-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_272
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_272`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_272` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_272`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','5','272','PURCHASES','','2022-06-02 11:45:50',5,0.00,0.00,'','877','2022-06-02 11:45:50','877',0,0),(2,7000,'',0,'20','5','272','SALES','','2022-06-02 11:46:28',5,0.00,0.00,'','877','2022-06-02 11:46:28','877',0,0),(3,8000,'',0,'24','5','272','SALARIES & WAGES','','2022-06-02 11:46:50',5,0.00,0.00,'','877','2022-06-02 11:46:50','877',0,0),(4,500,'',0,'6.1','5','272','CASH','','2022-06-02 11:47:15',5,0.00,0.00,'','877','2022-06-02 11:47:15','877',0,0),(5,8001,'',0,'24','5','272','PURCHASES','','2022-06-02 11:47:33',5,0.00,0.00,'','877','2022-06-02 11:47:33','877',0,0),(6,2500,'',0,'2','5','272','UBA-1019882661','','2022-06-02 11:50:29',5,0.00,0.00,'','877','2022-06-02 11:50:29','877',0,0),(7,2000,'',0,'6','5','272','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:25:52',5,0.00,0.00,'','600','2023-02-06 10:25:52','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','272','0000-00-00','2023-02-07 14:12:21',10,'1013','','0000-00-00 00:00:00','606','2023-02-09 15:49:56'),(2,'5','272','0000-00-00','2023-02-20 16:43:58',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','272','0000-00-00','2023-02-22 12:50:51',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','272','1','7','6',0.00,'Being PMS Price Increase of #35*400 LTRS on 20/1/2023',14000.00,'2023-02-07'),(3,'5','272','1','1','supplier',14000.00,'Being PMS Price Increase of #35*400 LTRS on 20/1/2023',0.00,'2023-02-07'),(4,'5','272','1','7','6',10500.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023',0.00,'2023-02-07'),(5,'5','272','1','1','supplier',0.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023',10500.00,'2023-02-07'),(6,'5','272','2','1','supplier',0.00,'Being PMS Price decrease of #10*3000 LTRS on 19/2/2023',3000.00,'2023-02-20'),(7,'5','272','2','7','6',3000.00,'Being PMS Price decrease of #10*3000 LTRS on 19/2/2023',0.00,'2023-02-20'),(8,'5','272','3','1','supplier',0.00,'Being AGO Price Decrease of #10 * 50 LTRS  On 20/02/2023',500.00,'2023-02-22'),(9,'5','272','3','7','6',500.00,'Being AGO Price Decrease of #10 * 50 LTRS  On 21/02/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','272',1,'2',22733.28,22900.00,'2022-07-10','','2022-07-10 17:39:47','600','600',2022,'600','2022-07-10 17:39:47',5),('5','272',2,'1',106.36,600.00,'2022-07-10','','2022-07-10 17:43:14','600','600',2022,'600','2022-07-10 17:43:14',5),('5','272',3,'1',4881.54,3400.00,'2022-07-19','','2022-07-19 10:40:29','600','600',2022,'600','2022-07-19 10:40:29',5),('5','272',4,'2',3310.94,4800.00,'2022-07-19','','2022-07-19 10:40:52','600','600',2022,'600','2022-07-19 10:40:52',5),('5','272',5,'1',3400.00,5600.00,'2022-07-19','','2022-07-19 12:12:42','600','600',2022,'600','2022-07-19 12:12:42',5),('5','272',6,'2',4800.00,2800.00,'2022-07-19','','2022-07-19 12:12:58','600','600',2022,'600','2022-07-19 12:12:58',5),('5','272',7,'1',23949.27,26150.00,'2022-09-08','','2022-09-08 14:38:07','600','600',2022,'600','2022-09-08 14:38:07',5),('5','272',8,'2',1419.13,14500.00,'2022-09-08','','2022-09-08 14:38:25','600','600',2022,'600','2022-09-08 14:38:25',5),('5','272',9,'2',7650.56,19450.00,'2022-09-08','','2022-09-08 14:54:42','600','600',2022,'600','2022-09-08 14:54:42',5),('5','272',10,'1',18083.93,6500.00,'2022-09-08','','2022-09-08 14:55:11','600','600',2022,'600','2022-09-08 14:55:11',5),('5','272',11,'1',1053.63,10000.00,'2022-09-08','','2022-09-08 15:15:08','600','600',2022,'600','2022-09-08 15:15:08',5),('5','272',12,'2',5743.02,5600.00,'2022-09-20','','2022-09-20 15:22:14','600','600',2022,'600','2022-09-20 15:22:14',5),('5','272',13,'1',8984.24,200.00,'2022-09-20','','2022-09-20 15:22:45','600','600',2022,'600','2022-09-20 15:22:45',5),('5','272',14,'2',91.79,14100.00,'2022-11-20','Available Dipping','2022-11-21 16:04:15','877','877',2022,'877','2022-11-21 16:04:15',5),('5','272',15,'1',14123.54,100.00,'2022-11-20','Available Stock','2022-11-21 16:05:22','877','877',2022,'877','2022-11-21 16:05:22',5),('5','272',16,'2',23557.36,23700.00,'2022-11-29','Available Stock','2022-11-30 07:21:49','877','877',2022,'877','2022-11-30 07:21:49',5),('5','272',17,'2',15392.63,15600.00,'2022-12-02','Available Stock','2022-12-03 08:15:43','877','877',2022,'877','2022-12-03 08:15:43',5),('5','272',18,'1',100.00,200.00,'2022-12-13','','2022-12-13 11:37:47','600','600',2022,'600','2022-12-13 11:37:47',5),('5','272',19,'2',8576.07,8950.00,'2022-12-13','','2022-12-13 11:38:15','600','600',2022,'600','2022-12-13 11:38:15',5),('5','272',20,'2',7515.17,7900.00,'2023-02-03','','2023-02-03 10:05:41','600','600',2023,'600','2023-02-03 10:05:41',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','272','1',1,'5','PUMP 1',320826.61,'PMS PUMP 1','',NULL,NULL,'',5,'2022-06-02 11:05:43','600'),('5','272','1',2,'5','PUMP 2',463638.36,'PMS PUMP 2','',NULL,NULL,'',5,'2022-06-02 11:08:25','600'),('5','272','2',3,'5','PUMP 3',652638.36,'PMS PUMP 3','',NULL,NULL,'',5,'2022-06-02 11:09:12','600'),('5','272','2',4,'5','PUMP 4',829236.21,'PMS PUMP 4','',NULL,NULL,'',5,'2022-06-02 11:10:09','600'),('5','272','3',5,'5','PUMP 5',12843.10,'AGO PUMP 5','',NULL,NULL,'',5,'2022-06-02 11:11:23','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','272',1,'DAILY','2022-06-01','2022-06-02 12:50:01','2022-06-03 12:50:01','877',821511.90,821511.90,'877','2022-06-02 12:54:07','664','2022-06-02 13:00:18',10,0),('5','272',2,'DAILY','2022-06-02','2022-06-02 21:25:38','2022-06-03 21:25:38','877',994747.05,994747.05,'877','2022-06-02 21:28:16','664','2022-06-02 21:31:40',10,0),('5','272',3,'DAILY','2022-06-03','2022-06-03 09:13:13','2022-06-04 09:13:13','877',546308.40,546308.40,'877','2022-06-03 21:56:51','664','2022-06-04 06:04:58',10,0),('5','272',4,'DAILY','2022-06-04','2022-06-04 06:36:57','2022-06-05 06:36:57','877',1368684.90,1368684.90,'877','2022-06-04 23:09:06','664','2022-06-05 06:05:56',10,0),('5','272',5,'DAILY','2022-06-05','2022-06-05 07:24:44','2022-06-06 07:24:44','877',447816.60,447816.60,'877','2022-06-05 23:32:43','664','2022-06-06 06:25:37',10,0),('5','272',6,'DAILY','2022-06-06','2022-06-06 10:47:07','2022-06-07 10:47:07','877',1450642.05,1450642.05,'877','2022-06-06 23:28:49','664','2022-06-07 07:25:13',10,0),('5','272',7,'DAILY','2022-06-07','2022-06-07 10:29:48','2022-06-08 10:29:48','877',1785816.45,1785816.45,'877','2022-06-07 20:29:09','664','2022-06-08 10:30:37',10,0),('5','272',8,'DAILY','2022-06-08','2022-06-08 14:18:45','2022-06-09 14:18:45','877',1604550.75,1604550.75,'877','2022-06-08 23:36:27','606','2022-06-09 23:02:10',10,0),('5','272',9,'DAILY','2022-06-09','2022-06-09 23:05:45','2022-06-10 23:05:45','877',1007541.15,1007541.15,'877','2022-06-09 23:07:27','664','2022-06-10 05:24:33',10,0),('5','272',10,'DAILY','2022-06-10','2022-06-10 08:46:34','2022-06-11 08:46:34','877',841712.85,841712.85,'877','2022-06-10 20:52:20','664','2022-06-10 21:42:03',10,0),('5','272',11,'DAILY','2022-06-11','2022-06-11 08:30:31','2022-06-12 08:30:31','877',577874.55,577874.55,'877','2022-06-11 23:02:45','664','2022-06-12 08:29:23',10,0),('5','272',12,'DAILY','2022-06-12','2022-06-12 21:43:23','2022-06-13 21:43:23','877',333351.15,333351.15,'877','2022-06-12 22:01:51','664','2022-06-13 06:53:19',10,0),('5','272',13,'DAILY','2022-06-13','2022-06-13 09:04:54','2022-06-14 09:04:54','877',349740.60,349740.60,'877','2022-06-13 20:18:20','664','2022-06-14 08:57:05',10,0),('5','272',14,'DAILY','2022-06-14','2022-06-14 11:24:27','2022-06-15 11:24:27','877',307885.05,307885.05,'877','2022-06-14 22:50:09','664','2022-06-15 07:35:46',10,0),('5','272',15,'DAILY','2022-06-15','2022-06-15 16:07:03','2022-06-16 16:07:03','877',508416.15,508416.15,'877','2022-06-15 21:44:00','664','2022-06-16 07:00:38',10,0),('5','272',16,'DAILY','2022-06-16','2022-06-16 14:47:25','2022-06-17 14:47:25','877',315230.85,315230.85,'877','2022-06-17 00:12:53','664','2022-06-17 05:58:56',10,0),('5','272',17,'DAILY','2022-06-17','2022-06-17 13:15:44','2022-06-18 13:15:44','877',371655.90,371655.90,'877','2022-06-17 23:03:44','664','2022-06-18 07:01:47',10,0),('5','272',18,'DAILY','2022-06-18','2022-06-18 08:17:34','2022-06-19 08:17:34','877',330001.65,330001.65,'877','2022-06-18 22:04:58','664','2022-06-18 22:46:10',10,0),('5','272',19,'DAILY','2022-06-19','2022-06-19 07:34:46','2022-06-20 07:34:46','877',267465.00,267465.00,'877','2022-06-19 21:19:30','664','2022-06-20 06:45:25',10,0),('5','272',20,'DAILY','2022-06-20','2022-06-20 08:48:31','2022-06-21 08:48:31','877',43256.40,43256.40,'877','2022-06-20 21:35:17','664','2022-06-21 07:53:30',10,0),('5','272',21,'DAILY','2022-06-21','2022-06-21 08:11:01','2022-06-22 08:11:01','877',0.00,0.00,'877','2022-06-21 19:29:29','664','2022-06-21 22:44:35',10,0),('5','272',22,'DAILY','2022-06-22','2022-06-22 08:03:21','2022-06-23 08:03:21','877',0.00,0.00,'877','2022-06-22 22:07:45','664','2022-06-23 07:05:00',10,0),('5','272',23,'DAILY','2022-06-23','2022-06-23 08:29:21','2022-06-24 08:29:21','877',0.00,0.00,'877','2022-06-23 23:48:20','664','2022-06-24 06:57:20',10,0),('5','272',24,'DAILY','2022-06-24','2022-06-24 07:39:03','2022-06-25 07:39:03','877',0.00,0.00,'877','2022-06-24 19:44:37','664','2022-06-25 06:12:44',10,0),('5','272',25,'DAILY','2022-06-25','2022-06-25 08:19:25','2022-06-26 08:19:25','877',0.00,0.00,'877','2022-06-25 20:22:37','664','2022-06-26 07:13:56',10,0),('5','272',26,'DAILY','2022-06-26','2022-06-26 13:38:51','2022-06-27 13:38:51','877',0.00,0.00,'877','2022-06-26 22:55:08','664','2022-06-27 07:34:11',10,0),('5','272',27,'DAILY','2022-06-27','2022-06-27 08:44:12','2022-06-28 08:44:12','877',0.00,0.00,'877','2022-06-27 19:32:44','664','2022-06-28 07:21:25',10,0),('5','272',28,'DAILY','2022-06-28','2022-06-28 07:27:11','2022-06-29 07:27:11','877',0.00,0.00,'877','2022-06-28 21:07:11','664','2022-06-29 08:00:50',10,0),('5','272',29,'DAILY','2022-06-29','2022-06-29 08:07:37','2022-06-30 08:07:37','877',0.00,0.00,'877','2022-06-29 18:54:03','664','2022-06-30 06:23:48',10,0),('5','272',30,'DAILY','2022-06-30','2022-06-30 07:45:05','2022-07-01 07:45:05','877',0.00,0.00,'877','2022-06-30 23:59:07','664','2022-07-01 07:08:49',10,0),('5','272',31,'DAILY','2022-07-01','2022-07-01 08:06:04','2022-07-02 08:06:04','877',0.00,0.00,'600','2022-07-02 14:29:55','600','2022-07-02 14:30:13',10,0),('5','272',32,'DAILY','2022-07-02','2022-07-03 01:36:13','2022-07-04 01:36:13','877',0.00,0.00,'877','2022-07-03 01:38:04','664','2022-07-03 06:29:00',10,0),('5','272',33,'DAILY','2022-07-03','2022-07-03 14:24:32','2022-07-04 14:24:32','877',0.00,0.00,'877','2022-07-04 00:23:21','664','2022-07-04 09:59:03',10,0),('5','272',34,'DAILY','2022-07-04','2022-07-04 10:27:07','2022-07-05 10:27:07','877',0.00,0.00,'877','2022-07-04 21:54:34','664','2022-07-04 22:34:22',10,0),('5','272',35,'DAILY','2022-07-05','2022-07-05 08:26:23','2022-07-06 08:26:23','877',0.00,0.00,'877','2022-07-05 23:06:00','664','2022-07-06 07:47:47',10,0),('5','272',36,'DAILY','2022-07-06','2022-07-06 09:38:38','2022-07-07 09:38:38','877',0.00,0.00,'877','2022-07-06 21:58:45','664','2022-07-07 05:23:57',10,0),('5','272',37,'DAILY','2022-07-07','2022-07-07 08:27:28','2022-07-08 08:27:28','877',176134.20,176134.20,'600','2022-07-10 17:44:45','600','2022-07-10 17:45:01',10,0),('5','272',38,'DAILY','2022-07-08','2022-07-11 08:13:29','2022-07-12 08:13:29','877',915990.90,915990.90,'877','2022-07-11 08:15:11','664','2022-07-11 08:18:12',10,0),('5','272',39,'DAILY','2022-07-09','2022-07-11 08:26:03','2022-07-12 08:26:03','877',377749.65,377749.65,'877','2022-07-11 08:30:55','664','2022-07-11 08:32:52',10,0),('5','272',40,'DAILY','2022-07-10','2022-07-11 08:40:25','2022-07-12 08:40:25','877',467075.05,467075.05,'877','2022-07-11 08:42:29','664','2022-07-11 08:44:16',10,0),('5','272',41,'DAILY','2022-07-11','2022-07-11 08:51:24','2022-07-12 08:51:24','877',790001.80,790001.80,'877','2022-07-11 21:22:42','664','2022-07-12 05:21:19',10,0),('5','272',42,'DAILY','2022-07-12','2022-07-12 08:15:41','2022-07-13 08:15:41','877',383353.30,383353.30,'877','2022-07-12 23:58:21','664','2022-07-13 07:16:58',10,0),('5','272',43,'DAILY','2022-07-13','2022-07-13 08:33:51','2022-07-14 08:33:51','877',455532.90,455532.90,'877','2022-07-14 00:05:50','664','2022-07-14 06:31:32',10,0),('5','272',44,'DAILY','2022-07-14','2022-07-14 08:16:08','2022-07-15 08:16:08','877',540126.00,540126.00,'877','2022-07-14 22:48:47','664','2022-07-15 07:15:57',10,0),('5','272',45,'DAILY','2022-07-15','2022-07-15 07:25:13','2022-07-16 07:25:13','877',2196965.65,2196965.65,'877','2022-07-15 21:08:46','664','2022-07-16 06:52:10',10,0),('5','272',46,'DAILY','2022-07-16','2022-07-16 07:16:18','2022-07-17 07:16:18','877',1904441.80,1904441.80,'877','2022-07-16 22:52:08','664','2022-07-17 05:28:12',10,0),('5','272',47,'DAILY','2022-07-17','2022-07-17 11:47:57','2022-07-18 11:47:57','877',1892141.15,1892141.15,'877','2022-07-18 00:05:17','664','2022-07-18 07:32:47',10,0),('5','272',48,'DAILY','2022-07-18','2022-07-18 08:36:32','2022-07-19 08:36:32','877',1532715.75,1532715.75,'600','2022-07-19 12:13:15','664','2022-07-19 12:16:04',10,0),('5','272',49,'DAILY','2022-07-18','2022-07-19 12:44:17','2022-07-20 12:44:17','877',2450857.80,2450857.80,'877','2022-07-20 12:40:24','664','2022-07-20 12:58:23',10,0),('5','272',50,'DAILY','2022-07-20','2022-07-20 13:01:56','2022-07-21 13:01:56','877',3044189.80,3044189.80,'877','2022-07-20 21:51:11','664','2022-07-21 06:47:33',10,0),('5','272',51,'DAILY','2022-07-21','2022-07-21 08:02:45','2022-07-22 08:02:45','877',2798726.25,2798726.25,'877','2022-07-21 18:14:20','664','2022-07-21 23:17:29',10,0),('5','272',52,'DAILY','2022-07-22','2022-07-22 08:39:22','2022-07-23 08:39:22','877',1258687.65,1258687.65,'877','2022-07-22 21:53:47','664','2022-07-23 06:53:17',10,0),('5','272',53,'DAILY','2022-07-23','2022-07-23 09:50:50','2022-07-24 09:50:50','877',1567769.55,1567769.55,'877','2022-07-24 07:36:45','664','2022-07-24 08:30:55',10,0),('5','272',54,'DAILY','2022-07-24','2022-07-24 09:33:34','2022-07-25 09:33:34','877',2660668.15,2660668.15,'877','2022-07-24 21:24:40','664','2022-07-25 06:43:31',10,0),('5','272',55,'DAILY','2022-07-25','2022-07-25 07:56:24','2022-07-26 07:56:24','877',1736422.95,1736422.95,'877','2022-07-25 21:57:47','664','2022-07-26 05:52:23',10,0),('5','272',56,'DAILY','2022-07-26','2022-07-26 08:38:03','2022-07-27 08:38:03','877',1506825.00,1506825.00,'877','2022-07-27 01:58:05','664','2022-07-27 06:03:09',10,0),('5','272',57,'DAILY','2022-07-27','2022-07-27 08:27:28','2022-07-28 08:27:28','877',334665.00,334665.00,'877','2022-07-27 22:10:37','664','2022-07-28 06:52:24',10,0),('5','272',58,'DAILY','2022-07-28','2022-07-28 08:48:45','2022-07-29 08:48:45','877',269476.55,269476.55,'877','2022-07-28 23:53:03','664','2022-07-29 07:11:00',10,0),('5','272',59,'DAILY','2022-07-29','2022-07-29 07:46:08','2022-07-30 07:46:08','877',312139.40,312139.40,'877','2022-07-30 01:54:15','664','2022-07-30 05:46:25',10,0),('5','272',60,'DAILY','2022-07-30','2022-07-30 10:00:45','2022-07-31 10:00:45','877',277625.80,277625.80,'877','2022-07-30 20:36:20','664','2022-07-31 05:21:53',10,0),('5','272',61,'DAILY','2022-07-31','2022-07-31 09:51:46','2022-08-01 09:51:46','877',285911.95,285911.95,'877','2022-07-31 22:29:47','664','2022-08-01 07:47:38',10,0),('5','272',62,'DAILY','2022-08-01','2022-08-01 09:30:14','2022-08-02 09:30:14','877',0.00,0.00,'877','2022-08-01 21:51:20','664','2022-08-02 05:36:18',10,0),('5','272',63,'DAILY','2022-08-02','2022-08-02 08:36:28','2022-08-03 08:36:28','877',706298.55,706298.55,'877','2022-08-02 23:26:05','664','2022-08-03 06:56:53',10,0),('5','272',64,'DAILY','2022-08-03','2022-08-03 11:10:25','2022-08-04 11:10:25','877',3717438.10,3717438.10,'877','2022-08-04 02:23:25','664','2022-08-04 06:13:20',10,0),('5','272',65,'DAILY','2022-08-04','2022-08-04 08:49:25','2022-08-05 08:49:25','877',410757.35,410757.35,'877','2022-08-05 00:40:15','664','2022-08-05 06:33:10',10,0),('5','272',66,'DAILY','2022-08-05','2022-08-05 08:12:53','2022-08-06 08:12:53','877',804269.00,804269.00,'877','2022-08-06 01:23:34','664','2022-08-06 06:59:22',10,0),('5','272',67,'DAILY','2022-08-06','2022-08-06 07:33:15','2022-08-07 07:33:15','877',1732883.90,1732883.90,'877','2022-08-07 01:22:08','664','2022-08-07 05:33:52',10,0),('5','272',68,'DAILY','2022-08-07','2022-08-07 09:48:16','2022-08-08 09:48:16','877',1467806.65,1467806.65,'877','2022-08-07 18:42:25','664','2022-09-05 06:47:20',10,0),('5','272',69,'DAILY','2022-09-06','2022-09-06 11:45:55','2022-09-07 11:45:55','877',2606132.00,2606132.00,'877','2022-09-06 11:47:41','664','2022-09-06 11:49:20',10,0),('5','272',70,'DAILY','2022-09-06','2022-09-06 11:52:55','2022-09-07 11:52:55','877',2236061.70,2236061.70,'877','2022-09-06 12:02:53','664','2022-09-06 12:04:28',10,0),('5','272',71,'DAILY','2022-08-10','2022-09-06 12:10:17','2022-09-07 12:10:17','877',2775599.40,2775599.40,'877','2022-09-06 12:22:49','664','2022-09-06 12:24:51',10,0),('5','272',72,'DAILY','2022-08-11','2022-09-06 12:28:50','2022-09-07 12:28:50','877',2783249.15,2783249.15,'877','2022-09-06 12:30:24','664','2022-09-06 12:31:21',10,0),('5','272',73,'DAILY','2022-08-12','2022-09-06 12:32:47','2022-09-07 12:32:47','877',2093075.20,2093075.20,'877','2022-09-06 12:34:15','664','2022-09-06 12:35:46',10,0),('5','272',74,'DAILY','2022-08-13','2022-09-06 12:44:34','2022-09-07 12:44:34','877',2525216.70,2525216.70,'877','2022-09-06 13:25:20','664','2022-09-06 13:26:53',10,0),('5','272',75,'DAILY','2022-08-14','2022-09-06 13:32:21','2022-09-07 13:32:21','877',2290697.75,2290697.75,'877','2022-09-06 13:46:47','664','2022-09-06 13:49:15',10,0),('5','272',76,'DAILY','2022-08-15','2022-09-06 13:59:37','2022-09-07 13:59:37','877',2181000.15,2181000.15,'877','2022-09-06 14:26:20','664','2022-09-06 14:27:58',10,0),('5','272',77,'DAILY','2022-08-16','2022-09-06 14:29:17','2022-09-07 14:29:17','877',1901679.75,1901679.75,'877','2022-09-06 14:30:45','664','2022-09-06 14:31:41',10,0),('5','272',78,'DAILY','2022-08-17','2022-09-06 14:33:33','2022-09-07 14:33:33','877',1900007.35,1900007.35,'877','2022-09-06 14:34:50','664','2022-09-06 14:36:42',10,0),('5','272',79,'DAILY','2022-08-18','2022-09-06 14:37:48','2022-09-07 14:37:48','877',2074776.85,2074776.85,'877','2022-09-06 14:39:09','664','2022-09-06 14:40:23',10,0),('5','272',80,'DAILY','2022-08-19','2022-09-06 14:43:10','2022-09-07 14:43:10','877',2539293.35,2539293.35,'877','2022-09-06 15:00:59','664','2022-09-06 15:13:05',10,0),('5','272',81,'DAILY','2022-08-20','2022-09-06 15:17:38','2022-09-07 15:17:38','877',2577087.00,2577087.00,'877','2022-09-06 15:34:42','664','2022-09-06 15:41:02',10,0),('5','272',82,'DAILY','2022-08-21','2022-09-06 15:45:53','2022-09-07 15:45:53','877',1610893.05,1610893.05,'877','2022-09-06 15:50:03','664','2022-09-06 16:03:53',10,0),('5','272',83,'DAILY','2022-09-06','2022-09-06 16:10:13','2022-09-07 16:10:13','877',1820927.25,1820927.25,'877','2022-09-08 12:29:27','664','2022-09-08 12:30:07',10,0),('5','272',84,'DAILY','2022-08-23','2022-09-08 12:30:58','2022-09-09 12:30:58','877',2119648.60,2119648.60,'877','2022-09-08 12:32:15','664','2022-09-08 12:33:01',10,0),('5','272',85,'DAILY','2022-08-24','2022-09-08 12:33:34','2022-09-09 12:33:34','877',2494478.95,2494478.95,'877','2022-09-08 12:40:43','664','2022-09-08 12:41:23',10,0),('5','272',86,'DAILY','2022-08-25','2022-09-08 12:50:36','2022-09-09 12:50:36','877',2301459.20,2301459.20,'877','2022-09-08 13:41:51','664','2022-09-08 13:45:58',10,0),('5','272',87,'DAILY','2022-08-26','2022-09-08 13:52:14','2022-09-09 13:52:14','877',2785865.05,2785865.05,'877','2022-09-08 13:53:46','664','2022-09-08 13:54:59',10,0),('5','272',88,'DAILY','2022-08-27','2022-09-08 13:56:00','2022-09-09 13:56:00','877',2457556.65,2457556.65,'877','2022-09-08 13:58:59','664','2022-09-08 13:59:55',10,0),('5','272',89,'DAILY','2022-08-28','2022-09-08 14:01:55','2022-09-09 14:01:55','877',2310450.20,2310450.20,'877','2022-09-08 14:20:41','664','2022-09-08 14:21:15',10,0),('5','272',90,'DAILY','2022-08-29','2022-09-08 14:22:00','2022-09-09 14:22:00','877',2759369.35,2759369.35,'877','2022-09-08 14:40:15','664','2022-09-08 14:41:50',10,0),('5','272',91,'DAILY','2022-08-30','2022-09-08 14:42:27','2022-09-09 14:42:27','877',2491071.25,2491071.25,'877','2022-09-08 14:54:53','664','2022-09-08 14:57:45',10,0),('5','272',92,'DAILY','2022-08-31','2022-09-08 14:58:21','2022-09-09 14:58:21','877',844991.20,844991.20,'877','2022-09-08 15:26:22','664','2022-09-08 15:28:44',10,0),('5','272',93,'DAILY','2022-09-01','2022-09-08 15:32:53','2022-09-09 15:32:53','877',448247.60,448247.60,'877','2022-09-08 15:43:26','664','2022-09-08 16:09:00',10,0),('5','272',94,'DAILY','2022-09-02','2022-09-08 16:11:42','2022-09-09 16:11:42','877',1009794.75,1009794.75,'877','2022-09-08 16:14:10','664','2022-09-08 16:15:06',10,0),('5','272',95,'DAILY','2022-09-03','2022-09-08 16:22:51','2022-09-09 16:22:51','877',2606986.70,2606986.70,'877','2022-09-08 16:34:02','664','2022-09-08 16:34:59',10,0),('5','272',96,'DAILY','2022-09-04','2022-09-08 16:39:29','2022-09-09 16:39:29','877',1970727.30,1970727.30,'877','2022-09-08 16:40:53','664','2022-09-08 16:41:43',10,0),('5','272',97,'DAILY','2022-09-05','2022-09-08 16:43:16','2022-09-09 16:43:16','877',2573466.55,2573466.55,'877','2022-09-08 16:44:30','664','2022-09-08 16:45:50',10,0),('5','272',98,'DAILY','2022-09-06','2022-09-08 16:51:00','2022-09-09 16:51:00','877',2602937.05,2602937.05,'877','2022-09-20 15:32:27','664','2022-09-20 15:35:34',10,0),('5','272',99,'DAILY','2022-09-07','2022-09-20 15:39:00','2022-09-21 15:39:00','877',2473457.40,2473457.40,'877','2022-09-20 15:42:04','664','2022-09-20 16:03:52',10,0),('5','272',100,'DAILY','2022-09-08','2022-09-22 17:52:27','2022-09-23 17:52:27','877',1809288.90,1809288.90,'877','2022-09-22 17:55:30','664','2022-09-22 17:58:49',10,0),('5','272',101,'DAILY','2022-09-09','2022-09-22 18:05:24','2022-09-23 18:05:24','877',691840.80,691840.80,'877','2022-09-22 18:06:41','664','2022-09-22 18:09:28',10,0),('5','272',102,'DAILY','2022-09-10','2022-09-22 18:11:08','2022-09-23 18:11:08','877',375747.95,375747.95,'877','2022-09-22 18:12:14','664','2022-09-22 18:13:27',10,0),('5','272',103,'DAILY','2022-09-11','2022-09-22 18:14:00','2022-09-23 18:14:00','877',314500.00,314500.00,'877','2022-09-22 18:14:43','664','2022-09-22 18:16:02',10,0),('5','272',104,'DAILY','2022-09-12','2022-09-22 18:22:29','2022-09-23 18:22:29','877',873077.90,873077.90,'877','2022-09-22 18:23:42','664','2022-09-22 18:23:56',10,0),('5','272',105,'DAILY','2022-09-13','2022-09-26 14:27:53','2022-09-27 14:27:53','877',1448087.50,1448087.50,'877','2022-09-26 15:26:28','664','2022-09-26 15:38:07',10,0),('5','272',106,'DAILY','2022-09-14','2022-09-26 15:40:42','2022-09-27 15:40:42','877',2528609.60,2528609.60,'877','2022-09-26 15:41:44','664','2022-09-26 15:42:36',10,0),('5','272',107,'DAILY','2022-09-15','2022-09-26 15:43:42','2022-09-27 15:43:42','877',1087761.15,1087761.15,'877','2022-09-26 15:44:58','664','2022-09-26 15:49:06',10,0),('5','272',108,'DAILY','2022-09-16','2022-09-26 16:04:01','2022-09-27 16:04:01','877',2793662.80,2793662.80,'877','2022-09-26 16:07:22','664','2022-09-26 16:09:11',10,0),('5','272',109,'DAILY','2022-09-17','2022-09-26 16:12:01','2022-09-27 16:12:01','877',2740558.55,2740558.55,'877','2022-09-26 16:13:54','664','2022-09-26 16:14:51',10,0),('5','272',110,'DAILY','2022-09-18','2022-09-26 16:15:44','2022-09-27 16:15:44','877',1681163.45,1681163.45,'877','2022-09-26 16:17:24','664','2022-09-26 16:18:03',10,0),('5','272',111,'DAILY','2022-09-19','2022-09-26 16:18:45','2022-09-27 16:18:45','877',1826247.85,1826247.85,'877','2022-09-26 16:20:18','664','2022-09-26 16:21:01',10,0),('5','272',112,'DAILY','2022-09-20','2022-09-26 16:26:12','2022-09-27 16:26:12','877',2143162.10,2143162.10,'877','2022-09-26 16:42:06','664','2022-09-26 16:42:53',10,0),('5','272',113,'DAILY','2022-09-21','2022-09-26 16:46:36','2022-09-27 16:46:36','877',2012800.00,2012800.00,'877','2022-09-26 16:48:18','664','2022-09-26 16:48:59',10,0),('5','272',114,'DAILY','2022-09-22','2022-09-26 16:49:58','2022-09-27 16:49:58','877',1856682.20,1856682.20,'877','2022-09-26 16:51:39','664','2022-09-26 17:08:09',10,0),('5','272',115,'DAILY','2022-09-23','2022-09-26 18:05:31','2022-09-27 18:05:31','877',2391507.95,2391507.95,'877','2022-09-26 18:07:17','664','2022-09-26 18:09:25',10,0),('5','272',116,'DAILY','2022-09-24','2022-09-26 18:14:42','2022-09-27 18:14:42','877',2380050.90,2380050.90,'877','2022-09-26 18:20:33','664','2022-09-26 18:21:48',10,0),('5','272',117,'DAILY','2022-09-25','2022-09-26 18:22:42','2022-09-27 18:22:42','877',1611253.80,1611253.80,'877','2022-09-26 18:24:09','664','2022-09-26 18:25:14',10,0),('5','272',118,'DAILY','2022-09-26','2022-09-26 18:29:54','2022-09-27 18:29:54','877',2426793.00,2426793.00,'877','2022-09-27 00:05:51','664','2022-09-27 09:44:05',10,0),('5','272',119,'DAILY','2022-09-27','2022-09-27 16:25:13','2022-09-28 16:25:13','877',1531367.10,1531367.10,'877','2022-09-27 21:48:57','664','2022-09-28 08:21:33',10,0),('5','272',120,'DAILY','2022-09-28','2022-09-28 12:28:16','2022-09-29 12:28:16','877',2515482.00,2515482.00,'877','2022-09-28 23:50:24','664','2022-09-29 08:33:21',10,0),('5','272',121,'DAILY','2022-09-29','2022-09-29 09:12:56','2022-09-30 09:12:56','877',2620913.50,2620913.50,'877','2022-09-29 23:11:03','664','2022-09-30 08:06:58',10,0),('5','272',122,'DAILY','2022-09-30','2022-09-30 09:53:44','2022-10-01 09:53:44','877',2435462.10,2435462.10,'877','2022-09-30 22:38:18','664','2022-10-01 08:57:05',10,0),('5','272',123,'DAILY','2022-10-01','2022-10-01 10:01:06','2022-10-02 10:01:06','877',2458032.10,2458032.10,'877','2022-10-04 11:32:06','664','2022-10-04 11:34:21',10,0),('5','272',124,'DAILY','2022-10-02','2022-10-04 11:36:38','2022-10-05 11:36:38','877',2060783.45,2060783.45,'877','2022-10-04 11:52:50','664','2022-10-04 11:57:32',10,0),('5','272',125,'DAILY','2022-10-04','2022-10-04 12:22:44','2022-10-05 12:22:44','877',1463764.40,1463764.40,'877','2022-10-04 13:09:29','664','2022-10-04 13:19:02',10,0),('5','272',126,'DAILY','2022-10-04','2022-10-04 13:29:40','2022-10-05 13:29:40','877',957861.55,957861.55,'877','2022-10-05 00:08:23','664','2022-10-05 09:36:31',10,0),('5','272',127,'DAILY','2022-10-05','2022-10-05 19:36:13','2022-10-06 19:36:13','877',422419.75,422419.75,'877','2022-10-05 20:46:41','664','2022-10-06 07:57:45',10,0),('5','272',128,'DAILY','2022-10-06','2022-10-06 11:53:00','2022-10-07 11:53:00','877',103503.80,103503.80,'877','2022-10-07 09:54:41','664','2022-10-07 10:18:47',10,0),('5','272',129,'DAILY','2022-10-07','2022-10-07 13:36:21','2022-10-08 13:36:21','877',335954.45,335954.45,'877','2022-10-07 20:25:23','664','2022-10-08 08:34:56',10,0),('5','272',130,'DAILY','2022-10-08','2022-10-08 11:58:13','2022-10-09 11:58:13','877',245472.80,245472.80,'877','2022-10-08 18:39:00','664','2022-10-09 08:30:28',10,0),('5','272',131,'DAILY','2022-10-09','2022-10-09 09:01:56','2022-10-10 09:01:56','877',0.00,0.00,'877','2022-10-09 21:47:49','664','2022-10-10 12:13:23',10,0),('5','272',132,'DAILY','2022-10-10','2022-10-10 14:16:26','2022-10-11 14:16:26','877',537334.35,537334.35,'877','2022-10-12 15:05:18','664','2022-10-12 15:06:30',10,0),('5','272',133,'DAILY','2022-10-11','2022-10-12 15:09:15','2022-10-13 15:09:15','877',3473304.70,3473304.70,'877','2022-10-12 22:05:24','664','2022-10-12 22:11:54',10,0),('5','272',134,'DAILY','2022-10-12','2022-10-12 22:35:30','2022-10-13 22:35:30','877',2698604.25,2698604.25,'877','2022-10-12 23:15:09','664','2022-10-13 05:39:41',10,0),('5','272',135,'DAILY','2022-10-13','2022-10-13 09:52:58','2022-10-14 09:52:58','877',2521810.85,2521810.85,'877','2022-10-13 23:14:46','664','2022-10-14 07:28:05',10,0),('5','272',136,'DAILY','2022-10-14','2022-10-14 10:19:22','2022-10-15 10:19:22','877',2804814.60,2804814.60,'877','2022-10-15 21:45:29','664','2022-10-15 22:26:01',10,0),('5','272',137,'DAILY','2022-10-15','2022-10-16 09:16:22','2022-10-17 09:16:22','877',2725035.20,2725035.20,'877','2022-10-16 09:19:39','664','2022-10-16 09:42:07',10,0),('5','272',138,'DAILY','2022-10-16','2022-10-16 20:41:39','2022-10-17 20:41:39','877',3304492.20,3304492.20,'877','2022-10-16 20:44:30','664','2022-10-17 07:34:55',10,0),('5','272',139,'DAILY','2022-10-17','2022-10-19 19:54:27','2022-10-20 19:54:27','877',2523094.75,2523094.75,'877','2022-10-19 19:55:54','664','2022-10-19 20:10:03',10,0),('5','272',140,'DAILY','2022-10-18','2022-10-19 20:14:46','2022-10-20 20:14:46','877',3456099.70,3456099.70,'877','2022-10-19 20:25:19','664','2022-10-19 20:26:43',10,0),('5','272',141,'DAILY','2022-10-19','2022-10-19 20:27:28','2022-10-20 20:27:28','877',2077969.95,2077969.95,'877','2022-10-19 21:28:24','664','2022-10-20 07:02:20',10,0),('5','272',142,'DAILY','2022-10-20','2022-10-20 15:12:40','2022-10-21 15:12:40','877',2178870.80,2178870.80,'877','2022-10-20 20:38:03','664','2022-10-21 07:40:04',10,0),('5','272',143,'DAILY','2022-10-21','2022-10-21 10:32:50','2022-10-22 10:32:50','877',1281145.35,1281145.35,'877','2022-10-21 21:39:58','664','2022-10-22 06:16:04',10,0),('5','272',144,'DAILY','2022-10-22','2022-10-22 09:22:23','2022-10-23 09:22:23','877',0.00,0.00,'877','2022-10-22 20:30:57','664','2022-10-23 21:34:11',10,0),('5','272',145,'DAILY','2022-10-23','2022-10-23 21:41:08','2022-10-24 21:41:08','877',0.00,0.00,'877','2022-10-23 21:41:50','664','2022-10-24 07:21:09',10,0),('5','272',146,'DAILY','2022-10-24','2022-10-24 09:05:59','2022-10-25 09:05:59','877',0.00,0.00,'877','2022-10-24 18:33:11','664','2022-10-25 07:21:25',10,0),('5','272',147,'DAILY','2022-10-25','2022-10-25 14:12:01','2022-10-26 14:12:01','877',0.00,0.00,'877','2022-10-26 20:08:36','664','2022-10-26 20:43:54',10,0),('5','272',148,'DAILY','2022-10-26','2022-10-27 11:00:50','2022-10-28 11:00:50','877',0.00,0.00,'877','2022-10-27 11:01:32','664','2022-10-27 11:03:21',10,0),('5','272',149,'DAILY','2022-10-27','2022-10-27 12:47:40','2022-10-28 12:47:40','877',0.00,0.00,'877','2022-10-27 19:42:10','664','2022-10-28 06:52:45',10,0),('5','272',150,'DAILY','2022-10-28','2022-10-28 15:44:59','2022-10-29 15:44:59','877',2236008.05,2236008.05,'877','2022-10-29 22:08:32','664','2022-10-30 06:33:39',10,0),('5','272',151,'DAILY','2022-10-29','2022-10-30 17:45:23','2022-10-31 17:45:23','877',2168864.15,2168864.15,'877','2022-10-30 17:46:19','664','2022-10-30 17:49:12',10,0),('5','272',152,'DAILY','2022-10-30','2022-10-30 22:11:04','2022-10-31 22:11:04','877',1228536.90,1228536.90,'877','2022-10-30 22:48:48','664','2022-10-31 06:45:00',10,0),('5','272',153,'DAILY','2022-10-31','2022-10-31 22:58:17','2022-11-01 22:58:17','877',1421310.60,1421310.60,'877','2022-10-31 22:59:25','664','2022-11-01 06:40:21',10,0),('5','272',154,'DAILY','2022-11-01','2022-11-01 09:49:13','2022-11-02 09:49:13','877',1297806.45,1297806.45,'877','2022-11-01 22:33:16','664','2022-11-02 08:22:06',10,0),('5','272',155,'DAILY','2022-11-02','2022-11-02 23:10:09','2022-11-03 23:10:09','877',0.00,0.00,'877','2022-11-02 23:10:33','664','2022-11-03 08:12:54',10,0),('5','272',156,'DAILY','2022-11-03','2022-11-03 23:19:06','2022-11-04 23:19:06','877',0.00,0.00,'877','2022-11-03 23:19:36','664','2022-11-04 07:32:00',10,0),('5','272',157,'DAILY','2022-11-04','2022-11-05 01:53:29','2022-11-06 01:53:29','877',0.00,0.00,'877','2022-11-05 01:54:03','664','2022-11-05 09:39:38',10,0),('5','272',158,'DAILY','2022-11-05','2022-11-13 09:22:36','2022-11-14 09:22:36','877',0.00,0.00,'877','2022-11-13 09:22:58','664','2022-11-13 09:50:42',10,0),('5','272',159,'DAILY','2022-11-06','2022-11-13 09:55:00','2022-11-14 09:55:00','877',0.00,0.00,'877','2022-11-13 09:55:29','664','2022-11-13 10:05:08',10,0),('5','272',160,'DAILY','2022-11-07','2022-11-13 21:55:44','2022-11-14 21:55:44','877',0.00,0.00,'877','2022-11-13 21:56:07','664','2022-11-13 21:58:04',10,0),('5','272',161,'DAILY','2022-11-08','2022-11-13 22:01:44','2022-11-14 22:01:44','877',0.00,0.00,'877','2022-11-13 22:02:07','664','2022-11-13 22:05:26',10,0),('5','272',162,'DAILY','2022-11-09','2022-11-13 22:13:13','2022-11-14 22:13:13','877',2818878.30,2818878.30,'877','2022-11-14 09:01:00','664','2022-11-14 09:09:51',10,0),('5','272',163,'DAILY','2022-11-10','2022-11-14 12:31:50','2022-11-15 12:31:50','877',2210596.45,2210596.45,'877','2022-11-14 12:35:44','664','2022-11-14 12:39:26',10,0),('5','272',164,'DAILY','2022-11-11','2022-11-14 12:43:11','2022-11-15 12:43:11','877',2271964.65,2271964.65,'877','2022-11-14 12:46:33','664','2022-11-14 13:28:04',10,0),('5','272',165,'DAILY SHIFT','2022-11-12','2022-11-15 07:10:11','2022-11-16 07:10:11','877',0.00,0.00,'877','2022-11-15 07:10:33','664','2022-11-15 07:43:58',10,0),('5','272',166,'DAILY SHIFT','2022-11-13','2022-11-15 17:04:54','2022-11-16 17:04:54','877',1044363.85,1044363.85,'877','2022-11-15 17:09:36','664','2022-11-16 07:34:22',10,0),('5','272',167,'DAILY SHIFT','2022-11-14','2022-11-16 08:30:17','2022-11-17 08:30:17','877',0.00,0.00,'877','2022-11-16 08:30:35','664','2022-11-17 08:11:41',10,0),('5','272',168,'DAILY SHIFT','2022-11-15','2022-11-17 09:27:25','2022-11-18 09:27:25','877',0.00,0.00,'877','2022-11-17 09:27:47','664','2022-11-17 10:03:18',10,0),('5','272',169,'DAILY SHIFT','2022-11-16','2022-11-17 10:50:59','2022-11-18 10:50:59','877',0.00,0.00,'877','2022-11-17 10:51:15','664','2022-11-17 10:52:48',10,0),('5','272',170,'DAILY SHIFT','2022-11-17','2022-11-17 10:54:26','2022-11-18 10:54:26','877',0.00,0.00,'877','2022-11-17 18:53:33','664','2022-11-18 07:33:00',10,0),('5','272',171,'DAILY SHIFT','2022-11-18','2022-11-18 09:11:45','2022-11-19 09:11:45','877',0.00,0.00,'877','2022-11-18 20:20:26','664','2022-11-19 08:28:44',10,0),('5','272',172,'DAILY SHIFT','2022-11-19','2022-11-19 08:32:38','2022-11-20 08:32:38','877',0.00,0.00,'877','2022-11-19 18:44:15','664','2022-11-20 09:37:04',10,0),('5','272',173,'DAILY SHIFT','2022-11-20','2022-11-21 13:45:22','2022-11-22 13:45:22','877',1385637.05,1385637.05,'877','2022-11-21 16:07:28','664','2022-11-21 16:16:58',10,0),('5','272',174,'DAILY SHIFT','2022-11-21','2022-11-21 16:26:34','2022-11-22 16:26:34','877',1200291.10,1200291.10,'877','2022-11-21 20:53:17','664','2022-11-22 09:21:52',10,0),('5','272',175,'DAILY SHIFT','2022-11-22','2022-11-22 13:50:40','2022-11-23 13:50:40','877',3777934.95,3777934.95,'877','2022-11-23 16:07:19','664','2022-11-23 16:29:35',10,0),('5','272',176,'DAILY SHIFT','2022-11-23','2022-11-23 16:43:41','2022-11-24 16:43:41','877',3560772.70,3560772.70,'877','2022-11-23 22:23:54','600','2022-11-24 13:07:15',10,0),('5','272',177,'DAILY SHIFT','2022-11-24','2022-11-24 14:12:58','2022-11-25 14:12:58','877',4133423.55,4133423.55,'877','2022-11-25 06:22:53','664','2022-11-25 08:32:36',10,0),('5','272',178,'DAILY SHIFT','2022-11-25','2022-11-25 21:24:04','2022-11-26 21:24:04','877',4157412.50,4157412.50,'877','2022-11-26 10:43:57','600','2022-11-26 11:47:08',10,0),('5','272',179,'DAILY SHIFT','2022-11-26','2022-11-27 19:44:46','2022-11-28 19:44:46','877',4209950.65,4209950.65,'877','2022-11-27 22:14:51','600','2022-11-28 06:14:23',10,0),('5','272',180,'DAILY SHIFT','2022-11-27','2022-11-28 06:39:01','2022-11-29 06:39:01','877',2986665.90,2986665.90,'877','2022-11-28 07:18:40','664','2022-11-28 07:52:19',10,0),('5','272',181,'DAILY SHIFT','2022-11-28','2022-11-28 09:24:59','2022-11-29 09:24:59','877',0.00,0.00,'877','2022-11-28 22:01:30','664','2022-11-29 08:10:11',10,0),('5','272',182,'DAILY SHIFT','2022-11-29','2022-11-30 07:18:11','2022-12-01 07:18:11','877',4376578.30,4376578.30,'877','2022-11-30 07:30:20','664','2022-11-30 07:34:02',10,0),('5','272',183,'DAILY SHIFT','2022-11-30','2022-11-30 08:41:38','2022-12-01 08:41:38','877',4139449.00,4139449.00,'877','2022-11-30 22:38:20','664','2022-12-01 07:45:14',10,0),('5','272',184,'DAILY SHIFT','2022-12-01','2022-12-01 12:23:43','2022-12-02 12:23:43','877',4546336.15,4546336.15,'877','2022-12-02 06:29:29','664','2022-12-02 07:11:34',10,0),('5','272',185,'DAILY SHIFT','2022-12-02','2022-12-02 08:07:55','2022-12-03 08:07:55','877',2883223.15,2883223.15,'877','2022-12-03 08:16:55','664','2022-12-03 08:23:14',10,0),('5','272',186,'DAILY SHIFT','2022-12-03','2022-12-03 10:39:01','2022-12-04 10:39:01','877',2767722.10,2767722.10,'877','2022-12-04 07:25:02','664','2022-12-04 09:15:55',10,0),('5','272',187,'DAILY SHIFT','2022-12-04','2022-12-04 21:49:16','2022-12-05 21:49:16','877',3667765.60,3667765.60,'877','2022-12-04 21:50:16','664','2022-12-05 07:35:58',10,0),('5','272',188,'DAILY SHIFT','2022-12-05','2022-12-06 06:36:13','2022-12-07 06:36:13','877',1354758.70,1354758.70,'877','2022-12-06 06:41:06','664','2022-12-06 07:57:36',10,0),('5','272',189,'DAILY SHIFT','2022-12-06','2022-12-06 14:08:43','2022-12-07 14:08:43','877',1725957.50,1725957.50,'877','2022-12-07 14:26:32','664','2022-12-07 15:04:48',10,0),('5','272',190,'DAILY SHIFT','2022-12-07','2022-12-07 15:06:32','2022-12-08 15:06:32','877',1611570.15,1611570.15,'877','2022-12-13 11:48:36','664','2022-12-13 11:50:49',10,0),('5','272',191,'DAILY SHIFT','2022-12-08','2022-12-13 11:56:00','2022-12-14 11:56:00','877',0.00,0.00,'877','2022-12-13 11:56:15','664','2022-12-13 12:02:05',10,0),('5','272',192,'DAILY SHIFT','2022-12-09','2022-12-13 12:04:04','2022-12-14 12:04:04','877',0.00,0.00,'877','2022-12-13 12:04:22','664','2022-12-13 12:10:52',10,0),('5','272',193,'DAILY SHIFT','2022-12-10','2022-12-13 12:11:48','2022-12-14 12:11:48','877',0.00,0.00,'877','2022-12-13 12:12:09','664','2022-12-13 12:13:12',10,0),('5','272',194,'DAILY SHIFT','2022-12-11','2022-12-13 12:14:42','2022-12-14 12:14:42','877',0.00,0.00,'877','2022-12-13 12:14:59','664','2022-12-13 12:15:50',10,0),('5','272',195,'DAILY SHIFT','2022-12-12','2022-12-13 12:16:57','2022-12-14 12:16:57','877',0.00,0.00,'877','2022-12-13 12:17:14','664','2022-12-13 12:18:39',10,0),('5','272',196,'DAILY SHIFT','2022-12-13','2022-12-13 12:34:34','2022-12-14 12:34:34','877',0.00,0.00,'877','2022-12-13 20:07:53','1013','2022-12-14 09:47:30',10,0),('5','272',197,'DAILY SHIFT','2022-12-14','2022-12-14 10:23:27','2022-12-15 10:23:27','877',0.00,0.00,'877','2022-12-14 17:22:44','664','2022-12-15 09:59:14',10,0),('5','272',198,'DAILY SHIFT','2022-12-15','2022-12-16 06:56:51','2022-12-17 06:56:51','877',0.00,0.00,'877','2022-12-16 06:57:07','664','2022-12-16 07:29:01',10,0),('5','272',199,'DAILY SHIFT','2022-12-16','2022-12-16 09:34:05','2022-12-17 09:34:05','877',0.00,0.00,'877','2022-12-16 23:00:53','664','2022-12-17 11:12:40',10,0),('5','272',200,'DAILY SHIFT','2022-12-17','2022-12-17 15:42:39','2022-12-18 15:42:39','877',0.00,0.00,'877','2022-12-17 17:54:58','1013','2022-12-18 10:40:45',10,0),('5','272',201,'DAILY SHIFT','2022-12-18','2022-12-18 11:14:24','2022-12-19 11:14:24','877',0.00,0.00,'877','2022-12-19 07:03:43','1013','2022-12-19 09:13:38',10,0),('5','272',202,'DAILY SHIFT','2022-12-19','2022-12-19 14:22:30','2022-12-20 14:22:30','877',0.00,0.00,'877','2022-12-19 21:25:00','1013','2022-12-20 09:36:02',10,0),('5','272',203,'DAILY SHIFT','2022-12-20','2022-12-20 13:39:02','2022-12-21 13:39:02','877',0.00,0.00,'877','2022-12-20 23:12:13','1013','2022-12-21 09:36:31',10,0),('5','272',204,'DAILY SHIFT','2022-12-21','2022-12-21 21:37:27','2022-12-22 21:37:27','877',0.00,0.00,'877','2022-12-21 21:37:44','1013','2022-12-22 09:03:49',10,0),('5','272',205,'DAILY SHIFT','2022-12-22','2022-12-22 20:52:05','2022-12-23 20:52:05','877',0.00,0.00,'877','2022-12-22 20:52:33','1013','2022-12-23 11:08:26',10,0),('5','272',206,'DAILY SHIFT','2022-12-23','2022-12-24 00:16:34','2022-12-25 00:16:34','877',0.00,0.00,'877','2022-12-24 00:16:55','1013','2022-12-24 12:04:15',10,0),('5','272',207,'DAILY SHIFT','2022-12-24','2022-12-24 19:56:06','2022-12-25 19:56:06','877',0.00,0.00,'877','2022-12-24 19:56:49','1013','2022-12-25 18:27:54',10,0),('5','272',208,'DAILY SHIFT','2022-12-25','2022-12-25 19:22:23','2022-12-26 19:22:23','877',0.00,0.00,'877','2022-12-25 19:22:41','1013','2022-12-26 21:06:58',10,0),('5','272',209,'DAILY SHIFT','2022-12-26','2022-12-27 19:18:19','2022-12-28 19:18:19','877',0.00,0.00,'877','2022-12-27 19:18:43','1013','2022-12-28 09:01:05',10,0),('5','272',210,'DAILY SHIFT','2022-12-27','2022-12-29 01:53:17','2022-12-30 01:53:17','877',0.00,0.00,'877','2022-12-29 01:53:39','1013','2022-12-29 07:55:42',10,0),('5','272',211,'DAILY SHIFT ','2022-12-28','2022-12-29 16:10:55','2022-12-30 16:10:55','877',0.00,0.00,'877','2022-12-29 16:11:10','1013','2022-12-30 08:11:16',10,0),('5','272',212,'DAILY SHIFT ','2022-12-29','2022-12-30 21:59:08','2022-12-31 21:59:08','877',0.00,0.00,'877','2022-12-30 21:59:33','1013','2022-12-30 22:20:41',10,0),('5','272',213,'DAILY SHIFT ','2022-12-30','2022-12-31 22:44:11','2023-01-01 22:44:11','877',0.00,0.00,'877','2022-12-31 22:44:44','1013','2023-01-01 11:30:26',10,0),('5','272',214,'DAILY SHIFT ','2022-12-31','2023-01-02 07:59:16','2023-01-03 07:59:16','877',0.00,0.00,'877','2023-01-02 07:59:33','1013','2023-01-02 10:38:06',10,0),('5','272',215,'DAILY SHIFT ','2023-01-01','2023-01-02 18:45:06','2023-01-03 18:45:06','877',0.00,0.00,'877','2023-01-02 18:45:31','1013','2023-01-02 21:58:47',10,0),('5','272',216,'DAILY SHIFT ','2023-01-02','2023-01-03 22:31:27','2023-01-04 22:31:27','877',0.00,0.00,'877','2023-01-03 22:32:01','1013','2023-01-04 09:44:52',10,0),('5','272',217,'DAILY SHIFT ','2023-01-03','2023-01-04 22:24:47','2023-01-05 22:24:47','877',0.00,0.00,'877','2023-01-04 22:25:10','1013','2023-01-05 09:09:33',10,0),('5','272',218,'DAILY SHIFT ','2023-01-04','2023-01-05 09:24:30','2023-01-06 09:24:30','877',0.00,0.00,'877','2023-01-05 09:25:04','1013','2023-01-06 09:11:16',10,0),('5','272',219,'DAILY SHIFT ','2023-01-05','2023-01-06 19:26:40','2023-01-07 19:26:40','877',0.00,0.00,'877','2023-01-06 19:27:07','1013','2023-01-06 21:52:02',10,0),('5','272',220,'DAILY SHIFT ','2023-01-06','2023-01-07 10:02:53','2023-01-08 10:02:53','877',0.00,0.00,'877','2023-01-07 10:03:10','1013','2023-01-07 11:06:30',10,0),('5','272',221,'DAILY SHIFT ','2023-01-07','2023-01-07 14:34:54','2023-01-08 14:34:54','877',0.00,0.00,'877','2023-01-07 16:33:32','1013','2023-01-07 20:17:33',10,0),('5','272',222,'DAILY SHIFT ','2023-01-08','2023-01-08 11:00:10','2023-01-09 11:00:10','877',0.00,0.00,'877','2023-01-08 15:11:01','1013','2023-01-08 17:12:29',10,0),('5','272',223,'DAILY SHIFT ','2023-01-09','2023-01-09 09:02:55','2023-01-10 09:02:55','877',0.00,0.00,'877','2023-01-09 19:54:05','1013','2023-01-10 09:12:29',10,0),('5','272',224,'DAILY SHIFT ','2023-01-10','2023-01-10 21:18:19','2023-01-11 21:18:19','877',0.00,0.00,'877','2023-01-10 21:18:35','1013','2023-01-10 22:21:34',10,0),('5','272',225,'DAILY SHIFT ','2023-01-11','2023-01-11 07:30:01','2023-01-12 07:30:01','877',0.00,0.00,'877','2023-01-11 22:26:00','1013','2023-01-12 09:24:11',10,0),('5','272',226,'DAILY SHIFT ','2023-01-12','2023-01-12 22:55:11','2023-01-13 22:55:11','877',0.00,0.00,'877','2023-01-12 22:56:32','1013','2023-01-13 09:29:01',10,0),('5','272',227,'DAILY SHIFT ','2023-01-13','2023-01-15 01:19:53','2023-01-16 01:19:53','877',1351180.80,1351180.80,'877','2023-01-15 22:42:11','1013','2023-01-15 22:50:46',10,0),('5','272',228,'DAILY SHIFT ','2023-01-14','2023-01-15 23:08:58','2023-01-16 23:08:58','877',1408553.00,1408553.00,'877','2023-01-15 23:09:49','1013','2023-01-16 09:33:42',10,0),('5','272',229,'DAILY SHIFT ','2023-01-15','2023-01-16 10:59:09','2023-01-17 10:59:09','877',2529591.95,2529591.95,'877','2023-01-16 11:00:42','1013','2023-01-16 11:03:23',10,0),('5','272',230,'DAILY SHIFT ','2023-01-16','2023-01-16 11:05:25','2023-01-17 11:05:25','877',2003217.00,2003217.00,'877','2023-01-16 21:14:18','1013','2023-01-17 09:40:04',10,0),('5','272',231,'DAILY SHIFT ','2023-01-17','2023-01-17 11:19:43','2023-01-18 11:19:43','877',1048424.60,1048424.60,'877','2023-01-17 20:56:45','1013','2023-01-18 09:13:05',10,0),('5','272',232,'DAILY SHIFT ','2023-01-18','2023-01-18 10:34:15','2023-01-19 10:34:15','877',0.00,0.00,'877','2023-01-18 13:50:38','1013','2023-01-19 07:22:16',10,0),('5','272',233,'DAILY SHIFT ','2023-01-19','2023-01-19 21:23:15','2023-01-20 21:23:15','877',0.00,0.00,'877','2023-01-19 21:23:34','1013','2023-01-20 08:55:19',10,0),('5','272',234,'DAILY SHIFT ','2023-01-20','2023-01-20 21:42:10','2023-01-21 21:42:10','877',0.00,0.00,'877','2023-01-20 21:42:25','1013','2023-01-21 08:19:48',10,0),('5','272',235,'DAILY SHIFT ','2023-01-21','2023-01-21 22:02:11','2023-01-22 22:02:11','877',449209.60,449209.60,'877','2023-01-22 20:27:03','1013','2023-01-22 20:54:09',10,0),('5','272',236,'DAILY SHIFT ','2023-01-22','2023-01-22 21:05:09','2023-01-23 21:05:09','877',1843351.40,1843351.40,'877','2023-01-22 21:07:04','1013','2023-01-23 10:12:02',10,0),('5','272',237,'DAILY SHIFT ','2023-01-23','2023-01-23 13:02:56','2023-01-24 13:02:56','877',946957.00,946957.00,'877','2023-01-24 01:30:23','1013','2023-01-24 11:27:26',10,0),('5','272',238,'DAILY SHIFT ','2023-01-24','2023-01-24 13:24:52','2023-01-25 13:24:52','877',1866792.40,1866792.40,'877','2023-01-24 22:06:27','1013','2023-01-25 09:34:15',10,0),('5','272',239,'DAILY SHIFT ','2023-01-25','2023-01-25 13:26:08','2023-01-26 13:26:08','877',1777738.60,1777738.60,'877','2023-01-26 10:00:16','1013','2023-01-26 10:09:37',10,0),('5','272',240,'DAILY SHIFT ','2023-01-26','2023-01-26 10:20:09','2023-01-27 10:20:09','877',1732203.00,1732203.00,'877','2023-01-26 21:56:09','1013','2023-01-27 10:02:00',10,0),('5','272',241,'DAILY SHIFT ','2023-01-27','2023-01-28 06:25:27','2023-01-29 06:25:27','877',1233674.20,1233674.20,'877','2023-01-28 06:28:34','1013','2023-01-28 10:05:05',10,0),('5','272',242,'DAILY SHIFT ','2023-01-28','2023-01-28 10:51:23','2023-01-29 10:51:23','877',0.00,0.00,'877','2023-01-28 21:00:45','1013','2023-01-29 10:01:06',10,0),('5','272',243,'DAILY SHIFT ','2023-01-29','2023-01-29 18:36:34','2023-01-30 18:36:34','877',0.00,0.00,'877','2023-01-29 18:36:56','1013','2023-01-30 09:51:44',10,0),('5','272',244,'DAILY SHIFT ','2023-01-30','2023-01-30 19:40:02','2023-01-31 19:40:02','877',0.00,0.00,'877','2023-01-30 19:40:19','1013','2023-01-31 08:37:25',10,0),('5','272',245,'DAILY SHIFT ','2023-01-31','2023-01-31 21:23:01','2023-02-01 21:23:01','877',608355.00,608355.00,'877','2023-02-01 22:21:47','1013','2023-02-02 09:50:56',10,0),('5','272',246,'DAILY SHIFT ','2023-02-01','2023-02-02 09:58:09','2023-02-03 09:58:09','877',1487945.80,1487945.80,'877','2023-02-02 10:00:05','1013','2023-02-02 10:01:46',10,0),('5','272',247,'DAILY SHIFT ','2023-02-02','2023-02-02 13:58:21','2023-02-03 13:58:21','877',1654008.40,1654008.40,'877','2023-02-03 10:45:35','1013','2023-02-03 11:02:49',10,0),('5','272',248,'DAILY SHIFT ','2023-02-03','2023-02-03 11:05:07','2023-02-04 11:05:07','877',0.00,0.00,'877','2023-02-03 22:30:31','1013','2023-02-04 13:00:58',10,0),('5','272',249,'DAILY SHIFT ','2023-02-04','2023-02-04 22:10:02','2023-02-05 22:10:02','877',0.00,0.00,'877','2023-02-04 22:10:20','1013','2023-02-05 16:22:01',10,0),('5','272',250,'DAILY SHIFT ','2023-02-05','2023-02-05 22:34:54','2023-02-06 22:34:54','877',0.00,0.00,'877','2023-02-05 22:35:09','1013','2023-02-06 09:18:52',10,0),('5','272',251,'DAILY SHIFT ','2023-02-06','2023-02-06 22:58:30','2023-02-07 22:58:30','877',393969.40,393969.40,'877','2023-02-07 15:28:44','1013','2023-02-07 15:31:48',10,0),('5','272',252,'DAILY SHIFT ','2023-02-07','2023-02-07 21:42:59','2023-02-08 21:42:59','877',1189370.60,1189370.60,'877','2023-02-07 22:36:47','1013','2023-02-08 09:37:40',10,0),('5','272',253,'DAILY SHIFT ','2023-02-08','2023-02-09 12:55:45','2023-02-10 12:55:45','877',449143.20,449143.20,'877','2023-02-09 12:56:35','1013','2023-02-09 13:41:38',10,0),('5','272',254,'DAILY SHIFT ','2023-02-09','2023-02-09 15:20:41','2023-02-10 15:20:41','877',0.00,0.00,'877','2023-02-10 22:37:42','1013','2023-02-11 13:10:20',10,0),('5','272',255,'DAILY SHIFT ','2023-02-10','2023-02-11 22:39:31','2023-02-12 22:39:31','877',0.00,0.00,'877','2023-02-11 22:39:48','1013','2023-02-12 12:49:48',10,0),('5','272',256,'DAILY SHIFT ','2023-02-11','2023-02-13 05:02:41','2023-02-14 05:02:41','877',0.00,0.00,'877','2023-02-13 05:04:35','1013','2023-02-13 09:23:05',10,0),('5','272',257,'DAILY SHIFT ','2023-02-12','2023-02-13 16:12:53','2023-02-14 16:12:53','877',449125.60,449125.60,'877','2023-02-13 16:48:25','1013','2023-02-13 16:51:24',10,0),('5','272',258,'DAILY SHIFT ','2023-02-13','2023-02-13 17:47:55','2023-02-14 17:47:55','877',804874.40,804874.40,'877','2023-02-13 22:01:59','1013','2023-02-14 11:27:51',10,0),('5','272',259,'DAILY SHIFT ','2023-02-14','2023-02-14 22:13:01','2023-02-15 22:13:01','877',0.00,0.00,'877','2023-02-14 22:13:25','1013','2023-02-15 13:23:00',10,0),('5','272',260,'DAILY SHIFT ','2023-02-15','2023-02-15 22:16:53','2023-02-16 22:16:53','877',0.00,0.00,'877','2023-02-15 22:17:11','1013','2023-02-16 09:33:07',10,0),('5','272',261,'DAILY SHIFT ','2023-02-16','2023-02-16 16:34:26','2023-02-17 16:34:26','877',0.00,0.00,'877','2023-02-16 16:34:38','1013','2023-02-17 09:19:57',10,0),('5','272',262,'DAILY SHIFT ','2023-02-17','2023-02-17 21:23:28','2023-02-18 21:23:28','877',0.00,0.00,'877','2023-02-17 21:24:06','1013','2023-02-18 21:00:32',10,0),('5','272',263,'DAILY SHIFT ','2023-02-18','2023-02-19 06:28:06','2023-02-20 06:28:06','877',0.00,0.00,'877','2023-02-19 06:28:21','1013','2023-02-19 19:21:50',10,0),('5','272',264,'DAILY SHIFT ','2023-02-19','2023-02-19 20:51:58','2023-02-20 20:51:58','877',0.00,0.00,'877','2023-02-19 20:52:15','1013','2023-02-20 09:30:06',10,0),('5','272',265,'DAILY SHIFT ','2023-02-20','2023-02-20 22:15:16','2023-02-21 22:15:16','877',0.00,0.00,'877','2023-02-20 22:15:38','1013','2023-02-21 09:31:20',10,0),('5','272',266,'DAILY SHIFT ','2023-02-22','2023-02-22 06:59:30','2023-02-23 06:59:30','877',0.00,0.00,'877','2023-02-22 07:00:05','1013','2023-02-22 10:30:08',10,0),('5','272',267,'DAILY SHIFT ','2023-02-23','2023-02-25 06:32:20','2023-02-26 06:32:20','877',2793153.30,2793153.30,'877','2023-02-25 13:42:37','1013','2023-02-25 21:21:05',10,0),('5','272',268,'DAILY SHIFT ','2023-02-24','2023-02-26 06:26:40','2023-02-27 06:26:40','877',3160382.40,3160382.40,'877','2023-02-26 06:31:07','1013','2023-02-26 10:00:51',10,0),('5','272',269,'DAILY SHIFT ','2023-02-25','2023-02-26 11:02:28','2023-02-27 11:02:28','877',0.00,0.00,'877','2023-02-26 11:02:46','1013','2023-02-27 08:39:38',10,0),('5','272',270,'DAILY SHIFT ','2023-02-26','2023-02-27 11:05:38','2023-02-28 11:05:38','877',3425251.20,3425251.20,'877','2023-02-28 06:34:41','1013','2023-02-28 09:22:46',10,0),('5','272',271,'DAILY SHIFT ','2023-02-27','2023-02-28 10:55:43','2023-03-01 10:55:43','877',2652734.70,2652734.70,'877','2023-02-28 10:57:54','1013','2023-02-28 14:11:04',10,0),('5','272',272,'DAILY SHIFT ','2023-02-28','2023-02-28 14:37:07','2023-03-01 14:37:07','877',3452979.60,3452979.60,'877','2023-03-01 10:24:34','1013','2023-03-02 08:54:23',10,0),('5','272',273,'DAILY SHIFT ','2023-03-01','2023-03-03 10:32:30','2023-03-04 10:32:30','877',1669245.90,1669245.90,'877','2023-03-03 10:34:00','1013','2023-03-03 11:32:46',10,0),('5','272',274,'DAILY SHIFT ','2023-03-02','2023-03-03 11:46:13','2023-03-04 11:46:13','877',2428068.30,2428068.30,'877','2023-03-03 11:48:26','1013','2023-03-03 14:16:11',10,0),('5','272',275,'DAILY SHIFT ','2023-03-03','2023-03-03 21:29:05','2023-03-04 21:29:05','877',1516315.50,1516315.50,'877','2023-03-05 07:34:58','1013','2023-03-05 08:31:13',10,0),('5','272',276,'DAILY SHIFT ','2023-03-04','2023-03-05 08:51:23','2023-03-06 08:51:23','877',1722294.00,1722294.00,'877','2023-03-05 08:52:33','1013','2023-03-05 18:23:59',10,0),('5','272',277,'DAILY SHIFT ','2023-03-05','2023-03-05 18:29:23','2023-03-06 18:29:23','877',680127.00,680127.00,'877','2023-03-05 18:30:37','1013','2023-03-06 08:50:18',10,0),('5','272',278,'DAILY SHIFT ','2023-03-06','2023-03-07 07:20:08','2023-03-08 07:20:08','877',333324.60,333324.60,'877','2023-03-07 07:21:24','1013','2023-03-07 09:16:18',10,0),('5','272',279,'DAILY SHIFT ','2023-03-07','2023-03-08 13:34:50','2023-03-09 13:34:50','877',2095226.70,2095226.70,'877','2023-03-08 13:37:26','1013','2023-03-08 14:05:25',10,0),('5','272',280,'DAILY SHIFT ','2023-03-08','2023-03-09 22:14:13','2023-03-10 22:14:13','877',2228763.60,2228763.60,'877','2023-03-09 22:15:56','1013','2023-03-10 09:50:06',10,0),('5','272',281,'DAILY SHIFT ','2023-03-09','2023-03-10 10:47:55','2023-03-11 10:47:55','877',1733455.50,1733455.50,'877','2023-03-10 10:48:46','1013','2023-03-10 11:30:05',10,0),('5','272',282,'DAILY SHIFT ','2023-03-10','2023-03-13 07:27:48','2023-03-14 07:27:48','877',2197085.10,2197085.10,'877','2023-03-13 07:29:07','1013','2023-03-13 09:29:17',10,0),('5','272',283,'DAILY SHIFT ','2023-03-11','2023-03-13 10:06:21','2023-03-14 10:06:21','877',0.00,0.00,'877','2023-03-13 10:06:37','1013','2023-03-14 11:43:39',10,0),('5','272',284,'DAILY SHIFT ','2023-03-12','2023-03-15 10:42:48','2023-03-16 10:42:48','877',0.00,0.00,'877','2023-03-15 10:43:03','1013','2023-03-15 11:02:59',10,0),('5','272',285,'DAILY SHIFT ','2023-03-15','2023-03-15 13:17:56','2023-03-16 13:17:56','877',0.00,0.00,'877','2023-03-15 13:20:20','1013','2023-03-16 16:39:38',10,0),('5','272',286,'DAILY SHIFT ','2023-03-16','2023-03-17 23:11:17','2023-03-18 23:11:17','877',0.00,0.00,'877','2023-03-17 23:11:58','1013','2023-03-19 21:25:24',10,0),('5','272',287,'DAILY SHIFT ','2023-03-17','2023-03-20 07:36:04','2023-03-21 07:36:04','877',0.00,0.00,'877','2023-03-20 07:36:46','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1436 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','272','1','1',1,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','1',2,'2','1',183539.78,185917.94,2378.16,392396.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','1',3,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','1',4,'4','1',152459.79,155060.49,2600.70,429115.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','1',5,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','2',6,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','2',7,'2','1',185917.94,191946.71,6028.77,994747.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','2',8,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','2',9,'4','1',155060.49,155060.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','2',10,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','3',11,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','3',12,'2','1',191946.71,191946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','3',13,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','3',14,'4','1',155060.49,158371.45,3310.96,546308.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','3',15,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','4',16,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','4',17,'2','1',191946.71,191946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','4',18,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','4',19,'4','1',158371.45,166666.51,8295.06,1368684.90,0.00,0.00,0.00,0.00,0.00),('5','272','3','4',20,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','5',21,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','5',22,'2','1',191946.71,191946.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','5',23,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','5',24,'4','1',166666.51,169380.55,2714.04,447816.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','5',25,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','6',26,'1','1',151407.92,151407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','6',27,'2','1',191946.71,194296.30,2349.59,387682.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','6',28,'3','1',32608.79,32608.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','6',29,'4','1',169380.55,175822.73,6442.18,1062959.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','6',30,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','7',31,'1','1',151407.92,151427.92,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','7',32,'2','1',194296.30,202018.90,7722.60,1274229.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','7',33,'3','1',32608.79,32628.79,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','7',34,'4','1',175822.73,178883.26,3060.53,504987.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','7',35,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','8',36,'1','1',151427.92,151427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','8',37,'2','1',202018.90,202018.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','8',38,'3','1',32628.79,37880.47,5251.68,866527.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','8',39,'4','1',178883.26,183356.13,4472.87,738023.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','8',40,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','9',41,'1','1',151427.92,151427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','9',42,'2','1',202018.90,202018.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','9',43,'3','1',37880.47,40891.49,3011.02,496818.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','9',44,'4','1',183356.13,186451.42,3095.29,510722.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','9',45,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','10',46,'1','1',151427.92,151427.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','10',47,'2','1',202018.90,207120.19,5101.29,841712.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','10',48,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','10',49,'4','1',186451.42,186451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','10',50,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','11',51,'1','1',151427.92,154930.19,3502.27,577874.55,0.00,0.00,0.00,0.00,0.00),('5','272','1','11',52,'2','1',207120.19,207120.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','11',53,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','11',54,'4','1',186451.42,186451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','11',55,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','12',56,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','12',57,'2','1',207120.19,209140.50,2020.31,333351.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','12',58,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','12',59,'4','1',186451.42,186451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','12',60,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','13',61,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','13',62,'2','1',209140.50,211260.14,2119.64,349740.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','13',63,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','13',64,'4','1',186451.42,186451.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','13',65,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','14',66,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','14',67,'2','1',211260.14,212315.22,1055.08,174088.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','14',68,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','14',69,'4','1',186451.42,187262.31,810.89,133796.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','14',70,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','15',71,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','15',72,'2','1',212315.22,215396.53,3081.31,508416.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','15',73,'3','1',40891.49,40891.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','15',74,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','15',75,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','16',76,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','16',77,'2','1',215396.53,215396.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','16',78,'3','1',40891.49,42801.98,1910.49,315230.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','16',79,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','16',80,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','17',81,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','17',82,'2','1',215396.53,217648.99,2252.46,371655.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','17',83,'3','1',42801.98,42801.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','17',84,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','17',85,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','18',86,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','18',87,'2','1',217648.99,217648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','18',88,'3','1',42801.98,44801.99,2000.01,330001.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','18',89,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','18',90,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','19',91,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','19',92,'2','1',217648.99,217648.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','19',93,'3','1',44801.99,46422.99,1621.00,267465.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','19',94,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','19',95,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','20',96,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','20',97,'2','1',217648.99,217911.15,262.16,43256.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','20',98,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','20',99,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','20',100,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','21',101,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','21',102,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','21',103,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','21',104,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','21',105,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','22',106,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','22',107,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','22',108,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','22',109,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','22',110,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','23',111,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','23',112,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','23',113,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','23',114,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','23',115,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','24',116,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','24',117,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','24',118,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','24',119,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','24',120,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','25',121,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','25',122,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','25',123,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','25',124,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','25',125,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','26',126,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','26',127,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','26',128,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','26',129,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','26',130,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','27',131,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','27',132,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','27',133,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','27',134,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','27',135,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','28',136,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','28',137,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','28',138,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','28',139,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','28',140,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','29',141,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','29',142,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','29',143,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','29',144,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','29',145,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','30',146,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','30',147,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','30',148,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','30',149,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','30',150,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','31',151,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','31',152,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','31',153,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','31',154,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','31',155,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','32',156,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','32',157,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','32',158,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','32',159,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','32',160,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','33',161,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','33',162,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','33',163,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','33',164,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','33',165,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','34',166,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','34',167,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','34',168,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','34',169,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','34',170,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','35',171,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','35',172,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','35',173,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','35',174,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','35',175,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','36',176,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','36',177,'2','1',217911.15,217911.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','36',178,'3','1',46422.99,46422.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','36',179,'4','1',187262.31,187262.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','36',180,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','37',181,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','37',182,'2','1',217911.15,218374.25,463.10,76411.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','37',183,'3','1',46422.99,46884.87,461.88,76210.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','37',184,'4','1',187262.31,187404.81,142.50,23512.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','37',185,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','38',186,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','38',187,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','38',188,'3','1',46884.87,48997.02,2112.15,348504.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','38',189,'4','1',187404.81,190844.12,3439.31,567486.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','38',190,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','39',191,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','39',192,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','39',193,'3','1',48997.02,50338.91,1341.89,248249.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','39',194,'4','1',190844.12,191544.12,700.00,129500.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','39',195,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','40',196,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','40',197,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','40',198,'3','1',50338.91,52863.64,2524.73,467075.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','40',199,'4','1',191544.12,191544.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','40',200,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','41',201,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','41',202,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','41',203,'3','1',52863.64,54779.36,1915.72,354408.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','41',204,'4','1',191544.12,193898.68,2354.56,435593.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','41',205,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','42',206,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','42',207,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','42',208,'3','1',54779.36,56851.54,2072.18,383353.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','42',209,'4','1',193898.68,193898.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','42',210,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','43',211,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','43',212,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','43',213,'3','1',56851.54,59313.88,2462.34,455532.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','43',214,'4','1',193898.68,193898.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','43',215,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','44',216,'1','1',154930.19,154930.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','44',217,'2','1',218374.25,218374.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','44',218,'3','1',59313.88,59313.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','44',219,'4','1',193898.68,196818.28,2919.60,540126.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','44',220,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','45',221,'1','1',154930.19,157577.74,2647.55,489796.75,0.00,0.00,0.00,0.00,0.00),('5','272','1','45',222,'2','1',218374.25,221944.18,3569.93,660437.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','45',223,'3','1',59313.88,64536.76,5222.88,966232.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','45',224,'4','1',196818.28,197253.41,435.13,80499.05,0.00,0.00,0.00,0.00,0.00),('5','272','3','45',225,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','46',226,'1','1',157577.74,161160.17,3582.43,662749.55,0.00,0.00,0.00,0.00,0.00),('5','272','1','46',227,'2','1',221944.18,225171.84,3227.66,597117.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','46',228,'3','1',64536.76,68020.95,3484.19,644575.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','46',229,'4','1',197253.41,197253.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','46',230,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','47',231,'1','1',161160.17,164857.95,3697.78,684089.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','47',232,'2','1',225171.84,229701.85,4530.01,838051.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','47',233,'3','1',68020.95,68020.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','47',234,'4','1',197253.41,199253.41,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','47',235,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','48',236,'1','1',164857.95,167623.49,2765.54,511624.90,0.00,0.00,0.00,0.00,0.00),('5','272','1','48',237,'2','1',229701.85,232487.85,2786.00,515410.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','48',238,'3','1',68020.95,69152.98,1132.03,209425.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','48',239,'4','1',199253.41,200854.79,1601.38,296255.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','48',240,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','49',241,'1','1',167623.49,172037.97,4414.48,816678.80,0.00,0.00,0.00,0.00,0.00),('5','272','1','49',242,'2','1',232487.85,235365.52,2877.67,532368.95,0.00,0.00,0.00,0.00,0.00),('5','272','2','49',243,'3','1',69152.98,72659.30,3506.32,648669.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','49',244,'4','1',200854.79,203304.20,2449.41,453140.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','49',245,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','50',246,'1','1',172037.97,177747.40,5709.43,1056244.55,0.00,0.00,0.00,0.00,0.00),('5','272','1','50',247,'2','1',235365.52,238783.96,3418.44,632411.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','50',248,'3','1',72659.30,75829.15,3169.85,586422.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','50',249,'4','1',203304.20,207461.56,4157.36,769111.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','50',250,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','51',251,'1','1',177747.40,181888.76,4141.36,766151.60,0.00,0.00,0.00,0.00,0.00),('5','272','1','51',252,'2','1',238783.96,242676.20,3892.24,720064.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','51',253,'3','1',75829.15,79753.78,3924.63,726056.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','51',254,'4','1',207461.56,210631.58,3170.02,586453.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','51',255,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','52',256,'1','1',181888.76,183450.36,1561.60,288896.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','52',257,'2','1',242676.20,245386.09,2709.89,501329.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','52',258,'3','1',79753.78,81338.53,1584.75,293178.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','52',259,'4','1',210631.58,211579.06,947.48,175283.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','52',260,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','53',261,'1','1',183450.36,184057.16,606.80,112258.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','53',262,'2','1',245386.09,246086.81,700.72,129633.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','53',263,'3','1',81338.53,85067.61,3729.08,689879.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','53',264,'4','1',211579.06,215016.89,3437.83,635998.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','53',265,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','54',266,'1','1',184057.16,187880.56,3823.40,707329.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','54',267,'2','1',246086.81,250612.61,4525.80,837273.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','54',268,'3','1',85067.61,86461.20,1393.59,257814.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','54',269,'4','1',215016.89,219656.09,4639.20,858252.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','54',270,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','55',271,'1','1',187880.56,189963.27,2082.71,385301.35,0.00,0.00,0.00,0.00,0.00),('5','272','1','55',272,'2','1',250612.61,253022.13,2409.52,445761.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','55',273,'3','1',86461.20,86517.32,56.12,10382.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','55',274,'4','1',219656.09,224493.81,4837.72,894978.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','55',275,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','56',276,'1','1',189963.27,191963.27,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','56',277,'2','1',253022.13,259167.13,6145.00,1136825.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','56',278,'3','1',86517.32,86517.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','56',279,'4','1',224493.81,224493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','56',280,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','57',281,'1','1',191963.27,193772.27,1809.00,334665.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','57',282,'2','1',259167.13,259167.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','57',283,'3','1',86517.32,86517.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','57',284,'4','1',224493.81,224493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','57',285,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','58',286,'1','1',193772.27,193772.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','58',287,'2','1',259167.13,260623.76,1456.63,269476.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','58',288,'3','1',86517.32,86517.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','58',289,'4','1',224493.81,224493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','58',290,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','59',291,'1','1',193772.27,195459.51,1687.24,312139.40,0.00,0.00,0.00,0.00,0.00),('5','272','1','59',292,'2','1',260623.76,260623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','59',293,'3','1',86517.32,86517.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','59',294,'4','1',224493.81,224493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','59',295,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','60',296,'1','1',195459.51,195459.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','60',297,'2','1',260623.76,260623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','60',298,'3','1',86517.32,88018.00,1500.68,277625.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','60',299,'4','1',224493.81,224493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','60',300,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','61',301,'1','1',195459.51,196559.51,1100.00,203500.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','61',302,'2','1',260623.76,260623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','61',303,'3','1',88018.00,88018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','61',304,'4','1',224493.81,224939.28,445.47,82411.95,0.00,0.00,0.00,0.00,0.00),('5','272','3','61',305,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','62',306,'1','1',196559.51,196559.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','62',307,'2','1',260623.76,260623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','62',308,'3','1',88018.00,88018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','62',309,'4','1',224939.28,224939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','62',310,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','63',311,'1','1',196559.51,196559.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','63',312,'2','1',260623.76,260623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','63',313,'3','1',88018.00,88018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','63',314,'4','1',224939.28,228757.11,3817.83,706298.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','63',315,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','64',316,'1','1',196559.51,201861.76,5302.25,980916.25,0.00,0.00,0.00,0.00,0.00),('5','272','1','64',317,'2','1',260623.76,264781.44,4157.68,769170.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','64',318,'3','1',88018.00,91446.50,3428.50,634272.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','64',319,'4','1',228757.11,235962.94,7205.83,1333078.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','64',320,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','65',321,'1','1',201861.76,202377.76,516.00,95460.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','65',322,'2','1',264781.44,265739.39,957.95,177220.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','65',323,'3','1',91446.50,91446.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','65',324,'4','1',235962.94,236709.30,746.36,138076.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','65',325,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','66',326,'1','1',202377.76,203672.32,1294.56,239493.60,0.00,0.00,0.00,0.00,0.00),('5','272','1','66',327,'2','1',265739.39,267369.48,1630.09,301566.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','66',328,'3','1',91446.50,91446.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','66',329,'4','1',236709.30,238132.05,1422.75,263208.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','66',330,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','67',331,'1','1',203672.32,206285.28,2612.96,483397.60,0.00,0.00,0.00,0.00,0.00),('5','272','1','67',332,'2','1',267369.48,270658.63,3289.15,608492.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','67',333,'3','1',91446.50,91446.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','67',334,'4','1',238132.05,241596.88,3464.83,640993.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','67',335,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','68',336,'1','1',206285.28,208508.85,2223.57,411360.45,0.00,0.00,0.00,0.00,0.00),('5','272','1','68',337,'2','1',270658.63,273703.15,3044.52,563236.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','68',338,'3','1',91446.50,91446.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','68',339,'4','1',241596.88,244262.88,2666.00,493210.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','68',340,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','69',341,'1','1',208508.85,212092.63,3583.78,662999.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','69',342,'2','1',273703.15,278835.00,5131.85,949392.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','69',343,'3','1',91446.50,91446.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','69',344,'4','1',244262.88,249634.45,5371.57,993740.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','69',345,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','70',346,'1','1',212092.63,215206.86,3114.23,576132.55,0.00,0.00,0.00,0.00,0.00),('5','272','1','70',347,'2','1',278835.00,281724.35,2889.35,534529.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','70',348,'3','1',91446.50,93107.24,1660.74,307236.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','70',349,'4','1',249634.45,254056.95,4422.50,818162.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','70',350,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','71',351,'1','1',215206.86,217195.31,1988.45,367863.25,0.00,0.00,0.00,0.00,0.00),('5','272','1','71',352,'2','1',281724.35,288728.92,7004.57,1295845.45,0.00,0.00,0.00,0.00,0.00),('5','272','2','71',353,'3','1',93107.24,94036.91,929.67,171988.95,0.00,0.00,0.00,0.00,0.00),('5','272','2','71',354,'4','1',254056.95,259137.50,5080.55,939901.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','71',355,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','72',356,'1','1',217195.31,219306.80,2111.49,390625.65,0.00,0.00,0.00,0.00,0.00),('5','272','1','72',357,'2','1',288728.92,295208.01,6479.09,1198631.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','72',358,'3','1',94036.91,96236.77,2199.86,406974.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','72',359,'4','1',259137.50,263391.65,4254.15,787017.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','72',360,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','73',361,'1','1',219306.80,223217.46,3910.66,723472.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','73',362,'2','1',295208.01,299882.06,4674.05,864699.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','73',363,'3','1',96236.77,96236.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','73',364,'4','1',263391.65,266120.86,2729.21,504903.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','73',365,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','74',366,'1','1',223217.46,226557.34,3339.88,617877.80,0.00,0.00,0.00,0.00,0.00),('5','272','1','74',367,'2','1',299882.06,305492.48,5610.42,1037927.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','74',368,'3','1',96236.77,97912.68,1675.91,310043.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','74',369,'4','1',266120.86,269144.47,3023.61,559367.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','74',370,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','75',371,'1','1',226557.34,230532.05,3974.71,735321.35,0.00,0.00,0.00,0.00,0.00),('5','272','1','75',372,'2','1',305492.48,308564.75,3072.27,568369.95,0.00,0.00,0.00,0.00,0.00),('5','272','2','75',373,'3','1',97912.68,103034.09,5121.41,947460.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','75',374,'4','1',269144.47,269358.23,213.76,39545.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','75',375,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','76',376,'1','1',230532.05,234117.51,3585.46,663310.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','76',377,'2','1',308564.75,313548.33,4983.58,921962.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','76',378,'3','1',103034.09,105947.80,2913.71,539036.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','76',379,'4','1',269358.23,269664.67,306.44,56691.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','76',380,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','77',381,'1','1',234117.51,237223.38,3105.87,574585.95,0.00,0.00,0.00,0.00,0.00),('5','272','1','77',382,'2','1',313548.33,316904.13,3355.80,620823.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','77',383,'3','1',105947.80,108335.05,2387.25,441641.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','77',384,'4','1',269664.67,271095.10,1430.43,264629.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','77',385,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','78',386,'1','1',237223.38,240193.77,2970.39,549522.15,0.00,0.00,0.00,0.00,0.00),('5','272','1','78',387,'2','1',316904.13,320498.20,3594.07,664902.95,0.00,0.00,0.00,0.00,0.00),('5','272','2','78',388,'3','1',108335.05,112040.90,3705.85,685582.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','78',389,'4','1',271095.10,271095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','78',390,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','79',391,'1','1',240193.77,243496.19,3302.42,610947.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','79',392,'2','1',320498.20,324343.06,3844.86,711299.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','79',393,'3','1',112040.90,113691.84,1650.94,305423.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','79',394,'4','1',271095.10,273511.89,2416.79,447106.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','79',395,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','80',396,'1','1',243496.19,244598.01,1101.82,203836.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','80',397,'2','1',324343.06,325423.66,1080.60,199911.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','80',398,'3','1',113691.84,118968.02,5276.18,976093.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','80',399,'4','1',273511.89,279779.20,6267.31,1159452.35,0.00,0.00,0.00,0.00,0.00),('5','272','3','80',400,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','81',401,'1','1',244598.01,246524.81,1926.80,356458.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','81',402,'2','1',325423.66,331601.75,6178.09,1142946.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','81',403,'3','1',118968.02,123913.40,4945.38,914895.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','81',404,'4','1',279779.20,280659.13,879.93,162787.05,0.00,0.00,0.00,0.00,0.00),('5','272','3','81',405,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','82',406,'1','1',246524.81,248841.32,2316.51,428554.35,0.00,0.00,0.00,0.00,0.00),('5','272','1','82',407,'2','1',331601.75,334005.99,2404.24,444784.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','82',408,'3','1',123913.40,126224.20,2310.80,427498.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','82',409,'4','1',280659.13,282335.11,1675.98,310056.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','82',410,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','83',411,'1','1',248841.32,251664.14,2822.82,522221.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','83',412,'2','1',334005.99,337618.93,3612.94,668393.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','83',413,'3','1',126224.20,127795.72,1571.52,290731.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','83',414,'4','1',282335.11,284170.68,1835.57,339580.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','83',415,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','84',416,'1','1',251664.14,254687.54,3023.40,559329.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','84',417,'2','1',337618.93,341378.75,3759.82,695566.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','84',418,'3','1',127795.72,130516.74,2721.02,503388.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','84',419,'4','1',284170.68,286124.00,1953.32,361364.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','84',420,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','85',421,'1','1',254687.54,255799.69,1112.15,205747.75,0.00,0.00,0.00,0.00,0.00),('5','272','1','85',422,'2','1',341378.75,344165.75,2787.00,515595.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','85',423,'3','1',130516.74,135218.34,4701.60,869796.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','85',424,'4','1',286124.00,291006.92,4882.92,903340.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','85',425,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','86',426,'1','1',255799.69,258394.35,2594.66,480012.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','86',427,'2','1',344165.75,348440.34,4274.59,790799.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','86',428,'3','1',135218.34,136798.97,1580.63,292416.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','86',429,'4','1',291006.92,294997.36,3990.44,738231.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','86',430,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','87',431,'1','1',258394.35,260547.76,2153.41,398380.85,0.00,0.00,0.00,0.00,0.00),('5','272','1','87',432,'2','1',348440.34,354430.78,5990.44,1108231.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','87',433,'3','1',136798.97,139150.35,2351.38,435005.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','87',434,'4','1',294997.36,299560.86,4563.50,844247.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','87',435,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','88',436,'1','1',260547.76,260547.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','88',437,'2','1',354430.78,359407.96,4977.18,920778.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','88',438,'3','1',139150.35,143764.27,4613.92,853575.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','88',439,'4','1',299560.86,303253.85,3692.99,683203.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','88',440,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','89',441,'1','1',260547.76,261953.98,1406.22,260150.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','89',442,'2','1',359407.96,364986.55,5578.59,1032039.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','89',443,'3','1',143764.27,146955.38,3191.11,590355.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','89',444,'4','1',303253.85,305566.85,2313.00,427905.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','89',445,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','90',446,'1','1',261953.98,266537.67,4583.69,847982.65,0.00,0.00,0.00,0.00,0.00),('5','272','1','90',447,'2','1',364986.55,368468.93,3482.38,644240.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','90',448,'3','1',146955.38,151147.81,4192.43,775599.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','90',449,'4','1',305566.85,308223.86,2657.01,491546.85,0.00,0.00,0.00,0.00,0.00),('5','272','3','90',450,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','91',451,'1','1',266537.67,266537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','91',452,'2','1',368468.93,373915.30,5446.37,1007578.45,0.00,0.00,0.00,0.00,0.00),('5','272','2','91',453,'3','1',151147.81,155380.80,4232.99,783103.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','91',454,'4','1',308223.86,312009.75,3785.89,700389.65,0.00,0.00,0.00,0.00,0.00),('5','272','3','91',455,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','92',456,'1','1',266537.67,266537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','92',457,'2','1',373915.30,375077.47,1162.17,215001.45,0.00,0.00,0.00,0.00,0.00),('5','272','2','92',458,'3','1',155380.80,156933.61,1552.81,287269.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','92',459,'4','1',312009.75,313862.29,1852.54,342719.90,0.00,0.00,0.00,0.00,0.00),('5','272','3','92',460,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','93',461,'1','1',266537.67,266537.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','93',462,'2','1',375077.47,375077.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','93',463,'3','1',156933.61,158030.14,1096.53,202858.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','93',464,'4','1',313862.29,315188.72,1326.43,245389.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','93',465,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','94',466,'1','1',266537.67,266556.92,19.25,3561.25,0.00,0.00,0.00,0.00,0.00),('5','272','1','94',467,'2','1',375077.47,375077.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','94',468,'3','1',158030.14,160567.46,2537.32,469404.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','94',469,'4','1',315188.72,318090.50,2901.78,536829.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','94',470,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','95',471,'1','1',266556.92,266621.78,64.86,11999.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','95',472,'2','1',375077.47,380335.57,5258.10,972748.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','95',473,'3','1',160567.46,165054.90,4487.44,830176.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','95',474,'4','1',318090.50,322371.92,4281.42,792062.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','95',475,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','96',476,'1','1',266621.78,268652.37,2030.59,375659.15,0.00,0.00,0.00,0.00,0.00),('5','272','1','96',477,'2','1',380335.57,382351.96,2016.39,373032.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','96',478,'3','1',165054.90,168381.74,3326.84,615465.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','96',479,'4','1',322371.92,325650.68,3278.76,606570.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','96',480,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','97',481,'1','1',268652.37,271177.35,2524.98,467121.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','97',482,'2','1',382351.96,385391.38,3039.42,562292.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','97',483,'3','1',168381.74,174620.13,6238.39,1154102.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','97',484,'4','1',325650.68,327758.52,2107.84,389950.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','97',485,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','98',486,'1','1',271177.35,274553.24,3375.89,624539.65,0.00,0.00,0.00,0.00,0.00),('5','272','1','98',487,'2','1',385391.38,389969.36,4577.98,846926.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','98',488,'3','1',174620.13,179866.01,5245.88,970487.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','98',489,'4','1',327758.52,328628.70,870.18,160983.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','98',490,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','99',491,'1','1',274553.24,274669.29,116.05,21469.25,0.00,0.00,0.00,0.00,0.00),('5','272','1','99',492,'2','1',389969.36,394886.89,4917.53,909743.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','99',493,'3','1',179866.01,183537.31,3671.30,679190.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','99',494,'4','1',328628.70,333293.86,4665.16,863054.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','99',495,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','100',496,'1','1',274669.29,274669.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','100',497,'2','1',394886.89,399172.97,4286.08,792924.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','100',498,'3','1',183537.31,185298.01,1760.70,325729.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','100',499,'4','1',333293.86,337027.02,3733.16,690634.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','100',500,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','101',501,'1','1',274669.29,278408.97,3739.68,691840.80,0.00,0.00,0.00,0.00,0.00),('5','272','1','101',502,'2','1',399172.97,399172.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','101',503,'3','1',185298.01,185298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','101',504,'4','1',337027.02,337027.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','101',505,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','102',506,'1','1',278408.97,278408.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','102',507,'2','1',399172.97,401204.04,2031.07,375747.95,0.00,0.00,0.00,0.00,0.00),('5','272','2','102',508,'3','1',185298.01,185298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','102',509,'4','1',337027.02,337027.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','102',510,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','103',511,'1','1',278408.97,278408.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','103',512,'2','1',401204.04,402904.04,1700.00,314500.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','103',513,'3','1',185298.01,185298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','103',514,'4','1',337027.02,337027.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','103',515,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','104',516,'1','1',278408.97,280315.52,1906.55,352711.75,0.00,0.00,0.00,0.00,0.00),('5','272','1','104',517,'2','1',402904.04,405716.83,2812.79,520366.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','104',518,'3','1',185298.01,185298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','104',519,'4','1',337027.02,337027.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','104',520,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','105',521,'1','1',280315.52,280315.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','105',522,'2','1',405716.83,405736.83,20.00,3700.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','105',523,'3','1',185298.01,189476.06,4178.05,772939.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','105',524,'4','1',337027.02,340656.47,3629.45,671448.25,0.00,0.00,0.00,0.00,0.00),('5','272','3','105',525,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','106',526,'1','1',280315.52,280315.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','106',527,'2','1',405736.83,405736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','106',528,'3','1',189476.06,196415.65,6939.59,1283824.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','106',529,'4','1',340656.47,347385.04,6728.57,1244785.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','106',530,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','107',531,'1','1',280315.52,280315.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','107',532,'2','1',405736.83,405736.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','107',533,'3','1',196415.65,199359.73,2944.08,544654.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','107',534,'4','1',347385.04,350320.75,2935.71,543106.35,0.00,0.00,0.00,0.00,0.00),('5','272','3','107',535,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','108',536,'1','1',280315.52,283275.76,2960.24,547644.40,0.00,0.00,0.00,0.00,0.00),('5','272','1','108',537,'2','1',405736.83,408767.37,3030.54,560649.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','108',538,'3','1',199359.73,203675.28,4315.55,798376.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','108',539,'4','1',350320.75,355115.30,4794.55,886991.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','108',540,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','109',541,'1','1',283275.76,283536.53,260.77,48242.45,0.00,0.00,0.00,0.00,0.00),('5','272','1','109',542,'2','1',408767.37,414842.67,6075.30,1123930.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','109',543,'3','1',203675.28,207750.30,4075.02,753878.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','109',544,'4','1',355115.30,359518.04,4402.74,814506.90,0.00,0.00,0.00,0.00,0.00),('5','272','3','109',545,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','110',546,'1','1',283536.53,283536.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','110',547,'2','1',414842.67,415060.46,217.79,40291.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','110',548,'3','1',207750.30,212392.98,4642.68,858895.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','110',549,'4','1',359518.04,363744.94,4226.90,781976.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','110',550,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','111',551,'1','1',283536.53,283553.45,16.92,3130.20,0.00,0.00,0.00,0.00,0.00),('5','272','1','111',552,'2','1',415060.46,415289.86,229.40,42439.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','111',553,'3','1',212392.98,217026.37,4633.39,857177.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','111',554,'4','1',363744.94,368736.84,4991.90,923501.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','111',555,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','112',556,'1','1',283553.45,286539.78,2986.33,552471.05,0.00,0.00,0.00,0.00,0.00),('5','272','1','112',557,'2','1',415289.86,418801.95,3512.09,649736.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','112',558,'3','1',217026.37,222112.61,5086.24,940954.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','112',559,'4','1',368736.84,368736.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','112',560,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','113',561,'1','1',286539.78,289295.28,2755.50,509767.50,0.00,0.00,0.00,0.00,0.00),('5','272','1','113',562,'2','1',418801.95,422355.43,3553.48,657393.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','113',563,'3','1',222112.61,226023.75,3911.14,723560.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','113',564,'4','1',368736.84,369396.72,659.88,122077.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','113',565,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','114',566,'1','1',289295.28,292081.90,2786.62,515524.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','114',567,'2','1',422355.43,425629.32,3273.89,605669.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','114',568,'3','1',226023.75,228093.90,2070.15,382977.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','114',569,'4','1',369396.72,371302.18,1905.46,352510.10,0.00,0.00,0.00,0.00,0.00),('5','272','3','114',570,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','115',571,'1','1',292081.90,293166.16,1084.26,200588.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','115',572,'2','1',425629.32,431403.02,5773.70,1068134.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','115',573,'3','1',228093.90,231243.96,3150.06,582761.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','115',574,'4','1',371302.18,374221.23,2919.05,540024.25,0.00,0.00,0.00,0.00,0.00),('5','272','3','115',575,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','116',576,'1','1',293166.16,293166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','116',577,'2','1',431403.02,431403.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','116',578,'3','1',231243.96,237799.56,6555.60,1212786.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','116',579,'4','1',374221.23,380530.77,6309.54,1167264.90,0.00,0.00,0.00,0.00,0.00),('5','272','3','116',580,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','117',581,'1','1',293166.16,293166.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','117',582,'2','1',431403.02,431403.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','117',583,'3','1',237799.56,242534.54,4734.98,875971.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','117',584,'4','1',380530.77,384505.27,3974.50,735282.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','117',585,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','118',586,'1','1',293166.16,294998.78,1832.62,339034.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','118',587,'2','1',431403.02,433586.41,2183.39,403927.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','118',588,'3','1',242534.54,248091.79,5557.25,1028091.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','118',589,'4','1',384505.27,388049.81,3544.54,655739.90,0.00,0.00,0.00,0.00,0.00),('5','272','3','118',590,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','119',591,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','119',592,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','119',593,'3','1',248091.79,252238.69,4146.90,767176.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','119',594,'4','1',388049.81,392180.57,4130.76,764190.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','119',595,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','120',596,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','120',597,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','120',598,'3','1',252238.69,258867.70,6629.01,1226366.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','120',599,'4','1',392180.57,399148.76,6968.19,1289115.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','120',600,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','121',601,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','121',602,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','121',603,'3','1',258867.70,265985.31,7117.61,1316757.85,0.00,0.00,0.00,0.00,0.00),('5','272','2','121',604,'4','1',399148.76,406198.25,7049.49,1304155.65,0.00,0.00,0.00,0.00,0.00),('5','272','3','121',605,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','122',606,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','122',607,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','122',608,'3','1',265985.31,272580.04,6594.73,1220025.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','122',609,'4','1',406198.25,412768.18,6569.93,1215437.05,0.00,0.00,0.00,0.00,0.00),('5','272','3','122',610,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','123',611,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','123',612,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','123',613,'3','1',272580.04,279603.55,7023.51,1299349.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','123',614,'4','1',412768.18,419031.33,6263.15,1158682.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','123',615,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','124',616,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','124',617,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','124',618,'3','1',279603.55,285121.25,5517.70,1020774.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','124',619,'4','1',419031.33,424653.00,5621.67,1040008.95,0.00,0.00,0.00,0.00,0.00),('5','272','3','124',620,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','125',621,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','125',622,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','125',623,'3','1',285121.25,289270.94,4149.69,767692.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','125',624,'4','1',424653.00,428415.55,3762.55,696071.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','125',625,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','126',626,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','126',627,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','126',628,'3','1',289270.94,291726.07,2455.13,454199.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','126',629,'4','1',428415.55,431138.05,2722.50,503662.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','126',630,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','127',631,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','127',632,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','127',633,'3','1',291726.07,291726.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','127',634,'4','1',431138.05,433421.40,2283.35,422419.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','127',635,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','128',636,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','128',637,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','128',638,'3','1',291726.07,291726.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','128',639,'4','1',433421.40,433980.88,559.48,103503.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','128',640,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','129',641,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','129',642,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','129',643,'3','1',291726.07,291726.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','129',644,'4','1',433980.88,435796.85,1815.97,335954.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','129',645,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','130',646,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','130',647,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','130',648,'3','1',291726.07,291726.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','130',649,'4','1',435796.85,437123.73,1326.88,245472.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','130',650,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','131',651,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','131',652,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','131',653,'3','1',291726.07,291726.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','131',654,'4','1',437123.73,437123.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','131',655,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','132',656,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','132',657,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','132',658,'3','1',291726.07,293070.99,1344.92,248810.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','132',659,'4','1',437123.73,438683.32,1559.59,288524.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','132',660,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','133',661,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','133',662,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','133',663,'3','1',293070.99,303270.32,10199.33,1886876.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','133',664,'4','1',438683.32,447258.61,8575.29,1586428.65,0.00,0.00,0.00,0.00,0.00),('5','272','3','133',665,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','134',666,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','134',667,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','134',668,'3','1',303270.32,311604.87,8334.55,1541891.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','134',669,'4','1',447258.61,453511.11,6252.50,1156712.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','134',670,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','135',671,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','135',672,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','135',673,'3','1',311604.87,317938.96,6334.09,1171806.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','135',674,'4','1',453511.11,460808.43,7297.32,1350004.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','135',675,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','136',676,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','136',677,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','136',678,'3','1',317938.96,325646.47,7707.51,1425889.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','136',679,'4','1',460808.43,468262.08,7453.65,1378925.25,0.00,0.00,0.00,0.00,0.00),('5','272','3','136',680,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','137',681,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','137',682,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','137',683,'3','1',325646.47,332528.09,6881.62,1273099.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','137',684,'4','1',468262.08,476110.38,7848.30,1451935.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','137',685,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','138',686,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','138',687,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','138',688,'3','1',332528.09,341765.24,9237.15,1708872.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','138',689,'4','1',476110.38,484735.35,8624.97,1595619.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','138',690,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','139',691,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','139',692,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','139',693,'3','1',341765.24,347551.48,5786.24,1070454.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','139',694,'4','1',484735.35,492587.46,7852.11,1452640.35,0.00,0.00,0.00,0.00,0.00),('5','272','3','139',695,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','140',696,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','140',697,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','140',698,'3','1',347551.48,356797.04,9245.56,1710428.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','140',699,'4','1',492587.46,502023.52,9436.06,1745671.10,0.00,0.00,0.00,0.00,0.00),('5','272','3','140',700,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','141',701,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','141',702,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','141',703,'3','1',356797.04,363608.72,6811.68,1260160.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','141',704,'4','1',502023.52,506444.11,4420.59,817809.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','141',705,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','142',706,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','142',707,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','142',708,'3','1',363608.72,371474.58,7865.86,1455184.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','142',709,'4','1',506444.11,510355.93,3911.82,723686.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','142',710,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','143',711,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','143',712,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','143',713,'3','1',371474.58,375563.46,4088.88,756442.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','143',714,'4','1',510355.93,513192.16,2836.23,524702.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','143',715,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','144',716,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','144',717,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','144',718,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','144',719,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','144',720,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','145',721,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','145',722,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','145',723,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','145',724,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','145',725,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','146',726,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','146',727,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','146',728,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','146',729,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','146',730,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','147',731,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','147',732,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','147',733,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','147',734,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','147',735,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','148',736,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','148',737,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','148',738,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','148',739,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','148',740,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','149',741,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','149',742,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','149',743,'3','1',375563.46,375563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','149',744,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','149',745,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','150',746,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','150',747,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','150',748,'3','1',375563.46,387649.99,12086.53,2236008.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','150',749,'4','1',513192.16,513192.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','150',750,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','151',751,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','151',752,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','151',753,'3','1',387649.99,387649.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','151',754,'4','1',513192.16,524915.75,11723.59,2168864.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','151',755,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','152',756,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','152',757,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','152',758,'3','1',387649.99,391085.53,3435.54,635574.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','152',759,'4','1',524915.75,528120.95,3205.20,592962.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','152',760,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','153',761,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','153',762,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','153',763,'3','1',391085.53,398768.29,7682.76,1421310.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','153',764,'4','1',528120.95,528120.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','153',765,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','154',766,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','154',767,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','154',768,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','154',769,'4','1',528120.95,535136.12,7015.17,1297806.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','154',770,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','155',771,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','155',772,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','155',773,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','155',774,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','155',775,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','156',776,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','156',777,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','156',778,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','156',779,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','156',780,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','157',781,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','157',782,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','157',783,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','157',784,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','157',785,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','158',786,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','158',787,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','158',788,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','158',789,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','158',790,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','159',791,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','159',792,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','159',793,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','159',794,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','159',795,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','160',796,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','160',797,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','160',798,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','160',799,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','160',800,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','161',801,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','161',802,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','161',803,'3','1',398768.29,398768.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','161',804,'4','1',535136.12,535136.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','161',805,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','162',806,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','162',807,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','162',808,'3','1',398768.29,406005.23,7236.94,1338833.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','162',809,'4','1',535136.12,543136.36,8000.24,1480044.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','162',810,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','163',811,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','163',812,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','163',813,'3','1',406005.23,412168.57,6163.34,1140217.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','163',814,'4','1',543136.36,548922.19,5785.83,1070378.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','163',815,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','164',816,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','164',817,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','164',818,'3','1',412168.57,417728.86,5560.29,1028653.65,0.00,0.00,0.00,0.00,0.00),('5','272','2','164',819,'4','1',548922.19,555642.79,6720.60,1243311.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','164',820,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','165',821,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','165',822,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','165',823,'3','1',417728.86,417728.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','165',824,'4','1',555642.79,555642.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','165',825,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','166',826,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','166',827,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','166',828,'3','1',417728.86,419387.92,1659.06,306926.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','166',829,'4','1',555642.79,559628.94,3986.15,737437.75,0.00,0.00,0.00,0.00,0.00),('5','272','3','166',830,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','167',831,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','167',832,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','167',833,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','167',834,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','167',835,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','168',836,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','168',837,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','168',838,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','168',839,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','168',840,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','169',841,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','169',842,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','169',843,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','169',844,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','169',845,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','170',846,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','170',847,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','170',848,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','170',849,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','170',850,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','171',851,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','171',852,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','171',853,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','171',854,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','171',855,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','172',856,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','172',857,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','172',858,'3','1',419387.92,419387.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','172',859,'4','1',559628.94,559628.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','172',860,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','173',861,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','173',862,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','173',863,'3','1',419387.92,423479.74,4091.82,756986.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','173',864,'4','1',559628.94,563027.05,3398.11,628650.35,0.00,0.00,0.00,0.00,0.00),('5','272','3','173',865,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','174',866,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','174',867,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','174',868,'3','1',423479.74,426409.97,2930.23,542092.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','174',869,'4','1',563027.05,566584.88,3557.83,658198.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','174',870,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','175',871,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','175',872,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','175',873,'3','1',426409.97,435859.02,9449.05,1748074.25,0.00,0.00,0.00,0.00,0.00),('5','272','2','175',874,'4','1',566584.88,577557.10,10972.22,2029860.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','175',875,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','176',876,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','176',877,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','176',878,'3','1',435859.02,445038.72,9179.70,1698244.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','176',879,'4','1',577557.10,587624.82,10067.72,1862528.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','176',880,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','177',881,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','177',882,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','177',883,'3','1',445038.72,455291.92,10253.20,1896842.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','177',884,'4','1',587624.82,599714.45,12089.63,2236581.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','177',885,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','178',886,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','178',887,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','178',888,'3','1',455291.92,466818.23,11526.31,2132367.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','178',889,'4','1',599714.45,610660.64,10946.19,2025045.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','178',890,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','179',891,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','179',892,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','179',893,'3','1',466818.23,477661.85,10843.62,2006069.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','179',894,'4','1',610660.64,622573.51,11912.87,2203880.95,0.00,0.00,0.00,0.00,0.00),('5','272','3','179',895,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','180',896,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','180',897,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','180',898,'3','1',477661.85,485108.60,7446.75,1377648.75,0.00,0.00,0.00,0.00,0.00),('5','272','2','180',899,'4','1',622573.51,631270.90,8697.39,1609017.15,0.00,0.00,0.00,0.00,0.00),('5','272','3','180',900,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','181',901,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','181',902,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','181',903,'3','1',485108.60,485108.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','181',904,'4','1',631270.90,631270.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','181',905,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','182',906,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','182',907,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','182',908,'3','1',485108.60,496461.06,11352.46,2100205.10,0.00,0.00,0.00,0.00,0.00),('5','272','2','182',909,'4','1',631270.90,643575.62,12304.72,2276373.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','182',910,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','183',911,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','183',912,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','183',913,'3','1',496461.06,507041.64,10580.58,1957407.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','183',914,'4','1',643575.62,655370.44,11794.82,2182041.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','183',915,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','184',916,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','184',917,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','184',918,'3','1',507041.64,519662.26,12620.62,2334814.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','184',919,'4','1',655370.44,667324.61,11954.17,2211521.45,0.00,0.00,0.00,0.00,0.00),('5','272','3','184',920,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','185',921,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','185',922,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','185',923,'3','1',519662.26,526919.96,7257.70,1342674.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','185',924,'4','1',667324.61,675651.90,8327.29,1540548.65,0.00,0.00,0.00,0.00,0.00),('5','272','3','185',925,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','186',926,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','186',927,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','186',928,'3','1',526919.96,534419.39,7499.43,1387394.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','186',929,'4','1',675651.90,683113.13,7461.23,1380327.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','186',930,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','187',931,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','187',932,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','187',933,'3','1',534419.39,544214.97,9795.58,1812182.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','187',934,'4','1',683113.13,693143.31,10030.18,1855583.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','187',935,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','188',936,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','188',937,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','188',938,'3','1',544214.97,547515.88,3300.91,610668.35,0.00,0.00,0.00,0.00,0.00),('5','272','2','188',939,'4','1',693143.31,697165.42,4022.11,744090.35,0.00,0.00,0.00,0.00,0.00),('5','272','3','188',940,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','189',941,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','189',942,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','189',943,'3','1',547515.88,547515.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','189',944,'4','1',697165.42,706494.92,9329.50,1725957.50,0.00,0.00,0.00,0.00,0.00),('5','272','3','189',945,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','190',946,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','190',947,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','190',948,'3','1',547515.88,552421.47,4905.59,907534.15,0.00,0.00,0.00,0.00,0.00),('5','272','2','190',949,'4','1',706494.92,710300.52,3805.60,704036.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','190',950,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','191',951,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','191',952,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','191',953,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','191',954,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','191',955,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','192',956,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','192',957,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','192',958,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','192',959,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','192',960,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','193',961,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','193',962,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','193',963,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','193',964,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','193',965,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','194',966,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','194',967,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','194',968,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','194',969,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','194',970,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','195',971,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','195',972,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','195',973,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','195',974,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','195',975,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','196',976,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','196',977,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','196',978,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','196',979,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','196',980,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','197',981,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','197',982,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','197',983,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','197',984,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','197',985,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','198',986,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','198',987,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','198',988,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','198',989,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','198',990,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','199',991,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','199',992,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','199',993,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','199',994,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','199',995,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','200',996,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','200',997,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','200',998,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','200',999,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','200',1000,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','201',1001,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','201',1002,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','201',1003,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','201',1004,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','201',1005,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','202',1006,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','202',1007,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','202',1008,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','202',1009,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','202',1010,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','203',1011,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','203',1012,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','203',1013,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','203',1014,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','203',1015,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','204',1016,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','204',1017,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','204',1018,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','204',1019,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','204',1020,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','205',1021,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','205',1022,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','205',1023,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','205',1024,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','205',1025,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','206',1026,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','206',1027,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','206',1028,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','206',1029,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','206',1030,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','207',1031,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','207',1032,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','207',1033,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','207',1034,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','207',1035,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','208',1036,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','208',1037,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','208',1038,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','208',1039,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','208',1040,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','209',1041,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','209',1042,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','209',1043,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','209',1044,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','209',1045,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','210',1046,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','210',1047,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','210',1048,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','210',1049,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','210',1050,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','211',1051,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','211',1052,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','211',1053,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','211',1054,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','211',1055,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','212',1056,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','212',1057,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','212',1058,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','212',1059,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','212',1060,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','213',1061,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','213',1062,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','213',1063,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','213',1064,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','213',1065,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','214',1066,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','214',1067,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','214',1068,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','214',1069,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','214',1070,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','215',1071,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','215',1072,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','215',1073,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','215',1074,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','215',1075,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','216',1076,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','216',1077,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','216',1078,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','216',1079,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','216',1080,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','217',1081,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','217',1082,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','217',1083,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','217',1084,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','217',1085,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','218',1086,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','218',1087,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','218',1088,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','218',1089,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','218',1090,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','219',1091,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','219',1092,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','219',1093,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','219',1094,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','219',1095,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','220',1096,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','220',1097,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','220',1098,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','220',1099,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','220',1100,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','221',1101,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','221',1102,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','221',1103,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','221',1104,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','221',1105,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','222',1106,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','222',1107,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','222',1108,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','222',1109,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','222',1110,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','223',1111,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','223',1112,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','223',1113,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','223',1114,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','223',1115,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','224',1116,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','224',1117,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','224',1118,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','224',1119,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','224',1120,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','225',1121,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','225',1122,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','225',1123,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','225',1124,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','225',1125,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','226',1126,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','226',1127,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','226',1128,'3','1',552421.47,552421.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','226',1129,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','226',1130,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','227',1131,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','227',1132,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','227',1133,'3','1',552421.47,559725.15,7303.68,1351180.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','227',1134,'4','1',710300.52,710300.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','227',1135,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','228',1136,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','228',1137,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','228',1138,'3','1',559725.15,559725.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','228',1139,'4','1',710300.52,717914.32,7613.80,1408553.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','228',1140,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','229',1141,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','229',1142,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','229',1143,'3','1',559725.15,566409.38,6684.23,1236582.55,0.00,0.00,0.00,0.00,0.00),('5','272','2','229',1144,'4','1',717914.32,724903.56,6989.24,1293009.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','229',1145,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','230',1146,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','230',1147,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','230',1148,'3','1',566409.38,571910.76,5501.38,1017755.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','230',1149,'4','1',724903.56,730230.38,5326.82,985461.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','230',1150,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','231',1151,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','231',1152,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','231',1153,'3','1',571910.76,574469.94,2559.18,473448.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','231',1154,'4','1',730230.38,733338.36,3107.98,574976.30,0.00,0.00,0.00,0.00,0.00),('5','272','3','231',1155,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','232',1156,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','232',1157,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','232',1158,'3','1',574469.94,574469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','232',1159,'4','1',733338.36,733338.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','232',1160,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','233',1161,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','233',1162,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','233',1163,'3','1',574469.94,574469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','233',1164,'4','1',733338.36,733338.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','233',1165,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','234',1166,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','234',1167,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','234',1168,'3','1',574469.94,574469.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','234',1169,'4','1',733338.36,733338.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','234',1170,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','235',1171,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','235',1172,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','235',1173,'3','1',574469.94,575764.07,1294.13,239414.05,0.00,0.00,0.00,0.00,0.00),('5','272','2','235',1174,'4','1',733338.36,734472.39,1134.03,209795.55,0.00,0.00,0.00,0.00,0.00),('5','272','3','235',1175,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','236',1176,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','236',1177,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','236',1178,'3','1',575764.07,579212.05,3447.98,758555.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','236',1179,'4','1',734472.39,739403.28,4930.89,1084795.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','236',1180,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','237',1181,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','237',1182,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','237',1183,'3','1',579212.05,581261.90,2049.85,450967.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','237',1184,'4','1',739403.28,741657.78,2254.50,495990.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','237',1185,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','238',1186,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','238',1187,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','238',1188,'3','1',581261.90,587475.03,6213.13,1366888.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','238',1189,'4','1',741657.78,743930.07,2272.29,499903.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','238',1190,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','239',1191,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','239',1192,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','239',1193,'3','1',587475.03,594327.13,6852.10,1507462.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','239',1194,'4','1',743930.07,745158.60,1228.53,270276.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','239',1195,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','240',1196,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','240',1197,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','240',1198,'3','1',594327.13,594327.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','240',1199,'4','1',745158.60,753032.25,7873.65,1732203.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','240',1200,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','241',1201,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','241',1202,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','241',1203,'3','1',594327.13,598761.73,4434.60,975612.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','241',1204,'4','1',753032.25,754205.26,1173.01,258062.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','241',1205,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','242',1206,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','242',1207,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','242',1208,'3','1',598761.73,598761.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','242',1209,'4','1',754205.26,754205.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','242',1210,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','243',1211,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','243',1212,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','243',1213,'3','1',598761.73,598761.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','243',1214,'4','1',754205.26,754205.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','243',1215,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','244',1216,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','244',1217,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','244',1218,'3','1',598761.73,598761.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','244',1219,'4','1',754205.26,754205.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','244',1220,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','245',1221,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','245',1222,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','245',1223,'3','1',598761.73,598761.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','245',1224,'4','1',754205.26,756970.51,2765.25,608355.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','245',1225,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','246',1226,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','246',1227,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','246',1228,'3','1',598761.73,603770.39,5008.66,1101905.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','246',1229,'4','1',756970.51,758725.24,1754.73,386040.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','246',1230,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','247',1231,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','247',1232,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','247',1233,'3','1',603770.39,607291.53,3521.14,774650.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','247',1234,'4','1',758725.24,762722.32,3997.08,879357.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','247',1235,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','248',1236,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','248',1237,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','248',1238,'3','1',607291.53,607291.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','248',1239,'4','1',762722.32,762722.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','248',1240,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','249',1241,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','249',1242,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','249',1243,'3','1',607291.53,607291.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','249',1244,'4','1',762722.32,762722.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','249',1245,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','250',1246,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','250',1247,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','250',1248,'3','1',607291.53,607291.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','250',1249,'4','1',762722.32,762722.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','250',1250,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','251',1251,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','251',1252,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','251',1253,'3','1',607291.53,607868.23,576.70,126874.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','251',1254,'4','1',762722.32,763936.39,1214.07,267095.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','251',1255,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','252',1256,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','252',1257,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','252',1258,'3','1',607868.23,607868.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','252',1259,'4','1',763936.39,769342.62,5406.23,1189370.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','252',1260,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','253',1261,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','253',1262,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','253',1263,'3','1',607868.23,608868.23,1000.00,220000.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','253',1264,'4','1',769342.62,770384.18,1041.56,229143.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','253',1265,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','254',1266,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','254',1267,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','254',1268,'3','1',608868.23,608868.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','254',1269,'4','1',770384.18,770384.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','254',1270,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','255',1271,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','255',1272,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','255',1273,'3','1',608868.23,608868.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','255',1274,'4','1',770384.18,770384.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','255',1275,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','256',1276,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','256',1277,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','256',1278,'3','1',608868.23,608868.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','256',1279,'4','1',770384.18,770384.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','256',1280,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','257',1281,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','257',1282,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','257',1283,'3','1',608868.23,609485.05,616.82,135700.40,0.00,0.00,0.00,0.00,0.00),('5','272','2','257',1284,'4','1',770384.18,771808.84,1424.66,313425.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','257',1285,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','258',1286,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','258',1287,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','258',1288,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','258',1289,'4','1',771808.84,775467.36,3658.52,804874.40,0.00,0.00,0.00,0.00,0.00),('5','272','3','258',1290,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','259',1291,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','259',1292,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','259',1293,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','259',1294,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','259',1295,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','260',1296,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','260',1297,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','260',1298,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','260',1299,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','260',1300,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','261',1301,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','261',1302,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','261',1303,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','261',1304,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','261',1305,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','262',1306,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','262',1307,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','262',1308,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','262',1309,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','262',1310,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','263',1311,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','263',1312,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','263',1313,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','263',1314,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','263',1315,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','264',1316,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','264',1317,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','264',1318,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','264',1319,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','264',1320,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','265',1321,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','265',1322,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','265',1323,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','265',1324,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','265',1325,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','266',1326,'1','1',294998.78,294998.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','266',1327,'2','1',433586.41,433586.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','266',1328,'3','1',609485.05,609485.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','266',1329,'4','1',775467.36,775467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','266',1330,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','267',1331,'1','1',294998.78,297887.89,2889.11,606713.10,0.00,0.00,0.00,0.00,0.00),('5','272','1','267',1332,'2','1',433586.41,435728.40,2141.99,449817.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','267',1333,'3','1',609485.05,613380.90,3895.85,818128.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','267',1334,'4','1',775467.36,779841.14,4373.78,918493.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','267',1335,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','268',1336,'1','1',297887.89,302515.43,4627.54,971783.40,0.00,0.00,0.00,0.00,0.00),('5','272','1','268',1337,'2','1',435728.40,439671.97,3943.57,828149.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','268',1338,'3','1',613380.90,616238.37,2857.47,600068.70,0.00,0.00,0.00,0.00,0.00),('5','272','2','268',1339,'4','1',779841.14,783462.00,3620.86,760380.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','268',1340,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','269',1341,'1','1',302515.43,302515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','269',1342,'2','1',439671.97,439671.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','269',1343,'3','1',616238.37,616238.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','269',1344,'4','1',783462.00,783462.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','269',1345,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','270',1346,'1','1',302515.43,305528.53,3013.10,632751.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','270',1347,'2','1',439671.97,442971.57,3299.60,692916.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','270',1348,'3','1',616238.37,621105.39,4867.02,1022074.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','270',1349,'4','1',783462.00,788593.00,5131.00,1077510.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','270',1350,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','271',1351,'1','1',305528.53,308457.06,2928.53,614991.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','271',1352,'2','1',442971.57,445064.45,2092.88,439504.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','271',1353,'3','1',621105.39,628716.05,7610.66,1598238.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','271',1354,'4','1',788593.00,788593.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','271',1355,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','272',1356,'1','1',308457.06,308457.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','272',1357,'2','1',445064.45,445064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','272',1358,'3','1',628716.05,632402.90,3686.85,774238.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','272',1359,'4','1',788593.00,801348.91,12755.91,2678741.10,0.00,0.00,0.00,0.00,0.00),('5','272','3','272',1360,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','273',1361,'1','1',308457.06,308457.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','273',1362,'2','1',445064.45,445064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','273',1363,'3','1',632402.90,635415.58,3012.68,632662.80,0.00,0.00,0.00,0.00,0.00),('5','272','2','273',1364,'4','1',801348.91,806285.02,4936.11,1036583.10,0.00,0.00,0.00,0.00,0.00),('5','272','3','273',1365,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','274',1366,'1','1',308457.06,308457.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','274',1367,'2','1',445064.45,445064.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','274',1368,'3','1',635415.58,639616.81,4201.23,882258.30,0.00,0.00,0.00,0.00,0.00),('5','272','2','274',1369,'4','1',806285.02,813646.02,7361.00,1545810.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','274',1370,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','275',1371,'1','1',308457.06,308457.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','275',1372,'2','1',445064.45,452285.00,7220.55,1516315.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','275',1373,'3','1',639616.81,639616.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','275',1374,'4','1',813646.02,813646.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','275',1375,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','276',1376,'1','1',308457.06,314709.18,6252.12,1312945.20,0.00,0.00,0.00,0.00,0.00),('5','272','1','276',1377,'2','1',452285.00,452285.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','276',1378,'3','1',639616.81,640585.63,968.82,203452.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','276',1379,'4','1',813646.02,814626.48,980.46,205896.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','276',1380,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','277',1381,'1','1',314709.18,314709.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','277',1382,'2','1',452285.00,455523.70,3238.70,680127.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','277',1383,'3','1',640585.63,640585.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','277',1384,'4','1',814626.48,814626.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','277',1385,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','278',1386,'1','1',314709.18,315372.55,663.37,139307.70,0.00,0.00,0.00,0.00,0.00),('5','272','1','278',1387,'2','1',455523.70,456206.45,682.75,143377.50,0.00,0.00,0.00,0.00,0.00),('5','272','2','278',1388,'3','1',640585.63,640600.89,15.26,3204.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','278',1389,'4','1',814626.48,814852.36,225.88,47434.80,0.00,0.00,0.00,0.00,0.00),('5','272','3','278',1390,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','279',1391,'1','1',315372.55,318274.05,2901.50,609315.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','279',1392,'2','1',456206.45,459222.77,3016.32,633427.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','279',1393,'3','1',640600.89,642982.38,2381.49,500112.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','279',1394,'4','1',814852.36,816530.32,1677.96,352371.60,0.00,0.00,0.00,0.00,0.00),('5','272','3','279',1395,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','280',1396,'1','1',318274.05,320353.38,2079.33,436659.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','280',1397,'2','1',459222.77,459222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','280',1398,'3','1',642982.38,646591.64,3609.26,757944.60,0.00,0.00,0.00,0.00,0.00),('5','272','2','280',1399,'4','1',816530.32,821454.89,4924.57,1034159.70,0.00,0.00,0.00,0.00,0.00),('5','272','3','280',1400,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','281',1401,'1','1',320353.38,320826.61,473.23,99378.30,0.00,0.00,0.00,0.00,0.00),('5','272','1','281',1402,'2','1',459222.77,459222.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','281',1403,'3','1',646591.64,646591.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','281',1404,'4','1',821454.89,829236.21,7781.32,1634077.20,0.00,0.00,0.00,0.00,0.00),('5','272','3','281',1405,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','282',1406,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','282',1407,'2','1',459222.77,463638.36,4415.59,927273.90,0.00,0.00,0.00,0.00,0.00),('5','272','2','282',1408,'3','1',646591.64,652638.36,6046.72,1269811.20,0.00,0.00,0.00,0.00,0.00),('5','272','2','282',1409,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','282',1410,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','283',1411,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','283',1412,'2','1',463638.36,463638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','283',1413,'3','1',652638.36,652638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','283',1414,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','283',1415,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','284',1416,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','284',1417,'2','1',463638.36,463638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','284',1418,'3','1',652638.36,652638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','284',1419,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','284',1420,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','285',1421,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','285',1422,'2','1',463638.36,463638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','285',1423,'3','1',652638.36,652638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','285',1424,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','285',1425,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','286',1426,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','286',1427,'2','1',463638.36,463638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','286',1428,'3','1',652638.36,652638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','286',1429,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','286',1430,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','287',1431,'1','1',320826.61,320826.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','1','287',1432,'2','1',463638.36,463638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','287',1433,'3','1',652638.36,652638.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','2','287',1434,'4','1',829236.21,829236.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','272','3','287',1435,'5','2',12843.10,12843.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=575 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','272','1','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,1),('5','272','1','1',165.00,165.00,4978.86,0.00,0.00,0.00,0.00,2),('5','272','2','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,3),('5','272','2','1',165.00,165.00,6028.77,0.00,0.00,0.00,0.00,4),('5','272','3','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,5),('5','272','3','1',165.00,165.00,3310.96,0.00,0.00,0.00,0.00,6),('5','272','4','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,7),('5','272','4','1',165.00,165.00,8295.06,0.00,0.00,0.00,0.00,8),('5','272','5','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,9),('5','272','5','1',165.00,165.00,2714.04,0.00,0.00,0.00,0.00,10),('5','272','6','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,11),('5','272','6','1',165.00,165.00,8791.77,0.00,0.00,0.00,0.00,12),('5','272','7','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,13),('5','272','7','1',165.00,165.00,10823.13,0.00,0.00,0.00,0.00,14),('5','272','8','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,15),('5','272','8','1',165.00,165.00,9724.55,0.00,0.00,0.00,0.00,16),('5','272','9','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,17),('5','272','9','1',165.00,165.00,6106.31,0.00,0.00,0.00,0.00,18),('5','272','10','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,19),('5','272','10','1',165.00,165.00,5101.29,0.00,0.00,0.00,0.00,20),('5','272','11','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,21),('5','272','11','1',165.00,165.00,3502.27,0.00,0.00,0.00,0.00,22),('5','272','12','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,23),('5','272','12','1',165.00,165.00,2020.31,0.00,0.00,0.00,0.00,24),('5','272','13','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,25),('5','272','13','1',165.00,165.00,2119.64,0.00,0.00,0.00,0.00,26),('5','272','14','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,27),('5','272','14','1',165.00,165.00,1865.97,0.00,0.00,0.00,0.00,28),('5','272','15','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,29),('5','272','15','1',165.00,165.00,3081.31,0.00,0.00,0.00,0.00,30),('5','272','16','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,31),('5','272','16','1',165.00,165.00,1910.49,0.00,0.00,0.00,0.00,32),('5','272','17','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,33),('5','272','17','1',165.00,165.00,2252.46,0.00,0.00,0.00,0.00,34),('5','272','18','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,35),('5','272','18','1',165.00,165.00,2000.01,0.00,0.00,0.00,0.00,36),('5','272','19','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,37),('5','272','19','1',165.00,165.00,1621.00,0.00,0.00,0.00,0.00,38),('5','272','20','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,39),('5','272','20','1',165.00,165.00,262.16,0.00,0.00,0.00,0.00,40),('5','272','21','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,41),('5','272','21','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,42),('5','272','22','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,43),('5','272','22','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,44),('5','272','23','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,45),('5','272','23','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,46),('5','272','24','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,47),('5','272','24','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,48),('5','272','25','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,49),('5','272','25','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,50),('5','272','26','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,51),('5','272','26','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,52),('5','272','27','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,53),('5','272','27','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,54),('5','272','28','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,55),('5','272','28','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,56),('5','272','29','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,57),('5','272','29','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,58),('5','272','30','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,59),('5','272','30','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,60),('5','272','31','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,61),('5','272','31','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,62),('5','272','32','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,63),('5','272','32','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,64),('5','272','33','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,65),('5','272','33','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,66),('5','272','34','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,67),('5','272','34','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,68),('5','272','35','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,69),('5','272','35','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,70),('5','272','36','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,71),('5','272','36','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,72),('5','272','37','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,73),('5','272','37','1',165.00,165.00,1067.48,0.00,0.00,0.00,0.00,74),('5','272','38','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,75),('5','272','38','1',165.00,165.00,5551.46,0.00,0.00,0.00,0.00,76),('5','272','39','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,77),('5','272','39','1',185.00,185.00,2041.89,0.00,0.00,0.00,0.00,78),('5','272','40','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,79),('5','272','40','1',185.00,185.00,2524.73,0.00,0.00,0.00,0.00,80),('5','272','41','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,81),('5','272','41','1',185.00,185.00,4270.28,0.00,0.00,0.00,0.00,82),('5','272','42','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,83),('5','272','42','1',185.00,185.00,2072.18,0.00,0.00,0.00,0.00,84),('5','272','43','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,85),('5','272','43','1',185.00,185.00,2462.34,0.00,0.00,0.00,0.00,86),('5','272','44','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,87),('5','272','44','1',185.00,185.00,2919.60,0.00,0.00,0.00,0.00,88),('5','272','45','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,89),('5','272','45','1',185.00,185.00,11875.49,0.00,0.00,0.00,0.00,90),('5','272','46','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,91),('5','272','46','1',185.00,185.00,10294.28,0.00,0.00,0.00,0.00,92),('5','272','47','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,93),('5','272','47','1',185.00,185.00,10227.79,0.00,0.00,0.00,0.00,94),('5','272','48','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,95),('5','272','48','1',185.00,185.00,8284.95,0.00,0.00,0.00,0.00,96),('5','272','49','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,97),('5','272','49','1',185.00,185.00,13247.88,0.00,0.00,0.00,0.00,98),('5','272','50','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,99),('5','272','50','1',185.00,185.00,16455.08,0.00,0.00,0.00,0.00,100),('5','272','51','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,101),('5','272','51','1',185.00,185.00,15128.25,0.00,0.00,0.00,0.00,102),('5','272','52','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,103),('5','272','52','1',185.00,185.00,6803.72,0.00,0.00,0.00,0.00,104),('5','272','53','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,105),('5','272','53','1',185.00,185.00,8474.43,0.00,0.00,0.00,0.00,106),('5','272','54','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,107),('5','272','54','1',185.00,185.00,14381.99,0.00,0.00,0.00,0.00,108),('5','272','55','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,109),('5','272','55','1',185.00,185.00,9386.07,0.00,0.00,0.00,0.00,110),('5','272','56','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,111),('5','272','56','1',185.00,185.00,8145.00,0.00,0.00,0.00,0.00,112),('5','272','57','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,113),('5','272','57','1',185.00,185.00,1809.00,0.00,0.00,0.00,0.00,114),('5','272','58','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,115),('5','272','58','1',185.00,185.00,1456.63,0.00,0.00,0.00,0.00,116),('5','272','59','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,117),('5','272','59','1',185.00,185.00,1687.24,0.00,0.00,0.00,0.00,118),('5','272','60','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,119),('5','272','60','1',185.00,185.00,1500.68,0.00,0.00,0.00,0.00,120),('5','272','61','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,121),('5','272','61','1',185.00,185.00,1545.47,0.00,0.00,0.00,0.00,122),('5','272','62','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,123),('5','272','62','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,124),('5','272','63','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,125),('5','272','63','1',185.00,185.00,3817.83,0.00,0.00,0.00,0.00,126),('5','272','64','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,127),('5','272','64','1',185.00,185.00,20094.26,0.00,0.00,0.00,0.00,128),('5','272','65','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,129),('5','272','65','1',185.00,185.00,2220.31,0.00,0.00,0.00,0.00,130),('5','272','66','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,131),('5','272','66','1',185.00,185.00,4347.40,0.00,0.00,0.00,0.00,132),('5','272','67','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,133),('5','272','67','1',185.00,185.00,9366.94,0.00,0.00,0.00,0.00,134),('5','272','68','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,135),('5','272','68','1',185.00,185.00,7934.09,0.00,0.00,0.00,0.00,136),('5','272','69','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,137),('5','272','69','1',185.00,185.00,14087.20,0.00,0.00,0.00,0.00,138),('5','272','70','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,139),('5','272','70','1',185.00,185.00,12086.82,0.00,0.00,0.00,0.00,140),('5','272','71','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,141),('5','272','71','1',185.00,185.00,15003.24,0.00,0.00,0.00,0.00,142),('5','272','72','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,143),('5','272','72','1',185.00,185.00,15044.59,0.00,0.00,0.00,0.00,144),('5','272','73','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,145),('5','272','73','1',185.00,185.00,11313.92,0.00,0.00,0.00,0.00,146),('5','272','74','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,147),('5','272','74','1',185.00,185.00,13649.82,0.00,0.00,0.00,0.00,148),('5','272','75','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,149),('5','272','75','1',185.00,185.00,12382.15,0.00,0.00,0.00,0.00,150),('5','272','76','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,151),('5','272','76','1',185.00,185.00,11789.19,0.00,0.00,0.00,0.00,152),('5','272','77','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,153),('5','272','77','1',185.00,185.00,10279.35,0.00,0.00,0.00,0.00,154),('5','272','78','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,155),('5','272','78','1',185.00,185.00,10270.31,0.00,0.00,0.00,0.00,156),('5','272','79','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,157),('5','272','79','1',185.00,185.00,11215.01,0.00,0.00,0.00,0.00,158),('5','272','80','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,159),('5','272','80','1',185.00,185.00,13725.91,0.00,0.00,0.00,0.00,160),('5','272','81','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,161),('5','272','81','1',185.00,185.00,13930.20,0.00,0.00,0.00,0.00,162),('5','272','82','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,163),('5','272','82','1',185.00,185.00,8707.53,0.00,0.00,0.00,0.00,164),('5','272','83','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,165),('5','272','83','1',185.00,185.00,9842.85,0.00,0.00,0.00,0.00,166),('5','272','84','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,167),('5','272','84','1',185.00,185.00,11457.56,0.00,0.00,0.00,0.00,168),('5','272','85','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,169),('5','272','85','1',185.00,185.00,13483.67,0.00,0.00,0.00,0.00,170),('5','272','86','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,171),('5','272','86','1',185.00,185.00,12440.32,0.00,0.00,0.00,0.00,172),('5','272','87','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,173),('5','272','87','1',185.00,185.00,15058.73,0.00,0.00,0.00,0.00,174),('5','272','88','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,175),('5','272','88','1',185.00,185.00,13284.09,0.00,0.00,0.00,0.00,176),('5','272','89','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,177),('5','272','89','1',185.00,185.00,12488.92,0.00,0.00,0.00,0.00,178),('5','272','90','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,179),('5','272','90','1',185.00,185.00,14915.51,0.00,0.00,0.00,0.00,180),('5','272','91','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,181),('5','272','91','1',185.00,185.00,13465.25,0.00,0.00,0.00,0.00,182),('5','272','92','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,183),('5','272','92','1',185.00,185.00,4567.52,0.00,0.00,0.00,0.00,184),('5','272','93','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,185),('5','272','93','1',185.00,185.00,2422.96,0.00,0.00,0.00,0.00,186),('5','272','94','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,187),('5','272','94','1',185.00,185.00,5458.35,0.00,0.00,0.00,0.00,188),('5','272','95','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,189),('5','272','95','1',185.00,185.00,14091.82,0.00,0.00,0.00,0.00,190),('5','272','96','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,191),('5','272','96','1',185.00,185.00,10652.58,0.00,0.00,0.00,0.00,192),('5','272','97','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,193),('5','272','97','1',185.00,185.00,13910.63,0.00,0.00,0.00,0.00,194),('5','272','98','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,195),('5','272','98','1',185.00,185.00,14069.93,0.00,0.00,0.00,0.00,196),('5','272','99','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,197),('5','272','99','1',185.00,185.00,13370.04,0.00,0.00,0.00,0.00,198),('5','272','100','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,199),('5','272','100','1',185.00,185.00,9779.94,0.00,0.00,0.00,0.00,200),('5','272','101','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,201),('5','272','101','1',185.00,185.00,3739.68,0.00,0.00,0.00,0.00,202),('5','272','102','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,203),('5','272','102','1',185.00,185.00,2031.07,0.00,0.00,0.00,0.00,204),('5','272','103','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,205),('5','272','103','1',185.00,185.00,1700.00,0.00,0.00,0.00,0.00,206),('5','272','104','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,207),('5','272','104','1',185.00,185.00,4719.34,0.00,0.00,0.00,0.00,208),('5','272','105','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,209),('5','272','105','1',185.00,185.00,7827.50,0.00,0.00,0.00,0.00,210),('5','272','106','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,211),('5','272','106','1',185.00,185.00,13668.16,0.00,0.00,0.00,0.00,212),('5','272','107','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,213),('5','272','107','1',185.00,185.00,5879.79,0.00,0.00,0.00,0.00,214),('5','272','108','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,215),('5','272','108','1',185.00,185.00,15100.88,0.00,0.00,0.00,0.00,216),('5','272','109','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,217),('5','272','109','1',185.00,185.00,14813.83,0.00,0.00,0.00,0.00,218),('5','272','110','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,219),('5','272','110','1',185.00,185.00,9087.37,0.00,0.00,0.00,0.00,220),('5','272','111','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,221),('5','272','111','1',185.00,185.00,9871.61,0.00,0.00,0.00,0.00,222),('5','272','112','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,223),('5','272','112','1',185.00,185.00,11584.66,0.00,0.00,0.00,0.00,224),('5','272','113','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,225),('5','272','113','1',185.00,185.00,10880.00,0.00,0.00,0.00,0.00,226),('5','272','114','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,227),('5','272','114','1',185.00,185.00,10036.12,0.00,0.00,0.00,0.00,228),('5','272','115','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,229),('5','272','115','1',185.00,185.00,12927.07,0.00,0.00,0.00,0.00,230),('5','272','116','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,231),('5','272','116','1',185.00,185.00,12865.14,0.00,0.00,0.00,0.00,232),('5','272','117','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,233),('5','272','117','1',185.00,185.00,8709.48,0.00,0.00,0.00,0.00,234),('5','272','118','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,235),('5','272','118','1',185.00,185.00,13117.80,0.00,0.00,0.00,0.00,236),('5','272','119','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,237),('5','272','119','1',185.00,185.00,8277.66,0.00,0.00,0.00,0.00,238),('5','272','120','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,239),('5','272','120','1',185.00,185.00,13597.20,0.00,0.00,0.00,0.00,240),('5','272','121','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,241),('5','272','121','1',185.00,185.00,14167.10,0.00,0.00,0.00,0.00,242),('5','272','122','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,243),('5','272','122','1',185.00,185.00,13164.66,0.00,0.00,0.00,0.00,244),('5','272','123','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,245),('5','272','123','1',185.00,185.00,13286.66,0.00,0.00,0.00,0.00,246),('5','272','124','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,247),('5','272','124','1',185.00,185.00,11139.37,0.00,0.00,0.00,0.00,248),('5','272','125','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,249),('5','272','125','1',185.00,185.00,7912.24,0.00,0.00,0.00,0.00,250),('5','272','126','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,251),('5','272','126','1',185.00,185.00,5177.63,0.00,0.00,0.00,0.00,252),('5','272','127','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,253),('5','272','127','1',185.00,185.00,2283.35,0.00,0.00,0.00,0.00,254),('5','272','128','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,255),('5','272','128','1',185.00,185.00,559.48,0.00,0.00,0.00,0.00,256),('5','272','129','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,257),('5','272','129','1',185.00,185.00,1815.97,0.00,0.00,0.00,0.00,258),('5','272','130','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,259),('5','272','130','1',185.00,185.00,1326.88,0.00,0.00,0.00,0.00,260),('5','272','131','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,261),('5','272','131','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,262),('5','272','132','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,263),('5','272','132','1',185.00,185.00,2904.51,0.00,0.00,0.00,0.00,264),('5','272','133','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,265),('5','272','133','1',185.00,185.00,18774.62,0.00,0.00,0.00,0.00,266),('5','272','134','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,267),('5','272','134','1',185.00,185.00,14587.05,0.00,0.00,0.00,0.00,268),('5','272','135','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,269),('5','272','135','1',185.00,185.00,13631.41,0.00,0.00,0.00,0.00,270),('5','272','136','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,271),('5','272','136','1',185.00,185.00,15161.16,0.00,0.00,0.00,0.00,272),('5','272','137','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,273),('5','272','137','1',185.00,185.00,14729.92,0.00,0.00,0.00,0.00,274),('5','272','138','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,275),('5','272','138','1',185.00,185.00,17862.12,0.00,0.00,0.00,0.00,276),('5','272','139','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,277),('5','272','139','1',185.00,185.00,13638.35,0.00,0.00,0.00,0.00,278),('5','272','140','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,279),('5','272','140','1',185.00,185.00,18681.62,0.00,0.00,0.00,0.00,280),('5','272','141','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,281),('5','272','141','1',185.00,185.00,11232.27,0.00,0.00,0.00,0.00,282),('5','272','142','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,283),('5','272','142','1',185.00,185.00,11777.68,0.00,0.00,0.00,0.00,284),('5','272','143','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,285),('5','272','143','1',185.00,185.00,6925.11,0.00,0.00,0.00,0.00,286),('5','272','144','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,287),('5','272','144','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,288),('5','272','145','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,289),('5','272','145','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,290),('5','272','146','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,291),('5','272','146','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,292),('5','272','147','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,293),('5','272','147','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,294),('5','272','148','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,295),('5','272','148','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,296),('5','272','149','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,297),('5','272','149','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,298),('5','272','150','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,299),('5','272','150','1',185.00,185.00,12086.53,0.00,0.00,0.00,0.00,300),('5','272','151','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,301),('5','272','151','1',185.00,185.00,11723.59,0.00,0.00,0.00,0.00,302),('5','272','152','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,303),('5','272','152','1',185.00,185.00,6640.74,0.00,0.00,0.00,0.00,304),('5','272','153','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,305),('5','272','153','1',185.00,185.00,7682.76,0.00,0.00,0.00,0.00,306),('5','272','154','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,307),('5','272','154','1',185.00,185.00,7015.17,0.00,0.00,0.00,0.00,308),('5','272','155','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,309),('5','272','155','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,310),('5','272','156','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,311),('5','272','156','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,312),('5','272','157','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,313),('5','272','157','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,314),('5','272','158','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,315),('5','272','158','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,316),('5','272','159','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,317),('5','272','159','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,318),('5','272','160','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,319),('5','272','160','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,320),('5','272','161','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,321),('5','272','161','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,322),('5','272','162','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,323),('5','272','162','1',185.00,185.00,15237.18,0.00,0.00,0.00,0.00,324),('5','272','163','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,325),('5','272','163','1',185.00,185.00,11949.17,0.00,0.00,0.00,0.00,326),('5','272','164','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,327),('5','272','164','1',185.00,185.00,12280.89,0.00,0.00,0.00,0.00,328),('5','272','165','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,329),('5','272','165','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,330),('5','272','166','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,331),('5','272','166','1',185.00,185.00,5645.21,0.00,0.00,0.00,0.00,332),('5','272','167','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,333),('5','272','167','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,334),('5','272','168','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,335),('5','272','168','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,336),('5','272','169','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,337),('5','272','169','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,338),('5','272','170','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,339),('5','272','170','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,340),('5','272','171','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,341),('5','272','171','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,342),('5','272','172','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,343),('5','272','172','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,344),('5','272','173','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,345),('5','272','173','1',185.00,185.00,7489.93,0.00,0.00,0.00,0.00,346),('5','272','174','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,347),('5','272','174','1',185.00,185.00,6488.06,0.00,0.00,0.00,0.00,348),('5','272','175','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,349),('5','272','175','1',185.00,185.00,20421.27,0.00,0.00,0.00,0.00,350),('5','272','176','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,351),('5','272','176','1',185.00,185.00,19247.42,0.00,0.00,0.00,0.00,352),('5','272','177','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,353),('5','272','177','1',185.00,185.00,22342.83,0.00,0.00,0.00,0.00,354),('5','272','178','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,355),('5','272','178','1',185.00,185.00,22472.50,0.00,0.00,0.00,0.00,356),('5','272','179','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,357),('5','272','179','1',185.00,185.00,22756.49,0.00,0.00,0.00,0.00,358),('5','272','180','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,359),('5','272','180','1',185.00,185.00,16144.14,0.00,0.00,0.00,0.00,360),('5','272','181','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,361),('5','272','181','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,362),('5','272','182','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,363),('5','272','182','1',185.00,185.00,23657.18,0.00,0.00,0.00,0.00,364),('5','272','183','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,365),('5','272','183','1',185.00,185.00,22375.40,0.00,0.00,0.00,0.00,366),('5','272','184','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,367),('5','272','184','1',185.00,185.00,24574.79,0.00,0.00,0.00,0.00,368),('5','272','185','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,369),('5','272','185','1',185.00,185.00,15584.99,0.00,0.00,0.00,0.00,370),('5','272','186','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,371),('5','272','186','1',185.00,185.00,14960.66,0.00,0.00,0.00,0.00,372),('5','272','187','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,373),('5','272','187','1',185.00,185.00,19825.76,0.00,0.00,0.00,0.00,374),('5','272','188','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,375),('5','272','188','1',185.00,185.00,7323.02,0.00,0.00,0.00,0.00,376),('5','272','189','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,377),('5','272','189','1',185.00,185.00,9329.50,0.00,0.00,0.00,0.00,378),('5','272','190','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,379),('5','272','190','1',185.00,185.00,8711.19,0.00,0.00,0.00,0.00,380),('5','272','191','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,381),('5','272','191','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,382),('5','272','192','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,383),('5','272','192','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,384),('5','272','193','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,385),('5','272','193','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,386),('5','272','194','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,387),('5','272','194','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,388),('5','272','195','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,389),('5','272','195','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,390),('5','272','196','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,391),('5','272','196','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,392),('5','272','197','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,393),('5','272','197','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,394),('5','272','198','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,395),('5','272','198','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,396),('5','272','199','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,397),('5','272','199','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,398),('5','272','200','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,399),('5','272','200','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,400),('5','272','201','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,401),('5','272','201','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,402),('5','272','202','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,403),('5','272','202','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,404),('5','272','203','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,405),('5','272','203','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,406),('5','272','204','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,407),('5','272','204','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,408),('5','272','205','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,409),('5','272','205','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,410),('5','272','206','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,411),('5','272','206','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,412),('5','272','207','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,413),('5','272','207','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,414),('5','272','208','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,415),('5','272','208','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,416),('5','272','209','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,417),('5','272','209','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,418),('5','272','210','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,419),('5','272','210','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,420),('5','272','211','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,421),('5','272','211','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,422),('5','272','212','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,423),('5','272','212','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,424),('5','272','213','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,425),('5','272','213','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,426),('5','272','214','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,427),('5','272','214','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,428),('5','272','215','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,429),('5','272','215','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,430),('5','272','216','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,431),('5','272','216','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,432),('5','272','217','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,433),('5','272','217','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,434),('5','272','218','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,435),('5','272','218','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,436),('5','272','219','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,437),('5','272','219','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,438),('5','272','220','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,439),('5','272','220','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,440),('5','272','221','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,441),('5','272','221','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,442),('5','272','222','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,443),('5','272','222','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,444),('5','272','223','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,445),('5','272','223','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,446),('5','272','224','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,447),('5','272','224','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,448),('5','272','225','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,449),('5','272','225','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,450),('5','272','226','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,451),('5','272','226','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,452),('5','272','227','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,453),('5','272','227','1',185.00,185.00,7303.68,0.00,0.00,0.00,0.00,454),('5','272','228','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,455),('5','272','228','1',185.00,185.00,7613.80,0.00,0.00,0.00,0.00,456),('5','272','229','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,457),('5','272','229','1',185.00,185.00,13673.47,0.00,0.00,0.00,0.00,458),('5','272','230','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,459),('5','272','230','1',185.00,185.00,10828.20,0.00,0.00,0.00,0.00,460),('5','272','231','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,461),('5','272','231','1',185.00,185.00,5667.16,0.00,0.00,0.00,0.00,462),('5','272','232','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,463),('5','272','232','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,464),('5','272','233','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,465),('5','272','233','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,466),('5','272','234','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,467),('5','272','234','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,468),('5','272','235','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,469),('5','272','235','1',185.00,185.00,2428.16,0.00,0.00,0.00,0.00,470),('5','272','236','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,471),('5','272','236','1',220.00,220.00,8378.87,0.00,0.00,0.00,0.00,472),('5','272','237','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,473),('5','272','237','1',220.00,220.00,4304.35,0.00,0.00,0.00,0.00,474),('5','272','238','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,475),('5','272','238','1',220.00,220.00,8485.42,0.00,0.00,0.00,0.00,476),('5','272','239','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,477),('5','272','239','1',220.00,220.00,8080.63,0.00,0.00,0.00,0.00,478),('5','272','240','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,479),('5','272','240','1',220.00,220.00,7873.65,0.00,0.00,0.00,0.00,480),('5','272','241','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,481),('5','272','241','1',220.00,220.00,5607.61,0.00,0.00,0.00,0.00,482),('5','272','242','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,483),('5','272','242','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,484),('5','272','243','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,485),('5','272','243','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,486),('5','272','244','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,487),('5','272','244','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,488),('5','272','245','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,489),('5','272','245','1',220.00,220.00,2765.25,0.00,0.00,0.00,0.00,490),('5','272','246','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,491),('5','272','246','1',220.00,220.00,6763.39,0.00,0.00,0.00,0.00,492),('5','272','247','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,493),('5','272','247','1',220.00,220.00,7518.22,0.00,0.00,0.00,0.00,494),('5','272','248','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,495),('5','272','248','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,496),('5','272','249','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,497),('5','272','249','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,498),('5','272','250','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,499),('5','272','250','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,500),('5','272','251','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,501),('5','272','251','1',220.00,220.00,1790.77,0.00,0.00,0.00,0.00,502),('5','272','252','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,503),('5','272','252','1',220.00,220.00,5406.23,0.00,0.00,0.00,0.00,504),('5','272','253','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,505),('5','272','253','1',220.00,220.00,2041.56,0.00,0.00,0.00,0.00,506),('5','272','254','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,507),('5','272','254','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,508),('5','272','255','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,509),('5','272','255','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,510),('5','272','256','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,511),('5','272','256','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,512),('5','272','257','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,513),('5','272','257','1',220.00,220.00,2041.48,0.00,0.00,0.00,0.00,514),('5','272','258','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,515),('5','272','258','1',220.00,220.00,3658.52,0.00,0.00,0.00,0.00,516),('5','272','259','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,517),('5','272','259','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,518),('5','272','260','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,519),('5','272','260','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,520),('5','272','261','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,521),('5','272','261','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,522),('5','272','262','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,523),('5','272','262','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,524),('5','272','263','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,525),('5','272','263','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,526),('5','272','264','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,527),('5','272','264','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,528),('5','272','265','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,529),('5','272','265','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,530),('5','272','266','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,531),('5','272','266','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,532),('5','272','267','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,533),('5','272','267','1',210.00,210.00,13300.73,0.00,0.00,0.00,0.00,534),('5','272','268','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,535),('5','272','268','1',210.00,210.00,15049.44,0.00,0.00,0.00,0.00,536),('5','272','269','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,537),('5','272','269','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,538),('5','272','270','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,539),('5','272','270','1',210.00,210.00,16310.72,0.00,0.00,0.00,0.00,540),('5','272','271','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,541),('5','272','271','1',210.00,210.00,12632.07,0.00,0.00,0.00,0.00,542),('5','272','272','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,543),('5','272','272','1',210.00,210.00,16442.76,0.00,0.00,0.00,0.00,544),('5','272','273','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,545),('5','272','273','1',210.00,210.00,7948.79,0.00,0.00,0.00,0.00,546),('5','272','274','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,547),('5','272','274','1',210.00,210.00,11562.23,0.00,0.00,0.00,0.00,548),('5','272','275','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,549),('5','272','275','1',210.00,210.00,7220.55,0.00,0.00,0.00,0.00,550),('5','272','276','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,551),('5','272','276','1',210.00,210.00,8201.40,0.00,0.00,0.00,0.00,552),('5','272','277','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,553),('5','272','277','1',210.00,210.00,3238.70,0.00,0.00,0.00,0.00,554),('5','272','278','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,555),('5','272','278','1',210.00,210.00,1587.26,0.00,0.00,0.00,0.00,556),('5','272','279','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,557),('5','272','279','1',210.00,210.00,9977.27,0.00,0.00,0.00,0.00,558),('5','272','280','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,559),('5','272','280','1',210.00,210.00,10613.16,0.00,0.00,0.00,0.00,560),('5','272','281','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,561),('5','272','281','1',210.00,210.00,8254.55,0.00,0.00,0.00,0.00,562),('5','272','282','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,563),('5','272','282','1',210.00,210.00,10462.31,0.00,0.00,0.00,0.00,564),('5','272','283','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,565),('5','272','283','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,566),('5','272','284','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,567),('5','272','284','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,568),('5','272','285','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,569),('5','272','285','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,570),('5','272','286','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,571),('5','272','286','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,572),('5','272','287','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,573),('5','272','287','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,574);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (1,'5','272','190','2022-12-08 11:40:06','877','1',185.00,8759.00,1620415.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',1,'272','TANK ','PMS TANKS'),('5',2,'272','AGO','AGO TANK');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','272','1',1,0,'1','TANK 1',31000.00,0.00,NULL,'PMS TANK 1','446','2022-06-02 10:34:11','2022-06-02 12:48:29','600',5,0),('5','272','1',2,0,'1','TANK 2',32000.00,0.00,NULL,'PMS TANK 2','446','2022-06-02 10:34:53','2022-06-02 12:48:47','600',5,0),('5','272','2',3,0,'2','AGO',31000.00,0.00,NULL,'AGO TANK 3','446','2022-06-02 10:35:36','2022-06-02 12:49:25','600',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','272',3,0.00,'2023-03-20 07:36:04'),(2,'5','272',2,821.06,'2023-03-20 07:36:04'),(3,'5','272',1,1070.22,'2023-03-20 07:36:04');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=888 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,4479750.00,27150.00,0.00,0.00,'2022-06-02 11:55:30','',''),(2,'5','272',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,8500.00,0.00,'2022-06-02 11:57:44','',''),(3,'5','272','1',1,'Received from bridging 1',0.00,0.00,8500.00,0.00,0.00,'2022-06-02 11:57:44','',''),(4,'5','272',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,18650.00,0.00,'2022-06-02 11:59:08','',''),(5,'5','272','2',1,'Received from bridging 2',0.00,0.00,18650.00,0.00,0.00,'2022-06-02 11:59:08','',''),(6,'5','272','1',1,'Sale Id shift 1',0.00,0.00,0.00,2378.16,0.00,'2022-06-02 13:00:18','',''),(7,'5','272','2',1,'Sale Id shift 1',0.00,0.00,0.00,2600.70,0.00,'2022-06-02 13:00:18','',''),(8,'5','272',NULL,1,'Sale Id shift 1',821511.90,0.00,0.00,0.00,0.00,'2022-06-02 13:00:18','',''),(9,'5','272','1',1,'Sale Id shift 2',0.00,0.00,0.00,6028.77,0.00,'2022-06-02 21:31:40','',''),(10,'5','272',NULL,1,'Sale Id shift 2',994747.05,0.00,0.00,0.00,0.00,'2022-06-02 21:31:40','',''),(11,'5','272','2',1,'Sale Id shift 3',0.00,0.00,0.00,3310.96,0.00,'2022-06-04 06:04:58','',''),(12,'5','272',NULL,1,'Sale Id shift 3',546308.40,0.00,0.00,0.00,0.00,'2022-06-04 06:04:58','',''),(13,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,2508000.00,15200.00,0.00,0.00,'2022-06-04 15:25:13','',''),(14,'5','272',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,15200.00,0.00,'2022-06-04 18:02:04','',''),(15,'5','272','2',1,'Received from bridging 4',0.00,0.00,15200.00,0.00,0.00,'2022-06-04 18:02:04','',''),(16,'5','272','2',1,'Sale Id shift 4',0.00,0.00,0.00,8295.06,0.00,'2022-06-05 06:05:56','',''),(17,'5','272',NULL,1,'Sale Id shift 4',1368684.90,0.00,0.00,0.00,0.00,'2022-06-05 06:05:56','',''),(18,'5','272','2',1,'Sale Id shift 5',0.00,0.00,0.00,2714.04,0.00,'2022-06-06 06:25:37','',''),(19,'5','272',NULL,1,'Sale Id shift 5',447816.60,0.00,0.00,0.00,0.00,'2022-06-06 06:25:37','',''),(20,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7342500.00,44500.00,0.00,0.00,'2022-06-06 22:31:00','',''),(21,'5','272',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,29500.00,0.00,'2022-06-06 23:18:08','',''),(22,'5','272','1',1,'Received from bridging 5',0.00,0.00,29500.00,0.00,0.00,'2022-06-06 23:18:08','',''),(23,'5','272',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 23:18:21','',''),(24,'5','272','2',1,'Received from bridging 6',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 23:18:21','',''),(25,'5','272','1',1,'Sale Id shift 6',0.00,0.00,0.00,2349.59,0.00,'2022-06-07 07:25:13','',''),(26,'5','272','2',1,'Sale Id shift 6',0.00,0.00,0.00,6442.18,0.00,'2022-06-07 07:25:13','',''),(27,'5','272',NULL,1,'Sale Id shift 6',1450642.05,0.00,0.00,0.00,0.00,'2022-06-07 07:25:13','',''),(28,'5','272','1',1,'Sale Id shift 7',0.00,0.00,0.00,20.00,0.00,'2022-06-08 10:30:37','',''),(29,'5','272','1',1,'Sale Id shift 7',0.00,0.00,0.00,7722.60,0.00,'2022-06-08 10:30:37','',''),(30,'5','272','2',1,'Sale Id shift 7',0.00,0.00,0.00,20.00,0.00,'2022-06-08 10:30:37','',''),(31,'5','272','2',1,'Sale Id shift 7',0.00,0.00,0.00,3060.53,0.00,'2022-06-08 10:30:37','',''),(32,'5','272',NULL,1,'Sale Id shift 7',1785816.45,0.00,0.00,0.00,0.00,'2022-06-08 10:30:37','',''),(33,'5','272','2',1,'Sale Id shift 8',0.00,0.00,0.00,5251.68,0.00,'2022-06-09 23:02:10','',''),(34,'5','272','2',1,'Sale Id shift 8',0.00,0.00,0.00,4472.87,0.00,'2022-06-09 23:02:10','',''),(35,'5','272',NULL,1,'Sale Id shift 8',1604550.75,0.00,0.00,0.00,0.00,'2022-06-09 23:02:10','',''),(36,'5','272','2',1,'Sale Id shift 9',0.00,0.00,0.00,3011.02,0.00,'2022-06-10 05:24:33','',''),(37,'5','272','2',1,'Sale Id shift 9',0.00,0.00,0.00,3095.29,0.00,'2022-06-10 05:24:33','',''),(38,'5','272',NULL,1,'Sale Id shift 9',1007541.15,0.00,0.00,0.00,0.00,'2022-06-10 05:24:33','',''),(39,'5','272','1',1,'Sale Id shift 10',0.00,0.00,0.00,5101.29,0.00,'2022-06-10 21:42:03','',''),(40,'5','272',NULL,1,'Sale Id shift 10',841712.85,0.00,0.00,0.00,0.00,'2022-06-10 21:42:03','',''),(41,'5','272','1',1,'Sale Id shift 11',0.00,0.00,0.00,3502.27,0.00,'2022-06-12 08:29:23','',''),(42,'5','272',NULL,1,'Sale Id shift 11',577874.55,0.00,0.00,0.00,0.00,'2022-06-12 08:29:23','',''),(43,'5','272','1',1,'Sale Id shift 12',0.00,0.00,0.00,2020.31,0.00,'2022-06-13 06:53:19','',''),(44,'5','272',NULL,1,'Sale Id shift 12',333351.15,0.00,0.00,0.00,0.00,'2022-06-13 06:53:19','',''),(45,'5','272','1',1,'Sale Id shift 13',0.00,0.00,0.00,2119.64,0.00,'2022-06-14 08:57:05','',''),(46,'5','272',NULL,1,'Sale Id shift 13',349740.60,0.00,0.00,0.00,0.00,'2022-06-14 08:57:05','',''),(47,'5','272','1',1,'Sale Id shift 14',0.00,0.00,0.00,1055.08,0.00,'2022-06-15 07:35:47','',''),(48,'5','272','2',1,'Sale Id shift 14',0.00,0.00,0.00,810.89,0.00,'2022-06-15 07:35:47','',''),(49,'5','272',NULL,1,'Sale Id shift 14',307885.05,0.00,0.00,0.00,0.00,'2022-06-15 07:35:47','',''),(50,'5','272','1',1,'Sale Id shift 15',0.00,0.00,0.00,3081.31,0.00,'2022-06-16 07:00:38','',''),(51,'5','272',NULL,1,'Sale Id shift 15',508416.15,0.00,0.00,0.00,0.00,'2022-06-16 07:00:38','',''),(52,'5','272','2',1,'Sale Id shift 16',0.00,0.00,0.00,1910.49,0.00,'2022-06-17 05:58:56','',''),(53,'5','272',NULL,1,'Sale Id shift 16',315230.85,0.00,0.00,0.00,0.00,'2022-06-17 05:58:56','',''),(54,'5','272','1',1,'Sale Id shift 17',0.00,0.00,0.00,2252.46,0.00,'2022-06-18 07:01:47','',''),(55,'5','272',NULL,1,'Sale Id shift 17',371655.90,0.00,0.00,0.00,0.00,'2022-06-18 07:01:47','',''),(56,'5','272','2',1,'Sale Id shift 18',0.00,0.00,0.00,2000.01,0.00,'2022-06-18 22:46:10','',''),(57,'5','272',NULL,1,'Sale Id shift 18',330001.65,0.00,0.00,0.00,0.00,'2022-06-18 22:46:10','',''),(58,'5','272','2',1,'Sale Id shift 19',0.00,0.00,0.00,1621.00,0.00,'2022-06-20 06:45:25','',''),(59,'5','272',NULL,1,'Sale Id shift 19',267465.00,0.00,0.00,0.00,0.00,'2022-06-20 06:45:25','',''),(60,'5','272','1',1,'Sale Id shift 20',0.00,0.00,0.00,262.16,0.00,'2022-06-21 07:53:30','',''),(61,'5','272',NULL,1,'Sale Id shift 20',43256.40,0.00,0.00,0.00,0.00,'2022-06-21 07:53:30','',''),(62,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,3712500.00,22500.00,0.00,0.00,'2022-07-07 19:45:59','',''),(63,'5','272',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,22500.00,0.00,'2022-07-07 21:59:35','',''),(64,'5','272','2',1,'Received from bridging 7',0.00,0.00,22500.00,0.00,0.00,'2022-07-07 21:59:35','',''),(65,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,22733.28,0.00,'2022-07-10 17:39:47','',''),(66,'5','272','2',0,'Inventory adjustment from tank dipping to 22900',0.00,0.00,22900.00,0.00,0.00,'2022-07-10 17:39:47','',''),(67,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,106.36,0.00,'2022-07-10 17:43:14','',''),(68,'5','272','1',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-07-10 17:43:14','',''),(69,'5','272','1',1,'Sale Id shift 37',0.00,0.00,0.00,463.10,0.00,'2022-07-10 17:45:01','',''),(70,'5','272','2',1,'Sale Id shift 37',0.00,0.00,0.00,461.88,0.00,'2022-07-10 17:45:01','',''),(71,'5','272','2',1,'Sale Id shift 37',0.00,0.00,0.00,142.50,0.00,'2022-07-10 17:45:01','',''),(72,'5','272',NULL,1,'Sale Id shift 37',176134.20,0.00,0.00,0.00,0.00,'2022-07-10 17:45:01','',''),(73,'5','272','2',1,'Sale Id shift 38',0.00,0.00,0.00,2112.15,0.00,'2022-07-11 08:18:12','',''),(74,'5','272','2',1,'Sale Id shift 38',0.00,0.00,0.00,3439.31,0.00,'2022-07-11 08:18:12','',''),(75,'5','272',NULL,1,'Sale Id shift 38',915990.90,0.00,0.00,0.00,0.00,'2022-07-11 08:18:12','',''),(76,'5','272','2',1,'Sale Id shift 39',0.00,0.00,0.00,1341.89,0.00,'2022-07-11 08:32:52','',''),(77,'5','272','2',1,'Sale Id shift 39',0.00,0.00,0.00,700.00,0.00,'2022-07-11 08:32:52','',''),(78,'5','272',NULL,1,'Sale Id shift 39',377749.65,0.00,0.00,0.00,0.00,'2022-07-11 08:32:52','',''),(79,'5','272','2',1,'Sale Id shift 40',0.00,0.00,0.00,2524.73,0.00,'2022-07-11 08:44:16','',''),(80,'5','272',NULL,1,'Sale Id shift 40',467075.05,0.00,0.00,0.00,0.00,'2022-07-11 08:44:16','',''),(81,'5','272','2',1,'Sale Id shift 41',0.00,0.00,0.00,1915.72,0.00,'2022-07-12 05:21:19','',''),(82,'5','272','2',1,'Sale Id shift 41',0.00,0.00,0.00,2354.56,0.00,'2022-07-12 05:21:19','',''),(83,'5','272',NULL,1,'Sale Id shift 41',790001.80,0.00,0.00,0.00,0.00,'2022-07-12 05:21:19','',''),(84,'5','272','2',1,'Sale Id shift 42',0.00,0.00,0.00,2072.18,0.00,'2022-07-13 07:16:58','',''),(85,'5','272',NULL,1,'Sale Id shift 42',383353.30,0.00,0.00,0.00,0.00,'2022-07-13 07:16:58','',''),(86,'5','272','2',1,'Sale Id shift 43',0.00,0.00,0.00,2462.34,0.00,'2022-07-14 06:31:32','',''),(87,'5','272',NULL,1,'Sale Id shift 43',455532.90,0.00,0.00,0.00,0.00,'2022-07-14 06:31:32','',''),(88,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-07-14 21:29:17','',''),(89,'5','272',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,14000.00,0.00,'2022-07-14 22:12:32','',''),(90,'5','272','2',1,'Received from bridging 9',0.00,0.00,14000.00,0.00,0.00,'2022-07-14 22:12:32','',''),(91,'5','272',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,26000.00,0.00,'2022-07-14 22:12:59','',''),(92,'5','272','1',1,'Received from bridging 8',0.00,0.00,26000.00,0.00,0.00,'2022-07-14 22:12:59','',''),(93,'5','272','2',1,'Sale Id shift 44',0.00,0.00,0.00,2919.60,0.00,'2022-07-15 07:15:57','',''),(94,'5','272',NULL,1,'Sale Id shift 44',540126.00,0.00,0.00,0.00,0.00,'2022-07-15 07:15:57','',''),(95,'5','272','1',1,'Sale Id shift 45',0.00,0.00,0.00,2647.55,0.00,'2022-07-16 06:52:10','',''),(96,'5','272','1',1,'Sale Id shift 45',0.00,0.00,0.00,3569.93,0.00,'2022-07-16 06:52:10','',''),(97,'5','272','2',1,'Sale Id shift 45',0.00,0.00,0.00,5222.88,0.00,'2022-07-16 06:52:10','',''),(98,'5','272','2',1,'Sale Id shift 45',0.00,0.00,0.00,435.13,0.00,'2022-07-16 06:52:10','',''),(99,'5','272',NULL,1,'Sale Id shift 45',2196965.65,0.00,0.00,0.00,0.00,'2022-07-16 06:52:10','',''),(100,'5','272','1',1,'Sale Id shift 46',0.00,0.00,0.00,3582.43,0.00,'2022-07-17 05:28:12','',''),(101,'5','272','1',1,'Sale Id shift 46',0.00,0.00,0.00,3227.66,0.00,'2022-07-17 05:28:12','',''),(102,'5','272','2',1,'Sale Id shift 46',0.00,0.00,0.00,3484.19,0.00,'2022-07-17 05:28:12','',''),(103,'5','272',NULL,1,'Sale Id shift 46',1904441.80,0.00,0.00,0.00,0.00,'2022-07-17 05:28:12','',''),(104,'5','272','1',1,'Sale Id shift 47',0.00,0.00,0.00,3697.78,0.00,'2022-07-18 07:32:47','',''),(105,'5','272','1',1,'Sale Id shift 47',0.00,0.00,0.00,4530.01,0.00,'2022-07-18 07:32:47','',''),(106,'5','272','2',1,'Sale Id shift 47',0.00,0.00,0.00,2000.00,0.00,'2022-07-18 07:32:47','',''),(107,'5','272',NULL,1,'Sale Id shift 47',1892141.15,0.00,0.00,0.00,0.00,'2022-07-18 07:32:47','',''),(108,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,4881.54,0.00,'2022-07-19 10:40:29','',''),(109,'5','272','1',0,'Inventory adjustment from tank dipping to 3400',0.00,0.00,3400.00,0.00,0.00,'2022-07-19 10:40:29','',''),(110,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,3310.94,0.00,'2022-07-19 10:40:52','',''),(111,'5','272','2',0,'Inventory adjustment from tank dipping to 4800',0.00,0.00,4800.00,0.00,0.00,'2022-07-19 10:40:52','',''),(112,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,3400.00,0.00,'2022-07-19 12:12:42','',''),(113,'5','272','1',0,'Inventory adjustment from tank dipping to 5600',0.00,0.00,5600.00,0.00,0.00,'2022-07-19 12:12:42','',''),(114,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,4800.00,0.00,'2022-07-19 12:12:58','',''),(115,'5','272','2',0,'Inventory adjustment from tank dipping to 2800',0.00,0.00,2800.00,0.00,0.00,'2022-07-19 12:12:58','',''),(116,'5','272','1',1,'Sale Id shift 48',0.00,0.00,0.00,2765.54,0.00,'2022-07-19 12:16:04','',''),(117,'5','272','1',1,'Sale Id shift 48',0.00,0.00,0.00,2786.00,0.00,'2022-07-19 12:16:04','',''),(118,'5','272','2',1,'Sale Id shift 48',0.00,0.00,0.00,1132.03,0.00,'2022-07-19 12:16:04','',''),(119,'5','272','2',1,'Sale Id shift 48',0.00,0.00,0.00,1601.38,0.00,'2022-07-19 12:16:04','',''),(120,'5','272',NULL,1,'Sale Id shift 48',1532715.75,0.00,0.00,0.00,0.00,'2022-07-19 12:16:04','',''),(121,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,11081500.00,59900.00,0.00,0.00,'2022-07-20 11:32:36','',''),(122,'5','272',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,29900.00,0.00,'2022-07-20 12:00:28','',''),(123,'5','272','2',1,'Received from bridging 11',0.00,0.00,29900.00,0.00,0.00,'2022-07-20 12:00:28','',''),(124,'5','272',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,30000.00,0.00,'2022-07-20 12:00:38','',''),(125,'5','272','1',1,'Received from bridging 10',0.00,0.00,30000.00,0.00,0.00,'2022-07-20 12:00:38','',''),(126,'5','272','1',1,'Sale Id shift 49',0.00,0.00,0.00,4414.48,0.00,'2022-07-20 12:58:23','',''),(127,'5','272','1',1,'Sale Id shift 49',0.00,0.00,0.00,2877.67,0.00,'2022-07-20 12:58:23','',''),(128,'5','272','2',1,'Sale Id shift 49',0.00,0.00,0.00,3506.32,0.00,'2022-07-20 12:58:23','',''),(129,'5','272','2',1,'Sale Id shift 49',0.00,0.00,0.00,2449.41,0.00,'2022-07-20 12:58:23','',''),(130,'5','272',NULL,1,'Sale Id shift 49',2450857.80,0.00,0.00,0.00,0.00,'2022-07-20 12:58:23','',''),(131,'5','272','1',1,'Sale Id shift 50',0.00,0.00,0.00,5709.43,0.00,'2022-07-21 06:47:33','',''),(132,'5','272','1',1,'Sale Id shift 50',0.00,0.00,0.00,3418.44,0.00,'2022-07-21 06:47:33','',''),(133,'5','272','2',1,'Sale Id shift 50',0.00,0.00,0.00,3169.85,0.00,'2022-07-21 06:47:33','',''),(134,'5','272','2',1,'Sale Id shift 50',0.00,0.00,0.00,4157.36,0.00,'2022-07-21 06:47:33','',''),(135,'5','272',NULL,1,'Sale Id shift 50',3044189.80,0.00,0.00,0.00,0.00,'2022-07-21 06:47:33','',''),(136,'5','272','1',1,'Sale Id shift 51',0.00,0.00,0.00,4141.36,0.00,'2022-07-21 23:17:29','',''),(137,'5','272','1',1,'Sale Id shift 51',0.00,0.00,0.00,3892.24,0.00,'2022-07-21 23:17:29','',''),(138,'5','272','2',1,'Sale Id shift 51',0.00,0.00,0.00,3924.63,0.00,'2022-07-21 23:17:29','',''),(139,'5','272','2',1,'Sale Id shift 51',0.00,0.00,0.00,3170.02,0.00,'2022-07-21 23:17:29','',''),(140,'5','272',NULL,1,'Sale Id shift 51',2798726.25,0.00,0.00,0.00,0.00,'2022-07-21 23:17:29','',''),(141,'5','272','1',1,'Sale Id shift 52',0.00,0.00,0.00,1561.60,0.00,'2022-07-23 06:53:17','',''),(142,'5','272','1',1,'Sale Id shift 52',0.00,0.00,0.00,2709.89,0.00,'2022-07-23 06:53:17','',''),(143,'5','272','2',1,'Sale Id shift 52',0.00,0.00,0.00,1584.75,0.00,'2022-07-23 06:53:17','',''),(144,'5','272','2',1,'Sale Id shift 52',0.00,0.00,0.00,947.48,0.00,'2022-07-23 06:53:17','',''),(145,'5','272',NULL,1,'Sale Id shift 52',1258688.20,0.00,0.00,0.00,0.00,'2022-07-23 06:53:17','',''),(146,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7418500.00,40100.00,0.00,0.00,'2022-07-23 20:46:08','',''),(147,'5','272',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,27100.00,0.00,'2022-07-24 07:05:41','',''),(148,'5','272','1',1,'Received from bridging 12',0.00,0.00,27100.00,0.00,0.00,'2022-07-24 07:05:41','',''),(149,'5','272',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,13000.00,0.00,'2022-07-24 07:05:53','',''),(150,'5','272','2',1,'Received from bridging 13',0.00,0.00,13000.00,0.00,0.00,'2022-07-24 07:05:53','',''),(151,'5','272','1',1,'Sale Id shift 53',0.00,0.00,0.00,606.80,0.00,'2022-07-24 08:30:55','',''),(152,'5','272','1',1,'Sale Id shift 53',0.00,0.00,0.00,700.72,0.00,'2022-07-24 08:30:55','',''),(153,'5','272','2',1,'Sale Id shift 53',0.00,0.00,0.00,3729.08,0.00,'2022-07-24 08:30:55','',''),(154,'5','272','2',1,'Sale Id shift 53',0.00,0.00,0.00,3437.83,0.00,'2022-07-24 08:30:55','',''),(155,'5','272',NULL,1,'Sale Id shift 53',1567769.55,0.00,0.00,0.00,0.00,'2022-07-24 08:30:55','',''),(156,'5','272','1',1,'Sale Id shift 54',0.00,0.00,0.00,3823.40,0.00,'2022-07-25 06:43:31','',''),(157,'5','272','1',1,'Sale Id shift 54',0.00,0.00,0.00,4525.80,0.00,'2022-07-25 06:43:31','',''),(158,'5','272','2',1,'Sale Id shift 54',0.00,0.00,0.00,1393.59,0.00,'2022-07-25 06:43:31','',''),(159,'5','272','2',1,'Sale Id shift 54',0.00,0.00,0.00,4639.20,0.00,'2022-07-25 06:43:31','',''),(160,'5','272',NULL,1,'Sale Id shift 54',2660668.15,0.00,0.00,0.00,0.00,'2022-07-25 06:43:31','',''),(161,'5','272','1',1,'Sale Id shift 55',0.00,0.00,0.00,2082.71,0.00,'2022-07-26 05:52:23','',''),(162,'5','272','1',1,'Sale Id shift 55',0.00,0.00,0.00,2409.52,0.00,'2022-07-26 05:52:23','',''),(163,'5','272','2',1,'Sale Id shift 55',0.00,0.00,0.00,56.12,0.00,'2022-07-26 05:52:23','',''),(164,'5','272','2',1,'Sale Id shift 55',0.00,0.00,0.00,4837.72,0.00,'2022-07-26 05:52:23','',''),(165,'5','272',NULL,1,'Sale Id shift 55',1736422.95,0.00,0.00,0.00,0.00,'2022-07-26 05:52:23','',''),(166,'5','272','1',1,'Sale Id shift 56',0.00,0.00,0.00,2000.00,0.00,'2022-07-27 06:03:09','',''),(167,'5','272','1',1,'Sale Id shift 56',0.00,0.00,0.00,6145.00,0.00,'2022-07-27 06:03:09','',''),(168,'5','272',NULL,1,'Sale Id shift 56',1506825.00,0.00,0.00,0.00,0.00,'2022-07-27 06:03:09','',''),(169,'5','272','1',1,'Sale Id shift 57',0.00,0.00,0.00,1809.00,0.00,'2022-07-28 06:52:24','',''),(170,'5','272',NULL,1,'Sale Id shift 57',334665.00,0.00,0.00,0.00,0.00,'2022-07-28 06:52:24','',''),(171,'5','272','1',1,'Sale Id shift 58',0.00,0.00,0.00,1456.63,0.00,'2022-07-29 07:11:00','',''),(172,'5','272',NULL,1,'Sale Id shift 58',269476.55,0.00,0.00,0.00,0.00,'2022-07-29 07:11:00','',''),(173,'5','272','1',1,'Sale Id shift 59',0.00,0.00,0.00,1687.24,0.00,'2022-07-30 05:46:25','',''),(174,'5','272',NULL,1,'Sale Id shift 59',312139.40,0.00,0.00,0.00,0.00,'2022-07-30 05:46:25','',''),(175,'5','272','2',1,'Sale Id shift 60',0.00,0.00,0.00,1500.68,0.00,'2022-07-31 05:21:53','',''),(176,'5','272',NULL,1,'Sale Id shift 60',277625.80,0.00,0.00,0.00,0.00,'2022-07-31 05:21:53','',''),(177,'5','272','1',1,'Sale Id shift 61',0.00,0.00,0.00,1100.00,0.00,'2022-08-01 07:47:38','',''),(178,'5','272','2',1,'Sale Id shift 61',0.00,0.00,0.00,445.47,0.00,'2022-08-01 07:47:38','',''),(179,'5','272',NULL,1,'Sale Id shift 61',285911.95,0.00,0.00,0.00,0.00,'2022-08-01 07:47:38','',''),(180,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7381500.00,39900.00,0.00,0.00,'2022-08-01 21:18:23','',''),(181,'5','272',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,11900.00,0.00,'2022-08-01 21:29:43','',''),(182,'5','272','1',1,'Received from bridging 14',0.00,0.00,11900.00,0.00,0.00,'2022-08-01 21:29:43','',''),(183,'5','272',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,28000.00,0.00,'2022-08-01 21:29:54','',''),(184,'5','272','2',1,'Received from bridging 15',0.00,0.00,28000.00,0.00,0.00,'2022-08-01 21:29:54','',''),(185,'5','272','2',1,'Sale Id shift 63',0.00,0.00,0.00,3817.83,0.00,'2022-08-03 06:56:53','',''),(186,'5','272',NULL,1,'Sale Id shift 63',706298.55,0.00,0.00,0.00,0.00,'2022-08-03 06:56:53','',''),(187,'5','272','1',1,'Sale Id shift 64',0.00,0.00,0.00,5302.25,0.00,'2022-08-04 06:13:20','',''),(188,'5','272','1',1,'Sale Id shift 64',0.00,0.00,0.00,4157.68,0.00,'2022-08-04 06:13:20','',''),(189,'5','272','2',1,'Sale Id shift 64',0.00,0.00,0.00,3428.50,0.00,'2022-08-04 06:13:20','',''),(190,'5','272','2',1,'Sale Id shift 64',0.00,0.00,0.00,7205.83,0.00,'2022-08-04 06:13:20','',''),(191,'5','272',NULL,1,'Sale Id shift 64',3717438.10,0.00,0.00,0.00,0.00,'2022-08-04 06:13:20','',''),(192,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8214000.00,44400.00,0.00,0.00,'2022-08-04 17:11:42','',''),(193,'5','272',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,28400.00,0.00,'2022-08-04 20:04:17','',''),(194,'5','272','1',1,'Received from bridging 16',0.00,0.00,28400.00,0.00,0.00,'2022-08-04 20:04:17','',''),(195,'5','272',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,16000.00,0.00,'2022-08-04 20:04:29','',''),(196,'5','272','2',1,'Received from bridging 17',0.00,0.00,16000.00,0.00,0.00,'2022-08-04 20:04:29','',''),(197,'5','272','1',1,'Sale Id shift 65',0.00,0.00,0.00,516.00,0.00,'2022-08-05 06:33:10','',''),(198,'5','272','1',1,'Sale Id shift 65',0.00,0.00,0.00,957.95,0.00,'2022-08-05 06:33:10','',''),(199,'5','272','2',1,'Sale Id shift 65',0.00,0.00,0.00,746.36,0.00,'2022-08-05 06:33:10','',''),(200,'5','272',NULL,1,'Sale Id shift 65',410757.35,0.00,0.00,0.00,0.00,'2022-08-05 06:33:10','',''),(201,'5','272','1',1,'Sale Id shift 66',0.00,0.00,0.00,1294.56,0.00,'2022-08-06 06:59:22','',''),(202,'5','272','1',1,'Sale Id shift 66',0.00,0.00,0.00,1630.09,0.00,'2022-08-06 06:59:22','',''),(203,'5','272','2',1,'Sale Id shift 66',0.00,0.00,0.00,1422.75,0.00,'2022-08-06 06:59:22','',''),(204,'5','272',NULL,1,'Sale Id shift 66',804269.00,0.00,0.00,0.00,0.00,'2022-08-06 06:59:22','',''),(205,'5','272','1',1,'Sale Id shift 67',0.00,0.00,0.00,2612.96,0.00,'2022-08-07 05:33:52','',''),(206,'5','272','1',1,'Sale Id shift 67',0.00,0.00,0.00,3289.15,0.00,'2022-08-07 05:33:52','',''),(207,'5','272','2',1,'Sale Id shift 67',0.00,0.00,0.00,3464.83,0.00,'2022-08-07 05:33:52','',''),(208,'5','272',NULL,1,'Sale Id shift 67',1732883.90,0.00,0.00,0.00,0.00,'2022-08-07 05:33:52','',''),(209,'5','272','1',1,'Sale Id shift 68',0.00,0.00,0.00,2223.57,0.00,'2022-09-05 06:47:20','',''),(210,'5','272','1',1,'Sale Id shift 68',0.00,0.00,0.00,3044.52,0.00,'2022-09-05 06:47:20','',''),(211,'5','272','2',1,'Sale Id shift 68',0.00,0.00,0.00,2666.00,0.00,'2022-09-05 06:47:20','',''),(212,'5','272',NULL,1,'Sale Id shift 68',1467806.65,0.00,0.00,0.00,0.00,'2022-09-05 06:47:20','',''),(213,'5','272','1',1,'Sale Id shift 69',0.00,0.00,0.00,3583.78,0.00,'2022-09-06 11:49:20','',''),(214,'5','272','1',1,'Sale Id shift 69',0.00,0.00,0.00,5131.85,0.00,'2022-09-06 11:49:20','',''),(215,'5','272','2',1,'Sale Id shift 69',0.00,0.00,0.00,5371.57,0.00,'2022-09-06 11:49:20','',''),(216,'5','272',NULL,1,'Sale Id shift 69',2606132.00,0.00,0.00,0.00,0.00,'2022-09-06 11:49:20','',''),(217,'5','272','1',1,'Sale Id shift 70',0.00,0.00,0.00,3114.23,0.00,'2022-09-06 12:04:28','',''),(218,'5','272','1',1,'Sale Id shift 70',0.00,0.00,0.00,2889.35,0.00,'2022-09-06 12:04:28','',''),(219,'5','272','2',1,'Sale Id shift 70',0.00,0.00,0.00,1660.74,0.00,'2022-09-06 12:04:28','',''),(220,'5','272','2',1,'Sale Id shift 70',0.00,0.00,0.00,4422.50,0.00,'2022-09-06 12:04:28','',''),(221,'5','272',NULL,1,'Sale Id shift 70',2236061.70,0.00,0.00,0.00,0.00,'2022-09-06 12:04:28','',''),(222,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,6055050.00,32730.00,0.00,0.00,'2022-09-06 12:10:08','',''),(223,'5','272',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,5400.00,0.00,'2022-09-06 12:20:05','',''),(224,'5','272','2',1,'Received from bridging 19',0.00,0.00,5400.00,0.00,0.00,'2022-09-06 12:20:05','',''),(225,'5','272',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,27330.00,0.00,'2022-09-06 12:20:13','',''),(226,'5','272','1',1,'Received from bridging 18',0.00,0.00,27330.00,0.00,0.00,'2022-09-06 12:20:13','',''),(227,'5','272','1',1,'Sale Id shift 71',0.00,0.00,0.00,1988.45,0.00,'2022-09-06 12:24:51','',''),(228,'5','272','1',1,'Sale Id shift 71',0.00,0.00,0.00,7004.57,0.00,'2022-09-06 12:24:51','',''),(229,'5','272','2',1,'Sale Id shift 71',0.00,0.00,0.00,929.67,0.00,'2022-09-06 12:24:51','',''),(230,'5','272','2',1,'Sale Id shift 71',0.00,0.00,0.00,5080.55,0.00,'2022-09-06 12:24:51','',''),(231,'5','272',NULL,1,'Sale Id shift 71',2775599.40,0.00,0.00,0.00,0.00,'2022-09-06 12:24:51','',''),(232,'5','272','1',1,'Sale Id shift 72',0.00,0.00,0.00,2111.49,0.00,'2022-09-06 12:31:21','',''),(233,'5','272','1',1,'Sale Id shift 72',0.00,0.00,0.00,6479.09,0.00,'2022-09-06 12:31:21','',''),(234,'5','272','2',1,'Sale Id shift 72',0.00,0.00,0.00,2199.86,0.00,'2022-09-06 12:31:21','',''),(235,'5','272','2',1,'Sale Id shift 72',0.00,0.00,0.00,4254.15,0.00,'2022-09-06 12:31:21','',''),(236,'5','272',NULL,1,'Sale Id shift 72',2783249.15,0.00,0.00,0.00,0.00,'2022-09-06 12:31:21','',''),(237,'5','272','1',1,'Sale Id shift 73',0.00,0.00,0.00,3910.66,0.00,'2022-09-06 12:35:46','',''),(238,'5','272','1',1,'Sale Id shift 73',0.00,0.00,0.00,4674.05,0.00,'2022-09-06 12:35:46','',''),(239,'5','272','2',1,'Sale Id shift 73',0.00,0.00,0.00,2729.21,0.00,'2022-09-06 12:35:46','',''),(240,'5','272',NULL,1,'Sale Id shift 73',2093075.20,0.00,0.00,0.00,0.00,'2022-09-06 12:35:46','',''),(241,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8195500.00,44300.00,0.00,0.00,'2022-09-06 13:05:15','',''),(242,'5','272',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 13:22:34','',''),(243,'5','272','2',1,'Received from bridging 21',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 13:22:34','',''),(244,'5','272',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,14300.00,0.00,'2022-09-06 13:22:42','',''),(245,'5','272','1',1,'Received from bridging 20',0.00,0.00,14300.00,0.00,0.00,'2022-09-06 13:22:42','',''),(246,'5','272','1',1,'Sale Id shift 74',0.00,0.00,0.00,3339.88,0.00,'2022-09-06 13:26:53','',''),(247,'5','272','1',1,'Sale Id shift 74',0.00,0.00,0.00,5610.42,0.00,'2022-09-06 13:26:53','',''),(248,'5','272','2',1,'Sale Id shift 74',0.00,0.00,0.00,1675.91,0.00,'2022-09-06 13:26:53','',''),(249,'5','272','2',1,'Sale Id shift 74',0.00,0.00,0.00,3023.61,0.00,'2022-09-06 13:26:53','',''),(250,'5','272',NULL,1,'Sale Id shift 74',2525216.70,0.00,0.00,0.00,0.00,'2022-09-06 13:26:53','',''),(251,'5','272','1',1,'Sale Id shift 75',0.00,0.00,0.00,3974.71,0.00,'2022-09-06 13:49:15','',''),(252,'5','272','1',1,'Sale Id shift 75',0.00,0.00,0.00,3072.27,0.00,'2022-09-06 13:49:15','',''),(253,'5','272','2',1,'Sale Id shift 75',0.00,0.00,0.00,5121.41,0.00,'2022-09-06 13:49:15','',''),(254,'5','272','2',1,'Sale Id shift 75',0.00,0.00,0.00,213.76,0.00,'2022-09-06 13:49:15','',''),(255,'5','272',NULL,1,'Sale Id shift 75',2290697.75,0.00,0.00,0.00,0.00,'2022-09-06 13:49:15','',''),(256,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7316750.00,39550.00,0.00,0.00,'2022-09-06 14:10:15','',''),(257,'5','272',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,8650.00,0.00,'2022-09-06 14:25:35','',''),(258,'5','272','2',1,'Received from bridging 23',0.00,0.00,8650.00,0.00,0.00,'2022-09-06 14:25:35','',''),(259,'5','272',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30900.00,0.00,'2022-09-06 14:25:44','',''),(260,'5','272','1',1,'Received from bridging 22',0.00,0.00,30900.00,0.00,0.00,'2022-09-06 14:25:44','',''),(261,'5','272','1',1,'Sale Id shift 76',0.00,0.00,0.00,3585.46,0.00,'2022-09-06 14:27:58','',''),(262,'5','272','1',1,'Sale Id shift 76',0.00,0.00,0.00,4983.58,0.00,'2022-09-06 14:27:58','',''),(263,'5','272','2',1,'Sale Id shift 76',0.00,0.00,0.00,2913.71,0.00,'2022-09-06 14:27:58','',''),(264,'5','272','2',1,'Sale Id shift 76',0.00,0.00,0.00,306.44,0.00,'2022-09-06 14:27:58','',''),(265,'5','272',NULL,1,'Sale Id shift 76',2181000.15,0.00,0.00,0.00,0.00,'2022-09-06 14:27:58','',''),(266,'5','272','1',1,'Sale Id shift 77',0.00,0.00,0.00,3105.87,0.00,'2022-09-06 14:31:41','',''),(267,'5','272','1',1,'Sale Id shift 77',0.00,0.00,0.00,3355.80,0.00,'2022-09-06 14:31:41','',''),(268,'5','272','2',1,'Sale Id shift 77',0.00,0.00,0.00,2387.25,0.00,'2022-09-06 14:31:41','',''),(269,'5','272','2',1,'Sale Id shift 77',0.00,0.00,0.00,1430.43,0.00,'2022-09-06 14:31:41','',''),(270,'5','272',NULL,1,'Sale Id shift 77',1901679.75,0.00,0.00,0.00,0.00,'2022-09-06 14:31:41','',''),(271,'5','272','1',1,'Sale Id shift 78',0.00,0.00,0.00,2970.39,0.00,'2022-09-06 14:36:42','',''),(272,'5','272','1',1,'Sale Id shift 78',0.00,0.00,0.00,3594.07,0.00,'2022-09-06 14:36:42','',''),(273,'5','272','2',1,'Sale Id shift 78',0.00,0.00,0.00,3705.85,0.00,'2022-09-06 14:36:42','',''),(274,'5','272',NULL,1,'Sale Id shift 78',1900007.35,0.00,0.00,0.00,0.00,'2022-09-06 14:36:42','',''),(275,'5','272','1',1,'Sale Id shift 79',0.00,0.00,0.00,3302.42,0.00,'2022-09-06 14:40:23','',''),(276,'5','272','1',1,'Sale Id shift 79',0.00,0.00,0.00,3844.86,0.00,'2022-09-06 14:40:23','',''),(277,'5','272','2',1,'Sale Id shift 79',0.00,0.00,0.00,1650.94,0.00,'2022-09-06 14:40:23','',''),(278,'5','272','2',1,'Sale Id shift 79',0.00,0.00,0.00,2416.79,0.00,'2022-09-06 14:40:23','',''),(279,'5','272',NULL,1,'Sale Id shift 79',2074776.85,0.00,0.00,0.00,0.00,'2022-09-06 14:40:23','',''),(280,'5','272','1',1,'Sale Id shift 80',0.00,0.00,0.00,1101.82,0.00,'2022-09-06 15:13:05','',''),(281,'5','272','1',1,'Sale Id shift 80',0.00,0.00,0.00,1080.60,0.00,'2022-09-06 15:13:05','',''),(282,'5','272','2',1,'Sale Id shift 80',0.00,0.00,0.00,5276.18,0.00,'2022-09-06 15:13:05','',''),(283,'5','272','2',1,'Sale Id shift 80',0.00,0.00,0.00,6267.31,0.00,'2022-09-06 15:13:05','',''),(284,'5','272',NULL,1,'Sale Id shift 80',2539293.35,0.00,0.00,0.00,0.00,'2022-09-06 15:13:05','',''),(285,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-06 15:21:57','',''),(286,'5','272',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,30300.00,0.00,'2022-09-06 15:33:58','',''),(287,'5','272','1',1,'Received from bridging 24',0.00,0.00,30300.00,0.00,0.00,'2022-09-06 15:33:58','',''),(288,'5','272',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,29700.00,0.00,'2022-09-06 15:34:06','',''),(289,'5','272','2',1,'Received from bridging 25',0.00,0.00,29700.00,0.00,0.00,'2022-09-06 15:34:06','',''),(290,'5','272','1',1,'Sale Id shift 81',0.00,0.00,0.00,1926.80,0.00,'2022-09-06 15:41:02','',''),(291,'5','272','1',1,'Sale Id shift 81',0.00,0.00,0.00,6178.09,0.00,'2022-09-06 15:41:02','',''),(292,'5','272','2',1,'Sale Id shift 81',0.00,0.00,0.00,4945.38,0.00,'2022-09-06 15:41:02','',''),(293,'5','272','2',1,'Sale Id shift 81',0.00,0.00,0.00,879.93,0.00,'2022-09-06 15:41:02','',''),(294,'5','272',NULL,1,'Sale Id shift 81',2577087.00,0.00,0.00,0.00,0.00,'2022-09-06 15:41:02','',''),(295,'5','272','1',1,'Sale Id shift 82',0.00,0.00,0.00,2316.51,0.00,'2022-09-06 16:03:53','',''),(296,'5','272','1',1,'Sale Id shift 82',0.00,0.00,0.00,2404.24,0.00,'2022-09-06 16:03:53','',''),(297,'5','272','2',1,'Sale Id shift 82',0.00,0.00,0.00,2310.80,0.00,'2022-09-06 16:03:53','',''),(298,'5','272','2',1,'Sale Id shift 82',0.00,0.00,0.00,1675.98,0.00,'2022-09-06 16:03:53','',''),(299,'5','272',NULL,1,'Sale Id shift 82',1610893.05,0.00,0.00,0.00,0.00,'2022-09-06 16:03:53','',''),(300,'5','272','1',1,'Sale Id shift 83',0.00,0.00,0.00,2822.82,0.00,'2022-09-08 12:30:07','',''),(301,'5','272','1',1,'Sale Id shift 83',0.00,0.00,0.00,3612.94,0.00,'2022-09-08 12:30:07','',''),(302,'5','272','2',1,'Sale Id shift 83',0.00,0.00,0.00,1571.52,0.00,'2022-09-08 12:30:07','',''),(303,'5','272','2',1,'Sale Id shift 83',0.00,0.00,0.00,1835.57,0.00,'2022-09-08 12:30:07','',''),(304,'5','272',NULL,1,'Sale Id shift 83',1820927.25,0.00,0.00,0.00,0.00,'2022-09-08 12:30:07','',''),(305,'5','272','1',1,'Sale Id shift 84',0.00,0.00,0.00,3023.40,0.00,'2022-09-08 12:33:01','',''),(306,'5','272','1',1,'Sale Id shift 84',0.00,0.00,0.00,3759.82,0.00,'2022-09-08 12:33:01','',''),(307,'5','272','2',1,'Sale Id shift 84',0.00,0.00,0.00,2721.02,0.00,'2022-09-08 12:33:01','',''),(308,'5','272','2',1,'Sale Id shift 84',0.00,0.00,0.00,1953.32,0.00,'2022-09-08 12:33:01','',''),(309,'5','272',NULL,1,'Sale Id shift 84',2119648.60,0.00,0.00,0.00,0.00,'2022-09-08 12:33:01','',''),(310,'5','272','1',1,'Sale Id shift 85',0.00,0.00,0.00,1112.15,0.00,'2022-09-08 12:41:23','',''),(311,'5','272','1',1,'Sale Id shift 85',0.00,0.00,0.00,2787.00,0.00,'2022-09-08 12:41:23','',''),(312,'5','272','2',1,'Sale Id shift 85',0.00,0.00,0.00,4701.60,0.00,'2022-09-08 12:41:23','',''),(313,'5','272','2',1,'Sale Id shift 85',0.00,0.00,0.00,4882.92,0.00,'2022-09-08 12:41:23','',''),(314,'5','272',NULL,1,'Sale Id shift 85',2494478.95,0.00,0.00,0.00,0.00,'2022-09-08 12:41:23','',''),(315,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,9176370.00,49602.00,0.00,0.00,'2022-09-08 12:46:35','',''),(316,'5','272',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,21502.00,0.00,'2022-09-08 13:23:15','',''),(317,'5','272','2',1,'Received from bridging 31',0.00,0.00,21502.00,0.00,0.00,'2022-09-08 13:23:15','',''),(318,'5','272',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,28100.00,0.00,'2022-09-08 13:23:24','',''),(319,'5','272','1',1,'Received from bridging 30',0.00,0.00,28100.00,0.00,0.00,'2022-09-08 13:23:24','',''),(320,'5','272','1',1,'Sale Id shift 86',0.00,0.00,0.00,2594.66,0.00,'2022-09-08 13:45:58','',''),(321,'5','272','1',1,'Sale Id shift 86',0.00,0.00,0.00,4274.59,0.00,'2022-09-08 13:45:58','',''),(322,'5','272','2',1,'Sale Id shift 86',0.00,0.00,0.00,1580.63,0.00,'2022-09-08 13:45:58','',''),(323,'5','272','2',1,'Sale Id shift 86',0.00,0.00,0.00,3990.44,0.00,'2022-09-08 13:45:58','',''),(324,'5','272',NULL,1,'Sale Id shift 86',2301459.20,0.00,0.00,0.00,0.00,'2022-09-08 13:45:58','',''),(325,'5','272','1',1,'Sale Id shift 87',0.00,0.00,0.00,2153.41,0.00,'2022-09-08 13:54:59','',''),(326,'5','272','1',1,'Sale Id shift 87',0.00,0.00,0.00,5990.44,0.00,'2022-09-08 13:54:59','',''),(327,'5','272','2',1,'Sale Id shift 87',0.00,0.00,0.00,2351.38,0.00,'2022-09-08 13:54:59','',''),(328,'5','272','2',1,'Sale Id shift 87',0.00,0.00,0.00,4563.50,0.00,'2022-09-08 13:54:59','',''),(329,'5','272',NULL,1,'Sale Id shift 87',2785865.05,0.00,0.00,0.00,0.00,'2022-09-08 13:54:59','',''),(330,'5','272','1',1,'Sale Id shift 88',0.00,0.00,0.00,4977.18,0.00,'2022-09-08 13:59:55','',''),(331,'5','272','2',1,'Sale Id shift 88',0.00,0.00,0.00,4613.92,0.00,'2022-09-08 13:59:55','',''),(332,'5','272','2',1,'Sale Id shift 88',0.00,0.00,0.00,3692.99,0.00,'2022-09-08 13:59:55','',''),(333,'5','272',NULL,1,'Sale Id shift 88',2457556.65,0.00,0.00,0.00,0.00,'2022-09-08 13:59:55','',''),(334,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7316750.00,39550.00,0.00,0.00,'2022-09-08 14:09:24','',''),(335,'5','272',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,1715.00,0.00,'2022-09-08 14:19:15','',''),(336,'5','272','2',1,'Received from bridging 33',0.00,0.00,1715.00,0.00,0.00,'2022-09-08 14:19:15','',''),(337,'5','272',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,22400.00,0.00,'2022-09-08 14:19:23','',''),(338,'5','272','1',1,'Received from bridging 32',0.00,0.00,22400.00,0.00,0.00,'2022-09-08 14:19:23','',''),(339,'5','272','1',1,'Sale Id shift 89',0.00,0.00,0.00,1406.22,0.00,'2022-09-08 14:21:15','',''),(340,'5','272','1',1,'Sale Id shift 89',0.00,0.00,0.00,5578.59,0.00,'2022-09-08 14:21:15','',''),(341,'5','272','2',1,'Sale Id shift 89',0.00,0.00,0.00,3191.11,0.00,'2022-09-08 14:21:15','',''),(342,'5','272','2',1,'Sale Id shift 89',0.00,0.00,0.00,2313.00,0.00,'2022-09-08 14:21:15','',''),(343,'5','272',NULL,1,'Sale Id shift 89',2310450.20,0.00,0.00,0.00,0.00,'2022-09-08 14:21:15','',''),(344,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,23949.27,0.00,'2022-09-08 14:38:07','',''),(345,'5','272','1',0,'Inventory adjustment from tank dipping to 26150',0.00,0.00,26150.00,0.00,0.00,'2022-09-08 14:38:07','',''),(346,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,1419.13,0.00,'2022-09-08 14:38:25','',''),(347,'5','272','2',0,'Inventory adjustment from tank dipping to 14500',0.00,0.00,14500.00,0.00,0.00,'2022-09-08 14:38:25','',''),(348,'5','272','1',1,'Sale Id shift 90',0.00,0.00,0.00,4583.69,0.00,'2022-09-08 14:41:50','',''),(349,'5','272','1',1,'Sale Id shift 90',0.00,0.00,0.00,3482.38,0.00,'2022-09-08 14:41:50','',''),(350,'5','272','2',1,'Sale Id shift 90',0.00,0.00,0.00,4192.43,0.00,'2022-09-08 14:41:50','',''),(351,'5','272','2',1,'Sale Id shift 90',0.00,0.00,0.00,2657.01,0.00,'2022-09-08 14:41:50','',''),(352,'5','272',NULL,1,'Sale Id shift 90',2759369.35,0.00,0.00,0.00,0.00,'2022-09-08 14:41:50','',''),(353,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,7650.56,0.00,'2022-09-08 14:54:42','',''),(354,'5','272','2',0,'Inventory adjustment from tank dipping to 19450',0.00,0.00,19450.00,0.00,0.00,'2022-09-08 14:54:42','',''),(355,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,18083.93,0.00,'2022-09-08 14:55:11','',''),(356,'5','272','1',0,'Inventory adjustment from tank dipping to 6500',0.00,0.00,6500.00,0.00,0.00,'2022-09-08 14:55:11','',''),(357,'5','272','1',1,'Sale Id shift 91',0.00,0.00,0.00,5446.37,0.00,'2022-09-08 14:57:45','',''),(358,'5','272','2',1,'Sale Id shift 91',0.00,0.00,0.00,4232.99,0.00,'2022-09-08 14:57:45','',''),(359,'5','272','2',1,'Sale Id shift 91',0.00,0.00,0.00,3785.89,0.00,'2022-09-08 14:57:45','',''),(360,'5','272',NULL,1,'Sale Id shift 91',2491071.25,0.00,0.00,0.00,0.00,'2022-09-08 14:57:45','',''),(361,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1053.63,0.00,'2022-09-08 15:15:08','',''),(362,'5','272','1',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2022-09-08 15:15:08','',''),(363,'5','272','1',1,'Sale Id shift 92',0.00,0.00,0.00,1162.17,0.00,'2022-09-08 15:28:44','',''),(364,'5','272','2',1,'Sale Id shift 92',0.00,0.00,0.00,1552.81,0.00,'2022-09-08 15:28:44','',''),(365,'5','272','2',1,'Sale Id shift 92',0.00,0.00,0.00,1852.54,0.00,'2022-09-08 15:28:44','',''),(366,'5','272',NULL,1,'Sale Id shift 92',844991.20,0.00,0.00,0.00,0.00,'2022-09-08 15:28:44','',''),(367,'5','272','2',1,'Sale Id shift 93',0.00,0.00,0.00,1096.53,0.00,'2022-09-08 16:09:00','',''),(368,'5','272','2',1,'Sale Id shift 93',0.00,0.00,0.00,1326.43,0.00,'2022-09-08 16:09:00','',''),(369,'5','272',NULL,1,'Sale Id shift 93',448247.60,0.00,0.00,0.00,0.00,'2022-09-08 16:09:00','',''),(370,'5','272','1',1,'Sale Id shift 94',0.00,0.00,0.00,19.25,0.00,'2022-09-08 16:15:06','',''),(371,'5','272','2',1,'Sale Id shift 94',0.00,0.00,0.00,2537.32,0.00,'2022-09-08 16:15:06','',''),(372,'5','272','2',1,'Sale Id shift 94',0.00,0.00,0.00,2901.78,0.00,'2022-09-08 16:15:06','',''),(373,'5','272',NULL,1,'Sale Id shift 94',1009794.75,0.00,0.00,0.00,0.00,'2022-09-08 16:15:06','',''),(374,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8214000.00,44400.00,0.00,0.00,'2022-09-08 16:28:23','',''),(375,'5','272',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,29300.00,0.00,'2022-09-08 16:33:24','',''),(376,'5','272','2',1,'Received from bridging 35',0.00,0.00,29300.00,0.00,0.00,'2022-09-08 16:33:24','',''),(377,'5','272',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,15100.00,0.00,'2022-09-08 16:33:42','',''),(378,'5','272','1',1,'Received from bridging 34',0.00,0.00,15100.00,0.00,0.00,'2022-09-08 16:33:42','',''),(379,'5','272','1',1,'Sale Id shift 95',0.00,0.00,0.00,64.86,0.00,'2022-09-08 16:34:59','',''),(380,'5','272','1',1,'Sale Id shift 95',0.00,0.00,0.00,5258.10,0.00,'2022-09-08 16:34:59','',''),(381,'5','272','2',1,'Sale Id shift 95',0.00,0.00,0.00,4487.44,0.00,'2022-09-08 16:34:59','',''),(382,'5','272','2',1,'Sale Id shift 95',0.00,0.00,0.00,4281.42,0.00,'2022-09-08 16:34:59','',''),(383,'5','272',NULL,1,'Sale Id shift 95',2606986.70,0.00,0.00,0.00,0.00,'2022-09-08 16:34:59','',''),(384,'5','272','1',1,'Sale Id shift 96',0.00,0.00,0.00,2030.59,0.00,'2022-09-08 16:41:43','',''),(385,'5','272','1',1,'Sale Id shift 96',0.00,0.00,0.00,2016.39,0.00,'2022-09-08 16:41:43','',''),(386,'5','272','2',1,'Sale Id shift 96',0.00,0.00,0.00,3326.84,0.00,'2022-09-08 16:41:43','',''),(387,'5','272','2',1,'Sale Id shift 96',0.00,0.00,0.00,3278.76,0.00,'2022-09-08 16:41:43','',''),(388,'5','272',NULL,1,'Sale Id shift 96',1970727.30,0.00,0.00,0.00,0.00,'2022-09-08 16:41:43','',''),(389,'5','272','1',1,'Sale Id shift 97',0.00,0.00,0.00,2524.98,0.00,'2022-09-08 16:45:50','',''),(390,'5','272','1',1,'Sale Id shift 97',0.00,0.00,0.00,3039.42,0.00,'2022-09-08 16:45:50','',''),(391,'5','272','2',1,'Sale Id shift 97',0.00,0.00,0.00,6238.39,0.00,'2022-09-08 16:45:50','',''),(392,'5','272','2',1,'Sale Id shift 97',0.00,0.00,0.00,2107.84,0.00,'2022-09-08 16:45:50','',''),(393,'5','272',NULL,1,'Sale Id shift 97',2573466.55,0.00,0.00,0.00,0.00,'2022-09-08 16:45:50','',''),(394,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8223250.00,44450.00,0.00,0.00,'2022-09-08 16:54:11','',''),(395,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,5743.02,0.00,'2022-09-20 15:22:14','',''),(396,'5','272','2',0,'Inventory adjustment from tank dipping to 5600',0.00,0.00,5600.00,0.00,0.00,'2022-09-20 15:22:14','',''),(397,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,8984.24,0.00,'2022-09-20 15:22:45','',''),(398,'5','272','1',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-09-20 15:22:45','',''),(399,'5','272',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,15150.00,0.00,'2022-09-20 15:25:12','',''),(400,'5','272','2',1,'Received from bridging 37',0.00,0.00,15150.00,0.00,0.00,'2022-09-20 15:25:12','',''),(401,'5','272',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,29300.00,0.00,'2022-09-20 15:25:12','',''),(402,'5','272','1',1,'Received from bridging 36',0.00,0.00,29300.00,0.00,0.00,'2022-09-20 15:25:12','',''),(403,'5','272','1',1,'Sale Id shift 98',0.00,0.00,0.00,3375.89,0.00,'2022-09-20 15:35:34','',''),(404,'5','272','1',1,'Sale Id shift 98',0.00,0.00,0.00,4577.98,0.00,'2022-09-20 15:35:34','',''),(405,'5','272','2',1,'Sale Id shift 98',0.00,0.00,0.00,5245.88,0.00,'2022-09-20 15:35:34','',''),(406,'5','272','2',1,'Sale Id shift 98',0.00,0.00,0.00,870.18,0.00,'2022-09-20 15:35:34','',''),(407,'5','272',NULL,1,'Sale Id shift 98',2602937.05,0.00,0.00,0.00,0.00,'2022-09-20 15:35:34','',''),(408,'5','272','1',1,'Sale Id shift 99',0.00,0.00,0.00,116.05,0.00,'2022-09-20 16:03:52','',''),(409,'5','272','1',1,'Sale Id shift 99',0.00,0.00,0.00,4917.53,0.00,'2022-09-20 16:03:52','',''),(410,'5','272','2',1,'Sale Id shift 99',0.00,0.00,0.00,3671.30,0.00,'2022-09-20 16:03:52','',''),(411,'5','272','2',1,'Sale Id shift 99',0.00,0.00,0.00,4665.16,0.00,'2022-09-20 16:03:52','',''),(412,'5','272',NULL,1,'Sale Id shift 99',2473457.40,0.00,0.00,0.00,0.00,'2022-09-20 16:03:52','',''),(413,'5','272','1',1,'Sale Id shift 100',0.00,0.00,0.00,4286.08,0.00,'2022-09-22 17:58:49','',''),(414,'5','272','2',1,'Sale Id shift 100',0.00,0.00,0.00,1760.70,0.00,'2022-09-22 17:58:49','',''),(415,'5','272','2',1,'Sale Id shift 100',0.00,0.00,0.00,3733.16,0.00,'2022-09-22 17:58:49','',''),(416,'5','272',NULL,1,'Sale Id shift 100',1809288.90,0.00,0.00,0.00,0.00,'2022-09-22 17:58:49','',''),(417,'5','272','1',1,'Sale Id shift 101',0.00,0.00,0.00,3739.68,0.00,'2022-09-22 18:09:28','',''),(418,'5','272',NULL,1,'Sale Id shift 101',691840.80,0.00,0.00,0.00,0.00,'2022-09-22 18:09:28','',''),(419,'5','272','1',1,'Sale Id shift 102',0.00,0.00,0.00,2031.07,0.00,'2022-09-22 18:13:27','',''),(420,'5','272',NULL,1,'Sale Id shift 102',375747.95,0.00,0.00,0.00,0.00,'2022-09-22 18:13:27','',''),(421,'5','272','1',1,'Sale Id shift 103',0.00,0.00,0.00,1700.00,0.00,'2022-09-22 18:16:02','',''),(422,'5','272',NULL,1,'Sale Id shift 103',314500.00,0.00,0.00,0.00,0.00,'2022-09-22 18:16:02','',''),(423,'5','272','1',1,'Sale Id shift 104',0.00,0.00,0.00,1906.55,0.00,'2022-09-22 18:23:56','',''),(424,'5','272','1',1,'Sale Id shift 104',0.00,0.00,0.00,2812.79,0.00,'2022-09-22 18:23:56','',''),(425,'5','272',NULL,1,'Sale Id shift 104',873077.90,0.00,0.00,0.00,0.00,'2022-09-22 18:23:56','',''),(426,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7418500.00,40100.00,0.00,0.00,'2022-09-26 14:47:36','',''),(427,'5','272',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,27000.00,0.00,'2022-09-26 14:56:23','',''),(428,'5','272','2',1,'Received from bridging 39',0.00,0.00,27000.00,0.00,0.00,'2022-09-26 14:56:23','',''),(429,'5','272',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,13100.00,0.00,'2022-09-26 14:56:36','',''),(430,'5','272','1',1,'Received from bridging 38',0.00,0.00,13100.00,0.00,0.00,'2022-09-26 14:56:36','',''),(431,'5','272','1',1,'Sale Id shift 105',0.00,0.00,0.00,20.00,0.00,'2022-09-26 15:38:07','',''),(432,'5','272','2',1,'Sale Id shift 105',0.00,0.00,0.00,4178.05,0.00,'2022-09-26 15:38:07','',''),(433,'5','272','2',1,'Sale Id shift 105',0.00,0.00,0.00,3629.45,0.00,'2022-09-26 15:38:07','',''),(434,'5','272',NULL,1,'Sale Id shift 105',1448087.50,0.00,0.00,0.00,0.00,'2022-09-26 15:38:07','',''),(435,'5','272','2',1,'Sale Id shift 106',0.00,0.00,0.00,6939.59,0.00,'2022-09-26 15:42:36','',''),(436,'5','272','2',1,'Sale Id shift 106',0.00,0.00,0.00,6728.57,0.00,'2022-09-26 15:42:36','',''),(437,'5','272',NULL,1,'Sale Id shift 106',2528609.60,0.00,0.00,0.00,0.00,'2022-09-26 15:42:36','',''),(438,'5','272','2',1,'Sale Id shift 107',0.00,0.00,0.00,2944.08,0.00,'2022-09-26 15:49:06','',''),(439,'5','272','2',1,'Sale Id shift 107',0.00,0.00,0.00,2935.71,0.00,'2022-09-26 15:49:06','',''),(440,'5','272',NULL,1,'Sale Id shift 107',1087761.15,0.00,0.00,0.00,0.00,'2022-09-26 15:49:06','',''),(441,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7353750.00,39750.00,0.00,0.00,'2022-09-26 15:50:10','',''),(442,'5','272',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,27000.00,0.00,'2022-09-26 16:04:06','',''),(443,'5','272','2',1,'Received from bridging 40',0.00,0.00,27000.00,0.00,0.00,'2022-09-26 16:04:06','',''),(444,'5','272','1',1,'Sale Id shift 108',0.00,0.00,0.00,2960.24,0.00,'2022-09-26 16:09:11','',''),(445,'5','272','1',1,'Sale Id shift 108',0.00,0.00,0.00,3030.54,0.00,'2022-09-26 16:09:11','',''),(446,'5','272','2',1,'Sale Id shift 108',0.00,0.00,0.00,4315.55,0.00,'2022-09-26 16:09:11','',''),(447,'5','272','2',1,'Sale Id shift 108',0.00,0.00,0.00,4794.55,0.00,'2022-09-26 16:09:11','',''),(448,'5','272',NULL,1,'Sale Id shift 108',2793662.80,0.00,0.00,0.00,0.00,'2022-09-26 16:09:11','',''),(449,'5','272',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,12750.00,0.00,'2022-09-26 16:12:10','',''),(450,'5','272','2',1,'Received from bridging 41',0.00,0.00,12750.00,0.00,0.00,'2022-09-26 16:12:10','',''),(451,'5','272','1',1,'Sale Id shift 109',0.00,0.00,0.00,260.77,0.00,'2022-09-26 16:14:51','',''),(452,'5','272','1',1,'Sale Id shift 109',0.00,0.00,0.00,6075.30,0.00,'2022-09-26 16:14:51','',''),(453,'5','272','2',1,'Sale Id shift 109',0.00,0.00,0.00,4075.02,0.00,'2022-09-26 16:14:51','',''),(454,'5','272','2',1,'Sale Id shift 109',0.00,0.00,0.00,4402.74,0.00,'2022-09-26 16:14:51','',''),(455,'5','272',NULL,1,'Sale Id shift 109',2740558.55,0.00,0.00,0.00,0.00,'2022-09-26 16:14:51','',''),(456,'5','272','1',1,'Sale Id shift 110',0.00,0.00,0.00,217.79,0.00,'2022-09-26 16:18:03','',''),(457,'5','272','2',1,'Sale Id shift 110',0.00,0.00,0.00,4642.68,0.00,'2022-09-26 16:18:03','',''),(458,'5','272','2',1,'Sale Id shift 110',0.00,0.00,0.00,4226.90,0.00,'2022-09-26 16:18:03','',''),(459,'5','272',NULL,1,'Sale Id shift 110',1681163.45,0.00,0.00,0.00,0.00,'2022-09-26 16:18:03','',''),(460,'5','272','1',1,'Sale Id shift 111',0.00,0.00,0.00,16.92,0.00,'2022-09-26 16:21:01','',''),(461,'5','272','1',1,'Sale Id shift 111',0.00,0.00,0.00,229.40,0.00,'2022-09-26 16:21:01','',''),(462,'5','272','2',1,'Sale Id shift 111',0.00,0.00,0.00,4633.39,0.00,'2022-09-26 16:21:01','',''),(463,'5','272','2',1,'Sale Id shift 111',0.00,0.00,0.00,4991.90,0.00,'2022-09-26 16:21:01','',''),(464,'5','272',NULL,1,'Sale Id shift 111',1826247.85,0.00,0.00,0.00,0.00,'2022-09-26 16:21:01','',''),(465,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8252850.00,44610.00,0.00,0.00,'2022-09-26 16:27:17','',''),(466,'5','272',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,14850.00,0.00,'2022-09-26 16:39:29','',''),(467,'5','272','2',1,'Received from bridging 43',0.00,0.00,14850.00,0.00,0.00,'2022-09-26 16:39:29','',''),(468,'5','272',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,29540.00,0.00,'2022-09-26 16:39:51','',''),(469,'5','272','1',1,'Received from bridging 42',0.00,0.00,29540.00,0.00,0.00,'2022-09-26 16:39:51','',''),(470,'5','272','1',1,'Sale Id shift 112',0.00,0.00,0.00,2986.33,0.00,'2022-09-26 16:42:53','',''),(471,'5','272','1',1,'Sale Id shift 112',0.00,0.00,0.00,3512.09,0.00,'2022-09-26 16:42:53','',''),(472,'5','272','2',1,'Sale Id shift 112',0.00,0.00,0.00,5086.24,0.00,'2022-09-26 16:42:53','',''),(473,'5','272',NULL,1,'Sale Id shift 112',2143162.10,0.00,0.00,0.00,0.00,'2022-09-26 16:42:53','',''),(474,'5','272','1',1,'Sale Id shift 113',0.00,0.00,0.00,2755.50,0.00,'2022-09-26 16:48:59','',''),(475,'5','272','1',1,'Sale Id shift 113',0.00,0.00,0.00,3553.48,0.00,'2022-09-26 16:48:59','',''),(476,'5','272','2',1,'Sale Id shift 113',0.00,0.00,0.00,3911.14,0.00,'2022-09-26 16:48:59','',''),(477,'5','272','2',1,'Sale Id shift 113',0.00,0.00,0.00,659.88,0.00,'2022-09-26 16:48:59','',''),(478,'5','272',NULL,1,'Sale Id shift 113',2012800.00,0.00,0.00,0.00,0.00,'2022-09-26 16:48:59','',''),(479,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-26 17:00:31','',''),(480,'5','272','1',1,'Sale Id shift 114',0.00,0.00,0.00,2786.62,0.00,'2022-09-26 17:08:09','',''),(481,'5','272','1',1,'Sale Id shift 114',0.00,0.00,0.00,3273.89,0.00,'2022-09-26 17:08:09','',''),(482,'5','272','2',1,'Sale Id shift 114',0.00,0.00,0.00,2070.15,0.00,'2022-09-26 17:08:09','',''),(483,'5','272','2',1,'Sale Id shift 114',0.00,0.00,0.00,1905.46,0.00,'2022-09-26 17:08:09','',''),(484,'5','272',NULL,1,'Sale Id shift 114',1856682.20,0.00,0.00,0.00,0.00,'2022-09-26 17:08:09','',''),(485,'5','272',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,26000.00,0.00,'2022-09-26 18:04:10','',''),(486,'5','272','2',1,'Received from bridging 45',0.00,0.00,26000.00,0.00,0.00,'2022-09-26 18:04:10','',''),(487,'5','272','1',1,'Sale Id shift 115',0.00,0.00,0.00,1084.26,0.00,'2022-09-26 18:09:25','',''),(488,'5','272','1',1,'Sale Id shift 115',0.00,0.00,0.00,5773.70,0.00,'2022-09-26 18:09:25','',''),(489,'5','272','2',1,'Sale Id shift 115',0.00,0.00,0.00,3150.06,0.00,'2022-09-26 18:09:25','',''),(490,'5','272','2',1,'Sale Id shift 115',0.00,0.00,0.00,2919.05,0.00,'2022-09-26 18:09:25','',''),(491,'5','272',NULL,1,'Sale Id shift 115',2391507.95,0.00,0.00,0.00,0.00,'2022-09-26 18:09:25','',''),(492,'5','272','2',1,'Sale Id shift 116',0.00,0.00,0.00,6555.60,0.00,'2022-09-26 18:21:48','',''),(493,'5','272','2',1,'Sale Id shift 116',0.00,0.00,0.00,6309.54,0.00,'2022-09-26 18:21:48','',''),(494,'5','272',NULL,1,'Sale Id shift 116',2380050.90,0.00,0.00,0.00,0.00,'2022-09-26 18:21:48','',''),(495,'5','272',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,6000.00,0.00,'2022-09-26 18:23:08','',''),(496,'5','272','2',1,'Received from bridging 46',0.00,0.00,6000.00,0.00,0.00,'2022-09-26 18:23:08','',''),(497,'5','272','2',1,'Sale Id shift 117',0.00,0.00,0.00,4734.98,0.00,'2022-09-26 18:25:14','',''),(498,'5','272','2',1,'Sale Id shift 117',0.00,0.00,0.00,3974.50,0.00,'2022-09-26 18:25:14','',''),(499,'5','272',NULL,1,'Sale Id shift 117',1611253.80,0.00,0.00,0.00,0.00,'2022-09-26 18:25:14','',''),(500,'5','272',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,8000.00,0.00,'2022-09-26 18:30:52','',''),(501,'5','272','2',1,'Received from bridging 47',0.00,0.00,8000.00,0.00,0.00,'2022-09-26 18:30:52','',''),(502,'5','272','1',1,'Sale Id shift 118',0.00,0.00,0.00,1832.62,0.00,'2022-09-27 09:44:05','',''),(503,'5','272','1',1,'Sale Id shift 118',0.00,0.00,0.00,2183.39,0.00,'2022-09-27 09:44:05','',''),(504,'5','272','2',1,'Sale Id shift 118',0.00,0.00,0.00,5557.25,0.00,'2022-09-27 09:44:05','',''),(505,'5','272','2',1,'Sale Id shift 118',0.00,0.00,0.00,3544.54,0.00,'2022-09-27 09:44:05','',''),(506,'5','272',NULL,1,'Sale Id shift 118',2426793.00,0.00,0.00,0.00,0.00,'2022-09-27 09:44:05','',''),(507,'5','272','2',1,'Sale Id shift 119',0.00,0.00,0.00,4146.90,0.00,'2022-09-28 08:21:33','',''),(508,'5','272','2',1,'Sale Id shift 119',0.00,0.00,0.00,4130.76,0.00,'2022-09-28 08:21:33','',''),(509,'5','272',NULL,1,'Sale Id shift 119',1531367.10,0.00,0.00,0.00,0.00,'2022-09-28 08:21:33','',''),(510,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8288000.00,44800.00,0.00,0.00,'2022-09-28 21:07:32','',''),(511,'5','272',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,30000.00,0.00,'2022-09-28 21:42:00','',''),(512,'5','272','2',1,'Received from bridging 48',0.00,0.00,30000.00,0.00,0.00,'2022-09-28 21:42:00','',''),(513,'5','272','2',1,'Sale Id shift 120',0.00,0.00,0.00,6629.01,0.00,'2022-09-29 08:33:21','',''),(514,'5','272','2',1,'Sale Id shift 120',0.00,0.00,0.00,6968.19,0.00,'2022-09-29 08:33:21','',''),(515,'5','272',NULL,1,'Sale Id shift 120',2515482.00,0.00,0.00,0.00,0.00,'2022-09-29 08:33:21','',''),(516,'5','272','2',1,'Sale Id shift 121',0.00,0.00,0.00,7117.61,0.00,'2022-09-30 08:06:58','',''),(517,'5','272','2',1,'Sale Id shift 121',0.00,0.00,0.00,7049.49,0.00,'2022-09-30 08:06:58','',''),(518,'5','272',NULL,1,'Sale Id shift 121',2620913.50,0.00,0.00,0.00,0.00,'2022-09-30 08:06:58','',''),(519,'5','272',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,14800.00,0.00,'2022-09-30 19:30:19','',''),(520,'5','272','2',1,'Received from bridging 49',0.00,0.00,14800.00,0.00,0.00,'2022-09-30 19:30:19','',''),(521,'5','272','2',1,'Sale Id shift 122',0.00,0.00,0.00,6594.73,0.00,'2022-10-01 08:57:05','',''),(522,'5','272','2',1,'Sale Id shift 122',0.00,0.00,0.00,6569.93,0.00,'2022-10-01 08:57:05','',''),(523,'5','272',NULL,1,'Sale Id shift 122',2435462.10,0.00,0.00,0.00,0.00,'2022-10-01 08:57:05','',''),(524,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,4930250.00,26650.00,0.00,0.00,'2022-10-01 21:23:14','',''),(525,'5','272',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,26650.00,0.00,'2022-10-02 07:36:09','',''),(526,'5','272','2',1,'Received from bridging 50',0.00,0.00,26650.00,0.00,0.00,'2022-10-02 07:36:09','',''),(527,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7381500.00,39900.00,0.00,0.00,'2022-10-03 16:49:01','',''),(528,'5','272',NULL,1,'Returned purchase #27 to SALBAS OIL AND GAS LTD',7381500.00,0.00,0.00,39900.00,0.00,'2022-10-04 11:20:18','',''),(529,'5','272','2',1,'Sale Id shift 123',0.00,0.00,0.00,7023.51,0.00,'2022-10-04 11:34:21','',''),(530,'5','272','2',1,'Sale Id shift 123',0.00,0.00,0.00,6263.15,0.00,'2022-10-04 11:34:21','',''),(531,'5','272',NULL,1,'Sale Id shift 123',2458032.10,0.00,0.00,0.00,0.00,'2022-10-04 11:34:21','',''),(532,'5','272','2',1,'Sale Id shift 124',0.00,0.00,0.00,5517.70,0.00,'2022-10-04 11:57:32','',''),(533,'5','272','2',1,'Sale Id shift 124',0.00,0.00,0.00,5621.67,0.00,'2022-10-04 11:57:32','',''),(534,'5','272',NULL,1,'Sale Id shift 124',2060783.45,0.00,0.00,0.00,0.00,'2022-10-04 11:57:32','',''),(535,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,2451250.00,13250.00,0.00,0.00,'2022-10-04 12:45:07','',''),(536,'5','272',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,13250.00,0.00,'2022-10-04 13:04:49','',''),(537,'5','272','2',1,'Received from bridging 51',0.00,0.00,13250.00,0.00,0.00,'2022-10-04 13:04:49','',''),(538,'5','272','2',1,'Sale Id shift 125',0.00,0.00,0.00,4149.69,0.00,'2022-10-04 13:19:02','',''),(539,'5','272','2',1,'Sale Id shift 125',0.00,0.00,0.00,3762.55,0.00,'2022-10-04 13:19:02','',''),(540,'5','272',NULL,1,'Sale Id shift 125',1463764.40,0.00,0.00,0.00,0.00,'2022-10-04 13:19:02','',''),(541,'5','272','2',1,'Sale Id shift 126',0.00,0.00,0.00,2455.13,0.00,'2022-10-05 09:36:31','',''),(542,'5','272','2',1,'Sale Id shift 126',0.00,0.00,0.00,2722.50,0.00,'2022-10-05 09:36:31','',''),(543,'5','272',NULL,1,'Sale Id shift 126',957861.55,0.00,0.00,0.00,0.00,'2022-10-05 09:36:31','',''),(544,'5','272','2',1,'Sale Id shift 127',0.00,0.00,0.00,2283.35,0.00,'2022-10-06 07:57:45','',''),(545,'5','272',NULL,1,'Sale Id shift 127',422419.75,0.00,0.00,0.00,0.00,'2022-10-06 07:57:45','',''),(546,'5','272','2',1,'Sale Id shift 128',0.00,0.00,0.00,559.48,0.00,'2022-10-07 10:18:47','',''),(547,'5','272',NULL,1,'Sale Id shift 128',103503.80,0.00,0.00,0.00,0.00,'2022-10-07 10:18:47','',''),(548,'5','272','2',1,'Sale Id shift 129',0.00,0.00,0.00,1815.97,0.00,'2022-10-08 08:34:56','',''),(549,'5','272',NULL,1,'Sale Id shift 129',335954.45,0.00,0.00,0.00,0.00,'2022-10-08 08:34:56','',''),(550,'5','272','2',1,'Sale Id shift 130',0.00,0.00,0.00,1326.88,0.00,'2022-10-09 08:30:28','',''),(551,'5','272',NULL,1,'Sale Id shift 130',245472.80,0.00,0.00,0.00,0.00,'2022-10-09 08:30:28','',''),(552,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-12 14:37:13','',''),(553,'5','272',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,26000.00,0.00,'2022-10-12 14:42:08','',''),(554,'5','272','2',1,'Received from bridging 52',0.00,0.00,26000.00,0.00,0.00,'2022-10-12 14:42:08','',''),(555,'5','272','2',1,'Sale Id shift 132',0.00,0.00,0.00,1344.92,0.00,'2022-10-12 15:06:30','',''),(556,'5','272','2',1,'Sale Id shift 132',0.00,0.00,0.00,1559.59,0.00,'2022-10-12 15:06:30','',''),(557,'5','272',NULL,1,'Sale Id shift 132',537334.35,0.00,0.00,0.00,0.00,'2022-10-12 15:06:30','',''),(558,'5','272','2',1,'Sale Id shift 133',0.00,0.00,0.00,10199.33,0.00,'2022-10-12 22:11:54','',''),(559,'5','272','2',1,'Sale Id shift 133',0.00,0.00,0.00,8575.29,0.00,'2022-10-12 22:11:54','',''),(560,'5','272',NULL,1,'Sale Id shift 133',3473304.70,0.00,0.00,0.00,0.00,'2022-10-12 22:11:54','',''),(561,'5','272',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,24000.00,0.00,'2022-10-12 23:14:12','',''),(562,'5','272','2',1,'Received from bridging 53',0.00,0.00,24000.00,0.00,0.00,'2022-10-12 23:14:12','',''),(563,'5','272','2',1,'Sale Id shift 134',0.00,0.00,0.00,8334.55,0.00,'2022-10-13 05:39:41','',''),(564,'5','272','2',1,'Sale Id shift 134',0.00,0.00,0.00,6252.50,0.00,'2022-10-13 05:39:41','',''),(565,'5','272',NULL,1,'Sale Id shift 134',2698604.25,0.00,0.00,0.00,0.00,'2022-10-13 05:39:41','',''),(566,'5','272','2',1,'Sale Id shift 135',0.00,0.00,0.00,6334.09,0.00,'2022-10-14 07:28:05','',''),(567,'5','272','2',1,'Sale Id shift 135',0.00,0.00,0.00,7297.32,0.00,'2022-10-14 07:28:05','',''),(568,'5','272',NULL,1,'Sale Id shift 135',2521810.85,0.00,0.00,0.00,0.00,'2022-10-14 07:28:05','',''),(569,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,9231500.00,49900.00,0.00,0.00,'2022-10-15 21:28:06','',''),(570,'5','272',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,31000.00,0.00,'2022-10-15 21:38:52','',''),(571,'5','272','2',1,'Received from bridging 54',0.00,0.00,31000.00,0.00,0.00,'2022-10-15 21:38:52','',''),(572,'5','272','2',1,'Sale Id shift 136',0.00,0.00,0.00,7707.51,0.00,'2022-10-15 22:26:01','',''),(573,'5','272','2',1,'Sale Id shift 136',0.00,0.00,0.00,7453.65,0.00,'2022-10-15 22:26:01','',''),(574,'5','272',NULL,1,'Sale Id shift 136',2804814.60,0.00,0.00,0.00,0.00,'2022-10-15 22:26:01','',''),(575,'5','272','2',1,'Sale Id shift 137',0.00,0.00,0.00,6881.62,0.00,'2022-10-16 09:42:07','',''),(576,'5','272','2',1,'Sale Id shift 137',0.00,0.00,0.00,7848.30,0.00,'2022-10-16 09:42:07','',''),(577,'5','272',NULL,1,'Sale Id shift 137',2725035.20,0.00,0.00,0.00,0.00,'2022-10-16 09:42:07','',''),(578,'5','272',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,18900.00,0.00,'2022-10-16 20:42:36','',''),(579,'5','272','2',1,'Received from bridging 55',0.00,0.00,18900.00,0.00,0.00,'2022-10-16 20:42:36','',''),(580,'5','272','2',1,'Sale Id shift 138',0.00,0.00,0.00,9237.15,0.00,'2022-10-17 07:34:55','',''),(581,'5','272','2',1,'Sale Id shift 138',0.00,0.00,0.00,8624.97,0.00,'2022-10-17 07:34:55','',''),(582,'5','272',NULL,1,'Sale Id shift 138',3304492.20,0.00,0.00,0.00,0.00,'2022-10-17 07:34:55','',''),(583,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,11083350.00,59910.00,0.00,0.00,'2022-10-19 11:14:34','',''),(584,'5','272',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,29000.00,0.00,'2022-10-19 11:42:31','',''),(585,'5','272','2',1,'Received from bridging 56',0.00,0.00,29000.00,0.00,0.00,'2022-10-19 11:42:31','',''),(586,'5','272','2',1,'Sale Id shift 139',0.00,0.00,0.00,5786.24,0.00,'2022-10-19 20:10:03','',''),(587,'5','272','2',1,'Sale Id shift 139',0.00,0.00,0.00,7852.11,0.00,'2022-10-19 20:10:03','',''),(588,'5','272',NULL,1,'Sale Id shift 139',2523094.75,0.00,0.00,0.00,0.00,'2022-10-19 20:10:03','',''),(589,'5','272',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,13000.00,0.00,'2022-10-19 20:22:14','',''),(590,'5','272','2',1,'Received from bridging 57',0.00,0.00,13000.00,0.00,0.00,'2022-10-19 20:22:14','',''),(591,'5','272','2',1,'Sale Id shift 140',0.00,0.00,0.00,9245.56,0.00,'2022-10-19 20:26:43','',''),(592,'5','272','2',1,'Sale Id shift 140',0.00,0.00,0.00,9436.06,0.00,'2022-10-19 20:26:43','',''),(593,'5','272',NULL,1,'Sale Id shift 140',3456099.70,0.00,0.00,0.00,0.00,'2022-10-19 20:26:43','',''),(594,'5','272','2',1,'Sale Id shift 141',0.00,0.00,0.00,6811.68,0.00,'2022-10-20 07:02:20','',''),(595,'5','272','2',1,'Sale Id shift 141',0.00,0.00,0.00,4420.59,0.00,'2022-10-20 07:02:20','',''),(596,'5','272',NULL,1,'Sale Id shift 141',2077969.95,0.00,0.00,0.00,0.00,'2022-10-20 07:02:20','',''),(597,'5','272',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,17910.00,0.00,'2022-10-20 20:32:22','',''),(598,'5','272','2',1,'Received from bridging 58',0.00,0.00,17910.00,0.00,0.00,'2022-10-20 20:32:22','',''),(599,'5','272','2',1,'Sale Id shift 142',0.00,0.00,0.00,7865.86,0.00,'2022-10-21 07:40:04','',''),(600,'5','272','2',1,'Sale Id shift 142',0.00,0.00,0.00,3911.82,0.00,'2022-10-21 07:40:04','',''),(601,'5','272',NULL,1,'Sale Id shift 142',2178870.80,0.00,0.00,0.00,0.00,'2022-10-21 07:40:04','',''),(602,'5','272','2',1,'Sale Id shift 143',0.00,0.00,0.00,4088.88,0.00,'2022-10-22 06:16:04','',''),(603,'5','272','2',1,'Sale Id shift 143',0.00,0.00,0.00,2836.23,0.00,'2022-10-22 06:16:04','',''),(604,'5','272',NULL,1,'Sale Id shift 143',1281145.35,0.00,0.00,0.00,0.00,'2022-10-22 06:16:04','',''),(605,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8300950.00,44870.00,0.00,0.00,'2022-10-29 21:47:54','',''),(606,'5','272',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,30000.00,0.00,'2022-10-29 22:01:50','',''),(607,'5','272','2',1,'Received from bridging 59',0.00,0.00,30000.00,0.00,0.00,'2022-10-29 22:01:50','',''),(608,'5','272','2',1,'Sale Id shift 150',0.00,0.00,0.00,12086.53,0.00,'2022-10-30 06:33:39','',''),(609,'5','272',NULL,1,'Sale Id shift 150',2236008.05,0.00,0.00,0.00,0.00,'2022-10-30 06:33:39','',''),(610,'5','272','2',1,'Sale Id shift 151',0.00,0.00,0.00,11723.59,0.00,'2022-10-30 17:49:12','',''),(611,'5','272',NULL,1,'Sale Id shift 151',2168864.15,0.00,0.00,0.00,0.00,'2022-10-30 17:49:12','',''),(612,'5','272','2',1,'Sale Id shift 152',0.00,0.00,0.00,3435.54,0.00,'2022-10-31 06:45:00','',''),(613,'5','272','2',1,'Sale Id shift 152',0.00,0.00,0.00,3205.20,0.00,'2022-10-31 06:45:00','',''),(614,'5','272',NULL,1,'Sale Id shift 152',1228536.90,0.00,0.00,0.00,0.00,'2022-10-31 06:45:00','',''),(615,'5','272',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,14870.00,0.00,'2022-10-31 07:00:00','',''),(616,'5','272','2',1,'Received from bridging 60',0.00,0.00,14870.00,0.00,0.00,'2022-10-31 07:00:00','',''),(617,'5','272','2',1,'Sale Id shift 153',0.00,0.00,0.00,7682.76,0.00,'2022-11-01 06:40:21','',''),(618,'5','272',NULL,1,'Sale Id shift 153',1421310.60,0.00,0.00,0.00,0.00,'2022-11-01 06:40:21','',''),(619,'5','272','2',1,'Sale Id shift 154',0.00,0.00,0.00,7015.17,0.00,'2022-11-02 08:22:06','',''),(620,'5','272',NULL,1,'Sale Id shift 154',1297806.45,0.00,0.00,0.00,0.00,'2022-11-02 08:22:06','',''),(621,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-11-13 22:05:47','',''),(622,'5','272',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,30000.00,0.00,'2022-11-14 02:19:50','',''),(623,'5','272','2',1,'Received from bridging 61',0.00,0.00,30000.00,0.00,0.00,'2022-11-14 02:19:50','',''),(624,'5','272','2',1,'Sale Id shift 162',0.00,0.00,0.00,7236.94,0.00,'2022-11-14 09:09:51','',''),(625,'5','272','2',1,'Sale Id shift 162',0.00,0.00,0.00,8000.24,0.00,'2022-11-14 09:09:51','',''),(626,'5','272',NULL,1,'Sale Id shift 162',2818878.30,0.00,0.00,0.00,0.00,'2022-11-14 09:09:51','',''),(627,'5','272','2',1,'Sale Id shift 163',0.00,0.00,0.00,6163.34,0.00,'2022-11-14 12:39:26','',''),(628,'5','272','2',1,'Sale Id shift 163',0.00,0.00,0.00,5785.83,0.00,'2022-11-14 12:39:26','',''),(629,'5','272',NULL,1,'Sale Id shift 163',2210596.45,0.00,0.00,0.00,0.00,'2022-11-14 12:39:26','',''),(630,'5','272',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,15000.00,0.00,'2022-11-14 12:44:10','',''),(631,'5','272','2',1,'Received from bridging 62',0.00,0.00,15000.00,0.00,0.00,'2022-11-14 12:44:10','',''),(632,'5','272','2',1,'Sale Id shift 164',0.00,0.00,0.00,5560.29,0.00,'2022-11-14 13:28:04','',''),(633,'5','272','2',1,'Sale Id shift 164',0.00,0.00,0.00,6720.60,0.00,'2022-11-14 13:28:04','',''),(634,'5','272',NULL,1,'Sale Id shift 164',2271964.65,0.00,0.00,0.00,0.00,'2022-11-14 13:28:04','',''),(635,'5','272','2',1,'Sale Id shift 166',0.00,0.00,0.00,1659.06,0.00,'2022-11-16 07:34:22','',''),(636,'5','272','2',1,'Sale Id shift 166',0.00,0.00,0.00,3986.15,0.00,'2022-11-16 07:34:22','',''),(637,'5','272',NULL,1,'Sale Id shift 166',1044363.85,0.00,0.00,0.00,0.00,'2022-11-16 07:34:22','',''),(638,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,2590000.00,14000.00,0.00,0.00,'2022-11-21 14:09:49','',''),(639,'5','272',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,14000.00,0.00,'2022-11-21 15:59:55','',''),(640,'5','272','1',1,'Received from bridging 63',0.00,0.00,14000.00,0.00,0.00,'2022-11-21 15:59:55','',''),(641,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,91.79,0.00,'2022-11-21 16:04:15','',''),(642,'5','272','2',0,'Inventory adjustment from tank dipping to 14100',0.00,0.00,14100.00,0.00,0.00,'2022-11-21 16:04:15','',''),(643,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,14123.54,0.00,'2022-11-21 16:05:22','',''),(644,'5','272','1',0,'Inventory adjustment from tank dipping to 100',0.00,0.00,100.00,0.00,0.00,'2022-11-21 16:05:22','',''),(645,'5','272','2',1,'Sale Id shift 173',0.00,0.00,0.00,4091.82,0.00,'2022-11-21 16:16:58','',''),(646,'5','272','2',1,'Sale Id shift 173',0.00,0.00,0.00,3398.11,0.00,'2022-11-21 16:16:58','',''),(647,'5','272',NULL,1,'Sale Id shift 173',1385637.05,0.00,0.00,0.00,0.00,'2022-11-21 16:16:58','',''),(648,'5','272','2',1,'Sale Id shift 174',0.00,0.00,0.00,2930.23,0.00,'2022-11-22 09:21:52','',''),(649,'5','272','2',1,'Sale Id shift 174',0.00,0.00,0.00,3557.83,0.00,'2022-11-22 09:21:52','',''),(650,'5','272',NULL,1,'Sale Id shift 174',1200291.10,0.00,0.00,0.00,0.00,'2022-11-22 09:21:52','',''),(651,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7375950.00,39870.00,0.00,0.00,'2022-11-23 14:46:36','',''),(652,'5','272',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,26370.00,0.00,'2022-11-23 16:04:52','',''),(653,'5','272','2',1,'Received from bridging 64',0.00,0.00,26370.00,0.00,0.00,'2022-11-23 16:04:52','',''),(654,'5','272','2',1,'Sale Id shift 175',0.00,0.00,0.00,9449.05,0.00,'2022-11-23 16:29:35','',''),(655,'5','272','2',1,'Sale Id shift 175',0.00,0.00,0.00,10972.22,0.00,'2022-11-23 16:29:35','',''),(656,'5','272',NULL,1,'Sale Id shift 175',3777934.95,0.00,0.00,0.00,0.00,'2022-11-23 16:29:35','',''),(657,'5','272',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,13500.00,0.00,'2022-11-23 22:07:25','',''),(658,'5','272','2',1,'Received from bridging 65',0.00,0.00,13500.00,0.00,0.00,'2022-11-23 22:07:25','',''),(659,'5','272','2',1,'Sale Id shift 176',0.00,0.00,0.00,9179.70,0.00,'2022-11-24 13:07:15','',''),(660,'5','272','2',1,'Sale Id shift 176',0.00,0.00,0.00,10067.72,0.00,'2022-11-24 13:07:15','',''),(661,'5','272',NULL,1,'Sale Id shift 176',3560772.70,0.00,0.00,0.00,0.00,'2022-11-24 13:07:15','',''),(662,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8260250.00,44650.00,0.00,0.00,'2022-11-24 20:57:41','',''),(663,'5','272',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,29800.00,0.00,'2022-11-24 22:53:25','',''),(664,'5','272','2',1,'Received from bridging 66',0.00,0.00,29800.00,0.00,0.00,'2022-11-24 22:53:25','',''),(665,'5','272','2',1,'Sale Id shift 177',0.00,0.00,0.00,10253.20,0.00,'2022-11-25 08:32:36','',''),(666,'5','272','2',1,'Sale Id shift 177',0.00,0.00,0.00,12089.63,0.00,'2022-11-25 08:32:36','',''),(667,'5','272',NULL,1,'Sale Id shift 177',4133423.55,0.00,0.00,0.00,0.00,'2022-11-25 08:32:36','',''),(668,'5','272',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,14850.00,0.00,'2022-11-25 21:29:55','',''),(669,'5','272','2',1,'Received from bridging 67',0.00,0.00,14850.00,0.00,0.00,'2022-11-25 21:29:55','',''),(670,'5','272','2',1,'Sale Id shift 178',0.00,0.00,0.00,11526.31,0.00,'2022-11-26 11:47:08','',''),(671,'5','272','2',1,'Sale Id shift 178',0.00,0.00,0.00,10946.19,0.00,'2022-11-26 11:47:08','',''),(672,'5','272',NULL,1,'Sale Id shift 178',4157412.50,0.00,0.00,0.00,0.00,'2022-11-26 11:47:08','',''),(673,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7363000.00,39800.00,0.00,0.00,'2022-11-27 21:29:09','',''),(674,'5','272',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,25800.00,0.00,'2022-11-27 22:02:49','',''),(675,'5','272','2',1,'Received from bridging 68',0.00,0.00,25800.00,0.00,0.00,'2022-11-27 22:02:49','',''),(676,'5','272','2',1,'Sale Id shift 179',0.00,0.00,0.00,10843.62,0.00,'2022-11-28 06:14:23','',''),(677,'5','272','2',1,'Sale Id shift 179',0.00,0.00,0.00,11912.87,0.00,'2022-11-28 06:14:23','',''),(678,'5','272',NULL,1,'Sale Id shift 179',4209950.65,0.00,0.00,0.00,0.00,'2022-11-28 06:14:23','',''),(679,'5','272',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,14000.00,0.00,'2022-11-28 07:02:08','',''),(680,'5','272','2',1,'Received from bridging 69',0.00,0.00,14000.00,0.00,0.00,'2022-11-28 07:02:08','',''),(681,'5','272','2',1,'Sale Id shift 180',0.00,0.00,0.00,7446.75,0.00,'2022-11-28 07:52:19','',''),(682,'5','272','2',1,'Sale Id shift 180',0.00,0.00,0.00,8697.39,0.00,'2022-11-28 07:52:19','',''),(683,'5','272',NULL,1,'Sale Id shift 180',2986665.90,0.00,0.00,0.00,0.00,'2022-11-28 07:52:19','',''),(684,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-11-29 19:17:12','',''),(685,'5','272',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,22500.00,0.00,'2022-11-29 20:04:18','',''),(686,'5','272','2',1,'Received from bridging 70',0.00,0.00,22500.00,0.00,0.00,'2022-11-29 20:04:18','',''),(687,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,23557.36,0.00,'2022-11-30 07:21:49','',''),(688,'5','272','2',0,'Inventory adjustment from tank dipping to 23700',0.00,0.00,23700.00,0.00,0.00,'2022-11-30 07:21:49','',''),(689,'5','272','2',1,'Sale Id shift 182',0.00,0.00,0.00,11352.46,0.00,'2022-11-30 07:34:02','',''),(690,'5','272','2',1,'Sale Id shift 182',0.00,0.00,0.00,12304.72,0.00,'2022-11-30 07:34:02','',''),(691,'5','272',NULL,1,'Sale Id shift 182',4376578.30,0.00,0.00,0.00,0.00,'2022-11-30 07:34:02','',''),(692,'5','272',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,22500.00,0.00,'2022-11-30 09:16:43','',''),(693,'5','272','2',1,'Received from bridging 71',0.00,0.00,22500.00,0.00,0.00,'2022-11-30 09:16:43','',''),(694,'5','272','2',1,'Sale Id shift 183',0.00,0.00,0.00,10580.58,0.00,'2022-12-01 07:45:14','',''),(695,'5','272','2',1,'Sale Id shift 183',0.00,0.00,0.00,11794.82,0.00,'2022-12-01 07:45:14','',''),(696,'5','272',NULL,1,'Sale Id shift 183',4139449.00,0.00,0.00,0.00,0.00,'2022-12-01 07:45:14','',''),(697,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,7381500.00,39900.00,0.00,0.00,'2022-12-01 22:30:45','',''),(698,'5','272',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,26500.00,0.00,'2022-12-02 06:25:08','',''),(699,'5','272','2',1,'Received from bridging 72',0.00,0.00,26500.00,0.00,0.00,'2022-12-02 06:25:08','',''),(700,'5','272','2',1,'Sale Id shift 184',0.00,0.00,0.00,12620.62,0.00,'2022-12-02 07:11:34','',''),(701,'5','272','2',1,'Sale Id shift 184',0.00,0.00,0.00,11954.17,0.00,'2022-12-02 07:11:34','',''),(702,'5','272',NULL,1,'Sale Id shift 184',4546336.15,0.00,0.00,0.00,0.00,'2022-12-02 07:11:34','',''),(703,'5','272',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,13300.00,0.00,'2022-12-02 10:08:13','',''),(704,'5','272','2',1,'Received from bridging 73',0.00,0.00,13300.00,0.00,0.00,'2022-12-02 10:08:13','',''),(705,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,15392.63,0.00,'2022-12-03 08:15:43','',''),(706,'5','272','2',0,'Inventory adjustment from tank dipping to 15600',0.00,0.00,15600.00,0.00,0.00,'2022-12-03 08:15:43','',''),(707,'5','272','2',1,'Sale Id shift 185',0.00,0.00,0.00,7257.70,0.00,'2022-12-03 08:23:15','',''),(708,'5','272','2',1,'Sale Id shift 185',0.00,0.00,0.00,8327.29,0.00,'2022-12-03 08:23:15','',''),(709,'5','272',NULL,1,'Sale Id shift 185',2883223.15,0.00,0.00,0.00,0.00,'2022-12-03 08:23:15','',''),(710,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-12-03 20:24:30','',''),(711,'5','272',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,15200.00,0.00,'2022-12-03 21:50:54','',''),(712,'5','272','2',1,'Received from bridging 74',0.00,0.00,15200.00,0.00,0.00,'2022-12-03 21:50:54','',''),(713,'5','272','2',1,'Sale Id shift 186',0.00,0.00,0.00,7499.43,0.00,'2022-12-04 09:15:55','',''),(714,'5','272','2',1,'Sale Id shift 186',0.00,0.00,0.00,7461.23,0.00,'2022-12-04 09:15:55','',''),(715,'5','272',NULL,1,'Sale Id shift 186',2767722.10,0.00,0.00,0.00,0.00,'2022-12-04 09:15:55','',''),(716,'5','272',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,29800.00,0.00,'2022-12-04 15:13:21','',''),(717,'5','272','2',1,'Received from bridging 75',0.00,0.00,29800.00,0.00,0.00,'2022-12-04 15:13:21','',''),(718,'5','272','2',1,'Sale Id shift 187',0.00,0.00,0.00,9795.58,0.00,'2022-12-05 07:35:58','',''),(719,'5','272','2',1,'Sale Id shift 187',0.00,0.00,0.00,10030.18,0.00,'2022-12-05 07:35:58','',''),(720,'5','272',NULL,1,'Sale Id shift 187',3667765.60,0.00,0.00,0.00,0.00,'2022-12-05 07:35:58','',''),(721,'5','272','2',1,'Sale Id shift 188',0.00,0.00,0.00,3300.91,0.00,'2022-12-06 07:57:36','',''),(722,'5','272','2',1,'Sale Id shift 188',0.00,0.00,0.00,4022.11,0.00,'2022-12-06 07:57:36','',''),(723,'5','272',NULL,1,'Sale Id shift 188',1354758.70,0.00,0.00,0.00,0.00,'2022-12-06 07:57:36','',''),(724,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-12-06 07:58:05','',''),(725,'5','272',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,15000.00,0.00,'2022-12-07 08:28:40','',''),(726,'5','272','2',1,'Received from bridging 76',0.00,0.00,15000.00,0.00,0.00,'2022-12-07 08:28:40','',''),(727,'5','272','2',1,'Sale Id shift 189',0.00,0.00,0.00,9329.50,0.00,'2022-12-07 15:04:48','',''),(728,'5','272',NULL,1,'Sale Id shift 189',1725957.50,0.00,0.00,0.00,0.00,'2022-12-07 15:04:48','',''),(729,'5','272','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,100.00,0.00,'2022-12-13 11:37:47','',''),(730,'5','272','1',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-12-13 11:37:47','',''),(731,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,8576.07,0.00,'2022-12-13 11:38:15','',''),(732,'5','272','2',0,'Inventory adjustment from tank dipping to 8950',0.00,0.00,8950.00,0.00,0.00,'2022-12-13 11:38:15','',''),(733,'5','272','2',1,'Sale Id shift 190',0.00,0.00,0.00,4905.59,0.00,'2022-12-13 11:50:49','',''),(734,'5','272','2',1,'Sale Id shift 190',0.00,0.00,0.00,3805.60,0.00,'2022-12-13 11:50:49','',''),(735,'5','272',NULL,1,'Sale Id shift 190',1611570.15,0.00,0.00,0.00,0.00,'2022-12-13 11:50:49','',''),(736,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,693935.00,3751.00,0.00,0.00,'2023-01-13 19:09:24','',''),(737,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8297250.00,44850.00,0.00,0.00,'2023-01-15 14:55:29','',''),(738,'5','272',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,30000.00,0.00,'2023-01-15 18:15:39','',''),(739,'5','272','2',1,'Received from bridging 77',0.00,0.00,30000.00,0.00,0.00,'2023-01-15 18:15:39','',''),(740,'5','272','2',1,'Sale Id shift 227',0.00,0.00,0.00,7303.68,0.00,'2023-01-15 22:50:46','',''),(741,'5','272',NULL,1,'Sale Id shift 227',1351180.80,0.00,0.00,0.00,0.00,'2023-01-15 22:50:46','',''),(742,'5','272','2',1,'Sale Id shift 228',0.00,0.00,0.00,7613.80,0.00,'2023-01-16 09:33:42','',''),(743,'5','272',NULL,1,'Sale Id shift 228',1408553.00,0.00,0.00,0.00,0.00,'2023-01-16 09:33:42','',''),(744,'5','272','2',1,'Sale Id shift 229',0.00,0.00,0.00,6684.23,0.00,'2023-01-16 11:03:23','',''),(745,'5','272','2',1,'Sale Id shift 229',0.00,0.00,0.00,6989.24,0.00,'2023-01-16 11:03:23','',''),(746,'5','272',NULL,1,'Sale Id shift 229',2529591.95,0.00,0.00,0.00,0.00,'2023-01-16 11:03:23','',''),(747,'5','272',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,14850.00,0.00,'2023-01-16 14:14:31','',''),(748,'5','272','2',1,'Received from bridging 78',0.00,0.00,14850.00,0.00,0.00,'2023-01-16 14:14:31','',''),(749,'5','272','2',1,'Sale Id shift 230',0.00,0.00,0.00,5501.38,0.00,'2023-01-17 09:40:04','',''),(750,'5','272','2',1,'Sale Id shift 230',0.00,0.00,0.00,5326.82,0.00,'2023-01-17 09:40:04','',''),(751,'5','272',NULL,1,'Sale Id shift 230',2003217.00,0.00,0.00,0.00,0.00,'2023-01-17 09:40:04','',''),(752,'5','272','2',1,'Sale Id shift 231',0.00,0.00,0.00,2559.18,0.00,'2023-01-18 09:13:05','',''),(753,'5','272','2',1,'Sale Id shift 231',0.00,0.00,0.00,3107.98,0.00,'2023-01-18 09:13:05','',''),(754,'5','272',NULL,1,'Sale Id shift 231',1048424.60,0.00,0.00,0.00,0.00,'2023-01-18 09:13:05','',''),(755,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,3344000.00,15200.00,0.00,0.00,'2023-01-22 10:37:03','',''),(756,'5','272',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,15200.00,0.00,'2023-01-22 11:40:13','',''),(757,'5','272','2',1,'Received from bridging 79',0.00,0.00,15200.00,0.00,0.00,'2023-01-22 11:40:13','',''),(758,'5','272','2',1,'Sale Id shift 235',0.00,0.00,0.00,1294.13,0.00,'2023-01-22 20:54:09','',''),(759,'5','272','2',1,'Sale Id shift 235',0.00,0.00,0.00,1134.03,0.00,'2023-01-22 20:54:09','',''),(760,'5','272',NULL,1,'Sale Id shift 235',449209.60,0.00,0.00,0.00,0.00,'2023-01-22 20:54:09','',''),(761,'5','272','2',1,'Sale Id shift 236',0.00,0.00,0.00,3447.98,0.00,'2023-01-23 10:12:02','',''),(762,'5','272','2',1,'Sale Id shift 236',0.00,0.00,0.00,4930.89,0.00,'2023-01-23 10:12:02','',''),(763,'5','272',NULL,1,'Sale Id shift 236',1843351.40,0.00,0.00,0.00,0.00,'2023-01-23 10:12:02','',''),(764,'5','272','2',1,'Sale Id shift 237',0.00,0.00,0.00,2049.85,0.00,'2023-01-24 11:27:26','',''),(765,'5','272','2',1,'Sale Id shift 237',0.00,0.00,0.00,2254.50,0.00,'2023-01-24 11:27:26','',''),(766,'5','272',NULL,1,'Sale Id shift 237',946957.00,0.00,0.00,0.00,0.00,'2023-01-24 11:27:26','',''),(767,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,6600000.00,30000.00,0.00,0.00,'2023-01-24 13:25:50','',''),(768,'5','272',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,30000.00,0.00,'2023-01-24 15:04:25','',''),(769,'5','272','2',1,'Received from bridging 80',0.00,0.00,30000.00,0.00,0.00,'2023-01-24 15:04:25','',''),(770,'5','272','2',1,'Sale Id shift 238',0.00,0.00,0.00,6213.13,0.00,'2023-01-25 09:34:15','',''),(771,'5','272','2',1,'Sale Id shift 238',0.00,0.00,0.00,2272.29,0.00,'2023-01-25 09:34:15','',''),(772,'5','272',NULL,1,'Sale Id shift 238',1866792.40,0.00,0.00,0.00,0.00,'2023-01-25 09:34:15','',''),(773,'5','272','2',1,'Sale Id shift 239',0.00,0.00,0.00,6852.10,0.00,'2023-01-26 10:09:37','',''),(774,'5','272','2',1,'Sale Id shift 239',0.00,0.00,0.00,1228.53,0.00,'2023-01-26 10:09:37','',''),(775,'5','272',NULL,1,'Sale Id shift 239',1777738.60,0.00,0.00,0.00,0.00,'2023-01-26 10:09:37','',''),(776,'5','272','2',1,'Sale Id shift 240',0.00,0.00,0.00,7873.65,0.00,'2023-01-27 10:02:00','',''),(777,'5','272',NULL,1,'Sale Id shift 240',1732203.00,0.00,0.00,0.00,0.00,'2023-01-27 10:02:00','',''),(778,'5','272','2',1,'Sale Id shift 241',0.00,0.00,0.00,4434.60,0.00,'2023-01-28 10:05:05','',''),(779,'5','272','2',1,'Sale Id shift 241',0.00,0.00,0.00,1173.01,0.00,'2023-01-28 10:05:05','',''),(780,'5','272',NULL,1,'Sale Id shift 241',1233674.20,0.00,0.00,0.00,0.00,'2023-01-28 10:05:05','',''),(781,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,3740000.00,17000.00,0.00,0.00,'2023-01-31 21:34:18','',''),(782,'5','272',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,17000.00,0.00,'2023-02-01 07:41:18','',''),(783,'5','272','2',1,'Received from bridging 81',0.00,0.00,17000.00,0.00,0.00,'2023-02-01 07:41:18','',''),(784,'5','272','2',1,'Sale Id shift 245',0.00,0.00,0.00,2765.25,0.00,'2023-02-02 09:50:56','',''),(785,'5','272',NULL,1,'Sale Id shift 245',608355.00,0.00,0.00,0.00,0.00,'2023-02-02 09:50:56','',''),(786,'5','272','2',1,'Sale Id shift 246',0.00,0.00,0.00,5008.66,0.00,'2023-02-02 10:01:46','',''),(787,'5','272','2',1,'Sale Id shift 246',0.00,0.00,0.00,1754.73,0.00,'2023-02-02 10:01:46','',''),(788,'5','272',NULL,1,'Sale Id shift 246',1487945.80,0.00,0.00,0.00,0.00,'2023-02-02 10:01:46','',''),(789,'5','272','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,7515.17,0.00,'2023-02-03 10:05:41','',''),(790,'5','272','2',0,'Inventory adjustment from tank dipping to 7900',0.00,0.00,7900.00,0.00,0.00,'2023-02-03 10:05:41','',''),(791,'5','272','2',1,'Sale Id shift 247',0.00,0.00,0.00,3521.14,0.00,'2023-02-03 11:02:49','',''),(792,'5','272','2',1,'Sale Id shift 247',0.00,0.00,0.00,3997.08,0.00,'2023-02-03 11:02:49','',''),(793,'5','272',NULL,1,'Sale Id shift 247',1654008.40,0.00,0.00,0.00,0.00,'2023-02-03 11:02:49','',''),(794,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,3300000.00,15000.00,0.00,0.00,'2023-02-07 10:38:16','',''),(795,'5','272',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,15000.00,0.00,'2023-02-07 15:17:20','',''),(796,'5','272','2',1,'Received from bridging 82',0.00,0.00,15000.00,0.00,0.00,'2023-02-07 15:17:20','',''),(797,'5','272','2',1,'Sale Id shift 251',0.00,0.00,0.00,576.70,0.00,'2023-02-07 15:31:49','',''),(798,'5','272','2',1,'Sale Id shift 251',0.00,0.00,0.00,1214.07,0.00,'2023-02-07 15:31:49','',''),(799,'5','272',NULL,1,'Sale Id shift 251',393969.40,0.00,0.00,0.00,0.00,'2023-02-07 15:31:49','',''),(800,'5','272','2',1,'Sale Id shift 252',0.00,0.00,0.00,5406.23,0.00,'2023-02-08 09:37:40','',''),(801,'5','272',NULL,1,'Sale Id shift 252',1189370.60,0.00,0.00,0.00,0.00,'2023-02-08 09:37:40','',''),(802,'5','272','2',1,'Sale Id shift 253',0.00,0.00,0.00,1000.00,0.00,'2023-02-09 13:41:38','',''),(803,'5','272','2',1,'Sale Id shift 253',0.00,0.00,0.00,1041.56,0.00,'2023-02-09 13:41:38','',''),(804,'5','272',NULL,1,'Sale Id shift 253',449143.20,0.00,0.00,0.00,0.00,'2023-02-09 13:41:38','',''),(805,'5','272','2',1,'Sale Id shift 257',0.00,0.00,0.00,616.82,0.00,'2023-02-13 16:51:24','',''),(806,'5','272','2',1,'Sale Id shift 257',0.00,0.00,0.00,1424.66,0.00,'2023-02-13 16:51:24','',''),(807,'5','272',NULL,1,'Sale Id shift 257',449125.60,0.00,0.00,0.00,0.00,'2023-02-13 16:51:24','',''),(808,'5','272','2',1,'Sale Id shift 258',0.00,0.00,0.00,3658.52,0.00,'2023-02-14 11:27:51','',''),(809,'5','272',NULL,1,'Sale Id shift 258',804874.40,0.00,0.00,0.00,0.00,'2023-02-14 11:27:51','',''),(810,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,6300000.00,30000.00,0.00,0.00,'2023-02-25 09:27:02','',''),(811,'5','272',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,15000.00,0.00,'2023-02-25 13:34:34','',''),(812,'5','272','1',1,'Received from bridging 83',0.00,0.00,15000.00,0.00,0.00,'2023-02-25 13:34:34','',''),(813,'5','272',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,15000.00,0.00,'2023-02-25 13:34:45','',''),(814,'5','272','2',1,'Received from bridging 84',0.00,0.00,15000.00,0.00,0.00,'2023-02-25 13:34:45','',''),(815,'5','272','1',1,'Sale Id shift 267',0.00,0.00,0.00,2889.11,0.00,'2023-02-25 21:21:05','',''),(816,'5','272','1',1,'Sale Id shift 267',0.00,0.00,0.00,2141.99,0.00,'2023-02-25 21:21:05','',''),(817,'5','272','2',1,'Sale Id shift 267',0.00,0.00,0.00,3895.85,0.00,'2023-02-25 21:21:05','',''),(818,'5','272','2',1,'Sale Id shift 267',0.00,0.00,0.00,4373.78,0.00,'2023-02-25 21:21:05','',''),(819,'5','272',NULL,1,'Sale Id shift 267',2793153.30,0.00,0.00,0.00,0.00,'2023-02-25 21:21:05','',''),(820,'5','272','1',1,'Sale Id shift 268',0.00,0.00,0.00,4627.54,0.00,'2023-02-26 10:00:51','',''),(821,'5','272','1',1,'Sale Id shift 268',0.00,0.00,0.00,3943.57,0.00,'2023-02-26 10:00:51','',''),(822,'5','272','2',1,'Sale Id shift 268',0.00,0.00,0.00,2857.47,0.00,'2023-02-26 10:00:51','',''),(823,'5','272','2',1,'Sale Id shift 268',0.00,0.00,0.00,3620.86,0.00,'2023-02-26 10:00:51','',''),(824,'5','272',NULL,1,'Sale Id shift 268',3160382.40,0.00,0.00,0.00,0.00,'2023-02-26 10:00:51','',''),(825,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,9439500.00,44950.00,0.00,0.00,'2023-02-27 08:40:18','',''),(826,'5','272',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,30000.00,0.00,'2023-02-27 18:02:36','',''),(827,'5','272','2',1,'Received from bridging 86',0.00,0.00,30000.00,0.00,0.00,'2023-02-27 18:02:36','',''),(828,'5','272',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,14950.00,0.00,'2023-02-27 18:02:47','',''),(829,'5','272','1',1,'Received from bridging 85',0.00,0.00,14950.00,0.00,0.00,'2023-02-27 18:02:47','',''),(830,'5','272','1',1,'Sale Id shift 270',0.00,0.00,0.00,3013.10,0.00,'2023-02-28 09:22:46','',''),(831,'5','272','1',1,'Sale Id shift 270',0.00,0.00,0.00,3299.60,0.00,'2023-02-28 09:22:46','',''),(832,'5','272','2',1,'Sale Id shift 270',0.00,0.00,0.00,4867.02,0.00,'2023-02-28 09:22:46','',''),(833,'5','272','2',1,'Sale Id shift 270',0.00,0.00,0.00,5131.00,0.00,'2023-02-28 09:22:46','',''),(834,'5','272',NULL,1,'Sale Id shift 270',3425251.20,0.00,0.00,0.00,0.00,'2023-02-28 09:22:46','',''),(835,'5','272','1',1,'Sale Id shift 271',0.00,0.00,0.00,2928.53,0.00,'2023-02-28 14:11:04','',''),(836,'5','272','1',1,'Sale Id shift 271',0.00,0.00,0.00,2092.88,0.00,'2023-02-28 14:11:04','',''),(837,'5','272','2',1,'Sale Id shift 271',0.00,0.00,0.00,7610.66,0.00,'2023-02-28 14:11:04','',''),(838,'5','272',NULL,1,'Sale Id shift 271',2652734.70,0.00,0.00,0.00,0.00,'2023-02-28 14:11:04','',''),(839,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8211000.00,39100.00,0.00,0.00,'2023-03-01 09:01:53','',''),(840,'5','272',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,13300.00,0.00,'2023-03-01 09:54:55','',''),(841,'5','272','1',1,'Received from bridging 87',0.00,0.00,13300.00,0.00,0.00,'2023-03-01 09:54:55','',''),(842,'5','272',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,13500.00,0.00,'2023-03-01 09:55:02','',''),(843,'5','272','2',1,'Received from bridging 88',0.00,0.00,13500.00,0.00,0.00,'2023-03-01 09:55:02','',''),(844,'5','272','2',1,'Sale Id shift 272',0.00,0.00,0.00,3686.85,0.00,'2023-03-02 08:54:23','',''),(845,'5','272','2',1,'Sale Id shift 272',0.00,0.00,0.00,12755.91,0.00,'2023-03-02 08:54:23','',''),(846,'5','272',NULL,1,'Sale Id shift 272',3452979.60,0.00,0.00,0.00,0.00,'2023-03-02 08:54:23','',''),(847,'5','272',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,12300.00,0.00,'2023-03-03 11:29:02','',''),(848,'5','272','2',1,'Received from bridging 89',0.00,0.00,12300.00,0.00,0.00,'2023-03-03 11:29:02','',''),(849,'5','272','2',1,'Sale Id shift 273',0.00,0.00,0.00,3012.68,0.00,'2023-03-03 11:32:46','',''),(850,'5','272','2',1,'Sale Id shift 273',0.00,0.00,0.00,4936.11,0.00,'2023-03-03 11:32:46','',''),(851,'5','272',NULL,1,'Sale Id shift 273',1669245.90,0.00,0.00,0.00,0.00,'2023-03-03 11:32:46','',''),(852,'5','272','2',1,'Sale Id shift 274',0.00,0.00,0.00,4201.23,0.00,'2023-03-03 14:16:11','',''),(853,'5','272','2',1,'Sale Id shift 274',0.00,0.00,0.00,7361.00,0.00,'2023-03-03 14:16:11','',''),(854,'5','272',NULL,1,'Sale Id shift 274',2428068.30,0.00,0.00,0.00,0.00,'2023-03-03 14:16:11','',''),(855,'5','272','1',1,'Sale Id shift 275',0.00,0.00,0.00,7220.55,0.00,'2023-03-05 08:31:13','',''),(856,'5','272',NULL,1,'Sale Id shift 275',1516315.50,0.00,0.00,0.00,0.00,'2023-03-05 08:31:13','',''),(857,'5','272','1',1,'Sale Id shift 276',0.00,0.00,0.00,6252.12,0.00,'2023-03-05 18:23:59','',''),(858,'5','272','2',1,'Sale Id shift 276',0.00,0.00,0.00,968.82,0.00,'2023-03-05 18:23:59','',''),(859,'5','272','2',1,'Sale Id shift 276',0.00,0.00,0.00,980.46,0.00,'2023-03-05 18:23:59','',''),(860,'5','272',NULL,1,'Sale Id shift 276',1722294.00,0.00,0.00,0.00,0.00,'2023-03-05 18:23:59','',''),(861,'5','272','1',1,'Sale Id shift 277',0.00,0.00,0.00,3238.70,0.00,'2023-03-06 08:50:18','',''),(862,'5','272',NULL,1,'Sale Id shift 277',680127.00,0.00,0.00,0.00,0.00,'2023-03-06 08:50:18','',''),(863,'5','272','1',1,'Sale Id shift 278',0.00,0.00,0.00,663.37,0.00,'2023-03-07 09:16:18','',''),(864,'5','272','1',1,'Sale Id shift 278',0.00,0.00,0.00,682.75,0.00,'2023-03-07 09:16:18','',''),(865,'5','272','2',1,'Sale Id shift 278',0.00,0.00,0.00,15.26,0.00,'2023-03-07 09:16:18','',''),(866,'5','272','2',1,'Sale Id shift 278',0.00,0.00,0.00,225.88,0.00,'2023-03-07 09:16:18','',''),(867,'5','272',NULL,1,'Sale Id shift 278',333324.60,0.00,0.00,0.00,0.00,'2023-03-07 09:16:18','',''),(868,'5','272',NULL,1,'Purchased from SALBAS OIL AND GAS LTD',0.00,8400000.00,40000.00,0.00,0.00,'2023-03-07 09:17:28','',''),(869,'5','272',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,13500.00,0.00,'2023-03-08 08:26:11','',''),(870,'5','272','1',1,'Received from bridging 90',0.00,0.00,13500.00,0.00,0.00,'2023-03-08 08:26:11','',''),(871,'5','272',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,26500.00,0.00,'2023-03-08 08:26:24','',''),(872,'5','272','2',1,'Received from bridging 91',0.00,0.00,26500.00,0.00,0.00,'2023-03-08 08:26:24','',''),(873,'5','272','1',1,'Sale Id shift 279',0.00,0.00,0.00,2901.50,0.00,'2023-03-08 14:05:25','',''),(874,'5','272','1',1,'Sale Id shift 279',0.00,0.00,0.00,3016.32,0.00,'2023-03-08 14:05:25','',''),(875,'5','272','2',1,'Sale Id shift 279',0.00,0.00,0.00,2381.49,0.00,'2023-03-08 14:05:25','',''),(876,'5','272','2',1,'Sale Id shift 279',0.00,0.00,0.00,1677.96,0.00,'2023-03-08 14:05:25','',''),(877,'5','272',NULL,1,'Sale Id shift 279',2095226.70,0.00,0.00,0.00,0.00,'2023-03-08 14:05:25','',''),(878,'5','272','1',1,'Sale Id shift 280',0.00,0.00,0.00,2079.33,0.00,'2023-03-10 09:50:06','',''),(879,'5','272','2',1,'Sale Id shift 280',0.00,0.00,0.00,3609.26,0.00,'2023-03-10 09:50:06','',''),(880,'5','272','2',1,'Sale Id shift 280',0.00,0.00,0.00,4924.57,0.00,'2023-03-10 09:50:06','',''),(881,'5','272',NULL,1,'Sale Id shift 280',2228763.60,0.00,0.00,0.00,0.00,'2023-03-10 09:50:06','',''),(882,'5','272','1',1,'Sale Id shift 281',0.00,0.00,0.00,473.23,0.00,'2023-03-10 11:30:05','',''),(883,'5','272','2',1,'Sale Id shift 281',0.00,0.00,0.00,7781.32,0.00,'2023-03-10 11:30:05','',''),(884,'5','272',NULL,1,'Sale Id shift 281',1733455.50,0.00,0.00,0.00,0.00,'2023-03-10 11:30:05','',''),(885,'5','272','1',1,'Sale Id shift 282',0.00,0.00,0.00,4415.59,0.00,'2023-03-13 09:29:17','',''),(886,'5','272','2',1,'Sale Id shift 282',0.00,0.00,0.00,6046.72,0.00,'2023-03-13 09:29:17','',''),(887,'5','272',NULL,1,'Sale Id shift 282',2197085.10,0.00,0.00,0.00,0.00,'2023-03-13 09:29:17','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','272',2,0.00,'2023-03-20 07:36:04'),(2,'5','272',1,3819.74,'2023-03-20 07:36:04');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'5','272',1,'Sale Id shift 1',0.00,821511.90,165.00,821511.90,0.00,'2022-06-02 13:00:18'),(2,'5','272',1,'Sale Id shift 2',0.00,994747.05,165.00,994747.05,0.00,'2022-06-02 21:31:40'),(3,'5','272',1,'Sale Id shift 3',0.00,546308.40,165.00,546308.40,0.00,'2022-06-04 06:04:58'),(4,'5','272',1,'Sale Id shift 4',0.00,1368684.90,165.00,1368684.90,0.00,'2022-06-05 06:05:56'),(5,'5','272',1,'Sale Id shift 5',0.00,447816.60,165.00,447816.60,0.00,'2022-06-06 06:25:37'),(6,'5','272',1,'Sale Id shift 6',0.00,1450642.05,165.00,1450642.05,0.00,'2022-06-07 07:25:13'),(7,'5','272',1,'Sale Id shift 7',0.00,1785816.45,165.00,1785816.45,0.00,'2022-06-08 10:30:37'),(8,'5','272',1,'Sale Id shift 8',0.00,1604550.75,165.00,1604550.75,0.00,'2022-06-09 23:02:10'),(9,'5','272',1,'Sale Id shift 9',0.00,1007541.15,165.00,1007541.15,0.00,'2022-06-10 05:24:33'),(10,'5','272',1,'Sale Id shift 10',0.00,841712.85,165.00,841712.85,0.00,'2022-06-10 21:42:03'),(11,'5','272',1,'Sale Id shift 11',0.00,577874.55,165.00,577874.55,0.00,'2022-06-12 08:29:23'),(12,'5','272',1,'Sale Id shift 12',0.00,333351.15,165.00,333351.15,0.00,'2022-06-13 06:53:19'),(13,'5','272',1,'Sale Id shift 13',0.00,349740.60,165.00,349740.60,0.00,'2022-06-14 08:57:05'),(14,'5','272',1,'Sale Id shift 14',0.00,307885.05,165.00,307885.05,0.00,'2022-06-15 07:35:47'),(15,'5','272',1,'Sale Id shift 15',0.00,508416.15,165.00,508416.15,0.00,'2022-06-16 07:00:38'),(16,'5','272',1,'Sale Id shift 16',0.00,315230.85,165.00,315230.85,0.00,'2022-06-17 05:58:56'),(17,'5','272',1,'Sale Id shift 17',0.00,371655.90,165.00,371655.90,0.00,'2022-06-18 07:01:47'),(18,'5','272',1,'Sale Id shift 18',0.00,330001.65,165.00,330001.65,0.00,'2022-06-18 22:46:10'),(19,'5','272',1,'Sale Id shift 19',0.00,267465.00,165.00,267465.00,0.00,'2022-06-20 06:45:25'),(20,'5','272',1,'Sale Id shift 20',0.00,43256.40,165.00,43256.40,0.00,'2022-06-21 07:53:30'),(21,'5','272',1,'Sale Id shift 37',0.00,176134.20,165.00,176134.20,0.00,'2022-07-10 17:45:01'),(22,'5','272',1,'Sale Id shift 38',0.00,915990.90,165.00,915990.90,0.00,'2022-07-11 08:18:12'),(23,'5','272',1,'Sale Id shift 39',0.00,377749.65,185.00,377749.65,0.00,'2022-07-11 08:32:52'),(24,'5','272',1,'Sale Id shift 40',0.00,467075.05,185.00,467075.05,0.00,'2022-07-11 08:44:16'),(25,'5','272',1,'Sale Id shift 41',0.00,790001.80,185.00,790001.80,0.00,'2022-07-12 05:21:19'),(26,'5','272',1,'Sale Id shift 42',0.00,383353.30,185.00,383353.30,0.00,'2022-07-13 07:16:58'),(27,'5','272',1,'Sale Id shift 43',0.00,455532.90,185.00,455532.90,0.00,'2022-07-14 06:31:32'),(28,'5','272',1,'Sale Id shift 44',0.00,540126.00,185.00,540126.00,0.00,'2022-07-15 07:15:57'),(29,'5','272',1,'Sale Id shift 45',0.00,2196965.65,185.00,2196965.65,0.00,'2022-07-16 06:52:10'),(30,'5','272',1,'Sale Id shift 46',0.00,1904441.80,185.00,1904441.80,0.00,'2022-07-17 05:28:12'),(31,'5','272',1,'Sale Id shift 47',0.00,1892141.15,185.00,1892141.15,0.00,'2022-07-18 07:32:47'),(32,'5','272',1,'Sale Id shift 48',0.00,1532715.75,185.00,1532715.75,0.00,'2022-07-19 12:16:04'),(33,'5','272',1,'Sale Id shift 49',0.00,2450857.80,185.00,2450857.80,0.00,'2022-07-20 12:58:23'),(34,'5','272',1,'Sale Id shift 50',0.00,3044189.80,185.00,3044189.80,0.00,'2022-07-21 06:47:33'),(35,'5','272',1,'Sale Id shift 51',0.00,2798726.25,185.00,2798726.25,0.00,'2022-07-21 23:17:29'),(36,'5','272',1,'Sale Id shift 52',0.00,1258688.20,185.00,1258688.20,0.00,'2022-07-23 06:53:17'),(37,'5','272',1,'Sale Id shift 53',0.00,1567769.55,185.00,1567769.55,0.00,'2022-07-24 08:30:55'),(38,'5','272',1,'Sale Id shift 54',0.00,2660668.15,185.00,2660668.15,0.00,'2022-07-25 06:43:31'),(39,'5','272',1,'Sale Id shift 55',0.00,1736422.95,185.00,1736422.95,0.00,'2022-07-26 05:52:23'),(40,'5','272',1,'Sale Id shift 56',0.00,1506825.00,185.00,1506825.00,0.00,'2022-07-27 06:03:09'),(41,'5','272',1,'Sale Id shift 57',0.00,334665.00,185.00,334665.00,0.00,'2022-07-28 06:52:24'),(42,'5','272',1,'Sale Id shift 58',0.00,269476.55,185.00,269476.55,0.00,'2022-07-29 07:11:00'),(43,'5','272',1,'Sale Id shift 59',0.00,312139.40,185.00,312139.40,0.00,'2022-07-30 05:46:25'),(44,'5','272',1,'Sale Id shift 60',0.00,277625.80,185.00,277625.80,0.00,'2022-07-31 05:21:53'),(45,'5','272',1,'Sale Id shift 61',0.00,285911.95,185.00,285911.95,0.00,'2022-08-01 07:47:38'),(46,'5','272',1,'Sale Id shift 63',0.00,706298.55,185.00,706298.55,0.00,'2022-08-03 06:56:53'),(47,'5','272',1,'Sale Id shift 64',0.00,3717438.10,185.00,3717438.10,0.00,'2022-08-04 06:13:20'),(48,'5','272',1,'Sale Id shift 65',0.00,410757.35,185.00,410757.35,0.00,'2022-08-05 06:33:10'),(49,'5','272',1,'Sale Id shift 66',0.00,804269.00,185.00,804269.00,0.00,'2022-08-06 06:59:22'),(50,'5','272',1,'Sale Id shift 67',0.00,1732883.90,185.00,1732883.90,0.00,'2022-08-07 05:33:52'),(51,'5','272',1,'Sale Id shift 68',0.00,1467806.65,185.00,1467806.65,0.00,'2022-09-05 06:47:20'),(52,'5','272',1,'Sale Id shift 69',0.00,2606132.00,185.00,2606132.00,0.00,'2022-09-06 11:49:20'),(53,'5','272',1,'Sale Id shift 70',0.00,2236061.70,185.00,2236061.70,0.00,'2022-09-06 12:04:28'),(54,'5','272',1,'Sale Id shift 71',0.00,2775599.40,185.00,2775599.40,0.00,'2022-09-06 12:24:51'),(55,'5','272',1,'Sale Id shift 72',0.00,2783249.15,185.00,2783249.15,0.00,'2022-09-06 12:31:21'),(56,'5','272',1,'Sale Id shift 73',0.00,2093075.20,185.00,2093075.20,0.00,'2022-09-06 12:35:46'),(57,'5','272',1,'Sale Id shift 74',0.00,2525216.70,185.00,2525216.70,0.00,'2022-09-06 13:26:53'),(58,'5','272',1,'Sale Id shift 75',0.00,2290697.75,185.00,2290697.75,0.00,'2022-09-06 13:49:15'),(59,'5','272',1,'Sale Id shift 76',0.00,2181000.15,185.00,2181000.15,0.00,'2022-09-06 14:27:58'),(60,'5','272',1,'Sale Id shift 77',0.00,1901679.75,185.00,1901679.75,0.00,'2022-09-06 14:31:41'),(61,'5','272',1,'Sale Id shift 78',0.00,1900007.35,185.00,1900007.35,0.00,'2022-09-06 14:36:42'),(62,'5','272',1,'Sale Id shift 79',0.00,2074776.85,185.00,2074776.85,0.00,'2022-09-06 14:40:23'),(63,'5','272',1,'Sale Id shift 80',0.00,2539293.35,185.00,2539293.35,0.00,'2022-09-06 15:13:05'),(64,'5','272',1,'Sale Id shift 81',0.00,2577087.00,185.00,2577087.00,0.00,'2022-09-06 15:41:02'),(65,'5','272',1,'Sale Id shift 82',0.00,1610893.05,185.00,1610893.05,0.00,'2022-09-06 16:03:53'),(66,'5','272',1,'Sale Id shift 83',0.00,1820927.25,185.00,1820927.25,0.00,'2022-09-08 12:30:07'),(67,'5','272',1,'Sale Id shift 84',0.00,2119648.60,185.00,2119648.60,0.00,'2022-09-08 12:33:01'),(68,'5','272',1,'Sale Id shift 85',0.00,2494478.95,185.00,2494478.95,0.00,'2022-09-08 12:41:23'),(69,'5','272',1,'Sale Id shift 86',0.00,2301459.20,185.00,2301459.20,0.00,'2022-09-08 13:45:58'),(70,'5','272',1,'Sale Id shift 87',0.00,2785865.05,185.00,2785865.05,0.00,'2022-09-08 13:54:59'),(71,'5','272',1,'Sale Id shift 88',0.00,2457556.65,185.00,2457556.65,0.00,'2022-09-08 13:59:55'),(72,'5','272',1,'Sale Id shift 89',0.00,2310450.20,185.00,2310450.20,0.00,'2022-09-08 14:21:15'),(73,'5','272',1,'Sale Id shift 90',0.00,2759369.35,185.00,2759369.35,0.00,'2022-09-08 14:41:50'),(74,'5','272',1,'Sale Id shift 91',0.00,2491071.25,185.00,2491071.25,0.00,'2022-09-08 14:57:45'),(75,'5','272',1,'Sale Id shift 92',0.00,844991.20,185.00,844991.20,0.00,'2022-09-08 15:28:44'),(76,'5','272',1,'Sale Id shift 93',0.00,448247.60,185.00,448247.60,0.00,'2022-09-08 16:09:00'),(77,'5','272',1,'Sale Id shift 94',0.00,1009794.75,185.00,1009794.75,0.00,'2022-09-08 16:15:06'),(78,'5','272',1,'Sale Id shift 95',0.00,2606986.70,185.00,2606986.70,0.00,'2022-09-08 16:34:59'),(79,'5','272',1,'Sale Id shift 96',0.00,1970727.30,185.00,1970727.30,0.00,'2022-09-08 16:41:43'),(80,'5','272',1,'Sale Id shift 97',0.00,2573466.55,185.00,2573466.55,0.00,'2022-09-08 16:45:50'),(81,'5','272',1,'Sale Id shift 98',0.00,2602937.05,185.00,2602937.05,0.00,'2022-09-20 15:35:34'),(82,'5','272',1,'Sale Id shift 99',0.00,2473457.40,185.00,2473457.40,0.00,'2022-09-20 16:03:52'),(83,'5','272',1,'Sale Id shift 100',0.00,1809288.90,185.00,1809288.90,0.00,'2022-09-22 17:58:49'),(84,'5','272',1,'Sale Id shift 101',0.00,691840.80,185.00,691840.80,0.00,'2022-09-22 18:09:28'),(85,'5','272',1,'Sale Id shift 102',0.00,375747.95,185.00,375747.95,0.00,'2022-09-22 18:13:27'),(86,'5','272',1,'Sale Id shift 103',0.00,314500.00,185.00,314500.00,0.00,'2022-09-22 18:16:02'),(87,'5','272',1,'Sale Id shift 104',0.00,873077.90,185.00,873077.90,0.00,'2022-09-22 18:23:56'),(88,'5','272',1,'Sale Id shift 105',0.00,1448087.50,185.00,1448087.50,0.00,'2022-09-26 15:38:07'),(89,'5','272',1,'Sale Id shift 106',0.00,2528609.60,185.00,2528609.60,0.00,'2022-09-26 15:42:36'),(90,'5','272',1,'Sale Id shift 107',0.00,1087761.15,185.00,1087761.15,0.00,'2022-09-26 15:49:06'),(91,'5','272',1,'Sale Id shift 108',0.00,2793662.80,185.00,2793662.80,0.00,'2022-09-26 16:09:11'),(92,'5','272',1,'Sale Id shift 109',0.00,2740558.55,185.00,2740558.55,0.00,'2022-09-26 16:14:51'),(93,'5','272',1,'Sale Id shift 110',0.00,1681163.45,185.00,1681163.45,0.00,'2022-09-26 16:18:03'),(94,'5','272',1,'Sale Id shift 111',0.00,1826247.85,185.00,1826247.85,0.00,'2022-09-26 16:21:01'),(95,'5','272',1,'Sale Id shift 112',0.00,2143162.10,185.00,2143162.10,0.00,'2022-09-26 16:42:53'),(96,'5','272',1,'Sale Id shift 113',0.00,2012800.00,185.00,2012800.00,0.00,'2022-09-26 16:48:59'),(97,'5','272',1,'Sale Id shift 114',0.00,1856682.20,185.00,1856682.20,0.00,'2022-09-26 17:08:09'),(98,'5','272',1,'Sale Id shift 115',0.00,2391507.95,185.00,2391507.95,0.00,'2022-09-26 18:09:25'),(99,'5','272',1,'Sale Id shift 116',0.00,2380050.90,185.00,2380050.90,0.00,'2022-09-26 18:21:48'),(100,'5','272',1,'Sale Id shift 117',0.00,1611253.80,185.00,1611253.80,0.00,'2022-09-26 18:25:14'),(101,'5','272',1,'Sale Id shift 118',0.00,2426793.00,185.00,2426793.00,0.00,'2022-09-27 09:44:05'),(102,'5','272',1,'Sale Id shift 119',0.00,1531367.10,185.00,1531367.10,0.00,'2022-09-28 08:21:33'),(103,'5','272',1,'Sale Id shift 120',0.00,2515482.00,185.00,2515482.00,0.00,'2022-09-29 08:33:21'),(104,'5','272',1,'Sale Id shift 121',0.00,2620913.50,185.00,2620913.50,0.00,'2022-09-30 08:06:58'),(105,'5','272',1,'Sale Id shift 122',0.00,2435462.10,185.00,2435462.10,0.00,'2022-10-01 08:57:05'),(106,'5','272',1,'Sale Id shift 123',0.00,2458032.10,185.00,2458032.10,0.00,'2022-10-04 11:34:21'),(107,'5','272',1,'Sale Id shift 124',0.00,2060783.45,185.00,2060783.45,0.00,'2022-10-04 11:57:32'),(108,'5','272',1,'Sale Id shift 125',0.00,1463764.40,185.00,1463764.40,0.00,'2022-10-04 13:19:02'),(109,'5','272',1,'Sale Id shift 126',0.00,957861.55,185.00,957861.55,0.00,'2022-10-05 09:36:31'),(110,'5','272',1,'Sale Id shift 127',0.00,422419.75,185.00,422419.75,0.00,'2022-10-06 07:57:45'),(111,'5','272',1,'Sale Id shift 128',0.00,103503.80,185.00,103503.80,0.00,'2022-10-07 10:18:47'),(112,'5','272',1,'Sale Id shift 129',0.00,335954.45,185.00,335954.45,0.00,'2022-10-08 08:34:56'),(113,'5','272',1,'Sale Id shift 130',0.00,245472.80,185.00,245472.80,0.00,'2022-10-09 08:30:28'),(114,'5','272',1,'Sale Id shift 132',0.00,537334.35,185.00,537334.35,0.00,'2022-10-12 15:06:30'),(115,'5','272',1,'Sale Id shift 133',0.00,3473304.70,185.00,3473304.70,0.00,'2022-10-12 22:11:54'),(116,'5','272',1,'Sale Id shift 134',0.00,2698604.25,185.00,2698604.25,0.00,'2022-10-13 05:39:41'),(117,'5','272',1,'Sale Id shift 135',0.00,2521810.85,185.00,2521810.85,0.00,'2022-10-14 07:28:05'),(118,'5','272',1,'Sale Id shift 136',0.00,2804814.60,185.00,2804814.60,0.00,'2022-10-15 22:26:01'),(119,'5','272',1,'Sale Id shift 137',0.00,2725035.20,185.00,2725035.20,0.00,'2022-10-16 09:42:07'),(120,'5','272',1,'Sale Id shift 138',0.00,3304492.20,185.00,3304492.20,0.00,'2022-10-17 07:34:55'),(121,'5','272',1,'Sale Id shift 139',0.00,2523094.75,185.00,2523094.75,0.00,'2022-10-19 20:10:03'),(122,'5','272',1,'Sale Id shift 140',0.00,3456099.70,185.00,3456099.70,0.00,'2022-10-19 20:26:43'),(123,'5','272',1,'Sale Id shift 141',0.00,2077969.95,185.00,2077969.95,0.00,'2022-10-20 07:02:20'),(124,'5','272',1,'Sale Id shift 142',0.00,2178870.80,185.00,2178870.80,0.00,'2022-10-21 07:40:04'),(125,'5','272',1,'Sale Id shift 143',0.00,1281145.35,185.00,1281145.35,0.00,'2022-10-22 06:16:04'),(126,'5','272',1,'Sale Id shift 150',0.00,2236008.05,185.00,2236008.05,0.00,'2022-10-30 06:33:39'),(127,'5','272',1,'Sale Id shift 151',0.00,2168864.15,185.00,2168864.15,0.00,'2022-10-30 17:49:12'),(128,'5','272',1,'Sale Id shift 152',0.00,1228536.90,185.00,1228536.90,0.00,'2022-10-31 06:45:00'),(129,'5','272',1,'Sale Id shift 153',0.00,1421310.60,185.00,1421310.60,0.00,'2022-11-01 06:40:21'),(130,'5','272',1,'Sale Id shift 154',0.00,1297806.45,185.00,1297806.45,0.00,'2022-11-02 08:22:06'),(131,'5','272',1,'Sale Id shift 162',0.00,2818878.30,185.00,2818878.30,0.00,'2022-11-14 09:09:51'),(132,'5','272',1,'Sale Id shift 163',0.00,2210596.45,185.00,2210596.45,0.00,'2022-11-14 12:39:26'),(133,'5','272',1,'Sale Id shift 164',0.00,2271964.65,185.00,2271964.65,0.00,'2022-11-14 13:28:04'),(134,'5','272',1,'Sale Id shift 166',0.00,1044363.85,185.00,1044363.85,0.00,'2022-11-16 07:34:22'),(135,'5','272',1,'Sale Id shift 173',0.00,1385637.05,185.00,1385637.05,0.00,'2022-11-21 16:16:58'),(136,'5','272',1,'Sale Id shift 174',0.00,1200291.10,185.00,1200291.10,0.00,'2022-11-22 09:21:52'),(137,'5','272',1,'Sale Id shift 175',0.00,3777934.95,185.00,3777934.95,0.00,'2022-11-23 16:29:35'),(138,'5','272',1,'Sale Id shift 176',0.00,3560772.70,185.00,3560772.70,0.00,'2022-11-24 13:07:15'),(139,'5','272',1,'Sale Id shift 177',0.00,4133423.55,185.00,4133423.55,0.00,'2022-11-25 08:32:36'),(140,'5','272',1,'Sale Id shift 178',0.00,4157412.50,185.00,4157412.50,0.00,'2022-11-26 11:47:08'),(141,'5','272',1,'Sale Id shift 179',0.00,4209950.65,185.00,4209950.65,0.00,'2022-11-28 06:14:23'),(142,'5','272',1,'Sale Id shift 180',0.00,2986665.90,185.00,2986665.90,0.00,'2022-11-28 07:52:19'),(143,'5','272',1,'Sale Id shift 182',0.00,4376578.30,185.00,4376578.30,0.00,'2022-11-30 07:34:02'),(144,'5','272',1,'Sale Id shift 183',0.00,4139449.00,185.00,4139449.00,0.00,'2022-12-01 07:45:14'),(145,'5','272',1,'Sale Id shift 184',0.00,4546336.15,185.00,4546336.15,0.00,'2022-12-02 07:11:34'),(146,'5','272',1,'Sale Id shift 185',0.00,2883223.15,185.00,2883223.15,0.00,'2022-12-03 08:23:15'),(147,'5','272',1,'Sale Id shift 186',0.00,2767722.10,185.00,2767722.10,0.00,'2022-12-04 09:15:55'),(148,'5','272',1,'Sale Id shift 187',0.00,3667765.60,185.00,3667765.60,0.00,'2022-12-05 07:35:58'),(149,'5','272',1,'Sale Id shift 188',0.00,1354758.70,185.00,1354758.70,0.00,'2022-12-06 07:57:36'),(150,'5','272',1,'Sale Id shift 189',0.00,1725957.50,185.00,1725957.50,0.00,'2022-12-07 15:04:48'),(151,'5','272',1,'Sale Id shift 190',0.00,1611570.15,185.00,1611570.15,0.00,'2022-12-13 11:50:49'),(152,'5','272',1,'Sale Id shift 227',0.00,1351180.80,185.00,1351180.80,0.00,'2023-01-15 22:50:46'),(153,'5','272',1,'Sale Id shift 228',0.00,1408553.00,185.00,1408553.00,0.00,'2023-01-16 09:33:42'),(154,'5','272',1,'Sale Id shift 229',0.00,2529591.95,185.00,2529591.95,0.00,'2023-01-16 11:03:23'),(155,'5','272',1,'Sale Id shift 230',0.00,2003217.00,185.00,2003217.00,0.00,'2023-01-17 09:40:04'),(156,'5','272',1,'Sale Id shift 231',0.00,1048424.60,185.00,1048424.60,0.00,'2023-01-18 09:13:05'),(157,'5','272',1,'Sale Id shift 235',0.00,449209.60,185.00,449209.60,0.00,'2023-01-22 20:54:09'),(158,'5','272',1,'Sale Id shift 236',0.00,1843351.40,220.00,1843351.40,0.00,'2023-01-23 10:12:02'),(159,'5','272',1,'Sale Id shift 237',0.00,946957.00,220.00,946957.00,0.00,'2023-01-24 11:27:26'),(160,'5','272',1,'Sale Id shift 238',0.00,1866792.40,220.00,1866792.40,0.00,'2023-01-25 09:34:15'),(161,'5','272',1,'Sale Id shift 239',0.00,1777738.60,220.00,1777738.60,0.00,'2023-01-26 10:09:37'),(162,'5','272',1,'Sale Id shift 240',0.00,1732203.00,220.00,1732203.00,0.00,'2023-01-27 10:02:00'),(163,'5','272',1,'Sale Id shift 241',0.00,1233674.20,220.00,1233674.20,0.00,'2023-01-28 10:05:06'),(164,'5','272',1,'Sale Id shift 245',0.00,608355.00,220.00,608355.00,0.00,'2023-02-02 09:50:56'),(165,'5','272',1,'Sale Id shift 246',0.00,1487945.80,220.00,1487945.80,0.00,'2023-02-02 10:01:46'),(166,'5','272',1,'Sale Id shift 247',0.00,1654008.40,220.00,1654008.40,0.00,'2023-02-03 11:02:49'),(167,'5','272',1,'Sale Id shift 251',0.00,393969.40,220.00,393969.40,0.00,'2023-02-07 15:31:49'),(168,'5','272',1,'Sale Id shift 252',0.00,1189370.60,220.00,1189370.60,0.00,'2023-02-08 09:37:40'),(169,'5','272',1,'Sale Id shift 253',0.00,449143.20,220.00,449143.20,0.00,'2023-02-09 13:41:38'),(170,'5','272',1,'Sale Id shift 257',0.00,449125.60,220.00,449125.60,0.00,'2023-02-13 16:51:24'),(171,'5','272',1,'Sale Id shift 258',0.00,804874.40,220.00,804874.40,0.00,'2023-02-14 11:27:51'),(172,'5','272',1,'Sale Id shift 267',0.00,2793153.30,210.00,2793153.30,0.00,'2023-02-25 21:21:05'),(173,'5','272',1,'Sale Id shift 268',0.00,3160382.40,210.00,3160382.40,0.00,'2023-02-26 10:00:51'),(174,'5','272',1,'Sale Id shift 270',0.00,3425251.20,210.00,3425251.20,0.00,'2023-02-28 09:22:46'),(175,'5','272',1,'Sale Id shift 271',0.00,2652734.70,210.00,2652734.70,0.00,'2023-02-28 14:11:04'),(176,'5','272',1,'Sale Id shift 272',0.00,3452979.60,210.00,3452979.60,0.00,'2023-03-02 08:54:23'),(177,'5','272',1,'Sale Id shift 273',0.00,1669245.90,210.00,1669245.90,0.00,'2023-03-03 11:32:46'),(178,'5','272',1,'Sale Id shift 274',0.00,2428068.30,210.00,2428068.30,0.00,'2023-03-03 14:16:11'),(179,'5','272',1,'Sale Id shift 275',0.00,1516315.50,210.00,1516315.50,0.00,'2023-03-05 08:31:13'),(180,'5','272',1,'Sale Id shift 276',0.00,1722294.00,210.00,1722294.00,0.00,'2023-03-05 18:23:59'),(181,'5','272',1,'Sale Id shift 277',0.00,680127.00,210.00,680127.00,0.00,'2023-03-06 08:50:18'),(182,'5','272',1,'Sale Id shift 278',0.00,333324.60,210.00,333324.60,0.00,'2023-03-07 09:16:18'),(183,'5','272',1,'Sale Id shift 279',0.00,2095226.70,210.00,2095226.70,0.00,'2023-03-08 14:05:25'),(184,'5','272',1,'Sale Id shift 280',0.00,2228763.60,210.00,2228763.60,0.00,'2023-03-10 09:50:06'),(185,'5','272',1,'Sale Id shift 281',0.00,1733455.50,210.00,1733455.50,0.00,'2023-03-10 11:30:05'),(186,'5','272',1,'Sale Id shift 282',0.00,2197085.10,210.00,2197085.10,0.00,'2023-03-13 09:29:17');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1480 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','272',1,'','24','5',0.00,4479750.00,'Purchase Id 2 for 27,150.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-02 11:55:30','',''),('5','272',2,'','supplier','1',4479750.00,0.00,'Purchase Id 2 for 27,150.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-02 11:55:30','',''),('5','272',3,'','20','2',821511.90,0.00,'Sales from shift 1 on 2022-06-02 13:00:18 ','2022-06-02 13:00:18','',''),('5','272',4,'','6.1','4',0.00,821511.90,'Sales from shift 1 on 2022-06-02 13:00:18 ','2022-06-02 13:00:18','',''),('5','272',5,'','6.1','4',27750.00,0.00,'Payment Id 4 for invoice:1, receipt: 001 by SALBAS OIL AND GAS LTD','2022-06-02 21:29:24','',''),('5','272',6,'','supplier','1',0.00,27750.00,'Payment Id 4 for invoice:1, receipt: 001 by SALBAS OIL AND GAS LTD','2022-06-02 21:29:24','',''),('5','272',7,'','2','6',793765.00,0.00,'Payment Id 3 for invoice:1, receipt: 001 by SALBAS OIL AND GAS LTD','2022-06-02 21:29:38','',''),('5','272',8,'','supplier','1',0.00,793765.00,'Payment Id 3 for invoice:1, receipt: 001 by SALBAS OIL AND GAS LTD','2022-06-02 21:29:38','',''),('5','272',9,'','20','2',994747.05,0.00,'Sales from shift 2 on 2022-06-02 21:31:40 ','2022-06-02 21:31:40','',''),('5','272',10,'','6.1','4',0.00,994747.05,'Sales from shift 2 on 2022-06-02 21:31:40 ','2022-06-02 21:31:40','',''),('5','272',11,'','6.1','4',27750.00,0.00,'Payment Id 6 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-03 19:03:35','',''),('5','272',12,'','supplier','1',0.00,27750.00,'Payment Id 6 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-03 19:03:35','',''),('5','272',13,'','2','6',967000.00,0.00,'Payment Id 5 for invoice:2, receipt:  by SALBAS OIL AND GAS LTD','2022-06-03 19:03:35','',''),('5','272',14,'','supplier','1',0.00,967000.00,'Payment Id 5 for invoice:2, receipt:  by SALBAS OIL AND GAS LTD','2022-06-03 19:03:35','',''),('5','272',15,'','20','2',546308.40,0.00,'Sales from shift 3 on 2022-06-04 06:04:58 ','2022-06-04 06:04:58','',''),('5','272',16,'','6.1','4',0.00,546308.40,'Sales from shift 3 on 2022-06-04 06:04:58 ','2022-06-04 06:04:58','',''),('5','272',17,'','24','5',0.00,2508000.00,'Purchase Id 3 for 15,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-04 15:25:13','',''),('5','272',18,'','supplier','1',2508000.00,0.00,'Purchase Id 3 for 15,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-04 15:25:13','',''),('5','272',19,'','20','2',1368684.90,0.00,'Sales from shift 4 on 2022-06-05 06:05:56 ','2022-06-05 06:05:56','',''),('5','272',20,'','6.1','4',0.00,1368684.90,'Sales from shift 4 on 2022-06-05 06:05:56 ','2022-06-05 06:05:56','',''),('5','272',21,'','20','2',447816.60,0.00,'Sales from shift 5 on 2022-06-06 06:25:37 ','2022-06-06 06:25:37','',''),('5','272',22,'','6.1','4',0.00,447816.60,'Sales from shift 5 on 2022-06-06 06:25:37 ','2022-06-06 06:25:37','',''),('5','272',23,'','2','6',484760.00,0.00,'Payment Id 7 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:37:13','',''),('5','272',24,'','supplier','1',0.00,484760.00,'Payment Id 7 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:37:13','',''),('5','272',25,'','6.1','4',61550.00,0.00,'Payment Id 8 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:37:39','',''),('5','272',26,'','supplier','1',0.00,61550.00,'Payment Id 8 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:37:39','',''),('5','272',27,'','2','6',1341935.00,0.00,'Payment Id 9 for invoice:4, receipt:  by SALBAS OIL AND GAS LTD','2022-06-06 16:38:00','',''),('5','272',28,'','supplier','1',0.00,1341935.00,'Payment Id 9 for invoice:4, receipt:  by SALBAS OIL AND GAS LTD','2022-06-06 16:38:00','',''),('5','272',29,'','6.1','4',26750.00,0.00,'Payment Id 10 for invoice:4, receipt: 004 by SALBAS OIL AND GAS LTD','2022-06-06 16:38:42','',''),('5','272',30,'','supplier','1',0.00,26750.00,'Payment Id 10 for invoice:4, receipt: 004 by SALBAS OIL AND GAS LTD','2022-06-06 16:38:42','',''),('5','272',31,'','2','6',421070.00,0.00,'Payment Id 11 for invoice:5, receipt:  by SALBAS OIL AND GAS LTD','2022-06-06 16:38:59','',''),('5','272',32,'','supplier','1',0.00,421070.00,'Payment Id 11 for invoice:5, receipt:  by SALBAS OIL AND GAS LTD','2022-06-06 16:38:59','',''),('5','272',33,'','6.1','4',0.00,27750.00,'Payment Id 6 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-06 16:39:27','',''),('5','272',34,'','supplier','1',27750.00,0.00,'Payment Id 6 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-06 16:39:27','',''),('5','272',35,'','6.1','4',0.00,61550.00,'Payment Id 8 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:39:55','',''),('5','272',36,'','supplier','1',61550.00,0.00,'Payment Id 8 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-06 16:39:55','',''),('5','272',37,'','6.1','4',26750.00,0.00,'Payment Id 12 for invoice:5, receipt: 005 by SALBAS OIL AND GAS LTD','2022-06-06 16:40:25','',''),('5','272',38,'','supplier','1',0.00,26750.00,'Payment Id 12 for invoice:5, receipt: 005 by SALBAS OIL AND GAS LTD','2022-06-06 16:40:25','',''),('5','272',39,'','24','5',0.00,7342500.00,'Purchase Id 4 for 44,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-06 22:31:00','',''),('5','272',40,'','supplier','1',7342500.00,0.00,'Purchase Id 4 for 44,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-06-06 22:31:00','',''),('5','272',41,'','20','2',1450642.05,0.00,'Sales from shift 6 on 2022-06-07 07:25:13 ','2022-06-07 07:25:13','',''),('5','272',42,'','6.1','4',0.00,1450642.05,'Sales from shift 6 on 2022-06-07 07:25:13 ','2022-06-07 07:25:13','',''),('5','272',43,'','6.1','4',27750.00,0.00,'Payment Id 13 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-07 10:39:57','',''),('5','272',44,'','supplier','1',0.00,27750.00,'Payment Id 13 for invoice:2, receipt: 002 by SALBAS OIL AND GAS LTD','2022-06-07 10:39:57','',''),('5','272',45,'','6.1','4',61550.00,0.00,'Payment Id 14 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-07 10:40:45','',''),('5','272',46,'','supplier','1',0.00,61550.00,'Payment Id 14 for invoice:3, receipt: 003 by SALBAS OIL AND GAS LTD','2022-06-07 10:40:45','',''),('5','272',47,'','2','6',1165645.00,0.00,'Payment Id 15 for invoice:6, receipt:  by SALBAS OIL AND GAS LTD','2022-06-07 15:22:25','',''),('5','272',48,'','supplier','1',0.00,1165645.00,'Payment Id 15 for invoice:6, receipt:  by SALBAS OIL AND GAS LTD','2022-06-07 15:22:25','',''),('5','272',49,'','6.1','4',40000.00,0.00,'Payment Id 17 for invoice:6, receipt: 006 by SALBAS OIL AND GAS LTD','2022-06-07 15:37:44','',''),('5','272',50,'','supplier','1',0.00,40000.00,'Payment Id 17 for invoice:6, receipt: 006 by SALBAS OIL AND GAS LTD','2022-06-07 15:37:44','',''),('5','272',51,'','20','2',1785816.45,0.00,'Sales from shift 7 on 2022-06-08 10:30:37 ','2022-06-08 10:30:37','',''),('5','272',52,'','6.1','4',0.00,1785816.45,'Sales from shift 7 on 2022-06-08 10:30:37 ','2022-06-08 10:30:37','',''),('5','272',53,'','2','6',1451820.00,0.00,'Payment Id 18 for invoice:7, receipt:  by SALBAS OIL AND GAS LTD','2022-06-08 16:30:17','',''),('5','272',54,'','supplier','1',0.00,1451820.00,'Payment Id 18 for invoice:7, receipt:  by SALBAS OIL AND GAS LTD','2022-06-08 16:30:17','',''),('5','272',55,'','6.1','4',334000.00,0.00,'Payment Id 19 for invoice:7, receipt: 007 by SALBAS OIL AND GAS LTD','2022-06-08 16:30:35','',''),('5','272',56,'','supplier','1',0.00,334000.00,'Payment Id 19 for invoice:7, receipt: 007 by SALBAS OIL AND GAS LTD','2022-06-08 16:30:35','',''),('5','272',57,'','2','6',1535555.00,0.00,'Payment Id 20 for invoice:8, receipt:  by SALBAS OIL AND GAS LTD','2022-06-09 12:40:29','',''),('5','272',58,'','supplier','1',0.00,1535555.00,'Payment Id 20 for invoice:8, receipt:  by SALBAS OIL AND GAS LTD','2022-06-09 12:40:29','',''),('5','272',59,'','20','2',1604550.75,0.00,'Sales from shift 8 on 2022-06-09 23:02:10 ','2022-06-09 23:02:10','',''),('5','272',60,'','6.1','4',0.00,1604550.75,'Sales from shift 8 on 2022-06-09 23:02:10 ','2022-06-09 23:02:10','',''),('5','272',61,'','20','2',1007541.15,0.00,'Sales from shift 9 on 2022-06-10 05:24:33 ','2022-06-10 05:24:33','',''),('5','272',62,'','6.1','4',0.00,1007541.15,'Sales from shift 9 on 2022-06-10 05:24:33 ','2022-06-10 05:24:33','',''),('5','272',63,'','6.1','4',69000.00,0.00,'Payment Id 21 for invoice:8, receipt: 008 by SALBAS OIL AND GAS LTD','2022-06-10 05:25:59','',''),('5','272',64,'','supplier','1',0.00,69000.00,'Payment Id 21 for invoice:8, receipt: 008 by SALBAS OIL AND GAS LTD','2022-06-10 05:25:59','',''),('5','272',65,'','2','6',976295.00,0.00,'Payment Id 22 for invoice:9, receipt:  by SALBAS OIL AND GAS LTD','2022-06-10 15:15:34','',''),('5','272',66,'','supplier','1',0.00,976295.00,'Payment Id 22 for invoice:9, receipt:  by SALBAS OIL AND GAS LTD','2022-06-10 15:15:34','',''),('5','272',67,'','20','2',841712.85,0.00,'Sales from shift 10 on 2022-06-10 21:42:03 ','2022-06-10 21:42:03','',''),('5','272',68,'','6.1','4',0.00,841712.85,'Sales from shift 10 on 2022-06-10 21:42:03 ','2022-06-10 21:42:03','',''),('5','272',69,'','6.1','4',31250.00,0.00,'Payment Id 23 for invoice:9, receipt: 009 by SALBAS OIL AND GAS LTD','2022-06-10 21:42:28','',''),('5','272',70,'','supplier','1',0.00,31250.00,'Payment Id 23 for invoice:9, receipt: 009 by SALBAS OIL AND GAS LTD','2022-06-10 21:42:28','',''),('5','272',71,'','20','2',577874.55,0.00,'Sales from shift 11 on 2022-06-12 08:29:23 ','2022-06-12 08:29:23','',''),('5','272',72,'','6.1','4',0.00,577874.55,'Sales from shift 11 on 2022-06-12 08:29:23 ','2022-06-12 08:29:23','',''),('5','272',73,'','20','2',333351.15,0.00,'Sales from shift 12 on 2022-06-13 06:53:19 ','2022-06-13 06:53:19','',''),('5','272',74,'','6.1','4',0.00,333351.15,'Sales from shift 12 on 2022-06-13 06:53:19 ','2022-06-13 06:53:19','',''),('5','272',75,'','20','2',349740.60,0.00,'Sales from shift 13 on 2022-06-14 08:57:05 ','2022-06-14 08:57:05','',''),('5','272',76,'','6.1','4',0.00,349740.60,'Sales from shift 13 on 2022-06-14 08:57:05 ','2022-06-14 08:57:05','',''),('5','272',77,'','2','6',810465.00,0.00,'Payment Id 24 for invoice:10, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:20:14','',''),('5','272',78,'','supplier','1',0.00,810465.00,'Payment Id 24 for invoice:10, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:20:14','',''),('5','272',79,'','6.1','4',31250.00,0.00,'Payment Id 25 for invoice:10, receipt: 010 by SALBAS OIL AND GAS LTD','2022-06-14 16:20:27','',''),('5','272',80,'','supplier','1',0.00,31250.00,'Payment Id 25 for invoice:10, receipt: 010 by SALBAS OIL AND GAS LTD','2022-06-14 16:20:27','',''),('5','272',81,'','2','6',545625.00,0.00,'Payment Id 26 for invoice:11, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:20:50','',''),('5','272',82,'','supplier','1',0.00,545625.00,'Payment Id 26 for invoice:11, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:20:50','',''),('5','272',83,'','6.1','4',32250.00,0.00,'Payment Id 27 for invoice:11, receipt: 011 by SALBAS OIL AND GAS LTD','2022-06-14 16:21:01','',''),('5','272',84,'','supplier','1',0.00,32250.00,'Payment Id 27 for invoice:11, receipt: 011 by SALBAS OIL AND GAS LTD','2022-06-14 16:21:01','',''),('5','272',85,'','2','6',303105.00,0.00,'Payment Id 28 for invoice:12, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:21:17','',''),('5','272',86,'','supplier','1',0.00,303105.00,'Payment Id 28 for invoice:12, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:21:17','',''),('5','272',87,'','6.1','4',30250.00,0.00,'Payment Id 29 for invoice:12, receipt: 012 by SALBAS OIL AND GAS LTD','2022-06-14 16:21:30','',''),('5','272',88,'','supplier','1',0.00,30250.00,'Payment Id 29 for invoice:12, receipt: 012 by SALBAS OIL AND GAS LTD','2022-06-14 16:21:30','',''),('5','272',89,'','2','6',286990.00,0.00,'Payment Id 30 for invoice:13, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:21:44','',''),('5','272',90,'','supplier','1',0.00,286990.00,'Payment Id 30 for invoice:13, receipt:  by SALBAS OIL AND GAS LTD','2022-06-14 16:21:44','',''),('5','272',91,'','6.1','4',62750.00,0.00,'Payment Id 31 for invoice:13, receipt: 013 by SALBAS OIL AND GAS LTD','2022-06-14 16:22:03','',''),('5','272',92,'','supplier','1',0.00,62750.00,'Payment Id 31 for invoice:13, receipt: 013 by SALBAS OIL AND GAS LTD','2022-06-14 16:22:03','',''),('5','272',93,'','20','2',307885.05,0.00,'Sales from shift 14 on 2022-06-15 07:35:46 ','2022-06-15 07:35:46','',''),('5','272',94,'','6.1','4',0.00,307885.05,'Sales from shift 14 on 2022-06-15 07:35:46 ','2022-06-15 07:35:46','',''),('5','272',95,'','20','2',508416.15,0.00,'Sales from shift 15 on 2022-06-16 07:00:38 ','2022-06-16 07:00:38','',''),('5','272',96,'','6.1','4',0.00,508416.15,'Sales from shift 15 on 2022-06-16 07:00:38 ','2022-06-16 07:00:38','',''),('5','272',97,'','6.1','4',31250.00,0.00,'Payment Id 33 for invoice:14, receipt: 014 by SALBAS OIL AND GAS LTD','2022-06-16 07:00:57','',''),('5','272',98,'','supplier','1',0.00,31250.00,'Payment Id 33 for invoice:14, receipt: 014 by SALBAS OIL AND GAS LTD','2022-06-16 07:00:57','',''),('5','272',99,'','2','6',276640.00,0.00,'Payment Id 32 for invoice:14, receipt:  by SALBAS OIL AND GAS LTD','2022-06-16 07:00:57','',''),('5','272',100,'','supplier','1',0.00,276640.00,'Payment Id 32 for invoice:14, receipt:  by SALBAS OIL AND GAS LTD','2022-06-16 07:00:57','',''),('5','272',101,'','6.1','4',31250.00,0.00,'Payment Id 35 for invoice:15, receipt: 015 by SALBAS OIL AND GAS LTD','2022-06-16 19:16:33','',''),('5','272',102,'','supplier','1',0.00,31250.00,'Payment Id 35 for invoice:15, receipt: 015 by SALBAS OIL AND GAS LTD','2022-06-16 19:16:33','',''),('5','272',103,'','2','6',477170.00,0.00,'Payment Id 34 for invoice:15, receipt:  by SALBAS OIL AND GAS LTD','2022-06-16 19:16:33','',''),('5','272',104,'','supplier','1',0.00,477170.00,'Payment Id 34 for invoice:15, receipt:  by SALBAS OIL AND GAS LTD','2022-06-16 19:16:33','',''),('5','272',105,'','20','2',315230.85,0.00,'Sales from shift 16 on 2022-06-17 05:58:56 ','2022-06-17 05:58:56','',''),('5','272',106,'','6.1','4',0.00,315230.85,'Sales from shift 16 on 2022-06-17 05:58:56 ','2022-06-17 05:58:56','',''),('5','272',107,'','20','2',371655.90,0.00,'Sales from shift 17 on 2022-06-18 07:01:47 ','2022-06-18 07:01:47','',''),('5','272',108,'','6.1','4',0.00,371655.90,'Sales from shift 17 on 2022-06-18 07:01:47 ','2022-06-18 07:01:47','',''),('5','272',109,'','6.1','4',31250.00,0.00,'Payment Id 37 for invoice:16, receipt: 016 by SALBAS OIL AND GAS LTD','2022-06-18 07:02:14','',''),('5','272',110,'','supplier','1',0.00,31250.00,'Payment Id 37 for invoice:16, receipt: 016 by SALBAS OIL AND GAS LTD','2022-06-18 07:02:14','',''),('5','272',111,'','2','6',283985.00,0.00,'Payment Id 36 for invoice:16, receipt:  by SALBAS OIL AND GAS LTD','2022-06-18 07:02:14','',''),('5','272',112,'','supplier','1',0.00,283985.00,'Payment Id 36 for invoice:16, receipt:  by SALBAS OIL AND GAS LTD','2022-06-18 07:02:14','',''),('5','272',113,'','20','2',330001.65,0.00,'Sales from shift 18 on 2022-06-18 22:46:10 ','2022-06-18 22:46:10','',''),('5','272',114,'','6.1','4',0.00,330001.65,'Sales from shift 18 on 2022-06-18 22:46:10 ','2022-06-18 22:46:10','',''),('5','272',115,'','20','2',267465.00,0.00,'Sales from shift 19 on 2022-06-20 06:45:25 ','2022-06-20 06:45:25','',''),('5','272',116,'','6.1','4',0.00,267465.00,'Sales from shift 19 on 2022-06-20 06:45:25 ','2022-06-20 06:45:25','',''),('5','272',117,'','6.1','4',51250.00,0.00,'Payment Id 43 for invoice:19, receipt: 019 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',118,'','supplier','1',0.00,51250.00,'Payment Id 43 for invoice:19, receipt: 019 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',119,'','2','6',216215.00,0.00,'Payment Id 42 for invoice:19, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',120,'','supplier','1',0.00,216215.00,'Payment Id 42 for invoice:19, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',121,'','6.1','4',30250.00,0.00,'Payment Id 41 for invoice:18, receipt: 018 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',122,'','supplier','1',0.00,30250.00,'Payment Id 41 for invoice:18, receipt: 018 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',123,'','2','6',299755.00,0.00,'Payment Id 40 for invoice:18, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',124,'','supplier','1',0.00,299755.00,'Payment Id 40 for invoice:18, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',125,'','6.1','4',31250.00,0.00,'Payment Id 39 for invoice:17, receipt: 017 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',126,'','supplier','1',0.00,31250.00,'Payment Id 39 for invoice:17, receipt: 017 by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',127,'','2','6',340410.00,0.00,'Payment Id 38 for invoice:17, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',128,'','supplier','1',0.00,340410.00,'Payment Id 38 for invoice:17, receipt:  by SALBAS OIL AND GAS LTD','2022-06-20 21:04:16','',''),('5','272',129,'','20','2',43256.40,0.00,'Sales from shift 20 on 2022-06-21 07:53:30 ','2022-06-21 07:53:30','',''),('5','272',130,'','6.1','4',0.00,43256.40,'Sales from shift 20 on 2022-06-21 07:53:30 ','2022-06-21 07:53:30','',''),('5','272',131,'','6.1','4',2000.00,0.00,'Payment Id 45 for invoice:20, receipt: 020 by SALBAS OIL AND GAS LTD','2022-06-21 18:49:49','',''),('5','272',132,'','supplier','1',0.00,2000.00,'Payment Id 45 for invoice:20, receipt: 020 by SALBAS OIL AND GAS LTD','2022-06-21 18:49:49','',''),('5','272',133,'','2','6',41260.00,0.00,'Payment Id 44 for invoice:20, receipt:  by SALBAS OIL AND GAS LTD','2022-06-21 18:49:49','',''),('5','272',134,'','supplier','1',0.00,41260.00,'Payment Id 44 for invoice:20, receipt:  by SALBAS OIL AND GAS LTD','2022-06-21 18:49:49','',''),('5','272',135,'','20','2',0.00,0.00,'Sales from shift 21 on 2022-06-21 22:44:35 ','2022-06-21 22:44:35','',''),('5','272',136,'','6.1','4',0.00,0.00,'Sales from shift 21 on 2022-06-21 22:44:35 ','2022-06-21 22:44:35','',''),('5','272',137,'','20','2',0.00,0.00,'Sales from shift 22 on 2022-06-23 07:05:00 ','2022-06-23 07:05:00','',''),('5','272',138,'','6.1','4',0.00,0.00,'Sales from shift 22 on 2022-06-23 07:05:00 ','2022-06-23 07:05:00','',''),('5','272',139,'','20','2',0.00,0.00,'Sales from shift 23 on 2022-06-24 06:57:20 ','2022-06-24 06:57:20','',''),('5','272',140,'','6.1','4',0.00,0.00,'Sales from shift 23 on 2022-06-24 06:57:20 ','2022-06-24 06:57:20','',''),('5','272',141,'','20','2',0.00,0.00,'Sales from shift 24 on 2022-06-25 06:12:44 ','2022-06-25 06:12:44','',''),('5','272',142,'','6.1','4',0.00,0.00,'Sales from shift 24 on 2022-06-25 06:12:44 ','2022-06-25 06:12:44','',''),('5','272',143,'','20','2',0.00,0.00,'Sales from shift 25 on 2022-06-26 07:13:56 ','2022-06-26 07:13:56','',''),('5','272',144,'','6.1','4',0.00,0.00,'Sales from shift 25 on 2022-06-26 07:13:56 ','2022-06-26 07:13:56','',''),('5','272',145,'','20','2',0.00,0.00,'Sales from shift 26 on 2022-06-27 07:34:11 ','2022-06-27 07:34:11','',''),('5','272',146,'','6.1','4',0.00,0.00,'Sales from shift 26 on 2022-06-27 07:34:11 ','2022-06-27 07:34:11','',''),('5','272',147,'','20','2',0.00,0.00,'Sales from shift 27 on 2022-06-28 07:21:25 ','2022-06-28 07:21:25','',''),('5','272',148,'','6.1','4',0.00,0.00,'Sales from shift 27 on 2022-06-28 07:21:25 ','2022-06-28 07:21:25','',''),('5','272',149,'','20','2',0.00,0.00,'Sales from shift 28 on 2022-06-29 08:00:50 ','2022-06-29 08:00:50','',''),('5','272',150,'','6.1','4',0.00,0.00,'Sales from shift 28 on 2022-06-29 08:00:50 ','2022-06-29 08:00:50','',''),('5','272',151,'','20','2',0.00,0.00,'Sales from shift 29 on 2022-06-30 06:23:48 ','2022-06-30 06:23:48','',''),('5','272',152,'','6.1','4',0.00,0.00,'Sales from shift 29 on 2022-06-30 06:23:48 ','2022-06-30 06:23:48','',''),('5','272',153,'','20','2',0.00,0.00,'Sales from shift 30 on 2022-07-01 07:08:49 ','2022-07-01 07:08:49','',''),('5','272',154,'','6.1','4',0.00,0.00,'Sales from shift 30 on 2022-07-01 07:08:49 ','2022-07-01 07:08:49','',''),('5','272',155,'','20','2',0.00,0.00,'Sales from shift 31 on 2022-07-02 14:30:13 ','2022-07-02 14:30:13','',''),('5','272',156,'','6.1','4',0.00,0.00,'Sales from shift 31 on 2022-07-02 14:30:13 ','2022-07-02 14:30:13','',''),('5','272',157,'','20','2',0.00,0.00,'Sales from shift 32 on 2022-07-03 06:29:00 ','2022-07-03 06:29:00','',''),('5','272',158,'','6.1','4',0.00,0.00,'Sales from shift 32 on 2022-07-03 06:29:00 ','2022-07-03 06:29:00','',''),('5','272',159,'','20','2',0.00,0.00,'Sales from shift 33 on 2022-07-04 09:59:03 ','2022-07-04 09:59:03','',''),('5','272',160,'','6.1','4',0.00,0.00,'Sales from shift 33 on 2022-07-04 09:59:03 ','2022-07-04 09:59:03','',''),('5','272',161,'','20','2',0.00,0.00,'Sales from shift 34 on 2022-07-04 22:34:22 ','2022-07-04 22:34:22','',''),('5','272',162,'','6.1','4',0.00,0.00,'Sales from shift 34 on 2022-07-04 22:34:22 ','2022-07-04 22:34:22','',''),('5','272',163,'','20','2',0.00,0.00,'Sales from shift 35 on 2022-07-06 07:47:47 ','2022-07-06 07:47:47','',''),('5','272',164,'','6.1','4',0.00,0.00,'Sales from shift 35 on 2022-07-06 07:47:47 ','2022-07-06 07:47:47','',''),('5','272',165,'','20','2',0.00,0.00,'Sales from shift 36 on 2022-07-07 05:23:57 ','2022-07-07 05:23:57','',''),('5','272',166,'','6.1','4',0.00,0.00,'Sales from shift 36 on 2022-07-07 05:23:57 ','2022-07-07 05:23:57','',''),('5','272',167,'','24','5',0.00,3712500.00,'Purchase Id 5 for 22,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-07 19:45:59','',''),('5','272',168,'','supplier','1',3712500.00,0.00,'Purchase Id 5 for 22,500.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-07 19:45:59','',''),('5','272',169,'','20','2',176134.20,0.00,'Sales from shift 37 on 2022-07-10 17:45:01 ','2022-07-10 17:45:01','',''),('5','272',170,'','6.1','4',0.00,176134.20,'Sales from shift 37 on 2022-07-10 17:45:01 ','2022-07-10 17:45:01','',''),('5','272',171,'','20','2',915990.90,0.00,'Sales from shift 38 on 2022-07-11 08:18:12 ','2022-07-11 08:18:12','',''),('5','272',172,'','6.1','4',0.00,915990.90,'Sales from shift 38 on 2022-07-11 08:18:12 ','2022-07-11 08:18:12','',''),('5','272',173,'','20','2',377749.65,0.00,'Sales from shift 39 on 2022-07-11 08:32:52 ','2022-07-11 08:32:52','',''),('5','272',174,'','6.1','4',0.00,377749.65,'Sales from shift 39 on 2022-07-11 08:32:52 ','2022-07-11 08:32:52','',''),('5','272',175,'','20','2',467075.05,0.00,'Sales from shift 40 on 2022-07-11 08:44:16 ','2022-07-11 08:44:16','',''),('5','272',176,'','6.1','4',0.00,467075.05,'Sales from shift 40 on 2022-07-11 08:44:16 ','2022-07-11 08:44:16','',''),('5','272',177,'','20','2',790001.80,0.00,'Sales from shift 41 on 2022-07-12 05:21:19 ','2022-07-12 05:21:19','',''),('5','272',178,'','6.1','4',0.00,790001.80,'Sales from shift 41 on 2022-07-12 05:21:19 ','2022-07-12 05:21:19','',''),('5','272',179,'','20','2',383353.30,0.00,'Sales from shift 42 on 2022-07-13 07:16:58 ','2022-07-13 07:16:58','',''),('5','272',180,'','6.1','4',0.00,383353.30,'Sales from shift 42 on 2022-07-13 07:16:58 ','2022-07-13 07:16:58','',''),('5','272',181,'','6.1','4',30250.00,0.00,'Payment Id 47 for invoice:37, receipt: 037 by SALBAS OIL AND GAS LTD','2022-07-13 18:54:13','',''),('5','272',182,'','supplier','1',0.00,30250.00,'Payment Id 47 for invoice:37, receipt: 037 by SALBAS OIL AND GAS LTD','2022-07-13 18:54:13','',''),('5','272',183,'','2','6',145885.00,0.00,'Payment Id 46 for invoice:37, receipt:  by SALBAS OIL AND GAS LTD','2022-07-13 18:54:13','',''),('5','272',184,'','supplier','1',0.00,145885.00,'Payment Id 46 for invoice:37, receipt:  by SALBAS OIL AND GAS LTD','2022-07-13 18:54:13','',''),('5','272',185,'','6.1','4',30250.00,0.00,'Payment Id 57 for invoice:42, receipt: 042 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',186,'','supplier','1',0.00,30250.00,'Payment Id 57 for invoice:42, receipt: 042 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',187,'','2','6',353105.00,0.00,'Payment Id 56 for invoice:42, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',188,'','supplier','1',0.00,353105.00,'Payment Id 56 for invoice:42, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',189,'','6.1','4',30250.00,0.00,'Payment Id 55 for invoice:41, receipt: 041 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',190,'','supplier','1',0.00,30250.00,'Payment Id 55 for invoice:41, receipt: 041 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',191,'','2','6',759755.00,0.00,'Payment Id 54 for invoice:41, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',192,'','supplier','1',0.00,759755.00,'Payment Id 54 for invoice:41, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',193,'','6.1','4',30250.00,0.00,'Payment Id 53 for invoice:40, receipt: 040 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',194,'','supplier','1',0.00,30250.00,'Payment Id 53 for invoice:40, receipt: 040 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',195,'','2','6',436830.00,0.00,'Payment Id 52 for invoice:40, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',196,'','supplier','1',0.00,436830.00,'Payment Id 52 for invoice:40, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',197,'','6.1','4',34010.00,0.00,'Payment Id 51 for invoice:39, receipt: 039 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',198,'','supplier','1',0.00,34010.00,'Payment Id 51 for invoice:39, receipt: 039 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',199,'','2','6',343740.00,0.00,'Payment Id 50 for invoice:39, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',200,'','supplier','1',0.00,343740.00,'Payment Id 50 for invoice:39, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',201,'','6.1','4',52200.00,0.00,'Payment Id 49 for invoice:38, receipt: 038 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',202,'','supplier','1',0.00,52200.00,'Payment Id 49 for invoice:38, receipt: 038 by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',203,'','2','6',863795.00,0.00,'Payment Id 48 for invoice:38, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',204,'','supplier','1',0.00,863795.00,'Payment Id 48 for invoice:38, receipt:  by SALBAS OIL AND GAS LTD','2022-07-14 06:30:53','',''),('5','272',205,'','20','2',455532.90,0.00,'Sales from shift 43 on 2022-07-14 06:31:32 ','2022-07-14 06:31:32','',''),('5','272',206,'','6.1','4',0.00,455532.90,'Sales from shift 43 on 2022-07-14 06:31:32 ','2022-07-14 06:31:32','',''),('5','272',207,'','24','5',0.00,7400000.00,'Purchase Id 6 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-14 21:29:17','',''),('5','272',208,'','supplier','1',7400000.00,0.00,'Purchase Id 6 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-14 21:29:17','',''),('5','272',209,'','20','2',540126.00,0.00,'Sales from shift 44 on 2022-07-15 07:15:57 ','2022-07-15 07:15:57','',''),('5','272',210,'','6.1','4',0.00,540126.00,'Sales from shift 44 on 2022-07-15 07:15:57 ','2022-07-15 07:15:57','',''),('5','272',211,'','6.1','4',31250.00,0.00,'Payment Id 59 for invoice:43, receipt: 043 by SALBAS OIL AND GAS LTD','2022-07-15 07:16:29','',''),('5','272',212,'','supplier','1',0.00,31250.00,'Payment Id 59 for invoice:43, receipt: 043 by SALBAS OIL AND GAS LTD','2022-07-15 07:16:29','',''),('5','272',213,'','2','6',424285.00,0.00,'Payment Id 58 for invoice:43, receipt:  by SALBAS OIL AND GAS LTD','2022-07-15 07:16:29','',''),('5','272',214,'','supplier','1',0.00,424285.00,'Payment Id 58 for invoice:43, receipt:  by SALBAS OIL AND GAS LTD','2022-07-15 07:16:29','',''),('5','272',215,'','6.1','4',51250.00,0.00,'Payment Id 61 for invoice:44, receipt: 044 by SALBAS OIL AND GAS LTD','2022-07-16 06:51:53','',''),('5','272',216,'','supplier','1',0.00,51250.00,'Payment Id 61 for invoice:44, receipt: 044 by SALBAS OIL AND GAS LTD','2022-07-16 06:51:53','',''),('5','272',217,'','2','6',488880.00,0.00,'Payment Id 60 for invoice:44, receipt:  by SALBAS OIL AND GAS LTD','2022-07-16 06:51:53','',''),('5','272',218,'','supplier','1',0.00,488880.00,'Payment Id 60 for invoice:44, receipt:  by SALBAS OIL AND GAS LTD','2022-07-16 06:51:53','',''),('5','272',219,'','20','2',2196965.65,0.00,'Sales from shift 45 on 2022-07-16 06:52:10 ','2022-07-16 06:52:10','',''),('5','272',220,'','6.1','4',0.00,2196965.65,'Sales from shift 45 on 2022-07-16 06:52:10 ','2022-07-16 06:52:10','',''),('5','272',221,'','20','2',1904441.80,0.00,'Sales from shift 46 on 2022-07-17 05:28:12 ','2022-07-17 05:28:12','',''),('5','272',222,'','6.1','4',0.00,1904441.80,'Sales from shift 46 on 2022-07-17 05:28:12 ','2022-07-17 05:28:12','',''),('5','272',223,'','20','2',1892141.15,0.00,'Sales from shift 47 on 2022-07-18 07:32:47 ','2022-07-18 07:32:47','',''),('5','272',224,'','6.1','4',0.00,1892141.15,'Sales from shift 47 on 2022-07-18 07:32:47 ','2022-07-18 07:32:47','',''),('5','272',225,'','6.1','4',338000.00,0.00,'Payment Id 67 for invoice:47, receipt: 047 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',226,'','supplier','1',0.00,338000.00,'Payment Id 67 for invoice:47, receipt: 047 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',227,'','2','6',1554145.00,0.00,'Payment Id 66 for invoice:47, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',228,'','supplier','1',0.00,1554145.00,'Payment Id 66 for invoice:47, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',229,'','6.1','4',43000.00,0.00,'Payment Id 65 for invoice:46, receipt: 046 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',230,'','supplier','1',0.00,43000.00,'Payment Id 65 for invoice:46, receipt: 046 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',231,'','2','6',1861445.00,0.00,'Payment Id 64 for invoice:46, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',232,'','supplier','1',0.00,1861445.00,'Payment Id 64 for invoice:46, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',233,'','6.1','4',44000.00,0.00,'Payment Id 63 for invoice:45, receipt: 045 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',234,'','supplier','1',0.00,44000.00,'Payment Id 63 for invoice:45, receipt: 045 by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',235,'','2','6',2152970.00,0.00,'Payment Id 62 for invoice:45, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',236,'','supplier','1',0.00,2152970.00,'Payment Id 62 for invoice:45, receipt:  by SALBAS OIL AND GAS LTD','2022-07-18 17:04:53','',''),('5','272',237,'','20','2',1532715.75,0.00,'Sales from shift 48 on 2022-07-19 12:16:04 ','2022-07-19 12:16:04','',''),('5','272',238,'','6.1','4',0.00,1532715.75,'Sales from shift 48 on 2022-07-19 12:16:04 ','2022-07-19 12:16:04','',''),('5','272',239,'','6.1','4',44000.00,0.00,'Payment Id 69 for invoice:48, receipt: 048 by SALBAS OIL AND GAS LTD','2022-07-20 08:17:12','',''),('5','272',240,'','supplier','1',0.00,44000.00,'Payment Id 69 for invoice:48, receipt: 048 by SALBAS OIL AND GAS LTD','2022-07-20 08:17:12','',''),('5','272',241,'','2','6',1488720.00,0.00,'Payment Id 68 for invoice:48, receipt:  by SALBAS OIL AND GAS LTD','2022-07-20 08:17:12','',''),('5','272',242,'','supplier','1',0.00,1488720.00,'Payment Id 68 for invoice:48, receipt:  by SALBAS OIL AND GAS LTD','2022-07-20 08:17:12','',''),('5','272',243,'','24','5',0.00,11081500.00,'Purchase Id 7 for 59,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-20 11:32:36','',''),('5','272',244,'','supplier','1',11081500.00,0.00,'Purchase Id 7 for 59,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-20 11:32:36','',''),('5','272',245,'','20','2',2450857.80,0.00,'Sales from shift 49 on 2022-07-20 12:58:23 ','2022-07-20 12:58:23','',''),('5','272',246,'','6.1','4',0.00,2450857.80,'Sales from shift 49 on 2022-07-20 12:58:23 ','2022-07-20 12:58:23','',''),('5','272',247,'','6.1','4',44000.00,0.00,'Payment Id 71 for invoice:48, receipt: 048 by SALBAS OIL AND GAS LTD','2022-07-20 16:26:30','',''),('5','272',248,'','supplier','1',0.00,44000.00,'Payment Id 71 for invoice:48, receipt: 048 by SALBAS OIL AND GAS LTD','2022-07-20 16:26:30','',''),('5','272',249,'','2','6',2406860.00,0.00,'Payment Id 70 for invoice:48, receipt:  by SALBAS OIL AND GAS LTD','2022-07-20 16:26:30','',''),('5','272',250,'','supplier','1',0.00,2406860.00,'Payment Id 70 for invoice:48, receipt:  by SALBAS OIL AND GAS LTD','2022-07-20 16:26:30','',''),('5','272',251,'','20','2',3044189.80,0.00,'Sales from shift 50 on 2022-07-21 06:47:33 ','2022-07-21 06:47:33','',''),('5','272',252,'','6.1','4',0.00,3044189.80,'Sales from shift 50 on 2022-07-21 06:47:33 ','2022-07-21 06:47:33','',''),('5','272',253,'','6.1','4',44000.00,0.00,'Payment Id 73 for invoice:50, receipt: 050 by SALBAS OIL AND GAS LTD','2022-07-21 19:56:29','',''),('5','272',254,'','supplier','1',0.00,44000.00,'Payment Id 73 for invoice:50, receipt: 050 by SALBAS OIL AND GAS LTD','2022-07-21 19:56:29','',''),('5','272',255,'','2','6',3000190.00,0.00,'Payment Id 72 for invoice:50, receipt:  by SALBAS OIL AND GAS LTD','2022-07-21 19:56:29','',''),('5','272',256,'','supplier','1',0.00,3000190.00,'Payment Id 72 for invoice:50, receipt:  by SALBAS OIL AND GAS LTD','2022-07-21 19:56:29','',''),('5','272',257,'','20','2',2798726.25,0.00,'Sales from shift 51 on 2022-07-21 23:17:29 ','2022-07-21 23:17:29','',''),('5','272',258,'','6.1','4',0.00,2798726.25,'Sales from shift 51 on 2022-07-21 23:17:29 ','2022-07-21 23:17:29','',''),('5','272',259,'','6.1','4',44000.00,0.00,'Payment Id 75 for invoice:51, receipt: 051 by SALBAS OIL AND GAS LTD','2022-07-22 16:40:58','',''),('5','272',260,'','supplier','1',0.00,44000.00,'Payment Id 75 for invoice:51, receipt: 051 by SALBAS OIL AND GAS LTD','2022-07-22 16:40:58','',''),('5','272',261,'','2','6',2754730.00,0.00,'Payment Id 74 for invoice:51, receipt:  by SALBAS OIL AND GAS LTD','2022-07-22 16:40:58','',''),('5','272',262,'','supplier','1',0.00,2754730.00,'Payment Id 74 for invoice:51, receipt:  by SALBAS OIL AND GAS LTD','2022-07-22 16:40:58','',''),('5','272',263,'','20','2',1258687.65,0.00,'Sales from shift 52 on 2022-07-23 06:53:17 ','2022-07-23 06:53:17','',''),('5','272',264,'','6.1','4',0.00,1258687.65,'Sales from shift 52 on 2022-07-23 06:53:17 ','2022-07-23 06:53:17','',''),('5','272',265,'','24','5',0.00,7418500.00,'Purchase Id 8 for 40,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-23 20:46:08','',''),('5','272',266,'','supplier','1',7418500.00,0.00,'Purchase Id 8 for 40,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-07-23 20:46:08','',''),('5','272',267,'','20','2',1567769.55,0.00,'Sales from shift 53 on 2022-07-24 08:30:55 ','2022-07-24 08:30:55','',''),('5','272',268,'','6.1','4',0.00,1567769.55,'Sales from shift 53 on 2022-07-24 08:30:55 ','2022-07-24 08:30:55','',''),('5','272',269,'','20','2',2660668.15,0.00,'Sales from shift 54 on 2022-07-25 06:43:31 ','2022-07-25 06:43:31','',''),('5','272',270,'','6.1','4',0.00,2660668.15,'Sales from shift 54 on 2022-07-25 06:43:31 ','2022-07-25 06:43:31','',''),('5','272',271,'','6.1','4',43000.00,0.00,'Payment Id 81 for invoice:54, receipt: 054 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',272,'','supplier','1',0.00,43000.00,'Payment Id 81 for invoice:54, receipt: 054 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',273,'','2','6',2617670.00,0.00,'Payment Id 80 for invoice:54, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',274,'','supplier','1',0.00,2617670.00,'Payment Id 80 for invoice:54, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',275,'','6.1','4',45000.00,0.00,'Payment Id 79 for invoice:53, receipt: 053 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',276,'','supplier','1',0.00,45000.00,'Payment Id 79 for invoice:53, receipt: 053 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',277,'','2','6',1522770.00,0.00,'Payment Id 78 for invoice:53, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',278,'','supplier','1',0.00,1522770.00,'Payment Id 78 for invoice:53, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',279,'','6.1','4',44000.00,0.00,'Payment Id 77 for invoice:52, receipt: 052 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',280,'','supplier','1',0.00,44000.00,'Payment Id 77 for invoice:52, receipt: 052 by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',281,'','2','6',1214690.00,0.00,'Payment Id 76 for invoice:52, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',282,'','supplier','1',0.00,1214690.00,'Payment Id 76 for invoice:52, receipt:  by SALBAS OIL AND GAS LTD','2022-07-25 18:48:11','',''),('5','272',283,'','20','2',1736422.95,0.00,'Sales from shift 55 on 2022-07-26 05:52:23 ','2022-07-26 05:52:23','',''),('5','272',284,'','6.1','4',0.00,1736422.95,'Sales from shift 55 on 2022-07-26 05:52:23 ','2022-07-26 05:52:23','',''),('5','272',285,'','6.1','4',44000.00,0.00,'Payment Id 83 for invoice:55, receipt: 055 by SALBAS OIL AND GAS LTD','2022-07-26 18:20:13','',''),('5','272',286,'','supplier','1',0.00,44000.00,'Payment Id 83 for invoice:55, receipt: 055 by SALBAS OIL AND GAS LTD','2022-07-26 18:20:13','',''),('5','272',287,'','2','6',1692425.00,0.00,'Payment Id 82 for invoice:55, receipt:  by SALBAS OIL AND GAS LTD','2022-07-26 18:20:14','',''),('5','272',288,'','supplier','1',0.00,1692425.00,'Payment Id 82 for invoice:55, receipt:  by SALBAS OIL AND GAS LTD','2022-07-26 18:20:14','',''),('5','272',289,'','20','2',1506825.00,0.00,'Sales from shift 56 on 2022-07-27 06:03:09 ','2022-07-27 06:03:09','',''),('5','272',290,'','6.1','4',0.00,1506825.00,'Sales from shift 56 on 2022-07-27 06:03:09 ','2022-07-27 06:03:09','',''),('5','272',291,'','20','2',334665.00,0.00,'Sales from shift 57 on 2022-07-28 06:52:24 ','2022-07-28 06:52:24','',''),('5','272',292,'','6.1','4',0.00,334665.00,'Sales from shift 57 on 2022-07-28 06:52:24 ','2022-07-28 06:52:24','',''),('5','272',293,'','20','2',269476.55,0.00,'Sales from shift 58 on 2022-07-29 07:11:00 ','2022-07-29 07:11:00','',''),('5','272',294,'','6.1','4',0.00,269476.55,'Sales from shift 58 on 2022-07-29 07:11:00 ','2022-07-29 07:11:00','',''),('5','272',295,'','20','2',312139.40,0.00,'Sales from shift 59 on 2022-07-30 05:46:25 ','2022-07-30 05:46:25','',''),('5','272',296,'','6.1','4',0.00,312139.40,'Sales from shift 59 on 2022-07-30 05:46:25 ','2022-07-30 05:46:25','',''),('5','272',297,'','20','2',277625.80,0.00,'Sales from shift 60 on 2022-07-31 05:21:53 ','2022-07-31 05:21:53','',''),('5','272',298,'','6.1','4',0.00,277625.80,'Sales from shift 60 on 2022-07-31 05:21:53 ','2022-07-31 05:21:53','',''),('5','272',299,'','20','2',285911.95,0.00,'Sales from shift 61 on 2022-08-01 07:47:38 ','2022-08-01 07:47:38','',''),('5','272',300,'','6.1','4',0.00,285911.95,'Sales from shift 61 on 2022-08-01 07:47:38 ','2022-08-01 07:47:38','',''),('5','272',301,'','24','5',0.00,7381500.00,'Purchase Id 9 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-08-01 21:18:23','',''),('5','272',302,'','supplier','1',7381500.00,0.00,'Purchase Id 9 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-08-01 21:18:23','',''),('5','272',303,'','20','2',0.00,0.00,'Sales from shift 62 on 2022-08-02 05:36:18 ','2022-08-02 05:36:18','',''),('5','272',304,'','6.1','4',0.00,0.00,'Sales from shift 62 on 2022-08-02 05:36:18 ','2022-08-02 05:36:18','',''),('5','272',305,'','6.1','4',30250.00,0.00,'Payment Id 95 for invoice:61, receipt: 061 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',306,'','supplier','1',0.00,30250.00,'Payment Id 95 for invoice:61, receipt: 061 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',307,'','2','6',255665.00,0.00,'Payment Id 94 for invoice:61, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',308,'','supplier','1',0.00,255665.00,'Payment Id 94 for invoice:61, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',309,'','6.1','4',30250.00,0.00,'Payment Id 93 for invoice:60, receipt: 060 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',310,'','supplier','1',0.00,30250.00,'Payment Id 93 for invoice:60, receipt: 060 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',311,'','2','6',247380.00,0.00,'Payment Id 92 for invoice:60, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',312,'','supplier','1',0.00,247380.00,'Payment Id 92 for invoice:60, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',313,'','6.1','4',30250.00,0.00,'Payment Id 91 for invoice:59, receipt: 059 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',314,'','supplier','1',0.00,30250.00,'Payment Id 91 for invoice:59, receipt: 059 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',315,'','2','6',281890.00,0.00,'Payment Id 90 for invoice:59, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',316,'','supplier','1',0.00,281890.00,'Payment Id 90 for invoice:59, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',317,'','6.1','4',30250.00,0.00,'Payment Id 89 for invoice:58, receipt: 058 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',318,'','supplier','1',0.00,30250.00,'Payment Id 89 for invoice:58, receipt: 058 by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',319,'','2','6',239230.00,0.00,'Payment Id 88 for invoice:58, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',320,'','supplier','1',0.00,239230.00,'Payment Id 88 for invoice:58, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',321,'','2','6',304415.00,0.00,'Payment Id 86 for invoice:57, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',322,'','supplier','1',0.00,304415.00,'Payment Id 86 for invoice:57, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:36:45','',''),('5','272',323,'','6.1','4',30250.00,0.00,'Payment Id 87 for invoice:57, receipt: 057 by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',324,'','supplier','1',0.00,30250.00,'Payment Id 87 for invoice:57, receipt: 057 by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',325,'','6.1','4',46500.00,0.00,'Payment Id 85 for invoice:56, receipt: 056 by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',326,'','supplier','1',0.00,46500.00,'Payment Id 85 for invoice:56, receipt: 056 by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',327,'','2','6',1460325.00,0.00,'Payment Id 84 for invoice:56, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',328,'','supplier','1',0.00,1460325.00,'Payment Id 84 for invoice:56, receipt:  by SALBAS OIL AND GAS LTD','2022-08-02 05:37:06','',''),('5','272',329,'','20','2',706298.55,0.00,'Sales from shift 63 on 2022-08-03 06:56:53 ','2022-08-03 06:56:53','',''),('5','272',330,'','6.1','4',0.00,706298.55,'Sales from shift 63 on 2022-08-03 06:56:53 ','2022-08-03 06:56:53','',''),('5','272',331,'','6.1','4',17000.00,0.00,'Payment Id 97 for invoice:63, receipt: 063 by SALBAS OIL AND GAS LTD','2022-08-03 17:51:39','',''),('5','272',332,'','supplier','1',0.00,17000.00,'Payment Id 97 for invoice:63, receipt: 063 by SALBAS OIL AND GAS LTD','2022-08-03 17:51:39','',''),('5','272',333,'','2','6',689300.00,0.00,'Payment Id 96 for invoice:63, receipt:  by SALBAS OIL AND GAS LTD','2022-08-03 17:51:39','',''),('5','272',334,'','supplier','1',0.00,689300.00,'Payment Id 96 for invoice:63, receipt:  by SALBAS OIL AND GAS LTD','2022-08-03 17:51:39','',''),('5','272',335,'','20','2',3717438.10,0.00,'Sales from shift 64 on 2022-08-04 06:13:20 ','2022-08-04 06:13:20','',''),('5','272',336,'','6.1','4',0.00,3717438.10,'Sales from shift 64 on 2022-08-04 06:13:20 ','2022-08-04 06:13:20','',''),('5','272',337,'','24','5',0.00,8214000.00,'Purchase Id 10 for 44,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-08-04 17:11:42','',''),('5','272',338,'','supplier','1',8214000.00,0.00,'Purchase Id 10 for 44,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-08-04 17:11:42','',''),('5','272',339,'','20','2',410757.35,0.00,'Sales from shift 65 on 2022-08-05 06:33:10 ','2022-08-05 06:33:10','',''),('5','272',340,'','6.1','4',0.00,410757.35,'Sales from shift 65 on 2022-08-05 06:33:10 ','2022-08-05 06:33:10','',''),('5','272',341,'','6.1','4',31750.00,0.00,'Payment Id 99 for invoice:64, receipt: 064 by SALBAS OIL AND GAS LTD','2022-08-05 06:33:32','',''),('5','272',342,'','supplier','1',0.00,31750.00,'Payment Id 99 for invoice:64, receipt: 064 by SALBAS OIL AND GAS LTD','2022-08-05 06:33:32','',''),('5','272',343,'','2','6',3685690.00,0.00,'Payment Id 98 for invoice:64, receipt:  by SALBAS OIL AND GAS LTD','2022-08-05 06:33:33','',''),('5','272',344,'','supplier','1',0.00,3685690.00,'Payment Id 98 for invoice:64, receipt:  by SALBAS OIL AND GAS LTD','2022-08-05 06:33:33','',''),('5','272',345,'','20','2',804269.00,0.00,'Sales from shift 66 on 2022-08-06 06:59:22 ','2022-08-06 06:59:22','',''),('5','272',346,'','6.1','4',0.00,804269.00,'Sales from shift 66 on 2022-08-06 06:59:22 ','2022-08-06 06:59:22','',''),('5','272',347,'','6.1','4',27500.00,0.00,'Payment Id 101 for invoice:65, receipt: 065 by SALBAS OIL AND GAS LTD','2022-08-06 06:59:39','',''),('5','272',348,'','supplier','1',0.00,27500.00,'Payment Id 101 for invoice:65, receipt: 065 by SALBAS OIL AND GAS LTD','2022-08-06 06:59:39','',''),('5','272',349,'','2','6',383260.00,0.00,'Payment Id 100 for invoice:65, receipt:  by SALBAS OIL AND GAS LTD','2022-08-06 06:59:39','',''),('5','272',350,'','supplier','1',0.00,383260.00,'Payment Id 100 for invoice:65, receipt:  by SALBAS OIL AND GAS LTD','2022-08-06 06:59:39','',''),('5','272',351,'','20','2',1732883.90,0.00,'Sales from shift 67 on 2022-08-07 05:33:52 ','2022-08-07 05:33:52','',''),('5','272',352,'','6.1','4',0.00,1732883.90,'Sales from shift 67 on 2022-08-07 05:33:52 ','2022-08-07 05:33:52','',''),('5','272',353,'','20','2',1467806.65,0.00,'Sales from shift 68 on 2022-09-05 06:47:20 ','2022-09-05 06:47:20','',''),('5','272',354,'','6.1','4',0.00,1467806.65,'Sales from shift 68 on 2022-09-05 06:47:20 ','2022-09-05 06:47:20','',''),('5','272',355,'','20','2',2606132.00,0.00,'Sales from shift 69 on 2022-09-06 11:49:20 ','2022-09-06 11:49:20','',''),('5','272',356,'','6.1','4',0.00,2606132.00,'Sales from shift 69 on 2022-09-06 11:49:20 ','2022-09-06 11:49:20','',''),('5','272',357,'','20','2',2236061.70,0.00,'Sales from shift 70 on 2022-09-06 12:04:28 ','2022-09-06 12:04:28','',''),('5','272',358,'','6.1','4',0.00,2236061.70,'Sales from shift 70 on 2022-09-06 12:04:28 ','2022-09-06 12:04:28','',''),('5','272',359,'','24','5',0.00,6055050.00,'Purchase Id 11 for 32,730.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 12:10:08','',''),('5','272',360,'','supplier','1',6055050.00,0.00,'Purchase Id 11 for 32,730.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 12:10:08','',''),('5','272',361,'','20','2',2775599.40,0.00,'Sales from shift 71 on 2022-09-06 12:24:51 ','2022-09-06 12:24:51','',''),('5','272',362,'','6.1','4',0.00,2775599.40,'Sales from shift 71 on 2022-09-06 12:24:51 ','2022-09-06 12:24:51','',''),('5','272',363,'','20','2',2783249.15,0.00,'Sales from shift 72 on 2022-09-06 12:31:21 ','2022-09-06 12:31:21','',''),('5','272',364,'','6.1','4',0.00,2783249.15,'Sales from shift 72 on 2022-09-06 12:31:21 ','2022-09-06 12:31:21','',''),('5','272',365,'','20','2',2093075.20,0.00,'Sales from shift 73 on 2022-09-06 12:35:46 ','2022-09-06 12:35:46','',''),('5','272',366,'','6.1','4',0.00,2093075.20,'Sales from shift 73 on 2022-09-06 12:35:46 ','2022-09-06 12:35:46','',''),('5','272',367,'','24','5',0.00,8195500.00,'Purchase Id 12 for 44,300.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 13:05:15','',''),('5','272',368,'','supplier','1',8195500.00,0.00,'Purchase Id 12 for 44,300.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 13:05:15','',''),('5','272',369,'','20','2',2525216.70,0.00,'Sales from shift 74 on 2022-09-06 13:26:53 ','2022-09-06 13:26:53','',''),('5','272',370,'','6.1','4',0.00,2525216.70,'Sales from shift 74 on 2022-09-06 13:26:53 ','2022-09-06 13:26:53','',''),('5','272',371,'','20','2',2290697.75,0.00,'Sales from shift 75 on 2022-09-06 13:49:15 ','2022-09-06 13:49:15','',''),('5','272',372,'','6.1','4',0.00,2290697.75,'Sales from shift 75 on 2022-09-06 13:49:15 ','2022-09-06 13:49:15','',''),('5','272',373,'','24','5',0.00,7316750.00,'Purchase Id 13 for 39,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 14:10:15','',''),('5','272',374,'','supplier','1',7316750.00,0.00,'Purchase Id 13 for 39,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 14:10:15','',''),('5','272',375,'','20','2',2181000.15,0.00,'Sales from shift 76 on 2022-09-06 14:27:58 ','2022-09-06 14:27:58','',''),('5','272',376,'','6.1','4',0.00,2181000.15,'Sales from shift 76 on 2022-09-06 14:27:58 ','2022-09-06 14:27:58','',''),('5','272',377,'','20','2',1901679.75,0.00,'Sales from shift 77 on 2022-09-06 14:31:41 ','2022-09-06 14:31:41','',''),('5','272',378,'','6.1','4',0.00,1901679.75,'Sales from shift 77 on 2022-09-06 14:31:41 ','2022-09-06 14:31:41','',''),('5','272',379,'','20','2',1900007.35,0.00,'Sales from shift 78 on 2022-09-06 14:36:42 ','2022-09-06 14:36:42','',''),('5','272',380,'','6.1','4',0.00,1900007.35,'Sales from shift 78 on 2022-09-06 14:36:42 ','2022-09-06 14:36:42','',''),('5','272',381,'','20','2',2074776.85,0.00,'Sales from shift 79 on 2022-09-06 14:40:23 ','2022-09-06 14:40:23','',''),('5','272',382,'','6.1','4',0.00,2074776.85,'Sales from shift 79 on 2022-09-06 14:40:23 ','2022-09-06 14:40:23','',''),('5','272',383,'','20','2',2539293.35,0.00,'Sales from shift 80 on 2022-09-06 15:13:05 ','2022-09-06 15:13:05','',''),('5','272',384,'','6.1','4',0.00,2539293.35,'Sales from shift 80 on 2022-09-06 15:13:05 ','2022-09-06 15:13:05','',''),('5','272',385,'','24','5',0.00,11100000.00,'Purchase Id 16 for 60,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 15:21:57','',''),('5','272',386,'','supplier','1',11100000.00,0.00,'Purchase Id 16 for 60,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-06 15:21:57','',''),('5','272',387,'','20','2',2577087.00,0.00,'Sales from shift 81 on 2022-09-06 15:41:02 ','2022-09-06 15:41:02','',''),('5','272',388,'','6.1','4',0.00,2577087.00,'Sales from shift 81 on 2022-09-06 15:41:02 ','2022-09-06 15:41:02','',''),('5','272',389,'','20','2',1610893.05,0.00,'Sales from shift 82 on 2022-09-06 16:03:53 ','2022-09-06 16:03:53','',''),('5','272',390,'','6.1','4',0.00,1610893.05,'Sales from shift 82 on 2022-09-06 16:03:53 ','2022-09-06 16:03:53','',''),('5','272',391,'','20','2',1820927.25,0.00,'Sales from shift 83 on 2022-09-08 12:30:07 ','2022-09-08 12:30:07','',''),('5','272',392,'','6.1','4',0.00,1820927.25,'Sales from shift 83 on 2022-09-08 12:30:07 ','2022-09-08 12:30:07','',''),('5','272',393,'','20','2',2119648.60,0.00,'Sales from shift 84 on 2022-09-08 12:33:01 ','2022-09-08 12:33:01','',''),('5','272',394,'','6.1','4',0.00,2119648.60,'Sales from shift 84 on 2022-09-08 12:33:01 ','2022-09-08 12:33:01','',''),('5','272',395,'','20','2',2494478.95,0.00,'Sales from shift 85 on 2022-09-08 12:41:23 ','2022-09-08 12:41:23','',''),('5','272',396,'','6.1','4',0.00,2494478.95,'Sales from shift 85 on 2022-09-08 12:41:23 ','2022-09-08 12:41:23','',''),('5','272',397,'','24','5',0.00,9176370.00,'Purchase Id 17 for 49,602.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 12:46:35','',''),('5','272',398,'','supplier','1',9176370.00,0.00,'Purchase Id 17 for 49,602.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 12:46:35','',''),('5','272',399,'','20','2',2301459.20,0.00,'Sales from shift 86 on 2022-09-08 13:45:58 ','2022-09-08 13:45:58','',''),('5','272',400,'','6.1','4',0.00,2301459.20,'Sales from shift 86 on 2022-09-08 13:45:58 ','2022-09-08 13:45:58','',''),('5','272',401,'','20','2',2785865.05,0.00,'Sales from shift 87 on 2022-09-08 13:54:59 ','2022-09-08 13:54:59','',''),('5','272',402,'','6.1','4',0.00,2785865.05,'Sales from shift 87 on 2022-09-08 13:54:59 ','2022-09-08 13:54:59','',''),('5','272',403,'','20','2',2457556.65,0.00,'Sales from shift 88 on 2022-09-08 13:59:55 ','2022-09-08 13:59:55','',''),('5','272',404,'','6.1','4',0.00,2457556.65,'Sales from shift 88 on 2022-09-08 13:59:55 ','2022-09-08 13:59:55','',''),('5','272',405,'','24','5',0.00,7316750.00,'Purchase Id 18 for 39,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 14:09:24','',''),('5','272',406,'','supplier','1',7316750.00,0.00,'Purchase Id 18 for 39,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 14:09:24','',''),('5','272',407,'','20','2',2310450.20,0.00,'Sales from shift 89 on 2022-09-08 14:21:15 ','2022-09-08 14:21:15','',''),('5','272',408,'','6.1','4',0.00,2310450.20,'Sales from shift 89 on 2022-09-08 14:21:15 ','2022-09-08 14:21:15','',''),('5','272',409,'','20','2',2759369.35,0.00,'Sales from shift 90 on 2022-09-08 14:41:50 ','2022-09-08 14:41:50','',''),('5','272',410,'','6.1','4',0.00,2759369.35,'Sales from shift 90 on 2022-09-08 14:41:50 ','2022-09-08 14:41:50','',''),('5','272',411,'','20','2',2491071.25,0.00,'Sales from shift 91 on 2022-09-08 14:57:45 ','2022-09-08 14:57:45','',''),('5','272',412,'','6.1','4',0.00,2491071.25,'Sales from shift 91 on 2022-09-08 14:57:45 ','2022-09-08 14:57:45','',''),('5','272',413,'','20','2',844991.20,0.00,'Sales from shift 92 on 2022-09-08 15:28:44 ','2022-09-08 15:28:44','',''),('5','272',414,'','6.1','4',0.00,844991.20,'Sales from shift 92 on 2022-09-08 15:28:44 ','2022-09-08 15:28:44','',''),('5','272',415,'','20','2',448247.60,0.00,'Sales from shift 93 on 2022-09-08 16:09:00 ','2022-09-08 16:09:00','',''),('5','272',416,'','6.1','4',0.00,448247.60,'Sales from shift 93 on 2022-09-08 16:09:00 ','2022-09-08 16:09:00','',''),('5','272',417,'','20','2',1009794.75,0.00,'Sales from shift 94 on 2022-09-08 16:15:06 ','2022-09-08 16:15:06','',''),('5','272',418,'','6.1','4',0.00,1009794.75,'Sales from shift 94 on 2022-09-08 16:15:06 ','2022-09-08 16:15:06','',''),('5','272',419,'','24','5',0.00,8214000.00,'Purchase Id 19 for 44,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 16:28:23','',''),('5','272',420,'','supplier','1',8214000.00,0.00,'Purchase Id 19 for 44,400.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 16:28:23','',''),('5','272',421,'','20','2',2606986.70,0.00,'Sales from shift 95 on 2022-09-08 16:34:59 ','2022-09-08 16:34:59','',''),('5','272',422,'','6.1','4',0.00,2606986.70,'Sales from shift 95 on 2022-09-08 16:34:59 ','2022-09-08 16:34:59','',''),('5','272',423,'','20','2',1970727.30,0.00,'Sales from shift 96 on 2022-09-08 16:41:43 ','2022-09-08 16:41:43','',''),('5','272',424,'','6.1','4',0.00,1970727.30,'Sales from shift 96 on 2022-09-08 16:41:43 ','2022-09-08 16:41:43','',''),('5','272',425,'','20','2',2573466.55,0.00,'Sales from shift 97 on 2022-09-08 16:45:50 ','2022-09-08 16:45:50','',''),('5','272',426,'','6.1','4',0.00,2573466.55,'Sales from shift 97 on 2022-09-08 16:45:50 ','2022-09-08 16:45:50','',''),('5','272',427,'','24','5',0.00,8223250.00,'Purchase Id 20 for 44,450.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 16:54:11','',''),('5','272',428,'','supplier','1',8223250.00,0.00,'Purchase Id 20 for 44,450.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-08 16:54:11','',''),('5','272',429,'','2','6',1870510.00,0.00,'Payment Id 128 for invoice:78, receipt: 078 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:55','',''),('5','272',430,'','supplier','1',0.00,1870510.00,'Payment Id 128 for invoice:78, receipt: 078 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:55','',''),('5','272',431,'','6.1','4',27500.00,0.00,'Payment Id 127 for invoice:77, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',432,'','supplier','1',0.00,27500.00,'Payment Id 127 for invoice:77, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',433,'','2','6',1874180.00,0.00,'Payment Id 126 for invoice:77, receipt: 077 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',434,'','supplier','1',0.00,1874180.00,'Payment Id 126 for invoice:77, receipt: 077 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',435,'','6.1','4',27500.00,0.00,'Payment Id 125 for invoice:76, receipt: 076 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',436,'','supplier','1',0.00,27500.00,'Payment Id 125 for invoice:76, receipt: 076 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',437,'','2','6',2153505.00,0.00,'Payment Id 124 for invoice:76, receipt: 076 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',438,'','supplier','1',0.00,2153505.00,'Payment Id 124 for invoice:76, receipt: 076 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',439,'','6.1','4',26000.00,0.00,'Payment Id 123 for invoice:75, receipt: 075 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',440,'','supplier','1',0.00,26000.00,'Payment Id 123 for invoice:75, receipt: 075 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',441,'','2','6',2264700.00,0.00,'Payment Id 122 for invoice:75, receipt: 075 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',442,'','supplier','1',0.00,2264700.00,'Payment Id 122 for invoice:75, receipt: 075 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',443,'','6.1','4',27000.00,0.00,'Payment Id 121 for invoice:74, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',444,'','supplier','1',0.00,27000.00,'Payment Id 121 for invoice:74, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',445,'','2','6',2498220.00,0.00,'Payment Id 120 for invoice:74, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',446,'','supplier','1',0.00,2498220.00,'Payment Id 120 for invoice:74, receipt: 074 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',447,'','6.1','4',27500.00,0.00,'Payment Id 119 for invoice:73, receipt: 073 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',448,'','supplier','1',0.00,27500.00,'Payment Id 119 for invoice:73, receipt: 073 by SALBAS OIL AND GAS LTD','2022-09-10 15:02:56','',''),('5','272',449,'','2','6',2065580.00,0.00,'Payment Id 118 for invoice:73, receipt: 073 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',450,'','supplier','1',0.00,2065580.00,'Payment Id 118 for invoice:73, receipt: 073 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',451,'','6.1','4',27500.00,0.00,'Payment Id 117 for invoice:72, receipt: 072 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',452,'','supplier','1',0.00,27500.00,'Payment Id 117 for invoice:72, receipt: 072 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',453,'','2','6',2755750.00,0.00,'Payment Id 116 for invoice:72, receipt: 072 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',454,'','supplier','1',0.00,2755750.00,'Payment Id 116 for invoice:72, receipt: 072 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',455,'','6.1','4',330000.00,0.00,'Payment Id 115 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',456,'','supplier','1',0.00,330000.00,'Payment Id 115 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',457,'','2','6',20000.00,0.00,'Payment Id 114 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',458,'','supplier','1',0.00,20000.00,'Payment Id 114 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',459,'','2','6',2425600.00,0.00,'Payment Id 113 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',460,'','supplier','1',0.00,2425600.00,'Payment Id 113 for invoice:71, receipt: 071 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',461,'','6.1','4',67350.00,0.00,'Payment Id 112 for invoice:70, receipt: 070 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',462,'','supplier','1',0.00,67350.00,'Payment Id 112 for invoice:70, receipt: 070 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',463,'','2','6',2168715.00,0.00,'Payment Id 111 for invoice:70, receipt: 070 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',464,'','supplier','1',0.00,2168715.00,'Payment Id 111 for invoice:70, receipt: 070 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',465,'','2','6',500.00,0.00,'Payment Id 110 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',466,'','supplier','1',0.00,500.00,'Payment Id 110 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',467,'','6.1','4',27500.00,0.00,'Payment Id 109 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',468,'','supplier','1',0.00,27500.00,'Payment Id 109 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:28','',''),('5','272',469,'','2','6',2578135.00,0.00,'Payment Id 108 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',470,'','supplier','1',0.00,2578135.00,'Payment Id 108 for invoice:69, receipt: 069 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',471,'','6.1','4',26000.00,0.00,'Payment Id 107 for invoice:68, receipt: 068 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',472,'','supplier','1',0.00,26000.00,'Payment Id 107 for invoice:68, receipt: 068 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',473,'','2','6',1441810.00,0.00,'Payment Id 106 for invoice:68, receipt: 068 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',474,'','supplier','1',0.00,1441810.00,'Payment Id 106 for invoice:68, receipt: 068 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',475,'','6.1','4',35250.00,0.00,'Payment Id 105 for invoice:67, receipt: 067 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',476,'','supplier','1',0.00,35250.00,'Payment Id 105 for invoice:67, receipt: 067 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',477,'','6.1','4',39200.00,0.00,'Payment Id 103 for invoice:66, receipt: 066 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',478,'','supplier','1',0.00,39200.00,'Payment Id 103 for invoice:66, receipt: 066 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',479,'','2','6',765070.00,0.00,'Payment Id 102 for invoice:66, receipt: 066 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',480,'','supplier','1',0.00,765070.00,'Payment Id 102 for invoice:66, receipt: 066 by SALBAS OIL AND GAS LTD','2022-09-10 15:03:47','',''),('5','272',481,'','2','6',1697635.00,0.00,'Payment Id 104 for invoice:67, receipt: 067 by SALBAS OIL AND GAS LTD','2022-09-10 15:04:02','',''),('5','272',482,'','supplier','1',0.00,1697635.00,'Payment Id 104 for invoice:67, receipt: 067 by SALBAS OIL AND GAS LTD','2022-09-10 15:04:02','',''),('5','272',483,'','6.1','4',64750.00,0.00,'Payment Id 167 for invoice:97, receipt: 097 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',484,'','supplier','1',0.00,64750.00,'Payment Id 167 for invoice:97, receipt: 097 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',485,'','2','6',2508720.00,0.00,'Payment Id 166 for invoice:97, receipt: 097 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',486,'','supplier','1',0.00,2508720.00,'Payment Id 166 for invoice:97, receipt: 097 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',487,'','6.1','4',43000.00,0.00,'Payment Id 163 for invoice:95, receipt: 095 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',488,'','supplier','1',0.00,43000.00,'Payment Id 163 for invoice:95, receipt: 095 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',489,'','2','6',2563900.00,0.00,'Payment Id 162 for invoice:95, receipt: 095 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',490,'','supplier','1',0.00,2563900.00,'Payment Id 162 for invoice:95, receipt: 095 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',491,'','6.1','4',50700.00,0.00,'Payment Id 161 for invoice:94, receipt: 094 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',492,'','supplier','1',0.00,50700.00,'Payment Id 161 for invoice:94, receipt: 094 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',493,'','2','6',959185.00,0.00,'Payment Id 160 for invoice:94, receipt: 094 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',494,'','supplier','1',0.00,959185.00,'Payment Id 160 for invoice:94, receipt: 094 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',495,'','6.1','4',27500.00,0.00,'Payment Id 159 for invoice:93, receipt: 093 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',496,'','supplier','1',0.00,27500.00,'Payment Id 159 for invoice:93, receipt: 093 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',497,'','2','6',420750.00,0.00,'Payment Id 158 for invoice:93, receipt: 093 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',498,'','supplier','1',0.00,420750.00,'Payment Id 158 for invoice:93, receipt: 093 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:46','',''),('5','272',499,'','6.1','4',34500.00,0.00,'Payment Id 165 for invoice:96, receipt: 096 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:53','',''),('5','272',500,'','supplier','1',0.00,34500.00,'Payment Id 165 for invoice:96, receipt: 096 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:53','',''),('5','272',501,'','2','6',1936230.00,0.00,'Payment Id 164 for invoice:96, receipt: 096 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:53','',''),('5','272',502,'','supplier','1',0.00,1936230.00,'Payment Id 164 for invoice:96, receipt: 096 by SALBAS OIL AND GAS LTD','2022-09-12 08:53:53','',''),('5','272',503,'','6.1','4',28500.00,0.00,'Payment Id 157 for invoice:92, receipt: 092 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',504,'','supplier','1',0.00,28500.00,'Payment Id 157 for invoice:92, receipt: 092 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',505,'','2','6',816495.00,0.00,'Payment Id 156 for invoice:92, receipt: 092 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',506,'','supplier','1',0.00,816495.00,'Payment Id 156 for invoice:92, receipt: 092 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',507,'','6.1','4',44500.00,0.00,'Payment Id 155 for invoice:91, receipt: 091 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',508,'','supplier','1',0.00,44500.00,'Payment Id 155 for invoice:91, receipt: 091 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',509,'','2','6',2446575.00,0.00,'Payment Id 154 for invoice:91, receipt: 091 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',510,'','supplier','1',0.00,2446575.00,'Payment Id 154 for invoice:91, receipt: 091 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',511,'','6.1','4',44500.00,0.00,'Payment Id 153 for invoice:90, receipt: 090 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',512,'','supplier','1',0.00,44500.00,'Payment Id 153 for invoice:90, receipt: 090 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',513,'','2','6',2714870.00,0.00,'Payment Id 152 for invoice:90, receipt: 090 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',514,'','supplier','1',0.00,2714870.00,'Payment Id 152 for invoice:90, receipt: 090 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',515,'','6.1','4',43000.00,0.00,'Payment Id 151 for invoice:89, receipt: 089 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',516,'','supplier','1',0.00,43000.00,'Payment Id 151 for invoice:89, receipt: 089 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',517,'','2','6',2267455.00,0.00,'Payment Id 150 for invoice:89, receipt: 089 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',518,'','supplier','1',0.00,2267455.00,'Payment Id 150 for invoice:89, receipt: 089 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',519,'','6.1','4',43000.00,0.00,'Payment Id 149 for invoice:88, receipt: 088 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',520,'','supplier','1',0.00,43000.00,'Payment Id 149 for invoice:88, receipt: 088 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',521,'','2','6',2414560.00,0.00,'Payment Id 148 for invoice:88, receipt: 088 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',522,'','supplier','1',0.00,2414560.00,'Payment Id 148 for invoice:88, receipt: 088 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:21','',''),('5','272',523,'','6.1','4',44500.00,0.00,'Payment Id 147 for invoice:87, receipt: 087 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',524,'','supplier','1',0.00,44500.00,'Payment Id 147 for invoice:87, receipt: 087 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',525,'','2','6',2741370.00,0.00,'Payment Id 146 for invoice:87, receipt: 087 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',526,'','supplier','1',0.00,2741370.00,'Payment Id 146 for invoice:87, receipt: 087 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',527,'','6.1','4',44500.00,0.00,'Payment Id 145 for invoice:86, receipt: 086 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',528,'','supplier','1',0.00,44500.00,'Payment Id 145 for invoice:86, receipt: 086 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',529,'','2','6',2257010.00,0.00,'Payment Id 144 for invoice:86, receipt: 086 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',530,'','supplier','1',0.00,2257010.00,'Payment Id 144 for invoice:86, receipt: 086 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',531,'','6.1','4',44500.00,0.00,'Payment Id 143 for invoice:85, receipt: 085 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',532,'','supplier','1',0.00,44500.00,'Payment Id 143 for invoice:85, receipt: 085 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',533,'','2','6',2449935.00,0.00,'Payment Id 142 for invoice:85, receipt: 085 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',534,'','supplier','1',0.00,2449935.00,'Payment Id 142 for invoice:85, receipt: 085 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',535,'','6.1','4',82700.00,0.00,'Payment Id 141 for invoice:84, receipt: 084 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',536,'','supplier','1',0.00,82700.00,'Payment Id 141 for invoice:84, receipt: 084 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',537,'','2','6',2036950.00,0.00,'Payment Id 140 for invoice:84, receipt: 084 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',538,'','supplier','1',0.00,2036950.00,'Payment Id 140 for invoice:84, receipt: 084 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',539,'','6.1','4',36000.00,0.00,'Payment Id 139 for invoice:83, receipt: 083 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',540,'','supplier','1',0.00,36000.00,'Payment Id 139 for invoice:83, receipt: 083 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',541,'','2','6',1784930.00,0.00,'Payment Id 138 for invoice:83, receipt: 083 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',542,'','supplier','1',0.00,1784930.00,'Payment Id 138 for invoice:83, receipt: 083 by SALBAS OIL AND GAS LTD','2022-09-12 08:54:43','',''),('5','272',543,'','6.1','4',30250.00,0.00,'Payment Id 137 for invoice:82, receipt: 082 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',544,'','supplier','1',0.00,30250.00,'Payment Id 137 for invoice:82, receipt: 082 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',545,'','2','6',1580645.00,0.00,'Payment Id 136 for invoice:82, receipt: 082 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',546,'','supplier','1',0.00,1580645.00,'Payment Id 136 for invoice:82, receipt: 082 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',547,'','6.1','4',43000.00,0.00,'Payment Id 135 for invoice:81, receipt: 081 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',548,'','supplier','1',0.00,43000.00,'Payment Id 135 for invoice:81, receipt: 081 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',549,'','2','6',2534090.00,0.00,'Payment Id 134 for invoice:81, receipt: 081 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',550,'','supplier','1',0.00,2534090.00,'Payment Id 134 for invoice:81, receipt: 081 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',551,'','6.1','4',44500.00,0.00,'Payment Id 133 for invoice:80, receipt: 080 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',552,'','supplier','1',0.00,44500.00,'Payment Id 133 for invoice:80, receipt: 080 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',553,'','2','6',2494795.00,0.00,'Payment Id 132 for invoice:80, receipt: 080 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',554,'','supplier','1',0.00,2494795.00,'Payment Id 132 for invoice:80, receipt: 080 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',555,'','6.1','4',27500.00,0.00,'Payment Id 131 for invoice:79, receipt: 079 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',556,'','supplier','1',0.00,27500.00,'Payment Id 131 for invoice:79, receipt: 079 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',557,'','2','6',2047280.00,0.00,'Payment Id 130 for invoice:79, receipt: 079 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',558,'','supplier','1',0.00,2047280.00,'Payment Id 130 for invoice:79, receipt: 079 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',559,'','6.1','4',29500.00,0.00,'Payment Id 129 for invoice:78, receipt: 078 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',560,'','supplier','1',0.00,29500.00,'Payment Id 129 for invoice:78, receipt: 078 by SALBAS OIL AND GAS LTD','2022-09-12 08:55:02','',''),('5','272',561,'','20','2',2602937.05,0.00,'Sales from shift 98 on 2022-09-20 15:35:34 ','2022-09-20 15:35:34','',''),('5','272',562,'','6.1','4',0.00,2602937.05,'Sales from shift 98 on 2022-09-20 15:35:34 ','2022-09-20 15:35:34','',''),('5','272',563,'','20','2',2473457.40,0.00,'Sales from shift 99 on 2022-09-20 16:03:52 ','2022-09-20 16:03:52','',''),('5','272',564,'','6.1','4',0.00,2473457.40,'Sales from shift 99 on 2022-09-20 16:03:52 ','2022-09-20 16:03:52','',''),('5','272',565,'','20','2',1809288.90,0.00,'Sales from shift 100 on 2022-09-22 17:58:49 ','2022-09-22 17:58:49','',''),('5','272',566,'','6.1','4',0.00,1809288.90,'Sales from shift 100 on 2022-09-22 17:58:49 ','2022-09-22 17:58:49','',''),('5','272',567,'','20','2',691840.80,0.00,'Sales from shift 101 on 2022-09-22 18:09:28 ','2022-09-22 18:09:28','',''),('5','272',568,'','6.1','4',0.00,691840.80,'Sales from shift 101 on 2022-09-22 18:09:28 ','2022-09-22 18:09:28','',''),('5','272',569,'','20','2',375747.95,0.00,'Sales from shift 102 on 2022-09-22 18:13:27 ','2022-09-22 18:13:27','',''),('5','272',570,'','6.1','4',0.00,375747.95,'Sales from shift 102 on 2022-09-22 18:13:27 ','2022-09-22 18:13:27','',''),('5','272',571,'','20','2',314500.00,0.00,'Sales from shift 103 on 2022-09-22 18:16:02 ','2022-09-22 18:16:02','',''),('5','272',572,'','6.1','4',0.00,314500.00,'Sales from shift 103 on 2022-09-22 18:16:02 ','2022-09-22 18:16:02','',''),('5','272',573,'','20','2',873077.90,0.00,'Sales from shift 104 on 2022-09-22 18:23:56 ','2022-09-22 18:23:56','',''),('5','272',574,'','6.1','4',0.00,873077.90,'Sales from shift 104 on 2022-09-22 18:23:56 ','2022-09-22 18:23:56','',''),('5','272',575,'','24','5',0.00,7418500.00,'Purchase Id 21 for 40,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 14:47:36','',''),('5','272',576,'','supplier','1',7418500.00,0.00,'Purchase Id 21 for 40,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 14:47:36','',''),('5','272',577,'','20','2',1448087.50,0.00,'Sales from shift 105 on 2022-09-26 15:38:07 ','2022-09-26 15:38:07','',''),('5','272',578,'','6.1','4',0.00,1448087.50,'Sales from shift 105 on 2022-09-26 15:38:07 ','2022-09-26 15:38:07','',''),('5','272',579,'','20','2',2528609.60,0.00,'Sales from shift 106 on 2022-09-26 15:42:36 ','2022-09-26 15:42:36','',''),('5','272',580,'','6.1','4',0.00,2528609.60,'Sales from shift 106 on 2022-09-26 15:42:36 ','2022-09-26 15:42:36','',''),('5','272',581,'','20','2',1087761.15,0.00,'Sales from shift 107 on 2022-09-26 15:49:06 ','2022-09-26 15:49:06','',''),('5','272',582,'','6.1','4',0.00,1087761.15,'Sales from shift 107 on 2022-09-26 15:49:06 ','2022-09-26 15:49:06','',''),('5','272',583,'','24','5',0.00,7353750.00,'Purchase Id 22 for 39,750.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 15:50:10','',''),('5','272',584,'','supplier','1',7353750.00,0.00,'Purchase Id 22 for 39,750.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 15:50:10','',''),('5','272',585,'','20','2',2793662.80,0.00,'Sales from shift 108 on 2022-09-26 16:09:11 ','2022-09-26 16:09:11','',''),('5','272',586,'','6.1','4',0.00,2793662.80,'Sales from shift 108 on 2022-09-26 16:09:11 ','2022-09-26 16:09:11','',''),('5','272',587,'','20','2',2740558.55,0.00,'Sales from shift 109 on 2022-09-26 16:14:51 ','2022-09-26 16:14:51','',''),('5','272',588,'','6.1','4',0.00,2740558.55,'Sales from shift 109 on 2022-09-26 16:14:51 ','2022-09-26 16:14:51','',''),('5','272',589,'','20','2',1681163.45,0.00,'Sales from shift 110 on 2022-09-26 16:18:03 ','2022-09-26 16:18:03','',''),('5','272',590,'','6.1','4',0.00,1681163.45,'Sales from shift 110 on 2022-09-26 16:18:03 ','2022-09-26 16:18:03','',''),('5','272',591,'','20','2',1826247.85,0.00,'Sales from shift 111 on 2022-09-26 16:21:01 ','2022-09-26 16:21:01','',''),('5','272',592,'','6.1','4',0.00,1826247.85,'Sales from shift 111 on 2022-09-26 16:21:01 ','2022-09-26 16:21:01','',''),('5','272',593,'','24','5',0.00,8252850.00,'Purchase Id 23 for 44,610.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 16:27:17','',''),('5','272',594,'','supplier','1',8252850.00,0.00,'Purchase Id 23 for 44,610.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 16:27:17','',''),('5','272',595,'','20','2',2143162.10,0.00,'Sales from shift 112 on 2022-09-26 16:42:53 ','2022-09-26 16:42:53','',''),('5','272',596,'','6.1','4',0.00,2143162.10,'Sales from shift 112 on 2022-09-26 16:42:53 ','2022-09-26 16:42:53','',''),('5','272',597,'','20','2',2012800.00,0.00,'Sales from shift 113 on 2022-09-26 16:48:59 ','2022-09-26 16:48:59','',''),('5','272',598,'','6.1','4',0.00,2012800.00,'Sales from shift 113 on 2022-09-26 16:48:59 ','2022-09-26 16:48:59','',''),('5','272',599,'','24','5',0.00,7400000.00,'Purchase Id 24 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 17:00:31','',''),('5','272',600,'','supplier','1',7400000.00,0.00,'Purchase Id 24 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-26 17:00:31','',''),('5','272',601,'','20','2',1856682.20,0.00,'Sales from shift 114 on 2022-09-26 17:08:09 ','2022-09-26 17:08:09','',''),('5','272',602,'','6.1','4',0.00,1856682.20,'Sales from shift 114 on 2022-09-26 17:08:09 ','2022-09-26 17:08:09','',''),('5','272',603,'','20','2',2391507.95,0.00,'Sales from shift 115 on 2022-09-26 18:09:25 ','2022-09-26 18:09:25','',''),('5','272',604,'','6.1','4',0.00,2391507.95,'Sales from shift 115 on 2022-09-26 18:09:25 ','2022-09-26 18:09:25','',''),('5','272',605,'','20','2',2380050.90,0.00,'Sales from shift 116 on 2022-09-26 18:21:48 ','2022-09-26 18:21:48','',''),('5','272',606,'','6.1','4',0.00,2380050.90,'Sales from shift 116 on 2022-09-26 18:21:48 ','2022-09-26 18:21:48','',''),('5','272',607,'','20','2',1611253.80,0.00,'Sales from shift 117 on 2022-09-26 18:25:14 ','2022-09-26 18:25:14','',''),('5','272',608,'','6.1','4',0.00,1611253.80,'Sales from shift 117 on 2022-09-26 18:25:14 ','2022-09-26 18:25:14','',''),('5','272',609,'','20','2',2426793.00,0.00,'Sales from shift 118 on 2022-09-27 09:44:05 ','2022-09-27 09:44:05','',''),('5','272',610,'','6.1','4',0.00,2426793.00,'Sales from shift 118 on 2022-09-27 09:44:05 ','2022-09-27 09:44:05','',''),('5','272',611,'','6.1','4',44500.00,0.00,'Payment Id 185 for invoice:106, receipt: 106 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',612,'','supplier','1',0.00,44500.00,'Payment Id 185 for invoice:106, receipt: 106 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',613,'','2','6',2484110.00,0.00,'Payment Id 184 for invoice:106, receipt: 106 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',614,'','supplier','1',0.00,2484110.00,'Payment Id 184 for invoice:106, receipt: 106 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',615,'','6.1','4',27500.00,0.00,'Payment Id 183 for invoice:105, receipt: 105 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',616,'','supplier','1',0.00,27500.00,'Payment Id 183 for invoice:105, receipt: 105 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',617,'','2','6',981040.00,0.00,'Payment Id 182 for invoice:105, receipt: 105 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',618,'','supplier','1',0.00,981040.00,'Payment Id 182 for invoice:105, receipt: 105 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',619,'','6.1','4',433500.00,0.00,'Payment Id 181 for invoice:104, receipt: 104 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',620,'','supplier','1',0.00,433500.00,'Payment Id 181 for invoice:104, receipt: 104 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',621,'','2','6',439580.00,0.00,'Payment Id 180 for invoice:104, receipt: 104 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',622,'','supplier','1',0.00,439580.00,'Payment Id 180 for invoice:104, receipt: 104 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',623,'','6.1','4',26000.00,0.00,'Payment Id 179 for invoice:103, receipt: 103 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',624,'','supplier','1',0.00,26000.00,'Payment Id 179 for invoice:103, receipt: 103 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',625,'','2','6',288500.00,0.00,'Payment Id 178 for invoice:103, receipt: 103 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',626,'','supplier','1',0.00,288500.00,'Payment Id 178 for invoice:103, receipt: 103 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',627,'','6.1','4',61000.00,0.00,'Payment Id 177 for invoice:102, receipt: 102 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',628,'','supplier','1',0.00,61000.00,'Payment Id 177 for invoice:102, receipt: 102 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',629,'','2','6',314750.00,0.00,'Payment Id 176 for invoice:102, receipt: 102 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',630,'','supplier','1',0.00,314750.00,'Payment Id 176 for invoice:102, receipt: 102 by SALBAS OIL AND GAS LTD','2022-09-27 15:37:40','',''),('5','272',631,'','6.1','4',27500.00,0.00,'Payment Id 175 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',632,'','supplier','1',0.00,27500.00,'Payment Id 175 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',633,'','2','6',664345.00,0.00,'Payment Id 174 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',634,'','supplier','1',0.00,664345.00,'Payment Id 174 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',635,'','6.1','4',36000.00,0.00,'Payment Id 173 for invoice:100, receipt: 100 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',636,'','supplier','1',0.00,36000.00,'Payment Id 173 for invoice:100, receipt: 100 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',637,'','2','6',1773290.00,0.00,'Payment Id 172 for invoice:100, receipt: 100 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',638,'','supplier','1',0.00,1773290.00,'Payment Id 172 for invoice:100, receipt: 100 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',639,'','6.1','4',44500.00,0.00,'Payment Id 171 for invoice:99, receipt: 099 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',640,'','supplier','1',0.00,44500.00,'Payment Id 171 for invoice:99, receipt: 099 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',641,'','2','6',2428960.00,0.00,'Payment Id 170 for invoice:99, receipt: 099 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',642,'','supplier','1',0.00,2428960.00,'Payment Id 170 for invoice:99, receipt: 099 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',643,'','6.1','4',46500.00,0.00,'Payment Id 169 for invoice:98, receipt: 098 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',644,'','supplier','1',0.00,46500.00,'Payment Id 169 for invoice:98, receipt: 098 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',645,'','2','6',2556440.00,0.00,'Payment Id 168 for invoice:98, receipt: 098 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',646,'','supplier','1',0.00,2556440.00,'Payment Id 168 for invoice:98, receipt: 098 by SALBAS OIL AND GAS LTD','2022-09-27 15:38:11','',''),('5','272',647,'','20','2',1531367.10,0.00,'Sales from shift 119 on 2022-09-28 08:21:33 ','2022-09-28 08:21:33','',''),('5','272',648,'','6.1','4',0.00,1531367.10,'Sales from shift 119 on 2022-09-28 08:21:33 ','2022-09-28 08:21:33','',''),('5','272',649,'','6.1','4',44500.00,0.00,'Payment Id 209 for invoice:118, receipt: 118 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',650,'','supplier','1',0.00,44500.00,'Payment Id 209 for invoice:118, receipt: 118 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',651,'','2','6',2382295.00,0.00,'Payment Id 208 for invoice:118, receipt: 118 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',652,'','supplier','1',0.00,2382295.00,'Payment Id 208 for invoice:118, receipt: 118 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',653,'','6.1','4',26000.00,0.00,'Payment Id 207 for invoice:117, receipt: 117 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',654,'','supplier','1',0.00,26000.00,'Payment Id 207 for invoice:117, receipt: 117 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',655,'','2','6',1585255.00,0.00,'Payment Id 206 for invoice:117, receipt: 117 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',656,'','supplier','1',0.00,1585255.00,'Payment Id 206 for invoice:117, receipt: 117 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',657,'','6.1','4',43000.00,0.00,'Payment Id 205 for invoice:116, receipt: 116 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',658,'','supplier','1',0.00,43000.00,'Payment Id 205 for invoice:116, receipt: 116 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',659,'','2','6',2337055.00,0.00,'Payment Id 204 for invoice:116, receipt: 116 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',660,'','supplier','1',0.00,2337055.00,'Payment Id 204 for invoice:116, receipt: 116 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',661,'','6.1','4',144500.00,0.00,'Payment Id 203 for invoice:115, receipt: 115 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',662,'','supplier','1',0.00,144500.00,'Payment Id 203 for invoice:115, receipt: 115 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',663,'','2','6',2247010.00,0.00,'Payment Id 202 for invoice:115, receipt: 115 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',664,'','supplier','1',0.00,2247010.00,'Payment Id 202 for invoice:115, receipt: 115 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',665,'','6.1','4',36000.00,0.00,'Payment Id 201 for invoice:114, receipt: 114 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',666,'','supplier','1',0.00,36000.00,'Payment Id 201 for invoice:114, receipt: 114 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',667,'','2','6',1820685.00,0.00,'Payment Id 200 for invoice:114, receipt: 114 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',668,'','supplier','1',0.00,1820685.00,'Payment Id 200 for invoice:114, receipt: 114 by SALBAS OIL AND GAS LTD','2022-09-28 08:21:54','',''),('5','272',669,'','6.1','4',36000.00,0.00,'Payment Id 199 for invoice:113, receipt: 113 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',670,'','supplier','1',0.00,36000.00,'Payment Id 199 for invoice:113, receipt: 113 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',671,'','2','6',1976800.00,0.00,'Payment Id 198 for invoice:113, receipt: 113 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',672,'','supplier','1',0.00,1976800.00,'Payment Id 198 for invoice:113, receipt: 113 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',673,'','6.1','4',35500.00,0.00,'Payment Id 197 for invoice:112 , receipt: 112 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',674,'','supplier','1',0.00,35500.00,'Payment Id 197 for invoice:112 , receipt: 112 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',675,'','2','6',2107665.00,0.00,'Payment Id 196 for invoice:112, receipt: 112 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',676,'','supplier','1',0.00,2107665.00,'Payment Id 196 for invoice:112, receipt: 112 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',677,'','6.1','4',31750.00,0.00,'Payment Id 195 for invoice:111, receipt: 111 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',678,'','supplier','1',0.00,31750.00,'Payment Id 195 for invoice:111, receipt: 111 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',679,'','2','6',1794500.00,0.00,'Payment Id 194 for invoice:111, receipt: 111 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',680,'','supplier','1',0.00,1794500.00,'Payment Id 194 for invoice:111, receipt: 111 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',681,'','6.1','4',30250.00,0.00,'Payment Id 193 for invoice:110, receipt: 110 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',682,'','supplier','1',0.00,30250.00,'Payment Id 193 for invoice:110, receipt: 110 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',683,'','2','6',1650915.00,0.00,'Payment Id 192 for invoice:110, receipt: 110 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',684,'','supplier','1',0.00,1650915.00,'Payment Id 192 for invoice:110, receipt: 110 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',685,'','6.1','4',43000.00,0.00,'Payment Id 191 for invoice:109, receipt: 109 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',686,'','supplier','1',0.00,43000.00,'Payment Id 191 for invoice:109, receipt: 109 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',687,'','2','6',2697560.00,0.00,'Payment Id 190 for invoice:109, receipt: 109 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',688,'','supplier','1',0.00,2697560.00,'Payment Id 190 for invoice:109, receipt: 109 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:13','',''),('5','272',689,'','6.1','4',161100.00,0.00,'Payment Id 189 for invoice:108, receipt: 108 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',690,'','supplier','1',0.00,161100.00,'Payment Id 189 for invoice:108, receipt: 108 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',691,'','2','6',2632565.00,0.00,'Payment Id 188 for invoice:108, receipt: 108 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',692,'','supplier','1',0.00,2632565.00,'Payment Id 188 for invoice:108, receipt: 108 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',693,'','6.1','4',165000.00,0.00,'Payment Id 187 for invoice:107, receipt: 107 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',694,'','supplier','1',0.00,165000.00,'Payment Id 187 for invoice:107, receipt: 107 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',695,'','2','6',922765.00,0.00,'Payment Id 186 for invoice:107, receipt: 107 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',696,'','supplier','1',0.00,922765.00,'Payment Id 186 for invoice:107, receipt: 107 by SALBAS OIL AND GAS LTD','2022-09-28 08:22:28','',''),('5','272',697,'','6.1','4',64500.00,0.00,'Payment Id 211 for invoice:119, receipt: 119 by SALBAS OIL AND GAS LTD','2022-09-28 16:29:37','',''),('5','272',698,'','supplier','1',0.00,64500.00,'Payment Id 211 for invoice:119, receipt: 119 by SALBAS OIL AND GAS LTD','2022-09-28 16:29:37','',''),('5','272',699,'','2','6',1466870.00,0.00,'Payment Id 210 for invoice:119, receipt: 119 by SALBAS OIL AND GAS LTD','2022-09-28 16:29:37','',''),('5','272',700,'','supplier','1',0.00,1466870.00,'Payment Id 210 for invoice:119, receipt: 119 by SALBAS OIL AND GAS LTD','2022-09-28 16:29:37','',''),('5','272',701,'','24','5',0.00,8288000.00,'Purchase Id 25 for 44,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-28 21:07:32','',''),('5','272',702,'','supplier','1',8288000.00,0.00,'Purchase Id 25 for 44,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-09-28 21:07:32','',''),('5','272',703,'','20','2',2515482.00,0.00,'Sales from shift 120 on 2022-09-29 08:33:21 ','2022-09-29 08:33:21','',''),('5','272',704,'','6.1','4',0.00,2515482.00,'Sales from shift 120 on 2022-09-29 08:33:21 ','2022-09-29 08:33:21','',''),('5','272',705,'','20','2',2620913.50,0.00,'Sales from shift 121 on 2022-09-30 08:06:58 ','2022-09-30 08:06:58','',''),('5','272',706,'','6.1','4',0.00,2620913.50,'Sales from shift 121 on 2022-09-30 08:06:58 ','2022-09-30 08:06:58','',''),('5','272',707,'','6.1','4',44500.00,0.00,'Payment Id 217 for invoice:121, receipt: 121 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',708,'','supplier','1',0.00,44500.00,'Payment Id 217 for invoice:121, receipt: 121 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',709,'','2','6',2576415.00,0.00,'Payment Id 216 for invoice:121, receipt: 121 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',710,'','supplier','1',0.00,2576415.00,'Payment Id 216 for invoice:121, receipt: 121 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',711,'','6.1','4',83350.00,0.00,'Payment Id 215 for invoice:120, receipt: 120 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',712,'','supplier','1',0.00,83350.00,'Payment Id 215 for invoice:120, receipt: 120 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',713,'','2','6',2432135.00,0.00,'Payment Id 214 for invoice:120, receipt: 120 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',714,'','supplier','1',0.00,2432135.00,'Payment Id 214 for invoice:120, receipt: 120 by SALBAS OIL AND GAS LTD','2022-09-30 21:47:55','',''),('5','272',715,'','20','2',2435462.10,0.00,'Sales from shift 122 on 2022-10-01 08:57:05 ','2022-10-01 08:57:05','',''),('5','272',716,'','6.1','4',0.00,2435462.10,'Sales from shift 122 on 2022-10-01 08:57:05 ','2022-10-01 08:57:05','',''),('5','272',717,'','24','5',0.00,4930250.00,'Purchase Id 26 for 26,650.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-01 21:23:14','',''),('5','272',718,'','supplier','1',4930250.00,0.00,'Purchase Id 26 for 26,650.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-01 21:23:14','',''),('5','272',719,'','24','5',0.00,7381500.00,'Purchase Id 27 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-03 16:49:01','',''),('5','272',720,'','supplier','1',7381500.00,0.00,'Purchase Id 27 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-03 16:49:01','',''),('5','272',721,'','supplier','1',0.00,7381500.00,'Purchase Id 27 for 39,900.00 litters of Petrol - PMS returned to SALBAS OIL AND GAS LTD','2022-10-04 11:20:18','',''),('5','272',722,'','20','2',2458032.10,0.00,'Sales from shift 123 on 2022-10-04 11:34:21 ','2022-10-04 11:34:21','',''),('5','272',723,'','6.1','4',0.00,2458032.10,'Sales from shift 123 on 2022-10-04 11:34:21 ','2022-10-04 11:34:21','',''),('5','272',724,'','20','2',2060783.45,0.00,'Sales from shift 124 on 2022-10-04 11:57:32 ','2022-10-04 11:57:32','',''),('5','272',725,'','6.1','4',0.00,2060783.45,'Sales from shift 124 on 2022-10-04 11:57:32 ','2022-10-04 11:57:32','',''),('5','272',726,'','24','5',0.00,2451250.00,'Purchase Id 28 for 13,250.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-04 12:45:07','',''),('5','272',727,'','supplier','1',2451250.00,0.00,'Purchase Id 28 for 13,250.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-04 12:45:07','',''),('5','272',728,'','20','2',1463764.40,0.00,'Sales from shift 125 on 2022-10-04 13:19:02 ','2022-10-04 13:19:02','',''),('5','272',729,'','6.1','4',0.00,1463764.40,'Sales from shift 125 on 2022-10-04 13:19:02 ','2022-10-04 13:19:02','',''),('5','272',730,'','20','2',957861.55,0.00,'Sales from shift 126 on 2022-10-05 09:36:31 ','2022-10-05 09:36:31','',''),('5','272',731,'','6.1','4',0.00,957861.55,'Sales from shift 126 on 2022-10-05 09:36:31 ','2022-10-05 09:36:31','',''),('5','272',732,'','20','2',422419.75,0.00,'Sales from shift 127 on 2022-10-06 07:57:45 ','2022-10-06 07:57:45','',''),('5','272',733,'','6.1','4',0.00,422419.75,'Sales from shift 127 on 2022-10-06 07:57:45 ','2022-10-06 07:57:45','',''),('5','272',734,'','6.1','4',36750.00,0.00,'Payment Id 231 for invoice:127, receipt: 127 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',735,'','supplier','1',0.00,36750.00,'Payment Id 231 for invoice:127, receipt: 127 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',736,'','2','6',385670.00,0.00,'Payment Id 230 for invoice:127, receipt: 127 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',737,'','supplier','1',0.00,385670.00,'Payment Id 230 for invoice:127, receipt: 127 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',738,'','6.1','4',27500.00,0.00,'Payment Id 229 for invoice:126, receipt: 126 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',739,'','supplier','1',0.00,27500.00,'Payment Id 229 for invoice:126, receipt: 126 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',740,'','2','6',930365.00,0.00,'Payment Id 228 for invoice:126, receipt: 126 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',741,'','supplier','1',0.00,930365.00,'Payment Id 228 for invoice:126, receipt: 126 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',742,'','6.1','4',37700.00,0.00,'Payment Id 227 for invoice:125, receipt: 125 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',743,'','supplier','1',0.00,37700.00,'Payment Id 227 for invoice:125, receipt: 125 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',744,'','2','6',1426065.00,0.00,'Payment Id 226 for invoice:125, receipt: 125 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',745,'','supplier','1',0.00,1426065.00,'Payment Id 226 for invoice:125, receipt: 125 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',746,'','6.1','4',43000.00,0.00,'Payment Id 225 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',747,'','supplier','1',0.00,43000.00,'Payment Id 225 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',748,'','2','6',2017765.00,0.00,'Payment Id 224 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',749,'','supplier','1',0.00,2017765.00,'Payment Id 224 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',750,'','6.1','4',88000.00,0.00,'Payment Id 223 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',751,'','supplier','1',0.00,88000.00,'Payment Id 223 for invoice:124, receipt: 124 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',752,'','6.1','4',88000.00,0.00,'Payment Id 222 for invoice:123, receipt: 123 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',753,'','supplier','1',0.00,88000.00,'Payment Id 222 for invoice:123, receipt: 123 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:01','',''),('5','272',754,'','2','6',2370055.00,0.00,'Payment Id 221 for invoice:123, receipt: 123 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',755,'','supplier','1',0.00,2370055.00,'Payment Id 221 for invoice:123, receipt: 123 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',756,'','6.1','4',44500.00,0.00,'Payment Id 220 for invoice:122, receipt: 122 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',757,'','supplier','1',0.00,44500.00,'Payment Id 220 for invoice:122, receipt: 122 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',758,'','2','6',2390965.00,0.00,'Payment Id 219 for invoice:122, receipt: 122 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',759,'','supplier','1',0.00,2390965.00,'Payment Id 219 for invoice:122, receipt: 122 by SALBAS OIL AND GAS LTD','2022-10-07 09:37:31','',''),('5','272',760,'','20','2',103503.80,0.00,'Sales from shift 128 on 2022-10-07 10:18:47 ','2022-10-07 10:18:47','',''),('5','272',761,'','6.1','4',0.00,103503.80,'Sales from shift 128 on 2022-10-07 10:18:47 ','2022-10-07 10:18:47','',''),('5','272',762,'','20','2',335954.45,0.00,'Sales from shift 129 on 2022-10-08 08:34:56 ','2022-10-08 08:34:56','',''),('5','272',763,'','6.1','4',0.00,335954.45,'Sales from shift 129 on 2022-10-08 08:34:56 ','2022-10-08 08:34:56','',''),('5','272',764,'','20','2',245472.80,0.00,'Sales from shift 130 on 2022-10-09 08:30:28 ','2022-10-09 08:30:28','',''),('5','272',765,'','6.1','4',0.00,245472.80,'Sales from shift 130 on 2022-10-09 08:30:28 ','2022-10-09 08:30:28','',''),('5','272',766,'','20','2',0.00,0.00,'Sales from shift 131 on 2022-10-10 12:13:23 ','2022-10-10 12:13:23','',''),('5','272',767,'','6.1','4',0.00,0.00,'Sales from shift 131 on 2022-10-10 12:13:23 ','2022-10-10 12:13:23','',''),('5','272',768,'','24','5',0.00,9250000.00,'Purchase Id 29 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-12 14:37:13','',''),('5','272',769,'','supplier','1',9250000.00,0.00,'Purchase Id 29 for 50,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-12 14:37:13','',''),('5','272',770,'','20','2',537334.35,0.00,'Sales from shift 132 on 2022-10-12 15:06:30 ','2022-10-12 15:06:30','',''),('5','272',771,'','6.1','4',0.00,537334.35,'Sales from shift 132 on 2022-10-12 15:06:30 ','2022-10-12 15:06:30','',''),('5','272',772,'','20','2',3473304.70,0.00,'Sales from shift 133 on 2022-10-12 22:11:54 ','2022-10-12 22:11:54','',''),('5','272',773,'','6.1','4',0.00,3473304.70,'Sales from shift 133 on 2022-10-12 22:11:54 ','2022-10-12 22:11:54','',''),('5','272',774,'','20','2',2698604.25,0.00,'Sales from shift 134 on 2022-10-13 05:39:41 ','2022-10-13 05:39:41','',''),('5','272',775,'','6.1','4',0.00,2698604.25,'Sales from shift 134 on 2022-10-13 05:39:41 ','2022-10-13 05:39:41','',''),('5','272',776,'','20','2',2521810.85,0.00,'Sales from shift 135 on 2022-10-14 07:28:05 ','2022-10-14 07:28:05','',''),('5','272',777,'','6.1','4',0.00,2521810.85,'Sales from shift 135 on 2022-10-14 07:28:05 ','2022-10-14 07:28:05','',''),('5','272',778,'','24','5',0.00,9231500.00,'Purchase Id 30 for 49,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-15 21:28:06','',''),('5','272',779,'','supplier','1',9231500.00,0.00,'Purchase Id 30 for 49,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-15 21:28:06','',''),('5','272',780,'','20','2',2804814.60,0.00,'Sales from shift 136 on 2022-10-15 22:26:01 ','2022-10-15 22:26:01','',''),('5','272',781,'','6.1','4',0.00,2804814.60,'Sales from shift 136 on 2022-10-15 22:26:01 ','2022-10-15 22:26:01','',''),('5','272',782,'','20','2',2725035.20,0.00,'Sales from shift 137 on 2022-10-16 09:42:07 ','2022-10-16 09:42:07','',''),('5','272',783,'','6.1','4',0.00,2725035.20,'Sales from shift 137 on 2022-10-16 09:42:07 ','2022-10-16 09:42:07','',''),('5','272',784,'','20','2',3304492.20,0.00,'Sales from shift 138 on 2022-10-17 07:34:55 ','2022-10-17 07:34:55','',''),('5','272',785,'','6.1','4',0.00,3304492.20,'Sales from shift 138 on 2022-10-17 07:34:55 ','2022-10-17 07:34:55','',''),('5','272',786,'','24','5',0.00,11083350.00,'Purchase Id 31 for 59,910.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-19 11:14:34','',''),('5','272',787,'','supplier','1',11083350.00,0.00,'Purchase Id 31 for 59,910.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-19 11:14:34','',''),('5','272',788,'','20','2',2523094.75,0.00,'Sales from shift 139 on 2022-10-19 20:10:03 ','2022-10-19 20:10:03','',''),('5','272',789,'','6.1','4',0.00,2523094.75,'Sales from shift 139 on 2022-10-19 20:10:03 ','2022-10-19 20:10:03','',''),('5','272',790,'','20','2',3456099.70,0.00,'Sales from shift 140 on 2022-10-19 20:26:43 ','2022-10-19 20:26:43','',''),('5','272',791,'','6.1','4',0.00,3456099.70,'Sales from shift 140 on 2022-10-19 20:26:43 ','2022-10-19 20:26:43','',''),('5','272',792,'','20','2',2077969.95,0.00,'Sales from shift 141 on 2022-10-20 07:02:20 ','2022-10-20 07:02:20','',''),('5','272',793,'','6.1','4',0.00,2077969.95,'Sales from shift 141 on 2022-10-20 07:02:20 ','2022-10-20 07:02:20','',''),('5','272',794,'','20','2',2178870.80,0.00,'Sales from shift 142 on 2022-10-21 07:40:04 ','2022-10-21 07:40:04','',''),('5','272',795,'','6.1','4',0.00,2178870.80,'Sales from shift 142 on 2022-10-21 07:40:04 ','2022-10-21 07:40:04','',''),('5','272',796,'','6.1','4',45500.00,0.00,'Payment Id 274 for invoice:141, receipt: 141 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',797,'','supplier','1',0.00,45500.00,'Payment Id 274 for invoice:141, receipt: 141 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',798,'','2','6',2032470.00,0.00,'Payment Id 273 for invoice:141, receipt: 141 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',799,'','supplier','1',0.00,2032470.00,'Payment Id 273 for invoice:141, receipt: 141 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',800,'','6.1','4',54500.00,0.00,'Payment Id 272 for invoice:140, receipt: 140 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',801,'','supplier','1',0.00,54500.00,'Payment Id 272 for invoice:140, receipt: 140 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',802,'','2','6',3401600.00,0.00,'Payment Id 271 for invoice:140, receipt: 140 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',803,'','supplier','1',0.00,3401600.00,'Payment Id 271 for invoice:140, receipt: 140 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',804,'','6.1','4',47500.00,0.00,'Payment Id 270 for invoice:139, receipt: 139 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',805,'','supplier','1',0.00,47500.00,'Payment Id 270 for invoice:139, receipt: 139 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',806,'','2','6',2475600.00,0.00,'Payment Id 269 for invoice:139, receipt: 139 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',807,'','supplier','1',0.00,2475600.00,'Payment Id 269 for invoice:139, receipt: 139 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',808,'','6.1','4',43000.00,0.00,'Payment Id 268 for invoice:138, receipt: 138 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',809,'','supplier','1',0.00,43000.00,'Payment Id 268 for invoice:138, receipt: 138 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',810,'','2','6',3261495.00,0.00,'Payment Id 267 for invoice:138, receipt: 138 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',811,'','supplier','1',0.00,3261495.00,'Payment Id 267 for invoice:138, receipt: 138 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',812,'','6.1','4',737000.00,0.00,'Payment Id 266 for invoice:137, receipt: 137 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',813,'','supplier','1',0.00,737000.00,'Payment Id 266 for invoice:137, receipt: 137 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',814,'','2','6',1988040.00,0.00,'Payment Id 265 for invoice:137, receipt: 137 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',815,'','supplier','1',0.00,1988040.00,'Payment Id 265 for invoice:137, receipt: 137 by SALBAS OIL AND GAS LTD','2022-10-21 07:40:34','',''),('5','272',816,'','6.1','4',44500.00,0.00,'Payment Id 264 for invoice:136, receipt: 136 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',817,'','supplier','1',0.00,44500.00,'Payment Id 264 for invoice:136, receipt: 136 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',818,'','2','6',2760315.00,0.00,'Payment Id 263 for invoice:136, receipt: 136 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',819,'','supplier','1',0.00,2760315.00,'Payment Id 263 for invoice:136, receipt: 136 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',820,'','6.1','4',44500.00,0.00,'Payment Id 262 for invoice:135, receipt: 135 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',821,'','supplier','1',0.00,44500.00,'Payment Id 262 for invoice:135, receipt: 135 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',822,'','2','6',2477315.00,0.00,'Payment Id 261 for invoice:135, receipt: 135 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',823,'','supplier','1',0.00,2477315.00,'Payment Id 261 for invoice:135, receipt: 135 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',824,'','6.1','4',44500.00,0.00,'Payment Id 260 for invoice:134, receipt: 134 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',825,'','supplier','1',0.00,44500.00,'Payment Id 260 for invoice:134, receipt: 134 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',826,'','2','6',2654105.00,0.00,'Payment Id 259 for invoice:134, receipt: 134 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',827,'','supplier','1',0.00,2654105.00,'Payment Id 259 for invoice:134, receipt: 134 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',828,'','6.1','4',48500.00,0.00,'Payment Id 258 for invoice:133, receipt: 133 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',829,'','supplier','1',0.00,48500.00,'Payment Id 258 for invoice:133, receipt: 133 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',830,'','2','6',3443310.00,0.00,'Payment Id 257 for invoice:133, receipt: 133 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',831,'','supplier','1',0.00,3443310.00,'Payment Id 257 for invoice:133, receipt: 133 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',832,'','6.1','4',26000.00,0.00,'Payment Id 256 for invoice:132, receipt: 132 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',833,'','supplier','1',0.00,26000.00,'Payment Id 256 for invoice:132, receipt: 132 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',834,'','2','6',492835.00,0.00,'Payment Id 255 for invoice:132, receipt: 132 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',835,'','supplier','1',0.00,492835.00,'Payment Id 255 for invoice:132, receipt: 132 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:22','',''),('5','272',836,'','6.1','4',36000.00,0.00,'Payment Id 254 for invoice:130, receipt: 130 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',837,'','supplier','1',0.00,36000.00,'Payment Id 254 for invoice:130, receipt: 130 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',838,'','2','6',209475.00,0.00,'Payment Id 253 for invoice:130, receipt: 130 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',839,'','supplier','1',0.00,209475.00,'Payment Id 253 for invoice:130, receipt: 130 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',840,'','6.1','4',26000.00,0.00,'Payment Id 252 for invoice:129, receipt: 129 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',841,'','supplier','1',0.00,26000.00,'Payment Id 252 for invoice:129, receipt: 129 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',842,'','2','6',309955.00,0.00,'Payment Id 251 for invoice:129, receipt: 129 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',843,'','supplier','1',0.00,309955.00,'Payment Id 251 for invoice:129, receipt: 129 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',844,'','6.1','4',19000.00,0.00,'Payment Id 250 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',845,'','supplier','1',0.00,19000.00,'Payment Id 250 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',846,'','2','6',84505.00,0.00,'Payment Id 249 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',847,'','supplier','1',0.00,84505.00,'Payment Id 249 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',848,'','6.1','4',26000.00,0.00,'Payment Id 248 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',849,'','supplier','1',0.00,26000.00,'Payment Id 248 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',850,'','2','6',385670.00,0.00,'Payment Id 247 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',851,'','supplier','1',0.00,385670.00,'Payment Id 247 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',852,'','2','6',2390965.00,0.00,'Payment Id 218 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',853,'','supplier','1',0.00,2390965.00,'Payment Id 218 for invoice:128, receipt: 128 by SALBAS OIL AND GAS LTD','2022-10-21 07:41:43','',''),('5','272',854,'','20','2',1281145.35,0.00,'Sales from shift 143 on 2022-10-22 06:16:04 ','2022-10-22 06:16:04','',''),('5','272',855,'','6.1','4',0.00,1281145.35,'Sales from shift 143 on 2022-10-22 06:16:04 ','2022-10-22 06:16:04','',''),('5','272',856,'','6.1','4',36000.00,0.00,'Payment Id 276 for invoice:142, receipt: 142 by SALBAS OIL AND GAS LTD','2022-10-23 08:10:31','',''),('5','272',857,'','supplier','1',0.00,36000.00,'Payment Id 276 for invoice:142, receipt: 142 by SALBAS OIL AND GAS LTD','2022-10-23 08:10:31','',''),('5','272',858,'','2','6',2142875.00,0.00,'Payment Id 275 for invoice:142, receipt: 142 by SALBAS OIL AND GAS LTD','2022-10-23 08:10:31','',''),('5','272',859,'','supplier','1',0.00,2142875.00,'Payment Id 275 for invoice:142, receipt: 142 by SALBAS OIL AND GAS LTD','2022-10-23 08:10:31','',''),('5','272',860,'','20','2',0.00,0.00,'Sales from shift 144 on 2022-10-23 21:34:11 ','2022-10-23 21:34:11','',''),('5','272',861,'','6.1','4',0.00,0.00,'Sales from shift 144 on 2022-10-23 21:34:11 ','2022-10-23 21:34:11','',''),('5','272',862,'','20','2',0.00,0.00,'Sales from shift 145 on 2022-10-24 07:21:09 ','2022-10-24 07:21:09','',''),('5','272',863,'','6.1','4',0.00,0.00,'Sales from shift 145 on 2022-10-24 07:21:09 ','2022-10-24 07:21:09','',''),('5','272',864,'','20','2',0.00,0.00,'Sales from shift 146 on 2022-10-25 07:21:25 ','2022-10-25 07:21:25','',''),('5','272',865,'','6.1','4',0.00,0.00,'Sales from shift 146 on 2022-10-25 07:21:25 ','2022-10-25 07:21:25','',''),('5','272',866,'','20','2',0.00,0.00,'Sales from shift 147 on 2022-10-26 20:43:54 ','2022-10-26 20:43:54','',''),('5','272',867,'','6.1','4',0.00,0.00,'Sales from shift 147 on 2022-10-26 20:43:54 ','2022-10-26 20:43:54','',''),('5','272',868,'','20','2',0.00,0.00,'Sales from shift 148 on 2022-10-27 11:03:21 ','2022-10-27 11:03:21','',''),('5','272',869,'','6.1','4',0.00,0.00,'Sales from shift 148 on 2022-10-27 11:03:21 ','2022-10-27 11:03:21','',''),('5','272',870,'','2','6',0.00,1341935.00,'Payment Id 9 for invoice:4, receipt:  by SALBAS OIL AND GAS LTD','2022-10-27 15:40:46','',''),('5','272',871,'','supplier','1',1341935.00,0.00,'Payment Id 9 for invoice:4, receipt:  by SALBAS OIL AND GAS LTD','2022-10-27 15:40:46','',''),('5','272',872,'','6.1','4',534267.90,0.00,'Payment Id 277 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:49:54','',''),('5','272',873,'','supplier','1',0.00,534267.90,'Payment Id 277 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:49:54','',''),('5','272',874,'','6.1','4',0.00,534267.90,'Payment Id 277 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:50:41','',''),('5','272',875,'','supplier','1',534267.90,0.00,'Payment Id 277 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:50:41','',''),('5','272',876,'','2','6',0.00,664345.00,'Payment Id 174 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-10-27 15:51:37','',''),('5','272',877,'','supplier','1',664345.00,0.00,'Payment Id 174 for invoice:101, receipt: 101 by SALBAS OIL AND GAS LTD','2022-10-27 15:51:37','',''),('5','272',878,'','6.1','4',130077.10,0.00,'Payment Id 278 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:53:44','',''),('5','272',879,'','supplier','1',0.00,130077.10,'Payment Id 278 for invoice:149, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-10-27 15:53:44','',''),('5','272',880,'','20','2',0.00,0.00,'Sales from shift 149 on 2022-10-28 06:52:45 ','2022-10-28 06:52:45','',''),('5','272',881,'','6.1','4',0.00,0.00,'Sales from shift 149 on 2022-10-28 06:52:45 ','2022-10-28 06:52:45','',''),('5','272',882,'','24','5',0.00,8300950.00,'Purchase Id 32 for 44,870.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-29 21:47:54','',''),('5','272',883,'','supplier','1',8300950.00,0.00,'Purchase Id 32 for 44,870.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-10-29 21:47:54','',''),('5','272',884,'','20','2',2236008.05,0.00,'Sales from shift 150 on 2022-10-30 06:33:39 ','2022-10-30 06:33:39','',''),('5','272',885,'','6.1','4',0.00,2236008.05,'Sales from shift 150 on 2022-10-30 06:33:39 ','2022-10-30 06:33:39','',''),('5','272',886,'','20','2',2168864.15,0.00,'Sales from shift 151 on 2022-10-30 17:49:12 ','2022-10-30 17:49:12','',''),('5','272',887,'','6.1','4',0.00,2168864.15,'Sales from shift 151 on 2022-10-30 17:49:12 ','2022-10-30 17:49:12','',''),('5','272',888,'','20','2',1228536.90,0.00,'Sales from shift 152 on 2022-10-31 06:45:00 ','2022-10-31 06:45:00','',''),('5','272',889,'','6.1','4',0.00,1228536.90,'Sales from shift 152 on 2022-10-31 06:45:00 ','2022-10-31 06:45:00','',''),('5','272',890,'','20','2',1421310.60,0.00,'Sales from shift 153 on 2022-11-01 06:40:21 ','2022-11-01 06:40:21','',''),('5','272',891,'','6.1','4',0.00,1421310.60,'Sales from shift 153 on 2022-11-01 06:40:21 ','2022-11-01 06:40:21','',''),('5','272',892,'','6.1','4',17500.00,0.00,'Payment Id 286 for invoice:152, receipt: 152 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',893,'','supplier','1',0.00,17500.00,'Payment Id 286 for invoice:152, receipt: 152 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',894,'','2','6',1211040.00,0.00,'Payment Id 285 for invoice:152, receipt: 152 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',895,'','supplier','1',0.00,1211040.00,'Payment Id 285 for invoice:152, receipt: 152 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',896,'','6.1','4',17500.00,0.00,'Payment Id 284 for invoice:151, receipt: 151 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',897,'','supplier','1',0.00,17500.00,'Payment Id 284 for invoice:151, receipt: 151 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',898,'','2','6',2151365.00,0.00,'Payment Id 283 for invoice:151, receipt: 151 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',899,'','supplier','1',0.00,2151365.00,'Payment Id 283 for invoice:151, receipt: 151 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',900,'','6.1','4',20500.00,0.00,'Payment Id 282 for invoice:150, receipt: 150 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',901,'','supplier','1',0.00,20500.00,'Payment Id 282 for invoice:150, receipt: 150 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',902,'','2','6',2215510.00,0.00,'Payment Id 281 for invoice:150, receipt: 150 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',903,'','supplier','1',0.00,2215510.00,'Payment Id 281 for invoice:150, receipt: 150 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',904,'','6.1','4',26000.00,0.00,'Payment Id 280 for invoice:143, receipt: 143 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',905,'','supplier','1',0.00,26000.00,'Payment Id 280 for invoice:143, receipt: 143 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',906,'','2','6',1255150.00,0.00,'Payment Id 279 for invoice:143, receipt: 143 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',907,'','supplier','1',0.00,1255150.00,'Payment Id 279 for invoice:143, receipt: 143 by SALBAS OIL AND GAS LTD','2022-11-01 06:40:49','',''),('5','272',908,'','20','2',1297806.45,0.00,'Sales from shift 154 on 2022-11-02 08:22:06 ','2022-11-02 08:22:06','',''),('5','272',909,'','6.1','4',0.00,1297806.45,'Sales from shift 154 on 2022-11-02 08:22:06 ','2022-11-02 08:22:06','',''),('5','272',910,'','6.1','4',19000.00,0.00,'Payment Id 288 for invoice:153, receipt: 153 by SALBAS OIL AND GAS LTD','2022-11-02 08:24:40','',''),('5','272',911,'','supplier','1',0.00,19000.00,'Payment Id 288 for invoice:153, receipt: 153 by SALBAS OIL AND GAS LTD','2022-11-02 08:24:40','',''),('5','272',912,'','2','6',1402315.00,0.00,'Payment Id 287 for invoice:153, receipt: 153 by SALBAS OIL AND GAS LTD','2022-11-02 08:24:40','',''),('5','272',913,'','supplier','1',0.00,1402315.00,'Payment Id 287 for invoice:153, receipt: 153 by SALBAS OIL AND GAS LTD','2022-11-02 08:24:40','',''),('5','272',914,'','20','2',0.00,0.00,'Sales from shift 155 on 2022-11-03 08:12:54 ','2022-11-03 08:12:54','',''),('5','272',915,'','6.1','4',0.00,0.00,'Sales from shift 155 on 2022-11-03 08:12:54 ','2022-11-03 08:12:54','',''),('5','272',916,'','20','2',0.00,0.00,'Sales from shift 156 on 2022-11-04 07:32:00 ','2022-11-04 07:32:00','',''),('5','272',917,'','6.1','4',0.00,0.00,'Sales from shift 156 on 2022-11-04 07:32:00 ','2022-11-04 07:32:00','',''),('5','272',918,'','6.1','4',25500.00,0.00,'Payment Id 290 for invoice:154, receipt: 154 by SALBAS OIL AND GAS LTD','2022-11-04 07:32:21','',''),('5','272',919,'','supplier','1',0.00,25500.00,'Payment Id 290 for invoice:154, receipt: 154 by SALBAS OIL AND GAS LTD','2022-11-04 07:32:21','',''),('5','272',920,'','2','6',1272310.00,0.00,'Payment Id 289 for invoice:154, receipt: 154 by SALBAS OIL AND GAS LTD','2022-11-04 07:32:21','',''),('5','272',921,'','supplier','1',0.00,1272310.00,'Payment Id 289 for invoice:154, receipt: 154 by SALBAS OIL AND GAS LTD','2022-11-04 07:32:21','',''),('5','272',922,'','20','2',0.00,0.00,'Sales from shift 157 on 2022-11-05 09:39:38 ','2022-11-05 09:39:38','',''),('5','272',923,'','6.1','4',0.00,0.00,'Sales from shift 157 on 2022-11-05 09:39:38 ','2022-11-05 09:39:38','',''),('5','272',924,'','20','2',0.00,0.00,'Sales from shift 158 on 2022-11-13 09:50:42 ','2022-11-13 09:50:42','',''),('5','272',925,'','6.1','4',0.00,0.00,'Sales from shift 158 on 2022-11-13 09:50:42 ','2022-11-13 09:50:42','',''),('5','272',926,'','20','2',0.00,0.00,'Sales from shift 159 on 2022-11-13 10:05:08 ','2022-11-13 10:05:08','',''),('5','272',927,'','6.1','4',0.00,0.00,'Sales from shift 159 on 2022-11-13 10:05:08 ','2022-11-13 10:05:08','',''),('5','272',928,'','20','2',0.00,0.00,'Sales from shift 160 on 2022-11-13 21:58:04 ','2022-11-13 21:58:04','',''),('5','272',929,'','6.1','4',0.00,0.00,'Sales from shift 160 on 2022-11-13 21:58:04 ','2022-11-13 21:58:04','',''),('5','272',930,'','20','2',0.00,0.00,'Sales from shift 161 on 2022-11-13 22:05:26 ','2022-11-13 22:05:26','',''),('5','272',931,'','6.1','4',0.00,0.00,'Sales from shift 161 on 2022-11-13 22:05:26 ','2022-11-13 22:05:26','',''),('5','272',932,'','24','5',0.00,8325000.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-13 22:05:47','',''),('5','272',933,'','supplier','1',8325000.00,0.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-13 22:05:47','',''),('5','272',934,'','20','2',2818878.30,0.00,'Sales from shift 162 on 2022-11-14 09:09:51 ','2022-11-14 09:09:51','',''),('5','272',935,'','6.1','4',0.00,2818878.30,'Sales from shift 162 on 2022-11-14 09:09:51 ','2022-11-14 09:09:51','',''),('5','272',936,'','20','2',2210596.45,0.00,'Sales from shift 163 on 2022-11-14 12:39:26 ','2022-11-14 12:39:26','',''),('5','272',937,'','6.1','4',0.00,2210596.45,'Sales from shift 163 on 2022-11-14 12:39:26 ','2022-11-14 12:39:26','',''),('5','272',938,'','20','2',2271964.65,0.00,'Sales from shift 164 on 2022-11-14 13:28:04 ','2022-11-14 13:28:04','',''),('5','272',939,'','6.1','4',0.00,2271964.65,'Sales from shift 164 on 2022-11-14 13:28:04 ','2022-11-14 13:28:04','',''),('5','272',940,'','20','2',0.00,0.00,'Sales from shift 165 on 2022-11-15 07:43:58 ','2022-11-15 07:43:58','',''),('5','272',941,'','6.1','4',0.00,0.00,'Sales from shift 165 on 2022-11-15 07:43:58 ','2022-11-15 07:43:58','',''),('5','272',942,'','6.1','4',36800.00,0.00,'Payment Id 296 for invoice:164, receipt: 164 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',943,'','supplier','1',0.00,36800.00,'Payment Id 296 for invoice:164, receipt: 164 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',944,'','2','6',2179500.00,0.00,'Payment Id 295 for invoice:164, receipt: 164 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',945,'','supplier','1',0.00,2179500.00,'Payment Id 295 for invoice:164, receipt: 164 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',946,'','6.1','4',36800.00,0.00,'Payment Id 294 for invoice:163, receipt: 163 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',947,'','supplier','1',0.00,36800.00,'Payment Id 294 for invoice:163, receipt: 163 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',948,'','2','6',2173800.00,0.00,'Payment Id 293 for invoice:163, receipt: 163 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',949,'','supplier','1',0.00,2173800.00,'Payment Id 293 for invoice:163, receipt: 163 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',950,'','6.1','4',86000.00,0.00,'Payment Id 292 for invoice:162, receipt: 162 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',951,'','supplier','1',0.00,86000.00,'Payment Id 292 for invoice:162, receipt: 162 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',952,'','2','6',2732880.00,0.00,'Payment Id 291 for invoice:162, receipt: 162 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',953,'','supplier','1',0.00,2732880.00,'Payment Id 291 for invoice:162, receipt: 162 by SALBAS OIL AND GAS LTD','2022-11-15 07:44:20','',''),('5','272',954,'','20','2',1044363.85,0.00,'Sales from shift 166 on 2022-11-16 07:34:22 ','2022-11-16 07:34:22','',''),('5','272',955,'','6.1','4',0.00,1044363.85,'Sales from shift 166 on 2022-11-16 07:34:22 ','2022-11-16 07:34:22','',''),('5','272',956,'','6.1','4',352100.00,0.00,'Payment Id 298 for invoice:166, receipt: TCI0060 by SALBAS OIL AND GAS LTD','2022-11-16 07:34:43','',''),('5','272',957,'','supplier','1',0.00,352100.00,'Payment Id 298 for invoice:166, receipt: TCI0060 by SALBAS OIL AND GAS LTD','2022-11-16 07:34:43','',''),('5','272',958,'','2','6',692265.00,0.00,'Payment Id 297 for invoice:166, receipt: TCI0060 by SALBAS OIL AND GAS LTD','2022-11-16 07:34:43','',''),('5','272',959,'','supplier','1',0.00,692265.00,'Payment Id 297 for invoice:166, receipt: TCI0060 by SALBAS OIL AND GAS LTD','2022-11-16 07:34:43','',''),('5','272',960,'','20','2',0.00,0.00,'Sales from shift 167 on 2022-11-17 08:11:41 ','2022-11-17 08:11:41','',''),('5','272',961,'','6.1','4',0.00,0.00,'Sales from shift 167 on 2022-11-17 08:11:41 ','2022-11-17 08:11:41','',''),('5','272',962,'','20','2',0.00,0.00,'Sales from shift 168 on 2022-11-17 10:03:18 ','2022-11-17 10:03:18','',''),('5','272',963,'','6.1','4',0.00,0.00,'Sales from shift 168 on 2022-11-17 10:03:18 ','2022-11-17 10:03:18','',''),('5','272',964,'','20','2',0.00,0.00,'Sales from shift 169 on 2022-11-17 10:52:48 ','2022-11-17 10:52:48','',''),('5','272',965,'','6.1','4',0.00,0.00,'Sales from shift 169 on 2022-11-17 10:52:48 ','2022-11-17 10:52:48','',''),('5','272',966,'','20','2',0.00,0.00,'Sales from shift 170 on 2022-11-18 07:33:00 ','2022-11-18 07:33:00','',''),('5','272',967,'','6.1','4',0.00,0.00,'Sales from shift 170 on 2022-11-18 07:33:00 ','2022-11-18 07:33:00','',''),('5','272',968,'','20','2',0.00,0.00,'Sales from shift 171 on 2022-11-19 08:28:44 ','2022-11-19 08:28:44','',''),('5','272',969,'','6.1','4',0.00,0.00,'Sales from shift 171 on 2022-11-19 08:28:44 ','2022-11-19 08:28:44','',''),('5','272',970,'','20','2',0.00,0.00,'Sales from shift 172 on 2022-11-20 09:37:04 ','2022-11-20 09:37:04','',''),('5','272',971,'','6.1','4',0.00,0.00,'Sales from shift 172 on 2022-11-20 09:37:04 ','2022-11-20 09:37:04','',''),('5','272',972,'','24','5',0.00,2590000.00,'Purchase Id 34 for 14,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-21 14:09:49','',''),('5','272',973,'','supplier','1',2590000.00,0.00,'Purchase Id 34 for 14,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-21 14:09:49','',''),('5','272',974,'','20','2',1385637.05,0.00,'Sales from shift 173 on 2022-11-21 16:16:58 ','2022-11-21 16:16:58','',''),('5','272',975,'','6.1','4',0.00,1385637.05,'Sales from shift 173 on 2022-11-21 16:16:58 ','2022-11-21 16:16:58','',''),('5','272',976,'','20','2',1200291.10,0.00,'Sales from shift 174 on 2022-11-22 09:21:52 ','2022-11-22 09:21:52','',''),('5','272',977,'','6.1','4',0.00,1200291.10,'Sales from shift 174 on 2022-11-22 09:21:52 ','2022-11-22 09:21:52','',''),('5','272',978,'','6.1','4',86800.00,0.00,'Payment Id 300 for invoice:173, receipt: CNR019 by SALBAS OIL AND GAS LTD','2022-11-22 09:22:12','',''),('5','272',979,'','supplier','1',0.00,86800.00,'Payment Id 300 for invoice:173, receipt: CNR019 by SALBAS OIL AND GAS LTD','2022-11-22 09:22:12','',''),('5','272',980,'','2','6',1298840.00,0.00,'Payment Id 299 for invoice:173, receipt: CNR0019 by SALBAS OIL AND GAS LTD','2022-11-22 09:22:12','',''),('5','272',981,'','supplier','1',0.00,1298840.00,'Payment Id 299 for invoice:173, receipt: CNR0019 by SALBAS OIL AND GAS LTD','2022-11-22 09:22:12','',''),('5','272',982,'','6.1','4',36800.00,0.00,'Payment Id 303 for invoice:174, receipt: 0023 by SALBAS OIL AND GAS LTD','2022-11-22 15:16:19','',''),('5','272',983,'','supplier','1',0.00,36800.00,'Payment Id 303 for invoice:174, receipt: 0023 by SALBAS OIL AND GAS LTD','2022-11-22 15:16:19','',''),('5','272',984,'','2','6',1163490.00,0.00,'Payment Id 302 for invoice:174, receipt: 0023 by SALBAS OIL AND GAS LTD','2022-11-22 15:16:19','',''),('5','272',985,'','supplier','1',0.00,1163490.00,'Payment Id 302 for invoice:174, receipt: 0023 by SALBAS OIL AND GAS LTD','2022-11-22 15:16:19','',''),('5','272',986,'','2','6',0.00,1214690.00,'Payment Id 76 for invoice:52, receipt:  by SALBAS OIL AND GAS LTD','2022-11-23 13:17:37','',''),('5','272',987,'','supplier','1',1214690.00,0.00,'Payment Id 76 for invoice:52, receipt:  by SALBAS OIL AND GAS LTD','2022-11-23 13:17:37','',''),('5','272',988,'','6.1','4',194000.00,0.00,'Payment Id 304 for invoice:175, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-11-23 14:03:20','',''),('5','272',989,'','supplier','1',0.00,194000.00,'Payment Id 304 for invoice:175, receipt: 2634 by SALBAS OIL AND GAS LTD','2022-11-23 14:03:20','',''),('5','272',990,'','24','5',0.00,7375950.00,'Purchase Id 35 for 39,870.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-23 14:46:36','',''),('5','272',991,'','supplier','1',7375950.00,0.00,'Purchase Id 35 for 39,870.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-23 14:46:36','',''),('5','272',992,'','20','2',3777934.95,0.00,'Sales from shift 175 on 2022-11-23 16:29:35 ','2022-11-23 16:29:35','',''),('5','272',993,'','6.1','4',0.00,3777934.95,'Sales from shift 175 on 2022-11-23 16:29:35 ','2022-11-23 16:29:35','',''),('5','272',994,'','6.1','4',36800.00,0.00,'Payment Id 306 for invoice:175, receipt: CNR0034 by SALBAS OIL AND GAS LTD','2022-11-23 21:26:15','',''),('5','272',995,'','supplier','1',0.00,36800.00,'Payment Id 306 for invoice:175, receipt: CNR0034 by SALBAS OIL AND GAS LTD','2022-11-23 21:26:15','',''),('5','272',996,'','2','6',3741135.00,0.00,'Payment Id 305 for invoice:175, receipt: CNR0034 by SALBAS OIL AND GAS LTD','2022-11-23 21:26:15','',''),('5','272',997,'','supplier','1',0.00,3741135.00,'Payment Id 305 for invoice:175, receipt: CNR0034 by SALBAS OIL AND GAS LTD','2022-11-23 21:26:15','',''),('5','272',998,'','20','2',3560772.70,0.00,'Sales from shift 176 on 2022-11-24 13:07:15 ','2022-11-24 13:07:15','',''),('5','272',999,'','6.1','4',0.00,3560772.70,'Sales from shift 176 on 2022-11-24 13:07:15 ','2022-11-24 13:07:15','',''),('5','272',1000,'','24','5',0.00,8260250.00,'Purchase Id 36 for 44,650.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-24 20:57:41','',''),('5','272',1001,'','supplier','1',8260250.00,0.00,'Purchase Id 36 for 44,650.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-24 20:57:41','',''),('5','272',1002,'','6.1','4',36800.00,0.00,'Payment Id 308 for invoice:176, receipt: CNR0018 by SALBAS OIL AND GAS LTD','2022-11-24 21:59:48','',''),('5','272',1003,'','supplier','1',0.00,36800.00,'Payment Id 308 for invoice:176, receipt: CNR0018 by SALBAS OIL AND GAS LTD','2022-11-24 21:59:48','',''),('5','272',1004,'','2','6',3523975.00,0.00,'Payment Id 307 for invoice:176, receipt: CNR0018 by SALBAS OIL AND GAS LTD','2022-11-24 21:59:48','',''),('5','272',1005,'','supplier','1',0.00,3523975.00,'Payment Id 307 for invoice:176, receipt: CNR0018 by SALBAS OIL AND GAS LTD','2022-11-24 21:59:48','',''),('5','272',1006,'','20','2',4133423.55,0.00,'Sales from shift 177 on 2022-11-25 08:32:36 ','2022-11-25 08:32:36','',''),('5','272',1007,'','6.1','4',0.00,4133423.55,'Sales from shift 177 on 2022-11-25 08:32:36 ','2022-11-25 08:32:36','',''),('5','272',1008,'','20','2',4157412.50,0.00,'Sales from shift 178 on 2022-11-26 11:47:08 ','2022-11-26 11:47:08','',''),('5','272',1009,'','6.1','4',0.00,4157412.50,'Sales from shift 178 on 2022-11-26 11:47:08 ','2022-11-26 11:47:08','',''),('5','272',1010,'','24','5',0.00,7363000.00,'Purchase Id 37 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-27 21:29:09','',''),('5','272',1011,'','supplier','1',7363000.00,0.00,'Purchase Id 37 for 39,800.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-27 21:29:09','',''),('5','272',1012,'','20','2',4209950.65,0.00,'Sales from shift 179 on 2022-11-28 06:14:23 ','2022-11-28 06:14:23','',''),('5','272',1013,'','6.1','4',0.00,4209950.65,'Sales from shift 179 on 2022-11-28 06:14:23 ','2022-11-28 06:14:23','',''),('5','272',1014,'','20','2',2986665.90,0.00,'Sales from shift 180 on 2022-11-28 07:52:19 ','2022-11-28 07:52:19','',''),('5','272',1015,'','6.1','4',0.00,2986665.90,'Sales from shift 180 on 2022-11-28 07:52:19 ','2022-11-28 07:52:19','',''),('5','272',1016,'','20','2',0.00,0.00,'Sales from shift 181 on 2022-11-29 08:10:11 ','2022-11-29 08:10:11','',''),('5','272',1017,'','6.1','4',0.00,0.00,'Sales from shift 181 on 2022-11-29 08:10:11 ','2022-11-29 08:10:11','',''),('5','272',1018,'','6.1','4',36800.00,0.00,'Payment Id 314 for invoice:180, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1019,'','supplier','1',0.00,36800.00,'Payment Id 314 for invoice:180, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1020,'','2','6',2949865.00,0.00,'Payment Id 313 for invoice:180, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1021,'','supplier','1',0.00,2949865.00,'Payment Id 313 for invoice:180, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1022,'','6.1','4',35300.00,0.00,'Payment Id 312 for invoice:179, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1023,'','supplier','1',0.00,35300.00,'Payment Id 312 for invoice:179, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1024,'','2','6',4174650.00,0.00,'Payment Id 311 for invoice:179, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1025,'','supplier','1',0.00,4174650.00,'Payment Id 311 for invoice:179, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1026,'','6.1','4',35300.00,0.00,'Payment Id 310 for invoice:178, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1027,'','supplier','1',0.00,35300.00,'Payment Id 310 for invoice:178, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1028,'','2','6',4122115.00,0.00,'Payment Id 309 for invoice:181, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1029,'','supplier','1',0.00,4122115.00,'Payment Id 309 for invoice:181, receipt: 024445 by SALBAS OIL AND GAS LTD','2022-11-29 08:10:53','',''),('5','272',1030,'','24','5',0.00,8325000.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-29 19:17:12','',''),('5','272',1031,'','supplier','1',8325000.00,0.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-11-29 19:17:12','',''),('5','272',1032,'','20','2',4376578.30,0.00,'Sales from shift 182 on 2022-11-30 07:34:02 ','2022-11-30 07:34:02','',''),('5','272',1033,'','6.1','4',0.00,4376578.30,'Sales from shift 182 on 2022-11-30 07:34:02 ','2022-11-30 07:34:02','',''),('5','272',1034,'','20','2',4139449.00,0.00,'Sales from shift 183 on 2022-12-01 07:45:14 ','2022-12-01 07:45:14','',''),('5','272',1035,'','6.1','4',0.00,4139449.00,'Sales from shift 183 on 2022-12-01 07:45:14 ','2022-12-01 07:45:14','',''),('5','272',1036,'','6.1','4',36800.00,0.00,'Payment Id 318 for invoice:183, receipt: 0062 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1037,'','supplier','1',0.00,36800.00,'Payment Id 318 for invoice:183, receipt: 0062 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1038,'','2','6',4102650.00,0.00,'Payment Id 317 for invoice:183, receipt: 0062 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1039,'','supplier','1',0.00,4102650.00,'Payment Id 317 for invoice:183, receipt: 0062 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1040,'','6.1','4',36800.00,0.00,'Payment Id 316 for invoice:184, receipt: 0056 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1041,'','supplier','1',0.00,36800.00,'Payment Id 316 for invoice:184, receipt: 0056 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1042,'','2','6',4339780.00,0.00,'Payment Id 315 for invoice:182, receipt: 0056 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1043,'','supplier','1',0.00,4339780.00,'Payment Id 315 for invoice:182, receipt: 0056 by SALBAS OIL AND GAS LTD','2022-12-01 16:40:07','',''),('5','272',1044,'','24','5',0.00,7381500.00,'Purchase Id 39 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-01 22:30:45','',''),('5','272',1045,'','supplier','1',7381500.00,0.00,'Purchase Id 39 for 39,900.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-01 22:30:45','',''),('5','272',1046,'','20','2',4546336.15,0.00,'Sales from shift 184 on 2022-12-02 07:11:34 ','2022-12-02 07:11:34','',''),('5','272',1047,'','6.1','4',0.00,4546336.15,'Sales from shift 184 on 2022-12-02 07:11:34 ','2022-12-02 07:11:34','',''),('5','272',1048,'','20','2',2883223.15,0.00,'Sales from shift 185 on 2022-12-03 08:23:14 ','2022-12-03 08:23:14','',''),('5','272',1049,'','6.1','4',0.00,2883223.15,'Sales from shift 185 on 2022-12-03 08:23:14 ','2022-12-03 08:23:14','',''),('5','272',1050,'','24','5',0.00,8325000.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-03 20:24:30','',''),('5','272',1051,'','supplier','1',8325000.00,0.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-03 20:24:30','',''),('5','272',1052,'','20','2',2767722.10,0.00,'Sales from shift 186 on 2022-12-04 09:15:55 ','2022-12-04 09:15:55','',''),('5','272',1053,'','6.1','4',0.00,2767722.10,'Sales from shift 186 on 2022-12-04 09:15:55 ','2022-12-04 09:15:55','',''),('5','272',1054,'','20','2',3667765.60,0.00,'Sales from shift 187 on 2022-12-05 07:35:58 ','2022-12-05 07:35:58','',''),('5','272',1055,'','6.1','4',0.00,3667765.60,'Sales from shift 187 on 2022-12-05 07:35:58 ','2022-12-05 07:35:58','',''),('5','272',1056,'','20','2',1354758.70,0.00,'Sales from shift 188 on 2022-12-06 07:57:36 ','2022-12-06 07:57:36','',''),('5','272',1057,'','6.1','4',0.00,1354758.70,'Sales from shift 188 on 2022-12-06 07:57:36 ','2022-12-06 07:57:36','',''),('5','272',1058,'','24','5',0.00,2775000.00,'Purchase Id 41 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-06 07:58:05','',''),('5','272',1059,'','supplier','1',2775000.00,0.00,'Purchase Id 41 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2022-12-06 07:58:05','',''),('5','272',1060,'','6.1','4',55800.00,0.00,'Payment Id 320 for invoice:184, receipt: 0081 by SALBAS OIL AND GAS LTD','2022-12-06 07:58:37','',''),('5','272',1061,'','supplier','1',0.00,55800.00,'Payment Id 320 for invoice:184, receipt: 0081 by SALBAS OIL AND GAS LTD','2022-12-06 07:58:37','',''),('5','272',1062,'','2','6',4490540.00,0.00,'Payment Id 319 for invoice:184, receipt: 0081 by SALBAS OIL AND GAS LTD','2022-12-06 07:58:37','',''),('5','272',1063,'','supplier','1',0.00,4490540.00,'Payment Id 319 for invoice:184, receipt: 0081 by SALBAS OIL AND GAS LTD','2022-12-06 07:58:37','',''),('5','272',1064,'','6.1','4',55800.00,0.00,'Payment Id 328 for invoice:188, receipt: 0026 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1065,'','supplier','1',0.00,55800.00,'Payment Id 328 for invoice:188, receipt: 0026 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1066,'','2','6',1291960.00,0.00,'Payment Id 327 for invoice:188, receipt: 0026 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1067,'','supplier','1',0.00,1291960.00,'Payment Id 327 for invoice:188, receipt: 0026 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1068,'','6.1','4',36800.00,0.00,'Payment Id 326 for invoice:187, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1069,'','supplier','1',0.00,36800.00,'Payment Id 326 for invoice:187, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1070,'','2','6',3630965.00,0.00,'Payment Id 325 for invoice:187, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1071,'','supplier','1',0.00,3630965.00,'Payment Id 325 for invoice:187, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1072,'','6.1','4',35300.00,0.00,'Payment Id 324 for invoice:186, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1073,'','supplier','1',0.00,35300.00,'Payment Id 324 for invoice:186, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1074,'','2','6',2732410.00,0.00,'Payment Id 323 for invoice:186, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1075,'','supplier','1',0.00,2732410.00,'Payment Id 323 for invoice:186, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1076,'','6.1','4',35300.00,0.00,'Payment Id 322 for invoice:185, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1077,'','supplier','1',0.00,35300.00,'Payment Id 322 for invoice:185, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1078,'','2','6',2847920.00,0.00,'Payment Id 321 for invoice:185, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1079,'','supplier','1',0.00,2847920.00,'Payment Id 321 for invoice:185, receipt: 343313 by SALBAS OIL AND GAS LTD','2022-12-07 07:44:28','',''),('5','272',1080,'','20','2',1725957.50,0.00,'Sales from shift 189 on 2022-12-07 15:04:48 ','2022-12-07 15:04:48','',''),('5','272',1081,'','6.1','4',0.00,1725957.50,'Sales from shift 189 on 2022-12-07 15:04:48 ','2022-12-07 15:04:48','',''),('5','272',1082,'','6.1','4',36800.00,0.00,'Payment Id 332 for invoice:190, receipt: 0019 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:56','',''),('5','272',1083,'','supplier','1',0.00,36800.00,'Payment Id 332 for invoice:190, receipt: 0019 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:56','',''),('5','272',1084,'','2','6',1574770.00,0.00,'Payment Id 331 for invoice:190, receipt: 019 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:56','',''),('5','272',1085,'','supplier','1',0.00,1574770.00,'Payment Id 331 for invoice:190, receipt: 019 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:56','',''),('5','272',1086,'','6.1','4',36800.00,0.00,'Payment Id 330 for invoice:189, receipt: 0018 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:57','',''),('5','272',1087,'','supplier','1',0.00,36800.00,'Payment Id 330 for invoice:189, receipt: 0018 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:57','',''),('5','272',1088,'','2','6',1689150.00,0.00,'Payment Id 329 for invoice:189, receipt: 0018 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:57','',''),('5','272',1089,'','supplier','1',0.00,1689150.00,'Payment Id 329 for invoice:189, receipt: 0018 by SALBAS OIL AND GAS LTD','2022-12-09 08:11:57','',''),('5','272',1090,'','20','2',1611570.15,0.00,'Sales from shift 190 on 2022-12-13 11:50:49 ','2022-12-13 11:50:49','',''),('5','272',1091,'','6.1','4',0.00,1611570.15,'Sales from shift 190 on 2022-12-13 11:50:49 ','2022-12-13 11:50:49','',''),('5','272',1092,'','20','2',0.00,0.00,'Sales from shift 191 on 2022-12-13 12:02:05 ','2022-12-13 12:02:05','',''),('5','272',1093,'','6.1','4',0.00,0.00,'Sales from shift 191 on 2022-12-13 12:02:05 ','2022-12-13 12:02:05','',''),('5','272',1094,'','20','2',0.00,0.00,'Sales from shift 192 on 2022-12-13 12:10:52 ','2022-12-13 12:10:52','',''),('5','272',1095,'','6.1','4',0.00,0.00,'Sales from shift 192 on 2022-12-13 12:10:52 ','2022-12-13 12:10:52','',''),('5','272',1096,'','20','2',0.00,0.00,'Sales from shift 193 on 2022-12-13 12:13:12 ','2022-12-13 12:13:12','',''),('5','272',1097,'','6.1','4',0.00,0.00,'Sales from shift 193 on 2022-12-13 12:13:12 ','2022-12-13 12:13:12','',''),('5','272',1098,'','20','2',0.00,0.00,'Sales from shift 194 on 2022-12-13 12:15:50 ','2022-12-13 12:15:50','',''),('5','272',1099,'','6.1','4',0.00,0.00,'Sales from shift 194 on 2022-12-13 12:15:50 ','2022-12-13 12:15:50','',''),('5','272',1100,'','20','2',0.00,0.00,'Sales from shift 195 on 2022-12-13 12:18:39 ','2022-12-13 12:18:39','',''),('5','272',1101,'','6.1','4',0.00,0.00,'Sales from shift 195 on 2022-12-13 12:18:39 ','2022-12-13 12:18:39','',''),('5','272',1102,'','20','2',0.00,0.00,'Sales from shift 196 on 2022-12-14 09:47:30 ','2022-12-14 09:47:30','',''),('5','272',1103,'','6.1','4',0.00,0.00,'Sales from shift 196 on 2022-12-14 09:47:30 ','2022-12-14 09:47:30','',''),('5','272',1104,'','20','2',0.00,0.00,'Sales from shift 197 on 2022-12-15 09:59:14 ','2022-12-15 09:59:14','',''),('5','272',1105,'','6.1','4',0.00,0.00,'Sales from shift 197 on 2022-12-15 09:59:14 ','2022-12-15 09:59:14','',''),('5','272',1106,'','2','6',295000.00,0.00,'Payment Id 335 for invoice:197, receipt: 124 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1107,'','supplier','1',0.00,295000.00,'Payment Id 335 for invoice:197, receipt: 124 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1108,'','6.1','4',36800.00,0.00,'Payment Id 334 for invoice:197, receipt: 123 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1109,'','supplier','1',0.00,36800.00,'Payment Id 334 for invoice:197, receipt: 123 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1110,'','2','6',4096625.00,0.00,'Payment Id 333 for invoice:197, receipt: 123 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1111,'','supplier','1',0.00,4096625.00,'Payment Id 333 for invoice:197, receipt: 123 by SALBAS OIL AND GAS LTD','2022-12-15 11:01:52','',''),('5','272',1112,'','2','6',0.00,295000.00,'Payment Id 335 for invoice:197, receipt: 124 by SALBAS OIL AND GAS LTD','2022-12-15 11:03:32','',''),('5','272',1113,'','supplier','1',295000.00,0.00,'Payment Id 335 for invoice:197, receipt: 124 by SALBAS OIL AND GAS LTD','2022-12-15 11:03:32','',''),('5','272',1114,'','2','6',295000.00,0.00,'Payment Id 336 for invoice:197, receipt: 125 by SALBAS OIL AND GAS LTD','2022-12-15 11:09:02','',''),('5','272',1115,'','supplier','1',0.00,295000.00,'Payment Id 336 for invoice:197, receipt: 125 by SALBAS OIL AND GAS LTD','2022-12-15 11:09:02','',''),('5','272',1116,'','20','2',0.00,0.00,'Sales from shift 198 on 2022-12-16 07:29:01 ','2022-12-16 07:29:01','',''),('5','272',1117,'','6.1','4',0.00,0.00,'Sales from shift 198 on 2022-12-16 07:29:01 ','2022-12-16 07:29:01','',''),('5','272',1118,'','20','2',0.00,0.00,'Sales from shift 199 on 2022-12-17 11:12:40 ','2022-12-17 11:12:40','',''),('5','272',1119,'','6.1','4',0.00,0.00,'Sales from shift 199 on 2022-12-17 11:12:40 ','2022-12-17 11:12:40','',''),('5','272',1120,'','20','2',0.00,0.00,'Sales from shift 200 on 2022-12-18 10:40:45 ','2022-12-18 10:40:45','',''),('5','272',1121,'','6.1','4',0.00,0.00,'Sales from shift 200 on 2022-12-18 10:40:45 ','2022-12-18 10:40:45','',''),('5','272',1122,'','20','2',0.00,0.00,'Sales from shift 201 on 2022-12-19 09:13:38 ','2022-12-19 09:13:38','',''),('5','272',1123,'','6.1','4',0.00,0.00,'Sales from shift 201 on 2022-12-19 09:13:38 ','2022-12-19 09:13:38','',''),('5','272',1124,'','20','2',0.00,0.00,'Sales from shift 202 on 2022-12-20 09:36:02 ','2022-12-20 09:36:02','',''),('5','272',1125,'','6.1','4',0.00,0.00,'Sales from shift 202 on 2022-12-20 09:36:02 ','2022-12-20 09:36:02','',''),('5','272',1126,'','20','2',0.00,0.00,'Sales from shift 203 on 2022-12-21 09:36:31 ','2022-12-21 09:36:31','',''),('5','272',1127,'','6.1','4',0.00,0.00,'Sales from shift 203 on 2022-12-21 09:36:31 ','2022-12-21 09:36:31','',''),('5','272',1128,'','20','2',0.00,0.00,'Sales from shift 204 on 2022-12-22 09:03:49 ','2022-12-22 09:03:49','',''),('5','272',1129,'','6.1','4',0.00,0.00,'Sales from shift 204 on 2022-12-22 09:03:49 ','2022-12-22 09:03:49','',''),('5','272',1130,'','20','2',0.00,0.00,'Sales from shift 205 on 2022-12-23 11:08:26 ','2022-12-23 11:08:26','',''),('5','272',1131,'','6.1','4',0.00,0.00,'Sales from shift 205 on 2022-12-23 11:08:26 ','2022-12-23 11:08:26','',''),('5','272',1132,'','20','2',0.00,0.00,'Sales from shift 206 on 2022-12-24 12:04:15 ','2022-12-24 12:04:15','',''),('5','272',1133,'','6.1','4',0.00,0.00,'Sales from shift 206 on 2022-12-24 12:04:15 ','2022-12-24 12:04:15','',''),('5','272',1134,'','20','2',0.00,0.00,'Sales from shift 207 on 2022-12-25 18:27:54 ','2022-12-25 18:27:54','',''),('5','272',1135,'','6.1','4',0.00,0.00,'Sales from shift 207 on 2022-12-25 18:27:54 ','2022-12-25 18:27:54','',''),('5','272',1136,'','20','2',0.00,0.00,'Sales from shift 208 on 2022-12-26 21:06:58 ','2022-12-26 21:06:58','',''),('5','272',1137,'','6.1','4',0.00,0.00,'Sales from shift 208 on 2022-12-26 21:06:58 ','2022-12-26 21:06:58','',''),('5','272',1138,'','20','2',0.00,0.00,'Sales from shift 209 on 2022-12-28 09:01:05 ','2022-12-28 09:01:05','',''),('5','272',1139,'','6.1','4',0.00,0.00,'Sales from shift 209 on 2022-12-28 09:01:05 ','2022-12-28 09:01:05','',''),('5','272',1140,'','20','2',0.00,0.00,'Sales from shift 210 on 2022-12-29 07:55:42 ','2022-12-29 07:55:42','',''),('5','272',1141,'','6.1','4',0.00,0.00,'Sales from shift 210 on 2022-12-29 07:55:42 ','2022-12-29 07:55:42','',''),('5','272',1142,'','20','2',0.00,0.00,'Sales from shift 211 on 2022-12-30 08:11:16 ','2022-12-30 08:11:16','',''),('5','272',1143,'','6.1','4',0.00,0.00,'Sales from shift 211 on 2022-12-30 08:11:16 ','2022-12-30 08:11:16','',''),('5','272',1144,'','20','2',0.00,0.00,'Sales from shift 212 on 2022-12-30 22:20:41 ','2022-12-30 22:20:41','',''),('5','272',1145,'','6.1','4',0.00,0.00,'Sales from shift 212 on 2022-12-30 22:20:41 ','2022-12-30 22:20:41','',''),('5','272',1146,'','20','2',0.00,0.00,'Sales from shift 213 on 2023-01-01 11:30:26 ','2023-01-01 11:30:26','',''),('5','272',1147,'','6.1','4',0.00,0.00,'Sales from shift 213 on 2023-01-01 11:30:26 ','2023-01-01 11:30:26','',''),('5','272',1148,'','20','2',0.00,0.00,'Sales from shift 214 on 2023-01-02 10:38:06 ','2023-01-02 10:38:06','',''),('5','272',1149,'','6.1','4',0.00,0.00,'Sales from shift 214 on 2023-01-02 10:38:06 ','2023-01-02 10:38:06','',''),('5','272',1150,'','20','2',0.00,0.00,'Sales from shift 215 on 2023-01-02 21:58:47 ','2023-01-02 21:58:47','',''),('5','272',1151,'','6.1','4',0.00,0.00,'Sales from shift 215 on 2023-01-02 21:58:47 ','2023-01-02 21:58:47','',''),('5','272',1152,'','20','2',0.00,0.00,'Sales from shift 216 on 2023-01-04 09:44:52 ','2023-01-04 09:44:52','',''),('5','272',1153,'','6.1','4',0.00,0.00,'Sales from shift 216 on 2023-01-04 09:44:52 ','2023-01-04 09:44:52','',''),('5','272',1154,'','20','2',0.00,0.00,'Sales from shift 217 on 2023-01-05 09:09:33 ','2023-01-05 09:09:33','',''),('5','272',1155,'','6.1','4',0.00,0.00,'Sales from shift 217 on 2023-01-05 09:09:33 ','2023-01-05 09:09:33','',''),('5','272',1156,'','20','2',0.00,0.00,'Sales from shift 218 on 2023-01-06 09:11:16 ','2023-01-06 09:11:16','',''),('5','272',1157,'','6.1','4',0.00,0.00,'Sales from shift 218 on 2023-01-06 09:11:16 ','2023-01-06 09:11:16','',''),('5','272',1158,'','20','2',0.00,0.00,'Sales from shift 219 on 2023-01-06 21:52:02 ','2023-01-06 21:52:02','',''),('5','272',1159,'','6.1','4',0.00,0.00,'Sales from shift 219 on 2023-01-06 21:52:02 ','2023-01-06 21:52:02','',''),('5','272',1160,'','20','2',0.00,0.00,'Sales from shift 220 on 2023-01-07 11:06:30 ','2023-01-07 11:06:30','',''),('5','272',1161,'','6.1','4',0.00,0.00,'Sales from shift 220 on 2023-01-07 11:06:30 ','2023-01-07 11:06:30','',''),('5','272',1162,'','20','2',0.00,0.00,'Sales from shift 221 on 2023-01-07 20:17:33 ','2023-01-07 20:17:33','',''),('5','272',1163,'','6.1','4',0.00,0.00,'Sales from shift 221 on 2023-01-07 20:17:33 ','2023-01-07 20:17:33','',''),('5','272',1164,'','20','2',0.00,0.00,'Sales from shift 222 on 2023-01-08 17:12:29 ','2023-01-08 17:12:29','',''),('5','272',1165,'','6.1','4',0.00,0.00,'Sales from shift 222 on 2023-01-08 17:12:29 ','2023-01-08 17:12:29','',''),('5','272',1166,'','20','2',0.00,0.00,'Sales from shift 223 on 2023-01-10 09:12:29 ','2023-01-10 09:12:29','',''),('5','272',1167,'','6.1','4',0.00,0.00,'Sales from shift 223 on 2023-01-10 09:12:29 ','2023-01-10 09:12:29','',''),('5','272',1168,'','20','2',0.00,0.00,'Sales from shift 224 on 2023-01-10 22:21:34 ','2023-01-10 22:21:34','',''),('5','272',1169,'','6.1','4',0.00,0.00,'Sales from shift 224 on 2023-01-10 22:21:34 ','2023-01-10 22:21:34','',''),('5','272',1170,'','20','2',0.00,0.00,'Sales from shift 225 on 2023-01-12 09:24:11 ','2023-01-12 09:24:11','',''),('5','272',1171,'','6.1','4',0.00,0.00,'Sales from shift 225 on 2023-01-12 09:24:11 ','2023-01-12 09:24:11','',''),('5','272',1172,'','20','2',0.00,0.00,'Sales from shift 226 on 2023-01-13 09:29:01 ','2023-01-13 09:29:01','',''),('5','272',1173,'','6.1','4',0.00,0.00,'Sales from shift 226 on 2023-01-13 09:29:01 ','2023-01-13 09:29:01','',''),('5','272',1174,'','24','5',0.00,693935.00,'Purchase Id 42 for 3,751.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-13 19:09:24','',''),('5','272',1175,'','supplier','1',693935.00,0.00,'Purchase Id 42 for 3,751.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-13 19:09:24','',''),('5','272',1176,'','2','6',346956.00,0.00,'Payment Id 337 for invoice:226, receipt: 2634 by SALBAS OIL AND GAS LTD','2023-01-13 19:27:13','',''),('5','272',1177,'','supplier','1',0.00,346956.00,'Payment Id 337 for invoice:226, receipt: 2634 by SALBAS OIL AND GAS LTD','2023-01-13 19:27:13','',''),('5','272',1178,'','24','5',0.00,8297250.00,'Purchase Id 43 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-15 14:55:29','',''),('5','272',1179,'','supplier','1',8297250.00,0.00,'Purchase Id 43 for 44,850.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-15 14:55:29','',''),('5','272',1180,'','20','2',1351180.80,0.00,'Sales from shift 227 on 2023-01-15 22:50:46 ','2023-01-15 22:50:46','',''),('5','272',1181,'','6.1','4',0.00,1351180.80,'Sales from shift 227 on 2023-01-15 22:50:46 ','2023-01-15 22:50:46','',''),('5','272',1182,'','20','2',1408553.00,0.00,'Sales from shift 228 on 2023-01-16 09:33:42 ','2023-01-16 09:33:42','',''),('5','272',1183,'','6.1','4',0.00,1408553.00,'Sales from shift 228 on 2023-01-16 09:33:42 ','2023-01-16 09:33:42','',''),('5','272',1184,'','20','2',2529591.95,0.00,'Sales from shift 229 on 2023-01-16 11:03:23 ','2023-01-16 11:03:23','',''),('5','272',1185,'','6.1','4',0.00,2529591.95,'Sales from shift 229 on 2023-01-16 11:03:23 ','2023-01-16 11:03:23','',''),('5','272',1186,'','20','2',2003217.00,0.00,'Sales from shift 230 on 2023-01-17 09:40:04 ','2023-01-17 09:40:04','',''),('5','272',1187,'','6.1','4',0.00,2003217.00,'Sales from shift 230 on 2023-01-17 09:40:04 ','2023-01-17 09:40:04','',''),('5','272',1188,'','2','6',1317480.00,0.00,'Payment Id 338 for invoice:227, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:01:26','',''),('5','272',1189,'','supplier','1',0.00,1317480.00,'Payment Id 338 for invoice:227, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:01:26','',''),('5','272',1190,'','6.1','4',33700.00,0.00,'Payment Id 339 for invoice:227, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:02:55','',''),('5','272',1191,'','supplier','1',0.00,33700.00,'Payment Id 339 for invoice:227, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:02:55','',''),('5','272',1192,'','6.1','4',46900.00,0.00,'Payment Id 343 for invoice:229, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:04:34','',''),('5','272',1193,'','supplier','1',0.00,46900.00,'Payment Id 343 for invoice:229, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:04:34','',''),('5','272',1194,'','2','6',2482690.00,0.00,'Payment Id 342 for invoice:229, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:05:14','',''),('5','272',1195,'','supplier','1',0.00,2482690.00,'Payment Id 342 for invoice:229, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:05:14','',''),('5','272',1196,'','2','6',1374850.00,0.00,'Payment Id 340 for invoice:228, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:05:36','',''),('5','272',1197,'','supplier','1',0.00,1374850.00,'Payment Id 340 for invoice:228, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:05:36','',''),('5','272',1198,'','6.1','4',33700.00,0.00,'Payment Id 341 for invoice:228, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:06:13','',''),('5','272',1199,'','supplier','1',0.00,33700.00,'Payment Id 341 for invoice:228, receipt: 0482795 by SALBAS OIL AND GAS LTD','2023-01-17 12:06:13','',''),('5','272',1200,'','20','2',1048424.60,0.00,'Sales from shift 231 on 2023-01-18 09:13:05 ','2023-01-18 09:13:05','',''),('5','272',1201,'','6.1','4',0.00,1048424.60,'Sales from shift 231 on 2023-01-18 09:13:05 ','2023-01-18 09:13:05','',''),('5','272',1202,'','2','6',1598020.00,0.00,'Payment Id 344 for invoice:230, receipt: TCI0027 by SALBAS OIL AND GAS LTD','2023-01-18 12:17:54','',''),('5','272',1203,'','supplier','1',0.00,1598020.00,'Payment Id 344 for invoice:230, receipt: TCI0027 by SALBAS OIL AND GAS LTD','2023-01-18 12:17:54','',''),('5','272',1204,'','6.1','4',405200.00,0.00,'Payment Id 345 for invoice:230, receipt: TCI0027 by SALBAS OIL AND GAS LTD','2023-01-18 12:18:44','',''),('5','272',1205,'','supplier','1',0.00,405200.00,'Payment Id 345 for invoice:230, receipt: TCI0027 by SALBAS OIL AND GAS LTD','2023-01-18 12:18:44','',''),('5','272',1206,'','2','6',1011230.00,0.00,'Payment Id 346 for invoice:231, receipt: CNR0024 by SALBAS OIL AND GAS LTD','2023-01-18 12:23:43','',''),('5','272',1207,'','supplier','1',0.00,1011230.00,'Payment Id 346 for invoice:231, receipt: CNR0024 by SALBAS OIL AND GAS LTD','2023-01-18 12:23:43','',''),('5','272',1208,'','6.1','4',35200.00,0.00,'Payment Id 347 for invoice:231, receipt: CNR0024 by SALBAS OIL AND GAS LTD','2023-01-18 12:24:40','',''),('5','272',1209,'','supplier','1',0.00,35200.00,'Payment Id 347 for invoice:231, receipt: CNR0024 by SALBAS OIL AND GAS LTD','2023-01-18 12:24:40','',''),('5','272',1210,'','2','6',2000.00,0.00,'Payment Id 348 for invoice:231, receipt: 491271 by SALBAS OIL AND GAS LTD','2023-01-18 12:25:27','',''),('5','272',1211,'','supplier','1',0.00,2000.00,'Payment Id 348 for invoice:231, receipt: 491271 by SALBAS OIL AND GAS LTD','2023-01-18 12:25:27','',''),('5','272',1212,'','20','2',0.00,0.00,'Sales from shift 232 on 2023-01-19 07:22:16 ','2023-01-19 07:22:16','',''),('5','272',1213,'','6.1','4',0.00,0.00,'Sales from shift 232 on 2023-01-19 07:22:16 ','2023-01-19 07:22:16','',''),('5','272',1214,'','20','2',0.00,0.00,'Sales from shift 233 on 2023-01-20 08:55:19 ','2023-01-20 08:55:19','',''),('5','272',1215,'','6.1','4',0.00,0.00,'Sales from shift 233 on 2023-01-20 08:55:19 ','2023-01-20 08:55:19','',''),('5','272',1216,'','20','2',0.00,0.00,'Sales from shift 234 on 2023-01-21 08:19:48 ','2023-01-21 08:19:48','',''),('5','272',1217,'','6.1','4',0.00,0.00,'Sales from shift 234 on 2023-01-21 08:19:48 ','2023-01-21 08:19:48','',''),('5','272',1218,'','24','5',0.00,3344000.00,'Purchase Id 44 for 15,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-22 10:37:03','',''),('5','272',1219,'','supplier','1',3344000.00,0.00,'Purchase Id 44 for 15,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-22 10:37:03','',''),('5','272',1220,'','20','2',449209.60,0.00,'Sales from shift 235 on 2023-01-22 20:54:09 ','2023-01-22 20:54:09','',''),('5','272',1221,'','6.1','4',0.00,449209.60,'Sales from shift 235 on 2023-01-22 20:54:09 ','2023-01-22 20:54:09','',''),('5','272',1222,'','20','2',1843351.40,0.00,'Sales from shift 236 on 2023-01-23 10:12:02 ','2023-01-23 10:12:02','',''),('5','272',1223,'','6.1','4',0.00,1843351.40,'Sales from shift 236 on 2023-01-23 10:12:02 ','2023-01-23 10:12:02','',''),('5','272',1224,'','6.1','4',33700.00,0.00,'Payment Id 350 for invoice:235, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 15:58:46','',''),('5','272',1225,'','supplier','1',0.00,33700.00,'Payment Id 350 for invoice:235, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 15:58:46','',''),('5','272',1226,'','2','6',500500.00,0.00,'Payment Id 349 for invoice:235, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 15:59:01','',''),('5','272',1227,'','supplier','1',0.00,500500.00,'Payment Id 349 for invoice:235, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 15:59:01','',''),('5','272',1228,'','2','6',1808150.00,0.00,'Payment Id 351 for invoice:236, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 16:00:32','',''),('5','272',1229,'','supplier','1',0.00,1808150.00,'Payment Id 351 for invoice:236, receipt: CNR0072 by SALBAS OIL AND GAS LTD','2023-01-23 16:00:32','',''),('5','272',1230,'','6.1','4',35200.00,0.00,'Payment Id 352 for invoice:236, receipt: 0072 by SALBAS OIL AND GAS LTD','2023-01-23 16:00:51','',''),('5','272',1231,'','supplier','1',0.00,35200.00,'Payment Id 352 for invoice:236, receipt: 0072 by SALBAS OIL AND GAS LTD','2023-01-23 16:00:51','',''),('5','272',1232,'','20','2',946957.00,0.00,'Sales from shift 237 on 2023-01-24 11:27:26 ','2023-01-24 11:27:26','',''),('5','272',1233,'','6.1','4',0.00,946957.00,'Sales from shift 237 on 2023-01-24 11:27:26 ','2023-01-24 11:27:26','',''),('5','272',1234,'','24','5',0.00,6600000.00,'Purchase Id 45 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-24 13:25:50','',''),('5','272',1235,'','supplier','1',6600000.00,0.00,'Purchase Id 45 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-24 13:25:50','',''),('5','272',1236,'','20','2',1866792.40,0.00,'Sales from shift 238 on 2023-01-25 09:34:15 ','2023-01-25 09:34:15','',''),('5','272',1237,'','6.1','4',0.00,1866792.40,'Sales from shift 238 on 2023-01-25 09:34:15 ','2023-01-25 09:34:15','',''),('5','272',1238,'','2','6',911760.00,0.00,'Payment Id 353 for invoice:237, receipt: CNR0031 by SALBAS OIL AND GAS LTD','2023-01-25 09:36:13','',''),('5','272',1239,'','supplier','1',0.00,911760.00,'Payment Id 353 for invoice:237, receipt: CNR0031 by SALBAS OIL AND GAS LTD','2023-01-25 09:36:13','',''),('5','272',1240,'','6.1','4',35200.00,0.00,'Payment Id 354 for invoice:237, receipt: CNR by SALBAS OIL AND GAS LTD','2023-01-25 09:36:27','',''),('5','272',1241,'','supplier','1',0.00,35200.00,'Payment Id 354 for invoice:237, receipt: CNR by SALBAS OIL AND GAS LTD','2023-01-25 09:36:27','',''),('5','272',1242,'','20','2',1777738.60,0.00,'Sales from shift 239 on 2023-01-26 10:09:37 ','2023-01-26 10:09:37','',''),('5','272',1243,'','6.1','4',0.00,1777738.60,'Sales from shift 239 on 2023-01-26 10:09:37 ','2023-01-26 10:09:37','',''),('5','272',1244,'','2','6',1831590.00,0.00,'Payment Id 355 for invoice:238, receipt: CNR0054 by SALBAS OIL AND GAS LTD','2023-01-26 10:11:07','',''),('5','272',1245,'','supplier','1',0.00,1831590.00,'Payment Id 355 for invoice:238, receipt: CNR0054 by SALBAS OIL AND GAS LTD','2023-01-26 10:11:07','',''),('5','272',1246,'','6.1','4',35200.00,0.00,'Payment Id 356 for invoice:238, receipt: CNR0054 by SALBAS OIL AND GAS LTD','2023-01-26 10:11:33','',''),('5','272',1247,'','supplier','1',0.00,35200.00,'Payment Id 356 for invoice:238, receipt: CNR0054 by SALBAS OIL AND GAS LTD','2023-01-26 10:11:33','',''),('5','272',1248,'','20','2',1732203.00,0.00,'Sales from shift 240 on 2023-01-27 10:02:00 ','2023-01-27 10:02:00','',''),('5','272',1249,'','6.1','4',0.00,1732203.00,'Sales from shift 240 on 2023-01-27 10:02:00 ','2023-01-27 10:02:00','',''),('5','272',1250,'','2','6',35200.00,0.00,'Payment Id 358 for invoice:249, receipt: 054 by SALBAS OIL AND GAS LTD','2023-01-27 10:53:23','',''),('5','272',1251,'','supplier','1',0.00,35200.00,'Payment Id 358 for invoice:249, receipt: 054 by SALBAS OIL AND GAS LTD','2023-01-27 10:53:23','',''),('5','272',1252,'','2','6',1742540.00,0.00,'Payment Id 361 for invoice:239, receipt: CNR0050 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:20','',''),('5','272',1253,'','supplier','1',0.00,1742540.00,'Payment Id 361 for invoice:239, receipt: CNR0050 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:20','',''),('5','272',1254,'','6.1','4',35200.00,0.00,'Payment Id 360 for invoice:240, receipt: CNR0064 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:43','',''),('5','272',1255,'','supplier','1',0.00,35200.00,'Payment Id 360 for invoice:240, receipt: CNR0064 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:43','',''),('5','272',1256,'','2','6',1697000.00,0.00,'Payment Id 359 for invoice:240, receipt: CNR0064 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:54','',''),('5','272',1257,'','supplier','1',0.00,1697000.00,'Payment Id 359 for invoice:240, receipt: CNR0064 by SALBAS OIL AND GAS LTD','2023-01-27 18:57:54','',''),('5','272',1258,'','20','2',1233674.20,0.00,'Sales from shift 241 on 2023-01-28 10:05:05 ','2023-01-28 10:05:05','',''),('5','272',1259,'','6.1','4',0.00,1233674.20,'Sales from shift 241 on 2023-01-28 10:05:05 ','2023-01-28 10:05:05','',''),('5','272',1260,'','6.1','4',35200.00,0.00,'Payment Id 363 for invoice:241, receipt: 666294 by SALBAS OIL AND GAS LTD','2023-01-28 18:55:47','',''),('5','272',1261,'','supplier','1',0.00,35200.00,'Payment Id 363 for invoice:241, receipt: 666294 by SALBAS OIL AND GAS LTD','2023-01-28 18:55:47','',''),('5','272',1262,'','2','6',1198480.00,0.00,'Payment Id 362 for invoice:241, receipt: 666294 by SALBAS OIL AND GAS LTD','2023-01-28 18:56:05','',''),('5','272',1263,'','supplier','1',0.00,1198480.00,'Payment Id 362 for invoice:241, receipt: 666294 by SALBAS OIL AND GAS LTD','2023-01-28 18:56:05','',''),('5','272',1264,'','20','2',0.00,0.00,'Sales from shift 242 on 2023-01-29 10:01:06 ','2023-01-29 10:01:06','',''),('5','272',1265,'','6.1','4',0.00,0.00,'Sales from shift 242 on 2023-01-29 10:01:06 ','2023-01-29 10:01:06','',''),('5','272',1266,'','20','2',0.00,0.00,'Sales from shift 243 on 2023-01-30 09:51:44 ','2023-01-30 09:51:44','',''),('5','272',1267,'','6.1','4',0.00,0.00,'Sales from shift 243 on 2023-01-30 09:51:44 ','2023-01-30 09:51:44','',''),('5','272',1268,'','20','2',0.00,0.00,'Sales from shift 244 on 2023-01-31 08:37:25 ','2023-01-31 08:37:25','',''),('5','272',1269,'','6.1','4',0.00,0.00,'Sales from shift 244 on 2023-01-31 08:37:25 ','2023-01-31 08:37:25','',''),('5','272',1270,'','24','5',0.00,3740000.00,'Purchase Id 46 for 17,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-31 21:34:18','',''),('5','272',1271,'','supplier','1',3740000.00,0.00,'Purchase Id 46 for 17,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-01-31 21:34:18','',''),('5','272',1272,'','20','2',608355.00,0.00,'Sales from shift 245 on 2023-02-02 09:50:56 ','2023-02-02 09:50:56','',''),('5','272',1273,'','6.1','4',0.00,608355.00,'Sales from shift 245 on 2023-02-02 09:50:56 ','2023-02-02 09:50:56','',''),('5','272',1274,'','20','2',1487945.80,0.00,'Sales from shift 246 on 2023-02-02 10:01:46 ','2023-02-02 10:01:46','',''),('5','272',1275,'','6.1','4',0.00,1487945.80,'Sales from shift 246 on 2023-02-02 10:01:46 ','2023-02-02 10:01:46','',''),('5','272',1276,'','6.1','4',35200.00,0.00,'Payment Id 365 for invoice:245, receipt: 755911 by SALBAS OIL AND GAS LTD','2023-02-02 13:29:44','',''),('5','272',1277,'','supplier','1',0.00,35200.00,'Payment Id 365 for invoice:245, receipt: 755911 by SALBAS OIL AND GAS LTD','2023-02-02 13:29:44','',''),('5','272',1278,'','2','6',573155.00,0.00,'Payment Id 364 for invoice:245, receipt: 755911 by SALBAS OIL AND GAS LTD','2023-02-02 13:30:29','',''),('5','272',1279,'','supplier','1',0.00,573155.00,'Payment Id 364 for invoice:245, receipt: 755911 by SALBAS OIL AND GAS LTD','2023-02-02 13:30:29','',''),('5','272',1280,'','6.1','4',35200.00,0.00,'Payment Id 367 for invoice:246, receipt: 931915 by SALBAS OIL AND GAS LTD','2023-02-03 09:19:05','',''),('5','272',1281,'','supplier','1',0.00,35200.00,'Payment Id 367 for invoice:246, receipt: 931915 by SALBAS OIL AND GAS LTD','2023-02-03 09:19:05','',''),('5','272',1282,'','2','6',1452745.00,0.00,'Payment Id 366 for invoice:246, receipt: 931915 by SALBAS OIL AND GAS LTD','2023-02-03 09:19:22','',''),('5','272',1283,'','supplier','1',0.00,1452745.00,'Payment Id 366 for invoice:246, receipt: 931915 by SALBAS OIL AND GAS LTD','2023-02-03 09:19:22','',''),('5','272',1284,'','20','2',1654008.40,0.00,'Sales from shift 247 on 2023-02-03 11:02:49 ','2023-02-03 11:02:49','',''),('5','272',1285,'','6.1','4',0.00,1654008.40,'Sales from shift 247 on 2023-02-03 11:02:49 ','2023-02-03 11:02:49','',''),('5','272',1286,'','2','6',1618800.00,0.00,'Payment Id 368 for invoice:247, receipt: 782101 by SALBAS OIL AND GAS LTD','2023-02-03 11:44:16','',''),('5','272',1287,'','supplier','1',0.00,1618800.00,'Payment Id 368 for invoice:247, receipt: 782101 by SALBAS OIL AND GAS LTD','2023-02-03 11:44:16','',''),('5','272',1288,'','6.1','4',35200.00,0.00,'Payment Id 369 for invoice:247, receipt: 782101 by SALBAS OIL AND GAS LTD','2023-02-03 11:44:32','',''),('5','272',1289,'','supplier','1',0.00,35200.00,'Payment Id 369 for invoice:247, receipt: 782101 by SALBAS OIL AND GAS LTD','2023-02-03 11:44:32','',''),('5','272',1290,'','20','2',0.00,0.00,'Sales from shift 248 on 2023-02-04 13:00:58 ','2023-02-04 13:00:58','',''),('5','272',1291,'','6.1','4',0.00,0.00,'Sales from shift 248 on 2023-02-04 13:00:58 ','2023-02-04 13:00:58','',''),('5','272',1292,'','20','2',0.00,0.00,'Sales from shift 249 on 2023-02-05 16:22:01 ','2023-02-05 16:22:01','',''),('5','272',1293,'','6.1','4',0.00,0.00,'Sales from shift 249 on 2023-02-05 16:22:01 ','2023-02-05 16:22:01','',''),('5','272',1294,'','20','2',0.00,0.00,'Sales from shift 250 on 2023-02-06 09:18:52 ','2023-02-06 09:18:52','',''),('5','272',1295,'','6.1','4',0.00,0.00,'Sales from shift 250 on 2023-02-06 09:18:52 ','2023-02-06 09:18:52','',''),('5','272',1296,'','24','5',0.00,3300000.00,'Purchase Id 47 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-07 10:38:16','',''),('5','272',1297,'','supplier','1',3300000.00,0.00,'Purchase Id 47 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-07 10:38:16','',''),('5','272',1298,'','20','2',393969.40,0.00,'Sales from shift 251 on 2023-02-07 15:31:48 ','2023-02-07 15:31:48','',''),('5','272',1299,'','6.1','4',0.00,393969.40,'Sales from shift 251 on 2023-02-07 15:31:48 ','2023-02-07 15:31:48','',''),('5','272',1300,'','20','2',1189370.60,0.00,'Sales from shift 252 on 2023-02-08 09:37:40 ','2023-02-08 09:37:40','',''),('5','272',1301,'','6.1','4',0.00,1189370.60,'Sales from shift 252 on 2023-02-08 09:37:40 ','2023-02-08 09:37:40','',''),('5','272',1302,'','2','6',347070.00,0.00,'Payment Id 370 for invoice:251, receipt: 705010 by SALBAS OIL AND GAS LTD','2023-02-08 09:38:26','',''),('5','272',1303,'','supplier','1',0.00,347070.00,'Payment Id 370 for invoice:251, receipt: 705010 by SALBAS OIL AND GAS LTD','2023-02-08 09:38:26','',''),('5','272',1304,'','6.1','4',46900.00,0.00,'Payment Id 371 for invoice:251, receipt: 705010 by SALBAS OIL AND GAS LTD','2023-02-08 09:38:48','',''),('5','272',1305,'','supplier','1',0.00,46900.00,'Payment Id 371 for invoice:251, receipt: 705010 by SALBAS OIL AND GAS LTD','2023-02-08 09:38:48','',''),('5','272',1306,'','20','2',449143.20,0.00,'Sales from shift 253 on 2023-02-09 13:41:38 ','2023-02-09 13:41:38','',''),('5','272',1307,'','6.1','4',0.00,449143.20,'Sales from shift 253 on 2023-02-09 13:41:38 ','2023-02-09 13:41:38','',''),('5','272',1308,'','6','7',0.00,14000.00,'Being PMS Price Increase of #35*400 LTRS on 20/1/2023','2023-02-07 00:00:00','',''),('5','272',1309,'','supplier','1',14000.00,0.00,'Being PMS Price Increase of #35*400 LTRS on 20/1/2023','2023-02-07 00:00:00','',''),('5','272',1310,'','6','7',10500.00,0.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023','2023-02-07 00:00:00','',''),('5','272',1311,'','supplier','1',0.00,10500.00,'Being AGO Price Decrease of 350 LTRS On 14/01/2023','2023-02-07 00:00:00','',''),('5','272',1312,'','2','6',1154170.00,0.00,'Payment Id 372 for invoice:252, receipt: 169531 by SALBAS OIL AND GAS LTD','2023-02-09 16:45:33','',''),('5','272',1313,'','supplier','1',0.00,1154170.00,'Payment Id 372 for invoice:252, receipt: 169531 by SALBAS OIL AND GAS LTD','2023-02-09 16:45:33','',''),('5','272',1314,'','6.1','4',35200.00,0.00,'Payment Id 373 for invoice:252, receipt: 169531 by SALBAS OIL AND GAS LTD','2023-02-09 16:45:54','',''),('5','272',1315,'','supplier','1',0.00,35200.00,'Payment Id 373 for invoice:252, receipt: 169531 by SALBAS OIL AND GAS LTD','2023-02-09 16:45:54','',''),('5','272',1316,'','2','6',413945.00,0.00,'Payment Id 374 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-09 16:46:18','',''),('5','272',1317,'','supplier','1',0.00,413945.00,'Payment Id 374 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-09 16:46:18','',''),('5','272',1318,'','6.1','4',35290.00,0.00,'Payment Id 375 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-09 16:56:30','',''),('5','272',1319,'','supplier','1',0.00,35290.00,'Payment Id 375 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-09 16:56:30','',''),('5','272',1320,'','6.1','4',0.00,35290.00,'Payment Id 375 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-10 10:35:13','',''),('5','272',1321,'','supplier','1',35290.00,0.00,'Payment Id 375 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-10 10:35:13','',''),('5','272',1322,'','20','2',0.00,0.00,'Sales from shift 254 on 2023-02-11 13:10:20 ','2023-02-11 13:10:20','',''),('5','272',1323,'','6.1','4',0.00,0.00,'Sales from shift 254 on 2023-02-11 13:10:20 ','2023-02-11 13:10:20','',''),('5','272',1324,'','6.1','4',35200.00,0.00,'Payment Id 376 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-11 13:10:46','',''),('5','272',1325,'','supplier','1',0.00,35200.00,'Payment Id 376 for invoice:253, receipt: 993289 by SALBAS OIL AND GAS LTD','2023-02-11 13:10:46','',''),('5','272',1326,'','20','2',0.00,0.00,'Sales from shift 255 on 2023-02-12 12:49:48 ','2023-02-12 12:49:48','',''),('5','272',1327,'','6.1','4',0.00,0.00,'Sales from shift 255 on 2023-02-12 12:49:48 ','2023-02-12 12:49:48','',''),('5','272',1328,'','20','2',0.00,0.00,'Sales from shift 256 on 2023-02-13 09:23:05 ','2023-02-13 09:23:05','',''),('5','272',1329,'','6.1','4',0.00,0.00,'Sales from shift 256 on 2023-02-13 09:23:05 ','2023-02-13 09:23:05','',''),('5','272',1330,'','20','2',449125.60,0.00,'Sales from shift 257 on 2023-02-13 16:51:24 ','2023-02-13 16:51:24','',''),('5','272',1331,'','6.1','4',0.00,449125.60,'Sales from shift 257 on 2023-02-13 16:51:24 ','2023-02-13 16:51:24','',''),('5','272',1332,'','20','2',804874.40,0.00,'Sales from shift 258 on 2023-02-14 11:27:51 ','2023-02-14 11:27:51','',''),('5','272',1333,'','6.1','4',0.00,804874.40,'Sales from shift 258 on 2023-02-14 11:27:51 ','2023-02-14 11:27:51','',''),('5','272',1334,'','6.1','4',645000.00,0.00,'Payment Id 380 for invoice:258, receipt: 459505 by SALBAS OIL AND GAS LTD','2023-02-14 15:22:53','',''),('5','272',1335,'','supplier','1',0.00,645000.00,'Payment Id 380 for invoice:258, receipt: 459505 by SALBAS OIL AND GAS LTD','2023-02-14 15:22:53','',''),('5','272',1336,'','2','6',413945.00,0.00,'Payment Id 377 for invoice:257, receipt: 023862 by SALBAS OIL AND GAS LTD','2023-02-14 15:29:57','',''),('5','272',1337,'','supplier','1',0.00,413945.00,'Payment Id 377 for invoice:257, receipt: 023862 by SALBAS OIL AND GAS LTD','2023-02-14 15:29:57','',''),('5','272',1338,'','6.1','4',35200.00,0.00,'Payment Id 378 for invoice:257, receipt: 023862 by SALBAS OIL AND GAS LTD','2023-02-14 15:30:42','',''),('5','272',1339,'','supplier','1',0.00,35200.00,'Payment Id 378 for invoice:257, receipt: 023862 by SALBAS OIL AND GAS LTD','2023-02-14 15:30:42','',''),('5','272',1340,'','20','2',0.00,0.00,'Sales from shift 259 on 2023-02-15 13:23:00 ','2023-02-15 13:23:00','',''),('5','272',1341,'','6.1','4',0.00,0.00,'Sales from shift 259 on 2023-02-15 13:23:00 ','2023-02-15 13:23:00','',''),('5','272',1342,'','2','6',159876.00,0.00,'Payment Id 379 for invoice:258, receipt: 459505 by SALBAS OIL AND GAS LTD','2023-02-15 13:35:10','',''),('5','272',1343,'','supplier','1',0.00,159876.00,'Payment Id 379 for invoice:258, receipt: 459505 by SALBAS OIL AND GAS LTD','2023-02-15 13:35:10','',''),('5','272',1344,'','20','2',0.00,0.00,'Sales from shift 260 on 2023-02-16 09:33:07 ','2023-02-16 09:33:07','',''),('5','272',1345,'','6.1','4',0.00,0.00,'Sales from shift 260 on 2023-02-16 09:33:07 ','2023-02-16 09:33:07','',''),('5','272',1346,'','20','2',0.00,0.00,'Sales from shift 261 on 2023-02-17 09:19:57 ','2023-02-17 09:19:57','',''),('5','272',1347,'','6.1','4',0.00,0.00,'Sales from shift 261 on 2023-02-17 09:19:57 ','2023-02-17 09:19:57','',''),('5','272',1348,'','2','6',124500.00,0.00,'Payment Id 381 for invoice:258, receipt: 040106 by SALBAS OIL AND GAS LTD','2023-02-17 09:22:19','',''),('5','272',1349,'','supplier','1',0.00,124500.00,'Payment Id 381 for invoice:258, receipt: 040106 by SALBAS OIL AND GAS LTD','2023-02-17 09:22:19','',''),('5','272',1350,'','20','2',0.00,0.00,'Sales from shift 262 on 2023-02-18 21:00:32 ','2023-02-18 21:00:32','',''),('5','272',1351,'','6.1','4',0.00,0.00,'Sales from shift 262 on 2023-02-18 21:00:32 ','2023-02-18 21:00:32','',''),('5','272',1352,'','20','2',0.00,0.00,'Sales from shift 263 on 2023-02-19 19:21:50 ','2023-02-19 19:21:50','',''),('5','272',1353,'','6.1','4',0.00,0.00,'Sales from shift 263 on 2023-02-19 19:21:50 ','2023-02-19 19:21:50','',''),('5','272',1354,'','20','2',0.00,0.00,'Sales from shift 264 on 2023-02-20 09:30:06 ','2023-02-20 09:30:06','',''),('5','272',1355,'','6.1','4',0.00,0.00,'Sales from shift 264 on 2023-02-20 09:30:06 ','2023-02-20 09:30:06','',''),('5','272',1356,'','20','2',0.00,0.00,'Sales from shift 265 on 2023-02-21 09:31:20 ','2023-02-21 09:31:20','',''),('5','272',1357,'','6.1','4',0.00,0.00,'Sales from shift 265 on 2023-02-21 09:31:20 ','2023-02-21 09:31:20','',''),('5','272',1358,'','20','2',0.00,0.00,'Sales from shift 266 on 2023-02-22 10:30:08 ','2023-02-22 10:30:08','',''),('5','272',1359,'','6.1','4',0.00,0.00,'Sales from shift 266 on 2023-02-22 10:30:08 ','2023-02-22 10:30:08','',''),('5','272',1360,'','24','5',0.00,6300000.00,'Purchase Id 48 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-25 09:27:02','',''),('5','272',1361,'','supplier','1',6300000.00,0.00,'Purchase Id 48 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-25 09:27:02','',''),('5','272',1362,'','20','2',2793153.30,0.00,'Sales from shift 267 on 2023-02-25 21:21:05 ','2023-02-25 21:21:05','',''),('5','272',1363,'','6.1','4',0.00,2793153.30,'Sales from shift 267 on 2023-02-25 21:21:05 ','2023-02-25 21:21:05','',''),('5','272',1364,'','20','2',3160382.40,0.00,'Sales from shift 268 on 2023-02-26 10:00:51 ','2023-02-26 10:00:51','',''),('5','272',1365,'','6.1','4',0.00,3160382.40,'Sales from shift 268 on 2023-02-26 10:00:51 ','2023-02-26 10:00:51','',''),('5','272',1366,'','20','2',0.00,0.00,'Sales from shift 269 on 2023-02-27 08:39:38 ','2023-02-27 08:39:38','',''),('5','272',1367,'','6.1','4',0.00,0.00,'Sales from shift 269 on 2023-02-27 08:39:38 ','2023-02-27 08:39:38','',''),('5','272',1368,'','24','5',0.00,9439500.00,'Purchase Id 49 for 44,950.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-27 08:40:18','',''),('5','272',1369,'','supplier','1',9439500.00,0.00,'Purchase Id 49 for 44,950.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-02-27 08:40:18','',''),('5','272',1370,'','20','2',3425251.20,0.00,'Sales from shift 270 on 2023-02-28 09:22:46 ','2023-02-28 09:22:46','',''),('5','272',1371,'','6.1','4',0.00,3425251.20,'Sales from shift 270 on 2023-02-28 09:22:46 ','2023-02-28 09:22:46','',''),('5','272',1372,'','20','2',2652734.70,0.00,'Sales from shift 271 on 2023-02-28 14:11:04 ','2023-02-28 14:11:04','',''),('5','272',1373,'','6.1','4',0.00,2652734.70,'Sales from shift 271 on 2023-02-28 14:11:04 ','2023-02-28 14:11:04','',''),('5','272',1374,'','24','5',0.00,8211000.00,'Purchase Id 50 for 39,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-03-01 09:01:53','',''),('5','272',1375,'','supplier','1',8211000.00,0.00,'Purchase Id 50 for 39,100.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-03-01 09:01:53','',''),('5','272',1376,'','2','6',2368855.00,0.00,'Payment Id 382 for invoice:267, receipt: 327455 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:24','',''),('5','272',1377,'','supplier','1',0.00,2368855.00,'Payment Id 382 for invoice:267, receipt: 327455 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:24','',''),('5','272',1378,'','6.1','4',424300.00,0.00,'Payment Id 383 for invoice:267, receipt: 327455 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:40','',''),('5','272',1379,'','supplier','1',0.00,424300.00,'Payment Id 383 for invoice:267, receipt: 327455 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:40','',''),('5','272',1380,'','2','6',3117080.00,0.00,'Payment Id 384 for invoice:268, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:51','',''),('5','272',1381,'','supplier','1',0.00,3117080.00,'Payment Id 384 for invoice:268, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:15:51','',''),('5','272',1382,'','6.1','4',43300.00,0.00,'Payment Id 385 for invoice:268, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:02','',''),('5','272',1383,'','supplier','1',0.00,43300.00,'Payment Id 385 for invoice:268, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:02','',''),('5','272',1384,'','2','6',3391130.00,0.00,'Payment Id 386 for invoice:270, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:19','',''),('5','272',1385,'','supplier','1',0.00,3391130.00,'Payment Id 386 for invoice:270, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:19','',''),('5','272',1386,'','6.1','4',34300.00,0.00,'Payment Id 387 for invoice:270, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:38','',''),('5','272',1387,'','supplier','1',0.00,34300.00,'Payment Id 387 for invoice:270, receipt: 491 by SALBAS OIL AND GAS LTD','2023-03-01 09:16:38','',''),('5','272',1388,'','2','6',2618435.00,0.00,'Payment Id 388 for invoice:271, receipt: 168589 by SALBAS OIL AND GAS LTD','2023-03-01 09:17:00','',''),('5','272',1389,'','supplier','1',0.00,2618435.00,'Payment Id 388 for invoice:271, receipt: 168589 by SALBAS OIL AND GAS LTD','2023-03-01 09:17:00','',''),('5','272',1390,'','20','2',3452979.60,0.00,'Sales from shift 272 on 2023-03-02 08:54:23 ','2023-03-02 08:54:23','',''),('5','272',1391,'','6.1','4',0.00,3452979.60,'Sales from shift 272 on 2023-03-02 08:54:23 ','2023-03-02 08:54:23','',''),('5','272',1392,'','6.1','4',34300.00,0.00,'Payment Id 389 for invoice:271, receipt: 168589 by SALBAS OIL AND GAS LTD','2023-03-02 11:30:51','',''),('5','272',1393,'','supplier','1',0.00,34300.00,'Payment Id 389 for invoice:271, receipt: 168589 by SALBAS OIL AND GAS LTD','2023-03-02 11:30:51','',''),('5','272',1394,'','20','2',1669245.90,0.00,'Sales from shift 273 on 2023-03-03 11:32:46 ','2023-03-03 11:32:46','',''),('5','272',1395,'','6.1','4',0.00,1669245.90,'Sales from shift 273 on 2023-03-03 11:32:46 ','2023-03-03 11:32:46','',''),('5','272',1396,'','2','6',3418425.00,0.00,'Payment Id 390 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 11:39:38','',''),('5','272',1397,'','supplier','1',0.00,3418425.00,'Payment Id 390 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 11:39:38','',''),('5','272',1398,'','6.1','4',34300.00,0.00,'Payment Id 391 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 11:39:57','',''),('5','272',1399,'','supplier','1',0.00,34300.00,'Payment Id 391 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 11:39:57','',''),('5','272',1400,'','6.1','4',34300.00,0.00,'Payment Id 393 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 11:40:17','',''),('5','272',1401,'','supplier','1',0.00,34300.00,'Payment Id 393 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 11:40:17','',''),('5','272',1402,'','2','6',1636295.00,0.00,'Payment Id 392 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 11:56:19','',''),('5','272',1403,'','supplier','1',0.00,1636295.00,'Payment Id 392 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 11:56:19','',''),('5','272',1404,'','2','6',0.00,1636295.00,'Payment Id 392 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 12:00:45','',''),('5','272',1405,'','supplier','1',1636295.00,0.00,'Payment Id 392 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 12:00:45','',''),('5','272',1406,'','2','6',1634945.00,0.00,'Payment Id 395 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 12:01:03','',''),('5','272',1407,'','supplier','1',0.00,1634945.00,'Payment Id 395 for invoice:273, receipt: 229949 by SALBAS OIL AND GAS LTD','2023-03-03 12:01:03','',''),('5','272',1408,'','2','6',0.00,3418425.00,'Payment Id 390 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 12:03:10','',''),('5','272',1409,'','supplier','1',3418425.00,0.00,'Payment Id 390 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 12:03:10','',''),('5','272',1410,'','2','6',3418680.00,0.00,'Payment Id 394 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 12:03:21','',''),('5','272',1411,'','supplier','1',0.00,3418680.00,'Payment Id 394 for invoice:272, receipt: 735425 by SALBAS OIL AND GAS LTD','2023-03-03 12:03:21','',''),('5','272',1412,'','20','2',2428068.30,0.00,'Sales from shift 274 on 2023-03-03 14:16:11 ','2023-03-03 14:16:11','',''),('5','272',1413,'','6.1','4',0.00,2428068.30,'Sales from shift 274 on 2023-03-03 14:16:11 ','2023-03-03 14:16:11','',''),('5','272',1414,'','20','2',1516315.50,0.00,'Sales from shift 275 on 2023-03-05 08:31:13 ','2023-03-05 08:31:13','',''),('5','272',1415,'','6.1','4',0.00,1516315.50,'Sales from shift 275 on 2023-03-05 08:31:13 ','2023-03-05 08:31:13','',''),('5','272',1416,'','20','2',1722294.00,0.00,'Sales from shift 276 on 2023-03-05 18:23:59 ','2023-03-05 18:23:59','',''),('5','272',1417,'','6.1','4',0.00,1722294.00,'Sales from shift 276 on 2023-03-05 18:23:59 ','2023-03-05 18:23:59','',''),('5','272',1418,'','20','2',680127.00,0.00,'Sales from shift 277 on 2023-03-06 08:50:18 ','2023-03-06 08:50:18','',''),('5','272',1419,'','6.1','4',0.00,680127.00,'Sales from shift 277 on 2023-03-06 08:50:18 ','2023-03-06 08:50:18','',''),('5','272',1420,'','6.1','4',34300.00,0.00,'Payment Id 403 for invoice:277, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:19:47','',''),('5','272',1421,'','supplier','1',0.00,34300.00,'Payment Id 403 for invoice:277, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:19:47','',''),('5','272',1422,'','2','6',645830.00,0.00,'Payment Id 402 for invoice:277, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:19','',''),('5','272',1423,'','supplier','1',0.00,645830.00,'Payment Id 402 for invoice:277, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:19','',''),('5','272',1424,'','6.1','4',32800.00,0.00,'Payment Id 401 for invoice:276, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:37','',''),('5','272',1425,'','supplier','1',0.00,32800.00,'Payment Id 401 for invoice:276, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:37','',''),('5','272',1426,'','2','6',1689495.00,0.00,'Payment Id 400 for invoice:276, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:50','',''),('5','272',1427,'','supplier','1',0.00,1689495.00,'Payment Id 400 for invoice:276, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:20:50','',''),('5','272',1428,'','6.1','4',81500.00,0.00,'Payment Id 399 for invoice:275, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:16','',''),('5','272',1429,'','supplier','1',0.00,81500.00,'Payment Id 399 for invoice:275, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:16','',''),('5','272',1430,'','2','6',1434815.00,0.00,'Payment Id 398 for invoice:275, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:27','',''),('5','272',1431,'','supplier','1',0.00,1434815.00,'Payment Id 398 for invoice:275, receipt: 376210 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:27','',''),('5','272',1432,'','6.1','4',46000.00,0.00,'Payment Id 397 for invoice:274, receipt: 111980 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:40','',''),('5','272',1433,'','supplier','1',0.00,46000.00,'Payment Id 397 for invoice:274, receipt: 111980 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:40','',''),('5','272',1434,'','2','6',2382070.00,0.00,'Payment Id 396 for invoice:274, receipt: 111980 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:52','',''),('5','272',1435,'','supplier','1',0.00,2382070.00,'Payment Id 396 for invoice:274, receipt: 111980 by SALBAS OIL AND GAS LTD','2023-03-06 13:21:52','',''),('5','272',1436,'','20','2',333324.60,0.00,'Sales from shift 278 on 2023-03-07 09:16:18 ','2023-03-07 09:16:18','',''),('5','272',1437,'','6.1','4',0.00,333324.60,'Sales from shift 278 on 2023-03-07 09:16:18 ','2023-03-07 09:16:18','',''),('5','272',1438,'','24','5',0.00,8400000.00,'Purchase Id 51 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-03-07 09:17:28','',''),('5','272',1439,'','supplier','1',8400000.00,0.00,'Purchase Id 51 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS LTD','2023-03-07 09:17:28','',''),('5','272',1440,'','2','6',299025.00,0.00,'Payment Id 404 for invoice:278, receipt: 651883 by SALBAS OIL AND GAS LTD','2023-03-07 09:24:40','',''),('5','272',1441,'','supplier','1',0.00,299025.00,'Payment Id 404 for invoice:278, receipt: 651883 by SALBAS OIL AND GAS LTD','2023-03-07 09:24:40','',''),('5','272',1442,'','6.1','4',34300.00,0.00,'Payment Id 405 for invoice:278, receipt: 651883 by SALBAS OIL AND GAS LTD','2023-03-07 09:25:13','',''),('5','272',1443,'','supplier','1',0.00,34300.00,'Payment Id 405 for invoice:278, receipt: 651883 by SALBAS OIL AND GAS LTD','2023-03-07 09:25:13','',''),('5','272',1444,'','20','2',2095226.70,0.00,'Sales from shift 279 on 2023-03-08 14:05:25 ','2023-03-08 14:05:25','',''),('5','272',1445,'','6.1','4',0.00,2095226.70,'Sales from shift 279 on 2023-03-08 14:05:25 ','2023-03-08 14:05:25','',''),('5','272',1446,'','2','6',2060950.00,0.00,'Payment Id 406 for invoice:278, receipt: 958652 by SALBAS OIL AND GAS LTD','2023-03-08 14:11:04','',''),('5','272',1447,'','supplier','1',0.00,2060950.00,'Payment Id 406 for invoice:278, receipt: 958652 by SALBAS OIL AND GAS LTD','2023-03-08 14:11:04','',''),('5','272',1448,'','6.1','4',34300.00,0.00,'Payment Id 407 for invoice:279, receipt: 598652 by SALBAS OIL AND GAS LTD','2023-03-08 14:11:16','',''),('5','272',1449,'','supplier','1',0.00,34300.00,'Payment Id 407 for invoice:279, receipt: 598652 by SALBAS OIL AND GAS LTD','2023-03-08 14:11:16','',''),('5','272',1450,'','20','2',2228763.60,0.00,'Sales from shift 280 on 2023-03-10 09:50:06 ','2023-03-10 09:50:06','',''),('5','272',1451,'','6.1','4',0.00,2228763.60,'Sales from shift 280 on 2023-03-10 09:50:06 ','2023-03-10 09:50:06','',''),('5','272',1452,'','20','2',1733455.50,0.00,'Sales from shift 281 on 2023-03-10 11:30:05 ','2023-03-10 11:30:05','',''),('5','272',1453,'','6.1','4',0.00,1733455.50,'Sales from shift 281 on 2023-03-10 11:30:05 ','2023-03-10 11:30:05','',''),('5','272',1454,'','6.1','4',146500.00,0.00,'Payment Id 412 for invoice:258, receipt: 1234 by SALBAS OIL AND GAS LTD','2023-03-10 11:47:32','',''),('5','272',1455,'','supplier','1',0.00,146500.00,'Payment Id 412 for invoice:258, receipt: 1234 by SALBAS OIL AND GAS LTD','2023-03-10 11:47:32','',''),('5','272',1456,'','6.1','4',41000.00,0.00,'Payment Id 413 for invoice:259, receipt: 1234 by SALBAS OIL AND GAS LTD','2023-03-10 11:48:29','',''),('5','272',1457,'','supplier','1',0.00,41000.00,'Payment Id 413 for invoice:259, receipt: 1234 by SALBAS OIL AND GAS LTD','2023-03-10 11:48:29','',''),('5','272',1458,'','6.1','4',34300.00,0.00,'Payment Id 411 for invoice:281, receipt: 918617 by SALBAS OIL AND GAS LTD','2023-03-10 11:48:53','',''),('5','272',1459,'','supplier','1',0.00,34300.00,'Payment Id 411 for invoice:281, receipt: 918617 by SALBAS OIL AND GAS LTD','2023-03-10 11:48:53','',''),('5','272',1460,'','2','6',1699155.00,0.00,'Payment Id 410 for invoice:281, receipt: 918617 by SALBAS OIL AND GAS LTD','2023-03-10 11:51:29','',''),('5','272',1461,'','supplier','1',0.00,1699155.00,'Payment Id 410 for invoice:281, receipt: 918617 by SALBAS OIL AND GAS LTD','2023-03-10 11:51:29','',''),('5','272',1462,'','6.1','4',34300.00,0.00,'Payment Id 409 for invoice:280, receipt: 239875 by SALBAS OIL AND GAS LTD','2023-03-10 12:16:04','',''),('5','272',1463,'','supplier','1',0.00,34300.00,'Payment Id 409 for invoice:280, receipt: 239875 by SALBAS OIL AND GAS LTD','2023-03-10 12:16:04','',''),('5','272',1464,'','20','2',2197085.10,0.00,'Sales from shift 282 on 2023-03-13 09:29:17 ','2023-03-13 09:29:17','',''),('5','272',1465,'','6.1','4',0.00,2197085.10,'Sales from shift 282 on 2023-03-13 09:29:17 ','2023-03-13 09:29:17','',''),('5','272',1466,'','2','6',2194445.00,0.00,'Payment Id 414 for invoice:280, receipt: 239875 by SALBAS OIL AND GAS LTD','2023-03-13 09:41:16','',''),('5','272',1467,'','supplier','1',0.00,2194445.00,'Payment Id 414 for invoice:280, receipt: 239875 by SALBAS OIL AND GAS LTD','2023-03-13 09:41:16','',''),('5','272',1468,'','6.1','4',44800.00,0.00,'Payment Id 416 for invoice:282, receipt: 419718 by SALBAS OIL AND GAS LTD','2023-03-13 13:39:46','',''),('5','272',1469,'','supplier','1',0.00,44800.00,'Payment Id 416 for invoice:282, receipt: 419718 by SALBAS OIL AND GAS LTD','2023-03-13 13:39:46','',''),('5','272',1470,'','2','6',2160240.00,0.00,'Payment Id 415 for invoice:282, receipt: 419718 by SALBAS OIL AND GAS LTD','2023-03-13 13:39:58','',''),('5','272',1471,'','supplier','1',0.00,2160240.00,'Payment Id 415 for invoice:282, receipt: 419718 by SALBAS OIL AND GAS LTD','2023-03-13 13:39:58','',''),('5','272',1472,'','20','2',0.00,0.00,'Sales from shift 283 on 2023-03-14 11:43:39 ','2023-03-14 11:43:39','',''),('5','272',1473,'','6.1','4',0.00,0.00,'Sales from shift 283 on 2023-03-14 11:43:39 ','2023-03-14 11:43:39','',''),('5','272',1474,'','20','2',0.00,0.00,'Sales from shift 284 on 2023-03-15 11:02:59 ','2023-03-15 11:02:59','',''),('5','272',1475,'','6.1','4',0.00,0.00,'Sales from shift 284 on 2023-03-15 11:02:59 ','2023-03-15 11:02:59','',''),('5','272',1476,'','20','2',0.00,0.00,'Sales from shift 285 on 2023-03-16 16:39:38 ','2023-03-16 16:39:38','',''),('5','272',1477,'','6.1','4',0.00,0.00,'Sales from shift 285 on 2023-03-16 16:39:38 ','2023-03-16 16:39:38','',''),('5','272',1478,'','20','2',0.00,0.00,'Sales from shift 286 on 2023-03-19 21:25:24 ','2023-03-19 21:25:24','',''),('5','272',1479,'','6.1','4',0.00,0.00,'Sales from shift 286 on 2023-03-19 21:25:24 ','2023-03-19 21:25:24','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'5','272','PMS','Petrol','Litres',0,210.00,210.00,210.00,210.00,0.00,0,'2022-06-02 10:34:11','446','446','2022-06-02 10:34:11',0),(2,'5','272','AGO','Diesel','Litres',0,830.00,830.00,830.00,830.00,0.00,0,'2022-06-02 10:35:36','446','877','2022-06-23 23:46:25',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'5','272',1,165.00,165.00,165.00,165.00,'','2022-06-02 11:14:55','600'),(2,'5','272',2,700.00,700.00,700.00,700.00,'','2022-06-02 11:15:52','600'),(3,'5','272',2,800.00,800.00,800.00,800.00,'','2022-06-23 23:45:58','877'),(4,'5','272',2,820.00,820.00,820.00,820.00,'','2022-06-26 22:53:50','877'),(5,'5','272',1,185.00,185.00,185.00,185.00,'','2022-07-11 08:25:11','877'),(6,'5','272',1,870.00,870.00,870.00,870.00,'PMS Price Change','2022-11-30 07:23:14','877'),(7,'5','272',1,185.00,185.00,185.00,185.00,'PMS Price Change','2022-11-30 07:24:50','877'),(8,'5','272',1,870.00,870.00,870.00,870.00,'AGO Price Change','2022-11-30 07:25:28','877'),(9,'5','272',1,185.00,185.00,185.00,185.00,'PMS Price Change','2022-11-30 07:26:53','877'),(10,'5','272',2,870.00,870.00,870.00,870.00,'AGO Price Change','2022-11-30 07:28:21','877'),(11,'5','272',2,830.00,830.00,830.00,830.00,'AGO Pump Price  Change ','2023-01-18 13:52:22','877'),(12,'5','272',1,220.00,220.00,220.00,220.00,'PMS Pump  Prince  Change ','2023-01-21 22:04:19','877'),(13,'5','272',1,210.00,210.00,210.00,210.00,'PMS Pump  Prince  Change ','2023-02-25 06:29:56','877');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (2,'5','272','2022-06-01',1,1,165.00,27150.00,0.00,0.00,4479750.00,0.00,'','1417','BCH 743XA','','','','2022-06-02 11:55:11',15,'','600','','0000-00-00 00:00:00','600','2022-06-02 11:55:30'),(3,'5','272','2022-06-04',1,1,165.00,15200.00,0.00,0.00,2508000.00,0.00,'','2249','LSD 736 XY','','','','2022-06-04 15:16:51',15,'','877','','0000-00-00 00:00:00','664','2022-06-04 15:25:13'),(4,'5','272','2022-06-06',1,1,165.00,44500.00,0.00,0.00,7342500.00,0.00,'','2250','KMC 37 XX','','','','2022-06-06 19:02:09',15,'','877','','0000-00-00 00:00:00','664','2022-06-06 22:31:00'),(5,'5','272','2022-07-07',1,1,165.00,22500.00,0.00,0.00,3712500.00,0.00,'','1709','BCH 732 XA','','','','2022-07-07 19:26:34',15,'','877','','0000-00-00 00:00:00','664','2022-07-07 19:45:59'),(6,'5','272','2022-07-14',1,1,185.00,40000.00,0.00,0.00,7400000.00,0.00,'','1712','TRN 176 ZG','','','','2022-07-14 21:16:57',15,'','877','','0000-00-00 00:00:00','664','2022-07-14 21:29:17'),(7,'5','272','2022-07-19',1,1,185.00,59900.00,0.00,0.00,11081500.00,0.00,'','1715','LSD 602 XY','','','','2022-07-20 10:44:29',15,'','877','','0000-00-00 00:00:00','664','2022-07-20 11:32:36'),(8,'5','272','2022-07-23',1,1,185.00,40100.00,0.00,0.00,7418500.00,0.00,'','1715','RAN 551 XA','','','','2022-07-23 20:06:18',15,'','877','','0000-00-00 00:00:00','664','2022-07-23 20:46:08'),(9,'5','272','2022-08-01',1,1,185.00,39900.00,0.00,0.00,7381500.00,0.00,'','1716','KMC 140 YJ','','','','2022-08-01 21:06:59',15,'','877','','0000-00-00 00:00:00','664','2022-08-01 21:18:23'),(10,'5','272','2022-08-04',1,1,185.00,44400.00,0.00,0.00,8214000.00,0.00,'','1718','KMC 38 XX ','','','','2022-08-04 17:07:16',15,'','877','','0000-00-00 00:00:00','664','2022-08-04 17:11:42'),(11,'5','272','2022-08-09',1,1,185.00,32730.00,0.00,0.00,6055050.00,0.00,'','1719','RBC 92 XC','','','','2022-09-06 12:08:16',15,'','877','','0000-00-00 00:00:00','664','2022-09-06 12:10:08'),(12,'5','272','2022-08-13',1,1,185.00,44300.00,0.00,0.00,8195500.00,0.00,'','1720','MKA 795 ZU','','','','2022-09-06 12:47:25',15,'','877','','0000-00-00 00:00:00','664','2022-09-06 13:05:15'),(13,'5','272','2022-08-15',1,1,185.00,39550.00,0.00,0.00,7316750.00,0.00,'','1722','GWL 66 YS','','','','2022-09-06 14:07:25',15,'','877','','0000-00-00 00:00:00','664','2022-09-06 14:10:15'),(16,'5','272','2022-08-19',1,1,185.00,60000.00,0.00,0.00,11100000.00,0.00,'','1725','LSD 763 XG','','','','2022-09-06 15:13:41',15,'','877','','0000-00-00 00:00:00','664','2022-09-06 15:21:57'),(17,'5','272','2022-08-25',1,1,185.00,49602.00,0.00,0.00,9176370.00,0.00,'','1723','RBC 897 XC','','','','2022-09-08 12:45:22',15,'','877','','0000-00-00 00:00:00','664','2022-09-08 12:46:35'),(18,'5','272','2022-08-28',1,1,185.00,39550.00,0.00,0.00,7316750.00,0.00,'','1726','RAN 552 XA','','','','2022-09-08 14:03:56',15,'','877','','0000-00-00 00:00:00','664','2022-09-08 14:09:24'),(19,'5','272','2022-09-03',1,1,185.00,44400.00,0.00,0.00,8214000.00,0.00,'','1729','KMC 35 XX','','','','2022-09-08 16:24:22',15,'','877','','0000-00-00 00:00:00','664','2022-09-08 16:28:23'),(20,'5','272','2022-09-06',1,1,185.00,44450.00,0.00,0.00,8223250.00,0.00,'','1730','KMC 144 YT','','','','2022-09-08 16:48:58',15,'','877','','0000-00-00 00:00:00','664','2022-09-08 16:54:11'),(21,'5','272','2022-09-13',1,1,185.00,40100.00,0.00,0.00,7418500.00,0.00,'','1731','RAN 551 XA','','','','2022-09-26 14:40:44',15,'','877','','0000-00-00 00:00:00','664','2022-09-26 14:47:36'),(22,'5','272','2022-09-16',1,1,185.00,39750.00,0.00,0.00,7353750.00,0.00,'','1734','NSR 34 ZU','','','','2022-09-26 15:49:00',15,'','877','','0000-00-00 00:00:00','664','2022-09-26 15:50:10'),(23,'5','272','2022-09-20',1,1,185.00,44610.00,0.00,0.00,8252850.00,0.00,'','1735','RBC 996 XC','','','','2022-09-26 16:25:21',10,'','877','','0000-00-00 00:00:00','664','2022-09-26 16:27:17'),(24,'5','272','2022-09-23',1,1,185.00,40000.00,0.00,0.00,7400000.00,0.00,'','1739','RAN 663 XA','','','','2022-09-26 16:55:52',15,'','877','','0000-00-00 00:00:00','664','2022-09-26 17:00:31'),(25,'5','272','2022-09-28',1,1,185.00,44800.00,0.00,0.00,8288000.00,0.00,'','1737','KMC 138 YT','','','','2022-09-28 21:03:28',15,'','877','','0000-00-00 00:00:00','664','2022-09-28 21:07:32'),(26,'5','272','2022-10-01',1,1,185.00,26650.00,0.00,0.00,4930250.00,0.00,'','1742','RAN 551 XA','','','','2022-10-01 20:20:21',15,'','877','','0000-00-00 00:00:00','664','2022-10-01 21:23:14'),(27,'5','272','2022-09-30',1,1,185.00,39900.00,0.00,0.00,7381500.00,0.00,'','1742','RAN 551 XA','','','','2022-10-03 15:30:56',2,'','877','','0000-00-00 00:00:00','600','2022-10-04 11:20:18'),(28,'5','272','2022-10-03',1,1,185.00,13250.00,0.00,0.00,2451250.00,0.00,'','1742','RAN 551 XA','','','','2022-10-04 12:43:06',15,'','877','','0000-00-00 00:00:00','664','2022-10-04 12:45:07'),(29,'5','272','2022-10-10',1,1,185.00,50000.00,0.00,0.00,9250000.00,0.00,'','2003','BCH 733 XA','','','','2022-10-12 14:29:10',15,'','877','','0000-00-00 00:00:00','664','2022-10-12 14:37:13'),(30,'5','272','2022-10-14',1,1,185.00,49900.00,0.00,0.00,9231500.00,0.00,'','2016','RBC 352 XG','','','','2022-10-15 21:20:22',15,'','877','','0000-00-00 00:00:00','664','2022-10-15 21:28:06'),(31,'5','272','2022-10-17',1,1,185.00,59910.00,0.00,0.00,11083350.00,0.00,'','2025','LSD 769 XY','','','','2022-10-19 11:13:01',15,'','877','','0000-00-00 00:00:00','664','2022-10-19 11:14:34'),(32,'5','272','2022-10-28',1,1,185.00,44870.00,0.00,0.00,8300950.00,0.00,'','2036','RBC 996 XC','','','','2022-10-29 21:18:55',15,'','877','','0000-00-00 00:00:00','664','2022-10-29 21:47:54'),(33,'5','272','2022-11-08',1,1,185.00,45000.00,0.00,0.00,8325000.00,0.00,'','1676','BHC 739 XA','','','','2022-11-13 22:04:24',15,'','877','','0000-00-00 00:00:00','664','2022-11-13 22:05:47'),(34,'5','272','2022-11-20',1,1,185.00,14000.00,0.00,0.00,2590000.00,0.00,'','1689','KMC 136 YT','','','','2022-11-21 13:46:49',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-11-21 14:09:49'),(35,'5','272','2022-11-22',1,1,185.00,39870.00,0.00,0.00,7375950.00,0.00,'','1687','NSR 219 ZQ','','','','2022-11-23 14:43:45',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-11-23 14:46:36'),(36,'5','272','2022-11-24',1,1,185.00,44650.00,0.00,0.00,8260250.00,0.00,'','2350','BCH 742 XA','','','','2022-11-24 20:05:30',15,'PMS Supply','877','','0000-00-00 00:00:00','600','2022-11-24 20:57:41'),(37,'5','272','2022-11-26',1,1,185.00,39800.00,0.00,0.00,7363000.00,0.00,'','2361','KMC 140 YT','','','','2022-11-27 20:33:17',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-11-27 21:29:09'),(38,'5','272','2022-11-29',1,1,185.00,45000.00,0.00,0.00,8325000.00,0.00,'','2363','BCH 732 XA','','','','2022-11-29 18:04:41',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-11-29 19:17:12'),(39,'5','272','2022-12-01',1,1,185.00,39900.00,0.00,0.00,7381500.00,0.00,'','2377','NSR 220 ZQ','','','','2022-12-01 21:28:48',10,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-12-01 22:30:45'),(40,'5','272','2022-12-03',1,1,185.00,45000.00,0.00,0.00,8325000.00,0.00,'','2382','RBC 604 XF','','','','2022-12-03 19:42:16',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-12-03 20:24:30'),(41,'5','272','2022-12-05',1,1,185.00,15000.00,0.00,0.00,2775000.00,0.00,'','2383','RBC 593 XF','','','','2022-12-06 06:49:25',15,'PMS Supply','877','','0000-00-00 00:00:00','664','2022-12-06 07:58:05'),(42,'5','272','2022-12-05',1,1,185.00,3751.00,0.00,0.00,693935.00,0.00,'','2288','BCH 743 XA','','','','2023-01-13 19:06:57',5,'','606','','0000-00-00 00:00:00','606','2023-01-13 19:09:24'),(43,'5','272','2023-01-13',1,1,185.00,44850.00,0.00,0.00,8297250.00,0.00,'','1252','LSD 178 XM','','','','2023-01-15 01:22:25',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-01-15 14:55:29'),(44,'5','272','2023-01-21',1,1,220.00,15200.00,0.00,0.00,3344000.00,0.00,'','2385','RSH 420 XE','','','','2023-01-21 22:05:48',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-01-22 10:37:03'),(45,'5','272','2023-01-23',1,1,220.00,30000.00,0.00,0.00,6600000.00,0.00,'','1254','RBC 988 XC','','','','2023-01-24 01:32:15',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-01-24 13:25:50'),(46,'5','272','2023-01-31',1,1,220.00,17000.00,0.00,0.00,3740000.00,0.00,'','2385','RSH278 XF','','','','2023-01-31 21:24:33',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-01-31 21:34:18'),(47,'5','272','2023-02-06',1,1,220.00,15000.00,0.00,0.00,3300000.00,0.00,'','1256','KMC 63 YS','','','','2023-02-06 23:01:31',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-02-07 10:38:16'),(48,'5','272','2023-02-23',1,1,210.00,30000.00,0.00,0.00,6300000.00,0.00,'','1253','LSD 602 XE','','','','2023-02-25 06:31:31',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-02-25 09:27:02'),(49,'5','272','2023-02-24',1,1,210.00,44950.00,0.00,0.00,9439500.00,0.00,'','1261','RSH 422 XE','','','','2023-02-27 07:24:58',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-02-27 08:40:18'),(50,'5','272','2023-02-28',1,1,210.00,39100.00,0.00,0.00,8211000.00,0.00,'','1262','KMC 34 XX','','','','2023-02-28 23:42:06',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-03-01 09:01:53'),(51,'5','272','2023-03-06',1,1,210.00,40000.00,0.00,0.00,8400000.00,0.00,'','1263','TRN 182 ZG','','','','2023-03-07 07:22:35',15,'PMS Supply ','877','','0000-00-00 00:00:00','1013','2023-03-07 09:17:28');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=417 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (3,'5','272','2022-06-01',1,'001','','5',793765.00,'1','','','6','kd1','0050',821511.90,'2022-06-02 21:22:29',5,'','877','','0000-00-00 00:00:00','664','2022-06-02 21:29:38'),(4,'5','272','2022-06-01',1,'001','','2',27750.00,'1','','','','','',821511.90,'2022-06-02 21:23:32',5,'','877','','0000-00-00 00:00:00','664','2022-06-02 21:29:24'),(5,'5','272','2022-06-02',1,'','','5',967000.00,'2','','','6','kd1','0050',994747.05,'2022-06-03 15:21:14',5,'','877','','0000-00-00 00:00:00','664','2022-06-03 19:03:35'),(6,'5','272','2022-06-02',1,'002','','2',27750.00,'2','','','','','',994747.05,'2022-06-03 15:22:26',2,'','877','','0000-00-00 00:00:00','664','2022-06-03 19:03:35'),(7,'5','272','2022-06-03',1,'003','','5',484760.00,'3','','','6','kd1','0014',546308.40,'2022-06-06 10:51:51',5,'','877','','0000-00-00 00:00:00','600','2022-06-06 16:37:13'),(8,'5','272','2022-06-03',1,'003','','2',61550.00,'3','','','','','',546308.40,'2022-06-06 10:53:38',2,'','877','','0000-00-00 00:00:00','600','2022-06-06 16:37:39'),(9,'5','272','2022-06-04',1,'','','5',1341935.00,'4','','','6','kd1','0014',1368684.90,'2022-06-06 10:56:19',2,'','877','','0000-00-00 00:00:00','600','2022-06-06 16:38:00'),(10,'5','272','2022-06-04',1,'004','','2',26750.00,'4','','','','','',0.00,'2022-06-06 10:57:48',5,'','877','600','2022-06-06 16:38:32','600','2022-06-06 16:38:42'),(11,'5','272','2022-06-05',1,'','','5',421070.00,'5','','','6','kd1','0014',447816.60,'2022-06-06 11:00:23',5,'','877','','0000-00-00 00:00:00','600','2022-06-06 16:38:59'),(12,'5','272','2022-06-05',1,'005','','2',26750.00,'5','','','','','',0.00,'2022-06-06 11:02:17',5,'','877','600','2022-06-06 16:40:18','600','2022-06-06 16:40:25'),(13,'5','272','2022-06-02',1,'002','','2',27750.00,'2','','','','','',0.00,'2022-06-06 18:58:17',5,'','877','','0000-00-00 00:00:00','600','2022-06-07 10:39:57'),(14,'5','272','2022-06-03',1,'003','','2',61550.00,'3','','','','','',0.00,'2022-06-06 18:59:46',5,'','877','','0000-00-00 00:00:00','600','2022-06-07 10:40:45'),(15,'5','272','2022-06-06',1,'','','5',1165645.00,'6','','','6','kd1','0034',1450642.05,'2022-06-07 14:22:31',5,'','877','','0000-00-00 00:00:00','600','2022-06-07 15:22:25'),(17,'5','272','2022-06-06',1,'006','','2',40000.00,'6','','','','','',0.00,'2022-06-07 14:27:53',5,'','877','','0000-00-00 00:00:00','600','2022-06-07 15:37:44'),(18,'5','272','2022-06-07',1,'','','5',1451820.00,'7','','','6','kd1','0006',1785816.45,'2022-06-08 14:20:57',5,'','877','','0000-00-00 00:00:00','600','2022-06-08 16:30:17'),(19,'5','272','2022-06-07',1,'007','','2',334000.00,'7','','','','','',0.00,'2022-06-08 14:21:47',5,'','877','','0000-00-00 00:00:00','600','2022-06-08 16:30:35'),(20,'5','272','2022-06-08',1,'','','5',1535555.00,'8','','','6','kd1','0005',1604550.75,'2022-06-09 11:02:41',5,'','877','','0000-00-00 00:00:00','600','2022-06-09 12:40:29'),(21,'5','272','2022-06-08',1,'008','','2',69000.00,'8','','','','','',0.00,'2022-06-09 11:03:25',5,'','877','','0000-00-00 00:00:00','664','2022-06-10 05:25:59'),(22,'5','272','2022-06-09',1,'','','5',976295.00,'9','','','6','kd1','0042',1007541.15,'2022-06-10 14:28:27',5,'','877','','0000-00-00 00:00:00','600','2022-06-10 15:15:34'),(23,'5','272','2022-06-09',1,'009','','2',31250.00,'9','','','','','',0.00,'2022-06-10 14:31:48',5,'','877','','0000-00-00 00:00:00','664','2022-06-10 21:42:28'),(24,'5','272','2022-06-10',1,'','','5',810465.00,'10','','','6','kd1','004',841712.85,'2022-06-14 11:10:53',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:20:14'),(25,'5','272','2022-06-10',1,'010','','2',31250.00,'10','','','','','',0.00,'2022-06-14 11:12:23',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:20:27'),(26,'5','272','2022-06-11',1,'','','5',545625.00,'11','','','6','kd1','0004',577874.55,'2022-06-14 11:14:25',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:20:50'),(27,'5','272','2022-06-11',1,'011','','2',32250.00,'11','','','','','',0.00,'2022-06-14 11:18:34',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:21:01'),(28,'5','272','2022-06-12',1,'','','5',303105.00,'12','','','6','kd1','0004',333351.15,'2022-06-14 11:20:18',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:21:17'),(29,'5','272','2022-06-12',1,'012','','2',30250.00,'12','','','','','',0.00,'2022-06-14 11:21:15',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:21:30'),(30,'5','272','2022-06-13',1,'','','5',286990.00,'13','','','6','kd1','0004',349740.60,'2022-06-14 11:22:26',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:21:44'),(31,'5','272','2022-06-13',1,'013','','2',62750.00,'13','','','','','',0.00,'2022-06-14 11:23:08',5,'','877','','0000-00-00 00:00:00','600','2022-06-14 16:22:03'),(32,'5','272','2022-06-14',1,'','','5',276640.00,'14','','','6','kd1','0037',307885.05,'2022-06-15 16:04:33',5,'','877','','0000-00-00 00:00:00','664','2022-06-16 07:00:57'),(33,'5','272','2022-06-14',1,'014','','2',31250.00,'14','','','','','',0.00,'2022-06-15 16:05:56',5,'','877','','0000-00-00 00:00:00','664','2022-06-16 07:00:57'),(34,'5','272','2022-06-15',1,'','','5',477170.00,'15','','','6','kd1','0026',508416.15,'2022-06-16 14:45:00',5,'','877','','0000-00-00 00:00:00','664','2022-06-16 19:16:33'),(35,'5','272','2022-06-15',1,'015','','2',31250.00,'15','','','','','',0.00,'2022-06-16 14:46:44',5,'','877','','0000-00-00 00:00:00','664','2022-06-16 19:16:33'),(36,'5','272','2022-06-16',1,'','','5',283985.00,'16','','','6','kd1','0033',315230.85,'2022-06-17 16:24:09',5,'','877','','0000-00-00 00:00:00','664','2022-06-18 07:02:14'),(37,'5','272','2022-06-16',1,'016','','2',31250.00,'16','','','','','',0.00,'2022-06-17 16:24:59',5,'','877','','0000-00-00 00:00:00','664','2022-06-18 07:02:14'),(38,'5','272','2022-06-17',1,'','','5',340410.00,'17','','','6','kd1','54967132',371655.90,'2022-06-20 15:50:20',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(39,'5','272','2022-06-17',1,'017','','2',31250.00,'17','','','','','',0.00,'2022-06-20 15:51:06',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(40,'5','272','2022-06-18',1,'','','5',299755.00,'18','','','6','kd1','54967132',330001.65,'2022-06-20 15:52:39',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(41,'5','272','2022-06-18',1,'018','','2',30250.00,'18','','','','','',0.00,'2022-06-20 15:53:45',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(42,'5','272','2022-06-19',1,'','','5',216215.00,'19','','','6','kd1','54967132',267465.00,'2022-06-20 15:55:01',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(43,'5','272','2022-06-19',1,'019','','2',51250.00,'19','','','','','',0.00,'2022-06-20 15:55:37',5,'','877','','0000-00-00 00:00:00','664','2022-06-20 21:04:16'),(44,'5','272','2022-06-20',1,'','','5',41260.00,'20','','','6','kd1','54967941',43256.40,'2022-06-21 16:34:05',5,'','877','','0000-00-00 00:00:00','664','2022-06-21 18:49:49'),(45,'5','272','2022-06-20',1,'020','','2',2000.00,'20','','','','','',0.00,'2022-06-21 16:34:57',5,'','877','','0000-00-00 00:00:00','664','2022-06-21 18:49:49'),(46,'5','272','2022-07-07',1,'','','5',145885.00,'37','','','6','kd1','0006',176134.20,'2022-07-11 08:49:38',5,'','877','','0000-00-00 00:00:00','664','2022-07-13 18:54:13'),(47,'5','272','2022-07-07',1,'037','','2',30250.00,'37','','','','','',0.00,'2022-07-11 08:50:45',5,'','877','','0000-00-00 00:00:00','664','2022-07-13 18:54:13'),(48,'5','272','2022-07-08',1,'','','5',863795.00,'38','','','6','kd1','0054',915990.90,'2022-07-13 19:12:03',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(49,'5','272','2022-07-08',1,'038','','2',52200.00,'38','','','','','',0.00,'2022-07-13 19:12:47',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(50,'5','272','2022-07-09',1,'','','5',343740.00,'39','','','6','kd1','0054',377749.65,'2022-07-13 19:14:38',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(51,'5','272','2022-07-09',1,'039','','2',34010.00,'39','','','','','',0.00,'2022-07-13 19:15:30',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(52,'5','272','2022-07-10',1,'','','5',436830.00,'40','','','6','kd1','0054',467075.05,'2022-07-13 19:17:08',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(53,'5','272','2022-07-10',1,'040','','2',30250.00,'40','','','','','',0.00,'2022-07-13 19:17:42',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(54,'5','272','2022-07-11',1,'','','5',759755.00,'41','','','6','kd1','0054',790001.80,'2022-07-13 19:19:22',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(55,'5','272','2022-07-11',1,'041','','2',30250.00,'41','','','','','',0.00,'2022-07-13 19:20:11',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(56,'5','272','2022-07-12',1,'','','5',353105.00,'42','','','6','kd1','0054',383353.30,'2022-07-13 19:22:21',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(57,'5','272','2022-07-12',1,'042','','2',30250.00,'42','','','','','',0.00,'2022-07-13 19:22:55',5,'','877','','0000-00-00 00:00:00','664','2022-07-14 06:30:53'),(58,'5','272','2022-07-13',1,'','','5',424285.00,'43','','','6','kd1','0049',455532.90,'2022-07-14 18:50:37',5,'','877','','0000-00-00 00:00:00','664','2022-07-15 07:16:29'),(59,'5','272','2022-07-13',1,'043','','2',31250.00,'43','','','','','',0.00,'2022-07-14 18:52:16',5,'','877','','0000-00-00 00:00:00','664','2022-07-15 07:16:29'),(60,'5','272','2022-07-14',1,'','','5',488880.00,'44','','','6','kd1','0003',540126.00,'2022-07-15 21:04:52',5,'','877','','0000-00-00 00:00:00','664','2022-07-16 06:51:53'),(61,'5','272','2022-07-14',1,'044','','2',51250.00,'44','','','','','',0.00,'2022-07-15 21:05:40',5,'','877','','0000-00-00 00:00:00','664','2022-07-16 06:51:53'),(62,'5','272','2022-07-15',1,'','','5',2152970.00,'45','','','6','kd1','0007',2196965.65,'2022-07-18 16:39:34',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(63,'5','272','2022-07-15',1,'045','','2',44000.00,'45','','','','','',0.00,'2022-07-18 16:40:11',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(64,'5','272','2022-07-16',1,'','','5',1861445.00,'46','','','6','kd1','0007',1904441.80,'2022-07-18 16:43:05',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(65,'5','272','2022-07-16',1,'046','','2',43000.00,'46','','','','','',0.00,'2022-07-18 16:45:09',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(66,'5','272','2022-07-17',1,'','','5',1554145.00,'47','','','6','kd1','0007',1892141.15,'2022-07-18 16:48:00',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(67,'5','272','2022-07-17',1,'047','','2',338000.00,'47','','','','','',0.00,'2022-07-18 16:50:05',5,'','877','','0000-00-00 00:00:00','664','2022-07-18 17:04:53'),(68,'5','272','2022-07-18',1,'','','5',1488720.00,'48','','','6','kd1','0018',1532715.75,'2022-07-20 08:02:52',5,'','877','','0000-00-00 00:00:00','664','2022-07-20 08:17:12'),(69,'5','272','2022-07-18',1,'048','','2',44000.00,'48','','','','','',0.00,'2022-07-20 08:03:44',5,'','877','','0000-00-00 00:00:00','664','2022-07-20 08:17:12'),(70,'5','272','2022-07-18',1,'','','5',2406860.00,'48','','','6','kd1','0027',2450857.80,'2022-07-20 14:00:53',5,'','877','','0000-00-00 00:00:00','664','2022-07-20 16:26:30'),(71,'5','272','2022-07-18',1,'048','','2',44000.00,'48','','','','','',0.00,'2022-07-20 14:01:30',5,'','877','','0000-00-00 00:00:00','664','2022-07-20 16:26:30'),(72,'5','272','2022-07-20',1,'','','5',3000190.00,'50','','','6','kd1','0034',3044189.80,'2022-07-21 15:22:30',5,'','877','','0000-00-00 00:00:00','664','2022-07-21 19:56:29'),(73,'5','272','2022-07-20',1,'050','','2',44000.00,'50','','','','','',0.00,'2022-07-21 15:24:27',5,'','877','','0000-00-00 00:00:00','664','2022-07-21 19:56:29'),(74,'5','272','2022-07-21',1,'','','5',2754730.00,'51','','','6','kd1','0054',2798726.25,'2022-07-22 15:57:03',5,'','877','','0000-00-00 00:00:00','664','2022-07-22 16:40:58'),(75,'5','272','2022-07-21',1,'051','','2',44000.00,'51','','','','','',0.00,'2022-07-22 15:57:45',5,'','877','','0000-00-00 00:00:00','664','2022-07-22 16:40:58'),(76,'5','272','2022-07-22',1,'','','5',1214690.00,'52','','','6','kd1','0031',1258690.00,'2022-07-25 17:32:59',2,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(77,'5','272','2022-07-22',1,'052','','2',44000.00,'52','','','','','',0.00,'2022-07-25 17:33:39',5,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(78,'5','272','2022-07-23',1,'','','5',1522770.00,'53','','','6','kd1','0031',1567770.00,'2022-07-25 17:36:45',5,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(79,'5','272','2022-07-23',1,'053','','2',45000.00,'53','','','','','',0.00,'2022-07-25 17:37:19',5,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(80,'5','272','2022-07-24',1,'','','5',2617670.00,'54','','','6','kd1','0031',2660670.00,'2022-07-25 17:40:44',5,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(81,'5','272','2022-07-24',1,'054','','2',43000.00,'54','','','','','',0.00,'2022-07-25 17:41:23',5,'','877','','0000-00-00 00:00:00','664','2022-07-25 18:48:11'),(82,'5','272','2022-07-25',1,'','','5',1692425.00,'55','','','6','kd1','0038',1736422.85,'2022-07-26 15:37:24',5,'','877','','0000-00-00 00:00:00','664','2022-07-26 18:20:14'),(83,'5','272','2022-07-25',1,'055','','2',44000.00,'55','','','','','',0.00,'2022-07-26 15:38:06',5,'','877','','0000-00-00 00:00:00','664','2022-07-26 18:20:13'),(84,'5','272','2022-07-26',1,'','','5',1460325.00,'56','','','6','kd1','0109',1506825.00,'2022-08-01 21:35:34',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:37:06'),(85,'5','272','2022-07-26',1,'056','','2',46500.00,'56','','','','','',0.00,'2022-08-01 21:36:15',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:37:06'),(86,'5','272','2022-07-27',1,'','','5',304415.00,'57','','','6','kd1','0109',334665.00,'2022-08-01 21:38:15',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(87,'5','272','2022-07-27',1,'057','','2',30250.00,'57','','','','','',0.00,'2022-08-01 21:38:59',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:37:06'),(88,'5','272','2022-07-28',1,'','','5',239230.00,'58','','','6','kd1','0109',269476.55,'2022-08-01 21:40:58',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(89,'5','272','2022-07-28',1,'058','','2',30250.00,'58','','','','','',0.00,'2022-08-01 21:41:38',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(90,'5','272','2022-07-29',1,'','','5',281890.00,'59','','','6','kd1','0109',312139.40,'2022-08-01 21:43:33',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(91,'5','272','2022-07-29',1,'059','','2',30250.00,'59','','','','','',0.00,'2022-08-01 21:44:18',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(92,'5','272','2022-07-30',1,'','','5',247380.00,'60','','','6','kd1','0109',277625.80,'2022-08-01 21:46:37',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(93,'5','272','2022-07-30',1,'060','','2',30250.00,'60','','','','','',0.00,'2022-08-01 21:47:16',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(94,'5','272','2022-07-31',1,'','','5',255665.00,'61','','','6','kd1','0109',285911.95,'2022-08-01 21:49:37',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(95,'5','272','2022-07-31',1,'061','','2',30250.00,'61','','','','','',0.00,'2022-08-01 21:50:20',5,'','877','','0000-00-00 00:00:00','664','2022-08-02 05:36:45'),(96,'5','272','2022-08-02',1,'','','5',689300.00,'63','','','6','kd1','0035',706298.55,'2022-08-03 14:40:11',5,'','877','','0000-00-00 00:00:00','664','2022-08-03 17:51:39'),(97,'5','272','2022-08-02',1,'063','','2',17000.00,'63','','','','','',0.00,'2022-08-03 14:40:51',5,'','877','','0000-00-00 00:00:00','664','2022-08-03 17:51:39'),(98,'5','272','2022-08-03',1,'','','5',3685690.00,'64','','','6','kd1','0040',3717438.10,'2022-08-05 00:48:05',5,'','877','','0000-00-00 00:00:00','664','2022-08-05 06:33:33'),(99,'5','272','2022-08-03',1,'064','','2',31750.00,'64','','','','','',0.00,'2022-08-05 00:49:26',5,'','877','','0000-00-00 00:00:00','664','2022-08-05 06:33:32'),(100,'5','272','2022-08-04',1,'','','5',383260.00,'65','','','6','kd1','0033',410757.35,'2022-08-06 01:18:41',5,'','877','','0000-00-00 00:00:00','664','2022-08-06 06:59:39'),(101,'5','272','2022-08-04',1,'065','','2',27500.00,'65','','','','','',0.00,'2022-08-06 01:19:32',5,'','877','','0000-00-00 00:00:00','664','2022-08-06 06:59:39'),(102,'5','272','2022-08-05',1,'066','','5',765070.00,'66','','','6','kd1','001',804269.00,'2022-09-09 13:51:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(103,'5','272','2022-08-05',1,'066','','2',39200.00,'66','','','','','',0.00,'2022-09-09 13:52:05',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(104,'5','272','2022-08-06',1,'067','','5',1697635.00,'67','','','6','kd1','002',1732883.90,'2022-09-09 13:53:59',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:04:02'),(105,'5','272','2022-08-06',1,'067','','2',35250.00,'67','','','','','',0.00,'2022-09-09 13:54:47',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(106,'5','272','2022-08-07',1,'068','','5',1441810.00,'68','','','6','kd1','003',1467806.65,'2022-09-09 14:04:50',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(107,'5','272','2022-08-07',1,'068','','2',26000.00,'68','','','','','',0.00,'2022-09-09 14:22:41',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(108,'5','272','2022-09-06',1,'069','','5',2578135.00,'69','','','6','kd1','004',2606132.00,'2022-09-10 00:54:07',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:47'),(109,'5','272','2022-09-06',1,'069','','2',27500.00,'69','','','','','',0.00,'2022-09-10 00:55:21',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(110,'5','272','2022-09-06',1,'069','','5',500.00,'69','','','6','kd1','004',0.00,'2022-09-10 00:59:03',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(111,'5','272','2022-09-06',1,'070','','5',2168715.00,'70','','','6','kd1','005',2236061.70,'2022-09-10 01:02:48',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(112,'5','272','2022-09-06',1,'070','','2',67350.00,'70','','','','','',0.00,'2022-09-10 01:03:24',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(113,'5','272','2022-08-10',1,'071','','5',2425600.00,'71','','','6','kd1','006',2775599.40,'2022-09-10 01:05:48',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(114,'5','272','2022-08-10',1,'071','','10',20000.00,'71','','','6','kd1','071',0.00,'2022-09-10 01:07:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(115,'5','272','2022-08-10',1,'071','','2',330000.00,'71','','','','','',0.00,'2022-09-10 01:08:07',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(116,'5','272','2022-08-11',1,'072','','5',2755750.00,'72','','','6','kd1','072',2783249.15,'2022-09-10 01:10:43',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(117,'5','272','2022-08-11',1,'072','','2',27500.00,'72','','','','','',0.00,'2022-09-10 01:11:16',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(118,'5','272','2022-08-12',1,'073','','5',2065580.00,'73','','','6','kd1','007',2093075.20,'2022-09-10 01:15:42',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:03:28'),(119,'5','272','2022-08-12',1,'073','','2',27500.00,'73','','','','','',0.00,'2022-09-10 01:17:46',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(120,'5','272','2022-08-13',1,'074','','5',2498220.00,'74','','','6','kd1','007',2525216.70,'2022-09-10 01:20:22',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(121,'5','272','2022-08-13',1,'074','','2',27000.00,'74','','','','','',0.00,'2022-09-10 01:21:06',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(122,'5','272','2022-08-14',1,'075','','5',2264700.00,'75','','','6','kd1','007',2290697.75,'2022-09-10 01:23:17',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(123,'5','272','2022-08-14',1,'075','','2',26000.00,'75','','','','','',0.00,'2022-09-10 01:24:21',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(124,'5','272','2022-08-15',1,'076','','5',2153505.00,'76','','','6','kd1','007',2181000.15,'2022-09-10 01:27:37',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(125,'5','272','2022-08-15',1,'076','','2',27500.00,'76','','','','','',0.00,'2022-09-10 01:29:57',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(126,'5','272','2022-08-16',1,'077','','5',1874180.00,'77','','','6','kd1','0006',1901679.75,'2022-09-10 01:35:35',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(127,'5','272','2022-08-16',1,'074','','2',27500.00,'77','','','','','',0.00,'2022-09-10 01:37:16',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(128,'5','272','2022-08-17',1,'078','','5',1870510.00,'78','','','6','kd1','0006',1900007.35,'2022-09-10 01:41:03',5,'','877','','0000-00-00 00:00:00','664','2022-09-10 15:02:56'),(129,'5','272','2022-08-17',1,'078','','2',29500.00,'78','','','','','',0.00,'2022-09-11 01:21:44',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(130,'5','272','2022-08-18',1,'079','','5',2047280.00,'79','','','6','kd1','007',2074776.85,'2022-09-11 01:24:07',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(131,'5','272','2022-08-18',1,'079','','2',27500.00,'79','','','','','',0.00,'2022-09-11 01:24:48',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(132,'5','272','2022-08-19',1,'080','','5',2494795.00,'80','','','6','kd1','007',2539293.35,'2022-09-11 01:27:03',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(133,'5','272','2022-08-19',1,'080','','2',44500.00,'80','','','','','',0.00,'2022-09-11 01:27:44',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(134,'5','272','2022-08-20',1,'081','','5',2534090.00,'81','','','6','kd1','007',2577087.00,'2022-09-11 01:30:54',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(135,'5','272','2022-08-20',1,'081','','2',43000.00,'81','','','','','',0.00,'2022-09-11 01:31:50',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(136,'5','272','2022-08-21',1,'082','','5',1580645.00,'82','','','6','kd1','007',1610893.05,'2022-09-11 01:34:01',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(137,'5','272','2022-08-21',1,'082','','2',30250.00,'82','','','','','',0.00,'2022-09-11 01:34:53',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:55:02'),(138,'5','272','2022-09-06',1,'083','','5',1784930.00,'83','','','6','kd1','0050',1820927.25,'2022-09-11 01:37:42',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(139,'5','272','2022-09-06',1,'083','','2',36000.00,'83','','','','','',0.00,'2022-09-11 01:38:25',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(140,'5','272','2022-08-23',1,'084','','5',2036950.00,'84','','','6','kd1','0050',2119648.60,'2022-09-11 01:40:53',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(141,'5','272','2022-08-23',1,'084','','2',82700.00,'84','','','','','',0.00,'2022-09-11 01:41:30',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(142,'5','272','2022-08-24',1,'085','','5',2449935.00,'85','','','6','kd1','0014',2494478.95,'2022-09-11 01:43:23',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(143,'5','272','2022-08-24',1,'085','','2',44500.00,'85','','','','','',0.00,'2022-09-11 01:44:01',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(144,'5','272','2022-08-25',1,'086','','5',2257010.00,'86','','','6','kd1','0014',2301459.20,'2022-09-11 01:46:23',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(145,'5','272','2022-08-25',1,'086','','2',44500.00,'86','','','','','',0.00,'2022-09-11 01:47:04',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(146,'5','272','2022-08-26',1,'087','','5',2741370.00,'87','','','6','kd1','0050',2785865.05,'2022-09-11 01:48:51',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(147,'5','272','2022-08-26',1,'087','','2',44500.00,'87','','','','','',0.00,'2022-09-11 01:49:23',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:43'),(148,'5','272','2022-08-27',1,'088','','5',2414560.00,'88','','','6','kd1','0014',2457556.65,'2022-09-11 01:51:20',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(149,'5','272','2022-08-27',1,'088','','2',43000.00,'88','','','','','',0.00,'2022-09-11 01:51:53',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(150,'5','272','2022-08-28',1,'089','','5',2267455.00,'89','','','6','kd1','0014',2310450.20,'2022-09-11 01:54:19',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(151,'5','272','2022-08-28',1,'089','','2',43000.00,'89','','','','','',0.00,'2022-09-11 01:54:55',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(152,'5','272','2022-08-29',1,'090','','5',2714870.00,'90','','','6','kd1','0050',2759369.35,'2022-09-11 14:46:45',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(153,'5','272','2022-08-29',1,'090','','2',44500.00,'90','','','','','',0.00,'2022-09-11 14:47:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(154,'5','272','2022-08-30',1,'091','','5',2446575.00,'91','','','6','kd1','0014',2491071.25,'2022-09-11 14:48:54',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(155,'5','272','2022-08-30',1,'091','','2',44500.00,'91','','','','','',0.00,'2022-09-11 14:49:38',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(156,'5','272','2022-08-31',1,'092','','5',816495.00,'92','','','6','kd1','0050',844991.20,'2022-09-11 14:51:16',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(157,'5','272','2022-08-31',1,'092','','2',28500.00,'92','','','','','',0.00,'2022-09-11 14:51:54',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:54:21'),(158,'5','272','2022-09-01',1,'093','','5',420750.00,'93','','','6','kd1','0014',448247.60,'2022-09-11 15:08:32',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(159,'5','272','2022-09-01',1,'093','','2',27500.00,'93','','','','','',0.00,'2022-09-11 15:09:12',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(160,'5','272','2022-09-02',1,'094','','5',959185.00,'94','','','6','kd1','0050',1009794.75,'2022-09-11 15:10:31',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(161,'5','272','2022-09-02',1,'094','','2',50700.00,'94','','','','','',0.00,'2022-09-11 15:11:05',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(162,'5','272','2022-09-03',1,'095','','5',2563900.00,'95','','','6','kd1','0006',2606986.70,'2022-09-11 15:12:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(163,'5','272','2022-09-03',1,'095','','2',43000.00,'95','','','','','',0.00,'2022-09-11 15:13:00',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(164,'5','272','2022-09-04',1,'096','','5',1936230.00,'96','','','6','kd1','0004',1970727.30,'2022-09-11 15:14:14',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:53'),(165,'5','272','2022-09-04',1,'096','','2',34500.00,'96','','','','','',0.00,'2022-09-11 15:15:16',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:53'),(166,'5','272','2022-09-05',1,'097','','5',2508720.00,'97','','','6','kd1','0014',2573466.55,'2022-09-11 15:18:55',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(167,'5','272','2022-09-05',1,'097','','2',64750.00,'97','','','','','',0.00,'2022-09-11 15:20:43',5,'','877','','0000-00-00 00:00:00','664','2022-09-12 08:53:46'),(168,'5','272','2022-09-06',1,'098','','5',2556440.00,'98','','','6','kd1','001',2602937.05,'2022-09-27 14:23:12',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(169,'5','272','2022-09-06',1,'098','','2',46500.00,'98','','','','','',0.00,'2022-09-27 14:23:59',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(170,'5','272','2022-09-07',1,'099','','5',2428960.00,'99','','','6','kd1','002',2473457.40,'2022-09-27 14:26:24',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(171,'5','272','2022-09-07',1,'099','','2',44500.00,'99','','','','','',0.00,'2022-09-27 14:28:21',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(172,'5','272','2022-09-08',1,'100','','5',1773290.00,'100','','','6','kd1','003',1809288.90,'2022-09-27 14:30:02',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(173,'5','272','2022-09-08',1,'100','','2',36000.00,'100','','','','','',0.00,'2022-09-27 14:31:10',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(174,'5','272','2022-09-09',1,'101','','5',664345.00,'101','','','6','kd1','004',691840.80,'2022-09-27 15:21:09',2,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(175,'5','272','2022-09-09',1,'101','','2',27500.00,'101','','','','','',0.00,'2022-09-27 15:22:04',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:38:11'),(176,'5','272','2022-09-10',1,'102','','5',314750.00,'102','','','6','kd1','005',3775747.95,'2022-09-27 15:23:58',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(177,'5','272','2022-09-10',1,'102','','2',61000.00,'102','','','','','',0.00,'2022-09-27 15:24:36',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(178,'5','272','2022-09-11',1,'103','','5',288500.00,'103','','','6','kd1','006',314500.00,'2022-09-27 15:26:07',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(179,'5','272','2022-09-11',1,'103','','2',26000.00,'103','','','','','',0.00,'2022-09-27 15:27:51',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(180,'5','272','2022-09-12',1,'104','','5',439580.00,'104','','','6','kd1','007',873077.90,'2022-09-27 15:29:58',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(181,'5','272','2022-09-12',1,'104','','2',433500.00,'104','','','','','',0.00,'2022-09-27 15:30:55',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(182,'5','272','2022-09-13',1,'105','','5',981040.00,'105','','','6','kd1','008',1448087.50,'2022-09-27 15:32:57',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(183,'5','272','2022-09-13',1,'105','','2',27500.00,'105','','','','','',0.00,'2022-09-27 15:33:36',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(184,'5','272','2022-09-14',1,'106','','5',2484110.00,'106','','','6','kd1','009',2528609.60,'2022-09-27 15:35:34',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(185,'5','272','2022-09-14',1,'106','','2',44500.00,'106','','','','','',0.00,'2022-09-27 15:36:40',5,'','877','','0000-00-00 00:00:00','664','2022-09-27 15:37:40'),(186,'5','272','2022-09-15',1,'107','','5',922765.00,'107','','','6','kd1','009',1087761.15,'2022-09-27 15:38:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:28'),(187,'5','272','2022-09-15',1,'107','','2',165000.00,'107','','','','','',0.00,'2022-09-27 15:39:13',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:28'),(188,'5','272','2022-09-16',1,'108','','5',2632565.00,'108','','','6','kd1','010',2793662.80,'2022-09-27 15:41:35',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:28'),(189,'5','272','2022-09-16',1,'108','','2',161100.00,'108','','','','','',0.00,'2022-09-27 15:42:40',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:28'),(190,'5','272','2022-09-17',1,'109','','5',2697560.00,'109','','','6','kd1','011',2740558.55,'2022-09-27 15:44:15',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(191,'5','272','2022-09-17',1,'109','','2',43000.00,'109','','','','','',0.00,'2022-09-27 15:45:10',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(192,'5','272','2022-09-18',1,'110','','5',1650915.00,'110','','','6','kd1','010',1681163.45,'2022-09-27 15:47:29',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(193,'5','272','2022-09-18',1,'110','','2',30250.00,'110','','','','','',0.00,'2022-09-27 15:48:18',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(194,'5','272','2022-09-19',1,'111','','5',1794500.00,'111','','','6','kd1','012',1826247.85,'2022-09-27 15:51:27',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(195,'5','272','2022-09-19',1,'111','','2',31750.00,'111','','','','','',0.00,'2022-09-27 15:52:47',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(196,'5','272','2022-09-20',1,'112','','5',2107665.00,'112','','','6','kd1','013',2143162.10,'2022-09-27 15:54:37',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(197,'5','272','2022-09-20',1,'112','','2',35500.00,'112 ','','','','','',0.00,'2022-09-27 15:55:26',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(198,'5','272','2022-09-21',1,'113','','5',1976800.00,'113','','','6','kd1','014',2012800.00,'2022-09-27 15:57:43',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(199,'5','272','2022-09-21',1,'113','','2',36000.00,'113','','','','','',0.00,'2022-09-27 15:58:28',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:22:13'),(200,'5','272','2022-09-22',1,'114','','5',1820685.00,'114','','','6','kd1','015',1856682.20,'2022-09-27 16:00:26',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(201,'5','272','2022-09-22',1,'114','','2',36000.00,'114','','','','','',0.00,'2022-09-27 16:01:47',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(202,'5','272','2022-09-23',1,'115','','5',2247010.00,'115','','','6','kd1','016',2391507.95,'2022-09-27 16:03:19',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(203,'5','272','2022-09-23',1,'115','','2',144500.00,'115','','','','','',0.00,'2022-09-27 16:04:57',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(204,'5','272','2022-09-24',1,'116','','5',2337055.00,'116','','','6','kd1','017',2380050.90,'2022-09-27 16:06:59',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(205,'5','272','2022-09-24',1,'116','','2',43000.00,'116','','','','','',0.00,'2022-09-27 16:08:03',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(206,'5','272','2022-09-25',1,'117','','5',1585255.00,'117','','','6','kd1','018',1611253.80,'2022-09-27 16:13:40',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(207,'5','272','2022-09-25',1,'117','','2',26000.00,'117','','','','','',0.00,'2022-09-27 16:14:39',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(208,'5','272','2022-09-26',1,'118','','5',2382295.00,'118','','','6','kd1','019',2426793.00,'2022-09-27 16:16:31',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(209,'5','272','2022-09-26',1,'118','','2',44500.00,'118','','','','','',0.00,'2022-09-27 16:17:10',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 08:21:54'),(210,'5','272','2022-09-27',1,'119','','5',1466870.00,'119','','','6','kd1','0028',1531367.10,'2022-09-28 15:18:27',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 16:29:37'),(211,'5','272','2022-09-27',1,'119','','2',64500.00,'119','','','','','',0.00,'2022-09-28 15:19:27',5,'','877','','0000-00-00 00:00:00','664','2022-09-28 16:29:37'),(214,'5','272','2022-09-28',1,'120','','5',2432135.00,'120','','','6','kd1','0028',2515482.00,'2022-09-30 18:51:09',5,'','877','','0000-00-00 00:00:00','664','2022-09-30 21:47:55'),(215,'5','272','2022-09-28',1,'120','','2',83350.00,'120','','','','','',0.00,'2022-09-30 18:52:47',5,'','877','','0000-00-00 00:00:00','664','2022-09-30 21:47:55'),(216,'5','272','2022-09-29',1,'121','','5',2576415.00,'121','','','6','kd1','0114',2620913.50,'2022-09-30 18:55:58',5,'','877','','0000-00-00 00:00:00','664','2022-09-30 21:47:55'),(217,'5','272','2022-09-29',1,'121','','2',44500.00,'121','','','','','',0.00,'2022-09-30 18:56:23',5,'','877','','0000-00-00 00:00:00','664','2022-09-30 21:47:55'),(218,'5','272','2022-09-30',1,'128','','5',2390965.00,'128','','','6','kd1','0059',2435462.10,'2022-10-06 17:37:06',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(219,'5','272','2022-09-30',1,'122','','5',2390965.00,'122','','','6','kd1','0058',2435462.10,'2022-10-06 17:42:28',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:31'),(220,'5','272','2022-09-30',1,'122','','2',44500.00,'122','','','','','',0.00,'2022-10-06 17:44:18',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:31'),(221,'5','272','2022-10-01',1,'123','','5',2370055.00,'123','','','6','kd1','0056',2458050.60,'2022-10-06 17:47:58',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:31'),(222,'5','272','2022-10-01',1,'123','','2',88000.00,'123','','','','','',0.00,'2022-10-06 17:48:57',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(223,'5','272','2022-10-02',1,'124','','2',88000.00,'124','','','','','',0.00,'2022-10-06 17:50:40',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(224,'5','272','2022-10-02',1,'124','','5',2017765.00,'124','','','6','kd1','0055',2060764.95,'2022-10-06 17:54:44',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(225,'5','272','2022-10-02',1,'124','','2',43000.00,'124','','','','','',0.00,'2022-10-06 17:55:54',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(226,'5','272','2022-10-04',1,'125','','5',1426065.00,'125','','','6','kd1','0066',1463764.40,'2022-10-06 18:00:05',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(227,'5','272','2022-10-04',1,'125','','2',37700.00,'125','','','','','',0.00,'2022-10-06 18:01:17',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(228,'5','272','2022-10-04',1,'126','','5',930365.00,'126','','','6','kd1','5554',957861.55,'2022-10-06 18:06:32',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(229,'5','272','2022-10-04',1,'126','','2',27500.00,'126','','','','','',0.00,'2022-10-06 18:07:47',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(230,'5','272','2022-10-05',1,'127','','5',385670.00,'127','','','6','kd1','0036',422419.75,'2022-10-06 18:10:49',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(231,'5','272','2022-10-05',1,'127','','2',36750.00,'127','','','','kd1','',0.00,'2022-10-06 18:13:16',5,'','877','','0000-00-00 00:00:00','664','2022-10-07 09:37:01'),(247,'5','272','2022-10-06',1,'128','','5',385670.00,'128','','','6','kd1','1160',103503.80,'2022-10-20 15:04:14',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(248,'5','272','2022-10-06',1,'128','','2',26000.00,'128','','','','','',0.00,'2022-10-20 15:06:02',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(249,'5','272','2022-10-06',1,'128','','5',84505.00,'128','','','6','kd1','1260',103503.80,'2022-10-20 15:07:19',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(250,'5','272','2022-10-06',1,'128','','2',19000.00,'128','','','','','',0.00,'2022-10-20 15:08:54',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(251,'5','272','2022-10-07',1,'129','','5',309955.00,'129','','','6','kd1','1170',335954.45,'2022-10-20 15:11:55',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(252,'5','272','2022-10-07',1,'129','','2',26000.00,'129','','','','','',0.00,'2022-10-20 15:14:31',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(253,'5','272','2022-10-08',1,'130','','5',209475.00,'130','','','6','kd1','1280',245472.80,'2022-10-20 15:17:21',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(254,'5','272','2022-10-08',1,'130','','2',36000.00,'130','','','','','',0.00,'2022-10-20 15:19:13',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:43'),(255,'5','272','2022-10-10',1,'132','','5',492835.00,'132','','','6','kd1','2210',518832.50,'2022-10-20 15:22:40',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(256,'5','272','2022-10-10',1,'132','','2',26000.00,'132','','','','','',0.00,'2022-10-20 15:24:51',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(257,'5','272','2022-10-11',1,'133','','5',3443310.00,'133','','','6','kd1','1122',3491806.55,'2022-10-20 15:26:54',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(258,'5','272','2022-10-11',1,'133','','2',48500.00,'133','','','','','',0.00,'2022-10-20 15:28:01',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(259,'5','272','2022-10-12',1,'134','','5',2654105.00,'134','','','6','kd1','1224',2698604.25,'2022-10-20 15:31:12',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(260,'5','272','2022-10-12',1,'134','','2',44500.00,'134','','','','','',0.00,'2022-10-20 15:32:30',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(261,'5','272','2022-10-13',1,'135','','5',2477315.00,'135','','','6','kd1','1123',2521810.85,'2022-10-20 15:34:21',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(262,'5','272','2022-10-13',1,'135','','2',44500.00,'135','','','','','',0.00,'2022-10-20 15:35:15',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(263,'5','272','2022-10-14',1,'136','','5',2760315.00,'136','','','6','kd1','1225',2804814.60,'2022-10-20 15:37:55',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(264,'5','272','2022-10-14',1,'136','','2',44500.00,'136','','','','','',0.00,'2022-10-20 15:39:04',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:41:22'),(265,'5','272','2022-10-15',1,'137','','5',1988040.00,'137','','','6','kd1','3370',2725035.20,'2022-10-20 15:41:45',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(266,'5','272','2022-10-15',1,'137','','2',737000.00,'137','','','','','',0.00,'2022-10-20 15:43:17',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(267,'5','272','2022-10-16',1,'138','','5',3261495.00,'138','','','6','kd1','1266',3304492.20,'2022-10-20 15:45:13',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(268,'5','272','2022-10-16',1,'138','','2',43000.00,'138','','','','','',0.00,'2022-10-20 15:46:16',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(269,'5','272','2022-10-17',1,'139','','5',2475600.00,'139','','','6','kd1','1139',2523094.75,'2022-10-20 15:48:48',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(270,'5','272','2022-10-17',1,'139','','2',47500.00,'139','','','','','',0.00,'2022-10-20 15:50:05',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(271,'5','272','2022-10-18',1,'140','','5',3401600.00,'140','','','6','kd1','1288',3456099.70,'2022-10-20 15:51:49',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(272,'5','272','2022-10-18',1,'140','','2',54500.00,'140','','','','','',0.00,'2022-10-20 15:52:47',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(273,'5','272','2022-10-19',1,'141','','5',2032470.00,'141','','','6','kd1','1299',2077969.95,'2022-10-20 15:54:30',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(274,'5','272','2022-10-19',1,'141','','2',45500.00,'141','','','','','',0.00,'2022-10-20 15:55:26',5,'','877','','0000-00-00 00:00:00','664','2022-10-21 07:40:34'),(275,'5','272','2022-10-20',1,'142','','5',2142875.00,'142','','','6','kd1','0043',2178870.80,'2022-10-22 11:02:48',5,'','877','','0000-00-00 00:00:00','664','2022-10-23 08:10:31'),(276,'5','272','2022-10-20',1,'142','','2',36000.00,'142','','','','','',0.00,'2022-10-22 11:04:34',5,'','877','','0000-00-00 00:00:00','664','2022-10-23 08:10:31'),(277,'5','272','2022-10-27',1,'2634','','2',534267.90,'149','','','','','',0.00,'2022-10-27 15:49:46',2,'FSM CLEARED BALANCE','606','','0000-00-00 00:00:00','606','2022-10-27 15:49:54'),(278,'5','272','2022-10-27',1,'2634','','2',130077.10,'149','','','','','',0.00,'2022-10-27 15:53:18',5,'FSM CLEARED AMOUNT','606','','0000-00-00 00:00:00','606','2022-10-27 15:53:44'),(279,'5','272','2022-10-21',1,'143','','5',1255150.00,'143','','','6','kd1','00540',1281145.35,'2022-10-31 23:10:45',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(280,'5','272','2022-10-21',1,'143','','2',26000.00,'143','','','','','',0.00,'2022-10-31 23:12:02',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(281,'5','272','2022-10-28',1,'150','','5',2215510.00,'150','','','6','kd1','1159',2236008.05,'2022-10-31 23:14:43',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(282,'5','272','2022-10-28',1,'150','','2',20500.00,'150','','','','','',0.00,'2022-10-31 23:15:54',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(283,'5','272','2022-10-29',1,'151','','5',2151365.00,'151','','','6','kd1','11600',2168864.15,'2022-10-31 23:18:14',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(284,'5','272','2022-10-29',1,'151','','2',17500.00,'151','','','','','',0.00,'2022-10-31 23:19:58',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(285,'5','272','2022-10-30',1,'152','','5',1211040.00,'152','','','6','kd1','1189',1228536.90,'2022-10-31 23:21:59',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(286,'5','272','2022-10-30',1,'152','','2',17500.00,'152','','','','','',0.00,'2022-10-31 23:23:13',5,'','877','','0000-00-00 00:00:00','664','2022-11-01 06:40:49'),(287,'5','272','2022-10-31',1,'153','','5',1402315.00,'153','','','6','kd1','00311',1421310.60,'2022-11-01 22:47:52',5,'','877','','0000-00-00 00:00:00','664','2022-11-02 08:24:40'),(288,'5','272','2022-10-31',1,'153','','2',19000.00,'153','','','','','',0.00,'2022-11-01 22:50:36',5,'','877','','0000-00-00 00:00:00','664','2022-11-02 08:24:40'),(289,'5','272','2022-11-01',1,'154','','5',1272310.00,'154','','','6','kd1','0024',1297806.45,'2022-11-03 23:34:08',5,'','877','','0000-00-00 00:00:00','664','2022-11-04 07:32:21'),(290,'5','272','2022-11-01',1,'154','','2',25500.00,'154','','','','','',0.00,'2022-11-03 23:35:30',5,'','877','','0000-00-00 00:00:00','664','2022-11-04 07:32:21'),(291,'5','272','2022-11-09',1,'162','','5',2732880.00,'162','','','6','kd1','00057',2818878.30,'2022-11-14 13:30:32',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(292,'5','272','2022-11-09',1,'162','','2',86000.00,'162','','','','','',0.00,'2022-11-14 13:31:45',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(293,'5','272','2022-11-10',1,'163','','5',2173800.00,'163','','','6','kd1','00056',2210596.45,'2022-11-14 13:33:17',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(294,'5','272','2022-11-10',1,'163','','2',36800.00,'163','','','','','',0.00,'2022-11-14 13:34:37',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(295,'5','272','2022-11-11',1,'164','','5',2179500.00,'164','','','6','kd1','00050',2271964.65,'2022-11-14 15:19:51',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(296,'5','272','2022-11-11',1,'164','','2',36800.00,'164','','','','','',0.00,'2022-11-14 15:20:43',5,'','877','','0000-00-00 00:00:00','664','2022-11-15 07:44:20'),(297,'5','272','2022-11-13',1,'TCI0060','','5',692265.00,'166','','','6','Kaduna Service Station','TCI0060',1044363.85,'2022-11-15 17:16:57',5,'Payment for the Sales of 13/0/11/2022','877','','0000-00-00 00:00:00','664','2022-11-16 07:34:43'),(298,'5','272','2022-11-13',1,'TCI0060','','2',352100.00,'166','','','','','',0.00,'2022-11-15 17:21:25',5,'House Rent #204,000\r\nGen Service #38,850\r\nRefilling of fire extinguisher #40,500\r\nGen AGO #35,300\r\nMonthly Expenses #11,700\r\nWeight and Measure #11,000\r\n50L of PMS to DPO #9250\r\nTransport #1500','877','','0000-00-00 00:00:00','664','2022-11-16 07:34:43'),(299,'5','272','2022-11-20',1,'CNR0019','','5',1298840.00,'173','','','6','Kaduna Service Station','CNR0019',1385637.05,'2022-11-21 16:24:05',5,'Payment for the Sales of 20/11/22','877','','0000-00-00 00:00:00','664','2022-11-22 09:22:12'),(300,'5','272','2022-11-20',1,'CNR019','','2',86800.00,'173','','','','','',1385637.05,'2022-11-21 16:25:25',5,'Gen AGO #35,300\r\nTransport #1500\r\nMattress #50,000','877','','0000-00-00 00:00:00','664','2022-11-22 09:22:12'),(302,'5','272','2022-11-21',1,'0023','','5',1163490.00,'174','','','6','Kaduna Service Station','0023',1200291.10,'2022-11-22 13:49:01',5,'Payment for the Sales of 21/11/22','877','','0000-00-00 00:00:00','600','2022-11-22 15:16:19'),(303,'5','272','2022-11-21',1,'0023','','2',36800.00,'174','','','','','',0.00,'2022-11-22 13:50:14',5,'Gen AGO #35,300\r\nTransport #1500','877','','0000-00-00 00:00:00','600','2022-11-22 15:16:19'),(304,'5','272','2022-11-23',1,'2634','','2',194000.00,'175','','','','','',0.00,'2022-11-23 14:03:05',5,'AUTHORITY OF LEAKING TANK 194,000','606','','0000-00-00 00:00:00','606','2022-11-23 14:03:20'),(305,'5','272','2022-11-22',1,'CNR0034','','5',3741135.00,'175','','','6','Kaduna Service Station','CNR0034',3777934.95,'2022-11-23 16:47:08',5,'Payment for the Sales of 22/11/22','877','','0000-00-00 00:00:00','664','2022-11-23 21:26:15'),(306,'5','272','2022-11-22',1,'CNR0034','','2',36800.00,'175','','','','','',0.00,'2022-11-23 16:48:44',5,'Gen AGO #35,300\r\nTransport #1500','877','','0000-00-00 00:00:00','664','2022-11-23 21:26:15'),(307,'5','272','2022-11-23',1,'CNR0018','','5',3523975.00,'176','','','6','Kaduna Service Station','CNR0018',3560772.70,'2022-11-24 14:11:34',5,'Payment for the Sales of 23/11/22','877','','0000-00-00 00:00:00','664','2022-11-24 21:59:48'),(308,'5','272','2022-11-23',1,'CNR0018','','2',36800.00,'176','','','','','',0.00,'2022-11-24 14:12:38',5,'Gen AGO #35,300\r\nTransport #1500','877','','0000-00-00 00:00:00','664','2022-11-24 21:59:48'),(309,'5','272','2022-11-25',1,'024445','','5',4122115.00,'181','','','6','Kaduna Service Station','024445',4157412.00,'2022-11-28 14:02:02',5,'Payment for the Sales of 25/11/22','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(310,'5','272','2022-11-25',1,'024445','','2',35300.00,'178','','','','','',0.00,'2022-11-28 14:03:51',5,'Gen AGO 35,300','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(311,'5','272','2022-11-26',1,'024445','','5',4174650.00,'179','','','6','Kaduna Service Station','2024445',4209950.00,'2022-11-28 14:06:33',5,'Payment for the Sales of 26/11/22','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(312,'5','272','2022-11-26',1,'024445','','2',35300.00,'179','','','','','',0.00,'2022-11-28 14:07:55',5,'Gen AGO 35,300','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(313,'5','272','2022-11-27',1,'024445','','5',2949865.00,'180','','','6','Kaduna Service Station','02024445',2986665.90,'2022-11-28 14:10:07',5,'Payment for the Sales of 27/11/22','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(314,'5','272','2022-11-27',1,'024445','','2',36800.00,'180','','','','','',0.00,'2022-11-28 14:11:46',5,'Gen AGO #35,300\r\nTransport #1500','877','','0000-00-00 00:00:00','664','2022-11-29 08:10:53'),(315,'5','272','2022-11-29',1,'0056','','5',4339780.00,'182','','','6','Kaduna Service Station','CNR0056',4376578.30,'2022-12-01 14:08:08',5,'Payment for the Sales of 29/11/2022','877','','0000-00-00 00:00:00','664','2022-12-01 16:40:07'),(316,'5','272','2022-11-29',1,'0056','','2',36800.00,'184','','','','','',0.00,'2022-12-01 14:09:14',5,'Gen AGO 35,300\r\nTransport 1500','877','','0000-00-00 00:00:00','664','2022-12-01 16:40:07'),(317,'5','272','2022-11-30',1,'0062','','5',4102650.00,'183','','','6','Kaduna Service Station','CNR0062',4139449.00,'2022-12-01 14:11:34',5,'Payment for the Sales of 30/11/2022','877','','0000-00-00 00:00:00','664','2022-12-01 16:40:07'),(318,'5','272','2022-11-30',1,'0062','','2',36800.00,'183','','','','','',0.00,'2022-12-01 14:13:17',5,'Gen AGO 36,300\r\nTransport 1500','877','','0000-00-00 00:00:00','664','2022-12-01 16:40:07'),(319,'5','272','2022-12-01',1,'0081','','5',4490540.00,'184','','','6','Kaduna Service Station','CNR0082',4546336.15,'2022-12-06 06:44:10',5,'Payment for the Sales of 01/12/22','877','','0000-00-00 00:00:00','664','2022-12-06 07:58:37'),(320,'5','272','2022-12-01',1,'0081','','2',55800.00,'184','','','','','',0.00,'2022-12-06 06:46:28',5,'Gen AGO 35,300\r\nTransport 1500\r\nFIRS License 19,000','877','','0000-00-00 00:00:00','664','2022-12-06 07:58:37'),(321,'5','272','2022-12-02',1,'343313','','5',2847920.00,'185','','','6','Kaduna Service Station','4343313',2883223.15,'2022-12-06 13:07:51',5,'Payment for the Sales of 2/12/22','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(322,'5','272','2022-12-02',1,'343313','','2',35300.00,'185','','','','','',0.00,'2022-12-06 13:09:16',5,'Gen AGO 35,300','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(323,'5','272','2022-12-03',1,'343313','','5',2732410.00,'186','','','6','Kaduna Service Station','24343313',2767722.10,'2022-12-06 13:13:25',5,'Payment for the Sales of 03/12/22','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(324,'5','272','2022-12-03',1,'343313','','2',35300.00,'186','','','','','',0.00,'2022-12-06 13:59:46',5,'Payment for the Sales 03/12/22','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(325,'5','272','2022-12-04',1,'343313','','5',3630965.00,'187','','','6','Kaduna Service Station','624343313',3667765.60,'2022-12-06 14:03:21',5,'Payment for the Sales of 4/12/22','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(326,'5','272','2022-12-04',1,'343313','','2',36800.00,'187','','','','','',0.00,'2022-12-06 14:04:51',5,'Gen AGO 35,300\r\nTransport 1500','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(327,'5','272','2022-12-05',1,'0026','','5',1291960.00,'188','','','6','Kaduna Service Station','CNR0026',1354758.70,'2022-12-06 14:06:17',5,'Payment for the Sales of 5/12/22','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(328,'5','272','2022-12-05',1,'0026','','2',55800.00,'188','','','','','',0.00,'2022-12-06 14:07:35',5,'Gen AGO 35,300\r\nTransport 1500\r\nFIRS License 26,000','877','','0000-00-00 00:00:00','664','2022-12-07 07:44:28'),(329,'5','272','2022-12-06',1,'0018','','5',1689150.00,'189','','','6','Kaduna Service Station','865CNR0018',1725957.50,'2022-12-07 14:29:01',5,'Payment for the Sales of 06/12/2022','877','','0000-00-00 00:00:00','664','2022-12-09 08:11:57'),(330,'5','272','2022-12-06',1,'0018','','2',36800.00,'189','','','','','',0.00,'2022-12-07 14:29:54',5,'Gen AGO 35,300\r\nTransport 1500','877','','0000-00-00 00:00:00','664','2022-12-09 08:11:57'),(331,'5','272','2022-12-07',1,'019','','5',1574770.00,'190','','','6','Kaduna Service Station','CNR019',1611570.15,'2022-12-08 11:37:15',5,'Payment for the Sales of 07/12/22','877','','0000-00-00 00:00:00','664','2022-12-09 08:11:56'),(332,'5','272','2022-12-07',1,'0019','','2',36800.00,'190','','','','','',0.00,'2022-12-08 11:38:03',5,'Gen AGO 35,300\r\nTransport 1500','877','','0000-00-00 00:00:00','664','2022-12-09 08:11:56'),(333,'5','272','2022-11-24',1,'123','','5',4096625.00,'197','','','6','KADUNA STATION ','123',0.00,'2022-12-15 10:58:57',5,'Payments for 24 Nov ','600','','0000-00-00 00:00:00','664','2022-12-15 11:01:52'),(334,'5','272','2022-11-24',1,'123','','2',36800.00,'197','','','','','',0.00,'2022-12-15 11:00:06',5,'','600','','0000-00-00 00:00:00','664','2022-12-15 11:01:52'),(335,'5','272','2022-11-02',1,'124','','5',295000.00,'197','','','6','KADUNA ','124',0.00,'2022-12-15 11:01:22',2,'Refund from jajira station ','600','','0000-00-00 00:00:00','664','2022-12-15 11:01:52'),(336,'5','272','2022-11-02',1,'125','','5',295000.00,'197','','','6','KADUNA STATION ','125',0.00,'2022-12-15 11:08:41',5,'JAJIRA STATION REFUND ','600','','0000-00-00 00:00:00','664','2022-12-15 11:09:02'),(337,'5','272','2022-11-02',1,'2634','','5',346956.00,'226','','','6','Tamburawa','2422',0.00,'2023-01-13 19:26:59',5,'','606','','0000-00-00 00:00:00','606','2023-01-13 19:27:13'),(338,'5','272','2023-01-13',1,'0482795','','5',1317480.00,'227','','','6','Kaduna Service Station ','0482785',1351180.80,'2023-01-17 11:47:01',5,'Payment for the Sales of 13th 01 23','877','','0000-00-00 00:00:00','1013','2023-01-17 12:01:26'),(339,'5','272','2023-01-13',1,'0482795','','2',33700.00,'227','','','','','',0.00,'2023-01-17 11:48:21',5,'Gen AGO  33,700','877','','0000-00-00 00:00:00','1013','2023-01-17 12:02:55'),(340,'5','272','2023-01-14',1,'0482795','','5',1374850.00,'228','','','6','Kaduna Service Station ','0482795',1408553.00,'2023-01-17 11:50:51',5,'Payment for the Sales of 14th 01 23','877','','0000-00-00 00:00:00','1013','2023-01-17 12:05:36'),(341,'5','272','2023-01-14',1,'0482795','','2',33700.00,'228','','','','','',0.00,'2023-01-17 11:52:01',5,'Gen AGO 33,700','877','','0000-00-00 00:00:00','1013','2023-01-17 12:06:13'),(342,'5','272','2023-01-15',1,'0482795','','5',2482690.00,'229','','','6','Kaduna Service Station ','482795',2529591.95,'2023-01-17 11:54:12',5,'Payment for the Sales of 15th 01 23','877','','0000-00-00 00:00:00','1013','2023-01-17 12:05:14'),(343,'5','272','2023-01-15',1,'0482795','','2',46900.00,'229','','','','','',0.00,'2023-01-17 11:56:13',5,'Gen AGO 33,700 \r\nMonthly Expenses 11,700\r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-01-17 12:04:34'),(344,'5','272','2023-01-16',1,'TCI0027','','5',1598020.00,'230','','','6','Kaduna Service Station ','TCI0027',2003217.00,'2023-01-17 17:35:52',5,'Payment for the Sales of 16th  01 23','877','','0000-00-00 00:00:00','1013','2023-01-18 12:17:54'),(345,'5','272','2023-01-16',1,'TCI0027','','2',405200.00,'230','','','','','',0.00,'2023-01-17 17:38:17',5,'Gen AGO 33,700\r\nTransport 1500\r\nStaffs Salary 330,000\r\nSokoto Staffs Salary 40,000','877','','0000-00-00 00:00:00','1013','2023-01-18 12:18:44'),(346,'5','272','2023-01-17',1,'CNR0024','','5',1011230.00,'231','','','6','Kaduna Service Station ','CNR0024',1048424.60,'2023-01-18 12:02:37',5,'Payment for the Sales of 17th 01 23','877','','0000-00-00 00:00:00','1013','2023-01-18 12:23:43'),(347,'5','272','2023-01-17',1,'CNR0024','','2',35200.00,'231','','','','','',0.00,'2023-01-18 12:04:28',5,'Gen AGO 33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-01-18 12:24:40'),(348,'5','272','2023-01-17',1,'491271','','5',2000.00,'231','','','6','Kaduna Service Station ','491271',0.00,'2023-01-18 12:19:37',5,'Payment  Shortage #2000','877','','0000-00-00 00:00:00','1013','2023-01-18 12:25:27'),(349,'5','272','2023-01-21',1,'CNR0072','','5',500500.00,'235','','','6','Kaduna Service Station ','CNR0072',534195.20,'2023-01-23 15:36:49',5,'Payment for the Sales of 21/01/23','877','','0000-00-00 00:00:00','1013','2023-01-23 15:59:01'),(350,'5','272','2023-01-21',1,'CNR0072','','2',33700.00,'235','','','','','',0.00,'2023-01-23 15:38:21',5,'Gen AGO 33,700 ','877','','0000-00-00 00:00:00','1013','2023-01-23 15:58:46'),(351,'5','272','2023-01-22',1,'CNR0072','','5',1808150.00,'236','','','6','Kaduna Service Station ','0072',1843351.40,'2023-01-23 15:40:06',5,'Payment for the Sales of 22/01/23','877','','0000-00-00 00:00:00','1013','2023-01-23 16:00:32'),(352,'5','272','2023-01-22',1,'0072','','2',35200.00,'236','','','','','',0.00,'2023-01-23 15:41:33',5,'Gen AGO 33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-01-23 16:00:51'),(353,'5','272','2023-01-23',1,'CNR0031','','5',911760.00,'237','','','6','Kaduna Service Station ','CNR0031',946957.00,'2023-01-24 22:28:01',5,'Payment for the Sales of 23/01/23','877','','0000-00-00 00:00:00','1013','2023-01-25 09:36:13'),(354,'5','272','2023-01-23',1,'CNR','','2',35200.00,'237','','','','','',0.00,'2023-01-24 22:31:55',5,'Gen AGO 33,700 \r\nTransport 1,500','877','','0000-00-00 00:00:00','1013','2023-01-25 09:36:27'),(355,'5','272','2023-01-24',1,'CNR0054','','5',1831590.00,'238','','','6','Kaduna Service Station ','CNR0054',1866792.40,'2023-01-26 10:06:00',5,'Payment for the Sales of 24th ','877','','0000-00-00 00:00:00','1013','2023-01-26 10:11:07'),(356,'5','272','2023-01-24',1,'CNR0054','','2',35200.00,'238','','','','','',0.00,'2023-01-26 10:07:11',5,'Gen AGO  33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-01-26 10:11:33'),(358,'5','272','2023-01-25',1,'054','','5',35200.00,'249','','','6','Kaduna Service Station ','54',0.00,'2023-01-26 10:24:46',5,'Gen AGO  33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-01-27 10:53:23'),(359,'5','272','2023-01-26',1,'CNR0064','','5',1697000.00,'240','','','6','Kaduna Service Station ','CNR0064',1732203.00,'2023-01-27 15:48:50',5,'Payment for the Sales of 26th ','877','','0000-00-00 00:00:00','1013','2023-01-27 18:57:54'),(360,'5','272','2023-01-26',1,'CNR0064','','2',35200.00,'240','','','','','',0.00,'2023-01-27 15:49:49',5,'Gen AGO  33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-01-27 18:57:43'),(361,'5','272','2023-01-25',1,'CNR0050','','5',1742540.00,'239','','','6','Kaduna Service Station ','CNR0050',1777738.60,'2023-01-27 16:51:49',5,'Payment for the Sales of 25th ','877','','0000-00-00 00:00:00','1013','2023-01-27 18:57:20'),(362,'5','272','2023-01-27',1,'666294','','5',1198480.00,'241','','','6','Kaduna Service Station ','666294',1233674.20,'2023-01-28 10:49:42',5,'Payment for the Sales of 27th  01 23','877','','0000-00-00 00:00:00','1013','2023-01-28 18:56:05'),(363,'5','272','2023-01-27',1,'666294','','2',35200.00,'241','','','','','',0.00,'2023-01-28 10:50:33',5,'Gen AGO  33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-01-28 18:55:47'),(364,'5','272','2023-01-31',1,'755911','','5',573155.00,'245','','','6','Kaduna Service Station ','755911',608355.00,'2023-02-01 22:25:39',5,'Payment for the Sales of  31st  01 23','877','','0000-00-00 00:00:00','1013','2023-02-02 13:30:29'),(365,'5','272','2023-01-31',1,'755911','','2',35200.00,'245','','','','','',0.00,'2023-02-01 22:27:06',5,'Gen AGO 33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-02-02 13:29:44'),(366,'5','272','2023-02-01',1,'931915','','5',1452745.00,'246','','','6','Kaduna Service Station ','931915',1487945.80,'2023-02-02 13:59:57',5,'Payment for the Sales of 01/02/23','877','','0000-00-00 00:00:00','1013','2023-02-03 09:19:22'),(367,'5','272','2023-02-01',1,'931915','','2',35200.00,'246','','','','','',0.00,'2023-02-02 14:01:49',5,'Gen AGO 33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-02-03 09:19:05'),(368,'5','272','2023-02-02',1,'782101','','5',1618800.00,'247','','','6','Kaduna Service Station ','782101',1654008.40,'2023-02-03 11:39:39',5,'Payment for the Sales of 02/02/23','877','','0000-00-00 00:00:00','1013','2023-02-03 11:44:16'),(369,'5','272','2023-02-02',1,'782101','','2',35200.00,'247','','','','','',0.00,'2023-02-03 11:40:29',5,'Gen AGO 33,700 \r\nTransport  1500','877','','0000-00-00 00:00:00','1013','2023-02-03 11:44:32'),(370,'5','272','2023-02-06',1,'705010','','5',347070.00,'251','','','6','Kaduna Service Station ','705010',393969.40,'2023-02-07 15:36:57',5,'Payment for the Sales of  06/06/2023','877','','0000-00-00 00:00:00','1013','2023-02-08 09:38:26'),(371,'5','272','2023-02-06',1,'705010','','2',46900.00,'251','','','','','',0.00,'2023-02-07 15:38:21',5,'Gen AGO 33,700 \r\nTransport 1500\r\nMonthly Expenses 11,700','877','','0000-00-00 00:00:00','1013','2023-02-08 09:38:48'),(372,'5','272','2023-02-07',1,'169531','','5',1154170.00,'252','','','6','Kaduna Service Station ','169531',1189370.60,'2023-02-09 16:02:47',5,'Payment for the Sales of 7th 0223','877','','0000-00-00 00:00:00','1013','2023-02-09 16:45:33'),(373,'5','272','2023-02-07',1,'169531','','2',35200.00,'252','','','','','',0.00,'2023-02-09 16:03:56',5,'Gen AGO 33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-02-09 16:45:54'),(374,'5','272','2023-02-08',1,'993289','','5',413945.00,'253','','','6','Kaduna Service Station ','993289',449143.20,'2023-02-09 16:05:39',5,'Payment for the Sales of 8th 02 23','877','','0000-00-00 00:00:00','1013','2023-02-09 16:46:18'),(375,'5','272','2023-02-08',1,'993289','','2',35290.00,'253','','','','','',0.00,'2023-02-09 16:08:57',2,'Gen AGO  33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-02-09 16:56:30'),(376,'5','272','2023-02-08',1,'993289','','2',35200.00,'253','','','','','',0.00,'2023-02-10 22:40:48',5,'Gen AGO 33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-02-11 13:10:46'),(377,'5','272','2023-02-12',1,'023862','','5',413945.00,'257','','','6','Kaduna Service Station ','023862',449125.60,'2023-02-14 14:41:07',5,'Payment for the Sales of 12th 02 23','877','','0000-00-00 00:00:00','1013','2023-02-14 15:29:57'),(378,'5','272','2023-02-12',1,'023862','','2',35200.00,'257','','','','','',0.00,'2023-02-14 14:42:26',5,'Gen AGO  33,700 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-02-14 15:30:42'),(379,'5','272','2023-02-13',1,'459505','','5',159876.00,'258','','','6','Kaduna Service Station ','459505',804874.40,'2023-02-14 14:45:11',5,'Payment for the Sales of  13th 02 23','877','','0000-00-00 00:00:00','1013','2023-02-15 13:35:10'),(380,'5','272','2023-02-13',1,'459505','','2',645000.00,'258','','','','','',0.00,'2023-02-14 14:46:46',5,'Gen AGO 33,700 \r\nTransport 1500\r\nStation Maintenance 609,800','877','','0000-00-00 00:00:00','1013','2023-02-14 15:22:53'),(381,'5','272','2023-02-13',1,'040106','','5',124500.00,'258','','','6','Kaduna Service Station ','040106',0.00,'2023-02-16 16:33:52',5,'AGO Payment ','877','','0000-00-00 00:00:00','1013','2023-02-17 09:22:19'),(382,'5','272','2023-02-23',1,'327455','','5',2368855.00,'267','','','6','Kaduna Service Station ','327455',2793153.30,'2023-02-27 14:55:32',5,'Payment for the Sales of 23rd February 23','877','','0000-00-00 00:00:00','1013','2023-03-01 09:15:24'),(383,'5','272','2023-02-23',1,'327455','','2',424300.00,'267','','','','','',0.00,'2023-02-27 14:58:33',5,'Gen AGO 32,800\r\nTransport 1500\r\nStaffs Salary 330,000\r\nSokoto Salary 40,000\r\nPeter Labour 20,000','877','','0000-00-00 00:00:00','1013','2023-03-01 09:15:40'),(384,'5','272','2023-02-24',1,'491','','5',3117080.00,'268','','','6','Kaduna Service Station ','491',3160382.40,'2023-02-27 15:00:19',5,'Payment for the Sales of 24th February 23','877','','0000-00-00 00:00:00','1013','2023-03-01 09:15:51'),(385,'5','272','2023-02-24',1,'491','','2',43300.00,'268','','','','','',0.00,'2023-02-27 15:03:09',5,'Gen AGO 32,800\r\nDPO 50Ltrs PMS 10,500','877','','0000-00-00 00:00:00','1013','2023-03-01 09:16:02'),(386,'5','272','2023-02-26',1,'491','','5',3391130.00,'270','','','6','Kaduna Service Station ','0491',3425427.60,'2023-02-27 15:06:47',5,'Payment for the Sales of 26th February 23','877','','0000-00-00 00:00:00','1013','2023-03-01 09:16:19'),(387,'5','272','2023-02-27',1,'491','','2',34300.00,'270','','','','','',0.00,'2023-02-27 15:07:39',5,'Gen AGO  32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-01 09:16:38'),(388,'5','272','2023-02-27',1,'168589','','5',2618435.00,'271','','','6','Kaduna Service Station ','168589',2652734.70,'2023-02-28 14:39:05',5,'Payment for the Sales of 27th February 23','877','','0000-00-00 00:00:00','1013','2023-03-01 09:17:00'),(389,'5','272','2023-02-27',1,'168589','','2',34300.00,'271','','','','','',0.00,'2023-02-28 14:40:05',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-02 11:30:51'),(390,'5','272','2023-02-28',1,'735425','','5',3418425.00,'272','','','6','Kaduna Service Station ','735425',3452979.60,'2023-03-03 10:45:26',2,'Payment for the Sales of 28th February 23','877','','0000-00-00 00:00:00','1013','2023-03-03 11:39:38'),(391,'5','272','2023-02-28',1,'735425','','2',34300.00,'272','','','','','',0.00,'2023-03-03 10:46:46',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-03 11:39:57'),(392,'5','272','2023-03-01',1,'229949','','5',1636295.00,'273','','','6','Kaduna Service Station ','229949',1669245.90,'2023-03-03 10:48:15',2,'Payment for the Sales of 1st March 23','877','','0000-00-00 00:00:00','1013','2023-03-03 11:56:19'),(393,'5','272','2023-03-01',1,'229949','','2',34300.00,'273','','','','','',1669245.90,'2023-03-03 10:48:53',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-03 11:40:17'),(394,'5','272','2023-03-03',1,'735425','','5',3418680.00,'272','','','6','Kaduna Service Station ','35425',3452979.60,'2023-03-03 11:54:48',5,'Payment for the Sales of 28th February 23','877','','0000-00-00 00:00:00','1013','2023-03-03 12:03:21'),(395,'5','272','2023-03-01',1,'229949','','5',1634945.00,'273','','','6','Kaduna Service Station ','29949',1669245.90,'2023-03-03 11:56:41',5,'Payments for the Sales of 1st March 23','877','','0000-00-00 00:00:00','1013','2023-03-03 12:01:03'),(396,'5','272','2023-03-02',1,'111980','','5',2382070.00,'274','','','6','Kaduna Service Station ','111980',2428068.30,'2023-03-05 13:23:57',5,'Payment for the Sales of 2nd March 23','877','','0000-00-00 00:00:00','1013','2023-03-06 13:21:52'),(397,'5','272','2023-03-02',1,'111980','','2',46000.00,'274','','','','','',0.00,'2023-03-05 13:25:26',5,'Gen AGO 32,800 \r\nTransport 1500\r\nMonthly Expenses 11,700','877','','0000-00-00 00:00:00','1013','2023-03-06 13:21:40'),(398,'5','272','2023-03-03',1,'376210','','5',1434815.00,'275','','','6','Kaduna Service Station ','376210',1516315.50,'2023-03-06 08:43:50',5,'Payment for the Sales of 3rd March 23','877','','0000-00-00 00:00:00','1013','2023-03-06 13:21:27'),(399,'5','272','2023-03-03',1,'376210','','2',81500.00,'275','','','','','',0.00,'2023-03-06 08:45:51',5,'Gen AGO 32,800 \r\nTransport to Peter 10,000\r\nGen Service 38,700','877','','0000-00-00 00:00:00','1013','2023-03-06 13:21:16'),(400,'5','272','2023-03-04',1,'376210','','5',1689495.00,'276','','','6','Kaduna Service Station ','76210',1722294.00,'2023-03-06 08:47:30',5,'Payment for the Sales of 4th March 23','877','','0000-00-00 00:00:00','1013','2023-03-06 13:20:50'),(401,'5','272','2023-03-04',1,'376210','','2',32800.00,'276','','','','','',0.00,'2023-03-06 08:48:19',5,'Gen AGO 32,800 ','877','','0000-00-00 00:00:00','1013','2023-03-06 13:20:37'),(402,'5','272','2023-03-05',1,'376210','','5',645830.00,'277','','','6','Kaduna Service Station ','6210',680127.00,'2023-03-06 08:49:55',5,'Payment for the Sales of 5th March 23','877','','0000-00-00 00:00:00','1013','2023-03-06 13:20:19'),(403,'5','272','2023-03-05',1,'376210','','2',34300.00,'277','','','','','',0.00,'2023-03-06 08:51:14',5,'Gen AGO 32,800 \r\nTransport 1500\r\n','877','','0000-00-00 00:00:00','1013','2023-03-06 13:19:47'),(404,'5','272','2023-03-06',1,'651883','','5',299025.00,'278','','','6','Kaduna Service Station ','651883',333324.60,'2023-03-07 08:10:21',5,'Payment for the Sales of 6th March 23','877','','0000-00-00 00:00:00','1013','2023-03-07 09:24:40'),(405,'5','272','2023-03-06',1,'651883','','2',34300.00,'278','','','','','',0.00,'2023-03-07 08:11:04',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-07 09:25:13'),(406,'5','272','2023-03-07',1,'958652','','5',2060950.00,'278','','','6','Kaduna Service Station ','598652',2095247.70,'2023-03-08 13:58:39',5,'Payment for the Sales of 7th March 23','877','','0000-00-00 00:00:00','1013','2023-03-08 14:11:04'),(407,'5','272','2023-03-07',1,'598652','','2',34300.00,'279','','','','','',0.00,'2023-03-08 13:59:31',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-08 14:11:16'),(408,'5','272','2023-03-08',1,'239875','','5',239875.00,'280','','','6','Kaduna Service Station ','239875',2228763.60,'2023-03-10 10:46:33',0,'Payment for the Sales 0f 8th March 2023','877','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(409,'5','272','2023-03-08',1,'239875','','2',34300.00,'280','','','','','',2228763.60,'2023-03-10 10:47:23',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-10 12:16:04'),(410,'5','272','2023-03-09',1,'918617','','5',1699155.00,'281','','','6','Kaduna Service Station ','918617',1733455.50,'2023-03-10 11:08:27',5,'Payment for the Sales of 9th March 23','877','','0000-00-00 00:00:00','1013','2023-03-10 11:51:29'),(411,'5','272','2023-03-09',1,'918617','','2',34300.00,'281','','','','','',0.00,'2023-03-10 11:09:39',5,'Gen AGO 32,800 \r\nTransport 1500','877','','0000-00-00 00:00:00','1013','2023-03-10 11:48:53'),(412,'5','272','2023-02-13',1,'1234','','2',146500.00,'258','','','','','',0.00,'2023-03-10 11:15:56',5,'For 150L AGO Lost and 200L PMS Lost','877','','0000-00-00 00:00:00','1013','2023-03-10 11:47:32'),(413,'5','272','2023-02-23',1,'1234','','2',41000.00,'259','','','','','',0.00,'2023-03-10 11:18:16',5,'AGO Converted to PMS in Tank 1','877','','0000-00-00 00:00:00','1013','2023-03-10 11:48:29'),(414,'5','272','2023-03-08',1,'239875','','5',2194445.00,'280','','','6','Kaduna Service Station ','39875',2228742.60,'2023-03-13 07:32:27',5,'Payment for the Sales of 8th March w3','877','','0000-00-00 00:00:00','1013','2023-03-13 09:41:16'),(415,'5','272','2023-03-10',1,'419718','','5',2160240.00,'282','','','6','Kaduna Service Station ','419718',2197085.10,'2023-03-13 10:09:52',5,'Payment for the Sales of 10th March 23','877','','0000-00-00 00:00:00','1013','2023-03-13 13:39:58'),(416,'5','272','2023-03-10',1,'419718','','2',44800.00,'282','','','','','',0.00,'2023-03-13 10:11:58',5,'Gen AGO 32,800 \r\nTransport 1500\r\n50L PMS to DPO 10,500','877','','0000-00-00 00:00:00','1013','2023-03-13 13:39:46');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'5',2,'272',1,1,'2022-06-02 00:00:00','A A RANO',8500.00,8500.00,0.00,'Nil','','1','BCH 743XA','YAHYA RUFAI','0809','',5,'2022-06-02 11:57:34','600','0000-00-00 00:00:00','','2022-06-02 11:57:44','600'),(2,'5',2,'272',1,1,'2022-06-02 00:00:00','A A RANO',18650.00,18650.00,0.00,'Nil','','2','BCH 743XA','YAHYA RUFAI','0809','',5,'2022-06-02 11:57:34','600','0000-00-00 00:00:00','','2022-06-02 11:59:08','600'),(4,'5',3,'272',1,1,'2022-06-04 00:00:00','SALBAS',15200.00,15200.00,0.00,'2249','','2','LSD 736 XY','YUSUF GWANDU','07031020383','',5,'2022-06-04 17:05:57','877','0000-00-00 00:00:00','','2022-06-04 18:02:04','600'),(5,'5',4,'272',1,1,'2022-06-06 00:00:00','SALBAS',29500.00,29500.00,0.00,'2250','','1','KMC 37 XX','SANI RIDWAN','08032763790','',5,'2022-06-06 22:44:00','877','0000-00-00 00:00:00','','2022-06-06 23:18:08','606'),(6,'5',4,'272',1,1,'2022-06-06 00:00:00','SALBAS',15000.00,15000.00,0.00,'2250','','2','KMC 37 XX','SANI RIDWAN','08032763790','',5,'2022-06-06 22:44:00','877','0000-00-00 00:00:00','','2022-06-06 23:18:21','606'),(7,'5',5,'272',1,1,'2022-07-07 00:00:00','O\'GARA',22500.00,22500.00,0.00,'1709','','2','BCH 732 XA','AHMED SMALL','08066714939','',5,'2022-07-07 20:23:12','877','0000-00-00 00:00:00','','2022-07-07 21:59:35','606'),(8,'5',6,'272',1,1,'2022-07-14 00:00:00','Salbas',26000.00,26000.00,0.00,'1712','','1','TRN 176 ZG','Isiaku Abubakar ','','',5,'2022-07-14 22:05:03','877','0000-00-00 00:00:00','','2022-07-14 22:12:59','606'),(9,'5',6,'272',1,1,'2022-07-14 00:00:00','Salbas',14000.00,14000.00,0.00,'1712','','2','TRN 176 ZG','Isiaku Abubakar ','','',5,'2022-07-14 22:05:03','877','0000-00-00 00:00:00','','2022-07-14 22:12:32','606'),(10,'5',7,'272',1,1,'2022-07-20 00:00:00','O\'GARA',30000.00,30000.00,0.00,'1715','','1','LSD 602 XY','Abdullahi  Oduwa','08069093367','',5,'2022-07-20 11:38:56','877','0000-00-00 00:00:00','','2022-07-20 12:00:38','600'),(11,'5',7,'272',1,1,'2022-07-20 00:00:00','O\'GARA',29900.00,29900.00,0.00,'1715','','2','LSD 602 XY','Abdullahi  Oduwa','08069093367','',5,'2022-07-20 11:38:56','877','0000-00-00 00:00:00','','2022-07-20 12:00:28','600'),(12,'5',8,'272',1,1,'2022-07-23 00:00:00','O\'GARA',27100.00,27100.00,0.00,'1715','','1','RAN 551 XA','Sani Abdullahi','07033293166','',5,'2022-07-23 20:55:55','877','0000-00-00 00:00:00','','2022-07-24 07:05:41','606'),(13,'5',8,'272',1,1,'2022-07-23 00:00:00','O\'GARA',13000.00,13000.00,0.00,'1715','','2','RAN 551 XA','Sani Abdullahi','07033293166','',5,'2022-07-23 20:55:55','877','0000-00-00 00:00:00','','2022-07-24 07:05:53','606'),(14,'5',9,'272',1,1,'2022-08-01 00:00:00','O\'GARA',11900.00,11900.00,0.00,'1716','','1','KMC 140 YJ','Auwal Yahaya','08064300885','',5,'2022-08-01 21:26:04','877','0000-00-00 00:00:00','','2022-08-01 21:29:43','606'),(15,'5',9,'272',1,1,'2022-08-01 00:00:00','O\'GARA',28000.00,28000.00,0.00,'1716','','2','KMC 140 YJ','Auwal Yahaya','08064300885','',5,'2022-08-01 21:26:04','877','0000-00-00 00:00:00','','2022-08-01 21:29:54','606'),(16,'5',10,'272',1,1,'2022-08-04 00:00:00','O\'GARA',28400.00,28400.00,0.00,'1718','','1','KMC 38 XX ','Najib Aliyu','07063637033','',5,'2022-08-04 18:17:49','877','0000-00-00 00:00:00','','2022-08-04 20:04:17','606'),(17,'5',10,'272',1,1,'2022-08-04 00:00:00','O\'GARA',16000.00,16000.00,0.00,'1718','','2','KMC 38 XX ','Najib Aliyu','07063637033','',5,'2022-08-04 18:17:49','877','0000-00-00 00:00:00','','2022-08-04 20:04:29','606'),(18,'5',11,'272',1,1,'2022-09-06 00:00:00','O\'GARA',27330.00,27330.00,0.00,'1719','','1','RBC 92 XC','','','',5,'2022-09-06 12:18:16','877','0000-00-00 00:00:00','','2022-09-06 12:20:13','606'),(19,'5',11,'272',1,1,'2022-09-06 00:00:00','O\'GARA',5400.00,5400.00,0.00,'1719','','2','RBC 92 XC','','','',5,'2022-09-06 12:18:16','877','0000-00-00 00:00:00','','2022-09-06 12:20:05','606'),(20,'5',12,'272',1,1,'2022-09-06 00:00:00','MAWO LAGOS',14300.00,14300.00,0.00,'1720','','1','MKA 795 ZU','BABA TASI','09161920340','',5,'2022-09-06 13:10:28','877','0000-00-00 00:00:00','','2022-09-06 13:22:42','606'),(21,'5',12,'272',1,1,'2022-09-06 00:00:00','MAWO LAGOS',30000.00,30000.00,0.00,'1720','','2','MKA 795 ZU','BABA TASI','09161920340','',5,'2022-09-06 13:10:28','877','0000-00-00 00:00:00','','2022-09-06 13:22:34','606'),(22,'5',13,'272',1,1,'2022-09-06 00:00:00','O\'GARA',30900.00,30900.00,0.00,'1720','','1','GWL 66 YS','','','',5,'2022-09-06 14:23:30','877','0000-00-00 00:00:00','','2022-09-06 14:25:44','606'),(23,'5',13,'272',1,1,'2022-09-06 00:00:00','O\'GARA',8650.00,8650.00,0.00,'1720','','2','GWL 66 YS','','','',5,'2022-09-06 14:23:30','877','0000-00-00 00:00:00','','2022-09-06 14:25:35','606'),(24,'5',16,'272',1,1,'2022-09-06 00:00:00','MAWO LAGOS',30300.00,30300.00,0.00,'1725','','1','LSD 763 XG','ADAMU JUBRIL','08066616980','',5,'2022-09-06 15:31:11','877','0000-00-00 00:00:00','','2022-09-06 15:33:58','606'),(25,'5',16,'272',1,1,'2022-09-06 00:00:00','MAWO LAGOS',29700.00,29700.00,0.00,'1725','','2','LSD 763 XG','ADAMU JUBRIL','08066616980','',5,'2022-09-06 15:31:11','877','0000-00-00 00:00:00','','2022-09-06 15:34:06','606'),(30,'5',17,'272',1,1,'2022-09-08 00:00:00','SALBAS',28100.00,28100.00,0.00,'1723','','1','RBC 897 XC','UMAR ABUBAKAR','08034949507','',5,'2022-09-08 12:49:27','877','0000-00-00 00:00:00','','2022-09-08 13:23:24','606'),(31,'5',17,'272',1,1,'2022-09-08 00:00:00','SALBAS',21502.00,21502.00,0.00,'1723','','2','RBC 897 XC','UMAR ABUBAKAR','08034949507','',5,'2022-09-08 12:49:27','877','0000-00-00 00:00:00','','2022-09-08 13:23:15','606'),(32,'5',18,'272',1,1,'2022-09-08 00:00:00','PARKER OIL',22400.00,22400.00,0.00,'1726','','1','RAN 552 XA','HABIBU ODUWA','08084425810','',5,'2022-09-08 14:14:02','877','0000-00-00 00:00:00','','2022-09-08 14:19:23','606'),(33,'5',18,'272',1,1,'2022-09-08 00:00:00','PARKER OIL',17150.00,1715.00,0.00,'1726','','2','RAN 552 XA','HABIBU ODUWA','08084425810','',5,'2022-09-08 14:14:02','877','0000-00-00 00:00:00','','2022-09-08 14:19:15','606'),(34,'5',19,'272',1,1,'2022-09-08 00:00:00','SALBAS',15100.00,15100.00,0.00,'1729','','1','KMC 35 XX','','08138376432','',5,'2022-09-08 16:31:05','877','0000-00-00 00:00:00','','2022-09-08 16:33:42','606'),(35,'5',19,'272',1,1,'2022-09-08 00:00:00','SALBAS',29300.00,29300.00,0.00,'1729','','2','KMC 35 XX','','08138376432','',5,'2022-09-08 16:31:05','877','0000-00-00 00:00:00','','2022-09-08 16:33:24','606'),(36,'5',20,'272',1,1,'2022-09-08 00:00:00','O\'GARA',29300.00,29300.00,0.00,'1730','','1','KMC 144 YT','RABIU','08068844412','',5,'2022-09-08 17:00:46','877','0000-00-00 00:00:00','','2022-09-20 15:25:12','600'),(37,'5',20,'272',1,1,'2022-09-08 00:00:00','O\'GARA',15150.00,15150.00,0.00,'1730','','2','KMC 144 YT','RABIU','08068844412','',5,'2022-09-08 17:00:46','877','0000-00-00 00:00:00','','2022-09-20 15:25:12','600'),(38,'5',21,'272',1,1,'2022-09-26 00:00:00','SALBAS',13100.00,13100.00,0.00,'1731','','1','RAN 551 XA','Sani','09062864783','',5,'2022-09-26 14:51:29','877','0000-00-00 00:00:00','','2022-09-26 14:56:36','606'),(39,'5',21,'272',1,1,'2022-09-26 00:00:00','SALBAS',27000.00,27000.00,0.00,'1731','','2','RAN 551 XA','Sani','09062864783','',5,'2022-09-26 14:51:29','877','0000-00-00 00:00:00','','2022-09-26 14:56:23','606'),(40,'5',22,'272',1,1,'2022-09-26 00:00:00','A.A RANO',27000.00,27000.00,0.00,'1734','','2','NSR 34 ZU','DA','07030658000','',5,'2022-09-26 15:57:14','877','0000-00-00 00:00:00','','2022-09-26 16:04:06','606'),(41,'5',22,'272',1,1,'2022-09-26 00:00:00','A.A RANO',12750.00,12750.00,0.00,'1734','','2','NSR 34 ZU','DA','07030658000','',5,'2022-09-26 16:10:47','877','0000-00-00 00:00:00','','2022-09-26 16:12:10','606'),(42,'5',23,'272',1,1,'2022-09-26 00:00:00','A.A RANO',29540.00,29540.00,0.00,'1735','','1','RBC 996 XC','Abdul','08034096367','',5,'2022-09-26 16:35:20','877','0000-00-00 00:00:00','','2022-09-26 16:39:51','606'),(43,'5',23,'272',1,1,'2022-09-26 00:00:00','A.A RANO',14850.00,14850.00,0.00,'1735','','2','RBC 996 XC','Abdul','08034096367','',5,'2022-09-26 16:35:20','877','0000-00-00 00:00:00','','2022-09-26 16:39:29','606'),(45,'5',24,'272',1,1,'2022-09-26 00:00:00','O\'GARA',26000.00,26000.00,0.00,'1739','','2','RAN 663 XA','Shehu Aliyu ','07030658000','',5,'2022-09-26 17:16:54','877','0000-00-00 00:00:00','','2022-09-26 18:04:10','606'),(46,'5',24,'272',1,1,'2022-09-26 00:00:00','O\'GARA',6000.00,6000.00,0.00,'1739','','2','RAN 663 XA','Shehu Aliyu ','07030658000','',5,'2022-09-26 18:18:01','877','0000-00-00 00:00:00','','2022-09-26 18:23:08','606'),(47,'5',24,'272',1,1,'2022-09-26 00:00:00','O\'GARA',8000.00,8000.00,0.00,'1739','','2','RAN 663 XA','Shehu Aliyu ','07030658000','',5,'2022-09-26 18:26:44','877','0000-00-00 00:00:00','','2022-09-26 18:30:52','606'),(48,'5',25,'272',1,1,'2022-09-28 00:00:00','O\'GARA',30000.00,30000.00,0.00,'1737','','2','KMC 138 YT','ABDULLAHI YAWURI','08162784233','',5,'2022-09-28 21:11:04','877','0000-00-00 00:00:00','','2022-09-28 21:42:00','606'),(49,'5',25,'272',1,1,'2022-09-30 00:00:00','O\'GARA',14800.00,14800.00,0.00,'1737','','2','KMC 138 YT','ABDULLAHI YAWURI','08162784233','',5,'2022-09-30 17:39:00','877','0000-00-00 00:00:00','','2022-09-30 19:30:19','606'),(50,'5',26,'272',1,1,'2022-10-01 00:00:00','O\'GARA',26650.00,26650.00,0.00,'1742','','2','RAN 551 XA','Sani','09062864783','',5,'2022-10-01 22:16:47','877','0000-00-00 00:00:00','','2022-10-02 07:36:09','606'),(51,'5',28,'272',1,1,'2022-10-04 00:00:00','O\'GARA',13250.00,13250.00,0.00,'1742','','2','RAN 551 XA','Sani','09062864783','',5,'2022-10-04 12:48:04','877','0000-00-00 00:00:00','','2022-10-04 13:04:49','606'),(52,'5',29,'272',1,1,'2022-10-12 00:00:00','Calabar ',26000.00,26000.00,0.00,'2003','','2','BCH 733 XA','Sale Adamu','07033389889','',5,'2022-10-12 14:40:55','877','0000-00-00 00:00:00','','2022-10-12 14:42:08','606'),(53,'5',29,'272',1,1,'2022-10-12 00:00:00','Calabar ',24000.00,24000.00,0.00,'2003','','2','BCH 733 XA','Sale Adamu','07033389889','',5,'2022-10-12 22:47:12','877','0000-00-00 00:00:00','','2022-10-12 23:14:12','606'),(54,'5',30,'272',1,1,'2022-10-15 00:00:00','Calabar ',31000.00,31000.00,0.00,'2016','','2','RBC 352 XG','Lawan Maraba','08038323996','',5,'2022-10-15 21:33:36','877','0000-00-00 00:00:00','','2022-10-15 21:38:52','606'),(55,'5',30,'272',1,1,'2022-10-16 00:00:00','Calabar ',18900.00,18900.00,0.00,'2016','','2','RBC 352 XG','Lawan Maraba','08038323996','',5,'2022-10-16 20:39:18','877','0000-00-00 00:00:00','','2022-10-16 20:42:36','606'),(56,'5',31,'272',1,1,'2022-10-19 00:00:00','A.A RANO',29000.00,29000.00,0.00,'2025','','2','LSD 769 XY','Alhaji Aji','08037214669','',5,'2022-10-19 11:40:15','877','0000-00-00 00:00:00','','2022-10-19 11:42:31','606'),(57,'5',31,'272',1,1,'2022-10-19 00:00:00','Calabar ',13000.00,13000.00,0.00,'2025','','2','LSD 769 XY','Alhaji Aji','08037214669','',5,'2022-10-19 20:18:26','877','0000-00-00 00:00:00','','2022-10-19 20:22:14','606'),(58,'5',31,'272',1,1,'2022-10-20 00:00:00','A.A RANO',17910.00,17910.00,0.00,'2025','','2','LSD 769 XY','Alhaji Aji','08037214669','',5,'2022-10-20 18:37:41','877','0000-00-00 00:00:00','','2022-10-20 20:32:22','606'),(59,'5',32,'272',1,1,'2022-10-29 00:00:00','O\'GARA',30000.00,30000.00,0.00,'2036','','2','RBC 996 XC','Abdullahi ','08034096367','',5,'2022-10-29 21:59:13','877','0000-00-00 00:00:00','','2022-10-29 22:01:50','606'),(60,'5',32,'272',1,1,'2022-10-30 00:00:00','O\'GARA',14870.00,14870.00,0.00,'2036','','2','RBC 996 XC','Abdullahi ','08034096367','',5,'2022-10-30 19:03:23','877','0000-00-00 00:00:00','','2022-10-31 07:00:00','606'),(61,'5',33,'272',1,1,'2022-11-13 00:00:00','Rain oil ',30000.00,30000.00,0.00,'1676','','2','BHC 739 XA','Yusuf Ibrahim ','08064761380','',5,'2022-11-13 22:09:05','877','0000-00-00 00:00:00','','2022-11-14 02:19:50','606'),(62,'5',33,'272',1,1,'2022-11-14 00:00:00','Rain oil ',15000.00,15000.00,0.00,'1676','','2','BHC 739 XA','Yusuf Ibrahim ','08064761380','',5,'2022-11-14 12:38:10','877','0000-00-00 00:00:00','','2022-11-14 12:44:10','606'),(63,'5',34,'272',1,1,'2022-11-21 00:00:00','A and E Warri',14000.00,14000.00,0.00,'1689','','1','KMC 136 YT','Saleh Gajere','','PMS Discharge',5,'2022-11-21 15:51:15','877','0000-00-00 00:00:00','','2022-11-21 15:59:55','606'),(64,'5',35,'272',1,1,'2022-11-23 00:00:00','A and E Warri',26370.00,26370.00,0.00,'1687','','2','NSR 219 ZQ','Ahmad Officer','','PMS Discharge',5,'2022-11-23 15:38:05','877','0000-00-00 00:00:00','','2022-11-23 16:04:52','606'),(65,'5',35,'272',1,1,'2022-11-23 00:00:00','A and E Warri',13500.00,13500.00,0.00,'1687','','2','NSR 219 ZQ','Ahmad Officer','','PMS Discharge',5,'2022-11-23 21:52:29','877','0000-00-00 00:00:00','','2022-11-23 22:07:25','606'),(66,'5',36,'272',1,1,'2022-11-24 00:00:00','A and E Warri',29800.00,29800.00,0.00,'2350','','2','BCH 742 XA','Adamu Soja','','PMS Discharge',5,'2022-11-24 22:23:02','877','0000-00-00 00:00:00','','2022-11-24 22:53:25','606'),(67,'5',36,'272',1,1,'2022-11-25 00:00:00','A and E Warri',14850.00,14850.00,0.00,'2350','','2','BCH 742 XA','Adamu Soja','','PMS Discharge',5,'2022-11-25 21:21:22','877','0000-00-00 00:00:00','','2022-11-25 21:29:55','606'),(68,'5',37,'272',1,1,'2022-11-27 00:00:00','A and E Warri',25800.00,25800.00,0.00,'2361','','2','KMC 140 YT','','','PMS Discharge',5,'2022-11-27 21:38:40','877','0000-00-00 00:00:00','','2022-11-27 22:02:49','606'),(69,'5',37,'272',1,1,'2022-11-28 00:00:00','A and E Warri',14000.00,14000.00,0.00,'2361','','2','KMC 140 YT','','','PMS Discharge',5,'2022-11-28 06:36:32','877','0000-00-00 00:00:00','','2022-11-28 07:02:08','606'),(70,'5',38,'272',1,1,'2022-11-29 00:00:00','Ogare',22500.00,22500.00,0.00,'2363','','2','BCH 732 XA','','','PMS Discharge',5,'2022-11-29 19:18:37','877','0000-00-00 00:00:00','','2022-11-29 20:04:18','606'),(71,'5',38,'272',1,1,'2022-11-30 00:00:00','Ogare',22500.00,22500.00,0.00,'2363','','2','BCH 732 XA','Ahmad ','','PMS Discharge',5,'2022-11-30 08:43:07','877','0000-00-00 00:00:00','','2022-11-30 09:16:43','606'),(72,'5',39,'272',1,1,'2022-12-01 00:00:00','Ogare',26500.00,26500.00,0.00,'2377','','2','NSR 220 ZQ','','','PMS Discharge',5,'2022-12-01 22:41:20','877','0000-00-00 00:00:00','','2022-12-02 06:25:08','606'),(73,'5',39,'272',1,1,'2022-12-02 00:00:00','Ogare',13300.00,13300.00,0.00,'2377','','2','NSR 220 ZQ','','','PMS Discharge',5,'2022-12-02 08:10:08','877','0000-00-00 00:00:00','','2022-12-02 10:08:13','606'),(74,'5',40,'272',1,1,'2022-12-03 00:00:00','Ogare',15200.00,15200.00,0.00,'2382','','2','RBC 604 XF','','','PMS Discharge',5,'2022-12-03 20:46:50','877','0000-00-00 00:00:00','','2022-12-03 21:50:54','606'),(75,'5',40,'272',1,1,'2022-12-04 00:00:00','Ogare',29800.00,29800.00,0.00,'2382','','2','RBC 604 XF','','','PMS Discharge',5,'2022-12-04 14:50:13','877','0000-00-00 00:00:00','','2022-12-04 15:13:21','606'),(76,'5',41,'272',1,1,'2022-12-06 00:00:00','Ogare',15000.00,15000.00,0.00,'2383','','2','RBC 593 XF','','','PMS Discharge',5,'2022-12-06 08:16:28','877','0000-00-00 00:00:00','','2022-12-07 08:28:40','606'),(77,'5',43,'272',1,1,'2023-01-15 00:00:00','A and E Warri',30000.00,30000.00,0.00,'1252','','2','LSD 178 XM','Ubayyu','','PMS Discharge ',5,'2023-01-15 17:41:21','877','0000-00-00 00:00:00','','2023-01-15 18:15:39','606'),(78,'5',43,'272',1,1,'2023-01-16 00:00:00','A and E Warri',14850.00,14850.00,0.00,'','','2','LSD 178 XM','Ubayyu','','PMS Discharge ',5,'2023-01-16 13:45:15','877','0000-00-00 00:00:00','','2023-01-16 14:14:31','606'),(79,'5',44,'272',1,1,'2023-01-22 00:00:00','A and E Warri',15200.00,15200.00,0.00,'2385','','2','RSH 420 XE','Jamilu','','PMS Discharge ',5,'2023-01-22 10:41:08','877','0000-00-00 00:00:00','','2023-01-22 11:40:13','606'),(80,'5',45,'272',1,1,'2023-01-24 00:00:00','A and E Warri',30000.00,30000.00,0.00,'1254','','2','RBC 988 XC','','','PMS Discharge ',5,'2023-01-24 13:33:52','877','0000-00-00 00:00:00','','2023-01-24 15:04:25','606'),(81,'5',46,'272',1,1,'2023-01-31 00:00:00','Ever Green',17000.00,17000.00,0.00,'2385','','2','RSH278 XF','Alhaji Rabiu','','PMS Discharge ',5,'2023-01-31 21:36:20','877','0000-00-00 00:00:00','','2023-02-01 07:41:18','606'),(82,'5',47,'272',1,1,'2023-02-07 00:00:00','Ogara',15000.00,15000.00,0.00,'1256','','2','KMC 63 YS','Sani','','PMS Discharge ',5,'2023-02-07 14:57:41','877','0000-00-00 00:00:00','','2023-02-07 15:17:20','606'),(83,'5',48,'272',1,1,'2023-02-25 00:00:00','Ogara',15000.00,15000.00,0.00,'1253','','1','LSD 602 XE','Abdullahi','','PMS Discharge ',5,'2023-02-25 12:48:42','877','0000-00-00 00:00:00','','2023-02-25 13:34:34','606'),(84,'5',48,'272',1,1,'2023-02-25 00:00:00','Ogara',15000.00,15000.00,0.00,'1253','','2','LSD 602 XE','Abdullahi','','PMS Discharge ',5,'2023-02-25 12:48:42','877','0000-00-00 00:00:00','','2023-02-25 13:34:45','606'),(85,'5',49,'272',1,1,'2023-02-27 00:00:00','Ogara',14950.00,14950.00,0.00,'1261','','1','RSH 422 XE','','','PMS Discharge ',5,'2023-02-27 11:03:24','877','0000-00-00 00:00:00','','2023-02-27 18:02:47','606'),(86,'5',49,'272',1,1,'2023-02-27 00:00:00','Ogara',30000.00,30000.00,0.00,'1261','','2','RSH 422 XE','','','PMS Discharge ',5,'2023-02-27 11:03:24','877','0000-00-00 00:00:00','','2023-02-27 18:02:36','606'),(87,'5',50,'272',1,1,'2023-03-01 00:00:00','Ogara',13300.00,13300.00,0.00,'1262','','1','KMC 34 XX','','','PMS Discharge ',5,'2023-03-01 09:40:09','877','0000-00-00 00:00:00','','2023-03-01 09:54:55','606'),(88,'5',50,'272',1,1,'2023-03-01 00:00:00','Ogara',13500.00,13500.00,0.00,'1262','','2','KMC 34 XX','','','PMS Discharge ',5,'2023-03-01 09:40:09','877','0000-00-00 00:00:00','','2023-03-01 09:55:02','606'),(89,'5',50,'272',1,1,'2023-03-03 00:00:00','Ogara',12300.00,12300.00,0.00,'1262','','2','KMC 34 XX','','','PMS Discharge ',5,'2023-03-03 10:36:24','877','0000-00-00 00:00:00','','2023-03-03 11:29:02','606'),(90,'5',51,'272',1,1,'2023-03-08 00:00:00','Ogara',13500.00,13500.00,0.00,'1263','','1','TRN 182 ZG','','','PMS Discharge ',5,'2023-03-08 08:14:36','877','0000-00-00 00:00:00','','2023-03-08 08:26:11','606'),(91,'5',51,'272',1,1,'2023-03-08 00:00:00','Ogara',26500.00,26500.00,0.00,'1263','','2','TRN 182 ZG','','','PMS Discharge ',5,'2023-03-08 08:14:36','877','0000-00-00 00:00:00','','2023-03-08 08:26:24','606');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'5','272','SALBAS OIL AND GAS LTD','USMAN IT','08069090514','usman.shehu@salbasoilandgas.co','Kano','Kano','UNGUWAR RIMI JUNCTION, NAIBAWA KANO','Nigeria',0.00,0.00,'0000-00-00','2022-06-02 11:20:29',5,'600','2022-06-02 11:40:29','877');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:42
