-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_271
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_271`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_271` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_271`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','5','271','PUBLIC RELATION','','2022-06-02 16:36:30',5,0.00,0.00,'','446','2022-06-02 16:36:30','446',0,0),(2,8001,'',0,'24','5','271','PURCHASES','','2022-06-02 16:36:55',5,0.00,0.00,'','446','2022-06-02 16:36:55','446',0,0),(3,8002,'',0,'24','5','271','SALARIES & WAGES','','2022-06-02 16:37:27',5,0.00,0.00,'','446','2022-06-02 16:37:27','446',0,0),(4,500,'',0,'6.1','5','271','CASH','','2022-06-02 16:37:42',5,0.00,0.00,'','446','2022-06-02 16:37:42','446',0,0),(5,8003,'',0,'24','5','271','DISIEL INTERNAL CONSUMPTION','','2022-06-02 16:38:08',5,0.00,0.00,'','446','2022-06-02 16:38:08','446',0,0),(6,8004,'',0,'24','5','271','CLEANING ANDSANITARY ITEMS','','2022-06-02 16:38:36',5,0.00,0.00,'','446','2022-06-02 16:38:36','446',0,0),(7,8005,'',0,'24','5','271','TRANSPORT FARE','','2022-06-02 16:38:53',5,0.00,0.00,'','446','2022-06-02 16:38:53','446',0,0),(8,8006,'',0,'24','5','271','OTHER OPERATING EXPENSES','','2022-06-02 16:39:40',5,0.00,0.00,'','446','2022-06-02 16:39:40','446',0,0),(9,8007,'',0,'24','5','271','GENERATOR REPAIRS AND MENTAINA','','2022-06-02 16:40:09',5,0.00,0.00,'','446','2022-06-02 16:40:09','446',0,0),(10,8008,'',0,'24','5','271','PUMP REPAIRS ANDMAINTAINANCE','','2022-06-02 16:40:38',5,0.00,0.00,'','446','2022-06-02 16:40:38','446',0,0),(11,2500,'',0,'2','5','271','0001950815-TAJ','','2022-06-03 13:48:09',5,0.00,0.00,'','600','2022-06-03 13:48:09','600',0,0),(12,7000,'',0,'20','5','271','SALES','','2022-06-03 13:53:56',5,0.00,0.00,'','891','2022-06-03 13:53:56','891',0,0),(13,2000,'',0,'6','5','271','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:06:18',5,0.00,0.00,'','600','2023-02-06 10:06:18','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','271','0000-00-00','2023-02-06 10:08:35',10,'600','','0000-00-00 00:00:00','600','2023-02-06 10:10:17'),(2,'5','271','0000-00-00','2023-02-06 10:43:01',10,'600','','0000-00-00 00:00:00','600','2023-02-06 10:45:37'),(3,'5','271','0000-00-00','2023-02-20 12:06:34',10,'600','','0000-00-00 00:00:00','600','2023-02-20 12:09:55'),(4,'5','271','0000-00-00','2023-02-20 12:12:26',10,'600','','0000-00-00 00:00:00','600','2023-02-20 12:14:18');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','271','1','13','6',0.00,'PMS Price Icrease(185 to 220 x 4,300 litrs',150500.00,'2023-02-06'),(2,'5','271','1','1','supplier',150500.00,'PMS Price Icrease(185 to 220 x 4,300 litrs) 20/1/2023',0.00,'2023-02-06'),(3,'5','271','2','1','supplier',0.00,'AGO Price Decrease(860 to 830 x 22,350 litrs) 13/1/2023',670500.00,'2023-02-06'),(4,'5','271','2','13','6',670500.00,'AGO Price Decrease(860 to 830 x 22,350 litrs) 13/1/2023',0.00,'2023-02-06'),(6,'5','271','3','13','6',22500.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 2,250',0.00,'2023-02-19'),(7,'5','271','3','1','supplier',0.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 2,250LTRS',22500.00,'2023-02-20'),(8,'5','271','4','1','supplier',0.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 29,850Ltrs',298500.00,'2023-02-20'),(9,'5','271','4','13','6',298500.00,'AGO PRICE DECREASE FROM 830 820 DIPPING 29,850Ltrs',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','271',1,'1',0.00,9950.00,'2022-06-01','','2022-06-06 09:50:41','600','600',2022,'600','2022-06-06 09:50:41',5),('5','271',2,'2',0.00,7100.00,'2022-06-01','','2022-06-06 09:51:15','600','600',2022,'600','2022-06-06 09:51:15',5),('5','271',3,'3',0.00,14500.00,'2022-06-01','','2022-06-06 09:51:49','600','600',2022,'600','2022-06-06 09:51:49',5),('5','271',4,'4',0.00,650.00,'2022-06-01','','2022-06-06 09:52:11','600','600',2022,'600','2022-06-06 09:52:11',5),('5','271',5,'5',0.00,250.00,'2022-06-01','','2022-06-06 09:52:30','600','600',2022,'600','2022-06-06 09:52:30',5),('5','271',6,'1',9950.00,10.00,'2022-06-07','','2022-06-07 09:44:26','600','600',2022,'600','2022-06-07 09:44:26',5),('5','271',7,'2',7100.00,1.00,'2022-06-07','','2022-06-07 09:44:41','600','600',2022,'600','2022-06-07 09:44:41',5),('5','271',8,'1',10.00,1.00,'2022-06-07','','2022-06-07 09:44:54','600','600',2022,'600','2022-06-07 09:44:54',5),('5','271',9,'3',14500.00,1.00,'2022-06-07','','2022-06-07 09:45:07','600','600',2022,'600','2022-06-07 09:45:07',5),('5','271',10,'5',476.47,1500.00,'2022-08-02','','2022-08-02 14:48:11','600','600',2022,'600','2022-08-02 14:48:11',5),('5','271',11,'2',13316.54,12500.00,'2022-11-17','','2022-11-17 11:07:56','600','600',2022,'600','2022-11-17 11:07:56',5),('5','271',12,'2',12500.00,30000.00,'2022-11-17','','2022-11-17 11:28:48','600','600',2022,'600','2022-11-17 11:28:48',5),('5','271',13,'4',10148.68,30000.00,'2022-11-24','','2022-11-24 12:10:40','600','600',2022,'600','2022-11-24 12:10:40',5),('5','271',14,'2',11137.48,30000.00,'2022-11-24','','2022-11-24 17:41:24','600','600',2022,'600','2022-11-24 17:41:24',5),('5','271',15,'3',6779.52,10000.00,'2022-11-24','','2022-11-24 18:42:49','600','600',2022,'600','2022-11-24 18:42:49',5),('5','271',16,'5',1693.22,2750.00,'2022-12-01','','2022-12-01 16:43:33','600','600',2022,'600','2022-12-01 16:43:33',5),('5','271',17,'1',2397.27,450.00,'2023-01-10','','2023-01-10 09:06:21','600','600',2023,'600','2023-01-10 09:06:21',5),('5','271',18,'2',8013.77,400.00,'2023-01-10','','2023-01-10 09:06:34','600','600',2023,'600','2023-01-10 09:06:34',5),('5','271',19,'3',7888.29,550.00,'2023-01-10','','2023-01-10 09:06:50','600','600',2023,'600','2023-01-10 09:06:50',5),('5','271',20,'4',13483.35,650.00,'2023-01-10','','2023-01-10 09:07:03','600','600',2023,'600','2023-01-10 09:07:03',5),('5','271',21,'1',1070.32,1250.00,'2023-01-27','','2023-01-27 15:10:43','600','600',2023,'600','2023-01-27 15:10:43',5),('5','271',22,'2',4065.26,4500.00,'2023-02-22','','2023-02-22 14:04:50','600','600',2023,'600','2023-02-22 14:04:50',5),('5','271',23,'2',42671.35,43700.00,'2023-03-10','','2023-03-10 11:05:48','600','600',2023,'600','2023-03-10 11:05:48',5),('5','271',24,'4',13649.71,14200.00,'2023-03-10','','2023-03-10 21:45:46','600','600',2023,'600','2023-03-10 21:45:46',5),('5','271',25,'1',2475.85,3500.00,'2023-03-10','','2023-03-10 21:46:34','600','600',2023,'600','2023-03-10 21:46:34',5),('5','271',26,'2',18532.30,19500.00,'2023-03-10','','2023-03-10 22:05:39','600','600',2023,'600','2023-03-10 22:05:39',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','271','1',1,'5','PUMP 1',29963.53,'PMS PUMP 1','',NULL,NULL,'',5,'2022-06-07 09:18:19','600'),('5','271','1',2,'5','PUMP 2',543847.09,'PMS PUMP 2','',NULL,NULL,'',5,'2022-06-07 09:18:43','600'),('5','271','1',3,'5','PUMP 3',565235.40,'PMS PUMP 3','',NULL,NULL,'',5,'2022-06-07 09:19:12','600'),('5','271','1',4,'5','PUMP 4',5339.39,'PMS PUMP 4','',NULL,NULL,'',5,'2022-06-07 09:19:56','600'),('5','271','1',5,'5','PUM 5',27488.50,'PMS PUMP 5','',NULL,NULL,'',5,'2022-06-07 09:20:31','600'),('5','271','1',6,'5','PUMP 6',724789.75,'PMS PUMP 6','',NULL,NULL,'',5,'2022-06-07 09:21:05','600'),('5','271','2',7,'5','PUMP 7',555881.38,'PMS PUMP 7','',NULL,NULL,'',5,'2022-06-07 09:22:10','600'),('5','271','2',8,'5','PUMP 8',23697.10,'PMS PUMP 8','',NULL,NULL,'',5,'2022-06-07 09:22:36','600'),('5','271','2',9,'5','PUMP 15',992443.84,'PMS PUMP 15','',NULL,NULL,'',5,'2022-06-07 09:23:06','600'),('5','271','2',10,'5','PUMP 16',116406.44,'PMS PUMP 16','',NULL,NULL,'',5,'2022-06-07 09:23:35','600'),('5','271','2',11,'5','PUMP 19',324114.02,'PMS PUMP 19','',NULL,NULL,'',5,'2022-06-07 09:24:16','600'),('5','271','2',12,'5','PUMP 20',601423.07,'PMS PUMP 20','',NULL,NULL,'',5,'2022-06-07 09:24:52','600'),('5','271','3',13,'5','PUMP 9',467.89,'PMS PUMP9','',NULL,NULL,'',5,'2022-06-07 09:25:50','600'),('5','271','3',14,'5','PUMP 10',860161.57,'PMS PUMP 10','',NULL,NULL,'',5,'2022-06-07 09:26:22','600'),('5','271','3',15,'5','PUMP 17',94070.38,'PMS PUMP 17','',NULL,NULL,'',5,'2022-06-07 09:27:16','600'),('5','271','3',16,'5','PUMP 18',442902.63,'PMS PUMP 18','',NULL,NULL,'',5,'2022-06-07 09:28:05','600'),('5','271','4',17,'5','PUMP 11',20962.48,'PMS PUMP 11','',NULL,NULL,'',5,'2022-06-07 09:28:54','600'),('5','271','4',18,'5','PUMP 12',809107.59,'PMS PUMP 12','',NULL,NULL,'',5,'2022-06-07 09:29:24','600'),('5','271','4',19,'5','PUMP 13',367500.37,'PMS PUMP 13','',NULL,NULL,'',5,'2022-06-07 09:30:08','600'),('5','271','4',20,'5','PUMP 14',22182.96,'PMS PUMP 14','',NULL,NULL,'',5,'2022-06-07 09:30:38','600'),('5','271','5',21,'5','PUMP 21',150336.32,'AGO PUMP 21','',NULL,NULL,'',5,'2022-06-07 10:15:14','600'),('5','271','5',22,'5','PUMP 22',162936.89,'AGO PUM 22','',NULL,NULL,'',5,'2022-06-07 10:15:47','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=342 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','271',1,'daily','2022-06-02','2022-06-02 14:24:44','2022-06-03 14:24:44','891',0.00,0.00,'891','2022-06-03 12:46:02','600','2022-06-03 13:56:19',10,0),('5','271',2,'daily','2022-04-07','2022-06-07 15:16:05','2022-06-08 15:16:05','891',9136828.80,9136828.80,'891','2022-06-07 15:34:22','606','2022-06-07 15:38:17',10,0),('5','271',3,'daily','2022-04-08','2022-06-07 15:39:53','2022-06-08 15:39:53','891',11523583.50,11523583.50,'891','2022-06-08 10:55:21','600','2022-06-08 10:56:16',10,0),('5','271',4,'daily','2022-04-09','2022-06-08 10:59:20','2022-06-09 10:59:20','891',13897744.25,13897744.25,'891','2022-06-08 11:48:31','600','2022-06-08 11:49:00',10,0),('5','271',5,'daily','2022-04-10','2022-06-08 11:51:01','2022-06-09 11:51:01','891',13414874.55,13414874.55,'891','2022-06-08 12:29:16','606','2022-06-08 12:32:13',10,0),('5','271',6,'Daily','2022-04-11','2022-06-10 12:01:41','2022-06-11 12:01:41','891',16184590.95,16184590.95,'891','2022-06-10 16:43:16','600','2022-06-11 09:34:50',10,0),('5','271',7,'daily','2022-04-11','2022-06-14 10:29:16','2022-06-15 10:29:16','891',0.00,0.00,'600','2022-06-15 09:25:37','600','2022-06-15 09:25:53',10,0),('5','271',8,'daily','2021-04-12','2022-06-15 10:33:57','2022-06-16 10:33:57','891',15016834.80,15016834.80,'891','2022-06-15 10:44:04','606','2022-06-15 10:47:25',10,0),('5','271',9,'daily','2022-04-13','2022-06-15 10:49:23','2022-06-16 10:49:23','891',13252272.00,13252272.00,'891','2022-06-17 14:47:38','606','2022-06-17 14:55:06',10,0),('5','271',10,'daily','2022-04-14','2022-06-17 14:56:52','2022-06-18 14:56:52','891',15629796.60,15629796.60,'891','2022-06-20 15:29:43','606','2022-06-20 15:32:01',10,0),('5','271',11,'daily','2022-04-15','2022-06-20 15:35:23','2022-06-21 15:35:23','891',10817660.70,10817660.70,'891','2022-06-21 14:04:10','606','2022-06-21 14:06:05',10,0),('5','271',12,'daily','2022-04-16','2022-06-21 14:07:06','2022-06-22 14:07:06','891',9206797.05,9206797.05,'891','2022-06-21 14:13:33','606','2022-06-21 14:14:42',10,0),('5','271',13,'daily','2021-04-17','2022-06-21 14:15:42','2022-06-22 14:15:42','891',12680505.75,12680505.75,'891','2022-06-21 14:22:03','606','2022-06-21 14:24:09',10,0),('5','271',14,'daily','2022-04-18','2022-06-21 14:24:43','2022-06-22 14:24:43','891',9416140.80,9416140.80,'891','2022-06-21 15:23:02','606','2022-06-21 15:24:36',10,0),('5','271',15,'daily','2022-04-19','2022-06-21 15:25:26','2022-06-22 15:25:26','891',10711065.75,10711065.75,'891','2022-06-21 16:52:59','606','2022-06-21 16:54:25',10,0),('5','271',16,'daily','2022-04-20','2022-06-21 16:56:33','2022-06-22 16:56:33','891',8202597.15,8202597.15,'891','2022-06-21 17:03:44','606','2022-06-21 17:05:34',10,0),('5','271',17,'daily','2022-04-21','2022-06-21 17:06:15','2022-06-22 17:06:15','891',7296679.50,7296679.50,'891','2022-06-21 17:35:17','606','2022-06-21 17:36:45',10,0),('5','271',18,'daily','2022-04-22','2022-06-21 17:38:02','2022-06-22 17:38:02','891',9238901.10,9238901.10,'891','2022-06-21 18:05:42','606','2022-06-21 18:10:13',10,0),('5','271',19,'daily','2022-04-23','2022-06-21 18:11:06','2022-06-22 18:11:06','891',10158490.65,10158490.65,'891','2022-06-21 18:22:00','606','2022-06-21 18:24:27',10,0),('5','271',20,'daily','2022-04-24','2022-06-21 18:25:29','2022-06-22 18:25:29','891',8854426.35,8854426.35,'891','2022-06-21 18:35:25','606','2022-06-21 18:38:07',10,0),('5','271',21,'daily','2022-04-25','2022-06-21 18:39:01','2022-06-22 18:39:01','891',8493843.60,8493843.60,'891','2022-06-21 18:45:55','606','2022-06-21 18:47:14',10,0),('5','271',22,'daily','2022-04-26','2022-06-21 18:47:57','2022-06-22 18:47:57','891',10136664.45,10136664.45,'891','2022-06-21 18:53:13','606','2022-06-21 18:54:16',10,0),('5','271',23,'daily','2022-04-27','2022-06-21 18:59:51','2022-06-22 18:59:51','891',8522032.20,8522032.20,'891','2022-06-21 19:15:05','606','2022-06-21 19:15:55',10,0),('5','271',24,'daily','2022-04-28','2022-06-21 19:17:16','2022-06-22 19:17:16','891',10147269.00,10147269.00,'891','2022-06-21 19:33:30','600','2022-06-21 19:36:11',10,0),('5','271',25,'daily','2022-04-29','2022-06-21 19:37:48','2022-06-22 19:37:48','891',11117818.80,11117818.80,'891','2022-06-21 19:44:45','600','2022-06-21 19:45:37',10,0),('5','271',26,'daily','2022-04-30','2022-06-21 19:46:20','2022-06-22 19:46:20','891',7947137.55,7947137.55,'891','2022-06-21 19:52:44','600','2022-06-21 19:53:27',10,0),('5','271',27,'daily','2022-05-01','2022-06-23 09:28:25','2022-06-24 09:28:25','891',11729894.55,11729894.55,'891','2022-06-23 10:05:04','606','2022-06-23 10:07:36',10,0),('5','271',28,'daily','2022-05-02','2022-06-23 10:08:51','2022-06-24 10:08:51','891',6043631.55,6043631.55,'891','2022-06-23 14:09:43','606','2022-06-23 14:14:36',10,0),('5','271',29,'daily','2022-05-03','2022-06-23 14:16:51','2022-06-24 14:16:51','891',10549174.35,10549174.35,'891','2022-06-23 14:25:27','606','2022-06-23 14:27:27',10,0),('5','271',30,'daily','2022-05-04','2022-06-23 14:28:37','2022-06-24 14:28:37','891',7075384.80,7075384.80,'891','2022-06-23 14:33:31','606','2022-06-23 14:36:41',10,0),('5','271',31,'daily','2022-05-05','2022-06-23 14:37:43','2022-06-24 14:37:43','891',7575001.50,7575001.50,'891','2022-06-23 14:46:37','606','2022-06-23 14:47:37',10,0),('5','271',32,'daily','2022-06-06','2022-06-23 15:10:51','2022-06-24 15:10:51','891',6837331.05,6837331.05,'891','2022-06-23 15:16:18','606','2022-06-23 15:18:01',10,0),('5','271',33,'daily','2022-05-07','2022-06-23 15:19:08','2022-06-24 15:19:08','891',7783332.15,7783332.15,'891','2022-06-23 15:24:29','606','2022-06-23 15:25:33',10,0),('5','271',34,'daily','2022-05-08','2022-06-23 15:26:40','2022-06-24 15:26:40','891',11244825.90,11244825.90,'891','2022-06-23 15:57:40','606','2022-06-23 16:02:06',10,0),('5','271',35,'daily','2022-05-09','2022-06-23 16:03:48','2022-06-24 16:03:48','891',8486713.95,8486713.95,'891','2022-06-24 11:19:56','606','2022-06-24 11:35:59',10,0),('5','271',36,'daily','2022-05-10','2022-06-24 12:04:47','2022-06-25 12:04:47','891',9857357.40,9857357.40,'891','2022-06-24 12:09:49','606','2022-06-24 12:11:41',10,0),('5','271',37,'daily','2022-05-11','2022-06-24 12:12:42','2022-06-25 12:12:42','891',13308972.60,13308972.60,'891','2022-06-24 12:21:26','606','2022-06-24 12:25:49',10,0),('5','271',38,'daily','2022-05-11','2022-06-24 15:48:44','2022-06-25 15:48:44','891',0.00,0.00,'600','2022-06-27 11:30:27','600','2022-06-27 11:30:40',10,0),('5','271',39,'daily','2022-05-12','2022-06-27 11:33:16','2022-06-28 11:33:16','891',18708834.25,18708834.25,'891','2022-06-27 11:35:35','606','2022-06-27 11:38:00',10,0),('5','271',40,'daily','2022-05-13','2022-06-27 11:38:59','2022-06-28 11:38:59','891',0.00,0.00,'600','2022-06-27 12:28:04','600','2022-06-27 12:28:19',10,0),('5','271',41,'daily','2019-05-13','2022-06-27 12:29:52','2022-06-28 12:29:52','891',7633134.15,7220181.75,'891','2022-06-27 12:37:43','606','2022-06-27 12:54:33',10,0),('5','271',42,'daily','2022-05-14','2022-06-27 12:55:50','2022-06-28 12:55:50','891',5676417.45,5676417.45,'891','2022-06-28 10:57:03','606','2022-06-28 11:04:35',10,0),('5','271',43,'daily','2022-05-15','2022-06-28 11:05:15','2022-06-29 11:05:15','891',5253352.50,5253352.50,'891','2022-06-28 11:09:16','606','2022-06-28 11:12:35',10,0),('5','271',44,'daily','2022-05-16','2022-06-28 11:13:27','2022-06-29 11:13:27','891',7544491.35,7544491.35,'891','2022-06-28 11:20:28','606','2022-06-28 11:21:55',10,0),('5','271',45,'daily','2022-05-17','2022-06-28 11:22:48','2022-06-29 11:22:48','891',6125468.25,6125468.25,'891','2022-06-28 11:48:09','606','2022-06-28 11:48:59',10,0),('5','271',46,'daily','2022-05-18','2022-06-28 11:51:31','2022-06-29 11:51:31','891',5269467.39,5269467.39,'891','2022-06-28 12:31:12','606','2022-06-28 12:32:11',10,0),('5','271',47,'daily','2022-05-19','2022-06-28 12:32:57','2022-06-29 12:32:57','891',5022641.25,5022641.25,'891','2022-06-28 12:50:56','606','2022-06-28 12:51:35',10,0),('5','271',48,'daily','2022-05-20','2022-06-28 12:52:27','2022-06-29 12:52:27','891',7277894.25,7277894.25,'891','2022-06-28 12:56:05','606','2022-06-28 12:59:28',10,0),('5','271',49,'daily','2022-04-21','2022-06-28 13:06:09','2022-06-29 13:06:09','891',6336709.50,6336709.50,'891','2022-06-28 14:27:25','600','2022-06-28 14:30:28',10,0),('5','271',50,'daily','2022-05-22','2022-06-28 14:31:55','2022-06-29 14:31:55','891',5752903.20,5752903.20,'891','2022-06-28 15:21:41','606','2022-06-28 15:22:14',10,0),('5','271',51,'daily','2022-04-23','2022-06-28 15:23:32','2022-06-29 15:23:32','891',6406245.45,6406245.45,'891','2022-06-28 15:29:44','606','2022-06-28 15:56:47',10,0),('5','271',52,'daily','2022-05-24','2022-06-28 15:58:16','2022-06-29 15:58:16','891',6055047.90,6055047.90,'891','2022-06-28 16:02:30','606','2022-06-28 16:05:31',10,0),('5','271',53,'daily','2022-05-25','2022-06-28 16:11:38','2022-06-29 16:11:38','891',4835696.25,4835696.25,'891','2022-06-28 16:15:49','606','2022-06-28 16:16:26',10,0),('5','271',54,'daily','2022-05-26','2022-06-28 16:18:14','2022-06-29 16:18:14','891',7641471.75,7641471.75,'891','2022-06-28 16:33:41','606','2022-06-28 16:35:29',10,0),('5','271',55,'daily','2022-05-27','2022-06-28 16:36:08','2022-06-29 16:36:08','891',7004555.25,7004555.25,'891','2022-06-28 16:40:52','606','2022-06-28 16:42:41',10,0),('5','271',56,'daily','2022-05-28','2022-06-28 16:43:54','2022-06-29 16:43:54','891',5420144.40,5420144.40,'891','2022-06-28 16:46:53','606','2022-06-28 16:50:59',10,0),('5','271',57,'daily','2022-05-29','2022-06-28 16:51:39','2022-06-29 16:51:39','891',7678435.05,7678435.05,'891','2022-06-28 17:06:41','606','2022-06-28 17:07:28',10,0),('5','271',58,'daily','2022-05-30','2022-06-28 17:08:15','2022-06-29 17:08:15','891',6097198.80,6097198.80,'891','2022-06-28 17:11:23','606','2022-06-28 17:12:24',10,0),('5','271',59,'daily','2022-05-31','2022-06-28 17:13:05','2022-06-29 17:13:05','891',7027879.65,7027879.65,'891','2022-06-29 11:00:43','606','2022-06-29 11:18:49',10,0),('5','271',60,'daily','2022-06-01','2022-06-29 11:23:10','2022-06-30 11:23:10','891',5047401.15,5047401.15,'891','2022-06-29 11:26:18','606','2022-06-29 11:28:27',10,0),('5','271',61,'daily','2022-06-02','2022-06-29 11:29:28','2022-06-30 11:29:28','891',2885488.65,2885488.65,'891','2022-06-29 11:32:10','606','2022-06-29 11:33:13',10,0),('5','271',62,'daily','2022-06-03','2022-06-29 11:35:02','2022-06-30 11:35:02','891',2064534.45,2064534.45,'891','2022-06-29 11:38:33','606','2022-06-29 11:39:41',10,0),('5','271',63,'daily','2022-06-04','2022-06-29 11:41:04','2022-06-30 11:41:04','891',3916624.80,3916624.80,'891','2022-06-29 11:43:57','606','2022-06-29 11:51:28',10,0),('5','271',64,'daily','2022-06-05','2022-06-29 11:52:07','2022-06-30 11:52:07','891',4693614.75,4693614.75,'891','2022-06-29 16:48:02','606','2022-06-29 16:56:14',10,0),('5','271',65,'daily','2022-06-06','2022-06-29 16:59:32','2022-06-30 16:59:32','891',5327886.30,5327886.30,'891','2022-06-29 17:06:42','606','2022-06-29 17:08:54',10,0),('5','271',66,'daily','2022-06-07','2022-06-29 17:10:12','2022-06-30 17:10:12','891',4186779.30,4186779.30,'891','2022-06-29 17:16:54','606','2022-06-29 17:21:10',10,0),('5','271',67,'daily','2022-06-08','2022-06-29 17:26:20','2022-06-30 17:26:20','891',4660332.60,4660332.60,'891','2022-06-30 11:24:23','606','2022-06-30 11:27:35',10,0),('5','271',68,'daily','2022-06-09','2022-06-30 11:31:19','2022-07-01 11:31:19','891',3571055.40,3571055.40,'891','2022-06-30 11:50:24','606','2022-06-30 11:51:21',10,0),('5','271',69,'daily','2022-06-10','2022-06-30 11:53:07','2022-07-01 11:53:07','891',4363456.35,4363456.35,'891','2022-06-30 11:57:54','606','2022-06-30 12:00:40',10,0),('5','271',70,'daily','2022-06-11','2022-06-30 12:02:55','2022-07-01 12:02:55','891',2448270.00,2448270.00,'891','2022-06-30 12:24:56','606','2022-06-30 12:27:14',10,0),('5','271',71,'daily','2022-06-12','2022-06-30 12:28:20','2022-07-01 12:28:20','891',0.00,0.00,'891','2022-06-30 12:33:17','606','2022-06-30 12:36:14',10,0),('5','271',72,'daily','2022-06-16','2022-06-30 12:37:50','2022-07-01 12:37:50','891',680312.00,680312.00,'891','2022-06-30 12:39:49','606','2022-06-30 12:45:45',10,0),('5','271',73,'daily','2022-06-17','2022-06-30 12:48:45','2022-07-01 12:48:45','891',3921739.10,3921739.10,'891','2022-06-30 12:53:08','606','2022-06-30 12:54:53',10,0),('5','271',74,'daily','2022-06-18','2022-06-30 12:55:53','2022-07-01 12:55:53','891',4728623.80,4728623.80,'891','2022-06-30 14:08:27','606','2022-06-30 14:17:14',10,0),('5','271',75,'daily','2022-06-19','2022-06-30 14:18:53','2022-07-01 14:18:53','891',6115526.30,6115526.30,'891','2022-06-30 14:55:21','606','2022-06-30 15:09:47',10,0),('5','271',76,'daily','2022-06-20','2022-06-30 15:11:08','2022-07-01 15:11:08','891',6555598.90,6555598.90,'891','2022-07-04 12:11:57','606','2022-07-05 12:23:43',10,0),('5','271',77,'daily','2022-06-21','2022-07-05 14:01:11','2022-07-06 14:01:11','891',2251699.85,2251699.85,'891','2022-07-05 14:04:56','606','2022-07-05 14:42:00',10,0),('5','271',78,'daily','2022-06-22','2022-07-06 13:02:59','2022-07-07 13:02:59','891',6745181.65,6745181.65,'891','2022-07-06 13:47:49','606','2022-07-06 13:50:48',10,0),('5','271',79,'daily','2022-06-23','2022-07-06 14:00:46','2022-07-07 14:00:46','891',7555959.20,7555959.20,'891','2022-07-06 14:39:37','606','2022-07-07 10:20:00',10,0),('5','271',80,'daily','2022-06-24','2022-07-07 10:32:53','2022-07-08 10:32:53','891',5362891.70,5362891.70,'891','2022-07-07 10:36:58','606','2022-07-07 10:48:22',10,0),('5','271',81,'daily','2022-06-25','2022-07-07 10:50:21','2022-07-08 10:50:21','891',2871370.05,2871370.05,'891','2022-07-07 10:55:03','606','2022-07-07 10:58:12',10,0),('5','271',82,'daily','2022-06-26','2022-07-07 11:12:58','2022-07-08 11:12:58','891',3748172.60,3748172.60,'891','2022-07-07 11:16:31','606','2022-07-07 11:20:36',10,0),('5','271',83,'daily','2022-06-27','2022-07-07 11:23:11','2022-07-08 11:23:11','891',3515053.04,3515053.04,'891','2022-07-07 11:40:47','606','2022-07-07 11:45:44',10,0),('5','271',84,'daily','2022-06-28','2022-07-07 11:47:53','2022-07-08 11:47:53','891',2228906.35,2228906.35,'891','2022-07-07 12:02:15','606','2022-07-07 12:03:55',10,0),('5','271',85,'daily','2022-06-29','2022-07-07 12:05:07','2022-07-08 12:05:07','891',940613.80,940613.80,'891','2022-07-07 12:07:34','606','2022-07-07 12:10:24',10,0),('5','271',86,'daily','2022-06-30','2022-07-07 12:12:16','2022-07-08 12:12:16','891',1130976.80,1130976.80,'891','2022-07-07 12:13:16','606','2022-07-07 12:15:34',10,0),('5','271',87,'daily','2022-07-01','2022-07-07 12:17:14','2022-07-08 12:17:14','891',202343.20,202343.20,'891','2022-07-07 12:18:07','606','2022-07-07 12:19:01',10,0),('5','271',88,'daily','2022-07-02','2022-07-07 12:20:18','2022-07-08 12:20:18','891',287656.00,287656.00,'891','2022-07-07 12:21:33','606','2022-07-07 12:23:11',10,0),('5','271',89,'daily','2022-07-03','2022-07-07 12:24:00','2022-07-08 12:24:00','891',4062588.65,4062588.65,'891','2022-07-14 10:17:00','606','2022-07-14 12:36:23',10,0),('5','271',90,'daily','2022-07-04','2022-07-14 12:59:02','2022-07-15 12:59:02','891',3746637.15,3398499.75,'891','2022-07-14 13:01:34','606','2022-07-14 13:06:20',10,0),('5','271',91,'daily','2022-07-05','2022-07-14 13:07:18','2022-07-15 13:07:18','891',3942922.75,3554451.75,'891','2022-07-14 13:09:50','606','2022-07-14 13:11:25',10,0),('5','271',92,'daily','2022-07-06','2022-07-14 13:13:53','2022-07-15 13:13:53','891',3943406.95,3566727.95,'891','2022-07-14 14:52:03','606','2022-07-14 14:55:31',10,0),('5','271',93,'daily','2022-07-07','2022-07-14 14:56:30','2022-07-15 14:56:30','891',4031473.90,3658567.90,'891','2022-07-14 15:00:30','606','2022-07-14 15:02:49',10,0),('5','271',94,'daily','2022-07-08','2022-07-14 15:04:03','2022-07-15 15:04:03','891',5026663.15,4574900.15,'891','2022-07-14 15:24:14','606','2022-07-14 15:25:06',10,0),('5','271',95,'daily','2022-07-09','2022-07-14 15:27:26','2022-07-15 15:27:26','891',882737.90,808271.10,'891','2022-07-14 15:30:43','606','2022-07-14 15:34:21',10,0),('5','271',96,'daily','2022-07-10','2022-07-14 15:35:04','2022-07-15 15:35:04','891',490924.85,464336.65,'891','2022-07-14 15:36:57','606','2022-07-14 15:39:11',10,0),('5','271',97,'daily','2022-07-11','2022-07-14 15:39:56','2022-07-15 15:39:56','891',243087.35,228145.15,'891','2022-07-14 15:42:02','606','2022-07-14 15:48:22',10,0),('5','271',98,'daily','2022-07-12','2022-07-14 22:34:21','2022-07-15 22:34:21','891',2423350.40,2216361.60,'891','2022-07-15 10:49:20','606','2022-07-15 10:50:40',10,0),('5','271',99,'daily','2022-07-13','2022-07-15 10:51:35','2022-07-16 10:51:35','891',4237384.80,3818207.20,'891','2022-07-15 10:55:24','606','2022-07-15 10:56:26',10,0),('5','271',100,'daily','2022-07-14','2022-07-15 10:58:30','2022-07-16 10:58:30','891',9334571.00,8563439.00,'891','2022-07-15 11:14:13','606','2022-07-15 11:28:39',10,0),('5','271',101,'daily','2022-07-15','2022-07-15 12:36:53','2022-07-16 12:36:53','891',7151155.80,6408398.20,'891','2022-07-16 17:10:40','606','2022-07-16 21:45:08',10,0),('5','271',102,'daily','2022-07-16','2022-07-19 10:46:40','2022-07-20 10:46:40','891',5113331.15,4606831.35,'891','2022-07-19 11:09:31','606','2022-07-19 11:11:33',10,0),('5','271',103,'daily','2022-07-17','2022-07-19 11:18:05','2022-07-20 11:18:05','891',2609340.40,2361303.60,'891','2022-07-19 12:37:44','606','2022-07-19 12:42:11',10,0),('5','271',104,'Daily','2022-07-18','2022-07-19 12:44:07','2022-07-20 12:44:07','891',7502365.45,6831394.05,'891','2022-07-21 09:48:46','606','2022-07-21 16:49:39',10,0),('5','271',105,'daily','2022-07-19','2022-07-22 12:09:32','2022-07-23 12:09:32','891',5307176.35,5307176.35,'891','2022-07-22 12:16:24','606','2022-07-22 14:18:39',10,0),('5','271',106,'daily','2022-07-20','2022-07-22 14:53:57','2022-07-23 14:53:57','891',7534682.35,7534682.35,'891','2022-07-22 14:58:11','606','2022-07-22 15:12:20',10,0),('5','271',107,'daily','2022-07-21','2022-07-22 15:16:23','2022-07-23 15:16:23','891',3954465.15,3954465.15,'891','2022-07-22 15:21:46','664','2022-07-22 16:42:51',10,0),('5','271',108,'Daily','2022-07-22','2022-07-22 23:00:33','2022-07-23 23:00:33','891',8028444.25,8028444.25,'891','2022-07-23 17:17:01','606','2022-07-23 18:40:58',10,0),('5','271',109,'Daily','2022-07-23','2022-07-23 18:49:38','2022-07-24 18:49:38','891',10636050.25,10636050.25,'891','2022-07-25 16:50:01','606','2022-07-25 17:02:08',10,0),('5','271',110,'daily','2022-07-24','2022-07-25 17:08:01','2022-07-26 17:08:01','891',10669523.25,10669523.25,'891','2022-07-25 17:17:35','606','2022-07-26 07:10:28',10,0),('5','271',111,'daily','2022-07-25','2022-07-26 11:08:47','2022-07-27 11:08:47','891',8657143.55,8657143.55,'891','2022-07-28 16:06:51','606','2022-07-28 16:08:52',10,0),('5','271',112,'daily','2022-07-26','2022-07-28 16:09:58','2022-07-29 16:09:58','891',8886272.60,8886272.60,'891','2022-08-02 12:18:51','606','2022-08-02 12:20:13',10,0),('5','271',113,'daily','2022-07-27','2022-08-02 12:21:20','2022-08-03 12:21:20','891',5881849.75,5881849.75,'891','2022-08-02 12:25:52','606','2022-08-02 12:28:10',10,0),('5','271',114,'daily','2022-07-28','2022-08-02 12:29:08','2022-08-03 12:29:08','891',6263694.30,6263694.30,'891','2022-08-02 12:34:39','606','2022-08-02 12:36:24',10,0),('5','271',115,'daily','2022-07-29','2022-08-02 12:37:41','2022-08-03 12:37:41','891',5501195.70,5501195.70,'891','2022-08-02 14:58:01','606','2022-08-02 15:06:46',10,0),('5','271',116,'daily','2022-07-30','2022-08-02 15:09:41','2022-08-03 15:09:41','891',6505236.50,6505236.50,'891','2022-08-02 15:12:49','606','2022-08-02 15:14:45',10,0),('5','271',117,'daily','2022-07-31','2022-08-02 15:15:44','2022-08-03 15:15:44','891',2731251.20,2731251.20,'891','2022-08-02 15:19:18','606','2022-08-02 15:20:01',10,0),('5','271',118,'daily','2022-08-01','2022-08-02 15:20:57','2022-08-03 15:20:57','891',4373488.80,4373488.80,'891','2022-08-02 15:26:18','606','2022-08-02 15:27:35',10,0),('5','271',119,'daily','2022-08-02','2022-08-02 15:28:29','2022-08-03 15:28:29','891',4080728.15,4080728.15,'891','2022-08-03 12:27:09','664','2022-08-03 20:26:28',10,0),('5','271',120,'Daily','2022-08-03','2022-08-04 07:46:45','2022-08-05 07:46:45','891',4535250.95,4535250.95,'891','2022-08-04 19:16:59','664','2022-08-04 19:19:14',10,0),('5','271',121,'daily','2022-08-04','2022-08-04 19:27:59','2022-08-05 19:27:59','891',6059578.80,6059578.80,'891','2022-08-04 22:04:59','664','2022-08-05 06:35:03',10,0),('5','271',122,'daily','2022-08-05','2022-08-05 10:01:20','2022-08-06 10:01:20','891',5624590.15,5624590.15,'891','2022-08-05 20:28:07','664','2022-08-06 06:57:17',10,0),('5','271',123,'Daily','2022-08-06','2022-08-06 12:02:36','2022-08-07 12:02:36','891',4036433.60,4036433.60,'891','2022-09-05 14:58:46','664','2022-09-05 15:04:27',10,0),('5','271',124,'daily','2022-08-07','2022-09-05 15:05:56','2022-09-06 15:05:56','891',2477886.30,2477886.30,'891','2022-09-05 15:08:05','664','2022-09-05 15:08:42',10,0),('5','271',125,'daily','2022-08-08','2022-09-05 15:09:57','2022-09-06 15:09:57','891',2249840.50,2249840.50,'891','2022-09-05 15:12:46','664','2022-09-05 15:13:43',10,0),('5','271',126,'daily','2022-08-09','2022-09-05 15:14:28','2022-09-06 15:14:28','891',3531418.75,3531418.75,'891','2022-09-05 15:17:16','664','2022-09-05 15:18:13',10,0),('5','271',127,'daily','2022-08-10','2022-09-05 15:19:14','2022-09-06 15:19:14','891',3815354.90,3815354.90,'891','2022-09-05 15:22:55','664','2022-09-05 15:24:21',10,0),('5','271',128,'daily','2022-08-11','2022-09-05 15:25:01','2022-09-06 15:25:01','891',3398376.00,3398376.00,'891','2022-09-05 15:29:41','664','2022-09-05 15:30:34',10,0),('5','271',129,'daily','2022-08-12','2022-09-05 15:32:19','2022-09-06 15:32:19','891',3452433.00,3452433.00,'891','2022-09-05 15:34:37','664','2022-09-05 15:35:37',10,0),('5','271',130,'daily','2022-08-13','2022-09-05 15:39:21','2022-09-06 15:39:21','891',4633395.30,4633395.30,'891','2022-09-05 15:53:18','664','2022-09-05 16:05:39',10,0),('5','271',131,'daily','2022-08-14','2022-09-05 16:10:23','2022-09-06 16:10:23','891',4078426.75,4078426.75,'891','2022-09-05 16:14:27','664','2022-09-05 16:16:03',10,0),('5','271',132,'daily','2022-08-15','2022-09-05 16:16:43','2022-09-06 16:16:43','891',3740115.40,3740115.40,'891','2022-09-05 16:20:33','664','2022-09-05 16:21:25',10,0),('5','271',133,'daily','2022-08-16','2022-09-05 16:21:53','2022-09-06 16:21:53','891',3830887.50,3830887.50,'891','2022-09-05 16:25:21','664','2022-09-05 16:31:06',10,0),('5','271',134,'daily','2022-08-17','2022-09-05 16:31:42','2022-09-06 16:31:42','891',3638555.95,3638555.95,'891','2022-09-05 22:33:04','664','2022-09-05 22:38:09',10,0),('5','271',135,'daily','2022-08-18','2022-09-06 09:28:37','2022-09-07 09:28:37','891',3225380.65,3225380.65,'891','2022-09-06 09:32:25','664','2022-09-06 09:35:39',10,0),('5','271',136,'daily','2022-08-19','2022-09-06 09:36:09','2022-09-07 09:36:09','891',2631945.05,2631945.05,'891','2022-09-06 09:39:29','664','2022-09-06 09:40:12',10,0),('5','271',137,'daily','2022-08-20','2022-09-06 09:41:34','2022-09-07 09:41:34','891',2806231.70,2806231.70,'891','2022-09-06 10:03:59','664','2022-09-06 10:04:49',10,0),('5','271',138,'daily','2022-08-21','2022-09-06 10:05:49','2022-09-07 10:05:49','891',3242565.30,3242565.30,'891','2022-09-06 10:09:14','664','2022-09-06 10:10:25',10,0),('5','271',139,'daily','2022-08-22','2022-09-06 10:11:21','2022-09-07 10:11:21','891',3335340.95,3335340.95,'891','2022-09-06 10:18:28','664','2022-09-06 10:20:13',10,0),('5','271',140,'daily','2022-08-23','2022-09-06 10:21:46','2022-09-07 10:21:46','891',2962512.30,2962512.30,'891','2022-09-06 10:27:29','664','2022-09-06 10:30:11',10,0),('5','271',141,'daily','2022-08-24','2022-09-07 09:45:33','2022-09-08 09:45:33','891',2653693.65,2653693.65,'891','2022-09-07 09:49:38','664','2022-09-07 09:51:17',10,0),('5','271',142,'daily','2022-08-25','2022-09-07 09:53:20','2022-09-08 09:53:20','891',2811650.35,2811650.35,'891','2022-09-07 09:57:52','664','2022-09-07 09:58:59',10,0),('5','271',143,'daily','2022-08-26','2022-09-07 09:59:50','2022-09-08 09:59:50','891',2820767.15,2820767.15,'891','2022-09-07 10:03:32','664','2022-09-07 10:07:06',10,0),('5','271',144,'daily','2022-08-27','2022-09-07 10:07:30','2022-09-08 10:07:30','891',2830799.70,2830799.70,'891','2022-09-07 10:11:03','664','2022-09-07 10:18:56',10,0),('5','271',145,'daily','2022-08-28','2022-09-07 11:14:02','2022-09-08 11:14:02','891',2461900.45,2461900.45,'891','2022-09-07 11:17:47','664','2022-09-07 11:18:48',10,0),('5','271',146,'daily','2022-08-29','2022-09-07 11:19:11','2022-09-08 11:19:11','891',2547126.25,2547126.25,'891','2022-09-07 11:22:46','664','2022-09-07 11:24:01',10,0),('5','271',147,'daily','2022-08-30','2022-09-07 11:24:27','2022-09-08 11:24:27','891',2914153.30,2914153.30,'891','2022-09-07 11:28:07','664','2022-09-07 11:29:10',10,0),('5','271',148,'daily','2022-08-31','2022-09-07 11:29:45','2022-09-08 11:29:45','891',3567031.60,3567031.60,'891','2022-09-07 11:34:07','664','2022-09-07 11:34:46',10,0),('5','271',149,'daily','2022-09-01','2022-09-07 11:35:25','2022-09-08 11:35:25','891',2831134.20,2831134.20,'891','2022-09-07 11:38:39','664','2022-09-07 11:39:34',10,0),('5','271',150,'daily','2022-09-02','2022-09-07 11:40:07','2022-09-08 11:40:07','891',4508587.40,4508587.40,'891','2022-09-07 11:43:10','664','2022-09-07 11:43:54',10,0),('5','271',151,'daily','2022-09-03','2022-09-07 11:44:20','2022-09-08 11:44:20','891',2571972.80,2571972.80,'891','2022-09-07 11:47:11','664','2022-09-07 11:48:02',10,0),('5','271',152,'daily','2022-09-04','2022-09-07 12:09:11','2022-09-08 12:09:11','891',2937600.80,2937600.80,'891','2022-09-08 10:06:28','664','2022-09-08 10:07:49',10,0),('5','271',153,'daily','2022-09-05','2022-09-08 17:05:30','2022-09-09 17:05:30','891',4208152.00,4208152.00,'891','2022-09-08 17:09:52','664','2022-09-08 17:13:07',10,0),('5','271',154,'daily','2022-09-06','2022-09-08 17:14:16','2022-09-09 17:14:16','891',5353999.30,5353999.30,'891','2022-09-13 13:08:41','664','2022-09-13 13:15:39',10,0),('5','271',155,'daily','2022-09-07','2022-09-13 13:16:31','2022-09-14 13:16:31','891',2978032.20,2978032.20,'891','2022-09-13 13:20:30','664','2022-09-13 13:22:08',10,0),('5','271',156,'daily','2022-09-08','2022-09-13 13:23:01','2022-09-14 13:23:01','891',3216647.55,3216647.55,'891','2022-09-16 11:12:52','664','2022-09-16 11:21:43',10,0),('5','271',157,'daily','2022-09-09','2022-09-16 11:23:34','2022-09-17 11:23:34','891',3591688.85,3591688.85,'891','2022-09-16 11:26:05','664','2022-09-16 11:27:17',10,0),('5','271',158,'daily','2022-09-10','2022-09-16 11:30:05','2022-09-17 11:30:05','891',3614565.40,3614565.40,'891','2022-09-16 11:31:56','664','2022-09-16 11:32:57',10,0),('5','271',159,'daily','2022-09-11','2022-09-16 11:36:07','2022-09-17 11:36:07','891',3155503.85,3155503.85,'891','2022-09-20 13:43:20','664','2022-09-20 13:52:11',10,0),('5','271',160,'daily','2022-09-12','2022-09-20 13:52:47','2022-09-21 13:52:47','891',3421506.05,3421506.05,'891','2022-09-20 13:55:22','664','2022-09-20 13:56:25',10,0),('5','271',161,'daily','2022-09-13','2022-09-20 13:57:01','2022-09-21 13:57:01','891',3143342.40,3143342.40,'891','2022-09-20 13:59:13','664','2022-09-20 14:45:55',10,0),('5','271',162,'daily','2022-09-14','2022-09-20 14:48:02','2022-09-21 14:48:02','891',3230077.25,3230077.25,'891','2022-09-20 14:50:00','664','2022-09-20 14:52:28',10,0),('5','271',163,'daily','2022-09-15','2022-09-20 14:52:58','2022-09-21 14:52:58','891',3534661.35,3534661.35,'891','2022-09-20 14:56:08','664','2022-09-20 14:57:58',10,0),('5','271',164,'daily','2022-09-16','2022-09-20 14:58:42','2022-09-21 14:58:42','891',3357544.50,3357544.50,'891','2022-09-20 15:01:19','664','2022-09-20 15:07:59',10,0),('5','271',165,'daily','2022-09-17','2022-09-20 15:08:37','2022-09-21 15:08:37','891',2836813.95,2836813.95,'891','2022-09-20 15:12:10','664','2022-09-20 15:15:21',10,0),('5','271',166,'daily','2022-09-18','2022-09-20 15:17:16','2022-09-21 15:17:16','891',3395927.90,3395927.90,'891','2022-09-21 14:28:10','664','2022-09-21 14:29:30',10,0),('5','271',167,'daily','2022-09-19','2022-09-21 14:30:38','2022-09-22 14:30:38','891',4089318.00,4089318.00,'891','2022-09-21 14:36:20','664','2022-09-21 14:36:45',10,0),('5','271',168,'daily','2022-09-20','2022-09-21 14:37:35','2022-09-22 14:37:35','891',9241180.65,9241180.65,'891','2022-09-21 14:40:35','664','2022-09-21 14:41:25',10,0),('5','271',169,'daily','2022-09-21','2022-09-21 14:41:50','2022-09-22 14:41:50','891',9892306.60,9892306.60,'891','2022-09-23 10:42:17','664','2022-09-23 10:44:46',10,0),('5','271',170,'daily','2022-09-22','2022-09-23 10:45:45','2022-09-24 10:45:45','891',5118392.90,5118392.90,'891','2022-09-23 10:49:52','664','2022-09-23 10:57:55',10,0),('5','271',171,'daily','2022-09-23','2022-09-29 10:53:15','2022-09-30 10:53:15','891',3486772.60,3486772.60,'891','2022-09-29 10:56:57','664','2022-09-29 10:58:38',10,0),('5','271',172,'daily','2022-09-24','2022-09-29 10:59:22','2022-09-30 10:59:22','891',4107507.45,4107507.45,'891','2022-09-29 11:02:58','664','2022-09-29 11:04:43',10,0),('5','271',173,'daily','2022-09-25','2022-09-29 11:05:09','2022-09-30 11:05:09','891',3678213.90,3678213.90,'891','2022-09-29 11:09:37','664','2022-09-29 11:10:30',10,0),('5','271',174,'daily','2022-09-26','2022-09-29 11:11:19','2022-09-30 11:11:19','891',3990874.45,3990874.45,'891','2022-09-29 11:15:05','664','2022-09-29 11:15:54',10,0),('5','271',175,'daily','2022-09-27','2022-09-29 11:16:56','2022-09-30 11:16:56','891',4719620.80,4719620.80,'891','2022-09-29 11:21:22','664','2022-09-29 11:22:20',10,0),('5','271',176,'daily','2022-09-28','2022-09-29 11:22:58','2022-09-30 11:22:58','891',3673579.55,3673579.55,'891','2022-10-18 12:04:46','664','2022-10-18 12:07:52',10,0),('5','271',177,'daily','2022-09-29','2022-10-18 12:08:49','2022-10-19 12:08:49','891',4641904.70,4608197.90,'891','2022-10-18 12:11:34','664','2022-10-18 12:12:35',10,0),('5','271',178,'daily','2022-09-30','2022-10-18 12:13:14','2022-10-19 12:13:14','891',4460525.90,4420745.30,'891','2022-10-18 12:16:34','664','2022-10-18 12:17:27',10,0),('5','271',179,'daily','2022-10-01','2022-10-18 12:17:48','2022-10-19 12:17:48','891',5260622.95,5188028.35,'891','2022-10-18 12:20:25','664','2022-10-18 12:21:16',10,0),('5','271',180,'daily','2022-10-02','2022-10-18 12:21:48','2022-10-19 12:21:48','891',3175912.85,3165226.85,'891','2022-10-18 12:40:33','664','2022-10-18 12:41:59',10,0),('5','271',181,'daily','2022-10-03','2022-10-18 12:42:49','2022-10-19 12:42:49','891',2922709.55,2922709.55,'891','2022-10-18 12:44:57','664','2022-10-18 12:46:05',10,0),('5','271',182,'daily','2022-10-04','2022-10-18 12:47:04','2022-10-19 12:47:04','891',5440710.35,5311917.35,'891','2022-10-18 12:49:43','664','2022-10-18 12:50:35',10,0),('5','271',183,'daily','2022-10-05','2022-10-18 12:51:47','2022-10-19 12:51:47','891',2127540.20,2087019.20,'891','2022-10-18 12:53:22','664','2022-10-18 13:15:29',10,0),('5','271',184,'daily','2022-10-06','2022-10-18 13:22:54','2022-10-19 13:22:54','891',617078.60,617078.60,'891','2022-10-18 13:23:37','664','2022-10-18 13:24:33',10,0),('5','271',185,'daily','2022-10-07','2022-10-18 13:25:11','2022-10-19 13:25:11','891',313567.60,313567.60,'891','2022-10-18 13:26:22','664','2022-10-18 13:27:16',10,0),('5','271',186,'daily','2022-10-08','2022-10-18 13:27:54','2022-10-19 13:27:54','891',2111942.75,2093731.55,'891','2022-10-25 13:48:42','664','2022-10-25 14:00:00',10,0),('5','271',187,'daily','2022-10-17','2022-10-25 14:03:37','2022-10-26 14:03:37','891',3571562.90,3474072.50,'891','2022-10-25 14:05:39','664','2022-10-25 14:07:44',10,0),('5','271',188,'daily','2022-10-18','2022-10-25 14:08:14','2022-10-26 14:08:14','891',4690633.65,4669069.65,'891','2022-10-25 14:10:20','664','2022-10-25 14:11:38',10,0),('5','271',189,'daily','2022-10-19','2022-10-25 14:12:20','2022-10-26 14:12:20','891',4161303.25,4148429.65,'891','2022-10-25 14:14:47','664','2022-10-25 14:15:33',10,0),('5','271',190,'daily','2022-10-20','2022-10-25 14:16:10','2022-10-26 14:16:10','891',2271613.40,2253445.70,'891','2022-10-25 14:17:30','664','2022-10-25 14:18:30',10,0),('5','271',191,'daily','2022-10-21','2022-10-25 14:19:08','2022-10-26 14:19:08','891',846357.65,836392.55,'891','2022-10-26 11:48:30','664','2022-10-26 11:52:15',10,0),('5','271',192,'daily','2022-10-24','2022-10-26 11:52:56','2022-10-27 11:52:56','891',1144591.90,1116116.50,'891','2022-10-26 11:54:15','664','2022-10-26 11:55:18',10,0),('5','271',193,'daily','2022-10-25','2022-10-26 11:55:41','2022-10-27 11:55:41','891',3477555.50,3451952.90,'891','2022-10-26 11:57:22','664','2022-10-26 11:59:07',10,0),('5','271',194,'daily','2022-10-22','2022-10-26 12:00:53','2022-10-27 12:00:53','891',338059.00,325840.00,'891','2022-10-26 12:03:03','664','2022-10-26 12:06:18',10,0),('5','271',195,'daily','2022-10-26','2022-10-27 10:32:13','2022-10-28 10:32:13','891',4923456.80,4923456.80,'891','2022-10-27 10:45:20','664','2022-10-27 10:47:05',10,0),('5','271',196,'daily','2022-10-27','2022-10-27 10:50:52','2022-10-28 10:50:52','891',5715822.30,5697533.40,'891','2022-10-28 09:34:37','664','2022-10-28 10:28:19',10,0),('5','271',197,'daily','2022-10-28','2022-10-29 12:29:07','2022-10-30 12:29:07','891',5554863.05,5511576.95,'891','2022-10-29 12:35:51','664','2022-10-30 06:35:32',10,0),('5','271',198,'daily','2022-10-29','2022-10-31 09:55:47','2022-11-01 09:55:47','891',7584305.95,7584305.95,'891','2022-10-31 13:36:22','664','2022-10-31 14:34:43',10,0),('5','271',199,'daily','2022-10-30','2022-10-31 15:29:09','2022-11-01 15:29:09','891',5019239.90,5019239.90,'891','2022-10-31 15:32:33','664','2022-10-31 15:34:37',10,0),('5','271',200,'daily','2022-10-31','2022-10-31 15:35:01','2022-11-01 15:35:01','891',8254209.55,8254209.55,'891','2022-11-01 16:40:20','664','2022-11-02 06:27:29',10,0),('5','271',201,'daily','2022-11-01','2022-11-02 10:07:34','2022-11-03 10:07:34','891',8743895.95,8743895.95,'891','2022-11-02 10:38:56','664','2022-11-03 08:14:46',10,0),('5','271',202,'daily','2022-11-02','2022-11-03 10:51:38','2022-11-04 10:51:38','891',9238034.10,9238034.10,'891','2022-11-05 10:06:57','664','2022-11-05 10:10:22',10,0),('5','271',203,'daily','2022-11-03','2022-11-05 10:13:02','2022-11-06 10:13:02','891',6818444.80,6818444.80,'891','2022-11-05 10:18:23','664','2022-11-05 10:19:31',10,0),('5','271',204,'daily','2022-11-04','2022-11-05 10:20:08','2022-11-06 10:20:08','891',6061678.40,6061678.40,'891','2022-11-05 10:25:15','664','2022-11-05 10:26:35',10,0),('5','271',205,'daily','2022-11-05','2022-11-05 10:33:22','2022-11-06 10:33:22','891',4342166.60,4342166.60,'891','2022-11-08 11:02:07','664','2022-11-08 11:05:34',10,0),('5','271',206,'daily','2022-11-06','2022-11-08 11:08:51','2022-11-09 11:08:51','891',4207333.20,4207333.20,'891','2022-11-08 11:13:05','664','2022-11-08 11:13:23',10,0),('5','271',207,'daily','2022-11-07','2022-11-08 11:17:30','2022-11-09 11:17:30','891',9380596.50,9380596.50,'891','2022-11-08 11:22:00','664','2022-11-08 11:23:14',10,0),('5','271',208,'daily','2022-11-08','2022-11-08 11:25:53','2022-11-09 11:25:53','891',4068410.70,4068410.70,'891','2022-11-17 11:31:00','664','2022-11-17 11:32:25',10,0),('5','271',209,'daily','2022-11-09','2022-11-17 11:34:53','2022-11-18 11:34:53','891',5818028.60,5818028.60,'891','2022-11-17 11:39:52','664','2022-11-17 11:41:21',10,0),('5','271',210,'daily','2022-11-10','2022-11-17 11:42:41','2022-11-18 11:42:41','891',5341103.65,5341103.65,'891','2022-11-17 11:47:02','664','2022-11-17 11:48:15',10,0),('5','271',211,'daily','2022-11-11','2022-11-17 11:49:10','2022-11-18 11:49:10','891',1808423.15,1808423.15,'891','2022-11-17 11:52:05','664','2022-11-17 11:53:12',10,0),('5','271',212,'daily','2022-11-12','2022-11-17 11:55:43','2022-11-18 11:55:43','891',2532043.85,2532043.85,'891','2022-11-17 12:02:59','664','2022-11-17 12:04:19',10,0),('5','271',213,'daily','2022-11-13','2022-11-17 12:05:59','2022-11-18 12:05:59','891',1066403.40,1066403.40,'891','2022-11-17 12:07:22','664','2022-11-17 12:08:09',10,0),('5','271',214,'daily','2022-11-14','2022-11-17 12:09:19','2022-11-18 12:09:19','891',1798654.40,1798654.40,'891','2022-11-20 11:35:28','664','2022-11-20 11:38:20',10,0),('5','271',215,'daily','2022-11-15','2022-11-20 11:38:49','2022-11-21 11:38:49','891',2514629.20,2514629.20,'891','2022-11-20 11:41:26','664','2022-11-20 11:47:42',10,0),('5','271',216,'daily','2022-11-16','2022-11-20 11:48:21','2022-11-21 11:48:21','891',2412491.15,2412491.15,'891','2022-11-20 11:50:07','664','2022-11-20 11:53:55',10,0),('5','271',217,'daily','2022-11-17','2022-11-20 11:54:19','2022-11-21 11:54:19','891',322400.00,322400.00,'891','2022-11-20 11:55:16','664','2022-11-20 11:56:39',10,0),('5','271',218,'daily','2022-11-18','2022-11-20 11:57:05','2022-11-21 11:57:05','891',2724039.45,2724039.45,'891','2022-11-20 11:58:12','664','2022-11-20 12:01:16',10,0),('5','271',219,'daily','2022-11-19','2022-11-20 12:02:30','2022-11-21 12:02:30','891',5992368.75,5992368.75,'891','2022-11-24 15:50:18','600','2022-11-24 16:12:30',10,0),('5','271',220,'daily','2022-11-20','2022-11-24 16:18:35','2022-11-25 16:18:35','891',3916980.50,3916980.50,'891','2022-11-24 16:23:14','600','2022-11-24 16:25:36',10,0),('5','271',221,'daily','2022-11-21','2022-11-24 16:31:08','2022-11-25 16:31:08','891',3724263.50,3724263.50,'891','2022-11-24 16:35:23','600','2022-11-24 16:39:06',10,0),('5','271',222,'daily','2022-11-22','2022-11-24 16:40:57','2022-11-25 16:40:57','891',3741382.30,3741382.30,'891','2022-11-24 17:42:47','600','2022-11-24 17:43:34',10,0),('5','271',223,'daily','2022-11-23','2022-11-24 17:45:10','2022-11-25 17:45:10','891',3325903.25,3325903.25,'891','2022-11-24 18:53:06','600','2022-11-24 18:54:10',10,0),('5','271',224,'daily','2022-11-24','2022-11-24 18:55:49','2022-11-25 18:55:49','891',1193549.15,1193549.15,'891','2022-11-24 21:03:29','600','2022-11-24 21:11:29',10,0),('5','271',225,'daily','2022-11-25','2022-11-26 11:15:01','2022-11-27 11:15:01','891',4107724.55,4107724.55,'891','2022-11-26 11:17:54','600','2022-11-26 11:19:48',10,0),('5','271',226,'daily','2022-11-26','2022-11-26 11:24:51','2022-11-27 11:24:51','891',2678100.30,2678100.30,'891','2022-11-26 20:20:34','664','2022-11-28 09:53:15',10,0),('5','271',227,'daily','2022-11-27','2022-11-28 09:54:26','2022-11-29 09:54:26','891',4760478.15,4760478.15,'891','2022-11-28 09:57:11','664','2022-11-29 08:08:07',10,0),('5','271',228,'daily','2022-11-28','2022-11-29 21:34:30','2022-11-30 21:34:30','891',3528733.85,3528733.85,'891','2022-11-29 21:37:26','664','2022-11-30 07:35:10',10,0),('5','271',229,'daily','2022-11-29','2022-11-30 18:38:47','2022-12-01 18:38:47','891',6235858.20,6235858.20,'891','2022-12-01 16:49:02','664','2022-12-02 07:12:46',10,0),('5','271',230,'daily','2022-11-30','2022-12-02 09:33:25','2022-12-03 09:33:25','891',3871276.70,3871276.70,'891','2022-12-02 09:36:32','664','2022-12-03 08:25:38',10,0),('5','271',231,'daily','2022-12-01','2022-12-03 16:16:58','2022-12-04 16:16:58','891',664632.85,664632.85,'891','2022-12-03 16:19:51','600','2022-12-03 16:23:25',10,0),('5','271',232,'daily','2022-12-02','2022-12-03 16:26:12','2022-12-04 16:26:12','891',3649659.65,3649659.65,'891','2022-12-03 16:32:04','600','2022-12-03 16:52:20',10,0),('5','271',233,'daily','2022-12-03','2022-12-03 17:45:45','2022-12-04 17:45:45','891',5100070.75,5100070.75,'891','2022-12-04 17:20:15','600','2022-12-04 20:42:13',10,0),('5','271',234,'daily','2022-12-04','2022-12-04 20:47:39','2022-12-05 20:47:39','891',5367734.30,5367734.30,'891','2022-12-04 20:51:38','664','2022-12-05 07:37:39',10,0),('5','271',235,'daily','2022-12-05','2022-12-06 09:42:54','2022-12-07 09:42:54','891',5476752.95,5476752.95,'891','2022-12-06 09:54:10','664','2022-12-06 10:07:13',10,0),('5','271',236,'daily','2022-12-06','2022-12-06 21:10:42','2022-12-07 21:10:42','891',5821434.22,5821434.22,'891','2022-12-06 21:25:49','664','2022-12-07 07:50:53',10,0),('5','271',237,'daily','2022-12-07','2022-12-08 10:01:07','2022-12-09 10:01:07','891',5031008.40,5031008.40,'891','2022-12-08 10:04:20','664','2022-12-09 08:13:40',10,0),('5','271',238,'daily','2022-12-08','2022-12-09 09:55:27','2022-12-10 09:55:27','891',1728303.30,1728303.30,'891','2022-12-09 09:57:53','664','2022-12-09 10:39:53',10,0),('5','271',239,'daily','2022-12-09','2022-12-10 09:22:13','2022-12-11 09:22:13','891',2051122.75,2051122.75,'891','2022-12-10 09:23:45','664','2022-12-10 10:32:16',10,0),('5','271',240,'daily','2022-12-10','2022-12-11 09:39:16','2022-12-12 09:39:16','891',422997.55,422997.55,'891','2022-12-11 09:41:55','664','2022-12-12 08:07:41',10,0),('5','271',241,'daily','2022-12-11','2022-12-12 13:34:08','2022-12-13 13:34:08','891',23315.55,23315.55,'891','2022-12-12 14:00:06','664','2022-12-12 20:20:22',10,0),('5','271',242,'daily','2022-12-12','2022-12-13 13:06:03','2022-12-14 13:06:03','891',0.00,0.00,'891','2022-12-13 13:07:25','606','2022-12-13 14:16:32',10,0),('5','271',243,'daily','2022-12-13','2022-12-13 15:08:44','2022-12-14 15:08:44','891',43763.25,43763.25,'891','2022-12-14 11:02:25','664','2022-12-14 16:59:51',10,0),('5','271',244,'daily','2022-12-14','2022-12-15 09:09:00','2022-12-16 09:09:00','891',1254257.40,1254257.40,'891','2022-12-15 09:10:05','664','2022-12-15 10:02:03',10,0),('5','271',245,'daily','2022-12-15','2022-12-16 09:19:45','2022-12-17 09:19:45','891',55471.80,55471.80,'891','2022-12-16 09:21:03','600','2022-12-16 09:35:26',10,0),('5','271',246,'daily','2022-12-16','2022-12-16 19:19:06','2022-12-17 19:19:06','891',0.00,0.00,'891','2022-12-17 09:00:42','600','2022-12-17 10:30:15',10,0),('5','271',247,'daily','2022-12-17','2022-12-18 09:15:46','2022-12-19 09:15:46','891',456367.95,456367.95,'891','2022-12-18 09:17:09','600','2022-12-18 09:27:46',10,0),('5','271',248,'daily','2022-12-18','2022-12-18 22:20:22','2022-12-19 22:20:22','891',4910183.35,4910183.35,'891','2022-12-18 22:24:13','600','2022-12-19 07:00:09',10,0),('5','271',249,'daily','2022-12-19','2022-12-19 17:34:47','2022-12-20 17:34:47','891',4789123.15,4789123.15,'891','2022-12-20 09:56:21','600','2022-12-20 20:46:48',10,0),('5','271',250,'daily','2022-12-20','2022-12-20 21:07:05','2022-12-21 21:07:05','891',5007231.60,5007231.60,'891','2022-12-20 21:22:06','600','2022-12-21 09:30:05',10,0),('5','271',251,'daily','2022-12-21','2022-12-21 21:21:56','2022-12-22 21:21:56','891',5750937.25,5750937.25,'891','2022-12-21 22:07:34','600','2022-12-22 09:48:26',10,0),('5','271',252,'daily','2022-12-22','2022-12-23 09:17:37','2022-12-24 09:17:37','891',5991523.15,5991523.15,'891','2022-12-23 09:21:45','600','2022-12-23 09:52:54',10,0),('5','271',253,'daily','2022-12-23','2022-12-23 17:56:02','2022-12-24 17:56:02','891',3224152.65,3224152.65,'891','2022-12-23 21:06:01','600','2022-12-24 07:19:41',10,0),('5','271',254,'daily','2022-12-24','2022-12-24 08:33:19','2022-12-25 08:33:19','891',3069239.00,3069239.00,'891','2022-12-25 09:35:15','600','2022-12-25 09:38:24',10,0),('5','271',255,'daily','2022-12-25','2022-12-25 09:53:11','2022-12-26 09:53:11','891',1214012.26,1214012.26,'891','2022-12-26 09:59:37','600','2022-12-26 10:05:45',10,0),('5','271',256,'daily','2022-12-26','2022-12-26 20:13:20','2022-12-27 20:13:20','891',3779015.15,3779015.15,'891','2022-12-26 20:46:00','600','2022-12-27 09:36:27',10,0),('5','271',257,'daily','2022-12-27','2022-12-27 19:31:18','2022-12-28 19:31:18','891',1236630.45,1236630.45,'891','2022-12-27 20:27:11','600','2022-12-28 09:32:23',10,0),('5','271',258,'daily','2022-12-28','2022-12-28 16:19:08','2022-12-29 16:19:08','891',309431.00,309431.00,'891','2022-12-28 20:19:41','600','2022-12-29 09:39:45',10,0),('5','271',259,'daily','2022-12-29','2022-12-29 18:51:45','2022-12-30 18:51:45','891',310519.95,310519.95,'891','2022-12-29 20:57:04','600','2022-12-30 10:26:19',10,0),('5','271',260,'daily','2022-12-30','2022-12-30 14:33:18','2022-12-31 14:33:18','891',0.00,0.00,'891','2022-12-31 10:13:19','600','2022-12-31 15:31:13',10,0),('5','271',261,'daily','2022-12-31','2022-12-31 15:58:21','2023-01-01 15:58:21','891',262570.65,262570.65,'891','2022-12-31 20:30:29','600','2023-01-01 09:27:15',10,0),('5','271',262,'daily','2023-01-01','2023-01-01 19:13:43','2023-01-02 19:13:43','891',0.00,0.00,'891','2023-01-01 20:02:34','600','2023-01-02 08:55:38',10,0),('5','271',263,'daily','2023-01-02','2023-01-02 15:04:12','2023-01-03 15:04:12','891',0.00,0.00,'891','2023-01-02 19:19:28','600','2023-01-03 07:39:32',10,0),('5','271',264,'daily','2023-01-03','2023-01-03 14:04:10','2023-01-04 14:04:10','891',205892.60,205892.60,'891','2023-01-03 20:38:53','600','2023-01-04 09:16:04',10,0),('5','271',265,'daily','2023-01-04','2023-01-04 18:07:38','2023-01-05 18:07:38','891',730183.00,730183.00,'891','2023-01-05 09:15:34','600','2023-01-05 09:55:59',10,0),('5','271',266,'daily','2023-01-05','2023-01-05 18:30:42','2023-01-06 18:30:42','891',0.00,0.00,'891','2023-01-06 19:20:47','600','2023-01-06 21:19:41',10,0),('5','271',267,'daily','2023-01-06','2023-01-06 21:21:32','2023-01-07 21:21:32','891',233060.00,233060.00,'891','2023-01-06 21:23:04','600','2023-01-06 21:30:09',10,0),('5','271',268,'daily','2023-01-07','2023-01-07 03:30:40','2023-01-08 03:30:40','891',1325810.40,1325810.40,'891','2023-01-07 20:53:38','600','2023-01-08 12:45:11',10,0),('5','271',269,'daily','2023-01-08','2023-01-08 12:49:39','2023-01-09 12:49:39','891',408044.20,408044.20,'891','2023-01-08 21:37:56','600','2023-01-09 06:40:32',10,0),('5','271',270,'daily','2023-01-09','2023-01-09 09:42:10','2023-01-10 09:42:10','891',0.00,0.00,'891','2023-01-10 08:41:26','600','2023-01-10 09:07:40',10,0),('5','271',271,'daily','2023-01-10','2023-01-10 20:39:15','2023-01-11 20:39:15','891',6082377.55,6082377.55,'891','2023-01-10 20:41:22','600','2023-01-11 08:28:54',10,0),('5','271',272,'daily','2023-01-11','2023-01-11 14:58:18','2023-01-12 14:58:18','891',2631238.70,2631238.70,'891','2023-01-11 21:02:08','600','2023-01-12 06:21:51',10,0),('5','271',273,'daily','2023-01-12','2023-01-12 21:42:53','2023-01-13 21:42:53','891',0.00,0.00,'891','2023-01-12 21:43:21','600','2023-01-13 06:29:22',10,0),('5','271',274,'daily','2023-01-13','2023-01-13 18:17:40','2023-01-14 18:17:40','891',74200.80,74200.80,'891','2023-01-13 19:41:17','600','2023-01-14 14:45:12',10,0),('5','271',275,'daily','2023-01-14','2023-01-14 20:00:00','2023-01-15 20:00:00','891',481375.10,481375.10,'891','2023-01-14 20:51:28','600','2023-01-15 09:29:11',10,0),('5','271',276,'daily','2023-01-15','2023-01-15 17:38:07','2023-01-16 17:38:07','891',0.00,0.00,'891','2023-01-16 08:37:00','600','2023-01-16 20:51:49',10,0),('5','271',277,'daily','2023-01-16','2023-01-16 20:54:11','2023-01-17 20:54:11','891',3619674.40,3619674.40,'891','2023-01-16 20:58:58','600','2023-01-17 08:24:41',10,0),('5','271',278,'daily','2023-01-17','2023-01-17 19:25:49','2023-01-18 19:25:49','891',5163298.35,5163298.35,'891','2023-01-18 17:35:23','600','2023-01-19 08:26:39',10,0),('5','271',279,'daily','2023-01-18','2023-01-19 08:49:14','2023-01-20 08:49:14','891',3530279.20,3530279.20,'891','2023-01-19 09:00:27','600','2023-01-19 18:58:19',10,0),('5','271',280,'daily','2023-01-19','2023-01-19 19:19:48','2023-01-20 19:19:48','891',2666220.80,2666220.80,'891','2023-01-19 20:55:05','600','2023-01-20 08:32:15',10,0),('5','271',281,'daily','2023-01-20','2023-01-20 11:51:49','2023-01-21 11:51:49','891',175687.10,175687.10,'891','2023-01-20 11:52:49','600','2023-01-20 12:00:55',10,0),('5','271',282,'daily','2023-01-20','2023-01-20 12:04:27','2023-01-21 12:04:27','891',583935.30,583935.30,'891','2023-01-20 20:55:06','600','2023-01-21 10:07:34',10,0),('5','271',283,'daily','2023-01-21','2023-01-21 17:58:42','2023-01-22 17:58:42','891',3981749.90,3981749.90,'891','2023-01-22 18:39:00','600','2023-01-23 08:18:02',10,0),('5','271',284,'daily','2023-01-22','2023-01-23 09:59:55','2023-01-24 09:59:55','891',5360995.40,5360995.40,'891','2023-01-23 10:10:48','600','2023-01-23 20:49:49',10,0),('5','271',285,'daily','2023-01-23','2023-01-23 20:52:55','2023-01-24 20:52:55','891',4792997.80,4792997.80,'891','2023-01-23 20:56:10','600','2023-01-24 08:27:06',10,0),('5','271',286,'daily','2023-01-24','2023-01-24 19:22:11','2023-01-25 19:22:11','891',5719277.30,5719277.30,'891','2023-01-24 20:09:04','600','2023-01-25 09:16:53',10,0),('5','271',287,'daily','2023-01-25','2023-01-25 17:08:38','2023-01-26 17:08:38','891',2169226.50,2169226.50,'891','2023-01-25 20:35:43','600','2023-01-26 09:00:30',10,0),('5','271',288,'daily','2023-01-26','2023-01-26 20:58:54','2023-01-27 20:58:54','891',555235.10,555235.10,'891','2023-01-27 15:11:06','600','2023-01-27 15:13:52',10,0),('5','271',289,'daily','2023-01-27','2023-01-27 15:17:49','2023-01-28 15:17:49','891',3869037.00,3869037.00,'891','2023-01-27 20:45:32','600','2023-01-28 12:01:22',10,0),('5','271',290,'daily','2023-01-28','2023-01-28 20:14:40','2023-01-29 20:14:40','891',4555307.30,4555307.30,'891','2023-01-29 07:11:05','600','2023-01-29 11:58:05',10,0),('5','271',291,'daily','2023-01-29','2023-01-29 18:48:53','2023-01-30 18:48:53','891',725033.60,725033.60,'891','2023-01-29 20:55:14','600','2023-01-30 09:02:16',10,0),('5','271',292,'daily','2023-01-30','2023-01-30 18:19:52','2023-01-31 18:19:52','891',230574.00,230574.00,'891','2023-01-30 20:44:29','600','2023-01-31 10:12:23',10,0),('5','271',293,'daily','2023-01-31','2023-01-31 14:55:04','2023-02-01 14:55:04','891',256685.80,256685.80,'891','2023-01-31 21:12:22','600','2023-02-01 07:28:41',10,0),('5','271',294,'daily','2023-02-01','2023-02-02 08:29:52','2023-02-03 08:29:52','891',7165512.80,7165512.80,'891','2023-02-02 13:49:52','600','2023-02-02 13:55:34',10,0),('5','271',295,'daily','2023-02-02','2023-02-03 08:21:30','2023-02-04 08:21:30','891',3967356.80,3967356.80,'891','2023-02-03 08:28:47','600','2023-02-03 09:15:33',10,0),('5','271',296,'daily','2023-02-03','2023-02-03 20:37:59','2023-02-04 20:37:59','891',4425393.50,4425393.50,'891','2023-02-03 20:52:04','600','2023-02-04 13:18:58',10,0),('5','271',297,'daily234','2023-02-04','2023-02-04 20:10:21','2023-02-05 20:10:21','891',949632.60,949632.60,'891','2023-02-04 20:57:26','600','2023-02-05 15:08:56',10,0),('5','271',298,'daily','2023-02-05','2023-02-06 09:50:02','2023-02-07 09:50:02','891',2136818.40,2136818.40,'891','2023-02-06 09:50:51','600','2023-02-06 11:08:14',10,0),('5','271',299,'daily','2023-02-06','2023-02-06 21:36:18','2023-02-07 21:36:18','891',772452.30,772452.30,'891','2023-02-07 09:58:36','600','2023-02-08 08:38:51',10,0),('5','271',300,'daily','2023-02-07','2023-02-08 08:45:06','2023-02-09 08:45:06','891',5918026.00,5918026.00,'891','2023-02-08 08:47:43','600','2023-02-08 13:59:11',10,0),('5','271',301,'daily','2023-02-08','2023-02-09 08:07:10','2023-02-10 08:07:10','891',6809264.80,6809264.80,'891','2023-02-09 09:11:47','600','2023-02-09 09:13:57',10,0),('5','271',302,'daily','2023-02-09','2023-02-10 08:02:41','2023-02-11 08:02:41','891',6048887.10,6048887.10,'891','2023-02-10 08:33:06','600','2023-02-10 09:26:32',10,0),('5','271',303,'daily','2023-02-10','2023-02-10 21:10:54','2023-02-11 21:10:54','891',3890988.80,3890988.80,'891','2023-02-10 21:16:07','600','2023-02-11 14:00:12',10,0),('5','271',304,'daily','2023-02-11','2023-02-11 17:16:47','2023-02-12 17:16:47','891',1133697.00,1133697.00,'891','2023-02-11 22:12:53','600','2023-02-12 14:16:05',10,0),('5','271',305,'daily','2023-02-12','2023-02-12 16:54:57','2023-02-13 16:54:57','891',210512.90,210512.90,'891','2023-02-12 21:27:21','600','2023-02-13 09:06:21',10,0),('5','271',306,'daily','2023-02-13','2023-02-13 13:13:40','2023-02-14 13:13:40','891',542886.40,542886.40,'891','2023-02-13 21:01:20','600','2023-02-14 09:35:02',10,0),('5','271',307,'daily','2023-02-14','2023-02-14 15:10:45','2023-02-15 15:10:45','891',0.00,0.00,'891','2023-02-14 22:11:13','600','2023-02-15 08:59:06',10,0),('5','271',308,'daily','2023-02-15','2023-02-15 22:43:26','2023-02-16 22:43:26','891',1091657.50,1091657.50,'891','2023-02-15 22:44:02','600','2023-02-16 11:50:44',10,0),('5','271',309,'daily','2023-02-16','2023-02-16 18:52:01','2023-02-17 18:52:01','891',0.00,0.00,'891','2023-02-16 20:50:47','600','2023-02-17 10:30:55',10,0),('5','271',310,'daily','2023-02-17','2023-02-17 14:08:33','2023-02-18 14:08:33','891',0.00,0.00,'891','2023-02-18 08:59:27','600','2023-02-18 21:25:10',10,0),('5','271',311,'daily','2023-02-18','2023-02-18 21:49:20','2023-02-19 21:49:20','891',173387.00,173387.00,'891','2023-02-18 21:50:16','600','2023-02-19 17:43:14',10,0),('5','271',312,'daily','2023-02-19','2023-02-20 10:55:51','2023-02-21 10:55:51','891',415397.70,415397.70,'891','2023-02-20 12:56:32','600','2023-02-20 13:28:20',10,0),('5','271',313,'daily','2023-02-20','2023-02-21 13:11:32','2023-02-22 13:11:32','891',9004406.50,9004406.50,'891','2023-02-21 13:14:53','600','2023-02-21 13:42:46',10,0),('5','271',314,'daily','2023-02-21','2023-02-21 20:31:08','2023-02-22 20:31:08','891',1929026.40,1929026.40,'600','2023-02-22 14:05:04','600','2023-02-22 14:05:17',10,0),('5','271',315,'daily','2023-02-22','2023-02-22 23:35:24','2023-02-23 23:35:24','891',91643.20,91643.20,'891','2023-02-22 23:36:42','600','2023-02-23 10:09:07',10,0),('5','271',316,'daily','2023-02-23','2023-02-23 17:10:56','2023-02-24 17:10:56','891',95915.40,95915.40,'891','2023-02-24 08:02:40','600','2023-02-24 09:08:57',10,0),('5','271',317,'daily','2023-02-24','2023-02-24 20:41:30','2023-02-25 20:41:30','891',6151050.00,6151050.00,'891','2023-02-25 09:43:44','600','2023-02-25 10:49:40',10,0),('5','271',318,'daily','2023-02-25','2023-02-26 15:39:16','2023-02-27 15:39:16','891',0.00,0.00,'891','2023-02-26 15:40:48','600','2023-02-27 09:49:08',10,0),('5','271',319,'daily','2023-02-26','2023-02-27 13:22:53','2023-02-28 13:22:53','891',0.00,0.00,'891','2023-02-27 13:24:20','600','2023-02-28 08:29:15',10,0),('5','271',320,'daily','2023-02-27','2023-02-28 13:19:34','2023-03-01 13:19:34','891',6760531.10,6760531.10,'891','2023-02-28 13:25:50','600','2023-02-28 21:20:34',10,0),('5','271',321,'daily','2023-02-28','2023-03-01 08:32:06','2023-03-02 08:32:06','891',7564664.10,7564664.10,'891','2023-03-01 08:36:56','600','2023-03-01 10:08:00',10,0),('5','271',322,'daily','2023-03-01','2023-03-01 14:16:50','2023-03-02 14:16:50','891',8382899.00,8382899.00,'891','2023-03-02 09:14:40','600','2023-03-02 09:28:35',10,0),('5','271',323,'daily','2023-03-02','2023-03-03 08:19:04','2023-03-04 08:19:04','891',12334507.30,12334507.30,'891','2023-03-03 08:25:31','600','2023-03-03 08:56:52',10,0),('5','271',324,'daily','2023-03-03','2023-03-04 07:51:45','2023-03-05 07:51:45','891',9776821.20,9776821.20,'891','2023-03-04 14:56:28','600','2023-03-04 18:09:28',10,0),('5','271',325,'daily','2023-03-04','2023-03-05 07:01:13','2023-03-06 07:01:13','891',13770147.30,13770147.30,'891','2023-03-05 07:08:17','600','2023-03-05 11:23:30',10,0),('5','271',326,'daily','2023-03-05','2023-03-06 07:03:30','2023-03-07 07:03:30','891',10389435.30,10389435.30,'891','2023-03-07 07:41:38','600','2023-03-07 08:21:35',10,0),('5','271',327,'daily','2023-03-06','2023-03-07 08:31:05','2023-03-08 08:31:05','891',9058566.00,9058566.00,'891','2023-03-08 10:42:33','600','2023-03-08 22:28:05',10,0),('5','271',328,'daily','2023-03-07','2023-03-08 22:32:56','2023-03-09 22:32:56','891',11314612.80,11314612.80,'891','2023-03-08 23:42:45','600','2023-03-09 06:07:50',10,0),('5','271',329,'daily','2023-03-08','2023-03-09 06:11:32','2023-03-10 06:11:32','891',13099979.20,13099979.20,'891','2023-03-09 22:21:38','600','2023-03-10 06:36:22',10,0),('5','271',330,'daily','2023-03-09','2023-03-10 10:31:37','2023-03-11 10:31:37','891',10381940.20,10381940.20,'891','2023-03-10 21:46:59','600','2023-03-10 22:05:11',10,0),('5','271',331,'daily','2023-03-10','2023-03-11 09:08:54','2023-03-12 09:08:54','891',7954221.60,7954221.60,'891','2023-03-11 09:12:56','600','2023-03-11 22:53:47',10,0),('5','271',332,'daily','2023-03-11','2023-03-12 08:28:24','2023-03-13 08:28:24','891',2172594.10,2172594.10,'891','2023-03-12 08:29:38','600','2023-03-12 09:22:19',10,0),('5','271',333,'daily','2023-03-12','2023-03-13 09:18:39','2023-03-14 09:18:39','891',1047757.70,1047757.70,'891','2023-03-13 09:23:13','600','2023-03-13 12:49:12',10,0),('5','271',334,'daily','2023-03-13','2023-03-13 14:11:06','2023-03-14 14:11:06','891',337266.00,337266.00,'891','2023-03-14 08:46:39','600','2023-03-14 09:30:07',10,0),('5','271',335,'daily','2023-03-14','2023-03-14 14:29:51','2023-03-15 14:29:51','891',126280.00,126280.00,'891','2023-03-15 09:03:59','600','2023-03-15 11:44:58',10,0),('5','271',336,'daily','2023-03-15','2023-03-16 08:42:55','2023-03-17 08:42:55','891',37211.60,37211.60,'891','2023-03-16 08:43:56','600','2023-03-16 13:41:20',10,0),('5','271',337,'daily','2023-03-16','2023-03-16 15:34:01','2023-03-17 15:34:01','891',582421.40,582421.40,'891','2023-03-16 21:00:04','600','2023-03-17 12:01:09',10,0),('5','271',338,'daily','2023-03-17','2023-03-17 14:59:34','2023-03-18 14:59:34','891',305671.40,305671.40,'891','2023-03-17 21:41:40','600','2023-03-18 10:12:00',10,0),('5','271',339,'daily','2023-03-18','2023-03-18 20:47:15','2023-03-19 20:47:15','891',0.00,0.00,'891','2023-03-18 20:49:00','600','2023-03-19 10:02:55',10,0),('5','271',340,'daily','2023-03-19','2023-03-19 19:56:29','2023-03-20 19:56:29','891',0.00,0.00,'891','2023-03-19 19:57:12','600','2023-03-20 08:40:33',10,0),('5','271',341,'daily','2023-03-20','2023-03-21 00:59:06','2023-03-22 00:59:06','891',0.00,0.00,'891','2023-03-21 00:59:31','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=7503 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','271','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',7,'7','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',8,'8','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',9,'9','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',10,'10','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',11,'11','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','1',12,'12','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','1',13,'13','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','1',14,'14','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','1',15,'15','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','1',16,'16','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','1',17,'17','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','1',18,'18','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','1',19,'19','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','1',20,'20','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','1',21,'21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','1',22,'22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',23,'1','1',67.83,4090.92,4023.09,663809.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',24,'2','1',148.00,4285.34,4137.34,682661.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',25,'3','1',70.28,4487.07,4416.79,728770.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',26,'4','1',113.04,3676.90,3563.86,588036.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',27,'5','1',88.24,3987.31,3899.07,643346.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','2',28,'6','1',154.73,2822.13,2667.40,440121.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',29,'7','1',159.87,3050.13,2890.26,476892.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',30,'8','1',74.73,2048.83,1974.10,325726.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',31,'9','1',75.46,2709.61,2634.15,434634.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',32,'10','1',316.37,3036.83,2720.46,448875.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',33,'11','1',252.33,2330.50,2078.17,342898.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','2',34,'12','1',202.64,2548.96,2346.32,387142.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','2',35,'13','1',206.50,467.89,261.39,43129.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','2',36,'14','1',98.33,563.27,464.94,76715.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','2',37,'15','1',78.04,2709.98,2631.94,434270.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','2',38,'16','1',140.18,1561.20,1421.02,234468.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','2',39,'17','1',79.56,4588.92,4509.36,744044.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','2',40,'18','1',89.68,5084.79,4995.11,824193.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','2',41,'19','1',72.55,2041.25,1968.70,324835.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','2',42,'20','1',214.90,1986.15,1771.25,292256.25,0.00,0.00,0.00,0.00,0.00),('5','271','5','2',43,'21','2',84.56,84.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','2',44,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',45,'1','1',4090.92,9171.83,5080.91,838350.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',46,'2','1',4285.34,9255.70,4970.36,820109.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',47,'3','1',4487.07,7459.66,2972.59,490477.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',48,'4','1',3676.90,5294.91,1618.01,266971.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',49,'5','1',3987.31,8038.60,4051.29,668462.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','3',50,'6','1',2822.13,5725.88,2903.75,479118.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',51,'7','1',3050.13,6062.73,3012.60,497079.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',52,'8','1',2048.83,6320.03,4271.20,704748.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',53,'9','1',2709.61,7390.99,4681.38,772427.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',54,'10','1',3036.83,6846.71,3809.88,628630.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',55,'11','1',2330.50,4792.01,2461.51,406149.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','3',56,'12','1',2548.96,3976.43,1427.47,235532.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','3',57,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','3',58,'14','1',563.27,563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','3',59,'15','1',2709.98,6003.38,3293.40,543411.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','3',60,'16','1',1561.20,4914.01,3352.81,553213.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','3',61,'17','1',4588.92,10197.78,5608.86,925461.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','3',62,'18','1',5084.79,11171.82,6087.03,1004359.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','3',63,'19','1',2041.25,6193.58,4152.33,685134.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','3',64,'20','1',1986.15,6099.03,4112.88,678625.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','3',65,'21','2',84.56,577.47,492.91,325320.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','3',66,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',67,'1','1',9171.83,15465.96,6294.13,1038531.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',68,'2','1',9255.70,19233.60,9977.90,1646353.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',69,'3','1',7459.66,14827.96,7368.30,1215769.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',70,'4','1',5294.91,5322.04,27.13,4476.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',71,'5','1',8038.60,12889.09,4850.49,800330.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','4',72,'6','1',5725.88,9929.51,4203.63,693598.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',73,'7','1',6062.73,8698.99,2636.26,434982.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',74,'8','1',6320.03,8770.64,2450.61,404350.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',75,'9','1',7390.99,11202.59,3811.60,628914.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',76,'10','1',6846.71,10040.76,3194.05,527018.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',77,'11','1',4792.01,4991.95,199.94,32990.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','4',78,'12','1',3976.43,4165.78,189.35,31242.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','4',79,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','4',80,'14','1',563.27,563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','4',81,'15','1',6003.38,14011.02,8007.64,1321260.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','4',82,'16','1',4914.01,12095.93,7181.92,1185016.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','4',83,'17','1',10197.78,12163.82,1966.04,324396.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','4',84,'18','1',11171.82,14768.90,3597.08,593518.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','4',85,'19','1',6193.58,7700.67,1507.09,248669.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','4',86,'20','1',6099.03,10318.14,4219.11,696153.15,0.00,0.00,0.00,0.00,0.00),('5','271','5','4',87,'21','2',577.47,3714.09,3136.62,2070169.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','4',88,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',89,'1','1',15465.96,19901.60,4435.64,731880.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',90,'2','1',19233.60,24126.07,4892.47,807257.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',91,'3','1',14827.96,15740.08,912.12,150499.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',92,'4','1',5322.04,5322.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',93,'5','1',12889.09,17977.01,5087.92,839506.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','5',94,'6','1',9929.51,12545.88,2616.37,431701.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',95,'7','1',8698.99,15576.43,6877.44,1134777.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',96,'8','1',8770.64,15051.94,6281.30,1036414.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',97,'9','1',11202.59,15563.36,4360.77,719527.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',98,'10','1',10040.76,14164.47,4123.71,680412.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',99,'11','1',4991.95,8136.37,3144.42,518829.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','5',100,'12','1',4165.78,8071.11,3905.33,644379.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','5',101,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','5',102,'14','1',563.27,563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','5',103,'15','1',14011.02,20171.47,6160.45,1016474.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','5',104,'16','1',12095.93,16086.82,3990.89,658496.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','5',105,'17','1',12163.82,16584.87,4421.05,729473.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','5',106,'18','1',14768.90,20775.45,6006.55,991080.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','5',107,'19','1',7700.67,12275.99,4575.32,754927.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','5',108,'20','1',10318.14,12884.70,2566.56,423482.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','5',109,'21','2',3714.09,5450.08,1735.99,1145753.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','5',110,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',111,'1','1',19901.60,25182.82,5281.22,871401.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',112,'2','1',24126.07,29544.97,5418.90,894118.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',113,'3','1',15740.08,22180.84,6440.76,1062725.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',114,'4','1',5322.04,5326.54,4.50,742.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',115,'5','1',17977.01,26064.35,8087.34,1334411.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','6',116,'6','1',12545.88,18436.56,5890.68,971962.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',117,'7','1',15576.43,18469.42,2892.99,477343.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',118,'8','1',15051.94,20770.40,5718.46,943545.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',119,'9','1',15563.36,21240.64,5677.28,936751.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',120,'10','1',14164.47,20954.55,6790.08,1120363.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',121,'11','1',8136.37,12592.59,4456.22,735276.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','6',122,'12','1',8071.11,10323.31,2252.20,371613.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','6',123,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','6',124,'14','1',563.27,563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','6',125,'15','1',20171.47,24199.41,4027.94,664610.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','6',126,'16','1',16086.82,19871.49,3784.67,624470.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','6',127,'17','1',16584.87,20193.48,3608.61,595420.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','6',128,'18','1',20775.45,28933.95,8158.50,1346152.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','6',129,'19','1',12275.99,18619.25,6343.26,1046637.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','6',130,'20','1',12884.70,16485.28,3600.58,594095.70,0.00,0.00,0.00,0.00,0.00),('5','271','5','6',131,'21','2',5450.08,7863.64,2413.56,1592949.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','6',132,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',133,'1','1',25182.82,25182.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',134,'2','1',29544.97,29544.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',135,'3','1',22180.84,22180.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',136,'4','1',5326.54,5326.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',137,'5','1',26064.35,26064.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','7',138,'6','1',18436.56,18436.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',139,'7','1',18469.42,18469.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',140,'8','1',20770.40,20770.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',141,'9','1',21240.64,21240.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',142,'10','1',20954.55,20954.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',143,'11','1',12592.59,12592.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','7',144,'12','1',10323.31,10323.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','7',145,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','7',146,'14','1',563.27,563.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','7',147,'15','1',24199.41,24199.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','7',148,'16','1',19871.49,19871.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','7',149,'17','1',20193.48,20193.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','7',150,'18','1',28933.95,28933.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','7',151,'19','1',18619.25,18619.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','7',152,'20','1',16485.28,16485.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','7',153,'21','2',7863.64,7863.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','7',154,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',155,'1','1',25182.82,29387.19,4204.37,693721.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',156,'2','1',29544.97,38008.57,8463.60,1396494.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',157,'3','1',22180.84,27467.06,5286.22,872226.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',158,'4','1',5326.54,5333.39,6.85,1130.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',159,'5','1',26064.35,27439.12,1374.77,226837.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','8',160,'6','1',18436.56,25093.51,6656.95,1098396.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',161,'7','1',18469.42,20146.70,1677.28,276751.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',162,'8','1',20770.40,23697.10,2926.70,482905.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',163,'9','1',21240.64,28343.58,7102.94,1171985.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',164,'10','1',20954.55,29187.56,8233.01,1358446.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',165,'11','1',12592.59,14782.36,2189.77,361312.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','8',166,'12','1',10323.31,10423.67,100.36,16559.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','8',167,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','8',168,'14','1',563.27,3447.75,2884.48,475939.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','8',169,'15','1',24199.41,31371.88,7172.47,1183457.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','8',170,'16','1',19871.49,27895.23,8023.74,1323917.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','8',171,'17','1',20193.48,20742.00,548.52,90505.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','8',172,'18','1',28933.95,36092.45,7158.50,1181152.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','8',173,'19','1',18619.25,25219.04,6599.79,1088965.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','8',174,'20','1',16485.28,16834.16,348.88,57565.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','8',175,'21','2',7863.64,10376.62,2512.98,1658566.80,0.00,0.00,0.00,0.00,0.00),('5','271','5','8',176,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',177,'1','1',29387.19,29614.14,226.95,37446.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',178,'2','1',38008.57,48210.76,10202.19,1683361.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',179,'3','1',27467.06,29946.18,2479.12,409054.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',180,'4','1',5333.39,5339.39,6.00,990.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',181,'5','1',27439.12,27488.50,49.38,8147.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','9',182,'6','1',25093.51,29388.06,4294.55,708600.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',183,'7','1',20146.70,20202.57,55.87,9218.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',184,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',185,'9','1',28343.58,33264.50,4920.92,811951.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',186,'10','1',29187.56,35094.24,5906.68,974602.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',187,'11','1',14782.36,19371.26,4588.90,757168.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','9',188,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','9',189,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','9',190,'14','1',3447.75,15112.13,11664.38,1924622.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','9',191,'15','1',31371.88,36960.10,5588.22,922056.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','9',192,'16','1',27895.23,34853.26,6958.03,1148074.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','9',193,'17','1',20742.00,20953.08,211.08,34828.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','9',194,'18','1',36092.45,45570.18,9477.73,1563825.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','9',195,'19','1',25219.04,33240.62,8021.58,1323560.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','9',196,'20','1',16834.16,17147.46,313.30,51694.50,0.00,0.00,0.00,0.00,0.00),('5','271','5','9',197,'21','2',10376.62,11714.60,1337.98,883066.80,0.00,0.00,0.00,0.00,0.00),('5','271','5','9',198,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',199,'1','1',29614.14,29614.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',200,'2','1',48210.76,59096.01,10885.25,1796066.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',201,'3','1',29946.18,39238.03,9291.85,1533155.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',202,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',203,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','10',204,'6','1',29388.06,39530.44,10142.38,1673492.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',205,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',206,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',207,'9','1',33264.50,38366.08,5101.58,841760.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',208,'10','1',35094.24,42872.62,7778.38,1283432.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',209,'11','1',19371.26,23625.39,4254.13,701931.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','10',210,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','10',211,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','10',212,'14','1',15112.13,23158.83,8046.70,1327705.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','10',213,'15','1',36960.10,42805.90,5845.80,964557.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','10',214,'16','1',34853.26,42119.72,7266.46,1198965.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','10',215,'17','1',20953.08,20953.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','10',216,'18','1',45570.18,52444.41,6874.23,1134247.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','10',217,'19','1',33240.62,39022.30,5781.68,953977.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','10',218,'20','1',17147.46,17147.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','10',219,'21','2',11714.60,15079.00,3364.40,2220504.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','10',220,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',221,'1','1',29614.14,29616.66,2.52,415.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',222,'2','1',59096.01,63148.70,4052.69,668693.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',223,'3','1',39238.03,41954.53,2716.50,448222.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',224,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',225,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','11',226,'6','1',39530.44,42937.69,3407.25,562196.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',227,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',228,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',229,'9','1',38366.08,44228.00,5861.92,967216.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',230,'10','1',42872.62,46673.91,3801.29,627212.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',231,'11','1',23625.39,27663.58,4038.19,666301.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','11',232,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','11',233,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','11',234,'14','1',23158.83,31928.83,8770.00,1447050.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','11',235,'15','1',42805.90,44908.23,2102.33,346884.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','11',236,'16','1',42119.72,49574.54,7454.82,1230045.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','11',237,'17','1',20953.08,20955.67,2.59,427.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','11',238,'18','1',52444.41,61510.41,9066.00,1495890.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','11',239,'19','1',39022.30,45462.87,6440.57,1062694.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','11',240,'20','1',17147.46,17250.73,103.27,17039.55,0.00,0.00,0.00,0.00,0.00),('5','271','5','11',241,'21','2',15079.00,17014.41,1935.41,1277370.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','11',242,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',243,'1','1',29616.66,29955.25,338.59,55867.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',244,'2','1',63148.70,67054.68,3905.98,644486.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',245,'3','1',41954.53,45282.20,3327.67,549065.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',246,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',247,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','12',248,'6','1',42937.69,46115.98,3178.29,524417.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',249,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',250,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',251,'9','1',44228.00,47676.66,3448.66,569028.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',252,'10','1',46673.91,46673.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',253,'11','1',27663.58,34194.27,6530.69,1077563.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','12',254,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','12',255,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','12',256,'14','1',31928.83,36785.93,4857.10,801421.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','12',257,'15','1',44908.23,49193.11,4284.88,707005.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','12',258,'16','1',49574.54,49574.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','12',259,'17','1',20955.67,20955.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','12',260,'18','1',61510.41,69825.81,8315.40,1372041.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','12',261,'19','1',45462.87,53085.49,7622.62,1257732.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','12',262,'20','1',17250.73,21832.30,4581.57,755959.05,0.00,0.00,0.00,0.00,0.00),('5','271','5','12',263,'21','2',17014.41,18366.24,1351.83,892207.80,0.00,0.00,0.00,0.00,0.00),('5','271','5','12',264,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',265,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',266,'2','1',67054.68,76571.45,9516.77,1570267.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',267,'3','1',45282.20,54130.07,8847.87,1459898.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',268,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',269,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','13',270,'6','1',46115.98,55793.07,9677.09,1596719.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',271,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',272,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',273,'9','1',47676.66,53093.70,5417.04,893811.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',274,'10','1',46673.91,55545.34,8871.43,1463785.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',275,'11','1',34194.27,44456.62,10262.35,1693287.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','13',276,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','13',277,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','13',278,'14','1',36785.93,46148.11,9362.18,1544759.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','13',279,'15','1',49193.11,53384.49,4191.38,691577.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','13',280,'16','1',49574.54,49575.23,0.69,113.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','13',281,'17','1',20955.67,20957.55,1.88,310.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','13',282,'18','1',69825.81,69836.53,10.72,1768.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','13',283,'19','1',53085.49,56209.20,3123.71,515412.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','13',284,'20','1',21832.30,21833.18,0.88,145.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','13',285,'21','2',18366.24,20258.13,1891.89,1248647.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','13',286,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',287,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',288,'2','1',76571.45,78398.66,1827.21,301489.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',289,'3','1',54130.07,56562.39,2432.32,401332.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',290,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',291,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','14',292,'6','1',55793.07,57646.82,1853.75,305868.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',293,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',294,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',295,'9','1',53093.70,58569.96,5476.26,903582.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',296,'10','1',55545.34,55548.05,2.71,447.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',297,'11','1',44456.62,51824.89,7368.27,1215764.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','14',298,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','14',299,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','14',300,'14','1',46148.11,55196.29,9048.18,1492949.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','14',301,'15','1',53384.49,53384.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','14',302,'16','1',49575.23,56265.69,6690.46,1103925.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','14',303,'17','1',20957.55,20957.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','14',304,'18','1',69836.53,78131.02,8294.49,1368590.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','14',305,'19','1',56209.20,63118.43,6909.23,1140022.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','14',306,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','14',307,'21','2',20258.13,22049.29,1791.16,1182165.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','14',308,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',309,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',310,'2','1',78398.66,87902.11,9503.45,1568069.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',311,'3','1',56562.39,64573.24,8010.85,1321790.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',312,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',313,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','15',314,'6','1',57646.82,65395.03,7748.21,1278454.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',315,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',316,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',317,'9','1',58569.96,61201.01,2631.05,434123.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',318,'10','1',55548.05,58154.63,2606.58,430085.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',319,'11','1',51824.89,61024.58,9199.69,1517948.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','15',320,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','15',321,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','15',322,'14','1',55196.29,59711.91,4515.62,745077.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','15',323,'15','1',53384.49,58377.40,4992.91,823830.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','15',324,'16','1',56265.69,56265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','15',325,'17','1',20957.55,20962.48,4.93,813.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','15',326,'18','1',78131.02,84001.23,5870.21,968584.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','15',327,'19','1',63118.43,67011.28,3892.85,642320.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','15',328,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','15',329,'21','2',22049.29,23534.09,1484.80,979968.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','15',330,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',331,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',332,'2','1',87902.11,90128.36,2226.25,367331.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',333,'3','1',64573.24,72607.59,8034.35,1325667.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',334,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',335,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','16',336,'6','1',65395.03,67188.72,1793.69,295958.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',337,'7','1',20202.57,20202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',338,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',339,'9','1',61201.01,69161.38,7960.37,1313461.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',340,'10','1',58154.63,58166.93,12.30,2029.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',341,'11','1',61024.58,70191.38,9166.80,1512522.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','16',342,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','16',343,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','16',344,'14','1',59711.91,59711.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','16',345,'15','1',58377.40,58377.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','16',346,'16','1',56265.69,56265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','16',347,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','16',348,'18','1',84001.23,84026.58,25.35,4182.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','16',349,'19','1',67011.28,75351.52,8340.24,1376139.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','16',350,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','16',351,'21','2',23534.09,26572.43,3038.34,2005304.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','16',352,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',353,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',354,'2','1',90128.36,97033.08,6904.72,1139278.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',355,'3','1',72607.59,74575.12,1967.53,324642.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',356,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',357,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','17',358,'6','1',67188.72,74508.91,7320.19,1207831.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',359,'7','1',20202.57,20537.01,334.44,55182.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',360,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',361,'9','1',69161.38,69243.58,82.20,13563.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',362,'10','1',58166.93,61654.13,3487.20,575388.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',363,'11','1',70191.38,80071.25,9879.87,1630178.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','17',364,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','17',365,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','17',366,'14','1',59711.91,59711.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','17',367,'15','1',58377.40,58377.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','17',368,'16','1',56265.69,56265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','17',369,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','17',370,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','17',371,'19','1',75351.52,81705.47,6353.95,1048401.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','17',372,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','17',373,'21','2',26572.43,28545.48,1973.05,1302213.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','17',374,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',375,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',376,'2','1',97033.08,102519.07,5485.99,905188.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',377,'3','1',74575.12,82901.80,8326.68,1373902.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',378,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',379,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','18',380,'6','1',74508.91,83599.55,9090.64,1499955.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',381,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',382,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',383,'9','1',69243.58,69243.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',384,'10','1',61654.13,63171.91,1517.78,250433.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',385,'11','1',80071.25,81638.14,1566.89,258536.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','18',386,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','18',387,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','18',388,'14','1',59711.91,67947.42,8235.51,1358859.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','18',389,'15','1',58377.40,66085.10,7707.70,1271770.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','18',390,'16','1',56265.69,63553.12,7287.43,1202425.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','18',391,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','18',392,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','18',393,'19','1',81705.47,81705.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','18',394,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','18',395,'21','2',28545.48,30239.16,1693.68,1117828.80,0.00,0.00,0.00,0.00,0.00),('5','271','5','18',396,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',397,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',398,'2','1',102519.07,111799.01,9279.94,1531190.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',399,'3','1',82901.80,90818.81,7917.01,1306306.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',400,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',401,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','19',402,'6','1',83599.55,91447.56,7848.01,1294921.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',403,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',404,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',405,'9','1',69243.58,69247.25,3.67,605.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',406,'10','1',63171.91,63173.11,1.20,198.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',407,'11','1',81638.14,81640.15,2.01,331.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','19',408,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','19',409,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','19',410,'14','1',67947.42,76574.83,8627.41,1423522.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','19',411,'15','1',66085.10,72885.48,6800.38,1122062.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','19',412,'16','1',63553.12,74052.90,10499.78,1732463.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','19',413,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','19',414,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','19',415,'19','1',81705.47,81705.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','19',416,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','19',417,'21','2',30239.16,32885.96,2646.80,1746888.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','19',418,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',419,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',420,'2','1',111799.01,117275.76,5476.75,903663.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',421,'3','1',90818.81,94205.11,3386.30,558739.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',422,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',423,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','20',424,'6','1',91447.56,98892.94,7445.38,1228487.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',425,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',426,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',427,'9','1',69247.25,69247.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',428,'10','1',63173.11,69973.46,6800.35,1122057.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',429,'11','1',81640.15,90103.00,8462.85,1396370.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','20',430,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','20',431,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','20',432,'14','1',76574.83,79897.49,3322.66,548238.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','20',433,'15','1',72885.48,72885.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','20',434,'16','1',74052.90,77331.65,3278.75,540993.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','20',435,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','20',436,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','20',437,'19','1',81705.47,90905.34,9199.87,1517978.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','20',438,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','20',439,'21','2',32885.96,34458.53,1572.57,1037896.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','20',440,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',441,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',442,'2','1',117275.76,117275.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',443,'3','1',94205.11,94205.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',444,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',445,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','21',446,'6','1',98892.94,103602.26,4709.32,777037.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',447,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',448,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',449,'9','1',69247.25,76110.31,6863.06,1132404.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',450,'10','1',69973.46,78966.30,8992.84,1483818.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',451,'11','1',90103.00,101966.91,11863.91,1957545.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','21',452,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','21',453,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','21',454,'14','1',79897.49,79897.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','21',455,'15','1',72885.48,72885.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','21',456,'16','1',77331.65,77331.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','21',457,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','21',458,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','21',459,'19','1',90905.34,100684.25,9778.91,1613520.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','21',460,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','21',461,'21','2',34458.53,36775.98,2317.45,1529517.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','21',462,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',463,'1','1',29955.25,29955.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',464,'2','1',117275.76,118350.68,1074.92,177361.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',465,'3','1',94205.11,102769.79,8564.68,1413172.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',466,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',467,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','22',468,'6','1',103602.26,111946.55,8344.29,1376807.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',469,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',470,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',471,'9','1',76110.31,76110.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',472,'10','1',78966.30,78966.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',473,'11','1',101966.91,104146.41,2179.50,359617.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','22',474,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','22',475,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','22',476,'14','1',79897.49,87731.66,7834.17,1292638.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','22',477,'15','1',72885.48,72885.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','22',478,'16','1',77331.65,86850.12,9518.47,1570547.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','22',479,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','22',480,'18','1',84026.58,84026.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','22',481,'19','1',100684.25,110077.31,9393.06,1549854.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','22',482,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','22',483,'21','2',36775.98,40407.29,3631.31,2396664.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','22',484,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',485,'1','1',29955.25,29959.60,4.35,717.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',486,'2','1',118350.68,120468.98,2118.30,349519.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',487,'3','1',102769.79,105288.54,2518.75,415593.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',488,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',489,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','23',490,'6','1',111946.55,121294.90,9348.35,1542477.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',491,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',492,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',493,'9','1',76110.31,77021.71,911.40,150381.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',494,'10','1',78966.30,80089.23,1122.93,185283.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',495,'11','1',104146.41,105864.17,1717.76,283430.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','23',496,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','23',497,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','23',498,'14','1',87731.66,90296.65,2564.99,423223.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','23',499,'15','1',72885.48,74708.14,1822.66,300738.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','23',500,'16','1',86850.12,88333.34,1483.22,244731.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','23',501,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','23',502,'18','1',84026.58,89420.71,5394.13,890031.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','23',503,'19','1',110077.31,116630.75,6553.44,1081317.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','23',504,'20','1',21833.18,21833.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','23',505,'21','2',40407.29,44429.39,4022.10,2654586.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','23',506,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',507,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',508,'2','1',120468.98,122334.52,1865.54,307814.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',509,'3','1',105288.54,107091.96,1803.42,297564.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',510,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',511,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','24',512,'6','1',121294.90,122784.52,1489.62,245787.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',513,'7','1',20537.01,20537.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',514,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',515,'9','1',77021.71,82921.42,5899.71,973452.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',516,'10','1',80089.23,85978.99,5889.76,971810.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',517,'11','1',105864.17,111723.28,5859.11,966753.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','24',518,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','24',519,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','24',520,'14','1',90296.65,99805.98,9509.33,1569039.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','24',521,'15','1',74708.14,81461.38,6753.24,1114284.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','24',522,'16','1',88333.34,96720.95,8387.61,1383955.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','24',523,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','24',524,'18','1',89420.71,92243.84,2823.13,465816.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','24',525,'19','1',116630.75,116630.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','24',526,'20','1',21833.18,22150.75,317.57,52399.05,0.00,0.00,0.00,0.00,0.00),('5','271','5','24',527,'21','2',44429.39,47154.53,2725.14,1798592.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','24',528,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',529,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',530,'2','1',122334.52,130143.34,7808.82,1288455.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',531,'3','1',107091.96,114331.64,7239.68,1194547.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',532,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',533,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','25',534,'6','1',122784.52,130276.50,7491.98,1236176.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',535,'7','1',20537.01,20575.43,38.42,6339.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',536,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',537,'9','1',82921.42,87146.30,4224.88,697105.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',538,'10','1',85978.99,85998.99,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',539,'11','1',111723.28,118329.47,6606.19,1090021.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','25',540,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','25',541,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','25',542,'14','1',99805.98,104308.14,4502.16,742856.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','25',543,'15','1',81461.38,86109.24,4647.86,766896.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','25',544,'16','1',96720.95,96745.85,24.90,4108.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','25',545,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','25',546,'18','1',92243.84,104344.11,12100.27,1996544.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','25',547,'19','1',116630.75,117983.43,1352.68,223192.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','25',548,'20','1',22150.75,22160.75,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','25',549,'21','2',47154.53,49982.75,2828.22,1866625.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','25',550,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',551,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',552,'2','1',130143.34,130193.88,50.54,8339.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',553,'3','1',114331.64,120678.80,6347.16,1047281.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',554,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',555,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','26',556,'6','1',130276.50,136186.03,5909.53,975072.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',557,'7','1',20575.43,20575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',558,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',559,'9','1',87146.30,89349.70,2203.40,363561.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',560,'10','1',85998.99,92765.66,6766.67,1116500.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',561,'11','1',118329.47,118329.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','26',562,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','26',563,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','26',564,'14','1',104308.14,111525.68,7217.54,1190894.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','26',565,'15','1',86109.24,90135.20,4025.96,664283.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','26',566,'16','1',96745.85,96844.38,98.53,16257.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','26',567,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','26',568,'18','1',104344.11,113702.34,9358.23,1544107.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','26',569,'19','1',117983.43,118507.90,524.47,86537.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','26',570,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','26',571,'21','2',49982.75,51398.36,1415.61,934302.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','26',572,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',573,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',574,'2','1',130193.88,130193.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',575,'3','1',120678.80,130643.94,9965.14,1644248.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',576,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',577,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','27',578,'6','1',136186.03,144468.84,8282.81,1366663.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',579,'7','1',20575.43,20608.77,33.34,5501.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',580,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',581,'9','1',89349.70,91274.70,1925.00,317625.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',582,'10','1',92765.66,100294.44,7528.78,1242248.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',583,'11','1',118329.47,122054.58,3725.11,614643.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','27',584,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','27',585,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','27',586,'14','1',111525.68,120133.69,8608.01,1420321.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','27',587,'15','1',90135.20,92618.77,2483.57,409789.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','27',588,'16','1',96844.38,96844.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','27',589,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','27',590,'18','1',113702.34,125712.29,12009.95,1981641.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','27',591,'19','1',118507.90,124972.26,6464.36,1066619.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','27',592,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','27',593,'21','2',51398.36,53914.41,2516.05,1660593.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','27',594,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',595,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',596,'2','1',130193.88,130193.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',597,'3','1',130643.94,137361.90,6717.96,1108463.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',598,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',599,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','28',600,'6','1',144468.84,149997.54,5528.70,912235.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',601,'7','1',20608.77,20608.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',602,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',603,'9','1',91274.70,92313.77,1039.07,171446.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',604,'10','1',100294.44,100294.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',605,'11','1',122054.58,122218.90,164.32,27112.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','28',606,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','28',607,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','28',608,'14','1',120133.69,127598.39,7464.70,1231675.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','28',609,'15','1',92618.77,93170.11,551.34,90971.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','28',610,'16','1',96844.38,97420.08,575.70,94990.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','28',611,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','28',612,'18','1',125712.29,131346.27,5633.98,929606.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','28',613,'19','1',124972.26,127229.40,2257.14,372428.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','28',614,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','28',615,'21','2',53914.41,55588.20,1673.79,1104701.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','28',616,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',617,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',618,'2','1',130193.88,130193.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',619,'3','1',137361.90,141228.91,3867.01,638056.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',620,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',621,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','29',622,'6','1',149997.54,153883.43,3885.89,641171.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',623,'7','1',20608.77,20608.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',624,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',625,'9','1',92313.77,100774.80,8461.03,1396069.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',626,'10','1',100294.44,109950.10,9655.66,1593183.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',627,'11','1',122218.90,130858.57,8639.67,1425545.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','29',628,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','29',629,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','29',630,'14','1',127598.39,136743.69,9145.30,1508974.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','29',631,'15','1',93170.11,93170.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','29',632,'16','1',97420.08,97420.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','29',633,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','29',634,'18','1',131346.27,136101.74,4755.47,784652.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','29',635,'19','1',127229.40,130303.28,3073.88,507190.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','29',636,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','29',637,'21','2',55588.20,58700.82,3112.62,2054329.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','29',638,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',639,'1','1',29959.60,29959.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',640,'2','1',130193.88,130193.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',641,'3','1',141228.91,142935.64,1706.73,281610.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',642,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',643,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','30',644,'6','1',153883.43,155124.70,1241.27,204809.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',645,'7','1',20608.77,20883.95,275.18,45404.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',646,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',647,'9','1',100774.80,105142.09,4367.29,720602.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',648,'10','1',109950.10,116406.44,6456.34,1065296.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',649,'11','1',130858.57,138255.80,7397.23,1220542.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','30',650,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','30',651,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','30',652,'14','1',136743.69,136743.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','30',653,'15','1',93170.11,93170.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','30',654,'16','1',97420.08,97420.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','30',655,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','30',656,'18','1',136101.74,145955.01,9853.27,1625789.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','30',657,'19','1',130303.28,131624.69,1321.41,218032.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','30',658,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','30',659,'21','2',58700.82,61266.42,2565.60,1693296.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','30',660,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',661,'1','1',29959.60,29963.53,3.93,648.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',662,'2','1',130193.88,130393.93,200.05,33008.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',663,'3','1',142935.64,146178.44,3242.80,535062.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',664,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',665,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','31',666,'6','1',155124.70,164165.70,9041.00,1491765.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',667,'7','1',20883.95,20883.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',668,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',669,'9','1',105142.09,105142.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',670,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',671,'11','1',138255.80,138255.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','31',672,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','31',673,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','31',674,'14','1',136743.69,143788.38,7044.69,1162373.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','31',675,'15','1',93170.11,94070.38,900.27,148544.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','31',676,'16','1',97420.08,97689.03,268.95,44376.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','31',677,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','31',678,'18','1',145955.01,157849.66,11894.65,1962617.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','31',679,'19','1',131624.69,131624.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','31',680,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','31',681,'21','2',61266.42,64594.61,3328.19,2196605.40,0.00,0.00,0.00,0.00,0.00),('5','271','5','31',682,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',683,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',684,'2','1',130393.93,130393.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',685,'3','1',146178.44,156342.36,10163.92,1677046.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',686,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',687,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','32',688,'6','1',164165.70,168763.66,4597.96,758663.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',689,'7','1',20883.95,20883.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',690,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',691,'9','1',105142.09,105142.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',692,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',693,'11','1',138255.80,138255.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','32',694,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','32',695,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','32',696,'14','1',143788.38,155409.58,11621.20,1917498.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','32',697,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','32',698,'16','1',97689.03,97689.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','32',699,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','32',700,'18','1',157849.66,160840.35,2990.69,493463.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','32',701,'19','1',131624.69,131624.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','32',702,'20','1',22160.75,22160.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','32',703,'21','2',64594.61,67610.76,3016.15,1990659.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','32',704,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',705,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',706,'2','1',130393.93,130393.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',707,'3','1',156342.36,156342.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',708,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',709,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','33',710,'6','1',168763.66,168763.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',711,'7','1',20883.95,23788.20,2904.25,479201.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',712,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',713,'9','1',105142.09,107982.65,2840.56,468692.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',714,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',715,'11','1',138255.80,141549.28,3293.48,543424.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','33',716,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','33',717,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','33',718,'14','1',155409.58,165155.66,9746.08,1608103.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','33',719,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','33',720,'16','1',97689.03,97768.55,79.52,13120.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','33',721,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','33',722,'18','1',160840.35,172634.85,11794.50,1946092.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','33',723,'19','1',131624.69,135561.45,3936.76,649565.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','33',724,'20','1',22160.75,22181.67,20.92,3451.80,0.00,0.00,0.00,0.00,0.00),('5','271','5','33',725,'21','2',67610.76,70749.67,3138.91,2071680.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','33',726,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',727,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',728,'2','1',130393.93,139752.68,9358.75,1544193.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',729,'3','1',156342.36,164875.87,8533.51,1408029.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',730,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',731,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','34',732,'6','1',168763.66,178199.59,9435.93,1556928.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',733,'7','1',23788.20,32686.49,8898.29,1468217.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',734,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',735,'9','1',107982.65,119879.97,11897.32,1963057.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',736,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',737,'11','1',141549.28,151870.90,10321.62,1703067.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','34',738,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','34',739,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','34',740,'14','1',165155.66,165155.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','34',741,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','34',742,'16','1',97768.55,97768.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','34',743,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','34',744,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','34',745,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','34',746,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','34',747,'21','2',70749.67,73175.93,2426.26,1601331.60,0.00,0.00,0.00,0.00,0.00),('5','271','5','34',748,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',749,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',750,'2','1',139752.68,145910.78,6158.10,1016086.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',751,'3','1',164875.87,166719.15,1843.28,304141.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',752,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',753,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','35',754,'6','1',178199.59,188076.88,9877.29,1629752.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',755,'7','1',32686.49,34514.11,1827.62,301557.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',756,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',757,'9','1',119879.97,125627.72,5747.75,948378.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',758,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',759,'11','1',151870.90,154308.09,2437.19,402136.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','35',760,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','35',761,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','35',762,'14','1',165155.66,165155.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','35',763,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','35',764,'16','1',97768.55,97768.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','35',765,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','35',766,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','35',767,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','35',768,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','35',769,'21','2',73175.93,79061.78,5885.85,3884661.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','35',770,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',771,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',772,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',773,'3','1',166719.15,166719.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',774,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',775,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','36',776,'6','1',188076.88,188076.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',777,'7','1',34514.11,46615.86,12101.75,1996788.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',778,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',779,'9','1',125627.72,133592.52,7964.80,1314192.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',780,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',781,'11','1',154308.09,166255.02,11946.93,1971243.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','36',782,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','36',783,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','36',784,'14','1',165155.66,165155.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','36',785,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','36',786,'16','1',97768.55,97768.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','36',787,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','36',788,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','36',789,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','36',790,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','36',791,'21','2',79061.78,85993.80,6932.02,4575133.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','36',792,'22','2',91.22,91.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',793,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',794,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',795,'3','1',166719.15,168888.07,2168.92,357871.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',796,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',797,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','37',798,'6','1',188076.88,190019.49,1942.61,320530.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',799,'7','1',46615.86,46615.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',800,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',801,'9','1',133592.52,134681.78,1089.26,179727.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',802,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',803,'11','1',166255.02,172526.48,6271.46,1034790.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','37',804,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','37',805,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','37',806,'14','1',165155.66,172421.52,7265.86,1198866.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','37',807,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','37',808,'16','1',97768.55,99445.80,1677.25,276746.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','37',809,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','37',810,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','37',811,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','37',812,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','37',813,'21','2',85993.80,97301.62,11307.82,7463161.20,0.00,0.00,0.00,0.00,0.00),('5','271','5','37',814,'22','2',91.22,3844.67,3753.45,2477277.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',815,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',816,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',817,'3','1',168888.07,168888.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',818,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',819,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','38',820,'6','1',190019.49,190019.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',821,'7','1',46615.86,46615.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',822,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',823,'9','1',134681.78,134681.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',824,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',825,'11','1',172526.48,172526.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','38',826,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','38',827,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','38',828,'14','1',172421.52,172421.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','38',829,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','38',830,'16','1',99445.80,99445.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','38',831,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','38',832,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','38',833,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','38',834,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','38',835,'21','2',97301.62,97301.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','38',836,'22','2',3844.67,3844.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',837,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',838,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',839,'3','1',168888.07,168888.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',840,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',841,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','39',842,'6','1',190019.49,190019.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',843,'7','1',46615.86,46615.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',844,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',845,'9','1',134681.78,141593.43,6911.65,1140422.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',846,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',847,'11','1',172526.48,183877.37,11350.89,1872896.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','39',848,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','39',849,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','39',850,'14','1',172421.52,180349.09,7927.57,1308049.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','39',851,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','39',852,'16','1',99445.80,99445.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','39',853,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','39',854,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','39',855,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','39',856,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','39',857,'21','2',97301.62,107789.31,10487.69,7026752.30,0.00,0.00,0.00,0.00,0.00),('5','271','5','39',858,'22','2',3844.67,14830.81,10986.14,7360713.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',859,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',860,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',861,'3','1',168888.07,168888.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',862,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',863,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','40',864,'6','1',190019.49,190019.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',865,'7','1',46615.86,46615.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',866,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',867,'9','1',141593.43,141593.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',868,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',869,'11','1',183877.37,183877.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','40',870,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','40',871,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','40',872,'14','1',180349.09,180349.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','40',873,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','40',874,'16','1',99445.80,99445.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','40',875,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','40',876,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','40',877,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','40',878,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','40',879,'21','2',107789.31,107789.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','40',880,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',881,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',882,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',883,'3','1',168888.07,172116.37,3228.30,532669.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',884,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',885,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','41',886,'6','1',190019.49,193204.43,3184.94,525515.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',887,'7','1',46615.86,46615.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',888,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',889,'9','1',141593.43,148039.72,6446.29,1063637.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',890,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',891,'11','1',183877.37,189271.16,5393.79,889975.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','41',892,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','41',893,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','41',894,'14','1',180349.09,190757.35,10408.26,1717362.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','41',895,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','41',896,'16','1',99445.80,99943.57,497.77,82132.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','41',897,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','41',898,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','41',899,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','41',900,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','41',901,'21','2',107789.31,111230.58,3441.27,2408889.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','41',902,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',903,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',904,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',905,'3','1',172116.37,172116.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',906,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',907,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','42',908,'6','1',193204.43,193204.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',909,'7','1',46615.86,51409.92,4794.06,791019.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',910,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',911,'9','1',148039.72,158509.86,10470.14,1727573.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',912,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',913,'11','1',189271.16,200444.32,11173.16,1843571.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','42',914,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','42',915,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','42',916,'14','1',190757.35,198722.52,7965.17,1314253.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','42',917,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','42',918,'16','1',99943.57,99943.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','42',919,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','42',920,'18','1',172634.85,172634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','42',921,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','42',922,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','42',923,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','42',924,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',925,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',926,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',927,'3','1',172116.37,172116.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',928,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',929,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','43',930,'6','1',193204.43,196886.28,3681.85,607505.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',931,'7','1',51409.92,51409.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',932,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',933,'9','1',158509.86,168435.89,9926.03,1637794.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',934,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',935,'11','1',200444.32,209381.34,8937.02,1474608.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','43',936,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','43',937,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','43',938,'14','1',198722.52,205883.67,7161.15,1181589.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','43',939,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','43',940,'16','1',99943.57,99943.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','43',941,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','43',942,'18','1',172634.85,174767.30,2132.45,351854.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','43',943,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','43',944,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','43',945,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','43',946,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',947,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',948,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',949,'3','1',172116.37,177252.84,5136.47,847517.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',950,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',951,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','44',952,'6','1',196886.28,206174.22,9287.94,1532510.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',953,'7','1',51409.92,51409.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',954,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',955,'9','1',168435.89,175092.46,6656.57,1098334.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',956,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',957,'11','1',209381.34,219832.87,10451.53,1724502.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','44',958,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','44',959,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','44',960,'14','1',205883.67,208407.99,2524.32,416512.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','44',961,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','44',962,'16','1',99943.57,99943.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','44',963,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','44',964,'18','1',174767.30,186434.66,11667.36,1925114.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','44',965,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','44',966,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','44',967,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','44',968,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',969,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',970,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',971,'3','1',177252.84,184643.82,7390.98,1219511.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',972,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',973,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','45',974,'6','1',206174.22,213956.53,7782.31,1284081.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',975,'7','1',51409.92,51409.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',976,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',977,'9','1',175092.46,175786.12,693.66,114453.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',978,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',979,'11','1',219832.87,230214.17,10381.30,1712914.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','45',980,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','45',981,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','45',982,'14','1',208407.99,208407.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','45',983,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','45',984,'16','1',99943.57,99943.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','45',985,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','45',986,'18','1',186434.66,197310.46,10875.80,1794507.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','45',987,'19','1',135561.45,135561.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','45',988,'20','1',22181.67,22181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','45',989,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','45',990,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',991,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',992,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',993,'3','1',184643.82,184643.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',994,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',995,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','46',996,'6','1',213956.53,217299.34,3342.81,551563.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',997,'7','1',51409.92,52561.37,1151.45,189989.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',998,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',999,'9','1',175786.12,177409.44,1623.32,267847.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',1000,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',1001,'11','1',230214.17,235117.98,4903.81,809127.99,0.00,0.00,0.00,0.00,0.00),('5','271','2','46',1002,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','46',1003,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','46',1004,'14','1',208407.99,219087.10,10679.11,1762053.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','46',1005,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','46',1006,'16','1',99943.57,99943.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','46',1007,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','46',1008,'18','1',197310.46,207544.67,10234.21,1688644.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','46',1009,'19','1',135561.45,135561.62,0.17,28.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','46',1010,'20','1',22181.67,22182.96,1.29,212.85,0.00,0.00,0.00,0.00,0.00),('5','271','5','46',1011,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','46',1012,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1013,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1014,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1015,'3','1',184643.82,185979.00,1335.18,220304.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1016,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1017,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','47',1018,'6','1',217299.34,218609.66,1310.32,216202.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1019,'7','1',52561.37,56055.78,3494.41,576577.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1020,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1021,'9','1',177409.44,177692.00,282.56,46622.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1022,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1023,'11','1',235117.98,242948.05,7830.07,1291961.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','47',1024,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','47',1025,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','47',1026,'14','1',219087.10,230055.52,10968.42,1809789.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','47',1027,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','47',1028,'16','1',99943.57,100144.51,200.94,33155.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','47',1029,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','47',1030,'18','1',207544.67,212563.02,5018.35,828027.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','47',1031,'19','1',135561.62,135561.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','47',1032,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','47',1033,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','47',1034,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1035,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1036,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1037,'3','1',185979.00,187960.51,1981.51,326949.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1038,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1039,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','48',1040,'6','1',218609.66,228836.96,10227.30,1687504.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1041,'7','1',56055.78,56055.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1042,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1043,'9','1',177692.00,187242.19,9550.19,1575781.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1044,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1045,'11','1',242948.05,255004.04,12055.99,1989238.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','48',1046,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','48',1047,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','48',1048,'14','1',230055.52,240147.45,10091.93,1665168.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','48',1049,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','48',1050,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','48',1051,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','48',1052,'18','1',212563.02,212764.55,201.53,33252.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','48',1053,'19','1',135561.62,135561.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','48',1054,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','48',1055,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','48',1056,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1057,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1058,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1059,'3','1',187960.51,190292.82,2332.31,384831.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1060,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1061,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','49',1062,'6','1',228836.96,240122.51,11285.55,1862115.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1063,'7','1',56055.78,56055.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1064,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1065,'9','1',187242.19,193047.75,5805.56,957917.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1066,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1067,'11','1',255004.04,263846.81,8842.77,1459057.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','49',1068,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','49',1069,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','49',1070,'14','1',240147.45,248249.02,8101.57,1336759.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','49',1071,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','49',1072,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','49',1073,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','49',1074,'18','1',212764.55,214801.09,2036.54,336029.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','49',1075,'19','1',135561.62,135561.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','49',1076,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','49',1077,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','49',1078,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1079,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1080,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1081,'3','1',190292.82,190797.35,504.53,83247.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1082,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1083,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','50',1084,'6','1',240122.51,250217.06,10094.55,1665600.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1085,'7','1',56055.78,56055.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1086,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1087,'9','1',193047.75,193047.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1088,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1089,'11','1',263846.81,263846.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','50',1090,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','50',1091,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','50',1092,'14','1',248249.02,258998.17,10749.15,1773609.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','50',1093,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','50',1094,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','50',1095,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','50',1096,'18','1',214801.09,228318.94,13517.85,2230445.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','50',1097,'19','1',135561.62,135561.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','50',1098,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','50',1099,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','50',1100,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1101,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1102,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1103,'3','1',190797.35,192159.07,1361.72,224683.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1104,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1105,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','51',1106,'6','1',250217.06,250518.31,301.25,49706.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1107,'7','1',56055.78,56347.20,291.42,48084.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1108,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1109,'9','1',193047.75,193047.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1110,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1111,'11','1',263846.81,267920.28,4073.47,672122.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','51',1112,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','51',1113,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','51',1114,'14','1',258998.17,269767.68,10769.51,1776969.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','51',1115,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','51',1116,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','51',1117,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','51',1118,'18','1',228318.94,241631.78,13312.84,2196618.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','51',1119,'19','1',135561.62,144277.14,8715.52,1438060.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','51',1120,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','51',1121,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','51',1122,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1123,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1124,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1125,'3','1',192159.07,192159.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1126,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1127,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','52',1128,'6','1',250518.31,258181.59,7663.28,1264441.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1129,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1130,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1131,'9','1',193047.75,199633.59,6585.84,1086663.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1132,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1133,'11','1',267920.28,278574.88,10654.60,1758009.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','52',1134,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','52',1135,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','52',1136,'14','1',269767.68,279423.50,9655.82,1593210.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','52',1137,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','52',1138,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','52',1139,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','52',1140,'18','1',241631.78,241631.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','52',1141,'19','1',144277.14,146414.86,2137.72,352723.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','52',1142,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','52',1143,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','52',1144,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1145,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1146,'2','1',145910.78,145910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1147,'3','1',192159.07,193797.78,1638.71,270387.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1148,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1149,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','53',1150,'6','1',258181.59,266431.04,8249.45,1361159.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1151,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1152,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1153,'9','1',199633.59,199633.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1154,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1155,'11','1',278574.88,291308.28,12733.40,2101011.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','53',1156,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','53',1157,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','53',1158,'14','1',279423.50,284440.94,5017.44,827877.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','53',1159,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','53',1160,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','53',1161,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','53',1162,'18','1',241631.78,243300.03,1668.25,275261.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','53',1163,'19','1',146414.86,146414.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','53',1164,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','53',1165,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','53',1166,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1167,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1168,'2','1',145910.78,149601.20,3690.42,608919.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1169,'3','1',193797.78,202985.73,9187.95,1516011.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1170,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1171,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','54',1172,'6','1',266431.04,271320.30,4889.26,806727.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1173,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1174,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1175,'9','1',199633.59,199633.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1176,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1177,'11','1',291308.28,293559.30,2251.02,371418.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','54',1178,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','54',1179,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','54',1180,'14','1',284440.94,289072.15,4631.21,764149.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','54',1181,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','54',1182,'16','1',100144.51,100144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','54',1183,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','54',1184,'18','1',243300.03,255486.26,12186.23,2010727.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','54',1185,'19','1',146414.86,155890.72,9475.86,1563516.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','54',1186,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','54',1187,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','54',1188,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1189,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1190,'2','1',149601.20,149601.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1191,'3','1',202985.73,202985.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1192,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1193,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','55',1194,'6','1',271320.30,276520.89,5200.59,858097.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1195,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1196,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1197,'9','1',199633.59,199633.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1198,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1199,'11','1',293559.30,304750.73,11191.43,1846585.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','55',1200,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','55',1201,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','55',1202,'14','1',289072.15,298207.88,9135.73,1507395.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','55',1203,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','55',1204,'16','1',100144.51,100307.22,162.71,26847.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','55',1205,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','55',1206,'18','1',255486.26,262460.74,6974.48,1150789.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','55',1207,'19','1',155890.72,165677.63,9786.91,1614840.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','55',1208,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','55',1209,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','55',1210,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1211,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1212,'2','1',149601.20,153469.18,3867.98,638216.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1213,'3','1',202985.73,211857.65,8871.92,1463866.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1214,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1215,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','56',1216,'6','1',276520.89,276520.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1217,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1218,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1219,'9','1',199633.59,199633.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1220,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1221,'11','1',304750.73,308715.65,3964.92,654211.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','56',1222,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','56',1223,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','56',1224,'14','1',298207.88,307521.31,9313.43,1536715.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','56',1225,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','56',1226,'16','1',100307.22,107138.33,6831.11,1127133.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','56',1227,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','56',1228,'18','1',262460.74,262460.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','56',1229,'19','1',165677.63,165677.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','56',1230,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','56',1231,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','56',1232,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1233,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1234,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1235,'3','1',211857.65,214110.61,2252.96,371738.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1236,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1237,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','57',1238,'6','1',276520.89,282994.23,6473.34,1068101.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1239,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1240,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1241,'9','1',199633.59,200102.67,469.08,77398.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1242,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1243,'11','1',308715.65,309128.59,412.94,68135.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','57',1244,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','57',1245,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','57',1246,'14','1',307521.31,317100.02,9578.71,1580487.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','57',1247,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','57',1248,'16','1',107138.33,116364.24,9225.91,1522275.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','57',1249,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','57',1250,'18','1',262460.74,272095.91,9635.17,1589803.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','57',1251,'19','1',165677.63,174165.49,8487.86,1400496.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','57',1252,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','57',1253,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','57',1254,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1255,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1256,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1257,'3','1',214110.61,222554.89,8444.28,1393306.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1258,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1259,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','58',1260,'6','1',282994.23,290730.79,7736.56,1276532.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1261,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1262,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1263,'9','1',200102.67,208825.89,8723.22,1439331.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1264,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1265,'11','1',309128.59,309128.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','58',1266,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','58',1267,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','58',1268,'14','1',317100.02,317100.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','58',1269,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','58',1270,'16','1',116364.24,116364.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','58',1271,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','58',1272,'18','1',272095.91,275721.98,3626.07,598301.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','58',1273,'19','1',174165.49,182588.08,8422.59,1389727.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','58',1274,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','58',1275,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','58',1276,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1277,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1278,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1279,'3','1',222554.89,232568.18,10013.29,1652192.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1280,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1281,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','59',1282,'6','1',290730.79,300066.12,9335.33,1540329.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1283,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1284,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1285,'9','1',208825.89,221586.86,12760.97,2105560.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1286,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1287,'11','1',309128.59,309128.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','59',1288,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','59',1289,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','59',1290,'14','1',317100.02,317750.99,650.97,107410.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','59',1291,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','59',1292,'16','1',116364.24,116733.58,369.34,60941.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','59',1293,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','59',1294,'18','1',275721.98,276019.20,297.22,49041.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','59',1295,'19','1',182588.08,191754.17,9166.09,1512404.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','59',1296,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','59',1297,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','59',1298,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1299,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1300,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1301,'3','1',232568.18,232568.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1302,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1303,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','60',1304,'6','1',300066.12,310596.56,10530.44,1737522.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1305,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1306,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1307,'9','1',221586.86,222381.07,794.21,131044.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1308,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1309,'11','1',309128.59,309128.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','60',1310,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','60',1311,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','60',1312,'14','1',317750.99,325749.54,7998.55,1319760.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','60',1313,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','60',1314,'16','1',116733.58,128000.69,11267.11,1859073.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','60',1315,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','60',1316,'18','1',276019.20,276019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','60',1317,'19','1',191754.17,191754.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','60',1318,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','60',1319,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','60',1320,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1321,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1322,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1323,'3','1',232568.18,232568.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1324,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1325,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','61',1326,'6','1',310596.56,310596.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1327,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1328,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1329,'9','1',222381.07,222381.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1330,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1331,'11','1',309128.59,315595.09,6466.50,1066972.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','61',1332,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','61',1333,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','61',1334,'14','1',325749.54,334371.73,8622.19,1422661.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','61',1335,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','61',1336,'16','1',128000.69,130399.81,2399.12,395854.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','61',1337,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','61',1338,'18','1',276019.20,276019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','61',1339,'19','1',191754.17,191754.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','61',1340,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','61',1341,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','61',1342,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1343,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1344,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1345,'3','1',232568.18,236707.60,4139.42,683004.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1346,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1347,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','62',1348,'6','1',310596.56,315781.31,5184.75,855483.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1349,'7','1',56347.20,56347.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1350,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1351,'9','1',222381.07,222381.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1352,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1353,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','62',1354,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','62',1355,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','62',1356,'14','1',334371.73,335020.55,648.82,107055.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','62',1357,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','62',1358,'16','1',130399.81,132939.15,2539.34,418991.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','62',1359,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','62',1360,'18','1',276019.20,276019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','62',1361,'19','1',191754.17,191754.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','62',1362,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','62',1363,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','62',1364,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1365,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1366,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1367,'3','1',236707.60,236707.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1368,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1369,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','63',1370,'6','1',315781.31,315781.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1371,'7','1',56347.20,61645.69,5298.49,874250.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1372,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1373,'9','1',222381.07,233416.31,11035.24,1820814.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1374,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1375,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','63',1376,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','63',1377,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','63',1378,'14','1',335020.55,340176.94,5156.39,850804.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','63',1379,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','63',1380,'16','1',132939.15,135186.15,2247.00,370755.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','63',1381,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','63',1382,'18','1',276019.20,276019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','63',1383,'19','1',191754.17,191754.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','63',1384,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','63',1385,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','63',1386,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1387,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1388,'2','1',153469.18,153469.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1389,'3','1',236707.60,237642.92,935.32,154327.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1390,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1391,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','64',1392,'6','1',315781.31,322867.77,7086.46,1169265.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1393,'7','1',61645.69,61645.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1394,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1395,'9','1',233416.31,246147.73,12731.42,2100684.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1396,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1397,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','64',1398,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','64',1399,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','64',1400,'14','1',340176.94,346166.75,5989.81,988318.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','64',1401,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','64',1402,'16','1',135186.15,136889.29,1703.14,281018.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','64',1403,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','64',1404,'18','1',276019.20,276019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','64',1405,'19','1',191754.17,191754.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','64',1406,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','64',1407,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','64',1408,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1409,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1410,'2','1',153469.18,159518.52,6049.34,998141.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1411,'3','1',237642.92,245258.52,7615.60,1256574.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1412,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1413,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','65',1414,'6','1',322867.77,329420.58,6552.81,1081213.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1415,'7','1',61645.69,61904.42,258.73,42690.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1416,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1417,'9','1',246147.73,246714.76,567.03,93559.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1418,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1419,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','65',1420,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','65',1421,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','65',1422,'14','1',346166.75,346166.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','65',1423,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','65',1424,'16','1',136889.29,136889.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','65',1425,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','65',1426,'18','1',276019.20,286269.86,10250.66,1691358.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','65',1427,'19','1',191754.17,192750.22,996.05,164348.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','65',1428,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','65',1429,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','65',1430,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1431,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1432,'2','1',159518.52,163026.64,3508.12,578839.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1433,'3','1',245258.52,245258.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1434,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1435,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','66',1436,'6','1',329420.58,330691.45,1270.87,209693.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1437,'7','1',61904.42,68915.99,7011.57,1156909.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1438,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1439,'9','1',246714.76,256036.48,9321.72,1538083.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1440,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1441,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','66',1442,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','66',1443,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','66',1444,'14','1',346166.75,346189.23,22.48,3709.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','66',1445,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','66',1446,'16','1',136889.29,136889.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','66',1447,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','66',1448,'18','1',286269.86,290509.52,4239.66,699543.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','66',1449,'19','1',192750.22,192750.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','66',1450,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','66',1451,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','66',1452,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1453,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1454,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1455,'3','1',245258.52,251994.97,6736.45,1111514.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1456,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1457,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','67',1458,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1459,'7','1',68915.99,74642.51,5726.52,944875.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1460,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1461,'9','1',256036.48,264783.23,8746.75,1443213.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1462,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1463,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','67',1464,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','67',1465,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','67',1466,'14','1',346189.23,348360.32,2171.09,358229.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','67',1467,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','67',1468,'16','1',136889.29,138054.83,1165.54,192314.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','67',1469,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','67',1470,'18','1',290509.52,294207.61,3698.09,610184.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','67',1471,'19','1',192750.22,192750.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','67',1472,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','67',1473,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','67',1474,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1475,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1476,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1477,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1478,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1479,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','68',1480,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1481,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1482,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1483,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1484,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1485,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','68',1486,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','68',1487,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','68',1488,'14','1',348360.32,355455.18,7094.86,1170651.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','68',1489,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','68',1490,'16','1',138054.83,149864.03,11809.20,1948518.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','68',1491,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','68',1492,'18','1',294207.61,296946.31,2738.70,451885.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','68',1493,'19','1',192750.22,192750.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','68',1494,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','68',1495,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','68',1496,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1497,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1498,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1499,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1500,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1501,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','69',1502,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1503,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1504,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1505,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1506,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1507,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','69',1508,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','69',1509,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','69',1510,'14','1',355455.18,361611.28,6156.10,1015756.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','69',1511,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','69',1512,'16','1',149864.03,157466.91,7602.88,1254475.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','69',1513,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','69',1514,'18','1',296946.31,308771.61,11825.30,1951174.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','69',1515,'19','1',192750.22,193611.13,860.91,142050.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','69',1516,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','69',1517,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','69',1518,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1519,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1520,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1521,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1522,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1523,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','70',1524,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1525,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1526,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1527,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1528,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1529,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','70',1530,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','70',1531,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','70',1532,'14','1',361611.28,367100.89,5489.61,905785.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','70',1533,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','70',1534,'16','1',157466.91,160973.32,3506.41,578557.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','70',1535,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','70',1536,'18','1',308771.61,308771.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','70',1537,'19','1',193611.13,199453.11,5841.98,963926.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','70',1538,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','70',1539,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','70',1540,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1541,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1542,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1543,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1544,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1545,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','71',1546,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1547,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1548,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1549,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1550,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1551,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','71',1552,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','71',1553,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','71',1554,'14','1',367100.89,367100.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','71',1555,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','71',1556,'16','1',160973.32,160973.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','71',1557,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','71',1558,'18','1',308771.61,308771.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','71',1559,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','71',1560,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','71',1561,'21','2',111230.58,111230.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','71',1562,'22','2',14830.81,14830.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1563,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1564,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1565,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1566,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1567,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','72',1568,'6','1',330691.45,330691.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1569,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1570,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1571,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1572,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1573,'11','1',315595.09,315595.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','72',1574,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','72',1575,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','72',1576,'14','1',367100.89,367100.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','72',1577,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','72',1578,'16','1',160973.32,160973.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','72',1579,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','72',1580,'18','1',308771.61,308771.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','72',1581,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','72',1582,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','72',1583,'21','2',111230.58,111393.08,162.50,130000.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','72',1584,'22','2',14830.81,15518.70,687.89,550312.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1585,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1586,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1587,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1588,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1589,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','73',1590,'6','1',330691.45,330950.92,259.47,42812.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1591,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1592,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1593,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1594,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1595,'11','1',315595.09,316254.10,659.01,108736.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','73',1596,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','73',1597,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','73',1598,'14','1',367100.89,374295.97,7195.08,1187188.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','73',1599,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','73',1600,'16','1',160973.32,174243.04,13269.72,2189503.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','73',1601,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','73',1602,'18','1',308771.61,309056.47,284.86,47001.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','73',1603,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','73',1604,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','73',1605,'21','2',111393.08,111746.58,353.50,282800.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','73',1606,'22','2',15518.70,15598.32,79.62,63696.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1607,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1608,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1609,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1610,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1611,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','74',1612,'6','1',330950.92,330950.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1613,'7','1',74642.51,74642.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1614,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1615,'9','1',264783.23,264783.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1616,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1617,'11','1',316254.10,319378.35,3124.25,515501.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','74',1618,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','74',1619,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','74',1620,'14','1',374295.97,381969.33,7673.36,1266104.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','74',1621,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','74',1622,'16','1',174243.04,188473.55,14230.51,2348034.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','74',1623,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','74',1624,'18','1',309056.47,309056.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','74',1625,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','74',1626,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','74',1627,'21','2',111746.58,111746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','74',1628,'22','2',15598.32,16347.05,748.73,598984.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1629,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1630,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1631,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1632,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1633,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','75',1634,'6','1',330950.92,340685.20,9734.28,1606156.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1635,'7','1',74642.51,80698.90,6056.39,999304.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1636,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1637,'9','1',264783.23,278835.63,14052.40,2318646.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1638,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1639,'11','1',319378.35,323335.90,3957.55,652995.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','75',1640,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','75',1641,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','75',1642,'14','1',381969.33,381969.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','75',1643,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','75',1644,'16','1',188473.55,188473.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','75',1645,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','75',1646,'18','1',309056.47,309056.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','75',1647,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','75',1648,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','75',1649,'21','2',111746.58,111746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','75',1650,'22','2',16347.05,17020.08,673.03,538424.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1651,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1652,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1653,'3','1',251994.97,251994.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1654,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1655,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','76',1656,'6','1',340685.20,348449.33,7764.13,1281081.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1657,'7','1',80698.90,83931.70,3232.80,533412.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1658,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1659,'9','1',278835.63,286948.24,8112.61,1338580.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1660,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1661,'11','1',323335.90,324114.02,778.12,128389.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','76',1662,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','76',1663,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','76',1664,'14','1',381969.33,382573.55,604.22,99696.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','76',1665,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','76',1666,'16','1',188473.55,190682.49,2208.94,364475.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','76',1667,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','76',1668,'18','1',309056.47,309751.91,695.44,114747.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','76',1669,'19','1',199453.11,199453.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','76',1670,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','76',1671,'21','2',111746.58,111746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','76',1672,'22','2',17020.08,20389.10,3369.02,2695216.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1673,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1674,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1675,'3','1',251994.97,255156.93,3161.96,521723.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1676,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1677,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','77',1678,'6','1',348449.33,348898.09,448.76,74045.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1679,'7','1',83931.70,83931.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1680,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1681,'9','1',286948.24,286948.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1682,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1683,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','77',1684,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','77',1685,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','77',1686,'14','1',382573.55,382573.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','77',1687,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','77',1688,'16','1',190682.49,190682.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','77',1689,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','77',1690,'18','1',309751.91,309751.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','77',1691,'19','1',199453.11,205198.68,5745.57,948019.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','77',1692,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','77',1693,'21','2',111746.58,111746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','77',1694,'22','2',20389.10,21273.99,884.89,707912.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1695,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1696,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1697,'3','1',255156.93,263025.53,7868.60,1298319.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1698,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1699,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','78',1700,'6','1',348898.09,354612.80,5714.71,942927.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1701,'7','1',83931.70,83931.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1702,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1703,'9','1',286948.24,286948.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1704,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1705,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','78',1706,'12','1',10423.67,10423.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','78',1707,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','78',1708,'14','1',382573.55,382573.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','78',1709,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','78',1710,'16','1',190682.49,190682.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','78',1711,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','78',1712,'18','1',309751.91,320183.95,10432.04,1721286.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','78',1713,'19','1',205198.68,207121.74,1923.06,317304.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','78',1714,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','78',1715,'21','2',111746.58,114238.26,2491.68,1993344.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','78',1716,'22','2',21273.99,21863.99,590.00,472000.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1717,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1718,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1719,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1720,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1721,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','79',1722,'6','1',354612.80,359654.48,5041.68,831877.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1723,'7','1',83931.70,91264.96,7333.26,1209987.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1724,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1725,'9','1',286948.24,296145.08,9196.84,1517478.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1726,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1727,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','79',1728,'12','1',10423.67,21149.88,10726.21,1769824.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','79',1729,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','79',1730,'14','1',382573.55,383143.24,569.69,93998.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','79',1731,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','79',1732,'16','1',190682.49,190682.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','79',1733,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','79',1734,'18','1',320183.95,320183.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','79',1735,'19','1',207121.74,207121.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','79',1736,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','79',1737,'21','2',114238.26,115509.76,1271.50,1017200.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','79',1738,'22','2',21863.99,23258.48,1394.49,1115592.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1739,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1740,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1741,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1742,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1743,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','80',1744,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1745,'7','1',91264.96,99153.18,7888.22,1301556.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1746,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1747,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1748,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1749,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','80',1750,'12','1',21149.88,30611.03,9461.15,1561089.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','80',1751,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','80',1752,'14','1',383143.24,388431.49,5288.25,872561.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','80',1753,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','80',1754,'16','1',190682.49,192932.65,2250.16,371276.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','80',1755,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','80',1756,'18','1',320183.95,320183.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','80',1757,'19','1',207121.74,207121.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','80',1758,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','80',1759,'21','2',115509.76,115509.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','80',1760,'22','2',23258.48,24828.99,1570.51,1256408.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1761,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1762,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1763,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1764,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1765,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','81',1766,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1767,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1768,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1769,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1770,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1771,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','81',1772,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','81',1773,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','81',1774,'14','1',388431.49,391718.96,3287.47,542432.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','81',1775,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','81',1776,'16','1',192932.65,197033.84,4101.19,676696.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','81',1777,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','81',1778,'18','1',320183.95,326367.81,6183.86,1020336.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','81',1779,'19','1',207121.74,208890.43,1768.69,291833.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','81',1780,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','81',1781,'21','2',115509.76,115509.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','81',1782,'22','2',24828.99,25243.71,414.72,340070.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1783,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1784,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1785,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1786,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1787,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','82',1788,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1789,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1790,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1791,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1792,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1793,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','82',1794,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','82',1795,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','82',1796,'14','1',391718.96,396240.31,4521.35,746022.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','82',1797,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','82',1798,'16','1',197033.84,200141.10,3107.26,512697.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','82',1799,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','82',1800,'18','1',326367.81,332371.83,6004.02,990663.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','82',1801,'19','1',208890.43,215410.28,6519.85,1075775.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','82',1802,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','82',1803,'21','2',115509.76,115509.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','82',1804,'22','2',25243.71,25759.58,515.87,423013.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1805,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1806,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1807,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1808,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1809,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','83',1810,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1811,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1812,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1813,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1814,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1815,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','83',1816,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','83',1817,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','83',1818,'14','1',396240.31,402808.98,6568.67,1083829.89,0.00,0.00,0.00,0.00,0.00),('5','271','3','83',1819,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','83',1820,'16','1',200141.10,210514.53,10373.43,1711615.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','83',1821,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','83',1822,'18','1',332371.83,332681.59,309.76,51110.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','83',1823,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','83',1824,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','83',1825,'21','2',115509.76,115509.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','83',1826,'22','2',25759.58,26574.82,815.24,668496.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1827,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1828,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1829,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1830,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1831,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','84',1832,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1833,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1834,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1835,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1836,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1837,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','84',1838,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','84',1839,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','84',1840,'14','1',402808.98,404739.62,1930.64,318555.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','84',1841,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','84',1842,'16','1',210514.53,213359.96,2845.43,469495.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','84',1843,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','84',1844,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','84',1845,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','84',1846,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','84',1847,'21','2',115509.76,115607.31,97.55,79991.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','84',1848,'22','2',26574.82,28234.41,1659.59,1360863.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1849,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1850,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1851,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1852,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1853,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','85',1854,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1855,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1856,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1857,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1858,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1859,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','85',1860,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','85',1861,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','85',1862,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','85',1863,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','85',1864,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','85',1865,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','85',1866,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','85',1867,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','85',1868,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','85',1869,'21','2',115607.31,115607.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','85',1870,'22','2',28234.41,29381.50,1147.09,940613.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1871,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1872,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1873,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1874,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1875,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','86',1876,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1877,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1878,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1879,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1880,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1881,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','86',1882,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','86',1883,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','86',1884,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','86',1885,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','86',1886,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','86',1887,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','86',1888,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','86',1889,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','86',1890,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','86',1891,'21','2',115607.31,115757.31,150.00,123000.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','86',1892,'22','2',29381.50,30610.74,1229.24,1007976.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1893,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1894,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1895,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1896,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1897,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','87',1898,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1899,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1900,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1901,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1902,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1903,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','87',1904,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','87',1905,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','87',1906,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','87',1907,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','87',1908,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','87',1909,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','87',1910,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','87',1911,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','87',1912,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','87',1913,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','87',1914,'22','2',30610.74,30857.50,246.76,202343.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1915,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1916,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1917,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1918,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1919,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','88',1920,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1921,'7','1',99153.18,99153.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1922,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1923,'9','1',296145.08,296145.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1924,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1925,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','88',1926,'12','1',30611.03,30611.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','88',1927,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','88',1928,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','88',1929,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','88',1930,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','88',1931,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','88',1932,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','88',1933,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','88',1934,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','88',1935,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','88',1936,'22','2',30857.50,31208.30,350.80,287656.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1937,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1938,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1939,'3','1',263025.53,263025.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1940,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1941,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','89',1942,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1943,'7','1',99153.18,104753.58,5600.40,924066.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1944,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1945,'9','1',296145.08,305722.66,9577.58,1580300.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1946,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1947,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','89',1948,'12','1',30611.03,37411.02,6799.99,1121998.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','89',1949,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','89',1950,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','89',1951,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','89',1952,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','89',1953,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','89',1954,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','89',1955,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','89',1956,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','89',1957,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','89',1958,'22','2',31208.30,31740.28,531.98,436223.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1959,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1960,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1961,'3','1',263025.53,263047.01,21.48,3544.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1962,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1963,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','90',1964,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1965,'7','1',104753.58,109043.71,4290.13,707871.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1966,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1967,'9','1',305722.66,311998.81,6276.15,1035564.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1968,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1969,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','90',1970,'12','1',37411.02,44230.13,6819.11,1125153.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','90',1971,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','90',1972,'14','1',404739.62,404739.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','90',1973,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','90',1974,'16','1',213359.96,213359.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','90',1975,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','90',1976,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','90',1977,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','90',1978,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','90',1979,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','90',1980,'22','2',31740.28,32382.19,641.91,526366.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1981,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1982,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1983,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1984,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1985,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','91',1986,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1987,'7','1',109043.71,109043.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1988,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1989,'9','1',311998.81,313349.63,1350.82,222885.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1990,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1991,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','91',1992,'12','1',44230.13,48369.64,4139.51,683019.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','91',1993,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','91',1994,'14','1',404739.62,410404.49,5664.87,934703.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','91',1995,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','91',1996,'16','1',213359.96,221628.31,8268.35,1364277.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','91',1997,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','91',1998,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','91',1999,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','91',2000,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','91',2001,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','91',2002,'22','2',32382.19,32808.49,426.30,349566.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2003,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2004,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2005,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2006,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2007,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','92',2008,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2009,'7','1',109043.71,109043.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2010,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2011,'9','1',313349.63,319339.82,5990.19,988381.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2012,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2013,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','92',2014,'12','1',48369.64,50649.12,2279.48,376114.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','92',2015,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','92',2016,'14','1',410404.49,414814.93,4410.44,727722.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','92',2017,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','92',2018,'16','1',221628.31,227782.15,6153.84,1015383.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','92',2019,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','92',2020,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','92',2021,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','92',2022,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','92',2023,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','92',2024,'22','2',32808.49,33368.40,559.91,459126.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2025,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2026,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2027,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2028,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2029,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','93',2030,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2031,'7','1',109043.71,113853.43,4809.72,793603.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2032,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2033,'9','1',319339.82,326204.05,6864.23,1132597.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2034,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2035,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','93',2036,'12','1',50649.12,56995.36,6346.24,1047129.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','93',2037,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','93',2038,'14','1',414814.93,414962.40,147.47,24332.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','93',2039,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','93',2040,'16','1',227782.15,228259.79,477.64,78810.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','93',2041,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','93',2042,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','93',2043,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','93',2044,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','93',2045,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','93',2046,'22','2',33368.40,34078.27,709.87,582093.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2047,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2048,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2049,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2050,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2051,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','94',2052,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2053,'7','1',113853.43,114501.00,647.57,106849.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2054,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2055,'9','1',326204.05,329949.27,3745.22,617961.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2056,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2057,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','94',2058,'12','1',56995.36,63284.06,6288.70,1037635.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','94',2059,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','94',2060,'14','1',414962.40,419842.39,4879.99,805198.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','94',2061,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','94',2062,'16','1',228259.79,235286.46,7026.67,1159400.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','94',2063,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','94',2064,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','94',2065,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','94',2066,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','94',2067,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','94',2068,'22','2',34078.27,35112.24,1033.97,847855.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2069,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2070,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2071,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2072,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2073,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','95',2074,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2075,'7','1',114501.00,116267.25,1766.25,291431.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2076,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2077,'9','1',329949.27,330547.18,597.91,98655.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2078,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2079,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','95',2080,'12','1',63284.06,63302.43,18.37,3031.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','95',2081,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','95',2082,'14','1',419842.39,421183.20,1340.81,221233.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','95',2083,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','95',2084,'16','1',235286.46,235286.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','95',2085,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','95',2086,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','95',2087,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','95',2088,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','95',2089,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','95',2090,'22','2',35112.24,35354.64,242.40,193920.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2091,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2092,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2093,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2094,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2095,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','96',2096,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2097,'7','1',116267.25,116267.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2098,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2099,'9','1',330547.18,330934.99,387.81,63988.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2100,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2101,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','96',2102,'12','1',63302.43,63302.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','96',2103,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','96',2104,'14','1',421183.20,421711.64,528.44,87192.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','96',2105,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','96',2106,'16','1',235286.46,235699.62,413.16,68171.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','96',2107,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','96',2108,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','96',2109,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','96',2110,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','96',2111,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','96',2112,'22','2',35354.64,35660.87,306.23,244984.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2113,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2114,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2115,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2116,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2117,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','97',2118,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2119,'7','1',116267.25,116517.08,249.83,41221.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2120,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2121,'9','1',330934.99,330934.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2122,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2123,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','97',2124,'12','1',63302.43,63302.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','97',2125,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','97',2126,'14','1',421711.64,422134.45,422.81,69763.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','97',2127,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','97',2128,'16','1',235699.62,235774.09,74.47,12287.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','97',2129,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','97',2130,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','97',2131,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','97',2132,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','97',2133,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','97',2134,'22','2',35660.87,35791.96,131.09,104872.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2135,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2136,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2137,'3','1',263047.01,263047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2138,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2139,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','98',2140,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2141,'7','1',116517.08,116517.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2142,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2143,'9','1',330934.99,330934.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2144,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2145,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','98',2146,'12','1',63302.43,63302.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','98',2147,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','98',2148,'14','1',422134.45,426575.88,4441.43,732835.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','98',2149,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','98',2150,'16','1',235774.09,241682.10,5908.01,974821.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','98',2151,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','98',2152,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','98',2153,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','98',2154,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','98',2155,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','98',2156,'22','2',35791.96,36427.84,635.88,508704.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2157,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2158,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2159,'3','1',263047.01,265022.90,1975.89,326021.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2160,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2161,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','99',2162,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2163,'7','1',116517.08,118813.48,2296.40,378906.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2164,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2165,'9','1',330934.99,334722.96,3787.97,625015.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2166,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2167,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','99',2168,'12','1',63302.43,66608.55,3306.12,545509.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','99',2169,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','99',2170,'14','1',426575.88,430374.71,3798.83,626806.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','99',2171,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','99',2172,'16','1',241682.10,247475.77,5793.67,955955.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','99',2173,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','99',2174,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','99',2175,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','99',2176,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','99',2177,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','99',2178,'22','2',36427.84,36877.83,449.99,359992.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2179,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2180,'2','1',163026.64,163026.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2181,'3','1',265022.90,265022.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2182,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2183,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','100',2184,'6','1',359654.48,359654.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2185,'7','1',118813.48,125292.41,6478.93,1069023.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2186,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2187,'9','1',334722.96,347061.88,12338.92,2035921.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2188,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2189,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','100',2190,'12','1',66608.55,78510.65,11902.10,1963846.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','100',2191,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','100',2192,'14','1',430374.71,438211.36,7836.65,1293047.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','100',2193,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','100',2194,'16','1',247475.77,247475.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','100',2195,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','100',2196,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','100',2197,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','100',2198,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','100',2199,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','100',2200,'22','2',36877.83,39629.83,2752.00,2201600.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2201,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2202,'2','1',163026.64,170992.10,7965.46,1314300.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2203,'3','1',265022.90,273057.29,8034.39,1325674.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2204,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2205,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','101',2206,'6','1',359654.48,368314.59,8660.11,1428918.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2207,'7','1',125292.41,125292.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2208,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2209,'9','1',347061.88,347061.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2210,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2211,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','101',2212,'12','1',78510.65,78945.73,435.08,71788.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','101',2213,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','101',2214,'14','1',438211.36,438211.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','101',2215,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','101',2216,'16','1',247475.77,259518.61,12042.84,1987068.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','101',2217,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','101',2218,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','101',2219,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','101',2220,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','101',2221,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','101',2222,'22','2',39629.83,39980.64,350.81,280648.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2223,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2224,'2','1',170992.10,170992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2225,'3','1',273057.29,273057.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2226,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2227,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','102',2228,'6','1',368314.59,368314.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2229,'7','1',125292.41,132318.32,7025.91,1159275.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2230,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2231,'9','1',347061.88,347061.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2232,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2233,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','102',2234,'12','1',78945.73,84023.69,5077.96,837863.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','102',2235,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','102',2236,'14','1',438211.36,443866.31,5654.95,933066.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','102',2237,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','102',2238,'16','1',259518.61,267084.78,7566.17,1248418.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','102',2239,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','102',2240,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','102',2241,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','102',2242,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','102',2243,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','102',2244,'22','2',39980.64,40515.90,535.26,428208.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2245,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2246,'2','1',170992.10,170992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2247,'3','1',273057.29,276597.15,3539.86,584076.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2248,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2249,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','103',2250,'6','1',368314.59,371487.01,3172.42,523449.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2251,'7','1',132318.32,132318.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2252,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2253,'9','1',347061.88,352167.21,5105.33,842379.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2254,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2255,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','103',2256,'12','1',84023.69,84023.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','103',2257,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','103',2258,'14','1',443866.31,443866.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','103',2259,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','103',2260,'16','1',267084.78,267669.01,584.23,96397.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','103',2261,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','103',2262,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','103',2263,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','103',2264,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','103',2265,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','103',2266,'22','2',40515.90,40909.65,393.75,315000.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2267,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2268,'2','1',170992.10,170992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2269,'3','1',276597.15,284842.46,8245.31,1360476.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2270,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2271,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','104',2272,'6','1',371487.01,378802.84,7315.83,1207111.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2273,'7','1',132318.32,133956.34,1638.02,270273.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2274,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2275,'9','1',352167.21,357368.77,5201.56,858257.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2276,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2277,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','104',2278,'12','1',84023.69,93337.88,9314.19,1536841.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','104',2279,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','104',2280,'14','1',443866.31,443866.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','104',2281,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','104',2282,'16','1',267669.01,269502.67,1833.66,302553.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','104',2283,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','104',2284,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','104',2285,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','104',2286,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','104',2287,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','104',2288,'22','2',40909.65,42529.50,1619.85,1295880.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2289,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2290,'2','1',170992.10,172964.63,1972.53,364918.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2291,'3','1',284842.46,290116.76,5274.30,975745.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2292,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2293,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','105',2294,'6','1',378802.84,382217.78,3414.94,631763.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2295,'7','1',133956.34,136760.56,2804.22,518780.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2296,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2297,'9','1',357368.77,361358.38,3989.61,738077.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2298,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2299,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','105',2300,'12','1',93337.88,97924.75,4586.87,848570.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','105',2301,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','105',2302,'14','1',443866.31,445533.68,1667.37,308463.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','105',2303,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','105',2304,'16','1',269502.67,272016.14,2513.47,464991.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','105',2305,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','105',2306,'18','1',332681.59,332681.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','105',2307,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','105',2308,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','105',2309,'21','2',115757.31,115757.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','105',2310,'22','2',42529.50,43099.33,569.83,455864.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2311,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2312,'2','1',172964.63,177631.45,4666.82,863361.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2313,'3','1',290116.76,294308.03,4191.27,775384.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2314,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2315,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','106',2316,'6','1',382217.78,387374.29,5156.51,953954.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2317,'7','1',136760.56,136760.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2318,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2319,'9','1',361358.38,361358.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2320,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2321,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','106',2322,'12','1',97924.75,106055.46,8130.71,1504181.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','106',2323,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','106',2324,'14','1',445533.68,445533.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','106',2325,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','106',2326,'16','1',272016.14,272016.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','106',2327,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','106',2328,'18','1',332681.59,337870.39,5188.80,959928.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','106',2329,'19','1',215410.28,215410.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','106',2330,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','106',2331,'21','2',115757.31,116777.30,1019.99,815992.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','106',2332,'22','2',43099.33,45176.68,2077.35,1661880.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2333,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2334,'2','1',177631.45,177631.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2335,'3','1',294308.03,294308.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2336,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2337,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','107',2338,'6','1',387374.29,387374.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2339,'7','1',136760.56,138277.08,1516.52,280556.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2340,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2341,'9','1',361358.38,361358.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2342,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2343,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','107',2344,'12','1',106055.46,110012.40,3956.94,732033.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','107',2345,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','107',2346,'14','1',445533.68,449131.52,3597.84,665600.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','107',2347,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','107',2348,'16','1',272016.14,273556.23,1540.09,284916.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','107',2349,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','107',2350,'18','1',337870.39,339903.48,2033.09,376121.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','107',2351,'19','1',215410.28,219327.19,3916.91,724628.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','107',2352,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','107',2353,'21','2',116777.30,116777.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','107',2354,'22','2',45176.68,46289.94,1113.26,890608.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2355,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2356,'2','1',177631.45,177631.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2357,'3','1',294308.03,297507.25,3199.22,591855.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2358,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2359,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','108',2360,'6','1',387374.29,392146.46,4772.17,882851.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2361,'7','1',138277.08,140331.18,2054.10,380008.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2362,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2363,'9','1',361358.38,368452.40,7094.02,1312393.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2364,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2365,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','108',2366,'12','1',110012.40,117426.90,7414.50,1371682.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','108',2367,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','108',2368,'14','1',449131.52,454103.20,4971.68,919760.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','108',2369,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','108',2370,'16','1',273556.23,278196.87,4640.64,858518.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','108',2371,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','108',2372,'18','1',339903.48,342721.80,2818.32,521389.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','108',2373,'19','1',219327.19,219327.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','108',2374,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','108',2375,'21','2',116777.30,116777.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','108',2376,'22','2',46289.94,47777.42,1487.48,1189984.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2377,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2378,'2','1',177631.45,177631.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2379,'3','1',297507.25,304435.26,6928.01,1281681.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2380,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2381,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','109',2382,'6','1',392146.46,398513.38,6366.92,1177880.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2383,'7','1',140331.18,144066.13,3734.95,690965.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2384,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2385,'9','1',368452.40,375637.95,7185.55,1329326.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2386,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2387,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','109',2388,'12','1',117426.90,126021.28,8594.38,1589960.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','109',2389,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','109',2390,'14','1',454103.20,459785.66,5682.46,1051255.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','109',2391,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','109',2392,'16','1',278196.87,283861.11,5664.24,1047884.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','109',2393,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','109',2394,'18','1',342721.80,349393.53,6671.73,1234270.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','109',2395,'19','1',219327.19,223666.40,4339.21,802753.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','109',2396,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','109',2397,'21','2',116777.30,116777.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','109',2398,'22','2',47777.42,48315.01,537.59,430072.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2399,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2400,'2','1',177631.45,183616.56,5985.11,1107245.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2401,'3','1',304435.26,309929.33,5494.07,1016402.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2402,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2403,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','110',2404,'6','1',398513.38,404391.06,5877.68,1087370.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2405,'7','1',144066.13,144066.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2406,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2407,'9','1',375637.95,375637.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2408,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2409,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','110',2410,'12','1',126021.28,130651.73,4630.45,856633.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','110',2411,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','110',2412,'14','1',459785.66,465115.91,5330.25,986096.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','110',2413,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','110',2414,'16','1',283861.11,292070.76,8209.65,1518785.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','110',2415,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','110',2416,'18','1',349393.53,358085.92,8692.39,1608092.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','110',2417,'19','1',223666.40,231733.65,8067.25,1492441.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','110',2418,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','110',2419,'21','2',116777.30,116777.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','110',2420,'22','2',48315.01,49560.58,1245.57,996456.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2421,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2422,'2','1',183616.56,183616.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2423,'3','1',309929.33,312743.87,2814.54,520689.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2424,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2425,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','111',2426,'6','1',404391.06,407597.20,3206.14,593135.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2427,'7','1',144066.13,150068.71,6002.58,1110477.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2428,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2429,'9','1',375637.95,384724.84,9086.89,1681074.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2430,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2431,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','111',2432,'12','1',130651.73,138990.84,8339.11,1542735.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','111',2433,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','111',2434,'14','1',465115.91,470560.06,5444.15,1007167.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','111',2435,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','111',2436,'16','1',292070.76,299548.39,7477.63,1383361.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','111',2437,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','111',2438,'18','1',358085.92,358161.58,75.66,13997.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','111',2439,'19','1',231733.65,234597.78,2864.13,529864.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','111',2440,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','111',2441,'21','2',116777.30,117101.55,324.25,259400.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','111',2442,'22','2',49560.58,49579.63,19.05,15240.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2443,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2444,'2','1',183616.56,189760.33,6143.77,1136597.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2445,'3','1',312743.87,317822.23,5078.36,939496.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2446,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2447,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','112',2448,'6','1',407597.20,412514.96,4917.76,909785.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2449,'7','1',150068.71,152270.41,2201.70,407314.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2450,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2451,'9','1',384724.84,387527.32,2802.48,518458.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2452,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2453,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','112',2454,'12','1',138990.84,141280.52,2289.68,423590.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','112',2455,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','112',2456,'14','1',470560.06,475148.17,4588.11,848800.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','112',2457,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','112',2458,'16','1',299548.39,304351.74,4803.35,888619.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','112',2459,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','112',2460,'18','1',358161.58,364771.60,6610.02,1222853.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','112',2461,'19','1',234597.78,240863.31,6265.53,1159123.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','112',2462,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','112',2463,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','112',2464,'22','2',49579.63,50119.17,539.54,431632.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2465,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2466,'2','1',189760.33,195989.76,6229.43,1152444.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2467,'3','1',317822.23,323887.50,6065.27,1122074.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2468,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2469,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','113',2470,'6','1',412514.96,419731.05,7216.09,1334976.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2471,'7','1',152270.41,152270.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2472,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2473,'9','1',387527.32,387527.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2474,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2475,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','113',2476,'12','1',141280.52,141280.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','113',2477,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','113',2478,'14','1',475148.17,476227.34,1079.17,199646.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','113',2479,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','113',2480,'16','1',304351.74,306913.74,2562.00,473970.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','113',2481,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','113',2482,'18','1',364771.60,366197.94,1426.34,263872.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','113',2483,'19','1',240863.31,241999.96,1136.65,210280.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','113',2484,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','113',2485,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','113',2486,'22','2',50119.17,51524.90,1405.73,1124584.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2487,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2488,'2','1',195989.76,195989.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2489,'3','1',323887.50,327734.11,3846.61,711622.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2490,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2491,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','114',2492,'6','1',419731.05,424026.51,4295.46,794660.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2493,'7','1',152270.41,157567.35,5296.94,979933.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2494,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2495,'9','1',387527.32,395250.51,7723.19,1428790.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2496,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2497,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','114',2498,'12','1',141280.52,148904.30,7623.78,1410399.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','114',2499,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','114',2500,'14','1',476227.34,476227.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','114',2501,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','114',2502,'16','1',306913.74,306913.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','114',2503,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','114',2504,'18','1',366197.94,366197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','114',2505,'19','1',241999.96,241999.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','114',2506,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','114',2507,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','114',2508,'22','2',51524.90,52697.76,1172.86,938288.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2509,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2510,'2','1',195989.76,195989.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2511,'3','1',327734.11,327734.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2512,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2513,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','115',2514,'6','1',424026.51,424888.16,861.65,159405.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2515,'7','1',157567.35,163469.24,5901.89,1091849.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2516,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2517,'9','1',395250.51,404107.41,8856.90,1638526.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2518,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2519,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','115',2520,'12','1',148904.30,157578.05,8673.75,1604643.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','115',2521,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','115',2522,'14','1',476227.34,476918.77,691.43,127914.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','115',2523,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','115',2524,'16','1',306913.74,306913.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','115',2525,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','115',2526,'18','1',366197.94,366197.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','115',2527,'19','1',241999.96,241999.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','115',2528,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','115',2529,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','115',2530,'22','2',52697.76,53796.33,1098.57,878856.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2531,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2532,'2','1',195989.76,198425.04,2435.28,450526.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2533,'3','1',327734.11,334279.75,6545.64,1210943.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2534,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2535,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','116',2536,'6','1',424888.16,430829.02,5940.86,1099059.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2537,'7','1',163469.24,163469.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2538,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2539,'9','1',404107.41,404140.42,33.01,6106.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2540,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2541,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','116',2542,'12','1',157578.05,158349.25,771.20,142672.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','116',2543,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','116',2544,'14','1',476918.77,476918.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','116',2545,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','116',2546,'16','1',306913.74,306913.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','116',2547,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','116',2548,'18','1',366197.94,375040.73,8842.79,1635916.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','116',2549,'19','1',241999.96,251417.28,9417.32,1742204.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','116',2550,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','116',2551,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','116',2552,'22','2',53796.33,54068.59,272.26,217808.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2553,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2554,'2','1',198425.04,200423.43,1998.39,369702.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2555,'3','1',334279.75,335840.63,1560.88,288762.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2556,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2557,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','117',2558,'6','1',430829.02,432021.83,1192.81,220669.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2559,'7','1',163469.24,163469.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2560,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2561,'9','1',404140.42,404140.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2562,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2563,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','117',2564,'12','1',158349.25,158349.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','117',2565,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','117',2566,'14','1',476918.77,478808.59,1889.82,349616.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','117',2567,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','117',2568,'16','1',306913.74,309676.36,2762.62,511084.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','117',2569,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','117',2570,'18','1',375040.73,377232.20,2191.47,405421.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','117',2571,'19','1',251417.28,254584.81,3167.53,585993.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','117',2572,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','117',2573,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','117',2574,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2575,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2576,'2','1',200423.43,205329.67,4906.24,907654.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2577,'3','1',335840.63,338517.39,2676.76,495200.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2578,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2579,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','118',2580,'6','1',432021.83,434357.85,2336.02,432163.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2581,'7','1',163469.24,164224.08,754.84,139645.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2582,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2583,'9','1',404140.42,405344.53,1204.11,222760.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2584,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2585,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','118',2586,'12','1',158349.25,158349.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','118',2587,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','118',2588,'14','1',478808.59,480797.21,1988.62,367894.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','118',2589,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','118',2590,'16','1',309676.36,313316.84,3640.48,673488.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','118',2591,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','118',2592,'18','1',377232.20,380180.11,2947.91,545363.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','118',2593,'19','1',254584.81,257770.31,3185.50,589317.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','118',2594,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','118',2595,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','118',2596,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2597,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2598,'2','1',205329.67,205329.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2599,'3','1',338517.39,338517.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2600,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2601,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','119',2602,'6','1',434357.85,434357.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2603,'7','1',164224.08,167987.26,3763.18,696188.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2604,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2605,'9','1',405344.53,410848.94,5504.41,1018315.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2606,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2607,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','119',2608,'12','1',158349.25,163145.14,4795.89,887239.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','119',2609,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','119',2610,'14','1',480797.21,484342.74,3545.53,655923.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','119',2611,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','119',2612,'16','1',313316.84,317765.82,4448.98,823061.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','119',2613,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','119',2614,'18','1',380180.11,380180.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','119',2615,'19','1',257770.31,257770.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','119',2616,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','119',2617,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','119',2618,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2619,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2620,'2','1',205329.67,209688.00,4358.33,806291.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2621,'3','1',338517.39,342339.60,3822.21,707108.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2622,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2623,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','120',2624,'6','1',434357.85,434636.94,279.09,51631.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2625,'7','1',167987.26,171115.57,3128.31,578737.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2626,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2627,'9','1',410848.94,417419.25,6570.31,1215507.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2628,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2629,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','120',2630,'12','1',163145.14,168328.57,5183.43,958934.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','120',2631,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','120',2632,'14','1',484342.74,484342.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','120',2633,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','120',2634,'16','1',317765.82,318939.01,1173.19,217040.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','120',2635,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','120',2636,'18','1',380180.11,380180.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','120',2637,'19','1',257770.31,257770.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','120',2638,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','120',2639,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','120',2640,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2641,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2642,'2','1',209688.00,213893.83,4205.83,778078.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2643,'3','1',342339.60,345942.76,3603.16,666584.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2644,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2645,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','121',2646,'6','1',434636.94,434636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2647,'7','1',171115.57,176849.69,5734.12,1060812.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2648,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2649,'9','1',417419.25,423551.34,6132.09,1134436.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2650,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2651,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','121',2652,'12','1',168328.57,168328.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','121',2653,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','121',2654,'14','1',484342.74,490078.79,5736.05,1061169.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','121',2655,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','121',2656,'16','1',318939.01,322585.63,3646.62,674624.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','121',2657,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','121',2658,'18','1',380180.11,383876.72,3696.61,683872.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','121',2659,'19','1',257770.31,257770.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','121',2660,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','121',2661,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','121',2662,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2663,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2664,'2','1',213893.83,219347.71,5453.88,1008967.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2665,'3','1',345942.76,350579.19,4636.43,857739.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2666,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2667,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','122',2668,'6','1',434636.94,434636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2669,'7','1',176849.69,176849.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2670,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2671,'9','1',423551.34,423551.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2672,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2673,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','122',2674,'12','1',168328.57,168328.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','122',2675,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','122',2676,'14','1',490078.79,494690.80,4612.01,853221.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','122',2677,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','122',2678,'16','1',322585.63,330251.65,7666.02,1418213.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','122',2679,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','122',2680,'18','1',383876.72,391911.57,8034.85,1486447.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','122',2681,'19','1',257770.31,257770.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','122',2682,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','122',2683,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','122',2684,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2685,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2686,'2','1',219347.71,221673.95,2326.24,430354.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2687,'3','1',350579.19,353656.62,3077.43,569324.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2688,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2689,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','123',2690,'6','1',434636.94,434636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2691,'7','1',176849.69,178761.44,1911.75,353673.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2692,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2693,'9','1',423551.34,424683.84,1132.50,209512.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2694,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2695,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','123',2696,'12','1',168328.57,168328.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','123',2697,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','123',2698,'14','1',494690.80,497673.12,2982.32,551729.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','123',2699,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','123',2700,'16','1',330251.65,334861.79,4610.14,852875.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','123',2701,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','123',2702,'18','1',391911.57,395809.16,3897.59,721054.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','123',2703,'19','1',257770.31,259650.90,1880.59,347909.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','123',2704,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','123',2705,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','123',2706,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2707,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2708,'2','1',221673.95,224420.31,2746.36,508076.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2709,'3','1',353656.62,355970.17,2313.55,428006.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2710,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2711,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','124',2712,'6','1',434636.94,434636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2713,'7','1',178761.44,178761.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2714,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2715,'9','1',424683.84,424683.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2716,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2717,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','124',2718,'12','1',168328.57,168328.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','124',2719,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','124',2720,'14','1',497673.12,497673.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','124',2721,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','124',2722,'16','1',334861.79,334861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','124',2723,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','124',2724,'18','1',395809.16,400267.83,4458.67,824853.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','124',2725,'19','1',259650.90,263526.30,3875.40,716949.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','124',2726,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','124',2727,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','124',2728,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2729,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2730,'2','1',224420.31,226617.20,2196.89,406424.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2731,'3','1',355970.17,358836.16,2865.99,530208.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2732,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2733,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','125',2734,'6','1',434636.94,434636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2735,'7','1',178761.44,178761.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2736,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2737,'9','1',424683.84,424683.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2738,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2739,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','125',2740,'12','1',168328.57,168328.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','125',2741,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','125',2742,'14','1',497673.12,497673.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','125',2743,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','125',2744,'16','1',334861.79,334861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','125',2745,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','125',2746,'18','1',400267.83,403997.69,3729.86,690024.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','125',2747,'19','1',263526.30,266894.86,3368.56,623183.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','125',2748,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','125',2749,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','125',2750,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2751,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2752,'2','1',226617.20,230950.93,4333.73,801740.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2753,'3','1',358836.16,362678.69,3842.53,710868.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2754,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2755,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','126',2756,'6','1',434636.94,434833.29,196.35,36324.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2757,'7','1',178761.44,178761.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2758,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2759,'9','1',424683.84,430188.73,5504.89,1018404.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2760,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2761,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','126',2762,'12','1',168328.57,173539.82,5211.25,964081.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','126',2763,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','126',2764,'14','1',497673.12,497673.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','126',2765,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','126',2766,'16','1',334861.79,334861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','126',2767,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','126',2768,'18','1',403997.69,403997.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','126',2769,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','126',2770,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','126',2771,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','126',2772,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2773,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2774,'2','1',230950.93,235155.84,4204.91,777908.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2775,'3','1',362678.69,366709.85,4031.16,745764.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2776,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2777,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','127',2778,'6','1',434833.29,434833.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2779,'7','1',178761.44,178761.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2780,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2781,'9','1',430188.73,435667.13,5478.40,1013504.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2782,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2783,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','127',2784,'12','1',173539.82,177448.66,3908.84,723135.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','127',2785,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','127',2786,'14','1',497673.12,500673.35,3000.23,555042.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','127',2787,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','127',2788,'16','1',334861.79,334861.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','127',2789,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','127',2790,'18','1',403997.69,403997.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','127',2791,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','127',2792,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','127',2793,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','127',2794,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2795,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2796,'2','1',235155.84,236648.14,1492.30,276075.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2797,'3','1',366709.85,367705.03,995.18,184108.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2798,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2799,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','128',2800,'6','1',434833.29,434833.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2801,'7','1',178761.44,181405.76,2644.32,489199.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2802,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2803,'9','1',435667.13,440636.37,4969.24,919309.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2804,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2805,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','128',2806,'12','1',177448.66,180695.77,3247.11,600715.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','128',2807,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','128',2808,'14','1',500673.35,503940.00,3266.65,604330.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','128',2809,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','128',2810,'16','1',334861.79,336616.59,1754.80,324638.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','128',2811,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','128',2812,'18','1',403997.69,403997.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','128',2813,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','128',2814,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','128',2815,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','128',2816,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2817,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2818,'2','1',236648.14,241882.67,5234.53,968388.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2819,'3','1',367705.03,371428.41,3723.38,688825.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2820,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2821,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','129',2822,'6','1',434833.29,434833.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2823,'7','1',181405.76,181405.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2824,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2825,'9','1',440636.37,444431.46,3795.09,702091.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2826,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2827,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','129',2828,'12','1',180695.77,183585.04,2889.27,534514.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','129',2829,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','129',2830,'14','1',503940.00,506959.53,3019.53,558613.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','129',2831,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','129',2832,'16','1',336616.59,336616.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','129',2833,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','129',2834,'18','1',403997.69,403997.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','129',2835,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','129',2836,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','129',2837,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','129',2838,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2839,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2840,'2','1',241882.67,247238.51,5355.84,990830.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2841,'3','1',371428.41,375523.24,4094.83,757543.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2842,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2843,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','130',2844,'6','1',434833.29,437529.91,2696.62,498874.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2845,'7','1',181405.76,181405.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2846,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2847,'9','1',444431.46,447557.86,3126.40,578384.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2848,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2849,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','130',2850,'12','1',183585.04,186303.83,2718.79,502976.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','130',2851,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','130',2852,'14','1',506959.53,510565.32,3605.79,667071.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','130',2853,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','130',2854,'16','1',336616.59,337968.24,1351.65,250055.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','130',2855,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','130',2856,'18','1',403997.69,406093.15,2095.46,387660.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','130',2857,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','130',2858,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','130',2859,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','130',2860,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2861,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2862,'2','1',247238.51,250523.14,3284.63,607656.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2863,'3','1',375523.24,375640.26,117.02,21648.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2864,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2865,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','131',2866,'6','1',437529.91,440999.23,3469.32,641824.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2867,'7','1',181405.76,184670.93,3265.17,604056.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2868,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2869,'9','1',447557.86,451162.54,3604.68,666865.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2870,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2871,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','131',2872,'12','1',186303.83,187582.61,1278.78,236574.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','131',2873,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','131',2874,'14','1',510565.32,513249.86,2684.54,496639.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','131',2875,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','131',2876,'16','1',337968.24,337968.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','131',2877,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','131',2878,'18','1',406093.15,410434.56,4341.41,803160.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','131',2879,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','131',2880,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','131',2881,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','131',2882,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2883,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2884,'2','1',250523.14,253993.73,3470.59,642059.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2885,'3','1',375640.26,379464.30,3824.04,707447.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2886,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2887,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','132',2888,'6','1',440999.23,442924.02,1924.79,356086.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2889,'7','1',184670.93,186360.97,1690.04,312657.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2890,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2891,'9','1',451162.54,453198.39,2035.85,376632.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2892,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2893,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','132',2894,'12','1',187582.61,188753.47,1170.86,216609.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','132',2895,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','132',2896,'14','1',513249.86,515202.65,1952.79,361266.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','132',2897,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','132',2898,'16','1',337968.24,338403.52,435.28,80526.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','132',2899,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','132',2900,'18','1',410434.56,414147.16,3712.60,686831.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','132',2901,'19','1',266894.86,266894.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','132',2902,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','132',2903,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','132',2904,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2905,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2906,'2','1',253993.73,256778.56,2784.83,515193.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2907,'3','1',379464.30,383323.94,3859.64,714033.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2908,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2909,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','133',2910,'6','1',442924.02,445264.49,2340.47,432986.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2911,'7','1',186360.97,188618.81,2257.84,417700.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2912,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2913,'9','1',453198.39,455368.99,2170.60,401561.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2914,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2915,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','133',2916,'12','1',188753.47,189492.73,739.26,136763.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','133',2917,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','133',2918,'14','1',515202.65,515721.38,518.73,95965.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','133',2919,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','133',2920,'16','1',338403.52,340005.03,1601.51,296279.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','133',2921,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','133',2922,'18','1',414147.16,416923.52,2776.36,513626.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','133',2923,'19','1',266894.86,268553.12,1658.26,306778.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','133',2924,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','133',2925,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','133',2926,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2927,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2928,'2','1',256778.56,259916.00,3137.44,580426.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2929,'3','1',383323.94,386025.25,2701.31,499742.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2930,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2931,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','134',2932,'6','1',445264.49,447088.67,1824.18,337473.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2933,'7','1',188618.81,190195.25,1576.44,291641.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2934,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2935,'9','1',455368.99,456364.31,995.32,184134.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2936,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2937,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','134',2938,'12','1',189492.73,191199.56,1706.83,315763.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','134',2939,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','134',2940,'14','1',515721.38,517379.87,1658.49,306820.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','134',2941,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','134',2942,'16','1',340005.03,340765.01,759.98,140596.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','134',2943,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','134',2944,'18','1',416923.52,419906.04,2982.52,551766.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','134',2945,'19','1',268553.12,270878.48,2325.36,430191.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','134',2946,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','134',2947,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','134',2948,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2949,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2950,'2','1',259916.00,264309.33,4393.33,812766.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2951,'3','1',386025.25,388754.44,2729.19,504900.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2952,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2953,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','135',2954,'6','1',447088.67,447933.67,845.00,156325.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2955,'7','1',190195.25,192382.57,2187.32,404654.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2956,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2957,'9','1',456364.31,458158.18,1793.87,331865.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2958,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2959,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','135',2960,'12','1',191199.56,191199.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','135',2961,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','135',2962,'14','1',517379.87,517620.49,240.62,44514.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','135',2963,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','135',2964,'16','1',340765.01,341407.18,642.17,118801.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','135',2965,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','135',2966,'18','1',419906.04,423022.53,3116.49,576550.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','135',2967,'19','1',270878.48,272364.98,1486.50,275002.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','135',2968,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','135',2969,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','135',2970,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2971,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2972,'2','1',264309.33,267428.92,3119.59,577124.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2973,'3','1',388754.44,391181.87,2427.43,449074.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2974,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2975,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','136',2976,'6','1',447933.67,449726.29,1792.62,331634.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2977,'7','1',192382.57,193142.12,759.55,140516.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2978,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2979,'9','1',458158.18,458266.49,108.31,20037.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2980,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2981,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','136',2982,'12','1',191199.56,191940.67,741.11,137105.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','136',2983,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','136',2984,'14','1',517620.49,518413.23,792.74,146656.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','136',2985,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','136',2986,'16','1',341407.18,341407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','136',2987,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','136',2988,'18','1',423022.53,425757.81,2735.28,506026.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','136',2989,'19','1',272364.98,274115.08,1750.10,323768.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','136',2990,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','136',2991,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','136',2992,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2993,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2994,'2','1',267428.92,270745.02,3316.10,613478.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2995,'3','1',391181.87,394264.33,3082.46,570255.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2996,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2997,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','137',2998,'6','1',449726.29,451255.78,1529.49,282955.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',2999,'7','1',193142.12,194787.45,1645.33,304386.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',3000,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',3001,'9','1',458266.49,459255.86,989.37,183033.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',3002,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',3003,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','137',3004,'12','1',191940.67,192007.64,66.97,12389.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','137',3005,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','137',3006,'14','1',518413.23,519208.53,795.30,147130.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','137',3007,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','137',3008,'16','1',341407.18,341407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','137',3009,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','137',3010,'18','1',425757.81,428029.02,2271.21,420173.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','137',3011,'19','1',274115.08,275587.67,1472.59,272429.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','137',3012,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','137',3013,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','137',3014,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3015,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3016,'2','1',270745.02,274764.40,4019.38,743585.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3017,'3','1',394264.33,397482.59,3218.26,595378.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3018,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3019,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','138',3020,'6','1',451255.78,453473.32,2217.54,410244.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3021,'7','1',194787.45,196685.74,1898.29,351183.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3022,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3023,'9','1',459255.86,459255.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3024,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3025,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','138',3026,'12','1',192007.64,192007.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','138',3027,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','138',3028,'14','1',519208.53,519208.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','138',3029,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','138',3030,'16','1',341407.18,341407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','138',3031,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','138',3032,'18','1',428029.02,431618.00,3588.98,663961.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','138',3033,'19','1',275587.67,278172.60,2584.93,478212.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','138',3034,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','138',3035,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','138',3036,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3037,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3038,'2','1',274764.40,278416.62,3652.22,675660.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3039,'3','1',397482.59,399924.09,2441.50,451677.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3040,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3041,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','139',3042,'6','1',453473.32,453473.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3043,'7','1',196685.74,200359.49,3673.75,679643.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3044,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3045,'9','1',459255.86,461058.49,1802.63,333486.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3046,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3047,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','139',3048,'12','1',192007.64,192744.11,736.47,136246.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','139',3049,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','139',3050,'14','1',519208.53,519892.08,683.55,126456.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','139',3051,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','139',3052,'16','1',341407.18,341407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','139',3053,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','139',3054,'18','1',431618.00,435500.25,3882.25,718216.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','139',3055,'19','1',278172.60,279329.10,1156.50,213952.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','139',3056,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','139',3057,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','139',3058,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3059,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3060,'2','1',278416.62,282230.35,3813.73,705540.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3061,'3','1',399924.09,403196.13,3272.04,605327.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3062,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3063,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','140',3064,'6','1',453473.32,454921.02,1447.70,267824.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3065,'7','1',200359.49,201830.59,1471.10,272153.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3066,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3067,'9','1',461058.49,461887.25,828.76,153320.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3068,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3069,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','140',3070,'12','1',192744.11,193468.70,724.59,134049.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','140',3071,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','140',3072,'14','1',519892.08,521349.72,1457.64,269663.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','140',3073,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','140',3074,'16','1',341407.18,341407.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','140',3075,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','140',3076,'18','1',435500.25,437809.24,2308.99,427163.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','140',3077,'19','1',279329.10,280018.13,689.03,127470.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','140',3078,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','140',3079,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','140',3080,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3081,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3082,'2','1',282230.35,284994.81,2764.46,511425.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3083,'3','1',403196.13,405173.88,1977.75,365883.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3084,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3085,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','141',3086,'6','1',454921.02,456122.51,1201.49,222275.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3087,'7','1',201830.59,203105.51,1274.92,235860.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3088,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3089,'9','1',461887.25,463815.86,1928.61,356792.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3090,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3091,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','141',3092,'12','1',193468.70,194421.44,952.74,176256.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','141',3093,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','141',3094,'14','1',521349.72,522688.20,1338.48,247618.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','141',3095,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','141',3096,'16','1',341407.18,342701.57,1294.39,239462.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','141',3097,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','141',3098,'18','1',437809.24,438780.89,971.65,179755.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','141',3099,'19','1',280018.13,280657.93,639.80,118363.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','141',3100,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','141',3101,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','141',3102,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3103,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3104,'2','1',284994.81,288412.97,3418.16,632359.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3105,'3','1',405173.88,408207.71,3033.83,561258.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3106,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3107,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','142',3108,'6','1',456122.51,458211.19,2088.68,386405.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3109,'7','1',203105.51,203945.49,839.98,155396.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3110,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3111,'9','1',463815.86,465431.19,1615.33,298836.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3112,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3113,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','142',3114,'12','1',194421.44,194703.35,281.91,52153.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','142',3115,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','142',3116,'14','1',522688.20,523994.63,1306.43,241689.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','142',3117,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','142',3118,'16','1',342701.57,342701.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','142',3119,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','142',3120,'18','1',438780.89,440672.10,1891.21,349873.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','142',3121,'19','1',280657.93,281380.51,722.58,133677.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','142',3122,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','142',3123,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','142',3124,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3125,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3126,'2','1',288412.97,291334.97,2922.00,540570.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3127,'3','1',408207.71,411463.88,3256.17,602391.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3128,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3129,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','143',3130,'6','1',458211.19,459837.83,1626.64,300928.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3131,'7','1',203945.49,205428.52,1483.03,274360.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3132,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3133,'9','1',465431.19,465867.63,436.44,80741.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3134,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3135,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','143',3136,'12','1',194703.35,194703.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','143',3137,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','143',3138,'14','1',523994.63,524920.28,925.65,171245.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','143',3139,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','143',3140,'16','1',342701.57,342701.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','143',3141,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','143',3142,'18','1',440672.10,443724.30,3052.20,564657.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','143',3143,'19','1',281380.51,282925.77,1545.26,285873.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','143',3144,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','143',3145,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','143',3146,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3147,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3148,'2','1',291334.97,294264.91,2929.94,542038.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3149,'3','1',411463.88,414052.31,2588.43,478859.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3150,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3151,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','144',3152,'6','1',459837.83,461910.46,2072.63,383436.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3153,'7','1',205428.52,206992.66,1564.14,289365.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3154,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3155,'9','1',465867.63,466186.58,318.95,59005.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3156,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3157,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','144',3158,'12','1',194703.35,195060.92,357.57,66150.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','144',3159,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','144',3160,'14','1',524920.28,526408.34,1488.06,275291.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','144',3161,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','144',3162,'16','1',342701.57,342701.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','144',3163,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','144',3164,'18','1',443724.30,446532.42,2808.12,519502.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','144',3165,'19','1',282925.77,284099.55,1173.78,217149.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','144',3166,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','144',3167,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','144',3168,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3169,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3170,'2','1',294264.91,296775.84,2510.93,464522.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3171,'3','1',414052.31,416290.89,2238.58,414137.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3172,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3173,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','145',3174,'6','1',461910.46,463590.22,1679.76,310755.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3175,'7','1',206992.66,207646.95,654.29,121043.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3176,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3177,'9','1',466186.58,467026.86,840.28,155451.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3178,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3179,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','145',3180,'12','1',195060.92,195684.24,623.32,115314.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','145',3181,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','145',3182,'14','1',526408.34,526575.37,167.03,30900.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','145',3183,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','145',3184,'16','1',342701.57,342701.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','145',3185,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','145',3186,'18','1',446532.42,449097.92,2565.50,474617.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','145',3187,'19','1',284099.55,286127.43,2027.88,375157.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','145',3188,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','145',3189,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','145',3190,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3191,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3192,'2','1',296775.84,299520.29,2744.45,507723.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3193,'3','1',416290.89,418652.86,2361.97,436964.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3194,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3195,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','146',3196,'6','1',463590.22,465263.57,1673.35,309569.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3197,'7','1',207646.95,207886.34,239.39,44287.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3198,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3199,'9','1',467026.86,467804.76,777.90,143911.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3200,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3201,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','146',3202,'12','1',195684.24,196144.30,460.06,85111.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','146',3203,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','146',3204,'14','1',526575.37,527579.90,1004.53,185838.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','146',3205,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','146',3206,'16','1',342701.57,343726.10,1024.53,189538.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','146',3207,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','146',3208,'18','1',449097.92,451795.00,2697.08,498959.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','146',3209,'19','1',286127.43,286912.42,784.99,145223.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','146',3210,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','146',3211,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','146',3212,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3213,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3214,'2','1',299520.29,302344.37,2824.08,522454.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3215,'3','1',418652.86,421520.52,2867.66,530517.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3216,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3217,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','147',3218,'6','1',465263.57,467572.13,2308.56,427083.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3219,'7','1',207886.34,208805.85,919.51,170109.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3220,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3221,'9','1',467804.76,470088.95,2284.19,422575.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3222,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3223,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','147',3224,'12','1',196144.30,196231.78,87.48,16183.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','147',3225,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','147',3226,'14','1',527579.90,528663.63,1083.73,200490.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','147',3227,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','147',3228,'16','1',343726.10,343891.03,164.93,30512.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','147',3229,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','147',3230,'18','1',451795.00,455007.04,3212.04,594227.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','147',3231,'19','1',286912.42,286912.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','147',3232,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','147',3233,'21','2',117101.55,117101.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','147',3234,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3235,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3236,'2','1',302344.37,303587.68,1243.31,230012.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3237,'3','1',421520.52,422012.07,491.55,90936.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3238,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3239,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','148',3240,'6','1',467572.13,468161.56,589.43,109044.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3241,'7','1',208805.85,211373.99,2568.14,475105.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3242,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3243,'9','1',470088.95,472450.00,2361.05,436794.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3244,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3245,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','148',3246,'12','1',196231.78,197484.10,1252.32,231679.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','148',3247,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','148',3248,'14','1',528663.63,530340.42,1676.79,310206.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','148',3249,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','148',3250,'16','1',343891.03,345214.26,1323.23,244797.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','148',3251,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','148',3252,'18','1',455007.04,458168.98,3161.94,584958.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','148',3253,'19','1',286912.42,286912.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','148',3254,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','148',3255,'21','2',117101.55,118168.42,1066.87,853496.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','148',3256,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3257,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3258,'2','1',303587.68,303587.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3259,'3','1',422012.07,422012.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3260,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3261,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','149',3262,'6','1',468161.56,468161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3263,'7','1',211373.99,214800.98,3426.99,633993.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3264,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3265,'9','1',472450.00,475496.18,3046.18,563543.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3266,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3267,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','149',3268,'12','1',197484.10,198899.74,1415.64,261893.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','149',3269,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','149',3270,'14','1',530340.42,532657.26,2316.84,428615.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','149',3271,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','149',3272,'16','1',345214.26,347011.38,1797.12,332467.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','149',3273,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','149',3274,'18','1',458168.98,461196.73,3027.75,560133.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','149',3275,'19','1',286912.42,286912.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','149',3276,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','149',3277,'21','2',118168.42,118231.53,63.11,50488.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','149',3278,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3279,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3280,'2','1',303587.68,303587.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3281,'3','1',422012.07,422012.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3282,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3283,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','150',3284,'6','1',468161.56,468161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3285,'7','1',214800.98,217684.10,2883.12,533377.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3286,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3287,'9','1',475496.18,478549.54,3053.36,564871.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3288,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3289,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','150',3290,'12','1',198899.74,200881.79,1982.05,366679.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','150',3291,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','150',3292,'14','1',532657.26,534711.06,2053.80,379953.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','150',3293,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','150',3294,'16','1',347011.38,349189.57,2178.19,402965.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','150',3295,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','150',3296,'18','1',461196.73,465008.65,3811.92,705205.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','150',3297,'19','1',286912.42,286912.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','150',3298,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','150',3299,'21','2',118231.53,120175.95,1944.42,1555536.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','150',3300,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3301,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3302,'2','1',303587.68,303587.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3303,'3','1',422012.07,422012.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3304,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3305,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','151',3306,'6','1',468161.56,468161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3307,'7','1',217684.10,220368.04,2683.94,496528.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3308,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3309,'9','1',478549.54,480959.83,2410.29,445903.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3310,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3311,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','151',3312,'12','1',200881.79,202014.38,1132.59,209529.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','151',3313,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','151',3314,'14','1',534711.06,536152.38,1441.32,266644.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','151',3315,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','151',3316,'16','1',349189.57,351192.09,2002.52,370466.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','151',3317,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','151',3318,'18','1',465008.65,468091.56,3082.91,570338.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','151',3319,'19','1',286912.42,287611.33,698.91,129298.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','151',3320,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','151',3321,'21','2',120175.95,120280.03,104.08,83264.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','151',3322,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3323,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3324,'2','1',303587.68,304241.37,653.69,120932.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3325,'3','1',422012.07,422506.04,493.97,91384.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3326,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3327,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','152',3328,'6','1',468161.56,468161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3329,'7','1',220368.04,223597.22,3229.18,597398.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3330,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3331,'9','1',480959.83,482648.67,1688.84,312435.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3332,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3333,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','152',3334,'12','1',202014.38,202645.69,631.31,116792.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','152',3335,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','152',3336,'14','1',536152.38,537803.23,1650.85,305407.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','152',3337,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','152',3338,'16','1',351192.09,352364.65,1172.56,216923.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','152',3339,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','152',3340,'18','1',468091.56,471275.21,3183.65,588975.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','152',3341,'19','1',287611.33,290381.36,2770.03,512455.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','152',3342,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','152',3343,'21','2',120280.03,120373.65,93.62,74896.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','152',3344,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3345,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3346,'2','1',304241.37,307854.55,3613.18,668438.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3347,'3','1',422506.04,425127.70,2621.66,485007.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3348,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3349,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','153',3350,'6','1',468161.56,470227.26,2065.70,382154.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3351,'7','1',223597.22,226397.00,2799.78,517959.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3352,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3353,'9','1',482648.67,484128.43,1479.76,273755.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3354,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3355,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','153',3356,'12','1',202645.69,202645.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','153',3357,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','153',3358,'14','1',537803.23,539783.21,1979.98,366296.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','153',3359,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','153',3360,'16','1',352364.65,352684.40,319.75,59153.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','153',3361,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','153',3362,'18','1',471275.21,474671.12,3395.91,628243.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','153',3363,'19','1',290381.36,292201.64,1820.28,336751.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','153',3364,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','153',3365,'21','2',120373.65,120986.64,612.99,490392.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','153',3366,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3367,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3368,'2','1',307854.55,312372.80,4518.25,835876.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3369,'3','1',425127.70,429656.59,4528.89,837844.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3370,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3371,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','154',3372,'6','1',470227.26,474121.85,3894.59,720499.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3373,'7','1',226397.00,227433.74,1036.74,191796.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3374,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3375,'9','1',484128.43,487802.43,3674.00,679690.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3376,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3377,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','154',3378,'12','1',202645.69,203120.92,475.23,87917.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','154',3379,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','154',3380,'14','1',539783.21,541166.41,1383.20,255892.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','154',3381,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','154',3382,'16','1',352684.40,354019.68,1335.28,247026.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','154',3383,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','154',3384,'18','1',474671.12,474671.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','154',3385,'19','1',292201.64,292201.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','154',3386,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','154',3387,'21','2',120986.64,122858.46,1871.82,1497456.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','154',3388,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3389,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3390,'2','1',312372.80,316732.16,4359.36,806481.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3391,'3','1',429656.59,433169.53,3512.94,649893.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3392,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3393,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','155',3394,'6','1',474121.85,477950.97,3829.12,708387.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3395,'7','1',227433.74,228484.43,1050.69,194377.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3396,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3397,'9','1',487802.43,488410.34,607.91,112463.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3398,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3399,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','155',3400,'12','1',203120.92,203199.42,78.50,14522.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','155',3401,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','155',3402,'14','1',541166.41,541166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','155',3403,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','155',3404,'16','1',354019.68,356325.68,2306.00,426610.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','155',3405,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','155',3406,'18','1',474671.12,474671.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','155',3407,'19','1',292201.64,292201.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','155',3408,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','155',3409,'21','2',122858.46,122940.08,81.62,65296.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','155',3410,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3411,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3412,'2','1',316732.16,321309.90,4577.74,846881.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3413,'3','1',433169.53,436582.85,3413.32,631464.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3414,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3415,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','156',3416,'6','1',477950.97,480703.34,2752.37,509188.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3417,'7','1',228484.43,228484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3418,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3419,'9','1',488410.34,488427.21,16.87,3120.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3420,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3421,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','156',3422,'12','1',203199.42,203199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','156',3423,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','156',3424,'14','1',541166.41,541986.50,820.09,151716.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','156',3425,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','156',3426,'16','1',356325.68,357176.96,851.28,157486.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','156',3427,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','156',3428,'18','1',474671.12,477309.85,2638.73,488165.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','156',3429,'19','1',292201.64,294181.27,1979.63,366231.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','156',3430,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','156',3431,'21','2',122940.08,123018.07,77.99,62392.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','156',3432,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3433,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3434,'2','1',321309.90,321332.49,22.59,4179.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3435,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3436,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3437,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','157',3438,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3439,'7','1',228484.43,228484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3440,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3441,'9','1',488427.21,488427.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3442,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3443,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','157',3444,'12','1',203199.42,203199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','157',3445,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','157',3446,'14','1',541986.50,545925.03,3938.53,728628.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','157',3447,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','157',3448,'16','1',357176.96,361521.67,4344.71,803771.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','157',3449,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','157',3450,'18','1',477309.85,482607.75,5297.90,980111.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','157',3451,'19','1',294181.27,298917.35,4736.08,876174.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','157',3452,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','157',3453,'21','2',123018.07,123266.60,248.53,198824.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','157',3454,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3455,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3456,'2','1',321332.49,321332.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3457,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3458,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3459,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','158',3460,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3461,'7','1',228484.43,228484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3462,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3463,'9','1',488427.21,488427.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3464,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3465,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','158',3466,'12','1',203199.42,203199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','158',3467,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','158',3468,'14','1',545925.03,550044.67,4119.64,762133.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','158',3469,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','158',3470,'16','1',361521.67,364564.50,3042.83,562923.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','158',3471,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','158',3472,'18','1',482607.75,487369.62,4761.87,880945.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','158',3473,'19','1',298917.35,304264.65,5347.30,989250.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','158',3474,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','158',3475,'21','2',123266.60,123790.74,524.14,419312.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','158',3476,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3477,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3478,'2','1',321332.49,321332.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3479,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3480,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3481,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','159',3482,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3483,'7','1',228484.43,228484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3484,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3485,'9','1',488427.21,488427.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3486,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3487,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','159',3488,'12','1',203199.42,203199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','159',3489,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','159',3490,'14','1',550044.67,554612.34,4567.67,845018.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','159',3491,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','159',3492,'16','1',364564.50,368549.23,3984.73,737175.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','159',3493,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','159',3494,'18','1',487369.62,491671.90,4302.28,795921.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','159',3495,'19','1',304264.65,307735.98,3471.33,642196.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','159',3496,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','159',3497,'21','2',123790.74,123959.73,168.99,135192.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','159',3498,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3499,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3500,'2','1',321332.49,321332.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3501,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3502,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3503,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','160',3504,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3505,'7','1',228484.43,228484.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3506,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3507,'9','1',488427.21,488427.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3508,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3509,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','160',3510,'12','1',203199.42,203199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','160',3511,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','160',3512,'14','1',554612.34,561625.32,7012.98,1297401.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','160',3513,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','160',3514,'16','1',368549.23,376923.49,8374.26,1549238.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','160',3515,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','160',3516,'18','1',491671.90,492598.53,926.63,171426.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','160',3517,'19','1',307735.98,308461.04,725.06,134136.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','160',3518,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','160',3519,'21','2',123959.73,124296.36,336.63,269304.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','160',3520,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3521,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3522,'2','1',321332.49,321332.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3523,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3524,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3525,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','161',3526,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3527,'7','1',228484.43,234148.51,5664.08,1047854.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3528,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3529,'9','1',488427.21,494124.51,5697.30,1054000.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3530,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3531,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','161',3532,'12','1',203199.42,206552.42,3353.00,620305.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','161',3533,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','161',3534,'14','1',561625.32,563143.58,1518.26,280878.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','161',3535,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','161',3536,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','161',3537,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','161',3538,'18','1',492598.53,492598.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','161',3539,'19','1',308461.04,308461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','161',3540,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','161',3541,'21','2',124296.36,124471.74,175.38,140304.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','161',3542,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3543,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3544,'2','1',321332.49,321332.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3545,'3','1',436582.85,436582.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3546,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3547,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','162',3548,'6','1',480703.34,480703.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3549,'7','1',234148.51,240005.69,5857.18,1083578.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3550,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3551,'9','1',494124.51,499666.82,5542.31,1025327.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3552,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3553,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','162',3554,'12','1',206552.42,211382.58,4830.16,893579.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','162',3555,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','162',3556,'14','1',563143.58,563143.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','162',3557,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','162',3558,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','162',3559,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','162',3560,'18','1',492598.53,492598.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','162',3561,'19','1',308461.04,308461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','162',3562,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','162',3563,'21','2',124471.74,124756.23,284.49,227592.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','162',3564,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3565,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3566,'2','1',321332.49,325905.47,4572.98,846001.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3567,'3','1',436582.85,440915.20,4332.35,801484.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3568,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3569,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','163',3570,'6','1',480703.34,483274.40,2571.06,475646.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3571,'7','1',240005.69,242719.11,2713.42,501982.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3572,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3573,'9','1',499666.82,501992.48,2325.66,430247.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3574,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3575,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','163',3576,'12','1',211382.58,213181.82,1799.24,332859.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','163',3577,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','163',3578,'14','1',563143.58,563143.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','163',3579,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','163',3580,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','163',3581,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','163',3582,'18','1',492598.53,492598.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','163',3583,'19','1',308461.04,308461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','163',3584,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','163',3585,'21','2',124756.23,124939.28,183.05,146440.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','163',3586,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3587,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3588,'2','1',325905.47,330199.42,4293.95,794380.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3589,'3','1',440915.20,444834.50,3919.30,725070.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3590,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3591,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','164',3592,'6','1',483274.40,487201.50,3927.10,726513.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3593,'7','1',242719.11,244222.35,1503.24,278099.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3594,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3595,'9','1',501992.48,503459.86,1467.38,271465.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3596,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3597,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','164',3598,'12','1',213181.82,214228.95,1047.13,193719.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','164',3599,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','164',3600,'14','1',563143.58,563143.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','164',3601,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','164',3602,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','164',3603,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','164',3604,'18','1',492598.53,492598.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','164',3605,'19','1',308461.04,308461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','164',3606,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','164',3607,'21','2',124939.28,125399.65,460.37,368296.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','164',3608,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3609,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3610,'2','1',330199.42,333757.59,3558.17,658261.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3611,'3','1',444834.50,446608.71,1774.21,328228.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3612,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3613,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','165',3614,'6','1',487201.50,490035.16,2833.66,524227.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3615,'7','1',244222.35,244222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3616,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3617,'9','1',503459.86,504101.45,641.59,118694.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3618,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3619,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','165',3620,'12','1',214228.95,214627.52,398.57,73735.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','165',3621,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','165',3622,'14','1',563143.58,563145.30,1.72,318.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','165',3623,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','165',3624,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','165',3625,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','165',3626,'18','1',492598.53,495325.11,2726.58,504417.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','165',3627,'19','1',308461.04,310489.21,2028.17,375211.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','165',3628,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','165',3629,'21','2',125399.65,125716.80,317.15,253720.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','165',3630,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3631,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3632,'2','1',333757.59,337971.16,4213.57,779510.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3633,'3','1',446608.71,449715.11,3106.40,574684.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3634,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3635,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','166',3636,'6','1',490035.16,492749.75,2714.59,502199.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3637,'7','1',244222.35,244222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3638,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3639,'9','1',504101.45,506295.76,2194.31,405947.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3640,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3641,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','166',3642,'12','1',214627.52,215591.76,964.24,178384.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','166',3643,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','166',3644,'14','1',563145.30,563145.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','166',3645,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','166',3646,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','166',3647,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','166',3648,'18','1',495325.11,498756.33,3431.22,634775.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','166',3649,'19','1',310489.21,311405.42,916.21,169498.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','166',3650,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','166',3651,'21','2',125716.80,125905.46,188.66,150928.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','166',3652,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3653,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3654,'2','1',337971.16,339275.58,1304.42,241317.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3655,'3','1',449715.11,450706.62,991.51,183429.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3656,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3657,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','167',3658,'6','1',492749.75,493769.81,1020.06,188711.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3659,'7','1',244222.35,247451.29,3228.94,597353.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3660,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3661,'9','1',506295.76,510395.69,4099.93,758487.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3662,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3663,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','167',3664,'12','1',215591.76,217717.07,2125.31,393182.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','167',3665,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','167',3666,'14','1',563145.30,563145.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','167',3667,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','167',3668,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','167',3669,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','167',3670,'18','1',498756.33,503499.36,4743.03,877460.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','167',3671,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','167',3672,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','167',3673,'21','2',125905.46,126967.18,1061.72,849376.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','167',3674,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3675,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3676,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3677,'3','1',450706.62,450706.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3678,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3679,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','168',3680,'6','1',493769.81,493769.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3681,'7','1',247451.29,251659.17,4207.88,778457.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3682,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3683,'9','1',510395.69,514770.57,4374.88,809352.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3684,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3685,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','168',3686,'12','1',217717.07,220394.61,2677.54,495344.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','168',3687,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','168',3688,'14','1',563145.30,563145.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','168',3689,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','168',3690,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','168',3691,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','168',3692,'18','1',503499.36,508015.95,4516.59,835569.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','168',3693,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','168',3694,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','168',3695,'21','2',126967.18,134870.25,7903.07,6322456.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','168',3696,'22','2',54068.59,54068.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3697,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3698,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3699,'3','1',450706.62,450706.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3700,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3701,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','169',3702,'6','1',493769.81,493769.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3703,'7','1',251659.17,254892.00,3232.83,598073.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3704,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3705,'9','1',514770.57,518355.93,3585.36,663291.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3706,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3707,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','169',3708,'12','1',220394.61,223475.85,3081.24,570029.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','169',3709,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','169',3710,'14','1',563145.30,566327.66,3182.36,588736.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','169',3711,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','169',3712,'16','1',376923.49,376923.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','169',3713,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','169',3714,'18','1',508015.95,512697.72,4681.77,866127.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','169',3715,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','169',3716,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','169',3717,'21','2',134870.25,142865.31,7995.06,6396048.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','169',3718,'22','2',54068.59,54331.09,262.50,210000.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3719,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3720,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3721,'3','1',450706.62,450706.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3722,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3723,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','170',3724,'6','1',493769.81,493769.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3725,'7','1',254892.00,258348.38,3456.38,639430.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3726,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3727,'9','1',518355.93,520879.27,2523.34,466817.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3728,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3729,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','170',3730,'12','1',223475.85,225603.27,2127.42,393572.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','170',3731,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','170',3732,'14','1',566327.66,569570.82,3243.16,599984.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','170',3733,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','170',3734,'16','1',376923.49,378750.79,1827.30,338050.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','170',3735,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','170',3736,'18','1',512697.72,516935.26,4237.54,783944.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','170',3737,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','170',3738,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','170',3739,'21','2',142865.31,145236.05,2370.74,1896592.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','170',3740,'22','2',54331.09,54331.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3741,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3742,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3743,'3','1',450706.62,450706.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3744,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3745,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','171',3746,'6','1',493769.81,493769.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3747,'7','1',258348.38,261994.92,3646.54,674609.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3748,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3749,'9','1',520879.27,524867.71,3988.44,737861.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3750,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3751,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','171',3752,'12','1',225603.27,226634.79,1031.52,190831.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','171',3753,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','171',3754,'14','1',569570.82,571613.24,2042.42,377847.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','171',3755,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','171',3756,'16','1',378750.79,380337.39,1586.60,293521.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','171',3757,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','171',3758,'18','1',516935.26,521994.10,5058.84,935885.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','171',3759,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','171',3760,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','171',3761,'21','2',145236.05,145410.83,174.78,139824.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','171',3762,'22','2',54331.09,54501.58,170.49,136392.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3763,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3764,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3765,'3','1',450706.62,454940.85,4234.23,783332.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3766,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3767,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','172',3768,'6','1',493769.81,493769.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3769,'7','1',261994.92,263342.67,1347.75,249333.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3770,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3771,'9','1',524867.71,527522.16,2654.45,491073.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3772,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3773,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','172',3774,'12','1',226634.79,229510.57,2875.78,532019.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','172',3775,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','172',3776,'14','1',571613.24,574331.91,2718.67,502953.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','172',3777,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','172',3778,'16','1',380337.39,380337.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','172',3779,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','172',3780,'18','1',521994.10,526207.39,4213.29,779458.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','172',3781,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','172',3782,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','172',3783,'21','2',145410.83,145410.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','172',3784,'22','2',54501.58,55463.25,961.67,769336.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3785,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3786,'2','1',339275.58,339275.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3787,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3788,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3789,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','173',3790,'6','1',493769.81,495766.54,1996.73,369395.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3791,'7','1',263342.67,266528.60,3185.93,589397.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3792,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3793,'9','1',527522.16,531939.10,4416.94,817133.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3794,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3795,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','173',3796,'12','1',229510.57,231530.17,2019.60,373626.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','173',3797,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','173',3798,'14','1',574331.91,576411.84,2079.93,384787.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','173',3799,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','173',3800,'16','1',380337.39,381039.11,701.72,129818.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','173',3801,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','173',3802,'18','1',526207.39,529511.48,3304.09,611256.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','173',3803,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','173',3804,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','173',3805,'21','2',145410.83,145410.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','173',3806,'22','2',55463.25,55966.75,503.50,402800.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3807,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3808,'2','1',339275.58,343539.48,4263.90,788821.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3809,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3810,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3811,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','174',3812,'6','1',495766.54,496393.19,626.65,115930.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3813,'7','1',266528.60,269960.14,3431.54,634834.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3814,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3815,'9','1',531939.10,535683.69,3744.59,692749.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3816,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3817,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','174',3818,'12','1',231530.17,233930.99,2400.82,444151.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','174',3819,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','174',3820,'14','1',576411.84,578374.46,1962.62,363084.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','174',3821,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','174',3822,'16','1',381039.11,382633.71,1594.60,295001.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','174',3823,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','174',3824,'18','1',529511.48,529689.93,178.45,33013.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','174',3825,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','174',3826,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','174',3827,'21','2',145410.83,145720.34,309.51,247608.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','174',3828,'22','2',55966.75,56436.35,469.60,375680.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3829,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3830,'2','1',343539.48,345370.32,1830.84,338705.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3831,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3832,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3833,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','175',3834,'6','1',496393.19,498532.25,2139.06,395726.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3835,'7','1',269960.14,272965.06,3004.92,555910.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3836,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3837,'9','1',535683.69,538828.25,3144.56,581743.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3838,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3839,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','175',3840,'12','1',233930.99,236221.44,2290.45,423733.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','175',3841,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','175',3842,'14','1',578374.46,581842.66,3468.20,641617.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','175',3843,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','175',3844,'16','1',382633.71,384758.88,2125.17,393156.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','175',3845,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','175',3846,'18','1',529689.93,529764.81,74.88,13852.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','175',3847,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','175',3848,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','175',3849,'21','2',145720.34,147439.31,1718.97,1375176.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','175',3850,'22','2',56436.35,56436.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3851,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3852,'2','1',345370.32,348678.45,3308.13,612004.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3853,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3854,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3855,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','176',3856,'6','1',498532.25,501480.09,2947.84,545350.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3857,'7','1',272965.06,275016.94,2051.88,379597.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3858,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3859,'9','1',538828.25,541911.13,3082.88,570332.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3860,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3861,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','176',3862,'12','1',236221.44,236221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','176',3863,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','176',3864,'14','1',581842.66,583797.40,1954.74,361626.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','176',3865,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','176',3866,'16','1',384758.88,385469.04,710.16,131379.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','176',3867,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','176',3868,'18','1',529764.81,529764.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','176',3869,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','176',3870,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','176',3871,'21','2',147439.31,148780.92,1341.61,1073288.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','176',3872,'22','2',56436.35,56436.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3873,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3874,'2','1',348678.45,353605.70,4927.25,911541.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3875,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3876,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3877,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','177',3878,'6','1',501480.09,505897.89,4417.80,817293.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3879,'7','1',275016.94,278163.13,3146.19,582045.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3880,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3881,'9','1',541911.13,546548.88,4637.75,857983.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3882,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3883,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','177',3884,'12','1',236221.44,236221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','177',3885,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','177',3886,'14','1',583797.40,586278.53,2481.13,459009.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','177',3887,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','177',3888,'16','1',385469.04,385909.46,440.42,81477.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','177',3889,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','177',3890,'18','1',529764.81,529764.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','177',3891,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','177',3892,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','177',3893,'21','2',148780.92,149904.48,1123.56,898848.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','177',3894,'22','2',56436.35,56436.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3895,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3896,'2','1',353605.70,358658.37,5052.67,934743.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3897,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3898,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3899,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','178',3900,'6','1',505897.89,509875.54,3977.65,735865.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3901,'7','1',278163.13,278926.75,763.62,141269.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3902,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3903,'9','1',546548.88,550798.10,4249.22,786105.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3904,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3905,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','178',3906,'12','1',236221.44,237679.16,1457.72,269678.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','178',3907,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','178',3908,'14','1',586278.53,588294.07,2015.54,372874.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','178',3909,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','178',3910,'16','1',385909.46,386554.82,645.36,119391.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','178',3911,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','178',3912,'18','1',529764.81,529764.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','178',3913,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','178',3914,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','178',3915,'21','2',149904.48,149962.97,58.49,46792.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','178',3916,'22','2',56436.35,57703.88,1267.53,1014024.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3917,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3918,'2','1',358658.37,363464.53,4806.16,889139.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3919,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3920,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3921,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','179',3922,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3923,'7','1',278926.75,282758.41,3831.66,708857.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3924,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3925,'9','1',550798.10,554978.42,4180.32,773359.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3926,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3927,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','179',3928,'12','1',237679.16,238723.44,1044.28,193191.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','179',3929,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','179',3930,'14','1',588294.07,588801.75,507.68,93920.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','179',3931,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','179',3932,'16','1',386554.82,389764.03,3209.21,593703.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','179',3933,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','179',3934,'18','1',529764.81,529764.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','179',3935,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','179',3936,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','179',3937,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','179',3938,'22','2',57703.88,60123.70,2419.82,1935856.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3939,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3940,'2','1',363464.53,367157.90,3693.37,683273.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3941,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3942,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3943,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','180',3944,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3945,'7','1',282758.41,286222.85,3464.44,640921.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3946,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3947,'9','1',554978.42,559049.96,4071.54,753234.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3948,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3949,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','180',3950,'12','1',238723.44,240423.40,1699.96,314492.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','180',3951,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','180',3952,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','180',3953,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','180',3954,'16','1',389764.03,392403.73,2639.70,488344.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','180',3955,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','180',3956,'18','1',529764.81,529764.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','180',3957,'19','1',311405.42,311405.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','180',3958,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','180',3959,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','180',3960,'22','2',60123.70,60479.90,356.20,284960.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3961,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3962,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3963,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3964,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3965,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','181',3966,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3967,'7','1',286222.85,288268.27,2045.42,378402.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3968,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3969,'9','1',559049.96,560109.67,1059.71,196046.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3970,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3971,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','181',3972,'12','1',240423.40,241995.36,1571.96,290812.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','181',3973,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','181',3974,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','181',3975,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','181',3976,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','181',3977,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','181',3978,'18','1',529764.81,535494.32,5729.51,1059959.35,0.00,0.00,0.00,0.00,0.00),('5','271','4','181',3979,'19','1',311405.42,316797.25,5391.83,997488.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','181',3980,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','181',3981,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','181',3982,'22','2',60479.90,60479.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3983,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3984,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3985,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3986,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3987,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','182',3988,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3989,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3990,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3991,'9','1',560109.67,560109.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3992,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3993,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','182',3994,'12','1',241995.36,241995.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','182',3995,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','182',3996,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','182',3997,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','182',3998,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','182',3999,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','182',4000,'18','1',535494.32,544399.39,8905.07,1647437.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','182',4001,'19','1',316797.25,318040.49,1243.24,229999.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','182',4002,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','182',4003,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','182',4004,'22','2',60479.90,64773.00,4293.10,3434480.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4005,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4006,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4007,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4008,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4009,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','183',4010,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4011,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4012,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4013,'9','1',560109.67,560109.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4014,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4015,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','183',4016,'12','1',241995.36,241995.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','183',4017,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','183',4018,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','183',4019,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','183',4020,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','183',4021,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','183',4022,'18','1',544399.39,549839.71,5440.32,1006459.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','183',4023,'19','1',318040.49,318040.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','183',4024,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','183',4025,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','183',4026,'22','2',64773.00,66123.70,1350.70,1080560.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4027,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4028,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4029,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4030,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4031,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','184',4032,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4033,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4034,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4035,'9','1',560109.67,560109.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4036,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4037,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','184',4038,'12','1',241995.36,241995.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','184',4039,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','184',4040,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','184',4041,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','184',4042,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','184',4043,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','184',4044,'18','1',549839.71,553175.27,3335.56,617078.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','184',4045,'19','1',318040.49,318040.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','184',4046,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','184',4047,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','184',4048,'22','2',66123.70,66123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4049,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4050,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4051,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4052,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4053,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','185',4054,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4055,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4056,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4057,'9','1',560109.67,560109.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4058,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4059,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','185',4060,'12','1',241995.36,241995.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','185',4061,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','185',4062,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','185',4063,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','185',4064,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','185',4065,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','185',4066,'18','1',553175.27,554802.68,1627.41,301070.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','185',4067,'19','1',318040.49,318108.04,67.55,12496.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','185',4068,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','185',4069,'21','2',149962.97,149962.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','185',4070,'22','2',66123.70,66123.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4071,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4072,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4073,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4074,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4075,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','186',4076,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4077,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4078,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4079,'9','1',560109.67,560109.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4080,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4081,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','186',4082,'12','1',241995.36,241995.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','186',4083,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','186',4084,'14','1',588801.75,588801.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','186',4085,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','186',4086,'16','1',392403.73,392403.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','186',4087,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','186',4088,'18','1',554802.68,560152.13,5349.45,989648.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','186',4089,'19','1',318108.04,321451.02,3342.98,618451.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','186',4090,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','186',4091,'21','2',149962.97,150336.32,373.35,298680.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','186',4092,'22','2',66123.70,66357.39,233.69,186952.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4093,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4094,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4095,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4096,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4097,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','187',4098,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4099,'7','1',288268.27,288268.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4100,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4101,'9','1',560109.67,561163.35,1053.68,194930.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4102,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4103,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','187',4104,'12','1',241995.36,243430.23,1434.87,265450.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','187',4105,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','187',4106,'14','1',588801.75,590180.88,1379.13,255139.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','187',4107,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','187',4108,'16','1',392403.73,393262.15,858.42,158807.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','187',4109,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','187',4110,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','187',4111,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','187',4112,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','187',4113,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','187',4114,'22','2',66357.39,69607.07,3249.68,2599744.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4115,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4116,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4117,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4118,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4119,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','188',4120,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4121,'7','1',288268.27,292293.76,4025.49,744715.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4122,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4123,'9','1',561163.35,568779.01,7615.66,1408897.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4124,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4125,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','188',4126,'12','1',243430.23,249353.70,5923.47,1095841.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','188',4127,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','188',4128,'14','1',590180.88,593586.49,3405.61,630037.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','188',4129,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','188',4130,'16','1',393262.15,394421.81,1159.66,214537.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','188',4131,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','188',4132,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','188',4133,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','188',4134,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','188',4135,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','188',4136,'22','2',69607.07,70325.87,718.80,575040.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4137,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4138,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4139,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4140,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4141,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','189',4142,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4143,'7','1',292293.76,294982.06,2688.30,497335.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4144,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4145,'9','1',568779.01,572644.28,3865.27,715074.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4146,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4147,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','189',4148,'12','1',249353.70,252993.18,3639.48,673303.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','189',4149,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','189',4150,'14','1',593586.49,598223.13,4636.64,857778.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','189',4151,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','189',4152,'16','1',394421.81,400160.41,5738.60,1061641.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','189',4153,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','189',4154,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','189',4155,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','189',4156,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','189',4157,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','189',4158,'22','2',70325.87,70754.99,429.12,343296.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4159,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4160,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4161,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4162,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4163,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','190',4164,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4165,'7','1',294982.06,294982.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4166,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4167,'9','1',572644.28,572644.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4168,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4169,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','190',4170,'12','1',252993.18,252993.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','190',4171,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','190',4172,'14','1',598223.13,603340.36,5117.23,946687.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','190',4173,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','190',4174,'16','1',400160.41,404605.20,4444.79,822286.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','190',4175,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','190',4176,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','190',4177,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','190',4178,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','190',4179,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','190',4180,'22','2',70754.99,71360.58,605.59,484472.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4181,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4182,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4183,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4184,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4185,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','191',4186,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4187,'7','1',294982.06,294982.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4188,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4189,'9','1',572644.28,572644.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4190,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4191,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','191',4192,'12','1',252993.18,252993.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','191',4193,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','191',4194,'14','1',603340.36,604777.94,1437.58,265952.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','191',4195,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','191',4196,'16','1',404605.20,406252.25,1647.05,304704.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','191',4197,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','191',4198,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','191',4199,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','191',4200,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','191',4201,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','191',4202,'22','2',71360.58,71692.75,332.17,265736.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4203,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4204,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4205,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4206,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4207,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','192',4208,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4209,'7','1',294982.06,294982.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4210,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4211,'9','1',572644.28,573731.27,1086.99,201093.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4212,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4213,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','192',4214,'12','1',252993.18,253834.69,841.51,155679.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','192',4215,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','192',4216,'14','1',604777.94,604777.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','192',4217,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','192',4218,'16','1',406252.25,406252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','192',4219,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','192',4220,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','192',4221,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','192',4222,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','192',4223,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','192',4224,'22','2',71692.75,72641.93,949.18,759344.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4225,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4226,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4227,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4228,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4229,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','193',4230,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4231,'7','1',294982.06,298903.64,3921.58,725492.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4232,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4233,'9','1',573731.27,579876.96,6145.69,1136952.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4234,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4235,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','193',4236,'12','1',253834.69,258736.16,4901.47,906771.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','193',4237,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','193',4238,'14','1',604777.94,604777.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','193',4239,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','193',4240,'16','1',406252.25,406252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','193',4241,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','193',4242,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','193',4243,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','193',4244,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','193',4245,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','193',4246,'22','2',72641.93,73495.35,853.42,682736.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4247,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4248,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4249,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4250,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4251,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','194',4252,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4253,'7','1',298903.64,298903.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4254,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4255,'9','1',579876.96,579876.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4256,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4257,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','194',4258,'12','1',258736.16,258736.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','194',4259,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','194',4260,'14','1',604777.94,604777.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','194',4261,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','194',4262,'16','1',406252.25,406252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','194',4263,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','194',4264,'18','1',560152.13,560152.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','194',4265,'19','1',321451.02,321451.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','194',4266,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','194',4267,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','194',4268,'22','2',73495.35,73902.65,407.30,325840.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4269,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4270,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4271,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4272,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4273,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','195',4274,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4275,'7','1',298903.64,302459.53,3555.89,657839.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4276,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4277,'9','1',579876.96,584439.80,4562.84,844125.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4278,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4279,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','195',4280,'12','1',258736.16,263270.78,4534.62,838904.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','195',4281,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','195',4282,'14','1',604777.94,609551.88,4773.94,883178.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','195',4283,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','195',4284,'16','1',406252.25,406252.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','195',4285,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','195',4286,'18','1',560152.13,567304.53,7152.40,1323194.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','195',4287,'19','1',321451.02,323484.61,2033.59,376214.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','195',4288,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','195',4289,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','195',4290,'22','2',73902.65,73902.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4291,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4292,'2','1',367157.90,367157.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4293,'3','1',454940.85,454940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4294,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4295,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','196',4296,'6','1',509875.54,509875.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4297,'7','1',302459.53,306559.04,4099.51,758409.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4298,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4299,'9','1',584439.80,589732.55,5292.75,979158.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4300,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4301,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','196',4302,'12','1',263270.78,268949.48,5678.70,1050559.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','196',4303,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','196',4304,'14','1',609551.88,613442.22,3890.34,719712.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','196',4305,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','196',4306,'16','1',406252.25,408666.55,2414.30,446645.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','196',4307,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','196',4308,'18','1',567304.53,574062.91,6758.38,1250300.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','196',4309,'19','1',323484.61,323511.87,27.26,5043.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','196',4310,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','196',4311,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','196',4312,'22','2',73902.65,74512.28,609.63,487704.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4313,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4314,'2','1',367157.90,370546.55,3388.65,626900.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4315,'3','1',454940.85,456980.45,2039.60,377326.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4316,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4317,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','197',4318,'6','1',509875.54,512843.88,2968.34,549142.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4319,'7','1',306559.04,308796.61,2237.57,413950.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4320,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4321,'9','1',589732.55,593547.06,3814.51,705684.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4322,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4323,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','197',4324,'12','1',268949.48,272306.02,3356.54,620959.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','197',4325,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','197',4326,'14','1',613442.22,613566.56,124.34,23002.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','197',4327,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','197',4328,'16','1',408666.55,408666.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','197',4329,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','197',4330,'18','1',574062.91,578212.80,4149.89,767729.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','197',4331,'19','1',323511.87,324985.30,1473.43,272584.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','197',4332,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','197',4333,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','197',4334,'22','2',74512.28,75955.15,1442.87,1154296.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4335,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4336,'2','1',370546.55,375415.14,4868.59,900689.15,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4337,'3','1',456980.45,460340.09,3359.64,621533.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4338,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4339,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','198',4340,'6','1',512843.88,516335.57,3491.69,645962.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4341,'7','1',308796.61,312473.60,3676.99,680243.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4342,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4343,'9','1',593547.06,598989.63,5442.57,1006875.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4344,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4345,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','198',4346,'12','1',272306.02,276925.33,4619.31,854572.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','198',4347,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','198',4348,'14','1',613566.56,614131.27,564.71,104471.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','198',4349,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','198',4350,'16','1',408666.55,408666.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','198',4351,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','198',4352,'18','1',578212.80,583181.17,4968.37,919148.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','198',4353,'19','1',324985.30,326660.92,1675.62,309989.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','198',4354,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','198',4355,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','198',4356,'22','2',75955.15,77811.56,1856.41,1540820.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4357,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4358,'2','1',375415.14,380014.38,4599.24,850859.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4359,'3','1',460340.09,463015.79,2675.70,495004.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4360,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4361,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','199',4362,'6','1',516335.57,518875.24,2539.67,469838.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4363,'7','1',312473.60,312570.34,96.74,17896.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4364,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4365,'9','1',598989.63,599798.35,808.72,149613.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4366,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4367,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','199',4368,'12','1',276925.33,276925.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','199',4369,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','199',4370,'14','1',614131.27,617311.60,3180.33,588361.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','199',4371,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','199',4372,'16','1',408666.55,412743.96,4077.41,754320.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','199',4373,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','199',4374,'18','1',583181.17,587208.32,4027.15,745022.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','199',4375,'19','1',326660.92,329943.22,3282.30,607225.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','199',4376,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','199',4377,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','199',4378,'22','2',77811.56,78222.52,410.96,341096.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4379,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4380,'2','1',380014.38,383710.79,3696.41,683835.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4381,'3','1',463015.79,463203.15,187.36,34661.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4382,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4383,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','200',4384,'6','1',518875.24,524374.95,5499.71,1017446.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4385,'7','1',312570.34,312994.42,424.08,78454.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4386,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4387,'9','1',599798.35,599798.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4388,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4389,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','200',4390,'12','1',276925.33,276925.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','200',4391,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','200',4392,'14','1',617311.60,622979.68,5668.08,1048594.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','200',4393,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','200',4394,'16','1',412743.96,419437.22,6693.26,1238253.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','200',4395,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','200',4396,'18','1',587208.32,594500.78,7292.46,1349105.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','200',4397,'19','1',329943.22,337238.75,7295.53,1349673.05,0.00,0.00,0.00,0.00,0.00),('5','271','4','200',4398,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','200',4399,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','200',4400,'22','2',78222.52,79974.55,1752.03,1454184.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4401,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4402,'2','1',383710.79,389337.91,5627.12,1041017.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4403,'3','1',463203.15,467972.41,4769.26,882313.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4404,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4405,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','201',4406,'6','1',524374.95,527754.54,3379.59,625224.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4407,'7','1',312994.42,316073.27,3078.85,569587.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4408,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4409,'9','1',599798.35,603412.18,3613.83,668558.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4410,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4411,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','201',4412,'12','1',276925.33,281181.11,4255.78,787319.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','201',4413,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','201',4414,'14','1',622979.68,626090.94,3111.26,575583.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','201',4415,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','201',4416,'16','1',419437.22,423424.68,3987.46,737680.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','201',4417,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','201',4418,'18','1',594500.78,601109.67,6608.89,1222644.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','201',4419,'19','1',337238.75,340590.50,3351.75,620073.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','201',4420,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','201',4421,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','201',4422,'22','2',79974.55,81196.11,1221.56,1013894.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4423,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4424,'2','1',389337.91,395831.68,6493.77,1201347.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4425,'3','1',467972.41,472008.72,4036.31,746717.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4426,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4427,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','202',4428,'6','1',527754.54,531220.21,3465.67,641148.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4429,'7','1',316073.27,321266.36,5193.09,960721.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4430,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4431,'9','1',603412.18,608071.10,4658.92,861900.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4432,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4433,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','202',4434,'12','1',281181.11,286582.37,5401.26,999233.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','202',4435,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','202',4436,'14','1',626090.94,630713.58,4622.64,855188.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','202',4437,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','202',4438,'16','1',423424.68,427488.67,4063.99,751838.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','202',4439,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','202',4440,'18','1',601109.67,607025.14,5915.47,1094361.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','202',4441,'19','1',340590.50,343256.58,2666.08,493224.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','202',4442,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','202',4443,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','202',4444,'22','2',81196.11,81957.98,761.87,632352.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4445,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4446,'2','1',395831.68,399481.41,3649.73,675200.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4447,'3','1',472008.72,475210.72,3202.00,592370.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4448,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4449,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','203',4450,'6','1',531220.21,534293.44,3073.23,568547.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4451,'7','1',321266.36,325002.13,3735.77,691117.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4452,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4453,'9','1',608071.10,612970.84,4899.74,906451.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4454,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4455,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','203',4456,'12','1',286582.37,291058.91,4476.54,828159.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','203',4457,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','203',4458,'14','1',630713.58,631870.94,1157.36,214111.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','203',4459,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','203',4460,'16','1',427488.67,427650.44,161.77,29927.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','203',4461,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','203',4462,'18','1',607025.14,612068.44,5043.30,933010.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','203',4463,'19','1',343256.58,347135.76,3879.18,717648.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','203',4464,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','203',4465,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','203',4466,'22','2',81957.98,82755.45,797.47,661900.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4467,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4468,'2','1',399481.41,403028.51,3547.10,656213.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4469,'3','1',475210.72,476368.59,1157.87,214205.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4470,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4471,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','204',4472,'6','1',534293.44,536685.67,2392.23,442562.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4473,'7','1',325002.13,327638.62,2636.49,487750.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4474,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4475,'9','1',612970.84,616453.21,3482.37,644238.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4476,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4477,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','204',4478,'12','1',291058.91,296329.17,5270.26,974998.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','204',4479,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','204',4480,'14','1',631870.94,633654.53,1783.59,329964.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','204',4481,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','204',4482,'16','1',427650.44,431244.29,3593.85,664862.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','204',4483,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','204',4484,'18','1',612068.44,615427.50,3359.06,621426.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','204',4485,'19','1',347135.76,350186.84,3051.08,564449.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','204',4486,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','204',4487,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','204',4488,'22','2',82755.45,83310.88,555.43,461006.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4489,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4490,'2','1',403028.51,404253.32,1224.81,226589.85,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4491,'3','1',476368.59,476368.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4492,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4493,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','205',4494,'6','1',536685.67,536685.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4495,'7','1',327638.62,332286.82,4648.20,859917.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4496,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4497,'9','1',616453.21,617811.63,1358.42,251307.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4498,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4499,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','205',4500,'12','1',296329.17,300822.88,4493.71,831336.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','205',4501,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','205',4502,'14','1',633654.53,638451.29,4796.76,887400.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','205',4503,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','205',4504,'16','1',431244.29,435649.04,4404.75,814878.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','205',4505,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','205',4506,'18','1',615427.50,617036.05,1608.55,297581.75,0.00,0.00,0.00,0.00,0.00),('5','271','4','205',4507,'19','1',350186.84,350186.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','205',4508,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','205',4509,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','205',4510,'22','2',83310.88,83519.50,208.62,173154.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4511,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4512,'2','1',404253.32,404638.27,384.95,71215.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4513,'3','1',476368.59,477517.50,1148.91,212548.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4514,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4515,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','206',4516,'6','1',536685.67,536685.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4517,'7','1',332286.82,335057.47,2770.65,512570.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4518,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4519,'9','1',617811.63,617947.84,136.21,25198.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4520,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4521,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','206',4522,'12','1',300822.88,304203.00,3380.12,625322.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','206',4523,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','206',4524,'14','1',638451.29,641801.97,3350.68,619875.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','206',4525,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','206',4526,'16','1',435649.04,438920.76,3271.72,605268.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','206',4527,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','206',4528,'18','1',617036.05,620056.21,3020.16,558729.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','206',4529,'19','1',350186.84,355255.50,5068.66,937702.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','206',4530,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','206',4531,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','206',4532,'22','2',83519.50,83566.37,46.87,38902.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4533,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4534,'2','1',404638.27,404638.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4535,'3','1',477517.50,477517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4536,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4537,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','207',4538,'6','1',536685.67,540098.98,3413.31,631462.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4539,'7','1',335057.47,337457.20,2399.73,443950.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4540,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4541,'9','1',617947.84,625055.10,7107.26,1314843.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4542,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4543,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','207',4544,'12','1',304203.00,308746.00,4543.00,840455.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','207',4545,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','207',4546,'14','1',641801.97,645965.83,4163.86,770314.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','207',4547,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','207',4548,'16','1',438920.76,442902.63,3981.87,736645.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','207',4549,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','207',4550,'18','1',620056.21,624766.05,4709.84,871320.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','207',4551,'19','1',355255.50,357401.49,2145.99,397008.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','207',4552,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','207',4553,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','207',4554,'22','2',83566.37,87632.15,4065.78,3374597.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4555,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4556,'2','1',404638.27,404638.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4557,'3','1',477517.50,479420.50,1903.00,352055.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4558,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4559,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','208',4560,'6','1',540098.98,542705.05,2606.07,482122.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4561,'7','1',337457.20,339711.21,2254.01,416991.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4562,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4563,'9','1',625055.10,632472.03,7416.93,1372132.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4564,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4565,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','208',4566,'12','1',308746.00,312595.79,3849.79,712211.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','208',4567,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','208',4568,'14','1',645965.83,648931.17,2965.34,548587.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','208',4569,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','208',4570,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','208',4571,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','208',4572,'18','1',624766.05,624766.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','208',4573,'19','1',357401.49,357401.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','208',4574,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','208',4575,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','208',4576,'22','2',87632.15,87854.21,222.06,184309.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4577,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4578,'2','1',404638.27,407488.32,2850.05,527259.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4579,'3','1',479420.50,481701.26,2280.76,421940.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4580,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4581,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','209',4582,'6','1',542705.05,545149.17,2444.12,452162.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4583,'7','1',339711.21,341985.74,2274.53,420788.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4584,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4585,'9','1',632472.03,635116.65,2644.62,489254.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4586,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4587,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','209',4588,'12','1',312595.79,317028.01,4432.22,819960.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','209',4589,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','209',4590,'14','1',648931.17,653273.74,4342.57,803375.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','209',4591,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','209',4592,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','209',4593,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','209',4594,'18','1',624766.05,629376.93,4610.88,853012.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','209',4595,'19','1',357401.49,359565.30,2163.81,400304.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','209',4596,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','209',4597,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','209',4598,'22','2',87854.21,88613.21,759.00,629970.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4599,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4600,'2','1',407488.32,407488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4601,'3','1',481701.26,484722.43,3021.17,558916.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4602,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4603,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','210',4604,'6','1',545149.17,546477.04,1327.87,245655.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4605,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4606,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4607,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4608,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4609,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','210',4610,'12','1',317028.01,319926.61,2898.60,536241.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','210',4611,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','210',4612,'14','1',653273.74,658136.74,4863.00,899655.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','210',4613,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','210',4614,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','210',4615,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','210',4616,'18','1',629376.93,634450.77,5073.84,938660.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','210',4617,'19','1',359565.30,362352.57,2787.27,515644.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','210',4618,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','210',4619,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','210',4620,'22','2',88613.21,90596.74,1983.53,1646329.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4621,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4622,'2','1',407488.32,407488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4623,'3','1',484722.43,484722.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4624,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4625,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','211',4626,'6','1',546477.04,547762.02,1284.98,237721.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4627,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4628,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4629,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4630,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4631,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','211',4632,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','211',4633,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','211',4634,'14','1',658136.74,659545.48,1408.74,260616.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','211',4635,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','211',4636,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','211',4637,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','211',4638,'18','1',634450.77,637309.36,2858.59,528839.15,0.00,0.00,0.00,0.00,0.00),('5','271','4','211',4639,'19','1',362352.57,362352.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','211',4640,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','211',4641,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','211',4642,'22','2',90596.74,91538.00,941.26,781245.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4643,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4644,'2','1',407488.32,407488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4645,'3','1',484722.43,484722.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4646,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4647,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','212',4648,'6','1',547762.02,549119.36,1357.34,251107.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4649,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4650,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4651,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4652,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4653,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','212',4654,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','212',4655,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','212',4656,'14','1',659545.48,661045.39,1499.91,277483.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','212',4657,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','212',4658,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','212',4659,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','212',4660,'18','1',637309.36,642275.22,4965.86,918684.10,0.00,0.00,0.00,0.00,0.00),('5','271','4','212',4661,'19','1',362352.57,362352.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','212',4662,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','212',4663,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','212',4664,'22','2',91538.00,92844.95,1306.95,1084768.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4665,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4666,'2','1',407488.32,407488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4667,'3','1',484722.43,484722.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4668,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4669,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','213',4670,'6','1',549119.36,549119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4671,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4672,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4673,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4674,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4675,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','213',4676,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','213',4677,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','213',4678,'14','1',661045.39,662355.16,1309.77,242307.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','213',4679,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','213',4680,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','213',4681,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','213',4682,'18','1',642275.22,646244.85,3969.63,734381.55,0.00,0.00,0.00,0.00,0.00),('5','271','4','213',4683,'19','1',362352.57,362352.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','213',4684,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','213',4685,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','213',4686,'22','2',92844.95,92948.07,103.12,89714.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4687,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4688,'2','1',407488.32,407488.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4689,'3','1',484722.43,484722.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4690,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4691,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','214',4692,'6','1',549119.36,550103.03,983.67,181978.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4693,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4694,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4695,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4696,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4697,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','214',4698,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','214',4699,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','214',4700,'14','1',662355.16,663647.25,1292.09,239036.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','214',4701,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','214',4702,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','214',4703,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','214',4704,'18','1',646244.85,650726.21,4481.36,829051.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','214',4705,'19','1',362352.57,362352.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','214',4706,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','214',4707,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','214',4708,'22','2',92948.07,93578.63,630.56,548587.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4709,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4710,'2','1',407488.32,408661.03,1172.71,216951.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4711,'3','1',484722.43,485896.53,1174.10,217208.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4712,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4713,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','215',4714,'6','1',550103.03,552509.68,2406.65,445230.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4715,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4716,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4717,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4718,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4719,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','215',4720,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','215',4721,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','215',4722,'14','1',663647.25,665183.32,1536.07,284172.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','215',4723,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','215',4724,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','215',4725,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','215',4726,'18','1',650726.21,653723.22,2997.01,554446.85,0.00,0.00,0.00,0.00,0.00),('5','271','4','215',4727,'19','1',362352.57,363466.99,1114.42,206167.70,0.00,0.00,0.00,0.00,0.00),('5','271','4','215',4728,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','215',4729,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','215',4730,'22','2',93578.63,94257.31,678.68,590451.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4731,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4732,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4733,'3','1',485896.53,485896.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4734,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4735,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','216',4736,'6','1',552509.68,553477.25,967.57,179000.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4737,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4738,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4739,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4740,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4741,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','216',4742,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','216',4743,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','216',4744,'14','1',665183.32,667217.88,2034.56,376393.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','216',4745,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','216',4746,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','216',4747,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','216',4748,'18','1',653723.22,657414.58,3691.36,682901.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','216',4749,'19','1',363466.99,363466.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','216',4750,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','216',4751,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','216',4752,'22','2',94257.31,95606.96,1349.65,1174195.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4753,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4754,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4755,'3','1',485896.53,485896.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4756,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4757,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','217',4758,'6','1',553477.25,555138.69,1661.44,307366.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4759,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4760,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4761,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4762,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4763,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','217',4764,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','217',4765,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','217',4766,'14','1',667217.88,667217.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','217',4767,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','217',4768,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','217',4769,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','217',4770,'18','1',657414.58,657414.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','217',4771,'19','1',363466.99,363466.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','217',4772,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','217',4773,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','217',4774,'22','2',95606.96,95624.24,17.28,15033.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4775,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4776,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4777,'3','1',485896.53,485896.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4778,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4779,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','218',4780,'6','1',555138.69,562126.20,6987.51,1292689.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4781,'7','1',341985.74,341985.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4782,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4783,'9','1',635116.65,635116.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4784,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4785,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','218',4786,'12','1',319926.61,319926.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','218',4787,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','218',4788,'14','1',667217.88,671600.94,4383.06,810866.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','218',4789,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','218',4790,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','218',4791,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','218',4792,'18','1',657414.58,657414.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','218',4793,'19','1',363466.99,363466.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','218',4794,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','218',4795,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','218',4796,'22','2',95624.24,96337.44,713.20,620484.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4797,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4798,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4799,'3','1',485896.53,486311.76,415.23,76817.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4800,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4801,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','219',4802,'6','1',562126.20,562655.15,528.95,97855.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4803,'7','1',341985.74,344430.92,2445.18,452358.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4804,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4805,'9','1',635116.65,638664.91,3548.26,656428.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4806,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4807,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','219',4808,'12','1',319926.61,324690.72,4764.11,881360.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','219',4809,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','219',4810,'14','1',671600.94,676570.47,4969.53,919363.05,0.00,0.00,0.00,0.00,0.00),('5','271','3','219',4811,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','219',4812,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','219',4813,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','219',4814,'18','1',657414.58,663727.25,6312.67,1167843.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','219',4815,'19','1',363466.99,367500.37,4033.38,746175.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','219',4816,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','219',4817,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','219',4818,'22','2',96337.44,97480.16,1142.72,994166.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4819,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4820,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4821,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4822,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4823,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','220',4824,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4825,'7','1',344430.92,347509.65,3078.73,569565.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4826,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4827,'9','1',638664.91,641949.82,3284.91,607708.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4828,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4829,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','220',4830,'12','1',324690.72,328112.78,3422.06,633081.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','220',4831,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','220',4832,'14','1',676570.47,679910.56,3340.09,617916.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','220',4833,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','220',4834,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','220',4835,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','220',4836,'18','1',663727.25,669128.54,5401.29,999238.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','220',4837,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','220',4838,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','220',4839,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','220',4840,'22','2',97480.16,98042.77,562.61,489470.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4841,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4842,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4843,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4844,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4845,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','221',4846,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4847,'7','1',347509.65,350519.22,3009.57,556770.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4848,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4849,'9','1',641949.82,648219.30,6269.48,1159853.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4850,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4851,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','221',4852,'12','1',328112.78,331382.30,3269.52,604861.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','221',4853,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','221',4854,'14','1',679910.56,682891.28,2980.72,551433.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','221',4855,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','221',4856,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','221',4857,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','221',4858,'18','1',669128.54,670166.79,1038.25,192076.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','221',4859,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','221',4860,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','221',4861,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','221',4862,'22','2',98042.77,98800.55,757.78,659268.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4863,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4864,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4865,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4866,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4867,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','222',4868,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4869,'7','1',350519.22,353665.80,3146.58,582117.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4870,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4871,'9','1',648219.30,653173.31,4954.01,916491.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4872,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4873,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','222',4874,'12','1',331382.30,335364.62,3982.32,736729.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','222',4875,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','222',4876,'14','1',682891.28,686114.63,3223.35,596319.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','222',4877,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','222',4878,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','222',4879,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','222',4880,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','222',4881,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','222',4882,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','222',4883,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','222',4884,'22','2',98800.55,99846.21,1045.66,909724.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4885,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4886,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4887,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4888,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4889,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','223',4890,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4891,'7','1',353665.80,355477.88,1812.08,335234.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4892,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4893,'9','1',653173.31,654727.33,1554.02,287493.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4894,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4895,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','223',4896,'12','1',335364.62,336980.85,1616.23,299002.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','223',4897,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','223',4898,'14','1',686114.63,693308.29,7193.66,1330827.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','223',4899,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','223',4900,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','223',4901,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','223',4902,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','223',4903,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','223',4904,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','223',4905,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','223',4906,'22','2',99846.21,101079.94,1233.73,1073345.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4907,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4908,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4909,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4910,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4911,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','224',4912,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4913,'7','1',355477.88,355477.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4914,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4915,'9','1',654727.33,654727.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4916,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4917,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','224',4918,'12','1',336980.85,336980.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','224',4919,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','224',4920,'14','1',693308.29,696121.52,2813.23,520447.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','224',4921,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','224',4922,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','224',4923,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','224',4924,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','224',4925,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','224',4926,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','224',4927,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','224',4928,'22','2',101079.94,101853.62,773.68,673101.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4929,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4930,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4931,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4932,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4933,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','225',4934,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4935,'7','1',355477.88,359225.94,3748.06,693391.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4936,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4937,'9','1',654727.33,661454.86,6727.53,1244593.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4938,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4939,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','225',4940,'12','1',336980.85,341109.91,4129.06,763876.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','225',4941,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','225',4942,'14','1',696121.52,699357.76,3236.24,598704.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','225',4943,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','225',4944,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','225',4945,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','225',4946,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','225',4947,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','225',4948,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','225',4949,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','225',4950,'22','2',101853.62,102781.39,927.77,807159.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4951,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4952,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4953,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4954,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4955,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','226',4956,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4957,'7','1',359225.94,362061.03,2835.09,524491.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4958,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4959,'9','1',661454.86,667131.85,5676.99,1050243.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4960,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4961,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','226',4962,'12','1',341109.91,343881.93,2772.02,512823.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','226',4963,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','226',4964,'14','1',699357.76,701814.14,2456.38,454430.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','226',4965,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','226',4966,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','226',4967,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','226',4968,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','226',4969,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','226',4970,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','226',4971,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','226',4972,'22','2',102781.39,102937.84,156.45,136111.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4973,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4974,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4975,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4976,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4977,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','227',4978,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4979,'7','1',362061.03,362061.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4980,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4981,'9','1',667131.85,672275.92,5144.07,951652.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4982,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4983,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','227',4984,'12','1',343881.93,343881.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','227',4985,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','227',4986,'14','1',701814.14,701814.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','227',4987,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','227',4988,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','227',4989,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','227',4990,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','227',4991,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','227',4992,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','227',4993,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','227',4994,'22','2',102937.84,107315.80,4377.96,3808825.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',4995,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',4996,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',4997,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',4998,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',4999,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','228',5000,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5001,'7','1',362061.03,367273.12,5212.09,964236.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5002,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5003,'9','1',672275.92,676739.71,4463.79,825801.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5004,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5005,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','228',5006,'12','1',343881.93,348125.56,4243.63,785071.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','228',5007,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','228',5008,'14','1',701814.14,702952.90,1138.76,210670.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','228',5009,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','228',5010,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','228',5011,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','228',5012,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','228',5013,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','228',5014,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','228',5015,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','228',5016,'22','2',107315.80,108169.77,853.97,742953.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5017,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5018,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5019,'3','1',486311.76,486311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5020,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5021,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','229',5022,'6','1',562655.15,562655.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5023,'7','1',367273.12,374160.95,6887.83,1274248.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5024,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5025,'9','1',676739.71,685782.69,9042.98,1672951.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5026,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5027,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','229',5028,'12','1',348125.56,353922.85,5797.29,1072498.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','229',5029,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','229',5030,'14','1',702952.90,702952.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','229',5031,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','229',5032,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','229',5033,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','229',5034,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','229',5035,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','229',5036,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','229',5037,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','229',5038,'22','2',108169.77,110717.08,2547.31,2216159.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5039,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5040,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5041,'3','1',486311.76,490903.65,4591.89,849499.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5042,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5043,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','230',5044,'6','1',562655.15,569325.26,6670.11,1233970.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5045,'7','1',374160.95,374311.11,150.16,27779.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5046,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5047,'9','1',685782.69,689989.68,4206.99,778293.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5048,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5049,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','230',5050,'12','1',353922.85,359229.52,5306.67,981733.95,0.00,0.00,0.00,0.00,0.00),('5','271','3','230',5051,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','230',5052,'14','1',702952.90,702952.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','230',5053,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','230',5054,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','230',5055,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','230',5056,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','230',5057,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','230',5058,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','230',5059,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','230',5060,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5061,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5062,'2','1',408661.03,408661.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5063,'3','1',490903.65,492487.07,1583.42,292932.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5064,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5065,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','231',5066,'6','1',569325.26,571334.45,2009.19,371700.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5067,'7','1',374311.11,374311.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5068,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5069,'9','1',689989.68,689989.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5070,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5071,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','231',5072,'12','1',359229.52,359229.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','231',5073,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','231',5074,'14','1',702952.90,702952.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','231',5075,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','231',5076,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','231',5077,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','231',5078,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','231',5079,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','231',5080,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','231',5081,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','231',5082,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5083,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5084,'2','1',408661.03,412621.39,3960.36,732666.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5085,'3','1',492487.07,496573.44,4086.37,755978.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5086,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5087,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','232',5088,'6','1',571334.45,577164.61,5830.16,1078579.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5089,'7','1',374311.11,376104.26,1793.15,331732.75,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5090,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5091,'9','1',689989.68,693739.94,3750.26,693798.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5092,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5093,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','232',5094,'12','1',359229.52,359537.11,307.59,56904.15,0.00,0.00,0.00,0.00,0.00),('5','271','3','232',5095,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','232',5096,'14','1',702952.90,702952.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','232',5097,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','232',5098,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','232',5099,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','232',5100,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','232',5101,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','232',5102,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','232',5103,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','232',5104,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5105,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5106,'2','1',412621.39,412621.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5107,'3','1',496573.44,498860.12,2286.68,423035.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5108,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5109,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','233',5110,'6','1',577164.61,583283.57,6118.96,1132007.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5111,'7','1',376104.26,379524.10,3419.84,632670.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5112,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5113,'9','1',693739.94,698169.91,4429.97,819544.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5114,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5115,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','233',5116,'12','1',359537.11,363979.66,4442.55,821871.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','233',5117,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','233',5118,'14','1',702952.90,709822.85,6869.95,1270940.75,0.00,0.00,0.00,0.00,0.00),('5','271','3','233',5119,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','233',5120,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','233',5121,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','233',5122,'18','1',670166.79,670166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','233',5123,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','233',5124,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','233',5125,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','233',5126,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5127,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5128,'2','1',412621.39,412621.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5129,'3','1',498860.12,498860.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5130,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5131,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','234',5132,'6','1',583283.57,588744.10,5460.53,1010198.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5133,'7','1',379524.10,379524.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5134,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5135,'9','1',698169.91,704197.13,6027.22,1115035.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5136,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5137,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','234',5138,'12','1',363979.66,368307.31,4327.65,800615.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','234',5139,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','234',5140,'14','1',709822.85,715415.91,5593.06,1034716.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','234',5141,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','234',5142,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','234',5143,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','234',5144,'18','1',670166.79,677773.11,7606.32,1407169.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','234',5145,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','234',5146,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','234',5147,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','234',5148,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5149,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5150,'2','1',412621.39,412621.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5151,'3','1',498860.12,498860.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5152,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5153,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','235',5154,'6','1',588744.10,594411.92,5667.82,1048546.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5155,'7','1',379524.10,379524.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5156,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5157,'9','1',704197.13,710021.12,5823.99,1077438.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5158,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5159,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','235',5160,'12','1',368307.31,372850.22,4542.91,840438.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','235',5161,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','235',5162,'14','1',715415.91,720546.39,5130.48,949138.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','235',5163,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','235',5164,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','235',5165,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','235',5166,'18','1',677773.11,686211.98,8438.87,1561190.95,0.00,0.00,0.00,0.00,0.00),('5','271','4','235',5167,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','235',5168,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','235',5169,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','235',5170,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5171,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5172,'2','1',412621.39,415097.77,2476.38,458130.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5173,'3','1',498860.12,500582.38,1722.26,318618.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5174,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5175,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','236',5176,'6','1',594411.92,594411.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5177,'7','1',379524.10,382612.98,3088.88,571442.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5178,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5179,'9','1',710021.12,719111.24,9090.12,1681672.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5180,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5181,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','236',5182,'12','1',372850.22,380616.14,7765.92,1436695.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','236',5183,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','236',5184,'14','1',720546.39,723841.01,3294.62,609504.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','236',5185,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','236',5186,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','236',5187,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','236',5188,'18','1',686211.98,690241.01,4029.03,745370.92,0.00,0.00,0.00,0.00,0.00),('5','271','4','236',5189,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','236',5190,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','236',5191,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','236',5192,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5193,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5194,'2','1',415097.77,421181.69,6083.92,1125525.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5195,'3','1',500582.38,500884.68,302.30,55925.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5196,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5197,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','237',5198,'6','1',594411.92,600861.70,6449.78,1193209.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5199,'7','1',382612.98,382612.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5200,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5201,'9','1',719111.24,719138.26,27.02,4998.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5202,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5203,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','237',5204,'12','1',380616.14,385200.64,4584.50,848132.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','237',5205,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','237',5206,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','237',5207,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','237',5208,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','237',5209,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','237',5210,'18','1',690241.01,699988.13,9747.12,1803217.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','237',5211,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','237',5212,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','237',5213,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','237',5214,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5215,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5216,'2','1',421181.69,424283.77,3102.08,573884.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5217,'3','1',500884.68,502330.25,1445.57,267430.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5218,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5219,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','238',5220,'6','1',600861.70,602880.88,2019.18,373548.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5221,'7','1',382612.98,382612.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5222,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5223,'9','1',719138.26,721771.24,2632.98,487101.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5224,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5225,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','238',5226,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','238',5227,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','238',5228,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','238',5229,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','238',5230,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','238',5231,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','238',5232,'18','1',699988.13,700130.50,142.37,26338.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','238',5233,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','238',5234,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','238',5235,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','238',5236,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5237,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5238,'2','1',424283.77,431356.45,7072.68,1308445.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5239,'3','1',502330.25,502330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5240,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5241,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','239',5242,'6','1',602880.88,606895.35,4014.47,742676.95,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5243,'7','1',382612.98,382612.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5244,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5245,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5246,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5247,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','239',5248,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','239',5249,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','239',5250,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','239',5251,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','239',5252,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','239',5253,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','239',5254,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','239',5255,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','239',5256,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','239',5257,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','239',5258,'22','2',110717.08,110717.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5259,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5260,'2','1',431356.45,431356.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5261,'3','1',502330.25,502361.59,31.34,5797.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5262,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5263,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','240',5264,'6','1',606895.35,608668.77,1773.42,328082.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5265,'7','1',382612.98,383046.09,433.11,80125.35,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5266,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5267,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5268,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5269,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','240',5270,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','240',5271,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','240',5272,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','240',5273,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','240',5274,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','240',5275,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','240',5276,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','240',5277,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','240',5278,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','240',5279,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','240',5280,'22','2',110717.08,110727.24,10.16,8991.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5281,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5282,'2','1',431356.45,431482.48,126.03,23315.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5283,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5284,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5285,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','241',5286,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5287,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5288,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5289,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5290,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5291,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','241',5292,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','241',5293,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','241',5294,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','241',5295,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','241',5296,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','241',5297,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','241',5298,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','241',5299,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','241',5300,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','241',5301,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','241',5302,'22','2',110727.24,110727.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5303,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5304,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5305,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5306,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5307,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','242',5308,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5309,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5310,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5311,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5312,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5313,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','242',5314,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','242',5315,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','242',5316,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','242',5317,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','242',5318,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','242',5319,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','242',5320,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','242',5321,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','242',5322,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','242',5323,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','242',5324,'22','2',110727.24,110727.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5325,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5326,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5327,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5328,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5329,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','243',5330,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5331,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5332,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5333,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5334,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5335,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','243',5336,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','243',5337,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','243',5338,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','243',5339,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','243',5340,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','243',5341,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','243',5342,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','243',5343,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','243',5344,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','243',5345,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','243',5346,'22','2',110727.24,110776.69,49.45,43763.25,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5347,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5348,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5349,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5350,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5351,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','244',5352,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5353,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5354,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5355,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5356,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5357,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','244',5358,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','244',5359,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','244',5360,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','244',5361,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','244',5362,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','244',5363,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','244',5364,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','244',5365,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','244',5366,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','244',5367,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','244',5368,'22','2',110776.69,112193.93,1417.24,1254257.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5369,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5370,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5371,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5372,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5373,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','245',5374,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5375,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5376,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5377,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5378,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5379,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','245',5380,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','245',5381,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','245',5382,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','245',5383,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','245',5384,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','245',5385,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','245',5386,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','245',5387,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','245',5388,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','245',5389,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','245',5390,'22','2',112193.93,112256.61,62.68,55471.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5391,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5392,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5393,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5394,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5395,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','246',5396,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5397,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5398,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5399,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5400,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5401,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','246',5402,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','246',5403,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','246',5404,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','246',5405,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','246',5406,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','246',5407,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','246',5408,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','246',5409,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','246',5410,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','246',5411,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','246',5412,'22','2',112256.61,112256.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5413,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5414,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5415,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5416,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5417,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','247',5418,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5419,'7','1',383046.09,383046.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5420,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5421,'9','1',721771.24,721771.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5422,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5423,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','247',5424,'12','1',385200.64,385200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','247',5425,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','247',5426,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','247',5427,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','247',5428,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','247',5429,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','247',5430,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','247',5431,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','247',5432,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','247',5433,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','247',5434,'22','2',112256.61,112772.28,515.67,456367.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5435,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5436,'2','1',431482.48,431482.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5437,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5438,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5439,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','248',5440,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5441,'7','1',383046.09,390205.30,7159.21,1324453.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5442,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5443,'9','1',721771.24,731024.20,9252.96,1711797.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5444,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5445,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','248',5446,'12','1',385200.64,390544.40,5343.76,988595.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','248',5447,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','248',5448,'14','1',723841.01,723841.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','248',5449,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','248',5450,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','248',5451,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','248',5452,'18','1',700130.50,700130.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','248',5453,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','248',5454,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','248',5455,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','248',5456,'22','2',112772.28,113772.66,1000.38,885336.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5457,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5458,'2','1',431482.48,431493.28,10.80,1998.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5459,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5460,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5461,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','249',5462,'6','1',608668.77,608668.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5463,'7','1',390205.30,392179.07,1973.77,365147.45,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5464,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5465,'9','1',731024.20,737443.41,6419.21,1187553.85,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5466,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5467,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','249',5468,'12','1',390544.40,395310.65,4766.25,881756.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','249',5469,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','249',5470,'14','1',723841.01,729790.26,5949.25,1100611.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','249',5471,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','249',5472,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','249',5473,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','249',5474,'18','1',700130.50,704937.26,4806.76,889250.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','249',5475,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','249',5476,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','249',5477,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','249',5478,'22','2',113772.66,114182.61,409.95,362805.75,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5479,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5480,'2','1',431493.28,432413.11,919.83,170168.55,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5481,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5482,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5483,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','250',5484,'6','1',608668.77,613195.46,4526.69,837437.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5485,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5486,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5487,'9','1',737443.41,744132.19,6688.78,1237424.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5488,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5489,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','250',5490,'12','1',395310.65,398577.59,3266.94,604383.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','250',5491,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','250',5492,'14','1',729790.26,734260.97,4470.71,827081.35,0.00,0.00,0.00,0.00,0.00),('5','271','3','250',5493,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','250',5494,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','250',5495,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','250',5496,'18','1',704937.26,710196.63,5259.37,972983.45,0.00,0.00,0.00,0.00,0.00),('5','271','4','250',5497,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','250',5498,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','250',5499,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','250',5500,'22','2',114182.61,114586.85,404.24,357752.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5501,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5502,'2','1',432413.11,433335.55,922.44,170651.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5503,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5504,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5505,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','251',5506,'6','1',613195.46,617613.12,4417.66,817267.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5507,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5508,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5509,'9','1',744132.19,750368.68,6236.49,1153750.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5510,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5511,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','251',5512,'12','1',398577.59,401679.76,3102.17,573901.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','251',5513,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','251',5514,'14','1',734260.97,738536.37,4275.40,790949.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','251',5515,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','251',5516,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','251',5517,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','251',5518,'18','1',710196.63,719242.12,9045.49,1673415.65,0.00,0.00,0.00,0.00,0.00),('5','271','4','251',5519,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','251',5520,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','251',5521,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','251',5522,'22','2',114586.85,115232.05,645.20,571002.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5523,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5524,'2','1',433335.55,435896.29,2560.74,473736.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5525,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5526,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5527,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','252',5528,'6','1',617613.12,622401.81,4788.69,885907.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5529,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5530,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5531,'9','1',750368.68,754910.36,4541.68,840210.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5532,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5533,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','252',5534,'12','1',401679.76,406402.68,4722.92,873740.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','252',5535,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','252',5536,'14','1',738536.37,743034.02,4497.65,832065.25,0.00,0.00,0.00,0.00,0.00),('5','271','3','252',5537,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','252',5538,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','252',5539,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','252',5540,'18','1',719242.12,726989.92,7747.80,1433343.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','252',5541,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','252',5542,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','252',5543,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','252',5544,'22','2',115232.05,115969.36,737.31,652519.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5545,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5546,'2','1',435896.29,435896.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5547,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5548,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5549,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','253',5550,'6','1',622401.81,625049.70,2647.89,489859.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5551,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5552,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5553,'9','1',754910.36,762140.52,7230.16,1337579.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5554,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5555,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','253',5556,'12','1',406402.68,406847.89,445.21,82363.85,0.00,0.00,0.00,0.00,0.00),('5','271','3','253',5557,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','253',5558,'14','1',743034.02,745302.54,2268.52,419676.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','253',5559,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','253',5560,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','253',5561,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','253',5562,'18','1',726989.92,729257.77,2267.85,419552.25,0.00,0.00,0.00,0.00,0.00),('5','271','4','253',5563,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','253',5564,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','253',5565,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','253',5566,'22','2',115969.36,116506.22,536.86,475121.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5567,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5568,'2','1',435896.29,439003.11,3106.82,574761.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5569,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5570,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5571,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','254',5572,'6','1',625049.70,628158.84,3109.14,575190.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5573,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5574,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5575,'9','1',762140.52,767710.46,5569.94,1030438.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5576,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5577,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','254',5578,'12','1',406847.89,408157.58,1309.69,242292.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','254',5579,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','254',5580,'14','1',745302.54,747735.58,2433.04,450112.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','254',5581,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','254',5582,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','254',5583,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','254',5584,'18','1',729257.77,729817.85,560.08,103614.80,0.00,0.00,0.00,0.00,0.00),('5','271','4','254',5585,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','254',5586,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','254',5587,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','254',5588,'22','2',116506.22,116611.11,104.89,92827.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5589,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5590,'2','1',439003.11,439003.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5591,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5592,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5593,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','255',5594,'6','1',628158.84,628158.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5595,'7','1',392179.07,392179.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5596,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5597,'9','1',767710.46,767710.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5598,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5599,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','255',5600,'12','1',408157.58,414106.62,5949.04,1100572.96,0.00,0.00,0.00,0.00,0.00),('5','271','3','255',5601,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','255',5602,'14','1',747735.58,747735.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','255',5603,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','255',5604,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','255',5605,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','255',5606,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','255',5607,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','255',5608,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','255',5609,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','255',5610,'22','2',116611.11,116739.29,128.18,113439.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5611,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5612,'2','1',439003.11,441878.23,2875.12,531897.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5613,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5614,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5615,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','256',5616,'6','1',628158.84,630136.10,1977.26,365793.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5617,'7','1',392179.07,395130.12,2951.05,545944.25,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5618,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5619,'9','1',767710.46,771133.55,3423.09,633271.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5620,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5621,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','256',5622,'12','1',414106.62,418623.38,4516.76,835600.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','256',5623,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','256',5624,'14','1',747735.58,750397.16,2661.58,492392.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','256',5625,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','256',5626,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','256',5627,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','256',5628,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','256',5629,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','256',5630,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','256',5631,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','256',5632,'22','2',116739.29,117162.02,422.73,374116.05,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5633,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5634,'2','1',441878.23,441878.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5635,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5636,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5637,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','257',5638,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5639,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5640,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5641,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5642,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5643,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','257',5644,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','257',5645,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','257',5646,'14','1',750397.16,753652.25,3255.09,602191.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','257',5647,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','257',5648,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','257',5649,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','257',5650,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','257',5651,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','257',5652,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','257',5653,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','257',5654,'22','2',117162.02,117878.90,716.88,634438.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5655,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5656,'2','1',441878.23,443306.74,1428.51,264274.35,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5657,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5658,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5659,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','258',5660,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5661,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5662,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5663,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5664,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5665,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','258',5666,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','258',5667,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','258',5668,'14','1',753652.25,753896.34,244.09,45156.65,0.00,0.00,0.00,0.00,0.00),('5','271','3','258',5669,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','258',5670,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','258',5671,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','258',5672,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','258',5673,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','258',5674,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','258',5675,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','258',5676,'22','2',117878.90,117878.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5677,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5678,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5679,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5680,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5681,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','259',5682,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5683,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5684,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5685,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5686,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5687,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','259',5688,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','259',5689,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','259',5690,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','259',5691,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','259',5692,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','259',5693,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','259',5694,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','259',5695,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','259',5696,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','259',5697,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','259',5698,'22','2',117878.90,118229.77,350.87,310519.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5699,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5700,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5701,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5702,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5703,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','260',5704,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5705,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5706,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5707,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5708,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5709,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','260',5710,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','260',5711,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','260',5712,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','260',5713,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','260',5714,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','260',5715,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','260',5716,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','260',5717,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','260',5718,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','260',5719,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','260',5720,'22','2',118229.77,118229.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5721,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5722,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5723,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5724,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5725,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','261',5726,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5727,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5728,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5729,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5730,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5731,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','261',5732,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','261',5733,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','261',5734,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','261',5735,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','261',5736,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','261',5737,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','261',5738,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','261',5739,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','261',5740,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','261',5741,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','261',5742,'22','2',118229.77,118526.46,296.69,262570.65,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5743,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5744,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5745,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5746,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5747,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','262',5748,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5749,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5750,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5751,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5752,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5753,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','262',5754,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','262',5755,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','262',5756,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','262',5757,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','262',5758,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','262',5759,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','262',5760,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','262',5761,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','262',5762,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','262',5763,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','262',5764,'22','2',118526.46,118526.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5765,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5766,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5767,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5768,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5769,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','263',5770,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5771,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5772,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5773,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5774,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5775,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','263',5776,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','263',5777,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','263',5778,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','263',5779,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','263',5780,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','263',5781,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','263',5782,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','263',5783,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','263',5784,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','263',5785,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','263',5786,'22','2',118526.46,118526.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5787,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5788,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5789,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5790,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5791,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','264',5792,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5793,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5794,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5795,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5796,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5797,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','264',5798,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','264',5799,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','264',5800,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','264',5801,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','264',5802,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','264',5803,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','264',5804,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','264',5805,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','264',5806,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','264',5807,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','264',5808,'22','2',118526.46,118765.87,239.41,205892.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5809,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5810,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5811,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5812,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5813,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','265',5814,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5815,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5816,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5817,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5818,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5819,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','265',5820,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','265',5821,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','265',5822,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','265',5823,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','265',5824,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','265',5825,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','265',5826,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','265',5827,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','265',5828,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','265',5829,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','265',5830,'22','2',118765.87,119614.92,849.05,730183.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5831,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5832,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5833,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5834,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5835,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','266',5836,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5837,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5838,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5839,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5840,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5841,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','266',5842,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','266',5843,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','266',5844,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','266',5845,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','266',5846,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','266',5847,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','266',5848,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','266',5849,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','266',5850,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','266',5851,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','266',5852,'22','2',119614.92,119614.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5853,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5854,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5855,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5856,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5857,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','267',5858,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5859,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5860,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5861,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5862,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5863,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','267',5864,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','267',5865,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','267',5866,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','267',5867,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','267',5868,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','267',5869,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','267',5870,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','267',5871,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','267',5872,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','267',5873,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','267',5874,'22','2',119614.92,119885.92,271.00,233060.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5875,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5876,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5877,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5878,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5879,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','268',5880,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5881,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5882,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5883,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5884,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5885,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','268',5886,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','268',5887,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','268',5888,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','268',5889,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','268',5890,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','268',5891,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','268',5892,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','268',5893,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','268',5894,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','268',5895,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','268',5896,'22','2',119885.92,121427.56,1541.64,1325810.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5897,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5898,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5899,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5900,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5901,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','269',5902,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5903,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5904,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5905,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5906,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5907,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','269',5908,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','269',5909,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','269',5910,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','269',5911,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','269',5912,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','269',5913,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','269',5914,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','269',5915,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','269',5916,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','269',5917,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','269',5918,'22','2',121427.56,121902.03,474.47,408044.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5919,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5920,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5921,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5922,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5923,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','270',5924,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5925,'7','1',395130.12,395130.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5926,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5927,'9','1',771133.55,771133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5928,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5929,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','270',5930,'12','1',418623.38,418623.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','270',5931,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','270',5932,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','270',5933,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','270',5934,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','270',5935,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','270',5936,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','270',5937,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','270',5938,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','270',5939,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','270',5940,'22','2',121902.03,121902.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5941,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5942,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5943,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5944,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5945,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','271',5946,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5947,'7','1',395130.12,404436.08,9305.96,1721602.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5948,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5949,'9','1',771133.55,782436.83,11303.28,2091106.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5950,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5951,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','271',5952,'12','1',418623.38,429300.81,10677.43,1975324.55,0.00,0.00,0.00,0.00,0.00),('5','271','3','271',5953,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','271',5954,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','271',5955,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','271',5956,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','271',5957,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','271',5958,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','271',5959,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','271',5960,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','271',5961,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','271',5962,'22','2',121902.03,122244.29,342.26,294343.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5963,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5964,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5965,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5966,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5967,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','272',5968,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5969,'7','1',404436.08,408836.71,4400.63,814116.55,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5970,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5971,'9','1',782436.83,787654.13,5217.30,965200.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5972,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5973,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','272',5974,'12','1',429300.81,433188.18,3887.37,719163.45,0.00,0.00,0.00,0.00,0.00),('5','271','3','272',5975,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','272',5976,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','272',5977,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','272',5978,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','272',5979,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','272',5980,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','272',5981,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','272',5982,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','272',5983,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','272',5984,'22','2',122244.29,122398.66,154.37,132758.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5985,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5986,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5987,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5988,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5989,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','273',5990,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5991,'7','1',408836.71,408836.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5992,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5993,'9','1',787654.13,787654.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5994,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5995,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','273',5996,'12','1',433188.18,433188.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','273',5997,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','273',5998,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','273',5999,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','273',6000,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','273',6001,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','273',6002,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','273',6003,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','273',6004,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','273',6005,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','273',6006,'22','2',122398.66,122398.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6007,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6008,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6009,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6010,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6011,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','274',6012,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6013,'7','1',408836.71,408836.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6014,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6015,'9','1',787654.13,787654.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6016,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6017,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','274',6018,'12','1',433188.18,433188.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','274',6019,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','274',6020,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','274',6021,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','274',6022,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','274',6023,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','274',6024,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','274',6025,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','274',6026,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','274',6027,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','274',6028,'22','2',122398.66,122484.94,86.28,74200.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6029,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6030,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6031,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6032,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6033,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','275',6034,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6035,'7','1',408836.71,408836.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6036,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6037,'9','1',787654.13,787654.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6038,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6039,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','275',6040,'12','1',433188.18,433188.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','275',6041,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','275',6042,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','275',6043,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','275',6044,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','275',6045,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','275',6046,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','275',6047,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','275',6048,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','275',6049,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','275',6050,'22','2',122484.94,123064.91,579.97,481375.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6051,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6052,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6053,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6054,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6055,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','276',6056,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6057,'7','1',408836.71,408836.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6058,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6059,'9','1',787654.13,787654.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6060,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6061,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','276',6062,'12','1',433188.18,433188.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','276',6063,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','276',6064,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','276',6065,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','276',6066,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','276',6067,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','276',6068,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','276',6069,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','276',6070,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','276',6071,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','276',6072,'22','2',123064.91,123064.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6073,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6074,'2','1',443306.74,443306.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6075,'3','1',502361.59,502361.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6076,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6077,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','277',6078,'6','1',630136.10,630136.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6079,'7','1',408836.71,413944.00,5107.29,944848.65,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6080,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6081,'9','1',787654.13,794724.26,7070.13,1307974.05,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6082,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6083,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','277',6084,'12','1',433188.18,437848.38,4660.20,862137.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','277',6085,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','277',6086,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','277',6087,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','277',6088,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','277',6089,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','277',6090,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','277',6091,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','277',6092,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','277',6093,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','277',6094,'22','2',123064.91,123673.00,608.09,504714.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6095,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6096,'2','1',443306.74,449576.32,6269.58,1159872.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6097,'3','1',502361.59,502378.35,16.76,3100.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6098,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6099,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','278',6100,'6','1',630136.10,635803.86,5667.76,1048535.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6101,'7','1',413944.00,414025.00,81.00,14985.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6102,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6103,'9','1',794724.26,804610.25,9885.99,1828908.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6104,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6105,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','278',6106,'12','1',437848.38,440344.64,2496.26,461808.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','278',6107,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','278',6108,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','278',6109,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','278',6110,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','278',6111,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','278',6112,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','278',6113,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','278',6114,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','278',6115,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','278',6116,'22','2',123673.00,124451.42,778.42,646088.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6117,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6118,'2','1',449576.32,454881.99,5305.67,981548.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6119,'3','1',502378.35,506820.59,4442.24,821814.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6120,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6121,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','279',6122,'6','1',635803.86,641999.05,6195.19,1146110.15,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6123,'7','1',414025.00,414229.82,204.82,37891.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6124,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6125,'9','1',804610.25,804610.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6126,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6127,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','279',6128,'12','1',440344.64,440663.24,318.60,58941.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','279',6129,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','279',6130,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','279',6131,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','279',6132,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','279',6133,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','279',6134,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','279',6135,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','279',6136,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','279',6137,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','279',6138,'22','2',124451.42,125034.52,583.10,483973.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6139,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6140,'2','1',454881.99,459128.56,4246.57,785615.45,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6141,'3','1',506820.59,510580.06,3759.47,695501.95,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6142,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6143,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','280',6144,'6','1',641999.05,647744.11,5745.06,1062836.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6145,'7','1',414229.82,414229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6146,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6147,'9','1',804610.25,804610.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6148,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6149,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','280',6150,'12','1',440663.24,440663.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','280',6151,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','280',6152,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','280',6153,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','280',6154,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','280',6155,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','280',6156,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','280',6157,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','280',6158,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','280',6159,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','280',6160,'22','2',125034.52,125181.83,147.31,122267.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6161,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6162,'2','1',459128.56,459128.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6163,'3','1',510580.06,510580.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6164,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6165,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','281',6166,'6','1',647744.11,648693.77,949.66,175687.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6167,'7','1',414229.82,414229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6168,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6169,'9','1',804610.25,804610.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6170,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6171,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','281',6172,'12','1',440663.24,440663.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','281',6173,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','281',6174,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','281',6175,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','281',6176,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','281',6177,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','281',6178,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','281',6179,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','281',6180,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','281',6181,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','281',6182,'22','2',125181.83,125181.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6183,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6184,'2','1',459128.56,459128.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6185,'3','1',510580.06,510580.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6186,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6187,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','282',6188,'6','1',648693.77,650267.55,1573.78,346231.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6189,'7','1',414229.82,414229.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6190,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6191,'9','1',804610.25,804610.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6192,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6193,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','282',6194,'12','1',440663.24,440663.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','282',6195,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','282',6196,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','282',6197,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','282',6198,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','282',6199,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','282',6200,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','282',6201,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','282',6202,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','282',6203,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','282',6204,'22','2',125181.83,125468.22,286.39,237703.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6205,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6206,'2','1',459128.56,459311.11,182.55,40161.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6207,'3','1',510580.06,510580.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6208,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6209,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','283',6210,'6','1',650267.55,650809.30,541.75,119185.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6211,'7','1',414229.82,418969.62,4739.80,1042756.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6212,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6213,'9','1',804610.25,811494.38,6884.13,1514508.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6214,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6215,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','283',6216,'12','1',440663.24,444073.16,3409.92,750182.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','283',6217,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','283',6218,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','283',6219,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','283',6220,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','283',6221,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','283',6222,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','283',6223,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','283',6224,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','283',6225,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','283',6226,'22','2',125468.22,126088.65,620.43,514956.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6227,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6228,'2','1',459311.11,459311.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6229,'3','1',510580.06,515220.48,4640.42,1020892.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6230,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6231,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','284',6232,'6','1',650809.30,658166.89,7357.59,1618669.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6233,'7','1',418969.62,418969.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6234,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6235,'9','1',811494.38,816813.69,5319.31,1170248.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6236,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6237,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','284',6238,'12','1',444073.16,448824.75,4751.59,1045349.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','284',6239,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','284',6240,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','284',6241,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','284',6242,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','284',6243,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','284',6244,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','284',6245,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','284',6246,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','284',6247,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','284',6248,'22','2',126088.65,126698.09,609.44,505835.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6249,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6250,'2','1',459311.11,464070.29,4759.18,1047019.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6251,'3','1',515220.48,519205.04,3984.56,876603.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6252,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6253,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','285',6254,'6','1',658166.89,665386.97,7220.08,1588417.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6255,'7','1',418969.62,418969.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6256,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6257,'9','1',816813.69,816813.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6258,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6259,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','285',6260,'12','1',448824.75,452911.15,4086.40,899008.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','285',6261,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','285',6262,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','285',6263,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','285',6264,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','285',6265,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','285',6266,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','285',6267,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','285',6268,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','285',6269,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','285',6270,'22','2',126698.09,127158.27,460.18,381949.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6271,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6272,'2','1',464070.29,466849.78,2779.49,611487.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6273,'3','1',519205.04,521211.46,2006.42,441412.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6274,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6275,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','286',6276,'6','1',665386.97,671569.51,6182.54,1360158.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6277,'7','1',418969.62,419313.25,343.63,75598.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6278,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6279,'9','1',816813.69,818076.25,1262.56,277763.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6280,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6281,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','286',6282,'12','1',452911.15,453512.63,601.48,132325.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','286',6283,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','286',6284,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','286',6285,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','286',6286,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','286',6287,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','286',6288,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','286',6289,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','286',6290,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','286',6291,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','286',6292,'22','2',127158.27,130556.50,3398.23,2820530.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6293,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6294,'2','1',466849.78,466849.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6295,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6296,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6297,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','287',6298,'6','1',671569.51,676142.87,4573.36,1006139.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6299,'7','1',419313.25,419313.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6300,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6301,'9','1',818076.25,818076.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6302,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6303,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','287',6304,'12','1',453512.63,453512.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','287',6305,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','287',6306,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','287',6307,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','287',6308,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','287',6309,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','287',6310,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','287',6311,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','287',6312,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','287',6313,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','287',6314,'22','2',130556.50,131957.81,1401.31,1163087.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6315,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6316,'2','1',466849.78,467526.70,676.92,148922.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6317,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6318,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6319,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','288',6320,'6','1',676142.87,676591.46,448.59,98689.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6321,'7','1',419313.25,419313.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6322,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6323,'9','1',818076.25,818076.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6324,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6325,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','288',6326,'12','1',453512.63,453512.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','288',6327,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','288',6328,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','288',6329,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','288',6330,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','288',6331,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','288',6332,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','288',6333,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','288',6334,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','288',6335,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','288',6336,'22','2',131957.81,132328.44,370.63,307622.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6337,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6338,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6339,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6340,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6341,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','289',6342,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6343,'7','1',419313.25,424837.20,5523.95,1215269.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6344,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6345,'9','1',818076.25,824985.93,6909.68,1520129.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6346,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6347,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','289',6348,'12','1',453512.63,458082.57,4569.94,1005386.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','289',6349,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','289',6350,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','289',6351,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','289',6352,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','289',6353,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','289',6354,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','289',6355,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','289',6356,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','289',6357,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','289',6358,'22','2',132328.44,132482.96,154.52,128251.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6359,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6360,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6361,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6362,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6363,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','290',6364,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6365,'7','1',424837.20,431916.28,7079.08,1557397.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6366,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6367,'9','1',824985.93,831742.34,6756.41,1486410.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6368,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6369,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','290',6370,'12','1',458082.57,463395.98,5313.41,1168950.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','290',6371,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','290',6372,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','290',6373,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','290',6374,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','290',6375,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','290',6376,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','290',6377,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','290',6378,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','290',6379,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','290',6380,'22','2',132482.96,132895.67,412.71,342549.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6381,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6382,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6383,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6384,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6385,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','291',6386,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6387,'7','1',431916.28,432642.57,726.29,159783.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6388,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6389,'9','1',831742.34,833288.72,1546.38,340203.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6390,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6391,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','291',6392,'12','1',463395.98,463395.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','291',6393,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','291',6394,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','291',6395,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','291',6396,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','291',6397,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','291',6398,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','291',6399,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','291',6400,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','291',6401,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','291',6402,'22','2',132895.67,133166.81,271.14,225046.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6403,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6404,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6405,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6406,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6407,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','292',6408,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6409,'7','1',432642.57,432642.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6410,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6411,'9','1',833288.72,833288.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6412,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6413,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','292',6414,'12','1',463395.98,463395.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','292',6415,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','292',6416,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','292',6417,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','292',6418,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','292',6419,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','292',6420,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','292',6421,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','292',6422,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','292',6423,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','292',6424,'22','2',133166.81,133444.61,277.80,230574.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6425,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6426,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6427,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6428,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6429,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','293',6430,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6431,'7','1',432642.57,432642.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6432,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6433,'9','1',833288.72,833288.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6434,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6435,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','293',6436,'12','1',463395.98,463395.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','293',6437,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','293',6438,'14','1',753896.34,753896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','293',6439,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','293',6440,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','293',6441,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','293',6442,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','293',6443,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','293',6444,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','293',6445,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','293',6446,'22','2',133444.61,133753.87,309.26,256685.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6447,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6448,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6449,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6450,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6451,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','294',6452,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6453,'7','1',432642.57,442118.86,9476.29,2084783.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6454,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6455,'9','1',833288.72,843261.77,9973.05,2194071.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6456,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6457,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','294',6458,'12','1',463395.98,470636.32,7240.34,1592874.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','294',6459,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','294',6460,'14','1',753896.34,759560.92,5664.58,1246207.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','294',6461,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','294',6462,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','294',6463,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','294',6464,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','294',6465,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','294',6466,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','294',6467,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','294',6468,'22','2',133753.87,133811.19,57.32,47575.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6469,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6470,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6471,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6472,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6473,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','295',6474,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6475,'7','1',442118.86,444196.41,2077.55,457061.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6476,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6477,'9','1',843261.77,845737.29,2475.52,544614.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6478,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6479,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','295',6480,'12','1',470636.32,472635.10,1998.78,439731.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','295',6481,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','295',6482,'14','1',759560.92,770855.76,11294.84,2484864.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','295',6483,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','295',6484,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','295',6485,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','295',6486,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','295',6487,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','295',6488,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','295',6489,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','295',6490,'22','2',133811.19,133860.69,49.50,41085.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6491,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6492,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6493,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6494,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6495,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','296',6496,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6497,'7','1',444196.41,450110.69,5914.28,1301141.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6498,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6499,'9','1',845737.29,852728.12,6990.83,1537982.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6500,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6501,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','296',6502,'12','1',472635.10,478130.22,5495.12,1208926.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','296',6503,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','296',6504,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','296',6505,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','296',6506,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','296',6507,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','296',6508,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','296',6509,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','296',6510,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','296',6511,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','296',6512,'22','2',133860.69,134315.32,454.63,377342.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6513,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6514,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6515,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6516,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6517,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','297',6518,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6519,'7','1',450110.69,451664.81,1554.12,341906.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6520,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6521,'9','1',852728.12,855232.91,2504.79,551053.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6522,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6523,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','297',6524,'12','1',478130.22,478130.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','297',6525,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','297',6526,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','297',6527,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','297',6528,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','297',6529,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','297',6530,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','297',6531,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','297',6532,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','297',6533,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','297',6534,'22','2',134315.32,134383.60,68.28,56672.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6535,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6536,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6537,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6538,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6539,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','298',6540,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6541,'7','1',451664.81,451664.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6542,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6543,'9','1',855232.91,855232.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6544,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6545,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','298',6546,'12','1',478130.22,478130.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','298',6547,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','298',6548,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','298',6549,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','298',6550,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','298',6551,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','298',6552,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','298',6553,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','298',6554,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','298',6555,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','298',6556,'22','2',134383.60,136958.08,2574.48,2136818.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6557,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6558,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6559,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6560,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6561,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','299',6562,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6563,'7','1',451664.81,452997.55,1332.74,293202.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6564,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6565,'9','1',855232.91,856779.80,1546.89,340315.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6566,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6567,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','299',6568,'12','1',478130.22,478130.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','299',6569,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','299',6570,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','299',6571,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','299',6572,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','299',6573,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','299',6574,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','299',6575,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','299',6576,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','299',6577,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','299',6578,'22','2',136958.08,137125.47,167.39,138933.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6579,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6580,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6581,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6582,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6583,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','300',6584,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6585,'7','1',452997.55,462597.34,9599.79,2111953.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6586,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6587,'9','1',856779.80,866946.48,10166.68,2236669.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6588,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6589,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','300',6590,'12','1',478130.22,484254.89,6124.67,1347427.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','300',6591,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','300',6592,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','300',6593,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','300',6594,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','300',6595,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','300',6596,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','300',6597,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','300',6598,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','300',6599,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','300',6600,'22','2',137125.47,137392.91,267.44,221975.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6601,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6602,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6603,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6604,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6605,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','301',6606,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6607,'7','1',462597.34,467961.77,5364.43,1180174.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6608,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6609,'9','1',866946.48,874119.77,7173.29,1578123.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6610,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6611,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','301',6612,'12','1',484254.89,489460.81,5205.92,1145302.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','301',6613,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','301',6614,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','301',6615,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','301',6616,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','301',6617,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','301',6618,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','301',6619,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','301',6620,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','301',6621,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','301',6622,'22','2',137392.91,140893.71,3500.80,2905664.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6623,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6624,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6625,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6626,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6627,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','302',6628,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6629,'7','1',467961.77,475664.29,7702.52,1694554.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6630,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6631,'9','1',874119.77,886588.20,12468.43,2743054.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6632,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6633,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','302',6634,'12','1',489460.81,495413.00,5952.19,1309481.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','302',6635,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','302',6636,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','302',6637,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','302',6638,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','302',6639,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','302',6640,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','302',6641,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','302',6642,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','302',6643,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','302',6644,'22','2',140893.71,141257.32,363.61,301796.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6645,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6646,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6647,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6648,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6649,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','303',6650,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6651,'7','1',475664.29,481468.14,5803.85,1276847.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6652,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6653,'9','1',886588.20,892310.53,5722.33,1258912.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6654,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6655,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','303',6656,'12','1',495413.00,501497.98,6084.98,1338695.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','303',6657,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','303',6658,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','303',6659,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','303',6660,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','303',6661,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','303',6662,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','303',6663,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','303',6664,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','303',6665,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','303',6666,'22','2',141257.32,141277.24,19.92,16533.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6667,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6668,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6669,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6670,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6671,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','304',6672,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6673,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6674,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6675,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6676,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6677,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','304',6678,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','304',6679,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','304',6680,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','304',6681,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','304',6682,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','304',6683,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','304',6684,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','304',6685,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','304',6686,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','304',6687,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','304',6688,'22','2',141277.24,142643.14,1365.90,1133697.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6689,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6690,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6691,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6692,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6693,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','305',6694,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6695,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6696,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6697,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6698,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6699,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','305',6700,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','305',6701,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','305',6702,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','305',6703,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','305',6704,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','305',6705,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','305',6706,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','305',6707,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','305',6708,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','305',6709,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','305',6710,'22','2',142643.14,142896.77,253.63,210512.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6711,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6712,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6713,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6714,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6715,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','306',6716,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6717,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6718,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6719,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6720,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6721,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','306',6722,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','306',6723,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','306',6724,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','306',6725,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','306',6726,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','306',6727,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','306',6728,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','306',6729,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','306',6730,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','306',6731,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','306',6732,'22','2',142896.77,143550.85,654.08,542886.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6733,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6734,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6735,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6736,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6737,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','307',6738,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6739,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6740,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6741,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6742,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6743,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','307',6744,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','307',6745,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','307',6746,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','307',6747,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','307',6748,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','307',6749,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','307',6750,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','307',6751,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','307',6752,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','307',6753,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','307',6754,'22','2',143550.85,143550.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6755,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6756,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6757,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6758,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6759,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','308',6760,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6761,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6762,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6763,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6764,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6765,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','308',6766,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','308',6767,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','308',6768,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','308',6769,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','308',6770,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','308',6771,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','308',6772,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','308',6773,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','308',6774,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','308',6775,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','308',6776,'22','2',143550.85,144866.10,1315.25,1091657.50,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6777,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6778,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6779,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6780,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6781,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','309',6782,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6783,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6784,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6785,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6786,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6787,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','309',6788,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','309',6789,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','309',6790,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','309',6791,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','309',6792,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','309',6793,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','309',6794,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','309',6795,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','309',6796,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','309',6797,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','309',6798,'22','2',144866.10,144866.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6799,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6800,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6801,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6802,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6803,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','310',6804,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6805,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6806,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6807,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6808,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6809,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','310',6810,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','310',6811,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','310',6812,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','310',6813,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','310',6814,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','310',6815,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','310',6816,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','310',6817,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','310',6818,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','310',6819,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','310',6820,'22','2',144866.10,144866.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6821,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6822,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6823,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6824,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6825,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','311',6826,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6827,'7','1',481468.14,481468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6828,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6829,'9','1',892310.53,892310.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6830,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6831,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','311',6832,'12','1',501497.98,501497.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','311',6833,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','311',6834,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','311',6835,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','311',6836,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','311',6837,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','311',6838,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','311',6839,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','311',6840,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','311',6841,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','311',6842,'22','2',144866.10,145075.00,208.90,173387.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6843,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6844,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6845,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6846,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6847,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','312',6848,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6849,'7','1',481468.14,482136.01,667.87,140252.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6850,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6851,'9','1',892310.53,892944.12,633.59,133053.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6852,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6853,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','312',6854,'12','1',501497.98,502112.71,614.73,129093.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','312',6855,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','312',6856,'14','1',770855.76,770855.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','312',6857,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','312',6858,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','312',6859,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','312',6860,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','312',6861,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','312',6862,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','312',6863,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','312',6864,'22','2',145075.00,145090.66,15.66,12997.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6865,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6866,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6867,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6868,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6869,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','313',6870,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6871,'7','1',482136.01,492512.06,10376.05,2178970.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6872,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6873,'9','1',892944.12,902360.50,9416.38,1977439.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6874,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6875,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','313',6876,'12','1',502112.71,511949.23,9836.52,2065669.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','313',6877,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','313',6878,'14','1',770855.76,779291.38,8435.62,1771480.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','313',6879,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','313',6880,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','313',6881,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','313',6882,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','313',6883,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','313',6884,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','313',6885,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','313',6886,'22','2',145090.66,146323.40,1232.74,1010846.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6887,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6888,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6889,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6890,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6891,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','314',6892,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6893,'7','1',492512.06,494061.53,1549.47,325388.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6894,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6895,'9','1',902360.50,903623.63,1263.13,265257.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6896,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6897,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','314',6898,'12','1',511949.23,513315.48,1366.25,286912.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','314',6899,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','314',6900,'14','1',779291.38,784298.37,5006.99,1051467.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','314',6901,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','314',6902,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','314',6903,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','314',6904,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','314',6905,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','314',6906,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','314',6907,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','314',6908,'22','2',146323.40,146323.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6909,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6910,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6911,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6912,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6913,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','315',6914,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6915,'7','1',494061.53,494061.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6916,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6917,'9','1',903623.63,903623.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6918,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6919,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','315',6920,'12','1',513315.48,513315.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','315',6921,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','315',6922,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','315',6923,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','315',6924,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','315',6925,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','315',6926,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','315',6927,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','315',6928,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','315',6929,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','315',6930,'22','2',146323.40,146435.16,111.76,91643.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6931,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6932,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6933,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6934,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6935,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','316',6936,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6937,'7','1',494061.53,494061.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6938,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6939,'9','1',903623.63,903623.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6940,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6941,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','316',6942,'12','1',513315.48,513315.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','316',6943,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','316',6944,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','316',6945,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','316',6946,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','316',6947,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','316',6948,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','316',6949,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','316',6950,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','316',6951,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','316',6952,'22','2',146435.16,146552.13,116.97,95915.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6953,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6954,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6955,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6956,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6957,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','317',6958,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6959,'7','1',494061.53,502530.91,8469.38,1778569.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6960,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6961,'9','1',903623.63,914931.02,11307.39,2374551.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6962,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6963,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','317',6964,'12','1',513315.48,522087.91,8772.43,1842210.30,0.00,0.00,0.00,0.00,0.00),('5','271','3','317',6965,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','317',6966,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','317',6967,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','317',6968,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','317',6969,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','317',6970,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','317',6971,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','317',6972,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','317',6973,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','317',6974,'22','2',146552.13,146742.03,189.90,155718.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6975,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6976,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6977,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6978,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6979,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','318',6980,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6981,'7','1',502530.91,502530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6982,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6983,'9','1',914931.02,914931.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6984,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6985,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','318',6986,'12','1',522087.91,522087.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','318',6987,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','318',6988,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','318',6989,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','318',6990,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','318',6991,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','318',6992,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','318',6993,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','318',6994,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','318',6995,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','318',6996,'22','2',146742.03,146742.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',6997,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',6998,'2','1',467526.70,467526.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',6999,'3','1',521211.46,521211.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',7000,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',7001,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','319',7002,'6','1',676591.46,676591.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7003,'7','1',502530.91,502530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7004,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7005,'9','1',914931.02,914931.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7006,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7007,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','319',7008,'12','1',522087.91,522087.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','319',7009,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','319',7010,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','319',7011,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','319',7012,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','319',7013,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','319',7014,'18','1',729817.85,729817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','319',7015,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','319',7016,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','319',7017,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','319',7018,'22','2',146742.03,146742.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7019,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7020,'2','1',467526.70,474141.92,6615.22,1389196.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7021,'3','1',521211.46,525794.59,4583.13,962457.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7022,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7023,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','320',7024,'6','1',676591.46,678264.99,1673.53,351441.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7025,'7','1',502530.91,506925.11,4394.20,922782.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7026,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7027,'9','1',914931.02,918826.10,3895.08,817966.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7028,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7029,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','320',7030,'12','1',522087.91,525160.57,3072.66,645258.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','320',7031,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','320',7032,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','320',7033,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','320',7034,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','320',7035,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','320',7036,'18','1',729817.85,736483.70,6665.85,1399828.50,0.00,0.00,0.00,0.00,0.00),('5','271','4','320',7037,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','320',7038,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','320',7039,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','320',7040,'22','2',146742.03,147073.25,331.22,271600.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7041,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7042,'2','1',474141.92,482413.46,8271.54,1737023.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7043,'3','1',525794.59,527063.47,1268.88,266464.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7044,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7045,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','321',7046,'6','1',678264.99,678264.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7047,'7','1',506925.11,513283.48,6358.37,1335257.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7048,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7049,'9','1',918826.10,926068.20,7242.10,1520841.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7050,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7051,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','321',7052,'12','1',525160.57,528723.23,3562.66,748158.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','321',7053,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','321',7054,'14','1',784298.37,784298.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','321',7055,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','321',7056,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','321',7057,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','321',7058,'18','1',736483.70,744698.64,8214.94,1725137.40,0.00,0.00,0.00,0.00,0.00),('5','271','4','321',7059,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','321',7060,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','321',7061,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','321',7062,'22','2',147073.25,147355.91,282.66,231781.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7063,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7064,'2','1',482413.46,489492.30,7078.84,1486556.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7065,'3','1',527063.47,528221.29,1157.82,243142.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7066,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7067,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','322',7068,'6','1',678264.99,683631.98,5366.99,1127067.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7069,'7','1',513283.48,517826.31,4542.83,953994.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7070,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7071,'9','1',926068.20,932716.69,6648.49,1396182.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7072,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7073,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','322',7074,'12','1',528723.23,536181.08,7457.85,1566148.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','322',7075,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','322',7076,'14','1',784298.37,785787.33,1488.96,312681.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','322',7077,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','322',7078,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','322',7079,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','322',7080,'18','1',744698.64,744698.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','322',7081,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','322',7082,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','322',7083,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','322',7084,'22','2',147355.91,148937.77,1581.86,1297125.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7085,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7086,'2','1',489492.30,497368.91,7876.61,1654088.10,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7087,'3','1',528221.29,533364.47,5143.18,1080067.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7088,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7089,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','323',7090,'6','1',683631.98,689993.93,6361.95,1336009.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7091,'7','1',517826.31,523616.71,5790.40,1215984.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7092,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7093,'9','1',932716.69,940203.02,7486.33,1572129.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7094,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7095,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','323',7096,'12','1',536181.08,545889.55,9708.47,2038778.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','323',7097,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','323',7098,'14','1',785787.33,787798.72,2011.39,422391.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','323',7099,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','323',7100,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','323',7101,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','323',7102,'18','1',744698.64,744698.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','323',7103,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','323',7104,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','323',7105,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','323',7106,'22','2',148937.77,152614.67,3676.90,3015058.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7107,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7108,'2','1',497368.91,507318.28,9949.37,2089367.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7109,'3','1',533364.47,540011.73,6647.26,1395924.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7110,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7111,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','324',7112,'6','1',689993.93,697017.05,7023.12,1474855.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7113,'7','1',523616.71,523827.63,210.92,44293.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7114,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7115,'9','1',940203.02,942140.86,1937.84,406946.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7116,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7117,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','324',7118,'12','1',545889.55,547192.73,1303.18,273667.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','324',7119,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','324',7120,'14','1',787798.72,796071.64,8272.92,1737313.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','324',7121,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','324',7122,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','324',7123,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','324',7124,'18','1',744698.64,755241.67,10543.03,2214036.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','324',7125,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','324',7126,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','324',7127,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','324',7128,'22','2',152614.67,152785.91,171.24,140416.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7129,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7130,'2','1',507318.28,515742.95,8424.67,1769180.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7131,'3','1',540011.73,545492.92,5481.19,1151049.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7132,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7133,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','325',7134,'6','1',697017.05,702456.65,5439.60,1142316.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7135,'7','1',523827.63,529499.59,5671.96,1191111.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7136,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7137,'9','1',942140.86,949007.92,6867.06,1442082.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7138,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7139,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','325',7140,'12','1',547192.73,555685.68,8492.95,1783519.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','325',7141,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','325',7142,'14','1',796071.64,800932.43,4860.79,1020765.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','325',7143,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','325',7144,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','325',7145,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','325',7146,'18','1',755241.67,764018.50,8776.83,1843134.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','325',7147,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','325',7148,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','325',7149,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','325',7150,'22','2',152785.91,155745.65,2959.74,2426986.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7151,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7152,'2','1',515742.95,522372.38,6629.43,1392180.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7153,'3','1',545492.92,549822.75,4329.83,909264.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7154,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7155,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','326',7156,'6','1',702456.65,707255.69,4799.04,1007798.40,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7157,'7','1',529499.59,534130.90,4631.31,972575.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7158,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7159,'9','1',949007.92,955765.49,6757.57,1419089.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7160,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7161,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','326',7162,'12','1',555685.68,563756.68,8071.00,1694910.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','326',7163,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','326',7164,'14','1',800932.43,806240.48,5308.05,1114690.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','326',7165,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','326',7166,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','326',7167,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','326',7168,'18','1',764018.50,771503.36,7484.86,1571820.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','326',7169,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','326',7170,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','326',7171,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','326',7172,'22','2',155745.65,156120.17,374.52,307106.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7173,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7174,'2','1',522372.38,527356.67,4984.29,1046700.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7175,'3','1',549822.75,549822.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7176,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7177,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','327',7178,'6','1',707255.69,712137.55,4881.86,1025190.60,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7179,'7','1',534130.90,538184.57,4053.67,851270.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7180,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7181,'9','1',955765.49,965198.66,9433.17,1980965.70,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7182,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7183,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','327',7184,'12','1',563756.68,572873.45,9116.77,1914521.70,0.00,0.00,0.00,0.00,0.00),('5','271','3','327',7185,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','327',7186,'14','1',806240.48,811031.39,4790.91,1006091.10,0.00,0.00,0.00,0.00,0.00),('5','271','3','327',7187,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','327',7188,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','327',7189,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','327',7190,'18','1',771503.36,774500.05,2996.69,629304.90,0.00,0.00,0.00,0.00,0.00),('5','271','4','327',7191,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','327',7192,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','327',7193,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','327',7194,'22','2',156120.17,156857.39,737.22,604520.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7195,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7196,'2','1',527356.67,532953.66,5596.99,1175367.90,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7197,'3','1',549822.75,554536.92,4714.17,989975.70,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7198,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7199,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','328',7200,'6','1',712137.55,717722.66,5585.11,1172873.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7201,'7','1',538184.57,542723.22,4538.65,953116.50,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7202,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7203,'9','1',965198.66,973007.54,7808.88,1639864.80,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7204,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7205,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','328',7206,'12','1',572873.45,581692.01,8818.56,1851897.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','328',7207,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','328',7208,'14','1',811031.39,817187.67,6156.28,1292818.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','328',7209,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','328',7210,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','328',7211,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','328',7212,'18','1',774500.05,782837.81,8337.76,1750929.60,0.00,0.00,0.00,0.00,0.00),('5','271','4','328',7213,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','328',7214,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','328',7215,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','328',7216,'22','2',156857.39,157452.23,594.84,487768.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7217,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7218,'2','1',532953.66,543847.09,10893.43,2287620.30,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7219,'3','1',554536.92,562061.42,7524.50,1580145.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7220,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7221,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','329',7222,'6','1',717722.66,724789.75,7067.09,1484088.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7223,'7','1',542723.22,542928.64,205.42,43138.20,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7224,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7225,'9','1',973007.54,977393.63,4386.09,921078.90,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7226,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7227,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','329',7228,'12','1',581692.01,584320.17,2628.16,551913.60,0.00,0.00,0.00,0.00,0.00),('5','271','3','329',7229,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','329',7230,'14','1',817187.67,828272.79,11085.12,2327875.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','329',7231,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','329',7232,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','329',7233,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','329',7234,'18','1',782837.81,795326.14,12488.33,2622549.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','329',7235,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','329',7236,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','329',7237,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','329',7238,'22','2',157452.23,159015.12,1562.89,1281569.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7239,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7240,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7241,'3','1',562061.42,565235.40,3173.98,666535.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7242,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7243,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','330',7244,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7245,'7','1',542928.64,550754.85,7826.21,1643504.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7246,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7247,'9','1',977393.63,986523.24,9129.61,1917218.10,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7248,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7249,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','330',7250,'12','1',584320.17,595532.05,11211.88,2354494.80,0.00,0.00,0.00,0.00,0.00),('5','271','3','330',7251,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','330',7252,'14','1',828272.79,836022.89,7750.10,1627521.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','330',7253,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','330',7254,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','330',7255,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','330',7256,'18','1',795326.14,804428.66,9102.52,1911529.20,0.00,0.00,0.00,0.00,0.00),('5','271','4','330',7257,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','330',7258,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','330',7259,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','330',7260,'22','2',159015.12,159333.58,318.46,261137.20,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7261,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7262,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7263,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7264,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7265,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','331',7266,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7267,'7','1',550754.85,555881.38,5126.53,1076571.30,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7268,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7269,'9','1',986523.24,992443.84,5920.60,1243326.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7270,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7271,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','331',7272,'12','1',595532.05,601423.07,5891.02,1237114.20,0.00,0.00,0.00,0.00,0.00),('5','271','3','331',7273,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','331',7274,'14','1',836022.89,845245.23,9222.34,1936691.40,0.00,0.00,0.00,0.00,0.00),('5','271','3','331',7275,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','331',7276,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','331',7277,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','331',7278,'18','1',804428.66,809107.59,4678.93,982575.30,0.00,0.00,0.00,0.00,0.00),('5','271','4','331',7279,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','331',7280,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','331',7281,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','331',7282,'22','2',159333.58,161135.95,1802.37,1477943.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7283,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7284,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7285,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7286,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7287,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','332',7288,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7289,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7290,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7291,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7292,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7293,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','332',7294,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','332',7295,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','332',7296,'14','1',845245.23,855329.18,10083.95,2117629.50,0.00,0.00,0.00,0.00,0.00),('5','271','3','332',7297,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','332',7298,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','332',7299,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','332',7300,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','332',7301,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','332',7302,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','332',7303,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','332',7304,'22','2',161135.95,161202.98,67.03,54964.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7305,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7306,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7307,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7308,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7309,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','333',7310,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7311,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7312,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7313,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7314,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7315,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','333',7316,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','333',7317,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','333',7318,'14','1',855329.18,860161.57,4832.39,1014801.90,0.00,0.00,0.00,0.00,0.00),('5','271','3','333',7319,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','333',7320,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','333',7321,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','333',7322,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','333',7323,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','333',7324,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','333',7325,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','333',7326,'22','2',161202.98,161243.17,40.19,32955.80,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7327,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7328,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7329,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7330,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7331,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','334',7332,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7333,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7334,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7335,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7336,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7337,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','334',7338,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','334',7339,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','334',7340,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','334',7341,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','334',7342,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','334',7343,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','334',7344,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','334',7345,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','334',7346,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','334',7347,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','334',7348,'22','2',161243.17,161654.47,411.30,337266.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7349,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7350,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7351,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7352,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7353,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','335',7354,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7355,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7356,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7357,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7358,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7359,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','335',7360,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','335',7361,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','335',7362,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','335',7363,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','335',7364,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','335',7365,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','335',7366,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','335',7367,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','335',7368,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','335',7369,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','335',7370,'22','2',161654.47,161808.47,154.00,126280.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7371,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7372,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7373,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7374,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7375,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','336',7376,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7377,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7378,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7379,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7380,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7381,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','336',7382,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','336',7383,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','336',7384,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','336',7385,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','336',7386,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','336',7387,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','336',7388,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','336',7389,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','336',7390,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','336',7391,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','336',7392,'22','2',161808.47,161853.85,45.38,37211.60,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7393,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7394,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7395,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7396,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7397,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','337',7398,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7399,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7400,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7401,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7402,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7403,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','337',7404,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','337',7405,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','337',7406,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','337',7407,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','337',7408,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','337',7409,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','337',7410,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','337',7411,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','337',7412,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','337',7413,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','337',7414,'22','2',161853.85,162564.12,710.27,582421.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7415,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7416,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7417,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7418,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7419,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','338',7420,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7421,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7422,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7423,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7424,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7425,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','338',7426,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','338',7427,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','338',7428,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','338',7429,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','338',7430,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','338',7431,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','338',7432,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','338',7433,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','338',7434,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','338',7435,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','338',7436,'22','2',162564.12,162936.89,372.77,305671.40,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7437,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7438,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7439,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7440,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7441,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','339',7442,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7443,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7444,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7445,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7446,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7447,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','339',7448,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','339',7449,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','339',7450,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','339',7451,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','339',7452,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','339',7453,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','339',7454,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','339',7455,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','339',7456,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','339',7457,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','339',7458,'22','2',162936.89,162936.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7459,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7460,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7461,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7462,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7463,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','340',7464,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7465,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7466,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7467,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7468,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7469,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','340',7470,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','340',7471,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','340',7472,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','340',7473,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','340',7474,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','340',7475,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','340',7476,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','340',7477,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','340',7478,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','340',7479,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','340',7480,'22','2',162936.89,162936.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7481,'1','1',29963.53,29963.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7482,'2','1',543847.09,543847.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7483,'3','1',565235.40,565235.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7484,'4','1',5339.39,5339.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7485,'5','1',27488.50,27488.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','1','341',7486,'6','1',724789.75,724789.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7487,'7','1',555881.38,555881.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7488,'8','1',23697.10,23697.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7489,'9','1',992443.84,992443.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7490,'10','1',116406.44,116406.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7491,'11','1',324114.02,324114.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','2','341',7492,'12','1',601423.07,601423.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','341',7493,'13','1',467.89,467.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','341',7494,'14','1',860161.57,860161.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','341',7495,'15','1',94070.38,94070.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','3','341',7496,'16','1',442902.63,442902.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','341',7497,'17','1',20962.48,20962.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','341',7498,'18','1',809107.59,809107.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','341',7499,'19','1',367500.37,367500.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','4','341',7500,'20','1',22182.96,22182.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','341',7501,'21','2',150336.32,150336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','271','5','341',7502,'22','2',162936.89,162936.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=683 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','271','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('5','271','1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('5','271','2','2',660.00,660.00,0.00,0.00,0.00,0.00,0.00,3),('5','271','2','1',165.00,165.00,55374.72,0.00,0.00,0.00,0.00,4),('5','271','3','2',660.00,660.00,492.91,0.00,0.00,0.00,0.00,5),('5','271','3','1',165.00,165.00,67868.26,0.00,0.00,0.00,0.00,6),('5','271','4','2',660.00,660.00,3136.62,0.00,0.00,0.00,0.00,7),('5','271','4','1',165.00,165.00,71682.27,0.00,0.00,0.00,0.00,8),('5','271','5','2',660.00,660.00,1735.99,0.00,0.00,0.00,0.00,9),('5','271','5','1',165.00,165.00,74358.31,0.00,0.00,0.00,0.00,10),('5','271','6','2',660.00,660.00,2413.56,0.00,0.00,0.00,0.00,11),('5','271','6','1',165.00,165.00,88434.19,0.00,0.00,0.00,0.00,12),('5','271','7','2',660.00,660.00,0.00,0.00,0.00,0.00,0.00,13),('5','271','7','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,14),('5','271','8','2',660.00,660.00,2512.98,0.00,0.00,0.00,0.00,15),('5','271','8','1',165.00,165.00,80959.20,0.00,0.00,0.00,0.00,16),('5','271','9','2',660.00,660.00,1337.98,0.00,0.00,0.00,0.00,17),('5','271','9','1',165.00,165.00,74964.88,0.00,0.00,0.00,0.00,18),('5','271','10','2',660.00,660.00,3364.40,0.00,0.00,0.00,0.00,19),('5','271','10','1',165.00,165.00,81268.44,0.00,0.00,0.00,0.00,20),('5','271','11','2',660.00,660.00,1935.41,0.00,0.00,0.00,0.00,21),('5','271','11','1',165.00,165.00,57819.94,0.00,0.00,0.00,0.00,22),('5','271','12','2',660.00,660.00,1351.83,0.00,0.00,0.00,0.00,23),('5','271','12','1',165.00,165.00,50391.45,0.00,0.00,0.00,0.00,24),('5','271','13','2',660.00,660.00,1891.89,0.00,0.00,0.00,0.00,25),('5','271','13','1',165.00,165.00,69283.99,0.00,0.00,0.00,0.00,26),('5','271','14','2',660.00,660.00,1791.16,0.00,0.00,0.00,0.00,27),('5','271','14','1',165.00,165.00,49902.88,0.00,0.00,0.00,0.00,28),('5','271','15','2',660.00,660.00,1484.80,0.00,0.00,0.00,0.00,29),('5','271','15','1',165.00,165.00,58976.35,0.00,0.00,0.00,0.00,30),('5','271','16','2',660.00,660.00,3038.34,0.00,0.00,0.00,0.00,31),('5','271','16','1',165.00,165.00,37559.35,0.00,0.00,0.00,0.00,32),('5','271','17','2',660.00,660.00,1973.05,0.00,0.00,0.00,0.00,33),('5','271','17','1',165.00,165.00,36330.10,0.00,0.00,0.00,0.00,34),('5','271','18','2',660.00,660.00,1693.68,0.00,0.00,0.00,0.00,35),('5','271','18','1',165.00,165.00,49218.62,0.00,0.00,0.00,0.00,36),('5','271','19','2',660.00,660.00,2646.80,0.00,0.00,0.00,0.00,37),('5','271','19','1',165.00,165.00,50979.41,0.00,0.00,0.00,0.00,38),('5','271','20','2',660.00,660.00,1572.57,0.00,0.00,0.00,0.00,39),('5','271','20','1',165.00,165.00,47372.91,0.00,0.00,0.00,0.00,40),('5','271','21','2',660.00,660.00,2317.45,0.00,0.00,0.00,0.00,41),('5','271','21','1',165.00,165.00,42208.04,0.00,0.00,0.00,0.00,42),('5','271','22','2',660.00,660.00,3631.31,0.00,0.00,0.00,0.00,43),('5','271','22','1',165.00,165.00,46909.09,0.00,0.00,0.00,0.00,44),('5','271','23','2',660.00,660.00,4022.10,0.00,0.00,0.00,0.00,45),('5','271','23','1',165.00,165.00,35560.28,0.00,0.00,0.00,0.00,46),('5','271','24','2',660.00,660.00,2725.14,0.00,0.00,0.00,0.00,47),('5','271','24','1',165.00,165.00,50598.04,0.00,0.00,0.00,0.00,48),('5','271','25','2',660.00,660.00,2828.22,0.00,0.00,0.00,0.00,49),('5','271','25','1',165.00,165.00,56067.84,0.00,0.00,0.00,0.00,50),('5','271','26','2',660.00,660.00,1415.61,0.00,0.00,0.00,0.00,51),('5','271','26','1',165.00,165.00,42502.03,0.00,0.00,0.00,0.00,52),('5','271','27','2',660.00,660.00,2516.05,0.00,0.00,0.00,0.00,53),('5','271','27','1',165.00,165.00,61026.07,0.00,0.00,0.00,0.00,54),('5','271','28','2',660.00,660.00,1673.79,0.00,0.00,0.00,0.00,55),('5','271','28','1',165.00,165.00,29932.91,0.00,0.00,0.00,0.00,56),('5','271','29','2',660.00,660.00,3112.62,0.00,0.00,0.00,0.00,57),('5','271','29','1',165.00,165.00,51483.91,0.00,0.00,0.00,0.00,58),('5','271','30','2',660.00,660.00,2565.60,0.00,0.00,0.00,0.00,59),('5','271','30','1',165.00,165.00,32618.72,0.00,0.00,0.00,0.00,60),('5','271','31','2',660.00,660.00,3328.19,0.00,0.00,0.00,0.00,61),('5','271','31','1',165.00,165.00,32596.34,0.00,0.00,0.00,0.00,62),('5','271','32','2',660.00,660.00,3016.15,0.00,0.00,0.00,0.00,63),('5','271','32','1',165.00,165.00,29373.77,0.00,0.00,0.00,0.00,64),('5','271','33','2',660.00,660.00,3138.91,0.00,0.00,0.00,0.00,65),('5','271','33','1',165.00,165.00,34616.07,0.00,0.00,0.00,0.00,66),('5','271','34','2',660.00,660.00,2426.26,0.00,0.00,0.00,0.00,67),('5','271','34','1',165.00,165.00,58445.42,0.00,0.00,0.00,0.00,68),('5','271','35','2',660.00,660.00,5885.85,0.00,0.00,0.00,0.00,69),('5','271','35','1',165.00,165.00,27891.23,0.00,0.00,0.00,0.00,70),('5','271','36','2',660.00,660.00,6932.02,0.00,0.00,0.00,0.00,71),('5','271','36','1',165.00,165.00,32013.48,0.00,0.00,0.00,0.00,72),('5','271','37','2',660.00,660.00,15061.27,0.00,0.00,0.00,0.00,73),('5','271','37','1',165.00,165.00,20415.36,0.00,0.00,0.00,0.00,74),('5','271','38','2',660.00,660.00,0.00,0.00,0.00,0.00,0.00,75),('5','271','38','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,76),('5','271','39','2',670.00,670.00,21473.83,0.00,0.00,0.00,0.00,77),('5','271','39','1',165.00,165.00,26190.11,0.00,0.00,0.00,0.00,78),('5','271','40','2',670.00,670.00,0.00,0.00,0.00,0.00,0.00,79),('5','271','40','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,80),('5','271','41','2',820.00,700.00,3441.27,0.00,0.00,0.00,0.00,81),('5','271','41','1',165.00,165.00,29159.35,0.00,0.00,0.00,0.00,82),('5','271','42','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,83),('5','271','42','1',165.00,165.00,34402.53,0.00,0.00,0.00,0.00,84),('5','271','43','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,85),('5','271','43','1',165.00,165.00,31838.50,0.00,0.00,0.00,0.00,86),('5','271','44','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,87),('5','271','44','1',165.00,165.00,45724.19,0.00,0.00,0.00,0.00,88),('5','271','45','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,89),('5','271','45','1',165.00,165.00,37124.05,0.00,0.00,0.00,0.00,90),('5','271','46','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,91),('5','271','46','1',165.00,165.00,31936.17,0.00,0.00,0.00,0.00,92),('5','271','47','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,93),('5','271','47','1',165.00,165.00,30440.25,0.00,0.00,0.00,0.00,94),('5','271','48','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,95),('5','271','48','1',165.00,165.00,44108.45,0.00,0.00,0.00,0.00,96),('5','271','49','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,97),('5','271','49','1',165.00,165.00,38404.30,0.00,0.00,0.00,0.00,98),('5','271','50','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,99),('5','271','50','1',165.00,165.00,34866.08,0.00,0.00,0.00,0.00,100),('5','271','51','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,101),('5','271','51','1',165.00,165.00,38825.73,0.00,0.00,0.00,0.00,102),('5','271','52','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,103),('5','271','52','1',165.00,165.00,36697.26,0.00,0.00,0.00,0.00,104),('5','271','53','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,105),('5','271','53','1',165.00,165.00,29307.25,0.00,0.00,0.00,0.00,106),('5','271','54','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,107),('5','271','54','1',165.00,165.00,46311.95,0.00,0.00,0.00,0.00,108),('5','271','55','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,109),('5','271','55','1',165.00,165.00,42451.85,0.00,0.00,0.00,0.00,110),('5','271','56','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,111),('5','271','56','1',165.00,165.00,32849.36,0.00,0.00,0.00,0.00,112),('5','271','57','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,113),('5','271','57','1',165.00,165.00,46535.97,0.00,0.00,0.00,0.00,114),('5','271','58','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,115),('5','271','58','1',165.00,165.00,36952.72,0.00,0.00,0.00,0.00,116),('5','271','59','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,117),('5','271','59','1',165.00,165.00,42593.21,0.00,0.00,0.00,0.00,118),('5','271','60','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,119),('5','271','60','1',165.00,165.00,30590.31,0.00,0.00,0.00,0.00,120),('5','271','61','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,121),('5','271','61','1',165.00,165.00,17487.81,0.00,0.00,0.00,0.00,122),('5','271','62','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,123),('5','271','62','1',165.00,165.00,12512.33,0.00,0.00,0.00,0.00,124),('5','271','63','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,125),('5','271','63','1',165.00,165.00,23737.12,0.00,0.00,0.00,0.00,126),('5','271','64','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,127),('5','271','64','1',165.00,165.00,28446.15,0.00,0.00,0.00,0.00,128),('5','271','65','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,129),('5','271','65','1',165.00,165.00,32290.22,0.00,0.00,0.00,0.00,130),('5','271','66','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,131),('5','271','66','1',165.00,165.00,25374.42,0.00,0.00,0.00,0.00,132),('5','271','67','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,133),('5','271','67','1',165.00,165.00,28244.44,0.00,0.00,0.00,0.00,134),('5','271','68','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,135),('5','271','68','1',165.00,165.00,21642.76,0.00,0.00,0.00,0.00,136),('5','271','69','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,137),('5','271','69','1',165.00,165.00,26445.19,0.00,0.00,0.00,0.00,138),('5','271','70','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,139),('5','271','70','1',165.00,165.00,14838.00,0.00,0.00,0.00,0.00,140),('5','271','71','2',700.00,700.00,0.00,0.00,0.00,0.00,0.00,141),('5','271','71','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,142),('5','271','72','2',800.00,800.00,850.39,0.00,0.00,0.00,0.00,143),('5','271','72','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,144),('5','271','73','2',800.00,800.00,433.12,0.00,0.00,0.00,0.00,145),('5','271','73','1',165.00,165.00,21668.14,0.00,0.00,0.00,0.00,146),('5','271','74','2',800.00,800.00,748.73,0.00,0.00,0.00,0.00,147),('5','271','74','1',165.00,165.00,25028.12,0.00,0.00,0.00,0.00,148),('5','271','75','2',800.00,800.00,673.03,0.00,0.00,0.00,0.00,149),('5','271','75','1',165.00,165.00,33800.62,0.00,0.00,0.00,0.00,150),('5','271','76','2',800.00,800.00,3369.02,0.00,0.00,0.00,0.00,151),('5','271','76','1',165.00,165.00,23396.26,0.00,0.00,0.00,0.00,152),('5','271','77','2',800.00,800.00,884.89,0.00,0.00,0.00,0.00,153),('5','271','77','1',165.00,165.00,9356.29,0.00,0.00,0.00,0.00,154),('5','271','78','2',800.00,800.00,3081.68,0.00,0.00,0.00,0.00,155),('5','271','78','1',165.00,165.00,25938.41,0.00,0.00,0.00,0.00,156),('5','271','79','2',800.00,800.00,2665.99,0.00,0.00,0.00,0.00,157),('5','271','79','1',165.00,165.00,32867.68,0.00,0.00,0.00,0.00,158),('5','271','80','2',800.00,800.00,1570.51,0.00,0.00,0.00,0.00,159),('5','271','80','1',165.00,165.00,24887.78,0.00,0.00,0.00,0.00,160),('5','271','81','2',820.00,820.00,414.72,0.00,0.00,0.00,0.00,161),('5','271','81','1',165.00,165.00,15341.21,0.00,0.00,0.00,0.00,162),('5','271','82','2',820.00,820.00,515.87,0.00,0.00,0.00,0.00,163),('5','271','82','1',165.00,165.00,20152.48,0.00,0.00,0.00,0.00,164),('5','271','83','2',820.00,820.00,815.24,0.00,0.00,0.00,0.00,165),('5','271','83','1',165.00,165.00,17251.86,0.00,0.00,0.00,0.00,166),('5','271','84','2',820.00,820.00,1757.14,0.00,0.00,0.00,0.00,167),('5','271','84','1',165.00,165.00,4776.07,0.00,0.00,0.00,0.00,168),('5','271','85','2',820.00,820.00,1147.09,0.00,0.00,0.00,0.00,169),('5','271','85','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,170),('5','271','86','2',820.00,820.00,1379.24,0.00,0.00,0.00,0.00,171),('5','271','86','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,172),('5','271','87','2',820.00,820.00,246.76,0.00,0.00,0.00,0.00,173),('5','271','87','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,174),('5','271','88','2',820.00,820.00,350.80,0.00,0.00,0.00,0.00,175),('5','271','88','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,176),('5','271','89','2',820.00,820.00,531.98,0.00,0.00,0.00,0.00,177),('5','271','89','1',165.00,165.00,21977.97,0.00,0.00,0.00,0.00,178),('5','271','90','2',820.00,820.00,641.91,0.00,0.00,0.00,0.00,179),('5','271','90','1',185.00,165.00,17406.87,0.00,0.00,0.00,0.00,180),('5','271','91','2',820.00,820.00,426.30,0.00,0.00,0.00,0.00,181),('5','271','91','1',185.00,165.00,19423.55,0.00,0.00,0.00,0.00,182),('5','271','92','2',820.00,820.00,559.91,0.00,0.00,0.00,0.00,183),('5','271','92','1',185.00,165.00,18833.95,0.00,0.00,0.00,0.00,184),('5','271','93','2',820.00,820.00,709.87,0.00,0.00,0.00,0.00,185),('5','271','93','1',185.00,165.00,18645.30,0.00,0.00,0.00,0.00,186),('5','271','94','2',820.00,820.00,1033.97,0.00,0.00,0.00,0.00,187),('5','271','94','1',185.00,165.00,22588.15,0.00,0.00,0.00,0.00,188),('5','271','95','2',800.00,800.00,242.40,0.00,0.00,0.00,0.00,189),('5','271','95','1',185.00,165.00,3723.34,0.00,0.00,0.00,0.00,190),('5','271','96','2',800.00,800.00,306.23,0.00,0.00,0.00,0.00,191),('5','271','96','1',185.00,165.00,1329.41,0.00,0.00,0.00,0.00,192),('5','271','97','2',800.00,800.00,131.09,0.00,0.00,0.00,0.00,193),('5','271','97','1',185.00,165.00,747.11,0.00,0.00,0.00,0.00,194),('5','271','98','2',800.00,800.00,635.88,0.00,0.00,0.00,0.00,195),('5','271','98','1',185.00,165.00,10349.44,0.00,0.00,0.00,0.00,196),('5','271','99','2',800.00,800.00,449.99,0.00,0.00,0.00,0.00,197),('5','271','99','1',185.00,165.00,20958.88,0.00,0.00,0.00,0.00,198),('5','271','100','2',800.00,800.00,2752.00,0.00,0.00,0.00,0.00,199),('5','271','100','1',185.00,165.00,38556.60,0.00,0.00,0.00,0.00,200),('5','271','101','2',800.00,800.00,350.81,0.00,0.00,0.00,0.00,201),('5','271','101','1',185.00,165.00,37137.88,0.00,0.00,0.00,0.00,202),('5','271','102','2',800.00,800.00,535.26,0.00,0.00,0.00,0.00,203),('5','271','102','1',185.00,165.00,25324.99,0.00,0.00,0.00,0.00,204),('5','271','103','2',800.00,800.00,393.75,0.00,0.00,0.00,0.00,205),('5','271','103','1',185.00,165.00,12401.84,0.00,0.00,0.00,0.00,206),('5','271','104','2',800.00,800.00,1619.85,0.00,0.00,0.00,0.00,207),('5','271','104','1',185.00,165.00,33548.57,0.00,0.00,0.00,0.00,208),('5','271','105','2',800.00,800.00,569.83,0.00,0.00,0.00,0.00,209),('5','271','105','1',185.00,185.00,26223.31,0.00,0.00,0.00,0.00,210),('5','271','106','2',800.00,800.00,3097.34,0.00,0.00,0.00,0.00,211),('5','271','106','1',185.00,185.00,27334.11,0.00,0.00,0.00,0.00,212),('5','271','107','2',800.00,800.00,1113.26,0.00,0.00,0.00,0.00,213),('5','271','107','1',185.00,185.00,16561.39,0.00,0.00,0.00,0.00,214),('5','271','108','2',800.00,800.00,1487.48,0.00,0.00,0.00,0.00,215),('5','271','108','1',185.00,185.00,36964.65,0.00,0.00,0.00,0.00,216),('5','271','109','2',800.00,800.00,537.59,0.00,0.00,0.00,0.00,217),('5','271','109','1',185.00,185.00,55167.45,0.00,0.00,0.00,0.00,218),('5','271','110','2',800.00,800.00,1245.57,0.00,0.00,0.00,0.00,219),('5','271','110','1',185.00,185.00,52286.85,0.00,0.00,0.00,0.00,220),('5','271','111','2',800.00,800.00,343.30,0.00,0.00,0.00,0.00,221),('5','271','111','1',185.00,185.00,45310.83,0.00,0.00,0.00,0.00,222),('5','271','112','2',800.00,800.00,539.54,0.00,0.00,0.00,0.00,223),('5','271','112','1',185.00,185.00,45700.76,0.00,0.00,0.00,0.00,224),('5','271','113','2',800.00,800.00,1405.73,0.00,0.00,0.00,0.00,225),('5','271','113','1',185.00,185.00,25714.95,0.00,0.00,0.00,0.00,226),('5','271','114','2',800.00,800.00,1172.86,0.00,0.00,0.00,0.00,227),('5','271','114','1',185.00,185.00,28785.98,0.00,0.00,0.00,0.00,228),('5','271','115','2',800.00,800.00,1098.57,0.00,0.00,0.00,0.00,229),('5','271','115','1',185.00,185.00,24985.62,0.00,0.00,0.00,0.00,230),('5','271','116','2',800.00,800.00,272.26,0.00,0.00,0.00,0.00,231),('5','271','116','1',185.00,185.00,33986.10,0.00,0.00,0.00,0.00,232),('5','271','117','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,233),('5','271','117','1',185.00,185.00,14763.52,0.00,0.00,0.00,0.00,234),('5','271','118','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,235),('5','271','118','1',185.00,185.00,23640.48,0.00,0.00,0.00,0.00,236),('5','271','119','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,237),('5','271','119','1',185.00,185.00,22057.99,0.00,0.00,0.00,0.00,238),('5','271','120','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,239),('5','271','120','1',185.00,185.00,24514.87,0.00,0.00,0.00,0.00,240),('5','271','121','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,241),('5','271','121','1',185.00,185.00,32754.48,0.00,0.00,0.00,0.00,242),('5','271','122','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,243),('5','271','122','1',185.00,185.00,30403.19,0.00,0.00,0.00,0.00,244),('5','271','123','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,245),('5','271','123','1',185.00,185.00,21818.56,0.00,0.00,0.00,0.00,246),('5','271','124','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,247),('5','271','124','1',185.00,185.00,13393.98,0.00,0.00,0.00,0.00,248),('5','271','125','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,249),('5','271','125','1',185.00,185.00,12161.30,0.00,0.00,0.00,0.00,250),('5','271','126','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,251),('5','271','126','1',185.00,185.00,19088.75,0.00,0.00,0.00,0.00,252),('5','271','127','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,253),('5','271','127','1',185.00,185.00,20623.54,0.00,0.00,0.00,0.00,254),('5','271','128','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,255),('5','271','128','1',185.00,185.00,18369.60,0.00,0.00,0.00,0.00,256),('5','271','129','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,257),('5','271','129','1',185.00,185.00,18661.80,0.00,0.00,0.00,0.00,258),('5','271','130','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,259),('5','271','130','1',185.00,185.00,25045.38,0.00,0.00,0.00,0.00,260),('5','271','131','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,261),('5','271','131','1',185.00,185.00,22045.55,0.00,0.00,0.00,0.00,262),('5','271','132','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,263),('5','271','132','1',185.00,185.00,20216.84,0.00,0.00,0.00,0.00,264),('5','271','133','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,265),('5','271','133','1',185.00,185.00,20707.50,0.00,0.00,0.00,0.00,266),('5','271','134','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,267),('5','271','134','1',185.00,185.00,19667.87,0.00,0.00,0.00,0.00,268),('5','271','135','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,269),('5','271','135','1',185.00,185.00,17434.49,0.00,0.00,0.00,0.00,270),('5','271','136','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,271),('5','271','136','1',185.00,185.00,14226.73,0.00,0.00,0.00,0.00,272),('5','271','137','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,273),('5','271','137','1',185.00,185.00,15168.82,0.00,0.00,0.00,0.00,274),('5','271','138','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,275),('5','271','138','1',185.00,185.00,17527.38,0.00,0.00,0.00,0.00,276),('5','271','139','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,277),('5','271','139','1',185.00,185.00,18028.87,0.00,0.00,0.00,0.00,278),('5','271','140','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,279),('5','271','140','1',185.00,185.00,16013.58,0.00,0.00,0.00,0.00,280),('5','271','141','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,281),('5','271','141','1',185.00,185.00,14344.29,0.00,0.00,0.00,0.00,282),('5','271','142','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,283),('5','271','142','1',185.00,185.00,15198.11,0.00,0.00,0.00,0.00,284),('5','271','143','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,285),('5','271','143','1',185.00,185.00,15247.39,0.00,0.00,0.00,0.00,286),('5','271','144','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,287),('5','271','144','1',185.00,185.00,15301.62,0.00,0.00,0.00,0.00,288),('5','271','145','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,289),('5','271','145','1',185.00,185.00,13307.57,0.00,0.00,0.00,0.00,290),('5','271','146','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,291),('5','271','146','1',185.00,185.00,13768.25,0.00,0.00,0.00,0.00,292),('5','271','147','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,293),('5','271','147','1',185.00,185.00,15752.18,0.00,0.00,0.00,0.00,294),('5','271','148','2',800.00,800.00,1066.87,0.00,0.00,0.00,0.00,295),('5','271','148','1',185.00,185.00,14667.76,0.00,0.00,0.00,0.00,296),('5','271','149','2',800.00,800.00,63.11,0.00,0.00,0.00,0.00,297),('5','271','149','1',185.00,185.00,15030.52,0.00,0.00,0.00,0.00,298),('5','271','150','2',800.00,800.00,1944.42,0.00,0.00,0.00,0.00,299),('5','271','150','1',185.00,185.00,15962.44,0.00,0.00,0.00,0.00,300),('5','271','151','2',800.00,800.00,104.08,0.00,0.00,0.00,0.00,301),('5','271','151','1',185.00,185.00,13452.48,0.00,0.00,0.00,0.00,302),('5','271','152','2',800.00,800.00,93.62,0.00,0.00,0.00,0.00,303),('5','271','152','1',185.00,185.00,15474.08,0.00,0.00,0.00,0.00,304),('5','271','153','2',800.00,800.00,612.99,0.00,0.00,0.00,0.00,305),('5','271','153','1',185.00,185.00,20096.00,0.00,0.00,0.00,0.00,306),('5','271','154','2',800.00,800.00,1871.82,0.00,0.00,0.00,0.00,307),('5','271','154','1',185.00,185.00,20846.18,0.00,0.00,0.00,0.00,308),('5','271','155','2',800.00,800.00,81.62,0.00,0.00,0.00,0.00,309),('5','271','155','1',185.00,185.00,15744.52,0.00,0.00,0.00,0.00,310),('5','271','156','2',800.00,800.00,77.99,0.00,0.00,0.00,0.00,311),('5','271','156','1',185.00,185.00,17050.03,0.00,0.00,0.00,0.00,312),('5','271','157','2',800.00,800.00,248.53,0.00,0.00,0.00,0.00,313),('5','271','157','1',185.00,185.00,18339.81,0.00,0.00,0.00,0.00,314),('5','271','158','2',800.00,800.00,524.14,0.00,0.00,0.00,0.00,315),('5','271','158','1',185.00,185.00,17271.64,0.00,0.00,0.00,0.00,316),('5','271','159','2',800.00,800.00,168.99,0.00,0.00,0.00,0.00,317),('5','271','159','1',185.00,185.00,16326.01,0.00,0.00,0.00,0.00,318),('5','271','160','2',800.00,800.00,336.63,0.00,0.00,0.00,0.00,319),('5','271','160','1',185.00,185.00,17038.93,0.00,0.00,0.00,0.00,320),('5','271','161','2',800.00,800.00,175.38,0.00,0.00,0.00,0.00,321),('5','271','161','1',185.00,185.00,16232.64,0.00,0.00,0.00,0.00,322),('5','271','162','2',800.00,800.00,284.49,0.00,0.00,0.00,0.00,323),('5','271','162','1',185.00,185.00,16229.65,0.00,0.00,0.00,0.00,324),('5','271','163','2',800.00,800.00,183.05,0.00,0.00,0.00,0.00,325),('5','271','163','1',185.00,185.00,18314.71,0.00,0.00,0.00,0.00,326),('5','271','164','2',800.00,800.00,460.37,0.00,0.00,0.00,0.00,327),('5','271','164','1',185.00,185.00,16158.10,0.00,0.00,0.00,0.00,328),('5','271','165','2',800.00,800.00,317.15,0.00,0.00,0.00,0.00,329),('5','271','165','1',185.00,185.00,13962.67,0.00,0.00,0.00,0.00,330),('5','271','166','2',800.00,800.00,188.66,0.00,0.00,0.00,0.00,331),('5','271','166','1',185.00,185.00,17540.54,0.00,0.00,0.00,0.00,332),('5','271','167','2',800.00,800.00,1061.72,0.00,0.00,0.00,0.00,333),('5','271','167','1',185.00,185.00,17513.20,0.00,0.00,0.00,0.00,334),('5','271','168','2',800.00,800.00,7903.07,0.00,0.00,0.00,0.00,335),('5','271','168','1',185.00,185.00,15776.89,0.00,0.00,0.00,0.00,336),('5','271','169','2',800.00,800.00,8257.56,0.00,0.00,0.00,0.00,337),('5','271','169','1',185.00,185.00,17763.56,0.00,0.00,0.00,0.00,338),('5','271','170','2',800.00,800.00,2370.74,0.00,0.00,0.00,0.00,339),('5','271','170','1',185.00,185.00,17415.14,0.00,0.00,0.00,0.00,340),('5','271','171','2',800.00,800.00,345.27,0.00,0.00,0.00,0.00,341),('5','271','171','1',185.00,185.00,17354.36,0.00,0.00,0.00,0.00,342),('5','271','172','2',800.00,800.00,961.67,0.00,0.00,0.00,0.00,343),('5','271','172','1',185.00,185.00,18044.17,0.00,0.00,0.00,0.00,344),('5','271','173','2',800.00,800.00,503.50,0.00,0.00,0.00,0.00,345),('5','271','173','1',185.00,185.00,17704.94,0.00,0.00,0.00,0.00,346),('5','271','174','2',800.00,800.00,779.11,0.00,0.00,0.00,0.00,347),('5','271','174','1',185.00,185.00,18203.17,0.00,0.00,0.00,0.00,348),('5','271','175','2',800.00,800.00,1718.97,0.00,0.00,0.00,0.00,349),('5','271','175','1',185.00,185.00,18078.08,0.00,0.00,0.00,0.00,350),('5','271','176','2',800.00,800.00,1341.61,0.00,0.00,0.00,0.00,351),('5','271','176','1',185.00,185.00,14055.63,0.00,0.00,0.00,0.00,352),('5','271','177','2',830.00,800.00,1123.56,0.00,0.00,0.00,0.00,353),('5','271','177','1',185.00,185.00,20050.54,0.00,0.00,0.00,0.00,354),('5','271','178','2',830.00,800.00,1326.02,0.00,0.00,0.00,0.00,355),('5','271','178','1',185.00,185.00,18161.78,0.00,0.00,0.00,0.00,356),('5','271','179','2',830.00,800.00,2419.82,0.00,0.00,0.00,0.00,357),('5','271','179','1',185.00,185.00,17579.31,0.00,0.00,0.00,0.00,358),('5','271','180','2',830.00,800.00,356.20,0.00,0.00,0.00,0.00,359),('5','271','180','1',185.00,185.00,15569.01,0.00,0.00,0.00,0.00,360),('5','271','181','2',830.00,800.00,0.00,0.00,0.00,0.00,0.00,361),('5','271','181','1',185.00,185.00,15798.43,0.00,0.00,0.00,0.00,362),('5','271','182','2',830.00,800.00,4293.10,0.00,0.00,0.00,0.00,363),('5','271','182','1',185.00,185.00,10148.31,0.00,0.00,0.00,0.00,364),('5','271','183','2',830.00,800.00,1350.70,0.00,0.00,0.00,0.00,365),('5','271','183','1',185.00,185.00,5440.32,0.00,0.00,0.00,0.00,366),('5','271','184','2',830.00,800.00,0.00,0.00,0.00,0.00,0.00,367),('5','271','184','1',185.00,185.00,3335.56,0.00,0.00,0.00,0.00,368),('5','271','185','2',830.00,800.00,0.00,0.00,0.00,0.00,0.00,369),('5','271','185','1',185.00,185.00,1694.96,0.00,0.00,0.00,0.00,370),('5','271','186','2',830.00,800.00,607.04,0.00,0.00,0.00,0.00,371),('5','271','186','1',185.00,185.00,8692.43,0.00,0.00,0.00,0.00,372),('5','271','187','2',830.00,800.00,3249.68,0.00,0.00,0.00,0.00,373),('5','271','187','1',185.00,185.00,4726.10,0.00,0.00,0.00,0.00,374),('5','271','188','2',830.00,800.00,718.80,0.00,0.00,0.00,0.00,375),('5','271','188','1',185.00,185.00,22129.89,0.00,0.00,0.00,0.00,376),('5','271','189','2',830.00,800.00,429.12,0.00,0.00,0.00,0.00,377),('5','271','189','1',185.00,185.00,20568.29,0.00,0.00,0.00,0.00,378),('5','271','190','2',830.00,800.00,605.59,0.00,0.00,0.00,0.00,379),('5','271','190','1',185.00,185.00,9562.02,0.00,0.00,0.00,0.00,380),('5','271','191','2',830.00,800.00,332.17,0.00,0.00,0.00,0.00,381),('5','271','191','1',185.00,185.00,3084.63,0.00,0.00,0.00,0.00,382),('5','271','192','2',830.00,800.00,949.18,0.00,0.00,0.00,0.00,383),('5','271','192','1',185.00,185.00,1928.50,0.00,0.00,0.00,0.00,384),('5','271','193','2',830.00,800.00,853.42,0.00,0.00,0.00,0.00,385),('5','271','193','1',185.00,185.00,14968.74,0.00,0.00,0.00,0.00,386),('5','271','194','2',830.00,800.00,407.30,0.00,0.00,0.00,0.00,387),('5','271','194','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,388),('5','271','195','2',830.00,800.00,0.00,0.00,0.00,0.00,0.00,389),('5','271','195','1',185.00,185.00,26613.28,0.00,0.00,0.00,0.00,390),('5','271','196','2',830.00,800.00,609.63,0.00,0.00,0.00,0.00,391),('5','271','196','1',185.00,185.00,28161.24,0.00,0.00,0.00,0.00,392),('5','271','197','2',830.00,800.00,1442.87,0.00,0.00,0.00,0.00,393),('5','271','197','1',185.00,185.00,23552.87,0.00,0.00,0.00,0.00,394),('5','271','198','2',830.00,830.00,1856.41,0.00,0.00,0.00,0.00,395),('5','271','198','1',185.00,185.00,32667.49,0.00,0.00,0.00,0.00,396),('5','271','199','2',830.00,830.00,410.96,0.00,0.00,0.00,0.00,397),('5','271','199','1',185.00,185.00,25287.26,0.00,0.00,0.00,0.00,398),('5','271','200','2',830.00,830.00,1752.03,0.00,0.00,0.00,0.00,399),('5','271','200','1',185.00,185.00,36756.89,0.00,0.00,0.00,0.00,400),('5','271','201','2',830.00,830.00,1221.56,0.00,0.00,0.00,0.00,401),('5','271','201','1',185.00,185.00,41783.79,0.00,0.00,0.00,0.00,402),('5','271','202','2',830.00,830.00,761.87,0.00,0.00,0.00,0.00,403),('5','271','202','1',185.00,185.00,46517.20,0.00,0.00,0.00,0.00,404),('5','271','203','2',830.00,830.00,797.47,0.00,0.00,0.00,0.00,405),('5','271','203','1',185.00,185.00,33278.62,0.00,0.00,0.00,0.00,406),('5','271','204','2',830.00,830.00,555.43,0.00,0.00,0.00,0.00,407),('5','271','204','1',185.00,185.00,30273.90,0.00,0.00,0.00,0.00,408),('5','271','205','2',830.00,830.00,208.62,0.00,0.00,0.00,0.00,409),('5','271','205','1',185.00,185.00,22535.20,0.00,0.00,0.00,0.00,410),('5','271','206','2',830.00,830.00,46.87,0.00,0.00,0.00,0.00,411),('5','271','206','1',185.00,185.00,22532.06,0.00,0.00,0.00,0.00,412),('5','271','207','2',830.00,830.00,4065.78,0.00,0.00,0.00,0.00,413),('5','271','207','1',185.00,185.00,32464.86,0.00,0.00,0.00,0.00,414),('5','271','208','2',830.00,830.00,222.06,0.00,0.00,0.00,0.00,415),('5','271','208','1',185.00,185.00,20995.14,0.00,0.00,0.00,0.00,416),('5','271','209','2',830.00,830.00,759.00,0.00,0.00,0.00,0.00,417),('5','271','209','1',185.00,185.00,28043.56,0.00,0.00,0.00,0.00,418),('5','271','210','2',830.00,830.00,1983.53,0.00,0.00,0.00,0.00,419),('5','271','210','1',185.00,185.00,19971.75,0.00,0.00,0.00,0.00,420),('5','271','211','2',830.00,830.00,941.26,0.00,0.00,0.00,0.00,421),('5','271','211','1',185.00,185.00,5552.31,0.00,0.00,0.00,0.00,422),('5','271','212','2',830.00,830.00,1306.95,0.00,0.00,0.00,0.00,423),('5','271','212','1',185.00,185.00,7823.11,0.00,0.00,0.00,0.00,424),('5','271','213','2',870.00,870.00,103.12,0.00,0.00,0.00,0.00,425),('5','271','213','1',185.00,185.00,5279.40,0.00,0.00,0.00,0.00,426),('5','271','214','2',870.00,870.00,630.56,0.00,0.00,0.00,0.00,427),('5','271','214','1',185.00,185.00,6757.12,0.00,0.00,0.00,0.00,428),('5','271','215','2',870.00,870.00,678.68,0.00,0.00,0.00,0.00,429),('5','271','215','1',185.00,185.00,10400.96,0.00,0.00,0.00,0.00,430),('5','271','216','2',870.00,870.00,1349.65,0.00,0.00,0.00,0.00,431),('5','271','216','1',185.00,185.00,6693.49,0.00,0.00,0.00,0.00,432),('5','271','217','2',870.00,870.00,17.28,0.00,0.00,0.00,0.00,433),('5','271','217','1',185.00,185.00,1661.44,0.00,0.00,0.00,0.00,434),('5','271','218','2',870.00,870.00,713.20,0.00,0.00,0.00,0.00,435),('5','271','218','1',185.00,185.00,11370.57,0.00,0.00,0.00,0.00,436),('5','271','219','2',870.00,870.00,1142.72,0.00,0.00,0.00,0.00,437),('5','271','219','1',185.00,185.00,27017.31,0.00,0.00,0.00,0.00,438),('5','271','220','2',870.00,870.00,562.61,0.00,0.00,0.00,0.00,439),('5','271','220','1',185.00,185.00,18527.08,0.00,0.00,0.00,0.00,440),('5','271','221','2',870.00,870.00,757.78,0.00,0.00,0.00,0.00,441),('5','271','221','1',185.00,185.00,16567.54,0.00,0.00,0.00,0.00,442),('5','271','222','2',870.00,870.00,1045.66,0.00,0.00,0.00,0.00,443),('5','271','222','1',185.00,185.00,15306.26,0.00,0.00,0.00,0.00,444),('5','271','223','2',870.00,870.00,1233.73,0.00,0.00,0.00,0.00,445),('5','271','223','1',185.00,185.00,12175.99,0.00,0.00,0.00,0.00,446),('5','271','224','2',870.00,870.00,773.68,0.00,0.00,0.00,0.00,447),('5','271','224','1',185.00,185.00,2813.23,0.00,0.00,0.00,0.00,448),('5','271','225','2',870.00,870.00,927.77,0.00,0.00,0.00,0.00,449),('5','271','225','1',185.00,185.00,17840.89,0.00,0.00,0.00,0.00,450),('5','271','226','2',870.00,870.00,156.45,0.00,0.00,0.00,0.00,451),('5','271','226','1',185.00,185.00,13740.48,0.00,0.00,0.00,0.00,452),('5','271','227','2',870.00,870.00,4377.96,0.00,0.00,0.00,0.00,453),('5','271','227','1',185.00,185.00,5144.07,0.00,0.00,0.00,0.00,454),('5','271','228','2',870.00,870.00,853.97,0.00,0.00,0.00,0.00,455),('5','271','228','1',185.00,185.00,15058.27,0.00,0.00,0.00,0.00,456),('5','271','229','2',870.00,870.00,2547.31,0.00,0.00,0.00,0.00,457),('5','271','229','1',185.00,185.00,21728.10,0.00,0.00,0.00,0.00,458),('5','271','230','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,459),('5','271','230','1',185.00,185.00,20925.82,0.00,0.00,0.00,0.00,460),('5','271','231','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,461),('5','271','231','1',185.00,185.00,3592.61,0.00,0.00,0.00,0.00,462),('5','271','232','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,463),('5','271','232','1',185.00,185.00,19727.89,0.00,0.00,0.00,0.00,464),('5','271','233','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,465),('5','271','233','1',185.00,185.00,27567.95,0.00,0.00,0.00,0.00,466),('5','271','234','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,467),('5','271','234','1',185.00,185.00,29014.78,0.00,0.00,0.00,0.00,468),('5','271','235','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,469),('5','271','235','1',185.00,185.00,29604.07,0.00,0.00,0.00,0.00,470),('5','271','236','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,471),('5','271','236','1',185.00,185.00,31467.21,0.00,0.00,0.00,0.00,472),('5','271','237','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,473),('5','271','237','1',185.00,185.00,27194.64,0.00,0.00,0.00,0.00,474),('5','271','238','2',870.00,870.00,0.00,0.00,0.00,0.00,0.00,475),('5','271','238','1',185.00,185.00,9342.18,0.00,0.00,0.00,0.00,476),('5','271','239','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,477),('5','271','239','1',185.00,185.00,11087.15,0.00,0.00,0.00,0.00,478),('5','271','240','2',885.00,885.00,10.16,0.00,0.00,0.00,0.00,479),('5','271','240','1',185.00,185.00,2237.87,0.00,0.00,0.00,0.00,480),('5','271','241','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,481),('5','271','241','1',185.00,185.00,126.03,0.00,0.00,0.00,0.00,482),('5','271','242','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,483),('5','271','242','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,484),('5','271','243','2',885.00,885.00,49.45,0.00,0.00,0.00,0.00,485),('5','271','243','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,486),('5','271','244','2',885.00,885.00,1417.24,0.00,0.00,0.00,0.00,487),('5','271','244','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,488),('5','271','245','2',885.00,885.00,62.68,0.00,0.00,0.00,0.00,489),('5','271','245','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,490),('5','271','246','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,491),('5','271','246','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,492),('5','271','247','2',885.00,885.00,515.67,0.00,0.00,0.00,0.00,493),('5','271','247','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,494),('5','271','248','2',885.00,885.00,1000.38,0.00,0.00,0.00,0.00,495),('5','271','248','1',185.00,185.00,21755.93,0.00,0.00,0.00,0.00,496),('5','271','249','2',885.00,885.00,409.95,0.00,0.00,0.00,0.00,497),('5','271','249','1',185.00,185.00,23926.04,0.00,0.00,0.00,0.00,498),('5','271','250','2',885.00,885.00,404.24,0.00,0.00,0.00,0.00,499),('5','271','250','1',185.00,185.00,25132.32,0.00,0.00,0.00,0.00,500),('5','271','251','2',885.00,885.00,645.20,0.00,0.00,0.00,0.00,501),('5','271','251','1',185.00,185.00,27999.65,0.00,0.00,0.00,0.00,502),('5','271','252','2',885.00,885.00,737.31,0.00,0.00,0.00,0.00,503),('5','271','252','1',185.00,185.00,28859.48,0.00,0.00,0.00,0.00,504),('5','271','253','2',885.00,885.00,536.86,0.00,0.00,0.00,0.00,505),('5','271','253','1',185.00,185.00,14859.63,0.00,0.00,0.00,0.00,506),('5','271','254','2',885.00,885.00,104.89,0.00,0.00,0.00,0.00,507),('5','271','254','1',185.00,185.00,16088.71,0.00,0.00,0.00,0.00,508),('5','271','255','2',885.00,885.00,128.18,0.00,0.00,0.00,0.00,509),('5','271','255','1',185.00,185.00,5949.04,0.00,0.00,0.00,0.00,510),('5','271','256','2',885.00,885.00,422.73,0.00,0.00,0.00,0.00,511),('5','271','256','1',185.00,185.00,18404.86,0.00,0.00,0.00,0.00,512),('5','271','257','2',885.00,885.00,716.88,0.00,0.00,0.00,0.00,513),('5','271','257','1',185.00,185.00,3255.09,0.00,0.00,0.00,0.00,514),('5','271','258','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,515),('5','271','258','1',185.00,185.00,1672.60,0.00,0.00,0.00,0.00,516),('5','271','259','2',885.00,885.00,350.87,0.00,0.00,0.00,0.00,517),('5','271','259','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,518),('5','271','260','2',885.00,885.00,0.00,0.00,0.00,0.00,0.00,519),('5','271','260','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,520),('5','271','261','2',885.00,885.00,296.69,0.00,0.00,0.00,0.00,521),('5','271','261','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,522),('5','271','262','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,523),('5','271','262','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,524),('5','271','263','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,525),('5','271','263','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,526),('5','271','264','2',860.00,860.00,239.41,0.00,0.00,0.00,0.00,527),('5','271','264','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,528),('5','271','265','2',860.00,860.00,849.05,0.00,0.00,0.00,0.00,529),('5','271','265','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,530),('5','271','266','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,531),('5','271','266','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,532),('5','271','267','2',860.00,860.00,271.00,0.00,0.00,0.00,0.00,533),('5','271','267','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,534),('5','271','268','2',860.00,860.00,1541.64,0.00,0.00,0.00,0.00,535),('5','271','268','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,536),('5','271','269','2',860.00,860.00,474.47,0.00,0.00,0.00,0.00,537),('5','271','269','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,538),('5','271','270','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,539),('5','271','270','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,540),('5','271','271','2',860.00,860.00,342.26,0.00,0.00,0.00,0.00,541),('5','271','271','1',185.00,185.00,31286.67,0.00,0.00,0.00,0.00,542),('5','271','272','2',860.00,860.00,154.37,0.00,0.00,0.00,0.00,543),('5','271','272','1',185.00,185.00,13505.30,0.00,0.00,0.00,0.00,544),('5','271','273','2',860.00,860.00,0.00,0.00,0.00,0.00,0.00,545),('5','271','273','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,546),('5','271','274','2',860.00,860.00,86.28,0.00,0.00,0.00,0.00,547),('5','271','274','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,548),('5','271','275','2',830.00,830.00,579.97,0.00,0.00,0.00,0.00,549),('5','271','275','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,550),('5','271','276','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,551),('5','271','276','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,552),('5','271','277','2',830.00,830.00,608.09,0.00,0.00,0.00,0.00,553),('5','271','277','1',185.00,185.00,16837.62,0.00,0.00,0.00,0.00,554),('5','271','278','2',830.00,830.00,778.42,0.00,0.00,0.00,0.00,555),('5','271','278','1',185.00,185.00,24417.35,0.00,0.00,0.00,0.00,556),('5','271','279','2',830.00,830.00,583.10,0.00,0.00,0.00,0.00,557),('5','271','279','1',185.00,185.00,16466.52,0.00,0.00,0.00,0.00,558),('5','271','280','2',830.00,830.00,147.31,0.00,0.00,0.00,0.00,559),('5','271','280','1',185.00,185.00,13751.10,0.00,0.00,0.00,0.00,560),('5','271','281','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,561),('5','271','281','1',185.00,185.00,949.66,0.00,0.00,0.00,0.00,562),('5','271','282','2',830.00,830.00,286.39,0.00,0.00,0.00,0.00,563),('5','271','282','1',220.00,220.00,1573.78,0.00,0.00,0.00,0.00,564),('5','271','283','2',830.00,830.00,620.43,0.00,0.00,0.00,0.00,565),('5','271','283','1',220.00,220.00,15758.15,0.00,0.00,0.00,0.00,566),('5','271','284','2',830.00,830.00,609.44,0.00,0.00,0.00,0.00,567),('5','271','284','1',220.00,220.00,22068.91,0.00,0.00,0.00,0.00,568),('5','271','285','2',830.00,830.00,460.18,0.00,0.00,0.00,0.00,569),('5','271','285','1',220.00,220.00,20050.22,0.00,0.00,0.00,0.00,570),('5','271','286','2',830.00,830.00,3398.23,0.00,0.00,0.00,0.00,571),('5','271','286','1',220.00,220.00,13176.12,0.00,0.00,0.00,0.00,572),('5','271','287','2',830.00,830.00,1401.31,0.00,0.00,0.00,0.00,573),('5','271','287','1',220.00,220.00,4573.36,0.00,0.00,0.00,0.00,574),('5','271','288','2',830.00,830.00,370.63,0.00,0.00,0.00,0.00,575),('5','271','288','1',220.00,220.00,1125.51,0.00,0.00,0.00,0.00,576),('5','271','289','2',830.00,830.00,154.52,0.00,0.00,0.00,0.00,577),('5','271','289','1',220.00,220.00,17003.57,0.00,0.00,0.00,0.00,578),('5','271','290','2',830.00,830.00,412.71,0.00,0.00,0.00,0.00,579),('5','271','290','1',220.00,220.00,19148.90,0.00,0.00,0.00,0.00,580),('5','271','291','2',830.00,830.00,271.14,0.00,0.00,0.00,0.00,581),('5','271','291','1',220.00,220.00,2272.67,0.00,0.00,0.00,0.00,582),('5','271','292','2',830.00,830.00,277.80,0.00,0.00,0.00,0.00,583),('5','271','292','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,584),('5','271','293','2',830.00,830.00,309.26,0.00,0.00,0.00,0.00,585),('5','271','293','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,586),('5','271','294','2',830.00,830.00,57.32,0.00,0.00,0.00,0.00,587),('5','271','294','1',220.00,220.00,32354.26,0.00,0.00,0.00,0.00,588),('5','271','295','2',830.00,830.00,49.50,0.00,0.00,0.00,0.00,589),('5','271','295','1',220.00,220.00,17846.69,0.00,0.00,0.00,0.00,590),('5','271','296','2',830.00,830.00,454.63,0.00,0.00,0.00,0.00,591),('5','271','296','1',220.00,220.00,18400.23,0.00,0.00,0.00,0.00,592),('5','271','297','2',830.00,830.00,68.28,0.00,0.00,0.00,0.00,593),('5','271','297','1',220.00,220.00,4058.91,0.00,0.00,0.00,0.00,594),('5','271','298','2',830.00,830.00,2574.48,0.00,0.00,0.00,0.00,595),('5','271','298','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,596),('5','271','299','2',830.00,830.00,167.39,0.00,0.00,0.00,0.00,597),('5','271','299','1',220.00,220.00,2879.63,0.00,0.00,0.00,0.00,598),('5','271','300','2',830.00,830.00,267.44,0.00,0.00,0.00,0.00,599),('5','271','300','1',220.00,220.00,25891.14,0.00,0.00,0.00,0.00,600),('5','271','301','2',830.00,830.00,3500.80,0.00,0.00,0.00,0.00,601),('5','271','301','1',220.00,220.00,17743.64,0.00,0.00,0.00,0.00,602),('5','271','302','2',830.00,830.00,363.61,0.00,0.00,0.00,0.00,603),('5','271','302','1',220.00,220.00,26123.14,0.00,0.00,0.00,0.00,604),('5','271','303','2',830.00,830.00,19.92,0.00,0.00,0.00,0.00,605),('5','271','303','1',220.00,220.00,17611.16,0.00,0.00,0.00,0.00,606),('5','271','304','2',830.00,830.00,1365.90,0.00,0.00,0.00,0.00,607),('5','271','304','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,608),('5','271','305','2',830.00,830.00,253.63,0.00,0.00,0.00,0.00,609),('5','271','305','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,610),('5','271','306','2',830.00,830.00,654.08,0.00,0.00,0.00,0.00,611),('5','271','306','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,612),('5','271','307','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,613),('5','271','307','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,614),('5','271','308','2',830.00,830.00,1315.25,0.00,0.00,0.00,0.00,615),('5','271','308','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,616),('5','271','309','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,617),('5','271','309','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,618),('5','271','310','2',830.00,830.00,0.00,0.00,0.00,0.00,0.00,619),('5','271','310','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,620),('5','271','311','2',830.00,830.00,208.90,0.00,0.00,0.00,0.00,621),('5','271','311','1',220.00,220.00,0.00,0.00,0.00,0.00,0.00,622),('5','271','312','2',830.00,830.00,15.66,0.00,0.00,0.00,0.00,623),('5','271','312','1',210.00,210.00,1916.19,0.00,0.00,0.00,0.00,624),('5','271','313','2',820.00,820.00,1232.74,0.00,0.00,0.00,0.00,625),('5','271','313','1',210.00,210.00,38064.57,0.00,0.00,0.00,0.00,626),('5','271','314','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,627),('5','271','314','1',210.00,210.00,9185.84,0.00,0.00,0.00,0.00,628),('5','271','315','2',820.00,820.00,111.76,0.00,0.00,0.00,0.00,629),('5','271','315','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,630),('5','271','316','2',820.00,820.00,116.97,0.00,0.00,0.00,0.00,631),('5','271','316','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,632),('5','271','317','2',820.00,820.00,189.90,0.00,0.00,0.00,0.00,633),('5','271','317','1',210.00,210.00,28549.20,0.00,0.00,0.00,0.00,634),('5','271','318','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,635),('5','271','318','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,636),('5','271','319','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,637),('5','271','319','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,638),('5','271','320','2',820.00,820.00,331.22,0.00,0.00,0.00,0.00,639),('5','271','320','1',210.00,210.00,30899.67,0.00,0.00,0.00,0.00,640),('5','271','321','2',820.00,820.00,282.66,0.00,0.00,0.00,0.00,641),('5','271','321','1',210.00,210.00,34918.49,0.00,0.00,0.00,0.00,642),('5','271','322','2',820.00,820.00,1581.86,0.00,0.00,0.00,0.00,643),('5','271','322','1',210.00,210.00,33741.78,0.00,0.00,0.00,0.00,644),('5','271','323','2',820.00,820.00,3676.90,0.00,0.00,0.00,0.00,645),('5','271','323','1',210.00,210.00,44378.33,0.00,0.00,0.00,0.00,646),('5','271','324','2',820.00,820.00,171.24,0.00,0.00,0.00,0.00,647),('5','271','324','1',210.00,210.00,45887.64,0.00,0.00,0.00,0.00,648),('5','271','325','2',820.00,820.00,2959.74,0.00,0.00,0.00,0.00,649),('5','271','325','1',210.00,210.00,54015.05,0.00,0.00,0.00,0.00,650),('5','271','326','2',820.00,820.00,374.52,0.00,0.00,0.00,0.00,651),('5','271','326','1',210.00,210.00,48011.09,0.00,0.00,0.00,0.00,652),('5','271','327','2',820.00,820.00,737.22,0.00,0.00,0.00,0.00,653),('5','271','327','1',210.00,210.00,40257.36,0.00,0.00,0.00,0.00,654),('5','271','328','2',820.00,820.00,594.84,0.00,0.00,0.00,0.00,655),('5','271','328','1',210.00,210.00,51556.40,0.00,0.00,0.00,0.00,656),('5','271','329','2',820.00,820.00,1562.89,0.00,0.00,0.00,0.00,657),('5','271','329','1',210.00,210.00,56278.14,0.00,0.00,0.00,0.00,658),('5','271','330','2',820.00,820.00,318.46,0.00,0.00,0.00,0.00,659),('5','271','330','1',210.00,210.00,48194.30,0.00,0.00,0.00,0.00,660),('5','271','331','2',820.00,820.00,1802.37,0.00,0.00,0.00,0.00,661),('5','271','331','1',210.00,210.00,30839.42,0.00,0.00,0.00,0.00,662),('5','271','332','2',820.00,820.00,67.03,0.00,0.00,0.00,0.00,663),('5','271','332','1',210.00,210.00,10083.95,0.00,0.00,0.00,0.00,664),('5','271','333','2',820.00,820.00,40.19,0.00,0.00,0.00,0.00,665),('5','271','333','1',210.00,210.00,4832.39,0.00,0.00,0.00,0.00,666),('5','271','334','2',820.00,820.00,411.30,0.00,0.00,0.00,0.00,667),('5','271','334','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,668),('5','271','335','2',820.00,820.00,154.00,0.00,0.00,0.00,0.00,669),('5','271','335','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,670),('5','271','336','2',820.00,820.00,45.38,0.00,0.00,0.00,0.00,671),('5','271','336','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,672),('5','271','337','2',820.00,820.00,710.27,0.00,0.00,0.00,0.00,673),('5','271','337','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,674),('5','271','338','2',820.00,820.00,372.77,0.00,0.00,0.00,0.00,675),('5','271','338','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,676),('5','271','339','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,677),('5','271','339','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,678),('5','271','340','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,679),('5','271','340','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,680),('5','271','341','2',820.00,820.00,0.00,0.00,0.00,0.00,0.00,681),('5','271','341','1',210.00,210.00,0.00,0.00,0.00,0.00,0.00,682);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',1,'271','PRODUCT TANK','PMS'),('5',2,'271','AGO TANK','AGO');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','271','1',1,0,'1','TANK 1',50000.00,0.00,NULL,'','446','2022-06-02 10:12:24','2022-06-02 10:12:24','446',5,0),('5','271','1',2,0,'1','TANK 2',50000.00,0.00,NULL,'PMS TANK 2','446','2022-06-02 10:14:39','2022-06-02 10:14:39','446',5,0),('5','271','1',3,0,'1','TANK 3',50000.00,0.00,NULL,'PMS TANK 3','446','2022-06-02 10:15:25','2022-06-02 10:15:25','446',5,0),('5','271','1',4,0,'1','TANK 4',50000.00,0.00,NULL,'PMS TANK 4','446','2022-06-02 10:16:12','2022-06-02 10:16:12','446',5,0),('5','271','1',5,0,'2','AGO TANK 5',50000.00,0.00,NULL,'AGO TANK ','446','2022-06-02 10:16:49','2022-06-02 10:16:49','446',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','271',5,11982.88,'2023-03-21 00:59:06'),(2,'5','271',4,418.55,'2023-03-21 00:59:06'),(3,'5','271',3,270.77,'2023-03-21 00:59:06'),(4,'5','271',2,2561.85,'2023-03-21 00:59:06'),(5,'5','271',1,326.02,'2023-03-21 00:59:06');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3360 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'5','271','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-06-06 09:50:41','',''),(2,'5','271','1',0,'Inventory adjustment from tank dipping to 9950',0.00,0.00,9950.00,0.00,0.00,'2022-06-06 09:50:41','',''),(3,'5','271','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-06-06 09:51:15','',''),(4,'5','271','2',0,'Inventory adjustment from tank dipping to 7100',0.00,0.00,7100.00,0.00,0.00,'2022-06-06 09:51:15','',''),(5,'5','271','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-06-06 09:51:49','',''),(6,'5','271','3',0,'Inventory adjustment from tank dipping to 14500',0.00,0.00,14500.00,0.00,0.00,'2022-06-06 09:51:49','',''),(7,'5','271','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-06-06 09:52:11','',''),(8,'5','271','4',0,'Inventory adjustment from tank dipping to 650',0.00,0.00,650.00,0.00,0.00,'2022-06-06 09:52:11','',''),(9,'5','271','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-06-06 09:52:30','',''),(10,'5','271','5',0,'Inventory adjustment from tank dipping to 250',0.00,0.00,250.00,0.00,0.00,'2022-06-06 09:52:30','',''),(11,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,28578000.00,173200.00,0.00,0.00,'2022-06-07 09:37:34','',''),(12,'5','271',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,39400.00,0.00,'2022-06-07 09:42:32','',''),(13,'5','271','4',1,'Received from bridging 4',0.00,0.00,39400.00,0.00,0.00,'2022-06-07 09:42:32','',''),(14,'5','271','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,9950.00,0.00,'2022-06-07 09:44:26','',''),(15,'5','271','1',0,'Inventory adjustment from tank dipping to 10',0.00,0.00,10.00,0.00,0.00,'2022-06-07 09:44:26','',''),(16,'5','271','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,7100.00,0.00,'2022-06-07 09:44:41','',''),(17,'5','271','2',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-06-07 09:44:41','',''),(18,'5','271','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,10.00,0.00,'2022-06-07 09:44:54','',''),(19,'5','271','1',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-06-07 09:44:54','',''),(20,'5','271','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,14500.00,0.00,'2022-06-07 09:45:07','',''),(21,'5','271','3',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-06-07 09:45:07','',''),(22,'5','271',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,44980.00,0.00,'2022-06-07 09:45:24','',''),(23,'5','271','3',1,'Received from bridging 3',0.00,0.00,44980.00,0.00,0.00,'2022-06-07 09:45:24','',''),(24,'5','271',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,44400.00,0.00,'2022-06-07 09:45:24','',''),(25,'5','271','2',1,'Received from bridging 2',0.00,0.00,44400.00,0.00,0.00,'2022-06-07 09:45:24','',''),(26,'5','271',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,44420.00,0.00,'2022-06-07 09:45:24','',''),(27,'5','271','1',1,'Received from bridging 1',0.00,0.00,44420.00,0.00,0.00,'2022-06-07 09:45:24','',''),(28,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,4023.09,0.00,'2022-06-07 15:38:17','',''),(29,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,2720.46,0.00,'2022-06-07 15:38:17','',''),(30,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,2078.17,0.00,'2022-06-07 15:38:17','',''),(31,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,2346.32,0.00,'2022-06-07 15:38:17','',''),(32,'5','271','3',1,'Sale Id shift 2',0.00,0.00,0.00,261.39,0.00,'2022-06-07 15:38:17','',''),(33,'5','271','3',1,'Sale Id shift 2',0.00,0.00,0.00,464.94,0.00,'2022-06-07 15:38:17','',''),(34,'5','271','3',1,'Sale Id shift 2',0.00,0.00,0.00,2631.94,0.00,'2022-06-07 15:38:17','',''),(35,'5','271','3',1,'Sale Id shift 2',0.00,0.00,0.00,1421.02,0.00,'2022-06-07 15:38:17','',''),(36,'5','271','4',1,'Sale Id shift 2',0.00,0.00,0.00,4509.36,0.00,'2022-06-07 15:38:17','',''),(37,'5','271','4',1,'Sale Id shift 2',0.00,0.00,0.00,4995.11,0.00,'2022-06-07 15:38:17','',''),(38,'5','271','4',1,'Sale Id shift 2',0.00,0.00,0.00,1968.70,0.00,'2022-06-07 15:38:17','',''),(39,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,4137.34,0.00,'2022-06-07 15:38:17','',''),(40,'5','271','4',1,'Sale Id shift 2',0.00,0.00,0.00,1771.25,0.00,'2022-06-07 15:38:17','',''),(41,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,4416.79,0.00,'2022-06-07 15:38:17','',''),(42,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,3563.86,0.00,'2022-06-07 15:38:17','',''),(43,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,3899.07,0.00,'2022-06-07 15:38:17','',''),(44,'5','271','1',1,'Sale Id shift 2',0.00,0.00,0.00,2667.40,0.00,'2022-06-07 15:38:17','',''),(45,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,2890.26,0.00,'2022-06-07 15:38:17','',''),(46,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,1974.10,0.00,'2022-06-07 15:38:17','',''),(47,'5','271','2',1,'Sale Id shift 2',0.00,0.00,0.00,2634.15,0.00,'2022-06-07 15:38:17','',''),(48,'5','271',NULL,1,'Sale Id shift 2',9136828.80,0.00,0.00,0.00,0.00,'2022-06-07 15:38:17','',''),(49,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-07 16:25:21','',''),(50,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 10:32:00','',''),(51,'5','271',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,25000.00,0.00,'2022-06-08 10:37:15','',''),(52,'5','271','1',1,'Received from bridging 5',0.00,0.00,25000.00,0.00,0.00,'2022-06-08 10:37:15','',''),(53,'5','271',NULL,2,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,26400000.00,40000.00,0.00,0.00,'2022-06-08 10:44:22','',''),(54,'5','271',NULL,2,'Reception corrector for bridging 6',0.00,0.00,0.00,40000.00,0.00,'2022-06-08 10:54:58','',''),(55,'5','271','5',2,'Received from bridging 6',0.00,0.00,40000.00,0.00,0.00,'2022-06-08 10:54:58','',''),(56,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,5080.91,0.00,'2022-06-08 10:56:16','',''),(57,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,3809.88,0.00,'2022-06-08 10:56:16','',''),(58,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,2461.51,0.00,'2022-06-08 10:56:16','',''),(59,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,1427.47,0.00,'2022-06-08 10:56:16','',''),(60,'5','271','3',1,'Sale Id shift 3',0.00,0.00,0.00,3293.40,0.00,'2022-06-08 10:56:16','',''),(61,'5','271','3',1,'Sale Id shift 3',0.00,0.00,0.00,3352.81,0.00,'2022-06-08 10:56:16','',''),(62,'5','271','4',1,'Sale Id shift 3',0.00,0.00,0.00,5608.86,0.00,'2022-06-08 10:56:16','',''),(63,'5','271','4',1,'Sale Id shift 3',0.00,0.00,0.00,6087.03,0.00,'2022-06-08 10:56:16','',''),(64,'5','271','4',1,'Sale Id shift 3',0.00,0.00,0.00,4152.33,0.00,'2022-06-08 10:56:16','',''),(65,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,4970.36,0.00,'2022-06-08 10:56:16','',''),(66,'5','271','4',1,'Sale Id shift 3',0.00,0.00,0.00,4112.88,0.00,'2022-06-08 10:56:16','',''),(67,'5','271','5',2,'Sale Id shift 3',0.00,0.00,0.00,492.91,0.00,'2022-06-08 10:56:16','',''),(68,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,2972.59,0.00,'2022-06-08 10:56:16','',''),(69,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,1618.01,0.00,'2022-06-08 10:56:16','',''),(70,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,4051.29,0.00,'2022-06-08 10:56:16','',''),(71,'5','271','1',1,'Sale Id shift 3',0.00,0.00,0.00,2903.75,0.00,'2022-06-08 10:56:16','',''),(72,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,3012.60,0.00,'2022-06-08 10:56:16','',''),(73,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,4271.20,0.00,'2022-06-08 10:56:16','',''),(74,'5','271','2',1,'Sale Id shift 3',0.00,0.00,0.00,4681.38,0.00,'2022-06-08 10:56:16','',''),(75,'5','271',NULL,2,'Sale Id shift 3',325320.60,0.00,0.00,0.00,0.00,'2022-06-08 10:56:16','',''),(76,'5','271',NULL,1,'Sale Id shift 3',11198262.90,0.00,0.00,0.00,0.00,'2022-06-08 10:56:16','',''),(77,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 11:05:48','',''),(78,'5','271',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,43000.00,0.00,'2022-06-08 11:26:03','',''),(79,'5','271','4',1,'Received from bridging 8',0.00,0.00,43000.00,0.00,0.00,'2022-06-08 11:26:03','',''),(80,'5','271',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,20000.00,0.00,'2022-06-08 11:32:18','',''),(81,'5','271','1',1,'Received from bridging 10',0.00,0.00,20000.00,0.00,0.00,'2022-06-08 11:32:18','',''),(82,'5','271',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,39000.00,0.00,'2022-06-08 11:47:35','',''),(83,'5','271','2',1,'Received from bridging 12',0.00,0.00,39000.00,0.00,0.00,'2022-06-08 11:47:35','',''),(84,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,6294.13,0.00,'2022-06-08 11:49:00','',''),(85,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,3194.05,0.00,'2022-06-08 11:49:00','',''),(86,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,199.94,0.00,'2022-06-08 11:49:00','',''),(87,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,189.35,0.00,'2022-06-08 11:49:00','',''),(88,'5','271','3',1,'Sale Id shift 4',0.00,0.00,0.00,8007.64,0.00,'2022-06-08 11:49:00','',''),(89,'5','271','3',1,'Sale Id shift 4',0.00,0.00,0.00,7181.92,0.00,'2022-06-08 11:49:00','',''),(90,'5','271','4',1,'Sale Id shift 4',0.00,0.00,0.00,1966.04,0.00,'2022-06-08 11:49:00','',''),(91,'5','271','4',1,'Sale Id shift 4',0.00,0.00,0.00,3597.08,0.00,'2022-06-08 11:49:00','',''),(92,'5','271','4',1,'Sale Id shift 4',0.00,0.00,0.00,1507.09,0.00,'2022-06-08 11:49:00','',''),(93,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,9977.90,0.00,'2022-06-08 11:49:00','',''),(94,'5','271','4',1,'Sale Id shift 4',0.00,0.00,0.00,4219.11,0.00,'2022-06-08 11:49:00','',''),(95,'5','271','5',2,'Sale Id shift 4',0.00,0.00,0.00,3136.62,0.00,'2022-06-08 11:49:00','',''),(96,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,7368.30,0.00,'2022-06-08 11:49:00','',''),(97,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,27.13,0.00,'2022-06-08 11:49:00','',''),(98,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,4850.49,0.00,'2022-06-08 11:49:00','',''),(99,'5','271','1',1,'Sale Id shift 4',0.00,0.00,0.00,4203.63,0.00,'2022-06-08 11:49:00','',''),(100,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,2636.26,0.00,'2022-06-08 11:49:00','',''),(101,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,2450.61,0.00,'2022-06-08 11:49:00','',''),(102,'5','271','2',1,'Sale Id shift 4',0.00,0.00,0.00,3811.60,0.00,'2022-06-08 11:49:00','',''),(103,'5','271',NULL,2,'Sale Id shift 4',2070169.20,0.00,0.00,0.00,0.00,'2022-06-08 11:49:00','',''),(104,'5','271',NULL,1,'Sale Id shift 4',11827574.55,0.00,0.00,0.00,0.00,'2022-06-08 11:49:00','',''),(105,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7416750.00,44950.00,0.00,0.00,'2022-06-08 12:03:18','',''),(106,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9883500.00,59900.00,0.00,0.00,'2022-06-08 12:04:18','',''),(107,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 12:04:36','',''),(108,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7363785.00,44629.00,0.00,0.00,'2022-06-08 12:23:18','',''),(109,'5','271',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,37000.00,0.00,'2022-06-08 12:28:06','',''),(110,'5','271','1',1,'Received from bridging 14',0.00,0.00,37000.00,0.00,0.00,'2022-06-08 12:28:06','',''),(111,'5','271',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,2000.00,0.00,'2022-06-08 12:28:35','',''),(112,'5','271','4',1,'Received from bridging 13',0.00,0.00,2000.00,0.00,0.00,'2022-06-08 12:28:35','',''),(113,'5','271','1',1,'Sale Id shift 5',0.00,0.00,0.00,4435.64,0.00,'2022-06-08 12:32:13','',''),(114,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,4123.71,0.00,'2022-06-08 12:32:13','',''),(115,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,3144.42,0.00,'2022-06-08 12:32:13','',''),(116,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,3905.33,0.00,'2022-06-08 12:32:13','',''),(117,'5','271','3',1,'Sale Id shift 5',0.00,0.00,0.00,6160.45,0.00,'2022-06-08 12:32:13','',''),(118,'5','271','3',1,'Sale Id shift 5',0.00,0.00,0.00,3990.89,0.00,'2022-06-08 12:32:13','',''),(119,'5','271','4',1,'Sale Id shift 5',0.00,0.00,0.00,4421.05,0.00,'2022-06-08 12:32:13','',''),(120,'5','271','4',1,'Sale Id shift 5',0.00,0.00,0.00,6006.55,0.00,'2022-06-08 12:32:13','',''),(121,'5','271','4',1,'Sale Id shift 5',0.00,0.00,0.00,4575.32,0.00,'2022-06-08 12:32:13','',''),(122,'5','271','1',1,'Sale Id shift 5',0.00,0.00,0.00,4892.47,0.00,'2022-06-08 12:32:13','',''),(123,'5','271','4',1,'Sale Id shift 5',0.00,0.00,0.00,2566.56,0.00,'2022-06-08 12:32:13','',''),(124,'5','271','5',2,'Sale Id shift 5',0.00,0.00,0.00,1735.99,0.00,'2022-06-08 12:32:13','',''),(125,'5','271','1',1,'Sale Id shift 5',0.00,0.00,0.00,912.12,0.00,'2022-06-08 12:32:13','',''),(126,'5','271','1',1,'Sale Id shift 5',0.00,0.00,0.00,5087.92,0.00,'2022-06-08 12:32:13','',''),(127,'5','271','1',1,'Sale Id shift 5',0.00,0.00,0.00,2616.37,0.00,'2022-06-08 12:32:13','',''),(128,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,6877.44,0.00,'2022-06-08 12:32:13','',''),(129,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,6281.30,0.00,'2022-06-08 12:32:13','',''),(130,'5','271','2',1,'Sale Id shift 5',0.00,0.00,0.00,4360.77,0.00,'2022-06-08 12:32:13','',''),(131,'5','271',NULL,2,'Sale Id shift 5',1145753.40,0.00,0.00,0.00,0.00,'2022-06-08 12:32:13','',''),(132,'5','271',NULL,1,'Sale Id shift 5',12269121.15,0.00,0.00,0.00,0.00,'2022-06-08 12:32:13','',''),(133,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 19:57:54','',''),(134,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9891750.00,59950.00,0.00,0.00,'2022-06-09 19:58:15','',''),(135,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7401075.00,44855.00,0.00,0.00,'2022-06-09 19:58:49','',''),(136,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6517500.00,39500.00,0.00,0.00,'2022-06-09 19:59:03','',''),(137,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-09 19:59:15','',''),(138,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 20:03:03','',''),(139,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-09 20:03:17','',''),(140,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6550500.00,39700.00,0.00,0.00,'2022-06-09 20:03:31','',''),(141,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 20:03:45','',''),(142,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-09 20:04:05','',''),(143,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-09 20:04:19','',''),(144,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-09 20:04:43','',''),(145,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7375500.00,44700.00,0.00,0.00,'2022-06-09 20:04:59','',''),(146,'5','271',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,6000.00,0.00,'2022-06-10 12:01:43','',''),(147,'5','271','2',1,'Received from bridging 17',0.00,0.00,6000.00,0.00,0.00,'2022-06-10 12:01:43','',''),(148,'5','271',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,7950.00,0.00,'2022-06-10 12:01:54','',''),(149,'5','271','1',1,'Received from bridging 16',0.00,0.00,7950.00,0.00,0.00,'2022-06-10 12:01:54','',''),(150,'5','271',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,10000.00,0.00,'2022-06-10 15:37:00','',''),(151,'5','271','1',1,'Received from bridging 18',0.00,0.00,10000.00,0.00,0.00,'2022-06-10 15:37:00','',''),(152,'5','271',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,36000.00,0.00,'2022-06-10 15:37:13','',''),(153,'5','271','2',1,'Received from bridging 19',0.00,0.00,36000.00,0.00,0.00,'2022-06-10 15:37:13','',''),(154,'5','271',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,41000.00,0.00,'2022-06-10 15:37:26','',''),(155,'5','271','3',1,'Received from bridging 20',0.00,0.00,41000.00,0.00,0.00,'2022-06-10 15:37:26','',''),(156,'5','271',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,27000.00,0.00,'2022-06-10 15:37:37','',''),(157,'5','271','4',1,'Received from bridging 21',0.00,0.00,27000.00,0.00,0.00,'2022-06-10 15:37:37','',''),(158,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,5281.22,0.00,'2022-06-11 09:34:50','',''),(159,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,6790.08,0.00,'2022-06-11 09:34:50','',''),(160,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,4456.22,0.00,'2022-06-11 09:34:50','',''),(161,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,2252.20,0.00,'2022-06-11 09:34:50','',''),(162,'5','271','3',1,'Sale Id shift 6',0.00,0.00,0.00,4027.94,0.00,'2022-06-11 09:34:50','',''),(163,'5','271','3',1,'Sale Id shift 6',0.00,0.00,0.00,3784.67,0.00,'2022-06-11 09:34:50','',''),(164,'5','271','4',1,'Sale Id shift 6',0.00,0.00,0.00,3608.61,0.00,'2022-06-11 09:34:50','',''),(165,'5','271','4',1,'Sale Id shift 6',0.00,0.00,0.00,8158.50,0.00,'2022-06-11 09:34:50','',''),(166,'5','271','4',1,'Sale Id shift 6',0.00,0.00,0.00,6343.26,0.00,'2022-06-11 09:34:50','',''),(167,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,5418.90,0.00,'2022-06-11 09:34:50','',''),(168,'5','271','4',1,'Sale Id shift 6',0.00,0.00,0.00,3600.58,0.00,'2022-06-11 09:34:50','',''),(169,'5','271','5',2,'Sale Id shift 6',0.00,0.00,0.00,2413.56,0.00,'2022-06-11 09:34:50','',''),(170,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,6440.76,0.00,'2022-06-11 09:34:50','',''),(171,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,4.50,0.00,'2022-06-11 09:34:50','',''),(172,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,8087.34,0.00,'2022-06-11 09:34:50','',''),(173,'5','271','1',1,'Sale Id shift 6',0.00,0.00,0.00,5890.68,0.00,'2022-06-11 09:34:50','',''),(174,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,2892.99,0.00,'2022-06-11 09:34:50','',''),(175,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,5718.46,0.00,'2022-06-11 09:34:50','',''),(176,'5','271','2',1,'Sale Id shift 6',0.00,0.00,0.00,5677.28,0.00,'2022-06-11 09:34:50','',''),(177,'5','271',NULL,2,'Sale Id shift 6',1592949.60,0.00,0.00,0.00,0.00,'2022-06-11 09:34:50','',''),(178,'5','271',NULL,1,'Sale Id shift 6',14591641.35,0.00,0.00,0.00,0.00,'2022-06-11 09:34:50','',''),(179,'5','271',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,17629.00,0.00,'2022-06-11 20:32:03','',''),(180,'5','271','4',1,'Received from bridging 22',0.00,0.00,17629.00,0.00,0.00,'2022-06-11 20:32:03','',''),(181,'5','271',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,8900.00,0.00,'2022-06-11 20:32:11','',''),(182,'5','271','2',1,'Received from bridging 23',0.00,0.00,8900.00,0.00,0.00,'2022-06-11 20:32:11','',''),(183,'5','271',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,4000.00,0.00,'2022-06-11 20:32:22','',''),(184,'5','271','3',1,'Received from bridging 24',0.00,0.00,4000.00,0.00,0.00,'2022-06-11 20:32:22','',''),(185,'5','271',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,26000.00,0.00,'2022-06-11 20:32:29','',''),(186,'5','271','1',1,'Received from bridging 25',0.00,0.00,26000.00,0.00,0.00,'2022-06-11 20:32:29','',''),(187,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,4204.37,0.00,'2022-06-15 10:47:26','',''),(188,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,8233.01,0.00,'2022-06-15 10:47:26','',''),(189,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,2189.77,0.00,'2022-06-15 10:47:26','',''),(190,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,100.36,0.00,'2022-06-15 10:47:26','',''),(191,'5','271','3',1,'Sale Id shift 8',0.00,0.00,0.00,2884.48,0.00,'2022-06-15 10:47:26','',''),(192,'5','271','3',1,'Sale Id shift 8',0.00,0.00,0.00,7172.47,0.00,'2022-06-15 10:47:26','',''),(193,'5','271','3',1,'Sale Id shift 8',0.00,0.00,0.00,8023.74,0.00,'2022-06-15 10:47:26','',''),(194,'5','271','4',1,'Sale Id shift 8',0.00,0.00,0.00,548.52,0.00,'2022-06-15 10:47:26','',''),(195,'5','271','4',1,'Sale Id shift 8',0.00,0.00,0.00,7158.50,0.00,'2022-06-15 10:47:26','',''),(196,'5','271','4',1,'Sale Id shift 8',0.00,0.00,0.00,6599.79,0.00,'2022-06-15 10:47:26','',''),(197,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,8463.60,0.00,'2022-06-15 10:47:26','',''),(198,'5','271','4',1,'Sale Id shift 8',0.00,0.00,0.00,348.88,0.00,'2022-06-15 10:47:26','',''),(199,'5','271','5',2,'Sale Id shift 8',0.00,0.00,0.00,2512.98,0.00,'2022-06-15 10:47:26','',''),(200,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,5286.22,0.00,'2022-06-15 10:47:26','',''),(201,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,6.85,0.00,'2022-06-15 10:47:26','',''),(202,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,1374.77,0.00,'2022-06-15 10:47:26','',''),(203,'5','271','1',1,'Sale Id shift 8',0.00,0.00,0.00,6656.95,0.00,'2022-06-15 10:47:26','',''),(204,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,1677.28,0.00,'2022-06-15 10:47:26','',''),(205,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,2926.70,0.00,'2022-06-15 10:47:26','',''),(206,'5','271','2',1,'Sale Id shift 8',0.00,0.00,0.00,7102.94,0.00,'2022-06-15 10:47:26','',''),(207,'5','271',NULL,2,'Sale Id shift 8',1658566.80,0.00,0.00,0.00,0.00,'2022-06-15 10:47:26','',''),(208,'5','271',NULL,1,'Sale Id shift 8',13358268.00,0.00,0.00,0.00,0.00,'2022-06-15 10:47:26','',''),(209,'5','271',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,19000.00,0.00,'2022-06-16 19:18:55','',''),(210,'5','271','1',1,'Received from bridging 26',0.00,0.00,19000.00,0.00,0.00,'2022-06-16 19:18:55','',''),(211,'5','271',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,41000.00,0.00,'2022-06-16 19:19:08','',''),(212,'5','271','2',1,'Received from bridging 28',0.00,0.00,41000.00,0.00,0.00,'2022-06-16 19:19:08','',''),(213,'5','271',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,22000.00,0.00,'2022-06-16 19:19:20','',''),(214,'5','271','3',1,'Received from bridging 29',0.00,0.00,22000.00,0.00,0.00,'2022-06-16 19:19:20','',''),(215,'5','271',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,18000.00,0.00,'2022-06-16 19:19:32','',''),(216,'5','271','4',1,'Received from bridging 30',0.00,0.00,18000.00,0.00,0.00,'2022-06-16 19:19:32','',''),(217,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-17 10:27:12','',''),(218,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-17 10:27:21','',''),(219,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-17 10:27:28','',''),(220,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-17 10:27:36','',''),(221,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-17 10:27:57','',''),(222,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-17 10:28:05','',''),(223,'5','271',NULL,2,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,26301000.00,39850.00,0.00,0.00,'2022-06-17 10:28:13','',''),(224,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-17 10:28:21','',''),(225,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-17 10:28:28','',''),(226,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-17 10:28:36','',''),(227,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,226.95,0.00,'2022-06-17 14:55:06','',''),(228,'5','271','2',1,'Sale Id shift 9',0.00,0.00,0.00,5906.68,0.00,'2022-06-17 14:55:06','',''),(229,'5','271','2',1,'Sale Id shift 9',0.00,0.00,0.00,4588.90,0.00,'2022-06-17 14:55:06','',''),(230,'5','271','3',1,'Sale Id shift 9',0.00,0.00,0.00,11664.38,0.00,'2022-06-17 14:55:06','',''),(231,'5','271','3',1,'Sale Id shift 9',0.00,0.00,0.00,5588.22,0.00,'2022-06-17 14:55:06','',''),(232,'5','271','3',1,'Sale Id shift 9',0.00,0.00,0.00,6958.03,0.00,'2022-06-17 14:55:06','',''),(233,'5','271','4',1,'Sale Id shift 9',0.00,0.00,0.00,211.08,0.00,'2022-06-17 14:55:06','',''),(234,'5','271','4',1,'Sale Id shift 9',0.00,0.00,0.00,9477.73,0.00,'2022-06-17 14:55:06','',''),(235,'5','271','4',1,'Sale Id shift 9',0.00,0.00,0.00,8021.58,0.00,'2022-06-17 14:55:06','',''),(236,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,10202.19,0.00,'2022-06-17 14:55:06','',''),(237,'5','271','4',1,'Sale Id shift 9',0.00,0.00,0.00,313.30,0.00,'2022-06-17 14:55:06','',''),(238,'5','271','5',2,'Sale Id shift 9',0.00,0.00,0.00,1337.98,0.00,'2022-06-17 14:55:06','',''),(239,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,2479.12,0.00,'2022-06-17 14:55:06','',''),(240,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,6.00,0.00,'2022-06-17 14:55:06','',''),(241,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,49.38,0.00,'2022-06-17 14:55:06','',''),(242,'5','271','1',1,'Sale Id shift 9',0.00,0.00,0.00,4294.55,0.00,'2022-06-17 14:55:06','',''),(243,'5','271','2',1,'Sale Id shift 9',0.00,0.00,0.00,55.87,0.00,'2022-06-17 14:55:06','',''),(244,'5','271','2',1,'Sale Id shift 9',0.00,0.00,0.00,4920.92,0.00,'2022-06-17 14:55:06','',''),(245,'5','271',NULL,2,'Sale Id shift 9',883066.80,0.00,0.00,0.00,0.00,'2022-06-17 14:55:06','',''),(246,'5','271',NULL,1,'Sale Id shift 9',12369205.20,0.00,0.00,0.00,0.00,'2022-06-17 14:55:06','',''),(247,'5','271',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,18950.00,0.00,'2022-06-18 13:57:15','',''),(248,'5','271','1',1,'Received from bridging 31',0.00,0.00,18950.00,0.00,0.00,'2022-06-18 13:57:15','',''),(249,'5','271',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,4855.00,0.00,'2022-06-18 13:57:38','',''),(250,'5','271','3',1,'Received from bridging 32',0.00,0.00,4855.00,0.00,0.00,'2022-06-18 13:57:38','',''),(251,'5','271',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,18500.00,0.00,'2022-06-18 13:58:00','',''),(252,'5','271','4',1,'Received from bridging 33',0.00,0.00,18500.00,0.00,0.00,'2022-06-18 13:58:00','',''),(253,'5','271',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,15500.00,0.00,'2022-06-18 13:58:21','',''),(254,'5','271','2',1,'Received from bridging 34',0.00,0.00,15500.00,0.00,0.00,'2022-06-18 13:58:21','',''),(255,'5','271','2',1,'Sale Id shift 10',0.00,0.00,0.00,7778.38,0.00,'2022-06-20 15:32:01','',''),(256,'5','271','2',1,'Sale Id shift 10',0.00,0.00,0.00,4254.13,0.00,'2022-06-20 15:32:01','',''),(257,'5','271','3',1,'Sale Id shift 10',0.00,0.00,0.00,8046.70,0.00,'2022-06-20 15:32:01','',''),(258,'5','271','3',1,'Sale Id shift 10',0.00,0.00,0.00,5845.80,0.00,'2022-06-20 15:32:01','',''),(259,'5','271','3',1,'Sale Id shift 10',0.00,0.00,0.00,7266.46,0.00,'2022-06-20 15:32:01','',''),(260,'5','271','4',1,'Sale Id shift 10',0.00,0.00,0.00,6874.23,0.00,'2022-06-20 15:32:01','',''),(261,'5','271','4',1,'Sale Id shift 10',0.00,0.00,0.00,5781.68,0.00,'2022-06-20 15:32:01','',''),(262,'5','271','1',1,'Sale Id shift 10',0.00,0.00,0.00,10885.25,0.00,'2022-06-20 15:32:01','',''),(263,'5','271','5',2,'Sale Id shift 10',0.00,0.00,0.00,3364.40,0.00,'2022-06-20 15:32:01','',''),(264,'5','271','1',1,'Sale Id shift 10',0.00,0.00,0.00,9291.85,0.00,'2022-06-20 15:32:01','',''),(265,'5','271','1',1,'Sale Id shift 10',0.00,0.00,0.00,10142.38,0.00,'2022-06-20 15:32:01','',''),(266,'5','271','2',1,'Sale Id shift 10',0.00,0.00,0.00,5101.58,0.00,'2022-06-20 15:32:01','',''),(267,'5','271',NULL,2,'Sale Id shift 10',2220504.00,0.00,0.00,0.00,0.00,'2022-06-20 15:32:01','',''),(268,'5','271',NULL,1,'Sale Id shift 10',13409292.60,0.00,0.00,0.00,0.00,'2022-06-20 15:32:01','',''),(269,'5','271',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,40000.00,0.00,'2022-06-20 16:48:01','',''),(270,'5','271','3',1,'Received from bridging 39',0.00,0.00,40000.00,0.00,0.00,'2022-06-20 16:48:01','',''),(271,'5','271',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,5500.00,0.00,'2022-06-20 16:48:28','',''),(272,'5','271','4',1,'Received from bridging 36',0.00,0.00,5500.00,0.00,0.00,'2022-06-20 16:48:28','',''),(273,'5','271',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,17300.00,0.00,'2022-06-20 17:04:45','',''),(274,'5','271','2',1,'Received from bridging 37',0.00,0.00,17300.00,0.00,0.00,'2022-06-20 17:04:45','',''),(275,'5','271',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,41000.00,0.00,'2022-06-21 14:01:47','',''),(276,'5','271','1',1,'Received from bridging 40',0.00,0.00,41000.00,0.00,0.00,'2022-06-21 14:01:47','',''),(277,'5','271','1',1,'Sale Id shift 11',0.00,0.00,0.00,2.52,0.00,'2022-06-21 14:06:05','',''),(278,'5','271','2',1,'Sale Id shift 11',0.00,0.00,0.00,3801.29,0.00,'2022-06-21 14:06:05','',''),(279,'5','271','2',1,'Sale Id shift 11',0.00,0.00,0.00,4038.19,0.00,'2022-06-21 14:06:05','',''),(280,'5','271','3',1,'Sale Id shift 11',0.00,0.00,0.00,8770.00,0.00,'2022-06-21 14:06:05','',''),(281,'5','271','3',1,'Sale Id shift 11',0.00,0.00,0.00,2102.33,0.00,'2022-06-21 14:06:05','',''),(282,'5','271','3',1,'Sale Id shift 11',0.00,0.00,0.00,7454.82,0.00,'2022-06-21 14:06:05','',''),(283,'5','271','4',1,'Sale Id shift 11',0.00,0.00,0.00,2.59,0.00,'2022-06-21 14:06:05','',''),(284,'5','271','4',1,'Sale Id shift 11',0.00,0.00,0.00,9066.00,0.00,'2022-06-21 14:06:05','',''),(285,'5','271','4',1,'Sale Id shift 11',0.00,0.00,0.00,6440.57,0.00,'2022-06-21 14:06:05','',''),(286,'5','271','1',1,'Sale Id shift 11',0.00,0.00,0.00,4052.69,0.00,'2022-06-21 14:06:05','',''),(287,'5','271','4',1,'Sale Id shift 11',0.00,0.00,0.00,103.27,0.00,'2022-06-21 14:06:05','',''),(288,'5','271','5',2,'Sale Id shift 11',0.00,0.00,0.00,1935.41,0.00,'2022-06-21 14:06:05','',''),(289,'5','271','1',1,'Sale Id shift 11',0.00,0.00,0.00,2716.50,0.00,'2022-06-21 14:06:05','',''),(290,'5','271','1',1,'Sale Id shift 11',0.00,0.00,0.00,3407.25,0.00,'2022-06-21 14:06:05','',''),(291,'5','271','2',1,'Sale Id shift 11',0.00,0.00,0.00,5861.92,0.00,'2022-06-21 14:06:05','',''),(292,'5','271',NULL,2,'Sale Id shift 11',1277370.60,0.00,0.00,0.00,0.00,'2022-06-21 14:06:05','',''),(293,'5','271',NULL,1,'Sale Id shift 11',9540290.10,0.00,0.00,0.00,0.00,'2022-06-21 14:06:05','',''),(294,'5','271','1',1,'Sale Id shift 12',0.00,0.00,0.00,338.59,0.00,'2022-06-21 14:14:42','',''),(295,'5','271','2',1,'Sale Id shift 12',0.00,0.00,0.00,6530.69,0.00,'2022-06-21 14:14:42','',''),(296,'5','271','3',1,'Sale Id shift 12',0.00,0.00,0.00,4857.10,0.00,'2022-06-21 14:14:42','',''),(297,'5','271','3',1,'Sale Id shift 12',0.00,0.00,0.00,4284.88,0.00,'2022-06-21 14:14:42','',''),(298,'5','271','4',1,'Sale Id shift 12',0.00,0.00,0.00,8315.40,0.00,'2022-06-21 14:14:42','',''),(299,'5','271','4',1,'Sale Id shift 12',0.00,0.00,0.00,7622.62,0.00,'2022-06-21 14:14:42','',''),(300,'5','271','1',1,'Sale Id shift 12',0.00,0.00,0.00,3905.98,0.00,'2022-06-21 14:14:42','',''),(301,'5','271','4',1,'Sale Id shift 12',0.00,0.00,0.00,4581.57,0.00,'2022-06-21 14:14:42','',''),(302,'5','271','5',2,'Sale Id shift 12',0.00,0.00,0.00,1351.83,0.00,'2022-06-21 14:14:42','',''),(303,'5','271','1',1,'Sale Id shift 12',0.00,0.00,0.00,3327.67,0.00,'2022-06-21 14:14:42','',''),(304,'5','271','1',1,'Sale Id shift 12',0.00,0.00,0.00,3178.29,0.00,'2022-06-21 14:14:42','',''),(305,'5','271','2',1,'Sale Id shift 12',0.00,0.00,0.00,3448.66,0.00,'2022-06-21 14:14:42','',''),(306,'5','271',NULL,2,'Sale Id shift 12',892207.80,0.00,0.00,0.00,0.00,'2022-06-21 14:14:42','',''),(307,'5','271',NULL,1,'Sale Id shift 12',8314589.25,0.00,0.00,0.00,0.00,'2022-06-21 14:14:42','',''),(308,'5','271','2',1,'Sale Id shift 13',0.00,0.00,0.00,8871.43,0.00,'2022-06-21 14:24:09','',''),(309,'5','271','2',1,'Sale Id shift 13',0.00,0.00,0.00,10262.35,0.00,'2022-06-21 14:24:09','',''),(310,'5','271','3',1,'Sale Id shift 13',0.00,0.00,0.00,9362.18,0.00,'2022-06-21 14:24:09','',''),(311,'5','271','3',1,'Sale Id shift 13',0.00,0.00,0.00,4191.38,0.00,'2022-06-21 14:24:09','',''),(312,'5','271','3',1,'Sale Id shift 13',0.00,0.00,0.00,0.69,0.00,'2022-06-21 14:24:09','',''),(313,'5','271','4',1,'Sale Id shift 13',0.00,0.00,0.00,1.88,0.00,'2022-06-21 14:24:09','',''),(314,'5','271','4',1,'Sale Id shift 13',0.00,0.00,0.00,10.72,0.00,'2022-06-21 14:24:09','',''),(315,'5','271','4',1,'Sale Id shift 13',0.00,0.00,0.00,3123.71,0.00,'2022-06-21 14:24:09','',''),(316,'5','271','1',1,'Sale Id shift 13',0.00,0.00,0.00,9516.77,0.00,'2022-06-21 14:24:09','',''),(317,'5','271','4',1,'Sale Id shift 13',0.00,0.00,0.00,0.88,0.00,'2022-06-21 14:24:09','',''),(318,'5','271','5',2,'Sale Id shift 13',0.00,0.00,0.00,1891.89,0.00,'2022-06-21 14:24:09','',''),(319,'5','271','1',1,'Sale Id shift 13',0.00,0.00,0.00,8847.87,0.00,'2022-06-21 14:24:09','',''),(320,'5','271','1',1,'Sale Id shift 13',0.00,0.00,0.00,9677.09,0.00,'2022-06-21 14:24:09','',''),(321,'5','271','2',1,'Sale Id shift 13',0.00,0.00,0.00,5417.04,0.00,'2022-06-21 14:24:09','',''),(322,'5','271',NULL,2,'Sale Id shift 13',1248647.40,0.00,0.00,0.00,0.00,'2022-06-21 14:24:09','',''),(323,'5','271',NULL,1,'Sale Id shift 13',11431858.35,0.00,0.00,0.00,0.00,'2022-06-21 14:24:09','',''),(324,'5','271',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,22700.00,0.00,'2022-06-21 14:47:57','',''),(325,'5','271','2',1,'Received from bridging 41',0.00,0.00,22700.00,0.00,0.00,'2022-06-21 14:47:57','',''),(326,'5','271',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,4000.00,0.00,'2022-06-21 14:48:09','',''),(327,'5','271','1',1,'Received from bridging 42',0.00,0.00,4000.00,0.00,0.00,'2022-06-21 14:48:09','',''),(328,'5','271',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,45000.00,0.00,'2022-06-21 15:06:09','',''),(329,'5','271','1',1,'Received from bridging 46',0.00,0.00,45000.00,0.00,0.00,'2022-06-21 15:06:09','',''),(330,'5','271',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,39700.00,0.00,'2022-06-21 15:15:49','',''),(331,'5','271','4',1,'Received from bridging 47',0.00,0.00,39700.00,0.00,0.00,'2022-06-21 15:15:49','',''),(332,'5','271',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,42000.00,0.00,'2022-06-21 15:22:56','',''),(333,'5','271','3',1,'Received from bridging 48',0.00,0.00,42000.00,0.00,0.00,'2022-06-21 15:22:56','',''),(334,'5','271','2',1,'Sale Id shift 14',0.00,0.00,0.00,2.71,0.00,'2022-06-21 15:24:36','',''),(335,'5','271','2',1,'Sale Id shift 14',0.00,0.00,0.00,7368.27,0.00,'2022-06-21 15:24:36','',''),(336,'5','271','3',1,'Sale Id shift 14',0.00,0.00,0.00,9048.18,0.00,'2022-06-21 15:24:36','',''),(337,'5','271','3',1,'Sale Id shift 14',0.00,0.00,0.00,6690.46,0.00,'2022-06-21 15:24:36','',''),(338,'5','271','4',1,'Sale Id shift 14',0.00,0.00,0.00,8294.49,0.00,'2022-06-21 15:24:36','',''),(339,'5','271','4',1,'Sale Id shift 14',0.00,0.00,0.00,6909.23,0.00,'2022-06-21 15:24:36','',''),(340,'5','271','1',1,'Sale Id shift 14',0.00,0.00,0.00,1827.21,0.00,'2022-06-21 15:24:36','',''),(341,'5','271','5',2,'Sale Id shift 14',0.00,0.00,0.00,1791.16,0.00,'2022-06-21 15:24:36','',''),(342,'5','271','1',1,'Sale Id shift 14',0.00,0.00,0.00,2432.32,0.00,'2022-06-21 15:24:36','',''),(343,'5','271','1',1,'Sale Id shift 14',0.00,0.00,0.00,1853.75,0.00,'2022-06-21 15:24:36','',''),(344,'5','271','2',1,'Sale Id shift 14',0.00,0.00,0.00,5476.26,0.00,'2022-06-21 15:24:36','',''),(345,'5','271',NULL,2,'Sale Id shift 14',1182165.60,0.00,0.00,0.00,0.00,'2022-06-21 15:24:36','',''),(346,'5','271',NULL,1,'Sale Id shift 14',8233975.20,0.00,0.00,0.00,0.00,'2022-06-21 15:24:36','',''),(347,'5','271',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,8000.00,0.00,'2022-06-21 15:39:07','',''),(348,'5','271','2',1,'Received from bridging 49',0.00,0.00,8000.00,0.00,0.00,'2022-06-21 15:39:07','',''),(349,'5','271',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,5000.00,0.00,'2022-06-21 15:39:18','',''),(350,'5','271','3',1,'Received from bridging 50',0.00,0.00,5000.00,0.00,0.00,'2022-06-21 15:39:18','',''),(351,'5','271',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,30000.00,0.00,'2022-06-21 16:47:25','',''),(352,'5','271','2',1,'Received from bridging 51',0.00,0.00,30000.00,0.00,0.00,'2022-06-21 16:47:25','',''),(353,'5','271',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,20000.00,0.00,'2022-06-21 16:47:36','',''),(354,'5','271','4',1,'Received from bridging 52',0.00,0.00,20000.00,0.00,0.00,'2022-06-21 16:47:36','',''),(355,'5','271','2',1,'Sale Id shift 15',0.00,0.00,0.00,2606.58,0.00,'2022-06-21 16:54:25','',''),(356,'5','271','2',1,'Sale Id shift 15',0.00,0.00,0.00,9199.69,0.00,'2022-06-21 16:54:25','',''),(357,'5','271','3',1,'Sale Id shift 15',0.00,0.00,0.00,4515.62,0.00,'2022-06-21 16:54:25','',''),(358,'5','271','3',1,'Sale Id shift 15',0.00,0.00,0.00,4992.91,0.00,'2022-06-21 16:54:25','',''),(359,'5','271','4',1,'Sale Id shift 15',0.00,0.00,0.00,4.93,0.00,'2022-06-21 16:54:25','',''),(360,'5','271','4',1,'Sale Id shift 15',0.00,0.00,0.00,5870.21,0.00,'2022-06-21 16:54:25','',''),(361,'5','271','4',1,'Sale Id shift 15',0.00,0.00,0.00,3892.85,0.00,'2022-06-21 16:54:25','',''),(362,'5','271','1',1,'Sale Id shift 15',0.00,0.00,0.00,9503.45,0.00,'2022-06-21 16:54:25','',''),(363,'5','271','5',2,'Sale Id shift 15',0.00,0.00,0.00,1484.80,0.00,'2022-06-21 16:54:25','',''),(364,'5','271','1',1,'Sale Id shift 15',0.00,0.00,0.00,8010.85,0.00,'2022-06-21 16:54:25','',''),(365,'5','271','1',1,'Sale Id shift 15',0.00,0.00,0.00,7748.21,0.00,'2022-06-21 16:54:25','',''),(366,'5','271','2',1,'Sale Id shift 15',0.00,0.00,0.00,2631.05,0.00,'2022-06-21 16:54:25','',''),(367,'5','271',NULL,2,'Sale Id shift 15',979968.00,0.00,0.00,0.00,0.00,'2022-06-21 16:54:25','',''),(368,'5','271',NULL,1,'Sale Id shift 15',9731097.75,0.00,0.00,0.00,0.00,'2022-06-21 16:54:25','',''),(369,'5','271','2',1,'Sale Id shift 16',0.00,0.00,0.00,12.30,0.00,'2022-06-21 17:05:34','',''),(370,'5','271','2',1,'Sale Id shift 16',0.00,0.00,0.00,9166.80,0.00,'2022-06-21 17:05:34','',''),(371,'5','271','4',1,'Sale Id shift 16',0.00,0.00,0.00,25.35,0.00,'2022-06-21 17:05:34','',''),(372,'5','271','4',1,'Sale Id shift 16',0.00,0.00,0.00,8340.24,0.00,'2022-06-21 17:05:34','',''),(373,'5','271','1',1,'Sale Id shift 16',0.00,0.00,0.00,2226.25,0.00,'2022-06-21 17:05:34','',''),(374,'5','271','5',2,'Sale Id shift 16',0.00,0.00,0.00,3038.34,0.00,'2022-06-21 17:05:34','',''),(375,'5','271','1',1,'Sale Id shift 16',0.00,0.00,0.00,8034.35,0.00,'2022-06-21 17:05:35','',''),(376,'5','271','1',1,'Sale Id shift 16',0.00,0.00,0.00,1793.69,0.00,'2022-06-21 17:05:35','',''),(377,'5','271','2',1,'Sale Id shift 16',0.00,0.00,0.00,7960.37,0.00,'2022-06-21 17:05:35','',''),(378,'5','271',NULL,2,'Sale Id shift 16',2005304.40,0.00,0.00,0.00,0.00,'2022-06-21 17:05:35','',''),(379,'5','271',NULL,1,'Sale Id shift 16',6197292.75,0.00,0.00,0.00,0.00,'2022-06-21 17:05:35','',''),(380,'5','271',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2022-06-21 17:35:14','',''),(381,'5','271','1',1,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2022-06-21 17:35:14','',''),(382,'5','271',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,20000.00,0.00,'2022-06-21 17:35:25','',''),(383,'5','271','3',1,'Received from bridging 54',0.00,0.00,20000.00,0.00,0.00,'2022-06-21 17:35:25','',''),(384,'5','271',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,20000.00,0.00,'2022-06-21 17:35:36','',''),(385,'5','271','4',1,'Received from bridging 55',0.00,0.00,20000.00,0.00,0.00,'2022-06-21 17:35:36','',''),(386,'5','271',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 17:35:47','',''),(387,'5','271','2',1,'Received from bridging 56',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 17:35:47','',''),(388,'5','271','2',1,'Sale Id shift 17',0.00,0.00,0.00,3487.20,0.00,'2022-06-21 17:36:45','',''),(389,'5','271','2',1,'Sale Id shift 17',0.00,0.00,0.00,9879.87,0.00,'2022-06-21 17:36:45','',''),(390,'5','271','4',1,'Sale Id shift 17',0.00,0.00,0.00,6353.95,0.00,'2022-06-21 17:36:45','',''),(391,'5','271','1',1,'Sale Id shift 17',0.00,0.00,0.00,6904.72,0.00,'2022-06-21 17:36:45','',''),(392,'5','271','5',2,'Sale Id shift 17',0.00,0.00,0.00,1973.05,0.00,'2022-06-21 17:36:45','',''),(393,'5','271','1',1,'Sale Id shift 17',0.00,0.00,0.00,1967.53,0.00,'2022-06-21 17:36:45','',''),(394,'5','271','1',1,'Sale Id shift 17',0.00,0.00,0.00,7320.19,0.00,'2022-06-21 17:36:45','',''),(395,'5','271','2',1,'Sale Id shift 17',0.00,0.00,0.00,334.44,0.00,'2022-06-21 17:36:45','',''),(396,'5','271','2',1,'Sale Id shift 17',0.00,0.00,0.00,82.20,0.00,'2022-06-21 17:36:45','',''),(397,'5','271',NULL,2,'Sale Id shift 17',1302213.00,0.00,0.00,0.00,0.00,'2022-06-21 17:36:45','',''),(398,'5','271',NULL,1,'Sale Id shift 17',5994466.50,0.00,0.00,0.00,0.00,'2022-06-21 17:36:45','',''),(399,'5','271',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,20000.00,0.00,'2022-06-21 18:03:42','',''),(400,'5','271','1',1,'Received from bridging 57',0.00,0.00,20000.00,0.00,0.00,'2022-06-21 18:03:42','',''),(401,'5','271',NULL,2,'Reception corrector for bridging 58',0.00,0.00,0.00,38000.00,0.00,'2022-06-21 18:04:00','',''),(402,'5','271','5',2,'Received from bridging 58',0.00,0.00,38000.00,0.00,0.00,'2022-06-21 18:04:00','',''),(403,'5','271','2',1,'Sale Id shift 18',0.00,0.00,0.00,1517.78,0.00,'2022-06-21 18:10:13','',''),(404,'5','271','2',1,'Sale Id shift 18',0.00,0.00,0.00,1566.89,0.00,'2022-06-21 18:10:13','',''),(405,'5','271','3',1,'Sale Id shift 18',0.00,0.00,0.00,8235.51,0.00,'2022-06-21 18:10:13','',''),(406,'5','271','3',1,'Sale Id shift 18',0.00,0.00,0.00,7707.70,0.00,'2022-06-21 18:10:13','',''),(407,'5','271','3',1,'Sale Id shift 18',0.00,0.00,0.00,7287.43,0.00,'2022-06-21 18:10:13','',''),(408,'5','271','1',1,'Sale Id shift 18',0.00,0.00,0.00,5485.99,0.00,'2022-06-21 18:10:13','',''),(409,'5','271','5',2,'Sale Id shift 18',0.00,0.00,0.00,1693.68,0.00,'2022-06-21 18:10:13','',''),(410,'5','271','1',1,'Sale Id shift 18',0.00,0.00,0.00,8326.68,0.00,'2022-06-21 18:10:13','',''),(411,'5','271','1',1,'Sale Id shift 18',0.00,0.00,0.00,9090.64,0.00,'2022-06-21 18:10:13','',''),(412,'5','271',NULL,2,'Sale Id shift 18',1117828.80,0.00,0.00,0.00,0.00,'2022-06-21 18:10:13','',''),(413,'5','271',NULL,1,'Sale Id shift 18',8121072.30,0.00,0.00,0.00,0.00,'2022-06-21 18:10:13','',''),(414,'5','271',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,20000.00,0.00,'2022-06-21 18:19:07','',''),(415,'5','271','3',1,'Received from bridging 59',0.00,0.00,20000.00,0.00,0.00,'2022-06-21 18:19:07','',''),(416,'5','271',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 18:19:18','',''),(417,'5','271','1',1,'Received from bridging 60',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 18:19:18','',''),(418,'5','271','2',1,'Sale Id shift 19',0.00,0.00,0.00,1.20,0.00,'2022-06-21 18:24:27','',''),(419,'5','271','2',1,'Sale Id shift 19',0.00,0.00,0.00,2.01,0.00,'2022-06-21 18:24:27','',''),(420,'5','271','3',1,'Sale Id shift 19',0.00,0.00,0.00,8627.41,0.00,'2022-06-21 18:24:27','',''),(421,'5','271','3',1,'Sale Id shift 19',0.00,0.00,0.00,6800.38,0.00,'2022-06-21 18:24:27','',''),(422,'5','271','3',1,'Sale Id shift 19',0.00,0.00,0.00,10499.78,0.00,'2022-06-21 18:24:27','',''),(423,'5','271','1',1,'Sale Id shift 19',0.00,0.00,0.00,9279.94,0.00,'2022-06-21 18:24:27','',''),(424,'5','271','5',2,'Sale Id shift 19',0.00,0.00,0.00,2646.80,0.00,'2022-06-21 18:24:27','',''),(425,'5','271','1',1,'Sale Id shift 19',0.00,0.00,0.00,7917.01,0.00,'2022-06-21 18:24:27','',''),(426,'5','271','1',1,'Sale Id shift 19',0.00,0.00,0.00,7848.01,0.00,'2022-06-21 18:24:27','',''),(427,'5','271','2',1,'Sale Id shift 19',0.00,0.00,0.00,3.67,0.00,'2022-06-21 18:24:27','',''),(428,'5','271',NULL,2,'Sale Id shift 19',1746888.00,0.00,0.00,0.00,0.00,'2022-06-21 18:24:27','',''),(429,'5','271',NULL,1,'Sale Id shift 19',8411602.65,0.00,0.00,0.00,0.00,'2022-06-21 18:24:27','',''),(430,'5','271',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,17000.00,0.00,'2022-06-21 18:34:39','',''),(431,'5','271','1',1,'Received from bridging 61',0.00,0.00,17000.00,0.00,0.00,'2022-06-21 18:34:39','',''),(432,'5','271',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,30000.00,0.00,'2022-06-21 18:34:50','',''),(433,'5','271','2',1,'Received from bridging 62',0.00,0.00,30000.00,0.00,0.00,'2022-06-21 18:34:50','',''),(434,'5','271',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,29000.00,0.00,'2022-06-21 18:35:02','',''),(435,'5','271','3',1,'Received from bridging 63',0.00,0.00,29000.00,0.00,0.00,'2022-06-21 18:35:02','',''),(436,'5','271','2',1,'Sale Id shift 20',0.00,0.00,0.00,6800.35,0.00,'2022-06-21 18:38:07','',''),(437,'5','271','2',1,'Sale Id shift 20',0.00,0.00,0.00,8462.85,0.00,'2022-06-21 18:38:07','',''),(438,'5','271','3',1,'Sale Id shift 20',0.00,0.00,0.00,3322.66,0.00,'2022-06-21 18:38:07','',''),(439,'5','271','3',1,'Sale Id shift 20',0.00,0.00,0.00,3278.75,0.00,'2022-06-21 18:38:07','',''),(440,'5','271','4',1,'Sale Id shift 20',0.00,0.00,0.00,9199.87,0.00,'2022-06-21 18:38:07','',''),(441,'5','271','1',1,'Sale Id shift 20',0.00,0.00,0.00,5476.75,0.00,'2022-06-21 18:38:07','',''),(442,'5','271','5',2,'Sale Id shift 20',0.00,0.00,0.00,1572.57,0.00,'2022-06-21 18:38:07','',''),(443,'5','271','1',1,'Sale Id shift 20',0.00,0.00,0.00,3386.30,0.00,'2022-06-21 18:38:07','',''),(444,'5','271','1',1,'Sale Id shift 20',0.00,0.00,0.00,7445.38,0.00,'2022-06-21 18:38:07','',''),(445,'5','271',NULL,2,'Sale Id shift 20',1037896.20,0.00,0.00,0.00,0.00,'2022-06-21 18:38:07','',''),(446,'5','271',NULL,1,'Sale Id shift 20',7816530.15,0.00,0.00,0.00,0.00,'2022-06-21 18:38:07','',''),(447,'5','271',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,27700.00,0.00,'2022-06-21 18:45:15','',''),(448,'5','271','1',1,'Received from bridging 64',0.00,0.00,27700.00,0.00,0.00,'2022-06-21 18:45:15','',''),(449,'5','271',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,11000.00,0.00,'2022-06-21 18:45:27','',''),(450,'5','271','2',1,'Received from bridging 65',0.00,0.00,11000.00,0.00,0.00,'2022-06-21 18:45:27','',''),(451,'5','271','2',1,'Sale Id shift 21',0.00,0.00,0.00,8992.84,0.00,'2022-06-21 18:47:14','',''),(452,'5','271','2',1,'Sale Id shift 21',0.00,0.00,0.00,11863.91,0.00,'2022-06-21 18:47:14','',''),(453,'5','271','4',1,'Sale Id shift 21',0.00,0.00,0.00,9778.91,0.00,'2022-06-21 18:47:14','',''),(454,'5','271','5',2,'Sale Id shift 21',0.00,0.00,0.00,2317.45,0.00,'2022-06-21 18:47:14','',''),(455,'5','271','1',1,'Sale Id shift 21',0.00,0.00,0.00,4709.32,0.00,'2022-06-21 18:47:14','',''),(456,'5','271','2',1,'Sale Id shift 21',0.00,0.00,0.00,6863.06,0.00,'2022-06-21 18:47:14','',''),(457,'5','271',NULL,2,'Sale Id shift 21',1529517.00,0.00,0.00,0.00,0.00,'2022-06-21 18:47:14','',''),(458,'5','271',NULL,1,'Sale Id shift 21',6964326.60,0.00,0.00,0.00,0.00,'2022-06-21 18:47:14','',''),(459,'5','271','2',1,'Sale Id shift 22',0.00,0.00,0.00,2179.50,0.00,'2022-06-21 18:54:16','',''),(460,'5','271','3',1,'Sale Id shift 22',0.00,0.00,0.00,7834.17,0.00,'2022-06-21 18:54:16','',''),(461,'5','271','3',1,'Sale Id shift 22',0.00,0.00,0.00,9518.47,0.00,'2022-06-21 18:54:16','',''),(462,'5','271','4',1,'Sale Id shift 22',0.00,0.00,0.00,9393.06,0.00,'2022-06-21 18:54:16','',''),(463,'5','271','1',1,'Sale Id shift 22',0.00,0.00,0.00,1074.92,0.00,'2022-06-21 18:54:16','',''),(464,'5','271','5',2,'Sale Id shift 22',0.00,0.00,0.00,3631.31,0.00,'2022-06-21 18:54:16','',''),(465,'5','271','1',1,'Sale Id shift 22',0.00,0.00,0.00,8564.68,0.00,'2022-06-21 18:54:16','',''),(466,'5','271','1',1,'Sale Id shift 22',0.00,0.00,0.00,8344.29,0.00,'2022-06-21 18:54:16','',''),(467,'5','271',NULL,2,'Sale Id shift 22',2396664.60,0.00,0.00,0.00,0.00,'2022-06-21 18:54:16','',''),(468,'5','271',NULL,1,'Sale Id shift 22',7739999.85,0.00,0.00,0.00,0.00,'2022-06-21 18:54:16','',''),(469,'5','271',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,35000.00,0.00,'2022-06-21 18:56:48','',''),(470,'5','271','2',1,'Received from bridging 66',0.00,0.00,35000.00,0.00,0.00,'2022-06-21 18:56:48','',''),(471,'5','271',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,25000.00,0.00,'2022-06-21 18:56:59','',''),(472,'5','271','4',1,'Received from bridging 67',0.00,0.00,25000.00,0.00,0.00,'2022-06-21 18:56:59','',''),(473,'5','271',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,37000.00,0.00,'2022-06-21 19:13:20','',''),(474,'5','271','1',1,'Received from bridging 68',0.00,0.00,37000.00,0.00,0.00,'2022-06-21 19:13:20','',''),(475,'5','271',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,24000.00,0.00,'2022-06-21 19:13:33','',''),(476,'5','271','3',1,'Received from bridging 69',0.00,0.00,24000.00,0.00,0.00,'2022-06-21 19:13:33','',''),(477,'5','271','1',1,'Sale Id shift 23',0.00,0.00,0.00,4.35,0.00,'2022-06-21 19:15:55','',''),(478,'5','271','2',1,'Sale Id shift 23',0.00,0.00,0.00,1122.93,0.00,'2022-06-21 19:15:55','',''),(479,'5','271','2',1,'Sale Id shift 23',0.00,0.00,0.00,1717.76,0.00,'2022-06-21 19:15:55','',''),(480,'5','271','3',1,'Sale Id shift 23',0.00,0.00,0.00,2564.99,0.00,'2022-06-21 19:15:55','',''),(481,'5','271','3',1,'Sale Id shift 23',0.00,0.00,0.00,1822.66,0.00,'2022-06-21 19:15:55','',''),(482,'5','271','3',1,'Sale Id shift 23',0.00,0.00,0.00,1483.22,0.00,'2022-06-21 19:15:55','',''),(483,'5','271','4',1,'Sale Id shift 23',0.00,0.00,0.00,5394.13,0.00,'2022-06-21 19:15:55','',''),(484,'5','271','4',1,'Sale Id shift 23',0.00,0.00,0.00,6553.44,0.00,'2022-06-21 19:15:55','',''),(485,'5','271','1',1,'Sale Id shift 23',0.00,0.00,0.00,2118.30,0.00,'2022-06-21 19:15:55','',''),(486,'5','271','5',2,'Sale Id shift 23',0.00,0.00,0.00,4022.10,0.00,'2022-06-21 19:15:55','',''),(487,'5','271','1',1,'Sale Id shift 23',0.00,0.00,0.00,2518.75,0.00,'2022-06-21 19:15:55','',''),(488,'5','271','1',1,'Sale Id shift 23',0.00,0.00,0.00,9348.35,0.00,'2022-06-21 19:15:55','',''),(489,'5','271','2',1,'Sale Id shift 23',0.00,0.00,0.00,911.40,0.00,'2022-06-21 19:15:55','',''),(490,'5','271',NULL,2,'Sale Id shift 23',2654586.00,0.00,0.00,0.00,0.00,'2022-06-21 19:15:55','',''),(491,'5','271',NULL,1,'Sale Id shift 23',5867446.20,0.00,0.00,0.00,0.00,'2022-06-21 19:15:55','',''),(492,'5','271',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,5000.00,0.00,'2022-06-21 19:24:53','',''),(493,'5','271','2',1,'Received from bridging 70',0.00,0.00,5000.00,0.00,0.00,'2022-06-21 19:24:53','',''),(494,'5','271',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 19:25:06','',''),(495,'5','271','4',1,'Received from bridging 71',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 19:25:06','',''),(496,'5','271','2',1,'Sale Id shift 24',0.00,0.00,0.00,5889.76,0.00,'2022-06-21 19:36:11','',''),(497,'5','271','2',1,'Sale Id shift 24',0.00,0.00,0.00,5859.11,0.00,'2022-06-21 19:36:11','',''),(498,'5','271','3',1,'Sale Id shift 24',0.00,0.00,0.00,9509.33,0.00,'2022-06-21 19:36:11','',''),(499,'5','271','3',1,'Sale Id shift 24',0.00,0.00,0.00,6753.24,0.00,'2022-06-21 19:36:11','',''),(500,'5','271','3',1,'Sale Id shift 24',0.00,0.00,0.00,8387.61,0.00,'2022-06-21 19:36:11','',''),(501,'5','271','4',1,'Sale Id shift 24',0.00,0.00,0.00,2823.13,0.00,'2022-06-21 19:36:11','',''),(502,'5','271','1',1,'Sale Id shift 24',0.00,0.00,0.00,1865.54,0.00,'2022-06-21 19:36:11','',''),(503,'5','271','4',1,'Sale Id shift 24',0.00,0.00,0.00,317.57,0.00,'2022-06-21 19:36:11','',''),(504,'5','271','5',2,'Sale Id shift 24',0.00,0.00,0.00,2725.14,0.00,'2022-06-21 19:36:11','',''),(505,'5','271','1',1,'Sale Id shift 24',0.00,0.00,0.00,1803.42,0.00,'2022-06-21 19:36:11','',''),(506,'5','271','1',1,'Sale Id shift 24',0.00,0.00,0.00,1489.62,0.00,'2022-06-21 19:36:11','',''),(507,'5','271','2',1,'Sale Id shift 24',0.00,0.00,0.00,5899.71,0.00,'2022-06-21 19:36:11','',''),(508,'5','271',NULL,2,'Sale Id shift 24',1798592.40,0.00,0.00,0.00,0.00,'2022-06-21 19:36:11','',''),(509,'5','271',NULL,1,'Sale Id shift 24',8348676.60,0.00,0.00,0.00,0.00,'2022-06-21 19:36:11','',''),(510,'5','271',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,16000.00,0.00,'2022-06-21 19:43:53','',''),(511,'5','271','3',1,'Received from bridging 72',0.00,0.00,16000.00,0.00,0.00,'2022-06-21 19:43:53','',''),(512,'5','271',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,8000.00,0.00,'2022-06-21 19:44:05','',''),(513,'5','271','1',1,'Received from bridging 73',0.00,0.00,8000.00,0.00,0.00,'2022-06-21 19:44:05','',''),(514,'5','271',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,15000.00,0.00,'2022-06-21 19:44:16','',''),(515,'5','271','2',1,'Received from bridging 74',0.00,0.00,15000.00,0.00,0.00,'2022-06-21 19:44:16','',''),(516,'5','271','2',1,'Sale Id shift 25',0.00,0.00,0.00,20.00,0.00,'2022-06-21 19:45:37','',''),(517,'5','271','2',1,'Sale Id shift 25',0.00,0.00,0.00,6606.19,0.00,'2022-06-21 19:45:37','',''),(518,'5','271','3',1,'Sale Id shift 25',0.00,0.00,0.00,4502.16,0.00,'2022-06-21 19:45:37','',''),(519,'5','271','3',1,'Sale Id shift 25',0.00,0.00,0.00,4647.86,0.00,'2022-06-21 19:45:37','',''),(520,'5','271','3',1,'Sale Id shift 25',0.00,0.00,0.00,24.90,0.00,'2022-06-21 19:45:37','',''),(521,'5','271','4',1,'Sale Id shift 25',0.00,0.00,0.00,12100.27,0.00,'2022-06-21 19:45:37','',''),(522,'5','271','4',1,'Sale Id shift 25',0.00,0.00,0.00,1352.68,0.00,'2022-06-21 19:45:37','',''),(523,'5','271','1',1,'Sale Id shift 25',0.00,0.00,0.00,7808.82,0.00,'2022-06-21 19:45:37','',''),(524,'5','271','4',1,'Sale Id shift 25',0.00,0.00,0.00,10.00,0.00,'2022-06-21 19:45:37','',''),(525,'5','271','5',2,'Sale Id shift 25',0.00,0.00,0.00,2828.22,0.00,'2022-06-21 19:45:37','',''),(526,'5','271','1',1,'Sale Id shift 25',0.00,0.00,0.00,7239.68,0.00,'2022-06-21 19:45:37','',''),(527,'5','271','1',1,'Sale Id shift 25',0.00,0.00,0.00,7491.98,0.00,'2022-06-21 19:45:37','',''),(528,'5','271','2',1,'Sale Id shift 25',0.00,0.00,0.00,38.42,0.00,'2022-06-21 19:45:37','',''),(529,'5','271','2',1,'Sale Id shift 25',0.00,0.00,0.00,4224.88,0.00,'2022-06-21 19:45:37','',''),(530,'5','271',NULL,2,'Sale Id shift 25',1866625.20,0.00,0.00,0.00,0.00,'2022-06-21 19:45:37','',''),(531,'5','271',NULL,1,'Sale Id shift 25',9251193.60,0.00,0.00,0.00,0.00,'2022-06-21 19:45:37','',''),(532,'5','271','2',1,'Sale Id shift 26',0.00,0.00,0.00,6766.67,0.00,'2022-06-21 19:53:27','',''),(533,'5','271','3',1,'Sale Id shift 26',0.00,0.00,0.00,7217.54,0.00,'2022-06-21 19:53:27','',''),(534,'5','271','3',1,'Sale Id shift 26',0.00,0.00,0.00,4025.96,0.00,'2022-06-21 19:53:27','',''),(535,'5','271','3',1,'Sale Id shift 26',0.00,0.00,0.00,98.53,0.00,'2022-06-21 19:53:27','',''),(536,'5','271','4',1,'Sale Id shift 26',0.00,0.00,0.00,9358.23,0.00,'2022-06-21 19:53:27','',''),(537,'5','271','4',1,'Sale Id shift 26',0.00,0.00,0.00,524.47,0.00,'2022-06-21 19:53:27','',''),(538,'5','271','1',1,'Sale Id shift 26',0.00,0.00,0.00,50.54,0.00,'2022-06-21 19:53:27','',''),(539,'5','271','5',2,'Sale Id shift 26',0.00,0.00,0.00,1415.61,0.00,'2022-06-21 19:53:27','',''),(540,'5','271','1',1,'Sale Id shift 26',0.00,0.00,0.00,6347.16,0.00,'2022-06-21 19:53:27','',''),(541,'5','271','1',1,'Sale Id shift 26',0.00,0.00,0.00,5909.53,0.00,'2022-06-21 19:53:27','',''),(542,'5','271','2',1,'Sale Id shift 26',0.00,0.00,0.00,2203.40,0.00,'2022-06-21 19:53:27','',''),(543,'5','271',NULL,2,'Sale Id shift 26',934302.60,0.00,0.00,0.00,0.00,'2022-06-21 19:53:27','',''),(544,'5','271',NULL,1,'Sale Id shift 26',7012834.95,0.00,0.00,0.00,0.00,'2022-06-21 19:53:27','',''),(545,'5','271',NULL,2,'Reception corrector for bridging 75',0.00,0.00,0.00,1850.00,0.00,'2022-06-21 19:53:40','',''),(546,'5','271','5',2,'Received from bridging 75',0.00,0.00,1850.00,0.00,0.00,'2022-06-21 19:53:40','',''),(547,'5','271',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,33000.00,0.00,'2022-06-21 19:54:06','',''),(548,'5','271','1',1,'Received from bridging 76',0.00,0.00,33000.00,0.00,0.00,'2022-06-21 19:54:06','',''),(549,'5','271',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,17000.00,0.00,'2022-06-21 19:54:34','',''),(550,'5','271','4',1,'Received from bridging 77',0.00,0.00,17000.00,0.00,0.00,'2022-06-21 19:54:34','',''),(551,'5','271','2',1,'Sale Id shift 27',0.00,0.00,0.00,7528.78,0.00,'2022-06-23 10:07:36','',''),(552,'5','271','2',1,'Sale Id shift 27',0.00,0.00,0.00,3725.11,0.00,'2022-06-23 10:07:36','',''),(553,'5','271','3',1,'Sale Id shift 27',0.00,0.00,0.00,8608.01,0.00,'2022-06-23 10:07:36','',''),(554,'5','271','3',1,'Sale Id shift 27',0.00,0.00,0.00,2483.57,0.00,'2022-06-23 10:07:36','',''),(555,'5','271','4',1,'Sale Id shift 27',0.00,0.00,0.00,12009.95,0.00,'2022-06-23 10:07:36','',''),(556,'5','271','4',1,'Sale Id shift 27',0.00,0.00,0.00,6464.36,0.00,'2022-06-23 10:07:36','',''),(557,'5','271','5',2,'Sale Id shift 27',0.00,0.00,0.00,2516.05,0.00,'2022-06-23 10:07:36','',''),(558,'5','271','1',1,'Sale Id shift 27',0.00,0.00,0.00,9965.14,0.00,'2022-06-23 10:07:36','',''),(559,'5','271','1',1,'Sale Id shift 27',0.00,0.00,0.00,8282.81,0.00,'2022-06-23 10:07:36','',''),(560,'5','271','2',1,'Sale Id shift 27',0.00,0.00,0.00,33.34,0.00,'2022-06-23 10:07:36','',''),(561,'5','271','2',1,'Sale Id shift 27',0.00,0.00,0.00,1925.00,0.00,'2022-06-23 10:07:36','',''),(562,'5','271',NULL,2,'Sale Id shift 27',1660593.00,0.00,0.00,0.00,0.00,'2022-06-23 10:07:36','',''),(563,'5','271',NULL,1,'Sale Id shift 27',10069301.55,0.00,0.00,0.00,0.00,'2022-06-23 10:07:36','',''),(564,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:18:27','',''),(565,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:18:51','',''),(566,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-06-23 12:19:34','',''),(567,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:20:09','',''),(568,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:20:30','',''),(569,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7532250.00,45650.00,0.00,0.00,'2022-06-23 12:20:42','',''),(570,'5','271',NULL,2,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,29700000.00,45000.00,0.00,0.00,'2022-06-23 12:21:59','',''),(571,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:22:08','',''),(572,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-23 12:22:16','',''),(573,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:22:53','',''),(574,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:23:03','',''),(575,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9850500.00,59700.00,0.00,0.00,'2022-06-23 12:23:40','',''),(576,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:23:52','',''),(577,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,2310000.00,14000.00,0.00,0.00,'2022-06-23 12:24:33','',''),(578,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:24:42','',''),(579,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:24:51','',''),(580,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6570300.00,39820.00,0.00,0.00,'2022-06-23 12:26:13','',''),(581,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:26:21','',''),(582,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-23 12:26:29','',''),(583,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:27:32','',''),(584,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6550500.00,39700.00,0.00,0.00,'2022-06-23 12:27:39','',''),(585,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:28:16','',''),(586,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-23 12:28:27','',''),(587,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6525750.00,39550.00,0.00,0.00,'2022-06-23 12:29:02','',''),(588,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-23 12:29:09','',''),(589,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-23 12:29:15','',''),(590,'5','271',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,37000.00,0.00,'2022-06-23 13:01:25','',''),(591,'5','271','2',1,'Received from bridging 78',0.00,0.00,37000.00,0.00,0.00,'2022-06-23 13:01:25','',''),(592,'5','271',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,34000.00,0.00,'2022-06-23 13:01:34','',''),(593,'5','271','4',1,'Received from bridging 79',0.00,0.00,34000.00,0.00,0.00,'2022-06-23 13:01:34','',''),(594,'5','271',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,30000.00,0.00,'2022-06-23 13:01:43','',''),(595,'5','271','3',1,'Received from bridging 80',0.00,0.00,30000.00,0.00,0.00,'2022-06-23 13:01:43','',''),(596,'5','271',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,30000.00,0.00,'2022-06-23 13:01:54','',''),(597,'5','271','1',1,'Received from bridging 81',0.00,0.00,30000.00,0.00,0.00,'2022-06-23 13:01:54','',''),(598,'5','271','2',1,'Sale Id shift 28',0.00,0.00,0.00,164.32,0.00,'2022-06-23 14:14:36','',''),(599,'5','271','3',1,'Sale Id shift 28',0.00,0.00,0.00,7464.70,0.00,'2022-06-23 14:14:36','',''),(600,'5','271','3',1,'Sale Id shift 28',0.00,0.00,0.00,551.34,0.00,'2022-06-23 14:14:36','',''),(601,'5','271','3',1,'Sale Id shift 28',0.00,0.00,0.00,575.70,0.00,'2022-06-23 14:14:36','',''),(602,'5','271','4',1,'Sale Id shift 28',0.00,0.00,0.00,5633.98,0.00,'2022-06-23 14:14:36','',''),(603,'5','271','4',1,'Sale Id shift 28',0.00,0.00,0.00,2257.14,0.00,'2022-06-23 14:14:36','',''),(604,'5','271','5',2,'Sale Id shift 28',0.00,0.00,0.00,1673.79,0.00,'2022-06-23 14:14:36','',''),(605,'5','271','1',1,'Sale Id shift 28',0.00,0.00,0.00,6717.96,0.00,'2022-06-23 14:14:36','',''),(606,'5','271','1',1,'Sale Id shift 28',0.00,0.00,0.00,5528.70,0.00,'2022-06-23 14:14:36','',''),(607,'5','271','2',1,'Sale Id shift 28',0.00,0.00,0.00,1039.07,0.00,'2022-06-23 14:14:36','',''),(608,'5','271',NULL,2,'Sale Id shift 28',1104701.40,0.00,0.00,0.00,0.00,'2022-06-23 14:14:36','',''),(609,'5','271',NULL,1,'Sale Id shift 28',4938930.15,0.00,0.00,0.00,0.00,'2022-06-23 14:14:36','',''),(610,'5','271','2',1,'Sale Id shift 29',0.00,0.00,0.00,9655.66,0.00,'2022-06-23 14:27:27','',''),(611,'5','271','2',1,'Sale Id shift 29',0.00,0.00,0.00,8639.67,0.00,'2022-06-23 14:27:27','',''),(612,'5','271','3',1,'Sale Id shift 29',0.00,0.00,0.00,9145.30,0.00,'2022-06-23 14:27:27','',''),(613,'5','271','4',1,'Sale Id shift 29',0.00,0.00,0.00,4755.47,0.00,'2022-06-23 14:27:27','',''),(614,'5','271','4',1,'Sale Id shift 29',0.00,0.00,0.00,3073.88,0.00,'2022-06-23 14:27:27','',''),(615,'5','271','5',2,'Sale Id shift 29',0.00,0.00,0.00,3112.62,0.00,'2022-06-23 14:27:27','',''),(616,'5','271','1',1,'Sale Id shift 29',0.00,0.00,0.00,3867.01,0.00,'2022-06-23 14:27:27','',''),(617,'5','271','1',1,'Sale Id shift 29',0.00,0.00,0.00,3885.89,0.00,'2022-06-23 14:27:27','',''),(618,'5','271','2',1,'Sale Id shift 29',0.00,0.00,0.00,8461.03,0.00,'2022-06-23 14:27:27','',''),(619,'5','271',NULL,2,'Sale Id shift 29',2054329.20,0.00,0.00,0.00,0.00,'2022-06-23 14:27:27','',''),(620,'5','271',NULL,1,'Sale Id shift 29',8494845.15,0.00,0.00,0.00,0.00,'2022-06-23 14:27:27','',''),(621,'5','271','2',1,'Sale Id shift 30',0.00,0.00,0.00,6456.34,0.00,'2022-06-23 14:36:41','',''),(622,'5','271','2',1,'Sale Id shift 30',0.00,0.00,0.00,7397.23,0.00,'2022-06-23 14:36:41','',''),(623,'5','271','4',1,'Sale Id shift 30',0.00,0.00,0.00,9853.27,0.00,'2022-06-23 14:36:41','',''),(624,'5','271','4',1,'Sale Id shift 30',0.00,0.00,0.00,1321.41,0.00,'2022-06-23 14:36:41','',''),(625,'5','271','5',2,'Sale Id shift 30',0.00,0.00,0.00,2565.60,0.00,'2022-06-23 14:36:41','',''),(626,'5','271','1',1,'Sale Id shift 30',0.00,0.00,0.00,1706.73,0.00,'2022-06-23 14:36:41','',''),(627,'5','271','1',1,'Sale Id shift 30',0.00,0.00,0.00,1241.27,0.00,'2022-06-23 14:36:41','',''),(628,'5','271','2',1,'Sale Id shift 30',0.00,0.00,0.00,275.18,0.00,'2022-06-23 14:36:41','',''),(629,'5','271','2',1,'Sale Id shift 30',0.00,0.00,0.00,4367.29,0.00,'2022-06-23 14:36:41','',''),(630,'5','271',NULL,2,'Sale Id shift 30',1693296.00,0.00,0.00,0.00,0.00,'2022-06-23 14:36:41','',''),(631,'5','271',NULL,1,'Sale Id shift 30',5382088.80,0.00,0.00,0.00,0.00,'2022-06-23 14:36:41','',''),(632,'5','271','1',1,'Sale Id shift 31',0.00,0.00,0.00,3.93,0.00,'2022-06-23 14:47:37','',''),(633,'5','271','3',1,'Sale Id shift 31',0.00,0.00,0.00,7044.69,0.00,'2022-06-23 14:47:37','',''),(634,'5','271','3',1,'Sale Id shift 31',0.00,0.00,0.00,900.27,0.00,'2022-06-23 14:47:37','',''),(635,'5','271','3',1,'Sale Id shift 31',0.00,0.00,0.00,268.95,0.00,'2022-06-23 14:47:37','',''),(636,'5','271','4',1,'Sale Id shift 31',0.00,0.00,0.00,11894.65,0.00,'2022-06-23 14:47:37','',''),(637,'5','271','1',1,'Sale Id shift 31',0.00,0.00,0.00,200.05,0.00,'2022-06-23 14:47:37','',''),(638,'5','271','5',2,'Sale Id shift 31',0.00,0.00,0.00,3328.19,0.00,'2022-06-23 14:47:37','',''),(639,'5','271','1',1,'Sale Id shift 31',0.00,0.00,0.00,3242.80,0.00,'2022-06-23 14:47:37','',''),(640,'5','271','1',1,'Sale Id shift 31',0.00,0.00,0.00,9041.00,0.00,'2022-06-23 14:47:37','',''),(641,'5','271',NULL,2,'Sale Id shift 31',2196605.40,0.00,0.00,0.00,0.00,'2022-06-23 14:47:37','',''),(642,'5','271',NULL,1,'Sale Id shift 31',5378396.10,0.00,0.00,0.00,0.00,'2022-06-23 14:47:37','',''),(643,'5','271',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,8000.00,0.00,'2022-06-23 14:54:17','',''),(644,'5','271','2',1,'Received from bridging 83',0.00,0.00,8000.00,0.00,0.00,'2022-06-23 14:54:17','',''),(645,'5','271',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,11000.00,0.00,'2022-06-23 14:54:27','',''),(646,'5','271','4',1,'Received from bridging 84',0.00,0.00,11000.00,0.00,0.00,'2022-06-23 14:54:27','',''),(647,'5','271',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,21000.00,0.00,'2022-06-23 14:54:37','',''),(648,'5','271','1',1,'Received from bridging 85',0.00,0.00,21000.00,0.00,0.00,'2022-06-23 14:54:37','',''),(649,'5','271',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,34000.00,0.00,'2022-06-23 14:54:55','',''),(650,'5','271','3',1,'Received from bridging 86',0.00,0.00,34000.00,0.00,0.00,'2022-06-23 14:54:55','',''),(651,'5','271',NULL,2,'Reception corrector for bridging 87',0.00,0.00,0.00,34000.00,0.00,'2022-06-23 14:55:06','',''),(652,'5','271','5',2,'Received from bridging 87',0.00,0.00,34000.00,0.00,0.00,'2022-06-23 14:55:06','',''),(653,'5','271',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,38000.00,0.00,'2022-06-23 15:09:30','',''),(654,'5','271','2',1,'Received from bridging 88',0.00,0.00,38000.00,0.00,0.00,'2022-06-23 15:09:30','',''),(655,'5','271','3',1,'Sale Id shift 32',0.00,0.00,0.00,11621.20,0.00,'2022-06-23 15:18:01','',''),(656,'5','271','4',1,'Sale Id shift 32',0.00,0.00,0.00,2990.69,0.00,'2022-06-23 15:18:01','',''),(657,'5','271','5',2,'Sale Id shift 32',0.00,0.00,0.00,3016.15,0.00,'2022-06-23 15:18:01','',''),(658,'5','271','1',1,'Sale Id shift 32',0.00,0.00,0.00,10163.92,0.00,'2022-06-23 15:18:01','',''),(659,'5','271','1',1,'Sale Id shift 32',0.00,0.00,0.00,4597.96,0.00,'2022-06-23 15:18:01','',''),(660,'5','271',NULL,2,'Sale Id shift 32',1990659.00,0.00,0.00,0.00,0.00,'2022-06-23 15:18:01','',''),(661,'5','271',NULL,1,'Sale Id shift 32',4846672.05,0.00,0.00,0.00,0.00,'2022-06-23 15:18:01','',''),(662,'5','271','2',1,'Sale Id shift 33',0.00,0.00,0.00,3293.48,0.00,'2022-06-23 15:25:33','',''),(663,'5','271','3',1,'Sale Id shift 33',0.00,0.00,0.00,9746.08,0.00,'2022-06-23 15:25:33','',''),(664,'5','271','3',1,'Sale Id shift 33',0.00,0.00,0.00,79.52,0.00,'2022-06-23 15:25:33','',''),(665,'5','271','4',1,'Sale Id shift 33',0.00,0.00,0.00,11794.50,0.00,'2022-06-23 15:25:33','',''),(666,'5','271','4',1,'Sale Id shift 33',0.00,0.00,0.00,3936.76,0.00,'2022-06-23 15:25:33','',''),(667,'5','271','4',1,'Sale Id shift 33',0.00,0.00,0.00,20.92,0.00,'2022-06-23 15:25:33','',''),(668,'5','271','5',2,'Sale Id shift 33',0.00,0.00,0.00,3138.91,0.00,'2022-06-23 15:25:33','',''),(669,'5','271','2',1,'Sale Id shift 33',0.00,0.00,0.00,2904.25,0.00,'2022-06-23 15:25:33','',''),(670,'5','271','2',1,'Sale Id shift 33',0.00,0.00,0.00,2840.56,0.00,'2022-06-23 15:25:33','',''),(671,'5','271',NULL,2,'Sale Id shift 33',2071680.60,0.00,0.00,0.00,0.00,'2022-06-23 15:25:33','',''),(672,'5','271',NULL,1,'Sale Id shift 33',5711651.55,0.00,0.00,0.00,0.00,'2022-06-23 15:25:33','',''),(673,'5','271',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,11000.00,0.00,'2022-06-23 15:54:19','',''),(674,'5','271','3',1,'Received from bridging 89',0.00,0.00,11000.00,0.00,0.00,'2022-06-23 15:54:19','',''),(675,'5','271',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,24000.00,0.00,'2022-06-23 15:54:27','',''),(676,'5','271','1',1,'Received from bridging 90',0.00,0.00,24000.00,0.00,0.00,'2022-06-23 15:54:27','',''),(677,'5','271',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,7000.00,0.00,'2022-06-23 15:54:41','',''),(678,'5','271','2',1,'Received from bridging 91',0.00,0.00,7000.00,0.00,0.00,'2022-06-23 15:54:41','',''),(679,'5','271',NULL,1,'Reception corrector for bridging 92',0.00,0.00,0.00,40000.00,0.00,'2022-06-23 15:54:50','',''),(680,'5','271','4',1,'Received from bridging 92',0.00,0.00,40000.00,0.00,0.00,'2022-06-23 15:54:50','',''),(681,'5','271','2',1,'Sale Id shift 34',0.00,0.00,0.00,10321.62,0.00,'2022-06-23 16:02:06','',''),(682,'5','271','1',1,'Sale Id shift 34',0.00,0.00,0.00,9358.75,0.00,'2022-06-23 16:02:06','',''),(683,'5','271','5',2,'Sale Id shift 34',0.00,0.00,0.00,2426.26,0.00,'2022-06-23 16:02:06','',''),(684,'5','271','1',1,'Sale Id shift 34',0.00,0.00,0.00,8533.51,0.00,'2022-06-23 16:02:06','',''),(685,'5','271','1',1,'Sale Id shift 34',0.00,0.00,0.00,9435.93,0.00,'2022-06-23 16:02:06','',''),(686,'5','271','2',1,'Sale Id shift 34',0.00,0.00,0.00,8898.29,0.00,'2022-06-23 16:02:06','',''),(687,'5','271','2',1,'Sale Id shift 34',0.00,0.00,0.00,11897.32,0.00,'2022-06-23 16:02:06','',''),(688,'5','271',NULL,2,'Sale Id shift 34',1601331.60,0.00,0.00,0.00,0.00,'2022-06-23 16:02:06','',''),(689,'5','271',NULL,1,'Sale Id shift 34',9643494.30,0.00,0.00,0.00,0.00,'2022-06-23 16:02:06','',''),(690,'5','271',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,1424.00,0.00,'2022-06-23 16:23:37','',''),(691,'5','271','1',1,'Received from bridging 94',0.00,0.00,1424.00,0.00,0.00,'2022-06-23 16:23:37','',''),(692,'5','271',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,34000.00,0.00,'2022-06-23 16:23:49','',''),(693,'5','271','2',1,'Received from bridging 93',0.00,0.00,34000.00,0.00,0.00,'2022-06-23 16:23:49','',''),(694,'5','271',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,32500.00,0.00,'2022-06-24 09:53:15','',''),(695,'5','271','1',1,'Received from bridging 95',0.00,0.00,32500.00,0.00,0.00,'2022-06-24 09:53:15','',''),(696,'5','271',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,19000.00,0.00,'2022-06-24 10:02:16','',''),(697,'5','271','3',1,'Received from bridging 96',0.00,0.00,19000.00,0.00,0.00,'2022-06-24 10:02:16','',''),(698,'5','271','2',1,'Sale Id shift 35',0.00,0.00,0.00,2437.19,0.00,'2022-06-24 11:35:59','',''),(699,'5','271','1',1,'Sale Id shift 35',0.00,0.00,0.00,6158.10,0.00,'2022-06-24 11:35:59','',''),(700,'5','271','5',2,'Sale Id shift 35',0.00,0.00,0.00,5885.85,0.00,'2022-06-24 11:35:59','',''),(701,'5','271','1',1,'Sale Id shift 35',0.00,0.00,0.00,1843.28,0.00,'2022-06-24 11:35:59','',''),(702,'5','271','1',1,'Sale Id shift 35',0.00,0.00,0.00,9877.29,0.00,'2022-06-24 11:35:59','',''),(703,'5','271','2',1,'Sale Id shift 35',0.00,0.00,0.00,1827.62,0.00,'2022-06-24 11:35:59','',''),(704,'5','271','2',1,'Sale Id shift 35',0.00,0.00,0.00,5747.75,0.00,'2022-06-24 11:35:59','',''),(705,'5','271',NULL,2,'Sale Id shift 35',3884661.00,0.00,0.00,0.00,0.00,'2022-06-24 11:35:59','',''),(706,'5','271',NULL,1,'Sale Id shift 35',4602052.95,0.00,0.00,0.00,0.00,'2022-06-24 11:35:59','',''),(707,'5','271','2',1,'Sale Id shift 36',0.00,0.00,0.00,11946.93,0.00,'2022-06-24 12:11:41','',''),(708,'5','271','5',2,'Sale Id shift 36',0.00,0.00,0.00,6932.02,0.00,'2022-06-24 12:11:41','',''),(709,'5','271','2',1,'Sale Id shift 36',0.00,0.00,0.00,12101.75,0.00,'2022-06-24 12:11:41','',''),(710,'5','271','2',1,'Sale Id shift 36',0.00,0.00,0.00,7964.80,0.00,'2022-06-24 12:11:41','',''),(711,'5','271',NULL,2,'Sale Id shift 36',4575133.20,0.00,0.00,0.00,0.00,'2022-06-24 12:11:41','',''),(712,'5','271',NULL,1,'Sale Id shift 36',5282224.20,0.00,0.00,0.00,0.00,'2022-06-24 12:11:41','',''),(713,'5','271','2',1,'Sale Id shift 37',0.00,0.00,0.00,6271.46,0.00,'2022-06-24 12:25:49','',''),(714,'5','271','3',1,'Sale Id shift 37',0.00,0.00,0.00,7265.86,0.00,'2022-06-24 12:25:49','',''),(715,'5','271','3',1,'Sale Id shift 37',0.00,0.00,0.00,1677.25,0.00,'2022-06-24 12:25:49','',''),(716,'5','271','5',2,'Sale Id shift 37',0.00,0.00,0.00,11307.82,0.00,'2022-06-24 12:25:49','',''),(717,'5','271','5',2,'Sale Id shift 37',0.00,0.00,0.00,3753.45,0.00,'2022-06-24 12:25:49','',''),(718,'5','271','1',1,'Sale Id shift 37',0.00,0.00,0.00,2168.92,0.00,'2022-06-24 12:25:49','',''),(719,'5','271','1',1,'Sale Id shift 37',0.00,0.00,0.00,1942.61,0.00,'2022-06-24 12:25:49','',''),(720,'5','271','2',1,'Sale Id shift 37',0.00,0.00,0.00,1089.26,0.00,'2022-06-24 12:25:49','',''),(721,'5','271',NULL,2,'Sale Id shift 37',9940438.20,0.00,0.00,0.00,0.00,'2022-06-24 12:25:49','',''),(722,'5','271',NULL,1,'Sale Id shift 37',3368534.40,0.00,0.00,0.00,0.00,'2022-06-24 12:25:49','',''),(723,'5','271',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,45000.00,0.00,'2022-06-24 15:56:03','',''),(724,'5','271','2',1,'Received from bridging 97',0.00,0.00,45000.00,0.00,0.00,'2022-06-24 15:56:03','',''),(725,'5','271',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,22000.00,0.00,'2022-06-24 15:56:14','',''),(726,'5','271','1',1,'Received from bridging 98',0.00,0.00,22000.00,0.00,0.00,'2022-06-24 15:56:14','',''),(727,'5','271',NULL,2,'Reception corrector for bridging 100',0.00,0.00,0.00,11000.00,0.00,'2022-06-27 11:13:12','',''),(728,'5','271','5',2,'Received from bridging 100',0.00,0.00,11000.00,0.00,0.00,'2022-06-27 11:13:12','',''),(729,'5','271','2',1,'Sale Id shift 39',0.00,0.00,0.00,11350.89,0.00,'2022-06-27 11:38:00','',''),(730,'5','271','3',1,'Sale Id shift 39',0.00,0.00,0.00,7927.57,0.00,'2022-06-27 11:38:00','',''),(731,'5','271','5',2,'Sale Id shift 39',0.00,0.00,0.00,10487.69,0.00,'2022-06-27 11:38:00','',''),(732,'5','271','5',2,'Sale Id shift 39',0.00,0.00,0.00,10986.14,0.00,'2022-06-27 11:38:00','',''),(733,'5','271','2',1,'Sale Id shift 39',0.00,0.00,0.00,6911.65,0.00,'2022-06-27 11:38:00','',''),(734,'5','271',NULL,2,'Sale Id shift 39',14387466.10,0.00,0.00,0.00,0.00,'2022-06-27 11:38:00','',''),(735,'5','271',NULL,1,'Sale Id shift 39',4321368.15,0.00,0.00,0.00,0.00,'2022-06-27 11:38:00','',''),(736,'5','271',NULL,2,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,36900000.00,45000.00,0.00,0.00,'2022-06-27 12:11:37','',''),(737,'5','271',NULL,2,'Reception corrector for bridging 101',0.00,0.00,0.00,45000.00,0.00,'2022-06-27 12:16:55','',''),(738,'5','271','5',2,'Received from bridging 101',0.00,0.00,45000.00,0.00,0.00,'2022-06-27 12:16:55','',''),(739,'5','271',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,15700.00,0.00,'2022-06-27 12:33:02','',''),(740,'5','271','2',1,'Received from bridging 102',0.00,0.00,15700.00,0.00,0.00,'2022-06-27 12:33:02','',''),(741,'5','271','2',1,'Sale Id shift 41',0.00,0.00,0.00,5393.79,0.00,'2022-06-27 12:54:33','',''),(742,'5','271','3',1,'Sale Id shift 41',0.00,0.00,0.00,10408.26,0.00,'2022-06-27 12:54:33','',''),(743,'5','271','3',1,'Sale Id shift 41',0.00,0.00,0.00,497.77,0.00,'2022-06-27 12:54:33','',''),(744,'5','271','5',2,'Sale Id shift 41',0.00,0.00,0.00,3441.27,0.00,'2022-06-27 12:54:33','',''),(745,'5','271','1',1,'Sale Id shift 41',0.00,0.00,0.00,3228.30,0.00,'2022-06-27 12:54:33','',''),(746,'5','271','1',1,'Sale Id shift 41',0.00,0.00,0.00,3184.94,0.00,'2022-06-27 12:54:33','',''),(747,'5','271','2',1,'Sale Id shift 41',0.00,0.00,0.00,6446.29,0.00,'2022-06-27 12:54:33','',''),(748,'5','271',NULL,2,'Sale Id shift 41',2821841.40,0.00,0.00,0.00,0.00,'2022-06-27 12:54:33','',''),(749,'5','271',NULL,1,'Sale Id shift 41',4811292.75,0.00,0.00,0.00,0.00,'2022-06-27 12:54:33','',''),(750,'5','271',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,21000.00,0.00,'2022-06-27 13:47:59','',''),(751,'5','271','3',1,'Received from bridging 103',0.00,0.00,21000.00,0.00,0.00,'2022-06-27 13:47:59','',''),(752,'5','271',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,18000.00,0.00,'2022-06-27 13:48:06','',''),(753,'5','271','2',1,'Received from bridging 104',0.00,0.00,18000.00,0.00,0.00,'2022-06-27 13:48:06','',''),(754,'5','271','2',1,'Sale Id shift 42',0.00,0.00,0.00,11173.16,0.00,'2022-06-28 11:04:35','',''),(755,'5','271','3',1,'Sale Id shift 42',0.00,0.00,0.00,7965.17,0.00,'2022-06-28 11:04:35','',''),(756,'5','271','2',1,'Sale Id shift 42',0.00,0.00,0.00,4794.06,0.00,'2022-06-28 11:04:35','',''),(757,'5','271','2',1,'Sale Id shift 42',0.00,0.00,0.00,10470.14,0.00,'2022-06-28 11:04:35','',''),(758,'5','271',NULL,1,'Sale Id shift 42',5676417.45,0.00,0.00,0.00,0.00,'2022-06-28 11:04:35','',''),(759,'5','271','2',1,'Sale Id shift 43',0.00,0.00,0.00,8937.02,0.00,'2022-06-28 11:12:35','',''),(760,'5','271','3',1,'Sale Id shift 43',0.00,0.00,0.00,7161.15,0.00,'2022-06-28 11:12:35','',''),(761,'5','271','4',1,'Sale Id shift 43',0.00,0.00,0.00,2132.45,0.00,'2022-06-28 11:12:35','',''),(762,'5','271','1',1,'Sale Id shift 43',0.00,0.00,0.00,3681.85,0.00,'2022-06-28 11:12:35','',''),(763,'5','271','2',1,'Sale Id shift 43',0.00,0.00,0.00,9926.03,0.00,'2022-06-28 11:12:35','',''),(764,'5','271',NULL,1,'Sale Id shift 43',5253352.50,0.00,0.00,0.00,0.00,'2022-06-28 11:12:35','',''),(765,'5','271',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,22000.00,0.00,'2022-06-28 11:17:14','',''),(766,'5','271','2',1,'Received from bridging 105',0.00,0.00,22000.00,0.00,0.00,'2022-06-28 11:17:14','',''),(767,'5','271','2',1,'Sale Id shift 44',0.00,0.00,0.00,10451.53,0.00,'2022-06-28 11:21:55','',''),(768,'5','271','3',1,'Sale Id shift 44',0.00,0.00,0.00,2524.32,0.00,'2022-06-28 11:21:55','',''),(769,'5','271','4',1,'Sale Id shift 44',0.00,0.00,0.00,11667.36,0.00,'2022-06-28 11:21:55','',''),(770,'5','271','1',1,'Sale Id shift 44',0.00,0.00,0.00,5136.47,0.00,'2022-06-28 11:21:55','',''),(771,'5','271','1',1,'Sale Id shift 44',0.00,0.00,0.00,9287.94,0.00,'2022-06-28 11:21:55','',''),(772,'5','271','2',1,'Sale Id shift 44',0.00,0.00,0.00,6656.57,0.00,'2022-06-28 11:21:55','',''),(773,'5','271',NULL,1,'Sale Id shift 44',7544491.35,0.00,0.00,0.00,0.00,'2022-06-28 11:21:55','',''),(774,'5','271',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,22000.00,0.00,'2022-06-28 11:46:42','',''),(775,'5','271','1',1,'Received from bridging 99',0.00,0.00,22000.00,0.00,0.00,'2022-06-28 11:46:42','',''),(776,'5','271',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,14000.00,0.00,'2022-06-28 11:46:55','',''),(777,'5','271','2',1,'Received from bridging 107',0.00,0.00,14000.00,0.00,0.00,'2022-06-28 11:46:55','',''),(778,'5','271',NULL,1,'Reception corrector for bridging 109',0.00,0.00,0.00,21000.00,0.00,'2022-06-28 11:47:08','',''),(779,'5','271','4',1,'Received from bridging 109',0.00,0.00,21000.00,0.00,0.00,'2022-06-28 11:47:08','',''),(780,'5','271',NULL,1,'Reception corrector for bridging 110',0.00,0.00,0.00,24000.00,0.00,'2022-06-28 11:47:15','',''),(781,'5','271','3',1,'Received from bridging 110',0.00,0.00,24000.00,0.00,0.00,'2022-06-28 11:47:15','',''),(782,'5','271','2',1,'Sale Id shift 45',0.00,0.00,0.00,10381.30,0.00,'2022-06-28 11:48:59','',''),(783,'5','271','4',1,'Sale Id shift 45',0.00,0.00,0.00,10875.80,0.00,'2022-06-28 11:48:59','',''),(784,'5','271','1',1,'Sale Id shift 45',0.00,0.00,0.00,7390.98,0.00,'2022-06-28 11:48:59','',''),(785,'5','271','1',1,'Sale Id shift 45',0.00,0.00,0.00,7782.31,0.00,'2022-06-28 11:48:59','',''),(786,'5','271','2',1,'Sale Id shift 45',0.00,0.00,0.00,693.66,0.00,'2022-06-28 11:48:59','',''),(787,'5','271',NULL,1,'Sale Id shift 45',6125468.25,0.00,0.00,0.00,0.00,'2022-06-28 11:48:59','',''),(788,'5','271',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,38000.00,0.00,'2022-06-28 12:28:19','',''),(789,'5','271','2',1,'Received from bridging 111',0.00,0.00,38000.00,0.00,0.00,'2022-06-28 12:28:19','',''),(790,'5','271','2',1,'Sale Id shift 46',0.00,0.00,0.00,4903.81,0.00,'2022-06-28 12:32:11','',''),(791,'5','271','3',1,'Sale Id shift 46',0.00,0.00,0.00,10679.11,0.00,'2022-06-28 12:32:11','',''),(792,'5','271','4',1,'Sale Id shift 46',0.00,0.00,0.00,10234.21,0.00,'2022-06-28 12:32:11','',''),(793,'5','271','4',1,'Sale Id shift 46',0.00,0.00,0.00,0.17,0.00,'2022-06-28 12:32:11','',''),(794,'5','271','4',1,'Sale Id shift 46',0.00,0.00,0.00,1.29,0.00,'2022-06-28 12:32:11','',''),(795,'5','271','1',1,'Sale Id shift 46',0.00,0.00,0.00,3342.81,0.00,'2022-06-28 12:32:11','',''),(796,'5','271','2',1,'Sale Id shift 46',0.00,0.00,0.00,1151.45,0.00,'2022-06-28 12:32:11','',''),(797,'5','271','2',1,'Sale Id shift 46',0.00,0.00,0.00,1623.32,0.00,'2022-06-28 12:32:11','',''),(798,'5','271',NULL,1,'Sale Id shift 46',5269468.05,0.00,0.00,0.00,0.00,'2022-06-28 12:32:11','',''),(799,'5','271',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,18820.00,0.00,'2022-06-28 12:46:46','',''),(800,'5','271','4',1,'Received from bridging 112',0.00,0.00,18820.00,0.00,0.00,'2022-06-28 12:46:46','',''),(801,'5','271',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,2000.00,0.00,'2022-06-28 12:46:54','',''),(802,'5','271','2',1,'Received from bridging 113',0.00,0.00,2000.00,0.00,0.00,'2022-06-28 12:46:54','',''),(803,'5','271',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,21000.00,0.00,'2022-06-28 12:47:02','',''),(804,'5','271','1',1,'Received from bridging 114',0.00,0.00,21000.00,0.00,0.00,'2022-06-28 12:47:02','',''),(805,'5','271','2',1,'Sale Id shift 47',0.00,0.00,0.00,7830.07,0.00,'2022-06-28 12:51:35','',''),(806,'5','271','3',1,'Sale Id shift 47',0.00,0.00,0.00,10968.42,0.00,'2022-06-28 12:51:35','',''),(807,'5','271','3',1,'Sale Id shift 47',0.00,0.00,0.00,200.94,0.00,'2022-06-28 12:51:35','',''),(808,'5','271','4',1,'Sale Id shift 47',0.00,0.00,0.00,5018.35,0.00,'2022-06-28 12:51:35','',''),(809,'5','271','1',1,'Sale Id shift 47',0.00,0.00,0.00,1335.18,0.00,'2022-06-28 12:51:35','',''),(810,'5','271','1',1,'Sale Id shift 47',0.00,0.00,0.00,1310.32,0.00,'2022-06-28 12:51:35','',''),(811,'5','271','2',1,'Sale Id shift 47',0.00,0.00,0.00,3494.41,0.00,'2022-06-28 12:51:35','',''),(812,'5','271','2',1,'Sale Id shift 47',0.00,0.00,0.00,282.56,0.00,'2022-06-28 12:51:35','',''),(813,'5','271',NULL,1,'Sale Id shift 47',5022641.25,0.00,0.00,0.00,0.00,'2022-06-28 12:51:35','',''),(814,'5','271','2',1,'Sale Id shift 48',0.00,0.00,0.00,12055.99,0.00,'2022-06-28 12:59:28','',''),(815,'5','271','3',1,'Sale Id shift 48',0.00,0.00,0.00,10091.93,0.00,'2022-06-28 12:59:28','',''),(816,'5','271','4',1,'Sale Id shift 48',0.00,0.00,0.00,201.53,0.00,'2022-06-28 12:59:28','',''),(817,'5','271','1',1,'Sale Id shift 48',0.00,0.00,0.00,1981.51,0.00,'2022-06-28 12:59:28','',''),(818,'5','271','1',1,'Sale Id shift 48',0.00,0.00,0.00,10227.30,0.00,'2022-06-28 12:59:28','',''),(819,'5','271','2',1,'Sale Id shift 48',0.00,0.00,0.00,9550.19,0.00,'2022-06-28 12:59:28','',''),(820,'5','271',NULL,1,'Sale Id shift 48',7277894.25,0.00,0.00,0.00,0.00,'2022-06-28 12:59:28','',''),(821,'5','271',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,11650.00,0.00,'2022-06-28 12:59:48','',''),(822,'5','271','2',1,'Received from bridging 115',0.00,0.00,11650.00,0.00,0.00,'2022-06-28 12:59:48','',''),(823,'5','271',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,21000.00,0.00,'2022-06-28 12:59:58','',''),(824,'5','271','3',1,'Received from bridging 116',0.00,0.00,21000.00,0.00,0.00,'2022-06-28 12:59:58','',''),(825,'5','271',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,14000.00,0.00,'2022-06-28 13:34:04','',''),(826,'5','271','1',1,'Received from bridging 117',0.00,0.00,14000.00,0.00,0.00,'2022-06-28 13:34:04','',''),(827,'5','271',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,27000.00,0.00,'2022-06-28 13:34:13','',''),(828,'5','271','2',1,'Received from bridging 118',0.00,0.00,27000.00,0.00,0.00,'2022-06-28 13:34:13','',''),(829,'5','271','2',1,'Sale Id shift 49',0.00,0.00,0.00,8842.77,0.00,'2022-06-28 14:30:28','',''),(830,'5','271','3',1,'Sale Id shift 49',0.00,0.00,0.00,8101.57,0.00,'2022-06-28 14:30:28','',''),(831,'5','271','4',1,'Sale Id shift 49',0.00,0.00,0.00,2036.54,0.00,'2022-06-28 14:30:28','',''),(832,'5','271','1',1,'Sale Id shift 49',0.00,0.00,0.00,2332.31,0.00,'2022-06-28 14:30:28','',''),(833,'5','271','1',1,'Sale Id shift 49',0.00,0.00,0.00,11285.55,0.00,'2022-06-28 14:30:28','',''),(834,'5','271','2',1,'Sale Id shift 49',0.00,0.00,0.00,5805.56,0.00,'2022-06-28 14:30:28','',''),(835,'5','271',NULL,1,'Sale Id shift 49',6336709.50,0.00,0.00,0.00,0.00,'2022-06-28 14:30:28','',''),(836,'5','271','3',1,'Sale Id shift 50',0.00,0.00,0.00,10749.15,0.00,'2022-06-28 15:22:14','',''),(837,'5','271','4',1,'Sale Id shift 50',0.00,0.00,0.00,13517.85,0.00,'2022-06-28 15:22:14','',''),(838,'5','271','1',1,'Sale Id shift 50',0.00,0.00,0.00,504.53,0.00,'2022-06-28 15:22:14','',''),(839,'5','271','1',1,'Sale Id shift 50',0.00,0.00,0.00,10094.55,0.00,'2022-06-28 15:22:14','',''),(840,'5','271',NULL,1,'Sale Id shift 50',5752903.20,0.00,0.00,0.00,0.00,'2022-06-28 15:22:14','',''),(841,'5','271',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,19000.00,0.00,'2022-06-28 15:50:33','',''),(842,'5','271','1',1,'Received from bridging 119',0.00,0.00,19000.00,0.00,0.00,'2022-06-28 15:50:33','',''),(843,'5','271',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,9000.00,0.00,'2022-06-28 15:50:46','',''),(844,'5','271','2',1,'Received from bridging 120',0.00,0.00,9000.00,0.00,0.00,'2022-06-28 15:50:46','',''),(845,'5','271',NULL,1,'Reception corrector for bridging 121',0.00,0.00,0.00,30000.00,0.00,'2022-06-28 15:50:55','',''),(846,'5','271','3',1,'Received from bridging 121',0.00,0.00,30000.00,0.00,0.00,'2022-06-28 15:50:55','',''),(847,'5','271',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,23000.00,0.00,'2022-06-28 15:51:04','',''),(848,'5','271','4',1,'Received from bridging 122',0.00,0.00,23000.00,0.00,0.00,'2022-06-28 15:51:04','',''),(849,'5','271','2',1,'Sale Id shift 51',0.00,0.00,0.00,4073.47,0.00,'2022-06-28 15:56:47','',''),(850,'5','271','3',1,'Sale Id shift 51',0.00,0.00,0.00,10769.51,0.00,'2022-06-28 15:56:47','',''),(851,'5','271','4',1,'Sale Id shift 51',0.00,0.00,0.00,13312.84,0.00,'2022-06-28 15:56:47','',''),(852,'5','271','4',1,'Sale Id shift 51',0.00,0.00,0.00,8715.52,0.00,'2022-06-28 15:56:47','',''),(853,'5','271','1',1,'Sale Id shift 51',0.00,0.00,0.00,1361.72,0.00,'2022-06-28 15:56:47','',''),(854,'5','271','1',1,'Sale Id shift 51',0.00,0.00,0.00,301.25,0.00,'2022-06-28 15:56:47','',''),(855,'5','271','2',1,'Sale Id shift 51',0.00,0.00,0.00,291.42,0.00,'2022-06-28 15:56:47','',''),(856,'5','271',NULL,1,'Sale Id shift 51',6406245.45,0.00,0.00,0.00,0.00,'2022-06-28 15:56:47','',''),(857,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7348275.00,44535.00,0.00,0.00,'2022-06-28 16:00:49','',''),(858,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7398600.00,44840.00,0.00,0.00,'2022-06-28 16:00:56','',''),(859,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6484500.00,39300.00,0.00,0.00,'2022-06-28 16:01:06','',''),(860,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6517500.00,39500.00,0.00,0.00,'2022-06-28 16:01:13','',''),(861,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6535650.00,39610.00,0.00,0.00,'2022-06-28 16:01:21','',''),(862,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 16:01:29','',''),(863,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 16:04:50','',''),(864,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-28 16:04:57','',''),(865,'5','271','2',1,'Sale Id shift 52',0.00,0.00,0.00,10654.60,0.00,'2022-06-28 16:05:31','',''),(866,'5','271','3',1,'Sale Id shift 52',0.00,0.00,0.00,9655.82,0.00,'2022-06-28 16:05:31','',''),(867,'5','271','4',1,'Sale Id shift 52',0.00,0.00,0.00,2137.72,0.00,'2022-06-28 16:05:31','',''),(868,'5','271','1',1,'Sale Id shift 52',0.00,0.00,0.00,7663.28,0.00,'2022-06-28 16:05:31','',''),(869,'5','271','2',1,'Sale Id shift 52',0.00,0.00,0.00,6585.84,0.00,'2022-06-28 16:05:31','',''),(870,'5','271',NULL,1,'Sale Id shift 52',6055047.90,0.00,0.00,0.00,0.00,'2022-06-28 16:05:31','',''),(871,'5','271','2',1,'Sale Id shift 53',0.00,0.00,0.00,12733.40,0.00,'2022-06-28 16:16:26','',''),(872,'5','271','3',1,'Sale Id shift 53',0.00,0.00,0.00,5017.44,0.00,'2022-06-28 16:16:26','',''),(873,'5','271','4',1,'Sale Id shift 53',0.00,0.00,0.00,1668.25,0.00,'2022-06-28 16:16:26','',''),(874,'5','271','1',1,'Sale Id shift 53',0.00,0.00,0.00,1638.71,0.00,'2022-06-28 16:16:27','',''),(875,'5','271','1',1,'Sale Id shift 53',0.00,0.00,0.00,8249.45,0.00,'2022-06-28 16:16:27','',''),(876,'5','271',NULL,1,'Sale Id shift 53',4835696.25,0.00,0.00,0.00,0.00,'2022-06-28 16:16:27','',''),(877,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-28 16:27:57','',''),(878,'5','271','2',1,'Sale Id shift 54',0.00,0.00,0.00,2251.02,0.00,'2022-06-28 16:35:29','',''),(879,'5','271','3',1,'Sale Id shift 54',0.00,0.00,0.00,4631.21,0.00,'2022-06-28 16:35:29','',''),(880,'5','271','4',1,'Sale Id shift 54',0.00,0.00,0.00,12186.23,0.00,'2022-06-28 16:35:29','',''),(881,'5','271','4',1,'Sale Id shift 54',0.00,0.00,0.00,9475.86,0.00,'2022-06-28 16:35:29','',''),(882,'5','271','1',1,'Sale Id shift 54',0.00,0.00,0.00,3690.42,0.00,'2022-06-28 16:35:29','',''),(883,'5','271','1',1,'Sale Id shift 54',0.00,0.00,0.00,9187.95,0.00,'2022-06-28 16:35:29','',''),(884,'5','271','1',1,'Sale Id shift 54',0.00,0.00,0.00,4889.26,0.00,'2022-06-28 16:35:29','',''),(885,'5','271',NULL,1,'Sale Id shift 54',7641471.75,0.00,0.00,0.00,0.00,'2022-06-28 16:35:29','',''),(886,'5','271',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 16:36:13','',''),(887,'5','271','3',1,'Received from bridging 123',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 16:36:13','',''),(888,'5','271',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,16700.00,0.00,'2022-06-28 16:36:22','',''),(889,'5','271','4',1,'Received from bridging 124',0.00,0.00,16700.00,0.00,0.00,'2022-06-28 16:36:22','',''),(890,'5','271',NULL,1,'Reception corrector for bridging 125',0.00,0.00,0.00,40000.00,0.00,'2022-06-28 16:36:31','',''),(891,'5','271','2',1,'Received from bridging 125',0.00,0.00,40000.00,0.00,0.00,'2022-06-28 16:36:31','',''),(892,'5','271',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,25000.00,0.00,'2022-06-28 16:36:41','',''),(893,'5','271','1',1,'Received from bridging 126',0.00,0.00,25000.00,0.00,0.00,'2022-06-28 16:36:41','',''),(894,'5','271','2',1,'Sale Id shift 55',0.00,0.00,0.00,11191.43,0.00,'2022-06-28 16:42:41','',''),(895,'5','271','3',1,'Sale Id shift 55',0.00,0.00,0.00,9135.73,0.00,'2022-06-28 16:42:41','',''),(896,'5','271','3',1,'Sale Id shift 55',0.00,0.00,0.00,162.71,0.00,'2022-06-28 16:42:41','',''),(897,'5','271','4',1,'Sale Id shift 55',0.00,0.00,0.00,6974.48,0.00,'2022-06-28 16:42:41','',''),(898,'5','271','4',1,'Sale Id shift 55',0.00,0.00,0.00,9786.91,0.00,'2022-06-28 16:42:41','',''),(899,'5','271','1',1,'Sale Id shift 55',0.00,0.00,0.00,5200.59,0.00,'2022-06-28 16:42:41','',''),(900,'5','271',NULL,1,'Sale Id shift 55',7004555.25,0.00,0.00,0.00,0.00,'2022-06-28 16:42:41','',''),(901,'5','271','2',1,'Sale Id shift 56',0.00,0.00,0.00,3964.92,0.00,'2022-06-28 16:50:59','',''),(902,'5','271','3',1,'Sale Id shift 56',0.00,0.00,0.00,9313.43,0.00,'2022-06-28 16:50:59','',''),(903,'5','271','3',1,'Sale Id shift 56',0.00,0.00,0.00,6831.11,0.00,'2022-06-28 16:50:59','',''),(904,'5','271','1',1,'Sale Id shift 56',0.00,0.00,0.00,3867.98,0.00,'2022-06-28 16:50:59','',''),(905,'5','271','1',1,'Sale Id shift 56',0.00,0.00,0.00,8871.92,0.00,'2022-06-28 16:50:59','',''),(906,'5','271',NULL,1,'Sale Id shift 56',5420144.40,0.00,0.00,0.00,0.00,'2022-06-28 16:50:59','',''),(907,'5','271',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,5000.00,0.00,'2022-06-28 16:58:31','',''),(908,'5','271','2',1,'Received from bridging 127',0.00,0.00,5000.00,0.00,0.00,'2022-06-28 16:58:31','',''),(909,'5','271',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 16:58:41','',''),(910,'5','271','1',1,'Received from bridging 130',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 16:58:41','',''),(911,'5','271',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,38550.00,0.00,'2022-06-28 17:06:30','',''),(912,'5','271','4',1,'Received from bridging 131',0.00,0.00,38550.00,0.00,0.00,'2022-06-28 17:06:30','',''),(913,'5','271',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,40000.00,0.00,'2022-06-28 17:06:37','',''),(914,'5','271','3',1,'Received from bridging 132',0.00,0.00,40000.00,0.00,0.00,'2022-06-28 17:06:37','',''),(915,'5','271','2',1,'Sale Id shift 57',0.00,0.00,0.00,412.94,0.00,'2022-06-28 17:07:28','',''),(916,'5','271','3',1,'Sale Id shift 57',0.00,0.00,0.00,9578.71,0.00,'2022-06-28 17:07:28','',''),(917,'5','271','3',1,'Sale Id shift 57',0.00,0.00,0.00,9225.91,0.00,'2022-06-28 17:07:28','',''),(918,'5','271','4',1,'Sale Id shift 57',0.00,0.00,0.00,9635.17,0.00,'2022-06-28 17:07:28','',''),(919,'5','271','4',1,'Sale Id shift 57',0.00,0.00,0.00,8487.86,0.00,'2022-06-28 17:07:28','',''),(920,'5','271','1',1,'Sale Id shift 57',0.00,0.00,0.00,2252.96,0.00,'2022-06-28 17:07:28','',''),(921,'5','271','1',1,'Sale Id shift 57',0.00,0.00,0.00,6473.34,0.00,'2022-06-28 17:07:28','',''),(922,'5','271','2',1,'Sale Id shift 57',0.00,0.00,0.00,469.08,0.00,'2022-06-28 17:07:28','',''),(923,'5','271',NULL,1,'Sale Id shift 57',7678435.05,0.00,0.00,0.00,0.00,'2022-06-28 17:07:28','',''),(924,'5','271',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,10000.00,0.00,'2022-06-28 17:07:53','',''),(925,'5','271','1',1,'Received from bridging 133',0.00,0.00,10000.00,0.00,0.00,'2022-06-28 17:07:53','',''),(926,'5','271','4',1,'Sale Id shift 58',0.00,0.00,0.00,3626.07,0.00,'2022-06-28 17:12:24','',''),(927,'5','271','4',1,'Sale Id shift 58',0.00,0.00,0.00,8422.59,0.00,'2022-06-28 17:12:24','',''),(928,'5','271','1',1,'Sale Id shift 58',0.00,0.00,0.00,8444.28,0.00,'2022-06-28 17:12:24','',''),(929,'5','271','1',1,'Sale Id shift 58',0.00,0.00,0.00,7736.56,0.00,'2022-06-28 17:12:24','',''),(930,'5','271','2',1,'Sale Id shift 58',0.00,0.00,0.00,8723.22,0.00,'2022-06-28 17:12:24','',''),(931,'5','271',NULL,1,'Sale Id shift 58',6097198.80,0.00,0.00,0.00,0.00,'2022-06-28 17:12:24','',''),(932,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-28 17:13:55','',''),(933,'5','271',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,22000.00,0.00,'2022-06-29 10:57:21','',''),(934,'5','271','2',1,'Received from bridging 134',0.00,0.00,22000.00,0.00,0.00,'2022-06-29 10:57:21','',''),(935,'5','271',NULL,1,'Reception corrector for bridging 135',0.00,0.00,0.00,15000.00,0.00,'2022-06-29 10:57:33','',''),(936,'5','271','3',1,'Received from bridging 135',0.00,0.00,15000.00,0.00,0.00,'2022-06-29 10:57:33','',''),(937,'5','271',NULL,1,'Reception corrector for bridging 136',0.00,0.00,0.00,39000.00,0.00,'2022-06-29 10:57:44','',''),(938,'5','271','4',1,'Received from bridging 136',0.00,0.00,39000.00,0.00,0.00,'2022-06-29 10:57:44','',''),(939,'5','271',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,35000.00,0.00,'2022-06-29 10:57:57','',''),(940,'5','271','1',1,'Received from bridging 137',0.00,0.00,35000.00,0.00,0.00,'2022-06-29 10:57:57','',''),(941,'5','271','3',1,'Sale Id shift 59',0.00,0.00,0.00,650.97,0.00,'2022-06-29 11:18:49','',''),(942,'5','271','3',1,'Sale Id shift 59',0.00,0.00,0.00,369.34,0.00,'2022-06-29 11:18:49','',''),(943,'5','271','4',1,'Sale Id shift 59',0.00,0.00,0.00,297.22,0.00,'2022-06-29 11:18:49','',''),(944,'5','271','4',1,'Sale Id shift 59',0.00,0.00,0.00,9166.09,0.00,'2022-06-29 11:18:49','',''),(945,'5','271','1',1,'Sale Id shift 59',0.00,0.00,0.00,10013.29,0.00,'2022-06-29 11:18:49','',''),(946,'5','271','1',1,'Sale Id shift 59',0.00,0.00,0.00,9335.33,0.00,'2022-06-29 11:18:49','',''),(947,'5','271','2',1,'Sale Id shift 59',0.00,0.00,0.00,12760.97,0.00,'2022-06-29 11:18:49','',''),(948,'5','271',NULL,1,'Sale Id shift 59',7027879.65,0.00,0.00,0.00,0.00,'2022-06-29 11:18:49','',''),(949,'5','271','3',1,'Sale Id shift 60',0.00,0.00,0.00,7998.55,0.00,'2022-06-29 11:28:27','',''),(950,'5','271','3',1,'Sale Id shift 60',0.00,0.00,0.00,11267.11,0.00,'2022-06-29 11:28:27','',''),(951,'5','271','1',1,'Sale Id shift 60',0.00,0.00,0.00,10530.44,0.00,'2022-06-29 11:28:27','',''),(952,'5','271','2',1,'Sale Id shift 60',0.00,0.00,0.00,794.21,0.00,'2022-06-29 11:28:27','',''),(953,'5','271',NULL,1,'Sale Id shift 60',5047401.15,0.00,0.00,0.00,0.00,'2022-06-29 11:28:27','',''),(954,'5','271','2',1,'Sale Id shift 61',0.00,0.00,0.00,6466.50,0.00,'2022-06-29 11:33:13','',''),(955,'5','271','3',1,'Sale Id shift 61',0.00,0.00,0.00,8622.19,0.00,'2022-06-29 11:33:13','',''),(956,'5','271','3',1,'Sale Id shift 61',0.00,0.00,0.00,2399.12,0.00,'2022-06-29 11:33:13','',''),(957,'5','271',NULL,1,'Sale Id shift 61',2885488.65,0.00,0.00,0.00,0.00,'2022-06-29 11:33:13','',''),(958,'5','271','3',1,'Sale Id shift 62',0.00,0.00,0.00,648.82,0.00,'2022-06-29 11:39:41','',''),(959,'5','271','3',1,'Sale Id shift 62',0.00,0.00,0.00,2539.34,0.00,'2022-06-29 11:39:41','',''),(960,'5','271','1',1,'Sale Id shift 62',0.00,0.00,0.00,4139.42,0.00,'2022-06-29 11:39:41','',''),(961,'5','271','1',1,'Sale Id shift 62',0.00,0.00,0.00,5184.75,0.00,'2022-06-29 11:39:41','',''),(962,'5','271',NULL,1,'Sale Id shift 62',2064534.45,0.00,0.00,0.00,0.00,'2022-06-29 11:39:41','',''),(963,'5','271','3',1,'Sale Id shift 63',0.00,0.00,0.00,5156.39,0.00,'2022-06-29 11:51:28','',''),(964,'5','271','3',1,'Sale Id shift 63',0.00,0.00,0.00,2247.00,0.00,'2022-06-29 11:51:28','',''),(965,'5','271','2',1,'Sale Id shift 63',0.00,0.00,0.00,5298.49,0.00,'2022-06-29 11:51:28','',''),(966,'5','271','2',1,'Sale Id shift 63',0.00,0.00,0.00,11035.24,0.00,'2022-06-29 11:51:28','',''),(967,'5','271',NULL,1,'Sale Id shift 63',3916624.80,0.00,0.00,0.00,0.00,'2022-06-29 11:51:28','',''),(968,'5','271',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,8000.00,0.00,'2022-06-29 12:27:08','',''),(969,'5','271','2',1,'Received from bridging 138',0.00,0.00,8000.00,0.00,0.00,'2022-06-29 12:27:08','',''),(970,'5','271',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,4500.00,0.00,'2022-06-29 12:27:17','',''),(971,'5','271','1',1,'Received from bridging 139',0.00,0.00,4500.00,0.00,0.00,'2022-06-29 12:27:17','',''),(972,'5','271',NULL,1,'Reception corrector for bridging 140',0.00,0.00,0.00,45000.00,0.00,'2022-06-29 12:27:25','',''),(973,'5','271','3',1,'Received from bridging 140',0.00,0.00,45000.00,0.00,0.00,'2022-06-29 12:27:25','',''),(974,'5','271',NULL,1,'Reception corrector for bridging 141',0.00,0.00,0.00,1000.00,0.00,'2022-06-29 12:27:33','',''),(975,'5','271','4',1,'Received from bridging 141',0.00,0.00,1000.00,0.00,0.00,'2022-06-29 12:27:33','',''),(976,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-29 12:29:29','',''),(977,'5','271',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,35000.00,0.00,'2022-06-29 12:37:31','',''),(978,'5','271','1',1,'Received from bridging 142',0.00,0.00,35000.00,0.00,0.00,'2022-06-29 12:37:31','',''),(979,'5','271',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,28000.00,0.00,'2022-06-29 12:37:42','',''),(980,'5','271','2',1,'Received from bridging 143',0.00,0.00,28000.00,0.00,0.00,'2022-06-29 12:37:42','',''),(981,'5','271','3',1,'Sale Id shift 64',0.00,0.00,0.00,5989.81,0.00,'2022-06-29 16:56:14','',''),(982,'5','271','3',1,'Sale Id shift 64',0.00,0.00,0.00,1703.14,0.00,'2022-06-29 16:56:14','',''),(983,'5','271','1',1,'Sale Id shift 64',0.00,0.00,0.00,935.32,0.00,'2022-06-29 16:56:14','',''),(984,'5','271','1',1,'Sale Id shift 64',0.00,0.00,0.00,7086.46,0.00,'2022-06-29 16:56:14','',''),(985,'5','271','2',1,'Sale Id shift 64',0.00,0.00,0.00,12731.42,0.00,'2022-06-29 16:56:14','',''),(986,'5','271',NULL,1,'Sale Id shift 64',4693614.75,0.00,0.00,0.00,0.00,'2022-06-29 16:56:14','',''),(987,'5','271','4',1,'Sale Id shift 65',0.00,0.00,0.00,10250.66,0.00,'2022-06-29 17:08:54','',''),(988,'5','271','4',1,'Sale Id shift 65',0.00,0.00,0.00,996.05,0.00,'2022-06-29 17:08:54','',''),(989,'5','271','1',1,'Sale Id shift 65',0.00,0.00,0.00,6049.34,0.00,'2022-06-29 17:08:54','',''),(990,'5','271','1',1,'Sale Id shift 65',0.00,0.00,0.00,7615.60,0.00,'2022-06-29 17:08:54','',''),(991,'5','271','1',1,'Sale Id shift 65',0.00,0.00,0.00,6552.81,0.00,'2022-06-29 17:08:54','',''),(992,'5','271','2',1,'Sale Id shift 65',0.00,0.00,0.00,258.73,0.00,'2022-06-29 17:08:54','',''),(993,'5','271','2',1,'Sale Id shift 65',0.00,0.00,0.00,567.03,0.00,'2022-06-29 17:08:54','',''),(994,'5','271',NULL,1,'Sale Id shift 65',5327886.30,0.00,0.00,0.00,0.00,'2022-06-29 17:08:54','',''),(995,'5','271','3',1,'Sale Id shift 66',0.00,0.00,0.00,22.48,0.00,'2022-06-29 17:21:10','',''),(996,'5','271','4',1,'Sale Id shift 66',0.00,0.00,0.00,4239.66,0.00,'2022-06-29 17:21:10','',''),(997,'5','271','1',1,'Sale Id shift 66',0.00,0.00,0.00,3508.12,0.00,'2022-06-29 17:21:10','',''),(998,'5','271','1',1,'Sale Id shift 66',0.00,0.00,0.00,1270.87,0.00,'2022-06-29 17:21:10','',''),(999,'5','271','2',1,'Sale Id shift 66',0.00,0.00,0.00,7011.57,0.00,'2022-06-29 17:21:10','',''),(1000,'5','271','2',1,'Sale Id shift 66',0.00,0.00,0.00,9321.72,0.00,'2022-06-29 17:21:10','',''),(1001,'5','271',NULL,1,'Sale Id shift 66',4186779.30,0.00,0.00,0.00,0.00,'2022-06-29 17:21:10','',''),(1002,'5','271',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,30000.00,0.00,'2022-06-30 11:11:51','',''),(1003,'5','271','2',1,'Received from bridging 144',0.00,0.00,30000.00,0.00,0.00,'2022-06-30 11:11:51','',''),(1004,'5','271',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,5000.00,0.00,'2022-06-30 11:11:59','',''),(1005,'5','271','1',1,'Received from bridging 145',0.00,0.00,5000.00,0.00,0.00,'2022-06-30 11:11:59','',''),(1006,'5','271','3',1,'Sale Id shift 67',0.00,0.00,0.00,2171.09,0.00,'2022-06-30 11:27:35','',''),(1007,'5','271','3',1,'Sale Id shift 67',0.00,0.00,0.00,1165.54,0.00,'2022-06-30 11:27:35','',''),(1008,'5','271','4',1,'Sale Id shift 67',0.00,0.00,0.00,3698.09,0.00,'2022-06-30 11:27:35','',''),(1009,'5','271','1',1,'Sale Id shift 67',0.00,0.00,0.00,6736.45,0.00,'2022-06-30 11:27:35','',''),(1010,'5','271','2',1,'Sale Id shift 67',0.00,0.00,0.00,5726.52,0.00,'2022-06-30 11:27:35','',''),(1011,'5','271','2',1,'Sale Id shift 67',0.00,0.00,0.00,8746.75,0.00,'2022-06-30 11:27:35','',''),(1012,'5','271',NULL,1,'Sale Id shift 67',4660332.60,0.00,0.00,0.00,0.00,'2022-06-30 11:27:35','',''),(1013,'5','271','3',1,'Sale Id shift 68',0.00,0.00,0.00,7094.86,0.00,'2022-06-30 11:51:21','',''),(1014,'5','271','3',1,'Sale Id shift 68',0.00,0.00,0.00,11809.20,0.00,'2022-06-30 11:51:21','',''),(1015,'5','271','4',1,'Sale Id shift 68',0.00,0.00,0.00,2738.70,0.00,'2022-06-30 11:51:21','',''),(1016,'5','271',NULL,1,'Sale Id shift 68',3571055.40,0.00,0.00,0.00,0.00,'2022-06-30 11:51:21','',''),(1017,'5','271','3',1,'Sale Id shift 69',0.00,0.00,0.00,6156.10,0.00,'2022-06-30 12:00:40','',''),(1018,'5','271','3',1,'Sale Id shift 69',0.00,0.00,0.00,7602.88,0.00,'2022-06-30 12:00:40','',''),(1019,'5','271','4',1,'Sale Id shift 69',0.00,0.00,0.00,11825.30,0.00,'2022-06-30 12:00:40','',''),(1020,'5','271','4',1,'Sale Id shift 69',0.00,0.00,0.00,860.91,0.00,'2022-06-30 12:00:40','',''),(1021,'5','271',NULL,1,'Sale Id shift 69',4363456.35,0.00,0.00,0.00,0.00,'2022-06-30 12:00:40','',''),(1022,'5','271',NULL,1,'Reception corrector for bridging 146',0.00,0.00,0.00,2000.00,0.00,'2022-06-30 12:22:35','',''),(1023,'5','271','1',1,'Received from bridging 146',0.00,0.00,2000.00,0.00,0.00,'2022-06-30 12:22:35','',''),(1024,'5','271',NULL,1,'Reception corrector for bridging 147',0.00,0.00,0.00,44840.00,0.00,'2022-06-30 12:22:44','',''),(1025,'5','271','3',1,'Received from bridging 147',0.00,0.00,44840.00,0.00,0.00,'2022-06-30 12:22:44','',''),(1026,'5','271',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,43000.00,0.00,'2022-06-30 12:22:53','',''),(1027,'5','271','4',1,'Received from bridging 148',0.00,0.00,43000.00,0.00,0.00,'2022-06-30 12:22:53','',''),(1028,'5','271',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,9610.00,0.00,'2022-06-30 12:23:00','',''),(1029,'5','271','2',1,'Received from bridging 149',0.00,0.00,9610.00,0.00,0.00,'2022-06-30 12:23:00','',''),(1030,'5','271','3',1,'Sale Id shift 70',0.00,0.00,0.00,5489.61,0.00,'2022-06-30 12:27:14','',''),(1031,'5','271','3',1,'Sale Id shift 70',0.00,0.00,0.00,3506.41,0.00,'2022-06-30 12:27:14','',''),(1032,'5','271','4',1,'Sale Id shift 70',0.00,0.00,0.00,5841.98,0.00,'2022-06-30 12:27:14','',''),(1033,'5','271',NULL,1,'Sale Id shift 70',2448270.00,0.00,0.00,0.00,0.00,'2022-06-30 12:27:14','',''),(1034,'5','271','5',2,'Sale Id shift 72',0.00,0.00,0.00,162.50,0.00,'2022-06-30 12:45:45','',''),(1035,'5','271','5',2,'Sale Id shift 72',0.00,0.00,0.00,687.89,0.00,'2022-06-30 12:45:45','',''),(1036,'5','271',NULL,2,'Sale Id shift 72',680312.00,0.00,0.00,0.00,0.00,'2022-06-30 12:45:45','',''),(1037,'5','271','2',1,'Sale Id shift 73',0.00,0.00,0.00,659.01,0.00,'2022-06-30 12:54:53','',''),(1038,'5','271','3',1,'Sale Id shift 73',0.00,0.00,0.00,7195.08,0.00,'2022-06-30 12:54:53','',''),(1039,'5','271','3',1,'Sale Id shift 73',0.00,0.00,0.00,13269.72,0.00,'2022-06-30 12:54:53','',''),(1040,'5','271','4',1,'Sale Id shift 73',0.00,0.00,0.00,284.86,0.00,'2022-06-30 12:54:53','',''),(1041,'5','271','5',2,'Sale Id shift 73',0.00,0.00,0.00,353.50,0.00,'2022-06-30 12:54:53','',''),(1042,'5','271','5',2,'Sale Id shift 73',0.00,0.00,0.00,79.62,0.00,'2022-06-30 12:54:53','',''),(1043,'5','271','1',1,'Sale Id shift 73',0.00,0.00,0.00,259.47,0.00,'2022-06-30 12:54:53','',''),(1044,'5','271',NULL,2,'Sale Id shift 73',346496.00,0.00,0.00,0.00,0.00,'2022-06-30 12:54:53','',''),(1045,'5','271',NULL,1,'Sale Id shift 73',3575243.10,0.00,0.00,0.00,0.00,'2022-06-30 12:54:53','',''),(1046,'5','271',NULL,1,'Reception corrector for bridging 150',0.00,0.00,0.00,1536.00,0.00,'2022-06-30 13:14:18','',''),(1047,'5','271','4',1,'Received from bridging 150',0.00,0.00,1536.00,0.00,0.00,'2022-06-30 13:14:18','',''),(1048,'5','271',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,29000.00,0.00,'2022-06-30 13:14:28','',''),(1049,'5','271','3',1,'Received from bridging 152',0.00,0.00,29000.00,0.00,0.00,'2022-06-30 13:14:28','',''),(1050,'5','271','2',1,'Sale Id shift 74',0.00,0.00,0.00,3124.25,0.00,'2022-06-30 14:17:14','',''),(1051,'5','271','3',1,'Sale Id shift 74',0.00,0.00,0.00,7673.36,0.00,'2022-06-30 14:17:14','',''),(1052,'5','271','3',1,'Sale Id shift 74',0.00,0.00,0.00,14230.51,0.00,'2022-06-30 14:17:14','',''),(1053,'5','271','5',2,'Sale Id shift 74',0.00,0.00,0.00,748.73,0.00,'2022-06-30 14:17:14','',''),(1054,'5','271',NULL,2,'Sale Id shift 74',598984.00,0.00,0.00,0.00,0.00,'2022-06-30 14:17:14','',''),(1055,'5','271',NULL,1,'Sale Id shift 74',4129639.80,0.00,0.00,0.00,0.00,'2022-06-30 14:17:14','',''),(1056,'5','271','2',1,'Sale Id shift 75',0.00,0.00,0.00,3957.55,0.00,'2022-06-30 15:09:47','',''),(1057,'5','271','5',2,'Sale Id shift 75',0.00,0.00,0.00,673.03,0.00,'2022-06-30 15:09:47','',''),(1058,'5','271','1',1,'Sale Id shift 75',0.00,0.00,0.00,9734.28,0.00,'2022-06-30 15:09:47','',''),(1059,'5','271','2',1,'Sale Id shift 75',0.00,0.00,0.00,6056.39,0.00,'2022-06-30 15:09:47','',''),(1060,'5','271','2',1,'Sale Id shift 75',0.00,0.00,0.00,14052.40,0.00,'2022-06-30 15:09:47','',''),(1061,'5','271',NULL,2,'Sale Id shift 75',538424.00,0.00,0.00,0.00,0.00,'2022-06-30 15:09:47','',''),(1062,'5','271',NULL,1,'Sale Id shift 75',5577102.30,0.00,0.00,0.00,0.00,'2022-06-30 15:09:47','',''),(1063,'5','271',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,16000.00,0.00,'2022-06-30 18:45:12','',''),(1064,'5','271','3',1,'Received from bridging 153',0.00,0.00,16000.00,0.00,0.00,'2022-06-30 18:45:12','',''),(1065,'5','271',NULL,1,'Reception corrector for bridging 154',0.00,0.00,0.00,20000.00,0.00,'2022-06-30 18:45:27','',''),(1066,'5','271','1',1,'Received from bridging 154',0.00,0.00,20000.00,0.00,0.00,'2022-06-30 18:45:27','',''),(1067,'5','271',NULL,1,'Reception corrector for bridging 155',0.00,0.00,0.00,14300.00,0.00,'2022-06-30 18:45:43','',''),(1068,'5','271','2',1,'Received from bridging 155',0.00,0.00,14300.00,0.00,0.00,'2022-06-30 18:45:43','',''),(1069,'5','271',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,5000.00,0.00,'2022-06-30 18:45:58','',''),(1070,'5','271','4',1,'Received from bridging 156',0.00,0.00,5000.00,0.00,0.00,'2022-06-30 18:45:58','',''),(1071,'5','271','2',1,'Sale Id shift 76',0.00,0.00,0.00,778.12,0.00,'2022-07-05 12:23:43','',''),(1072,'5','271','3',1,'Sale Id shift 76',0.00,0.00,0.00,604.22,0.00,'2022-07-05 12:23:43','',''),(1073,'5','271','3',1,'Sale Id shift 76',0.00,0.00,0.00,2208.94,0.00,'2022-07-05 12:23:43','',''),(1074,'5','271','4',1,'Sale Id shift 76',0.00,0.00,0.00,695.44,0.00,'2022-07-05 12:23:43','',''),(1075,'5','271','5',2,'Sale Id shift 76',0.00,0.00,0.00,3369.02,0.00,'2022-07-05 12:23:43','',''),(1076,'5','271','1',1,'Sale Id shift 76',0.00,0.00,0.00,7764.13,0.00,'2022-07-05 12:23:43','',''),(1077,'5','271','2',1,'Sale Id shift 76',0.00,0.00,0.00,3232.80,0.00,'2022-07-05 12:23:43','',''),(1078,'5','271','2',1,'Sale Id shift 76',0.00,0.00,0.00,8112.61,0.00,'2022-07-05 12:23:43','',''),(1079,'5','271',NULL,2,'Sale Id shift 76',2695216.00,0.00,0.00,0.00,0.00,'2022-07-05 12:23:43','',''),(1080,'5','271',NULL,1,'Sale Id shift 76',3860382.90,0.00,0.00,0.00,0.00,'2022-07-05 12:23:43','',''),(1081,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-05 12:23:56','',''),(1082,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6575250.00,39850.00,0.00,0.00,'2022-07-05 12:24:03','',''),(1083,'5','271','4',1,'Sale Id shift 77',0.00,0.00,0.00,5745.57,0.00,'2022-07-05 14:42:00','',''),(1084,'5','271','5',2,'Sale Id shift 77',0.00,0.00,0.00,884.89,0.00,'2022-07-05 14:42:00','',''),(1085,'5','271','1',1,'Sale Id shift 77',0.00,0.00,0.00,3161.96,0.00,'2022-07-05 14:42:00','',''),(1086,'5','271','1',1,'Sale Id shift 77',0.00,0.00,0.00,448.76,0.00,'2022-07-05 14:42:00','',''),(1087,'5','271',NULL,2,'Sale Id shift 77',707912.00,0.00,0.00,0.00,0.00,'2022-07-05 14:42:00','',''),(1088,'5','271',NULL,1,'Sale Id shift 77',1543787.85,0.00,0.00,0.00,0.00,'2022-07-05 14:42:00','',''),(1089,'5','271',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,31000.00,0.00,'2022-07-05 14:42:09','',''),(1090,'5','271','2',1,'Received from bridging 157',0.00,0.00,31000.00,0.00,0.00,'2022-07-05 14:42:09','',''),(1091,'5','271','4',1,'Sale Id shift 78',0.00,0.00,0.00,10432.04,0.00,'2022-07-06 13:50:48','',''),(1092,'5','271','4',1,'Sale Id shift 78',0.00,0.00,0.00,1923.06,0.00,'2022-07-06 13:50:48','',''),(1093,'5','271','5',2,'Sale Id shift 78',0.00,0.00,0.00,2491.68,0.00,'2022-07-06 13:50:48','',''),(1094,'5','271','5',2,'Sale Id shift 78',0.00,0.00,0.00,590.00,0.00,'2022-07-06 13:50:48','',''),(1095,'5','271','1',1,'Sale Id shift 78',0.00,0.00,0.00,7868.60,0.00,'2022-07-06 13:50:48','',''),(1096,'5','271','1',1,'Sale Id shift 78',0.00,0.00,0.00,5714.71,0.00,'2022-07-06 13:50:48','',''),(1097,'5','271',NULL,2,'Sale Id shift 78',2465344.00,0.00,0.00,0.00,0.00,'2022-07-06 13:50:48','',''),(1098,'5','271',NULL,1,'Sale Id shift 78',4279837.65,0.00,0.00,0.00,0.00,'2022-07-06 13:50:48','',''),(1099,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-07-06 14:23:23','',''),(1100,'5','271',NULL,1,'Reception corrector for bridging 158',0.00,0.00,0.00,19850.00,0.00,'2022-07-06 14:23:30','',''),(1101,'5','271','1',1,'Received from bridging 158',0.00,0.00,19850.00,0.00,0.00,'2022-07-06 14:23:30','',''),(1102,'5','271','2',1,'Sale Id shift 79',0.00,0.00,0.00,10726.21,0.00,'2022-07-07 10:20:00','',''),(1103,'5','271','3',1,'Sale Id shift 79',0.00,0.00,0.00,569.69,0.00,'2022-07-07 10:20:00','',''),(1104,'5','271','5',2,'Sale Id shift 79',0.00,0.00,0.00,1271.50,0.00,'2022-07-07 10:20:00','',''),(1105,'5','271','5',2,'Sale Id shift 79',0.00,0.00,0.00,1394.49,0.00,'2022-07-07 10:20:00','',''),(1106,'5','271','1',1,'Sale Id shift 79',0.00,0.00,0.00,5041.68,0.00,'2022-07-07 10:20:00','',''),(1107,'5','271','2',1,'Sale Id shift 79',0.00,0.00,0.00,7333.26,0.00,'2022-07-07 10:20:00','',''),(1108,'5','271','2',1,'Sale Id shift 79',0.00,0.00,0.00,9196.84,0.00,'2022-07-07 10:20:00','',''),(1109,'5','271',NULL,2,'Sale Id shift 79',2132792.00,0.00,0.00,0.00,0.00,'2022-07-07 10:20:00','',''),(1110,'5','271',NULL,1,'Sale Id shift 79',5423167.20,0.00,0.00,0.00,0.00,'2022-07-07 10:20:00','',''),(1111,'5','271','2',1,'Sale Id shift 80',0.00,0.00,0.00,9461.15,0.00,'2022-07-07 10:48:22','',''),(1112,'5','271','3',1,'Sale Id shift 80',0.00,0.00,0.00,5288.25,0.00,'2022-07-07 10:48:22','',''),(1113,'5','271','3',1,'Sale Id shift 80',0.00,0.00,0.00,2250.16,0.00,'2022-07-07 10:48:22','',''),(1114,'5','271','5',2,'Sale Id shift 80',0.00,0.00,0.00,1570.51,0.00,'2022-07-07 10:48:22','',''),(1115,'5','271','2',1,'Sale Id shift 80',0.00,0.00,0.00,7888.22,0.00,'2022-07-07 10:48:22','',''),(1116,'5','271',NULL,2,'Sale Id shift 80',1256408.00,0.00,0.00,0.00,0.00,'2022-07-07 10:48:22','',''),(1117,'5','271',NULL,1,'Sale Id shift 80',4106483.70,0.00,0.00,0.00,0.00,'2022-07-07 10:48:22','',''),(1118,'5','271','3',1,'Sale Id shift 81',0.00,0.00,0.00,3287.47,0.00,'2022-07-07 10:58:12','',''),(1119,'5','271','3',1,'Sale Id shift 81',0.00,0.00,0.00,4101.19,0.00,'2022-07-07 10:58:12','',''),(1120,'5','271','4',1,'Sale Id shift 81',0.00,0.00,0.00,6183.86,0.00,'2022-07-07 10:58:12','',''),(1121,'5','271','4',1,'Sale Id shift 81',0.00,0.00,0.00,1768.69,0.00,'2022-07-07 10:58:12','',''),(1122,'5','271','5',2,'Sale Id shift 81',0.00,0.00,0.00,414.72,0.00,'2022-07-07 10:58:12','',''),(1123,'5','271',NULL,2,'Sale Id shift 81',340070.40,0.00,0.00,0.00,0.00,'2022-07-07 10:58:12','',''),(1124,'5','271',NULL,1,'Sale Id shift 81',2531299.65,0.00,0.00,0.00,0.00,'2022-07-07 10:58:12','',''),(1125,'5','271','3',1,'Sale Id shift 82',0.00,0.00,0.00,4521.35,0.00,'2022-07-07 11:20:36','',''),(1126,'5','271','3',1,'Sale Id shift 82',0.00,0.00,0.00,3107.26,0.00,'2022-07-07 11:20:36','',''),(1127,'5','271','4',1,'Sale Id shift 82',0.00,0.00,0.00,6004.02,0.00,'2022-07-07 11:20:36','',''),(1128,'5','271','4',1,'Sale Id shift 82',0.00,0.00,0.00,6519.85,0.00,'2022-07-07 11:20:36','',''),(1129,'5','271','5',2,'Sale Id shift 82',0.00,0.00,0.00,515.87,0.00,'2022-07-07 11:20:36','',''),(1130,'5','271',NULL,2,'Sale Id shift 82',423013.40,0.00,0.00,0.00,0.00,'2022-07-07 11:20:36','',''),(1131,'5','271',NULL,1,'Sale Id shift 82',3325159.20,0.00,0.00,0.00,0.00,'2022-07-07 11:20:36','',''),(1132,'5','271','3',1,'Sale Id shift 83',0.00,0.00,0.00,6568.67,0.00,'2022-07-07 11:45:44','',''),(1133,'5','271','3',1,'Sale Id shift 83',0.00,0.00,0.00,10373.43,0.00,'2022-07-07 11:45:44','',''),(1134,'5','271','4',1,'Sale Id shift 83',0.00,0.00,0.00,309.76,0.00,'2022-07-07 11:45:44','',''),(1135,'5','271','5',2,'Sale Id shift 83',0.00,0.00,0.00,815.24,0.00,'2022-07-07 11:45:44','',''),(1136,'5','271',NULL,2,'Sale Id shift 83',668496.80,0.00,0.00,0.00,0.00,'2022-07-07 11:45:44','',''),(1137,'5','271',NULL,1,'Sale Id shift 83',2846556.90,0.00,0.00,0.00,0.00,'2022-07-07 11:45:44','',''),(1138,'5','271',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,14000.00,0.00,'2022-07-07 11:59:28','',''),(1139,'5','271','2',1,'Received from bridging 159',0.00,0.00,14000.00,0.00,0.00,'2022-07-07 11:59:28','',''),(1140,'5','271',NULL,1,'Reception corrector for bridging 160',0.00,0.00,0.00,40000.00,0.00,'2022-07-07 12:00:28','',''),(1141,'5','271','3',1,'Received from bridging 160',0.00,0.00,40000.00,0.00,0.00,'2022-07-07 12:00:28','',''),(1142,'5','271','3',1,'Sale Id shift 84',0.00,0.00,0.00,1930.64,0.00,'2022-07-07 12:03:55','',''),(1143,'5','271','3',1,'Sale Id shift 84',0.00,0.00,0.00,2845.43,0.00,'2022-07-07 12:03:55','',''),(1144,'5','271','5',2,'Sale Id shift 84',0.00,0.00,0.00,97.55,0.00,'2022-07-07 12:03:55','',''),(1145,'5','271','5',2,'Sale Id shift 84',0.00,0.00,0.00,1659.59,0.00,'2022-07-07 12:03:55','',''),(1146,'5','271',NULL,2,'Sale Id shift 84',1440854.80,0.00,0.00,0.00,0.00,'2022-07-07 12:03:55','',''),(1147,'5','271',NULL,1,'Sale Id shift 84',788051.55,0.00,0.00,0.00,0.00,'2022-07-07 12:03:55','',''),(1148,'5','271','5',2,'Sale Id shift 85',0.00,0.00,0.00,1147.09,0.00,'2022-07-07 12:10:24','',''),(1149,'5','271',NULL,2,'Sale Id shift 85',940613.80,0.00,0.00,0.00,0.00,'2022-07-07 12:10:24','',''),(1150,'5','271','5',2,'Sale Id shift 86',0.00,0.00,0.00,150.00,0.00,'2022-07-07 12:15:34','',''),(1151,'5','271','5',2,'Sale Id shift 86',0.00,0.00,0.00,1229.24,0.00,'2022-07-07 12:15:34','',''),(1152,'5','271',NULL,2,'Sale Id shift 86',1130976.80,0.00,0.00,0.00,0.00,'2022-07-07 12:15:34','',''),(1153,'5','271','5',2,'Sale Id shift 87',0.00,0.00,0.00,246.76,0.00,'2022-07-07 12:19:01','',''),(1154,'5','271',NULL,2,'Sale Id shift 87',202343.20,0.00,0.00,0.00,0.00,'2022-07-07 12:19:01','',''),(1155,'5','271','5',2,'Sale Id shift 88',0.00,0.00,0.00,350.80,0.00,'2022-07-07 12:23:11','',''),(1156,'5','271',NULL,2,'Sale Id shift 88',287656.00,0.00,0.00,0.00,0.00,'2022-07-07 12:23:11','',''),(1157,'5','271',NULL,1,'Reception corrector for bridging 162',0.00,0.00,0.00,20000.00,0.00,'2022-07-07 17:55:22','',''),(1158,'5','271','2',1,'Received from bridging 162',0.00,0.00,20000.00,0.00,0.00,'2022-07-07 17:55:22','',''),(1159,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7331550.00,39630.00,0.00,0.00,'2022-07-12 14:26:44','',''),(1160,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-07-13 13:14:55','',''),(1161,'5','271',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,10000.00,0.00,'2022-07-13 13:38:56','',''),(1162,'5','271','2',1,'Received from bridging 164',0.00,0.00,10000.00,0.00,0.00,'2022-07-13 13:38:56','',''),(1163,'5','271',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,14000.00,0.00,'2022-07-13 13:39:04','',''),(1164,'5','271','3',1,'Received from bridging 163',0.00,0.00,14000.00,0.00,0.00,'2022-07-13 13:39:04','',''),(1165,'5','271','2',1,'Sale Id shift 89',0.00,0.00,0.00,6799.99,0.00,'2022-07-14 12:36:23','',''),(1166,'5','271','5',2,'Sale Id shift 89',0.00,0.00,0.00,531.98,0.00,'2022-07-14 12:36:23','',''),(1167,'5','271','2',1,'Sale Id shift 89',0.00,0.00,0.00,5600.40,0.00,'2022-07-14 12:36:23','',''),(1168,'5','271','2',1,'Sale Id shift 89',0.00,0.00,0.00,9577.58,0.00,'2022-07-14 12:36:23','',''),(1169,'5','271',NULL,2,'Sale Id shift 89',436223.60,0.00,0.00,0.00,0.00,'2022-07-14 12:36:23','',''),(1170,'5','271',NULL,1,'Sale Id shift 89',3626365.05,0.00,0.00,0.00,0.00,'2022-07-14 12:36:23','',''),(1171,'5','271','2',1,'Sale Id shift 90',0.00,0.00,0.00,6819.11,0.00,'2022-07-14 13:06:20','',''),(1172,'5','271','5',2,'Sale Id shift 90',0.00,0.00,0.00,641.91,0.00,'2022-07-14 13:06:20','',''),(1173,'5','271','1',1,'Sale Id shift 90',0.00,0.00,0.00,21.48,0.00,'2022-07-14 13:06:20','',''),(1174,'5','271','2',1,'Sale Id shift 90',0.00,0.00,0.00,4290.13,0.00,'2022-07-14 13:06:20','',''),(1175,'5','271','2',1,'Sale Id shift 90',0.00,0.00,0.00,6276.15,0.00,'2022-07-14 13:06:20','',''),(1176,'5','271',NULL,2,'Sale Id shift 90',526366.20,0.00,0.00,0.00,0.00,'2022-07-14 13:06:20','',''),(1177,'5','271',NULL,1,'Sale Id shift 90',3220270.95,0.00,0.00,0.00,0.00,'2022-07-14 13:06:20','',''),(1178,'5','271','2',1,'Sale Id shift 91',0.00,0.00,0.00,4139.51,0.00,'2022-07-14 13:11:25','',''),(1179,'5','271','3',1,'Sale Id shift 91',0.00,0.00,0.00,5664.87,0.00,'2022-07-14 13:11:25','',''),(1180,'5','271','3',1,'Sale Id shift 91',0.00,0.00,0.00,8268.35,0.00,'2022-07-14 13:11:25','',''),(1181,'5','271','5',2,'Sale Id shift 91',0.00,0.00,0.00,426.30,0.00,'2022-07-14 13:11:25','',''),(1182,'5','271','2',1,'Sale Id shift 91',0.00,0.00,0.00,1350.82,0.00,'2022-07-14 13:11:25','',''),(1183,'5','271',NULL,2,'Sale Id shift 91',349566.00,0.00,0.00,0.00,0.00,'2022-07-14 13:11:25','',''),(1184,'5','271',NULL,1,'Sale Id shift 91',3593356.75,0.00,0.00,0.00,0.00,'2022-07-14 13:11:25','',''),(1185,'5','271',NULL,1,'Reception corrector for bridging 166',0.00,0.00,0.00,30000.00,0.00,'2022-07-14 14:31:37','',''),(1186,'5','271','2',1,'Received from bridging 166',0.00,0.00,30000.00,0.00,0.00,'2022-07-14 14:31:37','',''),(1187,'5','271','2',1,'Sale Id shift 92',0.00,0.00,0.00,2279.48,0.00,'2022-07-14 14:55:31','',''),(1188,'5','271','3',1,'Sale Id shift 92',0.00,0.00,0.00,4410.44,0.00,'2022-07-14 14:55:31','',''),(1189,'5','271','3',1,'Sale Id shift 92',0.00,0.00,0.00,6153.84,0.00,'2022-07-14 14:55:31','',''),(1190,'5','271','5',2,'Sale Id shift 92',0.00,0.00,0.00,559.91,0.00,'2022-07-14 14:55:31','',''),(1191,'5','271','2',1,'Sale Id shift 92',0.00,0.00,0.00,5990.19,0.00,'2022-07-14 14:55:31','',''),(1192,'5','271',NULL,2,'Sale Id shift 92',459126.20,0.00,0.00,0.00,0.00,'2022-07-14 14:55:31','',''),(1193,'5','271',NULL,1,'Sale Id shift 92',3484280.75,0.00,0.00,0.00,0.00,'2022-07-14 14:55:31','',''),(1194,'5','271','2',1,'Sale Id shift 93',0.00,0.00,0.00,6346.24,0.00,'2022-07-14 15:02:49','',''),(1195,'5','271','3',1,'Sale Id shift 93',0.00,0.00,0.00,147.47,0.00,'2022-07-14 15:02:49','',''),(1196,'5','271','3',1,'Sale Id shift 93',0.00,0.00,0.00,477.64,0.00,'2022-07-14 15:02:49','',''),(1197,'5','271','5',2,'Sale Id shift 93',0.00,0.00,0.00,709.87,0.00,'2022-07-14 15:02:49','',''),(1198,'5','271','2',1,'Sale Id shift 93',0.00,0.00,0.00,4809.72,0.00,'2022-07-14 15:02:49','',''),(1199,'5','271','2',1,'Sale Id shift 93',0.00,0.00,0.00,6864.23,0.00,'2022-07-14 15:02:49','',''),(1200,'5','271',NULL,2,'Sale Id shift 93',582093.40,0.00,0.00,0.00,0.00,'2022-07-14 15:02:49','',''),(1201,'5','271',NULL,1,'Sale Id shift 93',3449380.50,0.00,0.00,0.00,0.00,'2022-07-14 15:02:49','',''),(1202,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-14 15:13:22','',''),(1203,'5','271',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,25630.00,0.00,'2022-07-14 15:23:06','',''),(1204,'5','271','2',1,'Received from bridging 167',0.00,0.00,25630.00,0.00,0.00,'2022-07-14 15:23:06','',''),(1205,'5','271','2',1,'Sale Id shift 94',0.00,0.00,0.00,6288.70,0.00,'2022-07-14 15:25:06','',''),(1206,'5','271','3',1,'Sale Id shift 94',0.00,0.00,0.00,4879.99,0.00,'2022-07-14 15:25:06','',''),(1207,'5','271','3',1,'Sale Id shift 94',0.00,0.00,0.00,7026.67,0.00,'2022-07-14 15:25:06','',''),(1208,'5','271','5',2,'Sale Id shift 94',0.00,0.00,0.00,1033.97,0.00,'2022-07-14 15:25:06','',''),(1209,'5','271','2',1,'Sale Id shift 94',0.00,0.00,0.00,647.57,0.00,'2022-07-14 15:25:06','',''),(1210,'5','271','2',1,'Sale Id shift 94',0.00,0.00,0.00,3745.22,0.00,'2022-07-14 15:25:06','',''),(1211,'5','271',NULL,2,'Sale Id shift 94',847855.40,0.00,0.00,0.00,0.00,'2022-07-14 15:25:06','',''),(1212,'5','271',NULL,1,'Sale Id shift 94',4178807.75,0.00,0.00,0.00,0.00,'2022-07-14 15:25:06','',''),(1213,'5','271','2',1,'Sale Id shift 95',0.00,0.00,0.00,18.37,0.00,'2022-07-14 15:34:21','',''),(1214,'5','271','3',1,'Sale Id shift 95',0.00,0.00,0.00,1340.81,0.00,'2022-07-14 15:34:21','',''),(1215,'5','271','5',2,'Sale Id shift 95',0.00,0.00,0.00,242.40,0.00,'2022-07-14 15:34:21','',''),(1216,'5','271','2',1,'Sale Id shift 95',0.00,0.00,0.00,1766.25,0.00,'2022-07-14 15:34:21','',''),(1217,'5','271','2',1,'Sale Id shift 95',0.00,0.00,0.00,597.91,0.00,'2022-07-14 15:34:21','',''),(1218,'5','271',NULL,2,'Sale Id shift 95',193920.00,0.00,0.00,0.00,0.00,'2022-07-14 15:34:21','',''),(1219,'5','271',NULL,1,'Sale Id shift 95',688817.90,0.00,0.00,0.00,0.00,'2022-07-14 15:34:21','',''),(1220,'5','271','3',1,'Sale Id shift 96',0.00,0.00,0.00,528.44,0.00,'2022-07-14 15:39:11','',''),(1221,'5','271','3',1,'Sale Id shift 96',0.00,0.00,0.00,413.16,0.00,'2022-07-14 15:39:11','',''),(1222,'5','271','5',2,'Sale Id shift 96',0.00,0.00,0.00,306.23,0.00,'2022-07-14 15:39:11','',''),(1223,'5','271','2',1,'Sale Id shift 96',0.00,0.00,0.00,387.81,0.00,'2022-07-14 15:39:11','',''),(1224,'5','271',NULL,2,'Sale Id shift 96',244984.00,0.00,0.00,0.00,0.00,'2022-07-14 15:39:11','',''),(1225,'5','271',NULL,1,'Sale Id shift 96',245940.85,0.00,0.00,0.00,0.00,'2022-07-14 15:39:11','',''),(1226,'5','271','3',1,'Sale Id shift 97',0.00,0.00,0.00,422.81,0.00,'2022-07-14 15:48:22','',''),(1227,'5','271','3',1,'Sale Id shift 97',0.00,0.00,0.00,74.47,0.00,'2022-07-14 15:48:22','',''),(1228,'5','271','5',2,'Sale Id shift 97',0.00,0.00,0.00,131.09,0.00,'2022-07-14 15:48:22','',''),(1229,'5','271','2',1,'Sale Id shift 97',0.00,0.00,0.00,249.83,0.00,'2022-07-14 15:48:22','',''),(1230,'5','271',NULL,2,'Sale Id shift 97',104872.00,0.00,0.00,0.00,0.00,'2022-07-14 15:48:22','',''),(1231,'5','271',NULL,1,'Sale Id shift 97',138215.35,0.00,0.00,0.00,0.00,'2022-07-14 15:48:22','',''),(1232,'5','271',NULL,1,'Reception corrector for bridging 168',0.00,0.00,0.00,18000.00,0.00,'2022-07-15 10:28:58','',''),(1233,'5','271','1',1,'Received from bridging 168',0.00,0.00,18000.00,0.00,0.00,'2022-07-15 10:28:58','',''),(1234,'5','271',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,32000.00,0.00,'2022-07-15 10:29:06','',''),(1235,'5','271','3',1,'Received from bridging 169',0.00,0.00,32000.00,0.00,0.00,'2022-07-15 10:29:06','',''),(1236,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-15 10:29:16','',''),(1237,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-15 10:29:29','',''),(1238,'5','271',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 10:39:28','',''),(1239,'5','271','2',1,'Received from bridging 171',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 10:39:28','',''),(1240,'5','271',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,35000.00,0.00,'2022-07-15 10:39:39','',''),(1241,'5','271','4',1,'Received from bridging 170',0.00,0.00,35000.00,0.00,0.00,'2022-07-15 10:39:39','',''),(1242,'5','271','3',1,'Sale Id shift 98',0.00,0.00,0.00,4441.43,0.00,'2022-07-15 10:50:40','',''),(1243,'5','271','3',1,'Sale Id shift 98',0.00,0.00,0.00,5908.01,0.00,'2022-07-15 10:50:40','',''),(1244,'5','271','5',2,'Sale Id shift 98',0.00,0.00,0.00,635.88,0.00,'2022-07-15 10:50:40','',''),(1245,'5','271',NULL,2,'Sale Id shift 98',508704.00,0.00,0.00,0.00,0.00,'2022-07-15 10:50:40','',''),(1246,'5','271',NULL,1,'Sale Id shift 98',1914646.40,0.00,0.00,0.00,0.00,'2022-07-15 10:50:40','',''),(1247,'5','271','2',1,'Sale Id shift 99',0.00,0.00,0.00,3306.12,0.00,'2022-07-15 10:56:26','',''),(1248,'5','271','3',1,'Sale Id shift 99',0.00,0.00,0.00,3798.83,0.00,'2022-07-15 10:56:26','',''),(1249,'5','271','3',1,'Sale Id shift 99',0.00,0.00,0.00,5793.67,0.00,'2022-07-15 10:56:26','',''),(1250,'5','271','5',2,'Sale Id shift 99',0.00,0.00,0.00,449.99,0.00,'2022-07-15 10:56:26','',''),(1251,'5','271','1',1,'Sale Id shift 99',0.00,0.00,0.00,1975.89,0.00,'2022-07-15 10:56:26','',''),(1252,'5','271','2',1,'Sale Id shift 99',0.00,0.00,0.00,2296.40,0.00,'2022-07-15 10:56:26','',''),(1253,'5','271','2',1,'Sale Id shift 99',0.00,0.00,0.00,3787.97,0.00,'2022-07-15 10:56:26','',''),(1254,'5','271',NULL,2,'Sale Id shift 99',359992.00,0.00,0.00,0.00,0.00,'2022-07-15 10:56:26','',''),(1255,'5','271',NULL,1,'Sale Id shift 99',3877392.80,0.00,0.00,0.00,0.00,'2022-07-15 10:56:26','',''),(1256,'5','271','2',1,'Sale Id shift 100',0.00,0.00,0.00,11902.10,0.00,'2022-07-15 11:28:39','',''),(1257,'5','271','3',1,'Sale Id shift 100',0.00,0.00,0.00,7836.65,0.00,'2022-07-15 11:28:39','',''),(1258,'5','271','5',2,'Sale Id shift 100',0.00,0.00,0.00,2752.00,0.00,'2022-07-15 11:28:39','',''),(1259,'5','271','2',1,'Sale Id shift 100',0.00,0.00,0.00,6478.93,0.00,'2022-07-15 11:28:39','',''),(1260,'5','271','2',1,'Sale Id shift 100',0.00,0.00,0.00,12338.92,0.00,'2022-07-15 11:28:39','',''),(1261,'5','271',NULL,2,'Sale Id shift 100',2201600.00,0.00,0.00,0.00,0.00,'2022-07-15 11:28:39','',''),(1262,'5','271',NULL,1,'Sale Id shift 100',7132971.00,0.00,0.00,0.00,0.00,'2022-07-15 11:28:39','',''),(1263,'5','271',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,15000.00,0.00,'2022-07-16 15:10:44','',''),(1264,'5','271','2',1,'Received from bridging 172',0.00,0.00,15000.00,0.00,0.00,'2022-07-16 15:10:44','',''),(1265,'5','271',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,10000.00,0.00,'2022-07-16 15:10:56','',''),(1266,'5','271','3',1,'Received from bridging 173',0.00,0.00,10000.00,0.00,0.00,'2022-07-16 15:10:56','',''),(1267,'5','271','2',1,'Sale Id shift 101',0.00,0.00,0.00,435.08,0.00,'2022-07-16 21:45:08','',''),(1268,'5','271','3',1,'Sale Id shift 101',0.00,0.00,0.00,12042.84,0.00,'2022-07-16 21:45:08','',''),(1269,'5','271','1',1,'Sale Id shift 101',0.00,0.00,0.00,7965.46,0.00,'2022-07-16 21:45:08','',''),(1270,'5','271','5',2,'Sale Id shift 101',0.00,0.00,0.00,350.81,0.00,'2022-07-16 21:45:08','',''),(1271,'5','271','1',1,'Sale Id shift 101',0.00,0.00,0.00,8034.39,0.00,'2022-07-16 21:45:08','',''),(1272,'5','271','1',1,'Sale Id shift 101',0.00,0.00,0.00,8660.11,0.00,'2022-07-16 21:45:08','',''),(1273,'5','271',NULL,2,'Sale Id shift 101',280648.00,0.00,0.00,0.00,0.00,'2022-07-16 21:45:08','',''),(1274,'5','271',NULL,1,'Sale Id shift 101',6870507.80,0.00,0.00,0.00,0.00,'2022-07-16 21:45:08','',''),(1275,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7363000.00,39800.00,0.00,0.00,'2022-07-19 10:34:20','',''),(1276,'5','271',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,38000.00,0.00,'2022-07-19 10:53:46','',''),(1277,'5','271','3',1,'Received from bridging 174',0.00,0.00,38000.00,0.00,0.00,'2022-07-19 10:53:46','',''),(1278,'5','271','2',1,'Sale Id shift 102',0.00,0.00,0.00,5077.96,0.00,'2022-07-19 11:11:33','',''),(1279,'5','271','3',1,'Sale Id shift 102',0.00,0.00,0.00,5654.95,0.00,'2022-07-19 11:11:33','',''),(1280,'5','271','3',1,'Sale Id shift 102',0.00,0.00,0.00,7566.17,0.00,'2022-07-19 11:11:33','',''),(1281,'5','271','5',2,'Sale Id shift 102',0.00,0.00,0.00,535.26,0.00,'2022-07-19 11:11:33','',''),(1282,'5','271','2',1,'Sale Id shift 102',0.00,0.00,0.00,7025.91,0.00,'2022-07-19 11:11:33','',''),(1283,'5','271',NULL,2,'Sale Id shift 102',428208.00,0.00,0.00,0.00,0.00,'2022-07-19 11:11:33','',''),(1284,'5','271',NULL,1,'Sale Id shift 102',4685123.15,0.00,0.00,0.00,0.00,'2022-07-19 11:11:33','',''),(1285,'5','271','3',1,'Sale Id shift 103',0.00,0.00,0.00,584.23,0.00,'2022-07-19 12:42:11','',''),(1286,'5','271','5',2,'Sale Id shift 103',0.00,0.00,0.00,393.75,0.00,'2022-07-19 12:42:11','',''),(1287,'5','271','1',1,'Sale Id shift 103',0.00,0.00,0.00,3539.86,0.00,'2022-07-19 12:42:11','',''),(1288,'5','271','1',1,'Sale Id shift 103',0.00,0.00,0.00,3172.42,0.00,'2022-07-19 12:42:11','',''),(1289,'5','271','2',1,'Sale Id shift 103',0.00,0.00,0.00,5105.33,0.00,'2022-07-19 12:42:11','',''),(1290,'5','271',NULL,2,'Sale Id shift 103',315000.00,0.00,0.00,0.00,0.00,'2022-07-19 12:42:11','',''),(1291,'5','271',NULL,1,'Sale Id shift 103',2294340.40,0.00,0.00,0.00,0.00,'2022-07-19 12:42:11','',''),(1292,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7372250.00,39850.00,0.00,0.00,'2022-07-20 09:51:29','',''),(1293,'5','271',NULL,1,'Reception corrector for bridging 175',0.00,0.00,0.00,19850.00,0.00,'2022-07-20 19:56:28','',''),(1294,'5','271','1',1,'Received from bridging 175',0.00,0.00,19850.00,0.00,0.00,'2022-07-20 19:56:28','',''),(1295,'5','271',NULL,1,'Reception corrector for bridging 176',0.00,0.00,0.00,20000.00,0.00,'2022-07-20 19:56:45','',''),(1296,'5','271','2',1,'Received from bridging 176',0.00,0.00,20000.00,0.00,0.00,'2022-07-20 19:56:45','',''),(1297,'5','271',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,1800.00,0.00,'2022-07-20 19:57:15','',''),(1298,'5','271','3',1,'Received from bridging 177',0.00,0.00,1800.00,0.00,0.00,'2022-07-20 19:57:15','',''),(1299,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,7287150.00,39390.00,0.00,0.00,'2022-07-21 12:54:33','',''),(1300,'5','271','2',1,'Sale Id shift 104',0.00,0.00,0.00,9314.19,0.00,'2022-07-21 16:49:39','',''),(1301,'5','271','3',1,'Sale Id shift 104',0.00,0.00,0.00,1833.66,0.00,'2022-07-21 16:49:39','',''),(1302,'5','271','5',2,'Sale Id shift 104',0.00,0.00,0.00,1619.85,0.00,'2022-07-21 16:49:39','',''),(1303,'5','271','1',1,'Sale Id shift 104',0.00,0.00,0.00,8245.31,0.00,'2022-07-21 16:49:39','',''),(1304,'5','271','1',1,'Sale Id shift 104',0.00,0.00,0.00,7315.83,0.00,'2022-07-21 16:49:39','',''),(1305,'5','271','2',1,'Sale Id shift 104',0.00,0.00,0.00,1638.02,0.00,'2022-07-21 16:49:39','',''),(1306,'5','271','2',1,'Sale Id shift 104',0.00,0.00,0.00,5201.56,0.00,'2022-07-21 16:49:39','',''),(1307,'5','271',NULL,2,'Sale Id shift 104',1295880.00,0.00,0.00,0.00,0.00,'2022-07-21 16:49:39','',''),(1308,'5','271',NULL,1,'Sale Id shift 104',6206485.45,0.00,0.00,0.00,0.00,'2022-07-21 16:49:39','',''),(1309,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,11081500.00,59900.00,0.00,0.00,'2022-07-22 07:20:47','',''),(1310,'5','271',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,19390.00,0.00,'2022-07-22 07:20:57','',''),(1311,'5','271','1',1,'Received from bridging 178',0.00,0.00,19390.00,0.00,0.00,'2022-07-22 07:20:57','',''),(1312,'5','271',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,20000.00,0.00,'2022-07-22 07:21:08','',''),(1313,'5','271','2',1,'Received from bridging 179',0.00,0.00,20000.00,0.00,0.00,'2022-07-22 07:21:08','',''),(1314,'5','271',NULL,1,'Reception corrector for bridging 181',0.00,0.00,0.00,15000.00,0.00,'2022-07-22 14:00:01','',''),(1315,'5','271','2',1,'Received from bridging 181',0.00,0.00,15000.00,0.00,0.00,'2022-07-22 14:00:01','',''),(1316,'5','271',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,25000.00,0.00,'2022-07-22 14:00:12','',''),(1317,'5','271','1',1,'Received from bridging 180',0.00,0.00,25000.00,0.00,0.00,'2022-07-22 14:00:12','',''),(1318,'5','271','2',1,'Sale Id shift 105',0.00,0.00,0.00,4586.87,0.00,'2022-07-22 14:18:39','',''),(1319,'5','271','3',1,'Sale Id shift 105',0.00,0.00,0.00,1667.37,0.00,'2022-07-22 14:18:39','',''),(1320,'5','271','3',1,'Sale Id shift 105',0.00,0.00,0.00,2513.47,0.00,'2022-07-22 14:18:39','',''),(1321,'5','271','1',1,'Sale Id shift 105',0.00,0.00,0.00,1972.53,0.00,'2022-07-22 14:18:39','',''),(1322,'5','271','5',2,'Sale Id shift 105',0.00,0.00,0.00,569.83,0.00,'2022-07-22 14:18:39','',''),(1323,'5','271','1',1,'Sale Id shift 105',0.00,0.00,0.00,5274.30,0.00,'2022-07-22 14:18:39','',''),(1324,'5','271','1',1,'Sale Id shift 105',0.00,0.00,0.00,3414.94,0.00,'2022-07-22 14:18:39','',''),(1325,'5','271','2',1,'Sale Id shift 105',0.00,0.00,0.00,2804.22,0.00,'2022-07-22 14:18:39','',''),(1326,'5','271','2',1,'Sale Id shift 105',0.00,0.00,0.00,3989.61,0.00,'2022-07-22 14:18:39','',''),(1327,'5','271',NULL,2,'Sale Id shift 105',455864.00,0.00,0.00,0.00,0.00,'2022-07-22 14:18:39','',''),(1328,'5','271',NULL,1,'Sale Id shift 105',4851312.35,0.00,0.00,0.00,0.00,'2022-07-22 14:18:39','',''),(1329,'5','271','2',1,'Sale Id shift 106',0.00,0.00,0.00,8130.71,0.00,'2022-07-22 15:12:20','',''),(1330,'5','271','4',1,'Sale Id shift 106',0.00,0.00,0.00,5188.80,0.00,'2022-07-22 15:12:20','',''),(1331,'5','271','1',1,'Sale Id shift 106',0.00,0.00,0.00,4666.82,0.00,'2022-07-22 15:12:20','',''),(1332,'5','271','5',2,'Sale Id shift 106',0.00,0.00,0.00,1019.99,0.00,'2022-07-22 15:12:20','',''),(1333,'5','271','5',2,'Sale Id shift 106',0.00,0.00,0.00,2077.35,0.00,'2022-07-22 15:12:20','',''),(1334,'5','271','1',1,'Sale Id shift 106',0.00,0.00,0.00,4191.27,0.00,'2022-07-22 15:12:20','',''),(1335,'5','271','1',1,'Sale Id shift 106',0.00,0.00,0.00,5156.51,0.00,'2022-07-22 15:12:20','',''),(1336,'5','271',NULL,2,'Sale Id shift 106',2477872.00,0.00,0.00,0.00,0.00,'2022-07-22 15:12:20','',''),(1337,'5','271',NULL,1,'Sale Id shift 106',5056810.35,0.00,0.00,0.00,0.00,'2022-07-22 15:12:20','',''),(1338,'5','271','2',1,'Sale Id shift 107',0.00,0.00,0.00,3956.94,0.00,'2022-07-22 16:42:51','',''),(1339,'5','271','3',1,'Sale Id shift 107',0.00,0.00,0.00,3597.84,0.00,'2022-07-22 16:42:51','',''),(1340,'5','271','3',1,'Sale Id shift 107',0.00,0.00,0.00,1540.09,0.00,'2022-07-22 16:42:51','',''),(1341,'5','271','4',1,'Sale Id shift 107',0.00,0.00,0.00,2033.09,0.00,'2022-07-22 16:42:51','',''),(1342,'5','271','4',1,'Sale Id shift 107',0.00,0.00,0.00,3916.91,0.00,'2022-07-22 16:42:51','',''),(1343,'5','271','5',2,'Sale Id shift 107',0.00,0.00,0.00,1113.26,0.00,'2022-07-22 16:42:51','',''),(1344,'5','271','2',1,'Sale Id shift 107',0.00,0.00,0.00,1516.52,0.00,'2022-07-22 16:42:51','',''),(1345,'5','271',NULL,2,'Sale Id shift 107',890608.00,0.00,0.00,0.00,0.00,'2022-07-22 16:42:51','',''),(1346,'5','271',NULL,1,'Sale Id shift 107',3063857.15,0.00,0.00,0.00,0.00,'2022-07-22 16:42:51','',''),(1347,'5','271','2',1,'Sale Id shift 108',0.00,0.00,0.00,7414.50,0.00,'2022-07-23 18:40:58','',''),(1348,'5','271','3',1,'Sale Id shift 108',0.00,0.00,0.00,4971.68,0.00,'2022-07-23 18:40:58','',''),(1349,'5','271','3',1,'Sale Id shift 108',0.00,0.00,0.00,4640.64,0.00,'2022-07-23 18:40:58','',''),(1350,'5','271','4',1,'Sale Id shift 108',0.00,0.00,0.00,2818.32,0.00,'2022-07-23 18:40:58','',''),(1351,'5','271','5',2,'Sale Id shift 108',0.00,0.00,0.00,1487.48,0.00,'2022-07-23 18:40:58','',''),(1352,'5','271','1',1,'Sale Id shift 108',0.00,0.00,0.00,3199.22,0.00,'2022-07-23 18:40:58','',''),(1353,'5','271','1',1,'Sale Id shift 108',0.00,0.00,0.00,4772.17,0.00,'2022-07-23 18:40:58','',''),(1354,'5','271','2',1,'Sale Id shift 108',0.00,0.00,0.00,2054.10,0.00,'2022-07-23 18:40:58','',''),(1355,'5','271','2',1,'Sale Id shift 108',0.00,0.00,0.00,7094.02,0.00,'2022-07-23 18:40:58','',''),(1356,'5','271',NULL,2,'Sale Id shift 108',1189984.00,0.00,0.00,0.00,0.00,'2022-07-23 18:40:58','',''),(1357,'5','271',NULL,1,'Sale Id shift 108',6838460.25,0.00,0.00,0.00,0.00,'2022-07-23 18:40:58','',''),(1358,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-07-23 18:41:20','',''),(1359,'5','271',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,19900.00,0.00,'2022-07-23 18:41:37','',''),(1360,'5','271','1',1,'Received from bridging 182',0.00,0.00,19900.00,0.00,0.00,'2022-07-23 18:41:37','',''),(1361,'5','271',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,30000.00,0.00,'2022-07-24 09:55:52','',''),(1362,'5','271','3',1,'Received from bridging 184',0.00,0.00,30000.00,0.00,0.00,'2022-07-24 09:55:52','',''),(1363,'5','271',NULL,1,'Reception corrector for bridging 183',0.00,0.00,0.00,30000.00,0.00,'2022-07-24 09:56:04','',''),(1364,'5','271','2',1,'Received from bridging 183',0.00,0.00,30000.00,0.00,0.00,'2022-07-24 09:56:04','',''),(1365,'5','271','2',1,'Sale Id shift 109',0.00,0.00,0.00,8594.38,0.00,'2022-07-25 17:02:08','',''),(1366,'5','271','3',1,'Sale Id shift 109',0.00,0.00,0.00,5682.46,0.00,'2022-07-25 17:02:08','',''),(1367,'5','271','3',1,'Sale Id shift 109',0.00,0.00,0.00,5664.24,0.00,'2022-07-25 17:02:08','',''),(1368,'5','271','4',1,'Sale Id shift 109',0.00,0.00,0.00,6671.73,0.00,'2022-07-25 17:02:08','',''),(1369,'5','271','4',1,'Sale Id shift 109',0.00,0.00,0.00,4339.21,0.00,'2022-07-25 17:02:08','',''),(1370,'5','271','5',2,'Sale Id shift 109',0.00,0.00,0.00,537.59,0.00,'2022-07-25 17:02:08','',''),(1371,'5','271','1',1,'Sale Id shift 109',0.00,0.00,0.00,6928.01,0.00,'2022-07-25 17:02:08','',''),(1372,'5','271','1',1,'Sale Id shift 109',0.00,0.00,0.00,6366.92,0.00,'2022-07-25 17:02:08','',''),(1373,'5','271','2',1,'Sale Id shift 109',0.00,0.00,0.00,3734.95,0.00,'2022-07-25 17:02:08','',''),(1374,'5','271','2',1,'Sale Id shift 109',0.00,0.00,0.00,7185.55,0.00,'2022-07-25 17:02:08','',''),(1375,'5','271',NULL,2,'Sale Id shift 109',430072.00,0.00,0.00,0.00,0.00,'2022-07-25 17:02:08','',''),(1376,'5','271',NULL,1,'Sale Id shift 109',10205978.25,0.00,0.00,0.00,0.00,'2022-07-25 17:02:08','',''),(1377,'5','271','2',1,'Sale Id shift 110',0.00,0.00,0.00,4630.45,0.00,'2022-07-26 07:10:28','',''),(1378,'5','271','3',1,'Sale Id shift 110',0.00,0.00,0.00,5330.25,0.00,'2022-07-26 07:10:28','',''),(1379,'5','271','3',1,'Sale Id shift 110',0.00,0.00,0.00,8209.65,0.00,'2022-07-26 07:10:28','',''),(1380,'5','271','4',1,'Sale Id shift 110',0.00,0.00,0.00,8692.39,0.00,'2022-07-26 07:10:28','',''),(1381,'5','271','4',1,'Sale Id shift 110',0.00,0.00,0.00,8067.25,0.00,'2022-07-26 07:10:28','',''),(1382,'5','271','1',1,'Sale Id shift 110',0.00,0.00,0.00,5985.11,0.00,'2022-07-26 07:10:28','',''),(1383,'5','271','5',2,'Sale Id shift 110',0.00,0.00,0.00,1245.57,0.00,'2022-07-26 07:10:28','',''),(1384,'5','271','1',1,'Sale Id shift 110',0.00,0.00,0.00,5494.07,0.00,'2022-07-26 07:10:28','',''),(1385,'5','271','1',1,'Sale Id shift 110',0.00,0.00,0.00,5877.68,0.00,'2022-07-26 07:10:28','',''),(1386,'5','271',NULL,2,'Sale Id shift 110',996456.00,0.00,0.00,0.00,0.00,'2022-07-26 07:10:28','',''),(1387,'5','271',NULL,1,'Sale Id shift 110',9673067.25,0.00,0.00,0.00,0.00,'2022-07-26 07:10:28','',''),(1388,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-07-26 12:15:20','',''),(1389,'5','271',NULL,1,'Reception corrector for bridging 187',0.00,0.00,0.00,15000.00,0.00,'2022-07-26 12:26:38','',''),(1390,'5','271','4',1,'Received from bridging 187',0.00,0.00,15000.00,0.00,0.00,'2022-07-26 12:26:38','',''),(1391,'5','271',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,13000.00,0.00,'2022-07-26 12:26:44','',''),(1392,'5','271','2',1,'Received from bridging 186',0.00,0.00,13000.00,0.00,0.00,'2022-07-26 12:26:44','',''),(1393,'5','271',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,32000.00,0.00,'2022-07-26 12:26:52','',''),(1394,'5','271','1',1,'Received from bridging 185',0.00,0.00,32000.00,0.00,0.00,'2022-07-26 12:26:52','',''),(1395,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-28 13:24:10','',''),(1396,'5','271',NULL,1,'Reception corrector for bridging 188',0.00,0.00,0.00,26000.00,0.00,'2022-07-28 15:47:43','',''),(1397,'5','271','2',1,'Received from bridging 188',0.00,0.00,26000.00,0.00,0.00,'2022-07-28 15:47:43','',''),(1398,'5','271','2',1,'Sale Id shift 111',0.00,0.00,0.00,8339.11,0.00,'2022-07-28 16:08:52','',''),(1399,'5','271','3',1,'Sale Id shift 111',0.00,0.00,0.00,5444.15,0.00,'2022-07-28 16:08:52','',''),(1400,'5','271','3',1,'Sale Id shift 111',0.00,0.00,0.00,7477.63,0.00,'2022-07-28 16:08:52','',''),(1401,'5','271','4',1,'Sale Id shift 111',0.00,0.00,0.00,75.66,0.00,'2022-07-28 16:08:52','',''),(1402,'5','271','4',1,'Sale Id shift 111',0.00,0.00,0.00,2864.13,0.00,'2022-07-28 16:08:52','',''),(1403,'5','271','5',2,'Sale Id shift 111',0.00,0.00,0.00,324.25,0.00,'2022-07-28 16:08:52','',''),(1404,'5','271','5',2,'Sale Id shift 111',0.00,0.00,0.00,19.05,0.00,'2022-07-28 16:08:52','',''),(1405,'5','271','1',1,'Sale Id shift 111',0.00,0.00,0.00,2814.54,0.00,'2022-07-28 16:08:52','',''),(1406,'5','271','1',1,'Sale Id shift 111',0.00,0.00,0.00,3206.14,0.00,'2022-07-28 16:08:52','',''),(1407,'5','271','2',1,'Sale Id shift 111',0.00,0.00,0.00,6002.58,0.00,'2022-07-28 16:08:52','',''),(1408,'5','271','2',1,'Sale Id shift 111',0.00,0.00,0.00,9086.89,0.00,'2022-07-28 16:08:52','',''),(1409,'5','271',NULL,2,'Sale Id shift 111',274640.00,0.00,0.00,0.00,0.00,'2022-07-28 16:08:52','',''),(1410,'5','271',NULL,1,'Sale Id shift 111',8382503.55,0.00,0.00,0.00,0.00,'2022-07-28 16:08:52','',''),(1411,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-08-02 11:53:51','',''),(1412,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,10951260.00,59196.00,0.00,0.00,'2022-08-02 11:58:54','',''),(1413,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-08-02 11:59:07','',''),(1414,'5','271',NULL,1,'Purchased from SALBAS OIL AND GAS NIG LTD',0.00,9083500.00,49100.00,0.00,0.00,'2022-08-02 11:59:12','',''),(1415,'5','271',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,19000.00,0.00,'2022-08-02 12:18:38','',''),(1416,'5','271','2',1,'Received from bridging 189',0.00,0.00,19000.00,0.00,0.00,'2022-08-02 12:18:38','',''),(1417,'5','271',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,40000.00,0.00,'2022-08-02 12:18:45','',''),(1418,'5','271','3',1,'Received from bridging 190',0.00,0.00,40000.00,0.00,0.00,'2022-08-02 12:18:45','',''),(1419,'5','271',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,17000.00,0.00,'2022-08-02 12:18:52','',''),(1420,'5','271','1',1,'Received from bridging 191',0.00,0.00,17000.00,0.00,0.00,'2022-08-02 12:18:52','',''),(1421,'5','271',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,30000.00,0.00,'2022-08-02 12:19:00','',''),(1422,'5','271','4',1,'Received from bridging 192',0.00,0.00,30000.00,0.00,0.00,'2022-08-02 12:19:00','',''),(1423,'5','271','2',1,'Sale Id shift 112',0.00,0.00,0.00,2289.68,0.00,'2022-08-02 12:20:13','',''),(1424,'5','271','3',1,'Sale Id shift 112',0.00,0.00,0.00,4588.11,0.00,'2022-08-02 12:20:13','',''),(1425,'5','271','3',1,'Sale Id shift 112',0.00,0.00,0.00,4803.35,0.00,'2022-08-02 12:20:13','',''),(1426,'5','271','4',1,'Sale Id shift 112',0.00,0.00,0.00,6610.02,0.00,'2022-08-02 12:20:13','',''),(1427,'5','271','4',1,'Sale Id shift 112',0.00,0.00,0.00,6265.53,0.00,'2022-08-02 12:20:13','',''),(1428,'5','271','1',1,'Sale Id shift 112',0.00,0.00,0.00,6143.77,0.00,'2022-08-02 12:20:13','',''),(1429,'5','271','5',2,'Sale Id shift 112',0.00,0.00,0.00,539.54,0.00,'2022-08-02 12:20:13','',''),(1430,'5','271','1',1,'Sale Id shift 112',0.00,0.00,0.00,5078.36,0.00,'2022-08-02 12:20:13','',''),(1431,'5','271','1',1,'Sale Id shift 112',0.00,0.00,0.00,4917.76,0.00,'2022-08-02 12:20:13','',''),(1432,'5','271','2',1,'Sale Id shift 112',0.00,0.00,0.00,2201.70,0.00,'2022-08-02 12:20:13','',''),(1433,'5','271','2',1,'Sale Id shift 112',0.00,0.00,0.00,2802.48,0.00,'2022-08-02 12:20:13','',''),(1434,'5','271',NULL,2,'Sale Id shift 112',431632.00,0.00,0.00,0.00,0.00,'2022-08-02 12:20:13','',''),(1435,'5','271',NULL,1,'Sale Id shift 112',8454640.60,0.00,0.00,0.00,0.00,'2022-08-02 12:20:13','',''),(1436,'5','271','3',1,'Sale Id shift 113',0.00,0.00,0.00,1079.17,0.00,'2022-08-02 12:28:10','',''),(1437,'5','271','3',1,'Sale Id shift 113',0.00,0.00,0.00,2562.00,0.00,'2022-08-02 12:28:10','',''),(1438,'5','271','4',1,'Sale Id shift 113',0.00,0.00,0.00,1426.34,0.00,'2022-08-02 12:28:10','',''),(1439,'5','271','4',1,'Sale Id shift 113',0.00,0.00,0.00,1136.65,0.00,'2022-08-02 12:28:10','',''),(1440,'5','271','1',1,'Sale Id shift 113',0.00,0.00,0.00,6229.43,0.00,'2022-08-02 12:28:10','',''),(1441,'5','271','5',2,'Sale Id shift 113',0.00,0.00,0.00,1405.73,0.00,'2022-08-02 12:28:10','',''),(1442,'5','271','1',1,'Sale Id shift 113',0.00,0.00,0.00,6065.27,0.00,'2022-08-02 12:28:10','',''),(1443,'5','271','1',1,'Sale Id shift 113',0.00,0.00,0.00,7216.09,0.00,'2022-08-02 12:28:10','',''),(1444,'5','271',NULL,2,'Sale Id shift 113',1124584.00,0.00,0.00,0.00,0.00,'2022-08-02 12:28:10','',''),(1445,'5','271',NULL,1,'Sale Id shift 113',4757265.75,0.00,0.00,0.00,0.00,'2022-08-02 12:28:10','',''),(1446,'5','271','2',1,'Sale Id shift 114',0.00,0.00,0.00,7623.78,0.00,'2022-08-02 12:36:24','',''),(1447,'5','271','5',2,'Sale Id shift 114',0.00,0.00,0.00,1172.86,0.00,'2022-08-02 12:36:24','',''),(1448,'5','271','1',1,'Sale Id shift 114',0.00,0.00,0.00,3846.61,0.00,'2022-08-02 12:36:24','',''),(1449,'5','271','1',1,'Sale Id shift 114',0.00,0.00,0.00,4295.46,0.00,'2022-08-02 12:36:24','',''),(1450,'5','271','2',1,'Sale Id shift 114',0.00,0.00,0.00,5296.94,0.00,'2022-08-02 12:36:24','',''),(1451,'5','271','2',1,'Sale Id shift 114',0.00,0.00,0.00,7723.19,0.00,'2022-08-02 12:36:24','',''),(1452,'5','271',NULL,2,'Sale Id shift 114',938288.00,0.00,0.00,0.00,0.00,'2022-08-02 12:36:24','',''),(1453,'5','271',NULL,1,'Sale Id shift 114',5325406.30,0.00,0.00,0.00,0.00,'2022-08-02 12:36:24','',''),(1454,'5','271',NULL,1,'Reception corrector for bridging 193',0.00,0.00,0.00,5000.00,0.00,'2022-08-02 13:14:14','',''),(1455,'5','271','3',1,'Received from bridging 193',0.00,0.00,5000.00,0.00,0.00,'2022-08-02 13:14:14','',''),(1456,'5','271',NULL,1,'Reception corrector for bridging 194',0.00,0.00,0.00,17000.00,0.00,'2022-08-02 13:14:25','',''),(1457,'5','271','1',1,'Received from bridging 194',0.00,0.00,17000.00,0.00,0.00,'2022-08-02 13:14:25','',''),(1458,'5','271',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,12196.00,0.00,'2022-08-0