-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_184
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_184`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_184` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_184`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3511 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3456,4037,'',0,'2','5','184','0001480969-TAJ BANK','','2021-07-14 09:09:34',5,0.00,0.00,'','600','2021-07-14 09:09:34','600',0,1),(3479,4023,'',0,'20','5','184','SALES','','2021-07-15 07:14:13',5,0.00,0.00,'','576','2021-07-15 07:14:13','576',0,1),(3480,4010,'',0,'22','5','184','PURCHASES','','2021-07-15 07:14:27',5,0.00,0.00,'','576','2021-07-15 07:14:27','576',0,1),(3481,30174,'',0,'24','5','184','PURCHASES','','2021-07-15 07:14:45',5,0.00,0.00,'','576','2021-07-15 07:14:45','576',0,1),(3482,30175,'',0,'24','5','184','SALARIES & WAGES','','2021-07-15 07:15:08',5,0.00,0.00,'','576','2021-07-15 07:15:08','576',0,1),(3483,3025,'',0,'6.1','5','184','CASH','','2021-07-15 07:15:54',5,0.00,0.00,'','576','2021-07-15 07:15:54','576',0,1),(3508,4041,'',0,'2','5','184','UBA-1023852627','','2021-07-23 14:28:57',5,0.00,0.00,'','600','2021-07-23 14:28:57','600',0,1),(3509,4042,'',0,'2','5','184','JA\'IZ-0010037957','','2022-03-02 19:02:56',5,0.00,0.00,'','600','2022-03-02 19:02:56','600',0,0),(3510,2000,'',0,'6','5','184','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:23:33',5,0.00,0.00,'','600','2023-02-06 10:23:33','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (2,'5','184','0000-00-00','2023-02-07 14:20:19',10,'795','','0000-00-00 00:00:00','606','2023-02-08 16:06:04'),(3,'5','184','0000-00-00','2023-02-22 13:06:33',10,'795','','0000-00-00 00:00:00','795','2023-03-02 14:05:05');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (3,'5','184','2','3510','6',0.00,'PMS Price Increase (185 to 220, 8956.68 litres on 20/1/2023',313484.50,'2023-02-07'),(4,'5','184','2','253','supplier',313484.50,'PMS Price Increase (185 to 220, 8956.68 litres on 20/1/2023',0.00,'2023-02-07'),(5,'5','184','3','253','supplier',0.00,'PMS Price decrease( 220 to 210 1,800litres on 19/2/2023',18000.00,'2023-02-19'),(6,'5','184','3','253','supplier',18000.00,'PMS Price decrease 220 to 210, 1,800litres on 19/2/2023',0.00,'2023-02-19'),(7,'5','184','3','253','supplier',0.00,'Ago Price decrease 830 to 820litres on 20/2/2023',5000.00,'2023-02-20'),(8,'5','184','3','253','supplier',5000.00,'Ago Price decrease 830 to 820 250litres on 20/2/2023',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3810 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3809,'','5','184','C.C.E.C.C','SHIELU RASAK','08134980693','info@aaranonigerialtd.com.ng','Kano','Kano','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-18 10:56:34',5,'600','2021-11-18 10:56:34','600');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16055 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','184',15863,'957',41045.55,39900.00,'2021-07-28','','2021-07-28 11:32:58','600','600',2021,'600','2021-07-28 11:32:58',5),('5','184',15864,'958',277.68,400.00,'2021-07-28','','2021-07-28 11:33:17','600','600',2021,'600','2021-07-28 11:33:17',5),('5','184',15944,'960',0.00,44750.00,'2021-08-03','','2021-08-03 10:17:31','600','600',2021,'600','2021-08-03 10:17:31',5),('5','184',16000,'960',44285.85,5286.00,'2021-08-10','','2021-08-10 11:10:17','600','600',2021,'600','2021-08-10 11:10:17',5),('5','184',16002,'957',47704.38,40850.00,'2021-08-10','','2021-08-10 12:38:17','600','600',2021,'600','2021-08-10 12:38:17',5),('5','184',16003,'958',2831.92,3800.00,'2021-08-10','','2021-08-10 12:39:24','600','600',2021,'600','2021-08-10 12:39:24',5),('5','184',16014,'957',40850.00,750.00,'2021-08-11','','2021-08-11 10:16:32','600','600',2021,'600','2021-08-11 10:16:32',5),('5','184',16015,'958',3800.00,9800.00,'2021-08-11','','2021-08-11 10:16:52','600','600',2021,'600','2021-08-11 10:16:52',5),('5','184',16037,'957',750.00,40850.00,'2021-08-12','','2021-08-12 14:11:42','600','600',2021,'600','2021-08-12 14:11:42',5),('5','184',16038,'958',9453.22,3900.00,'2021-08-12','','2021-08-12 14:12:03','600','600',2021,'600','2021-08-12 14:12:03',5),('5','184',16039,'958',1136.14,30000.00,'2022-07-01','','2022-07-04 09:52:04','640','640',2022,'640','2022-07-04 09:52:04',5),('5','184',16040,'958',17122.35,15000.00,'2022-07-18','','2022-07-18 16:27:45','600','600',2022,'600','2022-07-18 16:27:45',5),('5','184',16041,'957',819.14,11600.00,'2022-09-04','','2022-09-04 13:24:56','600','600',2022,'600','2022-09-04 13:24:56',5),('5','184',16042,'957',50093.63,1050.00,'2022-09-28','','2022-09-28 10:29:11','600','600',2022,'600','2022-09-28 10:29:11',5),('5','184',16043,'958',6850.19,450.00,'2022-09-28','','2022-09-28 10:29:30','600','600',2022,'600','2022-09-28 10:29:30',5),('5','184',16044,'960',1392.07,300.00,'2022-09-28','','2022-09-28 10:29:48','600','600',2022,'600','2022-09-28 10:29:48',5),('5','184',16045,'959',24739.02,500.00,'2022-11-21','','2022-11-21 14:04:48','600','600',2022,'600','2022-11-21 14:04:48',5),('5','184',16046,'957',2759.59,2760.00,'2023-01-23','','2023-01-23 15:49:03','600','600',2023,'600','2023-01-23 15:49:03',5),('5','184',16047,'958',448.54,3282.00,'2023-01-23','','2023-01-23 15:49:23','600','600',2023,'600','2023-01-23 15:49:23',5),('5','184',16048,'958',3282.00,500.00,'2023-01-23','','2023-01-23 15:50:08','600','600',2023,'600','2023-01-23 15:50:08',5),('5','184',16049,'957',2760.00,3000.00,'2023-01-23','','2023-01-23 21:40:18','600','600',2023,'600','2023-01-23 21:40:18',5),('5','184',16050,'958',500.00,1000.00,'2023-01-23','','2023-01-23 21:40:38','600','600',2023,'600','2023-01-23 21:40:38',5),('5','184',16051,'957',3000.00,3500.00,'2023-01-24','','2023-01-24 09:22:26','600','600',2023,'600','2023-01-24 09:22:26',5),('5','184',16052,'957',409.77,750.00,'2023-02-07','','2023-02-07 10:40:16','600','600',2023,'600','2023-02-07 10:40:16',5),('5','184',16053,'957',7333.18,7500.00,'2023-03-14','','2023-03-14 11:50:43','600','600',2023,'600','2023-03-14 11:50:43',5),('5','184',16054,'957',7500.00,7700.00,'2023-03-14','','2023-03-14 16:44:36','600','600',2023,'600','2023-03-14 16:44:36',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2853 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','184','958',2843,'5','PMS PUMP 1',386036.72,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:23:51','600'),('5','184','958',2844,'5','PMS PUMP 2',271685.74,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:24:31','600'),('5','184','958',2845,'5','PMS PUMP 3',392678.75,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:25:11','600'),('5','184','958',2846,'5','PMS PUMP 4',363395.37,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:25:47','600'),('5','184','957',2847,'5','PMS PUMP 5',238506.59,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:26:16','600'),('5','184','957',2848,'5','PMS PUMP 6',253034.32,'PMS DISPENSER','',NULL,NULL,'',5,'2022-06-29 13:35:56','600'),('5','184','957',2849,'5','PMS PUMP 7',358158.15,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:27:06','600'),('5','184','957',2850,'5','PMS PUMP 8',313638.65,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-04 12:14:37','600'),('5','184','959',2851,'5','AGO PUMP',329503.87,'AGO DISPENSER','',NULL,NULL,'',5,'2022-06-29 13:40:49','600'),('5','184','960',2852,'5','DPK PUMP',66765.86,'DPK DISPENSER','',NULL,NULL,'',5,'2022-09-28 10:28:03','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (231,'5','184','2843','958','PMS TANKS CONNECTION ERROR.','2021-07-28 11:28:44',0,'600'),(232,'5','184','2844','958','PMS TANKS CONNECTION ERROR.','2021-07-28 11:29:13',0,'600'),(233,'5','184','2845','958','PMS TANKS CONNECTION ERROR.','2021-07-28 11:29:38',0,'600'),(234,'5','184','2846','958','PMS TANKS CONNECTION ERROR.','2021-07-28 11:30:03',0,'600'),(235,'5','184','2847','957','PMS TANKS CONNECTION ERROR.','2021-07-28 11:30:29',0,'600'),(236,'5','184','2848','957','PMS TANKS CONNECTION ERROR.','2021-07-28 11:31:03',0,'600'),(237,'5','184','2849','957','PMS TANKS CONNECTION ERROR.','2021-07-28 11:31:27',0,'600'),(238,'5','184','2850','957','PMS TANKS CONNECTION ERROR.','2021-07-28 11:31:50',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257397 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','184',212338,'MORNING','2021-07-09','2021-07-09 00:00:00',NULL,'640',1008047.55,1008047.55,'600','2021-07-26 14:10:05','607','2021-07-26 14:14:44',10,0),('5','184',213030,'MORNING','2021-07-10','2021-07-10 00:00:00',NULL,'640',1327495.05,1327495.05,'640','2021-07-26 14:25:36','607','2021-07-26 14:27:04',10,0),('5','184',213036,'MORNING','2021-07-11','2021-07-11 00:00:00',NULL,'640',1525250.90,1520195.65,'640','2021-07-26 14:42:34','607','2021-07-26 14:44:46',10,0),('5','184',213043,'MORNING','2021-07-12','2021-07-12 00:00:00',NULL,'640',654989.80,654501.05,'640','2021-07-26 14:58:10','607','2021-07-26 14:58:42',10,0),('5','184',213057,'MORNING','2021-07-13','2021-07-13 00:00:00',NULL,'640',0.00,0.00,'640','2021-07-26 15:43:13','607','2021-07-26 15:50:03',10,0),('5','184',213061,'MORNING','2021-07-14','2021-07-14 00:00:00',NULL,'640',0.00,0.00,'640','2021-07-26 15:53:14','607','2021-07-26 15:54:46',10,0),('5','184',213062,'MORNING','2021-07-15','2021-07-15 00:00:00',NULL,'640',473927.20,473927.20,'640','2021-07-26 15:59:47','607','2021-07-26 16:22:42',10,0),('5','184',213068,'MORNING','2021-07-16','2021-07-16 00:00:00',NULL,'640',1240831.65,1240831.65,'640','2021-07-26 16:31:50','607','2021-07-27 09:25:19',10,0),('5','184',213228,'MORNING','2021-07-17','2021-07-17 00:00:00',NULL,'640',1414184.05,1414184.05,'640','2021-07-27 10:28:47','607','2021-07-27 10:39:58',10,0),('5','184',213237,'MORNING','2021-07-18','2021-07-18 00:00:00',NULL,'640',1231692.85,1231692.85,'640','2021-07-27 10:46:29','607','2021-07-27 10:54:35',10,0),('5','184',213242,'MORNING','2021-07-19','2021-07-19 00:00:00',NULL,'640',1609377.30,1609377.30,'640','2021-07-27 11:02:15','607','2021-07-27 11:17:48',10,0),('5','184',213260,'MORNING','2021-07-20','2021-07-20 00:00:00',NULL,'640',1257874.80,1257874.80,'640','2021-07-27 11:32:28','607','2021-07-27 11:45:09',10,0),('5','184',213284,'MORNING','2021-07-21','2021-07-21 00:00:00',NULL,'640',1179263.90,1179263.90,'640','2021-07-27 12:54:29','607','2021-07-27 13:05:31',10,0),('5','184',213305,'MORNING','2021-07-22','2021-07-22 00:00:00',NULL,'640',921683.05,921683.05,'640','2021-07-27 14:27:11','607','2021-07-27 14:44:04',10,0),('5','184',213338,'MORNING','2021-07-23','2021-07-23 00:00:00',NULL,'640',1035401.05,1035401.05,'640','2021-07-27 16:07:06','607','2021-07-27 16:26:54',10,0),('5','184',213346,'MORNING','2021-07-24','2021-07-24 00:00:00',NULL,'640',1472914.10,1472914.10,'640','2021-07-27 16:38:30','607','2021-07-27 16:43:07',10,0),('5','184',213481,'MORNING','2021-07-25','2021-07-25 00:00:00',NULL,'640',1246933.80,1246933.80,'640','2021-07-28 11:40:00','607','2021-07-28 11:48:48',10,0),('5','184',213502,'MORNING','2021-07-26','2021-07-26 00:00:00',NULL,'640',869074.80,869074.80,'640','2021-07-28 11:55:52','607','2021-07-28 11:57:38',10,0),('5','184',213509,'MORNING','2021-07-27','2021-07-27 00:00:00',NULL,'640',1072632.45,1072632.45,'640','2021-07-28 12:15:02','607','2021-07-28 12:17:26',10,0),('5','184',213562,'MORNING','2021-07-28','2021-07-28 00:00:00',NULL,'640',1300562.10,1300562.10,'640','2021-07-28 22:21:21','607','2021-07-29 08:56:30',10,0),('5','184',213688,'MORNING','2021-07-29','2021-07-29 00:00:00',NULL,'640',1079326.10,1079326.10,'640','2021-07-29 22:57:53','607','2021-07-29 23:09:42',10,0),('5','184',213899,'MORNING','2021-07-30','2021-07-30 00:00:00',NULL,'640',1280529.75,1280529.75,'640','2021-07-30 23:21:46','607','2021-07-31 08:30:30',10,0),('5','184',214142,'MORNING','2021-07-31','2021-07-31 00:00:00',NULL,'640',1020346.00,1020346.00,'640','2021-08-02 17:04:56','607','2021-08-02 19:17:59',10,0),('5','184',214754,'MORNING','2021-08-01','2021-08-01 00:00:00',NULL,'640',1283693.65,1283693.65,'640','2021-08-02 20:48:03','607','2021-08-03 13:54:32',10,0),('5','184',214933,'MORNING','2021-08-02','2021-08-02 00:00:00',NULL,'640',1331949.05,1331949.05,'640','2021-08-03 14:27:53','607','2021-08-03 14:40:21',10,0),('5','184',214938,'MORNING','2021-08-03','2021-08-03 00:00:00',NULL,'640',966418.65,966418.65,'640','2021-08-03 22:48:15','607','2021-08-03 23:19:19',10,0),('5','184',215044,'MORNING','2021-08-04','2021-08-04 00:00:00',NULL,'640',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','184',215288,'MORNING','2021-08-04','2021-08-04 00:00:00',NULL,'640',1289075.45,1289075.45,'640','2021-08-05 09:49:41','607','2021-08-05 15:32:27',10,0),('5','184',215400,'MORNING','2021-08-05','2021-08-05 00:00:00',NULL,'640',1222117.25,1222117.25,'640','2021-08-05 22:26:31','607','2021-08-06 05:27:19',10,0),('5','184',215500,'MORNING','2021-08-06','2021-08-06 00:00:00',NULL,'640',1147950.10,1147950.10,'640','2021-08-08 19:43:43','607','2021-08-09 08:04:52',10,0),('5','184',216434,'MORNING','2021-08-07','2021-08-07 00:00:00',NULL,'640',1352435.05,1352435.05,'640','2021-08-12 10:06:06','607','2021-08-12 11:32:39',10,0),('5','184',216887,'MORNING','2021-08-08','2021-08-08 00:00:00',NULL,'640',1233153.70,1233153.70,'640','2021-08-12 17:39:40','607','2021-08-12 18:21:43',10,0),('5','184',216984,'MORNING','2021-08-09','2021-08-09 00:00:00',NULL,'640',887365.05,887365.05,'640','2021-08-12 18:41:02','607','2021-08-12 19:32:27',10,0),('5','184',216992,'MORNING','2021-08-10','2021-08-10 00:00:00',NULL,'640',1040955.30,1040955.30,'640','2021-08-12 19:38:52','607','2021-08-12 19:45:37',10,0),('5','184',216994,'MORNING','2021-08-11','2021-08-11 00:00:00',NULL,'640',961627.95,961627.95,'640','2021-08-12 19:52:18','607','2021-08-12 20:20:21',10,0),('5','184',216998,'MORNING','2021-08-12','2021-08-12 00:00:00',NULL,'640',989753.85,989753.85,'640','2021-08-12 22:25:47','607','2021-08-12 22:43:18',10,0),('5','184',217055,'MORNING','2021-08-13','2021-08-13 00:00:00',NULL,'640',930378.30,930378.30,'640','2021-08-13 22:28:07','607','2021-08-14 06:44:26',10,0),('5','184',217481,'MORNING','2021-08-14','2021-08-14 00:00:00',NULL,'640',1140292.50,1140292.50,'640','2021-08-14 22:34:56','607','2021-08-14 23:01:21',10,0),('5','184',217647,'MORNING','2021-08-15','2021-08-15 00:00:00',NULL,'640',863574.40,863574.40,'640','2021-08-15 22:13:20','607','2021-08-16 09:54:34',10,0),('5','184',217856,'MORNING','2021-08-16','2021-08-16 00:00:00',NULL,'640',689032.80,689032.80,'640','2021-08-16 21:36:06','607','2021-08-17 05:43:36',10,0),('5','184',218026,'MORNING','2021-08-17','2021-08-17 00:00:00',NULL,'640',859771.35,859771.35,'640','2021-08-17 22:18:50','607','2021-08-17 22:33:24',10,0),('5','184',218265,'MORNING','2021-08-18','2021-08-18 00:00:00',NULL,'640',750076.25,750076.25,'640','2021-08-19 10:04:10','607','2021-08-20 06:30:22',10,0),('5','184',218779,'MORNING','2021-08-19','2021-08-19 00:00:00',NULL,'640',1059503.40,1059503.40,'640','2021-08-20 10:54:09','607','2021-08-20 15:43:15',10,0),('5','184',218873,'MORNING','2021-08-20','2021-08-20 00:00:00',NULL,'640',1157826.45,1157826.45,'640','2021-08-20 22:18:13','607','2021-08-20 23:08:09',10,0),('5','184',219101,'MORNING','2021-08-21','2021-08-21 00:00:00',NULL,'640',1059730.40,1059730.40,'640','2021-08-21 22:11:25','607','2021-08-21 23:06:58',10,0),('5','184',219314,'MORNING','2021-08-22','2021-08-22 00:00:00',NULL,'640',1113112.30,1113112.30,'640','2021-08-22 22:11:47','607','2021-08-22 23:29:10',10,0),('5','184',219444,'MORNING','2021-08-23','2021-08-23 00:00:00',NULL,'640',1178217.15,1178217.15,'640','2021-08-23 22:01:58','607','2021-08-23 22:03:52',10,0),('5','184',219679,'MORNING','2021-08-24','2021-08-24 00:00:00',NULL,'640',833768.65,833768.65,'640','2021-08-24 21:50:21','607','2021-08-24 22:28:30',10,0),('5','184',219880,'MORNING','2021-08-25','2021-08-25 00:00:00',NULL,'640',1009943.30,1009943.30,'640','2021-08-25 22:04:51','607','2021-08-26 05:23:37',10,0),('5','184',220128,'MORNING','2021-08-26','2021-08-26 00:00:00',NULL,'640',1060768.00,1060768.00,'640','2021-08-27 11:56:09','607','2021-08-27 15:30:11',10,0),('5','184',220440,'MORNING','2021-08-27','2021-08-27 00:00:00',NULL,'640',949021.60,949021.60,'640','2021-08-27 22:15:22','607','2021-08-28 07:08:25',10,0),('5','184',220551,'MORNING','2021-08-28','2021-08-28 00:00:00',NULL,'640',737256.95,737256.95,'640','2021-08-28 21:52:37','607','2021-08-29 08:49:04',10,0),('5','184',220889,'MORNING','2021-08-29','2021-08-29 00:00:00',NULL,'640',1059014.85,1059014.85,'640','2021-08-29 22:03:42','607','2021-08-30 09:17:15',10,0),('5','184',220985,'MORNING','2021-08-30','2021-08-30 00:00:00',NULL,'640',799421.35,799421.35,'640','2021-08-30 22:03:55','607','2021-08-31 07:04:49',10,0),('5','184',221192,'MORNING','2021-08-31','2021-08-31 00:00:00',NULL,'640',1117945.55,1117945.55,'640','2021-08-31 22:06:57','607','2021-09-01 05:31:30',10,0),('5','184',221511,'MORNING','2021-09-01','2021-09-01 00:00:00',NULL,'640',1062222.15,1062222.15,'640','2021-09-01 22:14:34','607','2021-09-01 22:38:03',10,0),('5','184',221757,'MORNING','2021-09-02','2021-09-02 00:00:00',NULL,'640',812710.35,812710.35,'640','2021-09-02 22:21:28','607','2021-09-04 07:12:44',10,0),('5','184',222242,'MORNING','2021-09-03','2021-09-03 00:00:00',NULL,'640',1043957.05,1043957.05,'640','2021-09-04 19:01:10','607','2021-09-04 20:09:06',10,0),('5','184',222253,'MORNING','2021-09-04','2021-09-04 00:00:00',NULL,'640',720151.75,720151.75,'640','2021-09-04 22:04:48','607','2021-09-05 07:12:30',10,0),('5','184',222468,'MORNING','2021-09-05','2021-09-05 00:00:00',NULL,'640',915566.25,915566.25,'640','2021-09-05 21:51:19','607','2021-09-06 05:31:08',10,0),('5','184',222617,'MORNING','2021-09-06','2021-09-06 00:00:00',NULL,'640',669327.65,669327.65,'640','2021-09-06 21:13:04','607','2021-09-07 06:54:05',10,0),('5','184',222786,'MORNING','2021-09-07','2021-09-07 00:00:00',NULL,'640',558570.15,558570.15,'640','2021-09-07 21:29:07','607','2021-09-08 09:14:47',10,0),('5','184',223003,'MORNING','2021-09-08','2021-09-08 00:00:00',NULL,'640',686362.90,686362.90,'640','2021-09-08 21:57:34','607','2021-09-09 05:59:34',10,0),('5','184',223264,'MORNING','2021-09-09','2021-09-09 00:00:00',NULL,'640',700681.95,700681.95,'640','2021-09-09 22:07:29','607','2021-09-10 09:00:35',10,0),('5','184',223528,'MORNING','2021-09-10','2021-09-10 00:00:00',NULL,'640',770607.80,770607.80,'640','2021-09-11 07:05:22','607','2021-09-11 07:37:13',10,0),('5','184',223708,'MORNING','2021-09-11','2021-09-11 00:00:00',NULL,'640',913963.48,913963.48,'640','2021-09-11 21:51:07','607','2021-09-12 05:44:09',10,0),('5','184',223941,'MORNING','2021-09-12','2021-09-12 00:00:00',NULL,'640',622736.96,622736.96,'640','2021-09-12 20:59:35','607','2021-09-13 09:02:23',10,0),('5','184',224163,'MORNING','2021-09-13','2021-09-13 00:00:00',NULL,'640',565383.64,565383.64,'640','2021-09-13 19:55:09','607','2021-09-14 09:01:08',10,0),('5','184',224424,'MORNING','2021-09-14','2021-09-14 00:00:00',NULL,'640',551012.19,550665.63,'640','2021-09-15 06:42:09','607','2021-09-15 09:15:53',10,0),('5','184',224619,'MORNING','2021-09-15','2021-09-15 00:00:00',NULL,'640',864708.43,864708.43,'640','2021-09-15 22:06:26','607','2021-09-16 08:35:22',10,0),('5','184',224822,'MORNING','2021-09-16','2021-09-16 00:00:00',NULL,'640',898017.52,898017.52,'640','2021-09-17 11:37:55','607','2021-09-18 07:36:25',10,0),('5','184',225333,'MORNING','2021-09-17','2021-09-17 00:00:00',NULL,'640',945121.38,945121.38,'640','2021-09-18 09:47:28','607','2021-09-18 10:54:03',10,0),('5','184',225411,'MORNING','2021-09-18','2021-09-18 00:00:00',NULL,'640',982241.47,982241.47,'640','2021-09-18 21:49:23','607','2021-09-19 06:25:01',10,0),('5','184',225553,'MORNING','2021-09-19','2021-09-19 00:00:00',NULL,'640',951068.47,951068.47,'640','2021-09-19 21:58:51','607','2021-09-20 09:14:46',10,0),('5','184',225839,'MORNING','2021-09-20','2021-09-20 00:00:00',NULL,'640',1083890.38,1083890.38,'640','2021-09-21 06:03:12','607','2021-09-21 09:46:41',10,0),('5','184',226066,'MORNING','2021-09-21','2021-09-21 00:00:00',NULL,'640',927065.15,927065.15,'640','2021-09-21 21:53:41','607','2021-09-22 09:09:36',10,0),('5','184',226329,'MORNING','2021-09-22','2021-09-22 00:00:00',NULL,'640',964287.13,964287.13,'640','2021-09-22 21:54:38','607','2021-09-23 10:26:30',10,0),('5','184',226585,'MORNING','2021-09-23','2021-09-23 00:00:00',NULL,'640',872495.13,872495.13,'640','2021-09-24 11:53:58','607','2021-09-25 05:34:25',10,0),('5','184',227007,'MORNING','2021-09-24','2021-09-24 00:00:00',NULL,'640',908284.75,908284.75,'640','2021-09-25 09:09:09','607','2021-09-25 09:15:34',10,0),('5','184',227121,'MORNING','2021-09-25','2021-09-25 00:00:00',NULL,'640',824174.59,824174.59,'640','2021-09-25 22:00:04','607','2021-09-26 06:43:41',10,0),('5','184',227242,'MORNING','2021-09-26','2021-09-26 00:00:00',NULL,'640',947123.50,947123.50,'640','2021-09-26 21:57:45','607','2021-09-27 01:08:11',10,0),('5','184',227436,'MORNING','2021-09-27','2021-09-27 00:00:00',NULL,'640',942694.89,942694.89,'640','2021-09-27 21:52:28','607','2021-09-28 08:24:31',10,0),('5','184',227794,'MORNING','2021-09-28','2021-09-28 00:00:00',NULL,'640',1068896.85,1068896.85,'640','2021-09-28 22:12:18','607','2021-09-29 08:32:00',10,0),('5','184',227921,'MORNING','2021-09-29','2021-09-29 00:00:00',NULL,'640',1059960.21,1059960.21,'640','2021-09-29 22:03:44','607','2021-09-29 22:13:05',10,0),('5','184',229313,'MORNING','2021-09-30','2021-09-30 00:00:00',NULL,'640',831165.95,831165.95,'640','2021-10-05 13:56:43','607','2021-10-05 14:00:49',10,0),('5','184',230633,'MORNING','2021-10-01','2021-10-01 00:00:00',NULL,'640',762801.34,762801.34,'640','2021-10-11 11:57:57','607','2021-10-11 14:18:08',10,0),('5','184',230676,'MORNING','2021-10-02','2021-10-02 00:00:00',NULL,'640',626337.51,626337.51,'640','2021-10-11 14:23:10','607','2021-10-12 14:09:22',10,0),('5','184',230964,'MORNING','2021-10-03','2021-10-03 00:00:00',NULL,'640',303114.75,303114.75,'640','2021-10-12 14:20:05','607','2021-10-12 14:29:20',10,0),('5','184',230970,'MORNING','2021-10-04','2021-10-04 00:00:00',NULL,'640',188713.62,188713.62,'640','2021-10-12 14:35:33','607','2021-10-12 14:40:03',10,0),('5','184',230977,'MORNING','2021-10-05','2021-10-05 00:00:00',NULL,'640',44850.80,44850.80,'640','2021-10-12 14:47:31','607','2021-10-12 14:57:44',10,0),('5','184',230986,'MORNING','2021-10-06','2021-10-06 00:00:00',NULL,'640',44299.00,44299.00,'640','2021-10-13 12:17:25','607','2021-10-13 12:28:58',10,0),('5','184',231183,'MORNING','2021-10-07','2021-10-07 00:00:00',NULL,'640',31781.20,31781.20,'640','2021-10-13 12:31:23','607','2021-10-13 12:38:15',10,0),('5','184',231190,'MORNING','2021-10-08','2021-10-08 00:00:00',NULL,'640',30671.40,30671.40,'640','2021-10-13 12:47:14','607','2021-10-13 12:49:48',10,0),('5','184',231226,'MORNING','2021-10-09','2021-10-09 00:00:00',NULL,'640',185997.92,185997.92,'640','2021-10-13 13:49:15','607','2021-10-13 13:59:05',10,0),('5','184',231236,'MORNING','2021-10-10','2021-10-10 00:00:00',NULL,'640',925983.72,925983.72,'640','2021-10-13 14:08:13','607','2021-10-13 14:09:06',10,0),('5','184',231247,'MORNING','2021-10-11','2021-10-11 00:00:00',NULL,'640',1291466.56,1291466.56,'640','2021-10-13 14:19:29','607','2021-10-13 14:27:19',10,0),('5','184',231270,'MORNING','2021-10-12','2021-10-12 00:00:00',NULL,'640',627637.21,627637.21,'640','2021-10-13 14:49:15','607','2021-10-13 14:59:15',10,0),('5','184',231280,'MORNING','2021-10-13','2021-10-13 00:00:00',NULL,'640',985598.72,985598.72,'640','2021-10-13 21:44:15','607','2021-10-14 05:40:45',10,0),('5','184',231462,'MORNING','2021-10-14','2021-10-14 00:00:00',NULL,'640',1033214.57,1033214.57,'640','2021-10-15 05:51:47','607','2021-10-15 10:09:30',10,0),('5','184',231794,'MORNING','2021-10-15','2021-10-15 00:00:00',NULL,'640',973623.30,973623.30,'640','2021-10-15 21:46:56','607','2021-10-17 00:11:54',10,0),('5','184',232096,'MORNING','2021-10-16','2021-10-16 00:00:00',NULL,'640',1055013.51,1055013.51,'640','2021-10-17 05:48:44','607','2021-10-17 09:28:20',10,0),('5','184',232280,'MORNING','2021-10-17','2021-10-17 00:00:00',NULL,'640',1097153.50,1097153.50,'640','2021-10-17 21:40:45','607','2021-10-17 22:18:23',10,0),('5','184',232396,'MORNING','2021-10-18','2021-10-18 00:00:00',NULL,'640',1060494.94,1060494.94,'640','2021-10-19 05:39:45','607','2021-10-19 07:38:15',10,0),('5','184',232848,'MORNING','2021-10-19','2021-10-19 00:00:00',NULL,'640',419249.08,419249.08,'640','2021-10-20 06:20:25','607','2021-10-20 09:06:31',10,0),('5','184',232975,'MORNING','2021-10-20','2021-10-20 00:00:00',NULL,'640',212963.13,212963.13,'640','2021-10-20 13:04:02','607','2021-10-20 15:37:06',10,0),('5','184',233064,'EVENING','2021-10-20','2021-10-20 00:00:00',NULL,'640',54799.78,54799.78,'640','2021-10-21 05:45:39','607','2021-10-21 08:38:03',10,0),('5','184',233318,'MORNING','2021-10-21','2021-10-21 00:00:00',NULL,'640',55695.81,55695.81,'640','2021-10-21 20:08:42','607','2021-10-22 09:20:17',10,0),('5','184',233596,'MORNING','2021-10-22','2021-10-22 00:00:00',NULL,'640',54267.39,54267.39,'640','2021-10-23 05:43:55','607','2021-10-23 08:07:14',10,0),('5','184',233801,'MORNING','2021-10-23','2021-10-23 00:00:00',NULL,'640',35335.30,35335.30,'640','2021-10-23 19:59:04','607','2021-10-23 22:40:16',10,0),('5','184',234006,'MORNING','2021-10-24','2021-10-24 00:00:00',NULL,'640',73947.31,73947.31,'640','2021-10-24 19:03:59','607','2021-10-25 11:17:39',10,0),('5','184',234342,'MORNING','2021-10-25','2021-10-25 00:00:00',NULL,'640',34737.34,34737.34,'640','2021-10-26 07:30:00','607','2021-10-26 08:29:25',10,0),('5','184',234503,'MORNING','2021-10-26','2021-10-26 00:00:00',NULL,'640',63221.25,63221.25,'640','2021-10-27 14:56:08','607','2021-10-28 09:28:52',10,0),('5','184',234919,'MORNING','2021-10-27','2021-10-27 00:00:00',NULL,'640',35190.00,35190.00,'640','2021-10-28 09:33:26','607','2021-10-28 15:56:40',10,0),('5','184',235030,'MORNING','2021-10-28','2021-10-28 00:00:00',NULL,'640',36045.60,36045.60,'640','2021-10-29 08:10:01','607','2021-10-30 16:50:42',10,0),('5','184',236116,'MORNING','2021-10-29','2021-10-29 00:00:00',NULL,'640',0.00,0.00,'640','2021-11-02 10:53:33','607','2021-11-02 11:06:01',10,0),('5','184',236120,'MORNING','2021-10-30','2021-10-30 00:00:00',NULL,'640',1280337.75,1280337.75,'640','2021-11-02 11:36:33','607','2021-11-02 11:47:52',10,0),('5','184',236331,'MORNING','2021-10-31','2021-10-31 00:00:00',NULL,'640',761554.05,761554.05,'640','2021-11-04 10:58:40','607','2021-11-04 11:44:24',10,0),('5','184',236622,'MORNING','2021-11-01','2021-11-01 00:00:00',NULL,'640',648897.60,648897.60,'640','2021-11-04 12:12:14','607','2021-11-04 14:42:53',10,0),('5','184',236674,'MORNING','2021-11-02','2021-11-02 00:00:00',NULL,'640',1406354.85,1406354.85,'640','2021-11-04 15:18:21','607','2021-11-04 15:19:39',10,0),('5','184',236675,'MORNING','2021-11-03','2021-11-03 00:00:00',NULL,'640',1331448.45,1331448.45,'640','2021-11-04 16:19:10','607','2021-11-05 10:17:43',10,0),('5','184',236867,'MORNING','2021-11-04','2021-11-04 00:00:00',NULL,'640',2374204.50,2374204.50,'640','2021-11-06 09:56:16','600','2021-11-06 09:59:40',10,0),('5','184',237032,'MORNING','2021-11-05','2021-11-05 00:00:00',NULL,'640',2911385.85,2911385.85,'640','2021-11-06 10:07:19','600','2021-11-06 10:08:20',10,0),('5','184',237036,'MORNING','2021-11-06','2021-11-06 00:00:00',NULL,'640',849079.35,849079.35,'640','2021-11-07 06:19:23','600','2021-11-07 07:47:13',10,0),('5','184',237345,'MORNING','2021-11-07','2021-11-07 00:00:00',NULL,'640',201930.60,201930.60,'640','2021-11-07 20:35:13','600','2021-11-08 07:36:38',10,0),('5','184',237634,'MORNING','2021-11-08','2021-11-08 00:00:00',NULL,'640',138994.80,138994.80,'640','2021-11-09 06:54:44','600','2021-11-09 08:38:43',10,0),('5','184',237729,'MORNING','2021-11-09','2021-11-09 00:00:00',NULL,'640',0.00,0.00,'640','2021-11-10 05:42:56','600','2021-11-10 05:48:18',10,0),('5','184',237982,'MORNING','2021-11-10','2021-11-10 00:00:00',NULL,'640',2506409.70,2506409.70,'640','2021-11-11 13:49:08','600','2021-11-12 08:20:00',10,0),('5','184',238433,'MORNING','2021-11-11','2021-11-11 00:00:00',NULL,'640',2099792.40,2099792.40,'640','2021-11-12 08:49:55','600','2021-11-12 08:51:06',10,0),('5','184',238437,'MORNING','2021-11-12','2021-11-12 00:00:00',NULL,'640',1935845.85,1935845.85,'640','2021-11-13 06:12:22','600','2021-11-13 10:08:14',10,0),('5','184',238695,'MORNING','2021-11-13','2021-11-13 00:00:00',NULL,'640',2295497.10,2295497.10,'640','2021-11-14 05:52:06','600','2021-11-14 09:34:37',10,0),('5','184',239036,'MORNING','2021-11-14','2021-11-14 00:00:00',NULL,'640',2695390.20,2695390.20,'640','2021-11-15 08:03:33','600','2021-11-15 08:17:05',10,0),('5','184',239137,'MORNING','2021-11-15','2021-11-15 00:00:00',NULL,'640',711285.45,711285.45,'640','2021-11-15 21:11:09','600','2021-11-16 08:07:33',10,0),('5','184',239370,'MORNING','2021-11-16','2021-11-16 00:00:00',NULL,'640',445775.25,445775.25,'640','2021-11-17 05:57:29','600','2021-11-17 08:02:08',10,0),('5','184',239604,'MORNING','2021-11-17','2021-11-17 00:00:00',NULL,'640',664791.30,664791.30,'640','2021-11-18 05:43:19','600','2021-11-18 10:37:44',10,0),('5','184',239881,'MORNING','2021-11-18','2021-11-18 00:00:00',NULL,'640',1847041.80,1847041.80,'640','2021-11-18 22:11:15','600','2021-11-19 08:12:17',10,0),('5','184',240084,'MORNING','2021-11-19','2021-11-19 00:00:00',NULL,'640',1530047.25,1530047.25,'640','2021-11-20 05:24:54','600','2021-11-20 08:25:36',10,0),('5','184',240283,'MORNING','2021-11-20','2021-11-20 00:00:00',NULL,'640',1410583.35,1410583.35,'640','2021-11-21 16:55:40','600','2021-11-21 19:44:56',10,0),('5','184',240681,'MORNING','2021-11-21','2021-11-21 00:00:00',NULL,'640',1953303.45,1953303.45,'640','2021-11-22 05:40:02','600','2021-11-22 08:01:23',10,0),('5','184',240771,'MORNING','2021-11-22','2021-11-22 00:00:00',NULL,'640',1918450.05,1918450.05,'640','2021-11-23 09:34:07','600','2021-11-23 09:55:08',10,0),('5','184',241086,'MORNING','2021-11-23','2021-11-23 00:00:00',NULL,'640',2026725.45,2026725.45,'640','2021-11-24 05:29:10','600','2021-11-24 08:44:59',10,0),('5','184',241345,'MORNING','2021-11-24','2021-11-24 00:00:00',NULL,'640',2382964.05,2382964.05,'640','2021-11-25 05:41:32','600','2021-11-25 07:50:36',10,0),('5','184',241588,'MORNING','2021-11-25','2021-11-25 00:00:00',NULL,'640',2396169.60,2396169.60,'640','2021-11-26 05:46:20','600','2021-11-26 08:27:36',10,0),('5','184',241845,'MORNING','2021-11-26','2021-11-26 00:00:00',NULL,'640',482777.85,482777.85,'640','2021-11-26 22:16:30','600','2021-11-27 07:57:31',10,0),('5','184',242133,'MORNING','2021-11-27','2021-11-27 00:00:00',NULL,'640',1823032.20,1823032.20,'640','2021-11-28 06:03:32','600','2021-11-28 13:42:38',10,0),('5','184',242396,'MORNING','2021-11-28','2021-11-28 00:00:00',NULL,'640',2180581.05,2180581.05,'640','2021-11-28 21:33:01','600','2021-11-29 14:03:45',10,0),('5','184',242615,'MORNING','2021-11-29','2021-11-29 00:00:00',NULL,'640',2620536.60,2620536.60,'640','2021-11-30 15:53:05','600','2021-12-01 08:33:26',10,0),('5','184',243003,'MORNING','2021-11-30','2021-11-30 00:00:00',NULL,'640',749497.95,749497.95,'640','2021-12-01 11:43:46','600','2021-12-01 19:21:09',10,0),('5','184',243094,'MORNING','2021-12-01','2021-12-01 00:00:00',NULL,'640',1507206.45,1507206.45,'640','2021-12-02 16:20:06','600','2021-12-03 09:30:23',10,0),('5','184',243473,'MORNING','2021-12-02','2021-12-02 00:00:00',NULL,'640',2521713.00,2521713.00,'640','2021-12-03 11:52:52','600','2021-12-04 17:46:44',10,0),('5','184',243806,'MORNING','2021-12-03','2021-12-03 00:00:00',NULL,'640',2395593.30,2395593.30,'640','2021-12-04 22:12:25','600','2021-12-05 07:50:06',10,0),('5','184',243963,'MORNING','2021-12-04','2021-12-04 00:00:00',NULL,'640',2243087.25,2243087.25,'640','2021-12-05 14:12:47','600','2021-12-05 19:27:13',10,0),('5','184',244156,'MORNING','2021-12-05','2021-12-05 00:00:00',NULL,'640',2406518.85,2406518.85,'640','2021-12-06 16:31:43','600','2021-12-06 18:15:24',10,0),('5','184',244287,'MORNING','2021-12-06','2021-12-06 00:00:00',NULL,'640',3248201.10,3248201.10,'640','2021-12-07 05:50:01','600','2021-12-07 08:09:34',10,0),('5','184',244575,'MORNING','2021-12-07','2021-12-07 00:00:00',NULL,'640',1095253.05,1095253.05,'640','2021-12-08 08:16:19','600','2021-12-08 17:47:44',10,0),('5','184',244823,'MORNING','2021-12-08','2021-12-08 00:00:00',NULL,'640',1050429.60,1050429.60,'640','2021-12-10 16:25:01','600','2021-12-11 06:56:36',10,0),('5','184',245513,'MORNING','2021-12-09','2021-12-09 00:00:00',NULL,'640',218371.65,218371.65,'640','2021-12-12 09:32:13','600','2021-12-13 10:35:56',10,0),('5','184',245783,'MORNING','2021-12-10','2021-12-10 00:00:00',NULL,'640',230880.15,230880.15,'640','2021-12-13 12:40:39','600','2021-12-14 08:51:18',10,0),('5','184',246114,'MORNING','2021-12-11','2021-12-11 00:00:00',NULL,'640',174670.05,174670.05,'640','2021-12-14 15:48:49','600','2021-12-15 11:31:09',10,0),('5','184',246351,'MORNING','2021-12-12','2021-12-12 00:00:00',NULL,'640',0.00,0.00,'640','2021-12-15 14:04:50','600','2021-12-15 14:09:02',10,0),('5','184',246451,'MORNING','2021-12-13','2021-12-13 00:00:00',NULL,'640',294512.70,294512.70,'640','2021-12-16 05:59:48','600','2021-12-16 08:16:11',10,0),('5','184',246544,'MORNING','2021-12-14','2021-12-14 00:00:00',NULL,'640',2971686.30,2971686.30,'640','2021-12-16 11:50:32','600','2021-12-16 12:09:36',10,0),('5','184',246598,'MORNING','2021-12-15','2021-12-15 00:00:00',NULL,'640',2064418.35,2064418.35,'640','2021-12-16 14:06:52','600','2021-12-16 14:20:11',10,0),('5','184',246622,'MORNING','2021-12-16','2021-12-16 00:00:00',NULL,'640',544758.90,544758.90,'640','2021-12-16 20:03:24','600','2021-12-17 09:37:16',10,0),('5','184',246798,'MORNING','2021-12-17','2021-12-17 00:00:00',NULL,'640',472848.00,472848.00,'640','2021-12-17 18:57:52','600','2021-12-18 04:03:43',10,0),('5','184',247105,'MORNING','2021-12-18','2021-12-18 00:00:00',NULL,'640',2023495.50,2023495.50,'640','2021-12-19 06:12:53','600','2021-12-19 07:52:17',10,0),('5','184',247578,'MORNING','2021-12-19','2021-12-19 00:00:00',NULL,'640',334605.15,334605.15,'640','2021-12-20 15:05:27','600','2021-12-21 07:56:50',10,0),('5','184',247728,'MORNING','2021-12-20','2021-12-20 00:00:00',NULL,'640',187139.70,187139.70,'640','2021-12-21 09:13:06','600','2021-12-21 17:47:50',10,0),('5','184',248001,'MORNING','2021-12-21','2021-12-21 00:00:00',NULL,'640',2032326.45,2032326.45,'640','2021-12-23 11:19:55','600','2021-12-23 12:05:55',10,0),('5','184',248443,'MORNING','2021-12-22','2021-12-22 00:00:00',NULL,'640',271291.35,271291.35,'640','2021-12-24 07:44:22','600','2021-12-24 08:11:03',10,0),('5','184',248519,'MORNING','2021-12-23','2021-12-23 00:00:00',NULL,'640',181074.30,181074.30,'640','2021-12-24 13:40:19','600','2021-12-25 08:26:22',10,0),('5','184',248740,'MORNING','2021-12-24','2021-12-24 00:00:00',NULL,'640',1200195.15,1200195.15,'640','2021-12-25 12:25:48','600','2021-12-26 07:16:13',10,0),('5','184',249201,'MORNING','2021-12-25','2021-12-25 00:00:00',NULL,'640',1032504.00,1032504.00,'640','2021-12-27 09:54:26','600','2021-12-27 12:18:33',10,0),('5','184',249434,'MORNING','2021-12-26','2021-12-26 00:00:00',NULL,'640',1058065.80,1058065.80,'640','2021-12-28 14:42:38','600','2021-12-28 16:00:31',10,0),('5','184',249661,'MORNING','2021-12-27','2021-12-27 00:00:00',NULL,'640',750586.65,750586.65,'640','2021-12-29 09:38:39','600','2021-12-29 09:45:40',10,0),('5','184',249702,'MORNING','2021-12-28','2021-12-28 00:00:00',NULL,'640',538421.40,538421.40,'640','2021-12-29 10:32:01','600','2021-12-29 11:06:07',10,0),('5','184',249716,'MORNING','2021-12-29','2021-12-29 00:00:00',NULL,'640',344411.10,344411.10,'640','2021-12-30 10:04:01','600','2021-12-31 08:44:26',10,0),('5','184',250184,'MORNING','2021-12-30','2021-12-30 00:00:00',NULL,'640',95454.15,95454.15,'640','2021-12-31 09:58:34','600','2022-01-01 08:36:42',10,0),('5','184',250440,'MORNING','2021-12-31','2021-12-31 00:00:00',NULL,'640',0.00,0.00,'640','2022-01-01 12:33:00','600','2022-01-01 16:02:16',10,0),('5','184',250493,'MORNING','2022-01-01','2022-01-01 00:00:00',NULL,'640',1464795.75,1464795.75,'640','2022-01-01 17:02:04','600','2022-01-02 09:29:44',10,0),('5','184',250713,'MORNING','2022-01-02','2022-01-02 00:00:00',NULL,'640',1556682.60,1556682.60,'640','2022-01-03 08:44:37','600','2022-01-03 10:15:39',10,0),('5','184',251130,'MORNING','2022-01-03','2022-01-03 00:00:00',NULL,'640',1751852.85,1751852.85,'640','2022-01-04 12:07:48','600','2022-01-05 11:36:26',10,0),('5','184',251375,'MORNING','2022-01-04','2022-01-04 00:00:00',NULL,'640',2591329.95,2591329.95,'640','2022-01-05 19:30:16','600','2022-01-06 12:22:34',10,0),('5','184',251635,'MORNING','2022-01-05','2022-01-05 00:00:00',NULL,'640',2693283.45,2693283.45,'640','2022-01-06 13:08:04','600','2022-01-07 11:44:49',10,0),('5','184',251857,'MORNING','2022-01-06','2022-01-06 00:00:00',NULL,'640',1753775.10,1753775.10,'640','2022-01-07 12:26:12','600','2022-01-07 14:55:05',10,0),('5','184',252091,'MORNING','2022-01-07','2022-01-07 00:00:00',NULL,'640',693490.05,693490.05,'640','2022-01-08 12:19:38','600','2022-01-08 13:23:27',10,0),('5','184',252374,'MORNING','2022-01-08','2022-01-08 00:00:00',NULL,'640',332925.45,332925.45,'640','2022-01-09 16:06:43','600','2022-01-10 09:41:24',10,0),('5','184',252602,'MORNING','2022-01-09','2022-01-09 00:00:00',NULL,'640',209391.60,209391.60,'640','2022-01-10 13:50:26','600','2022-01-10 20:36:38',10,0),('5','184',252821,'MORNING','2022-01-10','2022-01-10 00:00:00',NULL,'640',556488.90,556488.90,'640','2022-01-11 12:47:30','600','2022-01-11 13:37:19',10,0),('5','184',253047,'MORNING','2022-01-11','2022-01-11 00:00:00',NULL,'640',1831036.35,1831036.35,'640','2022-01-12 10:10:27','600','2022-01-12 10:17:19',10,0),('5','184',253184,'MORNING','2022-01-11','2022-01-11 00:00:00',NULL,'640',1823855.55,1823855.55,'640','2022-01-12 22:25:25','600','2022-01-13 09:13:03',10,0),('5','184',253380,'MORNING','2022-01-13','2022-01-13 00:00:00',NULL,'640',1231720.05,1231720.05,'640','2022-01-14 09:59:54','600','2022-01-14 22:09:20',10,0),('5','184',254104,'MORNING','2022-01-14','2022-01-14 00:00:00',NULL,'640',770625.90,770625.90,'640','2022-01-16 16:19:35','600','2022-01-16 16:50:12',10,0),('5','184',254120,'MORNING','2022-01-15','2022-01-15 00:00:00',NULL,'640',393709.80,393709.80,'640','2022-01-16 17:07:34','600','2022-01-16 17:08:39',10,0),('5','184',254129,'MORNING','2022-01-16','2022-01-16 00:00:00',NULL,'640',1239447.00,1239447.00,'640','2022-01-17 13:54:00','600','2022-01-17 13:55:55',10,0),('5','184',254399,'MORNING','2022-01-17','2022-01-17 00:00:00',NULL,'640',819743.10,819743.10,'640','2022-01-17 20:42:03','600','2022-01-18 13:24:29',10,0),('5','184',254698,'MORNING','2022-01-18','2022-01-18 00:00:00',NULL,'640',518169.30,518169.30,'640','2022-01-19 07:11:29','600','2022-01-19 09:47:53',10,0),('5','184',254808,'MORNING','2022-01-19','2022-01-19 00:00:00',NULL,'640',177997.05,177997.05,'640','2022-01-20 13:11:51','600','2022-01-20 13:21:14',10,0),('5','184',255283,'MORNING','2022-01-20','2022-01-20 00:00:00',NULL,'640',0.00,0.00,'640','2022-01-21 11:19:34','600','2022-01-22 09:23:37',10,0),('5','184',255568,'MORNING','2022-01-21','2022-01-21 00:00:00',NULL,'640',0.00,0.00,'640','2022-01-22 12:23:18','600','2022-01-23 09:04:43',10,0),('5','184',255807,'MORNING','2022-01-22','2022-01-22 00:00:00',NULL,'640',284306.55,284306.55,'640','2022-01-23 12:37:38','600','2022-01-23 16:29:27',10,0),('5','184',255938,'MORNING','2022-01-23','2022-01-23 00:00:00',NULL,'640',1776152.40,1776152.40,'640','2022-01-24 09:44:40','600','2022-01-25 09:12:05',10,0),('5','184',256270,'MORNING','2022-01-24','2022-01-24 00:00:00',NULL,'640',1859477.40,1859477.40,'640','2022-01-25 09:28:57','600','2022-01-26 09:05:14',10,0),('5','184',256665,'MORNING','2022-01-25','2022-01-25 00:00:00',NULL,'640',1266445.95,1266445.95,'640','2022-01-26 19:09:30','600','2022-01-27 10:05:23',10,0),('5','184',256898,'MORNING','2022-01-26','2022-01-26 00:00:00',NULL,'640',1252825.20,1252825.20,'640','2022-01-27 19:09:14','600','2022-01-28 10:48:49',10,0),('5','184',257101,'MORNING','2022-01-27','2022-01-27 00:00:00',NULL,'640',796524.30,796524.30,'640','2022-01-28 14:31:56','600','2022-01-28 15:18:12',10,0),('5','184',257102,'MORNING','2022-01-28','2022-01-28 00:00:00',NULL,'640',331212.75,331212.75,'640','2022-02-01 10:58:23','600','2022-02-01 10:59:46',10,0),('5','184',257103,'MORNING','2022-01-29','2022-01-29 00:00:00',NULL,'640',261112.50,261112.50,'640','2022-02-01 11:03:33','600','2022-02-01 11:05:10',10,0),('5','184',257104,'MORNING','2022-01-30','2022-01-30 00:00:00',NULL,'640',1479886.65,1479886.65,'640','2022-02-01 11:18:14','600','2022-02-01 11:29:28',10,0),('5','184',257105,'MORNING','2022-01-31','2022-01-31 00:00:00',NULL,'640',1739524.05,1739524.05,'640','2022-02-01 11:33:03','600','2022-02-01 14:55:15',10,0),('5','184',257106,'MORNING','2022-02-01','2022-02-01 00:00:00',NULL,'640',1664473.80,1664473.80,'640','2022-02-01 18:26:35','600','2022-02-01 19:28:41',10,0),('5','184',257107,'MORNING','2022-02-02','2022-02-02 00:00:00',NULL,'640',872013.45,872013.45,'640','2022-02-03 13:01:27','600','2022-02-03 14:00:23',10,0),('5','184',257108,'MORNING','2022-02-03','2022-02-03 00:00:00',NULL,'640',426929.25,426929.25,'640','2022-02-03 18:59:08','600','2022-02-04 09:25:54',10,0),('5','184',257109,'MORNING','2022-02-04','2022-02-04 00:00:00',NULL,'640',179364.90,179364.90,'640','2022-02-05 16:06:46','600','2022-02-06 05:24:50',10,0),('5','184',257110,'MORNING','2022-02-05','2022-02-05 00:00:00',NULL,'640',344978.70,344978.70,'640','2022-02-06 13:55:27','600','2022-02-06 15:11:43',10,0),('5','184',257111,'MORNING','2022-02-06','2022-02-06 00:00:00',NULL,'640',1462383.45,1462383.45,'640','2022-02-07 11:25:34','600','2022-02-07 11:26:23',10,0),('5','184',257112,'MORNING','2022-02-07','2022-02-07 00:00:00',NULL,'640',1707094.95,1707094.95,'640','2022-02-08 10:33:06','600','2022-02-08 12:28:14',10,0),('5','184',257113,'MORNING','2022-02-08','2022-02-08 00:00:00',NULL,'640',1353646.80,1353646.80,'640','2022-02-09 10:21:42','600','2022-02-09 10:57:48',10,0),('5','184',257114,'MORNING','2022-02-09','2022-02-09 00:00:00',NULL,'640',690584.40,690584.40,'640','2022-02-10 10:48:20','600','2022-02-10 12:41:02',10,0),('5','184',257115,'MORNING','2022-02-10','2022-02-10 00:00:00',NULL,'640',704320.65,704320.65,'640','2022-02-11 09:29:02','600','2022-02-11 09:43:47',10,0),('5','184',257116,'MORNING','2022-02-11','2022-02-11 00:00:00',NULL,'640',337583.40,337583.40,'640','2022-02-12 15:16:07','600','2022-02-12 15:39:33',10,0),('5','184',257117,'MORNING','2022-02-12','2022-02-12 00:00:00',NULL,'640',0.00,0.00,'640','2022-02-14 14:51:18','600','2022-02-14 16:39:54',10,0),('5','184',257118,'MORNING','2022-02-13','2022-02-13 00:00:00',NULL,'640',0.00,0.00,'640','2022-02-15 09:54:35','600','2022-02-15 09:55:26',10,0),('5','184',257119,'MORNING','2022-02-14','2022-02-14 00:00:00',NULL,'640',0.00,0.00,'640','2022-02-15 09:59:31','600','2022-02-15 11:26:17',10,0),('5','184',257120,'MORNING','2022-02-15','2022-02-15 00:00:00',NULL,'640',0.00,0.00,'640','2022-02-16 10:05:16','600','2022-02-17 08:58:07',10,0),('5','184',257121,'MORNING','2022-02-16','2022-02-16 00:00:00',NULL,'640',919114.35,919114.35,'640','2022-02-17 09:28:55','600','2022-02-17 09:30:49',10,0),('5','184',257122,'MORNING','2022-02-17','2022-02-17 00:00:00',NULL,'640',528457.05,528457.05,'640','2022-02-17 22:10:08','600','2022-02-18 09:24:24',10,0),('5','184',257123,'MORNING','2022-02-18','2022-02-18 00:00:00',NULL,'640',526861.50,526861.50,'640','2022-02-18 18:26:33','600','2022-02-19 11:49:57',10,0),('5','184',257124,'MORNING','2022-02-19','2022-02-19 00:00:00',NULL,'640',330452.10,330452.10,'640','2022-02-20 14:16:14','600','2022-02-20 14:59:57',10,0),('5','184',257125,'MORNING','2022-02-20','2022-02-20 00:00:00',NULL,'640',329722.80,329722.80,'640','2022-02-21 12:15:40','600','2022-02-21 14:21:58',10,0),('5','184',257126,'MORNING','2022-02-21','2022-02-21 00:00:00',NULL,'640',0.00,0.00,'446','2022-05-31 13:53:52','600','2022-05-31 13:54:12',10,0),('5','184',257127,'DAILY','2022-05-30','2022-05-31 13:55:46','2022-06-01 13:55:46','446',3409226.70,3409226.70,'446','2022-05-31 14:01:56','600','2022-05-31 14:04:00',10,0),('5','184',257128,'DAILY','2022-05-31','2022-05-31 14:04:49','2022-06-01 14:04:49','446',58334.10,58334.10,'446','2022-05-31 14:10:01','600','2022-05-31 14:10:59',10,0),('5','184',257129,'DAILY','2022-06-01','2022-06-01 12:18:06','2022-06-02 12:18:06','600',21926.85,21926.85,'600','2022-06-01 12:25:14','600','2022-06-01 12:25:51',10,0),('5','184',257130,'daily','2022-06-01','2022-06-01 13:27:24','2022-06-02 13:27:24','640',840014.00,840014.00,'600','2022-06-01 14:19:27','600','2022-06-01 14:20:48',10,0),('5','184',257131,'DAILY','2022-05-30','2022-06-01 14:44:30','2022-06-02 14:44:30','640',445500.00,445500.00,'640','2022-06-01 14:47:32','600','2022-06-01 14:55:44',10,0),('5','184',257132,'DAILY','2022-06-02','2022-06-02 12:15:55','2022-06-03 12:15:55','640',165422.85,165422.85,'640','2022-06-02 12:25:08','606','2022-06-02 14:11:19',10,0),('5','184',257133,'daily shift','2022-06-02','2022-06-02 14:14:14','2022-06-03 14:14:14','640',0.00,0.00,'640','2022-06-02 14:14:51','606','2022-06-02 14:15:49',10,0),('5','184',257134,'daily shift','2022-06-02','2022-06-02 14:20:28','2022-06-03 14:20:28','640',8126.25,8126.25,'640','2022-06-02 14:49:49','600','2022-06-05 09:13:15',10,0),('5','184',257135,'Full time shift','2022-06-24','2022-06-29 13:53:03','2022-06-30 13:53:03','640',678996.45,678996.45,'640','2022-06-29 13:56:52','600','2022-06-29 13:59:59',10,0),('5','184',257136,'Full time shift','2022-05-26','2022-06-29 14:03:51','2022-06-30 14:03:51','640',0.00,0.00,'600','2022-06-29 14:09:24','600','2022-06-29 14:09:37',10,0),('5','184',257137,'Full time shift','2022-05-26','2022-06-29 14:18:20','2022-06-30 14:18:20','640',994146.45,994146.45,'640','2022-06-29 14:24:19','600','2022-06-29 14:26:53',10,0),('5','184',257138,'Full time shift','2022-05-27','2022-06-29 14:28:50','2022-06-30 14:28:50','640',981543.75,981543.75,'640','2022-06-29 14:32:31','600','2022-06-29 14:33:35',10,0),('5','184',257139,'Full time shift','2022-05-28','2022-06-29 14:39:52','2022-06-30 14:39:52','640',722835.30,722835.30,'640','2022-06-29 14:44:05','600','2022-06-29 14:45:48',10,0),('5','184',257140,'Full time shift','2022-05-30','2022-06-29 14:48:21','2022-06-30 14:48:21','640',1064098.20,1064098.20,'640','2022-06-29 14:57:43','600','2022-06-29 18:28:42',10,0),('5','184',257141,'Full time shift','2022-05-31','2022-06-29 18:39:14','2022-06-30 18:39:14','640',659534.70,659534.70,'640','2022-06-29 18:53:36','600','2022-06-29 19:21:14',10,0),('5','184',257142,'Full time shift','2022-06-01','2022-06-30 04:43:19','2022-07-01 04:43:19','640',673284.15,673284.15,'640','2022-06-30 04:48:23','600','2022-06-30 08:33:24',10,0),('5','184',257143,'Full time shift','2022-06-02','2022-06-30 10:21:07','2022-07-01 10:21:07','640',674487.00,674487.00,'640','2022-06-30 10:58:29','600','2022-06-30 11:31:30',10,0),('5','184',257144,'Full time shift','2022-06-05','2022-06-30 12:20:28','2022-07-01 12:20:28','640',0.00,0.00,'640','2022-06-30 12:59:01','600','2022-06-30 20:13:41',10,0),('5','184',257145,'Full time shift','2022-06-06','2022-06-30 21:09:10','2022-07-01 21:09:10','640',0.00,0.00,'640','2022-07-03 04:38:57','600','2022-07-03 09:36:28',10,0),('5','184',257146,'Full time shift','2022-06-06','2022-07-04 15:05:52','2022-07-05 15:05:52','640',1288555.95,1288555.95,'640','2022-07-04 15:09:39','600','2022-07-04 15:14:03',10,0),('5','184',257147,'Full time shift','2022-06-07','2022-07-04 15:21:04','2022-07-05 15:21:04','640',681128.25,681128.25,'640','2022-07-04 15:23:39','600','2022-07-04 15:32:35',10,0),('5','184',257148,'Full time shift','2022-06-10','2022-07-04 15:36:26','2022-07-05 15:36:26','640',155128.05,155128.05,'640','2022-07-04 15:42:51','600','2022-07-04 15:44:23',10,0),('5','184',257149,'Full time shift','2022-06-17','2022-07-04 15:47:42','2022-07-05 15:47:42','640',443889.60,443889.60,'640','2022-07-04 15:51:46','600','2022-07-04 15:52:52',10,0),('5','184',257150,'Full time shift','2022-06-18','2022-07-04 15:55:28','2022-07-05 15:55:28','640',972244.35,972244.35,'640','2022-07-04 15:58:04','600','2022-07-04 16:14:37',10,0),('5','184',257151,'Full time shift','2022-06-19','2022-07-04 16:23:42','2022-07-05 16:23:42','640',1154930.70,1154930.70,'640','2022-07-04 16:27:04','600','2022-07-04 16:28:18',10,0),('5','184',257152,'Full time shift','2022-06-20','2022-07-04 16:31:50','2022-07-05 16:31:50','640',917947.80,917947.80,'640','2022-07-04 16:34:46','600','2022-07-04 16:36:13',10,0),('5','184',257153,'Full time shift','2022-06-21','2022-07-04 16:46:44','2022-07-05 16:46:44','640',503603.10,503603.10,'640','2022-07-04 22:22:58','600','2022-07-05 09:16:32',10,0),('5','184',257154,'Full time shift','2022-06-22','2022-07-05 11:06:08','2022-07-06 11:06:08','640',0.00,0.00,'640','2022-07-06 07:35:07','600','2022-07-06 09:14:12',10,0),('5','184',257155,'Full time shift','2022-06-23','2022-07-06 09:20:17','2022-07-07 09:20:17','640',0.00,0.00,'640','2022-07-06 09:35:51','600','2022-07-07 10:38:15',10,0),('5','184',257156,'Full time shift','2022-06-23','2022-07-12 12:47:19','2022-07-13 12:47:19','640',0.00,0.00,'640','2022-07-12 16:37:06','600','2022-07-13 09:31:55',10,0),('5','184',257157,'Daily','2022-07-14','2022-07-19 12:01:28','2022-07-20 12:01:28','640',279068.80,248899.20,'640','2022-07-19 12:04:57','600','2022-07-19 12:29:01',10,0),('5','184',257158,'Daily','2022-07-15','2022-07-19 13:29:09','2022-07-20 13:29:09','640',872310.15,778006.35,'640','2022-07-19 13:31:04','600','2022-07-19 13:59:37',10,0),('5','184',257159,'Daily','2022-07-16','2022-07-19 14:19:03','2022-07-20 14:19:03','640',905162.45,807307.05,'640','2022-07-19 14:21:40','600','2022-07-19 15:26:50',10,0),('5','184',257160,'Daily','2022-07-17','2022-07-19 15:58:15','2022-07-20 15:58:15','640',944399.10,842301.90,'640','2022-07-19 16:03:01','600','2022-07-20 09:09:24',10,0),('5','184',257161,'Daily','2022-07-18','2022-07-20 10:36:54','2022-07-21 10:36:54','640',1074537.35,958371.15,'640','2022-07-20 10:41:37','600','2022-07-20 10:48:52',10,0),('5','184',257162,'Daily','2022-07-19','2022-07-20 10:50:41','2022-07-21 10:50:41','640',870917.10,776763.90,'640','2022-07-20 10:57:09','600','2022-07-20 11:00:36',10,0),('5','184',257163,'Daily','2022-07-20','2022-07-20 12:05:32','2022-07-21 12:05:32','640',945392.55,843187.95,'640','2022-07-21 06:13:20','600','2022-07-21 08:58:38',10,0),('5','184',257164,'Daily','2022-07-21','2022-07-21 11:05:30','2022-07-22 11:05:30','640',725712.45,647257.05,'640','2022-07-22 03:14:51','600','2022-07-22 09:42:56',10,0),('5','184',257165,'Daily','2022-07-22','2022-07-22 23:20:39','2022-07-23 23:20:39','640',2051220.80,1829467.20,'640','2022-07-22 23:23:06','600','2022-07-23 10:34:10',10,0),('5','184',257166,'Daily','2022-07-23','2022-07-24 05:54:35','2022-07-25 05:54:35','640',1595362.30,1422890.70,'640','2022-07-25 11:20:33','600','2022-07-25 11:21:39',10,0),('5','184',257167,'Daily','2022-07-24','2022-07-25 11:27:06','2022-07-26 11:27:06','640',1885614.35,1681764.15,'640','2022-07-25 11:31:55','600','2022-07-25 11:32:46',10,0),('5','184',257168,'Daily','2022-07-25','2022-07-25 11:46:10','2022-07-26 11:46:10','640',1232379.35,1099149.15,'640','2022-07-26 05:58:23','600','2022-07-26 09:20:12',10,0),('5','184',257169,'Daily','2022-07-26','2022-07-26 12:25:29','2022-07-27 12:25:29','640',763128.70,680628.30,'640','2022-07-27 06:13:37','600','2022-07-27 09:16:22',10,0),('5','184',257170,'Daily','2022-07-27','2022-07-27 10:49:59','2022-07-28 10:49:59','640',656920.20,585901.80,'640','2022-07-28 07:15:29','600','2022-07-28 09:23:37',10,0),('5','184',257171,'Daily','2022-07-28','2022-07-28 23:19:22','2022-07-29 23:19:22','640',451982.75,403119.75,'640','2022-07-29 06:17:35','600','2022-07-29 09:15:36',10,0),('5','184',257172,'Daily','2022-07-29','2022-07-29 12:52:00','2022-07-30 12:52:00','640',363323.35,324045.15,'640','2022-07-30 06:09:54','600','2022-07-30 20:08:17',10,0),('5','184',257173,'Daily','2022-07-30','2022-07-31 17:26:01','2022-08-01 17:26:01','640',0.00,0.00,'640','2022-07-31 17:27:15','600','2022-08-01 08:23:14',10,0),('5','184',257174,'Daily','2022-08-02','2022-08-02 06:26:04','2022-08-03 06:26:04','640',0.00,0.00,'640','2022-08-03 06:35:37','600','2022-08-03 10:05:42',10,0),('5','184',257175,'Daily','2022-08-04','2022-08-04 09:25:41','2022-08-05 09:25:41','640',0.00,0.00,'640','2022-08-06 05:29:27','600','2022-08-06 08:58:06',10,0),('5','184',257176,'DAILY','2022-08-05','2022-08-06 11:43:01','2022-08-07 11:43:01','640',1941079.20,1731232.80,'640','2022-09-03 09:56:05','600','2022-09-03 10:06:27',10,0),('5','184',257177,'DAILY','2022-08-06','2022-09-03 10:09:21','2022-09-04 10:09:21','640',1199667.65,1069973.85,'640','2022-09-03 12:12:01','600','2022-09-03 12:14:02',10,0),('5','184',257178,'DAILLY','2022-08-07','2022-09-03 12:15:48','2022-09-04 12:15:48','640',957861.55,854308.95,'640','2022-09-03 12:17:14','600','2022-09-03 12:19:00',10,0),('5','184',257179,'DAILLY','2022-08-08','2022-09-03 12:21:24','2022-09-04 12:21:24','640',1092828.30,974684.70,'640','2022-09-03 12:22:59','600','2022-09-03 13:37:36',10,0),('5','184',257180,'DAILLY','2022-08-09','2022-09-03 14:19:17','2022-09-04 14:19:17','640',1363651.65,1216229.85,'640','2022-09-03 14:21:35','600','2022-09-03 15:03:22',10,0),('5','184',257181,'DAILLY','2022-08-10','2022-09-03 15:11:20','2022-09-04 15:11:20','640',837746.60,747179.40,'640','2022-09-03 15:12:32','600','2022-09-03 16:57:19',10,0),('5','184',257182,'DAILLY','2022-08-11','2022-09-03 17:20:15','2022-09-04 17:20:15','640',1362704.45,1215385.05,'640','2022-09-03 17:53:30','600','2022-09-03 20:18:11',10,0),('5','184',257183,'DAILLY','2022-08-12','2022-09-04 11:20:51','2022-09-05 11:20:51','640',1127952.40,1006011.60,'640','2022-09-04 11:23:15','600','2022-09-04 11:33:15',10,0),('5','184',257184,'DAILLY','2022-08-13','2022-09-04 11:35:47','2022-09-05 11:35:47','640',0.00,0.00,'600','2022-09-04 12:13:07','600','2022-09-04 12:13:47',10,0),('5','184',257185,'DAILLY','2022-08-13','2022-09-04 12:27:57','2022-09-05 12:27:57','640',1260377.25,1124120.25,'640','2022-09-04 13:44:04','600','2022-09-04 13:44:48',10,0),('5','184',257186,'DAILLY','2022-08-14','2022-09-04 13:45:54','2022-09-05 13:45:54','640',1635079.95,1458314.55,'640','2022-09-04 13:48:15','600','2022-09-04 13:49:05',10,0),('5','184',257187,'DAILLY','2022-08-15','2022-09-04 13:54:43','2022-09-05 13:54:43','640',1467136.95,1308527.55,'640','2022-09-04 13:58:13','600','2022-09-04 14:06:57',10,0),('5','184',257188,'DAILLY','2022-08-16','2022-09-04 14:10:10','2022-09-05 14:10:10','640',1384758.30,1235054.70,'640','2022-09-04 14:13:56','600','2022-09-04 14:32:03',10,0),('5','184',257189,'DAILLY','2022-08-17','2022-09-04 14:35:03','2022-09-05 14:35:03','640',1162515.95,1036838.55,'640','2022-09-04 14:55:19','600','2022-09-04 15:09:01',10,0),('5','184',257190,'DAILLY','2022-08-18','2022-09-04 15:17:49','2022-09-05 15:17:49','640',802054.55,715345.95,'640','2022-09-04 15:19:32','600','2022-09-04 16:00:04',10,0),('5','184',257191,'DAILLY','2022-08-19','2022-09-04 17:28:11','2022-09-05 17:28:11','640',1068920.75,953361.75,'640','2022-09-04 17:30:07','600','2022-09-04 17:38:44',10,0),('5','184',257192,'DAILLY','2022-08-20','2022-09-04 17:39:37','2022-09-05 17:39:37','640',992639.70,885327.30,'640','2022-09-04 17:41:45','600','2022-09-04 17:45:23',10,0),('5','184',257193,'DAILLY','2022-08-21','2022-09-04 17:46:12','2022-09-05 17:46:12','640',1136023.95,1013210.55,'640','2022-09-04 17:47:35','600','2022-09-04 17:48:11',10,0),('5','184',257194,'DAILLY','2022-08-21','2022-09-04 17:49:29','2022-09-05 17:49:29','640',1399007.00,1247763.00,'640','2022-09-04 17:51:08','600','2022-09-04 17:55:56',10,0),('5','184',257195,'DAILLY','2022-08-23','2022-09-04 17:57:17','2022-09-05 17:57:17','640',1329694.90,1185944.10,'640','2022-09-04 17:59:11','600','2022-09-04 17:59:50',10,0),('5','184',257196,'DAILLY','2022-08-24','2022-09-04 18:00:57','2022-09-05 18:00:57','640',1730390.10,1543320.90,'640','2022-09-04 20:49:59','600','2022-09-04 21:12:37',10,0),('5','184',257197,'DAILY','2022-08-25','2022-09-04 21:56:14','2022-09-05 21:56:14','640',1904887.65,1698953.85,'640','2022-09-04 21:58:26','600','2022-09-05 10:23:59',10,0),('5','184',257198,'DAILLY','2022-08-26','2022-09-05 11:07:17','2022-09-06 11:07:17','640',1669008.95,1488575.55,'640','2022-09-05 11:09:02','600','2022-09-05 11:16:00',10,0),('5','184',257199,'DAILLY','2022-08-27','2022-09-05 11:20:31','2022-09-06 11:20:31','640',2840502.95,2533421.55,'640','2022-09-05 11:23:18','600','2022-09-05 11:34:52',10,0),('5','184',257200,'DAILLY','2022-08-28','2022-09-05 11:46:26','2022-09-06 11:46:26','640',1343475.55,1198234.95,'640','2022-09-05 12:03:11','600','2022-09-05 12:04:07',10,0),('5','184',257201,'DAILLY','2022-08-29','2022-09-05 12:05:09','2022-09-06 12:05:09','640',1274729.55,1136920.95,'640','2022-09-05 12:06:43','600','2022-09-05 12:08:42',10,0),('5','184',257202,'DAILLY','2022-08-30','2022-09-05 12:09:31','2022-09-06 12:09:31','640',1525027.15,1360159.35,'640','2022-09-05 12:12:27','600','2022-09-05 12:13:26',10,0),('5','184',257203,'DAILLY','2022-08-31','2022-09-05 12:16:11','2022-09-06 12:16:11','640',1697983.65,1514417.85,'640','2022-09-05 12:17:41','600','2022-09-05 12:18:22',10,0),('5','184',257204,'DAILLY','2022-09-01','2022-09-05 12:19:38','2022-09-06 12:19:38','640',594926.70,530610.30,'640','2022-09-05 12:21:14','600','2022-09-05 12:30:12',10,0),('5','184',257205,'DAILLY','2022-09-02','2022-09-05 13:12:56','2022-09-06 13:12:56','640',2133040.75,1902441.75,'640','2022-09-05 13:16:09','600','2022-09-05 13:48:26',10,0),('5','184',257206,'DAILLY','2022-09-03','2022-09-05 14:55:56','2022-09-06 14:55:56','640',1666620.60,1486445.40,'640','2022-09-05 15:41:33','600','2022-09-05 16:05:41',10,0),('5','184',257207,'DAILY','2022-09-04','2022-09-05 17:26:14','2022-09-06 17:26:14','640',1734708.00,1547172.00,'640','2022-09-06 09:50:23','600','2022-09-06 10:21:55',10,0),('5','184',257208,'DAILLY','2022-09-05','2022-09-06 10:43:04','2022-09-07 10:43:04','640',1140617.50,1017307.50,'640','2022-09-06 10:45:07','600','2022-09-06 11:07:42',10,0),('5','184',257209,'DAILLY','2022-09-06','2022-09-06 11:30:20','2022-09-07 11:30:20','640',651631.05,581184.45,'640','2022-09-08 10:09:00','600','2022-09-08 10:10:24',10,0),('5','184',257210,'DAILLY','2022-09-07','2022-09-08 10:11:11','2022-09-09 10:11:11','640',613646.85,547306.65,'640','2022-09-08 10:14:46','600','2022-09-08 10:31:54',10,0),('5','184',257211,'DAILLY','2022-09-08','2022-09-08 10:37:04','2022-09-09 10:37:04','640',0.00,0.00,'640','2022-09-08 20:42:38','600','2022-09-09 09:15:24',10,0),('5','184',257212,'DAILY','2022-09-09','2022-09-09 10:38:41','2022-09-10 10:38:41','640',0.00,0.00,'640','2022-09-09 14:12:25','600','2022-09-10 09:41:06',10,0),('5','184',257213,'DAILY','2022-09-10','2022-09-10 11:43:47','2022-09-11 11:43:47','640',0.00,0.00,'640','2022-09-10 22:11:16','600','2022-09-11 05:54:18',10,0),('5','184',257214,'DAILY','2022-09-11','2022-09-11 08:11:29','2022-09-12 08:11:29','640',1413797.75,1260954.75,'640','2022-09-12 09:32:49','600','2022-09-12 10:06:57',10,0),('5','184',257215,'DAILLY','2022-09-12','2022-09-12 11:12:51','2022-09-13 11:12:51','640',1293773.45,1153906.05,'640','2022-09-13 06:40:25','600','2022-09-13 10:24:35',10,0),('5','184',257216,'DAILY','2022-09-13','2022-09-13 15:01:48','2022-09-14 15:01:48','640',1367671.70,1219815.30,'640','2022-09-14 09:48:29','600','2022-09-14 10:18:12',10,0),('5','184',257217,'DAILY','2022-09-14','2022-09-14 10:38:38','2022-09-15 10:38:38','640',1322938.70,1179918.30,'640','2022-09-15 09:05:22','600','2022-09-15 10:11:13',10,0),('5','184',257218,'DAILY','2022-09-15','2022-09-15 12:02:15','2022-09-16 12:02:15','640',1329176.90,1185482.10,'640','2022-09-16 10:00:40','600','2022-09-16 10:17:44',10,0),('5','184',257219,'DAILY','2022-09-16','2022-09-16 10:36:05','2022-09-17 10:36:05','640',1444535.50,1288369.50,'640','2022-09-17 11:18:27','600','2022-09-17 12:19:07',10,0),('5','184',257220,'DAILY','2022-09-17','2022-09-17 13:56:53','2022-09-18 13:56:53','640',1345242.30,1199810.70,'640','2022-09-18 10:03:17','600','2022-09-18 14:56:19',10,0),('5','184',257221,'DAILY','2022-09-18','2022-09-19 05:44:24','2022-09-20 05:44:24','640',1269695.70,1132431.30,'640','2022-09-19 05:46:10','600','2022-09-19 08:01:59',10,0),('5','184',257222,'DAILY','2022-09-19','2022-09-19 13:17:47','2022-09-20 13:17:47','640',1346189.50,1200655.50,'640','2022-09-20 08:13:53','600','2022-09-20 09:19:04',10,0),('5','184',257223,'DAILLY','2022-09-20','2022-09-21 08:33:00','2022-09-22 08:33:00','640',1290042.00,1150578.00,'640','2022-09-21 08:47:18','600','2022-09-22 08:43:43',10,0),('5','184',257224,'Daily shift','2022-09-24','2022-09-28 10:46:23','2022-09-29 10:46:23','640',1021716.15,1021716.15,'640','2022-09-28 10:51:56','600','2022-09-28 10:53:02',10,0),('5','184',257225,'Daily shift','2022-09-25','2022-09-28 10:55:22','2022-09-29 10:55:22','640',1188569.50,1188569.50,'640','2022-09-28 11:01:15','600','2022-09-28 11:02:05',10,0),('5','184',257226,'Daily shift','2022-09-26','2022-09-28 11:03:13','2022-09-29 11:03:13','640',1311507.55,1311507.55,'640','2022-09-28 11:09:23','600','2022-09-28 11:09:51',10,0),('5','184',257227,'Daily shift','2022-09-27','2022-09-28 16:45:11','2022-09-29 16:45:11','640',1228572.05,1228572.05,'640','2022-09-28 16:48:27','600','2022-09-28 16:49:27',10,0),('5','184',257228,'Daily shift','2022-09-28','2022-09-28 16:52:02','2022-09-29 16:52:02','640',1198986.85,1198986.85,'640','2022-09-29 12:01:24','600','2022-09-29 19:41:56',10,0),('5','184',257229,'Daily shift','2022-09-29','2022-09-29 19:43:46','2022-09-30 19:43:46','640',1283067.50,1283067.50,'640','2022-09-29 20:01:12','600','2022-09-30 08:19:17',10,0),('5','184',257230,'Daily shift','2022-09-30','2022-09-30 11:01:04','2022-10-01 11:01:04','640',1421943.30,1421943.30,'640','2022-09-30 19:01:16','600','2022-10-01 10:24:11',10,0),('5','184',257231,'Daily shift','2022-10-01','2022-10-01 10:57:51','2022-10-02 10:57:51','640',1357515.20,1357515.20,'640','2022-10-01 18:37:59','600','2022-10-02 05:08:35',10,0),('5','184',257232,'Daily shift','2022-10-02','2022-10-02 12:13:07','2022-10-03 12:13:07','640',1500930.90,1500930.90,'640','2022-10-02 18:17:44','600','2022-10-03 05:56:51',10,0),('5','184',257233,'Daily shift','2022-10-03','2022-10-03 10:47:31','2022-10-04 10:47:31','640',1446095.05,1446095.05,'640','2022-10-03 18:48:03','600','2022-10-04 09:07:34',10,0),('5','184',257234,'Daily shift','2022-10-04','2022-10-04 13:29:37','2022-10-05 13:29:37','640',1444629.85,1444629.85,'640','2022-10-04 18:42:52','600','2022-10-05 06:18:04',10,0),('5','184',257235,'Daily shift','2022-10-05','2022-10-05 10:55:38','2022-10-06 10:55:38','640',1277500.85,1277500.85,'640','2022-10-08 11:26:52','600','2022-10-08 18:51:21',10,0),('5','184',257236,'Daily shift','2022-10-08','2022-10-08 20:26:14','2022-10-09 20:26:14','640',0.00,0.00,'640','2022-10-08 20:28:19','600','2022-10-09 07:56:39',10,0),('5','184',257237,'Daily shift','2022-10-09','2022-10-09 20:13:25','2022-10-10 20:13:25','640',0.00,0.00,'640','2022-10-09 20:14:07','600','2022-10-10 10:26:45',10,0),('5','184',257238,'Daily shift','2022-10-10','2022-10-10 19:45:40','2022-10-11 19:45:40','640',0.00,0.00,'640','2022-10-10 19:46:25','600','2022-10-11 08:31:21',10,0),('5','184',257239,'Daily shift','2022-10-11','2022-10-11 18:49:24','2022-10-12 18:49:24','640',0.00,0.00,'640','2022-10-11 18:50:22','600','2022-10-12 08:59:21',10,0),('5','184',257240,'Daily shift','2022-10-12','2022-10-12 22:09:38','2022-10-13 22:09:38','640',0.00,0.00,'640','2022-10-12 22:10:16','600','2022-10-13 08:18:54',10,0),('5','184',257241,'Daily shift','2022-10-13','2022-10-13 19:51:01','2022-10-14 19:51:01','640',0.00,0.00,'640','2022-10-13 19:52:39','600','2022-10-14 08:13:01',10,0),('5','184',257242,'Daily shift','2022-10-14','2022-10-14 23:53:35','2022-10-15 23:53:35','640',0.00,0.00,'640','2022-10-14 23:54:01','600','2022-10-15 10:27:53',10,0),('5','184',257243,'Daily shift','2022-10-15','2022-10-16 02:23:59','2022-10-17 02:23:59','640',0.00,0.00,'640','2022-10-16 02:24:27','600','2022-10-16 09:58:18',10,0),('5','184',257244,'Daily shift','2022-10-16','2022-10-16 23:20:07','2022-10-17 23:20:07','640',0.00,0.00,'640','2022-10-16 23:20:45','600','2022-10-17 08:07:41',10,0),('5','184',257245,'Daily shift','2022-10-17','2022-10-17 21:00:39','2022-10-18 21:00:39','640',0.00,0.00,'640','2022-10-17 21:02:01','600','2022-10-18 06:37:50',10,0),('5','184',257246,'Daily shift','2022-10-18','2022-10-18 19:08:08','2022-10-19 19:08:08','640',0.00,0.00,'640','2022-10-18 19:08:38','600','2022-10-19 06:00:03',10,0),('5','184',257247,'Daily shift','2022-10-19','2022-10-19 12:03:00','2022-10-20 12:03:00','640',0.00,0.00,'640','2022-10-19 21:19:50','600','2022-10-20 09:08:14',10,0),('5','184',257248,'Daily shift','2022-10-20','2022-10-20 11:27:12','2022-10-21 11:27:12','640',0.00,0.00,'640','2022-10-20 20:58:23','600','2022-10-21 05:59:59',10,0),('5','184',257249,'Daily shift','2022-10-21','2022-10-21 21:02:19','2022-10-22 21:02:19','640',0.00,0.00,'640','2022-10-21 21:03:38','600','2022-10-22 09:14:11',10,0),('5','184',257250,'Daily shift','2022-10-22','2022-10-22 21:00:32','2022-10-23 21:00:32','640',0.00,0.00,'640','2022-10-22 21:01:09','600','2022-10-23 05:52:42',10,0),('5','184',257251,'Daily shift','2022-10-23','2022-10-23 15:30:40','2022-10-24 15:30:40','640',0.00,0.00,'640','2022-10-23 20:59:28','600','2022-10-24 06:02:29',10,0),('5','184',257252,'Daily shift','2022-10-24','2022-10-24 08:00:30','2022-10-25 08:00:30','640',0.00,0.00,'640','2022-10-24 19:21:52','600','2022-10-25 05:56:38',10,0),('5','184',257253,'Daily shift','2022-10-25','2022-10-25 19:07:13','2022-10-26 19:07:13','640',0.00,0.00,'640','2022-10-25 19:07:39','600','2022-10-26 06:02:16',10,0),('5','184',257254,'Daily shift','2022-10-26','2022-10-26 20:43:13','2022-10-27 20:43:13','640',0.00,0.00,'640','2022-10-26 20:43:59','600','2022-10-27 05:54:04',10,0),('5','184',257255,'Daily shift','2022-10-27','2022-10-27 18:55:34','2022-10-28 18:55:34','640',0.00,0.00,'640','2022-10-27 18:56:09','600','2022-10-28 08:04:10',10,0),('5','184',257256,'Daily shift','2022-10-28','2022-10-28 18:03:05','2022-10-29 18:03:05','640',2010117.50,2010117.50,'640','2022-10-29 12:00:55','600','2022-10-29 13:30:52',10,0),('5','184',257257,'Daily shift','2022-10-29','2022-10-29 20:19:03','2022-10-30 20:19:03','640',1209404.20,1209404.20,'640','2022-10-29 20:22:45','600','2022-10-30 05:48:47',10,0),('5','184',257258,'Daily shift','2022-10-30','2022-10-30 12:38:10','2022-10-31 12:38:10','640',1405235.95,1405235.95,'640','2022-10-30 20:35:16','600','2022-10-31 06:02:17',10,0),('5','184',257259,'Daily shift','2022-10-31','2022-10-31 22:01:19','2022-11-01 22:01:19','640',912523.60,912523.60,'640','2022-10-31 22:02:48','600','2022-11-01 05:55:21',10,0),('5','184',257260,'Daily shift','2022-11-01','2022-11-01 12:17:04','2022-11-02 12:17:04','640',1882504.50,1882504.50,'640','2022-11-01 21:14:49','600','2022-11-02 06:03:20',10,0),('5','184',257261,'Daily shift','2022-11-02','2022-11-02 20:02:14','2022-11-03 20:02:14','640',1647441.65,1647441.65,'640','2022-11-03 08:45:12','600','2022-11-03 19:23:16',10,0),('5','184',257262,'Daily shift','2022-11-03','2022-11-03 19:30:06','2022-11-04 19:30:06','640',1886981.50,1886981.50,'600','2022-11-04 10:59:09','600','2022-11-04 10:59:58',10,0),('5','184',257263,'Daily shift','2022-11-04','2022-11-04 13:26:45','2022-11-05 13:26:45','640',1970351.75,1970351.75,'640','2022-11-04 20:42:41','600','2022-11-05 09:00:13',10,0),('5','184',257264,'Daily shift','2022-11-05','2022-11-05 19:13:05','2022-11-06 19:13:05','640',1836559.75,1836559.75,'640','2022-11-05 19:15:08','600','2022-11-05 22:08:36',10,0),('5','184',257265,'Daily shift','2022-11-06','2022-11-06 18:06:24','2022-11-07 18:06:24','640',1866402.10,1866402.10,'640','2022-11-06 18:08:48','600','2022-11-07 06:07:00',10,0),('5','184',257266,'Daily shift','2022-11-07','2022-11-07 19:21:36','2022-11-08 19:21:36','640',1727393.10,1727393.10,'640','2022-11-07 19:25:51','600','2022-11-08 08:18:03',10,0),('5','184',257267,'Daily shift','2022-11-08','2022-11-08 19:17:17','2022-11-09 19:17:17','640',1072291.45,1072291.45,'640','2022-11-08 19:20:21','600','2022-11-09 08:14:55',10,0),('5','184',257268,'Daily shift','2022-11-09','2022-11-09 12:25:41','2022-11-10 12:25:41','640',2034938.95,2034938.95,'640','2022-11-10 07:56:29','600','2022-11-10 09:29:41',10,0),('5','184',257269,'Daily shift','2022-11-10','2022-11-10 15:59:33','2022-11-11 15:59:33','640',1303132.60,1303132.60,'640','2022-11-10 19:19:11','600','2022-11-11 09:27:22',10,0),('5','184',257270,'Daily shift','2022-11-11','2022-11-11 12:31:01','2022-11-12 12:31:01','640',1288787.70,1288787.70,'640','2022-11-11 18:52:04','600','2022-11-12 09:29:11',10,0),('5','184',257271,'Daily shift','2022-11-12','2022-11-12 20:39:50','2022-11-13 20:39:50','640',72155.55,72155.55,'640','2022-11-12 20:41:03','600','2022-11-13 06:01:10',10,0),('5','184',257272,'Daily shift','2022-11-13','2022-11-13 20:03:27','2022-11-14 20:03:27','640',0.00,0.00,'640','2022-11-13 20:04:01','600','2022-11-14 08:08:38',10,0),('5','184',257273,'Daily shift','2022-11-14','2022-11-14 20:05:52','2022-11-15 20:05:52','640',0.00,0.00,'640','2022-11-14 20:06:20','600','2022-11-15 08:24:31',10,0),('5','184',257274,'Daily shift','2022-11-15','2022-11-15 20:27:12','2022-11-16 20:27:12','640',0.00,0.00,'640','2022-11-15 20:27:54','600','2022-11-16 09:38:46',10,0),('5','184',257275,'Daily shift','2022-11-16','2022-11-16 19:12:27','2022-11-17 19:12:27','640',0.00,0.00,'640','2022-11-16 19:12:49','600','2022-11-17 09:59:42',10,0),('5','184',257276,'Daily shift','2022-11-17','2022-11-17 19:02:50','2022-11-18 19:02:50','640',0.00,0.00,'640','2022-11-17 19:04:50','600','2022-11-18 08:37:11',10,0),('5','184',257277,'Daily shift','2022-11-18','2022-11-18 21:00:28','2022-11-19 21:00:28','640',0.00,0.00,'640','2022-11-18 21:00:54','600','2022-11-19 09:15:08',10,0),('5','184',257278,'Daily shift','2022-11-19','2022-11-19 20:20:04','2022-11-20 20:20:04','640',0.00,0.00,'640','2022-11-19 20:20:35','600','2022-11-20 10:32:53',10,0),('5','184',257279,'Daily shift','2022-11-20','2022-11-20 17:55:48','2022-11-21 17:55:48','640',505009.30,505009.30,'640','2022-11-21 09:20:48','600','2022-11-21 10:10:57',10,0),('5','184',257280,'Daily shift','2022-11-21','2022-11-21 20:36:27','2022-11-22 20:36:26','640',1615506.95,1615506.95,'640','2022-11-21 20:38:10','600','2022-11-22 08:12:26',10,0),('5','184',257281,'Daily shift','2022-11-22','2022-11-22 09:36:07','2022-11-23 09:36:07','640',1325969.00,1325969.00,'640','2022-11-22 20:06:25','600','2022-11-23 06:11:41',10,0),('5','184',257282,'Daily shift','2022-11-23','2022-11-23 15:28:07','2022-11-24 15:28:07','640',1509840.50,1509840.50,'640','2022-11-23 18:33:40','600','2022-11-24 06:45:59',10,0),('5','184',257283,'DAILY ','2022-11-24','2022-11-24 10:22:35','2022-11-25 10:22:35','600',1158268.35,1158268.35,'640','2022-11-24 21:06:48','600','2022-11-25 06:09:03',10,0),('5','184',257284,'Daily shift','2022-11-25','2022-11-25 13:25:29','2022-11-26 13:25:29','640',1000047.10,1000047.10,'640','2022-11-25 22:19:21','600','2022-11-26 09:24:10',10,0),('5','184',257285,'Daily shift','2022-11-26','2022-11-26 20:32:43','2022-11-27 20:32:43','640',271282.15,271282.15,'640','2022-11-26 20:33:57','600','2022-11-27 09:29:51',10,0),('5','184',257286,'Daily shift','2022-11-27','2022-11-27 18:51:31','2022-11-28 18:51:31','640',0.00,0.00,'640','2022-11-27 18:51:54','600','2022-11-28 06:11:20',10,0),('5','184',257287,'Daily shift','2022-11-28','2022-11-28 17:30:43','2022-11-29 17:30:43','640',0.00,0.00,'640','2022-11-28 21:29:09','600','2022-11-29 06:02:47',10,0),('5','184',257288,'Daily shift','2022-11-29','2022-11-30 08:02:47','2022-12-01 08:02:47','640',555538.35,555538.35,'640','2022-11-30 08:04:39','600','2022-11-30 11:00:15',10,0),('5','184',257289,'Daily shift','2022-11-30','2022-11-30 18:02:52','2022-12-01 18:02:52','640',2527858.50,2527858.50,'640','2022-11-30 18:04:48','600','2022-12-01 06:04:29',10,0),('5','184',257290,'Daily shift','2022-12-01','2022-12-01 12:55:50','2022-12-02 12:55:50','640',1060503.25,1060503.25,'640','2022-12-01 18:27:06','600','2022-12-02 06:13:18',10,0),('5','184',257291,'Daily shift','2022-12-02','2022-12-02 11:58:49','2022-12-03 11:58:49','640',1503803.95,1503803.95,'640','2022-12-02 18:55:13','600','2022-12-03 10:11:44',10,0),('5','184',257292,'Daily shift','2022-12-03','2022-12-03 21:39:25','2022-12-04 21:39:25','640',1088743.50,1088743.50,'640','2022-12-03 21:42:50','600','2022-12-04 09:07:04',10,0),('5','184',257293,'Daily shift','2022-12-04','2022-12-04 19:02:47','2022-12-05 19:02:47','640',1035372.85,1035372.85,'640','2022-12-04 20:07:55','600','2022-12-05 06:06:32',10,0),('5','184',257294,'Daily shift','2022-12-05','2022-12-05 14:07:23','2022-12-06 14:07:23','640',546872.95,546872.95,'600','2022-12-06 15:16:48','600','2022-12-06 15:17:33',10,0),('5','184',257295,'Daily shift','2022-12-06','2022-12-06 19:54:38','2022-12-07 19:54:38','640',0.00,0.00,'640','2022-12-06 19:55:29','600','2022-12-07 06:14:10',10,0),('5','184',257296,'Daily shift','2022-12-07','2022-12-07 21:16:07','2022-12-08 21:16:07','640',0.00,0.00,'640','2022-12-07 21:17:22','600','2022-12-08 10:01:37',10,0),('5','184',257297,'Daily shift','2022-12-08','2022-12-08 20:01:26','2022-12-09 20:01:26','640',0.00,0.00,'640','2022-12-08 20:02:54','600','2022-12-09 06:07:04',10,0),('5','184',257298,'Daily shift','2022-12-09','2022-12-09 14:48:49','2022-12-10 14:48:49','640',0.00,0.00,'640','2022-12-09 18:40:38','600','2022-12-10 06:08:50',10,0),('5','184',257299,'Daily shift','2022-12-10','2022-12-10 09:19:47','2022-12-11 09:19:47','640',0.00,0.00,'640','2022-12-10 21:13:59','600','2022-12-11 09:17:43',10,0),('5','184',257300,'Daily shift','2022-12-11','2022-12-11 09:54:53','2022-12-12 09:54:53','640',0.00,0.00,'640','2022-12-11 23:48:03','600','2022-12-12 06:21:09',10,0),('5','184',257301,'Daily shift','2022-12-12','2022-12-12 07:10:24','2022-12-13 07:10:24','640',0.00,0.00,'640','2022-12-12 20:09:48','600','2022-12-13 09:19:49',10,0),('5','184',257302,'Daily shift','2022-12-13','2022-12-13 18:47:10','2022-12-14 18:47:10','640',0.00,0.00,'640','2022-12-13 18:47:43','795','2022-12-14 06:06:45',10,0),('5','184',257303,'Daily shift','2022-12-14','2022-12-14 12:10:28','2022-12-15 12:10:28','640',0.00,0.00,'640','2022-12-14 20:23:29','795','2022-12-15 09:48:25',10,0),('5','184',257304,'Daily shift','2022-12-15','2022-12-15 15:37:04','2022-12-16 15:37:04','640',0.00,0.00,'640','2022-12-15 19:18:50','795','2022-12-15 19:40:31',10,0),('5','184',257305,'Daily shift','2022-12-16','2022-12-16 11:07:13','2022-12-17 11:07:13','640',0.00,0.00,'640','2022-12-16 18:51:40','795','2022-12-17 19:06:39',10,0),('5','184',257306,'Daily shift','2022-12-17','2022-12-17 19:13:14','2022-12-18 19:13:14','640',0.00,0.00,'640','2022-12-17 19:13:45','795','2022-12-18 12:51:20',10,0),('5','184',257307,'Daily shift','2022-12-18','2022-12-18 14:00:48','2022-12-19 14:00:48','640',417774.40,417774.40,'640','2022-12-19 21:23:15','795','2022-12-20 12:15:28',10,0),('5','184',257308,'Daily shift','2022-12-19','2022-12-20 13:38:05','2022-12-21 13:38:05','640',1142881.90,1142881.90,'640','2022-12-20 13:39:41','795','2022-12-20 13:45:10',10,0),('5','184',257309,'Daily shift','2022-12-20','2022-12-20 14:36:29','2022-12-21 14:36:29','640',1344483.80,1344483.80,'640','2022-12-21 08:01:16','795','2022-12-21 10:38:14',10,0),('5','184',257310,'Daily shift','2022-12-21','2022-12-21 15:10:57','2022-12-22 15:10:57','640',1572548.10,1572548.10,'640','2022-12-21 18:43:56','795','2022-12-21 19:17:57',10,0),('5','184',257311,'Daily shift','2022-12-22','2022-12-22 11:23:05','2022-12-23 11:23:05','640',557915.60,557915.60,'640','2022-12-23 07:29:17','795','2022-12-23 09:57:56',10,0),('5','184',257312,'Daily shift','2022-12-23','2022-12-23 12:01:33','2022-12-24 12:01:33','640',503277.70,503277.70,'640','2022-12-23 20:16:38','795','2022-12-24 09:01:08',10,0),('5','184',257313,'Daily shift','2022-12-24','2022-12-24 20:04:58','2022-12-25 20:04:58','640',0.00,0.00,'640','2022-12-24 20:05:30','795','2022-12-25 16:07:10',10,0),('5','184',257314,'Daily shift','2022-12-25','2022-12-25 20:54:24','2022-12-26 20:54:24','640',0.00,0.00,'640','2022-12-25 20:54:54','795','2022-12-26 14:59:29',10,0),('5','184',257315,'Daily shift','2022-12-26','2022-12-26 20:29:34','2022-12-27 20:29:34','640',0.00,0.00,'640','2022-12-26 20:30:04','795','2022-12-27 12:14:40',10,0),('5','184',257316,'Daily shift','2022-12-27','2022-12-27 20:00:19','2022-12-28 20:00:19','640',0.00,0.00,'640','2022-12-27 20:01:14','795','2022-12-28 10:20:30',10,0),('5','184',257317,'Daily shift','2022-12-28','2022-12-28 16:31:01','2022-12-29 16:31:01','640',0.00,0.00,'640','2022-12-28 19:09:52','795','2022-12-29 09:28:47',10,0),('5','184',257318,'Daily shift','2022-12-29','2022-12-29 21:12:20','2022-12-30 21:12:20','640',0.00,0.00,'640','2022-12-29 21:12:56','795','2022-12-30 09:36:23',10,0),('5','184',257319,'Daily shift','2022-12-30','2022-12-30 21:02:45','2022-12-31 21:02:45','640',0.00,0.00,'640','2022-12-30 21:03:05','795','2022-12-31 07:31:39',10,0),('5','184',257320,'Daily shift','2022-12-31','2022-12-31 19:25:52','2023-01-01 19:25:52','640',0.00,0.00,'640','2022-12-31 19:26:13','795','2023-01-01 20:38:47',10,0),('5','184',257321,'Daily shift','2023-01-01','2023-01-01 20:48:56','2023-01-02 20:48:56','640',0.00,0.00,'640','2023-01-01 20:49:32','795','2023-01-02 19:05:19',10,0),('5','184',257322,'Daily shift','2023-01-02','2023-01-02 21:40:15','2023-01-03 21:40:15','640',0.00,0.00,'640','2023-01-02 21:40:58','795','2023-01-03 12:04:21',10,0),('5','184',257323,'Daily shift','2023-01-03','2023-01-03 20:17:41','2023-01-04 20:17:41','640',0.00,0.00,'640','2023-01-03 20:18:11','795','2023-01-04 11:20:23',10,0),('5','184',257324,'Daily shift','2023-01-04','2023-01-04 18:42:44','2023-01-05 18:42:44','640',0.00,0.00,'640','2023-01-04 18:43:06','795','2023-01-05 13:38:09',10,0),('5','184',257325,'Daily shift','2023-01-05','2023-01-05 19:10:51','2023-01-06 19:10:51','640',0.00,0.00,'640','2023-01-05 19:11:16','795','2023-01-05 19:54:35',10,0),('5','184',257326,'Daily shift','2023-01-06','2023-01-06 20:40:44','2023-01-07 20:40:44','640',0.00,0.00,'640','2023-01-06 20:41:20','795','2023-01-06 22:39:58',10,0),('5','184',257327,'Daily shift','2023-01-07','2023-01-07 19:16:02','2023-01-08 19:16:02','640',0.00,0.00,'640','2023-01-07 19:16:28','795','2023-01-07 21:52:46',10,0),('5','184',257328,'Daily shift','2023-01-08','2023-01-08 20:12:35','2023-01-09 20:12:35','640',0.00,0.00,'640','2023-01-08 20:13:03','795','2023-01-09 13:35:28',10,0),('5','184',257329,'Daily shift','2023-01-09','2023-01-09 21:27:22','2023-01-10 21:27:22','640',0.00,0.00,'640','2023-01-09 21:27:51','795','2023-01-10 15:39:33',10,0),('5','184',257330,'Daily shift','2023-01-10','2023-01-10 18:51:29','2023-01-11 18:51:29','640',0.00,0.00,'640','2023-01-10 18:51:57','795','2023-01-11 09:24:21',10,0),('5','184',257331,'Daily shift','2023-01-11','2023-01-11 21:06:48','2023-01-12 21:06:48','640',0.00,0.00,'640','2023-01-11 21:07:27','795','2023-01-12 09:26:57',10,0),('5','184',257332,'Daily shift','2023-01-12','2023-01-13 11:47:36','2023-01-14 11:47:36','640',0.00,0.00,'640','2023-01-13 11:48:12','795','2023-01-13 13:53:40',10,0),('5','184',257333,'Daily shift','2023-01-13','2023-01-13 14:45:20','2023-01-14 14:45:20','640',0.00,0.00,'640','2023-01-13 22:25:08','795','2023-01-14 13:41:56',10,0),('5','184',257334,'Daily shift','2023-01-14','2023-01-14 20:10:20','2023-01-15 20:10:20','640',0.00,0.00,'640','2023-01-14 20:10:42','795','2023-01-15 13:45:04',10,0),('5','184',257335,'Daily shift','2023-01-15','2023-01-15 19:22:32','2023-01-16 19:22:32','640',0.00,0.00,'640','2023-01-15 19:23:29','795','2023-01-16 09:35:23',10,0),('5','184',257336,'Daily shift','2023-01-16','2023-01-16 20:11:31','2023-01-17 20:11:31','640',0.00,0.00,'640','2023-01-16 20:11:52','795','2023-01-17 09:13:29',10,0),('5','184',257337,'Daily shift','2023-01-17','2023-01-17 16:18:44','2023-01-18 16:18:44','640',1336465.90,1336465.90,'640','2023-01-17 19:10:53','795','2023-01-18 09:26:14',10,0),('5','184',257338,'Daily shift','2023-01-18','2023-01-18 19:06:06','2023-01-19 19:06:06','640',2157322.00,2157322.00,'640','2023-01-18 19:07:42','795','2023-01-19 09:34:30',10,0),('5','184',257339,'Daily shift','2023-01-19','2023-01-19 19:17:55','2023-01-20 19:17:55','640',1320076.75,1320076.75,'640','2023-01-19 19:19:42','795','2023-01-19 19:20:55',10,0),('5','184',257340,'Daily shift','2023-01-20','2023-01-20 06:11:35','2023-01-21 06:11:35','640',1065409.45,1065409.45,'640','2023-01-20 18:51:27','795','2023-01-21 10:51:03',10,0),('5','184',257341,'Daily shift','2023-01-21','2023-01-21 19:43:17','2023-01-22 19:43:17','640',824717.05,980744.60,'640','2023-01-21 19:45:10','795','2023-01-22 20:43:03',10,0),('5','184',257342,'Daily shift','2023-01-22','2023-01-22 21:13:11','2023-01-23 21:13:11','640',607121.90,721982.80,'640','2023-01-24 19:06:39','795','2023-01-25 09:39:54',10,0),('5','184',257343,'Daily shift','2023-01-23','2023-01-25 10:29:33','2023-01-26 10:29:33','640',0.00,0.00,'640','2023-01-25 10:30:16','795','2023-01-25 21:09:26',10,0),('5','184',257344,'Daily shift','2023-01-24','2023-01-26 07:10:03','2023-01-27 07:10:03','640',0.00,0.00,'640','2023-01-26 07:11:12','795','2023-01-26 20:30:40',10,0),('5','184',257345,'Daily shift','2023-01-25','2023-01-26 20:38:37','2023-01-27 20:38:37','640',0.00,0.00,'640','2023-01-26 20:39:09','795','2023-01-27 08:24:48',10,0),('5','184',257346,'Daily shift','2023-01-26','2023-01-27 08:37:33','2023-01-28 08:37:33','640',0.00,0.00,'640','2023-01-27 08:38:02','795','2023-01-27 13:46:59',10,0),('5','184',257347,'Daily shift','2023-01-27','2023-01-27 16:29:03','2023-01-28 16:29:03','640',1666519.80,1666519.80,'640','2023-01-27 19:19:35','795','2023-01-28 23:53:16',10,0),('5','184',257348,'Daily shift','2023-01-28','2023-01-29 11:42:03','2023-01-30 11:42:03','640',1720043.60,1720043.60,'640','2023-01-29 11:44:11','795','2023-01-29 21:10:56',10,0),('5','184',257349,'Daily shift','2023-01-29','2023-01-29 21:43:06','2023-01-30 21:43:06','640',1426713.20,1426713.20,'640','2023-01-29 21:44:44','795','2023-01-30 09:49:59',10,0),('5','184',257350,'Daily shift','2023-01-30','2023-01-30 13:38:48','2023-01-31 13:38:48','640',2160092.00,2160092.00,'640','2023-01-30 19:16:10','795','2023-01-31 09:54:28',10,0),('5','184',257351,'Daily shift','2023-02-01','2023-02-02 07:56:01','2023-02-03 07:56:01','640',0.00,0.00,'640','2023-02-02 08:01:11','795','2023-02-02 09:25:46',10,0),('5','184',257352,'Daily shift','2023-02-02','2023-02-02 21:42:41','2023-02-03 21:42:41','640',0.00,0.00,'640','2023-02-02 21:43:17','795','2023-02-03 09:17:30',10,0),('5','184',257353,'Daily shift','2023-02-03','2023-02-03 09:36:05','2023-02-04 09:36:05','640',1382979.40,1382979.40,'640','2023-02-03 18:59:54','795','2023-02-04 18:10:16',10,0),('5','184',257354,'Daily shift','2023-02-04','2023-02-04 18:46:18','2023-02-05 18:46:18','640',889229.00,889229.00,'640','2023-02-04 18:48:09','795','2023-02-05 20:46:29',10,0),('5','184',257355,'Daily shift','2023-02-05','2023-02-05 23:35:45','2023-02-06 23:35:45','640',1338290.80,1338290.80,'640','2023-02-05 23:38:44','795','2023-02-06 13:48:05',10,0),('5','184',257356,'Daily shift','2023-02-06','2023-02-06 16:49:45','2023-02-07 16:49:45','640',127206.20,106968.85,'640','2023-02-07 12:55:19','795','2023-02-07 13:03:27',10,0),('5','184',257357,'Daily shift','2023-02-07','2023-02-07 21:40:49','2023-02-08 21:40:49','640',0.00,0.00,'640','2023-02-07 21:41:22','795','2023-02-08 10:30:05',10,0),('5','184',257358,'Daily shift','2023-02-08','2023-02-08 20:27:34','2023-02-09 20:27:34','640',0.00,0.00,'640','2023-02-08 20:28:18','795','2023-02-09 09:19:54',10,0),('5','184',257359,'Daily shift','2023-02-09','2023-02-09 16:00:03','2023-02-10 16:00:03','640',1380504.40,1380504.40,'640','2023-02-10 15:39:03','795','2023-02-10 15:48:42',10,0),('5','184',257360,'Daily shift','2023-02-10','2023-02-10 19:41:55','2023-02-11 19:41:55','640',1312579.40,1312579.40,'640','2023-02-10 19:43:36','795','2023-02-11 12:40:23',10,0),('5','184',257361,'Daily shift','2023-02-11','2023-02-11 19:14:10','2023-02-12 19:14:10','640',611050.00,611050.00,'640','2023-02-11 19:15:32','795','2023-02-12 09:18:41',10,0),('5','184',257362,'Daily shift','2023-02-12','2023-02-12 20:34:10','2023-02-13 20:34:10','640',0.00,0.00,'640','2023-02-12 20:34:45','795','2023-02-13 11:50:59',10,0),('5','184',257363,'Daily shift','2023-02-13','2023-02-13 20:58:23','2023-02-14 20:58:23','640',0.00,0.00,'640','2023-02-13 20:58:53','795','2023-02-14 09:30:39',10,0),('5','184',257364,'Daily shift','2023-02-14','2023-02-14 19:31:08','2023-02-15 19:31:08','640',0.00,0.00,'640','2023-02-14 19:31:35','795','2023-02-15 13:34:50',10,0),('5','184',257365,'Daily shift','2023-02-15','2023-02-15 20:54:59','2023-02-16 20:54:59','640',0.00,0.00,'640','2023-02-15 20:55:58','795','2023-02-16 12:32:08',10,0),('5','184',257366,'Daily shift','2023-02-16','2023-02-16 19:19:36','2023-02-17 19:19:36','640',0.00,0.00,'640','2023-02-16 19:20:14','795','2023-02-18 22:51:52',10,0),('5','184',257367,'Daily shift','2023-02-17','2023-02-18 22:57:21','2023-02-19 22:57:21','640',0.00,0.00,'640','2023-02-18 22:57:47','795','2023-02-20 09:19:25',10,0),('5','184',257368,'Daily shift','2023-02-18','2023-02-20 20:17:42','2023-02-21 20:17:42','640',0.00,0.00,'640','2023-02-20 20:18:09','795','2023-02-21 13:31:51',10,0),('5','184',257369,'Daily shift','2023-02-19','2023-02-21 14:17:42','2023-02-22 14:17:42','640',0.00,0.00,'640','2023-02-21 14:18:07','795','2023-02-22 13:46:32',10,0),('5','184',257370,'Daily shift','2023-02-20','2023-02-22 16:48:17','2023-02-23 16:48:17','640',0.00,0.00,'640','2023-02-22 16:48:43','795','2023-02-24 10:34:20',10,0),('5','184',257371,'Daily shift','2023-02-21','2023-02-24 13:03:29','2023-02-25 13:03:29','640',0.00,0.00,'640','2023-02-24 13:03:50','795','2023-02-24 21:50:12',10,0),('5','184',257372,'Daily shift','2023-02-24','2023-02-25 08:06:47','2023-02-26 08:06:47','640',262470.60,262470.60,'640','2023-02-26 07:40:05','795','2023-02-26 13:03:00',10,0),('5','184',257373,'Daily shift','2023-02-25','2023-02-26 19:10:44','2023-02-27 19:10:44','640',0.00,0.00,'640','2023-02-26 19:11:31','795','2023-02-27 07:14:57',10,0),('5','184',257374,'Daily shift','2023-02-26','2023-02-27 11:03:12','2023-02-28 11:03:12','640',967953.00,967953.00,'640','2023-02-27 11:05:27','795','2023-02-27 13:10:19',10,0),('5','184',257375,'Daily shift','2023-02-27','2023-02-27 21:38:56','2023-02-28 21:38:56','640',1039441.20,1039441.20,'640','2023-02-27 21:43:44','795','2023-02-27 22:49:48',10,0),('5','184',257376,'Daily shift','2023-02-28','2023-02-28 19:36:27','2023-03-01 19:36:27','640',1390565.40,1390565.40,'640','2023-02-28 19:37:57','795','2023-02-28 20:22:24',10,0),('5','184',257377,'Daily shift','2023-03-01','2023-03-01 21:34:38','2023-03-02 21:34:38','640',1700353.20,1700353.20,'640','2023-03-01 21:38:04','795','2023-03-02 09:44:01',10,0),('5','184',257378,'Daily shift','2023-03-02','2023-03-02 16:52:30','2023-03-03 16:52:30','640',1496287.80,1496287.80,'640','2023-03-03 12:17:18','795','2023-03-03 13:18:54',10,0),('5','184',257379,'Daily shift','2023-03-03','2023-03-03 19:12:04','2023-03-04 19:12:04','640',1717968.00,1717968.00,'640','2023-03-03 19:13:43','795','2023-03-04 12:41:06',10,0),('5','184',257380,'Daily shift','2023-03-04','2023-03-04 19:09:31','2023-03-05 19:09:31','640',1693549.20,1693549.20,'640','2023-03-04 19:11:19','795','2023-03-05 14:55:09',10,0),('5','184',257381,'Daily shift','2023-03-05','2023-03-05 18:32:14','2023-03-06 18:32:14','640',2175014.10,2175014.10,'640','2023-03-05 18:34:10','795','2023-03-06 09:41:29',10,0),('5','184',257382,'Daily shift','2023-03-06','2023-03-06 18:59:33','2023-03-07 18:59:33','640',1521055.20,1521055.20,'640','2023-03-06 19:01:37','795','2023-03-06 21:16:59',10,0),('5','184',257385,'Daily shift','2023-03-07','2023-03-07 18:44:32','2023-03-08 18:44:32','640',2427276.60,2427276.60,'640','2023-03-07 18:48:30','795','2023-03-08 12:17:03',10,0),('5','184',257386,'Daily shift','2023-03-08','2023-03-08 21:39:04','2023-03-09 21:39:04','640',1729608.30,1729608.30,'640','2023-03-08 21:42:39','795','2023-03-09 09:15:22',10,0),('5','184',257387,'Daily shift','2023-03-09','2023-03-10 08:15:24','2023-03-11 08:15:24','640',1401714.30,1401714.30,'640','2023-03-10 08:17:17','795','2023-03-10 13:45:10',10,0),('5','184',257388,'Daily shift','2023-03-10','2023-03-10 19:36:16','2023-03-11 19:36:16','640',1643271.00,1643271.00,'640','2023-03-10 19:38:15','795','2023-03-11 13:21:32',10,0),('5','184',257389,'Daily shift','2023-03-11','2023-03-11 19:46:02','2023-03-12 19:46:02','640',1806760.20,1806760.20,'640','2023-03-11 19:47:46','795','2023-03-12 15:48:29',10,0),('5','184',257390,'Daily shift','2023-03-12','2023-03-12 19:34:21','2023-03-13 19:34:21','640',1639274.70,1639274.70,'640','2023-03-12 19:35:54','795','2023-03-13 09:55:48',10,0),('5','184',257391,'Daily shift','2023-03-13','2023-03-13 16:27:10','2023-03-14 16:27:10','640',1577211.30,1577211.30,'640','2023-03-14 20:51:32','795','2023-03-15 12:06:16',10,0),('5','184',257392,'Daily shift','2023-03-14','2023-03-15 12:31:22','2023-03-16 12:31:22','640',0.00,0.00,'640','2023-03-15 12:31:54','795','2023-03-15 12:51:34',10,0),('5','184',257393,'Daily shift','2023-03-15','2023-03-15 19:03:24','2023-03-16 19:03:24','640',0.00,0.00,'640','2023-03-15 19:04:20','795','2023-03-18 00:03:25',10,0),('5','184',257394,'Daily shift','2023-03-17','2023-03-18 14:20:49','2023-03-19 14:20:49','640',0.00,0.00,'640','2023-03-18 14:22:35','795','2023-03-19 08:40:51',10,0),('5','184',257395,'Daily shift','2023-03-18','2023-03-19 08:50:55','2023-03-20 08:50:55','640',0.00,0.00,'640','2023-03-19 08:51:28','795','2023-03-20 08:47:00',10,0),('5','184',257396,'Daily shift','2023-03-19','2023-03-20 20:24:33','2023-03-21 20:24:33','640',0.00,0.00,'640','2023-03-20 20:25:27','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4899638 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','184','957','212338',4114076,'2843','429',121.19,433.21,312.02,51483.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','212338',4114077,'2844','429',82.95,1193.32,1110.37,183211.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','212338',4114078,'2845','429',39.51,1305.61,1266.10,208906.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','212338',4114079,'2846','429',2.81,2.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','212338',4114080,'2847','429',63.80,1225.04,1161.24,191604.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','212338',4114081,'2848','429',198.44,973.90,775.46,127950.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','212338',4114082,'2849','429',108.31,625.09,516.78,85268.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','212338',4114083,'2850','429',105.71,535.09,429.38,70847.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','212338',4114084,'2851','430',40.80,346.92,306.12,88774.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','212338',4114085,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213030',4126545,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213030',4126546,'2844','429',1193.32,3117.77,1924.45,317534.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','213030',4126547,'2845','429',1305.61,2276.95,971.34,160271.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','213030',4126548,'2846','429',73.26,73.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213030',4126549,'2847','429',1225.04,2494.94,1269.90,209533.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','213030',4126550,'2848','429',973.90,2930.85,1956.95,322896.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','213030',4126551,'2849','429',625.09,1713.36,1088.27,179564.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','213030',4126552,'2850','429',535.09,535.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213030',4126553,'2851','430',346.92,821.73,474.81,137694.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','213030',4126554,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213036',4126625,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213036',4126626,'2844','429',3117.77,5179.83,2062.06,340239.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','213036',4126627,'2845','429',2276.95,2276.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213036',4126628,'2846','429',73.26,73.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213036',4126629,'2847','429',2494.94,3135.35,640.41,105667.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','213036',4126630,'2848','429',2930.85,4812.26,1881.41,310432.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','213036',4126631,'2849','429',1713.36,3138.35,1424.99,235123.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','213036',4126632,'2850','429',535.09,1962.53,1427.44,235527.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','213036',4126633,'2851','430',821.73,1832.78,1011.05,293204.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','213036',4126634,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213043',4126726,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213043',4126727,'2844','429',5179.83,6454.04,1274.21,210244.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','213043',4126728,'2845','429',2276.95,2296.21,19.26,3177.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','213043',4126729,'2846','429',73.26,678.10,604.84,99798.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','213043',4126730,'2847','429',3135.35,3481.44,346.09,57104.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','213043',4126731,'2848','429',4812.26,5336.67,524.41,86527.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','213043',4126732,'2849','429',3138.35,3835.89,697.54,115094.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','213043',4126733,'2850','429',1962.53,2291.05,328.52,54205.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','213043',4126734,'2851','430',1832.78,1930.53,97.75,28347.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','213043',4126735,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213057',4126880,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213057',4126881,'2844','429',6454.04,6454.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213057',4126882,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213057',4126883,'2846','429',678.10,678.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213057',4126884,'2847','429',3481.44,3481.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213057',4126885,'2848','429',5336.67,5336.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213057',4126886,'2849','429',3835.89,3835.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213057',4126887,'2850','429',2291.05,2291.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213057',4126888,'2851','430',1930.53,1930.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','213057',4126889,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213061',4126985,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213061',4126986,'2844','429',6454.04,6454.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213061',4126987,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213061',4126988,'2846','429',678.10,678.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213061',4126989,'2847','429',3481.44,3481.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213061',4126990,'2848','429',5336.67,5336.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213061',4126991,'2849','429',3835.89,3835.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213061',4126992,'2850','429',2291.05,2291.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213061',4126993,'2851','430',1930.53,1930.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','213061',4126994,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213062',4126995,'2843','429',433.21,433.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213062',4126996,'2844','429',6454.04,7497.65,1043.61,172195.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','213062',4126997,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213062',4126998,'2846','429',678.10,678.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213062',4126999,'2847','429',3481.44,3481.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213062',4127000,'2848','429',5336.67,6301.78,965.11,159243.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','213062',4127001,'2849','429',3835.89,4629.55,793.66,130953.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','213062',4127002,'2850','429',2291.05,2291.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213062',4127003,'2851','430',1930.53,1969.63,39.10,11534.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','213062',4127004,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213068',4127135,'2843','429',433.21,1460.82,1027.61,169555.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','213068',4127136,'2844','429',7497.65,7883.45,385.80,63657.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213068',4127137,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213068',4127138,'2846','429',678.10,1630.14,952.04,157086.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','213068',4127139,'2847','429',3481.44,4856.58,1375.14,226898.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','213068',4127140,'2848','429',6301.78,6629.25,327.47,54032.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','213068',4127141,'2849','429',4629.55,5932.99,1303.44,215067.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','213068',4127142,'2850','429',2291.05,2291.23,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','213068',4127143,'2851','430',1969.63,3171.34,1201.71,354504.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','213068',4127144,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213228',4129713,'2843','429',1460.82,3711.70,2250.88,371395.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','213228',4129714,'2844','429',7883.45,7883.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213228',4129715,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213228',4129716,'2846','429',1630.14,2814.81,1184.67,195470.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','213228',4129717,'2847','429',4856.58,5910.67,1054.09,173924.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','213228',4129718,'2848','429',6629.25,9028.69,2399.44,395907.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','213228',4129719,'2849','429',5932.99,5932.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213228',4129720,'2850','429',2291.23,2291.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213228',4129721,'2851','430',3171.34,4111.97,940.63,277485.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','213228',4129722,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213237',4129836,'2843','429',3711.70,6467.61,2755.91,454725.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','213237',4129837,'2844','429',7883.45,9982.15,2098.70,346285.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','213237',4129838,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213237',4129839,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213237',4129840,'2847','429',5910.67,7426.92,1516.25,250181.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','213237',4129841,'2848','429',9028.69,9028.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213237',4129842,'2849','429',5932.99,6694.64,761.65,125672.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','213237',4129843,'2850','429',2291.23,2291.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213237',4129844,'2851','430',4111.97,4297.83,185.86,54828.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','213237',4129845,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213242',4129878,'2843','429',6467.61,8688.77,2221.16,366491.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','213242',4129879,'2844','429',9982.15,12378.12,2395.97,395335.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','213242',4129880,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213242',4129881,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213242',4129882,'2847','429',7426.92,8668.90,1241.98,204926.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','213242',4129883,'2848','429',9028.69,12123.63,3094.94,510665.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','213242',4129884,'2849','429',6694.64,6694.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213242',4129885,'2850','429',2291.23,2583.85,292.62,48282.30,0.00,0.00,0.00,0.00,0.00),('5','184','959','213242',4129886,'2851','430',4297.83,4581.48,283.65,83676.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','213242',4129887,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213260',4130168,'2843','429',8688.77,8688.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213260',4130169,'2844','429',12378.12,14859.36,2481.24,409404.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','213260',4130170,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213260',4130171,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213260',4130172,'2847','429',8668.90,11088.07,2419.17,399163.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','213260',4130173,'2848','429',12123.63,12123.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213260',4130174,'2849','429',6694.64,8939.17,2244.53,370347.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','213260',4130175,'2850','429',2583.85,2583.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213260',4130176,'2851','430',4581.48,4849.14,267.66,78959.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','213260',4130177,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213284',4130533,'2843','429',8688.77,11490.70,2801.93,462318.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','213284',4130534,'2844','429',14859.36,14859.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213284',4130535,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213284',4130536,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213284',4130537,'2847','429',11088.07,13270.64,2182.57,360124.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','213284',4130538,'2848','429',12123.63,14114.19,1990.56,328442.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','213284',4130539,'2849','429',8939.17,8939.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213284',4130540,'2850','429',2583.85,2583.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213284',4130541,'2851','430',4849.14,4945.34,96.20,28379.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','213284',4130542,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213305',4130968,'2843','429',11490.70,13604.82,2114.12,348829.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','213305',4130969,'2844','429',14859.36,16442.09,1582.73,261150.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','213305',4130970,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213305',4130971,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213305',4130972,'2847','429',13270.64,14965.03,1694.39,279574.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','213305',4130973,'2848','429',14114.19,14114.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213305',4130974,'2849','429',8939.17,8939.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213305',4130975,'2850','429',2583.85,2583.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213305',4130976,'2851','430',4945.34,5054.25,108.91,32128.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','213305',4130977,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213338',4131545,'2843','429',13604.82,15957.54,2352.72,388198.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','213338',4131546,'2844','429',16442.09,18279.82,1837.73,303225.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','213338',4131547,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213338',4131548,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213338',4131549,'2847','429',14965.03,14965.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213338',4131550,'2848','429',14114.19,14114.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213338',4131551,'2849','429',8939.17,10427.68,1488.51,245604.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','213338',4131552,'2850','429',2583.85,2896.83,312.98,51641.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','213338',4131553,'2851','430',5054.25,5212.66,158.41,46730.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','213338',4131554,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213346',4131747,'2843','429',15957.54,19016.46,3058.92,504721.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','213346',4131748,'2844','429',18279.82,20143.88,1864.06,307569.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','213346',4131749,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213346',4131750,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213346',4131751,'2847','429',14965.03,15530.11,565.08,93238.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','213346',4131752,'2848','429',14114.19,15267.31,1153.12,190264.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','213346',4131753,'2849','429',10427.68,10888.86,461.18,76094.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','213346',4131754,'2850','429',2896.83,2912.30,15.47,2552.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','213346',4131755,'2851','430',5212.66,6224.43,1011.77,298472.15,0.00,0.00,0.00,0.00,0.00),('5','184','960','213346',4131756,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213481',4133901,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213481',4133902,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213481',4133903,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213481',4133904,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213481',4133905,'2847','429',15530.11,18111.05,2580.94,425855.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','213481',4133906,'2848','429',15267.31,18033.89,2766.58,456485.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','213481',4133907,'2849','429',10888.86,12476.22,1587.36,261914.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','213481',4133908,'2850','429',2912.30,3336.14,423.84,69933.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','213481',4133909,'2851','430',6224.43,6335.43,111.00,32745.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','213481',4133910,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213502',4134237,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213502',4134238,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213502',4134239,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213502',4134240,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213502',4134241,'2847','429',18111.05,18852.16,741.11,122283.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','213502',4134242,'2848','429',18033.89,19865.76,1831.87,302258.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','213502',4134243,'2849','429',12476.22,13833.56,1357.34,223961.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','213502',4134244,'2850','429',3336.14,4672.94,1336.80,220572.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213502',4134245,'2851','430',6335.43,6335.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','213502',4134246,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213509',4134341,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213509',4134342,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213509',4134343,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213509',4134344,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213509',4134345,'2847','429',18852.16,21172.31,2320.15,382824.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','213509',4134346,'2848','429',19865.76,21894.41,2028.65,334727.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','213509',4134347,'2849','429',13833.56,15615.74,1782.18,294059.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','213509',4134348,'2850','429',4672.94,4672.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','213509',4134349,'2851','430',6335.43,6542.28,206.85,61020.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','213509',4134350,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213562',4135179,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213562',4135180,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213562',4135181,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213562',4135182,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213562',4135183,'2847','429',21172.31,23261.31,2089.00,344685.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213562',4135184,'2848','429',21894.41,23557.36,1662.95,274386.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','213562',4135185,'2849','429',15615.74,17075.62,1459.88,240880.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','213562',4135186,'2850','429',4672.94,5528.84,855.90,141223.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','213562',4135187,'2851','430',6542.28,7557.15,1014.87,299386.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','213562',4135188,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213688',4137333,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213688',4137334,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213688',4137335,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213688',4137336,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213688',4137337,'2847','429',23261.31,25311.03,2049.72,338203.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','213688',4137338,'2848','429',23557.36,25525.97,1968.61,324820.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','213688',4137339,'2849','429',17075.62,18955.03,1879.41,310102.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','213688',4137340,'2850','429',5528.84,5855.39,326.55,53880.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','213688',4137341,'2851','430',7557.15,7734.50,177.35,52318.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','213688',4137342,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213899',4140763,'2843','429',19016.46,19016.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213899',4140764,'2844','429',20143.88,20143.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213899',4140765,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','213899',4140766,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','213899',4140767,'2847','429',25311.03,27562.88,2251.85,371555.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','213899',4140768,'2848','429',25525.97,27554.03,2028.06,334629.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','213899',4140769,'2849','429',18955.03,19581.76,626.73,103410.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','213899',4140770,'2850','429',5855.39,6969.09,1113.70,183760.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','213899',4140771,'2851','430',7734.50,8707.97,973.47,287173.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','213899',4140772,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214142',4144839,'2843','429',19016.46,21168.44,2151.98,355076.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','214142',4144840,'2844','429',20143.88,21988.43,1844.55,304350.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','214142',4144841,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214142',4144842,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214142',4144843,'2847','429',27562.88,28512.96,950.08,156763.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','214142',4144844,'2848','429',27554.03,28089.11,535.08,88288.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','214142',4144845,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214142',4144846,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','214142',4144847,'2851','430',8707.97,9100.74,392.77,115867.15,0.00,0.00,0.00,0.00,0.00),('5','184','960','214142',4144848,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214754',4155641,'2843','429',21168.44,25138.08,3969.64,654990.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','214754',4155642,'2844','429',21988.43,24091.81,2103.38,347057.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','214754',4155643,'2845','429',2296.21,2296.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214754',4155644,'2846','429',2814.81,2814.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214754',4155645,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214754',4155646,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214754',4155647,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214754',4155648,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','214754',4155649,'2851','430',9100.74,10055.47,954.73,281645.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','214754',4155650,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214933',4158483,'2843','429',25138.08,27474.54,2336.46,385515.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','214933',4158484,'2844','429',24091.81,25844.31,1752.50,289162.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','214933',4158485,'2845','429',2296.21,3383.01,1086.80,179322.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214933',4158486,'2846','429',2814.81,4076.65,1261.84,208203.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','214933',4158487,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214933',4158488,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214933',4158489,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214933',4158490,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','214933',4158491,'2851','430',10055.47,10969.86,914.39,269745.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','214933',4158492,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','214938',4158622,'2843','429',27474.54,29447.97,1973.43,325615.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','214938',4158623,'2844','429',25844.31,27326.99,1482.68,244642.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','214938',4158624,'2845','429',3383.01,4940.60,1557.59,257002.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','214938',4158625,'2846','429',4076.65,4745.50,668.85,110360.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','214938',4158626,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214938',4158627,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214938',4158628,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','214938',4158629,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','214938',4158630,'2851','430',10969.86,11067.48,97.62,28797.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','214938',4158631,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215044',4160205,'2843','429',29447.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215044',4160206,'2844','429',27326.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215044',4160207,'2845','429',4940.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215044',4160208,'2846','429',4745.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215044',4160209,'2847','429',28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215044',4160210,'2848','429',28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215044',4160211,'2849','429',19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215044',4160212,'2850','429',6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','215044',4160213,'2851','430',11067.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','215044',4160214,'2852','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215288',4164424,'2843','429',29447.97,31408.33,1960.36,323459.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','215288',4164425,'2844','429',27326.99,28782.06,1455.07,240086.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','215288',4164426,'2845','429',4940.60,6712.26,1771.66,292323.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','215288',4164427,'2846','429',4745.50,5616.26,870.76,143675.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','215288',4164428,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215288',4164429,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215288',4164430,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215288',4164431,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','215288',4164432,'2851','430',11067.48,12045.89,978.41,288630.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','215288',4164433,'2852','431',286032.62,286038.07,5.45,899.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','215400',4166454,'2843','429',31408.33,33389.80,1981.47,326942.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','215400',4166455,'2844','429',28782.06,30111.75,1329.69,219398.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','215400',4166456,'2845','429',6712.26,8528.86,1816.60,299739.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215400',4166457,'2846','429',5616.26,6067.04,450.78,74378.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','215400',4166458,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215400',4166459,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215400',4166460,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215400',4166461,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','215400',4166462,'2851','430',12045.89,13068.46,1022.57,301658.15,0.00,0.00,0.00,0.00,0.00),('5','184','960','215400',4166463,'2852','431',286038.07,286038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','215500',4167931,'2843','429',33389.80,36158.77,2768.97,456880.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','215500',4167932,'2844','429',30111.75,32629.12,2517.37,415366.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','215500',4167933,'2845','429',8528.86,9475.79,946.93,156243.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','215500',4167934,'2846','429',6067.04,6067.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215500',4167935,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215500',4167936,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215500',4167937,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','215500',4167938,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','215500',4167939,'2851','430',13068.46,13216.85,148.39,43775.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','215500',4167940,'2852','431',286038.07,286496.77,458.70,75685.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','216434',4184124,'2843','429',36158.77,38134.40,1975.63,325978.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','216434',4184125,'2844','429',32629.12,33766.14,1137.02,187608.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','216434',4184126,'2845','429',9475.79,11540.23,2064.44,340632.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','216434',4184127,'2846','429',6067.04,6986.73,919.69,151748.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','216434',4184128,'2847','429',28512.96,28512.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216434',4184129,'2848','429',28089.11,28089.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216434',4184130,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216434',4184131,'2850','429',6969.09,6969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','216434',4184132,'2851','430',13216.85,14259.48,1042.63,307575.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','216434',4184133,'2852','431',286496.77,286732.47,235.70,38890.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','216887',4192054,'2843','429',38134.40,39755.56,1621.16,267491.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','216887',4192055,'2844','429',33766.14,33805.38,39.24,6474.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','216887',4192056,'2845','429',11540.23,12595.05,1054.82,174045.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','216887',4192057,'2846','429',6986.73,7886.05,899.32,148387.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','216887',4192058,'2847','429',28512.96,29591.29,1078.33,177924.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','216887',4192059,'2848','429',28089.11,28919.96,830.85,137090.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','216887',4192060,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216887',4192061,'2850','429',6969.09,7467.32,498.23,82207.95,0.00,0.00,0.00,0.00,0.00),('5','184','959','216887',4192062,'2851','430',14259.48,14853.58,594.10,175259.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','216887',4192063,'2852','431',286732.47,287122.00,389.53,64272.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','216984',4194047,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216984',4194048,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216984',4194049,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216984',4194050,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216984',4194051,'2847','429',29591.29,31857.29,2266.00,373890.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216984',4194052,'2848','429',28919.96,30633.47,1713.51,282729.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','216984',4194053,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216984',4194054,'2850','429',7467.32,8777.46,1310.14,216173.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','216984',4194055,'2851','430',14853.58,14853.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','216984',4194056,'2852','431',287122.00,287210.32,88.32,14572.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','216992',4194160,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216992',4194161,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216992',4194162,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216992',4194163,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216992',4194164,'2847','429',31857.29,34230.40,2373.11,391563.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','216992',4194165,'2848','429',30633.47,32253.56,1620.09,267314.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','216992',4194166,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216992',4194167,'2850','429',8777.46,10175.05,1397.59,230602.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','216992',4194168,'2851','430',14853.58,15033.10,179.52,52958.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','216992',4194169,'2852','431',287210.32,287807.39,597.07,98516.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','216994',4194176,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216994',4194177,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216994',4194178,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216994',4194179,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216994',4194180,'2847','429',34230.40,36510.57,2280.17,376228.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','216994',4194181,'2848','429',32253.56,34015.82,1762.26,290772.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','216994',4194182,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216994',4194183,'2850','429',10175.05,11715.70,1540.65,254207.25,0.00,0.00,0.00,0.00,0.00),('5','184','959','216994',4194184,'2851','430',15033.10,15126.64,93.54,27594.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','216994',4194185,'2852','431',287807.39,287885.12,77.73,12825.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','216998',4194220,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216998',4194221,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216998',4194222,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','216998',4194223,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216998',4194224,'2847','429',36510.57,38674.74,2164.17,357088.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','216998',4194225,'2848','429',34015.82,35597.54,1581.72,260983.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','216998',4194226,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','216998',4194227,'2850','429',11715.70,12920.77,1205.07,198836.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','216998',4194228,'2851','430',15126.64,15514.87,388.23,114527.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','216998',4194229,'2852','431',287885.12,288238.56,353.44,58317.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','217055',4194922,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217055',4194923,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217055',4194924,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217055',4194925,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217055',4194926,'2847','429',38674.74,40790.97,2116.23,349177.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','217055',4194927,'2848','429',35597.54,37038.63,1441.09,237779.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','217055',4194928,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217055',4194929,'2850','429',12920.77,14280.96,1360.19,224431.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','217055',4194930,'2851','430',15514.87,15689.08,174.21,51391.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','217055',4194931,'2852','431',288238.56,288648.24,409.68,67597.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','217481',4202900,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217481',4202901,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217481',4202902,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217481',4202903,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217481',4202904,'2847','429',40790.97,43008.99,2218.02,365973.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','217481',4202905,'2848','429',37038.63,38687.52,1648.89,272066.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','217481',4202906,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217481',4202907,'2850','429',14280.96,15647.77,1366.81,225523.65,0.00,0.00,0.00,0.00,0.00),('5','184','959','217481',4202908,'2851','430',15689.08,16421.71,732.63,216125.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','217481',4202909,'2852','431',288648.24,289015.53,367.29,60602.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','217647',4205886,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217647',4205887,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217647',4205888,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217647',4205889,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217647',4205890,'2847','429',43008.99,45292.21,2283.22,376731.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','217647',4205891,'2848','429',38687.52,39336.68,649.16,107111.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','217647',4205892,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217647',4205893,'2850','429',15647.77,17135.06,1487.29,245402.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','217647',4205894,'2851','430',16421.71,16582.07,160.36,47306.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','217647',4205895,'2852','431',289015.53,289542.94,527.41,87022.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','217856',4209518,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217856',4209519,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217856',4209520,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','217856',4209521,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217856',4209522,'2847','429',45292.21,46033.54,741.33,122319.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','217856',4209523,'2848','429',39336.68,39602.95,266.27,43934.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','217856',4209524,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','217856',4209525,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','217856',4209526,'2851','430',16582.07,16744.40,162.33,47887.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','217856',4209527,'2852','431',289542.94,292421.07,2878.13,474891.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','218026',4212348,'2843','429',39755.56,39755.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218026',4212349,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218026',4212350,'2845','429',12595.05,12595.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218026',4212351,'2846','429',7886.05,7886.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218026',4212352,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218026',4212353,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218026',4212354,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218026',4212355,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','218026',4212356,'2851','430',16744.40,17671.58,927.18,273518.10,0.00,0.00,0.00,0.00,0.00),('5','184','960','218026',4212357,'2852','431',292421.07,295974.12,3553.05,586253.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','218265',4216482,'2843','429',39755.56,41228.78,1473.22,243081.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','218265',4216483,'2844','429',33805.38,33805.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218265',4216484,'2845','429',12595.05,13684.41,1089.36,179744.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','218265',4216485,'2846','429',7886.05,8740.05,854.00,140910.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218265',4216486,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218265',4216487,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218265',4216488,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218265',4216489,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','218265',4216490,'2851','430',17671.58,17772.01,100.43,29626.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','218265',4216491,'2852','431',295974.12,296923.90,949.78,156713.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','218779',4225553,'2843','429',41228.78,43130.13,1901.35,313722.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','218779',4225554,'2844','429',33805.38,34157.31,351.93,58068.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','218779',4225555,'2845','429',13684.41,15322.21,1637.80,270237.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218779',4225556,'2846','429',8740.05,10237.81,1497.76,247130.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','218779',4225557,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218779',4225558,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218779',4225559,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218779',4225560,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','218779',4225561,'2851','430',17772.01,18349.45,577.44,170344.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','218779',4225562,'2852','431',296923.90,296923.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218873',4227460,'2843','429',43130.13,45494.93,2364.80,390192.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','218873',4227461,'2844','429',34157.31,35143.18,985.87,162668.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','218873',4227462,'2845','429',15322.21,17039.37,1717.16,283331.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','218873',4227463,'2846','429',10237.81,10237.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218873',4227464,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218873',4227465,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218873',4227466,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','218873',4227467,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','218873',4227468,'2851','430',18349.45,19267.18,917.73,270730.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','218873',4227469,'2852','431',296923.90,297232.41,308.51,50904.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','219101',4231413,'2843','429',45494.93,46962.65,1467.72,242173.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','219101',4231414,'2844','429',35143.18,36134.27,991.09,163529.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','219101',4231415,'2845','429',17039.37,18591.65,1552.28,256126.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','219101',4231416,'2846','429',10237.81,10909.49,671.68,110827.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','219101',4231417,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219101',4231418,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219101',4231419,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219101',4231420,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','219101',4231421,'2851','430',19267.18,20240.31,973.13,287073.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','219101',4231422,'2852','431',297232.41,297232.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','219314',4235119,'2843','429',46962.65,49070.72,2108.07,347831.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','219314',4235120,'2844','429',36134.27,36134.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','219314',4235121,'2845','429',18591.65,20222.57,1630.92,269101.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','219314',4235122,'2846','429',10909.49,12280.55,1371.06,226224.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','219314',4235123,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219314',4235124,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219314',4235125,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219314',4235126,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','219314',4235127,'2851','430',20240.31,21131.05,890.74,262768.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','219314',4235128,'2852','431',297232.41,297275.96,43.55,7185.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','219444',4237110,'2843','429',49070.72,51128.48,2057.76,339530.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','219444',4237111,'2844','429',36134.27,36902.97,768.70,126835.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','219444',4237112,'2845','429',20222.57,21641.50,1418.93,234123.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','219444',4237113,'2846','429',12280.55,13092.30,811.75,133938.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','219444',4237114,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219444',4237115,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219444',4237116,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219444',4237117,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','219444',4237118,'2851','430',21131.05,22069.90,938.85,276960.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','219444',4237119,'2852','431',297275.96,297680.98,405.02,66828.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','219679',4241134,'2843','429',51128.48,53024.54,1896.06,312849.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','219679',4241135,'2844','429',36902.97,37100.26,197.29,32552.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','219679',4241136,'2845','429',21641.50,23067.00,1425.50,235207.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','219679',4241137,'2846','429',13092.30,14291.67,1199.37,197896.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','219679',4241138,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219679',4241139,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219679',4241140,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219679',4241141,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','219679',4241142,'2851','430',22069.90,22257.23,187.33,55262.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','219679',4241143,'2852','431',297680.98,297680.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','219880',4244813,'2843','429',53024.54,55043.52,2018.98,333131.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','219880',4244814,'2844','429',37100.26,38650.46,1550.20,255783.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','219880',4244815,'2845','429',23067.00,24366.49,1299.49,214415.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','219880',4244816,'2846','429',14291.67,15077.25,785.58,129620.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','219880',4244817,'2847','429',46033.54,46033.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219880',4244818,'2848','429',39602.95,39602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219880',4244819,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','219880',4244820,'2850','429',17135.06,17135.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','219880',4244821,'2851','430',22257.23,22518.22,260.99,76992.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','219880',4244822,'2852','431',297680.98,297680.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220128',4249370,'2843','429',55043.52,55459.58,416.06,68649.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','220128',4249371,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220128',4249372,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220128',4249373,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220128',4249374,'2847','429',46033.54,47815.26,1781.72,293983.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','220128',4249375,'2848','429',39602.95,41068.32,1465.37,241786.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','220128',4249376,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220128',4249377,'2850','429',17135.06,17790.63,655.57,108169.05,0.00,0.00,0.00,0.00,0.00),('5','184','959','220128',4249378,'2851','430',22518.22,23426.63,908.41,267980.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','220128',4249379,'2852','431',297680.98,298167.03,486.05,80198.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','220440',4255225,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220440',4255226,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220440',4255227,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220440',4255228,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220440',4255229,'2847','429',47815.26,49636.11,1820.85,300440.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','220440',4255230,'2848','429',41068.32,42700.50,1632.18,269309.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','220440',4255231,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220440',4255232,'2850','429',17790.63,19104.15,1313.52,216730.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','220440',4255233,'2851','430',23426.63,23604.33,177.70,52421.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','220440',4255234,'2852','431',298167.03,298834.42,667.39,110119.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','220551',4256926,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220551',4256927,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220551',4256928,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220551',4256929,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220551',4256930,'2847','429',49636.11,51272.73,1636.62,270042.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','220551',4256931,'2848','429',42700.50,43998.79,1298.29,214217.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','220551',4256932,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220551',4256933,'2850','429',19104.15,20367.41,1263.26,208437.90,0.00,0.00,0.00,0.00,0.00),('5','184','959','220551',4256934,'2851','430',23604.33,23669.18,64.85,19130.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','220551',4256935,'2852','431',298834.42,298988.53,154.11,25428.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','220889',4263081,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220889',4263082,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220889',4263083,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220889',4263084,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220889',4263085,'2847','429',51272.73,53220.50,1947.77,321382.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','220889',4263086,'2848','429',43998.79,45647.93,1649.14,272108.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','220889',4263087,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220889',4263088,'2850','429',20367.41,21379.72,1012.31,167031.15,0.00,0.00,0.00,0.00,0.00),('5','184','959','220889',4263089,'2851','430',23669.18,24531.98,862.80,254526.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','220889',4263090,'2852','431',298988.53,299255.00,266.47,43967.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','220985',4264576,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220985',4264577,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220985',4264578,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','220985',4264579,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220985',4264580,'2847','429',53220.50,54476.58,1256.08,207253.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','220985',4264581,'2848','429',45647.93,47344.02,1696.09,279854.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','220985',4264582,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','220985',4264583,'2850','429',21379.72,22537.96,1158.24,191109.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','220985',4264584,'2851','430',24531.98,24583.80,51.82,15286.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','220985',4264585,'2852','431',299255.00,299896.92,641.92,105916.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','221192',4268064,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221192',4268065,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221192',4268066,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221192',4268067,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221192',4268068,'2847','429',54476.58,54476.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221192',4268069,'2848','429',47344.02,49490.03,2146.01,354091.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','221192',4268070,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221192',4268071,'2850','429',22537.96,24459.72,1921.76,317090.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','221192',4268072,'2851','430',24583.80,25584.23,1000.43,295126.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','221192',4268073,'2852','431',299896.92,300815.93,919.01,151636.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','221511',4273983,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221511',4273984,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221511',4273985,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221511',4273986,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221511',4273987,'2847','429',54476.58,54476.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221511',4273988,'2848','429',49490.03,51637.57,2147.54,354344.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','221511',4273989,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221511',4273990,'2850','429',24459.72,26071.85,1612.13,266001.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','221511',4273991,'2851','430',25584.23,26500.97,916.74,270438.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','221511',4273992,'2852','431',300815.93,301854.95,1039.02,171438.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','221757',4278529,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221757',4278530,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221757',4278531,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','221757',4278532,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221757',4278533,'2847','429',54476.58,56662.95,2186.37,360751.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','221757',4278534,'2848','429',51637.57,53318.14,1680.57,277294.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','221757',4278535,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','221757',4278536,'2850','429',26071.85,26330.39,258.54,42659.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','221757',4278537,'2851','430',26500.97,26586.50,85.53,25231.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','221757',4278538,'2852','431',301854.95,302502.07,647.12,106774.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','222242',4287189,'2843','429',55459.58,55459.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222242',4287190,'2844','429',38650.46,38650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222242',4287191,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222242',4287192,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222242',4287193,'2847','429',56662.95,58672.40,2009.45,331559.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','222242',4287194,'2848','429',53318.14,54645.43,1327.29,219002.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','222242',4287195,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222242',4287196,'2850','429',26330.39,27226.18,895.79,147805.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','222242',4287197,'2851','430',26586.50,27420.54,834.04,246041.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','222242',4287198,'2852','431',302502.07,303105.39,603.32,99547.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','222253',4287366,'2843','429',55459.58,57102.74,1643.16,271121.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','222253',4287367,'2844','429',38650.46,39863.77,1213.31,200196.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','222253',4287368,'2845','429',24366.49,24366.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222253',4287369,'2846','429',15077.25,15077.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222253',4287370,'2847','429',58672.40,59371.36,698.96,115328.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','222253',4287371,'2848','429',54645.43,55249.54,604.11,99678.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','222253',4287372,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222253',4287373,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','222253',4287374,'2851','430',27420.54,27535.21,114.67,33827.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','222253',4287375,'2852','431',303105.39,303105.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222468',4291117,'2843','429',57102.74,58927.89,1825.15,301149.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','222468',4291118,'2844','429',39863.77,39863.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','222468',4291119,'2845','429',24366.49,25394.28,1027.79,169585.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','222468',4291120,'2846','429',15077.25,15754.27,677.02,111708.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','222468',4291121,'2847','429',59371.36,59397.77,26.41,4357.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','222468',4291122,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222468',4291123,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222468',4291124,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','222468',4291125,'2851','430',27535.21,28553.56,1018.35,300413.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','222468',4291126,'2852','431',303105.39,303277.22,171.83,28351.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','222617',4293466,'2843','429',58927.89,60640.91,1713.02,282648.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','222617',4293467,'2844','429',39863.77,40487.65,623.88,102940.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','222617',4293468,'2845','429',25394.28,26428.96,1034.68,170722.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','222617',4293469,'2846','429',15754.27,16051.16,296.89,48986.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','222617',4293470,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222617',4293471,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222617',4293472,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222617',4293473,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','222617',4293474,'2851','430',28553.56,28731.00,177.44,52344.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','222617',4293475,'2852','431',303277.22,303348.04,70.82,11685.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','222786',4296522,'2843','429',60640.91,61978.36,1337.45,220679.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','222786',4296523,'2844','429',40487.65,41515.04,1027.39,169519.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','222786',4296524,'2845','429',26428.96,27241.48,812.52,134065.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','222786',4296525,'2846','429',16051.16,16051.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222786',4296526,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222786',4296527,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222786',4296528,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','222786',4296529,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','222786',4296530,'2851','430',28731.00,28767.66,36.66,10814.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','222786',4296531,'2852','431',303348.04,303490.41,142.37,23491.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','223003',4300805,'2843','429',61978.36,63644.49,1666.13,274911.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','223003',4300806,'2844','429',41515.04,41865.01,349.97,57745.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','223003',4300807,'2845','429',27241.48,28226.30,984.82,162495.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','223003',4300808,'2846','429',16051.16,16928.43,877.27,144749.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','223003',4300809,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223003',4300810,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223003',4300811,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223003',4300812,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','223003',4300813,'2851','430',28767.66,28899.40,131.74,38863.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','223003',4300814,'2852','431',303490.41,303536.46,46.05,7598.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','223264',4304900,'2843','429',63644.49,65112.33,1467.84,242193.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','223264',4304901,'2844','429',41865.01,42178.64,313.63,51748.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','223264',4304902,'2845','429',28226.30,29323.97,1097.67,181115.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','223264',4304903,'2846','429',16928.43,18070.95,1142.52,188515.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','223264',4304904,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223264',4304905,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223264',4304906,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223264',4304907,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','223264',4304908,'2851','430',28899.40,29025.19,125.79,37108.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','223264',4304909,'2852','431',303536.46,303536.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','223528',4309729,'2843','429',65112.33,66672.03,1559.70,257350.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','223528',4309730,'2844','429',42178.64,42473.45,294.81,48643.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','223528',4309731,'2845','429',29323.97,30465.57,1141.60,188364.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','223528',4309732,'2846','429',18070.95,19260.19,1189.24,196224.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','223528',4309733,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223528',4309734,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223528',4309735,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223528',4309736,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','223528',4309737,'2851','430',29025.19,29190.99,165.80,48911.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','223528',4309738,'2852','431',303536.46,303725.03,188.57,31114.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','223708',4313119,'2843','429',66672.03,68648.55,1976.52,322172.76,0.00,0.00,0.00,0.00,0.00),('5','184','958','223708',4313120,'2844','429',42473.45,42783.00,309.55,50456.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','223708',4313121,'2845','429',30465.57,31869.84,1404.27,228896.01,0.00,0.00,0.00,0.00,0.00),('5','184','958','223708',4313122,'2846','429',19260.19,19977.22,717.03,116875.89,0.00,0.00,0.00,0.00,0.00),('5','184','957','223708',4313123,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223708',4313124,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223708',4313125,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223708',4313126,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','223708',4313127,'2851','430',29190.99,29381.08,190.09,56076.55,0.00,0.00,0.00,0.00,0.00),('5','184','960','223708',4313128,'2852','431',303725.03,304580.77,855.74,139485.62,0.00,0.00,0.00,0.00,0.00),('5','184','958','223941',4317415,'2843','429',68648.55,68648.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','223941',4317416,'2844','429',42783.00,42783.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','223941',4317417,'2845','429',31869.84,31869.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','223941',4317418,'2846','429',19977.22,19977.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223941',4317419,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223941',4317420,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223941',4317421,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','223941',4317422,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','223941',4317423,'2851','430',29381.08,29486.23,105.15,31019.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','223941',4317424,'2852','431',304580.77,308210.94,3630.17,591717.71,0.00,0.00,0.00,0.00,0.00),('5','184','958','224163',4321183,'2843','429',68648.55,68648.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224163',4321184,'2844','429',42783.00,42783.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224163',4321185,'2845','429',31869.84,31869.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224163',4321186,'2846','429',19977.22,19977.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224163',4321187,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224163',4321188,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224163',4321189,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224163',4321190,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','224163',4321191,'2851','430',29486.23,29568.88,82.65,24381.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','224163',4321192,'2852','431',308210.94,311529.97,3319.03,541001.89,0.00,0.00,0.00,0.00,0.00),('5','184','958','224424',4326047,'2843','429',68648.55,68821.83,173.28,28244.64,0.00,0.00,0.00,0.00,0.00),('5','184','958','224424',4326048,'2844','429',42783.00,42783.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224424',4326049,'2845','429',31869.84,31869.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224424',4326050,'2846','429',19977.22,19977.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224424',4326051,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224424',4326052,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224424',4326053,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224424',4326054,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','224424',4326055,'2851','430',29568.88,29647.40,78.52,23163.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','224424',4326056,'2852','431',311529.97,314592.90,3062.93,499257.59,0.00,0.00,0.00,0.00,0.00),('5','184','958','224619',4329369,'2843','429',68821.83,70900.30,2078.47,338790.61,0.00,0.00,0.00,0.00,0.00),('5','184','958','224619',4329370,'2844','429',42783.00,43341.25,558.25,90994.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','224619',4329371,'2845','429',31869.84,33344.94,1475.10,240441.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','224619',4329372,'2846','429',19977.22,20664.86,687.64,112085.32,0.00,0.00,0.00,0.00,0.00),('5','184','957','224619',4329373,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224619',4329374,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224619',4329375,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224619',4329376,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','224619',4329377,'2851','430',29647.40,29926.71,279.31,82396.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','224619',4329378,'2852','431',314592.90,314592.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','224822',4332811,'2843','429',70900.30,72759.45,1859.15,303041.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','224822',4332812,'2844','429',43341.25,43752.01,410.76,66953.88,0.00,0.00,0.00,0.00,0.00),('5','184','958','224822',4332813,'2845','429',33344.94,35050.46,1705.52,277999.76,0.00,0.00,0.00,0.00,0.00),('5','184','958','224822',4332814,'2846','429',20664.86,21951.32,1286.46,209692.98,0.00,0.00,0.00,0.00,0.00),('5','184','957','224822',4332815,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224822',4332816,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224822',4332817,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','224822',4332818,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','224822',4332819,'2851','430',29926.71,30063.42,136.71,40329.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','224822',4332820,'2852','431',314592.90,314592.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','225333',4342063,'2843','429',72759.45,74673.06,1913.61,311918.43,0.00,0.00,0.00,0.00,0.00),('5','184','958','225333',4342064,'2844','429',43752.01,45141.94,1389.93,226558.59,0.00,0.00,0.00,0.00,0.00),('5','184','958','225333',4342065,'2845','429',35050.46,36774.38,1723.92,280998.96,0.00,0.00,0.00,0.00,0.00),('5','184','958','225333',4342066,'2846','429',21951.32,22313.82,362.50,59087.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','225333',4342067,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225333',4342068,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225333',4342069,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225333',4342070,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','225333',4342071,'2851','430',30063.42,30289.04,225.62,66557.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','225333',4342072,'2852','431',314592.90,314592.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','225411',4343898,'2843','429',74673.06,76944.34,2271.28,370218.64,0.00,0.00,0.00,0.00,0.00),('5','184','958','225411',4343899,'2844','429',45141.94,45551.95,410.01,66831.63,0.00,0.00,0.00,0.00,0.00),('5','184','958','225411',4343900,'2845','429',36774.38,38418.03,1643.65,267914.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','225411',4343901,'2846','429',22313.82,23844.67,1530.85,249528.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','225411',4343902,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225411',4343903,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225411',4343904,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225411',4343905,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','225411',4343906,'2851','430',30289.04,30383.10,94.06,27747.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','225411',4343907,'2852','431',314592.90,314592.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','225553',4346218,'2843','429',76944.34,79128.53,2184.19,356022.97,0.00,0.00,0.00,0.00,0.00),('5','184','958','225553',4346219,'2844','429',45551.95,46130.21,578.26,94256.38,0.00,0.00,0.00,0.00,0.00),('5','184','958','225553',4346220,'2845','429',38418.03,39968.08,1550.05,252658.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','225553',4346221,'2846','429',23844.67,25165.26,1320.59,215256.17,0.00,0.00,0.00,0.00,0.00),('5','184','957','225553',4346222,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225553',4346223,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225553',4346224,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225553',4346225,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','225553',4346226,'2851','430',30383.10,30494.54,111.44,32874.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','225553',4346227,'2852','431',314592.90,314592.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','225839',4351155,'2843','429',79128.53,81249.09,2120.56,345651.28,0.00,0.00,0.00,0.00,0.00),('5','184','958','225839',4351156,'2844','429',46130.21,47266.71,1136.50,185249.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','225839',4351157,'2845','429',39968.08,42218.31,2250.23,366787.49,0.00,0.00,0.00,0.00,0.00),('5','184','958','225839',4351158,'2846','429',25165.26,25829.22,663.96,108225.48,0.00,0.00,0.00,0.00,0.00),('5','184','957','225839',4351159,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225839',4351160,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225839',4351161,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','225839',4351162,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','225839',4351163,'2851','430',30494.54,30686.70,192.16,56687.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','225839',4351164,'2852','431',314592.90,314723.51,130.61,21289.43,0.00,0.00,0.00,0.00,0.00),('5','184','958','226066',4355009,'2843','429',81249.09,83203.79,1954.70,318616.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','226066',4355010,'2844','429',47266.71,47266.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','226066',4355011,'2845','429',42218.31,44136.85,1918.54,312722.02,0.00,0.00,0.00,0.00,0.00),('5','184','958','226066',4355012,'2846','429',25829.22,27395.28,1566.06,255267.78,0.00,0.00,0.00,0.00,0.00),('5','184','957','226066',4355013,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226066',4355014,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226066',4355015,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226066',4355016,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','226066',4355017,'2851','430',30686.70,30823.85,137.15,40459.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','226066',4355018,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','226329',4359858,'2843','429',83203.79,85270.08,2066.29,336805.27,0.00,0.00,0.00,0.00,0.00),('5','184','958','226329',4359859,'2844','429',47266.71,47558.43,291.72,47550.36,0.00,0.00,0.00,0.00,0.00),('5','184','958','226329',4359860,'2845','429',44136.85,46050.65,1913.80,311949.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','226329',4359861,'2846','429',27395.28,28776.43,1381.15,225127.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','226329',4359862,'2847','429',59397.77,59397.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226329',4359863,'2848','429',55249.54,55249.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226329',4359864,'2849','429',19581.76,19581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226329',4359865,'2850','429',27226.18,27226.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','226329',4359866,'2851','430',30823.85,30969.12,145.27,42854.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','226329',4359867,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','226585',4364395,'2843','429',85270.08,85342.26,72.18,11765.34,0.00,0.00,0.00,0.00,0.00),('5','184','958','226585',4364396,'2844','429',47558.43,47590.24,31.81,5185.03,0.00,0.00,0.00,0.00,0.00),('5','184','958','226585',4364397,'2845','429',46050.65,46068.46,17.81,2903.03,0.00,0.00,0.00,0.00,0.00),('5','184','958','226585',4364398,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','226585',4364399,'2847','429',59397.77,61010.31,1612.54,262844.02,0.00,0.00,0.00,0.00,0.00),('5','184','957','226585',4364400,'2848','429',55249.54,56071.08,821.54,133911.02,0.00,0.00,0.00,0.00,0.00),('5','184','957','226585',4364401,'2849','429',19581.76,21029.30,1447.54,235949.02,0.00,0.00,0.00,0.00,0.00),('5','184','957','226585',4364402,'2850','429',27226.18,28236.82,1010.64,164734.32,0.00,0.00,0.00,0.00,0.00),('5','184','959','226585',4364403,'2851','430',30969.12,31156.25,187.13,55203.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','226585',4364404,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227007',4371981,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227007',4371982,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227007',4371983,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227007',4371984,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227007',4371985,'2847','429',61010.31,62919.64,1909.33,311220.79,0.00,0.00,0.00,0.00,0.00),('5','184','957','227007',4371986,'2848','429',56071.08,57857.82,1786.74,291238.62,0.00,0.00,0.00,0.00,0.00),('5','184','957','227007',4371987,'2849','429',21029.30,22158.20,1128.90,184010.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','227007',4371988,'2850','429',28236.82,28641.75,404.93,66003.59,0.00,0.00,0.00,0.00,0.00),('5','184','959','227007',4371989,'2851','430',31156.25,31345.44,189.19,55811.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','227007',4371990,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227121',4374109,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227121',4374110,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227121',4374111,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227121',4374112,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227121',4374113,'2847','429',62919.64,64929.89,2010.25,327670.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','227121',4374114,'2848','429',57857.82,59211.67,1353.85,220677.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','227121',4374115,'2849','429',22158.20,23619.58,1461.38,238204.94,0.00,0.00,0.00,0.00,0.00),('5','184','957','227121',4374116,'2850','429',28641.75,28641.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','227121',4374117,'2851','430',31345.44,31472.97,127.53,37621.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','227121',4374118,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227242',4375988,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227242',4375989,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227242',4375990,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227242',4375991,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227242',4375992,'2847','429',64929.89,66945.55,2015.66,328552.58,0.00,0.00,0.00,0.00,0.00),('5','184','957','227242',4375993,'2848','429',59211.67,61000.93,1789.26,291649.38,0.00,0.00,0.00,0.00,0.00),('5','184','957','227242',4375994,'2849','429',23619.58,24975.96,1356.38,221089.94,0.00,0.00,0.00,0.00,0.00),('5','184','957','227242',4375995,'2850','429',28641.75,29221.40,579.65,94482.95,0.00,0.00,0.00,0.00,0.00),('5','184','959','227242',4375996,'2851','430',31472.97,31511.44,38.47,11348.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','227242',4375997,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227436',4379694,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227436',4379695,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227436',4379696,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227436',4379697,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227436',4379698,'2847','429',66945.55,68556.77,1611.22,262628.86,0.00,0.00,0.00,0.00,0.00),('5','184','957','227436',4379699,'2848','429',61000.93,62927.73,1926.80,314068.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','227436',4379700,'2849','429',24975.96,26460.43,1484.47,241968.61,0.00,0.00,0.00,0.00,0.00),('5','184','957','227436',4379701,'2850','429',29221.40,29699.44,478.04,77920.52,0.00,0.00,0.00,0.00,0.00),('5','184','959','227436',4379702,'2851','430',31511.44,31667.74,156.30,46108.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','227436',4379703,'2852','431',314723.51,314723.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227794',4386082,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227794',4386083,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227794',4386084,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227794',4386085,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227794',4386086,'2847','429',68556.77,70532.32,1975.55,322014.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','227794',4386087,'2848','429',62927.73,64744.30,1816.57,296100.91,0.00,0.00,0.00,0.00,0.00),('5','184','957','227794',4386088,'2849','429',26460.43,27485.15,1024.72,167029.36,0.00,0.00,0.00,0.00,0.00),('5','184','957','227794',4386089,'2850','429',29699.44,30672.15,972.71,158551.73,0.00,0.00,0.00,0.00,0.00),('5','184','959','227794',4386090,'2851','430',31667.74,31800.15,132.41,39723.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','227794',4386091,'2852','431',314723.51,315247.91,524.40,85477.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','227921',4388094,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227921',4388095,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227921',4388096,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','227921',4388097,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','227921',4388098,'2847','429',70532.32,72866.33,2334.01,380443.63,0.00,0.00,0.00,0.00,0.00),('5','184','957','227921',4388099,'2848','429',64744.30,65722.59,978.29,159461.27,0.00,0.00,0.00,0.00,0.00),('5','184','957','227921',4388100,'2849','429',27485.15,29349.33,1864.18,303861.34,0.00,0.00,0.00,0.00,0.00),('5','184','957','227921',4388101,'2850','429',30672.15,31074.23,402.08,65539.04,0.00,0.00,0.00,0.00,0.00),('5','184','959','227921',4388102,'2851','430',31800.15,31957.80,157.65,47295.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','227921',4388103,'2852','431',315247.91,315882.02,634.11,103359.93,0.00,0.00,0.00,0.00,0.00),('5','184','958','229313',4414588,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','229313',4414589,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','229313',4414590,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','229313',4414591,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','229313',4414592,'2847','429',72866.33,74127.14,1260.81,205512.03,0.00,0.00,0.00,0.00,0.00),('5','184','957','229313',4414593,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','229313',4414594,'2849','429',29349.33,29969.26,619.93,101048.59,0.00,0.00,0.00,0.00,0.00),('5','184','957','229313',4414595,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','229313',4414596,'2851','430',31957.80,32154.23,196.43,58929.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','229313',4414597,'2852','431',315882.02,318738.93,2856.91,465676.33,0.00,0.00,0.00,0.00,0.00),('5','184','958','230633',4439636,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230633',4439637,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230633',4439638,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230633',4439639,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230633',4439640,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230633',4439641,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230633',4439642,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230633',4439643,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230633',4439644,'2851','430',32154.23,32376.77,222.54,66762.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','230633',4439645,'2852','431',318738.93,323009.11,4270.18,696039.34,0.00,0.00,0.00,0.00,0.00),('5','184','958','230676',4440440,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230676',4440441,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230676',4440442,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230676',4440443,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230676',4440444,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230676',4440445,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230676',4440446,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230676',4440447,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230676',4440448,'2851','430',32376.77,32424.47,47.70,14310.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','230676',4440449,'2852','431',323009.11,326763.88,3754.77,612027.51,0.00,0.00,0.00,0.00,0.00),('5','184','958','230964',4445293,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230964',4445294,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230964',4445295,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230964',4445296,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230964',4445297,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230964',4445298,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230964',4445299,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230964',4445300,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230964',4445301,'2851','430',32424.47,32475.19,50.72,15216.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','230964',4445302,'2852','431',326763.88,328530.13,1766.25,287898.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','230970',4445380,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230970',4445381,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230970',4445382,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230970',4445383,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230970',4445384,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230970',4445385,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230970',4445386,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230970',4445387,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230970',4445388,'2851','430',32475.19,32575.17,99.98,29994.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','230970',4445389,'2852','431',328530.13,329503.87,973.74,158719.62,0.00,0.00,0.00,0.00,0.00),('5','184','958','230977',4445539,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230977',4445540,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230977',4445541,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230977',4445542,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230977',4445543,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230977',4445544,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230977',4445545,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230977',4445546,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230977',4445547,'2851','430',32575.17,32719.85,144.68,44850.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','230977',4445548,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230986',4445675,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230986',4445676,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230986',4445677,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','230986',4445678,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230986',4445679,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230986',4445680,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230986',4445681,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','230986',4445682,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','230986',4445683,'2851','430',32719.85,32862.75,142.90,44299.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','230986',4445684,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231183',4448999,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231183',4449000,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231183',4449001,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231183',4449002,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231183',4449003,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231183',4449004,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231183',4449005,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231183',4449006,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231183',4449007,'2851','430',32862.75,32965.27,102.52,31781.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','231183',4449008,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231190',4449145,'2843','429',85342.26,85342.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231190',4449146,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231190',4449147,'2845','429',46068.46,46068.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231190',4449148,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231190',4449149,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231190',4449150,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231190',4449151,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231190',4449152,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231190',4449153,'2851','430',32965.27,33064.21,98.94,30671.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','231190',4449154,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231226',4449666,'2843','429',85342.26,85759.58,417.32,68023.16,0.00,0.00,0.00,0.00,0.00),('5','184','958','231226',4449667,'2844','429',47590.24,47590.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231226',4449668,'2845','429',46068.46,46608.78,540.32,88072.16,0.00,0.00,0.00,0.00,0.00),('5','184','958','231226',4449669,'2846','429',28776.43,28776.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231226',4449670,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231226',4449671,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231226',4449672,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231226',4449673,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231226',4449674,'2851','430',33064.21,33160.67,96.46,29902.60,0.00,0.00,0.00,0.00,0.00),('5','184','960','231226',4449675,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231236',4449790,'2843','429',85759.58,87675.69,1916.11,312325.93,0.00,0.00,0.00,0.00,0.00),('5','184','958','231236',4449791,'2844','429',47590.24,47596.62,6.38,1039.94,0.00,0.00,0.00,0.00,0.00),('5','184','958','231236',4449792,'2845','429',46608.78,48429.63,1820.85,296798.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','231236',4449793,'2846','429',28776.43,30601.63,1825.20,297507.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','231236',4449794,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231236',4449795,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231236',4449796,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231236',4449797,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231236',4449798,'2851','430',33160.67,33219.74,59.07,18311.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','231236',4449799,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231247',4449952,'2843','429',87675.69,89634.94,1959.25,319357.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','231247',4449953,'2844','429',47596.62,47596.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231247',4449954,'2845','429',48429.63,50162.61,1732.98,282475.74,0.00,0.00,0.00,0.00,0.00),('5','184','958','231247',4449955,'2846','429',30601.63,31540.12,938.49,152973.87,0.00,0.00,0.00,0.00,0.00),('5','184','957','231247',4449956,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231247',4449957,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231247',4449958,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231247',4449959,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231247',4449960,'2851','430',33219.74,34896.80,1677.06,536659.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','231247',4449961,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231270',4450314,'2843','429',89634.94,90853.42,1218.48,198612.24,0.00,0.00,0.00,0.00,0.00),('5','184','958','231270',4450315,'2844','429',47596.62,47596.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231270',4450316,'2845','429',50162.61,51373.71,1211.10,197409.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','231270',4450317,'2846','429',31540.12,32367.21,827.09,134815.67,0.00,0.00,0.00,0.00,0.00),('5','184','957','231270',4450318,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231270',4450319,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231270',4450320,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231270',4450321,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231270',4450322,'2851','430',34896.80,35199.30,302.50,96800.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','231270',4450323,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231280',4450434,'2843','429',90853.42,92785.98,1932.56,315007.28,0.00,0.00,0.00,0.00,0.00),('5','184','958','231280',4450435,'2844','429',47596.62,48640.01,1043.39,170072.57,0.00,0.00,0.00,0.00,0.00),('5','184','958','231280',4450436,'2845','429',51373.71,52912.15,1538.44,250765.72,0.00,0.00,0.00,0.00,0.00),('5','184','958','231280',4450437,'2846','429',32367.21,33603.86,1236.65,201573.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','231280',4450438,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231280',4450439,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231280',4450440,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231280',4450441,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231280',4450442,'2851','430',35199.30,35349.86,150.56,48179.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','231280',4450443,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231462',4453199,'2843','429',92785.98,94812.81,2026.83,330373.29,0.00,0.00,0.00,0.00,0.00),('5','184','958','231462',4453200,'2844','429',48640.01,49770.43,1130.42,184258.46,0.00,0.00,0.00,0.00,0.00),('5','184','958','231462',4453201,'2845','429',52912.15,54157.50,1245.35,202992.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','231462',4453202,'2846','429',33603.86,34774.65,1170.79,190838.77,0.00,0.00,0.00,0.00,0.00),('5','184','957','231462',4453203,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231462',4453204,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231462',4453205,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231462',4453206,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231462',4453207,'2851','430',35349.86,35739.71,389.85,124752.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','231462',4453208,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','231794',4459392,'2843','429',94812.81,96765.67,1952.86,318316.18,0.00,0.00,0.00,0.00,0.00),('5','184','958','231794',4459393,'2844','429',49770.43,50291.48,521.05,84931.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','231794',4459394,'2845','429',54157.50,56020.46,1862.96,303662.48,0.00,0.00,0.00,0.00,0.00),('5','184','958','231794',4459395,'2846','429',34774.65,36153.28,1378.63,224716.69,0.00,0.00,0.00,0.00,0.00),('5','184','957','231794',4459396,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231794',4459397,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231794',4459398,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','231794',4459399,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','231794',4459400,'2851','430',35739.71,35870.95,131.24,41996.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','231794',4459401,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232096',4464849,'2843','429',96765.67,99245.28,2479.61,404176.43,0.00,0.00,0.00,0.00,0.00),('5','184','958','232096',4464850,'2844','429',50291.48,50291.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232096',4464851,'2845','429',56020.46,57867.39,1846.93,301049.59,0.00,0.00,0.00,0.00,0.00),('5','184','958','232096',4464852,'2846','429',36153.28,37976.95,1823.67,297258.21,0.00,0.00,0.00,0.00,0.00),('5','184','957','232096',4464853,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232096',4464854,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232096',4464855,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232096',4464856,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','232096',4464857,'2851','430',35870.95,36031.59,160.64,52529.28,0.00,0.00,0.00,0.00,0.00),('5','184','960','232096',4464858,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232280',4468196,'2843','429',99245.28,101328.11,2082.83,339501.29,0.00,0.00,0.00,0.00,0.00),('5','184','958','232280',4468197,'2844','429',50291.48,50906.87,615.39,100308.57,0.00,0.00,0.00,0.00,0.00),('5','184','958','232280',4468198,'2845','429',57867.39,59667.62,1800.23,293437.49,0.00,0.00,0.00,0.00,0.00),('5','184','958','232280',4468199,'2846','429',37976.95,39606.82,1629.87,265668.81,0.00,0.00,0.00,0.00,0.00),('5','184','957','232280',4468200,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232280',4468201,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232280',4468202,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232280',4468203,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','232280',4468204,'2851','430',36031.59,36332.01,300.42,98237.34,0.00,0.00,0.00,0.00,0.00),('5','184','960','232280',4468205,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232396',4469894,'2843','429',101328.11,103479.57,2151.46,350687.98,0.00,0.00,0.00,0.00,0.00),('5','184','958','232396',4469895,'2844','429',50906.87,51335.97,429.10,69943.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','232396',4469896,'2845','429',59667.62,61628.93,1961.31,319693.53,0.00,0.00,0.00,0.00,0.00),('5','184','958','232396',4469897,'2846','429',39606.82,41203.53,1596.71,260263.73,0.00,0.00,0.00,0.00,0.00),('5','184','957','232396',4469898,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232396',4469899,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232396',4469900,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232396',4469901,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','232396',4469902,'2851','430',36332.01,36515.21,183.20,59906.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','232396',4469903,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232848',4478236,'2843','429',103479.57,104364.89,885.32,144307.16,0.00,0.00,0.00,0.00,0.00),('5','184','958','232848',4478237,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232848',4478238,'2845','429',61628.93,62425.23,796.30,129796.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','232848',4478239,'2846','429',41203.53,41832.31,628.78,102491.14,0.00,0.00,0.00,0.00,0.00),('5','184','957','232848',4478240,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232848',4478241,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232848',4478242,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232848',4478243,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','232848',4478244,'2851','430',36515.21,36645.65,130.44,42653.88,0.00,0.00,0.00,0.00,0.00),('5','184','960','232848',4478245,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232975',4480595,'2843','429',104364.89,104933.13,568.24,92623.12,0.00,0.00,0.00,0.00,0.00),('5','184','958','232975',4480596,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','232975',4480597,'2845','429',62425.23,62908.40,483.17,78756.71,0.00,0.00,0.00,0.00,0.00),('5','184','958','232975',4480598,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232975',4480599,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232975',4480600,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232975',4480601,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','232975',4480602,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','232975',4480603,'2851','430',36645.65,36771.66,126.01,41583.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','232975',4480604,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233064',4482282,'2843','429',104933.13,105027.19,94.06,15331.78,0.00,0.00,0.00,0.00,0.00),('5','184','958','233064',4482283,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233064',4482284,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233064',4482285,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233064',4482286,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233064',4482287,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233064',4482288,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233064',4482289,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','233064',4482290,'2851','430',36771.66,36886.06,114.40,39468.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','233064',4482291,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233318',4486923,'2843','429',105027.19,105211.96,184.77,30117.51,0.00,0.00,0.00,0.00,0.00),('5','184','958','233318',4486924,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233318',4486925,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233318',4486926,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233318',4486927,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233318',4486928,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233318',4486929,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233318',4486930,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','233318',4486931,'2851','430',36886.06,36960.20,74.14,25578.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','233318',4486932,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233596',4491904,'2843','429',105211.96,105384.94,172.98,28195.74,0.00,0.00,0.00,0.00,0.00),('5','184','958','233596',4491905,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233596',4491906,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233596',4491907,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233596',4491908,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233596',4491909,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233596',4491910,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233596',4491911,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','233596',4491912,'2851','430',36960.20,37035.77,75.57,26071.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','233596',4491913,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233801',4495580,'2843','429',105384.94,105487.49,102.55,16715.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','233801',4495581,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233801',4495582,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','233801',4495583,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233801',4495584,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233801',4495585,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233801',4495586,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','233801',4495587,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','233801',4495588,'2851','430',37035.77,37089.74,53.97,18619.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','233801',4495589,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234006',4499257,'2843','429',105487.49,105578.46,90.97,14828.11,0.00,0.00,0.00,0.00,0.00),('5','184','958','234006',4499258,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234006',4499259,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234006',4499260,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234006',4499261,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234006',4499262,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234006',4499263,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234006',4499264,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','234006',4499265,'2851','430',37089.74,37261.10,171.36,59119.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','234006',4499266,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234342',4505150,'2843','429',105578.46,105678.04,99.58,16231.54,0.00,0.00,0.00,0.00,0.00),('5','184','958','234342',4505151,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234342',4505152,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234342',4505153,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234342',4505154,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234342',4505155,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234342',4505156,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234342',4505157,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','234342',4505158,'2851','430',37261.10,37314.74,53.64,18505.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','234342',4505159,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234503',4508145,'2843','429',105678.04,105678.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234503',4508146,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234503',4508147,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234503',4508148,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234503',4508149,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234503',4508150,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234503',4508151,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234503',4508152,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','234503',4508153,'2851','430',37314.74,37497.99,183.25,63221.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','234503',4508154,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234919',4515588,'2843','429',105678.04,105678.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234919',4515589,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234919',4515590,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','234919',4515591,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234919',4515592,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234919',4515593,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234919',4515594,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','234919',4515595,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','234919',4515596,'2851','430',37497.99,37599.99,102.00,35190.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','234919',4515597,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','235030',4517619,'2843','429',105678.04,105678.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','235030',4517620,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','235030',4517621,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','235030',4517622,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','235030',4517623,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','235030',4517624,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','235030',4517625,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','235030',4517626,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','235030',4517627,'2851','430',37599.99,37704.47,104.48,36045.60,0.00,0.00,0.00,0.00,0.00),('5','184','960','235030',4517628,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236116',4536604,'2843','429',105678.04,105678.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236116',4536605,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236116',4536606,'2845','429',62908.40,62908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236116',4536607,'2846','429',41832.31,41832.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236116',4536608,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236116',4536609,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236116',4536610,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236116',4536611,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236116',4536612,'2851','430',37704.47,37704.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','236116',4536613,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236120',4536654,'2843','429',105678.04,107934.12,2256.08,372253.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','236120',4536655,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236120',4536656,'2845','429',62908.40,65602.39,2693.99,444508.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','236120',4536657,'2846','429',41832.31,44174.67,2342.36,386489.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','236120',4536658,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236120',4536659,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236120',4536660,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236120',4536661,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236120',4536662,'2851','430',37704.47,37927.91,223.44,77086.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','236120',4536663,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236331',4540378,'2843','429',107934.12,108488.24,554.12,91429.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','236331',4540379,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236331',4540380,'2845','429',65602.39,67741.98,2139.59,353032.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','236331',4540381,'2846','429',44174.67,45729.15,1554.48,256489.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','236331',4540382,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236331',4540383,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236331',4540384,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236331',4540385,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236331',4540386,'2851','430',37927.91,38103.57,175.66,60602.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','236331',4540387,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236622',4545361,'2843','429',108488.24,110194.43,1706.19,281521.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','236622',4545362,'2844','429',51335.97,51335.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236622',4545363,'2845','429',67741.98,69266.48,1524.50,251542.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','236622',4545364,'2846','429',45729.15,45729.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236622',4545365,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236622',4545366,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236622',4545367,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236622',4545368,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236622',4545369,'2851','430',38103.57,38439.32,335.75,115833.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','236622',4545370,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236674',4546208,'2843','429',110194.43,110628.38,433.95,71601.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','236674',4546209,'2844','429',51335.97,53077.34,1741.37,287326.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','236674',4546210,'2845','429',69266.48,72178.91,2912.43,480550.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','236674',4546211,'2846','429',45729.15,47827.25,2098.10,346186.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','236674',4546212,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236674',4546213,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236674',4546214,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236674',4546215,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236674',4546216,'2851','430',38439.32,39079.00,639.68,220689.60,0.00,0.00,0.00,0.00,0.00),('5','184','960','236674',4546217,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236675',4546218,'2843','429',110628.38,113080.51,2452.13,404601.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','236675',4546219,'2844','429',53077.34,54365.39,1288.05,212528.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','236675',4546220,'2845','429',72178.91,74424.33,2245.42,370494.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','236675',4546221,'2846','429',47827.25,48117.62,290.37,47911.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','236675',4546222,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236675',4546223,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236675',4546224,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236675',4546225,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236675',4546226,'2851','430',39079.00,39936.72,857.72,295913.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','236675',4546227,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','236867',4549597,'2843','429',113080.51,117094.45,4013.94,662300.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','236867',4549598,'2844','429',54365.39,56723.21,2357.82,389040.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','236867',4549599,'2845','429',74424.33,78576.96,4152.63,685183.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','236867',4549600,'2846','429',48117.62,51050.43,2932.81,483913.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','236867',4549601,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236867',4549602,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236867',4549603,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','236867',4549604,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','236867',4549605,'2851','430',39936.72,40382.42,445.70,153766.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','236867',4549606,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237032',4552501,'2843','429',117094.45,122290.62,5196.17,857368.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','237032',4552502,'2844','429',56723.21,58633.09,1909.88,315130.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','237032',4552503,'2845','429',78576.96,83984.80,5407.84,892293.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','237032',4552504,'2846','429',51050.43,55270.67,4220.24,696339.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','237032',4552505,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237032',4552506,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237032',4552507,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237032',4552508,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237032',4552509,'2851','430',40382.42,40817.94,435.52,150254.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','237032',4552510,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237036',4552564,'2843','429',122290.62,123878.03,1587.41,261922.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','237036',4552565,'2844','429',58633.09,58633.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237036',4552566,'2845','429',83984.80,85505.51,1520.71,250917.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','237036',4552567,'2846','429',55270.67,56728.53,1457.86,240546.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','237036',4552568,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237036',4552569,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237036',4552570,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237036',4552571,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237036',4552572,'2851','430',40817.94,41095.31,277.37,95692.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','237036',4552573,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237345',4558326,'2843','429',123878.03,124444.24,566.21,93424.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','237345',4558327,'2844','429',58633.09,58633.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237345',4558328,'2845','429',85505.51,85505.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237345',4558329,'2846','429',56728.53,56728.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237345',4558330,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237345',4558331,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237345',4558332,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237345',4558333,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237345',4558334,'2851','430',41095.31,41409.82,314.51,108505.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','237345',4558335,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237634',4563159,'2843','429',124444.24,125048.75,604.51,99744.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','237634',4563160,'2844','429',58633.09,58633.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237634',4563161,'2845','429',85505.51,85505.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237634',4563162,'2846','429',56728.53,56728.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237634',4563163,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237634',4563164,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237634',4563165,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237634',4563166,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237634',4563167,'2851','430',41409.82,41523.59,113.77,39250.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','237634',4563168,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237729',4564969,'2843','429',125048.75,125048.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237729',4564970,'2844','429',58633.09,58633.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237729',4564971,'2845','429',85505.51,85505.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237729',4564972,'2846','429',56728.53,56728.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237729',4564973,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237729',4564974,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237729',4564975,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237729',4564976,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237729',4564977,'2851','430',41523.59,41523.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','237729',4564978,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237982',4568946,'2843','429',125048.75,129214.95,4166.20,687423.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','237982',4568947,'2844','429',58633.09,60767.26,2134.17,352138.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','237982',4568948,'2845','429',85505.51,89480.03,3974.52,655795.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','237982',4568949,'2846','429',56728.53,60228.08,3499.55,577425.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','237982',4568950,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237982',4568951,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237982',4568952,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','237982',4568953,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','237982',4568954,'2851','430',41523.59,42200.77,677.18,233627.10,0.00,0.00,0.00,0.00,0.00),('5','184','960','237982',4568955,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','238433',4576590,'2843','429',129214.95,132832.63,3617.68,596917.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','238433',4576591,'2844','429',60767.26,61806.96,1039.70,171550.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','238433',4576592,'2845','429',89480.03,93190.28,3710.25,612191.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','238433',4576593,'2846','429',60228.08,63279.96,3051.88,503560.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','238433',4576594,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238433',4576595,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238433',4576596,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238433',4576597,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','238433',4576598,'2851','430',42200.77,42825.62,624.85,215573.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','238433',4576599,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','238437',4576629,'2843','429',132832.63,136342.33,3509.70,579100.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','238437',4576630,'2844','429',61806.96,64247.38,2440.42,402669.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','238437',4576631,'2845','429',93190.28,96827.13,3636.85,600080.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','238437',4576632,'2846','429',63279.96,64366.03,1086.07,179201.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','238437',4576633,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238437',4576634,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238437',4576635,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238437',4576636,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','238437',4576637,'2851','430',42825.62,43332.27,506.65,174794.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','238437',4576638,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','238695',4581096,'2843','429',136342.33,141217.20,4874.87,804353.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','238695',4581097,'2844','429',64247.38,65022.20,774.82,127845.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','238695',4581098,'2845','429',96827.13,101093.46,4266.33,703944.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','238695',4581099,'2846','429',64366.03,67553.81,3187.78,525983.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','238695',4581100,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238695',4581101,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238695',4581102,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','238695',4581103,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','238695',4581104,'2851','430',43332.27,43718.85,386.58,133370.10,0.00,0.00,0.00,0.00,0.00),('5','184','960','238695',4581105,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239036',4587287,'2843','429',141217.20,145723.15,4505.95,743481.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','239036',4587288,'2844','429',65022.20,67873.71,2851.51,470499.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','239036',4587289,'2845','429',101093.46,105175.20,4081.74,673487.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','239036',4587290,'2846','429',67553.81,71711.36,4157.55,685995.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','239036',4587291,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239036',4587292,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239036',4587293,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239036',4587294,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','239036',4587295,'2851','430',43718.85,44072.26,353.41,121926.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','239036',4587296,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239137',4588947,'2843','429',145723.15,147135.12,1411.97,232975.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','239137',4588948,'2844','429',67873.71,67873.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239137',4588949,'2845','429',105175.20,106126.48,951.28,156961.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','239137',4588950,'2846','429',71711.36,72836.20,1124.84,185598.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','239137',4588951,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239137',4588952,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239137',4588953,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239137',4588954,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','239137',4588955,'2851','430',44072.26,44465.74,393.48,135750.60,0.00,0.00,0.00,0.00,0.00),('5','184','960','239137',4588956,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239370',4592827,'2843','429',147135.12,147857.91,722.79,119260.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','239370',4592828,'2844','429',67873.71,67873.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239370',4592829,'2845','429',106126.48,106126.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239370',4592830,'2846','429',72836.20,72836.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239370',4592831,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239370',4592832,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239370',4592833,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239370',4592834,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','239370',4592835,'2851','430',44465.74,45412.16,946.42,326514.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','239370',4592836,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239604',4596868,'2843','429',147857.91,148586.52,728.61,120220.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','239604',4596869,'2844','429',67873.71,67873.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239604',4596870,'2845','429',106126.48,106391.61,265.13,43746.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','239604',4596871,'2846','429',72836.20,73812.58,976.38,161102.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','239604',4596872,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239604',4596873,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239604',4596874,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239604',4596875,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','239604',4596876,'2851','430',45412.16,46396.86,984.70,339721.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','239604',4596877,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239881',4601677,'2843','429',148586.52,152323.62,3737.10,616621.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','239881',4601678,'2844','429',67873.71,67873.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','239881',4601679,'2845','429',106391.61,109345.50,2953.89,487391.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','239881',4601680,'2846','429',73812.58,77202.06,3389.48,559264.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','239881',4601681,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239881',4601682,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239881',4601683,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','239881',4601684,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','239881',4601685,'2851','430',46396.86,46929.51,532.65,183764.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','239881',4601686,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','240084',4605268,'2843','429',152323.62,155057.06,2733.44,451017.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','240084',4605269,'2844','429',67873.71,68360.91,487.20,80388.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','240084',4605270,'2845','429',109345.50,111799.55,2454.05,404918.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','240084',4605271,'2846','429',77202.06,79751.04,2548.98,420581.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','240084',4605272,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240084',4605273,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240084',4605274,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240084',4605275,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','240084',4605276,'2851','430',46929.51,47431.37,501.86,173141.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','240084',4605277,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','240283',4608789,'2843','429',155057.06,157688.50,2631.44,434187.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','240283',4608790,'2844','429',68360.91,69542.62,1181.71,194982.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','240283',4608791,'2845','429',111799.55,114453.32,2653.77,437872.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','240283',4608792,'2846','429',79751.04,81833.11,2082.07,343541.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','240283',4608793,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240283',4608794,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240283',4608795,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240283',4608796,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','240283',4608797,'2851','430',47431.37,47431.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','240283',4608798,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','240681',4614866,'2843','429',157688.50,160616.56,2928.06,483129.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','240681',4614867,'2844','429',69542.62,70582.32,1039.70,171550.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','240681',4614868,'2845','429',114453.32,117144.85,2691.53,444102.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','240681',4614869,'2846','429',81833.11,84454.36,2621.25,432506.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','240681',4614870,'2847','429',74127.14,74127.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240681',4614871,'2848','429',65722.59,65722.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240681',4614872,'2849','429',29969.26,29969.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','240681',4614873,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','240681',4614874,'2851','430',47431.37,48654.60,1223.23,422014.35,0.00,0.00,0.00,0.00,0.00),('5','184','960','240681',4614875,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','240771',4616292,'2843','429',160616.56,163747.06,3130.50,516532.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','240771',4616293,'2844','429',70582.32,71193.11,610.79,100780.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','240771',4616294,'2845','429',117144.85,119241.54,2096.69,345953.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','240771',4616295,'2846','429',84454.36,86134.86,1680.50,277282.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','240771',4616296,'2847','429',74127.14,75106.87,979.73,161655.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','240771',4616297,'2848','429',65722.59,66856.00,1133.41,187012.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','240771',4616298,'2849','429',29969.26,30702.60,733.34,121001.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','240771',4616299,'2850','429',31074.23,31074.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','240771',4616300,'2851','430',48654.60,49258.17,603.57,208231.65,0.00,0.00,0.00,0.00,0.00),('5','184','960','240771',4616301,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241086',4622054,'2843','429',163747.06,163747.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241086',4622055,'2844','429',71193.11,71193.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241086',4622056,'2845','429',119241.54,119241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241086',4622057,'2846','429',86134.86,86134.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','241086',4622058,'2847','429',75106.87,78894.23,3787.36,624914.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','241086',4622059,'2848','429',66856.00,69445.27,2589.27,427229.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','241086',4622060,'2849','429',30702.60,32992.36,2289.76,377810.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','241086',4622061,'2850','429',31074.23,32897.84,1823.61,300895.65,0.00,0.00,0.00,0.00,0.00),('5','184','959','241086',4622062,'2851','430',49258.17,50115.78,857.61,295875.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','241086',4622063,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241345',4626526,'2843','429',163747.06,163747.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241345',4626527,'2844','429',71193.11,71193.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241345',4626528,'2845','429',119241.54,119241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241345',4626529,'2846','429',86134.86,86134.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','241345',4626530,'2847','429',78894.23,82246.24,3352.01,553081.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','241345',4626531,'2848','429',69445.27,72309.81,2864.54,472649.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','241345',4626532,'2849','429',32992.36,35821.63,2829.27,466829.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','241345',4626533,'2850','429',32897.84,34850.06,1952.22,322116.30,0.00,0.00,0.00,0.00,0.00),('5','184','959','241345',4626534,'2851','430',50115.78,51762.99,1647.21,568287.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','241345',4626535,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241588',4630700,'2843','429',163747.06,163747.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241588',4630701,'2844','429',71193.11,71193.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241588',4630702,'2845','429',119241.54,119241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241588',4630703,'2846','429',86134.86,86134.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','241588',4630704,'2847','429',82246.24,86988.28,4742.04,782436.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','241588',4630705,'2848','429',72309.81,76043.84,3734.03,616114.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','241588',4630706,'2849','429',35821.63,39152.26,3330.63,549553.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','241588',4630707,'2850','429',34850.06,37565.60,2715.54,448064.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','241588',4630708,'2851','430',51762.99,51762.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','241588',4630709,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241845',4635031,'2843','429',163747.06,163747.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241845',4635032,'2844','429',71193.11,71193.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241845',4635033,'2845','429',119241.54,119241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','241845',4635034,'2846','429',86134.86,86134.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','241845',4635035,'2847','429',86988.28,87663.42,675.14,111398.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','241845',4635036,'2848','429',76043.84,77093.85,1050.01,173251.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','241845',4635037,'2849','429',39152.26,39797.52,645.26,106467.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','241845',4635038,'2850','429',37565.60,37943.18,377.58,62300.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','241845',4635039,'2851','430',51762.99,51848.09,85.10,29359.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','241845',4635040,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','242133',4640196,'2843','429',163747.06,166250.40,2503.34,413051.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','242133',4640197,'2844','429',71193.11,71193.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','242133',4640198,'2845','429',119241.54,121881.09,2639.55,435525.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','242133',4640199,'2846','429',86134.86,88580.02,2445.16,403451.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','242133',4640200,'2847','429',87663.42,88889.58,1226.16,202316.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','242133',4640201,'2848','429',77093.85,77835.41,741.56,122357.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','242133',4640202,'2849','429',39797.52,40642.78,845.26,139467.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','242133',4640203,'2850','429',37943.18,37992.14,48.96,8078.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','242133',4640204,'2851','430',51848.09,52134.42,286.33,98783.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','242133',4640205,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','242396',4645014,'2843','429',166250.40,170588.76,4338.36,715829.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','242396',4645015,'2844','429',71193.11,72104.30,911.19,150346.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','242396',4645016,'2845','429',121881.09,125599.49,3718.40,613536.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','242396',4645017,'2846','429',88580.02,91704.56,3124.54,515549.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','242396',4645018,'2847','429',88889.58,88889.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242396',4645019,'2848','429',77835.41,77835.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242396',4645020,'2849','429',40642.78,40642.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242396',4645021,'2850','429',37992.14,37992.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','242396',4645022,'2851','430',52134.42,52671.58,537.16,185320.20,0.00,0.00,0.00,0.00,0.00),('5','184','960','242396',4645023,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','242615',4648772,'2843','429',170588.76,175192.41,4603.65,759602.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','242615',4648773,'2844','429',72104.30,75564.39,3460.09,570914.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','242615',4648774,'2845','429',125599.49,128666.20,3066.71,506007.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','242615',4648775,'2846','429',91704.56,95059.13,3354.57,553504.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','242615',4648776,'2847','429',88889.58,88889.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242615',4648777,'2848','429',77835.41,77835.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242615',4648778,'2849','429',40642.78,40642.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','242615',4648779,'2850','429',37992.14,37992.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','242615',4648780,'2851','430',52671.58,53339.72,668.14,230508.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','242615',4648781,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243003',4655269,'2843','429',175192.41,176333.24,1140.83,188236.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','243003',4655270,'2844','429',75564.39,76179.57,615.18,101504.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','243003',4655271,'2845','429',128666.20,129714.20,1048.00,172920.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243003',4655272,'2846','429',95059.13,95661.52,602.39,99394.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','243003',4655273,'2847','429',88889.58,88889.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243003',4655274,'2848','429',77835.41,77835.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243003',4655275,'2849','429',40642.78,40642.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243003',4655276,'2850','429',37992.14,37992.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','243003',4655277,'2851','430',53339.72,53883.03,543.31,187441.95,0.00,0.00,0.00,0.00,0.00),('5','184','960','243003',4655278,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243094',4657223,'2843','429',176333.24,178603.10,2269.86,374526.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','243094',4657224,'2844','429',76179.57,76179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243094',4657225,'2845','429',129714.20,129714.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243094',4657226,'2846','429',95661.52,95661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243094',4657227,'2847','429',88889.58,90932.82,2043.24,337134.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','243094',4657228,'2848','429',77835.41,79051.91,1216.50,200722.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','243094',4657229,'2849','429',40642.78,40695.15,52.37,8641.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','243094',4657230,'2850','429',37992.14,39976.28,1984.14,327383.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','243094',4657231,'2851','430',53883.03,54633.17,750.14,258798.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','243094',4657232,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243473',4663667,'2843','429',178603.10,178603.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243473',4663668,'2844','429',76179.57,76179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243473',4663669,'2845','429',129714.20,129714.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243473',4663670,'2846','429',95661.52,95661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243473',4663671,'2847','429',90932.82,95309.38,4376.56,722132.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','243473',4663672,'2848','429',79051.91,82840.19,3788.28,625066.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','243473',4663673,'2849','429',40695.15,43753.63,3058.48,504649.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','243473',4663674,'2850','429',39976.28,42628.72,2652.44,437652.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','243473',4663675,'2851','430',54633.17,55306.25,673.08,232212.60,0.00,0.00,0.00,0.00,0.00),('5','184','960','243473',4663676,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243806',4669654,'2843','429',178603.10,178603.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243806',4669655,'2844','429',76179.57,76179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243806',4669656,'2845','429',129714.20,129714.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243806',4669657,'2846','429',95661.52,95661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','243806',4669658,'2847','429',95309.38,99970.21,4660.83,769036.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','243806',4669659,'2848','429',82840.19,86591.77,3751.58,619010.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','243806',4669660,'2849','429',43753.63,47636.10,3882.47,640607.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','243806',4669661,'2850','429',42628.72,43931.50,1302.78,214958.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','243806',4669662,'2851','430',55306.25,55746.77,440.52,151979.40,0.00,0.00,0.00,0.00,0.00),('5','184','960','243806',4669663,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243963',4672175,'2843','429',178603.10,179140.43,537.33,88659.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','243963',4672176,'2844','429',76179.57,76179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243963',4672177,'2845','429',129714.20,129714.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','243963',4672178,'2846','429',95661.52,95977.43,315.91,52125.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','243963',4672179,'2847','429',99970.21,104028.18,4057.97,669565.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','243963',4672180,'2848','429',86591.77,89756.14,3164.37,522121.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','243963',4672181,'2849','429',47636.10,50885.24,3249.14,536108.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','243963',4672182,'2850','429',43931.50,45380.65,1449.15,239109.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','243963',4672183,'2851','430',55746.77,56139.23,392.46,135398.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','243963',4672184,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244156',4675412,'2843','429',179140.43,183102.55,3962.12,653749.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','244156',4675413,'2844','429',76179.57,76179.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244156',4675414,'2845','429',129714.20,134947.71,5233.51,863529.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','244156',4675415,'2846','429',95977.43,100395.87,4418.44,729042.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','244156',4675416,'2847','429',104028.18,104032.09,3.91,645.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','244156',4675417,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244156',4675418,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244156',4675419,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','244156',4675420,'2851','430',56139.23,56601.70,462.47,159552.15,0.00,0.00,0.00,0.00,0.00),('5','184','960','244156',4675421,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244287',4677676,'2843','429',183102.55,188200.70,5098.15,841194.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','244287',4677677,'2844','429',76179.57,80016.68,3837.11,633123.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','244287',4677678,'2845','429',134947.71,140635.89,5688.18,938549.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','244287',4677679,'2846','429',100395.87,104576.51,4180.64,689805.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','244287',4677680,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244287',4677681,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244287',4677682,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244287',4677683,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','244287',4677684,'2851','430',56601.70,57023.52,421.82,145527.90,0.00,0.00,0.00,0.00,0.00),('5','184','960','244287',4677685,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244575',4682481,'2843','429',188200.70,190003.11,1802.41,297397.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','244575',4682482,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244575',4682483,'2845','429',140635.89,142729.08,2093.19,345376.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','244575',4682484,'2846','429',104576.51,105891.03,1314.52,216895.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','244575',4682485,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244575',4682486,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244575',4682487,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244575',4682488,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','244575',4682489,'2851','430',57023.52,57706.37,682.85,235583.25,0.00,0.00,0.00,0.00,0.00),('5','184','960','244575',4682490,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244823',4686949,'2843','429',190003.11,190387.10,383.99,63358.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','244823',4686950,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','244823',4686951,'2845','429',142729.08,143117.78,388.70,64135.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','244823',4686952,'2846','429',105891.03,106206.08,315.05,51983.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','244823',4686953,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244823',4686954,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244823',4686955,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','244823',4686956,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','244823',4686957,'2851','430',57706.37,60230.87,2524.50,870952.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','244823',4686958,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245513',4698872,'2843','429',190387.10,190698.69,311.59,51412.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','245513',4698873,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245513',4698874,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245513',4698875,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245513',4698876,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245513',4698877,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245513',4698878,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245513',4698879,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','245513',4698880,'2851','430',60230.87,60714.81,483.94,166959.30,0.00,0.00,0.00,0.00,0.00),('5','184','960','245513',4698881,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245783',4703666,'2843','429',190698.69,190753.07,54.38,8972.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','245783',4703667,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245783',4703668,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','245783',4703669,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245783',4703670,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245783',4703671,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245783',4703672,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','245783',4703673,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','245783',4703674,'2851','430',60714.81,61358.02,643.21,221907.45,0.00,0.00,0.00,0.00,0.00),('5','184','960','245783',4703675,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246114',4708871,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246114',4708872,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246114',4708873,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246114',4708874,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246114',4708875,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246114',4708876,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246114',4708877,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246114',4708878,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','246114',4708879,'2851','430',61358.02,61864.31,506.29,174670.05,0.00,0.00,0.00,0.00,0.00),('5','184','960','246114',4708880,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246351',4712659,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246351',4712660,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246351',4712661,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246351',4712662,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246351',4712663,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246351',4712664,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246351',4712665,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246351',4712666,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','246351',4712667,'2851','430',61864.31,61864.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','246351',4712668,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246451',4714478,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246451',4714479,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246451',4714480,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246451',4714481,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246451',4714482,'2847','429',104032.09,104032.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246451',4714483,'2848','429',89756.14,89756.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246451',4714484,'2849','429',50885.24,50885.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246451',4714485,'2850','429',45380.65,45380.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','246451',4714486,'2851','430',61864.31,62717.97,853.66,294512.70,0.00,0.00,0.00,0.00,0.00),('5','184','960','246451',4714487,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246544',4716124,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246544',4716125,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246544',4716126,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246544',4716127,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246544',4716128,'2847','429',104032.09,109319.44,5287.35,872412.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','246544',4716129,'2848','429',89756.14,94220.72,4464.58,736655.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','246544',4716130,'2849','429',50885.24,55256.65,4371.41,721282.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','246544',4716131,'2850','429',45380.65,46993.98,1613.33,266199.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','246544',4716132,'2851','430',62717.97,63805.32,1087.35,375135.75,0.00,0.00,0.00,0.00,0.00),('5','184','960','246544',4716133,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246598',4717166,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246598',4717167,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246598',4717168,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246598',4717169,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246598',4717170,'2847','429',109319.44,113083.45,3764.01,621061.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','246598',4717171,'2848','429',94220.72,97563.80,3343.08,551608.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','246598',4717172,'2849','429',55256.65,58704.47,3447.82,568890.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','246598',4717173,'2850','429',46993.98,47930.96,936.98,154601.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','246598',4717174,'2851','430',63805.32,64293.02,487.70,168256.50,0.00,0.00,0.00,0.00,0.00),('5','184','960','246598',4717175,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246622',4717636,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246622',4717637,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246622',4717638,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246622',4717639,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246622',4717640,'2847','429',113083.45,113640.54,557.09,91919.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','246622',4717641,'2848','429',97563.80,97932.82,369.02,60888.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','246622',4717642,'2849','429',58704.47,58809.58,105.11,17343.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','246622',4717643,'2850','429',47930.96,48428.49,497.53,82092.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','246622',4717644,'2851','430',64293.02,65140.89,847.87,292515.15,0.00,0.00,0.00,0.00,0.00),('5','184','960','246622',4717645,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246798',4720489,'2843','429',190753.07,190753.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246798',4720490,'2844','429',80016.68,80016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246798',4720491,'2845','429',143117.78,143117.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','246798',4720492,'2846','429',106206.08,106206.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246798',4720493,'2847','429',113640.54,114392.31,751.77,124042.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','246798',4720494,'2848','429',97932.82,98248.53,315.71,52092.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','246798',4720495,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','246798',4720496,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','246798',4720497,'2851','430',65140.89,66000.93,860.04,296713.80,0.00,0.00,0.00,0.00,0.00),('5','184','960','246798',4720498,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247105',4725907,'2843','429',190753.07,193937.06,3183.99,525358.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','247105',4725908,'2844','429',80016.68,82339.72,2323.04,383301.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','247105',4725909,'2845','429',143117.78,146855.38,3737.60,616704.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247105',4725910,'2846','429',106206.08,107625.66,1419.58,234230.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','247105',4725911,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247105',4725912,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247105',4725913,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247105',4725914,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','247105',4725915,'2851','430',66000.93,66765.86,764.93,263900.85,0.00,0.00,0.00,0.00,0.00),('5','184','960','247105',4725916,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247578',4734012,'2843','429',193937.06,195501.10,1564.04,258066.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','247578',4734013,'2844','429',82339.72,82339.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247578',4734014,'2845','429',146855.38,147319.25,463.87,76538.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','247578',4734015,'2846','429',107625.66,107625.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247578',4734016,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247578',4734017,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247578',4734018,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247578',4734019,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','247578',4734020,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','247578',4734021,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247728',4736590,'2843','429',195501.10,195855.28,354.18,58439.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','247728',4736591,'2844','429',82339.72,82339.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247728',4736592,'2845','429',147319.25,148099.25,780.00,128700.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','247728',4736593,'2846','429',107625.66,107625.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247728',4736594,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247728',4736595,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247728',4736596,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','247728',4736597,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','247728',4736598,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','247728',4736599,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248001',4741186,'2843','429',195855.28,199180.27,3324.99,548623.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','248001',4741187,'2844','429',82339.72,84571.71,2231.99,368278.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','248001',4741188,'2845','429',148099.25,152180.27,4081.02,673368.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','248001',4741189,'2846','429',107625.66,110304.79,2679.13,442056.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','248001',4741190,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248001',4741191,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248001',4741192,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248001',4741193,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','248001',4741194,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','248001',4741195,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248443',4748444,'2843','429',199180.27,200185.59,1005.32,165877.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','248443',4748445,'2844','429',84571.71,84571.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248443',4748446,'2845','429',152180.27,152819.14,638.87,105413.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','248443',4748447,'2846','429',110304.79,110304.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248443',4748448,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248443',4748449,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248443',4748450,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248443',4748451,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','248443',4748452,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','248443',4748453,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248519',4750066,'2843','429',200185.59,201283.01,1097.42,181074.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','248519',4750067,'2844','429',84571.71,84571.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248519',4750068,'2845','429',152819.14,152819.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248519',4750069,'2846','429',110304.79,110304.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248519',4750070,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248519',4750071,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248519',4750072,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248519',4750073,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','248519',4750074,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','248519',4750075,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248740',4753714,'2843','429',201283.01,203659.04,2376.03,392044.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','248740',4753715,'2844','429',84571.71,84571.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','248740',4753716,'2845','429',152819.14,156381.70,3562.56,587822.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','248740',4753717,'2846','429',110304.79,111640.11,1335.32,220327.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','248740',4753718,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248740',4753719,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248740',4753720,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','248740',4753721,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','248740',4753722,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','248740',4753723,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249201',4761291,'2843','429',203659.04,203659.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249201',4761292,'2844','429',84571.71,85958.39,1386.68,228802.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','249201',4761293,'2845','429',156381.70,159204.08,2822.38,465692.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','249201',4761294,'2846','429',111640.11,113688.65,2048.54,338009.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','249201',4761295,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249201',4761296,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249201',4761297,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249201',4761298,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','249201',4761299,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','249201',4761300,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249434',4765389,'2843','429',203659.04,206540.97,2881.93,475518.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','249434',4765390,'2844','429',85958.39,87612.94,1654.55,273000.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','249434',4765391,'2845','429',159204.08,161080.12,1876.04,309546.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','249434',4765392,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249434',4765393,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249434',4765394,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249434',4765395,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249434',4765396,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','249434',4765397,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','249434',4765398,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249661',4769130,'2843','429',206540.97,209570.07,3029.10,499801.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','249661',4769131,'2844','429',87612.94,89132.85,1519.91,250785.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','249661',4769132,'2845','429',161080.12,161080.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249661',4769133,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249661',4769134,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249661',4769135,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249661',4769136,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249661',4769137,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','249661',4769138,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','249661',4769139,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249702',4769737,'2843','429',209570.07,210698.50,1128.43,186190.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','249702',4769738,'2844','429',89132.85,89132.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249702',4769739,'2845','429',161080.12,163214.85,2134.73,352230.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','249702',4769740,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249702',4769741,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249702',4769742,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249702',4769743,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249702',4769744,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','249702',4769745,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','249702',4769746,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','249716',4770090,'2843','429',210698.50,211114.04,415.54,68564.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','249716',4770091,'2844','429',89132.85,90067.35,934.50,154192.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','249716',4770092,'2845','429',163214.85,163952.15,737.30,121654.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','249716',4770093,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249716',4770094,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249716',4770095,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249716',4770096,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','249716',4770097,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','249716',4770098,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','249716',4770099,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250184',4778015,'2843','429',211114.04,211692.55,578.51,95454.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','250184',4778016,'2844','429',90067.35,90067.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250184',4778017,'2845','429',163952.15,163952.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250184',4778018,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250184',4778019,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250184',4778020,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250184',4778021,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250184',4778022,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','250184',4778023,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','250184',4778024,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250440',4782146,'2843','429',211692.55,211692.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250440',4782147,'2844','429',90067.35,90067.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250440',4782148,'2845','429',163952.15,163952.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250440',4782149,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250440',4782150,'2847','429',114392.31,114392.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250440',4782151,'2848','429',98248.53,98248.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250440',4782152,'2849','429',58809.58,58809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250440',4782153,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','250440',4782154,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','250440',4782155,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250493',4783140,'2843','429',211692.55,211692.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250493',4783141,'2844','429',90067.35,90067.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250493',4783142,'2845','429',163952.15,163952.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250493',4783143,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250493',4783144,'2847','429',114392.31,117653.51,3261.20,538098.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250493',4783145,'2848','429',98248.53,100774.20,2525.67,416735.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','250493',4783146,'2849','429',58809.58,61900.26,3090.68,509962.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','250493',4783147,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','250493',4783148,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','250493',4783149,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250713',4786903,'2843','429',211692.55,211692.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250713',4786904,'2844','429',90067.35,90067.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250713',4786905,'2845','429',163952.15,163952.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','250713',4786906,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','250713',4786907,'2847','429',117653.51,120954.23,3300.72,544618.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','250713',4786908,'2848','429',100774.20,104118.43,3344.23,551797.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','250713',4786909,'2849','429',61900.26,64689.75,2789.49,460265.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','250713',4786910,'2850','429',48428.49,48428.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','250713',4786911,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','250713',4786912,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251130',4794292,'2843','429',211692.55,211692.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251130',4794293,'2844','429',90067.35,90067.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251130',4794294,'2845','429',163952.15,163952.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251130',4794295,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251130',4794296,'2847','429',120954.23,123536.21,2581.98,426026.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','251130',4794297,'2848','429',104118.43,106500.04,2381.61,392965.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','251130',4794298,'2849','429',64689.75,67461.11,2771.36,457274.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','251130',4794299,'2850','429',48428.49,51310.83,2882.34,475586.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','251130',4794300,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','251130',4794301,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251375',4798509,'2843','429',211692.55,213484.34,1791.79,295645.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','251375',4798510,'2844','429',90067.35,90992.97,925.62,152727.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','251375',4798511,'2845','429',163952.15,166138.07,2185.92,360676.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','251375',4798512,'2846','429',113688.65,113688.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251375',4798513,'2847','429',123536.21,126592.24,3056.03,504244.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','251375',4798514,'2848','429',106500.04,108800.15,2300.11,379518.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','251375',4798515,'2849','429',67461.11,70399.37,2938.26,484812.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','251375',4798516,'2850','429',51310.83,53818.13,2507.30,413704.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','251375',4798517,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','251375',4798518,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251635',4803004,'2843','429',213484.34,218302.80,4818.46,795045.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','251635',4803005,'2844','429',90992.97,93995.56,3002.59,495427.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','251635',4803006,'2845','429',166138.07,170874.86,4736.79,781570.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','251635',4803007,'2846','429',113688.65,117453.74,3765.09,621239.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','251635',4803008,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251635',4803009,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251635',4803010,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251635',4803011,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','251635',4803012,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','251635',4803013,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','251857',4806877,'2843','429',218302.80,221590.99,3288.19,542551.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','251857',4806878,'2844','429',93995.56,96854.97,2859.41,471802.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','251857',4806879,'2845','429',170874.86,174465.16,3590.30,592399.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','251857',4806880,'2846','429',117453.74,118344.78,891.04,147021.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','251857',4806881,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251857',4806882,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251857',4806883,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','251857',4806884,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','251857',4806885,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','251857',4806886,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252091',4811062,'2843','429',221590.99,222630.25,1039.26,171477.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','252091',4811063,'2844','429',96854.97,97758.79,903.82,149130.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','252091',4811064,'2845','429',174465.16,175709.85,1244.69,205373.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','252091',4811065,'2846','429',118344.78,119359.98,1015.20,167508.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252091',4811066,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252091',4811067,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252091',4811068,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252091',4811069,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','252091',4811070,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','252091',4811071,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252374',4816002,'2843','429',222630.25,223429.69,799.44,131907.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','252374',4816003,'2844','429',97758.79,97758.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252374',4816004,'2845','429',175709.85,175985.99,276.14,45563.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','252374',4816005,'2846','429',119359.98,120302.13,942.15,155454.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','252374',4816006,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252374',4816007,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252374',4816008,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252374',4816009,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','252374',4816010,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','252374',4816011,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252602',4820067,'2843','429',223429.69,224054.73,625.04,103131.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','252602',4820068,'2844','429',97758.79,97758.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252602',4820069,'2845','429',175985.99,176629.99,644.00,106260.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252602',4820070,'2846','429',120302.13,120302.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252602',4820071,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252602',4820072,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252602',4820073,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252602',4820074,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','252602',4820075,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','252602',4820076,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252821',4823623,'2843','429',224054.73,224411.87,357.14,58928.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','252821',4823624,'2844','429',97758.79,97758.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','252821',4823625,'2845','429',176629.99,177284.98,654.99,108073.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','252821',4823626,'2846','429',120302.13,122662.66,2360.53,389487.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','252821',4823627,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252821',4823628,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252821',4823629,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','252821',4823630,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','252821',4823631,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','252821',4823632,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','253047',4827366,'2843','429',224411.87,228666.82,4254.95,702066.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','253047',4827367,'2844','429',97758.79,99212.01,1453.22,239781.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','253047',4827368,'2845','429',177284.98,181025.59,3740.61,617200.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','253047',4827369,'2846','429',122662.66,124311.07,1648.41,271987.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','253047',4827370,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253047',4827371,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253047',4827372,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253047',4827373,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','253047',4827374,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','253047',4827375,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','253184',4830001,'2843','429',228666.82,232013.62,3346.80,552222.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','253184',4830002,'2844','429',99212.01,101059.88,1847.87,304898.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','253184',4830003,'2845','429',181025.59,184124.64,3099.05,511343.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','253184',4830004,'2846','429',124311.07,127071.02,2759.95,455391.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','253184',4830005,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253184',4830006,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253184',4830007,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253184',4830008,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','253184',4830009,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','253184',4830010,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','253380',4832974,'2843','429',232013.62,234420.89,2407.27,397199.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','253380',4832975,'2844','429',101059.88,101059.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','253380',4832976,'2845','429',184124.64,187127.28,3002.64,495435.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','253380',4832977,'2846','429',127071.02,129126.08,2055.06,339084.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','253380',4832978,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253380',4832979,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253380',4832980,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','253380',4832981,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','253380',4832982,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','253380',4832983,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254104',4845799,'2843','429',234420.89,235389.38,968.49,159800.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','254104',4845800,'2844','429',101059.88,102342.63,1282.75,211653.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','254104',4845801,'2845','429',187127.28,188483.85,1356.57,223834.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','254104',4845802,'2846','429',129126.08,130188.73,1062.65,175337.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','254104',4845803,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254104',4845804,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254104',4845805,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254104',4845806,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254104',4845807,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254104',4845808,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254120',4846035,'2843','429',235389.38,235765.42,376.04,62046.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','254120',4846036,'2844','429',102342.63,102342.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254120',4846037,'2845','429',188483.85,189554.76,1070.91,176700.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','254120',4846038,'2846','429',130188.73,131127.90,939.17,154963.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','254120',4846039,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254120',4846040,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254120',4846041,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254120',4846042,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254120',4846043,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254120',4846044,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254129',4846298,'2843','429',235765.42,237275.35,1509.93,249138.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','254129',4846299,'2844','429',102342.63,104262.44,1919.81,316768.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','254129',4846300,'2845','429',189554.76,191720.17,2165.41,357292.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','254129',4846301,'2846','429',131127.90,133044.55,1916.65,316247.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','254129',4846302,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254129',4846303,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254129',4846304,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254129',4846305,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254129',4846306,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254129',4846307,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254399',4850947,'2843','429',237275.35,238875.07,1599.72,263953.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','254399',4850948,'2844','429',104262.44,104895.65,633.21,104479.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','254399',4850949,'2845','429',191720.17,193273.88,1553.71,256362.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','254399',4850950,'2846','429',133044.55,134226.05,1181.50,194947.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','254399',4850951,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254399',4850952,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254399',4850953,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254399',4850954,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254399',4850955,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254399',4850956,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254698',4856067,'2843','429',238875.07,239534.63,659.56,108827.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','254698',4856068,'2844','429',104895.65,104895.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254698',4856069,'2845','429',193273.88,194486.12,1212.24,200019.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','254698',4856070,'2846','429',134226.05,135494.67,1268.62,209322.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','254698',4856071,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254698',4856072,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254698',4856073,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254698',4856074,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254698',4856075,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254698',4856076,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254808',4857825,'2843','429',239534.63,240344.24,809.61,133585.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','254808',4857826,'2844','429',104895.65,104895.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','254808',4857827,'2845','429',194486.12,194755.28,269.16,44411.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','254808',4857828,'2846','429',135494.67,135494.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254808',4857829,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254808',4857830,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254808',4857831,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','254808',4857832,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','254808',4857833,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','254808',4857834,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255283',4866260,'2843','429',240344.24,240344.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255283',4866261,'2844','429',104895.65,104895.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255283',4866262,'2845','429',194755.28,194755.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255283',4866263,'2846','429',135494.67,135494.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255283',4866264,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255283',4866265,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255283',4866266,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255283',4866267,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','255283',4866268,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','255283',4866269,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255568',4870663,'2843','429',240344.24,240344.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255568',4870664,'2844','429',104895.65,104895.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255568',4870665,'2845','429',194755.28,194755.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255568',4870666,'2846','429',135494.67,135494.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255568',4870667,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255568',4870668,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255568',4870669,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255568',4870670,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','255568',4870671,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','255568',4870672,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255807',4874670,'2843','429',240344.24,240567.31,223.07,36806.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','255807',4874671,'2844','429',104895.65,104895.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255807',4874672,'2845','429',194755.28,196255.28,1500.00,247500.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255807',4874673,'2846','429',135494.67,135494.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255807',4874674,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255807',4874675,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255807',4874676,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255807',4874677,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','255807',4874678,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','255807',4874679,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','255938',4876955,'2843','429',240567.31,244176.54,3609.23,595522.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','255938',4876956,'2844','429',104895.65,106975.44,2079.79,343165.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','255938',4876957,'2845','429',196255.28,198082.76,1827.48,301534.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','255938',4876958,'2846','429',135494.67,138742.73,3248.06,535929.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','255938',4876959,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255938',4876960,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255938',4876961,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','255938',4876962,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','255938',4876963,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','255938',4876964,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','256270',4882060,'2843','429',244176.54,247001.77,2825.23,466162.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','256270',4882061,'2844','429',106975.44,108971.11,1995.67,329285.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','256270',4882062,'2845','429',198082.76,201737.13,3654.37,602971.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','256270',4882063,'2846','429',138742.73,141537.02,2794.29,461057.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','256270',4882064,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256270',4882065,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256270',4882066,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256270',4882067,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','256270',4882068,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','256270',4882069,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','256665',4889166,'2843','429',247001.77,248824.04,1822.27,300674.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','256665',4889167,'2844','429',108971.11,110352.15,1381.04,227871.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','256665',4889168,'2845','429',201737.13,203948.23,2211.10,364831.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','256665',4889169,'2846','429',141537.02,143798.04,2261.02,373068.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','256665',4889170,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256665',4889171,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256665',4889172,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256665',4889173,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','256665',4889174,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','256665',4889175,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','256898',4893097,'2843','429',248824.04,250896.03,2071.99,341878.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','256898',4893098,'2844','429',110352.15,112001.38,1649.23,272122.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','256898',4893099,'2845','429',203948.23,206246.60,2298.37,379231.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','256898',4893100,'2846','429',143798.04,145371.33,1573.29,259592.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','256898',4893101,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256898',4893102,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256898',4893103,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','256898',4893104,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','256898',4893105,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','256898',4893106,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257101',4896698,'2843','429',250896.03,252239.80,1343.77,221722.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257101',4896699,'2844','429',112001.38,113079.86,1078.48,177949.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257101',4896700,'2845','429',206246.60,207537.24,1290.64,212955.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257101',4896701,'2846','429',145371.33,146485.86,1114.53,183897.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257101',4896702,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257101',4896703,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257101',4896704,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257101',4896705,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257101',4896706,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257101',4896707,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257102',4896708,'2843','429',252239.80,253372.91,1133.11,186963.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257102',4896709,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257102',4896710,'2845','429',207537.24,208411.48,874.24,144249.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257102',4896711,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257102',4896712,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257102',4896713,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257102',4896714,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257102',4896715,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257102',4896716,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257102',4896717,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257103',4896718,'2843','429',253372.91,254755.41,1382.50,228112.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257103',4896719,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257103',4896720,'2845','429',208411.48,208611.48,200.00,33000.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257103',4896721,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257103',4896722,'2847','429',126592.24,126592.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257103',4896723,'2848','429',108800.15,108800.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257103',4896724,'2849','429',70399.37,70399.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257103',4896725,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257103',4896726,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257103',4896727,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257104',4896728,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257104',4896729,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257104',4896730,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257104',4896731,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257104',4896732,'2847','429',126592.24,129963.87,3371.63,556318.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257104',4896733,'2848','429',108800.15,111663.10,2862.95,472386.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257104',4896734,'2849','429',70399.37,73133.80,2734.43,451180.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257104',4896735,'2850','429',53818.13,53818.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257104',4896736,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257104',4896737,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257105',4896738,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257105',4896739,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257105',4896740,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257105',4896741,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257105',4896742,'2847','429',129963.87,133206.68,3242.81,535063.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257105',4896743,'2848','429',111663.10,114899.40,3236.30,533989.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257105',4896744,'2849','429',73133.80,75899.80,2766.00,456390.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257105',4896745,'2850','429',53818.13,55115.59,1297.46,214080.90,0.00,0.00,0.00,0.00,0.00),('5','184','959','257105',4896746,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257105',4896747,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257106',4896748,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257106',4896749,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257106',4896750,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257106',4896751,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257106',4896752,'2847','429',133206.68,136038.89,2832.21,467314.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257106',4896753,'2848','429',114899.40,117703.52,2804.12,462679.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257106',4896754,'2849','429',75899.80,78734.75,2834.95,467766.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257106',4896755,'2850','429',55115.59,56732.03,1616.44,266712.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','257106',4896756,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257106',4896757,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257107',4896758,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257107',4896759,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257107',4896760,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257107',4896761,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257107',4896762,'2847','429',136038.89,137836.24,1797.35,296562.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257107',4896763,'2848','429',117703.52,119112.27,1408.75,232443.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257107',4896764,'2849','429',78734.75,79850.67,1115.92,184126.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257107',4896765,'2850','429',56732.03,57694.94,962.91,158880.15,0.00,0.00,0.00,0.00,0.00),('5','184','959','257107',4896766,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257107',4896767,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257108',4896768,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257108',4896769,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257108',4896770,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257108',4896771,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257108',4896772,'2847','429',137836.24,139217.33,1381.09,227879.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257108',4896773,'2848','429',119112.27,120318.63,1206.36,199049.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257108',4896774,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257108',4896775,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257108',4896776,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257108',4896777,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257109',4896778,'2843','429',254755.41,254755.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257109',4896779,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257109',4896780,'2845','429',208611.48,208611.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257109',4896781,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257109',4896782,'2847','429',139217.33,140062.61,845.28,139471.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257109',4896783,'2848','429',120318.63,120560.41,241.78,39893.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257109',4896784,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257109',4896785,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257109',4896786,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257109',4896787,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257110',4896788,'2843','429',254755.41,255434.44,679.03,112039.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257110',4896789,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257110',4896790,'2845','429',208611.48,209119.31,507.83,83791.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257110',4896791,'2846','429',146485.86,146485.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257110',4896792,'2847','429',140062.61,140801.85,739.24,121974.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257110',4896793,'2848','429',120560.41,120725.09,164.68,27172.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257110',4896794,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257110',4896795,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257110',4896796,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257110',4896797,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257111',4896798,'2843','429',255434.44,258426.45,2992.01,493681.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257111',4896799,'2844','429',113079.86,113079.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257111',4896800,'2845','429',209119.31,212239.49,3120.18,514829.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257111',4896801,'2846','429',146485.86,149236.60,2750.74,453872.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257111',4896802,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257111',4896803,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257111',4896804,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257111',4896805,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257111',4896806,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257111',4896807,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257112',4896808,'2843','429',258426.45,261057.60,2631.15,434139.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257112',4896809,'2844','429',113079.86,114315.41,1235.55,203865.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257112',4896810,'2845','429',212239.49,215135.88,2896.39,477904.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257112',4896811,'2846','429',149236.60,152819.54,3582.94,591185.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257112',4896812,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257112',4896813,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257112',4896814,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257112',4896815,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257112',4896816,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257112',4896817,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257113',4896818,'2843','429',261057.60,262917.55,1859.95,306891.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257113',4896819,'2844','429',114315.41,115986.65,1671.24,275754.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257113',4896820,'2845','429',215135.88,217742.38,2606.50,430072.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257113',4896821,'2846','429',152819.54,154885.77,2066.23,340927.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257113',4896822,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257113',4896823,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257113',4896824,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257113',4896825,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257113',4896826,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257113',4896827,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257114',4896828,'2843','429',262917.55,264034.94,1117.39,184369.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257114',4896829,'2844','429',115986.65,116906.87,920.22,151836.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257114',4896830,'2845','429',217742.38,218912.16,1169.78,193013.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257114',4896831,'2846','429',154885.77,155863.74,977.97,161365.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257114',4896832,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257114',4896833,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257114',4896834,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257114',4896835,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257114',4896836,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257114',4896837,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257115',4896838,'2843','429',264034.94,265497.57,1462.63,241333.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257115',4896839,'2844','429',116906.87,117769.98,863.11,142413.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257115',4896840,'2845','429',218912.16,219917.63,1005.47,165902.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257115',4896841,'2846','429',155863.74,156801.14,937.40,154671.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257115',4896842,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257115',4896843,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257115',4896844,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257115',4896845,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257115',4896846,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257115',4896847,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257116',4896848,'2843','429',265497.57,267099.86,1602.29,264377.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257116',4896849,'2844','429',117769.98,117769.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257116',4896850,'2845','429',219917.63,219917.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257116',4896851,'2846','429',156801.14,157244.81,443.67,73205.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257116',4896852,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257116',4896853,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257116',4896854,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257116',4896855,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257116',4896856,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257116',4896857,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257117',4896858,'2843','429',267099.86,267099.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257117',4896859,'2844','429',117769.98,117769.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257117',4896860,'2845','429',219917.63,219917.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257117',4896861,'2846','429',157244.81,157244.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257117',4896862,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257117',4896863,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257117',4896864,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257117',4896865,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257117',4896866,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257117',4896867,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257118',4896868,'2843','429',267099.86,267099.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257118',4896869,'2844','429',117769.98,117769.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257118',4896870,'2845','429',219917.63,219917.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257118',4896871,'2846','429',157244.81,157244.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257118',4896872,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257118',4896873,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257118',4896874,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257118',4896875,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257118',4896876,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257118',4896877,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257119',4896878,'2843','429',267099.86,267099.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257119',4896879,'2844','429',117769.98,117769.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257119',4896880,'2845','429',219917.63,219917.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257119',4896881,'2846','429',157244.81,157244.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257119',4896882,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257119',4896883,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257119',4896884,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257119',4896885,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257119',4896886,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257119',4896887,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257120',4896888,'2843','429',267099.86,267099.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257120',4896889,'2844','429',117769.98,117769.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257120',4896890,'2845','429',219917.63,219917.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257120',4896891,'2846','429',157244.81,157244.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257120',4896892,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257120',4896893,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257120',4896894,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257120',4896895,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257120',4896896,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257120',4896897,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257121',4896898,'2843','429',267099.86,268996.04,1896.18,312869.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257121',4896899,'2844','429',117769.98,118694.08,924.10,152476.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257121',4896900,'2845','429',219917.63,221255.40,1337.77,220732.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257121',4896901,'2846','429',157244.81,158657.15,1412.34,233036.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257121',4896902,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257121',4896903,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257121',4896904,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257121',4896905,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257121',4896906,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257121',4896907,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257122',4896908,'2843','429',268996.04,270959.59,1963.55,323985.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257122',4896909,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257122',4896910,'2845','429',221255.40,222494.62,1239.22,204471.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257122',4896911,'2846','429',158657.15,158657.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257122',4896912,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257122',4896913,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257122',4896914,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257122',4896915,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257122',4896916,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257122',4896917,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257123',4896918,'2843','429',270959.59,273087.16,2127.57,351049.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257123',4896919,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257123',4896920,'2845','429',222494.62,223560.15,1065.53,175812.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','257123',4896921,'2846','429',158657.15,158657.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257123',4896922,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257123',4896923,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257123',4896924,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257123',4896925,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257123',4896926,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257123',4896927,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257124',4896928,'2843','429',273087.16,274246.65,1159.49,191315.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257124',4896929,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257124',4896930,'2845','429',223560.15,223560.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257124',4896931,'2846','429',158657.15,159500.40,843.25,139136.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257124',4896932,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257124',4896933,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257124',4896934,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257124',4896935,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257124',4896936,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257124',4896937,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257125',4896938,'2843','429',274246.65,275846.34,1599.69,263948.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257125',4896939,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257125',4896940,'2845','429',223560.15,223958.78,398.63,65773.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257125',4896941,'2846','429',159500.40,159500.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257125',4896942,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257125',4896943,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257125',4896944,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257125',4896945,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257125',4896946,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257125',4896947,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257126',4896948,'2843','429',275846.34,275846.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257126',4896949,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257126',4896950,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257126',4896951,'2846','429',159500.40,159500.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257126',4896952,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257126',4896953,'2848','429',120725.09,120725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257126',4896954,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257126',4896955,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257126',4896956,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257126',4896957,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257127',4896958,'2843','429',275846.34,286422.11,10575.77,1745002.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257127',4896959,'2844','429',118694.08,118694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257127',4896960,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257127',4896961,'2846','429',159500.40,159500.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257127',4896962,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257127',4896963,'2848','429',120725.09,130811.30,10086.21,1664224.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257127',4896964,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257127',4896965,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257127',4896966,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257127',4896967,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257128',4896968,'2843','429',286422.11,286422.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257128',4896969,'2844','429',118694.08,118900.00,205.92,33976.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257128',4896970,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257128',4896971,'2846','429',159500.40,159559.66,59.26,9777.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257128',4896972,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257128',4896973,'2848','429',130811.30,130899.66,88.36,14579.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257128',4896974,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257128',4896975,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257128',4896976,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257128',4896977,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257129',4896978,'2843','429',286422.11,286555.00,132.89,21926.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257129',4896979,'2844','429',118900.00,118900.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257129',4896980,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257129',4896981,'2846','429',159559.66,159559.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257129',4896982,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257129',4896983,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257129',4896984,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257129',4896985,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257129',4896986,'2851','430',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257129',4896987,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257130',4896988,'2843','429',286555.00,286555.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257130',4896989,'2844','429',118900.00,118900.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257130',4896990,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257130',4896991,'2846','429',159559.66,159559.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257130',4896992,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257130',4896993,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257130',4896994,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257130',4896995,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257130',4896996,'2851','430',66765.86,67965.88,1200.02,840014.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257130',4896997,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257131',4896998,'2843','429',286555.00,288555.00,2000.00,330000.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257131',4896999,'2844','429',118900.00,119600.00,700.00,115500.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257131',4897000,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257131',4897001,'2846','429',159559.66,159559.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257131',4897002,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257131',4897003,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257131',4897004,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257131',4897005,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257131',4897006,'2851','430',67965.88,67965.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257131',4897007,'2852','431',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257132',4897008,'2843','429',288555.00,288555.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257132',4897009,'2844','429',119600.00,119960.09,360.09,59414.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257132',4897010,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257132',4897011,'2846','429',159559.66,159959.66,400.00,66000.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257132',4897012,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257132',4897013,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257132',4897014,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257132',4897015,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257132',4897016,'2851','430',67965.88,67965.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257132',4897017,'2852','431',329503.87,329603.89,100.02,40008.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257133',4897018,'2843','429',288555.00,288555.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257133',4897019,'2844','429',119960.09,119960.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257133',4897020,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257133',4897021,'2846','429',159959.66,159959.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257133',4897022,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257133',4897023,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257133',4897024,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257133',4897025,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257133',4897026,'2851','430',67965.88,67965.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257133',4897027,'2852','431',329603.89,329603.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257134',4897028,'2843','429',288555.00,288555.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257134',4897029,'2844','429',119960.09,119999.00,38.91,6420.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257134',4897030,'2845','429',223958.78,223958.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257134',4897031,'2846','429',159959.66,159970.00,10.34,1706.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257134',4897032,'2847','429',140801.85,140801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257134',4897033,'2848','429',130899.66,130899.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257134',4897034,'2849','429',79850.67,79850.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257134',4897035,'2850','429',57694.94,57694.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257134',4897036,'2851','430',67965.88,67965.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257134',4897037,'2852','431',329603.89,329603.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257135',4897038,'2843','429',299461.91,299461.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257135',4897039,'2844','429',128904.40,128904.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257135',4897040,'2845','429',264274.96,264274.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257135',4897041,'2846','429',182563.64,182563.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257135',4897042,'2847','429',210335.92,211647.77,1311.85,216455.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257135',4897043,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257135',4897044,'2849','429',157888.08,159092.01,1203.93,198648.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257135',4897045,'2850','429',127249.25,128848.60,1599.35,263892.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','257135',4897046,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257135',4897047,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257136',4897048,'2843','429',299461.91,299461.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257136',4897049,'2844','429',128904.40,128904.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257136',4897050,'2845','429',264274.96,264274.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257136',4897051,'2846','429',182563.64,182563.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257136',4897052,'2847','429',211647.77,211647.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257136',4897053,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257136',4897054,'2849','429',159092.01,159092.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257136',4897055,'2850','429',128848.60,128848.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257136',4897056,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257136',4897057,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257137',4897058,'2843','429',299461.91,300218.96,757.05,124913.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257137',4897059,'2844','429',128904.40,128904.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257137',4897060,'2845','429',264274.96,265405.12,1130.16,186476.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257137',4897061,'2846','429',182563.64,183541.67,978.03,161374.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257137',4897062,'2847','429',211647.77,212587.62,939.85,155075.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257137',4897063,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257137',4897064,'2849','429',159092.01,159858.38,766.37,126451.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257137',4897065,'2850','429',128848.60,130302.27,1453.67,239855.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257137',4897066,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257137',4897067,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257138',4897068,'2843','429',300218.96,301563.79,1344.83,221896.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257138',4897069,'2844','429',128904.40,128904.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257138',4897070,'2845','429',265405.12,268327.88,2922.76,482255.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257138',4897071,'2846','429',183541.67,185222.83,1681.16,277391.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257138',4897072,'2847','429',212587.62,212587.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257138',4897073,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257138',4897074,'2849','429',159858.38,159858.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257138',4897075,'2850','429',130302.27,130302.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257138',4897076,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257138',4897077,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257139',4897078,'2843','429',301563.79,301563.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257139',4897079,'2844','429',128904.40,130119.36,1214.96,200468.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257139',4897080,'2845','429',268327.88,270411.45,2083.57,343789.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257139',4897081,'2846','429',185222.83,186305.12,1082.29,178577.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257139',4897082,'2847','429',212587.62,212587.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257139',4897083,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257139',4897084,'2849','429',159858.38,159858.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257139',4897085,'2850','429',130302.27,130302.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257139',4897086,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257139',4897087,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257140',4897088,'2843','429',301563.79,302027.31,463.52,76480.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257140',4897089,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257140',4897090,'2845','429',270411.45,271772.40,1360.95,224556.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257140',4897091,'2846','429',186305.12,186305.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257140',4897092,'2847','429',212587.62,214050.78,1463.16,241421.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257140',4897093,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257140',4897094,'2849','429',159858.38,161564.87,1706.49,281570.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257140',4897095,'2850','429',130302.27,131757.23,1454.96,240068.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257140',4897096,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257140',4897097,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257141',4897098,'2843','429',302027.31,302027.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257141',4897099,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257141',4897100,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257141',4897101,'2846','429',186305.12,186305.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257141',4897102,'2847','429',214050.78,215007.00,956.22,157776.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257141',4897103,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257141',4897104,'2849','429',161564.87,163226.23,1661.36,274124.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257141',4897105,'2850','429',131757.23,133136.83,1379.60,227634.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257141',4897106,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257141',4897107,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257142',4897108,'2843','429',302027.31,302027.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257142',4897109,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257142',4897110,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257142',4897111,'2846','429',186305.12,186305.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257142',4897112,'2847','429',215007.00,215975.85,968.85,159860.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257142',4897113,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257142',4897114,'2849','429',163226.23,165012.56,1786.33,294744.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257142',4897115,'2850','429',133136.83,134462.16,1325.33,218679.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257142',4897116,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257142',4897117,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257143',4897118,'2843','429',302027.31,302905.33,878.02,144873.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257143',4897119,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257143',4897120,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257143',4897121,'2846','429',186305.12,187612.23,1307.11,215673.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257143',4897122,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257143',4897123,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257143',4897124,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257143',4897125,'2850','429',134462.16,136364.83,1902.67,313940.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257143',4897126,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257143',4897127,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257144',4897128,'2843','429',302905.33,302905.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257144',4897129,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257144',4897130,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257144',4897131,'2846','429',187612.23,187612.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257144',4897132,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257144',4897133,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257144',4897134,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257144',4897135,'2850','429',136364.83,136364.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257144',4897136,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257144',4897137,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257145',4897138,'2843','429',302905.33,302905.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257145',4897139,'2844','429',130119.36,130119.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257145',4897140,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257145',4897141,'2846','429',187612.23,187612.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257145',4897142,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257145',4897143,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257145',4897144,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257145',4897145,'2850','429',136364.83,136364.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257145',4897146,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257145',4897147,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257146',4897148,'2843','429',302905.33,305007.14,2101.81,346798.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257146',4897149,'2844','429',130119.36,131282.34,1162.98,191891.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257146',4897150,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257146',4897151,'2846','429',187612.23,192156.87,4544.64,749865.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257146',4897152,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257146',4897153,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257146',4897154,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257146',4897155,'2850','429',136364.83,136364.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257146',4897156,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257146',4897157,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257147',4897158,'2843','429',305007.14,305758.03,750.89,123896.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257147',4897159,'2844','429',131282.34,131945.04,662.70,109345.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257147',4897160,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257147',4897161,'2846','429',192156.87,194871.33,2714.46,447885.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257147',4897162,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257147',4897163,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257147',4897164,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257147',4897165,'2850','429',136364.83,136364.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257147',4897166,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257147',4897167,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257148',4897168,'2843','429',305758.03,306132.44,374.41,61777.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257148',4897169,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257148',4897170,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257148',4897171,'2846','429',194871.33,195437.09,565.76,93350.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257148',4897172,'2847','429',215975.85,215975.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257148',4897173,'2848','429',135882.95,135882.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257148',4897174,'2849','429',165012.56,165012.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257148',4897175,'2850','429',136364.83,136364.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257148',4897176,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257148',4897177,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257149',4897178,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257149',4897179,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257149',4897180,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257149',4897181,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257149',4897182,'2847','429',215975.85,216283.34,307.49,50735.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257149',4897183,'2848','429',135882.95,136873.90,990.95,163506.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257149',4897184,'2849','429',165012.56,165720.61,708.05,116828.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257149',4897185,'2850','429',136364.83,137048.58,683.75,112818.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','257149',4897186,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257149',4897187,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257150',4897188,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257150',4897189,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257150',4897190,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257150',4897191,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257150',4897192,'2847','429',216283.34,216283.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257150',4897193,'2848','429',136873.90,138129.58,1255.68,207187.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257150',4897194,'2849','429',165720.61,168681.51,2960.90,488548.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257150',4897195,'2850','429',137048.58,138724.39,1675.81,276508.65,0.00,0.00,0.00,0.00,0.00),('5','184','959','257150',4897196,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257150',4897197,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257151',4897198,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257151',4897199,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257151',4897200,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257151',4897201,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257151',4897202,'2847','429',216283.34,219327.02,3043.68,502207.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257151',4897203,'2848','429',138129.58,139399.70,1270.12,209569.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257151',4897204,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257151',4897205,'2850','429',138724.39,141410.17,2685.78,443153.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','257151',4897206,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257151',4897207,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257152',4897208,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257152',4897209,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257152',4897210,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257152',4897211,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257152',4897212,'2847','429',219327.02,221051.90,1724.88,284605.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257152',4897213,'2848','429',139399.70,140812.45,1412.75,233103.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257152',4897214,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257152',4897215,'2850','429',141410.17,143835.86,2425.69,400238.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257152',4897216,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257152',4897217,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257153',4897218,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257153',4897219,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257153',4897220,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257153',4897221,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257153',4897222,'2847','429',221051.90,222049.10,997.20,164538.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257153',4897223,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257153',4897224,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257153',4897225,'2850','429',143835.86,145890.80,2054.94,339065.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','257153',4897226,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257153',4897227,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257154',4897228,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257154',4897229,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257154',4897230,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257154',4897231,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257154',4897232,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257154',4897233,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257154',4897234,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257154',4897235,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257154',4897236,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257154',4897237,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257155',4897238,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257155',4897239,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257155',4897240,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257155',4897241,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257155',4897242,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257155',4897243,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257155',4897244,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257155',4897245,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257155',4897246,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257155',4897247,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257156',4897248,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257156',4897249,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257156',4897250,'2845','429',271772.40,271772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257156',4897251,'2846','429',195437.09,195437.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257156',4897252,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257156',4897253,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257156',4897254,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257156',4897255,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257156',4897256,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257156',4897257,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257157',4897258,'2843','429',306132.44,306132.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257157',4897259,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257157',4897260,'2845','429',271772.40,272302.55,530.15,87474.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257157',4897261,'2846','429',195437.09,196415.42,978.33,161424.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257157',4897262,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257157',4897263,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257157',4897264,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257157',4897265,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257157',4897266,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257157',4897267,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257158',4897268,'2843','429',306132.44,307556.06,1423.62,234897.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257158',4897269,'2844','429',131945.04,131945.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257158',4897270,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257158',4897271,'2846','429',196415.42,199706.99,3291.57,543109.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257158',4897272,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257158',4897273,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257158',4897274,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257158',4897275,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257158',4897276,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257158',4897277,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257159',4897278,'2843','429',307556.06,308442.40,886.34,146246.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257159',4897279,'2844','429',131945.04,132784.86,839.82,138570.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257159',4897280,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257159',4897281,'2846','429',199706.99,202873.60,3166.61,522490.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257159',4897282,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257159',4897283,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257159',4897284,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257159',4897285,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257159',4897286,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257159',4897287,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257160',4897288,'2843','429',308442.40,309177.40,735.00,121275.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257160',4897289,'2844','429',132784.86,133849.37,1064.51,175644.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257160',4897290,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257160',4897291,'2846','429',202873.60,206178.95,3305.35,545382.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257160',4897292,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257160',4897293,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257160',4897294,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257160',4897295,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257160',4897296,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257160',4897297,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257161',4897298,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257161',4897299,'2844','429',133849.37,134736.62,887.25,146396.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257161',4897300,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257161',4897301,'2846','429',206178.95,211100.01,4921.06,811974.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257161',4897302,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257161',4897303,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257161',4897304,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257161',4897305,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257161',4897306,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257161',4897307,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257162',4897308,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257162',4897309,'2844','429',134736.62,136168.76,1432.14,236303.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257162',4897310,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257162',4897311,'2846','429',211100.01,214375.53,3275.52,540460.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257162',4897312,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257162',4897313,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257162',4897314,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257162',4897315,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257162',4897316,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257162',4897317,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257163',4897318,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257163',4897319,'2844','429',136168.76,138716.12,2547.36,420314.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257163',4897320,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257163',4897321,'2846','429',214375.53,216938.40,2562.87,422873.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257163',4897322,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257163',4897323,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257163',4897324,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257163',4897325,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257163',4897326,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257163',4897327,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257164',4897328,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257164',4897329,'2844','429',138716.12,140724.82,2008.70,331435.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257164',4897330,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257164',4897331,'2846','429',216938.40,218852.47,1914.07,315821.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257164',4897332,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257164',4897333,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257164',4897334,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257164',4897335,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257164',4897336,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257164',4897337,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257165',4897338,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257165',4897339,'2844','429',140724.82,144697.90,3973.08,655558.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257165',4897340,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257165',4897341,'2846','429',218852.47,225967.07,7114.60,1173909.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257165',4897342,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257165',4897343,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257165',4897344,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257165',4897345,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257165',4897346,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257165',4897347,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257166',4897348,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257166',4897349,'2844','429',144697.90,147643.29,2945.39,485989.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257166',4897350,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257166',4897351,'2846','429',225967.07,231645.26,5678.19,936901.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257166',4897352,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257166',4897353,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257166',4897354,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257166',4897355,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257166',4897356,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257166',4897357,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257167',4897358,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257167',4897359,'2844','429',147643.29,151610.67,3967.38,654617.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257167',4897360,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257167',4897361,'2846','429',231645.26,237870.39,6225.13,1027146.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257167',4897362,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257167',4897363,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257167',4897364,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257167',4897365,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257167',4897366,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257167',4897367,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257168',4897368,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257168',4897369,'2844','429',151610.67,153549.53,1938.86,319911.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','257168',4897370,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257168',4897371,'2846','429',237870.39,242593.04,4722.65,779237.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257168',4897372,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257168',4897373,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257168',4897374,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257168',4897375,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257168',4897376,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257168',4897377,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257169',4897378,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257169',4897379,'2844','429',153549.53,153549.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257169',4897380,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257169',4897381,'2846','429',242593.04,246718.06,4125.02,680628.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257169',4897382,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257169',4897383,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257169',4897384,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257169',4897385,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257169',4897386,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257169',4897387,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257170',4897388,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257170',4897389,'2844','429',153549.53,153603.35,53.82,8880.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257170',4897390,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257170',4897391,'2846','429',246718.06,250215.16,3497.10,577021.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257170',4897392,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257170',4897393,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257170',4897394,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257170',4897395,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257170',4897396,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257170',4897397,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257171',4897398,'2843','429',309177.40,309177.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257171',4897399,'2844','429',153603.35,153603.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257171',4897400,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257171',4897401,'2846','429',250215.16,252658.31,2443.15,403119.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257171',4897402,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257171',4897403,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257171',4897404,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257171',4897405,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257171',4897406,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257171',4897407,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257172',4897408,'2843','429',309177.40,309274.70,97.30,16054.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257172',4897409,'2844','429',153603.35,153603.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257172',4897410,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257172',4897411,'2846','429',252658.31,254524.92,1866.61,307990.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257172',4897412,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257172',4897413,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257172',4897414,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257172',4897415,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257172',4897416,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257172',4897417,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257173',4897418,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257173',4897419,'2844','429',153603.35,153603.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257173',4897420,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257173',4897421,'2846','429',254524.92,254524.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257173',4897422,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257173',4897423,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257173',4897424,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257173',4897425,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257173',4897426,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257173',4897427,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257174',4897428,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257174',4897429,'2844','429',153603.35,153603.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257174',4897430,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257174',4897431,'2846','429',254524.92,254524.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257174',4897432,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257174',4897433,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257174',4897434,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257174',4897435,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257174',4897436,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257174',4897437,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257175',4897438,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257175',4897439,'2844','429',153603.35,153603.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257175',4897440,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257175',4897441,'2846','429',254524.92,254524.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257175',4897442,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257175',4897443,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257175',4897444,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257175',4897445,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257175',4897446,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257175',4897447,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257176',4897448,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257176',4897449,'2844','429',153603.35,156870.46,3267.11,539073.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257176',4897450,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257176',4897451,'2846','429',254524.92,261750.13,7225.21,1192159.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257176',4897452,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257176',4897453,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257176',4897454,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257176',4897455,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257176',4897456,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257176',4897457,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257177',4897458,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257177',4897459,'2844','429',156870.46,159353.43,2482.97,409690.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257177',4897460,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257177',4897461,'2846','429',261750.13,265751.85,4001.72,660283.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257177',4897462,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257177',4897463,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257177',4897464,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257177',4897465,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257177',4897466,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257177',4897467,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257178',4897468,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257178',4897469,'2844','429',159353.43,161280.85,1927.42,318024.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257178',4897470,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257178',4897471,'2846','429',265751.85,269002.06,3250.21,536284.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257178',4897472,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257178',4897473,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257178',4897474,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257178',4897475,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257178',4897476,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257178',4897477,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257179',4897478,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257179',4897479,'2844','429',161280.85,163571.70,2290.85,377990.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257179',4897480,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257179',4897481,'2846','429',269002.06,272618.39,3616.33,596694.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257179',4897482,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257179',4897483,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257179',4897484,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257179',4897485,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257179',4897486,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257179',4897487,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257180',4897488,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257180',4897489,'2844','429',163571.70,166719.35,3147.65,519362.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257180',4897490,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257180',4897491,'2846','429',272618.39,276841.83,4223.44,696867.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257180',4897492,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257180',4897493,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257180',4897494,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257180',4897495,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257180',4897496,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257180',4897497,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257181',4897498,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257181',4897499,'2844','429',166719.35,168418.67,1699.32,280387.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257181',4897500,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257181',4897501,'2846','429',276841.83,279670.87,2829.04,466791.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257181',4897502,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257181',4897503,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257181',4897504,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257181',4897505,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257181',4897506,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257181',4897507,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257182',4897508,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257182',4897509,'2844','429',168418.67,171459.72,3041.05,501773.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257182',4897510,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257182',4897511,'2846','429',279670.87,283995.79,4324.92,713611.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257182',4897512,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257182',4897513,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257182',4897514,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257182',4897515,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257182',4897516,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257182',4897517,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257183',4897518,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257183',4897519,'2844','429',171459.72,173908.49,2448.77,404047.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257183',4897520,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257183',4897521,'2846','429',283995.79,287644.06,3648.27,601964.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257183',4897522,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257183',4897523,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257183',4897524,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257183',4897525,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257183',4897526,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257183',4897527,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257184',4897528,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257184',4897529,'2844','429',173908.49,173908.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257184',4897530,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257184',4897531,'2846','429',287644.06,287644.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257184',4897532,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257184',4897533,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257184',4897534,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257184',4897535,'2850','429',145890.80,145890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257184',4897536,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257184',4897537,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257185',4897538,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257185',4897539,'2844','429',173908.49,175952.76,2044.27,337304.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257185',4897540,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257185',4897541,'2846','429',287644.06,290345.53,2701.47,445742.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257185',4897542,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257185',4897543,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257185',4897544,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257185',4897545,'2850','429',167274.07,169341.18,2067.11,341073.15,0.00,0.00,0.00,0.00,0.00),('5','184','959','257185',4897546,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257185',4897547,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257186',4897548,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257186',4897549,'2844','429',175952.76,178896.83,2944.07,485771.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257186',4897550,'2845','429',272302.55,272302.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257186',4897551,'2846','429',290345.53,293574.24,3228.71,532737.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257186',4897552,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257186',4897553,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257186',4897554,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257186',4897555,'2850','429',169341.18,172006.67,2665.49,439805.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257186',4897556,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257186',4897557,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257187',4897558,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257187',4897559,'2844','429',178896.83,181504.48,2607.65,430262.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257187',4897560,'2845','429',272302.55,275335.67,3033.12,500464.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257187',4897561,'2846','429',293574.24,293574.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257187',4897562,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257187',4897563,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257187',4897564,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257187',4897565,'2850','429',172006.67,174296.37,2289.70,377800.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257187',4897566,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257187',4897567,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257188',4897568,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257188',4897569,'2844','429',181504.48,184291.71,2787.23,459892.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257188',4897570,'2845','429',275335.67,275335.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257188',4897571,'2846','429',293574.24,295722.66,2148.42,354489.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257188',4897572,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257188',4897573,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257188',4897574,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257188',4897575,'2850','429',174296.37,176845.90,2549.53,420672.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257188',4897576,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257188',4897577,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257189',4897578,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257189',4897579,'2844','429',184291.71,186616.42,2324.71,383577.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257189',4897580,'2845','429',275335.67,276764.70,1429.03,235789.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257189',4897581,'2846','429',295722.66,295722.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257189',4897582,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257189',4897583,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257189',4897584,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257189',4897585,'2850','429',176845.90,179376.03,2530.13,417471.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257189',4897586,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257189',4897587,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257190',4897588,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257190',4897589,'2844','429',186616.42,187441.82,825.40,136191.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257190',4897590,'2845','429',276764.70,277741.99,977.29,161252.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257190',4897591,'2846','429',295722.66,295722.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257190',4897592,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257190',4897593,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257190',4897594,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257190',4897595,'2850','429',179376.03,181908.77,2532.74,417902.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','257190',4897596,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257190',4897597,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257191',4897598,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257191',4897599,'2844','429',187441.82,189380.12,1938.30,319819.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257191',4897600,'2845','429',277741.99,280188.26,2446.27,403634.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257191',4897601,'2846','429',295722.66,295722.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257191',4897602,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257191',4897603,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257191',4897604,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257191',4897605,'2850','429',181908.77,183302.15,1393.38,229907.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','257191',4897606,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257191',4897607,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257192',4897608,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257192',4897609,'2844','429',189380.12,191467.83,2087.71,344472.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257192',4897610,'2845','429',280188.26,282415.26,2227.00,367455.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257192',4897611,'2846','429',295722.66,295722.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257192',4897612,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257192',4897613,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257192',4897614,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257192',4897615,'2850','429',183302.15,184353.06,1050.91,173400.15,0.00,0.00,0.00,0.00,0.00),('5','184','959','257192',4897616,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257192',4897617,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257193',4897618,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257193',4897619,'2844','429',191467.83,193677.88,2210.05,364658.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257193',4897620,'2845','429',282415.26,284812.51,2397.25,395546.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257193',4897621,'2846','429',295722.66,295722.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257193',4897622,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257193',4897623,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257193',4897624,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257193',4897625,'2850','429',184353.06,185886.43,1533.37,253006.05,0.00,0.00,0.00,0.00,0.00),('5','184','959','257193',4897626,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257193',4897627,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257194',4897628,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257194',4897629,'2844','429',193677.88,196113.32,2435.44,401847.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257194',4897630,'2845','429',284812.51,287529.07,2716.56,448232.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257194',4897631,'2846','429',295722.66,298132.86,2410.20,397683.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257194',4897632,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257194',4897633,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257194',4897634,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257194',4897635,'2850','429',185886.43,185886.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257194',4897636,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257194',4897637,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257195',4897638,'2843','429',309274.70,309274.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257195',4897639,'2844','429',196113.32,198183.65,2070.33,341604.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','257195',4897640,'2845','429',287529.07,290711.35,3182.28,525076.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257195',4897641,'2846','429',298132.86,299238.22,1105.36,182384.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257195',4897642,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257195',4897643,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257195',4897644,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257195',4897645,'2850','429',185886.43,186716.00,829.57,136879.05,0.00,0.00,0.00,0.00,0.00),('5','184','959','257195',4897646,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257195',4897647,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257196',4897648,'2843','429',309274.70,311929.37,2654.67,438020.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257196',4897649,'2844','429',198183.65,200537.98,2354.33,388464.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','257196',4897650,'2845','429',290711.35,293765.87,3054.52,503995.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257196',4897651,'2846','429',299238.22,299363.60,125.38,20687.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257196',4897652,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257196',4897653,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257196',4897654,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257196',4897655,'2850','429',186716.00,187880.56,1164.56,192152.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257196',4897656,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257196',4897657,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257197',4897658,'2843','429',309545.43,313967.11,4421.68,729577.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257197',4897659,'2844','429',200537.98,202495.15,1957.17,322933.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257197',4897660,'2845','429',293765.87,296853.59,3087.72,509473.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257197',4897661,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257197',4897662,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257197',4897663,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257197',4897664,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257197',4897665,'2850','429',187880.56,188710.68,830.12,136969.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257197',4897666,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257197',4897667,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257198',4897668,'2843','429',313967.11,316363.13,2396.02,395343.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257198',4897669,'2844','429',202495.15,205251.11,2755.96,454733.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257198',4897670,'2845','429',296853.59,299387.59,2534.00,418110.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257198',4897671,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257198',4897672,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257198',4897673,'2848','429',140812.45,140812.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257198',4897674,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257198',4897675,'2850','429',188710.68,190046.37,1335.69,220388.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257198',4897676,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257198',4897677,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257199',4897678,'2843','429',316363.13,317574.39,1211.26,199857.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','257199',4897679,'2844','429',205251.11,206945.48,1694.37,279571.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257199',4897680,'2845','429',299387.59,302095.98,2708.39,446884.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257199',4897681,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257199',4897682,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257199',4897683,'2848','429',140812.45,149467.35,8654.90,1428058.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257199',4897684,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257199',4897685,'2850','429',190046.37,191131.52,1085.15,179049.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','257199',4897686,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257199',4897687,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257200',4897688,'2843','429',317574.39,319218.01,1643.62,271197.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257200',4897689,'2844','429',206945.48,208072.22,1126.74,185912.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257200',4897690,'2845','429',302095.98,304391.33,2295.35,378732.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257200',4897691,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257200',4897692,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257200',4897693,'2848','429',149467.35,151157.91,1690.56,278942.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257200',4897694,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257200',4897695,'2850','429',191131.52,191637.28,505.76,83450.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257200',4897696,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257200',4897697,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257201',4897698,'2843','429',319218.01,320521.31,1303.30,215044.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257201',4897699,'2844','429',208072.22,209842.14,1769.92,292036.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257201',4897700,'2845','429',304391.33,307081.53,2690.20,443883.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257201',4897701,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257201',4897702,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257201',4897703,'2848','429',151157.91,152284.92,1127.01,185956.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257201',4897704,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257201',4897705,'2850','429',191637.28,191637.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257201',4897706,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257201',4897707,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257202',4897708,'2843','429',320521.31,323489.13,2967.82,489690.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257202',4897709,'2844','429',209842.14,212061.12,2218.98,366131.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257202',4897710,'2845','429',307081.53,309598.71,2517.18,415334.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257202',4897711,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257202',4897712,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257202',4897713,'2848','429',152284.92,152824.33,539.41,89002.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257202',4897714,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257202',4897715,'2850','429',191637.28,191637.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257202',4897716,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257202',4897717,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257203',4897718,'2843','429',323489.13,326542.26,3053.13,503766.45,0.00,0.00,0.00,0.00,0.00),('5','184','958','257203',4897719,'2844','429',212061.12,214285.79,2224.67,367070.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257203',4897720,'2845','429',309598.71,312794.68,3195.97,527335.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257203',4897721,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257203',4897722,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257203',4897723,'2848','429',152824.33,153528.85,704.52,116245.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257203',4897724,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257203',4897725,'2850','429',191637.28,191637.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257203',4897726,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257203',4897727,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257204',4897728,'2843','429',326542.26,328350.54,1808.28,298366.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257204',4897729,'2844','429',214285.79,214285.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257204',4897730,'2845','429',312794.68,312799.00,4.32,712.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257204',4897731,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257204',4897732,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257204',4897733,'2848','429',153528.85,154932.07,1403.22,231531.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257204',4897734,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257204',4897735,'2850','429',191637.28,191637.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257204',4897736,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257204',4897737,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257205',4897738,'2843','429',328350.54,331331.84,2981.30,491914.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257205',4897739,'2844','429',214285.79,217110.67,2824.88,466105.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257205',4897740,'2845','429',312799.00,315859.78,3060.78,505028.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257205',4897741,'2846','429',299363.60,299363.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257205',4897742,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257205',4897743,'2848','429',154932.07,157107.85,2175.78,359003.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257205',4897744,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257205',4897745,'2850','429',191637.28,192124.49,487.21,80389.65,0.00,0.00,0.00,0.00,0.00),('5','184','959','257205',4897746,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257205',4897747,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257206',4897748,'2843','429',331331.84,333766.13,2434.29,401657.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257206',4897749,'2844','429',217110.67,219826.43,2715.76,448100.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257206',4897750,'2845','429',315859.78,318909.22,3049.44,503157.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257206',4897751,'2846','429',299363.60,299812.32,448.72,74038.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257206',4897752,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257206',4897753,'2848','429',157107.85,157108.33,0.48,79.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257206',4897754,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257206',4897755,'2850','429',192124.49,192484.56,360.07,59411.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257206',4897756,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257206',4897757,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257207',4897758,'2843','429',333766.13,336400.99,2634.86,434751.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','257207',4897759,'2844','429',219826.43,220689.80,863.37,142456.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257207',4897760,'2845','429',318909.22,321898.29,2989.07,493196.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257207',4897761,'2846','429',299812.32,302701.82,2889.50,476767.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257207',4897762,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257207',4897763,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257207',4897764,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257207',4897765,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257207',4897766,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257207',4897767,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257208',4897768,'2843','429',336400.99,338074.78,1673.79,276175.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257208',4897769,'2844','429',220689.80,221902.44,1212.64,200085.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257208',4897770,'2845','429',321898.29,323656.71,1758.42,290139.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257208',4897771,'2846','429',302701.82,304222.47,1520.65,250907.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257208',4897772,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257208',4897773,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257208',4897774,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257208',4897775,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257208',4897776,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257208',4897777,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257209',4897778,'2843','429',338074.78,338747.39,672.61,110980.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257209',4897779,'2844','429',221902.44,223502.96,1600.52,264085.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257209',4897780,'2845','429',323656.71,324339.45,682.74,112652.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257209',4897781,'2846','429',304222.47,304788.93,566.46,93465.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257209',4897782,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257209',4897783,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257209',4897784,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257209',4897785,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257209',4897786,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257209',4897787,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257210',4897788,'2843','429',338747.39,340590.99,1843.60,304194.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257210',4897789,'2844','429',223502.96,223502.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257210',4897790,'2845','429',324339.45,325812.86,1473.41,243112.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257210',4897791,'2846','429',304788.93,304788.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257210',4897792,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257210',4897793,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257210',4897794,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257210',4897795,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257210',4897796,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257210',4897797,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257211',4897798,'2843','429',340590.99,340590.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257211',4897799,'2844','429',223502.96,223502.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257211',4897800,'2845','429',325812.86,325812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257211',4897801,'2846','429',304788.93,304788.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257211',4897802,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257211',4897803,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257211',4897804,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257211',4897805,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257211',4897806,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257211',4897807,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257212',4897808,'2843','429',340590.99,340590.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257212',4897809,'2844','429',223502.96,223502.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257212',4897810,'2845','429',325812.86,325812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257212',4897811,'2846','429',304788.93,304788.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257212',4897812,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257212',4897813,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257212',4897814,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257212',4897815,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257212',4897816,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257212',4897817,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257213',4897818,'2843','429',340590.99,340590.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257213',4897819,'2844','429',223502.96,223502.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257213',4897820,'2845','429',325812.86,325812.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257213',4897821,'2846','429',304788.93,304788.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257213',4897822,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257213',4897823,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257213',4897824,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257213',4897825,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257213',4897826,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257213',4897827,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257214',4897828,'2843','429',340590.99,343421.38,2830.39,467014.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257214',4897829,'2844','429',223502.96,224437.98,935.02,154278.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257214',4897830,'2845','429',325812.86,328029.24,2216.38,365702.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257214',4897831,'2846','429',304788.93,306449.29,1660.36,273959.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257214',4897832,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257214',4897833,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257214',4897834,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257214',4897835,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257214',4897836,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257214',4897837,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257215',4897838,'2843','429',343421.38,345819.06,2397.68,395617.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257215',4897839,'2844','429',224437.98,225143.16,705.18,116354.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257215',4897840,'2845','429',328029.24,330095.40,2066.16,340916.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257215',4897841,'2846','429',306449.29,308273.64,1824.35,301017.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257215',4897842,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257215',4897843,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257215',4897844,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257215',4897845,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257215',4897846,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257215',4897847,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257216',4897848,'2843','429',345819.06,348419.30,2600.24,429039.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257216',4897849,'2844','429',225143.16,225971.98,828.82,136755.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257216',4897850,'2845','429',330095.40,332257.65,2162.25,356771.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257216',4897851,'2846','429',308273.64,310075.15,1801.51,297249.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257216',4897852,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257216',4897853,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257216',4897854,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257216',4897855,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257216',4897856,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257216',4897857,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257217',4897858,'2843','429',348419.30,350741.17,2321.87,383108.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257217',4897859,'2844','429',225971.98,226933.61,961.63,158668.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257217',4897860,'2845','429',332257.65,334442.07,2184.42,360429.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257217',4897861,'2846','429',310075.15,311758.25,1683.10,277711.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257217',4897862,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257217',4897863,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257217',4897864,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257217',4897865,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257217',4897866,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257217',4897867,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257218',4897868,'2843','429',350741.17,353129.04,2387.87,393998.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257218',4897869,'2844','429',226933.61,228815.28,1881.67,310475.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257218',4897870,'2845','429',334442.07,336427.13,1985.06,327534.90,0.00,0.00,0.00,0.00,0.00),('5','184','958','257218',4897871,'2846','429',311758.25,312688.39,930.14,153473.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257218',4897872,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257218',4897873,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257218',4897874,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257218',4897875,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257218',4897876,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257218',4897877,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257219',4897878,'2843','429',353129.04,355617.48,2488.44,410592.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257219',4897879,'2844','429',228815.28,229987.30,1172.02,193383.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257219',4897880,'2845','429',336427.13,338524.34,2097.21,346039.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257219',4897881,'2846','429',312688.39,314739.02,2050.63,338353.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257219',4897882,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257219',4897883,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257219',4897884,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257219',4897885,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257219',4897886,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257219',4897887,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257220',4897888,'2843','429',355617.48,357493.31,1875.83,309511.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257220',4897889,'2844','429',229987.30,231006.37,1019.07,168146.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257220',4897890,'2845','429',338524.34,340753.57,2229.23,367822.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257220',4897891,'2846','429',314739.02,316886.47,2147.45,354329.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257220',4897892,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257220',4897893,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257220',4897894,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257220',4897895,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257220',4897896,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257220',4897897,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257221',4897898,'2843','429',357493.31,359783.90,2290.59,377947.35,0.00,0.00,0.00,0.00,0.00),('5','184','958','257221',4897899,'2844','429',231006.37,231752.24,745.87,123068.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257221',4897900,'2845','429',340753.57,342682.67,1929.10,318301.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257221',4897901,'2846','429',316886.47,318784.13,1897.66,313113.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257221',4897902,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257221',4897903,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257221',4897904,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257221',4897905,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257221',4897906,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257221',4897907,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257222',4897908,'2843','429',359783.90,362186.20,2402.30,396379.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257222',4897909,'2844','429',231752.24,232918.22,1165.98,192386.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257222',4897910,'2845','429',342682.67,345028.74,2346.07,387101.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257222',4897911,'2846','429',318784.13,320146.48,1362.35,224787.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257222',4897912,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257222',4897913,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257222',4897914,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257222',4897915,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257222',4897916,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257222',4897917,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257223',4897918,'2843','429',362186.20,364395.90,2209.70,364600.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257223',4897919,'2844','429',232918.22,233896.04,977.82,161340.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257223',4897920,'2845','429',345028.74,347036.04,2007.30,331204.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257223',4897921,'2846','429',320146.48,321924.86,1778.38,293432.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257223',4897922,'2847','429',222049.10,222049.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257223',4897923,'2848','429',157108.33,157108.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257223',4897924,'2849','429',168681.51,168681.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257223',4897925,'2850','429',192484.56,192484.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257223',4897926,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257223',4897927,'2852','431',66765.08,66765.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257224',4897928,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257224',4897929,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257224',4897930,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257224',4897931,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257224',4897932,'2847','429',226788.26,226957.75,169.49,31355.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257224',4897933,'2848','429',157108.33,159433.99,2325.66,430247.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257224',4897934,'2849','429',168698.57,170631.41,1932.84,357575.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257224',4897935,'2850','429',192484.56,193579.36,1094.80,202538.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257224',4897936,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257224',4897937,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257225',4897938,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257225',4897939,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257225',4897940,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257225',4897941,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257225',4897942,'2847','429',226957.75,226957.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257225',4897943,'2848','429',159433.99,161904.07,2470.08,456964.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257225',4897944,'2849','429',170631.41,172888.73,2257.32,417604.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257225',4897945,'2850','429',193579.36,195276.66,1697.30,314000.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257225',4897946,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257225',4897947,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257226',4897948,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257226',4897949,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257226',4897950,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257226',4897951,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257226',4897952,'2847','429',226957.75,227081.79,124.04,22947.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257226',4897953,'2848','429',161904.07,164603.16,2699.09,499331.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257226',4897954,'2849','429',172888.73,175289.10,2400.37,444068.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257226',4897955,'2850','429',195276.66,197142.39,1865.73,345160.05,0.00,0.00,0.00,0.00,0.00),('5','184','959','257226',4897956,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257226',4897957,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257227',4897958,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257227',4897959,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257227',4897960,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257227',4897961,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257227',4897962,'2847','429',227081.79,229391.58,2309.79,427311.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257227',4897963,'2848','429',164603.16,166758.67,2155.51,398769.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257227',4897964,'2849','429',175289.10,177464.73,2175.63,402491.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257227',4897965,'2850','429',197142.39,197142.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257227',4897966,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257227',4897967,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257228',4897968,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257228',4897969,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257228',4897970,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257228',4897971,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257228',4897972,'2847','429',229391.58,231499.45,2107.87,389955.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257228',4897973,'2848','429',166758.67,168620.53,1861.86,344444.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257228',4897974,'2849','429',177464.73,179243.60,1778.87,329090.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257228',4897975,'2850','429',197142.39,197874.80,732.41,135495.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257228',4897976,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257228',4897977,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257229',4897978,'2843','429',366991.55,366991.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257229',4897979,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257229',4897980,'2845','429',348737.38,348737.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257229',4897981,'2846','429',323066.48,323066.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257229',4897982,'2847','429',231499.45,233888.08,2388.63,441896.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257229',4897983,'2848','429',168620.53,170619.48,1998.95,369805.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257229',4897984,'2849','429',179243.60,181197.10,1953.50,361397.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257229',4897985,'2850','429',197874.80,198469.22,594.42,109967.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','257229',4897986,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257229',4897987,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257230',4897988,'2843','429',366991.55,369544.00,2552.45,472203.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257230',4897989,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257230',4897990,'2845','429',348737.38,351196.16,2458.78,454874.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257230',4897991,'2846','429',323066.48,324967.00,1900.52,351596.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257230',4897992,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257230',4897993,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257230',4897994,'2849','429',181197.10,181212.03,14.93,2762.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257230',4897995,'2850','429',198469.22,199228.72,759.50,140507.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257230',4897996,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257230',4897997,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257231',4897998,'2843','429',369544.00,371868.73,2324.73,430075.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257231',4897999,'2844','429',235316.85,235316.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257231',4898000,'2845','429',351196.16,353789.59,2593.43,479784.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257231',4898001,'2846','429',324967.00,327386.76,2419.76,447655.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257231',4898002,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257231',4898003,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257231',4898004,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257231',4898005,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257231',4898006,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257231',4898007,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257232',4898008,'2843','429',371868.73,374434.31,2565.58,474632.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257232',4898009,'2844','429',235316.85,236835.31,1518.46,280915.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257232',4898010,'2845','429',353789.59,356061.34,2271.75,420273.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257232',4898011,'2846','429',327386.76,329144.11,1757.35,325109.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257232',4898012,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257232',4898013,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257232',4898014,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257232',4898015,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257232',4898016,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257232',4898017,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257233',4898018,'2843','429',374434.31,377002.03,2567.72,475028.20,0.00,0.00,0.00,0.00,0.00),('5','184','958','257233',4898019,'2844','429',236835.31,237616.94,781.63,144601.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257233',4898020,'2845','429',356061.34,358720.50,2659.16,491944.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257233',4898021,'2846','429',329144.11,330952.33,1808.22,334520.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257233',4898022,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257233',4898023,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257233',4898024,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257233',4898025,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257233',4898026,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257233',4898027,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257234',4898028,'2843','429',377002.03,380198.70,3196.67,591383.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257234',4898029,'2844','429',237616.94,239680.99,2064.05,381849.25,0.00,0.00,0.00,0.00,0.00),('5','184','958','257234',4898030,'2845','429',358720.50,361268.59,2548.09,471396.65,0.00,0.00,0.00,0.00,0.00),('5','184','958','257234',4898031,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257234',4898032,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257234',4898033,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257234',4898034,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257234',4898035,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257234',4898036,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257234',4898037,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257235',4898038,'2843','429',380198.70,382951.63,2752.93,509292.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257235',4898039,'2844','429',239680.99,241480.47,1799.48,332903.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257235',4898040,'2845','429',361268.59,363621.59,2353.00,435305.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257235',4898041,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257235',4898042,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257235',4898043,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257235',4898044,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257235',4898045,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257235',4898046,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257235',4898047,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257236',4898048,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257236',4898049,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257236',4898050,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257236',4898051,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257236',4898052,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257236',4898053,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257236',4898054,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257236',4898055,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257236',4898056,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257236',4898057,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257237',4898058,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257237',4898059,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257237',4898060,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257237',4898061,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257237',4898062,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257237',4898063,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257237',4898064,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257237',4898065,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257237',4898066,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257237',4898067,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257238',4898068,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257238',4898069,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257238',4898070,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257238',4898071,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257238',4898072,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257238',4898073,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257238',4898074,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257238',4898075,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257238',4898076,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257238',4898077,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257239',4898078,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257239',4898079,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257239',4898080,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257239',4898081,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257239',4898082,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257239',4898083,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257239',4898084,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257239',4898085,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257239',4898086,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257239',4898087,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257240',4898088,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257240',4898089,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257240',4898090,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257240',4898091,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257240',4898092,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257240',4898093,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257240',4898094,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257240',4898095,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257240',4898096,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257240',4898097,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257241',4898098,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257241',4898099,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257241',4898100,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257241',4898101,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257241',4898102,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257241',4898103,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257241',4898104,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257241',4898105,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257241',4898106,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257241',4898107,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257242',4898108,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257242',4898109,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257242',4898110,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257242',4898111,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257242',4898112,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257242',4898113,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257242',4898114,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257242',4898115,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257242',4898116,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257242',4898117,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257243',4898118,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257243',4898119,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257243',4898120,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257243',4898121,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257243',4898122,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257243',4898123,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257243',4898124,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257243',4898125,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257243',4898126,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257243',4898127,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257244',4898128,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257244',4898129,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257244',4898130,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257244',4898131,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257244',4898132,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257244',4898133,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257244',4898134,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257244',4898135,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257244',4898136,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257244',4898137,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257245',4898138,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257245',4898139,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257245',4898140,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257245',4898141,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257245',4898142,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257245',4898143,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257245',4898144,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257245',4898145,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257245',4898146,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257245',4898147,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257246',4898148,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257246',4898149,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257246',4898150,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257246',4898151,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257246',4898152,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257246',4898153,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257246',4898154,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257246',4898155,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257246',4898156,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257246',4898157,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257247',4898158,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257247',4898159,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257247',4898160,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257247',4898161,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257247',4898162,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257247',4898163,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257247',4898164,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257247',4898165,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257247',4898166,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257247',4898167,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257248',4898168,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257248',4898169,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257248',4898170,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257248',4898171,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257248',4898172,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257248',4898173,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257248',4898174,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257248',4898175,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257248',4898176,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257248',4898177,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257249',4898178,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257249',4898179,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257249',4898180,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257249',4898181,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257249',4898182,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257249',4898183,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257249',4898184,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257249',4898185,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257249',4898186,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257249',4898187,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257250',4898188,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257250',4898189,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257250',4898190,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257250',4898191,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257250',4898192,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257250',4898193,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257250',4898194,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257250',4898195,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257250',4898196,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257250',4898197,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257251',4898198,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257251',4898199,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257251',4898200,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257251',4898201,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257251',4898202,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257251',4898203,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257251',4898204,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257251',4898205,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257251',4898206,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257251',4898207,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257252',4898208,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257252',4898209,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257252',4898210,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257252',4898211,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257252',4898212,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257252',4898213,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257252',4898214,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257252',4898215,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257252',4898216,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257252',4898217,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257253',4898218,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257253',4898219,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257253',4898220,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257253',4898221,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257253',4898222,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257253',4898223,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257253',4898224,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257253',4898225,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257253',4898226,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257253',4898227,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257254',4898228,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257254',4898229,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257254',4898230,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257254',4898231,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257254',4898232,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257254',4898233,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257254',4898234,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257254',4898235,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257254',4898236,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257254',4898237,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257255',4898238,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257255',4898239,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257255',4898240,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257255',4898241,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257255',4898242,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257255',4898243,'2848','429',170619.48,170619.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257255',4898244,'2849','429',181212.03,181212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257255',4898245,'2850','429',199228.72,199228.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257255',4898246,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257255',4898247,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257256',4898248,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257256',4898249,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257256',4898250,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257256',4898251,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257256',4898252,'2847','429',233888.08,233888.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257256',4898253,'2848','429',170619.48,173210.83,2591.35,479399.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257256',4898254,'2849','429',181212.03,186188.79,4976.76,920700.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257256',4898255,'2850','429',199228.72,202526.11,3297.39,610017.15,0.00,0.00,0.00,0.00,0.00),('5','184','959','257256',4898256,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257256',4898257,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257257',4898258,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257257',4898259,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257257',4898260,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257257',4898261,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257257',4898262,'2847','429',233888.08,235746.63,1858.55,343831.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257257',4898263,'2848','429',173210.83,173813.13,602.30,111425.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257257',4898264,'2849','429',186188.79,187828.89,1640.10,303418.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257257',4898265,'2850','429',202526.11,204962.48,2436.37,450728.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257257',4898266,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257257',4898267,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257258',4898268,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257258',4898269,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257258',4898270,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257258',4898271,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257258',4898272,'2847','429',235746.63,238506.59,2759.96,510592.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257258',4898273,'2848','429',173813.13,173821.83,8.70,1609.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257258',4898274,'2849','429',187828.89,188805.19,976.30,180615.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257258',4898275,'2850','429',204962.48,208813.39,3850.91,712418.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','257258',4898276,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257258',4898277,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257259',4898278,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257259',4898279,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257259',4898280,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257259',4898281,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257259',4898282,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257259',4898283,'2848','429',173821.83,175785.79,1963.96,363332.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257259',4898284,'2849','429',188805.19,191773.79,2968.60,549191.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257259',4898285,'2850','429',208813.39,208813.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257259',4898286,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257259',4898287,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257260',4898288,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257260',4898289,'2844','429',241480.47,241480.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257260',4898290,'2845','429',363621.59,363621.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257260',4898291,'2846','429',330952.33,330952.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257260',4898292,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257260',4898293,'2848','429',175785.79,178538.00,2752.21,509158.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257260',4898294,'2849','429',191773.79,196079.97,4306.18,796643.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257260',4898295,'2850','429',208813.39,211930.70,3117.31,576702.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','257260',4898296,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257260',4898297,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257261',4898298,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257261',4898299,'2844','429',241480.47,242306.86,826.39,152882.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257261',4898300,'2845','429',363621.59,366659.49,3037.90,562011.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257261',4898301,'2846','429',330952.33,330953.84,1.51,279.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257261',4898302,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257261',4898303,'2848','429',178538.00,180294.06,1756.06,324871.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257261',4898304,'2849','429',196079.97,198993.83,2913.86,539064.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257261',4898305,'2850','429',211930.70,212300.07,369.37,68333.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257261',4898306,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257261',4898307,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257262',4898308,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257262',4898309,'2844','429',242306.86,244534.25,2227.39,412067.15,0.00,0.00,0.00,0.00,0.00),('5','184','958','257262',4898310,'2845','429',366659.49,369786.02,3126.53,578408.05,0.00,0.00,0.00,0.00,0.00),('5','184','958','257262',4898311,'2846','429',330953.84,330953.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257262',4898312,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257262',4898313,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257262',4898314,'2849','429',198993.83,203839.81,4845.98,896506.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257262',4898315,'2850','429',212300.07,212300.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257262',4898316,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257262',4898317,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257263',4898318,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257263',4898319,'2844','429',244534.25,247014.41,2480.16,458829.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257263',4898320,'2845','429',369786.02,373689.92,3903.90,722221.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257263',4898321,'2846','429',330953.84,330953.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257263',4898322,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257263',4898323,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257263',4898324,'2849','429',203839.81,208106.30,4266.49,789300.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257263',4898325,'2850','429',212300.07,212300.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257263',4898326,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257263',4898327,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257264',4898328,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257264',4898329,'2844','429',247014.41,249218.01,2203.60,407666.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257264',4898330,'2845','429',373689.92,373689.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257264',4898331,'2846','429',330953.84,334150.24,3196.40,591334.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257264',4898332,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257264',4898333,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257264',4898334,'2849','429',208106.30,212633.65,4527.35,837559.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257264',4898335,'2850','429',212300.07,212300.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257264',4898336,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257264',4898337,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257265',4898338,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257265',4898339,'2844','429',249218.01,251189.68,1971.67,364758.95,0.00,0.00,0.00,0.00,0.00),('5','184','958','257265',4898340,'2845','429',373689.92,373689.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257265',4898341,'2846','429',334150.24,336910.82,2760.58,510707.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257265',4898342,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257265',4898343,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257265',4898344,'2849','429',212633.65,217732.23,5098.58,943237.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257265',4898345,'2850','429',212300.07,212557.90,257.83,47698.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257265',4898346,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257265',4898347,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257266',4898348,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257266',4898349,'2844','429',251189.68,253255.43,2065.75,382163.75,0.00,0.00,0.00,0.00,0.00),('5','184','958','257266',4898350,'2845','429',373689.92,374247.75,557.83,103198.55,0.00,0.00,0.00,0.00,0.00),('5','184','958','257266',4898351,'2846','429',336910.82,339805.03,2894.21,535428.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257266',4898352,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257266',4898353,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257266',4898354,'2849','429',217732.23,221551.70,3819.47,706601.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257266',4898355,'2850','429',212557.90,212557.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257266',4898356,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257266',4898357,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257267',4898358,'2843','429',382951.63,382951.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257267',4898359,'2844','429',253255.43,255212.24,1956.81,362009.85,0.00,0.00,0.00,0.00,0.00),('5','184','958','257267',4898360,'2845','429',374247.75,375408.13,1160.38,214670.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257267',4898361,'2846','429',339805.03,342484.01,2678.98,495611.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257267',4898362,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257267',4898363,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257267',4898364,'2849','429',221551.70,221551.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257267',4898365,'2850','429',212557.90,212557.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257267',4898366,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257267',4898367,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257268',4898368,'2843','429',382951.63,383196.99,245.36,45391.60,0.00,0.00,0.00,0.00,0.00),('5','184','958','257268',4898369,'2844','429',255212.24,255835.30,623.06,115266.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257268',4898370,'2845','429',375408.13,376408.61,1000.48,185088.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257268',4898371,'2846','429',342484.01,343672.82,1188.81,219929.85,0.00,0.00,0.00,0.00,0.00),('5','184','957','257268',4898372,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257268',4898373,'2848','429',180294.06,180294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257268',4898374,'2849','429',221551.70,229493.66,7941.96,1469262.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257268',4898375,'2850','429',212557.90,212557.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257268',4898376,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257268',4898377,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257269',4898378,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257269',4898379,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257269',4898380,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257269',4898381,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257269',4898382,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257269',4898383,'2848','429',180294.06,182958.37,2664.31,492897.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257269',4898384,'2849','429',229493.66,229493.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257269',4898385,'2850','429',212557.90,216937.55,4379.65,810235.25,0.00,0.00,0.00,0.00,0.00),('5','184','959','257269',4898386,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257269',4898387,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257270',4898388,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257270',4898389,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257270',4898390,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257270',4898391,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257270',4898392,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257270',4898393,'2848','429',182958.37,185160.12,2201.75,407323.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257270',4898394,'2849','429',229493.66,230852.56,1358.90,251396.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257270',4898395,'2850','429',216937.55,220343.32,3405.77,630067.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257270',4898396,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257270',4898397,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257271',4898398,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257271',4898399,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257271',4898400,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257271',4898401,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257271',4898402,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257271',4898403,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257271',4898404,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257271',4898405,'2850','429',220343.32,220733.35,390.03,72155.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257271',4898406,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257271',4898407,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257272',4898408,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257272',4898409,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257272',4898410,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257272',4898411,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257272',4898412,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257272',4898413,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257272',4898414,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257272',4898415,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257272',4898416,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257272',4898417,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257273',4898418,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257273',4898419,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257273',4898420,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257273',4898421,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257273',4898422,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257273',4898423,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257273',4898424,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257273',4898425,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257273',4898426,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257273',4898427,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257274',4898428,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257274',4898429,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257274',4898430,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257274',4898431,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257274',4898432,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257274',4898433,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257274',4898434,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257274',4898435,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257274',4898436,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257274',4898437,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257275',4898438,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257275',4898439,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257275',4898440,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257275',4898441,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257275',4898442,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257275',4898443,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257275',4898444,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257275',4898445,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257275',4898446,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257275',4898447,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257276',4898448,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257276',4898449,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257276',4898450,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257276',4898451,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257276',4898452,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257276',4898453,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257276',4898454,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257276',4898455,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257276',4898456,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257276',4898457,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257277',4898458,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257277',4898459,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257277',4898460,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257277',4898461,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257277',4898462,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257277',4898463,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257277',4898464,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257277',4898465,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257277',4898466,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257277',4898467,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257278',4898468,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257278',4898469,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257278',4898470,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257278',4898471,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257278',4898472,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257278',4898473,'2848','429',185160.12,185160.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257278',4898474,'2849','429',230852.56,230852.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257278',4898475,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257278',4898476,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257278',4898477,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257279',4898478,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257279',4898479,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257279',4898480,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257279',4898481,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257279',4898482,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257279',4898483,'2848','429',185160.12,185994.60,834.48,154378.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257279',4898484,'2849','429',230852.56,232747.86,1895.30,350630.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257279',4898485,'2850','429',220733.35,220733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257279',4898486,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257279',4898487,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257280',4898488,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257280',4898489,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257280',4898490,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257280',4898491,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257280',4898492,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257280',4898493,'2848','429',185994.60,187978.39,1983.79,367001.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257280',4898494,'2849','429',232747.86,236461.13,3713.27,686954.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257280',4898495,'2850','429',220733.35,223768.76,3035.41,561550.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257280',4898496,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257280',4898497,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257281',4898498,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257281',4898499,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257281',4898500,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257281',4898501,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257281',4898502,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257281',4898503,'2848','429',187978.39,188351.75,373.36,69071.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257281',4898504,'2849','429',236461.13,240764.13,4303.00,796055.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257281',4898505,'2850','429',223768.76,226259.80,2491.04,460842.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257281',4898506,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257281',4898507,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257282',4898508,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257282',4898509,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257282',4898510,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257282',4898511,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257282',4898512,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257282',4898513,'2848','429',188351.75,190428.58,2076.83,384213.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257282',4898514,'2849','429',240764.13,245074.12,4309.99,797348.15,0.00,0.00,0.00,0.00,0.00),('5','184','957','257282',4898515,'2850','429',226259.80,228034.28,1774.48,328278.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257282',4898516,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257282',4898517,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257283',4898518,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257283',4898519,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257283',4898520,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257283',4898521,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257283',4898522,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257283',4898523,'2848','429',190428.58,192376.11,1947.53,360293.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257283',4898524,'2849','429',245074.12,247714.86,2640.74,488536.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257283',4898525,'2850','429',228034.28,229706.92,1672.64,309438.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257283',4898526,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257283',4898527,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257284',4898528,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257284',4898529,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257284',4898530,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257284',4898531,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257284',4898532,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257284',4898533,'2848','429',192376.11,193634.31,1258.20,232767.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257284',4898534,'2849','429',247714.86,249757.88,2043.02,377958.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257284',4898535,'2850','429',229706.92,231811.36,2104.44,389321.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257284',4898536,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257284',4898537,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257285',4898538,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257285',4898539,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257285',4898540,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257285',4898541,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257285',4898542,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257285',4898543,'2848','429',193634.31,193634.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257285',4898544,'2849','429',249757.88,250528.44,770.56,142553.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257285',4898545,'2850','429',231811.36,232507.19,695.83,128728.55,0.00,0.00,0.00,0.00,0.00),('5','184','959','257285',4898546,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257285',4898547,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257286',4898548,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257286',4898549,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257286',4898550,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257286',4898551,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257286',4898552,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257286',4898553,'2848','429',193634.31,193634.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257286',4898554,'2849','429',250528.44,250528.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257286',4898555,'2850','429',232507.19,232507.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257286',4898556,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257286',4898557,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257287',4898558,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257287',4898559,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257287',4898560,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257287',4898561,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257287',4898562,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257287',4898563,'2848','429',193634.31,193634.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257287',4898564,'2849','429',250528.44,250528.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257287',4898565,'2850','429',232507.19,232507.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257287',4898566,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257287',4898567,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257288',4898568,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257288',4898569,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257288',4898570,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257288',4898571,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257288',4898572,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257288',4898573,'2848','429',193634.31,194110.87,476.56,88163.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257288',4898574,'2849','429',250528.44,251743.34,1214.90,224756.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257288',4898575,'2850','429',232507.19,233818.64,1311.45,242618.25,0.00,0.00,0.00,0.00,0.00),('5','184','959','257288',4898576,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257288',4898577,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257289',4898578,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257289',4898579,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257289',4898580,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257289',4898581,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257289',4898582,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257289',4898583,'2848','429',194110.87,197697.81,3586.94,663583.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257289',4898584,'2849','429',251743.34,256853.19,5109.85,945322.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257289',4898585,'2850','429',233818.64,238785.95,4967.31,918952.35,0.00,0.00,0.00,0.00,0.00),('5','184','959','257289',4898586,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257289',4898587,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257290',4898588,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257290',4898589,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257290',4898590,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257290',4898591,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257290',4898592,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257290',4898593,'2848','429',197697.81,199266.28,1568.47,290166.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257290',4898594,'2849','429',256853.19,261017.17,4163.98,770336.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257290',4898595,'2850','429',238785.95,238785.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257290',4898596,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257290',4898597,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257291',4898598,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257291',4898599,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257291',4898600,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257291',4898601,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257291',4898602,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257291',4898603,'2848','429',199266.28,200830.60,1564.32,289399.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257291',4898604,'2849','429',261017.17,262906.50,1889.33,349526.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257291',4898605,'2850','429',238785.95,243460.97,4675.02,864878.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','257291',4898606,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257291',4898607,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257292',4898608,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257292',4898609,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257292',4898610,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257292',4898611,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257292',4898612,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257292',4898613,'2848','429',200830.60,202521.90,1691.30,312890.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257292',4898614,'2849','429',262906.50,262906.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257292',4898615,'2850','429',243460.97,247654.77,4193.80,775853.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257292',4898616,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257292',4898617,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257293',4898618,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257293',4898619,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257293',4898620,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257293',4898621,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257293',4898622,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257293',4898623,'2848','429',202521.90,203824.55,1302.65,240990.25,0.00,0.00,0.00,0.00,0.00),('5','184','957','257293',4898624,'2849','429',262906.50,267200.46,4293.96,794382.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257293',4898625,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257293',4898626,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257293',4898627,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257294',4898628,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257294',4898629,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257294',4898630,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257294',4898631,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257294',4898632,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257294',4898633,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257294',4898634,'2849','429',267200.46,270156.53,2956.07,546872.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257294',4898635,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257294',4898636,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257294',4898637,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257295',4898638,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257295',4898639,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257295',4898640,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257295',4898641,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257295',4898642,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257295',4898643,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257295',4898644,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257295',4898645,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257295',4898646,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257295',4898647,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257296',4898648,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257296',4898649,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257296',4898650,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257296',4898651,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257296',4898652,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257296',4898653,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257296',4898654,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257296',4898655,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257296',4898656,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257296',4898657,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257297',4898658,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257297',4898659,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257297',4898660,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257297',4898661,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257297',4898662,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257297',4898663,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257297',4898664,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257297',4898665,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257297',4898666,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257297',4898667,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257298',4898668,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257298',4898669,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257298',4898670,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257298',4898671,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257298',4898672,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257298',4898673,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257298',4898674,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257298',4898675,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257298',4898676,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257298',4898677,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257299',4898678,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257299',4898679,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257299',4898680,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257299',4898681,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257299',4898682,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257299',4898683,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257299',4898684,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257299',4898685,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257299',4898686,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257299',4898687,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257300',4898688,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257300',4898689,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257300',4898690,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257300',4898691,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257300',4898692,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257300',4898693,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257300',4898694,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257300',4898695,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257300',4898696,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257300',4898697,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257301',4898698,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257301',4898699,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257301',4898700,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257301',4898701,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257301',4898702,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257301',4898703,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257301',4898704,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257301',4898705,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257301',4898706,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257301',4898707,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257302',4898708,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257302',4898709,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257302',4898710,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257302',4898711,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257302',4898712,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257302',4898713,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257302',4898714,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257302',4898715,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257302',4898716,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257302',4898717,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257303',4898718,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257303',4898719,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257303',4898720,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257303',4898721,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257303',4898722,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257303',4898723,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257303',4898724,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257303',4898725,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257303',4898726,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257303',4898727,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257304',4898728,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257304',4898729,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257304',4898730,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257304',4898731,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257304',4898732,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257304',4898733,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257304',4898734,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257304',4898735,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257304',4898736,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257304',4898737,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257305',4898738,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257305',4898739,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257305',4898740,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257305',4898741,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257305',4898742,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257305',4898743,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257305',4898744,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257305',4898745,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257305',4898746,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257305',4898747,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257306',4898748,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257306',4898749,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257306',4898750,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257306',4898751,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257306',4898752,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257306',4898753,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257306',4898754,'2849','429',270156.53,270156.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257306',4898755,'2850','429',247654.77,247654.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257306',4898756,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257306',4898757,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257307',4898758,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257307',4898759,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257307',4898760,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257307',4898761,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257307',4898762,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257307',4898763,'2848','429',203824.55,203824.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257307',4898764,'2849','429',270156.53,271575.76,1419.23,262557.55,0.00,0.00,0.00,0.00,0.00),('5','184','957','257307',4898765,'2850','429',247654.77,248493.78,839.01,155216.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257307',4898766,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257307',4898767,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257308',4898768,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257308',4898769,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257308',4898770,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257308',4898771,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257308',4898772,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257308',4898773,'2848','429',203824.55,205062.93,1238.38,229100.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257308',4898774,'2849','429',271575.76,274813.87,3238.11,599050.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257308',4898775,'2850','429',248493.78,250195.03,1701.25,314731.25,0.00,0.00,0.00,0.00,0.00),('5','184','959','257308',4898776,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257308',4898777,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257309',4898778,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257309',4898779,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257309',4898780,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257309',4898781,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257309',4898782,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257309',4898783,'2848','429',205062.93,207652.28,2589.35,479029.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257309',4898784,'2849','429',274813.87,279492.00,4678.13,865454.05,0.00,0.00,0.00,0.00,0.00),('5','184','957','257309',4898785,'2850','429',250195.03,250195.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257309',4898786,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257309',4898787,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257310',4898788,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257310',4898789,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257310',4898790,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257310',4898791,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257310',4898792,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257310',4898793,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257310',4898794,'2849','429',279492.00,282792.71,3300.71,610631.35,0.00,0.00,0.00,0.00,0.00),('5','184','957','257310',4898795,'2850','429',250195.03,255394.58,5199.55,961916.75,0.00,0.00,0.00,0.00,0.00),('5','184','959','257310',4898796,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257310',4898797,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257311',4898798,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257311',4898799,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257311',4898800,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257311',4898801,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257311',4898802,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257311',4898803,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257311',4898804,'2849','429',282792.71,285808.47,3015.76,557915.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257311',4898805,'2850','429',255394.58,255394.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257311',4898806,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257311',4898807,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257312',4898808,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257312',4898809,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257312',4898810,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257312',4898811,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257312',4898812,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257312',4898813,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257312',4898814,'2849','429',285808.47,288147.75,2339.28,432766.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257312',4898815,'2850','429',255394.58,255775.72,381.14,70510.90,0.00,0.00,0.00,0.00,0.00),('5','184','959','257312',4898816,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257312',4898817,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257313',4898818,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257313',4898819,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257313',4898820,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257313',4898821,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257313',4898822,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257313',4898823,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257313',4898824,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257313',4898825,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257313',4898826,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257313',4898827,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257314',4898828,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257314',4898829,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257314',4898830,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257314',4898831,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257314',4898832,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257314',4898833,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257314',4898834,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257314',4898835,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257314',4898836,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257314',4898837,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257315',4898838,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257315',4898839,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257315',4898840,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257315',4898841,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257315',4898842,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257315',4898843,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257315',4898844,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257315',4898845,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257315',4898846,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257315',4898847,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257316',4898848,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257316',4898849,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257316',4898850,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257316',4898851,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257316',4898852,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257316',4898853,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257316',4898854,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257316',4898855,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257316',4898856,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257316',4898857,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257317',4898858,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257317',4898859,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257317',4898860,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257317',4898861,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257317',4898862,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257317',4898863,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257317',4898864,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257317',4898865,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257317',4898866,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257317',4898867,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257318',4898868,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257318',4898869,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257318',4898870,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257318',4898871,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257318',4898872,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257318',4898873,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257318',4898874,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257318',4898875,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257318',4898876,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257318',4898877,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257319',4898878,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257319',4898879,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257319',4898880,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257319',4898881,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257319',4898882,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257319',4898883,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257319',4898884,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257319',4898885,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257319',4898886,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257319',4898887,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257320',4898888,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257320',4898889,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257320',4898890,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257320',4898891,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257320',4898892,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257320',4898893,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257320',4898894,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257320',4898895,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257320',4898896,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257320',4898897,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257321',4898898,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257321',4898899,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257321',4898900,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257321',4898901,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257321',4898902,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257321',4898903,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257321',4898904,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257321',4898905,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257321',4898906,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257321',4898907,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257322',4898908,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257322',4898909,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257322',4898910,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257322',4898911,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257322',4898912,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257322',4898913,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257322',4898914,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257322',4898915,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257322',4898916,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257322',4898917,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257323',4898918,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257323',4898919,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257323',4898920,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257323',4898921,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257323',4898922,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257323',4898923,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257323',4898924,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257323',4898925,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257323',4898926,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257323',4898927,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257324',4898928,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257324',4898929,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257324',4898930,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257324',4898931,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257324',4898932,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257324',4898933,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257324',4898934,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257324',4898935,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257324',4898936,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257324',4898937,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257325',4898938,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257325',4898939,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257325',4898940,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257325',4898941,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257325',4898942,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257325',4898943,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257325',4898944,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257325',4898945,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257325',4898946,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257325',4898947,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257326',4898948,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257326',4898949,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257326',4898950,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257326',4898951,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257326',4898952,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257326',4898953,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257326',4898954,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257326',4898955,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257326',4898956,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257326',4898957,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257327',4898958,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257327',4898959,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257327',4898960,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257327',4898961,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257327',4898962,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257327',4898963,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257327',4898964,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257327',4898965,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257327',4898966,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257327',4898967,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257328',4898968,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257328',4898969,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257328',4898970,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257328',4898971,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257328',4898972,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257328',4898973,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257328',4898974,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257328',4898975,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257328',4898976,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257328',4898977,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257329',4898978,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257329',4898979,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257329',4898980,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257329',4898981,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257329',4898982,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257329',4898983,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257329',4898984,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257329',4898985,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257329',4898986,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257329',4898987,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257330',4898988,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257330',4898989,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257330',4898990,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257330',4898991,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257330',4898992,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257330',4898993,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257330',4898994,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257330',4898995,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257330',4898996,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257330',4898997,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257331',4898998,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257331',4898999,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257331',4899000,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257331',4899001,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257331',4899002,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257331',4899003,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257331',4899004,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257331',4899005,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257331',4899006,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257331',4899007,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257332',4899008,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257332',4899009,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257332',4899010,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257332',4899011,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257332',4899012,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257332',4899013,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257332',4899014,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257332',4899015,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257332',4899016,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257332',4899017,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257333',4899018,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257333',4899019,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257333',4899020,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257333',4899021,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257333',4899022,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257333',4899023,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257333',4899024,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257333',4899025,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257333',4899026,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257333',4899027,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257334',4899028,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257334',4899029,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257334',4899030,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257334',4899031,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257334',4899032,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257334',4899033,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257334',4899034,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257334',4899035,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257334',4899036,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257334',4899037,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257335',4899038,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257335',4899039,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257335',4899040,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257335',4899041,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257335',4899042,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257335',4899043,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257335',4899044,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257335',4899045,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257335',4899046,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257335',4899047,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257336',4899048,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257336',4899049,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257336',4899050,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257336',4899051,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257336',4899052,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257336',4899053,'2848','429',207652.28,207652.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257336',4899054,'2849','429',288147.75,288147.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257336',4899055,'2850','429',255775.72,255775.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257336',4899056,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257336',4899057,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257337',4899058,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257337',4899059,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257337',4899060,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257337',4899061,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257337',4899062,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257337',4899063,'2848','429',207652.28,210503.03,2850.75,527388.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257337',4899064,'2849','429',288147.75,290403.30,2255.55,417276.75,0.00,0.00,0.00,0.00,0.00),('5','184','957','257337',4899065,'2850','429',255775.72,257893.56,2117.84,391800.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257337',4899066,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257337',4899067,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257338',4899068,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257338',4899069,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257338',4899070,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257338',4899071,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257338',4899072,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257338',4899073,'2848','429',210503.03,213149.92,2646.89,489674.65,0.00,0.00,0.00,0.00,0.00),('5','184','957','257338',4899074,'2849','429',290403.30,295742.17,5338.87,987690.95,0.00,0.00,0.00,0.00,0.00),('5','184','957','257338',4899075,'2850','429',257893.56,261569.00,3675.44,679956.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257338',4899076,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257338',4899077,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257339',4899078,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257339',4899079,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257339',4899080,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257339',4899081,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257339',4899082,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257339',4899083,'2848','429',213149.92,215309.54,2159.62,399529.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257339',4899084,'2849','429',295742.17,300150.33,4408.16,815509.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257339',4899085,'2850','429',261569.00,262136.77,567.77,105037.45,0.00,0.00,0.00,0.00,0.00),('5','184','959','257339',4899086,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257339',4899087,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257340',4899088,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257340',4899089,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257340',4899090,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257340',4899091,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257340',4899092,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257340',4899093,'2848','429',215309.54,217484.26,2174.72,402323.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257340',4899094,'2849','429',300150.33,302582.50,2432.17,449951.45,0.00,0.00,0.00,0.00,0.00),('5','184','957','257340',4899095,'2850','429',262136.77,263288.85,1152.08,213134.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257340',4899096,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257340',4899097,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257341',4899098,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257341',4899099,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257341',4899100,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257341',4899101,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257341',4899102,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257341',4899103,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257341',4899104,'2849','429',302582.50,304334.37,1751.87,385411.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257341',4899105,'2850','429',263288.85,265994.91,2706.06,595333.20,0.00,0.00,0.00,0.00,0.00),('5','184','959','257341',4899106,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257341',4899107,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257342',4899108,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257342',4899109,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257342',4899110,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257342',4899111,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257342',4899112,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257342',4899113,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257342',4899114,'2849','429',304334.37,306160.87,1826.50,401830.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257342',4899115,'2850','429',265994.91,267450.15,1455.24,320152.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257342',4899116,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257342',4899117,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257343',4899118,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257343',4899119,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257343',4899120,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257343',4899121,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257343',4899122,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257343',4899123,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257343',4899124,'2849','429',306160.87,306160.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257343',4899125,'2850','429',267450.15,267450.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257343',4899126,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257343',4899127,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257344',4899128,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257344',4899129,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257344',4899130,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257344',4899131,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257344',4899132,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257344',4899133,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257344',4899134,'2849','429',306160.87,306160.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257344',4899135,'2850','429',267450.15,267450.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257344',4899136,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257344',4899137,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257345',4899138,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257345',4899139,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257345',4899140,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257345',4899141,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257345',4899142,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257345',4899143,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257345',4899144,'2849','429',306160.87,306160.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257345',4899145,'2850','429',267450.15,267450.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257345',4899146,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257345',4899147,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257346',4899148,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257346',4899149,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257346',4899150,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257346',4899151,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257346',4899152,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257346',4899153,'2848','429',217484.26,217484.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257346',4899154,'2849','429',306160.87,306160.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257346',4899155,'2850','429',267450.15,267450.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257346',4899156,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257346',4899157,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257347',4899158,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257347',4899159,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257347',4899160,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257347',4899161,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257347',4899162,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257347',4899163,'2848','429',217484.26,219258.68,1774.42,390372.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257347',4899164,'2849','429',306160.87,309770.30,3609.43,794074.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257347',4899165,'2850','429',267450.15,269641.39,2191.24,482072.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257347',4899166,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257347',4899167,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257348',4899168,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257348',4899169,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257348',4899170,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257348',4899171,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257348',4899172,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257348',4899173,'2848','429',219258.68,221216.29,1957.61,430674.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257348',4899174,'2849','429',309770.30,312979.50,3209.20,706024.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257348',4899175,'2850','429',269641.39,272292.96,2651.57,583345.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257348',4899176,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257348',4899177,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257349',4899178,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257349',4899179,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257349',4899180,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257349',4899181,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257349',4899182,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257349',4899183,'2848','429',221216.29,222539.98,1323.69,291211.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257349',4899184,'2849','429',312979.50,315988.33,3008.83,661942.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257349',4899185,'2850','429',272292.96,274445.50,2152.54,473558.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257349',4899186,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257349',4899187,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257350',4899188,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257350',4899189,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257350',4899190,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257350',4899191,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257350',4899192,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257350',4899193,'2848','429',222539.98,223678.43,1138.45,250459.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257350',4899194,'2849','429',315988.33,321088.10,5099.77,1121949.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257350',4899195,'2850','429',274445.50,278025.88,3580.38,787683.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','257350',4899196,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257350',4899197,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257351',4899198,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257351',4899199,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257351',4899200,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257351',4899201,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257351',4899202,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257351',4899203,'2848','429',223678.43,223678.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257351',4899204,'2849','429',321088.10,321088.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257351',4899205,'2850','429',278025.88,278025.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257351',4899206,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257351',4899207,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257352',4899208,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257352',4899209,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257352',4899210,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257352',4899211,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257352',4899212,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257352',4899213,'2848','429',223678.43,223678.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257352',4899214,'2849','429',321088.10,321088.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257352',4899215,'2850','429',278025.88,278025.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257352',4899216,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257352',4899217,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257353',4899218,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257353',4899219,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257353',4899220,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257353',4899221,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257353',4899222,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257353',4899223,'2848','429',223678.43,225677.92,1999.49,439887.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257353',4899224,'2849','429',321088.10,322890.21,1802.11,396464.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257353',4899225,'2850','429',278025.88,280510.55,2484.67,546627.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257353',4899226,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257353',4899227,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257354',4899228,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257354',4899229,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257354',4899230,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257354',4899231,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257354',4899232,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257354',4899233,'2848','429',225677.92,226032.45,354.53,77996.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257354',4899234,'2849','429',322890.21,325018.61,2128.40,468248.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257354',4899235,'2850','429',280510.55,282069.57,1559.02,342984.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257354',4899236,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257354',4899237,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257355',4899238,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257355',4899239,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257355',4899240,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257355',4899241,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257355',4899242,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257355',4899243,'2848','429',226032.45,226764.75,732.30,161106.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257355',4899244,'2849','429',325018.61,328231.30,3212.69,706791.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257355',4899245,'2850','429',282069.57,284207.72,2138.15,470393.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257355',4899246,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257355',4899247,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257356',4899248,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257356',4899249,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257356',4899250,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257356',4899251,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257356',4899252,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257356',4899253,'2848','429',226764.75,226764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257356',4899254,'2849','429',328231.30,328231.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257356',4899255,'2850','429',284207.72,284785.93,578.21,106968.85,0.00,0.00,0.00,0.00,0.00),('5','184','959','257356',4899256,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257356',4899257,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257357',4899258,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257357',4899259,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257357',4899260,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257357',4899261,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257357',4899262,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257357',4899263,'2848','429',226764.75,226764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257357',4899264,'2849','429',328231.30,328231.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257357',4899265,'2850','429',284785.93,284785.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257357',4899266,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257357',4899267,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257358',4899268,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257358',4899269,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257358',4899270,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257358',4899271,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257358',4899272,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257358',4899273,'2848','429',226764.75,226764.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257358',4899274,'2849','429',328231.30,328231.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257358',4899275,'2850','429',284785.93,284785.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257358',4899276,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257358',4899277,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257359',4899278,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257359',4899279,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257359',4899280,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257359',4899281,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257359',4899282,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257359',4899283,'2848','429',226764.75,229304.05,2539.30,558646.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257359',4899284,'2849','429',328231.30,330508.95,2277.65,501083.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257359',4899285,'2850','429',284785.93,286244.00,1458.07,320775.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257359',4899286,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257359',4899287,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257360',4899288,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257360',4899289,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257360',4899290,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257360',4899291,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257360',4899292,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257360',4899293,'2848','429',229304.05,231022.85,1718.80,378136.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257360',4899294,'2849','429',330508.95,332372.78,1863.83,410042.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257360',4899295,'2850','429',286244.00,288627.64,2383.64,524400.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257360',4899296,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257360',4899297,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257361',4899298,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257361',4899299,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257361',4899300,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257361',4899301,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257361',4899302,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257361',4899303,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257361',4899304,'2849','429',332372.78,333762.60,1389.82,305760.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257361',4899305,'2850','429',288627.64,290015.32,1387.68,305289.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','257361',4899306,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257361',4899307,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257362',4899308,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257362',4899309,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257362',4899310,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257362',4899311,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257362',4899312,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257362',4899313,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257362',4899314,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257362',4899315,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257362',4899316,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257362',4899317,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257363',4899318,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257363',4899319,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257363',4899320,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257363',4899321,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257363',4899322,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257363',4899323,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257363',4899324,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257363',4899325,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257363',4899326,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257363',4899327,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257364',4899328,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257364',4899329,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257364',4899330,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257364',4899331,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257364',4899332,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257364',4899333,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257364',4899334,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257364',4899335,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257364',4899336,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257364',4899337,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257365',4899338,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257365',4899339,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257365',4899340,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257365',4899341,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257365',4899342,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257365',4899343,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257365',4899344,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257365',4899345,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257365',4899346,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257365',4899347,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257366',4899348,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257366',4899349,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257366',4899350,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257366',4899351,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257366',4899352,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257366',4899353,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257366',4899354,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257366',4899355,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257366',4899356,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257366',4899357,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257367',4899358,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257367',4899359,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257367',4899360,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257367',4899361,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257367',4899362,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257367',4899363,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257367',4899364,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257367',4899365,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257367',4899366,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257367',4899367,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257368',4899368,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257368',4899369,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257368',4899370,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257368',4899371,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257368',4899372,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257368',4899373,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257368',4899374,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257368',4899375,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257368',4899376,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257368',4899377,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257369',4899378,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257369',4899379,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257369',4899380,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257369',4899381,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257369',4899382,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257369',4899383,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257369',4899384,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257369',4899385,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257369',4899386,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257369',4899387,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257370',4899388,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257370',4899389,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257370',4899390,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257370',4899391,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257370',4899392,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257370',4899393,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257370',4899394,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257370',4899395,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257370',4899396,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257370',4899397,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257371',4899398,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257371',4899399,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257371',4899400,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257371',4899401,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257371',4899402,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257371',4899403,'2848','429',231022.85,231022.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257371',4899404,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257371',4899405,'2850','429',290015.32,290015.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257371',4899406,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257371',4899407,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257372',4899408,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257372',4899409,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257372',4899410,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257372',4899411,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257372',4899412,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257372',4899413,'2848','429',231022.85,231436.55,413.70,86877.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257372',4899414,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257372',4899415,'2850','429',290015.32,290851.48,836.16,175593.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','257372',4899416,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257372',4899417,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257373',4899418,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257373',4899419,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257373',4899420,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257373',4899421,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257373',4899422,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257373',4899423,'2848','429',231436.55,231436.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257373',4899424,'2849','429',333762.60,333762.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257373',4899425,'2850','429',290851.48,290851.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257373',4899426,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257373',4899427,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257374',4899428,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257374',4899429,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257374',4899430,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257374',4899431,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257374',4899432,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257374',4899433,'2848','429',231436.55,232798.04,1361.49,285912.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257374',4899434,'2849','429',333762.60,335446.53,1683.93,353625.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257374',4899435,'2850','429',290851.48,292415.36,1563.88,328414.80,0.00,0.00,0.00,0.00,0.00),('5','184','959','257374',4899436,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257374',4899437,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257375',4899438,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257375',4899439,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257375',4899440,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257375',4899441,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257375',4899442,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257375',4899443,'2848','429',232798.04,234506.09,1708.05,358690.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257375',4899444,'2849','429',335446.53,337356.45,1909.92,401083.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257375',4899445,'2850','429',292415.36,293747.11,1331.75,279667.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257375',4899446,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257375',4899447,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257376',4899448,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257376',4899449,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257376',4899450,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257376',4899451,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257376',4899452,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257376',4899453,'2848','429',234506.09,236358.81,1852.72,389071.20,0.00,0.00,0.00,0.00,0.00),('5','184','957','257376',4899454,'2849','429',337356.45,340027.32,2670.87,560882.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257376',4899455,'2850','429',293747.11,295845.26,2098.15,440611.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257376',4899456,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257376',4899457,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257377',4899458,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257377',4899459,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257377',4899460,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257377',4899461,'2846','429',343672.82,343672.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257377',4899462,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257377',4899463,'2848','429',236358.81,238974.49,2615.68,549292.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257377',4899464,'2849','429',340027.32,343097.80,3070.48,644800.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257377',4899465,'2850','429',295845.26,298256.02,2410.76,506259.60,0.00,0.00,0.00,0.00,0.00),('5','184','959','257377',4899466,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257377',4899467,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257378',4899468,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257378',4899469,'2844','429',255835.30,255835.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257378',4899470,'2845','429',376408.61,376408.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257378',4899471,'2846','429',343672.82,346600.55,2927.73,614823.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257378',4899472,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257378',4899473,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257378',4899474,'2849','429',343097.80,345308.58,2210.78,464263.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257378',4899475,'2850','429',298256.02,300242.69,1986.67,417200.70,0.00,0.00,0.00,0.00,0.00),('5','184','959','257378',4899476,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257378',4899477,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257379',4899478,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257379',4899479,'2844','429',255835.30,258520.71,2685.41,563936.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257379',4899480,'2845','429',376408.61,379137.99,2729.38,573169.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257379',4899481,'2846','429',346600.55,349366.56,2766.01,580862.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257379',4899482,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257379',4899483,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257379',4899484,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257379',4899485,'2850','429',300242.69,300242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257379',4899486,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257379',4899487,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257380',4899488,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257380',4899489,'2844','429',258520.71,261201.39,2680.68,562942.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257380',4899490,'2845','429',379137.99,381615.26,2477.27,520226.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257380',4899491,'2846','429',349366.56,352273.13,2906.57,610379.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257380',4899492,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257380',4899493,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257380',4899494,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257380',4899495,'2850','429',300242.69,300242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257380',4899496,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257380',4899497,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257381',4899498,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257381',4899499,'2844','429',261201.39,264354.60,3153.21,662174.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257381',4899500,'2845','429',381615.26,385241.69,3626.43,761550.30,0.00,0.00,0.00,0.00,0.00),('5','184','958','257381',4899501,'2846','429',352273.13,355850.70,3577.57,751289.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257381',4899502,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257381',4899503,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257381',4899504,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257381',4899505,'2850','429',300242.69,300242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257381',4899506,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257381',4899507,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257382',4899508,'2843','429',383196.99,383196.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257382',4899509,'2844','429',264354.60,266573.98,2219.38,466069.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257382',4899510,'2845','429',385241.69,387584.44,2342.75,491977.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257382',4899511,'2846','429',355850.70,358531.69,2680.99,563007.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257382',4899512,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257382',4899513,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257382',4899514,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257382',4899515,'2850','429',300242.69,300242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257382',4899516,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257382',4899517,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257385',4899518,'2843','429',383196.99,384411.67,1214.68,255082.80,0.00,0.00,0.00,0.00,0.00),('5','184','958','257385',4899519,'2844','429',266573.98,270163.29,3589.31,753755.10,0.00,0.00,0.00,0.00,0.00),('5','184','958','257385',4899520,'2845','429',387584.44,391146.58,3562.14,748049.40,0.00,0.00,0.00,0.00,0.00),('5','184','958','257385',4899521,'2846','429',358531.69,361724.02,3192.33,670389.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257385',4899522,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257385',4899523,'2848','429',238974.49,238974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257385',4899524,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257385',4899525,'2850','429',300242.69,300242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257385',4899526,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257385',4899527,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257386',4899528,'2843','429',384411.67,386036.72,1625.05,341260.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257386',4899529,'2844','429',270163.29,271685.74,1522.45,319714.50,0.00,0.00,0.00,0.00,0.00),('5','184','958','257386',4899530,'2845','429',391146.58,392678.75,1532.17,321755.70,0.00,0.00,0.00,0.00,0.00),('5','184','958','257386',4899531,'2846','429',361724.02,363395.37,1671.35,350983.50,0.00,0.00,0.00,0.00,0.00),('5','184','957','257386',4899532,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257386',4899533,'2848','429',238974.49,240053.05,1078.56,226497.60,0.00,0.00,0.00,0.00,0.00),('5','184','957','257386',4899534,'2849','429',345308.58,345308.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257386',4899535,'2850','429',300242.69,301049.34,806.65,169396.50,0.00,0.00,0.00,0.00,0.00),('5','184','959','257386',4899536,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257386',4899537,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257387',4899538,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257387',4899539,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257387',4899540,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257387',4899541,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257387',4899542,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257387',4899543,'2848','429',240053.05,242724.53,2671.48,561010.80,0.00,0.00,0.00,0.00,0.00),('5','184','957','257387',4899544,'2849','429',345308.58,347287.32,1978.74,415535.40,0.00,0.00,0.00,0.00,0.00),('5','184','957','257387',4899545,'2850','429',301049.34,303073.95,2024.61,425168.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','257387',4899546,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257387',4899547,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257388',4899548,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257388',4899549,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257388',4899550,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257388',4899551,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257388',4899552,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257388',4899553,'2848','429',242724.53,245482.90,2758.37,579257.70,0.00,0.00,0.00,0.00,0.00),('5','184','957','257388',4899554,'2849','429',347287.32,350179.83,2892.51,607427.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257388',4899555,'2850','429',303073.95,305248.17,2174.22,456586.20,0.00,0.00,0.00,0.00,0.00),('5','184','959','257388',4899556,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257388',4899557,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257389',4899558,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257389',4899559,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257389',4899560,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257389',4899561,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257389',4899562,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257389',4899563,'2848','429',245482.90,248269.10,2786.20,585102.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257389',4899564,'2849','429',350179.83,353082.54,2902.71,609569.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257389',4899565,'2850','429',305248.17,308162.88,2914.71,612089.10,0.00,0.00,0.00,0.00,0.00),('5','184','959','257389',4899566,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257389',4899567,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257390',4899568,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257390',4899569,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257390',4899570,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257390',4899571,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257390',4899572,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257390',4899573,'2848','429',248269.10,250607.13,2338.03,490986.30,0.00,0.00,0.00,0.00,0.00),('5','184','957','257390',4899574,'2849','429',353082.54,355638.84,2556.30,536823.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257390',4899575,'2850','429',308162.88,311074.62,2911.74,611465.40,0.00,0.00,0.00,0.00,0.00),('5','184','959','257390',4899576,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257390',4899577,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257391',4899578,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257391',4899579,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257391',4899580,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257391',4899581,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257391',4899582,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257391',4899583,'2848','429',250607.13,253034.32,2427.19,509709.90,0.00,0.00,0.00,0.00,0.00),('5','184','957','257391',4899584,'2849','429',355638.84,358158.15,2519.31,529055.10,0.00,0.00,0.00,0.00,0.00),('5','184','957','257391',4899585,'2850','429',311074.62,313638.65,2564.03,538446.30,0.00,0.00,0.00,0.00,0.00),('5','184','959','257391',4899586,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257391',4899587,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257392',4899588,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257392',4899589,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257392',4899590,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257392',4899591,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257392',4899592,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257392',4899593,'2848','429',253034.32,253034.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257392',4899594,'2849','429',358158.15,358158.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257392',4899595,'2850','429',313638.65,313638.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257392',4899596,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257392',4899597,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257393',4899598,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257393',4899599,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257393',4899600,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257393',4899601,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257393',4899602,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257393',4899603,'2848','429',253034.32,253034.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257393',4899604,'2849','429',358158.15,358158.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257393',4899605,'2850','429',313638.65,313638.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257393',4899606,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257393',4899607,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257394',4899608,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257394',4899609,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257394',4899610,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257394',4899611,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257394',4899612,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257394',4899613,'2848','429',253034.32,253034.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257394',4899614,'2849','429',358158.15,358158.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257394',4899615,'2850','429',313638.65,313638.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257394',4899616,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257394',4899617,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257395',4899618,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257395',4899619,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257395',4899620,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257395',4899621,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257395',4899622,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257395',4899623,'2848','429',253034.32,253034.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257395',4899624,'2849','429',358158.15,358158.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257395',4899625,'2850','429',313638.65,313638.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257395',4899626,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257395',4899627,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257396',4899628,'2843','429',386036.72,386036.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257396',4899629,'2844','429',271685.74,271685.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257396',4899630,'2845','429',392678.75,392678.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','958','257396',4899631,'2846','429',363395.37,363395.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257396',4899632,'2847','429',238506.59,238506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257396',4899633,'2848','429',253034.32,253034.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257396',4899634,'2849','429',358158.15,358158.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','957','257396',4899635,'2850','429',313638.65,313638.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','959','257396',4899636,'2851','430',329503.87,329503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','184','960','257396',4899637,'2852','431',66765.86,66765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=729486 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','184','212338','429',165.00,165.00,5571.35,0.00,0.00,0.00,0.00,612321),('5','184','212338','430',290.00,290.00,306.12,0.00,0.00,0.00,0.00,612322),('5','184','212338','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612323),('5','184','213030','429',165.00,165.00,7210.91,0.00,0.00,0.00,0.00,614145),('5','184','213030','430',290.00,290.00,474.81,0.00,0.00,0.00,0.00,614146),('5','184','213030','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614147),('5','184','213036','429',165.00,165.00,7436.31,0.00,0.00,0.00,0.00,614161),('5','184','213036','430',295.00,290.00,1011.05,0.00,0.00,0.00,0.00,614162),('5','184','213036','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614163),('5','184','213043','429',165.00,165.00,3794.87,0.00,0.00,0.00,0.00,614182),('5','184','213043','430',295.00,290.00,97.75,0.00,0.00,0.00,0.00,614183),('5','184','213043','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614184),('5','184','213057','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,614209),('5','184','213057','430',295.00,290.00,0.00,0.00,0.00,0.00,0.00,614210),('5','184','213057','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614211),('5','184','213061','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,614220),('5','184','213061','430',295.00,290.00,0.00,0.00,0.00,0.00,0.00,614221),('5','184','213061','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614222),('5','184','213062','429',165.00,165.00,2802.38,0.00,0.00,0.00,0.00,614223),('5','184','213062','430',295.00,295.00,39.10,0.00,0.00,0.00,0.00,614224),('5','184','213062','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614225),('5','184','213068','429',165.00,165.00,5371.68,0.00,0.00,0.00,0.00,614240),('5','184','213068','430',295.00,295.00,1201.71,0.00,0.00,0.00,0.00,614241),('5','184','213068','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614242),('5','184','213228','429',165.00,165.00,6889.08,0.00,0.00,0.00,0.00,614649),('5','184','213228','430',295.00,295.00,940.63,0.00,0.00,0.00,0.00,614650),('5','184','213228','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614651),('5','184','213237','429',165.00,165.00,7132.51,0.00,0.00,0.00,0.00,614672),('5','184','213237','430',295.00,295.00,185.86,0.00,0.00,0.00,0.00,614673),('5','184','213237','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614674),('5','184','213242','429',165.00,165.00,9246.67,0.00,0.00,0.00,0.00,614683),('5','184','213242','430',295.00,295.00,283.65,0.00,0.00,0.00,0.00,614684),('5','184','213242','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614685),('5','184','213260','429',165.00,165.00,7144.94,0.00,0.00,0.00,0.00,614730),('5','184','213260','430',295.00,295.00,267.66,0.00,0.00,0.00,0.00,614731),('5','184','213260','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614732),('5','184','213284','429',165.00,165.00,6975.06,0.00,0.00,0.00,0.00,614789),('5','184','213284','430',295.00,295.00,96.20,0.00,0.00,0.00,0.00,614790),('5','184','213284','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614791),('5','184','213305','429',165.00,165.00,5391.24,0.00,0.00,0.00,0.00,614846),('5','184','213305','430',295.00,295.00,108.91,0.00,0.00,0.00,0.00,614847),('5','184','213305','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614848),('5','184','213338','429',165.00,165.00,5991.94,0.00,0.00,0.00,0.00,614936),('5','184','213338','430',295.00,295.00,158.41,0.00,0.00,0.00,0.00,614937),('5','184','213338','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614938),('5','184','213346','429',165.00,165.00,7117.83,0.00,0.00,0.00,0.00,614959),('5','184','213346','430',295.00,295.00,1011.77,0.00,0.00,0.00,0.00,614960),('5','184','213346','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614961),('5','184','213481','429',165.00,165.00,7358.72,0.00,0.00,0.00,0.00,615303),('5','184','213481','430',295.00,295.00,111.00,0.00,0.00,0.00,0.00,615304),('5','184','213481','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615305),('5','184','213502','429',165.00,165.00,5267.12,0.00,0.00,0.00,0.00,615359),('5','184','213502','430',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615360),('5','184','213502','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615361),('5','184','213509','429',165.00,165.00,6130.98,0.00,0.00,0.00,0.00,615380),('5','184','213509','430',295.00,295.00,206.85,0.00,0.00,0.00,0.00,615381),('5','184','213509','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615382),('5','184','213562','429',165.00,165.00,6067.73,0.00,0.00,0.00,0.00,615529),('5','184','213562','430',295.00,295.00,1014.87,0.00,0.00,0.00,0.00,615530),('5','184','213562','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615531),('5','184','213688','429',165.00,165.00,6224.29,0.00,0.00,0.00,0.00,615854),('5','184','213688','430',295.00,295.00,177.35,0.00,0.00,0.00,0.00,615855),('5','184','213688','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615856),('5','184','213899','429',165.00,165.00,6020.34,0.00,0.00,0.00,0.00,616405),('5','184','213899','430',295.00,295.00,973.47,0.00,0.00,0.00,0.00,616406),('5','184','213899','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616407),('5','184','214142','429',165.00,165.00,5481.69,0.00,0.00,0.00,0.00,617034),('5','184','214142','430',295.00,295.00,392.77,0.00,0.00,0.00,0.00,617035),('5','184','214142','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617036),('5','184','214754','429',165.00,165.00,6073.02,0.00,0.00,0.00,0.00,618638),('5','184','214754','430',295.00,295.00,954.73,0.00,0.00,0.00,0.00,618639),('5','184','214754','431',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618640),('5','184','214933','429',165.00,165.00,6437.60,0.00,0.00,0.00,0.00,619100),('5','184','214933','430',295.00,295.00,914.39,0.00,0.00,0.00,0.00,619101),('5','184','214933','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,619102),('5','184','214938','429',165.00,165.00,5682.55,0.00,0.00,0.00,0.00,619115),('5','184','214938','430',295.00,295.00,97.62,0.00,0.00,0.00,0.00,619116),('5','184','214938','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,619117),('5','184','215044','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,619383),('5','184','215044','430',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619384),('5','184','215044','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,619385),('5','184','215288','429',165.00,165.00,6057.85,0.00,0.00,0.00,0.00,620010),('5','184','215288','430',295.00,295.00,978.41,0.00,0.00,0.00,0.00,620011),('5','184','215288','431',165.00,165.00,5.45,0.00,0.00,0.00,0.00,620012),('5','184','215400','429',165.00,165.00,5578.54,0.00,0.00,0.00,0.00,620305),('5','184','215400','430',295.00,295.00,1022.57,0.00,0.00,0.00,0.00,620306),('5','184','215400','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,620307),('5','184','215500','429',165.00,165.00,6233.27,0.00,0.00,0.00,0.00,620547),('5','184','215500','430',295.00,295.00,148.39,0.00,0.00,0.00,0.00,620548),('5','184','215500','431',165.00,165.00,458.70,0.00,0.00,0.00,0.00,620549),('5','184','216434','429',165.00,165.00,6096.78,0.00,0.00,0.00,0.00,622972),('5','184','216434','430',295.00,295.00,1042.63,0.00,0.00,0.00,0.00,622973),('5','184','216434','431',165.00,165.00,235.70,0.00,0.00,0.00,0.00,622974),('5','184','216887','429',165.00,165.00,6021.95,0.00,0.00,0.00,0.00,624167),('5','184','216887','430',295.00,295.00,594.10,0.00,0.00,0.00,0.00,624168),('5','184','216887','431',165.00,165.00,389.53,0.00,0.00,0.00,0.00,624169),('5','184','216984','429',165.00,165.00,5289.65,0.00,0.00,0.00,0.00,624432),('5','184','216984','430',295.00,295.00,0.00,0.00,0.00,0.00,0.00,624433),('5','184','216984','431',165.00,165.00,88.32,0.00,0.00,0.00,0.00,624434),('5','184','216992','429',165.00,165.00,5390.79,0.00,0.00,0.00,0.00,624454),('5','184','216992','430',295.00,295.00,179.52,0.00,0.00,0.00,0.00,624455),('5','184','216992','431',165.00,165.00,597.07,0.00,0.00,0.00,0.00,624456),('5','184','216994','429',165.00,165.00,5583.08,0.00,0.00,0.00,0.00,624460),('5','184','216994','430',295.00,295.00,93.54,0.00,0.00,0.00,0.00,624461),('5','184','216994','431',165.00,165.00,77.73,0.00,0.00,0.00,0.00,624462),('5','184','216998','429',165.00,165.00,4950.96,0.00,0.00,0.00,0.00,624467),('5','184','216998','430',295.00,295.00,388.23,0.00,0.00,0.00,0.00,624468),('5','184','216998','431',165.00,165.00,353.44,0.00,0.00,0.00,0.00,624469),('5','184','217055','429',165.00,165.00,4917.51,0.00,0.00,0.00,0.00,624599),('5','184','217055','430',295.00,295.00,174.21,0.00,0.00,0.00,0.00,624600),('5','184','217055','431',165.00,165.00,409.68,0.00,0.00,0.00,0.00,624601),('5','184','217481','429',165.00,165.00,5233.72,0.00,0.00,0.00,0.00,625737),('5','184','217481','430',295.00,295.00,732.63,0.00,0.00,0.00,0.00,625738),('5','184','217481','431',165.00,165.00,367.29,0.00,0.00,0.00,0.00,625739),('5','184','217647','429',165.00,165.00,4419.67,0.00,0.00,0.00,0.00,626163),('5','184','217647','430',295.00,295.00,160.36,0.00,0.00,0.00,0.00,626164),('5','184','217647','431',165.00,165.00,527.41,0.00,0.00,0.00,0.00,626165),('5','184','217856','429',165.00,165.00,1007.60,0.00,0.00,0.00,0.00,626709),('5','184','217856','430',295.00,295.00,162.33,0.00,0.00,0.00,0.00,626710),('5','184','217856','431',165.00,165.00,2878.13,0.00,0.00,0.00,0.00,626711),('5','184','218026','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,627144),('5','184','218026','430',295.00,295.00,927.18,0.00,0.00,0.00,0.00,627145),('5','184','218026','431',165.00,165.00,3553.05,0.00,0.00,0.00,0.00,627146),('5','184','218265','429',165.00,165.00,3416.58,0.00,0.00,0.00,0.00,627775),('5','184','218265','430',295.00,295.00,100.43,0.00,0.00,0.00,0.00,627776),('5','184','218265','431',165.00,165.00,949.78,0.00,0.00,0.00,0.00,627777),('5','184','218779','429',165.00,165.00,5388.84,0.00,0.00,0.00,0.00,629112),('5','184','218779','430',295.00,295.00,577.44,0.00,0.00,0.00,0.00,629113),('5','184','218779','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,629114),('5','184','218873','429',165.00,165.00,5067.83,0.00,0.00,0.00,0.00,629377),('5','184','218873','430',295.00,295.00,917.73,0.00,0.00,0.00,0.00,629378),('5','184','218873','431',165.00,165.00,308.51,0.00,0.00,0.00,0.00,629379),('5','184','219101','429',165.00,165.00,4682.77,0.00,0.00,0.00,0.00,629970),('5','184','219101','430',295.00,295.00,973.13,0.00,0.00,0.00,0.00,629971),('5','184','219101','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,629972),('5','184','219314','429',165.00,165.00,5110.05,0.00,0.00,0.00,0.00,630530),('5','184','219314','430',295.00,295.00,890.74,0.00,0.00,0.00,0.00,630531),('5','184','219314','431',165.00,165.00,43.55,0.00,0.00,0.00,0.00,630532),('5','184','219444','429',165.00,165.00,5057.14,0.00,0.00,0.00,0.00,630858),('5','184','219444','430',295.00,295.00,938.85,0.00,0.00,0.00,0.00,630859),('5','184','219444','431',165.00,165.00,405.02,0.00,0.00,0.00,0.00,630860),('5','184','219679','429',165.00,165.00,4718.22,0.00,0.00,0.00,0.00,631475),('5','184','219679','430',295.00,295.00,187.33,0.00,0.00,0.00,0.00,631476),('5','184','219679','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,631477),('5','184','219880','429',165.00,165.00,5654.25,0.00,0.00,0.00,0.00,632007),('5','184','219880','430',295.00,295.00,260.99,0.00,0.00,0.00,0.00,632008),('5','184','219880','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,632009),('5','184','220128','429',165.00,165.00,4318.72,0.00,0.00,0.00,0.00,632671),('5','184','220128','430',295.00,295.00,908.41,0.00,0.00,0.00,0.00,632672),('5','184','220128','431',165.00,165.00,486.05,0.00,0.00,0.00,0.00,632673),('5','184','220440','429',165.00,165.00,4766.55,0.00,0.00,0.00,0.00,633499),('5','184','220440','430',295.00,295.00,177.70,0.00,0.00,0.00,0.00,633500),('5','184','220440','431',165.00,165.00,667.39,0.00,0.00,0.00,0.00,633501),('5','184','220551','429',165.00,165.00,4198.17,0.00,0.00,0.00,0.00,633782),('5','184','220551','430',295.00,295.00,64.85,0.00,0.00,0.00,0.00,633783),('5','184','220551','431',165.00,165.00,154.11,0.00,0.00,0.00,0.00,633784),('5','184','220889','429',165.00,165.00,4609.22,0.00,0.00,0.00,0.00,634668),('5','184','220889','430',295.00,295.00,862.80,0.00,0.00,0.00,0.00,634669),('5','184','220889','431',165.00,165.00,266.47,0.00,0.00,0.00,0.00,634670),('5','184','220985','429',165.00,165.00,4110.41,0.00,0.00,0.00,0.00,634908),('5','184','220985','430',295.00,295.00,51.82,0.00,0.00,0.00,0.00,634909),('5','184','220985','431',165.00,165.00,641.92,0.00,0.00,0.00,0.00,634910),('5','184','221192','429',165.00,165.00,4067.77,0.00,0.00,0.00,0.00,635430),('5','184','221192','430',295.00,295.00,1000.43,0.00,0.00,0.00,0.00,635431),('5','184','221192','431',165.00,165.00,919.01,0.00,0.00,0.00,0.00,635432),('5','184','221511','429',165.00,165.00,3759.67,0.00,0.00,0.00,0.00,636278),('5','184','221511','430',295.00,295.00,916.74,0.00,0.00,0.00,0.00,636279),('5','184','221511','431',165.00,165.00,1039.02,0.00,0.00,0.00,0.00,636280),('5','184','221757','429',165.00,165.00,4125.48,0.00,0.00,0.00,0.00,636926),('5','184','221757','430',295.00,295.00,85.53,0.00,0.00,0.00,0.00,636927),('5','184','221757','431',165.00,165.00,647.12,0.00,0.00,0.00,0.00,636928),('5','184','222242','429',165.00,165.00,4232.53,0.00,0.00,0.00,0.00,638177),('5','184','222242','430',295.00,295.00,834.04,0.00,0.00,0.00,0.00,638178),('5','184','222242','431',165.00,165.00,603.32,0.00,0.00,0.00,0.00,638179),('5','184','222253','429',165.00,165.00,4159.54,0.00,0.00,0.00,0.00,638206),('5','184','222253','430',295.00,295.00,114.67,0.00,0.00,0.00,0.00,638207),('5','184','222253','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,638208),('5','184','222468','429',165.00,165.00,3556.37,0.00,0.00,0.00,0.00,638763),('5','184','222468','430',295.00,295.00,1018.35,0.00,0.00,0.00,0.00,638764),('5','184','222468','431',165.00,165.00,171.83,0.00,0.00,0.00,0.00,638765),('5','184','222617','429',165.00,165.00,3668.47,0.00,0.00,0.00,0.00,639145),('5','184','222617','430',295.00,295.00,177.44,0.00,0.00,0.00,0.00,639146),('5','184','222617','431',165.00,165.00,70.82,0.00,0.00,0.00,0.00,639147),('5','184','222786','429',165.00,165.00,3177.36,0.00,0.00,0.00,0.00,639580),('5','184','222786','430',295.00,295.00,36.66,0.00,0.00,0.00,0.00,639581),('5','184','222786','431',165.00,165.00,142.37,0.00,0.00,0.00,0.00,639582),('5','184','223003','429',165.00,165.00,3878.19,0.00,0.00,0.00,0.00,640180),('5','184','223003','430',295.00,295.00,131.74,0.00,0.00,0.00,0.00,640181),('5','184','223003','431',165.00,165.00,46.05,0.00,0.00,0.00,0.00,640182),('5','184','223264','429',165.00,165.00,4021.66,0.00,0.00,0.00,0.00,640816),('5','184','223264','430',295.00,295.00,125.79,0.00,0.00,0.00,0.00,640817),('5','184','223264','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,640818),('5','184','223528','429',165.00,165.00,4185.35,0.00,0.00,0.00,0.00,641482),('5','184','223528','430',295.00,295.00,165.80,0.00,0.00,0.00,0.00,641483),('5','184','223528','431',165.00,165.00,188.57,0.00,0.00,0.00,0.00,641484),('5','184','223708','429',163.00,163.00,4407.37,0.00,0.00,0.00,0.00,641947),('5','184','223708','430',295.00,295.00,190.09,0.00,0.00,0.00,0.00,641948),('5','184','223708','431',163.00,163.00,855.74,0.00,0.00,0.00,0.00,641949),('5','184','223941','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,642547),('5','184','223941','430',295.00,295.00,105.15,0.00,0.00,0.00,0.00,642548),('5','184','223941','431',163.00,163.00,3630.17,0.00,0.00,0.00,0.00,642549),('5','184','224163','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,643122),('5','184','224163','430',295.00,295.00,82.65,0.00,0.00,0.00,0.00,643123),('5','184','224163','431',163.00,163.00,3319.03,0.00,0.00,0.00,0.00,643124),('5','184','224424','429',165.00,163.00,173.28,0.00,0.00,0.00,0.00,643806),('5','184','224424','430',295.00,295.00,78.52,0.00,0.00,0.00,0.00,643807),('5','184','224424','431',163.00,163.00,3062.93,0.00,0.00,0.00,0.00,643808),('5','184','224619','429',163.00,163.00,4799.46,0.00,0.00,0.00,0.00,644321),('5','184','224619','430',295.00,295.00,279.31,0.00,0.00,0.00,0.00,644322),('5','184','224619','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644323),('5','184','224822','429',163.00,163.00,5261.89,0.00,0.00,0.00,0.00,644826),('5','184','224822','430',295.00,295.00,136.71,0.00,0.00,0.00,0.00,644827),('5','184','224822','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644828),('5','184','225333','429',163.00,163.00,5389.96,0.00,0.00,0.00,0.00,646144),('5','184','225333','430',295.00,295.00,225.62,0.00,0.00,0.00,0.00,646145),('5','184','225333','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,646146),('5','184','225411','429',163.00,163.00,5855.79,0.00,0.00,0.00,0.00,646359),('5','184','225411','430',295.00,295.00,94.06,0.00,0.00,0.00,0.00,646360),('5','184','225411','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,646361),('5','184','225553','429',163.00,163.00,5633.09,0.00,0.00,0.00,0.00,646724),('5','184','225553','430',295.00,295.00,111.44,0.00,0.00,0.00,0.00,646725),('5','184','225553','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,646726),('5','184','225839','429',163.00,163.00,6171.25,0.00,0.00,0.00,0.00,647473),('5','184','225839','430',295.00,295.00,192.16,0.00,0.00,0.00,0.00,647474),('5','184','225839','431',163.00,163.00,130.61,0.00,0.00,0.00,0.00,647475),('5','184','226066','429',163.00,163.00,5439.30,0.00,0.00,0.00,0.00,648060),('5','184','226066','430',295.00,295.00,137.15,0.00,0.00,0.00,0.00,648061),('5','184','226066','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,648062),('5','184','226329','429',163.00,163.00,5652.96,0.00,0.00,0.00,0.00,648744),('5','184','226329','430',295.00,295.00,145.27,0.00,0.00,0.00,0.00,648745),('5','184','226329','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,648746),('5','184','226585','429',163.00,163.00,5014.06,0.00,0.00,0.00,0.00,649395),('5','184','226585','430',295.00,295.00,187.13,0.00,0.00,0.00,0.00,649396),('5','184','226585','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,649397),('5','184','227007','429',163.00,163.00,5229.90,0.00,0.00,0.00,0.00,650491),('5','184','227007','430',295.00,295.00,189.19,0.00,0.00,0.00,0.00,650492),('5','184','227007','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,650493),('5','184','227121','429',163.00,163.00,4825.48,0.00,0.00,0.00,0.00,650798),('5','184','227121','430',295.00,295.00,127.53,0.00,0.00,0.00,0.00,650799),('5','184','227121','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,650800),('5','184','227242','429',163.00,163.00,5740.95,0.00,0.00,0.00,0.00,651098),('5','184','227242','430',295.00,295.00,38.47,0.00,0.00,0.00,0.00,651099),('5','184','227242','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,651100),('5','184','227436','429',163.00,163.00,5500.53,0.00,0.00,0.00,0.00,651596),('5','184','227436','430',295.00,295.00,156.30,0.00,0.00,0.00,0.00,651597),('5','184','227436','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,651598),('5','184','227794','429',163.00,163.00,5789.55,0.00,0.00,0.00,0.00,652533),('5','184','227794','430',300.00,300.00,132.41,0.00,0.00,0.00,0.00,652534),('5','184','227794','431',163.00,163.00,524.40,0.00,0.00,0.00,0.00,652535),('5','184','227921','429',163.00,163.00,5578.56,0.00,0.00,0.00,0.00,652850),('5','184','227921','430',300.00,300.00,157.65,0.00,0.00,0.00,0.00,652851),('5','184','227921','431',163.00,163.00,634.11,0.00,0.00,0.00,0.00,652852),('5','184','229313','429',163.00,163.00,1880.74,0.00,0.00,0.00,0.00,656461),('5','184','229313','430',300.00,300.00,196.43,0.00,0.00,0.00,0.00,656462),('5','184','229313','431',163.00,163.00,2856.91,0.00,0.00,0.00,0.00,656463),('5','184','230633','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,659864),('5','184','230633','430',300.00,300.00,222.54,0.00,0.00,0.00,0.00,659865),('5','184','230633','431',163.00,163.00,4270.18,0.00,0.00,0.00,0.00,659866),('5','184','230676','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,659981),('5','184','230676','430',300.00,300.00,47.70,0.00,0.00,0.00,0.00,659982),('5','184','230676','431',163.00,163.00,3754.77,0.00,0.00,0.00,0.00,659983),('5','184','230964','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660730),('5','184','230964','430',300.00,300.00,50.72,0.00,0.00,0.00,0.00,660731),('5','184','230964','431',163.00,163.00,1766.25,0.00,0.00,0.00,0.00,660732),('5','184','230970','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660749),('5','184','230970','430',300.00,300.00,99.98,0.00,0.00,0.00,0.00,660750),('5','184','230970','431',163.00,163.00,973.74,0.00,0.00,0.00,0.00,660751),('5','184','230977','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660768),('5','184','230977','430',310.00,310.00,144.68,0.00,0.00,0.00,0.00,660769),('5','184','230977','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660770),('5','184','230986','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660793),('5','184','230986','430',310.00,310.00,142.90,0.00,0.00,0.00,0.00,660794),('5','184','230986','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660795),('5','184','231183','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661303),('5','184','231183','430',310.00,310.00,102.52,0.00,0.00,0.00,0.00,661304),('5','184','231183','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661305),('5','184','231190','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661323),('5','184','231190','430',310.00,310.00,98.94,0.00,0.00,0.00,0.00,661324),('5','184','231190','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661325),('5','184','231226','429',163.00,163.00,957.64,0.00,0.00,0.00,0.00,661427),('5','184','231226','430',310.00,310.00,96.46,0.00,0.00,0.00,0.00,661428),('5','184','231226','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661429),('5','184','231236','429',163.00,163.00,5568.54,0.00,0.00,0.00,0.00,661457),('5','184','231236','430',310.00,310.00,59.07,0.00,0.00,0.00,0.00,661458),('5','184','231236','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661459),('5','184','231247','429',163.00,163.00,4630.72,0.00,0.00,0.00,0.00,661490),('5','184','231247','430',320.00,320.00,1677.06,0.00,0.00,0.00,0.00,661491),('5','184','231247','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661492),('5','184','231270','429',163.00,163.00,3256.67,0.00,0.00,0.00,0.00,661555),('5','184','231270','430',320.00,320.00,302.50,0.00,0.00,0.00,0.00,661556),('5','184','231270','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661557),('5','184','231280','429',163.00,163.00,5751.04,0.00,0.00,0.00,0.00,661581),('5','184','231280','430',320.00,320.00,150.56,0.00,0.00,0.00,0.00,661582),('5','184','231280','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661583),('5','184','231462','429',163.00,163.00,5573.39,0.00,0.00,0.00,0.00,662052),('5','184','231462','430',320.00,320.00,389.85,0.00,0.00,0.00,0.00,662053),('5','184','231462','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662054),('5','184','231794','429',163.00,163.00,5715.50,0.00,0.00,0.00,0.00,662945),('5','184','231794','430',320.00,320.00,131.24,0.00,0.00,0.00,0.00,662946),('5','184','231794','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662947),('5','184','232096','429',163.00,163.00,6150.21,0.00,0.00,0.00,0.00,663753),('5','184','232096','430',327.00,327.00,160.64,0.00,0.00,0.00,0.00,663754),('5','184','232096','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663755),('5','184','232280','429',163.00,163.00,6128.32,0.00,0.00,0.00,0.00,664226),('5','184','232280','430',327.00,327.00,300.42,0.00,0.00,0.00,0.00,664227),('5','184','232280','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664228),('5','184','232396','429',163.00,163.00,6138.58,0.00,0.00,0.00,0.00,664514),('5','184','232396','430',327.00,327.00,183.20,0.00,0.00,0.00,0.00,664515),('5','184','232396','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664516),('5','184','232848','429',163.00,163.00,2310.40,0.00,0.00,0.00,0.00,665724),('5','184','232848','430',327.00,327.00,130.44,0.00,0.00,0.00,0.00,665725),('5','184','232848','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665726),('5','184','232975','429',163.00,163.00,1051.41,0.00,0.00,0.00,0.00,666065),('5','184','232975','430',330.00,330.00,126.01,0.00,0.00,0.00,0.00,666066),('5','184','232975','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666067),('5','184','233064','429',163.00,163.00,94.06,0.00,0.00,0.00,0.00,666297),('5','184','233064','430',345.00,345.00,114.40,0.00,0.00,0.00,0.00,666298),('5','184','233064','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666299),('5','184','233318','429',163.00,163.00,184.77,0.00,0.00,0.00,0.00,666960),('5','184','233318','430',345.00,345.00,74.14,0.00,0.00,0.00,0.00,666961),('5','184','233318','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666962),('5','184','233596','429',163.00,163.00,172.98,0.00,0.00,0.00,0.00,667683),('5','184','233596','430',345.00,345.00,75.57,0.00,0.00,0.00,0.00,667684),('5','184','233596','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,667685),('5','184','233801','429',163.00,163.00,102.55,0.00,0.00,0.00,0.00,668225),('5','184','233801','430',345.00,345.00,53.97,0.00,0.00,0.00,0.00,668226),('5','184','233801','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668227),('5','184','234006','429',163.00,163.00,90.97,0.00,0.00,0.00,0.00,668771),('5','184','234006','430',345.00,345.00,171.36,0.00,0.00,0.00,0.00,668772),('5','184','234006','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668773),('5','184','234342','429',163.00,163.00,99.58,0.00,0.00,0.00,0.00,669636),('5','184','234342','430',345.00,345.00,53.64,0.00,0.00,0.00,0.00,669637),('5','184','234342','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669638),('5','184','234503','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670087),('5','184','234503','430',345.00,345.00,183.25,0.00,0.00,0.00,0.00,670088),('5','184','234503','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670089),('5','184','234919','429',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671178),('5','184','234919','430',345.00,345.00,102.00,0.00,0.00,0.00,0.00,671179),('5','184','234919','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671180),('5','184','235030','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671499),('5','184','235030','430',345.00,345.00,104.48,0.00,0.00,0.00,0.00,671500),('5','184','235030','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671501),('5','184','236116','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,674309),('5','184','236116','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674310),('5','184','236116','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,674311),('5','184','236120','429',165.00,165.00,7292.43,0.00,0.00,0.00,0.00,674321),('5','184','236120','430',345.00,345.00,223.44,0.00,0.00,0.00,0.00,674322),('5','184','236120','431',163.00,163.00,0.00,0.00,0.00,0.00,0.00,674323),('5','184','236331','429',165.00,165.00,4248.19,0.00,0.00,0.00,0.00,674878),('5','184','236331','430',345.00,345.00,175.66,0.00,0.00,0.00,0.00,674879),('5','184','236331','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,674880),('5','184','236622','429',165.00,165.00,3230.69,0.00,0.00,0.00,0.00,675639),('5','184','236622','430',345.00,345.00,335.75,0.00,0.00,0.00,0.00,675640),('5','184','236622','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675641),('5','184','236674','429',165.00,165.00,7185.85,0.00,0.00,0.00,0.00,675783),('5','184','236674','430',345.00,345.00,639.68,0.00,0.00,0.00,0.00,675784),('5','184','236674','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675785),('5','184','236675','429',165.00,165.00,6275.97,0.00,0.00,0.00,0.00,675786),('5','184','236675','430',345.00,345.00,857.72,0.00,0.00,0.00,0.00,675787),('5','184','236675','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675788),('5','184','236867','429',165.00,165.00,13457.20,0.00,0.00,0.00,0.00,676279),('5','184','236867','430',345.00,345.00,445.70,0.00,0.00,0.00,0.00,676280),('5','184','236867','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676281),('5','184','237032','429',165.00,165.00,16734.13,0.00,0.00,0.00,0.00,676696),('5','184','237032','430',345.00,345.00,435.52,0.00,0.00,0.00,0.00,676697),('5','184','237032','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676698),('5','184','237036','429',165.00,165.00,4565.98,0.00,0.00,0.00,0.00,676709),('5','184','237036','430',345.00,345.00,277.37,0.00,0.00,0.00,0.00,676710),('5','184','237036','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676711),('5','184','237345','429',165.00,165.00,566.21,0.00,0.00,0.00,0.00,677516),('5','184','237345','430',345.00,345.00,314.51,0.00,0.00,0.00,0.00,677517),('5','184','237345','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677518),('5','184','237634','429',165.00,165.00,604.51,0.00,0.00,0.00,0.00,678251),('5','184','237634','430',345.00,345.00,113.77,0.00,0.00,0.00,0.00,678252),('5','184','237634','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678253),('5','184','237729','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678501),('5','184','237729','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678502),('5','184','237729','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678503),('5','184','237982','429',165.00,165.00,13774.44,0.00,0.00,0.00,0.00,679154),('5','184','237982','430',345.00,345.00,677.18,0.00,0.00,0.00,0.00,679155),('5','184','237982','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679156),('5','184','238433','429',165.00,165.00,11419.51,0.00,0.00,0.00,0.00,680318),('5','184','238433','430',345.00,345.00,624.85,0.00,0.00,0.00,0.00,680319),('5','184','238433','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680320),('5','184','238437','429',165.00,165.00,10673.04,0.00,0.00,0.00,0.00,680330),('5','184','238437','430',345.00,345.00,506.65,0.00,0.00,0.00,0.00,680331),('5','184','238437','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680332),('5','184','238695','429',165.00,165.00,13103.80,0.00,0.00,0.00,0.00,681006),('5','184','238695','430',345.00,345.00,386.58,0.00,0.00,0.00,0.00,681007),('5','184','238695','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681008),('5','184','239036','429',165.00,165.00,15596.75,0.00,0.00,0.00,0.00,681903),('5','184','239036','430',345.00,345.00,353.41,0.00,0.00,0.00,0.00,681904),('5','184','239036','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681905),('5','184','239137','429',165.00,165.00,3488.09,0.00,0.00,0.00,0.00,682147),('5','184','239137','430',345.00,345.00,393.48,0.00,0.00,0.00,0.00,682148),('5','184','239137','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682149),('5','184','239370','429',165.00,165.00,722.79,0.00,0.00,0.00,0.00,682756),('5','184','239370','430',345.00,345.00,946.42,0.00,0.00,0.00,0.00,682757),('5','184','239370','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682758),('5','184','239604','429',165.00,165.00,1970.12,0.00,0.00,0.00,0.00,683366),('5','184','239604','430',345.00,345.00,984.70,0.00,0.00,0.00,0.00,683367),('5','184','239604','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683368),('5','184','239881','429',165.00,165.00,10080.47,0.00,0.00,0.00,0.00,684091),('5','184','239881','430',345.00,345.00,532.65,0.00,0.00,0.00,0.00,684092),('5','184','239881','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684093),('5','184','240084','429',165.00,165.00,8223.67,0.00,0.00,0.00,0.00,684615),('5','184','240084','430',345.00,345.00,501.86,0.00,0.00,0.00,0.00,684616),('5','184','240084','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684617),('5','184','240283','429',165.00,165.00,8548.99,0.00,0.00,0.00,0.00,685125),('5','184','240283','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685126),('5','184','240283','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,685127),('5','184','240681','429',165.00,165.00,9280.54,0.00,0.00,0.00,0.00,686133),('5','184','240681','430',345.00,345.00,1223.23,0.00,0.00,0.00,0.00,686134),('5','184','240681','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686135),('5','184','240771','429',165.00,165.00,10364.96,0.00,0.00,0.00,0.00,686353),('5','184','240771','430',345.00,345.00,603.57,0.00,0.00,0.00,0.00,686354),('5','184','240771','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686355),('5','184','241086','429',165.00,165.00,10490.00,0.00,0.00,0.00,0.00,687204),('5','184','241086','430',345.00,345.00,857.61,0.00,0.00,0.00,0.00,687205),('5','184','241086','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,687206),('5','184','241345','429',165.00,165.00,10998.04,0.00,0.00,0.00,0.00,687881),('5','184','241345','430',345.00,345.00,1647.21,0.00,0.00,0.00,0.00,687882),('5','184','241345','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,687883),('5','184','241588','429',165.00,165.00,14522.24,0.00,0.00,0.00,0.00,688525),('5','184','241588','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688526),('5','184','241588','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688527),('5','184','241845','429',165.00,165.00,2747.99,0.00,0.00,0.00,0.00,689203),('5','184','241845','430',345.00,345.00,85.10,0.00,0.00,0.00,0.00,689204),('5','184','241845','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689205),('5','184','242133','429',165.00,165.00,10449.99,0.00,0.00,0.00,0.00,689956),('5','184','242133','430',345.00,345.00,286.33,0.00,0.00,0.00,0.00,689957),('5','184','242133','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689958),('5','184','242396','429',165.00,165.00,12092.49,0.00,0.00,0.00,0.00,690646),('5','184','242396','430',345.00,345.00,537.16,0.00,0.00,0.00,0.00,690647),('5','184','242396','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690648),('5','184','242615','429',165.00,165.00,14485.02,0.00,0.00,0.00,0.00,691214),('5','184','242615','430',345.00,345.00,668.14,0.00,0.00,0.00,0.00,691215),('5','184','242615','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691216),('5','184','243003','429',165.00,165.00,3406.40,0.00,0.00,0.00,0.00,692210),('5','184','243003','430',345.00,345.00,543.31,0.00,0.00,0.00,0.00,692211),('5','184','243003','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692212),('5','184','243094','429',165.00,165.00,7566.11,0.00,0.00,0.00,0.00,692466),('5','184','243094','430',345.00,345.00,750.14,0.00,0.00,0.00,0.00,692467),('5','184','243094','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692468),('5','184','243473','429',165.00,165.00,13875.76,0.00,0.00,0.00,0.00,693439),('5','184','243473','430',345.00,345.00,673.08,0.00,0.00,0.00,0.00,693440),('5','184','243473','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693441),('5','184','243806','429',165.00,165.00,13597.66,0.00,0.00,0.00,0.00,694322),('5','184','243806','430',345.00,345.00,440.52,0.00,0.00,0.00,0.00,694323),('5','184','243806','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694324),('5','184','243963','429',165.00,165.00,12773.87,0.00,0.00,0.00,0.00,694710),('5','184','243963','430',345.00,345.00,392.46,0.00,0.00,0.00,0.00,694711),('5','184','243963','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694712),('5','184','244156','429',165.00,165.00,13617.98,0.00,0.00,0.00,0.00,695194),('5','184','244156','430',345.00,345.00,462.47,0.00,0.00,0.00,0.00,695195),('5','184','244156','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695196),('5','184','244287','429',165.00,165.00,18804.08,0.00,0.00,0.00,0.00,695559),('5','184','244287','430',345.00,345.00,421.82,0.00,0.00,0.00,0.00,695560),('5','184','244287','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695561),('5','184','244575','429',165.00,165.00,5210.12,0.00,0.00,0.00,0.00,696283),('5','184','244575','430',345.00,345.00,682.85,0.00,0.00,0.00,0.00,696284),('5','184','244575','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696285),('5','184','244823','429',165.00,165.00,1087.74,0.00,0.00,0.00,0.00,696942),('5','184','244823','430',345.00,345.00,2524.50,0.00,0.00,0.00,0.00,696943),('5','184','244823','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696944),('5','184','245513','429',165.00,165.00,311.59,0.00,0.00,0.00,0.00,698716),('5','184','245513','430',345.00,345.00,483.94,0.00,0.00,0.00,0.00,698717),('5','184','245513','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698718),('5','184','245783','429',165.00,165.00,54.38,0.00,0.00,0.00,0.00,699410),('5','184','245783','430',345.00,345.00,643.21,0.00,0.00,0.00,0.00,699411),('5','184','245783','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699412),('5','184','246114','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700290),('5','184','246114','430',345.00,345.00,506.29,0.00,0.00,0.00,0.00,700291),('5','184','246114','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700292),('5','184','246351','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700918),('5','184','246351','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700919),('5','184','246351','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700920),('5','184','246451','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701173),('5','184','246451','430',345.00,345.00,853.66,0.00,0.00,0.00,0.00,701174),('5','184','246451','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701175),('5','184','246544','429',165.00,165.00,15736.67,0.00,0.00,0.00,0.00,701409),('5','184','246544','430',345.00,345.00,1087.35,0.00,0.00,0.00,0.00,701410),('5','184','246544','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701411),('5','184','246598','429',165.00,165.00,11491.89,0.00,0.00,0.00,0.00,701565),('5','184','246598','430',345.00,345.00,487.70,0.00,0.00,0.00,0.00,701566),('5','184','246598','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701567),('5','184','246622','429',165.00,165.00,1528.75,0.00,0.00,0.00,0.00,701634),('5','184','246622','430',345.00,345.00,847.87,0.00,0.00,0.00,0.00,701635),('5','184','246622','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701636),('5','184','246798','429',165.00,165.00,1067.48,0.00,0.00,0.00,0.00,702066),('5','184','246798','430',345.00,345.00,860.04,0.00,0.00,0.00,0.00,702067),('5','184','246798','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702068),('5','184','247105','429',165.00,165.00,10664.21,0.00,0.00,0.00,0.00,702873),('5','184','247105','430',345.00,345.00,764.93,0.00,0.00,0.00,0.00,702874),('5','184','247105','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702875),('5','184','247578','429',165.00,165.00,2027.91,0.00,0.00,0.00,0.00,704092),('5','184','247578','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704093),('5','184','247578','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704094),('5','184','247728','429',165.00,165.00,1134.18,0.00,0.00,0.00,0.00,704471),('5','184','247728','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704472),('5','184','247728','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704473),('5','184','248001','429',165.00,165.00,12317.13,0.00,0.00,0.00,0.00,705166),('5','184','248001','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705167),('5','184','248001','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705168),('5','184','248443','429',165.00,165.00,1644.19,0.00,0.00,0.00,0.00,706310),('5','184','248443','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706311),('5','184','248443','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706312),('5','184','248519','429',165.00,165.00,1097.42,0.00,0.00,0.00,0.00,706508),('5','184','248519','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706509),('5','184','248519','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706510),('5','184','248740','429',165.00,165.00,7273.91,0.00,0.00,0.00,0.00,707074),('5','184','248740','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707075),('5','184','248740','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707076),('5','184','249201','429',165.00,165.00,6257.60,0.00,0.00,0.00,0.00,708257),('5','184','249201','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708258),('5','184','249201','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708259),('5','184','249434','429',165.00,165.00,6412.52,0.00,0.00,0.00,0.00,708850),('5','184','249434','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708851),('5','184','249434','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708852),('5','184','249661','429',165.00,165.00,4549.01,0.00,0.00,0.00,0.00,709432),('5','184','249661','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709433),('5','184','249661','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709434),('5','184','249702','429',165.00,165.00,3263.16,0.00,0.00,0.00,0.00,709545),('5','184','249702','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709546),('5','184','249702','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709547),('5','184','249716','429',165.00,165.00,2087.34,0.00,0.00,0.00,0.00,709587),('5','184','249716','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709588),('5','184','249716','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709589),('5','184','250184','429',165.00,165.00,578.51,0.00,0.00,0.00,0.00,710774),('5','184','250184','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710775),('5','184','250184','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710776),('5','184','250440','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711415),('5','184','250440','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711416),('5','184','250440','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711417),('5','184','250493','429',165.00,165.00,8877.55,0.00,0.00,0.00,0.00,711568),('5','184','250493','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711569),('5','184','250493','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711570),('5','184','250713','429',165.00,165.00,9434.44,0.00,0.00,0.00,0.00,712142),('5','184','250713','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712143),('5','184','250713','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712144),('5','184','251130','429',165.00,165.00,10617.29,0.00,0.00,0.00,0.00,713203),('5','184','251130','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713204),('5','184','251130','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713205),('5','184','251375','429',165.00,165.00,15705.03,0.00,0.00,0.00,0.00,713848),('5','184','251375','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713849),('5','184','251375','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713850),('5','184','251635','429',165.00,165.00,16322.93,0.00,0.00,0.00,0.00,714528),('5','184','251635','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714529),('5','184','251635','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,714530),('5','184','251857','429',165.00,165.00,10628.94,0.00,0.00,0.00,0.00,715109),('5','184','251857','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715110),('5','184','251857','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715111),('5','184','252091','429',165.00,165.00,4202.97,0.00,0.00,0.00,0.00,715716),('5','184','252091','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715717),('5','184','252091','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715718),('5','184','252374','429',165.00,165.00,2017.73,0.00,0.00,0.00,0.00,716472),('5','184','252374','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716473),('5','184','252374','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716474),('5','184','252602','429',165.00,165.00,1269.04,0.00,0.00,0.00,0.00,717055),('5','184','252602','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717056),('5','184','252602','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717057),('5','184','252821','429',165.00,165.00,3372.66,0.00,0.00,0.00,0.00,717612),('5','184','252821','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717613),('5','184','252821','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717614),('5','184','253047','429',165.00,165.00,11097.19,0.00,0.00,0.00,0.00,718192),('5','184','253047','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718193),('5','184','253047','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718194),('5','184','253184','429',165.00,165.00,11053.67,0.00,0.00,0.00,0.00,718589),('5','184','253184','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718590),('5','184','253184','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718591),('5','184','253380','429',165.00,165.00,7464.97,0.00,0.00,0.00,0.00,719082),('5','184','253380','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719083),('5','184','253380','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719084),('5','184','254104','429',165.00,165.00,4670.46,0.00,0.00,0.00,0.00,720964),('5','184','254104','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720965),('5','184','254104','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720966),('5','184','254120','429',165.00,165.00,2386.12,0.00,0.00,0.00,0.00,721009),('5','184','254120','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721010),('5','184','254120','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721011),('5','184','254129','429',165.00,165.00,7511.80,0.00,0.00,0.00,0.00,721035),('5','184','254129','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721036),('5','184','254129','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721037),('5','184','254399','429',165.00,165.00,4968.14,0.00,0.00,0.00,0.00,721734),('5','184','254399','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721735),('5','184','254399','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721736),('5','184','254698','429',165.00,165.00,3140.42,0.00,0.00,0.00,0.00,722485),('5','184','254698','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722486),('5','184','254698','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722487),('5','184','254808','429',165.00,165.00,1078.77,0.00,0.00,0.00,0.00,722751),('5','184','254808','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722752),('5','184','254808','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722753),('5','184','255283','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723971),('5','184','255283','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723972),('5','184','255283','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723973),('5','184','255568','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724653),('5','184','255568','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724654),('5','184','255568','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724655),('5','184','255807','429',165.00,165.00,1723.07,0.00,0.00,0.00,0.00,725268),('5','184','255807','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725269),('5','184','255807','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725270),('5','184','255938','429',165.00,165.00,10764.56,0.00,0.00,0.00,0.00,725624),('5','184','255938','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725625),('5','184','255938','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725626),('5','184','256270','429',165.00,165.00,11269.56,0.00,0.00,0.00,0.00,726414),('5','184','256270','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726415),('5','184','256270','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726416),('5','184','256665','429',165.00,165.00,7675.43,0.00,0.00,0.00,0.00,727471),('5','184','256665','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727472),('5','184','256665','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727473),('5','184','256898','429',165.00,165.00,7592.88,0.00,0.00,0.00,0.00,728081),('5','184','256898','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728082),('5','184','256898','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728083),('5','184','257101','429',165.00,165.00,4827.42,0.00,0.00,0.00,0.00,728600),('5','184','257101','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728601),('5','184','257101','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728602),('5','184','257102','429',165.00,165.00,2007.35,0.00,0.00,0.00,0.00,728603),('5','184','257102','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728604),('5','184','257102','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728605),('5','184','257103','429',165.00,165.00,1582.50,0.00,0.00,0.00,0.00,728606),('5','184','257103','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728607),('5','184','257103','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728608),('5','184','257104','429',165.00,165.00,8969.01,0.00,0.00,0.00,0.00,728609),('5','184','257104','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728610),('5','184','257104','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728611),('5','184','257105','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728612),('5','184','257105','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728613),('5','184','257105','429',165.00,165.00,10542.57,0.00,0.00,0.00,0.00,728614),('5','184','257106','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728615),('5','184','257106','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728616),('5','184','257106','429',165.00,165.00,10087.72,0.00,0.00,0.00,0.00,728617),('5','184','257107','429',165.00,165.00,5284.93,0.00,0.00,0.00,0.00,728618),('5','184','257107','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728619),('5','184','257107','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728620),('5','184','257108','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728621),('5','184','257108','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728622),('5','184','257108','429',165.00,165.00,2587.45,0.00,0.00,0.00,0.00,728623),('5','184','257109','429',165.00,165.00,1087.06,0.00,0.00,0.00,0.00,728624),('5','184','257109','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728625),('5','184','257109','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728626),('5','184','257110','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728627),('5','184','257110','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728628),('5','184','257110','429',165.00,165.00,2090.78,0.00,0.00,0.00,0.00,728629),('5','184','257111','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728630),('5','184','257111','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728631),('5','184','257111','429',165.00,165.00,8862.93,0.00,0.00,0.00,0.00,728632),('5','184','257112','430',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728633),('5','184','257112','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728634),('5','184','257112','429',165.00,165.00,10346.03,0.00,0.00,0.00,0.00,728635),('5','184','257113','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728636),('5','184','257113','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728637),('5','184','257113','429',165.00,165.00,8203.92,0.00,0.00,0.00,0.00,728638),('5','184','257114','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728639),('5','184','257114','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728640),('5','184','257114','429',165.00,165.00,4185.36,0.00,0.00,0.00,0.00,728641),('5','184','257115','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728642),('5','184','257115','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728643),('5','184','257115','429',165.00,165.00,4268.61,0.00,0.00,0.00,0.00,728644),('5','184','257116','429',165.00,165.00,2045.96,0.00,0.00,0.00,0.00,728645),('5','184','257116','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728646),('5','184','257116','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728647),('5','184','257117','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728648),('5','184','257117','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728649),('5','184','257117','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728650),('5','184','257118','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728651),('5','184','257118','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728652),('5','184','257118','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728653),('5','184','257119','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728654),('5','184','257119','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728655),('5','184','257119','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728656),('5','184','257120','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728657),('5','184','257120','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728658),('5','184','257120','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728659),('5','184','257121','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728660),('5','184','257121','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728661),('5','184','257121','429',165.00,165.00,5570.39,0.00,0.00,0.00,0.00,728662),('5','184','257122','429',165.00,165.00,3202.77,0.00,0.00,0.00,0.00,728663),('5','184','257122','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728664),('5','184','257122','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728665),('5','184','257123','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728666),('5','184','257123','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728667),('5','184','257123','429',165.00,165.00,3193.10,0.00,0.00,0.00,0.00,728668),('5','184','257124','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728669),('5','184','257124','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728670),('5','184','257124','429',165.00,165.00,2002.74,0.00,0.00,0.00,0.00,728671),('5','184','257125','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728672),('5','184','257125','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728673),('5','184','257125','429',165.00,165.00,1998.32,0.00,0.00,0.00,0.00,728674),('5','184','257126','430',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728675),('5','184','257126','431',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728676),('5','184','257126','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728677),('5','184','257127','430',700.00,700.00,0.00,0.00,0.00,0.00,0.00,728678),('5','184','257127','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728679),('5','184','257127','429',165.00,165.00,20661.98,0.00,0.00,0.00,0.00,728680),('5','184','257128','430',700.00,700.00,0.00,0.00,0.00,0.00,0.00,728681),('5','184','257128','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728682),('5','184','257128','429',165.00,165.00,353.54,0.00,0.00,0.00,0.00,728683),('5','184','257129','430',700.00,750.00,0.00,0.00,0.00,0.00,0.00,728684),('5','184','257129','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728685),('5','184','257129','429',165.00,165.00,132.89,0.00,0.00,0.00,0.00,728686),('5','184','257130','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728687),('5','184','257130','430',700.00,700.00,1200.02,0.00,0.00,0.00,0.00,728688),('5','184','257130','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728689),('5','184','257131','429',165.00,165.00,2700.00,0.00,0.00,0.00,0.00,728690),('5','184','257131','430',700.00,700.00,0.00,0.00,0.00,0.00,0.00,728691),('5','184','257131','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728692),('5','184','257132','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728693),('5','184','257132','431',400.00,400.00,100.02,0.00,0.00,0.00,0.00,728694),('5','184','257132','429',165.00,165.00,760.09,0.00,0.00,0.00,0.00,728695),('5','184','257133','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728696),('5','184','257133','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728697),('5','184','257133','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728698),('5','184','257134','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728699),('5','184','257134','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728700),('5','184','257134','429',165.00,165.00,49.25,0.00,0.00,0.00,0.00,728701),('5','184','257135','429',165.00,165.00,4115.13,0.00,0.00,0.00,0.00,728702),('5','184','257135','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728703),('5','184','257135','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728704),('5','184','257136','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728705),('5','184','257136','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728706),('5','184','257136','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728707),('5','184','257137','429',165.00,165.00,6025.13,0.00,0.00,0.00,0.00,728708),('5','184','257137','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728709),('5','184','257137','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728710),('5','184','257138','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728711),('5','184','257138','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728712),('5','184','257138','429',165.00,165.00,5948.75,0.00,0.00,0.00,0.00,728713),('5','184','257139','429',165.00,165.00,4380.82,0.00,0.00,0.00,0.00,728714),('5','184','257139','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728715),('5','184','257139','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728716),('5','184','257140','429',165.00,165.00,6449.08,0.00,0.00,0.00,0.00,728717),('5','184','257140','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728718),('5','184','257140','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728719),('5','184','257141','429',165.00,165.00,3997.18,0.00,0.00,0.00,0.00,728720),('5','184','257141','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728721),('5','184','257141','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728722),('5','184','257142','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728723),('5','184','257142','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728724),('5','184','257142','429',165.00,165.00,4080.51,0.00,0.00,0.00,0.00,728725),('5','184','257143','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728726),('5','184','257143','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728727),('5','184','257143','429',165.00,165.00,4087.80,0.00,0.00,0.00,0.00,728728),('5','184','257144','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728729),('5','184','257144','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728730),('5','184','257144','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728731),('5','184','257145','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728732),('5','184','257145','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728733),('5','184','257145','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728734),('5','184','257146','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728735),('5','184','257146','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728736),('5','184','257146','429',165.00,165.00,7809.43,0.00,0.00,0.00,0.00,728737),('5','184','257147','429',165.00,165.00,4128.05,0.00,0.00,0.00,0.00,728738),('5','184','257147','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728739),('5','184','257147','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728740),('5','184','257148','429',165.00,165.00,940.17,0.00,0.00,0.00,0.00,728741),('5','184','257148','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728742),('5','184','257148','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728743),('5','184','257149','429',165.00,165.00,2690.24,0.00,0.00,0.00,0.00,728744),('5','184','257149','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728745),('5','184','257149','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728746),('5','184','257150','429',165.00,165.00,5892.39,0.00,0.00,0.00,0.00,728747),('5','184','257150','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728748),('5','184','257150','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728749),('5','184','257151','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728750),('5','184','257151','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728751),('5','184','257151','429',165.00,165.00,6999.58,0.00,0.00,0.00,0.00,728752),('5','184','257152','429',165.00,165.00,5563.32,0.00,0.00,0.00,0.00,728753),('5','184','257152','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728754),('5','184','257152','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728755),('5','184','257153','429',165.00,165.00,3052.14,0.00,0.00,0.00,0.00,728756),('5','184','257153','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728757),('5','184','257153','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728758),('5','184','257154','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728759),('5','184','257154','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728760),('5','184','257154','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728761),('5','184','257155','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728762),('5','184','257155','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728763),('5','184','257155','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728764),('5','184','257156','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728765),('5','184','257156','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728766),('5','184','257156','429',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728767),('5','184','257157','429',185.00,165.00,1508.48,0.00,0.00,0.00,0.00,728768),('5','184','257157','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728769),('5','184','257157','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728770),('5','184','257158','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728771),('5','184','257158','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728772),('5','184','257158','429',185.00,165.00,4715.19,0.00,0.00,0.00,0.00,728773),('5','184','257159','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728774),('5','184','257159','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728775),('5','184','257159','429',185.00,165.00,4892.77,0.00,0.00,0.00,0.00,728776),('5','184','257160','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728777),('5','184','257160','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728778),('5','184','257160','429',185.00,165.00,5104.86,0.00,0.00,0.00,0.00,728779),('5','184','257161','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728780),('5','184','257161','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728781),('5','184','257161','429',185.00,165.00,5808.31,0.00,0.00,0.00,0.00,728782),('5','184','257162','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728783),('5','184','257162','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728784),('5','184','257162','429',185.00,165.00,4707.66,0.00,0.00,0.00,0.00,728785),('5','184','257163','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728786),('5','184','257163','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728787),('5','184','257163','429',185.00,165.00,5110.23,0.00,0.00,0.00,0.00,728788),('5','184','257164','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728789),('5','184','257164','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728790),('5','184','257164','429',185.00,165.00,3922.77,0.00,0.00,0.00,0.00,728791),('5','184','257165','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728792),('5','184','257165','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728793),('5','184','257165','429',185.00,165.00,11087.68,0.00,0.00,0.00,0.00,728794),('5','184','257166','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728795),('5','184','257166','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728796),('5','184','257166','429',185.00,165.00,8623.58,0.00,0.00,0.00,0.00,728797),('5','184','257167','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728798),('5','184','257167','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728799),('5','184','257167','429',185.00,165.00,10192.51,0.00,0.00,0.00,0.00,728800),('5','184','257168','429',185.00,165.00,6661.51,0.00,0.00,0.00,0.00,728801),('5','184','257168','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728802),('5','184','257168','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728803),('5','184','257169','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728804),('5','184','257169','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728805),('5','184','257169','429',185.00,165.00,4125.02,0.00,0.00,0.00,0.00,728806),('5','184','257170','429',185.00,165.00,3550.92,0.00,0.00,0.00,0.00,728807),('5','184','257170','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728808),('5','184','257170','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728809),('5','184','257171','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728810),('5','184','257171','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728811),('5','184','257171','429',185.00,165.00,2443.15,0.00,0.00,0.00,0.00,728812),('5','184','257172','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728813),('5','184','257172','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728814),('5','184','257172','429',185.00,165.00,1963.91,0.00,0.00,0.00,0.00,728815),('5','184','257173','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728816),('5','184','257173','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728817),('5','184','257173','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728818),('5','184','257174','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728819),('5','184','257174','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728820),('5','184','257174','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728821),('5','184','257175','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728822),('5','184','257175','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728823),('5','184','257175','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728824),('5','184','257176','429',185.00,165.00,10492.32,0.00,0.00,0.00,0.00,728825),('5','184','257176','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728826),('5','184','257176','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728827),('5','184','257177','429',185.00,165.00,6484.69,0.00,0.00,0.00,0.00,728828),('5','184','257177','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728829),('5','184','257177','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728830),('5','184','257178','429',185.00,165.00,5177.63,0.00,0.00,0.00,0.00,728831),('5','184','257178','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728832),('5','184','257178','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728833),('5','184','257179','429',185.00,165.00,5907.18,0.00,0.00,0.00,0.00,728834),('5','184','257179','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728835),('5','184','257179','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728836),('5','184','257180','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728837),('5','184','257180','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728838),('5','184','257180','429',185.00,165.00,7371.09,0.00,0.00,0.00,0.00,728839),('5','184','257181','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728840),('5','184','257181','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728841),('5','184','257181','429',185.00,165.00,4528.36,0.00,0.00,0.00,0.00,728842),('5','184','257182','429',185.00,165.00,7365.97,0.00,0.00,0.00,0.00,728843),('5','184','257182','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728844),('5','184','257182','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728845),('5','184','257183','429',185.00,165.00,6097.04,0.00,0.00,0.00,0.00,728846),('5','184','257183','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728847),('5','184','257183','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728848),('5','184','257184','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728849),('5','184','257184','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728850),('5','184','257184','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728851),('5','184','257185','429',185.00,165.00,6812.85,0.00,0.00,0.00,0.00,728852),('5','184','257185','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728853),('5','184','257185','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728854),('5','184','257186','429',185.00,165.00,8838.27,0.00,0.00,0.00,0.00,728855),('5','184','257186','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728856),('5','184','257186','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728857),('5','184','257187','429',185.00,165.00,7930.47,0.00,0.00,0.00,0.00,728858),('5','184','257187','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728859),('5','184','257187','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728860),('5','184','257188','429',185.00,165.00,7485.18,0.00,0.00,0.00,0.00,728861),('5','184','257188','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728862),('5','184','257188','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728863),('5','184','257189','429',185.00,165.00,6283.87,0.00,0.00,0.00,0.00,728864),('5','184','257189','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728865),('5','184','257189','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728866),('5','184','257190','429',185.00,165.00,4335.43,0.00,0.00,0.00,0.00,728867),('5','184','257190','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728868),('5','184','257190','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728869),('5','184','257191','429',185.00,165.00,5777.95,0.00,0.00,0.00,0.00,728870),('5','184','257191','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728871),('5','184','257191','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728872),('5','184','257192','429',185.00,165.00,5365.62,0.00,0.00,0.00,0.00,728873),('5','184','257192','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728874),('5','184','257192','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728875),('5','184','257193','429',185.00,165.00,6140.67,0.00,0.00,0.00,0.00,728876),('5','184','257193','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728877),('5','184','257193','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728878),('5','184','257194','429',185.00,165.00,7562.20,0.00,0.00,0.00,0.00,728879),('5','184','257194','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728880),('5','184','257194','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728881),('5','184','257195','429',185.00,165.00,7187.54,0.00,0.00,0.00,0.00,728882),('5','184','257195','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728883),('5','184','257195','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728884),('5','184','257196','429',185.00,165.00,9353.46,0.00,0.00,0.00,0.00,728885),('5','184','257196','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728886),('5','184','257196','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728887),('5','184','257197','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728888),('5','184','257197','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728889),('5','184','257197','429',185.00,165.00,10296.69,0.00,0.00,0.00,0.00,728890),('5','184','257198','429',185.00,165.00,9021.67,0.00,0.00,0.00,0.00,728891),('5','184','257198','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728892),('5','184','257198','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728893),('5','184','257199','429',185.00,165.00,15354.07,0.00,0.00,0.00,0.00,728894),('5','184','257199','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728895),('5','184','257199','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728896),('5','184','257200','429',185.00,165.00,7262.03,0.00,0.00,0.00,0.00,728897),('5','184','257200','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728898),('5','184','257200','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728899),('5','184','257201','429',185.00,165.00,6890.43,0.00,0.00,0.00,0.00,728900),('5','184','257201','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728901),('5','184','257201','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728902),('5','184','257202','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728903),('5','184','257202','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728904),('5','184','257202','429',185.00,165.00,8243.39,0.00,0.00,0.00,0.00,728905),('5','184','257203','429',185.00,165.00,9178.29,0.00,0.00,0.00,0.00,728906),('5','184','257203','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728907),('5','184','257203','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728908),('5','184','257204','429',185.00,165.00,3215.82,0.00,0.00,0.00,0.00,728909),('5','184','257204','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728910),('5','184','257204','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728911),('5','184','257205','429',185.00,165.00,11529.95,0.00,0.00,0.00,0.00,728912),('5','184','257205','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728913),('5','184','257205','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728914),('5','184','257206','429',185.00,165.00,9008.76,0.00,0.00,0.00,0.00,728915),('5','184','257206','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728916),('5','184','257206','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728917),('5','184','257207','429',185.00,165.00,9376.80,0.00,0.00,0.00,0.00,728918),('5','184','257207','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728919),('5','184','257207','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728920),('5','184','257208','429',185.00,165.00,6165.50,0.00,0.00,0.00,0.00,728921),('5','184','257208','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728922),('5','184','257208','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728923),('5','184','257209','429',185.00,165.00,3522.33,0.00,0.00,0.00,0.00,728924),('5','184','257209','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728925),('5','184','257209','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728926),('5','184','257210','429',185.00,165.00,3317.01,0.00,0.00,0.00,0.00,728927),('5','184','257210','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728928),('5','184','257210','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728929),('5','184','257211','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728930),('5','184','257211','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728931),('5','184','257211','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728932),('5','184','257212','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728933),('5','184','257212','430',750.00,750.00,0.00,0.00,0.00,0.00,0.00,728934),('5','184','257212','431',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728935),('5','184','257213','429',185.00,165.00,0.00,0.00,0.00,0.00,0.00,728936),('5','184','257213','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728937),('5','184','257213','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728938),('5','184','257214','429',185.00,165.00,7642.15,0.00,0.00,0.00,0.00,728939),('5','184','257214','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728940),('5','184','257214','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728941),('5','184','257215','429',185.00,165.00,6993.37,0.00,0.00,0.00,0.00,728942),('5','184','257215','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728943),('5','184','257215','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728944),('5','184','257216','429',185.00,165.00,7392.82,0.00,0.00,0.00,0.00,728945),('5','184','257216','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728946),('5','184','257216','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728947),('5','184','257217','429',185.00,165.00,7151.02,0.00,0.00,0.00,0.00,728948),('5','184','257217','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728949),('5','184','257217','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728950),('5','184','257218','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728951),('5','184','257218','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728952),('5','184','257218','429',185.00,165.00,7184.74,0.00,0.00,0.00,0.00,728953),('5','184','257219','429',185.00,165.00,7808.30,0.00,0.00,0.00,0.00,728954),('5','184','257219','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728955),('5','184','257219','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728956),('5','184','257220','429',185.00,165.00,7271.58,0.00,0.00,0.00,0.00,728957),('5','184','257220','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728958),('5','184','257220','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728959),('5','184','257221','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728960),('5','184','257221','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728961),('5','184','257221','429',185.00,165.00,6863.22,0.00,0.00,0.00,0.00,728962),('5','184','257222','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728963),('5','184','257222','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728964),('5','184','257222','429',185.00,165.00,7276.70,0.00,0.00,0.00,0.00,728965),('5','184','257223','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728966),('5','184','257223','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728967),('5','184','257223','429',185.00,165.00,6973.20,0.00,0.00,0.00,0.00,728968),('5','184','257224','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728969),('5','184','257224','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728970),('5','184','257224','429',185.00,185.00,5522.79,0.00,0.00,0.00,0.00,728971),('5','184','257225','429',185.00,185.00,6424.70,0.00,0.00,0.00,0.00,728972),('5','184','257225','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728973),('5','184','257225','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728974),('5','184','257226','429',185.00,185.00,7089.23,0.00,0.00,0.00,0.00,728975),('5','184','257226','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728976),('5','184','257226','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728977),('5','184','257227','429',185.00,185.00,6640.93,0.00,0.00,0.00,0.00,728978),('5','184','257227','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728979),('5','184','257227','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728980),('5','184','257228','429',185.00,185.00,6481.01,0.00,0.00,0.00,0.00,728981),('5','184','257228','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728982),('5','184','257228','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728983),('5','184','257229','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728984),('5','184','257229','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728985),('5','184','257229','429',185.00,185.00,6935.50,0.00,0.00,0.00,0.00,728986),('5','184','257230','429',185.00,185.00,7686.18,0.00,0.00,0.00,0.00,728987),('5','184','257230','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728988),('5','184','257230','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728989),('5','184','257231','429',185.00,185.00,7337.92,0.00,0.00,0.00,0.00,728990),('5','184','257231','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728991),('5','184','257231','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728992),('5','184','257232','429',185.00,185.00,8113.14,0.00,0.00,0.00,0.00,728993),('5','184','257232','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728994),('5','184','257232','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728995),('5','184','257233','429',185.00,185.00,7816.73,0.00,0.00,0.00,0.00,728996),('5','184','257233','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,728997),('5','184','257233','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,728998),('5','184','257234','429',185.00,185.00,7808.81,0.00,0.00,0.00,0.00,728999),('5','184','257234','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729000),('5','184','257234','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729001),('5','184','257235','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729002),('5','184','257235','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729003),('5','184','257235','429',185.00,185.00,6905.41,0.00,0.00,0.00,0.00,729004),('5','184','257236','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729005),('5','184','257236','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729006),('5','184','257236','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729007),('5','184','257237','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729008),('5','184','257237','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729009),('5','184','257237','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729010),('5','184','257238','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729011),('5','184','257238','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729012),('5','184','257238','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729013),('5','184','257239','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729014),('5','184','257239','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729015),('5','184','257239','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729016),('5','184','257240','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729017),('5','184','257240','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729018),('5','184','257240','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729019),('5','184','257241','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729020),('5','184','257241','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729021),('5','184','257241','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729022),('5','184','257242','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729023),('5','184','257242','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729024),('5','184','257242','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729025),('5','184','257243','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729026),('5','184','257243','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729027),('5','184','257243','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729028),('5','184','257244','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729029),('5','184','257244','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729030),('5','184','257244','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729031),('5','184','257245','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729032),('5','184','257245','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729033),('5','184','257245','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729034),('5','184','257246','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729035),('5','184','257246','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729036),('5','184','257246','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729037),('5','184','257247','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729038),('5','184','257247','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729039),('5','184','257247','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729040),('5','184','257248','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729041),('5','184','257248','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729042),('5','184','257248','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729043),('5','184','257249','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729044),('5','184','257249','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729045),('5','184','257249','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729046),('5','184','257250','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729047),('5','184','257250','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729048),('5','184','257250','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729049),('5','184','257251','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729050),('5','184','257251','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729051),('5','184','257251','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729052),('5','184','257252','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729053),('5','184','257252','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729054),('5','184','257252','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729055),('5','184','257253','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729056),('5','184','257253','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729057),('5','184','257253','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729058),('5','184','257254','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729059),('5','184','257254','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729060),('5','184','257254','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729061),('5','184','257255','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729062),('5','184','257255','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729063),('5','184','257255','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729064),('5','184','257256','429',185.00,185.00,10865.50,0.00,0.00,0.00,0.00,729065),('5','184','257256','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729066),('5','184','257256','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729067),('5','184','257257','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729068),('5','184','257257','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729069),('5','184','257257','429',185.00,185.00,6537.32,0.00,0.00,0.00,0.00,729070),('5','184','257258','429',185.00,185.00,7595.87,0.00,0.00,0.00,0.00,729071),('5','184','257258','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729072),('5','184','257258','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729073),('5','184','257259','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729074),('5','184','257259','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729075),('5','184','257259','429',185.00,185.00,4932.56,0.00,0.00,0.00,0.00,729076),('5','184','257260','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729077),('5','184','257260','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729078),('5','184','257260','429',185.00,185.00,10175.70,0.00,0.00,0.00,0.00,729079),('5','184','257261','429',185.00,185.00,8905.09,0.00,0.00,0.00,0.00,729080),('5','184','257261','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729081),('5','184','257261','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729082),('5','184','257262','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729083),('5','184','257262','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729084),('5','184','257262','429',185.00,185.00,10199.90,0.00,0.00,0.00,0.00,729085),('5','184','257263','429',185.00,185.00,10650.55,0.00,0.00,0.00,0.00,729086),('5','184','257263','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729087),('5','184','257263','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729088),('5','184','257264','429',185.00,185.00,9927.35,0.00,0.00,0.00,0.00,729089),('5','184','257264','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729090),('5','184','257264','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729091),('5','184','257265','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729092),('5','184','257265','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729093),('5','184','257265','429',185.00,185.00,10088.66,0.00,0.00,0.00,0.00,729094),('5','184','257266','429',185.00,185.00,9337.26,0.00,0.00,0.00,0.00,729095),('5','184','257266','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729096),('5','184','257266','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729097),('5','184','257267','429',185.00,185.00,5796.17,0.00,0.00,0.00,0.00,729098),('5','184','257267','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729099),('5','184','257267','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729100),('5','184','257268','429',185.00,185.00,10999.67,0.00,0.00,0.00,0.00,729101),('5','184','257268','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729102),('5','184','257268','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729103),('5','184','257269','429',185.00,185.00,7043.96,0.00,0.00,0.00,0.00,729104),('5','184','257269','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729105),('5','184','257269','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729106),('5','184','257270','429',185.00,185.00,6966.42,0.00,0.00,0.00,0.00,729107),('5','184','257270','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729108),('5','184','257270','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729109),('5','184','257271','430',800.00,870.00,0.00,0.00,0.00,0.00,0.00,729110),('5','184','257271','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729111),('5','184','257271','429',185.00,185.00,390.03,0.00,0.00,0.00,0.00,729112),('5','184','257272','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729113),('5','184','257272','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729114),('5','184','257272','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729115),('5','184','257273','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729116),('5','184','257273','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729117),('5','184','257273','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729118),('5','184','257274','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729119),('5','184','257274','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729120),('5','184','257274','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729121),('5','184','257275','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729122),('5','184','257275','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729123),('5','184','257275','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729124),('5','184','257276','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729125),('5','184','257276','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729126),('5','184','257276','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729127),('5','184','257277','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729128),('5','184','257277','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729129),('5','184','257277','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729130),('5','184','257278','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729131),('5','184','257278','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729132),('5','184','257278','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729133),('5','184','257279','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729134),('5','184','257279','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729135),('5','184','257279','429',185.00,185.00,2729.78,0.00,0.00,0.00,0.00,729136),('5','184','257280','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729137),('5','184','257280','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729138),('5','184','257280','429',185.00,185.00,8732.47,0.00,0.00,0.00,0.00,729139),('5','184','257281','429',185.00,185.00,7167.40,0.00,0.00,0.00,0.00,729140),('5','184','257281','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729141),('5','184','257281','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729142),('5','184','257282','429',185.00,185.00,8161.30,0.00,0.00,0.00,0.00,729143),('5','184','257282','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729144),('5','184','257282','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729145),('5','184','257283','429',185.00,185.00,6260.91,0.00,0.00,0.00,0.00,729146),('5','184','257283','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729147),('5','184','257283','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729148),('5','184','257284','429',185.00,185.00,5405.66,0.00,0.00,0.00,0.00,729149),('5','184','257284','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729150),('5','184','257284','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729151),('5','184','257285','429',185.00,185.00,1466.39,0.00,0.00,0.00,0.00,729152),('5','184','257285','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729153),('5','184','257285','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729154),('5','184','257286','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729155),('5','184','257286','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729156),('5','184','257286','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729157),('5','184','257287','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729158),('5','184','257287','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729159),('5','184','257287','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729160),('5','184','257288','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729161),('5','184','257288','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729162),('5','184','257288','429',185.00,185.00,3002.91,0.00,0.00,0.00,0.00,729163),('5','184','257289','429',185.00,185.00,13664.10,0.00,0.00,0.00,0.00,729164),('5','184','257289','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729165),('5','184','257289','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729166),('5','184','257290','429',185.00,185.00,5732.45,0.00,0.00,0.00,0.00,729167),('5','184','257290','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729168),('5','184','257290','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729169),('5','184','257291','429',185.00,185.00,8128.67,0.00,0.00,0.00,0.00,729170),('5','184','257291','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729171),('5','184','257291','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729172),('5','184','257292','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729173),('5','184','257292','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729174),('5','184','257292','429',185.00,185.00,5885.10,0.00,0.00,0.00,0.00,729175),('5','184','257293','429',185.00,185.00,5596.61,0.00,0.00,0.00,0.00,729176),('5','184','257293','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729177),('5','184','257293','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729178),('5','184','257294','429',185.00,185.00,2956.07,0.00,0.00,0.00,0.00,729179),('5','184','257294','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729180),('5','184','257294','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729181),('5','184','257295','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729182),('5','184','257295','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729183),('5','184','257295','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729184),('5','184','257296','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729185),('5','184','257296','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729186),('5','184','257296','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729187),('5','184','257297','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729188),('5','184','257297','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729189),('5','184','257297','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729190),('5','184','257298','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729191),('5','184','257298','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729192),('5','184','257298','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729193),('5','184','257299','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729194),('5','184','257299','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729195),('5','184','257299','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729196),('5','184','257300','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729197),('5','184','257300','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729198),('5','184','257300','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729199),('5','184','257301','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729200),('5','184','257301','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729201),('5','184','257301','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729202),('5','184','257302','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729203),('5','184','257302','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729204),('5','184','257302','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729205),('5','184','257303','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729206),('5','184','257303','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729207),('5','184','257303','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729208),('5','184','257304','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729209),('5','184','257304','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729210),('5','184','257304','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729211),('5','184','257305','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729212),('5','184','257305','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729213),('5','184','257305','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729214),('5','184','257306','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729215),('5','184','257306','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729216),('5','184','257306','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729217),('5','184','257307','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729218),('5','184','257307','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729219),('5','184','257307','429',185.00,185.00,2258.24,0.00,0.00,0.00,0.00,729220),('5','184','257308','429',185.00,185.00,6177.74,0.00,0.00,0.00,0.00,729221),('5','184','257308','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729222),('5','184','257308','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729223),('5','184','257309','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729224),('5','184','257309','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729225),('5','184','257309','429',185.00,185.00,7267.48,0.00,0.00,0.00,0.00,729226),('5','184','257310','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729227),('5','184','257310','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729228),('5','184','257310','429',185.00,185.00,8500.26,0.00,0.00,0.00,0.00,729229),('5','184','257311','429',185.00,185.00,3015.76,0.00,0.00,0.00,0.00,729230),('5','184','257311','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729231),('5','184','257311','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729232),('5','184','257312','429',185.00,185.00,2720.42,0.00,0.00,0.00,0.00,729233),('5','184','257312','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729234),('5','184','257312','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729235),('5','184','257313','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729236),('5','184','257313','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729237),('5','184','257313','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729238),('5','184','257314','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729239),('5','184','257314','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729240),('5','184','257314','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729241),('5','184','257315','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729242),('5','184','257315','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729243),('5','184','257315','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729244),('5','184','257316','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729245),('5','184','257316','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729246),('5','184','257316','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729247),('5','184','257317','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729248),('5','184','257317','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729249),('5','184','257317','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729250),('5','184','257318','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729251),('5','184','257318','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729252),('5','184','257318','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729253),('5','184','257319','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729254),('5','184','257319','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729255),('5','184','257319','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729256),('5','184','257320','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729257),('5','184','257320','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729258),('5','184','257320','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729259),('5','184','257321','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729260),('5','184','257321','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729261),('5','184','257321','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729262),('5','184','257322','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729263),('5','184','257322','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729264),('5','184','257322','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729265),('5','184','257323','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729266),('5','184','257323','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729267),('5','184','257323','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729268),('5','184','257324','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729269),('5','184','257324','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729270),('5','184','257324','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729271),('5','184','257325','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729272),('5','184','257325','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729273),('5','184','257325','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729274),('5','184','257326','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729275),('5','184','257326','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729276),('5','184','257326','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729277),('5','184','257327','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729278),('5','184','257327','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729279),('5','184','257327','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729280),('5','184','257328','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729281),('5','184','257328','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729282),('5','184','257328','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729283),('5','184','257329','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729284),('5','184','257329','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729285),('5','184','257329','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729286),('5','184','257330','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729287),('5','184','257330','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729288),('5','184','257330','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729289),('5','184','257331','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729290),('5','184','257331','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729291),('5','184','257331','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729292),('5','184','257332','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729293),('5','184','257332','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729294),('5','184','257332','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729295),('5','184','257333','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729296),('5','184','257333','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729297),('5','184','257333','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729298),('5','184','257334','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729299),('5','184','257334','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729300),('5','184','257334','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729301),('5','184','257335','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729302),('5','184','257335','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729303),('5','184','257335','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729304),('5','184','257336','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729305),('5','184','257336','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729306),('5','184','257336','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729307),('5','184','257337','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729308),('5','184','257337','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729309),('5','184','257337','429',185.00,185.00,7224.14,0.00,0.00,0.00,0.00,729310),('5','184','257338','429',185.00,185.00,11661.20,0.00,0.00,0.00,0.00,729311),('5','184','257338','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729312),('5','184','257338','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729313),('5','184','257339','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729314),('5','184','257339','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729315),('5','184','257339','429',185.00,185.00,7135.55,0.00,0.00,0.00,0.00,729316),('5','184','257340','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729317),('5','184','257340','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729318),('5','184','257340','429',185.00,185.00,5758.97,0.00,0.00,0.00,0.00,729319),('5','184','257341','429',185.00,220.00,4457.93,0.00,0.00,0.00,0.00,729320),('5','184','257341','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729321),('5','184','257341','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729322),('5','184','257342','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729323),('5','184','257342','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729324),('5','184','257342','429',185.00,220.00,3281.74,0.00,0.00,0.00,0.00,729325),('5','184','257343','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729326),('5','184','257343','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729327),('5','184','257343','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729328),('5','184','257344','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729329),('5','184','257344','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729330),('5','184','257344','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729331),('5','184','257345','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729332),('5','184','257345','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729333),('5','184','257345','429',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729334),('5','184','257346','429',220.00,185.00,0.00,0.00,0.00,0.00,0.00,729335),('5','184','257346','430',800.00,220.00,0.00,0.00,0.00,0.00,0.00,729336),('5','184','257346','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729337),('5','184','257347','429',220.00,220.00,7575.09,0.00,0.00,0.00,0.00,729338),('5','184','257347','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729339),('5','184','257347','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729340),('5','184','257348','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729341),('5','184','257348','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729342),('5','184','257348','429',220.00,220.00,7818.38,0.00,0.00,0.00,0.00,729343),('5','184','257349','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729344),('5','184','257349','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729345),('5','184','257349','429',220.00,220.00,6485.06,0.00,0.00,0.00,0.00,729346),('5','184','257350','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729347),('5','184','257350','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729348),('5','184','257350','429',220.00,220.00,9818.60,0.00,0.00,0.00,0.00,729349),('5','184','257351','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729350),('5','184','257351','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729351),('5','184','257351','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729352),('5','184','257352','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729353),('5','184','257352','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729354),('5','184','257352','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729355),('5','184','257353','429',220.00,220.00,6286.27,0.00,0.00,0.00,0.00,729356),('5','184','257353','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729357),('5','184','257353','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729358),('5','184','257354','429',220.00,220.00,4041.95,0.00,0.00,0.00,0.00,729359),('5','184','257354','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729360),('5','184','257354','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729361),('5','184','257355','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729362),('5','184','257355','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729363),('5','184','257355','429',220.00,220.00,6083.14,0.00,0.00,0.00,0.00,729364),('5','184','257356','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729365),('5','184','257356','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729366),('5','184','257356','429',220.00,185.00,578.21,0.00,0.00,0.00,0.00,729367),('5','184','257357','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729368),('5','184','257357','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729369),('5','184','257357','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729370),('5','184','257358','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729371),('5','184','257358','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729372),('5','184','257358','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729373),('5','184','257359','429',220.00,220.00,6275.02,0.00,0.00,0.00,0.00,729374),('5','184','257359','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729375),('5','184','257359','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729376),('5','184','257360','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729377),('5','184','257360','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729378),('5','184','257360','429',220.00,220.00,5966.27,0.00,0.00,0.00,0.00,729379),('5','184','257361','429',220.00,220.00,2777.50,0.00,0.00,0.00,0.00,729380),('5','184','257361','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729381),('5','184','257361','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729382),('5','184','257362','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729383),('5','184','257362','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729384),('5','184','257362','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729385),('5','184','257363','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729386),('5','184','257363','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729387),('5','184','257363','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729388),('5','184','257364','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729389),('5','184','257364','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729390),('5','184','257364','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729391),('5','184','257365','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729392),('5','184','257365','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729393),('5','184','257365','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729394),('5','184','257366','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729395),('5','184','257366','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729396),('5','184','257366','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729397),('5','184','257367','430',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729398),('5','184','257367','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729399),('5','184','257367','429',220.00,220.00,0.00,0.00,0.00,0.00,0.00,729400),('5','184','257368','429',220.00,210.00,0.00,0.00,0.00,0.00,0.00,729401),('5','184','257368','430',800.00,810.00,0.00,0.00,0.00,0.00,0.00,729402),('5','184','257368','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729403),('5','184','257369','429',220.00,210.00,0.00,0.00,0.00,0.00,0.00,729404),('5','184','257369','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729405),('5','184','257369','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729406),('5','184','257370','429',220.00,210.00,0.00,0.00,0.00,0.00,0.00,729407),('5','184','257370','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729408),('5','184','257370','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729409),('5','184','257371','429',220.00,210.00,0.00,0.00,0.00,0.00,0.00,729410),('5','184','257371','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729411),('5','184','257371','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729412),('5','184','257372','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729413),('5','184','257372','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729414),('5','184','257372','429',210.00,210.00,1249.86,0.00,0.00,0.00,0.00,729415),('5','184','257373','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729416),('5','184','257373','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729417),('5','184','257373','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729418),('5','184','257374','429',210.00,210.00,4609.30,0.00,0.00,0.00,0.00,729419),('5','184','257374','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729420),('5','184','257374','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729421),('5','184','257375','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729422),('5','184','257375','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729423),('5','184','257375','429',210.00,210.00,4949.72,0.00,0.00,0.00,0.00,729424),('5','184','257376','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729425),('5','184','257376','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729426),('5','184','257376','429',210.00,210.00,6621.74,0.00,0.00,0.00,0.00,729427),('5','184','257377','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729428),('5','184','257377','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729429),('5','184','257377','429',210.00,210.00,8096.92,0.00,0.00,0.00,0.00,729430),('5','184','257378','429',210.00,210.00,7125.18,0.00,0.00,0.00,0.00,729431),('5','184','257378','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729432),('5','184','257378','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729433),('5','184','257379','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729434),('5','184','257379','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729435),('5','184','257379','429',210.00,210.00,8180.80,0.00,0.00,0.00,0.00,729436),('5','184','257380','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729437),('5','184','257380','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729438),('5','184','257380','429',210.00,210.00,8064.52,0.00,0.00,0.00,0.00,729439),('5','184','257381','429',210.00,210.00,10357.21,0.00,0.00,0.00,0.00,729440),('5','184','257381','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729441),('5','184','257381','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729442),('5','184','257382','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729443),('5','184','257382','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729444),('5','184','257382','429',210.00,210.00,7243.12,0.00,0.00,0.00,0.00,729445),('5','184','257385','430',800.00,830.00,0.00,0.00,0.00,0.00,0.00,729450),('5','184','257385','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729451),('5','184','257385','429',210.00,210.00,11558.46,0.00,0.00,0.00,0.00,729452),('5','184','257386','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729453),('5','184','257386','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729454),('5','184','257386','429',210.00,210.00,8236.23,0.00,0.00,0.00,0.00,729455),('5','184','257387','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729456),('5','184','257387','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729457),('5','184','257387','429',210.00,210.00,6674.83,0.00,0.00,0.00,0.00,729458),('5','184','257388','429',210.00,210.00,7825.10,0.00,0.00,0.00,0.00,729459),('5','184','257388','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729460),('5','184','257388','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729461),('5','184','257389','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729462),('5','184','257389','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729463),('5','184','257389','429',210.00,210.00,8603.62,0.00,0.00,0.00,0.00,729464),('5','184','257390','429',210.00,210.00,7806.07,0.00,0.00,0.00,0.00,729465),('5','184','257390','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729466),('5','184','257390','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729467),('5','184','257391','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729468),('5','184','257391','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729469),('5','184','257391','429',210.00,210.00,7510.53,0.00,0.00,0.00,0.00,729470),('5','184','257392','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729471),('5','184','257392','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729472),('5','184','257392','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729473),('5','184','257393','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729474),('5','184','257393','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729475),('5','184','257393','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729476),('5','184','257394','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729477),('5','184','257394','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729478),('5','184','257394','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729479),('5','184','257395','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729480),('5','184','257395','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729481),('5','184','257395','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729482),('5','184','257396','430',800.00,820.00,0.00,0.00,0.00,0.00,0.00,729483),('5','184','257396','431',650.00,650.00,0.00,0.00,0.00,0.00,0.00,729484),('5','184','257396','429',210.00,210.00,0.00,0.00,0.00,0.00,0.00,729485);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=393 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',392,'184','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=961 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','184','392',957,0,'429','PMS TANK 1',51000.00,1.00,2547.67,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:07:00','2021-07-15 07:07:00','576',5,1),('5','184','392',958,0,'429','PMS TANK 2',55000.00,1.00,23887.29,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:09:27','2021-11-11 13:42:38','600',5,1),('5','184','392',959,0,'430','AGO TANK',40000.00,1.00,8937.24,'TANKS CONTAINING DIESEL.','576','2021-07-15 07:12:20','2021-07-15 07:12:20','576',5,1),('5','184','392',960,0,'431','DPK TANK',50000.00,1.00,27505.55,'TANKS CONTAINING KEROSENE.','576','2021-07-15 07:13:14','2021-08-03 10:17:10','600',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','184',960,300.00,'2023-03-20 20:24:33'),(2,'5','184',959,500.00,'2023-03-20 20:24:33'),(3,'5','184',958,1117.14,'2023-03-20 20:24:33'),(4,'5','184',957,189.47,'2023-03-20 20:24:33');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2628952 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2110537,'5','184','958',429,'Sale Id shift 242615',0.00,0.00,0.00,4603.65,0.00,'2021-12-01 08:33:26','',''),(2110538,'5','184','958',429,'Sale Id shift 242615',0.00,0.00,0.00,3460.09,0.00,'2021-12-01 08:33:26','',''),(2110539,'5','184','958',429,'Sale Id shift 242615',0.00,0.00,0.00,3066.71,0.00,'2021-12-01 08:33:26','',''),(2110540,'5','184','958',429,'Sale Id shift 242615',0.00,0.00,0.00,3354.57,0.00,'2021-12-01 08:33:26','',''),(2110541,'5','184','959',430,'Sale Id shift 242615',0.00,0.00,0.00,668.14,0.00,'2021-12-01 08:33:26','',''),(2110542,'5','184',NULL,429,'Sale Id shift 242615',2390028.30,0.00,0.00,0.00,0.00,'2021-12-01 08:33:26','',''),(2110543,'5','184',NULL,430,'Sale Id shift 242615',230508.30,0.00,0.00,0.00,0.00,'2021-12-01 08:33:26','',''),(2119812,'5','184','958',429,'Sale Id shift 243003',0.00,0.00,0.00,1140.83,0.00,'2021-12-01 19:21:09','',''),(2119813,'5','184','958',429,'Sale Id shift 243003',0.00,0.00,0.00,615.18,0.00,'2021-12-01 19:21:09','',''),(2119814,'5','184','958',429,'Sale Id shift 243003',0.00,0.00,0.00,1048.00,0.00,'2021-12-01 19:21:09','',''),(2119815,'5','184','958',429,'Sale Id shift 243003',0.00,0.00,0.00,602.39,0.00,'2021-12-01 19:21:09','',''),(2119816,'5','184','959',430,'Sale Id shift 243003',0.00,0.00,0.00,543.31,0.00,'2021-12-01 19:21:09','',''),(2119817,'5','184',NULL,429,'Sale Id shift 243003',562056.00,0.00,0.00,0.00,0.00,'2021-12-01 19:21:09','',''),(2119818,'5','184',NULL,430,'Sale Id shift 243003',187441.95,0.00,0.00,0.00,0.00,'2021-12-01 19:21:09','',''),(2126406,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2021-12-02 11:31:31','',''),(2129803,'5','184',NULL,429,'Reception corrector for bridging 125950',0.00,0.00,0.00,45000.00,0.00,'2021-12-02 15:07:08','',''),(2129804,'5','184','957',429,'Received from bridging 125950',0.00,0.00,45000.00,0.00,0.00,'2021-12-02 15:07:08','',''),(2137615,'5','184','958',429,'Sale Id shift 243094',0.00,0.00,0.00,2269.86,0.00,'2021-12-03 09:30:23','',''),(2137616,'5','184','957',429,'Sale Id shift 243094',0.00,0.00,0.00,2043.24,0.00,'2021-12-03 09:30:23','',''),(2137617,'5','184','957',429,'Sale Id shift 243094',0.00,0.00,0.00,1216.50,0.00,'2021-12-03 09:30:23','',''),(2137618,'5','184','957',429,'Sale Id shift 243094',0.00,0.00,0.00,52.37,0.00,'2021-12-03 09:30:23','',''),(2137619,'5','184','957',429,'Sale Id shift 243094',0.00,0.00,0.00,1984.14,0.00,'2021-12-03 09:30:23','',''),(2137620,'5','184','959',430,'Sale Id shift 243094',0.00,0.00,0.00,750.14,0.00,'2021-12-03 09:30:23','',''),(2137621,'5','184',NULL,429,'Sale Id shift 243094',1248408.15,0.00,0.00,0.00,0.00,'2021-12-03 09:30:23','',''),(2137622,'5','184',NULL,430,'Sale Id shift 243094',258798.30,0.00,0.00,0.00,0.00,'2021-12-03 09:30:23','',''),(2160635,'5','184','957',429,'Sale Id shift 243473',0.00,0.00,0.00,4376.56,0.00,'2021-12-04 17:46:44','',''),(2160636,'5','184','957',429,'Sale Id shift 243473',0.00,0.00,0.00,3788.28,0.00,'2021-12-04 17:46:44','',''),(2160637,'5','184','957',429,'Sale Id shift 243473',0.00,0.00,0.00,3058.48,0.00,'2021-12-04 17:46:44','',''),(2160638,'5','184','957',429,'Sale Id shift 243473',0.00,0.00,0.00,2652.44,0.00,'2021-12-04 17:46:44','',''),(2160639,'5','184','959',430,'Sale Id shift 243473',0.00,0.00,0.00,673.08,0.00,'2021-12-04 17:46:44','',''),(2160640,'5','184',NULL,429,'Sale Id shift 243473',2289500.40,0.00,0.00,0.00,0.00,'2021-12-04 17:46:44','',''),(2160641,'5','184',NULL,430,'Sale Id shift 243473',232212.60,0.00,0.00,0.00,0.00,'2021-12-04 17:46:44','',''),(2163574,'5','184','957',429,'Sale Id shift 243806',0.00,0.00,0.00,4660.83,0.00,'2021-12-05 07:50:06','',''),(2163575,'5','184','957',429,'Sale Id shift 243806',0.00,0.00,0.00,3751.58,0.00,'2021-12-05 07:50:06','',''),(2163576,'5','184','957',429,'Sale Id shift 243806',0.00,0.00,0.00,3882.47,0.00,'2021-12-05 07:50:06','',''),(2163577,'5','184','957',429,'Sale Id shift 243806',0.00,0.00,0.00,1302.78,0.00,'2021-12-05 07:50:06','',''),(2163578,'5','184','959',430,'Sale Id shift 243806',0.00,0.00,0.00,440.52,0.00,'2021-12-05 07:50:06','',''),(2163579,'5','184',NULL,429,'Sale Id shift 243806',2243613.90,0.00,0.00,0.00,0.00,'2021-12-05 07:50:06','',''),(2163580,'5','184',NULL,430,'Sale Id shift 243806',151979.40,0.00,0.00,0.00,0.00,'2021-12-05 07:50:06','',''),(2163583,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2021-12-05 07:50:23','',''),(2174355,'5','184',NULL,429,'Reception corrector for bridging 126325',0.00,0.00,0.00,40000.00,0.00,'2021-12-05 19:26:37','',''),(2174356,'5','184','958',429,'Received from bridging 126325',0.00,0.00,40000.00,0.00,0.00,'2021-12-05 19:26:37','',''),(2174358,'5','184','958',429,'Sale Id shift 243963',0.00,0.00,0.00,537.33,0.00,'2021-12-05 19:27:13','',''),(2174359,'5','184','958',429,'Sale Id shift 243963',0.00,0.00,0.00,315.91,0.00,'2021-12-05 19:27:13','',''),(2174360,'5','184','957',429,'Sale Id shift 243963',0.00,0.00,0.00,4057.97,0.00,'2021-12-05 19:27:13','',''),(2174361,'5','184','957',429,'Sale Id shift 243963',0.00,0.00,0.00,3164.37,0.00,'2021-12-05 19:27:13','',''),(2174362,'5','184','957',429,'Sale Id shift 243963',0.00,0.00,0.00,3249.14,0.00,'2021-12-05 19:27:13','',''),(2174363,'5','184','957',429,'Sale Id shift 243963',0.00,0.00,0.00,1449.15,0.00,'2021-12-05 19:27:13','',''),(2174364,'5','184','959',430,'Sale Id shift 243963',0.00,0.00,0.00,392.46,0.00,'2021-12-05 19:27:13','',''),(2174365,'5','184',NULL,429,'Sale Id shift 243963',2107688.55,0.00,0.00,0.00,0.00,'2021-12-05 19:27:13','',''),(2174366,'5','184',NULL,430,'Sale Id shift 243963',135398.70,0.00,0.00,0.00,0.00,'2021-12-05 19:27:13','',''),(2186456,'5','184','958',429,'Sale Id shift 244156',0.00,0.00,0.00,3962.12,0.00,'2021-12-06 18:15:24','',''),(2186457,'5','184','958',429,'Sale Id shift 244156',0.00,0.00,0.00,5233.51,0.00,'2021-12-06 18:15:24','',''),(2186458,'5','184','958',429,'Sale Id shift 244156',0.00,0.00,0.00,4418.44,0.00,'2021-12-06 18:15:24','',''),(2186459,'5','184','957',429,'Sale Id shift 244156',0.00,0.00,0.00,3.91,0.00,'2021-12-06 18:15:24','',''),(2186460,'5','184','959',430,'Sale Id shift 244156',0.00,0.00,0.00,462.47,0.00,'2021-12-06 18:15:24','',''),(2186461,'5','184',NULL,429,'Sale Id shift 244156',2246966.70,0.00,0.00,0.00,0.00,'2021-12-06 18:15:24','',''),(2186462,'5','184',NULL,430,'Sale Id shift 244156',159552.15,0.00,0.00,0.00,0.00,'2021-12-06 18:15:24','',''),(2189310,'5','184','958',429,'Sale Id shift 244287',0.00,0.00,0.00,5098.15,0.00,'2021-12-07 08:09:34','',''),(2189311,'5','184','958',429,'Sale Id shift 244287',0.00,0.00,0.00,3837.11,0.00,'2021-12-07 08:09:34','',''),(2189312,'5','184','958',429,'Sale Id shift 244287',0.00,0.00,0.00,5688.18,0.00,'2021-12-07 08:09:34','',''),(2189313,'5','184','958',429,'Sale Id shift 244287',0.00,0.00,0.00,4180.64,0.00,'2021-12-07 08:09:34','',''),(2189314,'5','184','959',430,'Sale Id shift 244287',0.00,0.00,0.00,421.82,0.00,'2021-12-07 08:09:34','',''),(2189315,'5','184',NULL,429,'Sale Id shift 244287',3102673.20,0.00,0.00,0.00,0.00,'2021-12-07 08:09:34','',''),(2189316,'5','184',NULL,430,'Sale Id shift 244287',145527.90,0.00,0.00,0.00,0.00,'2021-12-07 08:09:34','',''),(2210894,'5','184','958',429,'Sale Id shift 244575',0.00,0.00,0.00,1802.41,0.00,'2021-12-08 17:47:44','',''),(2210895,'5','184','958',429,'Sale Id shift 244575',0.00,0.00,0.00,2093.19,0.00,'2021-12-08 17:47:44','',''),(2210896,'5','184','958',429,'Sale Id shift 244575',0.00,0.00,0.00,1314.52,0.00,'2021-12-08 17:47:44','',''),(2210897,'5','184','959',430,'Sale Id shift 244575',0.00,0.00,0.00,682.85,0.00,'2021-12-08 17:47:44','',''),(2210898,'5','184',NULL,429,'Sale Id shift 244575',859669.80,0.00,0.00,0.00,0.00,'2021-12-08 17:47:44','',''),(2210899,'5','184',NULL,430,'Sale Id shift 244575',235583.25,0.00,0.00,0.00,0.00,'2021-12-08 17:47:44','',''),(2239154,'5','184','958',429,'Sale Id shift 244823',0.00,0.00,0.00,383.99,0.00,'2021-12-11 06:56:36','',''),(2239155,'5','184','958',429,'Sale Id shift 244823',0.00,0.00,0.00,388.70,0.00,'2021-12-11 06:56:36','',''),(2239156,'5','184','958',429,'Sale Id shift 244823',0.00,0.00,0.00,315.05,0.00,'2021-12-11 06:56:36','',''),(2239157,'5','184','959',430,'Sale Id shift 244823',0.00,0.00,0.00,2524.50,0.00,'2021-12-11 06:56:36','',''),(2239158,'5','184',NULL,429,'Sale Id shift 244823',179477.10,0.00,0.00,0.00,0.00,'2021-12-11 06:56:36','',''),(2239159,'5','184',NULL,430,'Sale Id shift 244823',870952.50,0.00,0.00,0.00,0.00,'2021-12-11 06:56:36','',''),(2269501,'5','184','958',429,'Sale Id shift 245513',0.00,0.00,0.00,311.59,0.00,'2021-12-13 10:35:56','',''),(2269502,'5','184','959',430,'Sale Id shift 245513',0.00,0.00,0.00,483.94,0.00,'2021-12-13 10:35:56','',''),(2269503,'5','184',NULL,429,'Sale Id shift 245513',51412.35,0.00,0.00,0.00,0.00,'2021-12-13 10:35:56','',''),(2269504,'5','184',NULL,430,'Sale Id shift 245513',166959.30,0.00,0.00,0.00,0.00,'2021-12-13 10:35:56','',''),(2279665,'5','184','958',429,'Sale Id shift 245783',0.00,0.00,0.00,54.38,0.00,'2021-12-14 08:51:18','',''),(2279666,'5','184','959',430,'Sale Id shift 245783',0.00,0.00,0.00,643.21,0.00,'2021-12-14 08:51:18','',''),(2279667,'5','184',NULL,429,'Sale Id shift 245783',8972.70,0.00,0.00,0.00,0.00,'2021-12-14 08:51:18','',''),(2279668,'5','184',NULL,430,'Sale Id shift 245783',221907.45,0.00,0.00,0.00,0.00,'2021-12-14 08:51:18','',''),(2288763,'5','184','959',430,'Sale Id shift 246114',0.00,0.00,0.00,506.29,0.00,'2021-12-15 11:31:09','',''),(2288764,'5','184',NULL,430,'Sale Id shift 246114',174670.05,0.00,0.00,0.00,0.00,'2021-12-15 11:31:09','',''),(2290100,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4933500.00,29900.00,0.00,0.00,'2021-12-15 14:09:18','',''),(2294506,'5','184','959',430,'Sale Id shift 246451',0.00,0.00,0.00,853.66,0.00,'2021-12-16 08:16:11','',''),(2294507,'5','184',NULL,430,'Sale Id shift 246451',294512.70,0.00,0.00,0.00,0.00,'2021-12-16 08:16:11','',''),(2294514,'5','184',NULL,429,'Reception corrector for bridging 127536',0.00,0.00,0.00,29900.00,0.00,'2021-12-16 08:16:34','',''),(2294515,'5','184','957',429,'Received from bridging 127536',0.00,0.00,29900.00,0.00,0.00,'2021-12-16 08:16:34','',''),(2296893,'5','184','957',429,'Sale Id shift 246544',0.00,0.00,0.00,5287.35,0.00,'2021-12-16 12:09:36','',''),(2296894,'5','184','957',429,'Sale Id shift 246544',0.00,0.00,0.00,4464.58,0.00,'2021-12-16 12:09:36','',''),(2296895,'5','184','957',429,'Sale Id shift 246544',0.00,0.00,0.00,4371.41,0.00,'2021-12-16 12:09:36','',''),(2296896,'5','184','957',429,'Sale Id shift 246544',0.00,0.00,0.00,1613.33,0.00,'2021-12-16 12:09:36','',''),(2296897,'5','184','959',430,'Sale Id shift 246544',0.00,0.00,0.00,1087.35,0.00,'2021-12-16 12:09:36','',''),(2296898,'5','184',NULL,429,'Sale Id shift 246544',2596550.55,0.00,0.00,0.00,0.00,'2021-12-16 12:09:36','',''),(2296899,'5','184',NULL,430,'Sale Id shift 246544',375135.75,0.00,0.00,0.00,0.00,'2021-12-16 12:09:36','',''),(2298178,'5','184','957',429,'Sale Id shift 246598',0.00,0.00,0.00,3764.01,0.00,'2021-12-16 14:20:11','',''),(2298179,'5','184','957',429,'Sale Id shift 246598',0.00,0.00,0.00,3343.08,0.00,'2021-12-16 14:20:11','',''),(2298180,'5','184','957',429,'Sale Id shift 246598',0.00,0.00,0.00,3447.82,0.00,'2021-12-16 14:20:11','',''),(2298181,'5','184','957',429,'Sale Id shift 246598',0.00,0.00,0.00,936.98,0.00,'2021-12-16 14:20:11','',''),(2298182,'5','184','959',430,'Sale Id shift 246598',0.00,0.00,0.00,487.70,0.00,'2021-12-16 14:20:11','',''),(2298183,'5','184',NULL,429,'Sale Id shift 246598',1896161.85,0.00,0.00,0.00,0.00,'2021-12-16 14:20:11','',''),(2298184,'5','184',NULL,430,'Sale Id shift 246598',168256.50,0.00,0.00,0.00,0.00,'2021-12-16 14:20:11','',''),(2303496,'5','184','957',429,'Sale Id shift 246622',0.00,0.00,0.00,557.09,0.00,'2021-12-17 09:37:16','',''),(2303497,'5','184','957',429,'Sale Id shift 246622',0.00,0.00,0.00,369.02,0.00,'2021-12-17 09:37:16','',''),(2303498,'5','184','957',429,'Sale Id shift 246622',0.00,0.00,0.00,105.11,0.00,'2021-12-17 09:37:16','',''),(2303499,'5','184','957',429,'Sale Id shift 246622',0.00,0.00,0.00,497.53,0.00,'2021-12-17 09:37:16','',''),(2303500,'5','184','959',430,'Sale Id shift 246622',0.00,0.00,0.00,847.87,0.00,'2021-12-17 09:37:16','',''),(2303501,'5','184',NULL,429,'Sale Id shift 246622',252243.75,0.00,0.00,0.00,0.00,'2021-12-17 09:37:16','',''),(2303502,'5','184',NULL,430,'Sale Id shift 246622',292515.15,0.00,0.00,0.00,0.00,'2021-12-17 09:37:16','',''),(2308858,'5','184','957',429,'Sale Id shift 246798',0.00,0.00,0.00,751.77,0.00,'2021-12-18 04:03:43','',''),(2308859,'5','184','957',429,'Sale Id shift 246798',0.00,0.00,0.00,315.71,0.00,'2021-12-18 04:03:43','',''),(2308860,'5','184','959',430,'Sale Id shift 246798',0.00,0.00,0.00,860.04,0.00,'2021-12-18 04:03:43','',''),(2308861,'5','184',NULL,429,'Sale Id shift 246798',176134.20,0.00,0.00,0.00,0.00,'2021-12-18 04:03:43','',''),(2308862,'5','184',NULL,430,'Sale Id shift 246798',296713.80,0.00,0.00,0.00,0.00,'2021-12-18 04:03:43','',''),(2315879,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2310000.00,14000.00,0.00,0.00,'2021-12-18 15:52:59','',''),(2316013,'5','184',NULL,429,'Reception corrector for bridging 127888',0.00,0.00,0.00,14000.00,0.00,'2021-12-18 16:00:15','',''),(2316014,'5','184','958',429,'Received from bridging 127888',0.00,0.00,14000.00,0.00,0.00,'2021-12-18 16:00:15','',''),(2318881,'5','184','958',429,'Sale Id shift 247105',0.00,0.00,0.00,3183.99,0.00,'2021-12-19 07:52:17','',''),(2318882,'5','184','958',429,'Sale Id shift 247105',0.00,0.00,0.00,2323.04,0.00,'2021-12-19 07:52:17','',''),(2318883,'5','184','958',429,'Sale Id shift 247105',0.00,0.00,0.00,3737.60,0.00,'2021-12-19 07:52:17','',''),(2318884,'5','184','958',429,'Sale Id shift 247105',0.00,0.00,0.00,1419.58,0.00,'2021-12-19 07:52:17','',''),(2318885,'5','184','959',430,'Sale Id shift 247105',0.00,0.00,0.00,764.93,0.00,'2021-12-19 07:52:17','',''),(2318886,'5','184',NULL,429,'Sale Id shift 247105',1759594.65,0.00,0.00,0.00,0.00,'2021-12-19 07:52:17','',''),(2318887,'5','184',NULL,430,'Sale Id shift 247105',263900.85,0.00,0.00,0.00,0.00,'2021-12-19 07:52:17','',''),(2334268,'5','184','958',429,'Sale Id shift 247578',0.00,0.00,0.00,1564.04,0.00,'2021-12-21 07:56:50','',''),(2334269,'5','184','958',429,'Sale Id shift 247578',0.00,0.00,0.00,463.87,0.00,'2021-12-21 07:56:50','',''),(2334270,'5','184',NULL,429,'Sale Id shift 247578',334605.15,0.00,0.00,0.00,0.00,'2021-12-21 07:56:50','',''),(2340332,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2021-12-21 17:47:28','',''),(2340336,'5','184','958',429,'Sale Id shift 247728',0.00,0.00,0.00,354.18,0.00,'2021-12-21 17:47:50','',''),(2340337,'5','184','958',429,'Sale Id shift 247728',0.00,0.00,0.00,780.00,0.00,'2021-12-21 17:47:50','',''),(2340338,'5','184',NULL,429,'Sale Id shift 247728',187139.70,0.00,0.00,0.00,0.00,'2021-12-21 17:47:50','',''),(2345221,'5','184',NULL,429,'Reception corrector for bridging 128340',0.00,0.00,0.00,15000.00,0.00,'2021-12-22 12:06:05','',''),(2345222,'5','184','958',429,'Received from bridging 128340',0.00,0.00,15000.00,0.00,0.00,'2021-12-22 12:06:05','',''),(2353501,'5','184','958',429,'Sale Id shift 248001',0.00,0.00,0.00,3324.99,0.00,'2021-12-23 12:05:55','',''),(2353502,'5','184','958',429,'Sale Id shift 248001',0.00,0.00,0.00,2231.99,0.00,'2021-12-23 12:05:55','',''),(2353503,'5','184','958',429,'Sale Id shift 248001',0.00,0.00,0.00,4081.02,0.00,'2021-12-23 12:05:55','',''),(2353504,'5','184','958',429,'Sale Id shift 248001',0.00,0.00,0.00,2679.13,0.00,'2021-12-23 12:05:55','',''),(2353505,'5','184',NULL,429,'Sale Id shift 248001',2032326.45,0.00,0.00,0.00,0.00,'2021-12-23 12:05:55','',''),(2359690,'5','184','958',429,'Sale Id shift 248443',0.00,0.00,0.00,1005.32,0.00,'2021-12-24 08:11:03','',''),(2359691,'5','184','958',429,'Sale Id shift 248443',0.00,0.00,0.00,638.87,0.00,'2021-12-24 08:11:03','',''),(2359692,'5','184',NULL,429,'Sale Id shift 248443',271291.35,0.00,0.00,0.00,0.00,'2021-12-24 08:11:03','',''),(2364453,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4999500.00,30300.00,0.00,0.00,'2021-12-24 14:34:25','',''),(2369448,'5','184','958',429,'Sale Id shift 248519',0.00,0.00,0.00,1097.42,0.00,'2021-12-25 08:26:22','',''),(2369449,'5','184',NULL,429,'Sale Id shift 248519',181074.30,0.00,0.00,0.00,0.00,'2021-12-25 08:26:22','',''),(2369464,'5','184',NULL,429,'Reception corrector for bridging 128691',0.00,0.00,0.00,30300.00,0.00,'2021-12-25 08:27:45','',''),(2369465,'5','184','958',429,'Received from bridging 128691',0.00,0.00,30300.00,0.00,0.00,'2021-12-25 08:27:45','',''),(2375110,'5','184','958',429,'Sale Id shift 248740',0.00,0.00,0.00,2376.03,0.00,'2021-12-26 07:16:13','',''),(2375111,'5','184','958',429,'Sale Id shift 248740',0.00,0.00,0.00,3562.56,0.00,'2021-12-26 07:16:13','',''),(2375112,'5','184','958',429,'Sale Id shift 248740',0.00,0.00,0.00,1335.32,0.00,'2021-12-26 07:16:13','',''),(2375113,'5','184',NULL,429,'Sale Id shift 248740',1200195.15,0.00,0.00,0.00,0.00,'2021-12-26 07:16:13','',''),(2383873,'5','184','958',429,'Sale Id shift 249201',0.00,0.00,0.00,1386.68,0.00,'2021-12-27 12:18:33','',''),(2383874,'5','184','958',429,'Sale Id shift 249201',0.00,0.00,0.00,2822.38,0.00,'2021-12-27 12:18:33','',''),(2383875,'5','184','958',429,'Sale Id shift 249201',0.00,0.00,0.00,2048.54,0.00,'2021-12-27 12:18:33','',''),(2383876,'5','184',NULL,429,'Sale Id shift 249201',1032504.00,0.00,0.00,0.00,0.00,'2021-12-27 12:18:33','',''),(2392054,'5','184','958',429,'Sale Id shift 249434',0.00,0.00,0.00,2881.93,0.00,'2021-12-28 16:00:31','',''),(2392055,'5','184','958',429,'Sale Id shift 249434',0.00,0.00,0.00,1654.55,0.00,'2021-12-28 16:00:31','',''),(2392056,'5','184','958',429,'Sale Id shift 249434',0.00,0.00,0.00,1876.04,0.00,'2021-12-28 16:00:31','',''),(2392057,'5','184',NULL,429,'Sale Id shift 249434',1058065.80,0.00,0.00,0.00,0.00,'2021-12-28 16:00:31','',''),(2395257,'5','184','958',429,'Sale Id shift 249661',0.00,0.00,0.00,3029.10,0.00,'2021-12-29 09:45:40','',''),(2395258,'5','184','958',429,'Sale Id shift 249661',0.00,0.00,0.00,1519.91,0.00,'2021-12-29 09:45:40','',''),(2395259,'5','184',NULL,429,'Sale Id shift 249661',750586.65,0.00,0.00,0.00,0.00,'2021-12-29 09:45:40','',''),(2396031,'5','184','958',429,'Sale Id shift 249702',0.00,0.00,0.00,1128.43,0.00,'2021-12-29 11:06:07','',''),(2396032,'5','184','958',429,'Sale Id shift 249702',0.00,0.00,0.00,2134.73,0.00,'2021-12-29 11:06:07','',''),(2396033,'5','184',NULL,429,'Sale Id shift 249702',538421.40,0.00,0.00,0.00,0.00,'2021-12-29 11:06:07','',''),(2408859,'5','184','958',429,'Sale Id shift 249716',0.00,0.00,0.00,415.54,0.00,'2021-12-31 08:44:26','',''),(2408860,'5','184','958',429,'Sale Id shift 249716',0.00,0.00,0.00,934.50,0.00,'2021-12-31 08:44:26','',''),(2408861,'5','184','958',429,'Sale Id shift 249716',0.00,0.00,0.00,737.30,0.00,'2021-12-31 08:44:26','',''),(2408862,'5','184',NULL,429,'Sale Id shift 249716',344411.10,0.00,0.00,0.00,0.00,'2021-12-31 08:44:26','',''),(2415750,'5','184','958',429,'Sale Id shift 250184',0.00,0.00,0.00,578.51,0.00,'2022-01-01 08:36:42','',''),(2415751,'5','184',NULL,429,'Sale Id shift 250184',95454.15,0.00,0.00,0.00,0.00,'2022-01-01 08:36:42','',''),(2419552,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6484500.00,39300.00,0.00,0.00,'2022-01-01 16:02:29','',''),(2419708,'5','184',NULL,429,'Reception corrector for bridging 129437',0.00,0.00,0.00,39300.00,0.00,'2022-01-01 16:19:34','',''),(2419709,'5','184','957',429,'Received from bridging 129437',0.00,0.00,39300.00,0.00,0.00,'2022-01-01 16:19:34','',''),(2422042,'5','184','957',429,'Sale Id shift 250493',0.00,0.00,0.00,3261.20,0.00,'2022-01-02 09:29:44','',''),(2422043,'5','184','957',429,'Sale Id shift 250493',0.00,0.00,0.00,2525.67,0.00,'2022-01-02 09:29:44','',''),(2422044,'5','184','957',429,'Sale Id shift 250493',0.00,0.00,0.00,3090.68,0.00,'2022-01-02 09:29:44','',''),(2422045,'5','184',NULL,429,'Sale Id shift 250493',1464795.75,0.00,0.00,0.00,0.00,'2022-01-02 09:29:44','',''),(2428211,'5','184','957',429,'Sale Id shift 250713',0.00,0.00,0.00,3300.72,0.00,'2022-01-03 10:15:39','',''),(2428212,'5','184','957',429,'Sale Id shift 250713',0.00,0.00,0.00,3344.23,0.00,'2022-01-03 10:15:39','',''),(2428213,'5','184','957',429,'Sale Id shift 250713',0.00,0.00,0.00,2789.49,0.00,'2022-01-03 10:15:39','',''),(2428214,'5','184',NULL,429,'Sale Id shift 250713',1556682.60,0.00,0.00,0.00,0.00,'2022-01-03 10:15:39','',''),(2443031,'5','184','957',429,'Sale Id shift 251130',0.00,0.00,0.00,2581.98,0.00,'2022-01-05 11:36:26','',''),(2443032,'5','184','957',429,'Sale Id shift 251130',0.00,0.00,0.00,2381.61,0.00,'2022-01-05 11:36:26','',''),(2443033,'5','184','957',429,'Sale Id shift 251130',0.00,0.00,0.00,2771.36,0.00,'2022-01-05 11:36:26','',''),(2443034,'5','184','957',429,'Sale Id shift 251130',0.00,0.00,0.00,2882.34,0.00,'2022-01-05 11:36:26','',''),(2443035,'5','184',NULL,429,'Sale Id shift 251130',1751852.85,0.00,0.00,0.00,0.00,'2022-01-05 11:36:26','',''),(2443082,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-01-05 11:38:59','',''),(2446048,'5','184',NULL,429,'Reception corrector for bridging 129819',0.00,0.00,0.00,40000.00,0.00,'2022-01-05 16:23:39','',''),(2446049,'5','184','958',429,'Received from bridging 129819',0.00,0.00,40000.00,0.00,0.00,'2022-01-05 16:23:39','',''),(2451287,'5','184','958',429,'Sale Id shift 251375',0.00,0.00,0.00,1791.79,0.00,'2022-01-06 12:22:34','',''),(2451288,'5','184','958',429,'Sale Id shift 251375',0.00,0.00,0.00,925.62,0.00,'2022-01-06 12:22:34','',''),(2451289,'5','184','958',429,'Sale Id shift 251375',0.00,0.00,0.00,2185.92,0.00,'2022-01-06 12:22:34','',''),(2451290,'5','184','957',429,'Sale Id shift 251375',0.00,0.00,0.00,3056.03,0.00,'2022-01-06 12:22:34','',''),(2451291,'5','184','957',429,'Sale Id shift 251375',0.00,0.00,0.00,2300.11,0.00,'2022-01-06 12:22:34','',''),(2451292,'5','184','957',429,'Sale Id shift 251375',0.00,0.00,0.00,2938.26,0.00,'2022-01-06 12:22:34','',''),(2451293,'5','184','957',429,'Sale Id shift 251375',0.00,0.00,0.00,2507.30,0.00,'2022-01-06 12:22:34','',''),(2451294,'5','184',NULL,429,'Sale Id shift 251375',2591329.95,0.00,0.00,0.00,0.00,'2022-01-06 12:22:34','',''),(2458556,'5','184','958',429,'Sale Id shift 251635',0.00,0.00,0.00,4818.46,0.00,'2022-01-07 11:44:49','',''),(2458557,'5','184','958',429,'Sale Id shift 251635',0.00,0.00,0.00,3002.59,0.00,'2022-01-07 11:44:49','',''),(2458558,'5','184','958',429,'Sale Id shift 251635',0.00,0.00,0.00,4736.79,0.00,'2022-01-07 11:44:49','',''),(2458559,'5','184','958',429,'Sale Id shift 251635',0.00,0.00,0.00,3765.09,0.00,'2022-01-07 11:44:49','',''),(2458560,'5','184',NULL,429,'Sale Id shift 251635',2693283.45,0.00,0.00,0.00,0.00,'2022-01-07 11:44:49','',''),(2460067,'5','184','958',429,'Sale Id shift 251857',0.00,0.00,0.00,3288.19,0.00,'2022-01-07 14:55:05','',''),(2460068,'5','184','958',429,'Sale Id shift 251857',0.00,0.00,0.00,2859.41,0.00,'2022-01-07 14:55:05','',''),(2460069,'5','184','958',429,'Sale Id shift 251857',0.00,0.00,0.00,3590.30,0.00,'2022-01-07 14:55:05','',''),(2460070,'5','184','958',429,'Sale Id shift 251857',0.00,0.00,0.00,891.04,0.00,'2022-01-07 14:55:05','',''),(2460071,'5','184',NULL,429,'Sale Id shift 251857',1753775.10,0.00,0.00,0.00,0.00,'2022-01-07 14:55:05','',''),(2466954,'5','184','958',429,'Sale Id shift 252091',0.00,0.00,0.00,1039.26,0.00,'2022-01-08 13:23:27','',''),(2466955,'5','184','958',429,'Sale Id shift 252091',0.00,0.00,0.00,903.82,0.00,'2022-01-08 13:23:27','',''),(2466956,'5','184','958',429,'Sale Id shift 252091',0.00,0.00,0.00,1244.69,0.00,'2022-01-08 13:23:27','',''),(2466957,'5','184','958',429,'Sale Id shift 252091',0.00,0.00,0.00,1015.20,0.00,'2022-01-08 13:23:27','',''),(2466958,'5','184',NULL,429,'Sale Id shift 252091',693490.05,0.00,0.00,0.00,0.00,'2022-01-08 13:23:27','',''),(2480766,'5','184','958',429,'Sale Id shift 252374',0.00,0.00,0.00,799.44,0.00,'2022-01-10 09:41:24','',''),(2480767,'5','184','958',429,'Sale Id shift 252374',0.00,0.00,0.00,276.14,0.00,'2022-01-10 09:41:24','',''),(2480768,'5','184','958',429,'Sale Id shift 252374',0.00,0.00,0.00,942.15,0.00,'2022-01-10 09:41:24','',''),(2480769,'5','184',NULL,429,'Sale Id shift 252374',332925.45,0.00,0.00,0.00,0.00,'2022-01-10 09:41:24','',''),(2486066,'5','184','958',429,'Sale Id shift 252602',0.00,0.00,0.00,625.04,0.00,'2022-01-10 20:36:38','',''),(2486067,'5','184','958',429,'Sale Id shift 252602',0.00,0.00,0.00,644.00,0.00,'2022-01-10 20:36:38','',''),(2486068,'5','184',NULL,429,'Sale Id shift 252602',209391.60,0.00,0.00,0.00,0.00,'2022-01-10 20:36:38','',''),(2489903,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6550500.00,39700.00,0.00,0.00,'2022-01-11 13:36:58','',''),(2489909,'5','184','958',429,'Sale Id shift 252821',0.00,0.00,0.00,357.14,0.00,'2022-01-11 13:37:19','',''),(2489910,'5','184','958',429,'Sale Id shift 252821',0.00,0.00,0.00,654.99,0.00,'2022-01-11 13:37:19','',''),(2489911,'5','184','958',429,'Sale Id shift 252821',0.00,0.00,0.00,2360.53,0.00,'2022-01-11 13:37:19','',''),(2489912,'5','184',NULL,429,'Sale Id shift 252821',556488.90,0.00,0.00,0.00,0.00,'2022-01-11 13:37:19','',''),(2495481,'5','184',NULL,429,'Reception corrector for bridging 130524',0.00,0.00,0.00,39700.00,0.00,'2022-01-12 09:42:20','',''),(2495482,'5','184','958',429,'Received from bridging 130524',0.00,0.00,39700.00,0.00,0.00,'2022-01-12 09:42:20','',''),(2495941,'5','184','958',429,'Sale Id shift 253047',0.00,0.00,0.00,4254.95,0.00,'2022-01-12 10:17:19','',''),(2495942,'5','184','958',429,'Sale Id shift 253047',0.00,0.00,0.00,1453.22,0.00,'2022-01-12 10:17:19','',''),(2495943,'5','184','958',429,'Sale Id shift 253047',0.00,0.00,0.00,3740.61,0.00,'2022-01-12 10:17:19','',''),(2495944,'5','184','958',429,'Sale Id shift 253047',0.00,0.00,0.00,1648.41,0.00,'2022-01-12 10:17:19','',''),(2495945,'5','184',NULL,429,'Sale Id shift 253047',1831036.35,0.00,0.00,0.00,0.00,'2022-01-12 10:17:19','',''),(2502747,'5','184','958',429,'Sale Id shift 253184',0.00,0.00,0.00,3346.80,0.00,'2022-01-13 09:13:03','',''),(2502748,'5','184','958',429,'Sale Id shift 253184',0.00,0.00,0.00,1847.87,0.00,'2022-01-13 09:13:03','',''),(2502749,'5','184','958',429,'Sale Id shift 253184',0.00,0.00,0.00,3099.05,0.00,'2022-01-13 09:13:03','',''),(2502750,'5','184','958',429,'Sale Id shift 253184',0.00,0.00,0.00,2759.95,0.00,'2022-01-13 09:13:03','',''),(2502751,'5','184',NULL,429,'Sale Id shift 253184',1823855.55,0.00,0.00,0.00,0.00,'2022-01-13 09:13:03','',''),(2516466,'5','184','958',429,'Sale Id shift 253380',0.00,0.00,0.00,2407.27,0.00,'2022-01-14 22:09:20','',''),(2516467,'5','184','958',429,'Sale Id shift 253380',0.00,0.00,0.00,3002.64,0.00,'2022-01-14 22:09:20','',''),(2516468,'5','184','958',429,'Sale Id shift 253380',0.00,0.00,0.00,2055.06,0.00,'2022-01-14 22:09:20','',''),(2516469,'5','184',NULL,429,'Sale Id shift 253380',1231720.05,0.00,0.00,0.00,0.00,'2022-01-14 22:09:20','',''),(2532189,'5','184','958',429,'Sale Id shift 254104',0.00,0.00,0.00,968.49,0.00,'2022-01-16 16:50:12','',''),(2532190,'5','184','958',429,'Sale Id shift 254104',0.00,0.00,0.00,1282.75,0.00,'2022-01-16 16:50:12','',''),(2532191,'5','184','958',429,'Sale Id shift 254104',0.00,0.00,0.00,1356.57,0.00,'2022-01-16 16:50:12','',''),(2532192,'5','184','958',429,'Sale Id shift 254104',0.00,0.00,0.00,1062.65,0.00,'2022-01-16 16:50:12','',''),(2532193,'5','184',NULL,429,'Sale Id shift 254104',770625.90,0.00,0.00,0.00,0.00,'2022-01-16 16:50:12','',''),(2532196,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2813250.00,17050.00,0.00,0.00,'2022-01-16 16:50:29','',''),(2532428,'5','184','958',429,'Sale Id shift 254120',0.00,0.00,0.00,376.04,0.00,'2022-01-16 17:08:39','',''),(2532429,'5','184','958',429,'Sale Id shift 254120',0.00,0.00,0.00,1070.91,0.00,'2022-01-16 17:08:39','',''),(2532430,'5','184','958',429,'Sale Id shift 254120',0.00,0.00,0.00,939.17,0.00,'2022-01-16 17:08:39','',''),(2532431,'5','184',NULL,429,'Sale Id shift 254120',393709.80,0.00,0.00,0.00,0.00,'2022-01-16 17:08:39','',''),(2535041,'5','184',NULL,429,'Reception corrector for bridging 131142',0.00,0.00,0.00,17050.00,0.00,'2022-01-17 09:11:53','',''),(2535042,'5','184','958',429,'Received from bridging 131142',0.00,0.00,17050.00,0.00,0.00,'2022-01-17 09:11:53','',''),(2537455,'5','184','958',429,'Sale Id shift 254129',0.00,0.00,0.00,1509.93,0.00,'2022-01-17 13:55:55','',''),(2537456,'5','184','958',429,'Sale Id shift 254129',0.00,0.00,0.00,1919.81,0.00,'2022-01-17 13:55:55','',''),(2537457,'5','184','958',429,'Sale Id shift 254129',0.00,0.00,0.00,2165.41,0.00,'2022-01-17 13:55:55','',''),(2537458,'5','184','958',429,'Sale Id shift 254129',0.00,0.00,0.00,1916.65,0.00,'2022-01-17 13:55:55','',''),(2537459,'5','184',NULL,429,'Sale Id shift 254129',1239447.00,0.00,0.00,0.00,0.00,'2022-01-17 13:55:55','',''),(2544305,'5','184','958',429,'Sale Id shift 254399',0.00,0.00,0.00,1599.72,0.00,'2022-01-18 13:24:29','',''),(2544306,'5','184','958',429,'Sale Id shift 254399',0.00,0.00,0.00,633.21,0.00,'2022-01-18 13:24:29','',''),(2544307,'5','184','958',429,'Sale Id shift 254399',0.00,0.00,0.00,1553.71,0.00,'2022-01-18 13:24:29','',''),(2544308,'5','184','958',429,'Sale Id shift 254399',0.00,0.00,0.00,1181.50,0.00,'2022-01-18 13:24:29','',''),(2544309,'5','184',NULL,429,'Sale Id shift 254399',819743.10,0.00,0.00,0.00,0.00,'2022-01-18 13:24:29','',''),(2550031,'5','184','958',429,'Sale Id shift 254698',0.00,0.00,0.00,659.56,0.00,'2022-01-19 09:47:53','',''),(2550032,'5','184','958',429,'Sale Id shift 254698',0.00,0.00,0.00,1212.24,0.00,'2022-01-19 09:47:53','',''),(2550033,'5','184','958',429,'Sale Id shift 254698',0.00,0.00,0.00,1268.62,0.00,'2022-01-19 09:47:53','',''),(2550034,'5','184',NULL,429,'Sale Id shift 254698',518169.30,0.00,0.00,0.00,0.00,'2022-01-19 09:47:53','',''),(2560046,'5','184','958',429,'Sale Id shift 254808',0.00,0.00,0.00,809.61,0.00,'2022-01-20 13:21:14','',''),(2560047,'5','184','958',429,'Sale Id shift 254808',0.00,0.00,0.00,269.16,0.00,'2022-01-20 13:21:14','',''),(2560048,'5','184',NULL,429,'Sale Id shift 254808',177997.05,0.00,0.00,0.00,0.00,'2022-01-20 13:21:14','',''),(2587991,'5','184','958',429,'Sale Id shift 255807',0.00,0.00,0.00,223.07,0.00,'2022-01-23 16:29:27','',''),(2587992,'5','184','958',429,'Sale Id shift 255807',0.00,0.00,0.00,1500.00,0.00,'2022-01-23 16:29:27','',''),(2587993,'5','184',NULL,429,'Sale Id shift 255807',284306.55,0.00,0.00,0.00,0.00,'2022-01-23 16:29:27','',''),(2587995,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7837500.00,47500.00,0.00,0.00,'2022-01-23 16:29:47','',''),(2591182,'5','184',NULL,429,'Reception corrector for bridging 131922',0.00,0.00,0.00,47500.00,0.00,'2022-01-24 09:36:56','',''),(2591183,'5','184','958',429,'Received from bridging 131922',0.00,0.00,47500.00,0.00,0.00,'2022-01-24 09:36:56','',''),(2598161,'5','184','958',429,'Sale Id shift 255938',0.00,0.00,0.00,3609.23,0.00,'2022-01-25 09:12:05','',''),(2598162,'5','184','958',429,'Sale Id shift 255938',0.00,0.00,0.00,2079.79,0.00,'2022-01-25 09:12:05','',''),(2598163,'5','184','958',429,'Sale Id shift 255938',0.00,0.00,0.00,1827.48,0.00,'2022-01-25 09:12:05','',''),(2598164,'5','184','958',429,'Sale Id shift 255938',0.00,0.00,0.00,3248.06,0.00,'2022-01-25 09:12:05','',''),(2598165,'5','184',NULL,429,'Sale Id shift 255938',1776152.40,0.00,0.00,0.00,0.00,'2022-01-25 09:12:05','',''),(2606731,'5','184','958',429,'Sale Id shift 256270',0.00,0.00,0.00,2825.23,0.00,'2022-01-26 09:05:14','',''),(2606732,'5','184','958',429,'Sale Id shift 256270',0.00,0.00,0.00,1995.67,0.00,'2022-01-26 09:05:14','',''),(2606733,'5','184','958',429,'Sale Id shift 256270',0.00,0.00,0.00,3654.37,0.00,'2022-01-26 09:05:14','',''),(2606734,'5','184','958',429,'Sale Id shift 256270',0.00,0.00,0.00,2794.29,0.00,'2022-01-26 09:05:14','',''),(2606735,'5','184',NULL,429,'Sale Id shift 256270',1859477.40,0.00,0.00,0.00,0.00,'2022-01-26 09:05:14','',''),(2612728,'5','184',NULL,431,'Balance from closing inventory values 2021-11-31 23:59:59',7121198.57,6435000.00,39000.00,43471.25,0.00,'2021-11-30 23:59:59','',''),(2612935,'5','184',NULL,429,'Balance from closing inventory values 2021-11-31 23:59:59',115968738.91,121056100.00,1137220.00,1106423.85,0.00,'2021-11-30 23:59:59','',''),(2612946,'5','184',NULL,430,'Balance from closing inventory values 2021-11-31 23:59:59',16426858.15,21050500.00,97450.00,82630.78,0.00,'2021-11-30 23:59:59','',''),(2613255,'5','184','959',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,38937.24,23903.92,0.00,'2021-11-30 23:59:59','',''),(2613310,'5','184','957',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,87807.67,83904.66,0.00,'2021-11-30 23:59:59','',''),(2613380,'5','184','960',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,27505.55,26013.46,0.00,'2021-11-30 23:59:59','',''),(2613959,'5','184','958',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,340487.29,313211.07,0.00,'2021-11-30 23:59:59','',''),(2615990,'5','184','958',429,'Sale Id shift 256665',0.00,0.00,0.00,1822.27,0.00,'2022-01-27 10:05:23','',''),(2615991,'5','184','958',429,'Sale Id shift 256665',0.00,0.00,0.00,1381.04,0.00,'2022-01-27 10:05:23','',''),(2615992,'5','184','958',429,'Sale Id shift 256665',0.00,0.00,0.00,2211.10,0.00,'2022-01-27 10:05:23','',''),(2615993,'5','184','958',429,'Sale Id shift 256665',0.00,0.00,0.00,2261.02,0.00,'2022-01-27 10:05:23','',''),(2615994,'5','184',NULL,429,'Sale Id shift 256665',1266445.95,0.00,0.00,0.00,0.00,'2022-01-27 10:05:23','',''),(2625218,'5','184','958',429,'Sale Id shift 256898',0.00,0.00,0.00,2071.99,0.00,'2022-01-28 10:48:49','',''),(2625219,'5','184','958',429,'Sale Id shift 256898',0.00,0.00,0.00,1649.23,0.00,'2022-01-28 10:48:49','',''),(2625220,'5','184','958',429,'Sale Id shift 256898',0.00,0.00,0.00,2298.37,0.00,'2022-01-28 10:48:49','',''),(2625221,'5','184','958',429,'Sale Id shift 256898',0.00,0.00,0.00,1573.29,0.00,'2022-01-28 10:48:49','',''),(2625222,'5','184',NULL,429,'Sale Id shift 256898',1252825.20,0.00,0.00,0.00,0.00,'2022-01-28 10:48:49','',''),(2627637,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,38445.00,233.00,0.00,0.00,'2022-01-28 14:49:58','',''),(2627650,'5','184',NULL,429,'Reception corrector for bridging 132399',0.00,0.00,0.00,233.00,0.00,'2022-01-28 14:50:56','',''),(2627651,'5','184','957',429,'Received from bridging 132399',0.00,0.00,233.00,0.00,0.00,'2022-01-28 14:50:56','',''),(2628041,'5','184','958',429,'Sale Id shift 257101',0.00,0.00,0.00,1343.77,0.00,'2022-01-28 15:18:12','',''),(2628042,'5','184','958',429,'Sale Id shift 257101',0.00,0.00,0.00,1078.48,0.00,'2022-01-28 15:18:12','',''),(2628043,'5','184','958',429,'Sale Id shift 257101',0.00,0.00,0.00,1290.64,0.00,'2022-01-28 15:18:12','',''),(2628044,'5','184','958',429,'Sale Id shift 257101',0.00,0.00,0.00,1114.53,0.00,'2022-01-28 15:18:12','',''),(2628045,'5','184',NULL,429,'Sale Id shift 257101',796524.30,0.00,0.00,0.00,0.00,'2022-01-28 15:18:12','',''),(2628046,'5','184','958',429,'Sale Id shift 257102',0.00,0.00,0.00,1133.11,0.00,'2022-02-01 10:59:46','',''),(2628047,'5','184','958',429,'Sale Id shift 257102',0.00,0.00,0.00,874.24,0.00,'2022-02-01 10:59:46','',''),(2628048,'5','184',NULL,429,'Sale Id shift 257102',331212.75,0.00,0.00,0.00,0.00,'2022-02-01 10:59:46','',''),(2628049,'5','184','958',429,'Sale Id shift 257103',0.00,0.00,0.00,1382.50,0.00,'2022-02-01 11:05:10','',''),(2628050,'5','184','958',429,'Sale Id shift 257103',0.00,0.00,0.00,200.00,0.00,'2022-02-01 11:05:10','',''),(2628051,'5','184',NULL,429,'Sale Id shift 257103',261112.50,0.00,0.00,0.00,0.00,'2022-02-01 11:05:10','',''),(2628052,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6534000.00,39600.00,0.00,0.00,'2022-02-01 11:09:31','',''),(2628053,'5','184',NULL,429,'Reception corrector for bridging 132400',0.00,0.00,0.00,39600.00,0.00,'2022-02-01 11:14:46','',''),(2628054,'5','184','957',429,'Received from bridging 132400',0.00,0.00,39600.00,0.00,0.00,'2022-02-01 11:14:46','',''),(2628055,'5','184','957',429,'Sale Id shift 257104',0.00,0.00,0.00,3371.63,0.00,'2022-02-01 11:29:28','',''),(2628056,'5','184','957',429,'Sale Id shift 257104',0.00,0.00,0.00,2862.95,0.00,'2022-02-01 11:29:28','',''),(2628057,'5','184','957',429,'Sale Id shift 257104',0.00,0.00,0.00,2734.43,0.00,'2022-02-01 11:29:28','',''),(2628058,'5','184',NULL,429,'Sale Id shift 257104',1479886.65,0.00,0.00,0.00,0.00,'2022-02-01 11:29:28','',''),(2628059,'5','184','957',429,'Sale Id shift 257105',0.00,0.00,0.00,3242.81,0.00,'2022-02-01 14:55:15','',''),(2628060,'5','184','957',429,'Sale Id shift 257105',0.00,0.00,0.00,3236.30,0.00,'2022-02-01 14:55:15','',''),(2628061,'5','184','957',429,'Sale Id shift 257105',0.00,0.00,0.00,2766.00,0.00,'2022-02-01 14:55:15','',''),(2628062,'5','184','957',429,'Sale Id shift 257105',0.00,0.00,0.00,1297.46,0.00,'2022-02-01 14:55:15','',''),(2628063,'5','184',NULL,429,'Sale Id shift 257105',1739524.05,0.00,0.00,0.00,0.00,'2022-02-01 14:55:15','',''),(2628064,'5','184','957',429,'Sale Id shift 257106',0.00,0.00,0.00,2832.21,0.00,'2022-02-01 19:28:41','',''),(2628065,'5','184','957',429,'Sale Id shift 257106',0.00,0.00,0.00,2804.12,0.00,'2022-02-01 19:28:41','',''),(2628066,'5','184','957',429,'Sale Id shift 257106',0.00,0.00,0.00,2834.95,0.00,'2022-02-01 19:28:41','',''),(2628067,'5','184','957',429,'Sale Id shift 257106',0.00,0.00,0.00,1616.44,0.00,'2022-02-01 19:28:41','',''),(2628068,'5','184',NULL,429,'Sale Id shift 257106',1664473.80,0.00,0.00,0.00,0.00,'2022-02-01 19:28:41','',''),(2628069,'5','184','957',429,'Sale Id shift 257107',0.00,0.00,0.00,1797.35,0.00,'2022-02-03 14:00:23','',''),(2628070,'5','184','957',429,'Sale Id shift 257107',0.00,0.00,0.00,1408.75,0.00,'2022-02-03 14:00:23','',''),(2628071,'5','184','957',429,'Sale Id shift 257107',0.00,0.00,0.00,1115.92,0.00,'2022-02-03 14:00:23','',''),(2628072,'5','184','957',429,'Sale Id shift 257107',0.00,0.00,0.00,962.91,0.00,'2022-02-03 14:00:23','',''),(2628073,'5','184',NULL,429,'Sale Id shift 257107',872013.45,0.00,0.00,0.00,0.00,'2022-02-03 14:00:23','',''),(2628074,'5','184','957',429,'Sale Id shift 257108',0.00,0.00,0.00,1381.09,0.00,'2022-02-04 09:25:54','',''),(2628075,'5','184','957',429,'Sale Id shift 257108',0.00,0.00,0.00,1206.36,0.00,'2022-02-04 09:25:54','',''),(2628076,'5','184',NULL,429,'Sale Id shift 257108',426929.25,0.00,0.00,0.00,0.00,'2022-02-04 09:25:54','',''),(2628077,'5','184','957',429,'Sale Id shift 257109',0.00,0.00,0.00,845.28,0.00,'2022-02-06 05:24:50','',''),(2628078,'5','184','957',429,'Sale Id shift 257109',0.00,0.00,0.00,241.78,0.00,'2022-02-06 05:24:50','',''),(2628079,'5','184',NULL,429,'Sale Id shift 257109',179364.90,0.00,0.00,0.00,0.00,'2022-02-06 05:24:50','',''),(2628080,'5','184','958',429,'Sale Id shift 257110',0.00,0.00,0.00,679.03,0.00,'2022-02-06 15:11:43','',''),(2628081,'5','184','958',429,'Sale Id shift 257110',0.00,0.00,0.00,507.83,0.00,'2022-02-06 15:11:43','',''),(2628082,'5','184','957',429,'Sale Id shift 257110',0.00,0.00,0.00,739.24,0.00,'2022-02-06 15:11:43','',''),(2628083,'5','184','957',429,'Sale Id shift 257110',0.00,0.00,0.00,164.68,0.00,'2022-02-06 15:11:43','',''),(2628084,'5','184',NULL,429,'Sale Id shift 257110',344978.70,0.00,0.00,0.00,0.00,'2022-02-06 15:11:43','',''),(2628085,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-06 16:30:44','',''),(2628086,'5','184',NULL,429,'Reception corrector for bridging 132401',0.00,0.00,0.00,40000.00,0.00,'2022-02-06 19:35:35','',''),(2628087,'5','184','958',429,'Received from bridging 132401',0.00,0.00,40000.00,0.00,0.00,'2022-02-06 19:35:35','',''),(2628088,'5','184','958',429,'Sale Id shift 257111',0.00,0.00,0.00,2992.01,0.00,'2022-02-07 11:26:23','',''),(2628089,'5','184','958',429,'Sale Id shift 257111',0.00,0.00,0.00,3120.18,0.00,'2022-02-07 11:26:23','',''),(2628090,'5','184','958',429,'Sale Id shift 257111',0.00,0.00,0.00,2750.74,0.00,'2022-02-07 11:26:23','',''),(2628091,'5','184',NULL,429,'Sale Id shift 257111',1462383.45,0.00,0.00,0.00,0.00,'2022-02-07 11:26:23','',''),(2628092,'5','184','958',429,'Sale Id shift 257112',0.00,0.00,0.00,2631.15,0.00,'2022-02-08 12:28:14','',''),(2628093,'5','184','958',429,'Sale Id shift 257112',0.00,0.00,0.00,1235.55,0.00,'2022-02-08 12:28:14','',''),(2628094,'5','184','958',429,'Sale Id shift 257112',0.00,0.00,0.00,2896.39,0.00,'2022-02-08 12:28:14','',''),(2628095,'5','184','958',429,'Sale Id shift 257112',0.00,0.00,0.00,3582.94,0.00,'2022-02-08 12:28:14','',''),(2628096,'5','184',NULL,429,'Sale Id shift 257112',1707094.95,0.00,0.00,0.00,0.00,'2022-02-08 12:28:14','',''),(2628097,'5','184','958',429,'Sale Id shift 257113',0.00,0.00,0.00,1859.95,0.00,'2022-02-09 10:57:48','',''),(2628098,'5','184','958',429,'Sale Id shift 257113',0.00,0.00,0.00,1671.24,0.00,'2022-02-09 10:57:48','',''),(2628099,'5','184','958',429,'Sale Id shift 257113',0.00,0.00,0.00,2606.50,0.00,'2022-02-09 10:57:48','',''),(2628100,'5','184','958',429,'Sale Id shift 257113',0.00,0.00,0.00,2066.23,0.00,'2022-02-09 10:57:48','',''),(2628101,'5','184',NULL,429,'Sale Id shift 257113',1353646.80,0.00,0.00,0.00,0.00,'2022-02-09 10:57:48','',''),(2628102,'5','184','958',429,'Sale Id shift 257114',0.00,0.00,0.00,1117.39,0.00,'2022-02-10 12:41:02','',''),(2628103,'5','184','958',429,'Sale Id shift 257114',0.00,0.00,0.00,920.22,0.00,'2022-02-10 12:41:02','',''),(2628104,'5','184','958',429,'Sale Id shift 257114',0.00,0.00,0.00,1169.78,0.00,'2022-02-10 12:41:02','',''),(2628105,'5','184','958',429,'Sale Id shift 257114',0.00,0.00,0.00,977.97,0.00,'2022-02-10 12:41:02','',''),(2628106,'5','184',NULL,429,'Sale Id shift 257114',690584.40,0.00,0.00,0.00,0.00,'2022-02-10 12:41:02','',''),(2628107,'5','184','958',429,'Sale Id shift 257115',0.00,0.00,0.00,1462.63,0.00,'2022-02-11 09:43:47','',''),(2628108,'5','184','958',429,'Sale Id shift 257115',0.00,0.00,0.00,863.11,0.00,'2022-02-11 09:43:47','',''),(2628109,'5','184','958',429,'Sale Id shift 257115',0.00,0.00,0.00,1005.47,0.00,'2022-02-11 09:43:47','',''),(2628110,'5','184','958',429,'Sale Id shift 257115',0.00,0.00,0.00,937.40,0.00,'2022-02-11 09:43:47','',''),(2628111,'5','184',NULL,429,'Sale Id shift 257115',704320.65,0.00,0.00,0.00,0.00,'2022-02-11 09:43:47','',''),(2628112,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,57420.00,348.00,0.00,0.00,'2022-02-11 12:32:38','',''),(2628113,'5','184','958',429,'Sale Id shift 257116',0.00,0.00,0.00,1602.29,0.00,'2022-02-12 15:39:33','',''),(2628114,'5','184','958',429,'Sale Id shift 257116',0.00,0.00,0.00,443.67,0.00,'2022-02-12 15:39:33','',''),(2628115,'5','184',NULL,429,'Sale Id shift 257116',337583.40,0.00,0.00,0.00,0.00,'2022-02-12 15:39:33','',''),(2628116,'5','184',NULL,429,'Reception corrector for bridging 132402',0.00,0.00,0.00,348.00,0.00,'2022-02-14 08:59:25','',''),(2628117,'5','184','957',429,'Received from bridging 132402',0.00,0.00,348.00,0.00,0.00,'2022-02-14 08:59:25','',''),(2628118,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-02-16 10:09:43','',''),(2628119,'5','184',NULL,429,'Reception corrector for bridging 132403',0.00,0.00,0.00,15000.00,0.00,'2022-02-16 10:33:31','',''),(2628120,'5','184','958',429,'Received from bridging 132403',0.00,0.00,15000.00,0.00,0.00,'2022-02-16 10:33:31','',''),(2628121,'5','184','958',429,'Sale Id shift 257121',0.00,0.00,0.00,1896.18,0.00,'2022-02-17 09:30:49','',''),(2628122,'5','184','958',429,'Sale Id shift 257121',0.00,0.00,0.00,924.10,0.00,'2022-02-17 09:30:49','',''),(2628123,'5','184','958',429,'Sale Id shift 257121',0.00,0.00,0.00,1337.77,0.00,'2022-02-17 09:30:49','',''),(2628124,'5','184','958',429,'Sale Id shift 257121',0.00,0.00,0.00,1412.34,0.00,'2022-02-17 09:30:49','',''),(2628125,'5','184',NULL,429,'Sale Id shift 257121',919114.35,0.00,0.00,0.00,0.00,'2022-02-17 09:30:49','',''),(2628126,'5','184','958',429,'Sale Id shift 257122',0.00,0.00,0.00,1963.55,0.00,'2022-02-18 09:24:24','',''),(2628127,'5','184','958',429,'Sale Id shift 257122',0.00,0.00,0.00,1239.22,0.00,'2022-02-18 09:24:24','',''),(2628128,'5','184',NULL,429,'Sale Id shift 257122',528457.05,0.00,0.00,0.00,0.00,'2022-02-18 09:24:24','',''),(2628129,'5','184','958',429,'Sale Id shift 257123',0.00,0.00,0.00,2127.57,0.00,'2022-02-19 11:49:57','',''),(2628130,'5','184','958',429,'Sale Id shift 257123',0.00,0.00,0.00,1065.53,0.00,'2022-02-19 11:49:57','',''),(2628131,'5','184',NULL,429,'Sale Id shift 257123',526861.50,0.00,0.00,0.00,0.00,'2022-02-19 11:49:57','',''),(2628132,'5','184','958',429,'Sale Id shift 257124',0.00,0.00,0.00,1159.49,0.00,'2022-02-20 14:59:57','',''),(2628133,'5','184','958',429,'Sale Id shift 257124',0.00,0.00,0.00,843.25,0.00,'2022-02-20 14:59:57','',''),(2628134,'5','184',NULL,429,'Sale Id shift 257124',330452.10,0.00,0.00,0.00,0.00,'2022-02-20 14:59:57','',''),(2628135,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-02-21 14:21:33','',''),(2628136,'5','184','958',429,'Sale Id shift 257125',0.00,0.00,0.00,1599.69,0.00,'2022-02-21 14:21:58','',''),(2628137,'5','184','958',429,'Sale Id shift 257125',0.00,0.00,0.00,398.63,0.00,'2022-02-21 14:21:58','',''),(2628138,'5','184',NULL,429,'Sale Id shift 257125',329722.80,0.00,0.00,0.00,0.00,'2022-02-21 14:21:58','',''),(2628139,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-31 13:40:41','',''),(2628140,'5','184',NULL,429,'Reception corrector for bridging 132405',0.00,0.00,0.00,25000.00,0.00,'2022-05-31 13:48:32','',''),(2628141,'5','184','958',429,'Received from bridging 132405',0.00,0.00,25000.00,0.00,0.00,'2022-05-31 13:48:32','',''),(2628142,'5','184',NULL,429,'Reception corrector for bridging 132404',0.00,0.00,0.00,20000.00,0.00,'2022-05-31 13:48:32','',''),(2628143,'5','184','957',429,'Received from bridging 132404',0.00,0.00,20000.00,0.00,0.00,'2022-05-31 13:48:32','',''),(2628144,'5','184','958',429,'Sale Id shift 257127',0.00,0.00,0.00,10575.77,0.00,'2022-05-31 14:04:00','',''),(2628145,'5','184','957',429,'Sale Id shift 257127',0.00,0.00,0.00,10086.21,0.00,'2022-05-31 14:04:00','',''),(2628146,'5','184',NULL,429,'Sale Id shift 257127',3409226.70,0.00,0.00,0.00,0.00,'2022-05-31 14:04:00','',''),(2628147,'5','184','958',429,'Sale Id shift 257128',0.00,0.00,0.00,205.92,0.00,'2022-05-31 14:10:59','',''),(2628148,'5','184','958',429,'Sale Id shift 257128',0.00,0.00,0.00,59.26,0.00,'2022-05-31 14:10:59','',''),(2628149,'5','184','957',429,'Sale Id shift 257128',0.00,0.00,0.00,88.36,0.00,'2022-05-31 14:10:59','',''),(2628150,'5','184',NULL,429,'Sale Id shift 257128',58334.10,0.00,0.00,0.00,0.00,'2022-05-31 14:10:59','',''),(2628151,'5','184',NULL,429,'Reception corrector for bridging 132406',0.00,0.00,0.00,5000.00,0.00,'2022-06-01 12:15:27','',''),(2628152,'5','184','958',429,'Received from bridging 132406',0.00,0.00,5000.00,0.00,0.00,'2022-06-01 12:15:27','',''),(2628153,'5','184','958',429,'Sale Id shift 257129',0.00,0.00,0.00,132.89,0.00,'2022-06-01 12:25:51','',''),(2628154,'5','184',NULL,429,'Sale Id shift 257129',21926.85,0.00,0.00,0.00,0.00,'2022-06-01 12:25:51','',''),(2628155,'5','184',NULL,429,'Reception corrector for bridging 132407',0.00,0.00,0.00,8500.00,0.00,'2022-06-01 13:38:18','',''),(2628156,'5','184','957',429,'Received from bridging 132407',0.00,0.00,8500.00,0.00,0.00,'2022-06-01 13:38:18','',''),(2628157,'5','184',NULL,430,'Purchased from SALBAS OIL & GAS LIMITED',0.00,21000000.00,30000.00,0.00,0.00,'2022-06-01 13:56:44','',''),(2628158,'5','184',NULL,430,'Reception corrector for bridging 132408',0.00,0.00,0.00,30000.00,0.00,'2022-06-01 14:11:53','',''),(2628159,'5','184','959',430,'Received from bridging 132408',0.00,0.00,30000.00,0.00,0.00,'2022-06-01 14:11:53','',''),(2628160,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7408500.00,44900.00,0.00,0.00,'2022-06-01 14:14:13','',''),(2628161,'5','184','959',430,'Sale Id shift 257130',0.00,0.00,0.00,1200.02,0.00,'2022-06-01 14:20:48','',''),(2628162,'5','184',NULL,430,'Sale Id shift 257130',840014.00,0.00,0.00,0.00,0.00,'2022-06-01 14:20:48','',''),(2628163,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7408500.00,44900.00,0.00,0.00,'2022-06-01 14:36:33','',''),(2628164,'5','184','958',429,'Sale Id shift 257131',0.00,0.00,0.00,2000.00,0.00,'2022-06-01 14:55:44','',''),(2628165,'5','184','958',429,'Sale Id shift 257131',0.00,0.00,0.00,700.00,0.00,'2022-06-01 14:55:44','',''),(2628166,'5','184',NULL,429,'Sale Id shift 257131',445500.00,0.00,0.00,0.00,0.00,'2022-06-01 14:55:44','',''),(2628167,'5','184',NULL,430,'Purchased from SALBAS OIL & GAS LIMITED',0.00,18750000.00,25000.00,0.00,0.00,'2022-06-02 11:58:38','',''),(2628168,'5','184',NULL,429,'Reception corrector for bridging 132409',0.00,0.00,0.00,24000.00,0.00,'2022-06-02 12:00:05','',''),(2628169,'5','184','957',429,'Received from bridging 132409',0.00,0.00,24000.00,0.00,0.00,'2022-06-02 12:00:05','',''),(2628170,'5','184',NULL,429,'Reception corrector for bridging 132410',0.00,0.00,0.00,20900.00,0.00,'2022-06-02 12:00:16','',''),(2628171,'5','184','958',429,'Received from bridging 132410',0.00,0.00,20900.00,0.00,0.00,'2022-06-02 12:00:16','',''),(2628172,'5','184',NULL,430,'Reception corrector for bridging 132412',0.00,0.00,0.00,10000.00,0.00,'2022-06-02 12:12:01','',''),(2628173,'5','184','959',430,'Received from bridging 132412',0.00,0.00,10000.00,0.00,0.00,'2022-06-02 12:12:01','',''),(2628174,'5','184','958',429,'Sale Id shift 257132',0.00,0.00,0.00,360.09,0.00,'2022-06-02 14:11:19','',''),(2628175,'5','184','958',429,'Sale Id shift 257132',0.00,0.00,0.00,400.00,0.00,'2022-06-02 14:11:19','',''),(2628176,'5','184','960',431,'Sale Id shift 257132',0.00,0.00,0.00,100.02,0.00,'2022-06-02 14:11:19','',''),(2628177,'5','184',NULL,431,'Sale Id shift 257132',40008.00,0.00,0.00,0.00,0.00,'2022-06-02 14:11:19','',''),(2628178,'5','184',NULL,429,'Sale Id shift 257132',125414.85,0.00,0.00,0.00,0.00,'2022-06-02 14:11:20','',''),(2628179,'5','184','958',429,'Sale Id shift 257134',0.00,0.00,0.00,38.91,0.00,'2022-06-05 09:13:15','',''),(2628180,'5','184','958',429,'Sale Id shift 257134',0.00,0.00,0.00,10.34,0.00,'2022-06-05 09:13:15','',''),(2628181,'5','184',NULL,429,'Sale Id shift 257134',8126.25,0.00,0.00,0.00,0.00,'2022-06-05 09:13:15','',''),(2628182,'5','184','958',429,'Returned bridging 132406',0.00,0.00,0.00,5000.00,0.00,'2022-06-07 11:01:23','',''),(2628183,'5','184',NULL,429,'Reception Return corrector for bridging 132406',0.00,0.00,5000.00,0.00,0.00,'2022-06-07 11:01:23','',''),(2628184,'5','184','958',429,'Returned bridging 132410',0.00,0.00,0.00,20900.00,0.00,'2022-06-07 11:02:48','',''),(2628185,'5','184',NULL,429,'Reception Return corrector for bridging 132410',0.00,0.00,20900.00,0.00,0.00,'2022-06-07 11:02:48','',''),(2628186,'5','184','959',430,'Returned bridging 132408',0.00,0.00,0.00,30000.00,0.00,'2022-06-07 11:04:07','',''),(2628187,'5','184',NULL,430,'Reception Return corrector for bridging 132408',0.00,0.00,30000.00,0.00,0.00,'2022-06-07 11:04:07','',''),(2628188,'5','184','957',429,'Sale Id shift 257135',0.00,0.00,0.00,1311.85,0.00,'2022-06-29 13:59:59','',''),(2628189,'5','184','957',429,'Sale Id shift 257135',0.00,0.00,0.00,1203.93,0.00,'2022-06-29 13:59:59','',''),(2628190,'5','184','957',429,'Sale Id shift 257135',0.00,0.00,0.00,1599.35,0.00,'2022-06-29 13:59:59','',''),(2628191,'5','184',NULL,429,'Sale Id shift 257135',678996.45,0.00,0.00,0.00,0.00,'2022-06-29 13:59:59','',''),(2628192,'5','184','958',429,'Sale Id shift 257137',0.00,0.00,0.00,757.05,0.00,'2022-06-29 14:26:53','',''),(2628193,'5','184','958',429,'Sale Id shift 257137',0.00,0.00,0.00,1130.16,0.00,'2022-06-29 14:26:53','',''),(2628194,'5','184','958',429,'Sale Id shift 257137',0.00,0.00,0.00,978.03,0.00,'2022-06-29 14:26:53','',''),(2628195,'5','184','957',429,'Sale Id shift 257137',0.00,0.00,0.00,939.85,0.00,'2022-06-29 14:26:53','',''),(2628196,'5','184','957',429,'Sale Id shift 257137',0.00,0.00,0.00,766.37,0.00,'2022-06-29 14:26:53','',''),(2628197,'5','184','957',429,'Sale Id shift 257137',0.00,0.00,0.00,1453.67,0.00,'2022-06-29 14:26:53','',''),(2628198,'5','184',NULL,429,'Sale Id shift 257137',994146.45,0.00,0.00,0.00,0.00,'2022-06-29 14:26:53','',''),(2628199,'5','184','958',429,'Sale Id shift 257138',0.00,0.00,0.00,1344.83,0.00,'2022-06-29 14:33:35','',''),(2628200,'5','184','958',429,'Sale Id shift 257138',0.00,0.00,0.00,2922.76,0.00,'2022-06-29 14:33:35','',''),(2628201,'5','184','958',429,'Sale Id shift 257138',0.00,0.00,0.00,1681.16,0.00,'2022-06-29 14:33:35','',''),(2628202,'5','184',NULL,429,'Sale Id shift 257138',981543.75,0.00,0.00,0.00,0.00,'2022-06-29 14:33:35','',''),(2628203,'5','184','958',429,'Sale Id shift 257139',0.00,0.00,0.00,1214.96,0.00,'2022-06-29 14:45:48','',''),(2628204,'5','184','958',429,'Sale Id shift 257139',0.00,0.00,0.00,2083.57,0.00,'2022-06-29 14:45:48','',''),(2628205,'5','184','958',429,'Sale Id shift 257139',0.00,0.00,0.00,1082.29,0.00,'2022-06-29 14:45:48','',''),(2628206,'5','184',NULL,429,'Sale Id shift 257139',722835.30,0.00,0.00,0.00,0.00,'2022-06-29 14:45:48','',''),(2628207,'5','184','958',429,'Sale Id shift 257140',0.00,0.00,0.00,463.52,0.00,'2022-06-29 18:28:42','',''),(2628208,'5','184','958',429,'Sale Id shift 257140',0.00,0.00,0.00,1360.95,0.00,'2022-06-29 18:28:42','',''),(2628209,'5','184','957',429,'Sale Id shift 257140',0.00,0.00,0.00,1463.16,0.00,'2022-06-29 18:28:42','',''),(2628210,'5','184','957',429,'Sale Id shift 257140',0.00,0.00,0.00,1706.49,0.00,'2022-06-29 18:28:42','',''),(2628211,'5','184','957',429,'Sale Id shift 257140',0.00,0.00,0.00,1454.96,0.00,'2022-06-29 18:28:42','',''),(2628212,'5','184',NULL,429,'Sale Id shift 257140',1064098.20,0.00,0.00,0.00,0.00,'2022-06-29 18:28:42','',''),(2628213,'5','184','957',429,'Sale Id shift 257141',0.00,0.00,0.00,956.22,0.00,'2022-06-29 19:21:14','',''),(2628214,'5','184','957',429,'Sale Id shift 257141',0.00,0.00,0.00,1661.36,0.00,'2022-06-29 19:21:14','',''),(2628215,'5','184','957',429,'Sale Id shift 257141',0.00,0.00,0.00,1379.60,0.00,'2022-06-29 19:21:14','',''),(2628216,'5','184',NULL,429,'Sale Id shift 257141',659534.70,0.00,0.00,0.00,0.00,'2022-06-29 19:21:14','',''),(2628217,'5','184','957',429,'Sale Id shift 257142',0.00,0.00,0.00,968.85,0.00,'2022-06-30 08:33:24','',''),(2628218,'5','184','957',429,'Sale Id shift 257142',0.00,0.00,0.00,1786.33,0.00,'2022-06-30 08:33:24','',''),(2628219,'5','184','957',429,'Sale Id shift 257142',0.00,0.00,0.00,1325.33,0.00,'2022-06-30 08:33:24','',''),(2628220,'5','184',NULL,429,'Sale Id shift 257142',673284.15,0.00,0.00,0.00,0.00,'2022-06-30 08:33:24','',''),(2628221,'5','184','958',429,'Sale Id shift 257143',0.00,0.00,0.00,878.02,0.00,'2022-06-30 11:31:30','',''),(2628222,'5','184','958',429,'Sale Id shift 257143',0.00,0.00,0.00,1307.11,0.00,'2022-06-30 11:31:30','',''),(2628223,'5','184','957',429,'Sale Id shift 257143',0.00,0.00,0.00,1902.67,0.00,'2022-06-30 11:31:30','',''),(2628224,'5','184',NULL,429,'Sale Id shift 257143',674487.00,0.00,0.00,0.00,0.00,'2022-06-30 11:31:30','',''),(2628225,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,1136.14,0.00,'2022-07-04 09:52:04','',''),(2628226,'5','184','958',0,'Inventory adjustment from tank dipping to 30000',0.00,0.00,30000.00,0.00,0.00,'2022-07-04 09:52:04','',''),(2628227,'5','184','958',429,'Sale Id shift 257146',0.00,0.00,0.00,2101.81,0.00,'2022-07-04 15:14:03','',''),(2628228,'5','184','958',429,'Sale Id shift 257146',0.00,0.00,0.00,1162.98,0.00,'2022-07-04 15:14:03','',''),(2628229,'5','184','958',429,'Sale Id shift 257146',0.00,0.00,0.00,4544.64,0.00,'2022-07-04 15:14:03','',''),(2628230,'5','184',NULL,429,'Sale Id shift 257146',1288555.95,0.00,0.00,0.00,0.00,'2022-07-04 15:14:03','',''),(2628231,'5','184','958',429,'Sale Id shift 257147',0.00,0.00,0.00,750.89,0.00,'2022-07-04 15:32:35','',''),(2628232,'5','184','958',429,'Sale Id shift 257147',0.00,0.00,0.00,662.70,0.00,'2022-07-04 15:32:35','',''),(2628233,'5','184','958',429,'Sale Id shift 257147',0.00,0.00,0.00,2714.46,0.00,'2022-07-04 15:32:35','',''),(2628234,'5','184',NULL,429,'Sale Id shift 257147',681128.25,0.00,0.00,0.00,0.00,'2022-07-04 15:32:35','',''),(2628235,'5','184','958',429,'Sale Id shift 257148',0.00,0.00,0.00,374.41,0.00,'2022-07-04 15:44:23','',''),(2628236,'5','184','958',429,'Sale Id shift 257148',0.00,0.00,0.00,565.76,0.00,'2022-07-04 15:44:23','',''),(2628237,'5','184',NULL,429,'Sale Id shift 257148',155128.05,0.00,0.00,0.00,0.00,'2022-07-04 15:44:23','',''),(2628238,'5','184','957',429,'Sale Id shift 257149',0.00,0.00,0.00,307.49,0.00,'2022-07-04 15:52:52','',''),(2628239,'5','184','957',429,'Sale Id shift 257149',0.00,0.00,0.00,990.95,0.00,'2022-07-04 15:52:52','',''),(2628240,'5','184','957',429,'Sale Id shift 257149',0.00,0.00,0.00,708.05,0.00,'2022-07-04 15:52:52','',''),(2628241,'5','184','957',429,'Sale Id shift 257149',0.00,0.00,0.00,683.75,0.00,'2022-07-04 15:52:52','',''),(2628242,'5','184',NULL,429,'Sale Id shift 257149',443889.60,0.00,0.00,0.00,0.00,'2022-07-04 15:52:52','',''),(2628243,'5','184','957',429,'Sale Id shift 257150',0.00,0.00,0.00,1255.68,0.00,'2022-07-04 16:14:37','',''),(2628244,'5','184','957',429,'Sale Id shift 257150',0.00,0.00,0.00,2960.90,0.00,'2022-07-04 16:14:37','',''),(2628245,'5','184','957',429,'Sale Id shift 257150',0.00,0.00,0.00,1675.81,0.00,'2022-07-04 16:14:37','',''),(2628246,'5','184',NULL,429,'Sale Id shift 257150',972244.35,0.00,0.00,0.00,0.00,'2022-07-04 16:14:37','',''),(2628247,'5','184','957',429,'Sale Id shift 257151',0.00,0.00,0.00,3043.68,0.00,'2022-07-04 16:28:18','',''),(2628248,'5','184','957',429,'Sale Id shift 257151',0.00,0.00,0.00,1270.12,0.00,'2022-07-04 16:28:18','',''),(2628249,'5','184','957',429,'Sale Id shift 257151',0.00,0.00,0.00,2685.78,0.00,'2022-07-04 16:28:18','',''),(2628250,'5','184',NULL,429,'Sale Id shift 257151',1154930.70,0.00,0.00,0.00,0.00,'2022-07-04 16:28:18','',''),(2628251,'5','184','957',429,'Sale Id shift 257152',0.00,0.00,0.00,1724.88,0.00,'2022-07-04 16:36:13','',''),(2628252,'5','184','957',429,'Sale Id shift 257152',0.00,0.00,0.00,1412.75,0.00,'2022-07-04 16:36:13','',''),(2628253,'5','184','957',429,'Sale Id shift 257152',0.00,0.00,0.00,2425.69,0.00,'2022-07-04 16:36:13','',''),(2628254,'5','184',NULL,429,'Sale Id shift 257152',917947.80,0.00,0.00,0.00,0.00,'2022-07-04 16:36:13','',''),(2628255,'5','184','957',429,'Sale Id shift 257153',0.00,0.00,0.00,997.20,0.00,'2022-07-05 09:16:32','',''),(2628256,'5','184','957',429,'Sale Id shift 257153',0.00,0.00,0.00,2054.94,0.00,'2022-07-05 09:16:32','',''),(2628257,'5','184',NULL,429,'Sale Id shift 257153',503603.10,0.00,0.00,0.00,0.00,'2022-07-05 09:16:32','',''),(2628258,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-07-08 15:12:17','',''),(2628259,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4941750.00,29950.00,0.00,0.00,'2022-07-12 14:26:36','',''),(2628260,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-07-12 14:26:45','',''),(2628261,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-07-18 13:20:12','',''),(2628262,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,17122.35,0.00,'2022-07-18 16:27:45','',''),(2628263,'5','184','958',0,'Inventory adjustment from tank dipping to 15000',0.00,0.00,15000.00,0.00,0.00,'2022-07-18 16:27:45','',''),(2628264,'5','184',NULL,429,'Reception corrector for bridging 132413',0.00,0.00,0.00,40000.00,0.00,'2022-07-18 16:28:00','',''),(2628265,'5','184','958',429,'Received from bridging 132413',0.00,0.00,40000.00,0.00,0.00,'2022-07-18 16:28:00','',''),(2628266,'5','184','958',429,'Sale Id shift 257157',0.00,0.00,0.00,530.15,0.00,'2022-07-19 12:29:01','',''),(2628267,'5','184','958',429,'Sale Id shift 257157',0.00,0.00,0.00,978.33,0.00,'2022-07-19 12:29:01','',''),(2628268,'5','184',NULL,429,'Sale Id shift 257157',279068.80,0.00,0.00,0.00,0.00,'2022-07-19 12:29:01','',''),(2628269,'5','184','958',429,'Sale Id shift 257158',0.00,0.00,0.00,1423.62,0.00,'2022-07-19 13:59:37','',''),(2628270,'5','184','958',429,'Sale Id shift 257158',0.00,0.00,0.00,3291.57,0.00,'2022-07-19 13:59:37','',''),(2628271,'5','184',NULL,429,'Sale Id shift 257158',872310.15,0.00,0.00,0.00,0.00,'2022-07-19 13:59:37','',''),(2628272,'5','184','958',429,'Sale Id shift 257159',0.00,0.00,0.00,886.34,0.00,'2022-07-19 15:26:50','',''),(2628273,'5','184','958',429,'Sale Id shift 257159',0.00,0.00,0.00,839.82,0.00,'2022-07-19 15:26:50','',''),(2628274,'5','184','958',429,'Sale Id shift 257159',0.00,0.00,0.00,3166.61,0.00,'2022-07-19 15:26:50','',''),(2628275,'5','184',NULL,429,'Sale Id shift 257159',905162.45,0.00,0.00,0.00,0.00,'2022-07-19 15:26:50','',''),(2628276,'5','184','958',429,'Sale Id shift 257160',0.00,0.00,0.00,735.00,0.00,'2022-07-20 09:09:24','',''),(2628277,'5','184','958',429,'Sale Id shift 257160',0.00,0.00,0.00,1064.51,0.00,'2022-07-20 09:09:24','',''),(2628278,'5','184','958',429,'Sale Id shift 257160',0.00,0.00,0.00,3305.35,0.00,'2022-07-20 09:09:24','',''),(2628279,'5','184',NULL,429,'Sale Id shift 257160',944399.10,0.00,0.00,0.00,0.00,'2022-07-20 09:09:24','',''),(2628280,'5','184','958',429,'Sale Id shift 257161',0.00,0.00,0.00,887.25,0.00,'2022-07-20 10:48:52','',''),(2628281,'5','184','958',429,'Sale Id shift 257161',0.00,0.00,0.00,4921.06,0.00,'2022-07-20 10:48:52','',''),(2628282,'5','184',NULL,429,'Sale Id shift 257161',1074537.35,0.00,0.00,0.00,0.00,'2022-07-20 10:48:52','',''),(2628283,'5','184','958',429,'Sale Id shift 257162',0.00,0.00,0.00,1432.14,0.00,'2022-07-20 11:00:36','',''),(2628284,'5','184','958',429,'Sale Id shift 257162',0.00,0.00,0.00,3275.52,0.00,'2022-07-20 11:00:36','',''),(2628285,'5','184',NULL,429,'Sale Id shift 257162',870917.10,0.00,0.00,0.00,0.00,'2022-07-20 11:00:36','',''),(2628286,'5','184','958',429,'Sale Id shift 257163',0.00,0.00,0.00,2547.36,0.00,'2022-07-21 08:58:38','',''),(2628287,'5','184','958',429,'Sale Id shift 257163',0.00,0.00,0.00,2562.87,0.00,'2022-07-21 08:58:38','',''),(2628288,'5','184',NULL,429,'Sale Id shift 257163',945392.55,0.00,0.00,0.00,0.00,'2022-07-21 08:58:38','',''),(2628289,'5','184','958',429,'Sale Id shift 257164',0.00,0.00,0.00,2008.70,0.00,'2022-07-22 09:42:56','',''),(2628290,'5','184','958',429,'Sale Id shift 257164',0.00,0.00,0.00,1914.07,0.00,'2022-07-22 09:42:56','',''),(2628291,'5','184',NULL,429,'Sale Id shift 257164',725712.45,0.00,0.00,0.00,0.00,'2022-07-22 09:42:56','',''),(2628292,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8278750.00,44750.00,0.00,0.00,'2022-07-22 15:57:47','',''),(2628293,'5','184','958',429,'Sale Id shift 257165',0.00,0.00,0.00,3973.08,0.00,'2022-07-23 10:34:10','',''),(2628294,'5','184','958',429,'Sale Id shift 257165',0.00,0.00,0.00,7114.60,0.00,'2022-07-23 10:34:10','',''),(2628295,'5','184',NULL,429,'Sale Id shift 257165',2051220.80,0.00,0.00,0.00,0.00,'2022-07-23 10:34:10','',''),(2628296,'5','184',NULL,429,'Reception corrector for bridging 132414',0.00,0.00,0.00,44750.00,0.00,'2022-07-24 09:28:28','',''),(2628297,'5','184','958',429,'Received from bridging 132414',0.00,0.00,44750.00,0.00,0.00,'2022-07-24 09:28:28','',''),(2628298,'5','184','958',429,'Sale Id shift 257166',0.00,0.00,0.00,2945.39,0.00,'2022-07-25 11:21:39','',''),(2628299,'5','184','958',429,'Sale Id shift 257166',0.00,0.00,0.00,5678.19,0.00,'2022-07-25 11:21:39','',''),(2628300,'5','184',NULL,429,'Sale Id shift 257166',1595362.30,0.00,0.00,0.00,0.00,'2022-07-25 11:21:39','',''),(2628301,'5','184','958',429,'Sale Id shift 257167',0.00,0.00,0.00,3967.38,0.00,'2022-07-25 11:32:46','',''),(2628302,'5','184','958',429,'Sale Id shift 257167',0.00,0.00,0.00,6225.13,0.00,'2022-07-25 11:32:46','',''),(2628303,'5','184',NULL,429,'Sale Id shift 257167',1885614.35,0.00,0.00,0.00,0.00,'2022-07-25 11:32:46','',''),(2628304,'5','184','958',429,'Sale Id shift 257168',0.00,0.00,0.00,1938.86,0.00,'2022-07-26 09:20:12','',''),(2628305,'5','184','958',429,'Sale Id shift 257168',0.00,0.00,0.00,4722.65,0.00,'2022-07-26 09:20:12','',''),(2628306,'5','184',NULL,429,'Sale Id shift 257168',1232379.35,0.00,0.00,0.00,0.00,'2022-07-26 09:20:12','',''),(2628307,'5','184','958',429,'Sale Id shift 257169',0.00,0.00,0.00,4125.02,0.00,'2022-07-27 09:16:22','',''),(2628308,'5','184',NULL,429,'Sale Id shift 257169',763128.70,0.00,0.00,0.00,0.00,'2022-07-27 09:16:22','',''),(2628309,'5','184','958',429,'Sale Id shift 257170',0.00,0.00,0.00,53.82,0.00,'2022-07-28 09:23:37','',''),(2628310,'5','184','958',429,'Sale Id shift 257170',0.00,0.00,0.00,3497.10,0.00,'2022-07-28 09:23:37','',''),(2628311,'5','184',NULL,429,'Sale Id shift 257170',656920.20,0.00,0.00,0.00,0.00,'2022-07-28 09:23:37','',''),(2628312,'5','184','958',429,'Sale Id shift 257171',0.00,0.00,0.00,2443.15,0.00,'2022-07-29 09:15:36','',''),(2628313,'5','184',NULL,429,'Sale Id shift 257171',451982.75,0.00,0.00,0.00,0.00,'2022-07-29 09:15:36','',''),(2628314,'5','184','958',429,'Sale Id shift 257172',0.00,0.00,0.00,97.30,0.00,'2022-07-30 20:08:17','',''),(2628315,'5','184','958',429,'Sale Id shift 257172',0.00,0.00,0.00,1866.61,0.00,'2022-07-30 20:08:17','',''),(2628316,'5','184',NULL,429,'Sale Id shift 257172',363323.35,0.00,0.00,0.00,0.00,'2022-07-30 20:08:17','',''),(2628317,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-08-04 12:21:30','',''),(2628318,'5','184','958',429,'Sale Id shift 257176',0.00,0.00,0.00,3267.11,0.00,'2022-09-03 10:06:27','',''),(2628319,'5','184','958',429,'Sale Id shift 257176',0.00,0.00,0.00,7225.21,0.00,'2022-09-03 10:06:27','',''),(2628320,'5','184',NULL,429,'Sale Id shift 257176',1941079.20,0.00,0.00,0.00,0.00,'2022-09-03 10:06:27','',''),(2628321,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-03 11:36:04','',''),(2628322,'5','184',NULL,429,'Reception corrector for bridging 132416',0.00,0.00,0.00,30000.00,0.00,'2022-09-03 12:10:18','',''),(2628323,'5','184','958',429,'Received from bridging 132416',0.00,0.00,30000.00,0.00,0.00,'2022-09-03 12:10:18','',''),(2628324,'5','184','958',429,'Sale Id shift 257177',0.00,0.00,0.00,2482.97,0.00,'2022-09-03 12:14:02','',''),(2628325,'5','184','958',429,'Sale Id shift 257177',0.00,0.00,0.00,4001.72,0.00,'2022-09-03 12:14:02','',''),(2628326,'5','184',NULL,429,'Sale Id shift 257177',1199667.65,0.00,0.00,0.00,0.00,'2022-09-03 12:14:02','',''),(2628327,'5','184','958',429,'Sale Id shift 257178',0.00,0.00,0.00,1927.42,0.00,'2022-09-03 12:19:00','',''),(2628328,'5','184','958',429,'Sale Id shift 257178',0.00,0.00,0.00,3250.21,0.00,'2022-09-03 12:19:00','',''),(2628329,'5','184',NULL,429,'Sale Id shift 257178',957861.55,0.00,0.00,0.00,0.00,'2022-09-03 12:19:00','',''),(2628330,'5','184','958',429,'Sale Id shift 257179',0.00,0.00,0.00,2290.85,0.00,'2022-09-03 13:37:36','',''),(2628331,'5','184','958',429,'Sale Id shift 257179',0.00,0.00,0.00,3616.33,0.00,'2022-09-03 13:37:36','',''),(2628332,'5','184',NULL,429,'Sale Id shift 257179',1092828.30,0.00,0.00,0.00,0.00,'2022-09-03 13:37:36','',''),(2628333,'5','184','958',429,'Sale Id shift 257180',0.00,0.00,0.00,3147.65,0.00,'2022-09-03 15:03:22','',''),(2628334,'5','184','958',429,'Sale Id shift 257180',0.00,0.00,0.00,4223.44,0.00,'2022-09-03 15:03:22','',''),(2628335,'5','184',NULL,429,'Sale Id shift 257180',1363651.65,0.00,0.00,0.00,0.00,'2022-09-03 15:03:22','',''),(2628336,'5','184','958',429,'Sale Id shift 257181',0.00,0.00,0.00,1699.32,0.00,'2022-09-03 16:57:19','',''),(2628337,'5','184','958',429,'Sale Id shift 257181',0.00,0.00,0.00,2829.04,0.00,'2022-09-03 16:57:19','',''),(2628338,'5','184',NULL,429,'Sale Id shift 257181',837746.60,0.00,0.00,0.00,0.00,'2022-09-03 16:57:19','',''),(2628339,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7363000.00,39800.00,0.00,0.00,'2022-09-03 17:36:20','',''),(2628340,'5','184',NULL,429,'Reception corrector for bridging 132415',0.00,0.00,0.00,40000.00,0.00,'2022-09-03 17:36:33','',''),(2628341,'5','184','958',429,'Received from bridging 132415',0.00,0.00,40000.00,0.00,0.00,'2022-09-03 17:36:33','',''),(2628342,'5','184','958',429,'Sale Id shift 257182',0.00,0.00,0.00,3041.05,0.00,'2022-09-03 20:18:11','',''),(2628343,'5','184','958',429,'Sale Id shift 257182',0.00,0.00,0.00,4324.92,0.00,'2022-09-03 20:18:11','',''),(2628344,'5','184',NULL,429,'Sale Id shift 257182',1362704.45,0.00,0.00,0.00,0.00,'2022-09-03 20:18:11','',''),(2628345,'5','184','958',429,'Sale Id shift 257183',0.00,0.00,0.00,2448.77,0.00,'2022-09-04 11:33:15','',''),(2628346,'5','184','958',429,'Sale Id shift 257183',0.00,0.00,0.00,3648.27,0.00,'2022-09-04 11:33:15','',''),(2628347,'5','184',NULL,429,'Sale Id shift 257183',1127952.40,0.00,0.00,0.00,0.00,'2022-09-04 11:33:15','',''),(2628348,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8140000.00,44000.00,0.00,0.00,'2022-09-04 11:48:21','',''),(2628349,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-04 12:35:57','',''),(2628350,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,819.14,0.00,'2022-09-04 13:24:56','',''),(2628351,'5','184','957',0,'Inventory adjustment from tank dipping to 11600',0.00,0.00,11600.00,0.00,0.00,'2022-09-04 13:24:56','',''),(2628352,'5','184','958',429,'Sale Id shift 257185',0.00,0.00,0.00,2044.27,0.00,'2022-09-04 13:44:48','',''),(2628353,'5','184','958',429,'Sale Id shift 257185',0.00,0.00,0.00,2701.47,0.00,'2022-09-04 13:44:48','',''),(2628354,'5','184','957',429,'Sale Id shift 257185',0.00,0.00,0.00,2067.11,0.00,'2022-09-04 13:44:48','',''),(2628355,'5','184',NULL,429,'Sale Id shift 257185',1260377.25,0.00,0.00,0.00,0.00,'2022-09-04 13:44:48','',''),(2628356,'5','184','958',429,'Sale Id shift 257186',0.00,0.00,0.00,2944.07,0.00,'2022-09-04 13:49:05','',''),(2628357,'5','184','958',429,'Sale Id shift 257186',0.00,0.00,0.00,3228.71,0.00,'2022-09-04 13:49:05','',''),(2628358,'5','184','957',429,'Sale Id shift 257186',0.00,0.00,0.00,2665.49,0.00,'2022-09-04 13:49:05','',''),(2628359,'5','184',NULL,429,'Sale Id shift 257186',1635079.95,0.00,0.00,0.00,0.00,'2022-09-04 13:49:05','',''),(2628360,'5','184','958',429,'Sale Id shift 257187',0.00,0.00,0.00,2607.65,0.00,'2022-09-04 14:06:57','',''),(2628361,'5','184','958',429,'Sale Id shift 257187',0.00,0.00,0.00,3033.12,0.00,'2022-09-04 14:06:57','',''),(2628362,'5','184','957',429,'Sale Id shift 257187',0.00,0.00,0.00,2289.70,0.00,'2022-09-04 14:06:57','',''),(2628363,'5','184',NULL,429,'Sale Id shift 257187',1467136.95,0.00,0.00,0.00,0.00,'2022-09-04 14:06:57','',''),(2628364,'5','184','958',429,'Sale Id shift 257188',0.00,0.00,0.00,2787.23,0.00,'2022-09-04 14:32:04','',''),(2628365,'5','184','958',429,'Sale Id shift 257188',0.00,0.00,0.00,2148.42,0.00,'2022-09-04 14:32:04','',''),(2628366,'5','184','957',429,'Sale Id shift 257188',0.00,0.00,0.00,2549.53,0.00,'2022-09-04 14:32:04','',''),(2628367,'5','184',NULL,429,'Sale Id shift 257188',1384758.30,0.00,0.00,0.00,0.00,'2022-09-04 14:32:04','',''),(2628368,'5','184',NULL,429,'Reception corrector for bridging 132417',0.00,0.00,0.00,39800.00,0.00,'2022-09-04 14:50:13','',''),(2628369,'5','184','958',429,'Received from bridging 132417',0.00,0.00,39800.00,0.00,0.00,'2022-09-04 14:50:13','',''),(2628370,'5','184',NULL,429,'Reception corrector for bridging 132418',0.00,0.00,0.00,30000.00,0.00,'2022-09-04 14:50:20','',''),(2628371,'5','184','957',429,'Received from bridging 132418',0.00,0.00,30000.00,0.00,0.00,'2022-09-04 14:50:20','',''),(2628372,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-04 14:50:37','',''),(2628373,'5','184','958',429,'Sale Id shift 257189',0.00,0.00,0.00,2324.71,0.00,'2022-09-04 15:09:01','',''),(2628374,'5','184','958',429,'Sale Id shift 257189',0.00,0.00,0.00,1429.03,0.00,'2022-09-04 15:09:01','',''),(2628375,'5','184','957',429,'Sale Id shift 257189',0.00,0.00,0.00,2530.13,0.00,'2022-09-04 15:09:01','',''),(2628376,'5','184',NULL,429,'Sale Id shift 257189',1162515.95,0.00,0.00,0.00,0.00,'2022-09-04 15:09:01','',''),(2628377,'5','184','958',429,'Sale Id shift 257190',0.00,0.00,0.00,825.40,0.00,'2022-09-04 16:00:04','',''),(2628378,'5','184','958',429,'Sale Id shift 257190',0.00,0.00,0.00,977.29,0.00,'2022-09-04 16:00:04','',''),(2628379,'5','184','957',429,'Sale Id shift 257190',0.00,0.00,0.00,2532.74,0.00,'2022-09-04 16:00:04','',''),(2628380,'5','184',NULL,429,'Sale Id shift 257190',802054.55,0.00,0.00,0.00,0.00,'2022-09-04 16:00:04','',''),(2628381,'5','184','958',429,'Sale Id shift 257191',0.00,0.00,0.00,1938.30,0.00,'2022-09-04 17:38:44','',''),(2628382,'5','184','958',429,'Sale Id shift 257191',0.00,0.00,0.00,2446.27,0.00,'2022-09-04 17:38:44','',''),(2628383,'5','184','957',429,'Sale Id shift 257191',0.00,0.00,0.00,1393.38,0.00,'2022-09-04 17:38:44','',''),(2628384,'5','184',NULL,429,'Sale Id shift 257191',1068920.75,0.00,0.00,0.00,0.00,'2022-09-04 17:38:44','',''),(2628385,'5','184','958',429,'Sale Id shift 257192',0.00,0.00,0.00,2087.71,0.00,'2022-09-04 17:45:23','',''),(2628386,'5','184','958',429,'Sale Id shift 257192',0.00,0.00,0.00,2227.00,0.00,'2022-09-04 17:45:23','',''),(2628387,'5','184','957',429,'Sale Id shift 257192',0.00,0.00,0.00,1050.91,0.00,'2022-09-04 17:45:23','',''),(2628388,'5','184',NULL,429,'Sale Id shift 257192',992639.70,0.00,0.00,0.00,0.00,'2022-09-04 17:45:23','',''),(2628389,'5','184','958',429,'Sale Id shift 257193',0.00,0.00,0.00,2210.05,0.00,'2022-09-04 17:48:11','',''),(2628390,'5','184','958',429,'Sale Id shift 257193',0.00,0.00,0.00,2397.25,0.00,'2022-09-04 17:48:11','',''),(2628391,'5','184','957',429,'Sale Id shift 257193',0.00,0.00,0.00,1533.37,0.00,'2022-09-04 17:48:11','',''),(2628392,'5','184',NULL,429,'Sale Id shift 257193',1136023.95,0.00,0.00,0.00,0.00,'2022-09-04 17:48:11','',''),(2628393,'5','184','958',429,'Sale Id shift 257194',0.00,0.00,0.00,2435.44,0.00,'2022-09-04 17:55:56','',''),(2628394,'5','184','958',429,'Sale Id shift 257194',0.00,0.00,0.00,2716.56,0.00,'2022-09-04 17:55:56','',''),(2628395,'5','184','958',429,'Sale Id shift 257194',0.00,0.00,0.00,2410.20,0.00,'2022-09-04 17:55:56','',''),(2628396,'5','184',NULL,429,'Sale Id shift 257194',1399007.00,0.00,0.00,0.00,0.00,'2022-09-04 17:55:56','',''),(2628397,'5','184',NULL,429,'Reception corrector for bridging 132419',0.00,0.00,0.00,15000.00,0.00,'2022-09-04 17:57:45','',''),(2628398,'5','184','958',429,'Received from bridging 132419',0.00,0.00,15000.00,0.00,0.00,'2022-09-04 17:57:45','',''),(2628399,'5','184','958',429,'Sale Id shift 257195',0.00,0.00,0.00,2070.33,0.00,'2022-09-04 17:59:50','',''),(2628400,'5','184','958',429,'Sale Id shift 257195',0.00,0.00,0.00,3182.28,0.00,'2022-09-04 17:59:50','',''),(2628401,'5','184','958',429,'Sale Id shift 257195',0.00,0.00,0.00,1105.36,0.00,'2022-09-04 17:59:50','',''),(2628402,'5','184','957',429,'Sale Id shift 257195',0.00,0.00,0.00,829.57,0.00,'2022-09-04 17:59:50','',''),(2628403,'5','184',NULL,429,'Sale Id shift 257195',1329694.90,0.00,0.00,0.00,0.00,'2022-09-04 17:59:50','',''),(2628404,'5','184','958',429,'Sale Id shift 257196',0.00,0.00,0.00,2654.67,0.00,'2022-09-04 21:12:37','',''),(2628405,'5','184','958',429,'Sale Id shift 257196',0.00,0.00,0.00,2354.33,0.00,'2022-09-04 21:12:37','',''),(2628406,'5','184','958',429,'Sale Id shift 257196',0.00,0.00,0.00,3054.52,0.00,'2022-09-04 21:12:37','',''),(2628407,'5','184','958',429,'Sale Id shift 257196',0.00,0.00,0.00,125.38,0.00,'2022-09-04 21:12:37','',''),(2628408,'5','184','957',429,'Sale Id shift 257196',0.00,0.00,0.00,1164.56,0.00,'2022-09-04 21:12:37','',''),(2628409,'5','184',NULL,429,'Sale Id shift 257196',1730390.10,0.00,0.00,0.00,0.00,'2022-09-04 21:12:37','',''),(2628410,'5','184','958',429,'Sale Id shift 257197',0.00,0.00,0.00,4421.68,0.00,'2022-09-05 10:23:59','',''),(2628411,'5','184','958',429,'Sale Id shift 257197',0.00,0.00,0.00,1957.17,0.00,'2022-09-05 10:23:59','',''),(2628412,'5','184','958',429,'Sale Id shift 257197',0.00,0.00,0.00,3087.72,0.00,'2022-09-05 10:23:59','',''),(2628413,'5','184','957',429,'Sale Id shift 257197',0.00,0.00,0.00,830.12,0.00,'2022-09-05 10:23:59','',''),(2628414,'5','184',NULL,429,'Sale Id shift 257197',1904887.65,0.00,0.00,0.00,0.00,'2022-09-05 10:23:59','',''),(2628415,'5','184','958',429,'Sale Id shift 257198',0.00,0.00,0.00,2396.02,0.00,'2022-09-05 11:16:00','',''),(2628416,'5','184','958',429,'Sale Id shift 257198',0.00,0.00,0.00,2755.96,0.00,'2022-09-05 11:16:00','',''),(2628417,'5','184','958',429,'Sale Id shift 257198',0.00,0.00,0.00,2534.00,0.00,'2022-09-05 11:16:00','',''),(2628418,'5','184','957',429,'Sale Id shift 257198',0.00,0.00,0.00,1335.69,0.00,'2022-09-05 11:16:00','',''),(2628419,'5','184',NULL,429,'Sale Id shift 257198',1669008.95,0.00,0.00,0.00,0.00,'2022-09-05 11:16:00','',''),(2628420,'5','184','958',429,'Sale Id shift 257199',0.00,0.00,0.00,1211.26,0.00,'2022-09-05 11:34:52','',''),(2628421,'5','184','958',429,'Sale Id shift 257199',0.00,0.00,0.00,1694.37,0.00,'2022-09-05 11:34:52','',''),(2628422,'5','184','958',429,'Sale Id shift 257199',0.00,0.00,0.00,2708.39,0.00,'2022-09-05 11:34:52','',''),(2628423,'5','184','957',429,'Sale Id shift 257199',0.00,0.00,0.00,8654.90,0.00,'2022-09-05 11:34:52','',''),(2628424,'5','184','957',429,'Sale Id shift 257199',0.00,0.00,0.00,1085.15,0.00,'2022-09-05 11:34:52','',''),(2628425,'5','184',NULL,429,'Sale Id shift 257199',2840502.95,0.00,0.00,0.00,0.00,'2022-09-05 11:34:52','',''),(2628426,'5','184',NULL,429,'Reception corrector for bridging 132420',0.00,0.00,0.00,40000.00,0.00,'2022-09-05 12:01:59','',''),(2628427,'5','184','958',429,'Received from bridging 132420',0.00,0.00,40000.00,0.00,0.00,'2022-09-05 12:01:59','',''),(2628428,'5','184','958',429,'Sale Id shift 257200',0.00,0.00,0.00,1643.62,0.00,'2022-09-05 12:04:07','',''),(2628429,'5','184','958',429,'Sale Id shift 257200',0.00,0.00,0.00,1126.74,0.00,'2022-09-05 12:04:07','',''),(2628430,'5','184','958',429,'Sale Id shift 257200',0.00,0.00,0.00,2295.35,0.00,'2022-09-05 12:04:07','',''),(2628431,'5','184','957',429,'Sale Id shift 257200',0.00,0.00,0.00,1690.56,0.00,'2022-09-05 12:04:07','',''),(2628432,'5','184','957',429,'Sale Id shift 257200',0.00,0.00,0.00,505.76,0.00,'2022-09-05 12:04:07','',''),(2628433,'5','184',NULL,429,'Sale Id shift 257200',1343475.55,0.00,0.00,0.00,0.00,'2022-09-05 12:04:07','',''),(2628434,'5','184','958',429,'Sale Id shift 257201',0.00,0.00,0.00,1303.30,0.00,'2022-09-05 12:08:42','',''),(2628435,'5','184','958',429,'Sale Id shift 257201',0.00,0.00,0.00,1769.92,0.00,'2022-09-05 12:08:42','',''),(2628436,'5','184','958',429,'Sale Id shift 257201',0.00,0.00,0.00,2690.20,0.00,'2022-09-05 12:08:42','',''),(2628437,'5','184','957',429,'Sale Id shift 257201',0.00,0.00,0.00,1127.01,0.00,'2022-09-05 12:08:42','',''),(2628438,'5','184',NULL,429,'Sale Id shift 257201',1274729.55,0.00,0.00,0.00,0.00,'2022-09-05 12:08:42','',''),(2628439,'5','184','958',429,'Sale Id shift 257202',0.00,0.00,0.00,2967.82,0.00,'2022-09-05 12:13:26','',''),(2628440,'5','184','958',429,'Sale Id shift 257202',0.00,0.00,0.00,2218.98,0.00,'2022-09-05 12:13:26','',''),(2628441,'5','184','958',429,'Sale Id shift 257202',0.00,0.00,0.00,2517.18,0.00,'2022-09-05 12:13:26','',''),(2628442,'5','184','957',429,'Sale Id shift 257202',0.00,0.00,0.00,539.41,0.00,'2022-09-05 12:13:26','',''),(2628443,'5','184',NULL,429,'Sale Id shift 257202',1525027.15,0.00,0.00,0.00,0.00,'2022-09-05 12:13:26','',''),(2628444,'5','184','958',429,'Sale Id shift 257203',0.00,0.00,0.00,3053.13,0.00,'2022-09-05 12:18:22','',''),(2628445,'5','184','958',429,'Sale Id shift 257203',0.00,0.00,0.00,2224.67,0.00,'2022-09-05 12:18:22','',''),(2628446,'5','184','958',429,'Sale Id shift 257203',0.00,0.00,0.00,3195.97,0.00,'2022-09-05 12:18:22','',''),(2628447,'5','184','957',429,'Sale Id shift 257203',0.00,0.00,0.00,704.52,0.00,'2022-09-05 12:18:22','',''),(2628448,'5','184',NULL,429,'Sale Id shift 257203',1697983.65,0.00,0.00,0.00,0.00,'2022-09-05 12:18:22','',''),(2628449,'5','184','958',429,'Sale Id shift 257204',0.00,0.00,0.00,1808.28,0.00,'2022-09-05 12:30:12','',''),(2628450,'5','184','958',429,'Sale Id shift 257204',0.00,0.00,0.00,4.32,0.00,'2022-09-05 12:30:12','',''),(2628451,'5','184','957',429,'Sale Id shift 257204',0.00,0.00,0.00,1403.22,0.00,'2022-09-05 12:30:12','',''),(2628452,'5','184',NULL,429,'Sale Id shift 257204',594926.70,0.00,0.00,0.00,0.00,'2022-09-05 12:30:12','',''),(2628453,'5','184','958',429,'Sale Id shift 257205',0.00,0.00,0.00,2981.30,0.00,'2022-09-05 13:48:26','',''),(2628454,'5','184','958',429,'Sale Id shift 257205',0.00,0.00,0.00,2824.88,0.00,'2022-09-05 13:48:26','',''),(2628455,'5','184','958',429,'Sale Id shift 257205',0.00,0.00,0.00,3060.78,0.00,'2022-09-05 13:48:26','',''),(2628456,'5','184','957',429,'Sale Id shift 257205',0.00,0.00,0.00,2175.78,0.00,'2022-09-05 13:48:26','',''),(2628457,'5','184','957',429,'Sale Id shift 257205',0.00,0.00,0.00,487.21,0.00,'2022-09-05 13:48:26','',''),(2628458,'5','184',NULL,429,'Sale Id shift 257205',2133040.75,0.00,0.00,0.00,0.00,'2022-09-05 13:48:26','',''),(2628459,'5','184',NULL,429,'Reception corrector for bridging 132421',0.00,0.00,0.00,21500.00,0.00,'2022-09-05 15:36:35','',''),(2628460,'5','184','957',429,'Received from bridging 132421',0.00,0.00,21500.00,0.00,0.00,'2022-09-05 15:36:35','',''),(2628461,'5','184',NULL,429,'Reception corrector for bridging 132422',0.00,0.00,0.00,22500.00,0.00,'2022-09-05 15:36:47','',''),(2628462,'5','184','958',429,'Received from bridging 132422',0.00,0.00,22500.00,0.00,0.00,'2022-09-05 15:36:47','',''),(2628463,'5','184','958',429,'Sale Id shift 257206',0.00,0.00,0.00,2434.29,0.00,'2022-09-05 16:05:41','',''),(2628464,'5','184','958',429,'Sale Id shift 257206',0.00,0.00,0.00,2715.76,0.00,'2022-09-05 16:05:41','',''),(2628465,'5','184','958',429,'Sale Id shift 257206',0.00,0.00,0.00,3049.44,0.00,'2022-09-05 16:05:41','',''),(2628466,'5','184','958',429,'Sale Id shift 257206',0.00,0.00,0.00,448.72,0.00,'2022-09-05 16:05:41','',''),(2628467,'5','184','957',429,'Sale Id shift 257206',0.00,0.00,0.00,0.48,0.00,'2022-09-05 16:05:41','',''),(2628468,'5','184','957',429,'Sale Id shift 257206',0.00,0.00,0.00,360.07,0.00,'2022-09-05 16:05:41','',''),(2628469,'5','184',NULL,429,'Sale Id shift 257206',1666620.60,0.00,0.00,0.00,0.00,'2022-09-05 16:05:41','',''),(2628470,'5','184','958',429,'Sale Id shift 257207',0.00,0.00,0.00,2634.86,0.00,'2022-09-06 10:21:55','',''),(2628471,'5','184','958',429,'Sale Id shift 257207',0.00,0.00,0.00,863.37,0.00,'2022-09-06 10:21:55','',''),(2628472,'5','184','958',429,'Sale Id shift 257207',0.00,0.00,0.00,2989.07,0.00,'2022-09-06 10:21:55','',''),(2628473,'5','184','958',429,'Sale Id shift 257207',0.00,0.00,0.00,2889.50,0.00,'2022-09-06 10:21:55','',''),(2628474,'5','184',NULL,429,'Sale Id shift 257207',1734708.00,0.00,0.00,0.00,0.00,'2022-09-06 10:21:55','',''),(2628475,'5','184','958',429,'Sale Id shift 257208',0.00,0.00,0.00,1673.79,0.00,'2022-09-06 11:07:42','',''),(2628476,'5','184','958',429,'Sale Id shift 257208',0.00,0.00,0.00,1212.64,0.00,'2022-09-06 11:07:42','',''),(2628477,'5','184','958',429,'Sale Id shift 257208',0.00,0.00,0.00,1758.42,0.00,'2022-09-06 11:07:42','',''),(2628478,'5','184','958',429,'Sale Id shift 257208',0.00,0.00,0.00,1520.65,0.00,'2022-09-06 11:07:42','',''),(2628479,'5','184',NULL,429,'Sale Id shift 257208',1140617.50,0.00,0.00,0.00,0.00,'2022-09-06 11:07:42','',''),(2628480,'5','184',NULL,429,'Reception corrector for bridging 132423',0.00,0.00,0.00,13500.00,0.00,'2022-09-07 09:25:23','',''),(2628481,'5','184','957',429,'Received from bridging 132423',0.00,0.00,13500.00,0.00,0.00,'2022-09-07 09:25:23','',''),(2628482,'5','184',NULL,429,'Reception corrector for bridging 132425',0.00,0.00,0.00,5000.00,0.00,'2022-09-07 18:20:10','',''),(2628483,'5','184','958',429,'Received from bridging 132425',0.00,0.00,5000.00,0.00,0.00,'2022-09-07 18:20:10','',''),(2628484,'5','184',NULL,429,'Reception corrector for bridging 132429',0.00,0.00,0.00,15000.00,0.00,'2022-09-07 18:20:44','',''),(2628485,'5','184','957',429,'Received from bridging 132429',0.00,0.00,15000.00,0.00,0.00,'2022-09-07 18:20:44','',''),(2628486,'5','184',NULL,430,'Reception corrector for bridging 132428',0.00,0.00,0.00,15000.00,0.00,'2022-09-07 18:20:53','',''),(2628487,'5','184','959',430,'Received from bridging 132428',0.00,0.00,15000.00,0.00,0.00,'2022-09-07 18:20:53','',''),(2628488,'5','184','958',429,'Sale Id shift 257209',0.00,0.00,0.00,672.61,0.00,'2022-09-08 10:10:24','',''),(2628489,'5','184','958',429,'Sale Id shift 257209',0.00,0.00,0.00,1600.52,0.00,'2022-09-08 10:10:24','',''),(2628490,'5','184','958',429,'Sale Id shift 257209',0.00,0.00,0.00,682.74,0.00,'2022-09-08 10:10:24','',''),(2628491,'5','184','958',429,'Sale Id shift 257209',0.00,0.00,0.00,566.46,0.00,'2022-09-08 10:10:24','',''),(2628492,'5','184',NULL,429,'Sale Id shift 257209',651631.05,0.00,0.00,0.00,0.00,'2022-09-08 10:10:24','',''),(2628493,'5','184','958',429,'Sale Id shift 257210',0.00,0.00,0.00,1843.60,0.00,'2022-09-08 10:31:54','',''),(2628494,'5','184','958',429,'Sale Id shift 257210',0.00,0.00,0.00,1473.41,0.00,'2022-09-08 10:31:54','',''),(2628495,'5','184',NULL,429,'Sale Id shift 257210',613646.85,0.00,0.00,0.00,0.00,'2022-09-08 10:31:54','',''),(2628496,'5','184',NULL,431,'2022-09-09 11:39:09',0.00,-2245118.93,0.00,0.00,0.00,'2022-09-09 11:39:09','',''),(2628497,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-11 09:57:15','',''),(2628498,'5','184',NULL,429,'Reception corrector for bridging 132435',0.00,0.00,0.00,40000.00,0.00,'2022-09-12 09:26:57','',''),(2628499,'5','184','958',429,'Received from bridging 132435',0.00,0.00,40000.00,0.00,0.00,'2022-09-12 09:26:57','',''),(2628500,'5','184','958',429,'Sale Id shift 257214',0.00,0.00,0.00,2830.39,0.00,'2022-09-12 10:06:57','',''),(2628501,'5','184','958',429,'Sale Id shift 257214',0.00,0.00,0.00,935.02,0.00,'2022-09-12 10:06:57','',''),(2628502,'5','184','958',429,'Sale Id shift 257214',0.00,0.00,0.00,2216.38,0.00,'2022-09-12 10:06:57','',''),(2628503,'5','184','958',429,'Sale Id shift 257214',0.00,0.00,0.00,1660.36,0.00,'2022-09-12 10:06:57','',''),(2628504,'5','184',NULL,429,'Sale Id shift 257214',1413797.75,0.00,0.00,0.00,0.00,'2022-09-12 10:06:57','',''),(2628505,'5','184','958',429,'Sale Id shift 257215',0.00,0.00,0.00,2397.68,0.00,'2022-09-13 10:24:35','',''),(2628506,'5','184','958',429,'Sale Id shift 257215',0.00,0.00,0.00,705.18,0.00,'2022-09-13 10:24:35','',''),(2628507,'5','184','958',429,'Sale Id shift 257215',0.00,0.00,0.00,2066.16,0.00,'2022-09-13 10:24:35','',''),(2628508,'5','184','958',429,'Sale Id shift 257215',0.00,0.00,0.00,1824.35,0.00,'2022-09-13 10:24:35','',''),(2628509,'5','184',NULL,429,'Sale Id shift 257215',1293773.45,0.00,0.00,0.00,0.00,'2022-09-13 10:24:35','',''),(2628510,'5','184','958',429,'Sale Id shift 257216',0.00,0.00,0.00,2600.24,0.00,'2022-09-14 10:18:13','',''),(2628511,'5','184','958',429,'Sale Id shift 257216',0.00,0.00,0.00,828.82,0.00,'2022-09-14 10:18:13','',''),(2628512,'5','184','958',429,'Sale Id shift 257216',0.00,0.00,0.00,2162.25,0.00,'2022-09-14 10:18:13','',''),(2628513,'5','184','958',429,'Sale Id shift 257216',0.00,0.00,0.00,1801.51,0.00,'2022-09-14 10:18:13','',''),(2628514,'5','184',NULL,429,'Sale Id shift 257216',1367671.70,0.00,0.00,0.00,0.00,'2022-09-14 10:18:13','',''),(2628515,'5','184','958',429,'Sale Id shift 257217',0.00,0.00,0.00,2321.87,0.00,'2022-09-15 10:11:13','',''),(2628516,'5','184','958',429,'Sale Id shift 257217',0.00,0.00,0.00,961.63,0.00,'2022-09-15 10:11:13','',''),(2628517,'5','184','958',429,'Sale Id shift 257217',0.00,0.00,0.00,2184.42,0.00,'2022-09-15 10:11:13','',''),(2628518,'5','184','958',429,'Sale Id shift 257217',0.00,0.00,0.00,1683.10,0.00,'2022-09-15 10:11:13','',''),(2628519,'5','184',NULL,429,'Sale Id shift 257217',1322938.70,0.00,0.00,0.00,0.00,'2022-09-15 10:11:13','',''),(2628520,'5','184','958',429,'Sale Id shift 257218',0.00,0.00,0.00,2387.87,0.00,'2022-09-16 10:17:44','',''),(2628521,'5','184','958',429,'Sale Id shift 257218',0.00,0.00,0.00,1881.67,0.00,'2022-09-16 10:17:44','',''),(2628522,'5','184','958',429,'Sale Id shift 257218',0.00,0.00,0.00,1985.06,0.00,'2022-09-16 10:17:44','',''),(2628523,'5','184','958',429,'Sale Id shift 257218',0.00,0.00,0.00,930.14,0.00,'2022-09-16 10:17:44','',''),(2628524,'5','184',NULL,429,'Sale Id shift 257218',1329176.90,0.00,0.00,0.00,0.00,'2022-09-16 10:17:44','',''),(2628525,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7242750.00,39150.00,0.00,0.00,'2022-09-16 10:17:55','',''),(2628526,'5','184',NULL,429,'Reception corrector for bridging 132437',0.00,0.00,0.00,39150.00,0.00,'2022-09-16 10:53:22','',''),(2628527,'5','184','958',429,'Received from bridging 132437',0.00,0.00,39150.00,0.00,0.00,'2022-09-16 10:53:22','',''),(2628528,'5','184','958',429,'Sale Id shift 257219',0.00,0.00,0.00,2488.44,0.00,'2022-09-17 12:19:07','',''),(2628529,'5','184','958',429,'Sale Id shift 257219',0.00,0.00,0.00,1172.02,0.00,'2022-09-17 12:19:07','',''),(2628530,'5','184','958',429,'Sale Id shift 257219',0.00,0.00,0.00,2097.21,0.00,'2022-09-17 12:19:07','',''),(2628531,'5','184','958',429,'Sale Id shift 257219',0.00,0.00,0.00,2050.63,0.00,'2022-09-17 12:19:07','',''),(2628532,'5','184',NULL,429,'Sale Id shift 257219',1444535.50,0.00,0.00,0.00,0.00,'2022-09-17 12:19:07','',''),(2628533,'5','184','958',429,'Sale Id shift 257220',0.00,0.00,0.00,1875.83,0.00,'2022-09-18 14:56:19','',''),(2628534,'5','184','958',429,'Sale Id shift 257220',0.00,0.00,0.00,1019.07,0.00,'2022-09-18 14:56:19','',''),(2628535,'5','184','958',429,'Sale Id shift 257220',0.00,0.00,0.00,2229.23,0.00,'2022-09-18 14:56:19','',''),(2628536,'5','184','958',429,'Sale Id shift 257220',0.00,0.00,0.00,2147.45,0.00,'2022-09-18 14:56:19','',''),(2628537,'5','184',NULL,429,'Sale Id shift 257220',1345242.30,0.00,0.00,0.00,0.00,'2022-09-18 14:56:19','',''),(2628538,'5','184','958',429,'Sale Id shift 257221',0.00,0.00,0.00,2290.59,0.00,'2022-09-19 08:01:59','',''),(2628539,'5','184','958',429,'Sale Id shift 257221',0.00,0.00,0.00,745.87,0.00,'2022-09-19 08:01:59','',''),(2628540,'5','184','958',429,'Sale Id shift 257221',0.00,0.00,0.00,1929.10,0.00,'2022-09-19 08:01:59','',''),(2628541,'5','184','958',429,'Sale Id shift 257221',0.00,0.00,0.00,1897.66,0.00,'2022-09-19 08:01:59','',''),(2628542,'5','184',NULL,429,'Sale Id shift 257221',1269695.70,0.00,0.00,0.00,0.00,'2022-09-19 08:01:59','',''),(2628543,'5','184','958',429,'Sale Id shift 257222',0.00,0.00,0.00,2402.30,0.00,'2022-09-20 09:19:04','',''),(2628544,'5','184','958',429,'Sale Id shift 257222',0.00,0.00,0.00,1165.98,0.00,'2022-09-20 09:19:04','',''),(2628545,'5','184','958',429,'Sale Id shift 257222',0.00,0.00,0.00,2346.07,0.00,'2022-09-20 09:19:04','',''),(2628546,'5','184','958',429,'Sale Id shift 257222',0.00,0.00,0.00,1362.35,0.00,'2022-09-20 09:19:04','',''),(2628547,'5','184',NULL,429,'Sale Id shift 257222',1346189.50,0.00,0.00,0.00,0.00,'2022-09-20 09:19:04','',''),(2628548,'5','184','958',429,'Sale Id shift 257223',0.00,0.00,0.00,2209.70,0.00,'2022-09-22 08:43:43','',''),(2628549,'5','184','958',429,'Sale Id shift 257223',0.00,0.00,0.00,977.82,0.00,'2022-09-22 08:43:43','',''),(2628550,'5','184','958',429,'Sale Id shift 257223',0.00,0.00,0.00,2007.30,0.00,'2022-09-22 08:43:43','',''),(2628551,'5','184','958',429,'Sale Id shift 257223',0.00,0.00,0.00,1778.38,0.00,'2022-09-22 08:43:43','',''),(2628552,'5','184',NULL,429,'Sale Id shift 257223',1290042.00,0.00,0.00,0.00,0.00,'2022-09-22 08:43:43','',''),(2628553,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,50093.63,0.00,'2022-09-28 10:29:11','',''),(2628554,'5','184','957',0,'Inventory adjustment from tank dipping to 1050',0.00,0.00,1050.00,0.00,0.00,'2022-09-28 10:29:11','',''),(2628555,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,6850.19,0.00,'2022-09-28 10:29:30','',''),(2628556,'5','184','958',0,'Inventory adjustment from tank dipping to 450',0.00,0.00,450.00,0.00,0.00,'2022-09-28 10:29:30','',''),(2628557,'5','184','960',0,'Tank level zero out for dipping',0.00,0.00,0.00,1392.07,0.00,'2022-09-28 10:29:48','',''),(2628558,'5','184','960',0,'Inventory adjustment from tank dipping to 300',0.00,0.00,300.00,0.00,0.00,'2022-09-28 10:29:48','',''),(2628559,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7316750.00,39550.00,0.00,0.00,'2022-09-28 10:37:52','',''),(2628560,'5','184',NULL,429,'Reception corrector for bridging 132438',0.00,0.00,0.00,39550.00,0.00,'2022-09-28 10:42:44','',''),(2628561,'5','184','957',429,'Received from bridging 132438',0.00,0.00,39550.00,0.00,0.00,'2022-09-28 10:42:44','',''),(2628562,'5','184','957',429,'Sale Id shift 257224',0.00,0.00,0.00,169.49,0.00,'2022-09-28 10:53:02','',''),(2628563,'5','184','957',429,'Sale Id shift 257224',0.00,0.00,0.00,2325.66,0.00,'2022-09-28 10:53:02','',''),(2628564,'5','184','957',429,'Sale Id shift 257224',0.00,0.00,0.00,1932.84,0.00,'2022-09-28 10:53:02','',''),(2628565,'5','184','957',429,'Sale Id shift 257224',0.00,0.00,0.00,1094.80,0.00,'2022-09-28 10:53:02','',''),(2628566,'5','184',NULL,429,'Sale Id shift 257224',1021716.15,0.00,0.00,0.00,0.00,'2022-09-28 10:53:02','',''),(2628567,'5','184','957',429,'Sale Id shift 257225',0.00,0.00,0.00,2470.08,0.00,'2022-09-28 11:02:05','',''),(2628568,'5','184','957',429,'Sale Id shift 257225',0.00,0.00,0.00,2257.32,0.00,'2022-09-28 11:02:05','',''),(2628569,'5','184','957',429,'Sale Id shift 257225',0.00,0.00,0.00,1697.30,0.00,'2022-09-28 11:02:05','',''),(2628570,'5','184',NULL,429,'Sale Id shift 257225',1188569.50,0.00,0.00,0.00,0.00,'2022-09-28 11:02:05','',''),(2628571,'5','184','957',429,'Sale Id shift 257226',0.00,0.00,0.00,124.04,0.00,'2022-09-28 11:09:51','',''),(2628572,'5','184','957',429,'Sale Id shift 257226',0.00,0.00,0.00,2699.09,0.00,'2022-09-28 11:09:51','',''),(2628573,'5','184','957',429,'Sale Id shift 257226',0.00,0.00,0.00,2400.37,0.00,'2022-09-28 11:09:51','',''),(2628574,'5','184','957',429,'Sale Id shift 257226',0.00,0.00,0.00,1865.73,0.00,'2022-09-28 11:09:51','',''),(2628575,'5','184',NULL,429,'Sale Id shift 257226',1311507.55,0.00,0.00,0.00,0.00,'2022-09-28 11:09:51','',''),(2628576,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-28 11:12:05','',''),(2628577,'5','184',NULL,429,'Reception corrector for bridging 132439',0.00,0.00,0.00,45000.00,0.00,'2022-09-28 11:16:10','',''),(2628578,'5','184','958',429,'Received from bridging 132439',0.00,0.00,45000.00,0.00,0.00,'2022-09-28 11:16:10','',''),(2628579,'5','184','957',429,'Sale Id shift 257227',0.00,0.00,0.00,2309.79,0.00,'2022-09-28 16:49:27','',''),(2628580,'5','184','957',429,'Sale Id shift 257227',0.00,0.00,0.00,2155.51,0.00,'2022-09-28 16:49:27','',''),(2628581,'5','184','957',429,'Sale Id shift 257227',0.00,0.00,0.00,2175.63,0.00,'2022-09-28 16:49:27','',''),(2628582,'5','184',NULL,429,'Sale Id shift 257227',1228572.05,0.00,0.00,0.00,0.00,'2022-09-28 16:49:27','',''),(2628583,'5','184','957',429,'Sale Id shift 257228',0.00,0.00,0.00,2107.87,0.00,'2022-09-29 19:41:56','',''),(2628584,'5','184','957',429,'Sale Id shift 257228',0.00,0.00,0.00,1861.86,0.00,'2022-09-29 19:41:56','',''),(2628585,'5','184','957',429,'Sale Id shift 257228',0.00,0.00,0.00,1778.87,0.00,'2022-09-29 19:41:56','',''),(2628586,'5','184','957',429,'Sale Id shift 257228',0.00,0.00,0.00,732.41,0.00,'2022-09-29 19:41:56','',''),(2628587,'5','184',NULL,429,'Sale Id shift 257228',1198986.85,0.00,0.00,0.00,0.00,'2022-09-29 19:41:56','',''),(2628588,'5','184','957',429,'Sale Id shift 257229',0.00,0.00,0.00,2388.63,0.00,'2022-09-30 08:19:17','',''),(2628589,'5','184','957',429,'Sale Id shift 257229',0.00,0.00,0.00,1998.95,0.00,'2022-09-30 08:19:17','',''),(2628590,'5','184','957',429,'Sale Id shift 257229',0.00,0.00,0.00,1953.50,0.00,'2022-09-30 08:19:17','',''),(2628591,'5','184','957',429,'Sale Id shift 257229',0.00,0.00,0.00,594.42,0.00,'2022-09-30 08:19:17','',''),(2628592,'5','184',NULL,429,'Sale Id shift 257229',1283067.50,0.00,0.00,0.00,0.00,'2022-09-30 08:19:17','',''),(2628593,'5','184','958',429,'Sale Id shift 257230',0.00,0.00,0.00,2552.45,0.00,'2022-10-01 10:24:11','',''),(2628594,'5','184','958',429,'Sale Id shift 257230',0.00,0.00,0.00,2458.78,0.00,'2022-10-01 10:24:11','',''),(2628595,'5','184','958',429,'Sale Id shift 257230',0.00,0.00,0.00,1900.52,0.00,'2022-10-01 10:24:11','',''),(2628596,'5','184','957',429,'Sale Id shift 257230',0.00,0.00,0.00,14.93,0.00,'2022-10-01 10:24:11','',''),(2628597,'5','184','957',429,'Sale Id shift 257230',0.00,0.00,0.00,759.50,0.00,'2022-10-01 10:24:11','',''),(2628598,'5','184',NULL,429,'Sale Id shift 257230',1421943.30,0.00,0.00,0.00,0.00,'2022-10-01 10:24:11','',''),(2628599,'5','184','958',429,'Sale Id shift 257231',0.00,0.00,0.00,2324.73,0.00,'2022-10-02 05:08:35','',''),(2628600,'5','184','958',429,'Sale Id shift 257231',0.00,0.00,0.00,2593.43,0.00,'2022-10-02 05:08:35','',''),(2628601,'5','184','958',429,'Sale Id shift 257231',0.00,0.00,0.00,2419.76,0.00,'2022-10-02 05:08:35','',''),(2628602,'5','184',NULL,429,'Sale Id shift 257231',1357515.20,0.00,0.00,0.00,0.00,'2022-10-02 05:08:35','',''),(2628603,'5','184','958',429,'Sale Id shift 257232',0.00,0.00,0.00,2565.58,0.00,'2022-10-03 05:56:51','',''),(2628604,'5','184','958',429,'Sale Id shift 257232',0.00,0.00,0.00,1518.46,0.00,'2022-10-03 05:56:51','',''),(2628605,'5','184','958',429,'Sale Id shift 257232',0.00,0.00,0.00,2271.75,0.00,'2022-10-03 05:56:51','',''),(2628606,'5','184','958',429,'Sale Id shift 257232',0.00,0.00,0.00,1757.35,0.00,'2022-10-03 05:56:51','',''),(2628607,'5','184',NULL,429,'Sale Id shift 257232',1500930.90,0.00,0.00,0.00,0.00,'2022-10-03 05:56:51','',''),(2628608,'5','184','958',429,'Sale Id shift 257233',0.00,0.00,0.00,2567.72,0.00,'2022-10-04 09:07:34','',''),(2628609,'5','184','958',429,'Sale Id shift 257233',0.00,0.00,0.00,781.63,0.00,'2022-10-04 09:07:34','',''),(2628610,'5','184','958',429,'Sale Id shift 257233',0.00,0.00,0.00,2659.16,0.00,'2022-10-04 09:07:34','',''),(2628611,'5','184','958',429,'Sale Id shift 257233',0.00,0.00,0.00,1808.22,0.00,'2022-10-04 09:07:34','',''),(2628612,'5','184',NULL,429,'Sale Id shift 257233',1446095.05,0.00,0.00,0.00,0.00,'2022-10-04 09:07:34','',''),(2628613,'5','184','958',429,'Sale Id shift 257234',0.00,0.00,0.00,3196.67,0.00,'2022-10-05 06:18:04','',''),(2628614,'5','184','958',429,'Sale Id shift 257234',0.00,0.00,0.00,2064.05,0.00,'2022-10-05 06:18:04','',''),(2628615,'5','184','958',429,'Sale Id shift 257234',0.00,0.00,0.00,2548.09,0.00,'2022-10-05 06:18:04','',''),(2628616,'5','184',NULL,429,'Sale Id shift 257234',1444629.85,0.00,0.00,0.00,0.00,'2022-10-05 06:18:04','',''),(2628617,'5','184','958',429,'Sale Id shift 257235',0.00,0.00,0.00,2752.93,0.00,'2022-10-08 18:51:21','',''),(2628618,'5','184','958',429,'Sale Id shift 257235',0.00,0.00,0.00,1799.48,0.00,'2022-10-08 18:51:21','',''),(2628619,'5','184','958',429,'Sale Id shift 257235',0.00,0.00,0.00,2353.00,0.00,'2022-10-08 18:51:21','',''),(2628620,'5','184',NULL,429,'Sale Id shift 257235',1277500.85,0.00,0.00,0.00,0.00,'2022-10-08 18:51:22','',''),(2628621,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8297250.00,44850.00,0.00,0.00,'2022-10-29 09:38:00','',''),(2628622,'5','184',NULL,429,'Reception corrector for bridging 132441',0.00,0.00,0.00,44850.00,0.00,'2022-10-29 11:35:37','',''),(2628623,'5','184','957',429,'Received from bridging 132441',0.00,0.00,44850.00,0.00,0.00,'2022-10-29 11:35:37','',''),(2628624,'5','184','957',429,'Sale Id shift 257256',0.00,0.00,0.00,2591.35,0.00,'2022-10-29 13:30:52','',''),(2628625,'5','184','957',429,'Sale Id shift 257256',0.00,0.00,0.00,4976.76,0.00,'2022-10-29 13:30:52','',''),(2628626,'5','184','957',429,'Sale Id shift 257256',0.00,0.00,0.00,3297.39,0.00,'2022-10-29 13:30:52','',''),(2628627,'5','184',NULL,429,'Sale Id shift 257256',2010117.50,0.00,0.00,0.00,0.00,'2022-10-29 13:30:52','',''),(2628628,'5','184','957',429,'Sale Id shift 257257',0.00,0.00,0.00,1858.55,0.00,'2022-10-30 05:48:47','',''),(2628629,'5','184','957',429,'Sale Id shift 257257',0.00,0.00,0.00,602.30,0.00,'2022-10-30 05:48:47','',''),(2628630,'5','184','957',429,'Sale Id shift 257257',0.00,0.00,0.00,1640.10,0.00,'2022-10-30 05:48:47','',''),(2628631,'5','184','957',429,'Sale Id shift 257257',0.00,0.00,0.00,2436.37,0.00,'2022-10-30 05:48:47','',''),(2628632,'5','184',NULL,429,'Sale Id shift 257257',1209404.20,0.00,0.00,0.00,0.00,'2022-10-30 05:48:47','',''),(2628633,'5','184','957',429,'Sale Id shift 257258',0.00,0.00,0.00,2759.96,0.00,'2022-10-31 06:02:17','',''),(2628634,'5','184','957',429,'Sale Id shift 257258',0.00,0.00,0.00,8.70,0.00,'2022-10-31 06:02:17','',''),(2628635,'5','184','957',429,'Sale Id shift 257258',0.00,0.00,0.00,976.30,0.00,'2022-10-31 06:02:17','',''),(2628636,'5','184','957',429,'Sale Id shift 257258',0.00,0.00,0.00,3850.91,0.00,'2022-10-31 06:02:17','',''),(2628637,'5','184',NULL,429,'Sale Id shift 257258',1405235.95,0.00,0.00,0.00,0.00,'2022-10-31 06:02:17','',''),(2628638,'5','184','957',429,'Sale Id shift 257259',0.00,0.00,0.00,1963.96,0.00,'2022-11-01 05:55:21','',''),(2628639,'5','184','957',429,'Sale Id shift 257259',0.00,0.00,0.00,2968.60,0.00,'2022-11-01 05:55:21','',''),(2628640,'5','184',NULL,429,'Sale Id shift 257259',912523.60,0.00,0.00,0.00,0.00,'2022-11-01 05:55:21','',''),(2628641,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-11-01 12:27:11','',''),(2628642,'5','184',NULL,429,'Reception corrector for bridging 132443',0.00,0.00,0.00,40000.00,0.00,'2022-11-01 16:11:03','',''),(2628643,'5','184','958',429,'Received from bridging 132443',0.00,0.00,40000.00,0.00,0.00,'2022-11-01 16:11:03','',''),(2628644,'5','184','957',429,'Sale Id shift 257260',0.00,0.00,0.00,2752.21,0.00,'2022-11-02 06:03:20','',''),(2628645,'5','184','957',429,'Sale Id shift 257260',0.00,0.00,0.00,4306.18,0.00,'2022-11-02 06:03:20','',''),(2628646,'5','184','957',429,'Sale Id shift 257260',0.00,0.00,0.00,3117.31,0.00,'2022-11-02 06:03:20','',''),(2628647,'5','184',NULL,429,'Sale Id shift 257260',1882504.50,0.00,0.00,0.00,0.00,'2022-11-02 06:03:20','',''),(2628648,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8297250.00,44850.00,0.00,0.00,'2022-11-03 08:15:12','',''),(2628649,'5','184','958',429,'Sale Id shift 257261',0.00,0.00,0.00,826.39,0.00,'2022-11-03 19:23:16','',''),(2628650,'5','184','958',429,'Sale Id shift 257261',0.00,0.00,0.00,3037.90,0.00,'2022-11-03 19:23:16','',''),(2628651,'5','184','958',429,'Sale Id shift 257261',0.00,0.00,0.00,1.51,0.00,'2022-11-03 19:23:16','',''),(2628652,'5','184','957',429,'Sale Id shift 257261',0.00,0.00,0.00,1756.06,0.00,'2022-11-03 19:23:16','',''),(2628653,'5','184','957',429,'Sale Id shift 257261',0.00,0.00,0.00,2913.86,0.00,'2022-11-03 19:23:16','',''),(2628654,'5','184','957',429,'Sale Id shift 257261',0.00,0.00,0.00,369.37,0.00,'2022-11-03 19:23:16','',''),(2628655,'5','184',NULL,429,'Sale Id shift 257261',1647441.65,0.00,0.00,0.00,0.00,'2022-11-03 19:23:16','',''),(2628656,'5','184',NULL,429,'Reception corrector for bridging 132444',0.00,0.00,0.00,44850.00,0.00,'2022-11-04 10:58:59','',''),(2628657,'5','184','957',429,'Received from bridging 132444',0.00,0.00,44850.00,0.00,0.00,'2022-11-04 10:58:59','',''),(2628658,'5','184','958',429,'Sale Id shift 257262',0.00,0.00,0.00,2227.39,0.00,'2022-11-04 10:59:58','',''),(2628659,'5','184','958',429,'Sale Id shift 257262',0.00,0.00,0.00,3126.53,0.00,'2022-11-04 10:59:58','',''),(2628660,'5','184','957',429,'Sale Id shift 257262',0.00,0.00,0.00,4845.98,0.00,'2022-11-04 10:59:58','',''),(2628661,'5','184',NULL,429,'Sale Id shift 257262',1886981.50,0.00,0.00,0.00,0.00,'2022-11-04 10:59:58','',''),(2628662,'5','184','958',429,'Sale Id shift 257263',0.00,0.00,0.00,2480.16,0.00,'2022-11-05 09:00:13','',''),(2628663,'5','184','958',429,'Sale Id shift 257263',0.00,0.00,0.00,3903.90,0.00,'2022-11-05 09:00:13','',''),(2628664,'5','184','957',429,'Sale Id shift 257263',0.00,0.00,0.00,4266.49,0.00,'2022-11-05 09:00:13','',''),(2628665,'5','184',NULL,429,'Sale Id shift 257263',1970351.75,0.00,0.00,0.00,0.00,'2022-11-05 09:00:13','',''),(2628666,'5','184','958',429,'Sale Id shift 257264',0.00,0.00,0.00,2203.60,0.00,'2022-11-05 22:08:36','',''),(2628667,'5','184','958',429,'Sale Id shift 257264',0.00,0.00,0.00,3196.40,0.00,'2022-11-05 22:08:36','',''),(2628668,'5','184','957',429,'Sale Id shift 257264',0.00,0.00,0.00,4527.35,0.00,'2022-11-05 22:08:36','',''),(2628669,'5','184',NULL,429,'Sale Id shift 257264',1836559.75,0.00,0.00,0.00,0.00,'2022-11-05 22:08:36','',''),(2628670,'5','184','958',429,'Sale Id shift 257265',0.00,0.00,0.00,1971.67,0.00,'2022-11-07 06:07:00','',''),(2628671,'5','184','958',429,'Sale Id shift 257265',0.00,0.00,0.00,2760.58,0.00,'2022-11-07 06:07:00','',''),(2628672,'5','184','957',429,'Sale Id shift 257265',0.00,0.00,0.00,5098.58,0.00,'2022-11-07 06:07:00','',''),(2628673,'5','184','957',429,'Sale Id shift 257265',0.00,0.00,0.00,257.83,0.00,'2022-11-07 06:07:00','',''),(2628674,'5','184',NULL,429,'Sale Id shift 257265',1866402.10,0.00,0.00,0.00,0.00,'2022-11-07 06:07:00','',''),(2628675,'5','184','958',429,'Sale Id shift 257266',0.00,0.00,0.00,2065.75,0.00,'2022-11-08 08:18:03','',''),(2628676,'5','184','958',429,'Sale Id shift 257266',0.00,0.00,0.00,557.83,0.00,'2022-11-08 08:18:03','',''),(2628677,'5','184','958',429,'Sale Id shift 257266',0.00,0.00,0.00,2894.21,0.00,'2022-11-08 08:18:03','',''),(2628678,'5','184','957',429,'Sale Id shift 257266',0.00,0.00,0.00,3819.47,0.00,'2022-11-08 08:18:03','',''),(2628679,'5','184',NULL,429,'Sale Id shift 257266',1727393.10,0.00,0.00,0.00,0.00,'2022-11-08 08:18:03','',''),(2628680,'5','184','958',429,'Sale Id shift 257267',0.00,0.00,0.00,1956.81,0.00,'2022-11-09 08:14:55','',''),(2628681,'5','184','958',429,'Sale Id shift 257267',0.00,0.00,0.00,1160.38,0.00,'2022-11-09 08:14:55','',''),(2628682,'5','184','958',429,'Sale Id shift 257267',0.00,0.00,0.00,2678.98,0.00,'2022-11-09 08:14:55','',''),(2628683,'5','184',NULL,429,'Sale Id shift 257267',1072291.45,0.00,0.00,0.00,0.00,'2022-11-09 08:14:55','',''),(2628684,'5','184','958',429,'Sale Id shift 257268',0.00,0.00,0.00,245.36,0.00,'2022-11-10 09:29:41','',''),(2628685,'5','184','958',429,'Sale Id shift 257268',0.00,0.00,0.00,623.06,0.00,'2022-11-10 09:29:41','',''),(2628686,'5','184','958',429,'Sale Id shift 257268',0.00,0.00,0.00,1000.48,0.00,'2022-11-10 09:29:41','',''),(2628687,'5','184','958',429,'Sale Id shift 257268',0.00,0.00,0.00,1188.81,0.00,'2022-11-10 09:29:41','',''),(2628688,'5','184','957',429,'Sale Id shift 257268',0.00,0.00,0.00,7941.96,0.00,'2022-11-10 09:29:41','',''),(2628689,'5','184',NULL,429,'Sale Id shift 257268',2034938.95,0.00,0.00,0.00,0.00,'2022-11-10 09:29:41','',''),(2628690,'5','184','957',429,'Sale Id shift 257269',0.00,0.00,0.00,2664.31,0.00,'2022-11-11 09:27:22','',''),(2628691,'5','184','957',429,'Sale Id shift 257269',0.00,0.00,0.00,4379.65,0.00,'2022-11-11 09:27:22','',''),(2628692,'5','184',NULL,429,'Sale Id shift 257269',1303132.60,0.00,0.00,0.00,0.00,'2022-11-11 09:27:22','',''),(2628693,'5','184','957',429,'Sale Id shift 257270',0.00,0.00,0.00,2201.75,0.00,'2022-11-12 09:29:11','',''),(2628694,'5','184','957',429,'Sale Id shift 257270',0.00,0.00,0.00,1358.90,0.00,'2022-11-12 09:29:11','',''),(2628695,'5','184','957',429,'Sale Id shift 257270',0.00,0.00,0.00,3405.77,0.00,'2022-11-12 09:29:11','',''),(2628696,'5','184',NULL,429,'Sale Id shift 257270',1288787.70,0.00,0.00,0.00,0.00,'2022-11-12 09:29:11','',''),(2628697,'5','184','957',429,'Sale Id shift 257271',0.00,0.00,0.00,390.03,0.00,'2022-11-13 06:01:10','',''),(2628698,'5','184',NULL,429,'Sale Id shift 257271',72155.55,0.00,0.00,0.00,0.00,'2022-11-13 06:01:10','',''),(2628699,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-11-20 21:08:14','',''),(2628700,'5','184',NULL,429,'Reception corrector for bridging 132445',0.00,0.00,0.00,40000.00,0.00,'2022-11-21 08:05:13','',''),(2628701,'5','184','957',429,'Received from bridging 132445',0.00,0.00,40000.00,0.00,0.00,'2022-11-21 08:05:13','',''),(2628702,'5','184','957',429,'Sale Id shift 257279',0.00,0.00,0.00,834.48,0.00,'2022-11-21 10:10:57','',''),(2628703,'5','184','957',429,'Sale Id shift 257279',0.00,0.00,0.00,1895.30,0.00,'2022-11-21 10:10:57','',''),(2628704,'5','184',NULL,429,'Sale Id shift 257279',505009.30,0.00,0.00,0.00,0.00,'2022-11-21 10:10:57','',''),(2628705,'5','184','959',0,'Tank level zero out for dipping',0.00,0.00,0.00,24739.02,0.00,'2022-11-21 14:04:48','',''),(2628706,'5','184','959',0,'Inventory adjustment from tank dipping to 500',0.00,0.00,500.00,0.00,0.00,'2022-11-21 14:04:48','',''),(2628707,'5','184','957',429,'Sale Id shift 257280',0.00,0.00,0.00,1983.79,0.00,'2022-11-22 08:12:26','',''),(2628708,'5','184','957',429,'Sale Id shift 257280',0.00,0.00,0.00,3713.27,0.00,'2022-11-22 08:12:26','',''),(2628709,'5','184','957',429,'Sale Id shift 257280',0.00,0.00,0.00,3035.41,0.00,'2022-11-22 08:12:26','',''),(2628710,'5','184',NULL,429,'Sale Id shift 257280',1615506.95,0.00,0.00,0.00,0.00,'2022-11-22 08:12:26','',''),(2628711,'5','184','957',429,'Sale Id shift 257281',0.00,0.00,0.00,373.36,0.00,'2022-11-23 06:11:41','',''),(2628712,'5','184','957',429,'Sale Id shift 257281',0.00,0.00,0.00,4303.00,0.00,'2022-11-23 06:11:41','',''),(2628713,'5','184','957',429,'Sale Id shift 257281',0.00,0.00,0.00,2491.04,0.00,'2022-11-23 06:11:41','',''),(2628714,'5','184',NULL,429,'Sale Id shift 257281',1325969.00,0.00,0.00,0.00,0.00,'2022-11-23 06:11:41','',''),(2628715,'5','184','957',429,'Sale Id shift 257282',0.00,0.00,0.00,2076.83,0.00,'2022-11-24 06:45:59','',''),(2628716,'5','184','957',429,'Sale Id shift 257282',0.00,0.00,0.00,4309.99,0.00,'2022-11-24 06:45:59','',''),(2628717,'5','184','957',429,'Sale Id shift 257282',0.00,0.00,0.00,1774.48,0.00,'2022-11-24 06:45:59','',''),(2628718,'5','184',NULL,429,'Sale Id shift 257282',1509840.50,0.00,0.00,0.00,0.00,'2022-11-24 06:45:59','',''),(2628719,'5','184','957',429,'Sale Id shift 257283',0.00,0.00,0.00,1947.53,0.00,'2022-11-25 06:09:03','',''),(2628720,'5','184','957',429,'Sale Id shift 257283',0.00,0.00,0.00,2640.74,0.00,'2022-11-25 06:09:03','',''),(2628721,'5','184','957',429,'Sale Id shift 257283',0.00,0.00,0.00,1672.64,0.00,'2022-11-25 06:09:03','',''),(2628722,'5','184',NULL,429,'Sale Id shift 257283',1158268.35,0.00,0.00,0.00,0.00,'2022-11-25 06:09:03','',''),(2628723,'5','184','957',429,'Sale Id shift 257284',0.00,0.00,0.00,1258.20,0.00,'2022-11-26 09:24:10','',''),(2628724,'5','184','957',429,'Sale Id shift 257284',0.00,0.00,0.00,2043.02,0.00,'2022-11-26 09:24:10','',''),(2628725,'5','184','957',429,'Sale Id shift 257284',0.00,0.00,0.00,2104.44,0.00,'2022-11-26 09:24:10','',''),(2628726,'5','184',NULL,429,'Sale Id shift 257284',1000047.10,0.00,0.00,0.00,0.00,'2022-11-26 09:24:10','',''),(2628727,'5','184','957',429,'Sale Id shift 257285',0.00,0.00,0.00,770.56,0.00,'2022-11-27 09:29:51','',''),(2628728,'5','184','957',429,'Sale Id shift 257285',0.00,0.00,0.00,695.83,0.00,'2022-11-27 09:29:51','',''),(2628729,'5','184',NULL,429,'Sale Id shift 257285',271282.15,0.00,0.00,0.00,0.00,'2022-11-27 09:29:51','',''),(2628730,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8288000.00,44800.00,0.00,0.00,'2022-11-30 07:41:39','',''),(2628731,'5','184',NULL,429,'Reception corrector for bridging 132446',0.00,0.00,0.00,44800.00,0.00,'2022-11-30 07:52:37','',''),(2628732,'5','184','957',429,'Received from bridging 132446',0.00,0.00,44800.00,0.00,0.00,'2022-11-30 07:52:37','',''),(2628733,'5','184','957',429,'Sale Id shift 257288',0.00,0.00,0.00,476.56,0.00,'2022-11-30 11:00:15','',''),(2628734,'5','184','957',429,'Sale Id shift 257288',0.00,0.00,0.00,1214.90,0.00,'2022-11-30 11:00:15','',''),(2628735,'5','184','957',429,'Sale Id shift 257288',0.00,0.00,0.00,1311.45,0.00,'2022-11-30 11:00:15','',''),(2628736,'5','184',NULL,429,'Sale Id shift 257288',555538.35,0.00,0.00,0.00,0.00,'2022-11-30 11:00:15','',''),(2628737,'5','184','957',429,'Sale Id shift 257289',0.00,0.00,0.00,3586.94,0.00,'2022-12-01 06:04:29','',''),(2628738,'5','184','957',429,'Sale Id shift 257289',0.00,0.00,0.00,5109.85,0.00,'2022-12-01 06:04:29','',''),(2628739,'5','184','957',429,'Sale Id shift 257289',0.00,0.00,0.00,4967.31,0.00,'2022-12-01 06:04:29','',''),(2628740,'5','184',NULL,429,'Sale Id shift 257289',2527858.50,0.00,0.00,0.00,0.00,'2022-12-01 06:04:29','',''),(2628741,'5','184','957',429,'Sale Id shift 257290',0.00,0.00,0.00,1568.47,0.00,'2022-12-02 06:13:18','',''),(2628742,'5','184','957',429,'Sale Id shift 257290',0.00,0.00,0.00,4163.98,0.00,'2022-12-02 06:13:18','',''),(2628743,'5','184',NULL,429,'Sale Id shift 257290',1060503.25,0.00,0.00,0.00,0.00,'2022-12-02 06:13:18','',''),(2628744,'5','184','957',429,'Sale Id shift 257291',0.00,0.00,0.00,1564.32,0.00,'2022-12-03 10:11:44','',''),(2628745,'5','184','957',429,'Sale Id shift 257291',0.00,0.00,0.00,1889.33,0.00,'2022-12-03 10:11:44','',''),(2628746,'5','184','957',429,'Sale Id shift 257291',0.00,0.00,0.00,4675.02,0.00,'2022-12-03 10:11:44','',''),(2628747,'5','184',NULL,429,'Sale Id shift 257291',1503803.95,0.00,0.00,0.00,0.00,'2022-12-03 10:11:44','',''),(2628748,'5','184','957',429,'Sale Id shift 257292',0.00,0.00,0.00,1691.30,0.00,'2022-12-04 09:07:04','',''),(2628749,'5','184','957',429,'Sale Id shift 257292',0.00,0.00,0.00,4193.80,0.00,'2022-12-04 09:07:04','',''),(2628750,'5','184',NULL,429,'Sale Id shift 257292',1088743.50,0.00,0.00,0.00,0.00,'2022-12-04 09:07:04','',''),(2628751,'5','184','957',429,'Sale Id shift 257293',0.00,0.00,0.00,1302.65,0.00,'2022-12-05 06:06:32','',''),(2628752,'5','184','957',429,'Sale Id shift 257293',0.00,0.00,0.00,4293.96,0.00,'2022-12-05 06:06:32','',''),(2628753,'5','184',NULL,429,'Sale Id shift 257293',1035372.85,0.00,0.00,0.00,0.00,'2022-12-05 06:06:32','',''),(2628754,'5','184','957',429,'Sale Id shift 257294',0.00,0.00,0.00,2956.07,0.00,'2022-12-06 15:17:34','',''),(2628755,'5','184',NULL,429,'Sale Id shift 257294',546872.95,0.00,0.00,0.00,0.00,'2022-12-06 15:17:34','',''),(2628756,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-12-18 21:12:34','',''),(2628757,'5','184',NULL,429,'Reception corrector for bridging 132447',0.00,0.00,0.00,30000.00,0.00,'2022-12-19 14:29:30','',''),(2628758,'5','184','957',429,'Received from bridging 132447',0.00,0.00,30000.00,0.00,0.00,'2022-12-19 14:29:30','',''),(2628759,'5','184','957',429,'Sale Id shift 257307',0.00,0.00,0.00,1419.23,0.00,'2022-12-20 12:15:28','',''),(2628760,'5','184','957',429,'Sale Id shift 257307',0.00,0.00,0.00,839.01,0.00,'2022-12-20 12:15:28','',''),(2628761,'5','184',NULL,429,'Sale Id shift 257307',417774.40,0.00,0.00,0.00,0.00,'2022-12-20 12:15:28','',''),(2628762,'5','184','957',429,'Sale Id shift 257308',0.00,0.00,0.00,1238.38,0.00,'2022-12-20 13:45:10','',''),(2628763,'5','184','957',429,'Sale Id shift 257308',0.00,0.00,0.00,3238.11,0.00,'2022-12-20 13:45:10','',''),(2628764,'5','184','957',429,'Sale Id shift 257308',0.00,0.00,0.00,1701.25,0.00,'2022-12-20 13:45:10','',''),(2628765,'5','184',NULL,429,'Sale Id shift 257308',1142881.90,0.00,0.00,0.00,0.00,'2022-12-20 13:45:10','',''),(2628766,'5','184','957',429,'Sale Id shift 257309',0.00,0.00,0.00,2589.35,0.00,'2022-12-21 10:38:14','',''),(2628767,'5','184','957',429,'Sale Id shift 257309',0.00,0.00,0.00,4678.13,0.00,'2022-12-21 10:38:14','',''),(2628768,'5','184',NULL,429,'Sale Id shift 257309',1344483.80,0.00,0.00,0.00,0.00,'2022-12-21 10:38:14','',''),(2628769,'5','184','957',429,'Sale Id shift 257310',0.00,0.00,0.00,3300.71,0.00,'2022-12-21 19:17:57','',''),(2628770,'5','184','957',429,'Sale Id shift 257310',0.00,0.00,0.00,5199.55,0.00,'2022-12-21 19:17:57','',''),(2628771,'5','184',NULL,429,'Sale Id shift 257310',1572548.10,0.00,0.00,0.00,0.00,'2022-12-21 19:17:57','',''),(2628772,'5','184','957',429,'Sale Id shift 257311',0.00,0.00,0.00,3015.76,0.00,'2022-12-23 09:57:56','',''),(2628773,'5','184',NULL,429,'Sale Id shift 257311',557915.60,0.00,0.00,0.00,0.00,'2022-12-23 09:57:56','',''),(2628774,'5','184','957',429,'Sale Id shift 257312',0.00,0.00,0.00,2339.28,0.00,'2022-12-24 09:01:08','',''),(2628775,'5','184','957',429,'Sale Id shift 257312',0.00,0.00,0.00,381.14,0.00,'2022-12-24 09:01:08','',''),(2628776,'5','184',NULL,429,'Sale Id shift 257312',503277.70,0.00,0.00,0.00,0.00,'2022-12-24 09:01:08','',''),(2628777,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7196500.00,38900.00,0.00,0.00,'2023-01-17 16:24:19','',''),(2628778,'5','184',NULL,429,'Reception corrector for bridging 132448',0.00,0.00,0.00,38900.00,0.00,'2023-01-17 18:23:15','',''),(2628779,'5','184','957',429,'Received from bridging 132448',0.00,0.00,38900.00,0.00,0.00,'2023-01-17 18:23:15','',''),(2628780,'5','184','957',429,'Sale Id shift 257337',0.00,0.00,0.00,2850.75,0.00,'2023-01-18 09:26:14','',''),(2628781,'5','184','957',429,'Sale Id shift 257337',0.00,0.00,0.00,2255.55,0.00,'2023-01-18 09:26:14','',''),(2628782,'5','184','957',429,'Sale Id shift 257337',0.00,0.00,0.00,2117.84,0.00,'2023-01-18 09:26:14','',''),(2628783,'5','184',NULL,429,'Sale Id shift 257337',1336465.90,0.00,0.00,0.00,0.00,'2023-01-18 09:26:14','',''),(2628784,'5','184','957',429,'Sale Id shift 257338',0.00,0.00,0.00,2646.89,0.00,'2023-01-19 09:34:30','',''),(2628785,'5','184','957',429,'Sale Id shift 257338',0.00,0.00,0.00,5338.87,0.00,'2023-01-19 09:34:30','',''),(2628786,'5','184','957',429,'Sale Id shift 257338',0.00,0.00,0.00,3675.44,0.00,'2023-01-19 09:34:30','',''),(2628787,'5','184',NULL,429,'Sale Id shift 257338',2157322.00,0.00,0.00,0.00,0.00,'2023-01-19 09:34:30','',''),(2628788,'5','184','957',429,'Sale Id shift 257339',0.00,0.00,0.00,2159.62,0.00,'2023-01-19 19:20:55','',''),(2628789,'5','184','957',429,'Sale Id shift 257339',0.00,0.00,0.00,4408.16,0.00,'2023-01-19 19:20:55','',''),(2628790,'5','184','957',429,'Sale Id shift 257339',0.00,0.00,0.00,567.77,0.00,'2023-01-19 19:20:55','',''),(2628791,'5','184',NULL,429,'Sale Id shift 257339',1320076.75,0.00,0.00,0.00,0.00,'2023-01-19 19:20:55','',''),(2628792,'5','184','957',429,'Sale Id shift 257340',0.00,0.00,0.00,2174.72,0.00,'2023-01-21 10:51:03','',''),(2628793,'5','184','957',429,'Sale Id shift 257340',0.00,0.00,0.00,2432.17,0.00,'2023-01-21 10:51:03','',''),(2628794,'5','184','957',429,'Sale Id shift 257340',0.00,0.00,0.00,1152.08,0.00,'2023-01-21 10:51:03','',''),(2628795,'5','184',NULL,429,'Sale Id shift 257340',1065409.45,0.00,0.00,0.00,0.00,'2023-01-21 10:51:03','',''),(2628796,'5','184','957',429,'Sale Id shift 257341',0.00,0.00,0.00,1751.87,0.00,'2023-01-22 20:43:03','',''),(2628797,'5','184','957',429,'Sale Id shift 257341',0.00,0.00,0.00,2706.06,0.00,'2023-01-22 20:43:03','',''),(2628798,'5','184',NULL,429,'Sale Id shift 257341',824717.05,0.00,0.00,0.00,0.00,'2023-01-22 20:43:03','',''),(2628799,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,2759.59,0.00,'2023-01-23 15:49:03','',''),(2628800,'5','184','957',0,'Inventory adjustment from tank dipping to 2760',0.00,0.00,2760.00,0.00,0.00,'2023-01-23 15:49:03','',''),(2628801,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,448.54,0.00,'2023-01-23 15:49:23','',''),(2628802,'5','184','958',0,'Inventory adjustment from tank dipping to 3282',0.00,0.00,3282.00,0.00,0.00,'2023-01-23 15:49:23','',''),(2628803,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,3282.00,0.00,'2023-01-23 15:50:08','',''),(2628804,'5','184','958',0,'Inventory adjustment from tank dipping to 500',0.00,0.00,500.00,0.00,0.00,'2023-01-23 15:50:08','',''),(2628805,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,2760.00,0.00,'2023-01-23 21:40:18','',''),(2628806,'5','184','957',0,'Inventory adjustment from tank dipping to 3000',0.00,0.00,3000.00,0.00,0.00,'2023-01-23 21:40:18','',''),(2628807,'5','184','958',0,'Tank level zero out for dipping',0.00,0.00,0.00,500.00,0.00,'2023-01-23 21:40:38','',''),(2628808,'5','184','958',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2023-01-23 21:40:38','',''),(2628809,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,3000.00,0.00,'2023-01-24 09:22:26','',''),(2628810,'5','184','957',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2023-01-24 09:22:26','',''),(2628811,'5','184','957',429,'Sale Id shift 257342',0.00,0.00,0.00,1826.50,0.00,'2023-01-25 09:39:54','',''),(2628812,'5','184','957',429,'Sale Id shift 257342',0.00,0.00,0.00,1455.24,0.00,'2023-01-25 09:39:54','',''),(2628813,'5','184',NULL,429,'Sale Id shift 257342',607121.90,0.00,0.00,0.00,0.00,'2023-01-25 09:39:54','',''),(2628814,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6930000.00,31500.00,0.00,0.00,'2023-01-27 08:24:33','',''),(2628815,'5','184',NULL,429,'Reception corrector for bridging 132449',0.00,0.00,0.00,31500.00,0.00,'2023-01-27 16:31:27','',''),(2628816,'5','184','957',429,'Received from bridging 132449',0.00,0.00,31500.00,0.00,0.00,'2023-01-27 16:31:27','',''),(2628817,'5','184','957',429,'Sale Id shift 257347',0.00,0.00,0.00,1774.42,0.00,'2023-01-28 23:53:16','',''),(2628818,'5','184','957',429,'Sale Id shift 257347',0.00,0.00,0.00,3609.43,0.00,'2023-01-28 23:53:16','',''),(2628819,'5','184','957',429,'Sale Id shift 257347',0.00,0.00,0.00,2191.24,0.00,'2023-01-28 23:53:16','',''),(2628820,'5','184',NULL,429,'Sale Id shift 257347',1666519.80,0.00,0.00,0.00,0.00,'2023-01-28 23:53:16','',''),(2628821,'5','184','957',429,'Sale Id shift 257348',0.00,0.00,0.00,1957.61,0.00,'2023-01-29 21:10:56','',''),(2628822,'5','184','957',429,'Sale Id shift 257348',0.00,0.00,0.00,3209.20,0.00,'2023-01-29 21:10:56','',''),(2628823,'5','184','957',429,'Sale Id shift 257348',0.00,0.00,0.00,2651.57,0.00,'2023-01-29 21:10:56','',''),(2628824,'5','184',NULL,429,'Sale Id shift 257348',1720043.60,0.00,0.00,0.00,0.00,'2023-01-29 21:10:56','',''),(2628825,'5','184','957',429,'Sale Id shift 257349',0.00,0.00,0.00,1323.69,0.00,'2023-01-30 09:49:59','',''),(2628826,'5','184','957',429,'Sale Id shift 257349',0.00,0.00,0.00,3008.83,0.00,'2023-01-30 09:49:59','',''),(2628827,'5','184','957',429,'Sale Id shift 257349',0.00,0.00,0.00,2152.54,0.00,'2023-01-30 09:49:59','',''),(2628828,'5','184',NULL,429,'Sale Id shift 257349',1426713.20,0.00,0.00,0.00,0.00,'2023-01-30 09:49:59','',''),(2628829,'5','184','957',429,'Sale Id shift 257350',0.00,0.00,0.00,1138.45,0.00,'2023-01-31 09:54:28','',''),(2628830,'5','184','957',429,'Sale Id shift 257350',0.00,0.00,0.00,5099.77,0.00,'2023-01-31 09:54:28','',''),(2628831,'5','184','957',429,'Sale Id shift 257350',0.00,0.00,0.00,3580.38,0.00,'2023-01-31 09:54:28','',''),(2628832,'5','184',NULL,429,'Sale Id shift 257350',2160092.00,0.00,0.00,0.00,0.00,'2023-01-31 09:54:28','',''),(2628833,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3696000.00,16800.00,0.00,0.00,'2023-02-03 09:17:12','',''),(2628834,'5','184',NULL,429,'Reception corrector for bridging 132450',0.00,0.00,0.00,16800.00,0.00,'2023-02-03 11:44:36','',''),(2628835,'5','184','957',429,'Received from bridging 132450',0.00,0.00,16800.00,0.00,0.00,'2023-02-03 11:44:36','',''),(2628836,'5','184','957',429,'Sale Id shift 257353',0.00,0.00,0.00,1999.49,0.00,'2023-02-04 18:10:16','',''),(2628837,'5','184','957',429,'Sale Id shift 257353',0.00,0.00,0.00,1802.11,0.00,'2023-02-04 18:10:16','',''),(2628838,'5','184','957',429,'Sale Id shift 257353',0.00,0.00,0.00,2484.67,0.00,'2023-02-04 18:10:16','',''),(2628839,'5','184',NULL,429,'Sale Id shift 257353',1382979.40,0.00,0.00,0.00,0.00,'2023-02-04 18:10:16','',''),(2628840,'5','184','957',429,'Sale Id shift 257354',0.00,0.00,0.00,354.53,0.00,'2023-02-05 20:46:29','',''),(2628841,'5','184','957',429,'Sale Id shift 257354',0.00,0.00,0.00,2128.40,0.00,'2023-02-05 20:46:29','',''),(2628842,'5','184','957',429,'Sale Id shift 257354',0.00,0.00,0.00,1559.02,0.00,'2023-02-05 20:46:29','',''),(2628843,'5','184',NULL,429,'Sale Id shift 257354',889229.00,0.00,0.00,0.00,0.00,'2023-02-05 20:46:29','',''),(2628844,'5','184','957',429,'Sale Id shift 257355',0.00,0.00,0.00,732.30,0.00,'2023-02-06 13:48:06','',''),(2628845,'5','184','957',429,'Sale Id shift 257355',0.00,0.00,0.00,3212.69,0.00,'2023-02-06 13:48:06','',''),(2628846,'5','184','957',429,'Sale Id shift 257355',0.00,0.00,0.00,2138.15,0.00,'2023-02-06 13:48:06','',''),(2628847,'5','184',NULL,429,'Sale Id shift 257355',1338290.80,0.00,0.00,0.00,0.00,'2023-02-06 13:48:06','',''),(2628848,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,409.77,0.00,'2023-02-07 10:40:16','',''),(2628849,'5','184','957',0,'Inventory adjustment from tank dipping to 750',0.00,0.00,750.00,0.00,0.00,'2023-02-07 10:40:16','',''),(2628850,'5','184','957',429,'Sale Id shift 257356',0.00,0.00,0.00,578.21,0.00,'2023-02-07 13:03:27','',''),(2628851,'5','184',NULL,429,'Sale Id shift 257356',127206.20,0.00,0.00,0.00,0.00,'2023-02-07 13:03:27','',''),(2628852,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3300000.00,15000.00,0.00,0.00,'2023-02-09 09:21:24','',''),(2628853,'5','184',NULL,429,'Reception corrector for bridging 132451',0.00,0.00,0.00,15000.00,0.00,'2023-02-10 14:25:16','',''),(2628854,'5','184','957',429,'Received from bridging 132451',0.00,0.00,15000.00,0.00,0.00,'2023-02-10 14:25:16','',''),(2628855,'5','184','957',429,'Sale Id shift 257359',0.00,0.00,0.00,2539.30,0.00,'2023-02-10 15:48:42','',''),(2628856,'5','184','957',429,'Sale Id shift 257359',0.00,0.00,0.00,2277.65,0.00,'2023-02-10 15:48:42','',''),(2628857,'5','184','957',429,'Sale Id shift 257359',0.00,0.00,0.00,1458.07,0.00,'2023-02-10 15:48:42','',''),(2628858,'5','184',NULL,429,'Sale Id shift 257359',1380504.40,0.00,0.00,0.00,0.00,'2023-02-10 15:48:42','',''),(2628859,'5','184','957',429,'Sale Id shift 257360',0.00,0.00,0.00,1718.80,0.00,'2023-02-11 12:40:23','',''),(2628860,'5','184','957',429,'Sale Id shift 257360',0.00,0.00,0.00,1863.83,0.00,'2023-02-11 12:40:23','',''),(2628861,'5','184','957',429,'Sale Id shift 257360',0.00,0.00,0.00,2383.64,0.00,'2023-02-11 12:40:23','',''),(2628862,'5','184',NULL,429,'Sale Id shift 257360',1312579.40,0.00,0.00,0.00,0.00,'2023-02-11 12:40:23','',''),(2628863,'5','184','957',429,'Sale Id shift 257361',0.00,0.00,0.00,1389.82,0.00,'2023-02-12 09:18:41','',''),(2628864,'5','184','957',429,'Sale Id shift 257361',0.00,0.00,0.00,1387.68,0.00,'2023-02-12 09:18:41','',''),(2628865,'5','184',NULL,429,'Sale Id shift 257361',611050.00,0.00,0.00,0.00,0.00,'2023-02-12 09:18:41','',''),(2628866,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6237000.00,29700.00,0.00,0.00,'2023-02-24 21:49:54','',''),(2628867,'5','184',NULL,429,'Reception corrector for bridging 132452',0.00,0.00,0.00,29700.00,0.00,'2023-02-25 21:23:51','',''),(2628868,'5','184','957',429,'Received from bridging 132452',0.00,0.00,29700.00,0.00,0.00,'2023-02-25 21:23:51','',''),(2628869,'5','184','957',429,'Sale Id shift 257372',0.00,0.00,0.00,413.70,0.00,'2023-02-26 13:03:00','',''),(2628870,'5','184','957',429,'Sale Id shift 257372',0.00,0.00,0.00,836.16,0.00,'2023-02-26 13:03:00','',''),(2628871,'5','184',NULL,429,'Sale Id shift 257372',262470.60,0.00,0.00,0.00,0.00,'2023-02-26 13:03:00','',''),(2628872,'5','184','957',429,'Sale Id shift 257374',0.00,0.00,0.00,1361.49,0.00,'2023-02-27 13:10:19','',''),(2628873,'5','184','957',429,'Sale Id shift 257374',0.00,0.00,0.00,1683.93,0.00,'2023-02-27 13:10:19','',''),(2628874,'5','184','957',429,'Sale Id shift 257374',0.00,0.00,0.00,1563.88,0.00,'2023-02-27 13:10:19','',''),(2628875,'5','184',NULL,429,'Sale Id shift 257374',967953.00,0.00,0.00,0.00,0.00,'2023-02-27 13:10:19','',''),(2628876,'5','184','957',429,'Sale Id shift 257375',0.00,0.00,0.00,1708.05,0.00,'2023-02-27 22:49:48','',''),(2628877,'5','184','957',429,'Sale Id shift 257375',0.00,0.00,0.00,1909.92,0.00,'2023-02-27 22:49:48','',''),(2628878,'5','184','957',429,'Sale Id shift 257375',0.00,0.00,0.00,1331.75,0.00,'2023-02-27 22:49:48','',''),(2628879,'5','184',NULL,429,'Sale Id shift 257375',1039441.20,0.00,0.00,0.00,0.00,'2023-02-27 22:49:48','',''),(2628880,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,9408000.00,44800.00,0.00,0.00,'2023-02-28 20:22:09','',''),(2628881,'5','184','957',429,'Sale Id shift 257376',0.00,0.00,0.00,1852.72,0.00,'2023-02-28 20:22:24','',''),(2628882,'5','184','957',429,'Sale Id shift 257376',0.00,0.00,0.00,2670.87,0.00,'2023-02-28 20:22:24','',''),(2628883,'5','184','957',429,'Sale Id shift 257376',0.00,0.00,0.00,2098.15,0.00,'2023-02-28 20:22:24','',''),(2628884,'5','184',NULL,429,'Sale Id shift 257376',1390565.40,0.00,0.00,0.00,0.00,'2023-02-28 20:22:24','',''),(2628885,'5','184','957',429,'Sale Id shift 257377',0.00,0.00,0.00,2615.68,0.00,'2023-03-02 09:44:01','',''),(2628886,'5','184','957',429,'Sale Id shift 257377',0.00,0.00,0.00,3070.48,0.00,'2023-03-02 09:44:01','',''),(2628887,'5','184','957',429,'Sale Id shift 257377',0.00,0.00,0.00,2410.76,0.00,'2023-03-02 09:44:01','',''),(2628888,'5','184',NULL,429,'Sale Id shift 257377',1700353.20,0.00,0.00,0.00,0.00,'2023-03-02 09:44:01','',''),(2628889,'5','184',NULL,429,'Reception corrector for bridging 132453',0.00,0.00,0.00,44800.00,0.00,'2023-03-03 08:20:54','',''),(2628890,'5','184','958',429,'Received from bridging 132453',0.00,0.00,44800.00,0.00,0.00,'2023-03-03 08:20:54','',''),(2628891,'5','184','958',429,'Sale Id shift 257378',0.00,0.00,0.00,2927.73,0.00,'2023-03-03 13:18:54','',''),(2628892,'5','184','957',429,'Sale Id shift 257378',0.00,0.00,0.00,2210.78,0.00,'2023-03-03 13:18:54','',''),(2628893,'5','184','957',429,'Sale Id shift 257378',0.00,0.00,0.00,1986.67,0.00,'2023-03-03 13:18:54','',''),(2628894,'5','184',NULL,429,'Sale Id shift 257378',1496287.80,0.00,0.00,0.00,0.00,'2023-03-03 13:18:54','',''),(2628895,'5','184','958',429,'Sale Id shift 257379',0.00,0.00,0.00,2685.41,0.00,'2023-03-04 12:41:06','',''),(2628896,'5','184','958',429,'Sale Id shift 257379',0.00,0.00,0.00,2729.38,0.00,'2023-03-04 12:41:06','',''),(2628897,'5','184','958',429,'Sale Id shift 257379',0.00,0.00,0.00,2766.01,0.00,'2023-03-04 12:41:06','',''),(2628898,'5','184',NULL,429,'Sale Id shift 257379',1717968.00,0.00,0.00,0.00,0.00,'2023-03-04 12:41:06','',''),(2628899,'5','184','958',429,'Sale Id shift 257380',0.00,0.00,0.00,2680.68,0.00,'2023-03-05 14:55:09','',''),(2628900,'5','184','958',429,'Sale Id shift 257380',0.00,0.00,0.00,2477.27,0.00,'2023-03-05 14:55:09','',''),(2628901,'5','184','958',429,'Sale Id shift 257380',0.00,0.00,0.00,2906.57,0.00,'2023-03-05 14:55:09','',''),(2628902,'5','184',NULL,429,'Sale Id shift 257380',1693549.20,0.00,0.00,0.00,0.00,'2023-03-05 14:55:09','',''),(2628903,'5','184','958',429,'Sale Id shift 257381',0.00,0.00,0.00,3153.21,0.00,'2023-03-06 09:41:29','',''),(2628904,'5','184','958',429,'Sale Id shift 257381',0.00,0.00,0.00,3626.43,0.00,'2023-03-06 09:41:29','',''),(2628905,'5','184','958',429,'Sale Id shift 257381',0.00,0.00,0.00,3577.57,0.00,'2023-03-06 09:41:29','',''),(2628906,'5','184',NULL,429,'Sale Id shift 257381',2175014.10,0.00,0.00,0.00,0.00,'2023-03-06 09:41:29','',''),(2628907,'5','184','958',429,'Sale Id shift 257382',0.00,0.00,0.00,2219.38,0.00,'2023-03-06 21:16:59','',''),(2628908,'5','184','958',429,'Sale Id shift 257382',0.00,0.00,0.00,2342.75,0.00,'2023-03-06 21:16:59','',''),(2628909,'5','184','958',429,'Sale Id shift 257382',0.00,0.00,0.00,2680.99,0.00,'2023-03-06 21:16:59','',''),(2628910,'5','184',NULL,429,'Sale Id shift 257382',1521055.20,0.00,0.00,0.00,0.00,'2023-03-06 21:16:59','',''),(2628911,'5','184',NULL,429,'Purchased from SALBAS OIL & GAS LIMITED',0.00,10500000.00,50000.00,0.00,0.00,'2023-03-07 10:21:06','',''),(2628912,'5','184',NULL,429,'Reception corrector for bridging 132454',0.00,0.00,0.00,40000.00,0.00,'2023-03-07 13:52:19','',''),(2628913,'5','184','957',429,'Received from bridging 132454',0.00,0.00,40000.00,0.00,0.00,'2023-03-07 13:52:19','',''),(2628914,'5','184',NULL,429,'Reception corrector for bridging 132455',0.00,0.00,0.00,10000.00,0.00,'2023-03-07 13:52:47','',''),(2628915,'5','184','958',429,'Received from bridging 132455',0.00,0.00,10000.00,0.00,0.00,'2023-03-07 13:52:47','',''),(2628916,'5','184','958',429,'Sale Id shift 257385',0.00,0.00,0.00,1214.68,0.00,'2023-03-08 12:17:03','',''),(2628917,'5','184','958',429,'Sale Id shift 257385',0.00,0.00,0.00,3589.31,0.00,'2023-03-08 12:17:03','',''),(2628918,'5','184','958',429,'Sale Id shift 257385',0.00,0.00,0.00,3562.14,0.00,'2023-03-08 12:17:03','',''),(2628919,'5','184','958',429,'Sale Id shift 257385',0.00,0.00,0.00,3192.33,0.00,'2023-03-08 12:17:03','',''),(2628920,'5','184',NULL,429,'Sale Id shift 257385',2427276.60,0.00,0.00,0.00,0.00,'2023-03-08 12:17:03','',''),(2628921,'5','184','958',429,'Sale Id shift 257386',0.00,0.00,0.00,1625.05,0.00,'2023-03-09 09:15:22','',''),(2628922,'5','184','958',429,'Sale Id shift 257386',0.00,0.00,0.00,1522.45,0.00,'2023-03-09 09:15:22','',''),(2628923,'5','184','958',429,'Sale Id shift 257386',0.00,0.00,0.00,1532.17,0.00,'2023-03-09 09:15:22','',''),(2628924,'5','184','958',429,'Sale Id shift 257386',0.00,0.00,0.00,1671.35,0.00,'2023-03-09 09:15:22','',''),(2628925,'5','184','957',429,'Sale Id shift 257386',0.00,0.00,0.00,1078.56,0.00,'2023-03-09 09:15:22','',''),(2628926,'5','184','957',429,'Sale Id shift 257386',0.00,0.00,0.00,806.65,0.00,'2023-03-09 09:15:22','',''),(2628927,'5','184',NULL,429,'Sale Id shift 257386',1729608.30,0.00,0.00,0.00,0.00,'2023-03-09 09:15:22','',''),(2628928,'5','184','957',429,'Sale Id shift 257387',0.00,0.00,0.00,2671.48,0.00,'2023-03-10 13:45:10','',''),(2628929,'5','184','957',429,'Sale Id shift 257387',0.00,0.00,0.00,1978.74,0.00,'2023-03-10 13:45:10','',''),(2628930,'5','184','957',429,'Sale Id shift 257387',0.00,0.00,0.00,2024.61,0.00,'2023-03-10 13:45:10','',''),(2628931,'5','184',NULL,429,'Sale Id shift 257387',1401714.30,0.00,0.00,0.00,0.00,'2023-03-10 13:45:10','',''),(2628932,'5','184','957',429,'Sale Id shift 257388',0.00,0.00,0.00,2758.37,0.00,'2023-03-11 13:21:32','',''),(2628933,'5','184','957',429,'Sale Id shift 257388',0.00,0.00,0.00,2892.51,0.00,'2023-03-11 13:21:32','',''),(2628934,'5','184','957',429,'Sale Id shift 257388',0.00,0.00,0.00,2174.22,0.00,'2023-03-11 13:21:32','',''),(2628935,'5','184',NULL,429,'Sale Id shift 257388',1643271.00,0.00,0.00,0.00,0.00,'2023-03-11 13:21:32','',''),(2628936,'5','184','957',429,'Sale Id shift 257389',0.00,0.00,0.00,2786.20,0.00,'2023-03-12 15:48:29','',''),(2628937,'5','184','957',429,'Sale Id shift 257389',0.00,0.00,0.00,2902.71,0.00,'2023-03-12 15:48:29','',''),(2628938,'5','184','957',429,'Sale Id shift 257389',0.00,0.00,0.00,2914.71,0.00,'2023-03-12 15:48:29','',''),(2628939,'5','184',NULL,429,'Sale Id shift 257389',1806760.20,0.00,0.00,0.00,0.00,'2023-03-12 15:48:29','',''),(2628940,'5','184','957',429,'Sale Id shift 257390',0.00,0.00,0.00,2338.03,0.00,'2023-03-13 09:55:48','',''),(2628941,'5','184','957',429,'Sale Id shift 257390',0.00,0.00,0.00,2556.30,0.00,'2023-03-13 09:55:48','',''),(2628942,'5','184','957',429,'Sale Id shift 257390',0.00,0.00,0.00,2911.74,0.00,'2023-03-13 09:55:48','',''),(2628943,'5','184',NULL,429,'Sale Id shift 257390',1639274.70,0.00,0.00,0.00,0.00,'2023-03-13 09:55:48','',''),(2628944,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,7333.18,0.00,'2023-03-14 11:50:43','',''),(2628945,'5','184','957',0,'Inventory adjustment from tank dipping to 7500',0.00,0.00,7500.00,0.00,0.00,'2023-03-14 11:50:43','',''),(2628946,'5','184','957',0,'Tank level zero out for dipping',0.00,0.00,0.00,7500.00,0.00,'2023-03-14 16:44:36','',''),(2628947,'5','184','957',0,'Inventory adjustment from tank dipping to 7700',0.00,0.00,7700.00,0.00,0.00,'2023-03-14 16:44:36','',''),(2628948,'5','184','957',429,'Sale Id shift 257391',0.00,0.00,0.00,2427.19,0.00,'2023-03-15 12:06:16','',''),(2628949,'5','184','957',429,'Sale Id shift 257391',0.00,0.00,0.00,2519.31,0.00,'2023-03-15 12:06:16','',''),(2628950,'5','184','957',429,'Sale Id shift 257391',0.00,0.00,0.00,2564.03,0.00,'2023-03-15 12:06:16','',''),(2628951,'5','184',NULL,429,'Sale Id shift 257391',1577211.30,0.00,0.00,0.00,0.00,'2023-03-15 12:06:16','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','184',431,-4571.27,'2023-03-20 20:24:33'),(2,'5','184',430,54524.92,'2023-03-20 20:24:33'),(3,'5','184',429,112596.06,'2023-03-20 20:24:33');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1817822 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1030983,'5','184',429,'Sale Id shift 212338',0.00,919272.75,165.00,919272.75,0.00,'2021-07-26 14:14:44'),(1030984,'5','184',430,'Sale Id shift 212338',0.00,88774.80,290.00,88774.80,0.00,'2021-07-26 14:14:44'),(1031035,'5','184',429,'Sale Id shift 213030',0.00,1189800.15,165.00,1189800.15,0.00,'2021-07-26 14:27:04'),(1031036,'5','184',430,'Sale Id shift 213030',0.00,137694.90,290.00,137694.90,0.00,'2021-07-26 14:27:04'),(1031116,'5','184',429,'Sale Id shift 213036',0.00,1226991.15,165.00,1226991.15,0.00,'2021-07-26 14:44:46'),(1031117,'5','184',430,'Sale Id shift 213036',0.00,298259.75,290.00,293204.50,-5055.25,'2021-07-26 14:44:46'),(1031183,'5','184',429,'Sale Id shift 213043',0.00,626153.55,165.00,626153.55,0.00,'2021-07-26 14:58:42'),(1031184,'5','184',430,'Sale Id shift 213043',0.00,28836.25,290.00,28347.50,-488.75,'2021-07-26 14:58:42'),(1031658,'5','184',429,'Sale Id shift 213062',0.00,462392.70,165.00,462392.70,0.00,'2021-07-26 16:22:42'),(1031659,'5','184',430,'Sale Id shift 213062',0.00,11534.50,295.00,11534.50,0.00,'2021-07-26 16:22:42'),(1032944,'5','184',429,'Sale Id shift 213068',0.00,886327.20,165.00,886327.20,0.00,'2021-07-27 09:25:19'),(1032945,'5','184',430,'Sale Id shift 213068',0.00,354504.45,295.00,354504.45,0.00,'2021-07-27 09:25:19'),(1033392,'5','184',429,'Sale Id shift 213228',0.00,1136698.20,165.00,1136698.20,0.00,'2021-07-27 10:39:58'),(1033393,'5','184',430,'Sale Id shift 213228',0.00,277485.85,295.00,277485.85,0.00,'2021-07-27 10:39:58'),(1033477,'5','184',429,'Sale Id shift 213237',0.00,1176864.15,165.00,1176864.15,0.00,'2021-07-27 10:54:35'),(1033478,'5','184',430,'Sale Id shift 213237',0.00,54828.70,295.00,54828.70,0.00,'2021-07-27 10:54:35'),(1033614,'5','184',429,'Sale Id shift 213242',0.00,1525700.55,165.00,1525700.55,0.00,'2021-07-27 11:17:48'),(1033615,'5','184',430,'Sale Id shift 213242',0.00,83676.75,295.00,83676.75,0.00,'2021-07-27 11:17:48'),(1033764,'5','184',429,'Sale Id shift 213260',0.00,1178915.10,165.00,1178915.10,0.00,'2021-07-27 11:45:09'),(1033765,'5','184',430,'Sale Id shift 213260',0.00,78959.70,295.00,78959.70,0.00,'2021-07-27 11:45:09'),(1034157,'5','184',429,'Sale Id shift 213284',0.00,1150884.90,165.00,1150884.90,0.00,'2021-07-27 13:05:31'),(1034158,'5','184',430,'Sale Id shift 213284',0.00,28379.00,295.00,28379.00,0.00,'2021-07-27 13:05:31'),(1034777,'5','184',429,'Sale Id shift 213305',0.00,889554.60,165.00,889554.60,0.00,'2021-07-27 14:44:04'),(1034778,'5','184',430,'Sale Id shift 213305',0.00,32128.45,295.00,32128.45,0.00,'2021-07-27 14:44:04'),(1035516,'5','184',429,'Sale Id shift 213338',0.00,988670.10,165.00,988670.10,0.00,'2021-07-27 16:26:54'),(1035517,'5','184',430,'Sale Id shift 213338',0.00,46730.95,295.00,46730.95,0.00,'2021-07-27 16:26:54'),(1035617,'5','184',429,'Sale Id shift 213346',0.00,1174441.95,165.00,1174441.95,0.00,'2021-07-27 16:43:07'),(1035618,'5','184',430,'Sale Id shift 213346',0.00,298472.15,295.00,298472.15,0.00,'2021-07-27 16:43:07'),(1037667,'5','184',429,'Sale Id shift 213481',0.00,1214188.80,165.00,1214188.80,0.00,'2021-07-28 11:48:48'),(1037668,'5','184',430,'Sale Id shift 213481',0.00,32745.00,295.00,32745.00,0.00,'2021-07-28 11:48:48'),(1037729,'5','184',429,'Sale Id shift 213502',0.00,869074.80,165.00,869074.80,0.00,'2021-07-28 11:57:38'),(1037805,'5','184',429,'Sale Id shift 213509',0.00,1011611.70,165.00,1011611.70,0.00,'2021-07-28 12:17:26'),(1037806,'5','184',430,'Sale Id shift 213509',0.00,61020.75,295.00,61020.75,0.00,'2021-07-28 12:17:26'),(1040160,'5','184',429,'Sale Id shift 213562',0.00,1001175.45,165.00,1001175.45,0.00,'2021-07-29 08:56:30'),(1040161,'5','184',430,'Sale Id shift 213562',0.00,299386.65,295.00,299386.65,0.00,'2021-07-29 08:56:30'),(1043299,'5','184',429,'Sale Id shift 213688',0.00,1027007.85,165.00,1027007.85,0.00,'2021-07-29 23:09:42'),(1043300,'5','184',430,'Sale Id shift 213688',0.00,52318.25,295.00,52318.25,0.00,'2021-07-29 23:09:42'),(1047743,'5','184',429,'Sale Id shift 213899',0.00,993356.10,165.00,993356.10,0.00,'2021-07-31 08:30:30'),(1047744,'5','184',430,'Sale Id shift 213899',0.00,287173.65,295.00,287173.65,0.00,'2021-07-31 08:30:30'),(1059245,'5','184',429,'Sale Id shift 214142',0.00,904478.85,165.00,904478.85,0.00,'2021-08-02 19:17:59'),(1059246,'5','184',430,'Sale Id shift 214142',0.00,115867.15,295.00,115867.15,0.00,'2021-08-02 19:17:59'),(1062135,'5','184',429,'Sale Id shift 214754',0.00,1002048.30,165.00,1002048.30,0.00,'2021-08-03 13:54:32'),(1062136,'5','184',430,'Sale Id shift 214754',0.00,281645.35,295.00,281645.35,0.00,'2021-08-03 13:54:32'),(1062408,'5','184',429,'Sale Id shift 214933',0.00,1062204.00,165.00,1062204.00,0.00,'2021-08-03 14:40:21'),(1062409,'5','184',430,'Sale Id shift 214933',0.00,269745.05,295.00,269745.05,0.00,'2021-08-03 14:40:21'),(1063755,'5','184',429,'Sale Id shift 214938',0.00,937620.75,165.00,937620.75,0.00,'2021-08-03 23:19:19'),(1063756,'5','184',430,'Sale Id shift 214938',0.00,28797.90,295.00,28797.90,0.00,'2021-08-03 23:19:19'),(1069732,'5','184',429,'Sale Id shift 215288',0.00,999545.25,165.00,999545.25,0.00,'2021-08-05 15:32:27'),(1069733,'5','184',430,'Sale Id shift 215288',0.00,288630.95,295.00,288630.95,0.00,'2021-08-05 15:32:27'),(1069734,'5','184',431,'Sale Id shift 215288',0.00,899.25,165.00,899.25,0.00,'2021-08-05 15:32:27'),(1070581,'5','184',429,'Sale Id shift 215400',0.00,920459.10,165.00,920459.10,0.00,'2021-08-06 05:27:19'),(1070582,'5','184',430,'Sale Id shift 215400',0.00,301658.15,295.00,301658.15,0.00,'2021-08-06 05:27:19'),(1083072,'5','184',429,'Sale Id shift 215500',0.00,1028489.55,165.00,1028489.55,0.00,'2021-08-09 08:04:52'),(1083073,'5','184',430,'Sale Id shift 215500',0.00,43775.05,295.00,43775.05,0.00,'2021-08-09 08:04:52'),(1083074,'5','184',431,'Sale Id shift 215500',0.00,75685.50,165.00,75685.50,0.00,'2021-08-09 08:04:52'),(1094925,'5','184',429,'Sale Id shift 216434',0.00,1005968.70,165.00,1005968.70,0.00,'2021-08-12 11:32:39'),(1094926,'5','184',430,'Sale Id shift 216434',0.00,307575.85,295.00,307575.85,0.00,'2021-08-12 11:32:39'),(1094927,'5','184',431,'Sale Id shift 216434',0.00,38890.50,165.00,38890.50,0.00,'2021-08-12 11:32:39'),(1096912,'5','184',429,'Sale Id shift 216887',0.00,993621.75,165.00,993621.75,0.00,'2021-08-12 18:21:43'),(1096913,'5','184',430,'Sale Id shift 216887',0.00,175259.50,295.00,175259.50,0.00,'2021-08-12 18:21:43'),(1096914,'5','184',431,'Sale Id shift 216887',0.00,64272.45,165.00,64272.45,0.00,'2021-08-12 18:21:43'),(1096950,'5','184',429,'Sale Id shift 216984',0.00,872792.25,165.00,872792.25,0.00,'2021-08-12 19:32:27'),(1096951,'5','184',431,'Sale Id shift 216984',0.00,14572.80,165.00,14572.80,0.00,'2021-08-12 19:32:27'),(1096954,'5','184',429,'Sale Id shift 216992',0.00,889480.35,165.00,889480.35,0.00,'2021-08-12 19:45:37'),(1096955,'5','184',430,'Sale Id shift 216992',0.00,52958.40,295.00,52958.40,0.00,'2021-08-12 19:45:37'),(1096956,'5','184',431,'Sale Id shift 216992',0.00,98516.55,165.00,98516.55,0.00,'2021-08-12 19:45:37'),(1096983,'5','184',429,'Sale Id shift 216994',0.00,921208.20,165.00,921208.20,0.00,'2021-08-12 20:20:21'),(1096984,'5','184',430,'Sale Id shift 216994',0.00,27594.30,295.00,27594.30,0.00,'2021-08-12 20:20:21'),(1096985,'5','184',431,'Sale Id shift 216994',0.00,12825.45,165.00,12825.45,0.00,'2021-08-12 20:20:21'),(1096999,'5','184',429,'Sale Id shift 216998',0.00,816908.40,165.00,816908.40,0.00,'2021-08-12 22:43:18'),(1097000,'5','184',430,'Sale Id shift 216998',0.00,114527.85,295.00,114527.85,0.00,'2021-08-12 22:43:18'),(1097001,'5','184',431,'Sale Id shift 216998',0.00,58317.60,165.00,58317.60,0.00,'2021-08-12 22:43:18'),(1101289,'5','184',429,'Sale Id shift 217055',0.00,811389.15,165.00,811389.15,0.00,'2021-08-14 06:44:26'),(1101290,'5','184',430,'Sale Id shift 217055',0.00,51391.95,295.00,51391.95,0.00,'2021-08-14 06:44:26'),(1101291,'5','184',431,'Sale Id shift 217055',0.00,67597.20,165.00,67597.20,0.00,'2021-08-14 06:44:26'),(1105495,'5','184',429,'Sale Id shift 217481',0.00,863563.80,165.00,863563.80,0.00,'2021-08-14 23:01:21'),(1105496,'5','184',430,'Sale Id shift 217481',0.00,216125.85,295.00,216125.85,0.00,'2021-08-14 23:01:21'),(1105497,'5','184',431,'Sale Id shift 217481',0.00,60602.85,165.00,60602.85,0.00,'2021-08-14 23:01:21'),(1110828,'5','184',429,'Sale Id shift 217647',0.00,729245.55,165.00,729245.55,0.00,'2021-08-16 09:54:34'),(1110829,'5','184',430,'Sale Id shift 217647',0.00,47306.20,295.00,47306.20,0.00,'2021-08-16 09:54:34'),(1110830,'5','184',431,'Sale Id shift 217647',0.00,87022.65,165.00,87022.65,0.00,'2021-08-16 09:54:34'),(1113678,'5','184',429,'Sale Id shift 217856',0.00,166254.00,165.00,166254.00,0.00,'2021-08-17 05:43:36'),(1113679,'5','184',430,'Sale Id shift 217856',0.00,47887.35,295.00,47887.35,0.00,'2021-08-17 05:43:36'),(1113680,'5','184',431,'Sale Id shift 217856',0.00,474891.45,165.00,474891.45,0.00,'2021-08-17 05:43:36'),(1117511,'5','184',430,'Sale Id shift 218026',0.00,273518.10,295.00,273518.10,0.00,'2021-08-17 22:33:24'),(1117512,'5','184',431,'Sale Id shift 218026',0.00,586253.25,165.00,586253.25,0.00,'2021-08-17 22:33:24'),(1125249,'5','184',429,'Sale Id shift 218265',0.00,563735.70,165.00,563735.70,0.00,'2021-08-20 06:30:22'),(1125250,'5','184',430,'Sale Id shift 218265',0.00,29626.85,295.00,29626.85,0.00,'2021-08-20 06:30:22'),(1125251,'5','184',431,'Sale Id shift 218265',0.00,156713.70,165.00,156713.70,0.00,'2021-08-20 06:30:22'),(1128101,'5','184',429,'Sale Id shift 218779',0.00,889158.60,165.00,889158.60,0.00,'2021-08-20 15:43:15'),(1128102,'5','184',430,'Sale Id shift 218779',0.00,170344.80,295.00,170344.80,0.00,'2021-08-20 15:43:15'),(1128831,'5','184',429,'Sale Id shift 218873',0.00,836191.95,165.00,836191.95,0.00,'2021-08-20 23:08:09'),(1128832,'5','184',430,'Sale Id shift 218873',0.00,270730.35,295.00,270730.35,0.00,'2021-08-20 23:08:09'),(1128833,'5','184',431,'Sale Id shift 218873',0.00,50904.15,165.00,50904.15,0.00,'2021-08-20 23:08:09'),(1133151,'5','184',429,'Sale Id shift 219101',0.00,772657.05,165.00,772657.05,0.00,'2021-08-21 23:06:58'),(1133152,'5','184',430,'Sale Id shift 219101',0.00,287073.35,295.00,287073.35,0.00,'2021-08-21 23:06:58'),(1137264,'5','184',429,'Sale Id shift 219314',0.00,843158.25,165.00,843158.25,0.00,'2021-08-22 23:29:10'),(1137265,'5','184',430,'Sale Id shift 219314',0.00,262768.30,295.00,262768.30,0.00,'2021-08-22 23:29:10'),(1137266,'5','184',431,'Sale Id shift 219314',0.00,7185.75,165.00,7185.75,0.00,'2021-08-22 23:29:10'),(1141217,'5','184',429,'Sale Id shift 219444',0.00,834428.10,165.00,834428.10,0.00,'2021-08-23 22:03:52'),(1141218,'5','184',430,'Sale Id shift 219444',0.00,276960.75,295.00,276960.75,0.00,'2021-08-23 22:03:52'),(1141219,'5','184',431,'Sale Id shift 219444',0.00,66828.30,165.00,66828.30,0.00,'2021-08-23 22:03:52'),(1144989,'5','184',429,'Sale Id shift 219679',0.00,778506.30,165.00,778506.30,0.00,'2021-08-24 22:28:30'),(1144990,'5','184',430,'Sale Id shift 219679',0.00,55262.35,295.00,55262.35,0.00,'2021-08-24 22:28:30'),(1148839,'5','184',429,'Sale Id shift 219880',0.00,932951.25,165.00,932951.25,0.00,'2021-08-26 05:23:37'),(1148840,'5','184',430,'Sale Id shift 219880',0.00,76992.05,295.00,76992.05,0.00,'2021-08-26 05:23:37'),(1155013,'5','184',429,'Sale Id shift 220128',0.00,712588.80,165.00,712588.80,0.00,'2021-08-27 15:30:11'),(1155014,'5','184',430,'Sale Id shift 220128',0.00,267980.95,295.00,267980.95,0.00,'2021-08-27 15:30:11'),(1155015,'5','184',431,'Sale Id shift 220128',0.00,80198.25,165.00,80198.25,0.00,'2021-08-27 15:30:11'),(1156128,'5','184',429,'Sale Id shift 220440',0.00,786480.75,165.00,786480.75,0.00,'2021-08-28 07:08:25'),(1156129,'5','184',430,'Sale Id shift 220440',0.00,52421.50,295.00,52421.50,0.00,'2021-08-28 07:08:25'),(1156130,'5','184',431,'Sale Id shift 220440',0.00,110119.35,165.00,110119.35,0.00,'2021-08-28 07:08:25'),(1160421,'5','184',429,'Sale Id shift 220551',0.00,692698.05,165.00,692698.05,0.00,'2021-08-29 08:49:04'),(1160422,'5','184',430,'Sale Id shift 220551',0.00,19130.75,295.00,19130.75,0.00,'2021-08-29 08:49:04'),(1160423,'5','184',431,'Sale Id shift 220551',0.00,25428.15,165.00,25428.15,0.00,'2021-08-29 08:49:04'),(1164971,'5','184',429,'Sale Id shift 220889',0.00,760521.30,165.00,760521.30,0.00,'2021-08-30 09:17:15'),(1164972,'5','184',430,'Sale Id shift 220889',0.00,254526.00,295.00,254526.00,0.00,'2021-08-30 09:17:15'),(1164973,'5','184',431,'Sale Id shift 220889',0.00,43967.55,165.00,43967.55,0.00,'2021-08-30 09:17:15'),(1168431,'5','184',429,'Sale Id shift 220985',0.00,678217.65,165.00,678217.65,0.00,'2021-08-31 07:04:49'),(1168432,'5','184',430,'Sale Id shift 220985',0.00,15286.90,295.00,15286.90,0.00,'2021-08-31 07:04:49'),(1168433,'5','184',431,'Sale Id shift 220985',0.00,105916.80,165.00,105916.80,0.00,'2021-08-31 07:04:49'),(1172064,'5','184',429,'Sale Id shift 221192',0.00,671182.05,165.00,671182.05,0.00,'2021-09-01 05:31:30'),(1172065,'5','184',430,'Sale Id shift 221192',0.00,295126.85,295.00,295126.85,0.00,'2021-09-01 05:31:30'),(1172066,'5','184',431,'Sale Id shift 221192',0.00,151636.65,165.00,151636.65,0.00,'2021-09-01 05:31:30'),(1175784,'5','184',429,'Sale Id shift 221511',0.00,620345.55,165.00,620345.55,0.00,'2021-09-01 22:38:03'),(1175785,'5','184',430,'Sale Id shift 221511',0.00,270438.30,295.00,270438.30,0.00,'2021-09-01 22:38:03'),(1175786,'5','184',431,'Sale Id shift 221511',0.00,171438.30,165.00,171438.30,0.00,'2021-09-01 22:38:03'),(1184529,'5','184',429,'Sale Id shift 221757',0.00,680704.20,165.00,680704.20,0.00,'2021-09-04 07:12:44'),(1184530,'5','184',430,'Sale Id shift 221757',0.00,25231.35,295.00,25231.35,0.00,'2021-09-04 07:12:44'),(1184531,'5','184',431,'Sale Id shift 221757',0.00,106774.80,165.00,106774.80,0.00,'2021-09-04 07:12:44'),(1188283,'5','184',429,'Sale Id shift 222242',0.00,698367.45,165.00,698367.45,0.00,'2021-09-04 20:09:06'),(1188284,'5','184',430,'Sale Id shift 222242',0.00,246041.80,295.00,246041.80,0.00,'2021-09-04 20:09:06'),(1188285,'5','184',431,'Sale Id shift 222242',0.00,99547.80,165.00,99547.80,0.00,'2021-09-04 20:09:06'),(1188515,'5','184',429,'Sale Id shift 222253',0.00,686324.10,165.00,686324.10,0.00,'2021-09-05 07:12:30'),(1188516,'5','184',430,'Sale Id shift 222253',0.00,33827.65,295.00,33827.65,0.00,'2021-09-05 07:12:30'),(1192169,'5','184',429,'Sale Id shift 222468',0.00,586801.05,165.00,586801.05,0.00,'2021-09-06 05:31:08'),(1192170,'5','184',430,'Sale Id shift 222468',0.00,300413.25,295.00,300413.25,0.00,'2021-09-06 05:31:08'),(1192171,'5','184',431,'Sale Id shift 222468',0.00,28351.95,165.00,28351.95,0.00,'2021-09-06 05:31:08'),(1195241,'5','184',429,'Sale Id shift 222617',0.00,605297.55,165.00,605297.55,0.00,'2021-09-07 06:54:05'),(1195242,'5','184',430,'Sale Id shift 222617',0.00,52344.80,295.00,52344.80,0.00,'2021-09-07 06:54:05'),(1195243,'5','184',431,'Sale Id shift 222617',0.00,11685.30,165.00,11685.30,0.00,'2021-09-07 06:54:05'),(1196921,'5','184',429,'Sale Id shift 222786',0.00,524264.40,165.00,524264.40,0.00,'2021-09-08 09:14:47'),(1196922,'5','184',430,'Sale Id shift 222786',0.00,10814.70,295.00,10814.70,0.00,'2021-09-08 09:14:47'),(1196923,'5','184',431,'Sale Id shift 222786',0.00,23491.05,165.00,23491.05,0.00,'2021-09-08 09:14:47'),(1198504,'5','184',429,'Sale Id shift 223003',0.00,639901.35,165.00,639901.35,0.00,'2021-09-09 05:59:34'),(1198505,'5','184',430,'Sale Id shift 223003',0.00,38863.30,295.00,38863.30,0.00,'2021-09-09 05:59:34'),(1198506,'5','184',431,'Sale Id shift 223003',0.00,7598.25,165.00,7598.25,0.00,'2021-09-09 05:59:34'),(1202643,'5','184',429,'Sale Id shift 223264',0.00,663573.90,165.00,663573.90,0.00,'2021-09-10 09:00:35'),(1202644,'5','184',430,'Sale Id shift 223264',0.00,37108.05,295.00,37108.05,0.00,'2021-09-10 09:00:35'),(1205581,'5','184',429,'Sale Id shift 223528',0.00,690582.75,165.00,690582.75,0.00,'2021-09-11 07:37:13'),(1205582,'5','184',430,'Sale Id shift 223528',0.00,48911.00,295.00,48911.00,0.00,'2021-09-11 07:37:13'),(1205583,'5','184',431,'Sale Id shift 223528',0.00,31114.05,165.00,31114.05,0.00,'2021-09-11 07:37:13'),(1208971,'5','184',429,'Sale Id shift 223708',0.00,718401.31,163.00,718401.31,0.00,'2021-09-12 05:44:09'),(1208972,'5','184',430,'Sale Id shift 223708',0.00,56076.55,295.00,56076.55,0.00,'2021-09-12 05:44:09'),(1208973,'5','184',431,'Sale Id shift 223708',0.00,139485.62,163.00,139485.62,0.00,'2021-09-12 05:44:09'),(1213261,'5','184',430,'Sale Id shift 223941',0.00,31019.25,295.00,31019.25,0.00,'2021-09-13 09:02:24'),(1213262,'5','184',431,'Sale Id shift 223941',0.00,591717.71,163.00,591717.71,0.00,'2021-09-13 09:02:24'),(1217067,'5','184',430,'Sale Id shift 224163',0.00,24381.75,295.00,24381.75,0.00,'2021-09-14 09:01:08'),(1217068,'5','184',431,'Sale Id shift 224163',0.00,541001.89,163.00,541001.89,0.00,'2021-09-14 09:01:08'),(1220734,'5','184',429,'Sale Id shift 224424',0.00,28591.20,163.00,28244.64,-346.56,'2021-09-15 09:15:53'),(1220735,'5','184',430,'Sale Id shift 224424',0.00,23163.40,295.00,23163.40,0.00,'2021-09-15 09:15:53'),(1220736,'5','184',431,'Sale Id shift 224424',0.00,499257.59,163.00,499257.59,0.00,'2021-09-15 09:15:53'),(1224235,'5','184',429,'Sale Id shift 224619',0.00,782311.98,163.00,782311.98,0.00,'2021-09-16 08:35:22'),(1224236,'5','184',430,'Sale Id shift 224619',0.00,82396.45,295.00,82396.45,0.00,'2021-09-16 08:35:22'),(1230863,'5','184',429,'Sale Id shift 224822',0.00,857688.07,163.00,857688.07,0.00,'2021-09-18 07:36:25'),(1230864,'5','184',430,'Sale Id shift 224822',0.00,40329.45,295.00,40329.45,0.00,'2021-09-18 07:36:25'),(1232049,'5','184',429,'Sale Id shift 225333',0.00,878563.48,163.00,878563.48,0.00,'2021-09-18 10:54:03'),(1232050,'5','184',430,'Sale Id shift 225333',0.00,66557.90,295.00,66557.90,0.00,'2021-09-18 10:54:03'),(1233728,'5','184',429,'Sale Id shift 225411',0.00,954493.77,163.00,954493.77,0.00,'2021-09-19 06:25:01'),(1233729,'5','184',430,'Sale Id shift 225411',0.00,27747.70,295.00,27747.70,0.00,'2021-09-19 06:25:01'),(1237908,'5','184',429,'Sale Id shift 225553',0.00,918193.67,163.00,918193.67,0.00,'2021-09-20 09:14:46'),(1237909,'5','184',430,'Sale Id shift 225553',0.00,32874.80,295.00,32874.80,0.00,'2021-09-20 09:14:46'),(1241244,'5','184',429,'Sale Id shift 225839',0.00,1005913.75,163.00,1005913.75,0.00,'2021-09-21 09:46:41'),(1241245,'5','184',430,'Sale Id shift 225839',0.00,56687.20,295.00,56687.20,0.00,'2021-09-21 09:46:41'),(1241246,'5','184',431,'Sale Id shift 225839',0.00,21289.43,163.00,21289.43,0.00,'2021-09-21 09:46:41'),(1243640,'5','184',429,'Sale Id shift 226066',0.00,886605.90,163.00,886605.90,0.00,'2021-09-22 09:09:36'),(1243641,'5','184',430,'Sale Id shift 226066',0.00,40459.25,295.00,40459.25,0.00,'2021-09-22 09:09:36'),(1247341,'5','184',429,'Sale Id shift 226329',0.00,921432.48,163.00,921432.48,0.00,'2021-09-23 10:26:30'),(1247342,'5','184',430,'Sale Id shift 226329',0.00,42854.65,295.00,42854.65,0.00,'2021-09-23 10:26:30'),(1253193,'5','184',429,'Sale Id shift 226585',0.00,817291.78,163.00,817291.78,0.00,'2021-09-25 05:34:25'),(1253194,'5','184',430,'Sale Id shift 226585',0.00,55203.35,295.00,55203.35,0.00,'2021-09-25 05:34:25'),(1253964,'5','184',429,'Sale Id shift 227007',0.00,852473.70,163.00,852473.70,0.00,'2021-09-25 09:15:34'),(1253965,'5','184',430,'Sale Id shift 227007',0.00,55811.05,295.00,55811.05,0.00,'2021-09-25 09:15:34'),(1256768,'5','184',429,'Sale Id shift 227121',0.00,786553.24,163.00,786553.24,0.00,'2021-09-26 06:43:41'),(1256769,'5','184',430,'Sale Id shift 227121',0.00,37621.35,295.00,37621.35,0.00,'2021-09-26 06:43:41'),(1259665,'5','184',429,'Sale Id shift 227242',0.00,935774.85,163.00,935774.85,0.00,'2021-09-27 01:08:11'),(1259666,'5','184',430,'Sale Id shift 227242',0.00,11348.65,295.00,11348.65,0.00,'2021-09-27 01:08:11'),(1263459,'5','184',429,'Sale Id shift 227436',0.00,896586.39,163.00,896586.39,0.00,'2021-09-28 08:24:31'),(1263460,'5','184',430,'Sale Id shift 227436',0.00,46108.50,295.00,46108.50,0.00,'2021-09-28 08:24:31'),(1266319,'5','184',429,'Sale Id shift 227794',0.00,943696.65,163.00,943696.65,0.00,'2021-09-29 08:32:00'),(1266320,'5','184',430,'Sale Id shift 227794',0.00,39723.00,300.00,39723.00,0.00,'2021-09-29 08:32:00'),(1266321,'5','184',431,'Sale Id shift 227794',0.00,85477.20,163.00,85477.20,0.00,'2021-09-29 08:32:00'),(1268545,'5','184',429,'Sale Id shift 227921',0.00,909305.28,163.00,909305.28,0.00,'2021-09-29 22:13:05'),(1268546,'5','184',430,'Sale Id shift 227921',0.00,47295.00,300.00,47295.00,0.00,'2021-09-29 22:13:05'),(1268547,'5','184',431,'Sale Id shift 227921',0.00,103359.93,163.00,103359.93,0.00,'2021-09-29 22:13:05'),(1287154,'5','184',429,'Sale Id shift 229313',0.00,306560.62,163.00,306560.62,0.00,'2021-10-05 14:00:49'),(1287155,'5','184',430,'Sale Id shift 229313',0.00,58929.00,300.00,58929.00,0.00,'2021-10-05 14:00:49'),(1287156,'5','184',431,'Sale Id shift 229313',0.00,465676.33,163.00,465676.33,0.00,'2021-10-05 14:00:49'),(1307672,'5','184',430,'Sale Id shift 230633',0.00,66762.00,300.00,66762.00,0.00,'2021-10-11 14:18:08'),(1307673,'5','184',431,'Sale Id shift 230633',0.00,696039.34,163.00,696039.34,0.00,'2021-10-11 14:18:08'),(1310819,'5','184',430,'Sale Id shift 230676',0.00,14310.00,300.00,14310.00,0.00,'2021-10-12 14:09:22'),(1310820,'5','184',431,'Sale Id shift 230676',0.00,612027.51,163.00,612027.51,0.00,'2021-10-12 14:09:22'),(1310889,'5','184',430,'Sale Id shift 230964',0.00,15216.00,300.00,15216.00,0.00,'2021-10-12 14:29:20'),(1310890,'5','184',431,'Sale Id shift 230964',0.00,287898.75,163.00,287898.75,0.00,'2021-10-12 14:29:20'),(1310932,'5','184',430,'Sale Id shift 230970',0.00,29994.00,300.00,29994.00,0.00,'2021-10-12 14:40:03'),(1310933,'5','184',431,'Sale Id shift 230970',0.00,158719.62,163.00,158719.62,0.00,'2021-10-12 14:40:03'),(1310987,'5','184',430,'Sale Id shift 230977',0.00,44850.80,310.00,44850.80,0.00,'2021-10-12 14:57:44'),(1313246,'5','184',430,'Sale Id shift 230986',0.00,44299.00,310.00,44299.00,0.00,'2021-10-13 12:28:58'),(1313295,'5','184',430,'Sale Id shift 231183',0.00,31781.20,310.00,31781.20,0.00,'2021-10-13 12:38:15'),(1313348,'5','184',430,'Sale Id shift 231190',0.00,30671.40,310.00,30671.40,0.00,'2021-10-13 12:49:48'),(1313617,'5','184',429,'Sale Id shift 231226',0.00,156095.32,163.00,156095.32,0.00,'2021-10-13 13:59:05'),(1313618,'5','184',430,'Sale Id shift 231226',0.00,29902.60,310.00,29902.60,0.00,'2021-10-13 13:59:05'),(1313669,'5','184',429,'Sale Id shift 231236',0.00,907672.02,163.00,907672.02,0.00,'2021-10-13 14:09:06'),(1313670,'5','184',430,'Sale Id shift 231236',0.00,18311.70,310.00,18311.70,0.00,'2021-10-13 14:09:06'),(1313788,'5','184',429,'Sale Id shift 231247',0.00,754807.36,163.00,754807.36,0.00,'2021-10-13 14:27:19'),(1313789,'5','184',430,'Sale Id shift 231247',0.00,536659.20,320.00,536659.20,0.00,'2021-10-13 14:27:19'),(1313901,'5','184',429,'Sale Id shift 231270',0.00,530837.21,163.00,530837.21,0.00,'2021-10-13 14:59:15'),(1313902,'5','184',430,'Sale Id shift 231270',0.00,96800.00,320.00,96800.00,0.00,'2021-10-13 14:59:15'),(1314708,'5','184',429,'Sale Id shift 231280',0.00,937419.52,163.00,937419.52,0.00,'2021-10-14 05:40:45'),(1314709,'5','184',430,'Sale Id shift 231280',0.00,48179.20,320.00,48179.20,0.00,'2021-10-14 05:40:45'),(1318794,'5','184',429,'Sale Id shift 231462',0.00,908462.57,163.00,908462.57,0.00,'2021-10-15 10:09:30'),(1318795,'5','184',430,'Sale Id shift 231462',0.00,124752.00,320.00,124752.00,0.00,'2021-10-15 10:09:30'),(1323992,'5','184',429,'Sale Id shift 231794',0.00,931626.50,163.00,931626.50,0.00,'2021-10-17 00:11:54'),(1323993,'5','184',430,'Sale Id shift 231794',0.00,41996.80,320.00,41996.80,0.00,'2021-10-17 00:11:54'),(1324881,'5','184',429,'Sale Id shift 232096',0.00,1002484.23,163.00,1002484.23,0.00,'2021-10-17 09:28:20'),(1324882,'5','184',430,'Sale Id shift 232096',0.00,52529.28,327.00,52529.28,0.00,'2021-10-17 09:28:20'),(1327060,'5','184',429,'Sale Id shift 232280',0.00,998916.16,163.00,998916.16,0.00,'2021-10-17 22:18:23'),(1327061,'5','184',430,'Sale Id shift 232280',0.00,98237.34,327.00,98237.34,0.00,'2021-10-17 22:18:23'),(1331242,'5','184',429,'Sale Id shift 232396',0.00,1000588.54,163.00,1000588.54,0.00,'2021-10-19 07:38:15'),(1331243,'5','184',430,'Sale Id shift 232396',0.00,59906.40,327.00,59906.40,0.00,'2021-10-19 07:38:15'),(1334717,'5','184',429,'Sale Id shift 232848',0.00,376595.20,163.00,376595.20,0.00,'2021-10-20 09:06:31'),(1334718,'5','184',430,'Sale Id shift 232848',0.00,42653.88,327.00,42653.88,0.00,'2021-10-20 09:06:31'),(1336802,'5','184',429,'Sale Id shift 232975',0.00,171379.83,163.00,171379.83,0.00,'2021-10-20 15:37:06'),(1336803,'5','184',430,'Sale Id shift 232975',0.00,41583.30,330.00,41583.30,0.00,'2021-10-20 15:37:06'),(1338224,'5','184',429,'Sale Id shift 233064',0.00,15331.78,163.00,15331.78,0.00,'2021-10-21 08:38:03'),(1338225,'5','184',430,'Sale Id shift 233064',0.00,39468.00,345.00,39468.00,0.00,'2021-10-21 08:38:03'),(1341883,'5','184',429,'Sale Id shift 233318',0.00,30117.51,163.00,30117.51,0.00,'2021-10-22 09:20:17'),(1341884,'5','184',430,'Sale Id shift 233318',0.00,25578.30,345.00,25578.30,0.00,'2021-10-22 09:20:17'),(1344855,'5','184',429,'Sale Id shift 233596',0.00,28195.74,163.00,28195.74,0.00,'2021-10-23 08:07:14'),(1344856,'5','184',430,'Sale Id shift 233596',0.00,26071.65,345.00,26071.65,0.00,'2021-10-23 08:07:14'),(1348044,'5','184',429,'Sale Id shift 233801',0.00,16715.65,163.00,16715.65,0.00,'2021-10-23 22:40:16'),(1348045,'5','184',430,'Sale Id shift 233801',0.00,18619.65,345.00,18619.65,0.00,'2021-10-23 22:40:16'),(1352767,'5','184',429,'Sale Id shift 234006',0.00,14828.11,163.00,14828.11,0.00,'2021-10-25 11:17:39'),(1352768,'5','184',430,'Sale Id shift 234006',0.00,59119.20,345.00,59119.20,0.00,'2021-10-25 11:17:39'),(1355414,'5','184',429,'Sale Id shift 234342',0.00,16231.54,163.00,16231.54,0.00,'2021-10-26 08:29:25'),(1355415,'5','184',430,'Sale Id shift 234342',0.00,18505.80,345.00,18505.80,0.00,'2021-10-26 08:29:25'),(1362601,'5','184',430,'Sale Id shift 234503',0.00,63221.25,345.00,63221.25,0.00,'2021-10-28 09:28:52'),(1364439,'5','184',430,'Sale Id shift 234919',0.00,35190.00,345.00,35190.00,0.00,'2021-10-28 15:56:40'),(1370730,'5','184',430,'Sale Id shift 235030',0.00,36045.60,345.00,36045.60,0.00,'2021-10-30 16:50:42'),(1378247,'5','184',429,'Sale Id shift 236120',0.00,1203250.95,165.00,1203250.95,0.00,'2021-11-02 11:47:52'),(1378248,'5','184',430,'Sale Id shift 236120',0.00,77086.80,345.00,77086.80,0.00,'2021-11-02 11:47:52'),(1384722,'5','184',429,'Sale Id shift 236331',0.00,700951.35,165.00,700951.35,0.00,'2021-11-04 11:44:24'),(1384723,'5','184',430,'Sale Id shift 236331',0.00,60602.70,345.00,60602.70,0.00,'2021-11-04 11:44:24'),(1385989,'5','184',429,'Sale Id shift 236622',0.00,533063.85,165.00,533063.85,0.00,'2021-11-04 14:42:53'),(1385990,'5','184',430,'Sale Id shift 236622',0.00,115833.75,345.00,115833.75,0.00,'2021-11-04 14:42:53'),(1386258,'5','184',429,'Sale Id shift 236674',0.00,1185665.25,165.00,1185665.25,0.00,'2021-11-04 15:19:39'),(1386259,'5','184',430,'Sale Id shift 236674',0.00,220689.60,345.00,220689.60,0.00,'2021-11-04 15:19:39'),(1389494,'5','184',429,'Sale Id shift 236675',0.00,1035535.05,165.00,1035535.05,0.00,'2021-11-05 10:17:43'),(1389495,'5','184',430,'Sale Id shift 236675',0.00,295913.40,345.00,295913.40,0.00,'2021-11-05 10:17:43'),(1394200,'5','184',429,'Sale Id shift 236867',0.00,2220438.00,165.00,2220438.00,0.00,'2021-11-06 09:59:40'),(1394201,'5','184',430,'Sale Id shift 236867',0.00,153766.50,345.00,153766.50,0.00,'2021-11-06 09:59:40'),(1394265,'5','184',429,'Sale Id shift 237032',0.00,2761131.45,165.00,2761131.45,0.00,'2021-11-06 10:08:20'),(1394266,'5','184',430,'Sale Id shift 237032',0.00,150254.40,345.00,150254.40,0.00,'2021-11-06 10:08:20'),(1398453,'5','184',429,'Sale Id shift 237036',0.00,753386.70,165.00,753386.70,0.00,'2021-11-07 07:47:13'),(1398454,'5','184',430,'Sale Id shift 237036',0.00,95692.65,345.00,95692.65,0.00,'2021-11-07 07:47:13'),(1402813,'5','184',429,'Sale Id shift 237345',0.00,93424.65,165.00,93424.65,0.00,'2021-11-08 07:36:38'),(1402814,'5','184',430,'Sale Id shift 237345',0.00,108505.95,345.00,108505.95,0.00,'2021-11-08 07:36:38'),(1407546,'5','184',429,'Sale Id shift 237634',0.00,99744.15,165.00,99744.15,0.00,'2021-11-09 08:38:43'),(1407547,'5','184',430,'Sale Id shift 237634',0.00,39250.65,345.00,39250.65,0.00,'2021-11-09 08:38:43'),(1422194,'5','184',429,'Sale Id shift 237982',0.00,2272782.60,165.00,2272782.60,0.00,'2021-11-12 08:20:00'),(1422195,'5','184',430,'Sale Id shift 237982',0.00,233627.10,345.00,233627.10,0.00,'2021-11-12 08:20:00'),(1422395,'5','184',429,'Sale Id shift 238433',0.00,1884219.15,165.00,1884219.15,0.00,'2021-11-12 08:51:06'),(1422396,'5','184',430,'Sale Id shift 238433',0.00,215573.25,345.00,215573.25,0.00,'2021-11-12 08:51:06'),(1427607,'5','184',429,'Sale Id shift 238437',0.00,1761051.60,165.00,1761051.60,0.00,'2021-11-13 10:08:14'),(1427608,'5','184',430,'Sale Id shift 238437',0.00,174794.25,345.00,174794.25,0.00,'2021-11-13 10:08:14'),(1431840,'5','184',429,'Sale Id shift 238695',0.00,2162127.00,165.00,2162127.00,0.00,'2021-11-14 09:34:37'),(1431841,'5','184',430,'Sale Id shift 238695',0.00,133370.10,345.00,133370.10,0.00,'2021-11-14 09:34:37'),(1435851,'5','184',429,'Sale Id shift 239036',0.00,2573463.75,165.00,2573463.75,0.00,'2021-11-15 08:17:05'),(1435852,'5','184',430,'Sale Id shift 239036',0.00,121926.45,345.00,121926.45,0.00,'2021-11-15 08:17:05'),(1440052,'5','184',429,'Sale Id shift 239137',0.00,575534.85,165.00,575534.85,0.00,'2021-11-16 08:07:33'),(1440053,'5','184',430,'Sale Id shift 239137',0.00,135750.60,345.00,135750.60,0.00,'2021-11-16 08:07:33'),(1443825,'5','184',429,'Sale Id shift 239370',0.00,119260.35,165.00,119260.35,0.00,'2021-11-17 08:02:08'),(1443826,'5','184',430,'Sale Id shift 239370',0.00,326514.90,345.00,326514.90,0.00,'2021-11-17 08:02:08'),(1449095,'5','184',429,'Sale Id shift 239604',0.00,325069.80,165.00,325069.80,0.00,'2021-11-18 10:37:44'),(1449096,'5','184',430,'Sale Id shift 239604',0.00,339721.50,345.00,339721.50,0.00,'2021-11-18 10:37:44'),(1452569,'5','184',429,'Sale Id shift 239881',0.00,1663277.55,165.00,1663277.55,0.00,'2021-11-19 08:12:17'),(1452570,'5','184',430,'Sale Id shift 239881',0.00,183764.25,345.00,183764.25,0.00,'2021-11-19 08:12:17'),(1456960,'5','184',429,'Sale Id shift 240084',0.00,1356905.55,165.00,1356905.55,0.00,'2021-11-20 08:25:36'),(1456961,'5','184',430,'Sale Id shift 240084',0.00,173141.70,345.00,173141.70,0.00,'2021-11-20 08:25:36'),(1465622,'5','184',429,'Sale Id shift 240283',0.00,1410583.35,165.00,1410583.35,0.00,'2021-11-21 19:44:56'),(1466384,'5','184',429,'Sale Id shift 240681',0.00,1531289.10,165.00,1531289.10,0.00,'2021-11-22 08:01:23'),(1466385,'5','184',430,'Sale Id shift 240681',0.00,422014.35,345.00,422014.35,0.00,'2021-11-22 08:01:23'),(1472146,'5','184',429,'Sale Id shift 240771',0.00,1710218.40,165.00,1710218.40,0.00,'2021-11-23 09:55:08'),(1472147,'5','184',430,'Sale Id shift 240771',0.00,208231.65,345.00,208231.65,0.00,'2021-11-23 09:55:08'),(1476122,'5','184',429,'Sale Id shift 241086',0.00,1730850.00,165.00,1730850.00,0.00,'2021-11-24 08:44:59'),(1476123,'5','184',430,'Sale Id shift 241086',0.00,295875.45,345.00,295875.45,0.00,'2021-11-24 08:44:59'),(1479750,'5','184',429,'Sale Id shift 241345',0.00,1814676.60,165.00,1814676.60,0.00,'2021-11-25 07:50:36'),(1479751,'5','184',430,'Sale Id shift 241345',0.00,568287.45,345.00,568287.45,0.00,'2021-11-25 07:50:36'),(1484264,'5','184',429,'Sale Id shift 241588',0.00,2396169.60,165.00,2396169.60,0.00,'2021-11-26 08:27:36'),(1488308,'5','184',429,'Sale Id shift 241845',0.00,453418.35,165.00,453418.35,0.00,'2021-11-27 07:57:31'),(1488309,'5','184',430,'Sale Id shift 241845',0.00,29359.50,345.00,29359.50,0.00,'2021-11-27 07:57:31'),(1495639,'5','184',429,'Sale Id shift 242133',0.00,1724248.35,165.00,1724248.35,0.00,'2021-11-28 13:42:38'),(1495640,'5','184',430,'Sale Id shift 242133',0.00,98783.85,345.00,98783.85,0.00,'2021-11-28 13:42:38'),(1500383,'5','184',429,'Sale Id shift 242396',0.00,1995260.85,165.00,1995260.85,0.00,'2021-11-29 14:03:45'),(1500384,'5','184',430,'Sale Id shift 242396',0.00,185320.20,345.00,185320.20,0.00,'2021-11-29 14:03:45'),(1508083,'5','184',429,'Sale Id shift 242615',0.00,2390028.30,165.00,2390028.30,0.00,'2021-12-01 08:33:26'),(1508084,'5','184',430,'Sale Id shift 242615',0.00,230508.30,345.00,230508.30,0.00,'2021-12-01 08:33:26'),(1511640,'5','184',429,'Sale Id shift 243003',0.00,562056.00,165.00,562056.00,0.00,'2021-12-01 19:21:09'),(1511641,'5','184',430,'Sale Id shift 243003',0.00,187441.95,345.00,187441.95,0.00,'2021-12-01 19:21:09'),(1518407,'5','184',429,'Sale Id shift 243094',0.00,1248408.15,165.00,1248408.15,0.00,'2021-12-03 09:30:23'),(1518408,'5','184',430,'Sale Id shift 243094',0.00,258798.30,345.00,258798.30,0.00,'2021-12-03 09:30:23'),(1527328,'5','184',429,'Sale Id shift 243473',0.00,2289500.40,165.00,2289500.40,0.00,'2021-12-04 17:46:44'),(1527329,'5','184',430,'Sale Id shift 243473',0.00,232212.60,345.00,232212.60,0.00,'2021-12-04 17:46:44'),(1528279,'5','184',429,'Sale Id shift 243806',0.00,2243613.90,165.00,2243613.90,0.00,'2021-12-05 07:50:06'),(1528280,'5','184',430,'Sale Id shift 243806',0.00,151979.40,345.00,151979.40,0.00,'2021-12-05 07:50:06'),(1532322,'5','184',429,'Sale Id shift 243963',0.00,2107688.55,165.00,2107688.55,0.00,'2021-12-05 19:27:13'),(1532323,'5','184',430,'Sale Id shift 243963',0.00,135398.70,345.00,135398.70,0.00,'2021-12-05 19:27:13'),(1537667,'5','184',429,'Sale Id shift 244156',0.00,2246966.70,165.00,2246966.70,0.00,'2021-12-06 18:15:24'),(1537668,'5','184',430,'Sale Id shift 244156',0.00,159552.15,345.00,159552.15,0.00,'2021-12-06 18:15:24'),(1538729,'5','184',429,'Sale Id shift 244287',0.00,3102673.20,165.00,3102673.20,0.00,'2021-12-07 08:09:34'),(1538730,'5','184',430,'Sale Id shift 244287',0.00,145527.90,345.00,145527.90,0.00,'2021-12-07 08:09:34'),(1547357,'5','184',429,'Sale Id shift 244575',0.00,859669.80,165.00,859669.80,0.00,'2021-12-08 17:47:44'),(1547358,'5','184',430,'Sale Id shift 244575',0.00,235583.25,345.00,235583.25,0.00,'2021-12-08 17:47:44'),(1558349,'5','184',429,'Sale Id shift 244823',0.00,179477.10,165.00,179477.10,0.00,'2021-12-11 06:56:36'),(1558350,'5','184',430,'Sale Id shift 244823',0.00,870952.50,345.00,870952.50,0.00,'2021-12-11 06:56:36'),(1570325,'5','184',429,'Sale Id shift 245513',0.00,51412.35,165.00,51412.35,0.00,'2021-12-13 10:35:56'),(1570326,'5','184',430,'Sale Id shift 245513',0.00,166959.30,345.00,166959.30,0.00,'2021-12-13 10:35:56'),(1574825,'5','184',429,'Sale Id shift 245783',0.00,8972.70,165.00,8972.70,0.00,'2021-12-14 08:51:18'),(1574826,'5','184',430,'Sale Id shift 245783',0.00,221907.45,345.00,221907.45,0.00,'2021-12-14 08:51:18'),(1580793,'5','184',430,'Sale Id shift 246114',0.00,174670.05,345.00,174670.05,0.00,'2021-12-15 11:31:09'),(1584178,'5','184',430,'Sale Id shift 246451',0.00,294512.70,345.00,294512.70,0.00,'2021-12-16 08:16:11'),(1585961,'5','184',429,'Sale Id shift 246544',0.00,2596550.55,165.00,2596550.55,0.00,'2021-12-16 12:09:36'),(1585962,'5','184',430,'Sale Id shift 246544',0.00,375135.75,345.00,375135.75,0.00,'2021-12-16 12:09:36'),(1586901,'5','184',429,'Sale Id shift 246598',0.00,1896161.85,165.00,1896161.85,0.00,'2021-12-16 14:20:11'),(1586902,'5','184',430,'Sale Id shift 246598',0.00,168256.50,345.00,168256.50,0.00,'2021-12-16 14:20:11'),(1590034,'5','184',429,'Sale Id shift 246622',0.00,252243.75,165.00,252243.75,0.00,'2021-12-17 09:37:16'),(1590035,'5','184',430,'Sale Id shift 246622',0.00,292515.15,345.00,292515.15,0.00,'2021-12-17 09:37:16'),(1593601,'5','184',429,'Sale Id shift 246798',0.00,176134.20,165.00,176134.20,0.00,'2021-12-18 04:03:43'),(1593602,'5','184',430,'Sale Id shift 246798',0.00,296713.80,345.00,296713.80,0.00,'2021-12-18 04:03:43'),(1600145,'5','184',429,'Sale Id shift 247105',0.00,1759594.65,165.00,1759594.65,0.00,'2021-12-19 07:52:17'),(1600146,'5','184',430,'Sale Id shift 247105',0.00,263900.85,345.00,263900.85,0.00,'2021-12-19 07:52:17'),(1610719,'5','184',429,'Sale Id shift 247578',0.00,334605.15,165.00,334605.15,0.00,'2021-12-21 07:56:50'),(1615061,'5','184',429,'Sale Id shift 247728',0.00,187139.70,165.00,187139.70,0.00,'2021-12-21 17:47:50'),(1623582,'5','184',429,'Sale Id shift 248001',0.00,2032326.45,165.00,2032326.45,0.00,'2021-12-23 12:05:55'),(1627563,'5','184',429,'Sale Id shift 248443',0.00,271291.35,165.00,271291.35,0.00,'2021-12-24 08:11:03'),(1634240,'5','184',429,'Sale Id shift 248519',0.00,181074.30,165.00,181074.30,0.00,'2021-12-25 08:26:22'),(1638141,'5','184',429,'Sale Id shift 248740',0.00,1200195.15,165.00,1200195.15,0.00,'2021-12-26 07:16:13'),(1644471,'5','184',429,'Sale Id shift 249201',0.00,1032504.00,165.00,1032504.00,0.00,'2021-12-27 12:18:33'),(1650457,'5','184',429,'Sale Id shift 249434',0.00,1058065.80,165.00,1058065.80,0.00,'2021-12-28 16:00:31'),(1652549,'5','184',429,'Sale Id shift 249661',0.00,750586.65,165.00,750586.65,0.00,'2021-12-29 09:45:40'),(1653144,'5','184',429,'Sale Id shift 249702',0.00,538421.40,165.00,538421.40,0.00,'2021-12-29 11:06:07'),(1662343,'5','184',429,'Sale Id shift 249716',0.00,344411.10,165.00,344411.10,0.00,'2021-12-31 08:44:26'),(1667452,'5','184',429,'Sale Id shift 250184',0.00,95454.15,165.00,95454.15,0.00,'2022-01-01 08:36:42'),(1672402,'5','184',429,'Sale Id shift 250493',0.00,1464795.75,165.00,1464795.75,0.00,'2022-01-02 09:29:44'),(1677379,'5','184',429,'Sale Id shift 250713',0.00,1556682.60,165.00,1556682.60,0.00,'2022-01-03 10:15:39'),(1688374,'5','184',429,'Sale Id shift 251130',0.00,1751852.85,165.00,1751852.85,0.00,'2022-01-05 11:36:26'),(1694104,'5','184',429,'Sale Id shift 251375',0.00,2591329.95,165.00,2591329.95,0.00,'2022-01-06 12:22:34'),(1699207,'5','184',429,'Sale Id shift 251635',0.00,2693283.45,165.00,2693283.45,0.00,'2022-01-07 11:44:49'),(1700391,'5','184',429,'Sale Id shift 251857',0.00,1753775.10,165.00,1753775.10,0.00,'2022-01-07 14:55:05'),(1705155,'5','184',429,'Sale Id shift 252091',0.00,693490.05,165.00,693490.05,0.00,'2022-01-08 13:23:27'),(1714487,'5','184',429,'Sale Id shift 252374',0.00,332925.45,165.00,332925.45,0.00,'2022-01-10 09:41:24'),(1718718,'5','184',429,'Sale Id shift 252602',0.00,209391.60,165.00,209391.60,0.00,'2022-01-10 20:36:38'),(1721336,'5','184',429,'Sale Id shift 252821',0.00,556488.90,165.00,556488.90,0.00,'2022-01-11 13:37:19'),(1725166,'5','184',429,'Sale Id shift 253047',0.00,1831036.35,165.00,1831036.35,0.00,'2022-01-12 10:17:19'),(1729858,'5','184',429,'Sale Id shift 253184',0.00,1823855.55,165.00,1823855.55,0.00,'2022-01-13 09:13:03'),(1738939,'5','184',429,'Sale Id shift 253380',0.00,1231720.05,165.00,1231720.05,0.00,'2022-01-14 22:09:20'),(1748724,'5','184',429,'Sale Id shift 254104',0.00,770625.90,165.00,770625.90,0.00,'2022-01-16 16:50:12'),(1748873,'5','184',429,'Sale Id shift 254120',0.00,393709.80,165.00,393709.80,0.00,'2022-01-16 17:08:39'),(1752539,'5','184',429,'Sale Id shift 254129',0.00,1239447.00,165.00,1239447.00,0.00,'2022-01-17 13:55:55'),(1758118,'5','184',429,'Sale Id shift 254399',0.00,819743.10,165.00,819743.10,0.00,'2022-01-18 13:24:29'),(1762550,'5','184',429,'Sale Id shift 254698',0.00,518169.30,165.00,518169.30,0.00,'2022-01-19 09:47:53'),(1770607,'5','184',429,'Sale Id shift 254808',0.00,177997.05,165.00,177997.05,0.00,'2022-01-20 13:21:14'),(1789784,'5','184',429,'Sale Id shift 255807',0.00,284306.55,165.00,284306.55,0.00,'2022-01-23 16:29:27'),(1797349,'5','184',429,'Sale Id shift 255938',0.00,1776152.40,165.00,1776152.40,0.00,'2022-01-25 09:12:05'),(1803244,'5','184',429,'Sale Id shift 256270',0.00,1859477.40,165.00,1859477.40,0.00,'2022-01-26 09:05:14'),(1808618,'5','184',429,'Sale Id shift 256665',0.00,1266445.95,165.00,1266445.95,0.00,'2022-01-27 10:05:23'),(1815342,'5','184',429,'Sale Id shift 256898',0.00,1252825.20,165.00,1252825.20,0.00,'2022-01-28 10:48:49'),(1817635,'5','184',429,'Sale Id shift 257101',0.00,796524.30,165.00,796524.30,0.00,'2022-01-28 15:18:12'),(1817636,'5','184',429,'Sale Id shift 257102',0.00,331212.75,165.00,331212.75,0.00,'2022-02-01 10:59:46'),(1817637,'5','184',429,'Sale Id shift 257103',0.00,261112.50,165.00,261112.50,0.00,'2022-02-01 11:05:10'),(1817638,'5','184',429,'Sale Id shift 257104',0.00,1479886.65,165.00,1479886.65,0.00,'2022-02-01 11:29:28'),(1817639,'5','184',429,'Sale Id shift 257105',0.00,1739524.05,165.00,1739524.05,0.00,'2022-02-01 14:55:15'),(1817640,'5','184',429,'Sale Id shift 257106',0.00,1664473.80,165.00,1664473.80,0.00,'2022-02-01 19:28:41'),(1817641,'5','184',429,'Sale Id shift 257107',0.00,872013.45,165.00,872013.45,0.00,'2022-02-03 14:00:23'),(1817642,'5','184',429,'Sale Id shift 257108',0.00,426929.25,165.00,426929.25,0.00,'2022-02-04 09:25:54'),(1817643,'5','184',429,'Sale Id shift 257109',0.00,179364.90,165.00,179364.90,0.00,'2022-02-06 05:24:50'),(1817644,'5','184',429,'Sale Id shift 257110',0.00,344978.70,165.00,344978.70,0.00,'2022-02-06 15:11:43'),(1817645,'5','184',429,'Sale Id shift 257111',0.00,1462383.45,165.00,1462383.45,0.00,'2022-02-07 11:26:23'),(1817646,'5','184',429,'Sale Id shift 257112',0.00,1707094.95,165.00,1707094.95,0.00,'2022-02-08 12:28:14'),(1817647,'5','184',429,'Sale Id shift 257113',0.00,1353646.80,165.00,1353646.80,0.00,'2022-02-09 10:57:48'),(1817648,'5','184',429,'Sale Id shift 257114',0.00,690584.40,165.00,690584.40,0.00,'2022-02-10 12:41:02'),(1817649,'5','184',429,'Sale Id shift 257115',0.00,704320.65,165.00,704320.65,0.00,'2022-02-11 09:43:47'),(1817650,'5','184',429,'Sale Id shift 257116',0.00,337583.40,165.00,337583.40,0.00,'2022-02-12 15:39:33'),(1817651,'5','184',429,'Sale Id shift 257121',0.00,919114.35,165.00,919114.35,0.00,'2022-02-17 09:30:49'),(1817652,'5','184',429,'Sale Id shift 257122',0.00,528457.05,165.00,528457.05,0.00,'2022-02-18 09:24:24'),(1817653,'5','184',429,'Sale Id shift 257123',0.00,526861.50,165.00,526861.50,0.00,'2022-02-19 11:49:57'),(1817654,'5','184',429,'Sale Id shift 257124',0.00,330452.10,165.00,330452.10,0.00,'2022-02-20 14:59:57'),(1817655,'5','184',429,'Sale Id shift 257125',0.00,329722.80,165.00,329722.80,0.00,'2022-02-21 14:21:58'),(1817656,'5','184',429,'Sale Id shift 257127',0.00,3409226.70,165.00,3409226.70,0.00,'2022-05-31 14:04:00'),(1817657,'5','184',429,'Sale Id shift 257128',0.00,58334.10,165.00,58334.10,0.00,'2022-05-31 14:10:59'),(1817658,'5','184',429,'Sale Id shift 257129',0.00,21926.85,165.00,21926.85,0.00,'2022-06-01 12:25:51'),(1817659,'5','184',430,'Sale Id shift 257130',0.00,840014.00,700.00,840014.00,0.00,'2022-06-01 14:20:48'),(1817660,'5','184',429,'Sale Id shift 257131',0.00,445500.00,165.00,445500.00,0.00,'2022-06-01 14:55:44'),(1817661,'5','184',431,'Sale Id shift 257132',0.00,40008.00,400.00,40008.00,0.00,'2022-06-02 14:11:19'),(1817662,'5','184',429,'Sale Id shift 257132',0.00,125414.85,165.00,125414.85,0.00,'2022-06-02 14:11:20'),(1817663,'5','184',429,'Sale Id shift 257134',0.00,8126.25,165.00,8126.25,0.00,'2022-06-05 09:13:15'),(1817664,'5','184',429,'Sale Id shift 257135',0.00,678996.45,165.00,678996.45,0.00,'2022-06-29 13:59:59'),(1817665,'5','184',429,'Sale Id shift 257137',0.00,994146.45,165.00,994146.45,0.00,'2022-06-29 14:26:53'),(1817666,'5','184',429,'Sale Id shift 257138',0.00,981543.75,165.00,981543.75,0.00,'2022-06-29 14:33:35'),(1817667,'5','184',429,'Sale Id shift 257139',0.00,722835.30,165.00,722835.30,0.00,'2022-06-29 14:45:48'),(1817668,'5','184',429,'Sale Id shift 257140',0.00,1064098.20,165.00,1064098.20,0.00,'2022-06-29 18:28:42'),(1817669,'5','184',429,'Sale Id shift 257141',0.00,659534.70,165.00,659534.70,0.00,'2022-06-29 19:21:14'),(1817670,'5','184',429,'Sale Id shift 257142',0.00,673284.15,165.00,673284.15,0.00,'2022-06-30 08:33:24'),(1817671,'5','184',429,'Sale Id shift 257143',0.00,674487.00,165.00,674487.00,0.00,'2022-06-30 11:31:30'),(1817672,'5','184',429,'Sale Id shift 257146',0.00,1288555.95,165.00,1288555.95,0.00,'2022-07-04 15:14:03'),(1817673,'5','184',429,'Sale Id shift 257147',0.00,681128.25,165.00,681128.25,0.00,'2022-07-04 15:32:35'),(1817674,'5','184',429,'Sale Id shift 257148',0.00,155128.05,165.00,155128.05,0.00,'2022-07-04 15:44:23'),(1817675,'5','184',429,'Sale Id shift 257149',0.00,443889.60,165.00,443889.60,0.00,'2022-07-04 15:52:52'),(1817676,'5','184',429,'Sale Id shift 257150',0.00,972244.35,165.00,972244.35,0.00,'2022-07-04 16:14:37'),(1817677,'5','184',429,'Sale Id shift 257151',0.00,1154930.70,165.00,1154930.70,0.00,'2022-07-04 16:28:18'),(1817678,'5','184',429,'Sale Id shift 257152',0.00,917947.80,165.00,917947.80,0.00,'2022-07-04 16:36:13'),(1817679,'5','184',429,'Sale Id shift 257153',0.00,503603.10,165.00,503603.10,0.00,'2022-07-05 09:16:32'),(1817680,'5','184',429,'Sale Id shift 257157',0.00,279068.80,165.00,248899.20,-30169.60,'2022-07-19 12:29:01'),(1817681,'5','184',429,'Sale Id shift 257158',0.00,872310.15,165.00,778006.35,-94303.80,'2022-07-19 13:59:37'),(1817682,'5','184',429,'Sale Id shift 257159',0.00,905162.45,165.00,807307.05,-97855.40,'2022-07-19 15:26:50'),(1817683,'5','184',429,'Sale Id shift 257160',0.00,944399.10,165.00,842301.90,-102097.20,'2022-07-20 09:09:24'),(1817684,'5','184',429,'Sale Id shift 257161',0.00,1074537.35,165.00,958371.15,-116166.20,'2022-07-20 10:48:52'),(1817685,'5','184',429,'Sale Id shift 257162',0.00,870917.10,165.00,776763.90,-94153.20,'2022-07-20 11:00:36'),(1817686,'5','184',429,'Sale Id shift 257163',0.00,945392.55,165.00,843187.95,-102204.60,'2022-07-21 08:58:38'),(1817687,'5','184',429,'Sale Id shift 257164',0.00,725712.45,165.00,647257.05,-78455.40,'2022-07-22 09:42:56'),(1817688,'5','184',429,'Sale Id shift 257165',0.00,2051220.80,165.00,1829467.20,-221753.60,'2022-07-23 10:34:10'),(1817689,'5','184',429,'Sale Id shift 257166',0.00,1595362.30,165.00,1422890.70,-172471.60,'2022-07-25 11:21:39'),(1817690,'5','184',429,'Sale Id shift 257167',0.00,1885614.35,165.00,1681764.15,-203850.20,'2022-07-25 11:32:46'),(1817691,'5','184',429,'Sale Id shift 257168',0.00,1232379.35,165.00,1099149.15,-133230.20,'2022-07-26 09:20:12'),(1817692,'5','184',429,'Sale Id shift 257169',0.00,763128.70,165.00,680628.30,-82500.40,'2022-07-27 09:16:22'),(1817693,'5','184',429,'Sale Id shift 257170',0.00,656920.20,165.00,585901.80,-71018.40,'2022-07-28 09:23:37'),(1817694,'5','184',429,'Sale Id shift 257171',0.00,451982.75,165.00,403119.75,-48863.00,'2022-07-29 09:15:36'),(1817695,'5','184',429,'Sale Id shift 257172',0.00,363323.35,165.00,324045.15,-39278.20,'2022-07-30 20:08:17'),(1817696,'5','184',429,'Sale Id shift 257176',0.00,1941079.20,165.00,1731232.80,-209846.40,'2022-09-03 10:06:27'),(1817697,'5','184',429,'Sale Id shift 257177',0.00,1199667.65,165.00,1069973.85,-129693.80,'2022-09-03 12:14:02'),(1817698,'5','184',429,'Sale Id shift 257178',0.00,957861.55,165.00,854308.95,-103552.60,'2022-09-03 12:19:00'),(1817699,'5','184',429,'Sale Id shift 257179',0.00,1092828.30,165.00,974684.70,-118143.60,'2022-09-03 13:37:36'),(1817700,'5','184',429,'Sale Id shift 257180',0.00,1363651.65,165.00,1216229.85,-147421.80,'2022-09-03 15:03:22'),(1817701,'5','184',429,'Sale Id shift 257181',0.00,837746.60,165.00,747179.40,-90567.20,'2022-09-03 16:57:19'),(1817702,'5','184',429,'Sale Id shift 257182',0.00,1362704.45,165.00,1215385.05,-147319.40,'2022-09-03 20:18:11'),(1817703,'5','184',429,'Sale Id shift 257183',0.00,1127952.40,165.00,1006011.60,-121940.80,'2022-09-04 11:33:15'),(1817704,'5','184',429,'Sale Id shift 257185',0.00,1260377.25,165.00,1124120.25,-136257.00,'2022-09-04 13:44:48'),(1817705,'5','184',429,'Sale Id shift 257186',0.00,1635079.95,165.00,1458314.55,-176765.40,'2022-09-04 13:49:05'),(1817706,'5','184',429,'Sale Id shift 257187',0.00,1467136.95,165.00,1308527.55,-158609.40,'2022-09-04 14:06:57'),(1817707,'5','184',429,'Sale Id shift 257188',0.00,1384758.30,165.00,1235054.70,-149703.60,'2022-09-04 14:32:04'),(1817708,'5','184',429,'Sale Id shift 257189',0.00,1162515.95,165.00,1036838.55,-125677.40,'2022-09-04 15:09:01'),(1817709,'5','184',429,'Sale Id shift 257190',0.00,802054.55,165.00,715345.95,-86708.60,'2022-09-04 16:00:04'),(1817710,'5','184',429,'Sale Id shift 257191',0.00,1068920.75,165.00,953361.75,-115559.00,'2022-09-04 17:38:44'),(1817711,'5','184',429,'Sale Id shift 257192',0.00,992639.70,165.00,885327.30,-107312.40,'2022-09-04 17:45:23'),(1817712,'5','184',429,'Sale Id shift 257193',0.00,1136023.95,165.00,1013210.55,-122813.40,'2022-09-04 17:48:11'),(1817713,'5','184',429,'Sale Id shift 257194',0.00,1399007.00,165.00,1247763.00,-151244.00,'2022-09-04 17:55:56'),(1817714,'5','184',429,'Sale Id shift 257195',0.00,1329694.90,165.00,1185944.10,-143750.80,'2022-09-04 17:59:50'),(1817715,'5','184',429,'Sale Id shift 257196',0.00,1730390.10,165.00,1543320.90,-187069.20,'2022-09-04 21:12:37'),(1817716,'5','184',429,'Sale Id shift 257197',0.00,1904887.65,165.00,1698953.85,-205933.80,'2022-09-05 10:23:59'),(1817717,'5','184',429,'Sale Id shift 257198',0.00,1669008.95,165.00,1488575.55,-180433.40,'2022-09-05 11:16:00'),(1817718,'5','184',429,'Sale Id shift 257199',0.00,2840502.95,165.00,2533421.55,-307081.40,'2022-09-05 11:34:52'),(1817719,'5','184',429,'Sale Id shift 257200',0.00,1343475.55,165.00,1198234.95,-145240.60,'2022-09-05 12:04:07'),(1817720,'5','184',429,'Sale Id shift 257201',0.00,1274729.55,165.00,1136920.95,-137808.60,'2022-09-05 12:08:42'),(1817721,'5','184',429,'Sale Id shift 257202',0.00,1525027.15,165.00,1360159.35,-164867.80,'2022-09-05 12:13:26'),(1817722,'5','184',429,'Sale Id shift 257203',0.00,1697983.65,165.00,1514417.85,-183565.80,'2022-09-05 12:18:22'),(1817723,'5','184',429,'Sale Id shift 257204',0.00,594926.70,165.00,530610.30,-64316.40,'2022-09-05 12:30:12'),(1817724,'5','184',429,'Sale Id shift 257205',0.00,2133040.75,165.00,1902441.75,-230599.00,'2022-09-05 13:48:26'),(1817725,'5','184',429,'Sale Id shift 257206',0.00,1666620.60,165.00,1486445.40,-180175.20,'2022-09-05 16:05:41'),(1817726,'5','184',429,'Sale Id shift 257207',0.00,1734708.00,165.00,1547172.00,-187536.00,'2022-09-06 10:21:55'),(1817727,'5','184',429,'Sale Id shift 257208',0.00,1140617.50,165.00,1017307.50,-123310.00,'2022-09-06 11:07:42'),(1817728,'5','184',429,'Sale Id shift 257209',0.00,651631.05,165.00,581184.45,-70446.60,'2022-09-08 10:10:24'),(1817729,'5','184',429,'Sale Id shift 257210',0.00,613646.85,165.00,547306.65,-66340.20,'2022-09-08 10:31:54'),(1817730,'5','184',429,'Sale Id shift 257214',0.00,1413797.75,165.00,1260954.75,-152843.00,'2022-09-12 10:06:57'),(1817731,'5','184',429,'Sale Id shift 257215',0.00,1293773.45,165.00,1153906.05,-139867.40,'2022-09-13 10:24:35'),(1817732,'5','184',429,'Sale Id shift 257216',0.00,1367671.70,165.00,1219815.30,-147856.40,'2022-09-14 10:18:13'),(1817733,'5','184',429,'Sale Id shift 257217',0.00,1322938.70,165.00,1179918.30,-143020.40,'2022-09-15 10:11:13'),(1817734,'5','184',429,'Sale Id shift 257218',0.00,1329176.90,165.00,1185482.10,-143694.80,'2022-09-16 10:17:44'),(1817735,'5','184',429,'Sale Id shift 257219',0.00,1444535.50,165.00,1288369.50,-156166.00,'2022-09-17 12:19:07'),(1817736,'5','184',429,'Sale Id shift 257220',0.00,1345242.30,165.00,1199810.70,-145431.60,'2022-09-18 14:56:19'),(1817737,'5','184',429,'Sale Id shift 257221',0.00,1269695.70,165.00,1132431.30,-137264.40,'2022-09-19 08:01:59'),(1817738,'5','184',429,'Sale Id shift 257222',0.00,1346189.50,165.00,1200655.50,-145534.00,'2022-09-20 09:19:04'),(1817739,'5','184',429,'Sale Id shift 257223',0.00,1290042.00,165.00,1150578.00,-139464.00,'2022-09-22 08:43:43'),(1817740,'5','184',429,'Sale Id shift 257224',0.00,1021716.15,185.00,1021716.15,0.00,'2022-09-28 10:53:02'),(1817741,'5','184',429,'Sale Id shift 257225',0.00,1188569.50,185.00,1188569.50,0.00,'2022-09-28 11:02:05'),(1817742,'5','184',429,'Sale Id shift 257226',0.00,1311507.55,185.00,1311507.55,0.00,'2022-09-28 11:09:51'),(1817743,'5','184',429,'Sale Id shift 257227',0.00,1228572.05,185.00,1228572.05,0.00,'2022-09-28 16:49:27'),(1817744,'5','184',429,'Sale Id shift 257228',0.00,1198986.85,185.00,1198986.85,0.00,'2022-09-29 19:41:56'),(1817745,'5','184',429,'Sale Id shift 257229',0.00,1283067.50,185.00,1283067.50,0.00,'2022-09-30 08:19:17'),(1817746,'5','184',429,'Sale Id shift 257230',0.00,1421943.30,185.00,1421943.30,0.00,'2022-10-01 10:24:11'),(1817747,'5','184',429,'Sale Id shift 257231',0.00,1357515.20,185.00,1357515.20,0.00,'2022-10-02 05:08:35'),(1817748,'5','184',429,'Sale Id shift 257232',0.00,1500930.90,185.00,1500930.90,0.00,'2022-10-03 05:56:51'),(1817749,'5','184',429,'Sale Id shift 257233',0.00,1446095.05,185.00,1446095.05,0.00,'2022-10-04 09:07:34'),(1817750,'5','184',429,'Sale Id shift 257234',0.00,1444629.85,185.00,1444629.85,0.00,'2022-10-05 06:18:04'),(1817751,'5','184',429,'Sale Id shift 257235',0.00,1277500.85,185.00,1277500.85,0.00,'2022-10-08 18:51:22'),(1817752,'5','184',429,'Sale Id shift 257256',0.00,2010117.50,185.00,2010117.50,0.00,'2022-10-29 13:30:52'),(1817753,'5','184',429,'Sale Id shift 257257',0.00,1209404.20,185.00,1209404.20,0.00,'2022-10-30 05:48:47'),(1817754,'5','184',429,'Sale Id shift 257258',0.00,1405235.95,185.00,1405235.95,0.00,'2022-10-31 06:02:17'),(1817755,'5','184',429,'Sale Id shift 257259',0.00,912523.60,185.00,912523.60,0.00,'2022-11-01 05:55:21'),(1817756,'5','184',429,'Sale Id shift 257260',0.00,1882504.50,185.00,1882504.50,0.00,'2022-11-02 06:03:20'),(1817757,'5','184',429,'Sale Id shift 257261',0.00,1647441.65,185.00,1647441.65,0.00,'2022-11-03 19:23:16'),(1817758,'5','184',429,'Sale Id shift 257262',0.00,1886981.50,185.00,1886981.50,0.00,'2022-11-04 10:59:58'),(1817759,'5','184',429,'Sale Id shift 257263',0.00,1970351.75,185.00,1970351.75,0.00,'2022-11-05 09:00:13'),(1817760,'5','184',429,'Sale Id shift 257264',0.00,1836559.75,185.00,1836559.75,0.00,'2022-11-05 22:08:36'),(1817761,'5','184',429,'Sale Id shift 257265',0.00,1866402.10,185.00,1866402.10,0.00,'2022-11-07 06:07:00'),(1817762,'5','184',429,'Sale Id shift 257266',0.00,1727393.10,185.00,1727393.10,0.00,'2022-11-08 08:18:03'),(1817763,'5','184',429,'Sale Id shift 257267',0.00,1072291.45,185.00,1072291.45,0.00,'2022-11-09 08:14:55'),(1817764,'5','184',429,'Sale Id shift 257268',0.00,2034938.95,185.00,2034938.95,0.00,'2022-11-10 09:29:41'),(1817765,'5','184',429,'Sale Id shift 257269',0.00,1303132.60,185.00,1303132.60,0.00,'2022-11-11 09:27:22'),(1817766,'5','184',429,'Sale Id shift 257270',0.00,1288787.70,185.00,1288787.70,0.00,'2022-11-12 09:29:11'),(1817767,'5','184',429,'Sale Id shift 257271',0.00,72155.55,185.00,72155.55,0.00,'2022-11-13 06:01:10'),(1817768,'5','184',429,'Sale Id shift 257279',0.00,505009.30,185.00,505009.30,0.00,'2022-11-21 10:10:57'),(1817769,'5','184',429,'Sale Id shift 257280',0.00,1615506.95,185.00,1615506.95,0.00,'2022-11-22 08:12:26'),(1817770,'5','184',429,'Sale Id shift 257281',0.00,1325969.00,185.00,1325969.00,0.00,'2022-11-23 06:11:41'),(1817771,'5','184',429,'Sale Id shift 257282',0.00,1509840.50,185.00,1509840.50,0.00,'2022-11-24 06:45:59'),(1817772,'5','184',429,'Sale Id shift 257283',0.00,1158268.35,185.00,1158268.35,0.00,'2022-11-25 06:09:03'),(1817773,'5','184',429,'Sale Id shift 257284',0.00,1000047.10,185.00,1000047.10,0.00,'2022-11-26 09:24:10'),(1817774,'5','184',429,'Sale Id shift 257285',0.00,271282.15,185.00,271282.15,0.00,'2022-11-27 09:29:51'),(1817775,'5','184',429,'Sale Id shift 257288',0.00,555538.35,185.00,555538.35,0.00,'2022-11-30 11:00:15'),(1817776,'5','184',429,'Sale Id shift 257289',0.00,2527858.50,185.00,2527858.50,0.00,'2022-12-01 06:04:29'),(1817777,'5','184',429,'Sale Id shift 257290',0.00,1060503.25,185.00,1060503.25,0.00,'2022-12-02 06:13:18'),(1817778,'5','184',429,'Sale Id shift 257291',0.00,1503803.95,185.00,1503803.95,0.00,'2022-12-03 10:11:44'),(1817779,'5','184',429,'Sale Id shift 257292',0.00,1088743.50,185.00,1088743.50,0.00,'2022-12-04 09:07:04'),(1817780,'5','184',429,'Sale Id shift 257293',0.00,1035372.85,185.00,1035372.85,0.00,'2022-12-05 06:06:32'),(1817781,'5','184',429,'Sale Id shift 257294',0.00,546872.95,185.00,546872.95,0.00,'2022-12-06 15:17:34'),(1817782,'5','184',429,'Sale Id shift 257307',0.00,417774.40,185.00,417774.40,0.00,'2022-12-20 12:15:28'),(1817783,'5','184',429,'Sale Id shift 257308',0.00,1142881.90,185.00,1142881.90,0.00,'2022-12-20 13:45:10'),(1817784,'5','184',429,'Sale Id shift 257309',0.00,1344483.80,185.00,1344483.80,0.00,'2022-12-21 10:38:14'),(1817785,'5','184',429,'Sale Id shift 257310',0.00,1572548.10,185.00,1572548.10,0.00,'2022-12-21 19:17:57'),(1817786,'5','184',429,'Sale Id shift 257311',0.00,557915.60,185.00,557915.60,0.00,'2022-12-23 09:57:56'),(1817787,'5','184',429,'Sale Id shift 257312',0.00,503277.70,185.00,503277.70,0.00,'2022-12-24 09:01:08'),(1817788,'5','184',429,'Sale Id shift 257337',0.00,1336465.90,185.00,1336465.90,0.00,'2023-01-18 09:26:14'),(1817789,'5','184',429,'Sale Id shift 257338',0.00,2157322.00,185.00,2157322.00,0.00,'2023-01-19 09:34:30'),(1817790,'5','184',429,'Sale Id shift 257339',0.00,1320076.75,185.00,1320076.75,0.00,'2023-01-19 19:20:55'),(1817791,'5','184',429,'Sale Id shift 257340',0.00,1065409.45,185.00,1065409.45,0.00,'2023-01-21 10:51:03'),(1817792,'5','184',429,'Sale Id shift 257341',0.00,824717.05,220.00,980744.60,156027.55,'2023-01-22 20:43:03'),(1817793,'5','184',429,'Sale Id shift 257342',0.00,607121.90,220.00,721982.80,114860.90,'2023-01-25 09:39:54'),(1817794,'5','184',429,'Sale Id shift 257347',0.00,1666519.80,220.00,1666519.80,0.00,'2023-01-28 23:53:16'),(1817795,'5','184',429,'Sale Id shift 257348',0.00,1720043.60,220.00,1720043.60,0.00,'2023-01-29 21:10:56'),(1817796,'5','184',429,'Sale Id shift 257349',0.00,1426713.20,220.00,1426713.20,0.00,'2023-01-30 09:49:59'),(1817797,'5','184',429,'Sale Id shift 257350',0.00,2160092.00,220.00,2160092.00,0.00,'2023-01-31 09:54:28'),(1817798,'5','184',429,'Sale Id shift 257353',0.00,1382979.40,220.00,1382979.40,0.00,'2023-02-04 18:10:16'),(1817799,'5','184',429,'Sale Id shift 257354',0.00,889229.00,220.00,889229.00,0.00,'2023-02-05 20:46:29'),(1817800,'5','184',429,'Sale Id shift 257355',0.00,1338290.80,220.00,1338290.80,0.00,'2023-02-06 13:48:06'),(1817801,'5','184',429,'Sale Id shift 257356',0.00,127206.20,185.00,106968.85,-20237.35,'2023-02-07 13:03:27'),(1817802,'5','184',429,'Sale Id shift 257359',0.00,1380504.40,220.00,1380504.40,0.00,'2023-02-10 15:48:42'),(1817803,'5','184',429,'Sale Id shift 257360',0.00,1312579.40,220.00,1312579.40,0.00,'2023-02-11 12:40:23'),(1817804,'5','184',429,'Sale Id shift 257361',0.00,611050.00,220.00,611050.00,0.00,'2023-02-12 09:18:41'),(1817805,'5','184',429,'Sale Id shift 257372',0.00,262470.60,210.00,262470.60,0.00,'2023-02-26 13:03:00'),(1817806,'5','184',429,'Sale Id shift 257374',0.00,967953.00,210.00,967953.00,0.00,'2023-02-27 13:10:19'),(1817807,'5','184',429,'Sale Id shift 257375',0.00,1039441.20,210.00,1039441.20,0.00,'2023-02-27 22:49:48'),(1817808,'5','184',429,'Sale Id shift 257376',0.00,1390565.40,210.00,1390565.40,0.00,'2023-02-28 20:22:24'),(1817809,'5','184',429,'Sale Id shift 257377',0.00,1700353.20,210.00,1700353.20,0.00,'2023-03-02 09:44:01'),(1817810,'5','184',429,'Sale Id shift 257378',0.00,1496287.80,210.00,1496287.80,0.00,'2023-03-03 13:18:54'),(1817811,'5','184',429,'Sale Id shift 257379',0.00,1717968.00,210.00,1717968.00,0.00,'2023-03-04 12:41:06'),(1817812,'5','184',429,'Sale Id shift 257380',0.00,1693549.20,210.00,1693549.20,0.00,'2023-03-05 14:55:09'),(1817813,'5','184',429,'Sale Id shift 257381',0.00,2175014.10,210.00,2175014.10,0.00,'2023-03-06 09:41:29'),(1817814,'5','184',429,'Sale Id shift 257382',0.00,1521055.20,210.00,1521055.20,0.00,'2023-03-06 21:16:59'),(1817815,'5','184',429,'Sale Id shift 257385',0.00,2427276.60,210.00,2427276.60,0.00,'2023-03-08 12:17:03'),(1817816,'5','184',429,'Sale Id shift 257386',0.00,1729608.30,210.00,1729608.30,0.00,'2023-03-09 09:15:22'),(1817817,'5','184',429,'Sale Id shift 257387',0.00,1401714.30,210.00,1401714.30,0.00,'2023-03-10 13:45:10'),(1817818,'5','184',429,'Sale Id shift 257388',0.00,1643271.00,210.00,1643271.00,0.00,'2023-03-11 13:21:32'),(1817819,'5','184',429,'Sale Id shift 257389',0.00,1806760.20,210.00,1806760.20,0.00,'2023-03-12 15:48:29'),(1817820,'5','184',429,'Sale Id shift 257390',0.00,1639274.70,210.00,1639274.70,0.00,'2023-03-13 09:55:48'),(1817821,'5','184',429,'Sale Id shift 257391',0.00,1577211.30,210.00,1577211.30,0.00,'2023-03-15 12:06:16');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4930945 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','184',2812574,'','24','3481',0.00,7383750.00,'Purchase Id 72465 for 44,750.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-15 08:55:20','',''),('5','184',2812575,'','supplier','253',7383750.00,0.00,'Purchase Id 72465 for 44,750.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-15 08:55:20','',''),('5','184',2812593,'','24','3481',0.00,4480500.00,'Purchase Id 72464 for 15,450.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-07-15 08:56:45','',''),('5','184',2812594,'','supplier','253',4480500.00,0.00,'Purchase Id 72464 for 15,450.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-07-15 08:56:45','',''),('5','184',2812599,'','24','3481',0.00,14751000.00,'Purchase Id 72462 for 89,400.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-15 08:57:05','',''),('5','184',2812600,'','supplier','253',14751000.00,0.00,'Purchase Id 72462 for 89,400.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-15 08:57:05','',''),('5','184',2901279,'','20','3479',1008047.55,0.00,'Sales from shift 212338 on 2021-07-26 14:14:44 ','2021-07-26 14:14:44','',''),('5','184',2901280,'','6.1','3483',0.00,1008047.55,'Sales from shift 212338 on 2021-07-26 14:14:44 ','2021-07-26 14:14:44','',''),('5','184',2901454,'','20','3479',1327495.05,0.00,'Sales from shift 213030 on 2021-07-26 14:27:04 ','2021-07-26 14:27:04','',''),('5','184',2901455,'','6.1','3483',0.00,1327495.05,'Sales from shift 213030 on 2021-07-26 14:27:04 ','2021-07-26 14:27:04','',''),('5','184',2901676,'','2','3508',540620.00,0.00,'Payment Id 302038 for invoice:212338, receipt: 01151339 by SALBAS OIL & GAS LIMITED','2021-07-26 14:44:00','',''),('5','184',2901677,'','supplier','253',0.00,540620.00,'Payment Id 302038 for invoice:212338, receipt: 01151339 by SALBAS OIL & GAS LIMITED','2021-07-26 14:44:00','',''),('5','184',2901684,'','2','3508',1129895.00,0.00,'Payment Id 303365 for invoice:213030, receipt: 01150919 by SALBAS OIL & GAS LIMITED','2021-07-26 14:44:23','',''),('5','184',2901685,'','supplier','253',0.00,1129895.00,'Payment Id 303365 for invoice:213030, receipt: 01150919 by SALBAS OIL & GAS LIMITED','2021-07-26 14:44:23','',''),('5','184',2901694,'','20','3479',1520195.65,0.00,'Sales from shift 213036 on 2021-07-26 14:44:46 ','2021-07-26 14:44:46','',''),('5','184',2901695,'','6.1','3483',0.00,1520195.65,'Sales from shift 213036 on 2021-07-26 14:44:46 ','2021-07-26 14:44:46','',''),('5','184',2901903,'','20','3479',654501.05,0.00,'Sales from shift 213043 on 2021-07-26 14:58:42 ','2021-07-26 14:58:42','',''),('5','184',2901904,'','6.1','3483',0.00,654501.05,'Sales from shift 213043 on 2021-07-26 14:58:42 ','2021-07-26 14:58:42','',''),('5','184',2902827,'','20','3479',0.00,0.00,'Sales from shift 213057 on 2021-07-26 15:50:03 ','2021-07-26 15:50:03','',''),('5','184',2902828,'','6.1','3483',0.00,0.00,'Sales from shift 213057 on 2021-07-26 15:50:03 ','2021-07-26 15:50:03','',''),('5','184',2903010,'','20','3479',0.00,0.00,'Sales from shift 213061 on 2021-07-26 15:54:46 ','2021-07-26 15:54:46','',''),('5','184',2903011,'','6.1','3483',0.00,0.00,'Sales from shift 213061 on 2021-07-26 15:54:46 ','2021-07-26 15:54:46','',''),('5','184',2903232,'','2','3508',1434195.00,0.00,'Payment Id 303393 for invoice:213036, receipt: 01151703 by SALBAS OIL & GAS LIMITED','2021-07-26 16:04:37','',''),('5','184',2903233,'','supplier','253',0.00,1434195.00,'Payment Id 303393 for invoice:213036, receipt: 01151703 by SALBAS OIL & GAS LIMITED','2021-07-26 16:04:37','',''),('5','184',2903522,'','2','3456',520740.00,0.00,'Payment Id 303431 for invoice:213062, receipt: 130569 by SALBAS OIL & GAS LIMITED','2021-07-26 16:17:40','',''),('5','184',2903523,'','supplier','253',0.00,520740.00,'Payment Id 303431 for invoice:213062, receipt: 130569 by SALBAS OIL & GAS LIMITED','2021-07-26 16:17:40','',''),('5','184',2903624,'','20','3479',473927.20,0.00,'Sales from shift 213062 on 2021-07-26 16:22:42 ','2021-07-26 16:22:42','',''),('5','184',2903625,'','6.1','3483',0.00,473927.20,'Sales from shift 213062 on 2021-07-26 16:22:42 ','2021-07-26 16:22:42','',''),('5','184',2903670,'','2','3456',451675.00,0.00,'Payment Id 303441 for invoice:213062, receipt: 131764 by SALBAS OIL & GAS LIMITED','2021-07-26 16:25:16','',''),('5','184',2903671,'','supplier','253',0.00,451675.00,'Payment Id 303441 for invoice:213062, receipt: 131764 by SALBAS OIL & GAS LIMITED','2021-07-26 16:25:16','',''),('5','184',2906915,'','20','3479',1240831.65,0.00,'Sales from shift 213068 on 2021-07-27 09:25:19 ','2021-07-27 09:25:19','',''),('5','184',2906916,'','6.1','3483',0.00,1240831.65,'Sales from shift 213068 on 2021-07-27 09:25:19 ','2021-07-27 09:25:19','',''),('5','184',2906921,'','2','3508',1172260.00,0.00,'Payment Id 303459 for invoice:213068, receipt: 3880010 by SALBAS OIL & GAS LIMITED','2021-07-27 09:25:54','',''),('5','184',2906922,'','supplier','253',0.00,1172260.00,'Payment Id 303459 for invoice:213068, receipt: 3880010 by SALBAS OIL & GAS LIMITED','2021-07-27 09:25:54','',''),('5','184',2908047,'','20','3479',1414184.05,0.00,'Sales from shift 213228 on 2021-07-27 10:39:58 ','2021-07-27 10:39:58','',''),('5','184',2908048,'','6.1','3483',0.00,1414184.05,'Sales from shift 213228 on 2021-07-27 10:39:58 ','2021-07-27 10:39:58','',''),('5','184',2908061,'','2','3508',1294430.00,0.00,'Payment Id 303787 for invoice:213228, receipt: 9800009 by SALBAS OIL & GAS LIMITED','2021-07-27 10:40:39','',''),('5','184',2908062,'','supplier','253',0.00,1294430.00,'Payment Id 303787 for invoice:213228, receipt: 9800009 by SALBAS OIL & GAS LIMITED','2021-07-27 10:40:39','',''),('5','184',2908306,'','20','3479',1231692.85,0.00,'Sales from shift 213237 on 2021-07-27 10:54:35 ','2021-07-27 10:54:35','',''),('5','184',2908307,'','6.1','3483',0.00,1231692.85,'Sales from shift 213237 on 2021-07-27 10:54:35 ','2021-07-27 10:54:35','',''),('5','184',2908314,'','2','3508',1113590.00,0.00,'Payment Id 303805 for invoice:213237, receipt: 6010013 by SALBAS OIL & GAS LIMITED','2021-07-27 10:55:11','',''),('5','184',2908315,'','supplier','253',0.00,1113590.00,'Payment Id 303805 for invoice:213237, receipt: 6010013 by SALBAS OIL & GAS LIMITED','2021-07-27 10:55:11','',''),('5','184',2908602,'','20','3479',1609377.30,0.00,'Sales from shift 213242 on 2021-07-27 11:17:48 ','2021-07-27 11:17:48','',''),('5','184',2908603,'','6.1','3483',0.00,1609377.30,'Sales from shift 213242 on 2021-07-27 11:17:48 ','2021-07-27 11:17:48','',''),('5','184',2908608,'','2','3508',1509180.00,0.00,'Payment Id 303834 for invoice:213242, receipt: 3490016 by SALBAS OIL & GAS LIMITED','2021-07-27 11:18:04','',''),('5','184',2908609,'','supplier','253',0.00,1509180.00,'Payment Id 303834 for invoice:213242, receipt: 3490016 by SALBAS OIL & GAS LIMITED','2021-07-27 11:18:04','',''),('5','184',2908921,'','20','3479',1257874.80,0.00,'Sales from shift 213260 on 2021-07-27 11:45:09 ','2021-07-27 11:45:09','',''),('5','184',2908922,'','6.1','3483',0.00,1257874.80,'Sales from shift 213260 on 2021-07-27 11:45:09 ','2021-07-27 11:45:09','',''),('5','184',2908923,'','2','3508',1105775.00,0.00,'Payment Id 303857 for invoice:213260, receipt: 3490016 by SALBAS OIL & GAS LIMITED','2021-07-27 11:45:26','',''),('5','184',2908924,'','supplier','253',0.00,1105775.00,'Payment Id 303857 for invoice:213260, receipt: 3490016 by SALBAS OIL & GAS LIMITED','2021-07-27 11:45:26','',''),('5','184',2909857,'','20','3479',1179263.90,0.00,'Sales from shift 213284 on 2021-07-27 13:05:31 ','2021-07-27 13:05:31','',''),('5','184',2909858,'','6.1','3483',0.00,1179263.90,'Sales from shift 213284 on 2021-07-27 13:05:31 ','2021-07-27 13:05:31','',''),('5','184',2909866,'','2','3508',1063265.00,0.00,'Payment Id 303913 for invoice:213284, receipt: 2520017 by SALBAS OIL & GAS LIMITED','2021-07-27 13:06:14','',''),('5','184',2909867,'','supplier','253',0.00,1063265.00,'Payment Id 303913 for invoice:213284, receipt: 2520017 by SALBAS OIL & GAS LIMITED','2021-07-27 13:06:14','',''),('5','184',2911523,'','20','3479',921683.05,0.00,'Sales from shift 213305 on 2021-07-27 14:44:04 ','2021-07-27 14:44:04','',''),('5','184',2911524,'','6.1','3483',0.00,921683.05,'Sales from shift 213305 on 2021-07-27 14:44:04 ','2021-07-27 14:44:04','',''),('5','184',2911537,'','2','3456',844540.00,0.00,'Payment Id 303974 for invoice:213305, receipt: 133307 by SALBAS OIL & GAS LIMITED','2021-07-27 14:44:48','',''),('5','184',2911538,'','supplier','253',0.00,844540.00,'Payment Id 303974 for invoice:213305, receipt: 133307 by SALBAS OIL & GAS LIMITED','2021-07-27 14:44:48','',''),('5','184',2913598,'','20','3479',1035401.05,0.00,'Sales from shift 213338 on 2021-07-27 16:26:54 ','2021-07-27 16:26:54','',''),('5','184',2913599,'','6.1','3483',0.00,1035401.05,'Sales from shift 213338 on 2021-07-27 16:26:54 ','2021-07-27 16:26:54','',''),('5','184',2913876,'','20','3479',1472914.10,0.00,'Sales from shift 213346 on 2021-07-27 16:43:07 ','2021-07-27 16:43:07','',''),('5','184',2913877,'','6.1','3483',0.00,1472914.10,'Sales from shift 213346 on 2021-07-27 16:43:07 ','2021-07-27 16:43:07','',''),('5','184',2914285,'','24','3481',0.00,6600000.00,'Purchase Id 73320 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-27 17:21:22','',''),('5','184',2914286,'','supplier','253',6600000.00,0.00,'Purchase Id 73320 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-27 17:21:22','',''),('5','184',2917348,'','2','3508',892900.00,0.00,'Payment Id 304028 for invoice:213338, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 10:03:25','',''),('5','184',2917349,'','supplier','253',0.00,892900.00,'Payment Id 304028 for invoice:213338, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 10:03:25','',''),('5','184',2917366,'','2','3508',1322355.00,0.00,'Payment Id 304045 for invoice:213346, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 10:04:27','',''),('5','184',2917367,'','supplier','253',0.00,1322355.00,'Payment Id 304045 for invoice:213346, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 10:04:27','',''),('5','184',2918852,'','20','3479',1246933.80,0.00,'Sales from shift 213481 on 2021-07-28 11:48:48 ','2021-07-28 11:48:48','',''),('5','184',2918853,'','6.1','3483',0.00,1246933.80,'Sales from shift 213481 on 2021-07-28 11:48:48 ','2021-07-28 11:48:48','',''),('5','184',2918975,'','20','3479',869074.80,0.00,'Sales from shift 213502 on 2021-07-28 11:57:38 ','2021-07-28 11:57:38','',''),('5','184',2918976,'','6.1','3483',0.00,869074.80,'Sales from shift 213502 on 2021-07-28 11:57:38 ','2021-07-28 11:57:38','',''),('5','184',2919160,'','20','3479',1072632.45,0.00,'Sales from shift 213509 on 2021-07-28 12:17:26 ','2021-07-28 12:17:26','',''),('5','184',2919161,'','6.1','3483',0.00,1072632.45,'Sales from shift 213509 on 2021-07-28 12:17:26 ','2021-07-28 12:17:26','',''),('5','184',2919533,'','2','3508',1110335.00,0.00,'Payment Id 304375 for invoice:213481, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:12','',''),('5','184',2919534,'','supplier','253',0.00,1110335.00,'Payment Id 304375 for invoice:213481, receipt: 8900005 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:12','',''),('5','184',2919537,'','2','3456',774875.00,0.00,'Payment Id 304387 for invoice:213502, receipt: 134282 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:35','',''),('5','184',2919538,'','supplier','253',0.00,774875.00,'Payment Id 304387 for invoice:213502, receipt: 134282 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:35','',''),('5','184',2919541,'','2','3456',985855.00,0.00,'Payment Id 304394 for invoice:213509, receipt: 134745 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:56','',''),('5','184',2919542,'','supplier','253',0.00,985855.00,'Payment Id 304394 for invoice:213509, receipt: 134745 by SALBAS OIL & GAS LIMITED','2021-07-28 12:45:56','',''),('5','184',2924696,'','20','3479',1300562.10,0.00,'Sales from shift 213562 on 2021-07-29 08:56:30 ','2021-07-29 08:56:30','',''),('5','184',2924697,'','6.1','3483',0.00,1300562.10,'Sales from shift 213562 on 2021-07-29 08:56:30 ','2021-07-29 08:56:30','',''),('5','184',2929495,'','2','3456',1113610.00,0.00,'Payment Id 304991 for invoice:213562, receipt: 135386 by SALBAS OIL & GAS LIMITED','2021-07-29 15:25:13','',''),('5','184',2929496,'','supplier','253',0.00,1113610.00,'Payment Id 304991 for invoice:213562, receipt: 135386 by SALBAS OIL & GAS LIMITED','2021-07-29 15:25:13','',''),('5','184',2931896,'','20','3479',1079326.10,0.00,'Sales from shift 213688 on 2021-07-29 23:09:42 ','2021-07-29 23:09:42','',''),('5','184',2931897,'','6.1','3483',0.00,1079326.10,'Sales from shift 213688 on 2021-07-29 23:09:42 ','2021-07-29 23:09:42','',''),('5','184',2939951,'','2','3456',956875.00,0.00,'Payment Id 305541 for invoice:213899, receipt: 136115 by SALBAS OIL & GAS LIMITED','2021-07-30 16:42:08','',''),('5','184',2939952,'','supplier','253',0.00,956875.00,'Payment Id 305541 for invoice:213899, receipt: 136115 by SALBAS OIL & GAS LIMITED','2021-07-30 16:42:08','',''),('5','184',2942137,'','20','3479',1280529.75,0.00,'Sales from shift 213899 on 2021-07-31 08:30:30 ','2021-07-31 08:30:30','',''),('5','184',2942138,'','6.1','3483',0.00,1280529.75,'Sales from shift 213899 on 2021-07-31 08:30:30 ','2021-07-31 08:30:30','',''),('5','184',2950161,'','24','3481',0.00,8225250.00,'Purchase Id 73562 for 49,850.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-31 18:21:54','',''),('5','184',2950162,'','supplier','253',8225250.00,0.00,'Purchase Id 73562 for 49,850.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-07-31 18:21:54','',''),('5','184',2966928,'','20','3479',1020346.00,0.00,'Sales from shift 214142 on 2021-08-02 19:17:59 ','2021-08-02 19:17:59','',''),('5','184',2966929,'','6.1','3483',0.00,1020346.00,'Sales from shift 214142 on 2021-08-02 19:17:59 ','2021-08-02 19:17:59','',''),('5','184',2973016,'','2','3508',1186430.00,0.00,'Payment Id 307127 for invoice:213899, receipt: 270cnr0037 by SALBAS OIL & GAS LIMITED','2021-08-03 11:57:30','',''),('5','184',2973017,'','supplier','253',0.00,1186430.00,'Payment Id 307127 for invoice:213899, receipt: 270cnr0037 by SALBAS OIL & GAS LIMITED','2021-08-03 11:57:30','',''),('5','184',2973024,'','2','3508',957895.00,0.00,'Payment Id 307134 for invoice:214142, receipt: 004chq0041 by SALBAS OIL & GAS LIMITED','2021-08-03 11:57:47','',''),('5','184',2973025,'','supplier','253',0.00,957895.00,'Payment Id 307134 for invoice:214142, receipt: 004chq0041 by SALBAS OIL & GAS LIMITED','2021-08-03 11:57:47','',''),('5','184',2973032,'','2','3508',1165400.00,0.00,'Payment Id 307202 for invoice:214754, receipt: 105cnr0040 by SALBAS OIL & GAS LIMITED','2021-08-03 11:58:05','',''),('5','184',2973033,'','supplier','253',0.00,1165400.00,'Payment Id 307202 for invoice:214754, receipt: 105cnr0040 by SALBAS OIL & GAS LIMITED','2021-08-03 11:58:05','',''),('5','184',2974812,'','20','3479',1283693.65,0.00,'Sales from shift 214754 on 2021-08-03 13:54:32 ','2021-08-03 13:54:32','',''),('5','184',2974813,'','6.1','3483',0.00,1283693.65,'Sales from shift 214754 on 2021-08-03 13:54:32 ','2021-08-03 13:54:32','',''),('5','184',2975464,'','20','3479',1331949.05,0.00,'Sales from shift 214933 on 2021-08-03 14:40:21 ','2021-08-03 14:40:21','',''),('5','184',2975465,'','6.1','3483',0.00,1331949.05,'Sales from shift 214933 on 2021-08-03 14:40:21 ','2021-08-03 14:40:21','',''),('5','184',2975666,'','2','3456',1202345.00,0.00,'Payment Id 307558 for invoice:214933, receipt: 137280 by SALBAS OIL & GAS LIMITED','2021-08-03 14:49:25','',''),('5','184',2975667,'','supplier','253',0.00,1202345.00,'Payment Id 307558 for invoice:214933, receipt: 137280 by SALBAS OIL & GAS LIMITED','2021-08-03 14:49:25','',''),('5','184',2978708,'','20','3479',966418.65,0.00,'Sales from shift 214938 on 2021-08-03 23:19:19 ','2021-08-03 23:19:19','',''),('5','184',2978709,'','6.1','3483',0.00,966418.65,'Sales from shift 214938 on 2021-08-03 23:19:19 ','2021-08-03 23:19:19','',''),('5','184',2982997,'','2','3456',850020.00,0.00,'Payment Id 307882 for invoice:214938, receipt: 137888 by SALBAS OIL & GAS LIMITED','2021-08-04 12:21:21','',''),('5','184',2982998,'','supplier','253',0.00,850020.00,'Payment Id 307882 for invoice:214938, receipt: 137888 by SALBAS OIL & GAS LIMITED','2021-08-04 12:21:21','',''),('5','184',2993636,'','20','3479',1289075.45,0.00,'Sales from shift 215288 on 2021-08-05 15:32:27 ','2021-08-05 15:32:27','',''),('5','184',2993637,'','6.1','3483',0.00,1289075.45,'Sales from shift 215288 on 2021-08-05 15:32:27 ','2021-08-05 15:32:27','',''),('5','184',2995420,'','20','3479',1222117.25,0.00,'Sales from shift 215400 on 2021-08-06 05:27:19 ','2021-08-06 05:27:19','',''),('5','184',2995421,'','6.1','3483',0.00,1222117.25,'Sales from shift 215400 on 2021-08-06 05:27:19 ','2021-08-06 05:27:19','',''),('5','184',3022460,'','20','3479',1147950.10,0.00,'Sales from shift 215500 on 2021-08-09 08:04:52 ','2021-08-09 08:04:52','',''),('5','184',3022461,'','6.1','3483',0.00,1147950.10,'Sales from shift 215500 on 2021-08-09 08:04:52 ','2021-08-09 08:04:52','',''),('5','184',3032967,'','24','3481',0.00,6435000.00,'Purchase Id 74175 for 39,000.00 litters of Kerosene - DPK from SALBAS OIL & GAS LIMITED','2021-08-10 11:09:02','',''),('5','184',3032968,'','supplier','253',6435000.00,0.00,'Purchase Id 74175 for 39,000.00 litters of Kerosene - DPK from SALBAS OIL & GAS LIMITED','2021-08-10 11:09:02','',''),('5','184',3032976,'','24','3481',0.00,6490000.00,'Purchase Id 74174 for 22,000.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-08-10 11:09:24','',''),('5','184',3032977,'','supplier','253',6490000.00,0.00,'Purchase Id 74174 for 22,000.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-08-10 11:09:24','',''),('5','184',3046045,'','2','3456',1210270.00,0.00,'Payment Id 308663 for invoice:215288, receipt: 138613 by SALBAS OIL & GAS LIMITED','2021-08-11 14:27:20','',''),('5','184',3046046,'','supplier','253',0.00,1210270.00,'Payment Id 308663 for invoice:215288, receipt: 138613 by SALBAS OIL & GAS LIMITED','2021-08-11 14:27:20','',''),('5','184',3046088,'','2','3456',1154220.00,0.00,'Payment Id 308894 for invoice:215400, receipt: 139106 by SALBAS OIL & GAS LIMITED','2021-08-11 14:29:47','',''),('5','184',3046089,'','supplier','253',0.00,1154220.00,'Payment Id 308894 for invoice:215400, receipt: 139106 by SALBAS OIL & GAS LIMITED','2021-08-11 14:29:47','',''),('5','184',3046096,'','2','3456',765150.00,0.00,'Payment Id 311504 for invoice:215500, receipt: 140114 by SALBAS OIL & GAS LIMITED','2021-08-11 14:30:18','',''),('5','184',3046097,'','supplier','253',0.00,765150.00,'Payment Id 311504 for invoice:215500, receipt: 140114 by SALBAS OIL & GAS LIMITED','2021-08-11 14:30:18','',''),('5','184',3051551,'','2','3456',1201735.00,0.00,'Payment Id 311506 for invoice:216434, receipt: 140110 by SALBAS OIL & GAS LIMITED','2021-08-12 11:05:45','',''),('5','184',3051552,'','supplier','253',0.00,1201735.00,'Payment Id 311506 for invoice:216434, receipt: 140110 by SALBAS OIL & GAS LIMITED','2021-08-12 11:05:45','',''),('5','184',3051868,'','20','3479',1352435.05,0.00,'Sales from shift 216434 on 2021-08-12 11:32:39 ','2021-08-12 11:32:39','',''),('5','184',3051869,'','6.1','3483',0.00,1352435.05,'Sales from shift 216434 on 2021-08-12 11:32:39 ','2021-08-12 11:32:39','',''),('5','184',3056804,'','20','3479',1233153.70,0.00,'Sales from shift 216887 on 2021-08-12 18:21:43 ','2021-08-12 18:21:43','',''),('5','184',3056805,'','6.1','3483',0.00,1233153.70,'Sales from shift 216887 on 2021-08-12 18:21:43 ','2021-08-12 18:21:43','',''),('5','184',3056896,'','20','3479',887365.05,0.00,'Sales from shift 216984 on 2021-08-12 19:32:27 ','2021-08-12 19:32:27','',''),('5','184',3056897,'','6.1','3483',0.00,887365.05,'Sales from shift 216984 on 2021-08-12 19:32:27 ','2021-08-12 19:32:27','',''),('5','184',3056903,'','20','3479',1040955.30,0.00,'Sales from shift 216992 on 2021-08-12 19:45:37 ','2021-08-12 19:45:37','',''),('5','184',3056904,'','6.1','3483',0.00,1040955.30,'Sales from shift 216992 on 2021-08-12 19:45:37 ','2021-08-12 19:45:37','',''),('5','184',3056974,'','20','3479',961627.95,0.00,'Sales from shift 216994 on 2021-08-12 20:20:21 ','2021-08-12 20:20:21','',''),('5','184',3056975,'','6.1','3483',0.00,961627.95,'Sales from shift 216994 on 2021-08-12 20:20:21 ','2021-08-12 20:20:21','',''),('5','184',3057024,'','20','3479',989753.85,0.00,'Sales from shift 216998 on 2021-08-12 22:43:18 ','2021-08-12 22:43:18','',''),('5','184',3057025,'','6.1','3483',0.00,989753.85,'Sales from shift 216998 on 2021-08-12 22:43:18 ','2021-08-12 22:43:18','',''),('5','184',3060334,'','2','3508',1161755.00,0.00,'Payment Id 312283 for invoice:216887, receipt: 817cnr0008 by SALBAS OIL & GAS LIMITED','2021-08-13 11:06:18','',''),('5','184',3060335,'','supplier','253',0.00,1161755.00,'Payment Id 312283 for invoice:216887, receipt: 817cnr0008 by SALBAS OIL & GAS LIMITED','2021-08-13 11:06:18','',''),('5','184',3060364,'','2','3508',815865.00,0.00,'Payment Id 312296 for invoice:216984, receipt: 823cnr0007 by SALBAS OIL & GAS LIMITED','2021-08-13 11:09:19','',''),('5','184',3060365,'','supplier','253',0.00,815865.00,'Payment Id 312296 for invoice:216984, receipt: 823cnr0007 by SALBAS OIL & GAS LIMITED','2021-08-13 11:09:19','',''),('5','184',3060376,'','2','3456',936455.00,0.00,'Payment Id 312304 for invoice:216992, receipt: 140633 by SALBAS OIL & GAS LIMITED','2021-08-13 11:09:57','',''),('5','184',3060377,'','supplier','253',0.00,936455.00,'Payment Id 312304 for invoice:216992, receipt: 140633 by SALBAS OIL & GAS LIMITED','2021-08-13 11:09:57','',''),('5','184',3060384,'','2','3456',835930.00,0.00,'Payment Id 312314 for invoice:216994, receipt: 141362 by SALBAS OIL & GAS LIMITED','2021-08-13 11:10:21','',''),('5','184',3060385,'','supplier','253',0.00,835930.00,'Payment Id 312314 for invoice:216994, receipt: 141362 by SALBAS OIL & GAS LIMITED','2021-08-13 11:10:21','',''),('5','184',3063715,'','2','3456',884275.00,0.00,'Payment Id 312722 for invoice:216998, receipt: 141937 by SALBAS OIL & GAS LIMITED','2021-08-13 15:30:08','',''),('5','184',3063716,'','supplier','253',0.00,884275.00,'Payment Id 312722 for invoice:216998, receipt: 141937 by SALBAS OIL & GAS LIMITED','2021-08-13 15:30:08','',''),('5','184',3066285,'','20','3479',930378.30,0.00,'Sales from shift 217055 on 2021-08-14 06:44:26 ','2021-08-14 06:44:26','',''),('5','184',3066286,'','6.1','3483',0.00,930378.30,'Sales from shift 217055 on 2021-08-14 06:44:26 ','2021-08-14 06:44:26','',''),('5','184',3075684,'','20','3479',1140292.50,0.00,'Sales from shift 217481 on 2021-08-14 23:01:21 ','2021-08-14 23:01:21','',''),('5','184',3075685,'','6.1','3483',0.00,1140292.50,'Sales from shift 217481 on 2021-08-14 23:01:21 ','2021-08-14 23:01:21','',''),('5','184',3086438,'','20','3479',863574.40,0.00,'Sales from shift 217647 on 2021-08-16 09:54:34 ','2021-08-16 09:54:34','',''),('5','184',3086439,'','6.1','3483',0.00,863574.40,'Sales from shift 217647 on