-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_183
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_183`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_183` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_183`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3515 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3457,30160,'',0,'24','5','183','PUPLIC RELATION','','2021-07-15 06:12:06',5,0.00,0.00,'','576','2021-07-15 06:12:06','576',0,1),(3458,30161,'',0,'24','5','183','PURCHASES','','2021-07-15 06:13:01',5,0.00,0.00,'','576','2021-07-15 06:13:01','576',0,1),(3459,30162,'',0,'24','5','183','SALARIES & WAGES','','2021-07-15 06:15:08',5,0.00,0.00,'','576','2021-07-15 06:15:08','576',0,1),(3460,3023,'',0,'6.1','5','183','CASH','','2021-07-15 06:15:56',5,0.00,0.00,'','576','2021-07-15 06:15:56','576',0,1),(3461,30163,'',0,'24','5','183','DIESEL CONSUMPTION (GEN)','','2021-07-15 06:17:02',5,0.00,0.00,'','576','2021-07-15 06:17:02','576',0,1),(3462,30164,'',0,'24','5','183','TRANSPORT FARE','','2021-07-15 06:17:35',5,0.00,0.00,'','576','2021-07-15 06:17:35','576',0,1),(3463,30165,'',0,'24','5','183','OTHER OPERATING EXPENSES','','2021-07-15 06:18:21',5,0.00,0.00,'','576','2021-07-15 06:18:21','576',0,1),(3464,30166,'',0,'24','5','183','GENERATOR REPAIRS & MAINTENANC','','2021-07-15 06:19:19',5,0.00,0.00,'','576','2021-07-15 06:19:19','576',0,1),(3465,30167,'',0,'24','5','183','PUMP REPAIRS & MAINTENANCE','','2021-07-15 06:20:10',5,0.00,0.00,'','576','2021-07-15 06:20:10','576',0,1),(3466,30168,'',0,'24','5','183','WEITH AND MEASURE','','2021-07-15 06:21:20',5,0.00,0.00,'','576','2021-07-15 06:21:20','576',0,1),(3467,30169,'',0,'24','5','183','TRAVELLING EXPENSES','','2021-07-15 06:22:04',5,0.00,0.00,'','576','2021-07-15 06:22:04','576',0,1),(3468,30170,'',0,'24','5','183','MEDICAL EXPENSES','','2021-07-15 06:23:04',5,0.00,0.00,'','576','2021-07-15 06:23:04','576',0,1),(3469,30171,'',0,'24','5','183','OFFICIAL CAR FUEL & REPAIRS','','2021-07-15 06:23:54',5,0.00,0.00,'','576','2021-07-15 06:23:54','576',0,1),(3470,4021,'',0,'20','5','183','SALES','','2021-07-15 06:24:50',5,0.00,0.00,'','576','2021-07-15 06:24:50','576',0,1),(3471,4008,'',0,'22','5','183','PURCHASES','','2021-07-15 06:38:42',5,0.00,0.00,'','576','2021-07-15 06:38:42','576',0,1),(3472,4038,'',0,'2','5','183','UBA 1019882661','','2021-07-15 06:41:02',5,0.00,0.00,'','576','2021-07-15 06:41:02','576',0,1),(3473,4039,'',0,'2','5','183','ZB:EBILLS-1016650302','','2021-07-15 06:42:08',5,0.00,0.00,'','576','2021-07-15 06:42:08','576',0,1),(3512,4044,'',0,'2','5','183','UBA-1023852438','','2021-07-27 09:05:56',5,0.00,0.00,'','600','2021-07-27 09:05:56','600',0,1),(3513,4045,'',0,'2','5','183','JA\'IZ- 0010037957','','2022-03-01 20:40:58',5,0.00,0.00,'','600','2022-03-01 20:40:58','600',0,0),(3514,2000,'',0,'6','5','183','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:25:05',5,0.00,0.00,'','600','2023-02-06 10:25:05','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','183','0000-00-00','2023-02-07 13:27:28',10,'1013','','0000-00-00 00:00:00','606','2023-02-07 13:56:24'),(2,'5','183','0000-00-00','2023-02-07 13:58:06',10,'1013','','0000-00-00 00:00:00','606','2023-02-09 15:49:20'),(3,'5','183','0000-00-00','2023-02-20 16:47:48',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'5','183','0000-00-00','2023-02-22 11:34:09',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','183','1','3514','6',0.00,'Being PMS Price Increase of #35*1,459.85 ',51094.75,'2023-02-07'),(2,'5','183','1','262','supplier',51094.75,'Being PMS Price Increase of #35*1,459.85 ',0.00,'2023-02-07'),(3,'5','183','2','3514','6',9000.00,'Being AGO Price Decrease of 300 LTRS On 14/01/2023',0.00,'2023-02-07'),(4,'5','183','2','262','supplier',0.00,'Being AGO Price Decrease of 300 LTRS On 14/01/2023',9000.00,'2023-02-07'),(5,'5','183','3','262','supplier',0.00,'Being PMS Price decrease of #10*1459.85LTRS on 19/2/2023',14598.50,'2023-02-20'),(6,'5','183','3','3514','6',14598.50,'Being PMS Price Increase of #10*1,459.85 ',0.00,'2023-02-20'),(8,'5','183','5','262','supplier',0.00,'Being AGO Price Decrease of #10 * 300 LTRS  On 20/02/2023',3000.00,'2023-02-22'),(9,'5','183','5','3514','6',3000.00,'Being AGO Price Decrease of #10 * 300 LTRS  On 20/02/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16888 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','183',16869,'949',27300.00,14300.00,'2021-10-20','','2021-10-20 12:06:40','600','600',2021,'600','2021-10-20 12:06:40',5),('5','183',16870,'950',14900.00,27900.00,'2021-10-20','','2021-10-20 12:06:59','600','600',2021,'600','2021-10-20 12:06:59',5),('5','183',16874,'949',2091.41,7091.00,'2021-10-21','','2021-10-21 09:49:12','600','600',2021,'600','2021-10-21 09:49:12',5),('5','183',16875,'949',24989.66,4252.00,'2022-02-14','','2022-02-14 15:41:34','600','600',2022,'600','2022-02-14 15:41:34',5),('5','183',16876,'950',29985.88,4986.00,'2022-02-14','','2022-02-14 15:41:52','600','600',2022,'600','2022-02-14 15:41:52',5),('5','183',16877,'949',83.77,11000.00,'2022-03-01','','2022-03-01 20:39:16','600','600',2022,'600','2022-03-01 20:39:16',5),('5','183',16878,'949',9850.01,1000.00,'2022-03-15','','2022-03-15 08:47:50','638','638',2022,'638','2022-03-15 08:47:50',5),('5','183',16879,'949',1000.00,1000.00,'2022-03-15','','2022-03-15 08:48:56','638','638',2022,'638','2022-03-15 08:48:56',5),('5','183',16880,'949',1044.57,14950.00,'2022-03-17','','2022-03-17 10:17:35','600','600',2022,'600','2022-03-17 10:17:35',5),('5','183',16881,'949',1969.53,2600.00,'2022-03-31','','2022-03-31 11:08:36','600','600',2022,'600','2022-03-31 11:08:36',5),('5','183',16882,'949',313.57,2000.00,'2022-04-18','','2022-04-18 13:30:37','600','600',2022,'600','2022-04-18 13:30:37',5),('5','183',16883,'950',4529.30,11200.00,'2022-07-29','','2022-07-29 09:20:57','600','600',2022,'600','2022-07-29 09:20:57',5),('5','183',16884,'950',365.57,8500.00,'2022-09-10','','2022-09-10 09:40:03','600','600',2022,'600','2022-09-10 09:40:03',5),('5','183',16885,'950',5358.82,6000.00,'2022-10-10','','2022-10-10 13:14:06','600','600',2022,'600','2022-10-10 13:14:06',5),('5','183',16886,'949',11815.19,600.00,'2022-10-28','','2022-10-28 16:33:35','600','600',2022,'600','2022-10-28 16:33:35',5),('5','183',16887,'949',600.00,600.00,'2022-10-28','','2022-10-28 16:33:35','600','600',2022,'600','2022-10-28 16:33:35',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2837 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','183','949',2829,'5','PMS PUMP 3',1463317.00,'PMS DISPENSER','',NULL,NULL,'',5,'2021-10-18 12:53:12','600'),('5','183','949',2830,'5','PMS PUMP 5',1198838.34,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 10:17:58','600'),('5','183','949',2831,'5','PMS PUMP 6',4410.65,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 10:16:37','600'),('5','183','950',2832,'5','PMS PUMP 1',453632.13,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-23 12:34:11','600'),('5','183','950',2833,'5','PMS PUMP 2',862414.49,'PMS DISPENSER','',NULL,NULL,'',5,'2021-10-18 12:51:47','600'),('5','183','950',2834,'5','PMS PUMP 4',549579.73,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-23 12:36:17','600'),('5','183','951',2835,'5','AGO PUMP',252894.75,'AGO DISPENSER','',NULL,NULL,'',5,'2021-07-15 10:18:53','600'),('5','183','952',2836,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (227,'5','183','2829','950','PMS TANKS CONNECTION ERROR.','2021-07-15 10:13:39',0,'600'),(228,'5','183','2829','949','PMS TANKS CONNECTION ERROR.','2021-07-15 10:15:01',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257929 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','183',232977,'DAILY','2021-10-12','2021-10-12 00:00:00',NULL,'638',954348.48,954348.48,'638','2021-10-21 06:38:31','664','2021-10-21 06:40:42',10,0),('5','183',233176,'DAILY SHITF','2021-10-13','2021-10-13 00:00:00',NULL,'638',1124053.20,1124053.20,'638','2021-10-21 09:16:05','664','2021-10-21 09:17:55',10,0),('5','183',233186,'DAILY SHITF','2021-10-14','2021-10-14 00:00:00',NULL,'638',1054296.00,1054296.00,'638','2021-10-21 09:27:14','664','2021-10-21 09:28:29',10,0),('5','183',233191,'DAILY SHIRT','2021-10-15','2021-10-15 00:00:00',NULL,'638',985606.38,985606.38,'638','2021-10-21 09:58:33','664','2021-10-21 10:00:06',10,0),('5','183',233206,'DAILY SHITF','2021-10-16','2021-10-16 00:00:00',NULL,'638',1026103.14,1026103.14,'638','2021-10-21 10:17:16','664','2021-10-21 10:20:41',10,0),('5','183',233212,'DAILY SHITF','2021-10-17','2021-10-17 00:00:00',NULL,'638',990327.06,990327.06,'638','2021-10-21 10:25:12','664','2021-10-21 10:28:29',10,0),('5','183',233219,'DAILY SHITF','2021-10-18','2021-10-18 00:00:00',NULL,'638',1100992.50,1100992.50,'638','2021-10-21 10:47:01','664','2021-10-21 10:48:00',10,0),('5','183',233222,'DAILY SHITF','2021-10-19','2021-10-19 00:00:00',NULL,'638',1118752.56,1118752.56,'638','2021-10-21 10:52:10','664','2021-10-21 10:55:29',10,0),('5','183',233227,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'638',1120809.96,1120809.96,'638','2021-10-21 11:05:51','664','2021-10-21 11:39:23',10,0),('5','183',233370,'DAILY','2021-10-21','2021-10-21 00:00:00',NULL,'638',1112337.36,1112337.36,'638','2021-10-22 06:19:53','664','2021-10-22 08:49:15',10,0),('5','183',233615,'DAILY','2021-10-22','2021-10-22 00:00:00',NULL,'638',815778.54,815778.54,'638','2021-10-23 06:22:37','664','2021-10-24 06:48:59',10,0),('5','183',234164,'DAILY','2021-10-24','2021-10-24 00:00:00',NULL,'638',869735.88,869735.88,'638','2021-10-25 11:04:42','664','2021-10-25 13:16:10',10,0),('5','183',234307,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'638',1157441.40,1157441.40,'638','2021-10-26 06:04:55','664','2021-10-26 06:12:41',10,0),('5','183',234561,'DAILY','2021-10-26','2021-10-26 00:00:00',NULL,'638',125817.30,125817.30,'638','2021-10-27 06:56:11','664','2021-10-27 07:27:01',10,0),('5','183',234628,'DAILY','2021-10-27','2021-10-27 00:00:00',NULL,'638',0.00,0.00,'638','2021-10-28 06:13:50','664','2021-10-28 07:58:14',10,0),('5','183',234935,'DAILY','2021-10-28','2021-10-28 00:00:00',NULL,'638',0.00,0.00,'638','2021-10-29 04:46:18','664','2021-10-29 21:57:29',10,0),('5','183',235278,'DAILY','2021-10-29','2021-10-29 00:00:00',NULL,'638',0.00,0.00,'638','2021-10-29 22:56:15','664','2021-10-30 16:52:27',10,0),('5','183',235493,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'638',789510.15,789510.15,'638','2021-10-31 05:25:35','664','2021-10-31 08:49:32',10,0),('5','183',235725,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'638',1239965.10,1239965.10,'638','2021-11-01 04:17:34','664','2021-11-01 04:40:52',10,0),('5','183',235935,'DAILY','2021-11-01','2021-11-01 00:00:00',NULL,'638',168943.50,168943.50,'638','2021-11-02 05:09:53','664','2021-11-03 04:59:08',10,0),('5','183',236229,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'638',690619.05,690619.05,'638','2021-11-03 08:21:34','664','2021-11-03 17:53:16',10,0),('5','183',236481,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'638',1270369.65,1270369.65,'638','2021-11-04 05:27:08','664','2021-11-04 06:30:46',10,0),('5','183',236727,'DAILY','2021-11-04','2021-11-04 00:00:00',NULL,'638',1116361.95,1116361.95,'638','2021-11-05 05:26:04','664','2021-11-05 15:13:04',10,0),('5','183',237020,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'638',966207.00,966207.00,'638','2021-11-06 09:37:32','664','2021-11-07 07:10:34',10,0),('5','183',237420,'DAILY','2021-11-06','2021-11-06 00:00:00',NULL,'638',300243.90,300243.90,'638','2021-11-08 07:24:33','664','2021-11-08 21:42:51',10,0),('5','183',237638,'DAILY','2021-11-08','2021-11-08 00:00:00',NULL,'638',0.00,0.00,'638','2021-11-09 07:02:26','664','2021-11-09 10:44:45',10,0),('5','183',237723,'DAILY','2021-11-09','2021-11-09 00:00:00',NULL,'638',0.00,0.00,'638','2021-11-10 05:19:11','664','2021-11-10 06:41:39',10,0),('5','183',237938,'DAILY','2021-11-10','2021-11-10 00:00:00',NULL,'638',1251572.85,1251572.85,'638','2021-11-11 05:24:06','664','2021-11-11 09:43:48',10,0),('5','183',238211,'DAILY','2021-11-11','2021-11-11 00:00:00',NULL,'638',1180017.30,1180017.30,'638','2021-11-12 05:35:54','664','2021-11-12 08:18:58',10,0),('5','183',238428,'DAILY','2021-11-12','2021-11-12 00:00:00',NULL,'638',1654002.90,1654002.90,'638','2021-11-13 05:00:29','664','2021-11-13 05:54:27',10,0),('5','183',238727,'DAILY','2021-11-13','2021-11-13 00:00:00',NULL,'638',1650070.95,1650070.95,'638','2021-11-14 07:26:22','664','2021-11-14 15:24:04',10,0),('5','183',239031,'DAILY','2021-11-14','2021-11-14 00:00:00',NULL,'638',1876328.85,1876328.85,'638','2021-11-15 06:00:13','664','2021-11-15 07:24:33',10,0),('5','183',239144,'DAILY','2021-11-15','2021-11-15 00:00:00',NULL,'638',2810281.65,2810281.65,'638','2021-11-16 06:22:33','664','2021-11-16 08:09:20',10,0),('5','183',239353,'DAILY','2021-11-16','2021-11-16 00:00:00',NULL,'638',1638139.80,1638139.80,'638','2021-11-17 06:02:57','664','2021-11-17 14:43:42',10,0),('5','183',239678,'DAILY','2021-11-17','2021-11-17 00:00:00',NULL,'638',1387407.45,1387407.45,'638','2021-11-18 06:07:11','664','2021-11-18 06:25:13',10,0),('5','183',239922,'DAILY','2021-11-18','2021-11-18 00:00:00',NULL,'638',951711.75,951711.75,'638','2021-11-19 05:51:03','664','2021-11-19 07:54:04',10,0),('5','183',240073,'DAILY','2021-11-19','2021-11-19 00:00:00',NULL,'638',756160.35,756160.35,'638','2021-11-20 06:17:20','664','2021-11-20 06:38:33',10,0),('5','183',240218,'DAILY','2021-11-20','2021-11-20 00:00:00',NULL,'638',824955.45,824955.45,'638','2021-11-21 07:18:00','664','2021-11-21 07:23:04',10,0),('5','183',240675,'DAILY','2021-11-21','2021-11-21 00:00:00',NULL,'638',888026.70,888026.70,'638','2021-11-22 06:04:39','664','2021-11-22 06:20:49',10,0),('5','183',240781,'DAILY','2021-11-22','2021-11-22 00:00:00',NULL,'638',933687.15,933687.15,'638','2021-11-23 05:47:31','664','2021-11-23 06:28:43',10,0),('5','183',241039,'DAILY','2021-11-23','2021-11-23 00:00:00',NULL,'638',1125219.15,1125219.15,'638','2021-11-24 06:11:01','664','2021-11-24 07:03:09',10,0),('5','183',241510,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'638',1038795.45,1038795.45,'638','2021-11-25 06:53:55','664','2021-11-25 08:20:41',10,0),('5','183',241735,'DAILY','2021-11-25','2021-11-25 00:00:00',NULL,'638',1755235.35,1755235.35,'638','2021-11-26 06:14:52','664','2021-11-26 09:46:02',10,0),('5','183',241844,'DAILY','2021-11-26','2021-11-26 00:00:00',NULL,'638',1079834.25,1079834.25,'638','2021-11-27 07:06:44','664','2021-11-27 08:38:55',10,0),('5','183',242124,'DAILY','2021-11-27','2021-11-27 00:00:00',NULL,'638',849037.20,849037.20,'638','2021-11-28 06:37:14','664','2021-11-28 07:31:49',10,0),('5','183',242398,'DAILY','2021-11-28','2021-11-28 00:00:00',NULL,'638',240835.65,240835.65,'638','2021-11-29 06:35:20','664','2021-11-29 06:49:49',10,0),('5','183',242683,'DAILY','2021-11-29','2021-11-29 00:00:00',NULL,'638',0.00,0.00,'638','2021-11-30 06:25:48','664','2021-11-30 06:55:42',10,0),('5','183',242832,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'638',385410.30,385410.30,'638','2021-12-01 06:36:01','664','2021-12-01 20:01:31',10,0),('5','183',243124,'DAILY','2021-12-01','2021-12-01 00:00:00',NULL,'638',928022.70,928022.70,'638','2021-12-02 05:22:01','664','2021-12-02 11:32:23',10,0),('5','183',243239,'DAILY','2021-12-02','2021-12-02 00:00:00',NULL,'638',1410317.70,1410317.70,'638','2021-12-03 06:15:18','664','2021-12-04 17:38:39',10,0),('5','183',243803,'DAILY','2021-12-03','2021-12-03 00:00:00',NULL,'638',987320.40,987320.40,'638','2021-12-06 06:04:30','664','2021-12-06 07:32:23',10,0),('5','183',244159,'DAILY','2021-12-04','2021-12-04 00:00:00',NULL,'638',1587341.25,1587341.25,'638','2021-12-06 11:00:23','664','2021-12-06 16:04:00',10,0),('5','183',244208,'DAILY','2021-12-05','2021-12-05 00:00:00',NULL,'638',1373494.65,1373494.65,'638','2021-12-06 16:08:13','664','2021-12-06 16:31:39',10,0),('5','183',244237,'DAILY','2021-12-06','2021-12-06 00:00:00',NULL,'638',1451316.90,1451316.90,'638','2021-12-07 06:42:54','664','2021-12-07 07:28:15',10,0),('5','183',244370,'DAILY','2021-12-07','2021-12-07 00:00:00',NULL,'638',980123.10,980123.10,'638','2021-12-08 06:33:46','664','2021-12-08 07:07:48',10,0),('5','183',244652,'DAILY','2021-12-08','2021-12-08 00:00:00',NULL,'638',837238.05,837238.05,'638','2021-12-09 09:20:54','664','2021-12-09 18:17:47',10,0),('5','183',245007,'DAILY','2021-12-09','2021-12-09 00:00:00',NULL,'638',1134676.95,1134676.95,'638','2021-12-10 06:58:42','664','2021-12-10 09:23:23',10,0),('5','183',245151,'DAILY','2021-12-10','2021-12-10 00:00:00',NULL,'638',850241.70,850241.70,'638','2021-12-10 22:36:13','664','2021-12-11 20:38:42',10,0),('5','183',245437,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'638',303519.15,303519.15,'638','2021-12-12 06:12:23','664','2021-12-12 08:42:11',10,0),('5','183',245653,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'638',0.00,0.00,'638','2021-12-12 21:39:56','664','2021-12-13 11:12:44',10,0),('5','183',245918,'DAILY','2021-12-13','2021-12-13 00:00:00',NULL,'638',278655.30,278655.30,'638','2021-12-14 05:19:46','664','2021-12-14 08:38:47',10,0),('5','183',246058,'DAILY','2021-12-14','2021-12-14 00:00:00',NULL,'638',909115.35,909115.35,'638','2021-12-15 05:28:17','664','2021-12-15 09:03:50',10,0),('5','183',246364,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'638',882700.50,882700.50,'638','2021-12-16 06:01:43','664','2021-12-16 08:38:21',10,0),('5','183',246586,'DAILY','2021-12-16','2021-12-16 00:00:00',NULL,'638',938572.80,938572.80,'638','2021-12-17 05:44:23','664','2021-12-17 09:12:07',10,0),('5','183',246949,'DAILY','2021-12-17','2021-12-17 00:00:00',NULL,'638',1048220.25,1048220.25,'638','2021-12-18 06:36:44','664','2021-12-18 06:54:15',10,0),('5','183',247067,'DAILY','2021-12-18','2021-12-18 00:00:00',NULL,'638',1093544.10,1093544.10,'638','2021-12-19 15:27:18','664','2021-12-19 17:34:32',10,0),('5','183',247369,'DAILY','2021-12-19','2021-12-19 00:00:00',NULL,'638',1486468.50,1486468.50,'638','2021-12-20 06:18:39','664','2021-12-20 18:05:20',10,0),('5','183',247686,'DAILY','2021-12-20','2021-12-20 00:00:00',NULL,'638',733144.50,733144.50,'638','2021-12-21 06:52:06','664','2021-12-21 14:55:18',10,0),('5','183',247909,'DAILY','2021-12-21','2021-12-21 00:00:00',NULL,'638',728496.45,728496.45,'638','2021-12-22 06:31:52','664','2021-12-22 09:54:57',10,0),('5','183',248159,'DAILY','2021-12-22','2021-12-22 00:00:00',NULL,'638',597852.75,597852.75,'638','2021-12-23 06:09:22','664','2021-12-23 06:28:09',10,0),('5','183',248298,'DAILY','2021-12-23','2021-12-23 00:00:00',NULL,'638',232673.10,232673.10,'638','2021-12-24 06:24:59','664','2021-12-24 14:09:28',10,0),('5','183',248630,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'638',725566.05,725566.05,'638','2021-12-25 18:01:22','664','2021-12-26 07:26:31',10,0),('5','183',248991,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'638',1025319.90,1025319.90,'638','2021-12-26 15:40:34','664','2021-12-27 05:58:56',10,0),('5','183',249120,'DAILY','2021-12-26','2021-12-26 00:00:00',NULL,'638',943215.90,943215.90,'638','2021-12-27 06:32:51','664','2021-12-28 09:22:25',10,0),('5','183',249432,'DAILY','2021-12-27','2021-12-27 00:00:00',NULL,'638',1000589.70,1000589.70,'638','2021-12-28 10:04:52','664','2021-12-29 06:59:19',10,0),('5','183',249666,'DAILY','2021-12-28','2021-12-28 00:00:00',NULL,'638',647578.80,647578.80,'638','2021-12-30 05:49:34','664','2021-12-30 06:46:16',10,0),('5','183',249922,'DAILY','2021-12-29','2021-12-29 00:00:00',NULL,'638',250611.90,250611.90,'638','2021-12-30 08:49:29','664','2021-12-31 09:25:58',10,0),('5','183',250238,'DAILY','2021-12-30','2021-12-30 00:00:00',NULL,'638',406032.00,406032.00,'638','2021-12-31 14:25:37','664','2022-01-01 07:42:42',10,0),('5','183',250495,'DAILY','2021-12-31','2021-12-31 00:00:00',NULL,'638',1187036.40,1187036.40,'638','2022-01-01 16:37:32','664','2022-01-02 08:07:28',10,0),('5','183',250774,'DAILY','2022-01-01','2022-01-01 00:00:00',NULL,'638',1280708.55,1280708.55,'638','2022-01-02 22:08:30','664','2022-01-03 06:58:54',10,0),('5','183',251051,'DAILY','2022-01-02','2022-01-02 00:00:00',NULL,'638',1272095.55,1272095.55,'638','2022-01-04 07:07:00','664','2022-01-04 08:40:52',10,0),('5','183',251122,'DAILY','2022-01-03','2022-01-03 00:00:00',NULL,'638',1596346.95,1596346.95,'638','2022-01-04 13:36:29','664','2022-01-06 09:25:20',10,0),('5','183',251763,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'638',1540039.05,1540039.05,'638','2022-01-11 07:53:48','664','2022-01-11 08:20:10',10,0),('5','183',252813,'Dayly','2022-01-05','2022-01-05 00:00:00',NULL,'638',1371004.80,1371004.80,'638','2022-01-11 12:02:37','664','2022-01-11 12:45:44',10,0),('5','183',252830,'Dayly','2022-01-11','2022-01-11 00:00:00',NULL,'638',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','183',252832,'Dayly','2022-01-06','2022-01-06 00:00:00',NULL,'638',1061654.55,1061654.55,'638','2022-01-11 13:53:22','664','2022-01-11 13:58:09',10,0),('5','183',252840,'Dayly','2022-01-07','2022-01-07 00:00:00',NULL,'638',1064276.40,1064276.40,'638','2022-01-11 14:04:50','664','2022-01-11 14:05:51',10,0),('5','183',252844,'Dayly','2022-01-08','2022-01-08 00:00:00',NULL,'638',974846.40,974846.40,'638','2022-01-11 14:14:10','664','2022-01-11 14:20:11',10,0),('5','183',252853,'Dayly','2022-01-09','2022-01-09 00:00:00',NULL,'638',797680.95,797680.95,'638','2022-01-11 14:33:59','664','2022-01-11 14:34:54',10,0),('5','183',252860,'Dayly','2022-01-10','2022-01-10 00:00:00',NULL,'638',515882.40,515882.40,'638','2022-01-11 14:47:17','664','2022-01-11 14:48:54',10,0),('5','183',252864,'Dayly','2022-01-11','2022-01-11 00:00:00',NULL,'638',169862.55,169862.55,'638','2022-01-12 07:14:52','664','2022-01-12 08:14:10',10,0),('5','183',253017,'Dayly','2022-01-12','2022-01-12 00:00:00',NULL,'638',0.00,0.00,'638','2022-01-13 07:53:00','664','2022-01-13 08:28:13',10,0),('5','183',253412,'Dayly','2022-01-13','2022-01-13 00:00:00',NULL,'638',0.00,0.00,'638','2022-01-14 16:40:42','664','2022-01-14 16:41:53',10,0),('5','183',253638,'Dayly','2022-01-14','2022-01-14 00:00:00',NULL,'638',1114010.70,1114010.70,'638','2022-01-15 07:16:42','664','2022-01-15 09:08:23',10,0),('5','183',253872,'Dayly','2022-01-15','2022-01-15 00:00:00',NULL,'638',1200495.45,1200495.45,'638','2022-01-16 06:41:57','664','2022-01-16 06:54:51',10,0),('5','183',254079,'Dayly','2022-01-16','2022-01-16 00:00:00',NULL,'638',1042461.75,1042461.75,'638','2022-01-17 08:26:44','664','2022-01-17 08:29:13',10,0),('5','183',254244,'Dayly','2022-01-17','2022-01-17 00:00:00',NULL,'638',1281215.10,1281215.10,'638','2022-01-18 05:24:27','664','2022-01-18 07:07:50',10,0),('5','183',254482,'Dayly','2022-01-18','2022-01-18 00:00:00',NULL,'638',840480.30,840480.30,'638','2022-01-19 07:29:10','664','2022-01-19 08:50:47',10,0),('5','183',254933,'Dayly','2022-01-19','2022-01-19 00:00:00',NULL,'638',428780.55,428780.55,'638','2022-01-20 06:28:12','664','2022-01-20 06:35:02',10,0),('5','183',255018,'Dayly','2022-01-20','2022-01-20 00:00:00',NULL,'638',446419.05,446419.05,'638','2022-01-21 07:32:03','664','2022-01-21 11:16:36',10,0),('5','183',255340,'Dayly','2022-01-21','2022-01-21 00:00:00',NULL,'638',190210.35,190210.35,'638','2022-01-22 06:46:23','664','2022-01-22 09:18:13',10,0),('5','183',255748,'Dayly','2022-01-22','2022-01-22 00:00:00',NULL,'638',0.00,0.00,'638','2022-01-23 09:00:48','664','2022-01-23 09:17:12',10,0),('5','183',255888,'Dayly','2022-01-23','2022-01-23 00:00:00',NULL,'638',1010248.80,1010248.80,'638','2022-01-24 08:15:03','664','2022-01-24 08:22:09',10,0),('5','183',256143,'Dayly','2022-01-24','2022-01-24 00:00:00',NULL,'638',1272635.10,1272635.10,'638','2022-01-25 06:30:55','664','2022-01-25 08:24:15',10,0),('5','183',256359,'Dayly','2022-01-25','2022-01-25 00:00:00',NULL,'638',1119290.70,1119290.70,'638','2022-01-26 06:54:05','664','2022-01-26 10:07:29',10,0),('5','183',256559,'Dayly','2022-01-26','2022-01-26 00:00:00',NULL,'638',1181581.50,1181581.50,'638','2022-01-27 06:56:17','664','2022-01-27 07:07:53',10,0),('5','183',256801,'Dayly','2022-01-27','2022-01-27 00:00:00',NULL,'638',915989.25,915989.25,'638','2022-01-28 06:25:05','664','2022-01-28 06:37:32',10,0),('5','183',257012,'Dayly','2022-01-28','2022-01-28 00:00:00',NULL,'638',551302.95,551302.95,'638','2022-01-29 06:31:47','664','2022-01-29 07:13:39',10,0),('5','183',257524,'Dayly','2022-01-29','2022-01-29 00:00:00',NULL,'638',525171.90,525171.90,'638','2022-01-31 11:23:59','664','2022-01-31 11:25:35',10,0),('5','183',257525,'Dayly','2022-01-30','2022-01-30 00:00:00',NULL,'638',0.00,0.00,'638','2022-01-31 11:36:05','664','2022-02-02 19:22:12',10,0),('5','183',257526,'Dayly','2022-02-01','2022-02-01 00:00:00',NULL,'638',384715.65,384715.65,'638','2022-02-02 19:48:20','664','2022-02-02 19:54:57',10,0),('5','183',257527,'Dayly','2022-02-02','2022-02-02 00:00:00',NULL,'638',1485066.00,1485066.00,'638','2022-02-03 07:18:31','664','2022-02-03 07:55:36',10,0),('5','183',257528,'Dayly','2022-02-03','2022-02-03 00:00:00',NULL,'638',1186519.95,1186519.95,'638','2022-02-04 07:18:36','664','2022-02-04 07:29:42',10,0),('5','183',257529,'Dayly','2022-02-04','2022-02-04 00:00:00',NULL,'638',1078974.60,1078974.60,'638','2022-02-05 07:14:20','664','2022-02-05 07:36:37',10,0),('5','183',257530,'Dayly','2022-02-05','2022-02-05 00:00:00',NULL,'638',784654.20,784654.20,'638','2022-02-06 08:08:29','664','2022-02-06 09:32:00',10,0),('5','183',257531,'Dayly','2022-02-06','2022-02-06 00:00:00',NULL,'638',711229.20,711229.20,'638','2022-02-07 09:07:31','664','2022-02-07 09:50:17',10,0),('5','183',257532,'Dayly','2022-02-07','2022-02-07 00:00:00',NULL,'638',544143.60,544143.60,'638','2022-02-08 06:22:15','664','2022-02-08 07:16:56',10,0),('5','183',257533,'Dayly','2022-02-08','2022-02-08 00:00:00',NULL,'638',370591.65,370591.65,'638','2022-02-09 06:56:08','664','2022-02-09 07:21:37',10,0),('5','183',257534,'Full time shift','2022-02-09','2022-02-09 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-10 14:48:03','664','2022-02-10 14:55:18',10,0),('5','183',257535,'DAILY SHIRT','2022-02-11','2022-02-11 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-11 10:23:23','664','2022-02-11 20:20:10',10,0),('5','183',257536,'DAILY SHITF','2022-02-12','2022-02-12 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-12 19:24:49','664','2022-02-13 08:47:10',10,0),('5','183',257537,'DAILY SHIRT','2022-02-13','2022-02-13 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-13 19:42:13','664','2022-02-14 06:08:52',10,0),('5','183',257538,'DAILY SHIRT','2022-02-14','2022-02-14 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-14 21:21:08','664','2022-02-14 23:47:15',10,0),('5','183',257539,'DAILY SHITF','2022-02-15','2022-02-15 00:00:00',NULL,'638',0.00,0.00,'638','2022-02-15 20:35:13','664','2022-02-16 06:09:20',10,0),('5','183',257540,'DAILY SHITF','2022-02-16','2022-02-16 00:00:00',NULL,'638',274909.80,274909.80,'638','2022-02-17 10:19:08','664','2022-02-17 21:04:58',10,0),('5','183',257541,'DAILY SHITF','2022-02-17','2022-02-17 00:00:00',NULL,'638',1297157.40,1297157.40,'638','2022-02-18 14:52:02','664','2022-02-19 07:18:13',10,0),('5','183',257542,'DAILY SHITF','2022-02-18','2022-02-18 00:00:00',NULL,'638',1248320.70,1248320.70,'638','2022-02-19 09:52:14','664','2022-02-19 21:53:09',10,0),('5','183',257543,'DAILY SHITF','2022-02-19','2022-02-19 00:00:00',NULL,'638',932720.25,932720.25,'638','2022-02-20 12:22:41','664','2022-02-20 12:24:18',10,0),('5','183',257544,'Daily','2022-02-20','2022-02-20 00:00:00',NULL,'638',1176761.85,1176761.85,'638','2022-02-21 07:31:58','664','2022-02-21 08:41:59',10,0),('5','183',257545,'Daily','2022-02-21','2022-02-21 00:00:00',NULL,'638',981525.60,981525.60,'638','2022-02-22 07:14:08','664','2022-02-22 07:47:17',10,0),('5','183',257546,'Daily','2022-02-22','2022-02-23 06:30:15','2022-02-24 06:30:15','638',944281.80,944281.80,'638','2022-02-23 06:33:18','664','2022-02-23 07:11:24',10,0),('5','183',257547,'Daily','2022-02-23','2022-02-24 07:14:02','2022-02-25 07:14:02','638',472701.90,472701.90,'638','2022-02-24 07:17:55','664','2022-02-24 07:57:41',10,0),('5','183',257548,'Daily','2022-02-24','2022-02-26 07:47:40','2022-02-27 07:47:40','638',1416221.40,1416221.40,'638','2022-02-27 06:23:17','664','2022-02-27 09:11:22',10,0),('5','183',257549,'Daily','2022-02-25','2022-02-27 15:41:33','2022-02-28 15:41:33','638',1458253.50,1458253.50,'638','2022-02-27 15:50:57','664','2022-02-27 15:52:04',10,0),('5','183',257550,'Daily','2022-02-26','2022-02-27 16:39:22','2022-02-28 16:39:22','638',1236361.50,1236361.50,'638','2022-02-27 16:40:47','664','2022-02-27 16:41:57',10,0),('5','183',257551,'Daily','2022-02-27','2022-02-28 07:05:09','2022-03-01 07:05:09','638',1153213.05,1153213.05,'638','2022-02-28 07:06:58','664','2022-02-28 08:12:53',10,0),('5','183',257552,'Daily','2022-02-28','2022-02-28 13:48:01','2022-03-01 13:48:01','638',1776325.65,1776325.65,'638','2022-03-02 07:00:57','664','2022-03-02 09:40:20',10,0),('5','183',257553,'Daily','2022-03-01','2022-03-02 09:49:11','2022-03-03 09:49:11','638',1027999.50,1027999.50,'638','2022-03-02 09:53:55','664','2022-03-02 10:01:26',10,0),('5','183',257554,'Daily','2022-03-02','2022-03-02 10:03:49','2022-03-03 10:03:49','638',575977.05,575977.05,'638','2022-03-03 06:47:01','664','2022-03-03 08:07:32',10,0),('5','183',257555,'Daily','2022-03-03','2022-03-04 09:43:06','2022-03-05 09:43:06','638',460315.35,460315.35,'638','2022-03-04 09:45:59','664','2022-03-04 10:02:45',10,0),('5','183',257556,'Daily','2022-03-04','2022-03-05 14:20:42','2022-03-06 14:20:42','638',1428796.05,1428796.05,'638','2022-03-05 16:30:12','664','2022-03-05 19:31:14',10,0),('5','183',257557,'Daily','2022-03-05','2022-03-06 06:57:04','2022-03-07 06:57:04','638',1978321.95,1978321.95,'638','2022-03-06 06:58:19','664','2022-03-06 08:54:32',10,0),('5','183',257558,'Daily','2022-03-06','2022-03-06 12:12:16','2022-03-07 12:12:16','638',1132680.45,1132680.45,'638','2022-03-07 08:48:02','664','2022-03-07 20:08:44',10,0),('5','183',257559,'Daily','2022-03-07','2022-03-08 12:11:19','2022-03-09 12:11:19','638',1391309.70,1391309.70,'638','2022-03-08 12:12:17','664','2022-03-08 12:19:41',10,0),('5','183',257560,'Daily','2022-03-08','2022-03-08 12:37:09','2022-03-09 12:37:09','638',894537.60,894537.60,'638','2022-03-09 07:31:13','664','2022-03-09 07:50:57',10,0),('5','183',257561,'Daily','2022-03-09','2022-03-10 06:59:28','2022-03-11 06:59:28','638',990379.50,990379.50,'638','2022-03-10 07:01:04','664','2022-03-10 07:39:25',10,0),('5','183',257562,'Daily','2022-03-10','2022-03-11 07:56:55','2022-03-12 07:56:55','638',1200241.35,1200241.35,'638','2022-03-11 07:58:58','664','2022-03-11 08:54:30',10,0),('5','183',257563,'Daily','2022-03-11','2022-03-12 07:26:16','2022-03-13 07:26:16','638',0.00,0.00,'638','2022-03-12 13:38:20','664','2022-03-13 12:14:06',10,0),('5','183',257564,'Daily','2022-03-12','2022-03-13 16:41:44','2022-03-14 16:41:44','638',1726342.20,1726342.20,'638','2022-03-13 16:43:33','664','2022-03-14 06:04:56',10,0),('5','183',257565,'Daily ','2022-03-13','2022-03-14 07:16:46','2022-03-15 07:16:46','638',1217313.90,1217313.90,'638','2022-03-14 07:21:10','664','2022-03-15 05:58:31',10,0),('5','183',257566,'Daily','2022-03-14','2022-03-15 06:49:15','2022-03-16 06:49:15','638',1757467.80,1757467.80,'638','2022-03-15 11:49:01','664','2022-03-15 12:01:13',10,0),('5','183',257567,'Daily','2022-03-15','2022-03-15 17:04:34','2022-03-16 17:04:34','638',1510428.15,1510428.15,'638','2022-03-16 06:34:30','664','2022-03-16 08:12:44',10,0),('5','183',257568,'Daily','2022-03-16','2022-03-16 09:26:07','2022-03-17 09:26:07','638',1622984.55,1622984.55,'638','2022-03-17 10:47:04','664','2022-03-18 07:36:54',10,0),('5','183',257569,'Daily','2022-03-17','2022-03-18 11:11:08','2022-03-19 11:11:08','638',1808375.25,1808375.25,'638','2022-03-18 11:15:55','664','2022-03-19 07:06:00',10,0),('5','183',257570,'Daily','2022-03-18','2022-03-19 07:30:14','2022-03-20 07:30:14','638',773628.90,773628.90,'638','2022-03-19 07:33:08','664','2022-03-19 08:23:16',10,0),('5','183',257571,'Daily','2022-03-19','2022-03-20 06:34:03','2022-03-21 06:34:03','638',1032916.50,1032916.50,'638','2022-03-20 06:36:01','664','2022-03-20 08:37:41',10,0),('5','183',257572,'Daily','2022-03-20','2022-03-21 07:50:25','2022-03-22 07:50:25','638',1015007.40,1015007.40,'638','2022-03-21 07:55:26','664','2022-03-21 08:41:03',10,0),('5','183',257573,'Daily','2022-03-21','2022-03-22 08:09:28','2022-03-23 08:09:28','638',427605.75,427605.75,'638','2022-03-22 08:11:55','664','2022-03-22 08:25:52',10,0),('5','183',257574,'Daily','2022-03-22','2022-03-23 07:07:58','2022-03-24 07:07:58','638',341421.30,341421.30,'638','2022-03-23 07:09:38','664','2022-03-23 07:53:19',10,0),('5','183',257575,'Daily','2022-03-23','2022-03-24 07:12:10','2022-03-25 07:12:10','638',215290.35,215290.35,'638','2022-03-24 07:16:15','664','2022-03-24 07:58:32',10,0),('5','183',257576,'Daily','2022-03-24','2022-03-25 07:44:04','2022-03-26 07:44:04','638',1256443.65,1256443.65,'638','2022-03-25 09:44:56','664','2022-03-25 09:47:58',10,0),('5','183',257577,'Daily','2022-03-25','2022-03-25 10:01:57','2022-03-26 10:01:57','638',1122211.20,1122211.20,'638','2022-03-26 07:18:01','664','2022-03-27 07:54:49',10,0),('5','183',257578,'Daily','2022-03-26','2022-03-28 06:46:05','2022-03-29 06:46:05','638',844484.85,844484.85,'638','2022-03-28 07:19:26','664','2022-03-28 07:56:22',10,0),('5','183',257579,'Daily','2022-03-27','2022-03-28 10:30:36','2022-03-29 10:30:36','638',1083111.15,1083111.15,'638','2022-03-28 10:35:28','664','2022-03-29 07:52:01',10,0),('5','183',257580,'Daily','2022-03-28','2022-03-29 09:03:51','2022-03-30 09:03:51','638',1081274.70,1081274.70,'638','2022-03-29 09:09:03','664','2022-03-30 06:36:06',10,0),('5','183',257581,'Daily','2022-03-29','2022-03-30 06:57:35','2022-03-31 06:57:35','638',1074739.05,1074739.05,'638','2022-03-30 07:04:06','664','2022-03-30 10:56:30',10,0),('5','183',257582,'Daily','2022-03-30','2022-03-31 07:07:11','2022-04-01 07:07:11','638',414239.38,414239.38,'638','2022-03-31 11:21:47','664','2022-03-31 11:27:19',10,0),('5','183',257583,'Daily','2022-03-31','2022-03-31 11:31:38','2022-04-01 11:31:38','638',249999.75,249999.75,'638','2022-04-01 06:28:23','664','2022-04-01 10:03:12',10,0),('5','183',257584,'Daily','2022-04-01','2022-04-01 17:30:31','2022-04-02 17:30:31','638',0.00,0.00,'638','2022-04-02 07:26:02','664','2022-04-02 08:35:08',10,0),('5','183',257585,'Daily','2022-04-02','2022-04-03 08:36:20','2022-04-04 08:36:20','638',185380.80,185380.80,'638','2022-04-03 18:06:03','664','2022-04-04 07:44:20',10,0),('5','183',257586,'Daily','2022-04-03','2022-04-04 08:05:15','2022-04-05 08:05:15','638',1328286.30,1328286.30,'638','2022-04-04 08:07:41','664','2022-04-04 11:30:21',10,0),('5','183',257587,'Daily','2022-04-04','2022-04-04 11:41:01','2022-04-05 11:41:01','638',1124090.55,1124090.55,'638','2022-04-05 06:44:48','664','2022-04-05 09:03:04',10,0),('5','183',257588,'Fairly','2022-04-05','2022-04-05 16:25:01','2022-04-06 16:25:01','638',1022732.70,1022732.70,'638','2022-04-06 00:10:58','664','2022-04-06 08:19:45',10,0),('5','183',257589,'Daily','2022-04-06','2022-04-07 06:48:51','2022-04-08 06:48:51','638',958494.90,958494.90,'638','2022-04-07 06:53:06','664','2022-04-07 07:47:50',10,0),('5','183',257590,'Daily','2022-04-07','2022-04-07 18:06:38','2022-04-08 18:06:38','638',1381906.35,1381906.35,'638','2022-04-08 06:52:43','664','2022-04-08 07:51:25',10,0),('5','183',257591,'Daily','2022-04-08','2022-04-08 09:24:28','2022-04-09 09:24:28','638',1129113.15,1129113.15,'638','2022-04-09 07:21:29','664','2022-04-09 09:33:49',10,0),('5','183',257592,'Daily','2022-04-09','2022-04-09 18:25:52','2022-04-10 18:25:52','638',1314612.75,1314612.75,'638','2022-04-10 07:01:20','664','2022-04-10 08:08:39',10,0),('5','183',257593,'Daily','2022-04-10','2022-04-10 17:55:43','2022-04-11 17:55:43','638',1569389.25,1569389.25,'638','2022-04-10 23:45:10','664','2022-04-11 03:57:27',10,0),('5','183',257594,'Daily','2022-04-11','2022-04-11 15:06:27','2022-04-12 15:06:27','638',1479960.90,1479960.90,'638','2022-04-12 06:26:53','664','2022-04-12 12:46:05',10,0),('5','183',257595,'Daily','2022-04-12','2022-04-13 06:26:58','2022-04-14 06:26:58','638',1718831.40,1718831.40,'638','2022-04-13 06:34:16','664','2022-04-13 07:52:04',10,0),('5','183',257596,'Daily','2022-04-13','2022-04-13 10:54:54','2022-04-14 10:54:54','638',1482935.85,1482935.85,'638','2022-04-14 06:35:45','664','2022-04-14 08:42:18',10,0),('5','183',257597,'Daily','2022-04-14','2022-04-14 09:34:50','2022-04-15 09:34:50','638',1481388.15,1481388.15,'638','2022-04-15 06:53:08','664','2022-04-15 09:01:37',10,0),('5','183',257598,'Daily','2022-04-15','2022-04-15 13:12:01','2022-04-16 13:12:01','638',942323.25,942323.25,'638','2022-04-16 06:51:31','664','2022-04-16 09:21:54',10,0),('5','183',257599,'Daily','2022-04-16','2022-04-16 16:36:55','2022-04-17 16:36:55','638',760036.20,760036.20,'638','2022-04-17 06:42:48','664','2022-04-17 09:54:00',10,0),('5','183',257600,'Daily','2022-04-17','2022-04-18 06:07:11','2022-04-19 06:07:11','638',1086998.55,1086998.55,'638','2022-04-18 13:40:39','664','2022-04-18 13:53:58',10,0),('5','183',257601,'Daily','2022-04-18','2022-04-18 15:23:41','2022-04-19 15:23:41','638',1009818.15,1009818.15,'638','2022-04-19 06:18:49','664','2022-04-19 07:27:04',10,0),('5','183',257602,'Daily','2022-04-19','2022-04-19 10:21:05','2022-04-20 10:21:05','638',1036993.65,1036993.65,'638','2022-04-20 06:24:20','664','2022-04-20 07:58:55',10,0),('5','183',257603,'Daily','2022-04-20','2022-04-20 09:50:25','2022-04-21 09:50:25','638',896136.45,896136.45,'638','2022-04-21 06:25:16','664','2022-04-21 07:41:11',10,0),('5','183',257604,'Daily','2022-04-21','2022-04-21 07:43:47','2022-04-22 07:43:47','638',775534.65,775534.65,'638','2022-04-22 06:16:34','664','2022-04-22 08:08:11',10,0),('5','183',257605,'Daily','2022-04-22','2022-04-22 08:10:30','2022-04-23 08:10:30','638',363569.25,363569.25,'638','2022-04-23 06:22:02','664','2022-04-23 08:32:16',10,0),('5','183',257606,'Daily','2022-04-23','2022-04-23 17:07:48','2022-04-24 17:07:48','638',883909.95,883909.95,'638','2022-04-24 00:21:41','664','2022-04-24 03:07:50',10,0),('5','183',257607,'Daily','2022-04-24','2022-04-24 09:45:16','2022-04-25 09:45:16','638',733301.25,733301.25,'638','2022-04-25 05:45:47','664','2022-04-25 08:44:04',10,0),('5','183',257608,'Daily','2022-04-25','2022-04-25 09:00:44','2022-04-26 09:00:44','638',875859.60,875859.60,'638','2022-04-26 06:17:29','664','2022-04-26 08:30:53',10,0),('5','183',257609,'Daily','2022-04-26','2022-04-26 09:38:19','2022-04-27 09:38:19','638',251268.60,251268.60,'638','2022-04-27 07:38:48','664','2022-04-27 08:09:37',10,0),('5','183',257610,'Daily','2022-04-27','2022-04-27 10:40:04','2022-04-28 10:40:04','638',0.00,0.00,'638','2022-04-28 06:19:53','664','2022-04-28 08:11:16',10,0),('5','183',257611,'Daily','2022-04-28','2022-04-28 09:41:14','2022-04-29 09:41:14','638',0.00,0.00,'638','2022-04-29 06:32:26','664','2022-04-29 08:19:02',10,0),('5','183',257612,'Daily','2022-04-29','2022-04-29 08:22:06','2022-04-30 08:22:06','638',1011032.55,1011032.55,'638','2022-04-30 00:21:13','664','2022-05-09 15:26:58',10,0),('5','183',257613,'Daily','2022-04-30','2022-05-09 15:35:33','2022-05-10 15:35:33','638',1044410.40,1044410.40,'638','2022-05-09 15:45:48','664','2022-05-09 15:59:08',10,0),('5','183',257614,'Daily','2022-05-01','2022-05-09 19:23:17','2022-05-10 19:23:17','638',1295989.20,1295989.20,'638','2022-05-09 19:32:43','664','2022-05-09 19:34:33',10,0),('5','183',257615,'Daily','2022-05-02','2022-05-09 19:38:39','2022-05-10 19:38:39','638',746318.10,746318.10,'638','2022-05-09 19:45:24','664','2022-05-09 19:46:27',10,0),('5','183',257616,'Daily','2022-05-03','2022-05-09 19:48:50','2022-05-10 19:48:50','638',1433336.85,1433336.85,'638','2022-05-09 19:51:11','664','2022-05-09 19:55:49',10,0),('5','183',257617,'Daily','2022-05-04','2022-05-09 21:16:38','2022-05-10 21:16:38','638',684487.65,684487.65,'638','2022-05-09 21:30:14','664','2022-05-09 21:36:16',10,0),('5','183',257618,'Daily','2022-05-05','2022-05-09 21:39:17','2022-05-10 21:39:17','638',1065530.40,1065530.40,'638','2022-05-09 21:41:44','664','2022-05-09 21:42:26',10,0),('5','183',257619,'Daily','2022-05-06','2022-05-09 21:45:24','2022-05-10 21:45:24','638',770492.25,770492.25,'638','2022-05-09 21:47:24','664','2022-05-09 21:48:12',10,0),('5','183',257620,'Daily','2022-05-07','2022-05-09 21:53:34','2022-05-10 21:53:34','638',659793.75,659793.75,'638','2022-05-09 21:55:03','664','2022-05-09 21:56:05',10,0),('5','183',257621,'Daily','2022-05-08','2022-05-09 22:04:23','2022-05-10 22:04:23','638',298364.55,298364.55,'638','2022-05-09 22:06:14','664','2022-05-09 22:07:06',10,0),('5','183',257622,'Daily','2022-05-09','2022-05-09 22:13:20','2022-05-10 22:13:20','638',165848.10,165848.10,'638','2022-05-10 04:41:47','664','2022-05-10 06:48:22',10,0),('5','183',257623,'Daily','2022-05-10','2022-05-10 07:00:13','2022-05-11 07:00:13','638',0.00,0.00,'638','2022-05-10 23:26:52','664','2022-05-11 05:41:33',10,0),('5','183',257624,'Daily','2022-05-11','2022-05-11 19:27:15','2022-05-12 19:27:15','638',0.00,0.00,'638','2022-05-12 05:43:24','664','2022-05-12 07:35:52',10,0),('5','183',257625,'Daily','2022-05-12','2022-05-12 09:30:38','2022-05-13 09:30:38','638',738675.30,738675.30,'638','2022-05-13 08:13:42','664','2022-05-13 08:15:52',10,0),('5','183',257626,'Daily','2022-05-13','2022-05-13 08:41:17','2022-05-14 08:41:17','638',607584.45,607584.45,'638','2022-05-14 06:40:49','664','2022-05-14 06:47:06',10,0),('5','183',257627,'Daily','2022-05-14','2022-05-14 06:53:44','2022-05-15 06:53:44','638',763430.25,763430.25,'638','2022-05-14 23:11:44','664','2022-05-15 06:08:20',10,0),('5','183',257628,'Daily','2022-05-15','2022-05-15 07:42:34','2022-05-16 07:42:34','638',883644.30,883644.30,'638','2022-05-16 06:06:20','664','2022-05-16 06:10:19',10,0),('5','183',257629,'Daily','2022-05-16','2022-05-16 06:11:53','2022-05-17 06:11:53','638',966596.40,966596.40,'638','2022-05-16 23:56:14','600','2022-05-17 06:04:36',10,0),('5','183',257630,'Daily','2022-05-17','2022-05-17 08:34:55','2022-05-18 08:34:55','638',986610.90,986610.90,'638','2022-05-17 23:38:13','600','2022-05-18 05:19:41',10,0),('5','183',257631,'Daily','2022-05-18','2022-05-18 11:42:42','2022-05-19 11:42:42','638',932533.80,932533.80,'638','2022-05-18 23:50:29','600','2022-05-19 05:34:37',10,0),('5','183',257632,'Daily','2022-05-19','2022-05-19 06:35:16','2022-05-20 06:35:16','638',987665.25,987665.25,'638','2022-05-20 06:42:53','600','2022-05-20 07:15:15',10,0),('5','183',257633,'Daily','2022-05-20','2022-05-20 11:02:41','2022-05-21 11:02:41','638',826324.95,826324.95,'638','2022-05-21 07:43:05','600','2022-05-21 07:59:07',10,0),('5','183',257634,'Daily','2022-05-21','2022-05-21 08:19:46','2022-05-22 08:19:46','638',941343.15,941343.15,'638','2022-05-22 04:08:50','600','2022-05-22 08:09:31',10,0),('5','183',257635,'Daily','2022-05-22','2022-05-22 13:10:48','2022-05-23 13:10:48','638',1033751.40,1033751.40,'638','2022-05-23 05:12:05','664','2022-05-23 05:15:22',10,0),('5','183',257636,'Daily','2022-05-23','2022-05-23 12:48:54','2022-05-24 12:48:54','638',959757.15,959757.15,'638','2022-05-24 05:42:01','600','2022-05-24 07:59:02',10,0),('5','183',257637,'Daily','2022-05-24','2022-05-24 09:41:48','2022-05-25 09:41:48','638',1005473.70,1005473.70,'638','2022-05-25 00:08:39','600','2022-05-25 06:07:24',10,0),('5','183',257638,'Daily','2022-05-25','2022-05-25 09:45:50','2022-05-26 09:45:50','638',1020221.40,1020221.40,'638','2022-05-26 06:03:44','600','2022-05-26 07:42:16',10,0),('5','183',257639,'Daily','2022-05-26','2022-05-26 08:05:45','2022-05-27 08:05:45','638',901310.85,901310.85,'638','2022-05-27 06:27:58','664','2022-05-28 04:56:54',10,0),('5','183',257640,'Daily','2022-05-27','2022-05-28 06:21:42','2022-05-29 06:21:42','638',945700.80,945700.80,'638','2022-05-28 06:23:38','600','2022-05-29 08:14:08',10,0),('5','183',257641,'Daily','2022-05-28','2022-05-29 09:50:36','2022-05-30 09:50:36','638',829648.05,829648.05,'638','2022-05-29 21:34:55','600','2022-05-29 21:36:15',10,0),('5','183',257642,'Daily','2022-05-29','2022-05-29 21:40:02','2022-05-30 21:40:02','638',727963.50,727963.50,'638','2022-05-30 05:44:10','600','2022-05-30 05:58:31',10,0),('5','183',257643,'Daily','2022-05-30','2022-05-30 08:26:39','2022-05-31 08:26:39','638',934819.05,934819.05,'638','2022-05-30 23:16:40','664','2022-05-31 00:18:53',10,0),('5','183',257644,'Daily','2022-05-31','2022-05-31 17:21:38','2022-06-01 17:21:38','638',1004833.50,1004833.50,'638','2022-06-01 06:09:47','664','2022-06-01 07:02:25',10,0),('5','183',257645,'Daily','2022-06-01','2022-06-01 07:33:38','2022-06-02 07:33:38','638',925676.40,925676.40,'638','2022-06-02 05:45:21','664','2022-06-02 05:59:52',10,0),('5','183',257646,'Daily','2022-06-02','2022-06-02 06:35:03','2022-06-03 06:35:03','638',720289.35,720289.35,'638','2022-06-03 05:40:48','664','2022-06-03 06:43:00',10,0),('5','183',257647,'Daily','2022-06-03','2022-06-03 08:00:21','2022-06-04 08:00:21','638',643090.80,643090.80,'638','2022-06-04 05:41:47','664','2022-06-04 06:04:02',10,0),('5','183',257648,'Daily','2022-06-04','2022-06-05 06:49:36','2022-06-06 06:49:36','638',511726.05,511726.05,'638','2022-06-05 06:51:36','664','2022-06-05 08:12:01',10,0),('5','183',257649,'Daily','2022-06-05','2022-06-05 08:37:16','2022-06-06 08:37:16','638',931692.30,931692.30,'638','2022-06-05 23:27:39','664','2022-06-06 06:24:49',10,0),('5','183',257650,'Daily','2022-06-06','2022-06-06 10:28:34','2022-06-07 10:28:34','638',867834.00,867834.00,'638','2022-06-07 00:07:13','664','2022-06-07 07:24:14',10,0),('5','183',257651,'Daily','2022-06-07','2022-06-07 08:52:41','2022-06-08 08:52:41','638',576551.25,576551.25,'638','2022-06-08 09:45:01','664','2022-06-08 10:30:08',10,0),('5','183',257652,'DAILY SHIRT ','2022-06-08','2022-06-08 16:45:35','2022-06-09 16:45:35','638',589447.65,589447.65,'638','2022-06-09 07:04:31','664','2022-06-09 08:46:10',10,0),('5','183',257653,'DAILY SHIRT ','2022-06-09','2022-06-10 07:50:40','2022-06-11 07:50:40','638',0.00,0.00,'638','2022-06-10 07:51:01','664','2022-06-10 08:22:48',10,0),('5','183',257654,'DAILY SHIRT ','2022-06-10','2022-06-11 09:18:57','2022-06-12 09:18:57','638',0.00,0.00,'638','2022-06-11 09:19:19','664','2022-06-11 10:14:22',10,0),('5','183',257655,'DAILY SHIRT ','2022-06-11','2022-06-11 21:45:28','2022-06-12 21:45:28','638',0.00,0.00,'638','2022-06-11 21:45:44','664','2022-06-12 08:28:45',10,0),('5','183',257656,'DAILY SHIRT','2022-06-12','2022-06-12 21:05:17','2022-06-13 21:05:17','638',0.00,0.00,'638','2022-06-12 21:05:35','664','2022-06-13 06:52:48',10,0),('5','183',257657,'DAILY SHIRT ','2022-06-13','2022-06-13 09:43:38','2022-06-14 09:43:38','638',0.00,0.00,'638','2022-06-14 10:19:44','664','2022-06-14 10:21:12',10,0),('5','183',257658,'Daily shift','2022-06-14','2022-06-14 10:54:52','2022-06-15 10:54:52','638',0.00,0.00,'638','2022-06-14 22:14:39','664','2022-06-14 22:15:16',10,0),('5','183',257659,'Dayly','2022-06-15','2022-06-15 11:18:34','2022-06-16 11:18:34','638',0.00,0.00,'638','2022-06-15 19:18:29','664','2022-06-16 06:59:54',10,0),('5','183',257660,'Dayly','2022-06-16','2022-06-16 09:23:19','2022-06-17 09:23:19','638',0.00,0.00,'638','2022-06-16 22:41:24','664','2022-06-17 05:57:59',10,0),('5','183',257661,'Dayly','2022-06-17','2022-06-17 06:35:52','2022-06-18 06:35:52','638',0.00,0.00,'638','2022-06-17 23:08:13','664','2022-06-18 07:00:58',10,0),('5','183',257662,'Dayly','2022-06-18','2022-06-18 18:10:47','2022-06-19 18:10:47','638',0.00,0.00,'638','2022-06-18 21:29:22','664','2022-06-18 22:45:38',10,0),('5','183',257663,'Dayly','2022-06-19','2022-06-19 14:41:58','2022-06-20 14:41:58','638',976390.80,976390.80,'638','2022-06-19 23:23:01','664','2022-06-20 06:44:53',10,0),('5','183',257664,'Dayly','2022-06-20','2022-06-20 06:48:14','2022-06-21 06:48:14','638',846905.40,846905.40,'638','2022-06-21 06:31:17','664','2022-06-21 07:52:54',10,0),('5','183',257665,'Daily','2022-06-21','2022-06-21 09:03:58','2022-06-22 09:03:58','638',668914.95,668914.95,'638','2022-06-22 06:09:06','664','2022-06-22 07:03:29',10,0),('5','183',257666,'Daily','2022-06-22','2022-06-22 09:46:18','2022-06-23 09:46:18','638',564742.20,564742.20,'638','2022-06-23 05:59:45','664','2022-06-23 07:03:59',10,0),('5','183',257667,'Daily','2022-06-23','2022-06-23 08:14:53','2022-06-24 08:14:53','638',839011.80,839011.80,'638','2022-06-24 06:18:58','664','2022-06-24 06:56:45',10,0),('5','183',257668,'Daily','2022-06-24','2022-06-24 07:27:24','2022-06-25 07:27:24','638',487045.35,487045.35,'638','2022-06-25 05:53:58','664','2022-06-25 06:12:06',10,0),('5','183',257669,'Daily','2022-06-25','2022-06-25 08:11:50','2022-06-26 08:11:50','638',715111.65,715111.65,'638','2022-06-26 06:27:05','664','2022-06-26 07:13:14',10,0),('5','183',257670,'Daily','2022-06-26','2022-06-26 15:48:44','2022-06-27 15:48:44','638',526930.80,526930.80,'638','2022-06-26 21:20:36','664','2022-06-27 07:33:28',10,0),('5','183',257671,'Daily','2022-06-27','2022-06-27 08:56:20','2022-06-28 08:56:20','638',614493.00,614493.00,'638','2022-06-28 06:13:09','664','2022-06-28 07:20:53',10,0),('5','183',257672,'Daily','2022-06-28','2022-06-28 09:45:42','2022-06-29 09:45:42','638',276153.90,276153.90,'638','2022-06-28 23:09:46','664','2022-06-29 08:00:01',10,0),('5','183',257673,'Daily','2022-06-29','2022-06-29 09:26:39','2022-06-30 09:26:39','638',0.00,0.00,'638','2022-06-29 22:59:47','664','2022-06-30 06:23:09',10,0),('5','183',257674,'Daily','2022-06-30','2022-06-30 07:05:17','2022-07-01 07:05:17','638',0.00,0.00,'638','2022-06-30 21:52:30','664','2022-07-01 07:08:17',10,0),('5','183',257675,'Daily','2022-07-01','2022-07-01 10:29:09','2022-07-02 10:29:09','638',0.00,0.00,'638','2022-07-01 17:23:15','664','2022-07-02 05:47:30',10,0),('5','183',257676,'Daily','2022-07-02','2022-07-02 10:16:43','2022-07-03 10:16:43','638',0.00,0.00,'638','2022-07-03 11:41:23','664','2022-07-03 11:43:40',10,0),('5','183',257677,'Daily','2022-07-03','2022-07-03 12:23:50','2022-07-04 12:23:50','638',0.00,0.00,'638','2022-07-03 20:38:09','664','2022-07-03 23:23:46',10,0),('5','183',257678,'Daily','2022-07-04','2022-07-04 06:26:04','2022-07-05 06:26:04','638',0.00,0.00,'638','2022-07-04 23:40:12','664','2022-07-05 05:04:34',10,0),('5','183',257679,'Daily','2022-07-05','2022-07-05 06:01:09','2022-07-06 06:01:09','638',0.00,0.00,'638','2022-07-05 23:18:57','664','2022-07-06 07:47:10',10,0),('5','183',257680,'Daily','2022-07-06','2022-07-06 08:35:23','2022-07-07 08:35:23','638',706695.00,706695.00,'638','2022-07-06 22:55:13','664','2022-07-07 05:23:18',10,0),('5','183',257681,'Daily','2022-07-07','2022-07-07 06:56:05','2022-07-08 06:56:05','638',482549.10,482549.10,'638','2022-07-08 04:39:21','664','2022-07-08 06:09:35',10,0),('5','183',257682,'Daily','2022-07-08','2022-07-08 06:39:45','2022-07-09 06:39:45','638',641950.65,641950.65,'638','2022-07-09 00:18:12','664','2022-07-09 06:36:16',10,0),('5','183',257683,'Daily','2022-07-09','2022-07-09 12:22:13','2022-07-10 12:22:13','638',620957.70,620957.70,'638','2022-07-10 06:55:10','664','2022-07-10 07:02:10',10,0),('5','183',257684,'DAILY SHITF ','2022-07-10','2022-07-10 08:38:10','2022-07-11 08:38:10','638',326053.20,326053.20,'638','2022-07-11 06:48:34','664','2022-07-11 06:59:22',10,0),('5','183',257685,'Daily','2022-07-11','2022-07-11 12:24:52','2022-07-12 12:24:52','638',551653.35,551653.35,'638','2022-07-12 07:01:31','664','2022-07-12 08:21:54',10,0),('5','183',257686,'Daily','2022-07-12','2022-07-12 10:07:52','2022-07-13 10:07:52','638',601198.20,601198.20,'638','2022-07-12 22:37:00','664','2022-07-13 07:16:25',10,0),('5','183',257687,'Daily','2022-07-13','2022-07-13 09:47:57','2022-07-14 09:47:57','638',254489.70,254489.70,'638','2022-07-14 06:23:07','664','2022-07-14 06:30:03',10,0),('5','183',257688,'Daily','2022-07-14','2022-07-14 06:57:56','2022-07-15 06:57:56','638',868364.10,868364.10,'638','2022-07-15 07:37:31','664','2022-07-15 07:42:50',10,0),('5','183',257689,'Daily','2022-07-15','2022-07-15 07:50:43','2022-07-16 07:50:43','638',982042.90,982042.90,'638','2022-07-16 06:13:45','664','2022-07-16 06:51:25',10,0),('5','183',257690,'Daily','2022-07-16','2022-07-16 08:26:05','2022-07-17 08:26:05','638',793000.65,793000.65,'638','2022-07-17 05:53:07','664','2022-07-17 08:16:28',10,0),('5','183',257691,'Daily','2022-07-17','2022-07-17 15:54:11','2022-07-18 15:54:11','638',943377.90,943377.90,'638','2022-07-18 04:10:00','664','2022-07-18 07:31:44',10,0),('5','183',257692,'Daily','2022-07-18','2022-07-18 12:13:14','2022-07-19 12:13:14','638',842939.55,842939.55,'638','2022-07-18 23:13:02','664','2022-07-19 05:02:02',10,0),('5','183',257693,'Daily','2022-07-19','2022-07-19 07:39:38','2022-07-20 07:39:38','638',1699546.90,1699546.90,'638','2022-07-20 10:12:42','664','2022-07-20 10:13:20',10,0),('5','183',257694,'Daily','2022-07-20','2022-07-20 10:16:40','2022-07-21 10:16:40','638',1632813.70,1632813.70,'638','2022-07-21 06:06:17','664','2022-07-21 06:46:53',10,0),('5','183',257695,'Daily','2022-07-21','2022-07-21 07:01:33','2022-07-22 07:01:33','638',731702.75,731702.75,'638','2022-07-22 03:21:34','664','2022-07-22 07:12:36',10,0),('5','183',257696,'Daily','2022-07-22','2022-07-22 07:37:50','2022-07-23 07:37:50','638',1998999.00,1998999.00,'638','2022-07-22 23:18:10','664','2022-07-23 06:52:37',10,0),('5','183',257697,'Daily','2022-07-23','2022-07-23 08:46:18','2022-07-24 08:46:18','638',2216018.80,2216018.80,'638','2022-07-23 23:19:35','664','2022-07-24 08:30:19',10,0),('5','183',257698,'Daily','2022-07-24','2022-07-24 13:48:17','2022-07-25 13:48:17','638',1501191.75,1501191.75,'638','2022-07-24 21:39:30','664','2022-07-25 06:42:33',10,0),('5','183',257699,'Daily','2022-07-25','2022-07-25 07:42:04','2022-07-26 07:42:04','638',1432412.45,1432412.45,'638','2022-07-26 05:45:05','664','2022-07-26 05:51:45',10,0),('5','183',257700,'Daily','2022-07-26','2022-07-26 08:07:05','2022-07-27 08:07:05','638',808046.70,808046.70,'638','2022-07-27 06:11:32','664','2022-07-27 07:31:24',10,0),('5','183',257701,'Daily','2022-07-27','2022-07-27 09:06:19','2022-07-28 09:06:19','638',925355.20,925355.20,'638','2022-07-28 05:35:45','664','2022-07-28 06:51:40',10,0),('5','183',257702,'Daily','2022-07-28','2022-07-28 07:19:31','2022-07-29 07:19:31','638',1064356.80,1064356.80,'638','2022-07-29 12:46:00','664','2022-07-29 12:47:53',10,0),('5','183',257703,'Daily','2022-07-29','2022-07-29 12:50:21','2022-07-30 12:50:21','638',549054.10,549054.10,'638','2022-07-30 05:54:12','664','2022-07-30 09:11:51',10,0),('5','183',257704,'Daily','2022-07-30','2022-07-30 10:59:02','2022-07-31 10:59:02','638',439843.05,439843.05,'638','2022-07-31 06:59:33','664','2022-07-31 09:27:02',10,0),('5','183',257705,'Daily','2022-07-31','2022-07-31 09:27:43','2022-08-01 09:27:43','638',0.00,0.00,'638','2022-08-01 06:21:32','664','2022-08-01 07:46:55',10,0),('5','183',257706,'Daily','2022-08-01','2022-08-01 08:53:33','2022-08-02 08:53:33','638',0.00,0.00,'638','2022-08-02 06:23:16','664','2022-08-02 08:01:08',10,0),('5','183',257707,'Daily','2022-08-02','2022-08-02 08:24:43','2022-08-03 08:24:43','638',1252721.95,1252721.95,'638','2022-08-03 06:33:29','664','2022-08-03 06:55:43',10,0),('5','183',257708,'Daily','2022-08-03','2022-08-03 07:24:20','2022-08-04 07:24:20','638',1291100.20,1291100.20,'638','2022-08-04 06:14:06','664','2022-08-04 07:24:25',10,0),('5','183',257709,'Daily','2022-08-04','2022-08-04 09:24:08','2022-08-05 09:24:08','638',671649.90,671649.90,'638','2022-08-04 22:55:30','664','2022-08-05 06:32:37',10,0),('5','183',257710,'Daily','2022-08-05','2022-08-05 07:54:57','2022-08-06 07:54:57','638',845888.45,845888.45,'638','2022-08-06 00:11:20','664','2022-08-06 07:00:09',10,0),('5','183',257711,'Daily','2022-08-06','2022-08-06 09:19:43','2022-08-07 09:19:43','638',987137.80,987137.80,'638','2022-08-07 06:29:24','664','2022-08-07 07:23:14',10,0),('5','183',257712,'Daily','2022-08-07','2022-08-07 11:33:59','2022-08-08 11:33:59','638',614747.60,614747.60,'638','2022-08-07 23:42:31','664','2022-09-05 06:46:25',10,0),('5','183',257713,'Daily','2022-08-08','2022-09-05 14:24:49','2022-09-06 14:24:49','638',694205.10,694205.10,'638','2022-09-05 14:30:22','664','2022-09-05 14:43:55',10,0),('5','183',257714,'Daily','2022-08-09','2022-09-05 15:55:19','2022-09-06 15:55:19','638',1095884.50,1095884.50,'638','2022-09-05 15:59:30','664','2022-09-05 16:03:44',10,0),('5','183',257715,'Daily','2022-08-10','2022-09-05 16:36:35','2022-09-06 16:36:35','638',974953.70,974953.70,'638','2022-09-05 16:43:44','664','2022-09-05 18:01:53',10,0),('5','183',257716,'Daily','2022-08-11','2022-09-06 09:53:59','2022-09-07 09:53:59','638',989043.30,989043.30,'638','2022-09-06 10:39:41','664','2022-09-06 11:12:10',10,0),('5','183',257717,'Daily','2022-08-12','2022-09-06 11:13:51','2022-09-07 11:13:51','638',845255.75,845255.75,'638','2022-09-06 11:22:14','664','2022-09-06 11:24:20',10,0),('5','183',257718,'Daily','2022-08-13','2022-09-06 11:46:08','2022-09-07 11:46:08','638',1048400.55,1048400.55,'638','2022-09-06 11:48:36','664','2022-09-06 11:53:24',10,0),('5','183',257719,'Daily','2022-08-14','2022-09-06 11:57:44','2022-09-07 11:57:44','638',878002.60,878002.60,'638','2022-09-06 12:09:43','664','2022-09-06 12:12:02',10,0),('5','183',257720,'Daily','2022-08-15','2022-09-06 12:21:33','2022-09-07 12:21:33','638',506000.90,506000.90,'638','2022-09-06 12:24:43','664','2022-09-06 12:30:36',10,0),('5','183',257721,'Daily','2022-08-16','2022-09-06 12:53:00','2022-09-07 12:53:00','638',558117.25,558117.25,'638','2022-09-06 12:56:15','664','2022-09-06 13:08:35',10,0),('5','183',257722,'Daily','2022-08-17','2022-09-06 13:15:25','2022-09-07 13:15:25','638',848583.90,848583.90,'638','2022-09-06 13:18:30','664','2022-09-06 13:40:02',10,0),('5','183',257723,'Daily','2022-08-18','2022-09-06 13:41:12','2022-09-07 13:41:12','638',843840.50,843840.50,'638','2022-09-06 13:47:54','664','2022-09-06 13:50:00',10,0),('5','183',257724,'Daily','2022-08-19','2022-09-06 14:13:01','2022-09-07 14:13:01','638',480230.40,480230.40,'638','2022-09-06 14:15:38','664','2022-09-06 14:17:17',10,0),('5','183',257725,'Daily','2022-08-20','2022-09-06 14:31:03','2022-09-07 14:31:03','638',843873.80,843873.80,'638','2022-09-06 14:33:30','664','2022-09-06 14:34:58',10,0),('5','183',257726,'Daily','2022-08-21','2022-09-06 14:37:41','2022-09-07 14:37:41','638',1101458.55,1101458.55,'638','2022-09-06 14:41:46','664','2022-09-06 14:45:46',10,0),('5','183',257727,'Daily','2022-08-22','2022-09-06 14:49:20','2022-09-07 14:49:20','638',892484.40,892484.40,'638','2022-09-06 14:51:59','664','2022-09-06 14:52:53',10,0),('5','183',257728,'Daily','2022-08-23','2022-09-06 15:17:15','2022-09-07 15:17:15','638',885210.20,885210.20,'638','2022-09-06 15:19:11','664','2022-09-06 15:22:30',10,0),('5','183',257729,'Daily','2022-08-24','2022-09-06 15:28:47','2022-09-07 15:28:47','638',771738.60,771738.60,'638','2022-09-06 15:31:18','664','2022-09-06 15:40:20',10,0),('5','183',257730,'Daily','2022-08-25','2022-09-06 15:49:26','2022-09-07 15:49:26','638',616823.30,616823.30,'638','2022-09-06 15:51:55','664','2022-09-06 16:04:25',10,0),('5','183',257731,'Daily','2022-08-26','2022-09-06 16:20:21','2022-09-07 16:20:21','638',758886.65,758886.65,'638','2022-09-06 16:22:53','664','2022-09-06 16:29:21',10,0),('5','183',257732,'Daily','2022-08-27','2022-09-06 16:50:05','2022-09-07 16:50:05','638',680622.40,680622.40,'638','2022-09-06 16:52:48','664','2022-09-07 08:20:35',10,0),('5','183',257733,'Daily','2022-08-28','2022-09-07 09:05:08','2022-09-08 09:05:08','638',583902.55,583902.55,'638','2022-09-07 09:07:34','664','2022-09-07 09:11:59',10,0),('5','183',257734,'Daily','2022-08-29','2022-09-07 09:14:52','2022-09-08 09:14:52','638',538068.80,538068.80,'638','2022-09-07 09:25:14','664','2022-09-07 09:26:11',10,0),('5','183',257735,'Daily','2022-08-30','2022-09-07 09:34:55','2022-09-08 09:34:55','638',763559.75,763559.75,'638','2022-09-07 09:37:39','664','2022-09-07 09:45:22',10,0),('5','183',257736,'Daily','2022-08-31','2022-09-07 09:50:46','2022-09-08 09:50:46','638',644251.40,644251.40,'638','2022-09-07 09:53:08','664','2022-09-07 09:54:26',10,0),('5','183',257737,'Daily','2022-09-01','2022-09-07 09:58:11','2022-09-08 09:58:11','638',779105.30,779105.30,'638','2022-09-07 10:00:36','664','2022-09-07 10:08:02',10,0),('5','183',257738,'Daily','2022-09-02','2022-09-07 10:11:05','2022-09-08 10:11:05','638',552826.25,552826.25,'638','2022-09-07 10:16:55','664','2022-09-07 10:18:14',10,0),('5','183',257739,'Daily','2022-09-03','2022-09-07 10:21:09','2022-09-08 10:21:09','638',704171.05,704171.05,'638','2022-09-07 10:23:31','664','2022-09-07 10:24:40',10,0),('5','183',257740,'Daily','2022-09-04','2022-09-07 10:27:56','2022-09-08 10:27:56','638',688858.60,688858.60,'638','2022-09-07 10:31:20','664','2022-09-07 10:31:41',10,0),('5','183',257741,'Daily','2022-09-05','2022-09-07 10:34:21','2022-09-08 10:34:21','638',1079591.55,1079591.55,'638','2022-09-07 10:36:23','664','2022-09-07 10:37:08',10,0),('5','183',257742,'Daily','2022-09-06','2022-09-07 10:38:38','2022-09-08 10:38:38','638',1089030.25,1089030.25,'638','2022-09-07 10:40:21','664','2022-09-07 10:41:42',10,0),('5','183',257743,'Daily','2022-09-07','2022-09-07 10:48:11','2022-09-08 10:48:11','638',869783.05,869783.05,'638','2022-09-08 05:59:37','664','2022-09-08 07:08:12',10,0),('5','183',257744,'Daily shift','2022-09-08','2022-09-08 10:36:14','2022-09-09 10:36:14','638',664532.95,664532.95,'638','2022-09-08 23:39:38','664','2022-09-09 08:15:14',10,0),('5','183',257745,'Daily','2022-09-09','2022-09-09 08:26:22','2022-09-10 08:26:22','638',577679.15,577679.15,'638','2022-09-10 11:42:14','664','2022-09-10 13:01:17',10,0),('5','183',257746,'Daily','2022-09-10','2022-09-10 13:06:25','2022-09-11 13:06:25','638',650280.55,650280.55,'638','2022-09-11 06:38:43','664','2022-09-11 08:53:24',10,0),('5','183',257747,'Daily','2022-09-11','2022-09-11 17:15:58','2022-09-12 17:15:58','638',239388.15,239388.15,'638','2022-09-12 06:18:01','664','2022-09-12 08:53:04',10,0),('5','183',257748,'Daily','2022-09-12','2022-09-12 09:03:24','2022-09-13 09:03:24','638',651938.15,651938.15,'638','2022-09-13 00:25:00','664','2022-09-13 09:13:17',10,0),('5','183',257749,'Daily','2022-09-13','2022-09-13 12:54:30','2022-09-14 12:54:30','638',429514.50,429514.50,'638','2022-09-14 05:55:14','664','2022-09-14 08:10:20',10,0),('5','183',257750,'Daily','2022-09-14','2022-09-14 11:14:26','2022-09-15 11:14:26','638',724793.00,724793.00,'638','2022-09-15 06:18:04','664','2022-09-15 08:49:38',10,0),('5','183',257751,'Daily','2022-09-15','2022-09-16 06:11:42','2022-09-17 06:11:42','638',780659.30,780659.30,'638','2022-09-16 06:15:16','664','2022-09-16 09:05:40',10,0),('5','183',257752,'Daily','2022-09-16','2022-09-16 09:46:48','2022-09-17 09:46:48','638',555838.05,555838.05,'638','2022-09-17 06:56:23','664','2022-09-17 10:11:41',10,0),('5','183',257753,'Daily','2022-09-17','2022-09-17 13:19:36','2022-09-18 13:19:36','638',623485.15,623485.15,'638','2022-09-18 06:18:49','664','2022-09-18 07:19:08',10,0),('5','183',257754,'Daily','2022-09-18','2022-09-18 11:55:29','2022-09-19 11:55:29','638',887232.25,887232.25,'638','2022-09-19 06:43:21','664','2022-09-19 07:18:27',10,0),('5','183',257755,'Daily','2022-09-19','2022-09-19 08:18:05','2022-09-20 08:18:05','638',681373.50,681373.50,'638','2022-09-20 06:41:31','664','2022-09-20 08:31:26',10,0),('5','183',257756,'Daily','2022-09-20','2022-09-21 05:57:57','2022-09-22 05:57:57','638',633983.90,633983.90,'638','2022-09-21 06:02:40','664','2022-09-21 11:48:42',10,0),('5','183',257757,'Daily','2022-09-21','2022-09-22 06:17:50','2022-09-23 06:17:50','638',599070.70,599070.70,'638','2022-09-22 06:20:52','664','2022-09-22 07:37:35',10,0),('5','183',257758,'Daily','2022-09-22','2022-09-22 08:15:49','2022-09-23 08:15:49','638',791224.65,791224.65,'638','2022-09-23 06:18:26','664','2022-09-23 07:46:01',10,0),('5','183',257759,'Daily','2022-09-23','2022-09-23 08:38:54','2022-09-24 08:38:54','638',671620.30,671620.30,'638','2022-09-24 06:51:14','664','2022-09-24 08:28:33',10,0),('5','183',257760,'Daily','2022-09-24','2022-09-24 15:32:06','2022-09-25 15:32:06','638',515028.90,515028.90,'638','2022-09-25 06:55:45','664','2022-09-25 08:02:19',10,0),('5','183',257761,'Daily','2022-09-25','2022-09-25 18:57:23','2022-09-26 18:57:23','638',1255526.55,1255526.55,'638','2022-09-26 07:08:22','664','2022-09-26 07:16:05',10,0),('5','183',257762,'Daily','2022-09-26','2022-09-26 07:49:04','2022-09-27 07:49:04','638',791430.00,791430.00,'638','2022-09-27 06:34:06','664','2022-09-27 07:22:26',10,0),('5','183',257763,'Daily','2022-09-27','2022-09-27 08:24:29','2022-09-28 08:24:29','638',950522.60,950522.60,'638','2022-09-28 06:17:57','664','2022-09-28 08:20:54',10,0),('5','183',257764,'Daily','2022-09-28','2022-09-28 09:29:21','2022-09-29 09:29:21','638',1040895.10,1040895.10,'638','2022-09-29 06:30:54','664','2022-09-29 08:32:42',10,0),('5','183',257765,'Daily','2022-09-29','2022-09-29 08:38:25','2022-09-30 08:38:25','638',1052853.50,1052853.50,'638','2022-09-30 07:14:01','664','2022-09-30 08:05:45',10,0),('5','183',257766,'Daily','2022-09-30','2022-09-30 11:37:31','2022-10-01 11:37:31','638',921213.05,921213.05,'638','2022-10-01 06:17:59','664','2022-10-01 08:56:26',10,0),('5','183',257767,'Daily','2022-10-01','2022-10-01 10:02:22','2022-10-02 10:02:22','638',911565.30,911565.30,'638','2022-10-02 10:16:42','664','2022-10-02 18:36:26',10,0),('5','183',257768,'Daily','2022-10-02','2022-10-02 23:38:39','2022-10-03 23:38:39','638',1160360.70,1160360.70,'638','2022-10-03 05:55:59','664','2022-10-03 06:22:58',10,0),('5','183',257769,'Daily','2022-10-03','2022-10-03 11:59:48','2022-10-04 11:59:48','638',947529.30,947529.30,'638','2022-10-04 06:50:47','664','2022-10-04 07:10:24',10,0),('5','183',257770,'Daily','2022-10-04','2022-10-04 09:48:53','2022-10-05 09:48:53','638',743794.35,743794.35,'638','2022-10-05 06:48:49','664','2022-10-05 09:35:17',10,0),('5','183',257771,'Daily','2022-10-05','2022-10-05 09:52:21','2022-10-06 09:52:21','638',1042036.55,1042036.55,'638','2022-10-06 06:35:04','664','2022-10-06 07:57:06',10,0),('5','183',257772,'Daily','2022-10-06','2022-10-06 08:41:40','2022-10-07 08:41:40','638',976731.55,976731.55,'638','2022-10-07 07:05:29','664','2022-10-07 08:22:49',10,0),('5','183',257773,'Daily','2022-10-07','2022-10-07 09:20:57','2022-10-08 09:20:57','638',1214425.10,1214425.10,'638','2022-10-08 07:50:35','664','2022-10-08 08:34:08',10,0),('5','183',257774,'Daily','2022-10-08','2022-10-08 09:09:57','2022-10-09 09:09:57','638',1193662.55,1193662.55,'638','2022-10-09 07:11:38','664','2022-10-09 08:29:38',10,0),('5','183',257775,'Daily','2022-10-09','2022-10-10 08:33:02','2022-10-11 08:33:02','638',1006468.45,1006468.45,'638','2022-10-10 13:52:12','664','2022-10-10 14:18:04',10,0),('5','183',257776,'Daily','2022-10-10','2022-10-10 14:25:00','2022-10-11 14:25:00','638',0.00,0.00,'638','2022-10-11 07:00:59','664','2022-10-11 07:03:39',10,0),('5','183',257777,'Daily','2022-10-11','2022-10-11 12:00:38','2022-10-12 12:00:38','638',0.00,0.00,'638','2022-10-12 05:57:39','664','2022-10-12 10:02:46',10,0),('5','183',257778,'Daily','2022-10-12','2022-10-13 06:01:52','2022-10-14 06:01:52','638',0.00,0.00,'638','2022-10-13 08:49:40','664','2022-10-13 12:45:47',10,0),('5','183',257779,'Daily','2022-10-13','2022-10-13 22:41:34','2022-10-14 22:41:34','638',0.00,0.00,'638','2022-10-13 22:42:05','664','2022-10-14 07:29:00',10,0),('5','183',257780,'Daily','2022-10-14','2022-10-14 08:38:06','2022-10-15 08:38:06','638',0.00,0.00,'638','2022-10-15 07:05:09','664','2022-10-15 09:44:26',10,0),('5','183',257781,'Daily','2022-10-15','2022-10-16 07:34:34','2022-10-17 07:34:34','638',0.00,0.00,'638','2022-10-16 07:35:14','664','2022-10-16 08:37:20',10,0),('5','183',257782,'Daily','2022-10-16','2022-10-16 23:28:36','2022-10-17 23:28:36','638',0.00,0.00,'638','2022-10-16 23:29:13','664','2022-10-17 07:34:18',10,0),('5','183',257783,'Daily','2022-10-17','2022-10-17 12:15:59','2022-10-18 12:15:59','638',0.00,0.00,'638','2022-10-17 21:32:29','664','2022-10-18 07:41:43',10,0),('5','183',257784,'Daily','2022-10-18','2022-10-18 20:21:41','2022-10-19 20:21:41','638',0.00,0.00,'638','2022-10-18 20:22:06','664','2022-10-19 07:36:14',10,0),('5','183',257785,'Daily','2022-10-19','2022-10-19 08:11:44','2022-10-20 08:11:44','638',0.00,0.00,'638','2022-10-20 00:51:55','664','2022-10-20 07:01:40',10,0),('5','183',257786,'Daily','2022-10-20','2022-10-20 10:49:40','2022-10-21 10:49:40','638',0.00,0.00,'638','2022-10-21 07:58:09','664','2022-10-21 08:01:11',10,0),('5','183',257787,'Daily','2022-10-21','2022-10-21 08:15:36','2022-10-22 08:15:36','638',0.00,0.00,'638','2022-10-21 19:11:05','664','2022-10-22 06:14:44',10,0),('5','183',257788,'Daily','2022-10-22','2022-10-22 06:56:47','2022-10-23 06:56:47','638',0.00,0.00,'638','2022-10-22 18:43:53','664','2022-10-23 08:09:05',10,0),('5','183',257789,'Daily','2022-10-23','2022-10-23 08:40:43','2022-10-24 08:40:43','638',0.00,0.00,'638','2022-10-23 20:02:51','664','2022-10-24 07:22:09',10,0),('5','183',257790,'Daily','2022-10-24','2022-10-24 07:49:22','2022-10-25 07:49:22','638',0.00,0.00,'638','2022-10-24 23:08:15','664','2022-10-25 07:20:43',10,0),('5','183',257791,'Daily','2022-10-25','2022-10-25 07:22:22','2022-10-26 07:22:22','638',0.00,0.00,'638','2022-10-25 21:22:39','664','2022-10-26 07:20:21',10,0),('5','183',257792,'Daily','2022-10-26','2022-10-26 17:08:00','2022-10-27 17:08:00','638',0.00,0.00,'638','2022-10-26 17:08:38','664','2022-10-27 07:13:17',10,0),('5','183',257793,'Daily','2022-10-27','2022-10-27 08:07:15','2022-10-28 08:07:15','638',0.00,0.00,'638','2022-10-28 00:56:42','664','2022-10-28 06:51:44',10,0),('5','183',257794,'Daily','2022-10-28','2022-10-28 07:48:58','2022-10-29 07:48:58','638',1618935.00,1618935.00,'638','2022-10-29 05:58:01','664','2022-10-29 07:53:42',10,0),('5','183',257795,'Daily','2022-10-29','2022-10-29 14:42:46','2022-10-30 14:42:46','638',2087088.60,2087088.60,'638','2022-10-30 04:56:34','664','2022-10-30 06:34:19',10,0),('5','183',257796,'Daily','2022-10-30','2022-10-30 08:51:10','2022-10-31 08:51:10','638',1961804.75,1961804.75,'638','2022-10-30 22:28:50','664','2022-10-31 06:44:27',10,0),('5','183',257797,'Daily','2022-10-31','2022-10-31 07:43:57','2022-11-01 07:43:57','638',1935048.20,1935048.20,'638','2022-11-01 07:01:32','664','2022-11-01 07:53:16',10,0),('5','183',257798,'Daily','2022-11-01','2022-11-01 10:10:28','2022-11-02 10:10:28','638',2092969.75,2092969.75,'638','2022-11-02 10:52:14','664','2022-11-02 13:05:08',10,0),('5','183',257799,'Daily','2022-11-02','2022-11-02 13:09:19','2022-11-03 13:09:19','638',2460816.35,2460816.35,'638','2022-11-03 06:52:49','664','2022-11-03 08:12:11',10,0),('5','183',257800,'Daily','2022-11-03','2022-11-03 09:44:29','2022-11-04 09:44:29','638',2687254.50,2687254.50,'638','2022-11-04 06:02:59','664','2022-11-04 07:31:02',10,0),('5','183',257801,'Daily','2022-11-04','2022-11-04 08:48:53','2022-11-05 08:48:53','638',2588242.50,2588242.50,'638','2022-11-06 06:05:06','664','2022-11-06 07:07:13',10,0),('5','183',257802,'Daily','2022-11-05','2022-11-06 07:24:28','2022-11-07 07:24:28','638',2357849.05,2357849.05,'638','2022-11-06 07:29:02','664','2022-11-06 12:34:41',10,0),('5','183',257803,'Daily','2022-11-06','2022-11-06 13:54:56','2022-11-07 13:54:56','638',1613355.40,1613355.40,'638','2022-11-07 06:11:58','664','2022-11-07 08:28:09',10,0),('5','183',257804,'Daily','2022-11-07','2022-11-07 09:15:59','2022-11-08 09:15:59','638',932105.85,932105.85,'638','2022-11-08 07:12:14','664','2022-11-08 07:58:54',10,0),('5','183',257805,'Daily','2022-11-08','2022-11-08 08:10:42','2022-11-09 08:10:42','638',1082928.95,1082928.95,'638','2022-11-09 08:22:59','664','2022-11-09 08:24:37',10,0),('5','183',257806,'Daily','2022-11-09','2022-11-09 08:27:12','2022-11-10 08:27:12','638',591457.95,591457.95,'638','2022-11-10 06:04:41','664','2022-11-10 09:27:51',10,0),('5','183',257807,'Daily','2022-11-10','2022-11-10 09:38:49','2022-11-11 09:38:49','638',0.00,0.00,'638','2022-11-10 20:13:59','664','2022-11-11 07:51:11',10,0),('5','183',257808,'Daily','2022-11-11','2022-11-11 10:26:54','2022-11-12 10:26:54','638',0.00,0.00,'638','2022-11-11 20:09:36','664','2022-11-12 08:14:32',10,0),('5','183',257809,'Daily','2022-11-12','2022-11-12 08:48:40','2022-11-13 08:48:40','638',0.00,0.00,'638','2022-11-12 23:16:42','664','2022-11-13 09:49:58',10,0),('5','183',257810,'Daily','2022-11-13','2022-11-13 13:06:45','2022-11-14 13:06:45','638',0.00,0.00,'638','2022-11-13 23:34:57','664','2022-11-14 05:35:53',10,0),('5','183',257811,'Daily','2022-11-14','2022-11-14 09:37:23','2022-11-15 09:37:23','638',0.00,0.00,'638','2022-11-15 07:52:30','664','2022-11-15 08:11:44',10,0),('5','183',257812,'Daily','2022-11-15','2022-11-15 10:32:36','2022-11-16 10:32:36','638',0.00,0.00,'638','2022-11-16 06:47:12','664','2022-11-16 07:33:41',10,0),('5','183',257813,'Daily','2022-11-16','2022-11-16 09:08:45','2022-11-17 09:08:45','638',0.00,0.00,'638','2022-11-16 21:55:15','664','2022-11-17 07:59:32',10,0),('5','183',257814,'Daily','2022-11-17','2022-11-17 23:41:21','2022-11-18 23:41:21','638',0.00,0.00,'638','2022-11-17 23:41:53','664','2022-11-18 07:32:16',10,0),('5','183',257815,'Daily','2022-11-18','2022-11-18 11:35:40','2022-11-19 11:35:40','638',0.00,0.00,'638','2022-11-19 07:00:32','664','2022-11-19 08:26:54',10,0),('5','183',257816,'Daily','2022-11-19','2022-11-19 08:35:46','2022-11-20 08:35:46','638',0.00,0.00,'638','2022-11-20 14:35:15','664','2022-11-20 14:54:26',10,0),('5','183',257817,'Daily','2022-11-20','2022-11-20 16:23:13','2022-11-21 16:23:13','638',2216444.30,2216444.30,'638','2022-11-21 06:21:59','664','2022-11-21 06:37:11',10,0),('5','183',257818,'Daily','2022-11-21','2022-11-21 07:23:21','2022-11-22 07:23:21','638',1893867.20,1893867.20,'638','2022-11-21 22:14:32','664','2022-11-22 09:20:57',10,0),('5','183',257819,'Daily','2022-11-22','2022-11-22 14:02:53','2022-11-23 14:02:53','638',1550805.05,1550805.05,'638','2022-11-23 07:14:04','664','2022-11-23 08:29:45',10,0),('5','183',257820,'Daily','2022-11-23','2022-11-23 08:35:09','2022-11-24 08:35:09','638',1548618.35,1548618.35,'638','2022-11-24 05:51:47','600','2022-11-24 13:10:23',10,0),('5','183',257821,'Daily','2022-11-24','2022-11-24 23:17:51','2022-11-25 23:17:51','638',1083648.60,1083648.60,'638','2022-11-25 06:54:06','664','2022-11-25 08:31:55',10,0),('5','183',257822,'Daily','2022-11-25','2022-11-26 10:42:28','2022-11-27 10:42:28','638',0.00,0.00,'638','2022-11-26 10:43:27','664','2022-11-26 14:27:40',10,0),('5','183',257823,'Daily','2022-11-26','2022-11-26 22:31:52','2022-11-27 22:31:52','638',0.00,0.00,'638','2022-11-26 22:32:35','664','2022-11-27 08:31:08',10,0),('5','183',257824,'Daily','2022-11-27','2022-11-27 19:19:47','2022-11-28 19:19:47','638',0.00,0.00,'638','2022-11-27 19:20:15','664','2022-11-28 07:53:25',10,0),('5','183',257825,'Daily','2022-11-28','2022-11-28 16:36:39','2022-11-29 16:36:39','638',0.00,0.00,'638','2022-11-29 07:08:38','664','2022-11-29 08:11:34',10,0),('5','183',257826,'Daily','2022-11-29','2022-11-29 11:38:36','2022-11-30 11:38:36','638',0.00,0.00,'638','2022-11-30 07:16:16','664','2022-11-30 07:33:29',10,0),('5','183',257827,'Daily','2022-11-30','2022-11-30 10:09:13','2022-12-01 10:09:13','638',0.00,0.00,'638','2022-11-30 21:12:45','664','2022-12-01 07:44:28',10,0),('5','183',257828,'Daily','2022-12-01','2022-12-01 08:07:24','2022-12-02 08:07:24','638',2164566.60,2164566.60,'638','2022-12-02 07:16:04','664','2022-12-02 09:11:17',10,0),('5','183',257829,'Daily','2022-12-02','2022-12-03 06:48:17','2022-12-04 06:48:17','638',1879620.35,1879620.35,'638','2022-12-03 06:50:47','664','2022-12-03 08:22:01',10,0),('5','183',257830,'Daily','2022-12-03','2022-12-04 06:01:49','2022-12-05 06:01:49','638',2041835.75,2041835.75,'638','2022-12-04 06:04:55','664','2022-12-04 09:14:12',10,0),('5','183',257831,'Daily','2022-12-04','2022-12-05 06:35:51','2022-12-06 06:35:51','638',2000062.75,2000062.75,'638','2022-12-05 13:51:42','664','2022-12-05 13:56:25',10,0),('5','183',257832,'Daily','2022-12-05','2022-12-05 13:59:37','2022-12-06 13:59:37','638',2529397.70,2529397.70,'638','2022-12-06 06:20:58','664','2022-12-06 07:55:57',10,0),('5','183',257833,'Daily','2022-12-06','2022-12-06 08:53:47','2022-12-07 08:53:47','638',2223459.50,2223459.50,'638','2022-12-07 07:53:00','664','2022-12-08 07:48:22',10,0),('5','183',257834,'Daily','2022-12-07','2022-12-08 13:34:44','2022-12-09 13:34:44','638',0.00,0.00,'638','2022-12-08 13:35:22','664','2022-12-09 08:11:20',10,0),('5','183',257835,'Daily','2022-12-08','2022-12-09 13:57:00','2022-12-10 13:57:00','638',0.00,0.00,'638','2022-12-09 13:57:23','664','2022-12-09 16:26:34',10,0),('5','183',257836,'Daily','2022-12-09','2022-12-10 17:54:03','2022-12-11 17:54:03','638',0.00,0.00,'638','2022-12-10 17:54:59','664','2022-12-10 20:38:14',10,0),('5','183',257837,'Daily','2022-12-10','2022-12-12 06:05:00','2022-12-13 06:05:00','638',0.00,0.00,'638','2022-12-12 06:05:35','664','2022-12-12 08:05:59',10,0),('5','183',257838,'Daily','2022-12-11','2022-12-12 12:43:19','2022-12-13 12:43:19','638',0.00,0.00,'638','2022-12-12 12:43:44','664','2022-12-12 13:16:25',10,0),('5','183',257839,'Daily','2022-12-12','2022-12-12 16:09:57','2022-12-13 16:09:57','638',0.00,0.00,'638','2022-12-12 22:46:40','664','2022-12-13 08:19:43',10,0),('5','183',257840,'Daily','2022-12-13','2022-12-13 11:39:30','2022-12-14 11:39:30','638',0.00,0.00,'638','2022-12-14 13:14:28','664','2022-12-14 13:17:54',10,0),('5','183',257841,'Daily','2022-12-14','2022-12-14 13:59:01','2022-12-15 13:59:01','638',0.00,0.00,'638','2022-12-14 19:08:09','1013','2022-12-15 09:54:29',10,0),('5','183',257842,'Daily','2022-12-15','2022-12-15 13:22:28','2022-12-16 13:22:28','638',0.00,0.00,'638','2022-12-15 18:56:39','664','2022-12-16 07:28:02',10,0),('5','183',257843,'Daily','2022-12-16','2022-12-16 10:21:22','2022-12-17 10:21:22','638',0.00,0.00,'638','2022-12-17 07:34:40','664','2022-12-17 11:13:29',10,0),('5','183',257844,'Daily','2022-12-17','2022-12-17 13:54:37','2022-12-18 13:54:37','638',0.00,0.00,'638','2022-12-18 06:55:34','1013','2022-12-18 10:40:00',10,0),('5','183',257845,'Daily','2022-12-18','2022-12-19 06:23:01','2022-12-20 06:23:01','638',0.00,0.00,'638','2022-12-19 06:23:26','1013','2022-12-19 09:01:32',10,0),('5','183',257846,'Daily','2022-12-19','2022-12-19 12:32:59','2022-12-20 12:32:59','638',2212988.50,2212988.50,'638','2022-12-20 06:25:28','1013','2022-12-20 09:35:08',10,0),('5','183',257847,'Daily','2022-12-20','2022-12-20 10:32:02','2022-12-21 10:32:02','638',2423372.35,2423372.35,'638','2022-12-21 08:56:23','1013','2022-12-21 09:19:47',10,0),('5','183',257848,'Daily','2022-12-21','2022-12-22 07:09:46','2022-12-23 07:09:46','638',885341.55,885341.55,'638','2022-12-22 07:15:49','1013','2022-12-22 09:05:06',10,0),('5','183',257849,'Daily','2022-12-22','2022-12-22 10:48:17','2022-12-23 10:48:17','638',0.00,0.00,'638','2022-12-22 20:13:47','1013','2022-12-23 11:07:06',10,0),('5','183',257850,'Daily','2022-12-23','2022-12-23 12:03:45','2022-12-24 12:03:45','638',0.00,0.00,'638','2022-12-23 20:07:54','1013','2022-12-24 12:03:18',10,0),('5','183',257851,'Daily','2022-12-24','2022-12-24 22:45:21','2022-12-25 22:45:21','638',0.00,0.00,'638','2022-12-24 22:45:49','1013','2022-12-25 18:27:22',10,0),('5','183',257852,'Daily','2022-12-25','2022-12-25 20:08:01','2022-12-26 20:08:01','638',0.00,0.00,'638','2022-12-25 20:08:39','1013','2022-12-26 21:06:28',10,0),('5','183',257853,'Daily','2022-12-26','2022-12-26 23:49:44','2022-12-27 23:49:44','638',0.00,0.00,'638','2022-12-26 23:50:15','1013','2022-12-27 11:50:25',10,0),('5','183',257854,'Daily','2022-12-27','2022-12-27 15:44:01','2022-12-28 15:44:01','638',0.00,0.00,'638','2022-12-27 15:44:31','1013','2022-12-28 09:00:27',10,0),('5','183',257855,'Daily','2022-12-28','2022-12-28 14:11:00','2022-12-29 14:11:00','638',0.00,0.00,'638','2022-12-30 07:34:26','1013','2022-12-30 08:10:11',10,0),('5','183',257856,'Daily','2022-12-29','2022-12-30 17:35:26','2022-12-31 17:35:26','638',0.00,0.00,'638','2022-12-30 17:35:48','1013','2022-12-30 22:16:24',10,0),('5','183',257857,'Daily','2022-12-30','2022-12-31 09:31:16','2023-01-01 09:31:16','638',0.00,0.00,'638','2022-12-31 09:31:48','1013','2022-12-31 09:38:04',10,0),('5','183',257858,'Daily','2022-12-31','2022-12-31 11:56:06','2023-01-01 11:56:06','638',0.00,0.00,'638','2023-01-01 07:23:47','1013','2023-01-01 11:29:47',10,0),('5','183',257859,'Daily','2023-01-01','2023-01-01 12:22:14','2023-01-02 12:22:14','638',0.00,0.00,'638','2023-01-01 21:53:31','1013','2023-01-02 10:37:30',10,0),('5','183',257860,'Daily','2023-01-02','2023-01-02 15:05:56','2023-01-03 15:05:56','638',0.00,0.00,'638','2023-01-03 07:01:21','1013','2023-01-03 09:16:56',10,0),('5','183',257861,'Daily','2023-01-03','2023-01-03 09:49:48','2023-01-04 09:49:48','638',0.00,0.00,'638','2023-01-03 20:08:03','1013','2023-01-04 09:28:28',10,0),('5','183',257862,'Daily','2023-01-04','2023-01-04 10:06:56','2023-01-05 10:06:56','638',0.00,0.00,'638','2023-01-04 23:19:39','1013','2023-01-05 09:08:58',10,0),('5','183',257863,'Daily','2023-01-05','2023-01-05 12:43:26','2023-01-06 12:43:26','638',0.00,0.00,'638','2023-01-05 19:19:48','1013','2023-01-06 09:10:43',10,0),('5','183',257864,'Daily','2023-01-06','2023-01-06 12:07:50','2023-01-07 12:07:50','638',0.00,0.00,'638','2023-01-06 22:20:00','1013','2023-01-07 08:39:50',10,0),('5','183',257865,'Daily','2023-01-07','2023-01-07 13:53:37','2023-01-08 13:53:37','638',0.00,0.00,'638','2023-01-07 19:41:49','1013','2023-01-07 20:16:58',10,0),('5','183',257866,'Daily','2023-01-08','2023-01-08 07:05:05','2023-01-09 07:05:05','638',0.00,0.00,'638','2023-01-08 19:13:20','1013','2023-01-09 09:18:01',10,0),('5','183',257867,'Daily','2023-01-09','2023-01-09 10:22:56','2023-01-10 10:22:56','638',0.00,0.00,'638','2023-01-10 06:27:18','1013','2023-01-10 09:11:47',10,0),('5','183',257868,'Daily','2023-01-10','2023-01-10 21:13:23','2023-01-11 21:13:23','638',0.00,0.00,'638','2023-01-10 21:14:06','1013','2023-01-10 22:19:59',10,0),('5','183',257869,'Daily','2023-01-11','2023-01-12 06:51:54','2023-01-13 06:51:54','638',0.00,0.00,'638','2023-01-12 06:52:33','1013','2023-01-12 09:23:29',10,0),('5','183',257870,'Daily','2023-01-12','2023-01-12 14:05:25','2023-01-13 14:05:25','638',0.00,0.00,'638','2023-01-12 19:14:42','1013','2023-01-12 22:21:59',10,0),('5','183',257871,'Daily','2023-01-12','2023-01-13 06:48:11','2023-01-14 06:48:11','638',0.00,0.00,'638','2023-01-13 12:42:38','1013','2023-01-13 16:29:41',10,0),('5','183',257872,'Daily','2023-01-13','2023-01-13 20:58:06','2023-01-14 20:58:06','638',0.00,0.00,'638','2023-01-13 20:58:50','1013','2023-01-13 23:02:28',10,0),('5','183',257873,'Daily','2023-01-14','2023-01-14 08:19:06','2023-01-15 08:19:06','638',0.00,0.00,'638','2023-01-14 19:23:53','1013','2023-01-15 08:14:10',10,0),('5','183',257874,'Daily','2023-01-15','2023-01-15 16:43:30','2023-01-16 16:43:30','638',0.00,0.00,'638','2023-01-15 23:09:27','1013','2023-01-16 09:31:48',10,0),('5','183',257875,'Daily','2023-01-16','2023-01-17 06:45:54','2023-01-18 06:45:54','638',1960426.50,1960426.50,'638','2023-01-17 06:55:07','1013','2023-01-17 09:39:10',10,0),('5','183',257876,'Daily','2023-01-17','2023-01-17 12:27:38','2023-01-18 12:27:38','638',2936109.10,2936109.10,'638','2023-01-18 09:35:29','1013','2023-01-18 09:36:58',10,0),('5','183',257877,'Daily','2023-01-18','2023-01-18 09:40:25','2023-01-19 09:40:25','638',625714.40,625714.40,'638','2023-01-19 07:56:24','1013','2023-01-19 09:32:43',10,0),('5','183',257878,'Daily','2023-01-19','2023-01-19 10:07:21','2023-01-20 10:07:21','638',0.00,0.00,'638','2023-01-19 22:13:06','1013','2023-01-20 08:53:37',10,0),('5','183',257879,'Daily','2023-01-20','2023-01-20 09:30:11','2023-01-21 09:30:11','638',0.00,0.00,'638','2023-01-21 07:54:57','1013','2023-01-21 08:19:21',10,0),('5','183',257880,'Daily','2023-01-21','2023-01-21 12:38:47','2023-01-22 12:38:47','638',1199041.80,1008285.15,'638','2023-01-22 07:05:05','1013','2023-01-22 10:18:06',10,0),('5','183',257881,'Daily','2023-01-22','2023-01-22 10:59:26','2023-01-23 10:59:26','638',2012645.80,1692452.15,'638','2023-01-23 10:02:09','1013','2023-01-23 10:09:30',10,0),('5','183',257882,'Daily','2023-01-23','2023-01-23 10:14:36','2023-01-24 10:14:36','638',858312.40,858312.40,'638','2023-01-24 06:38:52','1013','2023-01-24 11:26:44',10,0),('5','183',257883,'Daily','2023-01-24','2023-01-24 11:36:12','2023-01-25 11:36:12','638',0.00,0.00,'638','2023-01-24 20:32:59','1013','2023-01-25 09:30:29',10,0),('5','183',257884,'Daily','2023-01-25','2023-01-25 09:35:50','2023-01-26 09:35:50','638',0.00,0.00,'638','2023-01-26 08:40:00','1013','2023-01-26 09:37:30',10,0),('5','183',257885,'Daily','2023-01-26','2023-01-26 10:05:03','2023-01-27 10:05:03','638',2032661.40,2032661.40,'638','2023-01-27 07:21:58','1013','2023-01-27 09:54:21',10,0),('5','183',257886,'Daily','2023-01-27','2023-01-27 10:24:50','2023-01-28 10:24:50','638',937332.00,937332.00,'638','2023-01-28 07:55:42','1013','2023-01-28 10:03:50',10,0),('5','183',257887,'Daily','2023-01-28','2023-01-28 18:49:57','2023-01-29 18:49:57','638',0.00,0.00,'638','2023-01-28 23:49:40','1013','2023-01-29 10:00:37',10,0),('5','183',257888,'Daily','2023-01-29','2023-01-30 07:28:18','2023-01-31 07:28:18','638',0.00,0.00,'638','2023-01-30 07:28:51','1013','2023-01-30 09:51:01',10,0),('5','183',257889,'Daily','2023-01-30','2023-01-30 12:56:23','2023-01-31 12:56:23','638',0.00,0.00,'638','2023-01-31 09:16:33','1013','2023-02-01 09:22:35',10,0),('5','183',257890,'Daily','2023-01-31','2023-02-01 14:02:47','2023-02-02 14:02:47','638',0.00,0.00,'638','2023-02-01 16:16:44','1013','2023-02-02 09:50:04',10,0),('5','183',257891,'Daily','2023-02-03','2023-02-03 07:41:33','2023-02-04 07:41:33','638',2684565.40,2684565.40,'638','2023-02-04 06:50:03','1013','2023-02-04 12:58:19',10,0),('5','183',257892,'Daily','2023-02-04','2023-02-04 16:42:40','2023-02-05 16:42:40','638',2265434.60,2265434.60,'638','2023-02-05 08:07:13','1013','2023-02-05 16:21:10',10,0),('5','183',257893,'Daily','2023-02-05','2023-02-05 19:56:42','2023-02-06 19:56:42','638',0.00,0.00,'638','2023-02-06 06:45:01','1013','2023-02-06 09:17:28',10,0),('5','183',257894,'Daily','2023-02-06','2023-02-06 14:49:52','2023-02-07 14:49:52','638',0.00,0.00,'638','2023-02-07 06:34:22','1013','2023-02-07 09:24:00',10,0),('5','183',257895,'Daily','2023-02-07','2023-02-07 13:16:57','2023-02-08 13:16:57','638',0.00,0.00,'638','2023-02-08 08:02:03','1013','2023-02-08 09:36:42',10,0),('5','183',257896,'Daily','2023-02-08','2023-02-08 09:57:05','2023-02-09 09:57:05','638',2588069.00,2588069.00,'638','2023-02-09 11:09:31','1013','2023-02-09 12:07:25',10,0),('5','183',257897,'Daily','2023-02-09','2023-02-10 06:24:07','2023-02-11 06:24:07','638',711931.00,711931.00,'638','2023-02-10 07:51:50','1013','2023-02-10 09:11:27',10,0),('5','183',257898,'Daily','2023-02-10','2023-02-11 07:41:09','2023-02-12 07:41:09','638',1398738.00,1398738.00,'638','2023-02-11 07:50:42','1013','2023-02-11 13:09:12',10,0),('5','183',257899,'Daily','2023-02-11','2023-02-12 08:03:59','2023-02-13 08:03:59','638',2092602.60,2092602.60,'638','2023-02-12 08:10:15','1013','2023-02-12 12:48:08',10,0),('5','183',257900,'Daily','2023-02-12','2023-02-13 07:39:11','2023-02-14 07:39:11','638',600659.40,600659.40,'638','2023-02-13 07:44:08','1013','2023-02-13 09:21:00',10,0),('5','183',257901,'Daily','2023-02-13','2023-02-13 11:43:58','2023-02-14 11:43:58','638',0.00,0.00,'638','2023-02-14 10:52:58','1013','2023-02-14 11:02:25',10,0),('5','183',257902,'Daily','2023-02-14','2023-02-14 19:49:54','2023-02-15 19:49:54','638',0.00,0.00,'638','2023-02-14 22:59:20','1013','2023-02-15 13:22:27',10,0),('5','183',257903,'Daily','2023-02-15','2023-02-15 14:11:40','2023-02-16 14:11:40','638',0.00,0.00,'638','2023-02-16 19:10:00','1013','2023-02-17 09:19:15',10,0),('5','183',257904,'Daily','2023-02-17','2023-02-17 12:06:19','2023-02-18 12:06:19','638',0.00,0.00,'638','2023-02-19 19:15:53','1013','2023-02-19 19:21:19',10,0),('5','183',257905,'Daily','2023-02-18','2023-02-22 10:35:42','2023-02-23 10:35:42','638',0.00,0.00,'638','2023-02-22 10:36:03','1013','2023-02-22 10:37:02',10,0),('5','183',257906,'Daily','2023-02-19','2023-02-22 11:28:24','2023-02-23 11:28:24','638',0.00,0.00,'638','2023-02-22 11:29:09','1013','2023-02-22 11:30:54',10,0),('5','183',257907,'Daily','2023-02-20','2023-02-22 11:44:12','2023-02-23 11:44:12','638',0.00,0.00,'638','2023-02-22 11:45:15','1013','2023-02-23 19:53:37',10,0),('5','183',257908,'Daily','2023-02-21','2023-02-23 22:32:33','2023-02-24 22:32:33','638',0.00,0.00,'638','2023-02-23 22:33:26','1013','2023-02-24 10:50:35',10,0),('5','183',257909,'Daily','2023-02-22','2023-02-24 11:25:29','2023-02-25 11:25:29','638',0.00,0.00,'638','2023-02-24 11:25:59','1013','2023-02-25 09:30:23',10,0),('5','183',257910,'Daily','2023-02-24','2023-02-25 21:06:08','2023-02-26 21:06:08','638',899829.00,942678.00,'638','2023-02-26 18:33:18','1013','2023-02-26 20:43:45',10,0),('5','183',257911,'Daily','2023-02-26','2023-02-26 21:41:05','2023-02-27 21:41:05','638',2122776.60,2122776.60,'638','2023-02-26 23:00:59','1013','2023-02-27 08:38:45',10,0),('5','183',257912,'Daily','2023-02-27','2023-02-27 08:53:19','2023-02-28 08:53:19','638',2169209.70,2169209.70,'638','2023-02-28 07:31:10','1013','2023-02-28 09:21:16',10,0),('5','183',257913,'Daily','2023-02-28','2023-02-28 11:49:29','2023-03-01 11:49:29','638',2857325.10,2857325.10,'638','2023-03-01 07:19:32','1013','2023-03-01 08:58:43',10,0),('5','183',257914,'Daily','2023-03-01','2023-03-02 08:47:19','2023-03-03 08:47:19','638',2497128.90,2497128.90,'638','2023-03-02 09:00:36','1013','2023-03-02 11:32:52',10,0),('5','183',257915,'Daily','2023-03-02','2023-03-03 06:54:35','2023-03-04 06:54:35','638',2237722.20,2237722.20,'638','2023-03-03 07:28:26','1013','2023-03-03 09:41:36',10,0),('5','183',257916,'Daily','2023-03-03','2023-03-03 10:43:35','2023-03-04 10:43:35','638',2298042.60,2298042.60,'638','2023-03-05 09:46:24','1013','2023-03-05 18:21:52',10,0),('5','183',257917,'Daily','2023-03-04','2023-03-06 00:32:31','2023-03-07 00:32:31','638',2848196.40,2848196.40,'638','2023-03-06 00:43:03','1013','2023-03-06 08:52:54',10,0),('5','183',257918,'Daily','2023-03-05','2023-03-06 12:13:41','2023-03-07 12:13:41','638',2784224.10,2784224.10,'638','2023-03-06 12:24:53','1013','2023-03-06 12:29:21',10,0),('5','183',257919,'Daily','2023-03-06','2023-03-07 08:05:10','2023-03-08 08:05:10','638',2843364.30,2843364.30,'638','2023-03-07 08:14:26','1013','2023-03-07 09:15:44',10,0),('5','183',257920,'Daily','2023-03-07','2023-03-07 10:42:36','2023-03-08 10:42:36','638',1316498.40,1316498.40,'638','2023-03-08 07:38:45','1013','2023-03-08 09:27:23',10,0),('5','183',257921,'Daily','2023-03-08','2023-03-08 12:57:29','2023-03-09 12:57:29','638',2987838.00,2987838.00,'638','2023-03-09 07:41:13','1013','2023-03-09 09:34:47',10,0),('5','183',257922,'Daily','2023-03-09','2023-03-10 08:47:57','2023-03-11 08:47:57','638',3046043.70,3046043.70,'638','2023-03-10 08:57:07','1013','2023-03-10 09:44:38',10,0),('5','183',257923,'Daily','2023-03-10','2023-03-12 07:18:55','2023-03-13 07:18:55','638',2312786.70,2312786.70,'638','2023-03-12 07:23:13','1013','2023-03-12 12:57:44',10,0),('5','183',257924,'Daily','2023-03-11','2023-03-12 19:08:40','2023-03-13 19:08:40','638',441909.30,441909.30,'638','2023-03-13 07:00:09','1013','2023-03-13 09:24:02',10,0),('5','183',257925,'Daily','2023-03-12','2023-03-13 10:34:13','2023-03-14 10:34:13','638',0.00,0.00,'638','2023-03-14 08:14:45','1013','2023-03-14 11:32:19',10,0),('5','183',257926,'Daily','2023-03-15','2023-03-15 12:57:05','2023-03-16 12:57:05','638',0.00,0.00,'638','2023-03-15 21:51:37','1013','2023-03-16 16:39:05',10,0),('5','183',257927,'Daily','2023-03-16','2023-03-16 23:29:45','2023-03-17 23:29:45','638',0.00,0.00,'638','2023-03-16 23:30:29','1013','2023-03-17 10:11:42',10,0),('5','183',257928,'Daily','2023-03-17','2023-03-19 06:44:15','2023-03-20 06:44:15','638',0.00,0.00,'638','2023-03-19 06:44:40','1013','2023-03-19 21:23:56',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907104 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','183','949','213186',4129011,'2829','423',558168.84,560100.47,1931.63,312924.06,0.00,0.00,0.00,0.00,0.00),('5','183','949','213186',4129012,'2830','423',300072.68,300072.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213186',4129013,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213186',4129014,'2832','423',135805.69,135805.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213186',4129015,'2833','423',452831.65,453654.12,822.47,133240.14,0.00,0.00,0.00,0.00,0.00),('5','183','950','213186',4129016,'2834','423',471563.66,473855.29,2291.63,371244.06,0.00,0.00,0.00,0.00,0.00),('5','183','951','213186',4129017,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213186',4129018,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213196',4129196,'2829','423',560100.47,562629.66,2529.19,409728.78,0.00,0.00,0.00,0.00,0.00),('5','183','949','213196',4129197,'2830','423',300072.68,300592.27,519.59,84173.58,0.00,0.00,0.00,0.00,0.00),('5','183','949','213196',4129198,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213196',4129199,'2832','423',135805.69,136083.62,277.93,45024.66,0.00,0.00,0.00,0.00,0.00),('5','183','950','213196',4129200,'2833','423',453654.12,454169.98,515.86,83569.32,0.00,0.00,0.00,0.00,0.00),('5','183','950','213196',4129201,'2834','423',473855.29,476047.79,2192.50,355185.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','213196',4129202,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213196',4129203,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213211',4129447,'2829','423',562629.66,564759.16,2129.50,344979.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213211',4129448,'2830','423',300592.27,300592.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213211',4129449,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213211',4129450,'2832','423',136083.62,138268.93,2185.31,354020.22,0.00,0.00,0.00,0.00,0.00),('5','183','950','213211',4129451,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213211',4129452,'2834','423',476047.79,477250.50,1202.71,194839.02,0.00,0.00,0.00,0.00,0.00),('5','183','951','213211',4129453,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213211',4129454,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213222',4129636,'2829','423',564759.16,566262.49,1503.33,243539.46,0.00,0.00,0.00,0.00,0.00),('5','183','949','213222',4129637,'2830','423',300592.27,300592.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213222',4129638,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213222',4129639,'2832','423',138268.93,139112.82,843.89,136710.18,0.00,0.00,0.00,0.00,0.00),('5','183','950','213222',4129640,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213222',4129641,'2834','423',477250.50,478858.02,1607.52,260418.24,0.00,0.00,0.00,0.00,0.00),('5','183','951','213222',4129642,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213222',4129643,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213550',4135019,'2829','423',566262.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213550',4135020,'2830','423',300592.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213550',4135021,'2831','423',4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213550',4135022,'2832','423',139112.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213550',4135023,'2833','423',454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213550',4135024,'2834','423',478858.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','213550',4135025,'2835','424',235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213550',4135026,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213559',4135141,'2829','423',566262.49,568162.52,1900.03,307804.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','213559',4135142,'2830','423',300592.27,300592.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213559',4135143,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213559',4135144,'2832','423',139112.82,141410.60,2297.78,372240.36,0.00,0.00,0.00,0.00,0.00),('5','183','950','213559',4135145,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213559',4135146,'2834','423',478858.02,479790.98,932.96,151139.52,0.00,0.00,0.00,0.00,0.00),('5','183','951','213559',4135147,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213559',4135148,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213561',4135171,'2829','423',568162.52,570211.92,2049.40,332002.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','213561',4135172,'2830','423',300592.27,300592.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','213561',4135173,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213561',4135174,'2832','423',141410.60,143724.64,2314.04,374874.48,0.00,0.00,0.00,0.00,0.00),('5','183','950','213561',4135175,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','213561',4135176,'2834','423',479790.98,480881.10,1090.12,176599.44,0.00,0.00,0.00,0.00,0.00),('5','183','951','213561',4135177,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','213561',4135178,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214867',4157421,'2829','423',570211.92,572718.98,2507.06,406143.72,0.00,0.00,0.00,0.00,0.00),('5','183','949','214867',4157422,'2830','423',300592.27,301230.19,637.92,103343.04,0.00,0.00,0.00,0.00,0.00),('5','183','949','214867',4157423,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214867',4157424,'2832','423',143724.64,145766.19,2041.55,330731.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','214867',4157425,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214867',4157426,'2834','423',480881.10,480881.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','214867',4157427,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214867',4157428,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214872',4157480,'2829','423',572718.98,575020.65,2301.67,372870.54,0.00,0.00,0.00,0.00,0.00),('5','183','949','214872',4157481,'2830','423',301230.19,302149.50,919.31,148928.22,0.00,0.00,0.00,0.00,0.00),('5','183','949','214872',4157482,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214872',4157483,'2832','423',145766.19,148031.34,2265.15,366954.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','214872',4157484,'2833','423',454169.98,454169.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214872',4157485,'2834','423',480881.10,480881.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','214872',4157486,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214872',4157487,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214877',4157548,'2829','423',575020.65,575020.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214877',4157549,'2830','423',302149.50,303209.24,1059.74,171677.88,0.00,0.00,0.00,0.00,0.00),('5','183','949','214877',4157550,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214877',4157551,'2832','423',148031.34,150428.92,2397.58,388407.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','214877',4157552,'2833','423',454169.98,454262.86,92.88,15046.56,0.00,0.00,0.00,0.00,0.00),('5','183','950','214877',4157553,'2834','423',480881.10,482120.94,1239.84,200854.08,0.00,0.00,0.00,0.00,0.00),('5','183','951','214877',4157554,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214877',4157555,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214880',4157592,'2829','423',575020.65,575020.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214880',4157593,'2830','423',303209.24,303743.50,534.26,86550.12,0.00,0.00,0.00,0.00,0.00),('5','183','949','214880',4157594,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214880',4157595,'2832','423',150428.92,152789.44,2360.52,382404.24,0.00,0.00,0.00,0.00,0.00),('5','183','950','214880',4157596,'2833','423',454262.86,454262.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214880',4157597,'2834','423',482120.94,483813.27,1692.33,274157.46,0.00,0.00,0.00,0.00,0.00),('5','183','951','214880',4157598,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214880',4157599,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214888',4157707,'2829','423',575020.65,575020.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214888',4157708,'2830','423',303743.50,304672.38,928.88,150478.56,0.00,0.00,0.00,0.00,0.00),('5','183','949','214888',4157709,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214888',4157710,'2832','423',152789.44,154765.02,1975.58,320043.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','214888',4157711,'2833','423',454262.86,454796.09,533.23,86383.26,0.00,0.00,0.00,0.00,0.00),('5','183','950','214888',4157712,'2834','423',483813.27,485062.00,1248.73,202294.26,0.00,0.00,0.00,0.00,0.00),('5','183','951','214888',4157713,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214888',4157714,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214891',4157732,'2829','423',575020.65,575020.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','214891',4157733,'2830','423',304672.38,306124.99,1452.61,235322.82,0.00,0.00,0.00,0.00,0.00),('5','183','949','214891',4157734,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','214891',4157735,'2832','423',154765.02,155511.45,746.43,120921.66,0.00,0.00,0.00,0.00,0.00),('5','183','950','214891',4157736,'2833','423',454796.09,455254.82,458.73,74314.26,0.00,0.00,0.00,0.00,0.00),('5','183','950','214891',4157737,'2834','423',485062.00,485109.05,47.05,7622.10,0.00,0.00,0.00,0.00,0.00),('5','183','951','214891',4157738,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','214891',4157739,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216433',4184116,'2829','423',575020.65,575525.77,505.12,81829.44,0.00,0.00,0.00,0.00,0.00),('5','183','949','216433',4184117,'2830','423',306124.99,307183.59,1058.60,171493.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','216433',4184118,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216433',4184119,'2832','423',155511.45,157001.03,1489.58,241311.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','216433',4184120,'2833','423',455254.82,456632.19,1377.37,223133.94,0.00,0.00,0.00,0.00,0.00),('5','183','950','216433',4184121,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216433',4184122,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','216433',4184123,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216438',4184219,'2829','423',575525.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216438',4184220,'2830','423',307183.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216438',4184221,'2831','423',4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216438',4184222,'2832','423',157001.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216438',4184223,'2833','423',456632.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216438',4184224,'2834','423',485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216438',4184225,'2835','424',235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','216438',4184226,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216440',4184240,'2829','423',575525.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216440',4184241,'2830','423',307183.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216440',4184242,'2831','423',4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216440',4184243,'2832','423',157001.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216440',4184244,'2833','423',456632.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216440',4184245,'2834','423',485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216440',4184246,'2835','424',235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','216440',4184247,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216448',4184386,'2829','423',575525.77,575525.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216448',4184387,'2830','423',307183.59,308415.84,1232.25,199624.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','216448',4184388,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216448',4184389,'2832','423',157001.03,158887.75,1886.72,305648.64,0.00,0.00,0.00,0.00,0.00),('5','183','950','216448',4184390,'2833','423',456632.19,457384.26,752.07,121835.34,0.00,0.00,0.00,0.00,0.00),('5','183','950','216448',4184391,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216448',4184392,'2835','424',235028.15,235028.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','216448',4184393,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216453',4184454,'2829','423',575525.77,578825.28,3299.51,534520.62,0.00,0.00,0.00,0.00,0.00),('5','183','949','216453',4184455,'2830','423',308415.84,308415.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216453',4184456,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216453',4184457,'2832','423',158887.75,160556.28,1668.53,270301.86,0.00,0.00,0.00,0.00,0.00),('5','183','950','216453',4184458,'2833','423',457384.26,458040.59,656.33,106325.46,0.00,0.00,0.00,0.00,0.00),('5','183','950','216453',4184459,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216453',4184460,'2835','424',235028.15,235876.75,848.60,250337.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','216453',4184461,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216523',4185854,'2829','423',578825.28,580807.39,1982.11,321101.82,0.00,0.00,0.00,0.00,0.00),('5','183','949','216523',4185855,'2830','423',308415.84,310505.02,2089.18,338447.16,0.00,0.00,0.00,0.00,0.00),('5','183','949','216523',4185856,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216523',4185857,'2832','423',160556.28,162735.30,2179.02,353001.24,0.00,0.00,0.00,0.00,0.00),('5','183','950','216523',4185858,'2833','423',458040.59,458040.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216523',4185859,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216523',4185860,'2835','424',235876.75,236063.25,186.50,55017.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','216523',4185861,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216841',4191249,'2829','423',580807.39,581815.05,1007.66,163240.92,0.00,0.00,0.00,0.00,0.00),('5','183','949','216841',4191250,'2830','423',310505.02,310505.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216841',4191251,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216841',4191252,'2832','423',162735.30,164655.82,1920.52,311124.24,0.00,0.00,0.00,0.00,0.00),('5','183','950','216841',4191253,'2833','423',458040.59,458966.50,925.91,149997.42,0.00,0.00,0.00,0.00,0.00),('5','183','950','216841',4191254,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216841',4191255,'2835','424',236063.25,236150.99,87.74,25883.30,0.00,0.00,0.00,0.00,0.00),('5','183','952','216841',4191256,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216860',4191626,'2829','423',581815.05,581815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216860',4191627,'2830','423',310505.02,310505.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216860',4191628,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216860',4191629,'2832','423',164655.82,167266.05,2610.23,422857.26,0.00,0.00,0.00,0.00,0.00),('5','183','950','216860',4191630,'2833','423',458966.50,461720.38,2753.88,446128.56,0.00,0.00,0.00,0.00,0.00),('5','183','950','216860',4191631,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216860',4191632,'2835','424',236150.99,236279.18,128.19,37816.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','216860',4191633,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216932',4192920,'2829','423',581815.05,581815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216932',4192921,'2830','423',310505.02,310505.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216932',4192922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216932',4192923,'2832','423',167266.05,169737.63,2471.58,400395.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','216932',4192924,'2833','423',461720.38,463712.68,1992.30,322752.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','216932',4192925,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216932',4192926,'2835','424',236279.18,236504.10,224.92,66351.40,0.00,0.00,0.00,0.00,0.00),('5','183','952','216932',4192927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','216939',4193050,'2829','423',581815.05,582781.85,966.80,156621.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','216939',4193051,'2830','423',310505.02,311569.25,1064.23,172405.26,0.00,0.00,0.00,0.00,0.00),('5','183','949','216939',4193052,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','216939',4193053,'2832','423',169737.63,171426.76,1689.13,273639.06,0.00,0.00,0.00,0.00,0.00),('5','183','950','216939',4193054,'2833','423',463712.68,464515.41,802.73,130042.26,0.00,0.00,0.00,0.00,0.00),('5','183','950','216939',4193055,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','216939',4193056,'2835','424',236504.10,236684.07,179.97,53091.15,0.00,0.00,0.00,0.00,0.00),('5','183','952','216939',4193057,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217029',4194559,'2829','423',582781.85,583966.37,1184.52,191892.24,0.00,0.00,0.00,0.00,0.00),('5','183','949','217029',4194560,'2830','423',311569.25,312376.27,807.02,130737.24,0.00,0.00,0.00,0.00,0.00),('5','183','949','217029',4194561,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217029',4194562,'2832','423',171426.76,172278.97,852.21,138058.02,0.00,0.00,0.00,0.00,0.00),('5','183','950','217029',4194563,'2833','423',464515.41,466483.15,1967.74,318773.88,0.00,0.00,0.00,0.00,0.00),('5','183','950','217029',4194564,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217029',4194565,'2835','424',236684.07,236897.36,213.29,62920.55,0.00,0.00,0.00,0.00,0.00),('5','183','952','217029',4194566,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217488',4203017,'2829','423',583966.37,585588.95,1622.58,262857.96,0.00,0.00,0.00,0.00,0.00),('5','183','949','217488',4203018,'2830','423',312376.27,312376.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217488',4203019,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217488',4203020,'2832','423',172278.97,174160.83,1881.86,304861.32,0.00,0.00,0.00,0.00,0.00),('5','183','950','217488',4203021,'2833','423',466483.15,468371.69,1888.54,305943.48,0.00,0.00,0.00,0.00,0.00),('5','183','950','217488',4203022,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217488',4203023,'2835','424',236897.36,237088.96,191.60,56522.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','217488',4203024,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217682',4206372,'2829','423',585588.95,587047.11,1458.16,236221.92,0.00,0.00,0.00,0.00,0.00),('5','183','949','217682',4206373,'2830','423',312376.27,312376.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217682',4206374,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217682',4206375,'2832','423',174160.83,176057.76,1896.93,307302.66,0.00,0.00,0.00,0.00,0.00),('5','183','950','217682',4206376,'2833','423',468371.69,470200.86,1829.17,296325.54,0.00,0.00,0.00,0.00,0.00),('5','183','950','217682',4206377,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217682',4206378,'2835','424',237088.96,237587.58,498.62,147092.90,0.00,0.00,0.00,0.00,0.00),('5','183','952','217682',4206379,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217933',4211004,'2829','423',587047.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217933',4211005,'2830','423',312376.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217933',4211006,'2831','423',4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217933',4211007,'2832','423',176057.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217933',4211008,'2833','423',470200.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217933',4211009,'2834','423',485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217933',4211010,'2835','424',237587.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','217933',4211011,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217939',4211105,'2829','423',587047.11,588318.24,1271.13,205923.06,0.00,0.00,0.00,0.00,0.00),('5','183','949','217939',4211106,'2830','423',312376.27,313116.25,739.98,119876.76,0.00,0.00,0.00,0.00,0.00),('5','183','949','217939',4211107,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217939',4211108,'2832','423',176057.76,176783.84,726.08,117624.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','217939',4211109,'2833','423',470200.86,471824.19,1623.33,262979.46,0.00,0.00,0.00,0.00,0.00),('5','183','950','217939',4211110,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217939',4211111,'2835','424',237587.58,237772.68,185.10,54604.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','217939',4211112,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','217963',4211528,'2829','423',588318.24,589889.58,1571.34,254557.08,0.00,0.00,0.00,0.00,0.00),('5','183','949','217963',4211529,'2830','423',313116.25,315023.73,1907.48,309011.76,0.00,0.00,0.00,0.00,0.00),('5','183','949','217963',4211530,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','217963',4211531,'2832','423',176783.84,178610.06,1826.22,295847.64,0.00,0.00,0.00,0.00,0.00),('5','183','950','217963',4211532,'2833','423',471824.19,472540.98,716.79,116119.98,0.00,0.00,0.00,0.00,0.00),('5','183','950','217963',4211533,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','217963',4211534,'2835','424',237772.68,238031.44,258.76,76334.20,0.00,0.00,0.00,0.00,0.00),('5','183','952','217963',4211535,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','218167',4214917,'2829','423',589889.58,591958.73,2069.15,335202.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','218167',4214918,'2830','423',315023.73,316130.06,1106.33,179225.46,0.00,0.00,0.00,0.00,0.00),('5','183','949','218167',4214919,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218167',4214920,'2832','423',178610.06,179622.53,1012.47,164020.14,0.00,0.00,0.00,0.00,0.00),('5','183','950','218167',4214921,'2833','423',472540.98,472540.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218167',4214922,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','218167',4214923,'2835','424',238031.44,238234.21,202.77,59817.15,0.00,0.00,0.00,0.00,0.00),('5','183','952','218167',4214924,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','218303',4217149,'2829','423',591958.73,594450.69,2491.96,403697.52,0.00,0.00,0.00,0.00,0.00),('5','183','949','218303',4217150,'2830','423',316130.06,318260.12,2130.06,345069.72,0.00,0.00,0.00,0.00,0.00),('5','183','949','218303',4217151,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218303',4217152,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218303',4217153,'2833','423',472540.98,472540.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218303',4217154,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','218303',4217155,'2835','424',238234.21,238365.56,131.35,38748.25,0.00,0.00,0.00,0.00,0.00),('5','183','952','218303',4217156,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','218661',4223848,'2829','423',594450.69,597510.17,3059.48,495635.76,0.00,0.00,0.00,0.00,0.00),('5','183','949','218661',4223849,'2830','423',318260.12,320334.74,2074.62,336088.44,0.00,0.00,0.00,0.00,0.00),('5','183','949','218661',4223850,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218661',4223851,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218661',4223852,'2833','423',472540.98,472540.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218661',4223853,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','218661',4223854,'2835','424',238365.56,238560.36,194.80,57466.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','218661',4223855,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','218772',4225446,'2829','423',597510.17,598549.05,1038.88,168298.56,0.00,0.00,0.00,0.00,0.00),('5','183','949','218772',4225447,'2830','423',320334.74,321373.77,1039.03,168322.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','218772',4225448,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218772',4225449,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218772',4225450,'2833','423',472540.98,472540.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','218772',4225451,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','218772',4225452,'2835','424',238560.36,239160.36,600.00,177000.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','218772',4225453,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','219102',4231423,'2829','423',598549.05,600032.12,1483.07,240257.34,0.00,0.00,0.00,0.00,0.00),('5','183','949','219102',4231424,'2830','423',321373.77,322815.52,1441.75,233563.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','219102',4231425,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219102',4231426,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219102',4231427,'2833','423',472540.98,474874.10,2333.12,377965.44,0.00,0.00,0.00,0.00,0.00),('5','183','950','219102',4231428,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','219102',4231429,'2835','424',239160.36,239933.86,773.50,228182.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','219102',4231430,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','219318',4235200,'2829','423',600032.12,601553.33,1521.21,246436.02,0.00,0.00,0.00,0.00,0.00),('5','183','949','219318',4235201,'2830','423',322815.52,324133.67,1318.15,213540.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','219318',4235202,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219318',4235203,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219318',4235204,'2833','423',474874.10,477203.27,2329.17,377325.54,0.00,0.00,0.00,0.00,0.00),('5','183','950','219318',4235205,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','219318',4235206,'2835','424',239933.86,240302.15,368.29,108645.55,0.00,0.00,0.00,0.00,0.00),('5','183','952','219318',4235207,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','219437',4236964,'2829','423',601553.33,603445.28,1891.95,306495.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','219437',4236965,'2830','423',324133.67,325458.59,1324.92,214637.04,0.00,0.00,0.00,0.00,0.00),('5','183','949','219437',4236966,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219437',4236967,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219437',4236968,'2833','423',477203.27,479089.45,1886.18,305561.16,0.00,0.00,0.00,0.00,0.00),('5','183','950','219437',4236969,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','219437',4236970,'2835','424',240302.15,240483.27,181.12,53430.40,0.00,0.00,0.00,0.00,0.00),('5','183','952','219437',4236971,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','219597',4239818,'2829','423',603445.28,605027.02,1581.74,256241.88,0.00,0.00,0.00,0.00,0.00),('5','183','949','219597',4239819,'2830','423',325458.59,326658.51,1199.92,194387.04,0.00,0.00,0.00,0.00,0.00),('5','183','949','219597',4239820,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219597',4239821,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219597',4239822,'2833','423',479089.45,481071.01,1981.56,321012.72,0.00,0.00,0.00,0.00,0.00),('5','183','950','219597',4239823,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','219597',4239824,'2835','424',240483.27,240746.39,263.12,77620.40,0.00,0.00,0.00,0.00,0.00),('5','183','952','219597',4239825,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','219825',4243812,'2829','423',605027.02,606764.29,1737.27,281437.74,0.00,0.00,0.00,0.00,0.00),('5','183','949','219825',4243813,'2830','423',326658.51,328076.38,1417.87,229694.94,0.00,0.00,0.00,0.00,0.00),('5','183','949','219825',4243814,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219825',4243815,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','219825',4243816,'2833','423',481071.01,482799.73,1728.72,280052.64,0.00,0.00,0.00,0.00,0.00),('5','183','950','219825',4243817,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','219825',4243818,'2835','424',240746.39,241995.20,1248.81,368398.95,0.00,0.00,0.00,0.00,0.00),('5','183','952','219825',4243819,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','220143',4249613,'2829','423',606764.29,608170.87,1406.58,227865.96,0.00,0.00,0.00,0.00,0.00),('5','183','949','220143',4249614,'2830','423',328076.38,329232.18,1155.80,187239.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','220143',4249615,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','220143',4249616,'2832','423',179622.53,179622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','220143',4249617,'2833','423',482799.73,484886.35,2086.62,338032.44,0.00,0.00,0.00,0.00,0.00),('5','183','950','220143',4249618,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','220143',4249619,'2835','424',241995.20,242570.90,575.70,169831.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','220143',4249620,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','220481',4255678,'2829','423',608170.87,610090.67,1919.80,311007.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','220481',4255679,'2830','423',329232.18,330759.12,1526.94,247364.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','220481',4255680,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','220481',4255681,'2832','423',179622.53,179663.94,41.41,6708.42,0.00,0.00,0.00,0.00,0.00),('5','183','950','220481',4255682,'2833','423',484886.35,487021.92,2135.57,345962.34,0.00,0.00,0.00,0.00,0.00),('5','183','950','220481',4255683,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','220481',4255684,'2835','424',242570.90,242884.49,313.59,92509.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','220481',4255685,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','220491',4255793,'2829','423',610090.67,611576.61,1485.94,240722.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','220491',4255794,'2830','423',330759.12,332004.99,1245.87,201830.94,0.00,0.00,0.00,0.00,0.00),('5','183','949','220491',4255795,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','220491',4255796,'2832','423',179663.94,181150.72,1486.78,240858.36,0.00,0.00,0.00,0.00,0.00),('5','183','950','220491',4255797,'2833','423',487021.92,487639.41,617.49,100033.38,0.00,0.00,0.00,0.00,0.00),('5','183','950','220491',4255798,'2834','423',485109.05,485109.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','220491',4255799,'2835','424',242884.49,243654.04,769.55,227017.25,0.00,0.00,0.00,0.00,0.00),('5','183','952','220491',4255800,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','220753',4260263,'2829','423',611576.61,613163.93,1587.32,257145.84,0.00,0.00,0.00,0.00,0.00),('5','183','949','220753',4260264,'2830','423',332004.99,332004.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','220753',4260265,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','220753',4260266,'2832','423',181150.72,182907.39,1756.67,284580.54,0.00,0.00,0.00,0.00,0.00),('5','183','950','220753',4260267,'2833','423',487639.41,488307.51,668.10,108232.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','220753',4260268,'2834','423',485109.05,486559.50,1450.45,234972.90,0.00,0.00,0.00,0.00,0.00),('5','183','951','220753',4260269,'2835','424',243654.04,244277.52,623.48,183926.60,0.00,0.00,0.00,0.00,0.00),('5','183','952','220753',4260270,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','221041',4265514,'2829','423',613163.93,614862.46,1698.53,275161.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','221041',4265515,'2830','423',332004.99,332004.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','221041',4265516,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221041',4265517,'2832','423',182907.39,184820.69,1913.30,309954.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','221041',4265518,'2833','423',488307.51,488307.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221041',4265519,'2834','423',486559.50,488051.33,1491.83,241676.46,0.00,0.00,0.00,0.00,0.00),('5','183','951','221041',4265520,'2835','424',244277.52,244552.04,274.52,80983.40,0.00,0.00,0.00,0.00,0.00),('5','183','952','221041',4265521,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','221237',4268858,'2829','423',614862.46,616319.03,1456.57,235964.34,0.00,0.00,0.00,0.00,0.00),('5','183','949','221237',4268859,'2830','423',332004.99,332539.97,534.98,86666.76,0.00,0.00,0.00,0.00,0.00),('5','183','949','221237',4268860,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221237',4268861,'2832','423',184820.69,185816.12,995.43,161259.66,0.00,0.00,0.00,0.00,0.00),('5','183','950','221237',4268862,'2833','423',488307.51,489203.30,895.79,145117.98,0.00,0.00,0.00,0.00,0.00),('5','183','950','221237',4268863,'2834','423',488051.33,489035.69,984.36,159466.32,0.00,0.00,0.00,0.00,0.00),('5','183','951','221237',4268864,'2835','424',244552.04,244732.51,180.47,53238.65,0.00,0.00,0.00,0.00,0.00),('5','183','952','221237',4268865,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','221375',4271692,'2829','423',616319.03,618297.56,1978.53,320521.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','221375',4271693,'2830','423',332539.97,333029.26,489.29,79264.98,0.00,0.00,0.00,0.00,0.00),('5','183','949','221375',4271694,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221375',4271695,'2832','423',185816.12,187899.58,2083.46,337520.52,0.00,0.00,0.00,0.00,0.00),('5','183','950','221375',4271696,'2833','423',489203.30,489203.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221375',4271697,'2834','423',489035.69,489785.35,749.66,121444.92,0.00,0.00,0.00,0.00,0.00),('5','183','951','221375',4271698,'2835','424',244732.51,244995.94,263.43,77711.85,0.00,0.00,0.00,0.00,0.00),('5','183','952','221375',4271699,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','221646',4276385,'2829','423',618297.56,620009.94,1712.38,277405.56,0.00,0.00,0.00,0.00,0.00),('5','183','949','221646',4276386,'2830','423',333029.26,334315.70,1286.44,208403.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','221646',4276387,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','221646',4276388,'2832','423',187899.58,189729.95,1830.37,296519.94,0.00,0.00,0.00,0.00,0.00),('5','183','950','221646',4276389,'2833','423',489203.30,489865.46,662.16,107269.92,0.00,0.00,0.00,0.00,0.00),('5','183','950','221646',4276390,'2834','423',489785.35,489793.66,8.31,1346.22,0.00,0.00,0.00,0.00,0.00),('5','183','951','221646',4276391,'2835','424',244995.94,245568.31,572.37,168849.15,0.00,0.00,0.00,0.00,0.00),('5','183','952','221646',4276392,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','222045',4283891,'2829','423',620009.94,621782.84,1772.90,287209.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','222045',4283892,'2830','423',334315.70,335879.31,1563.61,253304.82,0.00,0.00,0.00,0.00,0.00),('5','183','949','222045',4283893,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222045',4283894,'2832','423',189729.95,190909.67,1179.72,191114.64,0.00,0.00,0.00,0.00,0.00),('5','183','950','222045',4283895,'2833','423',489865.46,490322.96,457.50,74115.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222045',4283896,'2834','423',489793.66,489793.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','222045',4283897,'2835','424',245568.31,245800.04,231.73,68360.35,0.00,0.00,0.00,0.00,0.00),('5','183','952','222045',4283898,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','222266',4287461,'2829','423',621782.84,623162.98,1380.14,223582.68,0.00,0.00,0.00,0.00,0.00),('5','183','949','222266',4287462,'2830','423',335879.31,337227.08,1347.77,218338.74,0.00,0.00,0.00,0.00,0.00),('5','183','949','222266',4287463,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222266',4287464,'2832','423',190909.67,192019.74,1110.07,179831.34,0.00,0.00,0.00,0.00,0.00),('5','183','950','222266',4287465,'2833','423',490322.96,491452.82,1129.86,183037.32,0.00,0.00,0.00,0.00,0.00),('5','183','950','222266',4287466,'2834','423',489793.66,490470.21,676.55,109601.10,0.00,0.00,0.00,0.00,0.00),('5','183','951','222266',4287467,'2835','424',245800.04,246000.72,200.68,59200.60,0.00,0.00,0.00,0.00,0.00),('5','183','952','222266',4287468,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','222479',4291200,'2829','423',623162.98,624056.32,893.34,144721.08,0.00,0.00,0.00,0.00,0.00),('5','183','949','222479',4291201,'2830','423',337227.08,337360.37,133.29,21592.98,0.00,0.00,0.00,0.00,0.00),('5','183','949','222479',4291202,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222479',4291203,'2832','423',192019.74,193615.56,1595.82,258522.84,0.00,0.00,0.00,0.00,0.00),('5','183','950','222479',4291204,'2833','423',491452.82,492960.91,1508.09,244310.58,0.00,0.00,0.00,0.00,0.00),('5','183','950','222479',4291205,'2834','423',490470.21,492296.32,1826.11,295829.82,0.00,0.00,0.00,0.00,0.00),('5','183','951','222479',4291206,'2835','424',246000.72,246866.31,865.59,255349.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','222479',4291207,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','222729',4295740,'2829','423',624056.32,626966.49,2910.17,471447.54,0.00,0.00,0.00,0.00,0.00),('5','183','949','222729',4295741,'2830','423',337360.37,339750.55,2390.18,387209.16,0.00,0.00,0.00,0.00,0.00),('5','183','949','222729',4295742,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222729',4295743,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222729',4295744,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222729',4295745,'2834','423',492296.32,492307.34,11.02,1785.24,0.00,0.00,0.00,0.00,0.00),('5','183','951','222729',4295746,'2835','424',246866.31,247210.76,344.45,101612.75,0.00,0.00,0.00,0.00,0.00),('5','183','952','222729',4295747,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','222746',4295920,'2829','423',626966.49,629083.43,2116.94,342944.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','222746',4295921,'2830','423',339750.55,341303.70,1553.15,251610.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','222746',4295922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222746',4295923,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222746',4295924,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','222746',4295925,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','222746',4295926,'2835','424',247210.76,247456.09,245.33,72372.35,0.00,0.00,0.00,0.00,0.00),('5','183','952','222746',4295927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223182',4303778,'2829','423',629083.43,631593.33,2509.90,406603.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','223182',4303779,'2830','423',341303.70,343744.81,2441.11,395459.82,0.00,0.00,0.00,0.00,0.00),('5','183','949','223182',4303780,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223182',4303781,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223182',4303782,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223182',4303783,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','223182',4303784,'2835','424',247456.09,247649.63,193.54,57094.30,0.00,0.00,0.00,0.00,0.00),('5','183','952','223182',4303785,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223344',4306291,'2829','423',631593.33,634148.83,2555.50,413991.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223344',4306292,'2830','423',343744.81,346207.34,2462.53,398929.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','223344',4306293,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223344',4306294,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223344',4306295,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223344',4306296,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','223344',4306297,'2835','424',247649.63,247828.53,178.90,52775.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','223344',4306298,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223657',4312255,'2829','423',634148.83,635324.85,1176.02,190515.24,0.00,0.00,0.00,0.00,0.00),('5','183','949','223657',4312256,'2830','423',346207.34,347270.02,1062.68,172154.16,0.00,0.00,0.00,0.00,0.00),('5','183','949','223657',4312257,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223657',4312258,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223657',4312259,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223657',4312260,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','223657',4312261,'2835','424',247828.53,248193.44,364.91,107648.45,0.00,0.00,0.00,0.00,0.00),('5','183','952','223657',4312262,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223871',4316387,'2829','423',635324.85,635324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223871',4316388,'2830','423',347270.02,347270.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','223871',4316389,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223871',4316390,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223871',4316391,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','223871',4316392,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','223871',4316393,'2835','424',248193.44,248405.68,212.24,62610.80,0.00,0.00,0.00,0.00,0.00),('5','183','952','223871',4316394,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224081',4319949,'2829','423',635324.85,635324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224081',4319950,'2830','423',347270.02,347270.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224081',4319951,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224081',4319952,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224081',4319953,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224081',4319954,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','224081',4319955,'2835','424',248405.68,248940.07,534.39,157645.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','224081',4319956,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224297',4324012,'2829','423',635324.85,635324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224297',4324013,'2830','423',347270.02,347270.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224297',4324014,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224297',4324015,'2832','423',193615.56,193615.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224297',4324016,'2833','423',492960.91,492960.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224297',4324017,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','224297',4324018,'2835','424',248940.07,249126.07,186.00,54870.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','224297',4324019,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224515',4327803,'2829','423',635324.85,636599.56,1274.71,206503.02,0.00,0.00,0.00,0.00,0.00),('5','183','949','224515',4327804,'2830','423',347270.02,347937.27,667.25,108094.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','224515',4327805,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224515',4327806,'2832','423',193615.56,195077.34,1461.78,236808.36,0.00,0.00,0.00,0.00,0.00),('5','183','950','224515',4327807,'2833','423',492960.91,493953.18,992.27,160747.74,0.00,0.00,0.00,0.00,0.00),('5','183','950','224515',4327808,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','224515',4327809,'2835','424',249126.07,249365.08,239.01,70507.95,0.00,0.00,0.00,0.00,0.00),('5','183','952','224515',4327810,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224759',4332085,'2829','423',636599.56,638207.20,1607.64,260437.68,0.00,0.00,0.00,0.00,0.00),('5','183','949','224759',4332086,'2830','423',347937.27,347937.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224759',4332087,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224759',4332088,'2832','423',195077.34,196870.91,1793.57,290558.34,0.00,0.00,0.00,0.00,0.00),('5','183','950','224759',4332089,'2833','423',493953.18,495172.79,1219.61,197576.82,0.00,0.00,0.00,0.00,0.00),('5','183','950','224759',4332090,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','224759',4332091,'2835','424',249365.08,249609.87,244.79,72213.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','224759',4332092,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','224839',4333161,'2829','423',638207.20,639534.91,1327.71,215089.02,0.00,0.00,0.00,0.00,0.00),('5','183','949','224839',4333162,'2830','423',347937.27,348985.42,1048.15,169800.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','224839',4333163,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','224839',4333164,'2832','423',196870.91,197534.08,663.17,107433.54,0.00,0.00,0.00,0.00,0.00),('5','183','950','224839',4333165,'2833','423',495172.79,496841.38,1668.59,270311.58,0.00,0.00,0.00,0.00,0.00),('5','183','950','224839',4333166,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','224839',4333167,'2835','424',249609.87,249777.81,167.94,49542.30,0.00,0.00,0.00,0.00,0.00),('5','183','952','224839',4333168,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','225195',4339753,'2829','423',639534.91,641273.08,1738.17,281583.54,0.00,0.00,0.00,0.00,0.00),('5','183','949','225195',4339754,'2830','423',348985.42,350785.20,1799.78,291564.36,0.00,0.00,0.00,0.00,0.00),('5','183','949','225195',4339755,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225195',4339756,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225195',4339757,'2833','423',496841.38,498835.35,1993.97,323023.14,0.00,0.00,0.00,0.00,0.00),('5','183','950','225195',4339758,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','225195',4339759,'2835','424',249777.81,249993.64,215.83,63669.85,0.00,0.00,0.00,0.00,0.00),('5','183','952','225195',4339760,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','225433',4344326,'2829','423',641273.08,642955.01,1681.93,272472.66,0.00,0.00,0.00,0.00,0.00),('5','183','949','225433',4344327,'2830','423',350785.20,352405.29,1620.09,262454.58,0.00,0.00,0.00,0.00,0.00),('5','183','949','225433',4344328,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225433',4344329,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225433',4344330,'2833','423',498835.35,500528.71,1693.36,274324.32,0.00,0.00,0.00,0.00,0.00),('5','183','950','225433',4344331,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','225433',4344332,'2835','424',249993.64,250530.54,536.90,158385.50,0.00,0.00,0.00,0.00,0.00),('5','183','952','225433',4344333,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','225669',4348479,'2829','423',642955.01,644613.86,1658.85,268733.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','225669',4348480,'2830','423',352405.29,353672.70,1267.41,205320.42,0.00,0.00,0.00,0.00,0.00),('5','183','949','225669',4348481,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225669',4348482,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225669',4348483,'2833','423',500528.71,502531.39,2002.68,324434.16,0.00,0.00,0.00,0.00,0.00),('5','183','950','225669',4348484,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','225669',4348485,'2835','424',250530.54,250804.94,274.40,80948.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','225669',4348486,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','225921',4352685,'2829','423',644613.86,646448.51,1834.65,297213.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','225921',4352686,'2830','423',353672.70,355353.59,1680.89,272304.18,0.00,0.00,0.00,0.00,0.00),('5','183','949','225921',4352687,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225921',4352688,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','225921',4352689,'2833','423',502531.39,505058.52,2527.13,409395.06,0.00,0.00,0.00,0.00,0.00),('5','183','950','225921',4352690,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','225921',4352691,'2835','424',250804.94,251088.77,283.83,83729.85,0.00,0.00,0.00,0.00,0.00),('5','183','952','225921',4352692,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','226274',4358903,'2829','423',646448.51,648085.18,1636.67,265140.54,0.00,0.00,0.00,0.00,0.00),('5','183','949','226274',4358904,'2830','423',355353.59,356029.06,675.47,109426.14,0.00,0.00,0.00,0.00,0.00),('5','183','949','226274',4358905,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226274',4358906,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226274',4358907,'2833','423',505058.52,506996.06,1937.54,313881.48,0.00,0.00,0.00,0.00,0.00),('5','183','950','226274',4358908,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','226274',4358909,'2835','424',251088.77,251911.79,823.02,242790.90,0.00,0.00,0.00,0.00,0.00),('5','183','952','226274',4358910,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','226287',4359085,'2829','423',648085.18,649738.43,1653.25,267826.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','226287',4359086,'2830','423',356029.06,357470.28,1441.22,233477.64,0.00,0.00,0.00,0.00,0.00),('5','183','949','226287',4359087,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226287',4359088,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226287',4359089,'2833','423',506996.06,509064.53,2068.47,335092.14,0.00,0.00,0.00,0.00,0.00),('5','183','950','226287',4359090,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','226287',4359091,'2835','424',251911.79,252250.18,338.39,99825.05,0.00,0.00,0.00,0.00,0.00),('5','183','952','226287',4359092,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','226521',4363207,'2829','423',649738.43,651366.37,1627.94,263726.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','226521',4363208,'2830','423',357470.28,359050.21,1579.93,255948.66,0.00,0.00,0.00,0.00,0.00),('5','183','949','226521',4363209,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226521',4363210,'2832','423',197534.08,197534.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226521',4363211,'2833','423',509064.53,511121.14,2056.61,333170.82,0.00,0.00,0.00,0.00,0.00),('5','183','950','226521',4363212,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','226521',4363213,'2835','424',252250.18,252595.95,345.77,102002.15,0.00,0.00,0.00,0.00,0.00),('5','183','952','226521',4363214,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','226791',4368118,'2829','423',651366.37,653111.48,1745.11,282707.82,0.00,0.00,0.00,0.00,0.00),('5','183','949','226791',4368119,'2830','423',359050.21,360638.38,1588.17,257283.54,0.00,0.00,0.00,0.00,0.00),('5','183','949','226791',4368120,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226791',4368121,'2832','423',197534.08,198304.48,770.40,124804.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','226791',4368122,'2833','423',511121.14,511968.93,847.79,137341.98,0.00,0.00,0.00,0.00,0.00),('5','183','950','226791',4368123,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','226791',4368124,'2835','424',252595.95,252894.75,298.80,88146.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','226791',4368125,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','226951',4371230,'2829','423',653111.48,654609.10,1497.62,242614.44,0.00,0.00,0.00,0.00,0.00),('5','183','949','226951',4371231,'2830','423',360638.38,360718.32,79.94,12950.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','226951',4371232,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','226951',4371233,'2832','423',198304.48,200204.12,1899.64,307741.68,0.00,0.00,0.00,0.00,0.00),('5','183','950','226951',4371234,'2833','423',511968.93,513711.40,1742.47,282280.14,0.00,0.00,0.00,0.00,0.00),('5','183','950','226951',4371235,'2834','423',492307.34,492307.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','226951',4371236,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','226951',4371237,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227222',4375649,'2829','423',654609.10,656181.57,1572.47,254740.14,0.00,0.00,0.00,0.00,0.00),('5','183','949','227222',4375650,'2830','423',360718.32,360718.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227222',4375651,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227222',4375652,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227222',4375653,'2833','423',513711.40,515907.32,2195.92,355739.04,0.00,0.00,0.00,0.00,0.00),('5','183','950','227222',4375654,'2834','423',492307.34,493985.88,1678.54,271923.48,0.00,0.00,0.00,0.00,0.00),('5','183','951','227222',4375655,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','227222',4375656,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227384',4378668,'2829','423',656181.57,657917.84,1736.27,281275.74,0.00,0.00,0.00,0.00,0.00),('5','183','949','227384',4378669,'2830','423',360718.32,360718.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227384',4378670,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227384',4378671,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227384',4378672,'2833','423',515907.32,517938.67,2031.35,329078.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','227384',4378673,'2834','423',493985.88,495374.53,1388.65,224961.30,0.00,0.00,0.00,0.00,0.00),('5','183','951','227384',4378674,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','227384',4378675,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227706',4384299,'2829','423',657917.84,659694.06,1776.22,287747.64,0.00,0.00,0.00,0.00,0.00),('5','183','949','227706',4384300,'2830','423',360718.32,360718.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227706',4384301,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227706',4384302,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227706',4384303,'2833','423',517938.67,520204.18,2265.51,367012.62,0.00,0.00,0.00,0.00,0.00),('5','183','950','227706',4384304,'2834','423',495374.53,497244.58,1870.05,302948.10,0.00,0.00,0.00,0.00,0.00),('5','183','951','227706',4384305,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','227706',4384306,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','227903',4387797,'2829','423',659694.06,661360.40,1666.34,269947.08,0.00,0.00,0.00,0.00,0.00),('5','183','949','227903',4387798,'2830','423',360718.32,361546.68,828.36,134194.32,0.00,0.00,0.00,0.00,0.00),('5','183','949','227903',4387799,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227903',4387800,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','227903',4387801,'2833','423',520204.18,521293.74,1089.56,176508.72,0.00,0.00,0.00,0.00,0.00),('5','183','950','227903',4387802,'2834','423',497244.58,499137.78,1893.20,306698.40,0.00,0.00,0.00,0.00,0.00),('5','183','951','227903',4387803,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','227903',4387804,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','232977',4480633,'2829','423',661698.04,662980.07,1282.03,207688.86,0.00,0.00,0.00,0.00,0.00),('5','183','949','232977',4480634,'2830','423',361546.68,363661.57,2114.89,342612.18,0.00,0.00,0.00,0.00,0.00),('5','183','949','232977',4480635,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','232977',4480636,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','232977',4480637,'2833','423',522056.67,522394.33,337.66,54700.92,0.00,0.00,0.00,0.00,0.00),('5','183','950','232977',4480638,'2834','423',499137.78,501294.24,2156.46,349346.52,0.00,0.00,0.00,0.00,0.00),('5','183','951','232977',4480639,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','232977',4480640,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233176',4484176,'2829','423',662980.07,665684.73,2704.66,438154.92,0.00,0.00,0.00,0.00,0.00),('5','183','949','233176',4484177,'2830','423',363661.57,365553.36,1891.79,306469.98,0.00,0.00,0.00,0.00,0.00),('5','183','949','233176',4484178,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233176',4484179,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233176',4484180,'2833','423',522394.33,522447.38,53.05,8594.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','233176',4484181,'2834','423',501294.24,503583.34,2289.10,370834.20,0.00,0.00,0.00,0.00,0.00),('5','183','951','233176',4484182,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233176',4484183,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233186',4484316,'2829','423',665684.73,668064.18,2379.45,385470.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','233186',4484317,'2830','423',365553.36,367389.13,1835.77,297394.74,0.00,0.00,0.00,0.00,0.00),('5','183','949','233186',4484318,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233186',4484319,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233186',4484320,'2833','423',522447.38,522447.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233186',4484321,'2834','423',503583.34,505876.12,2292.78,371430.36,0.00,0.00,0.00,0.00,0.00),('5','183','951','233186',4484322,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233186',4484323,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233191',4484413,'2829','423',668064.18,669641.51,1577.33,255527.46,0.00,0.00,0.00,0.00,0.00),('5','183','949','233191',4484414,'2830','423',367389.13,368483.61,1094.48,177305.76,0.00,0.00,0.00,0.00,0.00),('5','183','949','233191',4484415,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233191',4484416,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233191',4484417,'2833','423',522447.38,523288.27,840.89,136224.18,0.00,0.00,0.00,0.00,0.00),('5','183','950','233191',4484418,'2834','423',505876.12,508447.41,2571.29,416548.98,0.00,0.00,0.00,0.00,0.00),('5','183','951','233191',4484419,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233191',4484420,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233206',4484658,'2829','423',669641.51,669641.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233206',4484659,'2830','423',368483.61,368483.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233206',4484660,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233206',4484661,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233206',4484662,'2833','423',523288.27,526886.40,3598.13,582897.06,0.00,0.00,0.00,0.00,0.00),('5','183','950','233206',4484663,'2834','423',508447.41,511183.25,2735.84,443206.08,0.00,0.00,0.00,0.00,0.00),('5','183','951','233206',4484664,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233206',4484665,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233212',4484760,'2829','423',669641.51,669641.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233212',4484761,'2830','423',368483.61,368483.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233212',4484762,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233212',4484763,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233212',4484764,'2833','423',526886.40,530163.48,3277.08,530886.96,0.00,0.00,0.00,0.00,0.00),('5','183','950','233212',4484765,'2834','423',511183.25,514019.30,2836.05,459440.10,0.00,0.00,0.00,0.00,0.00),('5','183','951','233212',4484766,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233212',4484767,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233219',4484873,'2829','423',669641.51,670256.76,615.25,99670.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','233219',4484874,'2830','423',368483.61,369080.12,596.51,96634.62,0.00,0.00,0.00,0.00,0.00),('5','183','949','233219',4484875,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233219',4484876,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233219',4484877,'2833','423',530163.48,533415.55,3252.07,526835.34,0.00,0.00,0.00,0.00,0.00),('5','183','950','233219',4484878,'2834','423',514019.30,516351.72,2332.42,377852.04,0.00,0.00,0.00,0.00,0.00),('5','183','951','233219',4484879,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233219',4484880,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233222',4484943,'2829','423',670256.76,672537.17,2280.41,369426.42,0.00,0.00,0.00,0.00,0.00),('5','183','949','233222',4484944,'2830','423',369080.12,369080.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233222',4484945,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233222',4484946,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233222',4484947,'2833','423',533415.55,535774.56,2359.01,382159.62,0.00,0.00,0.00,0.00,0.00),('5','183','950','233222',4484948,'2834','423',516351.72,518618.18,2266.46,367166.52,0.00,0.00,0.00,0.00,0.00),('5','183','951','233222',4484949,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233222',4484950,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233227',4485056,'2829','423',672537.17,674424.24,1887.07,305705.34,0.00,0.00,0.00,0.00,0.00),('5','183','949','233227',4485057,'2830','423',369080.12,369080.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233227',4485058,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233227',4485059,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233227',4485060,'2833','423',535774.56,538447.58,2673.02,433029.24,0.00,0.00,0.00,0.00,0.00),('5','183','950','233227',4485061,'2834','423',518618.18,520976.67,2358.49,382075.38,0.00,0.00,0.00,0.00,0.00),('5','183','951','233227',4485062,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233227',4485063,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233370',4487679,'2829','423',674424.24,678273.18,3848.94,623528.28,0.00,0.00,0.00,0.00,0.00),('5','183','949','233370',4487680,'2830','423',369080.12,369080.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233370',4487681,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233370',4487682,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233370',4487683,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233370',4487684,'2834','423',520976.67,523994.01,3017.34,488809.08,0.00,0.00,0.00,0.00,0.00),('5','183','951','233370',4487685,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233370',4487686,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','233615',4492135,'2829','423',678273.18,682055.52,3782.34,612739.08,0.00,0.00,0.00,0.00,0.00),('5','183','949','233615',4492136,'2830','423',369080.12,370333.45,1253.33,203039.46,0.00,0.00,0.00,0.00,0.00),('5','183','949','233615',4492137,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233615',4492138,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233615',4492139,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','233615',4492140,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','233615',4492141,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','233615',4492142,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234164',4502146,'2829','423',682055.52,684938.24,2882.72,467000.64,0.00,0.00,0.00,0.00,0.00),('5','183','949','234164',4502147,'2830','423',370333.45,372819.47,2486.02,402735.24,0.00,0.00,0.00,0.00,0.00),('5','183','949','234164',4502148,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234164',4502149,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234164',4502150,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234164',4502151,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','234164',4502152,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','234164',4502153,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234307',4504649,'2829','423',684938.24,688935.32,3997.08,647526.96,0.00,0.00,0.00,0.00,0.00),('5','183','949','234307',4504650,'2830','423',372819.47,375967.09,3147.62,509914.44,0.00,0.00,0.00,0.00,0.00),('5','183','949','234307',4504651,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234307',4504652,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234307',4504653,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234307',4504654,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','234307',4504655,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','234307',4504656,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234561',4509185,'2829','423',688935.32,689711.97,776.65,125817.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','234561',4509186,'2830','423',375967.09,375967.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234561',4509187,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234561',4509188,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234561',4509189,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234561',4509190,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','234561',4509191,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','234561',4509192,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234628',4510327,'2829','423',689711.97,689711.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234628',4510328,'2830','423',375967.09,375967.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234628',4510329,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234628',4510330,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234628',4510331,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234628',4510332,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','234628',4510333,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','234628',4510334,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234935',4515884,'2829','423',689711.97,689711.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234935',4515885,'2830','423',375967.09,375967.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','234935',4515886,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234935',4515887,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234935',4515888,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','234935',4515889,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','234935',4515890,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','234935',4515891,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235278',4521843,'2829','423',689711.97,689711.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235278',4521844,'2830','423',375967.09,375967.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235278',4521845,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235278',4521846,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235278',4521847,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235278',4521848,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','235278',4521849,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','235278',4521850,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235493',4525639,'2829','423',689711.97,692761.86,3049.89,503231.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','235493',4525640,'2830','423',375967.09,377702.11,1735.02,286278.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','235493',4525641,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235493',4525642,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235493',4525643,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235493',4525644,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','235493',4525645,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','235493',4525646,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235725',4529722,'2829','423',692761.86,696550.22,3788.36,625079.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','235725',4529723,'2830','423',377702.11,381428.69,3726.58,614885.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','235725',4529724,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235725',4529725,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235725',4529726,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235725',4529727,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','235725',4529728,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','235725',4529729,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','235935',4533165,'2829','423',696550.22,696853.39,303.17,50023.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','235935',4533166,'2830','423',381428.69,382149.42,720.73,118920.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','235935',4533167,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235935',4533168,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235935',4533169,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','235935',4533170,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','235935',4533171,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','235935',4533172,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','236229',4538624,'2829','423',696853.39,698580.19,1726.80,284922.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','236229',4538625,'2830','423',382149.42,384608.19,2458.77,405697.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','236229',4538626,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236229',4538627,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236229',4538628,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236229',4538629,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','236229',4538630,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','236229',4538631,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','236481',4543082,'2829','423',698580.19,702705.63,4105.44,677397.60,0.00,0.00,20.00,0.00,0.00),('5','183','949','236481',4543083,'2830','423',384608.19,388201.96,3593.77,592972.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','236481',4543084,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236481',4543085,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236481',4543086,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236481',4543087,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','236481',4543088,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','236481',4543089,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','236727',4547083,'2829','423',702705.63,707466.04,4760.41,785467.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','236727',4547084,'2830','423',388201.96,390207.38,2005.42,330894.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','236727',4547085,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236727',4547086,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236727',4547087,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','236727',4547088,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','236727',4547089,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','236727',4547090,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237020',4552310,'2829','423',707466.04,707466.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237020',4552311,'2830','423',390207.38,396063.18,5855.80,966207.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237020',4552312,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237020',4552313,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237020',4552314,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237020',4552315,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','237020',4552316,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','237020',4552317,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237420',4559473,'2829','423',707466.04,709285.70,1819.66,300243.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','237420',4559474,'2830','423',396063.18,396063.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237420',4559475,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237420',4559476,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237420',4559477,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237420',4559478,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','237420',4559479,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','237420',4559480,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237638',4563196,'2829','423',709285.70,709285.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237638',4563197,'2830','423',396063.18,396063.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237638',4563198,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237638',4563199,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237638',4563200,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237638',4563201,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','237638',4563202,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','237638',4563203,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237723',4564892,'2829','423',709285.70,709285.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237723',4564893,'2830','423',396063.18,396063.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237723',4564894,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237723',4564895,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237723',4564896,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237723',4564897,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','237723',4564898,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','237723',4564899,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','237938',4568229,'2829','423',709285.70,714670.11,5384.41,888427.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','237938',4568230,'2830','423',396063.18,398264.06,2200.88,363145.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','237938',4568231,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237938',4568232,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237938',4568233,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','237938',4568234,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','237938',4568235,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','237938',4568236,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','238211',4572789,'2829','423',714670.11,720350.26,5680.15,937224.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','238211',4572790,'2830','423',398264.06,399735.53,1471.47,242792.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','238211',4572791,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238211',4572792,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238211',4572793,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238211',4572794,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','238211',4572795,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','238211',4572796,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','238428',4576542,'2829','423',720350.26,727695.47,7345.21,1211959.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','238428',4576543,'2830','423',399735.53,402414.58,2679.05,442043.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','238428',4576544,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238428',4576545,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238428',4576546,'2833','423',538447.58,538447.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238428',4576547,'2834','423',523994.01,523994.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','238428',4576548,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','238428',4576549,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','238727',4581532,'2829','423',727695.47,730991.38,3295.91,543825.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','238727',4581533,'2830','423',402414.58,405036.21,2621.63,432568.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','238727',4581534,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238727',4581535,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','238727',4581536,'2833','423',538447.58,541222.08,2774.50,457792.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','238727',4581537,'2834','423',523994.01,525302.40,1308.39,215884.35,0.00,0.00,0.00,0.00,0.00),('5','183','951','238727',4581538,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','238727',4581539,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239031',4587215,'2829','423',730991.38,737263.18,6271.80,1034847.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239031',4587216,'2830','423',405036.21,405476.36,440.15,72624.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','239031',4587217,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239031',4587218,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239031',4587219,'2833','423',541222.08,541222.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239031',4587220,'2834','423',525302.40,529962.14,4659.74,768857.10,0.00,0.00,0.00,0.00,0.00),('5','183','951','239031',4587221,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','239031',4587222,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239144',4589074,'2829','423',737263.18,743478.95,6215.77,1025602.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','239144',4589075,'2830','423',405476.36,405476.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239144',4589076,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239144',4589077,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239144',4589078,'2833','423',541222.08,545662.94,4440.86,732741.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','239144',4589079,'2834','423',529962.14,536337.52,6375.38,1051937.70,0.00,0.00,0.00,0.00,0.00),('5','183','951','239144',4589080,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','239144',4589081,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239353',4592506,'2829','423',743478.95,743478.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239353',4592507,'2830','423',405476.36,407441.41,1965.05,324233.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','239353',4592508,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239353',4592509,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239353',4592510,'2833','423',545662.94,550719.88,5056.94,834395.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','239353',4592511,'2834','423',536337.52,539243.65,2906.13,479511.45,0.00,0.00,0.00,0.00,0.00),('5','183','951','239353',4592512,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','239353',4592513,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239678',4598203,'2829','423',743478.95,744880.03,1401.08,231178.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','239678',4598204,'2830','423',407441.41,411143.40,3701.99,610828.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','239678',4598205,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239678',4598206,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239678',4598207,'2833','423',550719.88,554025.34,3305.46,545400.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','239678',4598208,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','239678',4598209,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','239678',4598210,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','239922',4602447,'2829','423',744880.03,746853.98,1973.95,325701.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','239922',4602448,'2830','423',411143.40,413124.11,1980.71,326817.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','239922',4602449,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239922',4602450,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','239922',4602451,'2833','423',554025.34,555838.63,1813.29,299192.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','239922',4602452,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','239922',4602453,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','239922',4602454,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240073',4605050,'2829','423',746853.98,748483.47,1629.49,268865.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','240073',4605051,'2830','423',413124.11,414760.25,1636.14,269963.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','240073',4605052,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240073',4605053,'2832','423',200204.12,200204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240073',4605054,'2833','423',555838.63,557155.79,1317.16,217331.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','240073',4605055,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','240073',4605056,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','240073',4605057,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240218',4607513,'2829','423',748483.47,750435.00,1951.53,322002.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','240218',4607514,'2830','423',414760.25,416643.95,1883.70,310810.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','240218',4607515,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240218',4607516,'2832','423',200204.12,200261.13,57.01,9406.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','240218',4607517,'2833','423',557155.79,558263.28,1107.49,182735.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','240218',4607518,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','240218',4607519,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','240218',4607520,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240675',4614821,'2829','423',750435.00,753085.22,2650.22,437286.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','240675',4614822,'2830','423',416643.95,419153.03,2509.08,413998.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','240675',4614823,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240675',4614824,'2832','423',200261.13,200261.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240675',4614825,'2833','423',558263.28,558485.96,222.68,36742.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','240675',4614826,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','240675',4614827,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','240675',4614828,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240781',4616461,'2829','423',753085.22,755793.82,2708.60,446919.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240781',4616462,'2830','423',419153.03,419153.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','240781',4616463,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240781',4616464,'2832','423',200261.13,200261.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','240781',4616465,'2833','423',558485.96,561436.07,2950.11,486768.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','240781',4616466,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','240781',4616467,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','240781',4616468,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','241039',4621090,'2829','423',755793.82,759035.55,3241.73,534885.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','241039',4621091,'2830','423',419153.03,421883.30,2730.27,450494.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','241039',4621092,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241039',4621093,'2832','423',200261.13,200261.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241039',4621094,'2833','423',561436.07,562283.58,847.51,139839.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','241039',4621095,'2834','423',539243.65,539243.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','241039',4621096,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','241039',4621097,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','241510',4629263,'2829','423',759035.55,761816.37,2780.82,458835.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','241510',4629264,'2830','423',421883.30,423175.22,1291.92,213166.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','241510',4629265,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241510',4629266,'2832','423',200261.13,200261.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241510',4629267,'2833','423',562283.58,563646.27,1362.69,224843.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','241510',4629268,'2834','423',539243.65,540103.95,860.30,141949.50,0.00,0.00,0.00,0.00,0.00),('5','183','951','241510',4629269,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','241510',4629270,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','241735',4633341,'2829','423',761816.37,767056.48,5240.11,864618.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','241735',4633342,'2830','423',423175.22,423796.44,621.22,102501.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','241735',4633343,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241735',4633344,'2832','423',200261.13,200261.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241735',4633345,'2833','423',563646.27,563646.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241735',4633346,'2834','423',540103.95,544880.41,4776.46,788115.90,0.00,0.00,0.00,0.00,0.00),('5','183','951','241735',4633347,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','241735',4633348,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','241844',4635023,'2829','423',767056.48,767122.85,66.37,10951.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','241844',4635024,'2830','423',423796.44,426242.11,2445.67,403535.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','241844',4635025,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','241844',4635026,'2832','423',200261.13,203563.90,3302.77,544957.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','241844',4635027,'2833','423',563646.27,564375.91,729.64,120390.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','241844',4635028,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','241844',4635029,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','241844',4635030,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242124',4640043,'2829','423',767122.85,767122.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242124',4640044,'2830','423',426242.11,426242.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242124',4640045,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242124',4640046,'2832','423',203563.90,206189.02,2625.12,433144.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','242124',4640047,'2833','423',564375.91,566896.47,2520.56,415892.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','242124',4640048,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','242124',4640049,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','242124',4640050,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242398',4645040,'2829','423',767122.85,767122.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242398',4645041,'2830','423',426242.11,426242.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242398',4645042,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242398',4645043,'2832','423',206189.02,206441.17,252.15,41604.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','242398',4645044,'2833','423',566896.47,568103.93,1207.46,199230.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','242398',4645045,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','242398',4645046,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','242398',4645047,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242683',4649847,'2829','423',767122.85,767122.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242683',4649848,'2830','423',426242.11,426242.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242683',4649849,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242683',4649850,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242683',4649851,'2833','423',568103.93,568103.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242683',4649852,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','242683',4649853,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','242683',4649854,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','242832',4652386,'2829','423',767122.85,768264.24,1141.39,188329.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','242832',4652387,'2830','423',426242.11,427436.54,1194.43,197080.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','242832',4652388,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242832',4652389,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242832',4652390,'2833','423',568103.93,568103.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','242832',4652391,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','242832',4652392,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','242832',4652393,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','243124',4657583,'2829','423',768264.24,771792.97,3528.73,582240.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','243124',4657584,'2830','423',427436.54,429532.19,2095.65,345782.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','243124',4657585,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243124',4657586,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243124',4657587,'2833','423',568103.93,568103.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243124',4657588,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','243124',4657589,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','243124',4657590,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','243239',4659473,'2829','423',771792.97,776536.75,4743.78,782723.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','243239',4659474,'2830','423',429532.19,433335.79,3803.60,627594.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','243239',4659475,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243239',4659476,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243239',4659477,'2833','423',568103.93,568103.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243239',4659478,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','243239',4659479,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','243239',4659480,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','243803',4669617,'2829','423',776536.75,779664.37,3127.62,516057.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','243803',4669618,'2830','423',433335.79,436191.93,2856.14,471263.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','243803',4669619,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243803',4669620,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243803',4669621,'2833','423',568103.93,568103.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','243803',4669622,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','243803',4669623,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','243803',4669624,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244159',4675472,'2829','423',779664.37,784979.91,5315.54,877064.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','244159',4675473,'2830','423',436191.93,440269.91,4077.98,672866.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','244159',4675474,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244159',4675475,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244159',4675476,'2833','423',568103.93,568330.66,226.73,37410.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','244159',4675477,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','244159',4675478,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','244159',4675479,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244208',4676417,'2829','423',784979.91,789443.71,4463.80,736527.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244208',4676418,'2830','423',440269.91,444130.32,3860.41,636967.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','244208',4676419,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244208',4676420,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244208',4676421,'2833','423',568330.66,568330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244208',4676422,'2834','423',544880.41,544880.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','244208',4676423,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','244208',4676424,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244237',4676975,'2829','423',789443.71,789443.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244237',4676976,'2830','423',444130.32,446112.93,1982.61,327130.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','244237',4676977,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244237',4676978,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244237',4676979,'2833','423',568330.66,573578.03,5247.37,865816.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','244237',4676980,'2834','423',544880.41,546446.29,1565.88,258370.20,0.00,0.00,0.00,0.00,0.00),('5','183','951','244237',4676981,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','244237',4676982,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244370',4679104,'2829','423',789443.71,790906.60,1462.89,241376.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','244370',4679105,'2830','423',446112.93,447456.74,1343.81,221728.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','244370',4679106,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244370',4679107,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244370',4679108,'2833','423',573578.03,573578.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244370',4679109,'2834','423',546446.29,549579.73,3133.44,517017.60,0.00,0.00,0.00,0.00,0.00),('5','183','951','244370',4679110,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','244370',4679111,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244652',4684113,'2829','423',790906.60,790906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244652',4684114,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','244652',4684115,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244652',4684116,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','244652',4684117,'2833','423',573578.03,578652.20,5074.17,837238.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','244652',4684118,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','244652',4684119,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','244652',4684120,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245007',4689970,'2829','423',790906.60,790906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245007',4689971,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245007',4689972,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245007',4689973,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245007',4689974,'2833','423',578652.20,585529.03,6876.83,1134676.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','245007',4689975,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','245007',4689976,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','245007',4689977,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245151',4692864,'2829','423',790906.60,790906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245151',4692865,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245151',4692866,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245151',4692867,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245151',4692868,'2833','423',585529.03,590682.01,5152.98,850241.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','245151',4692869,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','245151',4692870,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','245151',4692871,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245437',4697706,'2829','423',790906.60,790906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245437',4697707,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245437',4697708,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245437',4697709,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245437',4697710,'2833','423',590682.01,592521.52,1839.51,303519.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','245437',4697711,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','245437',4697712,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','245437',4697713,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245653',4701637,'2829','423',790906.60,790906.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245653',4701638,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245653',4701639,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245653',4701640,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245653',4701641,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245653',4701642,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','245653',4701643,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','245653',4701644,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245918',4705700,'2829','423',790906.60,792595.42,1688.82,278655.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','245918',4705701,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','245918',4705702,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245918',4705703,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245918',4705704,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','245918',4705705,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','245918',4705706,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','245918',4705707,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246058',4707846,'2829','423',792595.42,798105.21,5509.79,909115.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','246058',4707847,'2830','423',447456.74,447456.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246058',4707848,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246058',4707849,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246058',4707850,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246058',4707851,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','246058',4707852,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','246058',4707853,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246364',4712902,'2829','423',798105.21,799424.25,1319.04,217641.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','246364',4712903,'2830','423',447456.74,451487.40,4030.66,665058.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','246364',4712904,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246364',4712905,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246364',4712906,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246364',4712907,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','246364',4712908,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','246364',4712909,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246586',4716900,'2829','423',799424.25,799469.27,45.02,7428.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','246586',4716901,'2830','423',451487.40,457130.70,5643.30,931144.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','246586',4716902,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246586',4716903,'2832','423',206441.17,206441.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246586',4716904,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246586',4716905,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','246586',4716906,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','246586',4716907,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246949',4723134,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','246949',4723135,'2830','423',457130.70,461802.08,4671.38,770777.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','246949',4723136,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246949',4723137,'2832','423',206441.17,208122.64,1681.47,277442.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','246949',4723138,'2833','423',592521.52,592521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','246949',4723139,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','246949',4723140,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','246949',4723141,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247067',4725154,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247067',4725155,'2830','423',461802.08,463127.18,1325.10,218641.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','247067',4725156,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247067',4725157,'2832','423',208122.64,210566.31,2443.67,403205.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','247067',4725158,'2833','423',592521.52,595380.29,2858.77,471697.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','247067',4725159,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','247067',4725160,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','247067',4725161,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247369',4730708,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247369',4730709,'2830','423',463127.18,463127.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247369',4730710,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247369',4730711,'2832','423',210566.31,213431.58,2865.27,472769.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','247369',4730712,'2833','423',595380.29,601523.92,6143.63,1013698.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','247369',4730713,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','247369',4730714,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','247369',4730715,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247686',4735691,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247686',4735692,'2830','423',463127.18,465944.69,2817.51,464889.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','247686',4735693,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247686',4735694,'2832','423',213431.58,215057.37,1625.79,268255.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','247686',4735695,'2833','423',601523.92,601523.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247686',4735696,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','247686',4735697,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','247686',4735698,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247909',4739618,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247909',4739619,'2830','423',465944.69,465944.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','247909',4739620,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247909',4739621,'2832','423',215057.37,219472.50,4415.13,728496.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','247909',4739622,'2833','423',601523.92,601523.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','247909',4739623,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','247909',4739624,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','247909',4739625,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248159',4743859,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248159',4743860,'2830','423',465944.69,465944.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248159',4743861,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248159',4743862,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248159',4743863,'2833','423',601523.92,605147.27,3623.35,597852.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','248159',4743864,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','248159',4743865,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','248159',4743866,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248298',4746345,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248298',4746346,'2830','423',465944.69,465944.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248298',4746347,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248298',4746348,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248298',4746349,'2833','423',605147.27,606557.41,1410.14,232673.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','248298',4746350,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','248298',4746351,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','248298',4746352,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248630',4751883,'2829','423',799469.27,799469.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248630',4751884,'2830','423',465944.69,470342.06,4397.37,725566.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','248630',4751885,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248630',4751886,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248630',4751887,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248630',4751888,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','248630',4751889,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','248630',4751890,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','248991',4757953,'2829','423',799469.27,802279.81,2810.54,463739.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','248991',4757954,'2830','423',470342.06,473745.58,3403.52,561580.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','248991',4757955,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248991',4757956,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248991',4757957,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','248991',4757958,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','248991',4757959,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','248991',4757960,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249120',4759920,'2829','423',802279.81,807996.27,5716.46,943215.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','249120',4759921,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249120',4759922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249120',4759923,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249120',4759924,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249120',4759925,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','249120',4759926,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','249120',4759927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249432',4765365,'2829','423',807996.27,814060.45,6064.18,1000589.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','249432',4765366,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249432',4765367,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249432',4765368,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249432',4765369,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249432',4765370,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','249432',4765371,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','249432',4765372,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249666',4769214,'2829','423',814060.45,817985.17,3924.72,647578.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','249666',4769215,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249666',4769216,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249666',4769217,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249666',4769218,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249666',4769219,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','249666',4769220,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','249666',4769221,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249922',4773593,'2829','423',817985.17,819504.03,1518.86,250611.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','249922',4773594,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','249922',4773595,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249922',4773596,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249922',4773597,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','249922',4773598,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','249922',4773599,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','249922',4773600,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250238',4779000,'2829','423',819504.03,821964.83,2460.80,406032.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250238',4779001,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250238',4779002,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250238',4779003,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250238',4779004,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250238',4779005,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','250238',4779006,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','250238',4779007,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250495',4783173,'2829','423',821964.83,829158.99,7194.16,1187036.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','250495',4783174,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250495',4783175,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250495',4783176,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250495',4783177,'2833','423',606557.41,606557.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250495',4783178,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','250495',4783179,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','250495',4783180,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250774',4788196,'2829','423',829158.99,833637.39,4478.40,738936.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250774',4788197,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','250774',4788198,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250774',4788199,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','250774',4788200,'2833','423',606557.41,609840.88,3283.47,541772.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','250774',4788201,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','250774',4788202,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','250774',4788203,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','251051',4792866,'2829','423',833637.39,836862.22,3224.83,532096.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','251051',4792867,'2830','423',473745.58,473745.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','251051',4792868,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251051',4792869,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251051',4792870,'2833','423',609840.88,614325.72,4484.84,739998.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','251051',4792871,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','251051',4792872,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','251051',4792873,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','251122',4794147,'2829','423',836862.22,839805.29,2943.07,485606.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','251122',4794148,'2830','423',473745.58,480448.01,6702.43,1105900.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','251122',4794149,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251122',4794150,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251122',4794151,'2833','423',614325.72,614355.05,29.33,4839.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','251122',4794152,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','251122',4794153,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','251122',4794154,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','251763',4805370,'2829','423',839805.29,846398.69,6593.40,1087911.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','251763',4805371,'2830','423',480448.01,483188.18,2740.17,452128.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','251763',4805372,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251763',4805373,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251763',4805374,'2833','423',614355.05,614355.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','251763',4805375,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','251763',4805376,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','251763',4805377,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252813',4823487,'2829','423',846398.69,853260.93,6862.24,1132269.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','252813',4823488,'2830','423',483188.18,484635.06,1446.88,238735.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','252813',4823489,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252813',4823490,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252813',4823491,'2833','423',614355.05,614355.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252813',4823492,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252813',4823493,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252813',4823494,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252830',4823762,'2829','423',853260.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252830',4823763,'2830','423',484635.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252830',4823764,'2831','423',4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252830',4823765,'2832','423',219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252830',4823766,'2833','423',614355.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252830',4823767,'2834','423',549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252830',4823768,'2835','424',252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252830',4823769,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252832',4823777,'2829','423',853260.93,858280.74,5019.81,828268.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','252832',4823778,'2830','423',484635.06,486049.52,1414.46,233385.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','252832',4823779,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252832',4823780,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252832',4823781,'2833','423',614355.05,614355.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252832',4823782,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252832',4823783,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252832',4823784,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252840',4823966,'2829','423',858280.74,859788.72,1507.98,248816.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','252840',4823967,'2830','423',486049.52,487577.92,1528.40,252186.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252840',4823968,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252840',4823969,'2832','423',219472.50,219472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252840',4823970,'2833','423',614355.05,617768.83,3413.78,563273.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','252840',4823971,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252840',4823972,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252840',4823973,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252844',4824023,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252844',4824024,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252844',4824025,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252844',4824026,'2832','423',219472.50,220186.21,713.71,117762.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','252844',4824027,'2833','423',617768.83,622963.28,5194.45,857084.25,0.00,0.00,0.00,0.00,0.00),('5','183','950','252844',4824028,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252844',4824029,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252844',4824030,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252853',4824183,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252853',4824184,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252853',4824185,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252853',4824186,'2832','423',220186.21,220241.94,55.73,9195.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','252853',4824187,'2833','423',622963.28,627741.98,4778.70,788485.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','252853',4824188,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252853',4824189,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252853',4824190,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252860',4824361,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252860',4824362,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252860',4824363,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252860',4824364,'2832','423',220241.94,220582.69,340.75,56223.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','252860',4824365,'2833','423',627741.98,630527.79,2785.81,459658.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','252860',4824366,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252860',4824367,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252860',4824368,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252864',4824407,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252864',4824408,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','252864',4824409,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252864',4824410,'2832','423',220582.69,221612.16,1029.47,169862.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','252864',4824411,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','252864',4824412,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','252864',4824413,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','252864',4824414,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253017',4826690,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253017',4826691,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253017',4826692,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253017',4826693,'2832','423',221612.16,221612.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253017',4826694,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253017',4826695,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','253017',4826696,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','253017',4826697,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253412',4833713,'2829','423',859788.72,859788.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253412',4833714,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253412',4833715,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253412',4833716,'2832','423',221612.16,221612.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253412',4833717,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253412',4833718,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','253412',4833719,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','253412',4833720,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253638',4837560,'2829','423',859788.72,866540.30,6751.58,1114010.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','253638',4837561,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253638',4837562,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253638',4837563,'2832','423',221612.16,221612.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253638',4837564,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253638',4837565,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','253638',4837566,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','253638',4837567,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253872',4841771,'2829','423',866540.30,870677.99,4137.69,682718.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','253872',4841772,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','253872',4841773,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253872',4841774,'2832','423',221612.16,224750.20,3138.04,517776.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','253872',4841775,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','253872',4841776,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','253872',4841777,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','253872',4841778,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254079',4845201,'2829','423',870677.99,875226.53,4548.54,750509.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','254079',4845202,'2830','423',487577.92,487577.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254079',4845203,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254079',4845204,'2832','423',224750.20,226519.61,1769.41,291952.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','254079',4845205,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254079',4845206,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','254079',4845207,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','254079',4845208,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254244',4848010,'2829','423',875226.53,880859.08,5632.55,929370.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','254244',4848011,'2830','423',487577.92,489710.31,2132.39,351844.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','254244',4848012,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254244',4848013,'2832','423',226519.61,226519.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254244',4848014,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254244',4848015,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','254244',4848016,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','254244',4848017,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254482',4852055,'2829','423',880859.08,884240.70,3381.62,557967.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','254482',4852056,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254482',4852057,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254482',4852058,'2832','423',226519.61,228231.81,1712.20,282513.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254482',4852059,'2833','423',630527.79,630527.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254482',4852060,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','254482',4852061,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','254482',4852062,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254933',4860194,'2829','423',884240.70,884240.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254933',4860195,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','254933',4860196,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','254933',4860197,'2832','423',228231.81,229920.36,1688.55,278610.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','254933',4860198,'2833','423',630527.79,631437.91,910.12,150169.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','254933',4860199,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','254933',4860200,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','254933',4860201,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255018',4861409,'2829','423',884240.70,884240.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255018',4861410,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255018',4861411,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255018',4861412,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255018',4861413,'2833','423',631437.91,634143.48,2705.57,446419.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','255018',4861414,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','255018',4861415,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','255018',4861416,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255340',4867231,'2829','423',884240.70,884240.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255340',4867232,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255340',4867233,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255340',4867234,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255340',4867235,'2833','423',634143.48,635296.27,1152.79,190210.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','255340',4867236,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','255340',4867237,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','255340',4867238,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255748',4873677,'2829','423',884240.70,884240.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255748',4873678,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255748',4873679,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255748',4873680,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255748',4873681,'2833','423',635296.27,635296.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255748',4873682,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','255748',4873683,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','255748',4873684,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255888',4876132,'2829','423',884240.70,886177.46,1936.76,319565.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','255888',4876133,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','255888',4876134,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255888',4876135,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','255888',4876136,'2833','423',635296.27,639482.23,4185.96,690683.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','255888',4876137,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','255888',4876138,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','255888',4876139,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256143',4880401,'2829','423',886177.46,888175.07,1997.61,329605.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','256143',4880402,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256143',4880403,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256143',4880404,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256143',4880405,'2833','423',639482.23,645197.56,5715.33,943029.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','256143',4880406,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','256143',4880407,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','256143',4880408,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256359',4883781,'2829','423',888175.07,894958.65,6783.58,1119290.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','256359',4883782,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256359',4883783,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256359',4883784,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256359',4883785,'2833','423',645197.56,645197.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256359',4883786,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','256359',4883787,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','256359',4883788,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256559',4887141,'2829','423',894958.65,902119.75,7161.10,1181581.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','256559',4887142,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256559',4887143,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256559',4887144,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256559',4887145,'2833','423',645197.56,645197.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256559',4887146,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','256559',4887147,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','256559',4887148,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256801',4891155,'2829','423',902119.75,907671.20,5551.45,915989.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','256801',4891156,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','256801',4891157,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256801',4891158,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256801',4891159,'2833','423',645197.56,645197.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','256801',4891160,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','256801',4891161,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','256801',4891162,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257012',4894770,'2829','423',907671.20,911012.43,3341.23,551302.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257012',4894771,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257012',4894772,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257012',4894773,'2832','423',229920.36,229920.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257012',4894774,'2833','423',645197.56,645197.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257012',4894775,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257012',4894776,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257012',4894777,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257524',4903864,'2829','423',911012.43,911012.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257524',4903865,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257524',4903866,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257524',4903867,'2832','423',229920.36,232403.13,2482.77,409657.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','257524',4903868,'2833','423',645197.56,645897.65,700.09,115514.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','257524',4903869,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257524',4903870,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257524',4903871,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257525',4903872,'2829','423',911012.43,911012.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257525',4903873,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257525',4903874,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257525',4903875,'2832','423',232403.13,232403.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257525',4903876,'2833','423',645897.65,645897.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257525',4903877,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257525',4903878,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257525',4903879,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257526',4903880,'2829','423',911012.43,912065.28,1052.85,173720.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257526',4903881,'2830','423',489710.31,489710.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257526',4903882,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257526',4903883,'2832','423',232403.13,232403.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257526',4903884,'2833','423',645897.65,647176.41,1278.76,210995.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257526',4903885,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257526',4903886,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257526',4903887,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257527',4903888,'2829','423',912065.28,918165.73,6100.45,1006574.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257527',4903889,'2830','423',489710.31,492610.26,2899.95,478491.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257527',4903890,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257527',4903891,'2832','423',232403.13,232403.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257527',4903892,'2833','423',647176.41,647176.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257527',4903893,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257527',4903894,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257527',4903895,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257528',4903896,'2829','423',918165.73,923935.37,5769.64,951990.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257528',4903897,'2830','423',492610.26,494031.65,1421.39,234529.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257528',4903898,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257528',4903899,'2832','423',232403.13,232403.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257528',4903900,'2833','423',647176.41,647176.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257528',4903901,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257528',4903902,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257528',4903903,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257529',4903904,'2829','423',923935.37,928664.79,4729.42,780354.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257529',4903905,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257529',4903906,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257529',4903907,'2832','423',232403.13,234212.95,1809.82,298620.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257529',4903908,'2833','423',647176.41,647176.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257529',4903909,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257529',4903910,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257529',4903911,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257530',4903912,'2829','423',928664.79,933331.00,4666.21,769924.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257530',4903913,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257530',4903914,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257530',4903915,'2832','423',234212.95,234212.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257530',4903916,'2833','423',647176.41,647265.68,89.27,14729.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257530',4903917,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257530',4903918,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257530',4903919,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257531',4903920,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257531',4903921,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257531',4903922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257531',4903923,'2832','423',234212.95,238096.17,3883.22,640731.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257531',4903924,'2833','423',647265.68,647692.94,427.26,70497.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257531',4903925,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257531',4903926,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257531',4903927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257532',4903928,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257532',4903929,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257532',4903930,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257532',4903931,'2832','423',238096.17,241394.01,3297.84,544143.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257532',4903932,'2833','423',647692.94,647692.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257532',4903933,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257532',4903934,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257532',4903935,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257533',4903936,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257533',4903937,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257533',4903938,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257533',4903939,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257533',4903940,'2833','423',647692.94,649938.95,2246.01,370591.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257533',4903941,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257533',4903942,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257533',4903943,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257534',4903944,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257534',4903945,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257534',4903946,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257534',4903947,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257534',4903948,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257534',4903949,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257534',4903950,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257534',4903951,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257535',4903952,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257535',4903953,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257535',4903954,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257535',4903955,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257535',4903956,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257535',4903957,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257535',4903958,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257535',4903959,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257536',4903960,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257536',4903961,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257536',4903962,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257536',4903963,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257536',4903964,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257536',4903965,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257536',4903966,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257536',4903967,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257537',4903968,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257537',4903969,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257537',4903970,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257537',4903971,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257537',4903972,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257537',4903973,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257537',4903974,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257537',4903975,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257538',4903976,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257538',4903977,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257538',4903978,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257538',4903979,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257538',4903980,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257538',4903981,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257538',4903982,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257538',4903983,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257539',4903984,'2829','423',933331.00,933331.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257539',4903985,'2830','423',494031.65,494031.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257539',4903986,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257539',4903987,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257539',4903988,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257539',4903989,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257539',4903990,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257539',4903991,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257540',4903992,'2829','423',933331.00,934503.75,1172.75,193503.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257540',4903993,'2830','423',494031.65,494525.02,493.37,81406.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257540',4903994,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257540',4903995,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257540',4903996,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257540',4903997,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257540',4903998,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257540',4903999,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257541',4904000,'2829','423',934503.75,942232.24,7728.49,1275200.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257541',4904001,'2830','423',494525.02,494658.09,133.07,21956.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257541',4904002,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257541',4904003,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257541',4904004,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257541',4904005,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257541',4904006,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257541',4904007,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257542',4904008,'2829','423',942232.24,949239.29,7007.05,1156163.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257542',4904009,'2830','423',494658.09,495216.62,558.53,92157.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257542',4904010,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257542',4904011,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257542',4904012,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257542',4904013,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257542',4904014,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257542',4904015,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257543',4904016,'2829','423',949239.29,954892.14,5652.85,932720.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257543',4904017,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257543',4904018,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257543',4904019,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257543',4904020,'2833','423',649938.95,649938.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257543',4904021,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257543',4904022,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257543',4904023,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257544',4904024,'2829','423',954892.14,954892.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257544',4904025,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257544',4904026,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257544',4904027,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257544',4904028,'2833','423',649938.95,657070.84,7131.89,1176761.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','257544',4904029,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257544',4904030,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257544',4904031,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257545',4904032,'2829','423',954892.14,954892.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257545',4904033,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257545',4904034,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257545',4904035,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257545',4904036,'2833','423',657070.84,663019.48,5948.64,981525.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257545',4904037,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257545',4904038,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257545',4904039,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257546',4904040,'2829','423',954892.14,954892.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257546',4904041,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257546',4904042,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257546',4904043,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257546',4904044,'2833','423',663019.48,668742.40,5722.92,944281.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257546',4904045,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257546',4904046,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257546',4904047,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257547',4904048,'2829','423',954892.14,954892.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257547',4904049,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257547',4904050,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257547',4904051,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257547',4904052,'2833','423',668742.40,671607.26,2864.86,472701.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257547',4904053,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257547',4904054,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257547',4904055,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257548',4904056,'2829','423',954892.14,963475.30,8583.16,1416221.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257548',4904057,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257548',4904058,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257548',4904059,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257548',4904060,'2833','423',671607.26,671607.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257548',4904061,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257548',4904062,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257548',4904063,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257549',4904064,'2829','423',963475.30,971331.99,7856.69,1296353.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257549',4904065,'2830','423',495216.62,495216.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257549',4904066,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257549',4904067,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257549',4904068,'2833','423',671607.26,672588.47,981.21,161899.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257549',4904069,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257549',4904070,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257549',4904071,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257550',4904072,'2829','423',971331.99,978612.99,7281.00,1201365.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257550',4904073,'2830','423',495216.62,495428.72,212.10,34996.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257550',4904074,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257550',4904075,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257550',4904076,'2833','423',672588.47,672588.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257550',4904077,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257550',4904078,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257550',4904079,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257551',4904080,'2829','423',978612.99,985602.16,6989.17,1153213.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257551',4904081,'2830','423',495428.72,495428.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257551',4904082,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257551',4904083,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257551',4904084,'2833','423',672588.47,672588.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257551',4904085,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257551',4904086,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257551',4904087,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257552',4904088,'2829','423',985602.16,990791.41,5189.25,856226.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257552',4904089,'2830','423',495428.72,501005.08,5576.36,920099.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257552',4904090,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257552',4904091,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257552',4904092,'2833','423',672588.47,672588.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257552',4904093,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257552',4904094,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257552',4904095,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257553',4904096,'2829','423',990791.41,990791.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257553',4904097,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257553',4904098,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257553',4904099,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257553',4904100,'2833','423',672588.47,678818.77,6230.30,1027999.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257553',4904101,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257553',4904102,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257553',4904103,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257554',4904104,'2829','423',990791.41,990791.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257554',4904105,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257554',4904106,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257554',4904107,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257554',4904108,'2833','423',678818.77,682309.54,3490.77,575977.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','257554',4904109,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257554',4904110,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257554',4904111,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257555',4904112,'2829','423',990791.41,990791.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257555',4904113,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257555',4904114,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257555',4904115,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257555',4904116,'2833','423',682309.54,685099.33,2789.79,460315.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257555',4904117,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257555',4904118,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257555',4904119,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257556',4904120,'2829','423',990791.41,999450.78,8659.37,1428796.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257556',4904121,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257556',4904122,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257556',4904123,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257556',4904124,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257556',4904125,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257556',4904126,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257556',4904127,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257557',4904128,'2829','423',999450.78,1011440.61,11989.83,1978321.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257557',4904129,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257557',4904130,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257557',4904131,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257557',4904132,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257557',4904133,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257557',4904134,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257557',4904135,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257558',4904136,'2829','423',1011440.61,1018305.34,6864.73,1132680.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257558',4904137,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257558',4904138,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257558',4904139,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257558',4904140,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257558',4904141,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257558',4904142,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257558',4904143,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257559',4904144,'2829','423',1018305.34,1026737.52,8432.18,1391309.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257559',4904145,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257559',4904146,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257559',4904147,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257559',4904148,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257559',4904149,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257559',4904150,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257559',4904151,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257560',4904152,'2829','423',1026737.52,1032158.96,5421.44,894537.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257560',4904153,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257560',4904154,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257560',4904155,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257560',4904156,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257560',4904157,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257560',4904158,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257560',4904159,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257561',4904160,'2829','423',1032158.96,1038161.26,6002.30,990379.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257561',4904161,'2830','423',501005.08,501005.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257561',4904162,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257561',4904163,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257561',4904164,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257561',4904165,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257561',4904166,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257561',4904167,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257562',4904168,'2829','423',1038161.26,1044042.61,5881.35,970422.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257562',4904169,'2830','423',501005.08,502397.92,1392.84,229818.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257562',4904170,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257562',4904171,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257562',4904172,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257562',4904173,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257562',4904174,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257562',4904175,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257563',4904176,'2829','423',1044042.61,1044042.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257563',4904177,'2830','423',502397.92,502397.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257563',4904178,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257563',4904179,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257563',4904180,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257563',4904181,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257563',4904182,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257563',4904183,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257564',4904184,'2829','423',1044042.61,1054505.29,10462.68,1726342.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257564',4904185,'2830','423',502397.92,502397.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257564',4904186,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257564',4904187,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257564',4904188,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257564',4904189,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257564',4904190,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257564',4904191,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257565',4904192,'2829','423',1054505.29,1061882.95,7377.66,1217313.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257565',4904193,'2830','423',502397.92,502397.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257565',4904194,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257565',4904195,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257565',4904196,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257565',4904197,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257565',4904198,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257565',4904199,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257566',4904200,'2829','423',1061882.95,1072126.49,10243.54,1690184.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257566',4904201,'2830','423',502397.92,502805.70,407.78,67283.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257566',4904202,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257566',4904203,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257566',4904204,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257566',4904205,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257566',4904206,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257566',4904207,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257567',4904208,'2829','423',1072126.49,1080697.60,8571.11,1414233.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257567',4904209,'2830','423',502805.70,503388.70,583.00,96195.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257567',4904210,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257567',4904211,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257567',4904212,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257567',4904213,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257567',4904214,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257567',4904215,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257568',4904216,'2829','423',1080697.60,1089558.18,8860.58,1461995.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257568',4904217,'2830','423',503388.70,504364.39,975.69,160988.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257568',4904218,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257568',4904219,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257568',4904220,'2833','423',685099.33,685099.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257568',4904221,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257568',4904222,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257568',4904223,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257569',4904224,'2829','423',1089558.18,1091159.20,1601.02,264168.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257569',4904225,'2830','423',504364.39,507527.39,3163.00,521895.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257569',4904226,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257569',4904227,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257569',4904228,'2833','423',685099.33,691295.16,6195.83,1022311.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257569',4904229,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257569',4904230,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257569',4904231,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257570',4904232,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257570',4904233,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257570',4904234,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257570',4904235,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257570',4904236,'2833','423',691295.16,695983.82,4688.66,773628.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257570',4904237,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257570',4904238,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257570',4904239,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257571',4904240,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257571',4904241,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257571',4904242,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257571',4904243,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257571',4904244,'2833','423',695983.82,702243.92,6260.10,1032916.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257571',4904245,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257571',4904246,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257571',4904247,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257572',4904248,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257572',4904249,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257572',4904250,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257572',4904251,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257572',4904252,'2833','423',702243.92,708395.48,6151.56,1015007.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257572',4904253,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257572',4904254,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257572',4904255,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257573',4904256,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257573',4904257,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257573',4904258,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257573',4904259,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257573',4904260,'2833','423',708395.48,710987.03,2591.55,427605.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257573',4904261,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257573',4904262,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257573',4904263,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257574',4904264,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257574',4904265,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257574',4904266,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257574',4904267,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257574',4904268,'2833','423',710987.03,713056.25,2069.22,341421.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257574',4904269,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257574',4904270,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257574',4904271,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257575',4904272,'2829','423',1091159.20,1091159.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257575',4904273,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257575',4904274,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257575',4904275,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257575',4904276,'2833','423',713056.25,714361.04,1304.79,215290.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257575',4904277,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257575',4904278,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257575',4904279,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257576',4904280,'2829','423',1091159.20,1098774.01,7614.81,1256443.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257576',4904281,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257576',4904282,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257576',4904283,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257576',4904284,'2833','423',714361.04,714361.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257576',4904285,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257576',4904286,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257576',4904287,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257577',4904288,'2829','423',1098774.01,1105575.29,6801.28,1122211.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257577',4904289,'2830','423',507527.39,507527.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257577',4904290,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257577',4904291,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257577',4904292,'2833','423',714361.04,714361.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257577',4904293,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257577',4904294,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257577',4904295,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257578',4904296,'2829','423',1105575.29,1110220.32,4645.03,766429.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257578',4904297,'2830','423',507527.39,508000.45,473.06,78054.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257578',4904298,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257578',4904299,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257578',4904300,'2833','423',714361.04,714361.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257578',4904301,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257578',4904302,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257578',4904303,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257579',4904304,'2829','423',1110220.32,1110336.47,116.15,19164.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257579',4904305,'2830','423',508000.45,508000.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257579',4904306,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257579',4904307,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257579',4904308,'2833','423',714361.04,720809.20,6448.16,1063946.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257579',4904309,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257579',4904310,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257579',4904311,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257580',4904312,'2829','423',1110336.47,1110336.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257580',4904313,'2830','423',508000.45,508000.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257580',4904314,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257580',4904315,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257580',4904316,'2833','423',720809.20,727362.38,6553.18,1081274.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257580',4904317,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257580',4904318,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257580',4904319,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257581',4904320,'2829','423',1110336.47,1110336.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257581',4904321,'2830','423',508000.45,508130.30,129.85,21425.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257581',4904322,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257581',4904323,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257581',4904324,'2833','423',727362.38,733746.10,6383.72,1053313.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257581',4904325,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257581',4904326,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257581',4904327,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257582',4904328,'2829','423',1110336.47,1112291.93,1955.46,322650.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257582',4904329,'2830','423',508130.30,508247.03,116.73,19260.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257582',4904330,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257582',4904331,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257582',4904332,'2833','423',733746.10,734184.45,438.35,72328.03,0.00,0.00,0.00,0.00,0.00),('5','183','950','257582',4904333,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257582',4904334,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257582',4904335,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257583',4904336,'2829','423',1112291.93,1112291.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257583',4904337,'2830','423',508247.03,508247.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257583',4904338,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257583',4904339,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257583',4904340,'2833','423',734184.45,735699.60,1515.15,249999.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257583',4904341,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257583',4904342,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257583',4904343,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257584',4904344,'2829','423',1112291.93,1112291.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257584',4904345,'2830','423',508247.03,508247.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257584',4904346,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257584',4904347,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257584',4904348,'2833','423',735699.60,735699.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257584',4904349,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257584',4904350,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257584',4904351,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257585',4904352,'2829','423',1112291.93,1113173.23,881.30,145414.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257585',4904353,'2830','423',508247.03,508489.25,242.22,39966.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257585',4904354,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257585',4904355,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257585',4904356,'2833','423',735699.60,735699.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257585',4904357,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257585',4904358,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257585',4904359,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257586',4904360,'2829','423',1113173.23,1120699.79,7526.56,1241882.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257586',4904361,'2830','423',508489.25,509012.91,523.66,86403.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257586',4904362,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257586',4904363,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257586',4904364,'2833','423',735699.60,735699.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257586',4904365,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257586',4904366,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257586',4904367,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257587',4904368,'2829','423',1120699.79,1127512.46,6812.67,1124090.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257587',4904369,'2830','423',509012.91,509012.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257587',4904370,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257587',4904371,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257587',4904372,'2833','423',735699.60,735699.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257587',4904373,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257587',4904374,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257587',4904375,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257588',4904376,'2829','423',1127512.46,1131647.00,4134.54,682199.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257588',4904377,'2830','423',509012.91,509012.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257588',4904378,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257588',4904379,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257588',4904380,'2833','423',735699.60,737763.44,2063.84,340533.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257588',4904381,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257588',4904382,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257588',4904383,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257589',4904384,'2829','423',1131647.00,1131968.90,321.90,53113.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257589',4904385,'2830','423',509012.91,509012.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257589',4904386,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257589',4904387,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257589',4904388,'2833','423',737763.44,743250.60,5487.16,905381.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257589',4904389,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257589',4904390,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257589',4904391,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257590',4904392,'2829','423',1131968.90,1138176.20,6207.30,1024204.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257590',4904393,'2830','423',509012.91,511180.80,2167.89,357701.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257590',4904394,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257590',4904395,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257590',4904396,'2833','423',743250.60,743250.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257590',4904397,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257590',4904398,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257590',4904399,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257591',4904400,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257591',4904401,'2830','423',511180.80,512659.82,1479.02,244038.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257591',4904402,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257591',4904403,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257591',4904404,'2833','423',743250.60,748614.69,5364.09,885074.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','257591',4904405,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257591',4904406,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257591',4904407,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257592',4904408,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257592',4904409,'2830','423',512659.82,515411.10,2751.28,453961.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257592',4904410,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257592',4904411,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257592',4904412,'2833','423',748614.69,753830.76,5216.07,860651.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257592',4904413,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257592',4904414,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257592',4904415,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257593',4904416,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257593',4904417,'2830','423',515411.10,520813.52,5402.42,891399.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257593',4904418,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257593',4904419,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257593',4904420,'2833','423',753830.76,757939.79,4109.03,677989.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257593',4904421,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257593',4904422,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257593',4904423,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257594',4904424,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257594',4904425,'2830','423',520813.52,525517.92,4704.40,776226.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257594',4904426,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257594',4904427,'2832','423',241394.01,241394.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257594',4904428,'2833','423',757939.79,762204.85,4265.06,703734.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257594',4904429,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257594',4904430,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257594',4904431,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257595',4904432,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257595',4904433,'2830','423',525517.92,530538.80,5020.88,828445.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257595',4904434,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257595',4904435,'2832','423',241394.01,243977.15,2583.14,426218.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257595',4904436,'2833','423',762204.85,765017.99,2813.14,464168.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257595',4904437,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257595',4904438,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257595',4904439,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257596',4904440,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257596',4904441,'2830','423',530538.80,533818.09,3279.29,541082.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257596',4904442,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257596',4904443,'2832','423',243977.15,243977.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257596',4904444,'2833','423',765017.99,770726.19,5708.20,941853.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257596',4904445,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257596',4904446,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257596',4904447,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257597',4904448,'2829','423',1138176.20,1138176.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257597',4904449,'2830','423',533818.09,538289.18,4471.09,737729.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257597',4904450,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257597',4904451,'2832','423',243977.15,248484.17,4507.02,743658.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257597',4904452,'2833','423',770726.19,770726.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257597',4904453,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257597',4904454,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257597',4904455,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257598',4904456,'2829','423',1138176.20,1138280.17,103.97,17155.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257598',4904457,'2830','423',538289.18,543811.31,5522.13,911151.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257598',4904458,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257598',4904459,'2832','423',248484.17,248484.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257598',4904460,'2833','423',770726.19,770811.14,84.95,14016.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257598',4904461,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257598',4904462,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257598',4904463,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257599',4904464,'2829','423',1138280.17,1142841.89,4561.72,752683.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257599',4904465,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257599',4904466,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257599',4904467,'2832','423',248484.17,248484.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257599',4904468,'2833','423',770811.14,770855.70,44.56,7352.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257599',4904469,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257599',4904470,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257599',4904471,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257600',4904472,'2829','423',1142841.89,1144740.36,1898.47,313247.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257600',4904473,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257600',4904474,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257600',4904475,'2832','423',248484.17,253173.57,4689.40,773751.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257600',4904476,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257600',4904477,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257600',4904478,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257600',4904479,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257601',4904480,'2829','423',1144740.36,1146945.81,2205.45,363899.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257601',4904481,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257601',4904482,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257601',4904483,'2832','423',253173.57,257088.23,3914.66,645918.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257601',4904484,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257601',4904485,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257601',4904486,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257601',4904487,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257602',4904488,'2829','423',1146945.81,1153230.62,6284.81,1036993.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257602',4904489,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257602',4904490,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257602',4904491,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257602',4904492,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257602',4904493,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257602',4904494,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257602',4904495,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257603',4904496,'2829','423',1153230.62,1158661.75,5431.13,896136.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257603',4904497,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257603',4904498,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257603',4904499,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257603',4904500,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257603',4904501,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257603',4904502,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257603',4904503,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257604',4904504,'2829','423',1158661.75,1163361.96,4700.21,775534.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257604',4904505,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257604',4904506,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257604',4904507,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257604',4904508,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257604',4904509,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257604',4904510,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257604',4904511,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257605',4904512,'2829','423',1163361.96,1165565.41,2203.45,363569.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257605',4904513,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257605',4904514,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257605',4904515,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257605',4904516,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257605',4904517,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257605',4904518,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257605',4904519,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257606',4904520,'2829','423',1165565.41,1170922.44,5357.03,883909.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257606',4904521,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257606',4904522,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257606',4904523,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257606',4904524,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257606',4904525,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257606',4904526,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257606',4904527,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257607',4904528,'2829','423',1170922.44,1175366.69,4444.25,733301.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257607',4904529,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257607',4904530,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257607',4904531,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257607',4904532,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257607',4904533,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257607',4904534,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257607',4904535,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257608',4904536,'2829','423',1175366.69,1180674.93,5308.24,875859.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257608',4904537,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257608',4904538,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257608',4904539,'2832','423',257088.23,257088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257608',4904540,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257608',4904541,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257608',4904542,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257608',4904543,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257609',4904544,'2829','423',1180674.93,1181782.55,1107.62,182757.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257609',4904545,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257609',4904546,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257609',4904547,'2832','423',257088.23,257503.45,415.22,68511.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257609',4904548,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257609',4904549,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257609',4904550,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257609',4904551,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257610',4904552,'2829','423',1181782.55,1181782.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257610',4904553,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257610',4904554,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257610',4904555,'2832','423',257503.45,257503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257610',4904556,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257610',4904557,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257610',4904558,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257610',4904559,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257611',4904560,'2829','423',1181782.55,1181782.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257611',4904561,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257611',4904562,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257611',4904563,'2832','423',257503.45,257503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257611',4904564,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257611',4904565,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257611',4904566,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257611',4904567,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257612',4904568,'2829','423',1181782.55,1187910.02,6127.47,1011032.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257612',4904569,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257612',4904570,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257612',4904571,'2832','423',257503.45,257503.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257612',4904572,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257612',4904573,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257612',4904574,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257612',4904575,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257613',4904576,'2829','423',1187910.02,1190985.01,3074.99,507373.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257613',4904577,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257613',4904578,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257613',4904579,'2832','423',257503.45,260758.22,3254.77,537037.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','257613',4904580,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257613',4904581,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257613',4904582,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257613',4904583,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257614',4904584,'2829','423',1190985.01,1195035.31,4050.30,668299.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257614',4904585,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257614',4904586,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257614',4904587,'2832','423',260758.22,264562.40,3804.18,627689.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257614',4904588,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257614',4904589,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257614',4904590,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257614',4904591,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257615',4904592,'2829','423',1195035.31,1197040.82,2005.51,330909.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257615',4904593,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257615',4904594,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257615',4904595,'2832','423',264562.40,267080.03,2517.63,415408.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257615',4904596,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257615',4904597,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257615',4904598,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257615',4904599,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257616',4904600,'2829','423',1197040.82,1201770.28,4729.46,780360.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257616',4904601,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257616',4904602,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257616',4904603,'2832','423',267080.03,271037.46,3957.43,652975.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257616',4904604,'2833','423',770855.70,770855.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257616',4904605,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257616',4904606,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257616',4904607,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257617',4904608,'2829','423',1201770.28,1204479.42,2709.14,447008.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257617',4904609,'2830','423',543811.31,543811.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257617',4904610,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257617',4904611,'2832','423',271037.46,271634.85,597.39,98569.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257617',4904612,'2833','423',770855.70,771697.58,841.88,138910.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257617',4904613,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257617',4904614,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257617',4904615,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257618',4904616,'2829','423',1204479.42,1209146.81,4667.39,770119.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257618',4904617,'2830','423',543811.31,545601.68,1790.37,295411.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257618',4904618,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257618',4904619,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257618',4904620,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257618',4904621,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257618',4904622,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257618',4904623,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257619',4904624,'2829','423',1209146.81,1213816.46,4669.65,770492.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257619',4904625,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257619',4904626,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257619',4904627,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257619',4904628,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257619',4904629,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257619',4904630,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257619',4904631,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257620',4904632,'2829','423',1213816.46,1217815.21,3998.75,659793.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257620',4904633,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257620',4904634,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257620',4904635,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257620',4904636,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257620',4904637,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257620',4904638,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257620',4904639,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257621',4904640,'2829','423',1217815.21,1219623.48,1808.27,298364.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257621',4904641,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257621',4904642,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257621',4904643,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257621',4904644,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257621',4904645,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257621',4904646,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257621',4904647,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257622',4904648,'2829','423',1219623.48,1220628.62,1005.14,165848.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257622',4904649,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257622',4904650,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257622',4904651,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257622',4904652,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257622',4904653,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257622',4904654,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257622',4904655,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257623',4904656,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257623',4904657,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257623',4904658,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257623',4904659,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257623',4904660,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257623',4904661,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257623',4904662,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257623',4904663,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257624',4904664,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257624',4904665,'2830','423',545601.68,545601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257624',4904666,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257624',4904667,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257624',4904668,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257624',4904669,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257624',4904670,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257624',4904671,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257625',4904672,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257625',4904673,'2830','423',545601.68,550078.50,4476.82,738675.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257625',4904674,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257625',4904675,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257625',4904676,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257625',4904677,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257625',4904678,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257625',4904679,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257626',4904680,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257626',4904681,'2830','423',550078.50,553760.83,3682.33,607584.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257626',4904682,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257626',4904683,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257626',4904684,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257626',4904685,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257626',4904686,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257626',4904687,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257627',4904688,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257627',4904689,'2830','423',553760.83,558387.68,4626.85,763430.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257627',4904690,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257627',4904691,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257627',4904692,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257627',4904693,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257627',4904694,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257627',4904695,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257628',4904696,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257628',4904697,'2830','423',558387.68,563743.10,5355.42,883644.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257628',4904698,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257628',4904699,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257628',4904700,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257628',4904701,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257628',4904702,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257628',4904703,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257629',4904704,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257629',4904705,'2830','423',563743.10,569601.26,5858.16,966596.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257629',4904706,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257629',4904707,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257629',4904708,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257629',4904709,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257629',4904710,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257629',4904711,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257630',4904712,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257630',4904713,'2830','423',569601.26,575580.72,5979.46,986610.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257630',4904714,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257630',4904715,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257630',4904716,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257630',4904717,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257630',4904718,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257630',4904719,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257631',4904720,'2829','423',1220628.62,1220628.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257631',4904721,'2830','423',575580.72,581232.44,5651.72,932533.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257631',4904722,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257631',4904723,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257631',4904724,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257631',4904725,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257631',4904726,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257631',4904727,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257632',4904728,'2829','423',1220628.62,1226614.47,5985.85,987665.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257632',4904729,'2830','423',581232.44,581232.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257632',4904730,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257632',4904731,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257632',4904732,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257632',4904733,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257632',4904734,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257632',4904735,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257633',4904736,'2829','423',1226614.47,1226845.58,231.11,38133.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257633',4904737,'2830','423',581232.44,586009.36,4776.92,788191.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257633',4904738,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257633',4904739,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257633',4904740,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257633',4904741,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257633',4904742,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257633',4904743,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257634',4904744,'2829','423',1226845.58,1227200.03,354.45,58484.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257634',4904745,'2830','423',586009.36,591360.02,5350.66,882858.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257634',4904746,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257634',4904747,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257634',4904748,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257634',4904749,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257634',4904750,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257634',4904751,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257635',4904752,'2829','423',1227200.03,1228692.67,1492.64,246285.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257635',4904753,'2830','423',591360.02,596132.54,4772.52,787465.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257635',4904754,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257635',4904755,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257635',4904756,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257635',4904757,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257635',4904758,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257635',4904759,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257636',4904760,'2829','423',1228692.67,1231127.78,2435.11,401793.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257636',4904761,'2830','423',596132.54,599514.14,3381.60,557964.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257636',4904762,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257636',4904763,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257636',4904764,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257636',4904765,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257636',4904766,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257636',4904767,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257637',4904768,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257637',4904769,'2830','423',599514.14,605607.92,6093.78,1005473.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257637',4904770,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257637',4904771,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257637',4904772,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257637',4904773,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257637',4904774,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257637',4904775,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257638',4904776,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257638',4904777,'2830','423',605607.92,611791.08,6183.16,1020221.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257638',4904778,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257638',4904779,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257638',4904780,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257638',4904781,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257638',4904782,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257638',4904783,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257639',4904784,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257639',4904785,'2830','423',611791.08,617253.57,5462.49,901310.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257639',4904786,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257639',4904787,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257639',4904788,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257639',4904789,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257639',4904790,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257639',4904791,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257640',4904792,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257640',4904793,'2830','423',617253.57,622985.09,5731.52,945700.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257640',4904794,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257640',4904795,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257640',4904796,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257640',4904797,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257640',4904798,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257640',4904799,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257641',4904800,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257641',4904801,'2830','423',622985.09,628013.26,5028.17,829648.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257641',4904802,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257641',4904803,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257641',4904804,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257641',4904805,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257641',4904806,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257641',4904807,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257642',4904808,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257642',4904809,'2830','423',628013.26,632425.16,4411.90,727963.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257642',4904810,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257642',4904811,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257642',4904812,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257642',4904813,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257642',4904814,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257642',4904815,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257643',4904816,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257643',4904817,'2830','423',632425.16,638090.73,5665.57,934819.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257643',4904818,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257643',4904819,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257643',4904820,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257643',4904821,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257643',4904822,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257643',4904823,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257644',4904824,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257644',4904825,'2830','423',638090.73,644180.63,6089.90,1004833.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257644',4904826,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257644',4904827,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257644',4904828,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257644',4904829,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257644',4904830,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257644',4904831,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257645',4904832,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257645',4904833,'2830','423',644180.63,649790.79,5610.16,925676.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257645',4904834,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257645',4904835,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257645',4904836,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257645',4904837,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257645',4904838,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257645',4904839,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257646',4904840,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257646',4904841,'2830','423',649790.79,654156.18,4365.39,720289.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257646',4904842,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257646',4904843,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257646',4904844,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257646',4904845,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257646',4904846,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257646',4904847,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257647',4904848,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257647',4904849,'2830','423',654156.18,658053.70,3897.52,643090.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257647',4904850,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257647',4904851,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257647',4904852,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257647',4904853,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257647',4904854,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257647',4904855,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257648',4904856,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257648',4904857,'2830','423',658053.70,661155.07,3101.37,511726.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257648',4904858,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257648',4904859,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257648',4904860,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257648',4904861,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257648',4904862,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257648',4904863,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257649',4904864,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257649',4904865,'2830','423',661155.07,666801.69,5646.62,931692.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257649',4904866,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257649',4904867,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257649',4904868,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257649',4904869,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257649',4904870,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257649',4904871,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257650',4904872,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257650',4904873,'2830','423',666801.69,672061.29,5259.60,867834.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257650',4904874,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257650',4904875,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257650',4904876,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257650',4904877,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257650',4904878,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257650',4904879,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257651',4904880,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257651',4904881,'2830','423',672061.29,675555.54,3494.25,576551.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257651',4904882,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257651',4904883,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257651',4904884,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257651',4904885,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257651',4904886,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257651',4904887,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257652',4904888,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257652',4904889,'2830','423',675555.54,679127.95,3572.41,589447.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257652',4904890,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257652',4904891,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257652',4904892,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257652',4904893,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257652',4904894,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257652',4904895,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257653',4904896,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257653',4904897,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257653',4904898,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257653',4904899,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257653',4904900,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257653',4904901,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257653',4904902,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257653',4904903,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257654',4904904,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257654',4904905,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257654',4904906,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257654',4904907,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257654',4904908,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257654',4904909,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257654',4904910,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257654',4904911,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257655',4904912,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257655',4904913,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257655',4904914,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257655',4904915,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257655',4904916,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257655',4904917,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257655',4904918,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257655',4904919,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257656',4904920,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257656',4904921,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257656',4904922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257656',4904923,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257656',4904924,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257656',4904925,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257656',4904926,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257656',4904927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257657',4904928,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257657',4904929,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257657',4904930,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257657',4904931,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257657',4904932,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257657',4904933,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257657',4904934,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257657',4904935,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257658',4904936,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257658',4904937,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257658',4904938,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257658',4904939,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257658',4904940,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257658',4904941,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257658',4904942,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257658',4904943,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257659',4904944,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257659',4904945,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257659',4904946,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257659',4904947,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257659',4904948,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257659',4904949,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257659',4904950,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257659',4904951,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257660',4904952,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257660',4904953,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257660',4904954,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257660',4904955,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257660',4904956,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257660',4904957,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257660',4904958,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257660',4904959,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257661',4904960,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257661',4904961,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257661',4904962,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257661',4904963,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257661',4904964,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257661',4904965,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257661',4904966,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257661',4904967,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257662',4904968,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257662',4904969,'2830','423',679127.95,679127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257662',4904970,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257662',4904971,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257662',4904972,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257662',4904973,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257662',4904974,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257662',4904975,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257663',4904976,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257663',4904977,'2830','423',679127.95,685045.47,5917.52,976390.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257663',4904978,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257663',4904979,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257663',4904980,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257663',4904981,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257663',4904982,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257663',4904983,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257664',4904984,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257664',4904985,'2830','423',685045.47,690178.23,5132.76,846905.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257664',4904986,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257664',4904987,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257664',4904988,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257664',4904989,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257664',4904990,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257664',4904991,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257665',4904992,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257665',4904993,'2830','423',690178.23,694232.26,4054.03,668914.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257665',4904994,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257665',4904995,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257665',4904996,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257665',4904997,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257665',4904998,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257665',4904999,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257666',4905000,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257666',4905001,'2830','423',694232.26,697654.94,3422.68,564742.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257666',4905002,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257666',4905003,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257666',4905004,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257666',4905005,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257666',4905006,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257666',4905007,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257667',4905008,'2829','423',1231127.78,1231127.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257667',4905009,'2830','423',697654.94,702739.86,5084.92,839011.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257667',4905010,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257667',4905011,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257667',4905012,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257667',4905013,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257667',4905014,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257667',4905015,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257668',4905016,'2829','423',1231127.78,1232059.68,931.90,153763.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257668',4905017,'2830','423',702739.86,704759.75,2019.89,333281.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257668',4905018,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257668',4905019,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257668',4905020,'2833','423',771697.58,771697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257668',4905021,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257668',4905022,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257668',4905023,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257669',4905024,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257669',4905025,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257669',4905026,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257669',4905027,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257669',4905028,'2833','423',771697.58,776031.59,4334.01,715111.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257669',4905029,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257669',4905030,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257669',4905031,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257670',4905032,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257670',4905033,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257670',4905034,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257670',4905035,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257670',4905036,'2833','423',776031.59,779225.11,3193.52,526930.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257670',4905037,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257670',4905038,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257670',4905039,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257671',4905040,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257671',4905041,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257671',4905042,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257671',4905043,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257671',4905044,'2833','423',779225.11,782949.31,3724.20,614493.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257671',4905045,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257671',4905046,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257671',4905047,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257672',4905048,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257672',4905049,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257672',4905050,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257672',4905051,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257672',4905052,'2833','423',782949.31,784622.97,1673.66,276153.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257672',4905053,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257672',4905054,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257672',4905055,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257673',4905056,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257673',4905057,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257673',4905058,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257673',4905059,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257673',4905060,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257673',4905061,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257673',4905062,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257673',4905063,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257674',4905064,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257674',4905065,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257674',4905066,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257674',4905067,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257674',4905068,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257674',4905069,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257674',4905070,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257674',4905071,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257675',4905072,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257675',4905073,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257675',4905074,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257675',4905075,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257675',4905076,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257675',4905077,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257675',4905078,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257675',4905079,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257676',4905080,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257676',4905081,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257676',4905082,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257676',4905083,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257676',4905084,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257676',4905085,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257676',4905086,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257676',4905087,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257677',4905088,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257677',4905089,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257677',4905090,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257677',4905091,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257677',4905092,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257677',4905093,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257677',4905094,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257677',4905095,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257678',4905096,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257678',4905097,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257678',4905098,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257678',4905099,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257678',4905100,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257678',4905101,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257678',4905102,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257678',4905103,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257679',4905104,'2829','423',1232059.68,1232059.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257679',4905105,'2830','423',704759.75,704759.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257679',4905106,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257679',4905107,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257679',4905108,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257679',4905109,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257679',4905110,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257679',4905111,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257680',4905112,'2829','423',1232059.68,1232406.83,347.15,57279.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257680',4905113,'2830','423',704759.75,708695.60,3935.85,649415.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257680',4905114,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257680',4905115,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257680',4905116,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257680',4905117,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257680',4905118,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257680',4905119,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257681',4905120,'2829','423',1232406.83,1232406.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257681',4905121,'2830','423',708695.60,711620.14,2924.54,482549.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257681',4905122,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257681',4905123,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257681',4905124,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257681',4905125,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257681',4905126,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257681',4905127,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257682',4905128,'2829','423',1232406.83,1232406.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257682',4905129,'2830','423',711620.14,715510.75,3890.61,641950.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257682',4905130,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257682',4905131,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257682',4905132,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257682',4905133,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257682',4905134,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257682',4905135,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257683',4905136,'2829','423',1232406.83,1232582.84,176.01,29041.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257683',4905137,'2830','423',715510.75,719098.12,3587.37,591916.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257683',4905138,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257683',4905139,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257683',4905140,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257683',4905141,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257683',4905142,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257683',4905143,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257684',4905144,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257684',4905145,'2830','423',719098.12,721074.20,1976.08,326053.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257684',4905146,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257684',4905147,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257684',4905148,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257684',4905149,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257684',4905150,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257684',4905151,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257685',4905152,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257685',4905153,'2830','423',721074.20,724056.11,2981.91,551653.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257685',4905154,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257685',4905155,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257685',4905156,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257685',4905157,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257685',4905158,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257685',4905159,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257686',4905160,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257686',4905161,'2830','423',724056.11,727305.83,3249.72,601198.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257686',4905162,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257686',4905163,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257686',4905164,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257686',4905165,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257686',4905166,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257686',4905167,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257687',4905168,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257687',4905169,'2830','423',727305.83,728681.45,1375.62,254489.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257687',4905170,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257687',4905171,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257687',4905172,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257687',4905173,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257687',4905174,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257687',4905175,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257688',4905176,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257688',4905177,'2830','423',728681.45,733375.31,4693.86,868364.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257688',4905178,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257688',4905179,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257688',4905180,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257688',4905181,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257688',4905182,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257688',4905183,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257689',4905184,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257689',4905185,'2830','423',733375.31,738683.65,5308.34,982042.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257689',4905186,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257689',4905187,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257689',4905188,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257689',4905189,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257689',4905190,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257689',4905191,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257690',4905192,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257690',4905193,'2830','423',738683.65,742970.14,4286.49,793000.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257690',4905194,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257690',4905195,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257690',4905196,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257690',4905197,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257690',4905198,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257690',4905199,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257691',4905200,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257691',4905201,'2830','423',742970.14,748069.48,5099.34,943377.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257691',4905202,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257691',4905203,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257691',4905204,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257691',4905205,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257691',4905206,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257691',4905207,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257692',4905208,'2829','423',1232582.84,1232582.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257692',4905209,'2830','423',748069.48,752625.91,4556.43,842939.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257692',4905210,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257692',4905211,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257692',4905212,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257692',4905213,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257692',4905214,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257692',4905215,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257693',4905216,'2829','423',1232582.84,1236712.46,4129.62,763979.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257693',4905217,'2830','423',752625.91,757683.03,5057.12,935567.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257693',4905218,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257693',4905219,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257693',4905220,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257693',4905221,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257693',4905222,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257693',4905223,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257694',4905224,'2829','423',1236712.46,1240471.30,3758.84,695385.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257694',4905225,'2830','423',757683.03,762750.21,5067.18,937428.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257694',4905226,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257694',4905227,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257694',4905228,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257694',4905229,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257694',4905230,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257694',4905231,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257695',4905232,'2829','423',1240471.30,1240471.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257695',4905233,'2830','423',762750.21,766705.36,3955.15,731702.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257695',4905234,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257695',4905235,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257695',4905236,'2833','423',784622.97,784622.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257695',4905237,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257695',4905238,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257695',4905239,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257696',4905240,'2829','423',1240471.30,1247540.22,7068.92,1307750.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257696',4905241,'2830','423',766705.36,770290.37,3585.01,663226.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257696',4905242,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257696',4905243,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257696',4905244,'2833','423',784622.97,784774.44,151.47,28021.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257696',4905245,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257696',4905246,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257696',4905247,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257697',4905248,'2829','423',1247540.22,1253077.25,5537.03,1024350.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257697',4905249,'2830','423',770290.37,776731.82,6441.45,1191668.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257697',4905250,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257697',4905251,'2832','423',271634.85,271634.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257697',4905252,'2833','423',784774.44,784774.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257697',4905253,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257697',4905254,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257697',4905255,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257698',4905256,'2829','423',1253077.25,1253356.12,278.87,51590.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257698',4905257,'2830','423',776731.82,776731.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257698',4905258,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257698',4905259,'2832','423',271634.85,275607.50,3972.65,734940.25,0.00,0.00,0.00,0.00,0.00),('5','183','950','257698',4905260,'2833','423',784774.44,788637.47,3863.03,714660.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257698',4905261,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257698',4905262,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257698',4905263,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257699',4905264,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257699',4905265,'2830','423',776731.82,776731.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257699',4905266,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257699',4905267,'2832','423',275607.50,279420.17,3812.67,705343.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257699',4905268,'2833','423',788637.47,792567.57,3930.10,727068.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257699',4905269,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257699',4905270,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257699',4905271,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257700',4905272,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257700',4905273,'2830','423',776731.82,781099.64,4367.82,808046.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257700',4905274,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257700',4905275,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257700',4905276,'2833','423',792567.57,792567.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257700',4905277,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257700',4905278,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257700',4905279,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257701',4905280,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257701',4905281,'2830','423',781099.64,781099.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257701',4905282,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257701',4905283,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257701',4905284,'2833','423',792567.57,797569.49,5001.92,925355.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257701',4905285,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257701',4905286,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257701',4905287,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257702',4905288,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257702',4905289,'2830','423',781099.64,782301.49,1201.85,222342.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257702',4905290,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257702',4905291,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257702',4905292,'2833','423',797569.49,802120.92,4551.43,842014.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257702',4905293,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257702',4905294,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257702',4905295,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257703',4905296,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257703',4905297,'2830','423',782301.49,782301.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257703',4905298,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257703',4905299,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257703',4905300,'2833','423',802120.92,805088.78,2967.86,549054.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257703',4905301,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257703',4905302,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257703',4905303,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257704',4905304,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257704',4905305,'2830','423',782301.49,783333.36,1031.87,190895.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257704',4905306,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257704',4905307,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257704',4905308,'2833','423',805088.78,806434.44,1345.66,248947.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257704',4905309,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257704',4905310,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257704',4905311,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257705',4905312,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257705',4905313,'2830','423',783333.36,783333.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257705',4905314,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257705',4905315,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257705',4905316,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257705',4905317,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257705',4905318,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257705',4905319,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257706',4905320,'2829','423',1253356.12,1253356.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257706',4905321,'2830','423',783333.36,783333.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257706',4905322,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257706',4905323,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257706',4905324,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257706',4905325,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257706',4905326,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257706',4905327,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257707',4905328,'2829','423',1253356.12,1256150.90,2794.78,517034.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257707',4905329,'2830','423',783333.36,787310.05,3976.69,735687.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257707',4905330,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257707',4905331,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257707',4905332,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257707',4905333,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257707',4905334,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257707',4905335,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257708',4905336,'2829','423',1256150.90,1257800.56,1649.66,305187.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257708',4905337,'2830','423',787310.05,792639.31,5329.26,985913.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257708',4905338,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257708',4905339,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257708',4905340,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257708',4905341,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257708',4905342,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257708',4905343,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257709',4905344,'2829','423',1257800.56,1257951.80,151.24,27979.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257709',4905345,'2830','423',792639.31,796118.61,3479.30,643670.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257709',4905346,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257709',4905347,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257709',4905348,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257709',4905349,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257709',4905350,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257709',4905351,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257710',4905352,'2829','423',1257951.80,1259902.21,1950.41,360825.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257710',4905353,'2830','423',796118.61,798740.57,2621.96,485062.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257710',4905354,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257710',4905355,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257710',4905356,'2833','423',806434.44,806434.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257710',4905357,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257710',4905358,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257710',4905359,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257711',4905360,'2829','423',1259902.21,1259902.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257711',4905361,'2830','423',798740.57,801470.13,2729.56,504968.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257711',4905362,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257711',4905363,'2832','423',279420.17,279420.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257711',4905364,'2833','423',806434.44,809040.76,2606.32,482169.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257711',4905365,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257711',4905366,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257711',4905367,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257712',4905368,'2829','423',1259902.21,1259902.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257712',4905369,'2830','423',801470.13,802566.75,1096.62,202874.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257712',4905370,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257712',4905371,'2832','423',279420.17,279908.06,487.89,90259.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257712',4905372,'2833','423',809040.76,810779.21,1738.45,321613.25,0.00,0.00,0.00,0.00,0.00),('5','183','950','257712',4905373,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257712',4905374,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257712',4905375,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257713',4905376,'2829','423',1259902.21,1259902.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257713',4905377,'2830','423',802566.75,802566.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257713',4905378,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257713',4905379,'2832','423',279908.06,281718.01,1809.95,334840.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257713',4905380,'2833','423',810779.21,812721.72,1942.51,359364.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257713',4905381,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257713',4905382,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257713',4905383,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257714',4905384,'2829','423',1259902.21,1259902.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257714',4905385,'2830','423',802566.75,805654.16,3087.41,571170.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257714',4905386,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257714',4905387,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257714',4905388,'2833','423',812721.72,815558.01,2836.29,524713.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257714',4905389,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257714',4905390,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257714',4905391,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257715',4905392,'2829','423',1259902.21,1259902.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257715',4905393,'2830','423',805654.16,808214.83,2560.67,473723.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257715',4905394,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257715',4905395,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257715',4905396,'2833','423',815558.01,818267.36,2709.35,501229.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257715',4905397,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257715',4905398,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257715',4905399,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257716',4905400,'2829','423',1259902.21,1262603.25,2701.04,499692.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257716',4905401,'2830','423',808214.83,810859.97,2645.14,489350.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257716',4905402,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257716',4905403,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257716',4905404,'2833','423',818267.36,818267.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257716',4905405,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257716',4905406,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257716',4905407,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257717',4905408,'2829','423',1262603.25,1264849.82,2246.57,415615.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257717',4905409,'2830','423',810859.97,813182.35,2322.38,429640.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257717',4905410,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257717',4905411,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257717',4905412,'2833','423',818267.36,818267.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257717',4905413,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257717',4905414,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257717',4905415,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257718',4905416,'2829','423',1264849.82,1267658.60,2808.78,519624.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257718',4905417,'2830','423',813182.35,816040.60,2858.25,528776.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257718',4905418,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257718',4905419,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257718',4905420,'2833','423',818267.36,818267.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257718',4905421,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257718',4905422,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257718',4905423,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257719',4905424,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257719',4905425,'2830','423',816040.60,818544.72,2504.12,463262.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257719',4905426,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257719',4905427,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257719',4905428,'2833','423',818267.36,820509.20,2241.84,414740.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257719',4905429,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257719',4905430,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257719',4905431,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257720',4905432,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257720',4905433,'2830','423',818544.72,819731.46,1186.74,219546.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257720',4905434,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257720',4905435,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257720',4905436,'2833','423',820509.20,822057.60,1548.40,286454.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257720',4905437,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257720',4905438,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257720',4905439,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257721',4905440,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257721',4905441,'2830','423',819731.46,821115.40,1383.94,256028.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257721',4905442,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257721',4905443,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257721',4905444,'2833','423',822057.60,823690.51,1632.91,302088.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257721',4905445,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257721',4905446,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257721',4905447,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257722',4905448,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257722',4905449,'2830','423',821115.40,823351.18,2235.78,413619.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257722',4905450,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257722',4905451,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257722',4905452,'2833','423',823690.51,826041.67,2351.16,434964.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257722',4905453,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257722',4905454,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257722',4905455,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257723',4905456,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257723',4905457,'2830','423',823351.18,825282.56,1931.38,357305.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257723',4905458,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257723',4905459,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257723',4905460,'2833','423',826041.67,828671.59,2629.92,486535.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257723',4905461,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257723',4905462,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257723',4905463,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257724',4905464,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257724',4905465,'2830','423',825282.56,826270.91,988.35,182844.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257724',4905466,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257724',4905467,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257724',4905468,'2833','423',828671.59,830279.08,1607.49,297385.65,0.00,0.00,0.00,0.00,0.00),('5','183','950','257724',4905469,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257724',4905470,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257724',4905471,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257725',4905472,'2829','423',1267658.60,1267658.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257725',4905473,'2830','423',826270.91,828424.88,2153.97,398484.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257725',4905474,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257725',4905475,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257725',4905476,'2833','423',830279.08,832686.59,2407.51,445389.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257725',4905477,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257725',4905478,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257725',4905479,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257726',4905480,'2829','423',1267658.60,1268099.79,441.19,81620.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257726',4905481,'2830','423',828424.88,831107.44,2682.56,496273.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257726',4905482,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257726',4905483,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257726',4905484,'2833','423',832686.59,835516.67,2830.08,523564.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257726',4905485,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257726',4905486,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257726',4905487,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257727',4905488,'2829','423',1268099.79,1268099.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257727',4905489,'2830','423',831107.44,833304.92,2197.48,406533.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257727',4905490,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257727',4905491,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257727',4905492,'2833','423',835516.67,838143.43,2626.76,485950.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257727',4905493,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257727',4905494,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257727',4905495,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257728',4905496,'2829','423',1268099.79,1270731.71,2631.92,486905.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257728',4905497,'2830','423',833304.92,835457.92,2153.00,398305.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257728',4905498,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257728',4905499,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257728',4905500,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257728',4905501,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257728',4905502,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257728',4905503,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257729',4905504,'2829','423',1270731.71,1272947.65,2215.94,409948.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257729',4905505,'2830','423',835457.92,837413.54,1955.62,361789.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257729',4905506,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257729',4905507,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257729',4905508,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257729',4905509,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257729',4905510,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257729',4905511,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257730',4905512,'2829','423',1272947.65,1275204.53,2256.88,417522.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257730',4905513,'2830','423',837413.54,838490.84,1077.30,199300.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257730',4905514,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257730',4905515,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257730',4905516,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257730',4905517,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257730',4905518,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257730',4905519,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257731',4905520,'2829','423',1275204.53,1277398.36,2193.83,405858.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257731',4905521,'2830','423',838490.84,840399.10,1908.26,353028.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257731',4905522,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257731',4905523,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257731',4905524,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257731',4905525,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257731',4905526,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257731',4905527,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257732',4905528,'2829','423',1277398.36,1279205.95,1807.59,334404.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257732',4905529,'2830','423',840399.10,842270.55,1871.45,346218.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257732',4905530,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257732',4905531,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257732',4905532,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257732',4905533,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257732',4905534,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257732',4905535,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257733',4905536,'2829','423',1279205.95,1280766.16,1560.21,288638.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257733',4905537,'2830','423',842270.55,843866.57,1596.02,295263.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257733',4905538,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257733',4905539,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257733',4905540,'2833','423',838143.43,838143.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257733',4905541,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257733',4905542,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257733',4905543,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257734',4905544,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257734',4905545,'2830','423',843866.57,845183.51,1316.94,243633.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257734',4905546,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257734',4905547,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257734',4905548,'2833','423',838143.43,839734.97,1591.54,294434.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257734',4905549,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257734',4905550,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257734',4905551,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257735',4905552,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257735',4905553,'2830','423',845183.51,847294.35,2110.84,390505.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257735',4905554,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257735',4905555,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257735',4905556,'2833','423',839734.97,841751.48,2016.51,373054.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257735',4905557,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257735',4905558,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257735',4905559,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257736',4905560,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257736',4905561,'2830','423',847294.35,848768.38,1474.03,272695.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257736',4905562,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257736',4905563,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257736',4905564,'2833','423',841751.48,843759.89,2008.41,371555.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','257736',4905565,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257736',4905566,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257736',4905567,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257737',4905568,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257737',4905569,'2830','423',848768.38,850910.38,2142.00,396270.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257737',4905570,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257737',4905571,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257737',4905572,'2833','423',843759.89,845829.27,2069.38,382835.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257737',4905573,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257737',4905574,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257737',4905575,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257738',4905576,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257738',4905577,'2830','423',850910.38,852344.12,1433.74,265241.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257738',4905578,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257738',4905579,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257738',4905580,'2833','423',845829.27,847383.78,1554.51,287584.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257738',4905581,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257738',4905582,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257738',4905583,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257739',4905584,'2829','423',1280766.16,1280766.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257739',4905585,'2830','423',852344.12,854145.39,1801.27,333234.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257739',4905586,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257739',4905587,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257739',4905588,'2833','423',847383.78,849388.84,2005.06,370936.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257739',4905589,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257739',4905590,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257739',4905591,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257740',4905592,'2829','423',1280766.16,1281944.76,1178.60,218041.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257740',4905593,'2830','423',854145.39,855450.11,1304.72,241373.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257740',4905594,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257740',4905595,'2832','423',281718.01,281718.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257740',4905596,'2833','423',849388.84,850629.08,1240.24,229444.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257740',4905597,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257740',4905598,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257740',4905599,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257741',4905600,'2829','423',1281944.76,1281944.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257741',4905601,'2830','423',855450.11,858322.54,2872.43,531399.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257741',4905602,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257741',4905603,'2832','423',281718.01,284681.21,2963.20,548192.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257741',4905604,'2833','423',850629.08,850629.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257741',4905605,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257741',4905606,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257741',4905607,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257742',4905608,'2829','423',1281944.76,1281944.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257742',4905609,'2830','423',858322.54,861435.55,3113.01,575906.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257742',4905610,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257742',4905611,'2832','423',284681.21,287454.85,2773.64,513123.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257742',4905612,'2833','423',850629.08,850629.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257742',4905613,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257742',4905614,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257742',4905615,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257743',4905616,'2829','423',1281944.76,1281944.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257743',4905617,'2830','423',861435.55,861608.99,173.44,32086.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257743',4905618,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257743',4905619,'2832','423',287454.85,290145.61,2690.76,497790.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257743',4905620,'2833','423',850629.08,852466.41,1837.33,339906.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','257743',4905621,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257743',4905622,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257743',4905623,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257744',4905624,'2829','423',1281944.76,1281944.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257744',4905625,'2830','423',861608.99,861608.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257744',4905626,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257744',4905627,'2832','423',290145.61,291708.53,1562.92,289140.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257744',4905628,'2833','423',852466.41,854495.56,2029.15,375392.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257744',4905629,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257744',4905630,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257744',4905631,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257745',4905632,'2829','423',1281944.76,1281944.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257745',4905633,'2830','423',861608.99,861608.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257745',4905634,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257745',4905635,'2832','423',291708.53,293349.77,1641.24,303629.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257745',4905636,'2833','423',854495.56,855976.91,1481.35,274049.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257745',4905637,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257745',4905638,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257745',4905639,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257746',4905640,'2829','423',1281944.76,1283751.10,1806.34,334172.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257746',4905641,'2830','423',861608.99,863317.68,1708.69,316107.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257746',4905642,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257746',4905643,'2832','423',293349.77,293349.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257746',4905644,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257746',4905645,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257746',4905646,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257746',4905647,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257747',4905648,'2829','423',1283751.10,1284569.15,818.05,151339.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257747',4905649,'2830','423',863317.68,863793.62,475.94,88048.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257747',4905650,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257747',4905651,'2832','423',293349.77,293349.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257747',4905652,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257747',4905653,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257747',4905654,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257747',4905655,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257748',4905656,'2829','423',1284569.15,1286050.25,1481.10,274003.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257748',4905657,'2830','423',863793.62,865836.51,2042.89,377934.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257748',4905658,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257748',4905659,'2832','423',293349.77,293349.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257748',4905660,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257748',4905661,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257748',4905662,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257748',4905663,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257749',4905664,'2829','423',1286050.25,1286643.84,593.59,109814.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257749',4905665,'2830','423',865836.51,866997.66,1161.15,214812.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257749',4905666,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257749',4905667,'2832','423',293349.77,293916.73,566.96,104887.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257749',4905668,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257749',4905669,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257749',4905670,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257749',4905671,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257750',4905672,'2829','423',1286643.84,1287659.50,1015.66,187897.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257750',4905673,'2830','423',866997.66,868743.63,1745.97,323004.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257750',4905674,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257750',4905675,'2832','423',293916.73,295072.90,1156.17,213891.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','257750',4905676,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257750',4905677,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257750',4905678,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257750',4905679,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257751',4905680,'2829','423',1287659.50,1289746.67,2087.17,386126.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257751',4905681,'2830','423',868743.63,870876.24,2132.61,394532.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257751',4905682,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257751',4905683,'2832','423',295072.90,295072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257751',4905684,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257751',4905685,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257751',4905686,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257751',4905687,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257752',4905688,'2829','423',1289746.67,1291741.46,1994.79,369036.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257752',4905689,'2830','423',870876.24,871885.98,1009.74,186801.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257752',4905690,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257752',4905691,'2832','423',295072.90,295072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257752',4905692,'2833','423',855976.91,855976.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257752',4905693,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257752',4905694,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257752',4905695,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257753',4905696,'2829','423',1291741.46,1293097.14,1355.68,250800.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257753',4905697,'2830','423',871885.98,872367.98,482.00,89170.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257753',4905698,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257753',4905699,'2832','423',295072.90,295436.44,363.54,67254.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257753',4905700,'2833','423',855976.91,857145.88,1168.97,216259.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','257753',4905701,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257753',4905702,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257753',4905703,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257754',4905704,'2829','423',1293097.14,1295699.30,2602.16,481399.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257754',4905705,'2830','423',872367.98,874561.67,2193.69,405832.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257754',4905706,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257754',4905707,'2832','423',295436.44,295436.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257754',4905708,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257754',4905709,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257754',4905710,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257754',4905711,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257755',4905712,'2829','423',1295699.30,1297371.12,1671.82,309286.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257755',4905713,'2830','423',874561.67,875669.36,1107.69,204922.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257755',4905714,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257755',4905715,'2832','423',295436.44,296340.03,903.59,167164.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','257755',4905716,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257755',4905717,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257755',4905718,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257755',4905719,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257756',4905720,'2829','423',1297371.12,1298770.44,1399.32,258874.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257756',4905721,'2830','423',875669.36,876904.86,1235.50,228567.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257756',4905722,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257756',4905723,'2832','423',296340.03,297132.15,792.12,146542.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257756',4905724,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257756',4905725,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257756',4905726,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257756',4905727,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257757',4905728,'2829','423',1298770.44,1300059.97,1289.53,238563.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257757',4905729,'2830','423',876904.86,877932.59,1027.73,190130.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257757',4905730,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257757',4905731,'2832','423',297132.15,298053.11,920.96,170377.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257757',4905732,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257757',4905733,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257757',4905734,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257757',4905735,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257758',4905736,'2829','423',1300059.97,1302324.16,2264.19,418875.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257758',4905737,'2830','423',877932.59,879492.89,1560.30,288655.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257758',4905738,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257758',4905739,'2832','423',298053.11,298505.51,452.40,83694.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257758',4905740,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257758',4905741,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257758',4905742,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257758',4905743,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257759',4905744,'2829','423',1302324.16,1304065.70,1741.54,322184.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257759',4905745,'2830','423',879492.89,879492.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257759',4905746,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257759',4905747,'2832','423',298505.51,300394.35,1888.84,349435.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257759',4905748,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257759',4905749,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257759',4905750,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257759',4905751,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257760',4905752,'2829','423',1304065.70,1305492.47,1426.77,263952.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257760',4905753,'2830','423',879492.89,880850.06,1357.17,251076.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257760',4905754,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257760',4905755,'2832','423',300394.35,300394.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257760',4905756,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257760',4905757,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257760',4905758,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257760',4905759,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257761',4905760,'2829','423',1305492.47,1308741.14,3248.67,601003.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257761',4905761,'2830','423',880850.06,882015.19,1165.13,215549.05,0.00,0.00,0.00,0.00,0.00),('5','183','949','257761',4905762,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257761',4905763,'2832','423',300394.35,302767.18,2372.83,438973.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257761',4905764,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257761',4905765,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257761',4905766,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257761',4905767,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257762',4905768,'2829','423',1308741.14,1311081.42,2340.28,432951.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257762',4905769,'2830','423',882015.19,882437.11,421.92,78055.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257762',4905770,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257762',4905771,'2832','423',302767.18,304282.98,1515.80,280423.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257762',4905772,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257762',4905773,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257762',4905774,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257762',4905775,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257763',4905776,'2829','423',1311081.42,1313463.24,2381.82,440636.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257763',4905777,'2830','423',882437.11,882976.85,539.74,99851.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257763',4905778,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257763',4905779,'2832','423',304282.98,306499.38,2216.40,410034.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257763',4905780,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257763',4905781,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257763',4905782,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257763',4905783,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257764',4905784,'2829','423',1313463.24,1315809.80,2346.56,434113.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257764',4905785,'2830','423',882976.85,883572.17,595.32,110134.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257764',4905786,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257764',4905787,'2832','423',306499.38,309183.96,2684.58,496647.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257764',4905788,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257764',4905789,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257764',4905790,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257764',4905791,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257765',4905792,'2829','423',1315809.80,1319002.29,3192.49,590610.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257765',4905793,'2830','423',883572.17,886070.78,2498.61,462242.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257765',4905794,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257765',4905795,'2832','423',309183.96,309183.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257765',4905796,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257765',4905797,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257765',4905798,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257765',4905799,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257766',4905800,'2829','423',1319002.29,1321512.84,2510.55,464451.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257766',4905801,'2830','423',886070.78,888539.76,2468.98,456761.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257766',4905802,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257766',4905803,'2832','423',309183.96,309183.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257766',4905804,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257766',4905805,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257766',4905806,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257766',4905807,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257767',4905808,'2829','423',1321512.84,1324040.32,2527.48,467583.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257767',4905809,'2830','423',888539.76,890939.66,2399.90,443981.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257767',4905810,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257767',4905811,'2832','423',309183.96,309183.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257767',4905812,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257767',4905813,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257767',4905814,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257767',4905815,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257768',4905816,'2829','423',1324040.32,1327043.77,3003.45,555638.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257768',4905817,'2830','423',890939.66,893857.86,2918.20,539867.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257768',4905818,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257768',4905819,'2832','423',309183.96,309534.53,350.57,64855.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','257768',4905820,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257768',4905821,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257768',4905822,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257768',4905823,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257769',4905824,'2829','423',1327043.77,1329996.83,2953.06,546316.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257769',4905825,'2830','423',893857.86,896026.58,2168.72,401213.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257769',4905826,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257769',4905827,'2832','423',309534.53,309534.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257769',4905828,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257769',4905829,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257769',4905830,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257769',4905831,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257770',4905832,'2829','423',1329996.83,1331239.07,1242.24,229814.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257770',4905833,'2830','423',896026.58,897598.94,1572.36,290886.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257770',4905834,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257770',4905835,'2832','423',309534.53,310740.44,1205.91,223093.35,0.00,0.00,0.00,0.00,0.00),('5','183','950','257770',4905836,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257770',4905837,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257770',4905838,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257770',4905839,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257771',4905840,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257771',4905841,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257771',4905842,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257771',4905843,'2832','423',310740.44,316373.07,5632.63,1042036.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257771',4905844,'2833','423',857145.88,857145.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257771',4905845,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257771',4905846,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257771',4905847,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257772',4905848,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257772',4905849,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257772',4905850,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257772',4905851,'2832','423',316373.07,321110.03,4736.96,876337.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257772',4905852,'2833','423',857145.88,857688.55,542.67,100393.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257772',4905853,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257772',4905854,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257772',4905855,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257773',4905856,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257773',4905857,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257773',4905858,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257773',4905859,'2832','423',321110.03,327674.49,6564.46,1214425.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257773',4905860,'2833','423',857688.55,857688.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257773',4905861,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257773',4905862,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257773',4905863,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257774',4905864,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257774',4905865,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257774',4905866,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257774',4905867,'2832','423',327674.49,332600.90,4926.41,911385.85,0.00,0.00,0.00,0.00,0.00),('5','183','950','257774',4905868,'2833','423',857688.55,859214.37,1525.82,282276.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257774',4905869,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257774',4905870,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257774',4905871,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257775',4905872,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257775',4905873,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257775',4905874,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257775',4905875,'2832','423',332600.90,338041.27,5440.37,1006468.45,0.00,0.00,0.00,0.00,0.00),('5','183','950','257775',4905876,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257775',4905877,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257775',4905878,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257775',4905879,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257776',4905880,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257776',4905881,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257776',4905882,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257776',4905883,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257776',4905884,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257776',4905885,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257776',4905886,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257776',4905887,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257777',4905888,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257777',4905889,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257777',4905890,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257777',4905891,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257777',4905892,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257777',4905893,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257777',4905894,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257777',4905895,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257778',4905896,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257778',4905897,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257778',4905898,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257778',4905899,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257778',4905900,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257778',4905901,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257778',4905902,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257778',4905903,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257779',4905904,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257779',4905905,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257779',4905906,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257779',4905907,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257779',4905908,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257779',4905909,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257779',4905910,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257779',4905911,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257780',4905912,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257780',4905913,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257780',4905914,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257780',4905915,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257780',4905916,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257780',4905917,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257780',4905918,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257780',4905919,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257781',4905920,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257781',4905921,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257781',4905922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257781',4905923,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257781',4905924,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257781',4905925,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257781',4905926,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257781',4905927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257782',4905928,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257782',4905929,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257782',4905930,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257782',4905931,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257782',4905932,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257782',4905933,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257782',4905934,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257782',4905935,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257783',4905936,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257783',4905937,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257783',4905938,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257783',4905939,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257783',4905940,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257783',4905941,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257783',4905942,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257783',4905943,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257784',4905944,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257784',4905945,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257784',4905946,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257784',4905947,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257784',4905948,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257784',4905949,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257784',4905950,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257784',4905951,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257785',4905952,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257785',4905953,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257785',4905954,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257785',4905955,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257785',4905956,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257785',4905957,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257785',4905958,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257785',4905959,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257786',4905960,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257786',4905961,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257786',4905962,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257786',4905963,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257786',4905964,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257786',4905965,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257786',4905966,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257786',4905967,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257787',4905968,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257787',4905969,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257787',4905970,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257787',4905971,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257787',4905972,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257787',4905973,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257787',4905974,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257787',4905975,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257788',4905976,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257788',4905977,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257788',4905978,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257788',4905979,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257788',4905980,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257788',4905981,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257788',4905982,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257788',4905983,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257789',4905984,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257789',4905985,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257789',4905986,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257789',4905987,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257789',4905988,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257789',4905989,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257789',4905990,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257789',4905991,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257790',4905992,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257790',4905993,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257790',4905994,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257790',4905995,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257790',4905996,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257790',4905997,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257790',4905998,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257790',4905999,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257791',4906000,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257791',4906001,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257791',4906002,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257791',4906003,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257791',4906004,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257791',4906005,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257791',4906006,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257791',4906007,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257792',4906008,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257792',4906009,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257792',4906010,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257792',4906011,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257792',4906012,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257792',4906013,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257792',4906014,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257792',4906015,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257793',4906016,'2829','423',1331239.07,1331239.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257793',4906017,'2830','423',897598.94,897598.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257793',4906018,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257793',4906019,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257793',4906020,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257793',4906021,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257793',4906022,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257793',4906023,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257794',4906024,'2829','423',1331239.07,1335815.18,4576.11,846580.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257794',4906025,'2830','423',897598.94,901773.83,4174.89,772354.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257794',4906026,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257794',4906027,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257794',4906028,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257794',4906029,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257794',4906030,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257794',4906031,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257795',4906032,'2829','423',1335815.18,1339871.05,4055.87,750335.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257795',4906033,'2830','423',901773.83,908999.52,7225.69,1336752.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257795',4906034,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257795',4906035,'2832','423',338041.27,338041.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257795',4906036,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257795',4906037,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257795',4906038,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257795',4906039,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257796',4906040,'2829','423',1339871.05,1339871.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257796',4906041,'2830','423',908999.52,913293.57,4294.05,794399.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257796',4906042,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257796',4906043,'2832','423',338041.27,344351.57,6310.30,1167405.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257796',4906044,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257796',4906045,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257796',4906046,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257796',4906047,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257797',4906048,'2829','423',1339871.05,1339871.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257797',4906049,'2830','423',913293.57,919882.25,6588.68,1218905.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257797',4906050,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257797',4906051,'2832','423',344351.57,348222.61,3871.04,716142.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257797',4906052,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257797',4906053,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257797',4906054,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257797',4906055,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257798',4906056,'2829','423',1339871.05,1347919.74,8048.69,1489007.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257798',4906057,'2830','423',919882.25,923146.91,3264.66,603962.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257798',4906058,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257798',4906059,'2832','423',348222.61,348222.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257798',4906060,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257798',4906061,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257798',4906062,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257798',4906063,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257799',4906064,'2829','423',1347919.74,1349588.52,1668.78,308724.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257799',4906065,'2830','423',923146.91,928498.65,5351.74,990071.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257799',4906066,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257799',4906067,'2832','423',348222.61,354503.80,6281.19,1162020.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','257799',4906068,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257799',4906069,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257799',4906070,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257799',4906071,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257800',4906072,'2829','423',1349588.52,1349588.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257800',4906073,'2830','423',928498.65,937525.35,9026.70,1669939.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257800',4906074,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257800',4906075,'2832','423',354503.80,360002.80,5499.00,1017315.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257800',4906076,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257800',4906077,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257800',4906078,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257800',4906079,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257801',4906080,'2829','423',1349588.52,1349588.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257801',4906081,'2830','423',937525.35,946939.92,9414.57,1741695.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257801',4906082,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257801',4906083,'2832','423',360002.80,364578.73,4575.93,846547.05,0.00,0.00,0.00,0.00,0.00),('5','183','950','257801',4906084,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257801',4906085,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257801',4906086,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257801',4906087,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257802',4906088,'2829','423',1349588.52,1349588.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257802',4906089,'2830','423',946939.92,954163.38,7223.46,1336340.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257802',4906090,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257802',4906091,'2832','423',364578.73,370100.40,5521.67,1021508.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257802',4906092,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257802',4906093,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257802',4906094,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257802',4906095,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257803',4906096,'2829','423',1349588.52,1349588.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257803',4906097,'2830','423',954163.38,959094.92,4931.54,912334.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257803',4906098,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257803',4906099,'2832','423',370100.40,373889.70,3789.30,701020.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257803',4906100,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257803',4906101,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257803',4906102,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257803',4906103,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257804',4906104,'2829','423',1349588.52,1349588.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257804',4906105,'2830','423',959094.92,960118.50,1023.58,189362.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257804',4906106,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257804',4906107,'2832','423',373889.70,377904.53,4014.83,742743.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257804',4906108,'2833','423',859214.37,859214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257804',4906109,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257804',4906110,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257804',4906111,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257805',4906112,'2829','423',1349588.52,1353166.79,3578.27,661979.95,0.00,0.00,0.00,0.00,0.00),('5','183','949','257805',4906113,'2830','423',960118.50,961389.95,1271.45,235218.25,0.00,0.00,0.00,0.00,0.00),('5','183','949','257805',4906114,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257805',4906115,'2832','423',377904.53,378430.49,525.96,97302.60,0.00,0.00,0.00,0.00,0.00),('5','183','950','257805',4906116,'2833','423',859214.37,859692.36,477.99,88428.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','257805',4906117,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257805',4906118,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257805',4906119,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257806',4906120,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257806',4906121,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257806',4906122,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257806',4906123,'2832','423',378430.49,381627.56,3197.07,591457.95,0.00,0.00,0.00,0.00,0.00),('5','183','950','257806',4906124,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257806',4906125,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257806',4906126,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257806',4906127,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257807',4906128,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257807',4906129,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257807',4906130,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257807',4906131,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257807',4906132,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257807',4906133,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257807',4906134,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257807',4906135,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257808',4906136,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257808',4906137,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257808',4906138,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257808',4906139,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257808',4906140,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257808',4906141,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257808',4906142,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257808',4906143,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257809',4906144,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257809',4906145,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257809',4906146,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257809',4906147,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257809',4906148,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257809',4906149,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257809',4906150,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257809',4906151,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257810',4906152,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257810',4906153,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257810',4906154,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257810',4906155,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257810',4906156,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257810',4906157,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257810',4906158,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257810',4906159,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257811',4906160,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257811',4906161,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257811',4906162,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257811',4906163,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257811',4906164,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257811',4906165,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257811',4906166,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257811',4906167,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257812',4906168,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257812',4906169,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257812',4906170,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257812',4906171,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257812',4906172,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257812',4906173,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257812',4906174,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257812',4906175,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257813',4906176,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257813',4906177,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257813',4906178,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257813',4906179,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257813',4906180,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257813',4906181,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257813',4906182,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257813',4906183,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257814',4906184,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257814',4906185,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257814',4906186,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257814',4906187,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257814',4906188,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257814',4906189,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257814',4906190,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257814',4906191,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257815',4906192,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257815',4906193,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257815',4906194,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257815',4906195,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257815',4906196,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257815',4906197,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257815',4906198,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257815',4906199,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257816',4906200,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257816',4906201,'2830','423',961389.95,961389.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257816',4906202,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257816',4906203,'2832','423',381627.56,381627.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257816',4906204,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257816',4906205,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257816',4906206,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257816',4906207,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257817',4906208,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257817',4906209,'2830','423',961389.95,968036.81,6646.86,1229669.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257817',4906210,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257817',4906211,'2832','423',381627.56,386961.48,5333.92,986775.20,0.00,0.00,0.00,0.00,0.00),('5','183','950','257817',4906212,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257817',4906213,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257817',4906214,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257817',4906215,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257818',4906216,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257818',4906217,'2830','423',968036.81,972759.38,4722.57,873675.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257818',4906218,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257818',4906219,'2832','423',386961.48,392476.03,5514.55,1020191.75,0.00,0.00,0.00,0.00,0.00),('5','183','950','257818',4906220,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257818',4906221,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257818',4906222,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257818',4906223,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257819',4906224,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257819',4906225,'2830','423',972759.38,976599.88,3840.50,710492.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257819',4906226,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257819',4906227,'2832','423',392476.03,397018.26,4542.23,840312.55,0.00,0.00,0.00,0.00,0.00),('5','183','950','257819',4906228,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257819',4906229,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257819',4906230,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257819',4906231,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257820',4906232,'2829','423',1353166.79,1353166.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257820',4906233,'2830','423',976599.88,984970.79,8370.91,1548618.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257820',4906234,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257820',4906235,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257820',4906236,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257820',4906237,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257820',4906238,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257820',4906239,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257821',4906240,'2829','423',1353166.79,1357677.18,4510.39,834422.15,0.00,0.00,0.00,0.00,0.00),('5','183','949','257821',4906241,'2830','423',984970.79,986317.96,1347.17,249226.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257821',4906242,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257821',4906243,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257821',4906244,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257821',4906245,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257821',4906246,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257821',4906247,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257822',4906248,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257822',4906249,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257822',4906250,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257822',4906251,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257822',4906252,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257822',4906253,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257822',4906254,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257822',4906255,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257823',4906256,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257823',4906257,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257823',4906258,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257823',4906259,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257823',4906260,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257823',4906261,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257823',4906262,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257823',4906263,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257824',4906264,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257824',4906265,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257824',4906266,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257824',4906267,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257824',4906268,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257824',4906269,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257824',4906270,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257824',4906271,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257825',4906272,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257825',4906273,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257825',4906274,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257825',4906275,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257825',4906276,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257825',4906277,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257825',4906278,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257825',4906279,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257826',4906280,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257826',4906281,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257826',4906282,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257826',4906283,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257826',4906284,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257826',4906285,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257826',4906286,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257826',4906287,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257827',4906288,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257827',4906289,'2830','423',986317.96,986317.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257827',4906290,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257827',4906291,'2832','423',397018.26,397018.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257827',4906292,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257827',4906293,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257827',4906294,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257827',4906295,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257828',4906296,'2829','423',1357677.18,1357677.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257828',4906297,'2830','423',986317.96,993580.73,7262.77,1343612.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257828',4906298,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257828',4906299,'2832','423',397018.26,401455.85,4437.59,820954.15,0.00,0.00,0.00,0.00,0.00),('5','183','950','257828',4906300,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257828',4906301,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257828',4906302,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257828',4906303,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257829',4906304,'2829','423',1357677.18,1363387.59,5710.41,1056425.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257829',4906305,'2830','423',993580.73,998030.43,4449.70,823194.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257829',4906306,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257829',4906307,'2832','423',401455.85,401455.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257829',4906308,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257829',4906309,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257829',4906310,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257829',4906311,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257830',4906312,'2829','423',1363387.59,1365327.10,1939.51,358809.35,0.00,0.00,0.00,0.00,0.00),('5','183','949','257830',4906313,'2830','423',998030.43,998030.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257830',4906314,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257830',4906315,'2832','423',401455.85,410553.29,9097.44,1683026.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257830',4906316,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257830',4906317,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257830',4906318,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257830',4906319,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257831',4906320,'2829','423',1365327.10,1365327.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257831',4906321,'2830','423',998030.43,1008841.58,10811.15,2000062.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257831',4906322,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257831',4906323,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257831',4906324,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257831',4906325,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257831',4906326,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257831',4906327,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257832',4906328,'2829','423',1365327.10,1365327.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257832',4906329,'2830','423',1008841.58,1022514.00,13672.42,2529397.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257832',4906330,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257832',4906331,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257832',4906332,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257832',4906333,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257832',4906334,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257832',4906335,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257833',4906336,'2829','423',1365327.10,1368505.25,3178.15,587957.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257833',4906337,'2830','423',1022514.00,1031354.55,8840.55,1635501.75,0.00,0.00,0.00,0.00,0.00),('5','183','949','257833',4906338,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257833',4906339,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257833',4906340,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257833',4906341,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257833',4906342,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257833',4906343,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257834',4906344,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257834',4906345,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257834',4906346,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257834',4906347,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257834',4906348,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257834',4906349,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257834',4906350,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257834',4906351,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257835',4906352,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257835',4906353,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257835',4906354,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257835',4906355,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257835',4906356,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257835',4906357,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257835',4906358,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257835',4906359,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257836',4906360,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257836',4906361,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257836',4906362,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257836',4906363,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257836',4906364,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257836',4906365,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257836',4906366,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257836',4906367,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257837',4906368,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257837',4906369,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257837',4906370,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257837',4906371,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257837',4906372,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257837',4906373,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257837',4906374,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257837',4906375,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257838',4906376,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257838',4906377,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257838',4906378,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257838',4906379,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257838',4906380,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257838',4906381,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257838',4906382,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257838',4906383,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257839',4906384,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257839',4906385,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257839',4906386,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257839',4906387,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257839',4906388,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257839',4906389,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257839',4906390,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257839',4906391,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257840',4906392,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257840',4906393,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257840',4906394,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257840',4906395,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257840',4906396,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257840',4906397,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257840',4906398,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257840',4906399,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257841',4906400,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257841',4906401,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257841',4906402,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257841',4906403,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257841',4906404,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257841',4906405,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257841',4906406,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257841',4906407,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257842',4906408,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257842',4906409,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257842',4906410,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257842',4906411,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257842',4906412,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257842',4906413,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257842',4906414,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257842',4906415,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257843',4906416,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257843',4906417,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257843',4906418,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257843',4906419,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257843',4906420,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257843',4906421,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257843',4906422,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257843',4906423,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257844',4906424,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257844',4906425,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257844',4906426,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257844',4906427,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257844',4906428,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257844',4906429,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257844',4906430,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257844',4906431,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257845',4906432,'2829','423',1368505.25,1368505.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257845',4906433,'2830','423',1031354.55,1031354.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257845',4906434,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257845',4906435,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257845',4906436,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257845',4906437,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257845',4906438,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257845',4906439,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257846',4906440,'2829','423',1368505.25,1372628.29,4123.04,762762.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257846',4906441,'2830','423',1031354.55,1039193.61,7839.06,1450226.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257846',4906442,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257846',4906443,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257846',4906444,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257846',4906445,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257846',4906446,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257846',4906447,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257847',4906448,'2829','423',1372628.29,1383168.99,10540.70,1950029.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257847',4906449,'2830','423',1039193.61,1041752.22,2558.61,473342.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257847',4906450,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257847',4906451,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257847',4906452,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257847',4906453,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257847',4906454,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257847',4906455,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257848',4906456,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257848',4906457,'2830','423',1041752.22,1046537.85,4785.63,885341.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257848',4906458,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257848',4906459,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257848',4906460,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257848',4906461,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257848',4906462,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257848',4906463,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257849',4906464,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257849',4906465,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257849',4906466,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257849',4906467,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257849',4906468,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257849',4906469,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257849',4906470,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257849',4906471,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257850',4906472,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257850',4906473,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257850',4906474,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257850',4906475,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257850',4906476,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257850',4906477,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257850',4906478,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257850',4906479,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257851',4906480,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257851',4906481,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257851',4906482,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257851',4906483,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257851',4906484,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257851',4906485,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257851',4906486,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257851',4906487,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257852',4906488,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257852',4906489,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257852',4906490,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257852',4906491,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257852',4906492,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257852',4906493,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257852',4906494,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257852',4906495,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257853',4906496,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257853',4906497,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257853',4906498,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257853',4906499,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257853',4906500,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257853',4906501,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257853',4906502,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257853',4906503,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257854',4906504,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257854',4906505,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257854',4906506,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257854',4906507,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257854',4906508,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257854',4906509,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257854',4906510,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257854',4906511,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257855',4906512,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257855',4906513,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257855',4906514,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257855',4906515,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257855',4906516,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257855',4906517,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257855',4906518,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257855',4906519,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257856',4906520,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257856',4906521,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257856',4906522,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257856',4906523,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257856',4906524,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257856',4906525,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257856',4906526,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257856',4906527,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257857',4906528,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257857',4906529,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257857',4906530,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257857',4906531,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257857',4906532,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257857',4906533,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257857',4906534,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257857',4906535,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257858',4906536,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257858',4906537,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257858',4906538,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257858',4906539,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257858',4906540,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257858',4906541,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257858',4906542,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257858',4906543,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257859',4906544,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257859',4906545,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257859',4906546,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257859',4906547,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257859',4906548,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257859',4906549,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257859',4906550,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257859',4906551,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257860',4906552,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257860',4906553,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257860',4906554,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257860',4906555,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257860',4906556,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257860',4906557,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257860',4906558,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257860',4906559,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257861',4906560,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257861',4906561,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257861',4906562,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257861',4906563,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257861',4906564,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257861',4906565,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257861',4906566,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257861',4906567,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257862',4906568,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257862',4906569,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257862',4906570,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257862',4906571,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257862',4906572,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257862',4906573,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257862',4906574,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257862',4906575,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257863',4906576,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257863',4906577,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257863',4906578,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257863',4906579,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257863',4906580,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257863',4906581,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257863',4906582,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257863',4906583,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257864',4906584,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257864',4906585,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257864',4906586,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257864',4906587,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257864',4906588,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257864',4906589,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257864',4906590,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257864',4906591,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257865',4906592,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257865',4906593,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257865',4906594,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257865',4906595,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257865',4906596,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257865',4906597,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257865',4906598,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257865',4906599,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257866',4906600,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257866',4906601,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257866',4906602,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257866',4906603,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257866',4906604,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257866',4906605,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257866',4906606,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257866',4906607,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257867',4906608,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257867',4906609,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257867',4906610,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257867',4906611,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257867',4906612,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257867',4906613,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257867',4906614,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257867',4906615,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257868',4906616,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257868',4906617,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257868',4906618,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257868',4906619,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257868',4906620,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257868',4906621,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257868',4906622,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257868',4906623,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257869',4906624,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257869',4906625,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257869',4906626,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257869',4906627,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257869',4906628,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257869',4906629,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257869',4906630,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257869',4906631,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257870',4906632,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257870',4906633,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257870',4906634,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257870',4906635,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257870',4906636,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257870',4906637,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257870',4906638,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257870',4906639,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257871',4906640,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257871',4906641,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257871',4906642,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257871',4906643,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257871',4906644,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257871',4906645,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257871',4906646,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257871',4906647,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257872',4906648,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257872',4906649,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257872',4906650,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257872',4906651,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257872',4906652,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257872',4906653,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257872',4906654,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257872',4906655,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257873',4906656,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257873',4906657,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257873',4906658,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257873',4906659,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257873',4906660,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257873',4906661,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257873',4906662,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257873',4906663,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257874',4906664,'2829','423',1383168.99,1383168.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257874',4906665,'2830','423',1046537.85,1046537.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257874',4906666,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257874',4906667,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257874',4906668,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257874',4906669,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257874',4906670,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257874',4906671,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257875',4906672,'2829','423',1383168.99,1388420.00,5251.01,971436.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257875',4906673,'2830','423',1046537.85,1051883.74,5345.89,988989.65,0.00,0.00,0.00,0.00,0.00),('5','183','949','257875',4906674,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257875',4906675,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257875',4906676,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257875',4906677,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257875',4906678,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257875',4906679,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257876',4906680,'2829','423',1388420.00,1393163.94,4743.94,877628.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257876',4906681,'2830','423',1051883.74,1063010.66,11126.92,2058480.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257876',4906682,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257876',4906683,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257876',4906684,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257876',4906685,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257876',4906686,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257876',4906687,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257877',4906688,'2829','423',1393163.94,1395833.97,2670.03,493955.55,0.00,0.00,0.00,0.00,0.00),('5','183','949','257877',4906689,'2830','423',1063010.66,1063722.87,712.21,131758.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257877',4906690,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257877',4906691,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257877',4906692,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257877',4906693,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257877',4906694,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257877',4906695,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257878',4906696,'2829','423',1395833.97,1395833.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257878',4906697,'2830','423',1063722.87,1063722.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257878',4906698,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257878',4906699,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257878',4906700,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257878',4906701,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257878',4906702,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257878',4906703,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257879',4906704,'2829','423',1395833.97,1395833.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257879',4906705,'2830','423',1063722.87,1063722.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257879',4906706,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257879',4906707,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257879',4906708,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257879',4906709,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257879',4906710,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257879',4906711,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257880',4906712,'2829','423',1395833.97,1399602.39,3768.42,697157.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257880',4906713,'2830','423',1063722.87,1065404.64,1681.77,311127.45,0.00,0.00,0.00,0.00,0.00),('5','183','949','257880',4906714,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257880',4906715,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257880',4906716,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257880',4906717,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257880',4906718,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257880',4906719,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257881',4906720,'2829','423',1399602.39,1401911.17,2308.78,427124.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257881',4906721,'2830','423',1065404.64,1072244.25,6839.61,1265327.85,0.00,0.00,0.00,0.00,0.00),('5','183','949','257881',4906722,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257881',4906723,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257881',4906724,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257881',4906725,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257881',4906726,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257881',4906727,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257882',4906728,'2829','423',1401911.17,1401911.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257882',4906729,'2830','423',1072244.25,1076145.67,3901.42,858312.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257882',4906730,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257882',4906731,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257882',4906732,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257882',4906733,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257882',4906734,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257882',4906735,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257883',4906736,'2829','423',1401911.17,1401911.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257883',4906737,'2830','423',1076145.67,1076145.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257883',4906738,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257883',4906739,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257883',4906740,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257883',4906741,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257883',4906742,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257883',4906743,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257884',4906744,'2829','423',1401911.17,1401911.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257884',4906745,'2830','423',1076145.67,1076145.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257884',4906746,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257884',4906747,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257884',4906748,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257884',4906749,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257884',4906750,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257884',4906751,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257885',4906752,'2829','423',1401911.17,1404281.99,2370.82,521580.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257885',4906753,'2830','423',1076145.67,1083014.22,6868.55,1511081.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257885',4906754,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257885',4906755,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257885',4906756,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257885',4906757,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257885',4906758,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257885',4906759,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257886',4906760,'2829','423',1404281.99,1405709.79,1427.80,314116.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257886',4906761,'2830','423',1083014.22,1085847.02,2832.80,623216.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257886',4906762,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257886',4906763,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257886',4906764,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257886',4906765,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257886',4906766,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257886',4906767,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257887',4906768,'2829','423',1405709.79,1405709.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257887',4906769,'2830','423',1085847.02,1085847.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257887',4906770,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257887',4906771,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257887',4906772,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257887',4906773,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257887',4906774,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257887',4906775,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257888',4906776,'2829','423',1405709.79,1405709.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257888',4906777,'2830','423',1085847.02,1085847.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257888',4906778,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257888',4906779,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257888',4906780,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257888',4906781,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257888',4906782,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257888',4906783,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257889',4906784,'2829','423',1405709.79,1405709.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257889',4906785,'2830','423',1085847.02,1085847.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257889',4906786,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257889',4906787,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257889',4906788,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257889',4906789,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257889',4906790,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257889',4906791,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257890',4906792,'2829','423',1405709.79,1405709.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257890',4906793,'2830','423',1085847.02,1085847.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257890',4906794,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257890',4906795,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257890',4906796,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257890',4906797,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257890',4906798,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257890',4906799,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257891',4906800,'2829','423',1405709.79,1410042.17,4332.38,953123.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257891',4906801,'2830','423',1085847.02,1093717.21,7870.19,1731441.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257891',4906802,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257891',4906803,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257891',4906804,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257891',4906805,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257891',4906806,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257891',4906807,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257892',4906808,'2829','423',1410042.17,1413718.49,3676.32,808790.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257892',4906809,'2830','423',1093717.21,1100338.32,6621.11,1456644.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257892',4906810,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257892',4906811,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257892',4906812,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257892',4906813,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257892',4906814,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257892',4906815,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257893',4906816,'2829','423',1413718.49,1413718.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257893',4906817,'2830','423',1100338.32,1100338.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257893',4906818,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257893',4906819,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257893',4906820,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257893',4906821,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257893',4906822,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257893',4906823,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257894',4906824,'2829','423',1413718.49,1413718.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257894',4906825,'2830','423',1100338.32,1100338.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257894',4906826,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257894',4906827,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257894',4906828,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257894',4906829,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257894',4906830,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257894',4906831,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257895',4906832,'2829','423',1413718.49,1413718.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257895',4906833,'2830','423',1100338.32,1100338.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257895',4906834,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257895',4906835,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257895',4906836,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257895',4906837,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257895',4906838,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257895',4906839,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257896',4906840,'2829','423',1413718.49,1416943.90,3225.41,709590.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257896',4906841,'2830','423',1100338.32,1108876.86,8538.54,1878478.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257896',4906842,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257896',4906843,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257896',4906844,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257896',4906845,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257896',4906846,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257896',4906847,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257897',4906848,'2829','423',1416943.90,1418263.24,1319.34,290254.80,0.00,0.00,0.00,0.00,0.00),('5','183','949','257897',4906849,'2830','423',1108876.86,1110793.57,1916.71,421676.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257897',4906850,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257897',4906851,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257897',4906852,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257897',4906853,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257897',4906854,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257897',4906855,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257898',4906856,'2829','423',1418263.24,1418991.22,727.98,160155.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257898',4906857,'2830','423',1110793.57,1116423.49,5629.92,1238582.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257898',4906858,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257898',4906859,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257898',4906860,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257898',4906861,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257898',4906862,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257898',4906863,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257899',4906864,'2829','423',1418991.22,1420583.93,1592.71,350396.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257899',4906865,'2830','423',1116423.49,1124342.61,7919.12,1742206.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257899',4906866,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257899',4906867,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257899',4906868,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257899',4906869,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257899',4906870,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257899',4906871,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257900',4906872,'2829','423',1420583.93,1422189.84,1605.91,353300.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257900',4906873,'2830','423',1124342.61,1125466.97,1124.36,247359.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257900',4906874,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257900',4906875,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257900',4906876,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257900',4906877,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257900',4906878,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257900',4906879,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257901',4906880,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257901',4906881,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257901',4906882,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257901',4906883,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257901',4906884,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257901',4906885,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257901',4906886,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257901',4906887,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257902',4906888,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257902',4906889,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257902',4906890,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257902',4906891,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257902',4906892,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257902',4906893,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257902',4906894,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257902',4906895,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257903',4906896,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257903',4906897,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257903',4906898,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257903',4906899,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257903',4906900,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257903',4906901,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257903',4906902,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257903',4906903,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257904',4906904,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257904',4906905,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257904',4906906,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257904',4906907,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257904',4906908,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257904',4906909,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257904',4906910,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257904',4906911,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257905',4906912,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257905',4906913,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257905',4906914,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257905',4906915,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257905',4906916,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257905',4906917,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257905',4906918,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257905',4906919,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257906',4906920,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257906',4906921,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257906',4906922,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257906',4906923,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257906',4906924,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257906',4906925,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257906',4906926,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257906',4906927,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257907',4906928,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257907',4906929,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257907',4906930,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257907',4906931,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257907',4906932,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257907',4906933,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257907',4906934,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257907',4906935,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257908',4906936,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257908',4906937,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257908',4906938,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257908',4906939,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257908',4906940,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257908',4906941,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257908',4906942,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257908',4906943,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257909',4906944,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257909',4906945,'2830','423',1125466.97,1125466.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257909',4906946,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257909',4906947,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257909',4906948,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257909',4906949,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257909',4906950,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257909',4906951,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257910',4906952,'2829','423',1422189.84,1422189.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257910',4906953,'2830','423',1125466.97,1129751.87,4284.90,942678.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257910',4906954,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257910',4906955,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257910',4906956,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257910',4906957,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257910',4906958,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257910',4906959,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257911',4906960,'2829','423',1422189.84,1425066.28,2876.44,604052.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257911',4906961,'2830','423',1129751.87,1136983.89,7232.02,1518724.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257911',4906962,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257911',4906963,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257911',4906964,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257911',4906965,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257911',4906966,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257911',4906967,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257912',4906968,'2829','423',1425066.28,1431008.04,5941.76,1247769.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257912',4906969,'2830','423',1136983.89,1141371.70,4387.81,921440.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257912',4906970,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257912',4906971,'2832','423',410553.29,410553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257912',4906972,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257912',4906973,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257912',4906974,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257912',4906975,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257913',4906976,'2829','423',1431008.04,1435626.18,4618.14,969809.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257913',4906977,'2830','423',1141371.70,1149271.99,7900.29,1659060.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257913',4906978,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257913',4906979,'2832','423',410553.29,411641.17,1087.88,228454.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257913',4906980,'2833','423',859692.36,859692.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257913',4906981,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257913',4906982,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257913',4906983,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257914',4906984,'2829','423',1435626.18,1437075.25,1449.07,304304.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257914',4906985,'2830','423',1149271.99,1155811.04,6539.05,1373200.50,0.00,0.00,0.00,0.00,0.00),('5','183','949','257914',4906986,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257914',4906987,'2832','423',411641.17,415336.75,3695.58,776071.80,0.00,0.00,0.00,0.00,0.00),('5','183','950','257914',4906988,'2833','423',859692.36,859899.75,207.39,43551.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257914',4906989,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257914',4906990,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257914',4906991,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257915',4906992,'2829','423',1437075.25,1437789.82,714.57,150059.70,0.00,0.00,0.00,0.00,0.00),('5','183','949','257915',4906993,'2830','423',1155811.04,1158835.27,3024.23,635088.30,0.00,0.00,0.00,0.00,0.00),('5','183','949','257915',4906994,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257915',4906995,'2832','423',415336.75,421565.44,6228.69,1308024.90,0.00,0.00,0.00,0.00,0.00),('5','183','950','257915',4906996,'2833','423',859899.75,860588.08,688.33,144549.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257915',4906997,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257915',4906998,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257915',4906999,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257916',4907000,'2829','423',1437789.82,1443140.72,5350.90,1123689.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257916',4907001,'2830','423',1158835.27,1163783.83,4948.56,1039197.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257916',4907002,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257916',4907003,'2832','423',421565.44,422209.04,643.60,135156.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257916',4907004,'2833','423',860588.08,860588.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257916',4907005,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257916',4907006,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257916',4907007,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257917',4907008,'2829','423',1443140.72,1443140.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257917',4907009,'2830','423',1163783.83,1170085.75,6301.92,1323403.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257917',4907010,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257917',4907011,'2832','423',422209.04,429274.89,7065.85,1483828.50,0.00,0.00,0.00,0.00,0.00),('5','183','950','257917',4907012,'2833','423',860588.08,860783.15,195.07,40964.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257917',4907013,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257917',4907014,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257917',4907015,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257918',4907016,'2829','423',1443140.72,1446085.08,2944.36,618315.60,0.00,0.00,0.00,0.00,0.00),('5','183','949','257918',4907017,'2830','423',1170085.75,1175945.79,5860.04,1230608.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257918',4907018,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257918',4907019,'2832','423',429274.89,433542.99,4268.10,896301.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257918',4907020,'2833','423',860783.15,860968.86,185.71,38999.10,0.00,0.00,0.00,0.00,0.00),('5','183','950','257918',4907021,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257918',4907022,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257918',4907023,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257919',4907024,'2829','423',1446085.08,1451841.99,5756.91,1208951.10,0.00,0.00,0.00,0.00,0.00),('5','183','949','257919',4907025,'2830','423',1175945.79,1182457.28,6511.49,1367412.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257919',4907026,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257919',4907027,'2832','423',433542.99,434814.42,1271.43,267000.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257919',4907028,'2833','423',860968.86,860968.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257919',4907029,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257919',4907030,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257919',4907031,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257920',4907032,'2829','423',1451841.99,1451841.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257920',4907033,'2830','423',1182457.28,1184030.58,1573.30,330393.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257920',4907034,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257920',4907035,'2832','423',434814.42,439510.16,4695.74,986105.40,0.00,0.00,0.00,0.00,0.00),('5','183','950','257920',4907036,'2833','423',860968.86,860968.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257920',4907037,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257920',4907038,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257920',4907039,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257921',4907040,'2829','423',1451841.99,1459261.08,7419.09,1558008.90,0.00,0.00,0.00,0.00,0.00),('5','183','949','257921',4907041,'2830','423',1184030.58,1189834.92,5804.34,1218911.40,0.00,0.00,0.00,0.00,0.00),('5','183','949','257921',4907042,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257921',4907043,'2832','423',439510.16,440514.53,1004.37,210917.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257921',4907044,'2833','423',860968.86,860968.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257921',4907045,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257921',4907046,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257921',4907047,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257922',4907048,'2829','423',1459261.08,1463317.00,4055.92,851743.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257922',4907049,'2830','423',1189834.92,1198838.34,9003.42,1890718.20,0.00,0.00,0.00,0.00,0.00),('5','183','949','257922',4907050,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257922',4907051,'2832','423',440514.53,440514.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257922',4907052,'2833','423',860968.86,862414.49,1445.63,303582.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257922',4907053,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257922',4907054,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257922',4907055,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257923',4907056,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257923',4907057,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257923',4907058,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257923',4907059,'2832','423',440514.53,451527.80,11013.27,2312786.70,0.00,0.00,0.00,0.00,0.00),('5','183','950','257923',4907060,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257923',4907061,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257923',4907062,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257923',4907063,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257924',4907064,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257924',4907065,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257924',4907066,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257924',4907067,'2832','423',451527.80,453632.13,2104.33,441909.30,0.00,0.00,0.00,0.00,0.00),('5','183','950','257924',4907068,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257924',4907069,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257924',4907070,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257924',4907071,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257925',4907072,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257925',4907073,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257925',4907074,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257925',4907075,'2832','423',453632.13,453632.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257925',4907076,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257925',4907077,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257925',4907078,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257925',4907079,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257926',4907080,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257926',4907081,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257926',4907082,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257926',4907083,'2832','423',453632.13,453632.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257926',4907084,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257926',4907085,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257926',4907086,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257926',4907087,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257927',4907088,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257927',4907089,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257927',4907090,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257927',4907091,'2832','423',453632.13,453632.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257927',4907092,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257927',4907093,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257927',4907094,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257927',4907095,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257928',4907096,'2829','423',1463317.00,1463317.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257928',4907097,'2830','423',1198838.34,1198838.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','949','257928',4907098,'2831','423',4410.65,4410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257928',4907099,'2832','423',453632.13,453632.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257928',4907100,'2833','423',862414.49,862414.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','950','257928',4907101,'2834','423',549579.73,549579.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','951','257928',4907102,'2835','424',252894.75,252894.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','183','952','257928',4907103,'2836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730912 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','183','213186','423',162.00,162.00,5045.73,0.00,0.00,0.00,0.00,614538),('5','183','213186','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614539),('5','183','213186','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614540),('5','183','213196','423',162.00,162.00,6035.07,0.00,0.00,0.00,0.00,614568),('5','183','213196','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614569),('5','183','213196','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614570),('5','183','213211','423',162.00,162.00,5517.52,0.00,0.00,0.00,0.00,614605),('5','183','213211','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614606),('5','183','213211','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614607),('5','183','213222','423',162.00,162.00,3954.74,0.00,0.00,0.00,0.00,614635),('5','183','213222','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614636),('5','183','213222','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614637),('5','183','213550','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,615498),('5','183','213550','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615499),('5','183','213550','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615500),('5','183','213559','423',162.00,162.00,5130.77,0.00,0.00,0.00,0.00,615520),('5','183','213559','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615521),('5','183','213559','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615522),('5','183','213561','423',162.00,162.00,5453.56,0.00,0.00,0.00,0.00,615526),('5','183','213561','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615527),('5','183','213561','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615528),('5','183','214867','423',162.00,162.00,5186.53,0.00,0.00,0.00,0.00,618922),('5','183','214867','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618923),('5','183','214867','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618924),('5','183','214872','423',162.00,162.00,5486.13,0.00,0.00,0.00,0.00,618934),('5','183','214872','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618935),('5','183','214872','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618936),('5','183','214877','423',162.00,162.00,4790.04,0.00,0.00,0.00,0.00,618946),('5','183','214877','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618947),('5','183','214877','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618948),('5','183','214880','423',162.00,162.00,4587.11,0.00,0.00,0.00,0.00,618955),('5','183','214880','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618956),('5','183','214880','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618957),('5','183','214888','423',162.00,162.00,4686.42,0.00,0.00,0.00,0.00,618977),('5','183','214888','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618978),('5','183','214888','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618979),('5','183','214891','423',162.00,162.00,2704.82,0.00,0.00,0.00,0.00,618984),('5','183','214891','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618985),('5','183','214891','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618986),('5','183','216433','423',162.00,162.00,4430.67,0.00,0.00,0.00,0.00,622969),('5','183','216433','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622970),('5','183','216433','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622971),('5','183','216438','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,622983),('5','183','216438','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622984),('5','183','216438','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622985),('5','183','216440','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,622989),('5','183','216440','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622990),('5','183','216440','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622991),('5','183','216448','423',162.00,162.00,3871.04,0.00,0.00,0.00,0.00,623010),('5','183','216448','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,623011),('5','183','216448','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623012),('5','183','216453','423',162.00,162.00,5624.37,0.00,0.00,0.00,0.00,623024),('5','183','216453','424',295.00,295.00,848.60,0.00,0.00,0.00,0.00,623025),('5','183','216453','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623026),('5','183','216523','423',162.00,162.00,6250.31,0.00,0.00,0.00,0.00,623225),('5','183','216523','424',295.00,295.00,186.50,0.00,0.00,0.00,0.00,623226),('5','183','216523','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623227),('5','183','216841','423',162.00,162.00,3854.09,0.00,0.00,0.00,0.00,624041),('5','183','216841','424',295.00,295.00,87.74,0.00,0.00,0.00,0.00,624042),('5','183','216841','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624043),('5','183','216860','423',162.00,162.00,5364.11,0.00,0.00,0.00,0.00,624097),('5','183','216860','424',295.00,295.00,128.19,0.00,0.00,0.00,0.00,624098),('5','183','216860','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624099),('5','183','216932','423',162.00,162.00,4463.88,0.00,0.00,0.00,0.00,624294),('5','183','216932','424',295.00,295.00,224.92,0.00,0.00,0.00,0.00,624295),('5','183','216932','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624296),('5','183','216939','423',162.00,162.00,4522.89,0.00,0.00,0.00,0.00,624312),('5','183','216939','424',295.00,295.00,179.97,0.00,0.00,0.00,0.00,624313),('5','183','216939','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624314),('5','183','217029','423',162.00,162.00,4811.49,0.00,0.00,0.00,0.00,624534),('5','183','217029','424',295.00,295.00,213.29,0.00,0.00,0.00,0.00,624535),('5','183','217029','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624536),('5','183','217488','423',162.00,162.00,5392.98,0.00,0.00,0.00,0.00,625757),('5','183','217488','424',295.00,295.00,191.60,0.00,0.00,0.00,0.00,625758),('5','183','217488','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625759),('5','183','217682','423',162.00,162.00,5184.26,0.00,0.00,0.00,0.00,626259),('5','183','217682','424',295.00,295.00,498.62,0.00,0.00,0.00,0.00,626260),('5','183','217682','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626261),('5','183','217933','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,626918),('5','183','217933','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,626919),('5','183','217933','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626920),('5','183','217939','423',162.00,162.00,4360.52,0.00,0.00,0.00,0.00,626936),('5','183','217939','424',295.00,295.00,185.10,0.00,0.00,0.00,0.00,626937),('5','183','217939','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626938),('5','183','217963','423',162.00,162.00,6021.83,0.00,0.00,0.00,0.00,626999),('5','183','217963','424',295.00,295.00,258.76,0.00,0.00,0.00,0.00,627000),('5','183','217963','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627001),('5','183','218167','423',162.00,162.00,4187.95,0.00,0.00,0.00,0.00,627530),('5','183','218167','424',295.00,295.00,202.77,0.00,0.00,0.00,0.00,627531),('5','183','218167','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627532),('5','183','218303','423',162.00,162.00,4622.02,0.00,0.00,0.00,0.00,627882),('5','183','218303','424',295.00,295.00,131.35,0.00,0.00,0.00,0.00,627883),('5','183','218303','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627884),('5','183','218661','423',162.00,162.00,5134.10,0.00,0.00,0.00,0.00,628825),('5','183','218661','424',295.00,295.00,194.80,0.00,0.00,0.00,0.00,628826),('5','183','218661','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628827),('5','183','218772','423',162.00,162.00,2077.91,0.00,0.00,0.00,0.00,629093),('5','183','218772','424',295.00,295.00,600.00,0.00,0.00,0.00,0.00,629094),('5','183','218772','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629095),('5','183','219102','423',162.00,162.00,5257.94,0.00,0.00,0.00,0.00,629973),('5','183','219102','424',295.00,295.00,773.50,0.00,0.00,0.00,0.00,629974),('5','183','219102','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629975),('5','183','219318','423',162.00,162.00,5168.53,0.00,0.00,0.00,0.00,630542),('5','183','219318','424',295.00,295.00,368.29,0.00,0.00,0.00,0.00,630543),('5','183','219318','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630544),('5','183','219437','423',162.00,162.00,5103.05,0.00,0.00,0.00,0.00,630839),('5','183','219437','424',295.00,295.00,181.12,0.00,0.00,0.00,0.00,630840),('5','183','219437','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630841),('5','183','219597','423',162.00,162.00,4763.22,0.00,0.00,0.00,0.00,631263),('5','183','219597','424',295.00,295.00,263.12,0.00,0.00,0.00,0.00,631264),('5','183','219597','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631265),('5','183','219825','423',162.00,162.00,4883.86,0.00,0.00,0.00,0.00,631851),('5','183','219825','424',295.00,295.00,1248.81,0.00,0.00,0.00,0.00,631852),('5','183','219825','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631853),('5','183','220143','423',162.00,162.00,4649.00,0.00,0.00,0.00,0.00,632711),('5','183','220143','424',295.00,295.00,575.70,0.00,0.00,0.00,0.00,632712),('5','183','220143','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632713),('5','183','220481','423',162.00,162.00,5623.72,0.00,0.00,0.00,0.00,633587),('5','183','220481','424',295.00,295.00,313.59,0.00,0.00,0.00,0.00,633588),('5','183','220481','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633589),('5','183','220491','423',162.00,162.00,4836.08,0.00,0.00,0.00,0.00,633616),('5','183','220491','424',295.00,295.00,769.55,0.00,0.00,0.00,0.00,633617),('5','183','220491','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633618),('5','183','220753','423',162.00,162.00,5462.54,0.00,0.00,0.00,0.00,634300),('5','183','220753','424',295.00,295.00,623.48,0.00,0.00,0.00,0.00,634301),('5','183','220753','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634302),('5','183','221041','423',162.00,162.00,5103.66,0.00,0.00,0.00,0.00,635047),('5','183','221041','424',295.00,295.00,274.52,0.00,0.00,0.00,0.00,635048),('5','183','221041','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635049),('5','183','221237','423',162.00,162.00,4867.13,0.00,0.00,0.00,0.00,635559),('5','183','221237','424',295.00,295.00,180.47,0.00,0.00,0.00,0.00,635560),('5','183','221237','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635561),('5','183','221375','423',162.00,162.00,5300.94,0.00,0.00,0.00,0.00,635931),('5','183','221375','424',295.00,295.00,263.43,0.00,0.00,0.00,0.00,635932),('5','183','221375','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635933),('5','183','221646','423',162.00,162.00,5499.66,0.00,0.00,0.00,0.00,636621),('5','183','221646','424',295.00,295.00,572.37,0.00,0.00,0.00,0.00,636622),('5','183','221646','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636623),('5','183','222045','423',162.00,162.00,4973.73,0.00,0.00,0.00,0.00,637682),('5','183','222045','424',295.00,295.00,231.73,0.00,0.00,0.00,0.00,637683),('5','183','222045','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637684),('5','183','222266','423',162.00,162.00,5644.39,0.00,0.00,0.00,0.00,638230),('5','183','222266','424',295.00,295.00,200.68,0.00,0.00,0.00,0.00,638231),('5','183','222266','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638232),('5','183','222479','423',162.00,162.00,5956.65,0.00,0.00,0.00,0.00,638784),('5','183','222479','424',295.00,295.00,865.59,0.00,0.00,0.00,0.00,638785),('5','183','222479','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638786),('5','183','222729','423',162.00,162.00,5311.37,0.00,0.00,0.00,0.00,639438),('5','183','222729','424',295.00,295.00,344.45,0.00,0.00,0.00,0.00,639439),('5','183','222729','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639440),('5','183','222746','423',162.00,162.00,3670.09,0.00,0.00,0.00,0.00,639477),('5','183','222746','424',295.00,295.00,245.33,0.00,0.00,0.00,0.00,639478),('5','183','222746','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639479),('5','183','223182','423',162.00,162.00,4951.01,0.00,0.00,0.00,0.00,640629),('5','183','223182','424',295.00,295.00,193.54,0.00,0.00,0.00,0.00,640630),('5','183','223182','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640631),('5','183','223344','423',162.00,162.00,5018.03,0.00,0.00,0.00,0.00,641029),('5','183','223344','424',295.00,295.00,178.90,0.00,0.00,0.00,0.00,641030),('5','183','223344','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641031),('5','183','223657','423',162.00,162.00,2238.70,0.00,0.00,0.00,0.00,641813),('5','183','223657','424',295.00,295.00,364.91,0.00,0.00,0.00,0.00,641814),('5','183','223657','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641815),('5','183','223871','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,642375),('5','183','223871','424',295.00,295.00,212.24,0.00,0.00,0.00,0.00,642376),('5','183','223871','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642377),('5','183','224081','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,642919),('5','183','224081','424',295.00,295.00,534.39,0.00,0.00,0.00,0.00,642920),('5','183','224081','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642921),('5','183','224297','423',162.00,162.00,0.00,0.00,0.00,0.00,0.00,643484),('5','183','224297','424',295.00,295.00,186.00,0.00,0.00,0.00,0.00,643485),('5','183','224297','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643486),('5','183','224515','423',162.00,162.00,4396.01,0.00,0.00,0.00,0.00,644069),('5','183','224515','424',295.00,295.00,239.01,0.00,0.00,0.00,0.00,644070),('5','183','224515','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644071),('5','183','224759','423',162.00,162.00,4620.82,0.00,0.00,0.00,0.00,644691),('5','183','224759','424',295.00,295.00,244.79,0.00,0.00,0.00,0.00,644692),('5','183','224759','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644693),('5','183','224839','423',162.00,162.00,4707.62,0.00,0.00,0.00,0.00,644876),('5','183','224839','424',295.00,295.00,167.94,0.00,0.00,0.00,0.00,644877),('5','183','224839','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644878),('5','183','225195','423',162.00,162.00,5531.92,0.00,0.00,0.00,0.00,645807),('5','183','225195','424',295.00,295.00,215.83,0.00,0.00,0.00,0.00,645808),('5','183','225195','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645809),('5','183','225433','423',162.00,162.00,4995.38,0.00,0.00,0.00,0.00,646419),('5','183','225433','424',295.00,295.00,536.90,0.00,0.00,0.00,0.00,646420),('5','183','225433','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646421),('5','183','225669','423',162.00,162.00,4928.94,0.00,0.00,0.00,0.00,647035),('5','183','225669','424',295.00,295.00,274.40,0.00,0.00,0.00,0.00,647036),('5','183','225669','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647037),('5','183','225921','423',162.00,162.00,6042.67,0.00,0.00,0.00,0.00,647703),('5','183','225921','424',295.00,295.00,283.83,0.00,0.00,0.00,0.00,647704),('5','183','225921','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647705),('5','183','226274','423',162.00,162.00,4249.68,0.00,0.00,0.00,0.00,648600),('5','183','226274','424',295.00,295.00,823.02,0.00,0.00,0.00,0.00,648601),('5','183','226274','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648602),('5','183','226287','423',162.00,162.00,5162.94,0.00,0.00,0.00,0.00,648629),('5','183','226287','424',295.00,295.00,338.39,0.00,0.00,0.00,0.00,648630),('5','183','226287','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648631),('5','183','226521','423',162.00,162.00,5264.48,0.00,0.00,0.00,0.00,649216),('5','183','226521','424',295.00,295.00,345.77,0.00,0.00,0.00,0.00,649217),('5','183','226521','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649218),('5','183','226791','423',162.00,162.00,4951.47,0.00,0.00,0.00,0.00,649923),('5','183','226791','424',295.00,295.00,298.80,0.00,0.00,0.00,0.00,649924),('5','183','226791','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649925),('5','183','226951','423',162.00,162.00,5219.67,0.00,0.00,0.00,0.00,650355),('5','183','226951','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650356),('5','183','226951','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650357),('5','183','227222','423',162.00,162.00,5446.93,0.00,0.00,0.00,0.00,651045),('5','183','227222','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651046),('5','183','227222','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651047),('5','183','227384','423',162.00,162.00,5156.27,0.00,0.00,0.00,0.00,651457),('5','183','227384','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651458),('5','183','227384','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651459),('5','183','227706','423',162.00,162.00,5911.78,0.00,0.00,0.00,0.00,652292),('5','183','227706','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652293),('5','183','227706','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652294),('5','183','227903','423',162.00,162.00,5477.46,0.00,0.00,0.00,0.00,652804),('5','183','227903','424',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652805),('5','183','227903','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652806),('5','183','232977','423',162.00,162.00,5891.04,0.00,0.00,0.00,0.00,666071),('5','183','232977','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666072),('5','183','232977','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666073),('5','183','233176','423',162.00,162.00,6938.60,0.00,0.00,0.00,0.00,666573),('5','183','233176','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666574),('5','183','233176','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666575),('5','183','233186','423',162.00,162.00,6508.00,0.00,0.00,0.00,0.00,666603),('5','183','233186','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666604),('5','183','233186','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666605),('5','183','233191','423',162.00,162.00,6083.99,0.00,0.00,0.00,0.00,666617),('5','183','233191','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666618),('5','183','233191','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666619),('5','183','233206','423',162.00,162.00,6333.97,0.00,0.00,0.00,0.00,666661),('5','183','233206','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666662),('5','183','233206','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666663),('5','183','233212','423',162.00,162.00,6113.13,0.00,0.00,0.00,0.00,666676),('5','183','233212','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666677),('5','183','233212','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666678),('5','183','233219','423',162.00,162.00,6796.25,0.00,0.00,0.00,0.00,666699),('5','183','233219','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666700),('5','183','233219','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666701),('5','183','233222','423',162.00,162.00,6905.88,0.00,0.00,0.00,0.00,666708),('5','183','233222','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666709),('5','183','233222','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666710),('5','183','233227','423',162.00,162.00,6918.58,0.00,0.00,0.00,0.00,666723),('5','183','233227','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666724),('5','183','233227','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666725),('5','183','233370','423',162.00,162.00,6866.28,0.00,0.00,0.00,0.00,667089),('5','183','233370','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,667090),('5','183','233370','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667091),('5','183','233615','423',162.00,162.00,5035.67,0.00,0.00,0.00,0.00,667725),('5','183','233615','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,667726),('5','183','233615','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667727),('5','183','234164','423',162.00,162.00,5368.74,0.00,0.00,0.00,0.00,669176),('5','183','234164','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,669177),('5','183','234164','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669178),('5','183','234307','423',162.00,162.00,7144.70,0.00,0.00,0.00,0.00,669557),('5','183','234307','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,669558),('5','183','234307','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669559),('5','183','234561','423',162.00,162.00,776.65,0.00,0.00,0.00,0.00,670236),('5','183','234561','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,670237),('5','183','234561','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670238),('5','183','234628','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,670396),('5','183','234628','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,670397),('5','183','234628','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670398),('5','183','234935','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671226),('5','183','234935','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,671227),('5','183','234935','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671228),('5','183','235278','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672141),('5','183','235278','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,672142),('5','183','235278','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672143),('5','183','235493','423',165.00,165.00,4784.91,0.00,0.00,0.00,0.00,672688),('5','183','235493','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,672689),('5','183','235493','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672690),('5','183','235725','423',165.00,165.00,7514.94,0.00,0.00,0.00,0.00,673292),('5','183','235725','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,673293),('5','183','235725','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673294),('5','183','235935','423',165.00,165.00,1023.90,0.00,0.00,0.00,0.00,673837),('5','183','235935','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,673838),('5','183','235935','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673839),('5','183','236229','423',165.00,165.00,4185.57,0.00,0.00,0.00,0.00,674618),('5','183','236229','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,674619),('5','183','236229','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674620),('5','183','236481','423',165.00,165.00,7699.21,0.00,0.00,0.00,0.00,675290),('5','183','236481','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,675291),('5','183','236481','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675292),('5','183','236727','423',165.00,165.00,6765.83,0.00,0.00,0.00,0.00,675914),('5','183','236727','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,675915),('5','183','236727','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675916),('5','183','237020','423',165.00,165.00,5855.80,0.00,0.00,0.00,0.00,676662),('5','183','237020','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,676663),('5','183','237020','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676664),('5','183','237420','423',165.00,165.00,1819.66,0.00,0.00,0.00,0.00,677688),('5','183','237420','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,677689),('5','183','237420','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677690),('5','183','237638','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678259),('5','183','237638','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,678260),('5','183','237638','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678261),('5','183','237723','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678485),('5','183','237723','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,678486),('5','183','237723','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678487),('5','183','237938','423',165.00,165.00,7585.29,0.00,0.00,0.00,0.00,679042),('5','183','237938','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,679043),('5','183','237938','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679044),('5','183','238211','423',165.00,165.00,7151.62,0.00,0.00,0.00,0.00,679744),('5','183','238211','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,679745),('5','183','238211','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679746),('5','183','238428','423',165.00,165.00,10024.26,0.00,0.00,0.00,0.00,680303),('5','183','238428','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,680304),('5','183','238428','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680305),('5','183','238727','423',165.00,165.00,10000.43,0.00,0.00,0.00,0.00,681089),('5','183','238727','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,681090),('5','183','238727','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681091),('5','183','239031','423',165.00,165.00,11371.69,0.00,0.00,0.00,0.00,681890),('5','183','239031','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,681891),('5','183','239031','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681892),('5','183','239144','423',165.00,165.00,17032.01,0.00,0.00,0.00,0.00,682168),('5','183','239144','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,682169),('5','183','239144','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682170),('5','183','239353','423',165.00,165.00,9928.12,0.00,0.00,0.00,0.00,682709),('5','183','239353','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,682710),('5','183','239353','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682711),('5','183','239678','423',165.00,165.00,8408.53,0.00,0.00,0.00,0.00,683569),('5','183','239678','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,683570),('5','183','239678','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683571),('5','183','239922','423',165.00,165.00,5767.95,0.00,0.00,0.00,0.00,684203),('5','183','239922','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,684204),('5','183','239922','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684205),('5','183','240073','423',165.00,165.00,4582.79,0.00,0.00,0.00,0.00,684583),('5','183','240073','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,684584),('5','183','240073','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684585),('5','183','240218','423',165.00,165.00,4999.73,0.00,0.00,0.00,0.00,684952),('5','183','240218','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,684953),('5','183','240218','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684954),('5','183','240675','423',165.00,165.00,5381.98,0.00,0.00,0.00,0.00,686121),('5','183','240675','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,686122),('5','183','240675','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686123),('5','183','240781','423',165.00,165.00,5658.71,0.00,0.00,0.00,0.00,686378),('5','183','240781','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,686379),('5','183','240781','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686380),('5','183','241039','423',165.00,165.00,6819.51,0.00,0.00,0.00,0.00,687073),('5','183','241039','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,687074),('5','183','241039','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687075),('5','183','241510','423',165.00,165.00,6295.73,0.00,0.00,0.00,0.00,688321),('5','183','241510','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,688322),('5','183','241510','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688323),('5','183','241735','423',165.00,165.00,10637.79,0.00,0.00,0.00,0.00,688918),('5','183','241735','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,688919),('5','183','241735','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688920),('5','183','241844','423',165.00,165.00,6544.45,0.00,0.00,0.00,0.00,689200),('5','183','241844','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,689201),('5','183','241844','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689202),('5','183','242124','423',165.00,165.00,5145.68,0.00,0.00,0.00,0.00,689932),('5','183','242124','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,689933),('5','183','242124','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689934),('5','183','242398','423',165.00,165.00,1459.61,0.00,0.00,0.00,0.00,690652),('5','183','242398','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,690653),('5','183','242398','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690654),('5','183','242683','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691372),('5','183','242683','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,691373),('5','183','242683','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691374),('5','183','242832','423',165.00,165.00,2335.82,0.00,0.00,0.00,0.00,691775),('5','183','242832','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,691776),('5','183','242832','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691777),('5','183','243124','423',165.00,165.00,5624.38,0.00,0.00,0.00,0.00,692543),('5','183','243124','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,692544),('5','183','243124','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692545),('5','183','243239','423',165.00,165.00,8547.38,0.00,0.00,0.00,0.00,692825),('5','183','243239','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,692826),('5','183','243239','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692827),('5','183','243803','423',165.00,165.00,5983.76,0.00,0.00,0.00,0.00,694312),('5','183','243803','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,694313),('5','183','243803','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694314),('5','183','244159','423',165.00,165.00,9620.25,0.00,0.00,0.00,0.00,695202),('5','183','244159','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,695203),('5','183','244159','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695204),('5','183','244208','423',165.00,165.00,8324.21,0.00,0.00,0.00,0.00,695348),('5','183','244208','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,695349),('5','183','244208','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695350),('5','183','244237','423',165.00,165.00,8795.86,0.00,0.00,0.00,0.00,695431),('5','183','244237','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,695432),('5','183','244237','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695433),('5','183','244370','423',165.00,165.00,5940.14,0.00,0.00,0.00,0.00,695763),('5','183','244370','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,695764),('5','183','244370','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695765),('5','183','244652','423',165.00,165.00,5074.17,0.00,0.00,0.00,0.00,696505),('5','183','244652','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,696506),('5','183','244652','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696507),('5','183','245007','423',165.00,165.00,6876.83,0.00,0.00,0.00,0.00,697412),('5','183','245007','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,697413),('5','183','245007','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697414),('5','183','245151','423',165.00,165.00,5152.98,0.00,0.00,0.00,0.00,697800),('5','183','245151','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,697801),('5','183','245151','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697802),('5','183','245437','423',165.00,165.00,1839.51,0.00,0.00,0.00,0.00,698531),('5','183','245437','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,698532),('5','183','245437','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698533),('5','183','245653','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699103),('5','183','245653','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,699104),('5','183','245653','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699105),('5','183','245918','423',165.00,165.00,1688.82,0.00,0.00,0.00,0.00,699797),('5','183','245918','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,699798),('5','183','245918','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699799),('5','183','246058','423',165.00,165.00,5509.79,0.00,0.00,0.00,0.00,700144),('5','183','246058','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,700145),('5','183','246058','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700146),('5','183','246364','423',165.00,165.00,5349.70,0.00,0.00,0.00,0.00,700957),('5','183','246364','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,700958),('5','183','246364','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700959),('5','183','246586','423',165.00,165.00,5688.32,0.00,0.00,0.00,0.00,701529),('5','183','246586','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,701530),('5','183','246586','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701531),('5','183','246949','423',165.00,165.00,6352.85,0.00,0.00,0.00,0.00,702457),('5','183','246949','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,702458),('5','183','246949','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702459),('5','183','247067','423',165.00,165.00,6627.54,0.00,0.00,0.00,0.00,702761),('5','183','247067','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,702762),('5','183','247067','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702763),('5','183','247369','423',165.00,165.00,9008.90,0.00,0.00,0.00,0.00,703557),('5','183','247369','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,703558),('5','183','247369','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703559),('5','183','247686','423',165.00,165.00,4443.30,0.00,0.00,0.00,0.00,704363),('5','183','247686','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,704364),('5','183','247686','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704365),('5','183','247909','423',165.00,165.00,4415.13,0.00,0.00,0.00,0.00,704947),('5','183','247909','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,704948),('5','183','247909','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704949),('5','183','248159','423',165.00,165.00,3623.35,0.00,0.00,0.00,0.00,705590),('5','183','248159','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,705591),('5','183','248159','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705592),('5','183','248298','423',165.00,165.00,1410.14,0.00,0.00,0.00,0.00,705955),('5','183','248298','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,705956),('5','183','248298','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705957),('5','183','248630','423',165.00,165.00,4397.37,0.00,0.00,0.00,0.00,706813),('5','183','248630','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,706814),('5','183','248630','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706815),('5','183','248991','423',165.00,165.00,6214.06,0.00,0.00,0.00,0.00,707732),('5','183','248991','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,707733),('5','183','248991','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707734),('5','183','249120','423',165.00,165.00,5716.46,0.00,0.00,0.00,0.00,708051),('5','183','249120','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,708052),('5','183','249120','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708053),('5','183','249432','423',165.00,165.00,6064.18,0.00,0.00,0.00,0.00,708844),('5','183','249432','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,708845),('5','183','249432','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708846),('5','183','249666','423',165.00,165.00,3924.72,0.00,0.00,0.00,0.00,709444),('5','183','249666','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,709445),('5','183','249666','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709446),('5','183','249922','423',165.00,165.00,1518.86,0.00,0.00,0.00,0.00,710102),('5','183','249922','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,710103),('5','183','249922','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710104),('5','183','250238','423',165.00,165.00,2460.80,0.00,0.00,0.00,0.00,710922),('5','183','250238','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,710923),('5','183','250238','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710924),('5','183','250495','423',165.00,165.00,7194.16,0.00,0.00,0.00,0.00,711574),('5','183','250495','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,711575),('5','183','250495','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711576),('5','183','250774','423',165.00,165.00,7761.87,0.00,0.00,0.00,0.00,712312),('5','183','250774','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,712313),('5','183','250774','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712314),('5','183','251051','423',165.00,165.00,7709.67,0.00,0.00,0.00,0.00,713000),('5','183','251051','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,713001),('5','183','251051','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713002),('5','183','251122','423',165.00,165.00,9674.83,0.00,0.00,0.00,0.00,713182),('5','183','251122','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,713183),('5','183','251122','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713184),('5','183','251763','423',165.00,165.00,9333.57,0.00,0.00,0.00,0.00,714873),('5','183','251763','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,714874),('5','183','251763','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714875),('5','183','252813','423',165.00,165.00,8309.12,0.00,0.00,0.00,0.00,717590),('5','183','252813','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717591),('5','183','252813','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717592),('5','183','252830','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717638),('5','183','252830','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717639),('5','183','252830','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717640),('5','183','252832','423',165.00,165.00,6434.27,0.00,0.00,0.00,0.00,717644),('5','183','252832','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717645),('5','183','252832','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717646),('5','183','252840','423',165.00,165.00,6450.16,0.00,0.00,0.00,0.00,717668),('5','183','252840','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717669),('5','183','252840','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717670),('5','183','252844','423',165.00,165.00,5908.16,0.00,0.00,0.00,0.00,717678),('5','183','252844','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717679),('5','183','252844','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717680),('5','183','252853','423',165.00,165.00,4834.43,0.00,0.00,0.00,0.00,717704),('5','183','252853','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717705),('5','183','252853','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717706),('5','183','252860','423',165.00,165.00,3126.56,0.00,0.00,0.00,0.00,717724),('5','183','252860','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717725),('5','183','252860','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717726),('5','183','252864','423',165.00,165.00,1029.47,0.00,0.00,0.00,0.00,717736),('5','183','252864','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,717737),('5','183','252864','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717738),('5','183','253017','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718115),('5','183','253017','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,718116),('5','183','253017','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718117),('5','183','253412','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719169),('5','183','253412','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,719170),('5','183','253412','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719171),('5','183','253638','423',165.00,165.00,6751.58,0.00,0.00,0.00,0.00,719755),('5','183','253638','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,719756),('5','183','253638','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719757),('5','183','253872','423',165.00,165.00,7275.73,0.00,0.00,0.00,0.00,720362),('5','183','253872','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,720363),('5','183','253872','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720364),('5','183','254079','423',165.00,165.00,6317.95,0.00,0.00,0.00,0.00,720897),('5','183','254079','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,720898),('5','183','254079','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720899),('5','183','254244','423',165.00,165.00,7764.94,0.00,0.00,0.00,0.00,721308),('5','183','254244','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,721309),('5','183','254244','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721310),('5','183','254482','423',165.00,165.00,5093.82,0.00,0.00,0.00,0.00,721926),('5','183','254482','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,721927),('5','183','254482','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721928),('5','183','254933','423',165.00,165.00,2598.67,0.00,0.00,0.00,0.00,723094),('5','183','254933','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,723095),('5','183','254933','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723096),('5','183','255018','423',165.00,165.00,2705.57,0.00,0.00,0.00,0.00,723283),('5','183','255018','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,723284),('5','183','255018','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723285),('5','183','255340','423',165.00,165.00,1152.79,0.00,0.00,0.00,0.00,724128),('5','183','255340','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,724129),('5','183','255340','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724130),('5','183','255748','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725123),('5','183','255748','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,725124),('5','183','255748','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725125),('5','183','255888','423',165.00,165.00,6122.72,0.00,0.00,0.00,0.00,725490),('5','183','255888','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,725491),('5','183','255888','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725492),('5','183','256143','423',165.00,165.00,7712.94,0.00,0.00,0.00,0.00,726138),('5','183','256143','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,726139),('5','183','256143','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726140),('5','183','256359','423',165.00,165.00,6783.58,0.00,0.00,0.00,0.00,726664),('5','183','256359','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,726665),('5','183','256359','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726666),('5','183','256559','423',165.00,165.00,7161.10,0.00,0.00,0.00,0.00,727181),('5','183','256559','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,727182),('5','183','256559','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727183),('5','183','256801','423',165.00,165.00,5551.45,0.00,0.00,0.00,0.00,727802),('5','183','256801','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,727803),('5','183','256801','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727804),('5','183','257012','423',165.00,165.00,3341.23,0.00,0.00,0.00,0.00,728350),('5','183','257012','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,728351),('5','183','257012','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728352),('5','183','257524','423',165.00,165.00,3182.86,0.00,0.00,0.00,0.00,729697),('5','183','257524','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729698),('5','183','257524','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729699),('5','183','257525','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729700),('5','183','257525','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729701),('5','183','257525','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729702),('5','183','257526','423',165.00,165.00,2331.61,0.00,0.00,0.00,0.00,729703),('5','183','257526','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729704),('5','183','257526','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729705),('5','183','257527','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729706),('5','183','257527','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729707),('5','183','257527','423',165.00,165.00,9000.40,0.00,0.00,0.00,0.00,729708),('5','183','257528','423',165.00,165.00,7191.03,0.00,0.00,0.00,0.00,729709),('5','183','257528','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729710),('5','183','257528','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729711),('5','183','257529','423',165.00,165.00,6539.24,0.00,0.00,0.00,0.00,729712),('5','183','257529','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729713),('5','183','257529','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729714),('5','183','257530','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729715),('5','183','257530','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729716),('5','183','257530','423',165.00,165.00,4755.48,0.00,0.00,0.00,0.00,729717),('5','183','257531','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729718),('5','183','257531','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729719),('5','183','257531','423',165.00,165.00,4310.48,0.00,0.00,0.00,0.00,729720),('5','183','257532','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729721),('5','183','257532','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729722),('5','183','257532','423',165.00,165.00,3297.84,0.00,0.00,0.00,0.00,729723),('5','183','257533','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729724),('5','183','257533','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729725),('5','183','257533','423',165.00,165.00,2246.01,0.00,0.00,0.00,0.00,729726),('5','183','257534','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729727),('5','183','257534','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','183','257534','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','183','257535','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729730),('5','183','257535','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','183','257535','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','183','257536','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729733),('5','183','257536','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729734),('5','183','257536','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','183','257537','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729736),('5','183','257537','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','183','257537','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729738),('5','183','257538','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729739),('5','183','257538','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729740),('5','183','257538','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729741),('5','183','257539','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729742),('5','183','257539','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729743),('5','183','257539','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729744),('5','183','257540','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729745),('5','183','257540','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','183','257540','423',165.00,165.00,1666.12,0.00,0.00,0.00,0.00,729747),('5','183','257541','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729748),('5','183','257541','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','183','257541','423',165.00,165.00,7861.56,0.00,0.00,0.00,0.00,729750),('5','183','257542','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729751),('5','183','257542','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','183','257542','423',165.00,165.00,7565.58,0.00,0.00,0.00,0.00,729753),('5','183','257543','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729754),('5','183','257543','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','183','257543','423',165.00,165.00,5652.85,0.00,0.00,0.00,0.00,729756),('5','183','257544','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729757),('5','183','257544','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','183','257544','423',165.00,165.00,7131.89,0.00,0.00,0.00,0.00,729759),('5','183','257545','423',165.00,165.00,5948.64,0.00,0.00,0.00,0.00,729760),('5','183','257545','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729761),('5','183','257545','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729762),('5','183','257546','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729763),('5','183','257546','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','183','257546','423',165.00,165.00,5722.92,0.00,0.00,0.00,0.00,729765),('5','183','257547','424',300.00,295.00,0.00,0.00,0.00,0.00,0.00,729766),('5','183','257547','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','183','257547','423',165.00,165.00,2864.86,0.00,0.00,0.00,0.00,729768),('5','183','257548','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729769),('5','183','257548','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','183','257548','423',165.00,165.00,8583.16,0.00,0.00,0.00,0.00,729771),('5','183','257549','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729772),('5','183','257549','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','183','257549','423',165.00,165.00,8837.90,0.00,0.00,0.00,0.00,729774),('5','183','257550','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729775),('5','183','257550','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','183','257550','423',165.00,165.00,7493.10,0.00,0.00,0.00,0.00,729777),('5','183','257551','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729778),('5','183','257551','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729779),('5','183','257551','423',165.00,165.00,6989.17,0.00,0.00,0.00,0.00,729780),('5','183','257552','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729781),('5','183','257552','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','183','257552','423',165.00,165.00,10765.61,0.00,0.00,0.00,0.00,729783),('5','183','257553','423',165.00,165.00,6230.30,0.00,0.00,0.00,0.00,729784),('5','183','257553','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729785),('5','183','257553','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729786),('5','183','257554','423',165.00,165.00,3490.77,0.00,0.00,0.00,0.00,729787),('5','183','257554','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729788),('5','183','257554','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729789),('5','183','257555','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729790),('5','183','257555','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','183','257555','423',165.00,165.00,2789.79,0.00,0.00,0.00,0.00,729792),('5','183','257556','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729793),('5','183','257556','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','183','257556','423',165.00,165.00,8659.37,0.00,0.00,0.00,0.00,729795),('5','183','257557','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729796),('5','183','257557','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','183','257557','423',165.00,165.00,11989.83,0.00,0.00,0.00,0.00,729798),('5','183','257558','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729799),('5','183','257558','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','183','257558','423',165.00,165.00,6864.73,0.00,0.00,0.00,0.00,729801),('5','183','257559','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729802),('5','183','257559','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','183','257559','423',165.00,165.00,8432.18,0.00,0.00,0.00,0.00,729804),('5','183','257560','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729805),('5','183','257560','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','183','257560','423',165.00,165.00,5421.44,0.00,0.00,0.00,0.00,729807),('5','183','257561','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729808),('5','183','257561','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','183','257561','423',165.00,165.00,6002.30,0.00,0.00,0.00,0.00,729810),('5','183','257562','423',165.00,165.00,7274.19,0.00,0.00,0.00,0.00,729811),('5','183','257562','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729812),('5','183','257562','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729813),('5','183','257563','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729814),('5','183','257563','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','183','257563','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','183','257564','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729817),('5','183','257564','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','183','257564','423',165.00,165.00,10462.68,0.00,0.00,0.00,0.00,729819),('5','183','257565','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729820),('5','183','257565','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','183','257565','423',165.00,165.00,7377.66,0.00,0.00,0.00,0.00,729822),('5','183','257566','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729823),('5','183','257566','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','183','257566','423',165.00,165.00,10651.32,0.00,0.00,0.00,0.00,729825),('5','183','257567','423',165.00,165.00,9154.11,0.00,0.00,0.00,0.00,729826),('5','183','257567','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729827),('5','183','257567','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729828),('5','183','257568','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729829),('5','183','257568','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729830),('5','183','257568','423',165.00,165.00,9836.27,0.00,0.00,0.00,0.00,729831),('5','183','257569','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729832),('5','183','257569','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','183','257569','423',165.00,165.00,10959.85,0.00,0.00,0.00,0.00,729834),('5','183','257570','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729835),('5','183','257570','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','183','257570','423',165.00,165.00,4688.66,0.00,0.00,0.00,0.00,729837),('5','183','257571','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729838),('5','183','257571','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','183','257571','423',165.00,165.00,6260.10,0.00,0.00,0.00,0.00,729840),('5','183','257572','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729841),('5','183','257572','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','183','257572','423',165.00,165.00,6151.56,0.00,0.00,0.00,0.00,729843),('5','183','257573','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729844),('5','183','257573','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729845),('5','183','257573','423',165.00,165.00,2591.55,0.00,0.00,0.00,0.00,729846),('5','183','257574','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729847),('5','183','257574','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729848),('5','183','257574','423',165.00,165.00,2069.22,0.00,0.00,0.00,0.00,729849),('5','183','257575','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729850),('5','183','257575','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729851),('5','183','257575','423',165.00,165.00,1304.79,0.00,0.00,0.00,0.00,729852),('5','183','257576','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729853),('5','183','257576','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','183','257576','423',165.00,165.00,7614.81,0.00,0.00,0.00,0.00,729855),('5','183','257577','423',165.00,165.00,6801.28,0.00,0.00,0.00,0.00,729856),('5','183','257577','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729857),('5','183','257577','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729858),('5','183','257578','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729859),('5','183','257578','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','183','257578','423',165.00,165.00,5118.09,0.00,0.00,0.00,0.00,729861),('5','183','257579','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729862),('5','183','257579','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','183','257579','423',165.00,165.00,6564.31,0.00,0.00,0.00,0.00,729864),('5','183','257580','423',165.00,165.00,6553.18,0.00,0.00,0.00,0.00,729865),('5','183','257580','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729866),('5','183','257580','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729867),('5','183','257581','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729868),('5','183','257581','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729869),('5','183','257581','423',165.00,165.00,6513.57,0.00,0.00,0.00,0.00,729870),('5','183','257582','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729871),('5','183','257582','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','183','257582','423',165.00,165.00,2510.54,0.00,0.00,0.00,0.00,729873),('5','183','257583','423',165.00,165.00,1515.15,0.00,0.00,0.00,0.00,729874),('5','183','257583','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729875),('5','183','257583','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729876),('5','183','257584','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729877),('5','183','257584','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','183','257584','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','183','257585','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729880),('5','183','257585','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','183','257585','423',165.00,165.00,1123.52,0.00,0.00,0.00,0.00,729882),('5','183','257586','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729883),('5','183','257586','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','183','257586','423',165.00,165.00,8050.22,0.00,0.00,0.00,0.00,729885),('5','183','257587','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729886),('5','183','257587','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','183','257587','423',165.00,165.00,6812.67,0.00,0.00,0.00,0.00,729888),('5','183','257588','423',165.00,165.00,6198.38,0.00,0.00,0.00,0.00,729889),('5','183','257588','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729890),('5','183','257588','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729891),('5','183','257589','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729892),('5','183','257589','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','183','257589','423',165.00,165.00,5809.06,0.00,0.00,0.00,0.00,729894),('5','183','257590','423',165.00,165.00,8375.19,0.00,0.00,0.00,0.00,729895),('5','183','257590','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729896),('5','183','257590','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729897),('5','183','257591','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729898),('5','183','257591','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','183','257591','423',165.00,165.00,6843.11,0.00,0.00,0.00,0.00,729900),('5','183','257592','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729901),('5','183','257592','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729902),('5','183','257592','423',165.00,165.00,7967.35,0.00,0.00,0.00,0.00,729903),('5','183','257593','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729904),('5','183','257593','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729905),('5','183','257593','423',165.00,165.00,9511.45,0.00,0.00,0.00,0.00,729906),('5','183','257594','423',165.00,165.00,8969.46,0.00,0.00,0.00,0.00,729907),('5','183','257594','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729908),('5','183','257594','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729909),('5','183','257595','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729910),('5','183','257595','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729911),('5','183','257595','423',165.00,165.00,10417.16,0.00,0.00,0.00,0.00,729912),('5','183','257596','423',165.00,165.00,8987.49,0.00,0.00,0.00,0.00,729913),('5','183','257596','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729914),('5','183','257596','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729915),('5','183','257597','423',165.00,165.00,8978.11,0.00,0.00,0.00,0.00,729916),('5','183','257597','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729917),('5','183','257597','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729918),('5','183','257598','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729919),('5','183','257598','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','183','257598','423',165.00,165.00,5711.05,0.00,0.00,0.00,0.00,729921),('5','183','257599','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729922),('5','183','257599','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','183','257599','423',165.00,165.00,4606.28,0.00,0.00,0.00,0.00,729924),('5','183','257600','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729925),('5','183','257600','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','183','257600','423',165.00,165.00,6587.87,0.00,0.00,0.00,0.00,729927),('5','183','257601','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729928),('5','183','257601','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','183','257601','423',165.00,165.00,6120.11,0.00,0.00,0.00,0.00,729930),('5','183','257602','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729931),('5','183','257602','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','183','257602','423',165.00,165.00,6284.81,0.00,0.00,0.00,0.00,729933),('5','183','257603','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729934),('5','183','257603','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','183','257603','423',165.00,165.00,5431.13,0.00,0.00,0.00,0.00,729936),('5','183','257604','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729937),('5','183','257604','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729938),('5','183','257604','423',165.00,165.00,4700.21,0.00,0.00,0.00,0.00,729939),('5','183','257605','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729940),('5','183','257605','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729941),('5','183','257605','423',165.00,165.00,2203.45,0.00,0.00,0.00,0.00,729942),('5','183','257606','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729943),('5','183','257606','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729944),('5','183','257606','423',165.00,165.00,5357.03,0.00,0.00,0.00,0.00,729945),('5','183','257607','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729946),('5','183','257607','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729947),('5','183','257607','423',165.00,165.00,4444.25,0.00,0.00,0.00,0.00,729948),('5','183','257608','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729949),('5','183','257608','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','183','257608','423',165.00,165.00,5308.24,0.00,0.00,0.00,0.00,729951),('5','183','257609','423',165.00,165.00,1522.84,0.00,0.00,0.00,0.00,729952),('5','183','257609','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729953),('5','183','257609','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729954),('5','183','257610','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729955),('5','183','257610','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','183','257610','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','183','257611','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729958),('5','183','257611','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','183','257611','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729960),('5','183','257612','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729961),('5','183','257612','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729962),('5','183','257612','423',165.00,165.00,6127.47,0.00,0.00,0.00,0.00,729963),('5','183','257613','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729964),('5','183','257613','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','183','257613','423',165.00,165.00,6329.76,0.00,0.00,0.00,0.00,729966),('5','183','257614','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729967),('5','183','257614','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','183','257614','423',165.00,165.00,7854.48,0.00,0.00,0.00,0.00,729969),('5','183','257615','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729970),('5','183','257615','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','183','257615','423',165.00,165.00,4523.14,0.00,0.00,0.00,0.00,729972),('5','183','257616','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729973),('5','183','257616','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729974),('5','183','257616','423',165.00,165.00,8686.89,0.00,0.00,0.00,0.00,729975),('5','183','257617','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729976),('5','183','257617','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','183','257617','423',165.00,165.00,4148.41,0.00,0.00,0.00,0.00,729978),('5','183','257618','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729979),('5','183','257618','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','183','257618','423',165.00,165.00,6457.76,0.00,0.00,0.00,0.00,729981),('5','183','257619','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729982),('5','183','257619','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','183','257619','423',165.00,165.00,4669.65,0.00,0.00,0.00,0.00,729984),('5','183','257620','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729985),('5','183','257620','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','183','257620','423',165.00,165.00,3998.75,0.00,0.00,0.00,0.00,729987),('5','183','257621','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729988),('5','183','257621','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729989),('5','183','257621','423',165.00,165.00,1808.27,0.00,0.00,0.00,0.00,729990),('5','183','257622','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729991),('5','183','257622','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729992),('5','183','257622','423',165.00,165.00,1005.14,0.00,0.00,0.00,0.00,729993),('5','183','257623','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729994),('5','183','257623','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','183','257623','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729996),('5','183','257624','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,729997),('5','183','257624','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','183','257624','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729999),('5','183','257625','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730000),('5','183','257625','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','183','257625','423',165.00,165.00,4476.82,0.00,0.00,0.00,0.00,730002),('5','183','257626','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730003),('5','183','257626','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730004),('5','183','257626','423',165.00,165.00,3682.33,0.00,0.00,0.00,0.00,730005),('5','183','257627','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730006),('5','183','257627','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730007),('5','183','257627','423',165.00,165.00,4626.85,0.00,0.00,0.00,0.00,730008),('5','183','257628','423',165.00,165.00,5355.42,0.00,0.00,0.00,0.00,730009),('5','183','257628','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730010),('5','183','257628','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730011),('5','183','257629','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730012),('5','183','257629','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','183','257629','423',165.00,165.00,5858.16,0.00,0.00,0.00,0.00,730014),('5','183','257630','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730015),('5','183','257630','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','183','257630','423',165.00,165.00,5979.46,0.00,0.00,0.00,0.00,730017),('5','183','257631','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730018),('5','183','257631','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','183','257631','423',165.00,165.00,5651.72,0.00,0.00,0.00,0.00,730020),('5','183','257632','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730021),('5','183','257632','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','183','257632','423',165.00,165.00,5985.85,0.00,0.00,0.00,0.00,730023),('5','183','257633','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730024),('5','183','257633','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','183','257633','423',165.00,165.00,5008.03,0.00,0.00,0.00,0.00,730026),('5','183','257634','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730027),('5','183','257634','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','183','257634','423',165.00,165.00,5705.11,0.00,0.00,0.00,0.00,730029),('5','183','257635','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730030),('5','183','257635','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','183','257635','423',165.00,165.00,6265.16,0.00,0.00,0.00,0.00,730032),('5','183','257636','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730033),('5','183','257636','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730034),('5','183','257636','423',165.00,165.00,5816.71,0.00,0.00,0.00,0.00,730035),('5','183','257637','423',165.00,165.00,6093.78,0.00,0.00,0.00,0.00,730036),('5','183','257637','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730037),('5','183','257637','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730038),('5','183','257638','423',165.00,165.00,6183.16,0.00,0.00,0.00,0.00,730039),('5','183','257638','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730040),('5','183','257638','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730041),('5','183','257639','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730042),('5','183','257639','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730043),('5','183','257639','423',165.00,165.00,5462.49,0.00,0.00,0.00,0.00,730044),('5','183','257640','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730045),('5','183','257640','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','183','257640','423',165.00,165.00,5731.52,0.00,0.00,0.00,0.00,730047),('5','183','257641','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730048),('5','183','257641','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','183','257641','423',165.00,165.00,5028.17,0.00,0.00,0.00,0.00,730050),('5','183','257642','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730051),('5','183','257642','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','183','257642','423',165.00,165.00,4411.90,0.00,0.00,0.00,0.00,730053),('5','183','257643','423',165.00,165.00,5665.57,0.00,0.00,0.00,0.00,730054),('5','183','257643','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730055),('5','183','257643','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730056),('5','183','257644','423',165.00,165.00,6089.90,0.00,0.00,0.00,0.00,730057),('5','183','257644','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730058),('5','183','257644','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','183','257645','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730060),('5','183','257645','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730061),('5','183','257645','423',165.00,165.00,5610.16,0.00,0.00,0.00,0.00,730062),('5','183','257646','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730063),('5','183','257646','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','183','257646','423',165.00,165.00,4365.39,0.00,0.00,0.00,0.00,730065),('5','183','257647','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730066),('5','183','257647','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','183','257647','423',165.00,165.00,3897.52,0.00,0.00,0.00,0.00,730068),('5','183','257648','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730069),('5','183','257648','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','183','257648','423',165.00,165.00,3101.37,0.00,0.00,0.00,0.00,730071),('5','183','257649','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730072),('5','183','257649','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','183','257649','423',165.00,165.00,5646.62,0.00,0.00,0.00,0.00,730074),('5','183','257650','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730075),('5','183','257650','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','183','257650','423',165.00,165.00,5259.60,0.00,0.00,0.00,0.00,730077),('5','183','257651','423',165.00,165.00,3494.25,0.00,0.00,0.00,0.00,730078),('5','183','257651','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730079),('5','183','257651','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730080),('5','183','257652','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730081),('5','183','257652','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','183','257652','423',165.00,165.00,3572.41,0.00,0.00,0.00,0.00,730083),('5','183','257653','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730084),('5','183','257653','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','183','257653','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','183','257654','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730087),('5','183','257654','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730088),('5','183','257654','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730089),('5','183','257655','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730090),('5','183','257655','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','183','257655','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730092),('5','183','257656','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730093),('5','183','257656','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','183','257656','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730095),('5','183','257657','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730096),('5','183','257657','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','183','257657','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730098),('5','183','257658','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730099),('5','183','257658','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730100),('5','183','257658','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730101),('5','183','257659','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730102),('5','183','257659','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730103),('5','183','257659','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730104),('5','183','257660','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730105),('5','183','257660','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','183','257660','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730107),('5','183','257661','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730108),('5','183','257661','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','183','257661','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730110),('5','183','257662','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730111),('5','183','257662','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','183','257662','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730113),('5','183','257663','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730114),('5','183','257663','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','183','257663','423',165.00,165.00,5917.52,0.00,0.00,0.00,0.00,730116),('5','183','257664','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730117),('5','183','257664','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','183','257664','423',165.00,165.00,5132.76,0.00,0.00,0.00,0.00,730119),('5','183','257665','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730120),('5','183','257665','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','183','257665','423',165.00,165.00,4054.03,0.00,0.00,0.00,0.00,730122),('5','183','257666','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730123),('5','183','257666','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','183','257666','423',165.00,165.00,3422.68,0.00,0.00,0.00,0.00,730125),('5','183','257667','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730126),('5','183','257667','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','183','257667','423',165.00,165.00,5084.92,0.00,0.00,0.00,0.00,730128),('5','183','257668','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730129),('5','183','257668','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','183','257668','423',165.00,165.00,2951.79,0.00,0.00,0.00,0.00,730131),('5','183','257669','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730132),('5','183','257669','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','183','257669','423',165.00,165.00,4334.01,0.00,0.00,0.00,0.00,730134),('5','183','257670','423',165.00,165.00,3193.52,0.00,0.00,0.00,0.00,730135),('5','183','257670','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730136),('5','183','257670','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730137),('5','183','257671','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730138),('5','183','257671','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','183','257671','423',165.00,165.00,3724.20,0.00,0.00,0.00,0.00,730140),('5','183','257672','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730141),('5','183','257672','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','183','257672','423',165.00,165.00,1673.66,0.00,0.00,0.00,0.00,730143),('5','183','257673','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730144),('5','183','257673','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','183','257673','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730146),('5','183','257674','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730147),('5','183','257674','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','183','257674','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730149),('5','183','257675','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730150),('5','183','257675','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','183','257675','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730152),('5','183','257676','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730153),('5','183','257676','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730154),('5','183','257676','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730155),('5','183','257677','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730156),('5','183','257677','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730157),('5','183','257677','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730158),('5','183','257678','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730159),('5','183','257678','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','183','257678','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730161),('5','183','257679','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730162),('5','183','257679','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','183','257679','423',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730164),('5','183','257680','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730165),('5','183','257680','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','183','257680','423',165.00,165.00,4283.00,0.00,0.00,0.00,0.00,730167),('5','183','257681','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730168),('5','183','257681','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','183','257681','423',165.00,165.00,2924.54,0.00,0.00,0.00,0.00,730170),('5','183','257682','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730171),('5','183','257682','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','183','257682','423',165.00,165.00,3890.61,0.00,0.00,0.00,0.00,730173),('5','183','257683','423',165.00,165.00,3763.38,0.00,0.00,0.00,0.00,730174),('5','183','257683','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730175),('5','183','257683','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730176),('5','183','257684','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730177),('5','183','257684','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','183','257684','423',165.00,165.00,1976.08,0.00,0.00,0.00,0.00,730179),('5','183','257685','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730180),('5','183','257685','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','183','257685','423',185.00,185.00,2981.91,0.00,0.00,0.00,0.00,730182),('5','183','257686','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730183),('5','183','257686','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','183','257686','423',185.00,185.00,3249.72,0.00,0.00,0.00,0.00,730185),('5','183','257687','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730186),('5','183','257687','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','183','257687','423',185.00,185.00,1375.62,0.00,0.00,0.00,0.00,730188),('5','183','257688','423',185.00,185.00,4693.86,0.00,0.00,0.00,0.00,730189),('5','183','257688','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730190),('5','183','257688','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','183','257689','423',185.00,185.00,5308.34,0.00,0.00,0.00,0.00,730192),('5','183','257689','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730193),('5','183','257689','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730194),('5','183','257690','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730195),('5','183','257690','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','183','257690','423',185.00,185.00,4286.49,0.00,0.00,0.00,0.00,730197),('5','183','257691','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730198),('5','183','257691','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','183','257691','423',185.00,185.00,5099.34,0.00,0.00,0.00,0.00,730200),('5','183','257692','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730201),('5','183','257692','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','183','257692','423',185.00,185.00,4556.43,0.00,0.00,0.00,0.00,730203),('5','183','257693','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730204),('5','183','257693','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','183','257693','423',185.00,185.00,9186.74,0.00,0.00,0.00,0.00,730206),('5','183','257694','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730207),('5','183','257694','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','183','257694','423',185.00,185.00,8826.02,0.00,0.00,0.00,0.00,730209),('5','183','257695','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730210),('5','183','257695','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','183','257695','423',185.00,185.00,3955.15,0.00,0.00,0.00,0.00,730212),('5','183','257696','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730213),('5','183','257696','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','183','257696','423',185.00,185.00,10805.40,0.00,0.00,0.00,0.00,730215),('5','183','257697','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730216),('5','183','257697','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','183','257697','423',185.00,185.00,11978.48,0.00,0.00,0.00,0.00,730218),('5','183','257698','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730219),('5','183','257698','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','183','257698','423',185.00,185.00,8114.55,0.00,0.00,0.00,0.00,730221),('5','183','257699','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730222),('5','183','257699','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','183','257699','423',185.00,185.00,7742.77,0.00,0.00,0.00,0.00,730224),('5','183','257700','423',185.00,185.00,4367.82,0.00,0.00,0.00,0.00,730225),('5','183','257700','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730226),('5','183','257700','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','183','257701','423',185.00,185.00,5001.92,0.00,0.00,0.00,0.00,730228),('5','183','257701','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730229),('5','183','257701','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730230),('5','183','257702','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730231),('5','183','257702','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','183','257702','423',185.00,185.00,5753.28,0.00,0.00,0.00,0.00,730233),('5','183','257703','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730234),('5','183','257703','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','183','257703','423',185.00,185.00,2967.86,0.00,0.00,0.00,0.00,730236),('5','183','257704','423',185.00,185.00,2377.53,0.00,0.00,0.00,0.00,730237),('5','183','257704','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730238),('5','183','257704','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','183','257705','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730240),('5','183','257705','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','183','257705','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730242),('5','183','257706','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730243),('5','183','257706','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','183','257706','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730245),('5','183','257707','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730246),('5','183','257707','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730247),('5','183','257707','423',185.00,185.00,6771.47,0.00,0.00,0.00,0.00,730248),('5','183','257708','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730249),('5','183','257708','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','183','257708','423',185.00,185.00,6978.92,0.00,0.00,0.00,0.00,730251),('5','183','257709','423',185.00,185.00,3630.54,0.00,0.00,0.00,0.00,730252),('5','183','257709','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730253),('5','183','257709','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730254),('5','183','257710','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730255),('5','183','257710','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','183','257710','423',185.00,185.00,4572.37,0.00,0.00,0.00,0.00,730257),('5','183','257711','423',185.00,185.00,5335.88,0.00,0.00,0.00,0.00,730258),('5','183','257711','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730259),('5','183','257711','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730260),('5','183','257712','423',185.00,185.00,3322.96,0.00,0.00,0.00,0.00,730261),('5','183','257712','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730262),('5','183','257712','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730263),('5','183','257713','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730264),('5','183','257713','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','183','257713','423',185.00,185.00,3752.46,0.00,0.00,0.00,0.00,730266),('5','183','257714','423',185.00,185.00,5923.70,0.00,0.00,0.00,0.00,730267),('5','183','257714','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730268),('5','183','257714','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730269),('5','183','257715','423',185.00,185.00,5270.02,0.00,0.00,0.00,0.00,730270),('5','183','257715','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730271),('5','183','257715','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730272),('5','183','257716','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730273),('5','183','257716','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','183','257716','423',185.00,185.00,5346.18,0.00,0.00,0.00,0.00,730275),('5','183','257717','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730276),('5','183','257717','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','183','257717','423',185.00,185.00,4568.95,0.00,0.00,0.00,0.00,730278),('5','183','257718','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730279),('5','183','257718','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','183','257718','423',185.00,185.00,5667.03,0.00,0.00,0.00,0.00,730281),('5','183','257719','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730282),('5','183','257719','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','183','257719','423',185.00,185.00,4745.96,0.00,0.00,0.00,0.00,730284),('5','183','257720','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730285),('5','183','257720','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','183','257720','423',185.00,185.00,2735.14,0.00,0.00,0.00,0.00,730287),('5','183','257721','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730288),('5','183','257721','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','183','257721','423',185.00,185.00,3016.85,0.00,0.00,0.00,0.00,730290),('5','183','257722','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730291),('5','183','257722','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','183','257722','423',185.00,185.00,4586.94,0.00,0.00,0.00,0.00,730293),('5','183','257723','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730294),('5','183','257723','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','183','257723','423',185.00,185.00,4561.30,0.00,0.00,0.00,0.00,730296),('5','183','257724','423',185.00,185.00,2595.84,0.00,0.00,0.00,0.00,730297),('5','183','257724','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730298),('5','183','257724','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730299),('5','183','257725','423',185.00,185.00,4561.48,0.00,0.00,0.00,0.00,730300),('5','183','257725','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730301),('5','183','257725','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730302),('5','183','257726','423',185.00,185.00,5953.83,0.00,0.00,0.00,0.00,730303),('5','183','257726','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730304),('5','183','257726','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730305),('5','183','257727','423',185.00,185.00,4824.24,0.00,0.00,0.00,0.00,730306),('5','183','257727','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730307),('5','183','257727','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730308),('5','183','257728','423',185.00,185.00,4784.92,0.00,0.00,0.00,0.00,730309),('5','183','257728','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730310),('5','183','257728','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730311),('5','183','257729','423',185.00,185.00,4171.56,0.00,0.00,0.00,0.00,730312),('5','183','257729','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730313),('5','183','257729','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730314),('5','183','257730','423',185.00,185.00,3334.18,0.00,0.00,0.00,0.00,730315),('5','183','257730','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730316),('5','183','257730','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730317),('5','183','257731','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730318),('5','183','257731','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','183','257731','423',185.00,185.00,4102.09,0.00,0.00,0.00,0.00,730320),('5','183','257732','423',185.00,185.00,3679.04,0.00,0.00,0.00,0.00,730321),('5','183','257732','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730322),('5','183','257732','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730323),('5','183','257733','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730324),('5','183','257733','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730325),('5','183','257733','423',185.00,185.00,3156.23,0.00,0.00,0.00,0.00,730326),('5','183','257734','423',185.00,185.00,2908.48,0.00,0.00,0.00,0.00,730327),('5','183','257734','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730328),('5','183','257734','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','183','257735','423',185.00,185.00,4127.35,0.00,0.00,0.00,0.00,730330),('5','183','257735','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730331),('5','183','257735','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','183','257736','423',185.00,185.00,3482.44,0.00,0.00,0.00,0.00,730333),('5','183','257736','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730334),('5','183','257736','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730335),('5','183','257737','423',185.00,185.00,4211.38,0.00,0.00,0.00,0.00,730336),('5','183','257737','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730337),('5','183','257737','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','183','257738','423',185.00,185.00,2988.25,0.00,0.00,0.00,0.00,730339),('5','183','257738','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730340),('5','183','257738','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','183','257739','423',185.00,185.00,3806.33,0.00,0.00,0.00,0.00,730342),('5','183','257739','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730343),('5','183','257739','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','183','257740','423',185.00,185.00,3723.56,0.00,0.00,0.00,0.00,730345),('5','183','257740','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730346),('5','183','257740','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','183','257741','423',185.00,185.00,5835.63,0.00,0.00,0.00,0.00,730348),('5','183','257741','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730349),('5','183','257741','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','183','257742','423',185.00,185.00,5886.65,0.00,0.00,0.00,0.00,730351),('5','183','257742','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730352),('5','183','257742','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','183','257743','423',185.00,185.00,4701.53,0.00,0.00,0.00,0.00,730354),('5','183','257743','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730355),('5','183','257743','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','183','257744','423',185.00,185.00,3592.07,0.00,0.00,0.00,0.00,730357),('5','183','257744','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730358),('5','183','257744','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','183','257745','423',185.00,185.00,3122.59,0.00,0.00,0.00,0.00,730360),('5','183','257745','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730361),('5','183','257745','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','183','257746','423',185.00,185.00,3515.03,0.00,0.00,0.00,0.00,730363),('5','183','257746','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730364),('5','183','257746','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730365),('5','183','257747','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730366),('5','183','257747','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','183','257747','423',185.00,185.00,1293.99,0.00,0.00,0.00,0.00,730368),('5','183','257748','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730369),('5','183','257748','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','183','257748','423',185.00,185.00,3523.99,0.00,0.00,0.00,0.00,730371),('5','183','257749','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730372),('5','183','257749','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','183','257749','423',185.00,185.00,2321.70,0.00,0.00,0.00,0.00,730374),('5','183','257750','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730375),('5','183','257750','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','183','257750','423',185.00,185.00,3917.80,0.00,0.00,0.00,0.00,730377),('5','183','257751','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730378),('5','183','257751','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','183','257751','423',185.00,185.00,4219.78,0.00,0.00,0.00,0.00,730380),('5','183','257752','423',185.00,185.00,3004.53,0.00,0.00,0.00,0.00,730381),('5','183','257752','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730382),('5','183','257752','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730383),('5','183','257753','423',185.00,185.00,3370.19,0.00,0.00,0.00,0.00,730384),('5','183','257753','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730385),('5','183','257753','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730386),('5','183','257754','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730387),('5','183','257754','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','183','257754','423',185.00,185.00,4795.85,0.00,0.00,0.00,0.00,730389),('5','183','257755','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730390),('5','183','257755','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730391),('5','183','257755','423',185.00,185.00,3683.10,0.00,0.00,0.00,0.00,730392),('5','183','257756','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730393),('5','183','257756','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','183','257756','423',185.00,185.00,3426.94,0.00,0.00,0.00,0.00,730395),('5','183','257757','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730396),('5','183','257757','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730397),('5','183','257757','423',185.00,185.00,3238.22,0.00,0.00,0.00,0.00,730398),('5','183','257758','423',185.00,185.00,4276.89,0.00,0.00,0.00,0.00,730399),('5','183','257758','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730400),('5','183','257758','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730401),('5','183','257759','423',185.00,185.00,3630.38,0.00,0.00,0.00,0.00,730402),('5','183','257759','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730403),('5','183','257759','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730404),('5','183','257760','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730405),('5','183','257760','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','183','257760','423',185.00,185.00,2783.94,0.00,0.00,0.00,0.00,730407),('5','183','257761','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730408),('5','183','257761','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','183','257761','423',185.00,185.00,6786.63,0.00,0.00,0.00,0.00,730410),('5','183','257762','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730411),('5','183','257762','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','183','257762','423',185.00,185.00,4278.00,0.00,0.00,0.00,0.00,730413),('5','183','257763','423',185.00,185.00,5137.96,0.00,0.00,0.00,0.00,730414),('5','183','257763','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730415),('5','183','257763','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','183','257764','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730417),('5','183','257764','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','183','257764','423',185.00,185.00,5626.46,0.00,0.00,0.00,0.00,730419),('5','183','257765','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730420),('5','183','257765','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','183','257765','423',185.00,185.00,5691.10,0.00,0.00,0.00,0.00,730422),('5','183','257766','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730423),('5','183','257766','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730424),('5','183','257766','423',185.00,185.00,4979.53,0.00,0.00,0.00,0.00,730425),('5','183','257767','423',185.00,185.00,4927.38,0.00,0.00,0.00,0.00,730426),('5','183','257767','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730427),('5','183','257767','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730428),('5','183','257768','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730429),('5','183','257768','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','183','257768','423',185.00,185.00,6272.22,0.00,0.00,0.00,0.00,730431),('5','183','257769','423',185.00,185.00,5121.78,0.00,0.00,0.00,0.00,730432),('5','183','257769','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730433),('5','183','257769','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730434),('5','183','257770','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730435),('5','183','257770','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','183','257770','423',185.00,185.00,4020.51,0.00,0.00,0.00,0.00,730437),('5','183','257771','423',185.00,185.00,5632.63,0.00,0.00,0.00,0.00,730438),('5','183','257771','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730439),('5','183','257771','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','183','257772','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730441),('5','183','257772','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','183','257772','423',185.00,185.00,5279.63,0.00,0.00,0.00,0.00,730443),('5','183','257773','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730444),('5','183','257773','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','183','257773','423',185.00,185.00,6564.46,0.00,0.00,0.00,0.00,730446),('5','183','257774','423',185.00,185.00,6452.23,0.00,0.00,0.00,0.00,730447),('5','183','257774','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730448),('5','183','257774','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','183','257775','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730450),('5','183','257775','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','183','257775','423',185.00,185.00,5440.37,0.00,0.00,0.00,0.00,730452),('5','183','257776','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730453),('5','183','257776','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730454),('5','183','257776','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730455),('5','183','257777','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730456),('5','183','257777','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730457),('5','183','257777','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730458),('5','183','257778','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730459),('5','183','257778','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730460),('5','183','257778','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730461),('5','183','257779','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730462),('5','183','257779','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','183','257779','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730464),('5','183','257780','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730465),('5','183','257780','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730466),('5','183','257780','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','183','257781','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730468),('5','183','257781','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730469),('5','183','257781','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730470),('5','183','257782','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730471),('5','183','257782','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','183','257782','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730473),('5','183','257783','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730474),('5','183','257783','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','183','257783','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730476),('5','183','257784','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730477),('5','183','257784','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730478),('5','183','257784','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730479),('5','183','257785','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730480),('5','183','257785','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730481),('5','183','257785','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','183','257786','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730483),('5','183','257786','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730484),('5','183','257786','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730485),('5','183','257787','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730486),('5','183','257787','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730487),('5','183','257787','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730488),('5','183','257788','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730489),('5','183','257788','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730490),('5','183','257788','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730491),('5','183','257789','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730492),('5','183','257789','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730493),('5','183','257789','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730494),('5','183','257790','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730495),('5','183','257790','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730496),('5','183','257790','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730497),('5','183','257791','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730498),('5','183','257791','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730499),('5','183','257791','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730500),('5','183','257792','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730501),('5','183','257792','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730502),('5','183','257792','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730503),('5','183','257793','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730504),('5','183','257793','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730505),('5','183','257793','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730506),('5','183','257794','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730507),('5','183','257794','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730508),('5','183','257794','423',185.00,185.00,8751.00,0.00,0.00,0.00,0.00,730509),('5','183','257795','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730510),('5','183','257795','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730511),('5','183','257795','423',185.00,185.00,11281.56,0.00,0.00,0.00,0.00,730512),('5','183','257796','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730513),('5','183','257796','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','183','257796','423',185.00,185.00,10604.35,0.00,0.00,0.00,0.00,730515),('5','183','257797','423',185.00,185.00,10459.72,0.00,0.00,0.00,0.00,730516),('5','183','257797','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730517),('5','183','257797','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730518),('5','183','257798','423',185.00,185.00,11313.35,0.00,0.00,0.00,0.00,730519),('5','183','257798','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730520),('5','183','257798','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730521),('5','183','257799','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730522),('5','183','257799','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730523),('5','183','257799','423',185.00,185.00,13301.71,0.00,0.00,0.00,0.00,730524),('5','183','257800','423',185.00,185.00,14525.70,0.00,0.00,0.00,0.00,730525),('5','183','257800','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730526),('5','183','257800','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730527),('5','183','257801','423',185.00,185.00,13990.50,0.00,0.00,0.00,0.00,730528),('5','183','257801','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730529),('5','183','257801','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730530),('5','183','257802','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730531),('5','183','257802','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730532),('5','183','257802','423',185.00,185.00,12745.13,0.00,0.00,0.00,0.00,730533),('5','183','257803','423',185.00,185.00,8720.84,0.00,0.00,0.00,0.00,730534),('5','183','257803','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730535),('5','183','257803','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730536),('5','183','257804','423',185.00,185.00,5038.41,0.00,0.00,0.00,0.00,730537),('5','183','257804','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730538),('5','183','257804','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730539),('5','183','257805','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730540),('5','183','257805','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730541),('5','183','257805','423',185.00,185.00,5853.67,0.00,0.00,0.00,0.00,730542),('5','183','257806','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730543),('5','183','257806','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730544),('5','183','257806','423',185.00,185.00,3197.07,0.00,0.00,0.00,0.00,730545),('5','183','257807','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730546),('5','183','257807','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730547),('5','183','257807','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730548),('5','183','257808','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730549),('5','183','257808','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730550),('5','183','257808','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730551),('5','183','257809','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730552),('5','183','257809','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730553),('5','183','257809','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730554),('5','183','257810','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730555),('5','183','257810','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730556),('5','183','257810','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730557),('5','183','257811','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730558),('5','183','257811','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730559),('5','183','257811','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730560),('5','183','257812','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','183','257812','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730562),('5','183','257812','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730563),('5','183','257813','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730564),('5','183','257813','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730565),('5','183','257813','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730566),('5','183','257814','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730567),('5','183','257814','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730568),('5','183','257814','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730569),('5','183','257815','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730570),('5','183','257815','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730571),('5','183','257815','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730572),('5','183','257816','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730573),('5','183','257816','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730574),('5','183','257816','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730575),('5','183','257817','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730576),('5','183','257817','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730577),('5','183','257817','423',185.00,185.00,11980.78,0.00,0.00,0.00,0.00,730578),('5','183','257818','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730579),('5','183','257818','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730580),('5','183','257818','423',185.00,185.00,10237.12,0.00,0.00,0.00,0.00,730581),('5','183','257819','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730582),('5','183','257819','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','183','257819','423',185.00,185.00,8382.73,0.00,0.00,0.00,0.00,730584),('5','183','257820','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730585),('5','183','257820','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730586),('5','183','257820','423',185.00,185.00,8370.91,0.00,0.00,0.00,0.00,730587),('5','183','257821','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730588),('5','183','257821','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','183','257821','423',185.00,185.00,5857.56,0.00,0.00,0.00,0.00,730590),('5','183','257822','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730591),('5','183','257822','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730592),('5','183','257822','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730593),('5','183','257823','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730594),('5','183','257823','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730595),('5','183','257823','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730596),('5','183','257824','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730597),('5','183','257824','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730598),('5','183','257824','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730599),('5','183','257825','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730600),('5','183','257825','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730601),('5','183','257825','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730602),('5','183','257826','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730603),('5','183','257826','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730604),('5','183','257826','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730605),('5','183','257827','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730606),('5','183','257827','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730607),('5','183','257827','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730608),('5','183','257828','423',185.00,185.00,11700.36,0.00,0.00,0.00,0.00,730609),('5','183','257828','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730610),('5','183','257828','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730611),('5','183','257829','423',185.00,185.00,10160.11,0.00,0.00,0.00,0.00,730612),('5','183','257829','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730613),('5','183','257829','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730614),('5','183','257830','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730615),('5','183','257830','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730616),('5','183','257830','423',185.00,185.00,11036.95,0.00,0.00,0.00,0.00,730617),('5','183','257831','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730618),('5','183','257831','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730619),('5','183','257831','423',185.00,185.00,10811.15,0.00,0.00,0.00,0.00,730620),('5','183','257832','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730621),('5','183','257832','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','183','257832','423',185.00,185.00,13672.42,0.00,0.00,0.00,0.00,730623),('5','183','257833','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730624),('5','183','257833','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','183','257833','423',185.00,185.00,12018.70,0.00,0.00,0.00,0.00,730626),('5','183','257834','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730627),('5','183','257834','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730628),('5','183','257834','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730629),('5','183','257835','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730630),('5','183','257835','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730631),('5','183','257835','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','183','257836','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730633),('5','183','257836','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730634),('5','183','257836','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730635),('5','183','257837','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730636),('5','183','257837','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730637),('5','183','257837','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730638),('5','183','257838','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730639),('5','183','257838','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','183','257838','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730641),('5','183','257839','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730642),('5','183','257839','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730643),('5','183','257839','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730644),('5','183','257840','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730645),('5','183','257840','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730646),('5','183','257840','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730647),('5','183','257841','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730648),('5','183','257841','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730649),('5','183','257841','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730650),('5','183','257842','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730651),('5','183','257842','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730652),('5','183','257842','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730653),('5','183','257843','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730654),('5','183','257843','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730655),('5','183','257843','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730656),('5','183','257844','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730657),('5','183','257844','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730658),('5','183','257844','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730659),('5','183','257845','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730660),('5','183','257845','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730661),('5','183','257845','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730662),('5','183','257846','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730663),('5','183','257846','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730664),('5','183','257846','423',185.00,185.00,11962.10,0.00,0.00,0.00,0.00,730665),('5','183','257847','423',185.00,185.00,13099.31,0.00,0.00,0.00,0.00,730666),('5','183','257847','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730667),('5','183','257847','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730668),('5','183','257848','423',185.00,185.00,4785.63,0.00,0.00,0.00,0.00,730669),('5','183','257848','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730670),('5','183','257848','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730671),('5','183','257849','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730672),('5','183','257849','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730673),('5','183','257849','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730674),('5','183','257850','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730675),('5','183','257850','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730676),('5','183','257850','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730677),('5','183','257851','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730678),('5','183','257851','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730679),('5','183','257851','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730680),('5','183','257852','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730681),('5','183','257852','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','183','257852','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730683),('5','183','257853','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730684),('5','183','257853','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730685),('5','183','257853','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730686),('5','183','257854','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730687),('5','183','257854','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730688),('5','183','257854','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730689),('5','183','257855','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730690),('5','183','257855','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730691),('5','183','257855','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730692),('5','183','257856','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730693),('5','183','257856','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730694),('5','183','257856','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730695),('5','183','257857','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730696),('5','183','257857','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730697),('5','183','257857','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730698),('5','183','257858','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730699),('5','183','257858','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730700),('5','183','257858','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730701),('5','183','257859','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730702),('5','183','257859','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730703),('5','183','257859','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730704),('5','183','257860','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730705),('5','183','257860','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730706),('5','183','257860','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730707),('5','183','257861','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730708),('5','183','257861','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730709),('5','183','257861','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730710),('5','183','257862','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730711),('5','183','257862','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730712),('5','183','257862','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730713),('5','183','257863','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730714),('5','183','257863','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730715),('5','183','257863','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730716),('5','183','257864','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730717),('5','183','257864','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730718),('5','183','257864','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730719),('5','183','257865','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730720),('5','183','257865','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730721),('5','183','257865','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730722),('5','183','257866','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730723),('5','183','257866','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730724),('5','183','257866','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730725),('5','183','257867','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730726),('5','183','257867','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730727),('5','183','257867','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','183','257868','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730729),('5','183','257868','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730730),('5','183','257868','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730731),('5','183','257869','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730732),('5','183','257869','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730733),('5','183','257869','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730734),('5','183','257870','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730735),('5','183','257870','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730736),('5','183','257870','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730737),('5','183','257871','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730738),('5','183','257871','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730739),('5','183','257871','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730740),('5','183','257872','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730741),('5','183','257872','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730742),('5','183','257872','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730743),('5','183','257873','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730744),('5','183','257873','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730745),('5','183','257873','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730746),('5','183','257874','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730747),('5','183','257874','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730748),('5','183','257874','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730749),('5','183','257875','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730750),('5','183','257875','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730751),('5','183','257875','423',185.00,185.00,10596.90,0.00,0.00,0.00,0.00,730752),('5','183','257876','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730753),('5','183','257876','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730754),('5','183','257876','423',185.00,185.00,15870.86,0.00,0.00,0.00,0.00,730755),('5','183','257877','423',185.00,185.00,3382.24,0.00,0.00,0.00,0.00,730756),('5','183','257877','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730757),('5','183','257877','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730758),('5','183','257878','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730759),('5','183','257878','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730760),('5','183','257878','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730761),('5','183','257879','423',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730762),('5','183','257879','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730763),('5','183','257879','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730764),('5','183','257880','423',220.00,185.00,5450.19,0.00,0.00,0.00,0.00,730765),('5','183','257880','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730766),('5','183','257880','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730767),('5','183','257881','423',220.00,185.00,9148.39,0.00,0.00,0.00,0.00,730768),('5','183','257881','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730769),('5','183','257881','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730770),('5','183','257882','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730771),('5','183','257882','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730772),('5','183','257882','423',220.00,220.00,3901.42,0.00,0.00,0.00,0.00,730773),('5','183','257883','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730774),('5','183','257883','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730775),('5','183','257883','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730776),('5','183','257884','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730777),('5','183','257884','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730778),('5','183','257884','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730779),('5','183','257885','423',220.00,220.00,9239.37,0.00,0.00,0.00,0.00,730780),('5','183','257885','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730781),('5','183','257885','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730782),('5','183','257886','423',220.00,220.00,4260.60,0.00,0.00,0.00,0.00,730783),('5','183','257886','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730784),('5','183','257886','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730785),('5','183','257887','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730786),('5','183','257887','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730787),('5','183','257887','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730788),('5','183','257888','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730789),('5','183','257888','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730790),('5','183','257888','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730791),('5','183','257889','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730792),('5','183','257889','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730793),('5','183','257889','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730794),('5','183','257890','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730795),('5','183','257890','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730796),('5','183','257890','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730797),('5','183','257891','423',220.00,220.00,12202.57,0.00,0.00,0.00,0.00,730798),('5','183','257891','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730799),('5','183','257891','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730800),('5','183','257892','423',220.00,220.00,10297.43,0.00,0.00,0.00,0.00,730801),('5','183','257892','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730802),('5','183','257892','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730803),('5','183','257893','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730804),('5','183','257893','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730805),('5','183','257893','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730806),('5','183','257894','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730807),('5','183','257894','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730808),('5','183','257894','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730809),('5','183','257895','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730810),('5','183','257895','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730811),('5','183','257895','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730812),('5','183','257896','423',220.00,220.00,11763.95,0.00,0.00,0.00,0.00,730813),('5','183','257896','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730814),('5','183','257896','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730815),('5','183','257897','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730816),('5','183','257897','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730817),('5','183','257897','423',220.00,220.00,3236.05,0.00,0.00,0.00,0.00,730818),('5','183','257898','423',220.00,220.00,6357.90,0.00,0.00,0.00,0.00,730819),('5','183','257898','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730820),('5','183','257898','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730821),('5','183','257899','423',220.00,220.00,9511.83,0.00,0.00,0.00,0.00,730822),('5','183','257899','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730823),('5','183','257899','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730824),('5','183','257900','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730825),('5','183','257900','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730826),('5','183','257900','423',220.00,220.00,2730.27,0.00,0.00,0.00,0.00,730827),('5','183','257901','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730828),('5','183','257901','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730829),('5','183','257901','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730830),('5','183','257902','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730831),('5','183','257902','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730832),('5','183','257902','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730833),('5','183','257903','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730834),('5','183','257903','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730835),('5','183','257903','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730836),('5','183','257904','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730837),('5','183','257904','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730838),('5','183','257904','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730839),('5','183','257905','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730840),('5','183','257905','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730841),('5','183','257905','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730842),('5','183','257906','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730843),('5','183','257906','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730844),('5','183','257906','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730845),('5','183','257907','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730846),('5','183','257907','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730847),('5','183','257907','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730848),('5','183','257908','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730849),('5','183','257908','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730850),('5','183','257908','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730851),('5','183','257909','423',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730852),('5','183','257909','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730853),('5','183','257909','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730854),('5','183','257910','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730855),('5','183','257910','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730856),('5','183','257910','423',210.00,220.00,4284.90,0.00,0.00,0.00,0.00,730857),('5','183','257911','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730858),('5','183','257911','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730859),('5','183','257911','423',210.00,210.00,10108.46,0.00,0.00,0.00,0.00,730860),('5','183','257912','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730861),('5','183','257912','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730862),('5','183','257912','423',210.00,210.00,10329.57,0.00,0.00,0.00,0.00,730863),('5','183','257913','423',210.00,210.00,13606.31,0.00,0.00,0.00,0.00,730864),('5','183','257913','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730865),('5','183','257913','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730866),('5','183','257914','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730867),('5','183','257914','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730868),('5','183','257914','423',210.00,210.00,11891.09,0.00,0.00,0.00,0.00,730869),('5','183','257915','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730870),('5','183','257915','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730871),('5','183','257915','423',210.00,210.00,10655.82,0.00,0.00,0.00,0.00,730872),('5','183','257916','423',210.00,210.00,10943.06,0.00,0.00,0.00,0.00,730873),('5','183','257916','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730874),('5','183','257916','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730875),('5','183','257917','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730876),('5','183','257917','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730877),('5','183','257917','423',210.00,210.00,13562.84,0.00,0.00,0.00,0.00,730878),('5','183','257918','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730879),('5','183','257918','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730880),('5','183','257918','423',210.00,210.00,13258.21,0.00,0.00,0.00,0.00,730881),('5','183','257919','423',210.00,210.00,13539.83,0.00,0.00,0.00,0.00,730882),('5','183','257919','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730883),('5','183','257919','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730884),('5','183','257920','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730885),('5','183','257920','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730886),('5','183','257920','423',210.00,210.00,6269.04,0.00,0.00,0.00,0.00,730887),('5','183','257921','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730888),('5','183','257921','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730889),('5','183','257921','423',210.00,210.00,14227.80,0.00,0.00,0.00,0.00,730890),('5','183','257922','423',210.00,210.00,14504.97,0.00,0.00,0.00,0.00,730891),('5','183','257922','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730892),('5','183','257922','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730893),('5','183','257923','423',210.00,210.00,11013.27,0.00,0.00,0.00,0.00,730894),('5','183','257923','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730895),('5','183','257923','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730896),('5','183','257924','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730897),('5','183','257924','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730898),('5','183','257924','423',210.00,210.00,2104.33,0.00,0.00,0.00,0.00,730899),('5','183','257925','423',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730900),('5','183','257925','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730901),('5','183','257925','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730902),('5','183','257926','423',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730903),('5','183','257926','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730904),('5','183','257926','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730905),('5','183','257927','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730906),('5','183','257927','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730907),('5','183','257927','423',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730908),('5','183','257928','424',415.00,295.00,0.00,0.00,0.00,0.00,0.00,730909),('5','183','257928','425',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730910),('5','183','257928','423',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730911);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=391 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',390,'183','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=953 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','183','390',949,0,'423','PMS TANK 1',40000.00,1.00,24254.85,'TANK CONTAINING PMS.','576','2021-07-15 05:50:37','2021-07-15 05:50:37','576',5,1),('5','183','390',950,0,'423','PMS TANK 2',40000.00,1.00,7517.32,'TANK CONTAINING PETROLEUM.','576','2021-07-15 06:02:48','2021-07-15 06:02:48','576',5,1),('5','183','390',951,0,'424','AGO TANK',40000.00,1.00,7827.43,'TANKS CONTAINING DIESEL.','576','2021-07-15 06:07:18','2021-07-15 06:07:18','576',5,1),('5','183','390',952,0,'425','DPK TANK',40000.00,1.00,0.00,'TANKS CONTAINING KEROSENE.','576','2021-07-15 06:10:03','2021-07-15 06:10:03','576',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','183',952,0.00,'2023-03-19 06:44:15'),(2,'5','183',951,650.00,'2023-03-19 06:44:15'),(3,'5','183',950,168.65,'2023-03-19 06:44:15'),(4,'5','183',949,1232.67,'2023-03-19 06:44:15');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2632480 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107756,'5','183',NULL,423,'Reception corrector for bridging 125766',0.00,0.00,0.00,15000.00,0.00,'2021-12-01 05:35:06','',''),(2107757,'5','183','949',423,'Received from bridging 125766',0.00,0.00,15000.00,0.00,0.00,'2021-12-01 05:35:06','',''),(2119929,'5','183','949',423,'Sale Id shift 242832',0.00,0.00,0.00,1141.39,0.00,'2021-12-01 20:01:31','',''),(2119930,'5','183','949',423,'Sale Id shift 242832',0.00,0.00,0.00,1194.43,0.00,'2021-12-01 20:01:31','',''),(2119931,'5','183',NULL,423,'Sale Id shift 242832',385410.30,0.00,0.00,0.00,0.00,'2021-12-01 20:01:31','',''),(2126426,'5','183','949',423,'Sale Id shift 243124',0.00,0.00,0.00,3528.73,0.00,'2021-12-02 11:32:23','',''),(2126427,'5','183','949',423,'Sale Id shift 243124',0.00,0.00,0.00,2095.65,0.00,'2021-12-02 11:32:23','',''),(2126428,'5','183',NULL,423,'Sale Id shift 243124',928022.70,0.00,0.00,0.00,0.00,'2021-12-02 11:32:23','',''),(2126445,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2021-12-02 11:33:31','',''),(2160419,'5','183','949',423,'Sale Id shift 243239',0.00,0.00,0.00,4743.78,0.00,'2021-12-04 17:38:39','',''),(2160420,'5','183','949',423,'Sale Id shift 243239',0.00,0.00,0.00,3803.60,0.00,'2021-12-04 17:38:39','',''),(2160421,'5','183',NULL,423,'Sale Id shift 243239',1410317.70,0.00,0.00,0.00,0.00,'2021-12-04 17:38:39','',''),(2161813,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4900500.00,29700.00,0.00,0.00,'2021-12-05 05:16:58','',''),(2162392,'5','183',NULL,423,'Reception corrector for bridging 125939',0.00,0.00,0.00,30000.00,0.00,'2021-12-05 06:43:09','',''),(2162393,'5','183','949',423,'Received from bridging 125939',0.00,0.00,30000.00,0.00,0.00,'2021-12-05 06:43:09','',''),(2175877,'5','183','949',423,'Sale Id shift 243803',0.00,0.00,0.00,3127.62,0.00,'2021-12-06 07:32:23','',''),(2175878,'5','183','949',423,'Sale Id shift 243803',0.00,0.00,0.00,2856.14,0.00,'2021-12-06 07:32:23','',''),(2175879,'5','183',NULL,423,'Sale Id shift 243803',987320.40,0.00,0.00,0.00,0.00,'2021-12-06 07:32:23','',''),(2184192,'5','183',NULL,423,'Reception corrector for bridging 126347',0.00,0.00,0.00,29700.00,0.00,'2021-12-06 15:39:04','',''),(2184193,'5','183','950',423,'Received from bridging 126347',0.00,0.00,29700.00,0.00,0.00,'2021-12-06 15:39:04','',''),(2184756,'5','183','949',423,'Sale Id shift 244159',0.00,0.00,0.00,5315.54,0.00,'2021-12-06 16:04:00','',''),(2184757,'5','183','949',423,'Sale Id shift 244159',0.00,0.00,0.00,4077.98,0.00,'2021-12-06 16:04:00','',''),(2184758,'5','183','950',423,'Sale Id shift 244159',0.00,0.00,0.00,226.73,0.00,'2021-12-06 16:04:00','',''),(2184759,'5','183',NULL,423,'Sale Id shift 244159',1587341.25,0.00,0.00,0.00,0.00,'2021-12-06 16:04:00','',''),(2185242,'5','183','949',423,'Sale Id shift 244208',0.00,0.00,0.00,4463.80,0.00,'2021-12-06 16:31:39','',''),(2185243,'5','183','949',423,'Sale Id shift 244208',0.00,0.00,0.00,3860.41,0.00,'2021-12-06 16:31:39','',''),(2185244,'5','183',NULL,423,'Sale Id shift 244208',1373494.65,0.00,0.00,0.00,0.00,'2021-12-06 16:31:39','',''),(2188524,'5','183','949',423,'Sale Id shift 244237',0.00,0.00,0.00,1982.61,0.00,'2021-12-07 07:28:15','',''),(2188525,'5','183','950',423,'Sale Id shift 244237',0.00,0.00,0.00,5247.37,0.00,'2021-12-07 07:28:15','',''),(2188526,'5','183','950',423,'Sale Id shift 244237',0.00,0.00,0.00,1565.88,0.00,'2021-12-07 07:28:15','',''),(2188527,'5','183',NULL,423,'Sale Id shift 244237',1451316.90,0.00,0.00,0.00,0.00,'2021-12-07 07:28:15','',''),(2200565,'5','183','949',423,'Sale Id shift 244370',0.00,0.00,0.00,1462.89,0.00,'2021-12-08 07:07:48','',''),(2200566,'5','183','949',423,'Sale Id shift 244370',0.00,0.00,0.00,1343.81,0.00,'2021-12-08 07:07:48','',''),(2200567,'5','183','950',423,'Sale Id shift 244370',0.00,0.00,0.00,3133.44,0.00,'2021-12-08 07:07:48','',''),(2200568,'5','183',NULL,423,'Sale Id shift 244370',980123.10,0.00,0.00,0.00,0.00,'2021-12-08 07:07:48','',''),(2224394,'5','183','950',423,'Sale Id shift 244652',0.00,0.00,0.00,5074.17,0.00,'2021-12-09 18:17:47','',''),(2224395,'5','183',NULL,423,'Sale Id shift 244652',837238.05,0.00,0.00,0.00,0.00,'2021-12-09 18:17:47','',''),(2228580,'5','183','950',423,'Sale Id shift 245007',0.00,0.00,0.00,6876.83,0.00,'2021-12-10 09:23:23','',''),(2228581,'5','183',NULL,423,'Sale Id shift 245007',1134676.95,0.00,0.00,0.00,0.00,'2021-12-10 09:23:23','',''),(2251765,'5','183','950',423,'Sale Id shift 245151',0.00,0.00,0.00,5152.98,0.00,'2021-12-11 20:38:42','',''),(2251766,'5','183',NULL,423,'Sale Id shift 245151',850241.70,0.00,0.00,0.00,0.00,'2021-12-11 20:38:42','',''),(2254239,'5','183','950',423,'Sale Id shift 245437',0.00,0.00,0.00,1839.51,0.00,'2021-12-12 08:42:11','',''),(2254240,'5','183',NULL,423,'Sale Id shift 245437',303519.15,0.00,0.00,0.00,0.00,'2021-12-12 08:42:11','',''),(2279444,'5','183','949',423,'Sale Id shift 245918',0.00,0.00,0.00,1688.82,0.00,'2021-12-14 08:38:47','',''),(2279445,'5','183',NULL,423,'Sale Id shift 245918',278655.30,0.00,0.00,0.00,0.00,'2021-12-14 08:38:47','',''),(2282432,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2260500.00,13700.00,0.00,0.00,'2021-12-14 11:49:37','',''),(2285040,'5','183',NULL,423,'Reception corrector for bridging 127375',0.00,0.00,0.00,13700.00,0.00,'2021-12-14 17:01:06','',''),(2285041,'5','183','949',423,'Received from bridging 127375',0.00,0.00,13700.00,0.00,0.00,'2021-12-14 17:01:06','',''),(2287507,'5','183','949',423,'Sale Id shift 246058',0.00,0.00,0.00,5509.79,0.00,'2021-12-15 09:03:50','',''),(2287508,'5','183',NULL,423,'Sale Id shift 246058',909115.35,0.00,0.00,0.00,0.00,'2021-12-15 09:03:50','',''),(2294784,'5','183','949',423,'Sale Id shift 246364',0.00,0.00,0.00,1319.04,0.00,'2021-12-16 08:38:21','',''),(2294785,'5','183','949',423,'Sale Id shift 246364',0.00,0.00,0.00,4030.66,0.00,'2021-12-16 08:38:21','',''),(2294786,'5','183',NULL,423,'Sale Id shift 246364',882700.50,0.00,0.00,0.00,0.00,'2021-12-16 08:38:21','',''),(2299338,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2021-12-16 15:54:40','',''),(2300499,'5','183',NULL,423,'Reception corrector for bridging 127632',0.00,0.00,0.00,13000.00,0.00,'2021-12-16 17:45:16','',''),(2300500,'5','183','949',423,'Received from bridging 127632',0.00,0.00,13000.00,0.00,0.00,'2021-12-16 17:45:16','',''),(2300502,'5','183',NULL,423,'Reception corrector for bridging 127633',0.00,0.00,0.00,27000.00,0.00,'2021-12-16 17:45:27','',''),(2300503,'5','183','950',423,'Received from bridging 127633',0.00,0.00,27000.00,0.00,0.00,'2021-12-16 17:45:27','',''),(2303193,'5','183','949',423,'Sale Id shift 246586',0.00,0.00,0.00,45.02,0.00,'2021-12-17 09:12:07','',''),(2303194,'5','183','949',423,'Sale Id shift 246586',0.00,0.00,0.00,5643.30,0.00,'2021-12-17 09:12:07','',''),(2303195,'5','183',NULL,423,'Sale Id shift 246586',938572.80,0.00,0.00,0.00,0.00,'2021-12-17 09:12:07','',''),(2309389,'5','183','949',423,'Sale Id shift 246949',0.00,0.00,0.00,4671.38,0.00,'2021-12-18 06:54:15','',''),(2309390,'5','183','950',423,'Sale Id shift 246949',0.00,0.00,0.00,1681.47,0.00,'2021-12-18 06:54:15','',''),(2309391,'5','183',NULL,423,'Sale Id shift 246949',1048220.25,0.00,0.00,0.00,0.00,'2021-12-18 06:54:15','',''),(2325605,'5','183','949',423,'Sale Id shift 247067',0.00,0.00,0.00,1325.10,0.00,'2021-12-19 17:34:32','',''),(2325606,'5','183','950',423,'Sale Id shift 247067',0.00,0.00,0.00,2443.67,0.00,'2021-12-19 17:34:32','',''),(2325607,'5','183','950',423,'Sale Id shift 247067',0.00,0.00,0.00,2858.77,0.00,'2021-12-19 17:34:32','',''),(2325608,'5','183',NULL,423,'Sale Id shift 247067',1093544.10,0.00,0.00,0.00,0.00,'2021-12-19 17:34:32','',''),(2332844,'5','183','950',423,'Sale Id shift 247369',0.00,0.00,0.00,2865.27,0.00,'2021-12-20 18:05:20','',''),(2332845,'5','183','950',423,'Sale Id shift 247369',0.00,0.00,0.00,6143.63,0.00,'2021-12-20 18:05:20','',''),(2332846,'5','183',NULL,423,'Sale Id shift 247369',1486468.50,0.00,0.00,0.00,0.00,'2021-12-20 18:05:20','',''),(2338334,'5','183','949',423,'Sale Id shift 247686',0.00,0.00,0.00,2817.51,0.00,'2021-12-21 14:55:18','',''),(2338335,'5','183','950',423,'Sale Id shift 247686',0.00,0.00,0.00,1625.79,0.00,'2021-12-21 14:55:18','',''),(2338336,'5','183',NULL,423,'Sale Id shift 247686',733144.50,0.00,0.00,0.00,0.00,'2021-12-21 14:55:18','',''),(2343890,'5','183','950',423,'Sale Id shift 247909',0.00,0.00,0.00,4415.13,0.00,'2021-12-22 09:54:57','',''),(2343891,'5','183',NULL,423,'Sale Id shift 247909',728496.45,0.00,0.00,0.00,0.00,'2021-12-22 09:54:57','',''),(2349642,'5','183','950',423,'Sale Id shift 248159',0.00,0.00,0.00,3623.35,0.00,'2021-12-23 06:28:09','',''),(2349643,'5','183',NULL,423,'Sale Id shift 248159',597852.75,0.00,0.00,0.00,0.00,'2021-12-23 06:28:09','',''),(2364124,'5','183','950',423,'Sale Id shift 248298',0.00,0.00,0.00,1410.14,0.00,'2021-12-24 14:09:28','',''),(2364125,'5','183',NULL,423,'Sale Id shift 248298',232673.10,0.00,0.00,0.00,0.00,'2021-12-24 14:09:28','',''),(2367996,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4768500.00,28900.00,0.00,0.00,'2021-12-25 05:57:13','',''),(2373648,'5','183',NULL,423,'Reception corrector for bridging 128752',0.00,0.00,0.00,28900.00,0.00,'2021-12-25 15:41:35','',''),(2373649,'5','183','949',423,'Received from bridging 128752',0.00,0.00,28900.00,0.00,0.00,'2021-12-25 15:41:35','',''),(2375174,'5','183','949',423,'Sale Id shift 248630',0.00,0.00,0.00,4397.37,0.00,'2021-12-26 07:26:32','',''),(2375175,'5','183',NULL,423,'Sale Id shift 248630',725566.05,0.00,0.00,0.00,0.00,'2021-12-26 07:26:32','',''),(2380496,'5','183','949',423,'Sale Id shift 248991',0.00,0.00,0.00,2810.54,0.00,'2021-12-27 05:58:56','',''),(2380497,'5','183','949',423,'Sale Id shift 248991',0.00,0.00,0.00,3403.52,0.00,'2021-12-27 05:58:56','',''),(2380498,'5','183',NULL,423,'Sale Id shift 248991',1025319.90,0.00,0.00,0.00,0.00,'2021-12-27 05:58:56','',''),(2388180,'5','183','949',423,'Sale Id shift 249120',0.00,0.00,0.00,5716.46,0.00,'2021-12-28 09:22:25','',''),(2388181,'5','183',NULL,423,'Sale Id shift 249120',943215.90,0.00,0.00,0.00,0.00,'2021-12-28 09:22:25','',''),(2393606,'5','183','949',423,'Sale Id shift 249432',0.00,0.00,0.00,6064.18,0.00,'2021-12-29 06:59:19','',''),(2393607,'5','183',NULL,423,'Sale Id shift 249432',1000589.70,0.00,0.00,0.00,0.00,'2021-12-29 06:59:19','',''),(2400287,'5','183','949',423,'Sale Id shift 249666',0.00,0.00,0.00,3924.72,0.00,'2021-12-30 06:46:16','',''),(2400288,'5','183',NULL,423,'Sale Id shift 249666',647578.80,0.00,0.00,0.00,0.00,'2021-12-30 06:46:16','',''),(2409315,'5','183','949',423,'Sale Id shift 249922',0.00,0.00,0.00,1518.86,0.00,'2021-12-31 09:25:58','',''),(2409316,'5','183',NULL,423,'Sale Id shift 249922',250611.90,0.00,0.00,0.00,0.00,'2021-12-31 09:25:58','',''),(2412004,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2021-12-31 14:34:31','',''),(2414188,'5','183',NULL,423,'Reception corrector for bridging 129324',0.00,0.00,0.00,26500.00,0.00,'2021-12-31 20:56:27','',''),(2414189,'5','183','949',423,'Received from bridging 129324',0.00,0.00,26500.00,0.00,0.00,'2021-12-31 20:56:27','',''),(2414190,'5','183',NULL,423,'Reception corrector for bridging 129325',0.00,0.00,0.00,13500.00,0.00,'2021-12-31 20:56:37','',''),(2414191,'5','183','950',423,'Received from bridging 129325',0.00,0.00,13500.00,0.00,0.00,'2021-12-31 20:56:37','',''),(2415080,'5','183','949',423,'Sale Id shift 250238',0.00,0.00,0.00,2460.80,0.00,'2022-01-01 07:42:42','',''),(2415081,'5','183',NULL,423,'Sale Id shift 250238',406032.00,0.00,0.00,0.00,0.00,'2022-01-01 07:42:42','',''),(2421394,'5','183','949',423,'Sale Id shift 250495',0.00,0.00,0.00,7194.16,0.00,'2022-01-02 08:07:28','',''),(2421395,'5','183',NULL,423,'Sale Id shift 250495',1187036.40,0.00,0.00,0.00,0.00,'2022-01-02 08:07:28','',''),(2426574,'5','183','949',423,'Sale Id shift 250774',0.00,0.00,0.00,4478.40,0.00,'2022-01-03 06:58:54','',''),(2426575,'5','183','950',423,'Sale Id shift 250774',0.00,0.00,0.00,3283.47,0.00,'2022-01-03 06:58:54','',''),(2426576,'5','183',NULL,423,'Sale Id shift 250774',1280708.55,0.00,0.00,0.00,0.00,'2022-01-03 06:58:54','',''),(2434216,'5','183','949',423,'Sale Id shift 251051',0.00,0.00,0.00,3224.83,0.00,'2022-01-04 08:40:52','',''),(2434217,'5','183','950',423,'Sale Id shift 251051',0.00,0.00,0.00,4484.84,0.00,'2022-01-04 08:40:52','',''),(2434218,'5','183',NULL,423,'Sale Id shift 251051',1272095.55,0.00,0.00,0.00,0.00,'2022-01-04 08:40:52','',''),(2439784,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6567000.00,39800.00,0.00,0.00,'2022-01-04 17:52:42','',''),(2440398,'5','183',NULL,423,'Reception corrector for bridging 129739',0.00,0.00,0.00,13300.00,0.00,'2022-01-05 05:59:32','',''),(2440399,'5','183','950',423,'Received from bridging 129739',0.00,0.00,13300.00,0.00,0.00,'2022-01-05 05:59:32','',''),(2449409,'5','183','949',423,'Sale Id shift 251122',0.00,0.00,0.00,2943.07,0.00,'2022-01-06 09:25:20','',''),(2449410,'5','183','949',423,'Sale Id shift 251122',0.00,0.00,0.00,6702.43,0.00,'2022-01-06 09:25:20','',''),(2449411,'5','183','950',423,'Sale Id shift 251122',0.00,0.00,0.00,29.33,0.00,'2022-01-06 09:25:20','',''),(2449412,'5','183',NULL,423,'Sale Id shift 251122',1596346.95,0.00,0.00,0.00,0.00,'2022-01-06 09:25:20','',''),(2458550,'5','183',NULL,423,'Reception corrector for bridging 129738',0.00,0.00,0.00,26500.00,0.00,'2022-01-07 11:44:12','',''),(2458551,'5','183','949',423,'Received from bridging 129738',0.00,0.00,26500.00,0.00,0.00,'2022-01-07 11:44:12','',''),(2486898,'5','183','949',423,'Sale Id shift 251763',0.00,0.00,0.00,6593.40,0.00,'2022-01-11 08:20:10','',''),(2486899,'5','183','949',423,'Sale Id shift 251763',0.00,0.00,0.00,2740.17,0.00,'2022-01-11 08:20:10','',''),(2486900,'5','183',NULL,423,'Sale Id shift 251763',1540039.05,0.00,0.00,0.00,0.00,'2022-01-11 08:20:10','',''),(2489508,'5','183','949',423,'Sale Id shift 252813',0.00,0.00,0.00,6862.24,0.00,'2022-01-11 12:45:44','',''),(2489509,'5','183','949',423,'Sale Id shift 252813',0.00,0.00,0.00,1446.88,0.00,'2022-01-11 12:45:44','',''),(2489510,'5','183',NULL,423,'Sale Id shift 252813',1371004.80,0.00,0.00,0.00,0.00,'2022-01-11 12:45:45','',''),(2490092,'5','183','949',423,'Sale Id shift 252832',0.00,0.00,0.00,5019.81,0.00,'2022-01-11 13:58:09','',''),(2490093,'5','183','949',423,'Sale Id shift 252832',0.00,0.00,0.00,1414.46,0.00,'2022-01-11 13:58:09','',''),(2490094,'5','183',NULL,423,'Sale Id shift 252832',1061654.55,0.00,0.00,0.00,0.00,'2022-01-11 13:58:09','',''),(2490146,'5','183','949',423,'Sale Id shift 252840',0.00,0.00,0.00,1507.98,0.00,'2022-01-11 14:05:51','',''),(2490147,'5','183','949',423,'Sale Id shift 252840',0.00,0.00,0.00,1528.40,0.00,'2022-01-11 14:05:51','',''),(2490148,'5','183','950',423,'Sale Id shift 252840',0.00,0.00,0.00,3413.78,0.00,'2022-01-11 14:05:51','',''),(2490149,'5','183',NULL,423,'Sale Id shift 252840',1064276.40,0.00,0.00,0.00,0.00,'2022-01-11 14:05:51','',''),(2490273,'5','183','950',423,'Sale Id shift 252844',0.00,0.00,0.00,713.71,0.00,'2022-01-11 14:20:11','',''),(2490274,'5','183','950',423,'Sale Id shift 252844',0.00,0.00,0.00,5194.45,0.00,'2022-01-11 14:20:11','',''),(2490275,'5','183',NULL,423,'Sale Id shift 252844',974846.40,0.00,0.00,0.00,0.00,'2022-01-11 14:20:11','',''),(2490485,'5','183','950',423,'Sale Id shift 252853',0.00,0.00,0.00,55.73,0.00,'2022-01-11 14:34:54','',''),(2490486,'5','183','950',423,'Sale Id shift 252853',0.00,0.00,0.00,4778.70,0.00,'2022-01-11 14:34:54','',''),(2490487,'5','183',NULL,423,'Sale Id shift 252853',797680.95,0.00,0.00,0.00,0.00,'2022-01-11 14:34:54','',''),(2490630,'5','183','950',423,'Sale Id shift 252860',0.00,0.00,0.00,340.75,0.00,'2022-01-11 14:48:54','',''),(2490631,'5','183','950',423,'Sale Id shift 252860',0.00,0.00,0.00,2785.81,0.00,'2022-01-11 14:48:54','',''),(2490632,'5','183',NULL,423,'Sale Id shift 252860',515882.40,0.00,0.00,0.00,0.00,'2022-01-11 14:48:54','',''),(2494419,'5','183','950',423,'Sale Id shift 252864',0.00,0.00,0.00,1029.47,0.00,'2022-01-12 08:14:10','',''),(2494420,'5','183',NULL,423,'Sale Id shift 252864',169862.55,0.00,0.00,0.00,0.00,'2022-01-12 08:14:10','',''),(2515805,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-01-14 18:25:27','',''),(2516654,'5','183',NULL,423,'Reception corrector for bridging 130923',0.00,0.00,0.00,26700.00,0.00,'2022-01-15 06:45:38','',''),(2516655,'5','183','949',423,'Received from bridging 130923',0.00,0.00,26700.00,0.00,0.00,'2022-01-15 06:45:38','',''),(2516656,'5','183',NULL,423,'Reception corrector for bridging 130924',0.00,0.00,0.00,13300.00,0.00,'2022-01-15 06:45:52','',''),(2516657,'5','183','950',423,'Received from bridging 130924',0.00,0.00,13300.00,0.00,0.00,'2022-01-15 06:45:52','',''),(2517896,'5','183','949',423,'Sale Id shift 253638',0.00,0.00,0.00,6751.58,0.00,'2022-01-15 09:08:23','',''),(2517897,'5','183',NULL,423,'Sale Id shift 253638',1114010.70,0.00,0.00,0.00,0.00,'2022-01-15 09:08:23','',''),(2525758,'5','183','949',423,'Sale Id shift 253872',0.00,0.00,0.00,4137.69,0.00,'2022-01-16 06:54:51','',''),(2525759,'5','183','950',423,'Sale Id shift 253872',0.00,0.00,0.00,3138.04,0.00,'2022-01-16 06:54:51','',''),(2525760,'5','183',NULL,423,'Sale Id shift 253872',1200495.45,0.00,0.00,0.00,0.00,'2022-01-16 06:54:51','',''),(2534712,'5','183','949',423,'Sale Id shift 254079',0.00,0.00,0.00,4548.54,0.00,'2022-01-17 08:29:13','',''),(2534713,'5','183','950',423,'Sale Id shift 254079',0.00,0.00,0.00,1769.41,0.00,'2022-01-17 08:29:13','',''),(2534714,'5','183',NULL,423,'Sale Id shift 254079',1042461.75,0.00,0.00,0.00,0.00,'2022-01-17 08:29:13','',''),(2541054,'5','183','949',423,'Sale Id shift 254244',0.00,0.00,0.00,5632.55,0.00,'2022-01-18 07:07:50','',''),(2541055,'5','183','949',423,'Sale Id shift 254244',0.00,0.00,0.00,2132.39,0.00,'2022-01-18 07:07:50','',''),(2541056,'5','183',NULL,423,'Sale Id shift 254244',1281215.10,0.00,0.00,0.00,0.00,'2022-01-18 07:07:50','',''),(2549324,'5','183','949',423,'Sale Id shift 254482',0.00,0.00,0.00,3381.62,0.00,'2022-01-19 08:50:47','',''),(2549325,'5','183','950',423,'Sale Id shift 254482',0.00,0.00,0.00,1712.20,0.00,'2022-01-19 08:50:47','',''),(2549326,'5','183',NULL,423,'Sale Id shift 254482',840480.30,0.00,0.00,0.00,0.00,'2022-01-19 08:50:47','',''),(2556050,'5','183','950',423,'Sale Id shift 254933',0.00,0.00,0.00,1688.55,0.00,'2022-01-20 06:35:02','',''),(2556051,'5','183','950',423,'Sale Id shift 254933',0.00,0.00,0.00,910.12,0.00,'2022-01-20 06:35:02','',''),(2556052,'5','183',NULL,423,'Sale Id shift 254933',428780.55,0.00,0.00,0.00,0.00,'2022-01-20 06:35:02','',''),(2567075,'5','183','950',423,'Sale Id shift 255018',0.00,0.00,0.00,2705.57,0.00,'2022-01-21 11:16:36','',''),(2567076,'5','183',NULL,423,'Sale Id shift 255018',446419.05,0.00,0.00,0.00,0.00,'2022-01-21 11:16:36','',''),(2574004,'5','183','950',423,'Sale Id shift 255340',0.00,0.00,0.00,1152.79,0.00,'2022-01-22 09:18:13','',''),(2574005,'5','183',NULL,423,'Sale Id shift 255340',190210.35,0.00,0.00,0.00,0.00,'2022-01-22 09:18:13','',''),(2589405,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6567000.00,39800.00,0.00,0.00,'2022-01-23 18:55:06','',''),(2589923,'5','183',NULL,423,'Reception corrector for bridging 131917',0.00,0.00,0.00,13000.00,0.00,'2022-01-24 05:47:13','',''),(2589924,'5','183','950',423,'Received from bridging 131917',0.00,0.00,13000.00,0.00,0.00,'2022-01-24 05:47:13','',''),(2589925,'5','183',NULL,423,'Reception corrector for bridging 131916',0.00,0.00,0.00,26800.00,0.00,'2022-01-24 05:47:23','',''),(2589926,'5','183','949',423,'Received from bridging 131916',0.00,0.00,26800.00,0.00,0.00,'2022-01-24 05:47:23','',''),(2590456,'5','183','949',423,'Sale Id shift 255888',0.00,0.00,0.00,1936.76,0.00,'2022-01-24 08:22:09','',''),(2590457,'5','183','950',423,'Sale Id shift 255888',0.00,0.00,0.00,4185.96,0.00,'2022-01-24 08:22:09','',''),(2590458,'5','183',NULL,423,'Sale Id shift 255888',1010248.80,0.00,0.00,0.00,0.00,'2022-01-24 08:22:09','',''),(2597620,'5','183','949',423,'Sale Id shift 256143',0.00,0.00,0.00,1997.61,0.00,'2022-01-25 08:24:15','',''),(2597621,'5','183','950',423,'Sale Id shift 256143',0.00,0.00,0.00,5715.33,0.00,'2022-01-25 08:24:15','',''),(2597622,'5','183',NULL,423,'Sale Id shift 256143',1272635.10,0.00,0.00,0.00,0.00,'2022-01-25 08:24:15','',''),(2607429,'5','183','949',423,'Sale Id shift 256359',0.00,0.00,0.00,6783.58,0.00,'2022-01-26 10:07:29','',''),(2607430,'5','183',NULL,423,'Sale Id shift 256359',1119290.70,0.00,0.00,0.00,0.00,'2022-01-26 10:07:29','',''),(2612724,'5','183',NULL,424,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,195000.00,1300.00,650.00,0.00,'2021-11-30 23:59:59','',''),(2612776,'5','183',NULL,423,'Balance from closing inventory values 2021-11-31 23:59:59',43989940.26,46925550.00,556900.00,539077.18,0.00,'2021-11-30 23:59:59','',''),(2612851,'5','183',NULL,425,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613555,'5','183','950',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,116100.00,112926.94,0.00,'2021-11-30 23:59:59','',''),(2613587,'5','183','949',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,204141.00,199491.65,0.00,'2021-11-30 23:59:59','',''),(2613625,'5','183','952',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614006,'5','183','951',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,650.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614153,'5','183','949',423,'Sale Id shift 256559',0.00,0.00,0.00,7161.10,0.00,'2022-01-27 07:07:53','',''),(2614154,'5','183',NULL,423,'Sale Id shift 256559',1181581.50,0.00,0.00,0.00,0.00,'2022-01-27 07:07:53','',''),(2622743,'5','183','949',423,'Sale Id shift 256801',0.00,0.00,0.00,5551.45,0.00,'2022-01-28 06:37:32','',''),(2622744,'5','183',NULL,423,'Sale Id shift 256801',915989.25,0.00,0.00,0.00,0.00,'2022-01-28 06:37:32','',''),(2631466,'5','183','949',423,'Sale Id shift 257012',0.00,0.00,0.00,3341.23,0.00,'2022-01-29 07:13:39','',''),(2631467,'5','183',NULL,423,'Sale Id shift 257012',551302.95,0.00,0.00,0.00,0.00,'2022-01-29 07:13:39','',''),(2631468,'5','183','950',423,'Sale Id shift 257524',0.00,0.00,0.00,2482.77,0.00,'2022-01-31 11:25:35','',''),(2631469,'5','183','950',423,'Sale Id shift 257524',0.00,0.00,0.00,700.09,0.00,'2022-01-31 11:25:35','',''),(2631470,'5','183',NULL,423,'Sale Id shift 257524',525171.90,0.00,0.00,0.00,0.00,'2022-01-31 11:25:35','',''),(2631471,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-02 19:22:52','',''),(2631472,'5','183','949',423,'Sale Id shift 257526',0.00,0.00,0.00,1052.85,0.00,'2022-02-02 19:54:57','',''),(2631473,'5','183','950',423,'Sale Id shift 257526',0.00,0.00,0.00,1278.76,0.00,'2022-02-02 19:54:57','',''),(2631474,'5','183',NULL,423,'Sale Id shift 257526',384715.65,0.00,0.00,0.00,0.00,'2022-02-02 19:54:57','',''),(2631475,'5','183',NULL,423,'Reception corrector for bridging 131918',0.00,0.00,0.00,26500.00,0.00,'2022-02-02 20:32:35','',''),(2631476,'5','183','949',423,'Received from bridging 131918',0.00,0.00,26500.00,0.00,0.00,'2022-02-02 20:32:35','',''),(2631477,'5','183',NULL,423,'Reception corrector for bridging 131919',0.00,0.00,0.00,13500.00,0.00,'2022-02-02 20:32:50','',''),(2631478,'5','183','950',423,'Received from bridging 131919',0.00,0.00,13500.00,0.00,0.00,'2022-02-02 20:32:50','',''),(2631479,'5','183','949',423,'Sale Id shift 257527',0.00,0.00,0.00,6100.45,0.00,'2022-02-03 07:55:36','',''),(2631480,'5','183','949',423,'Sale Id shift 257527',0.00,0.00,0.00,2899.95,0.00,'2022-02-03 07:55:36','',''),(2631481,'5','183',NULL,423,'Sale Id shift 257527',1485066.00,0.00,0.00,0.00,0.00,'2022-02-03 07:55:36','',''),(2631482,'5','183','949',423,'Sale Id shift 257528',0.00,0.00,0.00,5769.64,0.00,'2022-02-04 07:29:42','',''),(2631483,'5','183','949',423,'Sale Id shift 257528',0.00,0.00,0.00,1421.39,0.00,'2022-02-04 07:29:42','',''),(2631484,'5','183',NULL,423,'Sale Id shift 257528',1186519.95,0.00,0.00,0.00,0.00,'2022-02-04 07:29:42','',''),(2631485,'5','183','949',423,'Sale Id shift 257529',0.00,0.00,0.00,4729.42,0.00,'2022-02-05 07:36:37','',''),(2631486,'5','183','950',423,'Sale Id shift 257529',0.00,0.00,0.00,1809.82,0.00,'2022-02-05 07:36:37','',''),(2631487,'5','183',NULL,423,'Sale Id shift 257529',1078974.60,0.00,0.00,0.00,0.00,'2022-02-05 07:36:37','',''),(2631488,'5','183','949',423,'Sale Id shift 257530',0.00,0.00,0.00,4666.21,0.00,'2022-02-06 09:32:00','',''),(2631489,'5','183','950',423,'Sale Id shift 257530',0.00,0.00,0.00,89.27,0.00,'2022-02-06 09:32:00','',''),(2631490,'5','183',NULL,423,'Sale Id shift 257530',784654.20,0.00,0.00,0.00,0.00,'2022-02-06 09:32:00','',''),(2631491,'5','183','950',423,'Sale Id shift 257531',0.00,0.00,0.00,3883.22,0.00,'2022-02-07 09:50:17','',''),(2631492,'5','183','950',423,'Sale Id shift 257531',0.00,0.00,0.00,427.26,0.00,'2022-02-07 09:50:17','',''),(2631493,'5','183',NULL,423,'Sale Id shift 257531',711229.20,0.00,0.00,0.00,0.00,'2022-02-07 09:50:17','',''),(2631494,'5','183','950',423,'Sale Id shift 257532',0.00,0.00,0.00,3297.84,0.00,'2022-02-08 07:16:56','',''),(2631495,'5','183',NULL,423,'Sale Id shift 257532',544143.60,0.00,0.00,0.00,0.00,'2022-02-08 07:16:56','',''),(2631496,'5','183','950',423,'Sale Id shift 257533',0.00,0.00,0.00,2246.01,0.00,'2022-02-09 07:21:37','',''),(2631497,'5','183',NULL,423,'Sale Id shift 257533',370591.65,0.00,0.00,0.00,0.00,'2022-02-09 07:21:37','',''),(2631498,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7546770.00,45738.00,0.00,0.00,'2022-02-14 15:38:11','',''),(2631499,'5','183',NULL,423,'Reception corrector for bridging 131921',0.00,0.00,0.00,25000.00,0.00,'2022-02-14 15:41:09','',''),(2631500,'5','183','950',423,'Received from bridging 131921',0.00,0.00,25000.00,0.00,0.00,'2022-02-14 15:41:09','',''),(2631501,'5','183',NULL,423,'Reception corrector for bridging 131920',0.00,0.00,0.00,20738.00,0.00,'2022-02-14 15:41:09','',''),(2631502,'5','183','949',423,'Received from bridging 131920',0.00,0.00,20738.00,0.00,0.00,'2022-02-14 15:41:09','',''),(2631503,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,24989.66,0.00,'2022-02-14 15:41:34','',''),(2631504,'5','183','949',0,'Inventory adjustment from tank dipping to 4252',0.00,0.00,4252.00,0.00,0.00,'2022-02-14 15:41:34','',''),(2631505,'5','183','950',0,'Tank level zero out for dipping',0.00,0.00,0.00,29985.88,0.00,'2022-02-14 15:41:52','',''),(2631506,'5','183','950',0,'Inventory adjustment from tank dipping to 4986',0.00,0.00,4986.00,0.00,0.00,'2022-02-14 15:41:52','',''),(2631507,'5','183',NULL,423,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7426485.00,45009.00,0.00,0.00,'2022-02-16 21:33:47','',''),(2631508,'5','183',NULL,423,'Reception corrector for bridging 131923',0.00,0.00,0.00,22000.00,0.00,'2022-02-17 10:12:25','',''),(2631509,'5','183','950',423,'Received from bridging 131923',0.00,0.00,22000.00,0.00,0.00,'2022-02-17 10:12:25','',''),(2631510,'5','183',NULL,423,'Reception corrector for bridging 131922',0.00,0.00,0.00,23000.00,0.00,'2022-02-17 10:12:45','',''),(2631511,'5','183','949',423,'Received from bridging 131922',0.00,0.00,23000.00,0.00,0.00,'2022-02-17 10:12:45','',''),(2631512,'5','183','949',423,'Sale Id shift 257540',0.00,0.00,0.00,1172.75,0.00,'2022-02-17 21:04:58','',''),(2631513,'5','183','949',423,'Sale Id shift 257540',0.00,0.00,0.00,493.37,0.00,'2022-02-17 21:04:58','',''),(2631514,'5','183',NULL,423,'Sale Id shift 257540',274909.80,0.00,0.00,0.00,0.00,'2022-02-17 21:04:58','',''),(2631515,'5','183','949',423,'Sale Id shift 257541',0.00,0.00,0.00,7728.49,0.00,'2022-02-19 07:18:13','',''),(2631516,'5','183','949',423,'Sale Id shift 257541',0.00,0.00,0.00,133.07,0.00,'2022-02-19 07:18:13','',''),(2631517,'5','183',NULL,423,'Sale Id shift 257541',1297157.40,0.00,0.00,0.00,0.00,'2022-02-19 07:18:13','',''),(2631518,'5','183','949',423,'Sale Id shift 257542',0.00,0.00,0.00,7007.05,0.00,'2022-02-19 21:53:09','',''),(2631519,'5','183','949',423,'Sale Id shift 257542',0.00,0.00,0.00,558.53,0.00,'2022-02-19 21:53:09','',''),(2631520,'5','183',NULL,423,'Sale Id shift 257542',1248320.70,0.00,0.00,0.00,0.00,'2022-02-19 21:53:09','',''),(2631521,'5','183','949',423,'Sale Id shift 257543',0.00,0.00,0.00,5652.85,0.00,'2022-02-20 12:24:18','',''),(2631522,'5','183',NULL,423,'Sale Id shift 257543',932720.25,0.00,0.00,0.00,0.00,'2022-02-20 12:24:18','',''),(2631523,'5','183','950',423,'Sale Id shift 257544',0.00,0.00,0.00,7131.89,0.00,'2022-02-21 08:41:59','',''),(2631524,'5','183',NULL,423,'Sale Id shift 257544',1176761.85,0.00,0.00,0.00,0.00,'2022-02-21 08:41:59','',''),(2631525,'5','183','950',423,'Sale Id shift 257545',0.00,0.00,0.00,5948.64,0.00,'2022-02-22 07:47:17','',''),(2631526,'5','183',NULL,423,'Sale Id shift 257545',981525.60,0.00,0.00,0.00,0.00,'2022-02-22 07:47:17','',''),(2631527,'5','183','950',423,'Sale Id shift 257546',0.00,0.00,0.00,5722.92,0.00,'2022-02-23 07:11:24','',''),(2631528,'5','183',NULL,423,'Sale Id shift 257546',944281.80,0.00,0.00,0.00,0.00,'2022-02-23 07:11:24','',''),(2631529,'5','183','950',423,'Sale Id shift 257547',0.00,0.00,0.00,2864.86,0.00,'2022-02-24 07:57:41','',''),(2631530,'5','183',NULL,423,'Sale Id shift 257547',472701.90,0.00,0.00,0.00,0.00,'2022-02-24 07:57:41','',''),(2631531,'5','183',NULL,424,'Purchased from SALBAS OIL & GAS LIMITED',0.00,16600000.00,40000.00,0.00,0.00,'2022-02-24 15:45:36','',''),(2631532,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-25 06:45:51','',''),(2631533,'5','183',NULL,423,'Reception corrector for bridging 131924',0.00,0.00,0.00,26500.00,0.00,'2022-02-26 21:43:34','',''),(2631534,'5','183','949',423,'Received from bridging 131924',0.00,0.00,26500.00,0.00,0.00,'2022-02-26 21:43:34','',''),(2631535,'5','183',NULL,423,'Reception corrector for bridging 131925',0.00,0.00,0.00,13500.00,0.00,'2022-02-26 21:43:47','',''),(2631536,'5','183','950',423,'Received from bridging 131925',0.00,0.00,13500.00,0.00,0.00,'2022-02-26 21:43:47','',''),(2631537,'5','183','949',423,'Sale Id shift 257548',0.00,0.00,0.00,8583.16,0.00,'2022-02-27 09:11:22','',''),(2631538,'5','183',NULL,423,'Sale Id shift 257548',1416221.40,0.00,0.00,0.00,0.00,'2022-02-27 09:11:22','',''),(2631539,'5','183','949',423,'Sale Id shift 257549',0.00,0.00,0.00,7856.69,0.00,'2022-02-27 15:52:04','',''),(2631540,'5','183','950',423,'Sale Id shift 257549',0.00,0.00,0.00,981.21,0.00,'2022-02-27 15:52:04','',''),(2631541,'5','183',NULL,423,'Sale Id shift 257549',1458253.50,0.00,0.00,0.00,0.00,'2022-02-27 15:52:04','',''),(2631542,'5','183','949',423,'Sale Id shift 257550',0.00,0.00,0.00,7281.00,0.00,'2022-02-27 16:41:57','',''),(2631543,'5','183','949',423,'Sale Id shift 257550',0.00,0.00,0.00,212.10,0.00,'2022-02-27 16:41:57','',''),(2631544,'5','183',NULL,423,'Sale Id shift 257550',1236361.50,0.00,0.00,0.00,0.00,'2022-02-27 16:41:57','',''),(2631545,'5','183','949',423,'Sale Id shift 257551',0.00,0.00,0.00,6989.17,0.00,'2022-02-28 08:12:53','',''),(2631546,'5','183',NULL,423,'Sale Id shift 257551',1153213.05,0.00,0.00,0.00,0.00,'2022-02-28 08:12:53','',''),(2631547,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,83.77,0.00,'2022-03-01 20:39:16','',''),(2631548,'5','183','949',0,'Inventory adjustment from tank dipping to 11000',0.00,0.00,11000.00,0.00,0.00,'2022-03-01 20:39:16','',''),(2631549,'5','183','949',423,'Sale Id shift 257552',0.00,0.00,0.00,5189.25,0.00,'2022-03-02 09:40:20','',''),(2631550,'5','183','949',423,'Sale Id shift 257552',0.00,0.00,0.00,5576.36,0.00,'2022-03-02 09:40:20','',''),(2631551,'5','183',NULL,423,'Sale Id shift 257552',1776325.65,0.00,0.00,0.00,0.00,'2022-03-02 09:40:20','',''),(2631552,'5','183','950',423,'Sale Id shift 257553',0.00,0.00,0.00,6230.30,0.00,'2022-03-02 10:01:26','',''),(2631553,'5','183',NULL,423,'Sale Id shift 257553',1027999.50,0.00,0.00,0.00,0.00,'2022-03-02 10:01:26','',''),(2631554,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,825.00,5.00,0.00,0.00,'2022-03-02 14:34:01','',''),(2631555,'5','183','950',423,'Sale Id shift 257554',0.00,0.00,0.00,3490.77,0.00,'2022-03-03 08:07:32','',''),(2631556,'5','183',NULL,423,'Sale Id shift 257554',575977.05,0.00,0.00,0.00,0.00,'2022-03-03 08:07:32','',''),(2631557,'5','183','950',423,'Sale Id shift 257555',0.00,0.00,0.00,2789.79,0.00,'2022-03-04 10:02:45','',''),(2631558,'5','183',NULL,423,'Sale Id shift 257555',460315.35,0.00,0.00,0.00,0.00,'2022-03-04 10:02:45','',''),(2631559,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4809750.00,29150.00,0.00,0.00,'2022-03-05 14:17:11','',''),(2631560,'5','183',NULL,423,'Reception corrector for bridging 131927',0.00,0.00,0.00,29150.00,0.00,'2022-03-05 16:16:59','',''),(2631561,'5','183','949',423,'Received from bridging 131927',0.00,0.00,29150.00,0.00,0.00,'2022-03-05 16:16:59','',''),(2631562,'5','183','949',423,'Sale Id shift 257556',0.00,0.00,0.00,8659.37,0.00,'2022-03-05 19:31:14','',''),(2631563,'5','183',NULL,423,'Sale Id shift 257556',1428796.05,0.00,0.00,0.00,0.00,'2022-03-05 19:31:14','',''),(2631564,'5','183','949',423,'Sale Id shift 257557',0.00,0.00,0.00,11989.83,0.00,'2022-03-06 08:54:32','',''),(2631565,'5','183',NULL,423,'Sale Id shift 257557',1978321.95,0.00,0.00,0.00,0.00,'2022-03-06 08:54:32','',''),(2631566,'5','183','949',423,'Sale Id shift 257558',0.00,0.00,0.00,6864.73,0.00,'2022-03-07 20:08:44','',''),(2631567,'5','183',NULL,423,'Sale Id shift 257558',1132680.45,0.00,0.00,0.00,0.00,'2022-03-07 20:08:44','',''),(2631568,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4364250.00,26450.00,0.00,0.00,'2022-03-08 10:55:51','',''),(2631569,'5','183',NULL,423,'Reception corrector for bridging 131928',0.00,0.00,0.00,26450.00,0.00,'2022-03-08 11:53:05','',''),(2631570,'5','183','949',423,'Received from bridging 131928',0.00,0.00,26450.00,0.00,0.00,'2022-03-08 11:53:05','',''),(2631571,'5','183','949',423,'Sale Id shift 257559',0.00,0.00,0.00,8432.18,0.00,'2022-03-08 12:19:41','',''),(2631572,'5','183',NULL,423,'Sale Id shift 257559',1391309.70,0.00,0.00,0.00,0.00,'2022-03-08 12:19:41','',''),(2631573,'5','183','949',423,'Sale Id shift 257560',0.00,0.00,0.00,5421.44,0.00,'2022-03-09 07:50:57','',''),(2631574,'5','183',NULL,423,'Sale Id shift 257560',894537.60,0.00,0.00,0.00,0.00,'2022-03-09 07:50:57','',''),(2631575,'5','183','949',423,'Sale Id shift 257561',0.00,0.00,0.00,6002.30,0.00,'2022-03-10 07:39:25','',''),(2631576,'5','183',NULL,423,'Sale Id shift 257561',990379.50,0.00,0.00,0.00,0.00,'2022-03-10 07:39:25','',''),(2631577,'5','183','949',423,'Sale Id shift 257562',0.00,0.00,0.00,5881.35,0.00,'2022-03-11 08:54:30','',''),(2631578,'5','183','949',423,'Sale Id shift 257562',0.00,0.00,0.00,1392.84,0.00,'2022-03-11 08:54:30','',''),(2631579,'5','183',NULL,423,'Sale Id shift 257562',1200241.35,0.00,0.00,0.00,0.00,'2022-03-11 08:54:30','',''),(2631580,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-13 14:09:46','',''),(2631581,'5','183',NULL,423,'Reception corrector for bridging 131931',0.00,0.00,0.00,13500.00,0.00,'2022-03-13 14:31:44','',''),(2631582,'5','183','950',423,'Received from bridging 131931',0.00,0.00,13500.00,0.00,0.00,'2022-03-13 14:31:44','',''),(2631583,'5','183',NULL,423,'Reception corrector for bridging 131930',0.00,0.00,0.00,26500.00,0.00,'2022-03-13 14:31:54','',''),(2631584,'5','183','949',423,'Received from bridging 131930',0.00,0.00,26500.00,0.00,0.00,'2022-03-13 14:31:54','',''),(2631585,'5','183','949',423,'Sale Id shift 257564',0.00,0.00,0.00,10462.68,0.00,'2022-03-14 06:04:56','',''),(2631586,'5','183',NULL,423,'Sale Id shift 257564',1726342.20,0.00,0.00,0.00,0.00,'2022-03-14 06:04:56','',''),(2631587,'5','183','949',423,'Sale Id shift 257565',0.00,0.00,0.00,7377.66,0.00,'2022-03-15 05:58:31','',''),(2631588,'5','183',NULL,423,'Sale Id shift 257565',1217313.90,0.00,0.00,0.00,0.00,'2022-03-15 05:58:31','',''),(2631589,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,9850.01,0.00,'2022-03-15 08:47:50','',''),(2631590,'5','183','949',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-03-15 08:47:50','',''),(2631591,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,1000.00,0.00,'2022-03-15 08:48:56','',''),(2631592,'5','183','949',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-03-15 08:48:56','',''),(2631593,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6550500.00,39700.00,0.00,0.00,'2022-03-15 11:35:35','',''),(2631594,'5','183',NULL,423,'Reception corrector for bridging 131932',0.00,0.00,0.00,19850.00,0.00,'2022-03-15 11:40:29','',''),(2631595,'5','183','949',423,'Received from bridging 131932',0.00,0.00,19850.00,0.00,0.00,'2022-03-15 11:40:29','',''),(2631596,'5','183',NULL,423,'Reception corrector for bridging 131933',0.00,0.00,0.00,19850.00,0.00,'2022-03-15 11:40:38','',''),(2631597,'5','183','950',423,'Received from bridging 131933',0.00,0.00,19850.00,0.00,0.00,'2022-03-15 11:40:38','',''),(2631598,'5','183','949',423,'Sale Id shift 257566',0.00,0.00,0.00,10243.54,0.00,'2022-03-15 12:01:13','',''),(2631599,'5','183','949',423,'Sale Id shift 257566',0.00,0.00,0.00,407.78,0.00,'2022-03-15 12:01:13','',''),(2631600,'5','183',NULL,423,'Sale Id shift 257566',1757467.80,0.00,0.00,0.00,0.00,'2022-03-15 12:01:13','',''),(2631601,'5','183','949',423,'Sale Id shift 257567',0.00,0.00,0.00,8571.11,0.00,'2022-03-16 08:12:44','',''),(2631602,'5','183','949',423,'Sale Id shift 257567',0.00,0.00,0.00,583.00,0.00,'2022-03-16 08:12:44','',''),(2631603,'5','183',NULL,423,'Sale Id shift 257567',1510428.15,0.00,0.00,0.00,0.00,'2022-03-16 08:12:44','',''),(2631604,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,1044.57,0.00,'2022-03-17 10:17:35','',''),(2631605,'5','183','949',0,'Inventory adjustment from tank dipping to 14950',0.00,0.00,14950.00,0.00,0.00,'2022-03-17 10:17:35','',''),(2631606,'5','183','949',423,'Sale Id shift 257568',0.00,0.00,0.00,8860.58,0.00,'2022-03-18 07:36:54','',''),(2631607,'5','183','949',423,'Sale Id shift 257568',0.00,0.00,0.00,975.69,0.00,'2022-03-18 07:36:54','',''),(2631608,'5','183',NULL,423,'Sale Id shift 257568',1622984.55,0.00,0.00,0.00,0.00,'2022-03-18 07:36:54','',''),(2631609,'5','183','949',423,'Sale Id shift 257569',0.00,0.00,0.00,1601.02,0.00,'2022-03-19 07:06:00','',''),(2631610,'5','183','949',423,'Sale Id shift 257569',0.00,0.00,0.00,3163.00,0.00,'2022-03-19 07:06:00','',''),(2631611,'5','183','950',423,'Sale Id shift 257569',0.00,0.00,0.00,6195.83,0.00,'2022-03-19 07:06:00','',''),(2631612,'5','183',NULL,423,'Sale Id shift 257569',1808375.25,0.00,0.00,0.00,0.00,'2022-03-19 07:06:00','',''),(2631613,'5','183','950',423,'Sale Id shift 257570',0.00,0.00,0.00,4688.66,0.00,'2022-03-19 08:23:16','',''),(2631614,'5','183',NULL,423,'Sale Id shift 257570',773628.90,0.00,0.00,0.00,0.00,'2022-03-19 08:23:16','',''),(2631615,'5','183','950',423,'Sale Id shift 257571',0.00,0.00,0.00,6260.10,0.00,'2022-03-20 08:37:41','',''),(2631616,'5','183',NULL,423,'Sale Id shift 257571',1032916.50,0.00,0.00,0.00,0.00,'2022-03-20 08:37:41','',''),(2631617,'5','183','950',423,'Sale Id shift 257572',0.00,0.00,0.00,6151.56,0.00,'2022-03-21 08:41:03','',''),(2631618,'5','183',NULL,423,'Sale Id shift 257572',1015007.40,0.00,0.00,0.00,0.00,'2022-03-21 08:41:03','',''),(2631619,'5','183','950',423,'Sale Id shift 257573',0.00,0.00,0.00,2591.55,0.00,'2022-03-22 08:25:52','',''),(2631620,'5','183',NULL,423,'Sale Id shift 257573',427605.75,0.00,0.00,0.00,0.00,'2022-03-22 08:25:52','',''),(2631621,'5','183','950',423,'Sale Id shift 257574',0.00,0.00,0.00,2069.22,0.00,'2022-03-23 07:53:19','',''),(2631622,'5','183',NULL,423,'Sale Id shift 257574',341421.30,0.00,0.00,0.00,0.00,'2022-03-23 07:53:19','',''),(2631623,'5','183','950',423,'Sale Id shift 257575',0.00,0.00,0.00,1304.79,0.00,'2022-03-24 07:58:32','',''),(2631624,'5','183',NULL,423,'Sale Id shift 257575',215290.35,0.00,0.00,0.00,0.00,'2022-03-24 07:58:32','',''),(2631625,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7400250.00,44850.00,0.00,0.00,'2022-03-24 16:54:51','',''),(2631626,'5','183',NULL,423,'Reception corrector for bridging 131936',0.00,0.00,0.00,21400.00,0.00,'2022-03-25 08:41:07','',''),(2631627,'5','183','949',423,'Received from bridging 131936',0.00,0.00,21400.00,0.00,0.00,'2022-03-25 08:41:07','',''),(2631628,'5','183',NULL,423,'Reception corrector for bridging 131937',0.00,0.00,0.00,23450.00,0.00,'2022-03-25 08:41:19','',''),(2631629,'5','183','950',423,'Received from bridging 131937',0.00,0.00,23450.00,0.00,0.00,'2022-03-25 08:41:19','',''),(2631630,'5','183','949',423,'Sale Id shift 257576',0.00,0.00,0.00,7614.81,0.00,'2022-03-25 09:47:58','',''),(2631631,'5','183',NULL,423,'Sale Id shift 257576',1256443.65,0.00,0.00,0.00,0.00,'2022-03-25 09:47:58','',''),(2631632,'5','183','949',423,'Sale Id shift 257577',0.00,0.00,0.00,6801.28,0.00,'2022-03-27 07:54:49','',''),(2631633,'5','183',NULL,423,'Sale Id shift 257577',1122211.20,0.00,0.00,0.00,0.00,'2022-03-27 07:54:49','',''),(2631634,'5','183','949',423,'Sale Id shift 257578',0.00,0.00,0.00,4645.03,0.00,'2022-03-28 07:56:22','',''),(2631635,'5','183','949',423,'Sale Id shift 257578',0.00,0.00,0.00,473.06,0.00,'2022-03-28 07:56:22','',''),(2631636,'5','183',NULL,423,'Sale Id shift 257578',844484.85,0.00,0.00,0.00,0.00,'2022-03-28 07:56:22','',''),(2631637,'5','183','949',423,'Sale Id shift 257579',0.00,0.00,0.00,116.15,0.00,'2022-03-29 07:52:01','',''),(2631638,'5','183','950',423,'Sale Id shift 257579',0.00,0.00,0.00,6448.16,0.00,'2022-03-29 07:52:01','',''),(2631639,'5','183',NULL,423,'Sale Id shift 257579',1083111.15,0.00,0.00,0.00,0.00,'2022-03-29 07:52:01','',''),(2631640,'5','183','950',423,'Sale Id shift 257580',0.00,0.00,0.00,6553.18,0.00,'2022-03-30 06:36:06','',''),(2631641,'5','183',NULL,423,'Sale Id shift 257580',1081274.70,0.00,0.00,0.00,0.00,'2022-03-30 06:36:06','',''),(2631642,'5','183','949',423,'Sale Id shift 257581',0.00,0.00,0.00,129.85,0.00,'2022-03-30 10:56:30','',''),(2631643,'5','183','950',423,'Sale Id shift 257581',0.00,0.00,0.00,6383.72,0.00,'2022-03-30 10:56:30','',''),(2631644,'5','183',NULL,423,'Sale Id shift 257581',1074739.05,0.00,0.00,0.00,0.00,'2022-03-30 10:56:30','',''),(2631645,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,1969.53,0.00,'2022-03-31 11:08:36','',''),(2631646,'5','183','949',0,'Inventory adjustment from tank dipping to 2600',0.00,0.00,2600.00,0.00,0.00,'2022-03-31 11:08:36','',''),(2631647,'5','183','949',423,'Sale Id shift 257582',0.00,0.00,0.00,1955.46,0.00,'2022-03-31 11:27:19','',''),(2631648,'5','183','949',423,'Sale Id shift 257582',0.00,0.00,0.00,116.73,0.00,'2022-03-31 11:27:19','',''),(2631649,'5','183','950',423,'Sale Id shift 257582',0.00,0.00,0.00,438.35,0.00,'2022-03-31 11:27:19','',''),(2631650,'5','183',NULL,423,'Sale Id shift 257582',414239.10,0.00,0.00,0.00,0.00,'2022-03-31 11:27:19','',''),(2631651,'5','183','950',423,'Sale Id shift 257583',0.00,0.00,0.00,1515.15,0.00,'2022-04-01 10:03:12','',''),(2631652,'5','183',NULL,423,'Sale Id shift 257583',249999.75,0.00,0.00,0.00,0.00,'2022-04-01 10:03:12','',''),(2631653,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7301250.00,44250.00,0.00,0.00,'2022-04-03 10:29:37','',''),(2631654,'5','183',NULL,423,'Reception corrector for bridging 131939',0.00,0.00,0.00,23450.00,0.00,'2022-04-03 15:22:10','',''),(2631655,'5','183','950',423,'Received from bridging 131939',0.00,0.00,23450.00,0.00,0.00,'2022-04-03 15:22:10','',''),(2631656,'5','183',NULL,423,'Reception corrector for bridging 131938',0.00,0.00,0.00,20800.00,0.00,'2022-04-03 15:22:26','',''),(2631657,'5','183','949',423,'Received from bridging 131938',0.00,0.00,20800.00,0.00,0.00,'2022-04-03 15:22:26','',''),(2631658,'5','183','949',423,'Sale Id shift 257585',0.00,0.00,0.00,881.30,0.00,'2022-04-04 07:44:20','',''),(2631659,'5','183','949',423,'Sale Id shift 257585',0.00,0.00,0.00,242.22,0.00,'2022-04-04 07:44:20','',''),(2631660,'5','183',NULL,423,'Sale Id shift 257585',185380.80,0.00,0.00,0.00,0.00,'2022-04-04 07:44:20','',''),(2631661,'5','183','949',423,'Sale Id shift 257586',0.00,0.00,0.00,7526.56,0.00,'2022-04-04 11:30:21','',''),(2631662,'5','183','949',423,'Sale Id shift 257586',0.00,0.00,0.00,523.66,0.00,'2022-04-04 11:30:21','',''),(2631663,'5','183',NULL,423,'Sale Id shift 257586',1328286.30,0.00,0.00,0.00,0.00,'2022-04-04 11:30:21','',''),(2631664,'5','183','949',423,'Sale Id shift 257587',0.00,0.00,0.00,6812.67,0.00,'2022-04-05 09:03:04','',''),(2631665,'5','183',NULL,423,'Sale Id shift 257587',1124090.55,0.00,0.00,0.00,0.00,'2022-04-05 09:03:04','',''),(2631666,'5','183','949',423,'Sale Id shift 257588',0.00,0.00,0.00,4134.54,0.00,'2022-04-06 08:19:45','',''),(2631667,'5','183','950',423,'Sale Id shift 257588',0.00,0.00,0.00,2063.84,0.00,'2022-04-06 08:19:45','',''),(2631668,'5','183',NULL,423,'Sale Id shift 257588',1022732.70,0.00,0.00,0.00,0.00,'2022-04-06 08:19:45','',''),(2631669,'5','183','949',423,'Sale Id shift 257589',0.00,0.00,0.00,321.90,0.00,'2022-04-07 07:47:50','',''),(2631670,'5','183','950',423,'Sale Id shift 257589',0.00,0.00,0.00,5487.16,0.00,'2022-04-07 07:47:50','',''),(2631671,'5','183',NULL,423,'Sale Id shift 257589',958494.90,0.00,0.00,0.00,0.00,'2022-04-07 07:47:50','',''),(2631672,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7458000.00,45200.00,0.00,0.00,'2022-04-07 19:23:48','',''),(2631673,'5','183',NULL,423,'Reception corrector for bridging 131944',0.00,0.00,0.00,30100.00,0.00,'2022-04-08 03:21:07','',''),(2631674,'5','183','949',423,'Received from bridging 131944',0.00,0.00,30100.00,0.00,0.00,'2022-04-08 03:21:07','',''),(2631675,'5','183','949',423,'Sale Id shift 257590',0.00,0.00,0.00,6207.30,0.00,'2022-04-08 07:51:25','',''),(2631676,'5','183','949',423,'Sale Id shift 257590',0.00,0.00,0.00,2167.89,0.00,'2022-04-08 07:51:25','',''),(2631677,'5','183',NULL,423,'Sale Id shift 257590',1381906.35,0.00,0.00,0.00,0.00,'2022-04-08 07:51:25','',''),(2631678,'5','183','949',423,'Sale Id shift 257591',0.00,0.00,0.00,1479.02,0.00,'2022-04-09 09:33:49','',''),(2631679,'5','183','950',423,'Sale Id shift 257591',0.00,0.00,0.00,5364.09,0.00,'2022-04-09 09:33:49','',''),(2631680,'5','183',NULL,423,'Sale Id shift 257591',1129113.15,0.00,0.00,0.00,0.00,'2022-04-09 09:33:49','',''),(2631681,'5','183','949',423,'Sale Id shift 257592',0.00,0.00,0.00,2751.28,0.00,'2022-04-10 08:08:39','',''),(2631682,'5','183','950',423,'Sale Id shift 257592',0.00,0.00,0.00,5216.07,0.00,'2022-04-10 08:08:39','',''),(2631683,'5','183',NULL,423,'Sale Id shift 257592',1314612.75,0.00,0.00,0.00,0.00,'2022-04-10 08:08:39','',''),(2631684,'5','183','949',423,'Sale Id shift 257593',0.00,0.00,0.00,5402.42,0.00,'2022-04-11 03:57:27','',''),(2631685,'5','183','950',423,'Sale Id shift 257593',0.00,0.00,0.00,4109.03,0.00,'2022-04-11 03:57:27','',''),(2631686,'5','183',NULL,423,'Sale Id shift 257593',1569389.25,0.00,0.00,0.00,0.00,'2022-04-11 03:57:27','',''),(2631687,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4884000.00,29600.00,0.00,0.00,'2022-04-11 04:09:58','',''),(2631688,'5','183',NULL,423,'Reception corrector for bridging 131947',0.00,0.00,0.00,14600.00,0.00,'2022-04-11 15:39:28','',''),(2631689,'5','183','950',423,'Received from bridging 131947',0.00,0.00,14600.00,0.00,0.00,'2022-04-11 15:39:28','',''),(2631690,'5','183',NULL,423,'Reception corrector for bridging 131946',0.00,0.00,0.00,15000.00,0.00,'2022-04-11 15:40:18','',''),(2631691,'5','183','949',423,'Received from bridging 131946',0.00,0.00,15000.00,0.00,0.00,'2022-04-11 15:40:18','',''),(2631692,'5','183','949',423,'Sale Id shift 257594',0.00,0.00,0.00,4704.40,0.00,'2022-04-12 12:46:05','',''),(2631693,'5','183','950',423,'Sale Id shift 257594',0.00,0.00,0.00,4265.06,0.00,'2022-04-12 12:46:05','',''),(2631694,'5','183',NULL,423,'Sale Id shift 257594',1479960.90,0.00,0.00,0.00,0.00,'2022-04-12 12:46:05','',''),(2631695,'5','183','949',423,'Sale Id shift 257595',0.00,0.00,0.00,5020.88,0.00,'2022-04-13 07:52:04','',''),(2631696,'5','183','950',423,'Sale Id shift 257595',0.00,0.00,0.00,2583.14,0.00,'2022-04-13 07:52:04','',''),(2631697,'5','183','950',423,'Sale Id shift 257595',0.00,0.00,0.00,2813.14,0.00,'2022-04-13 07:52:04','',''),(2631698,'5','183',NULL,423,'Sale Id shift 257595',1718831.40,0.00,0.00,0.00,0.00,'2022-04-13 07:52:04','',''),(2631699,'5','183','949',423,'Sale Id shift 257596',0.00,0.00,0.00,3279.29,0.00,'2022-04-14 08:42:18','',''),(2631700,'5','183','950',423,'Sale Id shift 257596',0.00,0.00,0.00,5708.20,0.00,'2022-04-14 08:42:18','',''),(2631701,'5','183',NULL,423,'Sale Id shift 257596',1482935.85,0.00,0.00,0.00,0.00,'2022-04-14 08:42:18','',''),(2631702,'5','183','949',423,'Sale Id shift 257597',0.00,0.00,0.00,4471.09,0.00,'2022-04-15 09:01:37','',''),(2631703,'5','183','950',423,'Sale Id shift 257597',0.00,0.00,0.00,4507.02,0.00,'2022-04-15 09:01:37','',''),(2631704,'5','183',NULL,423,'Sale Id shift 257597',1481388.15,0.00,0.00,0.00,0.00,'2022-04-15 09:01:37','',''),(2631705,'5','183','949',423,'Sale Id shift 257598',0.00,0.00,0.00,103.97,0.00,'2022-04-16 09:21:54','',''),(2631706,'5','183','949',423,'Sale Id shift 257598',0.00,0.00,0.00,5522.13,0.00,'2022-04-16 09:21:54','',''),(2631707,'5','183','950',423,'Sale Id shift 257598',0.00,0.00,0.00,84.95,0.00,'2022-04-16 09:21:54','',''),(2631708,'5','183',NULL,423,'Sale Id shift 257598',942323.25,0.00,0.00,0.00,0.00,'2022-04-16 09:21:54','',''),(2631709,'5','183','949',423,'Sale Id shift 257599',0.00,0.00,0.00,4561.72,0.00,'2022-04-17 09:54:00','',''),(2631710,'5','183','950',423,'Sale Id shift 257599',0.00,0.00,0.00,44.56,0.00,'2022-04-17 09:54:00','',''),(2631711,'5','183',NULL,423,'Sale Id shift 257599',760036.20,0.00,0.00,0.00,0.00,'2022-04-17 09:54:00','',''),(2631712,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,313.57,0.00,'2022-04-18 13:30:37','',''),(2631713,'5','183','949',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-04-18 13:30:37','',''),(2631714,'5','183','949',423,'Sale Id shift 257600',0.00,0.00,0.00,1898.47,0.00,'2022-04-18 13:53:58','',''),(2631715,'5','183','950',423,'Sale Id shift 257600',0.00,0.00,0.00,4689.40,0.00,'2022-04-18 13:53:58','',''),(2631716,'5','183',NULL,423,'Sale Id shift 257600',1086998.55,0.00,0.00,0.00,0.00,'2022-04-18 13:53:58','',''),(2631717,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3522750.00,21350.00,0.00,0.00,'2022-04-18 14:32:22','',''),(2631718,'5','183',NULL,423,'Reception corrector for bridging 131948',0.00,0.00,0.00,21350.00,0.00,'2022-04-18 16:55:41','',''),(2631719,'5','183','949',423,'Received from bridging 131948',0.00,0.00,21350.00,0.00,0.00,'2022-04-18 16:55:41','',''),(2631720,'5','183',NULL,423,'Reception corrector for bridging 131941',0.00,0.00,0.00,15100.00,0.00,'2022-04-18 21:50:02','',''),(2631721,'5','183','950',423,'Received from bridging 131941',0.00,0.00,15100.00,0.00,0.00,'2022-04-18 21:50:02','',''),(2631722,'5','183','949',423,'Sale Id shift 257601',0.00,0.00,0.00,2205.45,0.00,'2022-04-19 07:27:04','',''),(2631723,'5','183','950',423,'Sale Id shift 257601',0.00,0.00,0.00,3914.66,0.00,'2022-04-19 07:27:04','',''),(2631724,'5','183',NULL,423,'Sale Id shift 257601',1009818.15,0.00,0.00,0.00,0.00,'2022-04-19 07:27:04','',''),(2631725,'5','183','949',423,'Sale Id shift 257602',0.00,0.00,0.00,6284.81,0.00,'2022-04-20 07:58:55','',''),(2631726,'5','183',NULL,423,'Sale Id shift 257602',1036993.65,0.00,0.00,0.00,0.00,'2022-04-20 07:58:55','',''),(2631727,'5','183','949',423,'Sale Id shift 257603',0.00,0.00,0.00,5431.13,0.00,'2022-04-21 07:41:11','',''),(2631728,'5','183',NULL,423,'Sale Id shift 257603',896136.45,0.00,0.00,0.00,0.00,'2022-04-21 07:41:11','',''),(2631729,'5','183','949',423,'Sale Id shift 257604',0.00,0.00,0.00,4700.21,0.00,'2022-04-22 08:08:11','',''),(2631730,'5','183',NULL,423,'Sale Id shift 257604',775534.65,0.00,0.00,0.00,0.00,'2022-04-22 08:08:11','',''),(2631731,'5','183','949',423,'Sale Id shift 257605',0.00,0.00,0.00,2203.45,0.00,'2022-04-23 08:32:16','',''),(2631732,'5','183',NULL,423,'Sale Id shift 257605',363569.25,0.00,0.00,0.00,0.00,'2022-04-23 08:32:16','',''),(2631733,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-04-23 17:13:09','',''),(2631734,'5','183',NULL,423,'Reception corrector for bridging 131949',0.00,0.00,0.00,16000.00,0.00,'2022-04-23 18:33:33','',''),(2631735,'5','183','949',423,'Received from bridging 131949',0.00,0.00,16000.00,0.00,0.00,'2022-04-23 18:33:33','',''),(2631736,'5','183','949',423,'Sale Id shift 257606',0.00,0.00,0.00,5357.03,0.00,'2022-04-24 03:07:50','',''),(2631737,'5','183',NULL,423,'Sale Id shift 257606',883909.95,0.00,0.00,0.00,0.00,'2022-04-24 03:07:50','',''),(2631738,'5','183','949',423,'Sale Id shift 257607',0.00,0.00,0.00,4444.25,0.00,'2022-04-25 08:44:04','',''),(2631739,'5','183',NULL,423,'Sale Id shift 257607',733301.25,0.00,0.00,0.00,0.00,'2022-04-25 08:44:04','',''),(2631740,'5','183','949',423,'Sale Id shift 257608',0.00,0.00,0.00,5308.24,0.00,'2022-04-26 08:30:53','',''),(2631741,'5','183',NULL,423,'Sale Id shift 257608',875859.60,0.00,0.00,0.00,0.00,'2022-04-26 08:30:53','',''),(2631742,'5','183','949',423,'Sale Id shift 257609',0.00,0.00,0.00,1107.62,0.00,'2022-04-27 08:09:37','',''),(2631743,'5','183','950',423,'Sale Id shift 257609',0.00,0.00,0.00,415.22,0.00,'2022-04-27 08:09:37','',''),(2631744,'5','183',NULL,423,'Sale Id shift 257609',251268.60,0.00,0.00,0.00,0.00,'2022-04-27 08:09:37','',''),(2631745,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-29 16:38:58','',''),(2631746,'5','183',NULL,423,'Reception corrector for bridging 131950',0.00,0.00,0.00,26000.00,0.00,'2022-04-29 17:03:01','',''),(2631747,'5','183','949',423,'Received from bridging 131950',0.00,0.00,26000.00,0.00,0.00,'2022-04-29 17:03:01','',''),(2631748,'5','183',NULL,423,'Reception corrector for bridging 131951',0.00,0.00,0.00,14000.00,0.00,'2022-04-29 17:03:12','',''),(2631749,'5','183','950',423,'Received from bridging 131951',0.00,0.00,14000.00,0.00,0.00,'2022-04-29 17:03:12','',''),(2631750,'5','183','949',423,'Sale Id shift 257612',0.00,0.00,0.00,6127.47,0.00,'2022-05-09 15:26:58','',''),(2631751,'5','183',NULL,423,'Sale Id shift 257612',1011032.55,0.00,0.00,0.00,0.00,'2022-05-09 15:26:58','',''),(2631752,'5','183','949',423,'Sale Id shift 257613',0.00,0.00,0.00,3074.99,0.00,'2022-05-09 15:59:08','',''),(2631753,'5','183','950',423,'Sale Id shift 257613',0.00,0.00,0.00,3254.77,0.00,'2022-05-09 15:59:08','',''),(2631754,'5','183',NULL,423,'Sale Id shift 257613',1044410.40,0.00,0.00,0.00,0.00,'2022-05-09 15:59:08','',''),(2631755,'5','183','949',423,'Sale Id shift 257614',0.00,0.00,0.00,4050.30,0.00,'2022-05-09 19:34:33','',''),(2631756,'5','183','950',423,'Sale Id shift 257614',0.00,0.00,0.00,3804.18,0.00,'2022-05-09 19:34:33','',''),(2631757,'5','183',NULL,423,'Sale Id shift 257614',1295989.20,0.00,0.00,0.00,0.00,'2022-05-09 19:34:33','',''),(2631758,'5','183','949',423,'Sale Id shift 257615',0.00,0.00,0.00,2005.51,0.00,'2022-05-09 19:46:27','',''),(2631759,'5','183','950',423,'Sale Id shift 257615',0.00,0.00,0.00,2517.63,0.00,'2022-05-09 19:46:27','',''),(2631760,'5','183',NULL,423,'Sale Id shift 257615',746318.10,0.00,0.00,0.00,0.00,'2022-05-09 19:46:27','',''),(2631761,'5','183','949',423,'Sale Id shift 257616',0.00,0.00,0.00,4729.46,0.00,'2022-05-09 19:55:49','',''),(2631762,'5','183','950',423,'Sale Id shift 257616',0.00,0.00,0.00,3957.43,0.00,'2022-05-09 19:55:49','',''),(2631763,'5','183',NULL,423,'Sale Id shift 257616',1433336.85,0.00,0.00,0.00,0.00,'2022-05-09 19:55:49','',''),(2631764,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-09 20:00:44','',''),(2631765,'5','183',NULL,423,'Reception corrector for bridging 131952',0.00,0.00,0.00,15000.00,0.00,'2022-05-09 21:04:27','',''),(2631766,'5','183','949',423,'Received from bridging 131952',0.00,0.00,15000.00,0.00,0.00,'2022-05-09 21:04:27','',''),(2631767,'5','183','949',423,'Sale Id shift 257617',0.00,0.00,0.00,2709.14,0.00,'2022-05-09 21:36:16','',''),(2631768,'5','183','950',423,'Sale Id shift 257617',0.00,0.00,0.00,597.39,0.00,'2022-05-09 21:36:16','',''),(2631769,'5','183','950',423,'Sale Id shift 257617',0.00,0.00,0.00,841.88,0.00,'2022-05-09 21:36:16','',''),(2631770,'5','183',NULL,423,'Sale Id shift 257617',684487.65,0.00,0.00,0.00,0.00,'2022-05-09 21:36:16','',''),(2631771,'5','183','949',423,'Sale Id shift 257618',0.00,0.00,0.00,4667.39,0.00,'2022-05-09 21:42:26','',''),(2631772,'5','183','949',423,'Sale Id shift 257618',0.00,0.00,0.00,1790.37,0.00,'2022-05-09 21:42:26','',''),(2631773,'5','183',NULL,423,'Sale Id shift 257618',1065530.40,0.00,0.00,0.00,0.00,'2022-05-09 21:42:26','',''),(2631774,'5','183','949',423,'Sale Id shift 257619',0.00,0.00,0.00,4669.65,0.00,'2022-05-09 21:48:12','',''),(2631775,'5','183',NULL,423,'Sale Id shift 257619',770492.25,0.00,0.00,0.00,0.00,'2022-05-09 21:48:12','',''),(2631776,'5','183','949',423,'Sale Id shift 257620',0.00,0.00,0.00,3998.75,0.00,'2022-05-09 21:56:05','',''),(2631777,'5','183',NULL,423,'Sale Id shift 257620',659793.75,0.00,0.00,0.00,0.00,'2022-05-09 21:56:05','',''),(2631778,'5','183','949',423,'Sale Id shift 257621',0.00,0.00,0.00,1808.27,0.00,'2022-05-09 22:07:06','',''),(2631779,'5','183',NULL,423,'Sale Id shift 257621',298364.55,0.00,0.00,0.00,0.00,'2022-05-09 22:07:06','',''),(2631780,'5','183','949',423,'Sale Id shift 257622',0.00,0.00,0.00,1005.14,0.00,'2022-05-10 06:48:22','',''),(2631781,'5','183',NULL,423,'Sale Id shift 257622',165848.10,0.00,0.00,0.00,0.00,'2022-05-10 06:48:22','',''),(2631782,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2235750.00,13550.00,0.00,0.00,'2022-05-12 21:11:09','',''),(2631783,'5','183',NULL,423,'Reception corrector for bridging 131953',0.00,0.00,0.00,13550.00,0.00,'2022-05-13 07:52:24','',''),(2631784,'5','183','949',423,'Received from bridging 131953',0.00,0.00,13550.00,0.00,0.00,'2022-05-13 07:52:24','',''),(2631785,'5','183','949',423,'Sale Id shift 257625',0.00,0.00,0.00,4476.82,0.00,'2022-05-13 08:15:52','',''),(2631786,'5','183',NULL,423,'Sale Id shift 257625',738675.30,0.00,0.00,0.00,0.00,'2022-05-13 08:15:52','',''),(2631787,'5','183','949',423,'Sale Id shift 257626',0.00,0.00,0.00,3682.33,0.00,'2022-05-14 06:47:06','',''),(2631788,'5','183',NULL,423,'Sale Id shift 257626',607584.45,0.00,0.00,0.00,0.00,'2022-05-14 06:47:06','',''),(2631789,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4785000.00,29000.00,0.00,0.00,'2022-05-14 06:47:25','',''),(2631790,'5','183',NULL,423,'Reception corrector for bridging 131955',0.00,0.00,0.00,29000.00,0.00,'2022-05-14 07:39:42','',''),(2631791,'5','183','949',423,'Received from bridging 131955',0.00,0.00,29000.00,0.00,0.00,'2022-05-14 07:39:42','',''),(2631792,'5','183','949',423,'Sale Id shift 257627',0.00,0.00,0.00,4626.85,0.00,'2022-05-15 06:08:20','',''),(2631793,'5','183',NULL,423,'Sale Id shift 257627',763430.25,0.00,0.00,0.00,0.00,'2022-05-15 06:08:20','',''),(2631794,'5','183','949',423,'Sale Id shift 257628',0.00,0.00,0.00,5355.42,0.00,'2022-05-16 06:10:19','',''),(2631795,'5','183',NULL,423,'Sale Id shift 257628',883644.30,0.00,0.00,0.00,0.00,'2022-05-16 06:10:19','',''),(2631796,'5','183','949',423,'Sale Id shift 257629',0.00,0.00,0.00,5858.16,0.00,'2022-05-17 06:04:36','',''),(2631797,'5','183',NULL,423,'Sale Id shift 257629',966596.40,0.00,0.00,0.00,0.00,'2022-05-17 06:04:36','',''),(2631798,'5','183','949',423,'Sale Id shift 257630',0.00,0.00,0.00,5979.46,0.00,'2022-05-18 05:19:41','',''),(2631799,'5','183',NULL,423,'Sale Id shift 257630',986610.90,0.00,0.00,0.00,0.00,'2022-05-18 05:19:41','',''),(2631800,'5','183','949',423,'Sale Id shift 257631',0.00,0.00,0.00,5651.72,0.00,'2022-05-19 05:34:37','',''),(2631801,'5','183',NULL,423,'Sale Id shift 257631',932533.80,0.00,0.00,0.00,0.00,'2022-05-19 05:34:37','',''),(2631802,'5','183','949',423,'Sale Id shift 257632',0.00,0.00,0.00,5985.85,0.00,'2022-05-20 07:15:15','',''),(2631803,'5','183',NULL,423,'Sale Id shift 257632',987665.25,0.00,0.00,0.00,0.00,'2022-05-20 07:15:15','',''),(2631804,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-21 05:25:39','',''),(2631805,'5','183',NULL,423,'Reception corrector for bridging 131956',0.00,0.00,0.00,15000.00,0.00,'2022-05-21 07:37:17','',''),(2631806,'5','183','949',423,'Received from bridging 131956',0.00,0.00,15000.00,0.00,0.00,'2022-05-21 07:37:17','',''),(2631807,'5','183','949',423,'Sale Id shift 257633',0.00,0.00,0.00,231.11,0.00,'2022-05-21 07:59:07','',''),(2631808,'5','183','949',423,'Sale Id shift 257633',0.00,0.00,0.00,4776.92,0.00,'2022-05-21 07:59:07','',''),(2631809,'5','183',NULL,423,'Sale Id shift 257633',826324.95,0.00,0.00,0.00,0.00,'2022-05-21 07:59:07','',''),(2631810,'5','183','949',423,'Sale Id shift 257634',0.00,0.00,0.00,354.45,0.00,'2022-05-22 08:09:31','',''),(2631811,'5','183','949',423,'Sale Id shift 257634',0.00,0.00,0.00,5350.66,0.00,'2022-05-22 08:09:32','',''),(2631812,'5','183',NULL,423,'Sale Id shift 257634',941343.15,0.00,0.00,0.00,0.00,'2022-05-22 08:09:32','',''),(2631813,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-22 14:39:36','',''),(2631814,'5','183',NULL,423,'Reception corrector for bridging 131957',0.00,0.00,0.00,15000.00,0.00,'2022-05-22 15:37:35','',''),(2631815,'5','183','949',423,'Received from bridging 131957',0.00,0.00,15000.00,0.00,0.00,'2022-05-22 15:37:35','',''),(2631816,'5','183','949',423,'Sale Id shift 257635',0.00,0.00,0.00,1492.64,0.00,'2022-05-23 05:15:22','',''),(2631817,'5','183','949',423,'Sale Id shift 257635',0.00,0.00,0.00,4772.52,0.00,'2022-05-23 05:15:22','',''),(2631818,'5','183',NULL,423,'Sale Id shift 257635',1033751.40,0.00,0.00,0.00,0.00,'2022-05-23 05:15:22','',''),(2631819,'5','183','949',423,'Sale Id shift 257636',0.00,0.00,0.00,2435.11,0.00,'2022-05-24 07:59:02','',''),(2631820,'5','183','949',423,'Sale Id shift 257636',0.00,0.00,0.00,3381.60,0.00,'2022-05-24 07:59:02','',''),(2631821,'5','183',NULL,423,'Sale Id shift 257636',959757.15,0.00,0.00,0.00,0.00,'2022-05-24 07:59:02','',''),(2631822,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4405500.00,26700.00,0.00,0.00,'2022-05-24 08:12:59','',''),(2631823,'5','183',NULL,423,'Reception corrector for bridging 131960',0.00,0.00,0.00,26700.00,0.00,'2022-05-24 10:29:27','',''),(2631824,'5','183','949',423,'Received from bridging 131960',0.00,0.00,26700.00,0.00,0.00,'2022-05-24 10:29:27','',''),(2631825,'5','183','949',423,'Sale Id shift 257637',0.00,0.00,0.00,6093.78,0.00,'2022-05-25 06:07:24','',''),(2631826,'5','183',NULL,423,'Sale Id shift 257637',1005473.70,0.00,0.00,0.00,0.00,'2022-05-25 06:07:24','',''),(2631827,'5','183','949',423,'Sale Id shift 257638',0.00,0.00,0.00,6183.16,0.00,'2022-05-26 07:42:16','',''),(2631828,'5','183',NULL,423,'Sale Id shift 257638',1020221.40,0.00,0.00,0.00,0.00,'2022-05-26 07:42:16','',''),(2631829,'5','183','949',423,'Sale Id shift 257639',0.00,0.00,0.00,5462.49,0.00,'2022-05-28 04:56:54','',''),(2631830,'5','183',NULL,423,'Sale Id shift 257639',901310.85,0.00,0.00,0.00,0.00,'2022-05-28 04:56:54','',''),(2631831,'5','183','949',423,'Sale Id shift 257640',0.00,0.00,0.00,5731.52,0.00,'2022-05-29 08:14:08','',''),(2631832,'5','183',NULL,423,'Sale Id shift 257640',945700.80,0.00,0.00,0.00,0.00,'2022-05-29 08:14:08','',''),(2631833,'5','183','949',423,'Sale Id shift 257641',0.00,0.00,0.00,5028.17,0.00,'2022-05-29 21:36:15','',''),(2631834,'5','183',NULL,423,'Sale Id shift 257641',829648.05,0.00,0.00,0.00,0.00,'2022-05-29 21:36:15','',''),(2631835,'5','183','949',423,'Sale Id shift 257642',0.00,0.00,0.00,4411.90,0.00,'2022-05-30 05:58:31','',''),(2631836,'5','183',NULL,423,'Sale Id shift 257642',727963.50,0.00,0.00,0.00,0.00,'2022-05-30 05:58:31','',''),(2631837,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-05-30 15:44:26','',''),(2631838,'5','183',NULL,423,'Reception corrector for bridging 131961',0.00,0.00,0.00,30000.00,0.00,'2022-05-30 16:46:43','',''),(2631839,'5','183','949',423,'Received from bridging 131961',0.00,0.00,30000.00,0.00,0.00,'2022-05-30 16:46:43','',''),(2631840,'5','183','949',423,'Sale Id shift 257643',0.00,0.00,0.00,5665.57,0.00,'2022-05-31 00:18:53','',''),(2631841,'5','183',NULL,423,'Sale Id shift 257643',934819.05,0.00,0.00,0.00,0.00,'2022-05-31 00:18:53','',''),(2631842,'5','183','949',423,'Sale Id shift 257644',0.00,0.00,0.00,6089.90,0.00,'2022-06-01 07:02:25','',''),(2631843,'5','183',NULL,423,'Sale Id shift 257644',1004833.50,0.00,0.00,0.00,0.00,'2022-06-01 07:02:25','',''),(2631844,'5','183','949',423,'Sale Id shift 257645',0.00,0.00,0.00,5610.16,0.00,'2022-06-02 05:59:52','',''),(2631845,'5','183',NULL,423,'Sale Id shift 257645',925676.40,0.00,0.00,0.00,0.00,'2022-06-02 05:59:52','',''),(2631846,'5','183','949',423,'Sale Id shift 257646',0.00,0.00,0.00,4365.39,0.00,'2022-06-03 06:43:00','',''),(2631847,'5','183',NULL,423,'Sale Id shift 257646',720289.35,0.00,0.00,0.00,0.00,'2022-06-03 06:43:00','',''),(2631848,'5','183','949',423,'Sale Id shift 257647',0.00,0.00,0.00,3897.52,0.00,'2022-06-04 06:04:02','',''),(2631849,'5','183',NULL,423,'Sale Id shift 257647',643090.80,0.00,0.00,0.00,0.00,'2022-06-04 06:04:02','',''),(2631850,'5','183','949',423,'Sale Id shift 257648',0.00,0.00,0.00,3101.37,0.00,'2022-06-05 08:12:01','',''),(2631851,'5','183',NULL,423,'Sale Id shift 257648',511726.05,0.00,0.00,0.00,0.00,'2022-06-05 08:12:01','',''),(2631852,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-05 10:06:56','',''),(2631853,'5','183',NULL,423,'Reception corrector for bridging 131962',0.00,0.00,0.00,15000.00,0.00,'2022-06-05 17:04:59','',''),(2631854,'5','183','949',423,'Received from bridging 131962',0.00,0.00,15000.00,0.00,0.00,'2022-06-05 17:04:59','',''),(2631855,'5','183','949',423,'Sale Id shift 257649',0.00,0.00,0.00,5646.62,0.00,'2022-06-06 06:24:49','',''),(2631856,'5','183',NULL,423,'Sale Id shift 257649',931692.30,0.00,0.00,0.00,0.00,'2022-06-06 06:24:49','',''),(2631857,'5','183','949',423,'Sale Id shift 257650',0.00,0.00,0.00,5259.60,0.00,'2022-06-07 07:24:14','',''),(2631858,'5','183',NULL,423,'Sale Id shift 257650',867834.00,0.00,0.00,0.00,0.00,'2022-06-07 07:24:14','',''),(2631859,'5','183','949',423,'Sale Id shift 257651',0.00,0.00,0.00,3494.25,0.00,'2022-06-08 10:30:08','',''),(2631860,'5','183',NULL,423,'Sale Id shift 257651',576551.25,0.00,0.00,0.00,0.00,'2022-06-08 10:30:08','',''),(2631861,'5','183','949',423,'Sale Id shift 257652',0.00,0.00,0.00,3572.41,0.00,'2022-06-09 08:46:10','',''),(2631862,'5','183',NULL,423,'Sale Id shift 257652',589447.65,0.00,0.00,0.00,0.00,'2022-06-09 08:46:10','',''),(2631863,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6567000.00,39800.00,0.00,0.00,'2022-06-19 15:36:44','',''),(2631864,'5','183',NULL,423,'Reception corrector for bridging 131963',0.00,0.00,0.00,26500.00,0.00,'2022-06-19 18:00:01','',''),(2631865,'5','183','949',423,'Received from bridging 131963',0.00,0.00,26500.00,0.00,0.00,'2022-06-19 18:00:01','',''),(2631866,'5','183',NULL,423,'Reception corrector for bridging 131964',0.00,0.00,0.00,13300.00,0.00,'2022-06-19 18:00:14','',''),(2631867,'5','183','950',423,'Received from bridging 131964',0.00,0.00,13300.00,0.00,0.00,'2022-06-19 18:00:14','',''),(2631868,'5','183','949',423,'Sale Id shift 257663',0.00,0.00,0.00,5917.52,0.00,'2022-06-20 06:44:53','',''),(2631869,'5','183',NULL,423,'Sale Id shift 257663',976390.80,0.00,0.00,0.00,0.00,'2022-06-20 06:44:53','',''),(2631870,'5','183','949',423,'Sale Id shift 257664',0.00,0.00,0.00,5132.76,0.00,'2022-06-21 07:52:54','',''),(2631871,'5','183',NULL,423,'Sale Id shift 257664',846905.40,0.00,0.00,0.00,0.00,'2022-06-21 07:52:54','',''),(2631872,'5','183','949',423,'Sale Id shift 257665',0.00,0.00,0.00,4054.03,0.00,'2022-06-22 07:03:29','',''),(2631873,'5','183',NULL,423,'Sale Id shift 257665',668914.95,0.00,0.00,0.00,0.00,'2022-06-22 07:03:29','',''),(2631874,'5','183','949',423,'Sale Id shift 257666',0.00,0.00,0.00,3422.68,0.00,'2022-06-23 07:03:59','',''),(2631875,'5','183',NULL,423,'Sale Id shift 257666',564742.20,0.00,0.00,0.00,0.00,'2022-06-23 07:03:59','',''),(2631876,'5','183','949',423,'Sale Id shift 257667',0.00,0.00,0.00,5084.92,0.00,'2022-06-24 06:56:45','',''),(2631877,'5','183',NULL,423,'Sale Id shift 257667',839011.80,0.00,0.00,0.00,0.00,'2022-06-24 06:56:45','',''),(2631878,'5','183','949',423,'Sale Id shift 257668',0.00,0.00,0.00,931.90,0.00,'2022-06-25 06:12:06','',''),(2631879,'5','183','949',423,'Sale Id shift 257668',0.00,0.00,0.00,2019.89,0.00,'2022-06-25 06:12:06','',''),(2631880,'5','183',NULL,423,'Sale Id shift 257668',487045.35,0.00,0.00,0.00,0.00,'2022-06-25 06:12:06','',''),(2631881,'5','183','950',423,'Sale Id shift 257669',0.00,0.00,0.00,4334.01,0.00,'2022-06-26 07:13:14','',''),(2631882,'5','183',NULL,423,'Sale Id shift 257669',715111.65,0.00,0.00,0.00,0.00,'2022-06-26 07:13:14','',''),(2631883,'5','183','950',423,'Sale Id shift 257670',0.00,0.00,0.00,3193.52,0.00,'2022-06-27 07:33:28','',''),(2631884,'5','183',NULL,423,'Sale Id shift 257670',526930.80,0.00,0.00,0.00,0.00,'2022-06-27 07:33:28','',''),(2631885,'5','183','950',423,'Sale Id shift 257671',0.00,0.00,0.00,3724.20,0.00,'2022-06-28 07:20:53','',''),(2631886,'5','183',NULL,423,'Sale Id shift 257671',614493.00,0.00,0.00,0.00,0.00,'2022-06-28 07:20:53','',''),(2631887,'5','183','950',423,'Sale Id shift 257672',0.00,0.00,0.00,1673.66,0.00,'2022-06-29 08:00:01','',''),(2631888,'5','183',NULL,423,'Sale Id shift 257672',276153.90,0.00,0.00,0.00,0.00,'2022-06-29 08:00:01','',''),(2631889,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4372500.00,26500.00,0.00,0.00,'2022-07-06 11:01:05','',''),(2631890,'5','183',NULL,423,'Reception corrector for bridging 131965',0.00,0.00,0.00,26500.00,0.00,'2022-07-06 14:17:55','',''),(2631891,'5','183','949',423,'Received from bridging 131965',0.00,0.00,26500.00,0.00,0.00,'2022-07-06 14:17:55','',''),(2631892,'5','183','949',423,'Sale Id shift 257680',0.00,0.00,0.00,347.15,0.00,'2022-07-07 05:23:18','',''),(2631893,'5','183','949',423,'Sale Id shift 257680',0.00,0.00,0.00,3935.85,0.00,'2022-07-07 05:23:18','',''),(2631894,'5','183',NULL,423,'Sale Id shift 257680',706695.00,0.00,0.00,0.00,0.00,'2022-07-07 05:23:18','',''),(2631895,'5','183','949',423,'Sale Id shift 257681',0.00,0.00,0.00,2924.54,0.00,'2022-07-08 06:09:35','',''),(2631896,'5','183',NULL,423,'Sale Id shift 257681',482549.10,0.00,0.00,0.00,0.00,'2022-07-08 06:09:35','',''),(2631897,'5','183','949',423,'Sale Id shift 257682',0.00,0.00,0.00,3890.61,0.00,'2022-07-09 06:36:16','',''),(2631898,'5','183',NULL,423,'Sale Id shift 257682',641950.65,0.00,0.00,0.00,0.00,'2022-07-09 06:36:16','',''),(2631899,'5','183','949',423,'Sale Id shift 257683',0.00,0.00,0.00,176.01,0.00,'2022-07-10 07:02:10','',''),(2631900,'5','183','949',423,'Sale Id shift 257683',0.00,0.00,0.00,3587.37,0.00,'2022-07-10 07:02:10','',''),(2631901,'5','183',NULL,423,'Sale Id shift 257683',620957.70,0.00,0.00,0.00,0.00,'2022-07-10 07:02:10','',''),(2631902,'5','183','949',423,'Sale Id shift 257684',0.00,0.00,0.00,1976.08,0.00,'2022-07-11 06:59:22','',''),(2631903,'5','183',NULL,423,'Sale Id shift 257684',326053.20,0.00,0.00,0.00,0.00,'2022-07-11 06:59:22','',''),(2631904,'5','183','949',423,'Sale Id shift 257685',0.00,0.00,0.00,2981.91,0.00,'2022-07-12 08:21:54','',''),(2631905,'5','183',NULL,423,'Sale Id shift 257685',551653.35,0.00,0.00,0.00,0.00,'2022-07-12 08:21:54','',''),(2631906,'5','183','949',423,'Sale Id shift 257686',0.00,0.00,0.00,3249.72,0.00,'2022-07-13 07:16:25','',''),(2631907,'5','183',NULL,423,'Sale Id shift 257686',601198.20,0.00,0.00,0.00,0.00,'2022-07-13 07:16:25','',''),(2631908,'5','183','949',423,'Sale Id shift 257687',0.00,0.00,0.00,1375.62,0.00,'2022-07-14 06:30:03','',''),(2631909,'5','183',NULL,423,'Sale Id shift 257687',254489.70,0.00,0.00,0.00,0.00,'2022-07-14 06:30:03','',''),(2631910,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7298250.00,39450.00,0.00,0.00,'2022-07-14 07:47:35','',''),(2631911,'5','183',NULL,423,'Reception corrector for bridging 131966',0.00,0.00,0.00,27000.00,0.00,'2022-07-15 06:59:25','',''),(2631912,'5','183','949',423,'Received from bridging 131966',0.00,0.00,27000.00,0.00,0.00,'2022-07-15 06:59:25','',''),(2631913,'5','183',NULL,423,'Reception corrector for bridging 131967',0.00,0.00,0.00,12450.00,0.00,'2022-07-15 06:59:36','',''),(2631914,'5','183','950',423,'Received from bridging 131967',0.00,0.00,12450.00,0.00,0.00,'2022-07-15 06:59:36','',''),(2631915,'5','183','949',423,'Sale Id shift 257688',0.00,0.00,0.00,4693.86,0.00,'2022-07-15 07:42:51','',''),(2631916,'5','183',NULL,423,'Sale Id shift 257688',868364.10,0.00,0.00,0.00,0.00,'2022-07-15 07:42:51','',''),(2631917,'5','183','949',423,'Sale Id shift 257689',0.00,0.00,0.00,5308.34,0.00,'2022-07-16 06:51:25','',''),(2631918,'5','183',NULL,423,'Sale Id shift 257689',982042.90,0.00,0.00,0.00,0.00,'2022-07-16 06:51:25','',''),(2631919,'5','183','949',423,'Sale Id shift 257690',0.00,0.00,0.00,4286.49,0.00,'2022-07-17 08:16:28','',''),(2631920,'5','183',NULL,423,'Sale Id shift 257690',793000.65,0.00,0.00,0.00,0.00,'2022-07-17 08:16:28','',''),(2631921,'5','183','949',423,'Sale Id shift 257691',0.00,0.00,0.00,5099.34,0.00,'2022-07-18 07:31:44','',''),(2631922,'5','183',NULL,423,'Sale Id shift 257691',943377.90,0.00,0.00,0.00,0.00,'2022-07-18 07:31:44','',''),(2631923,'5','183','949',423,'Sale Id shift 257692',0.00,0.00,0.00,4556.43,0.00,'2022-07-19 05:02:02','',''),(2631924,'5','183',NULL,423,'Sale Id shift 257692',842939.55,0.00,0.00,0.00,0.00,'2022-07-19 05:02:02','',''),(2631925,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,6179000.00,33400.00,0.00,0.00,'2022-07-20 07:47:15','',''),(2631926,'5','183',NULL,423,'Reception corrector for bridging 131968',0.00,0.00,0.00,16400.00,0.00,'2022-07-20 08:35:41','',''),(2631927,'5','183','949',423,'Received from bridging 131968',0.00,0.00,16400.00,0.00,0.00,'2022-07-20 08:35:41','',''),(2631928,'5','183','949',423,'Sale Id shift 257693',0.00,0.00,0.00,4129.62,0.00,'2022-07-20 10:13:20','',''),(2631929,'5','183','949',423,'Sale Id shift 257693',0.00,0.00,0.00,5057.12,0.00,'2022-07-20 10:13:20','',''),(2631930,'5','183',NULL,423,'Sale Id shift 257693',1699546.90,0.00,0.00,0.00,0.00,'2022-07-20 10:13:20','',''),(2631931,'5','183','949',423,'Sale Id shift 257694',0.00,0.00,0.00,3758.84,0.00,'2022-07-21 06:46:53','',''),(2631932,'5','183','949',423,'Sale Id shift 257694',0.00,0.00,0.00,5067.18,0.00,'2022-07-21 06:46:53','',''),(2631933,'5','183',NULL,423,'Sale Id shift 257694',1632813.70,0.00,0.00,0.00,0.00,'2022-07-21 06:46:53','',''),(2631934,'5','183','949',423,'Sale Id shift 257695',0.00,0.00,0.00,3955.15,0.00,'2022-07-22 07:12:36','',''),(2631935,'5','183',NULL,423,'Sale Id shift 257695',731702.75,0.00,0.00,0.00,0.00,'2022-07-22 07:12:36','',''),(2631936,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-22 15:14:18','',''),(2631937,'5','183',NULL,423,'Reception corrector for bridging 131970',0.00,0.00,0.00,30000.00,0.00,'2022-07-22 20:56:12','',''),(2631938,'5','183','949',423,'Received from bridging 131970',0.00,0.00,30000.00,0.00,0.00,'2022-07-22 20:56:12','',''),(2631939,'5','183','949',423,'Sale Id shift 257696',0.00,0.00,0.00,7068.92,0.00,'2022-07-23 06:52:37','',''),(2631940,'5','183','949',423,'Sale Id shift 257696',0.00,0.00,0.00,3585.01,0.00,'2022-07-23 06:52:37','',''),(2631941,'5','183','950',423,'Sale Id shift 257696',0.00,0.00,0.00,151.47,0.00,'2022-07-23 06:52:37','',''),(2631942,'5','183',NULL,423,'Sale Id shift 257696',1998999.00,0.00,0.00,0.00,0.00,'2022-07-23 06:52:37','',''),(2631943,'5','183','949',423,'Sale Id shift 257697',0.00,0.00,0.00,5537.03,0.00,'2022-07-24 08:30:19','',''),(2631944,'5','183','949',423,'Sale Id shift 257697',0.00,0.00,0.00,6441.45,0.00,'2022-07-24 08:30:19','',''),(2631945,'5','183',NULL,423,'Sale Id shift 257697',2216018.80,0.00,0.00,0.00,0.00,'2022-07-24 08:30:19','',''),(2631946,'5','183','949',423,'Sale Id shift 257698',0.00,0.00,0.00,278.87,0.00,'2022-07-25 06:42:33','',''),(2631947,'5','183','950',423,'Sale Id shift 257698',0.00,0.00,0.00,3972.65,0.00,'2022-07-25 06:42:33','',''),(2631948,'5','183','950',423,'Sale Id shift 257698',0.00,0.00,0.00,3863.03,0.00,'2022-07-25 06:42:33','',''),(2631949,'5','183',NULL,423,'Sale Id shift 257698',1501191.75,0.00,0.00,0.00,0.00,'2022-07-25 06:42:33','',''),(2631950,'5','183','950',423,'Sale Id shift 257699',0.00,0.00,0.00,3812.67,0.00,'2022-07-26 05:51:45','',''),(2631951,'5','183','950',423,'Sale Id shift 257699',0.00,0.00,0.00,3930.10,0.00,'2022-07-26 05:51:45','',''),(2631952,'5','183',NULL,423,'Sale Id shift 257699',1432412.45,0.00,0.00,0.00,0.00,'2022-07-26 05:51:45','',''),(2631953,'5','183','949',423,'Sale Id shift 257700',0.00,0.00,0.00,4367.82,0.00,'2022-07-27 07:31:24','',''),(2631954,'5','183',NULL,423,'Sale Id shift 257700',808046.70,0.00,0.00,0.00,0.00,'2022-07-27 07:31:24','',''),(2631955,'5','183','950',423,'Sale Id shift 257701',0.00,0.00,0.00,5001.92,0.00,'2022-07-28 06:51:40','',''),(2631956,'5','183',NULL,423,'Sale Id shift 257701',925355.20,0.00,0.00,0.00,0.00,'2022-07-28 06:51:40','',''),(2631957,'5','183','950',0,'Tank level zero out for dipping',0.00,0.00,0.00,4529.30,0.00,'2022-07-29 09:20:57','',''),(2631958,'5','183','950',0,'Inventory adjustment from tank dipping to 11200',0.00,0.00,11200.00,0.00,0.00,'2022-07-29 09:20:57','',''),(2631959,'5','183','949',423,'Sale Id shift 257702',0.00,0.00,0.00,1201.85,0.00,'2022-07-29 12:47:53','',''),(2631960,'5','183','950',423,'Sale Id shift 257702',0.00,0.00,0.00,4551.43,0.00,'2022-07-29 12:47:53','',''),(2631961,'5','183',NULL,423,'Sale Id shift 257702',1064356.80,0.00,0.00,0.00,0.00,'2022-07-29 12:47:53','',''),(2631962,'5','183','950',423,'Sale Id shift 257703',0.00,0.00,0.00,2967.86,0.00,'2022-07-30 09:11:51','',''),(2631963,'5','183',NULL,423,'Sale Id shift 257703',549054.10,0.00,0.00,0.00,0.00,'2022-07-30 09:11:51','',''),(2631964,'5','183','949',423,'Sale Id shift 257704',0.00,0.00,0.00,1031.87,0.00,'2022-07-31 09:27:02','',''),(2631965,'5','183','950',423,'Sale Id shift 257704',0.00,0.00,0.00,1345.66,0.00,'2022-07-31 09:27:02','',''),(2631966,'5','183',NULL,423,'Sale Id shift 257704',439843.05,0.00,0.00,0.00,0.00,'2022-07-31 09:27:02','',''),(2631967,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-08-02 18:03:03','',''),(2631968,'5','183',NULL,423,'Reception corrector for bridging 131971',0.00,0.00,0.00,26500.00,0.00,'2022-08-02 21:49:35','',''),(2631969,'5','183','949',423,'Received from bridging 131971',0.00,0.00,26500.00,0.00,0.00,'2022-08-02 21:49:35','',''),(2631970,'5','183',NULL,423,'Reception corrector for bridging 131972',0.00,0.00,0.00,13500.00,0.00,'2022-08-02 21:49:47','',''),(2631971,'5','183','950',423,'Received from bridging 131972',0.00,0.00,13500.00,0.00,0.00,'2022-08-02 21:49:47','',''),(2631972,'5','183','949',423,'Sale Id shift 257707',0.00,0.00,0.00,2794.78,0.00,'2022-08-03 06:55:43','',''),(2631973,'5','183','949',423,'Sale Id shift 257707',0.00,0.00,0.00,3976.69,0.00,'2022-08-03 06:55:43','',''),(2631974,'5','183',NULL,423,'Sale Id shift 257707',1252721.95,0.00,0.00,0.00,0.00,'2022-08-03 06:55:43','',''),(2631975,'5','183','949',423,'Sale Id shift 257708',0.00,0.00,0.00,1649.66,0.00,'2022-08-04 07:24:25','',''),(2631976,'5','183','949',423,'Sale Id shift 257708',0.00,0.00,0.00,5329.26,0.00,'2022-08-04 07:24:25','',''),(2631977,'5','183',NULL,423,'Sale Id shift 257708',1291100.20,0.00,0.00,0.00,0.00,'2022-08-04 07:24:25','',''),(2631978,'5','183','949',423,'Sale Id shift 257709',0.00,0.00,0.00,151.24,0.00,'2022-08-05 06:32:37','',''),(2631979,'5','183','949',423,'Sale Id shift 257709',0.00,0.00,0.00,3479.30,0.00,'2022-08-05 06:32:37','',''),(2631980,'5','183',NULL,423,'Sale Id shift 257709',671649.90,0.00,0.00,0.00,0.00,'2022-08-05 06:32:37','',''),(2631981,'5','183','949',423,'Sale Id shift 257710',0.00,0.00,0.00,1950.41,0.00,'2022-08-06 07:00:09','',''),(2631982,'5','183','949',423,'Sale Id shift 257710',0.00,0.00,0.00,2621.96,0.00,'2022-08-06 07:00:09','',''),(2631983,'5','183',NULL,423,'Sale Id shift 257710',845888.45,0.00,0.00,0.00,0.00,'2022-08-06 07:00:09','',''),(2631984,'5','183','949',423,'Sale Id shift 257711',0.00,0.00,0.00,2729.56,0.00,'2022-08-07 07:23:14','',''),(2631985,'5','183','950',423,'Sale Id shift 257711',0.00,0.00,0.00,2606.32,0.00,'2022-08-07 07:23:14','',''),(2631986,'5','183',NULL,423,'Sale Id shift 257711',987137.80,0.00,0.00,0.00,0.00,'2022-08-07 07:23:14','',''),(2631987,'5','183','949',423,'Sale Id shift 257712',0.00,0.00,0.00,1096.62,0.00,'2022-09-05 06:46:25','',''),(2631988,'5','183','950',423,'Sale Id shift 257712',0.00,0.00,0.00,487.89,0.00,'2022-09-05 06:46:25','',''),(2631989,'5','183','950',423,'Sale Id shift 257712',0.00,0.00,0.00,1738.45,0.00,'2022-09-05 06:46:25','',''),(2631990,'5','183',NULL,423,'Sale Id shift 257712',614747.60,0.00,0.00,0.00,0.00,'2022-09-05 06:46:25','',''),(2631991,'5','183','950',423,'Sale Id shift 257713',0.00,0.00,0.00,1809.95,0.00,'2022-09-05 14:43:55','',''),(2631992,'5','183','950',423,'Sale Id shift 257713',0.00,0.00,0.00,1942.51,0.00,'2022-09-05 14:43:55','',''),(2631993,'5','183',NULL,423,'Sale Id shift 257713',694205.10,0.00,0.00,0.00,0.00,'2022-09-05 14:43:55','',''),(2631994,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8297250.00,44850.00,0.00,0.00,'2022-09-05 14:44:20','',''),(2631995,'5','183',NULL,423,'Reception corrector for bridging 131974',0.00,0.00,0.00,14850.00,0.00,'2022-09-05 15:36:49','',''),(2631996,'5','183','950',423,'Received from bridging 131974',0.00,0.00,14850.00,0.00,0.00,'2022-09-05 15:36:49','',''),(2631997,'5','183',NULL,423,'Reception corrector for bridging 131973',0.00,0.00,0.00,30000.00,0.00,'2022-09-05 15:36:56','',''),(2631998,'5','183','949',423,'Received from bridging 131973',0.00,0.00,30000.00,0.00,0.00,'2022-09-05 15:36:56','',''),(2631999,'5','183','949',423,'Sale Id shift 257714',0.00,0.00,0.00,3087.41,0.00,'2022-09-05 16:03:44','',''),(2632000,'5','183','950',423,'Sale Id shift 257714',0.00,0.00,0.00,2836.29,0.00,'2022-09-05 16:03:44','',''),(2632001,'5','183',NULL,423,'Sale Id shift 257714',1095884.50,0.00,0.00,0.00,0.00,'2022-09-05 16:03:44','',''),(2632002,'5','183','949',423,'Sale Id shift 257715',0.00,0.00,0.00,2560.67,0.00,'2022-09-05 18:01:53','',''),(2632003,'5','183','950',423,'Sale Id shift 257715',0.00,0.00,0.00,2709.35,0.00,'2022-09-05 18:01:53','',''),(2632004,'5','183',NULL,423,'Sale Id shift 257715',974953.70,0.00,0.00,0.00,0.00,'2022-09-05 18:01:53','',''),(2632005,'5','183','949',423,'Sale Id shift 257716',0.00,0.00,0.00,2701.04,0.00,'2022-09-06 11:12:10','',''),(2632006,'5','183','949',423,'Sale Id shift 257716',0.00,0.00,0.00,2645.14,0.00,'2022-09-06 11:12:10','',''),(2632007,'5','183',NULL,423,'Sale Id shift 257716',989043.30,0.00,0.00,0.00,0.00,'2022-09-06 11:12:10','',''),(2632008,'5','183','949',423,'Sale Id shift 257717',0.00,0.00,0.00,2246.57,0.00,'2022-09-06 11:24:20','',''),(2632009,'5','183','949',423,'Sale Id shift 257717',0.00,0.00,0.00,2322.38,0.00,'2022-09-06 11:24:20','',''),(2632010,'5','183',NULL,423,'Sale Id shift 257717',845255.75,0.00,0.00,0.00,0.00,'2022-09-06 11:24:20','',''),(2632011,'5','183','949',423,'Sale Id shift 257718',0.00,0.00,0.00,2808.78,0.00,'2022-09-06 11:53:24','',''),(2632012,'5','183','949',423,'Sale Id shift 257718',0.00,0.00,0.00,2858.25,0.00,'2022-09-06 11:53:24','',''),(2632013,'5','183',NULL,423,'Sale Id shift 257718',1048400.55,0.00,0.00,0.00,0.00,'2022-09-06 11:53:24','',''),(2632014,'5','183','949',423,'Sale Id shift 257719',0.00,0.00,0.00,2504.12,0.00,'2022-09-06 12:12:02','',''),(2632015,'5','183','950',423,'Sale Id shift 257719',0.00,0.00,0.00,2241.84,0.00,'2022-09-06 12:12:02','',''),(2632016,'5','183',NULL,423,'Sale Id shift 257719',878002.60,0.00,0.00,0.00,0.00,'2022-09-06 12:12:02','',''),(2632017,'5','183','949',423,'Sale Id shift 257720',0.00,0.00,0.00,1186.74,0.00,'2022-09-06 12:30:36','',''),(2632018,'5','183','950',423,'Sale Id shift 257720',0.00,0.00,0.00,1548.40,0.00,'2022-09-06 12:30:36','',''),(2632019,'5','183',NULL,423,'Sale Id shift 257720',506000.90,0.00,0.00,0.00,0.00,'2022-09-06 12:30:36','',''),(2632020,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7363000.00,39800.00,0.00,0.00,'2022-09-06 12:39:00','',''),(2632021,'5','183',NULL,423,'Reception corrector for bridging 131976',0.00,0.00,0.00,13300.00,0.00,'2022-09-06 13:04:42','',''),(2632022,'5','183','950',423,'Received from bridging 131976',0.00,0.00,13300.00,0.00,0.00,'2022-09-06 13:04:42','',''),(2632023,'5','183',NULL,423,'Reception corrector for bridging 131975',0.00,0.00,0.00,26500.00,0.00,'2022-09-06 13:04:49','',''),(2632024,'5','183','949',423,'Received from bridging 131975',0.00,0.00,26500.00,0.00,0.00,'2022-09-06 13:04:49','',''),(2632025,'5','183','949',423,'Sale Id shift 257721',0.00,0.00,0.00,1383.94,0.00,'2022-09-06 13:08:35','',''),(2632026,'5','183','950',423,'Sale Id shift 257721',0.00,0.00,0.00,1632.91,0.00,'2022-09-06 13:08:35','',''),(2632027,'5','183',NULL,423,'Sale Id shift 257721',558117.25,0.00,0.00,0.00,0.00,'2022-09-06 13:08:35','',''),(2632028,'5','183','949',423,'Sale Id shift 257722',0.00,0.00,0.00,2235.78,0.00,'2022-09-06 13:40:02','',''),(2632029,'5','183','950',423,'Sale Id shift 257722',0.00,0.00,0.00,2351.16,0.00,'2022-09-06 13:40:02','',''),(2632030,'5','183',NULL,423,'Sale Id shift 257722',848583.90,0.00,0.00,0.00,0.00,'2022-09-06 13:40:02','',''),(2632031,'5','183','949',423,'Sale Id shift 257723',0.00,0.00,0.00,1931.38,0.00,'2022-09-06 13:50:00','',''),(2632032,'5','183','950',423,'Sale Id shift 257723',0.00,0.00,0.00,2629.92,0.00,'2022-09-06 13:50:00','',''),(2632033,'5','183',NULL,423,'Sale Id shift 257723',843840.50,0.00,0.00,0.00,0.00,'2022-09-06 13:50:00','',''),(2632034,'5','183','949',423,'Sale Id shift 257724',0.00,0.00,0.00,988.35,0.00,'2022-09-06 14:17:17','',''),(2632035,'5','183','950',423,'Sale Id shift 257724',0.00,0.00,0.00,1607.49,0.00,'2022-09-06 14:17:17','',''),(2632036,'5','183',NULL,423,'Sale Id shift 257724',480230.40,0.00,0.00,0.00,0.00,'2022-09-06 14:17:17','',''),(2632037,'5','183','949',423,'Sale Id shift 257725',0.00,0.00,0.00,2153.97,0.00,'2022-09-06 14:34:58','',''),(2632038,'5','183','950',423,'Sale Id shift 257725',0.00,0.00,0.00,2407.51,0.00,'2022-09-06 14:34:58','',''),(2632039,'5','183',NULL,423,'Sale Id shift 257725',843873.80,0.00,0.00,0.00,0.00,'2022-09-06 14:34:58','',''),(2632040,'5','183','949',423,'Sale Id shift 257726',0.00,0.00,0.00,441.19,0.00,'2022-09-06 14:45:46','',''),(2632041,'5','183','949',423,'Sale Id shift 257726',0.00,0.00,0.00,2682.56,0.00,'2022-09-06 14:45:46','',''),(2632042,'5','183','950',423,'Sale Id shift 257726',0.00,0.00,0.00,2830.08,0.00,'2022-09-06 14:45:46','',''),(2632043,'5','183',NULL,423,'Sale Id shift 257726',1101458.55,0.00,0.00,0.00,0.00,'2022-09-06 14:45:46','',''),(2632044,'5','183','949',423,'Sale Id shift 257727',0.00,0.00,0.00,2197.48,0.00,'2022-09-06 14:52:53','',''),(2632045,'5','183','950',423,'Sale Id shift 257727',0.00,0.00,0.00,2626.76,0.00,'2022-09-06 14:52:53','',''),(2632046,'5','183',NULL,423,'Sale Id shift 257727',892484.40,0.00,0.00,0.00,0.00,'2022-09-06 14:52:53','',''),(2632047,'5','183','949',423,'Sale Id shift 257728',0.00,0.00,0.00,2631.92,0.00,'2022-09-06 15:22:30','',''),(2632048,'5','183','949',423,'Sale Id shift 257728',0.00,0.00,0.00,2153.00,0.00,'2022-09-06 15:22:30','',''),(2632049,'5','183',NULL,423,'Sale Id shift 257728',885210.20,0.00,0.00,0.00,0.00,'2022-09-06 15:22:30','',''),(2632050,'5','183','949',423,'Sale Id shift 257729',0.00,0.00,0.00,2215.94,0.00,'2022-09-06 15:40:20','',''),(2632051,'5','183','949',423,'Sale Id shift 257729',0.00,0.00,0.00,1955.62,0.00,'2022-09-06 15:40:20','',''),(2632052,'5','183',NULL,423,'Sale Id shift 257729',771738.60,0.00,0.00,0.00,0.00,'2022-09-06 15:40:20','',''),(2632053,'5','183','949',423,'Sale Id shift 257730',0.00,0.00,0.00,2256.88,0.00,'2022-09-06 16:04:25','',''),(2632054,'5','183','949',423,'Sale Id shift 257730',0.00,0.00,0.00,1077.30,0.00,'2022-09-06 16:04:25','',''),(2632055,'5','183',NULL,423,'Sale Id shift 257730',616823.30,0.00,0.00,0.00,0.00,'2022-09-06 16:04:25','',''),(2632056,'5','183','949',423,'Sale Id shift 257731',0.00,0.00,0.00,2193.83,0.00,'2022-09-06 16:29:21','',''),(2632057,'5','183','949',423,'Sale Id shift 257731',0.00,0.00,0.00,1908.26,0.00,'2022-09-06 16:29:21','',''),(2632058,'5','183',NULL,423,'Sale Id shift 257731',758886.65,0.00,0.00,0.00,0.00,'2022-09-06 16:29:21','',''),(2632059,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,9200050.00,49730.00,0.00,0.00,'2022-09-06 16:29:52','',''),(2632060,'5','183',NULL,423,'Reception corrector for bridging 131978',0.00,0.00,0.00,16730.00,0.00,'2022-09-06 16:42:03','',''),(2632061,'5','183','950',423,'Received from bridging 131978',0.00,0.00,16730.00,0.00,0.00,'2022-09-06 16:42:03','',''),(2632062,'5','183',NULL,423,'Reception corrector for bridging 131977',0.00,0.00,0.00,33000.00,0.00,'2022-09-06 16:42:11','',''),(2632063,'5','183','949',423,'Received from bridging 131977',0.00,0.00,33000.00,0.00,0.00,'2022-09-06 16:42:11','',''),(2632064,'5','183','949',423,'Sale Id shift 257732',0.00,0.00,0.00,1807.59,0.00,'2022-09-07 08:20:35','',''),(2632065,'5','183','949',423,'Sale Id shift 257732',0.00,0.00,0.00,1871.45,0.00,'2022-09-07 08:20:35','',''),(2632066,'5','183',NULL,423,'Sale Id shift 257732',680622.40,0.00,0.00,0.00,0.00,'2022-09-07 08:20:35','',''),(2632067,'5','183','949',423,'Sale Id shift 257733',0.00,0.00,0.00,1560.21,0.00,'2022-09-07 09:11:59','',''),(2632068,'5','183','949',423,'Sale Id shift 257733',0.00,0.00,0.00,1596.02,0.00,'2022-09-07 09:11:59','',''),(2632069,'5','183',NULL,423,'Sale Id shift 257733',583902.55,0.00,0.00,0.00,0.00,'2022-09-07 09:11:59','',''),(2632070,'5','183','949',423,'Sale Id shift 257734',0.00,0.00,0.00,1316.94,0.00,'2022-09-07 09:26:11','',''),(2632071,'5','183','950',423,'Sale Id shift 257734',0.00,0.00,0.00,1591.54,0.00,'2022-09-07 09:26:11','',''),(2632072,'5','183',NULL,423,'Sale Id shift 257734',538068.80,0.00,0.00,0.00,0.00,'2022-09-07 09:26:11','',''),(2632073,'5','183','949',423,'Sale Id shift 257735',0.00,0.00,0.00,2110.84,0.00,'2022-09-07 09:45:22','',''),(2632074,'5','183','950',423,'Sale Id shift 257735',0.00,0.00,0.00,2016.51,0.00,'2022-09-07 09:45:22','',''),(2632075,'5','183',NULL,423,'Sale Id shift 257735',763559.75,0.00,0.00,0.00,0.00,'2022-09-07 09:45:22','',''),(2632076,'5','183','949',423,'Sale Id shift 257736',0.00,0.00,0.00,1474.03,0.00,'2022-09-07 09:54:26','',''),(2632077,'5','183','950',423,'Sale Id shift 257736',0.00,0.00,0.00,2008.41,0.00,'2022-09-07 09:54:26','',''),(2632078,'5','183',NULL,423,'Sale Id shift 257736',644251.40,0.00,0.00,0.00,0.00,'2022-09-07 09:54:26','',''),(2632079,'5','183','949',423,'Sale Id shift 257737',0.00,0.00,0.00,2142.00,0.00,'2022-09-07 10:08:02','',''),(2632080,'5','183','950',423,'Sale Id shift 257737',0.00,0.00,0.00,2069.38,0.00,'2022-09-07 10:08:02','',''),(2632081,'5','183',NULL,423,'Sale Id shift 257737',779105.30,0.00,0.00,0.00,0.00,'2022-09-07 10:08:02','',''),(2632082,'5','183','949',423,'Sale Id shift 257738',0.00,0.00,0.00,1433.74,0.00,'2022-09-07 10:18:14','',''),(2632083,'5','183','950',423,'Sale Id shift 257738',0.00,0.00,0.00,1554.51,0.00,'2022-09-07 10:18:14','',''),(2632084,'5','183',NULL,423,'Sale Id shift 257738',552826.25,0.00,0.00,0.00,0.00,'2022-09-07 10:18:14','',''),(2632085,'5','183','949',423,'Sale Id shift 257739',0.00,0.00,0.00,1801.27,0.00,'2022-09-07 10:24:40','',''),(2632086,'5','183','950',423,'Sale Id shift 257739',0.00,0.00,0.00,2005.06,0.00,'2022-09-07 10:24:40','',''),(2632087,'5','183',NULL,423,'Sale Id shift 257739',704171.05,0.00,0.00,0.00,0.00,'2022-09-07 10:24:40','',''),(2632088,'5','183','949',423,'Sale Id shift 257740',0.00,0.00,0.00,1178.60,0.00,'2022-09-07 10:31:41','',''),(2632089,'5','183','949',423,'Sale Id shift 257740',0.00,0.00,0.00,1304.72,0.00,'2022-09-07 10:31:41','',''),(2632090,'5','183','950',423,'Sale Id shift 257740',0.00,0.00,0.00,1240.24,0.00,'2022-09-07 10:31:41','',''),(2632091,'5','183',NULL,423,'Sale Id shift 257740',688858.60,0.00,0.00,0.00,0.00,'2022-09-07 10:31:41','',''),(2632092,'5','183','949',423,'Sale Id shift 257741',0.00,0.00,0.00,2872.43,0.00,'2022-09-07 10:37:08','',''),(2632093,'5','183','950',423,'Sale Id shift 257741',0.00,0.00,0.00,2963.20,0.00,'2022-09-07 10:37:08','',''),(2632094,'5','183',NULL,423,'Sale Id shift 257741',1079591.55,0.00,0.00,0.00,0.00,'2022-09-07 10:37:08','',''),(2632095,'5','183','949',423,'Sale Id shift 257742',0.00,0.00,0.00,3113.01,0.00,'2022-09-07 10:41:42','',''),(2632096,'5','183','950',423,'Sale Id shift 257742',0.00,0.00,0.00,2773.64,0.00,'2022-09-07 10:41:42','',''),(2632097,'5','183',NULL,423,'Sale Id shift 257742',1089030.25,0.00,0.00,0.00,0.00,'2022-09-07 10:41:42','',''),(2632098,'5','183','949',423,'Sale Id shift 257743',0.00,0.00,0.00,173.44,0.00,'2022-09-08 07:08:12','',''),(2632099,'5','183','950',423,'Sale Id shift 257743',0.00,0.00,0.00,2690.76,0.00,'2022-09-08 07:08:12','',''),(2632100,'5','183','950',423,'Sale Id shift 257743',0.00,0.00,0.00,1837.33,0.00,'2022-09-08 07:08:12','',''),(2632101,'5','183',NULL,423,'Sale Id shift 257743',869783.05,0.00,0.00,0.00,0.00,'2022-09-08 07:08:12','',''),(2632102,'5','183','950',423,'Sale Id shift 257744',0.00,0.00,0.00,1562.92,0.00,'2022-09-09 08:15:14','',''),(2632103,'5','183','950',423,'Sale Id shift 257744',0.00,0.00,0.00,2029.15,0.00,'2022-09-09 08:15:14','',''),(2632104,'5','183',NULL,423,'Sale Id shift 257744',664532.95,0.00,0.00,0.00,0.00,'2022-09-09 08:15:14','',''),(2632105,'5','183','950',0,'Tank level zero out for dipping',0.00,0.00,0.00,365.57,0.00,'2022-09-10 09:40:03','',''),(2632106,'5','183','950',0,'Inventory adjustment from tank dipping to 8500',0.00,0.00,8500.00,0.00,0.00,'2022-09-10 09:40:03','',''),(2632107,'5','183','950',423,'Sale Id shift 257745',0.00,0.00,0.00,1641.24,0.00,'2022-09-10 13:01:17','',''),(2632108,'5','183','950',423,'Sale Id shift 257745',0.00,0.00,0.00,1481.35,0.00,'2022-09-10 13:01:17','',''),(2632109,'5','183',NULL,423,'Sale Id shift 257745',577679.15,0.00,0.00,0.00,0.00,'2022-09-10 13:01:17','',''),(2632110,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7357450.00,39770.00,0.00,0.00,'2022-09-10 19:27:38','',''),(2632111,'5','183',NULL,423,'Reception corrector for bridging 131979',0.00,0.00,0.00,27000.00,0.00,'2022-09-10 21:31:23','',''),(2632112,'5','183','949',423,'Received from bridging 131979',0.00,0.00,27000.00,0.00,0.00,'2022-09-10 21:31:23','',''),(2632113,'5','183',NULL,423,'Reception corrector for bridging 131980',0.00,0.00,0.00,12770.00,0.00,'2022-09-10 21:31:52','',''),(2632114,'5','183','950',423,'Received from bridging 131980',0.00,0.00,12770.00,0.00,0.00,'2022-09-10 21:31:52','',''),(2632115,'5','183','949',423,'Sale Id shift 257746',0.00,0.00,0.00,1806.34,0.00,'2022-09-11 08:53:24','',''),(2632116,'5','183','949',423,'Sale Id shift 257746',0.00,0.00,0.00,1708.69,0.00,'2022-09-11 08:53:24','',''),(2632117,'5','183',NULL,423,'Sale Id shift 257746',650280.55,0.00,0.00,0.00,0.00,'2022-09-11 08:53:24','',''),(2632118,'5','183','949',423,'Sale Id shift 257747',0.00,0.00,0.00,818.05,0.00,'2022-09-12 08:53:04','',''),(2632119,'5','183','949',423,'Sale Id shift 257747',0.00,0.00,0.00,475.94,0.00,'2022-09-12 08:53:04','',''),(2632120,'5','183',NULL,423,'Sale Id shift 257747',239388.15,0.00,0.00,0.00,0.00,'2022-09-12 08:53:04','',''),(2632121,'5','183','949',423,'Sale Id shift 257748',0.00,0.00,0.00,1481.10,0.00,'2022-09-13 09:13:17','',''),(2632122,'5','183','949',423,'Sale Id shift 257748',0.00,0.00,0.00,2042.89,0.00,'2022-09-13 09:13:17','',''),(2632123,'5','183',NULL,423,'Sale Id shift 257748',651938.15,0.00,0.00,0.00,0.00,'2022-09-13 09:13:17','',''),(2632124,'5','183','949',423,'Sale Id shift 257749',0.00,0.00,0.00,593.59,0.00,'2022-09-14 08:10:20','',''),(2632125,'5','183','949',423,'Sale Id shift 257749',0.00,0.00,0.00,1161.15,0.00,'2022-09-14 08:10:20','',''),(2632126,'5','183','950',423,'Sale Id shift 257749',0.00,0.00,0.00,566.96,0.00,'2022-09-14 08:10:20','',''),(2632127,'5','183',NULL,423,'Sale Id shift 257749',429514.50,0.00,0.00,0.00,0.00,'2022-09-14 08:10:20','',''),(2632128,'5','183','949',423,'Sale Id shift 257750',0.00,0.00,0.00,1015.66,0.00,'2022-09-15 08:49:38','',''),(2632129,'5','183','949',423,'Sale Id shift 257750',0.00,0.00,0.00,1745.97,0.00,'2022-09-15 08:49:38','',''),(2632130,'5','183','950',423,'Sale Id shift 257750',0.00,0.00,0.00,1156.17,0.00,'2022-09-15 08:49:38','',''),(2632131,'5','183',NULL,423,'Sale Id shift 257750',724793.00,0.00,0.00,0.00,0.00,'2022-09-15 08:49:38','',''),(2632132,'5','183','949',423,'Sale Id shift 257751',0.00,0.00,0.00,2087.17,0.00,'2022-09-16 09:05:40','',''),(2632133,'5','183','949',423,'Sale Id shift 257751',0.00,0.00,0.00,2132.61,0.00,'2022-09-16 09:05:40','',''),(2632134,'5','183',NULL,423,'Sale Id shift 257751',780659.30,0.00,0.00,0.00,0.00,'2022-09-16 09:05:40','',''),(2632135,'5','183','949',423,'Sale Id shift 257752',0.00,0.00,0.00,1994.79,0.00,'2022-09-17 10:11:41','',''),(2632136,'5','183','949',423,'Sale Id shift 257752',0.00,0.00,0.00,1009.74,0.00,'2022-09-17 10:11:41','',''),(2632137,'5','183',NULL,423,'Sale Id shift 257752',555838.05,0.00,0.00,0.00,0.00,'2022-09-17 10:11:41','',''),(2632138,'5','183','949',423,'Sale Id shift 257753',0.00,0.00,0.00,1355.68,0.00,'2022-09-18 07:19:08','',''),(2632139,'5','183','949',423,'Sale Id shift 257753',0.00,0.00,0.00,482.00,0.00,'2022-09-18 07:19:08','',''),(2632140,'5','183','950',423,'Sale Id shift 257753',0.00,0.00,0.00,363.54,0.00,'2022-09-18 07:19:08','',''),(2632141,'5','183','950',423,'Sale Id shift 257753',0.00,0.00,0.00,1168.97,0.00,'2022-09-18 07:19:08','',''),(2632142,'5','183',NULL,423,'Sale Id shift 257753',623485.15,0.00,0.00,0.00,0.00,'2022-09-18 07:19:08','',''),(2632143,'5','183','949',423,'Sale Id shift 257754',0.00,0.00,0.00,2602.16,0.00,'2022-09-19 07:18:27','',''),(2632144,'5','183','949',423,'Sale Id shift 257754',0.00,0.00,0.00,2193.69,0.00,'2022-09-19 07:18:27','',''),(2632145,'5','183',NULL,423,'Sale Id shift 257754',887232.25,0.00,0.00,0.00,0.00,'2022-09-19 07:18:27','',''),(2632146,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8269500.00,44700.00,0.00,0.00,'2022-09-19 18:14:46','',''),(2632147,'5','183','949',423,'Sale Id shift 257755',0.00,0.00,0.00,1671.82,0.00,'2022-09-20 08:31:26','',''),(2632148,'5','183','949',423,'Sale Id shift 257755',0.00,0.00,0.00,1107.69,0.00,'2022-09-20 08:31:26','',''),(2632149,'5','183','950',423,'Sale Id shift 257755',0.00,0.00,0.00,903.59,0.00,'2022-09-20 08:31:26','',''),(2632150,'5','183',NULL,423,'Sale Id shift 257755',681373.50,0.00,0.00,0.00,0.00,'2022-09-20 08:31:26','',''),(2632151,'5','183',NULL,423,'Reception corrector for bridging 131981',0.00,0.00,0.00,30000.00,0.00,'2022-09-20 20:24:18','',''),(2632152,'5','183','949',423,'Received from bridging 131981',0.00,0.00,30000.00,0.00,0.00,'2022-09-20 20:24:18','',''),(2632153,'5','183',NULL,423,'Reception corrector for bridging 131982',0.00,0.00,0.00,14700.00,0.00,'2022-09-20 20:24:40','',''),(2632154,'5','183','950',423,'Received from bridging 131982',0.00,0.00,14700.00,0.00,0.00,'2022-09-20 20:24:40','',''),(2632155,'5','183','949',423,'Sale Id shift 257756',0.00,0.00,0.00,1399.32,0.00,'2022-09-21 11:48:42','',''),(2632156,'5','183','949',423,'Sale Id shift 257756',0.00,0.00,0.00,1235.50,0.00,'2022-09-21 11:48:42','',''),(2632157,'5','183','950',423,'Sale Id shift 257756',0.00,0.00,0.00,792.12,0.00,'2022-09-21 11:48:42','',''),(2632158,'5','183',NULL,423,'Sale Id shift 257756',633983.90,0.00,0.00,0.00,0.00,'2022-09-21 11:48:42','',''),(2632159,'5','183','949',423,'Sale Id shift 257757',0.00,0.00,0.00,1289.53,0.00,'2022-09-22 07:37:35','',''),(2632160,'5','183','949',423,'Sale Id shift 257757',0.00,0.00,0.00,1027.73,0.00,'2022-09-22 07:37:35','',''),(2632161,'5','183','950',423,'Sale Id shift 257757',0.00,0.00,0.00,920.96,0.00,'2022-09-22 07:37:35','',''),(2632162,'5','183',NULL,423,'Sale Id shift 257757',599070.70,0.00,0.00,0.00,0.00,'2022-09-22 07:37:35','',''),(2632163,'5','183','949',423,'Sale Id shift 257758',0.00,0.00,0.00,2264.19,0.00,'2022-09-23 07:46:01','',''),(2632164,'5','183','949',423,'Sale Id shift 257758',0.00,0.00,0.00,1560.30,0.00,'2022-09-23 07:46:01','',''),(2632165,'5','183','950',423,'Sale Id shift 257758',0.00,0.00,0.00,452.40,0.00,'2022-09-23 07:46:01','',''),(2632166,'5','183',NULL,423,'Sale Id shift 257758',791224.65,0.00,0.00,0.00,0.00,'2022-09-23 07:46:01','',''),(2632167,'5','183','949',423,'Sale Id shift 257759',0.00,0.00,0.00,1741.54,0.00,'2022-09-24 08:28:33','',''),(2632168,'5','183','950',423,'Sale Id shift 257759',0.00,0.00,0.00,1888.84,0.00,'2022-09-24 08:28:33','',''),(2632169,'5','183',NULL,423,'Sale Id shift 257759',671620.30,0.00,0.00,0.00,0.00,'2022-09-24 08:28:33','',''),(2632170,'5','183','949',423,'Sale Id shift 257760',0.00,0.00,0.00,1426.77,0.00,'2022-09-25 08:02:19','',''),(2632171,'5','183','949',423,'Sale Id shift 257760',0.00,0.00,0.00,1357.17,0.00,'2022-09-25 08:02:19','',''),(2632172,'5','183',NULL,423,'Sale Id shift 257760',515028.90,0.00,0.00,0.00,0.00,'2022-09-25 08:02:19','',''),(2632173,'5','183','949',423,'Sale Id shift 257761',0.00,0.00,0.00,3248.67,0.00,'2022-09-26 07:16:05','',''),(2632174,'5','183','949',423,'Sale Id shift 257761',0.00,0.00,0.00,1165.13,0.00,'2022-09-26 07:16:05','',''),(2632175,'5','183','950',423,'Sale Id shift 257761',0.00,0.00,0.00,2372.83,0.00,'2022-09-26 07:16:05','',''),(2632176,'5','183',NULL,423,'Sale Id shift 257761',1255526.55,0.00,0.00,0.00,0.00,'2022-09-26 07:16:05','',''),(2632177,'5','183','949',423,'Sale Id shift 257762',0.00,0.00,0.00,2340.28,0.00,'2022-09-27 07:22:26','',''),(2632178,'5','183','949',423,'Sale Id shift 257762',0.00,0.00,0.00,421.92,0.00,'2022-09-27 07:22:26','',''),(2632179,'5','183','950',423,'Sale Id shift 257762',0.00,0.00,0.00,1515.80,0.00,'2022-09-27 07:22:26','',''),(2632180,'5','183',NULL,423,'Sale Id shift 257762',791430.00,0.00,0.00,0.00,0.00,'2022-09-27 07:22:26','',''),(2632181,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-27 16:47:19','',''),(2632182,'5','183','949',423,'Sale Id shift 257763',0.00,0.00,0.00,2381.82,0.00,'2022-09-28 08:20:54','',''),(2632183,'5','183','949',423,'Sale Id shift 257763',0.00,0.00,0.00,539.74,0.00,'2022-09-28 08:20:54','',''),(2632184,'5','183','950',423,'Sale Id shift 257763',0.00,0.00,0.00,2216.40,0.00,'2022-09-28 08:20:54','',''),(2632185,'5','183',NULL,423,'Sale Id shift 257763',950522.60,0.00,0.00,0.00,0.00,'2022-09-28 08:20:54','',''),(2632186,'5','183','949',423,'Sale Id shift 257764',0.00,0.00,0.00,2346.56,0.00,'2022-09-29 08:32:42','',''),(2632187,'5','183','949',423,'Sale Id shift 257764',0.00,0.00,0.00,595.32,0.00,'2022-09-29 08:32:42','',''),(2632188,'5','183','950',423,'Sale Id shift 257764',0.00,0.00,0.00,2684.58,0.00,'2022-09-29 08:32:42','',''),(2632189,'5','183',NULL,423,'Sale Id shift 257764',1040895.10,0.00,0.00,0.00,0.00,'2022-09-29 08:32:42','',''),(2632190,'5','183','949',423,'Sale Id shift 257765',0.00,0.00,0.00,3192.49,0.00,'2022-09-30 08:05:45','',''),(2632191,'5','183','949',423,'Sale Id shift 257765',0.00,0.00,0.00,2498.61,0.00,'2022-09-30 08:05:45','',''),(2632192,'5','183',NULL,423,'Sale Id shift 257765',1052853.50,0.00,0.00,0.00,0.00,'2022-09-30 08:05:45','',''),(2632193,'5','183',NULL,423,'Reception corrector for bridging 131983',0.00,0.00,0.00,30000.00,0.00,'2022-09-30 22:36:46','',''),(2632194,'5','183','949',423,'Received from bridging 131983',0.00,0.00,30000.00,0.00,0.00,'2022-09-30 22:36:46','',''),(2632195,'5','183',NULL,423,'Reception corrector for bridging 131984',0.00,0.00,0.00,15000.00,0.00,'2022-09-30 22:37:09','',''),(2632196,'5','183','950',423,'Received from bridging 131984',0.00,0.00,15000.00,0.00,0.00,'2022-09-30 22:37:09','',''),(2632197,'5','183','949',423,'Sale Id shift 257766',0.00,0.00,0.00,2510.55,0.00,'2022-10-01 08:56:26','',''),(2632198,'5','183','949',423,'Sale Id shift 257766',0.00,0.00,0.00,2468.98,0.00,'2022-10-01 08:56:26','',''),(2632199,'5','183',NULL,423,'Sale Id shift 257766',921213.05,0.00,0.00,0.00,0.00,'2022-10-01 08:56:26','',''),(2632200,'5','183','949',423,'Sale Id shift 257767',0.00,0.00,0.00,2527.48,0.00,'2022-10-02 18:36:26','',''),(2632201,'5','183','949',423,'Sale Id shift 257767',0.00,0.00,0.00,2399.90,0.00,'2022-10-02 18:36:26','',''),(2632202,'5','183',NULL,423,'Sale Id shift 257767',911565.30,0.00,0.00,0.00,0.00,'2022-10-02 18:36:26','',''),(2632203,'5','183','949',423,'Sale Id shift 257768',0.00,0.00,0.00,3003.45,0.00,'2022-10-03 06:22:58','',''),(2632204,'5','183','949',423,'Sale Id shift 257768',0.00,0.00,0.00,2918.20,0.00,'2022-10-03 06:22:58','',''),(2632205,'5','183','950',423,'Sale Id shift 257768',0.00,0.00,0.00,350.57,0.00,'2022-10-03 06:22:58','',''),(2632206,'5','183',NULL,423,'Sale Id shift 257768',1160360.70,0.00,0.00,0.00,0.00,'2022-10-03 06:22:58','',''),(2632207,'5','183','949',423,'Sale Id shift 257769',0.00,0.00,0.00,2953.06,0.00,'2022-10-04 07:10:24','',''),(2632208,'5','183','949',423,'Sale Id shift 257769',0.00,0.00,0.00,2168.72,0.00,'2022-10-04 07:10:24','',''),(2632209,'5','183',NULL,423,'Sale Id shift 257769',947529.30,0.00,0.00,0.00,0.00,'2022-10-04 07:10:24','',''),(2632210,'5','183','949',423,'Sale Id shift 257770',0.00,0.00,0.00,1242.24,0.00,'2022-10-05 09:35:17','',''),(2632211,'5','183','949',423,'Sale Id shift 257770',0.00,0.00,0.00,1572.36,0.00,'2022-10-05 09:35:17','',''),(2632212,'5','183','950',423,'Sale Id shift 257770',0.00,0.00,0.00,1205.91,0.00,'2022-10-05 09:35:17','',''),(2632213,'5','183',NULL,423,'Sale Id shift 257770',743794.35,0.00,0.00,0.00,0.00,'2022-10-05 09:35:17','',''),(2632214,'5','183','950',423,'Sale Id shift 257771',0.00,0.00,0.00,5632.63,0.00,'2022-10-06 07:57:06','',''),(2632215,'5','183',NULL,423,'Sale Id shift 257771',1042036.55,0.00,0.00,0.00,0.00,'2022-10-06 07:57:06','',''),(2632216,'5','183','950',423,'Sale Id shift 257772',0.00,0.00,0.00,4736.96,0.00,'2022-10-07 08:22:49','',''),(2632217,'5','183','950',423,'Sale Id shift 257772',0.00,0.00,0.00,542.67,0.00,'2022-10-07 08:22:49','',''),(2632218,'5','183',NULL,423,'Sale Id shift 257772',976731.55,0.00,0.00,0.00,0.00,'2022-10-07 08:22:49','',''),(2632219,'5','183','950',423,'Sale Id shift 257773',0.00,0.00,0.00,6564.46,0.00,'2022-10-08 08:34:08','',''),(2632220,'5','183',NULL,423,'Sale Id shift 257773',1214425.10,0.00,0.00,0.00,0.00,'2022-10-08 08:34:08','',''),(2632221,'5','183','950',423,'Sale Id shift 257774',0.00,0.00,0.00,4926.41,0.00,'2022-10-09 08:29:38','',''),(2632222,'5','183','950',423,'Sale Id shift 257774',0.00,0.00,0.00,1525.82,0.00,'2022-10-09 08:29:38','',''),(2632223,'5','183',NULL,423,'Sale Id shift 257774',1193662.55,0.00,0.00,0.00,0.00,'2022-10-09 08:29:38','',''),(2632224,'5','183','950',0,'Tank level zero out for dipping',0.00,0.00,0.00,5358.82,0.00,'2022-10-10 13:14:06','',''),(2632225,'5','183','950',0,'Inventory adjustment from tank dipping to 6000',0.00,0.00,6000.00,0.00,0.00,'2022-10-10 13:14:06','',''),(2632226,'5','183','950',423,'Sale Id shift 257775',0.00,0.00,0.00,5440.37,0.00,'2022-10-10 14:18:04','',''),(2632227,'5','183',NULL,423,'Sale Id shift 257775',1006468.45,0.00,0.00,0.00,0.00,'2022-10-10 14:18:04','',''),(2632228,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-28 14:58:31','',''),(2632229,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,11815.19,0.00,'2022-10-28 16:33:35','',''),(2632230,'5','183','949',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-10-28 16:33:35','',''),(2632231,'5','183','949',0,'Tank level zero out for dipping',0.00,0.00,0.00,600.00,0.00,'2022-10-28 16:33:35','',''),(2632232,'5','183','949',0,'Inventory adjustment from tank dipping to 600',0.00,0.00,600.00,0.00,0.00,'2022-10-28 16:33:35','',''),(2632233,'5','183',NULL,423,'Reception corrector for bridging 131986',0.00,0.00,0.00,17000.00,0.00,'2022-10-28 20:38:32','',''),(2632234,'5','183','950',423,'Received from bridging 131986',0.00,0.00,17000.00,0.00,0.00,'2022-10-28 20:38:32','',''),(2632235,'5','183',NULL,423,'Reception corrector for bridging 131985',0.00,0.00,0.00,33000.00,0.00,'2022-10-28 20:39:58','',''),(2632236,'5','183','949',423,'Received from bridging 131985',0.00,0.00,33000.00,0.00,0.00,'2022-10-28 20:39:58','',''),(2632237,'5','183','949',423,'Sale Id shift 257794',0.00,0.00,0.00,4576.11,0.00,'2022-10-29 07:53:42','',''),(2632238,'5','183','949',423,'Sale Id shift 257794',0.00,0.00,0.00,4174.89,0.00,'2022-10-29 07:53:42','',''),(2632239,'5','183',NULL,423,'Sale Id shift 257794',1618935.00,0.00,0.00,0.00,0.00,'2022-10-29 07:53:42','',''),(2632240,'5','183','949',423,'Sale Id shift 257795',0.00,0.00,0.00,4055.87,0.00,'2022-10-30 06:34:19','',''),(2632241,'5','183','949',423,'Sale Id shift 257795',0.00,0.00,0.00,7225.69,0.00,'2022-10-30 06:34:19','',''),(2632242,'5','183',NULL,423,'Sale Id shift 257795',2087088.60,0.00,0.00,0.00,0.00,'2022-10-30 06:34:19','',''),(2632243,'5','183','949',423,'Sale Id shift 257796',0.00,0.00,0.00,4294.05,0.00,'2022-10-31 06:44:27','',''),(2632244,'5','183','950',423,'Sale Id shift 257796',0.00,0.00,0.00,6310.30,0.00,'2022-10-31 06:44:27','',''),(2632245,'5','183',NULL,423,'Sale Id shift 257796',1961804.75,0.00,0.00,0.00,0.00,'2022-10-31 06:44:27','',''),(2632246,'5','183','949',423,'Sale Id shift 257797',0.00,0.00,0.00,6588.68,0.00,'2022-11-01 07:53:16','',''),(2632247,'5','183','950',423,'Sale Id shift 257797',0.00,0.00,0.00,3871.04,0.00,'2022-11-01 07:53:16','',''),(2632248,'5','183',NULL,423,'Sale Id shift 257797',1935048.20,0.00,0.00,0.00,0.00,'2022-11-01 07:53:16','',''),(2632249,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-11-02 06:25:50','',''),(2632250,'5','183',NULL,423,'Reception corrector for bridging 131988',0.00,0.00,0.00,13500.00,0.00,'2022-11-02 09:39:52','',''),(2632251,'5','183','950',423,'Received from bridging 131988',0.00,0.00,13500.00,0.00,0.00,'2022-11-02 09:39:52','',''),(2632252,'5','183',NULL,423,'Reception corrector for bridging 131987',0.00,0.00,0.00,26500.00,0.00,'2022-11-02 09:40:02','',''),(2632253,'5','183','949',423,'Received from bridging 131987',0.00,0.00,26500.00,0.00,0.00,'2022-11-02 09:40:02','',''),(2632254,'5','183','949',423,'Sale Id shift 257798',0.00,0.00,0.00,8048.69,0.00,'2022-11-02 13:05:08','',''),(2632255,'5','183','949',423,'Sale Id shift 257798',0.00,0.00,0.00,3264.66,0.00,'2022-11-02 13:05:08','',''),(2632256,'5','183',NULL,423,'Sale Id shift 257798',2092969.75,0.00,0.00,0.00,0.00,'2022-11-02 13:05:08','',''),(2632257,'5','183','949',423,'Sale Id shift 257799',0.00,0.00,0.00,1668.78,0.00,'2022-11-03 08:12:11','',''),(2632258,'5','183','949',423,'Sale Id shift 257799',0.00,0.00,0.00,5351.74,0.00,'2022-11-03 08:12:11','',''),(2632259,'5','183','950',423,'Sale Id shift 257799',0.00,0.00,0.00,6281.19,0.00,'2022-11-03 08:12:11','',''),(2632260,'5','183',NULL,423,'Sale Id shift 257799',2460816.35,0.00,0.00,0.00,0.00,'2022-11-03 08:12:11','',''),(2632261,'5','183','949',423,'Sale Id shift 257800',0.00,0.00,0.00,9026.70,0.00,'2022-11-04 07:31:02','',''),(2632262,'5','183','950',423,'Sale Id shift 257800',0.00,0.00,0.00,5499.00,0.00,'2022-11-04 07:31:02','',''),(2632263,'5','183',NULL,423,'Sale Id shift 257800',2687254.50,0.00,0.00,0.00,0.00,'2022-11-04 07:31:02','',''),(2632264,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7344500.00,39700.00,0.00,0.00,'2022-11-04 07:31:25','',''),(2632265,'5','183',NULL,423,'Reception corrector for bridging 131989',0.00,0.00,0.00,26200.00,0.00,'2022-11-05 18:06:01','',''),(2632266,'5','183','949',423,'Received from bridging 131989',0.00,0.00,26200.00,0.00,0.00,'2022-11-05 18:06:01','',''),(2632267,'5','183',NULL,423,'Reception corrector for bridging 131990',0.00,0.00,0.00,13500.00,0.00,'2022-11-05 18:06:13','',''),(2632268,'5','183','950',423,'Received from bridging 131990',0.00,0.00,13500.00,0.00,0.00,'2022-11-05 18:06:13','',''),(2632269,'5','183','949',423,'Sale Id shift 257801',0.00,0.00,0.00,9414.57,0.00,'2022-11-06 07:07:13','',''),(2632270,'5','183','950',423,'Sale Id shift 257801',0.00,0.00,0.00,4575.93,0.00,'2022-11-06 07:07:13','',''),(2632271,'5','183',NULL,423,'Sale Id shift 257801',2588242.50,0.00,0.00,0.00,0.00,'2022-11-06 07:07:13','',''),(2632272,'5','183','949',423,'Sale Id shift 257802',0.00,0.00,0.00,7223.46,0.00,'2022-11-06 12:34:41','',''),(2632273,'5','183','950',423,'Sale Id shift 257802',0.00,0.00,0.00,5521.67,0.00,'2022-11-06 12:34:41','',''),(2632274,'5','183',NULL,423,'Sale Id shift 257802',2357849.05,0.00,0.00,0.00,0.00,'2022-11-06 12:34:41','',''),(2632275,'5','183','949',423,'Sale Id shift 257803',0.00,0.00,0.00,4931.54,0.00,'2022-11-07 08:28:09','',''),(2632276,'5','183','950',423,'Sale Id shift 257803',0.00,0.00,0.00,3789.30,0.00,'2022-11-07 08:28:09','',''),(2632277,'5','183',NULL,423,'Sale Id shift 257803',1613355.40,0.00,0.00,0.00,0.00,'2022-11-07 08:28:09','',''),(2632278,'5','183','949',423,'Sale Id shift 257804',0.00,0.00,0.00,1023.58,0.00,'2022-11-08 07:58:54','',''),(2632279,'5','183','950',423,'Sale Id shift 257804',0.00,0.00,0.00,4014.83,0.00,'2022-11-08 07:58:54','',''),(2632280,'5','183',NULL,423,'Sale Id shift 257804',932105.85,0.00,0.00,0.00,0.00,'2022-11-08 07:58:54','',''),(2632281,'5','183','949',423,'Sale Id shift 257805',0.00,0.00,0.00,3578.27,0.00,'2022-11-09 08:24:37','',''),(2632282,'5','183','949',423,'Sale Id shift 257805',0.00,0.00,0.00,1271.45,0.00,'2022-11-09 08:24:37','',''),(2632283,'5','183','950',423,'Sale Id shift 257805',0.00,0.00,0.00,525.96,0.00,'2022-11-09 08:24:37','',''),(2632284,'5','183','950',423,'Sale Id shift 257805',0.00,0.00,0.00,477.99,0.00,'2022-11-09 08:24:37','',''),(2632285,'5','183',NULL,423,'Sale Id shift 257805',1082928.95,0.00,0.00,0.00,0.00,'2022-11-09 08:24:37','',''),(2632286,'5','183','950',423,'Sale Id shift 257806',0.00,0.00,0.00,3197.07,0.00,'2022-11-10 09:27:51','',''),(2632287,'5','183',NULL,423,'Sale Id shift 257806',591457.95,0.00,0.00,0.00,0.00,'2022-11-10 09:27:51','',''),(2632288,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-11-20 18:31:49','',''),(2632289,'5','183',NULL,423,'Reception corrector for bridging 131992',0.00,0.00,0.00,15000.00,0.00,'2022-11-20 21:02:31','',''),(2632290,'5','183','950',423,'Received from bridging 131992',0.00,0.00,15000.00,0.00,0.00,'2022-11-20 21:02:31','',''),(2632291,'5','183',NULL,423,'Reception corrector for bridging 131991',0.00,0.00,0.00,30000.00,0.00,'2022-11-20 21:02:42','',''),(2632292,'5','183','949',423,'Received from bridging 131991',0.00,0.00,30000.00,0.00,0.00,'2022-11-20 21:02:42','',''),(2632293,'5','183','949',423,'Sale Id shift 257817',0.00,0.00,0.00,6646.86,0.00,'2022-11-21 06:37:11','',''),(2632294,'5','183','950',423,'Sale Id shift 257817',0.00,0.00,0.00,5333.92,0.00,'2022-11-21 06:37:11','',''),(2632295,'5','183',NULL,423,'Sale Id shift 257817',2216444.30,0.00,0.00,0.00,0.00,'2022-11-21 06:37:11','',''),(2632296,'5','183','949',423,'Sale Id shift 257818',0.00,0.00,0.00,4722.57,0.00,'2022-11-22 09:20:57','',''),(2632297,'5','183','950',423,'Sale Id shift 257818',0.00,0.00,0.00,5514.55,0.00,'2022-11-22 09:20:57','',''),(2632298,'5','183',NULL,423,'Sale Id shift 257818',1893867.20,0.00,0.00,0.00,0.00,'2022-11-22 09:20:57','',''),(2632299,'5','183','949',423,'Sale Id shift 257819',0.00,0.00,0.00,3840.50,0.00,'2022-11-23 08:29:45','',''),(2632300,'5','183','950',423,'Sale Id shift 257819',0.00,0.00,0.00,4542.23,0.00,'2022-11-23 08:29:45','',''),(2632301,'5','183',NULL,423,'Sale Id shift 257819',1550805.05,0.00,0.00,0.00,0.00,'2022-11-23 08:29:45','',''),(2632302,'5','183','949',423,'Sale Id shift 257820',0.00,0.00,0.00,8370.91,0.00,'2022-11-24 13:10:23','',''),(2632303,'5','183',NULL,423,'Sale Id shift 257820',1548618.35,0.00,0.00,0.00,0.00,'2022-11-24 13:10:23','',''),(2632304,'5','183','949',423,'Sale Id shift 257821',0.00,0.00,0.00,4510.39,0.00,'2022-11-25 08:31:55','',''),(2632305,'5','183','949',423,'Sale Id shift 257821',0.00,0.00,0.00,1347.17,0.00,'2022-11-25 08:31:55','',''),(2632306,'5','183',NULL,423,'Sale Id shift 257821',1083648.60,0.00,0.00,0.00,0.00,'2022-11-25 08:31:55','',''),(2632307,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,7335250.00,39650.00,0.00,0.00,'2022-12-01 16:38:27','',''),(2632308,'5','183',NULL,423,'Reception corrector for bridging 131993',0.00,0.00,0.00,26200.00,0.00,'2022-12-02 06:20:57','',''),(2632309,'5','183','949',423,'Received from bridging 131993',0.00,0.00,26200.00,0.00,0.00,'2022-12-02 06:20:57','',''),(2632310,'5','183',NULL,423,'Reception corrector for bridging 131994',0.00,0.00,0.00,13450.00,0.00,'2022-12-02 06:21:13','',''),(2632311,'5','183','950',423,'Received from bridging 131994',0.00,0.00,13450.00,0.00,0.00,'2022-12-02 06:21:13','',''),(2632312,'5','183','949',423,'Sale Id shift 257828',0.00,0.00,0.00,7262.77,0.00,'2022-12-02 09:11:17','',''),(2632313,'5','183','950',423,'Sale Id shift 257828',0.00,0.00,0.00,4437.59,0.00,'2022-12-02 09:11:17','',''),(2632314,'5','183',NULL,423,'Sale Id shift 257828',2164566.60,0.00,0.00,0.00,0.00,'2022-12-02 09:11:17','',''),(2632315,'5','183','949',423,'Sale Id shift 257829',0.00,0.00,0.00,5710.41,0.00,'2022-12-03 08:22:01','',''),(2632316,'5','183','949',423,'Sale Id shift 257829',0.00,0.00,0.00,4449.70,0.00,'2022-12-03 08:22:01','',''),(2632317,'5','183',NULL,423,'Sale Id shift 257829',1879620.35,0.00,0.00,0.00,0.00,'2022-12-03 08:22:01','',''),(2632318,'5','183','949',423,'Sale Id shift 257830',0.00,0.00,0.00,1939.51,0.00,'2022-12-04 09:14:12','',''),(2632319,'5','183','950',423,'Sale Id shift 257830',0.00,0.00,0.00,9097.44,0.00,'2022-12-04 09:14:12','',''),(2632320,'5','183',NULL,423,'Sale Id shift 257830',2041835.75,0.00,0.00,0.00,0.00,'2022-12-04 09:14:12','',''),(2632321,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5485250.00,29650.00,0.00,0.00,'2022-12-05 07:34:42','',''),(2632322,'5','183',NULL,423,'Reception corrector for bridging 131995',0.00,0.00,0.00,29650.00,0.00,'2022-12-05 09:09:55','',''),(2632323,'5','183','949',423,'Received from bridging 131995',0.00,0.00,29650.00,0.00,0.00,'2022-12-05 09:09:55','',''),(2632324,'5','183','949',423,'Sale Id shift 257831',0.00,0.00,0.00,10811.15,0.00,'2022-12-05 13:56:25','',''),(2632325,'5','183',NULL,423,'Sale Id shift 257831',2000062.75,0.00,0.00,0.00,0.00,'2022-12-05 13:56:25','',''),(2632326,'5','183','949',423,'Sale Id shift 257832',0.00,0.00,0.00,13672.42,0.00,'2022-12-06 07:55:57','',''),(2632327,'5','183',NULL,423,'Sale Id shift 257832',2529397.70,0.00,0.00,0.00,0.00,'2022-12-06 07:55:57','',''),(2632328,'5','183','949',423,'Sale Id shift 257833',0.00,0.00,0.00,3178.15,0.00,'2022-12-08 07:48:22','',''),(2632329,'5','183','949',423,'Sale Id shift 257833',0.00,0.00,0.00,8840.55,0.00,'2022-12-08 07:48:22','',''),(2632330,'5','183',NULL,423,'Sale Id shift 257833',2223459.50,0.00,0.00,0.00,0.00,'2022-12-08 07:48:22','',''),(2632331,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-12-19 12:52:57','',''),(2632332,'5','183',NULL,423,'Reception corrector for bridging 131996',0.00,0.00,0.00,30000.00,0.00,'2022-12-19 13:32:59','',''),(2632333,'5','183','949',423,'Received from bridging 131996',0.00,0.00,30000.00,0.00,0.00,'2022-12-19 13:32:59','',''),(2632334,'5','183','949',423,'Sale Id shift 257846',0.00,0.00,0.00,4123.04,0.00,'2022-12-20 09:35:08','',''),(2632335,'5','183','949',423,'Sale Id shift 257846',0.00,0.00,0.00,7839.06,0.00,'2022-12-20 09:35:09','',''),(2632336,'5','183',NULL,423,'Sale Id shift 257846',2212988.50,0.00,0.00,0.00,0.00,'2022-12-20 09:35:09','',''),(2632337,'5','183','949',423,'Sale Id shift 257847',0.00,0.00,0.00,10540.70,0.00,'2022-12-21 09:19:47','',''),(2632338,'5','183','949',423,'Sale Id shift 257847',0.00,0.00,0.00,2558.61,0.00,'2022-12-21 09:19:47','',''),(2632339,'5','183',NULL,423,'Sale Id shift 257847',2423372.35,0.00,0.00,0.00,0.00,'2022-12-21 09:19:47','',''),(2632340,'5','183','949',423,'Sale Id shift 257848',0.00,0.00,0.00,4785.63,0.00,'2022-12-22 09:05:06','',''),(2632341,'5','183',NULL,423,'Sale Id shift 257848',885341.55,0.00,0.00,0.00,0.00,'2022-12-22 09:05:06','',''),(2632342,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,12210.00,66.00,0.00,0.00,'2023-01-13 16:14:40','',''),(2632343,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,5522250.00,29850.00,0.00,0.00,'2023-01-16 13:22:18','',''),(2632344,'5','183',NULL,423,'Reception corrector for bridging 131997',0.00,0.00,0.00,29850.00,0.00,'2023-01-16 14:15:36','',''),(2632345,'5','183','949',423,'Received from bridging 131997',0.00,0.00,29850.00,0.00,0.00,'2023-01-16 14:15:36','',''),(2632346,'5','183','949',423,'Sale Id shift 257875',0.00,0.00,0.00,5251.01,0.00,'2023-01-17 09:39:10','',''),(2632347,'5','183','949',423,'Sale Id shift 257875',0.00,0.00,0.00,5345.89,0.00,'2023-01-17 09:39:10','',''),(2632348,'5','183',NULL,423,'Sale Id shift 257875',1960426.50,0.00,0.00,0.00,0.00,'2023-01-17 09:39:10','',''),(2632349,'5','183','949',423,'Sale Id shift 257876',0.00,0.00,0.00,4743.94,0.00,'2023-01-18 09:36:58','',''),(2632350,'5','183','949',423,'Sale Id shift 257876',0.00,0.00,0.00,11126.92,0.00,'2023-01-18 09:36:58','',''),(2632351,'5','183',NULL,423,'Sale Id shift 257876',2936109.10,0.00,0.00,0.00,0.00,'2023-01-18 09:36:58','',''),(2632352,'5','183','949',423,'Sale Id shift 257877',0.00,0.00,0.00,2670.03,0.00,'2023-01-19 09:32:43','',''),(2632353,'5','183','949',423,'Sale Id shift 257877',0.00,0.00,0.00,712.21,0.00,'2023-01-19 09:32:43','',''),(2632354,'5','183',NULL,423,'Sale Id shift 257877',625714.40,0.00,0.00,0.00,0.00,'2023-01-19 09:32:43','',''),(2632355,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4070000.00,18500.00,0.00,0.00,'2023-01-21 12:36:47','',''),(2632356,'5','183',NULL,423,'Reception corrector for bridging 131998',0.00,0.00,0.00,18500.00,0.00,'2023-01-22 05:05:30','',''),(2632357,'5','183','949',423,'Received from bridging 131998',0.00,0.00,18500.00,0.00,0.00,'2023-01-22 05:05:30','',''),(2632358,'5','183','949',423,'Sale Id shift 257880',0.00,0.00,0.00,3768.42,0.00,'2023-01-22 10:18:06','',''),(2632359,'5','183','949',423,'Sale Id shift 257880',0.00,0.00,0.00,1681.77,0.00,'2023-01-22 10:18:06','',''),(2632360,'5','183',NULL,423,'Sale Id shift 257880',1199041.80,0.00,0.00,0.00,0.00,'2023-01-22 10:18:06','',''),(2632361,'5','183','949',423,'Sale Id shift 257881',0.00,0.00,0.00,2308.78,0.00,'2023-01-23 10:09:31','',''),(2632362,'5','183','949',423,'Sale Id shift 257881',0.00,0.00,0.00,6839.61,0.00,'2023-01-23 10:09:31','',''),(2632363,'5','183',NULL,423,'Sale Id shift 257881',2012645.80,0.00,0.00,0.00,0.00,'2023-01-23 10:09:31','',''),(2632364,'5','183','949',423,'Sale Id shift 257882',0.00,0.00,0.00,3901.42,0.00,'2023-01-24 11:26:44','',''),(2632365,'5','183',NULL,423,'Sale Id shift 257882',858312.40,0.00,0.00,0.00,0.00,'2023-01-24 11:26:44','',''),(2632366,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,2970000.00,13500.00,0.00,0.00,'2023-01-26 09:35:45','',''),(2632367,'5','183',NULL,423,'Reception corrector for bridging 131999',0.00,0.00,0.00,13500.00,0.00,'2023-01-26 10:52:36','',''),(2632368,'5','183','949',423,'Received from bridging 131999',0.00,0.00,13500.00,0.00,0.00,'2023-01-26 10:52:36','',''),(2632369,'5','183','949',423,'Sale Id shift 257885',0.00,0.00,0.00,2370.82,0.00,'2023-01-27 09:54:21','',''),(2632370,'5','183','949',423,'Sale Id shift 257885',0.00,0.00,0.00,6868.55,0.00,'2023-01-27 09:54:21','',''),(2632371,'5','183',NULL,423,'Sale Id shift 257885',2032661.40,0.00,0.00,0.00,0.00,'2023-01-27 09:54:21','',''),(2632372,'5','183','949',423,'Sale Id shift 257886',0.00,0.00,0.00,1427.80,0.00,'2023-01-28 10:03:51','',''),(2632373,'5','183','949',423,'Sale Id shift 257886',0.00,0.00,0.00,2832.80,0.00,'2023-01-28 10:03:51','',''),(2632374,'5','183',NULL,423,'Sale Id shift 257886',937332.00,0.00,0.00,0.00,0.00,'2023-01-28 10:03:51','',''),(2632375,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4950000.00,22500.00,0.00,0.00,'2023-02-03 09:15:34','',''),(2632376,'5','183',NULL,423,'Reception corrector for bridging 132000',0.00,0.00,0.00,22500.00,0.00,'2023-02-04 04:33:43','',''),(2632377,'5','183','949',423,'Received from bridging 132000',0.00,0.00,22500.00,0.00,0.00,'2023-02-04 04:33:43','',''),(2632378,'5','183','949',423,'Sale Id shift 257891',0.00,0.00,0.00,4332.38,0.00,'2023-02-04 12:58:19','',''),(2632379,'5','183','949',423,'Sale Id shift 257891',0.00,0.00,0.00,7870.19,0.00,'2023-02-04 12:58:19','',''),(2632380,'5','183',NULL,423,'Sale Id shift 257891',2684565.40,0.00,0.00,0.00,0.00,'2023-02-04 12:58:19','',''),(2632381,'5','183','949',423,'Sale Id shift 257892',0.00,0.00,0.00,3676.32,0.00,'2023-02-05 16:21:10','',''),(2632382,'5','183','949',423,'Sale Id shift 257892',0.00,0.00,0.00,6621.11,0.00,'2023-02-05 16:21:10','',''),(2632383,'5','183',NULL,423,'Sale Id shift 257892',2265434.60,0.00,0.00,0.00,0.00,'2023-02-05 16:21:10','',''),(2632384,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3300000.00,15000.00,0.00,0.00,'2023-02-08 14:30:51','',''),(2632385,'5','183',NULL,423,'Reception corrector for bridging 132001',0.00,0.00,0.00,15000.00,0.00,'2023-02-09 10:09:19','',''),(2632386,'5','183','949',423,'Received from bridging 132001',0.00,0.00,15000.00,0.00,0.00,'2023-02-09 10:09:19','',''),(2632387,'5','183','949',423,'Sale Id shift 257896',0.00,0.00,0.00,3225.41,0.00,'2023-02-09 12:07:25','',''),(2632388,'5','183','949',423,'Sale Id shift 257896',0.00,0.00,0.00,8538.54,0.00,'2023-02-09 12:07:25','',''),(2632389,'5','183',NULL,423,'Sale Id shift 257896',2588069.00,0.00,0.00,0.00,0.00,'2023-02-09 12:07:25','',''),(2632390,'5','183','949',423,'Sale Id shift 257897',0.00,0.00,0.00,1319.34,0.00,'2023-02-10 09:11:27','',''),(2632391,'5','183','949',423,'Sale Id shift 257897',0.00,0.00,0.00,1916.71,0.00,'2023-02-10 09:11:27','',''),(2632392,'5','183',NULL,423,'Sale Id shift 257897',711931.00,0.00,0.00,0.00,0.00,'2023-02-10 09:11:27','',''),(2632393,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,4092000.00,18600.00,0.00,0.00,'2023-02-10 10:30:51','',''),(2632394,'5','183',NULL,423,'Reception corrector for bridging 132002',0.00,0.00,0.00,18600.00,0.00,'2023-02-11 07:28:19','',''),(2632395,'5','183','949',423,'Received from bridging 132002',0.00,0.00,18600.00,0.00,0.00,'2023-02-11 07:28:19','',''),(2632396,'5','183','949',423,'Sale Id shift 257898',0.00,0.00,0.00,727.98,0.00,'2023-02-11 13:09:12','',''),(2632397,'5','183','949',423,'Sale Id shift 257898',0.00,0.00,0.00,5629.92,0.00,'2023-02-11 13:09:12','',''),(2632398,'5','183',NULL,423,'Sale Id shift 257898',1398738.00,0.00,0.00,0.00,0.00,'2023-02-11 13:09:12','',''),(2632399,'5','183','949',423,'Sale Id shift 257899',0.00,0.00,0.00,1592.71,0.00,'2023-02-12 12:48:08','',''),(2632400,'5','183','949',423,'Sale Id shift 257899',0.00,0.00,0.00,7919.12,0.00,'2023-02-12 12:48:08','',''),(2632401,'5','183',NULL,423,'Sale Id shift 257899',2092602.60,0.00,0.00,0.00,0.00,'2023-02-12 12:48:08','',''),(2632402,'5','183','949',423,'Sale Id shift 257900',0.00,0.00,0.00,1605.91,0.00,'2023-02-13 09:21:00','',''),(2632403,'5','183','949',423,'Sale Id shift 257900',0.00,0.00,0.00,1124.36,0.00,'2023-02-13 09:21:00','',''),(2632404,'5','183',NULL,423,'Sale Id shift 257900',600659.40,0.00,0.00,0.00,0.00,'2023-02-13 09:21:00','',''),(2632405,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3570000.00,17000.00,0.00,0.00,'2023-02-25 09:33:26','',''),(2632406,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,3150000.00,15000.00,0.00,0.00,'2023-02-25 09:33:38','',''),(2632407,'5','183',NULL,423,'Reception corrector for bridging 132003',0.00,0.00,0.00,15000.00,0.00,'2023-02-25 15:58:05','',''),(2632408,'5','183','949',423,'Received from bridging 132003',0.00,0.00,15000.00,0.00,0.00,'2023-02-25 15:58:05','',''),(2632409,'5','183',NULL,423,'Reception corrector for bridging 132004',0.00,0.00,0.00,17000.00,0.00,'2023-02-25 15:58:16','',''),(2632410,'5','183','949',423,'Received from bridging 132004',0.00,0.00,17000.00,0.00,0.00,'2023-02-25 15:58:16','',''),(2632411,'5','183','949',423,'Sale Id shift 257910',0.00,0.00,0.00,4284.90,0.00,'2023-02-26 20:43:45','',''),(2632412,'5','183',NULL,423,'Sale Id shift 257910',899829.00,0.00,0.00,0.00,0.00,'2023-02-26 20:43:45','',''),(2632413,'5','183','949',423,'Sale Id shift 257911',0.00,0.00,0.00,2876.44,0.00,'2023-02-27 08:38:45','',''),(2632414,'5','183','949',423,'Sale Id shift 257911',0.00,0.00,0.00,7232.02,0.00,'2023-02-27 08:38:45','',''),(2632415,'5','183',NULL,423,'Sale Id shift 257911',2122776.60,0.00,0.00,0.00,0.00,'2023-02-27 08:38:45','',''),(2632416,'5','183','949',423,'Sale Id shift 257912',0.00,0.00,0.00,5941.76,0.00,'2023-02-28 09:21:16','',''),(2632417,'5','183','949',423,'Sale Id shift 257912',0.00,0.00,0.00,4387.81,0.00,'2023-02-28 09:21:16','',''),(2632418,'5','183',NULL,423,'Sale Id shift 257912',2169209.70,0.00,0.00,0.00,0.00,'2023-02-28 09:21:16','',''),(2632419,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,10311000.00,49100.00,0.00,0.00,'2023-02-28 14:09:31','',''),(2632420,'5','183',NULL,423,'Reception corrector for bridging 132006',0.00,0.00,0.00,32550.00,0.00,'2023-02-28 18:02:36','',''),(2632421,'5','183','950',423,'Received from bridging 132006',0.00,0.00,32550.00,0.00,0.00,'2023-02-28 18:02:36','',''),(2632422,'5','183',NULL,423,'Reception corrector for bridging 132005',0.00,0.00,0.00,16550.00,0.00,'2023-02-28 18:02:48','',''),(2632423,'5','183','949',423,'Received from bridging 132005',0.00,0.00,16550.00,0.00,0.00,'2023-02-28 18:02:48','',''),(2632424,'5','183','949',423,'Sale Id shift 257913',0.00,0.00,0.00,4618.14,0.00,'2023-03-01 08:58:43','',''),(2632425,'5','183','949',423,'Sale Id shift 257913',0.00,0.00,0.00,7900.29,0.00,'2023-03-01 08:58:43','',''),(2632426,'5','183','950',423,'Sale Id shift 257913',0.00,0.00,0.00,1087.88,0.00,'2023-03-01 08:58:43','',''),(2632427,'5','183',NULL,423,'Sale Id shift 257913',2857325.10,0.00,0.00,0.00,0.00,'2023-03-01 08:58:43','',''),(2632428,'5','183','949',423,'Sale Id shift 257914',0.00,0.00,0.00,1449.07,0.00,'2023-03-02 11:32:52','',''),(2632429,'5','183','949',423,'Sale Id shift 257914',0.00,0.00,0.00,6539.05,0.00,'2023-03-02 11:32:52','',''),(2632430,'5','183','950',423,'Sale Id shift 257914',0.00,0.00,0.00,3695.58,0.00,'2023-03-02 11:32:52','',''),(2632431,'5','183','950',423,'Sale Id shift 257914',0.00,0.00,0.00,207.39,0.00,'2023-03-02 11:32:52','',''),(2632432,'5','183',NULL,423,'Sale Id shift 257914',2497128.90,0.00,0.00,0.00,0.00,'2023-03-02 11:32:52','',''),(2632433,'5','183','949',423,'Sale Id shift 257915',0.00,0.00,0.00,714.57,0.00,'2023-03-03 09:41:36','',''),(2632434,'5','183','949',423,'Sale Id shift 257915',0.00,0.00,0.00,3024.23,0.00,'2023-03-03 09:41:36','',''),(2632435,'5','183','950',423,'Sale Id shift 257915',0.00,0.00,0.00,6228.69,0.00,'2023-03-03 09:41:36','',''),(2632436,'5','183','950',423,'Sale Id shift 257915',0.00,0.00,0.00,688.33,0.00,'2023-03-03 09:41:36','',''),(2632437,'5','183',NULL,423,'Sale Id shift 257915',2237722.20,0.00,0.00,0.00,0.00,'2023-03-03 09:41:36','',''),(2632438,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8274000.00,39400.00,0.00,0.00,'2023-03-04 17:18:33','',''),(2632439,'5','183',NULL,423,'Reception corrector for bridging 132007',0.00,0.00,0.00,27850.00,0.00,'2023-03-05 08:37:37','',''),(2632440,'5','183','949',423,'Received from bridging 132007',0.00,0.00,27850.00,0.00,0.00,'2023-03-05 08:37:37','',''),(2632441,'5','183','949',423,'Sale Id shift 257916',0.00,0.00,0.00,5350.90,0.00,'2023-03-05 18:21:52','',''),(2632442,'5','183','949',423,'Sale Id shift 257916',0.00,0.00,0.00,4948.56,0.00,'2023-03-05 18:21:52','',''),(2632443,'5','183','950',423,'Sale Id shift 257916',0.00,0.00,0.00,643.60,0.00,'2023-03-05 18:21:52','',''),(2632444,'5','183',NULL,423,'Sale Id shift 257916',2298042.60,0.00,0.00,0.00,0.00,'2023-03-05 18:21:52','',''),(2632445,'5','183','949',423,'Sale Id shift 257917',0.00,0.00,0.00,6301.92,0.00,'2023-03-06 08:52:54','',''),(2632446,'5','183','950',423,'Sale Id shift 257917',0.00,0.00,0.00,7065.85,0.00,'2023-03-06 08:52:54','',''),(2632447,'5','183','950',423,'Sale Id shift 257917',0.00,0.00,0.00,195.07,0.00,'2023-03-06 08:52:54','',''),(2632448,'5','183',NULL,423,'Sale Id shift 257917',2848196.40,0.00,0.00,0.00,0.00,'2023-03-06 08:52:54','',''),(2632449,'5','183','949',423,'Sale Id shift 257918',0.00,0.00,0.00,2944.36,0.00,'2023-03-06 12:29:21','',''),(2632450,'5','183','949',423,'Sale Id shift 257918',0.00,0.00,0.00,5860.04,0.00,'2023-03-06 12:29:21','',''),(2632451,'5','183','950',423,'Sale Id shift 257918',0.00,0.00,0.00,4268.10,0.00,'2023-03-06 12:29:21','',''),(2632452,'5','183','950',423,'Sale Id shift 257918',0.00,0.00,0.00,185.71,0.00,'2023-03-06 12:29:21','',''),(2632453,'5','183',NULL,423,'Sale Id shift 257918',2784224.10,0.00,0.00,0.00,0.00,'2023-03-06 12:29:21','',''),(2632454,'5','183',NULL,423,'Reception corrector for bridging 132008',0.00,0.00,0.00,11550.00,0.00,'2023-03-06 22:42:27','',''),(2632455,'5','183','949',423,'Received from bridging 132008',0.00,0.00,11550.00,0.00,0.00,'2023-03-06 22:42:27','',''),(2632456,'5','183','949',423,'Sale Id shift 257919',0.00,0.00,0.00,5756.91,0.00,'2023-03-07 09:15:44','',''),(2632457,'5','183','949',423,'Sale Id shift 257919',0.00,0.00,0.00,6511.49,0.00,'2023-03-07 09:15:44','',''),(2632458,'5','183','950',423,'Sale Id shift 257919',0.00,0.00,0.00,1271.43,0.00,'2023-03-07 09:15:44','',''),(2632459,'5','183',NULL,423,'Sale Id shift 257919',2843364.30,0.00,0.00,0.00,0.00,'2023-03-07 09:15:44','',''),(2632460,'5','183','949',423,'Sale Id shift 257920',0.00,0.00,0.00,1573.30,0.00,'2023-03-08 09:27:23','',''),(2632461,'5','183','950',423,'Sale Id shift 257920',0.00,0.00,0.00,4695.74,0.00,'2023-03-08 09:27:23','',''),(2632462,'5','183',NULL,423,'Sale Id shift 257920',1316498.40,0.00,0.00,0.00,0.00,'2023-03-08 09:27:23','',''),(2632463,'5','183',NULL,423,'Purchased from SALBAS OIL AND GAS NIG LIMITED',0.00,8379000.00,39900.00,0.00,0.00,'2023-03-08 21:03:56','',''),(2632464,'5','183',NULL,423,'Reception corrector for bridging 132009',0.00,0.00,0.00,26500.00,0.00,'2023-03-09 06:35:54','',''),(2632465,'5','183','949',423,'Received from bridging 132009',0.00,0.00,26500.00,0.00,0.00,'2023-03-09 06:35:54','',''),(2632466,'5','183',NULL,423,'Reception corrector for bridging 132010',0.00,0.00,0.00,13400.00,0.00,'2023-03-09 06:36:05','',''),(2632467,'5','183','950',423,'Received from bridging 132010',0.00,0.00,13400.00,0.00,0.00,'2023-03-09 06:36:05','',''),(2632468,'5','183','949',423,'Sale Id shift 257921',0.00,0.00,0.00,7419.09,0.00,'2023-03-09 09:34:47','',''),(2632469,'5','183','949',423,'Sale Id shift 257921',0.00,0.00,0.00,5804.34,0.00,'2023-03-09 09:34:47','',''),(2632470,'5','183','950',423,'Sale Id shift 257921',0.00,0.00,0.00,1004.37,0.00,'2023-03-09 09:34:47','',''),(2632471,'5','183',NULL,423,'Sale Id shift 257921',2987838.00,0.00,0.00,0.00,0.00,'2023-03-09 09:34:47','',''),(2632472,'5','183','949',423,'Sale Id shift 257922',0.00,0.00,0.00,4055.92,0.00,'2023-03-10 09:44:38','',''),(2632473,'5','183','949',423,'Sale Id shift 257922',0.00,0.00,0.00,9003.42,0.00,'2023-03-10 09:44:38','',''),(2632474,'5','183','950',423,'Sale Id shift 257922',0.00,0.00,0.00,1445.63,0.00,'2023-03-10 09:44:38','',''),(2632475,'5','183',NULL,423,'Sale Id shift 257922',3046043.70,0.00,0.00,0.00,0.00,'2023-03-10 09:44:38','',''),(2632476,'5','183','950',423,'Sale Id shift 257923',0.00,0.00,0.00,11013.27,0.00,'2023-03-12 12:57:44','',''),(2632477,'5','183',NULL,423,'Sale Id shift 257923',2312786.70,0.00,0.00,0.00,0.00,'2023-03-12 12:57:44','',''),(2632478,'5','183','950',423,'Sale Id shift 257924',0.00,0.00,0.00,2104.33,0.00,'2023-03-13 09:24:02','',''),(2632479,'5','183',NULL,423,'Sale Id shift 257924',441909.30,0.00,0.00,0.00,0.00,'2023-03-13 09:24:02','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','183',425,0.00,'2023-03-19 06:44:15'),(2,'5','183',424,40650.00,'2023-03-19 06:44:15'),(3,'5','183',423,36699.60,'2023-03-19 06:44:15');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1819969 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1337546,'5','183',423,'Sale Id shift 232977',0.00,954348.48,162.00,954348.48,0.00,'2021-10-21 06:40:42'),(1338423,'5','183',423,'Sale Id shift 233176',0.00,1124053.20,162.00,1124053.20,0.00,'2021-10-21 09:17:55'),(1338494,'5','183',423,'Sale Id shift 233186',0.00,1054296.00,162.00,1054296.00,0.00,'2021-10-21 09:28:29'),(1338649,'5','183',423,'Sale Id shift 233191',0.00,985606.38,162.00,985606.38,0.00,'2021-10-21 10:00:06'),(1338746,'5','183',423,'Sale Id shift 233206',0.00,1026103.14,162.00,1026103.14,0.00,'2021-10-21 10:20:41'),(1338771,'5','183',423,'Sale Id shift 233212',0.00,990327.06,162.00,990327.06,0.00,'2021-10-21 10:28:29'),(1338845,'5','183',423,'Sale Id shift 233219',0.00,1100992.50,162.00,1100992.50,0.00,'2021-10-21 10:48:01'),(1338883,'5','183',423,'Sale Id shift 233222',0.00,1118752.56,162.00,1118752.56,0.00,'2021-10-21 10:55:29'),(1339075,'5','183',423,'Sale Id shift 233227',0.00,1120809.96,162.00,1120809.96,0.00,'2021-10-21 11:39:23'),(1341713,'5','183',423,'Sale Id shift 233370',0.00,1112337.36,162.00,1112337.36,0.00,'2021-10-22 08:49:15'),(1348277,'5','183',423,'Sale Id shift 233615',0.00,815778.54,162.00,815778.54,0.00,'2021-10-24 06:48:59'),(1353322,'5','183',423,'Sale Id shift 234164',0.00,869735.88,162.00,869735.88,0.00,'2021-10-25 13:16:10'),(1354776,'5','183',423,'Sale Id shift 234307',0.00,1157441.40,162.00,1157441.40,0.00,'2021-10-26 06:12:41'),(1358488,'5','183',423,'Sale Id shift 234561',0.00,125817.30,162.00,125817.30,0.00,'2021-10-27 07:27:01'),(1371702,'5','183',423,'Sale Id shift 235493',0.00,789510.15,165.00,789510.15,0.00,'2021-10-31 08:49:32'),(1373956,'5','183',423,'Sale Id shift 235725',0.00,1239965.10,165.00,1239965.10,0.00,'2021-11-01 04:40:52'),(1379098,'5','183',423,'Sale Id shift 235935',0.00,168943.50,165.00,168943.50,0.00,'2021-11-03 04:59:08'),(1382667,'5','183',423,'Sale Id shift 236229',0.00,690619.05,165.00,690619.05,0.00,'2021-11-03 17:53:16'),(1382943,'5','183',423,'Sale Id shift 236481',0.00,1270369.65,165.00,1270369.65,0.00,'2021-11-04 06:30:46'),(1391323,'5','183',423,'Sale Id shift 236727',0.00,1116361.95,165.00,1116361.95,0.00,'2021-11-05 15:13:04'),(1398164,'5','183',423,'Sale Id shift 237020',0.00,966207.00,165.00,966207.00,0.00,'2021-11-07 07:10:34'),(1406473,'5','183',423,'Sale Id shift 237420',0.00,300243.90,165.00,300243.90,0.00,'2021-11-08 21:42:51'),(1417496,'5','183',423,'Sale Id shift 237938',0.00,1251572.85,165.00,1251572.85,0.00,'2021-11-11 09:43:48'),(1422185,'5','183',423,'Sale Id shift 238211',0.00,1180017.30,165.00,1180017.30,0.00,'2021-11-12 08:18:58'),(1425914,'5','183',423,'Sale Id shift 238428',0.00,1654002.90,165.00,1654002.90,0.00,'2021-11-13 05:54:27'),(1434228,'5','183',423,'Sale Id shift 238727',0.00,1650070.95,165.00,1650070.95,0.00,'2021-11-14 15:24:04'),(1435605,'5','183',423,'Sale Id shift 239031',0.00,1876328.85,165.00,1876328.85,0.00,'2021-11-15 07:24:33'),(1440068,'5','183',423,'Sale Id shift 239144',0.00,2810281.65,165.00,2810281.65,0.00,'2021-11-16 08:09:20'),(1446122,'5','183',423,'Sale Id shift 239353',0.00,1638139.80,165.00,1638139.80,0.00,'2021-11-17 14:43:42'),(1447546,'5','183',423,'Sale Id shift 239678',0.00,1387407.45,165.00,1387407.45,0.00,'2021-11-18 06:25:13'),(1452455,'5','183',423,'Sale Id shift 239922',0.00,951711.75,165.00,951711.75,0.00,'2021-11-19 07:54:04'),(1456131,'5','183',423,'Sale Id shift 240073',0.00,756160.35,165.00,756160.35,0.00,'2021-11-20 06:38:33'),(1461341,'5','183',423,'Sale Id shift 240218',0.00,824955.45,165.00,824955.45,0.00,'2021-11-21 07:23:04'),(1465781,'5','183',423,'Sale Id shift 240675',0.00,888026.70,165.00,888026.70,0.00,'2021-11-22 06:20:49'),(1470569,'5','183',423,'Sale Id shift 240781',0.00,933687.15,165.00,933687.15,0.00,'2021-11-23 06:28:43'),(1475438,'5','183',423,'Sale Id shift 241039',0.00,1125219.15,165.00,1125219.15,0.00,'2021-11-24 07:03:09'),(1479944,'5','183',423,'Sale Id shift 241510',0.00,1038795.45,165.00,1038795.45,0.00,'2021-11-25 08:20:41'),(1484742,'5','183',423,'Sale Id shift 241735',0.00,1755235.35,165.00,1755235.35,0.00,'2021-11-26 09:46:02'),(1488556,'5','183',423,'Sale Id shift 241844',0.00,1079834.25,165.00,1079834.25,0.00,'2021-11-27 08:38:55'),(1493057,'5','183',423,'Sale Id shift 242124',0.00,849037.20,165.00,849037.20,0.00,'2021-11-28 07:31:49'),(1497634,'5','183',423,'Sale Id shift 242398',0.00,240835.65,165.00,240835.65,0.00,'2021-11-29 06:49:49'),(1511670,'5','183',423,'Sale Id shift 242832',0.00,385410.30,165.00,385410.30,0.00,'2021-12-01 20:01:31'),(1514313,'5','183',423,'Sale Id shift 243124',0.00,928022.70,165.00,928022.70,0.00,'2021-12-02 11:32:23'),(1527276,'5','183',423,'Sale Id shift 243239',0.00,1410317.70,165.00,1410317.70,0.00,'2021-12-04 17:38:39'),(1532957,'5','183',423,'Sale Id shift 243803',0.00,987320.40,165.00,987320.40,0.00,'2021-12-06 07:32:23'),(1536946,'5','183',423,'Sale Id shift 244159',0.00,1587341.25,165.00,1587341.25,0.00,'2021-12-06 16:04:00'),(1537168,'5','183',423,'Sale Id shift 244208',0.00,1373494.65,165.00,1373494.65,0.00,'2021-12-06 16:31:39'),(1538394,'5','183',423,'Sale Id shift 244237',0.00,1451316.90,165.00,1451316.90,0.00,'2021-12-07 07:28:15'),(1543127,'5','183',423,'Sale Id shift 244370',0.00,980123.10,165.00,980123.10,0.00,'2021-12-08 07:07:48'),(1552673,'5','183',423,'Sale Id shift 244652',0.00,837238.05,165.00,837238.05,0.00,'2021-12-09 18:17:47'),(1554215,'5','183',423,'Sale Id shift 245007',0.00,1134676.95,165.00,1134676.95,0.00,'2021-12-10 09:23:23'),(1563140,'5','183',423,'Sale Id shift 245151',0.00,850241.70,165.00,850241.70,0.00,'2021-12-11 20:38:42'),(1564031,'5','183',423,'Sale Id shift 245437',0.00,303519.15,165.00,303519.15,0.00,'2021-12-12 08:42:11'),(1574732,'5','183',423,'Sale Id shift 245918',0.00,278655.30,165.00,278655.30,0.00,'2021-12-14 08:38:47'),(1579734,'5','183',423,'Sale Id shift 246058',0.00,909115.35,165.00,909115.35,0.00,'2021-12-15 09:03:50'),(1584368,'5','183',423,'Sale Id shift 246364',0.00,882700.50,165.00,882700.50,0.00,'2021-12-16 08:38:21'),(1589823,'5','183',423,'Sale Id shift 246586',0.00,938572.80,165.00,938572.80,0.00,'2021-12-17 09:12:07'),(1593876,'5','183',423,'Sale Id shift 246949',0.00,1048220.25,165.00,1048220.25,0.00,'2021-12-18 06:54:15'),(1604502,'5','183',423,'Sale Id shift 247067',0.00,1093544.10,165.00,1093544.10,0.00,'2021-12-19 17:34:32'),(1609898,'5','183',423,'Sale Id shift 247369',0.00,1486468.50,165.00,1486468.50,0.00,'2021-12-20 18:05:20'),(1613652,'5','183',423,'Sale Id shift 247686',0.00,733144.50,165.00,733144.50,0.00,'2021-12-21 14:55:18'),(1617172,'5','183',423,'Sale Id shift 247909',0.00,728496.45,165.00,728496.45,0.00,'2021-12-22 09:54:57'),(1621039,'5','183',423,'Sale Id shift 248159',0.00,597852.75,165.00,597852.75,0.00,'2021-12-23 06:28:09'),(1630729,'5','183',423,'Sale Id shift 248298',0.00,232673.10,165.00,232673.10,0.00,'2021-12-24 14:09:28'),(1638173,'5','183',423,'Sale Id shift 248630',0.00,725566.05,165.00,725566.05,0.00,'2021-12-26 07:26:32'),(1641845,'5','183',423,'Sale Id shift 248991',0.00,1025319.90,165.00,1025319.90,0.00,'2021-12-27 05:58:56'),(1647500,'5','183',423,'Sale Id shift 249120',0.00,943215.90,165.00,943215.90,0.00,'2021-12-28 09:22:25'),(1651452,'5','183',423,'Sale Id shift 249432',0.00,1000589.70,165.00,1000589.70,0.00,'2021-12-29 06:59:19'),(1656046,'5','183',423,'Sale Id shift 249666',0.00,647578.80,165.00,647578.80,0.00,'2021-12-30 06:46:16'),(1662690,'5','183',423,'Sale Id shift 249922',0.00,250611.90,165.00,250611.90,0.00,'2021-12-31 09:25:58'),(1666955,'5','183',423,'Sale Id shift 250238',0.00,406032.00,165.00,406032.00,0.00,'2022-01-01 07:42:42'),(1671909,'5','183',423,'Sale Id shift 250495',0.00,1187036.40,165.00,1187036.40,0.00,'2022-01-02 08:07:28'),(1675921,'5','183',423,'Sale Id shift 250774',0.00,1280708.55,165.00,1280708.55,0.00,'2022-01-03 06:58:54'),(1681949,'5','183',423,'Sale Id shift 251051',0.00,1272095.55,165.00,1272095.55,0.00,'2022-01-04 08:40:52'),(1692727,'5','183',423,'Sale Id shift 251122',0.00,1596346.95,165.00,1596346.95,0.00,'2022-01-06 09:25:20'),(1719150,'5','183',423,'Sale Id shift 251763',0.00,1540039.05,165.00,1540039.05,0.00,'2022-01-11 08:20:10'),(1721016,'5','183',423,'Sale Id shift 252813',0.00,1371004.80,165.00,1371004.80,0.00,'2022-01-11 12:45:45'),(1721491,'5','183',423,'Sale Id shift 252832',0.00,1061654.55,165.00,1061654.55,0.00,'2022-01-11 13:58:09'),(1721535,'5','183',423,'Sale Id shift 252840',0.00,1064276.40,165.00,1064276.40,0.00,'2022-01-11 14:05:51'),(1721627,'5','183',423,'Sale Id shift 252844',0.00,974846.40,165.00,974846.40,0.00,'2022-01-11 14:20:11'),(1721757,'5','183',423,'Sale Id shift 252853',0.00,797680.95,165.00,797680.95,0.00,'2022-01-11 14:34:54'),(1721851,'5','183',423,'Sale Id shift 252860',0.00,515882.40,165.00,515882.40,0.00,'2022-01-11 14:48:54'),(1724114,'5','183',423,'Sale Id shift 252864',0.00,169862.55,165.00,169862.55,0.00,'2022-01-12 08:14:10'),(1739744,'5','183',423,'Sale Id shift 253638',0.00,1114010.70,165.00,1114010.70,0.00,'2022-01-15 09:08:23'),(1744948,'5','183',423,'Sale Id shift 253872',0.00,1200495.45,165.00,1200495.45,0.00,'2022-01-16 06:54:51'),(1750143,'5','183',423,'Sale Id shift 254079',0.00,1042461.75,165.00,1042461.75,0.00,'2022-01-17 08:29:13'),(1755439,'5','183',423,'Sale Id shift 254244',0.00,1281215.10,165.00,1281215.10,0.00,'2022-01-18 07:07:50'),(1761953,'5','183',423,'Sale Id shift 254482',0.00,840480.30,165.00,840480.30,0.00,'2022-01-19 08:50:47'),(1767518,'5','183',423,'Sale Id shift 254933',0.00,428780.55,165.00,428780.55,0.00,'2022-01-20 06:35:02'),(1775640,'5','183',423,'Sale Id shift 255018',0.00,446419.05,165.00,446419.05,0.00,'2022-01-21 11:16:36'),(1780435,'5','183',423,'Sale Id shift 255340',0.00,190210.35,165.00,190210.35,0.00,'2022-01-22 09:18:13'),(1791415,'5','183',423,'Sale Id shift 255888',0.00,1010248.80,165.00,1010248.80,0.00,'2022-01-24 08:22:09'),(1796966,'5','183',423,'Sale Id shift 256143',0.00,1272635.10,165.00,1272635.10,0.00,'2022-01-25 08:24:15'),(1803705,'5','183',423,'Sale Id shift 256359',0.00,1119290.70,165.00,1119290.70,0.00,'2022-01-26 10:07:29'),(1807374,'5','183',423,'Sale Id shift 256559',0.00,1181581.50,165.00,1181581.50,0.00,'2022-01-27 07:07:53'),(1813544,'5','183',423,'Sale Id shift 256801',0.00,915989.25,165.00,915989.25,0.00,'2022-01-28 06:37:32'),(1819691,'5','183',423,'Sale Id shift 257012',0.00,551302.95,165.00,551302.95,0.00,'2022-01-29 07:13:39'),(1819692,'5','183',423,'Sale Id shift 257524',0.00,525171.90,165.00,525171.90,0.00,'2022-01-31 11:25:35'),(1819693,'5','183',423,'Sale Id shift 257526',0.00,384715.65,165.00,384715.65,0.00,'2022-02-02 19:54:57'),(1819694,'5','183',423,'Sale Id shift 257527',0.00,1485066.00,165.00,1485066.00,0.00,'2022-02-03 07:55:36'),(1819695,'5','183',423,'Sale Id shift 257528',0.00,1186519.95,165.00,1186519.95,0.00,'2022-02-04 07:29:42'),(1819696,'5','183',423,'Sale Id shift 257529',0.00,1078974.60,165.00,1078974.60,0.00,'2022-02-05 07:36:37'),(1819697,'5','183',423,'Sale Id shift 257530',0.00,784654.20,165.00,784654.20,0.00,'2022-02-06 09:32:00'),(1819698,'5','183',423,'Sale Id shift 257531',0.00,711229.20,165.00,711229.20,0.00,'2022-02-07 09:50:17'),(1819699,'5','183',423,'Sale Id shift 257532',0.00,544143.60,165.00,544143.60,0.00,'2022-02-08 07:16:56'),(1819700,'5','183',423,'Sale Id shift 257533',0.00,370591.65,165.00,370591.65,0.00,'2022-02-09 07:21:37'),(1819701,'5','183',423,'Sale Id shift 257540',0.00,274909.80,165.00,274909.80,0.00,'2022-02-17 21:04:58'),(1819702,'5','183',423,'Sale Id shift 257541',0.00,1297157.40,165.00,1297157.40,0.00,'2022-02-19 07:18:13'),(1819703,'5','183',423,'Sale Id shift 257542',0.00,1248320.70,165.00,1248320.70,0.00,'2022-02-19 21:53:09'),(1819704,'5','183',423,'Sale Id shift 257543',0.00,932720.25,165.00,932720.25,0.00,'2022-02-20 12:24:18'),(1819705,'5','183',423,'Sale Id shift 257544',0.00,1176761.85,165.00,1176761.85,0.00,'2022-02-21 08:41:59'),(1819706,'5','183',423,'Sale Id shift 257545',0.00,981525.60,165.00,981525.60,0.00,'2022-02-22 07:47:17'),(1819707,'5','183',423,'Sale Id shift 257546',0.00,944281.80,165.00,944281.80,0.00,'2022-02-23 07:11:24'),(1819708,'5','183',423,'Sale Id shift 257547',0.00,472701.90,165.00,472701.90,0.00,'2022-02-24 07:57:41'),(1819709,'5','183',423,'Sale Id shift 257548',0.00,1416221.40,165.00,1416221.40,0.00,'2022-02-27 09:11:22'),(1819710,'5','183',423,'Sale Id shift 257549',0.00,1458253.50,165.00,1458253.50,0.00,'2022-02-27 15:52:04'),(1819711,'5','183',423,'Sale Id shift 257550',0.00,1236361.50,165.00,1236361.50,0.00,'2022-02-27 16:41:57'),(1819712,'5','183',423,'Sale Id shift 257551',0.00,1153213.05,165.00,1153213.05,0.00,'2022-02-28 08:12:53'),(1819713,'5','183',423,'Sale Id shift 257552',0.00,1776325.65,165.00,1776325.65,0.00,'2022-03-02 09:40:20'),(1819714,'5','183',423,'Sale Id shift 257553',0.00,1027999.50,165.00,1027999.50,0.00,'2022-03-02 10:01:26'),(1819715,'5','183',423,'Sale Id shift 257554',0.00,575977.05,165.00,575977.05,0.00,'2022-03-03 08:07:32'),(1819716,'5','183',423,'Sale Id shift 257555',0.00,460315.35,165.00,460315.35,0.00,'2022-03-04 10:02:45'),(1819717,'5','183',423,'Sale Id shift 257556',0.00,1428796.05,165.00,1428796.05,0.00,'2022-03-05 19:31:14'),(1819718,'5','183',423,'Sale Id shift 257557',0.00,1978321.95,165.00,1978321.95,0.00,'2022-03-06 08:54:32'),(1819719,'5','183',423,'Sale Id shift 257558',0.00,1132680.45,165.00,1132680.45,0.00,'2022-03-07 20:08:44'),(1819720,'5','183',423,'Sale Id shift 257559',0.00,1391309.70,165.00,1391309.70,0.00,'2022-03-08 12:19:41'),(1819721,'5','183',423,'Sale Id shift 257560',0.00,894537.60,165.00,894537.60,0.00,'2022-03-09 07:50:57'),(1819722,'5','183',423,'Sale Id shift 257561',0.00,990379.50,165.00,990379.50,0.00,'2022-03-10 07:39:25'),(1819723,'5','183',423,'Sale Id shift 257562',0.00,1200241.35,165.00,1200241.35,0.00,'2022-03-11 08:54:30'),(1819724,'5','183',423,'Sale Id shift 257564',0.00,1726342.20,165.00,1726342.20,0.00,'2022-03-14 06:04:56'),(1819725,'5','183',423,'Sale Id shift 257565',0.00,1217313.90,165.00,1217313.90,0.00,'2022-03-15 05:58:31'),(1819726,'5','183',423,'Sale Id shift 257566',0.00,1757467.80,165.00,1757467.80,0.00,'2022-03-15 12:01:13'),(1819727,'5','183',423,'Sale Id shift 257567',0.00,1510428.15,165.00,1510428.15,0.00,'2022-03-16 08:12:44'),(1819728,'5','183',423,'Sale Id shift 257568',0.00,1622984.55,165.00,1622984.55,0.00,'2022-03-18 07:36:54'),(1819729,'5','183',423,'Sale Id shift 257569',0.00,1808375.25,165.00,1808375.25,0.00,'2022-03-19 07:06:00'),(1819730,'5','183',423,'Sale Id shift 257570',0.00,773628.90,165.00,773628.90,0.00,'2022-03-19 08:23:16'),(1819731,'5','183',423,'Sale Id shift 257571',0.00,1032916.50,165.00,1032916.50,0.00,'2022-03-20 08:37:41'),(1819732,'5','183',423,'Sale Id shift 257572',0.00,1015007.40,165.00,1015007.40,0.00,'2022-03-21 08:41:03'),(1819733,'5','183',423,'Sale Id shift 257573',0.00,427605.75,165.00,427605.75,0.00,'2022-03-22 08:25:52'),(1819734,'5','183',423,'Sale Id shift 257574',0.00,341421.30,165.00,341421.30,0.00,'2022-03-23 07:53:19'),(1819735,'5','183',423,'Sale Id shift 257575',0.00,215290.35,165.00,215290.35,0.00,'2022-03-24 07:58:32'),(1819736,'5','183',423,'Sale Id shift 257576',0.00,1256443.65,165.00,1256443.65,0.00,'2022-03-25 09:47:58'),(1819737,'5','183',423,'Sale Id shift 257577',0.00,1122211.20,165.00,1122211.20,0.00,'2022-03-27 07:54:49'),(1819738,'5','183',423,'Sale Id shift 257578',0.00,844484.85,165.00,844484.85,0.00,'2022-03-28 07:56:22'),(1819739,'5','183',423,'Sale Id shift 257579',0.00,1083111.15,165.00,1083111.15,0.00,'2022-03-29 07:52:01'),(1819740,'5','183',423,'Sale Id shift 257580',0.00,1081274.70,165.00,1081274.70,0.00,'2022-03-30 06:36:06'),(1819741,'5','183',423,'Sale Id shift 257581',0.00,1074739.05,165.00,1074739.05,0.00,'2022-03-30 10:56:30'),(1819742,'5','183',423,'Sale Id shift 257582',0.00,414239.10,165.00,414239.10,0.00,'2022-03-31 11:27:19'),(1819743,'5','183',423,'Sale Id shift 257583',0.00,249999.75,165.00,249999.75,0.00,'2022-04-01 10:03:12'),(1819744,'5','183',423,'Sale Id shift 257585',0.00,185380.80,165.00,185380.80,0.00,'2022-04-04 07:44:20'),(1819745,'5','183',423,'Sale Id shift 257586',0.00,1328286.30,165.00,1328286.30,0.00,'2022-04-04 11:30:21'),(1819746,'5','183',423,'Sale Id shift 257587',0.00,1124090.55,165.00,1124090.55,0.00,'2022-04-05 09:03:04'),(1819747,'5','183',423,'Sale Id shift 257588',0.00,1022732.70,165.00,1022732.70,0.00,'2022-04-06 08:19:45'),(1819748,'5','183',423,'Sale Id shift 257589',0.00,958494.90,165.00,958494.90,0.00,'2022-04-07 07:47:50'),(1819749,'5','183',423,'Sale Id shift 257590',0.00,1381906.35,165.00,1381906.35,0.00,'2022-04-08 07:51:25'),(1819750,'5','183',423,'Sale Id shift 257591',0.00,1129113.15,165.00,1129113.15,0.00,'2022-04-09 09:33:49'),(1819751,'5','183',423,'Sale Id shift 257592',0.00,1314612.75,165.00,1314612.75,0.00,'2022-04-10 08:08:39'),(1819752,'5','183',423,'Sale Id shift 257593',0.00,1569389.25,165.00,1569389.25,0.00,'2022-04-11 03:57:27'),(1819753,'5','183',423,'Sale Id shift 257594',0.00,1479960.90,165.00,1479960.90,0.00,'2022-04-12 12:46:05'),(1819754,'5','183',423,'Sale Id shift 257595',0.00,1718831.40,165.00,1718831.40,0.00,'2022-04-13 07:52:04'),(1819755,'5','183',423,'Sale Id shift 257596',0.00,1482935.85,165.00,1482935.85,0.00,'2022-04-14 08:42:18'),(1819756,'5','183',423,'Sale Id shift 257597',0.00,1481388.15,165.00,1481388.15,0.00,'2022-04-15 09:01:37'),(1819757,'5','183',423,'Sale Id shift 257598',0.00,942323.25,165.00,942323.25,0.00,'2022-04-16 09:21:54'),(1819758,'5','183',423,'Sale Id shift 257599',0.00,760036.20,165.00,760036.20,0.00,'2022-04-17 09:54:00'),(1819759,'5','183',423,'Sale Id shift 257600',0.00,1086998.55,165.00,1086998.55,0.00,'2022-04-18 13:53:58'),(1819760,'5','183',423,'Sale Id shift 257601',0.00,1009818.15,165.00,1009818.15,0.00,'2022-04-19 07:27:04'),(1819761,'5','183',423,'Sale Id shift 257602',0.00,1036993.65,165.00,1036993.65,0.00,'2022-04-20 07:58:55'),(1819762,'5','183',423,'Sale Id shift 257603',0.00,896136.45,165.00,896136.45,0.00,'2022-04-21 07:41:11'),(1819763,'5','183',423,'Sale Id shift 257604',0.00,775534.65,165.00,775534.65,0.00,'2022-04-22 08:08:11'),(1819764,'5','183',423,'Sale Id shift 257605',0.00,363569.25,165.00,363569.25,0.00,'2022-04-23 08:32:16'),(1819765,'5','183',423,'Sale Id shift 257606',0.00,883909.95,165.00,883909.95,0.00,'2022-04-24 03:07:50'),(1819766,'5','183',423,'Sale Id shift 257607',0.00,733301.25,165.00,733301.25,0.00,'2022-04-25 08:44:04'),(1819767,'5','183',423,'Sale Id shift 257608',0.00,875859.60,165.00,875859.60,0.00,'2022-04-26 08:30:53'),(1819768,'5','183',423,'Sale Id shift 257609',0.00,251268.60,165.00,251268.60,0.00,'2022-04-27 08:09:37'),(1819769,'5','183',423,'Sale Id shift 257612',0.00,1011032.55,165.00,1011032.55,0.00,'2022-05-09 15:26:58'),(1819770,'5','183',423,'Sale Id shift 257613',0.00,1044410.40,165.00,1044410.40,0.00,'2022-05-09 15:59:08'),(1819771,'5','183',423,'Sale Id shift 257614',0.00,1295989.20,165.00,1295989.20,0.00,'2022-05-09 19:34:33'),(1819772,'5','183',423,'Sale Id shift 257615',0.00,746318.10,165.00,746318.10,0.00,'2022-05-09 19:46:27'),(1819773,'5','183',423,'Sale Id shift 257616',0.00,1433336.85,165.00,1433336.85,0.00,'2022-05-09 19:55:49'),(1819774,'5','183',423,'Sale Id shift 257617',0.00,684487.65,165.00,684487.65,0.00,'2022-05-09 21:36:16'),(1819775,'5','183',423,'Sale Id shift 257618',0.00,1065530.40,165.00,1065530.40,0.00,'2022-05-09 21:42:26'),(1819776,'5','183',423,'Sale Id shift 257619',0.00,770492.25,165.00,770492.25,0.00,'2022-05-09 21:48:12'),(1819777,'5','183',423,'Sale Id shift 257620',0.00,659793.75,165.00,659793.75,0.00,'2022-05-09 21:56:05'),(1819778,'5','183',423,'Sale Id shift 257621',0.00,298364.55,165.00,298364.55,0.00,'2022-05-09 22:07:06'),(1819779,'5','183',423,'Sale Id shift 257622',0.00,165848.10,165.00,165848.10,0.00,'2022-05-10 06:48:22'),(1819780,'5','183',423,'Sale Id shift 257625',0.00,738675.30,165.00,738675.30,0.00,'2022-05-13 08:15:52'),(1819781,'5','183',423,'Sale Id shift 257626',0.00,607584.45,165.00,607584.45,0.00,'2022-05-14 06:47:06'),(1819782,'5','183',423,'Sale Id shift 257627',0.00,763430.25,165.00,763430.25,0.00,'2022-05-15 06:08:20'),(1819783,'5','183',423,'Sale Id shift 257628',0.00,883644.30,165.00,883644.30,0.00,'2022-05-16 06:10:19'),(1819784,'5','183',423,'Sale Id shift 257629',0.00,966596.40,165.00,966596.40,0.00,'2022-05-17 06:04:36'),(1819785,'5','183',423,'Sale Id shift 257630',0.00,986610.90,165.00,986610.90,0.00,'2022-05-18 05:19:41'),(1819786,'5','183',423,'Sale Id shift 257631',0.00,932533.80,165.00,932533.80,0.00,'2022-05-19 05:34:37'),(1819787,'5','183',423,'Sale Id shift 257632',0.00,987665.25,165.00,987665.25,0.00,'2022-05-20 07:15:15'),(1819788,'5','183',423,'Sale Id shift 257633',0.00,826324.95,165.00,826324.95,0.00,'2022-05-21 07:59:07'),(1819789,'5','183',423,'Sale Id shift 257634',0.00,941343.15,165.00,941343.15,0.00,'2022-05-22 08:09:32'),(1819790,'5','183',423,'Sale Id shift 257635',0.00,1033751.40,165.00,1033751.40,0.00,'2022-05-23 05:15:22'),(1819791,'5','183',423,'Sale Id shift 257636',0.00,959757.15,165.00,959757.15,0.00,'2022-05-24 07:59:02'),(1819792,'5','183',423,'Sale Id shift 257637',0.00,1005473.70,165.00,1005473.70,0.00,'2022-05-25 06:07:24'),(1819793,'5','183',423,'Sale Id shift 257638',0.00,1020221.40,165.00,1020221.40,0.00,'2022-05-26 07:42:16'),(1819794,'5','183',423,'Sale Id shift 257639',0.00,901310.85,165.00,901310.85,0.00,'2022-05-28 04:56:54'),(1819795,'5','183',423,'Sale Id shift 257640',0.00,945700.80,165.00,945700.80,0.00,'2022-05-29 08:14:08'),(1819796,'5','183',423,'Sale Id shift 257641',0.00,829648.05,165.00,829648.05,0.00,'2022-05-29 21:36:15'),(1819797,'5','183',423,'Sale Id shift 257642',0.00,727963.50,165.00,727963.50,0.00,'2022-05-30 05:58:31'),(1819798,'5','183',423,'Sale Id shift 257643',0.00,934819.05,165.00,934819.05,0.00,'2022-05-31 00:18:53'),(1819799,'5','183',423,'Sale Id shift 257644',0.00,1004833.50,165.00,1004833.50,0.00,'2022-06-01 07:02:25'),(1819800,'5','183',423,'Sale Id shift 257645',0.00,925676.40,165.00,925676.40,0.00,'2022-06-02 05:59:52'),(1819801,'5','183',423,'Sale Id shift 257646',0.00,720289.35,165.00,720289.35,0.00,'2022-06-03 06:43:00'),(1819802,'5','183',423,'Sale Id shift 257647',0.00,643090.80,165.00,643090.80,0.00,'2022-06-04 06:04:02'),(1819803,'5','183',423,'Sale Id shift 257648',0.00,511726.05,165.00,511726.05,0.00,'2022-06-05 08:12:01'),(1819804,'5','183',423,'Sale Id shift 257649',0.00,931692.30,165.00,931692.30,0.00,'2022-06-06 06:24:49'),(1819805,'5','183',423,'Sale Id shift 257650',0.00,867834.00,165.00,867834.00,0.00,'2022-06-07 07:24:14'),(1819806,'5','183',423,'Sale Id shift 257651',0.00,576551.25,165.00,576551.25,0.00,'2022-06-08 10:30:08'),(1819807,'5','183',423,'Sale Id shift 257652',0.00,589447.65,165.00,589447.65,0.00,'2022-06-09 08:46:10'),(1819808,'5','183',423,'Sale Id shift 257663',0.00,976390.80,165.00,976390.80,0.00,'2022-06-20 06:44:53'),(1819809,'5','183',423,'Sale Id shift 257664',0.00,846905.40,165.00,846905.40,0.00,'2022-06-21 07:52:54'),(1819810,'5','183',423,'Sale Id shift 257665',0.00,668914.95,165.00,668914.95,0.00,'2022-06-22 07:03:29'),(1819811,'5','183',423,'Sale Id shift 257666',0.00,564742.20,165.00,564742.20,0.00,'2022-06-23 07:03:59'),(1819812,'5','183',423,'Sale Id shift 257667',0.00,839011.80,165.00,839011.80,0.00,'2022-06-24 06:56:45'),(1819813,'5','183',423,'Sale Id shift 257668',0.00,487045.35,165.00,487045.35,0.00,'2022-06-25 06:12:06'),(1819814,'5','183',423,'Sale Id shift 257669',0.00,715111.65,165.00,715111.65,0.00,'2022-06-26 07:13:14'),(1819815,'5','183',423,'Sale Id shift 257670',0.00,526930.80,165.00,526930.80,0.00,'2022-06-27 07:33:28'),(1819816,'5','183',423,'Sale Id shift 257671',0.00,614493.00,165.00,614493.00,0.00,'2022-06-28 07:20:53'),(1819817,'5','183',423,'Sale Id shift 257672',0.00,276153.90,165.00,276153.90,0.00,'2022-06-29 08:00:01'),(1819818,'5','183',423,'Sale Id shift 257680',0.00,706695.00,165.00,706695.00,0.00,'2022-07-07 05:23:18'),(1819819,'5','183',423,'Sale Id shift 257681',0.00,482549.10,165.00,482549.10,0.00,'2022-07-08 06:09:35'),(1819820,'5','183',423,'Sale Id shift 257682',0.00,641950.65,165.00,641950.65,0.00,'2022-07-09 06:36:16'),(1819821,'5','183',423,'Sale Id shift 257683',0.00,620957.70,165.00,620957.70,0.00,'2022-07-10 07:02:10'),(1819822,'5','183',423,'Sale Id shift 257684',0.00,326053.20,165.00,326053.20,0.00,'2022-07-11 06:59:22'),(1819823,'5','183',423,'Sale Id shift 257685',0.00,551653.35,185.00,551653.35,0.00,'2022-07-12 08:21:54'),(1819824,'5','183',423,'Sale Id shift 257686',0.00,601198.20,185.00,601198.20,0.00,'2022-07-13 07:16:25'),(1819825,'5','183',423,'Sale Id shift 257687',0.00,254489.70,185.00,254489.70,0.00,'2022-07-14 06:30:03'),(1819826,'5','183',423,'Sale Id shift 257688',0.00,868364.10,185.00,868364.10,0.00,'2022-07-15 07:42:51'),(1819827,'5','183',423,'Sale Id shift 257689',0.00,982042.90,185.00,982042.90,0.00,'2022-07-16 06:51:25'),(1819828,'5','183',423,'Sale Id shift 257690',0.00,793000.65,185.00,793000.65,0.00,'2022-07-17 08:16:28'),(1819829,'5','183',423,'Sale Id shift 257691',0.00,943377.90,185.00,943377.90,0.00,'2022-07-18 07:31:44'),(1819830,'5','183',423,'Sale Id shift 257692',0.00,842939.55,185.00,842939.55,0.00,'2022-07-19 05:02:02'),(1819831,'5','183',423,'Sale Id shift 257693',0.00,1699546.90,185.00,1699546.90,0.00,'2022-07-20 10:13:20'),(1819832,'5','183',423,'Sale Id shift 257694',0.00,1632813.70,185.00,1632813.70,0.00,'2022-07-21 06:46:53'),(1819833,'5','183',423,'Sale Id shift 257695',0.00,731702.75,185.00,731702.75,0.00,'2022-07-22 07:12:36'),(1819834,'5','183',423,'Sale Id shift 257696',0.00,1998999.00,185.00,1998999.00,0.00,'2022-07-23 06:52:37'),(1819835,'5','183',423,'Sale Id shift 257697',0.00,2216018.80,185.00,2216018.80,0.00,'2022-07-24 08:30:19'),(1819836,'5','183',423,'Sale Id shift 257698',0.00,1501191.75,185.00,1501191.75,0.00,'2022-07-25 06:42:33'),(1819837,'5','183',423,'Sale Id shift 257699',0.00,1432412.45,185.00,1432412.45,0.00,'2022-07-26 05:51:45'),(1819838,'5','183',423,'Sale Id shift 257700',0.00,808046.70,185.00,808046.70,0.00,'2022-07-27 07:31:24'),(1819839,'5','183',423,'Sale Id shift 257701',0.00,925355.20,185.00,925355.20,0.00,'2022-07-28 06:51:40'),(1819840,'5','183',423,'Sale Id shift 257702',0.00,1064356.80,185.00,1064356.80,0.00,'2022-07-29 12:47:53'),(1819841,'5','183',423,'Sale Id shift 257703',0.00,549054.10,185.00,549054.10,0.00,'2022-07-30 09:11:51'),(1819842,'5','183',423,'Sale Id shift 257704',0.00,439843.05,185.00,439843.05,0.00,'2022-07-31 09:27:02'),(1819843,'5','183',423,'Sale Id shift 257707',0.00,1252721.95,185.00,1252721.95,0.00,'2022-08-03 06:55:43'),(1819844,'5','183',423,'Sale Id shift 257708',0.00,1291100.20,185.00,1291100.20,0.00,'2022-08-04 07:24:25'),(1819845,'5','183',423,'Sale Id shift 257709',0.00,671649.90,185.00,671649.90,0.00,'2022-08-05 06:32:37'),(1819846,'5','183',423,'Sale Id shift 257710',0.00,845888.45,185.00,845888.45,0.00,'2022-08-06 07:00:09'),(1819847,'5','183',423,'Sale Id shift 257711',0.00,987137.80,185.00,987137.80,0.00,'2022-08-07 07:23:14'),(1819848,'5','183',423,'Sale Id shift 257712',0.00,614747.60,185.00,614747.60,0.00,'2022-09-05 06:46:25'),(1819849,'5','183',423,'Sale Id shift 257713',0.00,694205.10,185.00,694205.10,0.00,'2022-09-05 14:43:55'),(1819850,'5','183',423,'Sale Id shift 257714',0.00,1095884.50,185.00,1095884.50,0.00,'2022-09-05 16:03:44'),(1819851,'5','183',423,'Sale Id shift 257715',0.00,974953.70,185.00,974953.70,0.00,'2022-09-05 18:01:53'),(1819852,'5','183',423,'Sale Id shift 257716',0.00,989043.30,185.00,989043.30,0.00,'2022-09-06 11:12:10'),(1819853,'5','183',423,'Sale Id shift 257717',0.00,845255.75,185.00,845255.75,0.00,'2022-09-06 11:24:20'),(1819854,'5','183',423,'Sale Id shift 257718',0.00,1048400.55,185.00,1048400.55,0.00,'2022-09-06 11:53:24'),(1819855,'5','183',423,'Sale Id shift 257719',0.00,878002.60,185.00,878002.60,0.00,'2022-09-06 12:12:02'),(1819856,'5','183',423,'Sale Id shift 257720',0.00,506000.90,185.00,506000.90,0.00,'2022-09-06 12:30:36'),(1819857,'5','183',423,'Sale Id shift 257721',0.00,558117.25,185.00,558117.25,0.00,'2022-09-06 13:08:35'),(1819858,'5','183',423,'Sale Id shift 257722',0.00,848583.90,185.00,848583.90,0.00,'2022-09-06 13:40:02'),(1819859,'5','183',423,'Sale Id shift 257723',0.00,843840.50,185.00,843840.50,0.00,'2022-09-06 13:50:00'),(1819860,'5','183',423,'Sale Id shift 257724',0.00,480230.40,185.00,480230.40,0.00,'2022-09-06 14:17:17'),(1819861,'5','183',423,'Sale Id shift 257725',0.00,843873.80,185.00,843873.80,0.00,'2022-09-06 14:34:58'),(1819862,'5','183',423,'Sale Id shift 257726',0.00,1101458.55,185.00,1101458.55,0.00,'2022-09-06 14:45:46'),(1819863,'5','183',423,'Sale Id shift 257727',0.00,892484.40,185.00,892484.40,0.00,'2022-09-06 14:52:53'),(1819864,'5','183',423,'Sale Id shift 257728',0.00,885210.20,185.00,885210.20,0.00,'2022-09-06 15:22:30'),(1819865,'5','183',423,'Sale Id shift 257729',0.00,771738.60,185.00,771738.60,0.00,'2022-09-06 15:40:20'),(1819866,'5','183',423,'Sale Id shift 257730',0.00,616823.30,185.00,616823.30,0.00,'2022-09-06 16:04:25'),(1819867,'5','183',423,'Sale Id shift 257731',0.00,758886.65,185.00,758886.65,0.00,'2022-09-06 16:29:21'),(1819868,'5','183',423,'Sale Id shift 257732',0.00,680622.40,185.00,680622.40,0.00,'2022-09-07 08:20:35'),(1819869,'5','183',423,'Sale Id shift 257733',0.00,583902.55,185.00,583902.55,0.00,'2022-09-07 09:11:59'),(1819870,'5','183',423,'Sale Id shift 257734',0.00,538068.80,185.00,538068.80,0.00,'2022-09-07 09:26:11'),(1819871,'5','183',423,'Sale Id shift 257735',0.00,763559.75,185.00,763559.75,0.00,'2022-09-07 09:45:22'),(1819872,'5','183',423,'Sale Id shift 257736',0.00,644251.40,185.00,644251.40,0.00,'2022-09-07 09:54:26'),(1819873,'5','183',423,'Sale Id shift 257737',0.00,779105.30,185.00,779105.30,0.00,'2022-09-07 10:08:02'),(1819874,'5','183',423,'Sale Id shift 257738',0.00,552826.25,185.00,552826.25,0.00,'2022-09-07 10:18:14'),(1819875,'5','183',423,'Sale Id shift 257739',0.00,704171.05,185.00,704171.05,0.00,'2022-09-07 10:24:40'),(1819876,'5','183',423,'Sale Id shift 257740',0.00,688858.60,185.00,688858.60,0.00,'2022-09-07 10:31:41'),(1819877,'5','183',423,'Sale Id shift 257741',0.00,1079591.55,185.00,1079591.55,0.00,'2022-09-07 10:37:08'),(1819878,'5','183',423,'Sale Id shift 257742',0.00,1089030.25,185.00,1089030.25,0.00,'2022-09-07 10:41:42'),(1819879,'5','183',423,'Sale Id shift 257743',0.00,869783.05,185.00,869783.05,0.00,'2022-09-08 07:08:12'),(1819880,'5','183',423,'Sale Id shift 257744',0.00,664532.95,185.00,664532.95,0.00,'2022-09-09 08:15:14'),(1819881,'5','183',423,'Sale Id shift 257745',0.00,577679.15,185.00,577679.15,0.00,'2022-09-10 13:01:17'),(1819882,'5','183',423,'Sale Id shift 257746',0.00,650280.55,185.00,650280.55,0.00,'2022-09-11 08:53:24'),(1819883,'5','183',423,'Sale Id shift 257747',0.00,239388.15,185.00,239388.15,0.00,'2022-09-12 08:53:04'),(1819884,'5','183',423,'Sale Id shift 257748',0.00,651938.15,185.00,651938.15,0.00,'2022-09-13 09:13:17'),(1819885,'5','183',423,'Sale Id shift 257749',0.00,429514.50,185.00,429514.50,0.00,'2022-09-14 08:10:20'),(1819886,'5','183',423,'Sale Id shift 257750',0.00,724793.00,185.00,724793.00,0.00,'2022-09-15 08:49:38'),(1819887,'5','183',423,'Sale Id shift 257751',0.00,780659.30,185.00,780659.30,0.00,'2022-09-16 09:05:40'),(1819888,'5','183',423,'Sale Id shift 257752',0.00,555838.05,185.00,555838.05,0.00,'2022-09-17 10:11:41'),(1819889,'5','183',423,'Sale Id shift 257753',0.00,623485.15,185.00,623485.15,0.00,'2022-09-18 07:19:08'),(1819890,'5','183',423,'Sale Id shift 257754',0.00,887232.25,185.00,887232.25,0.00,'2022-09-19 07:18:27'),(1819891,'5','183',423,'Sale Id shift 257755',0.00,681373.50,185.00,681373.50,0.00,'2022-09-20 08:31:26'),(1819892,'5','183',423,'Sale Id shift 257756',0.00,633983.90,185.00,633983.90,0.00,'2022-09-21 11:48:42'),(1819893,'5','183',423,'Sale Id shift 257757',0.00,599070.70,185.00,599070.70,0.00,'2022-09-22 07:37:35'),(1819894,'5','183',423,'Sale Id shift 257758',0.00,791224.65,185.00,791224.65,0.00,'2022-09-23 07:46:01'),(1819895,'5','183',423,'Sale Id shift 257759',0.00,671620.30,185.00,671620.30,0.00,'2022-09-24 08:28:33'),(1819896,'5','183',423,'Sale Id shift 257760',0.00,515028.90,185.00,515028.90,0.00,'2022-09-25 08:02:19'),(1819897,'5','183',423,'Sale Id shift 257761',0.00,1255526.55,185.00,1255526.55,0.00,'2022-09-26 07:16:05'),(1819898,'5','183',423,'Sale Id shift 257762',0.00,791430.00,185.00,791430.00,0.00,'2022-09-27 07:22:26'),(1819899,'5','183',423,'Sale Id shift 257763',0.00,950522.60,185.00,950522.60,0.00,'2022-09-28 08:20:54'),(1819900,'5','183',423,'Sale Id shift 257764',0.00,1040895.10,185.00,1040895.10,0.00,'2022-09-29 08:32:42'),(1819901,'5','183',423,'Sale Id shift 257765',0.00,1052853.50,185.00,1052853.50,0.00,'2022-09-30 08:05:45'),(1819902,'5','183',423,'Sale Id shift 257766',0.00,921213.05,185.00,921213.05,0.00,'2022-10-01 08:56:26'),(1819903,'5','183',423,'Sale Id shift 257767',0.00,911565.30,185.00,911565.30,0.00,'2022-10-02 18:36:26'),(1819904,'5','183',423,'Sale Id shift 257768',0.00,1160360.70,185.00,1160360.70,0.00,'2022-10-03 06:22:58'),(1819905,'5','183',423,'Sale Id shift 257769',0.00,947529.30,185.00,947529.30,0.00,'2022-10-04 07:10:24'),(1819906,'5','183',423,'Sale Id shift 257770',0.00,743794.35,185.00,743794.35,0.00,'2022-10-05 09:35:17'),(1819907,'5','183',423,'Sale Id shift 257771',0.00,1042036.55,185.00,1042036.55,0.00,'2022-10-06 07:57:06'),(1819908,'5','183',423,'Sale Id shift 257772',0.00,976731.55,185.00,976731.55,0.00,'2022-10-07 08:22:49'),(1819909,'5','183',423,'Sale Id shift 257773',0.00,1214425.10,185.00,1214425.10,0.00,'2022-10-08 08:34:08'),(1819910,'5','183',423,'Sale Id shift 257774',0.00,1193662.55,185.00,1193662.55,0.00,'2022-10-09 08:29:38'),(1819911,'5','183',423,'Sale Id shift 257775',0.00,1006468.45,185.00,1006468.45,0.00,'2022-10-10 14:18:04'),(1819912,'5','183',423,'Sale Id shift 257794',0.00,1618935.00,185.00,1618935.00,0.00,'2022-10-29 07:53:42'),(1819913,'5','183',423,'Sale Id shift 257795',0.00,2087088.60,185.00,2087088.60,0.00,'2022-10-30 06:34:19'),(1819914,'5','183',423,'Sale Id shift 257796',0.00,1961804.75,185.00,1961804.75,0.00,'2022-10-31 06:44:27'),(1819915,'5','183',423,'Sale Id shift 257797',0.00,1935048.20,185.00,1935048.20,0.00,'2022-11-01 07:53:16'),(1819916,'5','183',423,'Sale Id shift 257798',0.00,2092969.75,185.00,2092969.75,0.00,'2022-11-02 13:05:08'),(1819917,'5','183',423,'Sale Id shift 257799',0.00,2460816.35,185.00,2460816.35,0.00,'2022-11-03 08:12:11'),(1819918,'5','183',423,'Sale Id shift 257800',0.00,2687254.50,185.00,2687254.50,0.00,'2022-11-04 07:31:02'),(1819919,'5','183',423,'Sale Id shift 257801',0.00,2588242.50,185.00,2588242.50,0.00,'2022-11-06 07:07:13'),(1819920,'5','183',423,'Sale Id shift 257802',0.00,2357849.05,185.00,2357849.05,0.00,'2022-11-06 12:34:41'),(1819921,'5','183',423,'Sale Id shift 257803',0.00,1613355.40,185.00,1613355.40,0.00,'2022-11-07 08:28:09'),(1819922,'5','183',423,'Sale Id shift 257804',0.00,932105.85,185.00,932105.85,0.00,'2022-11-08 07:58:54'),(1819923,'5','183',423,'Sale Id shift 257805',0.00,1082928.95,185.00,1082928.95,0.00,'2022-11-09 08:24:37'),(1819924,'5','183',423,'Sale Id shift 257806',0.00,591457.95,185.00,591457.95,0.00,'2022-11-10 09:27:51'),(1819925,'5','183',423,'Sale Id shift 257817',0.00,2216444.30,185.00,2216444.30,0.00,'2022-11-21 06:37:11'),(1819926,'5','183',423,'Sale Id shift 257818',0.00,1893867.20,185.00,1893867.20,0.00,'2022-11-22 09:20:57'),(1819927,'5','183',423,'Sale Id shift 257819',0.00,1550805.05,185.00,1550805.05,0.00,'2022-11-23 08:29:45'),(1819928,'5','183',423,'Sale Id shift 257820',0.00,1548618.35,185.00,1548618.35,0.00,'2022-11-24 13:10:23'),(1819929,'5','183',423,'Sale Id shift 257821',0.00,1083648.60,185.00,1083648.60,0.00,'2022-11-25 08:31:55'),(1819930,'5','183',423,'Sale Id shift 257828',0.00,2164566.60,185.00,2164566.60,0.00,'2022-12-02 09:11:17'),(1819931,'5','183',423,'Sale Id shift 257829',0.00,1879620.35,185.00,1879620.35,0.00,'2022-12-03 08:22:01'),(1819932,'5','183',423,'Sale Id shift 257830',0.00,2041835.75,185.00,2041835.75,0.00,'2022-12-04 09:14:12'),(1819933,'5','183',423,'Sale Id shift 257831',0.00,2000062.75,185.00,2000062.75,0.00,'2022-12-05 13:56:25'),(1819934,'5','183',423,'Sale Id shift 257832',0.00,2529397.70,185.00,2529397.70,0.00,'2022-12-06 07:55:57'),(1819935,'5','183',423,'Sale Id shift 257833',0.00,2223459.50,185.00,2223459.50,0.00,'2022-12-08 07:48:22'),(1819936,'5','183',423,'Sale Id shift 257846',0.00,2212988.50,185.00,2212988.50,0.00,'2022-12-20 09:35:09'),(1819937,'5','183',423,'Sale Id shift 257847',0.00,2423372.35,185.00,2423372.35,0.00,'2022-12-21 09:19:47'),(1819938,'5','183',423,'Sale Id shift 257848',0.00,885341.55,185.00,885341.55,0.00,'2022-12-22 09:05:06'),(1819939,'5','183',423,'Sale Id shift 257875',0.00,1960426.50,185.00,1960426.50,0.00,'2023-01-17 09:39:10'),(1819940,'5','183',423,'Sale Id shift 257876',0.00,2936109.10,185.00,2936109.10,0.00,'2023-01-18 09:36:58'),(1819941,'5','183',423,'Sale Id shift 257877',0.00,625714.40,185.00,625714.40,0.00,'2023-01-19 09:32:43'),(1819942,'5','183',423,'Sale Id shift 257880',0.00,1199041.80,185.00,1008285.15,-190756.65,'2023-01-22 10:18:06'),(1819943,'5','183',423,'Sale Id shift 257881',0.00,2012645.80,185.00,1692452.15,-320193.65,'2023-01-23 10:09:31'),(1819944,'5','183',423,'Sale Id shift 257882',0.00,858312.40,220.00,858312.40,0.00,'2023-01-24 11:26:44'),(1819945,'5','183',423,'Sale Id shift 257885',0.00,2032661.40,220.00,2032661.40,0.00,'2023-01-27 09:54:21'),(1819946,'5','183',423,'Sale Id shift 257886',0.00,937332.00,220.00,937332.00,0.00,'2023-01-28 10:03:51'),(1819947,'5','183',423,'Sale Id shift 257891',0.00,2684565.40,220.00,2684565.40,0.00,'2023-02-04 12:58:19'),(1819948,'5','183',423,'Sale Id shift 257892',0.00,2265434.60,220.00,2265434.60,0.00,'2023-02-05 16:21:10'),(1819949,'5','183',423,'Sale Id shift 257896',0.00,2588069.00,220.00,2588069.00,0.00,'2023-02-09 12:07:25'),(1819950,'5','183',423,'Sale Id shift 257897',0.00,711931.00,220.00,711931.00,0.00,'2023-02-10 09:11:27'),(1819951,'5','183',423,'Sale Id shift 257898',0.00,1398738.00,220.00,1398738.00,0.00,'2023-02-11 13:09:12'),(1819952,'5','183',423,'Sale Id shift 257899',0.00,2092602.60,220.00,2092602.60,0.00,'2023-02-12 12:48:08'),(1819953,'5','183',423,'Sale Id shift 257900',0.00,600659.40,220.00,600659.40,0.00,'2023-02-13 09:21:00'),(1819954,'5','183',423,'Sale Id shift 257910',0.00,899829.00,220.00,942678.00,42849.00,'2023-02-26 20:43:45'),(1819955,'5','183',423,'Sale Id shift 257911',0.00,2122776.60,210.00,2122776.60,0.00,'2023-02-27 08:38:45'),(1819956,'5','183',423,'Sale Id shift 257912',0.00,2169209.70,210.00,2169209.70,0.00,'2023-02-28 09:21:16'),(1819957,'5','183',423,'Sale Id shift 257913',0.00,2857325.10,210.00,2857325.10,0.00,'2023-03-01 08:58:43'),(1819958,'5','183',423,'Sale Id shift 257914',0.00,2497128.90,210.00,2497128.90,0.00,'2023-03-02 11:32:52'),(1819959,'5','183',423,'Sale Id shift 257915',0.00,2237722.20,210.00,2237722.20,0.00,'2023-03-03 09:41:36'),(1819960,'5','183',423,'Sale Id shift 257916',0.00,2298042.60,210.00,2298042.60,0.00,'2023-03-05 18:21:52'),(1819961,'5','183',423,'Sale Id shift 257917',0.00,2848196.40,210.00,2848196.40,0.00,'2023-03-06 08:52:54'),(1819962,'5','183',423,'Sale Id shift 257918',0.00,2784224.10,210.00,2784224.10,0.00,'2023-03-06 12:29:21'),(1819963,'5','183',423,'Sale Id shift 257919',0.00,2843364.30,210.00,2843364.30,0.00,'2023-03-07 09:15:44'),(1819964,'5','183',423,'Sale Id shift 257920',0.00,1316498.40,210.00,1316498.40,0.00,'2023-03-08 09:27:23'),(1819965,'5','183',423,'Sale Id shift 257921',0.00,2987838.00,210.00,2987838.00,0.00,'2023-03-09 09:34:47'),(1819966,'5','183',423,'Sale Id shift 257922',0.00,3046043.70,210.00,3046043.70,0.00,'2023-03-10 09:44:38'),(1819967,'5','183',423,'Sale Id shift 257923',0.00,2312786.70,210.00,2312786.70,0.00,'2023-03-12 12:57:44'),(1819968,'5','183',423,'Sale Id shift 257924',0.00,441909.30,210.00,441909.30,0.00,'2023-03-13 09:24:02');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4937508 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','183',3619053,'','24','3458',0.00,195000.00,'Purchase Id 78543 for 650.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-10-18 08:09:21','',''),('5','183',3619054,'','supplier','262',195000.00,0.00,'Purchase Id 78543 for 650.00 litters of Diesel - AGO from SALBAS OIL AND GAS NIG LIMITED','2021-10-18 08:09:21','',''),('5','183',3619059,'','24','3458',0.00,356400.00,'Purchase Id 78542 for 2,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-18 08:10:02','',''),('5','183',3619060,'','supplier','262',356400.00,0.00,'Purchase Id 78542 for 2,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-18 08:10:02','',''),('5','183',3640566,'','24','3458',0.00,6480000.00,'Purchase Id 78719 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-20 10:30:01','',''),('5','183',3640567,'','supplier','262',6480000.00,0.00,'Purchase Id 78719 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-20 10:30:01','',''),('5','183',3649216,'','20','3470',954348.48,0.00,'Sales from shift 232977 on 2021-10-21 06:40:42 ','2021-10-21 06:40:42','',''),('5','183',3649217,'','6.1','3460',0.00,954348.48,'Sales from shift 232977 on 2021-10-21 06:40:42 ','2021-10-21 06:40:42','',''),('5','183',3651197,'','20','3470',1124053.20,0.00,'Sales from shift 233176 on 2021-10-21 09:17:55 ','2021-10-21 09:17:55','',''),('5','183',3651198,'','6.1','3460',0.00,1124053.20,'Sales from shift 233176 on 2021-10-21 09:17:55 ','2021-10-21 09:17:55','',''),('5','183',3651374,'','20','3470',1054296.00,0.00,'Sales from shift 233186 on 2021-10-21 09:28:29 ','2021-10-21 09:28:29','',''),('5','183',3651375,'','6.1','3460',0.00,1054296.00,'Sales from shift 233186 on 2021-10-21 09:28:29 ','2021-10-21 09:28:29','',''),('5','183',3651760,'','20','3470',985606.38,0.00,'Sales from shift 233191 on 2021-10-21 10:00:06 ','2021-10-21 10:00:06','',''),('5','183',3651761,'','6.1','3460',0.00,985606.38,'Sales from shift 233191 on 2021-10-21 10:00:06 ','2021-10-21 10:00:06','',''),('5','183',3651992,'','20','3470',1026103.14,0.00,'Sales from shift 233206 on 2021-10-21 10:20:41 ','2021-10-21 10:20:41','',''),('5','183',3651993,'','6.1','3460',0.00,1026103.14,'Sales from shift 233206 on 2021-10-21 10:20:41 ','2021-10-21 10:20:41','',''),('5','183',3652052,'','20','3470',990327.06,0.00,'Sales from shift 233212 on 2021-10-21 10:28:29 ','2021-10-21 10:28:29','',''),('5','183',3652053,'','6.1','3460',0.00,990327.06,'Sales from shift 233212 on 2021-10-21 10:28:29 ','2021-10-21 10:28:29','',''),('5','183',3652093,'','24','3458',0.00,4860000.00,'Purchase Id 78821 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-21 10:33:18','',''),('5','183',3652094,'','supplier','262',4860000.00,0.00,'Purchase Id 78821 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-21 10:33:18','',''),('5','183',3652245,'','20','3470',1100992.50,0.00,'Sales from shift 233219 on 2021-10-21 10:48:00 ','2021-10-21 10:48:00','',''),('5','183',3652246,'','6.1','3460',0.00,1100992.50,'Sales from shift 233219 on 2021-10-21 10:48:00 ','2021-10-21 10:48:00','',''),('5','183',3652340,'','20','3470',1118752.56,0.00,'Sales from shift 233222 on 2021-10-21 10:55:29 ','2021-10-21 10:55:29','',''),('5','183',3652341,'','6.1','3460',0.00,1118752.56,'Sales from shift 233222 on 2021-10-21 10:55:29 ','2021-10-21 10:55:29','',''),('5','183',3652874,'','20','3470',1120809.96,0.00,'Sales from shift 233227 on 2021-10-21 11:39:23 ','2021-10-21 11:39:23','',''),('5','183',3652875,'','6.1','3460',0.00,1120809.96,'Sales from shift 233227 on 2021-10-21 11:39:23 ','2021-10-21 11:39:23','',''),('5','183',3656153,'','6.1','3460',14900.00,0.00,'Payment Id 348336 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656154,'','supplier','262',0.00,14900.00,'Payment Id 348336 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656155,'','2','3473',163500.00,0.00,'Payment Id 348335 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656156,'','supplier','262',0.00,163500.00,'Payment Id 348335 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656157,'','2','3512',847705.00,0.00,'Payment Id 348334 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656158,'','supplier','262',0.00,847705.00,'Payment Id 348334 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656159,'','6.1','3460',15300.00,0.00,'Payment Id 348333 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656160,'','supplier','262',0.00,15300.00,'Payment Id 348333 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656161,'','2','3473',91000.00,0.00,'Payment Id 348330 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656162,'','supplier','262',0.00,91000.00,'Payment Id 348330 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656163,'','2','3512',879305.00,0.00,'Payment Id 348327 for invoice:233227, receipt: 5588 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656164,'','supplier','262',0.00,879305.00,'Payment Id 348327 for invoice:233227, receipt: 5588 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656165,'','6.1','3460',15300.00,0.00,'Payment Id 348323 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656166,'','supplier','262',0.00,15300.00,'Payment Id 348323 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656167,'','2','3473',117200.00,0.00,'Payment Id 348319 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656168,'','supplier','262',0.00,117200.00,'Payment Id 348319 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656169,'','2','3512',921795.00,0.00,'Payment Id 348317 for invoice:233227, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656170,'','supplier','262',0.00,921795.00,'Payment Id 348317 for invoice:233227, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656171,'','6.1','3460',39800.00,0.00,'Payment Id 348315 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656172,'','supplier','262',0.00,39800.00,'Payment Id 348315 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656173,'','2','3473',131900.00,0.00,'Payment Id 348311 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656174,'','supplier','262',0.00,131900.00,'Payment Id 348311 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656175,'','2','3512',921795.00,0.00,'Payment Id 348309 for invoice:233227, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656176,'','supplier','262',0.00,921795.00,'Payment Id 348309 for invoice:233227, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656177,'','6.1','3460',265300.00,0.00,'Payment Id 348308 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656178,'','supplier','262',0.00,265300.00,'Payment Id 348308 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:24','',''),('5','183',3656179,'','2','3473',75200.00,0.00,'Payment Id 348305 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656180,'','supplier','262',0.00,75200.00,'Payment Id 348305 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656181,'','2','3473',75200.00,0.00,'Payment Id 348303 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656182,'','supplier','262',0.00,75200.00,'Payment Id 348303 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656183,'','2','3512',613845.00,0.00,'Payment Id 348301 for invoice:233227, receipt: 0081 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656184,'','supplier','262',0.00,613845.00,'Payment Id 348301 for invoice:233227, receipt: 0081 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 15:49:25','',''),('5','183',3656532,'','6.1','3460',16425.00,0.00,'Payment Id 348356 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:57','',''),('5','183',3656533,'','supplier','262',0.00,16425.00,'Payment Id 348356 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:57','',''),('5','183',3656534,'','2','3473',117600.00,0.00,'Payment Id 348354 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656535,'','supplier','262',0.00,117600.00,'Payment Id 348354 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656536,'','2','3512',986785.00,0.00,'Payment Id 348353 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656537,'','supplier','262',0.00,986785.00,'Payment Id 348353 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656538,'','6.1','3460',14400.00,0.00,'Payment Id 348351 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656539,'','supplier','262',0.00,14400.00,'Payment Id 348351 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656540,'','2','3473',152000.00,0.00,'Payment Id 348349 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656541,'','supplier','262',0.00,152000.00,'Payment Id 348349 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656542,'','2','3512',952355.00,0.00,'Payment Id 348348 for invoice:233227, receipt: 0033 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656543,'','supplier','262',0.00,952355.00,'Payment Id 348348 for invoice:233227, receipt: 0033 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656544,'','6.1','3460',15300.00,0.00,'Payment Id 348347 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656545,'','supplier','262',0.00,15300.00,'Payment Id 348347 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656546,'','2','3473',114865.00,0.00,'Payment Id 348345 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656547,'','supplier','262',0.00,114865.00,'Payment Id 348345 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656548,'','2','3512',970830.00,0.00,'Payment Id 348344 for invoice:233227, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656549,'','supplier','262',0.00,970830.00,'Payment Id 348344 for invoice:233227, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656550,'','6.1','3460',29900.00,0.00,'Payment Id 348342 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656551,'','supplier','262',0.00,29900.00,'Payment Id 348342 for invoice:233227, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656552,'','2','3512',960370.00,0.00,'Payment Id 348338 for invoice:233227, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3656553,'','supplier','262',0.00,960370.00,'Payment Id 348338 for invoice:233227, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-10-21 16:17:58','',''),('5','183',3659913,'','20','3470',1112337.36,0.00,'Sales from shift 233370 on 2021-10-22 08:49:15 ','2021-10-22 08:49:15','',''),('5','183',3659914,'','6.1','3460',0.00,1112337.36,'Sales from shift 233370 on 2021-10-22 08:49:15 ','2021-10-22 08:49:15','',''),('5','183',3668834,'','6.1','3460',16400.00,0.00,'Payment Id 348915 for invoice:233370, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3668835,'','supplier','262',0.00,16400.00,'Payment Id 348915 for invoice:233370, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3668836,'','2','3473',254400.00,0.00,'Payment Id 348914 for invoice:233370, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3668837,'','supplier','262',0.00,254400.00,'Payment Id 348914 for invoice:233370, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3668838,'','2','3512',844755.00,0.00,'Payment Id 348913 for invoice:233370, receipt: 0087 by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3668839,'','supplier','262',0.00,844755.00,'Payment Id 348913 for invoice:233370, receipt: 0087 by SALBAS OIL AND GAS NIG LIMITED','2021-10-23 04:05:33','',''),('5','183',3679426,'','20','3470',815778.54,0.00,'Sales from shift 233615 on 2021-10-24 06:48:59 ','2021-10-24 06:48:59','',''),('5','183',3679427,'','6.1','3460',0.00,815778.54,'Sales from shift 233615 on 2021-10-24 06:48:59 ','2021-10-24 06:48:59','',''),('5','183',3687173,'','24','3458',0.00,2138400.00,'Purchase Id 79034 for 13,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-24 19:25:56','',''),('5','183',3687174,'','supplier','262',2138400.00,0.00,'Purchase Id 79034 for 13,200.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-24 19:25:56','',''),('5','183',3692911,'','20','3470',869735.88,0.00,'Sales from shift 234164 on 2021-10-25 13:16:10 ','2021-10-25 13:16:10','',''),('5','183',3692912,'','6.1','3460',0.00,869735.88,'Sales from shift 234164 on 2021-10-25 13:16:10 ','2021-10-25 13:16:10','',''),('5','183',3697593,'','20','3470',1157441.40,0.00,'Sales from shift 234307 on 2021-10-26 06:12:41 ','2021-10-26 06:12:41','',''),('5','183',3697594,'','6.1','3460',0.00,1157441.40,'Sales from shift 234307 on 2021-10-26 06:12:41 ','2021-10-26 06:12:41','',''),('5','183',3709372,'','6.1','3460',16425.00,0.00,'Payment Id 351184 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709373,'','supplier','262',0.00,16425.00,'Payment Id 351184 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709374,'','2','3473',95000.00,0.00,'Payment Id 351179 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709375,'','supplier','262',0.00,95000.00,'Payment Id 351179 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709376,'','2','3512',1046015.00,0.00,'Payment Id 351178 for invoice:234561, receipt: 0041 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709377,'','supplier','262',0.00,1046015.00,'Payment Id 351178 for invoice:234561, receipt: 0041 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709378,'','6.1','3460',16025.00,0.00,'Payment Id 351177 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709379,'','supplier','262',0.00,16025.00,'Payment Id 351177 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709380,'','2','3473',103800.00,0.00,'Payment Id 351176 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709381,'','supplier','262',0.00,103800.00,'Payment Id 351176 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709382,'','2','3512',782310.00,0.00,'Payment Id 351174 for invoice:234561, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709383,'','supplier','262',0.00,782310.00,'Payment Id 351174 for invoice:234561, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709384,'','6.1','3460',16425.00,0.00,'Payment Id 351172 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709385,'','supplier','262',0.00,16425.00,'Payment Id 351172 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709386,'','2','3473',92900.00,0.00,'Payment Id 351171 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709387,'','supplier','262',0.00,92900.00,'Payment Id 351171 for invoice:234561, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709388,'','2','3512',706435.00,0.00,'Payment Id 351170 for invoice:234561, receipt: 0061 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709389,'','supplier','262',0.00,706435.00,'Payment Id 351170 for invoice:234561, receipt: 0061 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 06:50:15','',''),('5','183',3709959,'','20','3470',125817.30,0.00,'Sales from shift 234561 on 2021-10-27 07:27:01 ','2021-10-27 07:27:01','',''),('5','183',3709960,'','6.1','3460',0.00,125817.30,'Sales from shift 234561 on 2021-10-27 07:27:01 ','2021-10-27 07:27:01','',''),('5','183',3719263,'','6.1','3460',16425.00,0.00,'Payment Id 351571 for invoice:234628, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 19:19:33','',''),('5','183',3719264,'','supplier','262',0.00,16425.00,'Payment Id 351571 for invoice:234628, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 19:19:33','',''),('5','183',3719265,'','2','3512',111725.00,0.00,'Payment Id 351569 for invoice:234628, receipt: 0061 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 19:19:33','',''),('5','183',3719266,'','supplier','262',0.00,111725.00,'Payment Id 351569 for invoice:234628, receipt: 0061 by SALBAS OIL AND GAS NIG LIMITED','2021-10-27 19:19:33','',''),('5','183',3721069,'','20','3470',0.00,0.00,'Sales from shift 234628 on 2021-10-28 07:58:14 ','2021-10-28 07:58:14','',''),('5','183',3721070,'','6.1','3460',0.00,0.00,'Sales from shift 234628 on 2021-10-28 07:58:14 ','2021-10-28 07:58:14','',''),('5','183',3738322,'','20','3470',0.00,0.00,'Sales from shift 234935 on 2021-10-29 21:57:29 ','2021-10-29 21:57:29','',''),('5','183',3738323,'','6.1','3460',0.00,0.00,'Sales from shift 234935 on 2021-10-29 21:57:29 ','2021-10-29 21:57:29','',''),('5','183',3738442,'','24','3458',0.00,2310000.00,'Purchase Id 79360 for 14,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-30 05:39:13','',''),('5','183',3738443,'','supplier','262',2310000.00,0.00,'Purchase Id 79360 for 14,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-10-30 05:39:13','',''),('5','183',3747417,'','20','3470',0.00,0.00,'Sales from shift 235278 on 2021-10-30 16:52:27 ','2021-10-30 16:52:27','',''),('5','183',3747418,'','6.1','3460',0.00,0.00,'Sales from shift 235278 on 2021-10-30 16:52:27 ','2021-10-30 16:52:27','',''),('5','183',3750583,'','20','3470',789510.15,0.00,'Sales from shift 235493 on 2021-10-31 08:49:32 ','2021-10-31 08:49:32','',''),('5','183',3750584,'','6.1','3460',0.00,789510.15,'Sales from shift 235493 on 2021-10-31 08:49:32 ','2021-10-31 08:49:32','',''),('5','183',3758072,'','20','3470',1239965.10,0.00,'Sales from shift 235725 on 2021-11-01 04:40:52 ','2021-11-01 04:40:52','',''),('5','183',3758073,'','6.1','3460',0.00,1239965.10,'Sales from shift 235725 on 2021-11-01 04:40:52 ','2021-11-01 04:40:52','',''),('5','183',3766053,'','6.1','3460',16025.00,0.00,'Payment Id 354079 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766054,'','supplier','262',0.00,16025.00,'Payment Id 354079 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766055,'','2','3473',174625.00,0.00,'Payment Id 354078 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766056,'','supplier','262',0.00,174625.00,'Payment Id 354078 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766057,'','2','3512',1049315.00,0.00,'Payment Id 354077 for invoice:235935, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766058,'','supplier','262',0.00,1049315.00,'Payment Id 354077 for invoice:235935, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766059,'','6.1','3460',16025.00,0.00,'Payment Id 354076 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766060,'','supplier','262',0.00,16025.00,'Payment Id 354076 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766061,'','2','3473',125800.00,0.00,'Payment Id 354075 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766062,'','supplier','262',0.00,125800.00,'Payment Id 354075 for invoice:235935, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766063,'','2','3512',647685.00,0.00,'Payment Id 354074 for invoice:235935, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766064,'','supplier','262',0.00,647685.00,'Payment Id 354074 for invoice:235935, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-11-01 17:49:24','',''),('5','183',3766678,'','2','3472',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3767106,'','24','3467',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3767422,'','22','3471',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3767986,'','24','3468',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768058,'','24','3466',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768156,'','24','3462',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768416,'','24','3459',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768662,'','6.1','3460',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768784,'','24','3465',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3768943,'','24','3464',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769022,'','24','3463',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769024,'','24','3461',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769042,'','24','3458',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769112,'','24','3469',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769399,'','2','3512',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769762,'','24','3457',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3769932,'','2','3473',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3770209,'','20','3470',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','183',3778118,'','20','3470',168943.50,0.00,'Sales from shift 235935 on 2021-11-03 04:59:08 ','2021-11-03 04:59:08','',''),('5','183',3778119,'','6.1','3460',0.00,168943.50,'Sales from shift 235935 on 2021-11-03 04:59:08 ','2021-11-03 04:59:08','',''),('5','183',3778120,'','24','3458',0.00,4380750.00,'Purchase Id 79670 for 26,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-03 04:59:29','',''),('5','183',3778121,'','supplier','262',4380750.00,0.00,'Purchase Id 79670 for 26,550.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-03 04:59:29','',''),('5','183',3788956,'','20','3470',690619.05,0.00,'Sales from shift 236229 on 2021-11-03 17:53:16 ','2021-11-03 17:53:16','',''),('5','183',3788957,'','6.1','3460',0.00,690619.05,'Sales from shift 236229 on 2021-11-03 17:53:16 ','2021-11-03 17:53:16','',''),('5','183',3790200,'','20','3470',1270369.65,0.00,'Sales from shift 236481 on 2021-11-04 06:30:46 ','2021-11-04 06:30:46','',''),('5','183',3790201,'','6.1','3460',0.00,1270369.65,'Sales from shift 236481 on 2021-11-04 06:30:46 ','2021-11-04 06:30:46','',''),('5','183',3804022,'','6.1','3460',23425.00,0.00,'Payment Id 355712 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804023,'','supplier','262',0.00,23425.00,'Payment Id 355712 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804024,'','2','3512',1250245.00,0.00,'Payment Id 355710 for invoice:236481, receipt: 0003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804025,'','supplier','262',0.00,1250245.00,'Payment Id 355710 for invoice:236481, receipt: 0003 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804026,'','6.1','3460',16425.00,0.00,'Payment Id 355708 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804027,'','supplier','262',0.00,16425.00,'Payment Id 355708 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804028,'','2','3512',674195.00,0.00,'Payment Id 355705 for invoice:236481, receipt: 0097 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804029,'','supplier','262',0.00,674195.00,'Payment Id 355705 for invoice:236481, receipt: 0097 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804030,'','6.1','3460',28125.00,0.00,'Payment Id 355703 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804031,'','supplier','262',0.00,28125.00,'Payment Id 355703 for invoice:236481, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804032,'','2','3512',140765.00,0.00,'Payment Id 355701 for invoice:236481, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3804033,'','supplier','262',0.00,140765.00,'Payment Id 355701 for invoice:236481, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-04 18:07:48','',''),('5','183',3813568,'','20','3470',1116361.95,0.00,'Sales from shift 236727 on 2021-11-05 15:13:04 ','2021-11-05 15:13:04','',''),('5','183',3813569,'','6.1','3460',0.00,1116361.95,'Sales from shift 236727 on 2021-11-05 15:13:04 ','2021-11-05 15:13:04','',''),('5','183',3828715,'','20','3470',966207.00,0.00,'Sales from shift 237020 on 2021-11-07 07:10:34 ','2021-11-07 07:10:34','',''),('5','183',3828716,'','6.1','3460',0.00,966207.00,'Sales from shift 237020 on 2021-11-07 07:10:34 ','2021-11-07 07:10:34','',''),('5','183',3849961,'','20','3470',300243.90,0.00,'Sales from shift 237420 on 2021-11-08 21:42:51 ','2021-11-08 21:42:51','',''),('5','183',3849962,'','6.1','3460',0.00,300243.90,'Sales from shift 237420 on 2021-11-08 21:42:51 ','2021-11-08 21:42:51','',''),('5','183',3854818,'','20','3470',0.00,0.00,'Sales from shift 237638 on 2021-11-09 10:44:45 ','2021-11-09 10:44:45','',''),('5','183',3854819,'','6.1','3460',0.00,0.00,'Sales from shift 237638 on 2021-11-09 10:44:45 ','2021-11-09 10:44:45','',''),('5','183',3854951,'','6.1','3460',16025.00,0.00,'Payment Id 357661 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854952,'','supplier','262',0.00,16025.00,'Payment Id 357661 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854953,'','2','3512',284220.00,0.00,'Payment Id 357658 for invoice:237420, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854954,'','supplier','262',0.00,284220.00,'Payment Id 357658 for invoice:237420, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854955,'','6.1','3460',266425.00,0.00,'Payment Id 357656 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854956,'','supplier','262',0.00,266425.00,'Payment Id 357656 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854957,'','2','3512',699780.00,0.00,'Payment Id 357654 for invoice:237420, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854958,'','supplier','262',0.00,699780.00,'Payment Id 357654 for invoice:237420, receipt: 0067 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854959,'','6.1','3460',16425.00,0.00,'Payment Id 357653 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854960,'','supplier','262',0.00,16425.00,'Payment Id 357653 for invoice:237420, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854961,'','2','3512',1099935.00,0.00,'Payment Id 357652 for invoice:237420, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3854962,'','supplier','262',0.00,1099935.00,'Payment Id 357652 for invoice:237420, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-11-09 10:50:58','',''),('5','183',3864028,'','20','3470',0.00,0.00,'Sales from shift 237723 on 2021-11-10 06:41:39 ','2021-11-10 06:41:39','',''),('5','183',3864029,'','6.1','3460',0.00,0.00,'Sales from shift 237723 on 2021-11-10 06:41:39 ','2021-11-10 06:41:39','',''),('5','183',3865777,'','24','3458',0.00,7425000.00,'Purchase Id 80196 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-10 08:26:43','',''),('5','183',3865778,'','supplier','262',7425000.00,0.00,'Purchase Id 80196 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-10 08:26:43','',''),('5','183',3880045,'','20','3470',1251572.85,0.00,'Sales from shift 237938 on 2021-11-11 09:43:48 ','2021-11-11 09:43:48','',''),('5','183',3880046,'','6.1','3460',0.00,1251572.85,'Sales from shift 237938 on 2021-11-11 09:43:48 ','2021-11-11 09:43:48','',''),('5','183',3892778,'','20','3470',1180017.30,0.00,'Sales from shift 238211 on 2021-11-12 08:18:58 ','2021-11-12 08:18:58','',''),('5','183',3892779,'','6.1','3460',0.00,1180017.30,'Sales from shift 238211 on 2021-11-12 08:18:58 ','2021-11-12 08:18:58','',''),('5','183',3894408,'','6.1','3460',16425.00,0.00,'Payment Id 359512 for invoice:238211, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3894409,'','supplier','262',0.00,16425.00,'Payment Id 359512 for invoice:238211, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3894410,'','2','3473',73064.53,0.00,'Payment Id 359511 for invoice:238211, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3894411,'','supplier','262',0.00,73064.53,'Payment Id 359511 for invoice:238211, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3894412,'','2','3512',1162085.00,0.00,'Payment Id 359510 for invoice:238211, receipt: 0043 by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3894413,'','supplier','262',0.00,1162085.00,'Payment Id 359510 for invoice:238211, receipt: 0043 by SALBAS OIL AND GAS NIG LIMITED','2021-11-12 09:50:59','',''),('5','183',3902945,'','6.1','3460',16425.00,0.00,'Payment Id 359770 for invoice:238428, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902946,'','supplier','262',0.00,16425.00,'Payment Id 359770 for invoice:238428, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902947,'','2','3473',27500.00,0.00,'Payment Id 359767 for invoice:238428, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902948,'','supplier','262',0.00,27500.00,'Payment Id 359767 for invoice:238428, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902949,'','2','3512',941095.00,0.00,'Payment Id 359766 for invoice:238428, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902950,'','supplier','262',0.00,941095.00,'Payment Id 359766 for invoice:238428, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-11-13 05:54:00','',''),('5','183',3902953,'','20','3470',1654002.90,0.00,'Sales from shift 238428 on 2021-11-13 05:54:27 ','2021-11-13 05:54:27','',''),('5','183',3902954,'','6.1','3460',0.00,1654002.90,'Sales from shift 238428 on 2021-11-13 05:54:27 ','2021-11-13 05:54:27','',''),('5','183',3925174,'','24','3458',0.00,6600000.00,'Purchase Id 80562 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-14 15:23:45','',''),('5','183',3925175,'','supplier','262',6600000.00,0.00,'Purchase Id 80562 for 40,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-14 15:23:45','',''),('5','183',3925176,'','20','3470',1650070.95,0.00,'Sales from shift 238727 on 2021-11-14 15:24:04 ','2021-11-14 15:24:04','',''),('5','183',3925177,'','6.1','3460',0.00,1650070.95,'Sales from shift 238727 on 2021-11-14 15:24:04 ','2021-11-14 15:24:04','',''),('5','183',3928520,'','20','3470',1876328.85,0.00,'Sales from shift 239031 on 2021-11-15 07:24:33 ','2021-11-15 07:24:33','',''),('5','183',3928521,'','6.1','3460',0.00,1876328.85,'Sales from shift 239031 on 2021-11-15 07:24:33 ','2021-11-15 07:24:33','',''),('5','183',3940374,'','20','3470',2810281.65,0.00,'Sales from shift 239144 on 2021-11-16 08:09:20 ','2021-11-16 08:09:20','',''),('5','183',3940375,'','6.1','3460',0.00,2810281.65,'Sales from shift 239144 on 2021-11-16 08:09:20 ','2021-11-16 08:09:20','',''),('5','183',3940378,'','6.1','3460',16025.00,0.00,'Payment Id 361410 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940379,'','supplier','262',0.00,16025.00,'Payment Id 361410 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940380,'','2','3512',1860300.00,0.00,'Payment Id 361408 for invoice:239144, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940381,'','supplier','262',0.00,1860300.00,'Payment Id 361408 for invoice:239144, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940382,'','6.1','3460',16025.00,0.00,'Payment Id 361407 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940383,'','supplier','262',0.00,16025.00,'Payment Id 361407 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940384,'','2','3512',1633975.00,0.00,'Payment Id 361406 for invoice:239144, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940385,'','supplier','262',0.00,1633975.00,'Payment Id 361406 for invoice:239144, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940386,'','6.1','3460',24425.00,0.00,'Payment Id 361402 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940387,'','supplier','262',0.00,24425.00,'Payment Id 361402 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940388,'','2','3473',29000.00,0.00,'Payment Id 361399 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940389,'','supplier','262',0.00,29000.00,'Payment Id 361399 for invoice:239144, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940390,'','2','3512',1600600.00,0.00,'Payment Id 361395 for invoice:239144, receipt: 0066 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3940391,'','supplier','262',0.00,1600600.00,'Payment Id 361395 for invoice:239144, receipt: 0066 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 08:09:39','',''),('5','183',3949934,'','6.1','3460',16425.00,0.00,'Payment Id 361776 for invoice:239353, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3949935,'','supplier','262',0.00,16425.00,'Payment Id 361776 for invoice:239353, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3949936,'','2','3512',2793855.00,0.00,'Payment Id 361775 for invoice:239353, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3949937,'','supplier','262',0.00,2793855.00,'Payment Id 361775 for invoice:239353, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3949938,'','2','3512',2793855.00,0.00,'Payment Id 361774 for invoice:239353, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3949939,'','supplier','262',0.00,2793855.00,'Payment Id 361774 for invoice:239353, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-16 20:39:24','',''),('5','183',3958306,'','20','3470',1638139.80,0.00,'Sales from shift 239353 on 2021-11-17 14:43:42 ','2021-11-17 14:43:42','',''),('5','183',3958307,'','6.1','3460',0.00,1638139.80,'Sales from shift 239353 on 2021-11-17 14:43:42 ','2021-11-17 14:43:42','',''),('5','183',3958360,'','24','3458',0.00,2475000.00,'Purchase Id 80776 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-17 14:46:47','',''),('5','183',3958361,'','supplier','262',2475000.00,0.00,'Purchase Id 80776 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-17 14:46:47','',''),('5','183',3962541,'','20','3470',1387407.45,0.00,'Sales from shift 239678 on 2021-11-18 06:25:13 ','2021-11-18 06:25:13','',''),('5','183',3962542,'','6.1','3460',0.00,1387407.45,'Sales from shift 239678 on 2021-11-18 06:25:13 ','2021-11-18 06:25:13','',''),('5','183',3974429,'','24','3458',0.00,7425000.00,'Purchase Id 80876 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:30','',''),('5','183',3974430,'','supplier','262',7425000.00,0.00,'Purchase Id 80876 for 45,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:30','',''),('5','183',3974431,'','6.1','3460',16425.00,0.00,'Payment Id 362983 for invoice:239678, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974432,'','supplier','262',0.00,16425.00,'Payment Id 362983 for invoice:239678, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974433,'','2','3512',1370985.00,0.00,'Payment Id 362979 for invoice:239678, receipt: 0087 by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974434,'','supplier','262',0.00,1370985.00,'Payment Id 362979 for invoice:239678, receipt: 0087 by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974435,'','6.1','3460',16425.00,0.00,'Payment Id 362717 for invoice:239678, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974436,'','supplier','262',0.00,16425.00,'Payment Id 362717 for invoice:239678, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974437,'','2','3512',1619920.00,0.00,'Payment Id 362716 for invoice:239678, receipt: 0055 by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3974438,'','supplier','262',0.00,1619920.00,'Payment Id 362716 for invoice:239678, receipt: 0055 by SALBAS OIL AND GAS NIG LIMITED','2021-11-18 18:19:52','',''),('5','183',3976503,'','20','3470',951711.75,0.00,'Sales from shift 239922 on 2021-11-19 07:54:04 ','2021-11-19 07:54:04','',''),('5','183',3976504,'','6.1','3460',0.00,951711.75,'Sales from shift 239922 on 2021-11-19 07:54:04 ','2021-11-19 07:54:04','',''),('5','183',3985132,'','6.1','3460',16425.00,0.00,'Payment Id 363464 for invoice:240073, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-19 17:33:15','',''),('5','183',3985133,'','supplier','262',0.00,16425.00,'Payment Id 363464 for invoice:240073, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-19 17:33:15','',''),('5','183',3985134,'','2','3512',935285.00,0.00,'Payment Id 363463 for invoice:240073, receipt: 0078 by SALBAS OIL AND GAS NIG LIMITED','2021-11-19 17:33:15','',''),('5','183',3985135,'','supplier','262',0.00,935285.00,'Payment Id 363463 for invoice:240073, receipt: 0078 by SALBAS OIL AND GAS NIG LIMITED','2021-11-19 17:33:15','',''),('5','183',3986482,'','20','3470',756160.35,0.00,'Sales from shift 240073 on 2021-11-20 06:38:33 ','2021-11-20 06:38:33','',''),('5','183',3986483,'','6.1','3460',0.00,756160.35,'Sales from shift 240073 on 2021-11-20 06:38:33 ','2021-11-20 06:38:33','',''),('5','183',4000564,'','20','3470',824955.45,0.00,'Sales from shift 240218 on 2021-11-21 07:23:04 ','2021-11-21 07:23:04','',''),('5','183',4000565,'','6.1','3460',0.00,824955.45,'Sales from shift 240218 on 2021-11-21 07:23:04 ','2021-11-21 07:23:04','',''),('5','183',4012381,'','20','3470',888026.70,0.00,'Sales from shift 240675 on 2021-11-22 06:20:49 ','2021-11-22 06:20:49','',''),('5','183',4012382,'','6.1','3460',0.00,888026.70,'Sales from shift 240675 on 2021-11-22 06:20:49 ','2021-11-22 06:20:49','',''),('5','183',4024410,'','20','3470',933687.15,0.00,'Sales from shift 240781 on 2021-11-23 06:28:43 ','2021-11-23 06:28:43','',''),('5','183',4024411,'','6.1','3460',0.00,933687.15,'Sales from shift 240781 on 2021-11-23 06:28:43 ','2021-11-23 06:28:43','',''),('5','183',4026956,'','6.1','3460',16025.00,0.00,'Payment Id 365165 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026957,'','supplier','262',0.00,16025.00,'Payment Id 365165 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026958,'','2','3512',872000.00,0.00,'Payment Id 365163 for invoice:240781, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026959,'','supplier','262',0.00,872000.00,'Payment Id 365163 for invoice:240781, receipt: 0099 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026960,'','6.1','3460',45025.00,0.00,'Payment Id 365160 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026961,'','supplier','262',0.00,45025.00,'Payment Id 365160 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026962,'','2','3512',779930.00,0.00,'Payment Id 365154 for invoice:240781, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026963,'','supplier','262',0.00,779930.00,'Payment Id 365154 for invoice:240781, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026964,'','6.1','3460',31425.00,0.00,'Payment Id 365151 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026965,'','supplier','262',0.00,31425.00,'Payment Id 365151 for invoice:240781, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026966,'','2','3512',724735.00,0.00,'Payment Id 365149 for invoice:240781, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4026967,'','supplier','262',0.00,724735.00,'Payment Id 365149 for invoice:240781, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-23 08:44:32','',''),('5','183',4038466,'','6.1','3460',16425.00,0.00,'Payment Id 365704 for invoice:241039, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-24 07:02:48','',''),('5','183',4038467,'','supplier','262',0.00,16425.00,'Payment Id 365704 for invoice:241039, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-24 07:02:48','',''),('5','183',4038468,'','2','3512',917260.00,0.00,'Payment Id 365703 for invoice:241039, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-24 07:02:48','',''),('5','183',4038469,'','supplier','262',0.00,917260.00,'Payment Id 365703 for invoice:241039, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-24 07:02:48','',''),('5','183',4038472,'','20','3470',1125219.15,0.00,'Sales from shift 241039 on 2021-11-24 07:03:09 ','2021-11-24 07:03:09','',''),('5','183',4038473,'','6.1','3460',0.00,1125219.15,'Sales from shift 241039 on 2021-11-24 07:03:09 ','2021-11-24 07:03:09','',''),('5','183',4051828,'','20','3470',1038795.45,0.00,'Sales from shift 241510 on 2021-11-25 08:20:41 ','2021-11-25 08:20:41','',''),('5','183',4051829,'','6.1','3460',0.00,1038795.45,'Sales from shift 241510 on 2021-11-25 08:20:41 ','2021-11-25 08:20:41','',''),('5','183',4066298,'','20','3470',1755235.35,0.00,'Sales from shift 241735 on 2021-11-26 09:46:02 ','2021-11-26 09:46:02','',''),('5','183',4066299,'','6.1','3460',0.00,1755235.35,'Sales from shift 241735 on 2021-11-26 09:46:02 ','2021-11-26 09:46:02','',''),('5','183',4075047,'','6.1','3460',16425.00,0.00,'Payment Id 367092 for invoice:241844, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075048,'','supplier','262',0.00,16425.00,'Payment Id 367092 for invoice:241844, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075049,'','2','3512',1022370.00,0.00,'Payment Id 367091 for invoice:241844, receipt: 0058 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075050,'','supplier','262',0.00,1022370.00,'Payment Id 367091 for invoice:241844, receipt: 0058 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075051,'','6.1','3460',20425.00,0.00,'Payment Id 367090 for invoice:241844, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075052,'','supplier','262',0.00,20425.00,'Payment Id 367090 for invoice:241844, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075053,'','2','3512',1104795.00,0.00,'Payment Id 367088 for invoice:241844, receipt: 0049 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4075054,'','supplier','262',0.00,1104795.00,'Payment Id 367088 for invoice:241844, receipt: 0049 by SALBAS OIL AND GAS NIG LIMITED','2021-11-27 06:12:51','',''),('5','183',4076805,'','20','3470',1079834.25,0.00,'Sales from shift 241844 on 2021-11-27 08:38:55 ','2021-11-27 08:38:55','',''),('5','183',4076806,'','6.1','3460',0.00,1079834.25,'Sales from shift 241844 on 2021-11-27 08:38:55 ','2021-11-27 08:38:55','',''),('5','183',4089350,'','20','3470',849037.20,0.00,'Sales from shift 242124 on 2021-11-28 07:31:49 ','2021-11-28 07:31:49','',''),('5','183',4089351,'','6.1','3460',0.00,849037.20,'Sales from shift 242124 on 2021-11-28 07:31:49 ','2021-11-28 07:31:49','',''),('5','183',4101110,'','20','3470',240835.65,0.00,'Sales from shift 242398 on 2021-11-29 06:49:49 ','2021-11-29 06:49:49','',''),('5','183',4101111,'','6.1','3460',0.00,240835.65,'Sales from shift 242398 on 2021-11-29 06:49:49 ','2021-11-29 06:49:49','',''),('5','183',4113338,'','20','3470',0.00,0.00,'Sales from shift 242683 on 2021-11-30 06:55:42 ','2021-11-30 06:55:42','',''),('5','183',4113339,'','6.1','3460',0.00,0.00,'Sales from shift 242683 on 2021-11-30 06:55:42 ','2021-11-30 06:55:42','',''),('5','183',4113344,'','6.1','3460',16025.00,0.00,'Payment Id 369007 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113345,'','supplier','262',0.00,16025.00,'Payment Id 369007 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113346,'','2','3512',224435.00,0.00,'Payment Id 369005 for invoice:242683, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113347,'','supplier','262',0.00,224435.00,'Payment Id 369005 for invoice:242683, receipt: 0088 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113348,'','6.1','3460',16025.00,0.00,'Payment Id 369001 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113349,'','supplier','262',0.00,16025.00,'Payment Id 369001 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113350,'','2','3512',832635.00,0.00,'Payment Id 368999 for invoice:242683, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113351,'','supplier','262',0.00,832635.00,'Payment Id 368999 for invoice:242683, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113352,'','6.1','3460',16425.00,0.00,'Payment Id 368996 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113353,'','supplier','262',0.00,16425.00,'Payment Id 368996 for invoice:242683, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113354,'','2','3512',1063405.00,0.00,'Payment Id 368993 for invoice:242683, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113355,'','supplier','262',0.00,1063405.00,'Payment Id 368993 for invoice:242683, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113356,'','6.1','3460',16425.00,0.00,'Payment Id 368352 for invoice:242398, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113357,'','supplier','262',0.00,16425.00,'Payment Id 368352 for invoice:242398, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113358,'','2','3512',1933810.00,0.00,'Payment Id 368351 for invoice:242398, receipt: 0055 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4113359,'','supplier','262',0.00,1933810.00,'Payment Id 368351 for invoice:242398, receipt: 0055 by SALBAS OIL AND GAS NIG LIMITED','2021-11-30 06:56:03','',''),('5','183',4126233,'','24','3458',0.00,2475000.00,'Purchase Id 86089 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-30 19:05:43','',''),('5','183',4126234,'','supplier','262',2475000.00,0.00,'Purchase Id 86089 for 15,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-11-30 19:05:43','',''),('5','183',4138898,'','20','3470',385410.30,0.00,'Sales from shift 242832 on 2021-12-01 20:01:31 ','2021-12-01 20:01:31','',''),('5','183',4138899,'','6.1','3460',0.00,385410.30,'Sales from shift 242832 on 2021-12-01 20:01:31 ','2021-12-01 20:01:31','',''),('5','183',4145712,'','20','3470',928022.70,0.00,'Sales from shift 243124 on 2021-12-02 11:32:23 ','2021-12-02 11:32:23','',''),('5','183',4145713,'','6.1','3460',0.00,928022.70,'Sales from shift 243124 on 2021-12-02 11:32:23 ','2021-12-02 11:32:23','',''),('5','183',4145718,'','6.1','3460',16425.00,0.00,'Payment Id 370218 for invoice:243124, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:32:38','',''),('5','183',4145719,'','supplier','262',0.00,16425.00,'Payment Id 370218 for invoice:243124, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:32:38','',''),('5','183',4145720,'','2','3512',368990.00,0.00,'Payment Id 370216 for invoice:243124, receipt: 0024 by SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:32:38','',''),('5','183',4145721,'','supplier','262',0.00,368990.00,'Payment Id 370216 for invoice:243124, receipt: 0024 by SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:32:38','',''),('5','183',4145734,'','24','3458',0.00,4950000.00,'Purchase Id 86200 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:33:31','',''),('5','183',4145735,'','supplier','262',4950000.00,0.00,'Purchase Id 86200 for 30,000.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-02 11:33:31','',''),('5','183',4153571,'','6.1','3460',35125.00,0.00,'Payment Id 370430 for invoice:243239, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-03 05:35:23','',''),('5','183',4153572,'','supplier','262',0.00,35125.00,'Payment Id 370430 for invoice:243239, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-03 05:35:23','',''),('5','183',4153573,'','2','3512',892945.00,0.00,'Payment Id 370427 for invoice:243239, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-12-03 05:35:23','',''),('5','183',4153574,'','supplier','262',0.00,892945.00,'Payment Id 370427 for invoice:243239, receipt: 0054 by SALBAS OIL AND GAS NIG LIMITED','2021-12-03 05:35:23','',''),('5','183',4178455,'','20','3470',1410317.70,0.00,'Sales from shift 243239 on 2021-12-04 17:38:39 ','2021-12-04 17:38:39','',''),('5','183',4178456,'','6.1','3460',0.00,1410317.70,'Sales from shift 243239 on 2021-12-04 17:38:39 ','2021-12-04 17:38:39','',''),('5','183',4179673,'','24','3458',0.00,4900500.00,'Purchase Id 86437 for 29,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-05 05:16:58','',''),('5','183',4179674,'','supplier','262',4900500.00,0.00,'Purchase Id 86437 for 29,700.00 litters of Petrol - PMS from SALBAS OIL AND GAS NIG LIMITED','2021-12-05 05:16:58','',''),('5','183',4192770,'','20','3470',987320.40,0.00,'Sales from shift 243803 on 2021-12-06 07:32:23 ','2021-12-06 07:32:23','',''),('5','183',4192771,'','6.1','3460',0.00,987320.40,'Sales from shift 243803 on 2021-12-06 07:32:23 ','2021-12-06 07:32:23','',''),('5','183',4202639,'','20','3470',1587341.25,0.00,'Sales from shift 244159 on 2021-12-06 16:04:00 ','2021-12-06 16:04:00','',''),('5','183',4202640,'','6.1','3460',0.00,1587341.25,'Sales from shift 244159 on 2021-12-06 16:04:00 ','2021-12-06 16:04:00','',''),('5','183',4203178,'','20','3470',1373494.65,0.00,'Sales from shift 244208 on 2021-12-06 16:31:39 ','2021-12-06 16:31:39','',''),('5','183',4203179,'','6.1','3460',0.00,1373494.65,'Sales from shift 244208 on 2021-12-06 16:31:39 ','2021-12-06 16:31:39','',''),('5','183',4206699,'','20','3470',1451316.90,0.00,'Sales from shift 244237 on 2021-12-07 07:28:15 ','2021-12-07 07:28:15','',''),('5','183',4206700,'','6.1','3460',0.00,1451316.90,'Sales from shift 244237 on 2021-12-07 07:28:15 ','2021-12-07 07:28:15','',''),('5','183',4220767,'','20','3470',980123.10,0.00,'Sales from shift 244370 on 2021-12-08 07:07:48 ','2021-12-08 07:07:48','',''),('5','183',4220768,'','6.1','3460',0.00,980123.10,'Sales from shift 244370 on 2021-12-08 07:07:48 ','2021-12-08 07:07:48','',''),('5','183',4234754,'','6.1','3460',713695.00,0.00,'Payment Id 373610 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234755,'','supplier','262',0.00,713695.00,'Payment Id 373610 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234756,'','2','3512',713695.00,0.00,'Payment Id 373608 for invoice:244652, receipt: 0025 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234757,'','supplier','262',0.00,713695.00,'Payment Id 373608 for invoice:244652, receipt: 0025 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234758,'','6.1','3460',16425.00,0.00,'Payment Id 373606 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234759,'','supplier','262',0.00,16425.00,'Payment Id 373606 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234760,'','2','3512',1433890.00,0.00,'Payment Id 373605 for invoice:244652, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234761,'','supplier','262',0.00,1433890.00,'Payment Id 373605 for invoice:244652, receipt: 0044 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234762,'','6.1','3460',16025.00,0.00,'Payment Id 373604 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234763,'','supplier','262',0.00,16025.00,'Payment Id 373604 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234764,'','2','3512',1357460.00,0.00,'Payment Id 373603 for invoice:244652, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234765,'','supplier','262',0.00,1357460.00,'Payment Id 373603 for invoice:244652, receipt: 0065 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234766,'','6.1','3460',16025.00,0.00,'Payment Id 373602 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234767,'','supplier','262',0.00,16025.00,'Payment Id 373602 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234768,'','2','3512',1571375.00,0.00,'Payment Id 373599 for invoice:244652, receipt: 0033 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234769,'','supplier','262',0.00,1571375.00,'Payment Id 373599 for invoice:244652, receipt: 0033 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234770,'','6.1','3460',16425.00,0.00,'Payment Id 373597 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234771,'','supplier','262',0.00,16425.00,'Payment Id 373597 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234772,'','2','3512',970895.00,0.00,'Payment Id 373594 for invoice:244652, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234773,'','supplier','262',0.00,970895.00,'Payment Id 373594 for invoice:244652, receipt: 0077 by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234774,'','6.1','3460',16425.00,0.00,'Payment Id 373593 for invoice:244652, receipt:  by SALBAS OIL AND GAS NIG LIMITED','2021-12-09 08:28:04','',''),('5','183',4234775,'','supplier','262',0.00,16425.00,'Payment Id 373593 for invoice:244652, receipt:  by 