-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_182
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_182`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_182` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_182`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3684 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3474,30172,'',0,'24','5','182','PURCHASES','','2021-07-15 06:57:36',5,0.00,0.00,'','576','2021-07-15 06:57:36','576',0,1),(3475,4009,'',0,'22','5','182','PURCHASES','','2021-07-15 06:58:10',5,0.00,0.00,'','576','2021-07-15 06:58:10','576',0,1),(3476,30173,'',0,'24','5','182','SALARIES & WAGES','','2021-07-15 06:58:42',5,0.00,0.00,'','576','2021-07-15 06:58:42','576',0,1),(3477,3024,'',0,'6.1','5','182','CASH','','2021-07-15 06:58:56',5,0.00,0.00,'','576','2021-07-15 06:58:56','576',0,1),(3478,4022,'',0,'20','5','182','SALES','','2021-07-15 06:59:17',5,0.00,0.00,'','576','2021-07-15 06:59:17','576',0,1),(3510,4042,'',0,'2','5','182','Zenith Bank-1011555903','','2021-07-25 09:25:01',5,0.00,0.00,'','600','2021-07-25 09:25:01','600',0,1),(3681,4054,'',0,'2','5','182','1024022423-UBA','','2021-09-23 14:19:57',5,0.00,0.00,'','600','2021-09-23 14:19:57','600',0,1),(3682,4055,'',0,'2','5','182','JA\'IZ-0010037957','','2022-03-02 19:13:50',5,0.00,0.00,'','600','2022-03-02 19:13:50','600',0,0),(3683,2000,'',0,'6','5','182','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:38:41',5,0.00,0.00,'','600','2023-02-06 10:38:41','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (2,'5','182','0000-00-00','2023-02-22 13:15:17',10,'795','','0000-00-00 00:00:00','795','2023-02-22 13:18:24');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (3,'5','182','2','252','supplier',0.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',3000.00,'2023-02-19'),(4,'5','182','2','252','supplier',3000.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',0.00,'2023-02-22'),(5,'5','182','2','252','supplier',0.00,'Ago Price decrease 830 to 820 350litres on 20/2/2023',3500.00,'2023-02-22'),(6,'5','182','2','252','supplier',3500.00,'Ago Price decrease 830 to 820 350litres on 20/2/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17567 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','182',17553,'954',2166.45,337.00,'2021-11-09','','2021-11-09 13:57:00','639','639',2021,'639','2021-11-09 13:57:00',5),('5','182',17562,'954',6185.68,10500.00,'2021-11-10','','2021-11-10 09:45:36','600','600',2021,'600','2021-11-10 09:45:36',5),('5','182',17563,'953',14344.27,15000.00,'2022-03-02','','2022-03-02 15:04:01','600','600',2022,'600','2022-03-02 15:04:01',5),('5','182',17564,'954',4277.17,4500.00,'2022-07-23','','2022-07-23 10:38:50','600','600',2022,'600','2022-07-23 10:38:50',5),('5','182',17565,'954',436.42,1200.00,'2022-09-14','','2022-09-14 09:40:48','600','600',2022,'600','2022-09-14 09:40:48',5),('5','182',17566,'954',2956.91,3500.00,'2022-10-06','','2022-10-06 11:36:55','600','600',2022,'600','2022-10-06 11:36:55',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2843 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','182','953',2837,'5','PMS PUMP 2',872463.92,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 15:17:43','600'),('5','182','953',2838,'5','PMS PUMP 4',646154.00,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 15:19:39','600'),('5','182','954',2839,'5','PMS PUMP 1',511508.04,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 15:18:22','600'),('5','182','954',2840,'5','PMS PUMP 3',775424.49,'PMS DISPENSER','',NULL,NULL,'',5,'2021-10-15 10:20:31','600'),('5','182','955',2841,'5','AGO PUMP',204231.97,'AGO DISPENSER','',NULL,NULL,'',5,'2021-10-15 10:21:25','600'),('5','182','956',2842,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257881 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','182',210835,'Daily shiftu','2021-07-15','2021-07-15 00:00:00',NULL,'639',24148.30,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','182',210889,'Daily shiftu','2021-07-15','2021-07-15 00:00:00',NULL,'639',24564.65,24564.65,'639','2021-07-16 16:29:15','605','2021-07-16 17:29:23',10,0),('5','182',210911,'Daily shiftu','2021-07-16','2021-07-16 00:00:00',NULL,'639',25948.20,25948.20,'639','2021-07-16 20:44:42','605','2021-07-17 07:10:01',10,0),('5','182',210974,'Daily shiftu','2021-07-17','2021-07-17 00:00:00',NULL,'639',7873.55,7873.55,'639','2021-07-17 20:01:36','605','2021-07-17 22:28:35',10,0),('5','182',211196,'Daily shiftu','2021-07-18','2021-07-18 00:00:00',NULL,'639',14396.00,14396.00,'639','2021-07-19 11:55:08','605','2021-07-20 16:49:04',10,0),('5','182',211749,'Daily shiftu','2021-07-19','2021-07-19 00:00:00',NULL,'639',13879.75,13879.75,'639','2021-07-20 20:59:19','605','2021-07-21 05:39:28',10,0),('5','182',211978,'Daily shiftu','2021-07-21','2021-07-21 00:00:00',NULL,'639',20797.50,20797.50,'639','2021-07-22 05:34:43','605','2021-07-22 09:23:36',10,0),('5','182',212053,'Daily shiftu','2021-07-22','2021-07-22 00:00:00',NULL,'639',27110.50,27110.50,'639','2021-07-22 19:09:19','605','2021-07-23 16:21:28',10,0),('5','182',212421,'Daily shiftu','2021-07-23','2021-07-23 00:00:00',NULL,'639',137157.30,137157.30,'639','2021-07-23 20:35:20','605','2021-07-24 06:33:49',10,0),('5','182',212578,'Daily shiftu','2021-07-24','2021-07-24 00:00:00',NULL,'639',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','182',212714,'DAILY','2021-07-24','2021-07-24 00:00:00',NULL,'600',543640.85,543640.85,'639','2021-07-27 10:19:52','605','2021-07-27 10:21:33',10,0),('5','182',213247,'Daily shiftu','2021-07-25','2021-07-25 00:00:00',NULL,'639',1260682.04,1260682.04,'639','2021-07-27 11:09:39','605','2021-07-27 11:12:37',10,0),('5','182',213259,'Daily shiftu','2021-07-26','2021-07-26 00:00:00',NULL,'639',433351.05,433351.05,'639','2021-07-27 11:48:25','605','2021-07-27 11:50:01',10,0),('5','182',213270,'Daily shiftu','2021-07-27','2021-07-27 00:00:00',NULL,'639',399938.55,399938.55,'639','2021-07-27 20:11:23','605','2021-07-27 22:14:23',10,0),('5','182',213446,'Daily shiftu','2021-07-28','2021-07-28 00:00:00',NULL,'639',410619.00,410619.00,'639','2021-07-28 19:57:46','605','2021-07-29 04:46:10',10,0),('5','182',213733,'Daily shiftu','2021-07-29','2021-07-29 00:00:00',NULL,'639',533032.50,533032.50,'639','2021-07-29 20:01:31','605','2021-07-30 06:19:35',10,0),('5','182',213991,'Daily shiftu','2021-07-30','2021-07-30 00:00:00',NULL,'639',421662.45,421662.45,'639','2021-07-30 19:47:13','605','2021-07-31 15:13:02',10,0),('5','182',214303,'Daily shiftu','2021-07-31','2021-07-31 00:00:00',NULL,'639',526904.40,526904.40,'639','2021-07-31 20:30:09','605','2021-08-01 06:27:54',10,0),('5','182',214496,'Daily shiftu','2021-08-01','2021-08-01 00:00:00',NULL,'639',530950.20,530950.20,'639','2021-08-01 20:23:39','605','2021-08-02 06:17:15',10,0),('5','182',214535,'Daily shiftu','2021-08-02','2021-08-02 00:00:00',NULL,'639',290419.80,290419.80,'639','2021-08-02 20:37:26','605','2021-08-03 08:18:20',10,0),('5','182',214879,'Daily shiftu','2021-08-03','2021-08-03 00:00:00',NULL,'639',579760.50,579760.50,'639','2021-08-05 06:45:26','605','2021-08-05 06:54:23',10,0),('5','182',215299,'Daily shiftu','2021-08-04','2021-08-04 00:00:00',NULL,'639',470962.80,470962.80,'639','2021-08-05 10:09:53','605','2021-08-05 13:59:13',10,0),('5','182',215367,'Daily shiftu','2021-08-05','2021-08-05 00:00:00',NULL,'639',433776.75,433776.75,'639','2021-08-05 19:45:10','605','2021-08-06 00:13:11',10,0),('5','182',215450,'Daily shiftu','2021-08-06','2021-08-06 00:00:00',NULL,'639',655109.05,655109.05,'639','2021-08-07 14:23:30','605','2021-08-07 19:20:11',10,0),('5','182',215883,'Daily shiftu','2021-08-07','2021-08-07 00:00:00',NULL,'639',453511.80,453511.80,'639','2021-08-07 21:07:45','605','2021-08-08 06:23:18',10,0),('5','182',215923,'Daily shiftu','2021-08-08','2021-08-08 00:00:00',NULL,'639',506752.80,506752.80,'639','2021-08-08 19:07:43','605','2021-08-08 22:23:17',10,0),('5','182',216157,'Daily shiftu','2021-08-09','2021-08-09 00:00:00',NULL,'639',514398.10,514398.10,'639','2021-08-09 20:50:37','605','2021-08-10 05:43:52',10,0),('5','182',216316,'Daily shiftu','2021-08-10','2021-08-10 00:00:00',NULL,'639',456618.00,456618.00,'639','2021-08-10 18:56:14','605','2021-08-11 05:33:17',10,0),('5','182',216553,'Daily shiftu','2021-08-11','2021-08-11 00:00:00',NULL,'639',397984.40,397984.40,'639','2021-08-11 18:54:31','605','2021-08-12 05:19:05',10,0),('5','182',216782,'Daily shiftu','2021-08-12','2021-08-12 00:00:00',NULL,'639',470788.55,470788.55,'639','2021-08-12 18:37:07','605','2021-08-13 06:35:34',10,0),('5','182',217023,'Daily shiftu','2021-08-13','2021-08-13 00:00:00',NULL,'639',466604.70,466604.70,'639','2021-08-13 18:56:32','605','2021-08-14 06:52:38',10,0),('5','182',217297,'Daily shiftu','2021-08-14','2021-08-14 00:00:00',NULL,'639',447661.60,447661.60,'639','2021-08-14 19:10:42','605','2021-08-15 18:19:43',10,0),('5','182',217652,'Daily shiftu','2021-08-15','2021-08-15 00:00:00',NULL,'639',581102.45,581102.45,'639','2021-08-15 18:49:36','605','2021-08-15 21:01:53',10,0),('5','182',217733,'Daily shiftu','2021-08-16','2021-08-16 00:00:00',NULL,'639',725845.85,725845.85,'639','2021-08-16 18:25:21','605','2021-08-16 22:47:54',10,0),('5','182',218018,'Daily shiftu','2021-08-17','2021-08-17 00:00:00',NULL,'639',603830.50,603830.50,'639','2021-08-17 18:50:56','605','2021-08-18 05:54:08',10,0),('5','182',218257,'Daily shiftu','2021-08-18','2021-08-18 00:00:00',NULL,'639',652892.85,652892.85,'639','2021-08-23 14:53:17','605','2021-08-23 15:05:18',10,0),('5','182',219519,'Daily shift','2021-08-19','2021-08-19 00:00:00',NULL,'639',691843.90,691843.90,'639','2021-08-23 15:09:36','605','2021-08-23 15:10:53',10,0),('5','182',219521,'Daily shift','2021-08-20','2021-08-20 00:00:00',NULL,'639',317422.45,317422.45,'639','2021-08-23 15:26:46','605','2021-08-23 15:28:49',10,0),('5','182',219527,'Daily shift','2021-08-21','2021-08-21 00:00:00',NULL,'639',12773.50,12773.50,'639','2021-08-23 15:47:09','605','2021-08-23 15:57:30',10,0),('5','182',219533,'Daily shift','2021-08-22','2021-08-22 00:00:00',NULL,'639',15891.65,15891.65,'639','2021-08-23 16:08:32','605','2021-08-23 16:10:47',10,0),('5','182',219561,'Daily shift','2021-08-23','2021-08-23 00:00:00',NULL,'639',12953.45,12953.45,'639','2021-08-23 21:44:05','605','2021-08-23 22:32:26',10,0),('5','182',219615,'Daily shift','2021-08-24','2021-08-24 00:00:00',NULL,'639',451234.50,451234.50,'639','2021-08-24 20:45:22','605','2021-08-24 22:15:16',10,0),('5','182',219853,'Daily shift','2021-08-25','2021-08-25 00:00:00',NULL,'639',614826.20,614826.20,'639','2021-08-25 19:43:13','605','2021-08-25 21:31:01',10,0),('5','182',220076,'Daily shift','2021-08-26','2021-08-26 00:00:00',NULL,'639',478474.85,478474.85,'639','2021-08-26 21:14:13','605','2021-08-27 06:58:23',10,0),('5','182',220374,'Daily shift','2021-08-27','2021-08-27 00:00:00',NULL,'639',575353.45,575353.45,'639','2021-08-27 22:11:38','605','2021-08-28 06:35:56',10,0),('5','182',220484,'Daily shift','2021-08-28','2021-08-28 00:00:00',NULL,'639',394673.95,394673.95,'639','2021-08-28 21:02:16','605','2021-08-29 06:57:01',10,0),('5','182',220748,'Daily shift','2021-08-29','2021-08-29 00:00:00',NULL,'639',477467.55,477467.55,'639','2021-08-29 19:44:48','605','2021-08-30 04:42:33',10,0),('5','182',220922,'Daily shift','2021-08-30','2021-08-30 00:00:00',NULL,'639',466298.10,466298.10,'639','2021-09-15 11:14:29','664','2021-09-15 11:21:41',10,0),('5','182',224655,'DALY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'639',605366.20,605366.20,'639','2021-09-15 12:05:21','664','2021-09-15 12:34:13',10,0),('5','182',224660,'DALY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'639',552926.75,552926.75,'639','2021-09-15 12:40:46','664','2021-09-15 12:53:51',10,0),('5','182',224667,'DALY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'639',448426.45,448426.45,'639','2021-09-15 13:02:50','664','2021-09-15 13:05:43',10,0),('5','182',224674,'DALY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'639',474081.25,474081.25,'639','2021-09-15 13:16:48','664','2021-09-15 13:18:25',10,0),('5','182',224679,'DALY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'639',426264.00,426264.00,'639','2021-09-15 13:25:56','664','2021-09-15 13:27:48',10,0),('5','182',224681,'DALY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'639',391985.15,391985.15,'639','2021-09-15 13:35:47','664','2021-09-15 13:37:01',10,0),('5','182',224686,'DALY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'639',423671.65,423671.65,'639','2021-09-15 13:40:05','664','2021-09-15 13:41:35',10,0),('5','182',224689,'DALY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'639',311655.75,311655.75,'639','2021-09-15 14:10:37','664','2021-09-15 14:14:00',10,0),('5','182',224696,'DALY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'639',531523.40,531523.40,'639','2021-09-15 14:17:56','664','2021-09-15 14:19:38',10,0),('5','182',224701,'DALY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'639',406164.75,406164.75,'639','2021-09-15 14:24:23','664','2021-09-15 14:26:40',10,0),('5','182',224703,'DALY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'639',423883.30,423883.30,'639','2021-09-15 14:33:29','664','2021-09-15 14:34:24',10,0),('5','182',224704,'DALY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'639',334052.20,334052.20,'639','2021-09-15 14:40:01','664','2021-09-15 14:40:49',10,0),('5','182',224707,'DALY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'639',303062.50,303062.50,'639','2021-09-15 14:44:17','664','2021-09-15 14:55:52',10,0),('5','182',224712,'DALY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'639',393145.65,393145.65,'639','2021-09-15 15:17:51','664','2021-09-15 15:19:00',10,0),('5','182',224717,'DALY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'639',433069.25,433069.25,'639','2021-09-15 15:22:50','664','2021-09-15 15:24:43',10,0),('5','182',225177,'Daily shift','2021-09-15','2021-09-15 00:00:00',NULL,'639',413181.75,409659.75,'639','2021-09-17 14:39:56','664','2021-09-17 14:44:42',10,0),('5','182',225182,'Daily shift ','2021-09-16','2021-09-16 00:00:00',NULL,'639',373600.30,369847.00,'639','2021-09-17 14:53:30','664','2021-09-17 15:16:57',10,0),('5','182',225194,'Daily sales','2021-09-17','2021-09-17 00:00:00',NULL,'639',402481.25,398606.19,'639','2021-09-23 12:12:20','664','2021-09-23 12:13:14',10,0),('5','182',226600,'DALY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'639',592127.65,587505.51,'639','2021-09-23 12:19:20','664','2021-09-23 12:21:06',10,0),('5','182',226601,'DALY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'639',391646.55,387669.43,'639','2021-09-23 12:38:23','664','2021-09-23 12:40:52',10,0),('5','182',226606,'DALY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'639',492279.65,487176.67,'639','2021-09-23 12:45:34','664','2021-09-23 12:47:06',10,0),('5','182',226611,'DALY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'639',578898.15,574277.89,'639','2021-09-23 13:39:17','664','2021-09-23 13:42:58',10,0),('5','182',226630,'DALY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'639',536612.10,316701244.52,'639','2021-09-23 13:46:56','664','2021-09-23 13:48:35',10,0),('5','182',226656,'DALY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'639',0.00,0.00,'639','2021-10-15 10:05:54','664','2021-10-15 10:10:23',10,0),('5','182',231728,'DALY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'639',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','182',231730,'DALY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'639',90999.00,90999.00,'639','2021-10-15 10:24:12','664','2021-10-15 10:29:38',10,0),('5','182',231734,'DALY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'639',176172.00,176172.00,'639','2021-10-15 10:35:46','664','2021-10-15 10:38:43',10,0),('5','182',231739,'DALY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'639',71733.00,71733.00,'639','2021-10-15 10:46:51','664','2021-10-15 10:52:23',10,0),('5','182',231741,'DALY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'639',60663.00,60663.00,'639','2021-10-15 10:56:09','664','2021-10-15 10:58:10',10,0),('5','182',231743,'DALY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'639',99744.00,103068.80,'639','2021-10-15 11:02:03','664','2021-10-15 11:12:55',10,0),('5','182',231744,'DALY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'639',53538.00,55322.60,'639','2021-10-15 11:15:42','664','2021-10-15 11:17:37',10,0),('5','182',231748,'DALY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'639',85494.00,88343.80,'639','2021-10-15 11:20:38','664','2021-10-15 11:21:33',10,0),('5','182',231752,'DALY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'639',108666.00,112288.20,'639','2021-10-15 11:24:17','664','2021-10-15 11:25:07',10,0),('5','182',231754,'DALY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'639',52740.00,54498.00,'639','2021-10-15 11:28:32','664','2021-10-15 11:29:37',10,0),('5','182',231757,'DALY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'639',40428.00,41775.60,'639','2021-10-15 11:33:22','664','2021-10-15 11:33:54',10,0),('5','182',231760,'DALY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'639',41649.00,43037.30,'639','2021-10-15 11:37:35','664','2021-10-15 11:37:54',10,0),('5','182',231764,'DALY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'639',81090.00,86496.00,'639','2021-10-15 11:45:10','664','2021-10-15 11:46:03',10,0),('5','182',231765,'DALY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'639',411111.96,426076.96,'639','2021-10-15 11:59:56','664','2021-10-15 12:00:46',10,0),('5','182',231770,'DALY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'639',343068.47,348404.27,'639','2021-10-15 12:05:17','664','2021-10-15 12:07:18',10,0),('5','182',231782,'DALY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'639',495956.70,507853.30,'639','2021-10-18 09:33:39','664','2021-10-18 09:55:04',10,0),('5','182',232415,'Daily shift','2021-10-18','2021-10-18 00:00:00',NULL,'639',800192.51,834165.91,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','182',232418,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'639',800192.51,834165.91,'639','2021-10-18 10:07:31','664','2021-10-18 10:08:35',10,0),('5','182',232421,'Daily shift','2021-10-17','2021-10-17 00:00:00',NULL,'639',688625.60,699193.40,'639','2021-10-18 10:11:57','664','2021-10-18 10:12:56',10,0),('5','182',232435,'Daily shift','2021-10-18','2021-10-18 00:00:00',NULL,'639',740399.75,752136.92,'639','2021-10-19 08:53:23','664','2021-10-20 09:15:43',10,0),('5','182',232919,'Daily shift','2021-10-19','2021-10-19 00:00:00',NULL,'639',823788.67,850866.97,'639','2021-10-20 09:25:42','664','2021-10-20 09:38:17',10,0),('5','182',232930,'Daily shift','2021-10-20','2021-10-20 00:00:00',NULL,'639',1042674.78,1077894.48,'639','2021-10-21 09:35:49','664','2021-10-21 09:59:03',10,0),('5','182',233199,'Daily shift','2021-10-21','2021-10-21 00:00:00',NULL,'639',781922.45,817959.80,'639','2021-10-22 09:44:29','664','2021-10-22 10:57:04',10,0),('5','182',233476,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'639',515543.64,526804.44,'639','2021-10-25 09:45:43','664','2021-10-25 10:12:10',10,0),('5','182',234152,'Daily shift','2021-10-23','2021-10-23 00:00:00',NULL,'639',515962.71,533841.66,'639','2021-10-25 10:21:12','664','2021-10-25 10:28:39',10,0),('5','182',234154,'Daily shift','2021-10-24','2021-10-24 00:00:00',NULL,'639',416313.17,420579.17,'639','2021-10-25 10:31:20','664','2021-10-25 10:39:43',10,0),('5','182',234158,'Daily shift','2021-10-25','2021-10-25 00:00:00',NULL,'639',646740.25,652754.50,'639','2021-10-26 08:52:28','664','2021-10-26 09:01:22',10,0),('5','182',234381,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'639',570662.65,591728.40,'639','2021-10-27 09:35:48','664','2021-10-27 10:05:04',10,0),('5','182',234675,'Daily shift','2021-10-27','2021-10-27 00:00:00',NULL,'639',613524.68,626835.60,'639','2021-10-28 09:21:02','664','2021-10-28 09:50:45',10,0),('5','182',234936,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'639',670901.78,716600.55,'639','2021-11-09 14:06:04','664','2021-11-09 14:08:06',10,0),('5','182',237758,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'639',414441.00,437130.90,'639','2021-11-09 14:14:12','664','2021-11-09 14:15:11',10,0),('5','182',237764,'Daily shift','2021-10-30','2021-10-30 00:00:00',NULL,'639',772483.20,782879.10,'639','2021-11-09 14:21:06','664','2021-11-09 14:21:49',10,0),('5','182',237767,'Daily shift','2021-10-31','2021-10-31 00:00:00',NULL,'639',875404.20,877884.15,'639','2021-11-09 14:25:14','664','2021-11-09 14:26:30',10,0),('5','182',237768,'Daily shift','2021-11-01','2021-11-01 00:00:00',NULL,'639',1790123.70,1817325.30,'639','2021-11-09 14:30:41','664','2021-11-09 14:31:20',10,0),('5','182',237769,'Daily shift','2021-11-02','2021-11-02 00:00:00',NULL,'639',3013558.50,3060239.25,'639','2021-11-09 14:34:44','664','2021-11-09 14:35:49',10,0),('5','182',237770,'Daily shift','2021-11-03','2021-11-03 00:00:00',NULL,'639',2065009.65,2092670.25,'639','2021-11-10 09:46:17','664','2021-11-10 09:48:43',10,0),('5','182',237959,'Daily shift','2021-11-04','2021-11-04 00:00:00',NULL,'639',150000.00,172500.00,'639','2021-11-10 09:50:18','664','2021-11-10 09:50:46',10,0),('5','182',237960,'Daily shift','2021-11-05','2021-11-05 00:00:00',NULL,'639',104673.00,120373.95,'639','2021-11-10 09:51:47','664','2021-11-10 09:52:16',10,0),('5','182',237962,'Daily shift','2021-11-06','2021-11-06 00:00:00',NULL,'639',63735.00,73295.25,'639','2021-11-10 09:53:51','664','2021-11-10 09:54:23',10,0),('5','182',237963,'Daily shift','2021-11-07','2021-11-07 00:00:00',NULL,'639',150051.00,172558.65,'639','2021-11-10 09:55:40','664','2021-11-10 09:56:22',10,0),('5','182',237965,'Daily shift','2021-11-08','2021-11-08 00:00:00',NULL,'639',84876.00,97607.40,'639','2021-11-10 09:57:51','664','2021-11-10 09:58:18',10,0),('5','182',237968,'Daily shift','2021-11-09','2021-11-09 00:00:00',NULL,'639',188025.00,216228.75,'639','2021-11-10 09:59:33','664','2021-11-10 10:00:08',10,0),('5','182',237969,'Daily shift','2021-11-10','2021-11-10 00:00:00',NULL,'639',135540.00,155871.00,'639','2021-11-11 12:37:35','664','2021-11-11 13:04:45',10,0),('5','182',238255,'Daily shift','2021-11-11','2021-11-11 00:00:00',NULL,'639',0.00,0.00,'639','2021-11-12 09:46:15','664','2021-11-12 09:51:46',10,0),('5','182',239138,'Daily shift','2021-11-12','2021-11-12 00:00:00',NULL,'639',72189.00,83017.35,'639','2021-11-15 09:11:33','664','2021-11-15 09:42:33',10,0),('5','182',239149,'Daily shift','2021-11-13','2021-11-13 00:00:00',NULL,'639',83349.00,95851.35,'639','2021-11-15 09:46:53','664','2021-11-15 09:47:44',10,0),('5','182',239164,'Daily shift','2021-11-14','2021-11-14 00:00:00',NULL,'639',649915.05,652165.05,'639','2021-11-15 10:57:03','664','2021-11-15 19:11:11',10,0),('5','182',239371,'Daily shift','2021-11-15','2021-11-15 00:00:00',NULL,'639',1753780.05,1753780.05,'639','2021-11-16 09:34:41','664','2021-11-16 10:20:55',10,0),('5','182',239383,'Daily shift','2021-11-16','2021-11-16 00:00:00',NULL,'639',1099652.40,1099652.40,'639','2021-11-17 08:11:57','664','2021-11-17 18:26:42',10,0),('5','182',239841,'Daily shift','2021-11-17','2021-11-17 00:00:00',NULL,'639',1146413.10,1146948.15,'639','2021-11-18 09:01:25','664','2021-11-18 09:56:52',10,0),('5','182',240063,'Daily shift','2021-11-18','2021-11-18 00:00:00',NULL,'639',331580.70,331580.70,'639','2021-11-19 09:30:20','664','2021-11-19 17:34:42',10,0),('5','182',240760,'Daily shift','2021-11-19','2021-11-19 00:00:00',NULL,'639',0.00,0.00,'639','2021-11-22 08:40:50','664','2021-11-22 08:46:34',10,0),('5','182',240763,'Daily shift','2021-11-20','2021-11-20 00:00:00',NULL,'639',952976.25,953876.25,'639','2021-11-22 09:26:00','664','2021-11-22 09:41:25',10,0),('5','182',240777,'Daily shift','2021-11-21','2021-11-21 00:00:00',NULL,'639',1060852.65,1060852.65,'639','2021-11-22 09:44:58','664','2021-11-22 10:57:49',10,0),('5','182',240788,'Daily shift','2021-11-22','2021-11-22 00:00:00',NULL,'639',984513.75,984513.75,'639','2021-11-23 08:16:45','664','2021-11-24 08:51:37',10,0),('5','182',241317,'Daily shift','2021-11-23','2021-11-23 00:00:00',NULL,'639',1108461.75,1108461.75,'639','2021-11-24 09:07:53','664','2021-11-24 14:10:19',10,0),('5','182',241583,'Daily shift','2021-11-25','2021-11-25 00:00:00',NULL,'639',696242.25,696242.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','182',241595,'Daily shift','2021-11-24','2021-11-24 00:00:00',NULL,'639',699326.25,699788.85,'639','2021-11-25 10:36:58','664','2021-11-25 10:43:34',10,0),('5','182',241601,'Daily shift','2021-11-25','2021-11-25 00:00:00',NULL,'639',195244.50,195244.50,'639','2021-11-26 09:26:07','664','2021-11-26 10:29:15',10,0),('5','182',241837,'Daily shift','2021-11-26','2021-11-26 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-01 09:05:03','664','2021-12-01 09:07:53',10,0),('5','182',242995,'Daily shift','2021-11-27','2021-11-27 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-01 09:09:59','664','2021-12-01 09:14:07',10,0),('5','182',242997,'Daily shift','2021-11-28','2021-11-28 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-01 09:15:12','664','2021-12-01 09:16:04',10,0),('5','182',242999,'Daily shift','2021-11-29','2021-11-29 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-01 09:17:10','664','2021-12-01 09:17:57',10,0),('5','182',243000,'Daily shift','2021-11-30','2021-11-30 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-01 09:18:53','664','2021-12-01 19:59:27',10,0),('5','182',243287,'Daily shift','2021-12-01','2021-12-01 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-02 16:07:12','664','2021-12-03 05:34:32',10,0),('5','182',243428,'Daily shift','2021-12-02','2021-12-02 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-03 08:20:05','664','2021-12-06 07:43:23',10,0),('5','182',244101,'Daily shift','2021-12-03','2021-12-03 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-06 07:44:28','664','2021-12-06 07:46:13',10,0),('5','182',244103,'Daily shift','2021-12-04','2021-12-04 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-06 07:48:57','664','2021-12-06 07:49:35',10,0),('5','182',244107,'Daily shift','2021-12-05','2021-12-05 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-06 07:50:54','664','2021-12-06 07:51:41',10,0),('5','182',244110,'Daily shift','2021-12-06','2021-12-06 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-06 18:00:06','664','2021-12-07 06:16:30',10,0),('5','182',244398,'Daily shift','2021-12-07','2021-12-07 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-07 17:34:46','664','2021-12-07 21:45:48',10,0),('5','182',244570,'Daily shift','2021-12-08','2021-12-08 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-08 19:57:09','664','2021-12-09 08:27:16',10,0),('5','182',244817,'Daily shift','2021-12-09','2021-12-09 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-10 03:46:56','664','2021-12-10 09:22:47',10,0),('5','182',245107,'Daily shift','2021-12-10','2021-12-10 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-10 17:53:34','664','2021-12-11 17:30:03',10,0),('5','182',245380,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-11 17:54:33','664','2021-12-11 20:37:48',10,0),('5','182',245487,'Daily shift','2021-12-12','2021-12-12 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-12 16:46:44','664','2021-12-13 11:12:17',10,0),('5','182',245788,'Daily shift','2021-12-13','2021-12-13 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-13 17:09:01','664','2021-12-14 08:38:12',10,0),('5','182',246033,'Daily shift','2021-12-14','2021-12-14 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-14 21:49:07','664','2021-12-15 09:03:16',10,0),('5','182',246273,'Daily shift','2021-12-15','2021-12-15 00:00:00',NULL,'639',233743.95,233743.95,'639','2021-12-15 19:43:27','664','2021-12-16 08:39:04',10,0),('5','182',246529,'Daily shift','2021-12-16','2021-12-16 00:00:00',NULL,'639',528199.80,530365.20,'639','2021-12-16 19:33:35','664','2021-12-17 09:10:34',10,0),('5','182',246776,'Daily shift','2021-12-17','2021-12-17 00:00:00',NULL,'639',424812.30,424812.30,'639','2021-12-17 17:46:27','664','2021-12-18 06:53:39',10,0),('5','182',247117,'Daily shift','2021-12-18','2021-12-18 00:00:00',NULL,'639',433326.30,433326.30,'639','2021-12-18 18:03:28','664','2021-12-19 17:33:59',10,0),('5','182',247354,'Daily shift','2021-12-19','2021-12-19 00:00:00',NULL,'639',373781.10,373781.10,'639','2021-12-19 19:03:09','664','2021-12-20 06:12:59',10,0),('5','182',247408,'Daily shift','2021-12-20','2021-12-20 00:00:00',NULL,'639',360289.05,360289.05,'639','2021-12-20 17:55:57','664','2021-12-20 18:02:24',10,0),('5','182',247725,'Daily shift','2021-12-21','2021-12-21 00:00:00',NULL,'639',99460.35,99460.35,'639','2021-12-21 19:12:51','664','2021-12-22 09:54:24',10,0),('5','182',248015,'Daily shift','2021-12-22','2021-12-22 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-22 17:55:11','664','2021-12-22 18:17:19',10,0),('5','182',248174,'Daily shift','2021-12-23','2021-12-23 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-23 19:43:33','664','2021-12-24 14:08:58',10,0),('5','182',248563,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-24 16:57:21','664','2021-12-25 17:04:47',10,0),('5','182',248812,'Daily shift','2021-12-25','2021-12-25 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-25 17:35:41','664','2021-12-26 07:26:02',10,0),('5','182',248970,'Daily shift','2021-12-26','2021-12-26 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-26 19:13:12','664','2021-12-27 05:58:23',10,0),('5','182',249206,'Daily shift','2021-12-27','2021-12-27 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-27 17:47:30','664','2021-12-28 09:21:56',10,0),('5','182',249484,'Daily shift','2021-12-28','2021-12-28 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-28 18:21:17','664','2021-12-29 06:58:40',10,0),('5','182',249794,'Daily shift','2021-12-29','2021-12-29 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-29 18:52:19','664','2021-12-30 06:45:46',10,0),('5','182',250123,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-31 07:02:48','664','2021-12-31 09:25:20',10,0),('5','182',250185,'Daily shift','2021-12-31','2021-12-31 00:00:00',NULL,'639',0.00,0.00,'639','2021-12-31 22:11:15','664','2022-01-01 07:42:15',10,0),('5','182',250407,'Daily shift','2022-01-01','2022-01-01 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-01 21:32:57','664','2022-01-02 08:06:45',10,0),('5','182',250737,'Daily shift','2022-01-02','2022-01-02 00:00:00',NULL,'639',637150.80,637150.80,'639','2022-01-03 09:31:49','664','2022-01-03 09:34:39',10,0),('5','182',250878,'Daily shift','2022-01-03','2022-01-03 00:00:00',NULL,'639',594585.75,594585.75,'639','2022-01-03 18:13:36','664','2022-01-04 08:41:21',10,0),('5','182',251088,'Daily shift','2022-01-04','2022-01-04 00:00:00',NULL,'639',876166.50,876166.50,'639','2022-01-04 17:51:36','664','2022-01-04 19:02:24',10,0),('5','182',251370,'Daily shift','2022-01-05','2022-01-05 00:00:00',NULL,'639',568169.25,568169.25,'639','2022-01-05 19:05:47','664','2022-01-06 09:24:54',10,0),('5','182',251622,'Daily shift','2022-01-06','2022-01-06 00:00:00',NULL,'639',523818.90,523818.90,'639','2022-01-06 21:01:48','664','2022-01-07 07:02:29',10,0),('5','182',251832,'Daily shift','2022-01-07','2022-01-07 00:00:00',NULL,'639',528658.35,528658.35,'639','2022-01-08 20:32:53','664','2022-01-09 15:50:52',10,0),('5','182',252450,'Daily shift','2022-01-08','2022-01-08 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-09 22:49:53','664','2022-01-10 08:25:49',10,0),('5','182',252580,'Daily shift','2022-01-09','2022-01-09 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-10 11:46:37','664','2022-01-10 11:47:40',10,0),('5','182',252582,'Daily shift','2022-01-10','2022-01-10 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-10 19:05:10','664','2022-01-11 08:19:27',10,0),('5','182',252935,'Daily shift','2022-01-11','2022-01-11 00:00:00',NULL,'639',196734.45,196734.45,'639','2022-01-12 18:08:28','664','2022-01-12 19:41:42',10,0),('5','182',253152,'Daily shift','2022-01-12','2022-01-12 00:00:00',NULL,'639',634286.40,634286.40,'639','2022-01-12 21:10:17','664','2022-01-13 07:30:46',10,0),('5','182',253265,'Daily shift','2022-01-13','2022-01-13 00:00:00',NULL,'639',954143.85,954143.85,'639','2022-01-13 21:53:01','664','2022-01-14 06:37:36',10,0),('5','182',253516,'Daily shift','2022-01-14','2022-01-14 00:00:00',NULL,'639',830276.70,830276.70,'639','2022-01-15 09:37:42','664','2022-01-15 09:58:13',10,0),('5','182',253948,'Daily shift','2022-01-15','2022-01-15 00:00:00',NULL,'639',760277.10,760277.10,'639','2022-01-16 06:52:50','664','2022-01-16 06:54:11',10,0),('5','182',253958,'Daily shift','2022-01-16','2022-01-16 00:00:00',NULL,'639',1349683.50,1349683.50,'639','2022-01-16 19:40:52','664','2022-01-17 07:09:26',10,0),('5','182',254281,'Daily shift','2022-01-17','2022-01-17 00:00:00',NULL,'639',966147.60,966147.60,'639','2022-01-17 19:59:28','664','2022-01-18 07:07:22',10,0),('5','182',254481,'Daily shift','2022-01-18','2022-01-18 00:00:00',NULL,'639',560488.50,560488.50,'639','2022-01-18 20:22:18','664','2022-01-19 06:04:20',10,0),('5','182',254717,'Daily shift','2022-01-19','2022-01-19 00:00:00',NULL,'639',781331.10,781331.10,'639','2022-01-19 19:11:21','664','2022-01-20 06:34:28',10,0),('5','182',254947,'Daily shift','2022-01-20','2022-01-20 00:00:00',NULL,'639',157344.00,157344.00,'639','2022-01-20 19:10:40','664','2022-01-21 11:16:06',10,0),('5','182',255284,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-21 23:00:24','664','2022-01-22 09:19:21',10,0),('5','182',255531,'Daily shift','2022-01-22','2022-01-22 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-22 17:19:21','664','2022-01-23 07:29:43',10,0),('5','182',255740,'Daily shift','2022-01-23','2022-01-23 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-23 20:44:07','664','2022-01-24 07:38:52',10,0),('5','182',255981,'Daily shift','2022-01-24','2022-01-24 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-25 06:42:57','664','2022-01-25 08:23:08',10,0),('5','182',256362,'Daily shift','2022-01-25','2022-01-25 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-25 18:52:55','664','2022-01-26 06:10:03',10,0),('5','182',256511,'Daily shift','2022-01-26','2022-01-26 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-26 20:56:54','664','2022-01-27 07:07:21',10,0),('5','182',256764,'Daily shift','2022-01-27','2022-01-27 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-27 18:11:49','664','2022-01-28 06:36:06',10,0),('5','182',256959,'Daily shift','2022-01-28','2022-01-28 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-28 20:53:17','664','2022-01-29 07:13:11',10,0),('5','182',257270,'Daily shift','2022-01-29','2022-01-29 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-29 18:01:40','664','2022-01-29 23:07:54',10,0),('5','182',257489,'Daily shift','2022-01-30','2022-01-30 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-30 17:40:16','664','2022-01-31 09:19:10',10,0),('5','182',257490,'Daily shift','2022-01-31','2022-01-31 00:00:00',NULL,'639',0.00,0.00,'639','2022-01-31 18:02:20','664','2022-02-02 19:21:07',10,0),('5','182',257491,'Daily shift','2022-02-01','2022-02-01 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-02 19:26:41','664','2022-02-02 19:28:29',10,0),('5','182',257492,'Daily shift','2022-02-02','2022-02-02 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-02 19:29:04','664','2022-02-02 19:33:49',10,0),('5','182',257493,'Daily shift','2022-02-03','2022-02-03 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-08 05:33:39','664','2022-02-08 07:21:04',10,0),('5','182',257494,'Daily shift','2022-02-04','2022-02-04 00:00:00',NULL,'639',326467.35,326467.35,'639','2022-02-08 09:50:52','664','2022-02-08 10:01:53',10,0),('5','182',257495,'Daily shift','2022-02-05','2022-02-05 00:00:00',NULL,'639',753622.65,753622.65,'639','2022-02-08 10:05:44','664','2022-02-08 10:06:26',10,0),('5','182',257496,'Daily shift','2022-02-06','2022-02-06 00:00:00',NULL,'639',670178.85,670178.85,'639','2022-02-08 10:08:51','664','2022-02-08 10:09:52',10,0),('5','182',257497,'Daily shift','2022-02-07','2022-02-07 00:00:00',NULL,'639',670652.40,670652.40,'639','2022-02-08 10:11:34','664','2022-02-08 10:12:23',10,0),('5','182',257498,'Daily shift','2022-02-08','2022-02-08 00:00:00',NULL,'639',221454.75,221454.75,'639','2022-02-08 20:45:58','664','2022-02-08 21:59:17',10,0),('5','182',257499,'Daily shift','2022-02-09','2022-02-09 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-09 18:02:04','664','2022-02-09 20:57:44',10,0),('5','182',257500,'Daily shift','2022-02-10','2022-02-10 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-10 21:11:50','664','2022-02-10 21:44:53',10,0),('5','182',257501,'Daily shift','2022-02-11','2022-02-11 00:00:00',NULL,'639',179949.00,179949.00,'639','2022-02-11 22:42:10','664','2022-02-11 22:46:58',10,0),('5','182',257502,'Daily shift','2022-02-12','2022-02-12 00:00:00',NULL,'639',826879.35,826879.35,'639','2022-02-12 19:45:15','664','2022-02-13 08:48:51',10,0),('5','182',257503,'Daily shift','2022-02-13','2022-02-13 00:00:00',NULL,'639',841396.05,841396.05,'639','2022-02-13 21:24:27','664','2022-02-14 06:10:49',10,0),('5','182',257504,'Daily shift','2022-02-14','2022-02-14 00:00:00',NULL,'639',868281.15,868281.15,'639','2022-02-14 21:19:45','664','2022-02-14 23:50:14',10,0),('5','182',257505,'Daily shift','2022-02-15','2022-02-15 00:00:00',NULL,'639',838645.50,838645.50,'639','2022-02-16 06:51:14','664','2022-02-16 07:59:57',10,0),('5','182',257506,'Daily shift','2022-02-16','2022-02-16 00:00:00',NULL,'639',107992.50,107992.50,'639','2022-02-17 06:43:14','664','2022-02-17 09:27:14',10,0),('5','182',257507,'Daily shift','2022-02-17','2022-02-17 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-17 22:26:27','664','2022-02-18 07:59:42',10,0),('5','182',257508,'Daily shift','2022-02-18','2022-02-18 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-18 19:26:31','664','2022-02-19 07:20:24',10,0),('5','182',257509,'Daily shift','2022-02-19','2022-02-19 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-19 19:38:37','664','2022-02-19 21:54:54',10,0),('5','182',257510,'Daily shift','2022-02-20','2022-02-20 00:00:00',NULL,'639',0.00,0.00,'639','2022-02-20 17:23:15','664','2022-02-21 07:24:14',10,0),('5','182',257511,'Daily shift','2022-02-21','2022-02-21 00:00:00',NULL,'639',148417.50,148417.50,'639','2022-02-21 20:43:25','664','2022-02-22 06:56:12',10,0),('5','182',257512,'Daily shift','2022-02-22','2022-02-22 08:10:46','2022-02-23 08:10:46','639',1424435.10,1424435.10,'639','2022-02-22 20:41:58','664','2022-02-23 07:14:01',10,0),('5','182',257513,'Daily shift','2022-02-23','2022-02-23 11:39:23','2022-02-24 11:39:23','639',1412470.95,1412470.95,'639','2022-02-23 21:41:22','664','2022-02-24 07:59:49',10,0),('5','182',257514,'Daily shift','2022-02-24','2022-02-24 08:26:33','2022-02-25 08:26:33','639',1500805.35,1500805.35,'639','2022-02-24 22:04:42','664','2022-02-25 06:49:07',10,0),('5','182',257515,'Daily shift','2022-02-25','2022-02-25 07:43:50','2022-02-26 07:43:50','639',1052785.80,1052785.80,'639','2022-02-25 21:18:24','664','2022-02-26 07:19:06',10,0),('5','182',257516,'Daily shift','2022-02-26','2022-02-26 07:45:57','2022-02-27 07:45:57','639',3044505.75,3044505.75,'639','2022-02-26 21:02:54','664','2022-02-27 09:17:09',10,0),('5','182',257517,'Daily shift','2022-02-27','2022-02-27 21:02:25','2022-02-28 21:02:25','639',1660642.50,1660642.50,'639','2022-02-27 21:03:53','664','2022-02-27 23:59:59',10,0),('5','182',257518,'Daily shift','2022-02-28','2022-02-28 20:21:19','2022-03-01 20:21:19','639',1297482.45,1297482.45,'639','2022-02-28 21:14:04','664','2022-02-28 21:38:47',10,0),('5','182',257519,'Daily shift','2022-03-01','2022-03-01 08:47:07','2022-03-02 08:47:07','639',2560207.65,2560207.65,'639','2022-03-02 15:10:57','664','2022-03-02 15:14:04',10,0),('5','182',257520,'Daily shift','2022-03-02','2022-03-02 21:05:29','2022-03-03 21:05:29','639',965646.00,965646.00,'639','2022-03-02 22:07:15','664','2022-03-02 22:25:01',10,0),('5','182',257521,'Daily shift','2022-03-03','2022-03-03 05:30:19','2022-03-04 05:30:19','639',802690.35,802690.35,'639','2022-03-03 21:13:39','664','2022-03-04 08:21:59',10,0),('5','182',257522,'Daily shift','2022-03-04','2022-03-04 09:59:25','2022-03-05 09:59:25','639',183488.25,183488.25,'639','2022-03-04 21:27:13','664','2022-03-05 06:51:43',10,0),('5','182',257523,'Daily shift','2022-03-05','2022-03-05 09:16:03','2022-03-06 09:16:03','639',0.00,0.00,'639','2022-03-05 20:41:33','664','2022-03-06 06:03:59',10,0),('5','182',257524,'Daily shift','2022-03-06','2022-03-06 12:21:38','2022-03-07 12:21:38','639',0.00,0.00,'639','2022-03-07 17:41:36','664','2022-03-07 20:10:39',10,0),('5','182',257525,'Daily shift','2022-03-07','2022-03-07 22:30:05','2022-03-08 22:30:05','639',0.00,0.00,'639','2022-03-07 22:30:23','664','2022-03-08 07:57:08',10,0),('5','182',257526,'Daily shift','2022-03-08','2022-03-08 08:26:32','2022-03-09 08:26:32','639',0.00,0.00,'639','2022-03-08 22:31:56','664','2022-03-09 07:52:30',10,0),('5','182',257527,'Daily shift','2022-03-09','2022-03-09 09:24:14','2022-03-10 09:24:14','639',0.00,0.00,'639','2022-03-09 20:46:14','664','2022-03-10 07:41:35',10,0),('5','182',257528,'Daily shift','2022-03-10','2022-03-10 12:53:27','2022-03-11 12:53:27','639',0.00,0.00,'639','2022-03-10 21:45:09','664','2022-03-11 08:56:32',10,0),('5','182',257529,'Daily shift','2022-03-11','2022-03-11 23:24:47','2022-03-12 23:24:47','639',0.00,0.00,'639','2022-03-11 23:25:02','664','2022-03-12 07:41:27',10,0),('5','182',257530,'Daily shift','2022-03-12','2022-03-12 23:13:07','2022-03-13 23:13:07','639',0.00,0.00,'639','2022-03-12 23:13:49','664','2022-03-13 12:16:37',10,0),('5','182',257531,'Daily shift','2022-03-13','2022-03-13 20:50:39','2022-03-14 20:50:39','639',0.00,0.00,'639','2022-03-13 20:50:55','664','2022-03-14 06:06:53',10,0),('5','182',257532,'Daily shift','2022-03-14','2022-03-14 23:12:27','2022-03-15 23:12:27','639',0.00,0.00,'639','2022-03-14 23:12:47','664','2022-03-15 06:01:38',10,0),('5','182',257533,'Daily shift','2022-03-15','2022-03-15 21:33:32','2022-03-16 21:33:32','639',0.00,0.00,'639','2022-03-15 21:33:51','664','2022-03-16 08:14:50',10,0),('5','182',257534,'Daily shift','2022-03-16','2022-03-16 21:44:52','2022-03-17 21:44:52','639',0.00,0.00,'639','2022-03-16 21:45:08','664','2022-03-17 08:13:06',10,0),('5','182',257535,'Daily shift','2022-03-17','2022-03-17 22:33:35','2022-03-18 22:33:35','639',0.00,0.00,'639','2022-03-17 22:33:59','664','2022-03-18 07:39:51',10,0),('5','182',257536,'Daily shift','2022-03-18','2022-03-18 22:09:51','2022-03-19 22:09:51','639',123750.00,123750.00,'639','2022-03-18 22:11:37','664','2022-03-19 07:08:54',10,0),('5','182',257537,'Daily shift','2022-03-19','2022-03-19 15:09:43','2022-03-20 15:09:43','639',679852.80,679852.80,'639','2022-03-19 21:42:16','664','2022-03-20 08:39:44',10,0),('5','182',257538,'Daily shift','2022-03-20','2022-03-20 22:00:32','2022-03-21 22:00:32','639',505923.00,505923.00,'639','2022-03-20 22:01:39','664','2022-03-21 07:08:14',10,0),('5','182',257539,'Daily shift','2022-03-21','2022-03-21 09:21:51','2022-03-22 09:21:51','639',676830.00,676830.00,'639','2022-03-21 21:38:47','664','2022-03-22 07:33:18',10,0),('5','182',257540,'Daily shift','2022-03-22','2022-03-22 14:21:16','2022-03-23 14:21:16','639',247085.85,247085.85,'639','2022-03-22 19:09:00','664','2022-03-23 07:55:42',10,0),('5','182',257541,'Daily shift','2022-03-23','2022-03-23 15:28:31','2022-03-24 15:28:31','639',0.00,0.00,'639','2022-03-24 06:54:42','664','2022-03-24 08:00:39',10,0),('5','182',257542,'Daily shift','2022-03-24','2022-03-24 15:15:23','2022-03-25 15:15:23','639',116310.15,116310.15,'639','2022-03-24 20:59:25','664','2022-03-25 06:46:51',10,0),('5','182',257543,'Daily shift','2022-03-25','2022-03-25 11:08:08','2022-03-26 11:08:08','639',906354.90,906354.90,'639','2022-03-25 21:48:30','664','2022-03-26 04:56:35',10,0),('5','182',257544,'Daily shift','2022-03-26','2022-03-26 12:10:20','2022-03-27 12:10:20','639',1202543.10,1202543.10,'639','2022-03-26 22:06:54','664','2022-03-27 07:57:42',10,0),('5','182',257545,'Daily shift','2022-03-27','2022-03-27 15:58:45','2022-03-28 15:58:45','639',634677.45,634677.45,'639','2022-03-28 08:18:40','664','2022-03-28 08:27:29',10,0),('5','182',257546,'Daily shift','2022-03-28','2022-03-28 09:19:37','2022-03-29 09:19:37','639',0.00,0.00,'639','2022-03-29 06:16:47','664','2022-03-29 07:57:07',10,0),('5','182',257547,'Daily shift','2022-03-29','2022-03-29 09:47:02','2022-03-30 09:47:02','639',0.00,0.00,'639','2022-03-29 21:26:21','664','2022-03-30 06:37:44',10,0),('5','182',257548,'Daily shift','2022-03-30','2022-03-30 11:57:43','2022-03-31 11:57:43','639',0.00,0.00,'639','2022-03-30 18:32:28','664','2022-03-31 10:58:35',10,0),('5','182',257549,'Daily shift','2022-03-31','2022-03-31 19:23:20','2022-04-01 19:23:20','639',0.00,0.00,'639','2022-03-31 19:23:38','664','2022-04-01 10:05:44',10,0),('5','182',257550,'Daily shift','2022-04-01','2022-04-01 17:32:47','2022-04-02 17:32:47','639',0.00,0.00,'639','2022-04-01 17:33:04','664','2022-04-02 08:37:27',10,0),('5','182',257551,'Daily shift','2022-04-02','2022-04-02 11:59:15','2022-04-03 11:59:15','639',0.00,0.00,'639','2022-04-03 10:34:38','664','2022-04-03 10:38:26',10,0),('5','182',257552,'Daily shift','2022-04-03','2022-04-03 10:39:04','2022-04-04 10:39:04','639',0.00,0.00,'639','2022-04-03 17:19:30','664','2022-04-04 07:46:05',10,0),('5','182',257553,'Daily shift','2022-04-04','2022-04-04 09:48:55','2022-04-05 09:48:55','639',0.00,0.00,'639','2022-04-04 19:08:19','664','2022-04-05 09:05:22',10,0),('5','182',257554,'Daily shift','2022-04-05','2022-04-05 12:09:14','2022-04-06 12:09:14','639',0.00,0.00,'639','2022-04-05 18:25:16','664','2022-04-06 08:21:30',10,0),('5','182',257555,'Daily shift','2022-04-06','2022-04-06 20:42:32','2022-04-07 20:42:32','639',0.00,0.00,'639','2022-04-06 20:42:52','664','2022-04-07 07:50:00',10,0),('5','182',257556,'Daily shift','2022-04-07','2022-04-07 09:42:06','2022-04-08 09:42:06','639',0.00,0.00,'639','2022-04-07 21:58:44','664','2022-04-08 04:09:24',10,0),('5','182',257557,'Daily shift','2022-04-08','2022-04-08 09:26:23','2022-04-09 09:26:23','639',0.00,0.00,'639','2022-04-08 21:58:48','664','2022-04-09 09:35:31',10,0),('5','182',257558,'Daily shift','2022-04-09','2022-04-09 21:54:53','2022-04-10 21:54:53','639',0.00,0.00,'639','2022-04-09 21:55:06','664','2022-04-10 00:16:26',10,0),('5','182',257559,'Daily shift','2022-04-10','2022-04-10 10:43:24','2022-04-11 10:43:24','639',0.00,0.00,'639','2022-04-10 21:28:18','664','2022-04-11 03:59:59',10,0),('5','182',257560,'Daily shift','2022-04-11','2022-04-11 09:40:29','2022-04-12 09:40:29','639',0.00,0.00,'639','2022-04-11 19:24:27','664','2022-04-12 12:48:45',10,0),('5','182',257561,'Daily shift','2022-04-12','2022-04-12 19:37:38','2022-04-13 19:37:38','639',0.00,0.00,'639','2022-04-12 19:37:55','664','2022-04-13 04:06:32',10,0),('5','182',257562,'Daily shift','2022-04-13','2022-04-13 20:22:04','2022-04-14 20:22:04','639',0.00,0.00,'639','2022-04-13 20:22:19','664','2022-04-14 03:30:46',10,0),('5','182',257563,'Daily shift it','2022-04-14','2022-04-14 13:23:04','2022-04-15 13:23:04','639',0.00,0.00,'639','2022-04-14 19:46:29','664','2022-04-15 05:50:08',10,0),('5','182',257564,'Daily shift','2022-04-15','2022-04-15 19:30:23','2022-04-16 19:30:23','639',0.00,0.00,'639','2022-04-15 19:30:38','664','2022-04-16 05:14:18',10,0),('5','182',257565,'Daily shift','2022-04-16','2022-04-16 18:14:04','2022-04-17 18:14:04','639',0.00,0.00,'639','2022-04-16 18:14:37','664','2022-04-17 09:55:56',10,0),('5','182',257566,'Daily shift','2022-04-17','2022-04-17 19:12:57','2022-04-18 19:12:57','639',0.00,0.00,'639','2022-04-17 19:13:09','664','2022-04-18 00:00:38',10,0),('5','182',257567,'Daily shift','2022-04-18','2022-04-19 07:30:40','2022-04-20 07:30:40','639',0.00,0.00,'639','2022-04-19 07:30:55','664','2022-04-19 07:52:58',10,0),('5','182',257568,'Daily shift','2022-04-19','2022-04-19 08:28:01','2022-04-20 08:28:01','639',755178.60,755178.60,'639','2022-04-19 22:13:32','664','2022-04-20 04:52:10',10,0),('5','182',257569,'Daily shift','2022-04-20','2022-04-20 09:46:28','2022-04-21 09:46:28','639',1292563.80,1292563.80,'639','2022-04-20 20:58:37','664','2022-04-21 04:26:27',10,0),('5','182',257570,'Daily shift','2022-04-21','2022-04-21 06:26:48','2022-04-22 06:26:48','639',290862.00,290862.00,'639','2022-04-21 21:08:38','664','2022-04-22 06:11:19',10,0),('5','182',257571,'Daily shift','2022-04-22','2022-04-22 13:57:31','2022-04-23 13:57:31','639',205260.00,205260.00,'639','2022-04-23 07:31:37','664','2022-04-23 08:33:03',10,0),('5','182',257572,'Daily shift','2022-04-23','2022-04-23 08:39:04','2022-04-24 08:39:04','639',709673.25,709673.25,'639','2022-04-23 21:40:08','664','2022-04-24 03:10:23',10,0),('5','182',257573,'Daily shift','2022-04-24','2022-04-24 04:24:01','2022-04-25 04:24:01','639',838028.40,838028.40,'639','2022-04-24 20:52:46','664','2022-04-25 03:49:35',10,0),('5','182',257574,'Daily shift','2022-04-25','2022-04-25 19:33:34','2022-04-26 19:33:34','639',660412.50,660412.50,'639','2022-04-25 19:34:22','664','2022-04-26 02:17:39',10,0),('5','182',257575,'Daily shift','2022-04-26','2022-04-26 07:38:27','2022-04-27 07:38:27','639',891125.40,891125.40,'639','2022-04-26 19:31:10','664','2022-04-27 03:39:35',10,0),('5','182',257576,'Daily shift','2022-04-27','2022-04-27 08:53:30','2022-04-28 08:53:30','639',1084510.35,1084510.35,'639','2022-04-27 19:27:13','664','2022-04-28 02:28:32',10,0),('5','182',257577,'Daily shift','2022-04-28','2022-04-28 07:45:28','2022-04-29 07:45:28','639',690764.25,690764.25,'639','2022-04-28 21:00:21','664','2022-04-29 06:05:21',10,0),('5','182',257578,'Daily shift','2022-04-29','2022-04-29 11:17:00','2022-04-30 11:17:00','639',1030847.40,1030847.40,'639','2022-04-29 21:32:55','664','2022-04-30 00:04:51',10,0),('5','182',257579,'Daily shift','2022-04-30','2022-05-09 11:31:13','2022-05-10 11:31:13','639',1234076.25,1234076.25,'639','2022-05-09 11:32:08','664','2022-05-09 11:34:37',10,0),('5','182',257580,'Daily shift','2022-05-01','2022-05-09 11:35:11','2022-05-10 11:35:11','639',1173521.25,1173521.25,'639','2022-05-09 11:35:53','664','2022-05-09 11:38:31',10,0),('5','182',257581,'Daily shift','2022-05-02','2022-05-09 11:39:25','2022-05-10 11:39:25','639',668807.70,668807.70,'639','2022-05-09 12:31:41','664','2022-05-09 12:40:06',10,0),('5','182',257582,'Daily shift','2022-05-03','2022-05-09 12:43:33','2022-05-10 12:43:33','639',1186493.55,1186493.55,'639','2022-05-09 13:08:50','664','2022-05-09 13:09:55',10,0),('5','182',257583,'Daily shift','2022-05-04','2022-05-09 13:10:23','2022-05-10 13:10:23','639',841823.40,841823.40,'639','2022-05-09 13:11:02','664','2022-05-09 13:12:07',10,0),('5','182',257584,'Daily shift','2022-05-05','2022-05-09 13:12:39','2022-05-10 13:12:39','639',843415.65,843415.65,'639','2022-05-09 13:13:27','664','2022-05-09 13:14:32',10,0),('5','182',257585,'Daily shift','2022-05-06','2022-05-09 13:14:55','2022-05-10 13:14:55','639',830954.85,830954.85,'639','2022-05-09 13:15:32','664','2022-05-09 13:16:17',10,0),('5','182',257586,'Daily shift','2022-05-07','2022-05-09 13:16:44','2022-05-10 13:16:44','639',671089.65,671089.65,'639','2022-05-09 13:17:27','664','2022-05-09 13:19:05',10,0),('5','182',257587,'Daily shift','2022-05-08','2022-05-09 13:19:33','2022-05-10 13:19:33','639',627371.25,627371.25,'639','2022-05-09 13:20:28','664','2022-05-09 13:21:10',10,0),('5','182',257588,'Daily shift','2022-05-09','2022-05-09 13:35:15','2022-05-10 13:35:15','639',294417.75,294417.75,'639','2022-05-09 19:13:14','664','2022-05-10 06:50:24',10,0),('5','182',257589,'Daily shifted','2022-05-10','2022-05-10 08:25:25','2022-05-11 08:25:25','639',0.00,0.00,'639','2022-05-10 18:45:07','664','2022-05-10 22:53:53',10,0),('5','182',257590,'Daily shift','2022-05-11','2022-05-11 06:01:52','2022-05-12 06:01:52','639',0.00,0.00,'639','2022-05-11 19:32:33','664','2022-05-12 05:33:30',10,0),('5','182',257591,'Daily shift','2022-05-12','2022-05-12 05:51:49','2022-05-13 05:51:49','639',0.00,0.00,'639','2022-05-12 19:15:39','664','2022-05-12 22:43:42',10,0),('5','182',257592,'Daily shift','2022-05-13','2022-05-13 07:11:15','2022-05-14 07:11:15','639',0.00,0.00,'639','2022-05-13 19:44:58','664','2022-05-13 22:28:01',10,0),('5','182',257593,'Daily shift','2022-05-14','2022-05-14 06:13:21','2022-05-15 06:13:21','639',0.00,0.00,'639','2022-05-14 18:16:00','664','2022-05-15 06:12:07',10,0),('5','182',257594,'Daily shift','2022-05-15','2022-05-15 09:06:18','2022-05-16 09:06:18','639',0.00,0.00,'639','2022-05-15 22:51:26','664','2022-05-16 06:04:21',10,0),('5','182',257595,'Daily shift','2022-05-16','2022-05-16 06:18:54','2022-05-17 06:18:54','639',0.00,0.00,'639','2022-05-16 21:08:56','600','2022-05-17 06:14:05',10,0),('5','182',257596,'Daily shift','2022-05-17','2022-05-17 07:40:43','2022-05-18 07:40:43','639',0.00,0.00,'639','2022-05-17 19:56:57','600','2022-05-18 06:13:58',10,0),('5','182',257597,'Daily shift','2022-05-18','2022-05-18 07:10:41','2022-05-19 07:10:41','639',0.00,0.00,'639','2022-05-18 17:37:01','600','2022-05-18 21:32:32',10,0),('5','182',257598,'Daily shift','2022-05-19','2022-05-19 06:19:21','2022-05-20 06:19:21','639',0.00,0.00,'639','2022-05-19 20:15:48','600','2022-05-19 21:00:42',10,0),('5','182',257599,'Daily shift','2022-05-20','2022-05-20 07:04:47','2022-05-21 07:04:47','639',0.00,0.00,'639','2022-05-20 19:23:40','600','2022-05-20 21:26:06',10,0),('5','182',257600,'Daily shift','2022-05-21','2022-05-21 07:07:42','2022-05-22 07:07:42','639',0.00,0.00,'639','2022-05-21 21:32:21','600','2022-05-22 08:16:23',10,0),('5','182',257601,'Daily shift','2022-05-22','2022-05-22 13:32:50','2022-05-23 13:32:50','639',0.00,0.00,'639','2022-05-22 19:14:55','664','2022-05-23 05:18:14',10,0),('5','182',257602,'Daily shift','2022-05-23','2022-05-23 06:05:10','2022-05-24 06:05:10','639',0.00,0.00,'639','2022-05-23 22:30:30','600','2022-05-24 08:02:59',10,0),('5','182',257603,'Daily shift','2022-05-24','2022-05-24 20:08:16','2022-05-25 20:08:16','639',0.00,0.00,'639','2022-05-24 20:08:32','600','2022-05-25 06:12:40',10,0),('5','182',257604,'Daily shift','2022-05-25','2022-05-25 07:09:30','2022-05-26 07:09:30','639',414646.65,414646.65,'639','2022-05-26 10:01:37','600','2022-05-26 10:02:51',10,0),('5','182',257605,'Daily shift','2022-05-26','2022-05-26 10:08:02','2022-05-27 10:08:02','639',729268.65,729268.65,'639','2022-05-26 21:26:26','600','2022-05-27 05:28:10',10,0),('5','182',257606,'Daily shift','2022-05-27','2022-05-27 11:22:42','2022-05-28 11:22:42','639',758798.70,758798.70,'639','2022-05-27 20:43:48','664','2022-05-28 05:00:02',10,0),('5','182',257607,'Daily shift','2022-05-28','2022-05-28 07:48:48','2022-05-29 07:48:48','639',784604.70,784604.70,'639','2022-05-28 21:50:16','600','2022-05-29 08:19:07',10,0),('5','182',257608,'Daily shift','2022-05-29','2022-05-29 22:03:12','2022-05-30 22:03:12','639',766903.50,766903.50,'639','2022-05-29 22:05:04','664','2022-05-30 05:01:18',10,0),('5','182',257609,'Daily shift','2022-05-30','2022-05-30 17:12:17','2022-05-31 17:12:17','639',703074.90,703074.90,'639','2022-05-30 23:25:24','664','2022-05-31 00:22:17',10,0),('5','182',257610,'Daily shift','2022-05-31','2022-05-31 12:23:55','2022-06-01 12:23:55','639',687258.00,687258.00,'639','2022-06-01 06:05:00','664','2022-06-01 07:06:31',10,0),('5','182',257611,'Daily shift','2022-06-01','2022-06-01 08:14:08','2022-06-02 08:14:08','639',662508.00,662508.00,'639','2022-06-02 00:37:43','664','2022-06-02 05:02:39',10,0),('5','182',257612,'Daily shift','2022-06-02','2022-06-02 07:41:04','2022-06-03 07:41:04','639',338547.00,338547.00,'639','2022-06-02 22:46:39','664','2022-06-03 06:49:23',10,0),('5','182',257613,'Daily shift','2022-06-03','2022-06-03 11:13:13','2022-06-04 11:13:13','639',264778.80,264778.80,'639','2022-06-03 23:45:56','664','2022-06-04 06:09:14',10,0),('5','182',257614,'Daily shift','2022-06-04','2022-06-05 06:42:35','2022-06-06 06:42:35','639',0.00,0.00,'639','2022-06-05 06:42:51','664','2022-06-05 08:11:23',10,0),('5','182',257615,'Daily shift','2022-06-05','2022-06-05 15:39:51','2022-06-06 15:39:51','639',0.00,0.00,'639','2022-06-05 21:38:14','664','2022-06-06 06:30:55',10,0),('5','182',257616,'Daily shift','2022-06-06','2022-06-06 09:52:57','2022-06-07 09:52:57','639',619525.50,619525.50,'639','2022-06-07 10:10:45','664','2022-06-07 10:20:43',10,0),('5','182',257617,'Daily shift','2022-06-07','2022-06-07 13:06:55','2022-06-08 13:06:55','639',895522.65,895522.65,'639','2022-06-07 20:50:05','664','2022-06-08 10:33:15',10,0),('5','182',257618,'Daily shift','2022-06-08','2022-06-08 14:05:37','2022-06-09 14:05:37','639',691249.35,691249.35,'639','2022-06-08 21:41:03','664','2022-06-09 06:03:23',10,0),('5','182',257619,'Daily shift','2022-06-09','2022-06-09 22:02:07','2022-06-10 22:02:07','639',808412.55,808412.55,'639','2022-06-10 06:30:07','664','2022-06-10 08:22:04',10,0),('5','182',257620,'Daily shift','2022-06-10','2022-06-10 21:42:07','2022-06-11 21:42:07','639',818142.60,818142.60,'639','2022-06-10 21:43:48','664','2022-06-10 21:47:04',10,0),('5','182',257621,'Daily shift','2022-06-11','2022-06-11 07:50:37','2022-06-12 07:50:37','639',693607.20,693607.20,'639','2022-06-11 19:24:29','664','2022-06-12 08:32:42',10,0),('5','182',257622,'Daily shift','2022-06-12','2022-06-12 21:29:49','2022-06-13 21:29:49','639',661415.70,661415.70,'639','2022-06-12 21:31:20','664','2022-06-13 06:56:07',10,0),('5','182',257623,'Daily shift','2022-06-13','2022-06-14 06:10:21','2022-06-15 06:10:21','639',693785.40,693785.40,'639','2022-06-14 07:06:38','664','2022-06-14 09:00:35',10,0),('5','182',257624,'Daily shift','2022-06-14','2022-06-14 12:51:25','2022-06-15 12:51:25','639',714788.25,714788.25,'639','2022-06-15 05:50:59','664','2022-06-15 07:35:09',10,0),('5','182',257625,'Daily shift','2022-06-15','2022-06-15 12:47:01','2022-06-16 12:47:01','639',0.00,0.00,'639','2022-06-15 18:23:41','664','2022-06-16 07:04:39',10,0),('5','182',257626,'Daily shift','2022-06-16','2022-06-16 22:50:01','2022-06-17 22:50:01','639',0.00,0.00,'639','2022-06-16 22:50:21','664','2022-06-17 06:02:01',10,0),('5','182',257627,'Daily shift','2022-06-17','2022-06-17 08:45:34','2022-06-18 08:45:34','639',0.00,0.00,'639','2022-06-17 19:51:44','664','2022-06-18 07:05:58',10,0),('5','182',257628,'Daily shift','2022-06-18','2022-06-18 15:31:21','2022-06-19 15:31:21','639',0.00,0.00,'639','2022-06-18 15:55:36','664','2022-06-18 22:50:58',10,0),('5','182',257629,'Daily shift','2022-06-19','2022-06-19 22:14:20','2022-06-20 22:14:20','639',0.00,0.00,'639','2022-06-19 22:14:34','664','2022-06-20 06:48:22',10,0),('5','182',257630,'Daily shift','2022-06-20','2022-06-20 07:15:11','2022-06-21 07:15:11','639',0.00,0.00,'639','2022-06-20 21:17:56','664','2022-06-21 07:56:19',10,0),('5','182',257631,'Daily shift','2022-06-21','2022-06-21 18:38:24','2022-06-22 18:38:24','639',0.00,0.00,'639','2022-06-21 18:38:42','664','2022-06-21 22:48:51',10,0),('5','182',257632,'Daily shift','2022-06-22','2022-06-22 08:25:04','2022-06-23 08:25:04','639',0.00,0.00,'639','2022-06-22 21:41:35','664','2022-06-23 07:09:12',10,0),('5','182',257633,'Daily shift','2022-06-23','2022-06-23 10:37:46','2022-06-24 10:37:46','639',0.00,0.00,'639','2022-06-23 20:56:13','664','2022-06-23 22:53:37',10,0),('5','182',257634,'Daily shift','2022-06-24','2022-06-24 08:42:16','2022-06-25 08:42:16','639',0.00,0.00,'639','2022-06-24 20:09:18','664','2022-06-25 06:16:27',10,0),('5','182',257635,'Daily shift','2022-06-25','2022-06-25 21:17:35','2022-06-26 21:17:35','639',0.00,0.00,'639','2022-06-25 21:17:55','664','2022-06-26 07:17:25',10,0),('5','182',257636,'Daily shift','2022-06-26','2022-06-26 08:34:16','2022-06-27 08:34:16','639',0.00,0.00,'639','2022-06-26 19:20:28','664','2022-06-27 07:37:45',10,0),('5','182',257637,'Daily shift','2022-06-27','2022-06-27 07:57:27','2022-06-28 07:57:27','639',0.00,0.00,'639','2022-06-27 20:56:38','664','2022-06-28 07:24:28',10,0),('5','182',257638,'Daily shift','2022-06-28','2022-06-28 10:34:31','2022-06-29 10:34:31','639',0.00,0.00,'639','2022-06-28 19:19:57','664','2022-06-29 08:04:17',10,0),('5','182',257639,'Daily shift','2022-06-29','2022-06-29 08:12:26','2022-06-30 08:12:26','639',0.00,0.00,'639','2022-06-29 21:13:07','664','2022-06-30 06:26:22',10,0),('5','182',257640,'Daily shift','2022-06-30','2022-06-30 07:49:00','2022-07-01 07:49:00','639',0.00,0.00,'639','2022-06-30 16:53:07','664','2022-07-01 07:12:07',10,0),('5','182',257641,'Daily shift','2022-07-01','2022-07-01 07:23:56','2022-07-02 07:23:56','639',0.00,0.00,'639','2022-07-01 18:36:50','664','2022-07-02 05:51:07',10,0),('5','182',257642,'Daily shift','2022-07-02','2022-07-02 06:59:54','2022-07-03 06:59:54','639',0.00,0.00,'639','2022-07-02 20:25:11','664','2022-07-03 06:31:34',10,0),('5','182',257643,'Daily shift','2022-07-03','2022-07-03 09:22:38','2022-07-04 09:22:38','639',0.00,0.00,'639','2022-07-03 17:43:35','664','2022-07-03 23:26:58',10,0),('5','182',257644,'Daily shift','2022-07-04','2022-07-04 06:59:17','2022-07-05 06:59:17','639',0.00,0.00,'639','2022-07-04 16:30:24','664','2022-07-04 22:37:15',10,0),('5','182',257645,'Daily shift','2022-07-05','2022-07-05 06:52:00','2022-07-06 06:52:00','639',0.00,0.00,'639','2022-07-05 22:04:37','664','2022-07-06 07:51:19',10,0),('5','182',257646,'Daily shift','2022-07-06','2022-07-06 09:07:31','2022-07-07 09:07:31','639',0.00,0.00,'639','2022-07-06 20:39:45','664','2022-07-07 05:28:48',10,0),('5','182',257647,'Daily shift','2022-07-07','2022-07-07 07:45:13','2022-07-08 07:45:13','639',0.00,0.00,'639','2022-07-07 14:37:50','664','2022-07-08 06:12:10',10,0),('5','182',257648,'Daily shift','2022-07-08','2022-07-08 07:37:57','2022-07-09 07:37:57','639',0.00,0.00,'639','2022-07-08 18:17:46','664','2022-07-08 22:44:06',10,0),('5','182',257649,'Daily shift','2022-07-09','2022-07-09 06:59:14','2022-07-10 06:59:14','639',0.00,0.00,'639','2022-07-09 13:42:48','664','2022-07-10 07:06:24',10,0),('5','182',257650,'Daily shift','2022-07-10','2022-07-10 09:36:33','2022-07-11 09:36:33','639',0.00,0.00,'639','2022-07-10 22:00:12','664','2022-07-11 07:02:26',10,0),('5','182',257651,'Daily shift','2022-07-11','2022-07-11 07:02:56','2022-07-12 07:02:56','639',0.00,0.00,'639','2022-07-11 22:37:38','664','2022-07-12 05:24:36',10,0),('5','182',257652,'Daily shifts','2022-07-12','2022-07-12 08:33:34','2022-07-13 08:33:34','639',0.00,0.00,'639','2022-07-12 21:28:06','664','2022-07-13 07:20:17',10,0),('5','182',257653,'Daily shift','2022-07-13','2022-07-13 07:33:22','2022-07-14 07:33:22','639',524475.00,524475.00,'639','2022-07-14 08:37:00','664','2022-07-14 09:48:54',10,0),('5','182',257654,'Daily shift','2022-07-14','2022-07-14 13:01:19','2022-07-15 13:01:19','639',784873.60,784873.60,'639','2022-07-14 19:42:08','664','2022-07-15 07:19:44',10,0),('5','182',257655,'Daily shift','2022-07-15','2022-07-15 07:24:27','2022-07-16 07:24:27','639',783850.55,783850.55,'639','2022-07-15 18:32:29','664','2022-07-16 06:56:06',10,0),('5','182',257656,'Daily shift','2022-07-16','2022-07-16 08:26:55','2022-07-17 08:26:55','639',935767.00,935767.00,'639','2022-07-16 21:40:50','664','2022-07-17 05:31:27',10,0),('5','182',257657,'Daily shift','2022-07-17','2022-07-17 06:14:30','2022-07-18 06:14:30','639',1014319.85,1014319.85,'639','2022-07-18 02:30:23','664','2022-07-18 07:37:04',10,0),('5','182',257658,'Daily shift','2022-07-18','2022-07-18 09:14:45','2022-07-19 09:14:45','639',1172045.30,1172045.30,'639','2022-07-18 21:09:45','664','2022-07-19 05:05:04',10,0),('5','182',257659,'Daily shift','2022-07-19','2022-07-19 06:29:32','2022-07-20 06:29:32','639',846326.90,846326.90,'639','2022-07-19 22:05:45','664','2022-07-20 07:42:07',10,0),('5','182',257660,'Daily shift','2022-07-20','2022-07-20 11:25:11','2022-07-21 11:25:11','639',944652.55,944652.55,'639','2022-07-20 20:01:14','664','2022-07-21 06:51:07',10,0),('5','182',257661,'Daily shift','2022-07-21','2022-07-21 07:16:50','2022-07-22 07:16:50','639',748698.70,748698.70,'639','2022-07-21 20:06:09','664','2022-07-21 23:12:49',10,0),('5','182',257662,'Daily shift','2022-07-22','2022-07-22 08:46:12','2022-07-23 08:46:12','639',1255946.50,1255946.50,'639','2022-07-23 12:42:12','664','2022-07-23 13:45:50',10,0),('5','182',257663,'Daily shifts','2022-07-23','2022-07-23 15:43:52','2022-07-24 15:43:52','639',756753.60,756753.60,'639','2022-07-23 21:13:49','664','2022-07-24 08:33:54',10,0),('5','182',257664,'Daily shift','2022-07-24','2022-07-24 08:57:44','2022-07-25 08:57:44','639',0.00,0.00,'639','2022-07-24 20:43:42','664','2022-07-25 06:46:34',10,0),('5','182',257665,'Daily shift','2022-07-25','2022-07-25 06:59:49','2022-07-26 06:59:49','639',753736.25,753736.25,'639','2022-07-25 20:54:13','664','2022-07-26 05:55:52',10,0),('5','182',257666,'Daily shift','2022-07-26','2022-07-26 07:42:55','2022-07-27 07:42:55','639',1174426.25,1174426.25,'639','2022-07-26 20:34:52','664','2022-07-27 06:06:33',10,0),('5','182',257667,'Daily shift','2022-07-27','2022-07-27 07:35:14','2022-07-28 07:35:14','639',1127678.60,1127678.60,'639','2022-07-27 20:45:34','664','2022-07-28 06:56:31',10,0),('5','182',257668,'Daily shift','2022-07-28','2022-07-28 10:58:48','2022-07-29 10:58:48','639',751236.90,751236.90,'639','2022-07-28 21:19:36','664','2022-07-29 07:14:05',10,0),('5','182',257669,'Daily shift','2022-07-29','2022-07-29 08:07:32','2022-07-30 08:07:32','639',377007.80,377007.80,'639','2022-07-29 21:22:03','664','2022-07-30 05:50:30',10,0),('5','182',257670,'Daily shift','2022-07-30','2022-07-30 07:08:10','2022-07-31 07:08:10','639',0.00,0.00,'639','2022-07-30 17:58:54','664','2022-07-31 05:25:21',10,0),('5','182',257671,'Daily shift','2022-07-31','2022-07-31 10:07:31','2022-08-01 10:07:31','639',0.00,0.00,'639','2022-07-31 21:12:05','664','2022-08-01 07:54:51',10,0),('5','182',257672,'Daily shift','2022-08-01','2022-08-01 08:08:26','2022-08-02 08:08:26','639',0.00,0.00,'639','2022-08-01 20:58:08','664','2022-08-02 05:40:31',10,0),('5','182',257673,'Daily shift','2022-08-02','2022-08-02 06:55:02','2022-08-03 06:55:02','639',747671.95,747671.95,'639','2022-08-02 20:46:59','664','2022-08-03 07:00:46',10,0),('5','182',257674,'Daily shift','2022-08-03','2022-08-03 10:25:47','2022-08-04 10:25:47','639',791465.15,791465.15,'639','2022-08-03 20:19:02','664','2022-08-04 06:16:53',10,0),('5','182',257675,'Daily shift','2022-08-04','2022-08-04 07:32:21','2022-08-05 07:32:21','639',790880.55,790880.55,'639','2022-08-04 20:42:04','664','2022-08-04 21:51:54',10,0),('5','182',257676,'Daily shift','2022-08-05','2022-08-05 06:17:31','2022-08-06 06:17:31','639',442897.40,442897.40,'639','2022-08-05 20:59:24','664','2022-08-06 06:54:42',10,0),('5','182',257677,'Daily shift','2022-08-06','2022-08-06 07:39:28','2022-08-07 07:39:28','639',0.00,0.00,'639','2022-08-06 18:11:51','664','2022-08-07 05:38:50',10,0),('5','182',257678,'Daily shift','2022-08-07','2022-08-07 06:11:26','2022-08-08 06:11:26','639',0.00,0.00,'639','2022-08-07 16:13:35','664','2022-09-03 22:01:29',10,0),('5','182',257679,'Daily shift','2022-08-08','2022-09-03 22:14:42','2022-09-04 22:14:42','639',0.00,0.00,'639','2022-09-03 22:15:34','664','2022-09-04 00:06:59',10,0),('5','182',257680,'Daily shift','2022-08-09','2022-09-04 10:38:20','2022-09-05 10:38:20','639',648807.95,648807.95,'639','2022-09-04 11:09:58','664','2022-09-04 11:14:13',10,0),('5','182',257681,'Daily shift','2022-08-10','2022-09-04 11:14:49','2022-09-05 11:14:49','639',813816.85,813816.85,'639','2022-09-04 11:15:54','664','2022-09-04 11:19:33',10,0),('5','182',257682,'Daily shift','2022-08-11','2022-09-04 11:20:10','2022-09-05 11:20:10','639',752953.70,752953.70,'639','2022-09-04 11:20:47','664','2022-09-04 11:22:46',10,0),('5','182',257683,'Daily shift','2022-08-12','2022-09-04 11:23:21','2022-09-05 11:23:21','639',283960.20,283960.20,'639','2022-09-04 11:24:17','664','2022-09-04 11:26:05',10,0),('5','182',257684,'Daily shift','2022-08-13','2022-09-04 11:28:49','2022-09-05 11:28:49','639',0.00,0.00,'639','2022-09-04 11:29:02','664','2022-09-04 11:40:29',10,0),('5','182',257685,'Daily shift','2022-08-14','2022-09-04 11:44:09','2022-09-05 11:44:09','639',603257.25,603257.25,'639','2022-09-04 11:44:49','664','2022-09-04 12:23:21',10,0),('5','182',257686,'Daily shift','2022-08-15','2022-09-04 14:18:32','2022-09-05 14:18:32','639',763609.70,763609.70,'639','2022-09-04 14:19:37','664','2022-09-05 06:53:20',10,0),('5','182',257687,'Daily shift','2022-08-16','2022-09-05 11:29:38','2022-09-06 11:29:38','639',850300.70,850300.70,'639','2022-09-05 11:30:39','664','2022-09-05 11:33:33',10,0),('5','182',257688,'Daily shift','2022-08-17','2022-09-05 11:37:47','2022-09-06 11:37:47','639',360661.20,360661.20,'639','2022-09-05 11:38:45','664','2022-09-05 11:39:20',10,0),('5','182',257689,'Daily shift','2022-08-18','2022-09-05 11:39:53','2022-09-06 11:39:53','639',1099216.35,1099216.35,'639','2022-09-05 11:41:39','664','2022-09-05 11:42:17',10,0),('5','182',257690,'Daily shift','2022-08-19','2022-09-05 12:03:40','2022-09-06 12:03:40','639',482348.65,482348.65,'639','2022-09-05 12:04:45','664','2022-09-05 12:06:27',10,0),('5','182',257691,'Daily shift','2022-08-20','2022-09-05 12:07:21','2022-09-06 12:07:21','639',512453.70,512453.70,'639','2022-09-05 12:08:07','664','2022-09-05 12:11:48',10,0),('5','182',257692,'Daily shift','2022-08-21','2022-09-05 12:13:38','2022-09-06 12:13:38','639',772177.05,772177.05,'639','2022-09-05 12:15:25','664','2022-09-05 12:17:13',10,0),('5','182',257693,'Daily shift','2022-08-22','2022-09-05 12:18:05','2022-09-06 12:18:05','639',563889.25,563889.25,'639','2022-09-05 12:19:07','664','2022-09-05 12:21:19',10,0),('5','182',257694,'Daily shift','2022-08-23','2022-09-05 12:21:49','2022-09-06 12:21:49','639',827107.25,827107.25,'639','2022-09-05 12:22:55','664','2022-09-05 12:23:55',10,0),('5','182',257695,'Daily shift','2022-08-24','2022-09-05 12:24:49','2022-09-06 12:24:49','639',887309.95,887309.95,'639','2022-09-05 12:25:51','664','2022-09-05 12:29:07',10,0),('5','182',257696,'Daily shift','2022-08-25','2022-09-05 12:30:22','2022-09-06 12:30:22','639',619050.70,619050.70,'639','2022-09-05 12:30:55','664','2022-09-05 12:32:27',10,0),('5','182',257697,'Daily shift','2022-08-26','2022-09-05 12:33:05','2022-09-06 12:33:05','639',373577.90,373577.90,'639','2022-09-05 12:33:40','664','2022-09-05 12:35:49',10,0),('5','182',257698,'Daily shift','2022-08-27','2022-09-05 12:36:17','2022-09-06 12:36:17','639',596958.00,596958.00,'639','2022-09-05 12:37:29','664','2022-09-05 12:40:00',10,0),('5','182',257699,'Daily shift','2022-08-28','2022-09-05 12:40:30','2022-09-06 12:40:30','639',659441.75,659441.75,'639','2022-09-05 12:41:58','664','2022-09-05 12:42:43',10,0),('5','182',257700,'Daily shift','2022-08-29','2022-09-05 12:43:25','2022-09-06 12:43:25','639',1013368.95,1013368.95,'639','2022-09-05 12:44:29','664','2022-09-05 12:45:10',10,0),('5','182',257701,'Daily shift','2022-08-30','2022-09-05 12:45:57','2022-09-06 12:45:57','639',649076.20,649076.20,'639','2022-09-05 12:47:03','664','2022-09-05 12:47:38',10,0),('5','182',257702,'Daily shift','2022-08-31','2022-09-05 12:48:19','2022-09-06 12:48:19','639',972182.40,972182.40,'639','2022-09-05 12:49:24','664','2022-09-05 12:50:11',10,0),('5','182',257703,'Daily shift','2022-09-01','2022-09-05 12:50:31','2022-09-06 12:50:31','639',1123342.20,1123342.20,'639','2022-09-05 12:51:22','664','2022-09-05 13:08:16',10,0),('5','182',257704,'Daily shift','2022-09-02','2022-09-05 13:17:54','2022-09-06 13:17:54','639',930326.15,930326.15,'639','2022-09-05 13:18:52','664','2022-09-05 13:20:10',10,0),('5','182',257705,'Daily shift','2022-09-03','2022-09-05 13:20:49','2022-09-06 13:20:49','639',788908.45,788908.45,'639','2022-09-05 13:21:48','664','2022-09-05 13:22:35',10,0),('5','182',257706,'Daily shift','2022-09-04','2022-09-05 13:23:05','2022-09-06 13:23:05','639',1011200.75,1011200.75,'639','2022-09-05 13:23:38','664','2022-09-05 13:24:51',10,0),('5','182',257707,'Daily shift','2022-09-05','2022-09-05 13:25:44','2022-09-06 13:25:44','639',553967.70,553967.70,'639','2022-09-06 10:18:36','664','2022-09-06 10:31:02',10,0),('5','182',257708,'Daily shift','2022-09-06','2022-09-06 11:44:50','2022-09-07 11:44:50','639',1063095.10,1063095.10,'639','2022-09-07 10:21:15','664','2022-09-07 10:25:24',10,0),('5','182',257709,'Daily shift','2022-09-07','2022-09-07 10:43:46','2022-09-08 10:43:46','639',1045309.20,1045309.20,'639','2022-09-07 20:53:49','664','2022-09-08 07:12:31',10,0),('5','182',257710,'Daily shift','2022-09-08','2022-09-08 09:00:08','2022-09-09 09:00:08','639',848731.90,848731.90,'639','2022-09-08 19:18:02','664','2022-09-09 08:19:25',10,0),('5','182',257711,'Daily shift','2022-09-09','2022-09-09 09:03:47','2022-09-10 09:03:47','639',616318.25,616318.25,'639','2022-09-09 19:17:01','664','2022-09-10 09:42:37',10,0),('5','182',257712,'Daily shift','2022-09-10','2022-09-10 11:28:46','2022-09-11 11:28:46','639',782501.90,782501.90,'639','2022-09-10 20:28:15','664','2022-09-11 08:57:17',10,0),('5','182',257713,'Daily shift','2022-09-11','2022-09-11 12:27:15','2022-09-12 12:27:15','639',1433431.80,1433431.80,'639','2022-09-11 19:45:19','664','2022-09-12 08:57:43',10,0),('5','182',257714,'Daily shift','2022-09-12','2022-09-12 10:20:02','2022-09-13 10:20:02','639',1206571.85,1206571.85,'639','2022-09-12 19:44:51','664','2022-09-13 09:16:40',10,0),('5','182',257715,'Daily shift','2022-09-13','2022-09-13 09:39:10','2022-09-14 09:39:10','639',345002.80,345002.80,'639','2022-09-14 09:46:18','664','2022-09-14 09:53:33',10,0),('5','182',257716,'Daily shift','2022-09-14','2022-09-14 11:35:29','2022-09-15 11:35:29','639',0.00,0.00,'639','2022-09-14 19:30:02','664','2022-09-15 08:53:58',10,0),('5','182',257717,'Daily shift','2022-09-15','2022-09-15 13:24:17','2022-09-16 13:24:17','639',0.00,0.00,'639','2022-09-15 19:01:18','664','2022-09-16 09:10:44',10,0),('5','182',257718,'Daily shift','2022-09-16','2022-09-16 09:29:42','2022-09-17 09:29:42','639',0.00,0.00,'639','2022-09-16 21:38:41','664','2022-09-17 10:14:50',10,0),('5','182',257719,'Daily shift','2022-09-17','2022-09-17 10:20:51','2022-09-18 10:20:51','639',561460.20,561460.20,'639','2022-09-17 20:53:58','664','2022-09-18 07:22:52',10,0),('5','182',257720,'Daily shift','2022-09-18','2022-09-18 07:38:18','2022-09-19 07:38:18','639',919842.20,919842.20,'639','2022-09-18 21:19:18','664','2022-09-19 07:21:16',10,0),('5','182',257721,'Daily shift','2022-09-19','2022-09-19 09:10:00','2022-09-20 09:10:00','639',632657.45,632657.45,'639','2022-09-19 20:31:04','664','2022-09-20 08:34:50',10,0),('5','182',257722,'Daily shift','2022-09-20','2022-09-20 09:29:44','2022-09-21 09:29:44','639',1136336.60,1136336.60,'639','2022-09-20 20:43:53','664','2022-09-21 11:52:55',10,0),('5','182',257723,'Daily shift','2022-09-21','2022-09-21 15:06:57','2022-09-22 15:06:57','639',1033903.95,1033903.95,'639','2022-09-21 21:34:40','664','2022-09-22 07:41:17',10,0),('5','182',257724,'Daily shifts','2022-09-22','2022-09-22 10:45:14','2022-09-23 10:45:14','639',785680.20,785680.20,'639','2022-09-22 18:56:26','664','2022-09-23 07:52:10',10,0),('5','182',257725,'Daily shift','2022-09-23','2022-09-23 10:03:30','2022-09-24 10:03:30','639',746393.60,746393.60,'639','2022-09-23 20:21:30','664','2022-09-23 22:42:08',10,0),('5','182',257726,'Daily shift','2022-09-24','2022-09-24 08:34:32','2022-09-25 08:34:32','639',1041790.50,1041790.50,'639','2022-09-24 19:18:03','664','2022-09-25 08:06:26',10,0),('5','182',257727,'Daily shift','2022-09-25','2022-09-25 11:58:59','2022-09-26 11:58:59','639',761448.90,761448.90,'639','2022-09-25 20:02:19','664','2022-09-26 07:19:11',10,0),('5','182',257728,'Daily shift','2022-09-26','2022-09-26 09:27:12','2022-09-27 09:27:12','639',659195.70,659195.70,'639','2022-09-27 12:24:14','664','2022-09-27 12:25:18',10,0),('5','182',257729,'Daily shift','2022-09-27','2022-09-27 12:25:55','2022-09-28 12:25:55','639',627973.25,627973.25,'639','2022-09-27 20:21:58','664','2022-09-28 08:24:46',10,0),('5','182',257730,'Daily shift','2022-09-28','2022-09-28 08:34:27','2022-09-29 08:34:27','639',879782.30,879782.30,'639','2022-09-28 19:58:49','664','2022-09-29 08:37:33',10,0),('5','182',257731,'Daily shift','2022-09-29','2022-09-29 10:10:46','2022-09-30 10:10:46','639',1226076.40,1226076.40,'639','2022-09-29 20:09:16','664','2022-09-30 08:12:15',10,0),('5','182',257732,'Daily shift','2022-09-30','2022-09-30 10:20:49','2022-10-01 10:20:49','639',1143938.25,1143938.25,'639','2022-09-30 19:26:26','664','2022-09-30 21:44:54',10,0),('5','182',257733,'Daily shift','2022-10-01','2022-10-01 08:03:18','2022-10-02 08:03:18','639',1400910.65,1400910.65,'639','2022-10-01 19:22:41','664','2022-10-02 06:44:44',10,0),('5','182',257734,'Daily shift','2022-10-02','2022-10-02 08:51:25','2022-10-03 08:51:25','639',1211378.15,1211378.15,'639','2022-10-02 18:26:05','664','2022-10-03 06:26:24',10,0),('5','182',257735,'Daily shift','2022-10-03','2022-10-03 13:56:26','2022-10-04 13:56:26','639',1161783.35,1161783.35,'639','2022-10-03 20:42:24','664','2022-10-04 07:13:16',10,0),('5','182',257736,'Daily shift','2022-10-04','2022-10-04 07:49:13','2022-10-05 07:49:13','639',934331.40,934331.40,'639','2022-10-04 20:00:59','664','2022-10-05 09:41:34',10,0),('5','182',257737,'Daily shift','2022-10-05','2022-10-05 17:10:18','2022-10-06 17:10:18','639',563532.20,563532.20,'639','2022-10-06 11:47:43','664','2022-10-06 11:50:00',10,0),('5','182',257738,'Daily shift','2022-10-06','2022-10-06 13:51:59','2022-10-07 13:51:59','639',0.00,0.00,'639','2022-10-06 20:42:39','664','2022-10-06 21:17:21',10,0),('5','182',257739,'Daily shift','2022-10-07','2022-10-07 07:27:14','2022-10-08 07:27:14','639',0.00,0.00,'639','2022-10-07 19:50:13','664','2022-10-08 08:38:54',10,0),('5','182',257740,'Daily shift','2022-10-08','2022-10-08 10:04:22','2022-10-09 10:04:22','639',40790.65,40790.65,'639','2022-10-08 22:08:55','664','2022-10-09 08:33:44',10,0),('5','182',257741,'Daily shift','2022-10-09','2022-10-09 12:12:44','2022-10-10 12:12:44','639',0.00,0.00,'639','2022-10-09 19:48:23','664','2022-10-10 12:18:06',10,0),('5','182',257742,'Daily shift','2022-10-10','2022-10-10 13:57:00','2022-10-11 13:57:00','639',0.00,0.00,'639','2022-10-10 18:33:38','664','2022-10-11 07:07:34',10,0),('5','182',257743,'Daily shift','2022-10-11','2022-10-11 08:12:59','2022-10-12 08:12:59','639',0.00,0.00,'639','2022-10-11 19:35:48','664','2022-10-12 10:06:31',10,0),('5','182',257744,'Daily shift','2022-10-12','2022-10-12 10:59:27','2022-10-13 10:59:27','639',0.00,0.00,'639','2022-10-12 19:23:08','664','2022-10-12 22:18:19',10,0),('5','182',257745,'Daily shift','2022-10-13','2022-10-13 08:28:14','2022-10-14 08:28:14','639',0.00,0.00,'639','2022-10-14 20:26:09','664','2022-10-15 06:25:27',10,0),('5','182',257746,'Daily shift','2022-10-14','2022-10-15 08:07:00','2022-10-16 08:07:00','639',0.00,0.00,'639','2022-10-15 08:07:17','664','2022-10-15 20:34:20',10,0),('5','182',257747,'Daily shift','2022-10-15','2022-10-16 09:40:40','2022-10-17 09:40:40','639',0.00,0.00,'639','2022-10-16 09:41:03','664','2022-10-17 07:38:51',10,0),('5','182',257748,'Daily shift','2022-10-16','2022-10-17 14:48:08','2022-10-18 14:48:08','639',0.00,0.00,'639','2022-10-17 14:48:22','664','2022-10-17 19:05:26',10,0),('5','182',257749,'Daily shift','2022-10-17','2022-10-17 22:24:26','2022-10-18 22:24:26','639',0.00,0.00,'639','2022-10-17 22:24:50','664','2022-10-18 07:46:35',10,0),('5','182',257750,'Daily shift','2022-10-18','2022-10-18 09:20:00','2022-10-19 09:20:00','639',0.00,0.00,'639','2022-10-18 18:29:46','664','2022-10-19 07:42:35',10,0),('5','182',257751,'Daily shift','2022-10-19','2022-10-19 11:37:25','2022-10-20 11:37:25','639',0.00,0.00,'639','2022-10-19 15:49:31','664','2022-10-20 07:06:00',10,0),('5','182',257752,'Daily shift','2022-10-20','2022-10-20 11:35:51','2022-10-21 11:35:51','639',0.00,0.00,'639','2022-10-20 17:45:12','664','2022-10-21 07:45:34',10,0),('5','182',257753,'Daily shift','2022-10-21','2022-10-21 08:14:30','2022-10-22 08:14:30','639',0.00,0.00,'639','2022-10-21 15:43:22','664','2022-10-22 06:18:14',10,0),('5','182',257754,'Daily shift','2022-10-22','2022-10-22 11:32:57','2022-10-23 11:32:57','639',0.00,0.00,'639','2022-10-22 18:49:44','664','2022-10-23 08:14:01',10,0),('5','182',257755,'Daily shift','2022-10-23','2022-10-23 08:43:09','2022-10-24 08:43:09','639',0.00,0.00,'639','2022-10-23 19:31:56','664','2022-10-24 07:26:13',10,0),('5','182',257756,'Daily shift','2022-10-24','2022-10-24 08:07:35','2022-10-25 08:07:35','639',0.00,0.00,'639','2022-10-24 18:26:05','664','2022-10-25 07:24:43',10,0),('5','182',257757,'Daily shift','2022-10-25','2022-10-25 08:59:53','2022-10-26 08:59:53','639',0.00,0.00,'639','2022-10-25 16:56:45','664','2022-10-26 07:25:30',10,0),('5','182',257758,'Daily shift','2022-10-26','2022-10-26 08:27:05','2022-10-27 08:27:05','639',0.00,0.00,'639','2022-10-26 20:10:08','664','2022-10-27 07:16:13',10,0),('5','182',257759,'Daily shift','2022-10-27','2022-10-27 08:50:46','2022-10-28 08:50:46','639',0.00,0.00,'639','2022-10-27 18:29:38','664','2022-10-28 06:56:31',10,0),('5','182',257760,'Daily shift','2022-10-28','2022-10-28 07:44:52','2022-10-29 07:44:52','639',0.00,0.00,'639','2022-10-28 14:32:05','664','2022-10-29 07:57:50',10,0),('5','182',257761,'Daily shift','2022-10-29','2022-10-29 10:09:05','2022-10-30 10:09:05','639',0.00,0.00,'639','2022-10-29 16:05:16','664','2022-10-30 06:38:08',10,0),('5','182',257762,'Daily shift','2022-10-30','2022-10-30 08:19:57','2022-10-31 08:19:57','639',0.00,0.00,'639','2022-10-30 18:55:11','664','2022-10-31 06:47:33',10,0),('5','182',257763,'Daily shift','2022-10-31','2022-10-31 08:01:29','2022-11-01 08:01:29','639',0.00,0.00,'639','2022-10-31 17:43:32','664','2022-11-01 06:43:28',10,0),('5','182',257764,'Daily shift','2022-11-01','2022-11-01 08:59:19','2022-11-02 08:59:19','639',0.00,0.00,'639','2022-11-01 19:18:21','664','2022-11-02 06:30:15',10,0),('5','182',257765,'Daily shift','2022-11-02','2022-11-02 08:31:19','2022-11-03 08:31:19','639',0.00,0.00,'639','2022-11-02 18:34:05','664','2022-11-03 08:17:39',10,0),('5','182',257766,'Daily shift','2022-11-03','2022-11-03 08:50:32','2022-11-04 08:50:32','639',0.00,0.00,'639','2022-11-03 19:29:55','664','2022-11-04 07:35:03',10,0),('5','182',257767,'Daily shift','2022-11-04','2022-11-04 08:52:51','2022-11-05 08:52:51','639',0.00,0.00,'639','2022-11-04 20:18:07','664','2022-11-05 09:44:36',10,0),('5','182',257768,'Daily shift','2022-11-05','2022-11-05 12:46:49','2022-11-06 12:46:49','639',0.00,0.00,'639','2022-11-05 19:24:27','664','2022-11-06 07:12:40',10,0),('5','182',257769,'Daily shift','2022-11-06','2022-11-06 08:15:15','2022-11-07 08:15:15','639',0.00,0.00,'639','2022-11-06 19:21:51','664','2022-11-07 09:24:33',10,0),('5','182',257770,'Daily shift','2022-11-07','2022-11-07 15:01:46','2022-11-08 15:01:46','639',0.00,0.00,'639','2022-11-07 15:02:18','664','2022-11-08 07:13:07',10,0),('5','182',257771,'Daily shift','2022-11-08','2022-11-08 08:08:41','2022-11-09 08:08:41','639',0.00,0.00,'639','2022-11-08 21:05:15','664','2022-11-09 08:14:44',10,0),('5','182',257772,'Daily shift','2022-11-09','2022-11-09 09:05:35','2022-11-10 09:05:35','639',0.00,0.00,'639','2022-11-09 19:36:51','664','2022-11-10 09:30:56',10,0),('5','182',257773,'Daily shift','2022-11-10','2022-11-10 10:03:30','2022-11-11 10:03:30','639',0.00,0.00,'639','2022-11-10 17:43:56','664','2022-11-11 07:54:24',10,0),('5','182',257774,'Daily shift','2022-11-11','2022-11-11 08:12:32','2022-11-12 08:12:32','639',0.00,0.00,'639','2022-11-11 20:30:26','664','2022-11-12 08:17:12',10,0),('5','182',257775,'Daily shift','2022-11-12','2022-11-12 10:47:52','2022-11-13 10:47:52','639',0.00,0.00,'639','2022-11-12 19:37:44','664','2022-11-13 09:53:03',10,0),('5','182',257776,'Daily shift','2022-11-13','2022-11-13 13:10:58','2022-11-14 13:10:58','639',0.00,0.00,'639','2022-11-13 19:16:30','664','2022-11-14 05:38:58',10,0),('5','182',257777,'Daily shifts','2022-11-14','2022-11-14 08:15:26','2022-11-15 08:15:26','639',0.00,0.00,'639','2022-11-14 18:57:21','664','2022-11-15 07:46:35',10,0),('5','182',257778,'Daily shift','2022-11-15','2022-11-15 08:50:34','2022-11-16 08:50:34','639',0.00,0.00,'639','2022-11-15 16:00:39','664','2022-11-16 07:36:48',10,0),('5','182',257779,'Daily shift','2022-11-16','2022-11-16 11:04:12','2022-11-17 11:04:12','639',0.00,0.00,'639','2022-11-16 19:15:06','664','2022-11-17 08:15:23',10,0),('5','182',257780,'Daily shift','2022-11-17','2022-11-17 21:44:31','2022-11-18 21:44:31','639',0.00,0.00,'639','2022-11-17 21:44:48','664','2022-11-18 07:36:41',10,0),('5','182',257781,'Daily shift','2022-11-18','2022-11-18 10:49:54','2022-11-19 10:49:54','639',0.00,0.00,'639','2022-11-18 19:57:06','664','2022-11-19 08:32:21',10,0),('5','182',257782,'Daily shift','2022-11-19','2022-11-19 09:07:14','2022-11-20 09:07:14','639',0.00,0.00,'639','2022-11-19 18:55:18','664','2022-11-20 09:39:22',10,0),('5','182',257783,'Daily shift','2022-11-20','2022-11-20 10:24:25','2022-11-21 10:24:25','639',559571.35,559571.35,'639','2022-11-20 21:04:49','664','2022-11-21 06:39:44',10,0),('5','182',257784,'Daily shift','2022-11-21','2022-11-21 07:44:29','2022-11-22 07:44:29','639',956903.25,956903.25,'639','2022-11-21 19:58:25','664','2022-11-22 09:24:28',10,0),('5','182',257785,'Daily shift','2022-11-22','2022-11-22 11:23:04','2022-11-23 11:23:04','639',876498.55,876498.55,'639','2022-11-22 20:20:15','664','2022-11-23 07:23:57',10,0),('5','182',257786,'Daily shift','2022-11-23','2022-11-23 08:49:49','2022-11-24 08:49:49','639',388496.30,388496.30,'639','2022-11-23 19:03:52','600','2022-11-24 13:08:51',10,0),('5','182',257787,'Daily shift','2022-11-24','2022-11-24 20:03:09','2022-11-25 20:03:09','639',0.00,0.00,'639','2022-11-24 20:03:35','664','2022-11-24 22:03:26',10,0),('5','182',257788,'Daily shift','2022-11-25','2022-11-25 10:39:26','2022-11-26 10:39:26','639',0.00,0.00,'639','2022-11-25 19:57:49','664','2022-11-25 20:08:32',10,0),('5','182',257789,'Daily shift','2022-11-26','2022-11-26 19:05:17','2022-11-27 19:05:17','639',654892.60,654892.60,'639','2022-11-26 20:16:54','664','2022-11-27 08:34:53',10,0),('5','182',257790,'Daily shift','2022-11-27','2022-11-27 20:46:34','2022-11-28 20:46:34','639',882514.75,882514.75,'639','2022-11-28 05:56:40','664','2022-11-28 07:55:44',10,0),('5','182',257791,'Daily shift','2022-11-28','2022-11-28 09:20:12','2022-11-29 09:20:12','639',807833.95,807833.95,'639','2022-11-28 20:44:14','664','2022-11-29 08:05:42',10,0),('5','182',257792,'Daily shift','2022-11-29','2022-11-29 09:11:14','2022-11-30 09:11:14','639',529183.25,529183.25,'639','2022-11-29 18:39:43','664','2022-11-29 19:18:23',10,0),('5','182',257793,'Daily shift','2022-11-30','2022-11-30 09:15:34','2022-12-01 09:15:34','639',0.00,0.00,'639','2022-12-01 08:51:24','664','2022-12-01 13:15:50',10,0),('5','182',257794,'Daily shift','2022-12-01','2022-12-01 13:18:59','2022-12-02 13:18:59','639',0.00,0.00,'639','2022-12-01 18:51:56','664','2022-12-02 07:14:27',10,0),('5','182',257795,'Daily shift','2022-12-02','2022-12-02 09:20:38','2022-12-03 09:20:38','639',0.00,0.00,'639','2022-12-02 18:55:00','664','2022-12-03 08:32:52',10,0),('5','182',257796,'Daily shift','2022-12-03','2022-12-03 09:18:34','2022-12-04 09:18:34','639',0.00,0.00,'639','2022-12-03 19:16:35','664','2022-12-04 09:31:10',10,0),('5','182',257797,'Daily shift','2022-12-04','2022-12-04 09:44:33','2022-12-05 09:44:33','639',0.00,0.00,'639','2022-12-04 19:11:15','664','2022-12-05 07:39:20',10,0),('5','182',257798,'Daily shift','2022-12-05','2022-12-05 08:21:29','2022-12-06 08:21:29','639',0.00,0.00,'639','2022-12-05 19:45:03','664','2022-12-06 08:03:05',10,0),('5','182',257799,'Daily shift','2022-12-06','2022-12-06 11:54:03','2022-12-07 11:54:03','639',0.00,0.00,'639','2022-12-06 18:40:12','664','2022-12-07 07:52:38',10,0),('5','182',257800,'Daily shift','2022-12-07','2022-12-07 08:36:09','2022-12-08 08:36:09','639',0.00,0.00,'639','2022-12-07 20:01:05','664','2022-12-08 07:51:55',10,0),('5','182',257801,'Daily shift','2022-12-08','2022-12-08 10:02:13','2022-12-09 10:02:13','639',0.00,0.00,'639','2022-12-08 21:01:35','664','2022-12-09 08:16:19',10,0),('5','182',257802,'Daily shift','2022-12-09','2022-12-09 08:37:07','2022-12-10 08:37:07','639',0.00,0.00,'639','2022-12-09 20:00:47','664','2022-12-10 10:35:24',10,0),('5','182',257803,'Daily shift','2022-12-10','2022-12-10 10:57:44','2022-12-11 10:57:44','639',0.00,0.00,'639','2022-12-10 20:38:44','664','2022-12-11 08:43:49',10,0),('5','182',257804,'Daily shift','2022-12-11','2022-12-11 09:04:36','2022-12-12 09:04:36','639',0.00,0.00,'639','2022-12-11 19:45:36','664','2022-12-12 08:09:53',10,0),('5','182',257805,'Daily shift','2022-12-12','2022-12-12 09:06:02','2022-12-13 09:06:02','639',0.00,0.00,'639','2022-12-12 20:01:03','664','2022-12-13 08:25:33',10,0),('5','182',257806,'Daily shift','2022-12-13','2022-12-13 09:26:55','2022-12-14 09:26:55','639',0.00,0.00,'639','2022-12-13 18:53:33','795','2022-12-14 06:07:11',10,0),('5','182',257807,'Daily shift','2022-12-14','2022-12-14 09:53:06','2022-12-15 09:53:06','639',0.00,0.00,'639','2022-12-14 18:48:34','795','2022-12-15 09:48:48',10,0),('5','182',257808,'Daily shift','2022-12-15','2022-12-15 09:57:39','2022-12-16 09:57:39','639',0.00,0.00,'639','2022-12-16 06:07:07','795','2022-12-16 09:43:21',10,0),('5','182',257809,'Daily shift','2022-12-16','2022-12-16 09:54:51','2022-12-17 09:54:51','639',0.00,0.00,'639','2022-12-16 18:51:07','664','2022-12-17 11:15:01',10,0),('5','182',257810,'Daily shift','2022-12-17','2022-12-17 15:54:10','2022-12-18 15:54:10','639',0.00,0.00,'639','2022-12-17 15:54:27','795','2022-12-17 19:07:09',10,0),('5','182',257811,'Daily shift','2022-12-18','2022-12-18 09:51:56','2022-12-19 09:51:56','639',0.00,0.00,'639','2022-12-18 19:00:29','795','2022-12-18 21:06:51',10,0),('5','182',257812,'Daily shift','2022-12-19','2022-12-19 08:50:17','2022-12-20 08:50:17','639',0.00,0.00,'639','2022-12-19 16:51:54','795','2022-12-20 12:15:50',10,0),('5','182',257813,'Daily shift','2022-12-20','2022-12-20 12:33:41','2022-12-21 12:33:41','639',0.00,0.00,'639','2022-12-20 19:04:42','795','2022-12-21 10:38:34',10,0),('5','182',257814,'Daily shift','2022-12-21','2022-12-21 11:39:06','2022-12-22 11:39:06','639',0.00,0.00,'639','2022-12-21 17:23:06','795','2022-12-21 19:18:33',10,0),('5','182',257815,'Daily shift','2022-12-22','2022-12-22 09:56:18','2022-12-23 09:56:18','639',0.00,0.00,'639','2022-12-22 21:13:36','795','2022-12-23 09:58:20',10,0),('5','182',257816,'Daily shift','2022-12-23','2022-12-23 10:22:56','2022-12-24 10:22:56','639',0.00,0.00,'639','2022-12-23 10:23:14','795','2022-12-24 09:01:32',10,0),('5','182',257817,'Daily shift','2022-12-24','2022-12-24 09:51:10','2022-12-25 09:51:10','639',0.00,0.00,'639','2022-12-24 09:51:39','795','2022-12-25 16:07:36',10,0),('5','182',257818,'Daily shift','2022-12-25','2022-12-25 20:21:23','2022-12-26 20:21:23','639',0.00,0.00,'639','2022-12-25 20:21:39','795','2022-12-26 14:59:59',10,0),('5','182',257819,'Daily shift','2022-12-26','2022-12-26 21:27:14','2022-12-27 21:27:14','639',0.00,0.00,'639','2022-12-26 21:27:30','795','2022-12-27 12:15:07',10,0),('5','182',257820,'Daily shift','2022-12-27','2022-12-27 15:36:41','2022-12-28 15:36:41','639',0.00,0.00,'639','2022-12-27 15:37:01','795','2022-12-28 10:20:57',10,0),('5','182',257821,'Daily shift','2022-12-28','2022-12-28 21:42:18','2022-12-29 21:42:18','639',0.00,0.00,'639','2022-12-28 21:42:36','795','2022-12-29 09:29:19',10,0),('5','182',257822,'Daily shift','2022-12-29','2022-12-29 20:52:08','2022-12-30 20:52:08','639',0.00,0.00,'639','2022-12-29 20:52:28','795','2022-12-30 09:37:03',10,0),('5','182',257823,'Daily shift','2022-12-30','2022-12-30 09:41:24','2022-12-31 09:41:24','639',0.00,0.00,'639','2022-12-30 09:41:58','795','2022-12-31 07:32:02',10,0),('5','182',257824,'Daily shift','2022-12-31','2022-12-31 08:47:56','2023-01-01 08:47:56','639',0.00,0.00,'639','2022-12-31 20:52:47','795','2023-01-01 20:39:11',10,0),('5','182',257825,'Daily shift','2023-01-01','2023-01-01 20:42:49','2023-01-02 20:42:49','639',0.00,0.00,'639','2023-01-01 20:43:08','795','2023-01-02 19:05:44',10,0),('5','182',257826,'Daily shift','2023-01-02','2023-01-02 20:31:56','2023-01-03 20:31:56','639',0.00,0.00,'639','2023-01-02 20:32:12','795','2023-01-03 12:04:45',10,0),('5','182',257827,'Daily shift','2023-01-03','2023-01-03 12:14:42','2023-01-04 12:14:42','639',0.00,0.00,'639','2023-01-03 19:14:06','795','2023-01-04 11:20:54',10,0),('5','182',257828,'Daily shift','2023-01-04','2023-01-04 15:49:24','2023-01-05 15:49:24','639',0.00,0.00,'639','2023-01-04 15:49:39','795','2023-01-05 13:38:31',10,0),('5','182',257829,'Daily shift','2023-01-05','2023-01-05 14:09:37','2023-01-06 14:09:37','639',0.00,0.00,'639','2023-01-05 14:10:06','795','2023-01-05 19:56:46',10,0),('5','182',257830,'Daily shift','2023-01-06','2023-01-06 08:51:42','2023-01-07 08:51:42','639',0.00,0.00,'639','2023-01-06 17:51:17','795','2023-01-06 22:40:24',10,0),('5','182',257831,'Daily shift','2023-01-07','2023-01-07 10:19:40','2023-01-08 10:19:40','639',0.00,0.00,'639','2023-01-07 10:20:02','795','2023-01-07 21:53:06',10,0),('5','182',257832,'Daily shift','2023-01-08','2023-01-08 17:59:36','2023-01-09 17:59:36','639',0.00,0.00,'639','2023-01-08 17:59:59','795','2023-01-08 18:18:04',10,0),('5','182',257833,'Daily shift','2023-01-09','2023-01-09 09:55:45','2023-01-10 09:55:45','639',0.00,0.00,'639','2023-01-09 17:45:09','795','2023-01-10 15:40:50',10,0),('5','182',257834,'Daily shift','2023-01-10','2023-01-10 15:41:26','2023-01-11 15:41:26','639',0.00,0.00,'639','2023-01-10 15:41:43','795','2023-01-11 09:24:50',10,0),('5','182',257835,'Daily shift','2023-01-11','2023-01-11 10:18:28','2023-01-12 10:18:28','639',0.00,0.00,'639','2023-01-11 19:34:59','795','2023-01-12 09:27:24',10,0),('5','182',257836,'Daily shift','2023-01-12','2023-01-12 10:46:15','2023-01-13 10:46:15','639',0.00,0.00,'639','2023-01-12 18:21:00','795','2023-01-13 09:42:00',10,0),('5','182',257837,'Daily shift','2023-01-13','2023-01-13 10:31:09','2023-01-14 10:31:09','639',0.00,0.00,'639','2023-01-13 20:38:41','795','2023-01-14 13:41:28',10,0),('5','182',257838,'Daily shift','2023-01-14','2023-01-14 15:06:32','2023-01-15 15:06:32','639',0.00,0.00,'639','2023-01-14 15:06:49','795','2023-01-15 13:45:31',10,0),('5','182',257839,'Daily shift','2023-01-15','2023-01-15 21:14:36','2023-01-16 21:14:36','639',0.00,0.00,'639','2023-01-15 21:14:52','795','2023-01-16 09:36:05',10,0),('5','182',257840,'Daily shift','2023-01-16','2023-01-16 10:14:12','2023-01-17 10:14:12','639',0.00,0.00,'639','2023-01-16 17:56:46','795','2023-01-17 09:14:05',10,0),('5','182',257841,'Daily shift','2023-01-17','2023-01-17 09:25:28','2023-01-18 09:25:28','639',0.00,0.00,'639','2023-01-17 17:26:09','795','2023-01-18 09:26:51',10,0),('5','182',257842,'Daily shift','2023-01-18','2023-01-18 22:19:57','2023-01-19 22:19:57','639',0.00,0.00,'639','2023-01-18 22:20:25','795','2023-01-19 09:35:41',10,0),('5','182',257843,'Daily shift','2023-01-19','2023-01-19 10:32:42','2023-01-20 10:32:42','639',0.00,0.00,'639','2023-01-19 10:33:11','795','2023-01-19 19:21:47',10,0),('5','182',257844,'Daily shift','2023-01-20','2023-01-20 08:55:03','2023-01-21 08:55:03','639',0.00,0.00,'639','2023-01-20 21:38:47','795','2023-01-21 10:51:29',10,0),('5','182',257845,'Daily shift','2023-01-21','2023-01-21 20:46:16','2023-01-22 20:46:16','639',0.00,0.00,'639','2023-01-21 20:46:41','795','2023-01-22 20:43:35',10,0),('5','182',257846,'Daily shift','2023-01-22','2023-01-22 21:20:31','2023-01-23 21:20:31','639',0.00,0.00,'639','2023-01-22 21:21:32','795','2023-01-24 10:27:36',10,0),('5','182',257847,'Daily shift','2023-01-23','2023-01-24 11:44:35','2023-01-25 11:44:35','639',0.00,0.00,'639','2023-01-24 11:45:04','795','2023-01-25 09:40:30',10,0),('5','182',257848,'Daily shift','2023-01-24','2023-01-25 10:44:54','2023-01-26 10:44:54','639',0.00,0.00,'639','2023-01-25 10:45:17','795','2023-01-25 21:10:33',10,0),('5','182',257849,'Daily shift','2023-01-25','2023-01-25 21:23:20','2023-01-26 21:23:20','639',0.00,0.00,'639','2023-01-25 21:23:36','795','2023-01-27 08:25:12',10,0),('5','182',257850,'Daily shift','2023-01-16','2023-01-27 08:43:45','2023-01-28 08:43:45','639',0.00,0.00,'639','2023-01-27 08:44:05','795','2023-01-28 23:54:07',10,0),('5','182',257851,'Daily shift','2023-01-27','2023-01-29 06:25:25','2023-01-30 06:25:25','639',0.00,0.00,'639','2023-01-29 06:25:40','795','2023-01-29 21:11:22',10,0),('5','182',257852,'Daily shift','2023-01-28','2023-01-30 09:47:29','2023-01-31 09:47:29','639',0.00,0.00,'639','2023-01-30 09:47:47','795','2023-01-30 09:50:25',10,0),('5','182',257853,'Daily shift','2023-01-29','2023-01-30 10:03:17','2023-01-31 10:03:17','639',0.00,0.00,'639','2023-01-30 10:03:36','795','2023-01-31 09:54:58',10,0),('5','182',257854,'Daily shift','2023-01-30','2023-01-31 09:58:38','2023-02-01 09:58:38','639',0.00,0.00,'639','2023-01-31 09:58:51','795','2023-02-01 12:50:21',10,0),('5','182',257855,'Daily shift','2023-01-31','2023-02-01 13:29:14','2023-02-02 13:29:14','639',0.00,0.00,'639','2023-02-01 13:29:31','795','2023-02-02 09:26:47',10,0),('5','182',257856,'Daily shift','2023-02-01','2023-02-02 10:13:02','2023-02-03 10:13:02','639',0.00,0.00,'639','2023-02-02 10:13:22','795','2023-02-03 09:18:53',10,0),('5','182',257857,'Daily shift','2023-02-02','2023-02-03 18:31:27','2023-02-04 18:31:27','639',0.00,0.00,'639','2023-02-03 18:32:19','795','2023-02-03 18:37:46',10,0),('5','182',257858,'Daily shift','2023-02-03','2023-02-04 08:50:12','2023-02-05 08:50:12','639',0.00,0.00,'639','2023-02-04 08:50:28','795','2023-02-04 18:11:07',10,0),('5','182',257859,'Daily shift','2023-02-04','2023-02-04 20:19:11','2023-02-05 20:19:11','639',0.00,0.00,'639','2023-02-04 20:20:15','795','2023-02-05 20:46:56',10,0),('5','182',257860,'Daily shift','2023-02-05','2023-02-05 21:34:52','2023-02-06 21:34:52','639',0.00,0.00,'639','2023-02-05 21:35:10','795','2023-02-06 13:48:54',10,0),('5','182',257861,'Daily shift','2023-02-06','2023-02-06 13:59:01','2023-02-07 13:59:01','639',0.00,0.00,'639','2023-02-06 13:59:19','795','2023-02-07 10:14:05',10,0),('5','182',257862,'Daily shift','2023-02-07','2023-02-07 16:46:56','2023-02-08 16:46:56','639',0.00,0.00,'639','2023-02-07 16:47:12','795','2023-02-08 10:30:28',10,0),('5','182',257863,'Daily shift','2023-02-08','2023-02-08 11:03:14','2023-02-09 11:03:14','639',0.00,0.00,'639','2023-02-08 20:52:04','795','2023-02-09 09:25:47',10,0),('5','182',257864,'Daily shift','2023-02-09','2023-02-09 22:28:32','2023-02-10 22:28:32','639',0.00,0.00,'639','2023-02-09 22:28:51','795','2023-02-10 08:30:50',10,0),('5','182',257865,'Daily shift','2023-02-10','2023-02-10 15:07:19','2023-02-11 15:07:19','639',0.00,0.00,'639','2023-02-10 15:07:40','795','2023-02-11 12:40:59',10,0),('5','182',257866,'Daily shift','2023-02-11','2023-02-11 22:52:35','2023-02-12 22:52:35','639',0.00,0.00,'639','2023-02-11 22:53:03','795','2023-02-12 09:19:05',10,0),('5','182',257867,'Daily shift','2023-02-12','2023-02-12 12:03:11','2023-02-13 12:03:11','639',0.00,0.00,'639','2023-02-12 12:03:34','795','2023-02-14 09:31:49',10,0),('5','182',257868,'Daily shift','2023-02-13','2023-02-14 11:19:19','2023-02-15 11:19:19','639',0.00,0.00,'639','2023-02-14 11:19:33','795','2023-02-18 22:52:22',10,0),('5','182',257869,'Daily shift','2023-02-14','2023-02-19 14:32:03','2023-02-20 14:32:03','639',0.00,0.00,'639','2023-02-19 14:32:21','795','2023-02-20 09:20:11',10,0),('5','182',257870,'Daily shift','2023-02-15','2023-02-22 13:30:45','2023-02-23 13:30:45','639',0.00,0.00,'639','2023-02-22 13:30:59','795','2023-02-22 13:46:56',10,0),('5','182',257871,'Daily shift','2023-02-16','2023-02-22 15:44:33','2023-02-23 15:44:33','639',0.00,0.00,'639','2023-02-22 15:49:24','795','2023-02-24 10:34:42',10,0),('5','182',257872,'Daily shift','2023-02-17','2023-02-26 08:37:57','2023-02-27 08:37:57','639',0.00,0.00,'639','2023-02-26 08:38:17','795','2023-02-26 13:03:34',10,0),('5','182',257873,'Daily shift','2023-02-18','2023-02-26 22:56:03','2023-02-27 22:56:03','639',0.00,0.00,'639','2023-02-26 22:56:27','795','2023-02-27 07:14:34',10,0),('5','182',257874,'Daily shift','2023-02-19','2023-02-27 07:17:58','2023-02-28 07:17:58','639',0.00,0.00,'639','2023-02-27 07:18:30','795','2023-02-27 07:43:09',10,0),('5','182',257875,'Daily shift','2023-02-20','2023-02-27 09:14:06','2023-02-28 09:14:06','639',0.00,0.00,'639','2023-02-27 09:14:22','795','2023-02-27 09:15:50',10,0),('5','182',257876,'Daily shift','2023-02-21','2023-02-27 09:17:32','2023-02-28 09:17:32','639',0.00,0.00,'639','2023-02-27 09:17:47','795','2023-02-27 13:09:57',10,0),('5','182',257877,'Daily shift','2023-02-22','2023-02-27 13:27:18','2023-02-28 13:27:18','639',0.00,0.00,'639','2023-02-27 13:27:34','795','2023-02-27 22:49:24',10,0),('5','182',257878,'Daily shift','2023-02-23','2023-02-28 07:26:10','2023-03-01 07:26:10','639',0.00,0.00,'639','2023-02-28 07:26:29','795','2023-03-01 08:13:35',10,0),('5','182',257879,'Daily shift','2023-02-24','2023-03-01 09:17:30','2023-03-02 09:17:30','639',0.00,0.00,'639','2023-03-01 09:17:47','795','2023-03-06 09:45:56',10,0),('5','182',257880,'Daily shift','2023-03-05','2023-03-06 22:04:50','2023-03-07 22:04:50','639',0.00,0.00,'639','2023-03-06 22:05:19','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905865 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','182','953','210835',4087730,'2837','426',457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210835',4087731,'2838','426',305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210835',4087732,'2839','426',447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210835',4087733,'2840','426',493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','210835',4087734,'2841','427',166992.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','210835',4087735,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210889',4088723,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210889',4088724,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210889',4088725,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210889',4088726,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','210889',4088727,'2841','427',166992.11,167075.38,83.27,24564.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','210889',4088728,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210911',4089125,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210911',4089126,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210911',4089127,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210911',4089128,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','210911',4089129,'2841','427',167075.38,167163.34,87.96,25948.20,0.00,0.00,0.00,0.00,0.00),('5','182','956','210911',4089130,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210974',4089917,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','210974',4089918,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210974',4089919,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','210974',4089920,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','210974',4089921,'2841','427',167163.34,167190.03,26.69,7873.55,0.00,0.00,0.00,0.00,0.00),('5','182','956','210974',4089922,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211196',4093896,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211196',4093897,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211196',4093898,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211196',4093899,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','211196',4093900,'2841','427',167190.03,167238.83,48.80,14396.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','211196',4093901,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211749',4103774,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211749',4103775,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211749',4103776,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211749',4103777,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','211749',4103778,'2841','427',167238.83,167285.88,47.05,13879.75,0.00,0.00,0.00,0.00,0.00),('5','182','956','211749',4103779,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211978',4107758,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','211978',4107759,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211978',4107760,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','211978',4107761,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','211978',4107762,'2841','427',167285.88,167356.38,70.50,20797.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','211978',4107763,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212053',4108960,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212053',4108961,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212053',4108962,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212053',4108963,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','212053',4108964,'2841','427',167356.38,167448.28,91.90,27110.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','212053',4108965,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212421',4115765,'2837','426',457190.85,457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212421',4115766,'2838','426',305989.35,305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212421',4115767,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212421',4115768,'2840','426',493550.13,493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','212421',4115769,'2841','427',167448.28,167913.22,464.94,137157.30,0.00,0.00,0.00,0.00,0.00),('5','182','956','212421',4115770,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212578',4118460,'2837','426',457190.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212578',4118461,'2838','426',305989.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212578',4118462,'2839','426',447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212578',4118463,'2840','426',493550.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','212578',4118464,'2841','427',167913.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','212578',4118465,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212714',4120828,'2837','426',457190.85,458103.65,912.80,150612.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','212714',4120829,'2838','426',305989.35,306510.76,521.41,86032.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','212714',4120830,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','212714',4120831,'2840','426',496176.56,496717.76,541.20,89298.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','212714',4120832,'2841','427',167913.22,168651.18,737.96,217698.20,0.00,0.00,0.00,0.00,0.00),('5','182','956','212714',4120833,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213247',4129956,'2837','426',458103.65,459484.90,1381.25,227906.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','213247',4129957,'2838','426',306510.76,307544.95,1034.19,170641.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','213247',4129958,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213247',4129959,'2840','426',496717.76,497376.99,659.23,108772.29,0.00,0.00,0.00,0.00,0.00),('5','182','955','213247',4129960,'2841','427',168651.18,171204.95,2553.77,753362.15,0.00,0.00,0.00,0.00,0.00),('5','182','956','213247',4129961,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213259',4130162,'2837','426',459484.90,460713.98,1229.08,202798.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','213259',4130163,'2838','426',307544.95,308352.33,807.38,133217.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','213259',4130164,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213259',4130165,'2840','426',497376.99,497966.90,589.91,97335.15,0.00,0.00,0.00,0.00,0.00),('5','182','955','213259',4130166,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','213259',4130167,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213270',4130367,'2837','426',460713.98,461860.29,1146.31,189141.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','213270',4130368,'2838','426',308352.33,308911.70,559.37,92296.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','213270',4130369,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213270',4130370,'2840','426',497966.90,498685.09,718.19,118501.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','213270',4130371,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','213270',4130372,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213446',4133209,'2837','426',461860.29,463129.36,1269.07,209396.55,0.00,0.00,0.00,0.00,0.00),('5','182','953','213446',4133210,'2838','426',308911.70,309641.71,730.01,120451.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','213446',4133211,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213446',4133212,'2840','426',498685.09,499174.61,489.52,80770.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','213446',4133213,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','213446',4133214,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213733',4138091,'2837','426',463129.36,464300.51,1171.15,193239.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','213733',4138092,'2838','426',309641.71,310500.78,859.07,141746.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','213733',4138093,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213733',4138094,'2840','426',499174.61,500374.89,1200.28,198046.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','213733',4138095,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','213733',4138096,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','213991',4142342,'2837','426',464300.51,465475.37,1174.86,193851.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','213991',4142343,'2838','426',310500.78,311093.27,592.49,97760.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','213991',4142344,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','213991',4142345,'2840','426',500374.89,501163.07,788.18,130049.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','213991',4142346,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','213991',4142347,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214303',4147915,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214303',4147916,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214303',4147917,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214303',4147918,'2840','426',501163.07,504356.43,3193.36,526904.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','214303',4147919,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','214303',4147920,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214496',4151158,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214496',4151159,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214496',4151160,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214496',4151161,'2840','426',504356.43,507574.31,3217.88,530950.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','214496',4151162,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','214496',4151163,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214535',4151616,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214535',4151617,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214535',4151618,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214535',4151619,'2840','426',507574.31,509334.43,1760.12,290419.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','214535',4151620,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','214535',4151621,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214879',4157586,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','214879',4157587,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214879',4157588,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','214879',4157589,'2840','426',509334.43,512848.13,3513.70,579760.50,0.00,0.00,0.00,0.00,0.00),('5','182','955','214879',4157590,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','214879',4157591,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215299',4164647,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215299',4164648,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215299',4164649,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215299',4164650,'2840','426',512848.13,515702.45,2854.32,470962.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','215299',4164651,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','215299',4164652,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215367',4165878,'2837','426',465475.37,465475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215367',4165879,'2838','426',311093.27,311093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215367',4165880,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215367',4165881,'2840','426',515702.45,518331.40,2628.95,433776.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','215367',4165882,'2841','427',171204.95,171204.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','215367',4165883,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215450',4167116,'2837','426',465475.37,466796.31,1320.94,217955.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','215450',4167117,'2838','426',311093.27,311730.62,637.35,105162.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','215450',4167118,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215450',4167119,'2840','426',518331.40,519198.85,867.45,143129.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','215450',4167120,'2841','427',171204.95,171845.16,640.21,188861.95,0.00,0.00,0.00,0.00,0.00),('5','182','956','215450',4167121,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215883',4174734,'2837','426',466796.31,468077.69,1281.38,211427.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','215883',4174735,'2838','426',311730.62,312161.83,431.21,71149.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','215883',4174736,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215883',4174737,'2840','426',519198.85,519995.33,796.48,131419.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','215883',4174738,'2841','427',171845.16,171979.11,133.95,39515.25,0.00,0.00,0.00,0.00,0.00),('5','182','956','215883',4174739,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','215923',4175266,'2837','426',468077.69,469403.03,1325.34,218681.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','215923',4175267,'2838','426',312161.83,313376.10,1214.27,200354.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','215923',4175268,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','215923',4175269,'2840','426',519995.33,520096.41,101.08,16678.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','215923',4175270,'2841','427',171979.11,172219.92,240.81,71038.95,0.00,0.00,0.00,0.00,0.00),('5','182','956','215923',4175271,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','216157',4179262,'2837','426',469403.03,470764.55,1361.52,224650.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','216157',4179263,'2838','426',313376.10,314988.22,1612.12,265999.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','216157',4179264,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','216157',4179265,'2840','426',520096.41,520096.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','216157',4179266,'2841','427',172219.92,172300.42,80.50,23747.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','216157',4179267,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','216316',4182238,'2837','426',470764.55,471959.03,1194.48,197089.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','216316',4182239,'2838','426',314988.22,315567.70,579.48,95614.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','216316',4182240,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','216316',4182241,'2840','426',520096.41,520962.07,865.66,142833.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','216316',4182242,'2841','427',172300.42,172371.88,71.46,21080.70,0.00,0.00,0.00,0.00,0.00),('5','182','956','216316',4182243,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','216553',4186275,'2837','426',471959.03,473023.61,1064.58,175655.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','216553',4186276,'2838','426',315567.70,316043.94,476.24,78579.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','216553',4186277,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','216553',4186278,'2840','426',520962.07,521690.30,728.23,120157.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','216553',4186279,'2841','427',172371.88,172451.85,79.97,23591.15,0.00,0.00,0.00,0.00,0.00),('5','182','956','216553',4186280,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','216782',4190450,'2837','426',473023.61,474171.21,1147.60,189354.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','216782',4190451,'2838','426',316043.94,316666.12,622.18,102659.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','216782',4190452,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','216782',4190453,'2840','426',521690.30,522713.30,1023.00,168795.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','216782',4190454,'2841','427',172451.85,172485.68,33.83,9979.85,0.00,0.00,0.00,0.00,0.00),('5','182','956','216782',4190455,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','217023',4194496,'2837','426',474171.21,475661.22,1490.01,245851.65,0.00,0.00,0.00,0.00,0.00),('5','182','953','217023',4194497,'2838','426',316666.12,317208.57,542.45,89504.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','217023',4194498,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','217023',4194499,'2840','426',522713.30,523352.29,638.99,105433.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','217023',4194500,'2841','427',172485.68,172573.19,87.51,25815.45,0.00,0.00,0.00,0.00,0.00),('5','182','956','217023',4194501,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','217297',4199599,'2837','426',475661.22,476785.38,1124.16,185486.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','217297',4199600,'2838','426',317208.57,317764.86,556.29,91787.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','217297',4199601,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','217297',4199602,'2840','426',523352.29,524095.34,743.05,122603.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','217297',4199603,'2841','427',172573.19,172735.17,161.98,47784.10,0.00,0.00,0.00,0.00,0.00),('5','182','956','217297',4199604,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','217652',4205941,'2837','426',476785.38,478150.24,1364.86,225201.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','217652',4205942,'2838','426',317764.86,318563.46,798.60,131769.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','217652',4205943,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','217652',4205944,'2840','426',524095.34,525002.81,907.47,149732.55,0.00,0.00,0.00,0.00,0.00),('5','182','955','217652',4205945,'2841','427',172735.17,172987.37,252.20,74399.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','217652',4205946,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','217733',4207038,'2837','426',478150.24,479445.30,1295.06,213684.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','217733',4207039,'2838','426',318563.46,319545.35,981.89,162011.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','217733',4207040,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','217733',4207041,'2840','426',525002.81,526679.44,1676.63,276643.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','217733',4207042,'2841','427',172987.37,173236.54,249.17,73505.15,0.00,0.00,0.00,0.00,0.00),('5','182','956','217733',4207043,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','218018',4212211,'2837','426',479445.30,480898.96,1453.66,239853.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','218018',4212212,'2838','426',319545.35,320286.61,741.26,122307.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','218018',4212213,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','218018',4212214,'2840','426',526679.44,527772.81,1093.37,180406.05,0.00,0.00,0.00,0.00,0.00),('5','182','955','218018',4212215,'2841','427',173236.54,173444.21,207.67,61262.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','218018',4212216,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','218257',4216276,'2837','426',480898.96,481781.67,882.71,145647.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','218257',4216277,'2838','426',320286.61,321334.58,1047.97,172915.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','218257',4216278,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','218257',4216279,'2840','426',527772.81,529574.91,1802.10,297346.50,0.00,0.00,0.00,0.00,0.00),('5','182','955','218257',4216280,'2841','427',173444.21,173569.58,125.37,36984.15,0.00,0.00,0.00,0.00,0.00),('5','182','956','218257',4216281,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219519',4238592,'2837','426',481781.67,481781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219519',4238593,'2838','426',321334.58,321334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219519',4238594,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219519',4238595,'2840','426',529574.91,533476.05,3901.14,643688.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','219519',4238596,'2841','427',173569.58,173732.82,163.24,48155.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','219519',4238597,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219521',4238614,'2837','426',481781.67,481781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219521',4238615,'2838','426',321334.58,321334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219521',4238616,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219521',4238617,'2840','426',533476.05,535339.41,1863.36,307454.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','219521',4238618,'2841','427',173732.82,173766.61,33.79,9968.05,0.00,0.00,0.00,0.00,0.00),('5','182','956','219521',4238619,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219527',4238708,'2837','426',481781.67,481781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219527',4238709,'2838','426',321334.58,321334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219527',4238710,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219527',4238711,'2840','426',535339.41,535339.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','219527',4238712,'2841','427',173766.61,173809.91,43.30,12773.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','219527',4238713,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219533',4238821,'2837','426',481781.67,481781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219533',4238822,'2838','426',321334.58,321334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219533',4238823,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219533',4238824,'2840','426',535339.41,535339.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','219533',4238825,'2841','427',173809.91,173863.78,53.87,15891.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','219533',4238826,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219561',4239394,'2837','426',481781.67,481781.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219561',4239395,'2838','426',321334.58,321334.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219561',4239396,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219561',4239397,'2840','426',535339.41,535339.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','219561',4239398,'2841','427',173863.78,173907.69,43.91,12953.45,0.00,0.00,0.00,0.00,0.00),('5','182','956','219561',4239399,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219615',4239936,'2837','426',481781.67,483006.41,1224.74,202082.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','219615',4239937,'2838','426',321334.58,322010.02,675.44,111447.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','219615',4239938,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219615',4239939,'2840','426',535339.41,536134.24,794.83,131146.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','219615',4239940,'2841','427',173907.69,173929.92,22.23,6557.85,0.00,0.00,0.00,0.00,0.00),('5','182','956','219615',4239941,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','219853',4244298,'2837','426',483006.41,484586.49,1580.08,260713.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','219853',4244299,'2838','426',322010.02,322950.32,940.30,155149.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','219853',4244300,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','219853',4244301,'2840','426',536134.24,537190.13,1055.89,174221.85,0.00,0.00,0.00,0.00,0.00),('5','182','955','219853',4244302,'2841','427',173929.92,174013.79,83.87,24741.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','219853',4244303,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','220076',4248348,'2837','426',484586.49,485598.82,1012.33,167034.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','220076',4248349,'2838','426',322950.32,323640.18,689.86,113826.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','220076',4248350,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','220076',4248351,'2840','426',537190.13,538254.09,1063.96,175553.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','220076',4248352,'2841','427',174013.79,174088.57,74.78,22060.10,0.00,0.00,0.00,0.00,0.00),('5','182','956','220076',4248353,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','220374',4253767,'2837','426',485598.82,486768.46,1169.64,192990.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','220374',4253768,'2838','426',323640.18,324560.55,920.37,151861.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','220374',4253769,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','220374',4253770,'2840','426',538254.09,539276.51,1022.42,168699.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','220374',4253771,'2841','427',174088.57,174298.07,209.50,61802.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','220374',4253772,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','220484',4255721,'2837','426',486768.46,487556.04,787.58,129950.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','220484',4255722,'2838','426',324560.55,325390.20,829.65,136892.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','220484',4255723,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','220484',4255724,'2840','426',539276.51,539957.63,681.12,112384.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','220484',4255725,'2841','427',174298.07,174350.43,52.36,15446.20,0.00,0.00,0.00,0.00,0.00),('5','182','956','220484',4255726,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','220748',4260179,'2837','426',487556.04,488767.89,1211.85,199955.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','220748',4260180,'2838','426',325390.20,325892.47,502.27,82874.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','220748',4260181,'2839','426',447134.23,447134.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','220748',4260182,'2840','426',539957.63,540896.05,938.42,154839.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','220748',4260183,'2841','427',174350.43,174485.34,134.91,39798.45,0.00,0.00,0.00,0.00,0.00),('5','182','956','220748',4260184,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','220922',4263376,'2837','426',488767.89,489957.35,1189.46,196260.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','220922',4263377,'2838','426',325892.47,326590.85,698.38,115232.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','220922',4263378,'2839','426',447134.23,447134.33,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','220922',4263379,'2840','426',540896.05,541681.51,785.46,129600.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','220922',4263380,'2841','427',174485.34,174570.72,85.38,25187.10,0.00,0.00,0.00,0.00,0.00),('5','182','956','220922',4263381,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224655',4330050,'2837','426',489957.35,491460.64,1503.29,248042.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','224655',4330051,'2838','426',326590.85,327336.29,745.44,122997.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','224655',4330052,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224655',4330053,'2840','426',541681.51,542711.39,1029.88,169930.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','224655',4330054,'2841','427',174570.72,174789.01,218.29,64395.55,0.00,0.00,0.00,0.00,0.00),('5','182','956','224655',4330055,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224660',4330135,'2837','426',491460.64,492747.69,1287.05,212363.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','224660',4330136,'2838','426',327336.29,328287.61,951.32,156967.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','224660',4330137,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224660',4330138,'2840','426',542711.39,543574.70,863.31,142446.15,0.00,0.00,0.00,0.00,0.00),('5','182','955','224660',4330139,'2841','427',174789.01,174928.50,139.49,41149.55,0.00,0.00,0.00,0.00,0.00),('5','182','956','224660',4330140,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224667',4330237,'2837','426',492747.69,493614.79,867.10,143071.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','224667',4330238,'2838','426',328287.61,329075.32,787.71,129972.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','224667',4330239,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224667',4330240,'2840','426',543574.70,544234.96,660.26,108942.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','224667',4330241,'2841','427',174928.50,175153.72,225.22,66439.90,0.00,0.00,0.00,0.00,0.00),('5','182','956','224667',4330242,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224674',4330314,'2837','426',493614.79,494557.02,942.23,155467.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','224674',4330315,'2838','426',329075.32,329589.37,514.05,84818.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','224674',4330316,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224674',4330317,'2840','426',544234.96,545273.96,1039.00,171435.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','224674',4330318,'2841','427',175153.72,175365.11,211.39,62360.05,0.00,0.00,0.00,0.00,0.00),('5','182','956','224674',4330319,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224679',4330384,'2837','426',494557.02,495489.60,932.58,153875.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','224679',4330385,'2838','426',329589.37,330169.17,579.80,95667.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224679',4330386,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224679',4330387,'2840','426',545273.96,545818.45,544.49,89840.85,0.00,0.00,0.00,0.00,0.00),('5','182','955','224679',4330388,'2841','427',175365.11,175659.62,294.51,86880.45,0.00,0.00,0.00,0.00,0.00),('5','182','956','224679',4330389,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224681',4330416,'2837','426',495489.60,496378.44,888.84,146658.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','224681',4330417,'2838','426',330169.17,330778.67,609.50,100567.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','224681',4330418,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224681',4330419,'2840','426',545818.45,546471.81,653.36,107804.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','224681',4330420,'2841','427',175659.62,175784.89,125.27,36954.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','224681',4330421,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224686',4330508,'2837','426',496378.44,496846.76,468.32,77272.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','224686',4330509,'2838','426',330778.67,331530.23,751.56,124007.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','224686',4330510,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224686',4330511,'2840','426',546471.81,547674.05,1202.24,198369.60,0.00,0.00,0.00,0.00,0.00),('5','182','955','224686',4330512,'2841','427',175784.89,175866.32,81.43,24021.85,0.00,0.00,0.00,0.00,0.00),('5','182','956','224686',4330513,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224689',4330573,'2837','426',496846.76,497588.25,741.49,122345.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','224689',4330574,'2838','426',331530.23,332085.13,554.90,91558.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','224689',4330575,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224689',4330576,'2840','426',547674.05,548094.31,420.26,69342.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','224689',4330577,'2841','427',175866.32,175962.62,96.30,28408.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','224689',4330578,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224696',4330669,'2837','426',497588.25,498813.24,1224.99,202123.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','224696',4330670,'2838','426',332085.13,332926.62,841.49,138845.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','224696',4330671,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224696',4330672,'2840','426',548094.31,548858.30,763.99,126058.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','224696',4330673,'2841','427',175962.62,176181.25,218.63,64495.85,0.00,0.00,0.00,0.00,0.00),('5','182','956','224696',4330674,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224701',4330771,'2837','426',498813.24,499746.47,933.23,153982.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','224701',4330772,'2838','426',332926.62,333487.28,560.66,92508.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','224701',4330773,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224701',4330774,'2840','426',548858.30,549536.11,677.81,111838.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','224701',4330775,'2841','427',176181.25,176343.40,162.15,47834.25,0.00,0.00,0.00,0.00,0.00),('5','182','956','224701',4330776,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224703',4330779,'2837','426',499746.47,500938.40,1191.93,196668.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','224703',4330780,'2838','426',333487.28,334398.01,910.73,150270.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','224703',4330781,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224703',4330782,'2840','426',549536.11,549554.29,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','224703',4330783,'2841','427',176343.40,176594.06,250.66,73944.70,0.00,0.00,0.00,0.00,0.00),('5','182','956','224703',4330784,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224704',4330785,'2837','426',500938.40,501861.15,922.75,152253.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','224704',4330786,'2838','426',334398.01,335055.96,657.95,108561.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','224704',4330787,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224704',4330788,'2840','426',549554.29,549554.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','224704',4330789,'2841','427',176594.06,176842.32,248.26,73236.70,0.00,0.00,0.00,0.00,0.00),('5','182','956','224704',4330790,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224707',4330832,'2837','426',501861.15,502612.60,751.45,123989.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','224707',4330833,'2838','426',335055.96,335567.31,511.35,84372.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','224707',4330834,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224707',4330835,'2840','426',549554.29,549933.30,379.01,62536.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','224707',4330836,'2841','427',176842.32,176951.35,109.03,32163.85,0.00,0.00,0.00,0.00,0.00),('5','182','956','224707',4330837,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224712',4330902,'2837','426',502612.60,503051.76,439.16,72461.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','224712',4330903,'2838','426',335567.31,336334.65,767.34,126611.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','224712',4330904,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224712',4330905,'2840','426',549933.30,550804.31,871.01,143716.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','224712',4330906,'2841','427',176951.35,177122.05,170.70,50356.50,0.00,0.00,0.00,0.00,0.00),('5','182','956','224712',4330907,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','224717',4331004,'2837','426',503051.76,503382.04,330.28,54496.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','224717',4331005,'2838','426',336334.65,337329.80,995.15,164199.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','224717',4331006,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','224717',4331007,'2840','426',550804.31,551700.00,895.69,147788.85,0.00,0.00,0.00,0.00,0.00),('5','182','955','224717',4331008,'2841','427',177122.05,177347.76,225.71,66584.45,0.00,0.00,0.00,0.00,0.00),('5','182','956','224717',4331009,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','225177',4339426,'2837','426',503382.04,504458.94,1076.90,175534.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','225177',4339427,'2838','426',337329.80,338003.60,673.80,109829.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','225177',4339428,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','225177',4339429,'2840','426',551700.00,551710.30,10.30,1678.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','225177',4339430,'2841','427',177347.76,177763.41,415.65,122616.75,0.00,0.00,0.00,0.00,0.00),('5','182','956','225177',4339431,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','225182',4339551,'2837','426',504458.94,505177.82,718.88,117177.44,0.00,0.00,0.00,0.00,0.00),('5','182','953','225182',4339552,'2838','426',338003.60,338778.06,774.46,126236.98,0.00,0.00,0.00,0.00,0.00),('5','182','954','225182',4339553,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','225182',4339554,'2840','426',551710.30,552093.61,383.31,62479.53,0.00,0.00,0.00,0.00,0.00),('5','182','955','225182',4339555,'2841','427',177763.41,177980.20,216.79,63953.05,0.00,0.00,0.00,0.00,0.00),('5','182','956','225182',4339556,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','225194',4339747,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','225194',4339748,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','225194',4339749,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','225194',4339750,'2840','426',552093.61,554031.14,1937.53,315817.39,0.00,0.00,0.00,0.00,0.00),('5','182','955','225194',4339751,'2841','427',177980.20,178260.84,280.64,82788.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','225194',4339752,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226600',4364810,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226600',4364811,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226600',4364812,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226600',4364813,'2840','426',554031.14,556342.21,2311.07,376704.41,0.00,0.00,0.00,0.00,0.00),('5','182','955','226600',4364814,'2841','427',178260.84,178975.42,714.58,210801.10,0.00,0.00,0.00,0.00,0.00),('5','182','956','226600',4364815,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226601',4364816,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226601',4364817,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226601',4364818,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226601',4364819,'2840','426',556342.21,558330.77,1988.56,324135.28,0.00,0.00,0.00,0.00,0.00),('5','182','955','226601',4364820,'2841','427',178975.42,179190.79,215.37,63534.15,0.00,0.00,0.00,0.00,0.00),('5','182','956','226601',4364821,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226606',4364923,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226606',4364924,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226606',4364925,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226606',4364926,'2840','426',558330.77,560882.26,2551.49,415892.87,0.00,0.00,0.00,0.00,0.00),('5','182','955','226606',4364927,'2841','427',179190.79,179432.43,241.64,71283.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','226606',4364928,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226611',4365014,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226611',4365015,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226611',4365016,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226611',4365017,'2840','426',560882.26,563192.39,2310.13,376551.19,0.00,0.00,0.00,0.00,0.00),('5','182','955','226611',4365018,'2841','427',179432.43,180102.69,670.26,197726.70,0.00,0.00,0.00,0.00,0.00),('5','182','956','226611',4365019,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226630',4365399,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226630',4365400,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226630',4365401,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226630',4365402,'2840','426',563192.39,565133.98,1941.59,316484994.77,0.00,0.00,0.00,0.00,0.00),('5','182','955','226630',4365403,'2841','427',180102.69,180835.74,733.05,216249.75,0.00,0.00,0.00,0.00,0.00),('5','182','956','226630',4365404,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226656',4365951,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','226656',4365952,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226656',4365953,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','226656',4365954,'2840','426',565133.98,565133.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','226656',4365955,'2841','427',180835.74,180835.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','226656',4365956,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231728',4458099,'2837','426',505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231728',4458100,'2838','426',338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231728',4458101,'2839','426',447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231728',4458102,'2840','426',565133.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231728',4458103,'2841','427',180835.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231728',4458104,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231730',4458129,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231730',4458130,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231730',4458131,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231730',4458132,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231730',4458133,'2841','427',184881.18,185184.51,303.33,90999.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231730',4458134,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231734',4458220,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231734',4458221,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231734',4458222,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231734',4458223,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231734',4458224,'2841','427',185184.51,185771.75,587.24,176172.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231734',4458225,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231739',4458320,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231739',4458321,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231739',4458322,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231739',4458323,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231739',4458324,'2841','427',185771.75,186010.86,239.11,71733.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231739',4458325,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231741',4458360,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231741',4458361,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231741',4458362,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231741',4458363,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231741',4458364,'2841','427',186010.86,186213.07,202.21,60663.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231741',4458365,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231743',4458382,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231743',4458383,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231743',4458384,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231743',4458385,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231743',4458386,'2841','427',186213.07,186545.55,332.48,103068.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','231743',4458387,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231744',4458388,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231744',4458389,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231744',4458390,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231744',4458391,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231744',4458392,'2841','427',186545.55,186724.01,178.46,55322.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','231744',4458393,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231748',4458451,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231748',4458452,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231748',4458453,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231748',4458454,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231748',4458455,'2841','427',186724.01,187008.99,284.98,88343.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','231748',4458456,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231752',4458521,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231752',4458522,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231752',4458523,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231752',4458524,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231752',4458525,'2841','427',187008.99,187371.21,362.22,112288.20,0.00,0.00,0.00,0.00,0.00),('5','182','956','231752',4458526,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231754',4458555,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231754',4458556,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231754',4458557,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231754',4458558,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231754',4458559,'2841','427',187371.21,187547.01,175.80,54498.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231754',4458560,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231757',4458599,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231757',4458600,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231757',4458601,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231757',4458602,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231757',4458603,'2841','427',187547.01,187681.77,134.76,41775.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','231757',4458604,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231760',4458647,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231760',4458648,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231760',4458649,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231760',4458650,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231760',4458651,'2841','427',187681.77,187820.60,138.83,43037.30,0.00,0.00,0.00,0.00,0.00),('5','182','956','231760',4458652,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231764',4458760,'2837','426',505177.82,505177.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231764',4458761,'2838','426',338778.06,338778.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231764',4458762,'2839','426',447134.33,447134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','231764',4458763,'2840','426',574363.22,574363.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231764',4458764,'2841','427',187820.60,188090.90,270.30,86496.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231764',4458765,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231765',4458766,'2837','426',505177.82,505661.11,483.29,78776.27,0.00,0.00,0.00,0.00,0.00),('5','182','953','231765',4458767,'2838','426',338778.06,339107.33,329.27,53671.34,0.00,0.00,0.00,0.00,0.00),('5','182','954','231765',4458768,'2839','426',447134.33,447256.29,121.96,19879.48,0.00,0.00,0.00,0.00,0.00),('5','182','954','231765',4458769,'2840','426',574363.22,574573.71,210.49,34309.87,0.00,0.00,0.00,0.00,0.00),('5','182','955','231765',4458770,'2841','427',188090.90,188839.15,748.25,239440.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','231765',4458771,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231770',4458857,'2837','426',505661.11,505936.95,275.84,44961.92,0.00,0.00,0.00,0.00,0.00),('5','182','953','231770',4458858,'2838','426',339107.33,339247.03,139.70,22771.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','231770',4458859,'2839','426',447256.29,448012.04,755.75,123187.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','231770',4458860,'2840','426',574573.71,575016.11,442.40,72111.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','231770',4458861,'2841','427',188839.15,189105.94,266.79,85372.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','231770',4458862,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','231782',4459120,'2837','426',505936.95,506702.15,765.20,124727.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','231782',4459121,'2838','426',339247.03,339692.39,445.36,72593.68,0.00,0.00,0.00,0.00,0.00),('5','182','954','231782',4459122,'2839','426',448012.04,448749.38,737.34,120186.42,0.00,0.00,0.00,0.00,0.00),('5','182','954','231782',4459123,'2840','426',575016.11,575016.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','231782',4459124,'2841','427',189105.94,189700.77,594.83,190345.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','231782',4459125,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232415',4470347,'2837','426',506702.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232415',4470348,'2838','426',339692.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','232415',4470349,'2839','426',448749.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','232415',4470350,'2840','426',575016.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','232415',4470351,'2841','427',189700.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','232415',4470352,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232418',4470394,'2837','426',506702.15,507424.26,722.11,117703.93,0.00,0.00,0.00,0.00,0.00),('5','182','953','232418',4470395,'2838','426',339692.39,339889.09,196.70,32062.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','232418',4470396,'2839','426',448749.38,449613.34,863.96,140825.48,0.00,0.00,0.00,0.00,0.00),('5','182','954','232418',4470397,'2840','426',575016.11,575016.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','232418',4470398,'2841','427',189700.77,191399.44,1698.67,543574.40,0.00,0.00,0.00,0.00,0.00),('5','182','956','232418',4470399,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232421',4470457,'2837','426',507424.26,508767.50,1343.24,218948.12,0.00,0.00,0.00,0.00,0.00),('5','182','953','232421',4470458,'2838','426',339889.09,340397.84,508.75,82926.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','232421',4470459,'2839','426',449613.34,451013.55,1400.21,228234.23,0.00,0.00,0.00,0.00,0.00),('5','182','954','232421',4470460,'2840','426',575016.11,575016.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','232421',4470461,'2841','427',191399.44,191927.83,528.39,169084.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','232421',4470462,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232435',4470712,'2837','426',508767.50,510109.93,1342.43,218816.09,0.00,0.00,0.00,0.00,0.00),('5','182','953','232435',4470713,'2838','426',340397.84,340397.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','232435',4470714,'2839','426',451013.55,452432.23,1418.68,231244.84,0.00,0.00,0.00,0.00,0.00),('5','182','954','232435',4470715,'2840','426',575016.11,575997.25,981.14,159925.82,0.00,0.00,0.00,0.00,0.00),('5','182','955','232435',4470716,'2841','427',191927.83,192362.54,434.71,142150.17,0.00,0.00,0.00,0.00,0.00),('5','182','956','232435',4470717,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232919',4479478,'2837','426',510109.93,511485.80,1375.87,224266.81,0.00,0.00,0.00,0.00,0.00),('5','182','953','232919',4479479,'2838','426',340397.84,341241.04,843.20,137441.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','232919',4479480,'2839','426',452432.23,453421.25,989.02,161210.26,0.00,0.00,0.00,0.00,0.00),('5','182','954','232919',4479481,'2840','426',575997.25,575997.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','232919',4479482,'2841','427',192362.54,193365.44,1002.90,327948.30,0.00,0.00,0.00,0.00,0.00),('5','182','956','232919',4479483,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','232930',4479641,'2837','426',511485.80,513032.43,1546.63,252100.69,0.00,0.00,0.00,0.00,0.00),('5','182','953','232930',4479642,'2838','426',341241.04,342078.82,837.78,136558.14,0.00,0.00,0.00,0.00,0.00),('5','182','954','232930',4479643,'2839','426',453421.25,455272.90,1851.65,301818.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','232930',4479644,'2840','426',575997.25,575997.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','232930',4479645,'2841','427',193365.44,194539.43,1173.99,387416.70,0.00,0.00,0.00,0.00,0.00),('5','182','956','232930',4479646,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','233199',4484540,'2837','426',513032.43,513932.10,899.67,146646.21,0.00,0.00,0.00,0.00,0.00),('5','182','953','233199',4484541,'2838','426',342078.82,343133.17,1054.35,171859.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','233199',4484542,'2839','426',455272.90,456642.03,1369.13,223168.19,0.00,0.00,0.00,0.00,0.00),('5','182','954','233199',4484543,'2840','426',575997.25,575997.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','233199',4484544,'2841','427',194539.43,195340.26,800.83,276286.35,0.00,0.00,0.00,0.00,0.00),('5','182','956','233199',4484545,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','233476',4489518,'2837','426',513932.10,514426.32,494.22,80557.86,0.00,0.00,0.00,0.00,0.00),('5','182','953','233476',4489519,'2838','426',343133.17,344128.97,995.80,162315.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','233476',4489520,'2839','426',456642.03,457854.29,1212.26,197598.38,0.00,0.00,0.00,0.00,0.00),('5','182','954','233476',4489521,'2840','426',575997.25,575997.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','233476',4489522,'2841','427',195340.26,195590.50,250.24,86332.80,0.00,0.00,0.00,0.00,0.00),('5','182','956','233476',4489523,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234152',4501899,'2837','426',514426.32,514504.02,77.70,12665.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','234152',4501900,'2838','426',344128.97,344138.13,9.16,1493.08,0.00,0.00,0.00,0.00,0.00),('5','182','954','234152',4501901,'2839','426',457854.29,459193.39,1339.10,218273.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','234152',4501902,'2840','426',575997.25,577005.46,1008.21,164338.23,0.00,0.00,0.00,0.00,0.00),('5','182','955','234152',4501903,'2841','427',195590.50,195987.81,397.31,137071.95,0.00,0.00,0.00,0.00,0.00),('5','182','956','234152',4501904,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234154',4501929,'2837','426',514504.02,514504.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234154',4501930,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','234154',4501931,'2839','426',459193.39,460541.45,1348.06,219733.78,0.00,0.00,0.00,0.00,0.00),('5','182','954','234154',4501932,'2840','426',577005.46,578036.99,1031.53,168139.39,0.00,0.00,0.00,0.00,0.00),('5','182','955','234154',4501933,'2841','427',195987.81,196082.61,94.80,32706.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','234154',4501934,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234158',4501993,'2837','426',514504.02,514504.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234158',4501994,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','234158',4501995,'2839','426',460541.45,462327.98,1786.53,291204.39,0.00,0.00,0.00,0.00,0.00),('5','182','954','234158',4501996,'2840','426',578036.99,579972.21,1935.22,315440.86,0.00,0.00,0.00,0.00,0.00),('5','182','955','234158',4501997,'2841','427',196082.61,196216.26,133.65,46109.25,0.00,0.00,0.00,0.00,0.00),('5','182','956','234158',4501998,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234381',4505908,'2837','426',514504.02,514504.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234381',4505909,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','234381',4505910,'2839','426',462327.98,463961.26,1633.28,269491.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','234381',4505911,'2840','426',579972.21,581213.48,1241.27,204809.55,0.00,0.00,0.00,0.00,0.00),('5','182','955','234381',4505912,'2841','427',196216.26,196556.63,340.37,117427.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','234381',4505913,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234675',4511230,'2837','426',514504.02,514504.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234675',4511231,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','234675',4511232,'2839','426',463961.26,465899.80,1938.54,319859.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','234675',4511233,'2840','426',581213.48,582781.30,1567.82,258690.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','234675',4511234,'2841','427',196556.63,196696.59,139.96,48286.20,0.00,0.00,0.00,0.00,0.00),('5','182','956','234675',4511235,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234936',4515892,'2837','426',514504.02,514504.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','234936',4515893,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','234936',4515894,'2839','426',465899.80,466807.92,908.12,149839.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','234936',4515895,'2840','426',582781.30,584320.24,1538.94,253925.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','234936',4515896,'2841','427',196696.59,197603.36,906.77,312835.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','234936',4515897,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237758',4565268,'2837','426',514504.02,515248.65,744.63,122863.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','237758',4565269,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237758',4565270,'2839','426',466807.92,467658.29,850.37,140311.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','237758',4565271,'2840','426',584320.24,584320.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237758',4565272,'2841','427',197603.36,198107.58,504.22,173955.90,0.00,0.00,0.00,0.00,0.00),('5','182','956','237758',4565273,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237764',4565348,'2837','426',515248.65,516607.43,1358.78,224198.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','237764',4565349,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237764',4565350,'2839','426',467658.29,469247.94,1589.65,262292.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','237764',4565351,'2840','426',584320.24,585633.49,1313.25,216686.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','237764',4565352,'2841','427',198107.58,198338.60,231.02,79701.90,0.00,0.00,0.00,0.00,0.00),('5','182','956','237764',4565353,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237767',4565394,'2837','426',516607.43,518393.99,1786.56,294782.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','237767',4565395,'2838','426',344138.13,344138.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237767',4565396,'2839','426',469247.94,471183.65,1935.71,319392.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','237767',4565397,'2840','426',585633.49,587116.50,1483.01,244696.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','237767',4565398,'2841','427',198338.60,198393.71,55.11,19012.95,0.00,0.00,0.00,0.00,0.00),('5','182','956','237767',4565399,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237768',4565400,'2837','426',518393.99,521251.02,2857.03,471409.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','237768',4565401,'2838','426',344138.13,344462.97,324.84,53598.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','237768',4565402,'2839','426',471183.65,474388.35,3204.70,528775.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','237768',4565403,'2840','426',587116.50,590480.11,3363.61,554995.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','237768',4565404,'2841','427',198393.71,198998.19,604.48,208545.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','237768',4565405,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237769',4565406,'2837','426',521251.02,525315.93,4064.91,670710.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','237769',4565407,'2838','426',344462.97,348512.00,4049.03,668089.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','237769',4565408,'2839','426',474388.35,478933.44,4545.09,749939.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','237769',4565409,'2840','426',590480.11,594198.98,3718.87,613613.55,0.00,0.00,0.00,0.00,0.00),('5','182','955','237769',4565410,'2841','427',198998.19,200035.54,1037.35,357885.75,0.00,0.00,0.00,0.00,0.00),('5','182','956','237769',4565411,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237770',4565412,'2837','426',525315.93,526458.95,1143.02,188598.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','237770',4565413,'2838','426',348512.00,349608.74,1096.74,180962.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','237770',4565414,'2839','426',478933.44,482555.85,3622.41,597697.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','237770',4565415,'2840','426',594198.98,599734.42,5535.44,913347.60,0.00,0.00,0.00,0.00,0.00),('5','182','955','237770',4565416,'2841','427',200035.54,200650.22,614.68,212064.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','237770',4565417,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237959',4568639,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237959',4568640,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237959',4568641,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237959',4568642,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237959',4568643,'2841','427',200650.22,201150.22,500.00,172500.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','237959',4568644,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237960',4568645,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237960',4568646,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237960',4568647,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237960',4568648,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237960',4568649,'2841','427',201150.22,201499.13,348.91,120373.95,0.00,0.00,0.00,0.00,0.00),('5','182','956','237960',4568650,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237962',4568661,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237962',4568662,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237962',4568663,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237962',4568664,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237962',4568665,'2841','427',201499.13,201711.58,212.45,73295.25,0.00,0.00,0.00,0.00,0.00),('5','182','956','237962',4568666,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237963',4568667,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237963',4568668,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237963',4568669,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237963',4568670,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237963',4568671,'2841','427',201711.58,202211.75,500.17,172558.65,0.00,0.00,0.00,0.00,0.00),('5','182','956','237963',4568672,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237965',4568681,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237965',4568682,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237965',4568683,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237965',4568684,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237965',4568685,'2841','427',202211.75,202494.67,282.92,97607.40,0.00,0.00,0.00,0.00,0.00),('5','182','956','237965',4568686,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237968',4568723,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237968',4568724,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237968',4568725,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237968',4568726,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237968',4568727,'2841','427',202494.67,203121.42,626.75,216228.75,0.00,0.00,0.00,0.00,0.00),('5','182','956','237968',4568728,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237969',4568729,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','237969',4568730,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237969',4568731,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','237969',4568732,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','237969',4568733,'2841','427',203121.42,203573.22,451.80,155871.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','237969',4568734,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','238255',4573551,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','238255',4573552,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','238255',4573553,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','238255',4573554,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','238255',4573555,'2841','427',203573.22,203573.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','238255',4573556,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239138',4588957,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239138',4588958,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239138',4588959,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239138',4588960,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','239138',4588961,'2841','427',203573.22,203813.85,240.63,83017.35,0.00,0.00,0.00,0.00,0.00),('5','182','956','239138',4588962,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239149',4589134,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239149',4589135,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239149',4589136,'2839','426',482555.85,482555.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239149',4589137,'2840','426',599734.42,599734.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','239149',4589138,'2841','427',203813.85,204091.68,277.83,95851.35,0.00,0.00,0.00,0.00,0.00),('5','182','956','239149',4589139,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239164',4589380,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239164',4589381,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239164',4589382,'2839','426',482555.85,484480.29,1924.44,317532.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','239164',4589383,'2840','426',599734.42,601657.95,1923.53,317382.45,0.00,0.00,0.00,0.00,0.00),('5','182','955','239164',4589384,'2841','427',204091.68,204141.68,50.00,17250.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','239164',4589385,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239371',4592837,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239371',4592838,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239371',4592839,'2839','426',484480.29,489356.68,4876.39,804604.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','239371',4592840,'2840','426',601657.95,607410.53,5752.58,949175.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','239371',4592841,'2841','427',204141.68,204141.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','239371',4592842,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239383',4593045,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239383',4593046,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239383',4593047,'2839','426',489356.68,489356.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239383',4593048,'2840','426',607410.53,614075.09,6664.56,1099652.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','239383',4593049,'2841','427',204141.68,204141.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','239383',4593050,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239841',4601003,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','239841',4601004,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239841',4601005,'2839','426',489356.68,491782.48,2425.80,400257.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','239841',4601006,'2840','426',614075.09,618575.63,4500.54,742589.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','239841',4601007,'2841','427',204141.68,204153.57,11.89,4102.05,0.00,0.00,0.00,0.00,0.00),('5','182','956','239841',4601008,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240063',4604867,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240063',4604868,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240063',4604869,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240063',4604870,'2840','426',618575.63,620585.21,2009.58,331580.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','240063',4604871,'2841','427',204153.57,204153.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','240063',4604872,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240760',4616147,'2837','426',526458.95,526458.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240760',4616148,'2838','426',349608.74,349608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240760',4616149,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240760',4616150,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','240760',4616151,'2841','427',204153.57,204153.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','240760',4616152,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240763',4616185,'2837','426',526458.95,529386.58,2927.63,483058.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','240763',4616186,'2838','426',349608.74,352420.36,2811.62,463917.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','240763',4616187,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240763',4616188,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','240763',4616189,'2841','427',204153.57,204173.57,20.00,6900.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','240763',4616190,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240777',4616392,'2837','426',529386.58,532690.52,3303.94,545150.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','240777',4616393,'2838','426',352420.36,355545.83,3125.47,515702.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','240777',4616394,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240777',4616395,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','240777',4616396,'2841','427',204173.57,204173.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','240777',4616397,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','240788',4616612,'2837','426',532690.52,535773.84,3083.32,508747.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','240788',4616613,'2838','426',355545.83,358429.26,2883.43,475765.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','240788',4616614,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','240788',4616615,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','240788',4616616,'2841','427',204173.57,204173.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','240788',4616617,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241317',4626015,'2837','426',535773.84,538930.53,3156.69,520853.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','241317',4626016,'2838','426',358429.26,361990.52,3561.26,587607.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','241317',4626017,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241317',4626018,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','241317',4626019,'2841','427',204173.57,204173.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','241317',4626020,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241583',4630631,'2837','426',538930.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241583',4630632,'2838','426',361990.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241583',4630633,'2839','426',491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241583',4630634,'2840','426',620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','241583',4630635,'2841','427',204173.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','241583',4630636,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241595',4630795,'2837','426',538930.53,541134.44,2203.91,363645.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','241595',4630796,'2838','426',361990.52,364006.26,2015.74,332597.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','241595',4630797,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241595',4630798,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','241595',4630799,'2841','427',204173.57,204183.85,10.28,3546.60,0.00,0.00,0.00,0.00,0.00),('5','182','956','241595',4630800,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241601',4630874,'2837','426',541134.44,541761.27,626.83,103426.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','241601',4630875,'2838','426',364006.26,364562.73,556.47,91817.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','241601',4630876,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241601',4630877,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','241601',4630878,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','241601',4630879,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241837',4634922,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','241837',4634923,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241837',4634924,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','241837',4634925,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','241837',4634926,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','241837',4634927,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242995',4655180,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242995',4655181,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242995',4655182,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242995',4655183,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','242995',4655184,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','242995',4655185,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242997',4655194,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242997',4655195,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242997',4655196,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242997',4655197,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','242997',4655198,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','242997',4655199,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242999',4655214,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','242999',4655215,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242999',4655216,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','242999',4655217,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','242999',4655218,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','242999',4655219,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243000',4655220,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243000',4655221,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243000',4655222,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243000',4655223,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','243000',4655224,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','243000',4655225,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243287',4660405,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243287',4660406,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243287',4660407,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243287',4660408,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','243287',4660409,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','243287',4660410,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243428',4662819,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','243428',4662820,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243428',4662821,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','243428',4662822,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','243428',4662823,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','243428',4662824,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244101',4674470,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244101',4674471,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244101',4674472,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244101',4674473,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244101',4674474,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244101',4674475,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244103',4674487,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244103',4674488,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244103',4674489,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244103',4674490,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244103',4674491,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244103',4674492,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244107',4674577,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244107',4674578,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244107',4674579,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244107',4674580,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244107',4674581,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244107',4674582,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244110',4674603,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244110',4674604,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244110',4674605,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244110',4674606,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244110',4674607,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244110',4674608,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244398',4679779,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244398',4679780,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244398',4679781,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244398',4679782,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244398',4679783,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244398',4679784,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244570',4682450,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244570',4682451,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244570',4682452,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244570',4682453,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244570',4682454,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244570',4682455,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244817',4686818,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','244817',4686819,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244817',4686820,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','244817',4686821,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','244817',4686822,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','244817',4686823,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245107',4691921,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245107',4691922,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245107',4691923,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245107',4691924,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','245107',4691925,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','245107',4691926,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245380',4696867,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245380',4696868,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245380',4696869,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245380',4696870,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','245380',4696871,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','245380',4696872,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245487',4698436,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245487',4698437,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245487',4698438,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245487',4698439,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','245487',4698440,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','245487',4698441,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245788',4703750,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','245788',4703751,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245788',4703752,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','245788',4703753,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','245788',4703754,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','245788',4703755,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246033',4707424,'2837','426',541761.27,541761.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246033',4707425,'2838','426',364562.73,364562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','246033',4707426,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','246033',4707427,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','246033',4707428,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','246033',4707429,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246273',4711476,'2837','426',541761.27,542411.03,649.76,107210.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','246273',4711477,'2838','426',364562.73,365329.60,766.87,126533.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','246273',4711478,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','246273',4711479,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','246273',4711480,'2841','427',204183.85,204183.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','246273',4711481,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246529',4715806,'2837','426',542411.03,544106.11,1695.08,279688.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','246529',4715807,'2838','426',365329.60,366748.24,1418.64,234075.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','246529',4715808,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','246529',4715809,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','246529',4715810,'2841','427',204183.85,204231.97,48.12,16601.40,0.00,0.00,0.00,0.00,0.00),('5','182','956','246529',4715811,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246776',4720126,'2837','426',544106.11,545522.51,1416.40,233706.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','246776',4720127,'2838','426',366748.24,367906.46,1158.22,191106.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','246776',4720128,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','246776',4720129,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','246776',4720130,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','246776',4720131,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','247117',4726144,'2837','426',545522.51,546966.25,1443.74,238217.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','247117',4726145,'2838','426',367906.46,369088.94,1182.48,195109.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','247117',4726146,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','247117',4726147,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','247117',4726148,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','247117',4726149,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','247354',4730461,'2837','426',546966.25,548137.14,1170.89,193196.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','247354',4730462,'2838','426',369088.94,370183.39,1094.45,180584.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','247354',4730463,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','247354',4730464,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','247354',4730465,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','247354',4730466,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','247408',4731125,'2837','426',548137.14,549373.64,1236.50,204022.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','247408',4731126,'2838','426',370183.39,371130.46,947.07,156266.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','247408',4731127,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','247408',4731128,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','247408',4731129,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','247408',4731130,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','247725',4736534,'2837','426',549373.64,549696.10,322.46,53205.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','247725',4736535,'2838','426',371130.46,371410.79,280.33,46254.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','247725',4736536,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','247725',4736537,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','247725',4736538,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','247725',4736539,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248015',4741342,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248015',4741343,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248015',4741344,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248015',4741345,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','248015',4741346,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','248015',4741347,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248174',4744059,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248174',4744060,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248174',4744061,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248174',4744062,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','248174',4744063,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','248174',4744064,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248563',4750767,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248563',4750768,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248563',4750769,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248563',4750770,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','248563',4750771,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','248563',4750772,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248812',4755077,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248812',4755078,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248812',4755079,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248812',4755080,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','248812',4755081,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','248812',4755082,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248970',4757582,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','248970',4757583,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248970',4757584,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','248970',4757585,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','248970',4757586,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','248970',4757587,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249206',4761402,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249206',4761403,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249206',4761404,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249206',4761405,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','249206',4761406,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','249206',4761407,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249484',4766332,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249484',4766333,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249484',4766334,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249484',4766335,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','249484',4766336,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','249484',4766337,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249794',4771660,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','249794',4771661,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249794',4771662,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','249794',4771663,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','249794',4771664,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','249794',4771665,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250123',4776818,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250123',4776819,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250123',4776820,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250123',4776821,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','250123',4776822,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','250123',4776823,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250185',4778025,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250185',4778026,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250185',4778027,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250185',4778028,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','250185',4778029,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','250185',4778030,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250407',4781600,'2837','426',549696.10,549696.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250407',4781601,'2838','426',371410.79,371410.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250407',4781602,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250407',4781603,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','250407',4781604,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','250407',4781605,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250737',4787485,'2837','426',549696.10,551758.83,2062.73,340350.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','250737',4787486,'2838','426',371410.79,373209.58,1798.79,296800.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','250737',4787487,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250737',4787488,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','250737',4787489,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','250737',4787490,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','250878',4789872,'2837','426',551758.83,553897.00,2138.17,352798.05,0.00,0.00,0.00,0.00,0.00),('5','182','953','250878',4789873,'2838','426',373209.58,374674.96,1465.38,241787.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','250878',4789874,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','250878',4789875,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','250878',4789876,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','250878',4789877,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','251088',4793430,'2837','426',553897.00,559194.98,5297.98,874166.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','251088',4793431,'2838','426',374674.96,374687.08,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','251088',4793432,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','251088',4793433,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','251088',4793434,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','251088',4793435,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','251370',4798460,'2837','426',559194.98,562379.47,3184.49,525440.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','251370',4798461,'2838','426',374687.08,374946.04,258.96,42728.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','251370',4798462,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','251370',4798463,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','251370',4798464,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','251370',4798465,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','251622',4802844,'2837','426',562379.47,563998.13,1618.66,267078.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','251622',4802845,'2838','426',374946.04,376502.04,1556.00,256740.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','251622',4802846,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','251622',4802847,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','251622',4802848,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','251622',4802849,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','251832',4806480,'2837','426',563998.13,565680.61,1682.48,277609.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','251832',4806481,'2838','426',376502.04,378023.55,1521.51,251049.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','251832',4806482,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','251832',4806483,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','251832',4806484,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','251832',4806485,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252450',4817620,'2837','426',565680.61,565680.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252450',4817621,'2838','426',378023.55,378023.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252450',4817622,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252450',4817623,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','252450',4817624,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','252450',4817625,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252580',4819709,'2837','426',565680.61,565680.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252580',4819710,'2838','426',378023.55,378023.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252580',4819711,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252580',4819712,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','252580',4819713,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','252580',4819714,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252582',4819721,'2837','426',565680.61,565680.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252582',4819722,'2838','426',378023.55,378023.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252582',4819723,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252582',4819724,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','252582',4819725,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','252582',4819726,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','252935',4825705,'2837','426',565680.61,566362.13,681.52,112450.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','252935',4825706,'2838','426',378023.55,378534.36,510.81,84283.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','252935',4825707,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','252935',4825708,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','252935',4825709,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','252935',4825710,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','253152',4829443,'2837','426',566362.13,568561.34,2199.21,362869.65,0.00,0.00,0.00,0.00,0.00),('5','182','953','253152',4829444,'2838','426',378534.36,380179.31,1644.95,271416.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','253152',4829445,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','253152',4829446,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','253152',4829447,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','253152',4829448,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','253265',4831061,'2837','426',568561.34,571545.68,2984.34,492416.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','253265',4831062,'2838','426',380179.31,382977.66,2798.35,461727.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','253265',4831063,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','253265',4831064,'2840','426',620585.21,620585.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','253265',4831065,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','253265',4831066,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','253516',4835246,'2837','426',571545.68,573670.81,2125.13,350646.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','253516',4835247,'2838','426',382977.66,384285.10,1307.44,215727.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','253516',4835248,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','253516',4835249,'2840','426',620585.21,622184.62,1599.41,263902.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','253516',4835250,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','253516',4835251,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','253948',4843010,'2837','426',573670.81,575398.43,1727.62,285057.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','253948',4843011,'2838','426',384285.10,385829.77,1544.67,254870.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','253948',4843012,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','253948',4843013,'2840','426',622184.62,623520.07,1335.45,220349.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','253948',4843014,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','253948',4843015,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','253958',4843064,'2837','426',575398.43,579527.92,4129.49,681365.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','253958',4843065,'2838','426',385829.77,389880.18,4050.41,668317.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','253958',4843066,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','253958',4843067,'2840','426',623520.07,623520.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','253958',4843068,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','253958',4843069,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254281',4848739,'2837','426',579527.92,581747.00,2219.08,366148.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','254281',4848740,'2838','426',389880.18,391260.99,1380.81,227833.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','254281',4848741,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','254281',4848742,'2840','426',623520.07,625775.62,2255.55,372165.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','254281',4848743,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','254281',4848744,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254481',4852049,'2837','426',581747.00,582587.02,840.02,138603.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','254481',4852050,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','254481',4852051,'2839','426',491782.48,491782.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','254481',4852052,'2840','426',625775.62,628332.50,2556.88,421885.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','254481',4852053,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','254481',4852054,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254717',4856243,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254717',4856244,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','254717',4856245,'2839','426',491782.48,493305.62,1523.14,251318.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','254717',4856246,'2840','426',628332.50,631544.70,3212.20,530013.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','254717',4856247,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','254717',4856248,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254947',4860287,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','254947',4860288,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','254947',4860289,'2839','426',493305.62,493914.09,608.47,100397.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','254947',4860290,'2840','426',631544.70,631889.83,345.13,56946.45,0.00,0.00,0.00,0.00,0.00),('5','182','955','254947',4860291,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','254947',4860292,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255284',4866270,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255284',4866271,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255284',4866272,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255284',4866273,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','255284',4866274,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','255284',4866275,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255531',4870040,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.01,0.00),('5','182','953','255531',4870041,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255531',4870042,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255531',4870043,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','255531',4870044,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','255531',4870045,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255740',4873595,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255740',4873596,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255740',4873597,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255740',4873598,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','255740',4873599,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','255740',4873600,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255981',4877502,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','255981',4877503,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255981',4877504,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','255981',4877505,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','255981',4877506,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','255981',4877507,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256362',4883855,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256362',4883856,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256362',4883857,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256362',4883858,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','256362',4883859,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','256362',4883860,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256511',4886371,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256511',4886372,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256511',4886373,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256511',4886374,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','256511',4886375,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','256511',4886376,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256764',4890464,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256764',4890465,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256764',4890466,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256764',4890467,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','256764',4890468,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','256764',4890469,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256959',4894114,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','256959',4894115,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256959',4894116,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','256959',4894117,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','256959',4894118,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','256959',4894119,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257270',4899557,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257270',4899558,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257270',4899559,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257270',4899560,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257270',4899561,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257270',4899562,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257489',4903513,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257489',4903514,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257489',4903515,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257489',4903516,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257489',4903517,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257489',4903518,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257490',4903519,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257490',4903520,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257490',4903521,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257490',4903522,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257490',4903523,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257490',4903524,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257491',4903525,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257491',4903526,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257491',4903527,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257491',4903528,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257491',4903529,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257491',4903530,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257492',4903531,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257492',4903532,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257492',4903533,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257492',4903534,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257492',4903535,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257492',4903536,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257493',4903537,'2837','426',582587.02,582587.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257493',4903538,'2838','426',391260.99,391260.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257493',4903539,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257493',4903540,'2840','426',631889.83,631889.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257493',4903541,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257493',4903542,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257494',4903543,'2837','426',582587.02,583463.08,876.06,144549.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','257494',4903544,'2838','426',391260.99,391931.92,670.93,110703.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257494',4903545,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257494',4903546,'2840','426',631889.83,632321.43,431.60,71214.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257494',4903547,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257494',4903548,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257495',4903549,'2837','426',583463.08,585843.23,2380.15,392724.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257495',4903550,'2838','426',391931.92,394119.18,2187.26,360897.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','257495',4903551,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257495',4903552,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257495',4903553,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257495',4903554,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257496',4903555,'2837','426',585843.23,586705.72,862.49,142310.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257496',4903556,'2838','426',394119.18,397318.38,3199.20,527868.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257496',4903557,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257496',4903558,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257496',4903559,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257496',4903560,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257497',4903561,'2837','426',586705.72,589410.83,2705.11,446343.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','257497',4903562,'2838','426',397318.38,398677.83,1359.45,224309.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257497',4903563,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257497',4903564,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257497',4903565,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257497',4903566,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257498',4903567,'2837','426',589410.83,590752.98,1342.15,221454.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257498',4903568,'2838','426',398677.83,398677.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257498',4903569,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257498',4903570,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257498',4903571,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257498',4903572,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257499',4903573,'2837','426',590752.98,590752.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257499',4903574,'2838','426',398677.83,398677.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257499',4903575,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257499',4903576,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257499',4903577,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257499',4903578,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257500',4903579,'2837','426',590752.98,590752.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257500',4903580,'2838','426',398677.83,398677.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257500',4903581,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257500',4903582,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257500',4903583,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257500',4903584,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257501',4903585,'2837','426',590752.98,591252.58,499.60,82434.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257501',4903586,'2838','426',398677.83,399268.83,591.00,97515.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257501',4903587,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257501',4903588,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257501',4903589,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257501',4903590,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257502',4903591,'2837','426',591252.58,594261.08,3008.50,496402.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257502',4903592,'2838','426',399268.83,401271.72,2002.89,330476.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','257502',4903593,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257502',4903594,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257502',4903595,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257502',4903596,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257503',4903597,'2837','426',594261.08,597261.20,3000.12,495019.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','257503',4903598,'2838','426',401271.72,403370.97,2099.25,346376.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257503',4903599,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257503',4903600,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257503',4903601,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257503',4903602,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257504',4903603,'2837','426',597261.20,597363.35,102.15,16854.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257504',4903604,'2838','426',403370.97,408531.13,5160.16,851426.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257504',4903605,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257504',4903606,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257504',4903607,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257504',4903608,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257505',4903609,'2837','426',597363.35,602446.05,5082.70,838645.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257505',4903610,'2838','426',408531.13,408531.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257505',4903611,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257505',4903612,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257505',4903613,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257505',4903614,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257506',4903615,'2837','426',602446.05,602446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257506',4903616,'2838','426',408531.13,409185.63,654.50,107992.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257506',4903617,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257506',4903618,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257506',4903619,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257506',4903620,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257507',4903621,'2837','426',602446.05,602446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257507',4903622,'2838','426',409185.63,409185.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257507',4903623,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257507',4903624,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257507',4903625,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257507',4903626,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257508',4903627,'2837','426',602446.05,602446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257508',4903628,'2838','426',409185.63,409185.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257508',4903629,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257508',4903630,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257508',4903631,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257508',4903632,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257509',4903633,'2837','426',602446.05,602446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257509',4903634,'2838','426',409185.63,409185.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257509',4903635,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257509',4903636,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257509',4903637,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257509',4903638,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257510',4903639,'2837','426',602446.05,602446.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257510',4903640,'2838','426',409185.63,409185.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257510',4903641,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257510',4903642,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257510',4903643,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257510',4903644,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257511',4903645,'2837','426',602446.05,602896.05,450.00,74250.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257511',4903646,'2838','426',409185.63,409635.13,449.50,74167.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257511',4903647,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257511',4903648,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257511',4903649,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257511',4903650,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257512',4903651,'2837','426',602896.05,610230.94,7334.89,1210256.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257512',4903652,'2838','426',409635.13,410933.18,1298.05,214178.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257512',4903653,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257512',4903654,'2840','426',632321.43,632321.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257512',4903655,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257512',4903656,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257513',4903657,'2837','426',610230.94,610431.79,200.85,33140.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257513',4903658,'2838','426',410933.18,416289.60,5356.42,883809.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257513',4903659,'2839','426',493914.09,493914.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257513',4903660,'2840','426',632321.43,635324.59,3003.16,495521.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257513',4903661,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257513',4903662,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257514',4903663,'2837','426',610431.79,610431.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257514',4903664,'2838','426',416289.60,416289.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257514',4903665,'2839','426',493914.09,495725.09,1811.00,298815.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257514',4903666,'2840','426',635324.59,642609.38,7284.79,1201990.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','257514',4903667,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257514',4903668,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257515',4903669,'2837','426',610431.79,614667.79,4236.00,698940.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257515',4903670,'2838','426',416289.60,418434.12,2144.52,353845.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','257515',4903671,'2839','426',495725.09,495725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257515',4903672,'2840','426',642609.38,642609.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257515',4903673,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257515',4903674,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257516',4903675,'2837','426',614667.79,624114.09,9446.30,1558639.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257516',4903676,'2838','426',418434.12,427439.37,9005.25,1485866.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257516',4903677,'2839','426',495725.09,495725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257516',4903678,'2840','426',642609.38,642609.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257516',4903679,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257516',4903680,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257517',4903681,'2837','426',624114.09,628676.34,4562.25,752771.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257517',4903682,'2838','426',427439.37,432941.62,5502.25,907871.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257517',4903683,'2839','426',495725.09,495725.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257517',4903684,'2840','426',642609.38,642609.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257517',4903685,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257517',4903686,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257518',4903687,'2837','426',628676.34,629336.09,659.75,108858.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257518',4903688,'2838','426',432941.62,439175.52,6233.90,1028593.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257518',4903689,'2839','426',495725.09,496694.97,969.88,160030.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257518',4903690,'2840','426',642609.38,642609.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257518',4903691,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257518',4903692,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257519',4903693,'2837','426',629336.09,635576.93,6240.84,1029738.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257519',4903694,'2838','426',439175.52,447468.28,8292.76,1368305.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257519',4903695,'2839','426',496694.97,497067.30,372.33,61434.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257519',4903696,'2840','426',642609.38,643219.86,610.48,100729.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','257519',4903697,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257519',4903698,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257520',4903699,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257520',4903700,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257520',4903701,'2839','426',497067.30,500317.50,3250.20,536283.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257520',4903702,'2840','426',643219.86,645822.06,2602.20,429363.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257520',4903703,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257520',4903704,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257521',4903705,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257521',4903706,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257521',4903707,'2839','426',500317.50,500445.84,128.34,21176.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','257521',4903708,'2840','426',645822.06,650558.51,4736.45,781514.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','257521',4903709,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257521',4903710,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257522',4903711,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257522',4903712,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257522',4903713,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257522',4903714,'2840','426',650558.51,651670.56,1112.05,183488.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','257522',4903715,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257522',4903716,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257523',4903717,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257523',4903718,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257523',4903719,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257523',4903720,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257523',4903721,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257523',4903722,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257524',4903723,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257524',4903724,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257524',4903725,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257524',4903726,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257524',4903727,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257524',4903728,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257525',4903729,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257525',4903730,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257525',4903731,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257525',4903732,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257525',4903733,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257525',4903734,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257526',4903735,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257526',4903736,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257526',4903737,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257526',4903738,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257526',4903739,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257526',4903740,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257527',4903741,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257527',4903742,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257527',4903743,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257527',4903744,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257527',4903745,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257527',4903746,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257528',4903747,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257528',4903748,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257528',4903749,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257528',4903750,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257528',4903751,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257528',4903752,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257529',4903753,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257529',4903754,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257529',4903755,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257529',4903756,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257529',4903757,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257529',4903758,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257530',4903759,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257530',4903760,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257530',4903761,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257530',4903762,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257530',4903763,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257530',4903764,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257531',4903765,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257531',4903766,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257531',4903767,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257531',4903768,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257531',4903769,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257531',4903770,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257532',4903771,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257532',4903772,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257532',4903773,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257532',4903774,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257532',4903775,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257532',4903776,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257533',4903777,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257533',4903778,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257533',4903779,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257533',4903780,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257533',4903781,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257533',4903782,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257534',4903783,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257534',4903784,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257534',4903785,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257534',4903786,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257534',4903787,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257534',4903788,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257535',4903789,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257535',4903790,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257535',4903791,'2839','426',500445.84,500445.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257535',4903792,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257535',4903793,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257535',4903794,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257536',4903795,'2837','426',635576.93,635576.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257536',4903796,'2838','426',447468.28,447468.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257536',4903797,'2839','426',500445.84,501195.84,750.00,123750.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257536',4903798,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257536',4903799,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257536',4903800,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257537',4903801,'2837','426',635576.93,639076.26,3499.33,577389.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','257537',4903802,'2838','426',447468.28,448089.27,620.99,102463.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257537',4903803,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257537',4903804,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257537',4903805,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257537',4903806,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257538',4903807,'2837','426',639076.26,641340.46,2264.20,373593.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257538',4903808,'2838','426',448089.27,448891.27,802.00,132330.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257538',4903809,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257538',4903810,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257538',4903811,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257538',4903812,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257539',4903813,'2837','426',641340.46,641340.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257539',4903814,'2838','426',448891.27,452993.27,4102.00,676830.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257539',4903815,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257539',4903816,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257539',4903817,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257539',4903818,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257540',4903819,'2837','426',641340.46,641410.63,70.17,11578.05,0.00,0.00,0.00,0.00,0.00),('5','182','953','257540',4903820,'2838','426',452993.27,454420.59,1427.32,235507.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','257540',4903821,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257540',4903822,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257540',4903823,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257540',4903824,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257541',4903825,'2837','426',641410.63,641410.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257541',4903826,'2838','426',454420.59,454420.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257541',4903827,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257541',4903828,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257541',4903829,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257541',4903830,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257542',4903831,'2837','426',641410.63,641410.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257542',4903832,'2838','426',454420.59,455125.50,704.91,116310.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','257542',4903833,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257542',4903834,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257542',4903835,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257542',4903836,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257543',4903837,'2837','426',641410.63,644003.71,2593.08,427858.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257543',4903838,'2838','426',455125.50,458025.48,2899.98,478496.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257543',4903839,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257543',4903840,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257543',4903841,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257543',4903842,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257544',4903843,'2837','426',644003.71,645504.80,1501.09,247679.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257544',4903844,'2838','426',458025.48,463812.53,5787.05,954863.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257544',4903845,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257544',4903846,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257544',4903847,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257544',4903848,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257545',4903849,'2837','426',645504.80,647611.85,2107.05,347663.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257545',4903850,'2838','426',463812.53,465552.01,1739.48,287014.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257545',4903851,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257545',4903852,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257545',4903853,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257545',4903854,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257546',4903855,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257546',4903856,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257546',4903857,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257546',4903858,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257546',4903859,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257546',4903860,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257547',4903861,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257547',4903862,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257547',4903863,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257547',4903864,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257547',4903865,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257547',4903866,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257548',4903867,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257548',4903868,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257548',4903869,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257548',4903870,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257548',4903871,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257548',4903872,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257549',4903873,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257549',4903874,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257549',4903875,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257549',4903876,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257549',4903877,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257549',4903878,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257550',4903879,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257550',4903880,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257550',4903881,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257550',4903882,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257550',4903883,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257550',4903884,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257551',4903885,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257551',4903886,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257551',4903887,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257551',4903888,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257551',4903889,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257551',4903890,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257552',4903891,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257552',4903892,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257552',4903893,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257552',4903894,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257552',4903895,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257552',4903896,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257553',4903897,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257553',4903898,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257553',4903899,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257553',4903900,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257553',4903901,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257553',4903902,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257554',4903903,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257554',4903904,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257554',4903905,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257554',4903906,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257554',4903907,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257554',4903908,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257555',4903909,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257555',4903910,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257555',4903911,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257555',4903912,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257555',4903913,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257555',4903914,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257556',4903915,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257556',4903916,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257556',4903917,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257556',4903918,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257556',4903919,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257556',4903920,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257557',4903921,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257557',4903922,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257557',4903923,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257557',4903924,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257557',4903925,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257557',4903926,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257558',4903927,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257558',4903928,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257558',4903929,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257558',4903930,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257558',4903931,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257558',4903932,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257559',4903933,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257559',4903934,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257559',4903935,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257559',4903936,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257559',4903937,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257559',4903938,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257560',4903939,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257560',4903940,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257560',4903941,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257560',4903942,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257560',4903943,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257560',4903944,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257561',4903945,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257561',4903946,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257561',4903947,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257561',4903948,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257561',4903949,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257561',4903950,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257562',4903951,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257562',4903952,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257562',4903953,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257562',4903954,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257562',4903955,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257562',4903956,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257563',4903957,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257563',4903958,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257563',4903959,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257563',4903960,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257563',4903961,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257563',4903962,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257564',4903963,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257564',4903964,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257564',4903965,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257564',4903966,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257564',4903967,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257564',4903968,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257565',4903969,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257565',4903970,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257565',4903971,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257565',4903972,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257565',4903973,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257565',4903974,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257566',4903975,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257566',4903976,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257566',4903977,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257566',4903978,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257566',4903979,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257566',4903980,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257567',4903981,'2837','426',647611.85,647611.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257567',4903982,'2838','426',465552.01,465552.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257567',4903983,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257567',4903984,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257567',4903985,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257567',4903986,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257568',4903987,'2837','426',647611.85,650226.55,2614.70,431425.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257568',4903988,'2838','426',465552.01,467514.15,1962.14,323753.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','257568',4903989,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257568',4903990,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257568',4903991,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257568',4903992,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257569',4903993,'2837','426',650226.55,654419.99,4193.44,691917.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257569',4903994,'2838','426',467514.15,471154.43,3640.28,600646.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257569',4903995,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257569',4903996,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257569',4903997,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257569',4903998,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257570',4903999,'2837','426',654419.99,655112.20,692.21,114214.65,0.00,0.00,0.00,0.00,0.00),('5','182','953','257570',4904000,'2838','426',471154.43,472225.02,1070.59,176647.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257570',4904001,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257570',4904002,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257570',4904003,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257570',4904004,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257571',4904005,'2837','426',655112.20,655412.20,300.00,49500.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257571',4904006,'2838','426',472225.02,473169.02,944.00,155760.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257571',4904007,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257571',4904008,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257571',4904009,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257571',4904010,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257572',4904011,'2837','426',655412.20,658463.50,3051.30,503464.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257572',4904012,'2838','426',473169.02,474418.77,1249.75,206208.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','257572',4904013,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257572',4904014,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257572',4904015,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257572',4904016,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257573',4904017,'2837','426',658463.50,661839.42,3375.92,557026.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','257573',4904018,'2838','426',474418.77,476121.81,1703.04,281001.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','257573',4904019,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257573',4904020,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257573',4904021,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257573',4904022,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257574',4904023,'2837','426',661839.42,664347.42,2508.00,413820.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257574',4904024,'2838','426',476121.81,477616.31,1494.50,246592.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257574',4904025,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257574',4904026,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257574',4904027,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257574',4904028,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257575',4904029,'2837','426',664347.42,667664.18,3316.76,547265.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','257575',4904030,'2838','426',477616.31,479700.31,2084.00,343860.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257575',4904031,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257575',4904032,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257575',4904033,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257575',4904034,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257576',4904035,'2837','426',667664.18,670009.58,2345.40,386991.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257576',4904036,'2838','426',479700.31,483927.70,4227.39,697519.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257576',4904037,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257576',4904038,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257576',4904039,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257576',4904040,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257577',4904041,'2837','426',670009.58,674183.96,4174.38,688772.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257577',4904042,'2838','426',483927.70,483939.77,12.07,1991.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257577',4904043,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257577',4904044,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257577',4904045,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257577',4904046,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257578',4904047,'2837','426',674183.96,674309.16,125.20,20658.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257578',4904048,'2838','426',483939.77,490062.13,6122.36,1010189.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257578',4904049,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257578',4904050,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257578',4904051,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257578',4904052,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257579',4904053,'2837','426',674309.16,677434.66,3125.50,515707.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257579',4904054,'2838','426',490062.13,494415.88,4353.75,718368.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','257579',4904055,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257579',4904056,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257579',4904057,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257579',4904058,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257580',4904059,'2837','426',677434.66,684421.41,6986.75,1152813.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257580',4904060,'2838','426',494415.88,494541.38,125.50,20707.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257580',4904061,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257580',4904062,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257580',4904063,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257580',4904064,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257581',4904065,'2837','426',684421.41,685600.29,1178.88,194515.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257581',4904066,'2838','426',494541.38,497415.88,2874.50,474292.50,0.00,0.00,0.00,0.00,0.00),('5','182','954','257581',4904067,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257581',4904068,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257581',4904069,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257581',4904070,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257582',4904071,'2837','426',685600.29,688234.92,2634.63,434713.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','257582',4904072,'2838','426',497415.88,501972.12,4556.24,751779.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','257582',4904073,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257582',4904074,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257582',4904075,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257582',4904076,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257583',4904077,'2837','426',688234.92,692711.68,4476.76,738665.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','257583',4904078,'2838','426',501972.12,502597.32,625.20,103158.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257583',4904079,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257583',4904080,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257583',4904081,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257583',4904082,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257584',4904083,'2837','426',692711.68,693209.88,498.20,82203.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257584',4904084,'2838','426',502597.32,507210.73,4613.41,761212.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','257584',4904085,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257584',4904086,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257584',4904087,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257584',4904088,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257585',4904089,'2837','426',693209.88,696644.17,3434.29,566657.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257585',4904090,'2838','426',507210.73,508812.53,1601.80,264297.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257585',4904091,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257585',4904092,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257585',4904093,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257585',4904094,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257586',4904095,'2837','426',696644.17,698639.10,1994.93,329163.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','257586',4904096,'2838','426',508812.53,510884.81,2072.28,341926.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257586',4904097,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257586',4904098,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257586',4904099,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257586',4904100,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257587',4904101,'2837','426',698639.10,701418.28,2779.18,458564.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257587',4904102,'2838','426',510884.81,511907.88,1023.07,168806.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257587',4904103,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257587',4904104,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257587',4904105,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257587',4904106,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257588',4904107,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257588',4904108,'2838','426',511907.88,513692.23,1784.35,294417.75,0.00,0.00,0.00,0.00,0.00),('5','182','954','257588',4904109,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257588',4904110,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257588',4904111,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257588',4904112,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257589',4904113,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257589',4904114,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257589',4904115,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257589',4904116,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257589',4904117,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257589',4904118,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257590',4904119,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257590',4904120,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257590',4904121,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257590',4904122,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257590',4904123,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257590',4904124,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257591',4904125,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257591',4904126,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257591',4904127,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257591',4904128,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257591',4904129,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257591',4904130,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257592',4904131,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257592',4904132,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257592',4904133,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257592',4904134,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257592',4904135,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257592',4904136,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257593',4904137,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257593',4904138,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257593',4904139,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257593',4904140,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257593',4904141,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257593',4904142,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257594',4904143,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257594',4904144,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257594',4904145,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257594',4904146,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257594',4904147,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257594',4904148,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257595',4904149,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257595',4904150,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257595',4904151,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257595',4904152,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257595',4904153,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257595',4904154,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257596',4904155,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257596',4904156,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257596',4904157,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257596',4904158,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257596',4904159,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257596',4904160,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257597',4904161,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257597',4904162,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257597',4904163,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257597',4904164,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257597',4904165,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257597',4904166,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257598',4904167,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257598',4904168,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257598',4904169,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257598',4904170,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257598',4904171,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257598',4904172,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257599',4904173,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257599',4904174,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257599',4904175,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257599',4904176,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257599',4904177,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257599',4904178,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257600',4904179,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257600',4904180,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257600',4904181,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257600',4904182,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257600',4904183,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257600',4904184,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257601',4904185,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257601',4904186,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257601',4904187,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257601',4904188,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257601',4904189,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257601',4904190,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257602',4904191,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257602',4904192,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257602',4904193,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257602',4904194,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257602',4904195,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257602',4904196,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257603',4904197,'2837','426',701418.28,701418.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257603',4904198,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257603',4904199,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257603',4904200,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257603',4904201,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257603',4904202,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257604',4904203,'2837','426',701418.28,703931.29,2513.01,414646.65,0.00,0.00,0.00,0.00,0.00),('5','182','953','257604',4904204,'2838','426',513692.23,513692.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257604',4904205,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257604',4904206,'2840','426',651670.56,651670.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257604',4904207,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257604',4904208,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257605',4904209,'2837','426',703931.29,704726.73,795.44,131247.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257605',4904210,'2838','426',513692.23,517242.65,3550.42,585819.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257605',4904211,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257605',4904212,'2840','426',651670.56,651744.51,73.95,12201.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','257605',4904213,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257605',4904214,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257606',4904215,'2837','426',704726.73,707211.67,2484.94,410015.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','257606',4904216,'2838','426',517242.65,519356.49,2113.84,348783.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','257606',4904217,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257606',4904218,'2840','426',651744.51,651744.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257606',4904219,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257606',4904220,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257607',4904221,'2837','426',707211.67,709587.46,2375.79,392005.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257607',4904222,'2838','426',519356.49,519656.49,300.00,49500.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257607',4904223,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257607',4904224,'2840','426',651744.51,653823.90,2079.39,343099.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','257607',4904225,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257607',4904226,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257608',4904227,'2837','426',709587.46,711929.86,2342.40,386496.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257608',4904228,'2838','426',519656.49,519656.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257608',4904229,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257608',4904230,'2840','426',653823.90,656129.40,2305.50,380407.50,0.00,0.00,0.00,0.00,0.00),('5','182','955','257608',4904231,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257608',4904232,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257609',4904233,'2837','426',711929.86,712580.60,650.74,107372.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','257609',4904234,'2838','426',519656.49,520712.31,1055.82,174210.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257609',4904235,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257609',4904236,'2840','426',656129.40,658683.90,2554.50,421492.50,0.00,0.00,0.00,0.00,0.00),('5','182','955','257609',4904237,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257609',4904238,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257610',4904239,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257610',4904240,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257610',4904241,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257610',4904242,'2840','426',658683.90,662849.10,4165.20,687258.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257610',4904243,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257610',4904244,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257611',4904245,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257611',4904246,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257611',4904247,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257611',4904248,'2840','426',662849.10,666864.30,4015.20,662508.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257611',4904249,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257611',4904250,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257612',4904251,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257612',4904252,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257612',4904253,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257612',4904254,'2840','426',666864.30,668916.10,2051.80,338547.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257612',4904255,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257612',4904256,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257613',4904257,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257613',4904258,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257613',4904259,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257613',4904260,'2840','426',668916.10,670520.82,1604.72,264778.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','257613',4904261,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257613',4904262,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257614',4904263,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257614',4904264,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257614',4904265,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257614',4904266,'2840','426',670520.82,670520.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257614',4904267,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257614',4904268,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257615',4904269,'2837','426',712580.60,712580.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257615',4904270,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257615',4904271,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257615',4904272,'2840','426',670520.82,670520.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257615',4904273,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257615',4904274,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257616',4904275,'2837','426',712580.60,716335.30,3754.70,619525.50,0.00,0.00,0.00,0.00,0.00),('5','182','953','257616',4904276,'2838','426',520712.31,520712.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257616',4904277,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257616',4904278,'2840','426',670520.82,670520.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257616',4904279,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257616',4904280,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257617',4904281,'2837','426',716335.30,716335.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257617',4904282,'2838','426',520712.31,522552.93,1840.62,303702.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257617',4904283,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257617',4904284,'2840','426',670520.82,674107.61,3586.79,591820.35,0.00,0.00,0.00,0.00,0.00),('5','182','955','257617',4904285,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257617',4904286,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257618',4904287,'2837','426',716335.30,719366.69,3031.39,500179.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257618',4904288,'2838','426',522552.93,523710.93,1158.00,191070.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257618',4904289,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257618',4904290,'2840','426',674107.61,674107.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257618',4904291,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257618',4904292,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257619',4904293,'2837','426',719366.69,721179.24,1812.55,299070.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257619',4904294,'2838','426',523710.93,525588.93,1878.00,309870.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257619',4904295,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257619',4904296,'2840','426',674107.61,675316.53,1208.92,199471.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','257619',4904297,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257619',4904298,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257620',4904299,'2837','426',721179.24,723178.48,1999.24,329874.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257620',4904300,'2838','426',525588.93,527459.59,1870.66,308658.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','257620',4904301,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257620',4904302,'2840','426',675316.53,676405.07,1088.54,179609.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','257620',4904303,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257620',4904304,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257621',4904305,'2837','426',723178.48,724865.81,1687.33,278409.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','257621',4904306,'2838','426',527459.59,529591.58,2131.99,351778.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257621',4904307,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257621',4904308,'2840','426',676405.07,676789.43,384.36,63419.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257621',4904309,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257621',4904310,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257622',4904311,'2837','426',724865.81,727204.84,2339.03,385939.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','257622',4904312,'2838','426',529591.58,530547.06,955.48,157654.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257622',4904313,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257622',4904314,'2840','426',676789.43,677503.50,714.07,117821.55,0.00,0.00,0.00,0.00,0.00),('5','182','955','257622',4904315,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257622',4904316,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257623',4904317,'2837','426',727204.84,728217.72,1012.88,167125.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257623',4904318,'2838','426',530547.06,531436.74,889.68,146797.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257623',4904319,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257623',4904320,'2840','426',677503.50,679805.70,2302.20,379863.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257623',4904321,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257623',4904322,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257624',4904323,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257624',4904324,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257624',4904325,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257624',4904326,'2840','426',679805.70,684137.75,4332.05,714788.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','257624',4904327,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257624',4904328,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257625',4904329,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257625',4904330,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257625',4904331,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257625',4904332,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257625',4904333,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257625',4904334,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257626',4904335,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257626',4904336,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257626',4904337,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257626',4904338,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257626',4904339,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257626',4904340,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257627',4904341,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257627',4904342,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257627',4904343,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257627',4904344,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257627',4904345,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257627',4904346,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257628',4904347,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257628',4904348,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257628',4904349,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257628',4904350,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257628',4904351,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257628',4904352,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257629',4904353,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257629',4904354,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257629',4904355,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257629',4904356,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257629',4904357,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257629',4904358,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257630',4904359,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257630',4904360,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257630',4904361,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257630',4904362,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257630',4904363,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257630',4904364,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257631',4904365,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257631',4904366,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257631',4904367,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257631',4904368,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257631',4904369,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257631',4904370,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257632',4904371,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257632',4904372,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257632',4904373,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257632',4904374,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257632',4904375,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257632',4904376,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257633',4904377,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257633',4904378,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257633',4904379,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257633',4904380,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257633',4904381,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257633',4904382,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257634',4904383,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257634',4904384,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257634',4904385,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257634',4904386,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257634',4904387,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257634',4904388,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257635',4904389,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257635',4904390,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257635',4904391,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257635',4904392,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257635',4904393,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257635',4904394,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257636',4904395,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257636',4904396,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257636',4904397,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257636',4904398,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257636',4904399,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257636',4904400,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257637',4904401,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257637',4904402,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257637',4904403,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257637',4904404,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257637',4904405,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257637',4904406,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257638',4904407,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257638',4904408,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257638',4904409,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257638',4904410,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257638',4904411,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257638',4904412,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257639',4904413,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257639',4904414,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257639',4904415,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257639',4904416,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257639',4904417,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257639',4904418,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257640',4904419,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257640',4904420,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257640',4904421,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257640',4904422,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257640',4904423,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257640',4904424,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257641',4904425,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257641',4904426,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257641',4904427,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257641',4904428,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257641',4904429,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257641',4904430,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257642',4904431,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257642',4904432,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257642',4904433,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257642',4904434,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257642',4904435,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257642',4904436,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257643',4904437,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257643',4904438,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257643',4904439,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257643',4904440,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257643',4904441,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257643',4904442,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257644',4904443,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257644',4904444,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257644',4904445,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257644',4904446,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257644',4904447,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257644',4904448,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257645',4904449,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257645',4904450,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257645',4904451,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257645',4904452,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257645',4904453,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257645',4904454,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257646',4904455,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257646',4904456,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257646',4904457,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257646',4904458,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257646',4904459,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257646',4904460,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257647',4904461,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257647',4904462,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257647',4904463,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257647',4904464,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257647',4904465,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257647',4904466,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257648',4904467,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257648',4904468,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257648',4904469,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257648',4904470,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257648',4904471,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257648',4904472,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257649',4904473,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257649',4904474,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257649',4904475,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257649',4904476,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257649',4904477,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257649',4904478,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257650',4904479,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257650',4904480,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257650',4904481,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257650',4904482,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257650',4904483,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257650',4904484,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257651',4904485,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257651',4904486,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257651',4904487,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257651',4904488,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257651',4904489,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257651',4904490,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257652',4904491,'2837','426',728217.72,728217.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257652',4904492,'2838','426',531436.74,531436.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257652',4904493,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257652',4904494,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257652',4904495,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257652',4904496,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257653',4904497,'2837','426',728217.72,730492.72,2275.00,420875.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257653',4904498,'2838','426',531436.74,531996.74,560.00,103600.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257653',4904499,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257653',4904500,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257653',4904501,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257653',4904502,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257654',4904503,'2837','426',730492.72,731163.05,670.33,124011.05,0.00,0.00,0.00,0.00,0.00),('5','182','953','257654',4904504,'2838','426',531996.74,535568.97,3572.23,660862.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257654',4904505,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257654',4904506,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257654',4904507,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257654',4904508,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257655',4904509,'2837','426',731163.05,733088.30,1925.25,356171.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257655',4904510,'2838','426',535568.97,537880.75,2311.78,427679.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257655',4904511,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257655',4904512,'2840','426',684137.75,684137.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257655',4904513,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257655',4904514,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257656',4904515,'2837','426',733088.30,736832.06,3743.76,692595.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257656',4904516,'2838','426',537880.75,538380.75,500.00,92500.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257656',4904517,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257656',4904518,'2840','426',684137.75,684952.19,814.44,150671.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257656',4904519,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257656',4904520,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257657',4904521,'2837','426',736832.06,737127.58,295.52,54671.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257657',4904522,'2838','426',538380.75,543568.04,5187.29,959648.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','257657',4904523,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257657',4904524,'2840','426',684952.19,684952.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257657',4904525,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257657',4904526,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257658',4904527,'2837','426',737127.58,738627.58,1500.00,277500.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257658',4904528,'2838','426',543568.04,543568.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257658',4904529,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257658',4904530,'2840','426',684952.19,689787.57,4835.38,894545.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','257658',4904531,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257658',4904532,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257659',4904533,'2837','426',738627.58,739840.10,1212.52,224316.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257659',4904534,'2838','426',543568.04,543568.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257659',4904535,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257659',4904536,'2840','426',689787.57,693149.79,3362.22,622010.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','257659',4904537,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257659',4904538,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257660',4904539,'2837','426',739840.10,742080.36,2240.26,414448.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','257660',4904540,'2838','426',543568.04,546145.92,2577.88,476907.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','257660',4904541,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257660',4904542,'2840','426',693149.79,693437.88,288.09,53296.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','257660',4904543,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257660',4904544,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257661',4904545,'2837','426',742080.36,743778.00,1697.64,314063.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','257661',4904546,'2838','426',546145.92,546869.77,723.85,133912.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257661',4904547,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257661',4904548,'2840','426',693437.88,695063.41,1625.53,300723.05,0.00,0.00,0.00,0.00,0.00),('5','182','955','257661',4904549,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257661',4904550,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257662',4904551,'2837','426',743778.00,746221.51,2443.51,452049.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257662',4904552,'2838','426',546869.77,546912.99,43.22,7995.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257662',4904553,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257662',4904554,'2840','426',695063.41,699365.58,4302.17,795901.45,0.00,0.00,0.00,0.00,0.00),('5','182','955','257662',4904555,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257662',4904556,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257663',4904557,'2837','426',746221.51,749093.51,2872.00,531320.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257663',4904558,'2838','426',546912.99,548131.55,1218.56,225433.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','257663',4904559,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257663',4904560,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257663',4904561,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257663',4904562,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257664',4904563,'2837','426',749093.51,749093.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257664',4904564,'2838','426',548131.55,548131.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257664',4904565,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257664',4904566,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257664',4904567,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257664',4904568,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257665',4904569,'2837','426',749093.51,751165.76,2072.25,383366.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257665',4904570,'2838','426',548131.55,550133.55,2002.00,370370.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257665',4904571,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257665',4904572,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257665',4904573,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257665',4904574,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257666',4904575,'2837','426',751165.76,755041.77,3876.01,717061.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257666',4904576,'2838','426',550133.55,552605.79,2472.24,457364.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257666',4904577,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257666',4904578,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257666',4904579,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257666',4904580,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257667',4904581,'2837','426',755041.77,761137.33,6095.56,1127678.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257667',4904582,'2838','426',552605.79,552605.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257667',4904583,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257667',4904584,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257667',4904585,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257667',4904586,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257668',4904587,'2837','426',761137.33,761137.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257668',4904588,'2838','426',552605.79,556666.53,4060.74,751236.90,0.00,0.00,0.00,0.00,0.00),('5','182','954','257668',4904589,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257668',4904590,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257668',4904591,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257668',4904592,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257669',4904593,'2837','426',761137.33,762092.28,954.95,176665.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257669',4904594,'2838','426',556666.53,557749.46,1082.93,200342.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','257669',4904595,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257669',4904596,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257669',4904597,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257669',4904598,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257670',4904599,'2837','426',762092.28,762092.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257670',4904600,'2838','426',557749.46,557749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257670',4904601,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257670',4904602,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257670',4904603,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257670',4904604,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257671',4904605,'2837','426',762092.28,762092.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257671',4904606,'2838','426',557749.46,557749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257671',4904607,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257671',4904608,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257671',4904609,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257671',4904610,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257672',4904611,'2837','426',762092.28,762092.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257672',4904612,'2838','426',557749.46,557749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257672',4904613,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257672',4904614,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257672',4904615,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257672',4904616,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257673',4904617,'2837','426',762092.28,764633.75,2541.47,470171.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','257673',4904618,'2838','426',557749.46,559249.46,1500.00,277500.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257673',4904619,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257673',4904620,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257673',4904621,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257673',4904622,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257674',4904623,'2837','426',764633.75,765733.75,1100.00,203500.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257674',4904624,'2838','426',559249.46,562427.65,3178.19,587965.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','257674',4904625,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257674',4904626,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257674',4904627,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257674',4904628,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257675',4904629,'2837','426',765733.75,769008.78,3275.03,605880.55,0.00,0.00,0.00,0.00,0.00),('5','182','953','257675',4904630,'2838','426',562427.65,563427.65,1000.00,185000.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257675',4904631,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257675',4904632,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257675',4904633,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257675',4904634,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257676',4904635,'2837','426',769008.78,769808.59,799.81,147964.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257676',4904636,'2838','426',563427.65,565021.88,1594.23,294932.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257676',4904637,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257676',4904638,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257676',4904639,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257676',4904640,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257677',4904641,'2837','426',769808.59,769808.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257677',4904642,'2838','426',565021.88,565021.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257677',4904643,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257677',4904644,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257677',4904645,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257677',4904646,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257678',4904647,'2837','426',769808.59,769808.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257678',4904648,'2838','426',565021.88,565021.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257678',4904649,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257678',4904650,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257678',4904651,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257678',4904652,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257679',4904653,'2837','426',769808.59,769808.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257679',4904654,'2838','426',565021.88,565021.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257679',4904655,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257679',4904656,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257679',4904657,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257679',4904658,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257680',4904659,'2837','426',769808.59,772090.66,2282.07,422182.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','257680',4904660,'2838','426',565021.88,566246.88,1225.00,226625.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257680',4904661,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257680',4904662,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257680',4904663,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257680',4904664,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257681',4904665,'2837','426',772090.66,772591.66,501.00,92685.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257681',4904666,'2838','426',566246.88,570144.89,3898.01,721131.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','257681',4904667,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257681',4904668,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257681',4904669,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257681',4904670,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257682',4904671,'2837','426',772591.66,776661.68,4070.02,752953.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257682',4904672,'2838','426',570144.89,570144.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257682',4904673,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257682',4904674,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257682',4904675,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257682',4904676,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257683',4904677,'2837','426',776661.68,776762.69,101.01,18686.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257683',4904678,'2838','426',570144.89,571578.80,1433.91,265273.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257683',4904679,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257683',4904680,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257683',4904681,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257683',4904682,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257684',4904683,'2837','426',776762.69,776762.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257684',4904684,'2838','426',571578.80,571578.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257684',4904685,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257684',4904686,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257684',4904687,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257684',4904688,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257685',4904689,'2837','426',776762.69,778372.41,1609.72,297798.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257685',4904690,'2838','426',571578.80,573229.93,1651.13,305459.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','257685',4904691,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257685',4904692,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257685',4904693,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257685',4904694,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257686',4904695,'2837','426',778372.41,781400.03,3027.62,560109.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257686',4904696,'2838','426',573229.93,574329.93,1100.00,203500.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257686',4904697,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257686',4904698,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257686',4904699,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257686',4904700,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257687',4904701,'2837','426',781400.03,783199.08,1799.05,332824.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257687',4904702,'2838','426',574329.93,577127.10,2797.17,517476.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257687',4904703,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257687',4904704,'2840','426',699365.58,699365.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257687',4904705,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257687',4904706,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257688',4904707,'2837','426',783199.08,783199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257688',4904708,'2838','426',577127.10,577127.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257688',4904709,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257688',4904710,'2840','426',699365.58,701315.10,1949.52,360661.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','257688',4904711,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257688',4904712,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257689',4904713,'2837','426',783199.08,786234.14,3035.06,561486.10,0.00,0.00,0.00,0.00,0.00),('5','182','953','257689',4904714,'2838','426',577127.10,579054.51,1927.41,356570.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','257689',4904715,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257689',4904716,'2840','426',701315.10,702294.34,979.24,181159.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257689',4904717,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257689',4904718,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257690',4904719,'2837','426',786234.14,787630.17,1396.03,258265.55,0.00,0.00,0.00,0.00,0.00),('5','182','953','257690',4904720,'2838','426',579054.51,579054.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257690',4904721,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257690',4904722,'2840','426',702294.34,703505.60,1211.26,224083.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','257690',4904723,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257690',4904724,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257691',4904725,'2837','426',787630.17,789349.79,1719.62,318129.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257691',4904726,'2838','426',579054.51,579054.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257691',4904727,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257691',4904728,'2840','426',703505.60,704556.00,1050.40,194324.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257691',4904729,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257691',4904730,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257692',4904731,'2837','426',789349.79,791065.27,1715.48,317363.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','257692',4904732,'2838','426',579054.51,580085.53,1031.02,190738.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257692',4904733,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257692',4904734,'2840','426',704556.00,705983.43,1427.43,264074.55,0.00,0.00,0.00,0.00,0.00),('5','182','955','257692',4904735,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257692',4904736,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257693',4904737,'2837','426',791065.27,792670.05,1604.78,296884.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','257693',4904738,'2838','426',580085.53,581225.15,1139.62,210829.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257693',4904739,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257693',4904740,'2840','426',705983.43,706287.08,303.65,56175.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','257693',4904741,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257693',4904742,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257694',4904743,'2837','426',792670.05,794475.40,1805.35,333989.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257694',4904744,'2838','426',581225.15,583043.92,1818.77,336472.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257694',4904745,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257694',4904746,'2840','426',706287.08,707133.81,846.73,156645.05,0.00,0.00,0.00,0.00,0.00),('5','182','955','257694',4904747,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257694',4904748,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257695',4904749,'2837','426',794475.40,794908.56,433.16,80134.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257695',4904750,'2838','426',583043.92,583356.25,312.33,57781.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','257695',4904751,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257695',4904752,'2840','426',707133.81,711184.59,4050.78,749394.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','257695',4904753,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257695',4904754,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257696',4904755,'2837','426',794908.56,794908.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257696',4904756,'2838','426',583356.25,583356.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257696',4904757,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257696',4904758,'2840','426',711184.59,714530.81,3346.22,619050.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','257696',4904759,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257696',4904760,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257697',4904761,'2837','426',794908.56,794908.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257697',4904762,'2838','426',583356.25,583356.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257697',4904763,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257697',4904764,'2840','426',714530.81,716550.15,2019.34,373577.90,0.00,0.00,0.00,0.00,0.00),('5','182','955','257697',4904765,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257697',4904766,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257698',4904767,'2837','426',794908.56,796124.03,1215.47,224861.95,0.00,0.00,0.00,0.00,0.00),('5','182','953','257698',4904768,'2838','426',583356.25,584424.65,1068.40,197654.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257698',4904769,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257698',4904770,'2840','426',716550.15,717493.08,942.93,174442.05,0.00,0.00,0.00,0.00,0.00),('5','182','955','257698',4904771,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257698',4904772,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257699',4904773,'2837','426',796124.03,797632.36,1508.33,279041.05,0.00,0.00,0.00,0.00,0.00),('5','182','953','257699',4904774,'2838','426',584424.65,585343.08,918.43,169909.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257699',4904775,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257699',4904776,'2840','426',717493.08,718630.87,1137.79,210491.15,0.00,0.00,0.00,0.00,0.00),('5','182','955','257699',4904777,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257699',4904778,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257700',4904779,'2837','426',797632.36,799938.70,2306.34,426672.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','257700',4904780,'2838','426',585343.08,586795.74,1452.66,268742.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','257700',4904781,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257700',4904782,'2840','426',718630.87,720349.54,1718.67,317953.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','257700',4904783,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257700',4904784,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257701',4904785,'2837','426',799938.70,801409.88,1471.18,272168.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','257701',4904786,'2838','426',586795.74,587801.56,1005.82,186076.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257701',4904787,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257701',4904788,'2840','426',720349.54,721381.06,1031.52,190831.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','257701',4904789,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257701',4904790,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257702',4904791,'2837','426',801409.88,803848.85,2438.97,451209.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','257702',4904792,'2838','426',587801.56,589860.84,2059.28,380966.80,0.00,0.00,0.00,0.00,0.00),('5','182','954','257702',4904793,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257702',4904794,'2840','426',721381.06,722137.85,756.79,140006.15,0.00,0.00,0.00,0.00,0.00),('5','182','955','257702',4904795,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257702',4904796,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257703',4904797,'2837','426',803848.85,806411.10,2562.25,474016.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257703',4904798,'2838','426',589860.84,590945.09,1084.25,200586.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257703',4904799,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257703',4904800,'2840','426',722137.85,724563.47,2425.62,448739.70,0.00,0.00,0.00,0.00,0.00),('5','182','955','257703',4904801,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257703',4904802,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257704',4904803,'2837','426',806411.10,807629.66,1218.56,225433.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257704',4904804,'2838','426',590945.09,592755.32,1810.23,334892.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257704',4904805,'2839','426',501195.84,501195.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257704',4904806,'2840','426',724563.47,726563.47,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257704',4904807,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257704',4904808,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257705',4904809,'2837','426',807629.66,807629.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257705',4904810,'2838','426',592755.32,592755.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257705',4904811,'2839','426',501195.84,502435.21,1239.37,229283.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257705',4904812,'2840','426',726563.47,729588.47,3025.00,559625.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257705',4904813,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257705',4904814,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257706',4904815,'2837','426',807629.66,807629.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257706',4904816,'2838','426',592755.32,592755.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257706',4904817,'2839','426',502435.21,502435.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257706',4904818,'2840','426',729588.47,735054.42,5465.95,1011200.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','257706',4904819,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257706',4904820,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257707',4904821,'2837','426',807629.66,807629.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257707',4904822,'2838','426',592755.32,592755.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257707',4904823,'2839','426',502435.21,505429.63,2994.42,553967.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257707',4904824,'2840','426',735054.42,735054.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257707',4904825,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257707',4904826,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257708',4904827,'2837','426',807629.66,809684.22,2054.56,380093.60,0.00,0.00,0.00,0.00,0.00),('5','182','953','257708',4904828,'2838','426',592755.32,594797.71,2042.39,377842.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','257708',4904829,'2839','426',505429.63,507079.14,1649.51,305159.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257708',4904830,'2840','426',735054.42,735054.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257708',4904831,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257708',4904832,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257709',4904833,'2837','426',809684.22,812207.77,2523.55,466856.75,0.00,0.00,0.00,0.00,0.00),('5','182','953','257709',4904834,'2838','426',594797.71,596530.96,1733.25,320651.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257709',4904835,'2839','426',507079.14,507079.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257709',4904836,'2840','426',735054.42,736447.94,1393.52,257801.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','257709',4904837,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257709',4904838,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257710',4904839,'2837','426',812207.77,814144.56,1936.79,358306.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','257710',4904840,'2838','426',596530.96,598019.52,1488.56,275383.60,0.00,0.00,0.00,0.00,0.00),('5','182','954','257710',4904841,'2839','426',507079.14,507079.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257710',4904842,'2840','426',736447.94,737610.33,1162.39,215042.15,0.00,0.00,0.00,0.00,0.00),('5','182','955','257710',4904843,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257710',4904844,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257711',4904845,'2837','426',814144.56,815475.30,1330.74,246186.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','257711',4904846,'2838','426',598019.52,599126.76,1107.24,204839.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257711',4904847,'2839','426',507079.14,507079.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257711',4904848,'2840','426',737610.33,738503.80,893.47,165291.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','257711',4904849,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257711',4904850,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257712',4904851,'2837','426',815475.30,817276.14,1800.84,333155.40,0.00,0.00,0.00,0.00,0.00),('5','182','953','257712',4904852,'2838','426',599126.76,600398.28,1271.52,235231.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257712',4904853,'2839','426',507079.14,507079.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257712',4904854,'2840','426',738503.80,739661.18,1157.38,214115.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','257712',4904855,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257712',4904856,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257713',4904857,'2837','426',817276.14,819802.45,2526.31,467367.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257713',4904858,'2838','426',600398.28,602136.92,1738.64,321648.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257713',4904859,'2839','426',507079.14,508376.52,1297.38,240015.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257713',4904860,'2840','426',739661.18,741847.13,2185.95,404400.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','257713',4904861,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257713',4904862,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257714',4904863,'2837','426',819802.45,821933.76,2131.31,394292.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257714',4904864,'2838','426',602136.92,603778.44,1641.52,303681.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257714',4904865,'2839','426',508376.52,509541.52,1165.00,215525.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257714',4904866,'2840','426',741847.13,743431.31,1584.18,293073.30,0.00,0.00,0.00,0.00,0.00),('5','182','955','257714',4904867,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257714',4904868,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257715',4904869,'2837','426',821933.76,822422.01,488.25,90326.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257715',4904870,'2838','426',603778.44,604258.71,480.27,88849.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','257715',4904871,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257715',4904872,'2840','426',743431.31,744327.67,896.36,165826.60,0.00,0.00,0.00,0.00,0.00),('5','182','955','257715',4904873,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257715',4904874,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257716',4904875,'2837','426',822422.01,822422.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257716',4904876,'2838','426',604258.71,604258.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257716',4904877,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257716',4904878,'2840','426',744327.67,744327.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257716',4904879,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257716',4904880,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257717',4904881,'2837','426',822422.01,822422.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257717',4904882,'2838','426',604258.71,604258.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257717',4904883,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257717',4904884,'2840','426',744327.67,744327.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257717',4904885,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257717',4904886,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257718',4904887,'2837','426',822422.01,822422.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257718',4904888,'2838','426',604258.71,604258.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257718',4904889,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257718',4904890,'2840','426',744327.67,744327.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257718',4904891,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257718',4904892,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257719',4904893,'2837','426',822422.01,823925.13,1503.12,278077.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257719',4904894,'2838','426',604258.71,605035.63,776.92,143730.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257719',4904895,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257719',4904896,'2840','426',744327.67,745082.55,754.88,139652.80,0.00,0.00,0.00,0.00,0.00),('5','182','955','257719',4904897,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257719',4904898,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257720',4904899,'2837','426',823925.13,825783.42,1858.29,343783.65,0.00,0.00,0.00,0.00,0.00),('5','182','953','257720',4904900,'2838','426',605035.63,606711.09,1675.46,309960.10,0.00,0.00,0.00,0.00,0.00),('5','182','954','257720',4904901,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257720',4904902,'2840','426',745082.55,746520.92,1438.37,266098.45,0.00,0.00,0.00,0.00,0.00),('5','182','955','257720',4904903,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257720',4904904,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257721',4904905,'2837','426',825783.42,827748.22,1964.80,363488.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257721',4904906,'2838','426',606711.09,608166.06,1454.97,269169.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257721',4904907,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257721',4904908,'2840','426',746520.92,746520.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257721',4904909,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257721',4904910,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257722',4904911,'2837','426',827748.22,829753.64,2005.42,371002.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257722',4904912,'2838','426',608166.06,609637.24,1471.18,272168.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257722',4904913,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257722',4904914,'2840','426',746520.92,749186.68,2665.76,493165.60,0.00,0.00,0.00,0.00,0.00),('5','182','955','257722',4904915,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257722',4904916,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257723',4904917,'2837','426',829753.64,831827.57,2073.93,383677.05,0.00,0.00,0.00,0.00,0.00),('5','182','953','257723',4904918,'2838','426',609637.24,611606.57,1969.33,364326.05,0.00,0.00,0.00,0.00,0.00),('5','182','954','257723',4904919,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257723',4904920,'2840','426',749186.68,750732.09,1545.41,285900.85,0.00,0.00,0.00,0.00,0.00),('5','182','955','257723',4904921,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257723',4904922,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257724',4904923,'2837','426',831827.57,833737.79,1910.22,353390.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257724',4904924,'2838','426',611606.57,612840.20,1233.63,228221.55,0.00,0.00,0.00,0.00,0.00),('5','182','954','257724',4904925,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257724',4904926,'2840','426',750732.09,751835.16,1103.07,204067.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','257724',4904927,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257724',4904928,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257725',4904929,'2837','426',833737.79,835243.91,1506.12,278632.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257725',4904930,'2838','426',612840.20,614132.09,1291.89,238999.65,0.00,0.00,0.00,0.00,0.00),('5','182','954','257725',4904931,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257725',4904932,'2840','426',751835.16,753071.71,1236.55,228761.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','257725',4904933,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257725',4904934,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257726',4904935,'2837','426',835243.91,837464.12,2220.21,410738.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257726',4904936,'2838','426',614132.09,615982.13,1850.04,342257.40,0.00,0.00,0.00,0.00,0.00),('5','182','954','257726',4904937,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257726',4904938,'2840','426',753071.71,754632.76,1561.05,288794.25,0.00,0.00,0.00,0.00,0.00),('5','182','955','257726',4904939,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257726',4904940,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257727',4904941,'2837','426',837464.12,838721.14,1257.02,232548.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257727',4904942,'2838','426',615982.13,617327.10,1344.97,248819.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257727',4904943,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257727',4904944,'2840','426',754632.76,756146.71,1513.95,280080.75,0.00,0.00,0.00,0.00,0.00),('5','182','955','257727',4904945,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257727',4904946,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257728',4904947,'2837','426',838721.14,839160.99,439.85,81372.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257728',4904948,'2838','426',617327.10,617327.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257728',4904949,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257728',4904950,'2840','426',756146.71,759270.08,3123.37,577823.45,0.00,0.00,0.00,0.00,0.00),('5','182','955','257728',4904951,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257728',4904952,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257729',4904953,'2837','426',839160.99,840562.40,1401.41,259260.85,0.00,0.00,0.00,0.00,0.00),('5','182','953','257729',4904954,'2838','426',617327.10,618237.90,910.80,168498.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257729',4904955,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257729',4904956,'2840','426',759270.08,760352.32,1082.24,200214.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257729',4904957,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257729',4904958,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257730',4904959,'2837','426',840562.40,842655.02,2092.62,387134.70,0.00,0.00,0.00,0.00,0.00),('5','182','953','257730',4904960,'2838','426',618237.90,619642.22,1404.32,259799.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257730',4904961,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257730',4904962,'2840','426',760352.32,761610.96,1258.64,232848.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257730',4904963,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257730',4904964,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257731',4904965,'2837','426',842655.02,845350.20,2695.18,498608.30,0.00,0.00,0.00,0.00,0.00),('5','182','953','257731',4904966,'2838','426',619642.22,621643.19,2000.97,370179.45,0.00,0.00,0.00,0.00,0.00),('5','182','954','257731',4904967,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257731',4904968,'2840','426',761610.96,763542.25,1931.29,357288.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','257731',4904969,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257731',4904970,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257732',4904971,'2837','426',845350.20,847872.99,2522.79,466716.15,0.00,0.00,0.00,0.00,0.00),('5','182','953','257732',4904972,'2838','426',621643.19,623582.18,1938.99,358713.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','257732',4904973,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257732',4904974,'2840','426',763542.25,765263.92,1721.67,318508.95,0.00,0.00,0.00,0.00,0.00),('5','182','955','257732',4904975,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257732',4904976,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257733',4904977,'2837','426',847872.99,851060.90,3187.91,589763.35,0.00,0.00,0.00,0.00,0.00),('5','182','953','257733',4904978,'2838','426',623582.18,625785.90,2203.72,407688.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257733',4904979,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257733',4904980,'2840','426',765263.92,767444.78,2180.86,403459.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','257733',4904981,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257733',4904982,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257734',4904983,'2837','426',851060.90,853670.18,2609.28,482716.80,0.00,0.00,0.00,0.00,0.00),('5','182','953','257734',4904984,'2838','426',625785.90,627887.75,2101.85,388842.25,0.00,0.00,0.00,0.00,0.00),('5','182','954','257734',4904985,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257734',4904986,'2840','426',767444.78,769281.64,1836.86,339819.10,0.00,0.00,0.00,0.00,0.00),('5','182','955','257734',4904987,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257734',4904988,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257735',4904989,'2837','426',853670.18,854689.98,1019.80,188663.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257735',4904990,'2838','426',627887.75,630425.82,2538.07,469542.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','257735',4904991,'2839','426',509541.52,509541.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257735',4904992,'2840','426',769281.64,772003.68,2722.04,503577.40,0.00,0.00,0.00,0.00,0.00),('5','182','955','257735',4904993,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257735',4904994,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257736',4904995,'2837','426',854689.98,857619.70,2929.72,541998.20,0.00,0.00,0.00,0.00,0.00),('5','182','953','257736',4904996,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257736',4904997,'2839','426',509541.52,511508.04,1966.52,363806.20,0.00,0.00,0.00,0.00,0.00),('5','182','954','257736',4904998,'2840','426',772003.68,772157.88,154.20,28527.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257736',4904999,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257736',4905000,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257737',4905001,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257737',4905002,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257737',4905003,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257737',4905004,'2840','426',772157.88,775204.00,3046.12,563532.20,0.00,0.00,0.00,0.00,0.00),('5','182','955','257737',4905005,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257737',4905006,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257738',4905007,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257738',4905008,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257738',4905009,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257738',4905010,'2840','426',775204.00,775204.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257738',4905011,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257738',4905012,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257739',4905013,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257739',4905014,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257739',4905015,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257739',4905016,'2840','426',775204.00,775204.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257739',4905017,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257739',4905018,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257740',4905019,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257740',4905020,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257740',4905021,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257740',4905022,'2840','426',775204.00,775424.49,220.49,40790.65,0.00,0.00,0.00,0.00,0.00),('5','182','955','257740',4905023,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257740',4905024,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257741',4905025,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257741',4905026,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257741',4905027,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257741',4905028,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257741',4905029,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257741',4905030,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257742',4905031,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257742',4905032,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257742',4905033,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257742',4905034,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257742',4905035,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257742',4905036,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257743',4905037,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257743',4905038,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257743',4905039,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257743',4905040,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257743',4905041,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257743',4905042,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257744',4905043,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257744',4905044,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257744',4905045,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257744',4905046,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257744',4905047,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257744',4905048,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257745',4905049,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257745',4905050,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257745',4905051,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257745',4905052,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257745',4905053,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257745',4905054,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257746',4905055,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257746',4905056,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257746',4905057,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257746',4905058,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257746',4905059,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257746',4905060,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257747',4905061,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257747',4905062,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257747',4905063,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257747',4905064,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257747',4905065,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257747',4905066,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257748',4905067,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257748',4905068,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257748',4905069,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257748',4905070,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257748',4905071,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257748',4905072,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257749',4905073,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257749',4905074,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257749',4905075,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257749',4905076,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257749',4905077,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257749',4905078,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257750',4905079,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257750',4905080,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257750',4905081,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257750',4905082,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257750',4905083,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257750',4905084,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257751',4905085,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257751',4905086,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257751',4905087,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257751',4905088,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257751',4905089,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257751',4905090,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257752',4905091,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257752',4905092,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257752',4905093,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257752',4905094,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257752',4905095,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257752',4905096,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257753',4905097,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257753',4905098,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257753',4905099,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257753',4905100,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257753',4905101,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257753',4905102,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257754',4905103,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257754',4905104,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257754',4905105,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257754',4905106,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257754',4905107,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257754',4905108,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257755',4905109,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257755',4905110,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257755',4905111,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257755',4905112,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257755',4905113,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257755',4905114,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257756',4905115,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257756',4905116,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257756',4905117,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257756',4905118,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257756',4905119,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257756',4905120,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257757',4905121,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257757',4905122,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257757',4905123,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257757',4905124,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257757',4905125,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257757',4905126,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257758',4905127,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257758',4905128,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257758',4905129,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257758',4905130,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257758',4905131,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257758',4905132,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257759',4905133,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257759',4905134,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257759',4905135,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257759',4905136,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257759',4905137,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257759',4905138,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257760',4905139,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257760',4905140,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257760',4905141,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257760',4905142,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257760',4905143,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257760',4905144,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257761',4905145,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257761',4905146,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257761',4905147,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257761',4905148,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257761',4905149,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257761',4905150,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257762',4905151,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257762',4905152,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257762',4905153,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257762',4905154,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257762',4905155,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257762',4905156,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257763',4905157,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257763',4905158,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257763',4905159,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257763',4905160,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257763',4905161,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257763',4905162,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257764',4905163,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257764',4905164,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257764',4905165,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257764',4905166,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257764',4905167,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257764',4905168,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257765',4905169,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257765',4905170,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257765',4905171,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257765',4905172,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257765',4905173,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257765',4905174,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257766',4905175,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257766',4905176,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257766',4905177,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257766',4905178,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257766',4905179,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257766',4905180,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257767',4905181,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257767',4905182,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257767',4905183,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257767',4905184,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257767',4905185,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257767',4905186,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257768',4905187,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257768',4905188,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257768',4905189,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257768',4905190,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257768',4905191,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257768',4905192,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257769',4905193,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257769',4905194,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257769',4905195,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257769',4905196,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257769',4905197,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257769',4905198,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257770',4905199,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257770',4905200,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257770',4905201,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257770',4905202,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257770',4905203,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257770',4905204,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257771',4905205,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257771',4905206,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257771',4905207,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257771',4905208,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257771',4905209,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257771',4905210,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257772',4905211,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257772',4905212,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257772',4905213,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257772',4905214,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257772',4905215,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257772',4905216,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257773',4905217,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257773',4905218,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257773',4905219,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257773',4905220,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257773',4905221,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257773',4905222,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257774',4905223,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257774',4905224,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257774',4905225,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257774',4905226,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257774',4905227,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257774',4905228,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257775',4905229,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257775',4905230,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257775',4905231,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257775',4905232,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257775',4905233,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257775',4905234,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257776',4905235,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257776',4905236,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257776',4905237,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257776',4905238,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257776',4905239,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257776',4905240,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257777',4905241,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257777',4905242,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257777',4905243,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257777',4905244,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257777',4905245,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257777',4905246,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257778',4905247,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257778',4905248,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257778',4905249,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257778',4905250,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257778',4905251,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257778',4905252,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257779',4905253,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257779',4905254,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257779',4905255,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257779',4905256,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257779',4905257,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257779',4905258,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257780',4905259,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257780',4905260,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257780',4905261,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257780',4905262,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257780',4905263,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257780',4905264,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257781',4905265,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257781',4905266,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257781',4905267,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257781',4905268,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257781',4905269,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257781',4905270,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257782',4905271,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257782',4905272,'2838','426',630425.82,630425.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257782',4905273,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257782',4905274,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257782',4905275,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257782',4905276,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257783',4905277,'2837','426',857619.70,857619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257783',4905278,'2838','426',630425.82,633450.53,3024.71,559571.35,0.00,0.00,0.00,0.00,0.00),('5','182','954','257783',4905279,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257783',4905280,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257783',4905281,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257783',4905282,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257784',4905283,'2837','426',857619.70,860228.15,2608.45,482563.25,0.00,0.00,0.00,0.00,0.00),('5','182','953','257784',4905284,'2838','426',633450.53,636014.53,2564.00,474340.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257784',4905285,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257784',4905286,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257784',4905287,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257784',4905288,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257785',4905289,'2837','426',860228.15,864965.98,4737.83,876498.55,0.00,0.00,0.00,0.00,0.00),('5','182','953','257785',4905290,'2838','426',636014.53,636014.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257785',4905291,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257785',4905292,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257785',4905293,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257785',4905294,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257786',4905295,'2837','426',864965.98,864965.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257786',4905296,'2838','426',636014.53,638114.51,2099.98,388496.30,0.00,0.00,0.00,0.00,0.00),('5','182','954','257786',4905297,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257786',4905298,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257786',4905299,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257786',4905300,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257787',4905301,'2837','426',864965.98,864965.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257787',4905302,'2838','426',638114.51,638114.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257787',4905303,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257787',4905304,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257787',4905305,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257787',4905306,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257788',4905307,'2837','426',864965.98,864965.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257788',4905308,'2838','426',638114.51,638114.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257788',4905309,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257788',4905310,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257788',4905311,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257788',4905312,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257789',4905313,'2837','426',864965.98,866793.95,1827.97,338174.45,0.00,0.00,0.00,0.00,0.00),('5','182','953','257789',4905314,'2838','426',638114.51,639826.50,1711.99,316718.15,0.00,0.00,0.00,0.00,0.00),('5','182','954','257789',4905315,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257789',4905316,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257789',4905317,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257789',4905318,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257790',4905319,'2837','426',866793.95,869759.69,2965.74,548661.90,0.00,0.00,0.00,0.00,0.00),('5','182','953','257790',4905320,'2838','426',639826.50,641631.11,1804.61,333852.85,0.00,0.00,0.00,0.00,0.00),('5','182','954','257790',4905321,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257790',4905322,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257790',4905323,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257790',4905324,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257791',4905325,'2837','426',869759.69,869759.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257791',4905326,'2838','426',641631.11,645997.78,4366.67,807833.95,0.00,0.00,0.00,0.00,0.00),('5','182','954','257791',4905327,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257791',4905328,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257791',4905329,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257791',4905330,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257792',4905331,'2837','426',869759.69,872463.92,2704.23,500282.55,0.00,0.00,0.00,0.00,0.00),('5','182','953','257792',4905332,'2838','426',645997.78,646154.00,156.22,28900.70,0.00,0.00,0.00,0.00,0.00),('5','182','954','257792',4905333,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257792',4905334,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257792',4905335,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257792',4905336,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257793',4905337,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257793',4905338,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257793',4905339,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257793',4905340,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257793',4905341,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257793',4905342,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257794',4905343,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257794',4905344,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257794',4905345,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257794',4905346,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257794',4905347,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257794',4905348,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257795',4905349,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257795',4905350,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257795',4905351,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257795',4905352,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257795',4905353,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257795',4905354,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257796',4905355,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257796',4905356,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257796',4905357,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257796',4905358,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257796',4905359,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257796',4905360,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257797',4905361,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257797',4905362,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257797',4905363,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257797',4905364,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257797',4905365,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257797',4905366,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257798',4905367,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257798',4905368,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257798',4905369,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257798',4905370,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257798',4905371,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257798',4905372,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257799',4905373,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257799',4905374,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257799',4905375,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257799',4905376,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257799',4905377,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257799',4905378,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257800',4905379,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257800',4905380,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257800',4905381,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257800',4905382,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257800',4905383,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257800',4905384,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257801',4905385,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257801',4905386,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257801',4905387,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257801',4905388,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257801',4905389,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257801',4905390,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257802',4905391,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257802',4905392,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257802',4905393,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257802',4905394,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257802',4905395,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257802',4905396,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257803',4905397,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257803',4905398,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257803',4905399,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257803',4905400,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257803',4905401,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257803',4905402,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257804',4905403,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257804',4905404,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257804',4905405,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257804',4905406,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257804',4905407,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257804',4905408,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257805',4905409,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257805',4905410,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257805',4905411,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257805',4905412,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257805',4905413,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257805',4905414,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257806',4905415,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257806',4905416,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257806',4905417,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257806',4905418,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257806',4905419,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257806',4905420,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257807',4905421,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257807',4905422,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257807',4905423,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257807',4905424,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257807',4905425,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257807',4905426,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257808',4905427,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257808',4905428,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257808',4905429,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257808',4905430,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257808',4905431,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257808',4905432,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257809',4905433,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257809',4905434,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257809',4905435,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257809',4905436,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257809',4905437,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257809',4905438,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257810',4905439,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257810',4905440,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257810',4905441,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257810',4905442,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257810',4905443,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257810',4905444,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257811',4905445,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257811',4905446,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257811',4905447,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257811',4905448,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257811',4905449,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257811',4905450,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257812',4905451,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257812',4905452,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257812',4905453,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257812',4905454,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257812',4905455,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257812',4905456,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257813',4905457,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257813',4905458,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257813',4905459,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257813',4905460,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257813',4905461,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257813',4905462,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257814',4905463,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257814',4905464,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257814',4905465,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257814',4905466,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257814',4905467,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257814',4905468,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257815',4905469,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257815',4905470,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257815',4905471,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257815',4905472,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257815',4905473,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257815',4905474,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257816',4905475,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257816',4905476,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257816',4905477,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257816',4905478,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257816',4905479,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257816',4905480,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257817',4905481,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257817',4905482,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257817',4905483,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257817',4905484,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257817',4905485,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257817',4905486,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257818',4905487,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257818',4905488,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257818',4905489,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257818',4905490,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257818',4905491,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257818',4905492,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257819',4905493,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257819',4905494,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257819',4905495,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257819',4905496,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257819',4905497,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257819',4905498,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257820',4905499,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257820',4905500,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257820',4905501,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257820',4905502,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257820',4905503,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257820',4905504,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257821',4905505,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257821',4905506,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257821',4905507,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257821',4905508,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257821',4905509,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257821',4905510,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257822',4905511,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257822',4905512,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257822',4905513,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257822',4905514,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257822',4905515,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257822',4905516,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257823',4905517,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257823',4905518,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257823',4905519,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257823',4905520,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257823',4905521,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257823',4905522,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257824',4905523,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257824',4905524,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257824',4905525,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257824',4905526,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257824',4905527,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257824',4905528,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257825',4905529,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257825',4905530,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257825',4905531,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257825',4905532,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257825',4905533,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257825',4905534,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257826',4905535,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257826',4905536,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257826',4905537,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257826',4905538,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257826',4905539,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257826',4905540,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257827',4905541,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257827',4905542,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257827',4905543,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257827',4905544,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257827',4905545,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257827',4905546,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257828',4905547,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257828',4905548,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257828',4905549,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257828',4905550,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257828',4905551,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257828',4905552,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257829',4905553,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257829',4905554,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257829',4905555,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257829',4905556,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257829',4905557,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257829',4905558,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257830',4905559,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257830',4905560,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257830',4905561,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257830',4905562,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257830',4905563,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257830',4905564,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257831',4905565,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257831',4905566,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257831',4905567,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257831',4905568,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257831',4905569,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257831',4905570,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257832',4905571,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257832',4905572,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257832',4905573,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257832',4905574,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257832',4905575,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257832',4905576,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257833',4905577,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257833',4905578,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257833',4905579,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257833',4905580,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257833',4905581,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257833',4905582,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257834',4905583,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257834',4905584,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257834',4905585,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257834',4905586,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257834',4905587,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257834',4905588,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257835',4905589,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257835',4905590,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257835',4905591,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257835',4905592,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257835',4905593,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257835',4905594,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257836',4905595,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257836',4905596,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257836',4905597,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257836',4905598,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257836',4905599,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257836',4905600,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257837',4905601,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257837',4905602,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257837',4905603,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257837',4905604,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257837',4905605,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257837',4905606,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257838',4905607,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257838',4905608,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257838',4905609,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257838',4905610,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257838',4905611,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257838',4905612,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257839',4905613,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257839',4905614,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257839',4905615,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257839',4905616,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257839',4905617,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257839',4905618,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257840',4905619,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257840',4905620,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257840',4905621,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257840',4905622,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257840',4905623,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257840',4905624,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257841',4905625,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257841',4905626,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257841',4905627,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257841',4905628,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257841',4905629,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257841',4905630,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257842',4905631,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257842',4905632,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257842',4905633,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257842',4905634,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257842',4905635,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257842',4905636,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257843',4905637,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257843',4905638,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257843',4905639,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257843',4905640,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257843',4905641,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257843',4905642,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257844',4905643,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257844',4905644,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257844',4905645,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257844',4905646,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257844',4905647,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257844',4905648,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257845',4905649,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257845',4905650,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257845',4905651,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257845',4905652,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257845',4905653,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257845',4905654,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257846',4905655,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257846',4905656,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257846',4905657,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257846',4905658,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257846',4905659,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257846',4905660,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257847',4905661,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257847',4905662,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257847',4905663,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257847',4905664,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257847',4905665,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257847',4905666,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257848',4905667,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257848',4905668,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257848',4905669,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257848',4905670,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257848',4905671,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257848',4905672,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257849',4905673,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257849',4905674,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257849',4905675,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257849',4905676,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257849',4905677,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257849',4905678,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257850',4905679,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257850',4905680,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257850',4905681,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257850',4905682,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257850',4905683,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257850',4905684,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257851',4905685,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257851',4905686,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257851',4905687,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257851',4905688,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257851',4905689,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257851',4905690,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257852',4905691,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257852',4905692,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257852',4905693,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257852',4905694,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257852',4905695,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257852',4905696,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257853',4905697,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257853',4905698,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257853',4905699,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257853',4905700,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257853',4905701,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257853',4905702,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257854',4905703,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257854',4905704,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257854',4905705,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257854',4905706,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257854',4905707,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257854',4905708,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257855',4905709,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257855',4905710,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257855',4905711,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257855',4905712,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257855',4905713,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257855',4905714,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257856',4905715,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257856',4905716,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257856',4905717,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257856',4905718,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257856',4905719,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257856',4905720,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257857',4905721,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257857',4905722,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257857',4905723,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257857',4905724,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257857',4905725,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257857',4905726,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257858',4905727,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257858',4905728,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257858',4905729,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257858',4905730,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257858',4905731,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257858',4905732,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257859',4905733,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257859',4905734,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257859',4905735,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257859',4905736,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257859',4905737,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257859',4905738,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257860',4905739,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257860',4905740,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257860',4905741,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257860',4905742,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257860',4905743,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257860',4905744,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257861',4905745,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257861',4905746,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257861',4905747,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257861',4905748,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257861',4905749,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257861',4905750,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257862',4905751,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257862',4905752,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257862',4905753,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257862',4905754,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257862',4905755,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257862',4905756,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257863',4905757,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257863',4905758,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257863',4905759,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257863',4905760,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257863',4905761,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257863',4905762,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257864',4905763,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257864',4905764,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257864',4905765,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257864',4905766,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257864',4905767,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257864',4905768,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257865',4905769,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257865',4905770,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257865',4905771,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257865',4905772,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257865',4905773,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257865',4905774,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257866',4905775,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257866',4905776,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257866',4905777,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257866',4905778,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257866',4905779,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257866',4905780,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257867',4905781,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257867',4905782,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257867',4905783,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257867',4905784,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257867',4905785,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257867',4905786,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257868',4905787,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257868',4905788,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257868',4905789,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257868',4905790,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257868',4905791,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257868',4905792,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257869',4905793,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257869',4905794,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257869',4905795,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257869',4905796,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257869',4905797,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257869',4905798,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257870',4905799,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257870',4905800,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257870',4905801,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257870',4905802,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257870',4905803,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257870',4905804,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257871',4905805,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257871',4905806,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257871',4905807,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257871',4905808,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257871',4905809,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257871',4905810,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257872',4905811,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257872',4905812,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257872',4905813,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257872',4905814,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257872',4905815,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257872',4905816,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257873',4905817,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257873',4905818,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257873',4905819,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257873',4905820,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257873',4905821,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257873',4905822,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257874',4905823,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257874',4905824,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257874',4905825,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257874',4905826,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257874',4905827,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257874',4905828,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257875',4905829,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257875',4905830,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257875',4905831,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257875',4905832,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257875',4905833,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257875',4905834,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257876',4905835,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257876',4905836,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257876',4905837,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257876',4905838,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257876',4905839,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257876',4905840,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257877',4905841,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257877',4905842,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257877',4905843,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257877',4905844,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257877',4905845,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257877',4905846,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257878',4905847,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257878',4905848,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257878',4905849,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257878',4905850,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257878',4905851,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257878',4905852,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257879',4905853,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257879',4905854,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257879',4905855,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257879',4905856,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257879',4905857,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257879',4905858,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257880',4905859,'2837','426',872463.92,872463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','953','257880',4905860,'2838','426',646154.00,646154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257880',4905861,'2839','426',511508.04,511508.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','954','257880',4905862,'2840','426',775424.49,775424.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','955','257880',4905863,'2841','427',204231.97,204231.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','182','956','257880',4905864,'2842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730801 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','182','210835','426',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608427),('5','182','210835','427',290.00,0.00,0.00,0.00,0.00,0.00,0.00,608428),('5','182','210835','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608429),('5','182','210889','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,608567),('5','182','210889','427',295.00,295.00,83.27,0.00,0.00,0.00,0.00,608568),('5','182','210889','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608569),('5','182','210911','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,608624),('5','182','210911','427',295.00,295.00,87.96,0.00,0.00,0.00,0.00,608625),('5','182','210911','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608626),('5','182','210974','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,608774),('5','182','210974','427',295.00,295.00,26.69,0.00,0.00,0.00,0.00,608775),('5','182','210974','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608776),('5','182','211196','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,609340),('5','182','211196','427',295.00,295.00,48.80,0.00,0.00,0.00,0.00,609341),('5','182','211196','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609342),('5','182','211749','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,610786),('5','182','211749','427',295.00,295.00,47.05,0.00,0.00,0.00,0.00,610787),('5','182','211749','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610788),('5','182','211978','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,611379),('5','182','211978','427',295.00,295.00,70.50,0.00,0.00,0.00,0.00,611380),('5','182','211978','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611381),('5','182','212053','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,611566),('5','182','212053','427',295.00,295.00,91.90,0.00,0.00,0.00,0.00,611567),('5','182','212053','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611568),('5','182','212421','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,612543),('5','182','212421','427',295.00,295.00,464.94,0.00,0.00,0.00,0.00,612544),('5','182','212421','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612545),('5','182','212578','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,612956),('5','182','212578','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,612957),('5','182','212578','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612958),('5','182','212714','426',165.00,165.00,1975.41,0.00,0.00,0.00,0.00,613311),('5','182','212714','427',295.00,295.00,737.96,0.00,0.00,0.00,0.00,613312),('5','182','212714','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613313),('5','182','213247','426',165.00,165.00,3074.67,0.00,0.00,0.00,0.00,614698),('5','182','213247','427',295.00,295.00,2553.77,0.00,0.00,0.00,0.00,614699),('5','182','213247','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614700),('5','182','213259','426',165.00,165.00,2626.37,0.00,0.00,0.00,0.00,614727),('5','182','213259','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614728),('5','182','213259','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614729),('5','182','213270','426',165.00,165.00,2423.87,0.00,0.00,0.00,0.00,614757),('5','182','213270','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614758),('5','182','213270','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614759),('5','182','213446','426',165.00,165.00,2488.60,0.00,0.00,0.00,0.00,615202),('5','182','213446','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615203),('5','182','213446','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615204),('5','182','213733','426',165.00,165.00,3230.50,0.00,0.00,0.00,0.00,615971),('5','182','213733','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615972),('5','182','213733','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615973),('5','182','213991','426',165.00,165.00,2555.53,0.00,0.00,0.00,0.00,616649),('5','182','213991','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616650),('5','182','213991','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616651),('5','182','214303','426',165.00,165.00,3193.36,0.00,0.00,0.00,0.00,617463),('5','182','214303','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617464),('5','182','214303','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617465),('5','182','214496','426',165.00,165.00,3217.88,0.00,0.00,0.00,0.00,617959),('5','182','214496','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617960),('5','182','214496','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617961),('5','182','214535','426',165.00,165.00,1760.12,0.00,0.00,0.00,0.00,618052),('5','182','214535','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618053),('5','182','214535','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618054),('5','182','214879','426',165.00,165.00,3513.70,0.00,0.00,0.00,0.00,618952),('5','182','214879','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618953),('5','182','214879','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618954),('5','182','215299','426',165.00,165.00,2854.32,0.00,0.00,0.00,0.00,620039),('5','182','215299','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620040),('5','182','215299','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620041),('5','182','215367','426',165.00,165.00,2628.95,0.00,0.00,0.00,0.00,620220),('5','182','215367','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620221),('5','182','215367','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620222),('5','182','215450','426',165.00,165.00,2825.74,0.00,0.00,0.00,0.00,620415),('5','182','215450','427',295.00,295.00,640.21,0.00,0.00,0.00,0.00,620416),('5','182','215450','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620417),('5','182','215883','426',165.00,165.00,2509.07,0.00,0.00,0.00,0.00,621542),('5','182','215883','427',295.00,295.00,133.95,0.00,0.00,0.00,0.00,621543),('5','182','215883','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621544),('5','182','215923','426',165.00,165.00,2640.69,0.00,0.00,0.00,0.00,621633),('5','182','215923','427',295.00,295.00,240.81,0.00,0.00,0.00,0.00,621634),('5','182','215923','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621635),('5','182','216157','426',165.00,165.00,2973.64,0.00,0.00,0.00,0.00,622243),('5','182','216157','427',295.00,295.00,80.50,0.00,0.00,0.00,0.00,622244),('5','182','216157','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622245),('5','182','216316','426',165.00,165.00,2639.62,0.00,0.00,0.00,0.00,622668),('5','182','216316','427',295.00,295.00,71.46,0.00,0.00,0.00,0.00,622669),('5','182','216316','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622670),('5','182','216553','426',165.00,165.00,2269.05,0.00,0.00,0.00,0.00,623294),('5','182','216553','427',295.00,295.00,79.97,0.00,0.00,0.00,0.00,623295),('5','182','216553','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623296),('5','182','216782','426',165.00,165.00,2792.78,0.00,0.00,0.00,0.00,623899),('5','182','216782','427',295.00,295.00,33.83,0.00,0.00,0.00,0.00,623900),('5','182','216782','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623901),('5','182','217023','426',165.00,165.00,2671.45,0.00,0.00,0.00,0.00,624520),('5','182','217023','427',295.00,295.00,87.51,0.00,0.00,0.00,0.00,624521),('5','182','217023','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624522),('5','182','217297','426',165.00,165.00,2423.50,0.00,0.00,0.00,0.00,625236),('5','182','217297','427',295.00,295.00,161.98,0.00,0.00,0.00,0.00,625237),('5','182','217297','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625238),('5','182','217652','426',165.00,165.00,3070.93,0.00,0.00,0.00,0.00,626178),('5','182','217652','427',295.00,295.00,252.20,0.00,0.00,0.00,0.00,626179),('5','182','217652','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626180),('5','182','217733','426',165.00,165.00,3953.58,0.00,0.00,0.00,0.00,626372),('5','182','217733','427',295.00,295.00,249.17,0.00,0.00,0.00,0.00,626373),('5','182','217733','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626374),('5','182','218018','426',165.00,165.00,3288.29,0.00,0.00,0.00,0.00,627123),('5','182','218018','427',295.00,295.00,207.67,0.00,0.00,0.00,0.00,627124),('5','182','218018','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627125),('5','182','218257','426',165.00,165.00,3732.78,0.00,0.00,0.00,0.00,627752),('5','182','218257','427',295.00,295.00,125.37,0.00,0.00,0.00,0.00,627753),('5','182','218257','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627754),('5','182','219519','426',165.00,165.00,3901.14,0.00,0.00,0.00,0.00,631066),('5','182','219519','427',295.00,295.00,163.24,0.00,0.00,0.00,0.00,631067),('5','182','219519','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631068),('5','182','219521','426',165.00,165.00,1863.36,0.00,0.00,0.00,0.00,631072),('5','182','219521','427',295.00,295.00,33.79,0.00,0.00,0.00,0.00,631073),('5','182','219521','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631074),('5','182','219527','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,631089),('5','182','219527','427',295.00,295.00,43.30,0.00,0.00,0.00,0.00,631090),('5','182','219527','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631091),('5','182','219533','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,631105),('5','182','219533','427',295.00,295.00,53.87,0.00,0.00,0.00,0.00,631106),('5','182','219533','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631107),('5','182','219561','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,631180),('5','182','219561','427',295.00,295.00,43.91,0.00,0.00,0.00,0.00,631181),('5','182','219561','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631182),('5','182','219615','426',165.00,165.00,2695.01,0.00,0.00,0.00,0.00,631299),('5','182','219615','427',295.00,295.00,22.23,0.00,0.00,0.00,0.00,631300),('5','182','219615','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631301),('5','182','219853','426',165.00,165.00,3576.27,0.00,0.00,0.00,0.00,631927),('5','182','219853','427',295.00,295.00,83.87,0.00,0.00,0.00,0.00,631928),('5','182','219853','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631929),('5','182','220076','426',165.00,165.00,2766.15,0.00,0.00,0.00,0.00,632523),('5','182','220076','427',295.00,295.00,74.78,0.00,0.00,0.00,0.00,632524),('5','182','220076','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632525),('5','182','220374','426',165.00,165.00,3112.43,0.00,0.00,0.00,0.00,633321),('5','182','220374','427',295.00,295.00,209.50,0.00,0.00,0.00,0.00,633322),('5','182','220374','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633323),('5','182','220484','426',165.00,165.00,2298.35,0.00,0.00,0.00,0.00,633596),('5','182','220484','427',295.00,295.00,52.36,0.00,0.00,0.00,0.00,633597),('5','182','220484','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633598),('5','182','220748','426',165.00,165.00,2652.54,0.00,0.00,0.00,0.00,634285),('5','182','220748','427',295.00,295.00,134.91,0.00,0.00,0.00,0.00,634286),('5','182','220748','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634287),('5','182','220922','426',165.00,165.00,2673.40,0.00,0.00,0.00,0.00,634736),('5','182','220922','427',295.00,295.00,85.38,0.00,0.00,0.00,0.00,634737),('5','182','220922','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634738),('5','182','224655','426',165.00,165.00,3278.61,0.00,0.00,0.00,0.00,644416),('5','182','224655','427',295.00,295.00,218.29,0.00,0.00,0.00,0.00,644417),('5','182','224655','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644418),('5','182','224660','426',165.00,165.00,3101.68,0.00,0.00,0.00,0.00,644431),('5','182','224660','427',295.00,295.00,139.49,0.00,0.00,0.00,0.00,644432),('5','182','224660','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644433),('5','182','224667','426',165.00,165.00,2315.07,0.00,0.00,0.00,0.00,644450),('5','182','224667','427',295.00,295.00,225.22,0.00,0.00,0.00,0.00,644451),('5','182','224667','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644452),('5','182','224674','426',165.00,165.00,2495.28,0.00,0.00,0.00,0.00,644468),('5','182','224674','427',295.00,295.00,211.39,0.00,0.00,0.00,0.00,644469),('5','182','224674','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644470),('5','182','224679','426',165.00,165.00,2056.87,0.00,0.00,0.00,0.00,644482),('5','182','224679','427',295.00,295.00,294.51,0.00,0.00,0.00,0.00,644483),('5','182','224679','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644484),('5','182','224681','426',165.00,165.00,2151.70,0.00,0.00,0.00,0.00,644488),('5','182','224681','427',295.00,295.00,125.27,0.00,0.00,0.00,0.00,644489),('5','182','224681','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644490),('5','182','224686','426',165.00,165.00,2422.12,0.00,0.00,0.00,0.00,644502),('5','182','224686','427',295.00,295.00,81.43,0.00,0.00,0.00,0.00,644503),('5','182','224686','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644504),('5','182','224689','426',165.00,165.00,1716.65,0.00,0.00,0.00,0.00,644511),('5','182','224689','427',295.00,295.00,96.30,0.00,0.00,0.00,0.00,644512),('5','182','224689','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644513),('5','182','224696','426',165.00,165.00,2830.47,0.00,0.00,0.00,0.00,644527),('5','182','224696','427',295.00,295.00,218.63,0.00,0.00,0.00,0.00,644528),('5','182','224696','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644529),('5','182','224701','426',165.00,165.00,2171.70,0.00,0.00,0.00,0.00,644540),('5','182','224701','427',295.00,295.00,162.15,0.00,0.00,0.00,0.00,644541),('5','182','224701','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644542),('5','182','224703','426',165.00,165.00,2120.84,0.00,0.00,0.00,0.00,644544),('5','182','224703','427',295.00,295.00,250.66,0.00,0.00,0.00,0.00,644545),('5','182','224703','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644546),('5','182','224704','426',165.00,165.00,1580.70,0.00,0.00,0.00,0.00,644547),('5','182','224704','427',295.00,295.00,248.26,0.00,0.00,0.00,0.00,644548),('5','182','224704','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644549),('5','182','224707','426',165.00,165.00,1641.81,0.00,0.00,0.00,0.00,644555),('5','182','224707','427',295.00,295.00,109.03,0.00,0.00,0.00,0.00,644556),('5','182','224707','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644557),('5','182','224712','426',165.00,165.00,2077.51,0.00,0.00,0.00,0.00,644570),('5','182','224712','427',295.00,295.00,170.70,0.00,0.00,0.00,0.00,644571),('5','182','224712','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644572),('5','182','224717','426',165.00,165.00,2221.12,0.00,0.00,0.00,0.00,644585),('5','182','224717','427',295.00,295.00,225.71,0.00,0.00,0.00,0.00,644586),('5','182','224717','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644587),('5','182','225177','426',165.00,163.00,1761.00,0.00,0.00,0.00,0.00,645759),('5','182','225177','427',295.00,295.00,415.65,0.00,0.00,0.00,0.00,645760),('5','182','225177','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645761),('5','182','225182','426',165.00,163.00,1876.65,0.00,0.00,0.00,0.00,645773),('5','182','225182','427',295.00,295.00,216.79,0.00,0.00,0.00,0.00,645774),('5','182','225182','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645775),('5','182','225194','426',165.00,163.00,1937.53,0.00,0.00,0.00,0.00,645804),('5','182','225194','427',295.00,295.00,280.64,0.00,0.00,0.00,0.00,645805),('5','182','225194','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645806),('5','182','226600','426',165.00,163.00,2311.07,0.00,0.00,0.00,0.00,649435),('5','182','226600','427',295.00,295.00,714.58,0.00,0.00,0.00,0.00,649436),('5','182','226600','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649437),('5','182','226601','426',165.00,163.00,1988.56,0.00,0.00,0.00,0.00,649438),('5','182','226601','427',295.00,295.00,215.37,0.00,0.00,0.00,0.00,649439),('5','182','226601','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649440),('5','182','226606','426',165.00,163.00,2551.49,0.00,0.00,0.00,0.00,649453),('5','182','226606','427',295.00,295.00,241.64,0.00,0.00,0.00,0.00,649454),('5','182','226606','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649455),('5','182','226611','426',165.00,163.00,2310.13,0.00,0.00,0.00,0.00,649465),('5','182','226611','427',295.00,295.00,670.26,0.00,0.00,0.00,0.00,649466),('5','182','226611','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649467),('5','182','226630','426',165.00,163003.00,1941.59,0.00,0.00,0.00,0.00,649522),('5','182','226630','427',295.00,295.00,733.05,0.00,0.00,0.00,0.00,649523),('5','182','226630','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649524),('5','182','226656','426',165.00,163.00,0.00,0.00,0.00,0.00,0.00,649589),('5','182','226656','427',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649590),('5','182','226656','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649591),('5','182','231728','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662753),('5','182','231728','427',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662754),('5','182','231728','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662755),('5','182','231730','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662759),('5','182','231730','427',300.00,300.00,303.33,0.00,0.00,0.00,0.00,662760),('5','182','231730','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662761),('5','182','231734','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662771),('5','182','231734','427',300.00,300.00,587.24,0.00,0.00,0.00,0.00,662772),('5','182','231734','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662773),('5','182','231739','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662784),('5','182','231739','427',300.00,300.00,239.11,0.00,0.00,0.00,0.00,662785),('5','182','231739','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662786),('5','182','231741','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662789),('5','182','231741','427',300.00,300.00,202.21,0.00,0.00,0.00,0.00,662790),('5','182','231741','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662791),('5','182','231743','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662795),('5','182','231743','427',300.00,310.00,332.48,0.00,0.00,0.00,0.00,662796),('5','182','231743','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662797),('5','182','231744','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662798),('5','182','231744','427',300.00,310.00,178.46,0.00,0.00,0.00,0.00,662799),('5','182','231744','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662800),('5','182','231748','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662810),('5','182','231748','427',300.00,310.00,284.98,0.00,0.00,0.00,0.00,662811),('5','182','231748','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662812),('5','182','231752','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662822),('5','182','231752','427',300.00,310.00,362.22,0.00,0.00,0.00,0.00,662823),('5','182','231752','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662824),('5','182','231754','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662828),('5','182','231754','427',300.00,310.00,175.80,0.00,0.00,0.00,0.00,662829),('5','182','231754','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662830),('5','182','231757','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662837),('5','182','231757','427',300.00,310.00,134.76,0.00,0.00,0.00,0.00,662838),('5','182','231757','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662839),('5','182','231760','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662846),('5','182','231760','427',300.00,310.00,138.83,0.00,0.00,0.00,0.00,662847),('5','182','231760','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662848),('5','182','231764','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662858),('5','182','231764','427',300.00,320.00,270.30,0.00,0.00,0.00,0.00,662859),('5','182','231764','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662860),('5','182','231765','426',163.00,163.00,1145.01,0.00,0.00,0.00,0.00,662861),('5','182','231765','427',300.00,320.00,748.25,0.00,0.00,0.00,0.00,662862),('5','182','231765','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662863),('5','182','231770','426',163.00,163.00,1613.69,0.00,0.00,0.00,0.00,662876),('5','182','231770','427',300.00,320.00,266.79,0.00,0.00,0.00,0.00,662877),('5','182','231770','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662878),('5','182','231782','426',163.00,163.00,1947.90,0.00,0.00,0.00,0.00,662912),('5','182','231782','427',300.00,320.00,594.83,0.00,0.00,0.00,0.00,662913),('5','182','231782','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662914),('5','182','232415','426',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664568),('5','182','232415','427',300.00,320.00,0.00,0.00,0.00,0.00,0.00,664569),('5','182','232415','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664570),('5','182','232418','426',163.00,163.00,1782.77,0.00,0.00,0.00,0.00,664577),('5','182','232418','427',300.00,320.00,1698.67,0.00,0.00,0.00,0.00,664578),('5','182','232418','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664579),('5','182','232421','426',163.00,163.00,3252.20,0.00,0.00,0.00,0.00,664586),('5','182','232421','427',300.00,320.00,528.39,0.00,0.00,0.00,0.00,664587),('5','182','232421','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664588),('5','182','232435','426',163.00,163.00,3742.25,0.00,0.00,0.00,0.00,664624),('5','182','232435','427',300.00,327.00,434.71,0.00,0.00,0.00,0.00,664625),('5','182','232435','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664626),('5','182','232919','426',163.00,163.00,3208.09,0.00,0.00,0.00,0.00,665908),('5','182','232919','427',300.00,327.00,1002.90,0.00,0.00,0.00,0.00,665909),('5','182','232919','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665910),('5','182','232930','426',163.00,163.00,4236.06,0.00,0.00,0.00,0.00,665942),('5','182','232930','427',300.00,330.00,1173.99,0.00,0.00,0.00,0.00,665943),('5','182','232930','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665944),('5','182','233199','426',163.00,163.00,3323.15,0.00,0.00,0.00,0.00,666641),('5','182','233199','427',300.00,345.00,800.83,0.00,0.00,0.00,0.00,666642),('5','182','233199','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666643),('5','182','233476','426',163.00,163.00,2702.28,0.00,0.00,0.00,0.00,667366),('5','182','233476','427',300.00,345.00,250.24,0.00,0.00,0.00,0.00,667367),('5','182','233476','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667368),('5','182','234152','426',163.00,163.00,2434.17,0.00,0.00,0.00,0.00,669143),('5','182','234152','427',300.00,345.00,397.31,0.00,0.00,0.00,0.00,669144),('5','182','234152','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669145),('5','182','234154','426',163.00,163.00,2379.59,0.00,0.00,0.00,0.00,669149),('5','182','234154','427',300.00,345.00,94.80,0.00,0.00,0.00,0.00,669150),('5','182','234154','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669151),('5','182','234158','426',163.00,163.00,3721.75,0.00,0.00,0.00,0.00,669159),('5','182','234158','427',300.00,345.00,133.65,0.00,0.00,0.00,0.00,669160),('5','182','234158','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669161),('5','182','234381','426',163.00,165.00,2874.55,0.00,0.00,0.00,0.00,669747),('5','182','234381','427',300.00,345.00,340.37,0.00,0.00,0.00,0.00,669748),('5','182','234381','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669749),('5','182','234675','426',163.00,165.00,3506.36,0.00,0.00,0.00,0.00,670531),('5','182','234675','427',300.00,345.00,139.96,0.00,0.00,0.00,0.00,670532),('5','182','234675','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670533),('5','182','234936','426',163.00,165.00,2447.06,0.00,0.00,0.00,0.00,671229),('5','182','234936','427',300.00,345.00,906.77,0.00,0.00,0.00,0.00,671230),('5','182','234936','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671231),('5','182','237758','426',165.00,165.00,1595.00,0.00,0.00,0.00,0.00,678579),('5','182','237758','427',300.00,345.00,504.22,0.00,0.00,0.00,0.00,678580),('5','182','237758','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678581),('5','182','237764','426',165.00,165.00,4261.68,0.00,0.00,0.00,0.00,678596),('5','182','237764','427',300.00,345.00,231.02,0.00,0.00,0.00,0.00,678597),('5','182','237764','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678598),('5','182','237767','426',165.00,165.00,5205.28,0.00,0.00,0.00,0.00,678605),('5','182','237767','427',300.00,345.00,55.11,0.00,0.00,0.00,0.00,678606),('5','182','237767','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678607),('5','182','237768','426',165.00,165.00,9750.18,0.00,0.00,0.00,0.00,678608),('5','182','237768','427',300.00,345.00,604.48,0.00,0.00,0.00,0.00,678609),('5','182','237768','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678610),('5','182','237769','426',165.00,165.00,16377.90,0.00,0.00,0.00,0.00,678611),('5','182','237769','427',300.00,345.00,1037.35,0.00,0.00,0.00,0.00,678612),('5','182','237769','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678613),('5','182','237770','426',165.00,165.00,11397.61,0.00,0.00,0.00,0.00,678614),('5','182','237770','427',300.00,345.00,614.68,0.00,0.00,0.00,0.00,678615),('5','182','237770','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678616),('5','182','237959','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679094),('5','182','237959','427',300.00,345.00,500.00,0.00,0.00,0.00,0.00,679095),('5','182','237959','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679096),('5','182','237960','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679097),('5','182','237960','427',300.00,345.00,348.91,0.00,0.00,0.00,0.00,679098),('5','182','237960','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679099),('5','182','237962','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679103),('5','182','237962','427',300.00,345.00,212.45,0.00,0.00,0.00,0.00,679104),('5','182','237962','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679105),('5','182','237963','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679106),('5','182','237963','427',300.00,345.00,500.17,0.00,0.00,0.00,0.00,679107),('5','182','237963','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679108),('5','182','237965','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679112),('5','182','237965','427',300.00,345.00,282.92,0.00,0.00,0.00,0.00,679113),('5','182','237965','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679114),('5','182','237968','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679118),('5','182','237968','427',300.00,345.00,626.75,0.00,0.00,0.00,0.00,679119),('5','182','237968','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679120),('5','182','237969','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679121),('5','182','237969','427',300.00,345.00,451.80,0.00,0.00,0.00,0.00,679122),('5','182','237969','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679123),('5','182','238255','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679865),('5','182','238255','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,679866),('5','182','238255','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679867),('5','182','239138','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682150),('5','182','239138','427',300.00,345.00,240.63,0.00,0.00,0.00,0.00,682151),('5','182','239138','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682152),('5','182','239149','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682183),('5','182','239149','427',300.00,345.00,277.83,0.00,0.00,0.00,0.00,682184),('5','182','239149','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682185),('5','182','239164','426',165.00,165.00,3847.97,0.00,0.00,0.00,0.00,682226),('5','182','239164','427',300.00,345.00,50.00,0.00,0.00,0.00,0.00,682227),('5','182','239164','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682228),('5','182','239371','426',165.00,165.00,10628.97,0.00,0.00,0.00,0.00,682759),('5','182','239371','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682760),('5','182','239371','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682761),('5','182','239383','426',165.00,165.00,6664.56,0.00,0.00,0.00,0.00,682793),('5','182','239383','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682794),('5','182','239383','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682795),('5','182','239841','426',165.00,165.00,6926.34,0.00,0.00,0.00,0.00,683987),('5','182','239841','427',300.00,345.00,11.89,0.00,0.00,0.00,0.00,683988),('5','182','239841','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683989),('5','182','240063','426',165.00,165.00,2009.58,0.00,0.00,0.00,0.00,684558),('5','182','240063','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684559),('5','182','240063','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684560),('5','182','240760','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686323),('5','182','240760','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,686324),('5','182','240760','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686325),('5','182','240763','426',165.00,165.00,5739.25,0.00,0.00,0.00,0.00,686331),('5','182','240763','427',300.00,345.00,20.00,0.00,0.00,0.00,0.00,686332),('5','182','240763','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686333),('5','182','240777','426',165.00,165.00,6429.41,0.00,0.00,0.00,0.00,686368),('5','182','240777','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,686369),('5','182','240777','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686370),('5','182','240788','426',165.00,165.00,5966.75,0.00,0.00,0.00,0.00,686397),('5','182','240788','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,686398),('5','182','240788','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686399),('5','182','241317','426',165.00,165.00,6717.95,0.00,0.00,0.00,0.00,687805),('5','182','241317','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,687806),('5','182','241317','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687807),('5','182','241583','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688515),('5','182','241583','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688516),('5','182','241583','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688517),('5','182','241595','426',165.00,165.00,4219.65,0.00,0.00,0.00,0.00,688542),('5','182','241595','427',300.00,345.00,10.28,0.00,0.00,0.00,0.00,688543),('5','182','241595','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688544),('5','182','241601','426',165.00,165.00,1183.30,0.00,0.00,0.00,0.00,688557),('5','182','241601','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,688558),('5','182','241601','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688559),('5','182','241837','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689181),('5','182','241837','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,689182),('5','182','241837','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689183),('5','182','242995','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692186),('5','182','242995','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692187),('5','182','242995','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692188),('5','182','242997','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692192),('5','182','242997','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692193),('5','182','242997','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692194),('5','182','242999','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692198),('5','182','242999','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692199),('5','182','242999','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692200),('5','182','243000','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692201),('5','182','243000','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692202),('5','182','243000','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692203),('5','182','243287','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692966),('5','182','243287','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692967),('5','182','243287','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692968),('5','182','243428','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693322),('5','182','243428','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693323),('5','182','243428','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693324),('5','182','244101','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695053),('5','182','244101','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695054),('5','182','244101','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695055),('5','182','244103','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695059),('5','182','244103','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695060),('5','182','244103','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695061),('5','182','244107','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695070),('5','182','244107','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695071),('5','182','244107','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695072),('5','182','244110','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695077),('5','182','244110','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695078),('5','182','244110','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695079),('5','182','244398','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695836),('5','182','244398','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695837),('5','182','244398','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695838),('5','182','244570','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696274),('5','182','244570','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696275),('5','182','244570','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696276),('5','182','244817','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696925),('5','182','244817','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696926),('5','182','244817','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696927),('5','182','245107','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697677),('5','182','245107','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697678),('5','182','245107','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697679),('5','182','245380','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698388),('5','182','245380','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698389),('5','182','245380','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698390),('5','182','245487','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698650),('5','182','245487','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698651),('5','182','245487','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698652),('5','182','245788','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699425),('5','182','245788','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,699426),('5','182','245788','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699427),('5','182','246033','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700077),('5','182','246033','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,700078),('5','182','246033','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700079),('5','182','246273','426',165.00,165.00,1416.63,0.00,0.00,0.00,0.00,700688),('5','182','246273','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,700689),('5','182','246273','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700690),('5','182','246529','426',165.00,165.00,3113.72,0.00,0.00,0.00,0.00,701367),('5','182','246529','427',300.00,345.00,48.12,0.00,0.00,0.00,0.00,701368),('5','182','246529','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701369),('5','182','246776','426',165.00,165.00,2574.62,0.00,0.00,0.00,0.00,702007),('5','182','246776','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,702008),('5','182','246776','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702009),('5','182','247117','426',165.00,165.00,2626.22,0.00,0.00,0.00,0.00,702908),('5','182','247117','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,702909),('5','182','247117','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702910),('5','182','247354','426',165.00,165.00,2265.34,0.00,0.00,0.00,0.00,703516),('5','182','247354','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,703517),('5','182','247354','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703518),('5','182','247408','426',165.00,165.00,2183.57,0.00,0.00,0.00,0.00,703631),('5','182','247408','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,703632),('5','182','247408','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703633),('5','182','247725','426',165.00,165.00,602.79,0.00,0.00,0.00,0.00,704462),('5','182','247725','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,704463),('5','182','247725','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704464),('5','182','248015','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705205),('5','182','248015','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,705206),('5','182','248015','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705207),('5','182','248174','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705623),('5','182','248174','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,705624),('5','182','248174','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705625),('5','182','248563','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706631),('5','182','248563','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,706632),('5','182','248563','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706633),('5','182','248812','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707275),('5','182','248812','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,707276),('5','182','248812','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707277),('5','182','248970','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707671),('5','182','248970','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,707672),('5','182','248970','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707673),('5','182','249206','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708272),('5','182','249206','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,708273),('5','182','249206','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708274),('5','182','249484','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708985),('5','182','249484','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,708986),('5','182','249484','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708987),('5','182','249794','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709797),('5','182','249794','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,709798),('5','182','249794','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709799),('5','182','250123','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710613),('5','182','250123','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,710614),('5','182','250123','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710615),('5','182','250185','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710777),('5','182','250185','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,710778),('5','182','250185','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710779),('5','182','250407','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711332),('5','182','250407','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,711333),('5','182','250407','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711334),('5','182','250737','426',165.00,165.00,3861.52,0.00,0.00,0.00,0.00,712211),('5','182','250737','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,712212),('5','182','250737','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712213),('5','182','250878','426',165.00,165.00,3603.55,0.00,0.00,0.00,0.00,712550),('5','182','250878','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,712551),('5','182','250878','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712552),('5','182','251088','426',165.00,165.00,5310.10,0.00,0.00,0.00,0.00,713090),('5','182','251088','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,713091),('5','182','251088','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713092),('5','182','251370','426',165.00,165.00,3443.45,0.00,0.00,0.00,0.00,713837),('5','182','251370','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,713838),('5','182','251370','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713839),('5','182','251622','426',165.00,165.00,3174.66,0.00,0.00,0.00,0.00,714494),('5','182','251622','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,714495),('5','182','251622','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714496),('5','182','251832','426',165.00,165.00,3203.99,0.00,0.00,0.00,0.00,715040),('5','182','251832','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,715041),('5','182','251832','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715042),('5','182','252450','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716675),('5','182','252450','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,716676),('5','182','252450','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716677),('5','182','252580','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716991),('5','182','252580','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,716992),('5','182','252580','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716993),('5','182','252582','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716997),('5','182','252582','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,716998),('5','182','252582','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716999),('5','182','252935','426',165.00,165.00,1192.33,0.00,0.00,0.00,0.00,717932),('5','182','252935','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,717933),('5','182','252935','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717934),('5','182','253152','426',165.00,165.00,3844.16,0.00,0.00,0.00,0.00,718495),('5','182','253152','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,718496),('5','182','253152','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718497),('5','182','253265','426',165.00,165.00,5782.69,0.00,0.00,0.00,0.00,718777),('5','182','253265','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,718778),('5','182','253265','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718779),('5','182','253516','426',165.00,165.00,5031.98,0.00,0.00,0.00,0.00,719420),('5','182','253516','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,719421),('5','182','253516','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719422),('5','182','253948','426',165.00,165.00,4607.74,0.00,0.00,0.00,0.00,720562),('5','182','253948','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,720563),('5','182','253948','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720564),('5','182','253958','426',165.00,165.00,8179.90,0.00,0.00,0.00,0.00,720580),('5','182','253958','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,720581),('5','182','253958','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720582),('5','182','254281','426',165.00,165.00,5855.44,0.00,0.00,0.00,0.00,721409),('5','182','254281','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,721410),('5','182','254281','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721411),('5','182','254481','426',165.00,165.00,3396.90,0.00,0.00,0.00,0.00,721923),('5','182','254481','427',300.00,345.00,0.00,0.00,0.00,0.00,0.00,721924),('5','182','254481','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721925),('5','182','254717','426',165.00,165.00,4735.34,0.00,0.00,0.00,0.00,722522),('5','182','254717','427',300.00,350.00,0.00,0.00,0.00,0.00,0.00,722523),('5','182','254717','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722524),('5','182','254947','426',165.00,165.00,953.60,0.00,0.00,0.00,0.00,723118),('5','182','254947','427',300.00,350.00,0.00,0.00,0.00,0.00,0.00,723119),('5','182','254947','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723120),('5','182','255284','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723974),('5','182','255284','427',300.00,350.00,0.00,0.00,0.00,0.00,0.00,723975),('5','182','255284','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723976),('5','182','255531','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724571),('5','182','255531','427',300.00,350.00,0.00,0.00,0.00,0.00,0.00,724572),('5','182','255531','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724573),('5','182','255740','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725105),('5','182','255740','427',300.00,350.00,0.00,0.00,0.00,0.00,0.00,725106),('5','182','255740','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725107),('5','182','255981','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725716),('5','182','255981','427',300.00,355.00,0.00,0.00,0.00,0.00,0.00,725717),('5','182','255981','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725718),('5','182','256362','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726673),('5','182','256362','427',300.00,355.00,0.00,0.00,0.00,0.00,0.00,726674),('5','182','256362','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726675),('5','182','256511','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727062),('5','182','256511','427',300.00,355.00,0.00,0.00,0.00,0.00,0.00,727063),('5','182','256511','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727064),('5','182','256764','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727698),('5','182','256764','427',300.00,355.00,0.00,0.00,0.00,0.00,0.00,727699),('5','182','256764','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727700),('5','182','256959','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728245),('5','182','256959','427',300.00,360.00,0.00,0.00,0.00,0.00,0.00,728246),('5','182','256959','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728247),('5','182','257270','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729036),('5','182','257270','427',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729037),('5','182','257270','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729038),('5','182','257489','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729625),('5','182','257489','427',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729626),('5','182','257489','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729627),('5','182','257490','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729628),('5','182','257490','427',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729629),('5','182','257490','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729630),('5','182','257491','427',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729631),('5','182','257491','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729632),('5','182','257491','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729633),('5','182','257492','427',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729634),('5','182','257492','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729635),('5','182','257492','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729636),('5','182','257493','427',360.00,365.00,0.00,0.00,0.00,0.00,0.00,729637),('5','182','257493','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729638),('5','182','257493','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729639),('5','182','257494','426',165.00,165.00,1978.59,0.00,0.00,0.00,0.00,729640),('5','182','257494','427',365.00,390.00,0.00,0.00,0.00,0.00,0.00,729641),('5','182','257494','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729642),('5','182','257495','427',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729643),('5','182','257495','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729644),('5','182','257495','426',165.00,165.00,4567.41,0.00,0.00,0.00,0.00,729645),('5','182','257496','427',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729646),('5','182','257496','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729647),('5','182','257496','426',165.00,165.00,4061.69,0.00,0.00,0.00,0.00,729648),('5','182','257497','426',165.00,165.00,4064.56,0.00,0.00,0.00,0.00,729649),('5','182','257497','427',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729650),('5','182','257497','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729651),('5','182','257498','427',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729652),('5','182','257498','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729653),('5','182','257498','426',165.00,165.00,1342.15,0.00,0.00,0.00,0.00,729654),('5','182','257499','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729655),('5','182','257499','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729656),('5','182','257499','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729657),('5','182','257500','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729658),('5','182','257500','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729659),('5','182','257500','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729660),('5','182','257501','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729661),('5','182','257501','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729662),('5','182','257501','426',165.00,165.00,1090.60,0.00,0.00,0.00,0.00,729663),('5','182','257502','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729664),('5','182','257502','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729665),('5','182','257502','426',165.00,165.00,5011.39,0.00,0.00,0.00,0.00,729666),('5','182','257503','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729667),('5','182','257503','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729668),('5','182','257503','426',165.00,165.00,5099.37,0.00,0.00,0.00,0.00,729669),('5','182','257504','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729670),('5','182','257504','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729671),('5','182','257504','426',165.00,165.00,5262.31,0.00,0.00,0.00,0.00,729672),('5','182','257505','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729673),('5','182','257505','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729674),('5','182','257505','426',165.00,165.00,5082.70,0.00,0.00,0.00,0.00,729675),('5','182','257506','426',165.00,165.00,654.50,0.00,0.00,0.00,0.00,729676),('5','182','257506','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729677),('5','182','257506','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729678),('5','182','257507','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729679),('5','182','257507','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729680),('5','182','257507','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729681),('5','182','257508','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729682),('5','182','257508','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729683),('5','182','257508','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729684),('5','182','257509','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729685),('5','182','257509','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729686),('5','182','257509','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729687),('5','182','257510','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729688),('5','182','257510','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729689),('5','182','257510','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729690),('5','182','257511','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729691),('5','182','257511','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729692),('5','182','257511','426',165.00,165.00,899.50,0.00,0.00,0.00,0.00,729693),('5','182','257512','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729694),('5','182','257512','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729695),('5','182','257512','426',165.00,165.00,8632.94,0.00,0.00,0.00,0.00,729696),('5','182','257513','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729697),('5','182','257513','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729698),('5','182','257513','426',165.00,165.00,8560.43,0.00,0.00,0.00,0.00,729699),('5','182','257514','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729700),('5','182','257514','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729701),('5','182','257514','426',165.00,165.00,9095.79,0.00,0.00,0.00,0.00,729702),('5','182','257515','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729703),('5','182','257515','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729704),('5','182','257515','426',165.00,165.00,6380.52,0.00,0.00,0.00,0.00,729705),('5','182','257516','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729706),('5','182','257516','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729707),('5','182','257516','426',165.00,165.00,18451.55,0.00,0.00,0.00,0.00,729708),('5','182','257517','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729709),('5','182','257517','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729710),('5','182','257517','426',165.00,165.00,10064.50,0.00,0.00,0.00,0.00,729711),('5','182','257518','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729712),('5','182','257518','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729713),('5','182','257518','426',165.00,165.00,7863.53,0.00,0.00,0.00,0.00,729714),('5','182','257519','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729715),('5','182','257519','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729716),('5','182','257519','426',165.00,165.00,15516.41,0.00,0.00,0.00,0.00,729717),('5','182','257520','427',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729718),('5','182','257520','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729719),('5','182','257520','426',165.00,165.00,5852.40,0.00,0.00,0.00,0.00,729720),('5','182','257521','427',425.00,425.00,0.00,0.00,0.00,0.00,0.00,729721),('5','182','257521','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729722),('5','182','257521','426',165.00,165.00,4864.79,0.00,0.00,0.00,0.00,729723),('5','182','257522','427',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729724),('5','182','257522','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729725),('5','182','257522','426',165.00,165.00,1112.05,0.00,0.00,0.00,0.00,729726),('5','182','257523','427',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729727),('5','182','257523','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','182','257523','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','182','257524','427',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729730),('5','182','257524','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','182','257524','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','182','257525','427',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729733),('5','182','257525','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729734),('5','182','257525','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','182','257526','427',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729736),('5','182','257526','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','182','257526','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729738),('5','182','257527','427',600.00,600.00,0.00,0.00,0.00,0.00,0.00,729739),('5','182','257527','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729740),('5','182','257527','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729741),('5','182','257528','427',600.00,640.00,0.00,0.00,0.00,0.00,0.00,729742),('5','182','257528','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729743),('5','182','257528','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729744),('5','182','257529','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729745),('5','182','257529','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','182','257529','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729747),('5','182','257530','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729748),('5','182','257530','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','182','257530','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729750),('5','182','257531','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729751),('5','182','257531','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','182','257531','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729753),('5','182','257532','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729754),('5','182','257532','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','182','257532','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729756),('5','182','257533','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729757),('5','182','257533','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','182','257533','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729759),('5','182','257534','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729760),('5','182','257534','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729761),('5','182','257534','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729762),('5','182','257535','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729763),('5','182','257535','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','182','257535','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729765),('5','182','257536','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729766),('5','182','257536','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','182','257536','426',165.00,165.00,750.00,0.00,0.00,0.00,0.00,729768),('5','182','257537','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729769),('5','182','257537','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','182','257537','426',165.00,165.00,4120.32,0.00,0.00,0.00,0.00,729771),('5','182','257538','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729772),('5','182','257538','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','182','257538','426',165.00,165.00,3066.20,0.00,0.00,0.00,0.00,729774),('5','182','257539','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729775),('5','182','257539','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','182','257539','426',165.00,165.00,4102.00,0.00,0.00,0.00,0.00,729777),('5','182','257540','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729778),('5','182','257540','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729779),('5','182','257540','426',165.00,165.00,1497.49,0.00,0.00,0.00,0.00,729780),('5','182','257541','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729781),('5','182','257541','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','182','257541','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729783),('5','182','257542','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729784),('5','182','257542','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','182','257542','426',165.00,165.00,704.91,0.00,0.00,0.00,0.00,729786),('5','182','257543','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729787),('5','182','257543','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','182','257543','426',165.00,165.00,5493.06,0.00,0.00,0.00,0.00,729789),('5','182','257544','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729790),('5','182','257544','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','182','257544','426',165.00,165.00,7288.14,0.00,0.00,0.00,0.00,729792),('5','182','257545','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729793),('5','182','257545','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','182','257545','426',165.00,165.00,3846.53,0.00,0.00,0.00,0.00,729795),('5','182','257546','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729796),('5','182','257546','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','182','257546','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729798),('5','182','257547','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729799),('5','182','257547','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','182','257547','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729801),('5','182','257548','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729802),('5','182','257548','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','182','257548','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729804),('5','182','257549','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729805),('5','182','257549','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','182','257549','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729807),('5','182','257550','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729808),('5','182','257550','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','182','257550','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729810),('5','182','257551','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729811),('5','182','257551','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729812),('5','182','257551','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729813),('5','182','257552','427',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729814),('5','182','257552','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','182','257552','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','182','257553','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729817),('5','182','257553','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','182','257553','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729819),('5','182','257554','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729820),('5','182','257554','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','182','257554','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729822),('5','182','257555','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729823),('5','182','257555','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','182','257555','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729825),('5','182','257556','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729826),('5','182','257556','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','182','257556','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729828),('5','182','257557','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729829),('5','182','257557','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729830),('5','182','257557','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729831),('5','182','257558','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729832),('5','182','257558','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','182','257558','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729834),('5','182','257559','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729835),('5','182','257559','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','182','257559','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729837),('5','182','257560','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729838),('5','182','257560','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','182','257560','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729840),('5','182','257561','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729841),('5','182','257561','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','182','257561','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','182','257562','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729844),('5','182','257562','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729845),('5','182','257562','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729846),('5','182','257563','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729847),('5','182','257563','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729848),('5','182','257563','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729849),('5','182','257564','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729850),('5','182','257564','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729851),('5','182','257564','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729852),('5','182','257565','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729853),('5','182','257565','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','182','257565','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','182','257566','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729856),('5','182','257566','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729857),('5','182','257566','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','182','257567','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729859),('5','182','257567','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','182','257567','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','182','257568','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729862),('5','182','257568','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','182','257568','426',165.00,165.00,4576.84,0.00,0.00,0.00,0.00,729864),('5','182','257569','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729865),('5','182','257569','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729866),('5','182','257569','426',165.00,165.00,7833.72,0.00,0.00,0.00,0.00,729867),('5','182','257570','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729868),('5','182','257570','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729869),('5','182','257570','426',165.00,165.00,1762.80,0.00,0.00,0.00,0.00,729870),('5','182','257571','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729871),('5','182','257571','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','182','257571','426',165.00,165.00,1244.00,0.00,0.00,0.00,0.00,729873),('5','182','257572','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729874),('5','182','257572','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','182','257572','426',165.00,165.00,4301.05,0.00,0.00,0.00,0.00,729876),('5','182','257573','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729877),('5','182','257573','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','182','257573','426',165.00,165.00,5078.96,0.00,0.00,0.00,0.00,729879),('5','182','257574','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729880),('5','182','257574','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','182','257574','426',165.00,165.00,4002.50,0.00,0.00,0.00,0.00,729882),('5','182','257575','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729883),('5','182','257575','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','182','257575','426',165.00,165.00,5400.76,0.00,0.00,0.00,0.00,729885),('5','182','257576','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729886),('5','182','257576','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','182','257576','426',165.00,165.00,6572.79,0.00,0.00,0.00,0.00,729888),('5','182','257577','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729889),('5','182','257577','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','182','257577','426',165.00,165.00,4186.45,0.00,0.00,0.00,0.00,729891),('5','182','257578','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729892),('5','182','257578','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','182','257578','426',165.00,165.00,6247.56,0.00,0.00,0.00,0.00,729894),('5','182','257579','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729895),('5','182','257579','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','182','257579','426',165.00,165.00,7479.25,0.00,0.00,0.00,0.00,729897),('5','182','257580','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729898),('5','182','257580','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','182','257580','426',165.00,165.00,7112.25,0.00,0.00,0.00,0.00,729900),('5','182','257581','426',165.00,165.00,4053.38,0.00,0.00,0.00,0.00,729901),('5','182','257581','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729902),('5','182','257581','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','182','257582','426',165.00,165.00,7190.87,0.00,0.00,0.00,0.00,729904),('5','182','257582','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729905),('5','182','257582','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729906),('5','182','257583','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729907),('5','182','257583','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729908),('5','182','257583','426',165.00,165.00,5101.96,0.00,0.00,0.00,0.00,729909),('5','182','257584','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729910),('5','182','257584','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729911),('5','182','257584','426',165.00,165.00,5111.61,0.00,0.00,0.00,0.00,729912),('5','182','257585','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729913),('5','182','257585','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','182','257585','426',165.00,165.00,5036.09,0.00,0.00,0.00,0.00,729915),('5','182','257586','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729916),('5','182','257586','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','182','257586','426',165.00,165.00,4067.21,0.00,0.00,0.00,0.00,729918),('5','182','257587','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729919),('5','182','257587','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','182','257587','426',165.00,165.00,3802.25,0.00,0.00,0.00,0.00,729921),('5','182','257588','426',165.00,165.00,1784.35,0.00,0.00,0.00,0.00,729922),('5','182','257588','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729923),('5','182','257588','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729924),('5','182','257589','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729925),('5','182','257589','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','182','257589','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729927),('5','182','257590','427',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729928),('5','182','257590','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','182','257590','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729930),('5','182','257591','427',670.00,670.00,0.00,0.00,0.00,0.00,0.00,729931),('5','182','257591','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','182','257591','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729933),('5','182','257592','427',670.00,670.00,0.00,0.00,0.00,0.00,0.00,729934),('5','182','257592','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','182','257592','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729936),('5','182','257593','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729937),('5','182','257593','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729938),('5','182','257593','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','182','257594','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729940),('5','182','257594','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729941),('5','182','257594','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729942),('5','182','257595','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729943),('5','182','257595','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729944),('5','182','257595','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729945),('5','182','257596','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729946),('5','182','257596','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729947),('5','182','257596','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729948),('5','182','257597','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729949),('5','182','257597','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','182','257597','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729951),('5','182','257598','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729952),('5','182','257598','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729953),('5','182','257598','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','182','257599','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729955),('5','182','257599','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','182','257599','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','182','257600','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729958),('5','182','257600','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','182','257600','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729960),('5','182','257601','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729961),('5','182','257601','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729962),('5','182','257601','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','182','257602','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729964),('5','182','257602','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','182','257602','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729966),('5','182','257603','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729967),('5','182','257603','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','182','257603','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729969),('5','182','257604','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729970),('5','182','257604','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','182','257604','426',165.00,165.00,2513.01,0.00,0.00,0.00,0.00,729972),('5','182','257605','426',165.00,165.00,4419.81,0.00,0.00,0.00,0.00,729973),('5','182','257605','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729974),('5','182','257605','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729975),('5','182','257606','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729976),('5','182','257606','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','182','257606','426',165.00,165.00,4598.78,0.00,0.00,0.00,0.00,729978),('5','182','257607','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729979),('5','182','257607','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','182','257607','426',165.00,165.00,4755.18,0.00,0.00,0.00,0.00,729981),('5','182','257608','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729982),('5','182','257608','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','182','257608','426',165.00,165.00,4647.90,0.00,0.00,0.00,0.00,729984),('5','182','257609','426',165.00,165.00,4261.06,0.00,0.00,0.00,0.00,729985),('5','182','257609','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729986),('5','182','257609','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729987),('5','182','257610','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729988),('5','182','257610','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729989),('5','182','257610','426',165.00,165.00,4165.20,0.00,0.00,0.00,0.00,729990),('5','182','257611','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729991),('5','182','257611','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729992),('5','182','257611','426',165.00,165.00,4015.20,0.00,0.00,0.00,0.00,729993),('5','182','257612','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729994),('5','182','257612','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','182','257612','426',165.00,165.00,2051.80,0.00,0.00,0.00,0.00,729996),('5','182','257613','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729997),('5','182','257613','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','182','257613','426',165.00,165.00,1604.72,0.00,0.00,0.00,0.00,729999),('5','182','257614','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730000),('5','182','257614','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','182','257614','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730002),('5','182','257615','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730003),('5','182','257615','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730004),('5','182','257615','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730005),('5','182','257616','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730006),('5','182','257616','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730007),('5','182','257616','426',165.00,165.00,3754.70,0.00,0.00,0.00,0.00,730008),('5','182','257617','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730009),('5','182','257617','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730010),('5','182','257617','426',165.00,165.00,5427.41,0.00,0.00,0.00,0.00,730011),('5','182','257618','426',165.00,165.00,4189.39,0.00,0.00,0.00,0.00,730012),('5','182','257618','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730013),('5','182','257618','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730014),('5','182','257619','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730015),('5','182','257619','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','182','257619','426',165.00,165.00,4899.47,0.00,0.00,0.00,0.00,730017),('5','182','257620','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730018),('5','182','257620','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','182','257620','426',165.00,165.00,4958.44,0.00,0.00,0.00,0.00,730020),('5','182','257621','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730021),('5','182','257621','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','182','257621','426',165.00,165.00,4203.68,0.00,0.00,0.00,0.00,730023),('5','182','257622','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730024),('5','182','257622','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','182','257622','426',165.00,165.00,4008.58,0.00,0.00,0.00,0.00,730026),('5','182','257623','426',165.00,165.00,4204.76,0.00,0.00,0.00,0.00,730027),('5','182','257623','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730028),('5','182','257623','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730029),('5','182','257624','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730030),('5','182','257624','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','182','257624','426',165.00,165.00,4332.05,0.00,0.00,0.00,0.00,730032),('5','182','257625','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730033),('5','182','257625','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730034),('5','182','257625','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730035),('5','182','257626','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730036),('5','182','257626','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','182','257626','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730038),('5','182','257627','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730039),('5','182','257627','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730040),('5','182','257627','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730041),('5','182','257628','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730042),('5','182','257628','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730043),('5','182','257628','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730044),('5','182','257629','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730045),('5','182','257629','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','182','257629','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730047),('5','182','257630','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730048),('5','182','257630','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','182','257630','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730050),('5','182','257631','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730051),('5','182','257631','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730052),('5','182','257631','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730053),('5','182','257632','427',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730054),('5','182','257632','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','182','257632','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730056),('5','182','257633','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730057),('5','182','257633','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730058),('5','182','257633','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','182','257634','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730060),('5','182','257634','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730061),('5','182','257634','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','182','257635','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730063),('5','182','257635','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','182','257635','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730065),('5','182','257636','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730066),('5','182','257636','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','182','257636','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730068),('5','182','257637','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730069),('5','182','257637','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','182','257637','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','182','257638','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730072),('5','182','257638','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','182','257638','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730074),('5','182','257639','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730075),('5','182','257639','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','182','257639','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730077),('5','182','257640','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730078),('5','182','257640','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','182','257640','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730080),('5','182','257641','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730081),('5','182','257641','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','182','257641','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730083),('5','182','257642','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730084),('5','182','257642','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','182','257642','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','182','257643','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730087),('5','182','257643','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730088),('5','182','257643','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730089),('5','182','257644','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730090),('5','182','257644','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','182','257644','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730092),('5','182','257645','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730093),('5','182','257645','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','182','257645','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730095),('5','182','257646','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730096),('5','182','257646','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','182','257646','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730098),('5','182','257647','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730099),('5','182','257647','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','182','257647','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730101),('5','182','257648','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730102),('5','182','257648','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','182','257648','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730104),('5','182','257649','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730105),('5','182','257649','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','182','257649','426',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730107),('5','182','257650','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730108),('5','182','257650','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','182','257650','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730110),('5','182','257651','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730111),('5','182','257651','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','182','257651','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730113),('5','182','257652','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730114),('5','182','257652','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','182','257652','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730116),('5','182','257653','426',185.00,185.00,2835.00,0.00,0.00,0.00,0.00,730117),('5','182','257653','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730118),('5','182','257653','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730119),('5','182','257654','426',185.00,185.00,4242.56,0.00,0.00,0.00,0.00,730120),('5','182','257654','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730121),('5','182','257654','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730122),('5','182','257655','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730123),('5','182','257655','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','182','257655','426',185.00,185.00,4237.03,0.00,0.00,0.00,0.00,730125),('5','182','257656','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730126),('5','182','257656','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','182','257656','426',185.00,185.00,5058.20,0.00,0.00,0.00,0.00,730128),('5','182','257657','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730129),('5','182','257657','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','182','257657','426',185.00,185.00,5482.81,0.00,0.00,0.00,0.00,730131),('5','182','257658','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730132),('5','182','257658','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','182','257658','426',185.00,185.00,6335.38,0.00,0.00,0.00,0.00,730134),('5','182','257659','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730135),('5','182','257659','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','182','257659','426',185.00,185.00,4574.74,0.00,0.00,0.00,0.00,730137),('5','182','257660','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730138),('5','182','257660','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','182','257660','426',185.00,185.00,5106.23,0.00,0.00,0.00,0.00,730140),('5','182','257661','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730141),('5','182','257661','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','182','257661','426',185.00,185.00,4047.02,0.00,0.00,0.00,0.00,730143),('5','182','257662','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730144),('5','182','257662','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','182','257662','426',185.00,185.00,6788.90,0.00,0.00,0.00,0.00,730146),('5','182','257663','426',185.00,185.00,4090.56,0.00,0.00,0.00,0.00,730147),('5','182','257663','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730148),('5','182','257663','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730149),('5','182','257664','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730150),('5','182','257664','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','182','257664','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730152),('5','182','257665','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730153),('5','182','257665','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','182','257665','426',185.00,185.00,4074.25,0.00,0.00,0.00,0.00,730155),('5','182','257666','426',185.00,185.00,6348.25,0.00,0.00,0.00,0.00,730156),('5','182','257666','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730157),('5','182','257666','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730158),('5','182','257667','426',185.00,185.00,6095.56,0.00,0.00,0.00,0.00,730159),('5','182','257667','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730160),('5','182','257667','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730161),('5','182','257668','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730162),('5','182','257668','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','182','257668','426',185.00,185.00,4060.74,0.00,0.00,0.00,0.00,730164),('5','182','257669','426',185.00,185.00,2037.88,0.00,0.00,0.00,0.00,730165),('5','182','257669','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730166),('5','182','257669','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730167),('5','182','257670','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730168),('5','182','257670','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','182','257670','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730170),('5','182','257671','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730171),('5','182','257671','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','182','257671','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730173),('5','182','257672','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730174),('5','182','257672','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','182','257672','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730176),('5','182','257673','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730177),('5','182','257673','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','182','257673','426',185.00,185.00,4041.47,0.00,0.00,0.00,0.00,730179),('5','182','257674','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730180),('5','182','257674','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','182','257674','426',185.00,185.00,4278.19,0.00,0.00,0.00,0.00,730182),('5','182','257675','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730183),('5','182','257675','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','182','257675','426',185.00,185.00,4275.03,0.00,0.00,0.00,0.00,730185),('5','182','257676','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730186),('5','182','257676','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','182','257676','426',185.00,185.00,2394.04,0.00,0.00,0.00,0.00,730188),('5','182','257677','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730189),('5','182','257677','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730190),('5','182','257677','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','182','257678','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730192),('5','182','257678','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','182','257678','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730194),('5','182','257679','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730195),('5','182','257679','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730196),('5','182','257679','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730197),('5','182','257680','426',185.00,185.00,3507.07,0.00,0.00,0.00,0.00,730198),('5','182','257680','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730199),('5','182','257680','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730200),('5','182','257681','426',185.00,185.00,4399.01,0.00,0.00,0.00,0.00,730201),('5','182','257681','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730202),('5','182','257681','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730203),('5','182','257682','426',185.00,185.00,4070.02,0.00,0.00,0.00,0.00,730204),('5','182','257682','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730205),('5','182','257682','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730206),('5','182','257683','426',185.00,185.00,1534.92,0.00,0.00,0.00,0.00,730207),('5','182','257683','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730208),('5','182','257683','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730209),('5','182','257684','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730210),('5','182','257684','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730211),('5','182','257684','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','182','257685','426',185.00,185.00,3260.85,0.00,0.00,0.00,0.00,730213),('5','182','257685','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730214),('5','182','257685','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730215),('5','182','257686','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730216),('5','182','257686','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','182','257686','426',185.00,185.00,4127.62,0.00,0.00,0.00,0.00,730218),('5','182','257687','426',185.00,185.00,4596.22,0.00,0.00,0.00,0.00,730219),('5','182','257687','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730220),('5','182','257687','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730221),('5','182','257688','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730222),('5','182','257688','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','182','257688','426',185.00,185.00,1949.52,0.00,0.00,0.00,0.00,730224),('5','182','257689','426',185.00,185.00,5941.71,0.00,0.00,0.00,0.00,730225),('5','182','257689','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730226),('5','182','257689','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','182','257690','426',185.00,185.00,2607.29,0.00,0.00,0.00,0.00,730228),('5','182','257690','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730229),('5','182','257690','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730230),('5','182','257691','426',185.00,185.00,2770.02,0.00,0.00,0.00,0.00,730231),('5','182','257691','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730232),('5','182','257691','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730233),('5','182','257692','426',185.00,185.00,4173.93,0.00,0.00,0.00,0.00,730234),('5','182','257692','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730235),('5','182','257692','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730236),('5','182','257693','426',185.00,185.00,3048.05,0.00,0.00,0.00,0.00,730237),('5','182','257693','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730238),('5','182','257693','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','182','257694','426',185.00,185.00,4470.85,0.00,0.00,0.00,0.00,730240),('5','182','257694','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730241),('5','182','257694','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730242),('5','182','257695','426',185.00,185.00,4796.27,0.00,0.00,0.00,0.00,730243),('5','182','257695','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730244),('5','182','257695','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730245),('5','182','257696','426',185.00,185.00,3346.22,0.00,0.00,0.00,0.00,730246),('5','182','257696','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730247),('5','182','257696','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730248),('5','182','257697','426',185.00,185.00,2019.34,0.00,0.00,0.00,0.00,730249),('5','182','257697','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730250),('5','182','257697','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730251),('5','182','257698','426',185.00,185.00,3226.80,0.00,0.00,0.00,0.00,730252),('5','182','257698','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730253),('5','182','257698','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730254),('5','182','257699','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730255),('5','182','257699','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','182','257699','426',185.00,185.00,3564.55,0.00,0.00,0.00,0.00,730257),('5','182','257700','426',185.00,185.00,5477.67,0.00,0.00,0.00,0.00,730258),('5','182','257700','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730259),('5','182','257700','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730260),('5','182','257701','426',185.00,185.00,3508.52,0.00,0.00,0.00,0.00,730261),('5','182','257701','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730262),('5','182','257701','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730263),('5','182','257702','426',185.00,185.00,5255.04,0.00,0.00,0.00,0.00,730264),('5','182','257702','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730265),('5','182','257702','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730266),('5','182','257703','426',185.00,185.00,6072.12,0.00,0.00,0.00,0.00,730267),('5','182','257703','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730268),('5','182','257703','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730269),('5','182','257704','426',185.00,185.00,5028.79,0.00,0.00,0.00,0.00,730270),('5','182','257704','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730271),('5','182','257704','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730272),('5','182','257705','426',185.00,185.00,4264.37,0.00,0.00,0.00,0.00,730273),('5','182','257705','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730274),('5','182','257705','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730275),('5','182','257706','426',185.00,185.00,5465.95,0.00,0.00,0.00,0.00,730276),('5','182','257706','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730277),('5','182','257706','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730278),('5','182','257707','426',185.00,185.00,2994.42,0.00,0.00,0.00,0.00,730279),('5','182','257707','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730280),('5','182','257707','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730281),('5','182','257708','426',185.00,185.00,5746.46,0.00,0.00,0.00,0.00,730282),('5','182','257708','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730283),('5','182','257708','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','182','257709','426',185.00,185.00,5650.32,0.00,0.00,0.00,0.00,730285),('5','182','257709','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730286),('5','182','257709','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730287),('5','182','257710','426',185.00,185.00,4587.74,0.00,0.00,0.00,0.00,730288),('5','182','257710','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730289),('5','182','257710','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730290),('5','182','257711','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730291),('5','182','257711','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','182','257711','426',185.00,185.00,3331.45,0.00,0.00,0.00,0.00,730293),('5','182','257712','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730294),('5','182','257712','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','182','257712','426',185.00,185.00,4229.74,0.00,0.00,0.00,0.00,730296),('5','182','257713','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730297),('5','182','257713','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','182','257713','426',185.00,185.00,7748.28,0.00,0.00,0.00,0.00,730299),('5','182','257714','426',185.00,185.00,6522.01,0.00,0.00,0.00,0.00,730300),('5','182','257714','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730301),('5','182','257714','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730302),('5','182','257715','426',185.00,185.00,1864.88,0.00,0.00,0.00,0.00,730303),('5','182','257715','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730304),('5','182','257715','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730305),('5','182','257716','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730306),('5','182','257716','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730307),('5','182','257716','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730308),('5','182','257717','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730309),('5','182','257717','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730310),('5','182','257717','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730311),('5','182','257718','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730312),('5','182','257718','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730313),('5','182','257718','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730314),('5','182','257719','426',185.00,185.00,3034.92,0.00,0.00,0.00,0.00,730315),('5','182','257719','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730316),('5','182','257719','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730317),('5','182','257720','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730318),('5','182','257720','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','182','257720','426',185.00,185.00,4972.12,0.00,0.00,0.00,0.00,730320),('5','182','257721','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730321),('5','182','257721','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','182','257721','426',185.00,185.00,3419.77,0.00,0.00,0.00,0.00,730323),('5','182','257722','426',185.00,185.00,6142.36,0.00,0.00,0.00,0.00,730324),('5','182','257722','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730325),('5','182','257722','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','182','257723','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730327),('5','182','257723','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730328),('5','182','257723','426',185.00,185.00,5588.67,0.00,0.00,0.00,0.00,730329),('5','182','257724','426',185.00,185.00,4246.92,0.00,0.00,0.00,0.00,730330),('5','182','257724','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730331),('5','182','257724','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','182','257725','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730333),('5','182','257725','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','182','257725','426',185.00,185.00,4034.56,0.00,0.00,0.00,0.00,730335),('5','182','257726','426',185.00,185.00,5631.30,0.00,0.00,0.00,0.00,730336),('5','182','257726','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730337),('5','182','257726','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','182','257727','426',185.00,185.00,4115.94,0.00,0.00,0.00,0.00,730339),('5','182','257727','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730340),('5','182','257727','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','182','257728','426',185.00,185.00,3563.22,0.00,0.00,0.00,0.00,730342),('5','182','257728','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730343),('5','182','257728','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','182','257729','426',185.00,185.00,3394.45,0.00,0.00,0.00,0.00,730345),('5','182','257729','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730346),('5','182','257729','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','182','257730','426',185.00,185.00,4755.58,0.00,0.00,0.00,0.00,730348),('5','182','257730','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730349),('5','182','257730','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','182','257731','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730351),('5','182','257731','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730352),('5','182','257731','426',185.00,185.00,6627.44,0.00,0.00,0.00,0.00,730353),('5','182','257732','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730354),('5','182','257732','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730355),('5','182','257732','426',185.00,185.00,6183.45,0.00,0.00,0.00,0.00,730356),('5','182','257733','426',185.00,185.00,7572.49,0.00,0.00,0.00,0.00,730357),('5','182','257733','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730358),('5','182','257733','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','182','257734','426',185.00,185.00,6547.99,0.00,0.00,0.00,0.00,730360),('5','182','257734','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730361),('5','182','257734','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','182','257735','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730363),('5','182','257735','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730364),('5','182','257735','426',185.00,185.00,6279.91,0.00,0.00,0.00,0.00,730365),('5','182','257736','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730366),('5','182','257736','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','182','257736','426',185.00,185.00,5050.44,0.00,0.00,0.00,0.00,730368),('5','182','257737','426',185.00,185.00,3046.12,0.00,0.00,0.00,0.00,730369),('5','182','257737','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730370),('5','182','257737','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730371),('5','182','257738','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730372),('5','182','257738','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','182','257738','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730374),('5','182','257739','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730375),('5','182','257739','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730376),('5','182','257739','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730377),('5','182','257740','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730378),('5','182','257740','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','182','257740','426',185.00,185.00,220.49,0.00,0.00,0.00,0.00,730380),('5','182','257741','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730381),('5','182','257741','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730382),('5','182','257741','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730383),('5','182','257742','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730384),('5','182','257742','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730385),('5','182','257742','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730386),('5','182','257743','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730387),('5','182','257743','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','182','257743','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730389),('5','182','257744','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730390),('5','182','257744','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730391),('5','182','257744','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730392),('5','182','257745','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730393),('5','182','257745','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','182','257745','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730395),('5','182','257746','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730396),('5','182','257746','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730397),('5','182','257746','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730398),('5','182','257747','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730399),('5','182','257747','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730400),('5','182','257747','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730401),('5','182','257748','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730402),('5','182','257748','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730403),('5','182','257748','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730404),('5','182','257749','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730405),('5','182','257749','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','182','257749','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730407),('5','182','257750','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730408),('5','182','257750','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730409),('5','182','257750','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730410),('5','182','257751','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730411),('5','182','257751','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730412),('5','182','257751','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730413),('5','182','257752','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730414),('5','182','257752','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730415),('5','182','257752','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','182','257753','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730417),('5','182','257753','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','182','257753','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730419),('5','182','257754','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730420),('5','182','257754','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','182','257754','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730422),('5','182','257755','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730423),('5','182','257755','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730424),('5','182','257755','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730425),('5','182','257756','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730426),('5','182','257756','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730427),('5','182','257756','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730428),('5','182','257757','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730429),('5','182','257757','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','182','257757','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730431),('5','182','257758','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730432),('5','182','257758','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730433),('5','182','257758','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730434),('5','182','257759','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730435),('5','182','257759','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','182','257759','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730437),('5','182','257760','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730438),('5','182','257760','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730439),('5','182','257760','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','182','257761','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730441),('5','182','257761','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','182','257761','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730443),('5','182','257762','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730444),('5','182','257762','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730445),('5','182','257762','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730446),('5','182','257763','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730447),('5','182','257763','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730448),('5','182','257763','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','182','257764','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730450),('5','182','257764','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730451),('5','182','257764','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730452),('5','182','257765','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730453),('5','182','257765','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730454),('5','182','257765','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730455),('5','182','257766','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730456),('5','182','257766','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730457),('5','182','257766','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730458),('5','182','257767','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730459),('5','182','257767','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730460),('5','182','257767','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730461),('5','182','257768','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730462),('5','182','257768','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','182','257768','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730464),('5','182','257769','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730465),('5','182','257769','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730466),('5','182','257769','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','182','257770','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730468),('5','182','257770','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730469),('5','182','257770','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730470),('5','182','257771','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730471),('5','182','257771','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','182','257771','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730473),('5','182','257772','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730474),('5','182','257772','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','182','257772','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730476),('5','182','257773','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730477),('5','182','257773','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730478),('5','182','257773','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730479),('5','182','257774','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730480),('5','182','257774','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730481),('5','182','257774','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','182','257775','427',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730483),('5','182','257775','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730484),('5','182','257775','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730485),('5','182','257776','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730486),('5','182','257776','427',800.00,870.00,0.00,0.00,0.00,0.00,0.00,730487),('5','182','257776','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730488),('5','182','257777','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730489),('5','182','257777','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730490),('5','182','257777','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730491),('5','182','257778','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730492),('5','182','257778','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730493),('5','182','257778','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730494),('5','182','257779','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730495),('5','182','257779','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730496),('5','182','257779','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730497),('5','182','257780','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730498),('5','182','257780','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730499),('5','182','257780','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730500),('5','182','257781','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730501),('5','182','257781','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730502),('5','182','257781','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730503),('5','182','257782','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730504),('5','182','257782','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730505),('5','182','257782','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730506),('5','182','257783','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730507),('5','182','257783','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730508),('5','182','257783','426',185.00,185.00,3024.71,0.00,0.00,0.00,0.00,730509),('5','182','257784','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730510),('5','182','257784','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730511),('5','182','257784','426',185.00,185.00,5172.45,0.00,0.00,0.00,0.00,730512),('5','182','257785','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730513),('5','182','257785','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','182','257785','426',185.00,185.00,4737.83,0.00,0.00,0.00,0.00,730515),('5','182','257786','426',185.00,185.00,2099.98,0.00,0.00,0.00,0.00,730516),('5','182','257786','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730517),('5','182','257786','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730518),('5','182','257787','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730519),('5','182','257787','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730520),('5','182','257787','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730521),('5','182','257788','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730522),('5','182','257788','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730523),('5','182','257788','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730524),('5','182','257789','426',185.00,185.00,3539.96,0.00,0.00,0.00,0.00,730525),('5','182','257789','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730526),('5','182','257789','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730527),('5','182','257790','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730528),('5','182','257790','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730529),('5','182','257790','426',185.00,185.00,4770.35,0.00,0.00,0.00,0.00,730530),('5','182','257791','426',185.00,185.00,4366.67,0.00,0.00,0.00,0.00,730531),('5','182','257791','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730532),('5','182','257791','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730533),('5','182','257792','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730534),('5','182','257792','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730535),('5','182','257792','426',185.00,185.00,2860.45,0.00,0.00,0.00,0.00,730536),('5','182','257793','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730537),('5','182','257793','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730538),('5','182','257793','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730539),('5','182','257794','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730540),('5','182','257794','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730541),('5','182','257794','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730542),('5','182','257795','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730543),('5','182','257795','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730544),('5','182','257795','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730545),('5','182','257796','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730546),('5','182','257796','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730547),('5','182','257796','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730548),('5','182','257797','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730549),('5','182','257797','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730550),('5','182','257797','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730551),('5','182','257798','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730552),('5','182','257798','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730553),('5','182','257798','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730554),('5','182','257799','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730555),('5','182','257799','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730556),('5','182','257799','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730557),('5','182','257800','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730558),('5','182','257800','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730559),('5','182','257800','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730560),('5','182','257801','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','182','257801','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730562),('5','182','257801','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730563),('5','182','257802','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730564),('5','182','257802','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730565),('5','182','257802','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730566),('5','182','257803','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730567),('5','182','257803','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730568),('5','182','257803','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730569),('5','182','257804','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730570),('5','182','257804','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730571),('5','182','257804','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730572),('5','182','257805','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730573),('5','182','257805','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730574),('5','182','257805','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730575),('5','182','257806','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730576),('5','182','257806','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730577),('5','182','257806','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730578),('5','182','257807','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730579),('5','182','257807','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730580),('5','182','257807','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730581),('5','182','257808','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730582),('5','182','257808','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','182','257808','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730584),('5','182','257809','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730585),('5','182','257809','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730586),('5','182','257809','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730587),('5','182','257810','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730588),('5','182','257810','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','182','257810','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730590),('5','182','257811','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730591),('5','182','257811','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730592),('5','182','257811','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730593),('5','182','257812','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730594),('5','182','257812','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730595),('5','182','257812','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730596),('5','182','257813','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730597),('5','182','257813','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730598),('5','182','257813','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730599),('5','182','257814','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730600),('5','182','257814','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730601),('5','182','257814','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730602),('5','182','257815','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730603),('5','182','257815','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730604),('5','182','257815','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730605),('5','182','257816','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730606),('5','182','257816','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730607),('5','182','257816','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730608),('5','182','257817','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730609),('5','182','257817','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730610),('5','182','257817','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730611),('5','182','257818','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730612),('5','182','257818','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','182','257818','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730614),('5','182','257819','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730615),('5','182','257819','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730616),('5','182','257819','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730617),('5','182','257820','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730618),('5','182','257820','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730619),('5','182','257820','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730620),('5','182','257821','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730621),('5','182','257821','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','182','257821','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730623),('5','182','257822','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730624),('5','182','257822','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','182','257822','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730626),('5','182','257823','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730627),('5','182','257823','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730628),('5','182','257823','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730629),('5','182','257824','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730630),('5','182','257824','427',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730631),('5','182','257824','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','182','257825','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730633),('5','182','257825','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730634),('5','182','257825','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730635),('5','182','257826','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730636),('5','182','257826','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730637),('5','182','257826','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730638),('5','182','257827','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730639),('5','182','257827','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730640),('5','182','257827','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730641),('5','182','257828','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730642),('5','182','257828','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730643),('5','182','257828','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730644),('5','182','257829','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730645),('5','182','257829','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730646),('5','182','257829','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730647),('5','182','257830','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730648),('5','182','257830','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730649),('5','182','257830','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730650),('5','182','257831','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730651),('5','182','257831','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730652),('5','182','257831','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730653),('5','182','257832','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730654),('5','182','257832','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730655),('5','182','257832','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730656),('5','182','257833','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730657),('5','182','257833','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730658),('5','182','257833','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730659),('5','182','257834','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730660),('5','182','257834','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730661),('5','182','257834','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730662),('5','182','257835','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730663),('5','182','257835','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730664),('5','182','257835','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730665),('5','182','257836','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730666),('5','182','257836','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730667),('5','182','257836','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730668),('5','182','257837','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730669),('5','182','257837','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730670),('5','182','257837','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730671),('5','182','257838','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730672),('5','182','257838','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730673),('5','182','257838','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730674),('5','182','257839','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730675),('5','182','257839','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730676),('5','182','257839','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730677),('5','182','257840','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730678),('5','182','257840','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730679),('5','182','257840','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730680),('5','182','257841','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730681),('5','182','257841','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730682),('5','182','257841','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730683),('5','182','257842','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730684),('5','182','257842','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730685),('5','182','257842','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730686),('5','182','257843','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730687),('5','182','257843','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730688),('5','182','257843','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730689),('5','182','257844','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730690),('5','182','257844','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730691),('5','182','257844','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730692),('5','182','257845','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730693),('5','182','257845','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730694),('5','182','257845','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730695),('5','182','257846','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730696),('5','182','257846','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730697),('5','182','257846','426',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730698),('5','182','257847','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730699),('5','182','257847','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730700),('5','182','257847','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730701),('5','182','257848','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730702),('5','182','257848','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730703),('5','182','257848','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730704),('5','182','257849','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730705),('5','182','257849','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730706),('5','182','257849','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730707),('5','182','257850','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730708),('5','182','257850','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730709),('5','182','257850','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730710),('5','182','257851','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730711),('5','182','257851','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730712),('5','182','257851','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730713),('5','182','257852','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730714),('5','182','257852','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730715),('5','182','257852','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730716),('5','182','257853','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730717),('5','182','257853','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730718),('5','182','257853','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730719),('5','182','257854','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730720),('5','182','257854','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730721),('5','182','257854','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730722),('5','182','257855','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730723),('5','182','257855','427',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730724),('5','182','257855','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730725),('5','182','257856','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730726),('5','182','257856','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730727),('5','182','257856','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','182','257857','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730729),('5','182','257857','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730730),('5','182','257857','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730731),('5','182','257858','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730732),('5','182','257858','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730733),('5','182','257858','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730734),('5','182','257859','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730735),('5','182','257859','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730736),('5','182','257859','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730737),('5','182','257860','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730738),('5','182','257860','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730739),('5','182','257860','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730740),('5','182','257861','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730741),('5','182','257861','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730742),('5','182','257861','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730743),('5','182','257862','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730744),('5','182','257862','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730745),('5','182','257862','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730746),('5','182','257863','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730747),('5','182','257863','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730748),('5','182','257863','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730749),('5','182','257864','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730750),('5','182','257864','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730751),('5','182','257864','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730752),('5','182','257865','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730753),('5','182','257865','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730754),('5','182','257865','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730755),('5','182','257866','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730756),('5','182','257866','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730757),('5','182','257866','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730758),('5','182','257867','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730759),('5','182','257867','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730760),('5','182','257867','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730761),('5','182','257868','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730762),('5','182','257868','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730763),('5','182','257868','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730764),('5','182','257869','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730765),('5','182','257869','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730766),('5','182','257869','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730767),('5','182','257870','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730768),('5','182','257870','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730769),('5','182','257870','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730770),('5','182','257871','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730771),('5','182','257871','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730772),('5','182','257871','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730773),('5','182','257872','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730774),('5','182','257872','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730775),('5','182','257872','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730776),('5','182','257873','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730777),('5','182','257873','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730778),('5','182','257873','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730779),('5','182','257874','427',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730780),('5','182','257874','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730781),('5','182','257874','426',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730782),('5','182','257875','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730783),('5','182','257875','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730784),('5','182','257875','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730785),('5','182','257876','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730786),('5','182','257876','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730787),('5','182','257876','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730788),('5','182','257877','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730789),('5','182','257877','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730790),('5','182','257877','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730791),('5','182','257878','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730792),('5','182','257878','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730793),('5','182','257878','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730794),('5','182','257879','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730795),('5','182','257879','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730796),('5','182','257879','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730797),('5','182','257880','427',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730798),('5','182','257880','428',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730799),('5','182','257880','426',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730800);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=392 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',391,'182','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=957 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','182','391',953,0,'426','PMS TANK 1',40000.00,1.00,15955.89,'TANK CONTAINING PETROLEUM.','576','2021-07-15 06:50:49','2021-07-15 06:50:49','576',5,1),('5','182','391',954,0,'426','PMS TANK 2',40000.00,1.00,7193.36,'PMS DISPENSER','576','2021-07-15 06:52:30','2021-07-15 06:52:30','576',5,1),('5','182','391',955,0,'427','AGO TANK',40000.00,1.00,29779.77,'TANKS CONTAINING DIESEL.','576','2021-07-15 06:54:49','2021-07-15 06:54:49','576',5,1),('5','182','391',956,0,'428','DPK TANK',40000.00,1.00,0.00,'TANKS CONTAINING KEROSENE.','576','2021-07-15 06:55:58','2021-07-15 06:55:58','576',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','182',956,0.00,'2023-03-06 22:04:50'),(2,'5','182',955,349.21,'2023-03-06 22:04:50'),(3,'5','182',954,233.39,'2023-03-06 22:04:50'),(4,'5','182',953,943.69,'2023-03-06 22:04:50');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614614 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2287514,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2442000.00,14800.00,0.00,0.00,'2021-12-15 09:04:19','',''),(2288587,'5','182',NULL,426,'Reception corrector for bridging 127463',0.00,0.00,0.00,14800.00,0.00,'2021-12-15 11:12:37','',''),(2288588,'5','182','953',426,'Received from bridging 127463',0.00,0.00,14800.00,0.00,0.00,'2021-12-15 11:12:37','',''),(2294799,'5','182','953',426,'Sale Id shift 246273',0.00,0.00,0.00,649.76,0.00,'2021-12-16 08:39:04','',''),(2294800,'5','182','953',426,'Sale Id shift 246273',0.00,0.00,0.00,766.87,0.00,'2021-12-16 08:39:04','',''),(2294801,'5','182',NULL,426,'Sale Id shift 246273',233743.95,0.00,0.00,0.00,0.00,'2021-12-16 08:39:04','',''),(2303144,'5','182','953',426,'Sale Id shift 246529',0.00,0.00,0.00,1695.08,0.00,'2021-12-17 09:10:34','',''),(2303145,'5','182','953',426,'Sale Id shift 246529',0.00,0.00,0.00,1418.64,0.00,'2021-12-17 09:10:34','',''),(2303146,'5','182','955',427,'Sale Id shift 246529',0.00,0.00,0.00,48.12,0.00,'2021-12-17 09:10:34','',''),(2303147,'5','182',NULL,426,'Sale Id shift 246529',513763.80,0.00,0.00,0.00,0.00,'2021-12-17 09:10:34','',''),(2303148,'5','182',NULL,427,'Sale Id shift 246529',14436.00,0.00,0.00,0.00,0.00,'2021-12-17 09:10:34','',''),(2309377,'5','182','953',426,'Sale Id shift 246776',0.00,0.00,0.00,1416.40,0.00,'2021-12-18 06:53:39','',''),(2309378,'5','182','953',426,'Sale Id shift 246776',0.00,0.00,0.00,1158.22,0.00,'2021-12-18 06:53:39','',''),(2309379,'5','182',NULL,426,'Sale Id shift 246776',424812.30,0.00,0.00,0.00,0.00,'2021-12-18 06:53:39','',''),(2325600,'5','182','953',426,'Sale Id shift 247117',0.00,0.00,0.00,1443.74,0.00,'2021-12-19 17:33:59','',''),(2325601,'5','182','953',426,'Sale Id shift 247117',0.00,0.00,0.00,1182.48,0.00,'2021-12-19 17:33:59','',''),(2325602,'5','182',NULL,426,'Sale Id shift 247117',433326.30,0.00,0.00,0.00,0.00,'2021-12-19 17:33:59','',''),(2326185,'5','182','953',426,'Sale Id shift 247354',0.00,0.00,0.00,1170.89,0.00,'2021-12-20 06:12:59','',''),(2326186,'5','182','953',426,'Sale Id shift 247354',0.00,0.00,0.00,1094.45,0.00,'2021-12-20 06:12:59','',''),(2326187,'5','182',NULL,426,'Sale Id shift 247354',373781.10,0.00,0.00,0.00,0.00,'2021-12-20 06:12:59','',''),(2332820,'5','182','953',426,'Sale Id shift 247408',0.00,0.00,0.00,1236.50,0.00,'2021-12-20 18:02:24','',''),(2332821,'5','182','953',426,'Sale Id shift 247408',0.00,0.00,0.00,947.07,0.00,'2021-12-20 18:02:24','',''),(2332822,'5','182',NULL,426,'Sale Id shift 247408',360289.05,0.00,0.00,0.00,0.00,'2021-12-20 18:02:24','',''),(2343878,'5','182','953',426,'Sale Id shift 247725',0.00,0.00,0.00,322.46,0.00,'2021-12-22 09:54:24','',''),(2343879,'5','182','953',426,'Sale Id shift 247725',0.00,0.00,0.00,280.33,0.00,'2021-12-22 09:54:24','',''),(2343880,'5','182',NULL,426,'Sale Id shift 247725',99460.35,0.00,0.00,0.00,0.00,'2021-12-22 09:54:24','',''),(2426568,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3737250.00,22650.00,0.00,0.00,'2022-01-03 06:58:16','',''),(2426762,'5','182',NULL,426,'Reception corrector for bridging 129528',0.00,0.00,0.00,22650.00,0.00,'2022-01-03 07:30:47','',''),(2426763,'5','182','953',426,'Received from bridging 129528',0.00,0.00,22650.00,0.00,0.00,'2022-01-03 07:30:47','',''),(2427862,'5','182','953',426,'Sale Id shift 250737',0.00,0.00,0.00,2062.73,0.00,'2022-01-03 09:34:39','',''),(2427863,'5','182','953',426,'Sale Id shift 250737',0.00,0.00,0.00,1798.79,0.00,'2022-01-03 09:34:39','',''),(2427864,'5','182',NULL,426,'Sale Id shift 250737',637150.80,0.00,0.00,0.00,0.00,'2022-01-03 09:34:39','',''),(2434224,'5','182','953',426,'Sale Id shift 250878',0.00,0.00,0.00,2138.17,0.00,'2022-01-04 08:41:21','',''),(2434225,'5','182','953',426,'Sale Id shift 250878',0.00,0.00,0.00,1465.38,0.00,'2022-01-04 08:41:21','',''),(2434226,'5','182',NULL,426,'Sale Id shift 250878',594585.75,0.00,0.00,0.00,0.00,'2022-01-04 08:41:21','',''),(2439929,'5','182','953',426,'Sale Id shift 251088',0.00,0.00,0.00,5297.98,0.00,'2022-01-04 19:02:24','',''),(2439930,'5','182','953',426,'Sale Id shift 251088',0.00,0.00,0.00,12.12,0.00,'2022-01-04 19:02:24','',''),(2439931,'5','182',NULL,426,'Sale Id shift 251088',876166.50,0.00,0.00,0.00,0.00,'2022-01-04 19:02:24','',''),(2449399,'5','182','953',426,'Sale Id shift 251370',0.00,0.00,0.00,3184.49,0.00,'2022-01-06 09:24:54','',''),(2449400,'5','182','953',426,'Sale Id shift 251370',0.00,0.00,0.00,258.96,0.00,'2022-01-06 09:24:54','',''),(2449401,'5','182',NULL,426,'Sale Id shift 251370',568169.25,0.00,0.00,0.00,0.00,'2022-01-06 09:24:54','',''),(2455864,'5','182','953',426,'Sale Id shift 251622',0.00,0.00,0.00,1618.66,0.00,'2022-01-07 07:02:29','',''),(2455865,'5','182','953',426,'Sale Id shift 251622',0.00,0.00,0.00,1556.00,0.00,'2022-01-07 07:02:29','',''),(2455866,'5','182',NULL,426,'Sale Id shift 251622',523818.90,0.00,0.00,0.00,0.00,'2022-01-07 07:02:29','',''),(2477088,'5','182','953',426,'Sale Id shift 251832',0.00,0.00,0.00,1682.48,0.00,'2022-01-09 15:50:52','',''),(2477089,'5','182','953',426,'Sale Id shift 251832',0.00,0.00,0.00,1521.51,0.00,'2022-01-09 15:50:52','',''),(2477090,'5','182',NULL,426,'Sale Id shift 251832',528658.35,0.00,0.00,0.00,0.00,'2022-01-09 15:50:52','',''),(2496135,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-01-12 10:35:28','',''),(2496214,'5','182',NULL,426,'Reception corrector for bridging 130574',0.00,0.00,0.00,30000.00,0.00,'2022-01-12 10:45:04','',''),(2496215,'5','182','953',426,'Received from bridging 130574',0.00,0.00,30000.00,0.00,0.00,'2022-01-12 10:45:04','',''),(2501350,'5','182','953',426,'Sale Id shift 252935',0.00,0.00,0.00,681.52,0.00,'2022-01-12 19:41:42','',''),(2501351,'5','182','953',426,'Sale Id shift 252935',0.00,0.00,0.00,510.81,0.00,'2022-01-12 19:41:42','',''),(2501352,'5','182',NULL,426,'Sale Id shift 252935',196734.45,0.00,0.00,0.00,0.00,'2022-01-12 19:41:42','',''),(2501722,'5','182','953',426,'Sale Id shift 253152',0.00,0.00,0.00,2199.21,0.00,'2022-01-13 07:30:46','',''),(2501723,'5','182','953',426,'Sale Id shift 253152',0.00,0.00,0.00,1644.95,0.00,'2022-01-13 07:30:46','',''),(2501724,'5','182',NULL,426,'Sale Id shift 253152',634286.40,0.00,0.00,0.00,0.00,'2022-01-13 07:30:46','',''),(2509253,'5','182','953',426,'Sale Id shift 253265',0.00,0.00,0.00,2984.34,0.00,'2022-01-14 06:37:36','',''),(2509254,'5','182','953',426,'Sale Id shift 253265',0.00,0.00,0.00,2798.35,0.00,'2022-01-14 06:37:36','',''),(2509255,'5','182',NULL,426,'Sale Id shift 253265',954143.85,0.00,0.00,0.00,0.00,'2022-01-14 06:37:36','',''),(2509438,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2269410.00,13754.00,0.00,0.00,'2022-01-14 07:36:33','',''),(2518344,'5','182',NULL,426,'Reception corrector for bridging 130821',0.00,0.00,0.00,13754.00,0.00,'2022-01-15 09:35:04','',''),(2518345,'5','182','954',426,'Received from bridging 130821',0.00,0.00,13754.00,0.00,0.00,'2022-01-15 09:35:04','',''),(2518586,'5','182','953',426,'Sale Id shift 253516',0.00,0.00,0.00,2125.13,0.00,'2022-01-15 09:58:13','',''),(2518587,'5','182','953',426,'Sale Id shift 253516',0.00,0.00,0.00,1307.44,0.00,'2022-01-15 09:58:13','',''),(2518588,'5','182','954',426,'Sale Id shift 253516',0.00,0.00,0.00,1599.41,0.00,'2022-01-15 09:58:13','',''),(2518589,'5','182',NULL,426,'Sale Id shift 253516',830276.70,0.00,0.00,0.00,0.00,'2022-01-15 09:58:13','',''),(2525754,'5','182','953',426,'Sale Id shift 253948',0.00,0.00,0.00,1727.62,0.00,'2022-01-16 06:54:11','',''),(2525755,'5','182','953',426,'Sale Id shift 253948',0.00,0.00,0.00,1544.67,0.00,'2022-01-16 06:54:11','',''),(2525756,'5','182','954',426,'Sale Id shift 253948',0.00,0.00,0.00,1335.45,0.00,'2022-01-16 06:54:11','',''),(2525757,'5','182',NULL,426,'Sale Id shift 253948',760277.10,0.00,0.00,0.00,0.00,'2022-01-16 06:54:11','',''),(2534128,'5','182','953',426,'Sale Id shift 253958',0.00,0.00,0.00,4129.49,0.00,'2022-01-17 07:09:26','',''),(2534129,'5','182','953',426,'Sale Id shift 253958',0.00,0.00,0.00,4050.41,0.00,'2022-01-17 07:09:26','',''),(2534130,'5','182',NULL,426,'Sale Id shift 253958',1349683.50,0.00,0.00,0.00,0.00,'2022-01-17 07:09:26','',''),(2541049,'5','182','953',426,'Sale Id shift 254281',0.00,0.00,0.00,2219.08,0.00,'2022-01-18 07:07:22','',''),(2541050,'5','182','953',426,'Sale Id shift 254281',0.00,0.00,0.00,1380.81,0.00,'2022-01-18 07:07:22','',''),(2541051,'5','182','954',426,'Sale Id shift 254281',0.00,0.00,0.00,2255.55,0.00,'2022-01-18 07:07:22','',''),(2541052,'5','182',NULL,426,'Sale Id shift 254281',966147.60,0.00,0.00,0.00,0.00,'2022-01-18 07:07:22','',''),(2548266,'5','182','953',426,'Sale Id shift 254481',0.00,0.00,0.00,840.02,0.00,'2022-01-19 06:04:20','',''),(2548267,'5','182','954',426,'Sale Id shift 254481',0.00,0.00,0.00,2556.88,0.00,'2022-01-19 06:04:20','',''),(2548268,'5','182',NULL,426,'Sale Id shift 254481',560488.50,0.00,0.00,0.00,0.00,'2022-01-19 06:04:20','',''),(2556047,'5','182','954',426,'Sale Id shift 254717',0.00,0.00,0.00,1523.14,0.00,'2022-01-20 06:34:28','',''),(2556048,'5','182','954',426,'Sale Id shift 254717',0.00,0.00,0.00,3212.20,0.00,'2022-01-20 06:34:28','',''),(2556049,'5','182',NULL,426,'Sale Id shift 254717',781331.10,0.00,0.00,0.00,0.00,'2022-01-20 06:34:28','',''),(2567067,'5','182','954',426,'Sale Id shift 254947',0.00,0.00,0.00,608.47,0.00,'2022-01-21 11:16:06','',''),(2567068,'5','182','954',426,'Sale Id shift 254947',0.00,0.00,0.00,345.13,0.00,'2022-01-21 11:16:06','',''),(2567069,'5','182',NULL,426,'Sale Id shift 254947',157344.00,0.00,0.00,0.00,0.00,'2022-01-21 11:16:06','',''),(2612868,'5','182',NULL,427,'Balance from closing inventory values 2021-11-31 23:59:59',5790801.00,5910000.00,39400.00,39002.67,0.00,'2021-11-30 23:59:59','',''),(2612906,'5','182',NULL,426,'Balance from closing inventory values 2021-11-31 23:59:59',25195679.14,33026400.00,353150.00,305688.26,0.00,'2021-11-30 23:59:59','',''),(2613013,'5','182',NULL,428,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613287,'5','182','956',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613459,'5','182','953',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,63150.00,62368.12,0.00,'2021-11-30 23:59:59','',''),(2613828,'5','182','955',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,19700.00,19302.67,0.00,'2021-11-30 23:59:59','',''),(2614016,'5','182','954',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,100137.00,99222.27,0.00,'2021-11-30 23:59:59','',''),(2614017,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-02-08 07:20:29','',''),(2614018,'5','182',NULL,426,'Reception corrector for bridging 130822',0.00,0.00,0.00,16000.00,0.00,'2022-02-08 09:24:34','',''),(2614019,'5','182','953',426,'Received from bridging 130822',0.00,0.00,16000.00,0.00,0.00,'2022-02-08 09:24:34','',''),(2614020,'5','182','953',426,'Sale Id shift 257494',0.00,0.00,0.00,876.06,0.00,'2022-02-08 10:01:53','',''),(2614021,'5','182','953',426,'Sale Id shift 257494',0.00,0.00,0.00,670.93,0.00,'2022-02-08 10:01:53','',''),(2614022,'5','182','954',426,'Sale Id shift 257494',0.00,0.00,0.00,431.60,0.00,'2022-02-08 10:01:53','',''),(2614023,'5','182',NULL,426,'Sale Id shift 257494',326467.35,0.00,0.00,0.00,0.00,'2022-02-08 10:01:53','',''),(2614024,'5','182','953',426,'Sale Id shift 257495',0.00,0.00,0.00,2380.15,0.00,'2022-02-08 10:06:26','',''),(2614025,'5','182','953',426,'Sale Id shift 257495',0.00,0.00,0.00,2187.26,0.00,'2022-02-08 10:06:26','',''),(2614026,'5','182',NULL,426,'Sale Id shift 257495',753622.65,0.00,0.00,0.00,0.00,'2022-02-08 10:06:26','',''),(2614027,'5','182','953',426,'Sale Id shift 257496',0.00,0.00,0.00,862.49,0.00,'2022-02-08 10:09:52','',''),(2614028,'5','182','953',426,'Sale Id shift 257496',0.00,0.00,0.00,3199.20,0.00,'2022-02-08 10:09:52','',''),(2614029,'5','182',NULL,426,'Sale Id shift 257496',670178.85,0.00,0.00,0.00,0.00,'2022-02-08 10:09:52','',''),(2614030,'5','182','953',426,'Sale Id shift 257497',0.00,0.00,0.00,2705.11,0.00,'2022-02-08 10:12:23','',''),(2614031,'5','182','953',426,'Sale Id shift 257497',0.00,0.00,0.00,1359.45,0.00,'2022-02-08 10:12:23','',''),(2614032,'5','182',NULL,426,'Sale Id shift 257497',670652.40,0.00,0.00,0.00,0.00,'2022-02-08 10:12:23','',''),(2614033,'5','182','953',426,'Sale Id shift 257498',0.00,0.00,0.00,1342.15,0.00,'2022-02-08 21:59:17','',''),(2614034,'5','182',NULL,426,'Sale Id shift 257498',221454.75,0.00,0.00,0.00,0.00,'2022-02-08 21:59:17','',''),(2614035,'5','182','953',426,'Sale Id shift 257501',0.00,0.00,0.00,499.60,0.00,'2022-02-11 22:46:58','',''),(2614036,'5','182','953',426,'Sale Id shift 257501',0.00,0.00,0.00,591.00,0.00,'2022-02-11 22:46:58','',''),(2614037,'5','182',NULL,426,'Sale Id shift 257501',179949.00,0.00,0.00,0.00,0.00,'2022-02-11 22:46:58','',''),(2614038,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3712500.00,22500.00,0.00,0.00,'2022-02-12 07:00:13','',''),(2614039,'5','182',NULL,426,'Reception corrector for bridging 130823',0.00,0.00,0.00,22500.00,0.00,'2022-02-12 08:22:14','',''),(2614040,'5','182','953',426,'Received from bridging 130823',0.00,0.00,22500.00,0.00,0.00,'2022-02-12 08:22:14','',''),(2614041,'5','182','953',426,'Sale Id shift 257502',0.00,0.00,0.00,3008.50,0.00,'2022-02-13 08:48:51','',''),(2614042,'5','182','953',426,'Sale Id shift 257502',0.00,0.00,0.00,2002.89,0.00,'2022-02-13 08:48:51','',''),(2614043,'5','182',NULL,426,'Sale Id shift 257502',826879.35,0.00,0.00,0.00,0.00,'2022-02-13 08:48:51','',''),(2614044,'5','182','953',426,'Sale Id shift 257503',0.00,0.00,0.00,3000.12,0.00,'2022-02-14 06:10:49','',''),(2614045,'5','182','953',426,'Sale Id shift 257503',0.00,0.00,0.00,2099.25,0.00,'2022-02-14 06:10:49','',''),(2614046,'5','182',NULL,426,'Sale Id shift 257503',841396.05,0.00,0.00,0.00,0.00,'2022-02-14 06:10:49','',''),(2614047,'5','182','953',426,'Sale Id shift 257504',0.00,0.00,0.00,102.15,0.00,'2022-02-14 23:50:14','',''),(2614048,'5','182','953',426,'Sale Id shift 257504',0.00,0.00,0.00,5160.16,0.00,'2022-02-14 23:50:14','',''),(2614049,'5','182',NULL,426,'Sale Id shift 257504',868281.15,0.00,0.00,0.00,0.00,'2022-02-14 23:50:14','',''),(2614050,'5','182','953',426,'Sale Id shift 257505',0.00,0.00,0.00,5082.70,0.00,'2022-02-16 07:59:57','',''),(2614051,'5','182',NULL,426,'Sale Id shift 257505',838645.50,0.00,0.00,0.00,0.00,'2022-02-16 07:59:57','',''),(2614052,'5','182','953',426,'Sale Id shift 257506',0.00,0.00,0.00,654.50,0.00,'2022-02-17 09:27:14','',''),(2614053,'5','182',NULL,426,'Sale Id shift 257506',107992.50,0.00,0.00,0.00,0.00,'2022-02-17 09:27:14','',''),(2614054,'5','182','953',426,'Sale Id shift 257511',0.00,0.00,0.00,450.00,0.00,'2022-02-22 06:56:12','',''),(2614055,'5','182','953',426,'Sale Id shift 257511',0.00,0.00,0.00,449.50,0.00,'2022-02-22 06:56:12','',''),(2614056,'5','182',NULL,426,'Sale Id shift 257511',148417.50,0.00,0.00,0.00,0.00,'2022-02-22 06:56:12','',''),(2614057,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4917000.00,29800.00,0.00,0.00,'2022-02-22 07:48:12','',''),(2614058,'5','182',NULL,426,'Reception corrector for bridging 130824',0.00,0.00,0.00,29800.00,0.00,'2022-02-22 09:04:05','',''),(2614059,'5','182','953',426,'Received from bridging 130824',0.00,0.00,29800.00,0.00,0.00,'2022-02-22 09:04:05','',''),(2614060,'5','182','953',426,'Sale Id shift 257512',0.00,0.00,0.00,7334.89,0.00,'2022-02-23 07:14:01','',''),(2614061,'5','182','953',426,'Sale Id shift 257512',0.00,0.00,0.00,1298.05,0.00,'2022-02-23 07:14:01','',''),(2614062,'5','182',NULL,426,'Sale Id shift 257512',1424435.10,0.00,0.00,0.00,0.00,'2022-02-23 07:14:01','',''),(2614063,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2145000.00,13000.00,0.00,0.00,'2022-02-23 12:35:11','',''),(2614064,'5','182',NULL,426,'Reception corrector for bridging 130825',0.00,0.00,0.00,13000.00,0.00,'2022-02-23 18:24:56','',''),(2614065,'5','182','954',426,'Received from bridging 130825',0.00,0.00,13000.00,0.00,0.00,'2022-02-23 18:24:56','',''),(2614066,'5','182','953',426,'Sale Id shift 257513',0.00,0.00,0.00,200.85,0.00,'2022-02-24 07:59:49','',''),(2614067,'5','182','953',426,'Sale Id shift 257513',0.00,0.00,0.00,5356.42,0.00,'2022-02-24 07:59:49','',''),(2614068,'5','182','954',426,'Sale Id shift 257513',0.00,0.00,0.00,3003.16,0.00,'2022-02-24 07:59:49','',''),(2614069,'5','182',NULL,426,'Sale Id shift 257513',1412470.95,0.00,0.00,0.00,0.00,'2022-02-24 07:59:49','',''),(2614070,'5','182','954',426,'Sale Id shift 257514',0.00,0.00,0.00,1811.00,0.00,'2022-02-25 06:49:07','',''),(2614071,'5','182','954',426,'Sale Id shift 257514',0.00,0.00,0.00,7284.79,0.00,'2022-02-25 06:49:07','',''),(2614072,'5','182',NULL,426,'Sale Id shift 257514',1500805.35,0.00,0.00,0.00,0.00,'2022-02-25 06:49:07','',''),(2614073,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-02-25 15:01:59','',''),(2614074,'5','182',NULL,426,'Reception corrector for bridging 130826',0.00,0.00,0.00,13500.00,0.00,'2022-02-25 16:50:56','',''),(2614075,'5','182','953',426,'Received from bridging 130826',0.00,0.00,13500.00,0.00,0.00,'2022-02-25 16:50:56','',''),(2614076,'5','182','953',426,'Sale Id shift 257515',0.00,0.00,0.00,4236.00,0.00,'2022-02-26 07:19:06','',''),(2614077,'5','182','953',426,'Sale Id shift 257515',0.00,0.00,0.00,2144.52,0.00,'2022-02-26 07:19:06','',''),(2614078,'5','182',NULL,426,'Sale Id shift 257515',1052785.80,0.00,0.00,0.00,0.00,'2022-02-26 07:19:06','',''),(2614079,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-26 21:50:51','',''),(2614080,'5','182',NULL,426,'Reception corrector for bridging 130828',0.00,0.00,0.00,13500.00,0.00,'2022-02-27 09:09:52','',''),(2614081,'5','182','954',426,'Received from bridging 130828',0.00,0.00,13500.00,0.00,0.00,'2022-02-27 09:09:52','',''),(2614082,'5','182','953',426,'Sale Id shift 257516',0.00,0.00,0.00,9446.30,0.00,'2022-02-27 09:17:09','',''),(2614083,'5','182','953',426,'Sale Id shift 257516',0.00,0.00,0.00,9005.25,0.00,'2022-02-27 09:17:09','',''),(2614084,'5','182',NULL,426,'Sale Id shift 257516',3044505.75,0.00,0.00,0.00,0.00,'2022-02-27 09:17:09','',''),(2614085,'5','182',NULL,426,'Reception corrector for bridging 130827',0.00,0.00,0.00,26500.00,0.00,'2022-02-27 13:41:38','',''),(2614086,'5','182','953',426,'Received from bridging 130827',0.00,0.00,26500.00,0.00,0.00,'2022-02-27 13:41:38','',''),(2614087,'5','182','953',426,'Sale Id shift 257517',0.00,0.00,0.00,4562.25,0.00,'2022-02-27 23:59:59','',''),(2614088,'5','182','953',426,'Sale Id shift 257517',0.00,0.00,0.00,5502.25,0.00,'2022-02-27 23:59:59','',''),(2614089,'5','182',NULL,426,'Sale Id shift 257517',1660642.50,0.00,0.00,0.00,0.00,'2022-02-27 23:59:59','',''),(2614090,'5','182','953',426,'Sale Id shift 257518',0.00,0.00,0.00,659.75,0.00,'2022-02-28 21:38:47','',''),(2614091,'5','182','953',426,'Sale Id shift 257518',0.00,0.00,0.00,6233.90,0.00,'2022-02-28 21:38:47','',''),(2614092,'5','182','954',426,'Sale Id shift 257518',0.00,0.00,0.00,969.88,0.00,'2022-02-28 21:38:47','',''),(2614093,'5','182',NULL,426,'Sale Id shift 257518',1297482.45,0.00,0.00,0.00,0.00,'2022-02-28 21:38:47','',''),(2614094,'5','182','953',0,'Tank level zero out for dipping',0.00,0.00,0.00,14344.27,0.00,'2022-03-02 15:04:01','',''),(2614095,'5','182','953',0,'Inventory adjustment from tank dipping to 15000',0.00,0.00,15000.00,0.00,0.00,'2022-03-02 15:04:01','',''),(2614096,'5','182','953',426,'Sale Id shift 257519',0.00,0.00,0.00,6240.84,0.00,'2022-03-02 15:14:04','',''),(2614097,'5','182','953',426,'Sale Id shift 257519',0.00,0.00,0.00,8292.76,0.00,'2022-03-02 15:14:04','',''),(2614098,'5','182','954',426,'Sale Id shift 257519',0.00,0.00,0.00,372.33,0.00,'2022-03-02 15:14:04','',''),(2614099,'5','182','954',426,'Sale Id shift 257519',0.00,0.00,0.00,610.48,0.00,'2022-03-02 15:14:04','',''),(2614100,'5','182',NULL,426,'Sale Id shift 257519',2560207.65,0.00,0.00,0.00,0.00,'2022-03-02 15:14:04','',''),(2614101,'5','182','954',426,'Sale Id shift 257520',0.00,0.00,0.00,3250.20,0.00,'2022-03-02 22:25:01','',''),(2614102,'5','182','954',426,'Sale Id shift 257520',0.00,0.00,0.00,2602.20,0.00,'2022-03-02 22:25:01','',''),(2614103,'5','182',NULL,426,'Sale Id shift 257520',965646.00,0.00,0.00,0.00,0.00,'2022-03-02 22:25:01','',''),(2614104,'5','182','954',426,'Sale Id shift 257521',0.00,0.00,0.00,128.34,0.00,'2022-03-04 08:21:59','',''),(2614105,'5','182','954',426,'Sale Id shift 257521',0.00,0.00,0.00,4736.45,0.00,'2022-03-04 08:21:59','',''),(2614106,'5','182',NULL,426,'Sale Id shift 257521',802690.35,0.00,0.00,0.00,0.00,'2022-03-04 08:21:59','',''),(2614107,'5','182','954',426,'Sale Id shift 257522',0.00,0.00,0.00,1112.05,0.00,'2022-03-05 06:51:43','',''),(2614108,'5','182',NULL,426,'Sale Id shift 257522',183488.25,0.00,0.00,0.00,0.00,'2022-03-05 06:51:43','',''),(2614109,'5','182','954',426,'Sale Id shift 257536',0.00,0.00,0.00,750.00,0.00,'2022-03-19 07:08:54','',''),(2614110,'5','182',NULL,426,'Sale Id shift 257536',123750.00,0.00,0.00,0.00,0.00,'2022-03-19 07:08:54','',''),(2614111,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-03-19 15:09:20','',''),(2614112,'5','182',NULL,426,'Reception corrector for bridging 130829',0.00,0.00,0.00,13500.00,0.00,'2022-03-19 15:16:52','',''),(2614113,'5','182','953',426,'Received from bridging 130829',0.00,0.00,13500.00,0.00,0.00,'2022-03-19 15:16:52','',''),(2614114,'5','182','953',426,'Sale Id shift 257537',0.00,0.00,0.00,3499.33,0.00,'2022-03-20 08:39:44','',''),(2614115,'5','182','953',426,'Sale Id shift 257537',0.00,0.00,0.00,620.99,0.00,'2022-03-20 08:39:44','',''),(2614116,'5','182',NULL,426,'Sale Id shift 257537',679852.80,0.00,0.00,0.00,0.00,'2022-03-20 08:39:44','',''),(2614117,'5','182','953',426,'Sale Id shift 257538',0.00,0.00,0.00,2264.20,0.00,'2022-03-21 07:08:14','',''),(2614118,'5','182','953',426,'Sale Id shift 257538',0.00,0.00,0.00,802.00,0.00,'2022-03-21 07:08:14','',''),(2614119,'5','182',NULL,426,'Sale Id shift 257538',505923.00,0.00,0.00,0.00,0.00,'2022-03-21 07:08:14','',''),(2614120,'5','182','953',426,'Sale Id shift 257539',0.00,0.00,0.00,4102.00,0.00,'2022-03-22 07:33:18','',''),(2614121,'5','182',NULL,426,'Sale Id shift 257539',676830.00,0.00,0.00,0.00,0.00,'2022-03-22 07:33:18','',''),(2614122,'5','182','953',426,'Sale Id shift 257540',0.00,0.00,0.00,70.17,0.00,'2022-03-23 07:55:42','',''),(2614123,'5','182','953',426,'Sale Id shift 257540',0.00,0.00,0.00,1427.32,0.00,'2022-03-23 07:55:42','',''),(2614124,'5','182',NULL,426,'Sale Id shift 257540',247085.85,0.00,0.00,0.00,0.00,'2022-03-23 07:55:42','',''),(2614125,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2805000.00,17000.00,0.00,0.00,'2022-03-24 21:16:33','',''),(2614126,'5','182','953',426,'Sale Id shift 257542',0.00,0.00,0.00,704.91,0.00,'2022-03-25 06:46:51','',''),(2614127,'5','182',NULL,426,'Sale Id shift 257542',116310.15,0.00,0.00,0.00,0.00,'2022-03-25 06:46:51','',''),(2614128,'5','182',NULL,426,'Reception corrector for bridging 130830',0.00,0.00,0.00,17000.00,0.00,'2022-03-25 11:10:17','',''),(2614129,'5','182','953',426,'Received from bridging 130830',0.00,0.00,17000.00,0.00,0.00,'2022-03-25 11:10:17','',''),(2614130,'5','182','953',426,'Sale Id shift 257543',0.00,0.00,0.00,2593.08,0.00,'2022-03-26 04:56:35','',''),(2614131,'5','182','953',426,'Sale Id shift 257543',0.00,0.00,0.00,2899.98,0.00,'2022-03-26 04:56:35','',''),(2614132,'5','182',NULL,426,'Sale Id shift 257543',906354.90,0.00,0.00,0.00,0.00,'2022-03-26 04:56:35','',''),(2614133,'5','182','953',426,'Sale Id shift 257544',0.00,0.00,0.00,1501.09,0.00,'2022-03-27 07:57:42','',''),(2614134,'5','182','953',426,'Sale Id shift 257544',0.00,0.00,0.00,5787.05,0.00,'2022-03-27 07:57:42','',''),(2614135,'5','182',NULL,426,'Sale Id shift 257544',1202543.10,0.00,0.00,0.00,0.00,'2022-03-27 07:57:42','',''),(2614136,'5','182','953',426,'Sale Id shift 257545',0.00,0.00,0.00,2107.05,0.00,'2022-03-28 08:27:29','',''),(2614137,'5','182','953',426,'Sale Id shift 257545',0.00,0.00,0.00,1739.48,0.00,'2022-03-28 08:27:29','',''),(2614138,'5','182',NULL,426,'Sale Id shift 257545',634677.45,0.00,0.00,0.00,0.00,'2022-03-28 08:27:29','',''),(2614139,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2310000.00,14000.00,0.00,0.00,'2022-04-19 16:28:02','',''),(2614140,'5','182',NULL,426,'Reception corrector for bridging 130831',0.00,0.00,0.00,14000.00,0.00,'2022-04-19 18:22:44','',''),(2614141,'5','182','953',426,'Received from bridging 130831',0.00,0.00,14000.00,0.00,0.00,'2022-04-19 18:22:44','',''),(2614142,'5','182','953',426,'Sale Id shift 257568',0.00,0.00,0.00,2614.70,0.00,'2022-04-20 04:52:10','',''),(2614143,'5','182','953',426,'Sale Id shift 257568',0.00,0.00,0.00,1962.14,0.00,'2022-04-20 04:52:10','',''),(2614144,'5','182',NULL,426,'Sale Id shift 257568',755178.60,0.00,0.00,0.00,0.00,'2022-04-20 04:52:10','',''),(2614145,'5','182','953',426,'Sale Id shift 257569',0.00,0.00,0.00,4193.44,0.00,'2022-04-21 04:26:27','',''),(2614146,'5','182','953',426,'Sale Id shift 257569',0.00,0.00,0.00,3640.28,0.00,'2022-04-21 04:26:27','',''),(2614147,'5','182',NULL,426,'Sale Id shift 257569',1292563.80,0.00,0.00,0.00,0.00,'2022-04-21 04:26:27','',''),(2614148,'5','182','953',426,'Sale Id shift 257570',0.00,0.00,0.00,692.21,0.00,'2022-04-22 06:11:19','',''),(2614149,'5','182','953',426,'Sale Id shift 257570',0.00,0.00,0.00,1070.59,0.00,'2022-04-22 06:11:19','',''),(2614150,'5','182',NULL,426,'Sale Id shift 257570',290862.00,0.00,0.00,0.00,0.00,'2022-04-22 06:11:19','',''),(2614151,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3960000.00,24000.00,0.00,0.00,'2022-04-22 22:28:43','',''),(2614152,'5','182',NULL,426,'Reception corrector for bridging 130832',0.00,0.00,0.00,24000.00,0.00,'2022-04-23 07:21:06','',''),(2614153,'5','182','953',426,'Received from bridging 130832',0.00,0.00,24000.00,0.00,0.00,'2022-04-23 07:21:06','',''),(2614154,'5','182','953',426,'Sale Id shift 257571',0.00,0.00,0.00,300.00,0.00,'2022-04-23 08:33:03','',''),(2614155,'5','182','953',426,'Sale Id shift 257571',0.00,0.00,0.00,944.00,0.00,'2022-04-23 08:33:03','',''),(2614156,'5','182',NULL,426,'Sale Id shift 257571',205260.00,0.00,0.00,0.00,0.00,'2022-04-23 08:33:03','',''),(2614157,'5','182','953',426,'Sale Id shift 257572',0.00,0.00,0.00,3051.30,0.00,'2022-04-24 03:10:23','',''),(2614158,'5','182','953',426,'Sale Id shift 257572',0.00,0.00,0.00,1249.75,0.00,'2022-04-24 03:10:23','',''),(2614159,'5','182',NULL,426,'Sale Id shift 257572',709673.25,0.00,0.00,0.00,0.00,'2022-04-24 03:10:23','',''),(2614160,'5','182','953',426,'Sale Id shift 257573',0.00,0.00,0.00,3375.92,0.00,'2022-04-25 03:49:35','',''),(2614161,'5','182','953',426,'Sale Id shift 257573',0.00,0.00,0.00,1703.04,0.00,'2022-04-25 03:49:35','',''),(2614162,'5','182',NULL,426,'Sale Id shift 257573',838028.40,0.00,0.00,0.00,0.00,'2022-04-25 03:49:35','',''),(2614163,'5','182','953',426,'Sale Id shift 257574',0.00,0.00,0.00,2508.00,0.00,'2022-04-26 02:17:39','',''),(2614164,'5','182','953',426,'Sale Id shift 257574',0.00,0.00,0.00,1494.50,0.00,'2022-04-26 02:17:39','',''),(2614165,'5','182',NULL,426,'Sale Id shift 257574',660412.50,0.00,0.00,0.00,0.00,'2022-04-26 02:17:39','',''),(2614166,'5','182','953',426,'Sale Id shift 257575',0.00,0.00,0.00,3316.76,0.00,'2022-04-27 03:39:35','',''),(2614167,'5','182','953',426,'Sale Id shift 257575',0.00,0.00,0.00,2084.00,0.00,'2022-04-27 03:39:35','',''),(2614168,'5','182',NULL,426,'Sale Id shift 257575',891125.40,0.00,0.00,0.00,0.00,'2022-04-27 03:39:35','',''),(2614169,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-27 03:39:59','',''),(2614170,'5','182',NULL,426,'Reception corrector for bridging 130833',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 09:33:18','',''),(2614171,'5','182','953',426,'Received from bridging 130833',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 09:33:18','',''),(2614172,'5','182','953',426,'Sale Id shift 257576',0.00,0.00,0.00,2345.40,0.00,'2022-04-28 02:28:32','',''),(2614173,'5','182','953',426,'Sale Id shift 257576',0.00,0.00,0.00,4227.39,0.00,'2022-04-28 02:28:32','',''),(2614174,'5','182',NULL,426,'Sale Id shift 257576',1084510.35,0.00,0.00,0.00,0.00,'2022-04-28 02:28:32','',''),(2614175,'5','182','953',426,'Sale Id shift 257577',0.00,0.00,0.00,4174.38,0.00,'2022-04-29 06:05:21','',''),(2614176,'5','182','953',426,'Sale Id shift 257577',0.00,0.00,0.00,12.07,0.00,'2022-04-29 06:05:21','',''),(2614177,'5','182',NULL,426,'Sale Id shift 257577',690764.25,0.00,0.00,0.00,0.00,'2022-04-29 06:05:21','',''),(2614178,'5','182','953',426,'Sale Id shift 257578',0.00,0.00,0.00,125.20,0.00,'2022-04-30 00:04:51','',''),(2614179,'5','182','953',426,'Sale Id shift 257578',0.00,0.00,0.00,6122.36,0.00,'2022-04-30 00:04:51','',''),(2614180,'5','182',NULL,426,'Sale Id shift 257578',1030847.40,0.00,0.00,0.00,0.00,'2022-04-30 00:04:51','',''),(2614181,'5','182','953',426,'Sale Id shift 257579',0.00,0.00,0.00,3125.50,0.00,'2022-05-09 11:34:37','',''),(2614182,'5','182','953',426,'Sale Id shift 257579',0.00,0.00,0.00,4353.75,0.00,'2022-05-09 11:34:37','',''),(2614183,'5','182',NULL,426,'Sale Id shift 257579',1234076.25,0.00,0.00,0.00,0.00,'2022-05-09 11:34:37','',''),(2614184,'5','182','953',426,'Sale Id shift 257580',0.00,0.00,0.00,6986.75,0.00,'2022-05-09 11:38:31','',''),(2614185,'5','182','953',426,'Sale Id shift 257580',0.00,0.00,0.00,125.50,0.00,'2022-05-09 11:38:31','',''),(2614186,'5','182',NULL,426,'Sale Id shift 257580',1173521.25,0.00,0.00,0.00,0.00,'2022-05-09 11:38:31','',''),(2614187,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,5610000.00,34000.00,0.00,0.00,'2022-05-09 11:42:59','',''),(2614188,'5','182',NULL,426,'Reception corrector for bridging 130834',0.00,0.00,0.00,34000.00,0.00,'2022-05-09 12:28:40','',''),(2614189,'5','182','953',426,'Received from bridging 130834',0.00,0.00,34000.00,0.00,0.00,'2022-05-09 12:28:40','',''),(2614190,'5','182','953',426,'Sale Id shift 257581',0.00,0.00,0.00,1178.88,0.00,'2022-05-09 12:40:06','',''),(2614191,'5','182','953',426,'Sale Id shift 257581',0.00,0.00,0.00,2874.50,0.00,'2022-05-09 12:40:06','',''),(2614192,'5','182',NULL,426,'Sale Id shift 257581',668807.70,0.00,0.00,0.00,0.00,'2022-05-09 12:40:06','',''),(2614193,'5','182','953',426,'Sale Id shift 257582',0.00,0.00,0.00,2634.63,0.00,'2022-05-09 13:09:55','',''),(2614194,'5','182','953',426,'Sale Id shift 257582',0.00,0.00,0.00,4556.24,0.00,'2022-05-09 13:09:55','',''),(2614195,'5','182',NULL,426,'Sale Id shift 257582',1186493.55,0.00,0.00,0.00,0.00,'2022-05-09 13:09:55','',''),(2614196,'5','182','953',426,'Sale Id shift 257583',0.00,0.00,0.00,4476.76,0.00,'2022-05-09 13:12:07','',''),(2614197,'5','182','953',426,'Sale Id shift 257583',0.00,0.00,0.00,625.20,0.00,'2022-05-09 13:12:07','',''),(2614198,'5','182',NULL,426,'Sale Id shift 257583',841823.40,0.00,0.00,0.00,0.00,'2022-05-09 13:12:07','',''),(2614199,'5','182','953',426,'Sale Id shift 257584',0.00,0.00,0.00,498.20,0.00,'2022-05-09 13:14:32','',''),(2614200,'5','182','953',426,'Sale Id shift 257584',0.00,0.00,0.00,4613.41,0.00,'2022-05-09 13:14:32','',''),(2614201,'5','182',NULL,426,'Sale Id shift 257584',843415.65,0.00,0.00,0.00,0.00,'2022-05-09 13:14:32','',''),(2614202,'5','182','953',426,'Sale Id shift 257585',0.00,0.00,0.00,3434.29,0.00,'2022-05-09 13:16:17','',''),(2614203,'5','182','953',426,'Sale Id shift 257585',0.00,0.00,0.00,1601.80,0.00,'2022-05-09 13:16:17','',''),(2614204,'5','182',NULL,426,'Sale Id shift 257585',830954.85,0.00,0.00,0.00,0.00,'2022-05-09 13:16:17','',''),(2614205,'5','182','953',426,'Sale Id shift 257586',0.00,0.00,0.00,1994.93,0.00,'2022-05-09 13:19:05','',''),(2614206,'5','182','953',426,'Sale Id shift 257586',0.00,0.00,0.00,2072.28,0.00,'2022-05-09 13:19:05','',''),(2614207,'5','182',NULL,426,'Sale Id shift 257586',671089.65,0.00,0.00,0.00,0.00,'2022-05-09 13:19:05','',''),(2614208,'5','182','953',426,'Sale Id shift 257587',0.00,0.00,0.00,2779.18,0.00,'2022-05-09 13:21:10','',''),(2614209,'5','182','953',426,'Sale Id shift 257587',0.00,0.00,0.00,1023.07,0.00,'2022-05-09 13:21:10','',''),(2614210,'5','182',NULL,426,'Sale Id shift 257587',627371.25,0.00,0.00,0.00,0.00,'2022-05-09 13:21:10','',''),(2614211,'5','182','953',426,'Sale Id shift 257588',0.00,0.00,0.00,1784.35,0.00,'2022-05-10 06:50:24','',''),(2614212,'5','182',NULL,426,'Sale Id shift 257588',294417.75,0.00,0.00,0.00,0.00,'2022-05-10 06:50:24','',''),(2614213,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6105000.00,37000.00,0.00,0.00,'2022-05-25 21:44:44','',''),(2614214,'5','182',NULL,426,'Reception corrector for bridging 130836',0.00,0.00,0.00,18500.00,0.00,'2022-05-25 22:13:13','',''),(2614215,'5','182','954',426,'Received from bridging 130836',0.00,0.00,18500.00,0.00,0.00,'2022-05-25 22:13:13','',''),(2614216,'5','182',NULL,426,'Reception corrector for bridging 130835',0.00,0.00,0.00,18500.00,0.00,'2022-05-25 22:13:29','',''),(2614217,'5','182','953',426,'Received from bridging 130835',0.00,0.00,18500.00,0.00,0.00,'2022-05-25 22:13:29','',''),(2614218,'5','182','953',426,'Sale Id shift 257604',0.00,0.00,0.00,2513.01,0.00,'2022-05-26 10:02:51','',''),(2614219,'5','182',NULL,426,'Sale Id shift 257604',414646.65,0.00,0.00,0.00,0.00,'2022-05-26 10:02:51','',''),(2614220,'5','182','953',426,'Sale Id shift 257605',0.00,0.00,0.00,795.44,0.00,'2022-05-27 05:28:10','',''),(2614221,'5','182','953',426,'Sale Id shift 257605',0.00,0.00,0.00,3550.42,0.00,'2022-05-27 05:28:10','',''),(2614222,'5','182','954',426,'Sale Id shift 257605',0.00,0.00,0.00,73.95,0.00,'2022-05-27 05:28:10','',''),(2614223,'5','182',NULL,426,'Sale Id shift 257605',729268.65,0.00,0.00,0.00,0.00,'2022-05-27 05:28:10','',''),(2614224,'5','182','953',426,'Sale Id shift 257606',0.00,0.00,0.00,2484.94,0.00,'2022-05-28 05:00:02','',''),(2614225,'5','182','953',426,'Sale Id shift 257606',0.00,0.00,0.00,2113.84,0.00,'2022-05-28 05:00:02','',''),(2614226,'5','182',NULL,426,'Sale Id shift 257606',758798.70,0.00,0.00,0.00,0.00,'2022-05-28 05:00:02','',''),(2614227,'5','182','953',426,'Sale Id shift 257607',0.00,0.00,0.00,2375.79,0.00,'2022-05-29 08:19:07','',''),(2614228,'5','182','953',426,'Sale Id shift 257607',0.00,0.00,0.00,300.00,0.00,'2022-05-29 08:19:07','',''),(2614229,'5','182','954',426,'Sale Id shift 257607',0.00,0.00,0.00,2079.39,0.00,'2022-05-29 08:19:07','',''),(2614230,'5','182',NULL,426,'Sale Id shift 257607',784604.70,0.00,0.00,0.00,0.00,'2022-05-29 08:19:07','',''),(2614231,'5','182','953',426,'Sale Id shift 257608',0.00,0.00,0.00,2342.40,0.00,'2022-05-30 05:01:18','',''),(2614232,'5','182','954',426,'Sale Id shift 257608',0.00,0.00,0.00,2305.50,0.00,'2022-05-30 05:01:18','',''),(2614233,'5','182',NULL,426,'Sale Id shift 257608',766903.50,0.00,0.00,0.00,0.00,'2022-05-30 05:01:18','',''),(2614234,'5','182','953',426,'Sale Id shift 257609',0.00,0.00,0.00,650.74,0.00,'2022-05-31 00:22:17','',''),(2614235,'5','182','953',426,'Sale Id shift 257609',0.00,0.00,0.00,1055.82,0.00,'2022-05-31 00:22:17','',''),(2614236,'5','182','954',426,'Sale Id shift 257609',0.00,0.00,0.00,2554.50,0.00,'2022-05-31 00:22:17','',''),(2614237,'5','182',NULL,426,'Sale Id shift 257609',703074.90,0.00,0.00,0.00,0.00,'2022-05-31 00:22:17','',''),(2614238,'5','182','954',426,'Sale Id shift 257610',0.00,0.00,0.00,4165.20,0.00,'2022-06-01 07:06:31','',''),(2614239,'5','182',NULL,426,'Sale Id shift 257610',687258.00,0.00,0.00,0.00,0.00,'2022-06-01 07:06:31','',''),(2614240,'5','182','954',426,'Sale Id shift 257611',0.00,0.00,0.00,4015.20,0.00,'2022-06-02 05:02:39','',''),(2614241,'5','182',NULL,426,'Sale Id shift 257611',662508.00,0.00,0.00,0.00,0.00,'2022-06-02 05:02:39','',''),(2614242,'5','182','954',426,'Sale Id shift 257612',0.00,0.00,0.00,2051.80,0.00,'2022-06-03 06:49:23','',''),(2614243,'5','182',NULL,426,'Sale Id shift 257612',338547.00,0.00,0.00,0.00,0.00,'2022-06-03 06:49:23','',''),(2614244,'5','182','954',426,'Sale Id shift 257613',0.00,0.00,0.00,1604.72,0.00,'2022-06-04 06:09:14','',''),(2614245,'5','182',NULL,426,'Sale Id shift 257613',264778.80,0.00,0.00,0.00,0.00,'2022-06-04 06:09:14','',''),(2614246,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,6550500.00,39700.00,0.00,0.00,'2022-06-06 22:31:51','',''),(2614247,'5','182',NULL,426,'Reception corrector for bridging 130837',0.00,0.00,0.00,26200.00,0.00,'2022-06-07 09:13:22','',''),(2614248,'5','182','953',426,'Received from bridging 130837',0.00,0.00,26200.00,0.00,0.00,'2022-06-07 09:13:22','',''),(2614249,'5','182',NULL,426,'Reception corrector for bridging 130838',0.00,0.00,0.00,13500.00,0.00,'2022-06-07 09:13:30','',''),(2614250,'5','182','954',426,'Received from bridging 130838',0.00,0.00,13500.00,0.00,0.00,'2022-06-07 09:13:30','',''),(2614251,'5','182','953',426,'Sale Id shift 257616',0.00,0.00,0.00,3754.70,0.00,'2022-06-07 10:20:43','',''),(2614252,'5','182',NULL,426,'Sale Id shift 257616',619525.50,0.00,0.00,0.00,0.00,'2022-06-07 10:20:43','',''),(2614253,'5','182','953',426,'Sale Id shift 257617',0.00,0.00,0.00,1840.62,0.00,'2022-06-08 10:33:15','',''),(2614254,'5','182','954',426,'Sale Id shift 257617',0.00,0.00,0.00,3586.79,0.00,'2022-06-08 10:33:15','',''),(2614255,'5','182',NULL,426,'Sale Id shift 257617',895522.65,0.00,0.00,0.00,0.00,'2022-06-08 10:33:15','',''),(2614256,'5','182','953',426,'Sale Id shift 257618',0.00,0.00,0.00,3031.39,0.00,'2022-06-09 06:03:23','',''),(2614257,'5','182','953',426,'Sale Id shift 257618',0.00,0.00,0.00,1158.00,0.00,'2022-06-09 06:03:23','',''),(2614258,'5','182',NULL,426,'Sale Id shift 257618',691249.35,0.00,0.00,0.00,0.00,'2022-06-09 06:03:23','',''),(2614259,'5','182','953',426,'Sale Id shift 257619',0.00,0.00,0.00,1812.55,0.00,'2022-06-10 08:22:04','',''),(2614260,'5','182','953',426,'Sale Id shift 257619',0.00,0.00,0.00,1878.00,0.00,'2022-06-10 08:22:04','',''),(2614261,'5','182','954',426,'Sale Id shift 257619',0.00,0.00,0.00,1208.92,0.00,'2022-06-10 08:22:04','',''),(2614262,'5','182',NULL,426,'Sale Id shift 257619',808412.55,0.00,0.00,0.00,0.00,'2022-06-10 08:22:04','',''),(2614263,'5','182','953',426,'Sale Id shift 257620',0.00,0.00,0.00,1999.24,0.00,'2022-06-10 21:47:04','',''),(2614264,'5','182','953',426,'Sale Id shift 257620',0.00,0.00,0.00,1870.66,0.00,'2022-06-10 21:47:04','',''),(2614265,'5','182','954',426,'Sale Id shift 257620',0.00,0.00,0.00,1088.54,0.00,'2022-06-10 21:47:04','',''),(2614266,'5','182',NULL,426,'Sale Id shift 257620',818142.60,0.00,0.00,0.00,0.00,'2022-06-10 21:47:04','',''),(2614267,'5','182','953',426,'Sale Id shift 257621',0.00,0.00,0.00,1687.33,0.00,'2022-06-12 08:32:42','',''),(2614268,'5','182','953',426,'Sale Id shift 257621',0.00,0.00,0.00,2131.99,0.00,'2022-06-12 08:32:42','',''),(2614269,'5','182','954',426,'Sale Id shift 257621',0.00,0.00,0.00,384.36,0.00,'2022-06-12 08:32:42','',''),(2614270,'5','182',NULL,426,'Sale Id shift 257621',693607.20,0.00,0.00,0.00,0.00,'2022-06-12 08:32:42','',''),(2614271,'5','182','953',426,'Sale Id shift 257622',0.00,0.00,0.00,2339.03,0.00,'2022-06-13 06:56:07','',''),(2614272,'5','182','953',426,'Sale Id shift 257622',0.00,0.00,0.00,955.48,0.00,'2022-06-13 06:56:07','',''),(2614273,'5','182','954',426,'Sale Id shift 257622',0.00,0.00,0.00,714.07,0.00,'2022-06-13 06:56:07','',''),(2614274,'5','182',NULL,426,'Sale Id shift 257622',661415.70,0.00,0.00,0.00,0.00,'2022-06-13 06:56:07','',''),(2614275,'5','182','953',426,'Sale Id shift 257623',0.00,0.00,0.00,1012.88,0.00,'2022-06-14 09:00:35','',''),(2614276,'5','182','953',426,'Sale Id shift 257623',0.00,0.00,0.00,889.68,0.00,'2022-06-14 09:00:35','',''),(2614277,'5','182','954',426,'Sale Id shift 257623',0.00,0.00,0.00,2302.20,0.00,'2022-06-14 09:00:35','',''),(2614278,'5','182',NULL,426,'Sale Id shift 257623',693785.40,0.00,0.00,0.00,0.00,'2022-06-14 09:00:35','',''),(2614279,'5','182','954',426,'Sale Id shift 257624',0.00,0.00,0.00,4332.05,0.00,'2022-06-15 07:35:09','',''),(2614280,'5','182',NULL,426,'Sale Id shift 257624',714788.25,0.00,0.00,0.00,0.00,'2022-06-15 07:35:09','',''),(2614281,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4162500.00,22500.00,0.00,0.00,'2022-07-14 06:34:22','',''),(2614282,'5','182',NULL,426,'Reception corrector for bridging 130839',0.00,0.00,0.00,22500.00,0.00,'2022-07-14 07:47:53','',''),(2614283,'5','182','953',426,'Received from bridging 130839',0.00,0.00,22500.00,0.00,0.00,'2022-07-14 07:47:53','',''),(2614284,'5','182','953',426,'Sale Id shift 257653',0.00,0.00,0.00,2275.00,0.00,'2022-07-14 09:48:54','',''),(2614285,'5','182','953',426,'Sale Id shift 257653',0.00,0.00,0.00,560.00,0.00,'2022-07-14 09:48:54','',''),(2614286,'5','182',NULL,426,'Sale Id shift 257653',524475.00,0.00,0.00,0.00,0.00,'2022-07-14 09:48:54','',''),(2614287,'5','182','953',426,'Sale Id shift 257654',0.00,0.00,0.00,670.33,0.00,'2022-07-15 07:19:44','',''),(2614288,'5','182','953',426,'Sale Id shift 257654',0.00,0.00,0.00,3572.23,0.00,'2022-07-15 07:19:44','',''),(2614289,'5','182',NULL,426,'Sale Id shift 257654',784873.60,0.00,0.00,0.00,0.00,'2022-07-15 07:19:44','',''),(2614290,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-15 15:41:28','',''),(2614291,'5','182',NULL,426,'Reception corrector for bridging 130840',0.00,0.00,0.00,15000.00,0.00,'2022-07-15 16:41:17','',''),(2614292,'5','182','954',426,'Received from bridging 130840',0.00,0.00,15000.00,0.00,0.00,'2022-07-15 16:41:17','',''),(2614293,'5','182','953',426,'Sale Id shift 257655',0.00,0.00,0.00,1925.25,0.00,'2022-07-16 06:56:06','',''),(2614294,'5','182','953',426,'Sale Id shift 257655',0.00,0.00,0.00,2311.78,0.00,'2022-07-16 06:56:06','',''),(2614295,'5','182',NULL,426,'Sale Id shift 257655',783850.55,0.00,0.00,0.00,0.00,'2022-07-16 06:56:06','',''),(2614296,'5','182','953',426,'Sale Id shift 257656',0.00,0.00,0.00,3743.76,0.00,'2022-07-17 05:31:27','',''),(2614297,'5','182','953',426,'Sale Id shift 257656',0.00,0.00,0.00,500.00,0.00,'2022-07-17 05:31:27','',''),(2614298,'5','182','954',426,'Sale Id shift 257656',0.00,0.00,0.00,814.44,0.00,'2022-07-17 05:31:27','',''),(2614299,'5','182',NULL,426,'Sale Id shift 257656',935767.00,0.00,0.00,0.00,0.00,'2022-07-17 05:31:27','',''),(2614300,'5','182','953',426,'Sale Id shift 257657',0.00,0.00,0.00,295.52,0.00,'2022-07-18 07:37:04','',''),(2614301,'5','182','953',426,'Sale Id shift 257657',0.00,0.00,0.00,5187.29,0.00,'2022-07-18 07:37:04','',''),(2614302,'5','182',NULL,426,'Sale Id shift 257657',1014319.85,0.00,0.00,0.00,0.00,'2022-07-18 07:37:04','',''),(2614303,'5','182','953',426,'Sale Id shift 257658',0.00,0.00,0.00,1500.00,0.00,'2022-07-19 05:05:04','',''),(2614304,'5','182','954',426,'Sale Id shift 257658',0.00,0.00,0.00,4835.38,0.00,'2022-07-19 05:05:04','',''),(2614305,'5','182',NULL,426,'Sale Id shift 257658',1172045.30,0.00,0.00,0.00,0.00,'2022-07-19 05:05:04','',''),(2614306,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-19 19:54:37','',''),(2614307,'5','182',NULL,426,'Reception corrector for bridging 130841',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 21:57:31','',''),(2614308,'5','182','953',426,'Received from bridging 130841',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 21:57:31','',''),(2614309,'5','182','953',426,'Sale Id shift 257659',0.00,0.00,0.00,1212.52,0.00,'2022-07-20 07:42:07','',''),(2614310,'5','182','954',426,'Sale Id shift 257659',0.00,0.00,0.00,3362.22,0.00,'2022-07-20 07:42:07','',''),(2614311,'5','182',NULL,426,'Sale Id shift 257659',846326.90,0.00,0.00,0.00,0.00,'2022-07-20 07:42:07','',''),(2614312,'5','182','953',426,'Sale Id shift 257660',0.00,0.00,0.00,2240.26,0.00,'2022-07-21 06:51:07','',''),(2614313,'5','182','953',426,'Sale Id shift 257660',0.00,0.00,0.00,2577.88,0.00,'2022-07-21 06:51:07','',''),(2614314,'5','182','954',426,'Sale Id shift 257660',0.00,0.00,0.00,288.09,0.00,'2022-07-21 06:51:07','',''),(2614315,'5','182',NULL,426,'Sale Id shift 257660',944652.55,0.00,0.00,0.00,0.00,'2022-07-21 06:51:07','',''),(2614316,'5','182','953',426,'Sale Id shift 257661',0.00,0.00,0.00,1697.64,0.00,'2022-07-21 23:12:49','',''),(2614317,'5','182','953',426,'Sale Id shift 257661',0.00,0.00,0.00,723.85,0.00,'2022-07-21 23:12:49','',''),(2614318,'5','182','954',426,'Sale Id shift 257661',0.00,0.00,0.00,1625.53,0.00,'2022-07-21 23:12:49','',''),(2614319,'5','182',NULL,426,'Sale Id shift 257661',748698.70,0.00,0.00,0.00,0.00,'2022-07-21 23:12:49','',''),(2614320,'5','182','954',0,'Tank level zero out for dipping',0.00,0.00,0.00,4277.17,0.00,'2022-07-23 10:38:50','',''),(2614321,'5','182','954',0,'Inventory adjustment from tank dipping to 4500',0.00,0.00,4500.00,0.00,0.00,'2022-07-23 10:38:50','',''),(2614322,'5','182','953',426,'Sale Id shift 257662',0.00,0.00,0.00,2443.51,0.00,'2022-07-23 13:45:50','',''),(2614323,'5','182','953',426,'Sale Id shift 257662',0.00,0.00,0.00,43.22,0.00,'2022-07-23 13:45:50','',''),(2614324,'5','182','954',426,'Sale Id shift 257662',0.00,0.00,0.00,4302.17,0.00,'2022-07-23 13:45:50','',''),(2614325,'5','182',NULL,426,'Sale Id shift 257662',1255946.50,0.00,0.00,0.00,0.00,'2022-07-23 13:45:50','',''),(2614326,'5','182','953',426,'Sale Id shift 257663',0.00,0.00,0.00,2872.00,0.00,'2022-07-24 08:33:54','',''),(2614327,'5','182','953',426,'Sale Id shift 257663',0.00,0.00,0.00,1218.56,0.00,'2022-07-24 08:33:54','',''),(2614328,'5','182',NULL,426,'Sale Id shift 257663',756753.60,0.00,0.00,0.00,0.00,'2022-07-24 08:33:54','',''),(2614329,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,4162500.00,22500.00,0.00,0.00,'2022-07-25 15:26:58','',''),(2614330,'5','182',NULL,426,'Reception corrector for bridging 130842',0.00,0.00,0.00,22500.00,0.00,'2022-07-25 15:38:58','',''),(2614331,'5','182','953',426,'Received from bridging 130842',0.00,0.00,22500.00,0.00,0.00,'2022-07-25 15:38:58','',''),(2614332,'5','182','953',426,'Sale Id shift 257665',0.00,0.00,0.00,2072.25,0.00,'2022-07-26 05:55:52','',''),(2614333,'5','182','953',426,'Sale Id shift 257665',0.00,0.00,0.00,2002.00,0.00,'2022-07-26 05:55:52','',''),(2614334,'5','182',NULL,426,'Sale Id shift 257665',753736.25,0.00,0.00,0.00,0.00,'2022-07-26 05:55:52','',''),(2614335,'5','182','953',426,'Sale Id shift 257666',0.00,0.00,0.00,3876.01,0.00,'2022-07-27 06:06:33','',''),(2614336,'5','182','953',426,'Sale Id shift 257666',0.00,0.00,0.00,2472.24,0.00,'2022-07-27 06:06:33','',''),(2614337,'5','182',NULL,426,'Sale Id shift 257666',1174426.25,0.00,0.00,0.00,0.00,'2022-07-27 06:06:33','',''),(2614338,'5','182','953',426,'Sale Id shift 257667',0.00,0.00,0.00,6095.56,0.00,'2022-07-28 06:56:31','',''),(2614339,'5','182',NULL,426,'Sale Id shift 257667',1127678.60,0.00,0.00,0.00,0.00,'2022-07-28 06:56:31','',''),(2614340,'5','182','953',426,'Sale Id shift 257668',0.00,0.00,0.00,4060.74,0.00,'2022-07-29 07:14:05','',''),(2614341,'5','182',NULL,426,'Sale Id shift 257668',751236.90,0.00,0.00,0.00,0.00,'2022-07-29 07:14:05','',''),(2614342,'5','182','953',426,'Sale Id shift 257669',0.00,0.00,0.00,954.95,0.00,'2022-07-30 05:50:30','',''),(2614343,'5','182','953',426,'Sale Id shift 257669',0.00,0.00,0.00,1082.93,0.00,'2022-07-30 05:50:30','',''),(2614344,'5','182',NULL,426,'Sale Id shift 257669',377007.80,0.00,0.00,0.00,0.00,'2022-07-30 05:50:30','',''),(2614345,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-08-02 10:09:15','',''),(2614346,'5','182',NULL,426,'Reception corrector for bridging 130843',0.00,0.00,0.00,15000.00,0.00,'2022-08-02 10:53:30','',''),(2614347,'5','182','953',426,'Received from bridging 130843',0.00,0.00,15000.00,0.00,0.00,'2022-08-02 10:53:30','',''),(2614348,'5','182','953',426,'Sale Id shift 257673',0.00,0.00,0.00,2541.47,0.00,'2022-08-03 07:00:46','',''),(2614349,'5','182','953',426,'Sale Id shift 257673',0.00,0.00,0.00,1500.00,0.00,'2022-08-03 07:00:46','',''),(2614350,'5','182',NULL,426,'Sale Id shift 257673',747671.95,0.00,0.00,0.00,0.00,'2022-08-03 07:00:46','',''),(2614351,'5','182','953',426,'Sale Id shift 257674',0.00,0.00,0.00,1100.00,0.00,'2022-08-04 06:16:53','',''),(2614352,'5','182','953',426,'Sale Id shift 257674',0.00,0.00,0.00,3178.19,0.00,'2022-08-04 06:16:53','',''),(2614353,'5','182',NULL,426,'Sale Id shift 257674',791465.15,0.00,0.00,0.00,0.00,'2022-08-04 06:16:53','',''),(2614354,'5','182','953',426,'Sale Id shift 257675',0.00,0.00,0.00,3275.03,0.00,'2022-08-04 21:51:54','',''),(2614355,'5','182','953',426,'Sale Id shift 257675',0.00,0.00,0.00,1000.00,0.00,'2022-08-04 21:51:54','',''),(2614356,'5','182',NULL,426,'Sale Id shift 257675',790880.55,0.00,0.00,0.00,0.00,'2022-08-04 21:51:54','',''),(2614357,'5','182','953',426,'Sale Id shift 257676',0.00,0.00,0.00,799.81,0.00,'2022-08-06 06:54:42','',''),(2614358,'5','182','953',426,'Sale Id shift 257676',0.00,0.00,0.00,1594.23,0.00,'2022-08-06 06:54:42','',''),(2614359,'5','182',NULL,426,'Sale Id shift 257676',442897.40,0.00,0.00,0.00,0.00,'2022-08-06 06:54:42','',''),(2614360,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8195500.00,44300.00,0.00,0.00,'2022-09-04 07:33:31','',''),(2614361,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,3135750.00,16950.00,0.00,0.00,'2022-09-04 07:33:54','',''),(2614362,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,5513000.00,29800.00,0.00,0.00,'2022-09-04 07:34:07','',''),(2614363,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2488250.00,13450.00,0.00,0.00,'2022-09-04 07:34:22','',''),(2614364,'5','182',NULL,426,'Reception corrector for bridging 130844',0.00,0.00,0.00,13450.00,0.00,'2022-09-04 11:03:00','',''),(2614365,'5','182','953',426,'Received from bridging 130844',0.00,0.00,13450.00,0.00,0.00,'2022-09-04 11:03:00','',''),(2614366,'5','182',NULL,426,'Reception corrector for bridging 130846',0.00,0.00,0.00,16950.00,0.00,'2022-09-04 11:03:52','',''),(2614367,'5','182','954',426,'Received from bridging 130846',0.00,0.00,16950.00,0.00,0.00,'2022-09-04 11:03:52','',''),(2614368,'5','182','953',426,'Sale Id shift 257680',0.00,0.00,0.00,2282.07,0.00,'2022-09-04 11:14:13','',''),(2614369,'5','182','953',426,'Sale Id shift 257680',0.00,0.00,0.00,1225.00,0.00,'2022-09-04 11:14:13','',''),(2614370,'5','182',NULL,426,'Sale Id shift 257680',648807.95,0.00,0.00,0.00,0.00,'2022-09-04 11:14:13','',''),(2614371,'5','182','953',426,'Sale Id shift 257681',0.00,0.00,0.00,501.00,0.00,'2022-09-04 11:19:33','',''),(2614372,'5','182','953',426,'Sale Id shift 257681',0.00,0.00,0.00,3898.01,0.00,'2022-09-04 11:19:33','',''),(2614373,'5','182',NULL,426,'Sale Id shift 257681',813816.85,0.00,0.00,0.00,0.00,'2022-09-04 11:19:33','',''),(2614374,'5','182','953',426,'Sale Id shift 257682',0.00,0.00,0.00,4070.02,0.00,'2022-09-04 11:22:46','',''),(2614375,'5','182',NULL,426,'Sale Id shift 257682',752953.70,0.00,0.00,0.00,0.00,'2022-09-04 11:22:46','',''),(2614376,'5','182','953',426,'Sale Id shift 257683',0.00,0.00,0.00,101.01,0.00,'2022-09-04 11:26:05','',''),(2614377,'5','182','953',426,'Sale Id shift 257683',0.00,0.00,0.00,1433.91,0.00,'2022-09-04 11:26:05','',''),(2614378,'5','182',NULL,426,'Sale Id shift 257683',283960.20,0.00,0.00,0.00,0.00,'2022-09-04 11:26:05','',''),(2614379,'5','182',NULL,426,'Reception corrector for bridging 130845',0.00,0.00,0.00,29800.00,0.00,'2022-09-04 11:37:55','',''),(2614380,'5','182','953',426,'Received from bridging 130845',0.00,0.00,29800.00,0.00,0.00,'2022-09-04 11:37:55','',''),(2614381,'5','182','953',426,'Sale Id shift 257685',0.00,0.00,0.00,1609.72,0.00,'2022-09-04 12:23:21','',''),(2614382,'5','182','953',426,'Sale Id shift 257685',0.00,0.00,0.00,1651.13,0.00,'2022-09-04 12:23:21','',''),(2614383,'5','182',NULL,426,'Sale Id shift 257685',603257.25,0.00,0.00,0.00,0.00,'2022-09-04 12:23:21','',''),(2614384,'5','182','953',426,'Sale Id shift 257686',0.00,0.00,0.00,3027.62,0.00,'2022-09-05 06:53:20','',''),(2614385,'5','182','953',426,'Sale Id shift 257686',0.00,0.00,0.00,1100.00,0.00,'2022-09-05 06:53:20','',''),(2614386,'5','182',NULL,426,'Sale Id shift 257686',763609.70,0.00,0.00,0.00,0.00,'2022-09-05 06:53:20','',''),(2614387,'5','182','953',426,'Sale Id shift 257687',0.00,0.00,0.00,1799.05,0.00,'2022-09-05 11:33:33','',''),(2614388,'5','182','953',426,'Sale Id shift 257687',0.00,0.00,0.00,2797.17,0.00,'2022-09-05 11:33:33','',''),(2614389,'5','182',NULL,426,'Sale Id shift 257687',850300.70,0.00,0.00,0.00,0.00,'2022-09-05 11:33:33','',''),(2614390,'5','182','954',426,'Sale Id shift 257688',0.00,0.00,0.00,1949.52,0.00,'2022-09-05 11:39:20','',''),(2614391,'5','182',NULL,426,'Sale Id shift 257688',360661.20,0.00,0.00,0.00,0.00,'2022-09-05 11:39:20','',''),(2614392,'5','182','953',426,'Sale Id shift 257689',0.00,0.00,0.00,3035.06,0.00,'2022-09-05 11:42:17','',''),(2614393,'5','182','953',426,'Sale Id shift 257689',0.00,0.00,0.00,1927.41,0.00,'2022-09-05 11:42:17','',''),(2614394,'5','182','954',426,'Sale Id shift 257689',0.00,0.00,0.00,979.24,0.00,'2022-09-05 11:42:17','',''),(2614395,'5','182',NULL,426,'Sale Id shift 257689',1099216.35,0.00,0.00,0.00,0.00,'2022-09-05 11:42:17','',''),(2614396,'5','182','953',426,'Sale Id shift 257690',0.00,0.00,0.00,1396.03,0.00,'2022-09-05 12:06:27','',''),(2614397,'5','182','954',426,'Sale Id shift 257690',0.00,0.00,0.00,1211.26,0.00,'2022-09-05 12:06:27','',''),(2614398,'5','182',NULL,426,'Sale Id shift 257690',482348.65,0.00,0.00,0.00,0.00,'2022-09-05 12:06:27','',''),(2614399,'5','182','953',426,'Sale Id shift 257691',0.00,0.00,0.00,1719.62,0.00,'2022-09-05 12:11:48','',''),(2614400,'5','182','954',426,'Sale Id shift 257691',0.00,0.00,0.00,1050.40,0.00,'2022-09-05 12:11:48','',''),(2614401,'5','182',NULL,426,'Sale Id shift 257691',512453.70,0.00,0.00,0.00,0.00,'2022-09-05 12:11:48','',''),(2614402,'5','182','953',426,'Sale Id shift 257692',0.00,0.00,0.00,1715.48,0.00,'2022-09-05 12:17:13','',''),(2614403,'5','182','953',426,'Sale Id shift 257692',0.00,0.00,0.00,1031.02,0.00,'2022-09-05 12:17:13','',''),(2614404,'5','182','954',426,'Sale Id shift 257692',0.00,0.00,0.00,1427.43,0.00,'2022-09-05 12:17:13','',''),(2614405,'5','182',NULL,426,'Sale Id shift 257692',772177.05,0.00,0.00,0.00,0.00,'2022-09-05 12:17:13','',''),(2614406,'5','182','953',426,'Sale Id shift 257693',0.00,0.00,0.00,1604.78,0.00,'2022-09-05 12:21:19','',''),(2614407,'5','182','953',426,'Sale Id shift 257693',0.00,0.00,0.00,1139.62,0.00,'2022-09-05 12:21:19','',''),(2614408,'5','182','954',426,'Sale Id shift 257693',0.00,0.00,0.00,303.65,0.00,'2022-09-05 12:21:19','',''),(2614409,'5','182',NULL,426,'Sale Id shift 257693',563889.25,0.00,0.00,0.00,0.00,'2022-09-05 12:21:19','',''),(2614410,'5','182','953',426,'Sale Id shift 257694',0.00,0.00,0.00,1805.35,0.00,'2022-09-05 12:23:55','',''),(2614411,'5','182','953',426,'Sale Id shift 257694',0.00,0.00,0.00,1818.77,0.00,'2022-09-05 12:23:55','',''),(2614412,'5','182','954',426,'Sale Id shift 257694',0.00,0.00,0.00,846.73,0.00,'2022-09-05 12:23:55','',''),(2614413,'5','182',NULL,426,'Sale Id shift 257694',827107.25,0.00,0.00,0.00,0.00,'2022-09-05 12:23:55','',''),(2614414,'5','182','953',426,'Sale Id shift 257695',0.00,0.00,0.00,433.16,0.00,'2022-09-05 12:29:07','',''),(2614415,'5','182','953',426,'Sale Id shift 257695',0.00,0.00,0.00,312.33,0.00,'2022-09-05 12:29:07','',''),(2614416,'5','182','954',426,'Sale Id shift 257695',0.00,0.00,0.00,4050.78,0.00,'2022-09-05 12:29:07','',''),(2614417,'5','182',NULL,426,'Sale Id shift 257695',887309.95,0.00,0.00,0.00,0.00,'2022-09-05 12:29:07','',''),(2614418,'5','182','954',426,'Sale Id shift 257696',0.00,0.00,0.00,3346.22,0.00,'2022-09-05 12:32:27','',''),(2614419,'5','182',NULL,426,'Sale Id shift 257696',619050.70,0.00,0.00,0.00,0.00,'2022-09-05 12:32:27','',''),(2614420,'5','182',NULL,426,'Reception corrector for bridging 130848',0.00,0.00,0.00,22200.00,0.00,'2022-09-05 12:33:40','',''),(2614421,'5','182','954',426,'Received from bridging 130848',0.00,0.00,22200.00,0.00,0.00,'2022-09-05 12:33:40','',''),(2614422,'5','182',NULL,426,'Reception corrector for bridging 130847',0.00,0.00,0.00,22100.00,0.00,'2022-09-05 12:33:48','',''),(2614423,'5','182','953',426,'Received from bridging 130847',0.00,0.00,22100.00,0.00,0.00,'2022-09-05 12:33:48','',''),(2614424,'5','182','954',426,'Sale Id shift 257697',0.00,0.00,0.00,2019.34,0.00,'2022-09-05 12:35:49','',''),(2614425,'5','182',NULL,426,'Sale Id shift 257697',373577.90,0.00,0.00,0.00,0.00,'2022-09-05 12:35:49','',''),(2614426,'5','182','953',426,'Sale Id shift 257698',0.00,0.00,0.00,1215.47,0.00,'2022-09-05 12:40:00','',''),(2614427,'5','182','953',426,'Sale Id shift 257698',0.00,0.00,0.00,1068.40,0.00,'2022-09-05 12:40:00','',''),(2614428,'5','182','954',426,'Sale Id shift 257698',0.00,0.00,0.00,942.93,0.00,'2022-09-05 12:40:00','',''),(2614429,'5','182',NULL,426,'Sale Id shift 257698',596958.00,0.00,0.00,0.00,0.00,'2022-09-05 12:40:00','',''),(2614430,'5','182','953',426,'Sale Id shift 257699',0.00,0.00,0.00,1508.33,0.00,'2022-09-05 12:42:43','',''),(2614431,'5','182','953',426,'Sale Id shift 257699',0.00,0.00,0.00,918.43,0.00,'2022-09-05 12:42:43','',''),(2614432,'5','182','954',426,'Sale Id shift 257699',0.00,0.00,0.00,1137.79,0.00,'2022-09-05 12:42:43','',''),(2614433,'5','182',NULL,426,'Sale Id shift 257699',659441.75,0.00,0.00,0.00,0.00,'2022-09-05 12:42:43','',''),(2614434,'5','182','953',426,'Sale Id shift 257700',0.00,0.00,0.00,2306.34,0.00,'2022-09-05 12:45:10','',''),(2614435,'5','182','953',426,'Sale Id shift 257700',0.00,0.00,0.00,1452.66,0.00,'2022-09-05 12:45:10','',''),(2614436,'5','182','954',426,'Sale Id shift 257700',0.00,0.00,0.00,1718.67,0.00,'2022-09-05 12:45:10','',''),(2614437,'5','182',NULL,426,'Sale Id shift 257700',1013368.95,0.00,0.00,0.00,0.00,'2022-09-05 12:45:10','',''),(2614438,'5','182','953',426,'Sale Id shift 257701',0.00,0.00,0.00,1471.18,0.00,'2022-09-05 12:47:38','',''),(2614439,'5','182','953',426,'Sale Id shift 257701',0.00,0.00,0.00,1005.82,0.00,'2022-09-05 12:47:38','',''),(2614440,'5','182','954',426,'Sale Id shift 257701',0.00,0.00,0.00,1031.52,0.00,'2022-09-05 12:47:38','',''),(2614441,'5','182',NULL,426,'Sale Id shift 257701',649076.20,0.00,0.00,0.00,0.00,'2022-09-05 12:47:38','',''),(2614442,'5','182','953',426,'Sale Id shift 257702',0.00,0.00,0.00,2438.97,0.00,'2022-09-05 12:50:11','',''),(2614443,'5','182','953',426,'Sale Id shift 257702',0.00,0.00,0.00,2059.28,0.00,'2022-09-05 12:50:11','',''),(2614444,'5','182','954',426,'Sale Id shift 257702',0.00,0.00,0.00,756.79,0.00,'2022-09-05 12:50:11','',''),(2614445,'5','182',NULL,426,'Sale Id shift 257702',972182.40,0.00,0.00,0.00,0.00,'2022-09-05 12:50:11','',''),(2614446,'5','182','953',426,'Sale Id shift 257703',0.00,0.00,0.00,2562.25,0.00,'2022-09-05 13:08:16','',''),(2614447,'5','182','953',426,'Sale Id shift 257703',0.00,0.00,0.00,1084.25,0.00,'2022-09-05 13:08:16','',''),(2614448,'5','182','954',426,'Sale Id shift 257703',0.00,0.00,0.00,2425.62,0.00,'2022-09-05 13:08:16','',''),(2614449,'5','182',NULL,426,'Sale Id shift 257703',1123342.20,0.00,0.00,0.00,0.00,'2022-09-05 13:08:16','',''),(2614450,'5','182','953',426,'Sale Id shift 257704',0.00,0.00,0.00,1218.56,0.00,'2022-09-05 13:20:10','',''),(2614451,'5','182','953',426,'Sale Id shift 257704',0.00,0.00,0.00,1810.23,0.00,'2022-09-05 13:20:10','',''),(2614452,'5','182','954',426,'Sale Id shift 257704',0.00,0.00,0.00,2000.00,0.00,'2022-09-05 13:20:10','',''),(2614453,'5','182',NULL,426,'Sale Id shift 257704',930326.15,0.00,0.00,0.00,0.00,'2022-09-05 13:20:10','',''),(2614454,'5','182','954',426,'Sale Id shift 257705',0.00,0.00,0.00,1239.37,0.00,'2022-09-05 13:22:35','',''),(2614455,'5','182','954',426,'Sale Id shift 257705',0.00,0.00,0.00,3025.00,0.00,'2022-09-05 13:22:35','',''),(2614456,'5','182',NULL,426,'Sale Id shift 257705',788908.45,0.00,0.00,0.00,0.00,'2022-09-05 13:22:35','',''),(2614457,'5','182','954',426,'Sale Id shift 257706',0.00,0.00,0.00,5465.95,0.00,'2022-09-05 13:24:51','',''),(2614458,'5','182',NULL,426,'Sale Id shift 257706',1011200.75,0.00,0.00,0.00,0.00,'2022-09-05 13:24:51','',''),(2614459,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,7307500.00,39500.00,0.00,0.00,'2022-09-06 09:57:31','',''),(2614460,'5','182',NULL,426,'Reception corrector for bridging 130850',0.00,0.00,0.00,13500.00,0.00,'2022-09-06 10:13:30','',''),(2614461,'5','182','954',426,'Received from bridging 130850',0.00,0.00,13500.00,0.00,0.00,'2022-09-06 10:13:30','',''),(2614462,'5','182',NULL,426,'Reception corrector for bridging 130849',0.00,0.00,0.00,26000.00,0.00,'2022-09-06 10:13:38','',''),(2614463,'5','182','953',426,'Received from bridging 130849',0.00,0.00,26000.00,0.00,0.00,'2022-09-06 10:13:38','',''),(2614464,'5','182','954',426,'Sale Id shift 257707',0.00,0.00,0.00,2994.42,0.00,'2022-09-06 10:31:02','',''),(2614465,'5','182',NULL,426,'Sale Id shift 257707',553967.70,0.00,0.00,0.00,0.00,'2022-09-06 10:31:02','',''),(2614466,'5','182','953',426,'Sale Id shift 257708',0.00,0.00,0.00,2054.56,0.00,'2022-09-07 10:25:24','',''),(2614467,'5','182','953',426,'Sale Id shift 257708',0.00,0.00,0.00,2042.39,0.00,'2022-09-07 10:25:24','',''),(2614468,'5','182','954',426,'Sale Id shift 257708',0.00,0.00,0.00,1649.51,0.00,'2022-09-07 10:25:24','',''),(2614469,'5','182',NULL,426,'Sale Id shift 257708',1063095.10,0.00,0.00,0.00,0.00,'2022-09-07 10:25:24','',''),(2614470,'5','182','953',426,'Sale Id shift 257709',0.00,0.00,0.00,2523.55,0.00,'2022-09-08 07:12:31','',''),(2614471,'5','182','953',426,'Sale Id shift 257709',0.00,0.00,0.00,1733.25,0.00,'2022-09-08 07:12:31','',''),(2614472,'5','182','954',426,'Sale Id shift 257709',0.00,0.00,0.00,1393.52,0.00,'2022-09-08 07:12:31','',''),(2614473,'5','182',NULL,426,'Sale Id shift 257709',1045309.20,0.00,0.00,0.00,0.00,'2022-09-08 07:12:31','',''),(2614474,'5','182','953',426,'Sale Id shift 257710',0.00,0.00,0.00,1936.79,0.00,'2022-09-09 08:19:25','',''),(2614475,'5','182','953',426,'Sale Id shift 257710',0.00,0.00,0.00,1488.56,0.00,'2022-09-09 08:19:25','',''),(2614476,'5','182','954',426,'Sale Id shift 257710',0.00,0.00,0.00,1162.39,0.00,'2022-09-09 08:19:25','',''),(2614477,'5','182',NULL,426,'Sale Id shift 257710',848731.90,0.00,0.00,0.00,0.00,'2022-09-09 08:19:25','',''),(2614478,'5','182','953',426,'Sale Id shift 257711',0.00,0.00,0.00,1330.74,0.00,'2022-09-10 09:42:37','',''),(2614479,'5','182','953',426,'Sale Id shift 257711',0.00,0.00,0.00,1107.24,0.00,'2022-09-10 09:42:37','',''),(2614480,'5','182','954',426,'Sale Id shift 257711',0.00,0.00,0.00,893.47,0.00,'2022-09-10 09:42:37','',''),(2614481,'5','182',NULL,426,'Sale Id shift 257711',616318.25,0.00,0.00,0.00,0.00,'2022-09-10 09:42:37','',''),(2614482,'5','182','953',426,'Sale Id shift 257712',0.00,0.00,0.00,1800.84,0.00,'2022-09-11 08:57:17','',''),(2614483,'5','182','953',426,'Sale Id shift 257712',0.00,0.00,0.00,1271.52,0.00,'2022-09-11 08:57:17','',''),(2614484,'5','182','954',426,'Sale Id shift 257712',0.00,0.00,0.00,1157.38,0.00,'2022-09-11 08:57:17','',''),(2614485,'5','182',NULL,426,'Sale Id shift 257712',782501.90,0.00,0.00,0.00,0.00,'2022-09-11 08:57:17','',''),(2614486,'5','182','953',426,'Sale Id shift 257713',0.00,0.00,0.00,2526.31,0.00,'2022-09-12 08:57:43','',''),(2614487,'5','182','953',426,'Sale Id shift 257713',0.00,0.00,0.00,1738.64,0.00,'2022-09-12 08:57:43','',''),(2614488,'5','182','954',426,'Sale Id shift 257713',0.00,0.00,0.00,1297.38,0.00,'2022-09-12 08:57:43','',''),(2614489,'5','182','954',426,'Sale Id shift 257713',0.00,0.00,0.00,2185.95,0.00,'2022-09-12 08:57:43','',''),(2614490,'5','182',NULL,426,'Sale Id shift 257713',1433431.80,0.00,0.00,0.00,0.00,'2022-09-12 08:57:43','',''),(2614491,'5','182','953',426,'Sale Id shift 257714',0.00,0.00,0.00,2131.31,0.00,'2022-09-13 09:16:40','',''),(2614492,'5','182','953',426,'Sale Id shift 257714',0.00,0.00,0.00,1641.52,0.00,'2022-09-13 09:16:40','',''),(2614493,'5','182','954',426,'Sale Id shift 257714',0.00,0.00,0.00,1165.00,0.00,'2022-09-13 09:16:40','',''),(2614494,'5','182','954',426,'Sale Id shift 257714',0.00,0.00,0.00,1584.18,0.00,'2022-09-13 09:16:40','',''),(2614495,'5','182',NULL,426,'Sale Id shift 257714',1206571.85,0.00,0.00,0.00,0.00,'2022-09-13 09:16:40','',''),(2614496,'5','182','954',0,'Tank level zero out for dipping',0.00,0.00,0.00,436.42,0.00,'2022-09-14 09:40:48','',''),(2614497,'5','182','954',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-09-14 09:40:48','',''),(2614498,'5','182','953',426,'Sale Id shift 257715',0.00,0.00,0.00,488.25,0.00,'2022-09-14 09:53:33','',''),(2614499,'5','182','953',426,'Sale Id shift 257715',0.00,0.00,0.00,480.27,0.00,'2022-09-14 09:53:33','',''),(2614500,'5','182','954',426,'Sale Id shift 257715',0.00,0.00,0.00,896.36,0.00,'2022-09-14 09:53:33','',''),(2614501,'5','182',NULL,426,'Sale Id shift 257715',345002.80,0.00,0.00,0.00,0.00,'2022-09-14 09:53:33','',''),(2614502,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,8269500.00,44700.00,0.00,0.00,'2022-09-17 12:42:26','',''),(2614503,'5','182',NULL,426,'Reception corrector for bridging 130851',0.00,0.00,0.00,30350.00,0.00,'2022-09-17 15:46:37','',''),(2614504,'5','182','953',426,'Received from bridging 130851',0.00,0.00,30350.00,0.00,0.00,'2022-09-17 15:46:37','',''),(2614505,'5','182',NULL,426,'Reception corrector for bridging 130852',0.00,0.00,0.00,14350.00,0.00,'2022-09-17 15:46:50','',''),(2614506,'5','182','954',426,'Received from bridging 130852',0.00,0.00,14350.00,0.00,0.00,'2022-09-17 15:46:50','',''),(2614507,'5','182','953',426,'Sale Id shift 257719',0.00,0.00,0.00,1503.12,0.00,'2022-09-18 07:22:52','',''),(2614508,'5','182','953',426,'Sale Id shift 257719',0.00,0.00,0.00,776.92,0.00,'2022-09-18 07:22:52','',''),(2614509,'5','182','954',426,'Sale Id shift 257719',0.00,0.00,0.00,754.88,0.00,'2022-09-18 07:22:52','',''),(2614510,'5','182',NULL,426,'Sale Id shift 257719',561460.20,0.00,0.00,0.00,0.00,'2022-09-18 07:22:52','',''),(2614511,'5','182','953',426,'Sale Id shift 257720',0.00,0.00,0.00,1858.29,0.00,'2022-09-19 07:21:16','',''),(2614512,'5','182','953',426,'Sale Id shift 257720',0.00,0.00,0.00,1675.46,0.00,'2022-09-19 07:21:16','',''),(2614513,'5','182','954',426,'Sale Id shift 257720',0.00,0.00,0.00,1438.37,0.00,'2022-09-19 07:21:16','',''),(2614514,'5','182',NULL,426,'Sale Id shift 257720',919842.20,0.00,0.00,0.00,0.00,'2022-09-19 07:21:16','',''),(2614515,'5','182','953',426,'Sale Id shift 257721',0.00,0.00,0.00,1964.80,0.00,'2022-09-20 08:34:50','',''),(2614516,'5','182','953',426,'Sale Id shift 257721',0.00,0.00,0.00,1454.97,0.00,'2022-09-20 08:34:50','',''),(2614517,'5','182',NULL,426,'Sale Id shift 257721',632657.45,0.00,0.00,0.00,0.00,'2022-09-20 08:34:50','',''),(2614518,'5','182','953',426,'Sale Id shift 257722',0.00,0.00,0.00,2005.42,0.00,'2022-09-21 11:52:55','',''),(2614519,'5','182','953',426,'Sale Id shift 257722',0.00,0.00,0.00,1471.18,0.00,'2022-09-21 11:52:55','',''),(2614520,'5','182','954',426,'Sale Id shift 257722',0.00,0.00,0.00,2665.76,0.00,'2022-09-21 11:52:55','',''),(2614521,'5','182',NULL,426,'Sale Id shift 257722',1136336.60,0.00,0.00,0.00,0.00,'2022-09-21 11:52:55','',''),(2614522,'5','182','953',426,'Sale Id shift 257723',0.00,0.00,0.00,2073.93,0.00,'2022-09-22 07:41:17','',''),(2614523,'5','182','953',426,'Sale Id shift 257723',0.00,0.00,0.00,1969.33,0.00,'2022-09-22 07:41:17','',''),(2614524,'5','182','954',426,'Sale Id shift 257723',0.00,0.00,0.00,1545.41,0.00,'2022-09-22 07:41:17','',''),(2614525,'5','182',NULL,426,'Sale Id shift 257723',1033903.95,0.00,0.00,0.00,0.00,'2022-09-22 07:41:17','',''),(2614526,'5','182','953',426,'Sale Id shift 257724',0.00,0.00,0.00,1910.22,0.00,'2022-09-23 07:52:10','',''),(2614527,'5','182','953',426,'Sale Id shift 257724',0.00,0.00,0.00,1233.63,0.00,'2022-09-23 07:52:10','',''),(2614528,'5','182','954',426,'Sale Id shift 257724',0.00,0.00,0.00,1103.07,0.00,'2022-09-23 07:52:10','',''),(2614529,'5','182',NULL,426,'Sale Id shift 257724',785680.20,0.00,0.00,0.00,0.00,'2022-09-23 07:52:10','',''),(2614530,'5','182','953',426,'Sale Id shift 257725',0.00,0.00,0.00,1506.12,0.00,'2022-09-23 22:42:08','',''),(2614531,'5','182','953',426,'Sale Id shift 257725',0.00,0.00,0.00,1291.89,0.00,'2022-09-23 22:42:08','',''),(2614532,'5','182','954',426,'Sale Id shift 257725',0.00,0.00,0.00,1236.55,0.00,'2022-09-23 22:42:08','',''),(2614533,'5','182',NULL,426,'Sale Id shift 257725',746393.60,0.00,0.00,0.00,0.00,'2022-09-23 22:42:08','',''),(2614534,'5','182','953',426,'Sale Id shift 257726',0.00,0.00,0.00,2220.21,0.00,'2022-09-25 08:06:26','',''),(2614535,'5','182','953',426,'Sale Id shift 257726',0.00,0.00,0.00,1850.04,0.00,'2022-09-25 08:06:26','',''),(2614536,'5','182','954',426,'Sale Id shift 257726',0.00,0.00,0.00,1561.05,0.00,'2022-09-25 08:06:26','',''),(2614537,'5','182',NULL,426,'Sale Id shift 257726',1041790.50,0.00,0.00,0.00,0.00,'2022-09-25 08:06:26','',''),(2614538,'5','182','953',426,'Sale Id shift 257727',0.00,0.00,0.00,1257.02,0.00,'2022-09-26 07:19:11','',''),(2614539,'5','182','953',426,'Sale Id shift 257727',0.00,0.00,0.00,1344.97,0.00,'2022-09-26 07:19:11','',''),(2614540,'5','182','954',426,'Sale Id shift 257727',0.00,0.00,0.00,1513.95,0.00,'2022-09-26 07:19:11','',''),(2614541,'5','182',NULL,426,'Sale Id shift 257727',761448.90,0.00,0.00,0.00,0.00,'2022-09-26 07:19:11','',''),(2614542,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,9203750.00,49750.00,0.00,0.00,'2022-09-27 11:58:21','',''),(2614543,'5','182',NULL,426,'Reception corrector for bridging 130854',0.00,0.00,0.00,18100.00,0.00,'2022-09-27 12:22:26','',''),(2614544,'5','182','954',426,'Received from bridging 130854',0.00,0.00,18100.00,0.00,0.00,'2022-09-27 12:22:26','',''),(2614545,'5','182',NULL,426,'Reception corrector for bridging 130853',0.00,0.00,0.00,31650.00,0.00,'2022-09-27 12:22:34','',''),(2614546,'5','182','953',426,'Received from bridging 130853',0.00,0.00,31650.00,0.00,0.00,'2022-09-27 12:22:34','',''),(2614547,'5','182','953',426,'Sale Id shift 257728',0.00,0.00,0.00,439.85,0.00,'2022-09-27 12:25:18','',''),(2614548,'5','182','954',426,'Sale Id shift 257728',0.00,0.00,0.00,3123.37,0.00,'2022-09-27 12:25:18','',''),(2614549,'5','182',NULL,426,'Sale Id shift 257728',659195.70,0.00,0.00,0.00,0.00,'2022-09-27 12:25:18','',''),(2614550,'5','182','953',426,'Sale Id shift 257729',0.00,0.00,0.00,1401.41,0.00,'2022-09-28 08:24:46','',''),(2614551,'5','182','953',426,'Sale Id shift 257729',0.00,0.00,0.00,910.80,0.00,'2022-09-28 08:24:46','',''),(2614552,'5','182','954',426,'Sale Id shift 257729',0.00,0.00,0.00,1082.24,0.00,'2022-09-28 08:24:46','',''),(2614553,'5','182',NULL,426,'Sale Id shift 257729',627973.25,0.00,0.00,0.00,0.00,'2022-09-28 08:24:46','',''),(2614554,'5','182','953',426,'Sale Id shift 257730',0.00,0.00,0.00,2092.62,0.00,'2022-09-29 08:37:33','',''),(2614555,'5','182','953',426,'Sale Id shift 257730',0.00,0.00,0.00,1404.32,0.00,'2022-09-29 08:37:33','',''),(2614556,'5','182','954',426,'Sale Id shift 257730',0.00,0.00,0.00,1258.64,0.00,'2022-09-29 08:37:33','',''),(2614557,'5','182',NULL,426,'Sale Id shift 257730',879782.30,0.00,0.00,0.00,0.00,'2022-09-29 08:37:33','',''),(2614558,'5','182','953',426,'Sale Id shift 257731',0.00,0.00,0.00,2695.18,0.00,'2022-09-30 08:12:15','',''),(2614559,'5','182','953',426,'Sale Id shift 257731',0.00,0.00,0.00,2000.97,0.00,'2022-09-30 08:12:15','',''),(2614560,'5','182','954',426,'Sale Id shift 257731',0.00,0.00,0.00,1931.29,0.00,'2022-09-30 08:12:15','',''),(2614561,'5','182',NULL,426,'Sale Id shift 257731',1226076.40,0.00,0.00,0.00,0.00,'2022-09-30 08:12:15','',''),(2614562,'5','182','953',426,'Sale Id shift 257732',0.00,0.00,0.00,2522.79,0.00,'2022-09-30 21:44:54','',''),(2614563,'5','182','953',426,'Sale Id shift 257732',0.00,0.00,0.00,1938.99,0.00,'2022-09-30 21:44:54','',''),(2614564,'5','182','954',426,'Sale Id shift 257732',0.00,0.00,0.00,1721.67,0.00,'2022-09-30 21:44:54','',''),(2614565,'5','182',NULL,426,'Sale Id shift 257732',1143938.25,0.00,0.00,0.00,0.00,'2022-09-30 21:44:54','',''),(2614566,'5','182','953',426,'Sale Id shift 257733',0.00,0.00,0.00,3187.91,0.00,'2022-10-02 06:44:44','',''),(2614567,'5','182','953',426,'Sale Id shift 257733',0.00,0.00,0.00,2203.72,0.00,'2022-10-02 06:44:44','',''),(2614568,'5','182','954',426,'Sale Id shift 257733',0.00,0.00,0.00,2180.86,0.00,'2022-10-02 06:44:44','',''),(2614569,'5','182',NULL,426,'Sale Id shift 257733',1400910.65,0.00,0.00,0.00,0.00,'2022-10-02 06:44:44','',''),(2614570,'5','182','953',426,'Sale Id shift 257734',0.00,0.00,0.00,2609.28,0.00,'2022-10-03 06:26:24','',''),(2614571,'5','182','953',426,'Sale Id shift 257734',0.00,0.00,0.00,2101.85,0.00,'2022-10-03 06:26:24','',''),(2614572,'5','182','954',426,'Sale Id shift 257734',0.00,0.00,0.00,1836.86,0.00,'2022-10-03 06:26:24','',''),(2614573,'5','182',NULL,426,'Sale Id shift 257734',1211378.15,0.00,0.00,0.00,0.00,'2022-10-03 06:26:24','',''),(2614574,'5','182','953',426,'Sale Id shift 257735',0.00,0.00,0.00,1019.80,0.00,'2022-10-04 07:13:16','',''),(2614575,'5','182','953',426,'Sale Id shift 257735',0.00,0.00,0.00,2538.07,0.00,'2022-10-04 07:13:16','',''),(2614576,'5','182','954',426,'Sale Id shift 257735',0.00,0.00,0.00,2722.04,0.00,'2022-10-04 07:13:16','',''),(2614577,'5','182',NULL,426,'Sale Id shift 257735',1161783.35,0.00,0.00,0.00,0.00,'2022-10-04 07:13:16','',''),(2614578,'5','182','953',426,'Sale Id shift 257736',0.00,0.00,0.00,2929.72,0.00,'2022-10-05 09:41:34','',''),(2614579,'5','182','954',426,'Sale Id shift 257736',0.00,0.00,0.00,1966.52,0.00,'2022-10-05 09:41:34','',''),(2614580,'5','182','954',426,'Sale Id shift 257736',0.00,0.00,0.00,154.20,0.00,'2022-10-05 09:41:34','',''),(2614581,'5','182',NULL,426,'Sale Id shift 257736',934331.40,0.00,0.00,0.00,0.00,'2022-10-05 09:41:34','',''),(2614582,'5','182','954',0,'Tank level zero out for dipping',0.00,0.00,0.00,2956.91,0.00,'2022-10-06 11:36:55','',''),(2614583,'5','182','954',0,'Inventory adjustment from tank dipping to 3500',0.00,0.00,3500.00,0.00,0.00,'2022-10-06 11:36:55','',''),(2614584,'5','182','954',426,'Sale Id shift 257737',0.00,0.00,0.00,3046.12,0.00,'2022-10-06 11:50:00','',''),(2614585,'5','182',NULL,426,'Sale Id shift 257737',563532.20,0.00,0.00,0.00,0.00,'2022-10-06 11:50:00','',''),(2614586,'5','182','954',426,'Sale Id shift 257740',0.00,0.00,0.00,220.49,0.00,'2022-10-09 08:33:44','',''),(2614587,'5','182',NULL,426,'Sale Id shift 257740',40790.65,0.00,0.00,0.00,0.00,'2022-10-09 08:33:44','',''),(2614588,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-11-20 20:32:24','',''),(2614589,'5','182',NULL,426,'Reception corrector for bridging 130855',0.00,0.00,0.00,15000.00,0.00,'2022-11-20 21:01:36','',''),(2614590,'5','182','953',426,'Received from bridging 130855',0.00,0.00,15000.00,0.00,0.00,'2022-11-20 21:01:36','',''),(2614591,'5','182','953',426,'Sale Id shift 257783',0.00,0.00,0.00,3024.71,0.00,'2022-11-21 06:39:44','',''),(2614592,'5','182',NULL,426,'Sale Id shift 257783',559571.35,0.00,0.00,0.00,0.00,'2022-11-21 06:39:44','',''),(2614593,'5','182','953',426,'Sale Id shift 257784',0.00,0.00,0.00,2608.45,0.00,'2022-11-22 09:24:28','',''),(2614594,'5','182','953',426,'Sale Id shift 257784',0.00,0.00,0.00,2564.00,0.00,'2022-11-22 09:24:28','',''),(2614595,'5','182',NULL,426,'Sale Id shift 257784',956903.25,0.00,0.00,0.00,0.00,'2022-11-22 09:24:28','',''),(2614596,'5','182','953',426,'Sale Id shift 257785',0.00,0.00,0.00,4737.83,0.00,'2022-11-23 07:23:57','',''),(2614597,'5','182',NULL,426,'Sale Id shift 257785',876498.55,0.00,0.00,0.00,0.00,'2022-11-23 07:23:57','',''),(2614598,'5','182','953',426,'Sale Id shift 257786',0.00,0.00,0.00,2099.98,0.00,'2022-11-24 13:08:51','',''),(2614599,'5','182',NULL,426,'Sale Id shift 257786',388496.30,0.00,0.00,0.00,0.00,'2022-11-24 13:08:51','',''),(2614600,'5','182',NULL,426,'Purchased from SALBAS OIL & GAS LIMITED',0.00,2867500.00,15500.00,0.00,0.00,'2022-11-26 18:43:15','',''),(2614601,'5','182',NULL,426,'Reception corrector for bridging 130856',0.00,0.00,0.00,15500.00,0.00,'2022-11-26 19:13:50','',''),(2614602,'5','182','953',426,'Received from bridging 130856',0.00,0.00,15500.00,0.00,0.00,'2022-11-26 19:13:50','',''),(2614603,'5','182','953',426,'Sale Id shift 257789',0.00,0.00,0.00,1827.97,0.00,'2022-11-27 08:34:53','',''),(2614604,'5','182','953',426,'Sale Id shift 257789',0.00,0.00,0.00,1711.99,0.00,'2022-11-27 08:34:53','',''),(2614605,'5','182',NULL,426,'Sale Id shift 257789',654892.60,0.00,0.00,0.00,0.00,'2022-11-27 08:34:53','',''),(2614606,'5','182','953',426,'Sale Id shift 257790',0.00,0.00,0.00,2965.74,0.00,'2022-11-28 07:55:44','',''),(2614607,'5','182','953',426,'Sale Id shift 257790',0.00,0.00,0.00,1804.61,0.00,'2022-11-28 07:55:44','',''),(2614608,'5','182',NULL,426,'Sale Id shift 257790',882514.75,0.00,0.00,0.00,0.00,'2022-11-28 07:55:44','',''),(2614609,'5','182','953',426,'Sale Id shift 257791',0.00,0.00,0.00,4366.67,0.00,'2022-11-29 08:05:42','',''),(2614610,'5','182',NULL,426,'Sale Id shift 257791',807833.95,0.00,0.00,0.00,0.00,'2022-11-29 08:05:42','',''),(2614611,'5','182','953',426,'Sale Id shift 257792',0.00,0.00,0.00,2704.23,0.00,'2022-11-29 19:18:23','',''),(2614612,'5','182','953',426,'Sale Id shift 257792',0.00,0.00,0.00,156.22,0.00,'2022-11-29 19:18:23','',''),(2614613,'5','182',NULL,426,'Sale Id shift 257792',529183.25,0.00,0.00,0.00,0.00,'2022-11-29 19:18:23','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','182',428,0.00,'2023-03-06 22:04:50'),(2,'5','182',427,349.21,'2023-03-06 22:04:50'),(3,'5','182',426,44756.98,'2023-03-06 22:04:50');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1775791 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (997817,'5','182',427,'Sale Id shift 210889',0.00,24564.65,295.00,24564.65,0.00,'2021-07-16 17:29:23'),(998245,'5','182',427,'Sale Id shift 210911',0.00,25948.20,295.00,25948.20,0.00,'2021-07-17 07:10:01'),(1002451,'5','182',427,'Sale Id shift 210974',0.00,7873.55,295.00,7873.55,0.00,'2021-07-17 22:28:35'),(1012405,'5','182',427,'Sale Id shift 211196',0.00,14396.00,295.00,14396.00,0.00,'2021-07-20 16:49:04'),(1012577,'5','182',427,'Sale Id shift 211749',0.00,13879.75,295.00,13879.75,0.00,'2021-07-21 05:39:28'),(1016743,'5','182',427,'Sale Id shift 211978',0.00,20797.50,295.00,20797.50,0.00,'2021-07-22 09:23:36'),(1021837,'5','182',427,'Sale Id shift 212053',0.00,27110.50,295.00,27110.50,0.00,'2021-07-23 16:21:28'),(1022369,'5','182',427,'Sale Id shift 212421',0.00,137157.30,295.00,137157.30,0.00,'2021-07-24 06:33:49'),(1033281,'5','182',426,'Sale Id shift 212714',0.00,325942.65,165.00,325942.65,0.00,'2021-07-27 10:21:33'),(1033282,'5','182',427,'Sale Id shift 212714',0.00,217698.20,295.00,217698.20,0.00,'2021-07-27 10:21:33'),(1033583,'5','182',426,'Sale Id shift 213247',0.00,507320.55,165.00,507320.55,0.00,'2021-07-27 11:12:37'),(1033584,'5','182',427,'Sale Id shift 213247',0.00,753362.15,295.00,753362.15,0.00,'2021-07-27 11:12:37'),(1033778,'5','182',426,'Sale Id shift 213259',0.00,433351.05,165.00,433351.05,0.00,'2021-07-27 11:50:01'),(1036010,'5','182',426,'Sale Id shift 213270',0.00,399938.55,165.00,399938.55,0.00,'2021-07-27 22:14:23'),(1039336,'5','182',426,'Sale Id shift 213446',0.00,410619.00,165.00,410619.00,0.00,'2021-07-29 04:46:10'),(1043343,'5','182',426,'Sale Id shift 213733',0.00,533032.50,165.00,533032.50,0.00,'2021-07-30 06:19:35'),(1050451,'5','182',426,'Sale Id shift 213991',0.00,421662.45,165.00,421662.45,0.00,'2021-07-31 15:13:02'),(1051459,'5','182',426,'Sale Id shift 214303',0.00,526904.40,165.00,526904.40,0.00,'2021-08-01 06:27:54'),(1055137,'5','182',426,'Sale Id shift 214496',0.00,530950.20,165.00,530950.20,0.00,'2021-08-02 06:17:15'),(1059980,'5','182',426,'Sale Id shift 214535',0.00,290419.80,165.00,290419.80,0.00,'2021-08-03 08:18:20'),(1067434,'5','182',426,'Sale Id shift 214879',0.00,579760.50,165.00,579760.50,0.00,'2021-08-05 06:54:23'),(1069279,'5','182',426,'Sale Id shift 215299',0.00,470962.80,165.00,470962.80,0.00,'2021-08-05 13:59:13'),(1070553,'5','182',426,'Sale Id shift 215367',0.00,433776.75,165.00,433776.75,0.00,'2021-08-06 00:13:11'),(1078736,'5','182',426,'Sale Id shift 215450',0.00,466247.10,165.00,466247.10,0.00,'2021-08-07 19:20:11'),(1078737,'5','182',427,'Sale Id shift 215450',0.00,188861.95,295.00,188861.95,0.00,'2021-08-07 19:20:11'),(1078870,'5','182',426,'Sale Id shift 215883',0.00,413996.55,165.00,413996.55,0.00,'2021-08-08 06:23:18'),(1078871,'5','182',427,'Sale Id shift 215883',0.00,39515.25,295.00,39515.25,0.00,'2021-08-08 06:23:18'),(1082592,'5','182',426,'Sale Id shift 215923',0.00,435713.85,165.00,435713.85,0.00,'2021-08-08 22:23:17'),(1082593,'5','182',427,'Sale Id shift 215923',0.00,71038.95,295.00,71038.95,0.00,'2021-08-08 22:23:17'),(1086663,'5','182',426,'Sale Id shift 216157',0.00,490650.60,165.00,490650.60,0.00,'2021-08-10 05:43:52'),(1086664,'5','182',427,'Sale Id shift 216157',0.00,23747.50,295.00,23747.50,0.00,'2021-08-10 05:43:52'),(1090439,'5','182',426,'Sale Id shift 216316',0.00,435537.30,165.00,435537.30,0.00,'2021-08-11 05:33:17'),(1090440,'5','182',427,'Sale Id shift 216316',0.00,21080.70,295.00,21080.70,0.00,'2021-08-11 05:33:17'),(1093618,'5','182',426,'Sale Id shift 216553',0.00,374393.25,165.00,374393.25,0.00,'2021-08-12 05:19:05'),(1093619,'5','182',427,'Sale Id shift 216553',0.00,23591.15,295.00,23591.15,0.00,'2021-08-12 05:19:05'),(1097089,'5','182',426,'Sale Id shift 216782',0.00,460808.70,165.00,460808.70,0.00,'2021-08-13 06:35:34'),(1097090,'5','182',427,'Sale Id shift 216782',0.00,9979.85,295.00,9979.85,0.00,'2021-08-13 06:35:34'),(1101350,'5','182',426,'Sale Id shift 217023',0.00,440789.25,165.00,440789.25,0.00,'2021-08-14 06:52:38'),(1101351,'5','182',427,'Sale Id shift 217023',0.00,25815.45,295.00,25815.45,0.00,'2021-08-14 06:52:38'),(1109649,'5','182',426,'Sale Id shift 217297',0.00,399877.50,165.00,399877.50,0.00,'2021-08-15 18:19:43'),(1109650,'5','182',427,'Sale Id shift 217297',0.00,47784.10,295.00,47784.10,0.00,'2021-08-15 18:19:43'),(1109760,'5','182',426,'Sale Id shift 217652',0.00,506703.45,165.00,506703.45,0.00,'2021-08-15 21:01:53'),(1109761,'5','182',427,'Sale Id shift 217652',0.00,74399.00,295.00,74399.00,0.00,'2021-08-15 21:01:53'),(1113634,'5','182',426,'Sale Id shift 217733',0.00,652340.70,165.00,652340.70,0.00,'2021-08-16 22:47:54'),(1113635,'5','182',427,'Sale Id shift 217733',0.00,73505.15,295.00,73505.15,0.00,'2021-08-16 22:47:54'),(1117550,'5','182',426,'Sale Id shift 218018',0.00,542567.85,165.00,542567.85,0.00,'2021-08-18 05:54:08'),(1117551,'5','182',427,'Sale Id shift 218018',0.00,61262.65,295.00,61262.65,0.00,'2021-08-18 05:54:08'),(1140241,'5','182',426,'Sale Id shift 218257',0.00,615908.70,165.00,615908.70,0.00,'2021-08-23 15:05:18'),(1140242,'5','182',427,'Sale Id shift 218257',0.00,36984.15,295.00,36984.15,0.00,'2021-08-23 15:05:18'),(1140273,'5','182',426,'Sale Id shift 219519',0.00,643688.10,165.00,643688.10,0.00,'2021-08-23 15:10:53'),(1140274,'5','182',427,'Sale Id shift 219519',0.00,48155.80,295.00,48155.80,0.00,'2021-08-23 15:10:53'),(1140363,'5','182',426,'Sale Id shift 219521',0.00,307454.40,165.00,307454.40,0.00,'2021-08-23 15:28:49'),(1140364,'5','182',427,'Sale Id shift 219521',0.00,9968.05,295.00,9968.05,0.00,'2021-08-23 15:28:49'),(1140554,'5','182',427,'Sale Id shift 219527',0.00,12773.50,295.00,12773.50,0.00,'2021-08-23 15:57:30'),(1140640,'5','182',427,'Sale Id shift 219533',0.00,15891.65,295.00,15891.65,0.00,'2021-08-23 16:10:47'),(1141230,'5','182',427,'Sale Id shift 219561',0.00,12953.45,295.00,12953.45,0.00,'2021-08-23 22:32:26'),(1144980,'5','182',426,'Sale Id shift 219615',0.00,444676.65,165.00,444676.65,0.00,'2021-08-24 22:15:16'),(1144981,'5','182',427,'Sale Id shift 219615',0.00,6557.85,295.00,6557.85,0.00,'2021-08-24 22:15:16'),(1148794,'5','182',426,'Sale Id shift 219853',0.00,590084.55,165.00,590084.55,0.00,'2021-08-25 21:31:01'),(1148795,'5','182',427,'Sale Id shift 219853',0.00,24741.65,295.00,24741.65,0.00,'2021-08-25 21:31:01'),(1152647,'5','182',426,'Sale Id shift 220076',0.00,456414.75,165.00,456414.75,0.00,'2021-08-27 06:58:23'),(1152648,'5','182',427,'Sale Id shift 220076',0.00,22060.10,295.00,22060.10,0.00,'2021-08-27 06:58:23'),(1156000,'5','182',426,'Sale Id shift 220374',0.00,513550.95,165.00,513550.95,0.00,'2021-08-28 06:35:56'),(1156001,'5','182',427,'Sale Id shift 220374',0.00,61802.50,295.00,61802.50,0.00,'2021-08-28 06:35:56'),(1159809,'5','182',426,'Sale Id shift 220484',0.00,379227.75,165.00,379227.75,0.00,'2021-08-29 06:57:01'),(1159810,'5','182',427,'Sale Id shift 220484',0.00,15446.20,295.00,15446.20,0.00,'2021-08-29 06:57:01'),(1164017,'5','182',426,'Sale Id shift 220748',0.00,437669.10,165.00,437669.10,0.00,'2021-08-30 04:42:33'),(1164018,'5','182',427,'Sale Id shift 220748',0.00,39798.45,295.00,39798.45,0.00,'2021-08-30 04:42:33'),(1221410,'5','182',426,'Sale Id shift 220922',0.00,441111.00,165.00,441111.00,0.00,'2021-09-15 11:21:41'),(1221411,'5','182',427,'Sale Id shift 220922',0.00,25187.10,295.00,25187.10,0.00,'2021-09-15 11:21:41'),(1221807,'5','182',426,'Sale Id shift 224655',0.00,540970.65,165.00,540970.65,0.00,'2021-09-15 12:34:13'),(1221808,'5','182',427,'Sale Id shift 224655',0.00,64395.55,295.00,64395.55,0.00,'2021-09-15 12:34:13'),(1221913,'5','182',426,'Sale Id shift 224660',0.00,511777.20,165.00,511777.20,0.00,'2021-09-15 12:53:51'),(1221914,'5','182',427,'Sale Id shift 224660',0.00,41149.55,295.00,41149.55,0.00,'2021-09-15 12:53:51'),(1221961,'5','182',426,'Sale Id shift 224667',0.00,381986.55,165.00,381986.55,0.00,'2021-09-15 13:05:43'),(1221962,'5','182',427,'Sale Id shift 224667',0.00,66439.90,295.00,66439.90,0.00,'2021-09-15 13:05:43'),(1222023,'5','182',426,'Sale Id shift 224674',0.00,411721.20,165.00,411721.20,0.00,'2021-09-15 13:18:25'),(1222024,'5','182',427,'Sale Id shift 224674',0.00,62360.05,295.00,62360.05,0.00,'2021-09-15 13:18:25'),(1222067,'5','182',426,'Sale Id shift 224679',0.00,339383.55,165.00,339383.55,0.00,'2021-09-15 13:27:48'),(1222068,'5','182',427,'Sale Id shift 224679',0.00,86880.45,295.00,86880.45,0.00,'2021-09-15 13:27:48'),(1222106,'5','182',426,'Sale Id shift 224681',0.00,355030.50,165.00,355030.50,0.00,'2021-09-15 13:37:01'),(1222107,'5','182',427,'Sale Id shift 224681',0.00,36954.65,295.00,36954.65,0.00,'2021-09-15 13:37:01'),(1222130,'5','182',426,'Sale Id shift 224686',0.00,399649.80,165.00,399649.80,0.00,'2021-09-15 13:41:35'),(1222131,'5','182',427,'Sale Id shift 224686',0.00,24021.85,295.00,24021.85,0.00,'2021-09-15 13:41:35'),(1222318,'5','182',426,'Sale Id shift 224689',0.00,283247.25,165.00,283247.25,0.00,'2021-09-15 14:14:00'),(1222319,'5','182',427,'Sale Id shift 224689',0.00,28408.50,295.00,28408.50,0.00,'2021-09-15 14:14:00'),(1222346,'5','182',426,'Sale Id shift 224696',0.00,467027.55,165.00,467027.55,0.00,'2021-09-15 14:19:38'),(1222347,'5','182',427,'Sale Id shift 224696',0.00,64495.85,295.00,64495.85,0.00,'2021-09-15 14:19:38'),(1222382,'5','182',426,'Sale Id shift 224701',0.00,358330.50,165.00,358330.50,0.00,'2021-09-15 14:26:40'),(1222383,'5','182',427,'Sale Id shift 224701',0.00,47834.25,295.00,47834.25,0.00,'2021-09-15 14:26:40'),(1222423,'5','182',426,'Sale Id shift 224703',0.00,349938.60,165.00,349938.60,0.00,'2021-09-15 14:34:24'),(1222424,'5','182',427,'Sale Id shift 224703',0.00,73944.70,295.00,73944.70,0.00,'2021-09-15 14:34:24'),(1222460,'5','182',426,'Sale Id shift 224704',0.00,260815.50,165.00,260815.50,0.00,'2021-09-15 14:40:49'),(1222461,'5','182',427,'Sale Id shift 224704',0.00,73236.70,295.00,73236.70,0.00,'2021-09-15 14:40:49'),(1222523,'5','182',426,'Sale Id shift 224707',0.00,270898.65,165.00,270898.65,0.00,'2021-09-15 14:55:52'),(1222524,'5','182',427,'Sale Id shift 224707',0.00,32163.85,295.00,32163.85,0.00,'2021-09-15 14:55:52'),(1222608,'5','182',426,'Sale Id shift 224712',0.00,342789.15,165.00,342789.15,0.00,'2021-09-15 15:19:00'),(1222609,'5','182',427,'Sale Id shift 224712',0.00,50356.50,295.00,50356.50,0.00,'2021-09-15 15:19:00'),(1222638,'5','182',426,'Sale Id shift 224717',0.00,366484.80,165.00,366484.80,0.00,'2021-09-15 15:24:43'),(1222639,'5','182',427,'Sale Id shift 224717',0.00,66584.45,295.00,66584.45,0.00,'2021-09-15 15:24:43'),(1229739,'5','182',426,'Sale Id shift 225177',0.00,290565.00,163.00,287043.00,-3522.00,'2021-09-17 14:44:42'),(1229740,'5','182',427,'Sale Id shift 225177',0.00,122616.75,295.00,122616.75,0.00,'2021-09-17 14:44:42'),(1229900,'5','182',426,'Sale Id shift 225182',0.00,309647.25,163.00,305893.95,-3753.30,'2021-09-17 15:16:57'),(1229901,'5','182',427,'Sale Id shift 225182',0.00,63953.05,295.00,63953.05,0.00,'2021-09-17 15:16:57'),(1247939,'5','182',426,'Sale Id shift 225194',0.00,319692.45,163.00,315817.39,-3875.06,'2021-09-23 12:13:14'),(1247940,'5','182',427,'Sale Id shift 225194',0.00,82788.80,295.00,82788.80,0.00,'2021-09-23 12:13:14'),(1247974,'5','182',426,'Sale Id shift 226600',0.00,381326.55,163.00,376704.41,-4622.14,'2021-09-23 12:21:06'),(1247975,'5','182',427,'Sale Id shift 226600',0.00,210801.10,295.00,210801.10,0.00,'2021-09-23 12:21:06'),(1248094,'5','182',426,'Sale Id shift 226601',0.00,328112.40,163.00,324135.28,-3977.12,'2021-09-23 12:40:52'),(1248095,'5','182',427,'Sale Id shift 226601',0.00,63534.15,295.00,63534.15,0.00,'2021-09-23 12:40:52'),(1248125,'5','182',426,'Sale Id shift 226606',0.00,420995.85,163.00,415892.87,-5102.98,'2021-09-23 12:47:06'),(1248126,'5','182',427,'Sale Id shift 226606',0.00,71283.80,295.00,71283.80,0.00,'2021-09-23 12:47:06'),(1248386,'5','182',426,'Sale Id shift 226611',0.00,381171.45,163.00,376551.19,-4620.26,'2021-09-23 13:42:58'),(1248387,'5','182',427,'Sale Id shift 226611',0.00,197726.70,295.00,197726.70,0.00,'2021-09-23 13:42:58'),(1248417,'5','182',426,'Sale Id shift 226630',0.00,320362.35,163003.00,316484994.77,316164632.42,'2021-09-23 13:48:35'),(1248418,'5','182',427,'Sale Id shift 226630',0.00,216249.75,295.00,216249.75,0.00,'2021-09-23 13:48:35'),(1318907,'5','182',427,'Sale Id shift 231730',0.00,90999.00,300.00,90999.00,0.00,'2021-10-15 10:29:38'),(1318950,'5','182',427,'Sale Id shift 231734',0.00,176172.00,300.00,176172.00,0.00,'2021-10-15 10:38:43'),(1319010,'5','182',427,'Sale Id shift 231739',0.00,71733.00,300.00,71733.00,0.00,'2021-10-15 10:52:23'),(1319036,'5','182',427,'Sale Id shift 231741',0.00,60663.00,300.00,60663.00,0.00,'2021-10-15 10:58:10'),(1319101,'5','182',427,'Sale Id shift 231743',0.00,99744.00,310.00,103068.80,3324.80,'2021-10-15 11:12:55'),(1319115,'5','182',427,'Sale Id shift 231744',0.00,53538.00,310.00,55322.60,1784.60,'2021-10-15 11:17:37'),(1319129,'5','182',427,'Sale Id shift 231748',0.00,85494.00,310.00,88343.80,2849.80,'2021-10-15 11:21:33'),(1319139,'5','182',427,'Sale Id shift 231752',0.00,108666.00,310.00,112288.20,3622.20,'2021-10-15 11:25:07'),(1319165,'5','182',427,'Sale Id shift 231754',0.00,52740.00,310.00,54498.00,1758.00,'2021-10-15 11:29:37'),(1319189,'5','182',427,'Sale Id shift 231757',0.00,40428.00,310.00,41775.60,1347.60,'2021-10-15 11:33:54'),(1319204,'5','182',427,'Sale Id shift 231760',0.00,41649.00,310.00,43037.30,1388.30,'2021-10-15 11:37:54'),(1319249,'5','182',427,'Sale Id shift 231764',0.00,81090.00,320.00,86496.00,5406.00,'2021-10-15 11:46:03'),(1319306,'5','182',426,'Sale Id shift 231765',0.00,186636.63,163.00,186636.63,0.00,'2021-10-15 12:00:46'),(1319307,'5','182',427,'Sale Id shift 231765',0.00,224475.00,320.00,239440.00,14965.00,'2021-10-15 12:00:46'),(1319335,'5','182',426,'Sale Id shift 231770',0.00,263031.47,163.00,263031.47,0.00,'2021-10-15 12:07:18'),(1319336,'5','182',427,'Sale Id shift 231770',0.00,80037.00,320.00,85372.80,5335.80,'2021-10-15 12:07:18'),(1328226,'5','182',426,'Sale Id shift 231782',0.00,317507.70,163.00,317507.70,0.00,'2021-10-18 09:55:04'),(1328227,'5','182',427,'Sale Id shift 231782',0.00,178449.00,320.00,190345.60,11896.60,'2021-10-18 09:55:04'),(1328304,'5','182',426,'Sale Id shift 232418',0.00,290591.51,163.00,290591.51,0.00,'2021-10-18 10:08:35'),(1328305,'5','182',427,'Sale Id shift 232418',0.00,509601.00,320.00,543574.40,33973.40,'2021-10-18 10:08:35'),(1328333,'5','182',426,'Sale Id shift 232421',0.00,530108.60,163.00,530108.60,0.00,'2021-10-18 10:12:56'),(1328334,'5','182',427,'Sale Id shift 232421',0.00,158517.00,320.00,169084.80,10567.80,'2021-10-18 10:12:56'),(1334759,'5','182',426,'Sale Id shift 232435',0.00,609986.75,163.00,609986.75,0.00,'2021-10-20 09:15:43'),(1334760,'5','182',427,'Sale Id shift 232435',0.00,130413.00,327.00,142150.17,11737.17,'2021-10-20 09:15:43'),(1334880,'5','182',426,'Sale Id shift 232919',0.00,522918.67,163.00,522918.67,0.00,'2021-10-20 09:38:17'),(1334881,'5','182',427,'Sale Id shift 232919',0.00,300870.00,327.00,327948.30,27078.30,'2021-10-20 09:38:17'),(1338641,'5','182',426,'Sale Id shift 232930',0.00,690477.78,163.00,690477.78,0.00,'2021-10-21 09:59:03'),(1338642,'5','182',427,'Sale Id shift 232930',0.00,352197.00,330.00,387416.70,35219.70,'2021-10-21 09:59:03'),(1342384,'5','182',426,'Sale Id shift 233199',0.00,541673.45,163.00,541673.45,0.00,'2021-10-22 10:57:04'),(1342385,'5','182',427,'Sale Id shift 233199',0.00,240249.00,345.00,276286.35,36037.35,'2021-10-22 10:57:04'),(1352471,'5','182',426,'Sale Id shift 233476',0.00,440471.64,163.00,440471.64,0.00,'2021-10-25 10:12:10'),(1352472,'5','182',427,'Sale Id shift 233476',0.00,75072.00,345.00,86332.80,11260.80,'2021-10-25 10:12:10'),(1352543,'5','182',426,'Sale Id shift 234152',0.00,396769.71,163.00,396769.71,0.00,'2021-10-25 10:28:39'),(1352544,'5','182',427,'Sale Id shift 234152',0.00,119193.00,345.00,137071.95,17878.95,'2021-10-25 10:28:39'),(1352574,'5','182',426,'Sale Id shift 234154',0.00,387873.17,163.00,387873.17,0.00,'2021-10-25 10:39:43'),(1352575,'5','182',427,'Sale Id shift 234154',0.00,28440.00,345.00,32706.00,4266.00,'2021-10-25 10:39:43'),(1355561,'5','182',426,'Sale Id shift 234158',0.00,606645.25,163.00,606645.25,0.00,'2021-10-26 09:01:22'),(1355562,'5','182',427,'Sale Id shift 234158',0.00,40095.00,345.00,46109.25,6014.25,'2021-10-26 09:01:22'),(1359206,'5','182',426,'Sale Id shift 234381',0.00,468551.65,165.00,474300.75,5749.10,'2021-10-27 10:05:04'),(1359207,'5','182',427,'Sale Id shift 234381',0.00,102111.00,345.00,117427.65,15316.65,'2021-10-27 10:05:04'),(1362738,'5','182',426,'Sale Id shift 234675',0.00,571536.68,165.00,578549.40,7012.72,'2021-10-28 09:50:45'),(1362739,'5','182',427,'Sale Id shift 234675',0.00,41988.00,345.00,48286.20,6298.20,'2021-10-28 09:50:45'),(1409474,'5','182',426,'Sale Id shift 234936',0.00,398870.78,165.00,403764.90,4894.12,'2021-11-09 14:08:06'),(1409475,'5','182',427,'Sale Id shift 234936',0.00,272031.00,345.00,312835.65,40804.65,'2021-11-09 14:08:06'),(1409532,'5','182',426,'Sale Id shift 237758',0.00,263175.00,165.00,263175.00,0.00,'2021-11-09 14:15:11'),(1409533,'5','182',427,'Sale Id shift 237758',0.00,151266.00,345.00,173955.90,22689.90,'2021-11-09 14:15:11'),(1409581,'5','182',426,'Sale Id shift 237764',0.00,703177.20,165.00,703177.20,0.00,'2021-11-09 14:21:50'),(1409582,'5','182',427,'Sale Id shift 237764',0.00,69306.00,345.00,79701.90,10395.90,'2021-11-09 14:21:50'),(1409618,'5','182',426,'Sale Id shift 237767',0.00,858871.20,165.00,858871.20,0.00,'2021-11-09 14:26:30'),(1409619,'5','182',427,'Sale Id shift 237767',0.00,16533.00,345.00,19012.95,2479.95,'2021-11-09 14:26:30'),(1409652,'5','182',426,'Sale Id shift 237768',0.00,1608779.70,165.00,1608779.70,0.00,'2021-11-09 14:31:20'),(1409653,'5','182',427,'Sale Id shift 237768',0.00,181344.00,345.00,208545.60,27201.60,'2021-11-09 14:31:20'),(1409682,'5','182',426,'Sale Id shift 237769',0.00,2702353.50,165.00,2702353.50,0.00,'2021-11-09 14:35:49'),(1409683,'5','182',427,'Sale Id shift 237769',0.00,311205.00,345.00,357885.75,46680.75,'2021-11-09 14:35:49'),(1412541,'5','182',426,'Sale Id shift 237770',0.00,1880605.65,165.00,1880605.65,0.00,'2021-11-10 09:48:43'),(1412542,'5','182',427,'Sale Id shift 237770',0.00,184404.00,345.00,212064.60,27660.60,'2021-11-10 09:48:43'),(1412558,'5','182',427,'Sale Id shift 237959',0.00,150000.00,345.00,172500.00,22500.00,'2021-11-10 09:50:46'),(1412567,'5','182',427,'Sale Id shift 237960',0.00,104673.00,345.00,120373.95,15700.95,'2021-11-10 09:52:16'),(1412577,'5','182',427,'Sale Id shift 237962',0.00,63735.00,345.00,73295.25,9560.25,'2021-11-10 09:54:23'),(1412594,'5','182',427,'Sale Id shift 237963',0.00,150051.00,345.00,172558.65,22507.65,'2021-11-10 09:56:22'),(1412605,'5','182',427,'Sale Id shift 237965',0.00,84876.00,345.00,97607.40,12731.40,'2021-11-10 09:58:18'),(1412617,'5','182',427,'Sale Id shift 237968',0.00,188025.00,345.00,216228.75,28203.75,'2021-11-10 10:00:08'),(1418761,'5','182',427,'Sale Id shift 237969',0.00,135540.00,345.00,155871.00,20331.00,'2021-11-11 13:04:45'),(1436340,'5','182',427,'Sale Id shift 239138',0.00,72189.00,345.00,83017.35,10828.35,'2021-11-15 09:42:33'),(1436360,'5','182',427,'Sale Id shift 239149',0.00,83349.00,345.00,95851.35,12502.35,'2021-11-15 09:47:44'),(1439209,'5','182',426,'Sale Id shift 239164',0.00,634915.05,165.00,634915.05,0.00,'2021-11-15 19:11:11'),(1439210,'5','182',427,'Sale Id shift 239164',0.00,15000.00,345.00,17250.00,2250.00,'2021-11-15 19:11:11'),(1440685,'5','182',426,'Sale Id shift 239371',0.00,1753780.05,165.00,1753780.05,0.00,'2021-11-16 10:20:56'),(1447294,'5','182',426,'Sale Id shift 239383',0.00,1099652.40,165.00,1099652.40,0.00,'2021-11-17 18:26:42'),(1448873,'5','182',426,'Sale Id shift 239841',0.00,1142846.10,165.00,1142846.10,0.00,'2021-11-18 09:56:52'),(1448874,'5','182',427,'Sale Id shift 239841',0.00,3567.00,345.00,4102.05,535.05,'2021-11-18 09:56:52'),(1455663,'5','182',426,'Sale Id shift 240063',0.00,331580.70,165.00,331580.70,0.00,'2021-11-19 17:34:42'),(1466965,'5','182',426,'Sale Id shift 240763',0.00,946976.25,165.00,946976.25,0.00,'2021-11-22 09:41:25'),(1466966,'5','182',427,'Sale Id shift 240763',0.00,6000.00,345.00,6900.00,900.00,'2021-11-22 09:41:25'),(1467453,'5','182',426,'Sale Id shift 240777',0.00,1060852.65,165.00,1060852.65,0.00,'2021-11-22 10:57:49'),(1476172,'5','182',426,'Sale Id shift 240788',0.00,984513.75,165.00,984513.75,0.00,'2021-11-24 08:51:37'),(1477725,'5','182',426,'Sale Id shift 241317',0.00,1108461.75,165.00,1108461.75,0.00,'2021-11-24 14:10:19'),(1480774,'5','182',426,'Sale Id shift 241595',0.00,696242.25,165.00,696242.25,0.00,'2021-11-25 10:43:34'),(1480775,'5','182',427,'Sale Id shift 241595',0.00,3084.00,345.00,3546.60,462.60,'2021-11-25 10:43:34'),(1484995,'5','182',426,'Sale Id shift 241601',0.00,195244.50,165.00,195244.50,0.00,'2021-11-26 10:29:15'),(1584374,'5','182',426,'Sale Id shift 246273',0.00,233743.95,165.00,233743.95,0.00,'2021-12-16 08:39:04'),(1589808,'5','182',426,'Sale Id shift 246529',0.00,513763.80,165.00,513763.80,0.00,'2021-12-17 09:10:34'),(1589809,'5','182',427,'Sale Id shift 246529',0.00,14436.00,345.00,16601.40,2165.40,'2021-12-17 09:10:34'),(1593867,'5','182',426,'Sale Id shift 246776',0.00,424812.30,165.00,424812.30,0.00,'2021-12-18 06:53:39'),(1604500,'5','182',426,'Sale Id shift 247117',0.00,433326.30,165.00,433326.30,0.00,'2021-12-19 17:33:59'),(1604749,'5','182',426,'Sale Id shift 247354',0.00,373781.10,165.00,373781.10,0.00,'2021-12-20 06:12:59'),(1609890,'5','182',426,'Sale Id shift 247408',0.00,360289.05,165.00,360289.05,0.00,'2021-12-20 18:02:24'),(1617162,'5','182',426,'Sale Id shift 247725',0.00,99460.35,165.00,99460.35,0.00,'2021-12-22 09:54:24'),(1677058,'5','182',426,'Sale Id shift 250737',0.00,637150.80,165.00,637150.80,0.00,'2022-01-03 09:34:39'),(1681953,'5','182',426,'Sale Id shift 250878',0.00,594585.75,165.00,594585.75,0.00,'2022-01-04 08:41:21'),(1686353,'5','182',426,'Sale Id shift 251088',0.00,876166.50,165.00,876166.50,0.00,'2022-01-04 19:02:24'),(1692719,'5','182',426,'Sale Id shift 251370',0.00,568169.25,165.00,568169.25,0.00,'2022-01-06 09:24:54'),(1697164,'5','182',426,'Sale Id shift 251622',0.00,523818.90,165.00,523818.90,0.00,'2022-01-07 07:02:29'),(1712140,'5','182',426,'Sale Id shift 251832',0.00,528658.35,165.00,528658.35,0.00,'2022-01-09 15:50:52'),(1729008,'5','182',426,'Sale Id shift 252935',0.00,196734.45,165.00,196734.45,0.00,'2022-01-12 19:41:42'),(1729136,'5','182',426,'Sale Id shift 253152',0.00,634286.40,165.00,634286.40,0.00,'2022-01-13 07:30:46'),(1734171,'5','182',426,'Sale Id shift 253265',0.00,954143.85,165.00,954143.85,0.00,'2022-01-14 06:37:36'),(1740201,'5','182',426,'Sale Id shift 253516',0.00,830276.70,165.00,830276.70,0.00,'2022-01-15 09:58:13'),(1744947,'5','182',426,'Sale Id shift 253948',0.00,760277.10,165.00,760277.10,0.00,'2022-01-16 06:54:11'),(1749678,'5','182',426,'Sale Id shift 253958',0.00,1349683.50,165.00,1349683.50,0.00,'2022-01-17 07:09:26'),(1755437,'5','182',426,'Sale Id shift 254281',0.00,966147.60,165.00,966147.60,0.00,'2022-01-18 07:07:22'),(1761145,'5','182',426,'Sale Id shift 254481',0.00,560488.50,165.00,560488.50,0.00,'2022-01-19 06:04:20'),(1767517,'5','182',426,'Sale Id shift 254717',0.00,781331.10,165.00,781331.10,0.00,'2022-01-20 06:34:28'),(1775635,'5','182',426,'Sale Id shift 254947',0.00,157344.00,165.00,157344.00,0.00,'2022-01-21 11:16:06'),(1775636,'5','182',426,'Sale Id shift 257494',0.00,326467.35,165.00,326467.35,0.00,'2022-02-08 10:01:53'),(1775637,'5','182',426,'Sale Id shift 257495',0.00,753622.65,165.00,753622.65,0.00,'2022-02-08 10:06:26'),(1775638,'5','182',426,'Sale Id shift 257496',0.00,670178.85,165.00,670178.85,0.00,'2022-02-08 10:09:52'),(1775639,'5','182',426,'Sale Id shift 257497',0.00,670652.40,165.00,670652.40,0.00,'2022-02-08 10:12:23'),(1775640,'5','182',426,'Sale Id shift 257498',0.00,221454.75,165.00,221454.75,0.00,'2022-02-08 21:59:17'),(1775641,'5','182',426,'Sale Id shift 257501',0.00,179949.00,165.00,179949.00,0.00,'2022-02-11 22:46:58'),(1775642,'5','182',426,'Sale Id shift 257502',0.00,826879.35,165.00,826879.35,0.00,'2022-02-13 08:48:51'),(1775643,'5','182',426,'Sale Id shift 257503',0.00,841396.05,165.00,841396.05,0.00,'2022-02-14 06:10:49'),(1775644,'5','182',426,'Sale Id shift 257504',0.00,868281.15,165.00,868281.15,0.00,'2022-02-14 23:50:14'),(1775645,'5','182',426,'Sale Id shift 257505',0.00,838645.50,165.00,838645.50,0.00,'2022-02-16 07:59:57'),(1775646,'5','182',426,'Sale Id shift 257506',0.00,107992.50,165.00,107992.50,0.00,'2022-02-17 09:27:14'),(1775647,'5','182',426,'Sale Id shift 257511',0.00,148417.50,165.00,148417.50,0.00,'2022-02-22 06:56:12'),(1775648,'5','182',426,'Sale Id shift 257512',0.00,1424435.10,165.00,1424435.10,0.00,'2022-02-23 07:14:01'),(1775649,'5','182',426,'Sale Id shift 257513',0.00,1412470.95,165.00,1412470.95,0.00,'2022-02-24 07:59:49'),(1775650,'5','182',426,'Sale Id shift 257514',0.00,1500805.35,165.00,1500805.35,0.00,'2022-02-25 06:49:07'),(1775651,'5','182',426,'Sale Id shift 257515',0.00,1052785.80,165.00,1052785.80,0.00,'2022-02-26 07:19:06'),(1775652,'5','182',426,'Sale Id shift 257516',0.00,3044505.75,165.00,3044505.75,0.00,'2022-02-27 09:17:09'),(1775653,'5','182',426,'Sale Id shift 257517',0.00,1660642.50,165.00,1660642.50,0.00,'2022-02-27 23:59:59'),(1775654,'5','182',426,'Sale Id shift 257518',0.00,1297482.45,165.00,1297482.45,0.00,'2022-02-28 21:38:47'),(1775655,'5','182',426,'Sale Id shift 257519',0.00,2560207.65,165.00,2560207.65,0.00,'2022-03-02 15:14:04'),(1775656,'5','182',426,'Sale Id shift 257520',0.00,965646.00,165.00,965646.00,0.00,'2022-03-02 22:25:01'),(1775657,'5','182',426,'Sale Id shift 257521',0.00,802690.35,165.00,802690.35,0.00,'2022-03-04 08:21:59'),(1775658,'5','182',426,'Sale Id shift 257522',0.00,183488.25,165.00,183488.25,0.00,'2022-03-05 06:51:43'),(1775659,'5','182',426,'Sale Id shift 257536',0.00,123750.00,165.00,123750.00,0.00,'2022-03-19 07:08:54'),(1775660,'5','182',426,'Sale Id shift 257537',0.00,679852.80,165.00,679852.80,0.00,'2022-03-20 08:39:44'),(1775661,'5','182',426,'Sale Id shift 257538',0.00,505923.00,165.00,505923.00,0.00,'2022-03-21 07:08:14'),(1775662,'5','182',426,'Sale Id shift 257539',0.00,676830.00,165.00,676830.00,0.00,'2022-03-22 07:33:18'),(1775663,'5','182',426,'Sale Id shift 257540',0.00,247085.85,165.00,247085.85,0.00,'2022-03-23 07:55:42'),(1775664,'5','182',426,'Sale Id shift 257542',0.00,116310.15,165.00,116310.15,0.00,'2022-03-25 06:46:51'),(1775665,'5','182',426,'Sale Id shift 257543',0.00,906354.90,165.00,906354.90,0.00,'2022-03-26 04:56:35'),(1775666,'5','182',426,'Sale Id shift 257544',0.00,1202543.10,165.00,1202543.10,0.00,'2022-03-27 07:57:42'),(1775667,'5','182',426,'Sale Id shift 257545',0.00,634677.45,165.00,634677.45,0.00,'2022-03-28 08:27:29'),(1775668,'5','182',426,'Sale Id shift 257568',0.00,755178.60,165.00,755178.60,0.00,'2022-04-20 04:52:10'),(1775669,'5','182',426,'Sale Id shift 257569',0.00,1292563.80,165.00,1292563.80,0.00,'2022-04-21 04:26:27'),(1775670,'5','182',426,'Sale Id shift 257570',0.00,290862.00,165.00,290862.00,0.00,'2022-04-22 06:11:19'),(1775671,'5','182',426,'Sale Id shift 257571',0.00,205260.00,165.00,205260.00,0.00,'2022-04-23 08:33:03'),(1775672,'5','182',426,'Sale Id shift 257572',0.00,709673.25,165.00,709673.25,0.00,'2022-04-24 03:10:23'),(1775673,'5','182',426,'Sale Id shift 257573',0.00,838028.40,165.00,838028.40,0.00,'2022-04-25 03:49:35'),(1775674,'5','182',426,'Sale Id shift 257574',0.00,660412.50,165.00,660412.50,0.00,'2022-04-26 02:17:39'),(1775675,'5','182',426,'Sale Id shift 257575',0.00,891125.40,165.00,891125.40,0.00,'2022-04-27 03:39:35'),(1775676,'5','182',426,'Sale Id shift 257576',0.00,1084510.35,165.00,1084510.35,0.00,'2022-04-28 02:28:32'),(1775677,'5','182',426,'Sale Id shift 257577',0.00,690764.25,165.00,690764.25,0.00,'2022-04-29 06:05:21'),(1775678,'5','182',426,'Sale Id shift 257578',0.00,1030847.40,165.00,1030847.40,0.00,'2022-04-30 00:04:51'),(1775679,'5','182',426,'Sale Id shift 257579',0.00,1234076.25,165.00,1234076.25,0.00,'2022-05-09 11:34:37'),(1775680,'5','182',426,'Sale Id shift 257580',0.00,1173521.25,165.00,1173521.25,0.00,'2022-05-09 11:38:31'),(1775681,'5','182',426,'Sale Id shift 257581',0.00,668807.70,165.00,668807.70,0.00,'2022-05-09 12:40:06'),(1775682,'5','182',426,'Sale Id shift 257582',0.00,1186493.55,165.00,1186493.55,0.00,'2022-05-09 13:09:55'),(1775683,'5','182',426,'Sale Id shift 257583',0.00,841823.40,165.00,841823.40,0.00,'2022-05-09 13:12:07'),(1775684,'5','182',426,'Sale Id shift 257584',0.00,843415.65,165.00,843415.65,0.00,'2022-05-09 13:14:32'),(1775685,'5','182',426,'Sale Id shift 257585',0.00,830954.85,165.00,830954.85,0.00,'2022-05-09 13:16:17'),(1775686,'5','182',426,'Sale Id shift 257586',0.00,671089.65,165.00,671089.65,0.00,'2022-05-09 13:19:05'),(1775687,'5','182',426,'Sale Id shift 257587',0.00,627371.25,165.00,627371.25,0.00,'2022-05-09 13:21:10'),(1775688,'5','182',426,'Sale Id shift 257588',0.00,294417.75,165.00,294417.75,0.00,'2022-05-10 06:50:24'),(1775689,'5','182',426,'Sale Id shift 257604',0.00,414646.65,165.00,414646.65,0.00,'2022-05-26 10:02:51'),(1775690,'5','182',426,'Sale Id shift 257605',0.00,729268.65,165.00,729268.65,0.00,'2022-05-27 05:28:10'),(1775691,'5','182',426,'Sale Id shift 257606',0.00,758798.70,165.00,758798.70,0.00,'2022-05-28 05:00:02'),(1775692,'5','182',426,'Sale Id shift 257607',0.00,784604.70,165.00,784604.70,0.00,'2022-05-29 08:19:07'),(1775693,'5','182',426,'Sale Id shift 257608',0.00,766903.50,165.00,766903.50,0.00,'2022-05-30 05:01:18'),(1775694,'5','182',426,'Sale Id shift 257609',0.00,703074.90,165.00,703074.90,0.00,'2022-05-31 00:22:17'),(1775695,'5','182',426,'Sale Id shift 257610',0.00,687258.00,165.00,687258.00,0.00,'2022-06-01 07:06:31'),(1775696,'5','182',426,'Sale Id shift 257611',0.00,662508.00,165.00,662508.00,0.00,'2022-06-02 05:02:39'),(1775697,'5','182',426,'Sale Id shift 257612',0.00,338547.00,165.00,338547.00,0.00,'2022-06-03 06:49:23'),(1775698,'5','182',426,'Sale Id shift 257613',0.00,264778.80,165.00,264778.80,0.00,'2022-06-04 06:09:14'),(1775699,'5','182',426,'Sale Id shift 257616',0.00,619525.50,165.00,619525.50,0.00,'2022-06-07 10:20:43'),(1775700,'5','182',426,'Sale Id shift 257617',0.00,895522.65,165.00,895522.65,0.00,'2022-06-08 10:33:15'),(1775701,'5','182',426,'Sale Id shift 257618',0.00,691249.35,165.00,691249.35,0.00,'2022-06-09 06:03:23'),(1775702,'5','182',426,'Sale Id shift 257619',0.00,808412.55,165.00,808412.55,0.00,'2022-06-10 08:22:04'),(1775703,'5','182',426,'Sale Id shift 257620',0.00,818142.60,165.00,818142.60,0.00,'2022-06-10 21:47:04'),(1775704,'5','182',426,'Sale Id shift 257621',0.00,693607.20,165.00,693607.20,0.00,'2022-06-12 08:32:42'),(1775705,'5','182',426,'Sale Id shift 257622',0.00,661415.70,165.00,661415.70,0.00,'2022-06-13 06:56:07'),(1775706,'5','182',426,'Sale Id shift 257623',0.00,693785.40,165.00,693785.40,0.00,'2022-06-14 09:00:35'),(1775707,'5','182',426,'Sale Id shift 257624',0.00,714788.25,165.00,714788.25,0.00,'2022-06-15 07:35:09'),(1775708,'5','182',426,'Sale Id shift 257653',0.00,524475.00,185.00,524475.00,0.00,'2022-07-14 09:48:54'),(1775709,'5','182',426,'Sale Id shift 257654',0.00,784873.60,185.00,784873.60,0.00,'2022-07-15 07:19:44'),(1775710,'5','182',426,'Sale Id shift 257655',0.00,783850.55,185.00,783850.55,0.00,'2022-07-16 06:56:06'),(1775711,'5','182',426,'Sale Id shift 257656',0.00,935767.00,185.00,935767.00,0.00,'2022-07-17 05:31:27'),(1775712,'5','182',426,'Sale Id shift 257657',0.00,1014319.85,185.00,1014319.85,0.00,'2022-07-18 07:37:04'),(1775713,'5','182',426,'Sale Id shift 257658',0.00,1172045.30,185.00,1172045.30,0.00,'2022-07-19 05:05:04'),(1775714,'5','182',426,'Sale Id shift 257659',0.00,846326.90,185.00,846326.90,0.00,'2022-07-20 07:42:07'),(1775715,'5','182',426,'Sale Id shift 257660',0.00,944652.55,185.00,944652.55,0.00,'2022-07-21 06:51:07'),(1775716,'5','182',426,'Sale Id shift 257661',0.00,748698.70,185.00,748698.70,0.00,'2022-07-21 23:12:49'),(1775717,'5','182',426,'Sale Id shift 257662',0.00,1255946.50,185.00,1255946.50,0.00,'2022-07-23 13:45:50'),(1775718,'5','182',426,'Sale Id shift 257663',0.00,756753.60,185.00,756753.60,0.00,'2022-07-24 08:33:54'),(1775719,'5','182',426,'Sale Id shift 257665',0.00,753736.25,185.00,753736.25,0.00,'2022-07-26 05:55:52'),(1775720,'5','182',426,'Sale Id shift 257666',0.00,1174426.25,185.00,1174426.25,0.00,'2022-07-27 06:06:33'),(1775721,'5','182',426,'Sale Id shift 257667',0.00,1127678.60,185.00,1127678.60,0.00,'2022-07-28 06:56:31'),(1775722,'5','182',426,'Sale Id shift 257668',0.00,751236.90,185.00,751236.90,0.00,'2022-07-29 07:14:05'),(1775723,'5','182',426,'Sale Id shift 257669',0.00,377007.80,185.00,377007.80,0.00,'2022-07-30 05:50:30'),(1775724,'5','182',426,'Sale Id shift 257673',0.00,747671.95,185.00,747671.95,0.00,'2022-08-03 07:00:46'),(1775725,'5','182',426,'Sale Id shift 257674',0.00,791465.15,185.00,791465.15,0.00,'2022-08-04 06:16:53'),(1775726,'5','182',426,'Sale Id shift 257675',0.00,790880.55,185.00,790880.55,0.00,'2022-08-04 21:51:54'),(1775727,'5','182',426,'Sale Id shift 257676',0.00,442897.40,185.00,442897.40,0.00,'2022-08-06 06:54:42'),(1775728,'5','182',426,'Sale Id shift 257680',0.00,648807.95,185.00,648807.95,0.00,'2022-09-04 11:14:13'),(1775729,'5','182',426,'Sale Id shift 257681',0.00,813816.85,185.00,813816.85,0.00,'2022-09-04 11:19:33'),(1775730,'5','182',426,'Sale Id shift 257682',0.00,752953.70,185.00,752953.70,0.00,'2022-09-04 11:22:46'),(1775731,'5','182',426,'Sale Id shift 257683',0.00,283960.20,185.00,283960.20,0.00,'2022-09-04 11:26:05'),(1775732,'5','182',426,'Sale Id shift 257685',0.00,603257.25,185.00,603257.25,0.00,'2022-09-04 12:23:21'),(1775733,'5','182',426,'Sale Id shift 257686',0.00,763609.70,185.00,763609.70,0.00,'2022-09-05 06:53:20'),(1775734,'5','182',426,'Sale Id shift 257687',0.00,850300.70,185.00,850300.70,0.00,'2022-09-05 11:33:33'),(1775735,'5','182',426,'Sale Id shift 257688',0.00,360661.20,185.00,360661.20,0.00,'2022-09-05 11:39:20'),(1775736,'5','182',426,'Sale Id shift 257689',0.00,1099216.35,185.00,1099216.35,0.00,'2022-09-05 11:42:17'),(1775737,'5','182',426,'Sale Id shift 257690',0.00,482348.65,185.00,482348.65,0.00,'2022-09-05 12:06:27'),(1775738,'5','182',426,'Sale Id shift 257691',0.00,512453.70,185.00,512453.70,0.00,'2022-09-05 12:11:48'),(1775739,'5','182',426,'Sale Id shift 257692',0.00,772177.05,185.00,772177.05,0.00,'2022-09-05 12:17:13'),(1775740,'5','182',426,'Sale Id shift 257693',0.00,563889.25,185.00,563889.25,0.00,'2022-09-05 12:21:19'),(1775741,'5','182',426,'Sale Id shift 257694',0.00,827107.25,185.00,827107.25,0.00,'2022-09-05 12:23:55'),(1775742,'5','182',426,'Sale Id shift 257695',0.00,887309.95,185.00,887309.95,0.00,'2022-09-05 12:29:07'),(1775743,'5','182',426,'Sale Id shift 257696',0.00,619050.70,185.00,619050.70,0.00,'2022-09-05 12:32:27'),(1775744,'5','182',426,'Sale Id shift 257697',0.00,373577.90,185.00,373577.90,0.00,'2022-09-05 12:35:49'),(1775745,'5','182',426,'Sale Id shift 257698',0.00,596958.00,185.00,596958.00,0.00,'2022-09-05 12:40:00'),(1775746,'5','182',426,'Sale Id shift 257699',0.00,659441.75,185.00,659441.75,0.00,'2022-09-05 12:42:43'),(1775747,'5','182',426,'Sale Id shift 257700',0.00,1013368.95,185.00,1013368.95,0.00,'2022-09-05 12:45:10'),(1775748,'5','182',426,'Sale Id shift 257701',0.00,649076.20,185.00,649076.20,0.00,'2022-09-05 12:47:38'),(1775749,'5','182',426,'Sale Id shift 257702',0.00,972182.40,185.00,972182.40,0.00,'2022-09-05 12:50:11'),(1775750,'5','182',426,'Sale Id shift 257703',0.00,1123342.20,185.00,1123342.20,0.00,'2022-09-05 13:08:16'),(1775751,'5','182',426,'Sale Id shift 257704',0.00,930326.15,185.00,930326.15,0.00,'2022-09-05 13:20:10'),(1775752,'5','182',426,'Sale Id shift 257705',0.00,788908.45,185.00,788908.45,0.00,'2022-09-05 13:22:35'),(1775753,'5','182',426,'Sale Id shift 257706',0.00,1011200.75,185.00,1011200.75,0.00,'2022-09-05 13:24:51'),(1775754,'5','182',426,'Sale Id shift 257707',0.00,553967.70,185.00,553967.70,0.00,'2022-09-06 10:31:02'),(1775755,'5','182',426,'Sale Id shift 257708',0.00,1063095.10,185.00,1063095.10,0.00,'2022-09-07 10:25:24'),(1775756,'5','182',426,'Sale Id shift 257709',0.00,1045309.20,185.00,1045309.20,0.00,'2022-09-08 07:12:31'),(1775757,'5','182',426,'Sale Id shift 257710',0.00,848731.90,185.00,848731.90,0.00,'2022-09-09 08:19:25'),(1775758,'5','182',426,'Sale Id shift 257711',0.00,616318.25,185.00,616318.25,0.00,'2022-09-10 09:42:37'),(1775759,'5','182',426,'Sale Id shift 257712',0.00,782501.90,185.00,782501.90,0.00,'2022-09-11 08:57:17'),(1775760,'5','182',426,'Sale Id shift 257713',0.00,1433431.80,185.00,1433431.80,0.00,'2022-09-12 08:57:43'),(1775761,'5','182',426,'Sale Id shift 257714',0.00,1206571.85,185.00,1206571.85,0.00,'2022-09-13 09:16:40'),(1775762,'5','182',426,'Sale Id shift 257715',0.00,345002.80,185.00,345002.80,0.00,'2022-09-14 09:53:33'),(1775763,'5','182',426,'Sale Id shift 257719',0.00,561460.20,185.00,561460.20,0.00,'2022-09-18 07:22:52'),(1775764,'5','182',426,'Sale Id shift 257720',0.00,919842.20,185.00,919842.20,0.00,'2022-09-19 07:21:16'),(1775765,'5','182',426,'Sale Id shift 257721',0.00,632657.45,185.00,632657.45,0.00,'2022-09-20 08:34:50'),(1775766,'5','182',426,'Sale Id shift 257722',0.00,1136336.60,185.00,1136336.60,0.00,'2022-09-21 11:52:55'),(1775767,'5','182',426,'Sale Id shift 257723',0.00,1033903.95,185.00,1033903.95,0.00,'2022-09-22 07:41:17'),(1775768,'5','182',426,'Sale Id shift 257724',0.00,785680.20,185.00,785680.20,0.00,'2022-09-23 07:52:10'),(1775769,'5','182',426,'Sale Id shift 257725',0.00,746393.60,185.00,746393.60,0.00,'2022-09-23 22:42:08'),(1775770,'5','182',426,'Sale Id shift 257726',0.00,1041790.50,185.00,1041790.50,0.00,'2022-09-25 08:06:26'),(1775771,'5','182',426,'Sale Id shift 257727',0.00,761448.90,185.00,761448.90,0.00,'2022-09-26 07:19:12'),(1775772,'5','182',426,'Sale Id shift 257728',0.00,659195.70,185.00,659195.70,0.00,'2022-09-27 12:25:18'),(1775773,'5','182',426,'Sale Id shift 257729',0.00,627973.25,185.00,627973.25,0.00,'2022-09-28 08:24:46'),(1775774,'5','182',426,'Sale Id shift 257730',0.00,879782.30,185.00,879782.30,0.00,'2022-09-29 08:37:33'),(1775775,'5','182',426,'Sale Id shift 257731',0.00,1226076.40,185.00,1226076.40,0.00,'2022-09-30 08:12:15'),(1775776,'5','182',426,'Sale Id shift 257732',0.00,1143938.25,185.00,1143938.25,0.00,'2022-09-30 21:44:54'),(1775777,'5','182',426,'Sale Id shift 257733',0.00,1400910.65,185.00,1400910.65,0.00,'2022-10-02 06:44:44'),(1775778,'5','182',426,'Sale Id shift 257734',0.00,1211378.15,185.00,1211378.15,0.00,'2022-10-03 06:26:24'),(1775779,'5','182',426,'Sale Id shift 257735',0.00,1161783.35,185.00,1161783.35,0.00,'2022-10-04 07:13:16'),(1775780,'5','182',426,'Sale Id shift 257736',0.00,934331.40,185.00,934331.40,0.00,'2022-10-05 09:41:34'),(1775781,'5','182',426,'Sale Id shift 257737',0.00,563532.20,185.00,563532.20,0.00,'2022-10-06 11:50:00'),(1775782,'5','182',426,'Sale Id shift 257740',0.00,40790.65,185.00,40790.65,0.00,'2022-10-09 08:33:44'),(1775783,'5','182',426,'Sale Id shift 257783',0.00,559571.35,185.00,559571.35,0.00,'2022-11-21 06:39:44'),(1775784,'5','182',426,'Sale Id shift 257784',0.00,956903.25,185.00,956903.25,0.00,'2022-11-22 09:24:28'),(1775785,'5','182',426,'Sale Id shift 257785',0.00,876498.55,185.00,876498.55,0.00,'2022-11-23 07:23:57'),(1775786,'5','182',426,'Sale Id shift 257786',0.00,388496.30,185.00,388496.30,0.00,'2022-11-24 13:08:51'),(1775787,'5','182',426,'Sale Id shift 257789',0.00,654892.60,185.00,654892.60,0.00,'2022-11-27 08:34:53'),(1775788,'5','182',426,'Sale Id shift 257790',0.00,882514.75,185.00,882514.75,0.00,'2022-11-28 07:55:44'),(1775789,'5','182',426,'Sale Id shift 257791',0.00,807833.95,185.00,807833.95,0.00,'2022-11-29 08:05:42'),(1775790,'5','182',426,'Sale Id shift 257792',0.00,529183.25,185.00,529183.25,0.00,'2022-11-29 19:18:23');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4952635 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','182',3571102,'','24','3474',0.00,5910000.00,'Purchase Id 78193 for 19,700.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-10-13 09:40:09','',''),('5','182',3571103,'','supplier','252',5910000.00,0.00,'Purchase Id 78193 for 19,700.00 litters of Diesel - AGO from SALBAS OIL & GAS LIMITED','2021-10-13 09:40:09','',''),('5','182',3571110,'','24','3474',0.00,57050.00,'Purchase Id 78192 for 350.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-10-13 09:40:51','',''),('5','182',3571111,'','supplier','252',57050.00,0.00,'Purchase Id 78192 for 350.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-10-13 09:40:51','',''),('5','182',3591511,'','20','3478',0.00,0.00,'Sales from shift 226656 on 2021-10-15 10:10:23 ','2021-10-15 10:10:23','',''),('5','182',3591512,'','6.1','3477',0.00,0.00,'Sales from shift 226656 on 2021-10-15 10:10:23 ','2021-10-15 10:10:23','',''),('5','182',3591774,'','24','3474',0.00,7204600.00,'Purchase Id 78356 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-10-15 10:28:39','',''),('5','182',3591775,'','supplier','252',7204600.00,0.00,'Purchase Id 78356 for 44,200.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-10-15 10:28:39','',''),('5','182',3591792,'','20','3478',90999.00,0.00,'Sales from shift 231730 on 2021-10-15 10:29:38 ','2021-10-15 10:29:38','',''),('5','182',3591793,'','6.1','3477',0.00,90999.00,'Sales from shift 231730 on 2021-10-15 10:29:38 ','2021-10-15 10:29:38','',''),('5','182',3591890,'','20','3478',176172.00,0.00,'Sales from shift 231734 on 2021-10-15 10:38:43 ','2021-10-15 10:38:43','',''),('5','182',3591891,'','6.1','3477',0.00,176172.00,'Sales from shift 231734 on 2021-10-15 10:38:43 ','2021-10-15 10:38:43','',''),('5','182',3592098,'','20','3478',71733.00,0.00,'Sales from shift 231739 on 2021-10-15 10:52:23 ','2021-10-15 10:52:23','',''),('5','182',3592099,'','6.1','3477',0.00,71733.00,'Sales from shift 231739 on 2021-10-15 10:52:23 ','2021-10-15 10:52:23','',''),('5','182',3592192,'','20','3478',60663.00,0.00,'Sales from shift 231741 on 2021-10-15 10:58:10 ','2021-10-15 10:58:10','',''),('5','182',3592193,'','6.1','3477',0.00,60663.00,'Sales from shift 231741 on 2021-10-15 10:58:10 ','2021-10-15 10:58:10','',''),('5','182',3592366,'','20','3478',103068.80,0.00,'Sales from shift 231743 on 2021-10-15 11:12:55 ','2021-10-15 11:12:55','',''),('5','182',3592367,'','6.1','3477',0.00,103068.80,'Sales from shift 231743 on 2021-10-15 11:12:55 ','2021-10-15 11:12:55','',''),('5','182',3592419,'','20','3478',55322.60,0.00,'Sales from shift 231744 on 2021-10-15 11:17:37 ','2021-10-15 11:17:37','',''),('5','182',3592420,'','6.1','3477',0.00,55322.60,'Sales from shift 231744 on 2021-10-15 11:17:37 ','2021-10-15 11:17:37','',''),('5','182',3592489,'','20','3478',88343.80,0.00,'Sales from shift 231748 on 2021-10-15 11:21:33 ','2021-10-15 11:21:33','',''),('5','182',3592490,'','6.1','3477',0.00,88343.80,'Sales from shift 231748 on 2021-10-15 11:21:33 ','2021-10-15 11:21:33','',''),('5','182',3592525,'','20','3478',112288.20,0.00,'Sales from shift 231752 on 2021-10-15 11:25:07 ','2021-10-15 11:25:07','',''),('5','182',3592526,'','6.1','3477',0.00,112288.20,'Sales from shift 231752 on 2021-10-15 11:25:07 ','2021-10-15 11:25:07','',''),('5','182',3592614,'','20','3478',54498.00,0.00,'Sales from shift 231754 on 2021-10-15 11:29:37 ','2021-10-15 11:29:37','',''),('5','182',3592615,'','6.1','3477',0.00,54498.00,'Sales from shift 231754 on 2021-10-15 11:29:37 ','2021-10-15 11:29:37','',''),('5','182',3592674,'','20','3478',41775.60,0.00,'Sales from shift 231757 on 2021-10-15 11:33:54 ','2021-10-15 11:33:54','',''),('5','182',3592675,'','6.1','3477',0.00,41775.60,'Sales from shift 231757 on 2021-10-15 11:33:54 ','2021-10-15 11:33:54','',''),('5','182',3592716,'','20','3478',43037.30,0.00,'Sales from shift 231760 on 2021-10-15 11:37:54 ','2021-10-15 11:37:54','',''),('5','182',3592717,'','6.1','3477',0.00,43037.30,'Sales from shift 231760 on 2021-10-15 11:37:54 ','2021-10-15 11:37:54','',''),('5','182',3592864,'','20','3478',86496.00,0.00,'Sales from shift 231764 on 2021-10-15 11:46:03 ','2021-10-15 11:46:03','',''),('5','182',3592865,'','6.1','3477',0.00,86496.00,'Sales from shift 231764 on 2021-10-15 11:46:03 ','2021-10-15 11:46:03','',''),('5','182',3593052,'','20','3478',426076.96,0.00,'Sales from shift 231765 on 2021-10-15 12:00:46 ','2021-10-15 12:00:46','',''),('5','182',3593053,'','6.1','3477',0.00,426076.96,'Sales from shift 231765 on 2021-10-15 12:00:46 ','2021-10-15 12:00:46','',''),('5','182',3593182,'','20','3478',348404.27,0.00,'Sales from shift 231770 on 2021-10-15 12:07:18 ','2021-10-15 12:07:18','',''),('5','182',3593183,'','6.1','3477',0.00,348404.27,'Sales from shift 231770 on 2021-10-15 12:07:18 ','2021-10-15 12:07:18','',''),('5','182',3595757,'','6.1','3477',14030.00,0.00,'Payment Id 345037 for invoice:231744, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:22','',''),('5','182',3595758,'','supplier','252',0.00,14030.00,'Payment Id 345037 for invoice:231744, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:22','',''),('5','182',3595759,'','2','3681',41300.00,0.00,'Payment Id 345034 for invoice:231744, receipt: 02616 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:23','',''),('5','182',3595760,'','supplier','252',0.00,41300.00,'Payment Id 345034 for invoice:231744, receipt: 02616 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:23','',''),('5','182',3595773,'','6.1','3477',14030.00,0.00,'Payment Id 345042 for invoice:231748, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:47','',''),('5','182',3595774,'','supplier','252',0.00,14030.00,'Payment Id 345042 for invoice:231748, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:47','',''),('5','182',3595775,'','2','3681',74315.00,0.00,'Payment Id 345040 for invoice:231748, receipt: 02615 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:47','',''),('5','182',3595776,'','supplier','252',0.00,74315.00,'Payment Id 345040 for invoice:231748, receipt: 02615 by SALBAS OIL & GAS LIMITED','2021-10-15 15:15:47','',''),('5','182',3595813,'','6.1','3477',14430.00,0.00,'Payment Id 345103 for invoice:231770, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595814,'','supplier','252',0.00,14430.00,'Payment Id 345103 for invoice:231770, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595815,'','2','3681',333975.00,0.00,'Payment Id 345101 for invoice:231770, receipt: 92600 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595816,'','supplier','252',0.00,333975.00,'Payment Id 345101 for invoice:231770, receipt: 92600 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595817,'','6.1','3477',325930.00,0.00,'Payment Id 345098 for invoice:231765, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595818,'','supplier','252',0.00,325930.00,'Payment Id 345098 for invoice:231765, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595819,'','2','3681',100150.00,0.00,'Payment Id 345091 for invoice:231765, receipt: 05394 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595820,'','supplier','252',0.00,100150.00,'Payment Id 345091 for invoice:231765, receipt: 05394 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595821,'','6.1','3477',14430.00,0.00,'Payment Id 345083 for invoice:231764, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595822,'','supplier','252',0.00,14430.00,'Payment Id 345083 for invoice:231764, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:31','',''),('5','182',3595827,'','2','3681',72070.00,0.00,'Payment Id 345080 for invoice:231764, receipt: 02611 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595828,'','supplier','252',0.00,72070.00,'Payment Id 345080 for invoice:231764, receipt: 02611 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595829,'','6.1','3477',35530.00,0.00,'Payment Id 345076 for invoice:231760, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595830,'','supplier','252',0.00,35530.00,'Payment Id 345076 for invoice:231760, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595831,'','2','3681',7510.00,0.00,'Payment Id 345071 for invoice:231760, receipt: 02611 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595832,'','supplier','252',0.00,7510.00,'Payment Id 345071 for invoice:231760, receipt: 02611 by SALBAS OIL & GAS LIMITED','2021-10-15 15:16:52','',''),('5','182',3595841,'','6.1','3477',14030.00,0.00,'Payment Id 345066 for invoice:231757, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595842,'','supplier','252',0.00,14030.00,'Payment Id 345066 for invoice:231757, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595843,'','2','3681',27745.00,0.00,'Payment Id 345064 for invoice:231757, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595844,'','supplier','252',0.00,27745.00,'Payment Id 345064 for invoice:231757, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595845,'','6.1','3477',12400.00,0.00,'Payment Id 345060 for invoice:231754, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595846,'','supplier','252',0.00,12400.00,'Payment Id 345060 for invoice:231754, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595847,'','2','3681',41100.00,0.00,'Payment Id 345058 for invoice:231754, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595848,'','supplier','252',0.00,41100.00,'Payment Id 345058 for invoice:231754, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595849,'','6.1','3477',12400.00,0.00,'Payment Id 345053 for invoice:231752, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595850,'','supplier','252',0.00,12400.00,'Payment Id 345053 for invoice:231752, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:20','',''),('5','182',3595851,'','2','3681',99890.00,0.00,'Payment Id 345048 for invoice:231752, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:21','',''),('5','182',3595852,'','supplier','252',0.00,99890.00,'Payment Id 345048 for invoice:231752, receipt: 02641 by SALBAS OIL & GAS LIMITED','2021-10-15 15:17:21','',''),('5','182',3620612,'','20','3478',507853.30,0.00,'Sales from shift 231782 on 2021-10-18 09:55:04 ','2021-10-18 09:55:04','',''),('5','182',3620613,'','6.1','3477',0.00,507853.30,'Sales from shift 231782 on 2021-10-18 09:55:04 ','2021-10-18 09:55:04','',''),('5','182',3620797,'','20','3478',834165.91,0.00,'Sales from shift 232418 on 2021-10-18 10:08:35 ','2021-10-18 10:08:35','',''),('5','182',3620798,'','6.1','3477',0.00,834165.91,'Sales from shift 232418 on 2021-10-18 10:08:35 ','2021-10-18 10:08:35','',''),('5','182',3620856,'','20','3478',699193.40,0.00,'Sales from shift 232421 on 2021-10-18 10:12:56 ','2021-10-18 10:12:56','',''),('5','182',3620857,'','6.1','3477',0.00,699193.40,'Sales from shift 232421 on 2021-10-18 10:12:56 ','2021-10-18 10:12:56','',''),('5','182',3621522,'','6.1','3477',14430.00,0.00,'Payment Id 346364 for invoice:232421, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621523,'','supplier','252',0.00,14430.00,'Payment Id 346364 for invoice:232421, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621524,'','2','3681',684765.00,0.00,'Payment Id 346363 for invoice:232421, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621525,'','supplier','252',0.00,684765.00,'Payment Id 346363 for invoice:232421, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621526,'','6.1','3477',12000.00,0.00,'Payment Id 346360 for invoice:232418, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621527,'','supplier','252',0.00,12000.00,'Payment Id 346360 for invoice:232418, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621528,'','2','3681',821365.00,0.00,'Payment Id 346357 for invoice:232418, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621529,'','supplier','252',0.00,821365.00,'Payment Id 346357 for invoice:232418, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621530,'','6.1','3477',12800.00,0.00,'Payment Id 346354 for invoice:231782, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621531,'','supplier','252',0.00,12800.00,'Payment Id 346354 for invoice:231782, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621532,'','2','3681',495055.00,0.00,'Payment Id 346352 for invoice:231782, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3621533,'','supplier','252',0.00,495055.00,'Payment Id 346352 for invoice:231782, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-18 10:44:52','',''),('5','182',3639105,'','20','3478',752136.92,0.00,'Sales from shift 232435 on 2021-10-20 09:15:43 ','2021-10-20 09:15:43','',''),('5','182',3639106,'','6.1','3477',0.00,752136.92,'Sales from shift 232435 on 2021-10-20 09:15:43 ','2021-10-20 09:15:43','',''),('5','182',3639634,'','6.1','3477',14710.00,0.00,'Payment Id 347362 for invoice:232919, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639635,'','supplier','252',0.00,14710.00,'Payment Id 347362 for invoice:232919, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639636,'','2','3681',836160.00,0.00,'Payment Id 347361 for invoice:232919, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639637,'','supplier','252',0.00,836160.00,'Payment Id 347361 for invoice:232919, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639638,'','6.1','3477',17250.00,0.00,'Payment Id 347354 for invoice:232435, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639639,'','supplier','252',0.00,17250.00,'Payment Id 347354 for invoice:232435, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639640,'','2','3681',734885.00,0.00,'Payment Id 347351 for invoice:232435, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639641,'','supplier','252',0.00,734885.00,'Payment Id 347351 for invoice:232435, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-10-20 09:37:50','',''),('5','182',3639648,'','20','3478',850866.97,0.00,'Sales from shift 232919 on 2021-10-20 09:38:17 ','2021-10-20 09:38:17','',''),('5','182',3639649,'','6.1','3477',0.00,850866.97,'Sales from shift 232919 on 2021-10-20 09:38:17 ','2021-10-20 09:38:17','',''),('5','182',3651736,'','20','3478',1077894.48,0.00,'Sales from shift 232930 on 2021-10-21 09:59:03 ','2021-10-21 09:59:03','',''),('5','182',3651737,'','6.1','3477',0.00,1077894.48,'Sales from shift 232930 on 2021-10-21 09:59:03 ','2021-10-21 09:59:03','',''),('5','182',3652264,'','6.1','3477',27710.00,0.00,'Payment Id 347996 for invoice:232930, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-21 10:48:51','',''),('5','182',3652265,'','supplier','252',0.00,27710.00,'Payment Id 347996 for invoice:232930, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-21 10:48:51','',''),('5','182',3652266,'','2','3681',1050185.00,0.00,'Payment Id 347994 for invoice:232930, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-21 10:48:51','',''),('5','182',3652267,'','supplier','252',0.00,1050185.00,'Payment Id 347994 for invoice:232930, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-21 10:48:51','',''),('5','182',3661975,'','6.1','3477',24570.00,0.00,'Payment Id 348722 for invoice:233199, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-22 10:55:11','',''),('5','182',3661976,'','supplier','252',0.00,24570.00,'Payment Id 348722 for invoice:233199, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-22 10:55:11','',''),('5','182',3661977,'','2','3681',793230.00,0.00,'Payment Id 348717 for invoice:233199, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-10-22 10:55:12','',''),('5','182',3661978,'','supplier','252',0.00,793230.00,'Payment Id 348717 for invoice:233199, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-10-22 10:55:12','',''),('5','182',3662018,'','20','3478',817959.80,0.00,'Sales from shift 233199 on 2021-10-22 10:57:04 ','2021-10-22 10:57:04','',''),('5','182',3662019,'','6.1','3477',0.00,817959.80,'Sales from shift 233199 on 2021-10-22 10:57:04 ','2021-10-22 10:57:04','',''),('5','182',3690287,'','20','3478',526804.44,0.00,'Sales from shift 233476 on 2021-10-25 10:12:10 ','2021-10-25 10:12:10','',''),('5','182',3690288,'','6.1','3477',0.00,526804.44,'Sales from shift 233476 on 2021-10-25 10:12:10 ','2021-10-25 10:12:10','',''),('5','182',3690296,'','6.1','3477',13800.00,0.00,'Payment Id 350161 for invoice:233476, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690297,'','supplier','252',0.00,13800.00,'Payment Id 350161 for invoice:233476, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690298,'','2','3681',513000.00,0.00,'Payment Id 350159 for invoice:233476, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690299,'','supplier','252',0.00,513000.00,'Payment Id 350159 for invoice:233476, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690300,'','2','3681',513000.00,0.00,'Payment Id 350158 for invoice:233476, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690301,'','supplier','252',0.00,513000.00,'Payment Id 350158 for invoice:233476, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-10-25 10:12:31','',''),('5','182',3690491,'','20','3478',533841.66,0.00,'Sales from shift 234152 on 2021-10-25 10:28:39 ','2021-10-25 10:28:39','',''),('5','182',3690492,'','6.1','3477',0.00,533841.66,'Sales from shift 234152 on 2021-10-25 10:28:39 ','2021-10-25 10:28:39','',''),('5','182',3690630,'','20','3478',420579.17,0.00,'Sales from shift 234154 on 2021-10-25 10:39:43 ','2021-10-25 10:39:43','',''),('5','182',3690631,'','6.1','3477',0.00,420579.17,'Sales from shift 234154 on 2021-10-25 10:39:43 ','2021-10-25 10:39:43','',''),('5','182',3692809,'','6.1','3477',15430.00,0.00,'Payment Id 350221 for invoice:234154, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692810,'','supplier','252',0.00,15430.00,'Payment Id 350221 for invoice:234154, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692811,'','2','3681',405150.00,0.00,'Payment Id 350218 for invoice:234154, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692812,'','supplier','252',0.00,405150.00,'Payment Id 350218 for invoice:234154, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692813,'','6.1','3477',13800.00,0.00,'Payment Id 350200 for invoice:234152, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692814,'','supplier','252',0.00,13800.00,'Payment Id 350200 for invoice:234152, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692815,'','2','3681',520040.00,0.00,'Payment Id 350196 for invoice:234152, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3692816,'','supplier','252',0.00,520040.00,'Payment Id 350196 for invoice:234152, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-10-25 13:13:18','',''),('5','182',3699873,'','6.1','3477',27430.00,0.00,'Payment Id 350706 for invoice:234158, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-26 09:00:56','',''),('5','182',3699874,'','supplier','252',0.00,27430.00,'Payment Id 350706 for invoice:234158, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-26 09:00:56','',''),('5','182',3699875,'','2','3681',625325.00,0.00,'Payment Id 350703 for invoice:234158, receipt: 57318 by SALBAS OIL & GAS LIMITED','2021-10-26 09:00:56','',''),('5','182',3699876,'','supplier','252',0.00,625325.00,'Payment Id 350703 for invoice:234158, receipt: 57318 by SALBAS OIL & GAS LIMITED','2021-10-26 09:00:56','',''),('5','182',3699884,'','20','3478',652754.50,0.00,'Sales from shift 234158 on 2021-10-26 09:01:22 ','2021-10-26 09:01:22','',''),('5','182',3699885,'','6.1','3477',0.00,652754.50,'Sales from shift 234158 on 2021-10-26 09:01:22 ','2021-10-26 09:01:22','',''),('5','182',3712066,'','6.1','3477',19145.00,0.00,'Payment Id 351350 for invoice:234381, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-27 10:04:37','',''),('5','182',3712067,'','supplier','252',0.00,19145.00,'Payment Id 351350 for invoice:234381, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-27 10:04:37','',''),('5','182',3712068,'','2','3681',572585.00,0.00,'Payment Id 351344 for invoice:234381, receipt: 57319 by SALBAS OIL & GAS LIMITED','2021-10-27 10:04:37','',''),('5','182',3712069,'','supplier','252',0.00,572585.00,'Payment Id 351344 for invoice:234381, receipt: 57319 by SALBAS OIL & GAS LIMITED','2021-10-27 10:04:37','',''),('5','182',3712073,'','20','3478',591728.40,0.00,'Sales from shift 234381 on 2021-10-27 10:05:04 ','2021-10-27 10:05:04','',''),('5','182',3712074,'','6.1','3477',0.00,591728.40,'Sales from shift 234381 on 2021-10-27 10:05:04 ','2021-10-27 10:05:04','',''),('5','182',3723002,'','6.1','3477',15450.00,0.00,'Payment Id 351876 for invoice:234675, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-28 09:50:12','',''),('5','182',3723003,'','supplier','252',0.00,15450.00,'Payment Id 351876 for invoice:234675, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-10-28 09:50:12','',''),('5','182',3723004,'','2','3681',611385.00,0.00,'Payment Id 351875 for invoice:234675, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-28 09:50:12','',''),('5','182',3723005,'','supplier','252',0.00,611385.00,'Payment Id 351875 for invoice:234675, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-10-28 09:50:12','',''),('5','182',3723010,'','20','3478',626835.60,0.00,'Sales from shift 234675 on 2021-10-28 09:50:45 ','2021-10-28 09:50:45','',''),('5','182',3723011,'','6.1','3477',0.00,626835.60,'Sales from shift 234675 on 2021-10-28 09:50:45 ','2021-10-28 09:50:45','',''),('5','182',3766976,'','2','3681',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3767030,'','24','3474',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3767250,'','6.1','3477',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3767339,'','24','3476',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3768335,'','22','3475',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3770156,'','20','3478',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3770230,'','2','3510',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','182',3775983,'','24','3474',0.00,7961250.00,'Purchase Id 79612 for 48,250.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-02 14:38:55','',''),('5','182',3775984,'','supplier','252',7961250.00,0.00,'Purchase Id 79612 for 48,250.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-02 14:38:55','',''),('5','182',3858564,'','20','3478',716600.55,0.00,'Sales from shift 234936 on 2021-11-09 14:08:06 ','2021-11-09 14:08:06','',''),('5','182',3858565,'','6.1','3477',0.00,716600.55,'Sales from shift 234936 on 2021-11-09 14:08:06 ','2021-11-09 14:08:06','',''),('5','182',3858731,'','20','3478',437130.90,0.00,'Sales from shift 237758 on 2021-11-09 14:15:11 ','2021-11-09 14:15:11','',''),('5','182',3858732,'','6.1','3477',0.00,437130.90,'Sales from shift 237758 on 2021-11-09 14:15:11 ','2021-11-09 14:15:11','',''),('5','182',3858881,'','20','3478',782879.10,0.00,'Sales from shift 237764 on 2021-11-09 14:21:49 ','2021-11-09 14:21:49','',''),('5','182',3858882,'','6.1','3477',0.00,782879.10,'Sales from shift 237764 on 2021-11-09 14:21:49 ','2021-11-09 14:21:49','',''),('5','182',3858992,'','20','3478',877884.15,0.00,'Sales from shift 237767 on 2021-11-09 14:26:30 ','2021-11-09 14:26:30','',''),('5','182',3858993,'','6.1','3477',0.00,877884.15,'Sales from shift 237767 on 2021-11-09 14:26:30 ','2021-11-09 14:26:30','',''),('5','182',3859045,'','24','3474',0.00,7961250.00,'Purchase Id 79611 for 48,250.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-09 14:29:12','',''),('5','182',3859046,'','supplier','252',7961250.00,0.00,'Purchase Id 79611 for 48,250.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-09 14:29:12','',''),('5','182',3859095,'','20','3478',1817325.30,0.00,'Sales from shift 237768 on 2021-11-09 14:31:20 ','2021-11-09 14:31:20','',''),('5','182',3859096,'','6.1','3477',0.00,1817325.30,'Sales from shift 237768 on 2021-11-09 14:31:20 ','2021-11-09 14:31:20','',''),('5','182',3859188,'','20','3478',3060239.25,0.00,'Sales from shift 237769 on 2021-11-09 14:35:49 ','2021-11-09 14:35:49','',''),('5','182',3859189,'','6.1','3477',0.00,3060239.25,'Sales from shift 237769 on 2021-11-09 14:35:49 ','2021-11-09 14:35:49','',''),('5','182',3861595,'','6.1','3477',15450.00,0.00,'Payment Id 358150 for invoice:237767, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861596,'','supplier','252',0.00,15450.00,'Payment Id 358150 for invoice:237767, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861597,'','2','3681',862435.00,0.00,'Payment Id 358149 for invoice:237767, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861598,'','supplier','252',0.00,862435.00,'Payment Id 358149 for invoice:237767, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861599,'','6.1','3477',13800.00,0.00,'Payment Id 358146 for invoice:237764, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861600,'','supplier','252',0.00,13800.00,'Payment Id 358146 for invoice:237764, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861601,'','2','3681',769080.00,0.00,'Payment Id 358145 for invoice:237764, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861602,'','supplier','252',0.00,769080.00,'Payment Id 358145 for invoice:237764, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861603,'','6.1','3477',186300.00,0.00,'Payment Id 358144 for invoice:237758, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861604,'','supplier','252',0.00,186300.00,'Payment Id 358144 for invoice:237758, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861605,'','2','3681',250830.00,0.00,'Payment Id 358143 for invoice:237758, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861606,'','supplier','252',0.00,250830.00,'Payment Id 358143 for invoice:237758, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861607,'','6.1','3477',239700.00,0.00,'Payment Id 358142 for invoice:234936, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861608,'','supplier','252',0.00,239700.00,'Payment Id 358142 for invoice:234936, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861609,'','2','3681',476930.00,0.00,'Payment Id 358141 for invoice:234936, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3861610,'','supplier','252',0.00,476930.00,'Payment Id 358141 for invoice:234936, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-09 16:23:27','',''),('5','182',3863998,'','6.1','3477',227250.00,0.00,'Payment Id 358282 for invoice:237770, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3863999,'','supplier','252',0.00,227250.00,'Payment Id 358282 for invoice:237770, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864000,'','2','3681',1865420.00,0.00,'Payment Id 358281 for invoice:237770, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864001,'','supplier','252',0.00,1865420.00,'Payment Id 358281 for invoice:237770, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864002,'','6.1','3477',153450.00,0.00,'Payment Id 358280 for invoice:237769, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864003,'','supplier','252',0.00,153450.00,'Payment Id 358280 for invoice:237769, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864004,'','2','3681',2906790.00,0.00,'Payment Id 358276 for invoice:237769, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864005,'','supplier','252',0.00,2906790.00,'Payment Id 358276 for invoice:237769, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864006,'','6.1','3477',136410.00,0.00,'Payment Id 358274 for invoice:237768, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864007,'','supplier','252',0.00,136410.00,'Payment Id 358274 for invoice:237768, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864008,'','2','3681',1680920.00,0.00,'Payment Id 358272 for invoice:237768, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3864009,'','supplier','252',0.00,1680920.00,'Payment Id 358272 for invoice:237768, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 06:40:29','',''),('5','182',3867114,'','20','3478',2092670.25,0.00,'Sales from shift 237770 on 2021-11-10 09:48:43 ','2021-11-10 09:48:43','',''),('5','182',3867115,'','6.1','3477',0.00,2092670.25,'Sales from shift 237770 on 2021-11-10 09:48:43 ','2021-11-10 09:48:43','',''),('5','182',3867144,'','20','3478',172500.00,0.00,'Sales from shift 237959 on 2021-11-10 09:50:46 ','2021-11-10 09:50:46','',''),('5','182',3867145,'','6.1','3477',0.00,172500.00,'Sales from shift 237959 on 2021-11-10 09:50:46 ','2021-11-10 09:50:46','',''),('5','182',3867164,'','20','3478',120373.95,0.00,'Sales from shift 237960 on 2021-11-10 09:52:16 ','2021-11-10 09:52:16','',''),('5','182',3867165,'','6.1','3477',0.00,120373.95,'Sales from shift 237960 on 2021-11-10 09:52:16 ','2021-11-10 09:52:16','',''),('5','182',3867184,'','20','3478',73295.25,0.00,'Sales from shift 237962 on 2021-11-10 09:54:23 ','2021-11-10 09:54:23','',''),('5','182',3867185,'','6.1','3477',0.00,73295.25,'Sales from shift 237962 on 2021-11-10 09:54:23 ','2021-11-10 09:54:23','',''),('5','182',3867232,'','20','3478',172558.65,0.00,'Sales from shift 237963 on 2021-11-10 09:56:22 ','2021-11-10 09:56:22','',''),('5','182',3867233,'','6.1','3477',0.00,172558.65,'Sales from shift 237963 on 2021-11-10 09:56:22 ','2021-11-10 09:56:22','',''),('5','182',3867265,'','20','3478',97607.40,0.00,'Sales from shift 237965 on 2021-11-10 09:58:18 ','2021-11-10 09:58:18','',''),('5','182',3867266,'','6.1','3477',0.00,97607.40,'Sales from shift 237965 on 2021-11-10 09:58:18 ','2021-11-10 09:58:18','',''),('5','182',3867291,'','20','3478',216228.75,0.00,'Sales from shift 237968 on 2021-11-10 10:00:08 ','2021-11-10 10:00:08','',''),('5','182',3867292,'','6.1','3477',0.00,216228.75,'Sales from shift 237968 on 2021-11-10 10:00:08 ','2021-11-10 10:00:08','',''),('5','182',3867627,'','6.1','3477',81750.00,0.00,'Payment Id 358474 for invoice:239760, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867628,'','supplier','252',0.00,81750.00,'Payment Id 358474 for invoice:239760, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867629,'','2','3681',38625.00,0.00,'Payment Id 358473 for invoice:239760, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867630,'','supplier','252',0.00,38625.00,'Payment Id 358473 for invoice:239760, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867631,'','6.1','3477',172550.00,0.00,'Payment Id 358469 for invoice:237959, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867632,'','supplier','252',0.00,172550.00,'Payment Id 358469 for invoice:237959, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:12','',''),('5','182',3867633,'','2','3681',59495.00,0.00,'Payment Id 358476 for invoice:237962, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:26','',''),('5','182',3867634,'','supplier','252',0.00,59495.00,'Payment Id 358476 for invoice:237962, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-10 10:16:26','',''),('5','182',3867734,'','6.1','3477',222450.00,0.00,'Payment Id 358479 for invoice:237963, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867735,'','supplier','252',0.00,222450.00,'Payment Id 358479 for invoice:237963, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867736,'','2','3681',53610.00,0.00,'Payment Id 358478 for invoice:237963, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867737,'','supplier','252',0.00,53610.00,'Payment Id 358478 for invoice:237963, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867738,'','6.1','3477',13800.00,0.00,'Payment Id 358477 for invoice:237962, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867739,'','supplier','252',0.00,13800.00,'Payment Id 358477 for invoice:237962, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:28','',''),('5','182',3867744,'','2','3681',82160.00,0.00,'Payment Id 358483 for invoice:237965, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:39','',''),('5','182',3867745,'','supplier','252',0.00,82160.00,'Payment Id 358483 for invoice:237965, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-10 10:22:39','',''),('5','182',3883386,'','20','3478',155871.00,0.00,'Sales from shift 237969 on 2021-11-11 13:04:45 ','2021-11-11 13:04:45','',''),('5','182',3883387,'','6.1','3477',0.00,155871.00,'Sales from shift 237969 on 2021-11-11 13:04:45 ','2021-11-11 13:04:45','',''),('5','182',3883394,'','6.1','3477',15450.00,0.00,'Payment Id 359123 for invoice:237969, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883395,'','supplier','252',0.00,15450.00,'Payment Id 359123 for invoice:237969, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883396,'','2','3681',140420.00,0.00,'Payment Id 359120 for invoice:237969, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883397,'','supplier','252',0.00,140420.00,'Payment Id 359120 for invoice:237969, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883398,'','6.1','3477',15450.00,0.00,'Payment Id 358488 for invoice:237968, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883399,'','supplier','252',0.00,15450.00,'Payment Id 358488 for invoice:237968, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883400,'','2','3681',200780.00,0.00,'Payment Id 358487 for invoice:237698, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883401,'','supplier','252',0.00,200780.00,'Payment Id 358487 for invoice:237698, receipt: 58082 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883402,'','6.1','3477',15450.00,0.00,'Payment Id 358486 for invoice:237965, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3883403,'','supplier','252',0.00,15450.00,'Payment Id 358486 for invoice:237965, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-11 13:05:08','',''),('5','182',3894428,'','20','3478',0.00,0.00,'Sales from shift 238255 on 2021-11-12 09:51:46 ','2021-11-12 09:51:46','',''),('5','182',3894429,'','6.1','3477',0.00,0.00,'Sales from shift 238255 on 2021-11-12 09:51:46 ','2021-11-12 09:51:46','',''),('5','182',3930209,'','24','3474',0.00,4892250.00,'Purchase Id 80595 for 29,650.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-15 09:42:11','',''),('5','182',3930210,'','supplier','252',4892250.00,0.00,'Purchase Id 80595 for 29,650.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-15 09:42:11','',''),('5','182',3930211,'','20','3478',83017.35,0.00,'Sales from shift 239138 on 2021-11-15 09:42:33 ','2021-11-15 09:42:33','',''),('5','182',3930212,'','6.1','3477',0.00,83017.35,'Sales from shift 239138 on 2021-11-15 09:42:33 ','2021-11-15 09:42:33','',''),('5','182',3930263,'','20','3478',95851.35,0.00,'Sales from shift 239149 on 2021-11-15 09:47:44 ','2021-11-15 09:47:44','',''),('5','182',3930264,'','6.1','3477',0.00,95851.35,'Sales from shift 239149 on 2021-11-15 09:47:44 ','2021-11-15 09:47:44','',''),('5','182',3937929,'','6.1','3477',97400.00,0.00,'Payment Id 360985 for invoice:239150, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937930,'','supplier','252',0.00,97400.00,'Payment Id 360985 for invoice:239150, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937931,'','2','3681',554765.00,0.00,'Payment Id 360983 for invoice:239150, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937932,'','supplier','252',0.00,554765.00,'Payment Id 360983 for invoice:239150, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937933,'','6.1','3477',13800.00,0.00,'Payment Id 360981 for invoice:239149, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937934,'','supplier','252',0.00,13800.00,'Payment Id 360981 for invoice:239149, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937935,'','2','3681',82050.00,0.00,'Payment Id 360980 for invoice:239149, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937936,'','supplier','252',0.00,82050.00,'Payment Id 360980 for invoice:239149, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937937,'','2','3681',13800.00,0.00,'Payment Id 360978 for invoice:239138, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937938,'','supplier','252',0.00,13800.00,'Payment Id 360978 for invoice:239138, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937939,'','2','3681',69220.00,0.00,'Payment Id 360977 for invoice:239138, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937940,'','supplier','252',0.00,69220.00,'Payment Id 360977 for invoice:239138, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-15 19:10:46','',''),('5','182',3937941,'','20','3478',652165.05,0.00,'Sales from shift 239164 on 2021-11-15 19:11:11 ','2021-11-15 19:11:11','',''),('5','182',3937942,'','6.1','3477',0.00,652165.05,'Sales from shift 239164 on 2021-11-15 19:11:11 ','2021-11-15 19:11:11','',''),('5','182',3942083,'','20','3478',1753780.05,0.00,'Sales from shift 239371 on 2021-11-16 10:20:55 ','2021-11-16 10:20:55','',''),('5','182',3942084,'','6.1','3477',0.00,1753780.05,'Sales from shift 239371 on 2021-11-16 10:20:55 ','2021-11-16 10:20:55','',''),('5','182',3942091,'','6.1','3477',39950.00,0.00,'Payment Id 361575 for invoice:239371, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-16 10:21:11','',''),('5','182',3942092,'','supplier','252',0.00,39950.00,'Payment Id 361575 for invoice:239371, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-16 10:21:11','',''),('5','182',3942093,'','2','3681',1713830.00,0.00,'Payment Id 361569 for invoice:239371, receipt: 57342 by SALBAS OIL & GAS LIMITED','2021-11-16 10:21:11','',''),('5','182',3942094,'','supplier','252',0.00,1713830.00,'Payment Id 361569 for invoice:239371, receipt: 57342 by SALBAS OIL & GAS LIMITED','2021-11-16 10:21:11','',''),('5','182',3961816,'','6.1','3477',15450.00,0.00,'Payment Id 362155 for invoice:239383, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-17 18:26:24','',''),('5','182',3961817,'','supplier','252',0.00,15450.00,'Payment Id 362155 for invoice:239383, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-17 18:26:24','',''),('5','182',3961818,'','2','3681',1084200.00,0.00,'Payment Id 362154 for invoice:239383, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-17 18:26:24','',''),('5','182',3961819,'','supplier','252',0.00,1084200.00,'Payment Id 362154 for invoice:239383, receipt: 49356 by SALBAS OIL & GAS LIMITED','2021-11-17 18:26:24','',''),('5','182',3961820,'','20','3478',1099652.40,0.00,'Sales from shift 239383 on 2021-11-17 18:26:42 ','2021-11-17 18:26:42','',''),('5','182',3961821,'','6.1','3477',0.00,1099652.40,'Sales from shift 239383 on 2021-11-17 18:26:42 ','2021-11-17 18:26:42','',''),('5','182',3965836,'','6.1','3477',15450.00,0.00,'Payment Id 362696 for invoice:239841, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-18 09:56:11','',''),('5','182',3965837,'','supplier','252',0.00,15450.00,'Payment Id 362696 for invoice:239841, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-18 09:56:11','',''),('5','182',3965838,'','2','3681',1131500.00,0.00,'Payment Id 362694 for invoice:239841, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-18 09:56:11','',''),('5','182',3965839,'','supplier','252',0.00,1131500.00,'Payment Id 362694 for invoice:239841, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-18 09:56:11','',''),('5','182',3965853,'','20','3478',1146948.15,0.00,'Sales from shift 239841 on 2021-11-18 09:56:52 ','2021-11-18 09:56:52','',''),('5','182',3965854,'','6.1','3477',0.00,1146948.15,'Sales from shift 239841 on 2021-11-18 09:56:52 ','2021-11-18 09:56:52','',''),('5','182',3985144,'','6.1','3477',15450.00,0.00,'Payment Id 363268 for invoice:240063, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-19 17:34:18','',''),('5','182',3985145,'','supplier','252',0.00,15450.00,'Payment Id 363268 for invoice:240063, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-19 17:34:18','',''),('5','182',3985146,'','2','3681',316130.00,0.00,'Payment Id 363267 for invoice:240063, receipt: 58018 by SALBAS OIL & GAS LIMITED','2021-11-19 17:34:18','',''),('5','182',3985147,'','supplier','252',0.00,316130.00,'Payment Id 363267 for invoice:240063, receipt: 58018 by SALBAS OIL & GAS LIMITED','2021-11-19 17:34:18','',''),('5','182',3985150,'','20','3478',331580.70,0.00,'Sales from shift 240063 on 2021-11-19 17:34:42 ','2021-11-19 17:34:42','',''),('5','182',3985151,'','6.1','3477',0.00,331580.70,'Sales from shift 240063 on 2021-11-19 17:34:42 ','2021-11-19 17:34:42','',''),('5','182',4014150,'','24','3474',0.00,4950000.00,'Purchase Id 85365 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-22 08:46:13','',''),('5','182',4014151,'','supplier','252',4950000.00,0.00,'Purchase Id 85365 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-11-22 08:46:13','',''),('5','182',4014152,'','20','3478',0.00,0.00,'Sales from shift 240760 on 2021-11-22 08:46:34 ','2021-11-22 08:46:34','',''),('5','182',4014153,'','6.1','3477',0.00,0.00,'Sales from shift 240760 on 2021-11-22 08:46:34 ','2021-11-22 08:46:34','',''),('5','182',4014897,'','20','3478',953876.25,0.00,'Sales from shift 240763 on 2021-11-22 09:41:25 ','2021-11-22 09:41:25','',''),('5','182',4014898,'','6.1','3477',0.00,953876.25,'Sales from shift 240763 on 2021-11-22 09:41:25 ','2021-11-22 09:41:25','',''),('5','182',4016034,'','20','3478',1060852.65,0.00,'Sales from shift 240777 on 2021-11-22 10:57:49 ','2021-11-22 10:57:49','',''),('5','182',4016035,'','6.1','3477',0.00,1060852.65,'Sales from shift 240777 on 2021-11-22 10:57:49 ','2021-11-22 10:57:49','',''),('5','182',4016046,'','6.1','3477',15450.00,0.00,'Payment Id 364500 for invoice:240777, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016047,'','supplier','252',0.00,15450.00,'Payment Id 364500 for invoice:240777, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016048,'','2','3681',1045400.00,0.00,'Payment Id 364499 for invoice:240777, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016049,'','supplier','252',0.00,1045400.00,'Payment Id 364499 for invoice:240777, receipt: 58079 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016050,'','6.1','3477',13800.00,0.00,'Payment Id 364489 for invoice:240763, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016051,'','supplier','252',0.00,13800.00,'Payment Id 364489 for invoice:240763, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016052,'','2','3681',940075.00,0.00,'Payment Id 364487 for invoice:240763, receipt: 57341 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4016053,'','supplier','252',0.00,940075.00,'Payment Id 364487 for invoice:240763, receipt: 57341 by SALBAS OIL & GAS LIMITED','2021-11-22 10:58:33','',''),('5','182',4037563,'','6.1','3477',55450.00,0.00,'Payment Id 365153 for invoice:240788, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-23 21:32:22','',''),('5','182',4037564,'','supplier','252',0.00,55450.00,'Payment Id 365153 for invoice:240788, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-23 21:32:22','',''),('5','182',4037565,'','2','3681',929065.00,0.00,'Payment Id 365134 for invoice:240788, receipt: 90267 by SALBAS OIL & GAS LIMITED','2021-11-23 21:32:22','',''),('5','182',4037566,'','supplier','252',0.00,929065.00,'Payment Id 365134 for invoice:240788, receipt: 90267 by SALBAS OIL & GAS LIMITED','2021-11-23 21:32:22','',''),('5','182',4040445,'','20','3478',984513.75,0.00,'Sales from shift 240788 on 2021-11-24 08:51:37 ','2021-11-24 08:51:37','',''),('5','182',4040446,'','6.1','3477',0.00,984513.75,'Sales from shift 240788 on 2021-11-24 08:51:37 ','2021-11-24 08:51:37','',''),('5','182',4044800,'','20','3478',1108461.75,0.00,'Sales from shift 241317 on 2021-11-24 14:10:19 ','2021-11-24 14:10:19','',''),('5','182',4044801,'','6.1','3477',0.00,1108461.75,'Sales from shift 241317 on 2021-11-24 14:10:19 ','2021-11-24 14:10:19','',''),('5','182',4044806,'','6.1','3477',15450.00,0.00,'Payment Id 365862 for invoice:241317, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-24 14:10:41','',''),('5','182',4044807,'','supplier','252',0.00,15450.00,'Payment Id 365862 for invoice:241317, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-24 14:10:41','',''),('5','182',4044808,'','2','3681',1093010.00,0.00,'Payment Id 365861 for invoice:241317, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-24 14:10:41','',''),('5','182',4044809,'','supplier','252',0.00,1093010.00,'Payment Id 365861 for invoice:241317, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-11-24 14:10:41','',''),('5','182',4054438,'','20','3478',699788.85,0.00,'Sales from shift 241595 on 2021-11-25 10:43:34 ','2021-11-25 10:43:34','',''),('5','182',4054439,'','6.1','3477',0.00,699788.85,'Sales from shift 241595 on 2021-11-25 10:43:34 ','2021-11-25 10:43:34','',''),('5','182',4054450,'','6.1','3477',15450.00,0.00,'Payment Id 366487 for invoice:241595, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-25 10:44:19','',''),('5','182',4054451,'','supplier','252',0.00,15450.00,'Payment Id 366487 for invoice:241595, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-25 10:44:19','',''),('5','182',4054452,'','2','3681',684245.00,0.00,'Payment Id 366483 for invoice:241595, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-25 10:44:19','',''),('5','182',4054453,'','supplier','252',0.00,684245.00,'Payment Id 366483 for invoice:241595, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-25 10:44:19','',''),('5','182',4067048,'','6.1','3477',19450.00,0.00,'Payment Id 367006 for invoice:241601, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-26 10:28:54','',''),('5','182',4067049,'','supplier','252',0.00,19450.00,'Payment Id 367006 for invoice:241601, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-11-26 10:28:54','',''),('5','182',4067050,'','2','3681',175800.00,0.00,'Payment Id 367005 for invoice:241601, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-26 10:28:54','',''),('5','182',4067051,'','supplier','252',0.00,175800.00,'Payment Id 367005 for invoice:241601, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-11-26 10:28:54','',''),('5','182',4067059,'','20','3478',195244.50,0.00,'Sales from shift 241601 on 2021-11-26 10:29:15 ','2021-11-26 10:29:15','',''),('5','182',4067060,'','6.1','3477',0.00,195244.50,'Sales from shift 241601 on 2021-11-26 10:29:15 ','2021-11-26 10:29:15','',''),('5','182',4129654,'','20','3478',0.00,0.00,'Sales from shift 241837 on 2021-12-01 09:07:53 ','2021-12-01 09:07:53','',''),('5','182',4129655,'','6.1','3477',0.00,0.00,'Sales from shift 241837 on 2021-12-01 09:07:53 ','2021-12-01 09:07:53','',''),('5','182',4129807,'','20','3478',0.00,0.00,'Sales from shift 242995 on 2021-12-01 09:14:07 ','2021-12-01 09:14:07','',''),('5','182',4129808,'','6.1','3477',0.00,0.00,'Sales from shift 242995 on 2021-12-01 09:14:07 ','2021-12-01 09:14:07','',''),('5','182',4129845,'','20','3478',0.00,0.00,'Sales from shift 242997 on 2021-12-01 09:16:04 ','2021-12-01 09:16:04','',''),('5','182',4129846,'','6.1','3477',0.00,0.00,'Sales from shift 242997 on 2021-12-01 09:16:04 ','2021-12-01 09:16:04','',''),('5','182',4129874,'','20','3478',0.00,0.00,'Sales from shift 242999 on 2021-12-01 09:17:57 ','2021-12-01 09:17:57','',''),('5','182',4129875,'','6.1','3477',0.00,0.00,'Sales from shift 242999 on 2021-12-01 09:17:57 ','2021-12-01 09:17:57','',''),('5','182',4138890,'','20','3478',0.00,0.00,'Sales from shift 243000 on 2021-12-01 19:59:27 ','2021-12-01 19:59:27','',''),('5','182',4138891,'','6.1','3477',0.00,0.00,'Sales from shift 243000 on 2021-12-01 19:59:27 ','2021-12-01 19:59:27','',''),('5','182',4153565,'','20','3478',0.00,0.00,'Sales from shift 243287 on 2021-12-03 05:34:32 ','2021-12-03 05:34:32','',''),('5','182',4153566,'','6.1','3477',0.00,0.00,'Sales from shift 243287 on 2021-12-03 05:34:32 ','2021-12-03 05:34:32','',''),('5','182',4192986,'','20','3478',0.00,0.00,'Sales from shift 243428 on 2021-12-06 07:43:23 ','2021-12-06 07:43:23','',''),('5','182',4192987,'','6.1','3477',0.00,0.00,'Sales from shift 243428 on 2021-12-06 07:43:23 ','2021-12-06 07:43:23','',''),('5','182',4193049,'','20','3478',0.00,0.00,'Sales from shift 244101 on 2021-12-06 07:46:13 ','2021-12-06 07:46:13','',''),('5','182',4193050,'','6.1','3477',0.00,0.00,'Sales from shift 244101 on 2021-12-06 07:46:13 ','2021-12-06 07:46:13','',''),('5','182',4193119,'','20','3478',0.00,0.00,'Sales from shift 244103 on 2021-12-06 07:49:35 ','2021-12-06 07:49:35','',''),('5','182',4193120,'','6.1','3477',0.00,0.00,'Sales from shift 244103 on 2021-12-06 07:49:35 ','2021-12-06 07:49:35','',''),('5','182',4193176,'','20','3478',0.00,0.00,'Sales from shift 244107 on 2021-12-06 07:51:41 ','2021-12-06 07:51:41','',''),('5','182',4193177,'','6.1','3477',0.00,0.00,'Sales from shift 244107 on 2021-12-06 07:51:41 ','2021-12-06 07:51:41','',''),('5','182',4205507,'','20','3478',0.00,0.00,'Sales from shift 244110 on 2021-12-07 06:16:30 ','2021-12-07 06:16:30','',''),('5','182',4205508,'','6.1','3477',0.00,0.00,'Sales from shift 244110 on 2021-12-07 06:16:30 ','2021-12-07 06:16:30','',''),('5','182',4219834,'','20','3478',0.00,0.00,'Sales from shift 244398 on 2021-12-07 21:45:48 ','2021-12-07 21:45:48','',''),('5','182',4219835,'','6.1','3477',0.00,0.00,'Sales from shift 244398 on 2021-12-07 21:45:48 ','2021-12-07 21:45:48','',''),('5','182',4234740,'','20','3478',0.00,0.00,'Sales from shift 244570 on 2021-12-09 08:27:16 ','2021-12-09 08:27:16','',''),('5','182',4234741,'','6.1','3477',0.00,0.00,'Sales from shift 244570 on 2021-12-09 08:27:16 ','2021-12-09 08:27:16','',''),('5','182',4249559,'','20','3478',0.00,0.00,'Sales from shift 244817 on 2021-12-10 09:22:47 ','2021-12-10 09:22:47','',''),('5','182',4249560,'','6.1','3477',0.00,0.00,'Sales from shift 244817 on 2021-12-10 09:22:47 ','2021-12-10 09:22:47','',''),('5','182',4271619,'','20','3478',0.00,0.00,'Sales from shift 245107 on 2021-12-11 17:30:03 ','2021-12-11 17:30:03','',''),('5','182',4271620,'','6.1','3477',0.00,0.00,'Sales from shift 245107 on 2021-12-11 17:30:03 ','2021-12-11 17:30:03','',''),('5','182',4272600,'','20','3478',0.00,0.00,'Sales from shift 245380 on 2021-12-11 20:37:48 ','2021-12-11 20:37:48','',''),('5','182',4272601,'','6.1','3477',0.00,0.00,'Sales from shift 245380 on 2021-12-11 20:37:48 ','2021-12-11 20:37:48','',''),('5','182',4290603,'','20','3478',0.00,0.00,'Sales from shift 245487 on 2021-12-13 11:12:17 ','2021-12-13 11:12:17','',''),('5','182',4290604,'','6.1','3477',0.00,0.00,'Sales from shift 245487 on 2021-12-13 11:12:17 ','2021-12-13 11:12:17','',''),('5','182',4300556,'','20','3478',0.00,0.00,'Sales from shift 245788 on 2021-12-14 08:38:12 ','2021-12-14 08:38:12','',''),('5','182',4300557,'','6.1','3477',0.00,0.00,'Sales from shift 245788 on 2021-12-14 08:38:12 ','2021-12-14 08:38:12','',''),('5','182',4312791,'','20','3478',0.00,0.00,'Sales from shift 246033 on 2021-12-15 09:03:16 ','2021-12-15 09:03:16','',''),('5','182',4312792,'','6.1','3477',0.00,0.00,'Sales from shift 246033 on 2021-12-15 09:03:16 ','2021-12-15 09:03:16','',''),('5','182',4312821,'','24','3474',0.00,2442000.00,'Purchase Id 87256 for 14,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-12-15 09:04:19','',''),('5','182',4312822,'','supplier','252',2442000.00,0.00,'Purchase Id 87256 for 14,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2021-12-15 09:04:19','',''),('5','182',4327312,'','20','3478',233743.95,0.00,'Sales from shift 246273 on 2021-12-16 08:39:04 ','2021-12-16 08:39:04','',''),('5','182',4327313,'','6.1','3477',0.00,233743.95,'Sales from shift 246273 on 2021-12-16 08:39:04 ','2021-12-16 08:39:04','',''),('5','182',4334999,'','6.1','3477',29250.00,0.00,'Payment Id 377550 for invoice:246273, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-16 15:06:56','',''),('5','182',4335000,'','supplier','252',0.00,29250.00,'Payment Id 377550 for invoice:246273, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-16 15:06:56','',''),('5','182',4335001,'','2','3681',204500.00,0.00,'Payment Id 377539 for invoice:246273, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-12-16 15:06:56','',''),('5','182',4335002,'','supplier','252',0.00,204500.00,'Payment Id 377539 for invoice:246273, receipt: 47179 by SALBAS OIL & GAS LIMITED','2021-12-16 15:06:56','',''),('5','182',4342362,'','20','3478',530365.20,0.00,'Sales from shift 246529 on 2021-12-17 09:10:34 ','2021-12-17 09:10:34','',''),('5','182',4342363,'','6.1','3477',0.00,530365.20,'Sales from shift 246529 on 2021-12-17 09:10:34 ','2021-12-17 09:10:34','',''),('5','182',4347497,'','6.1','3477',252150.00,0.00,'Payment Id 378249 for invoice:246529, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-17 14:14:14','',''),('5','182',4347498,'','supplier','252',0.00,252150.00,'Payment Id 378249 for invoice:246529, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-17 14:14:14','',''),('5','182',4347499,'','2','3681',278200.00,0.00,'Payment Id 378248 for invoice:246529, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-12-17 14:14:14','',''),('5','182',4347500,'','supplier','252',0.00,278200.00,'Payment Id 378248 for invoice:246529, receipt: 471779 by SALBAS OIL & GAS LIMITED','2021-12-17 14:14:14','',''),('5','182',4353202,'','20','3478',424812.30,0.00,'Sales from shift 246776 on 2021-12-18 06:53:39 ','2021-12-18 06:53:39','',''),('5','182',4353203,'','6.1','3477',0.00,424812.30,'Sales from shift 246776 on 2021-12-18 06:53:39 ','2021-12-18 06:53:39','',''),('5','182',4381695,'','20','3478',433326.30,0.00,'Sales from shift 247117 on 2021-12-19 17:33:59 ','2021-12-19 17:33:59','',''),('5','182',4381696,'','6.1','3477',0.00,433326.30,'Sales from shift 247117 on 2021-12-19 17:33:59 ','2021-12-19 17:33:59','',''),('5','182',4382378,'','20','3478',373781.10,0.00,'Sales from shift 247354 on 2021-12-20 06:12:59 ','2021-12-20 06:12:59','',''),('5','182',4382379,'','6.1','3477',0.00,373781.10,'Sales from shift 247354 on 2021-12-20 06:12:59 ','2021-12-20 06:12:59','',''),('5','182',4394430,'','6.1','3477',15450.00,0.00,'Payment Id 379662 for invoice:247354, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394431,'','supplier','252',0.00,15450.00,'Payment Id 379662 for invoice:247354, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394432,'','2','3681',358330.00,0.00,'Payment Id 379661 for invoice:247354, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394433,'','supplier','252',0.00,358330.00,'Payment Id 379661 for invoice:247354, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394434,'','6.1','3477',13800.00,0.00,'Payment Id 379659 for invoice:247117, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394435,'','supplier','252',0.00,13800.00,'Payment Id 379659 for invoice:247117, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394436,'','2','3681',419525.00,0.00,'Payment Id 379656 for invoice:247117, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394437,'','supplier','252',0.00,419525.00,'Payment Id 379656 for invoice:247117, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394438,'','6.1','3477',16300.00,0.00,'Payment Id 379653 for invoice:246776, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394439,'','supplier','252',0.00,16300.00,'Payment Id 379653 for invoice:246776, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394440,'','2','3681',408515.00,0.00,'Payment Id 379648 for invoice:246776, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394441,'','supplier','252',0.00,408515.00,'Payment Id 379648 for invoice:246776, receipt: 57346 by SALBAS OIL & GAS LIMITED','2021-12-20 18:02:06','',''),('5','182',4394442,'','20','3478',360289.05,0.00,'Sales from shift 247408 on 2021-12-20 18:02:24 ','2021-12-20 18:02:24','',''),('5','182',4394443,'','6.1','3477',0.00,360289.05,'Sales from shift 247408 on 2021-12-20 18:02:24 ','2021-12-20 18:02:24','',''),('5','182',4405003,'','6.1','3477',25450.00,0.00,'Payment Id 380229 for invoice:247408, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-21 14:54:21','',''),('5','182',4405004,'','supplier','252',0.00,25450.00,'Payment Id 380229 for invoice:247408, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-21 14:54:21','',''),('5','182',4405005,'','2','3681',334840.00,0.00,'Payment Id 380225 for invoice:247408, receipt: 06896 by SALBAS OIL & GAS LIMITED','2021-12-21 14:54:21','',''),('5','182',4405006,'','supplier','252',0.00,334840.00,'Payment Id 380225 for invoice:247408, receipt: 06896 by SALBAS OIL & GAS LIMITED','2021-12-21 14:54:21','',''),('5','182',4414966,'','20','3478',99460.35,0.00,'Sales from shift 247725 on 2021-12-22 09:54:24 ','2021-12-22 09:54:24','',''),('5','182',4414967,'','6.1','3477',0.00,99460.35,'Sales from shift 247725 on 2021-12-22 09:54:24 ','2021-12-22 09:54:24','',''),('5','182',4425431,'','20','3478',0.00,0.00,'Sales from shift 248015 on 2021-12-22 18:17:19 ','2021-12-22 18:17:19','',''),('5','182',4425432,'','6.1','3477',0.00,0.00,'Sales from shift 248015 on 2021-12-22 18:17:19 ','2021-12-22 18:17:19','',''),('5','182',4425437,'','6.1','3477',15450.00,0.00,'Payment Id 380767 for invoice:247725, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-22 18:17:43','',''),('5','182',4425438,'','supplier','252',0.00,15450.00,'Payment Id 380767 for invoice:247725, receipt: 1 by SALBAS OIL & GAS LIMITED','2021-12-22 18:17:43','',''),('5','182',4425439,'','2','3681',84010.00,0.00,'Payment Id 380766 for invoice:247725, receipt: 06899 by SALBAS OIL & GAS LIMITED','2021-12-22 18:17:43','',''),('5','182',4425440,'','supplier','252',0.00,84010.00,'Payment Id 380766 for invoice:247725, receipt: 06899 by SALBAS OIL & GAS LIMITED','2021-12-22 18:17:43','',''),('5','182',4453114,'','20','3478',0.00,0.00,'Sales from shift 248174 on 2021-12-24 14:08:58 ','2021-12-24 14:08:58','',''),('5','182',4453115,'','6.1','3477',0.00,0.00,'Sales from shift 248174 on 2021-12-24 14:08:58 ','2021-12-24 14:08:58','',''),('5','182',4470870,'','20','3478',0.00,0.00,'Sales from shift 248563 on 2021-12-25 17:04:47 ','2021-12-25 17:04:47','',''),('5','182',4470871,'','6.1','3477',0.00,0.00,'Sales from shift 248563 on 2021-12-25 17:04:47 ','2021-12-25 17:04:47','',''),('5','182',4472103,'','20','3478',0.00,0.00,'Sales from shift 248812 on 2021-12-26 07:26:02 ','2021-12-26 07:26:02','',''),('5','182',4472104,'','6.1','3477',0.00,0.00,'Sales from shift 248812 on 2021-12-26 07:26:02 ','2021-12-26 07:26:02','',''),('5','182',4480678,'','20','3478',0.00,0.00,'Sales from shift 248970 on 2021-12-27 05:58:23 ','2021-12-27 05:58:23','',''),('5','182',4480679,'','6.1','3477',0.00,0.00,'Sales from shift 248970 on 2021-12-27 05:58:23 ','2021-12-27 05:58:23','',''),('5','182',4493859,'','20','3478',0.00,0.00,'Sales from shift 249206 on 2021-12-28 09:21:56 ','2021-12-28 09:21:56','',''),('5','182',4493860,'','6.1','3477',0.00,0.00,'Sales from shift 249206 on 2021-12-28 09:21:56 ','2021-12-28 09:21:56','',''),('5','182',4502776,'','20','3478',0.00,0.00,'Sales from shift 249484 on 2021-12-29 06:58:40 ','2021-12-29 06:58:40','',''),('5','182',4502777,'','6.1','3477',0.00,0.00,'Sales from shift 249484 on 2021-12-29 06:58:40 ','2021-12-29 06:58:40','',''),('5','182',4515003,'','20','3478',0.00,0.00,'Sales from shift 249794 on 2021-12-30 06:45:46 ','2021-12-30 06:45:46','',''),('5','182',4515004,'','6.1','3477',0.00,0.00,'Sales from shift 249794 on 2021-12-30 06:45:46 ','2021-12-30 06:45:46','',''),('5','182',4533357,'','20','3478',0.00,0.00,'Sales from shift 250123 on 2021-12-31 09:25:20 ','2021-12-31 09:25:20','',''),('5','182',4533358,'','6.1','3477',0.00,0.00,'Sales from shift 250123 on 2021-12-31 09:25:20 ','2021-12-31 09:25:20','',''),('5','182',4544051,'','20','3478',0.00,0.00,'Sales from shift 250185 on 2022-01-01 07:42:15 ','2022-01-01 07:42:15','',''),('5','182',4544052,'','6.1','3477',0.00,0.00,'Sales from shift 250185 on 2022-01-01 07:42:15 ','2022-01-01 07:42:15','',''),('5','182',4555016,'','20','3478',0.00,0.00,'Sales from shift 250407 on 2022-01-02 08:06:45 ','2022-01-02 08:06:45','',''),('5','182',4555017,'','6.1','3477',0.00,0.00,'Sales from shift 250407 on 2022-01-02 08:06:45 ','2022-01-02 08:06:45','',''),('5','182',4563966,'','24','3474',0.00,3737250.00,'Purchase Id 88666 for 22,650.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-03 06:58:16','',''),('5','182',4563967,'','supplier','252',3737250.00,0.00,'Purchase Id 88666 for 22,650.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-03 06:58:16','',''),('5','182',4566347,'','20','3478',637150.80,0.00,'Sales from shift 250737 on 2022-01-03 09:34:39 ','2022-01-03 09:34:39','',''),('5','182',4566348,'','6.1','3477',0.00,637150.80,'Sales from shift 250737 on 2022-01-03 09:34:39 ','2022-01-03 09:34:39','',''),('5','182',4577040,'','20','3478',594585.75,0.00,'Sales from shift 250878 on 2022-01-04 08:41:21 ','2022-01-04 08:41:21','',''),('5','182',4577041,'','6.1','3477',0.00,594585.75,'Sales from shift 250878 on 2022-01-04 08:41:21 ','2022-01-04 08:41:21','',''),('5','182',4588687,'','20','3478',876166.50,0.00,'Sales from shift 251088 on 2022-01-04 19:02:24 ','2022-01-04 19:02:24','',''),('5','182',4588688,'','6.1','3477',0.00,876166.50,'Sales from shift 251088 on 2022-01-04 19:02:24 ','2022-01-04 19:02:24','',''),('5','182',4588691,'','6.1','3477',27150.00,0.00,'Payment Id 387186 for invoice:250878, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588692,'','supplier','252',0.00,27150.00,'Payment Id 387186 for invoice:250878, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588693,'','2','3681',567435.00,0.00,'Payment Id 387185 for invoice:250878, receipt: 06897 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588694,'','supplier','252',0.00,567435.00,'Payment Id 387185 for invoice:250878, receipt: 06897 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588695,'','6.1','3477',213800.00,0.00,'Payment Id 387184 for invoice:250737, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588696,'','supplier','252',0.00,213800.00,'Payment Id 387184 for invoice:250737, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588697,'','2','3681',423350.00,0.00,'Payment Id 387182 for invoice:250737, receipt: 06897 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4588698,'','supplier','252',0.00,423350.00,'Payment Id 387182 for invoice:250737, receipt: 06897 by SALBAS OIL & GAS LIMITED','2022-01-04 19:02:44','',''),('5','182',4603822,'','6.1','3477',240450.00,0.00,'Payment Id 387777 for invoice:251088, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-05 19:10:51','',''),('5','182',4603823,'','supplier','252',0.00,240450.00,'Payment Id 387777 for invoice:251088, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-05 19:10:51','',''),('5','182',4603824,'','2','3681',635715.00,0.00,'Payment Id 387774 for invoice:251088, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-05 19:10:51','',''),('5','182',4603825,'','supplier','252',0.00,635715.00,'Payment Id 387774 for invoice:251088, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-05 19:10:51','',''),('5','182',4606371,'','20','3478',568169.25,0.00,'Sales from shift 251370 on 2022-01-06 09:24:54 ','2022-01-06 09:24:54','',''),('5','182',4606372,'','6.1','3477',0.00,568169.25,'Sales from shift 251370 on 2022-01-06 09:24:54 ','2022-01-06 09:24:54','',''),('5','182',4617410,'','20','3478',523818.90,0.00,'Sales from shift 251622 on 2022-01-07 07:02:29 ','2022-01-07 07:02:29','',''),('5','182',4617411,'','6.1','3477',0.00,523818.90,'Sales from shift 251622 on 2022-01-07 07:02:29 ','2022-01-07 07:02:29','',''),('5','182',4617416,'','6.1','3477',15450.00,0.00,'Payment Id 388457 for invoice:251370, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-07 07:02:43','',''),('5','182',4617417,'','supplier','252',0.00,15450.00,'Payment Id 388457 for invoice:251370, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-07 07:02:43','',''),('5','182',4617418,'','2','3681',552720.00,0.00,'Payment Id 388456 for invoice:251370, receipt: 59158 by SALBAS OIL & GAS LIMITED','2022-01-07 07:02:43','',''),('5','182',4617419,'','supplier','252',0.00,552720.00,'Payment Id 388456 for invoice:251370, receipt: 59158 by SALBAS OIL & GAS LIMITED','2022-01-07 07:02:43','',''),('5','182',4654080,'','20','3478',528658.35,0.00,'Sales from shift 251832 on 2022-01-09 15:50:52 ','2022-01-09 15:50:52','',''),('5','182',4654081,'','6.1','3477',0.00,528658.35,'Sales from shift 251832 on 2022-01-09 15:50:52 ','2022-01-09 15:50:52','',''),('5','182',4658201,'','20','3478',0.00,0.00,'Sales from shift 252450 on 2022-01-10 08:25:49 ','2022-01-10 08:25:49','',''),('5','182',4658202,'','6.1','3477',0.00,0.00,'Sales from shift 252450 on 2022-01-10 08:25:49 ','2022-01-10 08:25:49','',''),('5','182',4661821,'','20','3478',0.00,0.00,'Sales from shift 252580 on 2022-01-10 11:47:40 ','2022-01-10 11:47:40','',''),('5','182',4661822,'','6.1','3477',0.00,0.00,'Sales from shift 252580 on 2022-01-10 11:47:40 ','2022-01-10 11:47:40','',''),('5','182',4672089,'','20','3478',0.00,0.00,'Sales from shift 252582 on 2022-01-11 08:19:27 ','2022-01-11 08:19:27','',''),('5','182',4672090,'','6.1','3477',0.00,0.00,'Sales from shift 252582 on 2022-01-11 08:19:27 ','2022-01-11 08:19:27','',''),('5','182',4672097,'','6.1','3477',15450.00,0.00,'Payment Id 389785 for invoice:251622, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-11 08:19:42','',''),('5','182',4672098,'','supplier','252',0.00,15450.00,'Payment Id 389785 for invoice:251622, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-11 08:19:42','',''),('5','182',4672099,'','2','3681',508370.00,0.00,'Payment Id 389784 for invoice:251622, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-11 08:19:42','',''),('5','182',4672100,'','supplier','252',0.00,508370.00,'Payment Id 389784 for invoice:251622, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-11 08:19:42','',''),('5','182',4686730,'','6.1','3477',15450.00,0.00,'Payment Id 391412 for invoice:251832, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-12 08:13:42','',''),('5','182',4686731,'','supplier','252',0.00,15450.00,'Payment Id 391412 for invoice:251832, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-12 08:13:42','',''),('5','182',4686732,'','2','3681',513210.00,0.00,'Payment Id 391411 for invoice:251832, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-12 08:13:42','',''),('5','182',4686733,'','supplier','252',0.00,513210.00,'Payment Id 391411 for invoice:251832, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-01-12 08:13:42','',''),('5','182',4689684,'','24','3474',0.00,4950000.00,'Purchase Id 89346 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-12 10:35:28','',''),('5','182',4689685,'','supplier','252',4950000.00,0.00,'Purchase Id 89346 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-12 10:35:28','',''),('5','182',4700325,'','20','3478',196734.45,0.00,'Sales from shift 252935 on 2022-01-12 19:41:42 ','2022-01-12 19:41:42','',''),('5','182',4700326,'','6.1','3477',0.00,196734.45,'Sales from shift 252935 on 2022-01-12 19:41:42 ','2022-01-12 19:41:42','',''),('5','182',4700505,'','6.1','3477',15450.00,0.00,'Payment Id 391942 for invoice:252935, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-12 20:40:11','',''),('5','182',4700506,'','supplier','252',0.00,15450.00,'Payment Id 391942 for invoice:252935, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-12 20:40:11','',''),('5','182',4700507,'','2','3681',181285.00,0.00,'Payment Id 391939 for invoice:252935, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-12 20:40:11','',''),('5','182',4700508,'','supplier','252',0.00,181285.00,'Payment Id 391939 for invoice:252935, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-12 20:40:11','',''),('5','182',4700821,'','20','3478',634286.40,0.00,'Sales from shift 253152 on 2022-01-13 07:30:46 ','2022-01-13 07:30:46','',''),('5','182',4700822,'','6.1','3477',0.00,634286.40,'Sales from shift 253152 on 2022-01-13 07:30:46 ','2022-01-13 07:30:46','',''),('5','182',4708773,'','6.1','3477',15450.00,0.00,'Payment Id 392367 for invoice:253152, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-13 14:32:30','',''),('5','182',4708774,'','supplier','252',0.00,15450.00,'Payment Id 392367 for invoice:253152, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-13 14:32:30','',''),('5','182',4708775,'','2','3681',618835.00,0.00,'Payment Id 392366 for invoice:253152, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-13 14:32:30','',''),('5','182',4708776,'','supplier','252',0.00,618835.00,'Payment Id 392366 for invoice:253152, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-13 14:32:30','',''),('5','182',4714242,'','20','3478',954143.85,0.00,'Sales from shift 253265 on 2022-01-14 06:37:36 ','2022-01-14 06:37:36','',''),('5','182',4714243,'','6.1','3477',0.00,954143.85,'Sales from shift 253265 on 2022-01-14 06:37:36 ','2022-01-14 06:37:36','',''),('5','182',4714468,'','24','3474',0.00,2269410.00,'Purchase Id 89520 for 13,754.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-14 07:36:33','',''),('5','182',4714469,'','supplier','252',2269410.00,0.00,'Purchase Id 89520 for 13,754.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-01-14 07:36:33','',''),('5','182',4724256,'','6.1','3477',30600.00,0.00,'Payment Id 393169 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4724257,'','supplier','252',0.00,30600.00,'Payment Id 393169 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4724258,'','6.1','3477',30600.00,0.00,'Payment Id 393168 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4724259,'','supplier','252',0.00,30600.00,'Payment Id 393168 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4724260,'','2','3681',925195.00,0.00,'Payment Id 393166 for invoice:253265, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4724261,'','supplier','252',0.00,925195.00,'Payment Id 393166 for invoice:253265, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-14 16:33:58','',''),('5','182',4725023,'','6.1','3477',0.00,30600.00,'Payment Id 393169 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 17:00:17','',''),('5','182',4725024,'','supplier','252',30600.00,0.00,'Payment Id 393169 for invoice:253265, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-14 17:00:17','',''),('5','182',4730989,'','20','3478',830276.70,0.00,'Sales from shift 253516 on 2022-01-15 09:58:13 ','2022-01-15 09:58:13','',''),('5','182',4730990,'','6.1','3477',0.00,830276.70,'Sales from shift 253516 on 2022-01-15 09:58:13 ','2022-01-15 09:58:13','',''),('5','182',4743813,'','20','3478',760277.10,0.00,'Sales from shift 253948 on 2022-01-16 06:54:11 ','2022-01-16 06:54:11','',''),('5','182',4743814,'','6.1','3477',0.00,760277.10,'Sales from shift 253948 on 2022-01-16 06:54:11 ','2022-01-16 06:54:11','',''),('5','182',4757749,'','20','3478',1349683.50,0.00,'Sales from shift 253958 on 2022-01-17 07:09:26 ','2022-01-17 07:09:26','',''),('5','182',4757750,'','6.1','3477',0.00,1349683.50,'Sales from shift 253958 on 2022-01-17 07:09:26 ','2022-01-17 07:09:26','',''),('5','182',4767353,'','6.1','3477',50450.00,0.00,'Payment Id 394350 for invoice:253958, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767354,'','supplier','252',0.00,50450.00,'Payment Id 394350 for invoice:253958, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767355,'','2','3681',1299235.00,0.00,'Payment Id 394348 for invoice:253958, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767356,'','supplier','252',0.00,1299235.00,'Payment Id 394348 for invoice:253958, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767357,'','6.1','3477',13800.00,0.00,'Payment Id 394347 for invoice:253948, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767358,'','supplier','252',0.00,13800.00,'Payment Id 394347 for invoice:253948, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767359,'','2','3681',746480.00,0.00,'Payment Id 394342 for invoice:253948, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767360,'','supplier','252',0.00,746480.00,'Payment Id 394342 for invoice:253948, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767361,'','6.1','3477',13800.00,0.00,'Payment Id 394341 for invoice:253516, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767362,'','supplier','252',0.00,13800.00,'Payment Id 394341 for invoice:253516, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767363,'','2','3681',816475.00,0.00,'Payment Id 394340 for invoice:253516, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4767364,'','supplier','252',0.00,816475.00,'Payment Id 394340 for invoice:253516, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-01-17 16:37:16','',''),('5','182',4770987,'','20','3478',966147.60,0.00,'Sales from shift 254281 on 2022-01-18 07:07:22 ','2022-01-18 07:07:22','',''),('5','182',4770988,'','6.1','3477',0.00,966147.60,'Sales from shift 254281 on 2022-01-18 07:07:22 ','2022-01-18 07:07:22','',''),('5','182',4784366,'','6.1','3477',15450.00,0.00,'Payment Id 395261 for invoice:254281, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-18 18:28:58','',''),('5','182',4784367,'','supplier','252',0.00,15450.00,'Payment Id 395261 for invoice:254281, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-18 18:28:58','',''),('5','182',4784368,'','2','3681',950700.00,0.00,'Payment Id 395260 for invoice:254281, receipt: 06924 by SALBAS OIL & GAS LIMITED','2022-01-18 18:28:58','',''),('5','182',4784369,'','supplier','252',0.00,950700.00,'Payment Id 395260 for invoice:254281, receipt: 06924 by SALBAS OIL & GAS LIMITED','2022-01-18 18:28:58','',''),('5','182',4785279,'','20','3478',560488.50,0.00,'Sales from shift 254481 on 2022-01-19 06:04:20 ','2022-01-19 06:04:20','',''),('5','182',4785280,'','6.1','3477',0.00,560488.50,'Sales from shift 254481 on 2022-01-19 06:04:20 ','2022-01-19 06:04:20','',''),('5','182',4795005,'','6.1','3477',15450.00,0.00,'Payment Id 395730 for invoice:254481, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-19 15:02:45','',''),('5','182',4795006,'','supplier','252',0.00,15450.00,'Payment Id 395730 for invoice:254481, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-19 15:02:45','',''),('5','182',4795007,'','2','3681',544470.00,0.00,'Payment Id 395729 for invoice:254481, receipt: 52280 by SALBAS OIL & GAS LIMITED','2022-01-19 15:02:46','',''),('5','182',4795008,'','supplier','252',0.00,544470.00,'Payment Id 395729 for invoice:254481, receipt: 52280 by SALBAS OIL & GAS LIMITED','2022-01-19 15:02:46','',''),('5','182',4800695,'','20','3478',781331.10,0.00,'Sales from shift 254717 on 2022-01-20 06:34:28 ','2022-01-20 06:34:28','',''),('5','182',4800696,'','6.1','3477',0.00,781331.10,'Sales from shift 254717 on 2022-01-20 06:34:28 ','2022-01-20 06:34:28','',''),('5','182',4812653,'','6.1','3477',15650.00,0.00,'Payment Id 396353 for invoice:254717, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-20 16:50:01','',''),('5','182',4812654,'','supplier','252',0.00,15650.00,'Payment Id 396353 for invoice:254717, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-20 16:50:01','',''),('5','182',4812655,'','2','3681',766245.00,0.00,'Payment Id 396350 for invoice:254717, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-01-20 16:50:01','',''),('5','182',4812656,'','supplier','252',0.00,766245.00,'Payment Id 396350 for invoice:254717, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-01-20 16:50:01','',''),('5','182',4820458,'','20','3478',157344.00,0.00,'Sales from shift 254947 on 2022-01-21 11:16:06 ','2022-01-21 11:16:06','',''),('5','182',4820459,'','6.1','3477',0.00,157344.00,'Sales from shift 254947 on 2022-01-21 11:16:06 ','2022-01-21 11:16:06','',''),('5','182',4831320,'','6.1','3477',55650.00,0.00,'Payment Id 396772 for invoice:254947, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-21 22:36:06','',''),('5','182',4831321,'','supplier','252',0.00,55650.00,'Payment Id 396772 for invoice:254947, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-01-21 22:36:06','',''),('5','182',4831322,'','2','3681',101700.00,0.00,'Payment Id 396765 for invoice:254947, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-01-21 22:36:06','',''),('5','182',4831323,'','supplier','252',0.00,101700.00,'Payment Id 396765 for invoice:254947, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-01-21 22:36:06','',''),('5','182',4833323,'','20','3478',0.00,0.00,'Sales from shift 255284 on 2022-01-22 09:19:21 ','2022-01-22 09:19:21','',''),('5','182',4833324,'','6.1','3477',0.00,0.00,'Sales from shift 255284 on 2022-01-22 09:19:21 ','2022-01-22 09:19:21','',''),('5','182',4846992,'','20','3478',0.00,0.00,'Sales from shift 255531 on 2022-01-23 07:29:43 ','2022-01-23 07:29:43','',''),('5','182',4846993,'','6.1','3477',0.00,0.00,'Sales from shift 255531 on 2022-01-23 07:29:43 ','2022-01-23 07:29:43','',''),('5','182',4860515,'','20','3478',0.00,0.00,'Sales from shift 255740 on 2022-01-24 07:38:52 ','2022-01-24 07:38:52','',''),('5','182',4860516,'','6.1','3477',0.00,0.00,'Sales from shift 255740 on 2022-01-24 07:38:52 ','2022-01-24 07:38:52','',''),('5','182',4874840,'','20','3478',0.00,0.00,'Sales from shift 255981 on 2022-01-25 08:23:08 ','2022-01-25 08:23:08','',''),('5','182',4874841,'','6.1','3477',0.00,0.00,'Sales from shift 255981 on 2022-01-25 08:23:08 ','2022-01-25 08:23:08','',''),('5','182',4890465,'','20','3478',0.00,0.00,'Sales from shift 256362 on 2022-01-26 06:10:03 ','2022-01-26 06:10:03','',''),('5','182',4890466,'','6.1','3477',0.00,0.00,'Sales from shift 256362 on 2022-01-26 06:10:03 ','2022-01-26 06:10:03','',''),('5','182',4903975,'','20','3478',0.00,0.00,'Sales from shift 256511 on 2022-01-27 07:07:21 ','2022-01-27 07:07:21','',''),('5','182',4903976,'','6.1','3477',0.00,0.00,'Sales from shift 256511 on 2022-01-27 07:07:21 ','2022-01-27 07:07:21','',''),('5','182',4919824,'','20','3478',0.00,0.00,'Sales from shift 256764 on 2022-01-28 06:36:06 ','2022-01-28 06:36:06','',''),('5','182',4919825,'','6.1','3477',0.00,0.00,'Sales from shift 256764 on 2022-01-28 06:36:06 ','2022-01-28 06:36:06','',''),('5','182',4935404,'','20','3478',0.00,0.00,'Sales from shift 256959 on 2022-01-29 07:13:11 ','2022-01-29 07:13:11','',''),('5','182',4935405,'','6.1','3477',0.00,0.00,'Sales from shift 256959 on 2022-01-29 07:13:11 ','2022-01-29 07:13:11','',''),('5','182',4951135,'','20','3478',0.00,0.00,'Sales from shift 257270 on 2022-01-29 23:07:54 ','2022-01-29 23:07:54','',''),('5','182',4951136,'','6.1','3477',0.00,0.00,'Sales from shift 257270 on 2022-01-29 23:07:54 ','2022-01-29 23:07:54','',''),('5','182',4951137,'','20','3478',0.00,0.00,'Sales from shift 257489 on 2022-01-31 09:19:10 ','2022-01-31 09:19:10','',''),('5','182',4951138,'','6.1','3477',0.00,0.00,'Sales from shift 257489 on 2022-01-31 09:19:10 ','2022-01-31 09:19:10','',''),('5','182',4951139,'','20','3478',0.00,0.00,'Sales from shift 257490 on 2022-02-02 19:21:07 ','2022-02-02 19:21:07','',''),('5','182',4951140,'','6.1','3477',0.00,0.00,'Sales from shift 257490 on 2022-02-02 19:21:07 ','2022-02-02 19:21:07','',''),('5','182',4951141,'','20','3478',0.00,0.00,'Sales from shift 257491 on 2022-02-02 19:28:29 ','2022-02-02 19:28:29','',''),('5','182',4951142,'','6.1','3477',0.00,0.00,'Sales from shift 257491 on 2022-02-02 19:28:29 ','2022-02-02 19:28:29','',''),('5','182',4951143,'','20','3478',0.00,0.00,'Sales from shift 257492 on 2022-02-02 19:33:49 ','2022-02-02 19:33:49','',''),('5','182',4951144,'','6.1','3477',0.00,0.00,'Sales from shift 257492 on 2022-02-02 19:33:49 ','2022-02-02 19:33:49','',''),('5','182',4951145,'','24','3474',0.00,2640000.00,'Purchase Id 89521 for 16,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-08 07:20:29','',''),('5','182',4951146,'','supplier','252',2640000.00,0.00,'Purchase Id 89521 for 16,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-08 07:20:29','',''),('5','182',4951147,'','20','3478',0.00,0.00,'Sales from shift 257493 on 2022-02-08 07:21:04 ','2022-02-08 07:21:04','',''),('5','182',4951148,'','6.1','3477',0.00,0.00,'Sales from shift 257493 on 2022-02-08 07:21:04 ','2022-02-08 07:21:04','',''),('5','182',4951149,'','20','3478',326467.35,0.00,'Sales from shift 257494 on 2022-02-08 10:01:53 ','2022-02-08 10:01:53','',''),('5','182',4951150,'','6.1','3477',0.00,326467.35,'Sales from shift 257494 on 2022-02-08 10:01:53 ','2022-02-08 10:01:53','',''),('5','182',4951151,'','20','3478',753622.65,0.00,'Sales from shift 257495 on 2022-02-08 10:06:26 ','2022-02-08 10:06:26','',''),('5','182',4951152,'','6.1','3477',0.00,753622.65,'Sales from shift 257495 on 2022-02-08 10:06:26 ','2022-02-08 10:06:26','',''),('5','182',4951153,'','20','3478',670178.85,0.00,'Sales from shift 257496 on 2022-02-08 10:09:52 ','2022-02-08 10:09:52','',''),('5','182',4951154,'','6.1','3477',0.00,670178.85,'Sales from shift 257496 on 2022-02-08 10:09:52 ','2022-02-08 10:09:52','',''),('5','182',4951155,'','20','3478',670652.40,0.00,'Sales from shift 257497 on 2022-02-08 10:12:23 ','2022-02-08 10:12:23','',''),('5','182',4951156,'','6.1','3477',0.00,670652.40,'Sales from shift 257497 on 2022-02-08 10:12:23 ','2022-02-08 10:12:23','',''),('5','182',4951157,'','6.1','3477',242250.00,0.00,'Payment Id 396780 for invoice:257497, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951158,'','supplier','252',0.00,242250.00,'Payment Id 396780 for invoice:257497, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951159,'','2','3681',428270.00,0.00,'Payment Id 396779 for invoice:257497, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951160,'','supplier','252',0.00,428270.00,'Payment Id 396779 for invoice:257497, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951161,'','6.1','3477',16650.00,0.00,'Payment Id 396778 for invoice:257496, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951162,'','supplier','252',0.00,16650.00,'Payment Id 396778 for invoice:257496, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951163,'','2','3681',652930.00,0.00,'Payment Id 396777 for invoice:257496, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951164,'','supplier','252',0.00,652930.00,'Payment Id 396777 for invoice:257496, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951165,'','6.1','3477',27300.00,0.00,'Payment Id 396776 for invoice:257495, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951166,'','supplier','252',0.00,27300.00,'Payment Id 396776 for invoice:257495, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951167,'','2','3681',726325.00,0.00,'Payment Id 396775 for invoice:257495, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951168,'','supplier','252',0.00,726325.00,'Payment Id 396775 for invoice:257495, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951169,'','6.1','3477',15600.00,0.00,'Payment Id 396774 for invoice:257495, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951170,'','supplier','252',0.00,15600.00,'Payment Id 396774 for invoice:257495, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:00','',''),('5','182',4951171,'','2','3681',310870.00,0.00,'Payment Id 396773 for invoice:257495, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:01','',''),('5','182',4951172,'','supplier','252',0.00,310870.00,'Payment Id 396773 for invoice:257495, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-08 11:31:01','',''),('5','182',4951173,'','20','3478',221454.75,0.00,'Sales from shift 257498 on 2022-02-08 21:59:17 ','2022-02-08 21:59:17','',''),('5','182',4951174,'','6.1','3477',0.00,221454.75,'Sales from shift 257498 on 2022-02-08 21:59:17 ','2022-02-08 21:59:17','',''),('5','182',4951175,'','6.1','3477',17850.00,0.00,'Payment Id 396782 for invoice:257498, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-09 20:57:26','',''),('5','182',4951176,'','supplier','252',0.00,17850.00,'Payment Id 396782 for invoice:257498, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-09 20:57:26','',''),('5','182',4951177,'','2','3681',204340.00,0.00,'Payment Id 396781 for invoice:257498, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-02-09 20:57:26','',''),('5','182',4951178,'','supplier','252',0.00,204340.00,'Payment Id 396781 for invoice:257498, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-02-09 20:57:26','',''),('5','182',4951179,'','20','3478',0.00,0.00,'Sales from shift 257499 on 2022-02-09 20:57:44 ','2022-02-09 20:57:44','',''),('5','182',4951180,'','6.1','3477',0.00,0.00,'Sales from shift 257499 on 2022-02-09 20:57:44 ','2022-02-09 20:57:44','',''),('5','182',4951181,'','20','3478',0.00,0.00,'Sales from shift 257500 on 2022-02-10 21:44:53 ','2022-02-10 21:44:53','',''),('5','182',4951182,'','6.1','3477',0.00,0.00,'Sales from shift 257500 on 2022-02-10 21:44:53 ','2022-02-10 21:44:53','',''),('5','182',4951183,'','20','3478',179949.00,0.00,'Sales from shift 257501 on 2022-02-11 22:46:58 ','2022-02-11 22:46:58','',''),('5','182',4951184,'','6.1','3477',0.00,179949.00,'Sales from shift 257501 on 2022-02-11 22:46:58 ','2022-02-11 22:46:58','',''),('5','182',4951185,'','24','3474',0.00,3712500.00,'Purchase Id 89522 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-12 07:00:13','',''),('5','182',4951186,'','supplier','252',3712500.00,0.00,'Purchase Id 89522 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-12 07:00:13','',''),('5','182',4951187,'','20','3478',826879.35,0.00,'Sales from shift 257502 on 2022-02-13 08:48:51 ','2022-02-13 08:48:51','',''),('5','182',4951188,'','6.1','3477',0.00,826879.35,'Sales from shift 257502 on 2022-02-13 08:48:51 ','2022-02-13 08:48:51','',''),('5','182',4951189,'','20','3478',841396.05,0.00,'Sales from shift 257503 on 2022-02-14 06:10:49 ','2022-02-14 06:10:49','',''),('5','182',4951190,'','6.1','3477',0.00,841396.05,'Sales from shift 257503 on 2022-02-14 06:10:49 ','2022-02-14 06:10:49','',''),('5','182',4951191,'','6.1','3477',18250.00,0.00,'Payment Id 396788 for invoice:257503, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951192,'','supplier','252',0.00,18250.00,'Payment Id 396788 for invoice:257503, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951193,'','2','3681',823145.00,0.00,'Payment Id 396787 for invoice:257503, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951194,'','supplier','252',0.00,823145.00,'Payment Id 396787 for invoice:257503, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951195,'','6.1','3477',53600.00,0.00,'Payment Id 396786 for invoice:257502, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951196,'','supplier','252',0.00,53600.00,'Payment Id 396786 for invoice:257502, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951197,'','2','3681',773280.00,0.00,'Payment Id 396785 for invoice:257502, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951198,'','supplier','252',0.00,773280.00,'Payment Id 396785 for invoice:257502, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951199,'','6.1','3477',16600.00,0.00,'Payment Id 396784 for invoice:257501, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951200,'','supplier','252',0.00,16600.00,'Payment Id 396784 for invoice:257501, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951201,'','2','3681',163350.00,0.00,'Payment Id 396783 for invoice:257501, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951202,'','supplier','252',0.00,163350.00,'Payment Id 396783 for invoice:257501, receipt: 59180 by SALBAS OIL & GAS LIMITED','2022-02-14 16:58:43','',''),('5','182',4951203,'','20','3478',868281.15,0.00,'Sales from shift 257504 on 2022-02-14 23:50:14 ','2022-02-14 23:50:14','',''),('5','182',4951204,'','6.1','3477',0.00,868281.15,'Sales from shift 257504 on 2022-02-14 23:50:14 ','2022-02-14 23:50:14','',''),('5','182',4951205,'','6.1','3477',59250.00,0.00,'Payment Id 396790 for invoice:257504, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-16 06:13:39','',''),('5','182',4951206,'','supplier','252',0.00,59250.00,'Payment Id 396790 for invoice:257504, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-16 06:13:39','',''),('5','182',4951207,'','2','3681',809035.00,0.00,'Payment Id 396789 for invoice:257504, receipt: 59182 by SALBAS OIL & GAS LIMITED','2022-02-16 06:13:39','',''),('5','182',4951208,'','supplier','252',0.00,809035.00,'Payment Id 396789 for invoice:257504, receipt: 59182 by SALBAS OIL & GAS LIMITED','2022-02-16 06:13:39','',''),('5','182',4951209,'','20','3478',838645.50,0.00,'Sales from shift 257505 on 2022-02-16 07:59:57 ','2022-02-16 07:59:57','',''),('5','182',4951210,'','6.1','3477',0.00,838645.50,'Sales from shift 257505 on 2022-02-16 07:59:57 ','2022-02-16 07:59:57','',''),('5','182',4951211,'','6.1','3477',18250.00,0.00,'Payment Id 396792 for invoice:257505, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-16 14:20:54','',''),('5','182',4951212,'','supplier','252',0.00,18250.00,'Payment Id 396792 for invoice:257505, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-16 14:20:54','',''),('5','182',4951213,'','2','3681',820395.00,0.00,'Payment Id 396791 for invoice:257505, receipt: 59187 by SALBAS OIL & GAS LIMITED','2022-02-16 14:20:54','',''),('5','182',4951214,'','supplier','252',0.00,820395.00,'Payment Id 396791 for invoice:257505, receipt: 59187 by SALBAS OIL & GAS LIMITED','2022-02-16 14:20:54','',''),('5','182',4951215,'','2','3510',7275901.00,0.00,'Payment Id 396793 for invoice:257506, receipt: 2780 by SALBAS OIL & GAS LIMITED','2022-02-16 14:23:41','',''),('5','182',4951216,'','supplier','252',0.00,7275901.00,'Payment Id 396793 for invoice:257506, receipt: 2780 by SALBAS OIL & GAS LIMITED','2022-02-16 14:23:41','',''),('5','182',4951217,'','20','3478',107992.50,0.00,'Sales from shift 257506 on 2022-02-17 09:27:14 ','2022-02-17 09:27:14','',''),('5','182',4951218,'','6.1','3477',0.00,107992.50,'Sales from shift 257506 on 2022-02-17 09:27:14 ','2022-02-17 09:27:14','',''),('5','182',4951219,'','6.1','3477',18250.00,0.00,'Payment Id 396795 for invoice:257506, receipt: 67984 by SALBAS OIL & GAS LIMITED','2022-02-17 21:07:03','',''),('5','182',4951220,'','supplier','252',0.00,18250.00,'Payment Id 396795 for invoice:257506, receipt: 67984 by SALBAS OIL & GAS LIMITED','2022-02-17 21:07:03','',''),('5','182',4951221,'','2','3681',89745.00,0.00,'Payment Id 396794 for invoice:257506, receipt: 67984 by SALBAS OIL & GAS LIMITED','2022-02-17 21:07:03','',''),('5','182',4951222,'','supplier','252',0.00,89745.00,'Payment Id 396794 for invoice:257506, receipt: 67984 by SALBAS OIL & GAS LIMITED','2022-02-17 21:07:03','',''),('5','182',4951223,'','20','3478',0.00,0.00,'Sales from shift 257507 on 2022-02-18 07:59:42 ','2022-02-18 07:59:42','',''),('5','182',4951224,'','6.1','3477',0.00,0.00,'Sales from shift 257507 on 2022-02-18 07:59:42 ','2022-02-18 07:59:42','',''),('5','182',4951225,'','20','3478',0.00,0.00,'Sales from shift 257508 on 2022-02-19 07:20:24 ','2022-02-19 07:20:24','',''),('5','182',4951226,'','6.1','3477',0.00,0.00,'Sales from shift 257508 on 2022-02-19 07:20:24 ','2022-02-19 07:20:24','',''),('5','182',4951227,'','20','3478',0.00,0.00,'Sales from shift 257509 on 2022-02-19 21:54:54 ','2022-02-19 21:54:54','',''),('5','182',4951228,'','6.1','3477',0.00,0.00,'Sales from shift 257509 on 2022-02-19 21:54:54 ','2022-02-19 21:54:54','',''),('5','182',4951229,'','20','3478',0.00,0.00,'Sales from shift 257510 on 2022-02-21 07:24:14 ','2022-02-21 07:24:14','',''),('5','182',4951230,'','6.1','3477',0.00,0.00,'Sales from shift 257510 on 2022-02-21 07:24:14 ','2022-02-21 07:24:14','',''),('5','182',4951231,'','20','3478',148417.50,0.00,'Sales from shift 257511 on 2022-02-22 06:56:12 ','2022-02-22 06:56:12','',''),('5','182',4951232,'','6.1','3477',0.00,148417.50,'Sales from shift 257511 on 2022-02-22 06:56:12 ','2022-02-22 06:56:12','',''),('5','182',4951233,'','24','3474',0.00,4917000.00,'Purchase Id 89523 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-22 07:48:12','',''),('5','182',4951234,'','supplier','252',4917000.00,0.00,'Purchase Id 89523 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-22 07:48:12','',''),('5','182',4951235,'','6.1','3477',18250.00,0.00,'Payment Id 396797 for invoice:257511, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-22 20:12:28','',''),('5','182',4951236,'','supplier','252',0.00,18250.00,'Payment Id 396797 for invoice:257511, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-22 20:12:28','',''),('5','182',4951237,'','2','3681',130170.00,0.00,'Payment Id 396796 for invoice:257511, receipt: 59188 by SALBAS OIL & GAS LIMITED','2022-02-22 20:12:28','',''),('5','182',4951238,'','supplier','252',0.00,130170.00,'Payment Id 396796 for invoice:257511, receipt: 59188 by SALBAS OIL & GAS LIMITED','2022-02-22 20:12:28','',''),('5','182',4951239,'','20','3478',1424435.10,0.00,'Sales from shift 257512 on 2022-02-23 07:14:01 ','2022-02-23 07:14:01','',''),('5','182',4951240,'','6.1','3477',0.00,1424435.10,'Sales from shift 257512 on 2022-02-23 07:14:01 ','2022-02-23 07:14:01','',''),('5','182',4951241,'','6.1','3477',18250.00,0.00,'Payment Id 396799 for invoice:257512, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-23 12:34:57','',''),('5','182',4951242,'','supplier','252',0.00,18250.00,'Payment Id 396799 for invoice:257512, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-23 12:34:57','',''),('5','182',4951243,'','2','3681',1406185.00,0.00,'Payment Id 396798 for invoice:257512, receipt: 59191 by SALBAS OIL & GAS LIMITED','2022-02-23 12:34:57','',''),('5','182',4951244,'','supplier','252',0.00,1406185.00,'Payment Id 396798 for invoice:257512, receipt: 59191 by SALBAS OIL & GAS LIMITED','2022-02-23 12:34:57','',''),('5','182',4951245,'','24','3474',0.00,2145000.00,'Purchase Id 89524 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-23 12:35:11','',''),('5','182',4951246,'','supplier','252',2145000.00,0.00,'Purchase Id 89524 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-23 12:35:11','',''),('5','182',4951247,'','20','3478',1412470.95,0.00,'Sales from shift 257513 on 2022-02-24 07:59:49 ','2022-02-24 07:59:49','',''),('5','182',4951248,'','6.1','3477',0.00,1412470.95,'Sales from shift 257513 on 2022-02-24 07:59:49 ','2022-02-24 07:59:49','',''),('5','182',4951249,'','6.1','3477',38250.00,0.00,'Payment Id 396801 for invoice:257513, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-24 15:47:51','',''),('5','182',4951250,'','supplier','252',0.00,38250.00,'Payment Id 396801 for invoice:257513, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-24 15:47:51','',''),('5','182',4951251,'','2','3681',1374220.00,0.00,'Payment Id 396800 for invoice:257513, receipt: 59193 by SALBAS OIL & GAS LIMITED','2022-02-24 15:47:51','',''),('5','182',4951252,'','supplier','252',0.00,1374220.00,'Payment Id 396800 for invoice:257513, receipt: 59193 by SALBAS OIL & GAS LIMITED','2022-02-24 15:47:51','',''),('5','182',4951253,'','20','3478',1500805.35,0.00,'Sales from shift 257514 on 2022-02-25 06:49:07 ','2022-02-25 06:49:07','',''),('5','182',4951254,'','6.1','3477',0.00,1500805.35,'Sales from shift 257514 on 2022-02-25 06:49:07 ','2022-02-25 06:49:07','',''),('5','182',4951255,'','24','3474',0.00,2227500.00,'Purchase Id 89525 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-25 15:01:59','',''),('5','182',4951256,'','supplier','252',2227500.00,0.00,'Purchase Id 89525 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-25 15:01:59','',''),('5','182',4951257,'','20','3478',1052785.80,0.00,'Sales from shift 257515 on 2022-02-26 07:19:06 ','2022-02-26 07:19:06','',''),('5','182',4951258,'','6.1','3477',0.00,1052785.80,'Sales from shift 257515 on 2022-02-26 07:19:06 ','2022-02-26 07:19:06','',''),('5','182',4951259,'','6.1','3477',31250.00,0.00,'Payment Id 396803 for invoice:257514, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-26 07:19:25','',''),('5','182',4951260,'','supplier','252',0.00,31250.00,'Payment Id 396803 for invoice:257514, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-26 07:19:25','',''),('5','182',4951261,'','2','3681',1469950.00,0.00,'Payment Id 396802 for invoice:257514, receipt: 59194 by SALBAS OIL & GAS LIMITED','2022-02-26 07:19:25','',''),('5','182',4951262,'','supplier','252',0.00,1469950.00,'Payment Id 396802 for invoice:257514, receipt: 59194 by SALBAS OIL & GAS LIMITED','2022-02-26 07:19:25','',''),('5','182',4951263,'','24','3474',0.00,6600000.00,'Purchase Id 89526 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-26 21:50:51','',''),('5','182',4951264,'','supplier','252',6600000.00,0.00,'Purchase Id 89526 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-02-26 21:50:51','',''),('5','182',4951265,'','20','3478',3044505.75,0.00,'Sales from shift 257516 on 2022-02-27 09:17:09 ','2022-02-27 09:17:09','',''),('5','182',4951266,'','6.1','3477',0.00,3044505.75,'Sales from shift 257516 on 2022-02-27 09:17:09 ','2022-02-27 09:17:09','',''),('5','182',4951267,'','20','3478',1660642.50,0.00,'Sales from shift 257517 on 2022-02-27 23:59:59 ','2022-02-27 23:59:59','',''),('5','182',4951268,'','6.1','3477',0.00,1660642.50,'Sales from shift 257517 on 2022-02-27 23:59:59 ','2022-02-27 23:59:59','',''),('5','182',4951269,'','6.1','3477',18250.00,0.00,'Payment Id 396809 for invoice:257517, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951270,'','supplier','252',0.00,18250.00,'Payment Id 396809 for invoice:257517, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951271,'','2','3681',1642390.00,0.00,'Payment Id 396808 for invoice:257517, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951272,'','supplier','252',0.00,1642390.00,'Payment Id 396808 for invoice:257517, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951273,'','6.1','3477',16600.00,0.00,'Payment Id 396807 for invoice:257516, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951274,'','supplier','252',0.00,16600.00,'Payment Id 396807 for invoice:257516, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951275,'','2','3681',3027500.00,0.00,'Payment Id 396806 for invoice:257516, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951276,'','supplier','252',0.00,3027500.00,'Payment Id 396806 for invoice:257516, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951277,'','6.1','3477',16600.00,0.00,'Payment Id 396805 for invoice:257515, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951278,'','supplier','252',0.00,16600.00,'Payment Id 396805 for invoice:257515, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951279,'','2','3681',1036185.00,0.00,'Payment Id 396804 for invoice:257515, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951280,'','supplier','252',0.00,1036185.00,'Payment Id 396804 for invoice:257515, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-02-28 21:38:26','',''),('5','182',4951281,'','20','3478',1297482.45,0.00,'Sales from shift 257518 on 2022-02-28 21:38:47 ','2022-02-28 21:38:47','',''),('5','182',4951282,'','6.1','3477',0.00,1297482.45,'Sales from shift 257518 on 2022-02-28 21:38:47 ','2022-02-28 21:38:47','',''),('5','182',4951283,'','20','3478',2560207.65,0.00,'Sales from shift 257519 on 2022-03-02 15:14:04 ','2022-03-02 15:14:04','',''),('5','182',4951284,'','6.1','3477',0.00,2560207.65,'Sales from shift 257519 on 2022-03-02 15:14:04 ','2022-03-02 15:14:04','',''),('5','182',4951285,'','6.1','3477',252260.00,0.00,'Payment Id 396815 for invoice:257519, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951286,'','supplier','252',0.00,252260.00,'Payment Id 396815 for invoice:257519, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951287,'','2','3681',2307950.00,0.00,'Payment Id 396814 for invoice:257519, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951288,'','supplier','252',0.00,2307950.00,'Payment Id 396814 for invoice:257519, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951289,'','6.1','3477',18250.00,0.00,'Payment Id 396813 for invoice:257518, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951290,'','supplier','252',0.00,18250.00,'Payment Id 396813 for invoice:257518, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951291,'','2','3682',1279230.00,0.00,'Payment Id 396812 for invoice:257518, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951292,'','supplier','252',0.00,1279230.00,'Payment Id 396812 for invoice:257518, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951293,'','6.1','3477',18250.00,0.00,'Payment Id 396811 for invoice:257518, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951294,'','supplier','252',0.00,18250.00,'Payment Id 396811 for invoice:257518, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951295,'','2','3682',1279230.00,0.00,'Payment Id 396810 for invoice:257518, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951296,'','supplier','252',0.00,1279230.00,'Payment Id 396810 for invoice:257518, receipt: 49356 by SALBAS OIL & GAS LIMITED','2022-03-02 22:24:27','',''),('5','182',4951297,'','20','3478',965646.00,0.00,'Sales from shift 257520 on 2022-03-02 22:25:01 ','2022-03-02 22:25:01','',''),('5','182',4951298,'','6.1','3477',0.00,965646.00,'Sales from shift 257520 on 2022-03-02 22:25:01 ','2022-03-02 22:25:01','',''),('5','182',4951299,'','20','3478',802690.35,0.00,'Sales from shift 257521 on 2022-03-04 08:21:59 ','2022-03-04 08:21:59','',''),('5','182',4951300,'','6.1','3477',0.00,802690.35,'Sales from shift 257521 on 2022-03-04 08:21:59 ','2022-03-04 08:21:59','',''),('5','182',4951301,'','6.1','3477',29950.00,0.00,'Payment Id 396817 for invoice:257520, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-04 08:22:22','',''),('5','182',4951302,'','supplier','252',0.00,29950.00,'Payment Id 396817 for invoice:257520, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-04 08:22:22','',''),('5','182',4951303,'','2','3682',935695.00,0.00,'Payment Id 396816 for invoice:257520, receipt: 90766 by SALBAS OIL & GAS LIMITED','2022-03-04 08:22:22','',''),('5','182',4951304,'','supplier','252',0.00,935695.00,'Payment Id 396816 for invoice:257520, receipt: 90766 by SALBAS OIL & GAS LIMITED','2022-03-04 08:22:22','',''),('5','182',4951305,'','20','3478',183488.25,0.00,'Sales from shift 257522 on 2022-03-05 06:51:43 ','2022-03-05 06:51:43','',''),('5','182',4951306,'','6.1','3477',0.00,183488.25,'Sales from shift 257522 on 2022-03-05 06:51:43 ','2022-03-05 06:51:43','',''),('5','182',4951307,'','6.1','3477',358650.00,0.00,'Payment Id 396819 for invoice:257521, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-05 06:52:05','',''),('5','182',4951308,'','supplier','252',0.00,358650.00,'Payment Id 396819 for invoice:257521, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-05 06:52:05','',''),('5','182',4951309,'','2','3682',440040.00,0.00,'Payment Id 396818 for invoice:257521, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-05 06:52:05','',''),('5','182',4951310,'','supplier','252',0.00,440040.00,'Payment Id 396818 for invoice:257521, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-05 06:52:05','',''),('5','182',4951311,'','20','3478',0.00,0.00,'Sales from shift 257523 on 2022-03-06 06:03:59 ','2022-03-06 06:03:59','',''),('5','182',4951312,'','6.1','3477',0.00,0.00,'Sales from shift 257523 on 2022-03-06 06:03:59 ','2022-03-06 06:03:59','',''),('5','182',4951313,'','20','3478',0.00,0.00,'Sales from shift 257524 on 2022-03-07 20:10:39 ','2022-03-07 20:10:39','',''),('5','182',4951314,'','6.1','3477',0.00,0.00,'Sales from shift 257524 on 2022-03-07 20:10:39 ','2022-03-07 20:10:39','',''),('5','182',4951315,'','6.1','3477',17600.00,0.00,'Payment Id 396821 for invoice:257522, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-07 20:11:00','',''),('5','182',4951316,'','supplier','252',0.00,17600.00,'Payment Id 396821 for invoice:257522, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-07 20:11:00','',''),('5','182',4951317,'','2','3682',165840.00,0.00,'Payment Id 396820 for invoice:25752, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-03-07 20:11:00','',''),('5','182',4951318,'','supplier','252',0.00,165840.00,'Payment Id 396820 for invoice:25752, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-03-07 20:11:00','',''),('5','182',4951319,'','20','3478',0.00,0.00,'Sales from shift 257525 on 2022-03-08 07:57:08 ','2022-03-08 07:57:08','',''),('5','182',4951320,'','6.1','3477',0.00,0.00,'Sales from shift 257525 on 2022-03-08 07:57:08 ','2022-03-08 07:57:08','',''),('5','182',4951321,'','20','3478',0.00,0.00,'Sales from shift 257526 on 2022-03-09 07:52:30 ','2022-03-09 07:52:30','',''),('5','182',4951322,'','6.1','3477',0.00,0.00,'Sales from shift 257526 on 2022-03-09 07:52:30 ','2022-03-09 07:52:30','',''),('5','182',4951323,'','20','3478',0.00,0.00,'Sales from shift 257527 on 2022-03-10 07:41:35 ','2022-03-10 07:41:35','',''),('5','182',4951324,'','6.1','3477',0.00,0.00,'Sales from shift 257527 on 2022-03-10 07:41:35 ','2022-03-10 07:41:35','',''),('5','182',4951325,'','20','3478',0.00,0.00,'Sales from shift 257528 on 2022-03-11 08:56:32 ','2022-03-11 08:56:32','',''),('5','182',4951326,'','6.1','3477',0.00,0.00,'Sales from shift 257528 on 2022-03-11 08:56:32 ','2022-03-11 08:56:32','',''),('5','182',4951327,'','2','3682',4050.00,0.00,'Payment Id 396822 for invoice:257521, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-11 08:56:58','',''),('5','182',4951328,'','supplier','252',0.00,4050.00,'Payment Id 396822 for invoice:257521, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-03-11 08:56:58','',''),('5','182',4951329,'','20','3478',0.00,0.00,'Sales from shift 257529 on 2022-03-12 07:41:27 ','2022-03-12 07:41:27','',''),('5','182',4951330,'','6.1','3477',0.00,0.00,'Sales from shift 257529 on 2022-03-12 07:41:27 ','2022-03-12 07:41:27','',''),('5','182',4951331,'','20','3478',0.00,0.00,'Sales from shift 257530 on 2022-03-13 12:16:37 ','2022-03-13 12:16:37','',''),('5','182',4951332,'','6.1','3477',0.00,0.00,'Sales from shift 257530 on 2022-03-13 12:16:37 ','2022-03-13 12:16:37','',''),('5','182',4951333,'','20','3478',0.00,0.00,'Sales from shift 257531 on 2022-03-14 06:06:53 ','2022-03-14 06:06:53','',''),('5','182',4951334,'','6.1','3477',0.00,0.00,'Sales from shift 257531 on 2022-03-14 06:06:53 ','2022-03-14 06:06:53','',''),('5','182',4951335,'','20','3478',0.00,0.00,'Sales from shift 257532 on 2022-03-15 06:01:38 ','2022-03-15 06:01:38','',''),('5','182',4951336,'','6.1','3477',0.00,0.00,'Sales from shift 257532 on 2022-03-15 06:01:38 ','2022-03-15 06:01:38','',''),('5','182',4951337,'','20','3478',0.00,0.00,'Sales from shift 257533 on 2022-03-16 08:14:50 ','2022-03-16 08:14:50','',''),('5','182',4951338,'','6.1','3477',0.00,0.00,'Sales from shift 257533 on 2022-03-16 08:14:50 ','2022-03-16 08:14:50','',''),('5','182',4951339,'','20','3478',0.00,0.00,'Sales from shift 257534 on 2022-03-17 08:13:06 ','2022-03-17 08:13:06','',''),('5','182',4951340,'','6.1','3477',0.00,0.00,'Sales from shift 257534 on 2022-03-17 08:13:06 ','2022-03-17 08:13:06','',''),('5','182',4951341,'','20','3478',0.00,0.00,'Sales from shift 257535 on 2022-03-18 07:39:51 ','2022-03-18 07:39:51','',''),('5','182',4951342,'','6.1','3477',0.00,0.00,'Sales from shift 257535 on 2022-03-18 07:39:51 ','2022-03-18 07:39:51','',''),('5','182',4951343,'','20','3478',123750.00,0.00,'Sales from shift 257536 on 2022-03-19 07:08:54 ','2022-03-19 07:08:54','',''),('5','182',4951344,'','6.1','3477',0.00,123750.00,'Sales from shift 257536 on 2022-03-19 07:08:54 ','2022-03-19 07:08:54','',''),('5','182',4951345,'','24','3474',0.00,2227500.00,'Purchase Id 89527 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-03-19 15:09:20','',''),('5','182',4951346,'','supplier','252',2227500.00,0.00,'Purchase Id 89527 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-03-19 15:09:20','',''),('5','182',4951347,'','20','3478',679852.80,0.00,'Sales from shift 257537 on 2022-03-20 08:39:44 ','2022-03-20 08:39:44','',''),('5','182',4951348,'','6.1','3477',0.00,679852.80,'Sales from shift 257537 on 2022-03-20 08:39:44 ','2022-03-20 08:39:44','',''),('5','182',4951349,'','20','3478',505923.00,0.00,'Sales from shift 257538 on 2022-03-21 07:08:14 ','2022-03-21 07:08:14','',''),('5','182',4951350,'','6.1','3477',0.00,505923.00,'Sales from shift 257538 on 2022-03-21 07:08:14 ','2022-03-21 07:08:14','',''),('5','182',4951351,'','6.1','3477',27250.00,0.00,'Payment Id 396828 for invoice:257538, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951352,'','supplier','252',0.00,27250.00,'Payment Id 396828 for invoice:257538, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951353,'','2','3682',478675.00,0.00,'Payment Id 396827 for invoice:257537, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951354,'','supplier','252',0.00,478675.00,'Payment Id 396827 for invoice:257537, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951355,'','6.1','3477',25600.00,0.00,'Payment Id 396826 for invoice:257537, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951356,'','supplier','252',0.00,25600.00,'Payment Id 396826 for invoice:257537, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951357,'','2','3682',654250.00,0.00,'Payment Id 396825 for invoice:257537, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951358,'','supplier','252',0.00,654250.00,'Payment Id 396825 for invoice:257537, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951359,'','6.1','3477',25600.00,0.00,'Payment Id 396824 for invoice:257536, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951360,'','supplier','252',0.00,25600.00,'Payment Id 396824 for invoice:257536, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951361,'','2','3682',98150.00,0.00,'Payment Id 396823 for invoice:257536, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951362,'','supplier','252',0.00,98150.00,'Payment Id 396823 for invoice:257536, receipt: 94258 by SALBAS OIL & GAS LIMITED','2022-03-21 11:34:19','',''),('5','182',4951363,'','20','3478',676830.00,0.00,'Sales from shift 257539 on 2022-03-22 07:33:18 ','2022-03-22 07:33:18','',''),('5','182',4951364,'','6.1','3477',0.00,676830.00,'Sales from shift 257539 on 2022-03-22 07:33:18 ','2022-03-22 07:33:18','',''),('5','182',4951365,'','20','3478',247085.85,0.00,'Sales from shift 257540 on 2022-03-23 07:55:42 ','2022-03-23 07:55:42','',''),('5','182',4951366,'','6.1','3477',0.00,247085.85,'Sales from shift 257540 on 2022-03-23 07:55:42 ','2022-03-23 07:55:42','',''),('5','182',4951367,'','6.1','3477',37250.00,0.00,'Payment Id 396830 for invoice:257539, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-23 07:55:59','',''),('5','182',4951368,'','supplier','252',0.00,37250.00,'Payment Id 396830 for invoice:257539, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-23 07:55:59','',''),('5','182',4951369,'','2','3682',639580.00,0.00,'Payment Id 396829 for invoice:257539, receipt: 1296106 by SALBAS OIL & GAS LIMITED','2022-03-23 07:55:59','',''),('5','182',4951370,'','supplier','252',0.00,639580.00,'Payment Id 396829 for invoice:257539, receipt: 1296106 by SALBAS OIL & GAS LIMITED','2022-03-23 07:55:59','',''),('5','182',4951371,'','6.1','3477',27250.00,0.00,'Payment Id 396832 for invoice:257540, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-23 16:46:03','',''),('5','182',4951372,'','supplier','252',0.00,27250.00,'Payment Id 396832 for invoice:257540, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-23 16:46:03','',''),('5','182',4951373,'','2','3682',219835.00,0.00,'Payment Id 396831 for invoice:257540, receipt: 6582464 by SALBAS OIL & GAS LIMITED','2022-03-23 16:46:03','',''),('5','182',4951374,'','supplier','252',0.00,219835.00,'Payment Id 396831 for invoice:257540, receipt: 6582464 by SALBAS OIL & GAS LIMITED','2022-03-23 16:46:03','',''),('5','182',4951375,'','20','3478',0.00,0.00,'Sales from shift 257541 on 2022-03-24 08:00:39 ','2022-03-24 08:00:39','',''),('5','182',4951376,'','6.1','3477',0.00,0.00,'Sales from shift 257541 on 2022-03-24 08:00:39 ','2022-03-24 08:00:39','',''),('5','182',4951377,'','24','3474',0.00,2805000.00,'Purchase Id 89528 for 17,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-03-24 21:16:33','',''),('5','182',4951378,'','supplier','252',2805000.00,0.00,'Purchase Id 89528 for 17,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-03-24 21:16:33','',''),('5','182',4951379,'','20','3478',116310.15,0.00,'Sales from shift 257542 on 2022-03-25 06:46:51 ','2022-03-25 06:46:51','',''),('5','182',4951380,'','6.1','3477',0.00,116310.15,'Sales from shift 257542 on 2022-03-25 06:46:51 ','2022-03-25 06:46:51','',''),('5','182',4951381,'','20','3478',906354.90,0.00,'Sales from shift 257543 on 2022-03-26 04:56:35 ','2022-03-26 04:56:35','',''),('5','182',4951382,'','6.1','3477',0.00,906354.90,'Sales from shift 257543 on 2022-03-26 04:56:35 ','2022-03-26 04:56:35','',''),('5','182',4951383,'','6.1','3477',27250.00,0.00,'Payment Id 396834 for invoice:257542, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-26 04:56:52','',''),('5','182',4951384,'','supplier','252',0.00,27250.00,'Payment Id 396834 for invoice:257542, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-26 04:56:52','',''),('5','182',4951385,'','2','3682',89060.00,0.00,'Payment Id 396833 for invoice:257542, receipt: 6587079 by SALBAS OIL & GAS LIMITED','2022-03-26 04:56:52','',''),('5','182',4951386,'','supplier','252',0.00,89060.00,'Payment Id 396833 for invoice:257542, receipt: 6587079 by SALBAS OIL & GAS LIMITED','2022-03-26 04:56:52','',''),('5','182',4951387,'','20','3478',1202543.10,0.00,'Sales from shift 257544 on 2022-03-27 07:57:42 ','2022-03-27 07:57:42','',''),('5','182',4951388,'','6.1','3477',0.00,1202543.10,'Sales from shift 257544 on 2022-03-27 07:57:42 ','2022-03-27 07:57:42','',''),('5','182',4951389,'','20','3478',634677.45,0.00,'Sales from shift 257545 on 2022-03-28 08:27:29 ','2022-03-28 08:27:29','',''),('5','182',4951390,'','6.1','3477',0.00,634677.45,'Sales from shift 257545 on 2022-03-28 08:27:29 ','2022-03-28 08:27:29','',''),('5','182',4951391,'','20','3478',0.00,0.00,'Sales from shift 257546 on 2022-03-29 07:57:07 ','2022-03-29 07:57:07','',''),('5','182',4951392,'','6.1','3477',0.00,0.00,'Sales from shift 257546 on 2022-03-29 07:57:07 ','2022-03-29 07:57:07','',''),('5','182',4951393,'','6.1','3477',27250.00,0.00,'Payment Id 396841 for invoice:257545, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951394,'','supplier','252',0.00,27250.00,'Payment Id 396841 for invoice:257545, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951395,'','2','3682',607430.00,0.00,'Payment Id 396840 for invoice:257545, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951396,'','supplier','252',0.00,607430.00,'Payment Id 396840 for invoice:257545, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951397,'','6.1','3477',25600.00,0.00,'Payment Id 396839 for invoice:257543, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951398,'','supplier','252',0.00,25600.00,'Payment Id 396839 for invoice:257543, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951399,'','2','3682',1176945.00,0.00,'Payment Id 396838 for invoice:257543, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951400,'','supplier','252',0.00,1176945.00,'Payment Id 396838 for invoice:257543, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951401,'','6.1','3477',39000.00,0.00,'Payment Id 396837 for invoice:253262, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951402,'','supplier','252',0.00,39000.00,'Payment Id 396837 for invoice:253262, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951403,'','2','3682',867355.00,0.00,'Payment Id 396836 for invoice:257542, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951404,'','supplier','252',0.00,867355.00,'Payment Id 396836 for invoice:257542, receipt: 6588529 by SALBAS OIL & GAS LIMITED','2022-03-29 07:58:11','',''),('5','182',4951405,'','20','3478',0.00,0.00,'Sales from shift 257547 on 2022-03-30 06:37:44 ','2022-03-30 06:37:44','',''),('5','182',4951406,'','6.1','3477',0.00,0.00,'Sales from shift 257547 on 2022-03-30 06:37:44 ','2022-03-30 06:37:44','',''),('5','182',4951407,'','20','3478',0.00,0.00,'Sales from shift 257548 on 2022-03-31 10:58:35 ','2022-03-31 10:58:35','',''),('5','182',4951408,'','6.1','3477',0.00,0.00,'Sales from shift 257548 on 2022-03-31 10:58:35 ','2022-03-31 10:58:35','',''),('5','182',4951409,'','20','3478',0.00,0.00,'Sales from shift 257549 on 2022-04-01 10:05:44 ','2022-04-01 10:05:44','',''),('5','182',4951410,'','6.1','3477',0.00,0.00,'Sales from shift 257549 on 2022-04-01 10:05:44 ','2022-04-01 10:05:44','',''),('5','182',4951411,'','20','3478',0.00,0.00,'Sales from shift 257550 on 2022-04-02 08:37:27 ','2022-04-02 08:37:27','',''),('5','182',4951412,'','6.1','3477',0.00,0.00,'Sales from shift 257550 on 2022-04-02 08:37:27 ','2022-04-02 08:37:27','',''),('5','182',4951413,'','20','3478',0.00,0.00,'Sales from shift 257551 on 2022-04-03 10:38:26 ','2022-04-03 10:38:26','',''),('5','182',4951414,'','6.1','3477',0.00,0.00,'Sales from shift 257551 on 2022-04-03 10:38:26 ','2022-04-03 10:38:26','',''),('5','182',4951415,'','20','3478',0.00,0.00,'Sales from shift 257552 on 2022-04-04 07:46:05 ','2022-04-04 07:46:05','',''),('5','182',4951416,'','6.1','3477',0.00,0.00,'Sales from shift 257552 on 2022-04-04 07:46:05 ','2022-04-04 07:46:05','',''),('5','182',4951417,'','6.1','3477',17148.30,0.00,'Payment Id 345033 for invoice:231743, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951418,'','supplier','252',0.00,17148.30,'Payment Id 345033 for invoice:231743, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951419,'','2','3681',85920.00,0.00,'Payment Id 345031 for invoice:231744, receipt: 02617 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951420,'','supplier','252',0.00,85920.00,'Payment Id 345031 for invoice:231744, receipt: 02617 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951421,'','6.1','3477',13630.00,0.00,'Payment Id 345030 for invoice:231741, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951422,'','supplier','252',0.00,13630.00,'Payment Id 345030 for invoice:231741, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951423,'','2','3681',47035.00,0.00,'Payment Id 345025 for invoice:231741, receipt: 02642 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951424,'','supplier','252',0.00,47035.00,'Payment Id 345025 for invoice:231741, receipt: 02642 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951425,'','6.1','3477',13630.00,0.00,'Payment Id 345022 for invoice:231739, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951426,'','supplier','252',0.00,13630.00,'Payment Id 345022 for invoice:231739, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951427,'','2','3681',58105.00,0.00,'Payment Id 345020 for invoice:231739, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951428,'','supplier','252',0.00,58105.00,'Payment Id 345020 for invoice:231739, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951429,'','6.1','3477',23700.00,0.00,'Payment Id 345011 for invoice:231734, receipt: 00 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951430,'','supplier','252',0.00,23700.00,'Payment Id 345011 for invoice:231734, receipt: 00 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951431,'','2','3681',152475.00,0.00,'Payment Id 345005 for invoice:231734, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951432,'','supplier','252',0.00,152475.00,'Payment Id 345005 for invoice:231734, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951433,'','6.1','3477',12000.00,0.00,'Payment Id 345002 for invoice:231730, receipt: 00 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951434,'','supplier','252',0.00,12000.00,'Payment Id 345002 for invoice:231730, receipt: 00 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951435,'','2','3681',79000.00,0.00,'Payment Id 345000 for invoice:231730, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951436,'','supplier','252',0.00,79000.00,'Payment Id 345000 for invoice:231730, receipt: 02638 by SALBAS OIL & GAS LIMITED','2022-04-04 11:33:20','',''),('5','182',4951437,'','20','3478',0.00,0.00,'Sales from shift 257553 on 2022-04-05 09:05:22 ','2022-04-05 09:05:22','',''),('5','182',4951438,'','6.1','3477',0.00,0.00,'Sales from shift 257553 on 2022-04-05 09:05:22 ','2022-04-05 09:05:22','',''),('5','182',4951439,'','20','3478',0.00,0.00,'Sales from shift 257554 on 2022-04-06 08:21:30 ','2022-04-06 08:21:30','',''),('5','182',4951440,'','6.1','3477',0.00,0.00,'Sales from shift 257554 on 2022-04-06 08:21:30 ','2022-04-06 08:21:30','',''),('5','182',4951441,'','20','3478',0.00,0.00,'Sales from shift 257555 on 2022-04-07 07:50:00 ','2022-04-07 07:50:00','',''),('5','182',4951442,'','6.1','3477',0.00,0.00,'Sales from shift 257555 on 2022-04-07 07:50:00 ','2022-04-07 07:50:00','',''),('5','182',4951443,'','20','3478',0.00,0.00,'Sales from shift 257556 on 2022-04-08 04:09:24 ','2022-04-08 04:09:24','',''),('5','182',4951444,'','6.1','3477',0.00,0.00,'Sales from shift 257556 on 2022-04-08 04:09:24 ','2022-04-08 04:09:24','',''),('5','182',4951445,'','20','3478',0.00,0.00,'Sales from shift 257557 on 2022-04-09 09:35:31 ','2022-04-09 09:35:31','',''),('5','182',4951446,'','6.1','3477',0.00,0.00,'Sales from shift 257557 on 2022-04-09 09:35:31 ','2022-04-09 09:35:31','',''),('5','182',4951447,'','20','3478',0.00,0.00,'Sales from shift 257558 on 2022-04-10 00:16:26 ','2022-04-10 00:16:26','',''),('5','182',4951448,'','6.1','3477',0.00,0.00,'Sales from shift 257558 on 2022-04-10 00:16:26 ','2022-04-10 00:16:26','',''),('5','182',4951449,'','20','3478',0.00,0.00,'Sales from shift 257559 on 2022-04-11 03:59:59 ','2022-04-11 03:59:59','',''),('5','182',4951450,'','6.1','3477',0.00,0.00,'Sales from shift 257559 on 2022-04-11 03:59:59 ','2022-04-11 03:59:59','',''),('5','182',4951451,'','20','3478',0.00,0.00,'Sales from shift 257560 on 2022-04-12 12:48:45 ','2022-04-12 12:48:45','',''),('5','182',4951452,'','6.1','3477',0.00,0.00,'Sales from shift 257560 on 2022-04-12 12:48:45 ','2022-04-12 12:48:45','',''),('5','182',4951453,'','20','3478',0.00,0.00,'Sales from shift 257561 on 2022-04-13 04:06:32 ','2022-04-13 04:06:32','',''),('5','182',4951454,'','6.1','3477',0.00,0.00,'Sales from shift 257561 on 2022-04-13 04:06:32 ','2022-04-13 04:06:32','',''),('5','182',4951455,'','20','3478',0.00,0.00,'Sales from shift 257562 on 2022-04-14 03:30:46 ','2022-04-14 03:30:46','',''),('5','182',4951456,'','6.1','3477',0.00,0.00,'Sales from shift 257562 on 2022-04-14 03:30:46 ','2022-04-14 03:30:46','',''),('5','182',4951457,'','20','3478',0.00,0.00,'Sales from shift 257563 on 2022-04-15 05:50:08 ','2022-04-15 05:50:08','',''),('5','182',4951458,'','6.1','3477',0.00,0.00,'Sales from shift 257563 on 2022-04-15 05:50:08 ','2022-04-15 05:50:08','',''),('5','182',4951459,'','20','3478',0.00,0.00,'Sales from shift 257564 on 2022-04-16 05:14:18 ','2022-04-16 05:14:18','',''),('5','182',4951460,'','6.1','3477',0.00,0.00,'Sales from shift 257564 on 2022-04-16 05:14:18 ','2022-04-16 05:14:18','',''),('5','182',4951461,'','20','3478',0.00,0.00,'Sales from shift 257565 on 2022-04-17 09:55:56 ','2022-04-17 09:55:56','',''),('5','182',4951462,'','6.1','3477',0.00,0.00,'Sales from shift 257565 on 2022-04-17 09:55:56 ','2022-04-17 09:55:56','',''),('5','182',4951463,'','20','3478',0.00,0.00,'Sales from shift 257566 on 2022-04-18 00:00:38 ','2022-04-18 00:00:38','',''),('5','182',4951464,'','6.1','3477',0.00,0.00,'Sales from shift 257566 on 2022-04-18 00:00:38 ','2022-04-18 00:00:38','',''),('5','182',4951465,'','20','3478',0.00,0.00,'Sales from shift 257567 on 2022-04-19 07:52:58 ','2022-04-19 07:52:58','',''),('5','182',4951466,'','6.1','3477',0.00,0.00,'Sales from shift 257567 on 2022-04-19 07:52:58 ','2022-04-19 07:52:58','',''),('5','182',4951467,'','24','3474',0.00,2310000.00,'Purchase Id 89529 for 14,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-19 16:28:02','',''),('5','182',4951468,'','supplier','252',2310000.00,0.00,'Purchase Id 89529 for 14,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-19 16:28:02','',''),('5','182',4951469,'','20','3478',755178.60,0.00,'Sales from shift 257568 on 2022-04-20 04:52:10 ','2022-04-20 04:52:10','',''),('5','182',4951470,'','6.1','3477',0.00,755178.60,'Sales from shift 257568 on 2022-04-20 04:52:10 ','2022-04-20 04:52:10','',''),('5','182',4951471,'','6.1','3477',277750.00,0.00,'Payment Id 396843 for invoice:257568, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-20 16:06:25','',''),('5','182',4951472,'','supplier','252',0.00,277750.00,'Payment Id 396843 for invoice:257568, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-20 16:06:25','',''),('5','182',4951473,'','2','3682',477430.00,0.00,'Payment Id 396842 for invoice:257568, receipt: 6945550 by SALBAS OIL & GAS LIMITED','2022-04-20 16:06:25','',''),('5','182',4951474,'','supplier','252',0.00,477430.00,'Payment Id 396842 for invoice:257568, receipt: 6945550 by SALBAS OIL & GAS LIMITED','2022-04-20 16:06:25','',''),('5','182',4951475,'','20','3478',1292563.80,0.00,'Sales from shift 257569 on 2022-04-21 04:26:27 ','2022-04-21 04:26:27','',''),('5','182',4951476,'','6.1','3477',0.00,1292563.80,'Sales from shift 257569 on 2022-04-21 04:26:27 ','2022-04-21 04:26:27','',''),('5','182',4951477,'','6.1','3477',38050.00,0.00,'Payment Id 396845 for invoice:257569, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-21 16:42:34','',''),('5','182',4951478,'','supplier','252',0.00,38050.00,'Payment Id 396845 for invoice:257569, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-21 16:42:34','',''),('5','182',4951479,'','2','3682',1254510.00,0.00,'Payment Id 396844 for invoice:257569, receipt: 6947376 by SALBAS OIL & GAS LIMITED','2022-04-21 16:42:34','',''),('5','182',4951480,'','supplier','252',0.00,1254510.00,'Payment Id 396844 for invoice:257569, receipt: 6947376 by SALBAS OIL & GAS LIMITED','2022-04-21 16:42:34','',''),('5','182',4951481,'','20','3478',290862.00,0.00,'Sales from shift 257570 on 2022-04-22 06:11:19 ','2022-04-22 06:11:19','',''),('5','182',4951482,'','6.1','3477',0.00,290862.00,'Sales from shift 257570 on 2022-04-22 06:11:19 ','2022-04-22 06:11:19','',''),('5','182',4951483,'','6.1','3477',28050.00,0.00,'Payment Id 396847 for invoice:257570, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-22 14:04:52','',''),('5','182',4951484,'','supplier','252',0.00,28050.00,'Payment Id 396847 for invoice:257570, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-22 14:04:52','',''),('5','182',4951485,'','2','3682',262810.00,0.00,'Payment Id 396846 for invoice:257570, receipt: 4948195 by SALBAS OIL & GAS LIMITED','2022-04-22 14:04:52','',''),('5','182',4951486,'','supplier','252',0.00,262810.00,'Payment Id 396846 for invoice:257570, receipt: 4948195 by SALBAS OIL & GAS LIMITED','2022-04-22 14:04:52','',''),('5','182',4951487,'','24','3474',0.00,3960000.00,'Purchase Id 89530 for 24,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-22 22:28:43','',''),('5','182',4951488,'','supplier','252',3960000.00,0.00,'Purchase Id 89530 for 24,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-22 22:28:43','',''),('5','182',4951489,'','20','3478',205260.00,0.00,'Sales from shift 257571 on 2022-04-23 08:33:03 ','2022-04-23 08:33:03','',''),('5','182',4951490,'','6.1','3477',0.00,205260.00,'Sales from shift 257571 on 2022-04-23 08:33:03 ','2022-04-23 08:33:03','',''),('5','182',4951491,'','20','3478',709673.25,0.00,'Sales from shift 257572 on 2022-04-24 03:10:23 ','2022-04-24 03:10:23','',''),('5','182',4951492,'','6.1','3477',0.00,709673.25,'Sales from shift 257572 on 2022-04-24 03:10:23 ','2022-04-24 03:10:23','',''),('5','182',4951493,'','20','3478',838028.40,0.00,'Sales from shift 257573 on 2022-04-25 03:49:35 ','2022-04-25 03:49:35','',''),('5','182',4951494,'','6.1','3477',0.00,838028.40,'Sales from shift 257573 on 2022-04-25 03:49:35 ','2022-04-25 03:49:35','',''),('5','182',4951495,'','6.1','3477',28050.00,0.00,'Payment Id 396853 for invoice:257572, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951496,'','supplier','252',0.00,28050.00,'Payment Id 396853 for invoice:257572, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951497,'','2','3682',809980.00,0.00,'Payment Id 396852 for invoice:257572, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951498,'','supplier','252',0.00,809980.00,'Payment Id 396852 for invoice:257572, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951499,'','6.1','3477',26400.00,0.00,'Payment Id 396851 for invoice:257571, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951500,'','supplier','252',0.00,26400.00,'Payment Id 396851 for invoice:257571, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951501,'','2','3682',683275.00,0.00,'Payment Id 396850 for invoice:257571, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951502,'','supplier','252',0.00,683275.00,'Payment Id 396850 for invoice:257571, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951503,'','6.1','3477',26400.00,0.00,'Payment Id 396849 for invoice:257570, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951504,'','supplier','252',0.00,26400.00,'Payment Id 396849 for invoice:257570, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951505,'','2','3682',178860.00,0.00,'Payment Id 396848 for invoice:257570, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951506,'','supplier','252',0.00,178860.00,'Payment Id 396848 for invoice:257570, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-04-25 20:25:29','',''),('5','182',4951507,'','20','3478',660412.50,0.00,'Sales from shift 257574 on 2022-04-26 02:17:39 ','2022-04-26 02:17:39','',''),('5','182',4951508,'','6.1','3477',0.00,660412.50,'Sales from shift 257574 on 2022-04-26 02:17:39 ','2022-04-26 02:17:39','',''),('5','182',4951509,'','6.1','3477',38050.00,0.00,'Payment Id 396856 for invoice:257575, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-26 14:18:44','',''),('5','182',4951510,'','supplier','252',0.00,38050.00,'Payment Id 396856 for invoice:257575, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-26 14:18:44','',''),('5','182',4951511,'','2','3682',622370.00,0.00,'Payment Id 396854 for invoice:257575, receipt: 6946560 by SALBAS OIL & GAS LIMITED','2022-04-26 14:18:44','',''),('5','182',4951512,'','supplier','252',0.00,622370.00,'Payment Id 396854 for invoice:257575, receipt: 6946560 by SALBAS OIL & GAS LIMITED','2022-04-26 14:18:44','',''),('5','182',4951513,'','20','3478',891125.40,0.00,'Sales from shift 257575 on 2022-04-27 03:39:35 ','2022-04-27 03:39:35','',''),('5','182',4951514,'','6.1','3477',0.00,891125.40,'Sales from shift 257575 on 2022-04-27 03:39:35 ','2022-04-27 03:39:35','',''),('5','182',4951515,'','24','3474',0.00,4950000.00,'Purchase Id 89531 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-27 03:39:59','',''),('5','182',4951516,'','supplier','252',4950000.00,0.00,'Purchase Id 89531 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-04-27 03:39:59','',''),('5','182',4951517,'','6.1','3477',28050.00,0.00,'Payment Id 396858 for invoice:257575, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-27 18:01:24','',''),('5','182',4951518,'','supplier','252',0.00,28050.00,'Payment Id 396858 for invoice:257575, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-27 18:01:24','',''),('5','182',4951519,'','2','3682',863075.00,0.00,'Payment Id 396857 for invoice:257575, receipt: 6947645 by SALBAS OIL & GAS LIMITED','2022-04-27 18:01:24','',''),('5','182',4951520,'','supplier','252',0.00,863075.00,'Payment Id 396857 for invoice:257575, receipt: 6947645 by SALBAS OIL & GAS LIMITED','2022-04-27 18:01:24','',''),('5','182',4951521,'','20','3478',1084510.35,0.00,'Sales from shift 257576 on 2022-04-28 02:28:32 ','2022-04-28 02:28:32','',''),('5','182',4951522,'','6.1','3477',0.00,1084510.35,'Sales from shift 257576 on 2022-04-28 02:28:32 ','2022-04-28 02:28:32','',''),('5','182',4951523,'','6.1','3477',41350.00,0.00,'Payment Id 396860 for invoice:257576, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-28 22:41:33','',''),('5','182',4951524,'','supplier','252',0.00,41350.00,'Payment Id 396860 for invoice:257576, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-28 22:41:33','',''),('5','182',4951525,'','2','3682',1043060.00,0.00,'Payment Id 396859 for invoice:257576, receipt: 6947644 by SALBAS OIL & GAS LIMITED','2022-04-28 22:41:33','',''),('5','182',4951526,'','supplier','252',0.00,1043060.00,'Payment Id 396859 for invoice:257576, receipt: 6947644 by SALBAS OIL & GAS LIMITED','2022-04-28 22:41:33','',''),('5','182',4951527,'','20','3478',690764.25,0.00,'Sales from shift 257577 on 2022-04-29 06:05:21 ','2022-04-29 06:05:21','',''),('5','182',4951528,'','6.1','3477',0.00,690764.25,'Sales from shift 257577 on 2022-04-29 06:05:21 ','2022-04-29 06:05:21','',''),('5','182',4951529,'','6.1','3477',28150.00,0.00,'Payment Id 396862 for invoice:257577, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-29 14:48:16','',''),('5','182',4951530,'','supplier','252',0.00,28150.00,'Payment Id 396862 for invoice:257577, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-04-29 14:48:16','',''),('5','182',4951531,'','2','3682',662715.00,0.00,'Payment Id 396861 for invoice:257577, receipt: 6947641 by SALBAS OIL & GAS LIMITED','2022-04-29 14:48:16','',''),('5','182',4951532,'','supplier','252',0.00,662715.00,'Payment Id 396861 for invoice:257577, receipt: 6947641 by SALBAS OIL & GAS LIMITED','2022-04-29 14:48:16','',''),('5','182',4951533,'','20','3478',1030847.40,0.00,'Sales from shift 257578 on 2022-04-30 00:04:51 ','2022-04-30 00:04:51','',''),('5','182',4951534,'','6.1','3477',0.00,1030847.40,'Sales from shift 257578 on 2022-04-30 00:04:51 ','2022-04-30 00:04:51','',''),('5','182',4951535,'','20','3478',1234076.25,0.00,'Sales from shift 257579 on 2022-05-09 11:34:37 ','2022-05-09 11:34:37','',''),('5','182',4951536,'','6.1','3477',0.00,1234076.25,'Sales from shift 257579 on 2022-05-09 11:34:37 ','2022-05-09 11:34:37','',''),('5','182',4951537,'','20','3478',1173521.25,0.00,'Sales from shift 257580 on 2022-05-09 11:38:31 ','2022-05-09 11:38:31','',''),('5','182',4951538,'','6.1','3477',0.00,1173521.25,'Sales from shift 257580 on 2022-05-09 11:38:31 ','2022-05-09 11:38:31','',''),('5','182',4951539,'','24','3474',0.00,5610000.00,'Purchase Id 89532 for 34,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-05-09 11:42:59','',''),('5','182',4951540,'','supplier','252',5610000.00,0.00,'Purchase Id 89532 for 34,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-05-09 11:42:59','',''),('5','182',4951541,'','20','3478',668807.70,0.00,'Sales from shift 257581 on 2022-05-09 12:40:06 ','2022-05-09 12:40:06','',''),('5','182',4951542,'','6.1','3477',0.00,668807.70,'Sales from shift 257581 on 2022-05-09 12:40:06 ','2022-05-09 12:40:06','',''),('5','182',4951543,'','20','3478',1186493.55,0.00,'Sales from shift 257582 on 2022-05-09 13:09:55 ','2022-05-09 13:09:55','',''),('5','182',4951544,'','6.1','3477',0.00,1186493.55,'Sales from shift 257582 on 2022-05-09 13:09:55 ','2022-05-09 13:09:55','',''),('5','182',4951545,'','20','3478',841823.40,0.00,'Sales from shift 257583 on 2022-05-09 13:12:07 ','2022-05-09 13:12:07','',''),('5','182',4951546,'','6.1','3477',0.00,841823.40,'Sales from shift 257583 on 2022-05-09 13:12:07 ','2022-05-09 13:12:07','',''),('5','182',4951547,'','20','3478',843415.65,0.00,'Sales from shift 257584 on 2022-05-09 13:14:32 ','2022-05-09 13:14:32','',''),('5','182',4951548,'','6.1','3477',0.00,843415.65,'Sales from shift 257584 on 2022-05-09 13:14:32 ','2022-05-09 13:14:32','',''),('5','182',4951549,'','20','3478',830954.85,0.00,'Sales from shift 257585 on 2022-05-09 13:16:17 ','2022-05-09 13:16:17','',''),('5','182',4951550,'','6.1','3477',0.00,830954.85,'Sales from shift 257585 on 2022-05-09 13:16:17 ','2022-05-09 13:16:17','',''),('5','182',4951551,'','20','3478',671089.65,0.00,'Sales from shift 257586 on 2022-05-09 13:19:05 ','2022-05-09 13:19:05','',''),('5','182',4951552,'','6.1','3477',0.00,671089.65,'Sales from shift 257586 on 2022-05-09 13:19:05 ','2022-05-09 13:19:05','',''),('5','182',4951553,'','6.1','3477',28050.00,0.00,'Payment Id 396872 for invoice:257582, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951554,'','supplier','252',0.00,28050.00,'Payment Id 396872 for invoice:257582, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951555,'','2','3682',1158445.00,0.00,'Payment Id 396871 for invoice:257582, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951556,'','supplier','252',0.00,1158445.00,'Payment Id 396871 for invoice:257582, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951557,'','6.1','3477',26400.00,0.00,'Payment Id 396870 for invoice:257581, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951558,'','supplier','252',0.00,26400.00,'Payment Id 396870 for invoice:257581, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951559,'','2','3682',642410.00,0.00,'Payment Id 396869 for invoice:257581, receipt: 6947644 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951560,'','supplier','252',0.00,642410.00,'Payment Id 396869 for invoice:257581, receipt: 6947644 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951561,'','6.1','3477',264750.00,0.00,'Payment Id 396868 for invoice:257580, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951562,'','supplier','252',0.00,264750.00,'Payment Id 396868 for invoice:257580, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951563,'','2','3682',908770.00,0.00,'Payment Id 396867 for invoice:257580, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951564,'','supplier','252',0.00,908770.00,'Payment Id 396867 for invoice:257580, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951565,'','6.1','3477',28050.00,0.00,'Payment Id 396866 for invoice:257579, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951566,'','supplier','252',0.00,28050.00,'Payment Id 396866 for invoice:257579, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951567,'','2','3682',1206025.00,0.00,'Payment Id 396865 for invoice:257579, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951568,'','supplier','252',0.00,1206025.00,'Payment Id 396865 for invoice:257579, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951569,'','6.1','3477',26400.00,0.00,'Payment Id 396864 for invoice:257578, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951570,'','supplier','252',0.00,26400.00,'Payment Id 396864 for invoice:257578, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951571,'','2','3682',1004450.00,0.00,'Payment Id 396863 for invoice:257578, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951572,'','supplier','252',0.00,1004450.00,'Payment Id 396863 for invoice:257578, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-05-09 13:19:32','',''),('5','182',4951573,'','20','3478',627371.25,0.00,'Sales from shift 257587 on 2022-05-09 13:21:10 ','2022-05-09 13:21:10','',''),('5','182',4951574,'','6.1','3477',0.00,627371.25,'Sales from shift 257587 on 2022-05-09 13:21:10 ','2022-05-09 13:21:10','',''),('5','182',4951575,'','6.1','3477',28050.00,0.00,'Payment Id 396882 for invoice:2575875, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951576,'','supplier','252',0.00,28050.00,'Payment Id 396882 for invoice:2575875, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951577,'','2','3682',599320.00,0.00,'Payment Id 396881 for invoice:257586, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951578,'','supplier','252',0.00,599320.00,'Payment Id 396881 for invoice:257586, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951579,'','6.1','3477',26400.00,0.00,'Payment Id 396880 for invoice:257585, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951580,'','supplier','252',0.00,26400.00,'Payment Id 396880 for invoice:257585, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951581,'','2','3682',644690.00,0.00,'Payment Id 396879 for invoice:257585, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951582,'','supplier','252',0.00,644690.00,'Payment Id 396879 for invoice:257585, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951583,'','6.1','3477',26400.00,0.00,'Payment Id 396878 for invoice:257584, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951584,'','supplier','252',0.00,26400.00,'Payment Id 396878 for invoice:257584, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951585,'','2','3682',804555.00,0.00,'Payment Id 396877 for invoice:257584, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951586,'','supplier','252',0.00,804555.00,'Payment Id 396877 for invoice:257584, receipt: 6945321 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951587,'','6.1','3477',28050.00,0.00,'Payment Id 396876 for invoice:257583, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951588,'','supplier','252',0.00,28050.00,'Payment Id 396876 for invoice:257583, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951589,'','2','3682',815365.00,0.00,'Payment Id 396875 for invoice:257583, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951590,'','supplier','252',0.00,815365.00,'Payment Id 396875 for invoice:257583, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951591,'','6.1','3477',28050.00,0.00,'Payment Id 396874 for invoice:257582, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951592,'','supplier','252',0.00,28050.00,'Payment Id 396874 for invoice:257582, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951593,'','2','3682',813775.00,0.00,'Payment Id 396873 for invoice:257582, receipt: 6947641 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951594,'','supplier','252',0.00,813775.00,'Payment Id 396873 for invoice:257582, receipt: 6947641 by SALBAS OIL & GAS LIMITED','2022-05-09 13:38:27','',''),('5','182',4951595,'','20','3478',294417.75,0.00,'Sales from shift 257588 on 2022-05-10 06:50:24 ','2022-05-10 06:50:24','',''),('5','182',4951596,'','6.1','3477',0.00,294417.75,'Sales from shift 257588 on 2022-05-10 06:50:24 ','2022-05-10 06:50:24','',''),('5','182',4951597,'','6.1','3477',28050.00,0.00,'Payment Id 396884 for invoice:257588, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-10 12:48:12','',''),('5','182',4951598,'','supplier','252',0.00,28050.00,'Payment Id 396884 for invoice:257588, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-10 12:48:12','',''),('5','182',4951599,'','2','3682',266370.00,0.00,'Payment Id 396883 for invoice:257588, receipt: 6945243 by SALBAS OIL & GAS LIMITED','2022-05-10 12:48:12','',''),('5','182',4951600,'','supplier','252',0.00,266370.00,'Payment Id 396883 for invoice:257588, receipt: 6945243 by SALBAS OIL & GAS LIMITED','2022-05-10 12:48:12','',''),('5','182',4951601,'','20','3478',0.00,0.00,'Sales from shift 257589 on 2022-05-10 22:53:53 ','2022-05-10 22:53:53','',''),('5','182',4951602,'','6.1','3477',0.00,0.00,'Sales from shift 257589 on 2022-05-10 22:53:53 ','2022-05-10 22:53:53','',''),('5','182',4951603,'','20','3478',0.00,0.00,'Sales from shift 257590 on 2022-05-12 05:33:30 ','2022-05-12 05:33:30','',''),('5','182',4951604,'','6.1','3477',0.00,0.00,'Sales from shift 257590 on 2022-05-12 05:33:30 ','2022-05-12 05:33:30','',''),('5','182',4951605,'','20','3478',0.00,0.00,'Sales from shift 257591 on 2022-05-12 22:43:42 ','2022-05-12 22:43:42','',''),('5','182',4951606,'','6.1','3477',0.00,0.00,'Sales from shift 257591 on 2022-05-12 22:43:42 ','2022-05-12 22:43:42','',''),('5','182',4951607,'','20','3478',0.00,0.00,'Sales from shift 257592 on 2022-05-13 22:28:01 ','2022-05-13 22:28:01','',''),('5','182',4951608,'','6.1','3477',0.00,0.00,'Sales from shift 257592 on 2022-05-13 22:28:01 ','2022-05-13 22:28:01','',''),('5','182',4951609,'','20','3478',0.00,0.00,'Sales from shift 257593 on 2022-05-15 06:12:07 ','2022-05-15 06:12:07','',''),('5','182',4951610,'','6.1','3477',0.00,0.00,'Sales from shift 257593 on 2022-05-15 06:12:07 ','2022-05-15 06:12:07','',''),('5','182',4951611,'','20','3478',0.00,0.00,'Sales from shift 257594 on 2022-05-16 06:04:21 ','2022-05-16 06:04:21','',''),('5','182',4951612,'','6.1','3477',0.00,0.00,'Sales from shift 257594 on 2022-05-16 06:04:21 ','2022-05-16 06:04:21','',''),('5','182',4951613,'','20','3478',0.00,0.00,'Sales from shift 257595 on 2022-05-17 06:14:05 ','2022-05-17 06:14:05','',''),('5','182',4951614,'','6.1','3477',0.00,0.00,'Sales from shift 257595 on 2022-05-17 06:14:05 ','2022-05-17 06:14:05','',''),('5','182',4951615,'','20','3478',0.00,0.00,'Sales from shift 257596 on 2022-05-18 06:13:58 ','2022-05-18 06:13:58','',''),('5','182',4951616,'','6.1','3477',0.00,0.00,'Sales from shift 257596 on 2022-05-18 06:13:58 ','2022-05-18 06:13:58','',''),('5','182',4951617,'','20','3478',0.00,0.00,'Sales from shift 257597 on 2022-05-18 21:32:32 ','2022-05-18 21:32:32','',''),('5','182',4951618,'','6.1','3477',0.00,0.00,'Sales from shift 257597 on 2022-05-18 21:32:32 ','2022-05-18 21:32:32','',''),('5','182',4951619,'','20','3478',0.00,0.00,'Sales from shift 257598 on 2022-05-19 21:00:42 ','2022-05-19 21:00:42','',''),('5','182',4951620,'','6.1','3477',0.00,0.00,'Sales from shift 257598 on 2022-05-19 21:00:42 ','2022-05-19 21:00:42','',''),('5','182',4951621,'','20','3478',0.00,0.00,'Sales from shift 257599 on 2022-05-20 21:26:06 ','2022-05-20 21:26:06','',''),('5','182',4951622,'','6.1','3477',0.00,0.00,'Sales from shift 257599 on 2022-05-20 21:26:06 ','2022-05-20 21:26:06','',''),('5','182',4951623,'','20','3478',0.00,0.00,'Sales from shift 257600 on 2022-05-22 08:16:23 ','2022-05-22 08:16:23','',''),('5','182',4951624,'','6.1','3477',0.00,0.00,'Sales from shift 257600 on 2022-05-22 08:16:23 ','2022-05-22 08:16:23','',''),('5','182',4951625,'','20','3478',0.00,0.00,'Sales from shift 257601 on 2022-05-23 05:18:14 ','2022-05-23 05:18:14','',''),('5','182',4951626,'','6.1','3477',0.00,0.00,'Sales from shift 257601 on 2022-05-23 05:18:14 ','2022-05-23 05:18:14','',''),('5','182',4951627,'','20','3478',0.00,0.00,'Sales from shift 257602 on 2022-05-24 08:02:59 ','2022-05-24 08:02:59','',''),('5','182',4951628,'','6.1','3477',0.00,0.00,'Sales from shift 257602 on 2022-05-24 08:02:59 ','2022-05-24 08:02:59','',''),('5','182',4951629,'','20','3478',0.00,0.00,'Sales from shift 257603 on 2022-05-25 06:12:40 ','2022-05-25 06:12:40','',''),('5','182',4951630,'','6.1','3477',0.00,0.00,'Sales from shift 257603 on 2022-05-25 06:12:40 ','2022-05-25 06:12:40','',''),('5','182',4951631,'','24','3474',0.00,6105000.00,'Purchase Id 89533 for 37,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-05-25 21:44:44','',''),('5','182',4951632,'','supplier','252',6105000.00,0.00,'Purchase Id 89533 for 37,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-05-25 21:44:44','',''),('5','182',4951633,'','20','3478',414646.65,0.00,'Sales from shift 257604 on 2022-05-26 10:02:51 ','2022-05-26 10:02:51','',''),('5','182',4951634,'','6.1','3477',0.00,414646.65,'Sales from shift 257604 on 2022-05-26 10:02:51 ','2022-05-26 10:02:51','',''),('5','182',4951635,'','6.1','3477',289650.00,0.00,'Payment Id 396886 for invoice:257604, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-26 11:55:37','',''),('5','182',4951636,'','supplier','252',0.00,289650.00,'Payment Id 396886 for invoice:257604, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-26 11:55:37','',''),('5','182',4951637,'','2','3682',125000.00,0.00,'Payment Id 396885 for invoice:257604, receipt: 6946548 by SALBAS OIL & GAS LIMITED','2022-05-26 11:55:37','',''),('5','182',4951638,'','supplier','252',0.00,125000.00,'Payment Id 396885 for invoice:257604, receipt: 6946548 by SALBAS OIL & GAS LIMITED','2022-05-26 11:55:37','',''),('5','182',4951639,'','20','3478',729268.65,0.00,'Sales from shift 257605 on 2022-05-27 05:28:10 ','2022-05-27 05:28:10','',''),('5','182',4951640,'','6.1','3477',0.00,729268.65,'Sales from shift 257605 on 2022-05-27 05:28:10 ','2022-05-27 05:28:10','',''),('5','182',4951641,'','6.1','3477',39650.00,0.00,'Payment Id 396889 for invoice:257606, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-27 11:41:12','',''),('5','182',4951642,'','supplier','252',0.00,39650.00,'Payment Id 396889 for invoice:257606, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-27 11:41:12','',''),('5','182',4951643,'','2','3682',689620.00,0.00,'Payment Id 396888 for invoice:257606, receipt: 6946686 by SALBAS OIL & GAS LIMITED','2022-05-27 11:41:12','',''),('5','182',4951644,'','supplier','252',0.00,689620.00,'Payment Id 396888 for invoice:257606, receipt: 6946686 by SALBAS OIL & GAS LIMITED','2022-05-27 11:41:12','',''),('5','182',4951645,'','20','3478',758798.70,0.00,'Sales from shift 257606 on 2022-05-28 05:00:02 ','2022-05-28 05:00:02','',''),('5','182',4951646,'','6.1','3477',0.00,758798.70,'Sales from shift 257606 on 2022-05-28 05:00:02 ','2022-05-28 05:00:02','',''),('5','182',4951647,'','20','3478',784604.70,0.00,'Sales from shift 257607 on 2022-05-29 08:19:07 ','2022-05-29 08:19:07','',''),('5','182',4951648,'','6.1','3477',0.00,784604.70,'Sales from shift 257607 on 2022-05-29 08:19:07 ','2022-05-29 08:19:07','',''),('5','182',4951649,'','20','3478',766903.50,0.00,'Sales from shift 257608 on 2022-05-30 05:01:18 ','2022-05-30 05:01:18','',''),('5','182',4951650,'','6.1','3477',0.00,766903.50,'Sales from shift 257608 on 2022-05-30 05:01:18 ','2022-05-30 05:01:18','',''),('5','182',4951651,'','6.1','3477',29650.00,0.00,'Payment Id 396895 for invoice:257608, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951652,'','supplier','252',0.00,29650.00,'Payment Id 396895 for invoice:257608, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951653,'','2','3682',737255.00,0.00,'Payment Id 396894 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951654,'','supplier','252',0.00,737255.00,'Payment Id 396894 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951655,'','6.1','3477',28000.00,0.00,'Payment Id 396893 for invoice:257608, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951656,'','supplier','252',0.00,28000.00,'Payment Id 396893 for invoice:257608, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951657,'','2','3682',756600.00,0.00,'Payment Id 396892 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951658,'','supplier','252',0.00,756600.00,'Payment Id 396892 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951659,'','6.1','3477',28000.00,0.00,'Payment Id 396891 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951660,'','supplier','252',0.00,28000.00,'Payment Id 396891 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951661,'','2','3682',730800.00,0.00,'Payment Id 396890 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951662,'','supplier','252',0.00,730800.00,'Payment Id 396890 for invoice:257608, receipt: 6946689 by SALBAS OIL & GAS LIMITED','2022-05-30 17:27:35','',''),('5','182',4951663,'','20','3478',703074.90,0.00,'Sales from shift 257609 on 2022-05-31 00:22:17 ','2022-05-31 00:22:17','',''),('5','182',4951664,'','6.1','3477',0.00,703074.90,'Sales from shift 257609 on 2022-05-31 00:22:17 ','2022-05-31 00:22:17','',''),('5','182',4951665,'','6.1','3477',29650.00,0.00,'Payment Id 396897 for invoice:257610, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-31 15:07:16','',''),('5','182',4951666,'','supplier','252',0.00,29650.00,'Payment Id 396897 for invoice:257610, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-05-31 15:07:16','',''),('5','182',4951667,'','2','3682',673530.00,0.00,'Payment Id 396896 for invoice:257610, receipt: 6946294 by SALBAS OIL & GAS LIMITED','2022-05-31 15:07:16','',''),('5','182',4951668,'','supplier','252',0.00,673530.00,'Payment Id 396896 for invoice:257610, receipt: 6946294 by SALBAS OIL & GAS LIMITED','2022-05-31 15:07:16','',''),('5','182',4951669,'','20','3478',687258.00,0.00,'Sales from shift 257610 on 2022-06-01 07:06:31 ','2022-06-01 07:06:31','',''),('5','182',4951670,'','6.1','3477',0.00,687258.00,'Sales from shift 257610 on 2022-06-01 07:06:31 ','2022-06-01 07:06:31','',''),('5','182',4951671,'','6.1','3477',29650.00,0.00,'Payment Id 396899 for invoice:257611, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-01 19:30:22','',''),('5','182',4951672,'','supplier','252',0.00,29650.00,'Payment Id 396899 for invoice:257611, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-01 19:30:22','',''),('5','182',4951673,'','2','3682',624900.00,0.00,'Payment Id 396898 for invoice:257611, receipt: 6947806 by SALBAS OIL & GAS LIMITED','2022-06-01 19:30:22','',''),('5','182',4951674,'','supplier','252',0.00,624900.00,'Payment Id 396898 for invoice:257611, receipt: 6947806 by SALBAS OIL & GAS LIMITED','2022-06-01 19:30:22','',''),('5','182',4951675,'','20','3478',662508.00,0.00,'Sales from shift 257611 on 2022-06-02 05:02:39 ','2022-06-02 05:02:39','',''),('5','182',4951676,'','6.1','3477',0.00,662508.00,'Sales from shift 257611 on 2022-06-02 05:02:39 ','2022-06-02 05:02:39','',''),('5','182',4951677,'','6.1','3477',54750.00,0.00,'Payment Id 396901 for invoice:257612, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-02 12:14:48','',''),('5','182',4951678,'','supplier','252',0.00,54750.00,'Payment Id 396901 for invoice:257612, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-02 12:14:48','',''),('5','182',4951679,'','2','3682',640460.00,0.00,'Payment Id 396900 for invoice:257612, receipt: 6948627 by SALBAS OIL & GAS LIMITED','2022-06-02 12:14:48','',''),('5','182',4951680,'','supplier','252',0.00,640460.00,'Payment Id 396900 for invoice:257612, receipt: 6948627 by SALBAS OIL & GAS LIMITED','2022-06-02 12:14:48','',''),('5','182',4951681,'','20','3478',338547.00,0.00,'Sales from shift 257612 on 2022-06-03 06:49:23 ','2022-06-03 06:49:23','',''),('5','182',4951682,'','6.1','3477',0.00,338547.00,'Sales from shift 257612 on 2022-06-03 06:49:23 ','2022-06-03 06:49:23','',''),('5','182',4951683,'','6.1','3477',15650.00,0.00,'Payment Id 396903 for invoice:257613, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-03 19:06:29','',''),('5','182',4951684,'','supplier','252',0.00,15650.00,'Payment Id 396903 for invoice:257613, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-03 19:06:29','',''),('5','182',4951685,'','2','3682',322900.00,0.00,'Payment Id 396902 for invoice:257613, receipt: 6945738 by SALBAS OIL & GAS LIMITED','2022-06-03 19:06:29','',''),('5','182',4951686,'','supplier','252',0.00,322900.00,'Payment Id 396902 for invoice:257613, receipt: 6945738 by SALBAS OIL & GAS LIMITED','2022-06-03 19:06:29','',''),('5','182',4951687,'','20','3478',264778.80,0.00,'Sales from shift 257613 on 2022-06-04 06:09:14 ','2022-06-04 06:09:14','',''),('5','182',4951688,'','6.1','3477',0.00,264778.80,'Sales from shift 257613 on 2022-06-04 06:09:14 ','2022-06-04 06:09:14','',''),('5','182',4951689,'','20','3478',0.00,0.00,'Sales from shift 257614 on 2022-06-05 08:11:23 ','2022-06-05 08:11:23','',''),('5','182',4951690,'','6.1','3477',0.00,0.00,'Sales from shift 257614 on 2022-06-05 08:11:23 ','2022-06-05 08:11:23','',''),('5','182',4951691,'','20','3478',0.00,0.00,'Sales from shift 257615 on 2022-06-06 06:30:55 ','2022-06-06 06:30:55','',''),('5','182',4951692,'','6.1','3477',0.00,0.00,'Sales from shift 257615 on 2022-06-06 06:30:55 ','2022-06-06 06:30:55','',''),('5','182',4951693,'','24','3474',0.00,6550500.00,'Purchase Id 89534 for 39,700.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-06-06 22:31:51','',''),('5','182',4951694,'','supplier','252',6550500.00,0.00,'Purchase Id 89534 for 39,700.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-06-06 22:31:51','',''),('5','182',4951695,'','6.1','3477',15650.00,0.00,'Payment Id 396905 for invoice:257616, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-06 22:35:48','',''),('5','182',4951696,'','supplier','252',0.00,15650.00,'Payment Id 396905 for invoice:257616, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-06 22:35:48','',''),('5','182',4951697,'','2','3682',249230.00,0.00,'Payment Id 396904 for invoice:257616, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-06-06 22:35:48','',''),('5','182',4951698,'','supplier','252',0.00,249230.00,'Payment Id 396904 for invoice:257616, receipt: 6945090 by SALBAS OIL & GAS LIMITED','2022-06-06 22:35:48','',''),('5','182',4951699,'','20','3478',619525.50,0.00,'Sales from shift 257616 on 2022-06-07 10:20:43 ','2022-06-07 10:20:43','',''),('5','182',4951700,'','6.1','3477',0.00,619525.50,'Sales from shift 257616 on 2022-06-07 10:20:43 ','2022-06-07 10:20:43','',''),('5','182',4951701,'','2','3682',364875.00,0.00,'Payment Id 396906 for invoice:257617, receipt: 6947802 by SALBAS OIL & GAS LIMITED','2022-06-07 15:31:12','',''),('5','182',4951702,'','supplier','252',0.00,364875.00,'Payment Id 396906 for invoice:257617, receipt: 6947802 by SALBAS OIL & GAS LIMITED','2022-06-07 15:31:12','',''),('5','182',4951703,'','6.1','3477',254650.00,0.00,'Payment Id 396907 for invoice:257617, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-07 15:32:43','',''),('5','182',4951704,'','supplier','252',0.00,254650.00,'Payment Id 396907 for invoice:257617, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-07 15:32:43','',''),('5','182',4951705,'','20','3478',895522.65,0.00,'Sales from shift 257617 on 2022-06-08 10:33:15 ','2022-06-08 10:33:15','',''),('5','182',4951706,'','6.1','3477',0.00,895522.65,'Sales from shift 257617 on 2022-06-08 10:33:15 ','2022-06-08 10:33:15','',''),('5','182',4951707,'','2','3682',865870.00,0.00,'Payment Id 396908 for invoice:257617, receipt: 6947801 by SALBAS OIL & GAS LIMITED','2022-06-08 16:34:08','',''),('5','182',4951708,'','supplier','252',0.00,865870.00,'Payment Id 396908 for invoice:257617, receipt: 6947801 by SALBAS OIL & GAS LIMITED','2022-06-08 16:34:08','',''),('5','182',4951709,'','6.1','3477',29650.00,0.00,'Payment Id 396909 for invoice:257617, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-08 16:34:27','',''),('5','182',4951710,'','supplier','252',0.00,29650.00,'Payment Id 396909 for invoice:257617, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-08 16:34:27','',''),('5','182',4951711,'','20','3478',691249.35,0.00,'Sales from shift 257618 on 2022-06-09 06:03:23 ','2022-06-09 06:03:23','',''),('5','182',4951712,'','6.1','3477',0.00,691249.35,'Sales from shift 257618 on 2022-06-09 06:03:23 ','2022-06-09 06:03:23','',''),('5','182',4951713,'','6.1','3477',29650.00,0.00,'Payment Id 396911 for invoice:257618, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-10 05:30:17','',''),('5','182',4951714,'','supplier','252',0.00,29650.00,'Payment Id 396911 for invoice:257618, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-10 05:30:17','',''),('5','182',4951715,'','2','3682',661600.00,0.00,'Payment Id 396910 for invoice:257618, receipt: 6944048 by SALBAS OIL & GAS LIMITED','2022-06-10 05:30:17','',''),('5','182',4951716,'','supplier','252',0.00,661600.00,'Payment Id 396910 for invoice:257618, receipt: 6944048 by SALBAS OIL & GAS LIMITED','2022-06-10 05:30:17','',''),('5','182',4951717,'','20','3478',808412.55,0.00,'Sales from shift 257619 on 2022-06-10 08:22:04 ','2022-06-10 08:22:04','',''),('5','182',4951718,'','6.1','3477',0.00,808412.55,'Sales from shift 257619 on 2022-06-10 08:22:04 ','2022-06-10 08:22:04','',''),('5','182',4951719,'','2','3682',778760.00,0.00,'Payment Id 396912 for invoice:257619, receipt: 6945718 by SALBAS OIL & GAS LIMITED','2022-06-10 15:20:28','',''),('5','182',4951720,'','supplier','252',0.00,778760.00,'Payment Id 396912 for invoice:257619, receipt: 6945718 by SALBAS OIL & GAS LIMITED','2022-06-10 15:20:28','',''),('5','182',4951721,'','6.1','3477',29650.00,0.00,'Payment Id 396913 for invoice:257619, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-10 15:20:46','',''),('5','182',4951722,'','supplier','252',0.00,29650.00,'Payment Id 396913 for invoice:257619, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-10 15:20:46','',''),('5','182',4951723,'','20','3478',818142.60,0.00,'Sales from shift 257620 on 2022-06-10 21:47:04 ','2022-06-10 21:47:04','',''),('5','182',4951724,'','6.1','3477',0.00,818142.60,'Sales from shift 257620 on 2022-06-10 21:47:04 ','2022-06-10 21:47:04','',''),('5','182',4951725,'','20','3478',693607.20,0.00,'Sales from shift 257621 on 2022-06-12 08:32:42 ','2022-06-12 08:32:42','',''),('5','182',4951726,'','6.1','3477',0.00,693607.20,'Sales from shift 257621 on 2022-06-12 08:32:42 ','2022-06-12 08:32:42','',''),('5','182',4951727,'','20','3478',661415.70,0.00,'Sales from shift 257622 on 2022-06-13 06:56:07 ','2022-06-13 06:56:07','',''),('5','182',4951728,'','6.1','3477',0.00,661415.70,'Sales from shift 257622 on 2022-06-13 06:56:07 ','2022-06-13 06:56:07','',''),('5','182',4951729,'','20','3478',693785.40,0.00,'Sales from shift 257623 on 2022-06-14 09:00:35 ','2022-06-14 09:00:35','',''),('5','182',4951730,'','6.1','3477',0.00,693785.40,'Sales from shift 257623 on 2022-06-14 09:00:35 ','2022-06-14 09:00:35','',''),('5','182',4951731,'','2','3682',790140.00,0.00,'Payment Id 396914 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:22:34','',''),('5','182',4951732,'','supplier','252',0.00,790140.00,'Payment Id 396914 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:22:34','',''),('5','182',4951733,'','6.1','3477',28000.00,0.00,'Payment Id 396915 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:22:59','',''),('5','182',4951734,'','supplier','252',0.00,28000.00,'Payment Id 396915 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:22:59','',''),('5','182',4951735,'','2','3682',665600.00,0.00,'Payment Id 396916 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:23:27','',''),('5','182',4951736,'','supplier','252',0.00,665600.00,'Payment Id 396916 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:23:27','',''),('5','182',4951737,'','6.1','3477',28000.00,0.00,'Payment Id 396917 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:23:39','',''),('5','182',4951738,'','supplier','252',0.00,28000.00,'Payment Id 396917 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:23:39','',''),('5','182',4951739,'','2','3682',631765.00,0.00,'Payment Id 396918 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:24:21','',''),('5','182',4951740,'','supplier','252',0.00,631765.00,'Payment Id 396918 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:24:21','',''),('5','182',4951741,'','6.1','3477',29650.00,0.00,'Payment Id 396919 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:24:38','',''),('5','182',4951742,'','supplier','252',0.00,29650.00,'Payment Id 396919 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:24:38','',''),('5','182',4951743,'','2','3682',664235.00,0.00,'Payment Id 396920 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:25:01','',''),('5','182',4951744,'','supplier','252',0.00,664235.00,'Payment Id 396920 for invoice:257624, receipt: 6944523 by SALBAS OIL & GAS LIMITED','2022-06-14 16:25:01','',''),('5','182',4951745,'','6.1','3477',29650.00,0.00,'Payment Id 396921 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:25:31','',''),('5','182',4951746,'','supplier','252',0.00,29650.00,'Payment Id 396921 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-14 16:25:31','',''),('5','182',4951747,'','20','3478',714788.25,0.00,'Sales from shift 257624 on 2022-06-15 07:35:09 ','2022-06-15 07:35:09','',''),('5','182',4951748,'','6.1','3477',0.00,714788.25,'Sales from shift 257624 on 2022-06-15 07:35:09 ','2022-06-15 07:35:09','',''),('5','182',4951749,'','20','3478',0.00,0.00,'Sales from shift 257625 on 2022-06-16 07:04:39 ','2022-06-16 07:04:39','',''),('5','182',4951750,'','6.1','3477',0.00,0.00,'Sales from shift 257625 on 2022-06-16 07:04:39 ','2022-06-16 07:04:39','',''),('5','182',4951751,'','6.1','3477',29650.00,0.00,'Payment Id 396923 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-16 19:18:27','',''),('5','182',4951752,'','supplier','252',0.00,29650.00,'Payment Id 396923 for invoice:257624, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-06-16 19:18:27','',''),('5','182',4951753,'','2','3682',685240.00,0.00,'Payment Id 396922 for invoice:257624, receipt: 6948721 by SALBAS OIL & GAS LIMITED','2022-06-16 19:18:27','',''),('5','182',4951754,'','supplier','252',0.00,685240.00,'Payment Id 396922 for invoice:257624, receipt: 6948721 by SALBAS OIL & GAS LIMITED','2022-06-16 19:18:27','',''),('5','182',4951755,'','20','3478',0.00,0.00,'Sales from shift 257626 on 2022-06-17 06:02:01 ','2022-06-17 06:02:01','',''),('5','182',4951756,'','6.1','3477',0.00,0.00,'Sales from shift 257626 on 2022-06-17 06:02:01 ','2022-06-17 06:02:01','',''),('5','182',4951757,'','20','3478',0.00,0.00,'Sales from shift 257627 on 2022-06-18 07:05:58 ','2022-06-18 07:05:58','',''),('5','182',4951758,'','6.1','3477',0.00,0.00,'Sales from shift 257627 on 2022-06-18 07:05:58 ','2022-06-18 07:05:58','',''),('5','182',4951759,'','20','3478',0.00,0.00,'Sales from shift 257628 on 2022-06-18 22:50:58 ','2022-06-18 22:50:58','',''),('5','182',4951760,'','6.1','3477',0.00,0.00,'Sales from shift 257628 on 2022-06-18 22:50:58 ','2022-06-18 22:50:58','',''),('5','182',4951761,'','20','3478',0.00,0.00,'Sales from shift 257629 on 2022-06-20 06:48:22 ','2022-06-20 06:48:22','',''),('5','182',4951762,'','6.1','3477',0.00,0.00,'Sales from shift 257629 on 2022-06-20 06:48:22 ','2022-06-20 06:48:22','',''),('5','182',4951763,'','20','3478',0.00,0.00,'Sales from shift 257630 on 2022-06-21 07:56:19 ','2022-06-21 07:56:19','',''),('5','182',4951764,'','6.1','3477',0.00,0.00,'Sales from shift 257630 on 2022-06-21 07:56:19 ','2022-06-21 07:56:19','',''),('5','182',4951765,'','20','3478',0.00,0.00,'Sales from shift 257631 on 2022-06-21 22:48:51 ','2022-06-21 22:48:51','',''),('5','182',4951766,'','6.1','3477',0.00,0.00,'Sales from shift 257631 on 2022-06-21 22:48:51 ','2022-06-21 22:48:51','',''),('5','182',4951767,'','20','3478',0.00,0.00,'Sales from shift 257632 on 2022-06-23 07:09:12 ','2022-06-23 07:09:12','',''),('5','182',4951768,'','6.1','3477',0.00,0.00,'Sales from shift 257632 on 2022-06-23 07:09:12 ','2022-06-23 07:09:12','',''),('5','182',4951769,'','20','3478',0.00,0.00,'Sales from shift 257633 on 2022-06-23 22:53:37 ','2022-06-23 22:53:37','',''),('5','182',4951770,'','6.1','3477',0.00,0.00,'Sales from shift 257633 on 2022-06-23 22:53:37 ','2022-06-23 22:53:37','',''),('5','182',4951771,'','20','3478',0.00,0.00,'Sales from shift 257634 on 2022-06-25 06:16:27 ','2022-06-25 06:16:27','',''),('5','182',4951772,'','6.1','3477',0.00,0.00,'Sales from shift 257634 on 2022-06-25 06:16:27 ','2022-06-25 06:16:27','',''),('5','182',4951773,'','20','3478',0.00,0.00,'Sales from shift 257635 on 2022-06-26 07:17:25 ','2022-06-26 07:17:25','',''),('5','182',4951774,'','6.1','3477',0.00,0.00,'Sales from shift 257635 on 2022-06-26 07:17:25 ','2022-06-26 07:17:25','',''),('5','182',4951775,'','20','3478',0.00,0.00,'Sales from shift 257636 on 2022-06-27 07:37:45 ','2022-06-27 07:37:45','',''),('5','182',4951776,'','6.1','3477',0.00,0.00,'Sales from shift 257636 on 2022-06-27 07:37:45 ','2022-06-27 07:37:45','',''),('5','182',4951777,'','20','3478',0.00,0.00,'Sales from shift 257637 on 2022-06-28 07:24:28 ','2022-06-28 07:24:28','',''),('5','182',4951778,'','6.1','3477',0.00,0.00,'Sales from shift 257637 on 2022-06-28 07:24:28 ','2022-06-28 07:24:28','',''),('5','182',4951779,'','20','3478',0.00,0.00,'Sales from shift 257638 on 2022-06-29 08:04:17 ','2022-06-29 08:04:17','',''),('5','182',4951780,'','6.1','3477',0.00,0.00,'Sales from shift 257638 on 2022-06-29 08:04:17 ','2022-06-29 08:04:17','',''),('5','182',4951781,'','20','3478',0.00,0.00,'Sales from shift 257639 on 2022-06-30 06:26:22 ','2022-06-30 06:26:22','',''),('5','182',4951782,'','6.1','3477',0.00,0.00,'Sales from shift 257639 on 2022-06-30 06:26:22 ','2022-06-30 06:26:22','',''),('5','182',4951783,'','20','3478',0.00,0.00,'Sales from shift 257640 on 2022-07-01 07:12:07 ','2022-07-01 07:12:07','',''),('5','182',4951784,'','6.1','3477',0.00,0.00,'Sales from shift 257640 on 2022-07-01 07:12:07 ','2022-07-01 07:12:07','',''),('5','182',4951785,'','20','3478',0.00,0.00,'Sales from shift 257641 on 2022-07-02 05:51:07 ','2022-07-02 05:51:07','',''),('5','182',4951786,'','6.1','3477',0.00,0.00,'Sales from shift 257641 on 2022-07-02 05:51:07 ','2022-07-02 05:51:07','',''),('5','182',4951787,'','20','3478',0.00,0.00,'Sales from shift 257642 on 2022-07-03 06:31:34 ','2022-07-03 06:31:34','',''),('5','182',4951788,'','6.1','3477',0.00,0.00,'Sales from shift 257642 on 2022-07-03 06:31:34 ','2022-07-03 06:31:34','',''),('5','182',4951789,'','20','3478',0.00,0.00,'Sales from shift 257643 on 2022-07-03 23:26:58 ','2022-07-03 23:26:58','',''),('5','182',4951790,'','6.1','3477',0.00,0.00,'Sales from shift 257643 on 2022-07-03 23:26:58 ','2022-07-03 23:26:58','',''),('5','182',4951791,'','20','3478',0.00,0.00,'Sales from shift 257644 on 2022-07-04 22:37:15 ','2022-07-04 22:37:15','',''),('5','182',4951792,'','6.1','3477',0.00,0.00,'Sales from shift 257644 on 2022-07-04 22:37:15 ','2022-07-04 22:37:15','',''),('5','182',4951793,'','20','3478',0.00,0.00,'Sales from shift 257645 on 2022-07-06 07:51:19 ','2022-07-06 07:51:19','',''),('5','182',4951794,'','6.1','3477',0.00,0.00,'Sales from shift 257645 on 2022-07-06 07:51:19 ','2022-07-06 07:51:19','',''),('5','182',4951795,'','20','3478',0.00,0.00,'Sales from shift 257646 on 2022-07-07 05:28:48 ','2022-07-07 05:28:48','',''),('5','182',4951796,'','6.1','3477',0.00,0.00,'Sales from shift 257646 on 2022-07-07 05:28:48 ','2022-07-07 05:28:48','',''),('5','182',4951797,'','20','3478',0.00,0.00,'Sales from shift 257647 on 2022-07-08 06:12:10 ','2022-07-08 06:12:10','',''),('5','182',4951798,'','6.1','3477',0.00,0.00,'Sales from shift 257647 on 2022-07-08 06:12:10 ','2022-07-08 06:12:10','',''),('5','182',4951799,'','20','3478',0.00,0.00,'Sales from shift 257648 on 2022-07-08 22:44:06 ','2022-07-08 22:44:06','',''),('5','182',4951800,'','6.1','3477',0.00,0.00,'Sales from shift 257648 on 2022-07-08 22:44:06 ','2022-07-08 22:44:06','',''),('5','182',4951801,'','20','3478',0.00,0.00,'Sales from shift 257649 on 2022-07-10 07:06:24 ','2022-07-10 07:06:24','',''),('5','182',4951802,'','6.1','3477',0.00,0.00,'Sales from shift 257649 on 2022-07-10 07:06:24 ','2022-07-10 07:06:24','',''),('5','182',4951803,'','20','3478',0.00,0.00,'Sales from shift 257650 on 2022-07-11 07:02:26 ','2022-07-11 07:02:26','',''),('5','182',4951804,'','6.1','3477',0.00,0.00,'Sales from shift 257650 on 2022-07-11 07:02:26 ','2022-07-11 07:02:26','',''),('5','182',4951805,'','20','3478',0.00,0.00,'Sales from shift 257651 on 2022-07-12 05:24:36 ','2022-07-12 05:24:36','',''),('5','182',4951806,'','6.1','3477',0.00,0.00,'Sales from shift 257651 on 2022-07-12 05:24:36 ','2022-07-12 05:24:36','',''),('5','182',4951807,'','20','3478',0.00,0.00,'Sales from shift 257652 on 2022-07-13 07:20:17 ','2022-07-13 07:20:17','',''),('5','182',4951808,'','6.1','3477',0.00,0.00,'Sales from shift 257652 on 2022-07-13 07:20:17 ','2022-07-13 07:20:17','',''),('5','182',4951809,'','24','3474',0.00,4162500.00,'Purchase Id 89535 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-14 06:34:22','',''),('5','182',4951810,'','supplier','252',4162500.00,0.00,'Purchase Id 89535 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-14 06:34:22','',''),('5','182',4951811,'','20','3478',524475.00,0.00,'Sales from shift 257653 on 2022-07-14 09:48:54 ','2022-07-14 09:48:54','',''),('5','182',4951812,'','6.1','3477',0.00,524475.00,'Sales from shift 257653 on 2022-07-14 09:48:54 ','2022-07-14 09:48:54','',''),('5','182',4951813,'','6.1','3477',33850.00,0.00,'Payment Id 396925 for invoice:257654, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-14 19:50:10','',''),('5','182',4951814,'','supplier','252',0.00,33850.00,'Payment Id 396925 for invoice:257654, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-14 19:50:10','',''),('5','182',4951815,'','2','3682',490615.00,0.00,'Payment Id 396924 for invoice:257654, receipt: 6974057 by SALBAS OIL & GAS LIMITED','2022-07-14 19:50:10','',''),('5','182',4951816,'','supplier','252',0.00,490615.00,'Payment Id 396924 for invoice:257654, receipt: 6974057 by SALBAS OIL & GAS LIMITED','2022-07-14 19:50:10','',''),('5','182',4951817,'','20','3478',784873.60,0.00,'Sales from shift 257654 on 2022-07-15 07:19:44 ','2022-07-15 07:19:44','',''),('5','182',4951818,'','6.1','3477',0.00,784873.60,'Sales from shift 257654 on 2022-07-15 07:19:44 ','2022-07-15 07:19:44','',''),('5','182',4951819,'','24','3474',0.00,2775000.00,'Purchase Id 89536 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-15 15:41:28','',''),('5','182',4951820,'','supplier','252',2775000.00,0.00,'Purchase Id 89536 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-15 15:41:28','',''),('5','182',4951821,'','20','3478',783850.55,0.00,'Sales from shift 257655 on 2022-07-16 06:56:06 ','2022-07-16 06:56:06','',''),('5','182',4951822,'','6.1','3477',0.00,783850.55,'Sales from shift 257655 on 2022-07-16 06:56:06 ','2022-07-16 06:56:06','',''),('5','182',4951823,'','6.1','3477',33850.00,0.00,'Payment Id 396927 for invoice:257655, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-16 06:56:22','',''),('5','182',4951824,'','supplier','252',0.00,33850.00,'Payment Id 396927 for invoice:257655, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-16 06:56:22','',''),('5','182',4951825,'','2','3682',751020.00,0.00,'Payment Id 396926 for invoice:257655, receipt: 6973230 by SALBAS OIL & GAS LIMITED','2022-07-16 06:56:22','',''),('5','182',4951826,'','supplier','252',0.00,751020.00,'Payment Id 396926 for invoice:257655, receipt: 6973230 by SALBAS OIL & GAS LIMITED','2022-07-16 06:56:22','',''),('5','182',4951827,'','20','3478',935767.00,0.00,'Sales from shift 257656 on 2022-07-17 05:31:27 ','2022-07-17 05:31:27','',''),('5','182',4951828,'','6.1','3477',0.00,935767.00,'Sales from shift 257656 on 2022-07-17 05:31:27 ','2022-07-17 05:31:27','',''),('5','182',4951829,'','20','3478',1014319.85,0.00,'Sales from shift 257657 on 2022-07-18 07:37:04 ','2022-07-18 07:37:04','',''),('5','182',4951830,'','6.1','3477',0.00,1014319.85,'Sales from shift 257657 on 2022-07-18 07:37:04 ','2022-07-18 07:37:04','',''),('5','182',4951831,'','6.1','3477',33850.00,0.00,'Payment Id 396934 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951832,'','supplier','252',0.00,33850.00,'Payment Id 396934 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951833,'','6.1','3477',39850.00,0.00,'Payment Id 396933 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951834,'','supplier','252',0.00,39850.00,'Payment Id 396933 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951835,'','2','3682',980470.00,0.00,'Payment Id 396932 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951836,'','supplier','252',0.00,980470.00,'Payment Id 396932 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951837,'','6.1','3477',272000.00,0.00,'Payment Id 396931 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951838,'','supplier','252',0.00,272000.00,'Payment Id 396931 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951839,'','2','3682',663765.00,0.00,'Payment Id 396930 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951840,'','supplier','252',0.00,663765.00,'Payment Id 396930 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951841,'','6.1','3477',287500.00,0.00,'Payment Id 396929 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951842,'','supplier','252',0.00,287500.00,'Payment Id 396929 for invoice:257658, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951843,'','2','3682',496350.00,0.00,'Payment Id 396928 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951844,'','supplier','252',0.00,496350.00,'Payment Id 396928 for invoice:257658, receipt: 6973231 by SALBAS OIL & GAS LIMITED','2022-07-18 11:51:33','',''),('5','182',4951845,'','20','3478',1172045.30,0.00,'Sales from shift 257658 on 2022-07-19 05:05:04 ','2022-07-19 05:05:04','',''),('5','182',4951846,'','6.1','3477',0.00,1172045.30,'Sales from shift 257658 on 2022-07-19 05:05:04 ','2022-07-19 05:05:04','',''),('5','182',4951847,'','6.1','3477',191550.00,0.00,'Payment Id 396936 for invoice:257659, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-19 19:54:20','',''),('5','182',4951848,'','supplier','252',0.00,191550.00,'Payment Id 396936 for invoice:257659, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-19 19:54:20','',''),('5','182',4951849,'','2','3682',980495.00,0.00,'Payment Id 396935 for invoice:257659, receipt: 002 by SALBAS OIL & GAS LIMITED','2022-07-19 19:54:20','',''),('5','182',4951850,'','supplier','252',0.00,980495.00,'Payment Id 396935 for invoice:257659, receipt: 002 by SALBAS OIL & GAS LIMITED','2022-07-19 19:54:20','',''),('5','182',4951851,'','24','3474',0.00,2775000.00,'Purchase Id 89537 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-19 19:54:37','',''),('5','182',4951852,'','supplier','252',2775000.00,0.00,'Purchase Id 89537 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-19 19:54:37','',''),('5','182',4951853,'','20','3478',846326.90,0.00,'Sales from shift 257659 on 2022-07-20 07:42:07 ','2022-07-20 07:42:07','',''),('5','182',4951854,'','6.1','3477',0.00,846326.90,'Sales from shift 257659 on 2022-07-20 07:42:07 ','2022-07-20 07:42:07','',''),('5','182',4951855,'','6.1','3477',33850.00,0.00,'Payment Id 396938 for invoice:257660, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-20 16:24:29','',''),('5','182',4951856,'','supplier','252',0.00,33850.00,'Payment Id 396938 for invoice:257660, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-20 16:24:29','',''),('5','182',4951857,'','2','3682',812475.00,0.00,'Payment Id 396937 for invoice:257660, receipt: 003 by SALBAS OIL & GAS LIMITED','2022-07-20 16:24:29','',''),('5','182',4951858,'','supplier','252',0.00,812475.00,'Payment Id 396937 for invoice:257660, receipt: 003 by SALBAS OIL & GAS LIMITED','2022-07-20 16:24:29','',''),('5','182',4951859,'','20','3478',944652.55,0.00,'Sales from shift 257660 on 2022-07-21 06:51:07 ','2022-07-21 06:51:07','',''),('5','182',4951860,'','6.1','3477',0.00,944652.55,'Sales from shift 257660 on 2022-07-21 06:51:07 ','2022-07-21 06:51:07','',''),('5','182',4951861,'','6.1','3477',33850.00,0.00,'Payment Id 396940 for invoice:257661, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-21 11:07:50','',''),('5','182',4951862,'','supplier','252',0.00,33850.00,'Payment Id 396940 for invoice:257661, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-21 11:07:50','',''),('5','182',4951863,'','2','3682',910800.00,0.00,'Payment Id 396939 for invoice:257661, receipt: 004 by SALBAS OIL & GAS LIMITED','2022-07-21 11:07:50','',''),('5','182',4951864,'','supplier','252',0.00,910800.00,'Payment Id 396939 for invoice:257661, receipt: 004 by SALBAS OIL & GAS LIMITED','2022-07-21 11:07:50','',''),('5','182',4951865,'','20','3478',748698.70,0.00,'Sales from shift 257661 on 2022-07-21 23:12:49 ','2022-07-21 23:12:49','',''),('5','182',4951866,'','6.1','3477',0.00,748698.70,'Sales from shift 257661 on 2022-07-21 23:12:49 ','2022-07-21 23:12:49','',''),('5','182',4951867,'','6.1','3477',68350.00,0.00,'Payment Id 396942 for invoice:257662, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-22 16:45:37','',''),('5','182',4951868,'','supplier','252',0.00,68350.00,'Payment Id 396942 for invoice:257662, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-22 16:45:37','',''),('5','182',4951869,'','2','3682',680380.00,0.00,'Payment Id 396941 for invoice:257662, receipt: 005 by SALBAS OIL & GAS LIMITED','2022-07-22 16:45:37','',''),('5','182',4951870,'','supplier','252',0.00,680380.00,'Payment Id 396941 for invoice:257662, receipt: 005 by SALBAS OIL & GAS LIMITED','2022-07-22 16:45:37','',''),('5','182',4951871,'','20','3478',1255946.50,0.00,'Sales from shift 257662 on 2022-07-23 13:45:50 ','2022-07-23 13:45:50','',''),('5','182',4951872,'','6.1','3477',0.00,1255946.50,'Sales from shift 257662 on 2022-07-23 13:45:50 ','2022-07-23 13:45:50','',''),('5','182',4951873,'','20','3478',756753.60,0.00,'Sales from shift 257663 on 2022-07-24 08:33:54 ','2022-07-24 08:33:54','',''),('5','182',4951874,'','6.1','3477',0.00,756753.60,'Sales from shift 257663 on 2022-07-24 08:33:54 ','2022-07-24 08:33:54','',''),('5','182',4951875,'','20','3478',0.00,0.00,'Sales from shift 257664 on 2022-07-25 06:46:34 ','2022-07-25 06:46:34','',''),('5','182',4951876,'','6.1','3477',0.00,0.00,'Sales from shift 257664 on 2022-07-25 06:46:34 ','2022-07-25 06:46:34','',''),('5','182',4951877,'','24','3474',0.00,4162500.00,'Purchase Id 89538 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-25 15:26:58','',''),('5','182',4951878,'','supplier','252',4162500.00,0.00,'Purchase Id 89538 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-07-25 15:26:58','',''),('5','182',4951879,'','6.1','3477',38850.00,0.00,'Payment Id 396946 for invoice:257665, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951880,'','supplier','252',0.00,38850.00,'Payment Id 396946 for invoice:257665, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951881,'','2','3682',717900.00,0.00,'Payment Id 396945 for invoice:257665, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951882,'','supplier','252',0.00,717900.00,'Payment Id 396945 for invoice:257665, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951883,'','6.1','3477',42000.00,0.00,'Payment Id 396944 for invoice:257665, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951884,'','supplier','252',0.00,42000.00,'Payment Id 396944 for invoice:257665, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951885,'','2','3682',1213920.00,0.00,'Payment Id 396943 for invoice:257665, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951886,'','supplier','252',0.00,1213920.00,'Payment Id 396943 for invoice:257665, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-25 21:30:31','',''),('5','182',4951887,'','20','3478',753736.25,0.00,'Sales from shift 257665 on 2022-07-26 05:55:52 ','2022-07-26 05:55:52','',''),('5','182',4951888,'','6.1','3477',0.00,753736.25,'Sales from shift 257665 on 2022-07-26 05:55:52 ','2022-07-26 05:55:52','',''),('5','182',4951889,'','6.1','3477',29850.00,0.00,'Payment Id 396948 for invoice:257666, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-26 18:18:04','',''),('5','182',4951890,'','supplier','252',0.00,29850.00,'Payment Id 396948 for invoice:257666, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-26 18:18:04','',''),('5','182',4951891,'','2','3682',723885.00,0.00,'Payment Id 396947 for invoice:257666, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-26 18:18:04','',''),('5','182',4951892,'','supplier','252',0.00,723885.00,'Payment Id 396947 for invoice:257666, receipt: 006 by SALBAS OIL & GAS LIMITED','2022-07-26 18:18:04','',''),('5','182',4951893,'','20','3478',1174426.25,0.00,'Sales from shift 257666 on 2022-07-27 06:06:33 ','2022-07-27 06:06:33','',''),('5','182',4951894,'','6.1','3477',0.00,1174426.25,'Sales from shift 257666 on 2022-07-27 06:06:33 ','2022-07-27 06:06:33','',''),('5','182',4951895,'','6.1','3477',29850.00,0.00,'Payment Id 396950 for invoice:257667, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-27 19:41:05','',''),('5','182',4951896,'','supplier','252',0.00,29850.00,'Payment Id 396950 for invoice:257667, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-27 19:41:05','',''),('5','182',4951897,'','2','3682',1144575.00,0.00,'Payment Id 396949 for invoice:257667, receipt: 007 by SALBAS OIL & GAS LIMITED','2022-07-27 19:41:05','',''),('5','182',4951898,'','supplier','252',0.00,1144575.00,'Payment Id 396949 for invoice:257667, receipt: 007 by SALBAS OIL & GAS LIMITED','2022-07-27 19:41:05','',''),('5','182',4951899,'','20','3478',1127678.60,0.00,'Sales from shift 257667 on 2022-07-28 06:56:31 ','2022-07-28 06:56:31','',''),('5','182',4951900,'','6.1','3477',0.00,1127678.60,'Sales from shift 257667 on 2022-07-28 06:56:31 ','2022-07-28 06:56:31','',''),('5','182',4951901,'','6.1','3477',60850.00,0.00,'Payment Id 396952 for invoice:257668, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-28 16:45:05','',''),('5','182',4951902,'','supplier','252',0.00,60850.00,'Payment Id 396952 for invoice:257668, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-28 16:45:05','',''),('5','182',4951903,'','2','3682',1066830.00,0.00,'Payment Id 396951 for invoice:257668, receipt: 008 by SALBAS OIL & GAS LIMITED','2022-07-28 16:45:05','',''),('5','182',4951904,'','supplier','252',0.00,1066830.00,'Payment Id 396951 for invoice:257668, receipt: 008 by SALBAS OIL & GAS LIMITED','2022-07-28 16:45:05','',''),('5','182',4951905,'','20','3478',751236.90,0.00,'Sales from shift 257668 on 2022-07-29 07:14:05 ','2022-07-29 07:14:05','',''),('5','182',4951906,'','6.1','3477',0.00,751236.90,'Sales from shift 257668 on 2022-07-29 07:14:05 ','2022-07-29 07:14:05','',''),('5','182',4951907,'','6.1','3477',29850.00,0.00,'Payment Id 396954 for invoice:257669, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-29 15:41:22','',''),('5','182',4951908,'','supplier','252',0.00,29850.00,'Payment Id 396954 for invoice:257669, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-07-29 15:41:22','',''),('5','182',4951909,'','2','3682',721385.00,0.00,'Payment Id 396953 for invoice:257669, receipt: 008 by SALBAS OIL & GAS LIMITED','2022-07-29 15:41:22','',''),('5','182',4951910,'','supplier','252',0.00,721385.00,'Payment Id 396953 for invoice:257669, receipt: 008 by SALBAS OIL & GAS LIMITED','2022-07-29 15:41:22','',''),('5','182',4951911,'','20','3478',377007.80,0.00,'Sales from shift 257669 on 2022-07-30 05:50:30 ','2022-07-30 05:50:30','',''),('5','182',4951912,'','6.1','3477',0.00,377007.80,'Sales from shift 257669 on 2022-07-30 05:50:30 ','2022-07-30 05:50:30','',''),('5','182',4951913,'','20','3478',0.00,0.00,'Sales from shift 257670 on 2022-07-31 05:25:21 ','2022-07-31 05:25:21','',''),('5','182',4951914,'','6.1','3477',0.00,0.00,'Sales from shift 257670 on 2022-07-31 05:25:21 ','2022-07-31 05:25:21','',''),('5','182',4951915,'','20','3478',0.00,0.00,'Sales from shift 257671 on 2022-08-01 07:54:51 ','2022-08-01 07:54:51','',''),('5','182',4951916,'','6.1','3477',0.00,0.00,'Sales from shift 257671 on 2022-08-01 07:54:51 ','2022-08-01 07:54:51','',''),('5','182',4951917,'','6.1','3477',29850.00,0.00,'Payment Id 396957 for invoice:257672, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-01 21:17:34','',''),('5','182',4951918,'','supplier','252',0.00,29850.00,'Payment Id 396957 for invoice:257672, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-01 21:17:34','',''),('5','182',4951919,'','2','3682',347160.00,0.00,'Payment Id 396955 for invoice:257672, receipt: 009 by SALBAS OIL & GAS LIMITED','2022-08-01 21:17:34','',''),('5','182',4951920,'','supplier','252',0.00,347160.00,'Payment Id 396955 for invoice:257672, receipt: 009 by SALBAS OIL & GAS LIMITED','2022-08-01 21:17:34','',''),('5','182',4951921,'','20','3478',0.00,0.00,'Sales from shift 257672 on 2022-08-02 05:40:31 ','2022-08-02 05:40:31','',''),('5','182',4951922,'','6.1','3477',0.00,0.00,'Sales from shift 257672 on 2022-08-02 05:40:31 ','2022-08-02 05:40:31','',''),('5','182',4951923,'','24','3474',0.00,2775000.00,'Purchase Id 89539 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-08-02 10:09:15','',''),('5','182',4951924,'','supplier','252',2775000.00,0.00,'Purchase Id 89539 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-08-02 10:09:15','',''),('5','182',4951925,'','20','3478',747671.95,0.00,'Sales from shift 257673 on 2022-08-03 07:00:46 ','2022-08-03 07:00:46','',''),('5','182',4951926,'','6.1','3477',0.00,747671.95,'Sales from shift 257673 on 2022-08-03 07:00:46 ','2022-08-03 07:00:46','',''),('5','182',4951927,'','6.1','3477',32300.00,0.00,'Payment Id 396959 for invoice:257674, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-03 17:53:21','',''),('5','182',4951928,'','supplier','252',0.00,32300.00,'Payment Id 396959 for invoice:257674, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-03 17:53:21','',''),('5','182',4951929,'','2','3682',715375.00,0.00,'Payment Id 396958 for invoice:257674, receipt: 0010 by SALBAS OIL & GAS LIMITED','2022-08-03 17:53:22','',''),('5','182',4951930,'','supplier','252',0.00,715375.00,'Payment Id 396958 for invoice:257674, receipt: 0010 by SALBAS OIL & GAS LIMITED','2022-08-03 17:53:22','',''),('5','182',4951931,'','20','3478',791465.15,0.00,'Sales from shift 257674 on 2022-08-04 06:16:53 ','2022-08-04 06:16:53','',''),('5','182',4951932,'','6.1','3477',0.00,791465.15,'Sales from shift 257674 on 2022-08-04 06:16:53 ','2022-08-04 06:16:53','',''),('5','182',4951933,'','6.1','3477',14600.00,0.00,'Payment Id 396961 for invoice:257675, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-04 16:57:05','',''),('5','182',4951934,'','supplier','252',0.00,14600.00,'Payment Id 396961 for invoice:257675, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-04 16:57:05','',''),('5','182',4951935,'','2','3682',776865.00,0.00,'Payment Id 396960 for invoice:257675, receipt: 0011 by SALBAS OIL & GAS LIMITED','2022-08-04 16:57:05','',''),('5','182',4951936,'','supplier','252',0.00,776865.00,'Payment Id 396960 for invoice:257675, receipt: 0011 by SALBAS OIL & GAS LIMITED','2022-08-04 16:57:05','',''),('5','182',4951937,'','20','3478',790880.55,0.00,'Sales from shift 257675 on 2022-08-04 21:51:54 ','2022-08-04 21:51:54','',''),('5','182',4951938,'','6.1','3477',0.00,790880.55,'Sales from shift 257675 on 2022-08-04 21:51:54 ','2022-08-04 21:51:54','',''),('5','182',4951939,'','6.1','3477',14600.00,0.00,'Payment Id 396963 for invoice:257676, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-05 17:34:54','',''),('5','182',4951940,'','supplier','252',0.00,14600.00,'Payment Id 396963 for invoice:257676, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-08-05 17:34:54','',''),('5','182',4951941,'','2','3682',776280.00,0.00,'Payment Id 396962 for invoice:257676, receipt: 0012 by SALBAS OIL & GAS LIMITED','2022-08-05 17:34:54','',''),('5','182',4951942,'','supplier','252',0.00,776280.00,'Payment Id 396962 for invoice:257676, receipt: 0012 by SALBAS OIL & GAS LIMITED','2022-08-05 17:34:54','',''),('5','182',4951943,'','20','3478',442897.40,0.00,'Sales from shift 257676 on 2022-08-06 06:54:42 ','2022-08-06 06:54:42','',''),('5','182',4951944,'','6.1','3477',0.00,442897.40,'Sales from shift 257676 on 2022-08-06 06:54:42 ','2022-08-06 06:54:42','',''),('5','182',4951945,'','20','3478',0.00,0.00,'Sales from shift 257677 on 2022-08-07 05:38:50 ','2022-08-07 05:38:50','',''),('5','182',4951946,'','6.1','3477',0.00,0.00,'Sales from shift 257677 on 2022-08-07 05:38:50 ','2022-08-07 05:38:50','',''),('5','182',4951947,'','20','3478',0.00,0.00,'Sales from shift 257678 on 2022-09-03 22:01:29 ','2022-09-03 22:01:29','',''),('5','182',4951948,'','6.1','3477',0.00,0.00,'Sales from shift 257678 on 2022-09-03 22:01:29 ','2022-09-03 22:01:29','',''),('5','182',4951949,'','20','3478',0.00,0.00,'Sales from shift 257679 on 2022-09-04 00:06:59 ','2022-09-04 00:06:59','',''),('5','182',4951950,'','6.1','3477',0.00,0.00,'Sales from shift 257679 on 2022-09-04 00:06:59 ','2022-09-04 00:06:59','',''),('5','182',4951951,'','6.1','3477',26300.00,0.00,'Payment Id 397011 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951952,'','supplier','252',0.00,26300.00,'Payment Id 397011 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951953,'','2','3682',1097040.00,0.00,'Payment Id 397010 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951954,'','supplier','252',0.00,1097040.00,'Payment Id 397010 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951955,'','6.1','3477',14600.00,0.00,'Payment Id 397009 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951956,'','supplier','252',0.00,14600.00,'Payment Id 397009 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951957,'','2','3682',957580.00,0.00,'Payment Id 397008 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951958,'','supplier','252',0.00,957580.00,'Payment Id 397008 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951959,'','6.1','3477',14600.00,0.00,'Payment Id 397007 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951960,'','supplier','252',0.00,14600.00,'Payment Id 397007 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951961,'','2','3682',634475.00,0.00,'Payment Id 397006 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951962,'','supplier','252',0.00,634475.00,'Payment Id 397006 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951963,'','6.1','3477',14600.00,0.00,'Payment Id 397005 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951964,'','supplier','252',0.00,14600.00,'Payment Id 397005 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951965,'','2','3682',998765.00,0.00,'Payment Id 397004 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951966,'','supplier','252',0.00,998765.00,'Payment Id 397004 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951967,'','6.1','3477',14600.00,0.00,'Payment Id 397003 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951968,'','supplier','252',0.00,14600.00,'Payment Id 397003 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951969,'','2','3682',644840.00,0.00,'Payment Id 397002 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951970,'','supplier','252',0.00,644840.00,'Payment Id 397002 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 06:32:52','',''),('5','182',4951971,'','6.1','3477',12750.00,0.00,'Payment Id 397001 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951972,'','supplier','252',0.00,12750.00,'Payment Id 397001 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951973,'','2','3682',584210.00,0.00,'Payment Id 397000 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951974,'','supplier','252',0.00,584210.00,'Payment Id 397000 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951975,'','6.1','3477',12750.00,0.00,'Payment Id 396999 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951976,'','supplier','252',0.00,12750.00,'Payment Id 396999 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951977,'','2','3682',360830.00,0.00,'Payment Id 396998 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951978,'','supplier','252',0.00,360830.00,'Payment Id 396998 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951979,'','6.1','3477',14600.00,0.00,'Payment Id 396997 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951980,'','supplier','252',0.00,14600.00,'Payment Id 396997 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951981,'','2','3682',604450.00,0.00,'Payment Id 396996 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951982,'','supplier','252',0.00,604450.00,'Payment Id 396996 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951983,'','6.1','3477',14600.00,0.00,'Payment Id 396995 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951984,'','supplier','252',0.00,14600.00,'Payment Id 396995 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951985,'','2','3682',872705.00,0.00,'Payment Id 396994 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951986,'','supplier','252',0.00,872705.00,'Payment Id 396994 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951987,'','6.1','3477',24600.00,0.00,'Payment Id 396993 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951988,'','supplier','252',0.00,24600.00,'Payment Id 396993 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951989,'','2','3682',802500.00,0.00,'Payment Id 396992 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951990,'','supplier','252',0.00,802500.00,'Payment Id 396992 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:31:36','',''),('5','182',4951991,'','6.1','3477',14600.00,0.00,'Payment Id 396991 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951992,'','supplier','252',0.00,14600.00,'Payment Id 396991 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951993,'','2','3682',549290.00,0.00,'Payment Id 396990 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951994,'','supplier','252',0.00,549290.00,'Payment Id 396990 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951995,'','6.1','3477',14600.00,0.00,'Payment Id 396989 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951996,'','supplier','252',0.00,14600.00,'Payment Id 396989 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951997,'','2','3682',757575.00,0.00,'Payment Id 396988 for invoice:257678, receipt: 1296106 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951998,'','supplier','252',0.00,757575.00,'Payment Id 396988 for invoice:257678, receipt: 1296106 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4951999,'','6.1','3477',12750.00,0.00,'Payment Id 396987 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952000,'','supplier','252',0.00,12750.00,'Payment Id 396987 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952001,'','2','3682',499700.00,0.00,'Payment Id 396986 for invoice:257678, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952002,'','supplier','252',0.00,499700.00,'Payment Id 396986 for invoice:257678, receipt: 471779 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952003,'','6.1','3477',12750.00,0.00,'Payment Id 396985 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952004,'','supplier','252',0.00,12750.00,'Payment Id 396985 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952005,'','2','3682',469590.00,0.00,'Payment Id 396984 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952006,'','supplier','252',0.00,469590.00,'Payment Id 396984 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952007,'','6.1','3477',14600.00,0.00,'Payment Id 396983 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952008,'','supplier','252',0.00,14600.00,'Payment Id 396983 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952009,'','2','3682',1084615.00,0.00,'Payment Id 396982 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952010,'','supplier','252',0.00,1084615.00,'Payment Id 396982 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:02','',''),('5','182',4952011,'','6.1','3477',36600.00,0.00,'Payment Id 396981 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952012,'','supplier','252',0.00,36600.00,'Payment Id 396981 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952013,'','2','3682',324060.00,0.00,'Payment Id 396980 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952014,'','supplier','252',0.00,324060.00,'Payment Id 396980 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952015,'','6.1','3477',73600.00,0.00,'Payment Id 396979 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952016,'','supplier','252',0.00,73600.00,'Payment Id 396979 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952017,'','2','3682',776700.00,0.00,'Payment Id 396978 for invoice:257678, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952018,'','supplier','252',0.00,776700.00,'Payment Id 396978 for invoice:257678, receipt: 58082 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952019,'','6.1','3477',14600.00,0.00,'Payment Id 396977 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952020,'','supplier','252',0.00,14600.00,'Payment Id 396977 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952021,'','2','3682',749000.00,0.00,'Payment Id 396976 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952022,'','supplier','252',0.00,749000.00,'Payment Id 396976 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952023,'','6.1','3477',14600.00,0.00,'Payment Id 396975 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952024,'','supplier','252',0.00,14600.00,'Payment Id 396975 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952025,'','2','3682',588560.00,0.00,'Payment Id 396974 for invoice:257678, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952026,'','supplier','252',0.00,588560.00,'Payment Id 396974 for invoice:257678, receipt: 58079 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952027,'','6.1','3477',12750.00,0.00,'Payment Id 396973 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952028,'','supplier','252',0.00,12750.00,'Payment Id 396973 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952029,'','2','3682',271210.00,0.00,'Payment Id 396972 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952030,'','supplier','252',0.00,271210.00,'Payment Id 396972 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:22','',''),('5','182',4952031,'','6.1','3477',14600.00,0.00,'Payment Id 396971 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952032,'','supplier','252',0.00,14600.00,'Payment Id 396971 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952033,'','2','3682',738355.00,0.00,'Payment Id 396970 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952034,'','supplier','252',0.00,738355.00,'Payment Id 396970 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952035,'','6.1','3477',14600.00,0.00,'Payment Id 396969 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952036,'','supplier','252',0.00,14600.00,'Payment Id 396969 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952037,'','2','3682',799210.00,0.00,'Payment Id 396968 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952038,'','supplier','252',0.00,799210.00,'Payment Id 396968 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952039,'','6.1','3477',292100.00,0.00,'Payment Id 396967 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952040,'','supplier','252',0.00,292100.00,'Payment Id 396967 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952041,'','2','3682',356700.00,0.00,'Payment Id 396966 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952042,'','supplier','252',0.00,356700.00,'Payment Id 396966 for invoice:257678, receipt: 47179 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952043,'','6.1','3477',14600.00,0.00,'Payment Id 396965 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952044,'','supplier','252',0.00,14600.00,'Payment Id 396965 for invoice:257678, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952045,'','2','3682',428290.00,0.00,'Payment Id 396964 for invoice:257678, receipt: 57318 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952046,'','supplier','252',0.00,428290.00,'Payment Id 396964 for invoice:257678, receipt: 57318 by SALBAS OIL & GAS LIMITED','2022-09-04 07:32:42','',''),('5','182',4952047,'','24','3474',0.00,8195500.00,'Purchase Id 89543 for 44,300.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:33:31','',''),('5','182',4952048,'','supplier','252',8195500.00,0.00,'Purchase Id 89543 for 44,300.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:33:31','',''),('5','182',4952049,'','24','3474',0.00,3135750.00,'Purchase Id 89542 for 16,950.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:33:54','',''),('5','182',4952050,'','supplier','252',3135750.00,0.00,'Purchase Id 89542 for 16,950.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:33:54','',''),('5','182',4952051,'','24','3474',0.00,5513000.00,'Purchase Id 89541 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:34:07','',''),('5','182',4952052,'','supplier','252',5513000.00,0.00,'Purchase Id 89541 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:34:07','',''),('5','182',4952053,'','24','3474',0.00,2488250.00,'Purchase Id 89540 for 13,450.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:34:22','',''),('5','182',4952054,'','supplier','252',2488250.00,0.00,'Purchase Id 89540 for 13,450.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-04 07:34:22','',''),('5','182',4952055,'','20','3478',648807.95,0.00,'Sales from shift 257680 on 2022-09-04 11:14:13 ','2022-09-04 11:14:13','',''),('5','182',4952056,'','6.1','3477',0.00,648807.95,'Sales from shift 257680 on 2022-09-04 11:14:13 ','2022-09-04 11:14:13','',''),('5','182',4952057,'','20','3478',813816.85,0.00,'Sales from shift 257681 on 2022-09-04 11:19:33 ','2022-09-04 11:19:33','',''),('5','182',4952058,'','6.1','3477',0.00,813816.85,'Sales from shift 257681 on 2022-09-04 11:19:33 ','2022-09-04 11:19:33','',''),('5','182',4952059,'','20','3478',752953.70,0.00,'Sales from shift 257682 on 2022-09-04 11:22:46 ','2022-09-04 11:22:46','',''),('5','182',4952060,'','6.1','3477',0.00,752953.70,'Sales from shift 257682 on 2022-09-04 11:22:46 ','2022-09-04 11:22:46','',''),('5','182',4952061,'','20','3478',283960.20,0.00,'Sales from shift 257683 on 2022-09-04 11:26:05 ','2022-09-04 11:26:05','',''),('5','182',4952062,'','6.1','3477',0.00,283960.20,'Sales from shift 257683 on 2022-09-04 11:26:05 ','2022-09-04 11:26:05','',''),('5','182',4952063,'','20','3478',0.00,0.00,'Sales from shift 257684 on 2022-09-04 11:40:29 ','2022-09-04 11:40:29','',''),('5','182',4952064,'','6.1','3477',0.00,0.00,'Sales from shift 257684 on 2022-09-04 11:40:29 ','2022-09-04 11:40:29','',''),('5','182',4952065,'','20','3478',603257.25,0.00,'Sales from shift 257685 on 2022-09-04 12:23:21 ','2022-09-04 12:23:21','',''),('5','182',4952066,'','6.1','3477',0.00,603257.25,'Sales from shift 257685 on 2022-09-04 12:23:21 ','2022-09-04 12:23:21','',''),('5','182',4952067,'','20','3478',763609.70,0.00,'Sales from shift 257686 on 2022-09-05 06:53:20 ','2022-09-05 06:53:20','',''),('5','182',4952068,'','6.1','3477',0.00,763609.70,'Sales from shift 257686 on 2022-09-05 06:53:20 ','2022-09-05 06:53:20','',''),('5','182',4952069,'','20','3478',850300.70,0.00,'Sales from shift 257687 on 2022-09-05 11:33:33 ','2022-09-05 11:33:33','',''),('5','182',4952070,'','6.1','3477',0.00,850300.70,'Sales from shift 257687 on 2022-09-05 11:33:33 ','2022-09-05 11:33:33','',''),('5','182',4952071,'','20','3478',360661.20,0.00,'Sales from shift 257688 on 2022-09-05 11:39:20 ','2022-09-05 11:39:20','',''),('5','182',4952072,'','6.1','3477',0.00,360661.20,'Sales from shift 257688 on 2022-09-05 11:39:20 ','2022-09-05 11:39:20','',''),('5','182',4952073,'','20','3478',1099216.35,0.00,'Sales from shift 257689 on 2022-09-05 11:42:17 ','2022-09-05 11:42:17','',''),('5','182',4952074,'','6.1','3477',0.00,1099216.35,'Sales from shift 257689 on 2022-09-05 11:42:17 ','2022-09-05 11:42:17','',''),('5','182',4952075,'','20','3478',482348.65,0.00,'Sales from shift 257690 on 2022-09-05 12:06:27 ','2022-09-05 12:06:27','',''),('5','182',4952076,'','6.1','3477',0.00,482348.65,'Sales from shift 257690 on 2022-09-05 12:06:27 ','2022-09-05 12:06:27','',''),('5','182',4952077,'','20','3478',512453.70,0.00,'Sales from shift 257691 on 2022-09-05 12:11:48 ','2022-09-05 12:11:48','',''),('5','182',4952078,'','6.1','3477',0.00,512453.70,'Sales from shift 257691 on 2022-09-05 12:11:48 ','2022-09-05 12:11:48','',''),('5','182',4952079,'','20','3478',772177.05,0.00,'Sales from shift 257692 on 2022-09-05 12:17:13 ','2022-09-05 12:17:13','',''),('5','182',4952080,'','6.1','3477',0.00,772177.05,'Sales from shift 257692 on 2022-09-05 12:17:13 ','2022-09-05 12:17:13','',''),('5','182',4952081,'','20','3478',563889.25,0.00,'Sales from shift 257693 on 2022-09-05 12:21:19 ','2022-09-05 12:21:19','',''),('5','182',4952082,'','6.1','3477',0.00,563889.25,'Sales from shift 257693 on 2022-09-05 12:21:19 ','2022-09-05 12:21:19','',''),('5','182',4952083,'','20','3478',827107.25,0.00,'Sales from shift 257694 on 2022-09-05 12:23:55 ','2022-09-05 12:23:55','',''),('5','182',4952084,'','6.1','3477',0.00,827107.25,'Sales from shift 257694 on 2022-09-05 12:23:55 ','2022-09-05 12:23:55','',''),('5','182',4952085,'','20','3478',887309.95,0.00,'Sales from shift 257695 on 2022-09-05 12:29:07 ','2022-09-05 12:29:07','',''),('5','182',4952086,'','6.1','3477',0.00,887309.95,'Sales from shift 257695 on 2022-09-05 12:29:07 ','2022-09-05 12:29:07','',''),('5','182',4952087,'','20','3478',619050.70,0.00,'Sales from shift 257696 on 2022-09-05 12:32:27 ','2022-09-05 12:32:27','',''),('5','182',4952088,'','6.1','3477',0.00,619050.70,'Sales from shift 257696 on 2022-09-05 12:32:27 ','2022-09-05 12:32:27','',''),('5','182',4952089,'','20','3478',373577.90,0.00,'Sales from shift 257697 on 2022-09-05 12:35:49 ','2022-09-05 12:35:49','',''),('5','182',4952090,'','6.1','3477',0.00,373577.90,'Sales from shift 257697 on 2022-09-05 12:35:49 ','2022-09-05 12:35:49','',''),('5','182',4952091,'','20','3478',596958.00,0.00,'Sales from shift 257698 on 2022-09-05 12:40:00 ','2022-09-05 12:40:00','',''),('5','182',4952092,'','6.1','3477',0.00,596958.00,'Sales from shift 257698 on 2022-09-05 12:40:00 ','2022-09-05 12:40:00','',''),('5','182',4952093,'','20','3478',659441.75,0.00,'Sales from shift 257699 on 2022-09-05 12:42:43 ','2022-09-05 12:42:43','',''),('5','182',4952094,'','6.1','3477',0.00,659441.75,'Sales from shift 257699 on 2022-09-05 12:42:43 ','2022-09-05 12:42:43','',''),('5','182',4952095,'','20','3478',1013368.95,0.00,'Sales from shift 257700 on 2022-09-05 12:45:10 ','2022-09-05 12:45:10','',''),('5','182',4952096,'','6.1','3477',0.00,1013368.95,'Sales from shift 257700 on 2022-09-05 12:45:10 ','2022-09-05 12:45:10','',''),('5','182',4952097,'','20','3478',649076.20,0.00,'Sales from shift 257701 on 2022-09-05 12:47:38 ','2022-09-05 12:47:38','',''),('5','182',4952098,'','6.1','3477',0.00,649076.20,'Sales from shift 257701 on 2022-09-05 12:47:38 ','2022-09-05 12:47:38','',''),('5','182',4952099,'','20','3478',972182.40,0.00,'Sales from shift 257702 on 2022-09-05 12:50:11 ','2022-09-05 12:50:11','',''),('5','182',4952100,'','6.1','3477',0.00,972182.40,'Sales from shift 257702 on 2022-09-05 12:50:11 ','2022-09-05 12:50:11','',''),('5','182',4952101,'','20','3478',1123342.20,0.00,'Sales from shift 257703 on 2022-09-05 13:08:16 ','2022-09-05 13:08:16','',''),('5','182',4952102,'','6.1','3477',0.00,1123342.20,'Sales from shift 257703 on 2022-09-05 13:08:16 ','2022-09-05 13:08:16','',''),('5','182',4952103,'','20','3478',930326.15,0.00,'Sales from shift 257704 on 2022-09-05 13:20:10 ','2022-09-05 13:20:10','',''),('5','182',4952104,'','6.1','3477',0.00,930326.15,'Sales from shift 257704 on 2022-09-05 13:20:10 ','2022-09-05 13:20:10','',''),('5','182',4952105,'','20','3478',788908.45,0.00,'Sales from shift 257705 on 2022-09-05 13:22:35 ','2022-09-05 13:22:35','',''),('5','182',4952106,'','6.1','3477',0.00,788908.45,'Sales from shift 257705 on 2022-09-05 13:22:35 ','2022-09-05 13:22:35','',''),('5','182',4952107,'','20','3478',1011200.75,0.00,'Sales from shift 257706 on 2022-09-05 13:24:51 ','2022-09-05 13:24:51','',''),('5','182',4952108,'','6.1','3477',0.00,1011200.75,'Sales from shift 257706 on 2022-09-05 13:24:51 ','2022-09-05 13:24:51','',''),('5','182',4952109,'','6.1','3477',14600.00,0.00,'Payment Id 397017 for invoice:257706, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952110,'','supplier','252',0.00,14600.00,'Payment Id 397017 for invoice:257706, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952111,'','2','3682',996600.00,0.00,'Payment Id 397016 for invoice:257706, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952112,'','supplier','252',0.00,996600.00,'Payment Id 397016 for invoice:257706, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952113,'','6.1','3477',28750.00,0.00,'Payment Id 397015 for invoice:257705, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952114,'','supplier','252',0.00,28750.00,'Payment Id 397015 for invoice:257705, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952115,'','2','3682',760160.00,0.00,'Payment Id 397014 for invoice:257705, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952116,'','supplier','252',0.00,760160.00,'Payment Id 397014 for invoice:257705, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952117,'','6.1','3477',12750.00,0.00,'Payment Id 397013 for invoice:257704, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952118,'','supplier','252',0.00,12750.00,'Payment Id 397013 for invoice:257704, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952119,'','2','3682',917575.00,0.00,'Payment Id 397012 for invoice:257704, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952120,'','supplier','252',0.00,917575.00,'Payment Id 397012 for invoice:257704, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-05 16:39:33','',''),('5','182',4952121,'','24','3474',0.00,7307500.00,'Purchase Id 89544 for 39,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-06 09:57:31','',''),('5','182',4952122,'','supplier','252',7307500.00,0.00,'Purchase Id 89544 for 39,500.00 litters of Petrol - PMS from SALBAS OIL & GAS LIMITED','2022-09-06 09:57:31','',''),('5','182',4952123,'','20','3478',553967.70,0.00,'Sales from shift 257707 on 2022-09-06 10:31:02 ','2022-09-06 10:31:02','',''),('5','182',4952124,'','6.1','3477',0.00,553967.70,'Sales from shift 257707 on 2022-09-06 10:31:02 ','2022-09-06 10:31:02','',''),('5','182',4952125,'','20','3478',1063095.10,0.00,'Sales from shift 257708 on 2022-09-07 10:25:24 ','2022-09-07 10:25:24','',''),('5','182',4952126,'','6.1','3477',0.00,1063095.10,'Sales from shift 257708 on 2022-09-07 10:25:24 ','2022-09-07 10:25:24','',''),('5','182',4952127,'','6.1','3477',14600.00,0.00,'Payment Id 397021 for invoice:257708, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952128,'','supplier','252',0.00,14600.00,'Payment Id 397021 for invoice:257708, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952129,'','2','3682',1048495.00,0.00,'Payment Id 397020 for invoice:257708, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952130,'','supplier','252',0.00,1048495.00,'Payment Id 397020 for invoice:257708, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952131,'','6.1','3477',14600.00,0.00,'Payment Id 397019 for invoice:257707, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952132,'','supplier','252',0.00,14600.00,'Payment Id 397019 for invoice:257707, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952133,'','2','3682',539365.00,0.00,'Payment Id 397018 for invoice:257707, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952134,'','supplier','252',0.00,539365.00,'Payment Id 397018 for invoice:257707, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-07 11:20:00','',''),('5','182',4952135,'','20','3478',1045309.20,0.00,'Sales from shift 257709 on 2022-09-08 07:12:31 ','2022-09-08 07:12:31','',''),('5','182',4952136,'','6.1','3477',0.00,1045309.20,'Sales from shift 257709 on 2022-09-08 07:12:31 ','2022-09-08 07:12:31','',''),('5','182',4952137,'','20','3478',848731.90,0.00,'Sales from shift 257710 on 2022-09-09 08:19:25 ','2022-09-09 08:19:25','',''),('5','182',4952138,'','6.1','3477',0.00,848731.90,'Sales from shift 257710 on 2022-09-09 08:19:25 ','2022-09-09 08:19:25','',''),('5','182',4952139,'','6.1','3477',14600.00,0.00,'Payment Id 397023 for invoice:257709, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-09 08:19:46','',''),('5','182',4952140,'','supplier','252',0.00,14600.00,'Payment Id 397023 for invoice:257709, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-09 08:19:46','',''),('5','182',4952141,'','2','3682',1030700.00,0.00,'Payment Id 397022 for invoice:257709, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-09 08:19:46','',''),('5','182',4952142,'','supplier','252',0.00,1030700.00,'Payment Id 397022 for invoice:257709, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-09 08:19:46','',''),('5','182',4952143,'','20','3478',616318.25,0.00,'Sales from shift 257711 on 2022-09-10 09:42:37 ','2022-09-10 09:42:37','',''),('5','182',4952144,'','6.1','3477',0.00,616318.25,'Sales from shift 257711 on 2022-09-10 09:42:37 ','2022-09-10 09:42:37','',''),('5','182',4952145,'','6.1','3477',14600.00,0.00,'Payment Id 397025 for invoice:257710, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-10 09:42:55','',''),('5','182',4952146,'','supplier','252',0.00,14600.00,'Payment Id 397025 for invoice:257710, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-10 09:42:55','',''),('5','182',4952147,'','2','3682',834130.00,0.00,'Payment Id 397024 for invoice:257710, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-10 09:42:55','',''),('5','182',4952148,'','supplier','252',0.00,834130.00,'Payment Id 397024 for invoice:257710, receipt: 1 by SALBAS OIL & GAS LIMITED','2022-09-10 09:42:55','',''),('5','182',4952149,'','20','3478',782501.90,0.00,'Sales from shift 257712 on 2022-09-11 08:57:17 ','2022-09-11 08:57:17','',''),('5','182',4952150,'','6.1','3477',0.00,782501.90,'Sales from shift 257712 on 2022-09-11 08:57:17 ','2022-09-11 08:57:17','',''),('5','182',4952151,'','20','3478',1433431.80,0.00,'Sales from shift 257713 on 2022-09-12 08:57:43 ','2022-09-12 08:57:43','',''),('5','182',4952152,'','6.1','3477',0.00,1433431.80,'Sales from shift 