-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_181
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_181`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_181` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_181`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3535 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3454,4035,'',0,'2','5','181','OOO1480983-TAJ BANK','','2021-07-14 09:07:42',5,0.00,0.00,'','600','2021-07-14 09:07:42','600',0,1),(3489,4012,'',0,'22','5','181','PURCHASES','','2021-07-15 08:42:49',5,0.00,0.00,'','576','2021-07-15 08:42:49','576',0,1),(3490,30178,'',0,'24','5','181','PURCHASES','','2021-07-15 08:43:07',5,0.00,0.00,'','576','2021-07-15 08:43:07','576',0,1),(3491,4025,'',0,'20','5','181','SALES','','2021-07-15 08:43:23',5,0.00,0.00,'','576','2021-07-15 08:43:23','576',0,1),(3492,3027,'',0,'6.1','5','181','CASH','','2021-07-15 08:43:37',5,0.00,0.00,'','576','2021-07-15 08:43:37','576',0,1),(3493,30179,'',0,'24','5','181','SALARIES & WAGES','','2021-07-15 08:43:59',5,0.00,0.00,'','576','2021-07-15 08:43:59','576',0,1),(3532,4050,'',0,'2','5','181','UBA- 1023852445','','2021-07-30 16:00:11',5,0.00,0.00,'','600','2021-07-30 16:00:11','600',0,1),(3533,4051,'',0,'2','5','181','JA\'IZ-0010037957','','2022-03-02 19:14:45',5,0.00,0.00,'','600','2022-03-02 19:14:45','600',0,0),(3534,2000,'',0,'6','5','181','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:20:05',5,0.00,0.00,'','600','2023-02-06 10:20:05','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','181','0000-00-00','2023-02-07 14:05:23',10,'797','','0000-00-00 00:00:00','606','2023-02-08 15:58:32'),(2,'5','181','0000-00-00','2023-02-22 12:20:08',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','181','0000-00-00','2023-02-22 12:23:10',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','181','1','3534','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  6,790ltrs ×35 = 237,650',237650.00,'2023-01-20'),(2,'5','181','1','255','supplier',237650.00,'Pms price increase from 185 to 220 on 20/1/2023  6,790ltrs ×35 = 237,650',0.00,'2023-01-20'),(3,'5','181','2','255','supplier',0.00,'Ago price decrease from 830 to 820 on 20/1/2023 Dipping 25,650 × 10 256,500',256500.00,'2023-02-20'),(4,'5','181','2','3534','6',256500.00,'Ago price decrease from 830 to 820 on 20/1/2023 Dipping 25,650 × 10 256,500',0.00,'2023-02-20'),(5,'5','181','3','255','supplier',0.00,'Pms price increase from 220 to 210 on 19/2/2023  5,300ltrs 10 = 53,000',53000.00,'2023-02-19'),(6,'5','181','3','3534','6',53000.00,'Pms price increase from 220 to 210 on 19/2/2023  5,300ltrs ×10 = 53,000',0.00,'2023-02-19');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17872 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','181',15878,'973',3082.51,3726.00,'2021-07-30','','2021-07-30 10:20:49','600','600',2021,'600','2021-07-30 10:20:49',5),('5','181',16285,'967',1441.54,600.00,'2021-09-05','Pms Dipping was added to enable close our shift ','2021-09-05 07:46:37','642','642',2021,'642','2021-09-05 07:46:37',5),('5','181',16402,'971',89.96,1130.00,'2021-09-11','PMS Dipping added','2021-09-11 22:15:58','642','642',2021,'642','2021-09-11 22:15:58',5),('5','181',16404,'971',1130.00,1130.00,'2021-09-12','PMS add dipping ','2021-09-12 08:23:07','642','642',2021,'642','2021-09-12 08:23:07',5),('5','181',16405,'971',1130.00,1131.00,'2021-09-12','Dipping added','2021-09-12 08:54:20','642','642',2021,'642','2021-09-12 08:54:20',5),('5','181',16770,'970',703.04,2703.00,'2021-10-11','','2021-10-11 12:28:48','600','600',2021,'600','2021-10-11 12:28:48',5),('5','181',16771,'970',394.62,5000.00,'2021-10-11','','2021-10-11 14:22:16','600','600',2021,'600','2021-10-11 14:22:16',5),('5','181',16775,'971',13500.75,4700.00,'2021-10-11','Add dipping','2021-10-11 16:14:33','642','642',2021,'642','2021-10-11 16:14:33',5),('5','181',16778,'970',2569.99,5000.00,'2021-10-12','','2021-10-12 10:05:27','600','600',2021,'600','2021-10-12 10:05:27',5),('5','181',16780,'970',348.45,3500.00,'2021-10-12','Add dipping','2021-10-12 10:50:26','642','642',2021,'642','2021-10-12 10:50:26',5),('5','181',16812,'967',13900.73,1350.00,'2021-10-15','','2021-10-15 14:09:22','600','600',2021,'600','2021-10-15 14:09:22',5),('5','181',16813,'968',4107.59,1050.00,'2021-10-15','','2021-10-15 14:09:46','600','600',2021,'600','2021-10-15 14:09:46',5),('5','181',16814,'969',11963.01,400.00,'2021-10-15','','2021-10-15 14:10:19','600','600',2021,'600','2021-10-15 14:10:19',5),('5','181',16815,'970',1166.45,1700.00,'2021-10-15','','2021-10-15 14:10:44','600','600',2021,'600','2021-10-15 14:10:44',5),('5','181',16816,'971',1390.64,1100.00,'2021-10-15','','2021-10-15 14:11:07','600','600',2021,'600','2021-10-15 14:11:07',5),('5','181',16817,'970',1700.00,1900.00,'2021-10-15','','2021-10-15 14:27:48','600','600',2021,'600','2021-10-15 14:27:48',5),('5','181',16818,'973',33076.16,23500.00,'2021-10-15','','2021-10-15 14:28:23','600','600',2021,'600','2021-10-15 14:28:23',5),('5','181',16828,'973',7535.83,15207.00,'2021-10-16','','2021-10-16 16:27:55','600','600',2021,'600','2021-10-16 16:27:55',5),('5','181',16842,'970',838.45,1930.00,'2021-10-18','Add dipping my','2021-10-18 05:02:44','642','642',2021,'642','2021-10-18 05:02:44',5),('5','181',16843,'970',1930.00,2780.00,'2021-10-18','Add dipping','2021-10-18 05:08:56','642','642',2021,'642','2021-10-18 05:08:56',5),('5','181',16855,'970',19.95,1900.00,'2021-10-18','','2021-10-18 14:35:05','600','600',2021,'600','2021-10-18 14:35:05',5),('5','181',16856,'971',16100.00,11200.00,'2021-10-18','','2021-10-18 14:35:20','600','600',2021,'600','2021-10-18 14:35:20',5),('5','181',16857,'973',8399.66,9400.00,'2021-10-18','','2021-10-18 14:35:35','600','600',2021,'600','2021-10-18 14:35:35',5),('5','181',17314,'967',2383.69,5200.00,'2021-10-31','Add dipping','2021-10-31 05:18:18','642','642',2021,'642','2021-10-31 05:18:18',5),('5','181',17460,'967',4971.36,5700.00,'2021-11-04','Add dipping','2021-11-04 05:05:04','642','642',2021,'642','2021-11-04 05:05:04',5),('5','181',17495,'967',13571.22,1500.00,'2021-11-05','Add dipping','2021-11-05 22:28:28','642','642',2021,'642','2021-11-05 22:28:28',5),('5','181',17496,'973',16564.65,20100.00,'2021-11-05','','2021-11-05 22:50:49','642','642',2021,'642','2021-11-05 22:50:49',5),('5','181',17497,'967',1500.00,18350.00,'2021-11-05','Dipping add','2021-11-05 23:00:21','642','642',2021,'642','2021-11-05 23:00:21',5),('5','181',17513,'967',18350.00,21000.00,'2021-11-06','Add dipping','2021-11-06 16:00:24','642','642',2021,'642','2021-11-06 16:00:24',5),('5','181',17521,'967',2031.81,2600.00,'2021-11-07','Add dipping','2021-11-07 07:43:02','642','642',2021,'642','2021-11-07 07:43:02',5),('5','181',17530,'967',72.90,3700.00,'2021-11-08','add dippnig','2021-11-08 08:23:21','642','642',2021,'642','2021-11-08 08:23:21',5),('5','181',17531,'973',3468.89,5330.00,'2021-11-08','dipping added','2021-11-08 08:28:43','642','642',2021,'642','2021-11-08 08:28:43',5),('5','181',17606,'967',8952.36,21000.00,'2021-11-13','Add dipping','2021-11-13 17:09:58','642','642',2021,'642','2021-11-13 17:09:58',5),('5','181',17611,'967',4420.39,1400.00,'2021-11-14','','2021-11-14 07:44:41','600','600',2021,'600','2021-11-14 07:44:41',5),('5','181',17612,'968',29650.00,1050.00,'2021-11-14','','2021-11-14 07:45:03','600','600',2021,'600','2021-11-14 07:45:03',5),('5','181',17613,'969',400.00,23600.00,'2021-11-14','','2021-11-14 07:45:25','600','600',2021,'600','2021-11-14 07:45:25',5),('5','181',17614,'970',-1379.25,1900.00,'2021-11-14','','2021-11-14 07:45:43','600','600',2021,'600','2021-11-14 07:45:43',5),('5','181',17615,'971',3834.47,7100.00,'2021-11-14','','2021-11-14 07:46:11','600','600',2021,'600','2021-11-14 07:46:11',5),('5','181',17620,'967',1400.00,9300.00,'2021-11-14','Add dipping','2021-11-14 20:45:47','642','642',2021,'642','2021-11-14 20:45:47',5),('5','181',17621,'973',940.92,6978.00,'2021-11-14','Add dipping','2021-11-14 20:47:18','642','642',2021,'642','2021-11-14 20:47:18',5),('5','181',17663,'968',1050.00,6008.00,'2021-11-16','add dpping','2021-11-16 17:53:50','642','642',2021,'642','2021-11-16 17:53:50',5),('5','181',17670,'970',1900.00,4000.00,'2021-11-17','Add dipping','2021-11-17 10:03:55','642','642',2021,'642','2021-11-17 10:03:55',5),('5','181',17671,'970',709.68,1000.00,'2021-11-17','Add dipping','2021-11-17 10:15:05','642','642',2021,'642','2021-11-17 10:15:05',5),('5','181',17672,'970',1000.00,15000.00,'2021-11-17','Add dipping','2021-11-17 10:23:39','642','642',2021,'642','2021-11-17 10:23:39',5),('5','181',17673,'970',3215.28,3500.00,'2021-11-17','Add dipping','2021-11-17 10:38:34','642','642',2021,'642','2021-11-17 10:38:34',5),('5','181',17674,'970',156.36,3500.00,'2021-11-17','Add dipping','2021-11-17 11:08:24','642','642',2021,'642','2021-11-17 11:08:24',5),('5','181',17684,'970',257.26,2650.00,'2021-11-18','Add dipping','2021-11-18 09:12:14','642','642',2021,'642','2021-11-18 09:12:14',5),('5','181',17707,'970',29.05,2234.00,'2021-11-19','add dipping','2021-11-19 09:59:42','642','642',2021,'642','2021-11-19 09:59:42',5),('5','181',17757,'973',6443.64,500.00,'2021-11-24','','2021-11-24 14:50:10','600','600',2021,'600','2021-11-24 14:50:10',5),('5','181',17758,'971',1176.05,1900.00,'2022-02-05','Add DIPPING ','2022-02-05 09:44:49','642','642',2022,'642','2022-02-05 09:44:49',5),('5','181',17759,'973',6189.01,4576.00,'2022-02-09','add DIPPING ','2022-02-09 15:03:24','642','642',2022,'642','2022-02-09 15:03:24',5),('5','181',17760,'973',4576.00,11000.00,'2022-02-09','','2022-02-09 16:54:13','600','600',2022,'600','2022-02-09 16:54:13',5),('5','181',17761,'973',15803.52,8000.00,'2022-02-12','','2022-02-12 21:51:24','600','600',2022,'600','2022-02-12 21:51:24',5),('5','181',17762,'973',3869.32,4393.00,'2022-02-18','Ago','2022-02-18 07:11:26','642','642',2022,'642','2022-02-18 07:11:26',5),('5','181',17763,'973',4393.00,4400.00,'2022-02-18','Ago','2022-02-18 07:21:43','642','642',2022,'642','2022-02-18 07:21:43',5),('5','181',17764,'973',3190.57,50000.00,'2022-02-23','','2022-02-23 18:26:58','600','600',2022,'600','2022-02-23 18:26:58',5),('5','181',17765,'973',50000.00,7000.00,'2022-02-23','','2022-02-23 18:58:21','600','600',2022,'600','2022-02-23 18:58:21',5),('5','181',17766,'968',241925.80,15000.00,'2022-03-15','','2022-03-15 21:09:30','600','600',2022,'600','2022-03-15 21:09:30',5),('5','181',17767,'967',7711.95,8355.00,'2022-03-23','','2022-03-23 10:12:47','642','642',2022,'642','2022-03-23 10:12:47',5),('5','181',17768,'971',4880.41,11000.00,'2022-04-09','','2022-04-09 16:09:59','600','600',2022,'600','2022-04-09 16:09:59',5),('5','181',17769,'971',1748.93,8000.00,'2022-04-16','','2022-04-16 13:14:06','600','600',2022,'600','2022-04-16 13:14:06',5),('5','181',17770,'971',608.30,7000.00,'2022-04-16','','2022-04-16 13:35:19','600','600',2022,'600','2022-04-16 13:35:19',5),('5','181',17771,'973',2099.37,12000.00,'2022-04-18','','2022-04-18 13:32:00','600','600',2022,'600','2022-04-18 13:32:00',5),('5','181',17772,'973',8281.73,9531.00,'2022-04-07','','2022-04-18 15:42:01','642','642',2022,'642','2022-04-18 15:42:01',5),('5','181',17773,'973',9531.00,9545.00,'2022-04-07','','2022-04-18 15:45:24','642','642',2022,'642','2022-04-18 15:45:24',5),('5','181',17774,'973',13.11,8600.00,'2022-04-08','','2022-04-18 15:54:06','642','642',2022,'642','2022-04-18 15:54:06',5),('5','181',17775,'973',9.39,6812.00,'2022-04-09','','2022-04-18 16:00:49','642','642',2022,'642','2022-04-18 16:00:49',5),('5','181',17776,'968',3415.13,4112.00,'2022-04-10','','2022-04-18 16:46:04','642','642',2022,'642','2022-04-18 16:46:04',5),('5','181',17777,'968',1.50,5996.00,'2022-04-11','','2022-04-18 17:22:15','642','642',2022,'642','2022-04-18 17:22:15',5),('5','181',17778,'968',0.42,5657.00,'2022-04-12','','2022-04-18 17:33:49','642','642',2022,'642','2022-04-18 17:33:49',5),('5','181',17779,'973',13820.83,14099.00,'2022-04-12','','2022-04-18 17:39:58','642','642',2022,'642','2022-04-18 17:39:58',5),('5','181',17780,'968',909.13,5425.00,'2022-04-14','','2022-04-20 17:15:00','642','642',2022,'642','2022-04-20 17:15:00',5),('5','181',17781,'968',5425.00,5000.00,'2022-04-23','','2022-04-23 15:11:25','600','600',2022,'600','2022-04-23 15:11:25',5),('5','181',17782,'968',5000.00,8000.00,'2022-04-23','','2022-04-23 15:15:09','600','600',2022,'600','2022-04-23 15:15:09',5),('5','181',17783,'973',5095.98,6224.00,'2022-04-17','','2022-04-23 16:00:32','642','642',2022,'642','2022-04-23 16:00:32',5),('5','181',17784,'973',6224.00,6224.00,'2022-04-17','','2022-04-23 16:04:20','642','642',2022,'642','2022-04-23 16:04:20',5),('5','181',17785,'973',6224.00,6224.00,'2022-04-17','','2022-04-23 18:05:43','642','642',2022,'642','2022-04-23 18:05:43',5),('5','181',17786,'973',6224.00,6228.00,'2022-04-17','','2022-04-23 18:10:57','642','642',2022,'642','2022-04-23 18:10:57',5),('5','181',17787,'973',3.77,7539.00,'2022-04-18','','2022-04-23 18:16:47','642','642',2022,'642','2022-04-23 18:16:47',5),('5','181',17788,'971',2715.81,4200.00,'2022-04-26','Pms ','2022-04-26 00:06:13','642','642',2022,'642','2022-04-26 00:06:13',5),('5','181',17789,'971',12.42,4289.00,'2022-04-26','','2022-04-26 22:29:13','642','642',2022,'642','2022-04-26 22:29:13',5),('5','181',17790,'971',4289.00,5355.00,'2022-04-26','Pms','2022-04-27 11:49:29','642','642',2022,'642','2022-04-27 11:49:29',5),('5','181',17791,'973',5272.09,8400.00,'2022-04-28','','2022-04-29 13:29:30','642','642',2022,'642','2022-04-29 13:29:30',5),('5','181',17792,'973',7465.22,8333.00,'2022-05-04','','2022-05-18 11:27:27','642','642',2022,'642','2022-05-18 11:27:27',5),('5','181',17793,'973',8333.00,8335.00,'2022-05-04','','2022-05-18 11:35:22','642','642',2022,'642','2022-05-18 11:35:22',5),('5','181',17794,'973',2121.90,5760.00,'2022-05-08','','2022-05-18 13:21:03','642','642',2022,'642','2022-05-18 13:21:03',5),('5','181',17795,'973',1597.01,2905.00,'2022-05-19','','2022-05-20 14:23:30','642','642',2022,'642','2022-05-20 14:23:30',5),('5','181',17796,'971',1510.97,6719.00,'2022-05-19','','2022-05-20 14:24:24','642','642',2022,'642','2022-05-20 14:24:24',5),('5','181',17797,'971',2.95,5400.00,'2022-05-21','','2022-05-21 12:43:58','642','642',2022,'642','2022-05-21 12:43:58',5),('5','181',17798,'973',3.99,2720.00,'2022-05-21','','2022-05-21 12:44:35','642','642',2022,'642','2022-05-21 12:44:35',5),('5','181',17799,'973',4.19,2399.00,'2022-05-22','','2022-05-22 13:10:09','642','642',2022,'642','2022-05-22 13:10:09',5),('5','181',17800,'971',71.44,5959.00,'2022-05-22','','2022-05-22 13:13:29','642','642',2022,'642','2022-05-22 13:13:29',5),('5','181',17801,'971',4.45,5214.00,'2022-05-22','','2022-05-23 10:21:55','642','642',2022,'642','2022-05-23 10:21:55',5),('5','181',17802,'973',4.00,45.00,'2022-05-22','','2022-05-23 10:22:35','642','642',2022,'642','2022-05-23 10:22:35',5),('5','181',17803,'973',5.00,70.00,'2022-05-24','','2022-05-24 12:06:54','642','642',2022,'642','2022-05-24 12:06:54',5),('5','181',17804,'971',1169.68,2200.00,'2022-05-24','','2022-05-24 12:16:49','642','642',2022,'642','2022-05-24 12:16:49',5),('5','181',17805,'973',10.00,200.00,'2022-05-25','','2022-05-25 13:54:58','642','642',2022,'642','2022-05-25 13:54:58',5),('5','181',17806,'967',26320.70,31300.00,'2022-05-26','','2022-05-26 17:07:13','446','446',2022,'446','2022-05-26 17:07:13',5),('5','181',17807,'973',49.14,1900.00,'2022-05-26','','2022-05-26 17:07:41','446','446',2022,'446','2022-05-26 17:07:41',5),('5','181',17808,'971',283.24,200.00,'2022-07-18','','2022-07-18 08:27:22','642','642',2022,'642','2022-07-18 08:27:22',5),('5','181',17809,'971',200.00,2895.00,'2022-07-18','','2022-07-18 08:31:23','642','642',2022,'642','2022-07-18 08:31:23',5),('5','181',17810,'971',2895.00,3000.00,'2022-07-18','','2022-07-18 09:17:13','642','642',2022,'642','2022-07-18 09:17:13',5),('5','181',17811,'968',1273.24,1345.00,'2022-07-18','','2022-07-18 10:10:49','642','642',2022,'642','2022-07-18 10:10:49',5),('5','181',17812,'968',0.14,3000.00,'2022-07-18','','2022-07-18 23:19:44','642','642',2022,'642','2022-07-18 23:19:44',5),('5','181',17813,'968',102.45,3000.00,'2022-07-20','Add dipping','2022-07-20 07:11:15','642','642',2022,'642','2022-07-20 07:11:15',5),('5','181',17814,'968',3000.00,5000.00,'2022-07-20','','2022-07-20 07:14:52','642','642',2022,'642','2022-07-20 07:14:52',5),('5','181',17815,'968',327.70,3000.00,'2022-07-21','','2022-07-21 06:29:09','642','642',2022,'642','2022-07-21 06:29:09',5),('5','181',17816,'968',135.58,2700.00,'2022-07-21','','2022-07-21 21:35:07','642','642',2022,'642','2022-07-21 21:35:07',5),('5','181',17817,'968',57.95,2600.00,'2022-07-22','','2022-07-22 20:58:34','642','642',2022,'642','2022-07-22 20:58:34',5),('5','181',17818,'968',25.07,3100.00,'2022-07-23','','2022-07-23 21:24:45','642','642',2022,'642','2022-07-23 21:24:45',5),('5','181',17819,'968',47.81,2900.00,'2022-07-24','','2022-07-24 22:04:01','642','642',2022,'642','2022-07-24 22:04:01',5),('5','181',17820,'968',80.04,4000.00,'2022-07-25','','2022-07-25 21:09:28','642','642',2022,'642','2022-07-25 21:09:28',5),('5','181',17821,'968',43.00,6500.00,'2022-07-26','','2022-07-26 20:34:23','642','642',2022,'642','2022-07-26 20:34:23',5),('5','181',17822,'971',34784.65,1500.00,'2022-07-26','','2022-07-26 20:40:08','642','642',2022,'642','2022-07-26 20:40:08',5),('5','181',17823,'967',9288.80,1500.00,'2022-07-26','','2022-07-26 20:40:41','642','642',2022,'642','2022-07-26 20:40:41',5),('5','181',17824,'967',1500.00,1000.00,'2022-07-26','','2022-07-26 20:45:32','642','642',2022,'642','2022-07-26 20:45:32',5),('5','181',17825,'967',1000.00,3000.00,'2022-07-26','','2022-07-26 20:46:20','642','642',2022,'642','2022-07-26 20:46:20',5),('5','181',17826,'967',3000.00,2000.00,'2022-07-26','','2022-07-26 20:51:51','642','642',2022,'642','2022-07-26 20:51:51',5),('5','181',17827,'968',6500.00,6600.00,'2022-07-26','','2022-07-26 20:53:53','642','642',2022,'642','2022-07-26 20:53:53',5),('5','181',17828,'967',143.26,2200.00,'2022-07-27','','2022-07-27 21:18:58','642','642',2022,'642','2022-07-27 21:18:58',5),('5','181',17829,'967',2200.00,2200.00,'2022-07-27','','2022-07-27 21:20:12','642','642',2022,'642','2022-07-27 21:20:12',5),('5','181',17830,'968',1.52,1700.00,'2022-07-27','','2022-07-27 21:22:27','642','642',2022,'642','2022-07-27 21:22:27',5),('5','181',17831,'971',213.04,2000.00,'2022-07-27','','2022-07-27 21:23:56','642','642',2022,'642','2022-07-27 21:23:56',5),('5','181',17832,'967',54.42,3500.00,'2022-07-28','','2022-07-28 21:07:14','642','642',2022,'642','2022-07-28 21:07:14',5),('5','181',17833,'971',44.85,3500.00,'2022-07-28','','2022-07-28 21:08:14','642','642',2022,'642','2022-07-28 21:08:14',5),('5','181',17834,'971',3500.00,1500.00,'2022-07-28','','2022-07-28 21:16:18','642','642',2022,'642','2022-07-28 21:16:18',5),('5','181',17835,'971',1500.00,5000.00,'2022-07-28','','2022-07-28 21:17:23','642','642',2022,'642','2022-07-28 21:17:23',5),('5','181',17836,'971',121.52,6900.00,'2022-07-29','','2022-07-29 22:07:40','642','642',2022,'642','2022-07-29 22:07:40',5),('5','181',17837,'971',95.71,6500.00,'2022-07-30','','2022-07-30 21:59:08','642','642',2022,'642','2022-07-30 21:59:08',5),('5','181',17838,'971',57.92,5500.00,'2022-07-31','','2022-07-31 21:41:06','642','642',2022,'642','2022-07-31 21:41:06',5),('5','181',17839,'971',56.87,5500.00,'2022-08-02','','2022-08-02 07:23:00','642','642',2022,'642','2022-08-02 07:23:00',5),('5','181',17840,'967',1937.77,40000.00,'2022-09-05','Add dipping','2022-09-05 15:32:27','642','642',2022,'642','2022-09-05 15:32:27',5),('5','181',17841,'967',10319.41,25000.00,'2022-09-05','','2022-09-05 16:50:48','642','642',2022,'642','2022-09-05 16:50:48',5),('5','181',17842,'973',1392.41,50000.00,'2022-09-05','','2022-09-05 16:55:44','642','642',2022,'642','2022-09-05 16:55:44',5),('5','181',17843,'968',820.96,200.00,'2022-09-16','Add dipping','2022-09-16 08:28:52','642','642',2022,'642','2022-09-16 08:28:52',5),('5','181',17844,'968',200.00,200.00,'2022-09-16','Add dipping','2022-09-16 08:28:53','642','642',2022,'642','2022-09-16 08:28:53',5),('5','181',17845,'968',200.00,200.00,'2022-09-16','Add dipping','2022-09-16 08:28:53','642','642',2022,'642','2022-09-16 08:28:53',5),('5','181',17846,'968',200.00,3000.00,'2022-09-16','','2022-09-16 08:32:09','642','642',2022,'642','2022-09-16 08:32:09',5),('5','181',17847,'968',5356.74,200.00,'2022-10-08','Add 200 only','2022-10-08 07:00:39','642','642',2022,'642','2022-10-08 07:00:39',5),('5','181',17848,'968',200.00,5500.00,'2022-10-08','','2022-10-08 07:11:45','642','642',2022,'642','2022-10-08 07:11:45',5),('5','181',17849,'968',5500.00,200.00,'2022-10-08','','2022-10-08 07:18:10','642','642',2022,'642','2022-10-08 07:18:10',5),('5','181',17850,'968',200.00,5600.00,'2022-10-08','','2022-10-08 07:19:34','642','642',2022,'642','2022-10-08 07:19:34',5),('5','181',17851,'968',89.32,11000.00,'2022-10-09','','2022-10-09 11:31:10','642','642',2022,'642','2022-10-09 11:31:10',5),('5','181',17852,'968',680.58,15500.00,'2022-10-10','','2022-10-10 00:11:18','642','642',2022,'642','2022-10-10 00:11:18',5),('5','181',17853,'968',15500.00,15500.00,'2022-10-10','','2022-10-10 00:11:19','642','642',2022,'642','2022-10-10 00:11:19',5),('5','181',17854,'968',115.90,1200.00,'2022-10-10','','2022-10-10 23:36:23','642','642',2022,'642','2022-10-10 23:36:23',5),('5','181',17855,'968',89.37,1700.00,'2022-10-27','Add 1700 only','2022-10-27 06:47:45','642','642',2022,'642','2022-10-27 06:47:45',5),('5','181',17856,'968',747.61,2210.00,'2022-10-29','Add dipping','2022-10-29 23:40:41','642','642',2022,'642','2022-10-29 23:40:41',5),('5','181',17857,'967',13535.68,1100.00,'2022-11-04','Add dipping','2022-11-04 19:43:27','642','642',2022,'642','2022-11-04 19:43:27',5),('5','181',17858,'967',1100.00,1100.00,'2022-11-04','Add dipping','2022-11-04 19:43:30','642','642',2022,'642','2022-11-04 19:43:30',5),('5','181',17859,'967',29259.29,14000.00,'2022-11-05','Add dipping','2022-11-05 13:42:04','642','642',2022,'642','2022-11-05 13:42:04',5),('5','181',17860,'968',12396.27,14000.00,'2022-11-05','Add dipping','2022-11-05 13:44:04','642','642',2022,'642','2022-11-05 13:44:04',5),('5','181',17861,'967',149.04,2800.00,'2022-11-06','Add dipping','2022-11-06 07:58:47','642','642',2022,'642','2022-11-06 07:58:47',5),('5','181',17862,'968',105.27,3700.00,'2022-11-06','','2022-11-06 08:00:24','642','642',2022,'642','2022-11-06 08:00:24',5),('5','181',17863,'967',64.74,3710.00,'2022-11-07','Add dipping','2022-11-07 09:00:15','642','642',2022,'642','2022-11-07 09:00:15',5),('5','181',17864,'968',80.11,664.00,'2022-11-07','Add dipping','2022-11-07 09:00:47','642','642',2022,'642','2022-11-07 09:00:47',5),('5','181',17865,'968',1.91,1066.00,'2022-11-08','Add dipping','2022-11-08 06:25:48','642','642',2022,'642','2022-11-08 06:25:48',5),('5','181',17866,'968',1066.00,1100.00,'2022-11-08','Add dipping','2022-11-08 06:33:03','642','642',2022,'642','2022-11-08 06:33:03',5),('5','181',17867,'968',2244.34,2600.00,'2022-12-02','Add dipping','2022-12-02 22:21:54','642','642',2022,'642','2022-12-02 22:21:54',5),('5','181',17868,'968',2600.00,2620.00,'2022-12-02','Add dipping','2022-12-02 22:23:47','642','642',2022,'642','2022-12-02 22:23:47',5),('5','181',17869,'973',8217.53,13856.00,'2023-02-11','','2023-02-11 10:33:31','446','446',2023,'446','2023-02-11 10:33:31',5),('5','181',17870,'973',13856.00,13896.00,'2023-02-11','','2023-02-11 10:41:15','446','446',2023,'446','2023-02-11 10:41:15',5),('5','181',17871,'968',3029.86,3500.00,'2023-03-14','','2023-03-14 10:14:40','600','600',2023,'600','2023-03-14 10:14:40',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2912 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','181','967',2863,'5','PMS PUMP 1',995792.90,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:32:46','446'),('5','181','967',2864,'5','PMS PUMP 2',674543.66,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 13:11:03','600'),('5','181','967',2865,'5','PMS PUMP 3',88088.85,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:33:55','446'),('5','181','967',2866,'5','PMS PUMP 4',13434.85,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:34:33','446'),('5','181','968',2867,'5','PMS PUMP 5',467511.55,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:35:34','446'),('5','181','968',2868,'5','PMS PUMP 6',607447.51,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:36:32','446'),('5','181','969',2869,'5','PMS PUMP 7',0.00,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 14:03:11','600'),('5','181','969',2870,'5','PMS PUMP 8',156.66,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 14:12:10','600'),('5','181','971',2871,'5','PMS PUMP 9',589517.81,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:37:43','446'),('5','181','971',2872,'5','PMS PUMP 10',313919.60,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:38:39','446'),('5','181','970',2873,'5','PMS PUMP 11',33770.19,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 14:08:26','600'),('5','181','969',2874,'5','PMS PUMP 12',78628.47,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 14:09:53','600'),('5','181','972',2875,'5','PMS PUMP 21',0.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','181','972',2876,'5','PMS PUMP 23',0.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','181','973',2877,'5','AGO PUMP',2021724.73,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:39:53','446'),('5','181','974',2879,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','181','973',2910,'5','AGO PUMP 2',1317990.12,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-18 09:40:28','446'),('5','181','973',2911,'5','AGO TANK',0.00,'1&2',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (264,'5','181','2874','969','tank','2021-09-13 10:22:06',0,'600'),(289,'5','181','2871','971','tank','2021-10-18 14:31:52',0,'600'),(290,'5','181','2872','971','tank','2021-10-18 14:32:26',0,'600'),(339,'5','181','2873','970','Nil','2021-11-13 16:32:52',0,'600'),(340,'5','181','2874','970','Nil','2021-11-13 16:33:59',0,'600'),(342,'5','181','2874','969','Nil','2021-11-19 15:42:18',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','181',213310,'DAILY','2021-07-12','2021-07-12 00:00:00',NULL,'642',1068083.95,1068083.95,'642','2021-07-29 14:06:25','606','2021-07-29 14:07:18',10,0),('5','181',213773,'Daily','2021-07-13','2021-07-13 00:00:00',NULL,'642',0.00,0.00,'642','2021-07-29 14:10:44','606','2021-07-29 14:11:27',10,0),('5','181',213775,'Daily','2021-07-14','2021-07-14 00:00:00',NULL,'642',0.00,0.00,'642','2021-07-29 14:14:36','606','2021-07-29 14:15:56',10,0),('5','181',213777,'Daily','2021-07-15','2021-07-15 00:00:00',NULL,'642',466787.55,466787.55,'642','2021-07-29 14:27:32','606','2021-07-29 14:28:53',10,0),('5','181',213780,'Daily','2021-07-16','2021-07-16 00:00:00',NULL,'642',799827.85,799827.85,'642','2021-07-29 14:35:24','606','2021-07-29 14:36:40',10,0),('5','181',213782,'Daily','2021-07-17','2021-07-17 00:00:00',NULL,'642',799842.80,799842.80,'642','2021-07-29 14:58:54','606','2021-07-29 14:59:50',10,0),('5','181',213795,'Daily ','2021-07-18','2021-07-18 00:00:00',NULL,'642',902692.10,902692.10,'642','2021-07-29 15:25:11','606','2021-07-29 15:26:55',10,0),('5','181',213798,'Daily','2021-07-19','2021-07-19 00:00:00',NULL,'642',810608.50,810608.50,'642','2021-07-29 15:30:41','606','2021-07-29 15:32:21',10,0),('5','181',213799,'Daily ','2021-07-20','2021-07-20 00:00:00',NULL,'642',553700.15,553700.15,'642','2021-07-29 15:39:19','606','2021-07-29 15:42:22',10,0),('5','181',213803,'Daily','2021-07-21','2021-07-21 00:00:00',NULL,'642',523578.35,523578.35,'642','2021-07-29 15:55:22','606','2021-07-29 15:57:05',10,0),('5','181',213808,'Daily','2021-07-22','2021-07-22 00:00:00',NULL,'642',783550.35,783550.35,'642','2021-07-29 16:05:00','606','2021-07-29 16:05:57',10,0),('5','181',213810,'Daily','2021-07-23','2021-07-23 00:00:00',NULL,'642',1053038.95,1053038.95,'642','2021-07-29 16:09:16','606','2021-07-29 16:10:54',10,0),('5','181',213812,'Daily','2021-07-24','2021-07-24 00:00:00',NULL,'642',1118648.35,1118648.35,'642','2021-07-29 16:14:19','606','2021-07-29 16:15:07',10,0),('5','181',213814,'Daily','2021-07-25','2021-07-25 00:00:00',NULL,'642',1657349.65,1657349.65,'642','2021-07-29 16:21:12','606','2021-07-29 16:22:06',10,0),('5','181',213817,'Daily','2021-07-26','2021-07-26 00:00:00',NULL,'642',1529535.85,1529535.85,'642','2021-07-30 10:28:54','606','2021-07-30 10:39:34',10,0),('5','181',213969,'Daily ','2021-07-27','2021-07-27 00:00:00',NULL,'642',652165.80,652165.80,'642','2021-07-30 10:44:21','606','2021-07-30 10:48:43',10,0),('5','181',213975,'Daily','2021-07-28','2021-07-28 00:00:00',NULL,'642',758872.95,758872.95,'642','2021-07-30 10:53:37','606','2021-07-30 10:56:30',10,0),('5','181',213976,'Daily','2021-07-29','2021-07-29 00:00:00',NULL,'642',760448.15,760448.15,'642','2021-07-30 11:00:11','606','2021-07-30 11:03:23',10,0),('5','181',214051,'Daily','2021-07-30','2021-07-30 00:00:00',NULL,'642',928662.80,928662.80,'642','2021-08-03 11:15:49','606','2021-08-03 11:16:49',10,0),('5','181',214874,'Daily','2021-07-31','2021-07-31 00:00:00',NULL,'642',1358348.10,1358348.10,'642','2021-08-03 11:21:41','606','2021-08-03 11:24:08',10,0),('5','181',214876,'Daily','2021-08-01','2021-08-01 00:00:00',NULL,'642',793001.95,793001.95,'642','2021-08-03 13:10:55','606','2021-08-03 13:19:08',10,0),('5','181',214936,'Daily','2021-08-02','2021-08-02 00:00:00',NULL,'642',1303543.60,1303543.60,'642','2021-08-03 14:50:26','606','2021-08-03 14:53:21',10,0),('5','181',214941,'Daily','2021-08-03','2021-08-03 00:00:00',NULL,'642',883032.15,883032.15,'642','2021-08-04 08:19:39','606','2021-08-04 08:24:02',10,0),('5','181',215047,'Daily','2021-08-04','2021-08-04 00:00:00',NULL,'642',1653272.40,1653272.40,'642','2021-08-05 09:30:00','606','2021-08-05 09:32:43',10,0),('5','181',215300,'Daily','2021-08-05','2021-08-05 00:00:00',NULL,'642',1644697.80,1644697.80,'642','2021-08-06 09:35:07','606','2021-08-06 21:00:07',10,0),('5','181',215655,'Daily','2021-08-06','2021-08-06 00:00:00',NULL,'642',1564936.85,1564936.85,'642','2021-08-06 21:57:20','606','2021-08-07 05:39:51',10,0),('5','181',215874,'Daily','2021-08-07','2021-08-07 00:00:00',NULL,'642',1250702.35,1250702.35,'642','2021-08-07 21:31:03','606','2021-08-08 03:37:15',10,0),('5','181',215982,'Daily','2021-08-08','2021-08-08 00:00:00',NULL,'642',907116.30,907116.30,'642','2021-08-09 10:22:06','606','2021-08-09 11:38:30',10,0),('5','181',216212,'Daily','2021-08-09','2021-08-09 00:00:00',NULL,'642',1455988.95,1455988.95,'642','2021-08-09 21:43:37','606','2021-08-10 05:39:13',10,0),('5','181',216376,'Daily','2021-08-10','2021-08-10 00:00:00',NULL,'642',1556499.90,1556499.90,'642','2021-08-11 05:16:33','606','2021-08-11 05:51:19',10,0),('5','181',216571,'Daily','2021-08-11','2021-08-11 00:00:00',NULL,'642',1175642.20,1175642.20,'642','2021-08-11 20:39:58','606','2021-08-12 05:37:08',10,0),('5','181',216872,'Daily','2021-08-12','2021-08-12 00:00:00',NULL,'642',1466802.05,1466802.05,'642','2021-08-13 09:02:13','606','2021-08-13 09:08:47',10,0),('5','181',217253,'Daily','2021-08-13','2021-08-13 00:00:00',NULL,'642',984364.80,984364.80,'642','2021-08-14 08:11:18','606','2021-08-14 11:07:12',10,0),('5','181',217420,'Daily','2021-08-14','2021-08-14 00:00:00',NULL,'642',1511942.90,1511942.90,'642','2021-08-14 20:44:32','606','2021-08-15 18:55:48',10,0),('5','181',217692,'Daily','2021-08-15','2021-08-15 00:00:00',NULL,'642',646677.25,646677.25,'642','2021-08-15 22:38:29','606','2021-08-16 06:12:17',10,0),('5','181',217968,'Daily','2021-08-16','2021-08-16 00:00:00',NULL,'642',1210653.10,1210653.10,'642','2021-08-17 05:39:00','606','2021-08-17 05:43:27',10,0),('5','181',218198,'Daily','2021-08-17','2021-08-17 00:00:00',NULL,'642',1529750.15,1529750.15,'642','2021-08-17 22:26:49','606','2021-08-18 00:55:31',10,0),('5','181',218280,'Daily','2021-08-18','2021-08-18 00:00:00',NULL,'642',892589.50,892589.50,'642','2021-08-18 21:35:11','606','2021-08-19 05:50:24',10,0),('5','181',218551,'Daily','2021-08-19','2021-08-19 00:00:00',NULL,'642',1517355.90,1517355.90,'642','2021-08-19 20:28:05','606','2021-08-20 05:50:06',10,0),('5','181',218731,'Daily','2021-08-20','2021-08-20 00:00:00',NULL,'642',1181416.65,1181416.65,'642','2021-08-20 20:23:09','606','2021-08-21 06:20:06',10,0),('5','181',219068,'Daily','2021-08-21','2021-08-21 00:00:00',NULL,'642',1565804.25,1565804.25,'642','2021-08-22 11:41:16','606','2021-08-22 13:13:20',10,0),('5','181',219308,'Daily','2021-08-22','2021-08-22 00:00:00',NULL,'642',938526.60,938526.60,'642','2021-08-23 07:45:27','606','2021-08-23 08:21:24',10,0),('5','181',219462,'Daily','2021-08-23','2021-08-23 00:00:00',NULL,'642',1885005.40,1885005.40,'642','2021-08-24 08:06:49','606','2021-08-24 08:31:02',10,0),('5','181',219647,'Daily','2021-08-24','2021-08-24 00:00:00',NULL,'642',1050423.35,1050423.35,'642','2021-08-25 08:56:17','606','2021-08-25 09:21:02',10,0),('5','181',219878,'Daily','2021-08-25','2021-08-25 00:00:00',NULL,'642',1938763.75,1938763.75,'642','2021-08-25 20:30:43','606','2021-08-26 07:01:20',10,0),('5','181',220136,'Daily','2021-08-26','2021-08-26 00:00:00',NULL,'642',1789892.70,1789892.70,'642','2021-08-27 09:18:18','606','2021-08-27 09:36:38',10,0),('5','181',220363,'Daily','2021-08-27','2021-08-27 00:00:00',NULL,'642',1566055.10,1566055.10,'642','2021-08-27 20:53:03','606','2021-08-28 05:23:41',10,0),('5','181',220549,'Daily','2021-08-28','2021-08-28 00:00:00',NULL,'642',862725.75,862725.75,'642','2021-08-28 20:58:22','606','2021-08-29 05:55:51',10,0),('5','181',220743,'Daily','2021-08-29','2021-08-29 00:00:00',NULL,'642',1273973.80,1273973.80,'642','2021-08-30 08:53:52','606','2021-08-30 08:59:18',10,0),('5','181',220973,'Daily ','2021-08-30','2021-08-30 00:00:00',NULL,'642',2023080.10,2023080.10,'642','2021-08-30 20:46:26','606','2021-08-31 06:01:25',10,0),('5','181',221221,'Daily','2021-08-31','2021-08-31 00:00:00',NULL,'642',761814.90,761814.90,'642','2021-08-31 20:51:16','606','2021-09-01 05:58:22',10,0),('5','181',221467,'Daily','2021-09-01','2021-09-01 00:00:00',NULL,'642',1959437.65,1959437.65,'642','2021-09-01 19:58:14','606','2021-09-02 05:46:36',10,0),('5','181',221681,'Daily','2021-09-02','2021-09-02 00:00:00',NULL,'642',837032.95,837032.95,'642','2021-09-02 20:32:14','606','2021-09-03 05:44:28',10,0),('5','181',221955,'Daily','2021-09-03','2021-09-03 00:00:00',NULL,'642',1279402.95,1279402.95,'642','2021-09-03 21:02:27','606','2021-09-04 06:05:07',10,0),('5','181',222096,'Daily','2021-09-04','2021-09-04 00:00:00',NULL,'642',1924843.20,1924843.20,'642','2021-09-05 18:23:51','606','2021-09-05 18:44:58',10,0),('5','181',222457,'Daily','2021-09-05','2021-09-05 00:00:00',NULL,'642',982427.75,982427.75,'642','2021-09-06 08:47:19','606','2021-09-06 09:01:26',10,0),('5','181',222556,'Daily ','2021-09-06','2021-09-06 00:00:00',NULL,'642',1619801.70,1619801.70,'642','2021-09-07 06:01:27','606','2021-09-07 06:42:13',10,0),('5','181',222871,'Daily','2021-09-07','2021-09-07 00:00:00',NULL,'642',889408.55,889408.55,'642','2021-09-07 20:19:20','606','2021-09-08 06:07:55',10,0),('5','181',222958,'Daily','2021-09-08','2021-09-08 00:00:00',NULL,'642',927820.40,927820.40,'642','2021-09-08 20:40:09','606','2021-09-09 05:15:55',10,0),('5','181',223216,'Daily','2021-09-09','2021-09-09 00:00:00',NULL,'642',1039805.30,1039805.30,'642','2021-09-09 21:21:52','606','2021-09-10 05:56:58',10,0),('5','181',223500,'Daily','2021-09-10','2021-09-10 00:00:00',NULL,'642',1776285.05,1776285.05,'642','2021-09-10 20:47:56','606','2021-09-11 05:59:36',10,0),('5','181',223753,'Daily','2021-09-11','2021-09-11 00:00:00',NULL,'642',910830.10,910830.10,'642','2021-09-12 08:56:21','606','2021-09-12 09:29:07',10,0),('5','181',223947,'Daily','2021-09-12','2021-09-12 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',224171,'Daily','2021-09-12','2021-09-12 00:00:00',NULL,'642',808260.90,808260.90,'642','2021-09-13 10:44:41','606','2021-09-13 10:50:01',10,0),('5','181',224183,'Daily','2021-09-13','2021-09-13 00:00:00',NULL,'642',1081489.20,1081489.20,'642','2021-09-13 20:25:35','606','2021-09-14 06:29:25',10,0),('5','181',224364,'Daily','2021-09-14','2021-09-14 00:00:00',NULL,'642',1511530.15,1511530.15,'642','2021-09-14 20:33:34','606','2021-09-15 06:18:54',10,0),('5','181',224675,'Daily','2021-09-15','2021-09-15 00:00:00',NULL,'642',1623937.85,1623937.85,'642','2021-09-16 12:53:39','606','2021-09-16 12:59:01',10,0),('5','181',224912,'Daily','2021-09-16','2021-09-16 00:00:00',NULL,'642',2097831.00,2090943.12,'642','2021-09-16 21:06:06','606','2021-09-17 05:48:41',10,0),('5','181',225179,'Daily','2021-09-17','2021-09-17 00:00:00',NULL,'642',2546054.15,2534939.83,'642','2021-09-18 09:31:34','606','2021-09-18 16:36:28',10,0),('5','181',225447,'Daily','2021-09-18','2021-09-18 00:00:00',NULL,'642',1496968.65,1488428.99,'642','2021-09-19 04:53:20','606','2021-09-19 06:00:16',10,0),('5','181',225570,'Daily','2021-09-19','2021-09-19 00:00:00',NULL,'642',1625097.20,1615872.16,'642','2021-09-20 04:58:27','606','2021-09-20 05:43:20',10,0),('5','181',225736,'Daily','2021-09-20','2021-09-20 00:00:00',NULL,'642',1360112.20,1351639.30,'642','2021-09-20 20:27:27','606','2021-09-21 05:34:04',10,0),('5','181',226093,'Daily','2021-09-21','2021-09-21 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',226098,'Daily','2021-09-21','2021-09-21 00:00:00',NULL,'642',1903231.12,1903231.12,'642','2021-09-21 20:20:01','606','2021-09-22 08:37:05',10,0),('5','181',226377,'Daily','2021-09-22','2021-09-22 00:00:00',NULL,'642',1278150.21,1278150.21,'642','2021-09-22 21:00:39','606','2021-09-23 05:39:51',10,0),('5','181',226512,'Daily','2021-09-23','2021-09-23 00:00:00',NULL,'642',2108491.70,2108491.70,'642','2021-09-24 08:27:00','606','2021-09-24 08:55:52',10,0),('5','181',226830,'Daily','2021-09-24','2021-09-24 00:00:00',NULL,'642',1870793.00,1870793.00,'642','2021-09-24 21:16:46','606','2021-09-25 05:48:00',10,0),('5','181',227079,'Daily','2021-09-25','2021-09-25 00:00:00',NULL,'642',1664004.27,1664004.27,'642','2021-09-25 20:24:24','606','2021-09-26 05:49:48',10,0),('5','181',227246,'Daily','2021-09-26','2021-09-26 00:00:00',NULL,'642',1702041.78,1702041.78,'642','2021-09-26 20:23:55','606','2021-09-27 05:40:20',10,0),('5','181',227500,'Daily','2021-09-27','2021-09-27 00:00:00',NULL,'642',1491050.13,1491050.13,'642','2021-09-27 20:26:26','606','2021-09-28 05:49:40',10,0),('5','181',227645,'Daily','2021-09-28','2021-09-28 00:00:00',NULL,'642',938498.74,938498.74,'642','2021-09-28 20:33:05','606','2021-09-29 03:48:40',10,0),('5','181',227836,'Daily','2021-09-29','2021-09-29 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',227915,'Daily','2021-09-29','2021-09-29 00:00:00',NULL,'600',1466635.95,1478288.70,'642','2021-09-29 20:21:20','606','2021-10-05 11:55:13',10,0),('5','181',229339,'Daily','2021-09-30','2021-09-30 00:00:00',NULL,'642',1603233.83,1603233.83,'642','2021-10-11 13:26:49','606','2021-10-11 13:28:37',10,0),('5','181',230659,'Daily','2021-10-11','2021-10-11 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',230666,'Daily','2021-10-01','2021-10-01 00:00:00',NULL,'642',2374197.87,2374197.87,'642','2021-10-11 15:48:04','606','2021-10-11 15:52:03',10,0),('5','181',230712,'Daily','2021-10-02','2021-10-02 00:00:00',NULL,'642',1250124.65,1250124.65,'642','2021-10-12 10:24:04','606','2021-10-12 10:27:40',10,0),('5','181',230866,'Daily','2021-10-03','2021-10-03 00:00:00',NULL,'642',1995154.67,1995154.67,'642','2021-10-12 10:53:27','606','2021-10-12 10:57:01',10,0),('5','181',230878,'Daily','2021-10-04','2021-10-04 00:00:00',NULL,'642',3367540.75,3367540.75,'642','2021-10-12 12:08:41','606','2021-10-12 12:10:41',10,0),('5','181',230918,'Daily','2021-10-05','2021-10-05 00:00:00',NULL,'642',1243009.00,1266018.20,'642','2021-10-12 12:17:55','606','2021-10-12 12:26:58',10,0),('5','181',230929,'Daily','2021-10-06','2021-10-06 00:00:00',NULL,'642',3844811.01,3970133.71,'642','2021-10-12 12:48:26','606','2021-10-12 14:53:13',10,0),('5','181',230993,'Daily','2021-10-07','2021-10-07 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',231019,'Daily','2021-10-07','2021-10-07 00:00:00',NULL,'642',1235033.80,1235033.80,'642','2021-10-12 17:00:32','606','2021-10-12 17:03:55',10,0),('5','181',231023,'Daily','2021-10-08','2021-10-08 00:00:00',NULL,'642',897496.81,897496.81,'642','2021-10-12 17:08:40','606','2021-10-12 17:10:58',10,0),('5','181',231024,'Daily','2021-10-09','2021-10-09 00:00:00',NULL,'642',1992651.29,1992651.29,'642','2021-10-12 17:18:13','606','2021-10-12 17:20:04',10,0),('5','181',231026,'Daily','2021-10-10','2021-10-10 00:00:00',NULL,'642',2312183.63,2312183.63,'642','2021-10-13 09:22:18','606','2021-10-13 09:29:01',10,0),('5','181',231140,'Daily','2021-10-11','2021-10-11 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',231147,'Daily','2021-10-11','2021-10-11 00:00:00',NULL,'642',1412360.36,1412360.36,'642','2021-10-13 11:28:14','604','2021-10-13 11:28:32',10,0),('5','181',231223,'Daily','2021-10-12','2021-10-12 00:00:00',NULL,'642',3117944.26,3117944.26,'642','2021-10-13 13:55:29','606','2021-10-13 13:56:54',10,0),('5','181',231258,'Daily','2021-10-13','2021-10-13 00:00:00',NULL,'642',2451916.58,2451916.58,'642','2021-10-13 21:17:03','606','2021-10-14 07:24:07',10,0),('5','181',231418,'Daily','2021-10-14','2021-10-14 00:00:00',NULL,'642',3376937.12,3376937.12,'642','2021-10-15 08:46:33','606','2021-10-15 15:09:42',10,0),('5','181',231833,'Daily','2021-10-15','2021-10-15 00:00:00',NULL,'642',2773799.72,2773799.72,'642','2021-10-16 04:50:35','606','2021-10-16 06:20:15',10,0),('5','181',231923,'Daily','2021-10-16','2021-10-16 00:00:00',NULL,'642',1947995.29,1947995.29,'642','2021-10-17 05:06:30','606','2021-10-17 06:49:28',10,0),('5','181',232203,'DAILY','2021-10-17','2021-10-17 00:00:00',NULL,'642',1925176.11,1925176.11,'642','2021-10-18 05:12:48','606','2021-10-18 06:13:00',10,0),('5','181',232397,'Daily','2021-10-18','2021-10-18 00:00:00',NULL,'642',3271159.10,3271159.10,'642','2021-10-19 07:20:58','606','2021-10-19 07:23:25',10,0),('5','181',232625,'DAILY','2021-10-19','2021-10-19 00:00:00',NULL,'642',4365969.83,4365969.83,'642','2021-10-19 22:30:12','606','2021-10-20 05:50:53',10,0),('5','181',232913,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'642',440776.38,440776.38,'642','2021-10-20 13:58:38','606','2021-10-20 14:01:30',10,0),('5','181',233018,'afternoon shift','2021-10-20','2021-10-20 00:00:00',NULL,'642',4390524.00,4390524.00,'642','2021-10-20 22:14:58','606','2021-10-21 06:04:43',10,0),('5','181',233144,'Daily','2021-10-21','2021-10-21 00:00:00',NULL,'642',3094864.70,3094864.70,'642','2021-10-21 22:22:27','606','2021-10-22 05:59:46',10,0),('5','181',233423,'Daily','2021-10-22','2021-10-22 00:00:00',NULL,'642',2923437.66,2923437.66,'642','2021-10-23 11:00:11','606','2021-10-23 11:01:54',10,0),('5','181',233701,'Daily','2021-10-23','2021-10-23 00:00:00',NULL,'642',4182798.96,4182798.96,'642','2021-10-24 04:55:07','606','2021-10-24 06:15:58',10,0),('5','181',233879,'Daily','2021-10-24','2021-10-24 00:00:00',NULL,'642',3205391.65,3205391.65,'642','2021-10-25 05:22:07','606','2021-10-25 06:06:01',10,0),('5','181',234132,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'642',3473565.08,3473565.08,'642','2021-10-26 06:33:43','606','2021-10-26 16:13:29',10,0),('5','181',234508,'Daily','2021-10-26','2021-10-26 00:00:00',NULL,'642',2787332.69,2787332.69,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',234676,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'642',434210.70,434210.70,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',234688,'MORNING SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'642',434210.70,434210.70,'642','2021-10-27 10:55:09','606','2021-10-27 10:56:36',10,0),('5','181',234693,'AFTERNOON','2021-10-26','2021-10-26 00:00:00',NULL,'642',2358385.15,2358385.15,'642','2021-10-27 11:08:14','606','2021-10-27 11:12:17',10,0),('5','181',234696,'Daily','2021-10-27','2021-10-27 00:00:00',NULL,'642',3628842.30,3628842.30,'642','2021-10-28 04:56:02','606','2021-10-28 07:20:38',10,0),('5','181',234937,'Daily ','2021-10-28','2021-10-28 00:00:00',NULL,'642',3207894.00,3207894.00,'642','2021-10-29 11:09:47','606','2021-10-29 11:54:52',10,0),('5','181',235192,'Daily ','2021-10-29','2021-10-29 00:00:00',NULL,'642',2725303.80,2725303.80,'642','2021-10-29 22:14:58','606','2021-10-30 07:15:05',10,0),('5','181',235385,'Daily','2021-10-30','2021-10-30 00:00:00',NULL,'642',5309070.75,5309070.75,'642','2021-10-31 05:20:04','606','2021-10-31 06:13:28',10,0),('5','181',235604,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'642',2914535.25,2914535.25,'642','2021-11-01 04:56:38','606','2021-11-01 07:25:46',10,0),('5','181',235807,'Daily','2021-11-01','2021-11-01 00:00:00',NULL,'642',3765824.85,3765824.85,'642','2021-11-02 07:56:25','606','2021-11-02 09:07:29',10,0),('5','181',236327,'DAILY','2021-11-02','2021-11-02 00:00:00',NULL,'642',2924337.15,2924337.15,'642','2021-11-03 09:39:34','606','2021-11-03 09:48:41',10,0),('5','181',236336,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'642',4284174.90,4284174.90,'642','2021-11-04 05:09:48','606','2021-11-04 06:14:21',10,0),('5','181',236596,'DAILY','2021-11-04','2021-11-04 00:00:00',NULL,'642',4979300.40,4979300.40,'642','2021-11-05 05:04:30','606','2021-11-05 06:34:54',10,0),('5','181',236791,'Daily','2021-11-05','2021-11-05 00:00:00',NULL,'642',5893467.90,5893467.90,'642','2021-11-06 20:57:41','606','2021-11-07 06:28:02',10,0),('5','181',237207,'Daily ','2021-11-06','2021-11-06 00:00:00',NULL,'642',3644512.05,3644512.05,'642','2021-11-07 07:46:31','606','2021-11-07 12:05:40',10,0),('5','181',237444,'DAILY','2021-11-07','2021-11-07 00:00:00',NULL,'642',2443799.10,2443799.10,'642','2021-11-08 08:30:52','606','2021-11-08 08:41:55',10,0),('5','181',237456,'DAILY','2021-11-08','2021-11-08 00:00:00',NULL,'642',3358995.90,3358995.90,'642','2021-11-09 08:49:38','606','2021-11-09 08:52:10',10,0),('5','181',237678,'Daily ','2021-11-09','2021-11-09 00:00:00',NULL,'642',4364758.35,4364758.35,'642','2021-11-10 05:34:35','606','2021-11-10 05:50:14',10,0),('5','181',238009,'Daily','2021-11-10','2021-11-10 00:00:00',NULL,'642',5612508.15,5612508.15,'642','2021-11-11 05:59:29','606','2021-11-11 10:15:55',10,0),('5','181',238228,'Daily ','2021-11-11','2021-11-11 00:00:00',NULL,'642',5406133.50,5406133.50,'642','2021-11-12 05:07:31','606','2021-11-12 07:28:07',10,0),('5','181',238419,'Daily ','2021-11-12','2021-11-12 00:00:00',NULL,'642',5855265.75,5855265.75,'642','2021-11-13 17:16:46','606','2021-11-14 05:48:28',10,0),('5','181',238886,'Daily ','2021-11-14','2021-11-14 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',238913,'Daily ','2021-11-13','2021-11-13 00:00:00',NULL,'642',5664314.10,5664314.10,'642','2021-11-17 10:06:40','606','2021-11-17 10:09:30',10,0),('5','181',239623,'Daily ','2021-11-14','2021-11-14 00:00:00',NULL,'642',4891910.70,4891910.70,'642','2021-11-17 10:25:52','606','2021-11-17 10:27:42',10,0),('5','181',239625,'Daily','2021-11-17','2021-11-17 00:00:00',NULL,'642',4320932.55,4320932.55,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',239627,'Daily ','2021-11-15','2021-11-15 00:00:00',NULL,'642',4320932.55,4320932.55,'642','2021-11-17 11:04:15','606','2021-11-17 11:05:46',10,0),('5','181',239630,'Daily ','2021-11-16','2021-11-16 00:00:00',NULL,'642',4978141.65,4978141.65,'642','2021-11-17 11:11:13','606','2021-11-17 11:11:57',10,0),('5','181',239631,'Daily ','2021-11-17','2021-11-17 00:00:00',NULL,'642',5266054.95,5266054.95,'642','2021-11-18 10:30:29','606','2021-11-18 17:06:52',10,0),('5','181',239973,'Daily ','2021-11-18','2021-11-18 00:00:00',NULL,'642',4230932.55,4230932.55,'642','2021-11-19 10:00:19','606','2021-11-19 10:02:20',10,0),('5','181',240070,'DAILY','2021-11-19','2021-11-19 00:00:00',NULL,'642',4920139.20,4920139.20,'642','2021-11-19 22:39:59','606','2021-11-20 07:09:02',10,0),('5','181',240291,'Daily','2021-11-20','2021-11-20 00:00:00',NULL,'642',3765440.70,3765440.70,'642','2021-11-21 10:05:54','606','2021-11-21 16:55:24',10,0),('5','181',240600,'Daily','2021-11-21','2021-11-21 00:00:00',NULL,'642',3805680.45,3805680.45,'642','2021-11-22 08:52:56','606','2021-11-22 08:56:12',10,0),('5','181',240765,'DAILY','2021-11-22','2021-11-22 00:00:00',NULL,'642',4587674.55,4587674.55,'642','2021-11-22 22:00:16','606','2021-11-23 07:02:03',10,0),('5','181',241040,'Daily ','2021-11-23','2021-11-23 00:00:00',NULL,'642',3099786.90,3099786.90,'642','2021-11-24 09:32:18','606','2021-11-24 09:35:47',10,0),('5','181',241325,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'642',4109216.85,4109216.85,'642','2021-11-25 09:19:40','600','2021-11-25 09:28:20',10,0),('5','181',241590,'DAILY','2021-11-25','2021-11-25 00:00:00',NULL,'642',5459701.35,5459701.35,'642','2021-11-26 05:07:35','606','2021-11-26 06:10:39',10,0),('5','181',241809,'Daily','2021-11-26','2021-11-26 00:00:00',NULL,'642',4841057.85,4841057.85,'642','2021-11-27 05:14:06','606','2021-11-27 07:09:15',10,0),('5','181',242107,'Daily ','2021-11-27','2021-11-27 00:00:00',NULL,'642',4549621.65,4549621.65,'642','2021-11-28 05:18:11','606','2021-11-28 06:49:27',10,0),('5','181',242272,'Daily','2021-11-28','2021-11-28 00:00:00',NULL,'642',4672487.55,4672487.55,'642','2021-11-29 04:55:03','606','2021-11-29 05:58:35',10,0),('5','181',242536,'Daily ','2021-11-29','2021-11-29 00:00:00',NULL,'642',5995375.80,5995375.80,'642','2021-11-30 07:14:19','606','2021-11-30 11:42:53',10,0),('5','181',242788,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'642',6229529.40,6229529.40,'642','2021-12-01 10:04:17','606','2021-12-02 07:21:04',10,0),('5','181',243210,'Daily ','2021-12-01','2021-12-01 00:00:00',NULL,'642',5634518.55,5634518.55,'642','2021-12-02 08:59:52','606','2021-12-02 09:04:11',10,0),('5','181',243219,'Daily ','2021-12-02','2021-12-02 00:00:00',NULL,'642',6463570.50,6463570.50,'642','2021-12-03 05:18:22','606','2021-12-03 06:57:33',10,0),('5','181',243495,'Daily ','2021-12-03','2021-12-03 00:00:00',NULL,'642',5080628.40,5080628.40,'642','2021-12-04 07:44:03','606','2021-12-05 05:46:12',10,0),('5','181',243837,'Daily ','2021-12-04','2021-12-04 00:00:00',NULL,'642',5199259.20,5199259.20,'642','2021-12-05 06:26:08','606','2021-12-05 15:55:04',10,0),('5','181',243985,'Daily ','2021-12-05','2021-12-05 00:00:00',NULL,'642',6195459.45,6195459.45,'642','2021-12-05 23:41:24','606','2021-12-06 06:29:57',10,0),('5','181',244119,'Daily ','2021-12-06','2021-12-06 00:00:00',NULL,'642',7829332.35,7829332.35,'642','2021-12-06 22:34:55','606','2021-12-07 06:52:17',10,0),('5','181',244346,'Daily','2021-12-07','2021-12-07 00:00:00',NULL,'642',5854213.20,5854213.20,'642','2021-12-08 00:05:50','606','2021-12-08 07:18:03',10,0),('5','181',244718,'Daily ','2021-12-08','2021-12-08 00:00:00',NULL,'642',5178249.45,5178249.45,'642','2021-12-08 23:16:02','606','2021-12-09 05:42:21',10,0),('5','181',244747,'Daily ','2021-12-09','2021-12-09 00:00:00',NULL,'642',4375211.10,4375211.10,'642','2021-12-10 11:57:02','606','2021-12-11 07:00:01',10,0),('5','181',245253,'Daily','2021-12-10','2021-12-10 00:00:00',NULL,'642',3357513.30,3357513.30,'642','2021-12-11 07:49:38','606','2021-12-11 07:56:12',10,0),('5','181',245398,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'642',4980113.70,4980113.70,'642','2021-12-12 00:16:49','606','2021-12-12 06:50:15',10,0),('5','181',245479,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'642',4909120.35,4909120.35,'642','2021-12-12 23:56:28','606','2021-12-13 05:59:17',10,0),('5','181',245697,'Daily','2021-12-13','2021-12-13 00:00:00',NULL,'642',4195777.05,4195777.05,'642','2021-12-14 06:21:45','606','2021-12-14 06:43:30',10,0),('5','181',245978,'Dailyj','2021-12-14','2021-12-14 00:00:00',NULL,'642',6949258.05,6949258.05,'642','2021-12-14 23:51:36','606','2021-12-15 06:39:43',10,0),('5','181',246206,'Daily','2021-12-15','2021-12-15 00:00:00',NULL,'642',6188664.90,6188664.90,'642','2021-12-15 22:24:48','606','2021-12-16 06:51:14',10,0),('5','181',246472,'Daily','2021-12-16','2021-12-16 00:00:00',NULL,'642',4874371.20,4874371.20,'642','2021-12-16 23:56:06','606','2021-12-17 06:11:12',10,0),('5','181',246774,'Daily','2021-12-17','2021-12-17 00:00:00',NULL,'642',5878507.20,5878507.20,'642','2021-12-18 08:53:56','606','2021-12-18 14:43:52',10,0),('5','181',247094,'DAILY','2021-12-18','2021-12-18 00:00:00',NULL,'642',6389233.20,6389233.20,'642','2021-12-18 23:49:00','606','2021-12-19 07:12:38',10,0),('5','181',247240,'Daily','2021-12-19','2021-12-19 00:00:00',NULL,'642',6038647.35,6038647.35,'642','2021-12-19 23:52:21','606','2021-12-20 06:54:48',10,0),('5','181',247478,'Daily','2021-12-20','2021-12-20 00:00:00',NULL,'642',3709736.10,3709736.10,'642','2021-12-20 23:33:08','600','2021-12-21 09:21:32',10,0),('5','181',247756,'Daily','2021-12-21','2021-12-21 00:00:00',NULL,'642',3722801.70,3722801.70,'642','2021-12-21 22:08:19','606','2021-12-22 06:29:47',10,0),('5','181',247991,'Daily','2021-12-22','2021-12-22 00:00:00',NULL,'642',4728910.35,4728910.35,'642','2021-12-22 23:40:35','606','2021-12-23 06:29:50',10,0),('5','181',248240,'Daily','2021-12-23','2021-12-23 00:00:00',NULL,'642',3258278.40,3258278.40,'642','2021-12-23 23:28:54','606','2021-12-24 07:20:36',10,0),('5','181',248483,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'642',4791850.05,4791850.05,'642','2021-12-24 23:26:21','606','2021-12-25 14:08:52',10,0),('5','181',248830,'Daily','2021-12-25','2021-12-25 00:00:00',NULL,'642',3541838.10,3541838.10,'642','2021-12-25 23:23:04','606','2021-12-26 07:31:56',10,0),('5','181',249042,'Daily','2021-12-26','2021-12-26 00:00:00',NULL,'642',3355828.65,3355828.65,'642','2021-12-26 23:22:36','606','2021-12-27 07:41:14',10,0),('5','181',249179,'Daily','2021-12-27','2021-12-27 00:00:00',NULL,'642',4825670.25,4825670.25,'642','2021-12-27 23:42:58','606','2021-12-28 07:35:59',10,0),('5','181',249443,'Daily','2021-12-28','2021-12-28 00:00:00',NULL,'642',3762093.00,3762093.00,'642','2021-12-28 23:32:25','606','2021-12-29 06:45:46',10,0),('5','181',249688,'Daily','2021-12-29','2021-12-29 00:00:00',NULL,'642',4084153.50,4084153.50,'642','2021-12-29 22:49:11','606','2021-12-30 06:57:45',10,0),('5','181',249971,'Daily','2021-12-30','2021-12-30 00:00:00',NULL,'642',4897245.90,4897245.90,'642','2021-12-30 23:49:02','606','2021-12-31 06:47:05',10,0),('5','181',250244,'DAILY','2021-12-31','2021-12-31 00:00:00',NULL,'642',5123345.40,5123345.40,'642','2021-12-31 23:48:01','606','2022-01-01 07:49:37',10,0),('5','181',250504,'Daily','2022-01-01','2022-01-01 00:00:00',NULL,'642',3861014.10,3861014.10,'642','2022-01-02 06:17:54','606','2022-01-02 06:45:04',10,0),('5','181',250681,'Daily','2022-01-02','2022-01-02 00:00:00',NULL,'642',4296317.25,4296317.25,'642','2022-01-03 00:15:23','606','2022-01-03 14:05:56',10,0),('5','181',250973,'Daily','2022-01-03','2022-01-03 00:00:00',NULL,'642',4894316.70,4894316.70,'642','2022-01-04 06:06:45','606','2022-01-04 07:05:02',10,0),('5','181',251222,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'642',3535316.55,3535316.55,'642','2022-01-04 23:27:00','606','2022-01-05 07:34:55',10,0),('5','181',251330,'Daily','2022-01-05','2022-01-05 00:00:00',NULL,'642',6494968.65,6494968.65,'642','2022-01-06 00:40:26','606','2022-01-06 07:47:33',10,0),('5','181',251604,'Dailyj','2022-01-06','2022-01-06 00:00:00',NULL,'642',4897751.55,4897751.55,'642','2022-01-07 00:35:56','606','2022-01-07 09:08:43',10,0),('5','181',251895,'Daily','2022-01-07','2022-01-07 00:00:00',NULL,'642',3069752.85,3069752.85,'642','2022-01-07 23:03:38','606','2022-01-08 07:58:17',10,0),('5','181',252219,'Daily','2022-01-09','2022-01-09 00:00:00',NULL,'642',2677669.20,2677669.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',252292,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'600',2677669.20,2677669.20,'642','2022-01-09 10:10:41','606','2022-01-09 16:54:58',10,0),('5','181',252385,'Daily','2022-01-09','2022-01-09 00:00:00',NULL,'642',3171097.20,3171097.20,'642','2022-01-10 00:35:32','606','2022-01-10 07:02:08',10,0),('5','181',252674,'Dailyj','2022-01-10','2022-01-10 00:00:00',NULL,'642',7254712.95,7254712.95,'642','2022-01-11 08:25:15','606','2022-01-11 08:40:26',10,0),('5','181',252770,'Dailyj','2022-01-11','2022-01-11 00:00:00',NULL,'642',4988578.80,4988578.80,'642','2022-01-12 00:48:43','606','2022-01-12 07:49:41',10,0),('5','181',253097,'Daily ','2022-01-12','2022-01-12 00:00:00',NULL,'642',3837685.80,3837685.80,'642','2022-01-13 00:33:27','606','2022-01-13 07:35:09',10,0),('5','181',253420,'Daily ','2022-01-13','2022-01-13 00:00:00',NULL,'642',5711036.85,5711036.85,'642','2022-01-13 23:28:15','606','2022-01-14 09:33:58',10,0),('5','181',253581,'Daily ','2022-01-14','2022-01-14 00:00:00',NULL,'642',6168643.35,6168643.35,'642','2022-01-15 00:39:05','606','2022-01-15 07:15:29',10,0),('5','181',253768,'Daily ','2022-01-15','2022-01-15 00:00:00',NULL,'642',5889262.35,5889262.35,'642','2022-01-16 01:02:54','606','2022-01-16 07:14:31',10,0),('5','181',254083,'Dailyu','2022-01-16','2022-01-16 00:00:00',NULL,'642',4960358.25,4960358.25,'642','2022-01-17 00:54:58','606','2022-01-17 07:13:48',10,0),('5','181',254332,'Daily','2022-01-17','2022-01-17 00:00:00',NULL,'642',5755346.70,5755346.70,'642','2022-01-18 00:59:41','606','2022-01-18 08:39:06',10,0),('5','181',254541,'Daily ','2022-01-18','2022-01-18 00:00:00',NULL,'642',5919990.30,5919990.30,'642','2022-01-19 07:23:32','606','2022-01-19 08:43:26',10,0),('5','181',254809,'Daily ','2022-01-19','2022-01-19 00:00:00',NULL,'642',5085535.50,5085535.50,'642','2022-01-20 00:41:24','606','2022-01-20 08:08:19',10,0),('5','181',255077,'Daily ','2022-01-20','2022-01-20 00:00:00',NULL,'642',6933229.70,6933229.70,'642','2022-01-20 23:42:37','606','2022-01-21 08:34:28',10,0),('5','181',255254,'Daily','2022-01-21','2022-01-21 00:00:00',NULL,'642',4619656.20,4619656.20,'642','2022-01-22 08:17:28','606','2022-01-22 18:53:40',10,0),('5','181',255651,'Daily ','2022-01-22','2022-01-22 00:00:00',NULL,'642',4391491.60,4391491.60,'642','2022-01-23 01:04:09','606','2022-01-23 07:23:09',10,0),('5','181',255758,'Daily ','2022-01-23','2022-01-23 00:00:00',NULL,'642',4654943.20,4654943.20,'642','2022-01-23 23:38:15','606','2022-01-24 08:33:14',10,0),('5','181',256029,'Daily ','2022-01-24','2022-01-24 00:00:00',NULL,'642',6250170.00,6250170.00,'642','2022-01-25 00:43:40','606','2022-01-25 07:32:33',10,0),('5','181',256287,'Daily','2022-01-25','2022-01-25 00:00:00',NULL,'642',5396533.00,5396533.00,'642','2022-01-26 00:13:12','606','2022-01-26 08:08:34',10,0),('5','181',256600,'Daily','2022-01-26','2022-01-26 00:00:00',NULL,'642',5405759.05,5405759.05,'642','2022-01-27 00:14:37','606','2022-01-27 07:57:09',10,0),('5','181',256821,'DAILY','2022-01-27','2022-01-27 00:00:00',NULL,'642',3833166.95,3833166.95,'642','2022-01-28 00:19:50','606','2022-01-28 07:22:14',10,0),('5','181',257134,'Daily ','2022-01-28','2022-01-28 00:00:00',NULL,'642',5724012.00,5724012.00,'642','2022-01-29 00:18:32','606','2022-01-29 07:49:59',10,0),('5','181',257339,'Daily ','2022-01-29','2022-01-29 00:00:00',NULL,'642',5527789.30,5527789.30,'642','2022-01-30 00:40:14','606','2022-01-30 07:44:46',10,0),('5','181',257340,'Daily','2022-01-30','2022-01-30 00:00:00',NULL,'642',4842397.65,4842397.65,'642','2022-01-31 09:33:35','606','2022-01-31 09:34:43',10,0),('5','181',257341,'Daily ','2022-01-31','2022-01-31 00:00:00',NULL,'642',1328558.55,1328558.55,'642','2022-01-31 23:59:45','606','2022-02-01 08:28:44',10,0),('5','181',257342,'Daily ','2022-02-01','2022-02-01 00:00:00',NULL,'642',5861924.85,5861924.85,'642','2022-02-02 00:26:52','606','2022-02-02 08:32:17',10,0),('5','181',257343,'Daily ','2022-02-02','2022-02-02 00:00:00',NULL,'642',6083080.65,6083080.65,'642','2022-02-03 00:08:13','606','2022-02-03 06:38:21',10,0),('5','181',257344,'Daily ','2022-02-03','2022-02-03 00:00:00',NULL,'642',8411757.45,8411757.45,'642','2022-02-03 22:58:02','606','2022-02-04 06:26:34',10,0),('5','181',257345,'Dailyi','2022-02-04','2022-02-04 00:00:00',NULL,'642',2646630.45,2646630.45,'642','2022-02-09 10:05:03','606','2022-02-09 13:14:54',10,0),('5','181',257346,'Daily ','2022-02-09','2022-02-09 00:00:00',NULL,'642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','181',257347,'Daily ','2022-02-05','2022-02-05 00:00:00',NULL,'642',2705549.55,2705549.55,'642','2022-02-09 13:48:47','606','2022-02-09 13:52:45',10,0),('5','181',257348,'Daily ','2022-02-06','2022-02-06 00:00:00',NULL,'642',3149274.60,3149274.60,'642','2022-02-09 14:12:06','606','2022-02-09 14:16:56',10,0),('5','181',257349,'Daily ','2022-02-07','2022-02-07 00:00:00',NULL,'642',4778962.50,4778962.50,'642','2022-02-09 14:37:04','606','2022-02-09 14:45:16',10,0),('5','181',257350,'Daily ','2022-02-08','2022-02-08 00:00:00',NULL,'642',6938125.95,6938125.95,'642','2022-02-09 16:58:50','606','2022-02-09 16:59:50',10,0),('5','181',257351,'DAILY','2022-02-09','2022-02-09 00:00:00',NULL,'642',4088755.25,4088755.25,'642','2022-02-09 23:21:55','606','2022-02-10 07:59:24',10,0),('5','181',257352,'Daily ','2022-02-10','2022-02-10 00:00:00',NULL,'642',4110761.75,4110761.75,'642','2022-02-11 00:33:47','606','2022-02-11 08:10:51',10,0),('5','181',257353,'Dailyu','2022-02-11','2022-02-11 00:00:00',NULL,'642',3900285.95,3900285.95,'642','2022-02-12 00:05:39','606','2022-02-12 08:12:11',10,0),('5','181',257354,'Daily ','2022-02-12','2022-02-12 00:00:00',NULL,'642',5963759.70,5963759.70,'642','2022-02-13 00:42:23','606','2022-02-13 07:29:08',10,0),('5','181',257355,'Daily','2022-02-13','2022-02-13 00:00:00',NULL,'642',3425173.10,3425173.10,'642','2022-02-14 00:25:53','606','2022-02-14 07:19:57',10,0),('5','181',257356,'Dailyu','2022-02-14','2022-02-14 00:00:00',NULL,'642',5887834.65,5887834.65,'642','2022-02-15 07:51:37','606','2022-02-15 08:09:20',10,0),('5','181',257357,'Daily','2022-02-15','2022-02-15 00:00:00',NULL,'642',3041114.95,3041114.95,'642','2022-02-15 22:57:49','606','2022-02-16 07:31:50',10,0),('5','181',257358,'Daily','2022-02-16','2022-02-16 00:00:00',NULL,'642',4750861.10,4750861.10,'642','2022-02-16 23:13:44','606','2022-02-17 07:08:37',10,0),('5','181',257359,'Daily','2022-02-17','2022-02-17 00:00:00',NULL,'642',3459796.15,3459796.15,'642','2022-02-18 07:24:39','606','2022-02-18 08:17:51',10,0),('5','181',257360,'Daily','2022-02-18','2022-02-18 00:00:00',NULL,'642',4191911.95,4191911.95,'642','2022-02-19 07:44:55','606','2022-02-19 10:59:28',10,0),('5','181',257361,'Daily','2022-02-19','2022-02-19 00:00:00',NULL,'642',4579199.65,4579199.65,'642','2022-02-20 00:36:15','606','2022-02-20 07:20:50',10,0),('5','181',257362,'Daily','2022-02-20','2022-02-20 00:00:00',NULL,'642',3810014.00,3810014.00,'642','2022-02-20 23:08:02','606','2022-02-21 07:24:33',10,0),('5','181',257363,'Daily','2022-02-21','2022-02-21 00:00:00',NULL,'642',5217664.80,5217664.80,'642','2022-02-21 23:01:06','606','2022-02-22 06:42:23',10,0),('5','181',257364,'Daily','2022-02-22','2022-02-22 23:00:48','2022-02-23 23:00:48','642',6374357.45,6374357.45,'642','2022-02-22 23:04:40','606','2022-02-23 07:01:39',10,0),('5','181',257365,'Daily','2022-02-23','2022-02-23 10:36:18','2022-02-24 10:36:18','642',4918665.15,4918665.15,'642','2022-02-23 23:00:46','606','2022-02-24 09:37:28',10,0),('5','181',257366,'Daily','2022-02-24','2022-02-24 23:32:39','2022-02-25 23:32:39','642',2149395.00,2149395.00,'642','2022-02-25 09:53:56','606','2022-02-25 21:44:29',10,0),('5','181',257367,'Daily','2022-02-25','2022-02-25 21:49:28','2022-02-26 21:49:28','642',6132414.60,6132414.60,'642','2022-02-25 23:05:31','606','2022-02-26 07:19:19',10,0),('5','181',257368,'Dailyh','2022-02-26','2022-02-26 21:52:13','2022-02-27 21:52:13','642',7685877.80,7685877.80,'642','2022-02-27 08:35:00','606','2022-02-27 12:19:25',10,0),('5','181',257369,'Daily','2022-02-27','2022-02-27 12:35:37','2022-02-28 12:35:37','642',5836794.95,5836794.95,'642','2022-02-28 00:09:39','606','2022-02-28 07:17:29',10,0),('5','181',257370,'Daily','2022-02-28','2022-02-28 21:39:10','2022-03-01 21:39:10','642',2505078.60,2505078.60,'642','2022-03-01 07:36:10','606','2022-03-01 23:18:22',10,0),('5','181',257371,'Daily','2022-03-01','2022-03-01 23:19:02','2022-03-02 23:19:02','642',5366814.25,5366814.25,'642','2022-03-02 00:53:00','606','2022-03-02 08:18:10',10,0),('5','181',257372,'Daily','2022-03-02','2022-03-02 11:51:32','2022-03-03 11:51:32','642',1450882.95,1450882.95,'642','2022-03-03 00:20:32','606','2022-03-03 09:44:16',10,0),('5','181',257373,'Daily','2022-03-03','2022-03-03 21:26:21','2022-03-04 21:26:21','642',1309494.45,1309494.45,'642','2022-03-03 21:45:33','606','2022-03-04 09:12:52',10,0),('5','181',257374,'Daily','2022-03-04','2022-03-04 20:30:51','2022-03-05 20:30:51','642',900073.35,900073.35,'642','2022-03-04 23:34:37','606','2022-03-05 07:32:51',10,0),('5','181',257375,'Daily','2022-03-05','2022-03-05 10:52:31','2022-03-06 10:52:31','642',1006140.30,1006140.30,'642','2022-03-06 14:16:52','606','2022-03-06 15:01:08',10,0),('5','181',257376,'Daily','2022-03-06','2022-03-06 15:13:28','2022-03-07 15:13:28','642',8092519.80,8092519.80,'642','2022-03-07 00:42:01','606','2022-03-07 07:58:32',10,0),('5','181',257377,'Daily','2022-03-07','2022-03-08 06:50:02','2022-03-09 06:50:02','642',4960187.70,4960187.70,'642','2022-03-08 06:58:13','606','2022-03-08 07:02:54',10,0),('5','181',257378,'Daily','2022-03-08','2022-03-08 22:11:12','2022-03-09 22:11:12','642',1839637.80,1839637.80,'642','2022-03-08 22:24:59','606','2022-03-09 07:56:34',10,0),('5','181',257379,'Daily ','2022-03-09','2022-03-09 15:20:35','2022-03-10 15:20:35','642',1017683.70,1017683.70,'642','2022-03-10 00:29:57','600','2022-03-10 19:43:53',10,0),('5','181',257380,'Daily','2022-03-10','2022-03-10 22:15:39','2022-03-11 22:15:39','642',961205.85,961205.85,'642','2022-03-10 22:17:10','606','2022-03-11 08:24:20',10,0),('5','181',257381,'Daily ','2022-03-11','2022-03-11 21:32:36','2022-03-12 21:32:36','642',1467422.55,1467422.55,'642','2022-03-11 23:44:20','606','2022-03-12 07:55:57',10,0),('5','181',257382,'Daily','2022-03-12','2022-03-12 15:28:59','2022-03-13 15:28:59','642',2361513.95,2361513.95,'642','2022-03-13 00:21:53','606','2022-03-13 08:06:24',10,0),('5','181',257383,'Daily','2022-03-13','2022-03-13 23:20:12','2022-03-14 23:20:12','642',3619943.10,3619943.10,'642','2022-03-13 23:42:18','606','2022-03-14 07:05:59',10,0),('5','181',257384,'Daily ','2022-03-14','2022-03-14 15:57:32','2022-03-15 15:57:32','642',3753531.75,3753531.75,'642','2022-03-14 23:41:39','606','2022-03-15 07:07:27',10,0),('5','181',257385,'Daily ','2022-03-15','2022-03-15 19:18:27','2022-03-16 19:18:27','642',3576523.20,3576523.20,'642','2022-03-15 23:56:13','606','2022-03-16 08:09:16',10,0),('5','181',257386,'Daily ','2022-03-16','2022-03-16 19:23:40','2022-03-17 19:23:40','642',5965073.65,5965073.65,'642','2022-03-17 07:33:14','606','2022-03-17 10:22:00',10,0),('5','181',257387,'Daily','2022-03-17','2022-03-17 21:37:02','2022-03-18 21:37:02','642',4128540.00,4128540.00,'642','2022-03-18 07:45:26','606','2022-03-18 07:46:51',10,0),('5','181',257388,'Daily','2022-03-18','2022-03-18 10:46:45','2022-03-19 10:46:45','642',8780181.10,8780181.10,'642','2022-03-19 00:30:48','606','2022-03-19 07:00:16',10,0),('5','181',257389,'Daily','2022-03-19','2022-03-19 20:52:52','2022-03-20 20:52:52','642',6291443.45,6291443.45,'642','2022-03-19 22:53:02','606','2022-03-20 07:30:26',10,0),('5','181',257390,'Daily','2022-03-20','2022-03-20 21:36:07','2022-03-21 21:36:07','642',5730340.05,5730340.05,'642','2022-03-20 23:04:38','606','2022-03-21 06:32:32',10,0),('5','181',257391,'Daily ','2022-03-21','2022-03-21 18:30:45','2022-03-22 18:30:45','642',7312800.00,7312800.00,'642','2022-03-22 00:21:40','606','2022-03-22 07:06:00',10,0),('5','181',257392,'Daily','2022-03-22','2022-03-22 20:39:58','2022-03-23 20:39:58','642',7188729.50,7188729.50,'642','2022-03-23 10:15:28','606','2022-03-24 20:33:03',10,0),('5','181',257393,'Daly','2022-03-23','2022-03-25 19:56:01','2022-03-26 19:56:01','642',2661598.55,2661598.55,'642','2022-03-29 17:56:07','606','2022-03-30 06:41:12',10,0),('5','181',257394,'Daly','2022-03-24','2022-03-31 11:00:45','2022-04-01 11:00:45','642',9218398.35,9218398.35,'642','2022-03-31 11:04:10','606','2022-03-31 11:09:05',10,0),('5','181',257395,'Daly','2022-03-25','2022-04-09 14:51:45','2022-04-10 14:51:45','642',8103873.30,8103873.30,'642','2022-04-09 14:54:13','600','2022-04-09 14:56:15',10,0),('5','181',257396,'Daily','2022-03-26','2022-04-09 15:00:27','2022-04-10 15:00:27','642',5395087.15,5395087.15,'642','2022-04-09 15:03:43','600','2022-04-09 15:04:31',10,0),('5','181',257397,'Daily','2022-03-27','2022-04-09 15:10:44','2022-04-10 15:10:44','642',8582517.30,8582517.30,'642','2022-04-09 15:13:24','600','2022-04-09 15:14:08',10,0),('5','181',257398,'Daily','2022-03-28','2022-04-09 15:14:50','2022-04-10 15:14:50','642',7592589.75,7592589.75,'642','2022-04-09 16:16:52','797','2022-04-10 15:01:18',10,0),('5','181',257399,'Daily','2022-03-29','2022-04-12 21:46:02','2022-04-13 21:46:02','642',8043252.90,8043252.90,'642','2022-04-16 13:14:59','797','2022-04-16 13:21:31',10,0),('5','181',257400,'Daily','2022-03-30','2022-04-16 13:27:41','2022-04-17 13:27:41','642',7240972.20,7051640.00,'642','2022-04-16 13:36:05','797','2022-04-16 13:37:26',10,0),('5','181',257401,'Daily','2022-03-31','2022-04-16 13:38:20','2022-04-17 13:38:20','642',7662279.90,7461494.10,'642','2022-04-16 13:41:10','797','2022-04-16 13:42:09',10,0),('5','181',257402,'Daily','2022-04-01','2022-04-16 13:42:52','2022-04-17 13:42:52','642',8917406.85,8688192.85,'642','2022-04-18 13:32:17','797','2022-04-18 13:33:43',10,0),('5','181',257403,'DAILY','2022-03-02','2022-04-18 13:35:03','2022-04-19 13:35:03','642',7785625.65,7586030.45,'642','2022-04-18 14:07:42','797','2022-04-18 14:10:55',10,0),('5','181',257404,'DAILY','2022-03-03','2022-04-18 14:14:04','2022-04-19 14:14:04','642',5120019.30,4996751.70,'642','2022-04-18 14:19:17','797','2022-04-18 14:21:13',10,0),('5','181',257405,'DAILY','2022-03-04','2022-04-18 14:30:30','2022-04-19 14:30:30','642',9122703.15,9122703.15,'642','2022-04-18 14:33:07','797','2022-04-18 14:36:02',10,0),('5','181',257406,'DAILY','2022-03-05','2022-04-18 14:37:19','2022-04-19 14:37:19','642',8538444.75,8538444.75,'642','2022-04-18 14:55:38','797','2022-04-18 15:00:41',10,0),('5','181',257407,'DAILY','2022-03-06','2022-04-18 15:01:35','2022-04-19 15:01:35','642',8416268.85,8188200.45,'642','2022-04-18 15:26:41','797','2022-04-18 15:28:58',10,0),('5','181',257408,'DAILY','2022-03-07','2022-04-18 15:29:55','2022-04-19 15:29:55','642',7308196.50,7117558.70,'642','2022-04-18 15:45:49','797','2022-04-18 15:47:40',10,0),('5','181',257409,'DAILY','2022-03-08','2022-04-18 15:49:09','2022-04-19 15:49:09','642',6624878.70,6453066.50,'642','2022-04-18 15:54:22','797','2022-04-18 15:55:24',10,0),('5','181',257410,'DAILY','2022-03-09','2022-04-18 15:56:21','2022-04-19 15:56:21','642',6144524.10,6008296.90,'642','2022-04-18 16:01:04','797','2022-04-18 16:01:52',10,0),('5','181',257411,'DAILY','2022-03-10','2022-04-18 16:03:06','2022-04-19 16:03:06','642',8886624.45,8670290.05,'642','2022-04-18 16:49:20','797','2022-04-18 16:50:32',10,0),('5','181',257412,'DAILY','2022-03-11','2022-04-18 16:59:02','2022-04-19 16:59:02','642',7064953.50,7064953.50,'642','2022-04-18 17:22:33','797','2022-04-18 17:23:17',10,0),('5','181',257413,'Daily','2022-04-12','2022-04-18 17:28:23','2022-04-19 17:28:23','642',11305009.65,11305009.65,'642','2022-04-18 17:41:25','797','2022-04-18 17:55:41',10,0),('5','181',257414,'Daily ','2022-04-13','2022-04-20 16:46:02','2022-04-21 16:46:02','642',11026491.30,11026491.30,'642','2022-04-20 17:02:24','797','2022-04-20 17:03:27',10,0),('5','181',257415,'Daily ','2022-04-14','2022-04-20 17:05:04','2022-04-21 17:05:04','642',2886498.45,2886498.45,'600','2022-04-23 15:16:12','600','2022-04-23 15:33:27',10,0),('5','181',257416,'Daily ','2022-04-15','2022-04-23 15:34:32','2022-04-24 15:34:32','642',9382399.95,9382399.95,'642','2022-04-23 15:36:34','600','2022-04-23 15:37:56',10,0),('5','181',257417,'Daily ','2022-04-16','2022-04-23 15:39:15','2022-04-24 15:39:15','642',9804224.10,9804224.10,'642','2022-04-23 15:52:30','600','2022-04-23 15:53:52',10,0),('5','181',257418,'DAILY ','2022-04-17','2022-04-23 15:56:22','2022-04-24 15:56:22','642',4452886.35,4452886.35,'642','2022-04-23 18:11:50','797','2022-04-23 18:14:16',10,0),('5','181',257419,'Daily ','2022-04-18','2022-04-23 18:17:18','2022-04-24 18:17:18','642',5660716.05,5660716.05,'642','2022-04-23 18:18:55','797','2022-04-23 18:20:16',10,0),('5','181',257420,'Daily ','2022-04-19','2022-04-23 18:21:07','2022-04-24 18:21:07','642',4900143.60,4900143.60,'642','2022-04-23 18:36:14','797','2022-04-23 18:47:56',10,0),('5','181',257421,'Daily ','2022-04-20','2022-04-23 19:27:31','2022-04-24 19:27:31','642',9163862.40,9163862.40,'642','2022-04-23 19:29:36','797','2022-04-23 19:32:43',10,0),('5','181',257422,'Daily ','2022-04-21','2022-04-23 19:33:20','2022-04-24 19:33:20','642',6193641.30,6193641.30,'642','2022-04-23 19:35:08','797','2022-04-23 19:37:37',10,0),('5','181',257423,'Daily ','2022-04-22','2022-04-23 19:38:35','2022-04-24 19:38:35','642',6862744.35,6862744.35,'642','2022-04-23 19:41:05','797','2022-04-23 19:42:41',10,0),('5','181',257424,'Daily ','2022-04-23','2022-04-23 19:43:24','2022-04-24 19:43:24','642',8357848.95,8357848.95,'642','2022-04-24 15:02:48','797','2022-04-24 15:04:08',10,0),('5','181',257425,'Daily ','2022-04-24','2022-04-24 20:45:11','2022-04-25 20:45:11','642',6466775.70,6466775.70,'642','2022-04-24 22:52:59','797','2022-04-25 04:52:27',10,0),('5','181',257426,'Daily ','2022-04-25','2022-04-25 09:36:32','2022-04-26 09:36:32','642',5264872.80,5264872.80,'642','2022-04-26 00:07:29','797','2022-04-26 07:33:57',10,0),('5','181',257427,'Daily ','2022-04-26','2022-04-26 12:11:19','2022-04-27 12:11:19','642',7845626.25,7845626.25,'642','2022-04-27 11:53:25','797','2022-04-27 11:57:24',10,0),('5','181',257428,'Daily','2022-04-27','2022-04-27 12:31:06','2022-04-28 12:31:06','642',5181669.90,5181669.90,'642','2022-04-28 08:51:08','797','2022-04-28 08:59:52',10,0),('5','181',257429,'Daily','2022-04-28','2022-04-28 09:17:02','2022-04-29 09:17:02','642',6217356.75,6217356.75,'642','2022-04-29 13:31:26','797','2022-04-29 14:29:05',10,0),('5','181',257430,'DAILY','2022-04-29','2022-04-29 14:33:51','2022-04-30 14:33:51','642',6759960.90,6759960.90,'642','2022-05-13 12:01:19','797','2022-05-13 12:01:57',10,0),('5','181',257431,'Daily','2022-04-30','2022-05-13 12:04:27','2022-05-14 12:04:27','642',5316945.15,5316945.15,'642','2022-05-13 12:14:49','797','2022-05-13 12:15:16',10,0),('5','181',257432,'Daily','2022-05-01','2022-05-13 12:18:05','2022-05-14 12:18:05','642',2610446.85,2610446.85,'642','2022-05-13 12:22:50','797','2022-05-13 12:23:13',10,0),('5','181',257433,'Daily','2022-05-02','2022-05-13 12:24:41','2022-05-14 12:24:41','642',1474779.90,1474779.90,'642','2022-05-13 12:28:55','797','2022-05-13 12:29:18',10,0),('5','181',257434,'Daily','2022-05-03','2022-05-13 12:32:00','2022-05-14 12:32:00','642',3238925.25,3238925.25,'642','2022-05-13 12:35:01','797','2022-05-13 12:36:27',10,0),('5','181',257435,'Daily','2022-05-04','2022-05-13 12:37:42','2022-05-14 12:37:42','642',5873158.50,5873158.50,'642','2022-05-13 12:39:57','797','2022-05-13 12:40:47',10,0),('5','181',257436,'Daily','2022-05-05','2022-05-13 12:42:00','2022-05-14 12:42:00','642',0.00,0.00,'642','2022-05-13 12:56:25','797','2022-05-13 12:56:50',10,0),('5','181',257437,'Daily','2022-05-05','2022-05-13 12:58:38','2022-05-14 12:58:38','642',0.00,0.00,'642','2022-05-13 13:26:20','797','2022-05-13 13:26:42',10,0),('5','181',257438,'Daily','2022-05-05','2022-05-13 15:16:58','2022-05-14 15:16:58','642',1054823.55,1054823.55,'642','2022-05-13 15:22:54','797','2022-05-13 15:23:54',10,0),('5','181',257439,'DAILY','2022-05-06','2022-05-13 15:26:31','2022-05-14 15:26:31','642',0.00,0.00,'446','2022-05-18 09:30:16','446','2022-05-18 09:30:30',10,0),('5','181',257440,'Daily','2022-05-04','2022-05-18 09:41:13','2022-05-19 09:41:13','446',6221417.40,6221417.40,'642','2022-05-18 11:36:16','797','2022-05-18 11:39:12',10,0),('5','181',257441,'Daily','2022-05-05','2022-05-18 11:40:42','2022-05-19 11:40:42','642',10915754.85,10915754.85,'642','2022-05-18 12:11:05','797','2022-05-18 12:11:58',10,0),('5','181',257442,'Daily','2022-05-06','2022-05-18 12:13:55','2022-05-19 12:13:55','642',7369317.45,7369317.45,'642','2022-05-18 12:21:27','797','2022-05-18 12:22:30',10,0),('5','181',257443,'Daily','2022-05-07','2022-05-18 13:00:05','2022-05-19 13:00:05','642',11724637.65,11724637.65,'642','2022-05-18 13:01:25','797','2022-05-18 13:07:52',10,0),('5','181',257444,'Daily','2022-05-08','2022-05-18 13:16:45','2022-05-19 13:16:45','642',4499619.30,4499619.30,'642','2022-05-18 13:22:01','797','2022-05-18 13:23:24',10,0),('5','181',257445,'Daily','2022-05-09','2022-05-18 13:32:37','2022-05-19 13:32:37','642',7306594.35,7306594.35,'642','2022-05-18 13:55:06','797','2022-05-18 13:56:55',10,0),('5','181',257446,'Daily','2022-05-10','2022-05-18 13:57:45','2022-05-19 13:57:45','642',10274680.35,10274680.35,'642','2022-05-18 13:59:47','797','2022-05-18 14:01:19',10,0),('5','181',257447,'Daily','2022-05-11','2022-05-18 14:01:51','2022-05-19 14:01:51','642',11745483.75,11745483.75,'642','2022-05-18 14:03:18','797','2022-05-18 14:04:52',10,0),('5','181',257448,'Daily','2022-05-12','2022-05-18 14:06:36','2022-05-19 14:06:36','642',10359620.70,10359620.70,'642','2022-05-18 14:41:38','797','2022-05-18 14:44:05',10,0),('5','181',257449,'Daily','2022-05-13','2022-05-18 14:45:57','2022-05-19 14:45:57','642',14017804.70,14017804.70,'642','2022-05-18 14:49:26','797','2022-05-18 14:52:15',10,0),('5','181',257450,'Daily','2022-05-14','2022-05-18 15:00:00','2022-05-19 15:00:00','642',9584391.45,9584391.45,'642','2022-05-18 15:02:35','797','2022-05-18 15:03:59',10,0),('5','181',257451,'Daily','2022-05-15','2022-05-18 15:07:21','2022-05-19 15:07:21','642',9844240.50,9844240.50,'642','2022-05-18 15:42:45','797','2022-05-18 15:43:50',10,0),('5','181',257452,'Daily','2022-05-16','2022-05-18 15:44:39','2022-05-19 15:44:39','642',1216891.50,1216891.50,'642','2022-05-18 15:48:11','797','2022-05-18 15:49:57',10,0),('5','181',257453,'Daily','2022-05-17','2022-05-18 16:10:01','2022-05-19 16:10:01','642',12044133.90,12044133.90,'642','2022-05-18 16:13:52','797','2022-05-18 16:17:20',10,0),('5','181',257454,'Daily','2022-05-18','2022-05-18 16:43:29','2022-05-19 16:43:29','642',6182910.45,6182910.45,'642','2022-05-19 10:11:30','797','2022-05-19 10:12:50',10,0),('5','181',257455,'Daily','2022-05-19','2022-05-19 10:14:47','2022-05-20 10:14:47','642',3332394.90,3332394.90,'642','2022-05-20 14:27:11','797','2022-05-20 14:38:06',10,0),('5','181',257456,'Daily','2022-05-20','2022-05-20 14:38:38','2022-05-21 14:38:38','642',2834595.60,2834595.60,'642','2022-05-21 12:46:28','797','2022-05-21 14:15:05',10,0),('5','181',257457,'Daily','2022-05-21','2022-05-21 14:19:50','2022-05-22 14:19:50','642',2706900.75,2706900.75,'642','2022-05-22 13:14:52','797','2022-05-22 17:35:26',10,0),('5','181',257458,'Daily','2022-05-22','2022-05-23 10:00:00','2022-05-24 10:00:00','642',889068.75,889068.75,'642','2022-05-23 10:24:11','797','2022-05-23 10:25:10',10,0),('5','181',257459,'Daily','2022-05-23','2022-05-23 10:37:43','2022-05-24 10:37:43','642',1028834.10,1028834.10,'642','2022-05-24 12:17:56','797','2022-05-24 12:24:28',10,0),('5','181',257460,'DAILY','2022-05-24','2022-05-24 17:17:30','2022-05-25 17:17:30','642',1361954.25,1361954.25,'642','2022-05-25 14:00:35','797','2022-05-25 14:13:39',10,0),('5','181',257461,'Daily','2022-05-25','2022-05-25 16:38:56','2022-05-26 16:38:56','642',1176984.30,1176984.30,'642','2022-05-26 17:07:52','797','2022-05-26 17:10:21',10,0),('5','181',257462,'DAILY','2022-05-26','2022-05-26 18:45:51','2022-05-27 18:45:51','642',1058793.45,1058793.45,'642','2022-05-26 22:51:28','797','2022-05-27 05:50:03',10,0),('5','181',257463,'DAILY','2022-05-27','2022-05-27 13:01:14','2022-05-28 13:01:14','642',1168208.25,1168208.25,'642','2022-05-27 22:29:09','797','2022-05-28 06:56:30',10,0),('5','181',257464,'Daily','2022-05-28','2022-05-28 13:05:19','2022-05-29 13:05:19','642',1053645.45,1053645.45,'642','2022-05-28 22:45:26','797','2022-05-29 09:40:14',10,0),('5','181',257465,'DAILY ','2022-05-29','2022-05-29 10:45:07','2022-05-30 10:45:07','642',844450.20,844450.20,'642','2022-05-30 09:36:55','797','2022-05-30 10:29:59',10,0),('5','181',257466,'DAILY to','2022-05-30','2022-05-30 13:04:55','2022-05-31 13:04:55','642',1197921.45,1197921.45,'642','2022-05-31 06:27:58','797','2022-05-31 10:02:19',10,0),('5','181',257467,'DAILY','2022-05-31','2022-05-31 10:16:35','2022-06-01 10:16:35','642',1149447.75,1149447.75,'642','2022-05-31 21:56:26','797','2022-05-31 22:43:08',10,0),('5','181',257468,'DAILY','2022-06-01','2022-06-01 08:20:53','2022-06-02 08:20:53','642',1081004.10,1081004.10,'642','2022-06-01 22:33:30','797','2022-06-02 05:37:59',10,0),('5','181',257469,'DAILY','2022-06-02','2022-06-02 13:28:04','2022-06-03 13:28:04','642',1337254.05,1337254.05,'642','2022-06-03 07:26:48','797','2022-06-03 11:42:09',10,0),('5','181',257470,'DAILY','2022-06-03','2022-06-03 11:47:18','2022-06-04 11:47:18','642',992664.75,992664.75,'642','2022-06-03 22:54:35','797','2022-06-04 07:52:36',10,0),('5','181',257471,'DAILY ','2022-06-04','2022-06-04 08:27:48','2022-06-05 08:27:48','642',826552.65,826552.65,'642','2022-06-05 07:57:06','797','2022-06-05 08:07:21',10,0),('5','181',257472,'DAILY ','2022-06-05','2022-06-05 10:49:37','2022-06-06 10:49:37','642',913882.20,913882.20,'642','2022-06-06 06:31:19','797','2022-06-06 09:44:43',10,0),('5','181',257473,'DAILY u it','2022-06-06','2022-06-06 09:52:16','2022-06-07 09:52:16','642',1209481.35,1209481.35,'642','2022-06-07 02:48:30','797','2022-06-07 06:47:53',10,0),('5','181',257474,'DAILY ','2022-06-07','2022-06-07 08:30:54','2022-06-08 08:30:54','642',585147.75,585147.75,'642','2022-06-07 22:21:38','797','2022-06-08 09:02:56',10,0),('5','181',257475,'DAILY ','2022-06-08','2022-06-08 11:39:12','2022-06-09 11:39:12','642',1412145.90,1412145.90,'642','2022-06-08 22:28:44','797','2022-06-08 23:01:18',10,0),('5','181',257476,'DAILY ','2022-06-09','2022-06-09 07:57:12','2022-06-10 07:57:12','642',1155371.25,1155371.25,'642','2022-06-10 05:50:27','797','2022-06-10 09:20:59',10,0),('5','181',257477,'DAILY ','2022-06-10','2022-06-10 09:38:28','2022-06-11 09:38:28','642',605165.55,605165.55,'642','2022-06-10 22:53:29','797','2022-06-11 05:49:00',10,0),('5','181',257478,'DAILY','2022-06-11','2022-06-11 08:31:53','2022-06-12 08:31:53','642',0.00,0.00,'642','2022-06-11 22:23:40','797','2022-06-12 12:32:00',10,0),('5','181',257479,'DAILY ','2022-06-12','2022-06-12 14:36:00','2022-06-13 14:36:00','642',3004518.40,3004518.40,'642','2022-06-13 11:55:16','797','2022-06-13 13:47:42',10,0),('5','181',257480,'Daily','2022-06-13','2022-06-13 13:59:54','2022-06-14 13:59:54','642',3876656.00,3876656.00,'642','2022-06-14 08:54:41','797','2022-06-14 10:52:31',10,0),('5','181',257481,'DAILY','2022-06-14','2022-06-14 12:40:02','2022-06-15 12:40:02','642',4472755.45,4472755.45,'642','2022-06-15 09:35:48','797','2022-06-15 09:38:18',10,0),('5','181',257482,'DAILY ','2022-06-15','2022-06-15 10:35:54','2022-06-16 10:35:54','642',3361925.70,3361925.70,'642','2022-06-16 07:18:15','797','2022-06-16 09:39:50',10,0),('5','181',257483,'Daily','2022-06-16','2022-06-16 10:07:46','2022-06-17 10:07:46','642',4168925.40,4168925.40,'642','2022-06-17 07:37:34','797','2022-06-17 07:48:06',10,0),('5','181',257484,'Daily ','2022-06-17','2022-06-17 10:16:18','2022-06-18 10:16:18','642',4191516.00,4191516.00,'642','2022-06-18 12:40:21','797','2022-06-18 12:45:18',10,0),('5','181',257485,'Daily','2022-06-18','2022-06-18 14:32:20','2022-06-19 14:32:20','642',2014308.10,2014308.10,'642','2022-06-18 21:37:04','797','2022-06-18 23:03:06',10,0),('5','181',257486,'Daily','2022-06-19','2022-06-19 10:22:00','2022-06-20 10:22:00','642',4685446.05,4685446.05,'642','2022-06-20 10:16:49','797','2022-06-20 12:08:48',10,0),('5','181',257487,'DAILY','2022-06-20','2022-06-20 12:13:40','2022-06-21 12:13:40','642',2839803.15,2839803.15,'642','2022-06-21 08:44:53','797','2022-06-21 12:22:44',10,0),('5','181',257488,'DAILY','2022-06-21','2022-06-21 13:24:01','2022-06-22 13:24:01','642',4981450.05,4981450.05,'642','2022-06-22 06:04:17','797','2022-06-22 07:32:20',10,0),('5','181',257489,'DAILY ','2022-06-22','2022-06-22 09:15:47','2022-06-23 09:15:47','642',3568096.70,3568096.70,'642','2022-06-22 22:46:52','797','2022-06-23 05:35:01',10,0),('5','181',257490,'Daily','2022-06-23','2022-06-23 08:16:30','2022-06-24 08:16:30','642',2919199.55,2919199.55,'642','2022-06-23 22:57:24','797','2022-06-24 07:00:18',10,0),('5','181',257491,'DAILY ','2022-06-24','2022-06-24 10:36:09','2022-06-25 10:36:09','642',4023281.65,4023281.65,'642','2022-06-25 10:51:29','797','2022-06-25 11:02:27',10,0),('5','181',257492,'Daily','2022-06-25','2022-06-25 13:26:11','2022-06-26 13:26:11','642',593496.00,593496.00,'642','2022-06-25 18:18:17','797','2022-06-25 18:20:00',10,0),('5','181',257493,'DAILY ','2022-06-25','2022-06-25 18:23:33','2022-06-26 18:23:33','642',1645556.10,1645556.10,'642','2022-06-25 22:30:33','797','2022-06-26 08:58:49',10,0),('5','181',257494,'DAILY','2022-06-26','2022-06-26 11:46:54','2022-06-27 11:46:54','642',530834.70,530834.70,'642','2022-06-27 08:24:58','797','2022-06-27 09:35:46',10,0),('5','181',257495,'DAILY ','2022-06-27','2022-06-27 09:43:17','2022-06-28 09:43:17','642',5737044.15,5737044.15,'642','2022-06-27 23:06:57','797','2022-06-28 09:35:51',10,0),('5','181',257496,'DAILY ','2022-06-28','2022-06-28 10:40:44','2022-06-29 10:40:44','642',6747675.40,6747675.40,'642','2022-06-28 23:38:52','797','2022-06-29 09:26:50',10,0),('5','181',257497,'DAILY','2022-06-29','2022-06-29 09:34:17','2022-06-30 09:34:17','642',2261547.55,2261547.55,'642','2022-06-29 23:03:59','797','2022-06-30 07:14:33',10,0),('5','181',257498,'DAILY ','2022-06-30','2022-06-30 10:16:17','2022-07-01 10:16:17','642',3550571.10,3550571.10,'642','2022-07-01 06:57:47','797','2022-07-01 07:26:48',10,0),('5','181',257499,'DAILY','2022-07-01','2022-07-01 08:14:17','2022-07-02 08:14:17','642',2347889.20,2347889.20,'642','2022-07-01 23:13:32','797','2022-07-02 09:03:56',10,0),('5','181',257500,'DAILY','2022-07-02','2022-07-02 11:24:03','2022-07-03 11:24:03','642',3910258.80,3910258.80,'642','2022-07-03 08:46:54','797','2022-07-03 09:05:07',10,0),('5','181',257501,'DAILY','2022-07-03','2022-07-03 10:10:18','2022-07-04 10:10:18','642',2848742.95,2848742.95,'642','2022-07-04 07:02:13','797','2022-07-04 10:03:54',10,0),('5','181',257502,'DAILY','2022-07-04','2022-07-04 10:54:55','2022-07-05 10:54:55','642',4723217.25,4723217.25,'642','2022-07-04 22:06:21','797','2022-07-05 06:29:05',10,0),('5','181',257503,'DAILY ','2022-07-05','2022-07-05 09:54:00','2022-07-06 09:54:00','642',4654738.80,4654738.80,'642','2022-07-05 21:55:09','797','2022-07-06 06:25:12',10,0),('5','181',257504,'DAILY ','2022-07-06','2022-07-06 08:28:01','2022-07-07 08:28:01','642',3494770.30,3494770.30,'642','2022-07-06 23:31:53','797','2022-07-07 06:47:57',10,0),('5','181',257505,'DAILY','2022-07-07','2022-07-07 09:28:04','2022-07-08 09:28:04','642',3165630.20,3165630.20,'642','2022-07-07 22:10:18','797','2022-07-08 03:53:28',10,0),('5','181',257506,'DAILY ','2022-07-08','2022-07-08 07:53:01','2022-07-09 07:53:01','642',2722226.05,2722226.05,'642','2022-07-09 11:20:50','797','2022-07-09 11:27:35',10,0),('5','181',257507,'DAILY','2022-07-09','2022-07-09 11:44:09','2022-07-10 11:44:09','642',1416919.00,1416919.00,'642','2022-07-09 23:56:15','797','2022-07-10 06:51:51',10,0),('5','181',257508,'DAILY','2022-07-10','2022-07-10 09:48:11','2022-07-11 09:48:11','642',1310200.00,1310200.00,'642','2022-07-10 23:38:08','797','2022-07-11 07:37:21',10,0),('5','181',257509,'DAILY','2022-07-11','2022-07-11 07:45:10','2022-07-12 07:45:10','642',2024285.70,2024285.70,'642','2022-07-11 23:51:13','797','2022-07-12 08:39:28',10,0),('5','181',257510,'DAILY ','2022-07-12','2022-07-12 14:20:48','2022-07-13 14:20:48','642',2489543.40,2489543.40,'642','2022-07-12 23:42:20','797','2022-07-13 06:49:05',10,0),('5','181',257511,'DAILY ','2022-07-13','2022-07-13 07:46:10','2022-07-14 07:46:10','642',1671542.25,1671542.25,'642','2022-07-14 11:38:29','797','2022-07-14 13:34:59',10,0),('5','181',257512,'DAILY','2022-07-14','2022-07-14 14:37:00','2022-07-15 14:37:00','642',1395044.30,1395044.30,'642','2022-07-14 23:43:43','797','2022-07-15 06:36:25',10,0),('5','181',257513,'DAILY','2022-07-15','2022-07-15 08:02:52','2022-07-16 08:02:52','642',975070.25,975070.25,'642','2022-07-16 08:33:36','797','2022-07-16 10:59:57',10,0),('5','181',257514,'DAILY','2022-07-16','2022-07-16 12:17:39','2022-07-17 12:17:39','642',1157051.05,1157051.05,'642','2022-07-17 07:46:59','797','2022-07-17 11:37:01',10,0),('5','181',257515,'DAILY','2022-07-17','2022-07-17 14:12:03','2022-07-18 14:12:03','642',868160.60,868160.60,'642','2022-07-18 11:16:55','797','2022-07-18 11:58:23',10,0),('5','181',257516,'DAILY ','2022-07-18','2022-07-18 12:05:45','2022-07-19 12:05:45','642',1130879.10,1130879.10,'642','2022-07-18 23:21:52','797','2022-07-19 05:46:48',10,0),('5','181',257517,'DAILY','2022-07-19','2022-07-19 10:13:42','2022-07-20 10:13:42','642',1199086.75,1199086.75,'642','2022-07-20 07:17:02','797','2022-07-20 08:01:16',10,0),('5','181',257518,'DAILY','2022-07-20','2022-07-20 09:45:38','2022-07-21 09:45:38','642',1016280.85,1016280.85,'642','2022-07-21 06:32:34','797','2022-07-21 07:42:18',10,0),('5','181',257519,'DAILY','2022-07-21','2022-07-21 09:31:04','2022-07-22 09:31:04','642',1037735.30,1037735.30,'642','2022-07-21 21:37:52','797','2022-07-21 23:18:22',10,0),('5','181',257520,'DAILY','2022-07-22','2022-07-22 09:18:29','2022-07-23 09:18:29','642',1338943.05,1338943.05,'642','2022-07-22 21:00:15','797','2022-07-23 07:27:56',10,0),('5','181',257521,'DAILY ','2022-07-23','2022-07-23 09:27:37','2022-07-24 09:27:37','642',973420.05,973420.05,'642','2022-07-23 21:26:10','797','2022-07-24 06:54:52',10,0),('5','181',257522,'DAILY','2022-07-24','2022-07-24 09:11:09','2022-07-25 09:11:09','642',734646.10,734646.10,'642','2022-07-24 22:10:34','797','2022-07-25 06:39:55',10,0),('5','181',257523,'DAILY','2022-07-25','2022-07-25 08:10:47','2022-07-26 08:10:47','642',1552148.15,1552148.15,'642','2022-07-25 21:14:54','797','2022-07-26 07:38:13',10,0),('5','181',257524,'DAILY','2022-07-26','2022-07-26 08:27:49','2022-07-27 08:27:49','642',1802303.30,1802303.30,'642','2022-07-26 20:56:27','797','2022-07-27 06:53:04',10,0),('5','181',257525,'DAILY','2022-07-27','2022-07-27 10:33:59','2022-07-28 10:33:59','642',1071882.60,1071882.60,'642','2022-07-27 21:28:38','797','2022-07-28 07:25:20',10,0),('5','181',257526,'DAILY','2022-07-28','2022-07-28 08:51:25','2022-07-29 08:51:25','642',7128183.35,7128183.35,'642','2022-07-28 21:20:52','797','2022-07-29 06:54:41',10,0),('5','181',257527,'DAILY','2022-07-29','2022-07-29 08:48:12','2022-07-30 08:48:12','642',4320793.65,4320793.65,'642','2022-07-29 22:13:56','797','2022-07-30 06:58:03',10,0),('5','181',257528,'Daily','2022-07-30','2022-07-30 11:58:07','2022-07-31 11:58:07','642',2226720.80,2226720.80,'642','2022-07-30 22:01:22','797','2022-07-31 05:57:17',10,0),('5','181',257529,'Daily','2022-07-31','2022-07-31 08:51:48','2022-08-01 08:51:48','642',3578419.05,3578419.05,'642','2022-07-31 21:43:50','797','2022-08-01 06:47:08',10,0),('5','181',257530,'DAILY','2022-08-01','2022-08-01 11:22:32','2022-08-02 11:22:32','642',2706192.00,2706192.00,'642','2022-08-02 09:42:57','797','2022-08-02 10:14:19',10,0),('5','181',257531,'DAILY','2022-08-02','2022-08-02 11:15:43','2022-08-03 11:15:43','642',3612948.65,3612948.65,'642','2022-08-02 23:17:42','797','2022-08-03 06:34:52',10,0),('5','181',257532,'DAILY','2022-08-03','2022-08-03 11:05:42','2022-08-04 11:05:42','642',5039123.15,5039123.15,'642','2022-08-03 21:57:00','797','2022-08-04 06:48:18',10,0),('5','181',257533,'DAILY','2022-08-04','2022-08-04 07:45:47','2022-08-05 07:45:47','642',4166144.75,4166144.75,'642','2022-08-05 11:04:53','797','2022-08-05 11:09:36',10,0),('5','181',257534,'DAILY','2022-08-05','2022-08-05 12:08:11','2022-08-06 12:08:11','642',1772910.50,1772910.50,'642','2022-08-05 22:25:29','797','2022-08-06 09:08:48',10,0),('5','181',257535,'DAILY','2022-08-06','2022-08-06 09:59:45','2022-08-07 09:59:45','642',1376577.60,1376577.60,'642','2022-08-06 20:56:23','797','2022-08-07 07:10:20',10,0),('5','181',257536,'DAILY','2022-08-07','2022-08-07 08:29:33','2022-08-08 08:29:33','642',476839.35,476839.35,'642','2022-08-07 23:06:49','797','2022-09-03 08:13:29',10,0),('5','181',257537,'Daily','2022-09-03','2022-09-03 16:50:46','2022-09-04 16:50:46','642',0.00,0.00,'642','2022-09-05 15:14:41','797','2022-09-05 15:19:12',10,0),('5','181',257538,'Daily','2022-08-08','2022-09-05 15:24:33','2022-09-06 15:24:33','642',652820.60,652820.60,'642','2022-09-05 15:34:49','797','2022-09-05 15:37:48',10,0),('5','181',257539,'Daily','2022-08-09','2022-09-05 15:40:11','2022-09-06 15:40:11','642',1683922.54,1683922.54,'642','2022-09-05 15:47:28','797','2022-09-05 15:52:23',10,0),('5','181',257540,'Daily','2022-08-10','2022-09-05 16:12:36','2022-09-06 16:12:36','642',1063911.14,1063911.14,'642','2022-09-05 16:20:06','797','2022-09-05 16:22:00',10,0),('5','181',257541,'Daily','2022-08-11','2022-09-05 16:23:46','2022-09-06 16:23:46','642',1097821.45,1097821.45,'642','2022-09-05 16:26:36','797','2022-09-05 16:28:08',10,0),('5','181',257542,'Daily','2022-08-12','2022-09-05 16:29:06','2022-09-06 16:29:06','642',992434.35,992434.35,'642','2022-09-05 16:31:13','797','2022-09-05 16:32:10',10,0),('5','181',257543,'Daily','2022-08-13','2022-09-05 16:33:37','2022-09-06 16:33:37','642',2415010.85,2415010.85,'642','2022-09-05 16:58:37','797','2022-09-05 17:01:46',10,0),('5','181',257544,'Daily','2022-08-14','2022-09-06 11:22:26','2022-09-07 11:22:26','642',2574636.31,2574636.31,'642','2022-09-06 13:24:14','797','2022-09-06 13:28:06',10,0),('5','181',257545,'Daily','2022-08-15','2022-09-06 14:03:41','2022-09-07 14:03:41','642',3054250.10,3054250.10,'642','2022-09-06 14:16:20','797','2022-09-06 14:20:00',10,0),('5','181',257546,'Daily','2022-08-16','2022-09-06 14:21:44','2022-09-07 14:21:44','642',2884700.80,2884700.80,'642','2022-09-06 14:25:18','797','2022-09-06 14:26:20',10,0),('5','181',257547,'Daily','2022-08-17','2022-09-06 14:29:27','2022-09-07 14:29:27','642',3922757.75,3922757.75,'642','2022-09-06 15:28:17','797','2022-09-06 15:31:20',10,0),('5','181',257548,'Daily','2022-08-18','2022-09-06 16:17:07','2022-09-07 16:17:07','642',3135948.25,3135948.25,'642','2022-09-06 16:50:09','797','2022-09-06 16:52:12',10,0),('5','181',257549,'Daily','2022-08-19','2022-09-06 16:54:54','2022-09-07 16:54:54','642',3689950.25,3689950.25,'642','2022-09-06 16:58:22','797','2022-09-06 16:59:11',10,0),('5','181',257550,'Daily','2022-08-20','2022-09-06 17:00:43','2022-09-07 17:00:43','642',2353864.95,2353864.95,'642','2022-09-06 17:04:09','797','2022-09-06 17:28:45',10,0),('5','181',257551,'Daily','2022-08-21','2022-09-07 13:44:12','2022-09-08 13:44:12','642',2760475.00,2760475.00,'642','2022-09-07 13:49:06','797','2022-09-07 13:51:52',10,0),('5','181',257552,'Daily','2022-08-22','2022-09-07 13:56:50','2022-09-08 13:56:50','642',6461903.35,6461903.35,'642','2022-09-07 14:18:31','797','2022-09-07 14:22:08',10,0),('5','181',257553,'Daily','2022-08-23','2022-09-07 14:26:52','2022-09-08 14:26:52','642',3923948.50,3923948.50,'642','2022-09-07 14:32:53','797','2022-09-07 14:34:04',10,0),('5','181',257554,'Daily','2022-08-24','2022-09-07 14:35:33','2022-09-08 14:35:33','642',5539972.00,5539972.00,'642','2022-09-07 14:39:56','797','2022-09-07 14:41:19',10,0),('5','181',257555,'Daily','2022-08-25','2022-09-07 14:43:50','2022-09-08 14:43:50','642',5336142.40,5336142.40,'642','2022-09-07 15:21:49','797','2022-09-07 15:29:45',10,0),('5','181',257556,'Daily','2022-08-26','2022-09-07 15:32:02','2022-09-08 15:32:02','642',6166361.25,6166361.25,'642','2022-09-07 16:08:43','797','2022-09-07 16:12:29',10,0),('5','181',257557,'Daily','2022-08-27','2022-09-07 16:26:25','2022-09-08 16:26:25','642',2165742.75,2165742.75,'642','2022-09-07 16:30:10','797','2022-09-07 16:37:29',10,0),('5','181',257558,'Daily','2022-08-28','2022-09-07 16:38:52','2022-09-08 16:38:52','642',1992927.35,1992927.35,'642','2022-09-07 16:53:38','797','2022-09-07 16:55:50',10,0),('5','181',257559,'Daily','2022-08-29','2022-09-07 16:58:13','2022-09-08 16:58:13','642',2400434.10,2400434.10,'642','2022-09-07 17:02:41','797','2022-09-07 17:59:28',10,0),('5','181',257560,'Daily','2022-08-30','2022-09-07 20:16:24','2022-09-08 20:16:24','642',1472028.35,1472028.35,'642','2022-09-07 20:20:54','797','2022-09-07 21:50:02',10,0),('5','181',257561,'Daily','2022-08-31','2022-09-08 10:44:10','2022-09-09 10:44:10','642',5088424.86,5088424.86,'642','2022-09-08 10:48:10','797','2022-09-08 10:50:47',10,0),('5','181',257562,'Daily','2022-09-01','2022-09-08 10:57:50','2022-09-09 10:57:50','642',2111873.70,2111873.70,'642','2022-09-08 11:01:42','797','2022-09-08 11:02:29',10,0),('5','181',257563,'Daily','2022-09-02','2022-09-08 11:04:44','2022-09-09 11:04:44','642',1506270.30,1506270.30,'642','2022-09-08 11:09:00','797','2022-09-08 11:10:13',10,0),('5','181',257564,'Daily','2022-09-03','2022-09-08 11:15:29','2022-09-09 11:15:29','642',2162863.40,2162863.40,'642','2022-09-08 11:19:25','797','2022-09-08 11:20:36',10,0),('5','181',257565,'Daily','2022-09-04','2022-09-08 11:22:16','2022-09-09 11:22:16','642',1615258.45,1615258.45,'642','2022-09-08 11:26:31','797','2022-09-08 11:29:48',10,0),('5','181',257566,'Daily ','2022-09-05','2022-09-08 11:37:54','2022-09-09 11:37:54','642',1954435.90,1954435.90,'642','2022-09-08 11:42:16','797','2022-09-08 11:43:25',10,0),('5','181',257567,'Daily','2022-09-06','2022-09-08 11:50:34','2022-09-09 11:50:34','642',916694.75,916694.75,'642','2022-09-08 12:02:17','797','2022-09-08 12:13:10',10,0),('5','181',257568,'Daily','2022-09-07','2022-09-08 12:14:40','2022-09-09 12:14:40','642',2526542.20,2574418.80,'642','2022-09-08 12:20:18','797','2022-09-08 12:22:40',10,0),('5','181',257569,'Daily','2022-09-08','2022-09-08 12:28:04','2022-09-09 12:28:04','642',0.00,0.00,'600','2022-09-08 16:27:30','600','2022-09-08 16:27:55',10,0),('5','181',257570,'Daily','2022-09-08','2022-09-08 16:36:41','2022-09-09 16:36:41','642',2563703.15,2563703.15,'642','2022-09-08 22:01:56','797','2022-09-09 07:13:33',10,0),('5','181',257571,'Daily','2022-09-09','2022-09-09 09:49:27','2022-09-10 09:49:27','642',1650381.60,1650381.60,'642','2022-09-10 13:11:55','797','2022-09-10 16:18:36',10,0),('5','181',257572,'Daily','2022-09-10','2022-09-10 17:12:41','2022-09-11 17:12:41','642',1964581.40,1964581.40,'642','2022-09-10 22:45:07','797','2022-09-11 11:02:37',10,0),('5','181',257573,'Daily','2022-09-11','2022-09-11 11:29:20','2022-09-12 11:29:20','642',1745852.70,1745852.70,'642','2022-09-12 10:10:38','797','2022-09-12 10:38:24',10,0),('5','181',257574,'Daily','2022-09-12','2022-09-12 10:59:46','2022-09-13 10:59:46','642',1802887.65,1802887.65,'642','2022-09-12 23:09:35','797','2022-09-13 06:57:38',10,0),('5','181',257575,'Daily','2022-09-13','2022-09-13 10:21:54','2022-09-14 10:21:54','642',2807455.45,2807455.45,'642','2022-09-14 08:41:24','797','2022-09-14 09:13:43',10,0),('5','181',257576,'Daily','2022-09-14','2022-09-14 10:26:37','2022-09-15 10:26:37','642',915781.05,915781.05,'642','2022-09-15 09:56:25','797','2022-09-15 10:04:47',10,0),('5','181',257577,'Daily','2022-09-15','2022-09-15 10:49:50','2022-09-16 10:49:50','642',790653.00,790653.00,'642','2022-09-16 08:33:35','797','2022-09-16 09:33:06',10,0),('5','181',257578,'Daily','2022-09-16','2022-09-16 18:51:55','2022-09-17 18:51:55','642',742503.05,742503.05,'642','2022-09-17 10:53:04','797','2022-09-17 11:09:08',10,0),('5','181',257579,'Daily','2022-09-17','2022-09-17 11:49:49','2022-09-18 11:49:49','642',716647.45,716647.45,'642','2022-09-17 22:54:58','797','2022-09-18 10:31:23',10,0),('5','181',257580,'Daily','2022-09-18','2022-09-18 13:58:29','2022-09-19 13:58:29','642',446972.95,446972.95,'642','2022-09-19 06:05:21','797','2022-09-19 10:41:34',10,0),('5','181',257581,'Daily','2022-09-19','2022-09-19 10:53:33','2022-09-20 10:53:33','642',731567.70,731567.70,'642','2022-09-19 22:51:00','797','2022-09-20 08:58:03',10,0),('5','181',257582,'Daily','2022-09-20','2022-09-20 09:42:10','2022-09-21 09:42:10','642',697692.35,697692.35,'642','2022-09-20 22:44:07','797','2022-09-21 07:05:56',10,0),('5','181',257583,'Daily','2022-09-21','2022-09-21 09:33:11','2022-09-22 09:33:11','642',1336629.55,1336629.55,'642','2022-09-22 05:51:11','797','2022-09-22 09:13:25',10,0),('5','181',257584,'Daily','2022-09-22','2022-09-22 15:27:14','2022-09-23 15:27:14','642',1035146.85,1035146.85,'642','2022-09-22 23:18:03','797','2022-09-23 10:17:12',10,0),('5','181',257585,'Daily','2022-09-23','2022-09-23 11:54:10','2022-09-24 11:54:10','642',1523669.00,1523669.00,'642','2022-09-23 22:40:33','797','2022-09-24 08:48:54',10,0),('5','181',257586,'Daily','2022-09-24','2022-09-24 10:18:25','2022-09-25 10:18:25','642',2551637.05,2551637.05,'642','2022-09-25 09:48:24','797','2022-09-25 11:21:52',10,0),('5','181',257587,'Daily','2022-09-25','2022-09-25 12:06:45','2022-09-26 12:06:45','642',1802631.35,1802631.35,'642','2022-09-25 23:49:20','797','2022-09-26 10:03:32',10,0),('5','181',257588,'Daily','2022-09-26','2022-09-26 10:23:05','2022-09-27 10:23:05','642',4311809.65,4311809.65,'642','2022-09-27 08:37:32','797','2022-09-27 09:30:02',10,0),('5','181',257589,'Daily','2022-09-27','2022-09-27 09:56:36','2022-09-28 09:56:36','642',2602330.30,2602330.30,'642','2022-09-28 06:21:33','797','2022-09-28 06:38:49',10,0),('5','181',257590,'Daily','2022-09-28','2022-09-28 10:37:59','2022-09-29 10:37:59','642',2697522.90,2697522.90,'642','2022-09-29 06:51:37','797','2022-09-29 07:10:09',10,0),('5','181',257591,'Daily','2022-09-29','2022-09-29 08:24:03','2022-09-30 08:24:03','642',3143634.35,3143634.35,'642','2022-09-29 22:52:15','797','2022-09-30 07:20:45',10,0),('5','181',257592,'Daily','2022-09-30','2022-09-30 07:48:45','2022-10-01 07:48:45','642',6989987.25,6989987.25,'642','2022-10-01 09:54:32','797','2022-10-01 10:06:32',10,0),('5','181',257593,'Daily','2022-10-01','2022-10-01 23:01:13','2022-10-02 23:01:13','642',1517814.65,1517814.65,'642','2022-10-01 23:05:11','797','2022-10-02 06:55:26',10,0),('5','181',257594,'Daily','2022-10-02','2022-10-02 09:40:02','2022-10-03 09:40:02','642',1345817.75,1345817.75,'642','2022-10-02 22:49:45','797','2022-10-03 09:43:35',10,0),('5','181',257595,'Daily','2022-10-03','2022-10-03 10:45:21','2022-10-04 10:45:21','642',6292238.20,6292238.20,'642','2022-10-04 05:36:32','797','2022-10-04 07:10:29',10,0),('5','181',257596,'Daily','2022-10-04','2022-10-04 08:44:03','2022-10-05 08:44:03','642',4348119.95,4348119.95,'642','2022-10-05 06:35:12','797','2022-10-05 10:02:13',10,0),('5','181',257597,'Daily','2022-10-05','2022-10-05 10:58:18','2022-10-06 10:58:18','642',1809971.75,1809971.75,'642','2022-10-06 09:43:12','797','2022-10-06 10:18:44',10,0),('5','181',257598,'Daily','2022-10-06','2022-10-06 10:23:47','2022-10-07 10:23:47','642',6494474.00,6494474.00,'642','2022-10-06 22:57:58','797','2022-10-07 06:55:14',10,0),('5','181',257599,'Daily','2022-10-07','2022-10-07 11:21:30','2022-10-08 11:21:30','642',2045921.65,2045921.65,'642','2022-10-08 07:23:36','797','2022-10-08 11:33:07',10,0),('5','181',257600,'Daily','2022-10-08','2022-10-08 15:25:44','2022-10-09 15:25:44','642',5029105.95,5029105.95,'642','2022-10-09 11:38:56','797','2022-10-09 14:53:46',10,0),('5','181',257601,'Daily','2022-10-09','2022-10-09 15:09:34','2022-10-10 15:09:34','642',5040372.65,5040372.65,'642','2022-10-10 00:15:59','797','2022-10-10 08:54:33',10,0),('5','181',257602,'Daily','2022-10-10','2022-10-10 10:18:24','2022-10-11 10:18:24','642',5329286.75,5329286.75,'642','2022-10-10 23:39:30','797','2022-10-11 12:12:33',10,0),('5','181',257603,'Daily','2022-10-11','2022-10-11 12:41:19','2022-10-12 12:41:19','642',4706193.30,4706193.30,'642','2022-10-12 06:34:33','797','2022-10-12 12:28:24',10,0),('5','181',257604,'Daily','2022-10-12','2022-10-12 17:34:51','2022-10-13 17:34:51','642',8278911.65,8278911.65,'642','2022-10-13 09:59:10','797','2022-10-13 13:31:22',10,0),('5','181',257605,'Daily','2022-10-13','2022-10-13 18:43:50','2022-10-14 18:43:50','642',785896.35,785896.35,'642','2022-10-13 18:49:40','797','2022-10-13 20:33:44',10,0),('5','181',257606,'Daily','2022-10-13','2022-10-13 21:20:09','2022-10-14 21:20:09','642',2681001.25,2681001.25,'642','2022-10-13 23:25:47','797','2022-10-14 10:18:20',10,0),('5','181',257607,'Daily','2022-10-14','2022-10-14 12:50:31','2022-10-15 12:50:31','642',3014494.10,3014494.10,'642','2022-10-15 14:36:07','797','2022-10-15 16:25:27',10,0),('5','181',257608,'Daily','2022-10-15','2022-10-15 16:29:27','2022-10-16 16:29:27','642',1468845.60,1468845.60,'642','2022-10-15 22:59:11','797','2022-10-16 06:58:44',10,0),('5','181',257609,'Daily','2022-10-16','2022-10-16 10:03:03','2022-10-17 10:03:03','642',3967673.90,3967673.90,'642','2022-10-16 23:28:05','797','2022-10-17 20:04:47',10,0),('5','181',257610,'Daily','2022-10-17','2022-10-17 22:48:57','2022-10-18 22:48:57','642',2467872.20,2467872.20,'642','2022-10-18 05:42:09','797','2022-10-18 09:30:08',10,0),('5','181',257611,'Daily','2022-10-18','2022-10-18 11:31:23','2022-10-19 11:31:23','642',1642819.00,1642819.00,'642','2022-10-19 08:43:11','797','2022-10-19 09:40:38',10,0),('5','181',257612,'Daily','2022-10-19','2022-10-19 09:43:46','2022-10-20 09:43:46','642',2672326.10,2672326.10,'642','2022-10-20 10:14:58','797','2022-10-20 10:27:03',10,0),('5','181',257613,'Daily','2022-10-20','2022-10-21 08:05:23','2022-10-22 08:05:23','642',2263202.50,2263202.50,'642','2022-10-21 08:10:26','797','2022-10-21 09:30:10',10,0),('5','181',257614,'Daily','2022-10-21','2022-10-21 09:52:54','2022-10-22 09:52:54','642',3472587.20,3472587.20,'642','2022-10-22 08:57:54','797','2022-10-22 10:02:38',10,0),('5','181',257615,'Daily','2022-10-22','2022-10-23 11:54:07','2022-10-24 11:54:07','642',3211087.40,3211087.40,'642','2022-10-23 11:55:50','797','2022-10-23 13:51:05',10,0),('5','181',257616,'Daily','2022-10-23','2022-10-23 15:00:09','2022-10-24 15:00:09','642',3121472.30,3121472.30,'642','2022-10-24 06:24:52','797','2022-10-24 07:29:38',10,0),('5','181',257617,'Daily','2022-10-24','2022-10-24 09:43:16','2022-10-25 09:43:16','642',4665551.95,4665551.95,'642','2022-10-25 06:59:29','797','2022-10-25 09:21:44',10,0),('5','181',257618,'Daily','2022-10-25','2022-10-25 11:23:27','2022-10-26 11:23:27','642',3118304.80,3118304.80,'642','2022-10-26 06:09:46','797','2022-10-26 06:11:14',10,0),('5','181',257619,'Daily','2022-10-26','2022-10-26 08:47:50','2022-10-27 08:47:50','642',6514286.35,6514286.35,'642','2022-10-27 06:50:33','797','2022-10-27 06:59:44',10,0),('5','181',257620,'Daily','2022-10-27','2022-10-27 08:30:54','2022-10-28 08:30:54','642',4946889.70,4946889.70,'642','2022-10-28 07:06:38','797','2022-10-28 08:52:58',10,0),('5','181',257621,'Daily','2022-10-28','2022-10-28 09:50:22','2022-10-29 09:50:22','642',9905648.25,9905648.25,'642','2022-10-29 06:05:42','797','2022-10-29 08:33:11',10,0),('5','181',257622,'Daily','2022-10-29','2022-10-29 13:21:45','2022-10-30 13:21:45','642',3102164.45,3102164.45,'642','2022-10-29 23:43:11','797','2022-10-30 06:50:04',10,0),('5','181',257623,'Daily','2022-10-30','2022-10-30 10:25:55','2022-10-31 10:25:55','642',4698148.00,4698148.00,'642','2022-10-30 23:35:03','797','2022-10-31 06:58:40',10,0),('5','181',257624,'Daily','2022-10-31','2022-10-31 13:40:58','2022-11-01 13:40:58','642',7370835.95,7370835.95,'642','2022-11-01 06:38:24','797','2022-11-01 06:55:43',10,0),('5','181',257625,'Daily','2022-11-01','2022-11-01 08:11:13','2022-11-02 08:11:13','642',15625067.10,15625067.10,'642','2022-11-02 10:51:01','797','2022-11-02 11:45:53',10,0),('5','181',257626,'Daily','2022-11-02','2022-11-02 12:14:43','2022-11-03 12:14:43','642',10851481.15,10851481.15,'642','2022-11-03 07:19:34','797','2022-11-03 09:12:40',10,0),('5','181',257627,'Daily','2022-11-03','2022-11-03 11:15:02','2022-11-04 11:15:02','642',10977325.65,10977325.65,'642','2022-11-04 21:09:46','797','2022-11-04 22:41:00',10,0),('5','181',257628,'Daily','2022-11-04','2022-11-05 06:30:07','2022-11-06 06:30:07','642',16899754.75,16899754.75,'642','2022-11-05 13:47:20','797','2022-11-05 14:16:24',10,0),('5','181',257629,'Daily','2022-11-05','2022-11-05 16:22:32','2022-11-06 16:22:32','642',8703420.95,8703420.95,'642','2022-11-06 08:04:47','797','2022-11-06 08:12:15',10,0),('5','181',257630,'Daily','2022-11-06','2022-11-07 06:19:43','2022-11-08 06:19:43','642',4323636.55,4323636.55,'642','2022-11-07 09:03:57','797','2022-11-07 14:16:30',10,0),('5','181',257631,'Daily','2022-11-07','2022-11-07 15:18:07','2022-11-08 15:18:07','642',7558745.75,7558745.75,'642','2022-11-08 06:35:34','797','2022-11-08 07:40:51',10,0),('5','181',257632,'Daily','2022-11-08','2022-11-08 08:37:22','2022-11-09 08:37:22','642',15847234.65,15847234.65,'642','2022-11-09 09:57:39','797','2022-11-09 10:17:23',10,0),('5','181',257633,'Daily','2022-11-09','2022-11-09 11:27:16','2022-11-10 11:27:16','642',8162510.50,8162510.50,'642','2022-11-10 09:20:21','797','2022-11-10 10:40:26',10,0),('5','181',257634,'Daily','2022-11-10','2022-11-10 10:58:47','2022-11-11 10:58:47','642',3531882.40,3531882.40,'642','2022-11-10 17:48:11','797','2022-11-10 18:16:05',10,0),('5','181',257635,'Daily','2022-11-10','2022-11-10 18:27:18','2022-11-11 18:27:18','642',4557596.40,4557596.40,'642','2022-11-11 09:29:22','797','2022-11-11 11:25:14',10,0),('5','181',257636,'Daily','2022-11-11','2022-11-11 12:51:08','2022-11-12 12:51:08','642',5624178.00,5624178.00,'642','2022-11-12 08:33:54','797','2022-11-12 09:55:55',10,0),('5','181',257637,'Daily','2022-11-12','2022-11-12 12:35:59','2022-11-13 12:35:59','642',4055252.70,4055252.70,'642','2022-11-13 08:26:25','797','2022-11-13 15:34:09',10,0),('5','181',257638,'Daily','2022-11-13','2022-11-13 17:23:50','2022-11-14 17:23:50','642',8301844.50,8301844.50,'642','2022-11-14 07:17:19','797','2022-11-14 07:20:34',10,0),('5','181',257639,'Daily','2022-11-14','2022-11-14 09:15:14','2022-11-15 09:15:14','642',9801420.00,9801420.00,'642','2022-11-15 07:17:14','797','2022-11-15 11:44:28',10,0),('5','181',257640,'Daily','2022-11-15','2022-11-15 12:36:45','2022-11-16 12:36:45','642',6482396.10,6482396.10,'642','2022-11-16 06:41:08','797','2022-11-16 07:49:56',10,0),('5','181',257641,'Daily','2022-11-16','2022-11-16 09:12:29','2022-11-17 09:12:29','642',6877323.90,6877323.90,'642','2022-11-17 07:17:20','797','2022-11-17 09:33:05',10,0),('5','181',257642,'Daily','2022-11-17','2022-11-17 10:50:27','2022-11-18 10:50:27','642',7992411.60,7992411.60,'642','2022-11-18 06:12:49','797','2022-11-18 08:15:49',10,0),('5','181',257643,'Daily','2022-11-18','2022-11-18 09:01:33','2022-11-19 09:01:33','642',5495285.40,5495285.40,'642','2022-11-18 23:13:43','797','2022-11-19 09:13:36',10,0),('5','181',257644,'Daily','2022-11-19','2022-11-19 14:48:56','2022-11-20 14:48:56','642',11645762.90,11645762.90,'642','2022-11-20 09:22:57','797','2022-11-20 14:49:29',10,0),('5','181',257645,'Daily','2022-11-20','2022-11-21 07:05:38','2022-11-22 07:05:38','642',8021097.50,8021097.50,'642','2022-11-21 07:08:25','797','2022-11-21 09:34:03',10,0),('5','181',257646,'Daily','2022-11-21','2022-11-21 10:44:09','2022-11-22 10:44:09','642',1174417.00,1174417.00,'642','2022-11-22 06:27:35','797','2022-11-22 09:00:50',10,0),('5','181',257647,'Daily','2022-11-22','2022-11-22 10:39:52','2022-11-23 10:39:52','642',1255398.90,1255398.90,'642','2022-11-23 06:56:24','797','2022-11-23 09:34:23',10,0),('5','181',257648,'Daily','2022-11-23','2022-11-23 09:39:00','2022-11-24 09:39:00','642',0.00,0.00,'600','2022-11-23 15:19:07','600','2022-11-23 15:19:30',10,0),('5','181',257649,'Daily','2022-11-23','2022-11-23 15:31:20','2022-11-24 15:31:20','642',3599390.50,3599390.50,'642','2022-11-24 07:28:17','797','2022-11-24 08:52:47',10,0),('5','181',257650,'Daily','2022-11-24','2022-11-24 09:43:52','2022-11-25 09:43:52','642',4418540.10,4418540.10,'642','2022-11-25 06:47:00','797','2022-11-25 10:47:22',10,0),('5','181',257651,'Daily','2022-11-25','2022-11-25 11:11:22','2022-11-26 11:11:22','642',11817968.90,11817968.90,'642','2022-11-26 06:24:38','797','2022-11-26 07:37:30',10,0),('5','181',257652,'Daily','2022-11-26','2022-11-26 11:53:05','2022-11-27 11:53:05','642',841418.85,841418.85,'642','2022-11-27 10:39:02','797','2022-11-27 12:32:45',10,0),('5','181',257653,'Daily','2022-11-27','2022-11-28 08:28:54','2022-11-29 08:28:54','642',539593.20,539593.20,'642','2022-11-28 08:29:41','797','2022-11-28 09:45:03',10,0),('5','181',257654,'Daily','2022-11-28','2022-11-28 10:30:14','2022-11-29 10:30:14','642',294712.40,294712.40,'642','2022-11-29 07:38:59','797','2022-11-29 09:41:10',10,0),('5','181',257655,'Daily','2022-11-29','2022-11-29 10:02:46','2022-11-30 10:02:46','642',1741414.25,1741414.25,'642','2022-11-30 08:56:27','797','2022-11-30 09:01:13',10,0),('5','181',257656,'Daily','2022-11-30','2022-11-30 11:16:00','2022-12-01 11:16:00','642',2312265.05,2312265.05,'642','2022-12-01 07:26:55','797','2022-12-01 10:41:36',10,0),('5','181',257657,'Daily','2022-12-01','2022-12-01 12:32:26','2022-12-02 12:32:26','642',2715391.15,2715391.15,'642','2022-12-01 23:10:18','797','2022-12-02 09:56:37',10,0),('5','181',257658,'Daily','2022-12-02','2022-12-02 11:13:54','2022-12-03 11:13:54','642',483022.05,483022.05,'642','2022-12-02 22:25:22','797','2022-12-03 10:03:41',10,0),('5','181',257659,'Daily','2022-12-03','2022-12-03 11:59:30','2022-12-04 11:59:30','642',0.00,0.00,'642','2022-12-03 17:13:35','797','2022-12-03 17:21:28',10,0),('5','181',257660,'Daily','2022-12-03','2022-12-03 17:35:47','2022-12-04 17:35:47','642',3444356.00,3444356.00,'642','2022-12-04 10:48:14','797','2022-12-04 10:53:30',10,0),('5','181',257661,'Daily','2022-12-04','2022-12-04 11:39:53','2022-12-05 11:39:53','642',6646876.30,6646876.30,'642','2022-12-05 10:50:57','797','2022-12-05 10:54:23',10,0),('5','181',257662,'Daily','2022-12-05','2022-12-05 12:04:09','2022-12-06 12:04:09','642',6691129.55,6691129.55,'642','2022-12-06 07:25:24','797','2022-12-06 09:20:08',10,0),('5','181',257663,'Daily','2022-12-06','2022-12-06 12:00:46','2022-12-07 12:00:46','642',7305740.85,7305740.85,'642','2022-12-07 09:34:29','797','2022-12-07 10:33:11',10,0),('5','181',257664,'Daily','2022-12-07','2022-12-07 11:01:05','2022-12-08 11:01:05','642',6202026.00,6202026.00,'642','2022-12-08 07:00:38','797','2022-12-08 09:23:21',10,0),('5','181',257665,'Daily','2022-12-08','2022-12-08 11:16:19','2022-12-09 11:16:19','642',2811519.00,2811519.00,'642','2022-12-09 06:36:36','797','2022-12-09 09:13:56',10,0),('5','181',257666,'Daily','2022-12-09','2022-12-09 10:56:30','2022-12-10 10:56:30','642',0.00,0.00,'642','2022-12-10 08:59:01','797','2022-12-10 10:00:15',10,0),('5','181',257667,'Daily','2022-12-09','2022-12-10 10:06:37','2022-12-11 10:06:37','642',4625892.00,4625892.00,'642','2022-12-10 10:14:03','797','2022-12-10 13:08:27',10,0),('5','181',257668,'Daily','2022-12-10','2022-12-10 13:13:36','2022-12-11 13:13:36','642',4229361.90,4229361.90,'642','2022-12-11 06:39:40','446','2022-12-11 11:15:51',10,0),('5','181',257669,'Daily','2022-12-11','2022-12-11 14:03:46','2022-12-12 14:03:46','642',7947981.00,7815514.65,'642','2022-12-12 11:13:30','797','2022-12-12 11:46:07',10,0),('5','181',257670,'Daily','2022-12-12','2022-12-12 18:40:51','2022-12-13 18:40:51','642',4308984.00,4237167.60,'642','2022-12-13 07:21:08','797','2022-12-13 09:50:22',10,0),('5','181',257671,'Daily','2022-12-13','2022-12-13 09:51:14','2022-12-14 09:51:14','642',8647512.00,8647512.00,'642','2022-12-14 11:05:09','797','2022-12-14 11:08:23',10,0),('5','181',257672,'Daily','2022-12-14','2022-12-14 11:21:43','2022-12-15 11:21:43','642',10745316.00,10745316.00,'642','2022-12-15 06:44:06','797','2022-12-15 09:47:56',10,0),('5','181',257673,'Daily','2022-12-15','2022-12-15 10:58:00','2022-12-16 10:58:00','642',7859304.45,7859304.45,'642','2022-12-16 06:53:39','797','2022-12-16 09:57:31',10,0),('5','181',257674,'Daily','2022-12-16','2022-12-16 10:10:28','2022-12-17 10:10:28','642',7219971.60,7219971.60,'642','2022-12-16 23:37:11','797','2022-12-17 12:08:44',10,0),('5','181',257675,'Daily','2022-12-17','2022-12-17 13:41:00','2022-12-18 13:41:00','642',8898542.25,8898542.25,'642','2022-12-18 09:17:47','797','2022-12-18 12:29:16',10,0),('5','181',257676,'Daily','2022-12-18','2022-12-18 12:40:07','2022-12-19 12:40:07','642',5376692.55,5376692.55,'642','2022-12-19 10:59:13','797','2022-12-19 11:01:46',10,0),('5','181',257677,'Daily','2022-12-19','2022-12-19 11:11:14','2022-12-20 11:11:14','642',11966718.75,11966718.75,'642','2022-12-20 08:38:32','797','2022-12-20 08:58:29',10,0),('5','181',257678,'Daily','2022-12-20','2022-12-20 09:33:10','2022-12-21 09:33:10','642',8345636.70,8345636.70,'642','2022-12-21 09:30:10','797','2022-12-21 09:38:30',10,0),('5','181',257679,'Daily','2022-12-21','2022-12-21 11:22:27','2022-12-22 11:22:27','642',8227092.75,8227092.75,'642','2022-12-22 09:03:05','797','2022-12-22 09:25:29',10,0),('5','181',257680,'Daily','2022-12-22','2022-12-22 15:06:10','2022-12-23 15:06:10','642',7181725.35,7181725.35,'642','2022-12-23 10:27:31','797','2022-12-23 10:43:11',10,0),('5','181',257681,'Daily','2022-12-23','2022-12-23 12:29:38','2022-12-24 12:29:38','642',6524255.45,6524255.45,'642','2022-12-24 09:35:53','797','2022-12-24 19:13:12',10,0),('5','181',257682,'Daily','2022-12-24','2022-12-24 19:22:38','2022-12-25 19:22:38','642',6789347.80,6789347.80,'642','2022-12-25 15:17:40','797','2022-12-25 15:53:42',10,0),('5','181',257683,'Daily','2022-12-25','2022-12-25 16:00:52','2022-12-26 16:00:52','642',3916394.20,3916394.20,'642','2022-12-26 07:28:35','797','2022-12-26 08:20:27',10,0),('5','181',257684,'Daily','2022-12-26','2022-12-26 09:04:21','2022-12-27 09:04:21','642',7217316.60,7217316.60,'642','2022-12-27 08:27:04','797','2022-12-27 09:01:12',10,0),('5','181',257685,'Daily','2022-12-27','2022-12-27 09:28:29','2022-12-28 09:28:29','642',6995933.85,6995933.85,'642','2022-12-27 23:20:52','797','2022-12-28 09:11:50',10,0),('5','181',257686,'Daily','2022-12-28','2022-12-28 10:15:54','2022-12-29 10:15:54','642',7299462.30,7299462.30,'642','2022-12-29 06:41:18','797','2022-12-29 09:56:06',10,0),('5','181',257687,'Daily','2022-12-29','2022-12-29 13:00:47','2022-12-30 13:00:47','642',6985827.15,6985827.15,'642','2022-12-30 09:17:46','797','2022-12-30 10:05:00',10,0),('5','181',257688,'Daily','2022-12-30','2022-12-30 13:51:11','2022-12-31 13:51:11','642',6946488.90,6946488.90,'642','2022-12-31 07:18:27','797','2022-12-31 17:44:20',10,0),('5','181',257689,'Daily','2022-12-31','2022-12-31 17:54:33','2023-01-01 17:54:33','642',3295855.05,3295855.05,'642','2023-01-01 07:35:11','797','2023-01-01 08:50:15',10,0),('5','181',257690,'Daily','2023-01-01','2023-01-01 11:57:28','2023-01-02 11:57:28','642',0.00,0.00,'642','2023-01-01 16:26:00','797','2023-01-01 16:32:01',10,0),('5','181',257691,'Daily','2023-01-01','2023-01-01 16:37:52','2023-01-02 16:37:52','642',3216736.05,3216736.05,'642','2023-01-01 23:18:44','797','2023-01-02 08:18:43',10,0),('5','181',257692,'Daily','2023-01-02','2023-01-02 09:32:43','2023-01-03 09:32:43','642',5659092.40,5659092.40,'642','2023-01-03 09:27:06','797','2023-01-03 10:31:54',10,0),('5','181',257693,'Daily','2023-01-03','2023-01-03 12:18:04','2023-01-04 12:18:04','642',7762317.00,7762317.00,'642','2023-01-04 08:43:55','797','2023-01-04 19:32:06',10,0),('5','181',257694,'Daily','2023-01-04','2023-01-04 19:35:33','2023-01-05 19:35:33','642',8715747.40,8715747.40,'642','2023-01-04 23:19:49','797','2023-01-05 08:55:07',10,0),('5','181',257695,'Daily','2023-01-05','2023-01-05 10:00:51','2023-01-06 10:00:51','642',5918657.60,5918657.60,'642','2023-01-06 10:26:37','797','2023-01-06 14:58:57',10,0),('5','181',257696,'Daily','2023-01-06','2023-01-06 15:21:24','2023-01-07 15:21:24','642',6670719.00,6670719.00,'642','2023-01-07 09:20:24','797','2023-01-07 12:21:01',10,0),('5','181',257697,'Daily','2023-01-07','2023-01-07 13:24:36','2023-01-08 13:24:36','642',5571277.80,5571277.80,'642','2023-01-08 06:34:33','797','2023-01-08 09:19:05',10,0),('5','181',257698,'Daily','2023-01-08','2023-01-08 11:43:50','2023-01-09 11:43:50','642',8019474.20,8019474.20,'642','2023-01-09 09:39:36','797','2023-01-09 09:43:35',10,0),('5','181',257699,'Daily','2023-01-09','2023-01-09 11:11:45','2023-01-10 11:11:45','642',6010316.40,6010316.40,'642','2023-01-10 09:04:28','797','2023-01-10 09:14:41',10,0),('5','181',257700,'Daily','2023-01-10','2023-01-10 11:09:45','2023-01-11 11:09:45','642',9323612.60,9323612.60,'642','2023-01-11 09:27:55','797','2023-01-11 09:40:23',10,0),('5','181',257701,'Daily','2023-01-11','2023-01-11 12:43:48','2023-01-12 12:43:48','642',7578612.40,7578612.40,'642','2023-01-11 23:07:54','797','2023-01-12 09:24:01',10,0),('5','181',257702,'Daily','2023-01-12','2023-01-12 15:52:57','2023-01-13 15:52:57','642',6457697.00,6457697.00,'642','2023-01-13 08:21:53','797','2023-01-13 09:19:17',10,0),('5','181',257703,'Daily','2023-01-13','2023-01-13 12:23:28','2023-01-14 12:23:28','642',3948320.20,3948320.20,'642','2023-01-14 09:22:16','797','2023-01-14 16:50:21',10,0),('5','181',257704,'Daily','2023-01-14','2023-01-14 20:53:00','2023-01-15 20:53:00','642',11560911.20,11560911.20,'642','2023-01-15 09:23:43','797','2023-01-15 10:27:03',10,0),('5','181',257705,'Daily','2023-01-15','2023-01-15 12:59:11','2023-01-16 12:59:11','642',6224208.00,6224208.00,'642','2023-01-16 10:41:38','797','2023-01-16 11:01:40',10,0),('5','181',257706,'Daily','2023-01-16','2023-01-16 19:01:24','2023-01-17 19:01:24','642',9638444.05,9638444.05,'642','2023-01-17 13:34:56','797','2023-01-17 13:42:39',10,0),('5','181',257707,'Daily','2023-01-17','2023-01-17 15:22:41','2023-01-18 15:22:41','642',8789109.65,8789109.65,'642','2023-01-17 23:18:05','797','2023-01-18 09:11:00',10,0),('5','181',257708,'Daily','2023-01-18','2023-01-18 16:44:52','2023-01-19 16:44:52','642',6434639.00,6434639.00,'642','2023-01-18 23:46:59','797','2023-01-19 09:15:29',10,0),('5','181',257709,'Daily','2023-01-19','2023-01-19 10:03:04','2023-01-20 10:03:04','642',9161490.60,9161490.60,'642','2023-01-19 23:56:02','797','2023-01-20 09:24:44',10,0),('5','181',257710,'Daily','2023-01-20','2023-01-20 09:40:30','2023-01-21 09:40:30','642',9990.00,9990.00,'642','2023-01-20 14:51:17','797','2023-01-20 14:53:09',10,0),('5','181',257711,'Daily','2023-01-20','2023-01-21 11:59:31','2023-01-22 11:59:31','642',11287249.10,11287249.10,'642','2023-01-21 12:31:45','797','2023-01-21 13:25:04',10,0),('5','181',257712,'Daily','2023-01-21','2023-01-21 13:35:18','2023-01-22 13:35:18','642',3133413.80,3133413.80,'642','2023-01-22 07:02:41','797','2023-01-22 10:40:22',10,0),('5','181',257713,'Daily','2023-01-22','2023-01-22 13:14:59','2023-01-23 13:14:59','642',1866029.00,1866029.00,'642','2023-01-23 06:58:38','797','2023-01-23 09:05:16',10,0),('5','181',257714,'Daily','2023-01-23','2023-01-23 10:12:59','2023-01-24 10:12:59','642',11604638.40,11604638.40,'642','2023-01-24 06:55:54','797','2023-01-24 07:02:42',10,0),('5','181',257715,'Daily','2023-01-24','2023-01-24 11:26:45','2023-01-25 11:26:45','642',7259140.90,7259140.90,'642','2023-01-25 06:55:20','797','2023-01-25 09:19:29',10,0),('5','181',257716,'Daily','2023-01-25','2023-01-25 10:32:27','2023-01-26 10:32:27','642',7422789.90,7422789.90,'642','2023-01-26 10:04:37','797','2023-01-26 10:08:28',10,0),('5','181',257717,'Daily','2023-01-26','2023-01-27 11:04:35','2023-01-28 11:04:35','642',9192566.60,9192566.60,'642','2023-01-27 11:17:40','797','2023-01-27 11:20:39',10,0),('5','181',257718,'Daily','2023-01-27','2023-01-27 13:21:44','2023-01-28 13:21:44','642',8885695.50,8885695.50,'642','2023-01-28 08:25:33','797','2023-01-28 09:42:16',10,0),('5','181',257719,'Daily','2023-01-28','2023-01-28 13:54:34','2023-01-29 13:54:34','642',6319026.60,6319026.60,'642','2023-01-28 23:20:16','797','2023-01-29 10:58:14',10,0),('5','181',257720,'Daily','2023-01-29','2023-01-29 22:51:51','2023-01-30 22:51:51','642',4023830.20,4023830.20,'642','2023-01-29 22:53:34','797','2023-01-30 09:20:34',10,0),('5','181',257721,'Daily','2023-01-30','2023-01-30 09:58:45','2023-01-31 09:58:45','642',7831606.10,7831606.10,'642','2023-01-31 08:12:29','797','2023-01-31 09:07:21',10,0),('5','181',257722,'Daily','2023-01-31','2023-01-31 10:07:31','2023-02-01 10:07:31','642',6899184.10,6899184.10,'642','2023-02-01 07:04:19','797','2023-02-01 13:52:21',10,0),('5','181',257723,'Daily','2023-02-01','2023-02-01 20:17:51','2023-02-02 20:17:51','642',7411758.90,7411758.90,'642','2023-02-01 22:39:40','797','2023-02-02 11:27:13',10,0),('5','181',257724,'Daily','2023-02-02','2023-02-02 13:31:51','2023-02-03 13:31:51','642',10171052.40,10171052.40,'642','2023-02-03 12:07:09','797','2023-02-03 13:55:28',10,0),('5','181',257725,'Daily','2023-02-03','2023-02-03 17:03:56','2023-02-04 17:03:56','642',17781701.30,17781701.30,'642','2023-02-04 10:17:07','797','2023-02-04 13:18:24',10,0),('5','181',257726,'Daily','2023-02-04','2023-02-04 15:03:51','2023-02-05 15:03:51','642',9892189.80,9892189.80,'642','2023-02-05 11:31:10','797','2023-02-05 11:48:49',10,0),('5','181',257727,'Daily','2023-02-05','2023-02-05 16:03:58','2023-02-06 16:03:58','642',3865813.40,3865813.40,'642','2023-02-06 06:57:09','797','2023-02-06 09:05:59',10,0),('5','181',257728,'Daily','2023-02-06','2023-02-06 10:02:01','2023-02-07 10:02:01','642',6382477.20,6382477.20,'642','2023-02-07 07:41:12','797','2023-02-07 09:06:37',10,0),('5','181',257729,'Daily','2023-02-07','2023-02-07 10:13:21','2023-02-08 10:13:21','642',7530891.50,7530891.50,'642','2023-02-08 08:59:09','797','2023-02-08 09:23:00',10,0),('5','181',257730,'Daily','2023-02-08','2023-02-08 11:39:07','2023-02-09 11:39:07','642',10583991.10,10583991.10,'642','2023-02-09 06:49:22','797','2023-02-09 09:22:56',10,0),('5','181',257731,'Daily','2023-02-09','2023-02-09 12:00:41','2023-02-10 12:00:41','642',10813000.70,10813000.70,'642','2023-02-10 07:04:51','797','2023-02-10 09:01:45',10,0),('5','181',257732,'Daily','2023-02-10','2023-02-10 17:09:59','2023-02-11 17:09:59','642',12345564.50,12345564.50,'642','2023-02-11 11:01:56','797','2023-02-12 05:59:27',10,0),('5','181',257733,'Daily','2023-02-11','2023-02-12 06:51:55','2023-02-13 06:51:55','642',7761396.40,7761396.40,'642','2023-02-12 07:28:56','797','2023-02-12 07:36:19',10,0),('5','181',257734,'Daily','2023-02-12','2023-02-12 10:58:29','2023-02-13 10:58:29','642',4530754.20,4530754.20,'642','2023-02-13 08:29:53','797','2023-02-13 09:12:07',10,0),('5','181',257735,'Daily','2023-02-13','2023-02-13 09:51:44','2023-02-14 09:51:44','642',4438142.80,4438142.80,'642','2023-02-14 07:13:16','797','2023-02-14 09:34:21',10,0),('5','181',257736,'Daily','2023-02-14','2023-02-14 10:29:27','2023-02-15 10:29:27','642',2987668.00,2987668.00,'642','2023-02-15 06:15:13','797','2023-02-15 09:21:47',10,0),('5','181',257737,'Daily','2023-02-15','2023-02-15 10:01:20','2023-02-16 10:01:20','642',5437645.40,5437645.40,'642','2023-02-15 23:17:57','797','2023-02-16 08:41:28',10,0),('5','181',257738,'Daily','2023-02-16','2023-02-16 16:25:31','2023-02-17 16:25:31','642',7885805.10,7885805.10,'642','2023-02-17 07:34:19','797','2023-02-17 12:20:08',10,0),('5','181',257739,'Daily','2023-02-17','2023-02-17 16:43:40','2023-02-18 16:43:40','642',3317568.10,3317568.10,'642','2023-02-18 10:50:47','797','2023-02-18 16:26:00',10,0),('5','181',257740,'Daily','2023-02-18','2023-02-18 16:51:41','2023-02-19 16:51:41','642',3197035.50,3197035.50,'642','2023-02-18 23:20:15','797','2023-02-19 08:31:05',10,0),('5','181',257741,'Daily','2023-02-19','2023-02-19 12:14:20','2023-02-20 12:14:20','642',3534173.20,3534173.20,'642','2023-02-19 22:33:40','797','2023-02-20 09:17:37',10,0),('5','181',257742,'Daily','2023-02-20','2023-02-20 11:06:19','2023-02-21 11:06:19','642',2763659.30,2763659.30,'642','2023-02-21 07:17:40','797','2023-02-21 08:51:04',10,0),('5','181',257743,'Daily','2023-02-21','2023-02-21 09:46:24','2023-02-22 09:46:24','642',1127541.00,1127541.00,'642','2023-02-22 07:29:48','797','2023-02-22 09:48:36',10,0),('5','181',257744,'Daily','2023-02-22','2023-02-22 10:32:35','2023-02-23 10:32:35','642',4997047.20,4997047.20,'642','2023-02-22 23:08:42','797','2023-02-23 06:57:58',10,0),('5','181',257745,'Daily','2023-02-23','2023-02-23 09:29:01','2023-02-24 09:29:01','642',902016.40,902016.40,'642','2023-02-24 11:18:25','797','2023-02-24 18:49:58',10,0),('5','181',257746,'Daily','2023-02-24','2023-02-24 20:51:01','2023-02-25 20:51:01','642',2218259.70,2218259.70,'642','2023-02-25 11:58:13','797','2023-02-25 15:52:34',10,0),('5','181',257747,'Daily','2023-02-25','2023-02-25 18:34:06','2023-02-26 18:34:06','642',0.00,0.00,'642','2023-02-26 07:57:55','797','2023-02-26 11:16:36',10,0),('5','181',257748,'Daily','2023-02-26','2023-02-26 12:45:45','2023-02-27 12:45:45','642',1026150.60,1026150.60,'642','2023-02-27 15:29:16','797','2023-02-27 15:37:55',10,0),('5','181',257749,'Daily','2023-02-27','2023-02-27 21:08:56','2023-02-28 21:08:56','642',5297794.00,5297794.00,'642','2023-02-28 06:08:47','797','2023-02-28 10:20:58',10,0),('5','181',257750,'Daily','2023-02-28','2023-02-28 11:33:14','2023-03-01 11:33:14','642',4824872.80,4824872.80,'642','2023-03-01 07:39:32','797','2023-03-01 09:32:53',10,0),('5','181',257751,'Daily','2023-03-01','2023-03-01 12:16:39','2023-03-02 12:16:39','642',5811134.50,5811134.50,'642','2023-03-02 07:12:06','797','2023-03-02 10:06:37',10,0),('5','181',257752,'Daily','2023-03-02','2023-03-02 14:31:41','2023-03-03 14:31:41','642',12475915.60,12475915.60,'642','2023-03-03 07:40:21','797','2023-03-03 09:18:42',10,0),('5','181',257753,'Daily','2023-03-03','2023-03-03 11:39:22','2023-03-04 11:39:22','642',12969871.90,12969871.90,'642','2023-03-04 07:40:34','797','2023-03-04 08:44:46',10,0),('5','181',257754,'Daily','2023-03-04','2023-03-04 14:40:41','2023-03-05 14:40:41','642',11841038.10,11841038.10,'642','2023-03-05 08:58:42','797','2023-03-05 09:42:11',10,0),('5','181',257755,'Daily','2023-03-05','2023-03-05 11:40:44','2023-03-06 11:40:44','642',10916669.92,10916669.92,'642','2023-03-06 07:26:33','797','2023-03-06 08:59:10',10,0),('5','181',257756,'Daily','2023-03-06','2023-03-06 09:02:37','2023-03-07 09:02:37','642',9026826.60,9026826.60,'642','2023-03-07 11:56:35','797','2023-03-07 13:49:28',10,0),('5','181',257757,'Daily','2023-03-07','2023-03-07 17:48:23','2023-03-08 17:48:23','642',10652549.60,10652549.60,'642','2023-03-08 07:35:34','797','2023-03-08 09:49:16',10,0),('5','181',257758,'Daily','2023-03-08','2023-03-08 10:43:49','2023-03-09 10:43:49','642',8428750.90,8428750.90,'642','2023-03-09 07:06:56','797','2023-03-09 09:48:06',10,0),('5','181',257759,'Daily','2023-03-09','2023-03-09 13:35:34','2023-03-10 13:35:34','642',4767676.80,4767676.80,'642','2023-03-10 07:47:39','797','2023-03-10 09:16:47',10,0),('5','181',257760,'Daily','2023-03-10','2023-03-10 12:11:39','2023-03-11 12:11:39','642',15408450.70,15408450.70,'642','2023-03-11 12:48:01','797','2023-03-11 17:34:36',10,0),('5','181',257761,'Daily','2023-03-11','2023-03-11 18:23:28','2023-03-12 18:23:28','642',7830230.90,7830230.90,'642','2023-03-12 08:51:35','797','2023-03-12 08:57:46',10,0),('5','181',257762,'Daily','2023-03-12','2023-03-12 12:16:16','2023-03-13 12:16:16','642',4153521.80,4153521.80,'642','2023-03-13 07:05:09','797','2023-03-13 09:58:42',10,0),('5','181',257763,'Daily','2023-03-13','2023-03-13 11:11:34','2023-03-14 11:11:34','642',9133610.20,9133610.20,'642','2023-03-14 10:57:46','797','2023-03-14 12:29:08',10,0),('5','181',257764,'Daily','2023-03-14','2023-03-14 15:03:44','2023-03-15 15:03:44','642',7656249.80,7656249.80,'642','2023-03-15 09:35:45','797','2023-03-15 12:04:43',10,0),('5','181',257765,'Daily','2023-03-15','2023-03-15 13:00:51','2023-03-16 13:00:51','642',13489278.80,13489278.80,'642','2023-03-16 08:06:50','797','2023-03-16 09:31:38',10,0),('5','181',257766,'Daily 6','2023-03-16','2023-03-16 10:31:56','2023-03-17 10:31:56','642',8989815.80,8989815.80,'642','2023-03-17 07:57:32','797','2023-03-17 16:14:23',10,0),('5','181',257767,'Daily','2023-03-17','2023-03-17 18:26:29','2023-03-18 18:26:29','642',5273895.60,5273895.60,'642','2023-03-18 10:34:34','797','2023-03-18 11:00:35',10,0),('5','181',257768,'Daily','2023-03-18','2023-03-18 12:53:16','2023-03-19 12:53:16','642',0.00,0.00,'642','2023-03-19 09:18:29','797','2023-03-19 11:34:54',10,0),('5','181',257769,'Daily','2023-03-19','2023-03-19 13:03:32','2023-03-20 13:03:32','642',2200347.00,2200347.00,'642','2023-03-20 07:30:47','797','2023-03-20 12:16:48',10,0),('5','181',257770,'Daily','2023-03-20','2023-03-20 12:33:01','2023-03-21 12:33:01','642',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908576 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','181','967','213310',4131041,'2863','435',77.61,898.86,821.25,135506.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','213310',4131042,'2864','435',82.76,378.03,295.27,48719.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','213310',4131043,'2865','435',55.94,223.42,167.48,27634.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','213310',4131044,'2866','435',83.49,477.25,393.76,64970.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','213310',4131045,'2867','435',96.86,600.59,503.73,83115.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','213310',4131046,'2868','435',112.41,255.56,143.15,23619.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','213310',4131047,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213310',4131048,'2870','435',56.30,156.66,100.36,16559.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','213310',4131049,'2871','435',75.85,535.27,459.42,75804.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','213310',4131050,'2872','435',56.06,104.23,48.17,7948.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','213310',4131051,'2873','435',42.48,248.85,206.37,34051.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','213310',4131052,'2874','435',118.67,807.69,689.02,113688.30,0.00,0.00,0.00,0.00,0.00),('5','181','972','213310',4131053,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213310',4131054,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213310',4131055,'2877','436',115.04,1594.59,1479.55,436467.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','213310',4131056,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213773',4138831,'2863','435',898.86,898.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213773',4138832,'2864','435',378.03,378.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213773',4138833,'2865','435',223.42,223.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213773',4138834,'2866','435',477.25,477.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213773',4138835,'2867','435',600.59,600.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213773',4138836,'2868','435',255.56,255.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213773',4138837,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213773',4138838,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213773',4138839,'2871','435',535.27,535.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213773',4138840,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213773',4138841,'2873','435',248.85,248.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213773',4138842,'2874','435',807.69,807.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213773',4138843,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213773',4138844,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213773',4138845,'2877','436',1594.59,1594.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','213773',4138846,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213775',4138869,'2863','435',898.86,898.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213775',4138870,'2864','435',378.03,378.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213775',4138871,'2865','435',223.42,223.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213775',4138872,'2866','435',477.25,477.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213775',4138873,'2867','435',600.59,600.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213775',4138874,'2868','435',255.56,255.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213775',4138875,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213775',4138876,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213775',4138877,'2871','435',535.27,535.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213775',4138878,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213775',4138879,'2873','435',248.85,248.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213775',4138880,'2874','435',807.69,807.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213775',4138881,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213775',4138882,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213775',4138883,'2877','436',1594.59,1594.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','213775',4138884,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213777',4138891,'2863','435',898.86,1649.76,750.90,123898.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','213777',4138892,'2864','435',378.03,736.66,358.63,59173.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','213777',4138893,'2865','435',223.42,223.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213777',4138894,'2866','435',477.25,560.03,82.78,13658.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','213777',4138895,'2867','435',600.59,992.06,391.47,64592.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','213777',4138896,'2868','435',255.56,303.90,48.34,7976.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','213777',4138897,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213777',4138898,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213777',4138899,'2871','435',535.27,535.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213777',4138900,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213777',4138901,'2873','435',248.85,248.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213777',4138902,'2874','435',807.69,807.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213777',4138903,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213777',4138904,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213777',4138905,'2877','436',1594.59,2264.04,669.45,197487.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','213777',4138906,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213780',4138945,'2863','435',1649.76,3289.68,1639.92,270586.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','213780',4138946,'2864','435',736.66,1316.11,579.45,95609.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','213780',4138947,'2865','435',223.42,411.87,188.45,31094.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','213780',4138948,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213780',4138949,'2867','435',992.06,1625.29,633.23,104482.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','213780',4138950,'2868','435',303.90,329.32,25.42,4194.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','213780',4138951,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213780',4138952,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213780',4138953,'2871','435',535.27,1159.13,623.86,102936.90,0.00,0.00,0.00,0.00,0.00),('5','181','970','213780',4138954,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213780',4138955,'2873','435',248.85,402.89,154.04,25416.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','213780',4138956,'2874','435',807.69,807.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213780',4138957,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213780',4138958,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213780',4138959,'2877','436',2264.04,2825.08,561.04,165506.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','213780',4138960,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213782',4138965,'2863','435',3289.68,5017.53,1727.85,285095.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','213782',4138966,'2864','435',1316.11,1765.94,449.83,74221.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','213782',4138967,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213782',4138968,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213782',4138969,'2867','435',1625.29,2195.24,569.95,94041.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','213782',4138970,'2868','435',329.32,686.58,357.26,58947.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','213782',4138971,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213782',4138972,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213782',4138973,'2871','435',1159.13,1441.69,282.56,46622.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','213782',4138974,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213782',4138975,'2873','435',402.89,444.19,41.30,6814.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','213782',4138976,'2874','435',807.69,989.85,182.16,30056.40,0.00,0.00,0.00,0.00,0.00),('5','181','972','213782',4138977,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213782',4138978,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213782',4138979,'2877','436',2825.08,3516.75,691.67,204042.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','213782',4138980,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213795',4139174,'2863','435',5017.53,6550.48,1532.95,252936.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','213795',4139175,'2864','435',1765.94,2325.38,559.44,92307.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','213795',4139176,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213795',4139177,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213795',4139178,'2867','435',2195.24,2810.78,615.54,101564.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','213795',4139179,'2868','435',686.58,790.23,103.65,17102.25,0.00,0.00,0.00,0.00,0.00),('5','181','969','213795',4139180,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213795',4139181,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213795',4139182,'2871','435',1441.69,1945.33,503.64,83100.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','213795',4139183,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213795',4139184,'2873','435',444.19,722.50,278.31,45921.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','213795',4139185,'2874','435',989.85,1075.53,85.68,14137.20,0.00,0.00,0.00,0.00,0.00),('5','181','972','213795',4139186,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213795',4139187,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213795',4139188,'2877','436',3516.75,4518.86,1002.11,295622.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','213795',4139189,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213798',4139232,'2863','435',6550.48,7723.34,1172.86,193521.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','213798',4139233,'2864','435',2325.38,2986.13,660.75,109023.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','213798',4139234,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213798',4139235,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213798',4139236,'2867','435',2810.78,3843.04,1032.26,170322.90,0.00,0.00,0.00,0.00,0.00),('5','181','968','213798',4139237,'2868','435',790.23,1143.23,353.00,58245.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213798',4139238,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213798',4139239,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213798',4139240,'2871','435',1945.33,2545.21,599.88,98980.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','213798',4139241,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213798',4139242,'2873','435',722.50,933.71,211.21,34849.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','213798',4139243,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213798',4139244,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213798',4139245,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213798',4139246,'2877','436',4518.86,5012.64,493.78,145665.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','213798',4139247,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213799',4139248,'2863','435',7723.34,8626.73,903.39,149059.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','213799',4139249,'2864','435',2986.13,3556.90,570.77,94177.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','213799',4139250,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213799',4139251,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213799',4139252,'2867','435',3843.04,5054.67,1211.63,199918.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','213799',4139253,'2868','435',1143.23,1346.94,203.71,33612.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','213799',4139254,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213799',4139255,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213799',4139256,'2871','435',2545.21,2545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213799',4139257,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213799',4139258,'2873','435',933.71,1112.71,179.00,29535.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213799',4139259,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213799',4139260,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213799',4139261,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213799',4139262,'2877','436',5012.64,5173.31,160.67,47397.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','213799',4139263,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213803',4139307,'2863','435',8626.73,9783.32,1156.59,190837.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','213803',4139308,'2864','435',3556.90,3594.93,38.03,6274.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','213803',4139309,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213803',4139310,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213803',4139311,'2867','435',5054.67,5891.99,837.32,138157.80,0.00,0.00,0.00,0.00,0.00),('5','181','968','213803',4139312,'2868','435',1346.94,1817.28,470.34,77606.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','213803',4139313,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213803',4139314,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213803',4139315,'2871','435',2545.21,2978.97,433.76,71570.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','213803',4139316,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213803',4139317,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213803',4139318,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213803',4139319,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213803',4139320,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213803',4139321,'2877','436',5173.31,5305.96,132.65,39131.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','213803',4139322,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213808',4139389,'2863','435',9783.32,10590.38,807.06,133164.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','213808',4139390,'2864','435',3594.93,4592.75,997.82,164640.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','213808',4139391,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213808',4139392,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213808',4139393,'2867','435',5891.99,7025.58,1133.59,187042.35,0.00,0.00,0.00,0.00,0.00),('5','181','968','213808',4139394,'2868','435',1817.28,1817.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213808',4139395,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213808',4139396,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213808',4139397,'2871','435',2978.97,3299.54,320.57,52894.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','213808',4139398,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213808',4139399,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213808',4139400,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213808',4139401,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213808',4139402,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213808',4139403,'2877','436',5305.96,6139.21,833.25,245808.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','213808',4139404,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213810',4139417,'2863','435',10590.38,10590.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213810',4139418,'2864','435',4592.75,5801.98,1209.23,199522.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','213810',4139419,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213810',4139420,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213810',4139421,'2867','435',7025.58,8589.18,1563.60,257994.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213810',4139422,'2868','435',1817.28,2005.69,188.41,31087.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','213810',4139423,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213810',4139424,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213810',4139425,'2871','435',3299.54,4504.94,1205.40,198891.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213810',4139426,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213810',4139427,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213810',4139428,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213810',4139429,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213810',4139430,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213810',4139431,'2877','436',6139.21,7378.34,1239.13,365543.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','213810',4139432,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213812',4139450,'2863','435',10590.38,10590.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213812',4139451,'2864','435',5801.98,7321.24,1519.26,250677.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','213812',4139452,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213812',4139453,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213812',4139454,'2867','435',8589.18,10196.39,1607.21,265189.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','213812',4139455,'2868','435',2005.69,2934.18,928.49,153200.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','213812',4139456,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213812',4139457,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213812',4139458,'2871','435',4504.94,5404.94,900.00,148500.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213812',4139459,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213812',4139460,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213812',4139461,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213812',4139462,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213812',4139463,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213812',4139464,'2877','436',7378.34,8398.95,1020.61,301079.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','213812',4139465,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213814',4139489,'2863','435',10590.38,10590.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213814',4139490,'2864','435',7321.24,8433.97,1112.73,183600.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','213814',4139491,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213814',4139492,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213814',4139493,'2867','435',10196.39,11863.10,1666.71,275007.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','213814',4139494,'2868','435',2934.18,3742.24,808.06,133329.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','213814',4139495,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213814',4139496,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213814',4139497,'2871','435',5404.94,6438.31,1033.37,170506.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','213814',4139498,'2872','435',104.23,104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213814',4139499,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213814',4139500,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213814',4139501,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213814',4139502,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213814',4139503,'2877','436',8398.95,11432.53,3033.58,894906.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','213814',4139504,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213817',4139531,'2863','435',10590.38,12251.04,1660.66,274008.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','213817',4139532,'2864','435',8433.97,9132.58,698.61,115270.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','213817',4139533,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213817',4139534,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213817',4139535,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213817',4139536,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213817',4139537,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213817',4139538,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213817',4139539,'2871','435',6438.31,7323.25,884.94,146015.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','213817',4139540,'2872','435',104.23,450.63,346.40,57156.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213817',4139541,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213817',4139542,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213817',4139543,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213817',4139544,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213817',4139545,'2877','436',11432.53,14609.09,3176.56,937085.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','213817',4139546,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213969',4141961,'2863','435',12251.04,14033.33,1782.29,294077.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','213969',4141962,'2864','435',9132.58,10250.35,1117.77,184432.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','213969',4141963,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213969',4141964,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213969',4141965,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213969',4141966,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213969',4141967,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213969',4141968,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213969',4141969,'2871','435',7323.25,8375.71,1052.46,173655.90,0.00,0.00,0.00,0.00,0.00),('5','181','970','213969',4141970,'2872','435',450.63,450.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213969',4141971,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213969',4141972,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213969',4141973,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213969',4141974,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213969',4141975,'2877','436',14609.09,14609.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','213969',4141976,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213975',4142085,'2863','435',14033.33,16202.41,2169.08,357898.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','213975',4142086,'2864','435',10250.35,11526.06,1275.71,210492.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','213975',4142087,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213975',4142088,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213975',4142089,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213975',4142090,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213975',4142091,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213975',4142092,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213975',4142093,'2871','435',8375.71,9530.15,1154.44,190482.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','213975',4142094,'2872','435',450.63,450.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213975',4142095,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213975',4142096,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213975',4142097,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213975',4142098,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213975',4142099,'2877','436',14609.09,14609.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','213975',4142100,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213976',4142101,'2863','435',16202.41,18345.85,2143.44,353667.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','213976',4142102,'2864','435',11526.06,12606.90,1080.84,178338.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','213976',4142103,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','213976',4142104,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213976',4142105,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','213976',4142106,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213976',4142107,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','213976',4142108,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','213976',4142109,'2871','435',9530.15,10742.17,1212.02,199983.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','213976',4142110,'2872','435',450.63,450.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213976',4142111,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','213976',4142112,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213976',4142113,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','213976',4142114,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','213976',4142115,'2877','436',14609.09,14705.56,96.47,28458.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','213976',4142116,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214051',4143382,'2863','435',18345.85,20350.39,2004.54,330749.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','214051',4143383,'2864','435',12606.90,13502.94,896.04,147846.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','214051',4143384,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214051',4143385,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214051',4143386,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214051',4143387,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214051',4143388,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214051',4143389,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','214051',4143390,'2871','435',10742.17,12007.15,1264.98,208721.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','214051',4143391,'2872','435',450.63,450.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214051',4143392,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214051',4143393,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214051',4143394,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214051',4143395,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','214051',4143396,'2877','436',14705.56,15523.68,818.12,241345.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','214051',4143397,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214874',4157514,'2863','435',20350.39,22672.22,2321.83,383101.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','214874',4157515,'2864','435',13502.94,14543.04,1040.10,171616.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','214874',4157516,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214874',4157517,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214874',4157518,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214874',4157519,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214874',4157520,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214874',4157521,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','214874',4157522,'2871','435',12007.15,13349.54,1342.39,221494.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','214874',4157523,'2872','435',450.63,450.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214874',4157524,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214874',4157525,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214874',4157526,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214874',4157527,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','214874',4157528,'2877','436',15523.68,17497.02,1973.34,582135.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','214874',4157529,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214876',4157532,'2863','435',22672.22,24681.21,2008.99,331483.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','214876',4157533,'2864','435',14543.04,15493.36,950.32,156802.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','214876',4157534,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214876',4157535,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214876',4157536,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214876',4157537,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214876',4157538,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214876',4157539,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','214876',4157540,'2871','435',13349.54,14491.32,1141.78,188393.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','214876',4157541,'2872','435',450.63,627.33,176.70,29155.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','214876',4157542,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214876',4157543,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214876',4157544,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214876',4157545,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','214876',4157546,'2877','436',17497.02,17792.50,295.48,87166.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','214876',4157547,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214936',4158590,'2863','435',24681.21,25674.26,993.05,163853.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','214936',4158591,'2864','435',15493.36,16053.64,560.28,92446.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','214936',4158592,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214936',4158593,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214936',4158594,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214936',4158595,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214936',4158596,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214936',4158597,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','214936',4158598,'2871','435',14491.32,16960.28,2468.96,407378.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','214936',4158599,'2872','435',627.33,1708.74,1081.41,178432.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','214936',4158600,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214936',4158601,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214936',4158602,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214936',4158603,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','214936',4158604,'2877','436',17792.50,19356.68,1564.18,461433.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','214936',4158605,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214941',4158660,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214941',4158661,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214941',4158662,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','214941',4158663,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214941',4158664,'2867','435',11863.10,11863.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','214941',4158665,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214941',4158666,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','214941',4158667,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','214941',4158668,'2871','435',16960.28,19261.60,2301.32,379717.80,0.00,0.00,0.00,0.00,0.00),('5','181','970','214941',4158669,'2872','435',1708.74,3336.05,1627.31,268506.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','214941',4158670,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','214941',4158671,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214941',4158672,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','214941',4158673,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','214941',4158674,'2877','436',19356.68,20152.64,795.96,234808.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','214941',4158675,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215047',4160287,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215047',4160288,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215047',4160289,'2865','435',411.87,411.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215047',4160290,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215047',4160291,'2867','435',11863.10,12526.01,662.91,109380.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','215047',4160292,'2868','435',3742.24,3742.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215047',4160293,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215047',4160294,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','215047',4160295,'2871','435',19261.60,21024.82,1763.22,290931.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','215047',4160296,'2872','435',3336.05,5792.73,2456.68,405352.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','215047',4160297,'2873','435',1112.71,1112.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215047',4160298,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215047',4160299,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215047',4160300,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','215047',4160301,'2877','436',20152.64,23025.89,2873.25,847608.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','215047',4160302,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215300',4164653,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215300',4164654,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215300',4164655,'2865','435',411.87,1916.02,1504.15,248184.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','215300',4164656,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215300',4164657,'2867','435',12526.01,12526.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215300',4164658,'2868','435',3742.24,4957.53,1215.29,200522.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','215300',4164659,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215300',4164660,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','215300',4164661,'2871','435',21024.82,22542.92,1518.10,250486.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','215300',4164662,'2872','435',5792.73,5792.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215300',4164663,'2873','435',1112.71,1260.08,147.37,24316.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','215300',4164664,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215300',4164665,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215300',4164666,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','215300',4164667,'2877','436',23025.89,26148.56,3122.67,921187.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','215300',4164668,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215655',4170806,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215655',4170807,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215655',4170808,'2865','435',1916.02,3214.57,1298.55,214260.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','215655',4170809,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215655',4170810,'2867','435',12526.01,13295.16,769.15,126909.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','215655',4170811,'2868','435',4957.53,6375.83,1418.30,234019.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','215655',4170812,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215655',4170813,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','215655',4170814,'2871','435',22542.92,23429.59,886.67,146300.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','215655',4170815,'2872','435',5792.73,5792.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215655',4170816,'2873','435',1260.08,1260.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215655',4170817,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215655',4170818,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215655',4170819,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','215655',4170820,'2877','436',26148.56,29007.70,2859.14,843446.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','215655',4170821,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215874',4174601,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215874',4174602,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215874',4174603,'2865','435',3214.57,4309.81,1095.24,180714.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','215874',4174604,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215874',4174605,'2867','435',13295.16,14495.74,1200.58,198095.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','215874',4174606,'2868','435',6375.83,6948.14,572.31,94431.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','215874',4174607,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215874',4174608,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','215874',4174609,'2871','435',23429.59,25186.82,1757.23,289942.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','215874',4174610,'2872','435',5792.73,5802.73,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215874',4174611,'2873','435',1260.08,1260.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215874',4174612,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215874',4174613,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215874',4174614,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','215874',4174615,'2877','436',29007.70,30654.71,1647.01,485867.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','215874',4174616,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215982',4176287,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215982',4176288,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','215982',4176289,'2865','435',4309.81,5055.44,745.63,123028.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','215982',4176290,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','215982',4176291,'2867','435',14495.74,15292.49,796.75,131463.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','215982',4176292,'2868','435',6948.14,7862.65,914.51,150894.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','215982',4176293,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','215982',4176294,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','215982',4176295,'2871','435',25186.82,26571.26,1384.44,228432.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','215982',4176296,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215982',4176297,'2873','435',1260.08,1260.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','215982',4176298,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215982',4176299,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','215982',4176300,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','215982',4176301,'2877','436',30654.71,31581.14,926.43,273296.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','215982',4176302,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216212',4180228,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216212',4180229,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216212',4180230,'2865','435',5055.44,6241.26,1185.82,195660.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','216212',4180231,'2866','435',560.03,560.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','216212',4180232,'2867','435',15292.49,16736.39,1443.90,238243.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','216212',4180233,'2868','435',7862.65,8805.59,942.94,155585.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','216212',4180234,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','216212',4180235,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','216212',4180236,'2871','435',26571.26,27290.44,719.18,118664.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','216212',4180237,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216212',4180238,'2873','435',1260.08,1437.84,177.76,29330.40,0.00,0.00,0.00,0.00,0.00),('5','181','971','216212',4180239,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216212',4180240,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216212',4180241,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','216212',4180242,'2877','436',31581.14,34016.75,2435.61,718504.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','216212',4180243,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216376',4183005,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216376',4183006,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216376',4183007,'2865','435',6241.26,6497.59,256.33,42294.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','216376',4183008,'2866','435',560.03,1069.84,509.81,84118.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','216376',4183009,'2867','435',16736.39,18409.81,1673.42,276114.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','216376',4183010,'2868','435',8805.59,9469.39,663.80,109527.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','216376',4183011,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','216376',4183012,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','216376',4183013,'2871','435',27290.44,28096.25,805.81,132958.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','216376',4183014,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216376',4183015,'2873','435',1437.84,2373.09,935.25,154316.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','216376',4183016,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216376',4183017,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216376',4183018,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','216376',4183019,'2877','436',34016.75,36583.43,2566.68,757170.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','216376',4183020,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216571',4186411,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216571',4186412,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216571',4186413,'2865','435',6497.59,6497.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216571',4186414,'2866','435',1069.84,1817.62,747.78,123383.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','216571',4186415,'2867','435',18409.81,19922.04,1512.23,249517.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','216571',4186416,'2868','435',9469.39,10263.22,793.83,130981.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','216571',4186417,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','216571',4186418,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','216571',4186419,'2871','435',28096.25,28814.58,718.33,118524.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','216571',4186420,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216571',4186421,'2873','435',2373.09,2373.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216571',4186422,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216571',4186423,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216571',4186424,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','216571',4186425,'2877','436',36583.43,38458.80,1875.37,553234.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','216571',4186426,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216872',4191777,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216872',4191778,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216872',4191779,'2865','435',6497.59,6497.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','216872',4191780,'2866','435',1817.62,2730.02,912.40,150546.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','216872',4191781,'2867','435',19922.04,21251.81,1329.77,219412.05,0.00,0.00,0.00,0.00,0.00),('5','181','968','216872',4191782,'2868','435',10263.22,10801.78,538.56,88862.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','216872',4191783,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','216872',4191784,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','216872',4191785,'2871','435',28814.58,29632.94,818.36,135029.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','216872',4191786,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216872',4191787,'2873','435',2373.09,2373.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','216872',4191788,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216872',4191789,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','216872',4191790,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','216872',4191791,'2877','436',38458.80,41417.96,2959.16,872952.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','216872',4191792,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217253',4199108,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217253',4199109,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217253',4199110,'2865','435',6497.59,6497.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217253',4199111,'2866','435',2730.02,3453.13,723.11,119313.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','217253',4199112,'2867','435',21251.81,22746.30,1494.49,246590.85,0.00,0.00,0.00,0.00,0.00),('5','181','968','217253',4199113,'2868','435',10801.78,12367.16,1565.38,258287.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','217253',4199114,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217253',4199115,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217253',4199116,'2871','435',29632.94,29821.20,188.26,31062.90,0.00,0.00,0.00,0.00,0.00),('5','181','970','217253',4199117,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','217253',4199118,'2873','435',2373.09,2956.31,583.22,96231.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','217253',4199119,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217253',4199120,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217253',4199121,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','217253',4199122,'2877','436',41417.96,42207.38,789.42,232878.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','217253',4199123,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217420',4201700,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217420',4201701,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217420',4201702,'2865','435',6497.59,6497.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217420',4201703,'2866','435',3453.13,4183.43,730.30,120499.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','217420',4201704,'2867','435',22746.30,24636.56,1890.26,311892.90,0.00,0.00,0.00,0.00,0.00),('5','181','968','217420',4201705,'2868','435',12367.16,13492.36,1125.20,185658.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217420',4201706,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217420',4201707,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217420',4201708,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217420',4201709,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','217420',4201710,'2873','435',2956.31,3230.56,274.25,45251.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','217420',4201711,'2874','435',1075.53,1075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217420',4201712,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217420',4201713,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','217420',4201714,'2877','436',42207.38,45084.13,2876.75,848641.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','217420',4201715,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217692',4206578,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217692',4206579,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217692',4206580,'2865','435',6497.59,7210.95,713.36,117704.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','217692',4206581,'2866','435',4183.43,4574.87,391.44,64587.60,0.00,0.00,0.00,0.00,0.00),('5','181','968','217692',4206582,'2867','435',24636.56,25031.76,395.20,65208.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','217692',4206583,'2868','435',13492.36,13756.03,263.67,43505.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','217692',4206584,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217692',4206585,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217692',4206586,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217692',4206587,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','217692',4206588,'2873','435',3230.56,3940.09,709.53,117072.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','217692',4206589,'2874','435',1075.53,1343.66,268.13,44241.45,0.00,0.00,0.00,0.00,0.00),('5','181','972','217692',4206590,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217692',4206591,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','217692',4206592,'2877','436',45084.13,45742.97,658.84,194357.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','217692',4206593,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217968',4211611,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217968',4211612,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','217968',4211613,'2865','435',7210.95,8604.42,1393.47,229922.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','217968',4211614,'2866','435',4574.87,5057.43,482.56,79622.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','217968',4211615,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','217968',4211616,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217968',4211617,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','217968',4211618,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217968',4211619,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','217968',4211620,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','217968',4211621,'2873','435',3940.09,5380.62,1440.53,237687.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','217968',4211622,'2874','435',1343.66,1479.17,135.51,22359.15,0.00,0.00,0.00,0.00,0.00),('5','181','972','217968',4211623,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','217968',4211624,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','217968',4211625,'2877','436',45742.97,47916.06,2173.09,641061.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','217968',4211626,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218198',4215548,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218198',4215549,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218198',4215550,'2865','435',8604.42,10220.70,1616.28,266686.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','218198',4215551,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218198',4215552,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218198',4215553,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218198',4215554,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218198',4215555,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218198',4215556,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218198',4215557,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','218198',4215558,'2873','435',5380.62,7000.56,1619.94,267290.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','218198',4215559,'2874','435',1479.17,2010.50,531.33,87669.45,0.00,0.00,0.00,0.00,0.00),('5','181','972','218198',4215560,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','218198',4215561,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218198',4215562,'2877','436',47916.06,50320.83,2404.77,709407.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','218198',4215563,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218198',4215564,'2910','436',42.82,716.37,673.55,198697.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','218280',4216742,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218280',4216743,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218280',4216744,'2865','435',10220.70,11733.38,1512.68,249592.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','218280',4216745,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218280',4216746,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218280',4216747,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218280',4216748,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218280',4216749,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218280',4216750,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218280',4216751,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','218280',4216752,'2873','435',7000.56,8552.33,1551.77,256042.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','218280',4216753,'2874','435',2010.50,2705.06,694.56,114602.40,0.00,0.00,0.00,0.00,0.00),('5','181','972','218280',4216754,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','218280',4216755,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218280',4216756,'2877','436',50320.83,51104.22,783.39,231100.05,0.00,0.00,0.00,0.00,0.00),('5','181','974','218280',4216757,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218280',4216758,'2910','436',716.37,856.21,139.84,41252.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','218551',4221684,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218551',4221685,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218551',4221686,'2865','435',11733.38,13702.41,1969.03,324889.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','218551',4221687,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218551',4221688,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218551',4221689,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218551',4221690,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218551',4221691,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218551',4221692,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218551',4221693,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','218551',4221694,'2873','435',8552.33,9796.50,1244.17,205288.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','218551',4221695,'2874','435',2705.06,2838.16,133.10,21961.50,0.00,0.00,0.00,0.00,0.00),('5','181','972','218551',4221696,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','218551',4221697,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218551',4221698,'2877','436',51104.22,54329.90,3225.68,951575.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','218551',4221699,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218551',4221700,'2910','436',856.21,902.45,46.24,13640.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','218731',4224687,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218731',4224688,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','218731',4224689,'2865','435',13702.41,15794.91,2092.50,345262.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','218731',4224690,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218731',4224691,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','218731',4224692,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218731',4224693,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','218731',4224694,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218731',4224695,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','218731',4224696,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','218731',4224697,'2873','435',9796.50,11104.52,1308.02,215823.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','218731',4224698,'2874','435',2838.16,3435.77,597.61,98605.65,0.00,0.00,0.00,0.00,0.00),('5','181','972','218731',4224699,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','218731',4224700,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218731',4224701,'2877','436',54329.90,55833.40,1503.50,443532.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','218731',4224702,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','218731',4224703,'2910','436',902.45,1167.51,265.06,78192.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','219068',4230725,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219068',4230726,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219068',4230727,'2865','435',15794.91,17587.66,1792.75,295803.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','219068',4230728,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219068',4230729,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219068',4230730,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219068',4230731,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219068',4230732,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219068',4230733,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219068',4230734,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','219068',4230735,'2873','435',11104.52,12635.54,1531.02,252618.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','219068',4230736,'2874','435',3435.77,3754.93,319.16,52661.40,0.00,0.00,0.00,0.00,0.00),('5','181','972','219068',4230737,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219068',4230738,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219068',4230739,'2877','436',55833.40,58134.66,2301.26,678871.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','219068',4230740,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219068',4230741,'2910','436',1167.51,2136.49,968.98,285849.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','219308',4235027,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219308',4235028,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219308',4235029,'2865','435',17587.66,19744.42,2156.76,355865.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','219308',4235030,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219308',4235031,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219308',4235032,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219308',4235033,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219308',4235034,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219308',4235035,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219308',4235036,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','219308',4235037,'2873','435',12635.54,13738.38,1102.84,181968.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','219308',4235038,'2874','435',3754.93,3754.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219308',4235039,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219308',4235040,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219308',4235041,'2877','436',58134.66,59466.17,1331.51,392795.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','219308',4235042,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219308',4235043,'2910','436',2136.49,2163.26,26.77,7897.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','219462',4237456,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219462',4237457,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219462',4237458,'2865','435',19744.42,21923.33,2178.91,359520.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','219462',4237459,'2866','435',5057.43,5057.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219462',4237460,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219462',4237461,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219462',4237462,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219462',4237463,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219462',4237464,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219462',4237465,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','219462',4237466,'2873','435',13738.38,15388.55,1650.17,272278.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','219462',4237467,'2874','435',3754.93,3754.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219462',4237468,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219462',4237469,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219462',4237470,'2877','436',59466.17,61724.90,2258.73,666325.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','219462',4237471,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219462',4237472,'2910','436',2163.26,4152.69,1989.43,586881.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','219647',4240566,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219647',4240567,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219647',4240568,'2865','435',21923.33,23847.29,1923.96,317453.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','219647',4240569,'2866','435',5057.43,5078.69,21.26,3507.90,0.00,0.00,0.00,0.00,0.00),('5','181','968','219647',4240570,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219647',4240571,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219647',4240572,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219647',4240573,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219647',4240574,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219647',4240575,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','219647',4240576,'2873','435',15388.55,16562.85,1174.30,193759.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','219647',4240577,'2874','435',3754.93,4247.51,492.58,81275.70,0.00,0.00,0.00,0.00,0.00),('5','181','972','219647',4240578,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219647',4240579,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219647',4240580,'2877','436',61724.90,63177.56,1452.66,428534.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','219647',4240581,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219647',4240582,'2910','436',4152.69,4240.46,87.77,25892.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','219878',4244790,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219878',4244791,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','219878',4244792,'2865','435',23847.29,25862.86,2015.57,332569.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','219878',4244793,'2866','435',5078.69,5225.67,146.98,24251.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','219878',4244794,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','219878',4244795,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219878',4244796,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','219878',4244797,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219878',4244798,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','219878',4244799,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','219878',4244800,'2873','435',16562.85,18407.23,1844.38,304322.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','219878',4244801,'2874','435',4247.51,4736.81,489.30,80734.50,0.00,0.00,0.00,0.00,0.00),('5','181','972','219878',4244802,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','219878',4244803,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219878',4244804,'2877','436',63177.56,66261.90,3084.34,909880.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','219878',4244805,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','219878',4244806,'2910','436',4240.46,5213.36,972.90,287005.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','220136',4249500,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220136',4249501,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220136',4249502,'2865','435',25862.86,27791.42,1928.56,318212.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','220136',4249503,'2866','435',5225.67,5315.33,89.66,14793.90,0.00,0.00,0.00,0.00,0.00),('5','181','968','220136',4249504,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220136',4249505,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220136',4249506,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220136',4249507,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220136',4249508,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220136',4249509,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','220136',4249510,'2873','435',18407.23,19880.20,1472.97,243040.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','220136',4249511,'2874','435',4736.81,5664.01,927.20,152988.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220136',4249512,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220136',4249513,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220136',4249514,'2877','436',66261.90,68585.46,2323.56,685450.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','220136',4249515,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220136',4249516,'2910','436',5213.36,6485.93,1272.57,375408.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','220363',4253559,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220363',4253560,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220363',4253561,'2865','435',27791.42,29404.85,1613.43,266215.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','220363',4253562,'2866','435',5315.33,5790.61,475.28,78421.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','220363',4253563,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220363',4253564,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220363',4253565,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220363',4253566,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220363',4253567,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220363',4253568,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','220363',4253569,'2873','435',19880.20,21144.94,1264.74,208682.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','220363',4253570,'2874','435',5664.01,6314.07,650.06,107259.90,0.00,0.00,0.00,0.00,0.00),('5','181','972','220363',4253571,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220363',4253572,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220363',4253573,'2877','436',68585.46,70540.63,1955.17,576775.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','220363',4253574,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220363',4253575,'2910','436',6485.93,7600.17,1114.24,328700.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','220549',4256881,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220549',4256882,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220549',4256883,'2865','435',29404.85,31089.95,1685.10,278041.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','220549',4256884,'2866','435',5790.61,6163.56,372.95,61536.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','220549',4256885,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220549',4256886,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220549',4256887,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220549',4256888,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220549',4256889,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220549',4256890,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','220549',4256891,'2873','435',21144.94,22431.38,1286.44,212262.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','220549',4256892,'2874','435',6314.07,6318.91,4.84,798.60,0.00,0.00,0.00,0.00,0.00),('5','181','972','220549',4256893,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220549',4256894,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220549',4256895,'2877','436',70540.63,71477.04,936.41,276240.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','220549',4256896,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220549',4256897,'2910','436',7600.17,7714.90,114.73,33845.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','220743',4260059,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220743',4260060,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220743',4260061,'2865','435',31089.95,32991.73,1901.78,313793.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','220743',4260062,'2866','435',6163.56,6163.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220743',4260063,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220743',4260064,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220743',4260065,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220743',4260066,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220743',4260067,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220743',4260068,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','220743',4260069,'2873','435',22431.38,24210.72,1779.34,293591.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','220743',4260070,'2874','435',6318.91,8200.82,1881.91,310515.15,0.00,0.00,0.00,0.00,0.00),('5','181','972','220743',4260071,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220743',4260072,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220743',4260073,'2877','436',71477.04,72259.99,782.95,230970.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','220743',4260074,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220743',4260075,'2910','436',7714.90,8138.98,424.08,125103.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','220973',4264299,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220973',4264300,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','220973',4264301,'2865','435',32991.73,34260.72,1268.99,209383.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','220973',4264302,'2866','435',6163.56,6639.97,476.41,78607.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','220973',4264303,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','220973',4264304,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220973',4264305,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','220973',4264306,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220973',4264307,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','220973',4264308,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','220973',4264309,'2873','435',24210.72,25355.44,1144.72,188878.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','220973',4264310,'2874','435',8200.82,8806.09,605.27,99869.55,0.00,0.00,0.00,0.00,0.00),('5','181','972','220973',4264311,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','220973',4264312,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220973',4264313,'2877','436',72259.99,75964.78,3704.79,1092913.05,0.00,0.00,0.00,0.00,0.00),('5','181','974','220973',4264314,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','220973',4264315,'2910','436',8138.98,9337.04,1198.06,353427.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','221221',4268578,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221221',4268579,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221221',4268580,'2865','435',34260.72,36270.60,2009.88,331630.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','221221',4268581,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221221',4268582,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221221',4268583,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221221',4268584,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221221',4268585,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221221',4268586,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221221',4268587,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221221',4268588,'2873','435',25355.44,27043.59,1688.15,278544.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','221221',4268589,'2874','435',8806.09,8843.66,37.57,6199.05,0.00,0.00,0.00,0.00,0.00),('5','181','972','221221',4268590,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221221',4268591,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221221',4268592,'2877','436',75964.78,76186.72,221.94,65472.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','221221',4268593,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221221',4268594,'2910','436',9337.04,9608.12,271.08,79968.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','221467',4273016,'2863','435',25674.26,25674.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221467',4273017,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221467',4273018,'2865','435',36270.60,36481.38,210.78,34778.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','221467',4273019,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221467',4273020,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221467',4273021,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221467',4273022,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221467',4273023,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221467',4273024,'2871','435',29821.20,29821.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221467',4273025,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221467',4273026,'2873','435',27043.59,30460.83,3417.24,563844.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','221467',4273027,'2874','435',8843.66,8843.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221467',4273028,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221467',4273029,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221467',4273030,'2877','436',76186.72,79054.56,2867.84,846012.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','221467',4273031,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221467',4273032,'2910','436',9608.12,11353.21,1745.09,514801.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','221681',4277068,'2863','435',25674.26,26211.18,536.92,88591.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','221681',4277069,'2864','435',16053.64,16053.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221681',4277070,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221681',4277071,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221681',4277072,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221681',4277073,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221681',4277074,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221681',4277075,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221681',4277076,'2871','435',29821.20,31115.89,1294.69,213623.85,0.00,0.00,0.00,0.00,0.00),('5','181','970','221681',4277077,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221681',4277078,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221681',4277079,'2874','435',8843.66,8843.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221681',4277080,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221681',4277081,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221681',4277082,'2877','436',79054.56,80786.45,1731.89,510907.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','221681',4277083,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221681',4277084,'2910','436',11353.21,11434.26,81.05,23909.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','221955',4281927,'2863','435',26211.18,28598.51,2387.33,393909.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','221955',4281928,'2864','435',16053.64,16138.40,84.76,13985.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','221955',4281929,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','221955',4281930,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221955',4281931,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','221955',4281932,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221955',4281933,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','221955',4281934,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','221955',4281935,'2871','435',31115.89,33370.36,2254.47,371987.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','221955',4281936,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221955',4281937,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','221955',4281938,'2874','435',8843.66,8843.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221955',4281939,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','221955',4281940,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221955',4281941,'2877','436',80786.45,82047.01,1260.56,371865.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','221955',4281942,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','221955',4281943,'2910','436',11434.26,11866.99,432.73,127655.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','222096',4284434,'2863','435',28598.51,30594.06,1995.55,329265.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','222096',4284435,'2864','435',16138.40,16138.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222096',4284436,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222096',4284437,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222096',4284438,'2867','435',25031.76,25031.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222096',4284439,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222096',4284440,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222096',4284441,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222096',4284442,'2871','435',33370.36,34644.99,1274.63,210313.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','222096',4284443,'2872','435',5802.73,5802.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222096',4284444,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222096',4284445,'2874','435',8843.66,9706.72,863.06,142404.90,0.00,0.00,0.00,0.00,0.00),('5','181','972','222096',4284446,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','222096',4284447,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222096',4284448,'2877','436',82047.01,85909.73,3862.72,1139502.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','222096',4284449,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222096',4284450,'2910','436',11866.99,12217.35,350.36,103356.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','222457',4290880,'2863','435',30594.06,31838.34,1244.28,205306.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','222457',4290881,'2864','435',16138.40,16967.12,828.72,136738.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','222457',4290882,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222457',4290883,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222457',4290884,'2867','435',25031.76,26063.63,1031.87,170258.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','222457',4290885,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222457',4290886,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222457',4290887,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222457',4290888,'2871','435',34644.99,35243.07,598.08,98683.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','222457',4290889,'2872','435',5802.73,5867.19,64.46,10635.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','222457',4290890,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222457',4290891,'2874','435',9706.72,9994.44,287.72,47473.80,0.00,0.00,0.00,0.00,0.00),('5','181','972','222457',4290892,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','222457',4290893,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222457',4290894,'2877','436',85909.73,86916.25,1006.52,296923.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','222457',4290895,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222457',4290896,'2910','436',12217.35,12272.97,55.62,16407.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','222556',4292289,'2863','435',31838.34,33738.46,1900.12,313519.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','222556',4292290,'2864','435',16967.12,17872.41,905.29,149372.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','222556',4292291,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222556',4292292,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222556',4292293,'2867','435',26063.63,27380.75,1317.12,217324.80,0.00,0.00,0.00,0.00,0.00),('5','181','968','222556',4292294,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222556',4292295,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222556',4292296,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222556',4292297,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222556',4292298,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222556',4292299,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222556',4292300,'2874','435',9994.44,11871.59,1877.15,309729.75,0.00,0.00,0.00,0.00,0.00),('5','181','972','222556',4292301,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','222556',4292302,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222556',4292303,'2877','436',86916.25,88722.10,1805.85,532725.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','222556',4292304,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222556',4292305,'2910','436',12272.97,12602.22,329.25,97128.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','222871',4298368,'2863','435',33738.46,35082.64,1344.18,221789.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','222871',4298369,'2864','435',17872.41,17872.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222871',4298370,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222871',4298371,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222871',4298372,'2867','435',27380.75,28110.43,729.68,120397.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','222871',4298373,'2868','435',13756.03,13756.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222871',4298374,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222871',4298375,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222871',4298376,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222871',4298377,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222871',4298378,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222871',4298379,'2874','435',11871.59,13280.15,1408.56,232412.40,0.00,0.00,0.00,0.00,0.00),('5','181','972','222871',4298380,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','222871',4298381,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222871',4298382,'2877','436',88722.10,89572.09,849.99,250747.05,0.00,0.00,0.00,0.00,0.00),('5','181','974','222871',4298383,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222871',4298384,'2910','436',12602.22,12819.38,217.16,64062.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','222958',4299982,'2863','435',35082.64,36743.41,1660.77,274027.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','222958',4299983,'2864','435',17872.41,18751.19,878.78,144998.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','222958',4299984,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','222958',4299985,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','222958',4299986,'2867','435',28110.43,28434.28,323.85,53435.25,0.00,0.00,0.00,0.00,0.00),('5','181','968','222958',4299987,'2868','435',13756.03,13763.13,7.10,1171.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','222958',4299988,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','222958',4299989,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222958',4299990,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','222958',4299991,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222958',4299992,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','222958',4299993,'2874','435',13280.15,14844.24,1564.09,258074.85,0.00,0.00,0.00,0.00,0.00),('5','181','972','222958',4299994,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','222958',4299995,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222958',4299996,'2877','436',89572.09,89755.58,183.49,54129.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','222958',4299997,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','222958',4299998,'2910','436',12819.38,13300.68,481.30,141983.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','223216',4304215,'2863','435',36743.41,38493.73,1750.32,288802.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','223216',4304216,'2864','435',18751.19,20233.33,1482.14,244553.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','223216',4304217,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223216',4304218,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223216',4304219,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223216',4304220,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223216',4304221,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223216',4304222,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223216',4304223,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223216',4304224,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223216',4304225,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223216',4304226,'2874','435',14844.24,16507.41,1663.17,274423.05,0.00,0.00,0.00,0.00,0.00),('5','181','972','223216',4304227,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','223216',4304228,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223216',4304229,'2877','436',89755.58,90483.46,727.88,214724.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','223216',4304230,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223216',4304231,'2910','436',13300.68,13359.33,58.65,17301.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','223500',4309281,'2863','435',38493.73,39728.92,1235.19,203806.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','223500',4309282,'2864','435',20233.33,21450.60,1217.27,200849.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','223500',4309283,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223500',4309284,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223500',4309285,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223500',4309286,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223500',4309287,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223500',4309288,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223500',4309289,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223500',4309290,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223500',4309291,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223500',4309292,'2874','435',16507.41,17996.07,1488.66,245628.90,0.00,0.00,0.00,0.00,0.00),('5','181','972','223500',4309293,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','223500',4309294,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223500',4309295,'2877','436',90483.46,92714.60,2231.14,658186.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','223500',4309296,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223500',4309297,'2910','436',13359.33,14945.14,1585.81,467813.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','223753',4314074,'2863','435',39728.92,41453.14,1724.22,284496.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','223753',4314075,'2864','435',21450.60,22097.10,646.50,106672.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','223753',4314076,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223753',4314077,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223753',4314078,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223753',4314079,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223753',4314080,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223753',4314081,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223753',4314082,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223753',4314083,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223753',4314084,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223753',4314085,'2874','435',17996.07,19126.32,1130.25,186491.25,0.00,0.00,0.00,0.00,0.00),('5','181','972','223753',4314086,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','223753',4314087,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223753',4314088,'2877','436',92714.60,93591.50,876.90,258685.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','223753',4314089,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223753',4314090,'2910','436',14945.14,15197.63,252.49,74484.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','223947',4317481,'2863','435',41453.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223947',4317482,'2864','435',22097.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223947',4317483,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','223947',4317484,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223947',4317485,'2867','435',28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','223947',4317486,'2868','435',13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223947',4317487,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','223947',4317488,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223947',4317489,'2871','435',35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','223947',4317490,'2872','435',5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223947',4317491,'2873','435',30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','223947',4317492,'2874','435',19126.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','223947',4317493,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','223947',4317494,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223947',4317495,'2877','436',93591.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','223947',4317496,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','223947',4317497,'2910','436',15197.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224171',4321351,'2863','435',41453.14,43048.01,1594.87,263153.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','224171',4321352,'2864','435',22097.10,23012.91,915.81,151108.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','224171',4321353,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224171',4321354,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224171',4321355,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224171',4321356,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224171',4321357,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224171',4321358,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224171',4321359,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224171',4321360,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','224171',4321361,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224171',4321362,'2874','435',19126.32,21036.13,1909.81,315118.65,0.00,0.00,0.00,0.00,0.00),('5','181','972','224171',4321363,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','224171',4321364,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224171',4321365,'2877','436',93591.50,93721.22,129.72,38267.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','224171',4321366,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224171',4321367,'2910','436',15197.63,15335.30,137.67,40612.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','224183',4321604,'2863','435',43048.01,44784.93,1736.92,286591.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','224183',4321605,'2864','435',23012.91,23959.33,946.42,156159.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','224183',4321606,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224183',4321607,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224183',4321608,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224183',4321609,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224183',4321610,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224183',4321611,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224183',4321612,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224183',4321613,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','224183',4321614,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224183',4321615,'2874','435',21036.13,22602.14,1566.01,258391.65,0.00,0.00,0.00,0.00,0.00),('5','181','972','224183',4321616,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','224183',4321617,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224183',4321618,'2877','436',93721.22,94930.15,1208.93,356634.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','224183',4321619,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224183',4321620,'2910','436',15335.30,15415.68,80.38,23712.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','224364',4324861,'2863','435',44784.93,46203.65,1418.72,234088.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','224364',4324862,'2864','435',23959.33,25033.23,1073.90,177193.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','224364',4324863,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224364',4324864,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224364',4324865,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224364',4324866,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224364',4324867,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224364',4324868,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224364',4324869,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224364',4324870,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','224364',4324871,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224364',4324872,'2874','435',22602.14,24420.92,1818.78,300098.70,0.00,0.00,0.00,0.00,0.00),('5','181','972','224364',4324873,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','224364',4324874,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224364',4324875,'2877','436',94930.15,97186.82,2256.67,665717.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','224364',4324876,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224364',4324877,'2910','436',15415.68,15871.38,455.70,134431.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','224675',4330320,'2863','435',46203.65,46566.59,362.94,59885.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','224675',4330321,'2864','435',25033.23,25374.43,341.20,56298.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224675',4330322,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224675',4330323,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224675',4330324,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224675',4330325,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224675',4330326,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224675',4330327,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224675',4330328,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224675',4330329,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','224675',4330330,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224675',4330331,'2874','435',24420.92,27198.86,2777.94,458360.10,0.00,0.00,0.00,0.00,0.00),('5','181','972','224675',4330332,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','224675',4330333,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224675',4330334,'2877','436',97186.82,99718.99,2532.17,746990.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','224675',4330335,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224675',4330336,'2910','436',15871.38,16896.48,1025.10,302404.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','224912',4334518,'2863','435',46566.59,47619.51,1052.92,171625.96,0.00,0.00,0.00,0.00,0.00),('5','181','967','224912',4334519,'2864','435',25374.43,25883.10,508.67,82913.21,0.00,0.00,0.00,0.00,0.00),('5','181','967','224912',4334520,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','224912',4334521,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224912',4334522,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','224912',4334523,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224912',4334524,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224912',4334525,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224912',4334526,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','224912',4334527,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','224912',4334528,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','224912',4334529,'2874','435',27198.86,29081.21,1882.35,306823.05,0.00,0.00,0.00,0.00,0.00),('5','181','972','224912',4334530,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','224912',4334531,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224912',4334532,'2877','436',99718.99,102781.59,3062.60,903467.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','224912',4334533,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','224912',4334534,'2910','436',16896.48,19018.90,2122.42,626113.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','225179',4339448,'2863','435',47619.51,49486.88,1867.37,304381.31,0.00,0.00,0.00,0.00,0.00),('5','181','967','225179',4339449,'2864','435',25883.10,28112.55,2229.45,363400.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','225179',4339450,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','225179',4339451,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225179',4339452,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225179',4339453,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225179',4339454,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225179',4339455,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225179',4339456,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225179',4339457,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','225179',4339458,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225179',4339459,'2874','435',29081.21,30541.55,1460.34,238035.42,0.00,0.00,0.00,0.00,0.00),('5','181','972','225179',4339460,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','225179',4339461,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225179',4339462,'2877','436',102781.59,107118.17,4336.58,1279291.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','225179',4339463,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225179',4339464,'2910','436',19018.90,20204.77,1185.87,349831.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','225447',4344546,'2863','435',49486.88,51332.77,1845.89,300880.07,0.00,0.00,0.00,0.00,0.00),('5','181','967','225447',4344547,'2864','435',28112.55,29612.99,1500.44,244571.72,0.00,0.00,0.00,0.00,0.00),('5','181','967','225447',4344548,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','225447',4344549,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225447',4344550,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225447',4344551,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225447',4344552,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225447',4344553,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225447',4344554,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225447',4344555,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','225447',4344556,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225447',4344557,'2874','435',30541.55,31465.05,923.50,150530.50,0.00,0.00,0.00,0.00,0.00),('5','181','972','225447',4344558,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','225447',4344559,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225447',4344560,'2877','436',107118.17,109259.86,2141.69,631798.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','225447',4344561,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225447',4344562,'2910','436',20204.77,20749.34,544.57,160648.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','225570',4346573,'2863','435',51332.77,52296.62,963.85,157107.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','225570',4346574,'2864','435',29612.99,31067.07,1454.08,237015.04,0.00,0.00,0.00,0.00,0.00),('5','181','967','225570',4346575,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','225570',4346576,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225570',4346577,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225570',4346578,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225570',4346579,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225570',4346580,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225570',4346581,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225570',4346582,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','225570',4346583,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225570',4346584,'2874','435',31465.05,33659.64,2194.59,357718.17,0.00,0.00,0.00,0.00,0.00),('5','181','972','225570',4346585,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','225570',4346586,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225570',4346587,'2877','436',109259.86,111840.64,2580.78,761330.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','225570',4346588,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225570',4346589,'2910','436',20749.34,21097.48,348.14,102701.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','225736',4349186,'2863','435',52296.62,53973.20,1676.58,273282.54,0.00,0.00,0.00,0.00,0.00),('5','181','967','225736',4349187,'2864','435',31067.07,32010.11,943.04,153715.52,0.00,0.00,0.00,0.00,0.00),('5','181','967','225736',4349188,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','225736',4349189,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225736',4349190,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','225736',4349191,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225736',4349192,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225736',4349193,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225736',4349194,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','225736',4349195,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','225736',4349196,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','225736',4349197,'2874','435',33659.64,35276.47,1616.83,263543.29,0.00,0.00,0.00,0.00,0.00),('5','181','972','225736',4349198,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','225736',4349199,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225736',4349200,'2877','436',111840.64,113598.06,1757.42,518438.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','225736',4349201,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','225736',4349202,'2910','436',21097.48,21581.07,483.59,142659.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','226093',4355553,'2863','435',53973.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226093',4355554,'2864','435',32010.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226093',4355555,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226093',4355556,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226093',4355557,'2867','435',28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226093',4355558,'2868','435',13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226093',4355559,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226093',4355560,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226093',4355561,'2871','435',35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226093',4355562,'2872','435',5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','226093',4355563,'2873','435',30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226093',4355564,'2874','435',35276.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226093',4355565,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226093',4355566,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226093',4355567,'2877','436',113598.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','226093',4355568,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226093',4355569,'2910','436',21581.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226098',4355689,'2863','435',53973.20,53973.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226098',4355690,'2864','435',32010.11,32010.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226098',4355691,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226098',4355692,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226098',4355693,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226098',4355694,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226098',4355695,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226098',4355696,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226098',4355697,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226098',4355698,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','226098',4355699,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226098',4355700,'2874','435',35276.47,39254.61,3978.14,648436.82,0.00,0.00,0.00,0.00,0.00),('5','181','972','226098',4355701,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226098',4355702,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226098',4355703,'2877','436',113598.06,117504.51,3906.45,1152402.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','226098',4355704,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226098',4355705,'2910','436',21581.07,21928.16,347.09,102391.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','226377',4360782,'2863','435',53973.20,55522.13,1548.93,252475.59,0.00,0.00,0.00,0.00,0.00),('5','181','967','226377',4360783,'2864','435',32010.11,33527.95,1517.84,247407.92,0.00,0.00,0.00,0.00,0.00),('5','181','967','226377',4360784,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226377',4360785,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226377',4360786,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226377',4360787,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226377',4360788,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226377',4360789,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226377',4360790,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226377',4360791,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','226377',4360792,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226377',4360793,'2874','435',39254.61,40356.81,1102.20,179658.60,0.00,0.00,0.00,0.00,0.00),('5','181','972','226377',4360794,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226377',4360795,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226377',4360796,'2877','436',117504.51,119457.45,1952.94,576117.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','226377',4360797,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226377',4360798,'2910','436',21928.16,22004.40,76.24,22490.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','226512',4363052,'2863','435',55522.13,57300.37,1778.24,289853.12,0.00,0.00,0.00,0.00,0.00),('5','181','967','226512',4363053,'2864','435',33527.95,34385.96,858.01,139855.63,0.00,0.00,0.00,0.00,0.00),('5','181','967','226512',4363054,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226512',4363055,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226512',4363056,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226512',4363057,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226512',4363058,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226512',4363059,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226512',4363060,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226512',4363061,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','226512',4363062,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226512',4363063,'2874','435',40356.81,41694.01,1337.20,217963.60,0.00,0.00,0.00,0.00,0.00),('5','181','972','226512',4363064,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226512',4363065,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226512',4363066,'2877','436',119457.45,123191.12,3733.67,1101432.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','226512',4363067,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226512',4363068,'2910','436',22004.40,23222.66,1218.26,359386.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','226830',4368896,'2863','435',57300.37,59149.03,1848.66,301331.58,0.00,0.00,0.00,0.00,0.00),('5','181','967','226830',4368897,'2864','435',34385.96,36329.44,1943.48,316787.24,0.00,0.00,0.00,0.00,0.00),('5','181','967','226830',4368898,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','226830',4368899,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226830',4368900,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','226830',4368901,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226830',4368902,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226830',4368903,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226830',4368904,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','226830',4368905,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','226830',4368906,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','226830',4368907,'2874','435',41694.01,43048.12,1354.11,220719.93,0.00,0.00,0.00,0.00,0.00),('5','181','972','226830',4368908,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','226830',4368909,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226830',4368910,'2877','436',123191.12,125838.20,2647.08,780888.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','226830',4368911,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','226830',4368912,'2910','436',23222.66,24073.73,851.07,251065.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','227079',4373188,'2863','435',59149.03,61030.38,1881.35,306660.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','227079',4373189,'2864','435',36329.44,37492.25,1162.81,189538.03,0.00,0.00,0.00,0.00,0.00),('5','181','967','227079',4373190,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227079',4373191,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227079',4373192,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227079',4373193,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227079',4373194,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227079',4373195,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227079',4373196,'2871','435',35243.07,35243.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227079',4373197,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','227079',4373198,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227079',4373199,'2874','435',43048.12,44171.50,1123.38,183110.94,0.00,0.00,0.00,0.00,0.00),('5','181','972','227079',4373200,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227079',4373201,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227079',4373202,'2877','436',125838.20,128932.86,3094.66,912924.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','227079',4373203,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227079',4373204,'2910','436',24073.73,24317.02,243.29,71770.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','227246',4376056,'2863','435',61030.38,63145.84,2115.46,344819.98,0.00,0.00,0.00,0.00,0.00),('5','181','967','227246',4376057,'2864','435',37492.25,37492.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227246',4376058,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227246',4376059,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227246',4376060,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227246',4376061,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227246',4376062,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227246',4376063,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227246',4376064,'2871','435',35243.07,35649.01,405.94,66168.22,0.00,0.00,0.00,0.00,0.00),('5','181','970','227246',4376065,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','227246',4376066,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227246',4376067,'2874','435',44171.50,46246.26,2074.76,338185.88,0.00,0.00,0.00,0.00,0.00),('5','181','972','227246',4376068,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227246',4376069,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227246',4376070,'2877','436',128932.86,131337.89,2405.03,709483.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','227246',4376071,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227246',4376072,'2910','436',24317.02,25142.05,825.03,243383.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','227500',4380808,'2863','435',63145.84,64906.80,1760.96,287036.48,0.00,0.00,0.00,0.00,0.00),('5','181','967','227500',4380809,'2864','435',37492.25,38189.47,697.22,113646.86,0.00,0.00,0.00,0.00,0.00),('5','181','967','227500',4380810,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227500',4380811,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227500',4380812,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227500',4380813,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227500',4380814,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227500',4380815,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227500',4380816,'2871','435',35649.01,36682.44,1033.43,168449.09,0.00,0.00,0.00,0.00,0.00),('5','181','970','227500',4380817,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','227500',4380818,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227500',4380819,'2874','435',46246.26,48004.36,1758.10,286570.30,0.00,0.00,0.00,0.00,0.00),('5','181','972','227500',4380820,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227500',4380821,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227500',4380822,'2877','436',131337.89,133330.93,1993.04,587946.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','227500',4380823,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227500',4380824,'2910','436',25142.05,25302.73,160.68,47400.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','227645',4383110,'2863','435',64906.80,66035.14,1128.34,183919.42,0.00,0.00,0.00,0.00,0.00),('5','181','967','227645',4383111,'2864','435',38189.47,39204.35,1014.88,165425.44,0.00,0.00,0.00,0.00,0.00),('5','181','967','227645',4383112,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227645',4383113,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227645',4383114,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227645',4383115,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227645',4383116,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227645',4383117,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227645',4383118,'2871','435',36682.44,37254.09,571.65,93178.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','227645',4383119,'2872','435',5867.19,5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','227645',4383120,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227645',4383121,'2874','435',48004.36,48757.77,753.41,122805.83,0.00,0.00,0.00,0.00,0.00),('5','181','972','227645',4383122,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227645',4383123,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227645',4383124,'2877','436',133330.93,134282.17,951.24,280615.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','227645',4383125,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227645',4383126,'2910','436',25302.73,25616.47,313.74,92553.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','227836',4386776,'2863','435',66035.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227836',4386777,'2864','435',39204.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227836',4386778,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227836',4386779,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227836',4386780,'2867','435',28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227836',4386781,'2868','435',13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227836',4386782,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227836',4386783,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227836',4386784,'2871','435',37254.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227836',4386785,'2872','435',5867.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','227836',4386786,'2873','435',30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227836',4386787,'2874','435',48757.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227836',4386788,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227836',4386789,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227836',4386790,'2877','436',134282.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','227836',4386791,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227836',4386792,'2910','436',25616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227915',4387916,'2863','435',66035.14,66849.32,814.18,132711.34,0.00,0.00,0.00,0.00,0.00),('5','181','967','227915',4387917,'2864','435',39204.35,40303.50,1099.15,179161.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','227915',4387918,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','227915',4387919,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227915',4387920,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','227915',4387921,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227915',4387922,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227915',4387923,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','227915',4387924,'2871','435',37254.09,37588.01,333.92,54428.96,0.00,0.00,0.00,0.00,0.00),('5','181','970','227915',4387925,'2872','435',5867.19,7140.86,1273.67,207608.21,0.00,0.00,0.00,0.00,0.00),('5','181','971','227915',4387926,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','227915',4387927,'2874','435',48757.77,50016.75,1258.98,205213.74,0.00,0.00,0.00,0.00,0.00),('5','181','972','227915',4387928,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','227915',4387929,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227915',4387930,'2877','436',134282.17,135942.97,1660.80,498240.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','227915',4387931,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','227915',4387932,'2910','436',25616.47,26286.22,669.75,200925.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','229339',4415151,'2863','435',66849.32,67672.23,822.91,134134.33,0.00,0.00,0.00,0.00,0.00),('5','181','967','229339',4415152,'2864','435',40303.50,41821.94,1518.44,247505.72,0.00,0.00,0.00,0.00,0.00),('5','181','967','229339',4415153,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','229339',4415154,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','229339',4415155,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','229339',4415156,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','229339',4415157,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','229339',4415158,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','229339',4415159,'2871','435',37588.01,39624.74,2036.73,331986.99,0.00,0.00,0.00,0.00,0.00),('5','181','970','229339',4415160,'2872','435',7140.86,7412.51,271.65,44278.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','229339',4415161,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','229339',4415162,'2874','435',50016.75,50575.43,558.68,91064.84,0.00,0.00,0.00,0.00,0.00),('5','181','972','229339',4415163,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','229339',4415164,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','229339',4415165,'2877','436',135942.97,138279.18,2336.21,700863.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','229339',4415166,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','229339',4415167,'2910','436',26286.22,26464.22,178.00,53400.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230659',4440159,'2863','435',67672.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230659',4440160,'2864','435',41821.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230659',4440161,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230659',4440162,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230659',4440163,'2867','435',28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230659',4440164,'2868','435',13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230659',4440165,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230659',4440166,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230659',4440167,'2871','435',39624.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230659',4440168,'2872','435',7412.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','230659',4440169,'2873','435',30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230659',4440170,'2874','435',50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230659',4440171,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230659',4440172,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230659',4440173,'2877','436',138279.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230659',4440174,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230659',4440175,'2910','436',26464.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230666',4440231,'2863','435',67672.23,69106.05,1433.82,233712.66,0.00,0.00,0.00,0.00,0.00),('5','181','967','230666',4440232,'2864','435',41821.94,42670.60,848.66,138331.58,0.00,0.00,0.00,0.00,0.00),('5','181','967','230666',4440233,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230666',4440234,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230666',4440235,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230666',4440236,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230666',4440237,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230666',4440238,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230666',4440239,'2871','435',39624.74,41408.15,1783.41,290695.83,0.00,0.00,0.00,0.00,0.00),('5','181','970','230666',4440240,'2872','435',7412.51,8059.11,646.60,105395.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','230666',4440241,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230666',4440242,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230666',4440243,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230666',4440244,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230666',4440245,'2877','436',138279.18,141834.67,3555.49,1066647.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230666',4440246,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230666',4440247,'2910','436',26464.22,28262.27,1798.05,539415.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230712',4441183,'2863','435',69106.05,69106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230712',4441184,'2864','435',42670.60,42670.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230712',4441185,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230712',4441186,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230712',4441187,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230712',4441188,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230712',4441189,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230712',4441190,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230712',4441191,'2871','435',41408.15,43993.76,2585.61,421454.43,0.00,0.00,0.00,0.00,0.00),('5','181','970','230712',4441192,'2872','435',8059.11,10125.05,2065.94,336748.22,0.00,0.00,0.00,0.00,0.00),('5','181','971','230712',4441193,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230712',4441194,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230712',4441195,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230712',4441196,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230712',4441197,'2877','436',141834.67,143151.82,1317.15,395145.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230712',4441198,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230712',4441199,'2910','436',28262.27,28584.86,322.59,96777.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230866',4443438,'2863','435',69106.05,70174.23,1068.18,174113.34,0.00,0.00,0.00,0.00,0.00),('5','181','967','230866',4443439,'2864','435',42670.60,43389.96,719.36,117255.68,0.00,0.00,0.00,0.00,0.00),('5','181','967','230866',4443440,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230866',4443441,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230866',4443442,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230866',4443443,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230866',4443444,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230866',4443445,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230866',4443446,'2871','435',43993.76,44606.13,612.37,99816.31,0.00,0.00,0.00,0.00,0.00),('5','181','970','230866',4443447,'2872','435',10125.05,11846.23,1721.18,280552.34,0.00,0.00,0.00,0.00,0.00),('5','181','971','230866',4443448,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230866',4443449,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230866',4443450,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230866',4443451,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230866',4443452,'2877','436',143151.82,146947.22,3795.40,1138620.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230866',4443453,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230866',4443454,'2910','436',28584.86,29200.85,615.99,184797.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230878',4443610,'2863','435',70174.23,73229.68,3055.45,498038.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','230878',4443611,'2864','435',43389.96,44840.76,1450.80,236480.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','230878',4443612,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230878',4443613,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230878',4443614,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230878',4443615,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230878',4443616,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230878',4443617,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230878',4443618,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230878',4443619,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','230878',4443620,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230878',4443621,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230878',4443622,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230878',4443623,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230878',4443624,'2877','436',146947.22,148704.82,1757.60,527280.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230878',4443625,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230878',4443626,'2910','436',29200.85,36219.99,7019.14,2105742.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230918',4444361,'2863','435',73229.68,74675.16,1445.48,235613.24,0.00,0.00,0.00,0.00,0.00),('5','181','967','230918',4444362,'2864','435',44840.76,46786.28,1945.52,317119.76,0.00,0.00,0.00,0.00,0.00),('5','181','967','230918',4444363,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230918',4444364,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230918',4444365,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230918',4444366,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230918',4444367,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230918',4444368,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230918',4444369,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230918',4444370,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','230918',4444371,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230918',4444372,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230918',4444373,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230918',4444374,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230918',4444375,'2877','436',148704.82,150213.90,1509.08,467814.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','230918',4444376,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230918',4444377,'2910','436',36219.99,37011.83,791.84,245470.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','230929',4444530,'2863','435',74675.16,74898.09,222.93,36337.59,0.00,0.00,0.00,0.00,0.00),('5','181','967','230929',4444531,'2864','435',46786.28,47085.62,299.34,48792.42,0.00,0.00,0.00,0.00,0.00),('5','181','967','230929',4444532,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230929',4444533,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230929',4444534,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230929',4444535,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230929',4444536,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230929',4444537,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230929',4444538,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230929',4444539,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','230929',4444540,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230929',4444541,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230929',4444542,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230929',4444543,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230929',4444544,'2877','436',150213.90,155717.42,5503.52,1706091.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','230929',4444545,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230929',4444546,'2910','436',37011.83,44040.58,7028.75,2178912.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','230993',4445781,'2863','435',74898.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230993',4445782,'2864','435',47085.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230993',4445783,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','230993',4445784,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230993',4445785,'2867','435',28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','230993',4445786,'2868','435',13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230993',4445787,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230993',4445788,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230993',4445789,'2871','435',44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','230993',4445790,'2872','435',11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','230993',4445791,'2873','435',30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','230993',4445792,'2874','435',50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230993',4445793,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','230993',4445794,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230993',4445795,'2877','436',155717.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','230993',4445796,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','230993',4445797,'2910','436',44040.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231019',4446337,'2863','435',74898.09,74898.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231019',4446338,'2864','435',47085.62,47085.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231019',4446339,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231019',4446340,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231019',4446341,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231019',4446342,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231019',4446343,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231019',4446344,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231019',4446345,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231019',4446346,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231019',4446347,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231019',4446348,'2874','435',50575.43,50575.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231019',4446349,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231019',4446350,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231019',4446351,'2877','436',155717.42,159200.28,3482.86,1079686.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','231019',4446352,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231019',4446353,'2910','436',44040.58,44541.70,501.12,155347.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','231023',4446399,'2863','435',74898.09,76788.49,1890.40,308135.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','231023',4446400,'2864','435',47085.62,47085.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231023',4446401,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231023',4446402,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231023',4446403,'2867','435',28434.28,28434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231023',4446404,'2868','435',13763.13,13763.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231023',4446405,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231023',4446406,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231023',4446407,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231023',4446408,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231023',4446409,'2873','435',30460.83,30460.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231023',4446410,'2874','435',50575.43,51542.30,966.87,157599.81,0.00,0.00,0.00,0.00,0.00),('5','181','972','231023',4446411,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231023',4446412,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231023',4446413,'2877','436',159200.28,160310.24,1109.96,344087.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','231023',4446414,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231023',4446415,'2910','436',44541.70,44824.52,282.82,87674.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','231024',4446416,'2863','435',76788.49,77716.21,927.72,151218.36,0.00,0.00,0.00,0.00,0.00),('5','181','967','231024',4446417,'2864','435',47085.62,47085.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231024',4446418,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231024',4446419,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231024',4446420,'2867','435',28434.28,28639.00,204.72,33369.36,0.00,0.00,0.00,0.00,0.00),('5','181','968','231024',4446421,'2868','435',13763.13,14259.48,496.35,80905.05,0.00,0.00,0.00,0.00,0.00),('5','181','969','231024',4446422,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231024',4446423,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231024',4446424,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231024',4446425,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231024',4446426,'2873','435',30460.83,33062.22,2601.39,424026.57,0.00,0.00,0.00,0.00,0.00),('5','181','969','231024',4446427,'2874','435',51542.30,52112.95,570.65,93015.95,0.00,0.00,0.00,0.00,0.00),('5','181','972','231024',4446428,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231024',4446429,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231024',4446430,'2877','436',160310.24,163578.10,3267.86,1013036.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','231024',4446431,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231024',4446432,'2910','436',44824.52,45460.26,635.74,197079.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','231026',4446461,'2863','435',77716.21,79888.37,2172.16,354062.08,0.00,0.00,0.00,0.00,0.00),('5','181','967','231026',4446462,'2864','435',47085.62,49021.80,1936.18,315597.34,0.00,0.00,0.00,0.00,0.00),('5','181','967','231026',4446463,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231026',4446464,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231026',4446465,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231026',4446466,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231026',4446467,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231026',4446468,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231026',4446469,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231026',4446470,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231026',4446471,'2873','435',33062.22,33770.19,707.97,115399.11,0.00,0.00,0.00,0.00,0.00),('5','181','969','231026',4446472,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231026',4446473,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231026',4446474,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231026',4446475,'2877','436',163578.10,166390.64,2812.54,871887.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','231026',4446476,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231026',4446477,'2910','436',45460.26,47573.93,2113.67,655237.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','231140',4448186,'2863','435',79888.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231140',4448187,'2864','435',49021.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231140',4448188,'2865','435',36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231140',4448189,'2866','435',6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231140',4448190,'2867','435',28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231140',4448191,'2868','435',14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231140',4448192,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231140',4448193,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231140',4448194,'2871','435',44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231140',4448195,'2872','435',11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231140',4448196,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231140',4448197,'2874','435',52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231140',4448198,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231140',4448199,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231140',4448200,'2877','436',166390.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','231140',4448201,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231140',4448202,'2910','436',47573.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231147',4448330,'2863','435',79888.37,83462.04,3573.67,582508.21,0.00,0.00,0.00,0.00,0.00),('5','181','967','231147',4448331,'2864','435',49021.80,51686.65,2664.85,434370.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','231147',4448332,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231147',4448333,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231147',4448334,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231147',4448335,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231147',4448336,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231147',4448337,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231147',4448338,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231147',4448339,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231147',4448340,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231147',4448341,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231147',4448342,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231147',4448343,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231147',4448344,'2877','436',166390.64,167425.93,1035.29,331292.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','231147',4448345,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231147',4448346,'2910','436',47573.93,47774.52,200.59,64188.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','231223',4449624,'2863','435',83462.04,87380.49,3918.45,638707.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','231223',4449625,'2864','435',51686.65,53992.82,2306.17,375905.71,0.00,0.00,0.00,0.00,0.00),('5','181','967','231223',4449626,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231223',4449627,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231223',4449628,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231223',4449629,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231223',4449630,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231223',4449631,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231223',4449632,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231223',4449633,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231223',4449634,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231223',4449635,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231223',4449636,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231223',4449637,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231223',4449638,'2877','436',167425.93,171619.15,4193.22,1341830.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','231223',4449639,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231223',4449640,'2910','436',47774.52,50154.21,2379.69,761500.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','231258',4450124,'2863','435',87380.49,89902.54,2522.05,411094.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','231258',4450125,'2864','435',53992.82,58183.23,4190.41,683036.83,0.00,0.00,0.00,0.00,0.00),('5','181','967','231258',4450126,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231258',4450127,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231258',4450128,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231258',4450129,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231258',4450130,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231258',4450131,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231258',4450132,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231258',4450133,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231258',4450134,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231258',4450135,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231258',4450136,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231258',4450137,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231258',4450138,'2877','436',171619.15,174854.75,3235.60,1035392.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','231258',4450139,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231258',4450140,'2910','436',50154.21,51161.69,1007.48,322393.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','231418',4452484,'2863','435',89902.54,93836.45,3933.91,641227.33,0.00,0.00,0.00,0.00,0.00),('5','181','967','231418',4452485,'2864','435',58183.23,59906.76,1723.53,280935.39,0.00,0.00,0.00,0.00,0.00),('5','181','967','231418',4452486,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231418',4452487,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231418',4452488,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231418',4452489,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231418',4452490,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231418',4452491,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231418',4452492,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231418',4452493,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231418',4452494,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231418',4452495,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231418',4452496,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231418',4452497,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231418',4452498,'2877','436',174854.75,180456.16,5601.41,1792451.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','231418',4452499,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231418',4452500,'2910','436',51161.69,53231.45,2069.76,662323.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','231833',4460169,'2863','435',93836.45,94293.94,457.49,74570.87,0.00,0.00,0.00,0.00,0.00),('5','181','967','231833',4460170,'2864','435',59906.76,60185.71,278.95,45468.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','231833',4460171,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231833',4460172,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231833',4460173,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231833',4460174,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231833',4460175,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231833',4460176,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231833',4460177,'2871','435',44606.13,44606.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231833',4460178,'2872','435',11846.23,11846.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','231833',4460179,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231833',4460180,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231833',4460181,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231833',4460182,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231833',4460183,'2877','436',180456.16,186138.95,5682.79,1818492.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','231833',4460184,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231833',4460185,'2910','436',53231.45,55841.66,2610.21,835267.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','231923',4461462,'2863','435',94293.94,96657.80,2363.86,385309.18,0.00,0.00,0.00,0.00,0.00),('5','181','967','231923',4461463,'2864','435',60185.71,61035.53,849.82,138520.66,0.00,0.00,0.00,0.00,0.00),('5','181','967','231923',4461464,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','231923',4461465,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231923',4461466,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','231923',4461467,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231923',4461468,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231923',4461469,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','231923',4461470,'2871','435',44606.13,45502.22,896.09,146062.67,0.00,0.00,0.00,0.00,0.00),('5','181','970','231923',4461471,'2872','435',11846.23,12011.69,165.46,26969.98,0.00,0.00,0.00,0.00,0.00),('5','181','971','231923',4461472,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','231923',4461473,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231923',4461474,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','231923',4461475,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231923',4461476,'2877','436',186138.95,188276.60,2137.65,684048.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','231923',4461477,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','231923',4461478,'2910','436',55841.66,57613.80,1772.14,567084.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','232203',4466708,'2863','435',96657.80,98334.99,1677.19,273381.97,0.00,0.00,0.00,0.00,0.00),('5','181','967','232203',4466709,'2864','435',61035.53,62596.31,1560.78,254407.14,0.00,0.00,0.00,0.00,0.00),('5','181','967','232203',4466710,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232203',4466711,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232203',4466712,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232203',4466713,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232203',4466714,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232203',4466715,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','232203',4466716,'2871','435',45502.22,46852.80,1350.58,220144.54,0.00,0.00,0.00,0.00,0.00),('5','181','970','232203',4466717,'2872','435',12011.69,13421.16,1409.47,229743.61,0.00,0.00,0.00,0.00,0.00),('5','181','971','232203',4466718,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232203',4466719,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232203',4466720,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232203',4466721,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232203',4466722,'2877','436',188276.60,191019.08,2742.48,896790.96,0.00,0.00,0.00,0.00,0.00),('5','181','974','232203',4466723,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232203',4466724,'2910','436',57613.80,57768.87,155.07,50707.89,0.00,0.00,0.00,0.00,0.00),('5','181','967','232397',4469904,'2863','435',98334.99,98610.99,276.00,44988.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232397',4469905,'2864','435',62596.31,63828.57,1232.26,200858.38,0.00,0.00,0.00,0.00,0.00),('5','181','967','232397',4469906,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232397',4469907,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232397',4469908,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232397',4469909,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232397',4469910,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232397',4469911,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','232397',4469912,'2871','435',46852.80,49530.39,2677.59,436447.17,0.00,0.00,0.00,0.00,0.00),('5','181','970','232397',4469913,'2872','435',13421.16,14022.82,601.66,98070.58,0.00,0.00,0.00,0.00,0.00),('5','181','971','232397',4469914,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232397',4469915,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232397',4469916,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232397',4469917,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232397',4469918,'2877','436',191019.08,195747.47,4728.39,1546183.53,0.00,0.00,0.00,0.00,0.00),('5','181','974','232397',4469919,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232397',4469920,'2910','436',57768.87,60657.59,2888.72,944611.44,0.00,0.00,0.00,0.00,0.00),('5','181','967','232625',4474091,'2863','435',98610.99,98610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232625',4474092,'2864','435',63828.57,67404.97,3576.40,582953.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','232625',4474093,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232625',4474094,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232625',4474095,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232625',4474096,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232625',4474097,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232625',4474098,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','232625',4474099,'2871','435',49530.39,51128.44,1598.05,260482.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','232625',4474100,'2872','435',14022.82,14472.97,450.15,73374.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','232625',4474101,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232625',4474102,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232625',4474103,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232625',4474104,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232625',4474105,'2877','436',195747.47,203454.66,7707.19,2520251.13,0.00,0.00,0.00,0.00,0.00),('5','181','974','232625',4474106,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232625',4474107,'2910','436',60657.59,63498.29,2840.70,928908.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','232913',4479364,'2863','435',98610.99,98610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232913',4479365,'2864','435',67404.97,67404.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232913',4479366,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','232913',4479367,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232913',4479368,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','232913',4479369,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232913',4479370,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232913',4479371,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','232913',4479372,'2871','435',51128.44,51128.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','232913',4479373,'2872','435',14472.97,14472.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','232913',4479374,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','232913',4479375,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232913',4479376,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','232913',4479377,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232913',4479378,'2877','436',203454.66,204528.90,1074.24,351276.48,0.00,0.00,0.00,0.00,0.00),('5','181','974','232913',4479379,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','232913',4479380,'2910','436',63498.29,63771.99,273.70,89499.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','233018',4481393,'2863','435',98610.99,98610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233018',4481394,'2864','435',67404.97,68747.29,1342.32,218798.16,0.00,0.00,0.00,0.00,0.00),('5','181','967','233018',4481395,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233018',4481396,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233018',4481397,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233018',4481398,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233018',4481399,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233018',4481400,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233018',4481401,'2871','435',51128.44,52596.54,1468.10,239300.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','233018',4481402,'2872','435',14472.97,14962.85,489.88,79850.44,0.00,0.00,0.00,0.00,0.00),('5','181','971','233018',4481403,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233018',4481404,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233018',4481405,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233018',4481406,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233018',4481407,'2877','436',204528.90,210193.05,5664.15,1869169.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','233018',4481408,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233018',4481409,'2910','436',63771.99,69782.31,6010.32,1983405.60,0.00,0.00,0.00,0.00,2100.00),('5','181','967','233144',4483530,'2863','435',98610.99,98610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233144',4483531,'2864','435',68747.29,69894.65,1147.36,187019.68,0.00,0.00,0.00,0.00,0.00),('5','181','967','233144',4483532,'2865','435',36481.38,36481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233144',4483533,'2866','435',6639.97,6639.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233144',4483534,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233144',4483535,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233144',4483536,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233144',4483537,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233144',4483538,'2871','435',52596.54,54466.31,1869.77,304772.51,0.00,0.00,0.00,0.00,0.00),('5','181','971','233144',4483539,'2872','435',14962.85,16442.62,1479.77,241202.51,0.00,0.00,0.00,0.00,0.00),('5','181','971','233144',4483540,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233144',4483541,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233144',4483542,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233144',4483543,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233144',4483544,'2877','436',210193.05,214298.18,4105.13,1416269.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','233144',4483545,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233144',4483546,'2910','436',69782.31,72523.18,2740.87,945600.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','233423',4488454,'2863','435',98610.99,98610.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233423',4488455,'2864','435',69894.65,74422.58,4527.93,738052.59,0.00,0.00,0.00,0.00,0.00),('5','181','967','233423',4488456,'2865','435',36481.38,37761.01,1279.63,208579.69,0.00,0.00,0.00,0.00,0.00),('5','181','967','233423',4488457,'2866','435',6639.97,6762.27,122.30,19934.90,0.00,0.00,0.00,0.00,0.00),('5','181','968','233423',4488458,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233423',4488459,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233423',4488460,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233423',4488461,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233423',4488462,'2871','435',54466.31,54559.52,93.21,15193.23,0.00,0.00,0.00,0.00,0.00),('5','181','971','233423',4488463,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233423',4488464,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233423',4488465,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233423',4488466,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233423',4488467,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233423',4488468,'2877','436',214298.18,217774.17,3475.99,1199216.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','233423',4488469,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233423',4488470,'2910','436',72523.18,74675.24,2152.06,742460.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','233701',4493592,'2863','435',98610.99,100323.30,1712.31,279106.53,0.00,0.00,0.00,0.00,0.00),('5','181','967','233701',4493593,'2864','435',74422.58,77646.39,3223.81,525481.03,0.00,0.00,0.00,0.00,0.00),('5','181','967','233701',4493594,'2865','435',37761.01,37761.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','233701',4493595,'2866','435',6762.27,7183.82,421.55,68712.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','233701',4493596,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233701',4493597,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233701',4493598,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233701',4493599,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233701',4493600,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233701',4493601,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233701',4493602,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233701',4493603,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233701',4493604,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233701',4493605,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233701',4493606,'2877','436',217774.17,223766.93,5992.76,2067502.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','233701',4493607,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233701',4493608,'2910','436',74675.24,78275.23,3599.99,1241996.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','233879',4496760,'2863','435',100323.30,101218.26,894.96,145878.48,0.00,0.00,0.00,0.00,0.00),('5','181','967','233879',4496761,'2864','435',77646.39,79107.78,1461.39,238206.57,0.00,0.00,0.00,0.00,0.00),('5','181','967','233879',4496762,'2865','435',37761.01,39927.84,2166.83,353193.29,0.00,0.00,0.00,0.00,0.00),('5','181','967','233879',4496763,'2866','435',7183.82,8310.64,1126.82,183671.66,0.00,0.00,0.00,0.00,0.00),('5','181','968','233879',4496764,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','233879',4496765,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233879',4496766,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233879',4496767,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233879',4496768,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233879',4496769,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','233879',4496770,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','233879',4496771,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233879',4496772,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','233879',4496773,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233879',4496774,'2877','436',223766.93,229086.37,5319.44,1835206.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','233879',4496775,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','233879',4496776,'2910','436',78275.23,79577.36,1302.13,449234.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','234132',4501516,'2863','435',101218.26,105030.40,3812.14,621378.82,0.00,0.00,0.00,0.00,0.00),('5','181','967','234132',4501517,'2864','435',79107.78,80266.74,1158.96,188910.48,0.00,0.00,0.00,0.00,0.00),('5','181','967','234132',4501518,'2865','435',39927.84,40760.20,832.36,135674.68,0.00,0.00,0.00,0.00,0.00),('5','181','967','234132',4501519,'2866','435',8310.64,8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234132',4501520,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234132',4501521,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234132',4501522,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234132',4501523,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234132',4501524,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234132',4501525,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234132',4501526,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234132',4501527,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234132',4501528,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234132',4501529,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234132',4501530,'2877','436',229086.37,234088.43,5002.06,1725710.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','234132',4501531,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234132',4501532,'2910','436',79577.36,81901.68,2324.32,801890.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','234508',4508204,'2863','435',105030.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234508',4508205,'2864','435',80266.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234508',4508206,'2865','435',40760.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234508',4508207,'2866','435',8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234508',4508208,'2867','435',28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234508',4508209,'2868','435',14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234508',4508210,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234508',4508211,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234508',4508212,'2871','435',54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234508',4508213,'2872','435',16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234508',4508214,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234508',4508215,'2874','435',52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234508',4508216,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234508',4508217,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234508',4508218,'2877','436',234088.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','234508',4508219,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234508',4508220,'2910','436',81901.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234676',4511236,'2863','435',105030.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234676',4511237,'2864','435',80266.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234676',4511238,'2865','435',40760.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234676',4511239,'2866','435',8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234676',4511240,'2867','435',28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234676',4511241,'2868','435',14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234676',4511242,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234676',4511243,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234676',4511244,'2871','435',54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234676',4511245,'2872','435',16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234676',4511246,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234676',4511247,'2874','435',52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234676',4511248,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234676',4511249,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234676',4511250,'2877','436',234088.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','234676',4511251,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234676',4511252,'2910','436',81901.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234688',4511382,'2863','435',105030.40,106493.31,1462.91,241380.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','234688',4511383,'2864','435',80266.74,81115.31,848.57,140014.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','234688',4511384,'2865','435',40760.20,41080.30,320.10,52816.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','234688',4511385,'2866','435',8310.64,8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234688',4511386,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234688',4511387,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234688',4511388,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234688',4511389,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234688',4511390,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234688',4511391,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234688',4511392,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234688',4511393,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234688',4511394,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234688',4511395,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234688',4511396,'2877','436',234088.43,234088.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','234688',4511397,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234688',4511398,'2910','436',81901.68,81901.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','234693',4511488,'2863','435',106493.31,106938.96,445.65,72640.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','234693',4511489,'2864','435',81115.31,84721.11,3605.80,587745.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','234693',4511490,'2865','435',41080.30,41617.75,537.45,87604.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','234693',4511491,'2866','435',8310.64,8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234693',4511492,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234693',4511493,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234693',4511494,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234693',4511495,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234693',4511496,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234693',4511497,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234693',4511498,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234693',4511499,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234693',4511500,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234693',4511501,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234693',4511502,'2877','436',234088.43,238205.61,4117.18,1420427.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','234693',4511503,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234693',4511504,'2910','436',81901.68,82452.31,550.63,189967.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','234696',4511516,'2863','435',106938.96,107644.73,705.77,116452.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','234696',4511517,'2864','435',84721.11,87544.72,2823.61,465895.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','234696',4511518,'2865','435',41617.75,43559.22,1941.47,320342.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','234696',4511519,'2866','435',8310.64,8310.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234696',4511520,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234696',4511521,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234696',4511522,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234696',4511523,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234696',4511524,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234696',4511525,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234696',4511526,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234696',4511527,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234696',4511528,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234696',4511529,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234696',4511530,'2877','436',238205.61,243719.73,5514.12,1902371.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','234696',4511531,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234696',4511532,'2910','436',82452.31,84840.08,2387.77,823780.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','234937',4515898,'2863','435',107644.73,109347.67,1702.94,280985.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','234937',4515899,'2864','435',87544.72,89332.47,1787.75,294978.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','234937',4515900,'2865','435',43559.22,48321.60,4762.38,785792.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','234937',4515901,'2866','435',8310.64,8808.45,497.81,82138.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','234937',4515902,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','234937',4515903,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234937',4515904,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234937',4515905,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234937',4515906,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234937',4515907,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','234937',4515908,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','234937',4515909,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234937',4515910,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','234937',4515911,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234937',4515912,'2877','436',243719.73,246762.51,3042.78,1049759.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','234937',4515913,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','234937',4515914,'2910','436',84840.08,86910.34,2070.26,714239.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','235192',4520265,'2863','435',109347.67,109347.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','235192',4520266,'2864','435',89332.47,89332.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','235192',4520267,'2865','435',48321.60,53078.86,4757.26,784947.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','235192',4520268,'2866','435',8808.45,13414.43,4605.98,759986.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','235192',4520269,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235192',4520270,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235192',4520271,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235192',4520272,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235192',4520273,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235192',4520274,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235192',4520275,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235192',4520276,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235192',4520277,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235192',4520278,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235192',4520279,'2877','436',246762.51,249093.77,2331.26,804284.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','235192',4520280,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235192',4520281,'2910','436',86910.34,88000.44,1090.10,376084.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','235385',4523620,'2863','435',109347.67,109347.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','235385',4523621,'2864','435',89332.47,89332.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','235385',4523622,'2865','435',53078.86,58205.75,5126.89,845936.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','235385',4523623,'2866','435',13414.43,13414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235385',4523624,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235385',4523625,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235385',4523626,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235385',4523627,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235385',4523628,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235385',4523629,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235385',4523630,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235385',4523631,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235385',4523632,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235385',4523633,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235385',4523634,'2877','436',249093.77,257660.67,8566.90,2955580.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','235385',4523635,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235385',4523636,'2910','436',88000.44,92370.16,4369.72,1507553.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','235604',4527367,'2863','435',109347.67,112634.30,3286.63,542293.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','235604',4527368,'2864','435',89332.47,92073.19,2740.72,452218.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','235604',4527369,'2865','435',58205.75,59848.06,1642.31,270981.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','235604',4527370,'2866','435',13414.43,13414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235604',4527371,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235604',4527372,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235604',4527373,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235604',4527374,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235604',4527375,'2871','435',54559.52,54559.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235604',4527376,'2872','435',16442.62,16442.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235604',4527377,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235604',4527378,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235604',4527379,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235604',4527380,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235604',4527381,'2877','436',257660.67,260610.05,2949.38,1017536.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','235604',4527382,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235604',4527383,'2910','436',92370.16,94200.61,1830.45,631505.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','235807',4530998,'2863','435',112634.30,116545.41,3911.11,645333.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','235807',4530999,'2864','435',92073.19,95223.17,3149.98,519746.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','235807',4531000,'2865','435',59848.06,59848.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','235807',4531001,'2866','435',13414.43,13414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235807',4531002,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','235807',4531003,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235807',4531004,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235807',4531005,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','235807',4531006,'2871','435',54559.52,58187.18,3627.66,598563.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','235807',4531007,'2872','435',16442.62,17050.81,608.19,100351.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','235807',4531008,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','235807',4531009,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235807',4531010,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','235807',4531011,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235807',4531012,'2877','436',260610.05,263611.69,3001.64,1035565.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','235807',4531013,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','235807',4531014,'2910','436',94200.61,96711.52,2510.91,866263.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','236327',4540318,'2863','435',116545.41,121513.47,4968.06,819729.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','236327',4540319,'2864','435',95223.17,98476.11,3252.94,536735.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','236327',4540320,'2865','435',59848.06,59848.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','236327',4540321,'2866','435',13414.43,13414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236327',4540322,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236327',4540323,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236327',4540324,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236327',4540325,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236327',4540326,'2871','435',58187.18,59820.78,1633.60,269544.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236327',4540327,'2872','435',17050.81,17050.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236327',4540328,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236327',4540329,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236327',4540330,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236327',4540331,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236327',4540332,'2877','436',263611.69,266533.74,2922.05,1008107.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','236327',4540333,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236327',4540334,'2910','436',96711.52,97552.74,841.22,290220.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','236336',4540454,'2863','435',121513.47,124837.81,3324.34,548516.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','236336',4540455,'2864','435',98476.11,100819.16,2343.05,386603.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','236336',4540456,'2865','435',59848.06,59848.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','236336',4540457,'2866','435',13414.43,13414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236336',4540458,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236336',4540459,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236336',4540460,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236336',4540461,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236336',4540462,'2871','435',59820.78,62425.56,2604.78,429788.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','236336',4540463,'2872','435',17050.81,17848.31,797.50,131587.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','236336',4540464,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236336',4540465,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236336',4540466,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236336',4540467,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236336',4540468,'2877','436',266533.74,271577.21,5043.47,1739997.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','236336',4540469,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236336',4540470,'2910','436',97552.74,100589.50,3036.76,1047682.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','236596',4544961,'2863','435',124837.81,127538.88,2701.07,445676.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','236596',4544962,'2864','435',100819.16,101372.26,553.10,91261.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','236596',4544963,'2865','435',59848.06,65535.20,5687.14,938378.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','236596',4544964,'2866','435',13414.43,13434.51,20.08,3313.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','236596',4544965,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236596',4544966,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236596',4544967,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236596',4544968,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236596',4544969,'2871','435',62425.56,66587.06,4161.50,686647.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','236596',4544970,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236596',4544971,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236596',4544972,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236596',4544973,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236596',4544974,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236596',4544975,'2877','436',271577.21,277465.43,5888.22,2031435.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','236596',4544976,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236596',4544977,'2910','436',100589.50,102857.87,2268.37,782587.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','236791',4548164,'2863','435',127538.88,134462.99,6924.11,1142478.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','236791',4548165,'2864','435',101372.26,108506.37,7134.11,1177128.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','236791',4548166,'2865','435',65535.20,70445.17,4909.97,810145.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','236791',4548167,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236791',4548168,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','236791',4548169,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236791',4548170,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236791',4548171,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236791',4548172,'2871','435',66587.06,68123.57,1536.51,253524.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','236791',4548173,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','236791',4548174,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','236791',4548175,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236791',4548176,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','236791',4548177,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236791',4548178,'2877','436',277465.43,283975.10,6509.67,2245836.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','236791',4548179,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','236791',4548180,'2910','436',102857.87,103624.12,766.25,264356.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','237207',4555496,'2863','435',134462.99,136990.09,2527.10,416971.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','237207',4555497,'2864','435',108506.37,108506.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','237207',4555498,'2865','435',70445.17,70445.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','237207',4555499,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237207',4555500,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237207',4555501,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237207',4555502,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237207',4555503,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237207',4555504,'2871','435',68123.57,68123.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237207',4555505,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237207',4555506,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237207',4555507,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237207',4555508,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237207',4555509,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237207',4555510,'2877','436',283975.10,291272.11,7297.01,2517468.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','237207',4555511,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237207',4555512,'2910','436',103624.12,105682.30,2058.18,710072.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','237444',4560006,'2863','435',136990.09,138942.06,1951.97,322075.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','237444',4560007,'2864','435',108506.37,109934.33,1427.96,235613.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','237444',4560008,'2865','435',70445.17,70752.11,306.94,50645.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','237444',4560009,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237444',4560010,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237444',4560011,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237444',4560012,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237444',4560013,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237444',4560014,'2871','435',68123.57,68123.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237444',4560015,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237444',4560016,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237444',4560017,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237444',4560018,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237444',4560019,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237444',4560020,'2877','436',291272.11,294656.12,3384.01,1167483.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','237444',4560021,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237444',4560022,'2910','436',105682.30,107618.48,1936.18,667982.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','237456',4560220,'2863','435',138942.06,139746.15,804.09,132674.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','237456',4560221,'2864','435',109934.33,111006.78,1072.45,176954.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','237456',4560222,'2865','435',70752.11,74433.52,3681.41,607432.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','237456',4560223,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237456',4560224,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237456',4560225,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237456',4560226,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237456',4560227,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237456',4560228,'2871','435',68123.57,68123.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237456',4560229,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237456',4560230,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237456',4560231,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237456',4560232,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237456',4560233,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237456',4560234,'2877','436',294656.12,299676.00,5019.88,1731858.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','237456',4560235,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237456',4560236,'2910','436',107618.48,109676.67,2058.19,710075.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','237678',4563926,'2863','435',139746.15,143419.93,3673.78,606173.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','237678',4563927,'2864','435',111006.78,117487.34,6480.56,1069292.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','237678',4563928,'2865','435',74433.52,74433.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','237678',4563929,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237678',4563930,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','237678',4563931,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237678',4563932,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237678',4563933,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237678',4563934,'2871','435',68123.57,68123.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237678',4563935,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','237678',4563936,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','237678',4563937,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237678',4563938,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','237678',4563939,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237678',4563940,'2877','436',299676.00,306341.54,6665.54,2299611.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','237678',4563941,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','237678',4563942,'2910','436',109676.67,110806.18,1129.51,389680.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','238009',4569316,'2863','435',143419.93,143419.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238009',4569317,'2864','435',117487.34,123481.22,5993.88,988990.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','238009',4569318,'2865','435',74433.52,74433.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238009',4569319,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238009',4569320,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238009',4569321,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238009',4569322,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238009',4569323,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238009',4569324,'2871','435',68123.57,73583.02,5459.45,900809.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','238009',4569325,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238009',4569326,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238009',4569327,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238009',4569328,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238009',4569329,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238009',4569330,'2877','436',306341.54,315254.07,8912.53,3074822.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','238009',4569331,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238009',4569332,'2910','436',110806.18,112684.11,1877.93,647885.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','238228',4573069,'2863','435',143419.93,149645.45,6225.52,1027210.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','238228',4573070,'2864','435',123481.22,131410.30,7929.08,1308298.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','238228',4573071,'2865','435',74433.52,74433.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238228',4573072,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238228',4573073,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238228',4573074,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238228',4573075,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238228',4573076,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238228',4573077,'2871','435',73583.02,78851.36,5268.34,869276.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','238228',4573078,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238228',4573079,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238228',4573080,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238228',4573081,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238228',4573082,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238228',4573083,'2877','436',315254.07,320356.91,5102.84,1760479.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','238228',4573084,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238228',4573085,'2910','436',112684.11,113961.99,1277.88,440868.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','238419',4576403,'2863','435',149645.45,156649.39,7003.94,1155650.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','238419',4576404,'2864','435',131410.30,133338.07,1927.77,318082.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','238419',4576405,'2865','435',74433.52,82081.42,7647.90,1261903.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','238419',4576406,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238419',4576407,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238419',4576408,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238419',4576409,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238419',4576410,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238419',4576411,'2871','435',78851.36,83070.43,4219.07,696146.55,0.00,0.00,0.00,0.00,0.00),('5','181','971','238419',4576412,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238419',4576413,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238419',4576414,'2874','435',52112.95,52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238419',4576415,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238419',4576416,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238419',4576417,'2877','436',320356.91,326447.24,6090.33,2101163.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','238419',4576418,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238419',4576419,'2910','436',113961.99,114896.25,934.26,322319.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','238886',4584393,'2863','435',156649.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238886',4584394,'2864','435',133338.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238886',4584395,'2865','435',82081.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238886',4584396,'2866','435',13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238886',4584397,'2867','435',28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238886',4584398,'2868','435',14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238886',4584399,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238886',4584400,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238886',4584401,'2871','435',83070.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238886',4584402,'2872','435',17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','238886',4584403,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','238886',4584404,'2874','435',52112.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238886',4584405,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238886',4584406,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238886',4584407,'2877','436',326447.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','238886',4584408,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238886',4584409,'2910','436',114896.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238913',4584900,'2863','435',156649.39,159892.56,3243.17,535123.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','238913',4584901,'2864','435',133338.07,133338.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238913',4584902,'2865','435',82081.42,88088.02,6006.60,991089.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','238913',4584903,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238913',4584904,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','238913',4584905,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238913',4584906,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','238913',4584907,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','238913',4584908,'2871','435',83070.43,90277.37,7206.94,1189145.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','238913',4584909,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','238913',4584910,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','238913',4584911,'2874','435',52112.95,55403.27,3290.32,542902.80,0.00,0.00,0.00,0.00,0.00),('5','181','972','238913',4584912,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','238913',4584913,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238913',4584914,'2877','436',326447.24,332062.28,5615.04,1937188.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','238913',4584915,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','238913',4584916,'2910','436',114896.25,116255.28,1359.03,468865.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','239623',4597195,'2863','435',159892.56,159892.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239623',4597196,'2864','435',133338.07,133338.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239623',4597197,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239623',4597198,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239623',4597199,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239623',4597200,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239623',4597201,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239623',4597202,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239623',4597203,'2871','435',90277.37,95910.26,5632.89,929426.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','239623',4597204,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239623',4597205,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239623',4597206,'2874','435',55403.27,67187.99,11784.72,1944478.80,0.00,0.00,0.00,0.00,0.00),('5','181','972','239623',4597207,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239623',4597208,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239623',4597209,'2877','436',332062.28,336970.14,4907.86,1693211.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','239623',4597210,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239623',4597211,'2910','436',116255.28,117196.71,941.43,324793.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','239625',4597214,'2863','435',159892.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239625',4597215,'2864','435',133338.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239625',4597216,'2865','435',88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239625',4597217,'2866','435',13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239625',4597218,'2867','435',28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239625',4597219,'2868','435',14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239625',4597220,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239625',4597221,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239625',4597222,'2871','435',95910.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239625',4597223,'2872','435',17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239625',4597224,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239625',4597225,'2874','435',67187.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239625',4597226,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239625',4597227,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239625',4597228,'2877','436',336970.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','239625',4597229,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239625',4597230,'2910','436',117196.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239627',4597232,'2863','435',159892.56,159892.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239627',4597233,'2864','435',133338.07,133338.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239627',4597234,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239627',4597235,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239627',4597236,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239627',4597237,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239627',4597238,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239627',4597239,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239627',4597240,'2871','435',95910.26,95910.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239627',4597241,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239627',4597242,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239627',4597243,'2874','435',67187.99,70531.63,3343.64,551700.60,0.00,0.00,0.00,0.00,0.00),('5','181','972','239627',4597244,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239627',4597245,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239627',4597246,'2877','436',336970.14,345720.71,8750.57,3018946.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','239627',4597247,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239627',4597248,'2910','436',117196.71,119371.45,2174.74,750285.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','239630',4597325,'2863','435',159892.56,163584.44,3691.88,609160.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','239630',4597326,'2864','435',133338.07,137382.68,4044.61,667360.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','239630',4597327,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239630',4597328,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239630',4597329,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239630',4597330,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239630',4597331,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239630',4597332,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239630',4597333,'2871','435',95910.26,95910.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239630',4597334,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239630',4597335,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239630',4597336,'2874','435',70531.63,73774.37,3242.74,535052.10,0.00,0.00,0.00,0.00,0.00),('5','181','972','239630',4597337,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239630',4597338,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239630',4597339,'2877','436',345720.71,352733.52,7012.81,2419419.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','239630',4597340,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239630',4597341,'2910','436',119371.45,121537.10,2165.65,747149.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','239631',4597342,'2863','435',163584.44,168006.45,4422.01,729631.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','239631',4597343,'2864','435',137382.68,142396.67,5013.99,827308.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','239631',4597344,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239631',4597345,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239631',4597346,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239631',4597347,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239631',4597348,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239631',4597349,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239631',4597350,'2871','435',95910.26,95910.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239631',4597351,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239631',4597352,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239631',4597353,'2874','435',73774.37,76395.32,2620.95,432456.75,0.00,0.00,0.00,0.00,0.00),('5','181','972','239631',4597354,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239631',4597355,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239631',4597356,'2877','436',352733.52,360149.46,7415.94,2558499.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','239631',4597357,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239631',4597358,'2910','436',121537.10,123618.72,2081.62,718158.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','239973',4603444,'2863','435',168006.45,170397.51,2391.06,394524.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','239973',4603445,'2864','435',142396.67,143299.16,902.49,148910.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','239973',4603446,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','239973',4603447,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239973',4603448,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','239973',4603449,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239973',4603450,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','239973',4603451,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','239973',4603452,'2871','435',95910.26,100973.79,5063.53,835482.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','239973',4603453,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239973',4603454,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','239973',4603455,'2874','435',76395.32,78628.47,2233.15,368469.75,0.00,0.00,0.00,0.00,0.00),('5','181','972','239973',4603456,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','239973',4603457,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239973',4603458,'2877','436',360149.46,365519.21,5369.75,1852563.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','239973',4603459,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','239973',4603460,'2910','436',123618.72,125447.65,1828.93,630980.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','240070',4605028,'2863','435',170397.51,174855.98,4458.47,735647.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','240070',4605029,'2864','435',143299.16,144965.41,1666.25,274931.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','240070',4605030,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','240070',4605031,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240070',4605032,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240070',4605033,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240070',4605034,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240070',4605035,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','240070',4605036,'2871','435',100973.79,105783.82,4810.03,793654.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','240070',4605037,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','240070',4605038,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','240070',4605039,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240070',4605040,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240070',4605041,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240070',4605042,'2877','436',365519.21,372847.41,7328.20,2528229.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','240070',4605043,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240070',4605044,'2910','436',125447.65,127151.06,1703.41,587676.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','240291',4608880,'2863','435',174855.98,180568.80,5712.82,942615.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','240291',4608881,'2864','435',144965.41,145106.74,141.33,23319.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','240291',4608882,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','240291',4608883,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240291',4608884,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240291',4608885,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240291',4608886,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240291',4608887,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','240291',4608888,'2871','435',105783.82,111288.41,5504.59,908257.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','240291',4608889,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','240291',4608890,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240291',4608891,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240291',4608892,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240291',4608893,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240291',4608894,'2877','436',372847.41,377351.65,4504.24,1553962.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','240291',4608895,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240291',4608896,'2910','436',127151.06,128128.70,977.64,337285.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','240600',4613801,'2863','435',180568.80,184603.90,4035.10,665791.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','240600',4613802,'2864','435',145106.74,145106.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','240600',4613803,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','240600',4613804,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240600',4613805,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240600',4613806,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240600',4613807,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240600',4613808,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','240600',4613809,'2871','435',111288.41,116706.87,5418.46,894045.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','240600',4613810,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','240600',4613811,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240600',4613812,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240600',4613813,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240600',4613814,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240600',4613815,'2877','436',377351.65,383618.04,6266.39,2161904.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','240600',4613816,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240600',4613817,'2910','436',128128.70,128372.00,243.30,83938.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','240765',4616207,'2863','435',184603.90,186317.09,1713.19,282676.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','240765',4616208,'2864','435',145106.74,146613.90,1507.16,248681.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','240765',4616209,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','240765',4616210,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240765',4616211,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','240765',4616212,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240765',4616213,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240765',4616214,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','240765',4616215,'2871','435',116706.87,123009.56,6302.69,1039943.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','240765',4616216,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','240765',4616217,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','240765',4616218,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240765',4616219,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','240765',4616220,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240765',4616221,'2877','436',383618.04,389690.91,6072.87,2095140.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','240765',4616222,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','240765',4616223,'2910','436',128372.00,131042.24,2670.24,921232.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','241040',4621098,'2863','435',186317.09,186317.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241040',4621099,'2864','435',146613.90,146613.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241040',4621100,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241040',4621101,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241040',4621102,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241040',4621103,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241040',4621104,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241040',4621105,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','241040',4621106,'2871','435',123009.56,129366.32,6356.76,1048865.40,0.00,0.00,0.00,0.00,0.00),('5','181','971','241040',4621107,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','241040',4621108,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241040',4621109,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241040',4621110,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241040',4621111,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241040',4621112,'2877','436',389690.91,394175.93,4485.02,1547331.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','241040',4621113,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241040',4621114,'2910','436',131042.24,132501.92,1459.68,503589.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','241325',4626160,'2863','435',186317.09,189294.41,2977.32,491257.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','241325',4626161,'2864','435',146613.90,147840.35,1226.45,202364.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','241325',4626162,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241325',4626163,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241325',4626164,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241325',4626165,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241325',4626166,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241325',4626167,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','241325',4626168,'2871','435',129366.32,133650.77,4284.45,706934.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','241325',4626169,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','241325',4626170,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241325',4626171,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241325',4626172,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241325',4626173,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241325',4626174,'2877','436',394175.93,400682.05,6506.12,2244611.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','241325',4626175,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241325',4626176,'2910','436',132501.92,133846.99,1345.07,464049.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','241590',4630712,'2863','435',189294.41,193035.83,3741.42,617334.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','241590',4630713,'2864','435',147840.35,151474.84,3634.49,599690.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','241590',4630714,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241590',4630715,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241590',4630716,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241590',4630717,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241590',4630718,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241590',4630719,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','241590',4630720,'2871','435',133650.77,135246.64,1595.87,263318.55,0.00,0.00,0.00,0.00,0.00),('5','181','971','241590',4630721,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','241590',4630722,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241590',4630723,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241590',4630724,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241590',4630725,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241590',4630726,'2877','436',400682.05,410210.88,9528.83,3287446.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','241590',4630727,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241590',4630728,'2910','436',133846.99,135852.53,2005.54,691911.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','241809',4634443,'2863','435',193035.83,196604.66,3568.83,588856.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','241809',4634444,'2864','435',151474.84,155074.62,3599.78,593963.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','241809',4634445,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','241809',4634446,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241809',4634447,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','241809',4634448,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241809',4634449,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241809',4634450,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','241809',4634451,'2871','435',135246.64,137927.93,2681.29,442412.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','241809',4634452,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','241809',4634453,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','241809',4634454,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241809',4634455,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','241809',4634456,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241809',4634457,'2877','436',410210.88,417823.65,7612.77,2626405.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','241809',4634458,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','241809',4634459,'2910','436',135852.53,137560.99,1708.46,589418.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','242107',4639698,'2863','435',196604.66,202030.96,5426.30,895339.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','242107',4639699,'2864','435',155074.62,158658.63,3584.01,591361.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','242107',4639700,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242107',4639701,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242107',4639702,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242107',4639703,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242107',4639704,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242107',4639705,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','242107',4639706,'2871','435',137927.93,140254.82,2326.89,383936.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','242107',4639707,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','242107',4639708,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242107',4639709,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242107',4639710,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242107',4639711,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242107',4639712,'2877','436',417823.65,424362.62,6538.97,2255944.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','242107',4639713,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242107',4639714,'2910','436',137560.99,138787.19,1226.20,423039.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242272',4642656,'2863','435',202030.96,203693.72,1662.76,274355.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','242272',4642657,'2864','435',158658.63,163045.67,4387.04,723861.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','242272',4642658,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242272',4642659,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242272',4642660,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242272',4642661,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242272',4642662,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242272',4642663,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','242272',4642664,'2871','435',140254.82,145164.65,4909.83,810121.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','242272',4642665,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','242272',4642666,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242272',4642667,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242272',4642668,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242272',4642669,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242272',4642670,'2877','436',424362.62,430096.81,5734.19,1978295.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','242272',4642671,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242272',4642672,'2910','436',138787.19,141354.88,2567.69,885853.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','242536',4647385,'2863','435',203693.72,209460.17,5766.45,951464.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','242536',4647386,'2864','435',163045.67,166006.46,2960.79,488530.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','242536',4647387,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242536',4647388,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242536',4647389,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242536',4647390,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242536',4647391,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242536',4647392,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','242536',4647393,'2871','435',145164.65,151176.00,6011.35,991872.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','242536',4647394,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','242536',4647395,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242536',4647396,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242536',4647397,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242536',4647398,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242536',4647399,'2877','436',430096.81,437548.39,7451.58,2570795.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','242536',4647400,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242536',4647401,'2910','436',141354.88,144232.31,2877.43,992713.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','242788',4651652,'2863','435',209460.17,216743.57,7283.40,1201761.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242788',4651653,'2864','435',166006.46,169907.51,3901.05,643673.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','242788',4651654,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','242788',4651655,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242788',4651656,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','242788',4651657,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242788',4651658,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242788',4651659,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','242788',4651660,'2871','435',151176.00,158155.25,6979.25,1151576.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','242788',4651661,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','242788',4651662,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','242788',4651663,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242788',4651664,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','242788',4651665,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242788',4651666,'2877','436',437548.39,443953.18,6404.79,2209652.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','242788',4651667,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','242788',4651668,'2910','436',144232.31,147197.14,2964.83,1022866.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','243210',4658998,'2863','435',216743.57,218686.94,1943.37,320656.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','243210',4658999,'2864','435',169907.51,176856.54,6949.03,1146589.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','243210',4659000,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','243210',4659001,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243210',4659002,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243210',4659003,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243210',4659004,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243210',4659005,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','243210',4659006,'2871','435',158155.25,163720.06,5564.81,918193.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','243210',4659007,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','243210',4659008,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243210',4659009,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243210',4659010,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243210',4659011,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243210',4659012,'2877','436',443953.18,450660.46,6707.28,2314011.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','243210',4659013,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243210',4659014,'2910','436',147197.14,149907.48,2710.34,935067.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','243219',4659129,'2863','435',218686.94,226161.80,7474.86,1233351.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','243219',4659130,'2864','435',176856.54,178464.31,1607.77,265282.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','243219',4659131,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','243219',4659132,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243219',4659133,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243219',4659134,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243219',4659135,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243219',4659136,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','243219',4659137,'2871','435',163720.06,172336.07,8616.01,1421641.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','243219',4659138,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','243219',4659139,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243219',4659140,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243219',4659141,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243219',4659142,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243219',4659143,'2877','436',450660.46,458046.29,7385.83,2548111.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','243219',4659144,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243219',4659145,'2910','436',149907.48,152792.07,2884.59,995183.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','243495',4663963,'2863','435',226161.80,233742.46,7580.66,1250808.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','243495',4663964,'2864','435',178464.31,181303.86,2839.55,468525.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','243495',4663965,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','243495',4663966,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243495',4663967,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243495',4663968,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243495',4663969,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243495',4663970,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','243495',4663971,'2871','435',172336.07,180852.26,8516.19,1405171.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','243495',4663972,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','243495',4663973,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243495',4663974,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243495',4663975,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243495',4663976,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243495',4663977,'2877','436',458046.29,463073.03,5026.74,1734225.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','243495',4663978,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243495',4663979,'2910','436',152792.07,153435.25,643.18,221897.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','243837',4669931,'2863','435',233742.46,241374.90,7632.44,1259352.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','243837',4669932,'2864','435',181303.86,184020.44,2716.58,448235.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','243837',4669933,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','243837',4669934,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243837',4669935,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243837',4669936,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243837',4669937,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243837',4669938,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','243837',4669939,'2871','435',180852.26,186968.41,6116.15,1009164.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','243837',4669940,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','243837',4669941,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243837',4669942,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243837',4669943,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243837',4669944,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243837',4669945,'2877','436',463073.03,468372.81,5299.78,1828424.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','243837',4669946,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243837',4669947,'2910','436',153435.25,155331.14,1895.89,654082.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','243985',4672688,'2863','435',241374.90,247260.57,5885.67,971135.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','243985',4672689,'2864','435',184020.44,186527.12,2506.68,413602.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','243985',4672690,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','243985',4672691,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243985',4672692,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','243985',4672693,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243985',4672694,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243985',4672695,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','243985',4672696,'2871','435',186968.41,194060.88,7092.47,1170257.55,0.00,0.00,0.00,0.00,0.00),('5','181','971','243985',4672697,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','243985',4672698,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','243985',4672699,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243985',4672700,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','243985',4672701,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243985',4672702,'2877','436',468372.81,477049.81,8677.00,2993565.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','243985',4672703,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','243985',4672704,'2910','436',155331.14,157206.21,1875.07,646899.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','244119',4674776,'2863','435',247260.57,254857.03,7596.46,1253415.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','244119',4674777,'2864','435',186527.12,189540.50,3013.38,497207.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','244119',4674778,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','244119',4674779,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244119',4674780,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244119',4674781,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244119',4674782,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244119',4674783,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244119',4674784,'2871','435',194060.88,203091.11,9030.23,1489987.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','244119',4674785,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','244119',4674786,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244119',4674787,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244119',4674788,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244119',4674789,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244119',4674790,'2877','436',477049.81,485452.78,8402.97,2899024.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','244119',4674791,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244119',4674792,'2910','436',157206.21,162103.88,4897.67,1689696.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','244346',4678561,'2863','435',254857.03,262272.87,7415.84,1223613.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','244346',4678562,'2864','435',189540.50,192767.24,3226.74,532412.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','244346',4678563,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','244346',4678564,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244346',4678565,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244346',4678566,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244346',4678567,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244346',4678568,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244346',4678569,'2871','435',203091.11,209898.22,6807.11,1123173.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','244346',4678570,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','244346',4678571,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244346',4678572,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244346',4678573,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244346',4678574,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244346',4678575,'2877','436',485452.78,491821.57,6368.79,2197232.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','244346',4678576,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244346',4678577,'2910','436',162103.88,164358.32,2254.44,777781.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','244718',4685206,'2863','435',262272.87,271706.84,9433.97,1556605.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','244718',4685207,'2864','435',192767.24,195979.19,3211.95,529971.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','244718',4685208,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','244718',4685209,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244718',4685210,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244718',4685211,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244718',4685212,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244718',4685213,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244718',4685214,'2871','435',209898.22,209898.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244718',4685215,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','244718',4685216,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244718',4685217,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244718',4685218,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244718',4685219,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244718',4685220,'2877','436',491821.57,498212.35,6390.78,2204819.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','244718',4685221,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244718',4685222,'2910','436',164358.32,166928.91,2570.59,886853.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','244747',4685477,'2863','435',271706.84,274181.15,2474.31,408261.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','244747',4685478,'2864','435',195979.19,198860.83,2881.64,475470.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','244747',4685479,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','244747',4685480,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244747',4685481,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','244747',4685482,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244747',4685483,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244747',4685484,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244747',4685485,'2871','435',209898.22,209898.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','244747',4685486,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','244747',4685487,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','244747',4685488,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244747',4685489,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','244747',4685490,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244747',4685491,'2877','436',498212.35,505077.34,6864.99,2368421.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','244747',4685492,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','244747',4685493,'2910','436',166928.91,170184.15,3255.24,1123057.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','245253',4694338,'2863','435',274181.15,275926.19,1745.04,287931.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','245253',4694339,'2864','435',198860.83,201627.81,2766.98,456551.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','245253',4694340,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245253',4694341,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245253',4694342,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245253',4694343,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245253',4694344,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245253',4694345,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245253',4694346,'2871','435',209898.22,209898.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245253',4694347,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','245253',4694348,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245253',4694349,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245253',4694350,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245253',4694351,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245253',4694352,'2877','436',505077.34,511340.88,6263.54,2160921.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','245253',4694353,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245253',4694354,'2910','436',170184.15,171494.61,1310.46,452108.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','245398',4697156,'2863','435',275926.19,277709.99,1783.80,294327.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245398',4697157,'2864','435',201627.81,204540.80,2912.99,480643.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','245398',4697158,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245398',4697159,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245398',4697160,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245398',4697161,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245398',4697162,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245398',4697163,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245398',4697164,'2871','435',209898.22,212298.67,2400.45,396074.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','245398',4697165,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','245398',4697166,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245398',4697167,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245398',4697168,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245398',4697169,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245398',4697170,'2877','436',511340.88,519016.73,7675.85,2648168.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','245398',4697171,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245398',4697172,'2910','436',171494.61,174859.54,3364.93,1160900.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','245479',4698281,'2863','435',277709.99,285850.59,8140.60,1343199.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245479',4698282,'2864','435',204540.80,204540.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245479',4698283,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245479',4698284,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245479',4698285,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245479',4698286,'2868','435',14259.48,14259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245479',4698287,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245479',4698288,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245479',4698289,'2871','435',212298.67,215545.86,3247.19,535786.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','245479',4698290,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','245479',4698291,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245479',4698292,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245479',4698293,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245479',4698294,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245479',4698295,'2877','436',519016.73,525985.26,6968.53,2404142.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','245479',4698296,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245479',4698297,'2910','436',174859.54,176674.01,1814.47,625992.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','245697',4702050,'2863','435',285850.59,295736.23,9885.64,1631130.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','245697',4702051,'2864','435',204540.80,204540.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245697',4702052,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245697',4702053,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245697',4702054,'2867','435',28639.00,28639.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245697',4702055,'2868','435',14259.48,14764.89,505.41,83392.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','245697',4702056,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245697',4702057,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245697',4702058,'2871','435',215545.86,215545.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245697',4702059,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','245697',4702060,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245697',4702061,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245697',4702062,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245697',4702063,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245697',4702064,'2877','436',525985.26,531960.60,5975.34,2061492.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','245697',4702065,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245697',4702066,'2910','436',176674.01,177890.71,1216.70,419761.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','245978',4706344,'2863','435',295736.23,299890.81,4154.58,685505.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','245978',4706345,'2864','435',204540.80,210144.34,5603.54,924584.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','245978',4706346,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','245978',4706347,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','245978',4706348,'2867','435',28639.00,28859.45,220.45,36374.25,0.00,0.00,0.00,0.00,0.00),('5','181','968','245978',4706349,'2868','435',14764.89,14764.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245978',4706350,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245978',4706351,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','245978',4706352,'2871','435',215545.86,222346.16,6800.30,1122049.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','245978',4706353,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','245978',4706354,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','245978',4706355,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245978',4706356,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','245978',4706357,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245978',4706358,'2877','436',531960.60,540652.99,8692.39,2998874.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','245978',4706359,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','245978',4706360,'2910','436',177890.71,181316.42,3425.71,1181869.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','246206',4710288,'2863','435',299890.81,304854.19,4963.38,818957.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','246206',4710289,'2864','435',210144.34,210144.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246206',4710290,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246206',4710291,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','246206',4710292,'2867','435',28859.45,33171.05,4311.60,711414.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','246206',4710293,'2868','435',14764.89,14764.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246206',4710294,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246206',4710295,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','246206',4710296,'2871','435',222346.16,225512.61,3166.45,522464.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','246206',4710297,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','246206',4710298,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246206',4710299,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246206',4710300,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246206',4710301,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246206',4710302,'2877','436',540652.99,549315.29,8662.30,2988493.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','246206',4710303,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246206',4710304,'2910','436',181316.42,184642.03,3325.61,1147335.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','246472',4714746,'2863','435',304854.19,305239.05,384.86,63501.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','246472',4714747,'2864','435',210144.34,210144.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246472',4714748,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246472',4714749,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','246472',4714750,'2867','435',33171.05,39696.57,6525.52,1076710.80,0.00,0.00,0.00,0.00,0.00),('5','181','968','246472',4714751,'2868','435',14764.89,16651.06,1886.17,311218.05,0.00,0.00,0.00,0.00,0.00),('5','181','969','246472',4714752,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246472',4714753,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','246472',4714754,'2871','435',225512.61,226889.78,1377.17,227233.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','246472',4714755,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','246472',4714756,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246472',4714757,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246472',4714758,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246472',4714759,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246472',4714760,'2877','436',549315.29,556676.17,7360.88,2539503.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','246472',4714761,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246472',4714762,'2910','436',184642.03,186544.07,1902.04,656203.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','246774',4720098,'2863','435',305239.05,305239.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246774',4720099,'2864','435',210144.34,212680.54,2536.20,418473.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246774',4720100,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','246774',4720101,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','246774',4720102,'2867','435',39696.57,44515.71,4819.14,795158.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','246774',4720103,'2868','435',16651.06,16651.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246774',4720104,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246774',4720105,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','246774',4720106,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','246774',4720107,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','246774',4720108,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','246774',4720109,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246774',4720110,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','246774',4720111,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246774',4720112,'2877','436',556676.17,566571.23,9895.06,3413795.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','246774',4720113,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','246774',4720114,'2910','436',186544.07,190170.39,3626.32,1251080.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','247094',4725697,'2863','435',305239.05,312328.15,7089.10,1169701.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','247094',4725698,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247094',4725699,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247094',4725700,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247094',4725701,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247094',4725702,'2868','435',16651.06,19121.38,2470.32,407602.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','247094',4725703,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247094',4725704,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247094',4725705,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247094',4725706,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','247094',4725707,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247094',4725708,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247094',4725709,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247094',4725710,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247094',4725711,'2877','436',566571.23,575966.09,9394.86,3241226.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','247094',4725712,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247094',4725713,'2910','436',190170.39,194723.15,4552.76,1570702.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','247240',4728095,'2863','435',312328.15,316596.12,4267.97,704215.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','247240',4728096,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247240',4728097,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247240',4728098,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247240',4728099,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247240',4728100,'2868','435',19121.38,21934.16,2812.78,464108.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','247240',4728101,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247240',4728102,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247240',4728103,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247240',4728104,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','247240',4728105,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247240',4728106,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247240',4728107,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247240',4728108,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247240',4728109,'2877','436',575966.09,584748.95,8782.86,3030086.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','247240',4728110,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247240',4728111,'2910','436',194723.15,200057.17,5334.02,1840236.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','247478',4732411,'2863','435',316596.12,321238.06,4641.94,765920.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','247478',4732412,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247478',4732413,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247478',4732414,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247478',4732415,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247478',4732416,'2868','435',21934.16,25039.16,3105.00,512325.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247478',4732417,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247478',4732418,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247478',4732419,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247478',4732420,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','247478',4732421,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247478',4732422,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247478',4732423,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247478',4732424,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247478',4732425,'2877','436',584748.95,589793.56,5044.61,1740390.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','247478',4732426,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247478',4732427,'2910','436',200057.17,202060.36,2003.19,691100.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','247756',4737055,'2863','435',321238.06,325182.91,3944.85,650900.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','247756',4737056,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247756',4737057,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247756',4737058,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247756',4737059,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247756',4737060,'2868','435',25039.16,27346.42,2307.26,380697.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','247756',4737061,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247756',4737062,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247756',4737063,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247756',4737064,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','247756',4737065,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247756',4737066,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247756',4737067,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247756',4737068,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247756',4737069,'2877','436',589793.56,595955.41,6161.85,2125838.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','247756',4737070,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247756',4737071,'2910','436',202060.36,203699.10,1638.74,565365.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','247991',4740952,'2863','435',325182.91,327757.20,2574.29,424757.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','247991',4740953,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247991',4740954,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','247991',4740955,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247991',4740956,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','247991',4740957,'2868','435',27346.42,29961.78,2615.36,431534.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','247991',4740958,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247991',4740959,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247991',4740960,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','247991',4740961,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','247991',4740962,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','247991',4740963,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247991',4740964,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','247991',4740965,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247991',4740966,'2877','436',595955.41,603912.64,7957.23,2745244.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','247991',4740967,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','247991',4740968,'2910','436',203699.10,206966.85,3267.75,1127373.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','248240',4745205,'2863','435',327757.20,331722.40,3965.20,654258.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248240',4745206,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248240',4745207,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248240',4745208,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248240',4745209,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248240',4745210,'2868','435',29961.78,33133.47,3171.69,523328.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','248240',4745211,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248240',4745212,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','248240',4745213,'2871','435',226889.78,226889.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','248240',4745214,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','248240',4745215,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248240',4745216,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248240',4745217,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248240',4745218,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248240',4745219,'2877','436',603912.64,608606.68,4694.04,1619443.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','248240',4745220,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248240',4745221,'2910','436',206966.85,208303.80,1336.95,461247.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','248483',4749251,'2863','435',331722.40,334096.50,2374.10,391726.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','248483',4749252,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248483',4749253,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248483',4749254,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248483',4749255,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248483',4749256,'2868','435',33133.47,34092.74,959.27,158279.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','248483',4749257,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248483',4749258,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','248483',4749259,'2871','435',226889.78,234014.49,7124.71,1175577.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','248483',4749260,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','248483',4749261,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248483',4749262,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248483',4749263,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248483',4749264,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248483',4749265,'2877','436',608606.68,614291.04,5684.36,1961104.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','248483',4749266,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248483',4749267,'2910','436',208303.80,211507.17,3203.37,1105162.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','248830',4755378,'2863','435',334096.50,337178.13,3081.63,508468.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','248830',4755379,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248830',4755380,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','248830',4755381,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248830',4755382,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','248830',4755383,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248830',4755384,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248830',4755385,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','248830',4755386,'2871','435',234014.49,238965.50,4951.01,816916.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','248830',4755387,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','248830',4755388,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','248830',4755389,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248830',4755390,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','248830',4755391,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248830',4755392,'2877','436',614291.04,619111.82,4820.78,1663169.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','248830',4755393,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','248830',4755394,'2910','436',211507.17,213110.89,1603.72,553283.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','249042',4758934,'2863','435',337178.13,339728.09,2549.96,420743.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','249042',4758935,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249042',4758936,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249042',4758937,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249042',4758938,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249042',4758939,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249042',4758940,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249042',4758941,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','249042',4758942,'2871','435',238965.50,242347.95,3382.45,558104.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','249042',4758943,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','249042',4758944,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249042',4758945,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249042',4758946,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249042',4758947,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249042',4758948,'2877','436',619111.82,625162.67,6050.85,2087543.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','249042',4758949,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249042',4758950,'2910','436',213110.89,213949.84,838.95,289437.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','249179',4760930,'2863','435',339728.09,342759.17,3031.08,500128.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','249179',4760931,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249179',4760932,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249179',4760933,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249179',4760934,'2867','435',44515.71,44515.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249179',4760935,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249179',4760936,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249179',4760937,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','249179',4760938,'2871','435',242347.95,247563.52,5215.57,860569.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','249179',4760939,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','249179',4760940,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249179',4760941,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249179',4760942,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249179',4760943,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249179',4760944,'2877','436',625162.67,633233.08,8070.41,2784291.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','249179',4760945,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249179',4760946,'2910','436',213949.84,215922.83,1972.99,680681.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','249443',4765496,'2863','435',342759.17,343068.21,309.04,50991.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','249443',4765497,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249443',4765498,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249443',4765499,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249443',4765500,'2867','435',44515.71,46269.32,1753.61,289345.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','249443',4765501,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249443',4765502,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249443',4765503,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','249443',4765504,'2871','435',247563.52,250004.62,2441.10,402781.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','249443',4765505,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','249443',4765506,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249443',4765507,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249443',4765508,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249443',4765509,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249443',4765510,'2877','436',633233.08,640111.66,6878.58,2373110.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','249443',4765511,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249443',4765512,'2910','436',215922.83,217794.90,1872.07,645864.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','249688',4769580,'2863','435',343068.21,343068.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249688',4769581,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249688',4769582,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249688',4769583,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249688',4769584,'2867','435',46269.32,48081.70,1812.38,299042.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','249688',4769585,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249688',4769586,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249688',4769587,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','249688',4769588,'2871','435',250004.62,252734.69,2730.07,450461.55,0.00,0.00,0.00,0.00,0.00),('5','181','971','249688',4769589,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','249688',4769590,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249688',4769591,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249688',4769592,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249688',4769593,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249688',4769594,'2877','436',640111.66,647442.31,7330.65,2529074.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','249688',4769595,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249688',4769596,'2910','436',217794.90,220129.90,2335.00,805575.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249971',4774588,'2863','435',343068.21,351601.07,8532.86,1407921.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','249971',4774589,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249971',4774590,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','249971',4774591,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249971',4774592,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','249971',4774593,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249971',4774594,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249971',4774595,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','249971',4774596,'2871','435',252734.69,255158.31,2423.62,399897.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','249971',4774597,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','249971',4774598,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','249971',4774599,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249971',4774600,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','249971',4774601,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249971',4774602,'2877','436',647442.31,654591.47,7149.16,2466460.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','249971',4774603,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','249971',4774604,'2910','436',220129.90,221935.60,1805.70,622966.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','250244',4779070,'2863','435',351601.07,359696.51,8095.44,1335747.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','250244',4779071,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250244',4779072,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250244',4779073,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250244',4779074,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250244',4779075,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250244',4779076,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250244',4779077,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','250244',4779078,'2871','435',255158.31,257762.40,2604.09,429674.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','250244',4779079,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','250244',4779080,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250244',4779081,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250244',4779082,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250244',4779083,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250244',4779084,'2877','436',654591.47,662555.49,7964.02,2747586.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','250244',4779085,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250244',4779086,'2910','436',221935.60,223704.69,1769.09,610336.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','250504',4783328,'2863','435',359696.51,363409.19,3712.68,612592.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','250504',4783329,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250504',4783330,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250504',4783331,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250504',4783332,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250504',4783333,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250504',4783334,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250504',4783335,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','250504',4783336,'2871','435',257762.40,260544.91,2782.51,459114.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','250504',4783337,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','250504',4783338,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250504',4783339,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250504',4783340,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250504',4783341,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250504',4783342,'2877','436',662555.49,668919.42,6363.93,2195555.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','250504',4783343,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250504',4783344,'2910','436',223704.69,225425.71,1721.02,593751.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','250681',4786353,'2863','435',363409.19,370767.77,7358.58,1214165.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','250681',4786354,'2864','435',212680.54,212680.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250681',4786355,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250681',4786356,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250681',4786357,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250681',4786358,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250681',4786359,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250681',4786360,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','250681',4786361,'2871','435',260544.91,264795.19,4250.28,701296.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','250681',4786362,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','250681',4786363,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250681',4786364,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250681',4786365,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250681',4786366,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250681',4786367,'2877','436',668919.42,674487.77,5568.35,1921080.75,0.00,0.00,0.00,0.00,0.00),('5','181','974','250681',4786368,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250681',4786369,'2910','436',225425.71,226758.39,1332.68,459774.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','250973',4791757,'2863','435',370767.77,370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250973',4791758,'2864','435',212680.54,215550.40,2869.86,473526.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','250973',4791759,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','250973',4791760,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250973',4791761,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','250973',4791762,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250973',4791763,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250973',4791764,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','250973',4791765,'2871','435',264795.19,274537.60,9742.41,1607497.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','250973',4791766,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','250973',4791767,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','250973',4791768,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250973',4791769,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','250973',4791770,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250973',4791771,'2877','436',674487.77,681586.53,7098.76,2449072.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','250973',4791772,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','250973',4791773,'2910','436',226758.39,227814.10,1055.71,364219.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','251222',4796034,'2863','435',370767.77,370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251222',4796035,'2864','435',215550.40,219601.94,4051.54,668504.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','251222',4796036,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251222',4796037,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251222',4796038,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251222',4796039,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251222',4796040,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251222',4796041,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','251222',4796042,'2871','435',274537.60,278124.85,3587.25,591896.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','251222',4796043,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','251222',4796044,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251222',4796045,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251222',4796046,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251222',4796047,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251222',4796048,'2877','436',681586.53,686473.38,4886.85,1685963.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','251222',4796049,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251222',4796050,'2910','436',227814.10,229521.21,1707.11,588952.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','251330',4797737,'2863','435',370767.77,370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251330',4797738,'2864','435',219601.94,234012.61,14410.67,2377760.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','251330',4797739,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251330',4797740,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251330',4797741,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251330',4797742,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251330',4797743,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251330',4797744,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','251330',4797745,'2871','435',278124.85,281396.30,3271.45,539789.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','251330',4797746,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','251330',4797747,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251330',4797748,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251330',4797749,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251330',4797750,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251330',4797751,'2877','436',686473.38,693048.75,6575.37,2268502.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','251330',4797752,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251330',4797753,'2910','436',229521.21,233315.17,3793.96,1308916.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','251604',4802454,'2863','435',370767.77,370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251604',4802455,'2864','435',234012.61,240035.42,6022.81,993763.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','251604',4802456,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251604',4802457,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251604',4802458,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251604',4802459,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251604',4802460,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251604',4802461,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','251604',4802462,'2871','435',281396.30,285111.40,3715.10,612991.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','251604',4802463,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','251604',4802464,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251604',4802465,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251604',4802466,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251604',4802467,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251604',4802468,'2877','436',693048.75,699829.00,6780.25,2339186.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','251604',4802469,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251604',4802470,'2910','436',233315.17,236074.04,2758.87,951810.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','251895',4807591,'2863','435',370767.77,370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251895',4807592,'2864','435',240035.42,242552.12,2516.70,415255.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','251895',4807593,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','251895',4807594,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251895',4807595,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','251895',4807596,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251895',4807597,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251895',4807598,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','251895',4807599,'2871','435',285111.40,288950.78,3839.38,633497.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','251895',4807600,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','251895',4807601,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','251895',4807602,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251895',4807603,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','251895',4807604,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251895',4807605,'2877','436',699829.00,704798.93,4969.93,1714625.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','251895',4807606,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','251895',4807607,'2910','436',236074.04,236962.08,888.04,306373.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','252219',4813369,'2863','435',370767.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252219',4813370,'2864','435',242552.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252219',4813371,'2865','435',88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252219',4813372,'2866','435',13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252219',4813373,'2867','435',48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252219',4813374,'2868','435',34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252219',4813375,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252219',4813376,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252219',4813377,'2871','435',288950.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252219',4813378,'2872','435',17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','252219',4813379,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252219',4813380,'2874','435',78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252219',4813381,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252219',4813382,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252219',4813383,'2877','436',704798.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','252219',4813384,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252219',4813385,'2910','436',236962.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252292',4814296,'2863','435',370767.77,373662.51,2894.74,477632.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','252292',4814297,'2864','435',242552.12,242552.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252292',4814298,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252292',4814299,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252292',4814300,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252292',4814301,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252292',4814302,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252292',4814303,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252292',4814304,'2871','435',288950.78,292643.47,3692.69,609293.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','252292',4814305,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','252292',4814306,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252292',4814307,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252292',4814308,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252292',4814309,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252292',4814310,'2877','436',704798.93,708582.26,3783.33,1305248.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','252292',4814311,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252292',4814312,'2910','436',236962.08,237789.60,827.52,285494.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','252385',4816247,'2863','435',373662.51,373666.32,3.81,628.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','252385',4816248,'2864','435',242552.12,245506.54,2954.42,487479.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','252385',4816249,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252385',4816250,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252385',4816251,'2867','435',48081.70,48081.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252385',4816252,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252385',4816253,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252385',4816254,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252385',4816255,'2871','435',292643.47,294899.29,2255.82,372210.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','252385',4816256,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','252385',4816257,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252385',4816258,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252385',4816259,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252385',4816260,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252385',4816261,'2877','436',708582.26,714254.46,5672.20,1956909.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','252385',4816262,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252385',4816263,'2910','436',237789.60,238815.31,1025.71,353869.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','252674',4821419,'2863','435',373666.32,373666.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252674',4821420,'2864','435',245506.54,245506.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252674',4821421,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252674',4821422,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252674',4821423,'2867','435',48081.70,66423.91,18342.21,3026464.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','252674',4821424,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252674',4821425,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252674',4821426,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252674',4821427,'2871','435',294899.29,298041.68,3142.39,518494.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','252674',4821428,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','252674',4821429,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252674',4821430,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252674',4821431,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252674',4821432,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252674',4821433,'2877','436',714254.46,721422.34,7167.88,2472918.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','252674',4821434,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252674',4821435,'2910','436',238815.31,242400.34,3585.03,1236835.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','252770',4822702,'2863','435',373666.32,373666.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252770',4822703,'2864','435',245506.54,245506.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252770',4822704,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','252770',4822705,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','252770',4822706,'2867','435',66423.91,71196.92,4773.01,787546.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','252770',4822707,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252770',4822708,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252770',4822709,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','252770',4822710,'2871','435',298041.68,301909.60,3867.92,638206.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','252770',4822711,'2872','435',17848.31,17848.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','252770',4822712,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','252770',4822713,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252770',4822714,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','252770',4822715,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252770',4822716,'2877','436',721422.34,728187.65,6765.31,2334031.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','252770',4822717,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','252770',4822718,'2910','436',242400.34,245962.06,3561.72,1228793.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','253097',4828368,'2863','435',373666.32,373666.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253097',4828369,'2864','435',245506.54,245506.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253097',4828370,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253097',4828371,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253097',4828372,'2867','435',71196.92,74391.00,3194.08,527023.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','253097',4828373,'2868','435',34092.74,34092.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253097',4828374,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253097',4828375,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','253097',4828376,'2871','435',301909.60,304407.17,2497.57,412099.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','253097',4828377,'2872','435',17848.31,19537.73,1689.42,278754.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','253097',4828378,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253097',4828379,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253097',4828380,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253097',4828381,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253097',4828382,'2877','436',728187.65,734360.18,6172.53,2129522.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','253097',4828383,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253097',4828384,'2910','436',245962.06,247383.18,1421.12,490286.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','253420',4833856,'2863','435',373666.32,373666.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253420',4833857,'2864','435',245506.54,250195.49,4688.95,773676.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','253420',4833858,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253420',4833859,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253420',4833860,'2867','435',74391.00,75834.75,1443.75,238218.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','253420',4833861,'2868','435',34092.74,36084.98,1992.24,328719.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','253420',4833862,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253420',4833863,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','253420',4833864,'2871','435',304407.17,307190.88,2783.71,459312.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','253420',4833865,'2872','435',19537.73,21232.85,1695.12,279694.80,0.00,0.00,0.00,0.00,0.00),('5','181','970','253420',4833866,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253420',4833867,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253420',4833868,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253420',4833869,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253420',4833870,'2877','436',734360.18,741400.74,7040.56,2428993.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','253420',4833871,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253420',4833872,'2910','436',247383.18,250868.46,3485.28,1202421.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','253581',4836523,'2863','435',373666.32,373666.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253581',4836524,'2864','435',250195.49,255162.41,4966.92,819541.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','253581',4836525,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253581',4836526,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253581',4836527,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253581',4836528,'2868','435',36084.98,39916.85,3831.87,632258.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','253581',4836529,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253581',4836530,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','253581',4836531,'2871','435',307190.88,309943.24,2752.36,454139.40,0.00,0.00,0.00,0.00,0.00),('5','181','971','253581',4836532,'2872','435',21232.85,22313.04,1080.19,178231.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','253581',4836533,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253581',4836534,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253581',4836535,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253581',4836536,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253581',4836537,'2877','436',741400.74,749544.26,8143.52,2809514.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','253581',4836538,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253581',4836539,'2910','436',250868.46,254563.99,3695.53,1274957.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','253768',4839626,'2863','435',373666.32,381435.27,7768.95,1281876.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','253768',4839627,'2864','435',255162.41,255162.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253768',4839628,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','253768',4839629,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253768',4839630,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','253768',4839631,'2868','435',39916.85,41582.63,1665.78,274853.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','253768',4839632,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253768',4839633,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','253768',4839634,'2871','435',309943.24,314523.94,4580.70,755815.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','253768',4839635,'2872','435',22313.04,23093.48,780.44,128772.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','253768',4839636,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','253768',4839637,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253768',4839638,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','253768',4839639,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253768',4839640,'2877','436',749544.26,756526.22,6981.96,2408776.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','253768',4839641,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','253768',4839642,'2910','436',254563.99,257576.07,3012.08,1039167.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','254083',4845283,'2863','435',381435.27,384628.35,3193.08,526858.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','254083',4845284,'2864','435',255162.41,257581.60,2419.19,399166.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','254083',4845285,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254083',4845286,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254083',4845287,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254083',4845288,'2868','435',41582.63,41582.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254083',4845289,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254083',4845290,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254083',4845291,'2871','435',314523.94,319122.02,4598.08,758683.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','254083',4845292,'2872','435',23093.48,24936.74,1843.26,304137.90,0.00,0.00,0.00,0.00,0.00),('5','181','970','254083',4845293,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254083',4845294,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254083',4845295,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254083',4845296,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254083',4845297,'2877','436',756526.22,763873.14,7346.92,2534687.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','254083',4845298,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254083',4845299,'2910','436',257576.07,258842.23,1266.16,436825.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','254332',4849651,'2863','435',384628.35,384628.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254332',4849652,'2864','435',257581.60,263812.56,6230.96,1028108.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','254332',4849653,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254332',4849654,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254332',4849655,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254332',4849656,'2868','435',41582.63,43687.16,2104.53,347247.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','254332',4849657,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254332',4849658,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254332',4849659,'2871','435',319122.02,324023.52,4901.50,808747.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','254332',4849660,'2872','435',24936.74,27338.63,2401.89,396311.85,0.00,0.00,0.00,0.00,0.00),('5','181','970','254332',4849661,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254332',4849662,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254332',4849663,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254332',4849664,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254332',4849665,'2877','436',763873.14,769830.56,5957.42,2055309.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','254332',4849666,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254332',4849667,'2910','436',258842.23,262087.51,3245.28,1119621.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','254541',4853314,'2863','435',384628.35,384628.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254541',4853315,'2864','435',263812.56,264370.20,557.64,92010.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','254541',4853316,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254541',4853317,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254541',4853318,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254541',4853319,'2868','435',43687.16,45783.68,2096.52,345925.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','254541',4853320,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254541',4853321,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254541',4853322,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254541',4853323,'2872','435',27338.63,36289.02,8950.39,1476814.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','254541',4853324,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254541',4853325,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254541',4853326,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254541',4853327,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254541',4853328,'2877','436',769830.56,776651.10,6820.54,2353086.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','254541',4853329,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254541',4853330,'2910','436',262087.51,266876.36,4788.85,1652153.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','254809',4857835,'2863','435',384628.35,388785.52,4157.17,685933.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','254809',4857836,'2864','435',264370.20,269180.72,4810.52,793735.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','254809',4857837,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','254809',4857838,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254809',4857839,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','254809',4857840,'2868','435',45783.68,45783.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254809',4857841,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254809',4857842,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254809',4857843,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','254809',4857844,'2872','435',36289.02,38617.43,2328.41,384187.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','254809',4857845,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','254809',4857846,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254809',4857847,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','254809',4857848,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254809',4857849,'2877','436',776651.10,783178.33,6527.23,2251894.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','254809',4857850,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','254809',4857851,'2910','436',266876.36,269687.33,2810.97,969784.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','255077',4862564,'2863','435',388785.52,395063.46,6277.94,1035860.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','255077',4862565,'2864','435',269180.72,274434.46,5253.74,866867.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','255077',4862566,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255077',4862567,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255077',4862568,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255077',4862569,'2868','435',45783.68,45783.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255077',4862570,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255077',4862571,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255077',4862572,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255077',4862573,'2872','435',38617.43,40623.13,2005.70,330940.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','255077',4862574,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255077',4862575,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255077',4862576,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255077',4862577,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255077',4862578,'2877','436',783178.33,791858.52,8680.19,3038066.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','255077',4862579,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255077',4862580,'2910','436',269687.33,274434.46,4747.13,1661495.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','255254',4865408,'2863','435',395063.46,402596.84,7533.38,1243007.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','255254',4865409,'2864','435',274434.46,274434.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255254',4865410,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255254',4865411,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255254',4865412,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255254',4865413,'2868','435',45783.68,45783.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255254',4865414,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255254',4865415,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255254',4865416,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255254',4865417,'2872','435',40623.13,43526.13,2903.00,478995.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','255254',4865418,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255254',4865419,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255254',4865420,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255254',4865421,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255254',4865422,'2877','436',791858.52,797959.93,6101.41,2135493.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','255254',4865423,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255254',4865424,'2910','436',274434.46,276612.06,2177.60,762160.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255651',4872221,'2863','435',402596.84,402596.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255651',4872222,'2864','435',274434.46,274434.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255651',4872223,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255651',4872224,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255651',4872225,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255651',4872226,'2868','435',45783.68,49636.88,3853.20,635778.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255651',4872227,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255651',4872228,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255651',4872229,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255651',4872230,'2872','435',43526.13,50544.67,7018.54,1158059.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','255651',4872231,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255651',4872232,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255651',4872233,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255651',4872234,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255651',4872235,'2877','436',797959.93,803299.25,5339.32,1868762.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','255651',4872236,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255651',4872237,'2910','436',276612.06,278694.61,2082.55,728892.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','255758',4873853,'2863','435',402596.84,406835.46,4238.62,699372.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','255758',4873854,'2864','435',274434.46,276504.34,2069.88,341530.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','255758',4873855,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','255758',4873856,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255758',4873857,'2867','435',75834.75,75834.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','255758',4873858,'2868','435',49636.88,55174.56,5537.68,913717.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','255758',4873859,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255758',4873860,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255758',4873861,'2871','435',324023.52,324023.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','255758',4873862,'2872','435',50544.67,50544.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','255758',4873863,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','255758',4873864,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255758',4873865,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','255758',4873866,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255758',4873867,'2877','436',803299.25,809047.15,5747.90,2011765.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','255758',4873868,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','255758',4873869,'2910','436',278694.61,280661.92,1967.31,688558.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','256029',4878426,'2863','435',406835.46,410755.13,3919.67,646745.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','256029',4878427,'2864','435',276504.34,280098.97,3594.63,593113.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','256029',4878428,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256029',4878429,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256029',4878430,'2867','435',75834.75,75855.82,21.07,3476.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','256029',4878431,'2868','435',55174.56,61344.28,6169.72,1018003.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','256029',4878432,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256029',4878433,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','256029',4878434,'2871','435',324023.52,325326.20,1302.68,214942.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','256029',4878435,'2872','435',50544.67,52406.60,1861.93,307218.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','256029',4878436,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256029',4878437,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256029',4878438,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256029',4878439,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256029',4878440,'2877','436',809047.15,816028.95,6981.80,2443630.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','256029',4878441,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256029',4878442,'2910','436',280661.92,283584.89,2922.97,1023039.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','256287',4882390,'2863','435',410755.13,410755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256287',4882391,'2864','435',280098.97,285587.83,5488.86,905661.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','256287',4882392,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256287',4882393,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256287',4882394,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256287',4882395,'2868','435',61344.28,66793.47,5449.19,899116.35,0.00,0.00,0.00,0.00,0.00),('5','181','969','256287',4882396,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256287',4882397,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','256287',4882398,'2871','435',325326.20,327377.08,2050.88,338395.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','256287',4882399,'2872','435',52406.60,53537.40,1130.80,186582.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','256287',4882400,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256287',4882401,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256287',4882402,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256287',4882403,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256287',4882404,'2877','436',816028.95,823126.92,7097.97,2519779.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','256287',4882405,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256287',4882406,'2910','436',283584.89,285125.73,1540.84,546998.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','256600',4887963,'2863','435',410755.13,410755.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256600',4887964,'2864','435',285587.83,292583.50,6995.67,1154285.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','256600',4887965,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256600',4887966,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256600',4887967,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256600',4887968,'2868','435',66793.47,66793.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256600',4887969,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256600',4887970,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','256600',4887971,'2871','435',327377.08,329151.77,1774.69,292823.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','256600',4887972,'2872','435',53537.40,55082.48,1545.08,254938.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','256600',4887973,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256600',4887974,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256600',4887975,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256600',4887976,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256600',4887977,'2877','436',823126.92,831207.70,8080.78,2868676.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','256600',4887978,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256600',4887979,'2910','436',285125.73,287477.94,2352.21,835034.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','256821',4891572,'2863','435',410755.13,410850.22,95.09,15689.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','256821',4891573,'2864','435',292583.50,292583.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256821',4891574,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','256821',4891575,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256821',4891576,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','256821',4891577,'2868','435',66793.47,69934.13,3140.66,518208.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','256821',4891578,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256821',4891579,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','256821',4891580,'2871','435',329151.77,331714.97,2563.20,422928.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','256821',4891581,'2872','435',55082.48,56892.93,1810.45,298724.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','256821',4891582,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','256821',4891583,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256821',4891584,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','256821',4891585,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256821',4891586,'2877','436',831207.70,836253.22,5045.52,1791159.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','256821',4891587,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','256821',4891588,'2910','436',287477.94,289693.31,2215.37,786456.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257134',4897393,'2863','435',410850.22,416929.56,6079.34,1003091.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257134',4897394,'2864','435',292583.50,297398.33,4814.83,794446.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257134',4897395,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257134',4897396,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257134',4897397,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257134',4897398,'2868','435',69934.13,69934.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257134',4897399,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257134',4897400,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257134',4897401,'2871','435',331714.97,333323.39,1608.42,265389.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','257134',4897402,'2872','435',56892.93,58292.78,1399.85,230975.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257134',4897403,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257134',4897404,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257134',4897405,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257134',4897406,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257134',4897407,'2877','436',836253.22,841549.90,5296.68,1880321.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257134',4897408,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257134',4897409,'2910','436',289693.31,294058.91,4365.60,1549788.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257339',4900941,'2863','435',416929.56,421600.32,4670.76,770675.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257339',4900942,'2864','435',297398.33,300294.49,2896.16,477866.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257339',4900943,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257339',4900944,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257339',4900945,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257339',4900946,'2868','435',69934.13,76681.21,6747.08,1113268.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257339',4900947,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257339',4900948,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257339',4900949,'2871','435',333323.39,335142.22,1818.83,300106.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257339',4900950,'2872','435',58292.78,59738.06,1445.28,238471.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','257339',4900951,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257339',4900952,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257339',4900953,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257339',4900954,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257339',4900955,'2877','436',841549.90,846082.91,4533.01,1609218.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','257339',4900956,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257339',4900957,'2910','436',294058.91,296927.03,2868.12,1018182.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257340',4900958,'2863','435',421600.32,430367.67,8767.35,1446612.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257340',4900959,'2864','435',300294.49,300294.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257340',4900960,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257340',4900961,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257340',4900962,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257340',4900963,'2868','435',76681.21,77726.52,1045.31,172476.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257340',4900964,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257340',4900965,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257340',4900966,'2871','435',335142.22,336428.19,1285.97,212185.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257340',4900967,'2872','435',59738.06,61393.04,1654.98,273071.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','257340',4900968,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257340',4900969,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257340',4900970,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257340',4900971,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257340',4900972,'2877','436',846082.91,852520.85,6437.94,2317658.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257340',4900973,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257340',4900974,'2910','436',296927.03,298094.79,1167.76,420393.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257341',4900975,'2863','435',430367.67,434412.83,4045.16,667451.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257341',4900976,'2864','435',300294.49,300294.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257341',4900977,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257341',4900978,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257341',4900979,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257341',4900980,'2868','435',77726.52,77726.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257341',4900981,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257341',4900982,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257341',4900983,'2871','435',336428.19,338971.12,2542.93,419583.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257341',4900984,'2872','435',61393.04,62856.82,1463.78,241523.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','257341',4900985,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257341',4900986,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257341',4900987,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257341',4900988,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257341',4900989,'2877','436',852520.85,852520.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257341',4900990,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257341',4900991,'2910','436',298094.79,298094.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257342',4900992,'2863','435',434412.83,438445.66,4032.83,665416.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257342',4900993,'2864','435',300294.49,304281.82,3987.33,657909.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257342',4900994,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257342',4900995,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257342',4900996,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257342',4900997,'2868','435',77726.52,77726.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257342',4900998,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257342',4900999,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257342',4901000,'2871','435',338971.12,340962.25,1991.13,328536.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257342',4901001,'2872','435',62856.82,64037.22,1180.40,194766.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257342',4901002,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257342',4901003,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257342',4901004,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257342',4901005,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257342',4901006,'2877','436',852520.85,857555.24,5034.39,1812380.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257342',4901007,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257342',4901008,'2910','436',298094.79,304214.00,6119.21,2202915.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257343',4901009,'2863','435',438445.66,444711.23,6265.57,1033819.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257343',4901010,'2864','435',304281.82,309156.31,4874.49,804290.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257343',4901011,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257343',4901012,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257343',4901013,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257343',4901014,'2868','435',77726.52,77726.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257343',4901015,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257343',4901016,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257343',4901017,'2871','435',340962.25,342877.09,1914.84,315948.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','257343',4901018,'2872','435',64037.22,65321.09,1283.87,211838.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','257343',4901019,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257343',4901020,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257343',4901021,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257343',4901022,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257343',4901023,'2877','436',857555.24,863707.33,6152.09,2214752.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257343',4901024,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257343',4901025,'2910','436',304214.00,308387.42,4173.42,1502431.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257344',4901026,'2863','435',444711.23,451267.45,6556.22,1081776.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257344',4901027,'2864','435',309156.31,313912.67,4756.36,784799.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257344',4901028,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257344',4901029,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257344',4901030,'2867','435',75855.82,75855.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257344',4901031,'2868','435',77726.52,77726.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257344',4901032,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257344',4901033,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257344',4901034,'2871','435',342877.09,344277.67,1400.58,231095.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','257344',4901035,'2872','435',65321.09,66965.02,1643.93,271248.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257344',4901036,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257344',4901037,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257344',4901038,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257344',4901039,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257344',4901040,'2877','436',863707.33,869704.21,5996.88,2158876.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257344',4901041,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257344',4901042,'2910','436',308387.42,319176.20,10788.78,3883960.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257345',4901043,'2863','435',451267.45,451267.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257345',4901044,'2864','435',313912.67,316561.47,2648.80,437052.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257345',4901045,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257345',4901046,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257345',4901047,'2867','435',75855.82,80497.87,4642.05,765938.25,0.00,0.00,0.00,0.00,0.00),('5','181','968','257345',4901048,'2868','435',77726.52,80199.58,2473.06,408054.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','257345',4901049,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257345',4901050,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257345',4901051,'2871','435',344277.67,346087.72,1810.05,298658.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','257345',4901052,'2872','435',66965.02,68221.79,1256.77,207367.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','257345',4901053,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257345',4901054,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257345',4901055,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257345',4901056,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257345',4901057,'2877','436',869704.21,870935.30,1231.09,443192.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257345',4901058,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257345',4901059,'2910','436',319176.20,319416.11,239.91,86367.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257346',4901060,'2863','435',451267.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257346',4901061,'2864','435',316561.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257346',4901062,'2865','435',88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257346',4901063,'2866','435',13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257346',4901064,'2867','435',80497.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257346',4901065,'2868','435',80199.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257346',4901066,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257346',4901067,'2870','435',156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257346',4901068,'2871','435',346087.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257346',4901069,'2872','435',68221.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257346',4901070,'2873','435',33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257346',4901071,'2874','435',78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257346',4901072,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257346',4901073,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257346',4901074,'2877','436',870935.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257346',4901075,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257346',4901076,'2910','436',319416.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257347',4901077,'2863','435',451267.45,451267.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257347',4901078,'2864','435',316561.47,316561.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257347',4901079,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257347',4901080,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257347',4901081,'2867','435',80497.87,87594.06,7096.19,1170871.35,0.00,0.00,0.00,0.00,0.00),('5','181','968','257347',4901082,'2868','435',80199.58,86388.85,6189.27,1021229.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257347',4901083,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257347',4901084,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257347',4901085,'2871','435',346087.72,347826.20,1738.48,286849.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257347',4901086,'2872','435',68221.79,69595.12,1373.33,226599.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257347',4901087,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257347',4901088,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257347',4901089,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257347',4901090,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257347',4901091,'2877','436',870935.30,870935.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257347',4901092,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257347',4901093,'2910','436',319416.11,319416.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257348',4901094,'2863','435',451267.45,451267.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257348',4901095,'2864','435',316561.47,316561.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257348',4901096,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257348',4901097,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257348',4901098,'2867','435',87594.06,91056.56,3462.50,571312.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257348',4901099,'2868','435',86388.85,94650.15,8261.30,1363114.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257348',4901100,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257348',4901101,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257348',4901102,'2871','435',347826.20,348969.21,1143.01,188596.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','257348',4901103,'2872','435',69595.12,70457.22,862.10,142246.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257348',4901104,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257348',4901105,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257348',4901106,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257348',4901107,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257348',4901108,'2877','436',870935.30,872147.11,1211.81,442310.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257348',4901109,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257348',4901110,'2910','436',319416.11,320626.23,1210.12,441693.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257349',4901111,'2863','435',451267.45,452155.90,888.45,146594.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257349',4901112,'2864','435',316561.47,317300.68,739.21,121969.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257349',4901113,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257349',4901114,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257349',4901115,'2867','435',91056.56,92673.65,1617.09,266819.85,0.00,0.00,0.00,0.00,0.00),('5','181','968','257349',4901116,'2868','435',94650.15,96884.90,2234.75,368733.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257349',4901117,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257349',4901118,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257349',4901119,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257349',4901120,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257349',4901121,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257349',4901122,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257349',4901123,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257349',4901124,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257349',4901125,'2877','436',872147.11,876285.83,4138.72,1614100.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257349',4901126,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257349',4901127,'2910','436',320626.23,326423.01,5796.78,2260744.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257350',4901128,'2863','435',452155.90,461148.20,8992.30,1483729.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257350',4901129,'2864','435',317300.68,321355.62,4054.94,669065.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257350',4901130,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257350',4901131,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257350',4901132,'2867','435',92673.65,93833.80,1160.15,191424.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','257350',4901133,'2868','435',96884.90,99279.92,2395.02,395178.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','257350',4901134,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257350',4901135,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257350',4901136,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257350',4901137,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257350',4901138,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257350',4901139,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257350',4901140,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257350',4901141,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257350',4901142,'2877','436',876285.83,882720.88,6435.05,2509669.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','257350',4901143,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257350',4901144,'2910','436',326423.01,330753.93,4330.92,1689058.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257351',4901145,'2863','435',461148.20,462786.95,1638.75,270393.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257351',4901146,'2864','435',321355.62,323153.43,1797.81,296638.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257351',4901147,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257351',4901148,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257351',4901149,'2867','435',93833.80,94072.01,238.21,39304.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','257351',4901150,'2868','435',99279.92,99410.58,130.66,21558.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','257351',4901151,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257351',4901152,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257351',4901153,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257351',4901154,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257351',4901155,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257351',4901156,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257351',4901157,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257351',4901158,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257351',4901159,'2877','436',882720.88,889036.08,6315.20,2620808.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257351',4901160,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257351',4901161,'2910','436',330753.93,332778.15,2024.22,840051.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257352',4901162,'2863','435',462786.95,464154.86,1367.91,225705.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257352',4901163,'2864','435',323153.43,326229.34,3075.91,507525.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257352',4901164,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257352',4901165,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257352',4901166,'2867','435',94072.01,94072.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257352',4901167,'2868','435',99410.58,99410.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257352',4901168,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257352',4901169,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257352',4901170,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257352',4901171,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257352',4901172,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257352',4901173,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257352',4901174,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257352',4901175,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257352',4901176,'2877','436',889036.08,894184.10,5148.02,2136428.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','257352',4901177,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257352',4901178,'2910','436',332778.15,335768.76,2990.61,1241103.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257353',4901179,'2863','435',464154.86,465761.55,1606.69,265103.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257353',4901180,'2864','435',326229.34,328510.62,2281.28,376411.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257353',4901181,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257353',4901182,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257353',4901183,'2867','435',94072.01,94072.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257353',4901184,'2868','435',99410.58,99410.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257353',4901185,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257353',4901186,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257353',4901187,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257353',4901188,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257353',4901189,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257353',4901190,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257353',4901191,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257353',4901192,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257353',4901193,'2877','436',894184.10,897837.22,3653.12,1516044.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257353',4901194,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257353',4901195,'2910','436',335768.76,339968.10,4199.34,1742726.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257354',4901196,'2863','435',465761.55,467135.50,1373.95,226701.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257354',4901197,'2864','435',328510.62,331356.68,2846.06,469599.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257354',4901198,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257354',4901199,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257354',4901200,'2867','435',94072.01,94072.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257354',4901201,'2868','435',99410.58,99410.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257354',4901202,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257354',4901203,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257354',4901204,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257354',4901205,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257354',4901206,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257354',4901207,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257354',4901208,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257354',4901209,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257354',4901210,'2877','436',897837.22,902644.84,4807.62,1995162.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','257354',4901211,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257354',4901212,'2910','436',339968.10,347853.15,7885.05,3272295.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257355',4901213,'2863','435',467135.50,469523.85,2388.35,394077.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257355',4901214,'2864','435',331356.68,333795.96,2439.28,402481.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257355',4901215,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257355',4901216,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257355',4901217,'2867','435',94072.01,94072.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257355',4901218,'2868','435',99410.58,99410.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257355',4901219,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257355',4901220,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257355',4901221,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257355',4901222,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257355',4901223,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257355',4901224,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257355',4901225,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257355',4901226,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257355',4901227,'2877','436',902644.84,904566.68,1921.84,797563.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257355',4901228,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257355',4901229,'2910','436',347853.15,352265.32,4412.17,1831050.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257356',4901230,'2863','435',469523.85,471828.10,2304.25,380201.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257356',4901231,'2864','435',333795.96,336063.85,2267.89,374201.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257356',4901232,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257356',4901233,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257356',4901234,'2867','435',94072.01,94706.54,634.53,104697.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257356',4901235,'2868','435',99410.58,100644.97,1234.39,203674.35,0.00,0.00,0.00,0.00,0.00),('5','181','969','257356',4901236,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257356',4901237,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257356',4901238,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257356',4901239,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257356',4901240,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257356',4901241,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257356',4901242,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257356',4901243,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257356',4901244,'2877','436',904566.68,906536.56,1969.88,817500.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257356',4901245,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257356',4901246,'2910','436',352265.32,361922.09,9656.77,4007559.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257357',4901247,'2863','435',471828.10,471828.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257357',4901248,'2864','435',336063.85,336063.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257357',4901249,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257357',4901250,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257357',4901251,'2867','435',94706.54,96917.28,2210.74,364772.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257357',4901252,'2868','435',100644.97,104654.32,4009.35,661542.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257357',4901253,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257357',4901254,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257357',4901255,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257357',4901256,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257357',4901257,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257357',4901258,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257357',4901259,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257357',4901260,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257357',4901261,'2877','436',906536.56,910603.93,4067.37,1687958.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','257357',4901262,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257357',4901263,'2910','436',361922.09,362709.66,787.57,326841.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257358',4901264,'2863','435',471828.10,473825.57,1997.47,329582.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257358',4901265,'2864','435',336063.85,336395.15,331.30,54664.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257358',4901266,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257358',4901267,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257358',4901268,'2867','435',96917.28,99213.30,2296.02,378843.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','257358',4901269,'2868','435',104654.32,107135.96,2481.64,409470.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','257358',4901270,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257358',4901271,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257358',4901272,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257358',4901273,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257358',4901274,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257358',4901275,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257358',4901276,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257358',4901277,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257358',4901278,'2877','436',910603.93,916977.94,6374.01,2645214.15,0.00,0.00,0.00,0.00,0.00),('5','181','974','257358',4901279,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257358',4901280,'2910','436',362709.66,364958.06,2248.40,933086.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257359',4901281,'2863','435',473825.57,476524.60,2699.03,445339.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257359',4901282,'2864','435',336395.15,336395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257359',4901283,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257359',4901284,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257359',4901285,'2867','435',99213.30,102497.95,3284.65,541967.25,0.00,0.00,0.00,0.00,0.00),('5','181','968','257359',4901286,'2868','435',107135.96,111070.70,3934.74,649232.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257359',4901287,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257359',4901288,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257359',4901289,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257359',4901290,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257359',4901291,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257359',4901292,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257359',4901293,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257359',4901294,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257359',4901295,'2877','436',916977.94,921035.33,4057.39,1683816.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','257359',4901296,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257359',4901297,'2910','436',364958.06,365294.06,336.00,139440.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257360',4901298,'2863','435',476524.60,478406.59,1881.99,310528.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257360',4901299,'2864','435',336395.15,338422.68,2027.53,334542.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257360',4901300,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257360',4901301,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257360',4901302,'2867','435',102497.95,103432.95,935.00,154275.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257360',4901303,'2868','435',111070.70,113173.01,2102.31,346881.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257360',4901304,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257360',4901305,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257360',4901306,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257360',4901307,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257360',4901308,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257360',4901309,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257360',4901310,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257360',4901311,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257360',4901312,'2877','436',921035.33,927074.16,6038.83,2506114.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','257360',4901313,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257360',4901314,'2910','436',365294.06,366594.23,1300.17,539570.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257361',4901315,'2863','435',478406.59,481512.11,3105.52,512410.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257361',4901316,'2864','435',338422.68,341381.13,2958.45,488144.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257361',4901317,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257361',4901318,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257361',4901319,'2867','435',103432.95,103432.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257361',4901320,'2868','435',113173.01,113173.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257361',4901321,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257361',4901322,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257361',4901323,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257361',4901324,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257361',4901325,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257361',4901326,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257361',4901327,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257361',4901328,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257361',4901329,'2877','436',927074.16,932900.12,5825.96,2417773.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257361',4901330,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257361',4901331,'2910','436',366594.23,369391.51,2797.28,1160871.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257362',4901332,'2863','435',481512.11,484976.78,3464.67,571670.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257362',4901333,'2864','435',341381.13,344869.11,3487.98,575516.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257362',4901334,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257362',4901335,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257362',4901336,'2867','435',103432.95,103432.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257362',4901337,'2868','435',113173.01,113173.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257362',4901338,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257362',4901339,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257362',4901340,'2871','435',348969.21,348969.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257362',4901341,'2872','435',70457.22,70457.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257362',4901342,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257362',4901343,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257362',4901344,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257362',4901345,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257362',4901346,'2877','436',932900.12,938917.25,6017.13,2497108.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','257362',4901347,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257362',4901348,'2910','436',369391.51,369790.83,399.32,165717.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257363',4901349,'2863','435',484976.78,484976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257363',4901350,'2864','435',344869.11,348509.54,3640.43,600670.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257363',4901351,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257363',4901352,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257363',4901353,'2867','435',103432.95,105007.29,1574.34,259766.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257363',4901354,'2868','435',113173.01,115545.04,2372.03,391384.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','257363',4901355,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257363',4901356,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257363',4901357,'2871','435',348969.21,350462.56,1493.35,246402.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257363',4901358,'2872','435',70457.22,72070.68,1613.46,266220.90,0.00,0.00,0.00,0.00,0.00),('5','181','970','257363',4901359,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257363',4901360,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257363',4901361,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257363',4901362,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257363',4901363,'2877','436',938917.25,946058.13,7140.88,2963465.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257363',4901364,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257363',4901365,'2910','436',369790.83,370970.96,1180.13,489753.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257364',4901366,'2863','435',484976.78,484976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257364',4901367,'2864','435',348509.54,348509.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257364',4901368,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257364',4901369,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257364',4901370,'2867','435',105007.29,105007.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257364',4901371,'2868','435',115545.04,118691.56,3146.52,519175.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','257364',4901372,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257364',4901373,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257364',4901374,'2871','435',350462.56,353147.01,2684.45,442934.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','257364',4901375,'2872','435',72070.68,76912.90,4842.22,798966.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257364',4901376,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257364',4901377,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257364',4901378,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257364',4901379,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257364',4901380,'2877','436',946058.13,953767.42,7709.29,3199355.35,0.00,0.00,0.00,0.00,0.00),('5','181','974','257364',4901381,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257364',4901382,'2910','436',370970.96,374378.01,3407.05,1413925.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257365',4901383,'2863','435',484976.78,484976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257365',4901384,'2864','435',348509.54,350645.67,2136.13,352461.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257365',4901385,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257365',4901386,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257365',4901387,'2867','435',105007.29,105061.87,54.58,9005.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257365',4901388,'2868','435',118691.56,122824.55,4132.99,681943.35,0.00,0.00,0.00,0.00,0.00),('5','181','969','257365',4901389,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257365',4901390,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257365',4901391,'2871','435',353147.01,354365.41,1218.40,201036.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257365',4901392,'2872','435',76912.90,78539.32,1626.42,268359.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257365',4901393,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257365',4901394,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257365',4901395,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257365',4901396,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257365',4901397,'2877','436',953767.42,960072.95,6305.53,2616794.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','257365',4901398,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257365',4901399,'2910','436',374378.01,376279.37,1901.36,789064.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257366',4901400,'2863','435',484976.78,484976.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257366',4901401,'2864','435',350645.67,350645.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257366',4901402,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257366',4901403,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257366',4901404,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257366',4901405,'2868','435',122824.55,124214.36,1389.81,229318.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','257366',4901406,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257366',4901407,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257366',4901408,'2871','435',354365.41,354365.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257366',4901409,'2872','435',78539.32,78539.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257366',4901410,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257366',4901411,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257366',4901412,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257366',4901413,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257366',4901414,'2877','436',960072.95,964642.72,4569.77,1896454.55,0.00,0.00,0.00,0.00,0.00),('5','181','974','257366',4901415,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257366',4901416,'2910','436',376279.37,376336.29,56.92,23621.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257367',4901417,'2863','435',484976.78,489055.24,4078.46,672945.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257367',4901418,'2864','435',350645.67,352002.14,1356.47,223817.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257367',4901419,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257367',4901420,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257367',4901421,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257367',4901422,'2868','435',124214.36,124214.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257367',4901423,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257367',4901424,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257367',4901425,'2871','435',354365.41,355496.34,1130.93,186603.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257367',4901426,'2872','435',78539.32,78539.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257367',4901427,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257367',4901428,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257367',4901429,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257367',4901430,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257367',4901431,'2877','436',964642.72,975641.83,10999.11,4564630.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257367',4901432,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257367',4901433,'2910','436',376336.29,377503.56,1167.27,484417.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257368',4901434,'2863','435',489055.24,491014.81,1959.57,323329.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257368',4901435,'2864','435',352002.14,352002.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257368',4901436,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257368',4901437,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257368',4901438,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257368',4901439,'2868','435',124214.36,138889.85,14675.49,2421455.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257368',4901440,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257368',4901441,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257368',4901442,'2871','435',355496.34,357325.68,1829.34,301841.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257368',4901443,'2872','435',78539.32,78539.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257368',4901444,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257368',4901445,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257368',4901446,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257368',4901447,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257368',4901448,'2877','436',975641.83,983701.61,8059.78,3344808.70,0.00,0.00,0.00,0.00,0.00),('5','181','974','257368',4901449,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257368',4901450,'2910','436',377503.56,380622.70,3119.14,1294443.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257369',4901451,'2863','435',491014.81,492312.14,1297.33,214059.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257369',4901452,'2864','435',352002.14,355661.64,3659.50,603817.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257369',4901453,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257369',4901454,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257369',4901455,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257369',4901456,'2868','435',138889.85,138889.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257369',4901457,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257369',4901458,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257369',4901459,'2871','435',357325.68,362561.07,5235.39,863839.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','257369',4901460,'2872','435',78539.32,80242.60,1703.28,281041.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','257369',4901461,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257369',4901462,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257369',4901463,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257369',4901464,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257369',4901465,'2877','436',983701.61,991071.92,7370.31,3058678.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257369',4901466,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257369',4901467,'2910','436',380622.70,382587.42,1964.72,815358.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257370',4901468,'2863','435',492312.14,493860.92,1548.78,255548.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257370',4901469,'2864','435',355661.64,356727.05,1065.41,175792.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257370',4901470,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257370',4901471,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257370',4901472,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257370',4901473,'2868','435',138889.85,140069.25,1179.40,194601.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257370',4901474,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257370',4901475,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257370',4901476,'2871','435',362561.07,366072.67,3511.60,579414.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257370',4901477,'2872','435',80242.60,80653.93,411.33,67869.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257370',4901478,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257370',4901479,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257370',4901480,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257370',4901481,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257370',4901482,'2877','436',991071.92,993458.83,2386.91,990567.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257370',4901483,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257370',4901484,'2910','436',382587.42,383168.83,581.41,241285.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257371',4901485,'2863','435',493860.92,496000.48,2139.56,353027.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257371',4901486,'2864','435',356727.05,359219.47,2492.42,411249.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257371',4901487,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257371',4901488,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257371',4901489,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257371',4901490,'2868','435',140069.25,142225.62,2156.37,355801.05,0.00,0.00,0.00,0.00,0.00),('5','181','969','257371',4901491,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257371',4901492,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257371',4901493,'2871','435',366072.67,366072.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257371',4901494,'2872','435',80653.93,80653.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257371',4901495,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257371',4901496,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257371',4901497,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257371',4901498,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257371',4901499,'2877','436',993458.83,1001319.16,7860.33,3262036.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','257371',4901500,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257371',4901501,'2910','436',383168.83,385541.60,2372.77,984699.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257372',4901502,'2863','435',496000.48,498078.24,2077.76,342830.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257372',4901503,'2864','435',359219.47,360975.92,1756.45,289814.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257372',4901504,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257372',4901505,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257372',4901506,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257372',4901507,'2868','435',142225.62,142225.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257372',4901508,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257372',4901509,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257372',4901510,'2871','435',366072.67,368459.13,2386.46,393765.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','257372',4901511,'2872','435',80653.93,83226.49,2572.56,424472.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','257372',4901512,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257372',4901513,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257372',4901514,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257372',4901515,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257372',4901516,'2877','436',1001319.16,1001319.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257372',4901517,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257372',4901518,'2910','436',385541.60,385541.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257373',4901519,'2863','435',498078.24,498078.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257373',4901520,'2864','435',360975.92,360975.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257373',4901521,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257373',4901522,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257373',4901523,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257373',4901524,'2868','435',142225.62,142225.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257373',4901525,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257373',4901526,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257373',4901527,'2871','435',368459.13,374570.01,6110.88,1008295.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257373',4901528,'2872','435',83226.49,85051.94,1825.45,301199.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257373',4901529,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257373',4901530,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257373',4901531,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257373',4901532,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257373',4901533,'2877','436',1001319.16,1001319.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257373',4901534,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257373',4901535,'2910','436',385541.60,385541.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257374',4901536,'2863','435',498078.24,501609.21,3530.97,582610.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257374',4901537,'2864','435',360975.92,362899.94,1924.02,317463.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257374',4901538,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257374',4901539,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257374',4901540,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257374',4901541,'2868','435',142225.62,142225.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257374',4901542,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257374',4901543,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257374',4901544,'2871','435',374570.01,374570.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257374',4901545,'2872','435',85051.94,85051.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257374',4901546,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257374',4901547,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257374',4901548,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257374',4901549,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257374',4901550,'2877','436',1001319.16,1001319.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257374',4901551,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257374',4901552,'2910','436',385541.60,385541.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257375',4901553,'2863','435',501609.21,502728.09,1118.88,184615.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257375',4901554,'2864','435',362899.94,362899.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257375',4901555,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257375',4901556,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257375',4901557,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257375',4901558,'2868','435',142225.62,142225.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257375',4901559,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257375',4901560,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257375',4901561,'2871','435',374570.01,376926.64,2356.63,388843.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257375',4901562,'2872','435',85051.94,87674.25,2622.31,432681.15,0.00,0.00,0.00,0.00,0.00),('5','181','970','257375',4901563,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257375',4901564,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257375',4901565,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257375',4901566,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257375',4901567,'2877','436',1001319.16,1001319.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257375',4901568,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257375',4901569,'2910','436',385541.60,385541.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257376',4901570,'2863','435',502728.09,507236.89,4508.80,743952.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257376',4901571,'2864','435',362899.94,368441.13,5541.19,914296.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257376',4901572,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257376',4901573,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257376',4901574,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257376',4901575,'2868','435',142225.62,142225.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257376',4901576,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257376',4901577,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257376',4901578,'2871','435',376926.64,382947.86,6021.22,993501.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','257376',4901579,'2872','435',87674.25,90704.16,3029.91,499935.15,0.00,0.00,0.00,0.00,0.00),('5','181','970','257376',4901580,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257376',4901581,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257376',4901582,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257376',4901583,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257376',4901584,'2877','436',1001319.16,1008232.21,6913.05,3456525.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257376',4901585,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257376',4901586,'2910','436',385541.60,388510.22,2968.62,1484310.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257377',4901587,'2863','435',507236.89,517766.04,10529.15,1737309.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257377',4901588,'2864','435',368441.13,371840.33,3399.20,560868.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257377',4901589,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257377',4901590,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257377',4901591,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257377',4901592,'2868','435',142225.62,147867.65,5642.03,930934.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','257377',4901593,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257377',4901594,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257377',4901595,'2871','435',382947.86,388313.86,5366.00,885390.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257377',4901596,'2872','435',90704.16,90704.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257377',4901597,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257377',4901598,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257377',4901599,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257377',4901600,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257377',4901601,'2877','436',1008232.21,1009751.72,1519.51,759755.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257377',4901602,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257377',4901603,'2910','436',388510.22,388682.08,171.86,85930.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257378',4901604,'2863','435',517766.04,518254.61,488.57,80614.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257378',4901605,'2864','435',371840.33,372536.78,696.45,114914.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257378',4901606,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257378',4901607,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257378',4901608,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257378',4901609,'2868','435',147867.65,149821.85,1954.20,322443.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257378',4901610,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257378',4901611,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257378',4901612,'2871','435',388313.86,389657.05,1343.19,221626.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','257378',4901613,'2872','435',90704.16,97371.07,6666.91,1100040.15,0.00,0.00,0.00,0.00,0.00),('5','181','970','257378',4901614,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257378',4901615,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257378',4901616,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257378',4901617,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257378',4901618,'2877','436',1009751.72,1009751.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257378',4901619,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257378',4901620,'2910','436',388682.08,388682.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257379',4901621,'2863','435',518254.61,518254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257379',4901622,'2864','435',372536.78,372536.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257379',4901623,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257379',4901624,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257379',4901625,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257379',4901626,'2868','435',149821.85,155989.63,6167.78,1017683.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257379',4901627,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257379',4901628,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257379',4901629,'2871','435',389657.05,389657.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257379',4901630,'2872','435',97371.07,97371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257379',4901631,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257379',4901632,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257379',4901633,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257379',4901634,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257379',4901635,'2877','436',1009751.72,1009751.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257379',4901636,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257379',4901637,'2910','436',388682.08,388682.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257380',4901638,'2863','435',518254.61,518254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257380',4901639,'2864','435',372536.78,372536.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257380',4901640,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257380',4901641,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257380',4901642,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257380',4901643,'2868','435',155989.63,161815.12,5825.49,961205.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257380',4901644,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257380',4901645,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257380',4901646,'2871','435',389657.05,389657.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257380',4901647,'2872','435',97371.07,97371.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257380',4901648,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257380',4901649,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257380',4901650,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257380',4901651,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257380',4901652,'2877','436',1009751.72,1009751.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257380',4901653,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257380',4901654,'2910','436',388682.08,388682.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257381',4901655,'2863','435',518254.61,518254.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257381',4901656,'2864','435',372536.78,372536.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257381',4901657,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257381',4901658,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257381',4901659,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257381',4901660,'2868','435',161815.12,167665.68,5850.56,965342.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','257381',4901661,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257381',4901662,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257381',4901663,'2871','435',389657.05,391527.24,1870.19,308581.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','257381',4901664,'2872','435',97371.07,98543.79,1172.72,193498.80,0.00,0.00,0.00,0.00,0.00),('5','181','970','257381',4901665,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257381',4901666,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257381',4901667,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257381',4901668,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257381',4901669,'2877','436',1009751.72,1009751.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257381',4901670,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257381',4901671,'2910','436',388682.08,388682.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257382',4901672,'2863','435',518254.61,520352.69,2098.08,346183.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257382',4901673,'2864','435',372536.78,372536.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257382',4901674,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257382',4901675,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257382',4901676,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257382',4901677,'2868','435',167665.68,167665.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257382',4901678,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257382',4901679,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257382',4901680,'2871','435',391527.24,393273.90,1746.66,288198.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','257382',4901681,'2872','435',98543.79,103136.56,4592.77,757807.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','257382',4901682,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257382',4901683,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257382',4901684,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257382',4901685,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257382',4901686,'2877','436',1009751.72,1011266.29,1514.57,969324.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257382',4901687,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257382',4901688,'2910','436',388682.08,388682.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257383',4901689,'2863','435',520352.69,523638.81,3286.12,542209.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257383',4901690,'2864','435',372536.78,374987.55,2450.77,404377.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257383',4901691,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257383',4901692,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257383',4901693,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257383',4901694,'2868','435',167665.68,169568.81,1903.13,314016.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','257383',4901695,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257383',4901696,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257383',4901697,'2871','435',393273.90,393273.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257383',4901698,'2872','435',103136.56,107069.80,3933.24,648984.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257383',4901699,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257383',4901700,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257383',4901701,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257383',4901702,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257383',4901703,'2877','436',1011266.29,1013633.98,2367.69,1515321.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257383',4901704,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257383',4901705,'2910','436',388682.08,388986.82,304.74,195033.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257384',4901706,'2863','435',523638.81,529512.28,5873.47,969122.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257384',4901707,'2864','435',374987.55,377556.35,2568.80,423852.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257384',4901708,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257384',4901709,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257384',4901710,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257384',4901711,'2868','435',169568.81,172018.81,2450.00,404250.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257384',4901712,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257384',4901713,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257384',4901714,'2871','435',393273.90,393273.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257384',4901715,'2872','435',107069.80,107069.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257384',4901716,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257384',4901717,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257384',4901718,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257384',4901719,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257384',4901720,'2877','436',1013633.98,1015135.63,1501.65,961056.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257384',4901721,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257384',4901722,'2910','436',388986.82,390541.90,1555.08,995251.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257385',4901723,'2863','435',529512.28,531933.80,2421.52,399550.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257385',4901724,'2864','435',377556.35,377556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257385',4901725,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257385',4901726,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257385',4901727,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257385',4901728,'2868','435',172018.81,178564.75,6545.94,1080080.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257385',4901729,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257385',4901730,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257385',4901731,'2871','435',393273.90,394606.74,1332.84,219918.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','257385',4901732,'2872','435',107069.80,108436.38,1366.58,225485.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','257385',4901733,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257385',4901734,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257385',4901735,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257385',4901736,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257385',4901737,'2877','436',1015135.63,1017296.23,2160.60,1382784.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257385',4901738,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257385',4901739,'2910','436',390541.90,390961.75,419.85,268704.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257386',4901740,'2863','435',531933.80,538123.10,6189.30,1021234.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257386',4901741,'2864','435',377556.35,378792.62,1236.27,203984.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257386',4901742,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257386',4901743,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257386',4901744,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257386',4901745,'2868','435',178564.75,180897.29,2332.54,384869.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257386',4901746,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257386',4901747,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257386',4901748,'2871','435',394606.74,395776.62,1169.88,193030.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257386',4901749,'2872','435',108436.38,115527.60,7091.22,1170051.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257386',4901750,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257386',4901751,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257386',4901752,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257386',4901753,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257386',4901754,'2877','436',1017296.23,1020611.18,3314.95,2121568.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257386',4901755,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257386',4901756,'2910','436',390961.75,392321.65,1359.90,870336.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257387',4901757,'2863','435',538123.10,543461.46,5338.36,880829.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257387',4901758,'2864','435',378792.62,380615.16,1822.54,300719.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257387',4901759,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257387',4901760,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257387',4901761,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257387',4901762,'2868','435',180897.29,185540.19,4642.90,766078.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257387',4901763,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257387',4901764,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257387',4901765,'2871','435',395776.62,396847.01,1070.39,176614.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','257387',4901766,'2872','435',115527.60,117011.65,1484.05,244868.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257387',4901767,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257387',4901768,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257387',4901769,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257387',4901770,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257387',4901771,'2877','436',1020611.18,1023306.28,2695.10,1724864.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257387',4901772,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257387',4901773,'2910','436',392321.65,392375.66,54.01,34566.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257388',4901774,'2863','435',543461.46,548289.16,4827.70,796570.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257388',4901775,'2864','435',380615.16,380615.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257388',4901776,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257388',4901777,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257388',4901778,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257388',4901779,'2868','435',185540.19,186750.28,1210.09,199664.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257388',4901780,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257388',4901781,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257388',4901782,'2871','435',396847.01,399849.97,3002.96,495488.40,0.00,0.00,0.00,0.00,0.00),('5','181','971','257388',4901783,'2872','435',117011.65,118684.24,1672.59,275977.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','257388',4901784,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257388',4901785,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257388',4901786,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257388',4901787,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257388',4901788,'2877','436',1023306.28,1030546.44,7240.16,4633702.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257388',4901789,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257388',4901790,'2910','436',392375.66,396092.50,3716.84,2378777.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257389',4901791,'2863','435',548289.16,552965.04,4675.88,771520.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257389',4901792,'2864','435',380615.16,381129.22,514.06,84819.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257389',4901793,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257389',4901794,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257389',4901795,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257389',4901796,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257389',4901797,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257389',4901798,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257389',4901799,'2871','435',399849.97,401716.43,1866.46,307965.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','257389',4901800,'2872','435',118684.24,119530.29,846.05,139598.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257389',4901801,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257389',4901802,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257389',4901803,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257389',4901804,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257389',4901805,'2877','436',1030546.44,1036030.56,5484.12,3509836.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257389',4901806,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257389',4901807,'2910','436',396092.50,398401.41,2308.91,1477702.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257390',4901808,'2863','435',552965.04,557499.14,4534.10,748126.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257390',4901809,'2864','435',381129.22,382429.85,1300.63,214603.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257390',4901810,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257390',4901811,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257390',4901812,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257390',4901813,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257390',4901814,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257390',4901815,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257390',4901816,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257390',4901817,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257390',4901818,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257390',4901819,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257390',4901820,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257390',4901821,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257390',4901822,'2877','436',1036030.56,1041539.03,5508.47,3525420.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257390',4901823,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257390',4901824,'2910','436',398401.41,400342.33,1940.92,1242188.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257391',4901825,'2863','435',557499.14,561890.83,4391.69,724628.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257391',4901826,'2864','435',382429.85,385928.08,3498.23,577207.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257391',4901827,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257391',4901828,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257391',4901829,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257391',4901830,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257391',4901831,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257391',4901832,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257391',4901833,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257391',4901834,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257391',4901835,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257391',4901836,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257391',4901837,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257391',4901838,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257391',4901839,'2877','436',1041539.03,1047606.76,6067.73,3883347.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257391',4901840,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257391',4901841,'2910','436',400342.33,403666.73,3324.40,2127616.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257392',4901842,'2863','435',561890.83,568045.05,6154.22,1015446.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257392',4901843,'2864','435',385928.08,388126.48,2198.40,362736.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257392',4901844,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257392',4901845,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257392',4901846,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257392',4901847,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257392',4901848,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257392',4901849,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257392',4901850,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257392',4901851,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257392',4901852,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257392',4901853,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257392',4901854,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257392',4901855,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257392',4901856,'2877','436',1047606.76,1053070.76,5464.00,3496960.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257392',4901857,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257392',4901858,'2910','436',403666.73,407281.71,3614.98,2313587.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257393',4901859,'2863','435',568045.05,570696.76,2651.71,437532.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257393',4901860,'2864','435',388126.48,390674.16,2547.68,420367.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257393',4901861,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257393',4901862,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257393',4901863,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257393',4901864,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257393',4901865,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257393',4901866,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257393',4901867,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257393',4901868,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257393',4901869,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257393',4901870,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257393',4901871,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257393',4901872,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257393',4901873,'2877','436',1053070.76,1054932.79,1862.03,1191699.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257393',4901874,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257393',4901875,'2910','436',407281.71,408237.96,956.25,612000.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257394',4901876,'2863','435',570696.76,573165.22,2468.46,407295.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257394',4901877,'2864','435',390674.16,397676.41,7002.25,1155371.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257394',4901878,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257394',4901879,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257394',4901880,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257394',4901881,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257394',4901882,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257394',4901883,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257394',4901884,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257394',4901885,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257394',4901886,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257394',4901887,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257394',4901888,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257394',4901889,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257394',4901890,'2877','436',1054932.79,1062392.38,7459.59,4774137.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257394',4901891,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257394',4901892,'2910','436',408237.96,412740.45,4502.49,2881593.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257395',4901893,'2863','435',573165.22,575126.62,1961.40,323631.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257395',4901894,'2864','435',397676.41,403023.43,5347.02,882258.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257395',4901895,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257395',4901896,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257395',4901897,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257395',4901898,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257395',4901899,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257395',4901900,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257395',4901901,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257395',4901902,'2872','435',119530.29,119530.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257395',4901903,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257395',4901904,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257395',4901905,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257395',4901906,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257395',4901907,'2877','436',1062392.38,1069758.56,7366.18,4714355.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257395',4901908,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257395',4901909,'2910','436',412740.45,416152.37,3411.92,2183628.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257396',4901910,'2863','435',575126.62,579346.23,4219.61,696235.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257396',4901911,'2864','435',403023.43,405849.97,2826.54,466379.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257396',4901912,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257396',4901913,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257396',4901914,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257396',4901915,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257396',4901916,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257396',4901917,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257396',4901918,'2871','435',401716.43,401716.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257396',4901919,'2872','435',119530.29,121163.33,1633.04,269451.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257396',4901920,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257396',4901921,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257396',4901922,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257396',4901923,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257396',4901924,'2877','436',1069758.56,1074772.16,5013.60,3208704.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257396',4901925,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257396',4901926,'2910','436',416152.37,417330.99,1178.62,754316.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257397',4901927,'2863','435',579346.23,579346.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257397',4901928,'2864','435',405849.97,407257.55,1407.58,232250.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257397',4901929,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257397',4901930,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257397',4901931,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257397',4901932,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257397',4901933,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257397',4901934,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257397',4901935,'2871','435',401716.43,403387.34,1670.91,275700.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','257397',4901936,'2872','435',121163.33,124924.94,3761.61,620665.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257397',4901937,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257397',4901938,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257397',4901939,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257397',4901940,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257397',4901941,'2877','436',1074772.16,1080813.88,6041.72,3866700.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257397',4901942,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257397',4901943,'2910','436',417330.99,422935.99,5605.00,3587200.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257398',4901944,'2863','435',579346.23,579346.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257398',4901945,'2864','435',407257.55,407257.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257398',4901946,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257398',4901947,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257398',4901948,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257398',4901949,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257398',4901950,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257398',4901951,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257398',4901952,'2871','435',403387.34,408685.26,5297.92,874156.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','257398',4901953,'2872','435',124924.94,128878.09,3953.15,652269.75,0.00,0.00,0.00,0.00,0.00),('5','181','970','257398',4901954,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257398',4901955,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257398',4901956,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257398',4901957,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257398',4901958,'2877','436',1080813.88,1087535.28,6721.40,4301696.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257398',4901959,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257398',4901960,'2910','436',422935.99,425692.97,2756.98,1764467.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257399',4901961,'2863','435',579346.23,579346.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257399',4901962,'2864','435',407257.55,407257.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257399',4901963,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257399',4901964,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257399',4901965,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257399',4901966,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257399',4901967,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257399',4901968,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257399',4901969,'2871','435',408685.26,412966.75,4281.49,706445.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','257399',4901970,'2872','435',128878.09,131988.30,3110.21,513184.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257399',4901971,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257399',4901972,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257399',4901973,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257399',4901974,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257399',4901975,'2877','436',1087535.28,1092921.40,5386.12,3447116.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257399',4901976,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257399',4901977,'2910','436',425692.97,430968.76,5275.79,3376505.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257400',4901978,'2863','435',579346.23,579346.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257400',4901979,'2864','435',407257.55,407257.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257400',4901980,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257400',4901981,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257400',4901982,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257400',4901983,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257400',4901984,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257400',4901985,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257400',4901986,'2871','435',412966.75,414877.69,1910.94,315305.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257400',4901987,'2872','435',131988.30,136095.60,4107.30,677704.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257400',4901988,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257400',4901989,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257400',4901990,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257400',4901991,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257400',4901992,'2877','436',1092921.40,1098032.15,5110.75,3270880.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257400',4901993,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257400',4901994,'2910','436',430968.76,435324.62,4355.86,2787750.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257401',4901995,'2863','435',579346.23,582731.24,3385.01,558526.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257401',4901996,'2864','435',407257.55,410153.44,2895.89,477821.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257401',4901997,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257401',4901998,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257401',4901999,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257401',4902000,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257401',4902001,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257401',4902002,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257401',4902003,'2871','435',414877.69,414877.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257401',4902004,'2872','435',136095.60,136095.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257401',4902005,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257401',4902006,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257401',4902007,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257401',4902008,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257401',4902009,'2877','436',1098032.15,1103293.69,5261.54,3367385.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257401',4902010,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257401',4902011,'2910','436',435324.62,440102.37,4777.75,3057760.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257402',4902012,'2863','435',582731.24,588059.44,5328.20,879153.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257402',4902013,'2864','435',410153.44,413027.33,2873.89,474191.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257402',4902014,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257402',4902015,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257402',4902016,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257402',4902017,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257402',4902018,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257402',4902019,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257402',4902020,'2871','435',414877.69,414877.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257402',4902021,'2872','435',136095.60,136095.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257402',4902022,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257402',4902023,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257402',4902024,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257402',4902025,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257402',4902026,'2877','436',1103293.69,1103293.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257402',4902027,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257402',4902028,'2910','436',440102.37,451563.07,11460.70,7334848.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257403',4902029,'2863','435',588059.44,588059.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257403',4902030,'2864','435',413027.33,416839.10,3811.77,628942.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257403',4902031,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257403',4902032,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257403',4902033,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257403',4902034,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257403',4902035,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257403',4902036,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257403',4902037,'2871','435',414877.69,416596.24,1718.55,283560.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257403',4902038,'2872','435',136095.60,137831.85,1736.25,286481.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257403',4902039,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257403',4902040,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257403',4902041,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257403',4902042,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257403',4902043,'2877','436',1103293.69,1103303.59,9.90,6336.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257403',4902044,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257403',4902045,'2910','436',451563.07,461532.93,9969.86,6380710.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257404',4902046,'2863','435',588059.44,588059.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257404',4902047,'2864','435',416839.10,416839.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257404',4902048,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257404',4902049,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257404',4902050,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257404',4902051,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257404',4902052,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257404',4902053,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257404',4902054,'2871','435',416596.24,417284.39,688.15,113544.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257404',4902055,'2872','435',137831.85,143520.60,5688.75,938643.75,0.00,0.00,0.00,0.00,0.00),('5','181','970','257404',4902056,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257404',4902057,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257404',4902058,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257404',4902059,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257404',4902060,'2877','436',1103303.59,1103357.02,53.43,34195.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257404',4902061,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257404',4902062,'2910','436',461532.93,467642.88,6109.95,3910368.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257405',4902063,'2863','435',588059.44,588846.97,787.53,129942.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257405',4902064,'2864','435',416839.10,416839.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257405',4902065,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257405',4902066,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257405',4902067,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257405',4902068,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257405',4902069,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257405',4902070,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257405',4902071,'2871','435',417284.39,418816.44,1532.05,252788.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','257405',4902072,'2872','435',143520.60,147247.77,3727.17,614983.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','257405',4902073,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257405',4902074,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257405',4902075,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257405',4902076,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257405',4902077,'2877','436',1103357.02,1107364.14,4007.12,2644699.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257405',4902078,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257405',4902079,'2910','436',467642.88,475946.35,8303.47,5480290.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257406',4902080,'2863','435',588846.97,590072.25,1225.28,202171.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257406',4902081,'2864','435',416839.10,417326.83,487.73,80475.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257406',4902082,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257406',4902083,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257406',4902084,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257406',4902085,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257406',4902086,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257406',4902087,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257406',4902088,'2871','435',418816.44,421698.23,2881.79,475495.35,0.00,0.00,0.00,0.00,0.00),('5','181','971','257406',4902089,'2872','435',147247.77,148799.44,1551.67,256025.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','257406',4902090,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257406',4902091,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257406',4902092,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257406',4902093,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257406',4902094,'2877','436',1107364.14,1114573.55,7209.41,4758210.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257406',4902095,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257406',4902096,'2910','436',475946.35,480137.36,4191.01,2766066.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257407',4902097,'2863','435',590072.25,590351.02,278.77,45997.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257407',4902098,'2864','435',417326.83,417326.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257407',4902099,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257407',4902100,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257407',4902101,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257407',4902102,'2868','435',186750.28,186750.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257407',4902103,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257407',4902104,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257407',4902105,'2871','435',421698.23,423272.27,1574.04,259716.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','257407',4902106,'2872','435',148799.44,152340.64,3541.20,584298.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257407',4902107,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257407',4902108,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257407',4902109,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257407',4902110,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257407',4902111,'2877','436',1114573.55,1122073.02,7499.47,4799660.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257407',4902112,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257407',4902113,'2910','436',480137.36,484041.31,3903.95,2498528.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257408',4902114,'2863','435',590351.02,592487.31,2136.29,352487.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257408',4902115,'2864','435',417326.83,417326.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257408',4902116,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257408',4902117,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257408',4902118,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257408',4902119,'2868','435',186750.28,190778.53,4028.25,664661.25,0.00,0.00,0.00,0.00,0.00),('5','181','969','257408',4902120,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257408',4902121,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257408',4902122,'2871','435',423272.27,423272.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257408',4902123,'2872','435',152340.64,152340.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257408',4902124,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257408',4902125,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257408',4902126,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257408',4902127,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257408',4902128,'2877','436',1122073.02,1129056.89,6983.87,4469676.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257408',4902129,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257408',4902130,'2910','436',484041.31,486589.33,2548.02,1630732.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257409',4902131,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257409',4902132,'2864','435',417326.83,419142.51,1815.68,299587.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257409',4902133,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257409',4902134,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257409',4902135,'2867','435',105061.87,105061.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257409',4902136,'2868','435',190778.53,194751.19,3972.66,655488.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','257409',4902137,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257409',4902138,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257409',4902139,'2871','435',423272.27,423272.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257409',4902140,'2872','435',152340.64,152340.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257409',4902141,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257409',4902142,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257409',4902143,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257409',4902144,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257409',4902145,'2877','436',1129056.89,1135757.86,6700.97,4288620.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257409',4902146,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257409',4902147,'2910','436',486589.33,488478.97,1889.64,1209369.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257410',4902148,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257410',4902149,'2864','435',419142.51,421649.10,2506.59,413587.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257410',4902150,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257410',4902151,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257410',4902152,'2867','435',105061.87,107064.08,2002.21,330364.65,0.00,0.00,0.00,0.00,0.00),('5','181','968','257410',4902153,'2868','435',194751.19,200101.47,5350.28,882796.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257410',4902154,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257410',4902155,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257410',4902156,'2871','435',423272.27,423407.29,135.02,22278.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','257410',4902157,'2872','435',152340.64,152340.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257410',4902158,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257410',4902159,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257410',4902160,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257410',4902161,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257410',4902162,'2877','436',1135757.86,1140326.09,4568.23,2923667.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257410',4902163,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257410',4902164,'2910','436',488478.97,490722.10,2243.13,1435603.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257411',4902165,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257411',4902166,'2864','435',421649.10,425942.83,4293.73,708465.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257411',4902167,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257411',4902168,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257411',4902169,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257411',4902170,'2868','435',200101.47,204211.97,4110.50,678232.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257411',4902171,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257411',4902172,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257411',4902173,'2871','435',423407.29,423407.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257411',4902174,'2872','435',152340.64,154527.86,2187.22,360891.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257411',4902175,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257411',4902176,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257411',4902177,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257411',4902178,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257411',4902179,'2877','436',1140326.09,1148814.44,8488.35,5432544.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257411',4902180,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257411',4902181,'2910','436',490722.10,493050.47,2328.37,1490156.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257412',4902182,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257412',4902183,'2864','435',425942.83,425942.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257412',4902184,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257412',4902185,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257412',4902186,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257412',4902187,'2868','435',204211.97,210207.55,5995.58,989270.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257412',4902188,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257412',4902189,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257412',4902190,'2871','435',423407.29,426647.22,3239.93,534588.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257412',4902191,'2872','435',154527.86,158657.89,4130.03,681454.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','257412',4902192,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257412',4902193,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257412',4902194,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257412',4902195,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257412',4902196,'2877','436',1148814.44,1153697.54,4883.10,3222846.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257412',4902197,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257412',4902198,'2910','436',493050.47,495530.46,2479.99,1636793.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257413',4902199,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257413',4902200,'2864','435',425942.83,425942.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257413',4902201,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257413',4902202,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257413',4902203,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257413',4902204,'2868','435',210207.55,215864.11,5656.56,933332.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','257413',4902205,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257413',4902206,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257413',4902207,'2871','435',426647.22,433113.03,6465.81,1066858.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','257413',4902208,'2872','435',158657.89,158657.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257413',4902209,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257413',4902210,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257413',4902211,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257413',4902212,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257413',4902213,'2877','436',1153697.54,1162703.28,9005.74,5943788.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257413',4902214,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257413',4902215,'2910','436',495530.46,500622.93,5092.47,3361030.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257414',4902216,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257414',4902217,'2864','435',425942.83,425942.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257414',4902218,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257414',4902219,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257414',4902220,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257414',4902221,'2868','435',215864.11,223755.42,7891.31,1302066.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257414',4902222,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257414',4902223,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257414',4902224,'2871','435',433113.03,433113.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257414',4902225,'2872','435',158657.89,165177.44,6519.55,1075725.75,0.00,0.00,0.00,0.00,0.00),('5','181','970','257414',4902226,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257414',4902227,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257414',4902228,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257414',4902229,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257414',4902230,'2877','436',1162703.28,1171090.50,8387.22,5535565.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257414',4902231,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257414',4902232,'2910','436',500622.93,505339.80,4716.87,3113134.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257415',4902233,'2863','435',592487.31,592487.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257415',4902234,'2864','435',425942.83,427401.80,1458.97,240730.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257415',4902235,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257415',4902236,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257415',4902237,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257415',4902238,'2868','435',223755.42,229206.49,5451.07,899426.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257415',4902239,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257415',4902240,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257415',4902241,'2871','435',433113.03,433113.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257415',4902242,'2872','435',165177.44,170254.93,5077.49,837785.85,0.00,0.00,0.00,0.00,0.00),('5','181','970','257415',4902243,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257415',4902244,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257415',4902245,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257415',4902246,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257415',4902247,'2877','436',1171090.50,1171691.72,601.22,396805.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257415',4902248,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257415',4902249,'2910','436',505339.80,506115.18,775.38,511750.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257416',4902250,'2863','435',592487.31,599956.58,7469.27,1232429.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257416',4902251,'2864','435',427401.80,427401.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257416',4902252,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257416',4902253,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257416',4902254,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257416',4902255,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257416',4902256,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257416',4902257,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257416',4902258,'2871','435',433113.03,433113.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257416',4902259,'2872','435',170254.93,177620.73,7365.80,1215357.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257416',4902260,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257416',4902261,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257416',4902262,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257416',4902263,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257416',4902264,'2877','436',1171691.72,1178785.06,7093.34,4681604.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257416',4902265,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257416',4902266,'2910','436',506115.18,509528.83,3413.65,2253009.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257417',4902267,'2863','435',599956.58,600895.71,939.13,154956.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257417',4902268,'2864','435',427401.80,428299.53,897.73,148125.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257417',4902269,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257417',4902270,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257417',4902271,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257417',4902272,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257417',4902273,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257417',4902274,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257417',4902275,'2871','435',433113.03,433835.38,722.35,119187.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257417',4902276,'2872','435',177620.73,178812.54,1191.81,196648.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257417',4902277,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257417',4902278,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257417',4902279,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257417',4902280,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257417',4902281,'2877','436',1178785.06,1187024.74,8239.68,5438188.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257417',4902282,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257417',4902283,'2910','436',509528.83,515206.28,5677.45,3747117.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257418',4902284,'2863','435',600895.71,601738.81,843.10,139111.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257418',4902285,'2864','435',428299.53,429546.70,1247.17,205783.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257418',4902286,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257418',4902287,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257418',4902288,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257418',4902289,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257418',4902290,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257418',4902291,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257418',4902292,'2871','435',433835.38,433835.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257418',4902293,'2872','435',178812.54,178812.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257418',4902294,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257418',4902295,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257418',4902296,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257418',4902297,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257418',4902298,'2877','436',1187024.74,1193248.97,6224.23,4107991.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257418',4902299,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257418',4902300,'2910','436',515206.28,515206.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257419',4902301,'2863','435',601738.81,604952.23,3213.42,530214.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257419',4902302,'2864','435',429546.70,430485.49,938.79,154900.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257419',4902303,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257419',4902304,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257419',4902305,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257419',4902306,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257419',4902307,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257419',4902308,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257419',4902309,'2871','435',433835.38,433835.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257419',4902310,'2872','435',178812.54,178812.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257419',4902311,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257419',4902312,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257419',4902313,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257419',4902314,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257419',4902315,'2877','436',1193248.97,1199023.69,5774.72,3811315.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257419',4902316,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257419',4902317,'2910','436',515206.28,516970.35,1764.07,1164286.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257420',4902318,'2863','435',604952.23,607186.27,2234.04,368616.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257420',4902319,'2864','435',430485.49,431899.90,1414.41,233377.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257420',4902320,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257420',4902321,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257420',4902322,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257420',4902323,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257420',4902324,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257420',4902325,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257420',4902326,'2871','435',433835.38,434928.25,1092.87,180323.55,0.00,0.00,0.00,0.00,0.00),('5','181','971','257420',4902327,'2872','435',178812.54,178812.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257420',4902328,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257420',4902329,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257420',4902330,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257420',4902331,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257420',4902332,'2877','436',1199023.69,1203799.50,4775.81,3152034.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257420',4902333,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257420',4902334,'2910','436',516970.35,518433.67,1463.32,965791.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257421',4902335,'2863','435',607186.27,608219.62,1033.35,170502.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257421',4902336,'2864','435',431899.90,432655.92,756.02,124743.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257421',4902337,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257421',4902338,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257421',4902339,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257421',4902340,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257421',4902341,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257421',4902342,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257421',4902343,'2871','435',434928.25,436498.80,1570.55,259140.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257421',4902344,'2872','435',178812.54,180344.90,1532.36,252839.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','257421',4902345,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257421',4902346,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257421',4902347,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257421',4902348,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257421',4902349,'2877','436',1203799.50,1211046.54,7247.04,4783046.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257421',4902350,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257421',4902351,'2910','436',518433.67,523848.20,5414.53,3573589.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257422',4902352,'2863','435',608219.62,612044.93,3825.31,631176.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257422',4902353,'2864','435',432655.92,434987.19,2331.27,384659.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257422',4902354,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257422',4902355,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257422',4902356,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257422',4902357,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257422',4902358,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257422',4902359,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257422',4902360,'2871','435',436498.80,436498.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257422',4902361,'2872','435',180344.90,180344.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257422',4902362,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257422',4902363,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257422',4902364,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257422',4902365,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257422',4902366,'2877','436',1211046.54,1216310.80,5264.26,3474411.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257422',4902367,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257422',4902368,'2910','436',523848.20,526429.10,2580.90,1703394.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257423',4902369,'2863','435',612044.93,614816.73,2771.80,457347.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257423',4902370,'2864','435',434987.19,437207.97,2220.78,366428.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257423',4902371,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257423',4902372,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257423',4902373,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257423',4902374,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257423',4902375,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257423',4902376,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257423',4902377,'2871','435',436498.80,436498.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257423',4902378,'2872','435',180344.90,182076.63,1731.73,285735.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257423',4902379,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257423',4902380,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257423',4902381,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257423',4902382,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257423',4902383,'2877','436',1216310.80,1221503.35,5192.55,3427083.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257423',4902384,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257423',4902385,'2910','436',526429.10,529953.57,3524.47,2326150.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257424',4902386,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257424',4902387,'2864','435',437207.97,437207.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257424',4902388,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257424',4902389,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257424',4902390,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257424',4902391,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257424',4902392,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257424',4902393,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257424',4902394,'2871','435',436498.80,438360.98,1862.18,307259.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','257424',4902395,'2872','435',182076.63,184876.12,2799.49,461915.85,0.00,0.00,0.00,0.00,0.00),('5','181','970','257424',4902396,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257424',4902397,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257424',4902398,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257424',4902399,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257424',4902400,'2877','436',1221503.35,1229946.90,8443.55,5572743.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257424',4902401,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257424',4902402,'2910','436',529953.57,533008.01,3054.44,2015930.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257425',4902403,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257425',4902404,'2864','435',437207.97,437207.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257425',4902405,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257425',4902406,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257425',4902407,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257425',4902408,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257425',4902409,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257425',4902410,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257425',4902411,'2871','435',438360.98,440756.29,2395.31,395226.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','257425',4902412,'2872','435',184876.12,186482.95,1606.83,265126.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','257425',4902413,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257425',4902414,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257425',4902415,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257425',4902416,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257425',4902417,'2877','436',1229946.90,1236886.17,6939.27,4579918.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257425',4902418,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257425',4902419,'2910','436',533008.01,534866.35,1858.34,1226504.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257426',4902420,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257426',4902421,'2864','435',437207.97,438009.55,801.58,132260.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257426',4902422,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257426',4902423,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257426',4902424,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257426',4902425,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257426',4902426,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257426',4902427,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257426',4902428,'2871','435',440756.29,442189.32,1433.03,236449.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257426',4902429,'2872','435',186482.95,189237.50,2754.55,454500.75,0.00,0.00,0.00,0.00,0.00),('5','181','970','257426',4902430,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257426',4902431,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257426',4902432,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257426',4902433,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257426',4902434,'2877','436',1236886.17,1242185.39,5299.22,3497485.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257426',4902435,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257426',4902436,'2910','436',534866.35,536296.92,1430.57,944176.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257427',4902437,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257427',4902438,'2864','435',438009.55,439073.83,1064.28,175606.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257427',4902439,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257427',4902440,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257427',4902441,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257427',4902442,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257427',4902443,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257427',4902444,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257427',4902445,'2871','435',442189.32,443381.41,1192.09,196694.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','257427',4902446,'2872','435',189237.50,192334.54,3097.04,511011.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257427',4902447,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257427',4902448,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257427',4902449,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257427',4902450,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257427',4902451,'2877','436',1242185.39,1247010.02,4824.63,3184255.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257427',4902452,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257427',4902453,'2910','436',536296.92,542021.25,5724.33,3778057.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257428',4902454,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257428',4902455,'2864','435',439073.83,440796.97,1723.14,284318.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257428',4902456,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257428',4902457,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257428',4902458,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257428',4902459,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257428',4902460,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257428',4902461,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257428',4902462,'2871','435',443381.41,443381.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257428',4902463,'2872','435',192334.54,195251.90,2917.36,481364.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','257428',4902464,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257428',4902465,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257428',4902466,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257428',4902467,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257428',4902468,'2877','436',1247010.02,1251851.94,4841.92,3195667.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257428',4902469,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257428',4902470,'2910','436',542021.25,543870.22,1848.97,1220320.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257429',4902471,'2863','435',614816.73,614816.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257429',4902472,'2864','435',440796.97,442319.58,1522.61,251230.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257429',4902473,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257429',4902474,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257429',4902475,'2867','435',107064.08,107064.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257429',4902476,'2868','435',229206.49,229206.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257429',4902477,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257429',4902478,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257429',4902479,'2871','435',443381.41,443381.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257429',4902480,'2872','435',195251.90,198201.84,2949.94,486740.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','257429',4902481,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257429',4902482,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257429',4902483,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257429',4902484,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257429',4902485,'2877','436',1251851.94,1256829.15,4977.21,3284958.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257429',4902486,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257429',4902487,'2910','436',543870.22,547195.11,3324.89,2194427.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257430',4902488,'2863','435',614816.73,615466.38,649.65,107192.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257430',4902489,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257430',4902490,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257430',4902491,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257430',4902492,'2867','435',107064.08,109667.33,2603.25,429536.25,0.00,0.00,0.00,0.00,0.00),('5','181','968','257430',4902493,'2868','435',229206.49,233294.07,4087.58,674450.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257430',4902494,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257430',4902495,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257430',4902496,'2871','435',443381.41,443438.98,57.57,9499.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257430',4902497,'2872','435',198201.84,198950.45,748.61,123520.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257430',4902498,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257430',4902499,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257430',4902500,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257430',4902501,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257430',4902502,'2877','436',1256829.15,1260534.65,3705.50,2445630.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257430',4902503,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257430',4902504,'2910','436',547195.11,551695.31,4500.20,2970132.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257431',4902505,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257431',4902506,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257431',4902507,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257431',4902508,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257431',4902509,'2867','435',109667.33,112497.97,2830.64,467055.60,0.00,0.00,0.00,0.00,0.00),('5','181','968','257431',4902510,'2868','435',233294.07,235379.90,2085.83,344161.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','257431',4902511,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257431',4902512,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257431',4902513,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257431',4902514,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257431',4902515,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257431',4902516,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257431',4902517,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257431',4902518,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257431',4902519,'2877','436',1260534.65,1265809.45,5274.80,3481368.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257431',4902520,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257431',4902521,'2910','436',551695.31,553247.37,1552.06,1024359.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257432',4902522,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257432',4902523,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257432',4902524,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257432',4902525,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257432',4902526,'2867','435',112497.97,113462.20,964.23,159097.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','257432',4902527,'2868','435',235379.90,236776.12,1396.22,230376.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','257432',4902528,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257432',4902529,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257432',4902530,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257432',4902531,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257432',4902532,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257432',4902533,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257432',4902534,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257432',4902535,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257432',4902536,'2877','436',1265809.45,1268859.42,3049.97,2012980.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257432',4902537,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257432',4902538,'2910','436',553247.37,553562.51,315.14,207992.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257433',4902539,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257433',4902540,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257433',4902541,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257433',4902542,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257433',4902543,'2867','435',113462.20,114248.56,786.36,129749.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','257433',4902544,'2868','435',236776.12,237601.06,824.94,136115.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257433',4902545,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257433',4902546,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257433',4902547,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257433',4902548,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257433',4902549,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257433',4902550,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257433',4902551,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257433',4902552,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257433',4902553,'2877','436',1268859.42,1269735.83,876.41,578430.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257433',4902554,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257433',4902555,'2910','436',553562.51,554517.79,955.28,630484.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257434',4902556,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257434',4902557,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257434',4902558,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257434',4902559,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257434',4902560,'2867','435',114248.56,114248.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257434',4902561,'2868','435',237601.06,240953.31,3352.25,553121.25,0.00,0.00,0.00,0.00,0.00),('5','181','969','257434',4902562,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257434',4902563,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257434',4902564,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257434',4902565,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257434',4902566,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257434',4902567,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257434',4902568,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257434',4902569,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257434',4902570,'2877','436',1269735.83,1273281.00,3545.17,2339812.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257434',4902571,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257434',4902572,'2910','436',554517.79,555042.02,524.23,345991.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257435',4902573,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257435',4902574,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257435',4902575,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257435',4902576,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257435',4902577,'2867','435',114248.56,114468.30,219.74,36257.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257435',4902578,'2868','435',240953.31,242992.79,2039.48,336514.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257435',4902579,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257435',4902580,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257435',4902581,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257435',4902582,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257435',4902583,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257435',4902584,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257435',4902585,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257435',4902586,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257435',4902587,'2877','436',1273281.00,1278833.65,5552.65,3664749.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257435',4902588,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257435',4902589,'2910','436',555042.02,557823.29,2781.27,1835638.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257436',4902590,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257436',4902591,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257436',4902592,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257436',4902593,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257436',4902594,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257436',4902595,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257436',4902596,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257436',4902597,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257436',4902598,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257436',4902599,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257436',4902600,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257436',4902601,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257436',4902602,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257436',4902603,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257436',4902604,'2877','436',1278833.65,1278833.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257436',4902605,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257436',4902606,'2910','436',557823.29,557823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257437',4902607,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257437',4902608,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257437',4902609,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257437',4902610,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257437',4902611,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257437',4902612,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257437',4902613,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257437',4902614,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257437',4902615,'2871','435',443438.98,443438.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257437',4902616,'2872','435',198950.45,198950.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257437',4902617,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257437',4902618,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257437',4902619,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257437',4902620,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257437',4902621,'2877','436',1278833.65,1278833.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257437',4902622,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257437',4902623,'2910','436',557823.29,557823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257438',4902624,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257438',4902625,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257438',4902626,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257438',4902627,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257438',4902628,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257438',4902629,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257438',4902630,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257438',4902631,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257438',4902632,'2871','435',443438.98,446176.76,2737.78,451733.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','257438',4902633,'2872','435',198950.45,202605.54,3655.09,603089.85,0.00,0.00,0.00,0.00,0.00),('5','181','970','257438',4902634,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257438',4902635,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257438',4902636,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257438',4902637,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257438',4902638,'2877','436',1278833.65,1278833.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257438',4902639,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257438',4902640,'2910','436',557823.29,557823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257439',4902641,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257439',4902642,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257439',4902643,'2865','435',88088.02,88088.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257439',4902644,'2866','435',13434.51,13434.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257439',4902645,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257439',4902646,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257439',4902647,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257439',4902648,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257439',4902649,'2871','435',446176.76,446176.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257439',4902650,'2872','435',202605.54,202605.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257439',4902651,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257439',4902652,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257439',4902653,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257439',4902654,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257439',4902655,'2877','436',1278833.65,1278833.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257439',4902656,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257439',4902657,'2910','436',557823.29,557823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257440',4902658,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257440',4902659,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257440',4902660,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257440',4902661,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257440',4902662,'2867','435',114248.56,114468.30,219.74,36257.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257440',4902663,'2868','435',240953.31,242992.79,2039.48,336514.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257440',4902664,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257440',4902665,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257440',4902666,'2871','435',443438.98,444617.68,1178.70,194485.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','257440',4902667,'2872','435',198950.45,199884.93,934.48,154189.20,0.00,0.00,0.00,0.00,0.00),('5','181','970','257440',4902668,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257440',4902669,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257440',4902670,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257440',4902671,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257440',4902672,'2877','436',1273281.63,1278833.65,5552.02,3664333.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257440',4902673,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257440',4902674,'2910','436',555042.02,557823.29,2781.27,1835638.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257441',4902675,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257441',4902676,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257441',4902677,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257441',4902678,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257441',4902679,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257441',4902680,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257441',4902681,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257441',4902682,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257441',4902683,'2871','435',444617.68,446176.76,1559.08,257248.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257441',4902684,'2872','435',199884.93,202605.54,2720.61,448900.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257441',4902685,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257441',4902686,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257441',4902687,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257441',4902688,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257441',4902689,'2877','436',1278833.65,1288070.67,9237.02,6096433.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257441',4902690,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257441',4902691,'2910','436',557823.29,564055.37,6232.08,4113172.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257442',4902692,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257442',4902693,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257442',4902694,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257442',4902695,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257442',4902696,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257442',4902697,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257442',4902698,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257442',4902699,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257442',4902700,'2871','435',446176.76,448114.06,1937.30,319654.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','257442',4902701,'2872','435',202605.54,205562.41,2956.87,487883.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','257442',4902702,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257442',4902703,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257442',4902704,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257442',4902705,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257442',4902706,'2877','436',1288070.67,1294891.32,6820.65,4501629.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257442',4902707,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257442',4902708,'2910','436',564055.37,567176.81,3121.44,2060150.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257443',4902709,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257443',4902710,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257443',4902711,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257443',4902712,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257443',4902713,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257443',4902714,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257443',4902715,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257443',4902716,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257443',4902717,'2871','435',448114.06,450506.63,2392.57,394774.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257443',4902718,'2872','435',205562.41,208353.77,2791.36,460574.40,0.00,0.00,0.00,0.00,0.00),('5','181','970','257443',4902719,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257443',4902720,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257443',4902721,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257443',4902722,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257443',4902723,'2877','436',1294891.32,1304658.21,9766.89,6446147.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257443',4902724,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257443',4902725,'2910','436',567176.81,573878.54,6701.73,4423141.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257444',4902726,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257444',4902727,'2864','435',442319.58,442319.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257444',4902728,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257444',4902729,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257444',4902730,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257444',4902731,'2868','435',242992.79,242992.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257444',4902732,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257444',4902733,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257444',4902734,'2871','435',450506.63,454737.17,4230.54,698039.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257444',4902735,'2872','435',208353.77,208353.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257444',4902736,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257444',4902737,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257444',4902738,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257444',4902739,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257444',4902740,'2877','436',1304658.21,1309017.12,4358.91,2876880.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257444',4902741,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257444',4902742,'2910','436',573878.54,575279.60,1401.06,924699.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257445',4902743,'2863','435',615466.38,615466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257445',4902744,'2864','435',442319.58,444265.91,1946.33,321144.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257445',4902745,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257445',4902746,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257445',4902747,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257445',4902748,'2868','435',242992.79,244791.71,1798.92,296821.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','257445',4902749,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257445',4902750,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257445',4902751,'2871','435',454737.17,457808.35,3071.18,506744.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','257445',4902752,'2872','435',208353.77,208353.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257445',4902753,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257445',4902754,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257445',4902755,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257445',4902756,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257445',4902757,'2877','436',1309017.12,1315617.01,6599.89,4355927.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257445',4902758,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257445',4902759,'2910','436',575279.60,578046.20,2766.60,1825956.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257446',4902760,'2863','435',615466.38,616810.06,1343.68,221707.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257446',4902761,'2864','435',444265.91,447122.41,2856.50,471322.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257446',4902762,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257446',4902763,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257446',4902764,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257446',4902765,'2868','435',244791.71,244794.18,2.47,407.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257446',4902766,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257446',4902767,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257446',4902768,'2871','435',457808.35,461248.65,3440.30,567649.50,0.00,0.00,0.00,0.00,0.00),('5','181','971','257446',4902769,'2872','435',208353.77,208353.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257446',4902770,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257446',4902771,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257446',4902772,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257446',4902773,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257446',4902774,'2877','436',1315617.01,1325303.15,9686.14,6392852.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257446',4902775,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257446',4902776,'2910','436',578046.20,582017.02,3970.82,2620741.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257447',4902777,'2863','435',616810.06,619968.64,3158.58,521165.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257447',4902778,'2864','435',447122.41,448190.49,1068.08,176233.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257447',4902779,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257447',4902780,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257447',4902781,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257447',4902782,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257447',4902783,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257447',4902784,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257447',4902785,'2871','435',461248.65,465135.22,3886.57,641284.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257447',4902786,'2872','435',208353.77,208353.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257447',4902787,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257447',4902788,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257447',4902789,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257447',4902790,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257447',4902791,'2877','436',1325303.15,1335844.43,10541.28,6957244.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257447',4902792,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257447',4902793,'2910','436',582017.02,587243.62,5226.60,3449556.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257448',4902794,'2863','435',619968.64,619978.75,10.11,1668.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257448',4902795,'2864','435',448190.49,448200.49,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257448',4902796,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257448',4902797,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257448',4902798,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257448',4902799,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257448',4902800,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257448',4902801,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257448',4902802,'2871','435',465135.22,469373.07,4237.85,699245.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','257448',4902803,'2872','435',208353.77,210310.31,1956.54,322829.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','257448',4902804,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257448',4902805,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257448',4902806,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257448',4902807,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257448',4902808,'2877','436',1335844.43,1344444.01,8599.58,5675722.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257448',4902809,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257448',4902810,'2910','436',587243.62,592786.81,5543.19,3658505.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257449',4902811,'2863','435',619978.75,621574.87,1596.12,263359.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257449',4902812,'2864','435',448200.49,448874.27,673.78,111173.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257449',4902813,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257449',4902814,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257449',4902815,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257449',4902816,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257449',4902817,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257449',4902818,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257449',4902819,'2871','435',469373.07,473622.49,4249.42,701154.30,0.00,0.00,0.00,0.00,0.00),('5','181','971','257449',4902820,'2872','435',210310.31,210345.85,35.54,5864.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','257449',4902821,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257449',4902822,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257449',4902823,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257449',4902824,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257449',4902825,'2877','436',1344444.01,1356979.66,12535.65,8398885.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','257449',4902826,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257449',4902827,'2910','436',592786.81,599559.00,6772.19,4537367.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257450',4902828,'2863','435',621574.87,622892.61,1317.74,217427.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257450',4902829,'2864','435',448874.27,450339.11,1464.84,241698.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257450',4902830,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257450',4902831,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257450',4902832,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257450',4902833,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257450',4902834,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257450',4902835,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257450',4902836,'2871','435',473622.49,477067.44,3444.95,568416.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257450',4902837,'2872','435',210345.85,210345.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257450',4902838,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257450',4902839,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257450',4902840,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257450',4902841,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257450',4902842,'2877','436',1356979.66,1363910.77,6931.11,4851777.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257450',4902843,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257450',4902844,'2910','436',599559.00,604851.96,5292.96,3705072.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257451',4902845,'2863','435',622892.61,627073.98,4181.37,689926.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257451',4902846,'2864','435',450339.11,451674.04,1334.93,220263.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257451',4902847,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257451',4902848,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257451',4902849,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257451',4902850,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257451',4902851,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257451',4902852,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257451',4902853,'2871','435',477067.44,477067.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257451',4902854,'2872','435',210345.85,210345.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257451',4902855,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257451',4902856,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257451',4902857,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257451',4902858,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257451',4902859,'2877','436',1363910.77,1373372.83,9462.06,6623442.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257451',4902860,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257451',4902861,'2910','436',604851.96,608152.83,3300.87,2310609.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257452',4902862,'2863','435',627073.98,630964.41,3890.43,641920.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257452',4902863,'2864','435',451674.04,455158.71,3484.67,574970.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257452',4902864,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257452',4902865,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257452',4902866,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257452',4902867,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257452',4902868,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257452',4902869,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257452',4902870,'2871','435',477067.44,477067.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257452',4902871,'2872','435',210345.85,210345.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257452',4902872,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257452',4902873,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257452',4902874,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257452',4902875,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257452',4902876,'2877','436',1373372.83,1373372.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257452',4902877,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257452',4902878,'2910','436',608152.83,608152.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257453',4902879,'2863','435',630964.41,634332.09,3367.68,555667.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257453',4902880,'2864','435',455158.71,459269.37,4110.66,678258.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257453',4902881,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257453',4902882,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257453',4902883,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257453',4902884,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257453',4902885,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257453',4902886,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257453',4902887,'2871','435',477067.44,478001.16,933.72,154063.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','257453',4902888,'2872','435',210345.85,210345.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257453',4902889,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257453',4902890,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257453',4902891,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257453',4902892,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257453',4902893,'2877','436',1373372.83,1383345.05,9972.22,7179998.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257453',4902894,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257453',4902895,'2910','436',608152.83,612980.81,4827.98,3476145.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257454',4902896,'2863','435',634332.09,636405.68,2073.59,342142.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257454',4902897,'2864','435',459269.37,461983.70,2714.33,447864.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257454',4902898,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257454',4902899,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257454',4902900,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257454',4902901,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257454',4902902,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257454',4902903,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257454',4902904,'2871','435',478001.16,482872.13,4870.97,803710.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257454',4902905,'2872','435',210345.85,210345.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257454',4902906,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257454',4902907,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257454',4902908,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257454',4902909,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257454',4902910,'2877','436',1383345.05,1388452.52,5107.47,3677378.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257454',4902911,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257454',4902912,'2910','436',612980.81,614247.22,1266.41,911815.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257455',4902913,'2863','435',636405.68,637074.90,669.22,110421.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257455',4902914,'2864','435',461983.70,462135.81,152.11,25098.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257455',4902915,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257455',4902916,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257455',4902917,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257455',4902918,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257455',4902919,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257455',4902920,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257455',4902921,'2871','435',482872.13,487088.68,4216.55,695730.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257455',4902922,'2872','435',210345.85,212845.35,2499.50,412417.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257455',4902923,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257455',4902924,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257455',4902925,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257455',4902926,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257455',4902927,'2877','436',1388452.52,1390646.29,2193.77,1579514.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257455',4902928,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257455',4902929,'2910','436',614247.22,614954.46,707.24,509212.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257456',4902930,'2863','435',637074.90,637074.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257456',4902931,'2864','435',462135.81,462135.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257456',4902932,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257456',4902933,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257456',4902934,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257456',4902935,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257456',4902936,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257456',4902937,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257456',4902938,'2871','435',487088.68,490674.51,3585.83,591661.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257456',4902939,'2872','435',212845.35,214588.08,1742.73,287550.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257456',4902940,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257456',4902941,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257456',4902942,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257456',4902943,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257456',4902944,'2877','436',1390646.29,1391951.02,1304.73,939405.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257456',4902945,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257456',4902946,'2910','436',614954.46,616365.54,1411.08,1015977.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257457',4902947,'2863','435',637074.90,637074.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257457',4902948,'2864','435',462135.81,462135.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257457',4902949,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257457',4902950,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257457',4902951,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257457',4902952,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257457',4902953,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257457',4902954,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257457',4902955,'2871','435',490674.51,492555.66,1881.15,310389.75,0.00,0.00,0.00,0.00,0.00),('5','181','971','257457',4902956,'2872','435',214588.08,218661.48,4073.40,672111.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257457',4902957,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257457',4902958,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257457',4902959,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257457',4902960,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257457',4902961,'2877','436',1391951.02,1391951.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257457',4902962,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257457',4902963,'2910','436',616365.54,618760.54,2395.00,1724400.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257458',4902964,'2863','435',637074.90,637074.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257458',4902965,'2864','435',462135.81,463305.24,1169.43,192955.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257458',4902966,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257458',4902967,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257458',4902968,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257458',4902969,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257458',4902970,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257458',4902971,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257458',4902972,'2871','435',492555.66,494336.39,1780.73,293820.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257458',4902973,'2872','435',218661.48,220925.07,2263.59,373492.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','257458',4902974,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257458',4902975,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257458',4902976,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257458',4902977,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257458',4902978,'2877','436',1391951.02,1391951.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257458',4902979,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257458',4902980,'2910','436',618760.54,618800.54,40.00,28800.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257459',4902981,'2863','435',637074.90,639918.73,2843.83,469231.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257459',4902982,'2864','435',463305.24,464238.51,933.27,153989.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257459',4902983,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257459',4902984,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257459',4902985,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257459',4902986,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257459',4902987,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257459',4902988,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257459',4902989,'2871','435',494336.39,494525.73,189.34,31241.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257459',4902990,'2872','435',220925.07,222932.17,2007.10,331171.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257459',4902991,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257459',4902992,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257459',4902993,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257459',4902994,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257459',4902995,'2877','436',1391951.02,1391971.02,20.00,14400.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257459',4902996,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257459',4902997,'2910','436',618800.54,618840.54,40.00,28800.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257460',4902998,'2863','435',639918.73,644207.18,4288.45,707594.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257460',4902999,'2864','435',464238.51,467546.03,3307.52,545740.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257460',4903000,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257460',4903001,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257460',4903002,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257460',4903003,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257460',4903004,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257460',4903005,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257460',4903006,'2871','435',494525.73,494525.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257460',4903007,'2872','435',222932.17,222932.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257460',4903008,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257460',4903009,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257460',4903010,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257460',4903011,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257460',4903012,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257460',4903013,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257460',4903014,'2910','436',618840.54,618991.40,150.86,108619.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257461',4903015,'2863','435',644207.18,647655.96,3448.78,569048.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257461',4903016,'2864','435',467546.03,470776.67,3230.64,533055.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257461',4903017,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257461',4903018,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257461',4903019,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257461',4903020,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257461',4903021,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257461',4903022,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257461',4903023,'2871','435',494525.73,494525.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257461',4903024,'2872','435',222932.17,222932.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257461',4903025,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257461',4903026,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257461',4903027,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257461',4903028,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257461',4903029,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257461',4903030,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257461',4903031,'2910','436',618991.40,619095.40,104.00,74880.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257462',4903032,'2863','435',647655.96,650866.28,3210.32,529702.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257462',4903033,'2864','435',470776.67,473983.28,3206.61,529090.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257462',4903034,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257462',4903035,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257462',4903036,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257462',4903037,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257462',4903038,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257462',4903039,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257462',4903040,'2871','435',494525.73,494525.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257462',4903041,'2872','435',222932.17,222932.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257462',4903042,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257462',4903043,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257462',4903044,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257462',4903045,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257462',4903046,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257462',4903047,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257462',4903048,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257463',4903049,'2863','435',650866.28,654236.83,3370.55,556140.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257463',4903050,'2864','435',473983.28,477692.78,3709.50,612067.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257463',4903051,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257463',4903052,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257463',4903053,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257463',4903054,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257463',4903055,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257463',4903056,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257463',4903057,'2871','435',494525.73,494525.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257463',4903058,'2872','435',222932.17,222932.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257463',4903059,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257463',4903060,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257463',4903061,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257463',4903062,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257463',4903063,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257463',4903064,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257463',4903065,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257464',4903066,'2863','435',654236.83,657697.80,3460.97,571060.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257464',4903067,'2864','435',477692.78,480617.54,2924.76,482585.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257464',4903068,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257464',4903069,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257464',4903070,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257464',4903071,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257464',4903072,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257464',4903073,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257464',4903074,'2871','435',494525.73,494525.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257464',4903075,'2872','435',222932.17,222932.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257464',4903076,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257464',4903077,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257464',4903078,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257464',4903079,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257464',4903080,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257464',4903081,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257464',4903082,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257465',4903083,'2863','435',657697.80,657991.71,293.91,48495.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257465',4903084,'2864','435',480617.54,481235.44,617.90,101953.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257465',4903085,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257465',4903086,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257465',4903087,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257465',4903088,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257465',4903089,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257465',4903090,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257465',4903091,'2871','435',494525.73,497247.69,2721.96,449123.40,0.00,0.00,0.00,0.00,0.00),('5','181','971','257465',4903092,'2872','435',222932.17,224416.28,1484.11,244878.15,0.00,0.00,0.00,0.00,0.00),('5','181','970','257465',4903093,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257465',4903094,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257465',4903095,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257465',4903096,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257465',4903097,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257465',4903098,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257465',4903099,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257466',4903100,'2863','435',657991.71,657991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257466',4903101,'2864','435',481235.44,481235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257466',4903102,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257466',4903103,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257466',4903104,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257466',4903105,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257466',4903106,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257466',4903107,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257466',4903108,'2871','435',497247.69,500744.52,3496.83,576976.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257466',4903109,'2872','435',224416.28,228179.58,3763.30,620944.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257466',4903110,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257466',4903111,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257466',4903112,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257466',4903113,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257466',4903114,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257466',4903115,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257466',4903116,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257467',4903117,'2863','435',657991.71,657991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257467',4903118,'2864','435',481235.44,481235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257467',4903119,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257467',4903120,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257467',4903121,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257467',4903122,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257467',4903123,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257467',4903124,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257467',4903125,'2871','435',500744.52,503945.60,3201.08,528178.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257467',4903126,'2872','435',228179.58,231944.85,3765.27,621269.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','257467',4903127,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257467',4903128,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257467',4903129,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257467',4903130,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257467',4903131,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257467',4903132,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257467',4903133,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257468',4903134,'2863','435',657991.71,657991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257468',4903135,'2864','435',481235.44,481235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257468',4903136,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257468',4903137,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257468',4903138,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257468',4903139,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257468',4903140,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257468',4903141,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257468',4903142,'2871','435',503945.60,506291.92,2346.32,387142.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','257468',4903143,'2872','435',231944.85,236150.07,4205.22,693861.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257468',4903144,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257468',4903145,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257468',4903146,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257468',4903147,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257468',4903148,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257468',4903149,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257468',4903150,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257469',4903151,'2863','435',657991.71,657991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257469',4903152,'2864','435',481235.44,481235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257469',4903153,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257469',4903154,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257469',4903155,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257469',4903156,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257469',4903157,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257469',4903158,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257469',4903159,'2871','435',506291.92,510783.56,4491.64,741120.60,0.00,0.00,0.00,0.00,0.00),('5','181','971','257469',4903160,'2872','435',236150.07,239763.00,3612.93,596133.45,0.00,0.00,0.00,0.00,0.00),('5','181','970','257469',4903161,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257469',4903162,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257469',4903163,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257469',4903164,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257469',4903165,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257469',4903166,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257469',4903167,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257470',4903168,'2863','435',657991.71,657991.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257470',4903169,'2864','435',481235.44,481235.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257470',4903170,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257470',4903171,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257470',4903172,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257470',4903173,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257470',4903174,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257470',4903175,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257470',4903176,'2871','435',510783.56,514903.54,4119.98,679796.70,0.00,0.00,0.00,0.00,0.00),('5','181','971','257470',4903177,'2872','435',239763.00,241659.17,1896.17,312868.05,0.00,0.00,0.00,0.00,0.00),('5','181','970','257470',4903178,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257470',4903179,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257470',4903180,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257470',4903181,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257470',4903182,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257470',4903183,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257470',4903184,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257471',4903185,'2863','435',657991.71,660642.02,2650.31,437301.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257471',4903186,'2864','435',481235.44,482979.03,1743.59,287692.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257471',4903187,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257471',4903188,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257471',4903189,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257471',4903190,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257471',4903191,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257471',4903192,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257471',4903193,'2871','435',514903.54,515148.05,244.51,40344.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','257471',4903194,'2872','435',241659.17,242030.17,371.00,61215.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257471',4903195,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257471',4903196,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257471',4903197,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257471',4903198,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257471',4903199,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257471',4903200,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257471',4903201,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257472',4903202,'2863','435',660642.02,662630.89,1988.87,328163.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257472',4903203,'2864','435',482979.03,486528.84,3549.81,585718.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257472',4903204,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257472',4903205,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257472',4903206,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257472',4903207,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257472',4903208,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257472',4903209,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257472',4903210,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257472',4903211,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257472',4903212,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257472',4903213,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257472',4903214,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257472',4903215,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257472',4903216,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257472',4903217,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257472',4903218,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257473',4903219,'2863','435',662630.89,667048.74,4417.85,728945.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257473',4903220,'2864','435',486528.84,489441.18,2912.34,480536.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257473',4903221,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257473',4903222,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257473',4903223,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257473',4903224,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257473',4903225,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257473',4903226,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257473',4903227,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257473',4903228,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257473',4903229,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257473',4903230,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257473',4903231,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257473',4903232,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257473',4903233,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257473',4903234,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257473',4903235,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257474',4903236,'2863','435',667048.74,669221.30,2172.56,358472.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257474',4903237,'2864','435',489441.18,490814.97,1373.79,226675.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257474',4903238,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257474',4903239,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257474',4903240,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257474',4903241,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257474',4903242,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257474',4903243,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257474',4903244,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257474',4903245,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257474',4903246,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257474',4903247,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257474',4903248,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257474',4903249,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257474',4903250,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257474',4903251,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257474',4903252,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257475',4903253,'2863','435',669221.30,671136.20,1914.90,315958.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257475',4903254,'2864','435',490814.97,497458.53,6643.56,1096187.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257475',4903255,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257475',4903256,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257475',4903257,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257475',4903258,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257475',4903259,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257475',4903260,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257475',4903261,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257475',4903262,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257475',4903263,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257475',4903264,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257475',4903265,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257475',4903266,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257475',4903267,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257475',4903268,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257475',4903269,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257476',4903270,'2863','435',671136.20,673737.74,2601.54,429254.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257476',4903271,'2864','435',497458.53,501859.24,4400.71,726117.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257476',4903272,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257476',4903273,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257476',4903274,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257476',4903275,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257476',4903276,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257476',4903277,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257476',4903278,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257476',4903279,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257476',4903280,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257476',4903281,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257476',4903282,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257476',4903283,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257476',4903284,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257476',4903285,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257476',4903286,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257477',4903287,'2863','435',673737.74,674500.14,762.40,125796.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257477',4903288,'2864','435',501859.24,504764.51,2905.27,479369.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257477',4903289,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257477',4903290,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257477',4903291,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257477',4903292,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257477',4903293,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257477',4903294,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257477',4903295,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257477',4903296,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257477',4903297,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257477',4903298,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257477',4903299,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257477',4903300,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257477',4903301,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257477',4903302,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257477',4903303,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257478',4903304,'2863','435',674500.14,674500.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257478',4903305,'2864','435',504764.51,504764.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257478',4903306,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257478',4903307,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257478',4903308,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257478',4903309,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257478',4903310,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257478',4903311,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257478',4903312,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257478',4903313,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257478',4903314,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257478',4903315,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257478',4903316,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257478',4903317,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257478',4903318,'2877','436',1391971.02,1391971.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257478',4903319,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257478',4903320,'2910','436',619095.40,619095.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257479',4903321,'2863','435',674500.14,674500.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257479',4903322,'2864','435',504764.51,504764.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257479',4903323,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257479',4903324,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257479',4903325,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257479',4903326,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257479',4903327,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257479',4903328,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257479',4903329,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257479',4903330,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257479',4903331,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257479',4903332,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257479',4903333,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257479',4903334,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257479',4903335,'2877','436',1391971.02,1394755.65,2784.63,2060626.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257479',4903336,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257479',4903337,'2910','436',619095.40,620370.93,1275.53,943892.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257480',4903338,'2863','435',674500.14,674500.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257480',4903339,'2864','435',504764.51,504764.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257480',4903340,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257480',4903341,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257480',4903342,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257480',4903343,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257480',4903344,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257480',4903345,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257480',4903346,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257480',4903347,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257480',4903348,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257480',4903349,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257480',4903350,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257480',4903351,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257480',4903352,'2877','436',1394755.65,1398515.20,3759.55,3007640.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257480',4903353,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257480',4903354,'2910','436',620370.93,621457.20,1086.27,869016.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257480',4903355,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257481',4903356,'2863','435',674500.14,676119.27,1619.13,267156.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257481',4903357,'2864','435',504764.51,506180.31,1415.80,233607.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257481',4903358,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257481',4903359,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257481',4903360,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257481',4903361,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257481',4903362,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257481',4903363,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257481',4903364,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257481',4903365,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257481',4903366,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257481',4903367,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257481',4903368,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257481',4903369,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257481',4903370,'2877','436',1398515.20,1401658.17,3142.97,2514376.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257481',4903371,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257481',4903372,'2910','436',621457.20,623279.22,1822.02,1457616.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257481',4903373,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257482',4903374,'2863','435',676119.27,679119.49,3000.22,495036.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257482',4903375,'2864','435',506180.31,507914.67,1734.36,286169.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257482',4903376,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257482',4903377,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257482',4903378,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257482',4903379,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257482',4903380,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257482',4903381,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257482',4903382,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257482',4903383,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257482',4903384,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257482',4903385,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257482',4903386,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257482',4903387,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257482',4903388,'2877','436',1401658.17,1401658.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257482',4903389,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257482',4903390,'2910','436',623279.22,626505.12,3225.90,2580720.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257482',4903391,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257483',4903392,'2863','435',679119.49,681347.95,2228.46,367695.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257483',4903393,'2864','435',507914.67,510469.37,2554.70,421525.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257483',4903394,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257483',4903395,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257483',4903396,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257483',4903397,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257483',4903398,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257483',4903399,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257483',4903400,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257483',4903401,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257483',4903402,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257483',4903403,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257483',4903404,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257483',4903405,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257483',4903406,'2877','436',1401658.17,1404376.86,2718.69,2174952.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257483',4903407,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257483',4903408,'2910','436',626505.12,628011.06,1505.94,1204752.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257483',4903409,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257484',4903410,'2863','435',681347.95,682870.27,1522.32,251182.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257484',4903411,'2864','435',510469.37,513152.65,2683.28,442741.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257484',4903412,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257484',4903413,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257484',4903414,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257484',4903415,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257484',4903416,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257484',4903417,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257484',4903418,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257484',4903419,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257484',4903420,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257484',4903421,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257484',4903422,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257484',4903423,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257484',4903424,'2877','436',1404376.86,1407819.36,3442.50,2754000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257484',4903425,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257484',4903426,'2910','436',628011.06,628940.55,929.49,743592.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257484',4903427,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257485',4903428,'2863','435',682870.27,686143.46,3273.19,540076.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257485',4903429,'2864','435',513152.65,515303.00,2150.35,354807.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257485',4903430,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257485',4903431,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257485',4903432,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257485',4903433,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257485',4903434,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257485',4903435,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257485',4903436,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257485',4903437,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257485',4903438,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257485',4903439,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257485',4903440,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257485',4903441,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257485',4903442,'2877','436',1407819.36,1409218.64,1399.28,1119424.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257485',4903443,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257485',4903444,'2910','436',628940.55,628940.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257485',4903445,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257486',4903446,'2863','435',686143.46,688833.63,2690.17,443878.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257486',4903447,'2864','435',515303.00,515303.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257486',4903448,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257486',4903449,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257486',4903450,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257486',4903451,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257486',4903452,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257486',4903453,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257486',4903454,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257486',4903455,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257486',4903456,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257486',4903457,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257486',4903458,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257486',4903459,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257486',4903460,'2877','436',1409218.64,1413960.60,4741.96,3793568.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257486',4903461,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257486',4903462,'2910','436',628940.55,629500.55,560.00,448000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257486',4903463,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257487',4903464,'2863','435',688833.63,692318.95,3485.32,575077.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257487',4903465,'2864','435',515303.00,517309.19,2006.19,331021.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257487',4903466,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257487',4903467,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257487',4903468,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257487',4903469,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257487',4903470,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257487',4903471,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257487',4903472,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257487',4903473,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257487',4903474,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257487',4903475,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257487',4903476,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257487',4903477,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257487',4903478,'2877','436',1413960.60,1415575.73,1615.13,1292104.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257487',4903479,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257487',4903480,'2910','436',629500.55,630302.55,802.00,641600.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257487',4903481,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257488',4903482,'2863','435',692318.95,696391.39,4072.44,671952.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257488',4903483,'2864','435',517309.19,519082.92,1773.73,292665.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257488',4903484,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257488',4903485,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257488',4903486,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257488',4903487,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257488',4903488,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257488',4903489,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257488',4903490,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257488',4903491,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257488',4903492,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257488',4903493,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257488',4903494,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257488',4903495,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257488',4903496,'2877','436',1415575.73,1418690.48,3114.75,2491800.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257488',4903497,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257488',4903498,'2910','436',630302.55,632208.84,1906.29,1525032.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257488',4903499,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257489',4903500,'2863','435',696391.39,698689.35,2297.96,379163.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257489',4903501,'2864','435',519082.92,522536.14,3453.22,569781.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257489',4903502,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257489',4903503,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257489',4903504,'2867','435',114468.30,114468.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257489',4903505,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257489',4903506,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257489',4903507,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257489',4903508,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257489',4903509,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257489',4903510,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257489',4903511,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257489',4903512,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257489',4903513,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257489',4903514,'2877','436',1418690.48,1421894.42,3203.94,2563152.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257489',4903515,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257489',4903516,'2910','436',632208.84,632278.84,70.00,56000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257489',4903517,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257490',4903518,'2863','435',698689.35,698689.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257490',4903519,'2864','435',522536.14,522805.59,269.45,44459.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257490',4903520,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257490',4903521,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257490',4903522,'2867','435',114468.30,117231.72,2763.42,455964.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','257490',4903523,'2868','435',244794.18,244794.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257490',4903524,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257490',4903525,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257490',4903526,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257490',4903527,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257490',4903528,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257490',4903529,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257490',4903530,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257490',4903531,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257490',4903532,'2877','436',1421894.42,1423874.14,1979.72,1583776.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257490',4903533,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257490',4903534,'2910','436',632278.84,633322.59,1043.75,835000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257490',4903535,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257491',4903536,'2863','435',698689.35,699441.99,752.64,124185.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257491',4903537,'2864','435',522805.59,523910.38,1104.79,182290.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257491',4903538,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257491',4903539,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257491',4903540,'2867','435',117231.72,121215.80,3984.08,657373.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','257491',4903541,'2868','435',244794.18,249493.48,4699.30,775384.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257491',4903542,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257491',4903543,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257491',4903544,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257491',4903545,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257491',4903546,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257491',4903547,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257491',4903548,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257491',4903549,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257491',4903550,'2877','436',1423874.14,1426704.96,2830.82,2264656.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257491',4903551,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257491',4903552,'2910','436',633322.59,633346.83,24.24,19392.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257491',4903553,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257492',4903554,'2863','435',699441.99,699441.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257492',4903555,'2864','435',523910.38,523910.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257492',4903556,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257492',4903557,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257492',4903558,'2867','435',121215.80,121215.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257492',4903559,'2868','435',249493.48,249493.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257492',4903560,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257492',4903561,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257492',4903562,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257492',4903563,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257492',4903564,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257492',4903565,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257492',4903566,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257492',4903567,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257492',4903568,'2877','436',1426704.96,1427264.96,560.00,448000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257492',4903569,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257492',4903570,'2910','436',633346.83,633528.70,181.87,145496.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257492',4903571,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257493',4903572,'2863','435',699441.99,701659.06,2217.07,365816.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257493',4903573,'2864','435',523910.38,527388.85,3478.47,573947.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257493',4903574,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257493',4903575,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257493',4903576,'2867','435',121215.80,121215.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257493',4903577,'2868','435',249493.48,249493.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257493',4903578,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257493',4903579,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257493',4903580,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257493',4903581,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257493',4903582,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257493',4903583,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257493',4903584,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257493',4903585,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257493',4903586,'2877','436',1427264.96,1428147.20,882.24,705792.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257493',4903587,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257493',4903588,'2910','436',633528.70,633528.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257493',4903589,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257494',4903590,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257494',4903591,'2864','435',527388.85,530606.03,3217.18,530834.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257494',4903592,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257494',4903593,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257494',4903594,'2867','435',121215.80,121215.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257494',4903595,'2868','435',249493.48,249493.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257494',4903596,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257494',4903597,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257494',4903598,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257494',4903599,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257494',4903600,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257494',4903601,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257494',4903602,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257494',4903603,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257494',4903604,'2877','436',1428147.20,1428147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257494',4903605,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257494',4903606,'2910','436',633528.70,633528.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257494',4903607,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257495',4903608,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257495',4903609,'2864','435',530606.03,530758.36,152.33,25134.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257495',4903610,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257495',4903611,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257495',4903612,'2867','435',121215.80,128624.94,7409.14,1222508.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257495',4903613,'2868','435',249493.48,249493.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257495',4903614,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257495',4903615,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257495',4903616,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257495',4903617,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257495',4903618,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257495',4903619,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257495',4903620,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257495',4903621,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257495',4903622,'2877','436',1428147.20,1432760.69,4613.49,3783061.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257495',4903623,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257495',4903624,'2910','436',633528.70,634390.09,861.39,706339.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257495',4903625,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257496',4903626,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257496',4903627,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257496',4903628,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257496',4903629,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257496',4903630,'2867','435',128624.94,133487.47,4862.53,802317.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257496',4903631,'2868','435',249493.48,251253.63,1760.15,290424.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257496',4903632,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257496',4903633,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257496',4903634,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257496',4903635,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257496',4903636,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257496',4903637,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257496',4903638,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257496',4903639,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257496',4903640,'2877','436',1432760.69,1438084.25,5323.56,4365319.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257496',4903641,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257496',4903642,'2910','436',634390.09,635962.79,1572.70,1289614.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257496',4903643,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257497',4903644,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257497',4903645,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257497',4903646,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257497',4903647,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257497',4903648,'2867','435',133487.47,136436.70,2949.23,486622.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','257497',4903649,'2868','435',251253.63,256316.47,5062.84,835368.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','257497',4903650,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257497',4903651,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257497',4903652,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257497',4903653,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257497',4903654,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257497',4903655,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257497',4903656,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257497',4903657,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257497',4903658,'2877','436',1438084.25,1438749.21,664.96,545267.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257497',4903659,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257497',4903660,'2910','436',635962.79,636443.63,480.84,394288.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257497',4903661,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257498',4903662,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257498',4903663,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257498',4903664,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257498',4903665,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257498',4903666,'2867','435',136436.70,139130.34,2693.64,444450.60,0.00,0.00,0.00,0.00,0.00),('5','181','968','257498',4903667,'2868','435',256316.47,260639.37,4322.90,713278.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257498',4903668,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257498',4903669,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257498',4903670,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257498',4903671,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257498',4903672,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257498',4903673,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257498',4903674,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257498',4903675,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257498',4903676,'2877','436',1438749.21,1440411.68,1662.47,1363225.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257498',4903677,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257498',4903678,'2910','436',636443.63,637699.26,1255.63,1029616.60,0.00,0.00,0.00,0.00,0.00),('5','181','973','257498',4903679,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257499',4903680,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257499',4903681,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257499',4903682,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257499',4903683,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257499',4903684,'2867','435',139130.34,140757.84,1627.50,268537.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257499',4903685,'2868','435',260639.37,263239.39,2600.02,429003.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','257499',4903686,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257499',4903687,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257499',4903688,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257499',4903689,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257499',4903690,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257499',4903691,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257499',4903692,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257499',4903693,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257499',4903694,'2877','436',1440411.68,1442219.45,1807.77,1482371.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257499',4903695,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257499',4903696,'2910','436',637699.26,637904.11,204.85,167977.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257499',4903697,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257500',4903698,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257500',4903699,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257500',4903700,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257500',4903701,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257500',4903702,'2867','435',140757.84,142953.82,2195.98,362336.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257500',4903703,'2868','435',263239.39,264733.65,1494.26,246552.90,0.00,0.00,0.00,0.00,0.00),('5','181','969','257500',4903704,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257500',4903705,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257500',4903706,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257500',4903707,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257500',4903708,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257500',4903709,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257500',4903710,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257500',4903711,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257500',4903712,'2877','436',1442219.45,1445880.87,3661.42,3002364.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257500',4903713,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257500',4903714,'2910','436',637904.11,638268.75,364.64,299004.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257500',4903715,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257501',4903716,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257501',4903717,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257501',4903718,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257501',4903719,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257501',4903720,'2867','435',142953.82,145512.05,2558.23,422107.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','257501',4903721,'2868','435',264733.65,267561.81,2828.16,466646.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','257501',4903722,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257501',4903723,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257501',4903724,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257501',4903725,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257501',4903726,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257501',4903727,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257501',4903728,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257501',4903729,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257501',4903730,'2877','436',1445880.87,1447602.80,1721.93,1411982.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257501',4903731,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257501',4903732,'2910','436',638268.75,638937.05,668.30,548006.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257501',4903733,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257502',4903734,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257502',4903735,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257502',4903736,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257502',4903737,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257502',4903738,'2867','435',145512.05,149004.89,3492.84,576318.60,0.00,0.00,0.00,0.00,0.00),('5','181','968','257502',4903739,'2868','435',267561.81,272130.42,4568.61,753820.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','257502',4903740,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257502',4903741,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257502',4903742,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257502',4903743,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257502',4903744,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257502',4903745,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257502',4903746,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257502',4903747,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257502',4903748,'2877','436',1447602.80,1450870.70,3267.90,2679678.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257502',4903749,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257502',4903750,'2910','436',638937.05,639807.05,870.00,713400.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257502',4903751,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257503',4903752,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257503',4903753,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257503',4903754,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257503',4903755,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257503',4903756,'2867','435',149004.89,151558.25,2553.36,421304.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','257503',4903757,'2868','435',272130.42,276621.46,4491.04,741021.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','257503',4903758,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257503',4903759,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257503',4903760,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257503',4903761,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257503',4903762,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257503',4903763,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257503',4903764,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257503',4903765,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257503',4903766,'2877','436',1450870.70,1454415.36,3544.66,2906621.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257503',4903767,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257503',4903768,'2910','436',639807.05,640521.43,714.38,585791.60,0.00,0.00,0.00,0.00,0.00),('5','181','973','257503',4903769,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257504',4903770,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257504',4903771,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257504',4903772,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257504',4903773,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257504',4903774,'2867','435',151558.25,154463.61,2905.36,479384.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','257504',4903775,'2868','435',276621.46,281502.00,4880.54,805289.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257504',4903776,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257504',4903777,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257504',4903778,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257504',4903779,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257504',4903780,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257504',4903781,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257504',4903782,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257504',4903783,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257504',4903784,'2877','436',1454415.36,1456430.60,2015.24,1652496.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257504',4903785,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257504',4903786,'2910','436',640521.43,641201.43,680.00,557600.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257504',4903787,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257505',4903788,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257505',4903789,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257505',4903790,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257505',4903791,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257505',4903792,'2867','435',154463.61,157129.79,2666.18,439919.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257505',4903793,'2868','435',281502.00,286422.98,4920.98,811961.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257505',4903794,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257505',4903795,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257505',4903796,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257505',4903797,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257505',4903798,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257505',4903799,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257505',4903800,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257505',4903801,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257505',4903802,'2877','436',1456430.60,1458382.62,1952.02,1600656.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257505',4903803,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257505',4903804,'2910','436',641201.43,641583.25,381.82,313092.40,0.00,0.00,0.00,0.00,0.00),('5','181','973','257505',4903805,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257506',4903806,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257506',4903807,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257506',4903808,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257506',4903809,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257506',4903810,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257506',4903811,'2868','435',286422.98,286834.51,411.53,67902.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','257506',4903812,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257506',4903813,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257506',4903814,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257506',4903815,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257506',4903816,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257506',4903817,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257506',4903818,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257506',4903819,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257506',4903820,'2877','436',1458382.62,1461568.51,3185.89,2612429.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257506',4903821,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257506',4903822,'2910','436',641583.25,641634.34,51.09,41893.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257506',4903823,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257507',4903824,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257507',4903825,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257507',4903826,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257507',4903827,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257507',4903828,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257507',4903829,'2868','435',286834.51,286834.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257507',4903830,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257507',4903831,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257507',4903832,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257507',4903833,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257507',4903834,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257507',4903835,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257507',4903836,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257507',4903837,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257507',4903838,'2877','436',1461568.51,1463238.52,1670.01,1369408.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257507',4903839,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257507',4903840,'2910','436',641634.34,641692.28,57.94,47510.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257507',4903841,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257508',4903842,'2863','435',701659.06,701659.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257508',4903843,'2864','435',530758.36,530758.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257508',4903844,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257508',4903845,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257508',4903846,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257508',4903847,'2868','435',286834.51,286834.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257508',4903848,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257508',4903849,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257508',4903850,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257508',4903851,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257508',4903852,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257508',4903853,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257508',4903854,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257508',4903855,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257508',4903856,'2877','436',1463238.52,1464364.52,1126.00,900800.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257508',4903857,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257508',4903858,'2910','436',641692.28,642204.03,511.75,409400.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257508',4903859,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257509',4903860,'2863','435',701659.06,704373.17,2714.11,502110.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257509',4903861,'2864','435',530758.36,531873.47,1115.11,206295.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257509',4903862,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257509',4903863,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257509',4903864,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257509',4903865,'2868','435',286834.51,286834.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257509',4903866,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257509',4903867,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257509',4903868,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257509',4903869,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257509',4903870,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257509',4903871,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257509',4903872,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257509',4903873,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257509',4903874,'2877','436',1464364.52,1465941.12,1576.60,1261280.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257509',4903875,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257509',4903876,'2910','436',642204.03,642272.28,68.25,54600.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257509',4903877,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257510',4903878,'2863','435',704373.17,705487.32,1114.15,206117.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257510',4903879,'2864','435',531873.47,535072.96,3199.49,591905.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257510',4903880,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257510',4903881,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257510',4903882,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257510',4903883,'2868','435',286834.51,286834.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257510',4903884,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257510',4903885,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257510',4903886,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257510',4903887,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257510',4903888,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257510',4903889,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257510',4903890,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257510',4903891,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257510',4903892,'2877','436',1465941.12,1467700.04,1758.92,1407136.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257510',4903893,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257510',4903894,'2910','436',642272.28,642627.76,355.48,284384.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257510',4903895,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257511',4903896,'2863','435',705487.32,707585.99,2098.67,388253.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257511',4903897,'2864','435',535072.96,538825.74,3752.78,694264.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257511',4903898,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257511',4903899,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257511',4903900,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257511',4903901,'2868','435',286834.51,286834.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257511',4903902,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257511',4903903,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257511',4903904,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257511',4903905,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257511',4903906,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257511',4903907,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257511',4903908,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257511',4903909,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257511',4903910,'2877','436',1467700.04,1468101.30,401.26,321008.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257511',4903911,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257511',4903912,'2910','436',642627.76,642962.78,335.02,268016.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257511',4903913,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257512',4903914,'2863','435',707585.99,711390.76,3804.77,703882.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257512',4903915,'2864','435',538825.74,541857.60,3031.86,560894.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257512',4903916,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257512',4903917,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257512',4903918,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257512',4903919,'2868','435',286834.51,287538.66,704.15,130267.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257512',4903920,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257512',4903921,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257512',4903922,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257512',4903923,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257512',4903924,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257512',4903925,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257512',4903926,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257512',4903927,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257512',4903928,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257512',4903929,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257512',4903930,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257512',4903931,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257513',4903932,'2863','435',711390.76,712494.22,1103.46,204140.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257513',4903933,'2864','435',541857.60,544496.19,2638.59,488139.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257513',4903934,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257513',4903935,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257513',4903936,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257513',4903937,'2868','435',287538.66,289067.26,1528.60,282791.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257513',4903938,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257513',4903939,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257513',4903940,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257513',4903941,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257513',4903942,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257513',4903943,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257513',4903944,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257513',4903945,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257513',4903946,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257513',4903947,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257513',4903948,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257513',4903949,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257514',4903950,'2863','435',712494.22,713910.64,1416.42,262037.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257514',4903951,'2864','435',544496.19,546444.11,1947.92,360365.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257514',4903952,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257514',4903953,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257514',4903954,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257514',4903955,'2868','435',289067.26,291957.25,2889.99,534648.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257514',4903956,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257514',4903957,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257514',4903958,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257514',4903959,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257514',4903960,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257514',4903961,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257514',4903962,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257514',4903963,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257514',4903964,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257514',4903965,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257514',4903966,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257514',4903967,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257515',4903968,'2863','435',713910.64,715871.49,1960.85,362757.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257515',4903969,'2864','435',546444.11,547831.16,1387.05,256604.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257515',4903970,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257515',4903971,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257515',4903972,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257515',4903973,'2868','435',291957.25,293302.11,1344.86,248799.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257515',4903974,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257515',4903975,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257515',4903976,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257515',4903977,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257515',4903978,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257515',4903979,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257515',4903980,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257515',4903981,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257515',4903982,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257515',4903983,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257515',4903984,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257515',4903985,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257516',4903986,'2863','435',715871.49,717346.91,1475.42,272952.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257516',4903987,'2864','435',547831.16,549571.05,1739.89,321879.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257516',4903988,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257516',4903989,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257516',4903990,'2867','435',157129.79,157129.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257516',4903991,'2868','435',293302.11,296199.66,2897.55,536046.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257516',4903992,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257516',4903993,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257516',4903994,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257516',4903995,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257516',4903996,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257516',4903997,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257516',4903998,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257516',4903999,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257516',4904000,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257516',4904001,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257516',4904002,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257516',4904003,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257517',4904004,'2863','435',717346.91,718441.89,1094.98,202571.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257517',4904005,'2864','435',549571.05,550285.32,714.27,132139.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257517',4904006,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257517',4904007,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257517',4904008,'2867','435',157129.79,158685.51,1555.72,287808.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','257517',4904009,'2868','435',296199.66,299316.24,3116.58,576567.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','257517',4904010,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257517',4904011,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257517',4904012,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257517',4904013,'2872','435',242030.17,242030.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257517',4904014,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257517',4904015,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257517',4904016,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257517',4904017,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257517',4904018,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257517',4904019,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257517',4904020,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257517',4904021,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257518',4904022,'2863','435',718441.89,719501.89,1060.00,196100.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257518',4904023,'2864','435',550285.32,551403.34,1118.02,206833.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257518',4904024,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257518',4904025,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257518',4904026,'2867','435',158685.51,159836.34,1150.83,212903.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','257518',4904027,'2868','435',299316.24,301029.83,1713.59,317014.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257518',4904028,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257518',4904029,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257518',4904030,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257518',4904031,'2872','435',242030.17,242481.14,450.97,83429.45,0.00,0.00,0.00,0.00,240.00),('5','181','970','257518',4904032,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257518',4904033,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257518',4904034,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257518',4904035,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257518',4904036,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257518',4904037,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257518',4904038,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257518',4904039,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257519',4904040,'2863','435',719501.89,721001.50,1499.61,277427.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257519',4904041,'2864','435',551403.34,552871.06,1467.72,271528.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257519',4904042,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257519',4904043,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257519',4904044,'2867','435',159836.34,160670.44,834.10,154308.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257519',4904045,'2868','435',301029.83,302837.78,1807.95,334470.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257519',4904046,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257519',4904047,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257519',4904048,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257519',4904049,'2872','435',242481.14,242481.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257519',4904050,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257519',4904051,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257519',4904052,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257519',4904053,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257519',4904054,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257519',4904055,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257519',4904056,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257519',4904057,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257520',4904058,'2863','435',721001.50,722916.76,1915.26,354323.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257520',4904059,'2864','435',552871.06,555618.40,2747.34,508257.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257520',4904060,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257520',4904061,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257520',4904062,'2867','435',160670.44,162189.21,1518.77,280972.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257520',4904063,'2868','435',302837.78,303893.94,1056.16,195389.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','257520',4904064,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257520',4904065,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257520',4904066,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257520',4904067,'2872','435',242481.14,242481.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257520',4904068,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257520',4904069,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257520',4904070,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257520',4904071,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257520',4904072,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257520',4904073,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257520',4904074,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257520',4904075,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257521',4904076,'2863','435',722916.76,723935.42,1018.66,188452.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257521',4904077,'2864','435',555618.40,556809.28,1190.88,220312.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257521',4904078,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257521',4904079,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257521',4904080,'2867','435',162189.21,163084.38,895.17,165606.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257521',4904081,'2868','435',303893.94,306050.96,2157.02,399048.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257521',4904082,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257521',4904083,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257521',4904084,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257521',4904085,'2872','435',242481.14,242481.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257521',4904086,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257521',4904087,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257521',4904088,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257521',4904089,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257521',4904090,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257521',4904091,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257521',4904092,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257521',4904093,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257522',4904094,'2863','435',723935.42,724614.22,678.80,125578.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257522',4904095,'2864','435',556809.28,557281.58,472.30,87375.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257522',4904096,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257522',4904097,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257522',4904098,'2867','435',163084.38,163649.04,564.66,104462.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257522',4904099,'2868','435',306050.96,308306.26,2255.30,417230.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257522',4904100,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257522',4904101,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257522',4904102,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257522',4904103,'2872','435',242481.14,242481.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257522',4904104,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257522',4904105,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257522',4904106,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257522',4904107,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257522',4904108,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257522',4904109,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257522',4904110,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257522',4904111,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257523',4904112,'2863','435',724614.22,725652.56,1038.34,192092.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257523',4904113,'2864','435',557281.58,559911.85,2630.27,486599.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257523',4904114,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257523',4904115,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257523',4904116,'2867','435',163649.04,164603.41,954.37,176558.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257523',4904117,'2868','435',308306.26,311308.89,3002.63,555486.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257523',4904118,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257523',4904119,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257523',4904120,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257523',4904121,'2872','435',242481.14,243245.52,764.38,141410.30,0.00,0.00,0.00,0.00,0.00),('5','181','970','257523',4904122,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257523',4904123,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257523',4904124,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257523',4904125,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257523',4904126,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257523',4904127,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257523',4904128,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257523',4904129,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257524',4904130,'2863','435',725652.56,726487.51,834.95,154465.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257524',4904131,'2864','435',559911.85,560933.64,1021.79,189031.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257524',4904132,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257524',4904133,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257524',4904134,'2867','435',164603.41,168025.68,3422.27,633119.95,0.00,0.00,0.00,0.00,0.00),('5','181','968','257524',4904135,'2868','435',311308.89,314485.10,3176.21,587598.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257524',4904136,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257524',4904137,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257524',4904138,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257524',4904139,'2872','435',243245.52,244532.48,1286.96,238087.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257524',4904140,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257524',4904141,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257524',4904142,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257524',4904143,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257524',4904144,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257524',4904145,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257524',4904146,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257524',4904147,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257525',4904148,'2863','435',726487.51,728109.09,1621.58,299992.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257525',4904149,'2864','435',560933.64,561457.64,524.00,96940.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257525',4904150,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257525',4904151,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257525',4904152,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257525',4904153,'2868','435',314485.10,316178.33,1693.23,313247.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257525',4904154,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257525',4904155,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257525',4904156,'2871','435',515148.05,515148.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257525',4904157,'2872','435',244532.48,246487.63,1955.15,361702.75,0.00,0.00,0.00,0.00,0.00),('5','181','970','257525',4904158,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257525',4904159,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257525',4904160,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257525',4904161,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257525',4904162,'2877','436',1468101.30,1468101.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257525',4904163,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257525',4904164,'2910','436',642962.78,642962.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257525',4904165,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257526',4904166,'2863','435',728109.09,729205.15,1096.06,202771.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257526',4904167,'2864','435',561457.64,562139.01,681.37,126053.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257526',4904168,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257526',4904169,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257526',4904170,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257526',4904171,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257526',4904172,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257526',4904173,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257526',4904174,'2871','435',515148.05,517381.77,2233.72,413238.20,0.00,0.00,0.00,0.00,0.00),('5','181','971','257526',4904175,'2872','435',246487.63,249132.39,2644.76,489280.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257526',4904176,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257526',4904177,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257526',4904178,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257526',4904179,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257526',4904180,'2877','436',1468101.30,1473736.59,5635.29,4508232.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257526',4904181,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257526',4904182,'2910','436',642962.78,644698.54,1735.76,1388608.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257526',4904183,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257527',4904184,'2863','435',729205.15,729205.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257527',4904185,'2864','435',562139.01,562139.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257527',4904186,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257527',4904187,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257527',4904188,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257527',4904189,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257527',4904190,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257527',4904191,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257527',4904192,'2871','435',517381.77,520099.24,2717.47,502731.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257527',4904193,'2872','435',249132.39,253219.21,4086.82,756061.70,0.00,0.00,0.00,0.00,0.00),('5','181','970','257527',4904194,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257527',4904195,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257527',4904196,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257527',4904197,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257527',4904198,'2877','436',1473736.59,1477484.09,3747.50,2998000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257527',4904199,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257527',4904200,'2910','436',644698.54,644778.54,80.00,64000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257527',4904201,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257528',4904202,'2863','435',729205.15,729205.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257528',4904203,'2864','435',562139.01,562139.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257528',4904204,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257528',4904205,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257528',4904206,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257528',4904207,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257528',4904208,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257528',4904209,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257528',4904210,'2871','435',520099.24,522988.24,2889.00,534465.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257528',4904211,'2872','435',253219.21,256772.29,3553.08,657319.80,0.00,0.00,0.00,0.00,0.00),('5','181','970','257528',4904212,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257528',4904213,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257528',4904214,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257528',4904215,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257528',4904216,'2877','436',1477484.09,1478777.76,1293.67,1034936.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257528',4904217,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257528',4904218,'2910','436',644778.54,644778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257528',4904219,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257529',4904220,'2863','435',729205.15,729205.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257529',4904221,'2864','435',562139.01,562139.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257529',4904222,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257529',4904223,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257529',4904224,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257529',4904225,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257529',4904226,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257529',4904227,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257529',4904228,'2871','435',522988.24,525404.30,2416.06,446971.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257529',4904229,'2872','435',256772.29,259799.36,3027.07,560007.95,0.00,0.00,0.00,0.00,0.00),('5','181','970','257529',4904230,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257529',4904231,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257529',4904232,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257529',4904233,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257529',4904234,'2877','436',1478777.76,1481867.06,3089.30,2471440.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257529',4904235,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257529',4904236,'2910','436',644778.54,644903.54,125.00,100000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257529',4904237,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257530',4904238,'2863','435',729205.15,729205.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257530',4904239,'2864','435',562139.01,562139.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257530',4904240,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257530',4904241,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257530',4904242,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257530',4904243,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257530',4904244,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257530',4904245,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257530',4904246,'2871','435',525404.30,526712.67,1308.37,242048.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257530',4904247,'2872','435',259799.36,263282.99,3483.63,644471.55,0.00,0.00,0.00,0.00,0.00),('5','181','970','257530',4904248,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257530',4904249,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257530',4904250,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257530',4904251,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257530',4904252,'2877','436',1481867.06,1483830.07,1963.01,1570408.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257530',4904253,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257530',4904254,'2910','436',644903.54,645215.12,311.58,249264.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257530',4904255,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257531',4904256,'2863','435',729205.15,732132.60,2927.45,541578.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257531',4904257,'2864','435',562139.01,564266.85,2127.84,393650.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257531',4904258,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257531',4904259,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257531',4904260,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257531',4904261,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257531',4904262,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257531',4904263,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257531',4904264,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257531',4904265,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257531',4904266,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257531',4904267,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257531',4904268,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257531',4904269,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257531',4904270,'2877','436',1483830.07,1487090.32,3260.25,2608200.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257531',4904271,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257531',4904272,'2910','436',645215.12,645302.02,86.90,69520.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257531',4904273,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257532',4904274,'2863','435',732132.60,734596.49,2463.89,455819.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257532',4904275,'2864','435',564266.85,568414.35,4147.50,767287.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257532',4904276,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257532',4904277,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257532',4904278,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257532',4904279,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257532',4904280,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257532',4904281,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257532',4904282,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257532',4904283,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257532',4904284,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257532',4904285,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257532',4904286,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257532',4904287,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257532',4904288,'2877','436',1487090.32,1491548.66,4458.34,3566672.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257532',4904289,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257532',4904290,'2910','436',645302.02,645613.70,311.68,249344.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257532',4904291,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257533',4904292,'2863','435',734596.49,738490.64,3894.15,720417.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257533',4904293,'2864','435',568414.35,572736.55,4322.20,799607.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257533',4904294,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257533',4904295,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257533',4904296,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257533',4904297,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257533',4904298,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257533',4904299,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257533',4904300,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257533',4904301,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257533',4904302,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257533',4904303,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257533',4904304,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257533',4904305,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257533',4904306,'2877','436',1491548.66,1494356.31,2807.65,2246120.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257533',4904307,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257533',4904308,'2910','436',645613.70,646113.70,500.00,400000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257533',4904309,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257534',4904310,'2863','435',738490.64,743265.47,4774.83,883343.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257534',4904311,'2864','435',572736.55,577545.02,4808.47,889566.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257534',4904312,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257534',4904313,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257534',4904314,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257534',4904315,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257534',4904316,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257534',4904317,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257534',4904318,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257534',4904319,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257534',4904320,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257534',4904321,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257534',4904322,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257534',4904323,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257534',4904324,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257534',4904325,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257534',4904326,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257534',4904327,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257535',4904328,'2863','435',743265.47,746333.48,3068.01,567581.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257535',4904329,'2864','435',577545.02,581917.97,4372.95,808995.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257535',4904330,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257535',4904331,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257535',4904332,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257535',4904333,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257535',4904334,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257535',4904335,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257535',4904336,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257535',4904337,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257535',4904338,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257535',4904339,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257535',4904340,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257535',4904341,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257535',4904342,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257535',4904343,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257535',4904344,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257535',4904345,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257536',4904346,'2863','435',746333.48,747713.17,1379.69,255242.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257536',4904347,'2864','435',581917.97,583115.79,1197.82,221596.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257536',4904348,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257536',4904349,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257536',4904350,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257536',4904351,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257536',4904352,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257536',4904353,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257536',4904354,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257536',4904355,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257536',4904356,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257536',4904357,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257536',4904358,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257536',4904359,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257536',4904360,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257536',4904361,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257536',4904362,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257536',4904363,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257537',4904364,'2863','435',747713.17,747713.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257537',4904365,'2864','435',583115.79,583115.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257537',4904366,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257537',4904367,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257537',4904368,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257537',4904369,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257537',4904370,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257537',4904371,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257537',4904372,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257537',4904373,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257537',4904374,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257537',4904375,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257537',4904376,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257537',4904377,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257537',4904378,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257537',4904379,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257537',4904380,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257537',4904381,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257538',4904382,'2863','435',747713.17,749548.28,1835.11,339495.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257538',4904383,'2864','435',583115.79,584809.44,1693.65,313325.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257538',4904384,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257538',4904385,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257538',4904386,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257538',4904387,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257538',4904388,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257538',4904389,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257538',4904390,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257538',4904391,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257538',4904392,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257538',4904393,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257538',4904394,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257538',4904395,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257538',4904396,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257538',4904397,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257538',4904398,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257538',4904399,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257539',4904400,'2863','435',749548.28,753955.34,4407.06,815306.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257539',4904401,'2864','435',584809.44,589504.66,4695.22,868616.44,0.00,0.00,0.00,0.00,0.00),('5','181','967','257539',4904402,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257539',4904403,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257539',4904404,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257539',4904405,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257539',4904406,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257539',4904407,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257539',4904408,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257539',4904409,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257539',4904410,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257539',4904411,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257539',4904412,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257539',4904413,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257539',4904414,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257539',4904415,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257539',4904416,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257539',4904417,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257540',4904418,'2863','435',753955.34,756462.10,2506.76,463750.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257540',4904419,'2864','435',589504.66,592748.77,3244.11,600160.53,0.00,0.00,0.00,0.00,0.00),('5','181','967','257540',4904420,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257540',4904421,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257540',4904422,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257540',4904423,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257540',4904424,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257540',4904425,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257540',4904426,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257540',4904427,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257540',4904428,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257540',4904429,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257540',4904430,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257540',4904431,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257540',4904432,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257540',4904433,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257540',4904434,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257540',4904435,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257541',4904436,'2863','435',756462.10,759591.05,3128.95,578855.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257541',4904437,'2864','435',592748.77,595553.99,2805.22,518965.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257541',4904438,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257541',4904439,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257541',4904440,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257541',4904441,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257541',4904442,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257541',4904443,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257541',4904444,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257541',4904445,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257541',4904446,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257541',4904447,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257541',4904448,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257541',4904449,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257541',4904450,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257541',4904451,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257541',4904452,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257541',4904453,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257542',4904454,'2863','435',759591.05,762677.74,3086.69,571037.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257542',4904455,'2864','435',595553.99,597831.81,2277.82,421396.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257542',4904456,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257542',4904457,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257542',4904458,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257542',4904459,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257542',4904460,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257542',4904461,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257542',4904462,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257542',4904463,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257542',4904464,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257542',4904465,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257542',4904466,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257542',4904467,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257542',4904468,'2877','436',1494356.31,1494356.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257542',4904469,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257542',4904470,'2910','436',646113.70,646113.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257542',4904471,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257543',4904472,'2863','435',762677.74,764470.96,1793.22,331745.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257543',4904473,'2864','435',597831.81,598630.00,798.19,147665.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257543',4904474,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257543',4904475,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257543',4904476,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257543',4904477,'2868','435',316178.33,316178.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257543',4904478,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257543',4904479,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257543',4904480,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257543',4904481,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257543',4904482,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257543',4904483,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257543',4904484,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257543',4904485,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257543',4904486,'2877','436',1494356.31,1496359.55,2003.24,1602592.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257543',4904487,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257543',4904488,'2910','436',646113.70,646529.96,416.26,333008.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257543',4904489,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257544',4904490,'2863','435',764470.96,767946.39,3475.43,642954.55,0.00,0.00,0.00,0.00,0.00),('5','181','967','257544',4904491,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257544',4904492,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257544',4904493,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257544',4904494,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257544',4904495,'2868','435',316178.33,319514.60,3336.27,617209.76,0.00,0.00,0.00,0.00,0.00),('5','181','969','257544',4904496,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257544',4904497,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257544',4904498,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257544',4904499,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257544',4904500,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257544',4904501,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257544',4904502,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257544',4904503,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257544',4904504,'2877','436',1496359.55,1497952.64,1593.09,1274472.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257544',4904505,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257544',4904506,'2910','436',646529.96,646579.96,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257544',4904507,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257545',4904508,'2863','435',767946.39,771103.90,3157.51,584139.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257545',4904509,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257545',4904510,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257545',4904511,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257545',4904512,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257545',4904513,'2868','435',319514.60,322594.55,3079.95,569790.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257545',4904514,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257545',4904515,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257545',4904516,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257545',4904517,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257545',4904518,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257545',4904519,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257545',4904520,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257545',4904521,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257545',4904522,'2877','436',1497952.64,1500328.04,2375.40,1900320.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257545',4904523,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257545',4904524,'2910','436',646579.96,646579.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257545',4904525,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257546',4904526,'2863','435',771103.90,774002.10,2898.20,536167.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257546',4904527,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257546',4904528,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257546',4904529,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257546',4904530,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257546',4904531,'2868','435',322594.55,325171.23,2576.68,476685.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','257546',4904532,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257546',4904533,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257546',4904534,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257546',4904535,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257546',4904536,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257546',4904537,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257546',4904538,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257546',4904539,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257546',4904540,'2877','436',1500328.04,1502667.85,2339.81,1871848.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257546',4904541,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257546',4904542,'2910','436',646579.96,646579.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257546',4904543,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257547',4904544,'2863','435',774002.10,777344.22,3342.12,618292.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257547',4904545,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257547',4904546,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257547',4904547,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257547',4904548,'2867','435',168025.68,168025.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257547',4904549,'2868','435',325171.23,328210.46,3039.23,562257.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257547',4904550,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257547',4904551,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257547',4904552,'2871','435',526712.67,526712.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257547',4904553,'2872','435',263282.99,263282.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257547',4904554,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257547',4904555,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257547',4904556,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257547',4904557,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257547',4904558,'2877','436',1502667.85,1504996.60,2328.75,1863000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257547',4904559,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257547',4904560,'2910','436',646579.96,647678.97,1099.01,879208.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257547',4904561,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257548',4904562,'2863','435',777344.22,777344.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257548',4904563,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257548',4904564,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257548',4904565,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257548',4904566,'2867','435',168025.68,168555.68,530.00,98050.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257548',4904567,'2868','435',328210.46,328795.15,584.69,108167.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','257548',4904568,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257548',4904569,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257548',4904570,'2871','435',526712.67,528740.52,2027.85,375152.25,0.00,0.00,0.00,0.00,0.00),('5','181','971','257548',4904571,'2872','435',263282.99,265357.90,2074.91,383858.35,0.00,0.00,0.00,0.00,0.00),('5','181','970','257548',4904572,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257548',4904573,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257548',4904574,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257548',4904575,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257548',4904576,'2877','436',1504996.60,1507388.36,2391.76,1913408.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257548',4904577,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257548',4904578,'2910','436',647678.97,648000.61,321.64,257312.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257548',4904579,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257549',4904580,'2863','435',777344.22,777344.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257549',4904581,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257549',4904582,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257549',4904583,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257549',4904584,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257549',4904585,'2868','435',328795.15,328795.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257549',4904586,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257549',4904587,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257549',4904588,'2871','435',528740.52,531280.51,2539.99,469898.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','257549',4904589,'2872','435',265357.90,267307.76,1949.86,360724.10,0.00,0.00,0.00,0.00,0.00),('5','181','970','257549',4904590,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257549',4904591,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257549',4904592,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257549',4904593,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257549',4904594,'2877','436',1507388.36,1510149.60,2761.24,2208992.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257549',4904595,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257549',4904596,'2910','436',648000.61,648813.53,812.92,650336.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257549',4904597,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257550',4904598,'2863','435',777344.22,777344.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257550',4904599,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257550',4904600,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257550',4904601,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257550',4904602,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257550',4904603,'2868','435',328795.15,330201.78,1406.63,260226.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257550',4904604,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257550',4904605,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257550',4904606,'2871','435',531280.51,532858.79,1578.28,291981.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','257550',4904607,'2872','435',267307.76,270602.12,3294.36,609456.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257550',4904608,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257550',4904609,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257550',4904610,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257550',4904611,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257550',4904612,'2877','436',1510149.60,1511597.98,1448.38,1158704.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257550',4904613,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257550',4904614,'2910','436',648813.53,648855.40,41.87,33496.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257550',4904615,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257551',4904616,'2863','435',777344.22,777344.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257551',4904617,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257551',4904618,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257551',4904619,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257551',4904620,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257551',4904621,'2868','435',330201.78,331275.95,1074.17,198721.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','257551',4904622,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257551',4904623,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257551',4904624,'2871','435',532858.79,533621.32,762.53,141068.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257551',4904625,'2872','435',270602.12,272595.62,1993.50,368797.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257551',4904626,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257551',4904627,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257551',4904628,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257551',4904629,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257551',4904630,'2877','436',1511597.98,1513871.99,2274.01,1819208.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257551',4904631,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257551',4904632,'2910','436',648855.40,649146.25,290.85,232680.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257551',4904633,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257552',4904634,'2863','435',777344.22,777344.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257552',4904635,'2864','435',598630.00,598630.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257552',4904636,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257552',4904637,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257552',4904638,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257552',4904639,'2868','435',331275.95,332952.57,1676.62,310174.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257552',4904640,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257552',4904641,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257552',4904642,'2871','435',533621.32,534932.53,1311.21,242573.85,0.00,0.00,0.00,0.00,0.00),('5','181','971','257552',4904643,'2872','435',272595.62,274794.90,2199.28,406866.80,0.00,0.00,0.00,0.00,0.00),('5','181','970','257552',4904644,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257552',4904645,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257552',4904646,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257552',4904647,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257552',4904648,'2877','436',1513871.99,1518437.76,4565.77,3652616.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257552',4904649,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257552',4904650,'2910','436',649146.25,651458.34,2312.09,1849672.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257552',4904651,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257553',4904652,'2863','435',777344.22,777900.39,556.17,102891.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257553',4904653,'2864','435',598630.00,599181.94,551.94,102108.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257553',4904654,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257553',4904655,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257553',4904656,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257553',4904657,'2868','435',332952.57,334265.89,1313.32,242964.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257553',4904658,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257553',4904659,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257553',4904660,'2871','435',534932.53,536426.80,1494.27,276439.95,0.00,0.00,0.00,0.00,0.00),('5','181','971','257553',4904661,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257553',4904662,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257553',4904663,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257553',4904664,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257553',4904665,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257553',4904666,'2877','436',1518437.76,1520158.43,1720.67,1376536.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257553',4904667,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257553',4904668,'2910','436',651458.34,653737.10,2278.76,1823008.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257553',4904669,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257554',4904670,'2863','435',777900.39,779557.41,1657.02,306548.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257554',4904671,'2864','435',599181.94,600279.15,1097.21,202983.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257554',4904672,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257554',4904673,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257554',4904674,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257554',4904675,'2868','435',334265.89,335365.42,1099.53,203413.05,0.00,0.00,0.00,0.00,0.00),('5','181','969','257554',4904676,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257554',4904677,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257554',4904678,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257554',4904679,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257554',4904680,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257554',4904681,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257554',4904682,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257554',4904683,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257554',4904684,'2877','436',1520158.43,1524005.73,3847.30,3077842.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257554',4904685,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257554',4904686,'2910','436',653737.10,655923.58,2186.48,1749184.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257554',4904687,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257555',4904688,'2863','435',779557.41,780712.67,1155.26,213723.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257555',4904689,'2864','435',600279.15,601406.28,1127.13,208519.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257555',4904690,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257555',4904691,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257555',4904692,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257555',4904693,'2868','435',335365.42,337002.07,1636.65,302780.25,0.00,0.00,0.00,0.00,0.00),('5','181','969','257555',4904694,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257555',4904695,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257555',4904696,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257555',4904697,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257555',4904698,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257555',4904699,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257555',4904700,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257555',4904701,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257555',4904702,'2877','436',1524005.73,1526670.89,2665.16,2132128.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257555',4904703,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257555',4904704,'2910','436',655923.58,659022.32,3098.74,2478992.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257555',4904705,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257556',4904706,'2863','435',780712.67,782477.73,1765.06,326536.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257556',4904707,'2864','435',601406.28,601930.53,524.25,96986.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257556',4904708,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257556',4904709,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257556',4904710,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257556',4904711,'2868','435',337002.07,338213.29,1211.22,224075.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257556',4904712,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257556',4904713,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257556',4904714,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257556',4904715,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257556',4904716,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257556',4904717,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257556',4904718,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257556',4904719,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257556',4904720,'2877','436',1526670.89,1530639.34,3968.45,3174763.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257556',4904721,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257556',4904722,'2910','436',659022.32,661952.32,2930.00,2344000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257556',4904723,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257557',4904724,'2863','435',782477.73,783824.10,1346.37,249078.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257557',4904725,'2864','435',601930.53,603060.63,1130.10,209068.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257557',4904726,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257557',4904727,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257557',4904728,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257557',4904729,'2868','435',338213.29,339291.97,1078.68,199555.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','257557',4904730,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257557',4904731,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257557',4904732,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257557',4904733,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257557',4904734,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257557',4904735,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257557',4904736,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257557',4904737,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257557',4904738,'2877','436',1530639.34,1532119.97,1480.63,1184504.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257557',4904739,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257557',4904740,'2910','436',661952.32,662356.74,404.42,323536.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257557',4904741,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257558',4904742,'2863','435',783824.10,784316.98,492.88,91182.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257558',4904743,'2864','435',603060.63,603971.65,911.02,168538.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257558',4904744,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257558',4904745,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257558',4904746,'2867','435',168555.68,168555.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257558',4904747,'2868','435',339291.97,339350.38,58.41,10805.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257558',4904748,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257558',4904749,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257558',4904750,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257558',4904751,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257558',4904752,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257558',4904753,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257558',4904754,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257558',4904755,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257558',4904756,'2877','436',1532119.97,1533552.47,1432.50,1146000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257558',4904757,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257558',4904758,'2910','436',662356.74,663077.24,720.50,576400.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257558',4904759,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257559',4904760,'2863','435',784316.98,785450.73,1133.75,209743.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257559',4904761,'2864','435',603971.65,604962.91,991.26,183383.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257559',4904762,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257559',4904763,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257559',4904764,'2867','435',168555.68,168857.81,302.13,55894.05,0.00,0.00,0.00,0.00,0.00),('5','181','968','257559',4904765,'2868','435',339350.38,339930.30,579.92,107285.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257559',4904766,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257559',4904767,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257559',4904768,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257559',4904769,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257559',4904770,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257559',4904771,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257559',4904772,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257559',4904773,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257559',4904774,'2877','436',1533552.47,1535457.63,1905.16,1524128.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257559',4904775,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257559',4904776,'2910','436',663077.24,663477.24,400.00,320000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257559',4904777,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257560',4904778,'2863','435',785450.73,785923.92,473.19,87540.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257560',4904779,'2864','435',604962.91,606088.15,1125.24,208169.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257560',4904780,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257560',4904781,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257560',4904782,'2867','435',168857.81,169686.21,828.40,153254.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257560',4904783,'2868','435',339930.30,340697.18,766.88,141872.80,0.00,0.00,0.00,0.00,0.00),('5','181','969','257560',4904784,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257560',4904785,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257560',4904786,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257560',4904787,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257560',4904788,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257560',4904789,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257560',4904790,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257560',4904791,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257560',4904792,'2877','436',1535457.63,1535958.25,500.62,400496.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257560',4904793,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257560',4904794,'2910','436',663477.24,664078.11,600.87,480696.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257560',4904795,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257561',4904796,'2863','435',785923.92,787613.82,1689.90,312631.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257561',4904797,'2864','435',606088.15,606739.17,651.02,120437.96,0.00,0.00,0.00,0.00,0.00),('5','181','967','257561',4904798,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257561',4904799,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257561',4904800,'2867','435',169686.21,169686.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257561',4904801,'2868','435',340697.18,341578.02,880.84,162955.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','257561',4904802,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257561',4904803,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257561',4904804,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257561',4904805,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257561',4904806,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257561',4904807,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257561',4904808,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257561',4904809,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257561',4904810,'2877','436',1535958.25,1538473.25,2515.00,2012000.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257561',4904811,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257561',4904812,'2910','436',664078.11,667178.61,3100.50,2480400.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257561',4904813,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257562',4904814,'2863','435',787613.82,789697.00,2083.18,385388.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257562',4904815,'2864','435',606739.17,608596.41,1857.24,343589.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257562',4904816,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257562',4904817,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257562',4904818,'2867','435',169686.21,169686.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257562',4904819,'2868','435',341578.02,341578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257562',4904820,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257562',4904821,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257562',4904822,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257562',4904823,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257562',4904824,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257562',4904825,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257562',4904826,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257562',4904827,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257562',4904828,'2877','436',1538473.25,1539693.12,1219.87,975896.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257562',4904829,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257562',4904830,'2910','436',667178.61,667687.36,508.75,407000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257562',4904831,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257563',4904832,'2863','435',789697.00,791335.30,1638.30,303085.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257563',4904833,'2864','435',608596.41,610388.89,1792.48,331608.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257563',4904834,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257563',4904835,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257563',4904836,'2867','435',169686.21,169686.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257563',4904837,'2868','435',341578.02,341578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257563',4904838,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257563',4904839,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257563',4904840,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257563',4904841,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257563',4904842,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257563',4904843,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257563',4904844,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257563',4904845,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257563',4904846,'2877','436',1539693.12,1540682.59,989.47,791576.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257563',4904847,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257563',4904848,'2910','436',667687.36,667787.36,100.00,80000.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257563',4904849,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257564',4904850,'2863','435',791335.30,791553.20,217.90,40311.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257564',4904851,'2864','435',610388.89,610993.51,604.62,111854.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257564',4904852,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257564',4904853,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257564',4904854,'2867','435',169686.21,169838.20,151.99,28118.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','257564',4904855,'2868','435',341578.02,341755.71,177.69,32872.65,0.00,0.00,0.00,0.00,0.00),('5','181','969','257564',4904856,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257564',4904857,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257564',4904858,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257564',4904859,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257564',4904860,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257564',4904861,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257564',4904862,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257564',4904863,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257564',4904864,'2877','436',1540682.59,1542498.85,1816.26,1453008.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257564',4904865,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257564',4904866,'2910','436',667787.36,668408.23,620.87,496698.40,0.00,0.00,0.00,0.00,0.00),('5','181','973','257564',4904867,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257565',4904868,'2863','435',791553.20,792478.06,924.86,171099.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257565',4904869,'2864','435',610993.51,611283.40,289.89,53629.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257565',4904870,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257565',4904871,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257565',4904872,'2867','435',169838.20,170639.42,801.22,148225.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257565',4904873,'2868','435',341755.71,341755.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257565',4904874,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257565',4904875,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257565',4904876,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257565',4904877,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257565',4904878,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257565',4904879,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257565',4904880,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257565',4904881,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257565',4904882,'2877','436',1542498.85,1543477.14,978.29,782632.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257565',4904883,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257565',4904884,'2910','436',668408.23,668982.82,574.59,459672.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257565',4904885,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257566',4904886,'2863','435',792478.06,793862.14,1384.08,256054.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257566',4904887,'2864','435',611283.40,612977.49,1694.09,313406.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257566',4904888,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257566',4904889,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257566',4904890,'2867','435',170639.42,171200.19,560.77,103742.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257566',4904891,'2868','435',341755.71,341755.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257566',4904892,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257566',4904893,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257566',4904894,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257566',4904895,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257566',4904896,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257566',4904897,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257566',4904898,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257566',4904899,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257566',4904900,'2877','436',1543477.14,1544811.36,1334.22,1067376.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257566',4904901,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257566',4904902,'2910','436',668982.82,669250.14,267.32,213856.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257566',4904903,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257567',4904904,'2863','435',793862.14,794046.39,184.25,34086.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257567',4904905,'2864','435',612977.49,613486.60,509.11,94185.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257567',4904906,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257567',4904907,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257567',4904908,'2867','435',171200.19,172980.37,1780.18,329333.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','257567',4904909,'2868','435',341755.71,342731.72,976.01,180561.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257567',4904910,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257567',4904911,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257567',4904912,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257567',4904913,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257567',4904914,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257567',4904915,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257567',4904916,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257567',4904917,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257567',4904918,'2877','436',1544811.36,1545134.24,322.88,258304.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257567',4904919,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257567',4904920,'2910','436',669250.14,669275.42,25.28,20224.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257567',4904921,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257568',4904922,'2863','435',794046.39,795774.83,1728.44,319761.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257568',4904923,'2864','435',613486.60,614686.94,1200.34,222062.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257568',4904924,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257568',4904925,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257568',4904926,'2867','435',172980.37,173615.67,635.30,117530.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257568',4904927,'2868','435',342731.72,342731.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257568',4904928,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257568',4904929,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257568',4904930,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257568',4904931,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257568',4904932,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257568',4904933,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257568',4904934,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257568',4904935,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257568',4904936,'2877','436',1545134.24,1547028.35,1894.11,1515288.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257568',4904937,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257568',4904938,'2910','436',669275.42,669775.14,499.72,399776.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257568',4904939,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257569',4904940,'2863','435',795774.83,795774.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257569',4904941,'2864','435',614686.94,614686.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257569',4904942,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257569',4904943,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257569',4904944,'2867','435',173615.67,173615.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257569',4904945,'2868','435',342731.72,342731.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257569',4904946,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257569',4904947,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257569',4904948,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257569',4904949,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257569',4904950,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257569',4904951,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257569',4904952,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257569',4904953,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257569',4904954,'2877','436',1547028.35,1547028.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257569',4904955,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257569',4904956,'2910','436',669775.14,669775.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257569',4904957,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257570',4904958,'2863','435',795774.83,797054.83,1280.00,236800.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257570',4904959,'2864','435',614686.94,615593.00,906.06,167621.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257570',4904960,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257570',4904961,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257570',4904962,'2867','435',173615.67,174461.97,846.30,156565.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257570',4904963,'2868','435',342731.72,343759.15,1027.43,190074.55,0.00,0.00,0.00,0.00,0.00),('5','181','969','257570',4904964,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257570',4904965,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257570',4904966,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257570',4904967,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257570',4904968,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257570',4904969,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257570',4904970,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257570',4904971,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257570',4904972,'2877','436',1547028.35,1548400.16,1371.81,1070011.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257570',4904973,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257570',4904974,'2910','436',669775.14,670727.23,952.09,742630.20,0.00,0.00,0.00,0.00,0.00),('5','181','973','257570',4904975,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257571',4904976,'2863','435',797054.83,797054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257571',4904977,'2864','435',615593.00,617484.31,1891.31,349892.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257571',4904978,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257571',4904979,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257571',4904980,'2867','435',174461.97,175358.95,896.98,165941.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','257571',4904981,'2868','435',343759.15,344982.10,1222.95,226245.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257571',4904982,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257571',4904983,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257571',4904984,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257571',4904985,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257571',4904986,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257571',4904987,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257571',4904988,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257571',4904989,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257571',4904990,'2877','436',1548400.16,1549038.36,638.20,497796.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257571',4904991,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257571',4904992,'2910','436',670727.23,671253.52,526.29,410506.20,0.00,0.00,0.00,0.00,0.00),('5','181','973','257571',4904993,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257572',4904994,'2863','435',797054.83,797378.30,323.47,59841.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257572',4904995,'2864','435',617484.31,618481.32,997.01,184446.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257572',4904996,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257572',4904997,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257572',4904998,'2867','435',175358.95,175665.14,306.19,56645.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','257572',4904999,'2868','435',344982.10,345415.87,433.77,80247.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','257572',4905000,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257572',4905001,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257572',4905002,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257572',4905003,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257572',4905004,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257572',4905005,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257572',4905006,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257572',4905007,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257572',4905008,'2877','436',1549038.36,1550206.81,1168.45,911391.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257572',4905009,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257572',4905010,'2910','436',671253.52,672115.07,861.55,672009.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257572',4905011,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257573',4905012,'2863','435',797378.30,798481.67,1103.37,204123.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257573',4905013,'2864','435',618481.32,619359.24,877.92,162415.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257573',4905014,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257573',4905015,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257573',4905016,'2867','435',175665.14,176186.36,521.22,96425.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257573',4905017,'2868','435',345415.87,345982.06,566.19,104745.15,0.00,0.00,0.00,0.00,0.00),('5','181','969','257573',4905018,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257573',4905019,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257573',4905020,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257573',4905021,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257573',4905022,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257573',4905023,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257573',4905024,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257573',4905025,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257573',4905026,'2877','436',1550206.81,1551151.88,945.07,737154.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257573',4905027,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257573',4905028,'2910','436',672115.07,672680.44,565.37,440988.60,0.00,0.00,0.00,0.00,0.00),('5','181','973','257573',4905029,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257574',4905030,'2863','435',798481.67,799810.44,1328.77,245822.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257574',4905031,'2864','435',619359.24,621042.76,1683.52,311451.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257574',4905032,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257574',4905033,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257574',4905034,'2867','435',176186.36,176186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257574',4905035,'2868','435',345982.06,347524.82,1542.76,285410.60,0.00,0.00,0.00,0.00,0.00),('5','181','969','257574',4905036,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257574',4905037,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257574',4905038,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257574',4905039,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257574',4905040,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257574',4905041,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257574',4905042,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257574',4905043,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257574',4905044,'2877','436',1551151.88,1551482.42,330.54,257821.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257574',4905045,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257574',4905046,'2910','436',672680.44,673580.93,900.49,702382.20,0.00,0.00,0.00,0.00,0.00),('5','181','973','257574',4905047,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257575',4905048,'2863','435',799810.44,801037.76,1227.32,227054.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257575',4905049,'2864','435',621042.76,621921.94,879.18,162648.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257575',4905050,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257575',4905051,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257575',4905052,'2867','435',176186.36,177298.28,1111.92,205705.20,0.00,0.00,0.00,0.00,0.00),('5','181','968','257575',4905053,'2868','435',347524.82,348513.77,988.95,182955.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257575',4905054,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257575',4905055,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257575',4905056,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257575',4905057,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257575',4905058,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257575',4905059,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257575',4905060,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257575',4905061,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257575',4905062,'2877','436',1551482.42,1552738.82,1256.40,979992.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257575',4905063,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257575',4905064,'2910','436',673580.93,674925.93,1345.00,1049100.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257575',4905065,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257576',4905066,'2863','435',801037.76,802818.71,1780.95,329475.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257576',4905067,'2864','435',621921.94,622817.67,895.73,165710.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257576',4905068,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257576',4905069,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257576',4905070,'2867','435',177298.28,177298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257576',4905071,'2868','435',348513.77,350091.54,1577.77,291887.45,0.00,0.00,0.00,0.00,0.00),('5','181','969','257576',4905072,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257576',4905073,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257576',4905074,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257576',4905075,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257576',4905076,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257576',4905077,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257576',4905078,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257576',4905079,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257576',4905080,'2877','436',1552738.82,1552784.83,46.01,35887.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257576',4905081,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257576',4905082,'2910','436',674925.93,675044.93,119.00,92820.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257576',4905083,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257577',4905084,'2863','435',802818.71,804624.05,1805.34,333987.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257577',4905085,'2864','435',622817.67,623991.12,1173.45,217088.25,0.00,0.00,0.00,0.00,0.00),('5','181','967','257577',4905086,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257577',4905087,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257577',4905088,'2867','435',177298.28,177298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257577',4905089,'2868','435',350091.54,351386.55,1295.01,239576.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257577',4905090,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257577',4905091,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257577',4905092,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257577',4905093,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257577',4905094,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257577',4905095,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257577',4905096,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257577',4905097,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257577',4905098,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257577',4905099,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257577',4905100,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257577',4905101,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257578',4905102,'2863','435',804624.05,806789.36,2165.31,400582.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257578',4905103,'2864','435',623991.12,625839.34,1848.22,341920.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257578',4905104,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257578',4905105,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257578',4905106,'2867','435',177298.28,177298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257578',4905107,'2868','435',351386.55,351386.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257578',4905108,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257578',4905109,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257578',4905110,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257578',4905111,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257578',4905112,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257578',4905113,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257578',4905114,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257578',4905115,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257578',4905116,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257578',4905117,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257578',4905118,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257578',4905119,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257579',4905120,'2863','435',806789.36,808989.74,2200.38,407070.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257579',4905121,'2864','435',625839.34,627512.73,1673.39,309577.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257579',4905122,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257579',4905123,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257579',4905124,'2867','435',177298.28,177298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257579',4905125,'2868','435',351386.55,351386.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257579',4905126,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257579',4905127,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257579',4905128,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257579',4905129,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257579',4905130,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257579',4905131,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257579',4905132,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257579',4905133,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257579',4905134,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257579',4905135,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257579',4905136,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257579',4905137,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257580',4905138,'2863','435',808989.74,809879.08,889.34,164527.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257580',4905139,'2864','435',627512.73,627781.47,268.74,49716.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257580',4905140,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257580',4905141,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257580',4905142,'2867','435',177298.28,178556.27,1257.99,232728.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','257580',4905143,'2868','435',351386.55,351386.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257580',4905144,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257580',4905145,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257580',4905146,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257580',4905147,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257580',4905148,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257580',4905149,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257580',4905150,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257580',4905151,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257580',4905152,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257580',4905153,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257580',4905154,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257580',4905155,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257581',4905156,'2863','435',809879.08,811645.88,1766.80,326858.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257581',4905157,'2864','435',627781.47,628175.97,394.50,72982.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257581',4905158,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257581',4905159,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257581',4905160,'2867','435',178556.27,179245.13,688.86,127439.10,0.00,0.00,0.00,0.00,0.00),('5','181','968','257581',4905161,'2868','435',351386.55,352490.81,1104.26,204288.10,0.00,0.00,0.00,0.00,0.00),('5','181','969','257581',4905162,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257581',4905163,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257581',4905164,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257581',4905165,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257581',4905166,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257581',4905167,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257581',4905168,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257581',4905169,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257581',4905170,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257581',4905171,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257581',4905172,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257581',4905173,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257582',4905174,'2863','435',811645.88,813053.52,1407.64,260413.40,0.00,0.00,0.00,0.00,0.00),('5','181','967','257582',4905175,'2864','435',628175.97,629077.50,901.53,166783.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257582',4905176,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257582',4905177,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257582',4905178,'2867','435',179245.13,180526.63,1281.50,237077.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257582',4905179,'2868','435',352490.81,352671.45,180.64,33418.40,0.00,0.00,0.00,0.00,0.00),('5','181','969','257582',4905180,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257582',4905181,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257582',4905182,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257582',4905183,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257582',4905184,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257582',4905185,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257582',4905186,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257582',4905187,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257582',4905188,'2877','436',1552784.83,1552784.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257582',4905189,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257582',4905190,'2910','436',675044.93,675044.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257582',4905191,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257583',4905192,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257583',4905193,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257583',4905194,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257583',4905195,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257583',4905196,'2867','435',180526.63,182391.61,1864.98,345021.30,0.00,0.00,0.00,0.00,0.00),('5','181','968','257583',4905197,'2868','435',352671.45,354956.06,2284.61,422652.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257583',4905198,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257583',4905199,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257583',4905200,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257583',4905201,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257583',4905202,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257583',4905203,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257583',4905204,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257583',4905205,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257583',4905206,'2877','436',1552784.83,1553483.59,698.76,545032.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257583',4905207,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257583',4905208,'2910','436',675044.93,675075.60,30.67,23922.60,0.00,0.00,0.00,0.00,0.00),('5','181','973','257583',4905209,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257584',4905210,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257584',4905211,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257584',4905212,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257584',4905213,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257584',4905214,'2867','435',182391.61,184272.22,1880.61,347912.85,0.00,0.00,0.00,0.00,0.00),('5','181','968','257584',4905215,'2868','435',354956.06,356642.81,1686.75,312048.75,0.00,0.00,0.00,0.00,0.00),('5','181','969','257584',4905216,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257584',4905217,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257584',4905218,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257584',4905219,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257584',4905220,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257584',4905221,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257584',4905222,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257584',4905223,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257584',4905224,'2877','436',1553483.59,1553918.94,435.35,354810.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','257584',4905225,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257584',4905226,'2910','436',675075.60,675100.60,25.00,20375.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257584',4905227,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257585',4905228,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257585',4905229,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257585',4905230,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257585',4905231,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257585',4905232,'2867','435',184272.22,186231.10,1958.88,362392.80,0.00,0.00,0.00,0.00,0.00),('5','181','968','257585',4905233,'2868','435',356642.81,358489.11,1846.30,341565.50,0.00,0.00,0.00,0.00,0.00),('5','181','969','257585',4905234,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257585',4905235,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257585',4905236,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257585',4905237,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257585',4905238,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257585',4905239,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257585',4905240,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257585',4905241,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257585',4905242,'2877','436',1553918.94,1554871.69,952.75,776491.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','257585',4905243,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257585',4905244,'2910','436',675100.60,675153.63,53.03,43219.45,0.00,0.00,0.00,0.00,0.00),('5','181','973','257585',4905245,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257586',4905246,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257586',4905247,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257586',4905248,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257586',4905249,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257586',4905250,'2867','435',186231.10,188618.53,2387.43,441674.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','257586',4905251,'2868','435',358489.11,360020.83,1531.72,283368.20,0.00,0.00,0.00,0.00,0.00),('5','181','969','257586',4905252,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257586',4905253,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257586',4905254,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257586',4905255,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257586',4905256,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257586',4905257,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257586',4905258,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257586',4905259,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257586',4905260,'2877','436',1554871.69,1556303.84,1432.15,1167202.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','257586',4905261,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257586',4905262,'2910','436',675153.63,675962.70,809.07,659392.05,0.00,0.00,0.00,0.00,0.00),('5','181','973','257586',4905263,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257587',4905264,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257587',4905265,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257587',4905266,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257587',4905267,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257587',4905268,'2867','435',188618.53,189983.26,1364.73,252475.05,0.00,0.00,0.00,0.00,0.00),('5','181','968','257587',4905269,'2868','435',360020.83,360741.30,720.47,133286.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','257587',4905270,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257587',4905271,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257587',4905272,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257587',4905273,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257587',4905274,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257587',4905275,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257587',4905276,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257587',4905277,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257587',4905278,'2877','436',1556303.84,1557672.00,1368.16,1115050.40,0.00,0.00,0.00,0.00,0.00),('5','181','974','257587',4905279,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257587',4905280,'2910','436',675962.70,676333.03,370.33,301818.95,0.00,0.00,0.00,0.00,0.00),('5','181','973','257587',4905281,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257588',4905282,'2863','435',813053.52,813053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257588',4905283,'2864','435',629077.50,629077.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257588',4905284,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257588',4905285,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257588',4905286,'2867','435',189983.26,192312.36,2329.10,430883.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257588',4905287,'2868','435',360741.30,362710.88,1969.58,364372.30,0.00,0.00,0.00,0.00,0.00),('5','181','969','257588',4905288,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257588',4905289,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257588',4905290,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257588',4905291,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257588',4905292,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257588',4905293,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257588',4905294,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257588',4905295,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257588',4905296,'2877','436',1557672.00,1559753.79,2081.79,1696658.85,0.00,0.00,0.00,0.00,0.00),('5','181','974','257588',4905297,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257588',4905298,'2910','436',676333.03,678566.03,2233.00,1819895.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257588',4905299,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257589',4905300,'2863','435',813053.52,814085.44,1031.92,190905.20,0.00,0.00,0.00,0.00,0.00),('5','181','967','257589',4905301,'2864','435',629077.50,629323.01,245.51,45419.35,0.00,0.00,0.00,0.00,0.00),('5','181','967','257589',4905302,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257589',4905303,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257589',4905304,'2867','435',192312.36,193880.46,1568.10,290098.50,0.00,0.00,0.00,0.00,0.00),('5','181','968','257589',4905305,'2868','435',362710.88,363723.09,1012.21,187258.85,0.00,0.00,0.00,0.00,0.00),('5','181','969','257589',4905306,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257589',4905307,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257589',4905308,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257589',4905309,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257589',4905310,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257589',4905311,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257589',4905312,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257589',4905313,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257589',4905314,'2877','436',1559753.79,1560649.53,895.74,730028.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','257589',4905315,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257589',4905316,'2910','436',678566.03,679987.65,1421.62,1158620.30,0.00,0.00,0.00,0.00,0.00),('5','181','973','257589',4905317,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257590',4905318,'2863','435',814085.44,815938.63,1853.19,342840.15,0.00,0.00,0.00,0.00,0.00),('5','181','967','257590',4905319,'2864','435',629323.01,630630.57,1307.56,241898.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257590',4905320,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257590',4905321,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257590',4905322,'2867','435',193880.46,193880.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257590',4905323,'2868','435',363723.09,364627.71,904.62,167354.70,0.00,0.00,0.00,0.00,0.00),('5','181','969','257590',4905324,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257590',4905325,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257590',4905326,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257590',4905327,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257590',4905328,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257590',4905329,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257590',4905330,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257590',4905331,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257590',4905332,'2877','436',1560649.53,1562717.87,2068.34,1685697.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','257590',4905333,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257590',4905334,'2910','436',679987.65,680306.34,318.69,259732.35,0.00,0.00,0.00,0.00,0.00),('5','181','973','257590',4905335,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257591',4905336,'2863','435',815938.63,817455.44,1516.81,280609.85,0.00,0.00,0.00,0.00,0.00),('5','181','967','257591',4905337,'2864','435',630630.57,632044.97,1414.40,261664.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257591',4905338,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257591',4905339,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257591',4905340,'2867','435',193880.46,194502.43,621.97,115064.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257591',4905341,'2868','435',364627.71,364627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257591',4905342,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257591',4905343,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257591',4905344,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257591',4905345,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257591',4905346,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257591',4905347,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257591',4905348,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257591',4905349,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257591',4905350,'2877','436',1562717.87,1564245.97,1528.10,1245401.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','257591',4905351,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257591',4905352,'2910','436',680306.34,681828.91,1522.57,1240894.55,0.00,0.00,0.00,0.00,0.00),('5','181','973','257591',4905353,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257592',4905354,'2863','435',817455.44,819099.00,1643.56,304058.60,0.00,0.00,0.00,0.00,0.00),('5','181','967','257592',4905355,'2864','435',632044.97,633569.35,1524.38,282010.30,0.00,0.00,0.00,0.00,0.00),('5','181','967','257592',4905356,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257592',4905357,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257592',4905358,'2867','435',194502.43,195695.98,1193.55,220806.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','257592',4905359,'2868','435',364627.71,364627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257592',4905360,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257592',4905361,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257592',4905362,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257592',4905363,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257592',4905364,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257592',4905365,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257592',4905366,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257592',4905367,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257592',4905368,'2877','436',1564245.97,1565938.80,1692.83,1379656.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','257592',4905369,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257592',4905370,'2910','436',681828.91,687722.72,5893.81,4803455.15,0.00,0.00,0.00,0.00,0.00),('5','181','973','257592',4905371,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257593',4905372,'2863','435',819099.00,820094.09,995.09,184091.65,0.00,0.00,0.00,0.00,0.00),('5','181','967','257593',4905373,'2864','435',633569.35,634272.10,702.75,130008.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257593',4905374,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257593',4905375,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257593',4905376,'2867','435',195695.98,195695.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257593',4905377,'2868','435',364627.71,364627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257593',4905378,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257593',4905379,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257593',4905380,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257593',4905381,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257593',4905382,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257593',4905383,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257593',4905384,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257593',4905385,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257593',4905386,'2877','436',1565938.80,1566954.74,1015.94,827991.10,0.00,0.00,0.00,0.00,0.00),('5','181','974','257593',4905387,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257593',4905388,'2910','436',687722.72,688183.73,461.01,375723.15,0.00,0.00,0.00,0.00,0.00),('5','181','973','257593',4905389,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257594',4905390,'2863','435',820094.09,821114.84,1020.75,188838.75,0.00,0.00,0.00,0.00,0.00),('5','181','967','257594',4905391,'2864','435',634272.10,634951.00,678.90,125596.50,0.00,0.00,0.00,0.00,0.00),('5','181','967','257594',4905392,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257594',4905393,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257594',4905394,'2867','435',195695.98,195695.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257594',4905395,'2868','435',364627.71,364627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257594',4905396,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257594',4905397,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257594',4905398,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257594',4905399,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257594',4905400,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257594',4905401,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257594',4905402,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257594',4905403,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257594',4905404,'2877','436',1566954.74,1567961.25,1006.51,820305.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257594',4905405,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257594',4905406,'2910','436',688183.73,688442.72,258.99,211076.85,0.00,0.00,0.00,0.00,0.00),('5','181','973','257594',4905407,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257595',4905408,'2863','435',821114.84,822318.97,1204.13,222764.05,0.00,0.00,0.00,0.00,0.00),('5','181','967','257595',4905409,'2864','435',634951.00,636048.22,1097.22,202985.70,0.00,0.00,0.00,0.00,0.00),('5','181','967','257595',4905410,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257595',4905411,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257595',4905412,'2867','435',195695.98,196033.81,337.83,62498.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','257595',4905413,'2868','435',364627.71,364627.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257595',4905414,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257595',4905415,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257595',4905416,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257595',4905417,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257595',4905418,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257595',4905419,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257595',4905420,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257595',4905421,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257595',4905422,'2877','436',1567961.25,1570132.20,2170.95,1769324.25,0.00,0.00,0.00,0.00,0.00),('5','181','974','257595',4905423,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257595',4905424,'2910','436',688442.72,693393.23,4950.51,4034665.65,0.00,0.00,0.00,0.00,0.00),('5','181','973','257595',4905425,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257596',4905426,'2863','435',822318.97,823818.43,1499.46,277400.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257596',4905427,'2864','435',636048.22,637186.10,1137.88,210507.80,0.00,0.00,0.00,0.00,0.00),('5','181','967','257596',4905428,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257596',4905429,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257596',4905430,'2867','435',196033.81,196628.05,594.24,109934.40,0.00,0.00,0.00,0.00,0.00),('5','181','968','257596',4905431,'2868','435',364627.71,366046.02,1418.31,262387.35,0.00,0.00,0.00,0.00,0.00),('5','181','969','257596',4905432,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257596',4905433,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257596',4905434,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257596',4905435,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257596',4905436,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257596',4905437,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257596',4905438,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257596',4905439,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257596',4905440,'2877','436',1570132.20,1572198.88,2066.68,1684344.20,0.00,0.00,0.00,0.00,0.00),('5','181','974','257596',4905441,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257596',4905442,'2910','436',693393.23,695606.17,2212.94,1803546.10,0.00,0.00,0.00,0.00,0.00),('5','181','973','257596',4905443,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257597',4905444,'2863','435',823818.43,824906.10,1087.67,201218.95,0.00,0.00,0.00,0.00,0.00),('5','181','967','257597',4905445,'2864','435',637186.10,638016.96,830.86,153709.10,0.00,0.00,0.00,0.00,0.00),('5','181','967','257597',4905446,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257597',4905447,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257597',4905448,'2867','435',196628.05,197723.84,1095.79,202721.15,0.00,0.00,0.00,0.00,0.00),('5','181','968','257597',4905449,'2868','435',366046.02,366959.49,913.47,168991.95,0.00,0.00,0.00,0.00,0.00),('5','181','969','257597',4905450,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257597',4905451,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257597',4905452,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257597',4905453,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257597',4905454,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257597',4905455,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257597',4905456,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257597',4905457,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257597',4905458,'2877','436',1572198.88,1572654.54,455.66,371362.90,0.00,0.00,0.00,0.00,0.00),('5','181','974','257597',4905459,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257597',4905460,'2910','436',695606.17,696479.75,873.58,711967.70,0.00,0.00,0.00,0.00,0.00),('5','181','973','257597',4905461,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257598',4905462,'2863','435',824906.10,827231.47,2325.37,430193.45,0.00,0.00,0.00,0.00,0.00),('5','181','967','257598',4905463,'2864','435',638016.96,640082.76,2065.80,382173.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257598',4905464,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257598',4905465,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257598',4905466,'2867','435',197723.84,198073.59,349.75,64703.75,0.00,0.00,0.00,0.00,0.00),('5','181','968','257598',4905467,'2868','435',366959.49,366959.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257598',4905468,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257598',4905469,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257598',4905470,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257598',4905471,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257598',4905472,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257598',4905473,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257598',4905474,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257598',4905475,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257598',4905476,'2877','436',1572654.54,1576276.45,3621.91,2951856.65,0.00,0.00,0.00,0.00,0.00),('5','181','974','257598',4905477,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257598',4905478,'2910','436',696479.75,699750.36,3270.61,2665547.15,0.00,0.00,0.00,0.00,0.00),('5','181','973','257598',4905479,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257599',4905480,'2863','435',827231.47,827854.01,622.54,115169.90,0.00,0.00,0.00,0.00,0.00),('5','181','967','257599',4905481,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257599',4905482,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257599',4905483,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257599',4905484,'2867','435',198073.59,200893.07,2819.48,521603.80,0.00,0.00,0.00,0.00,0.00),('5','181','968','257599',4905485,'2868','435',366959.49,369650.69,2691.20,497872.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257599',4905486,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257599',4905487,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257599',4905488,'2871','435',536426.80,536426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257599',4905489,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257599',4905490,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257599',4905491,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257599',4905492,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257599',4905493,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257599',4905494,'2877','436',1576276.45,1577347.78,1071.33,873133.95,0.00,0.00,0.00,0.00,0.00),('5','181','974','257599',4905495,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257599',4905496,'2910','436',699750.36,699797.16,46.80,38142.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257599',4905497,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257600',4905498,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257600',4905499,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257600',4905500,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257600',4905501,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257600',4905502,'2867','435',200893.07,205917.89,5024.82,929591.70,0.00,0.00,0.00,0.00,0.00),('5','181','968','257600',4905503,'2868','435',369650.69,374945.29,5294.60,979501.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257600',4905504,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257600',4905505,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257600',4905506,'2871','435',536426.80,538556.14,2129.34,393927.90,0.00,0.00,0.00,0.00,0.00),('5','181','971','257600',4905507,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257600',4905508,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257600',4905509,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257600',4905510,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257600',4905511,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257600',4905512,'2877','436',1577347.78,1579881.68,2533.90,2065128.50,0.00,0.00,0.00,0.00,0.00),('5','181','974','257600',4905513,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257600',4905514,'2910','436',699797.16,700608.15,810.99,660956.85,0.00,0.00,0.00,0.00,0.00),('5','181','973','257600',4905515,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257601',4905516,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257601',4905517,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257601',4905518,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257601',4905519,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257601',4905520,'2867','435',205917.89,214715.06,8797.17,1627476.45,0.00,0.00,0.00,0.00,0.00),('5','181','968','257601',4905521,'2868','435',374945.29,381532.22,6586.93,1218582.05,0.00,0.00,0.00,0.00,0.00),('5','181','969','257601',4905522,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257601',4905523,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257601',4905524,'2871','435',538556.14,538556.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257601',4905525,'2872','435',274794.90,274794.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257601',4905526,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257601',4905527,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257601',4905528,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257601',4905529,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257601',4905530,'2877','436',1579881.68,1580676.80,795.12,648022.80,0.00,0.00,0.00,0.00,0.00),('5','181','974','257601',4905531,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257601',4905532,'2910','436',700608.15,702505.44,1897.29,1546291.35,0.00,0.00,0.00,0.00,0.00),('5','181','973','257601',4905533,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257602',4905534,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257602',4905535,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257602',4905536,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257602',4905537,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257602',4905538,'2867','435',214715.06,215825.69,1110.63,205466.55,0.00,0.00,0.00,0.00,0.00),('5','181','968','257602',4905539,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257602',4905540,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257602',4905541,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257602',4905542,'2871','435',538556.14,541391.33,2835.19,524510.15,0.00,0.00,0.00,0.00,0.00),('5','181','971','257602',4905543,'2872','435',274794.90,275860.15,1065.25,197071.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257602',4905544,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257602',4905545,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257602',4905546,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257602',4905547,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257602',4905548,'2877','436',1580676.80,1580676.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257602',4905549,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257602',4905550,'2910','436',702505.44,707906.96,5401.52,4402238.80,0.00,0.00,0.00,0.00,0.00),('5','181','973','257602',4905551,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257603',4905552,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257603',4905553,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257603',4905554,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257603',4905555,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257603',4905556,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257603',4905557,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257603',4905558,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257603',4905559,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257603',4905560,'2871','435',541391.33,544817.41,3426.08,633824.80,0.00,0.00,0.00,0.00,0.00),('5','181','971','257603',4905561,'2872','435',275860.15,278620.45,2760.30,510655.50,0.00,0.00,0.00,0.00,0.00),('5','181','970','257603',4905562,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257603',4905563,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257603',4905564,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257603',4905565,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257603',4905566,'2877','436',1580676.80,1580676.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257603',4905567,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257603',4905568,'2910','436',707906.96,712277.16,4370.20,3561713.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257603',4905569,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257604',4905570,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257604',4905571,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257604',4905572,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257604',4905573,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257604',4905574,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257604',4905575,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257604',4905576,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257604',4905577,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257604',4905578,'2871','435',544817.41,548136.34,3318.93,614002.05,0.00,0.00,0.00,0.00,0.00),('5','181','971','257604',4905579,'2872','435',278620.45,281860.04,3239.59,599324.15,0.00,0.00,0.00,0.00,0.00),('5','181','970','257604',4905580,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257604',4905581,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257604',4905582,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257604',4905583,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257604',4905584,'2877','436',1580676.80,1580676.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257604',4905585,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257604',4905586,'2910','436',712277.16,720946.59,8669.43,7065585.45,0.00,0.00,0.00,0.00,0.00),('5','181','973','257604',4905587,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257605',4905588,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257605',4905589,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257605',4905590,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257605',4905591,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257605',4905592,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257605',4905593,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257605',4905594,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257605',4905595,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257605',4905596,'2871','435',548136.34,548136.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257605',4905597,'2872','435',281860.04,281860.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','970','257605',4905598,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257605',4905599,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257605',4905600,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257605',4905601,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257605',4905602,'2877','436',1580676.80,1580676.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','974','257605',4905603,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257605',4905604,'2910','436',720946.59,721910.88,964.29,785896.35,0.00,0.00,0.00,0.00,0.00),('5','181','973','257605',4905605,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257606',4905606,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257606',4905607,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257606',4905608,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257606',4905609,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257606',4905610,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257606',4905611,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257606',4905612,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257606',4905613,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257606',4905614,'2871','435',548136.34,550560.31,2423.97,448434.45,0.00,0.00,0.00,0.00,0.00),('5','181','971','257606',4905615,'2872','435',281860.04,284608.73,2748.69,508507.65,0.00,0.00,0.00,0.00,0.00),('5','181','970','257606',4905616,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257606',4905617,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257606',4905618,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257606',4905619,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257606',4905620,'2877','436',1580676.80,1580819.43,142.63,116243.45,0.00,0.00,0.00,0.00,0.00),('5','181','974','257606',4905621,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257606',4905622,'2910','436',721910.88,723883.66,1972.78,1607815.70,0.00,0.00,0.00,0.00,0.00),('5','181','973','257606',4905623,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257607',4905624,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257607',4905625,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257607',4905626,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257607',4905627,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257607',4905628,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257607',4905629,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257607',4905630,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257607',4905631,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257607',4905632,'2871','435',550560.31,553070.00,2509.69,464292.65,0.00,0.00,0.00,0.00,0.00),('5','181','971','257607',4905633,'2872','435',284608.73,287202.78,2594.05,479899.25,0.00,0.00,0.00,0.00,0.00),('5','181','970','257607',4905634,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257607',4905635,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257607',4905636,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257607',4905637,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257607',4905638,'2877','436',1580819.43,1582464.24,1644.81,1365192.30,0.00,0.00,0.00,0.00,0.00),('5','181','974','257607',4905639,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257607',4905640,'2910','436',723883.66,724733.19,849.53,705109.90,0.00,0.00,0.00,0.00,0.00),('5','181','973','257607',4905641,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257608',4905642,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257608',4905643,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257608',4905644,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257608',4905645,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257608',4905646,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257608',4905647,'2868','435',381532.22,381532.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257608',4905648,'2869','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257608',4905649,'2870','435',156.66,156.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','971','257608',4905650,'2871','435',553070.00,554028.66,958.66,177352.10,0.00,0.00,0.00,0.00,0.00),('5','181','971','257608',4905651,'2872','435',287202.78,288357.54,1154.76,213630.60,0.00,0.00,0.00,0.00,0.00),('5','181','970','257608',4905652,'2873','435',33770.19,33770.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','969','257608',4905653,'2874','435',78628.47,78628.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257608',4905654,'2875','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','972','257608',4905655,'2876','435',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257608',4905656,'2877','436',1582464.24,1583005.66,541.42,449378.60,0.00,0.00,0.00,0.00,0.00),('5','181','974','257608',4905657,'2879','437',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','973','257608',4905658,'2910','436',724733.19,725490.40,757.21,628484.30,0.00,0.00,0.00,0.00,0.00),('5','181','973','257608',4905659,'2911','436',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257609',4905660,'2863','435',827854.01,827854.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257609',4905661,'2864','435',640082.76,640082.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257609',4905662,'2865','435',88088.85,88088.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','967','257609',4905663,'2866','435',13434.85,13434.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','181','968','257609',4905664,'2867','435',215825.69,215825.69,0.00,0.00,0.00,0.00,0.00,0.00