-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_175
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_175`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_175` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_175`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4078 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3182,4018,'',0,'20','5','175','SALES','','2021-02-22 21:49:40',5,0.00,0.00,'','597','2021-02-22 21:49:40','597',0,1),(3183,3020,'',0,'6.1','5','175','CASH','','2021-02-22 21:50:03',5,0.00,0.00,'','597','2021-02-22 21:50:03','597',0,1),(3184,4003,'',0,'22','5','175','PURCHASES','','2021-02-22 21:50:44',5,0.00,0.00,'','597','2021-02-22 21:50:44','597',0,1),(3185,30154,'',0,'24','5','175','SALARIES & WAGES','','2021-02-22 21:51:32',5,0.00,0.00,'','597','2021-02-22 21:51:32','597',0,1),(3186,30155,'',0,'24','5','175','PURCHASES','','2021-02-22 21:51:57',5,0.00,0.00,'','597','2021-02-22 21:51:57','597',0,1),(3235,4022,'',0,'2','5','175','ZENITH BANK-1011555093','','2021-03-06 01:30:23',5,0.00,0.00,'','600','2021-03-06 01:30:23','600',0,1),(4075,4055,'',0,'2','5','175','UBA-1024746828-','','2022-01-12 10:41:20',5,0.00,0.00,'','600','2022-01-12 10:41:20','600',0,0),(4076,4056,'',0,'2','5','175','JA\'IZ-0010037957','','2022-03-02 19:11:43',5,0.00,0.00,'','600','2022-03-02 19:11:43','600',0,0),(4077,2000,'',0,'6','5','175','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:36:41',5,0.00,0.00,'','600','2023-02-06 10:36:41','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','175',16907,'908',2182.97,2600.00,'2021-10-26','','2021-10-26 05:19:15','597','597',2021,'597','2021-10-26 05:19:15',5),('5','175',16908,'908',2600.00,2200.00,'2021-10-26','','2021-10-26 05:20:55','597','597',2021,'597','2021-10-26 05:20:55',5),('5','175',18042,'908',1987.68,300.00,'2021-12-15','','2021-12-15 07:46:45','597','597',2021,'597','2021-12-15 07:46:45',5),('5','175',18043,'908',300.00,2350.00,'2021-12-15','','2021-12-15 07:48:51','597','597',2021,'597','2021-12-15 07:48:51',5),('5','175',18393,'908',5372.16,5500.00,'2022-01-09','','2022-01-09 19:31:13','597','597',2022,'597','2022-01-09 19:31:13',5),('5','175',18502,'910',395.35,200.00,'2022-01-19','','2022-01-19 09:35:21','597','597',2022,'597','2022-01-19 09:35:21',5),('5','175',18521,'908',7156.04,7500.00,'2022-01-21','','2022-01-21 15:52:37','597','597',2022,'597','2022-01-21 15:52:37',5),('5','175',18522,'908',7500.00,7300.00,'2022-01-21','','2022-01-21 15:54:49','597','597',2022,'597','2022-01-21 15:54:49',5),('5','175',18523,'909',1324.00,400.00,'2022-02-17','','2022-02-17 10:23:36','600','600',2022,'600','2022-02-17 10:23:36',5),('5','175',18524,'908',2145.25,2500.00,'2022-03-01','','2022-03-01 07:24:55','597','597',2022,'597','2022-03-01 07:24:55',5),('5','175',18525,'909',400.00,100.00,'2022-03-04','Available Stock','2022-03-05 08:57:25','597','597',2022,'597','2022-03-05 08:57:25',5),('5','175',18526,'908',1071.49,1250.00,'2022-03-18','Available Stock','2022-03-18 19:36:12','597','597',2022,'597','2022-03-18 19:36:12',5),('5','175',18527,'908',1602.48,1750.00,'2022-05-01','Available Stock','2022-05-10 14:20:19','597','597',2022,'597','2022-05-10 14:20:19',5),('5','175',18528,'910',200.00,250.00,'2022-05-20','Available Stock','2022-05-20 22:06:47','597','597',2022,'597','2022-05-20 22:06:47',5),('5','175',18529,'908',2023.94,2300.00,'2022-09-15','Available Stock','2022-09-15 21:10:30','597','597',2022,'597','2022-09-15 21:10:30',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2694 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','175','908',2689,'5','PMS PUMP 3',1202987.00,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','175','908',2690,'5','PMS PUMP 4',1044816.43,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','175','909',2691,'5','PMS PUMP 1',448217.02,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-04 18:37:20','600'),('5','175','909',2692,'5','PMS PUMP 2',353863.92,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-04 18:38:07','600'),('5','175','910',2693,'5','AGO PUMP',420250.18,'AGO DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257812 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','175',181515,'AFTERNOON','2021-02-27','2021-02-27 00:00:00',NULL,'597',0.00,0.00,'597','2021-02-27 20:42:46','597','2021-02-27 20:45:36',10,0),('5','175',181546,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'597',0.00,0.00,'597','2021-02-28 18:42:15','597','2021-02-28 18:44:52',10,0),('5','175',181713,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'597',0.00,576265.00,'597','2021-03-01 19:08:45','597','2021-03-01 19:09:55',10,0),('5','175',182007,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'597',0.00,272470.00,'597','2021-03-02 19:02:12','597','2021-03-02 19:02:56',10,0),('5','175',182143,'DAILY SHIFT','2021-03-03','2021-03-03 00:00:00',NULL,'597',0.00,51922.50,'597','2021-03-03 16:01:00','597','2021-03-03 16:01:40',10,0),('5','175',182682,'DAILY SHIFT','2021-03-06','2021-03-06 00:00:00',NULL,'597',416602.50,416602.50,'597','2021-03-06 19:50:52','606','2021-03-07 09:23:13',10,0),('5','175',182884,'DAILY SHIFT','2021-03-07','2021-03-07 00:00:00',NULL,'597',257885.00,1110100.67,'597','2021-03-07 19:47:38','606','2021-03-08 06:44:26',10,0),('5','175',183000,'DAILY SHIFT','2021-03-08','2021-03-08 00:00:00',NULL,'597',2006800.68,2019952.83,'597','2021-03-08 19:35:42','606','2021-03-09 04:29:16',10,0),('5','175',183231,'DAILY SHIFT','2021-03-09','2021-03-09 00:00:00',NULL,'597',2438114.46,2457042.06,'597','2021-03-09 18:58:54','606','2021-03-09 19:23:30',10,0),('5','175',183433,'DAILY SHIFT','2021-03-10','2021-03-10 00:00:00',NULL,'597',2481983.13,2512779.18,'597','2021-03-10 22:29:50','606','2021-03-11 07:16:07',10,0),('5','175',183676,'DAILY SHIFT','2021-03-11','2021-03-11 00:00:00',NULL,'597',2013118.08,2020123.08,'597','2021-03-11 18:48:49','606','2021-03-11 21:31:09',10,0),('5','175',183972,'DAILY SHIFT','2021-03-12','2021-03-12 00:00:00',NULL,'597',1718135.85,1727835.20,'597','2021-03-12 20:50:03','606','2021-03-13 10:05:47',10,0),('5','175',184122,'DAILY SHIFT','2021-03-13','2021-03-13 00:00:00',NULL,'597',382352.50,389999.55,'597','2021-03-13 19:15:38','606','2021-03-14 08:06:58',10,0),('5','175',184311,'DAILY SHIFT','2021-03-14','2021-03-14 00:00:00',NULL,'597',526390.00,536917.80,'597','2021-03-14 19:08:28','606','2021-03-15 05:53:14',10,0),('5','175',184501,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'597',1672050.74,1672050.74,'597','2021-03-15 13:18:57','606','2021-03-15 14:05:05',10,0),('5','175',184607,'DAILY SHIFT','2021-03-15','2021-03-15 00:00:00',NULL,'597',1703007.39,1706714.91,'597','2021-03-15 19:15:43','606','2021-03-15 22:31:45',10,0),('5','175',184733,'DAILY SHIFT','2021-03-16','2021-03-16 00:00:00',NULL,'597',1979486.67,1967342.58,'597','2021-03-16 18:59:06','606','2021-03-17 06:59:45',10,0),('5','175',184919,'DAILY SHIFT','2021-03-17','2021-03-17 00:00:00',NULL,'597',1715128.38,1715128.38,'597','2021-03-17 17:20:17','606','2021-03-18 06:53:54',10,0),('5','175',185520,'DAILY SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'597',1425097.59,1425097.59,'597','2021-03-20 19:09:24','606','2021-03-20 19:52:53',10,0),('5','175',185675,'DAILY SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'597',1712370.42,1712370.42,'597','2021-03-21 18:56:03','606','2021-03-21 20:07:50',10,0),('5','175',185889,'DAILY SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'597',2371395.72,2371395.72,'597','2021-03-22 19:34:01','606','2021-03-22 20:57:59',10,0),('5','175',186096,'DAILY SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'597',2236312.73,2236312.73,'597','2021-03-23 19:22:55','606','2021-03-24 05:29:53',10,0),('5','175',186347,'DAILY SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'597',2144072.66,2144072.66,'597','2021-03-24 19:09:50','606','2021-03-25 05:27:28',10,0),('5','175',186569,'DAILY SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'597',720456.74,720456.74,'597','2021-03-25 17:48:18','606','2021-03-26 05:37:48',10,0),('5','175',187189,'DAILY SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'597',2113412.36,2113412.36,'597','2021-03-28 19:21:35','606','2021-03-29 06:30:21',10,0),('5','175',187401,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'597',1908382.81,1908382.81,'597','2021-03-29 19:26:11','606','2021-03-30 05:37:48',10,0),('5','175',187635,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'597',2010195.87,2010195.87,'597','2021-03-30 19:15:02','606','2021-03-31 04:08:24',10,0),('5','175',187828,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'597',1318994.37,1318994.37,'597','2021-03-31 20:13:12','606','2021-04-01 04:38:13',10,0),('5','175',188009,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'597',2293556.70,2293556.70,'597','2021-04-01 19:52:31','606','2021-04-02 05:18:14',10,0),('5','175',188265,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'597',2342963.63,2342963.63,'597','2021-04-02 19:35:46','606','2021-04-02 22:39:16',10,0),('5','175',188438,'DAILY SHIFT ','2021-04-03','2021-04-03 00:00:00',NULL,'597',2226032.32,2226032.32,'597','2021-04-03 19:45:11','606','2021-04-04 05:25:38',10,0),('5','175',188621,'DAILY SHIFT ','2021-04-04','2021-04-04 00:00:00',NULL,'597',543226.84,543226.84,'597','2021-04-04 19:17:13','606','2021-04-05 05:19:49',10,0),('5','175',189509,'DAILY SHIFT ','2021-04-08','2021-04-08 00:00:00',NULL,'597',428144.60,428144.60,'597','2021-04-08 20:33:12','606','2021-04-09 04:49:45',10,0),('5','175',189615,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'597',438066.20,438066.20,'597','2021-04-09 19:18:20','606','2021-04-10 05:47:06',10,0),('5','175',189875,'DAILY SHIFT ','2021-04-10','2021-04-10 00:00:00',NULL,'597',573282.85,577576.05,'597','2021-04-10 19:32:47','606','2021-04-11 05:33:28',10,0),('5','175',190074,'DAILY SHIFT ','2021-04-11','2021-04-11 00:00:00',NULL,'597',2520737.85,2520737.85,'597','2021-04-11 19:17:28','606','2021-04-12 05:12:43',10,0),('5','175',190232,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'597',2372432.50,2372432.50,'597','2021-04-12 19:01:46','606','2021-04-13 05:45:14',10,0),('5','175',190438,'DAILY SHIFT ','2021-04-13','2021-04-13 00:00:00',NULL,'597',1895789.65,1895789.65,'597','2021-04-13 19:46:20','606','2021-04-14 02:44:15',10,0),('5','175',190704,'DAILY SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'597',1128609.70,1128609.70,'597','2021-04-14 18:57:21','606','2021-04-15 06:49:55',10,0),('5','175',190921,'DAILY SHIFT ','2021-04-15','2021-04-15 00:00:00',NULL,'597',288786.40,288786.40,'597','2021-04-15 18:42:06','606','2021-04-16 05:07:04',10,0),('5','175',191102,'DAILY SHIFT ','2021-04-16','2021-04-16 00:00:00',NULL,'597',929872.95,929872.95,'597','2021-04-16 19:50:34','606','2021-04-17 05:15:57',10,0),('5','175',191280,'DAILY SHIFT ','2021-04-17','2021-04-17 00:00:00',NULL,'597',2252872.30,2252872.30,'597','2021-04-17 19:03:41','606','2021-04-18 04:43:41',10,0),('5','175',191505,'DAILY SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'597',1938714.85,1938714.85,'597','2021-04-18 18:35:58','606','2021-04-19 03:46:07',10,0),('5','175',191709,'DAILY SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'597',1684423.95,1684423.95,'597','2021-04-19 18:36:19','606','2021-04-20 05:15:23',10,0),('5','175',191947,'DAILY SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'597',757528.20,757528.20,'597','2021-04-20 18:15:14','606','2021-04-21 05:34:42',10,0),('5','175',193209,'DAILY SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'597',550675.30,550675.30,'597','2021-04-26 20:43:01','606','2021-04-27 05:29:19',10,0),('5','175',193408,'DAILY SHIFT ','2021-04-27','2021-04-27 00:00:00',NULL,'597',262249.30,262249.30,'597','2021-04-27 19:19:02','606','2021-04-28 05:32:30',10,0),('5','175',193640,'DAILY SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'597',287845.65,287845.65,'597','2021-04-28 19:53:47','606','2021-04-29 05:13:04',10,0),('5','175',193880,'DAILY SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'597',332299.40,332299.40,'597','2021-04-29 20:02:46','606','2021-04-30 12:56:15',10,0),('5','175',194188,'DAILY SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'597',357654.60,357654.60,'597','2021-04-30 19:46:54','606','2021-05-01 06:15:59',10,0),('5','175',194381,'DAILY SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'597',587950.20,587950.20,'597','2021-05-01 19:30:28','606','2021-05-01 21:10:20',10,0),('5','175',194492,'DAILY SHIFT ','2021-05-02','2021-05-02 00:00:00',NULL,'597',448107.05,448107.05,'597','2021-05-02 20:02:13','606','2021-05-02 23:40:40',10,0),('5','175',194708,'DAILY SHIFT ','2021-05-03','2021-05-03 00:00:00',NULL,'597',1326496.70,1326496.70,'597','2021-05-03 18:17:20','606','2021-05-04 05:30:30',10,0),('5','175',194918,'DAILY SHIFT ','2021-05-04','2021-05-04 00:00:00',NULL,'597',1459846.05,1459846.05,'597','2021-05-04 18:30:43','606','2021-05-05 05:26:44',10,0),('5','175',195287,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'597',1572678.70,1572678.70,'597','2021-05-05 21:38:55','606','2021-05-06 04:53:19',10,0),('5','175',195437,'DAILY SHIFT ','2021-05-06','2021-05-06 00:00:00',NULL,'597',1682226.65,1682226.65,'597','2021-05-06 20:12:02','606','2021-05-06 21:54:47',10,0),('5','175',195543,'DAILY SHIFT ','2021-05-07','2021-05-07 00:00:00',NULL,'597',1437665.25,1437665.25,'597','2021-05-07 21:23:52','606','2021-05-08 06:10:15',10,0),('5','175',195972,'DAILY SHIFT ','2021-05-08','2021-05-08 00:00:00',NULL,'597',814069.65,814069.65,'597','2021-05-08 20:09:28','606','2021-05-09 05:25:53',10,0),('5','175',196071,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'597',211106.95,211106.95,'597','2021-05-09 22:11:46','606','2021-05-10 05:41:52',10,0),('5','175',196336,'DAILY SHIFT ','2021-05-10','2021-05-10 00:00:00',NULL,'597',116170.70,116170.70,'597','2021-05-10 21:38:07','606','2021-05-11 04:16:03',10,0),('5','175',196540,'DAILY SHIFT ','2021-05-11','2021-05-11 00:00:00',NULL,'597',104404.70,104404.70,'597','2021-05-11 21:28:34','606','2021-05-12 09:38:53',10,0),('5','175',196858,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'597',183022.25,183022.25,'597','2021-05-13 04:42:27','606','2021-05-13 05:56:02',10,0),('5','175',196893,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'597',286046.30,286046.30,'597','2021-05-13 20:53:05','606','2021-05-14 06:14:49',10,0),('5','175',197206,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'597',189793.00,189793.00,'597','2021-05-14 20:48:25','606','2021-05-16 17:18:42',10,0),('5','175',197508,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'597',1422263.15,1422263.15,'597','2021-05-17 15:26:21','606','2021-05-17 15:27:28',10,0),('5','175',197760,'DAILY SHIFT ','2021-05-16','2021-05-16 00:00:00',NULL,'597',1079931.75,1079931.75,'597','2021-05-17 15:31:44','606','2021-05-17 15:33:19',10,0),('5','175',197766,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'597',1223592.15,1223592.15,'597','2021-05-17 20:57:53','606','2021-05-18 06:19:11',10,0),('5','175',198096,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'597',1241047.45,1241047.45,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','175',198139,'DAILY SHIFT ','2021-05-18','2021-05-18 00:00:00',NULL,'597',1246660.50,1246660.50,'597','2021-05-19 07:25:23','606','2021-05-19 08:56:28',10,0),('5','175',198260,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'597',1486701.00,1486701.00,'597','2021-05-19 23:14:56','606','2021-05-20 04:49:59',10,0),('5','175',198387,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'597',1389420.90,1389420.90,'597','2021-05-20 21:24:45','606','2021-05-21 05:06:19',10,0),('5','175',198645,'DAILY SHIFT ','2021-05-21','2021-05-21 00:00:00',NULL,'597',1342035.15,1342035.15,'597','2021-05-21 20:25:37','606','2021-05-22 05:25:14',10,0),('5','175',199046,'DAILY SHIFT ','2021-05-22','2021-05-22 00:00:00',NULL,'597',1453500.60,1453500.60,'597','2021-05-23 10:10:56','606','2021-05-23 10:17:04',10,0),('5','175',199056,'DAILY SHIFT ','2021-05-23','2021-05-23 00:00:00',NULL,'597',1080901.80,1080901.80,'597','2021-05-23 19:43:09','606','2021-05-24 04:41:42',10,0),('5','175',199211,'DAILY SHIFT ','2021-05-24','2021-05-24 00:00:00',NULL,'597',1132866.90,1132866.90,'597','2021-05-24 20:15:21','606','2021-05-25 05:01:45',10,0),('5','175',199426,'DAILY SHIFT ','2021-05-25','2021-05-25 00:00:00',NULL,'597',1335368.10,1335368.10,'597','2021-05-25 20:12:52','606','2021-05-26 04:48:21',10,0),('5','175',199675,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'597',1257092.10,1257092.10,'597','2021-05-26 19:58:19','606','2021-05-27 05:09:55',10,0),('5','175',199893,'DAILY SHIFT ','2021-05-27','2021-05-27 00:00:00',NULL,'597',1272689.55,1272689.55,'597','2021-05-27 20:35:03','606','2021-05-28 05:36:12',10,0),('5','175',200106,'DAILY SHIFT ','2021-05-28','2021-05-28 00:00:00',NULL,'597',1144494.45,1144494.45,'597','2021-05-28 20:13:49','606','2021-05-29 06:30:01',10,0),('5','175',200315,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'597',1391130.45,1391130.45,'597','2021-05-29 20:32:34','606','2021-05-30 04:38:20',10,0),('5','175',200506,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'597',1444281.00,1444281.00,'597','2021-05-30 20:17:37','606','2021-05-31 05:16:11',10,0),('5','175',200707,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'597',2205542.85,2205542.85,'597','2021-05-31 20:32:53','606','2021-06-01 05:12:37',10,0),('5','175',200919,'DAILY SHIFT ','2021-06-01','2021-06-01 00:00:00',NULL,'597',1986311.85,1986311.85,'597','2021-06-01 20:30:51','606','2021-06-02 05:24:14',10,0),('5','175',201122,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'597',2492659.80,2492659.80,'597','2021-06-02 20:31:45','606','2021-06-03 05:18:55',10,0),('5','175',201321,'DAILY SHIFT ','2021-06-03','2021-06-03 00:00:00',NULL,'597',2213834.70,2213834.70,'597','2021-06-03 20:58:35','606','2021-06-03 22:25:34',10,0),('5','175',201511,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'597',1463897.55,1463897.55,'597','2021-06-04 20:35:54','606','2021-06-05 05:40:07',10,0),('5','175',201760,'DAILY SHIFT ','2021-06-05','2021-06-05 00:00:00',NULL,'597',1383873.30,1390435.75,'597','2021-06-05 20:29:47','606','2021-06-05 22:32:33',10,0),('5','175',202030,'DAILY SHIFT ','2021-06-06','2021-06-06 00:00:00',NULL,'597',1462191.60,1471474.40,'597','2021-06-06 20:28:42','606','2021-06-07 05:12:56',10,0),('5','175',202240,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'597',1501969.20,1514841.90,'597','2021-06-07 20:39:54','606','2021-06-08 05:21:46',10,0),('5','175',202456,'DAILY SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'597',1230724.55,1230724.55,'597','2021-06-08 20:40:37','606','2021-06-09 01:06:28',10,0),('5','175',202655,'DAILY SHIFT ','2021-06-09','2021-06-09 00:00:00',NULL,'597',1336827.25,1336827.25,'597','2021-06-09 20:28:51','606','2021-06-10 05:43:30',10,0),('5','175',202857,'DAILY SHIFT ','2021-06-10','2021-06-10 00:00:00',NULL,'597',1133851.95,1133851.95,'597','2021-06-10 20:42:02','606','2021-06-11 05:48:37',10,0),('5','175',203124,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'597',839950.65,839950.65,'597','2021-06-11 20:30:28','606','2021-06-12 04:43:35',10,0),('5','175',203322,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'597',716278.20,716278.20,'597','2021-06-12 20:06:10','606','2021-06-13 05:03:22',10,0),('5','175',203528,'DAILY SHIFT ','2021-06-13','2021-06-13 00:00:00',NULL,'597',688520.25,688520.25,'597','2021-06-13 20:18:17','606','2021-06-14 06:14:12',10,0),('5','175',203737,'DAILY SHIFT ','2021-06-14','2021-06-14 00:00:00',NULL,'597',793191.30,793191.30,'597','2021-06-14 20:48:38','606','2021-06-15 05:02:47',10,0),('5','175',203973,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'597',824080.95,824080.95,'597','2021-06-16 05:51:08','606','2021-06-16 06:10:54',10,0),('5','175',204191,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'597',747088.65,747088.65,'597','2021-06-16 20:48:41','606','2021-06-17 05:59:51',10,0),('5','175',204404,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'597',672114.30,672114.30,'597','2021-06-17 20:29:20','606','2021-06-18 05:42:00',10,0),('5','175',204626,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'597',678216.00,678216.00,'597','2021-06-18 20:45:11','606','2021-06-19 05:54:44',10,0),('5','175',204842,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'597',685400.10,685400.10,'597','2021-06-19 21:18:13','606','2021-06-19 21:55:57',10,0),('5','175',205055,'DAILY SHIFT ','2021-06-20','2021-06-20 00:00:00',NULL,'597',667623.00,667623.00,'597','2021-06-20 21:46:00','606','2021-06-21 05:26:02',10,0),('5','175',205218,'DAILY SHIFT ','2021-06-21','2021-06-21 00:00:00',NULL,'597',0.00,0.00,'597','2021-06-21 05:56:44','606','2021-06-21 06:05:00',10,0),('5','175',205237,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'597',746384.10,746384.10,'597','2021-06-21 21:51:26','606','2021-06-22 05:12:58',10,0),('5','175',205479,'DAILY SHIFT ','2021-06-22','2021-06-22 00:00:00',NULL,'597',751570.05,751570.05,'597','2021-06-22 21:37:28','606','2021-06-23 05:31:01',10,0),('5','175',205719,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'597',718164.15,718164.15,'597','2021-06-23 21:45:43','606','2021-06-24 05:42:41',10,0),('5','175',206014,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'597',736759.65,736759.65,'597','2021-06-24 21:26:30','606','2021-06-25 05:13:55',10,0),('5','175',206219,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'597',672444.30,672444.30,'597','2021-06-25 22:03:59','606','2021-06-26 06:57:14',10,0),('5','175',206375,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'597',558998.55,558998.55,'597','2021-06-26 21:50:07','606','2021-06-27 05:42:25',10,0),('5','175',206772,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'597',601118.10,601118.10,'597','2021-06-27 21:42:15','606','2021-06-28 05:35:41',10,0),('5','175',206819,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'597',642178.35,642178.35,'597','2021-06-28 21:37:08','606','2021-06-29 05:45:30',10,0),('5','175',207028,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'597',591434.25,591434.25,'597','2021-06-29 21:43:31','606','2021-06-30 05:32:55',10,0),('5','175',207270,'DAILY SHIFT ','2021-06-30','2021-06-30 00:00:00',NULL,'597',755183.55,755183.55,'597','2021-06-30 23:13:50','606','2021-07-01 05:38:39',10,0),('5','175',207490,'DAILY SHIFT ','2021-07-01','2021-07-01 00:00:00',NULL,'597',765839.25,765839.25,'597','2021-07-01 21:29:59','606','2021-07-02 05:35:09',10,0),('5','175',207708,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'597',755597.70,755597.70,'597','2021-07-03 06:33:55','606','2021-07-03 07:01:39',10,0),('5','175',207926,'DAILY SHIFT ','2021-07-03','2021-07-03 00:00:00',NULL,'597',784132.80,784132.80,'597','2021-07-03 21:05:44','606','2021-07-04 05:41:19',10,0),('5','175',208118,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'597',655404.75,655404.75,'597','2021-07-04 21:14:11','606','2021-07-05 05:18:06',10,0),('5','175',208337,'DAILY SHIFT ','2021-07-05','2021-07-05 00:00:00',NULL,'597',731108.40,731108.40,'597','2021-07-05 21:06:39','606','2021-07-06 07:02:11',10,0),('5','175',208546,'DAILY SHIFT ','2021-07-06','2021-07-06 00:00:00',NULL,'597',643559.40,643559.40,'597','2021-07-06 21:04:01','606','2021-07-07 05:54:59',10,0),('5','175',208764,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'597',653000.70,653000.70,'597','2021-07-07 20:54:05','606','2021-07-08 04:55:23',10,0),('5','175',208984,'DAILY SHIFT ','2021-07-08','2021-07-08 00:00:00',NULL,'597',661925.55,661925.55,'597','2021-07-08 21:01:59','606','2021-07-09 06:16:36',10,0),('5','175',209255,'DAILY SHIFT ','2021-07-09','2021-07-09 00:00:00',NULL,'597',496511.40,496511.40,'597','2021-07-09 21:07:24','606','2021-07-10 06:32:30',10,0),('5','175',209455,'DAILY SHIFT ','2021-07-10','2021-07-10 00:00:00',NULL,'597',647171.25,647171.25,'597','2021-07-10 20:58:11','606','2021-07-11 05:43:48',10,0),('5','175',209656,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'597',608249.40,608249.40,'597','2021-07-12 07:15:32','606','2021-07-12 07:27:52',10,0),('5','175',209891,'DAILY SHIFT ','2021-07-12','2021-07-12 00:00:00',NULL,'597',571277.85,571277.85,'597','2021-07-12 20:43:34','606','2021-07-13 04:25:08',10,0),('5','175',210107,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'597',602906.70,602906.70,'597','2021-07-13 21:04:45','606','2021-07-14 06:20:24',10,0),('5','175',210325,'DAILY SHIFT ','2021-07-14','2021-07-14 00:00:00',NULL,'597',651383.70,651383.70,'597','2021-07-14 21:07:19','606','2021-07-15 06:07:15',10,0),('5','175',210524,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'597',594047.85,594047.85,'597','2021-07-15 21:06:48','606','2021-07-16 05:36:55',10,0),('5','175',210732,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'597',607685.10,607685.10,'597','2021-07-16 21:14:13','606','2021-07-17 06:03:16',10,0),('5','175',210954,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'597',674587.65,674587.65,'597','2021-07-17 21:05:15','606','2021-07-18 06:07:43',10,0),('5','175',211193,'DAILY SHIFT ','2021-07-18','2021-07-18 00:00:00',NULL,'597',563704.35,563704.35,'597','2021-07-18 21:01:50','606','2021-07-19 06:32:47',10,0),('5','175',211411,'DAILY SHIFT ','2021-07-19','2021-07-19 00:00:00',NULL,'597',906109.05,906109.05,'597','2021-07-19 21:41:35','606','2021-07-20 05:43:23',10,0),('5','175',211664,'DAILY SHIFT ','2021-07-20','2021-07-20 00:00:00',NULL,'597',762997.95,762997.95,'597','2021-07-20 21:25:03','606','2021-07-21 06:20:13',10,0),('5','175',211782,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'597',656294.10,656294.10,'597','2021-07-21 20:57:43','606','2021-07-22 06:22:44',10,0),('5','175',212004,'DAILY SHIFT ','2021-07-22','2021-07-22 00:00:00',NULL,'597',608713.05,608713.05,'597','2021-07-22 21:01:52','606','2021-07-23 04:34:16',10,0),('5','175',212237,'DAILY SHIFT ','2021-07-23','2021-07-23 00:00:00',NULL,'597',674619.00,674619.00,'597','2021-07-23 21:10:55','606','2021-07-24 04:41:05',10,0),('5','175',212485,'DAILY SHIFT ','2021-07-24','2021-07-24 00:00:00',NULL,'597',199277.10,199277.10,'597','2021-07-25 05:09:24','606','2021-07-25 05:23:42',10,0),('5','175',212661,'DAILY SHIFT ','2021-07-25','2021-07-25 00:00:00',NULL,'597',540599.40,540599.40,'597','2021-07-25 22:30:34','606','2021-07-26 05:41:17',10,0),('5','175',212874,'DAILY SHIFT ','2021-07-26','2021-07-26 00:00:00',NULL,'597',533251.95,533251.95,'597','2021-07-26 22:00:08','606','2021-07-27 05:51:43',10,0),('5','175',213129,'DAILY SHIFT ','2021-07-27','2021-07-27 00:00:00',NULL,'597',530841.30,530841.30,'597','2021-07-27 21:47:01','606','2021-07-28 01:53:49',10,0),('5','175',213378,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'597',547125.15,547125.15,'597','2021-07-28 21:31:56','606','2021-07-29 05:39:22',10,0),('5','175',213741,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'597',575209.80,575209.80,'597','2021-07-29 22:54:05','606','2021-07-30 07:06:11',10,0),('5','175',213911,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'597',543899.40,543899.40,'597','2021-07-30 22:39:21','606','2021-07-31 08:47:23',10,0),('5','175',214262,'DAILY SHIFT ','2021-07-31','2021-07-31 00:00:00',NULL,'597',482182.80,482182.80,'597','2021-07-31 23:24:16','606','2021-08-01 05:17:22',10,0),('5','175',214454,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'597',541953.70,542557.85,'597','2021-08-02 05:36:55','606','2021-08-02 07:05:53',10,0),('5','175',214557,'DAILY SHIFT ','2021-08-02','2021-08-02 00:00:00',NULL,'597',575887.55,575887.55,'597','2021-08-02 22:07:12','606','2021-08-03 04:27:40',10,0),('5','175',214825,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'597',384913.90,384913.90,'597','2021-08-03 20:47:05','606','2021-08-04 05:52:06',10,0),('5','175',215195,'DAILY SHIFT ','2021-08-04','2021-08-04 00:00:00',NULL,'597',213673.35,213673.35,'597','2021-08-04 22:04:45','606','2021-08-05 05:26:33',10,0),('5','175',215325,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'597',26998.40,26998.40,'597','2021-08-05 21:54:28','606','2021-08-06 01:14:12',10,0),('5','175',215526,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'597',1144109.10,1144109.10,'597','2021-08-06 21:36:40','606','2021-08-07 05:38:04',10,0),('5','175',215771,'DAILY SHIFT ','2021-08-07','2021-08-07 00:00:00',NULL,'597',554587.65,554587.65,'597','2021-08-07 21:57:34','606','2021-08-08 03:35:47',10,0),('5','175',215986,'DAILY SHIFT ','2021-08-08','2021-08-08 00:00:00',NULL,'597',496538.65,496538.65,'597','2021-08-08 22:18:50','606','2021-08-09 06:20:01',10,0),('5','175',216152,'DAILY SHIFT ','2021-08-09','2021-08-09 00:00:00',NULL,'597',760543.35,760543.35,'597','2021-08-09 22:23:05','606','2021-08-10 05:33:00',10,0),('5','175',216332,'DAILY SHIFT ','2021-08-10','2021-08-10 00:00:00',NULL,'597',505950.05,505950.05,'597','2021-08-10 21:53:14','606','2021-08-11 05:47:51',10,0),('5','175',216570,'DAILY SHIFT ','2021-08-11','2021-08-11 00:00:00',NULL,'597',553614.45,553614.45,'597','2021-08-11 21:32:04','606','2021-08-12 05:34:17',10,0),('5','175',216809,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'597',474754.35,474754.35,'597','2021-08-12 21:23:19','606','2021-08-13 05:40:10',10,0),('5','175',217046,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'597',531514.80,531514.80,'597','2021-08-13 22:03:49','606','2021-08-14 05:39:52',10,0),('5','175',217280,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'597',715905.25,715905.25,'597','2021-08-14 21:46:18','606','2021-08-15 19:00:01',10,0),('5','175',217680,'DAILY SHIFT ','2021-08-15','2021-08-15 00:00:00',NULL,'597',916949.35,916949.35,'597','2021-08-15 21:52:58','606','2021-08-16 06:08:10',10,0),('5','175',217713,'DAILY SHIFT ','2021-08-16','2021-08-16 00:00:00',NULL,'597',619130.25,619130.25,'597','2021-08-16 21:43:18','606','2021-08-17 05:44:24',10,0),('5','175',218016,'DAILY SHIFT ','2021-08-17','2021-08-17 00:00:00',NULL,'597',592235.75,592235.75,'597','2021-08-17 21:33:24','606','2021-08-18 00:53:21',10,0),('5','175',218223,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'597',627666.15,627666.15,'597','2021-08-18 22:14:30','606','2021-08-19 05:48:31',10,0),('5','175',218475,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'597',551750.15,551750.15,'597','2021-08-19 21:46:29','606','2021-08-20 05:46:49',10,0),('5','175',218732,'DAILY SHIFT ','2021-08-20','2021-08-20 00:00:00',NULL,'597',685974.55,685974.55,'597','2021-08-20 22:08:29','606','2021-08-21 06:16:16',10,0),('5','175',219002,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'597',746202.30,746202.30,'597','2021-08-21 21:40:52','606','2021-08-22 06:00:12',10,0),('5','175',219158,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'597',585330.10,585330.10,'597','2021-08-22 21:08:49','606','2021-08-23 05:46:58',10,0),('5','175',219329,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'597',486881.30,486881.30,'597','2021-08-23 21:03:11','606','2021-08-24 05:37:15',10,0),('5','175',219633,'DAILY SHIFT ','2021-08-24','2021-08-24 00:00:00',NULL,'597',558033.05,558033.05,'597','2021-08-24 20:57:24','606','2021-08-25 05:39:49',10,0),('5','175',219812,'DAILY SHIFT ','2021-08-25','2021-08-25 00:00:00',NULL,'597',568378.55,568378.55,'597','2021-08-25 21:03:11','606','2021-08-26 05:03:11',10,0),('5','175',220086,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'597',254555.60,254555.60,'597','2021-08-26 19:57:18','606','2021-08-27 06:15:26',10,0),('5','175',220266,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'597',27635.60,27635.60,'597','2021-08-27 20:26:09','606','2021-08-28 05:21:56',10,0),('5','175',220476,'DAILY SHIFT ','2021-08-28','2021-08-28 00:00:00',NULL,'597',51689.90,51689.90,'597','2021-08-28 19:45:32','606','2021-08-29 05:51:54',10,0),('5','175',220726,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'597',252978.80,252978.80,'597','2021-08-29 20:50:00','606','2021-08-30 05:35:12',10,0),('5','175',220905,'DAILY SHIFT ','2021-08-30','2021-08-30 00:00:00',NULL,'597',539069.65,539069.65,'597','2021-08-30 20:54:22','606','2021-08-31 05:59:12',10,0),('5','175',221145,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'597',615660.80,615660.80,'597','2021-08-31 21:07:04','606','2021-09-01 05:56:36',10,0),('5','175',221401,'DAILY SHIFT ','2021-09-01','2021-09-01 00:00:00',NULL,'597',567225.80,567225.80,'597','2021-09-01 20:26:06','606','2021-09-02 05:45:04',10,0),('5','175',221617,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'597',646424.45,646424.45,'597','2021-09-02 20:40:41','606','2021-09-03 05:41:56',10,0),('5','175',221836,'DAILY SHIFT ','2021-09-03','2021-09-03 00:00:00',NULL,'597',652503.10,652503.10,'597','2021-09-03 20:47:45','606','2021-09-04 05:58:26',10,0),('5','175',222062,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'597',635223.60,635223.60,'597','2021-09-04 22:55:29','606','2021-09-05 05:55:36',10,0),('5','175',222265,'DAILY SHIFT ','2021-09-05','2021-09-05 00:00:00',NULL,'597',581104.15,581104.15,'597','2021-09-05 20:48:37','606','2021-09-06 06:02:56',10,0),('5','175',222497,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'597',626739.05,626739.05,'597','2021-09-06 20:50:33','606','2021-09-07 06:37:35',10,0),('5','175',222738,'DAILY SHIFT ','2021-09-07','2021-09-07 00:00:00',NULL,'597',422544.65,422544.65,'597','2021-09-07 19:49:02','606','2021-09-08 06:06:40',10,0),('5','175',222957,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'597',253541.55,253541.55,'597','2021-09-08 19:43:56','606','2021-09-09 05:14:31',10,0),('5','175',223219,'DAILY SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'597',38987.20,38987.20,'597','2021-09-09 19:38:58','606','2021-09-10 05:55:34',10,0),('5','175',223446,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'597',37597.75,37597.75,'597','2021-09-10 19:49:55','606','2021-09-11 05:58:38',10,0),('5','175',223641,'DAILY SHIFT ','2021-09-11','2021-09-11 00:00:00',NULL,'597',58174.00,58174.00,'597','2021-09-11 19:46:40','606','2021-09-12 05:59:44',10,0),('5','175',224045,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'597',61395.40,61395.40,'597','2021-09-12 19:44:56','606','2021-09-13 05:43:46',10,0),('5','175',224118,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'597',35447.20,35447.20,'597','2021-09-13 19:37:46','606','2021-09-14 06:28:08',10,0),('5','175',224317,'DAILY SHIFT ','2021-09-14','2021-09-14 00:00:00',NULL,'597',101185.00,101185.00,'597','2021-09-14 19:36:56','606','2021-09-15 06:17:46',10,0),('5','175',224530,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'597',75095.20,75095.20,'597','2021-09-15 19:59:44','606','2021-09-16 06:05:40',10,0),('5','175',224776,'DAILY SHIFT ','2021-09-16','2021-09-16 00:00:00',NULL,'597',99648.05,99648.05,'597','2021-09-16 19:13:07','606','2021-09-17 05:45:18',10,0),('5','175',225043,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'597',60829.00,60829.00,'597','2021-09-17 19:19:17','606','2021-09-18 05:47:57',10,0),('5','175',225262,'DAILY SHIFT ','2021-09-18','2021-09-18 00:00:00',NULL,'597',61799.55,61799.55,'597','2021-09-18 19:34:05','606','2021-09-19 05:57:44',10,0),('5','175',225502,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'597',25547.00,25547.00,'597','2021-09-19 19:33:22','606','2021-09-20 05:38:06',10,0),('5','175',225707,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'597',96984.20,96984.20,'597','2021-09-20 19:29:56','606','2021-09-21 05:32:47',10,0),('5','175',226008,'DAILY SHIFT ','2021-09-21','2021-09-21 00:00:00',NULL,'597',26809.60,26809.60,'597','2021-09-21 21:27:20','606','2021-09-22 08:35:01',10,0),('5','175',226301,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'597',55545.55,55545.55,'597','2021-09-22 19:48:21','606','2021-09-23 05:38:38',10,0),('5','175',226490,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'597',377989.50,377989.50,'597','2021-09-23 20:40:04','606','2021-09-24 06:07:29',10,0),('5','175',226809,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'597',385224.75,385224.75,'597','2021-09-24 20:38:03','606','2021-09-25 05:43:40',10,0),('5','175',226999,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'597',346947.20,346947.20,'597','2021-09-25 20:24:06','606','2021-09-26 05:46:24',10,0),('5','175',227204,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'597',433076.45,433076.45,'597','2021-09-26 20:27:37','606','2021-09-27 05:37:44',10,0),('5','175',227399,'DAILY SHIFT ','2021-09-27','2021-09-27 00:00:00',NULL,'597',516612.80,516612.80,'597','2021-09-27 20:22:26','606','2021-09-28 05:48:20',10,0),('5','175',227627,'DAILY SHIFT ','2021-09-28','2021-09-28 00:00:00',NULL,'597',652904.15,656179.05,'597','2021-09-28 20:29:21','606','2021-09-29 05:52:13',10,0),('5','175',227883,'DAILY SHIFT ','2021-09-29','2021-09-29 00:00:00',NULL,'597',622101.00,623380.95,'597','2021-09-29 20:07:02','606','2021-10-05 11:54:25',10,0),('5','175',229277,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'597',639232.70,641306.10,'597','2021-10-05 12:26:17','606','2021-10-05 12:28:00',10,0),('5','175',229278,'DAILY SHIFT ','2021-10-01','2021-10-01 00:00:00',NULL,'597',938709.80,946028.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','175',230754,'DAILY SHIFT ','2021-10-01','2021-10-01 00:00:00',NULL,'597',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','175',230755,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'597',946028.25,946028.25,'597','2021-10-11 19:50:35','606','2021-10-11 19:53:47',10,0),('5','175',230757,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'597',545739.75,545739.75,'597','2021-10-11 19:56:21','606','2021-10-11 19:58:17',10,0),('5','175',230759,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'597',500540.55,500540.55,'597','2021-10-11 20:01:39','606','2021-10-11 20:06:11',10,0),('5','175',230765,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'597',475411.65,475411.65,'597','2021-10-11 22:02:33','606','2021-10-12 04:40:12',10,0),('5','175',230837,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'597',576000.60,576000.60,'597','2021-10-12 09:39:30','606','2021-10-12 09:41:46',10,0),('5','175',230840,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'597',641572.95,646685.15,'597','2021-10-12 09:50:51','606','2021-10-12 09:53:59',10,0),('5','175',230846,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'597',654941.05,654941.05,'597','2021-10-12 09:56:20','606','2021-10-12 09:57:18',10,0),('5','175',230847,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'597',656560.15,656560.15,'597','2021-10-12 09:59:53','606','2021-10-12 10:00:52',10,0),('5','175',230848,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'597',536546.40,536546.40,'597','2021-10-12 10:03:29','606','2021-10-12 10:04:46',10,0),('5','175',230850,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'597',89265.85,89265.85,'597','2021-10-12 10:07:15','606','2021-10-12 10:14:18',10,0),('5','175',230855,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'597',80684.80,80684.80,'597','2021-10-12 10:20:51','606','2021-10-12 10:23:37',10,0),('5','175',230858,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'597',469975.50,469975.50,'597','2021-10-12 20:17:04','606','2021-10-13 05:56:21',10,0),('5','175',231101,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'597',505027.65,505027.65,'597','2021-10-13 20:28:42','606','2021-10-14 07:20:09',10,0),('5','175',231417,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'597',527231.70,527231.70,'597','2021-10-14 20:16:40','606','2021-10-15 06:00:13',10,0),('5','175',231669,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'597',600763.40,600763.40,'597','2021-10-15 20:37:39','606','2021-10-16 06:19:13',10,0),('5','175',231991,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'597',516924.40,516924.40,'597','2021-10-16 21:28:40','606','2021-10-17 08:34:56',10,0),('5','175',232184,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'597',642542.55,642542.55,'597','2021-10-17 22:17:02','606','2021-10-18 06:11:46',10,0),('5','175',232341,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'597',575305.29,575305.29,'597','2021-10-18 22:20:12','606','2021-10-19 05:51:49',10,0),('5','175',232647,'DAILY SHIFT ','2021-10-19','2021-10-19 00:00:00',NULL,'597',664627.89,664627.89,'597','2021-10-19 20:57:53','606','2021-10-20 05:47:00',10,0),('5','175',232887,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'597',23720.58,23720.58,'597','2021-10-20 13:26:51','606','2021-10-20 13:30:18',10,0),('5','175',233023,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'597',529377.30,529377.30,'597','2021-10-20 21:51:28','606','2021-10-21 06:03:01',10,0),('5','175',233126,'DAILY SHIFT ','2021-10-21','2021-10-21 00:00:00',NULL,'597',663745.50,663745.50,'597','2021-10-21 21:32:31','606','2021-10-22 05:57:44',10,0),('5','175',233422,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'597',772071.15,772071.15,'597','2021-10-22 20:50:55','606','2021-10-23 06:16:21',10,0),('5','175',233654,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'597',1032049.80,1032049.80,'597','2021-10-23 21:57:28','606','2021-10-24 06:14:32',10,0),('5','175',233850,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'597',1041737.25,1041737.25,'597','2021-10-24 21:14:20','606','2021-10-25 06:05:01',10,0),('5','175',234053,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'597',432505.05,432505.05,'597','2021-10-26 05:22:13','606','2021-10-26 05:38:31',10,0),('5','175',234406,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'597',60095.55,60095.55,'597','2021-10-27 07:29:45','606','2021-10-27 08:31:14',10,0),('5','175',234657,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'597',51142.80,51142.80,'597','2021-10-27 21:55:01','606','2021-10-28 07:19:27',10,0),('5','175',234870,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'597',47416.80,47416.80,'597','2021-10-28 20:30:41','606','2021-10-29 06:07:08',10,0),('5','175',235094,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'597',59553.90,59553.90,'597','2021-10-29 21:14:48','606','2021-10-30 07:13:32',10,0),('5','175',235342,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'597',93674.40,93674.40,'597','2021-10-30 19:40:52','606','2021-10-31 06:10:47',10,0),('5','175',235586,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'597',100263.90,100263.90,'597','2021-10-31 21:48:49','606','2021-11-01 07:24:00',10,0),('5','175',238027,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-10 13:54:06','606','2021-11-10 14:07:20',10,0),('5','175',238035,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-10 14:23:02','606','2021-11-11 05:45:22',10,0),('5','175',238207,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-11 11:10:14','606','2021-11-11 12:11:16',10,0),('5','175',238237,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-11 12:15:32','606','2021-11-11 12:20:31',10,0),('5','175',238243,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-11 12:26:40','606','2021-11-11 12:34:56',10,0),('5','175',238249,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-11 12:39:30','606','2021-11-11 13:52:59',10,0),('5','175',238270,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-11 14:01:13','606','2021-11-12 07:26:34',10,0),('5','175',238491,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-12 12:55:33','606','2021-11-12 13:36:29',10,0),('5','175',238523,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-12 14:27:05','606','2021-11-12 14:34:33',10,0),('5','175',238531,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-12 14:59:20','606','2021-11-12 15:31:12',10,0),('5','175',238539,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-12 16:21:01','606','2021-11-13 07:03:16',10,0),('5','175',238683,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-13 17:43:40','606','2021-11-14 05:46:48',10,0),('5','175',238876,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-14 17:36:34','606','2021-11-15 06:22:30',10,0),('5','175',239139,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-15 20:58:53','606','2021-11-16 07:15:37',10,0),('5','175',239344,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-16 20:29:58','606','2021-11-17 05:46:04',10,0),('5','175',239603,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-17 18:21:23','606','2021-11-18 06:06:36',10,0),('5','175',240016,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-19 06:53:34','606','2021-11-19 07:26:02',10,0),('5','175',240079,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-19 22:16:40','606','2021-11-20 07:07:44',10,0),('5','175',240380,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-20 18:36:39','606','2021-11-21 05:51:19',10,0),('5','175',240561,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-21 13:12:23','606','2021-11-22 06:20:24',10,0),('5','175',240800,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-22 21:42:04','606','2021-11-23 07:00:53',10,0),('5','175',241165,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-23 17:36:14','606','2021-11-24 06:13:20',10,0),('5','175',241247,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-24 17:42:01','606','2021-11-25 06:24:56',10,0),('5','175',241518,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-25 18:04:23','606','2021-11-26 06:07:41',10,0),('5','175',241800,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-26 18:16:08','606','2021-11-27 07:08:00',10,0),('5','175',242009,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-27 17:36:02','606','2021-11-28 06:47:09',10,0),('5','175',242291,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-28 19:16:14','606','2021-11-29 05:57:41',10,0),('5','175',242478,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-29 22:53:07','606','2021-11-30 06:00:33',10,0),('5','175',242757,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'597',0.00,0.00,'597','2021-11-30 17:28:45','606','2021-12-01 02:41:32',10,0),('5','175',242927,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-01 16:32:06','606','2021-12-02 07:19:37',10,0),('5','175',243216,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-02 17:03:54','606','2021-12-03 06:46:13',10,0),('5','175',243429,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-03 17:46:50','606','2021-12-04 06:54:39',10,0),('5','175',243673,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-04 19:07:26','606','2021-12-05 05:43:54',10,0),('5','175',243908,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-05 18:45:35','606','2021-12-06 06:28:33',10,0),('5','175',244090,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-06 17:47:58','606','2021-12-07 06:51:00',10,0),('5','175',244357,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-07 17:49:14','606','2021-12-08 07:16:58',10,0),('5','175',244559,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-08 17:36:19','606','2021-12-09 05:40:50',10,0),('5','175',244779,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-09 19:12:15','606','2021-12-10 06:14:47',10,0),('5','175',245168,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'597',1352148.60,1352148.60,'597','2021-12-10 19:26:38','606','2021-12-11 06:58:48',10,0),('5','175',245243,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'597',1794544.95,1794544.95,'597','2021-12-11 21:01:18','606','2021-12-12 06:49:17',10,0),('5','175',245518,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'597',1327195.65,1327195.65,'597','2021-12-12 19:06:17','606','2021-12-13 05:56:56',10,0),('5','175',245742,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'597',1163091.60,1163091.60,'597','2021-12-13 19:18:21','606','2021-12-14 06:04:22',10,0),('5','175',245992,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'597',1363055.10,1363055.10,'597','2021-12-14 20:11:14','606','2021-12-15 06:38:23',10,0),('5','175',246289,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'597',351141.45,351141.45,'597','2021-12-15 17:01:47','606','2021-12-16 06:50:04',10,0),('5','175',246476,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-16 17:37:06','606','2021-12-17 06:09:55',10,0),('5','175',246704,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'597',0.00,0.00,'597','2021-12-17 18:24:56','606','2021-12-18 07:01:55',10,0),('5','175',246968,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'597',34248.15,34248.15,'597','2021-12-18 19:26:59','606','2021-12-19 07:11:24',10,0),('5','175',247215,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'597',80854.20,80854.20,'597','2021-12-19 20:35:55','606','2021-12-20 06:52:52',10,0),('5','175',247462,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'597',131852.10,131852.10,'597','2021-12-20 18:32:52','600','2021-12-21 09:21:58',10,0),('5','175',247746,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'597',125193.60,125193.60,'597','2021-12-21 18:16:01','606','2021-12-22 06:28:10',10,0),('5','175',248012,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'597',124434.60,124434.60,'597','2021-12-22 18:50:09','606','2021-12-23 06:23:16',10,0),('5','175',248241,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'597',120853.50,120853.50,'597','2021-12-23 18:39:01','606','2021-12-24 07:19:22',10,0),('5','175',248577,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'597',131120.70,131120.70,'597','2021-12-24 18:39:10','606','2021-12-25 14:07:31',10,0),('5','175',248821,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'597',162691.65,162691.65,'597','2021-12-25 18:27:05','606','2021-12-26 07:31:00',10,0),('5','175',248945,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'597',205254.30,205254.30,'597','2021-12-26 18:24:39','606','2021-12-27 07:39:49',10,0),('5','175',249197,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'597',254161.50,254161.50,'597','2021-12-27 18:59:06','606','2021-12-28 07:34:17',10,0),('5','175',249435,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'597',102037.20,102037.20,'597','2021-12-28 18:47:45','606','2021-12-29 06:44:22',10,0),('5','175',249651,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'597',119594.25,119594.25,'597','2021-12-29 18:23:41','606','2021-12-30 06:55:45',10,0),('5','175',249920,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'597',127384.35,127384.35,'597','2021-12-30 18:43:55','606','2021-12-31 18:59:45',10,0),('5','175',250288,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'597',124231.05,124231.05,'597','2021-12-31 19:02:47','606','2022-01-01 07:48:29',10,0),('5','175',250470,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'597',188180.25,188180.25,'597','2022-01-01 19:04:45','606','2022-01-02 06:43:57',10,0),('5','175',250667,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'597',134822.55,134822.55,'597','2022-01-02 18:28:45','606','2022-01-03 14:05:06',10,0),('5','175',250969,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'597',127646.55,127646.55,'597','2022-01-03 18:48:10','606','2022-01-04 07:03:53',10,0),('5','175',251075,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'597',167093.85,167093.85,'597','2022-01-04 18:55:10','606','2022-01-05 07:33:37',10,0),('5','175',251321,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'597',1569175.65,1569175.65,'597','2022-01-05 19:59:38','606','2022-01-06 07:45:18',10,0),('5','175',251569,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'597',1702808.25,1702808.25,'597','2022-01-06 20:04:25','606','2022-01-07 09:07:28',10,0),('5','175',251827,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'597',1918673.70,1918673.70,'597','2022-01-07 20:05:37','606','2022-01-08 07:57:07',10,0),('5','175',252043,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'597',2446139.10,2446139.10,'597','2022-01-08 20:00:41','606','2022-01-09 08:01:29',10,0),('5','175',252280,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'597',1064416.50,1064416.50,'597','2022-01-09 19:32:48','606','2022-01-10 07:00:57',10,0),('5','175',252570,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'597',170826.75,170826.75,'597','2022-01-10 19:29:12','606','2022-01-11 05:29:51',10,0),('5','175',252769,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'597',115578.45,115578.45,'597','2022-01-11 20:28:01','606','2022-01-12 07:48:34',10,0),('5','175',253031,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'597',107650.35,107650.35,'597','2022-01-12 19:18:28','606','2022-01-13 07:33:56',10,0),('5','175',253245,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'597',94954.35,94954.35,'597','2022-01-13 20:32:29','606','2022-01-14 09:29:54',10,0),('5','175',253545,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'597',110789.85,110789.85,'597','2022-01-14 19:42:36','606','2022-01-15 07:14:33',10,0),('5','175',253792,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'597',86453.55,86453.55,'597','2022-01-15 19:25:25','606','2022-01-16 07:09:14',10,0),('5','175',254000,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'597',108098.85,108098.85,'597','2022-01-16 20:13:46','606','2022-01-17 07:12:37',10,0),('5','175',254274,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'597',62796.90,62796.90,'597','2022-01-17 19:33:17','606','2022-01-18 08:36:59',10,0),('5','175',254517,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'597',2007399.90,2007399.90,'597','2022-01-18 20:32:34','606','2022-01-19 08:42:08',10,0),('5','175',254768,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'597',1764483.60,1764483.60,'597','2022-01-19 20:36:16','606','2022-01-20 08:07:14',10,0),('5','175',255031,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'597',1621052.40,1621052.40,'597','2022-01-20 20:18:46','606','2022-01-21 08:32:36',10,0),('5','175',255247,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'597',1187613.90,1187613.90,'597','2022-01-21 15:53:21','606','2022-01-22 08:04:44',10,0),('5','175',255545,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-22 17:24:57','606','2022-01-23 07:21:36',10,0),('5','175',255760,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-23 18:24:15','606','2022-01-24 08:31:34',10,0),('5','175',256041,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-24 17:56:13','606','2022-01-25 07:31:25',10,0),('5','175',256257,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-25 18:30:52','606','2022-01-26 08:07:21',10,0),('5','175',256540,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-26 19:00:39','606','2022-01-27 07:56:08',10,0),('5','175',256800,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-27 19:12:23','606','2022-01-28 07:20:40',10,0),('5','175',257076,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-28 18:55:00','606','2022-01-29 07:48:46',10,0),('5','175',257338,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-29 18:01:29','606','2022-01-30 07:42:27',10,0),('5','175',257531,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-30 19:10:44','606','2022-01-31 09:29:30',10,0),('5','175',257532,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'597',0.00,0.00,'597','2022-01-31 18:59:13','606','2022-02-01 08:28:21',10,0),('5','175',257533,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-01 18:19:02','606','2022-02-02 08:31:52',10,0),('5','175',257534,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-02 19:08:04','606','2022-02-03 06:37:59',10,0),('5','175',257535,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'597',437880.30,437880.30,'597','2022-02-03 20:25:17','606','2022-02-04 06:25:39',10,0),('5','175',257536,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'597',1282716.60,1282716.60,'597','2022-02-04 19:52:51','606','2022-02-05 07:50:07',10,0),('5','175',257537,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'597',1256691.15,1256691.15,'597','2022-02-05 20:29:31','606','2022-02-06 07:46:13',10,0),('5','175',257538,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'597',1006909.20,1006909.20,'597','2022-02-07 06:35:01','606','2022-02-07 07:15:33',10,0),('5','175',257539,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'597',1690009.20,1690009.20,'597','2022-02-07 23:15:09','606','2022-02-08 07:41:43',10,0),('5','175',257540,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'597',1057222.65,1057222.65,'597','2022-02-08 21:41:15','606','2022-02-09 08:16:46',10,0),('5','175',257541,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'597',713352.75,713352.75,'597','2022-02-09 17:49:13','606','2022-02-10 07:57:15',10,0),('5','175',257542,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-10 19:50:17','606','2022-02-11 08:10:19',10,0),('5','175',257543,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-11 22:29:29','606','2022-02-12 08:11:46',10,0),('5','175',257544,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-12 21:39:37','606','2022-02-13 07:28:39',10,0),('5','175',257545,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-13 20:43:50','606','2022-02-14 07:19:35',10,0),('5','175',257546,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-14 21:05:09','606','2022-02-15 08:08:55',10,0),('5','175',257547,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-15 19:52:54','606','2022-02-16 07:31:29',10,0),('5','175',257548,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-16 18:43:45','606','2022-02-17 07:08:06',10,0),('5','175',257549,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-17 21:16:35','606','2022-02-18 07:22:00',10,0),('5','175',257550,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-18 20:07:32','606','2022-02-19 07:29:43',10,0),('5','175',257551,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-19 20:16:42','606','2022-02-20 07:20:22',10,0),('5','175',257552,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-20 19:02:55','606','2022-02-21 07:24:11',10,0),('5','175',257553,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'597',0.00,0.00,'597','2022-02-21 21:02:54','606','2022-02-22 06:41:37',10,0),('5','175',257554,'DAILY SHIFT','2022-02-22','2022-02-22 11:54:31','2022-02-23 11:54:31','597',0.00,0.00,'597','2022-02-22 20:50:35','606','2022-02-23 07:01:01',10,0),('5','175',257555,'DAILY SHIFT','2022-02-23','2022-02-23 08:53:19','2022-02-24 08:53:19','597',962052.30,962052.30,'597','2022-02-23 21:04:50','606','2022-02-24 09:37:07',10,0),('5','175',257556,'DAILY SHIFT','2022-02-24','2022-02-24 09:51:24','2022-02-25 09:51:24','597',1269981.90,1269981.90,'597','2022-02-24 21:44:51','606','2022-02-25 08:09:57',10,0),('5','175',257557,'DAILY SHIFT','2022-02-25','2022-02-25 08:18:19','2022-02-26 08:18:19','597',1177101.75,1177101.75,'597','2022-02-25 21:41:57','606','2022-02-26 07:18:54',10,0),('5','175',257558,'DAILY SHIFT','2022-02-26','2022-02-26 16:11:04','2022-02-27 16:11:04','597',1310972.85,1310972.85,'597','2022-02-26 20:32:22','606','2022-02-27 07:01:15',10,0),('5','175',257559,'DAILY SHIFT','2022-02-27','2022-02-27 09:52:35','2022-02-28 09:52:35','597',1474011.00,1474011.00,'597','2022-02-27 21:39:07','606','2022-02-28 07:16:56',10,0),('5','175',257560,'DAILY SHIFT','2022-02-28','2022-02-28 08:42:48','2022-03-01 08:42:48','597',898933.20,898933.20,'597','2022-02-28 20:47:57','606','2022-03-01 06:53:49',10,0),('5','175',257561,'DAILY SHIFT','2022-03-01','2022-03-01 07:23:23','2022-03-02 07:23:23','597',409299.00,409299.00,'597','2022-03-01 16:49:08','606','2022-03-02 08:17:50',10,0),('5','175',257562,'DAILY SHIFT','2022-03-02','2022-03-02 09:05:39','2022-03-03 09:05:39','597',0.00,0.00,'597','2022-03-02 18:15:46','606','2022-03-03 09:42:16',10,0),('5','175',257563,'DAILY SHIFT','2022-03-04','2022-03-05 08:58:56','2022-03-06 08:58:56','597',0.00,0.00,'597','2022-03-05 08:59:39','606','2022-03-05 09:12:03',10,0),('5','175',257564,'DAILY SHIFT','2022-03-05','2022-03-05 11:12:18','2022-03-06 11:12:18','597',0.00,0.00,'597','2022-03-05 18:35:08','606','2022-03-06 07:42:08',10,0),('5','175',257565,'DAILY SHIFT','2022-03-06','2022-03-06 07:59:21','2022-03-07 07:59:21','597',0.00,0.00,'597','2022-03-06 19:41:02','606','2022-03-07 07:56:07',10,0),('5','175',257566,'DAILY SHIFT','2022-03-07','2022-03-07 11:31:55','2022-03-08 11:31:55','597',0.00,0.00,'597','2022-03-07 21:03:31','606','2022-03-08 07:02:30',10,0),('5','175',257567,'DAILY SHIFT ','2022-03-08','2022-03-08 09:21:04','2022-03-09 09:21:04','597',0.00,0.00,'597','2022-03-08 21:19:37','606','2022-03-09 07:55:25',10,0),('5','175',257568,'DAILY SHIFT','2022-03-09','2022-03-09 09:14:15','2022-03-10 09:14:15','597',0.00,0.00,'597','2022-03-09 20:29:16','606','2022-03-10 06:38:13',10,0),('5','175',257569,'DAILY SHIFT','2022-03-10','2022-03-10 06:51:39','2022-03-11 06:51:39','597',0.00,0.00,'597','2022-03-10 18:46:21','606','2022-03-11 08:23:50',10,0),('5','175',257570,'DAILY SHIFT','2022-03-11','2022-03-11 09:59:59','2022-03-12 09:59:59','597',0.00,0.00,'597','2022-03-11 20:24:55','606','2022-03-12 07:55:33',10,0),('5','175',257571,'DAILY SHIFT','2022-03-12','2022-03-12 17:04:51','2022-03-13 17:04:51','597',0.00,0.00,'597','2022-03-12 17:05:12','606','2022-03-13 08:06:03',10,0),('5','175',257572,'DAILY SHIFT','2022-03-13','2022-03-13 09:11:09','2022-03-14 09:11:09','597',0.00,0.00,'597','2022-03-13 18:52:21','606','2022-03-14 07:05:34',10,0),('5','175',257573,'DAILY SHIFT','2022-03-14','2022-03-14 08:54:32','2022-03-15 08:54:32','597',0.00,0.00,'597','2022-03-14 21:53:29','606','2022-03-15 07:07:04',10,0),('5','175',257574,'DAILY SHIFT','2022-03-15','2022-03-15 14:40:30','2022-03-16 14:40:30','597',547734.00,547734.00,'597','2022-03-15 20:35:14','606','2022-03-16 08:08:57',10,0),('5','175',257575,'DAILY SHIFT','2022-03-16','2022-03-16 12:01:31','2022-03-17 12:01:31','597',908760.60,908760.60,'597','2022-03-16 21:39:10','606','2022-03-17 10:21:33',10,0),('5','175',257576,'DAILY SHIFT','2022-03-17','2022-03-17 12:36:37','2022-03-18 12:36:37','597',597410.55,597410.55,'597','2022-03-17 22:48:45','606','2022-03-18 07:46:28',10,0),('5','175',257577,'DAILY SHIFT','2022-03-18','2022-03-18 13:14:06','2022-03-19 13:14:06','597',200491.50,200491.50,'597','2022-03-18 19:37:54','606','2022-03-19 06:59:38',10,0),('5','175',257578,'DAILY SHIFT','2022-03-19','2022-03-19 09:23:08','2022-03-20 09:23:08','597',0.00,0.00,'597','2022-03-19 18:19:18','606','2022-03-20 07:29:57',10,0),('5','175',257579,'DAILY SHIFT','2022-03-20','2022-03-20 22:56:35','2022-03-21 22:56:35','597',0.00,0.00,'597','2022-03-20 22:57:04','606','2022-03-21 06:31:07',10,0),('5','175',257580,'DAILY SHIFT','2022-03-21','2022-03-21 07:22:53','2022-03-22 07:22:53','597',0.00,0.00,'597','2022-03-21 20:06:17','606','2022-03-22 07:05:36',10,0),('5','175',257581,'DAILY SHIFT','2022-03-22','2022-03-22 07:52:25','2022-03-23 07:52:25','597',0.00,0.00,'597','2022-03-22 20:44:44','606','2022-03-23 06:32:30',10,0),('5','175',257582,'DAILY SHIFT','2022-03-23','2022-03-23 08:24:38','2022-03-24 08:24:38','597',0.00,0.00,'597','2022-03-23 19:31:50','606','2022-03-24 20:32:34',10,0),('5','175',257583,'DAILY SHIFT','2022-03-25','2022-03-25 00:06:12','2022-03-26 00:06:12','597',0.00,0.00,'597','2022-03-25 00:06:41','606','2022-03-25 08:27:27',10,0),('5','175',257584,'DAILY SHIFT','2022-03-25','2022-03-25 08:58:02','2022-03-26 08:58:02','597',0.00,0.00,'597','2022-03-26 09:26:57','606','2022-03-27 07:05:03',10,0),('5','175',257585,'DAILY SHIFT','2022-03-26','2022-03-27 12:03:40','2022-03-28 12:03:40','597',0.00,0.00,'597','2022-03-27 12:03:58','606','2022-03-28 09:19:52',10,0),('5','175',257586,'DAILY SHIFT','2022-03-27','2022-03-28 14:02:53','2022-03-29 14:02:53','597',0.00,0.00,'597','2022-03-28 14:03:41','606','2022-03-29 07:19:25',10,0),('5','175',257587,'DAILY SHIFT','2022-03-28','2022-03-29 09:06:33','2022-03-30 09:06:33','597',0.00,0.00,'597','2022-03-29 09:06:56','606','2022-03-29 12:58:59',10,0),('5','175',257588,'DAILY SHIFT','2022-03-29','2022-03-29 13:03:58','2022-03-30 13:03:58','597',0.00,0.00,'597','2022-03-29 16:41:59','606','2022-03-30 06:40:50',10,0),('5','175',257589,'DAILY SHIFT ','2022-03-30','2022-03-30 09:01:39','2022-03-31 09:01:39','597',0.00,0.00,'597','2022-03-30 16:26:53','606','2022-03-31 08:01:53',10,0),('5','175',257590,'DAILY SHIFT','2022-03-31','2022-03-31 11:55:51','2022-04-01 11:55:51','597',0.00,0.00,'597','2022-03-31 18:48:26','606','2022-04-01 08:38:07',10,0),('5','175',257591,'DAILY SHIFT','2022-04-01','2022-04-01 09:00:37','2022-04-02 09:00:37','597',0.00,0.00,'597','2022-04-01 17:02:01','606','2022-04-02 19:14:23',10,0),('5','175',257592,'DAILY SHIFT','2022-04-02','2022-04-02 20:48:18','2022-04-03 20:48:18','597',0.00,0.00,'597','2022-04-02 20:48:37','606','2022-04-03 15:21:20',10,0),('5','175',257593,'DAILY SHIFT','2022-04-03','2022-04-03 16:23:43','2022-04-04 16:23:43','597',0.00,0.00,'597','2022-04-03 21:00:06','606','2022-04-03 21:59:31',10,0),('5','175',257594,'DAILY SHIFT','2022-04-03','2022-04-05 07:39:51','2022-04-06 07:39:51','597',0.00,0.00,'597','2022-04-05 07:41:30','606','2022-04-07 06:09:09',10,0),('5','175',257595,'DAILY SHIFT','2022-04-08','2022-04-08 10:07:08','2022-04-09 10:07:08','597',0.00,0.00,'600','2022-04-08 13:52:05','600','2022-04-08 13:52:25',10,0),('5','175',257596,'DAILY SHIFT','2022-04-09','2022-04-09 09:58:58','2022-04-10 09:58:58','597',0.00,0.00,'597','2022-04-09 21:44:25','600','2022-04-11 11:43:07',10,0),('5','175',257597,'DAILY SHIFT','2022-04-10','2022-04-11 12:18:43','2022-04-12 12:18:43','597',0.00,0.00,'597','2022-04-11 12:19:09','600','2022-04-11 12:27:31',10,0),('5','175',257598,'DAILY SHIFT ','2022-04-11','2022-04-11 14:53:26','2022-04-12 14:53:26','597',0.00,0.00,'597','2022-04-11 22:42:58','600','2022-04-20 09:47:54',10,0),('5','175',257599,'DAILY SHIFT','2022-04-12','2022-04-20 12:07:03','2022-04-21 12:07:03','597',0.00,0.00,'597','2022-04-20 12:07:32','600','2022-04-20 12:56:22',10,0),('5','175',257600,'DAILY SHIFT','2022-04-13','2022-04-20 13:12:03','2022-04-21 13:12:03','597',0.00,0.00,'597','2022-04-20 13:12:30','600','2022-04-20 14:09:45',10,0),('5','175',257601,'DAILY SHIFT','2022-04-14','2022-04-20 14:53:39','2022-04-21 14:53:39','597',0.00,0.00,'597','2022-04-20 14:54:18','600','2022-04-20 15:04:26',10,0),('5','175',257602,'DAILY SHIFT','2022-04-15','2022-04-20 15:09:52','2022-04-21 15:09:52','597',0.00,0.00,'597','2022-04-20 15:10:12','600','2022-04-20 15:21:45',10,0),('5','175',257603,'DAILY SHIFT','2022-04-16','2022-04-20 15:22:54','2022-04-21 15:22:54','597',0.00,0.00,'597','2022-04-20 15:23:22','600','2022-04-21 07:45:03',10,0),('5','175',257604,'DAILY SHIFT','2022-04-17','2022-04-23 13:34:08','2022-04-24 13:34:08','597',0.00,0.00,'597','2022-04-23 13:34:38','600','2022-04-23 14:02:20',10,0),('5','175',257605,'DAILY SHIFT','2022-04-18','2022-04-23 14:04:06','2022-04-24 14:04:06','597',0.00,0.00,'597','2022-04-23 14:04:25','600','2022-04-23 15:33:54',10,0),('5','175',257606,'DAILY SHIFT','2022-04-19','2022-04-23 16:29:06','2022-04-24 16:29:06','597',0.00,0.00,'597','2022-04-23 16:29:31','600','2022-04-23 16:31:19',10,0),('5','175',257607,'DAILY SHIFT','2022-04-20','2022-04-23 16:39:08','2022-04-24 16:39:08','597',0.00,0.00,'597','2022-04-23 16:39:24','600','2022-04-23 16:46:23',10,0),('5','175',257608,'DAILY SHIFT','2022-04-21','2022-04-23 16:52:00','2022-04-24 16:52:00','597',0.00,0.00,'597','2022-04-23 16:52:20','600','2022-04-23 17:08:27',10,0),('5','175',257609,'DAILY SHIFT','2022-04-22','2022-04-23 17:15:37','2022-04-24 17:15:37','597',161799.00,161799.00,'597','2022-04-23 17:17:06','600','2022-04-23 17:39:13',10,0),('5','175',257610,'DAILY SHIFT','2022-04-23','2022-04-23 17:53:22','2022-04-24 17:53:22','597',962984.55,962984.55,'597','2022-04-23 20:04:06','600','2022-04-24 09:19:20',10,0),('5','175',257611,'DAILY SHIFT','2022-04-24','2022-04-24 22:15:51','2022-04-25 22:15:51','597',877224.15,877224.15,'597','2022-04-24 22:17:41','600','2022-04-25 11:36:52',10,0),('5','175',257612,'DAILY SHIFTING','2022-04-25','2022-04-25 14:50:52','2022-04-26 14:50:52','597',923094.15,923094.15,'597','2022-04-26 11:07:27','600','2022-04-26 11:21:01',10,0),('5','175',257613,'DAILY SHIFT','2022-04-26','2022-04-26 11:32:27','2022-04-27 11:32:27','597',860445.30,860445.30,'597','2022-04-26 20:48:30','600','2022-04-27 07:49:32',10,0),('5','175',257614,'DAILY SHIFT','2022-04-27','2022-04-27 09:11:32','2022-04-28 09:11:32','597',1012105.05,1012105.05,'597','2022-04-27 19:51:23','600','2022-04-28 08:25:57',10,0),('5','175',257615,'DAILY SHIFT','2022-04-28','2022-04-28 09:52:56','2022-04-29 09:52:56','597',1000421.40,1000421.40,'597','2022-04-28 20:48:33','600','2022-04-29 10:19:53',10,0),('5','175',257616,'DAILY SHIFT','2022-04-29','2022-05-09 17:45:12','2022-05-10 17:45:12','597',687731.55,687731.55,'597','2022-05-09 17:49:55','600','2022-05-10 09:19:22',10,0),('5','175',257617,'DAILY SHIFT','2022-04-30','2022-05-10 09:46:39','2022-05-11 09:46:39','597',680544.15,680544.15,'597','2022-05-10 09:48:06','600','2022-05-10 11:17:17',10,0),('5','175',257618,'DAILY SHIFT','2022-05-01','2022-05-10 11:20:59','2022-05-11 11:20:59','597',284024.40,284024.40,'597','2022-05-10 14:21:04','600','2022-05-10 15:54:19',10,0),('5','175',257619,'DAILY SHIFT','2022-05-02','2022-05-10 15:58:23','2022-05-11 15:58:23','597',0.00,0.00,'597','2022-05-10 15:58:51','600','2022-05-10 15:59:47',10,0),('5','175',257620,'DAILY SHIFT','2022-05-03','2022-05-10 16:02:28','2022-05-11 16:02:28','597',0.00,0.00,'597','2022-05-10 16:02:45','600','2022-05-10 16:15:06',10,0),('5','175',257621,'DAILY SHIFT','2022-05-04','2022-05-10 16:48:31','2022-05-11 16:48:31','597',0.00,0.00,'597','2022-05-10 16:48:52','600','2022-05-10 20:15:04',10,0),('5','175',257622,'DAILY SHIFT','2022-05-05','2022-05-10 21:50:18','2022-05-11 21:50:18','597',562037.85,562037.85,'597','2022-05-11 06:21:45','600','2022-05-11 06:40:53',10,0),('5','175',257623,'DAILY SHIFT','2022-05-06','2022-05-11 06:50:28','2022-05-12 06:50:28','597',609011.70,609011.70,'597','2022-05-11 06:51:33','600','2022-05-11 07:14:19',10,0),('5','175',257624,'DAILY SHIFT','2022-05-07','2022-05-11 07:20:27','2022-05-12 07:20:27','597',893677.95,893677.95,'597','2022-05-11 07:37:01','664','2022-05-11 07:48:52',10,0),('5','175',257625,'DAILY SHIFT14307','2022-05-08','2022-05-11 08:24:13','2022-05-12 08:24:13','597',834271.35,834271.35,'597','2022-05-11 08:25:55','664','2022-05-11 08:31:59',10,0),('5','175',257626,'DAILY SHIFT','2022-05-09','2022-05-11 08:39:48','2022-05-12 08:39:48','597',676942.20,676942.20,'597','2022-05-11 08:40:49','664','2022-05-11 08:42:08',10,0),('5','175',257627,'DAILY SHIFT','2022-05-10','2022-05-11 08:42:41','2022-05-12 08:42:41','597',592899.45,592899.45,'597','2022-05-11 08:43:44','664','2022-05-11 08:44:16',10,0),('5','175',257628,'DAILY SHIFT','2022-05-11','2022-05-11 08:45:01','2022-05-12 08:45:01','597',199379.40,199379.40,'597','2022-05-12 05:43:53','664','2022-05-12 18:43:52',10,0),('5','175',257629,'DAILY SHIFT','2022-05-12','2022-05-12 19:48:11','2022-05-13 19:48:11','597',0.00,0.00,'597','2022-05-12 19:48:39','664','2022-05-12 22:39:13',10,0),('5','175',257630,'DAILY SHIFT','2022-05-13','2022-05-13 08:06:27','2022-05-14 08:06:27','597',0.00,0.00,'597','2022-05-13 22:17:25','664','2022-05-13 22:25:29',10,0),('5','175',257631,'DAILY SHIFT','2022-05-14','2022-05-14 07:03:26','2022-05-15 07:03:26','597',0.00,0.00,'597','2022-05-14 19:20:04','664','2022-05-15 06:10:10',10,0),('5','175',257632,'DAILY SHIFT','2022-05-15','2022-05-15 06:59:17','2022-05-16 06:59:17','597',0.00,0.00,'597','2022-05-15 22:08:35','664','2022-05-16 06:02:32',10,0),('5','175',257633,'DAILY SHIFT','2022-05-16','2022-05-16 07:06:57','2022-05-17 07:06:57','597',0.00,0.00,'597','2022-05-16 20:59:48','600','2022-05-17 06:11:49',10,0),('5','175',257634,'DAILY SHIFT','2022-05-17','2022-05-17 06:58:13','2022-05-18 06:58:13','597',0.00,0.00,'597','2022-05-17 22:56:34','600','2022-05-18 06:11:53',10,0),('5','175',257635,'DAILY SHIFT','2022-05-18','2022-05-18 06:51:00','2022-05-19 06:51:00','597',0.00,0.00,'597','2022-05-18 19:30:26','600','2022-05-18 21:30:01',10,0),('5','175',257636,'DAILY SHIFT','2022-05-19','2022-05-19 06:36:12','2022-05-20 06:36:12','597',0.00,0.00,'597','2022-05-19 21:25:12','664','2022-05-20 05:23:20',10,0),('5','175',257637,'DAILY SHIFT','2022-05-20','2022-05-20 07:44:06','2022-05-21 07:44:06','597',0.00,0.00,'597','2022-05-20 21:00:36','600','2022-05-20 21:24:11',10,0),('5','175',257638,'DAILY SHIFT','2022-05-21','2022-05-21 05:34:33','2022-05-22 05:34:33','597',0.00,0.00,'597','2022-05-21 16:32:19','600','2022-05-22 08:14:12',10,0),('5','175',257639,'DAILY SHIFT','2022-05-22','2022-05-22 08:31:31','2022-05-23 08:31:31','597',0.00,0.00,'597','2022-05-22 20:40:53','664','2022-05-23 05:16:17',10,0),('5','175',257640,'DAILY SHIFT','2022-05-23','2022-05-23 05:54:02','2022-05-24 05:54:02','597',0.00,0.00,'597','2022-05-23 17:30:44','600','2022-05-23 22:08:58',10,0),('5','175',257641,'DAILY SHIFT','2022-05-24','2022-05-24 05:57:20','2022-05-25 05:57:20','597',0.00,0.00,'597','2022-05-25 05:32:26','600','2022-05-25 06:10:33',10,0),('5','175',257642,'DAILY SHIFT','2022-05-25','2022-05-25 06:16:29','2022-05-26 06:16:29','597',0.00,0.00,'597','2022-05-25 18:15:08','664','2022-05-26 05:21:07',10,0),('5','175',257643,'DAILY SHIFT','2022-05-26','2022-05-26 07:26:32','2022-05-27 07:26:32','597',0.00,0.00,'597','2022-05-26 16:38:02','600','2022-05-26 20:39:19',10,0),('5','175',257644,'DAILY SHIFT','2022-05-27','2022-05-27 01:19:04','2022-05-28 01:19:04','597',0.00,0.00,'597','2022-05-27 21:17:56','664','2022-05-28 04:58:10',10,0),('5','175',257645,'DAILY SHIFT','2022-05-28','2022-05-28 05:33:39','2022-05-29 05:33:39','597',208296.00,208296.00,'597','2022-05-28 23:14:06','600','2022-05-29 08:17:23',10,0),('5','175',257646,'DAILY SHIFT','2022-05-29','2022-05-29 22:33:33','2022-05-30 22:33:33','597',902472.45,902472.45,'597','2022-05-29 22:34:39','664','2022-05-30 04:59:35',10,0),('5','175',257647,'DAILY SHIFT','2022-05-30','2022-05-30 06:04:55','2022-05-31 06:04:55','597',739944.15,739944.15,'597','2022-05-30 22:33:51','664','2022-05-31 00:20:15',10,0),('5','175',257648,'DAILY SHIFT','2022-05-31','2022-05-31 07:31:53','2022-06-01 07:31:53','597',774279.00,774279.00,'597','2022-05-31 19:49:24','664','2022-06-01 07:04:11',10,0),('5','175',257649,'DAILY SHIFT','2022-06-01','2022-06-01 11:26:55','2022-06-02 11:26:55','597',800355.60,800355.60,'597','2022-06-01 20:17:07','664','2022-06-02 05:01:03',10,0),('5','175',257650,'DAILY SHIFT','2022-06-02','2022-06-02 07:05:41','2022-06-03 07:05:41','597',281049.45,281049.45,'597','2022-06-02 21:35:33','664','2022-06-03 06:46:28',10,0),('5','175',257651,'DAILY SHIFT','2022-06-03','2022-06-03 08:04:00','2022-06-04 08:04:00','597',0.00,0.00,'597','2022-06-03 16:27:50','664','2022-06-04 06:06:30',10,0),('5','175',257652,'DAILY SHIFT','2022-06-04','2022-06-04 11:45:41','2022-06-05 11:45:41','597',0.00,0.00,'597','2022-06-04 17:43:28','664','2022-06-05 06:07:16',10,0),('5','175',257653,'DAILY SHIFT','2022-06-05','2022-06-05 09:01:48','2022-06-06 09:01:48','597',0.00,0.00,'597','2022-06-05 20:24:09','664','2022-06-06 06:27:33',10,0),('5','175',257654,'DAILY SHIFT','2022-06-06','2022-06-06 21:48:45','2022-06-07 21:48:45','597',0.00,0.00,'597','2022-06-06 21:49:11','664','2022-06-07 07:26:26',10,0),('5','175',257655,'DAILY SHIFT','2022-06-07','2022-06-07 19:40:21','2022-06-08 19:40:21','597',0.00,0.00,'597','2022-06-07 19:40:50','664','2022-06-08 10:31:41',10,0),('5','175',257656,'DAILY SHIFT','2022-06-08','2022-06-08 21:45:53','2022-06-09 21:45:53','597',0.00,0.00,'597','2022-06-08 21:46:19','664','2022-06-09 06:00:40',10,0),('5','175',257657,'DAILY SHIFT','2022-06-09','2022-06-09 07:55:30','2022-06-10 07:55:30','597',0.00,0.00,'597','2022-06-09 20:54:07','664','2022-06-10 05:28:01',10,0),('5','175',257658,'DAILY SHIFT','2022-06-10','2022-06-10 20:39:11','2022-06-11 20:39:11','597',0.00,0.00,'597','2022-06-10 20:39:29','664','2022-06-10 21:44:57',10,0),('5','175',257659,'DAILY SHIFT','2022-06-11','2022-06-11 18:18:51','2022-06-12 18:18:51','597',0.00,0.00,'597','2022-06-11 18:19:54','664','2022-06-12 08:30:42',10,0),('5','175',257660,'DAILY SHIFT','2022-06-12','2022-06-12 09:09:30','2022-06-13 09:09:30','597',0.00,0.00,'597','2022-06-12 21:27:58','664','2022-06-13 06:54:21',10,0),('5','175',257661,'DAILY SHIFT','2022-06-13','2022-06-13 19:43:28','2022-06-14 19:43:28','597',0.00,0.00,'597','2022-06-13 19:43:54','664','2022-06-14 08:58:30',10,0),('5','175',257662,'DAILY SHIFT','2022-06-14','2022-06-14 19:02:14','2022-06-15 19:02:14','597',0.00,0.00,'597','2022-06-14 19:02:44','664','2022-06-14 22:17:29',10,0),('5','175',257663,'DAILY SHIFT','2022-06-15','2022-06-15 18:26:51','2022-06-16 18:26:51','597',0.00,0.00,'597','2022-06-15 18:27:25','664','2022-06-16 07:02:24',10,0),('5','175',257664,'DAILY SHIFT','2022-06-16','2022-06-16 20:00:41','2022-06-17 20:00:41','597',0.00,0.00,'597','2022-06-16 20:00:58','664','2022-06-17 06:00:22',10,0),('5','175',257665,'DAILY SHIFT','2022-06-17','2022-06-17 19:04:08','2022-06-18 19:04:08','597',0.00,0.00,'597','2022-06-17 19:04:30','664','2022-06-18 07:03:55',10,0),('5','175',257666,'DAILY SHIFT','2022-06-18','2022-06-18 15:45:58','2022-06-19 15:45:58','597',0.00,0.00,'597','2022-06-18 15:46:14','664','2022-06-18 22:47:37',10,0),('5','175',257667,'DAILY SHIFT','2022-06-19','2022-06-19 17:58:49','2022-06-20 17:58:49','597',0.00,0.00,'597','2022-06-19 17:59:13','664','2022-06-20 06:46:40',10,0),('5','175',257668,'DAILY SHIFT','2022-06-20','2022-06-20 20:46:39','2022-06-21 20:46:39','597',0.00,0.00,'597','2022-06-20 20:47:04','664','2022-06-21 07:54:41',10,0),('5','175',257669,'DAILY SHIFT','2022-06-21','2022-06-21 21:03:32','2022-06-22 21:03:32','597',0.00,0.00,'597','2022-06-21 21:03:56','664','2022-06-21 22:46:28',10,0),('5','175',257670,'DAILY SHIFT','2022-06-22','2022-06-22 16:36:34','2022-06-23 16:36:34','597',0.00,0.00,'597','2022-06-22 16:37:00','664','2022-06-23 07:07:11',10,0),('5','175',257671,'DAILY SHIFT','2022-06-23','2022-06-23 10:14:26','2022-06-24 10:14:26','597',0.00,0.00,'597','2022-06-23 19:11:20','664','2022-06-23 22:56:38',10,0),('5','175',257672,'DAILY SHIFT','2022-06-24','2022-06-24 07:30:37','2022-06-25 07:30:37','597',0.00,0.00,'597','2022-06-24 20:04:11','664','2022-06-25 06:14:12',10,0),('5','175',257673,'DAILY SHIFT','2022-06-25','2022-06-25 08:58:16','2022-06-26 08:58:16','597',0.00,0.00,'597','2022-06-25 18:55:42','664','2022-06-26 07:15:33',10,0),('5','175',257674,'DAILY SHIFT','2022-06-26','2022-06-26 08:42:07','2022-06-27 08:42:07','597',0.00,0.00,'597','2022-06-26 17:05:47','664','2022-06-27 07:35:37',10,0),('5','175',257675,'DAILY SHIFT','2022-06-27','2022-06-27 08:32:53','2022-06-28 08:32:53','597',0.00,0.00,'597','2022-06-27 20:02:31','664','2022-06-28 07:22:30',10,0),('5','175',257676,'DAILY SHIFT','2022-06-28','2022-06-28 07:34:55','2022-06-29 07:34:55','597',0.00,0.00,'597','2022-06-28 22:21:39','664','2022-06-29 08:02:29',10,0),('5','175',257677,'DAILY SHIFT','2022-06-29','2022-06-29 08:09:14','2022-06-30 08:09:14','597',0.00,0.00,'597','2022-06-29 21:54:21','664','2022-06-30 06:24:51',10,0),('5','175',257678,'DAILY SHIFT','2022-06-30','2022-06-30 07:50:34','2022-07-01 07:50:34','597',0.00,0.00,'597','2022-06-30 18:07:20','664','2022-07-01 07:10:02',10,0),('5','175',257679,'DAILY SHIFT','2022-07-01','2022-07-01 07:30:09','2022-07-02 07:30:09','597',0.00,0.00,'597','2022-07-01 16:33:44','664','2022-07-02 05:49:09',10,0),('5','175',257680,'DAILY SHIFT','2022-07-02','2022-07-02 07:07:29','2022-07-03 07:07:29','597',0.00,0.00,'597','2022-07-02 20:02:10','664','2022-07-03 06:30:03',10,0),('5','175',257681,'DAILY SHIFT','2022-07-03','2022-07-03 09:31:07','2022-07-04 09:31:07','597',0.00,0.00,'597','2022-07-03 21:55:41','664','2022-07-03 23:25:09',10,0),('5','175',257682,'DAILY SHIFT','2022-07-04','2022-07-04 08:17:31','2022-07-05 08:17:31','597',0.00,0.00,'597','2022-07-04 14:41:22','664','2022-07-04 22:35:37',10,0),('5','175',257683,'DAILY SHIFT','2022-07-05','2022-07-05 06:56:48','2022-07-06 06:56:48','597',0.00,0.00,'597','2022-07-05 13:57:06','664','2022-07-06 07:49:34',10,0),('5','175',257684,'DAILY SHIFT','2022-07-06','2022-07-06 08:52:48','2022-07-07 08:52:48','597',0.00,0.00,'597','2022-07-06 20:56:57','664','2022-07-07 05:27:10',10,0),('5','175',257685,'DAILY SHIFT','2022-07-07','2022-07-07 05:43:41','2022-07-08 05:43:41','597',0.00,0.00,'597','2022-07-07 17:37:14','664','2022-07-08 06:10:54',10,0),('5','175',257686,'DAILY SHIFT','2022-07-08','2022-07-08 06:46:04','2022-07-09 06:46:04','597',0.00,0.00,'597','2022-07-08 20:17:27','664','2022-07-08 22:42:06',10,0),('5','175',257687,'DAILY SHIFT','2022-07-09','2022-07-09 06:28:44','2022-07-10 06:28:44','597',0.00,0.00,'597','2022-07-09 22:04:27','664','2022-07-10 07:04:10',10,0),('5','175',257688,'DAILY SHIFT','2022-07-10','2022-07-10 07:07:04','2022-07-11 07:07:04','597',0.00,0.00,'597','2022-07-10 22:36:53','664','2022-07-11 07:00:48',10,0),('5','175',257689,'DAILY SHIFT','2022-07-11','2022-07-11 07:05:19','2022-07-12 07:05:19','597',0.00,0.00,'597','2022-07-11 19:14:47','664','2022-07-12 05:22:38',10,0),('5','175',257690,'DAILY SHIFT','2022-07-12','2022-07-12 06:55:49','2022-07-13 06:55:49','597',0.00,0.00,'597','2022-07-12 22:03:31','664','2022-07-13 07:18:10',10,0),('5','175',257691,'DAILY SHIFT','2022-07-13','2022-07-13 08:06:47','2022-07-14 08:06:47','597',0.00,0.00,'597','2022-07-13 20:11:09','664','2022-07-14 06:32:46',10,0),('5','175',257692,'DAILY SHIFT','2022-07-14','2022-07-14 07:56:08','2022-07-15 07:56:08','597',0.00,0.00,'597','2022-07-14 22:38:23','664','2022-07-15 07:17:57',10,0),('5','175',257693,'DAILY SHIFT','2022-07-15','2022-07-15 09:43:07','2022-07-16 09:43:07','597',0.00,0.00,'597','2022-07-15 22:44:23','664','2022-07-16 06:53:37',10,0),('5','175',257694,'DAILY SHIFT','2022-07-16','2022-07-16 08:24:30','2022-07-17 08:24:30','597',0.00,0.00,'597','2022-07-16 22:16:41','664','2022-07-17 05:29:31',10,0),('5','175',257695,'DAILY SHIFT','2022-07-17','2022-07-17 08:00:53','2022-07-18 08:00:53','597',219225.00,219225.00,'597','2022-07-18 11:47:24','664','2022-07-18 11:48:27',10,0),('5','175',257696,'DAILY SHIFT','2022-07-18','2022-07-18 11:50:57','2022-07-19 11:50:57','597',930631.40,930631.40,'597','2022-07-19 05:34:46','664','2022-07-19 07:22:03',10,0),('5','175',257697,'DAILY SHIFT','2022-07-19','2022-07-19 07:52:28','2022-07-20 07:52:28','597',648302.90,648302.90,'597','2022-07-19 23:01:04','664','2022-07-20 07:40:10',10,0),('5','175',257698,'DAILY SHIFT','2022-07-20','2022-07-20 08:37:59','2022-07-21 08:37:59','597',997730.90,997730.90,'597','2022-07-20 22:20:14','664','2022-07-21 06:49:11',10,0),('5','175',257699,'DAILY SHIFT','2022-07-21','2022-07-21 07:15:50','2022-07-22 07:15:50','597',823956.70,823956.70,'597','2022-07-21 22:57:36','664','2022-07-21 23:15:21',10,0),('5','175',257700,'DAILY SHIFT','2022-07-22','2022-07-22 08:25:39','2022-07-23 08:25:39','597',828041.50,828041.50,'597','2022-07-22 21:54:39','664','2022-07-23 06:54:53',10,0),('5','175',257701,'DAILY SHIFT','2022-07-23','2022-07-23 07:07:33','2022-07-24 07:07:33','597',777734.45,777734.45,'597','2022-07-23 22:13:06','664','2022-07-24 08:32:16',10,0),('5','175',257702,'DAILY SHIFT','2022-07-24','2022-07-24 10:27:30','2022-07-25 10:27:30','597',810044.70,810044.70,'597','2022-07-24 22:18:26','664','2022-07-25 06:44:43',10,0),('5','175',257703,'DAILY SHIFT','2022-07-25','2022-07-25 08:55:10','2022-07-26 08:55:10','597',656923.90,656923.90,'597','2022-07-26 00:23:26','664','2022-07-26 05:53:45',10,0),('5','175',257704,'DAILY SHIFT','2022-07-26','2022-07-26 08:59:00','2022-07-27 08:59:00','597',572469.55,572469.55,'597','2022-07-27 07:20:55','664','2022-07-27 07:30:12',10,0),('5','175',257705,'DAILY SHIFT','2022-07-27','2022-07-27 08:19:21','2022-07-28 08:19:21','597',742471.60,742471.60,'597','2022-07-27 21:14:16','664','2022-07-28 06:53:54',10,0),('5','175',257706,'DAILY SHIFT','2022-07-28','2022-07-28 10:06:58','2022-07-29 10:06:58','597',290187.30,290187.30,'597','2022-07-28 22:49:28','664','2022-07-29 07:12:22',10,0),('5','175',257707,'DAILY SHIFT','2022-07-29','2022-07-29 07:34:08','2022-07-30 07:34:08','597',0.00,0.00,'597','2022-07-29 22:53:51','664','2022-07-30 05:48:27',10,0),('5','175',257708,'DAILY SHIFT ','2022-07-30','2022-07-30 10:09:29','2022-07-31 10:09:29','597',0.00,0.00,'597','2022-07-30 22:00:33','664','2022-07-31 05:23:03',10,0),('5','175',257709,'DAILY SHIFT','2022-07-31','2022-07-31 11:48:12','2022-08-01 11:48:12','597',0.00,0.00,'597','2022-07-31 21:46:56','664','2022-08-01 07:48:50',10,0),('5','175',257710,'DAILY SHIFT','2022-08-01','2022-08-01 07:57:12','2022-08-02 07:57:12','597',0.00,0.00,'597','2022-08-01 19:51:59','664','2022-08-02 05:38:21',10,0),('5','175',257711,'DAILY SHIFT','2022-08-02','2022-08-02 10:57:07','2022-08-03 10:57:07','597',0.00,0.00,'597','2022-08-02 21:18:22','664','2022-08-03 06:59:13',10,0),('5','175',257712,'DAILY SHIFT','2022-08-03','2022-08-03 08:53:52','2022-08-04 08:53:52','597',0.00,0.00,'597','2022-08-03 18:22:50','664','2022-08-04 06:15:06',10,0),('5','175',257713,'DAILY SHIFT','2022-08-04','2022-08-04 08:08:45','2022-08-05 08:08:45','597',0.00,0.00,'597','2022-08-04 20:49:46','664','2022-08-04 21:55:16',10,0),('5','175',257714,'DAILY SHIFT','2022-08-05','2022-08-05 08:48:49','2022-08-06 08:48:49','597',0.00,0.00,'597','2022-08-05 20:04:28','664','2022-08-06 06:55:56',10,0),('5','175',257715,'DAILY SHIFT','2022-08-06','2022-08-06 08:07:09','2022-08-07 08:07:09','597',0.00,0.00,'597','2022-08-06 20:14:30','664','2022-08-07 05:36:52',10,0),('5','175',257716,'DAILY SHIFT','2022-08-07','2022-08-07 08:16:41','2022-08-08 08:16:41','597',0.00,0.00,'597','2022-08-07 21:47:05','664','2022-09-04 19:39:13',10,0),('5','175',257717,'DAILY SHIFT','2022-09-04','2022-09-04 19:42:05','2022-09-05 19:42:05','597',0.00,0.00,'597','2022-09-04 21:07:20','600','2022-09-05 10:37:08',10,0),('5','175',257718,'DAILY SHIFT','2022-08-08','2022-09-05 10:38:52','2022-09-06 10:38:52','597',0.00,0.00,'597','2022-09-05 10:39:12','664','2022-09-05 10:40:30',10,0),('5','175',257719,'DAILY SHIFT','2022-08-09','2022-09-05 10:41:52','2022-09-06 10:41:52','597',0.00,0.00,'597','2022-09-05 10:42:08','664','2022-09-05 10:43:14',10,0),('5','175',257720,'DAILY SHIFT','2022-08-10','2022-09-05 10:44:01','2022-09-06 10:44:01','597',0.00,0.00,'597','2022-09-05 10:44:29','664','2022-09-05 10:45:10',10,0),('5','175',257721,'DAILY SHIFT','2022-08-11','2022-09-05 10:46:42','2022-09-06 10:46:42','597',0.00,0.00,'597','2022-09-05 10:47:01','664','2022-09-05 10:47:27',10,0),('5','175',257722,'DAILY SHIFT','2022-08-12','2022-09-05 10:48:27','2022-09-06 10:48:27','597',309042.50,309042.50,'597','2022-09-05 11:04:29','664','2022-09-05 11:08:03',10,0),('5','175',257723,'DAILY SHIFT','2022-08-13','2022-09-05 11:08:49','2022-09-06 11:08:49','597',790838.00,790838.00,'597','2022-09-05 11:10:04','664','2022-09-05 11:10:28',10,0),('5','175',257724,'DAILY SHIFT','2022-08-14','2022-09-05 11:11:53','2022-09-06 11:11:53','597',831168.00,831168.00,'597','2022-09-05 11:13:26','664','2022-09-05 11:13:57',10,0),('5','175',257725,'DAILY SHIFT','2022-08-15','2022-09-05 11:14:53','2022-09-06 11:14:53','597',908510.95,908510.95,'597','2022-09-05 11:16:00','664','2022-09-05 11:17:38',10,0),('5','175',257726,'DAILY SHIFT','2022-08-16','2022-09-05 11:18:20','2022-09-06 11:18:20','597',1028381.70,1028381.70,'597','2022-09-05 11:19:18','664','2022-09-05 11:25:00',10,0),('5','175',257727,'DAILY SHIFT','2022-08-17','2022-09-05 11:25:59','2022-09-06 11:25:59','597',849797.50,849797.50,'597','2022-09-05 11:27:42','664','2022-09-05 11:29:03',10,0),('5','175',257728,'DAILY SHIFT','2022-08-18','2022-09-05 11:29:54','2022-09-06 11:29:54','597',1142051.25,1142051.25,'597','2022-09-05 11:31:02','664','2022-09-05 11:33:00',10,0),('5','175',257729,'DAILY SHIFT','2022-08-19','2022-09-05 11:36:52','2022-09-06 11:36:52','597',675697.70,675697.70,'597','2022-09-05 11:38:59','664','2022-09-05 11:40:28',10,0),('5','175',257730,'DAILY SHIFT','2022-08-20','2022-09-05 11:41:53','2022-09-06 11:41:53','597',783384.35,783384.35,'597','2022-09-05 11:43:00','664','2022-09-05 11:45:41',10,0),('5','175',257731,'DAILY SHIFT','2022-08-21','2022-09-05 11:52:59','2022-09-06 11:52:59','597',857915.30,857915.30,'597','2022-09-05 11:54:13','664','2022-09-05 11:55:11',10,0),('5','175',257732,'DAILY SHIFT','2022-08-22','2022-09-05 11:57:04','2022-09-06 11:57:04','597',412200.35,412200.35,'597','2022-09-05 11:58:05','664','2022-09-05 11:58:56',10,0),('5','175',257733,'DAILY SHIFT','2022-08-23','2022-09-05 12:00:20','2022-09-06 12:00:20','597',407111.00,407111.00,'597','2022-09-05 12:01:27','664','2022-09-05 12:04:49',10,0),('5','175',257734,'DAILY SHIFT','2022-08-24','2022-09-05 12:05:46','2022-09-06 12:05:46','597',221889.00,221889.00,'597','2022-09-05 12:07:06','664','2022-09-05 12:07:41',10,0),('5','175',257735,'DAILY SHIFT','2022-08-25','2022-09-05 12:09:54','2022-09-06 12:09:54','597',0.00,0.00,'597','2022-09-05 12:10:13','664','2022-09-05 12:12:27',10,0),('5','175',257736,'DAILY SHIFT','2022-08-26','2022-09-05 12:13:06','2022-09-06 12:13:06','597',0.00,0.00,'597','2022-09-05 12:13:28','664','2022-09-05 12:16:43',10,0),('5','175',257737,'DAILY SHIFT','2022-08-27','2022-09-05 12:17:36','2022-09-06 12:17:36','597',0.00,0.00,'597','2022-09-05 12:17:54','664','2022-09-05 12:20:39',10,0),('5','175',257738,'DAILY SHIFT','2022-08-28','2022-09-05 12:21:19','2022-09-06 12:21:19','597',0.00,0.00,'597','2022-09-05 12:21:38','664','2022-09-05 12:22:27',10,0),('5','175',257739,'DAILY SHIFT','2022-08-29','2022-09-05 12:23:48','2022-09-06 12:23:48','597',0.00,0.00,'597','2022-09-05 12:24:04','664','2022-09-05 12:28:31',10,0),('5','175',257740,'DAILY SHIFT','2022-08-30','2022-09-05 12:31:31','2022-09-06 12:31:31','597',0.00,0.00,'597','2022-09-05 12:31:49','664','2022-09-05 12:33:21',10,0),('5','175',257741,'DAILY SHIFT','2022-08-31','2022-09-05 12:34:58','2022-09-06 12:34:58','597',0.00,0.00,'597','2022-09-05 12:35:14','664','2022-09-05 12:36:39',10,0),('5','175',257742,'DAILY SHIFT','2022-09-01','2022-09-05 12:37:21','2022-09-06 12:37:21','597',0.00,0.00,'597','2022-09-05 12:37:41','664','2022-09-05 12:40:42',10,0),('5','175',257743,'DAILY SHIFT','2022-09-02','2022-09-05 12:44:03','2022-09-06 12:44:03','597',0.00,0.00,'597','2022-09-05 12:44:21','664','2022-09-05 12:46:00',10,0),('5','175',257744,'DAILY SHIFT','2022-09-03','2022-09-05 12:48:15','2022-09-06 12:48:15','597',0.00,0.00,'597','2022-09-05 12:48:33','664','2022-09-05 12:49:29',10,0),('5','175',257745,'DAILY SHIFT','2022-09-04','2022-09-05 12:50:24','2022-09-06 12:50:24','597',0.00,0.00,'597','2022-09-05 12:50:42','664','2022-09-05 13:08:48',10,0),('5','175',257746,'DAILY SHIFT','2022-09-05','2022-09-05 13:12:08','2022-09-06 13:12:08','597',493210.00,493210.00,'597','2022-09-06 07:38:27','664','2022-09-06 10:27:57',10,0),('5','175',257747,'DAILY SHIFT','2022-09-06','2022-09-06 10:54:13','2022-09-07 10:54:13','597',1111862.95,1111862.95,'597','2022-09-07 07:41:24','664','2022-09-07 08:24:35',10,0),('5','175',257748,'DAILY SHIFT','2022-09-07','2022-09-07 09:49:12','2022-09-08 09:49:12','597',917601.85,917601.85,'597','2022-09-07 20:56:53','664','2022-09-08 07:10:42',10,0),('5','175',257749,'DAILY SHIFT','2022-09-08','2022-09-08 07:48:42','2022-09-09 07:48:42','597',988934.15,988934.15,'597','2022-09-08 20:34:46','664','2022-09-09 08:18:03',10,0),('5','175',257750,'DAILY SHIFT','2022-09-09','2022-09-10 05:10:13','2022-09-11 05:10:13','597',665864.95,665864.95,'597','2022-09-10 05:11:20','664','2022-09-10 09:39:38',10,0),('5','175',257751,'DAILY SHIFT','2022-09-10','2022-09-10 11:07:43','2022-09-11 11:07:43','597',772606.25,772606.25,'597','2022-09-10 21:37:38','664','2022-09-11 08:55:58',10,0),('5','175',257752,'DAILY SHIFT','2022-09-11','2022-09-11 10:43:27','2022-09-12 10:43:27','597',782847.85,782847.85,'597','2022-09-12 05:59:48','664','2022-09-12 08:56:15',10,0),('5','175',257753,'DAILY SHIFT','2022-09-12','2022-09-12 13:08:06','2022-09-13 13:08:06','597',833663.65,833663.65,'597','2022-09-12 21:37:44','664','2022-09-13 09:15:19',10,0),('5','175',257754,'DAILY SHIFT','2022-09-13','2022-09-13 09:31:18','2022-09-14 09:31:18','597',744810.00,744810.00,'597','2022-09-13 20:29:22','664','2022-09-14 08:14:09',10,0),('5','175',257755,'DAILY SHIFT','2022-09-14','2022-09-14 11:04:04','2022-09-15 11:04:04','597',659902.40,659902.40,'597','2022-09-14 22:25:18','664','2022-09-15 08:52:10',10,0),('5','175',257756,'DAILY SHIFT','2022-09-15','2022-09-15 21:04:13','2022-09-16 21:04:13','597',405941.80,405941.80,'597','2022-09-15 21:11:38','664','2022-09-16 09:08:55',10,0),('5','175',257757,'DAILY SHIFT','2022-09-16','2022-09-17 10:40:13','2022-09-18 10:40:13','597',218386.95,218386.95,'597','2022-09-17 10:41:14','664','2022-09-17 10:42:22',10,0),('5','175',257758,'DAILY SHIFT','2022-09-17','2022-09-17 10:47:55','2022-09-18 10:47:55','597',773135.35,773135.35,'597','2022-09-17 20:46:38','664','2022-09-18 07:21:33',10,0),('5','175',257759,'DAILY SHIFT','2022-09-18','2022-09-18 10:08:22','2022-09-19 10:08:22','597',791326.40,791326.40,'597','2022-09-18 20:18:43','664','2022-09-19 07:20:02',10,0),('5','175',257760,'DAILY SHIFT','2022-09-19','2022-09-19 17:39:49','2022-09-20 17:39:49','597',820582.30,820582.30,'597','2022-09-19 19:45:31','664','2022-09-20 08:33:02',10,0),('5','175',257761,'DAILY SHIFT','2022-09-20','2022-09-20 11:46:28','2022-09-21 11:46:28','597',808760.80,808760.80,'597','2022-09-20 22:23:46','664','2022-09-21 11:51:21',10,0),('5','175',257762,'DAILY SHIFT','2022-09-21','2022-09-21 14:43:09','2022-09-22 14:43:09','597',677492.20,677492.20,'597','2022-09-21 21:02:06','664','2022-09-22 07:39:26',10,0),('5','175',257763,'DAILY SHIFT','2022-09-22','2022-09-22 13:03:29','2022-09-23 13:03:29','597',649122.45,649122.45,'597','2022-09-22 21:47:46','664','2022-09-23 07:49:51',10,0),('5','175',257764,'DAILY SHIFT','2022-09-23','2022-09-23 09:29:49','2022-09-24 09:29:49','597',677033.40,677033.40,'597','2022-09-23 21:29:34','664','2022-09-23 22:38:54',10,0),('5','175',257765,'DAILY SHIFT','2022-09-24','2022-09-24 10:49:36','2022-09-25 10:49:36','597',765646.55,765646.55,'597','2022-09-24 21:16:42','664','2022-09-25 08:04:58',10,0),('5','175',257766,'DAILY SHIFT','2022-09-25','2022-09-25 08:25:43','2022-09-26 08:25:43','597',709639.65,709639.65,'597','2022-09-26 05:20:50','664','2022-09-26 07:17:57',10,0),('5','175',257767,'DAILY SHIFT','2022-09-26','2022-09-26 20:04:45','2022-09-27 20:04:45','597',726970.45,726970.45,'597','2022-09-26 20:06:05','664','2022-09-27 07:25:13',10,0),('5','175',257768,'DAILY SHIFT','2022-09-27','2022-09-27 15:00:53','2022-09-28 15:00:53','597',661097.50,661097.50,'597','2022-09-27 19:56:58','664','2022-09-28 08:23:37',10,0),('5','175',257769,'DAILY SHIFT','2022-09-28','2022-09-28 18:23:51','2022-09-29 18:23:51','597',0.00,0.00,'597','2022-09-28 18:24:25','664','2022-09-29 08:35:39',10,0),('5','175',257770,'DAILY SHIFT','2022-09-29','2022-09-29 09:06:37','2022-09-30 09:06:37','597',0.00,0.00,'597','2022-09-29 13:12:53','664','2022-09-30 08:10:03',10,0),('5','175',257771,'DAILY SHIFT','2022-09-30','2022-09-30 09:12:56','2022-10-01 09:12:56','597',0.00,0.00,'597','2022-09-30 09:13:19','664','2022-09-30 21:49:56',10,0),('5','175',257772,'DAILY SHIFT','2022-10-01','2022-10-01 08:44:27','2022-10-02 08:44:27','597',0.00,0.00,'597','2022-10-01 12:02:19','664','2022-10-02 06:43:35',10,0),('5','175',257773,'DAILY SHIFT','2022-10-02','2022-10-02 16:48:15','2022-10-03 16:48:15','597',0.00,0.00,'597','2022-10-02 17:55:03','664','2022-10-03 06:25:05',10,0),('5','175',257774,'DAILY SHIFT','2022-10-03','2022-10-03 22:33:02','2022-10-04 22:33:02','597',0.00,0.00,'597','2022-10-03 22:33:22','664','2022-10-04 07:12:14',10,0),('5','175',257775,'DAILY SHIFT','2022-10-04','2022-10-04 07:17:04','2022-10-05 07:17:04','597',0.00,0.00,'597','2022-10-04 19:37:21','664','2022-10-05 09:40:07',10,0),('5','175',257776,'DAILY SHIFT','2022-10-05','2022-10-05 21:22:57','2022-10-06 21:22:57','597',0.00,0.00,'597','2022-10-05 21:23:26','664','2022-10-06 07:59:46',10,0),('5','175',257777,'DAILY SHIFT','2022-10-06','2022-10-06 21:10:49','2022-10-07 21:10:49','597',0.00,0.00,'597','2022-10-06 21:11:09','664','2022-10-06 21:18:12',10,0),('5','175',257778,'DAILY SHIFT','2022-10-07','2022-10-07 07:52:45','2022-10-08 07:52:45','597',0.00,0.00,'597','2022-10-07 16:12:50','664','2022-10-08 08:37:17',10,0),('5','175',257779,'DAILY SHIFT','2022-10-08','2022-10-08 17:13:44','2022-10-09 17:13:44','597',0.00,0.00,'597','2022-10-08 17:14:15','664','2022-10-09 08:31:37',10,0),('5','175',257780,'DAILY SHIFT','2022-10-09','2022-10-10 07:46:39','2022-10-11 07:46:39','597',0.00,0.00,'597','2022-10-10 07:47:04','664','2022-10-10 12:15:28',10,0),('5','175',257781,'DAILY SHIFT','2022-10-10','2022-10-10 14:15:30','2022-10-11 14:15:30','597',0.00,0.00,'597','2022-10-10 14:15:58','664','2022-10-11 07:05:46',10,0),('5','175',257782,'DAILY SHIFT','2022-10-11','2022-10-11 14:43:21','2022-10-12 14:43:21','597',0.00,0.00,'597','2022-10-11 14:43:46','664','2022-10-12 10:04:54',10,0),('5','175',257783,'DAILY SHIFT','2022-10-12','2022-10-12 17:45:38','2022-10-13 17:45:38','597',0.00,0.00,'597','2022-10-12 17:46:00','664','2022-10-12 22:15:59',10,0),('5','175',257784,'DAILY SHIFT','2022-10-13','2022-10-13 06:53:02','2022-10-14 06:53:02','597',0.00,0.00,'597','2022-10-13 16:18:39','664','2022-10-14 07:32:38',10,0),('5','175',257785,'DAILY SHIFT','2022-10-14','2022-10-14 19:18:36','2022-10-15 19:18:36','597',0.00,0.00,'597','2022-10-14 19:19:05','664','2022-10-15 06:23:20',10,0),('5','175',257786,'DAILY SHIFT','2022-10-15','2022-10-15 12:31:05','2022-10-16 12:31:05','597',0.00,0.00,'597','2022-10-15 12:32:18','664','2022-10-15 20:32:15',10,0),('5','175',257787,'DAILY SHIFT','2022-10-16','2022-10-16 14:52:10','2022-10-17 14:52:10','597',0.00,0.00,'597','2022-10-16 14:52:42','664','2022-10-17 07:37:28',10,0),('5','175',257788,'DAILY SHIFT','2022-10-17','2022-10-17 12:17:48','2022-10-18 12:17:48','597',0.00,0.00,'597','2022-10-17 20:32:23','664','2022-10-18 07:44:57',10,0),('5','175',257789,'DAILY SHIFT','2022-10-18','2022-10-18 16:41:04','2022-10-19 16:41:04','597',0.00,0.00,'597','2022-10-18 16:41:21','664','2022-10-19 07:38:45',10,0),('5','175',257790,'DAILY SHIFT','2022-10-19','2022-10-20 09:07:31','2022-10-21 09:07:31','597',0.00,0.00,'597','2022-10-20 09:07:51','664','2022-10-20 09:09:26',10,0),('5','175',257791,'DAILY SHIFT','2022-10-20','2022-10-20 16:29:32','2022-10-21 16:29:32','597',0.00,0.00,'597','2022-10-20 17:22:14','664','2022-10-21 07:44:13',10,0),('5','175',257792,'DAILY SHIFT','2022-10-21','2022-10-21 14:36:01','2022-10-22 14:36:01','597',0.00,0.00,'597','2022-10-21 14:37:18','664','2022-10-22 06:17:24',10,0),('5','175',257793,'DAILY SHIFT','2022-10-22','2022-10-22 12:59:39','2022-10-23 12:59:39','597',0.00,0.00,'597','2022-10-22 13:03:11','664','2022-10-23 08:12:35',10,0),('5','175',257794,'DAILY SHIFT','2022-10-23','2022-10-23 17:05:19','2022-10-24 17:05:19','597',0.00,0.00,'597','2022-10-23 17:06:31','664','2022-10-24 07:24:29',10,0),('5','175',257795,'DAILY SHIFT','2022-10-24','2022-10-24 11:53:15','2022-10-25 11:53:15','597',0.00,0.00,'597','2022-10-24 11:53:41','664','2022-10-25 07:23:22',10,0),('5','175',257796,'DAILY SHIFT','2022-10-25','2022-10-25 15:25:55','2022-10-26 15:25:55','597',0.00,0.00,'597','2022-10-25 15:26:18','664','2022-10-26 07:23:56',10,0),('5','175',257797,'DAILY SHIFT','2022-10-26','2022-10-26 09:57:17','2022-10-27 09:57:17','597',0.00,0.00,'597','2022-10-27 09:39:26','664','2022-10-27 09:58:20',10,0),('5','175',257798,'DAILY SHIFT','2022-10-27','2022-10-27 21:51:42','2022-10-28 21:51:42','597',0.00,0.00,'597','2022-10-27 21:52:07','664','2022-10-28 06:54:44',10,0),('5','175',257799,'DAILY SHIFT','2022-10-28','2022-10-28 14:27:16','2022-10-29 14:27:16','597',0.00,0.00,'597','2022-10-28 14:28:06','664','2022-10-29 07:56:22',10,0),('5','175',257800,'DAILY SHIFT','2022-10-29','2022-10-29 20:57:41','2022-10-30 20:57:41','597',0.00,0.00,'597','2022-10-29 20:59:02','664','2022-10-30 06:36:59',10,0),('5','175',257801,'DAILY SHIFT','2022-10-30','2022-10-30 07:25:04','2022-10-31 07:25:04','597',0.00,0.00,'597','2022-10-30 18:05:18','664','2022-10-31 06:46:19',10,0),('5','175',257802,'DAILY SHIFT','2022-10-31','2022-10-31 06:55:05','2022-11-01 06:55:05','597',0.00,0.00,'597','2022-10-31 18:43:11','664','2022-11-01 06:42:19',10,0),('5','175',257803,'DAILY SHIFT','2022-11-01','2022-11-01 21:15:21','2022-11-02 21:15:21','597',0.00,0.00,'597','2022-11-01 21:15:42','664','2022-11-02 06:28:36',10,0),('5','175',257804,'DAILY SHIFT','2022-11-02','2022-11-02 10:07:30','2022-11-03 10:07:30','597',0.00,0.00,'597','2022-11-02 19:05:58','664','2022-11-03 08:16:21',10,0),('5','175',257805,'DAILY SHIFT','2022-11-03','2022-11-03 18:45:55','2022-11-04 18:45:55','597',0.00,0.00,'597','2022-11-03 18:46:23','664','2022-11-04 07:33:45',10,0),('5','175',257806,'DAILY SHIFT','2022-11-05','2022-11-05 20:59:24','2022-11-06 20:59:24','597',0.00,0.00,'597','2022-11-05 20:59:58','664','2022-11-06 07:09:30',10,0),('5','175',257807,'DAILY SHIFT','2022-11-06','2022-11-06 09:32:25','2022-11-07 09:32:25','597',0.00,0.00,'597','2022-11-07 11:15:47','664','2022-11-08 07:11:54',10,0),('5','175',257808,'DAILY SHIFT','2022-11-07','2022-11-08 07:26:50','2022-11-09 07:26:50','597',0.00,0.00,'597','2022-11-08 07:27:16','664','2022-11-09 08:13:34',10,0),('5','175',257809,'DAILY SHIFT','2022-11-08','2022-11-09 22:31:18','2022-11-10 22:31:18','597',0.00,0.00,'597','2022-11-09 22:31:50','664','2022-11-10 09:29:43',10,0),('5','175',257810,'DAILY SHIFT','2022-11-09','2022-11-10 22:10:30','2022-11-11 22:10:30','597',0.00,0.00,'597','2022-11-10 22:10:46','664','2022-11-11 07:53:24',10,0),('5','175',257811,'DAILY SHIFT','2022-11-10','2022-11-17 10:53:02','2022-11-18 10:53:02','597',0.00,0.00,'597','2022-11-17 10:53:31','1013','2022-12-14 09:50:32',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905403 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','175','908','181515',3565036,'2689','403',0.00,541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','181515',3565037,'2690','403',0.00,497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181515',3565038,'2691','403',0.00,305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181515',3565039,'2692','403',0.00,235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','181515',3565040,'2693','404',0.00,291151.64,291151.64,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','181546',3565330,'2689','403',541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','181546',3565331,'2690','403',497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181546',3565332,'2691','403',305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181546',3565333,'2692','403',235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','181546',3565334,'2693','404',291151.64,292274.58,1122.94,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','181713',3568198,'2689','403',541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','181713',3568199,'2690','403',497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181713',3568200,'2691','403',305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','181713',3568201,'2692','403',235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','181713',3568202,'2693','404',292274.58,294579.64,2305.06,576265.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','182007',3573472,'2689','403',541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','182007',3573473,'2690','403',497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182007',3573474,'2691','403',305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182007',3573475,'2692','403',235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','182007',3573476,'2693','404',294579.64,295669.52,1089.88,272470.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','182143',3575954,'2689','403',541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','182143',3575955,'2690','403',497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182143',3575956,'2691','403',305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182143',3575957,'2692','403',235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','182143',3575958,'2693','404',295669.52,295877.21,207.69,51922.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','182682',3585807,'2689','403',541907.21,541907.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','182682',3585808,'2690','403',497719.02,497719.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182682',3585809,'2691','403',305272.30,305272.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','182682',3585810,'2692','403',235881.05,235881.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','182682',3585811,'2693','404',295877.21,297543.62,1666.41,416602.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','182884',3589553,'2689','403',541907.21,544330.32,2423.11,394966.93,0.00,0.00,0.00,0.00,0.00),('5','175','908','182884',3589554,'2690','403',497719.02,498127.00,407.98,66500.74,0.00,0.00,0.00,0.00,0.00),('5','175','909','182884',3589555,'2691','403',305272.30,306884.47,1612.17,262783.71,0.00,0.00,0.00,0.00,0.00),('5','175','909','182884',3589556,'2692','403',235881.05,236571.18,690.13,112491.19,0.00,0.00,0.00,0.00,0.00),('5','175','910','182884',3589557,'2693','404',297543.62,298575.16,1031.54,273358.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','183000',3591617,'2689','403',544330.32,547282.50,2952.18,481205.34,0.00,0.00,0.00,0.00,0.00),('5','175','908','183000',3591618,'2690','403',498127.00,500912.55,2785.55,454044.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','183000',3591619,'2691','403',306884.47,309836.58,2952.11,481193.93,0.00,0.00,0.00,0.00,0.00),('5','175','909','183000',3591620,'2692','403',236571.18,238848.20,2277.02,371154.26,0.00,0.00,0.00,0.00,0.00),('5','175','910','183000',3591621,'2693','404',298575.16,299451.97,876.81,232354.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','183231',3595779,'2689','403',547282.50,550239.19,2956.69,481940.47,0.00,0.00,0.00,0.00,0.00),('5','175','908','183231',3595780,'2690','403',500912.55,503504.20,2591.65,422438.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','183231',3595781,'2691','403',309836.58,313378.33,3541.75,577305.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','183231',3595782,'2692','403',238848.20,242780.53,3932.33,640969.79,0.00,0.00,0.00,0.00,0.00),('5','175','910','183231',3595783,'2693','404',299451.97,300713.81,1261.84,334387.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','183433',3599433,'2689','403',550239.19,556725.51,6486.32,1057270.16,0.00,0.00,0.00,0.00,0.00),('5','175','908','183433',3599434,'2690','403',503504.20,509095.89,5591.69,911445.47,0.00,0.00,0.00,0.00,0.00),('5','175','909','183433',3599435,'2691','403',313378.33,313378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','183433',3599436,'2692','403',242780.53,242780.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','183433',3599437,'2693','404',300713.81,302766.88,2053.07,544063.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','183676',3603806,'2689','403',556725.51,562761.63,6036.12,983887.56,0.00,0.00,0.00,0.00,0.00),('5','175','908','183676',3603807,'2690','403',509095.89,514693.93,5598.04,912480.52,0.00,0.00,0.00,0.00,0.00),('5','175','909','183676',3603808,'2691','403',313378.33,313378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','183676',3603809,'2692','403',242780.53,242780.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','183676',3603810,'2693','404',302766.88,303233.88,467.00,123755.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','183972',3609369,'2689','403',562761.63,567006.29,4244.66,691879.58,0.00,0.00,0.00,0.00,0.00),('5','175','908','183972',3609370,'2690','403',514693.93,518014.72,3320.79,541288.77,0.00,0.00,0.00,0.00,0.00),('5','175','909','183972',3609371,'2691','403',313378.33,313378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','183972',3609372,'2692','403',242780.53,242780.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','183972',3609373,'2693','404',303233.88,305173.75,1939.87,494666.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','184122',3611995,'2689','403',567006.29,567006.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','184122',3611996,'2690','403',518014.72,518014.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','184122',3611997,'2691','403',313378.33,313378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','184122',3611998,'2692','403',242780.53,242780.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','184122',3611999,'2693','404',305173.75,306703.16,1529.41,389999.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','184311',3615135,'2689','403',567006.29,567006.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','184311',3615136,'2690','403',518014.72,518014.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','184311',3615137,'2691','403',313378.33,313378.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','184311',3615138,'2692','403',242780.53,242780.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','184311',3615139,'2693','404',306703.16,308808.72,2105.56,536917.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','184501',3618536,'2689','403',567006.29,570397.12,3390.83,552705.29,0.00,0.00,0.00,0.00,0.00),('5','175','908','184501',3618537,'2690','403',518014.72,519629.98,1615.26,263287.38,0.00,0.00,0.00,0.00,0.00),('5','175','909','184501',3618538,'2691','403',313378.33,316245.53,2867.20,467353.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','184501',3618539,'2692','403',242780.53,245165.22,2384.69,388704.47,0.00,0.00,0.00,0.00,0.00),('5','175','910','184501',3618540,'2693','404',308808.72,308808.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','184607',3620746,'2689','403',570397.12,572466.65,2069.53,335263.86,0.00,0.00,0.00,0.00,0.00),('5','175','908','184607',3620747,'2690','403',519629.98,520738.19,1108.21,179530.02,0.00,0.00,0.00,0.00,0.00),('5','175','909','184607',3620748,'2691','403',316245.53,318280.26,2034.73,329626.26,0.00,0.00,0.00,0.00,0.00),('5','175','909','184607',3620749,'2692','403',245165.22,247077.78,1912.56,309834.72,0.00,0.00,0.00,0.00,0.00),('5','175','910','184607',3620750,'2693','404',308808.72,310975.23,2166.51,552460.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','184733',3622859,'2689','403',572466.65,574789.60,2322.95,376317.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','184733',3622860,'2690','403',520738.19,526209.51,5471.32,886353.84,0.00,0.00,0.00,0.00,0.00),('5','175','909','184733',3622861,'2691','403',318280.26,322303.73,4023.47,651802.14,0.00,0.00,0.00,0.00,0.00),('5','175','909','184733',3622862,'2692','403',247077.78,247404.13,326.35,52868.70,0.00,0.00,0.00,0.00,0.00),('5','175','910','184733',3622863,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','184919',3626196,'2689','403',574789.60,580819.66,6030.06,982899.78,0.00,0.00,0.00,0.00,0.00),('5','175','908','184919',3626197,'2690','403',526209.51,530701.71,4492.20,732228.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','184919',3626198,'2691','403',322303.73,322303.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','184919',3626199,'2692','403',247404.13,247404.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','184919',3626200,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','185520',3636646,'2689','403',580819.66,580819.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','185520',3636647,'2690','403',530701.71,530701.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','185520',3636648,'2691','403',322303.73,327135.48,4831.75,787575.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','185520',3636649,'2692','403',247404.13,251315.31,3911.18,637522.34,0.00,0.00,0.00,0.00,0.00),('5','175','910','185520',3636650,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','185675',3639526,'2689','403',580819.66,586310.53,5490.87,895011.81,0.00,0.00,0.00,0.00,0.00),('5','175','908','185675',3639527,'2690','403',530701.71,530929.20,227.49,37080.87,0.00,0.00,0.00,0.00,0.00),('5','175','909','185675',3639528,'2691','403',327135.48,329717.93,2582.45,420939.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','185675',3639529,'2692','403',251315.31,253519.84,2204.53,359338.39,0.00,0.00,0.00,0.00,0.00),('5','175','910','185675',3639530,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','185889',3643265,'2689','403',586310.53,592299.59,5989.06,976216.78,0.00,0.00,0.00,0.00,0.00),('5','175','908','185889',3643266,'2690','403',530929.20,533145.83,2216.63,361310.69,0.00,0.00,0.00,0.00,0.00),('5','175','909','185889',3643267,'2691','403',329717.93,332782.48,3064.55,499521.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','185889',3643268,'2692','403',253519.84,256798.04,3278.20,534346.60,0.00,0.00,0.00,0.00,0.00),('5','175','910','185889',3643269,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','186096',3647105,'2689','403',592299.59,598304.84,6005.25,978855.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','186096',3647106,'2690','403',533145.83,534157.27,1011.44,164864.72,0.00,0.00,0.00,0.00,0.00),('5','175','909','186096',3647107,'2691','403',332782.48,337370.66,4588.18,747873.34,0.00,0.00,0.00,0.00,0.00),('5','175','909','186096',3647108,'2692','403',256798.04,258912.88,2114.84,344718.92,0.00,0.00,0.00,0.00,0.00),('5','175','910','186096',3647109,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','186347',3651089,'2689','403',598304.84,605755.28,7450.44,1214421.72,0.00,0.00,0.00,0.00,0.00),('5','175','908','186347',3651090,'2690','403',534157.27,534846.78,689.51,112390.13,0.00,0.00,0.00,0.00,0.00),('5','175','909','186347',3651091,'2691','403',337370.66,341329.16,3958.50,645235.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','186347',3651092,'2692','403',258912.88,259968.25,1055.37,172025.31,0.00,0.00,0.00,0.00,0.00),('5','175','910','186347',3651093,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','186569',3654942,'2689','403',605755.28,608394.02,2638.74,430114.62,0.00,0.00,0.00,0.00,0.00),('5','175','908','186569',3654943,'2690','403',534846.78,536628.02,1781.24,290342.12,0.00,0.00,0.00,0.00,0.00),('5','175','909','186569',3654944,'2691','403',341329.16,341329.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','186569',3654945,'2692','403',259968.25,259968.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','186569',3654946,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','187189',3665437,'2689','403',608394.02,612678.62,4284.60,698389.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','187189',3665438,'2690','403',536628.02,539376.61,2748.59,448020.17,0.00,0.00,0.00,0.00,0.00),('5','175','909','187189',3665439,'2691','403',341329.16,345743.75,4414.59,719578.17,0.00,0.00,0.00,0.00,0.00),('5','175','909','187189',3665440,'2692','403',259968.25,261486.19,1517.94,247424.22,0.00,0.00,0.00,0.00,0.00),('5','175','910','187189',3665441,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','187401',3669327,'2689','403',612678.62,617226.27,4547.65,741266.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','187401',3669328,'2690','403',539376.61,541413.45,2036.84,332004.92,0.00,0.00,0.00,0.00,0.00),('5','175','909','187401',3669329,'2691','403',345743.75,348711.30,2967.55,483710.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','187401',3669330,'2692','403',261486.19,263642.02,2155.83,351400.29,0.00,0.00,0.00,0.00,0.00),('5','175','910','187401',3669331,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','187635',3673441,'2689','403',617226.27,623601.23,6374.96,1039118.48,0.00,0.00,0.00,0.00,0.00),('5','175','908','187635',3673442,'2690','403',541413.45,543448.17,2034.72,331659.36,0.00,0.00,0.00,0.00,0.00),('5','175','909','187635',3673443,'2691','403',348711.30,352295.19,3583.89,584174.07,0.00,0.00,0.00,0.00,0.00),('5','175','909','187635',3673444,'2692','403',263642.02,263980.94,338.92,55243.96,0.00,0.00,0.00,0.00,0.00),('5','175','910','187635',3673445,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','187828',3676821,'2689','403',623601.23,628249.74,4648.51,757707.13,0.00,0.00,0.00,0.00,0.00),('5','175','908','187828',3676822,'2690','403',543448.17,546891.65,3443.48,561287.24,0.00,0.00,0.00,0.00,0.00),('5','175','909','187828',3676823,'2691','403',352295.19,352295.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','187828',3676824,'2692','403',263980.94,263980.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','187828',3676825,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','188009',3680179,'2689','403',628249.74,631543.16,3293.42,536827.46,0.00,0.00,0.00,0.00,0.00),('5','175','908','188009',3680180,'2690','403',546891.65,551169.79,4278.14,697336.82,0.00,0.00,0.00,0.00,0.00),('5','175','909','188009',3680181,'2691','403',352295.19,355910.91,3615.72,589362.36,0.00,0.00,0.00,0.00,0.00),('5','175','909','188009',3680182,'2692','403',263980.94,266864.56,2883.62,470030.06,0.00,0.00,0.00,0.00,0.00),('5','175','910','188009',3680183,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','188265',3684481,'2689','403',631543.16,637951.61,6408.45,1044577.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','188265',3684482,'2690','403',551169.79,552938.41,1768.62,288285.06,0.00,0.00,0.00,0.00,0.00),('5','175','909','188265',3684483,'2691','403',355910.91,358708.32,2797.41,455977.83,0.00,0.00,0.00,0.00,0.00),('5','175','909','188265',3684484,'2692','403',266864.56,270264.09,3399.53,554123.39,0.00,0.00,0.00,0.00,0.00),('5','175','910','188265',3684485,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','188438',3687343,'2689','403',637951.61,639803.43,1851.82,301846.66,0.00,0.00,0.00,0.00,0.00),('5','175','908','188438',3687344,'2690','403',552938.41,554949.87,2011.46,327867.98,0.00,0.00,0.00,0.00,0.00),('5','175','909','188438',3687345,'2691','403',358708.32,365024.45,6316.13,1029529.19,0.00,0.00,0.00,0.00,0.00),('5','175','909','188438',3687346,'2692','403',270264.09,273741.32,3477.23,566788.49,0.00,0.00,0.00,0.00,0.00),('5','175','910','188438',3687347,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','188621',3690614,'2689','403',639803.43,641698.08,1894.65,308827.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','188621',3690615,'2690','403',554949.87,556244.21,1294.34,210977.42,0.00,0.00,0.00,0.00,0.00),('5','175','909','188621',3690616,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','188621',3690617,'2692','403',273741.32,273885.01,143.69,23421.47,0.00,0.00,0.00,0.00,0.00),('5','175','910','188621',3690618,'2693','404',310975.23,310975.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','189509',3706570,'2689','403',641698.08,641698.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','189509',3706571,'2690','403',556244.21,556244.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','189509',3706572,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','189509',3706573,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','189509',3706574,'2693','404',310975.23,312590.87,1615.64,428144.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','189615',3708448,'2689','403',641698.08,641698.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','189615',3708449,'2690','403',556244.21,556244.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','189615',3708450,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','189615',3708451,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','189615',3708452,'2693','404',312590.87,314243.95,1653.08,438066.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','189875',3712771,'2689','403',641698.08,642984.93,1286.85,212330.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','189875',3712772,'2690','403',556244.21,557103.96,859.75,141858.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','189875',3712773,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','189875',3712774,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','189875',3712775,'2693','404',314243.95,315086.92,842.97,223387.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','190074',3716950,'2689','403',642984.93,649575.30,6590.37,1087411.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','190074',3716951,'2690','403',557103.96,563426.70,6322.74,1043252.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','190074',3716952,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190074',3716953,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','190074',3716954,'2693','404',315086.92,316558.90,1471.98,390074.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','190232',3719941,'2689','403',649575.30,655441.29,5865.99,967888.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','190232',3719942,'2690','403',563426.70,568703.23,5276.53,870627.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','190232',3719943,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190232',3719944,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','190232',3719945,'2693','404',316558.90,318573.68,2014.78,533916.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','190438',3723810,'2689','403',655441.29,660605.65,5164.36,852119.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','190438',3723811,'2690','403',568703.23,572500.34,3797.11,626523.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','190438',3723812,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190438',3723813,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','190438',3723814,'2693','404',318573.68,320147.82,1574.14,417147.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','190704',3728699,'2689','403',660605.65,663048.98,2443.33,403149.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','190704',3728700,'2690','403',572500.34,574738.17,2237.83,369241.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','190704',3728701,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190704',3728702,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','190704',3728703,'2693','404',320147.82,321492.04,1344.22,356218.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','190921',3732572,'2689','403',663048.98,663048.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','190921',3732573,'2690','403',574738.17,574738.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190921',3732574,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','190921',3732575,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','190921',3732576,'2693','404',321492.04,322581.80,1089.76,288786.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','191102',3735801,'2689','403',663048.98,664669.13,1620.15,267324.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','191102',3735802,'2690','403',574738.17,576713.21,1975.04,325881.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','191102',3735803,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','191102',3735804,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','191102',3735805,'2693','404',322581.80,323852.24,1270.44,336666.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','191280',3739181,'2689','403',664669.13,670905.30,6236.17,1028968.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','191280',3739182,'2690','403',576713.21,582207.04,5493.83,906481.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','191280',3739183,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','191280',3739184,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','191280',3739185,'2693','404',323852.24,325050.06,1197.82,317422.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','191505',3743014,'2689','403',670905.30,676153.94,5248.64,866025.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','191505',3743015,'2690','403',582207.04,587209.09,5002.05,825338.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','191505',3743016,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','191505',3743017,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','191505',3743018,'2693','404',325050.06,325983.46,933.40,247351.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','191709',3747182,'2689','403',676153.94,681282.07,5128.13,846141.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','191709',3747183,'2690','403',587209.09,592289.59,5080.50,838282.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','191709',3747184,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','191709',3747185,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','191709',3747186,'2693','404',325983.46,325983.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','191947',3751661,'2689','403',681282.07,683808.99,2526.92,416941.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','191947',3751662,'2690','403',592289.59,594353.75,2064.16,340586.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','191947',3751663,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','191947',3751664,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','191947',3751665,'2693','404',325983.46,325983.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','193209',3774587,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','193209',3774588,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193209',3774589,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193209',3774590,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','193209',3774591,'2693','404',325983.46,328061.48,2078.02,550675.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','193408',3778848,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','193408',3778849,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193408',3778850,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193408',3778851,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','193408',3778852,'2693','404',328061.48,329051.10,989.62,262249.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','193640',3782989,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','193640',3782990,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193640',3782991,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193640',3782992,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','193640',3782993,'2693','404',329051.10,330137.31,1086.21,287845.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','193880',3787214,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','193880',3787215,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193880',3787216,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','193880',3787217,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','193880',3787218,'2693','404',330137.31,331391.27,1253.96,332299.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','194188',3792811,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','194188',3792812,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194188',3792813,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194188',3792814,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','194188',3792815,'2693','404',331391.27,332740.91,1349.64,357654.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','194381',3796342,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','194381',3796343,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194381',3796344,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194381',3796345,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','194381',3796346,'2693','404',332740.91,334959.59,2218.68,587950.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','194492',3798361,'2689','403',683808.99,683808.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','194492',3798362,'2690','403',594353.75,594353.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194492',3798363,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194492',3798364,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','194492',3798365,'2693','404',334959.59,336650.56,1690.97,448107.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','194708',3802140,'2689','403',683808.99,687334.02,3525.03,581629.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','194708',3802141,'2690','403',594353.75,597489.58,3135.83,517411.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','194708',3802142,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194708',3802143,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','194708',3802144,'2693','404',336650.56,337508.88,858.32,227454.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','194918',3806539,'2689','403',687334.02,690696.42,3362.40,554796.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','194918',3806540,'2690','403',597489.58,601139.92,3650.34,602306.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','194918',3806541,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','194918',3806542,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','194918',3806543,'2693','404',337508.88,338651.31,1142.43,302743.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','195287',3813198,'2689','403',690696.42,694104.13,3407.71,562272.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','195287',3813199,'2690','403',601139.92,604407.41,3267.49,539135.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','195287',3813200,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','195287',3813201,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','195287',3813202,'2693','404',338651.31,340429.69,1778.38,471270.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','195437',3815577,'2689','403',694104.13,698937.01,4832.88,797425.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','195437',3815578,'2690','403',604407.41,608465.24,4057.83,669541.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','195437',3815579,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','195437',3815580,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','195437',3815581,'2693','404',340429.69,341241.99,812.30,215259.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','195543',3817459,'2689','403',698937.01,702385.84,3448.83,569056.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','195543',3817460,'2690','403',608465.24,612150.47,3685.23,608062.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','195543',3817461,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','195543',3817462,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','195543',3817463,'2693','404',341241.99,342225.18,983.19,260545.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','195972',3825159,'2689','403',702385.84,704216.34,1830.50,302032.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','195972',3825160,'2690','403',612150.47,614034.34,1883.87,310838.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','195972',3825161,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','195972',3825162,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','195972',3825163,'2693','404',342225.18,342984.42,759.24,201198.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','196071',3826611,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','196071',3826612,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196071',3826613,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196071',3826614,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','196071',3826615,'2693','404',342984.42,343781.05,796.63,211106.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','196336',3831786,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','196336',3831787,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196336',3831788,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196336',3831789,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','196336',3831790,'2693','404',343781.05,344219.43,438.38,116170.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','196540',3835442,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','196540',3835443,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196540',3835444,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196540',3835445,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','196540',3835446,'2693','404',344219.43,344613.41,393.98,104404.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','196858',3841154,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','196858',3841155,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196858',3841156,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196858',3841157,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','196858',3841158,'2693','404',344613.41,345304.06,690.65,183022.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','196893',3841685,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','196893',3841686,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196893',3841687,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','196893',3841688,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','196893',3841689,'2693','404',345304.06,346383.48,1079.42,286046.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','197206',3847367,'2689','403',704216.34,704216.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','197206',3847368,'2690','403',614034.34,614034.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197206',3847369,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197206',3847370,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','197206',3847371,'2693','404',346383.48,347099.68,716.20,189793.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','197508',3852378,'2689','403',704216.34,706903.21,2686.87,443333.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','197508',3852379,'2690','403',614034.34,616891.48,2857.14,471428.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','197508',3852380,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197508',3852381,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','197508',3852382,'2693','404',347099.68,349014.78,1915.10,507501.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','197760',3856768,'2689','403',706903.21,709835.33,2932.12,483799.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','197760',3856769,'2690','403',616891.48,619361.48,2470.00,407550.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197760',3856770,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197760',3856771,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','197760',3856772,'2693','404',349014.78,349726.41,711.63,188581.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','197766',3856854,'2689','403',709835.33,712898.98,3063.65,505502.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','197766',3856855,'2690','403',619361.48,622579.87,3218.39,531034.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','197766',3856856,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','197766',3856857,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','197766',3856858,'2693','404',349726.41,350432.28,705.87,187055.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','198096',3862875,'2689','403',712898.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','198096',3862876,'2690','403',622579.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198096',3862877,'2691','403',365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198096',3862878,'2692','403',273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','198096',3862879,'2693','404',350432.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','198139',3863329,'2689','403',712898.98,715929.32,3030.34,500006.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','198139',3863330,'2690','403',622579.87,625268.05,2688.18,443549.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','198139',3863331,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198139',3863332,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','198139',3863333,'2693','404',350432.28,351554.89,1122.61,303104.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','198260',3865426,'2689','403',715929.32,719272.15,3342.83,551566.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','198260',3865427,'2690','403',625268.05,628872.14,3604.09,594674.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','198260',3865428,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198260',3865429,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','198260',3865430,'2693','404',351554.89,352815.85,1260.96,340459.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','198387',3867556,'2689','403',719272.15,722960.51,3688.36,608579.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','198387',3867557,'2690','403',628872.14,632076.28,3204.14,528683.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','198387',3867558,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198387',3867559,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','198387',3867560,'2693','404',352815.85,353749.77,933.92,252158.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','198645',3872100,'2689','403',722960.51,726550.90,3590.39,592414.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','198645',3872101,'2690','403',632076.28,634999.42,2923.14,482318.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','198645',3872102,'2691','403',365024.45,365024.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','198645',3872103,'2692','403',273885.01,273885.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','198645',3872104,'2693','404',353749.77,354739.78,990.01,267302.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','199046',3878937,'2689','403',726550.90,728193.32,1642.42,270999.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','199046',3878938,'2690','403',634999.42,636106.39,1106.97,182650.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','199046',3878939,'2691','403',365024.45,367626.75,2602.30,429379.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','199046',3878940,'2692','403',273885.01,275206.24,1321.23,218002.95,0.00,0.00,0.00,0.00,0.00),('5','175','910','199046',3878941,'2693','404',354739.78,356045.22,1305.44,352468.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','199056',3879148,'2689','403',728193.32,729711.99,1518.67,250580.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','199056',3879149,'2690','403',636106.39,637755.76,1649.37,272146.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','199056',3879150,'2691','403',367626.75,369734.74,2107.99,347818.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','199056',3879151,'2692','403',275206.24,276481.13,1274.89,210356.85,0.00,0.00,0.00,0.00,0.00),('5','175','910','199056',3879152,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','199211',3881945,'2689','403',729711.99,731612.94,1900.95,313656.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','199211',3881946,'2690','403',637755.76,639231.10,1475.34,243431.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','199211',3881947,'2691','403',369734.74,371693.14,1958.40,323136.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','199211',3881948,'2692','403',276481.13,278012.30,1531.17,252643.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','199211',3881949,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','199426',3885452,'2689','403',731612.94,735260.59,3647.65,601862.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','199426',3885453,'2690','403',639231.10,640158.21,927.11,152973.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','199426',3885454,'2691','403',371693.14,373174.81,1481.67,244475.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','199426',3885455,'2692','403',278012.30,280049.01,2036.71,336057.15,0.00,0.00,0.00,0.00,0.00),('5','175','910','199426',3885456,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','199675',3889416,'2689','403',735260.59,738508.99,3248.40,535986.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','199675',3889417,'2690','403',640158.21,641024.05,865.84,142863.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','199675',3889418,'2691','403',373174.81,375368.18,2193.37,361906.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','199675',3889419,'2692','403',280049.01,281360.14,1311.13,216336.45,0.00,0.00,0.00,0.00,0.00),('5','175','910','199675',3889420,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','199893',3892810,'2689','403',738508.99,741717.47,3208.48,529399.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','199893',3892811,'2690','403',641024.05,641952.84,928.79,153250.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','199893',3892812,'2691','403',375368.18,376821.97,1453.79,239875.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','199893',3892813,'2692','403',281360.14,283482.35,2122.21,350164.65,0.00,0.00,0.00,0.00,0.00),('5','175','910','199893',3892814,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','200106',3896852,'2689','403',741717.47,743072.84,1355.37,223636.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','200106',3896853,'2690','403',641952.84,643541.87,1589.03,262189.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','200106',3896854,'2691','403',376821.97,378736.15,1914.18,315839.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','200106',3896855,'2692','403',283482.35,285560.10,2077.75,342828.75,0.00,0.00,0.00,0.00,0.00),('5','175','910','200106',3896856,'2693','404',356045.22,356045.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','200315',3900492,'2689','403',743072.84,745948.60,2875.76,474500.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','200315',3900493,'2690','403',643541.87,644600.32,1058.45,174644.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','200315',3900494,'2691','403',378736.15,380107.93,1371.78,226343.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','200315',3900495,'2692','403',285560.10,287657.24,2097.14,346028.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','200315',3900496,'2693','404',356045.22,356673.42,628.20,169614.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','200506',3904138,'2689','403',745948.60,746818.41,869.81,143518.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','200506',3904139,'2690','403',644600.32,647593.18,2992.86,493821.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','200506',3904140,'2691','403',380107.93,382003.53,1895.60,312774.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','200506',3904141,'2692','403',287657.24,289172.13,1514.89,249956.85,0.00,0.00,0.00,0.00,0.00),('5','175','910','200506',3904142,'2693','404',356673.42,357577.90,904.48,244209.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','200707',3907693,'2689','403',746818.41,748557.89,1739.48,287014.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','200707',3907694,'2690','403',647593.18,651745.31,4152.13,685101.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','200707',3907695,'2691','403',382003.53,383730.01,1726.48,284869.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','200707',3907696,'2692','403',289172.13,290425.45,1253.32,206797.80,0.00,0.00,0.00,0.00,0.00),('5','175','910','200707',3907697,'2693','404',357577.90,360325.16,2747.26,741760.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','200919',3911478,'2689','403',748557.89,750708.60,2150.71,354867.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','200919',3911479,'2690','403',651745.31,655863.39,4118.08,679483.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','200919',3911480,'2691','403',383730.01,386168.49,2438.48,402349.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','200919',3911481,'2692','403',290425.45,291425.63,1000.18,165029.70,0.00,0.00,0.00,0.00,0.00),('5','175','910','200919',3911482,'2693','404',360325.16,361749.54,1424.38,384582.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','201122',3914700,'2689','403',750708.60,752545.96,1837.36,303164.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','201122',3914701,'2690','403',655863.39,658964.05,3100.66,511608.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','201122',3914702,'2691','403',386168.49,388716.68,2548.19,420451.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','201122',3914703,'2692','403',291425.63,293175.88,1750.25,288791.25,0.00,0.00,0.00,0.00,0.00),('5','175','910','201122',3914704,'2693','404',361749.54,365337.11,3587.57,968643.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','201321',3918146,'2689','403',752545.96,755498.76,2952.80,487212.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','201321',3918147,'2690','403',658964.05,660068.67,1104.62,182262.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','201321',3918148,'2691','403',388716.68,389945.93,1229.25,202826.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','201321',3918149,'2692','403',293175.88,296123.11,2947.23,486292.95,0.00,0.00,0.00,0.00,0.00),('5','175','910','201321',3918150,'2693','404',365337.11,368504.67,3167.56,855241.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','201511',3921604,'2689','403',755498.76,758430.16,2931.40,483681.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','201511',3921605,'2690','403',660068.67,660756.58,687.91,113505.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','201511',3921606,'2691','403',389945.93,391529.86,1583.93,261348.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','201511',3921607,'2692','403',296123.11,297775.60,1652.49,272660.85,0.00,0.00,0.00,0.00,0.00),('5','175','910','201511',3921608,'2693','404',368504.67,369736.90,1232.23,332702.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','201760',3926585,'2689','403',758430.16,759695.30,1265.14,208748.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','201760',3926586,'2690','403',660756.58,662164.91,1408.33,232374.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','201760',3926587,'2691','403',391529.86,393464.00,1934.14,319133.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','201760',3926588,'2692','403',297775.60,299407.39,1631.79,269245.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','201760',3926589,'2693','404',369736.90,371049.39,1312.49,360934.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','202030',3931646,'2689','403',759695.30,760974.02,1278.72,210988.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','202030',3931647,'2690','403',662164.91,663531.67,1366.76,225515.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','202030',3931648,'2691','403',393464.00,394958.66,1494.66,246618.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','202030',3931649,'2692','403',299407.39,301091.01,1683.62,277797.30,0.00,0.00,0.00,0.00,0.00),('5','175','910','202030',3931650,'2693','404',371049.39,372905.95,1856.56,510554.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','202240',3935044,'2689','403',760974.02,763614.71,2640.69,435713.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','202240',3935045,'2690','403',663531.67,664832.15,1300.48,214579.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','202240',3935046,'2691','403',394958.66,394958.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','202240',3935047,'2692','403',301091.01,302039.80,948.79,156550.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','202240',3935048,'2693','404',372905.95,375480.49,2574.54,707998.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','202456',3938770,'2689','403',763614.71,765262.43,1647.72,271873.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','202456',3938771,'2690','403',664832.15,666169.87,1337.72,220723.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','202456',3938772,'2691','403',394958.66,395633.51,674.85,111350.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','202456',3938773,'2692','403',302039.80,303517.43,1477.63,243808.95,0.00,0.00,0.00,0.00,0.00),('5','175','910','202456',3938774,'2693','404',375480.49,376873.10,1392.61,382967.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','202655',3942305,'2689','403',765262.43,766826.81,1564.38,258122.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','202655',3942306,'2690','403',666169.87,667403.49,1233.62,203547.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','202655',3942307,'2691','403',395633.51,396744.52,1111.01,183316.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','202655',3942308,'2692','403',303517.43,304383.82,866.39,142954.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','202655',3942309,'2693','404',376873.10,378869.05,1995.95,548886.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','202857',3945982,'2689','403',766826.81,768386.80,1559.99,257398.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','202857',3945983,'2690','403',667403.49,668606.25,1202.76,198455.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','202857',3945984,'2691','403',396744.52,397681.06,936.54,154529.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','202857',3945985,'2692','403',304383.82,305409.96,1026.14,169313.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','202857',3945986,'2693','404',378869.05,380156.89,1287.84,354156.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203124',3950956,'2689','403',768386.80,770823.00,2436.20,401973.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203124',3950957,'2690','403',668606.25,670678.16,2071.91,341865.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','203124',3950958,'2691','403',397681.06,397681.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','203124',3950959,'2692','403',305409.96,305680.46,270.50,44632.50,0.00,0.00,0.00,0.00,0.00),('5','175','910','203124',3950960,'2693','404',380156.89,380344.09,187.20,51480.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203322',3954603,'2689','403',770823.00,772365.20,1542.20,254463.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203322',3954604,'2690','403',670678.16,672304.08,1625.92,268276.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','203322',3954605,'2691','403',397681.06,397901.31,220.25,36341.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','203322',3954606,'2692','403',305680.46,306633.17,952.71,157197.15,0.00,0.00,0.00,0.00,0.00),('5','175','910','203322',3954607,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203528',3958368,'2689','403',772365.20,773172.17,806.97,133150.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','203528',3958369,'2690','403',672304.08,672819.40,515.32,85027.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','203528',3958370,'2691','403',397901.31,399900.50,1999.19,329866.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','203528',3958371,'2692','403',306633.17,307484.54,851.37,140476.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','203528',3958372,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203737',3962116,'2689','403',773172.17,773894.79,722.62,119232.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','203737',3962117,'2690','403',672819.40,673668.67,849.27,140129.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','203737',3962118,'2691','403',399900.50,401164.64,1264.14,208583.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','203737',3962119,'2692','403',307484.54,309455.73,1971.19,325246.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','203737',3962120,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','203973',3966209,'2689','403',773894.79,775586.84,1692.05,279188.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','203973',3966210,'2690','403',673668.67,675019.67,1351.00,222915.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','203973',3966211,'2691','403',401164.64,402192.28,1027.64,169560.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','203973',3966212,'2692','403',309455.73,310379.47,923.74,152417.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','203973',3966213,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','204191',3970340,'2689','403',775586.84,777039.39,1452.55,239670.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','204191',3970341,'2690','403',675019.67,676157.56,1137.89,187751.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','204191',3970342,'2691','403',402192.28,403132.61,940.33,155154.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','204191',3970343,'2692','403',310379.47,311376.51,997.04,164511.60,0.00,0.00,0.00,0.00,0.00),('5','175','910','204191',3970344,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','204404',3974050,'2689','403',777039.39,778247.07,1207.68,199267.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','204404',3974051,'2690','403',676157.56,677146.02,988.46,163095.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','204404',3974052,'2691','403',403132.61,404159.71,1027.10,169471.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','204404',3974053,'2692','403',311376.51,312226.69,850.18,140279.70,0.00,0.00,0.00,0.00,0.00),('5','175','910','204404',3974054,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','204626',3978119,'2689','403',778247.07,779300.34,1053.27,173789.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','204626',3978120,'2690','403',677146.02,677865.35,719.33,118689.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','204626',3978121,'2691','403',404159.71,405088.83,929.12,153304.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','204626',3978122,'2692','403',312226.69,313635.37,1408.68,232432.20,0.00,0.00,0.00,0.00,0.00),('5','175','910','204626',3978123,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','204842',3981613,'2689','403',779300.34,780662.73,1362.39,224794.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','204842',3981614,'2690','403',677865.35,678915.37,1050.02,173253.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','204842',3981615,'2691','403',405088.83,406007.04,918.21,151504.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','204842',3981616,'2692','403',313635.37,314458.69,823.32,135847.80,0.00,0.00,0.00,0.00,0.00),('5','175','910','204842',3981617,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205055',3985318,'2689','403',780662.73,781884.70,1221.97,201625.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','205055',3985319,'2690','403',678915.37,680111.07,1195.70,197290.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','205055',3985320,'2691','403',406007.04,407036.69,1029.65,169892.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','205055',3985321,'2692','403',314458.69,315057.57,598.88,98815.20,0.00,0.00,0.00,0.00,0.00),('5','175','910','205055',3985322,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205218',3988607,'2689','403',781884.70,781884.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205218',3988608,'2690','403',680111.07,680111.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','205218',3988609,'2691','403',407036.69,407036.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','205218',3988610,'2692','403',315057.57,315057.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','205218',3988611,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205237',3988774,'2689','403',781884.70,783616.20,1731.50,285697.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','205237',3988775,'2690','403',680111.07,681040.09,929.02,153288.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','205237',3988776,'2691','403',407036.69,408010.67,973.98,160706.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','205237',3988777,'2692','403',315057.57,315946.61,889.04,146691.60,0.00,0.00,0.00,0.00,0.00),('5','175','910','205237',3988778,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205479',3993131,'2689','403',783616.20,785012.18,1395.98,230336.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','205479',3993132,'2690','403',681040.09,682362.48,1322.39,218194.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','205479',3993133,'2691','403',408010.67,408859.74,849.07,140096.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','205479',3993134,'2692','403',315946.61,316934.14,987.53,162942.45,0.00,0.00,0.00,0.00,0.00),('5','175','910','205479',3993135,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','205719',3997676,'2689','403',785012.18,786244.62,1232.44,203352.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','205719',3997677,'2690','403',682362.48,683735.63,1373.15,226569.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','205719',3997678,'2691','403',408859.74,409847.04,987.30,162904.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','205719',3997679,'2692','403',316934.14,317693.76,759.62,125337.30,0.00,0.00,0.00,0.00,0.00),('5','175','910','205719',3997680,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','206014',4002730,'2689','403',786244.62,787758.72,1514.10,249826.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','206014',4002731,'2690','403',683735.63,684922.34,1186.71,195807.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','206014',4002732,'2691','403',409847.04,410925.42,1078.38,177932.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','206014',4002733,'2692','403',317693.76,318379.78,686.02,113193.30,0.00,0.00,0.00,0.00,0.00),('5','175','910','206014',4002734,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','206219',4006439,'2689','403',787758.72,789107.23,1348.51,222504.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','206219',4006440,'2690','403',684922.34,686004.80,1082.46,178605.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','206219',4006441,'2691','403',410925.42,411827.67,902.25,148871.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','206219',4006442,'2692','403',318379.78,319121.98,742.20,122463.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','206219',4006443,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','206375',4009011,'2689','403',789107.23,790239.29,1132.06,186789.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','206375',4009012,'2690','403',686004.80,686968.69,963.89,159041.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','206375',4009013,'2691','403',411827.67,412210.21,382.54,63119.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','206375',4009014,'2692','403',319121.98,320031.36,909.38,150047.70,0.00,0.00,0.00,0.00,0.00),('5','175','910','206375',4009015,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','206772',4016176,'2689','403',790239.29,791502.34,1263.05,208403.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','206772',4016177,'2690','403',686968.69,688653.71,1685.02,278028.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','206772',4016178,'2691','403',412210.21,412689.14,478.93,79023.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','206772',4016179,'2692','403',320031.36,320247.50,216.14,35663.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','206772',4016180,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','206819',4016780,'2689','403',791502.34,793756.46,2254.12,371929.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','206819',4016781,'2690','403',688653.71,690291.58,1637.87,270248.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','206819',4016782,'2691','403',412689.14,412689.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','206819',4016783,'2692','403',320247.50,320247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','206819',4016784,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','207028',4020683,'2689','403',793756.46,795556.93,1800.47,297077.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','207028',4020684,'2690','403',690291.58,692075.56,1783.98,294356.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','207028',4020685,'2691','403',412689.14,412689.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','207028',4020686,'2692','403',320247.50,320247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','207028',4020687,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','207270',4024934,'2689','403',795556.93,798140.45,2583.52,426280.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','207270',4024935,'2690','403',692075.56,693975.26,1899.70,313450.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','207270',4024936,'2691','403',412689.14,412782.79,93.65,15452.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','207270',4024937,'2692','403',320247.50,320247.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','207270',4024938,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','207490',4028910,'2689','403',798140.45,799610.54,1470.09,242564.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','207490',4028911,'2690','403',693975.26,695189.07,1213.81,200278.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','207490',4028912,'2691','403',412782.79,413695.17,912.38,150542.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','207490',4028913,'2692','403',320247.50,321292.67,1045.17,172453.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','207490',4028914,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','207708',4032661,'2689','403',799610.54,801249.55,1639.01,270436.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','207708',4032662,'2690','403',695189.07,696346.70,1157.63,191008.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','207708',4032663,'2691','403',413695.17,414413.55,718.38,118532.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','207708',4032664,'2692','403',321292.67,322357.03,1064.36,175619.40,0.00,0.00,0.00,0.00,0.00),('5','175','910','207708',4032665,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','207926',4036300,'2689','403',801249.55,802746.76,1497.21,247039.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','207926',4036301,'2690','403',696346.70,697694.38,1347.68,222367.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','207926',4036302,'2691','403',414413.55,415575.79,1162.24,191769.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','207926',4036303,'2692','403',322357.03,323102.22,745.19,122956.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','207926',4036304,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','208118',4039674,'2689','403',802746.76,804058.32,1311.56,216407.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','208118',4039675,'2690','403',697694.38,698676.91,982.53,162117.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','208118',4039676,'2691','403',415575.79,416399.86,824.07,135971.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','208118',4039677,'2692','403',323102.22,323956.21,853.99,140908.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','208118',4039678,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','208337',4043684,'2689','403',804058.32,805388.74,1330.42,219519.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','208337',4043685,'2690','403',698676.91,699999.34,1322.43,218200.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','208337',4043686,'2691','403',416399.86,417410.47,1010.61,166750.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','208337',4043687,'2692','403',323956.21,324723.71,767.50,126637.50,0.00,0.00,0.00,0.00,0.00),('5','175','910','208337',4043688,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','208546',4047433,'2689','403',805388.74,806698.23,1309.49,216065.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','208546',4047434,'2690','403',699999.34,700990.21,990.87,163493.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','208546',4047435,'2691','403',417410.47,418023.63,613.16,101171.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','208546',4047436,'2692','403',324723.71,325710.55,986.84,162828.60,0.00,0.00,0.00,0.00,0.00),('5','175','910','208546',4047437,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','208764',4051128,'2689','403',806698.23,808103.99,1405.76,231950.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','208764',4051129,'2690','403',700990.21,701984.16,993.95,164001.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','208764',4051130,'2691','403',418023.63,418928.59,904.96,149318.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','208764',4051131,'2692','403',325710.55,326363.46,652.91,107730.15,0.00,0.00,0.00,0.00,0.00),('5','175','910','208764',4051132,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','208984',4055048,'2689','403',808103.99,809648.29,1544.30,254809.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','208984',4055049,'2690','403',701984.16,703778.68,1794.52,296095.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','208984',4055050,'2691','403',418928.59,418928.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','208984',4055051,'2692','403',326363.46,327036.31,672.85,111020.25,0.00,0.00,0.00,0.00,0.00),('5','175','910','208984',4055052,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','209255',4059566,'2689','403',809648.29,811108.02,1459.73,240855.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','209255',4059567,'2690','403',703778.68,705328.11,1549.43,255655.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','209255',4059568,'2691','403',418928.59,418928.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','209255',4059569,'2692','403',327036.31,327036.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','209255',4059570,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','209455',4063087,'2689','403',811108.02,813449.05,2341.03,386269.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','209455',4063088,'2690','403',705328.11,706909.33,1581.22,260901.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','209455',4063089,'2691','403',418928.59,418928.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','209455',4063090,'2692','403',327036.31,327036.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','209455',4063091,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','209656',4066732,'2689','403',813449.05,815071.15,1622.10,267646.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','209656',4066733,'2690','403',706909.33,708654.69,1745.36,287984.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','209656',4066734,'2691','403',418928.59,419151.23,222.64,36735.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','209656',4066735,'2692','403',327036.31,327132.57,96.26,15882.90,0.00,0.00,0.00,0.00,0.00),('5','175','910','209656',4066736,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','209891',4070819,'2689','403',815071.15,816165.18,1094.03,180514.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','209891',4070820,'2690','403',708654.69,709638.47,983.78,162323.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','209891',4070821,'2691','403',419151.23,419831.99,680.76,112325.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','209891',4070822,'2692','403',327132.57,327836.29,703.72,116113.80,0.00,0.00,0.00,0.00,0.00),('5','175','910','209891',4070823,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','210107',4074799,'2689','403',816165.18,817085.09,919.91,151785.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','210107',4074800,'2690','403',709638.47,710574.17,935.70,154390.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','210107',4074801,'2691','403',419831.99,420671.13,839.14,138458.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','210107',4074802,'2692','403',327836.29,328795.52,959.23,158272.95,0.00,0.00,0.00,0.00,0.00),('5','175','910','210107',4074803,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','210325',4078572,'2689','403',817085.09,818307.79,1222.70,201745.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','210325',4078573,'2690','403',710574.17,711705.38,1131.21,186649.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','210325',4078574,'2691','403',420671.13,421705.65,1034.52,170695.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','210325',4078575,'2692','403',328795.52,329354.87,559.35,92292.75,0.00,0.00,0.00,0.00,0.00),('5','175','910','210325',4078576,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','210524',4082293,'2689','403',818307.79,819776.72,1468.93,242373.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','210524',4082294,'2690','403',711705.38,711933.36,227.98,37616.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','210524',4082295,'2691','403',421705.65,422541.91,836.26,137982.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','210524',4082296,'2692','403',329354.87,330421.99,1067.12,176074.80,0.00,0.00,0.00,0.00,0.00),('5','175','910','210524',4082297,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','210732',4085979,'2689','403',819776.72,820944.43,1167.71,192672.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','210732',4085980,'2690','403',711933.36,712719.13,785.77,129652.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','210732',4085981,'2691','403',422541.91,423422.77,880.86,145341.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','210732',4085982,'2692','403',330421.99,331270.59,848.60,140019.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','210732',4085983,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','210954',4089697,'2689','403',820944.43,822415.64,1471.21,242749.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','210954',4089698,'2690','403',712719.13,713190.18,471.05,77723.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','210954',4089699,'2691','403',423422.77,424477.30,1054.53,173997.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','210954',4089700,'2692','403',331270.59,332362.21,1091.62,180117.30,0.00,0.00,0.00,0.00,0.00),('5','175','910','210954',4089701,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','211193',4093863,'2689','403',822415.64,823749.92,1334.28,220156.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','211193',4093864,'2690','403',713190.18,713624.05,433.87,71588.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','211193',4093865,'2691','403',424477.30,425112.33,635.03,104779.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','211193',4093866,'2692','403',332362.21,333375.42,1013.21,167179.65,0.00,0.00,0.00,0.00,0.00),('5','175','910','211193',4093867,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','211411',4097780,'2689','403',823749.92,824525.14,775.22,127911.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','211411',4097781,'2690','403',713624.05,715794.74,2170.69,358163.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','211411',4097782,'2691','403',425112.33,426358.31,1245.98,205586.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','211411',4097783,'2692','403',333375.42,334675.10,1299.68,214447.20,0.00,0.00,0.00,0.00,0.00),('5','175','910','211411',4097784,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','211664',4102205,'2689','403',824525.14,826802.49,2277.35,375762.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','211664',4102206,'2690','403',715794.74,717918.30,2123.56,350387.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','211664',4102207,'2691','403',426358.31,426358.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','211664',4102208,'2692','403',334675.10,334898.42,223.32,36847.80,0.00,0.00,0.00,0.00,0.00),('5','175','910','211664',4102209,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','211782',4104125,'2689','403',826802.49,829253.34,2450.85,404390.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','211782',4104126,'2690','403',717918.30,719444.99,1526.69,251903.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','211782',4104127,'2691','403',426358.31,426358.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','211782',4104128,'2692','403',334898.42,334898.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','211782',4104129,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','212004',4108061,'2689','403',829253.34,831233.36,1980.02,326703.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','212004',4108062,'2690','403',719444.99,721154.14,1709.15,282009.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','212004',4108063,'2691','403',426358.31,426358.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','212004',4108064,'2692','403',334898.42,334898.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','212004',4108065,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','212237',4112214,'2689','403',831233.36,833414.47,2181.11,359883.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','212237',4112215,'2690','403',721154.14,723061.63,1907.49,314735.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','212237',4112216,'2691','403',426358.31,426358.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','212237',4112217,'2692','403',334898.42,334898.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','212237',4112218,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','212485',4116693,'2689','403',833414.47,834090.50,676.03,111544.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','212485',4116694,'2690','403',723061.63,723593.34,531.71,87732.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','212485',4116695,'2691','403',426358.31,426358.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','212485',4116696,'2692','403',334898.42,334898.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','212485',4116697,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','212661',4120018,'2689','403',834090.50,834963.59,873.09,144059.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','212661',4120019,'2690','403',723593.34,724169.58,576.24,95079.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','212661',4120020,'2691','403',426358.31,427381.08,1022.77,168757.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','212661',4120021,'2692','403',334898.42,335702.68,804.26,132702.90,0.00,0.00,0.00,0.00,0.00),('5','175','910','212661',4120022,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','212874',4123678,'2689','403',834963.59,835419.69,456.10,75256.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','212874',4123679,'2690','403',724169.58,725099.94,930.36,153509.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','212874',4123680,'2691','403',427381.08,428375.88,994.80,164142.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','212874',4123681,'2692','403',335702.68,336553.25,850.57,140344.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','212874',4123682,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','213129',4128147,'2689','403',835419.69,836033.38,613.69,101258.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','213129',4128148,'2690','403',725099.94,725806.55,706.61,116590.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','213129',4128149,'2691','403',428375.88,429734.34,1358.46,224145.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','213129',4128150,'2692','403',336553.25,337091.71,538.46,88845.90,0.00,0.00,0.00,0.00,0.00),('5','175','910','213129',4128151,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','213378',4132310,'2689','403',836033.38,836522.32,488.94,80675.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','213378',4132311,'2690','403',725806.55,726423.22,616.67,101750.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','213378',4132312,'2691','403',429734.34,430957.25,1222.91,201780.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','213378',4132313,'2692','403',337091.71,338079.10,987.39,162919.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','213378',4132314,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','213741',4138257,'2689','403',836522.32,837358.34,836.02,137943.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','213741',4138258,'2690','403',726423.22,727127.16,703.94,116150.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','213741',4138259,'2691','403',430957.25,432172.33,1215.08,200488.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','213741',4138260,'2692','403',338079.10,338810.18,731.08,120628.20,0.00,0.00,0.00,0.00,0.00),('5','175','910','213741',4138261,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','213911',4140876,'2689','403',837358.34,837729.56,371.22,61251.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','213911',4140877,'2690','403',727127.16,727925.47,798.31,131721.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','213911',4140878,'2691','403',432172.33,433364.37,1192.04,196686.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','213911',4140879,'2692','403',338810.18,339744.97,934.79,154240.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','213911',4140880,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','214262',4147180,'2689','403',837729.56,838417.04,687.48,113434.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','214262',4147181,'2690','403',727925.47,728488.29,562.82,92865.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','214262',4147182,'2691','403',433364.37,434130.85,766.48,126469.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','214262',4147183,'2692','403',339744.97,340650.51,905.54,149414.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','214262',4147184,'2693','404',380344.09,380344.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','214454',4150299,'2689','403',838417.04,838775.88,358.84,59208.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','214454',4150300,'2690','403',728488.29,729045.53,557.24,91944.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','214454',4150301,'2691','403',434130.85,435161.58,1030.73,170070.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','214454',4150302,'2692','403',340650.51,341775.90,1125.39,185689.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','214454',4150303,'2693','404',380344.09,380464.92,120.83,35644.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','214557',4151875,'2689','403',838775.88,839695.59,919.71,151752.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','214557',4151876,'2690','403',729045.53,729498.75,453.22,74781.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','214557',4151877,'2691','403',435161.58,435806.04,644.46,106335.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','214557',4151878,'2692','403',341775.90,343034.80,1258.90,207718.50,0.00,0.00,0.00,0.00,0.00),('5','175','910','214557',4151879,'2693','404',380464.92,380584.58,119.66,35299.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','214825',4156661,'2689','403',839695.59,839695.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','214825',4156662,'2690','403',729498.75,730358.76,860.01,141901.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','214825',4156663,'2691','403',435806.04,436854.54,1048.50,173002.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','214825',4156664,'2692','403',343034.80,343035.41,0.61,100.65,0.00,0.00,0.00,0.00,0.00),('5','175','910','214825',4156665,'2693','404',380584.58,380821.56,236.98,69909.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','215195',4162988,'2689','403',839695.59,839695.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','215195',4162989,'2690','403',730358.76,730896.17,537.41,88672.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','215195',4162990,'2691','403',436854.54,437612.12,757.58,125000.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','215195',4162991,'2692','403',343035.41,343035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','215195',4162992,'2693','404',380821.56,380821.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','215325',4165162,'2689','403',839695.59,839695.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','215325',4165163,'2690','403',730896.17,730896.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','215325',4165164,'2691','403',437612.12,437612.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','215325',4165165,'2692','403',343035.41,343035.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','215325',4165166,'2693','404',380821.56,380913.08,91.52,26998.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','215526',4168409,'2689','403',839695.59,842116.66,2421.07,399476.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','215526',4168410,'2690','403',730896.17,731631.83,735.66,121383.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','215526',4168411,'2691','403',437612.12,439068.56,1456.44,240312.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','215526',4168412,'2692','403',343035.41,344742.42,1707.01,281656.65,0.00,0.00,0.00,0.00,0.00),('5','175','910','215526',4168413,'2693','404',380913.08,381256.40,343.32,101279.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','215771',4172731,'2689','403',842116.66,843608.07,1491.41,246082.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','215771',4172732,'2690','403',731631.83,732183.00,551.17,90943.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','215771',4172733,'2691','403',439068.56,439252.72,184.16,30386.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','215771',4172734,'2692','403',344742.42,345586.43,844.01,139261.65,0.00,0.00,0.00,0.00,0.00),('5','175','910','215771',4172735,'2693','404',381256.40,381418.82,162.42,47913.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','215986',4176334,'2689','403',843608.07,844222.42,614.35,101367.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','215986',4176335,'2690','403',732183.00,732737.84,554.84,91548.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','215986',4176336,'2691','403',439252.72,440091.50,838.78,138398.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','215986',4176337,'2692','403',345586.43,345586.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','215986',4176338,'2693','404',381418.82,381978.90,560.08,165223.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','216152',4179198,'2689','403',844222.42,844955.31,732.89,120926.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','216152',4179199,'2690','403',732737.84,733373.24,635.40,104841.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','216152',4179200,'2691','403',440091.50,441216.72,1125.22,185661.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','216152',4179201,'2692','403',345586.43,347324.62,1738.19,286801.35,0.00,0.00,0.00,0.00,0.00),('5','175','910','216152',4179202,'2693','404',381978.90,382190.13,211.23,62312.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','216332',4182374,'2689','403',844955.31,845626.08,670.77,110677.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','216332',4182375,'2690','403',733373.24,734094.02,720.78,118928.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','216332',4182376,'2691','403',441216.72,442376.84,1160.12,191419.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','216332',4182377,'2692','403',347324.62,347531.62,207.00,34155.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','216332',4182378,'2693','404',382190.13,382362.23,172.10,50769.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','216570',4186406,'2689','403',845626.08,846026.98,400.90,66148.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','216570',4186407,'2690','403',734094.02,734930.18,836.16,137966.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','216570',4186408,'2691','403',442376.84,443350.03,973.19,160576.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','216570',4186409,'2692','403',347531.62,347988.24,456.62,75342.30,0.00,0.00,0.00,0.00,0.00),('5','175','910','216570',4186410,'2693','404',382362.23,382747.25,385.02,113580.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','216809',4190740,'2689','403',846026.98,846925.70,898.72,148288.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','216809',4190741,'2690','403',734930.18,735298.75,368.57,60814.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','216809',4190742,'2691','403',443350.03,443977.34,627.31,103506.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','216809',4190743,'2692','403',347988.24,348821.24,833.00,137445.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','216809',4190744,'2693','404',382747.25,382830.98,83.73,24700.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','217046',4194804,'2689','403',846925.70,847465.68,539.98,89096.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','217046',4194805,'2690','403',735298.75,735813.41,514.66,84918.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','217046',4194806,'2691','403',443977.34,444761.13,783.79,129325.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','217046',4194807,'2692','403',348821.24,349648.01,826.77,136417.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','217046',4194808,'2693','404',382830.98,383142.02,311.04,91756.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','217280',4199417,'2689','403',847465.68,848572.02,1106.34,182546.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','217280',4199418,'2690','403',735813.41,736909.24,1095.83,180811.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','217280',4199419,'2691','403',444761.13,445699.38,938.25,154811.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','217280',4199420,'2692','403',349648.01,350438.38,790.37,130411.05,0.00,0.00,0.00,0.00,0.00),('5','175','910','217280',4199421,'2693','404',383142.02,383370.24,228.22,67324.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','217680',4206352,'2689','403',848572.02,849267.23,695.21,114709.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','217680',4206353,'2690','403',736909.24,737608.14,698.90,115318.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','217680',4206354,'2691','403',445699.38,446511.98,812.60,134079.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','217680',4206355,'2692','403',350438.38,351301.32,862.94,142385.10,0.00,0.00,0.00,0.00,0.00),('5','175','910','217680',4206356,'2693','404',383370.24,384761.62,1391.38,410457.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','217713',4206707,'2689','403',849267.23,849787.46,520.23,85837.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','217713',4206708,'2690','403',737608.14,738367.56,759.42,125304.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','217713',4206709,'2691','403',446511.98,447389.73,877.75,144828.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','217713',4206710,'2692','403',351301.32,352267.07,965.75,159348.75,0.00,0.00,0.00,0.00,0.00),('5','175','910','217713',4206711,'2693','404',384761.62,385113.52,351.90,103810.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','218016',4212184,'2689','403',849787.46,850501.19,713.73,117765.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','218016',4212185,'2690','403',738367.56,739068.46,700.90,115648.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','218016',4212186,'2691','403',447389.73,448215.04,825.31,136176.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','218016',4212187,'2692','403',352267.07,353222.55,955.48,157654.20,0.00,0.00,0.00,0.00,0.00),('5','175','910','218016',4212188,'2693','404',385113.52,385333.83,220.31,64991.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','218223',4215830,'2689','403',850501.19,852149.01,1647.82,271890.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','218223',4215831,'2690','403',739068.46,739867.41,798.95,131826.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','218223',4215832,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','218223',4215833,'2692','403',353222.55,353861.68,639.13,105456.45,0.00,0.00,0.00,0.00,0.00),('5','175','910','218223',4215834,'2693','404',385333.83,385735.50,401.67,118492.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','218475',4220188,'2689','403',852149.01,853654.04,1505.03,248329.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','218475',4220189,'2690','403',739867.41,741322.57,1455.16,240101.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','218475',4220190,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','218475',4220191,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','218475',4220192,'2693','404',385735.50,385950.14,214.64,63318.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','218732',4224704,'2689','403',853654.04,855806.78,2152.74,355202.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','218732',4224705,'2690','403',741322.57,742932.47,1609.90,265633.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','218732',4224706,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','218732',4224707,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','218732',4224708,'2693','404',385950.14,386170.95,220.81,65138.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','219002',4229452,'2689','403',855806.78,857766.70,1959.92,323386.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','219002',4229453,'2690','403',742932.47,745006.79,2074.32,342262.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','219002',4229454,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','219002',4229455,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','219002',4229456,'2693','404',386170.95,386444.01,273.06,80552.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','219158',4232080,'2689','403',857766.70,859616.51,1849.81,305218.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','219158',4232081,'2690','403',745006.79,746126.11,1119.32,184687.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','219158',4232082,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','219158',4232083,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','219158',4232084,'2693','404',386444.01,386767.48,323.47,95423.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','219329',4235300,'2689','403',859616.51,861089.61,1473.10,243061.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','219329',4235301,'2690','403',746126.11,747491.08,1364.97,225220.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','219329',4235302,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','219329',4235303,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','219329',4235304,'2693','404',386767.48,386830.53,63.05,18599.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','219633',4240262,'2689','403',861089.61,862963.83,1874.22,309246.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','219633',4240263,'2690','403',747491.08,748876.82,1385.74,228647.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','219633',4240264,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','219633',4240265,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','219633',4240266,'2693','404',386830.53,386898.80,68.27,20139.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','219812',4243739,'2689','403',862963.83,864306.07,1342.24,221469.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','219812',4243740,'2690','403',748876.82,750404.71,1527.89,252101.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','219812',4243741,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','219812',4243742,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','219812',4243743,'2693','404',386898.80,387220.18,321.38,94807.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','220086',4248545,'2689','403',864306.07,865024.37,718.30,118519.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','220086',4248546,'2690','403',750404.71,750910.16,505.45,83399.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','220086',4248547,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220086',4248548,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','220086',4248549,'2693','404',387220.18,387398.61,178.43,52636.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','220266',4251674,'2689','403',865024.37,865024.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','220266',4251675,'2690','403',750910.16,750910.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220266',4251676,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220266',4251677,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','220266',4251678,'2693','404',387398.61,387492.29,93.68,27635.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','220476',4255636,'2689','403',865024.37,865024.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','220476',4255637,'2690','403',750910.16,750910.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220476',4255638,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220476',4255639,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','220476',4255640,'2693','404',387492.29,387667.51,175.22,51689.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','220726',4259753,'2689','403',865024.37,865561.22,536.85,88580.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','220726',4259754,'2690','403',750910.16,751612.23,702.07,115841.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','220726',4259755,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220726',4259756,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','220726',4259757,'2693','404',387667.51,387832.11,164.60,48557.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','220905',4263224,'2689','403',865561.22,867084.06,1522.84,251268.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','220905',4263225,'2690','403',751612.23,752937.40,1325.17,218653.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','220905',4263226,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','220905',4263227,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','220905',4263228,'2693','404',387832.11,388066.51,234.40,69148.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','221145',4267396,'2689','403',867084.06,868608.39,1524.33,251514.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','221145',4267397,'2690','403',752937.40,754380.53,1443.13,238116.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','221145',4267398,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','221145',4267399,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','221145',4267400,'2693','404',388066.51,388493.73,427.22,126029.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','221401',4271887,'2689','403',868608.39,870277.35,1668.96,275378.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','221401',4271888,'2690','403',754380.53,755768.77,1388.24,229059.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','221401',4271889,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','221401',4271890,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','221401',4271891,'2693','404',388493.73,388706.57,212.84,62787.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','221617',4276077,'2689','403',870277.35,872216.12,1938.77,319897.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','221617',4276078,'2690','403',755768.77,757067.15,1298.38,214232.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','221617',4276079,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','221617',4276080,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','221617',4276081,'2693','404',388706.57,389087.23,380.66,112294.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','221836',4279841,'2689','403',872216.12,874158.15,1942.03,320434.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','221836',4279842,'2690','403',757067.15,758389.42,1322.27,218174.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','221836',4279843,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','221836',4279844,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','221836',4279845,'2693','404',389087.23,389473.31,386.08,113893.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','222062',4284039,'2689','403',874158.15,875997.94,1839.79,303565.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','222062',4284040,'2690','403',758389.42,760119.22,1729.80,285417.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222062',4284041,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222062',4284042,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','222062',4284043,'2693','404',389473.31,389630.06,156.75,46241.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','222265',4287456,'2689','403',875997.94,878012.98,2015.04,332481.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','222265',4287457,'2690','403',760119.22,761279.89,1160.67,191510.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','222265',4287458,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222265',4287459,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','222265',4287460,'2693','404',389630.06,389823.66,193.60,57112.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','222497',4291351,'2689','403',878012.98,879914.00,1901.02,313668.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','222497',4291352,'2690','403',761279.89,762479.98,1200.09,198014.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','222497',4291353,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222497',4291354,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','222497',4291355,'2693','404',389823.66,390213.68,390.02,115055.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','222738',4295862,'2689','403',879914.00,880955.90,1041.90,171913.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','222738',4295863,'2690','403',762479.98,763664.82,1184.84,195498.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','222738',4295864,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222738',4295865,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','222738',4295866,'2693','404',390213.68,390400.57,186.89,55132.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','222957',4299977,'2689','403',880955.90,881814.99,859.09,141749.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','222957',4299978,'2690','403',763664.82,764051.10,386.28,63736.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','222957',4299979,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','222957',4299980,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','222957',4299981,'2693','404',390400.57,390563.47,162.90,48055.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','223219',4304252,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','223219',4304253,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223219',4304254,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223219',4304255,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','223219',4304256,'2693','404',390563.47,390695.63,132.16,38987.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','223446',4308296,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','223446',4308297,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223446',4308298,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223446',4308299,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','223446',4308300,'2693','404',390695.63,390823.08,127.45,37597.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','223641',4312025,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','223641',4312026,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223641',4312027,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','223641',4312028,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','223641',4312029,'2693','404',390823.08,391020.28,197.20,58174.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224045',4319443,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224045',4319444,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224045',4319445,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224045',4319446,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','224045',4319447,'2693','404',391020.28,391228.40,208.12,61395.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','224118',4320475,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224118',4320476,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224118',4320477,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224118',4320478,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','224118',4320479,'2693','404',391228.40,391348.56,120.16,35447.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','224317',4324193,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224317',4324194,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224317',4324195,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224317',4324196,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','224317',4324197,'2693','404',391348.56,391691.56,343.00,101185.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224530',4327911,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224530',4327912,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224530',4327913,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224530',4327914,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','224530',4327915,'2693','404',391691.56,391946.12,254.56,75095.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','224776',4332221,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','224776',4332222,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224776',4332223,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','224776',4332224,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','224776',4332225,'2693','404',391946.12,392283.91,337.79,99648.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','225043',4336801,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225043',4336802,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225043',4336803,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225043',4336804,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','225043',4336805,'2693','404',392283.91,392490.11,206.20,60829.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225262',4341045,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225262',4341046,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225262',4341047,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225262',4341048,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','225262',4341049,'2693','404',392490.11,392699.60,209.49,61799.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','225502',4345260,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225502',4345261,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225502',4345262,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225502',4345263,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','225502',4345264,'2693','404',392699.60,392786.20,86.60,25547.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225707',4348791,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','225707',4348792,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225707',4348793,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','225707',4348794,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','225707',4348795,'2693','404',392786.20,393114.96,328.76,96984.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','226008',4353879,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','226008',4353880,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226008',4353881,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226008',4353882,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','226008',4353883,'2693','404',393114.96,393205.84,90.88,26809.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','226301',4359298,'2689','403',881814.99,881814.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','226301',4359299,'2690','403',764051.10,764051.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226301',4359300,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226301',4359301,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','226301',4359302,'2693','404',393205.84,393394.13,188.29,55545.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','226490',4362703,'2689','403',881814.99,882856.13,1041.14,171788.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','226490',4362704,'2690','403',764051.10,764891.56,840.46,138675.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','226490',4362705,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226490',4362706,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','226490',4362707,'2693','404',393394.13,393623.03,228.90,67525.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','226809',4368554,'2689','403',882856.13,884100.64,1244.51,205344.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','226809',4368555,'2690','403',764891.56,765705.84,814.28,134356.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','226809',4368556,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226809',4368557,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','226809',4368558,'2693','404',393623.03,393777.35,154.32,45524.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','226999',4371819,'2689','403',884100.64,885075.97,975.33,160929.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','226999',4371820,'2690','403',765705.84,766565.70,859.86,141876.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','226999',4371821,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','226999',4371822,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','226999',4371823,'2693','404',393777.35,393926.98,149.63,44140.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','227204',4375439,'2689','403',885075.97,886316.54,1240.57,204694.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','227204',4375440,'2690','403',766565.70,767571.02,1005.32,165877.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','227204',4375441,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','227204',4375442,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','227204',4375443,'2693','404',393926.98,394138.86,211.88,62504.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','227399',4378847,'2689','403',886316.54,888090.26,1773.72,292663.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','227399',4378848,'2690','403',767571.02,768676.16,1105.14,182348.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','227399',4378849,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','227399',4378850,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','227399',4378851,'2693','404',394138.86,394279.88,141.02,41600.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','227627',4382791,'2689','403',888090.26,889785.71,1695.45,279749.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','227627',4382792,'2690','403',768676.16,769766.68,1090.52,179935.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','227627',4382793,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','227627',4382794,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','227627',4382795,'2693','404',394279.88,394934.86,654.98,196494.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','227883',4387405,'2689','403',889785.71,891663.58,1877.87,309848.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','227883',4387406,'2690','403',769766.68,771201.44,1434.76,236735.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','227883',4387407,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','227883',4387408,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','227883',4387409,'2693','404',394934.86,395190.85,255.99,76797.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','229277',4413938,'2689','403',891663.58,893362.40,1698.82,280305.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','229277',4413939,'2690','403',771201.44,772635.36,1433.92,236596.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','229277',4413940,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','229277',4413941,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','229277',4413942,'2693','404',395190.85,395605.53,414.68,124404.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','229278',4413943,'2689','403',893362.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','229278',4413944,'2690','403',772635.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','229278',4413945,'2691','403',448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','229278',4413946,'2692','403',353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','229278',4413947,'2693','404',395605.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230754',4441920,'2689','403',893362.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230754',4441921,'2690','403',772635.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230754',4441922,'2691','403',448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230754',4441923,'2692','403',353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230754',4441924,'2693','404',395605.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230755',4441925,'2689','403',893362.40,894969.19,1606.79,265120.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','230755',4441926,'2690','403',772635.36,774100.82,1465.46,241800.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','230755',4441927,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230755',4441928,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230755',4441929,'2693','404',395605.53,397069.22,1463.69,439107.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230757',4441950,'2689','403',894969.19,896500.75,1531.56,252707.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','230757',4441951,'2690','403',774100.82,775401.61,1300.79,214630.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','230757',4441952,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230757',4441953,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230757',4441954,'2693','404',397069.22,397330.56,261.34,78402.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230759',4441957,'2689','403',896500.75,897887.23,1386.48,228769.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','230759',4441958,'2690','403',775401.61,776679.80,1278.19,210901.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','230759',4441959,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230759',4441960,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230759',4441961,'2693','404',397330.56,397533.46,202.90,60870.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230765',4442016,'2689','403',897887.23,899338.37,1451.14,239438.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','230765',4442017,'2690','403',776679.80,777878.07,1198.27,197714.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','230765',4442018,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230765',4442019,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230765',4442020,'2693','404',397533.46,397660.99,127.53,38259.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230837',4443035,'2689','403',899338.37,901069.33,1730.96,285608.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','230837',4443036,'2690','403',777878.07,779286.95,1408.88,232465.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','230837',4443037,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230837',4443038,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230837',4443039,'2693','404',397660.99,397854.08,193.09,57927.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230840',4443082,'2689','403',901069.33,902556.90,1487.57,245449.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','230840',4443083,'2690','403',779286.95,780758.21,1471.26,242757.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','230840',4443084,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230840',4443085,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230840',4443086,'2693','404',397854.08,398365.30,511.22,158478.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','230846',4443193,'2689','403',902556.90,904443.74,1886.84,311328.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','230846',4443194,'2690','403',780758.21,782375.24,1617.03,266809.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','230846',4443195,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230846',4443196,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230846',4443197,'2693','404',398365.30,398613.05,247.75,76802.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','230847',4443198,'2689','403',904443.74,906083.87,1640.13,270621.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','230847',4443199,'2690','403',782375.24,784046.56,1671.32,275767.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','230847',4443200,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230847',4443201,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230847',4443202,'2693','404',398613.05,398968.44,355.39,110170.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','230848',4443203,'2689','403',906083.87,907662.93,1579.06,260544.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','230848',4443204,'2690','403',784046.56,785207.74,1161.18,191594.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','230848',4443205,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230848',4443206,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230848',4443207,'2693','404',398968.44,399240.72,272.28,84406.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','230850',4443224,'2689','403',907662.93,907985.00,322.07,53141.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','230850',4443225,'2690','403',785207.74,785207.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230850',4443226,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230850',4443227,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230850',4443228,'2693','404',399240.72,399357.25,116.53,36124.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','230855',4443287,'2689','403',907985.00,907985.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','230855',4443288,'2690','403',785207.74,785207.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230855',4443289,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230855',4443290,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230855',4443291,'2693','404',399357.25,399609.39,252.14,80684.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','230858',4443306,'2689','403',907985.00,909183.52,1198.52,197755.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','230858',4443307,'2690','403',785207.74,786254.56,1046.82,172725.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','230858',4443308,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','230858',4443309,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','230858',4443310,'2693','404',399609.39,399920.31,310.92,99494.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','231101',4447544,'2689','403',909183.52,910541.95,1358.43,224140.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','231101',4447545,'2690','403',786254.56,787146.14,891.58,147110.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','231101',4447546,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','231101',4447547,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','231101',4447548,'2693','404',399920.31,400338.36,418.05,133776.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','231417',4452479,'2689','403',910541.95,911763.72,1221.77,201592.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','231417',4452480,'2690','403',787146.14,788524.63,1378.49,227450.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','231417',4452481,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','231417',4452482,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','231417',4452483,'2693','404',400338.36,400645.20,306.84,98188.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','231669',4456782,'2689','403',911763.72,913354.62,1590.90,262498.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','231669',4456783,'2690','403',788524.63,789933.13,1408.50,232402.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','231669',4456784,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','231669',4456785,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','231669',4456786,'2693','404',400645.20,400976.02,330.82,105862.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','231991',4462870,'2689','403',913354.62,914744.34,1389.72,229303.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','231991',4462871,'2690','403',789933.13,791129.57,1196.44,197412.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','231991',4462872,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','231991',4462873,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','231991',4462874,'2693','404',400976.02,401257.92,281.90,90208.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','232184',4466304,'2689','403',914744.34,916426.33,1681.99,277528.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','232184',4466305,'2690','403',791129.57,792405.17,1275.60,210474.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232184',4466306,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232184',4466307,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','232184',4466308,'2693','404',401257.92,401730.52,472.60,154540.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','232341',4469016,'2689','403',916426.33,917816.17,1389.84,229323.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','232341',4469017,'2690','403',792405.17,793789.03,1383.86,228336.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','232341',4469018,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232341',4469019,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','232341',4469020,'2693','404',401730.52,402090.29,359.77,117644.79,0.00,0.00,0.00,0.00,0.00),('5','175','908','232647',4474661,'2689','403',917816.17,919291.80,1475.63,243478.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','232647',4474662,'2690','403',793789.03,795410.35,1621.32,267517.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','232647',4474663,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232647',4474664,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','232647',4474665,'2693','404',402090.29,402560.11,469.82,153631.14,0.00,0.00,0.00,0.00,0.00),('5','175','908','232887',4478841,'2689','403',919291.80,919291.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','232887',4478842,'2690','403',795410.35,795410.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232887',4478843,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','232887',4478844,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','232887',4478845,'2693','404',402560.11,402632.65,72.54,23720.58,0.00,0.00,0.00,0.00,0.00),('5','175','908','233023',4481487,'2689','403',919291.80,920558.09,1266.29,208937.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','233023',4481488,'2690','403',795410.35,797018.28,1607.93,265308.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','233023',4481489,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','233023',4481490,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','233023',4481491,'2693','404',402632.65,402792.45,159.80,55131.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','233126',4483165,'2689','403',920558.09,921993.48,1435.39,236839.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','233126',4483166,'2690','403',797018.28,798774.14,1755.86,289716.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','233126',4483167,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','233126',4483168,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','233126',4483169,'2693','404',402792.45,403190.10,397.65,137189.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','233422',4488449,'2689','403',921993.48,923701.72,1708.24,281859.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','233422',4488450,'2690','403',798774.14,800984.99,2210.85,364790.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','233422',4488451,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','233422',4488452,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','233422',4488453,'2693','404',403190.10,403553.64,363.54,125421.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','233654',4492687,'2689','403',923701.72,926233.50,2531.78,417743.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','233654',4492688,'2690','403',800984.99,803292.47,2307.48,380734.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','233654',4492689,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','233654',4492690,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','233654',4492691,'2693','404',403553.64,404230.66,677.02,233571.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','233850',4496293,'2689','403',926233.50,928045.67,1812.17,299008.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','233850',4496294,'2690','403',803292.47,805169.12,1876.65,309647.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','233850',4496295,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','233850',4496296,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','233850',4496297,'2693','404',404230.66,405485.97,1255.31,433081.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','234053',4499897,'2689','403',928045.67,929369.08,1323.41,218362.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','234053',4499898,'2690','403',805169.12,806033.57,864.45,142634.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','234053',4499899,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234053',4499900,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','234053',4499901,'2693','404',405485.97,405693.24,207.27,71508.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','234406',4506404,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','234406',4506405,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234406',4506406,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234406',4506407,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','234406',4506408,'2693','404',405693.24,405867.43,174.19,60095.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','234657',4510859,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','234657',4510860,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234657',4510861,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234657',4510862,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','234657',4510863,'2693','404',405867.43,406015.67,148.24,51142.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','234870',4514548,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','234870',4514549,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234870',4514550,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','234870',4514551,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','234870',4514552,'2693','404',406015.67,406153.11,137.44,47416.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','235094',4518556,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','235094',4518557,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235094',4518558,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235094',4518559,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','235094',4518560,'2693','404',406153.11,406325.73,172.62,59553.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','235342',4522811,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','235342',4522812,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235342',4522813,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235342',4522814,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','235342',4522815,'2693','404',406325.73,406597.25,271.52,93674.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','235586',4527018,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','235586',4527019,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235586',4527020,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','235586',4527021,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','235586',4527022,'2693','404',406597.25,406887.87,290.62,100263.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','238027',4569701,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238027',4569702,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238027',4569703,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238027',4569704,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238027',4569705,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238035',4569836,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238035',4569837,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238035',4569838,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238035',4569839,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238035',4569840,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238207',4572694,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238207',4572695,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238207',4572696,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238207',4572697,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238207',4572698,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238237',4573236,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238237',4573237,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238237',4573238,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238237',4573239,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238237',4573240,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238243',4573373,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238243',4573374,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238243',4573375,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238243',4573376,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238243',4573377,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238249',4573470,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238249',4573471,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238249',4573472,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238249',4573473,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238249',4573474,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238270',4573723,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238270',4573724,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238270',4573725,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238270',4573726,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238270',4573727,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238491',4577517,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238491',4577518,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238491',4577519,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238491',4577520,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238491',4577521,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238523',4578027,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238523',4578028,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238523',4578029,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238523',4578030,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238523',4578031,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238531',4578245,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238531',4578246,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238531',4578247,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238531',4578248,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238531',4578249,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238539',4578334,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238539',4578335,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238539',4578336,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238539',4578337,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238539',4578338,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238683',4580831,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238683',4580832,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238683',4580833,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238683',4580834,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238683',4580835,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238876',4584252,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','238876',4584253,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238876',4584254,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','238876',4584255,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','238876',4584256,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239139',4588963,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239139',4588964,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239139',4588965,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239139',4588966,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','239139',4588967,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239344',4592385,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239344',4592386,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239344',4592387,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239344',4592388,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','239344',4592389,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239603',4596863,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','239603',4596864,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239603',4596865,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','239603',4596866,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','239603',4596867,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240016',4603909,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240016',4603910,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240016',4603911,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240016',4603912,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','240016',4603913,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240079',4605129,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240079',4605130,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240079',4605131,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240079',4605132,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','240079',4605133,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240380',4610326,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240380',4610327,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240380',4610328,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240380',4610329,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','240380',4610330,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240561',4613105,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240561',4613106,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240561',4613107,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240561',4613108,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','240561',4613109,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240800',4616758,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','240800',4616759,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240800',4616760,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','240800',4616761,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','240800',4616762,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241165',4623591,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241165',4623592,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241165',4623593,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241165',4623594,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','241165',4623595,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241247',4624830,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241247',4624831,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241247',4624832,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241247',4624833,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','241247',4624834,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241518',4629354,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241518',4629355,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241518',4629356,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241518',4629357,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','241518',4629358,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241800',4634403,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','241800',4634404,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241800',4634405,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','241800',4634406,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','241800',4634407,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242009',4637840,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242009',4637841,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242009',4637842,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242009',4637843,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','242009',4637844,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242291',4642981,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242291',4642982,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242291',4642983,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242291',4642984,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','242291',4642985,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242478',4646168,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242478',4646169,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242478',4646170,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242478',4646171,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','242478',4646172,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242757',4651169,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242757',4651170,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242757',4651171,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242757',4651172,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','242757',4651173,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242927',4653927,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','242927',4653928,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242927',4653929,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','242927',4653930,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','242927',4653931,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243216',4659089,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243216',4659090,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243216',4659091,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243216',4659092,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','243216',4659093,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243429',4662825,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243429',4662826,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243429',4662827,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243429',4662828,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','243429',4662829,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243673',4666949,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243673',4666950,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243673',4666951,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243673',4666952,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','243673',4666953,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243908',4671143,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','243908',4671144,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243908',4671145,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','243908',4671146,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','243908',4671147,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244090',4674328,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244090',4674329,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244090',4674330,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244090',4674331,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','244090',4674332,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244357',4678832,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244357',4678833,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244357',4678834,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244357',4678835,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','244357',4678836,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244559',4682213,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244559',4682214,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244559',4682215,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244559',4682216,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','244559',4682217,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244779',4685970,'2689','403',929369.08,929369.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','244779',4685971,'2690','403',806033.57,806033.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244779',4685972,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','244779',4685973,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','244779',4685974,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','245168',4693162,'2689','403',929369.08,934012.25,4643.17,766123.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','245168',4693163,'2690','403',806033.57,809585.24,3551.67,586025.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','245168',4693164,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245168',4693165,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','245168',4693166,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','245243',4694189,'2689','403',934012.25,939890.24,5877.99,969868.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','245243',4694190,'2690','403',809585.24,814583.28,4998.04,824676.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','245243',4694191,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245243',4694192,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','245243',4694193,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','245518',4698975,'2689','403',939890.24,944049.32,4159.08,686248.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','245518',4698976,'2690','403',814583.28,818467.81,3884.53,640947.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','245518',4698977,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245518',4698978,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','245518',4698979,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','245742',4703004,'2689','403',944049.32,947675.98,3626.66,598398.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','245742',4703005,'2690','403',818467.81,821890.19,3422.38,564692.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','245742',4703006,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245742',4703007,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','245742',4703008,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','245992',4706609,'2689','403',947675.98,951119.52,3443.54,568184.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','245992',4706610,'2690','403',821890.19,826707.59,4817.40,794871.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245992',4706611,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','245992',4706612,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','245992',4706613,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246289',4711693,'2689','403',951119.52,953247.65,2128.13,351141.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','246289',4711694,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246289',4711695,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246289',4711696,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','246289',4711697,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246476',4714862,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246476',4714863,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246476',4714864,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246476',4714865,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','246476',4714866,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246704',4718800,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246704',4718801,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246704',4718802,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246704',4718803,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','246704',4718804,'2693','404',406887.87,406887.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246968',4723376,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','246968',4723377,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246968',4723378,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','246968',4723379,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','246968',4723380,'2693','404',406887.87,406987.14,99.27,34248.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','247215',4727548,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','247215',4727549,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247215',4727550,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247215',4727551,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','247215',4727552,'2693','404',406987.14,407221.50,234.36,80854.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','247462',4732056,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','247462',4732057,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247462',4732058,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247462',4732059,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','247462',4732060,'2693','404',407221.50,407603.68,382.18,131852.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','247746',4736990,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','247746',4736991,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247746',4736992,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','247746',4736993,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','247746',4736994,'2693','404',407603.68,407966.56,362.88,125193.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','248012',4741315,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','248012',4741316,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248012',4741317,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248012',4741318,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','248012',4741319,'2693','404',407966.56,408327.24,360.68,124434.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','248241',4745222,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','248241',4745223,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248241',4745224,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248241',4745225,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','248241',4745226,'2693','404',408327.24,408677.54,350.30,120853.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','248577',4750972,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','248577',4750973,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248577',4750974,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248577',4750975,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','248577',4750976,'2693','404',408677.54,409057.60,380.06,131120.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','248821',4755211,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','248821',4755212,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248821',4755213,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248821',4755214,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','248821',4755215,'2693','404',409057.60,409529.17,471.57,162691.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','248945',4757050,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','248945',4757051,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248945',4757052,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','248945',4757053,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','248945',4757054,'2693','404',409529.17,410124.11,594.94,205254.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','249197',4761238,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','249197',4761239,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249197',4761240,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249197',4761241,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','249197',4761242,'2693','404',410124.11,410860.81,736.70,254161.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','249435',4765399,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','249435',4765400,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249435',4765401,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249435',4765402,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','249435',4765403,'2693','404',410860.81,411156.57,295.76,102037.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','249651',4768981,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','249651',4768982,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249651',4768983,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249651',4768984,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','249651',4768985,'2693','404',411156.57,411503.22,346.65,119594.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','249920',4773570,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','249920',4773571,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249920',4773572,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','249920',4773573,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','249920',4773574,'2693','404',411503.22,411872.45,369.23,127384.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','250288',4779901,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','250288',4779902,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250288',4779903,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250288',4779904,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','250288',4779905,'2693','404',411872.45,412232.54,360.09,124231.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','250470',4782738,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','250470',4782739,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250470',4782740,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250470',4782741,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','250470',4782742,'2693','404',412232.54,412777.99,545.45,188180.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','250667',4786028,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','250667',4786029,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250667',4786030,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250667',4786031,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','250667',4786032,'2693','404',412777.99,413168.78,390.79,134822.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','250969',4791699,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','250969',4791700,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250969',4791701,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','250969',4791702,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','250969',4791703,'2693','404',413168.78,413538.77,369.99,127646.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','251075',4793221,'2689','403',953247.65,953247.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','251075',4793222,'2690','403',826707.59,826707.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','251075',4793223,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','251075',4793224,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','251075',4793225,'2693','404',413538.77,414023.10,484.33,167093.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','251321',4797533,'2689','403',953247.65,957242.41,3994.76,659135.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','251321',4797534,'2690','403',826707.59,830216.57,3508.98,578981.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','251321',4797535,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','251321',4797536,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','251321',4797537,'2693','404',414023.10,414982.69,959.59,331058.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','251569',4801638,'2689','403',957242.41,961988.14,4745.73,783045.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','251569',4801639,'2690','403',830216.57,834839.84,4623.27,762839.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','251569',4801640,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','251569',4801641,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','251569',4801642,'2693','404',414982.69,415437.54,454.85,156923.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','251827',4806363,'2689','403',961988.14,967366.25,5378.11,887388.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','251827',4806364,'2690','403',834839.84,839834.59,4994.75,824133.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','251827',4806365,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','251827',4806366,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','251827',4806367,'2693','404',415437.54,416037.98,600.44,207151.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','252043',4810045,'2689','403',967366.25,973275.66,5909.41,975052.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','252043',4810046,'2690','403',839834.59,846129.29,6294.70,1038625.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','252043',4810047,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252043',4810048,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','252043',4810049,'2693','404',416037.98,417291.49,1253.51,432460.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','252280',4814171,'2689','403',973275.66,976105.51,2829.85,466925.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','252280',4814172,'2690','403',846129.29,848758.94,2629.65,433892.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','252280',4814173,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252280',4814174,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','252280',4814175,'2693','404',417291.49,417765.69,474.20,163599.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','252570',4819565,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','252570',4819566,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252570',4819567,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252570',4819568,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','252570',4819569,'2693','404',417765.69,418260.84,495.15,170826.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','252769',4822697,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','252769',4822698,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252769',4822699,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','252769',4822700,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','252769',4822701,'2693','404',418260.84,418595.85,335.01,115578.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','253031',4827002,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','253031',4827003,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253031',4827004,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253031',4827005,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','253031',4827006,'2693','404',418595.85,418907.88,312.03,107650.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','253245',4830692,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','253245',4830693,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253245',4830694,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253245',4830695,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','253245',4830696,'2693','404',418907.88,419183.11,275.23,94954.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','253545',4835781,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','253545',4835782,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253545',4835783,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253545',4835784,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','253545',4835785,'2693','404',419183.11,419504.24,321.13,110789.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','253792',4840086,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','253792',4840087,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253792',4840088,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','253792',4840089,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','253792',4840090,'2693','404',419504.24,419754.83,250.59,86453.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','254000',4843583,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','254000',4843584,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254000',4843585,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254000',4843586,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','254000',4843587,'2693','404',419754.83,420068.16,313.33,108098.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','254274',4848633,'2689','403',976105.51,976105.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','254274',4848634,'2690','403',848758.94,848758.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254274',4848635,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254274',4848636,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','254274',4848637,'2693','404',420068.16,420250.18,182.02,62796.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','254517',4852818,'2689','403',976105.51,982628.84,6523.33,1076349.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','254517',4852819,'2690','403',848758.94,854401.67,5642.73,931050.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','254517',4852820,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254517',4852821,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','254517',4852822,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','254768',4856997,'2689','403',982628.84,988302.36,5673.52,936130.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','254768',4856998,'2690','403',854401.67,859421.99,5020.32,828352.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','254768',4856999,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','254768',4857000,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','254768',4857001,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255031',4861699,'2689','403',988302.36,993466.08,5163.72,852013.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','255031',4861700,'2690','403',859421.99,864082.83,4660.84,769038.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','255031',4861701,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255031',4861702,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','255031',4861703,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255247',4865213,'2689','403',993466.08,997355.42,3889.34,641741.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','255247',4865214,'2690','403',864082.83,867391.15,3308.32,545872.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','255247',4865215,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255247',4865216,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','255247',4865217,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255545',4870169,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255545',4870170,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255545',4870171,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255545',4870172,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','255545',4870173,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255760',4873876,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','255760',4873877,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255760',4873878,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','255760',4873879,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','255760',4873880,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256041',4878698,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256041',4878699,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256041',4878700,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256041',4878701,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','256041',4878702,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256257',4881839,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256257',4881840,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256257',4881841,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256257',4881842,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','256257',4881843,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256540',4886781,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256540',4886782,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256540',4886783,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256540',4886784,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','256540',4886785,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256800',4891150,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','256800',4891151,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256800',4891152,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','256800',4891153,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','256800',4891154,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257076',4896151,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257076',4896152,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257076',4896153,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257076',4896154,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257076',4896155,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257338',4900936,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257338',4900937,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257338',4900938,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257338',4900939,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257338',4900940,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257531',4903998,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257531',4903999,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257531',4904000,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257531',4904001,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257531',4904002,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257532',4904003,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257532',4904004,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257532',4904005,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257532',4904006,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257532',4904007,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257533',4904008,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257533',4904009,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257533',4904010,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257533',4904011,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257533',4904012,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257534',4904013,'2689','403',997355.42,997355.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257534',4904014,'2690','403',867391.15,867391.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257534',4904015,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257534',4904016,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257534',4904017,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257535',4904018,'2689','403',997355.42,998848.57,1493.15,246369.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','257535',4904019,'2690','403',867391.15,868551.82,1160.67,191510.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','257535',4904020,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257535',4904021,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257535',4904022,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257536',4904023,'2689','403',998848.57,1002658.58,3810.01,628651.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','257536',4904024,'2690','403',868551.82,872515.85,3964.03,654064.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','257536',4904025,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257536',4904026,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257536',4904027,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257537',4904028,'2689','403',1002658.58,1006722.49,4063.91,670545.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','257537',4904029,'2690','403',872515.85,876068.25,3552.40,586146.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257537',4904030,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257537',4904031,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257537',4904032,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257538',4904033,'2689','403',1006722.49,1009920.57,3198.08,527683.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','257538',4904034,'2690','403',876068.25,878972.65,2904.40,479226.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257538',4904035,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257538',4904036,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257538',4904037,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257539',4904038,'2689','403',1009920.57,1015583.51,5662.94,934385.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257539',4904039,'2690','403',878972.65,883552.19,4579.54,755624.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257539',4904040,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257539',4904041,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257539',4904042,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257540',4904043,'2689','403',1015583.51,1019080.13,3496.62,576942.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257540',4904044,'2690','403',883552.19,886462.98,2910.79,480280.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','257540',4904045,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257540',4904046,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257540',4904047,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257541',4904048,'2689','403',1019080.13,1021379.00,2298.87,379313.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257541',4904049,'2690','403',886462.98,888487.46,2024.48,334039.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','257541',4904050,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257541',4904051,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257541',4904052,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257542',4904053,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257542',4904054,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257542',4904055,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257542',4904056,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257542',4904057,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257543',4904058,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257543',4904059,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257543',4904060,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257543',4904061,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257543',4904062,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257544',4904063,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257544',4904064,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257544',4904065,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257544',4904066,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257544',4904067,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257545',4904068,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257545',4904069,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257545',4904070,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257545',4904071,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257545',4904072,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257546',4904073,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257546',4904074,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257546',4904075,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257546',4904076,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257546',4904077,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257547',4904078,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257547',4904079,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257547',4904080,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257547',4904081,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257547',4904082,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257548',4904083,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257548',4904084,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257548',4904085,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257548',4904086,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257548',4904087,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257549',4904088,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257549',4904089,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257549',4904090,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257549',4904091,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257549',4904092,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257550',4904093,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257550',4904094,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257550',4904095,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257550',4904096,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257550',4904097,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257551',4904098,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257551',4904099,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257551',4904100,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257551',4904101,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257551',4904102,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257552',4904103,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257552',4904104,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257552',4904105,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257552',4904106,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257552',4904107,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257553',4904108,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257553',4904109,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257553',4904110,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257553',4904111,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257553',4904112,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257554',4904113,'2689','403',1021379.00,1021379.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257554',4904114,'2690','403',888487.46,888487.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257554',4904115,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257554',4904116,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257554',4904117,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257555',4904118,'2689','403',1021379.00,1024675.68,3296.68,543952.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','257555',4904119,'2690','403',888487.46,891021.40,2533.94,418100.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257555',4904120,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257555',4904121,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257555',4904122,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257556',4904123,'2689','403',1024675.68,1028870.30,4194.62,692112.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257556',4904124,'2690','403',891021.40,894523.64,3502.24,577869.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257556',4904125,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257556',4904126,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257556',4904127,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257557',4904128,'2689','403',1028870.30,1032337.64,3467.34,572111.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257557',4904129,'2690','403',894523.64,898190.25,3666.61,604990.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','257557',4904130,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257557',4904131,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257557',4904132,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257558',4904133,'2689','403',1032337.64,1036577.31,4239.67,699545.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257558',4904134,'2690','403',898190.25,901895.87,3705.62,611427.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','257558',4904135,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257558',4904136,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257558',4904137,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257559',4904138,'2689','403',1036577.31,1041394.64,4817.33,794859.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257559',4904139,'2690','403',901895.87,906011.94,4116.07,679151.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','257559',4904140,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257559',4904141,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257559',4904142,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257560',4904143,'2689','403',1041394.64,1044531.95,3137.31,517656.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','257560',4904144,'2690','403',906011.94,908322.71,2310.77,381277.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257560',4904145,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257560',4904146,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257560',4904147,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257561',4904148,'2689','403',1044531.95,1046210.82,1678.87,277013.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257561',4904149,'2690','403',908322.71,909124.44,801.73,132285.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','257561',4904150,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257561',4904151,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257561',4904152,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257562',4904153,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257562',4904154,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257562',4904155,'2691','403',448215.04,448215.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257562',4904156,'2692','403',353861.68,353861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257562',4904157,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257563',4904158,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257563',4904159,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257563',4904160,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257563',4904161,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257563',4904162,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257564',4904163,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257564',4904164,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257564',4904165,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257564',4904166,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257564',4904167,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257565',4904168,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257565',4904169,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257565',4904170,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257565',4904171,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257565',4904172,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257566',4904173,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257566',4904174,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257566',4904175,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257566',4904176,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257566',4904177,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257567',4904178,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257567',4904179,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257567',4904180,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257567',4904181,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257567',4904182,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257568',4904183,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257568',4904184,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257568',4904185,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257568',4904186,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257568',4904187,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257569',4904188,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257569',4904189,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257569',4904190,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257569',4904191,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257569',4904192,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257570',4904193,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257570',4904194,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257570',4904195,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257570',4904196,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257570',4904197,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257571',4904198,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257571',4904199,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257571',4904200,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257571',4904201,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257571',4904202,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257572',4904203,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257572',4904204,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257572',4904205,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257572',4904206,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257572',4904207,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257573',4904208,'2689','403',1046210.82,1046210.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257573',4904209,'2690','403',909124.44,909124.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257573',4904210,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257573',4904211,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257573',4904212,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257574',4904213,'2689','403',1046210.82,1048065.76,1854.94,306065.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257574',4904214,'2690','403',909124.44,910589.10,1464.66,241668.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','257574',4904215,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257574',4904216,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257574',4904217,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257575',4904218,'2689','403',1048065.76,1050907.51,2841.75,468888.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','257575',4904219,'2690','403',910589.10,913254.99,2665.89,439871.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','257575',4904220,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257575',4904221,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257575',4904222,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257576',4904223,'2689','403',1050907.51,1052196.44,1288.93,212673.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257576',4904224,'2690','403',913254.99,915586.73,2331.74,384737.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257576',4904225,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257576',4904226,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257576',4904227,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257577',4904228,'2689','403',1052196.44,1053411.54,1215.10,200491.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257577',4904229,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257577',4904230,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257577',4904231,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257577',4904232,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257578',4904233,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257578',4904234,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257578',4904235,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257578',4904236,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257578',4904237,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257579',4904238,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257579',4904239,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257579',4904240,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257579',4904241,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257579',4904242,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257580',4904243,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257580',4904244,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257580',4904245,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257580',4904246,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257580',4904247,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257581',4904248,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257581',4904249,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257581',4904250,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257581',4904251,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257581',4904252,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257582',4904253,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257582',4904254,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257582',4904255,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257582',4904256,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257582',4904257,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257583',4904258,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257583',4904259,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257583',4904260,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257583',4904261,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257583',4904262,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257584',4904263,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257584',4904264,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257584',4904265,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257584',4904266,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257584',4904267,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257585',4904268,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257585',4904269,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257585',4904270,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257585',4904271,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257585',4904272,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257586',4904273,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257586',4904274,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257586',4904275,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257586',4904276,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257586',4904277,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257587',4904278,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257587',4904279,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257587',4904280,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257587',4904281,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257587',4904282,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257588',4904283,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257588',4904284,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257588',4904285,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257588',4904286,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257588',4904287,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257589',4904288,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257589',4904289,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257589',4904290,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257589',4904291,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257589',4904292,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257590',4904293,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257590',4904294,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257590',4904295,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257590',4904296,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257590',4904297,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257591',4904298,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257591',4904299,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257591',4904300,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257591',4904301,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257591',4904302,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257592',4904303,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257592',4904304,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257592',4904305,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257592',4904306,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257592',4904307,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257593',4904308,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257593',4904309,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257593',4904310,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257593',4904311,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257593',4904312,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257594',4904313,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257594',4904314,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257594',4904315,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257594',4904316,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257594',4904317,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257595',4904318,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257595',4904319,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257595',4904320,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257595',4904321,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257595',4904322,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257596',4904323,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257596',4904324,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257596',4904325,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257596',4904326,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257596',4904327,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257597',4904328,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257597',4904329,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257597',4904330,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257597',4904331,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257597',4904332,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257598',4904333,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257598',4904334,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257598',4904335,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257598',4904336,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257598',4904337,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257599',4904338,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257599',4904339,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257599',4904340,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257599',4904341,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257599',4904342,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257600',4904343,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257600',4904344,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257600',4904345,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257600',4904346,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257600',4904347,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257601',4904348,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257601',4904349,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257601',4904350,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257601',4904351,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257601',4904352,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257602',4904353,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257602',4904354,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257602',4904355,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257602',4904356,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257602',4904357,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257603',4904358,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257603',4904359,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257603',4904360,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257603',4904361,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257603',4904362,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257604',4904363,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257604',4904364,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257604',4904365,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257604',4904366,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257604',4904367,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257605',4904368,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257605',4904369,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257605',4904370,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257605',4904371,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257605',4904372,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257606',4904373,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257606',4904374,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257606',4904375,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257606',4904376,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257606',4904377,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257607',4904378,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257607',4904379,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257607',4904380,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257607',4904381,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257607',4904382,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257608',4904383,'2689','403',1053411.54,1053411.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257608',4904384,'2690','403',915586.73,915586.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257608',4904385,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257608',4904386,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257608',4904387,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257609',4904388,'2689','403',1053411.54,1053738.30,326.76,53915.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','257609',4904389,'2690','403',915586.73,916240.57,653.84,107883.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257609',4904390,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257609',4904391,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257609',4904392,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257610',4904393,'2689','403',1053738.30,1057104.63,3366.33,555444.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257610',4904394,'2690','403',916240.57,918710.51,2469.94,407540.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257610',4904395,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257610',4904396,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257610',4904397,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257611',4904398,'2689','403',1057104.63,1060130.57,3025.94,499280.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257611',4904399,'2690','403',918710.51,921001.08,2290.57,377944.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257611',4904400,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257611',4904401,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257611',4904402,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257612',4904403,'2689','403',1060130.57,1063600.91,3470.34,572606.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257612',4904404,'2690','403',921001.08,923125.25,2124.17,350488.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257612',4904405,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257612',4904406,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257612',4904407,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257613',4904408,'2689','403',1063600.91,1066871.18,3270.27,539594.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257613',4904409,'2690','403',923125.25,925069.80,1944.55,320850.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257613',4904410,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257613',4904411,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257613',4904412,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257614',4904413,'2689','403',1066871.18,1070498.91,3627.73,598575.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257614',4904414,'2690','403',925069.80,927576.04,2506.24,413529.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257614',4904415,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257614',4904416,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257614',4904417,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257615',4904418,'2689','403',1070498.91,1074115.52,3616.61,596740.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','257615',4904419,'2690','403',927576.04,930022.59,2446.55,403680.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257615',4904420,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257615',4904421,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257615',4904422,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257616',4904423,'2689','403',1074115.52,1076258.54,2143.02,353598.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257616',4904424,'2690','403',930022.59,932047.64,2025.05,334133.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','257616',4904425,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257616',4904426,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257616',4904427,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257617',4904428,'2689','403',1076258.54,1078407.59,2149.05,354593.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','257617',4904429,'2690','403',932047.64,934023.10,1975.46,325950.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','257617',4904430,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257617',4904431,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257617',4904432,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257618',4904433,'2689','403',1078407.59,1080128.95,1721.36,284024.40,0.00,0.00,0.00,0.00,0.00),('5','175','908','257618',4904434,'2690','403',934023.10,934023.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257618',4904435,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257618',4904436,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257618',4904437,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257619',4904438,'2689','403',1080128.95,1080128.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257619',4904439,'2690','403',934023.10,934023.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257619',4904440,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257619',4904441,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257619',4904442,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257620',4904443,'2689','403',1080128.95,1080128.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257620',4904444,'2690','403',934023.10,934023.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257620',4904445,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257620',4904446,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257620',4904447,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257621',4904448,'2689','403',1080128.95,1080128.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257621',4904449,'2690','403',934023.10,934023.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257621',4904450,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257621',4904451,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257621',4904452,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257622',4904453,'2689','403',1080128.95,1082132.21,2003.26,330537.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257622',4904454,'2690','403',934023.10,935426.13,1403.03,231499.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','257622',4904455,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257622',4904456,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257622',4904457,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257623',4904458,'2689','403',1082132.21,1084166.82,2034.61,335710.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','257623',4904459,'2690','403',935426.13,937082.50,1656.37,273301.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257623',4904460,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257623',4904461,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257623',4904462,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257624',4904463,'2689','403',1084166.82,1087120.95,2954.13,487431.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257624',4904464,'2690','403',937082.50,939544.60,2462.10,406246.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257624',4904465,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257624',4904466,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257624',4904467,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257625',4904468,'2689','403',1087120.95,1089877.65,2756.70,454855.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257625',4904469,'2690','403',939544.60,941844.09,2299.49,379415.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','257625',4904470,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257625',4904471,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257625',4904472,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257626',4904473,'2689','403',1089877.65,1091820.15,1942.50,320512.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257626',4904474,'2690','403',941844.09,944004.27,2160.18,356429.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','257626',4904475,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257626',4904476,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257626',4904477,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257627',4904478,'2689','403',1091820.15,1093533.57,1713.42,282714.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257627',4904479,'2690','403',944004.27,945884.18,1879.91,310185.15,0.00,0.00,0.00,0.00,0.00),('5','175','909','257627',4904480,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257627',4904481,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257627',4904482,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257628',4904483,'2689','403',1093533.57,1094548.52,1014.95,167466.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','257628',4904484,'2690','403',945884.18,946077.59,193.41,31912.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','257628',4904485,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257628',4904486,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257628',4904487,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257629',4904488,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257629',4904489,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257629',4904490,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257629',4904491,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257629',4904492,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257630',4904493,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257630',4904494,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257630',4904495,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257630',4904496,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257630',4904497,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257631',4904498,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257631',4904499,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257631',4904500,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257631',4904501,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257631',4904502,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257632',4904503,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257632',4904504,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257632',4904505,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257632',4904506,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257632',4904507,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257633',4904508,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257633',4904509,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257633',4904510,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257633',4904511,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257633',4904512,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257634',4904513,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257634',4904514,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257634',4904515,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257634',4904516,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257634',4904517,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257635',4904518,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257635',4904519,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257635',4904520,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257635',4904521,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257635',4904522,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257636',4904523,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257636',4904524,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257636',4904525,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257636',4904526,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257636',4904527,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257637',4904528,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257637',4904529,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257637',4904530,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257637',4904531,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257637',4904532,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257638',4904533,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257638',4904534,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257638',4904535,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257638',4904536,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257638',4904537,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257639',4904538,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257639',4904539,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257639',4904540,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257639',4904541,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257639',4904542,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257640',4904543,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257640',4904544,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257640',4904545,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257640',4904546,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257640',4904547,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257641',4904548,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257641',4904549,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257641',4904550,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257641',4904551,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257641',4904552,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257642',4904553,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257642',4904554,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257642',4904555,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257642',4904556,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257642',4904557,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257643',4904558,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257643',4904559,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257643',4904560,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257643',4904561,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257643',4904562,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257644',4904563,'2689','403',1094548.52,1094548.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257644',4904564,'2690','403',946077.59,946077.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257644',4904565,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257644',4904566,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257644',4904567,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257645',4904568,'2689','403',1094548.52,1094592.37,43.85,7235.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','257645',4904569,'2690','403',946077.59,947296.14,1218.55,201060.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257645',4904570,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257645',4904571,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257645',4904572,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257646',4904573,'2689','403',1094592.37,1097277.20,2684.83,442996.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257646',4904574,'2690','403',947296.14,950080.84,2784.70,459475.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257646',4904575,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257646',4904576,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257646',4904577,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257647',4904578,'2689','403',1097277.20,1100050.45,2773.25,457586.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','257647',4904579,'2690','403',950080.84,951792.10,1711.26,282357.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','257647',4904580,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257647',4904581,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257647',4904582,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257648',4904583,'2689','403',1100050.45,1102351.08,2300.63,379603.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257648',4904584,'2690','403',951792.10,954184.07,2391.97,394675.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257648',4904585,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257648',4904586,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257648',4904587,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257649',4904588,'2689','403',1102351.08,1105110.12,2759.04,455241.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','257649',4904589,'2690','403',954184.07,956275.67,2091.60,345114.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257649',4904590,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257649',4904591,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257649',4904592,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257650',4904593,'2689','403',1105110.12,1106813.45,1703.33,281049.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257650',4904594,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257650',4904595,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257650',4904596,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257650',4904597,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257651',4904598,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257651',4904599,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257651',4904600,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257651',4904601,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257651',4904602,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257652',4904603,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257652',4904604,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257652',4904605,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257652',4904606,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257652',4904607,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257653',4904608,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257653',4904609,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257653',4904610,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257653',4904611,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257653',4904612,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257654',4904613,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257654',4904614,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257654',4904615,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257654',4904616,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257654',4904617,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257655',4904618,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257655',4904619,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257655',4904620,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257655',4904621,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257655',4904622,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257656',4904623,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257656',4904624,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257656',4904625,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257656',4904626,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257656',4904627,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257657',4904628,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257657',4904629,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257657',4904630,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257657',4904631,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257657',4904632,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257658',4904633,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257658',4904634,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257658',4904635,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257658',4904636,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257658',4904637,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257659',4904638,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257659',4904639,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257659',4904640,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257659',4904641,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257659',4904642,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257660',4904643,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257660',4904644,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257660',4904645,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257660',4904646,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257660',4904647,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257661',4904648,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257661',4904649,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257661',4904650,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257661',4904651,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257661',4904652,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257662',4904653,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257662',4904654,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257662',4904655,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257662',4904656,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257662',4904657,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257663',4904658,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257663',4904659,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257663',4904660,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257663',4904661,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257663',4904662,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257664',4904663,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257664',4904664,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257664',4904665,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257664',4904666,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257664',4904667,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257665',4904668,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257665',4904669,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257665',4904670,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257665',4904671,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257665',4904672,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257666',4904673,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257666',4904674,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257666',4904675,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257666',4904676,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257666',4904677,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257667',4904678,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257667',4904679,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257667',4904680,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257667',4904681,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257667',4904682,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257668',4904683,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257668',4904684,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257668',4904685,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257668',4904686,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257668',4904687,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257669',4904688,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257669',4904689,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257669',4904690,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257669',4904691,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257669',4904692,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257670',4904693,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257670',4904694,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257670',4904695,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257670',4904696,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257670',4904697,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257671',4904698,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257671',4904699,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257671',4904700,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257671',4904701,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257671',4904702,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257672',4904703,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257672',4904704,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257672',4904705,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257672',4904706,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257672',4904707,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257673',4904708,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257673',4904709,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257673',4904710,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257673',4904711,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257673',4904712,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257674',4904713,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257674',4904714,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257674',4904715,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257674',4904716,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257674',4904717,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257675',4904718,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257675',4904719,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257675',4904720,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257675',4904721,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257675',4904722,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257676',4904723,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257676',4904724,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257676',4904725,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257676',4904726,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257676',4904727,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257677',4904728,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257677',4904729,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257677',4904730,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257677',4904731,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257677',4904732,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257678',4904733,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257678',4904734,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257678',4904735,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257678',4904736,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257678',4904737,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257679',4904738,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257679',4904739,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257679',4904740,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257679',4904741,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257679',4904742,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257680',4904743,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257680',4904744,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257680',4904745,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257680',4904746,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257680',4904747,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257681',4904748,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257681',4904749,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257681',4904750,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257681',4904751,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257681',4904752,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257682',4904753,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257682',4904754,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257682',4904755,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257682',4904756,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257682',4904757,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257683',4904758,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257683',4904759,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257683',4904760,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257683',4904761,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257683',4904762,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257684',4904763,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257684',4904764,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257684',4904765,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257684',4904766,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257684',4904767,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257685',4904768,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257685',4904769,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257685',4904770,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257685',4904771,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257685',4904772,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257686',4904773,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257686',4904774,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257686',4904775,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257686',4904776,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257686',4904777,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257687',4904778,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257687',4904779,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257687',4904780,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257687',4904781,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257687',4904782,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257688',4904783,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257688',4904784,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257688',4904785,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257688',4904786,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257688',4904787,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257689',4904788,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257689',4904789,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257689',4904790,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257689',4904791,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257689',4904792,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257690',4904793,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257690',4904794,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257690',4904795,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257690',4904796,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257690',4904797,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257691',4904798,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257691',4904799,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257691',4904800,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257691',4904801,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257691',4904802,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257692',4904803,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257692',4904804,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257692',4904805,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257692',4904806,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257692',4904807,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257693',4904808,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257693',4904809,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257693',4904810,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257693',4904811,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257693',4904812,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257694',4904813,'2689','403',1106813.45,1106813.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257694',4904814,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257694',4904815,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257694',4904816,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257694',4904817,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257695',4904818,'2689','403',1106813.45,1107998.45,1185.00,219225.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257695',4904819,'2690','403',956275.67,956275.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257695',4904820,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257695',4904821,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257695',4904822,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257696',4904823,'2689','403',1107998.45,1110082.11,2083.66,385477.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257696',4904824,'2690','403',956275.67,959222.45,2946.78,545154.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','257696',4904825,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257696',4904826,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257696',4904827,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257697',4904828,'2689','403',1110082.11,1112194.09,2111.98,390716.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257697',4904829,'2690','403',959222.45,960614.81,1392.36,257586.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257697',4904830,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257697',4904831,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257697',4904832,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257698',4904833,'2689','403',1112194.09,1115332.48,3138.39,580602.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','257698',4904834,'2690','403',960614.81,962869.56,2254.75,417128.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257698',4904835,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257698',4904836,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257698',4904837,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257699',4904838,'2689','403',1115332.48,1117273.30,1940.82,359051.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','257699',4904839,'2690','403',962869.56,965382.56,2513.00,464905.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257699',4904840,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257699',4904841,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257699',4904842,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257700',4904843,'2689','403',1117273.30,1120109.64,2836.34,524722.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257700',4904844,'2690','403',965382.56,967022.12,1639.56,303318.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257700',4904845,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257700',4904846,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257700',4904847,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257701',4904848,'2689','403',1120109.64,1122641.25,2531.61,468347.85,0.00,0.00,0.00,0.00,0.00),('5','175','908','257701',4904849,'2690','403',967022.12,968694.48,1672.36,309386.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257701',4904850,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257701',4904851,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257701',4904852,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257702',4904853,'2689','403',1122641.25,1124842.62,2201.37,407253.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257702',4904854,'2690','403',968694.48,970871.73,2177.25,402791.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','257702',4904855,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257702',4904856,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257702',4904857,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257703',4904858,'2689','403',1124842.62,1127361.38,2518.76,465970.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','257703',4904859,'2690','403',970871.73,971903.91,1032.18,190953.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','257703',4904860,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257703',4904861,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257703',4904862,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257704',4904863,'2689','403',1127361.38,1128964.50,1603.12,296577.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','257704',4904864,'2690','403',971903.91,973395.22,1491.31,275892.35,0.00,0.00,0.00,0.00,0.00),('5','175','909','257704',4904865,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257704',4904866,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257704',4904867,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257705',4904868,'2689','403',1128964.50,1130932.60,1968.10,364098.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257705',4904869,'2690','403',973395.22,975440.48,2045.26,378373.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257705',4904870,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257705',4904871,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257705',4904872,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257706',4904873,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257706',4904874,'2690','403',975440.48,977009.06,1568.58,290187.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','257706',4904875,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257706',4904876,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257706',4904877,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257707',4904878,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257707',4904879,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257707',4904880,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257707',4904881,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257707',4904882,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257708',4904883,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257708',4904884,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257708',4904885,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257708',4904886,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257708',4904887,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257709',4904888,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257709',4904889,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257709',4904890,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257709',4904891,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257709',4904892,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257710',4904893,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257710',4904894,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257710',4904895,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257710',4904896,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257710',4904897,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257711',4904898,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257711',4904899,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257711',4904900,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257711',4904901,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257711',4904902,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257712',4904903,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257712',4904904,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257712',4904905,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257712',4904906,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257712',4904907,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257713',4904908,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257713',4904909,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257713',4904910,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257713',4904911,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257713',4904912,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257714',4904913,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257714',4904914,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257714',4904915,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257714',4904916,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257714',4904917,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257715',4904918,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257715',4904919,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257715',4904920,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257715',4904921,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257715',4904922,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257716',4904923,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257716',4904924,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257716',4904925,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257716',4904926,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257716',4904927,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257717',4904928,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257717',4904929,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257717',4904930,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257717',4904931,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257717',4904932,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257718',4904933,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257718',4904934,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257718',4904935,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257718',4904936,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257718',4904937,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257719',4904938,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257719',4904939,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257719',4904940,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257719',4904941,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257719',4904942,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257720',4904943,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257720',4904944,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257720',4904945,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257720',4904946,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257720',4904947,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257721',4904948,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257721',4904949,'2690','403',977009.06,977009.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257721',4904950,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257721',4904951,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257721',4904952,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257722',4904953,'2689','403',1130932.60,1130932.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257722',4904954,'2690','403',977009.06,978679.56,1670.50,309042.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257722',4904955,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257722',4904956,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257722',4904957,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257723',4904958,'2689','403',1130932.60,1133972.87,3040.27,562449.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257723',4904959,'2690','403',978679.56,979914.09,1234.53,228388.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257723',4904960,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257723',4904961,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257723',4904962,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257724',4904963,'2689','403',1133972.87,1136817.50,2844.63,526256.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257724',4904964,'2690','403',979914.09,981562.26,1648.17,304911.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','257724',4904965,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257724',4904966,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257724',4904967,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257725',4904968,'2689','403',1136817.50,1138982.05,2164.55,400441.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','257725',4904969,'2690','403',981562.26,984308.58,2746.32,508069.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','257725',4904970,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257725',4904971,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257725',4904972,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257726',4904973,'2689','403',1138982.05,1141869.61,2887.56,534198.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','257726',4904974,'2690','403',984308.58,986979.84,2671.26,494183.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257726',4904975,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257726',4904976,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257726',4904977,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257727',4904978,'2689','403',1141869.61,1144431.98,2562.37,474038.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257727',4904979,'2690','403',986979.84,989010.97,2031.13,375759.05,0.00,0.00,0.00,0.00,0.00),('5','175','909','257727',4904980,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257727',4904981,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257727',4904982,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257728',4904983,'2689','403',1144431.98,1147520.34,3088.36,571346.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','257728',4904984,'2690','403',989010.97,992095.86,3084.89,570704.65,0.00,0.00,0.00,0.00,0.00),('5','175','909','257728',4904985,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257728',4904986,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257728',4904987,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257729',4904988,'2689','403',1147520.34,1147767.02,246.68,45635.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','257729',4904989,'2690','403',992095.86,995501.60,3405.74,630061.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','257729',4904990,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257729',4904991,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257729',4904992,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257730',4904993,'2689','403',1147767.02,1147790.51,23.49,4345.65,0.00,0.00,0.00,0.00,0.00),('5','175','908','257730',4904994,'2690','403',995501.60,999712.62,4211.02,779038.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','257730',4904995,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257730',4904996,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257730',4904997,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257731',4904998,'2689','403',1147790.51,1150272.25,2481.74,459121.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257731',4904999,'2690','403',999712.62,1001868.26,2155.64,398793.40,0.00,0.00,0.00,0.00,0.00),('5','175','909','257731',4905000,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257731',4905001,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257731',4905002,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257732',4905003,'2689','403',1150272.25,1151324.90,1052.65,194740.25,0.00,0.00,0.00,0.00,0.00),('5','175','908','257732',4905004,'2690','403',1001868.26,1003043.72,1175.46,217460.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257732',4905005,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257732',4905006,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257732',4905007,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257733',4905008,'2689','403',1151324.90,1152399.40,1074.50,198782.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257733',4905009,'2690','403',1003043.72,1004169.82,1126.10,208328.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257733',4905010,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257733',4905011,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257733',4905012,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257734',4905013,'2689','403',1152399.40,1153324.90,925.50,171217.50,0.00,0.00,0.00,0.00,0.00),('5','175','908','257734',4905014,'2690','403',1004169.82,1004443.72,273.90,50671.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257734',4905015,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257734',4905016,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257734',4905017,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257735',4905018,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257735',4905019,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257735',4905020,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257735',4905021,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257735',4905022,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257736',4905023,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257736',4905024,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257736',4905025,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257736',4905026,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257736',4905027,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257737',4905028,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257737',4905029,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257737',4905030,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257737',4905031,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257737',4905032,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257738',4905033,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257738',4905034,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257738',4905035,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257738',4905036,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257738',4905037,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257739',4905038,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257739',4905039,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257739',4905040,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257739',4905041,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257739',4905042,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257740',4905043,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257740',4905044,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257740',4905045,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257740',4905046,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257740',4905047,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257741',4905048,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257741',4905049,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257741',4905050,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257741',4905051,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257741',4905052,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257742',4905053,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257742',4905054,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257742',4905055,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257742',4905056,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257742',4905057,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257743',4905058,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257743',4905059,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257743',4905060,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257743',4905061,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257743',4905062,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257744',4905063,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257744',4905064,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257744',4905065,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257744',4905066,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257744',4905067,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257745',4905068,'2689','403',1153324.90,1153324.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257745',4905069,'2690','403',1004443.72,1004443.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257745',4905070,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257745',4905071,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257745',4905072,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257746',4905073,'2689','403',1153324.90,1154643.22,1318.32,243889.20,0.00,0.00,0.00,0.00,0.00),('5','175','908','257746',4905074,'2690','403',1004443.72,1005791.40,1347.68,249320.80,0.00,0.00,0.00,0.00,0.00),('5','175','909','257746',4905075,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257746',4905076,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257746',4905077,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257747',4905078,'2689','403',1154643.22,1158249.49,3606.27,667159.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257747',4905079,'2690','403',1005791.40,1008195.20,2403.80,444703.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257747',4905080,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257747',4905081,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257747',4905082,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257748',4905083,'2689','403',1158249.49,1160432.05,2182.56,403773.60,0.00,0.00,0.00,0.00,0.00),('5','175','908','257748',4905084,'2690','403',1008195.20,1010972.65,2777.45,513828.25,0.00,0.00,0.00,0.00,0.00),('5','175','909','257748',4905085,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257748',4905086,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257748',4905087,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257749',4905088,'2689','403',1160432.05,1164354.03,3921.98,725566.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257749',4905089,'2690','403',1010972.65,1012396.26,1423.61,263367.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','257749',4905090,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257749',4905091,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257749',4905092,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257750',4905093,'2689','403',1164354.03,1166170.74,1816.71,336091.35,0.00,0.00,0.00,0.00,0.00),('5','175','908','257750',4905094,'2690','403',1012396.26,1014178.82,1782.56,329773.60,0.00,0.00,0.00,0.00,0.00),('5','175','909','257750',4905095,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257750',4905096,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257750',4905097,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257751',4905098,'2689','403',1166170.74,1168668.37,2497.63,462061.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257751',4905099,'2690','403',1014178.82,1015857.44,1678.62,310544.70,0.00,0.00,0.00,0.00,0.00),('5','175','909','257751',4905100,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257751',4905101,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257751',4905102,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257752',4905103,'2689','403',1168668.37,1171014.71,2346.34,434072.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257752',4905104,'2690','403',1015857.44,1017742.71,1885.27,348774.95,0.00,0.00,0.00,0.00,0.00),('5','175','909','257752',4905105,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257752',4905106,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257752',4905107,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257753',4905108,'2689','403',1171014.71,1173508.45,2493.74,461341.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257753',4905109,'2690','403',1017742.71,1019755.26,2012.55,372321.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257753',4905110,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257753',4905111,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257753',4905112,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257754',4905113,'2689','403',1173508.45,1175490.28,1981.83,366638.55,0.00,0.00,0.00,0.00,0.00),('5','175','908','257754',4905114,'2690','403',1019755.26,1021799.43,2044.17,378171.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','257754',4905115,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257754',4905116,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257754',4905117,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257755',4905118,'2689','403',1175490.28,1176790.46,1300.18,240533.30,0.00,0.00,0.00,0.00,0.00),('5','175','908','257755',4905119,'2690','403',1021799.43,1024066.29,2266.86,419369.10,0.00,0.00,0.00,0.00,0.00),('5','175','909','257755',4905120,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257755',4905121,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257755',4905122,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257756',4905123,'2689','403',1176790.46,1178984.74,2194.28,405941.80,0.00,0.00,0.00,0.00,0.00),('5','175','908','257756',4905124,'2690','403',1024066.29,1024066.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257756',4905125,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257756',4905126,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257756',4905127,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257757',4905128,'2689','403',1178984.74,1180062.27,1077.53,199343.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','257757',4905129,'2690','403',1024066.29,1024169.23,102.94,19043.90,0.00,0.00,0.00,0.00,0.00),('5','175','909','257757',4905130,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257757',4905131,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257757',4905132,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257758',4905133,'2689','403',1180062.27,1182466.46,2404.19,444775.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','257758',4905134,'2690','403',1024169.23,1025944.15,1774.92,328360.20,0.00,0.00,0.00,0.00,0.00),('5','175','909','257758',4905135,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257758',4905136,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257758',4905137,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257759',4905138,'2689','403',1182466.46,1184706.00,2239.54,414314.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257759',4905139,'2690','403',1025944.15,1027982.05,2037.90,377011.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257759',4905140,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257759',4905141,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257759',4905142,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257760',4905143,'2689','403',1184706.00,1188652.37,3946.37,730078.45,0.00,0.00,0.00,0.00,0.00),('5','175','908','257760',4905144,'2690','403',1027982.05,1028471.26,489.21,90503.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','257760',4905145,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257760',4905146,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257760',4905147,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257761',4905148,'2689','403',1188652.37,1189317.04,664.67,122963.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257761',4905149,'2690','403',1028471.26,1032178.27,3707.01,685796.85,0.00,0.00,0.00,0.00,0.00),('5','175','909','257761',4905150,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257761',4905151,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257761',4905152,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257762',4905153,'2689','403',1189317.04,1191049.06,1732.02,320423.70,0.00,0.00,0.00,0.00,0.00),('5','175','908','257762',4905154,'2690','403',1032178.27,1034108.37,1930.10,357068.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257762',4905155,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257762',4905156,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257762',4905157,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257763',4905158,'2689','403',1191049.06,1193203.05,2153.99,398488.15,0.00,0.00,0.00,0.00,0.00),('5','175','908','257763',4905159,'2690','403',1034108.37,1035463.15,1354.78,250634.30,0.00,0.00,0.00,0.00,0.00),('5','175','909','257763',4905160,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257763',4905161,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257763',4905162,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257764',4905163,'2689','403',1193203.05,1195125.52,1922.47,355656.95,0.00,0.00,0.00,0.00,0.00),('5','175','908','257764',4905164,'2690','403',1035463.15,1037200.32,1737.17,321376.45,0.00,0.00,0.00,0.00,0.00),('5','175','909','257764',4905165,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257764',4905166,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257764',4905167,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257765',4905168,'2689','403',1195125.52,1197612.25,2486.73,460045.05,0.00,0.00,0.00,0.00,0.00),('5','175','908','257765',4905169,'2690','403',1037200.32,1038852.22,1651.90,305601.50,0.00,0.00,0.00,0.00,0.00),('5','175','909','257765',4905170,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257765',4905171,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257765',4905172,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257766',4905173,'2689','403',1197612.25,1198802.11,1189.86,220124.10,0.00,0.00,0.00,0.00,0.00),('5','175','908','257766',4905174,'2690','403',1038852.22,1041498.25,2646.03,489515.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','257766',4905175,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257766',4905176,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257766',4905177,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257767',4905178,'2689','403',1198802.11,1201402.25,2600.14,481025.90,0.00,0.00,0.00,0.00,0.00),('5','175','908','257767',4905179,'2690','403',1041498.25,1042827.68,1329.43,245944.55,0.00,0.00,0.00,0.00,0.00),('5','175','909','257767',4905180,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257767',4905181,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257767',4905182,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257768',4905183,'2689','403',1201402.25,1202987.00,1584.75,293178.75,0.00,0.00,0.00,0.00,0.00),('5','175','908','257768',4905184,'2690','403',1042827.68,1044816.43,1988.75,367918.75,0.00,0.00,0.00,0.00,0.00),('5','175','909','257768',4905185,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257768',4905186,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257768',4905187,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257769',4905188,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257769',4905189,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257769',4905190,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257769',4905191,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257769',4905192,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257770',4905193,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257770',4905194,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257770',4905195,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257770',4905196,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257770',4905197,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257771',4905198,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257771',4905199,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257771',4905200,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257771',4905201,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257771',4905202,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257772',4905203,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257772',4905204,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257772',4905205,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257772',4905206,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257772',4905207,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257773',4905208,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257773',4905209,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257773',4905210,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257773',4905211,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257773',4905212,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257774',4905213,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257774',4905214,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257774',4905215,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257774',4905216,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257774',4905217,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257775',4905218,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257775',4905219,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257775',4905220,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257775',4905221,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257775',4905222,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257776',4905223,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257776',4905224,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257776',4905225,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257776',4905226,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257776',4905227,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257777',4905228,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257777',4905229,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257777',4905230,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257777',4905231,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257777',4905232,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257778',4905233,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257778',4905234,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257778',4905235,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257778',4905236,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257778',4905237,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257779',4905238,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257779',4905239,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257779',4905240,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257779',4905241,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257779',4905242,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257780',4905243,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257780',4905244,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257780',4905245,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257780',4905246,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257780',4905247,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257781',4905248,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257781',4905249,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257781',4905250,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257781',4905251,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257781',4905252,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257782',4905253,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257782',4905254,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257782',4905255,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257782',4905256,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257782',4905257,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257783',4905258,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257783',4905259,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257783',4905260,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257783',4905261,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257783',4905262,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257784',4905263,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257784',4905264,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257784',4905265,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257784',4905266,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257784',4905267,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257785',4905268,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257785',4905269,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257785',4905270,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257785',4905271,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257785',4905272,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257786',4905273,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257786',4905274,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257786',4905275,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257786',4905276,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257786',4905277,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257787',4905278,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257787',4905279,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257787',4905280,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257787',4905281,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257787',4905282,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257788',4905283,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257788',4905284,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257788',4905285,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257788',4905286,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257788',4905287,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257789',4905288,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257789',4905289,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257789',4905290,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257789',4905291,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257789',4905292,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257790',4905293,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257790',4905294,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257790',4905295,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257790',4905296,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257790',4905297,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257791',4905298,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257791',4905299,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257791',4905300,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257791',4905301,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257791',4905302,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257792',4905303,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257792',4905304,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257792',4905305,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257792',4905306,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257792',4905307,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257793',4905308,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257793',4905309,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257793',4905310,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257793',4905311,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257793',4905312,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257794',4905313,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257794',4905314,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257794',4905315,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257794',4905316,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257794',4905317,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257795',4905318,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257795',4905319,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257795',4905320,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257795',4905321,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257795',4905322,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257796',4905323,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257796',4905324,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257796',4905325,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257796',4905326,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257796',4905327,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257797',4905328,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257797',4905329,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257797',4905330,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257797',4905331,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257797',4905332,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257798',4905333,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257798',4905334,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257798',4905335,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257798',4905336,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257798',4905337,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257799',4905338,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257799',4905339,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257799',4905340,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257799',4905341,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257799',4905342,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257800',4905343,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257800',4905344,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257800',4905345,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257800',4905346,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257800',4905347,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257801',4905348,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257801',4905349,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257801',4905350,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257801',4905351,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257801',4905352,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257802',4905353,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257802',4905354,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257802',4905355,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257802',4905356,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257802',4905357,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257803',4905358,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257803',4905359,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257803',4905360,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257803',4905361,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257803',4905362,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257804',4905363,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257804',4905364,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257804',4905365,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257804',4905366,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257804',4905367,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257805',4905368,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257805',4905369,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257805',4905370,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257805',4905371,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257805',4905372,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257806',4905373,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257806',4905374,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257806',4905375,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257806',4905376,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257806',4905377,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257807',4905378,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257807',4905379,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257807',4905380,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257807',4905381,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257807',4905382,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257808',4905383,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257808',4905384,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257808',4905385,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257808',4905386,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257808',4905387,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257809',4905388,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257809',4905389,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257809',4905390,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257809',4905391,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257809',4905392,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257810',4905393,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257810',4905394,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257810',4905395,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257810',4905396,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257810',4905397,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257811',4905398,'2689','403',1202987.00,1202987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','908','257811',4905399,'2690','403',1044816.43,1044816.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257811',4905400,'2691','403',448217.02,448217.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','909','257811',4905401,'2692','403',353863.92,353863.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','175','910','257811',4905402,'2693','404',420250.18,420250.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730278 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','175','181515','403',0.00,0.00,1580779.58,0.00,0.00,0.00,0.00,532473),('5','175','181515','404',0.00,0.00,291151.64,0.00,0.00,0.00,0.00,532474),('5','175','181546','403',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532534),('5','175','181546','404',0.00,0.00,1122.94,0.00,0.00,0.00,0.00,532535),('5','175','181713','403',0.00,163.00,0.00,0.00,0.00,0.00,0.00,532974),('5','175','181713','404',0.00,250.00,2305.06,0.00,0.00,0.00,0.00,532975),('5','175','182007','403',0.00,163.00,0.00,0.00,0.00,0.00,0.00,533780),('5','175','182007','404',0.00,250.00,1089.88,0.00,0.00,0.00,0.00,533781),('5','175','182143','403',0.00,163.00,0.00,0.00,0.00,0.00,0.00,534133),('5','175','182143','404',0.00,250.00,207.69,0.00,0.00,0.00,0.00,534134),('5','175','182682','403',0.00,163.00,0.00,0.00,0.00,0.00,0.00,535556),('5','175','182682','404',250.00,250.00,1666.41,0.00,0.00,0.00,0.00,535557),('5','175','182884','403',0.00,163.00,5133.39,0.00,0.00,0.00,0.00,536105),('5','175','182884','404',250.00,265.00,1031.54,0.00,0.00,0.00,0.00,536106),('5','175','183000','403',163.00,163.00,10966.86,0.00,0.00,0.00,0.00,536421),('5','175','183000','404',250.00,265.00,876.81,0.00,0.00,0.00,0.00,536422),('5','175','183231','403',163.00,163.00,13022.42,0.00,0.00,0.00,0.00,537005),('5','175','183231','404',250.00,265.00,1261.84,0.00,0.00,0.00,0.00,537006),('5','175','183433','403',163.00,163.00,12078.01,0.00,0.00,0.00,0.00,537526),('5','175','183433','404',250.00,265.00,2053.07,0.00,0.00,0.00,0.00,537527),('5','175','183676','403',163.00,163.00,11634.16,0.00,0.00,0.00,0.00,538174),('5','175','183676','404',250.00,265.00,467.00,0.00,0.00,0.00,0.00,538175),('5','175','183972','403',163.00,163.00,7565.45,0.00,0.00,0.00,0.00,538963),('5','175','183972','404',250.00,255.00,1939.87,0.00,0.00,0.00,0.00,538964),('5','175','184122','403',163.00,163.00,0.00,0.00,0.00,0.00,0.00,539361),('5','175','184122','404',250.00,255.00,1529.41,0.00,0.00,0.00,0.00,539362),('5','175','184311','403',163.00,163.00,0.00,0.00,0.00,0.00,0.00,539859),('5','175','184311','404',250.00,255.00,2105.56,0.00,0.00,0.00,0.00,539860),('5','175','184501','403',163.00,163.00,10257.98,0.00,0.00,0.00,0.00,540345),('5','175','184501','404',250.00,255.00,0.00,0.00,0.00,0.00,0.00,540346),('5','175','184607','403',163.00,162.00,7125.03,0.00,0.00,0.00,0.00,540649),('5','175','184607','404',250.00,255.00,2166.51,0.00,0.00,0.00,0.00,540650),('5','175','184733','403',163.00,162.00,12144.09,0.00,0.00,0.00,0.00,540986),('5','175','184733','404',250.00,255.00,0.00,0.00,0.00,0.00,0.00,540987),('5','175','184919','403',163.00,163.00,10522.26,0.00,0.00,0.00,0.00,541475),('5','175','184919','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,541476),('5','175','185520','403',163.00,163.00,8742.93,0.00,0.00,0.00,0.00,543018),('5','175','185520','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,543019),('5','175','185675','403',163.00,163.00,10505.34,0.00,0.00,0.00,0.00,543442),('5','175','185675','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,543443),('5','175','185889','403',163.00,163.00,14548.44,0.00,0.00,0.00,0.00,544007),('5','175','185889','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,544008),('5','175','186096','403',163.00,163.00,13719.71,0.00,0.00,0.00,0.00,544558),('5','175','186096','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,544559),('5','175','186347','403',163.00,163.00,13153.82,0.00,0.00,0.00,0.00,545207),('5','175','186347','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545208),('5','175','186569','403',163.00,163.00,4419.98,0.00,0.00,0.00,0.00,545798),('5','175','186569','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545799),('5','175','187189','403',163.00,163.00,12965.72,0.00,0.00,0.00,0.00,547398),('5','175','187189','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547399),('5','175','187401','403',163.00,163.00,11707.87,0.00,0.00,0.00,0.00,547956),('5','175','187401','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547957),('5','175','187635','403',163.00,163.00,12332.49,0.00,0.00,0.00,0.00,548576),('5','175','187635','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548577),('5','175','187828','403',163.00,163.00,8091.99,0.00,0.00,0.00,0.00,549085),('5','175','187828','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549086),('5','175','188009','403',163.00,163.00,14070.90,0.00,0.00,0.00,0.00,549567),('5','175','188009','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549568),('5','175','188265','403',163.00,163.00,14374.01,0.00,0.00,0.00,0.00,550228),('5','175','188265','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,550229),('5','175','188438','403',163.00,163.00,13656.64,0.00,0.00,0.00,0.00,550666),('5','175','188438','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,550667),('5','175','188621','403',163.00,163.00,3332.68,0.00,0.00,0.00,0.00,551130),('5','175','188621','404',250.00,265.00,0.00,0.00,0.00,0.00,0.00,551131),('5','175','189509','403',163.00,165.00,0.00,0.00,0.00,0.00,0.00,553470),('5','175','189509','404',265.00,265.00,1615.64,0.00,0.00,0.00,0.00,553471),('5','175','189615','403',163.00,165.00,0.00,0.00,0.00,0.00,0.00,553748),('5','175','189615','404',265.00,265.00,1653.08,0.00,0.00,0.00,0.00,553749),('5','175','189875','403',163.00,165.00,2146.60,0.00,0.00,0.00,0.00,554406),('5','175','189875','404',265.00,265.00,842.97,0.00,0.00,0.00,0.00,554407),('5','175','190074','403',165.00,165.00,12913.11,0.00,0.00,0.00,0.00,554933),('5','175','190074','404',265.00,265.00,1471.98,0.00,0.00,0.00,0.00,554934),('5','175','190232','403',165.00,165.00,11142.52,0.00,0.00,0.00,0.00,555342),('5','175','190232','404',265.00,265.00,2014.78,0.00,0.00,0.00,0.00,555343),('5','175','190438','403',165.00,165.00,8961.47,0.00,0.00,0.00,0.00,555885),('5','175','190438','404',265.00,265.00,1574.14,0.00,0.00,0.00,0.00,555886),('5','175','190704','403',165.00,165.00,4681.16,0.00,0.00,0.00,0.00,556587),('5','175','190704','404',265.00,265.00,1344.22,0.00,0.00,0.00,0.00,556588),('5','175','190921','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,557155),('5','175','190921','404',265.00,265.00,1089.76,0.00,0.00,0.00,0.00,557156),('5','175','191102','403',165.00,165.00,3595.19,0.00,0.00,0.00,0.00,557628),('5','175','191102','404',265.00,265.00,1270.44,0.00,0.00,0.00,0.00,557629),('5','175','191280','403',165.00,165.00,11730.00,0.00,0.00,0.00,0.00,558117),('5','175','191280','404',265.00,265.00,1197.82,0.00,0.00,0.00,0.00,558118),('5','175','191505','403',165.00,165.00,10250.69,0.00,0.00,0.00,0.00,558694),('5','175','191505','404',265.00,265.00,933.40,0.00,0.00,0.00,0.00,558695),('5','175','191709','403',165.00,165.00,10208.63,0.00,0.00,0.00,0.00,559248),('5','175','191709','404',265.00,265.00,0.00,0.00,0.00,0.00,0.00,559249),('5','175','191947','403',165.00,165.00,4591.08,0.00,0.00,0.00,0.00,559878),('5','175','191947','404',265.00,265.00,0.00,0.00,0.00,0.00,0.00,559879),('5','175','193209','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,563191),('5','175','193209','404',265.00,265.00,2078.02,0.00,0.00,0.00,0.00,563192),('5','175','193408','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,563719),('5','175','193408','404',265.00,265.00,989.62,0.00,0.00,0.00,0.00,563720),('5','175','193640','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564311),('5','175','193640','404',265.00,265.00,1086.21,0.00,0.00,0.00,0.00,564312),('5','175','193880','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564911),('5','175','193880','404',265.00,265.00,1253.96,0.00,0.00,0.00,0.00,564912),('5','175','194188','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,565702),('5','175','194188','404',265.00,265.00,1349.64,0.00,0.00,0.00,0.00,565703),('5','175','194381','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,566195),('5','175','194381','404',265.00,265.00,2218.68,0.00,0.00,0.00,0.00,566196),('5','175','194492','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,566472),('5','175','194492','404',265.00,265.00,1690.97,0.00,0.00,0.00,0.00,566473),('5','175','194708','403',165.00,165.00,6660.86,0.00,0.00,0.00,0.00,567020),('5','175','194708','404',265.00,265.00,858.32,0.00,0.00,0.00,0.00,567021),('5','175','194918','403',165.00,165.00,7012.74,0.00,0.00,0.00,0.00,567586),('5','175','194918','404',265.00,265.00,1142.43,0.00,0.00,0.00,0.00,567587),('5','175','195287','403',165.00,165.00,6675.20,0.00,0.00,0.00,0.00,568556),('5','175','195287','404',265.00,265.00,1778.38,0.00,0.00,0.00,0.00,568557),('5','175','195437','403',165.00,165.00,8890.71,0.00,0.00,0.00,0.00,568924),('5','175','195437','404',265.00,265.00,812.30,0.00,0.00,0.00,0.00,568925),('5','175','195543','403',165.00,165.00,7134.06,0.00,0.00,0.00,0.00,569190),('5','175','195543','404',265.00,265.00,983.19,0.00,0.00,0.00,0.00,569191),('5','175','195972','403',165.00,165.00,3714.37,0.00,0.00,0.00,0.00,570282),('5','175','195972','404',265.00,265.00,759.24,0.00,0.00,0.00,0.00,570283),('5','175','196071','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,570522),('5','175','196071','404',265.00,265.00,796.63,0.00,0.00,0.00,0.00,570523),('5','175','196336','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571189),('5','175','196336','404',265.00,265.00,438.38,0.00,0.00,0.00,0.00,571190),('5','175','196540','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571721),('5','175','196540','404',265.00,265.00,393.98,0.00,0.00,0.00,0.00,571722),('5','175','196858','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,572556),('5','175','196858','404',265.00,265.00,690.65,0.00,0.00,0.00,0.00,572557),('5','175','196893','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,572642),('5','175','196893','404',265.00,265.00,1079.42,0.00,0.00,0.00,0.00,572643),('5','175','197206','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,573463),('5','175','197206','404',265.00,265.00,716.20,0.00,0.00,0.00,0.00,573464),('5','175','197508','403',165.00,165.00,5544.01,0.00,0.00,0.00,0.00,574152),('5','175','197508','404',265.00,265.00,1915.10,0.00,0.00,0.00,0.00,574153),('5','175','197760','403',165.00,165.00,5402.12,0.00,0.00,0.00,0.00,574815),('5','175','197760','404',265.00,265.00,711.63,0.00,0.00,0.00,0.00,574816),('5','175','197766','403',165.00,165.00,6282.04,0.00,0.00,0.00,0.00,574832),('5','175','197766','404',265.00,265.00,705.87,0.00,0.00,0.00,0.00,574833),('5','175','198096','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,575708),('5','175','198096','404',265.00,265.00,0.00,0.00,0.00,0.00,0.00,575709),('5','175','198139','403',165.00,165.00,5718.52,0.00,0.00,0.00,0.00,575796),('5','175','198139','404',270.00,270.00,1122.61,0.00,0.00,0.00,0.00,575797),('5','175','198260','403',165.00,165.00,6946.92,0.00,0.00,0.00,0.00,576116),('5','175','198260','404',270.00,270.00,1260.96,0.00,0.00,0.00,0.00,576117),('5','175','198387','403',165.00,165.00,6892.50,0.00,0.00,0.00,0.00,576439),('5','175','198387','404',270.00,270.00,933.92,0.00,0.00,0.00,0.00,576440),('5','175','198645','403',165.00,165.00,6513.53,0.00,0.00,0.00,0.00,577125),('5','175','198645','404',270.00,270.00,990.01,0.00,0.00,0.00,0.00,577126),('5','175','199046','403',165.00,165.00,6672.92,0.00,0.00,0.00,0.00,578135),('5','175','199046','404',270.00,270.00,1305.44,0.00,0.00,0.00,0.00,578136),('5','175','199056','403',165.00,165.00,6550.92,0.00,0.00,0.00,0.00,578163),('5','175','199056','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,578164),('5','175','199211','403',165.00,165.00,6865.86,0.00,0.00,0.00,0.00,578543),('5','175','199211','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,578544),('5','175','199426','403',165.00,165.00,8093.14,0.00,0.00,0.00,0.00,579082),('5','175','199426','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,579083),('5','175','199675','403',165.00,165.00,7618.74,0.00,0.00,0.00,0.00,579680),('5','175','199675','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,579681),('5','175','199893','403',165.00,165.00,7713.27,0.00,0.00,0.00,0.00,580213),('5','175','199893','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,580214),('5','175','200106','403',165.00,165.00,6936.33,0.00,0.00,0.00,0.00,580779),('5','175','200106','404',270.00,270.00,0.00,0.00,0.00,0.00,0.00,580780),('5','175','200315','403',165.00,165.00,7403.13,0.00,0.00,0.00,0.00,581323),('5','175','200315','404',270.00,270.00,628.20,0.00,0.00,0.00,0.00,581324),('5','175','200506','403',165.00,165.00,7273.16,0.00,0.00,0.00,0.00,581818),('5','175','200506','404',270.00,270.00,904.48,0.00,0.00,0.00,0.00,581819),('5','175','200707','403',165.00,165.00,8871.41,0.00,0.00,0.00,0.00,582348),('5','175','200707','404',270.00,270.00,2747.26,0.00,0.00,0.00,0.00,582349),('5','175','200919','403',165.00,165.00,9707.45,0.00,0.00,0.00,0.00,582889),('5','175','200919','404',270.00,270.00,1424.38,0.00,0.00,0.00,0.00,582890),('5','175','201122','403',165.00,165.00,9236.46,0.00,0.00,0.00,0.00,583397),('5','175','201122','404',270.00,270.00,3587.57,0.00,0.00,0.00,0.00,583398),('5','175','201321','403',165.00,165.00,8233.90,0.00,0.00,0.00,0.00,583918),('5','175','201321','404',270.00,270.00,3167.56,0.00,0.00,0.00,0.00,583919),('5','175','201511','403',165.00,165.00,6855.73,0.00,0.00,0.00,0.00,584410),('5','175','201511','404',270.00,270.00,1232.23,0.00,0.00,0.00,0.00,584411),('5','175','201760','403',165.00,165.00,6239.40,0.00,0.00,0.00,0.00,585079),('5','175','201760','404',270.00,275.00,1312.49,0.00,0.00,0.00,0.00,585080),('5','175','202030','403',165.00,165.00,5823.76,0.00,0.00,0.00,0.00,585792),('5','175','202030','404',270.00,275.00,1856.56,0.00,0.00,0.00,0.00,585793),('5','175','202240','403',165.00,165.00,4889.96,0.00,0.00,0.00,0.00,586322),('5','175','202240','404',270.00,275.00,2574.54,0.00,0.00,0.00,0.00,586323),('5','175','202456','403',165.00,165.00,5137.92,0.00,0.00,0.00,0.00,586870),('5','175','202456','404',275.00,275.00,1392.61,0.00,0.00,0.00,0.00,586871),('5','175','202655','403',165.00,165.00,4775.40,0.00,0.00,0.00,0.00,587387),('5','175','202655','404',275.00,275.00,1995.95,0.00,0.00,0.00,0.00,587388),('5','175','202857','403',165.00,165.00,4725.43,0.00,0.00,0.00,0.00,587909),('5','175','202857','404',275.00,275.00,1287.84,0.00,0.00,0.00,0.00,587910),('5','175','203124','403',165.00,165.00,4778.61,0.00,0.00,0.00,0.00,588596),('5','175','203124','404',275.00,275.00,187.20,0.00,0.00,0.00,0.00,588597),('5','175','203322','403',165.00,165.00,4341.08,0.00,0.00,0.00,0.00,589121),('5','175','203322','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,589122),('5','175','203528','403',165.00,165.00,4172.85,0.00,0.00,0.00,0.00,589642),('5','175','203528','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,589643),('5','175','203737','403',165.00,165.00,4807.22,0.00,0.00,0.00,0.00,590183),('5','175','203737','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590184),('5','175','203973','403',165.00,165.00,4994.43,0.00,0.00,0.00,0.00,590787),('5','175','203973','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590788),('5','175','204191','403',165.00,165.00,4527.81,0.00,0.00,0.00,0.00,591368),('5','175','204191','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,591369),('5','175','204404','403',165.00,165.00,4073.42,0.00,0.00,0.00,0.00,591912),('5','175','204404','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,591913),('5','175','204626','403',165.00,165.00,4110.40,0.00,0.00,0.00,0.00,592481),('5','175','204626','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592482),('5','175','204842','403',165.00,165.00,4153.94,0.00,0.00,0.00,0.00,592998),('5','175','204842','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592999),('5','175','205055','403',165.00,165.00,4046.20,0.00,0.00,0.00,0.00,593537),('5','175','205055','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593538),('5','175','205218','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,593985),('5','175','205218','404',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593986),('5','175','205237','403',165.00,165.00,4523.54,0.00,0.00,0.00,0.00,594027),('5','175','205237','404',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594028),('5','175','205479','403',165.00,165.00,4554.97,0.00,0.00,0.00,0.00,594633),('5','175','205479','404',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594634),('5','175','205719','403',165.00,165.00,4352.51,0.00,0.00,0.00,0.00,595275),('5','175','205719','404',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595276),('5','175','206014','403',165.00,165.00,4465.21,0.00,0.00,0.00,0.00,596028),('5','175','206014','404',275.00,280.00,0.00,0.00,0.00,0.00,0.00,596029),('5','175','206219','403',165.00,165.00,4075.42,0.00,0.00,0.00,0.00,596554),('5','175','206219','404',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596555),('5','175','206375','403',165.00,165.00,3387.87,0.00,0.00,0.00,0.00,596943),('5','175','206375','404',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596944),('5','175','206772','403',165.00,165.00,3643.14,0.00,0.00,0.00,0.00,597974),('5','175','206772','404',275.00,290.00,0.00,0.00,0.00,0.00,0.00,597975),('5','175','206819','403',165.00,165.00,3891.99,0.00,0.00,0.00,0.00,598080),('5','175','206819','404',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598081),('5','175','207028','403',165.00,165.00,3584.45,0.00,0.00,0.00,0.00,598630),('5','175','207028','404',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598631),('5','175','207270','403',165.00,165.00,4576.87,0.00,0.00,0.00,0.00,599249),('5','175','207270','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,599250),('5','175','207490','403',165.00,165.00,4641.45,0.00,0.00,0.00,0.00,599821),('5','175','207490','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,599822),('5','175','207708','403',165.00,165.00,4579.38,0.00,0.00,0.00,0.00,600373),('5','175','207708','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600374),('5','175','207926','403',165.00,165.00,4752.32,0.00,0.00,0.00,0.00,600927),('5','175','207926','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600928),('5','175','208118','403',165.00,165.00,3972.15,0.00,0.00,0.00,0.00,601420),('5','175','208118','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,601421),('5','175','208337','403',165.00,165.00,4430.96,0.00,0.00,0.00,0.00,601986),('5','175','208337','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,601987),('5','175','208546','403',165.00,165.00,3900.36,0.00,0.00,0.00,0.00,602528),('5','175','208546','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,602529),('5','175','208764','403',165.00,165.00,3957.58,0.00,0.00,0.00,0.00,603084),('5','175','208764','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603085),('5','175','208984','403',165.00,165.00,4011.67,0.00,0.00,0.00,0.00,603648),('5','175','208984','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603649),('5','175','209255','403',165.00,165.00,3009.16,0.00,0.00,0.00,0.00,604325),('5','175','209255','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,604326),('5','175','209455','403',165.00,165.00,3922.25,0.00,0.00,0.00,0.00,604830),('5','175','209455','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,604831),('5','175','209656','403',165.00,165.00,3686.36,0.00,0.00,0.00,0.00,605347),('5','175','209656','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605348),('5','175','209891','403',165.00,165.00,3462.29,0.00,0.00,0.00,0.00,605956),('5','175','209891','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605957),('5','175','210107','403',165.00,165.00,3653.98,0.00,0.00,0.00,0.00,606524),('5','175','210107','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,606525),('5','175','210325','403',165.00,165.00,3947.78,0.00,0.00,0.00,0.00,607084),('5','175','210325','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,607085),('5','175','210524','403',165.00,165.00,3600.29,0.00,0.00,0.00,0.00,607612),('5','175','210524','404',290.00,290.00,0.00,0.00,0.00,0.00,0.00,607613),('5','175','210732','403',165.00,165.00,3682.94,0.00,0.00,0.00,0.00,608159),('5','175','210732','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,608160),('5','175','210954','403',165.00,165.00,4088.41,0.00,0.00,0.00,0.00,608733),('5','175','210954','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,608734),('5','175','211193','403',165.00,165.00,3416.39,0.00,0.00,0.00,0.00,609332),('5','175','211193','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,609333),('5','175','211411','403',165.00,165.00,5491.57,0.00,0.00,0.00,0.00,609911),('5','175','211411','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,609912),('5','175','211664','403',165.00,165.00,4624.23,0.00,0.00,0.00,0.00,610562),('5','175','211664','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,610563),('5','175','211782','403',165.00,165.00,3977.54,0.00,0.00,0.00,0.00,610859),('5','175','211782','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,610860),('5','175','212004','403',165.00,165.00,3689.17,0.00,0.00,0.00,0.00,611435),('5','175','212004','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,611436),('5','175','212237','403',165.00,165.00,4088.60,0.00,0.00,0.00,0.00,612046),('5','175','212237','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,612047),('5','175','212485','403',165.00,165.00,1207.74,0.00,0.00,0.00,0.00,612700),('5','175','212485','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,612701),('5','175','212661','403',165.00,165.00,3276.36,0.00,0.00,0.00,0.00,613181),('5','175','212661','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,613182),('5','175','212874','403',165.00,165.00,3231.83,0.00,0.00,0.00,0.00,613726),('5','175','212874','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,613727),('5','175','213129','403',165.00,165.00,3217.22,0.00,0.00,0.00,0.00,614397),('5','175','213129','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,614398),('5','175','213378','403',165.00,165.00,3315.91,0.00,0.00,0.00,0.00,615046),('5','175','213378','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,615047),('5','175','213741','403',165.00,165.00,3486.12,0.00,0.00,0.00,0.00,615995),('5','175','213741','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,615996),('5','175','213911','403',165.00,165.00,3296.36,0.00,0.00,0.00,0.00,616429),('5','175','213911','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,616430),('5','175','214262','403',165.00,165.00,2922.32,0.00,0.00,0.00,0.00,617358),('5','175','214262','404',290.00,295.00,0.00,0.00,0.00,0.00,0.00,617359),('5','175','214454','403',165.00,165.00,3072.20,0.00,0.00,0.00,0.00,617853),('5','175','214454','404',290.00,295.00,120.83,0.00,0.00,0.00,0.00,617854),('5','175','214557','403',165.00,165.00,3276.29,0.00,0.00,0.00,0.00,618101),('5','175','214557','404',295.00,295.00,119.66,0.00,0.00,0.00,0.00,618102),('5','175','214825','403',165.00,165.00,1909.12,0.00,0.00,0.00,0.00,618809),('5','175','214825','404',295.00,295.00,236.98,0.00,0.00,0.00,0.00,618810),('5','175','215195','403',165.00,165.00,1294.99,0.00,0.00,0.00,0.00,619775),('5','175','215195','404',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619776),('5','175','215325','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,620109),('5','175','215325','404',295.00,295.00,91.52,0.00,0.00,0.00,0.00,620110),('5','175','215526','403',165.00,165.00,6320.18,0.00,0.00,0.00,0.00,620618),('5','175','215526','404',295.00,295.00,343.32,0.00,0.00,0.00,0.00,620619),('5','175','215771','403',165.00,165.00,3070.75,0.00,0.00,0.00,0.00,621252),('5','175','215771','404',295.00,295.00,162.42,0.00,0.00,0.00,0.00,621253),('5','175','215986','403',165.00,165.00,2007.97,0.00,0.00,0.00,0.00,621806),('5','175','215986','404',295.00,295.00,560.08,0.00,0.00,0.00,0.00,621807),('5','175','216152','403',165.00,165.00,4231.70,0.00,0.00,0.00,0.00,622229),('5','175','216152','404',295.00,295.00,211.23,0.00,0.00,0.00,0.00,622230),('5','175','216332','403',165.00,165.00,2758.67,0.00,0.00,0.00,0.00,622702),('5','175','216332','404',295.00,295.00,172.10,0.00,0.00,0.00,0.00,622703),('5','175','216570','403',165.00,165.00,2666.87,0.00,0.00,0.00,0.00,623326),('5','175','216570','404',295.00,295.00,385.02,0.00,0.00,0.00,0.00,623327),('5','175','216809','403',165.00,165.00,2727.60,0.00,0.00,0.00,0.00,623958),('5','175','216809','404',295.00,295.00,83.73,0.00,0.00,0.00,0.00,623959),('5','175','217046','403',165.00,165.00,2665.20,0.00,0.00,0.00,0.00,624575),('5','175','217046','404',295.00,295.00,311.04,0.00,0.00,0.00,0.00,624576),('5','175','217280','403',165.00,165.00,3930.79,0.00,0.00,0.00,0.00,625198),('5','175','217280','404',295.00,295.00,228.22,0.00,0.00,0.00,0.00,625199),('5','175','217680','403',165.00,165.00,3069.65,0.00,0.00,0.00,0.00,626255),('5','175','217680','404',295.00,295.00,1391.38,0.00,0.00,0.00,0.00,626256),('5','175','217713','403',165.00,165.00,3123.15,0.00,0.00,0.00,0.00,626323),('5','175','217713','404',295.00,295.00,351.90,0.00,0.00,0.00,0.00,626324),('5','175','218016','403',165.00,165.00,3195.42,0.00,0.00,0.00,0.00,627118),('5','175','218016','404',295.00,295.00,220.31,0.00,0.00,0.00,0.00,627119),('5','175','218223','403',165.00,165.00,3085.90,0.00,0.00,0.00,0.00,627672),('5','175','218223','404',295.00,295.00,401.67,0.00,0.00,0.00,0.00,627673),('5','175','218475','403',165.00,165.00,2960.19,0.00,0.00,0.00,0.00,628324),('5','175','218475','404',295.00,295.00,214.64,0.00,0.00,0.00,0.00,628325),('5','175','218732','403',165.00,165.00,3762.64,0.00,0.00,0.00,0.00,628988),('5','175','218732','404',295.00,295.00,220.81,0.00,0.00,0.00,0.00,628989),('5','175','219002','403',165.00,165.00,4034.24,0.00,0.00,0.00,0.00,629700),('5','175','219002','404',295.00,295.00,273.06,0.00,0.00,0.00,0.00,629701),('5','175','219158','403',165.00,165.00,2969.13,0.00,0.00,0.00,0.00,630104),('5','175','219158','404',295.00,295.00,323.47,0.00,0.00,0.00,0.00,630105),('5','175','219329','403',165.00,165.00,2838.07,0.00,0.00,0.00,0.00,630563),('5','175','219329','404',295.00,295.00,63.05,0.00,0.00,0.00,0.00,630564),('5','175','219633','403',165.00,165.00,3259.96,0.00,0.00,0.00,0.00,631350),('5','175','219633','404',295.00,295.00,68.27,0.00,0.00,0.00,0.00,631351),('5','175','219812','403',165.00,165.00,2870.13,0.00,0.00,0.00,0.00,631827),('5','175','219812','404',295.00,295.00,321.38,0.00,0.00,0.00,0.00,631828),('5','175','220086','403',165.00,165.00,1223.75,0.00,0.00,0.00,0.00,632550),('5','175','220086','404',295.00,295.00,178.43,0.00,0.00,0.00,0.00,632551),('5','175','220266','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,633027),('5','175','220266','404',295.00,295.00,93.68,0.00,0.00,0.00,0.00,633028),('5','175','220476','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,633577),('5','175','220476','404',295.00,295.00,175.22,0.00,0.00,0.00,0.00,633578),('5','175','220726','403',165.00,165.00,1238.92,0.00,0.00,0.00,0.00,634225),('5','175','220726','404',295.00,295.00,164.60,0.00,0.00,0.00,0.00,634226),('5','175','220905','403',165.00,165.00,2848.01,0.00,0.00,0.00,0.00,634702),('5','175','220905','404',295.00,295.00,234.40,0.00,0.00,0.00,0.00,634703),('5','175','221145','403',165.00,165.00,2967.46,0.00,0.00,0.00,0.00,635316),('5','175','221145','404',295.00,295.00,427.22,0.00,0.00,0.00,0.00,635317),('5','175','221401','403',165.00,165.00,3057.20,0.00,0.00,0.00,0.00,635982),('5','175','221401','404',295.00,295.00,212.84,0.00,0.00,0.00,0.00,635983),('5','175','221617','403',165.00,165.00,3237.15,0.00,0.00,0.00,0.00,636555),('5','175','221617','404',295.00,295.00,380.66,0.00,0.00,0.00,0.00,636556),('5','175','221836','403',165.00,165.00,3264.30,0.00,0.00,0.00,0.00,637122),('5','175','221836','404',295.00,295.00,386.08,0.00,0.00,0.00,0.00,637123),('5','175','222062','403',165.00,165.00,3569.59,0.00,0.00,0.00,0.00,637714),('5','175','222062','404',295.00,295.00,156.75,0.00,0.00,0.00,0.00,637715),('5','175','222265','403',165.00,165.00,3175.71,0.00,0.00,0.00,0.00,638228),('5','175','222265','404',295.00,295.00,193.60,0.00,0.00,0.00,0.00,638229),('5','175','222497','403',165.00,165.00,3101.11,0.00,0.00,0.00,0.00,638819),('5','175','222497','404',295.00,295.00,390.02,0.00,0.00,0.00,0.00,638820),('5','175','222738','403',165.00,165.00,2226.74,0.00,0.00,0.00,0.00,639463),('5','175','222738','404',295.00,295.00,186.89,0.00,0.00,0.00,0.00,639464),('5','175','222957','403',165.00,165.00,1245.37,0.00,0.00,0.00,0.00,640054),('5','175','222957','404',295.00,295.00,162.90,0.00,0.00,0.00,0.00,640055),('5','175','223219','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,640715),('5','175','223219','404',295.00,295.00,132.16,0.00,0.00,0.00,0.00,640716),('5','175','223446','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,641270),('5','175','223446','404',295.00,295.00,127.45,0.00,0.00,0.00,0.00,641271),('5','175','223641','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,641778),('5','175','223641','404',295.00,295.00,197.20,0.00,0.00,0.00,0.00,641779),('5','175','224045','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,642833),('5','175','224045','404',295.00,295.00,208.12,0.00,0.00,0.00,0.00,642834),('5','175','224118','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,643006),('5','175','224118','404',295.00,295.00,120.16,0.00,0.00,0.00,0.00,643007),('5','175','224317','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,643523),('5','175','224317','404',295.00,295.00,343.00,0.00,0.00,0.00,0.00,643524),('5','175','224530','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644094),('5','175','224530','404',295.00,295.00,254.56,0.00,0.00,0.00,0.00,644095),('5','175','224776','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,644720),('5','175','224776','404',295.00,295.00,337.79,0.00,0.00,0.00,0.00,644721),('5','175','225043','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,645391),('5','175','225043','404',295.00,295.00,206.20,0.00,0.00,0.00,0.00,645392),('5','175','225262','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,645977),('5','175','225262','404',295.00,295.00,209.49,0.00,0.00,0.00,0.00,645978),('5','175','225502','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,646581),('5','175','225502','404',295.00,295.00,86.60,0.00,0.00,0.00,0.00,646582),('5','175','225707','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,647118),('5','175','225707','404',295.00,295.00,328.76,0.00,0.00,0.00,0.00,647119),('5','175','226008','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,647899),('5','175','226008','404',295.00,295.00,90.88,0.00,0.00,0.00,0.00,647900),('5','175','226301','403',165.00,163.00,0.00,0.00,0.00,0.00,0.00,648668),('5','175','226301','404',295.00,295.00,188.29,0.00,0.00,0.00,0.00,648669),('5','175','226490','403',165.00,165.00,1881.60,0.00,0.00,0.00,0.00,649140),('5','175','226490','404',295.00,295.00,228.90,0.00,0.00,0.00,0.00,649141),('5','175','226809','403',165.00,165.00,2058.79,0.00,0.00,0.00,0.00,649974),('5','175','226809','404',295.00,295.00,154.32,0.00,0.00,0.00,0.00,649975),('5','175','226999','403',165.00,165.00,1835.19,0.00,0.00,0.00,0.00,650470),('5','175','226999','404',295.00,295.00,149.63,0.00,0.00,0.00,0.00,650471),('5','175','227204','403',165.00,165.00,2245.89,0.00,0.00,0.00,0.00,651001),('5','175','227204','404',295.00,295.00,211.88,0.00,0.00,0.00,0.00,651002),('5','175','227399','403',165.00,165.00,2878.86,0.00,0.00,0.00,0.00,651498),('5','175','227399','404',295.00,295.00,141.02,0.00,0.00,0.00,0.00,651499),('5','175','227627','403',165.00,165.00,2785.97,0.00,0.00,0.00,0.00,652083),('5','175','227627','404',295.00,300.00,654.98,0.00,0.00,0.00,0.00,652084),('5','175','227883','403',165.00,165.00,3312.63,0.00,0.00,0.00,0.00,652749),('5','175','227883','404',295.00,300.00,255.99,0.00,0.00,0.00,0.00,652750),('5','175','229277','403',165.00,165.00,3132.74,0.00,0.00,0.00,0.00,656362),('5','175','229277','404',295.00,300.00,414.68,0.00,0.00,0.00,0.00,656363),('5','175','229278','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,656364),('5','175','229278','404',295.00,300.00,0.00,0.00,0.00,0.00,0.00,656365),('5','175','230754','403',163.00,165.00,0.00,0.00,0.00,0.00,0.00,660196),('5','175','230754','404',300.00,300.00,0.00,0.00,0.00,0.00,0.00,660197),('5','175','230755','403',165.00,165.00,3072.25,0.00,0.00,0.00,0.00,660198),('5','175','230755','404',300.00,300.00,1463.69,0.00,0.00,0.00,0.00,660199),('5','175','230757','403',165.00,165.00,2832.35,0.00,0.00,0.00,0.00,660202),('5','175','230757','404',300.00,300.00,261.34,0.00,0.00,0.00,0.00,660203),('5','175','230759','403',165.00,165.00,2664.67,0.00,0.00,0.00,0.00,660205),('5','175','230759','404',300.00,300.00,202.90,0.00,0.00,0.00,0.00,660206),('5','175','230765','403',165.00,165.00,2649.41,0.00,0.00,0.00,0.00,660220),('5','175','230765','404',300.00,300.00,127.53,0.00,0.00,0.00,0.00,660221),('5','175','230837','403',165.00,165.00,3139.84,0.00,0.00,0.00,0.00,660382),('5','175','230837','404',300.00,300.00,193.09,0.00,0.00,0.00,0.00,660383),('5','175','230840','403',165.00,165.00,2958.83,0.00,0.00,0.00,0.00,660388),('5','175','230840','404',300.00,310.00,511.22,0.00,0.00,0.00,0.00,660389),('5','175','230846','403',165.00,165.00,3503.87,0.00,0.00,0.00,0.00,660403),('5','175','230846','404',310.00,310.00,247.75,0.00,0.00,0.00,0.00,660404),('5','175','230847','403',165.00,165.00,3311.45,0.00,0.00,0.00,0.00,660405),('5','175','230847','404',310.00,310.00,355.39,0.00,0.00,0.00,0.00,660406),('5','175','230848','403',165.00,165.00,2740.24,0.00,0.00,0.00,0.00,660407),('5','175','230848','404',310.00,310.00,272.28,0.00,0.00,0.00,0.00,660408),('5','175','230850','403',165.00,165.00,322.07,0.00,0.00,0.00,0.00,660412),('5','175','230850','404',310.00,310.00,116.53,0.00,0.00,0.00,0.00,660413),('5','175','230855','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,660425),('5','175','230855','404',320.00,320.00,252.14,0.00,0.00,0.00,0.00,660426),('5','175','230858','403',165.00,165.00,2245.34,0.00,0.00,0.00,0.00,660433),('5','175','230858','404',320.00,320.00,310.92,0.00,0.00,0.00,0.00,660434),('5','175','231101','403',165.00,165.00,2250.01,0.00,0.00,0.00,0.00,661084),('5','175','231101','404',320.00,320.00,418.05,0.00,0.00,0.00,0.00,661085),('5','175','231417','403',165.00,165.00,2600.26,0.00,0.00,0.00,0.00,661929),('5','175','231417','404',320.00,320.00,306.84,0.00,0.00,0.00,0.00,661930),('5','175','231669','403',165.00,165.00,2999.40,0.00,0.00,0.00,0.00,662587),('5','175','231669','404',320.00,320.00,330.82,0.00,0.00,0.00,0.00,662588),('5','175','231991','403',165.00,165.00,2586.16,0.00,0.00,0.00,0.00,663472),('5','175','231991','404',320.00,320.00,281.90,0.00,0.00,0.00,0.00,663473),('5','175','232184','403',165.00,165.00,2957.59,0.00,0.00,0.00,0.00,663972),('5','175','232184','404',327.00,327.00,472.60,0.00,0.00,0.00,0.00,663973),('5','175','232341','403',165.00,165.00,2773.70,0.00,0.00,0.00,0.00,664372),('5','175','232341','404',327.00,327.00,359.77,0.00,0.00,0.00,0.00,664373),('5','175','232647','403',165.00,165.00,3096.95,0.00,0.00,0.00,0.00,665186),('5','175','232647','404',327.00,327.00,469.82,0.00,0.00,0.00,0.00,665187),('5','175','232887','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,665817),('5','175','232887','404',327.00,327.00,72.54,0.00,0.00,0.00,0.00,665818),('5','175','233023','403',165.00,165.00,2874.22,0.00,0.00,0.00,0.00,666193),('5','175','233023','404',345.00,345.00,159.80,0.00,0.00,0.00,0.00,666194),('5','175','233126','403',165.00,165.00,3191.25,0.00,0.00,0.00,0.00,666435),('5','175','233126','404',345.00,345.00,397.65,0.00,0.00,0.00,0.00,666436),('5','175','233422','403',165.00,165.00,3919.09,0.00,0.00,0.00,0.00,667215),('5','175','233422','404',345.00,345.00,363.54,0.00,0.00,0.00,0.00,667216),('5','175','233654','403',165.00,165.00,4839.26,0.00,0.00,0.00,0.00,667821),('5','175','233654','404',345.00,345.00,677.02,0.00,0.00,0.00,0.00,667822),('5','175','233850','403',165.00,165.00,3688.82,0.00,0.00,0.00,0.00,668340),('5','175','233850','404',345.00,345.00,1255.31,0.00,0.00,0.00,0.00,668341),('5','175','234053','403',165.00,165.00,2187.86,0.00,0.00,0.00,0.00,668881),('5','175','234053','404',345.00,345.00,207.27,0.00,0.00,0.00,0.00,668882),('5','175','234406','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,669817),('5','175','234406','404',345.00,345.00,174.19,0.00,0.00,0.00,0.00,669818),('5','175','234657','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,670478),('5','175','234657','404',345.00,345.00,148.24,0.00,0.00,0.00,0.00,670479),('5','175','234870','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671034),('5','175','234870','404',345.00,345.00,137.44,0.00,0.00,0.00,0.00,671035),('5','175','235094','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671652),('5','175','235094','404',345.00,345.00,172.62,0.00,0.00,0.00,0.00,671653),('5','175','235342','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672288),('5','175','235342','404',345.00,345.00,271.52,0.00,0.00,0.00,0.00,672289),('5','175','235586','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672911),('5','175','235586','404',345.00,345.00,290.62,0.00,0.00,0.00,0.00,672912),('5','175','238027','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679277),('5','175','238027','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679278),('5','175','238035','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679300),('5','175','238035','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679301),('5','175','238207','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679734),('5','175','238207','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679735),('5','175','238237','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679817),('5','175','238237','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679818),('5','175','238243','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679834),('5','175','238243','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679835),('5','175','238249','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679850),('5','175','238249','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679851),('5','175','238270','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679903),('5','175','238270','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679904),('5','175','238491','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680483),('5','175','238491','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680484),('5','175','238523','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680578),('5','175','238523','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680579),('5','175','238531','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680599),('5','175','238531','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680600),('5','175','238539','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680618),('5','175','238539','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680619),('5','175','238683','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680974),('5','175','238683','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680975),('5','175','238876','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681470),('5','175','238876','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681471),('5','175','239139','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682153),('5','175','239139','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682154),('5','175','239344','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682687),('5','175','239344','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682688),('5','175','239603','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683364),('5','175','239603','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683365),('5','175','240016','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684428),('5','175','240016','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684429),('5','175','240079','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684601),('5','175','240079','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684602),('5','175','240380','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,685389),('5','175','240380','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685390),('5','175','240561','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,685850),('5','175','240561','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685851),('5','175','240800','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686425),('5','175','240800','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686426),('5','175','241165','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,687425),('5','175','241165','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687426),('5','175','241247','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,687615),('5','175','241247','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687616),('5','175','241518','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688336),('5','175','241518','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688337),('5','175','241800','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689091),('5','175','241800','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689092),('5','175','242009','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689626),('5','175','242009','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689627),('5','175','242291','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690354),('5','175','242291','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690355),('5','175','242478','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690833),('5','175','242478','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690834),('5','175','242757','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691560),('5','175','242757','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691561),('5','175','242927','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692015),('5','175','242927','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692016),('5','175','243216','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692766),('5','175','243216','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692767),('5','175','243429','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693325),('5','175','243429','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693326),('5','175','243673','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693947),('5','175','243673','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693948),('5','175','243908','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694562),('5','175','243908','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694563),('5','175','244090','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695027),('5','175','244090','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695028),('5','175','244357','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695728),('5','175','244357','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695729),('5','175','244559','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696242),('5','175','244559','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696243),('5','175','244779','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696826),('5','175','244779','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696827),('5','175','245168','403',165.00,165.00,8194.84,0.00,0.00,0.00,0.00,697845),('5','175','245168','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697846),('5','175','245243','403',165.00,165.00,10876.03,0.00,0.00,0.00,0.00,698023),('5','175','245243','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698024),('5','175','245518','403',165.00,165.00,8043.61,0.00,0.00,0.00,0.00,698731),('5','175','245518','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698732),('5','175','245742','403',165.00,165.00,7049.04,0.00,0.00,0.00,0.00,699306),('5','175','245742','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699307),('5','175','245992','403',165.00,165.00,8260.94,0.00,0.00,0.00,0.00,699965),('5','175','245992','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699966),('5','175','246289','403',165.00,165.00,2128.13,0.00,0.00,0.00,0.00,700736),('5','175','246289','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700737),('5','175','246476','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701232),('5','175','246476','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701233),('5','175','246704','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701836),('5','175','246704','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701837),('5','175','246968','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702500),('5','175','246968','404',345.00,345.00,99.27,0.00,0.00,0.00,0.00,702501),('5','175','247215','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703143),('5','175','247215','404',345.00,345.00,234.36,0.00,0.00,0.00,0.00,703144),('5','175','247462','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703765),('5','175','247462','404',345.00,345.00,382.18,0.00,0.00,0.00,0.00,703766),('5','175','247746','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704514),('5','175','247746','404',345.00,345.00,362.88,0.00,0.00,0.00,0.00,704515),('5','175','248012','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705197),('5','175','248012','404',345.00,345.00,360.68,0.00,0.00,0.00,0.00,705198),('5','175','248241','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705793),('5','175','248241','404',345.00,345.00,350.30,0.00,0.00,0.00,0.00,705794),('5','175','248577','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706671),('5','175','248577','404',345.00,345.00,380.06,0.00,0.00,0.00,0.00,706672),('5','175','248821','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707300),('5','175','248821','404',345.00,345.00,471.57,0.00,0.00,0.00,0.00,707301),('5','175','248945','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707603),('5','175','248945','404',345.00,345.00,594.94,0.00,0.00,0.00,0.00,707604),('5','175','249197','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708246),('5','175','249197','404',345.00,345.00,736.70,0.00,0.00,0.00,0.00,708247),('5','175','249435','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708853),('5','175','249435','404',345.00,345.00,295.76,0.00,0.00,0.00,0.00,708854),('5','175','249651','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709405),('5','175','249651','404',345.00,345.00,346.65,0.00,0.00,0.00,0.00,709406),('5','175','249920','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710097),('5','175','249920','404',345.00,345.00,369.23,0.00,0.00,0.00,0.00,710098),('5','175','250288','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711057),('5','175','250288','404',345.00,345.00,360.09,0.00,0.00,0.00,0.00,711058),('5','175','250470','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711505),('5','175','250470','404',345.00,345.00,545.45,0.00,0.00,0.00,0.00,711506),('5','175','250667','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712009),('5','175','250667','404',345.00,345.00,390.79,0.00,0.00,0.00,0.00,712010),('5','175','250969','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712809),('5','175','250969','404',345.00,345.00,369.99,0.00,0.00,0.00,0.00,712810),('5','175','251075','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713057),('5','175','251075','404',345.00,345.00,484.33,0.00,0.00,0.00,0.00,713058),('5','175','251321','403',165.00,165.00,7503.74,0.00,0.00,0.00,0.00,713703),('5','175','251321','404',345.00,345.00,959.59,0.00,0.00,0.00,0.00,713704),('5','175','251569','403',165.00,165.00,9369.00,0.00,0.00,0.00,0.00,714346),('5','175','251569','404',345.00,345.00,454.85,0.00,0.00,0.00,0.00,714347),('5','175','251827','403',165.00,165.00,10372.86,0.00,0.00,0.00,0.00,715026),('5','175','251827','404',345.00,345.00,600.44,0.00,0.00,0.00,0.00,715027),('5','175','252043','403',165.00,165.00,12204.11,0.00,0.00,0.00,0.00,715591),('5','175','252043','404',345.00,345.00,1253.51,0.00,0.00,0.00,0.00,715592),('5','175','252280','403',165.00,165.00,5459.50,0.00,0.00,0.00,0.00,716212),('5','175','252280','404',345.00,345.00,474.20,0.00,0.00,0.00,0.00,716213),('5','175','252570','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716964),('5','175','252570','404',345.00,345.00,495.15,0.00,0.00,0.00,0.00,716965),('5','175','252769','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717470),('5','175','252769','404',345.00,345.00,335.01,0.00,0.00,0.00,0.00,717471),('5','175','253031','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718155),('5','175','253031','404',345.00,345.00,312.03,0.00,0.00,0.00,0.00,718156),('5','175','253245','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718722),('5','175','253245','404',345.00,345.00,275.23,0.00,0.00,0.00,0.00,718723),('5','175','253545','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719495),('5','175','253545','404',345.00,345.00,321.13,0.00,0.00,0.00,0.00,719496),('5','175','253792','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720137),('5','175','253792','404',345.00,345.00,250.59,0.00,0.00,0.00,0.00,720138),('5','175','254000','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720681),('5','175','254000','404',345.00,345.00,313.33,0.00,0.00,0.00,0.00,720682),('5','175','254274','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721391),('5','175','254274','404',345.00,345.00,182.02,0.00,0.00,0.00,0.00,721392),('5','175','254517','403',165.00,165.00,12166.06,0.00,0.00,0.00,0.00,722015),('5','175','254517','404',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722016),('5','175','254768','403',165.00,165.00,10693.84,0.00,0.00,0.00,0.00,722638),('5','175','254768','404',350.00,350.00,0.00,0.00,0.00,0.00,0.00,722639),('5','175','255031','403',165.00,165.00,9824.56,0.00,0.00,0.00,0.00,723319),('5','175','255031','404',350.00,350.00,0.00,0.00,0.00,0.00,0.00,723320),('5','175','255247','403',165.00,165.00,7197.66,0.00,0.00,0.00,0.00,723868),('5','175','255247','404',350.00,350.00,0.00,0.00,0.00,0.00,0.00,723869),('5','175','255545','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724598),('5','175','255545','404',350.00,350.00,0.00,0.00,0.00,0.00,0.00,724599),('5','175','255760','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725152),('5','175','255760','404',350.00,350.00,0.00,0.00,0.00,0.00,0.00,725153),('5','175','256041','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725870),('5','175','256041','404',355.00,355.00,0.00,0.00,0.00,0.00,0.00,725871),('5','175','256257','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726384),('5','175','256257','404',355.00,355.00,0.00,0.00,0.00,0.00,0.00,726385),('5','175','256540','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727134),('5','175','256540','404',355.00,355.00,0.00,0.00,0.00,0.00,0.00,727135),('5','175','256800','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727800),('5','175','256800','404',355.00,355.00,0.00,0.00,0.00,0.00,0.00,727801),('5','175','257076','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728529),('5','175','257076','404',360.00,360.00,0.00,0.00,0.00,0.00,0.00,728530),('5','175','257338','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729206),('5','175','257338','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729207),('5','175','257531','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729716),('5','175','257531','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729717),('5','175','257532','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729718),('5','175','257532','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729719),('5','175','257533','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729720),('5','175','257533','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729721),('5','175','257534','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729722),('5','175','257534','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729723),('5','175','257535','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729724),('5','175','257535','403',165.00,165.00,2653.82,0.00,0.00,0.00,0.00,729725),('5','175','257536','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729726),('5','175','257536','403',165.00,165.00,7774.04,0.00,0.00,0.00,0.00,729727),('5','175','257537','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729728),('5','175','257537','403',165.00,165.00,7616.31,0.00,0.00,0.00,0.00,729729),('5','175','257538','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729730),('5','175','257538','403',165.00,165.00,6102.48,0.00,0.00,0.00,0.00,729731),('5','175','257539','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729732),('5','175','257539','403',165.00,165.00,10242.48,0.00,0.00,0.00,0.00,729733),('5','175','257540','404',310.00,360.00,0.00,0.00,0.00,0.00,0.00,729734),('5','175','257540','403',165.00,165.00,6407.41,0.00,0.00,0.00,0.00,729735),('5','175','257541','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729736),('5','175','257541','403',165.00,165.00,4323.35,0.00,0.00,0.00,0.00,729737),('5','175','257542','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729738),('5','175','257542','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729739),('5','175','257543','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729740),('5','175','257543','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729741),('5','175','257544','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729742),('5','175','257544','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729743),('5','175','257545','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729744),('5','175','257545','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729745),('5','175','257546','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729746),('5','175','257546','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729747),('5','175','257547','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729748),('5','175','257547','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729749),('5','175','257548','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729750),('5','175','257548','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729751),('5','175','257549','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729752),('5','175','257549','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729753),('5','175','257550','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729754),('5','175','257550','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729755),('5','175','257551','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729756),('5','175','257551','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729757),('5','175','257552','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729758),('5','175','257552','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729759),('5','175','257553','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729760),('5','175','257553','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729761),('5','175','257554','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729762),('5','175','257554','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729763),('5','175','257555','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729764),('5','175','257555','403',165.00,165.00,5830.62,0.00,0.00,0.00,0.00,729765),('5','175','257556','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729766),('5','175','257556','403',165.00,165.00,7696.86,0.00,0.00,0.00,0.00,729767),('5','175','257557','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729768),('5','175','257557','403',165.00,165.00,7133.95,0.00,0.00,0.00,0.00,729769),('5','175','257558','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729770),('5','175','257558','403',165.00,165.00,7945.29,0.00,0.00,0.00,0.00,729771),('5','175','257559','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729772),('5','175','257559','403',165.00,165.00,8933.40,0.00,0.00,0.00,0.00,729773),('5','175','257560','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729774),('5','175','257560','403',165.00,165.00,5448.08,0.00,0.00,0.00,0.00,729775),('5','175','257561','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729776),('5','175','257561','403',165.00,165.00,2480.60,0.00,0.00,0.00,0.00,729777),('5','175','257562','404',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729778),('5','175','257562','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729779),('5','175','257563','404',415.00,440.00,0.00,0.00,0.00,0.00,0.00,729780),('5','175','257563','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729781),('5','175','257564','404',415.00,440.00,0.00,0.00,0.00,0.00,0.00,729782),('5','175','257564','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729783),('5','175','257565','404',415.00,500.00,0.00,0.00,0.00,0.00,0.00,729784),('5','175','257565','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729785),('5','175','257566','404',415.00,500.00,0.00,0.00,0.00,0.00,0.00,729786),('5','175','257566','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729787),('5','175','257567','404',415.00,500.00,0.00,0.00,0.00,0.00,0.00,729788),('5','175','257567','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729789),('5','175','257568','404',415.00,600.00,0.00,0.00,0.00,0.00,0.00,729790),('5','175','257568','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729791),('5','175','257569','404',415.00,600.00,0.00,0.00,0.00,0.00,0.00,729792),('5','175','257569','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729793),('5','175','257570','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729794),('5','175','257570','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729795),('5','175','257571','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729796),('5','175','257571','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729797),('5','175','257572','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729798),('5','175','257572','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729799),('5','175','257573','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729800),('5','175','257573','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729801),('5','175','257574','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729802),('5','175','257574','403',165.00,165.00,3319.60,0.00,0.00,0.00,0.00,729803),('5','175','257575','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729804),('5','175','257575','403',165.00,165.00,5507.64,0.00,0.00,0.00,0.00,729805),('5','175','257576','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729806),('5','175','257576','403',165.00,165.00,3620.67,0.00,0.00,0.00,0.00,729807),('5','175','257577','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729808),('5','175','257577','403',165.00,165.00,1215.10,0.00,0.00,0.00,0.00,729809),('5','175','257578','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729810),('5','175','257578','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729811),('5','175','257579','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729812),('5','175','257579','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729813),('5','175','257580','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729814),('5','175','257580','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729815),('5','175','257581','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729816),('5','175','257581','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729817),('5','175','257582','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729818),('5','175','257582','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729819),('5','175','257583','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729820),('5','175','257583','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729821),('5','175','257584','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729822),('5','175','257584','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729823),('5','175','257585','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729824),('5','175','257585','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729825),('5','175','257586','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729826),('5','175','257586','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729827),('5','175','257587','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729828),('5','175','257587','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729829),('5','175','257588','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729830),('5','175','257588','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729831),('5','175','257589','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729832),('5','175','257589','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729833),('5','175','257590','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729834),('5','175','257590','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729835),('5','175','257591','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729836),('5','175','257591','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729837),('5','175','257592','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729838),('5','175','257592','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729839),('5','175','257593','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729840),('5','175','257593','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729841),('5','175','257594','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729842),('5','175','257594','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','175','257595','404',415.00,640.00,0.00,0.00,0.00,0.00,0.00,729844),('5','175','257595','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729845),('5','175','257596','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729846),('5','175','257596','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729847),('5','175','257597','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729848),('5','175','257597','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729849),('5','175','257598','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729850),('5','175','257598','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729851),('5','175','257599','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729852),('5','175','257599','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729853),('5','175','257600','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729854),('5','175','257600','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','175','257601','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729856),('5','175','257601','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729857),('5','175','257602','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729858),('5','175','257602','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729859),('5','175','257603','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729860),('5','175','257603','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','175','257604','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729862),('5','175','257604','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729863),('5','175','257605','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729864),('5','175','257605','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729865),('5','175','257606','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729866),('5','175','257606','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729867),('5','175','257607','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729868),('5','175','257607','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729869),('5','175','257608','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729870),('5','175','257608','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729871),('5','175','257609','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729872),('5','175','257609','403',165.00,165.00,980.60,0.00,0.00,0.00,0.00,729873),('5','175','257610','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729874),('5','175','257610','403',165.00,165.00,5836.27,0.00,0.00,0.00,0.00,729875),('5','175','257611','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729876),('5','175','257611','403',165.00,165.00,5316.51,0.00,0.00,0.00,0.00,729877),('5','175','257612','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729878),('5','175','257612','403',165.00,165.00,5594.51,0.00,0.00,0.00,0.00,729879),('5','175','257613','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729880),('5','175','257613','403',165.00,165.00,5214.82,0.00,0.00,0.00,0.00,729881),('5','175','257614','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729882),('5','175','257614','403',165.00,165.00,6133.97,0.00,0.00,0.00,0.00,729883),('5','175','257615','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729884),('5','175','257615','403',165.00,165.00,6063.16,0.00,0.00,0.00,0.00,729885),('5','175','257616','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729886),('5','175','257616','403',165.00,165.00,4168.07,0.00,0.00,0.00,0.00,729887),('5','175','257617','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729888),('5','175','257617','403',165.00,165.00,4124.51,0.00,0.00,0.00,0.00,729889),('5','175','257618','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729890),('5','175','257618','403',165.00,165.00,1721.36,0.00,0.00,0.00,0.00,729891),('5','175','257619','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729892),('5','175','257619','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729893),('5','175','257620','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729894),('5','175','257620','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729895),('5','175','257621','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729896),('5','175','257621','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729897),('5','175','257622','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729898),('5','175','257622','403',165.00,165.00,3406.29,0.00,0.00,0.00,0.00,729899),('5','175','257623','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729900),('5','175','257623','403',165.00,165.00,3690.98,0.00,0.00,0.00,0.00,729901),('5','175','257624','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729902),('5','175','257624','403',165.00,165.00,5416.23,0.00,0.00,0.00,0.00,729903),('5','175','257625','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729904),('5','175','257625','403',165.00,165.00,5056.19,0.00,0.00,0.00,0.00,729905),('5','175','257626','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729906),('5','175','257626','403',165.00,165.00,4102.68,0.00,0.00,0.00,0.00,729907),('5','175','257627','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729908),('5','175','257627','403',165.00,165.00,3593.33,0.00,0.00,0.00,0.00,729909),('5','175','257628','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729910),('5','175','257628','403',165.00,165.00,1208.36,0.00,0.00,0.00,0.00,729911),('5','175','257629','404',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729912),('5','175','257629','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729913),('5','175','257630','404',660.00,700.00,0.00,0.00,0.00,0.00,0.00,729914),('5','175','257630','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729915),('5','175','257631','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729916),('5','175','257631','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729917),('5','175','257632','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729918),('5','175','257632','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729919),('5','175','257633','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729920),('5','175','257633','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729921),('5','175','257634','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729922),('5','175','257634','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729923),('5','175','257635','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729924),('5','175','257635','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729925),('5','175','257636','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729926),('5','175','257636','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729927),('5','175','257637','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729928),('5','175','257637','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729929),('5','175','257638','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729930),('5','175','257638','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729931),('5','175','257639','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729932),('5','175','257639','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729933),('5','175','257640','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729934),('5','175','257640','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729935),('5','175','257641','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729936),('5','175','257641','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729937),('5','175','257642','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729938),('5','175','257642','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','175','257643','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729940),('5','175','257643','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729941),('5','175','257644','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729942),('5','175','257644','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729943),('5','175','257645','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729944),('5','175','257645','403',165.00,165.00,1262.40,0.00,0.00,0.00,0.00,729945),('5','175','257646','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729946),('5','175','257646','403',165.00,165.00,5469.53,0.00,0.00,0.00,0.00,729947),('5','175','257647','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729948),('5','175','257647','403',165.00,165.00,4484.51,0.00,0.00,0.00,0.00,729949),('5','175','257648','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729950),('5','175','257648','403',165.00,165.00,4692.60,0.00,0.00,0.00,0.00,729951),('5','175','257649','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729952),('5','175','257649','403',165.00,165.00,4850.64,0.00,0.00,0.00,0.00,729953),('5','175','257650','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729954),('5','175','257650','403',165.00,165.00,1703.33,0.00,0.00,0.00,0.00,729955),('5','175','257651','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729956),('5','175','257651','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','175','257652','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729958),('5','175','257652','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729959),('5','175','257653','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729960),('5','175','257653','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729961),('5','175','257654','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729962),('5','175','257654','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','175','257655','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729964),('5','175','257655','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729965),('5','175','257656','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729966),('5','175','257656','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729967),('5','175','257657','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729968),('5','175','257657','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729969),('5','175','257658','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729970),('5','175','257658','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729971),('5','175','257659','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729972),('5','175','257659','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729973),('5','175','257660','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729974),('5','175','257660','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729975),('5','175','257661','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729976),('5','175','257661','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729977),('5','175','257662','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729978),('5','175','257662','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729979),('5','175','257663','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729980),('5','175','257663','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729981),('5','175','257664','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729982),('5','175','257664','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729983),('5','175','257665','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729984),('5','175','257665','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729985),('5','175','257666','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729986),('5','175','257666','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729987),('5','175','257667','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729988),('5','175','257667','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729989),('5','175','257668','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729990),('5','175','257668','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729991),('5','175','257669','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729992),('5','175','257669','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729993),('5','175','257670','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729994),('5','175','257670','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729995),('5','175','257671','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729996),('5','175','257671','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729997),('5','175','257672','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729998),('5','175','257672','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729999),('5','175','257673','404',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730000),('5','175','257673','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730001),('5','175','257674','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730002),('5','175','257674','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730003),('5','175','257675','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730004),('5','175','257675','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730005),('5','175','257676','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730006),('5','175','257676','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730007),('5','175','257677','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730008),('5','175','257677','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730009),('5','175','257678','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730010),('5','175','257678','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730011),('5','175','257679','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730012),('5','175','257679','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730013),('5','175','257680','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730014),('5','175','257680','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730015),('5','175','257681','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730016),('5','175','257681','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730017),('5','175','257682','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730018),('5','175','257682','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730019),('5','175','257683','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730020),('5','175','257683','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730021),('5','175','257684','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730022),('5','175','257684','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730023),('5','175','257685','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730024),('5','175','257685','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730025),('5','175','257686','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730026),('5','175','257686','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730027),('5','175','257687','404',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730028),('5','175','257687','403',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730029),('5','175','257688','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730030),('5','175','257688','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730031),('5','175','257689','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730032),('5','175','257689','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730033),('5','175','257690','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730034),('5','175','257690','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730035),('5','175','257691','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730036),('5','175','257691','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730037),('5','175','257692','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730038),('5','175','257692','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730039),('5','175','257693','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730040),('5','175','257693','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730041),('5','175','257694','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730042),('5','175','257694','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730043),('5','175','257695','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730044),('5','175','257695','403',185.00,185.00,1185.00,0.00,0.00,0.00,0.00,730045),('5','175','257696','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730046),('5','175','257696','403',185.00,185.00,5030.44,0.00,0.00,0.00,0.00,730047),('5','175','257697','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730048),('5','175','257697','403',185.00,185.00,3504.34,0.00,0.00,0.00,0.00,730049),('5','175','257698','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730050),('5','175','257698','403',185.00,185.00,5393.14,0.00,0.00,0.00,0.00,730051),('5','175','257699','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730052),('5','175','257699','403',185.00,185.00,4453.82,0.00,0.00,0.00,0.00,730053),('5','175','257700','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730054),('5','175','257700','403',185.00,185.00,4475.90,0.00,0.00,0.00,0.00,730055),('5','175','257701','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730056),('5','175','257701','403',185.00,185.00,4203.97,0.00,0.00,0.00,0.00,730057),('5','175','257702','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730058),('5','175','257702','403',185.00,185.00,4378.62,0.00,0.00,0.00,0.00,730059),('5','175','257703','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730060),('5','175','257703','403',185.00,185.00,3550.94,0.00,0.00,0.00,0.00,730061),('5','175','257704','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730062),('5','175','257704','403',185.00,185.00,3094.43,0.00,0.00,0.00,0.00,730063),('5','175','257705','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730064),('5','175','257705','403',185.00,185.00,4013.36,0.00,0.00,0.00,0.00,730065),('5','175','257706','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730066),('5','175','257706','403',185.00,185.00,1568.58,0.00,0.00,0.00,0.00,730067),('5','175','257707','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730068),('5','175','257707','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730069),('5','175','257708','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730070),('5','175','257708','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730071),('5','175','257709','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730072),('5','175','257709','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730073),('5','175','257710','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730074),('5','175','257710','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730075),('5','175','257711','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730076),('5','175','257711','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730077),('5','175','257712','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730078),('5','175','257712','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730079),('5','175','257713','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730080),('5','175','257713','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730081),('5','175','257714','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730082),('5','175','257714','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730083),('5','175','257715','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730084),('5','175','257715','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730085),('5','175','257716','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730086),('5','175','257716','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730087),('5','175','257717','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730088),('5','175','257717','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730089),('5','175','257718','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730090),('5','175','257718','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730091),('5','175','257719','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730092),('5','175','257719','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730093),('5','175','257720','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730094),('5','175','257720','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730095),('5','175','257721','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730096),('5','175','257721','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730097),('5','175','257722','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730098),('5','175','257722','403',185.00,185.00,1670.50,0.00,0.00,0.00,0.00,730099),('5','175','257723','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730100),('5','175','257723','403',185.00,185.00,4274.80,0.00,0.00,0.00,0.00,730101),('5','175','257724','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730102),('5','175','257724','403',185.00,185.00,4492.80,0.00,0.00,0.00,0.00,730103),('5','175','257725','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730104),('5','175','257725','403',185.00,185.00,4910.87,0.00,0.00,0.00,0.00,730105),('5','175','257726','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730106),('5','175','257726','403',185.00,185.00,5558.82,0.00,0.00,0.00,0.00,730107),('5','175','257727','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730108),('5','175','257727','403',185.00,185.00,4593.50,0.00,0.00,0.00,0.00,730109),('5','175','257728','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730110),('5','175','257728','403',185.00,185.00,6173.25,0.00,0.00,0.00,0.00,730111),('5','175','257729','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730112),('5','175','257729','403',185.00,185.00,3652.42,0.00,0.00,0.00,0.00,730113),('5','175','257730','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730114),('5','175','257730','403',185.00,185.00,4234.51,0.00,0.00,0.00,0.00,730115),('5','175','257731','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730116),('5','175','257731','403',185.00,185.00,4637.38,0.00,0.00,0.00,0.00,730117),('5','175','257732','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730118),('5','175','257732','403',185.00,185.00,2228.11,0.00,0.00,0.00,0.00,730119),('5','175','257733','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730120),('5','175','257733','403',185.00,185.00,2200.60,0.00,0.00,0.00,0.00,730121),('5','175','257734','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730122),('5','175','257734','403',185.00,185.00,1199.40,0.00,0.00,0.00,0.00,730123),('5','175','257735','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730124),('5','175','257735','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730125),('5','175','257736','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730126),('5','175','257736','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730127),('5','175','257737','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730128),('5','175','257737','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730129),('5','175','257738','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730130),('5','175','257738','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730131),('5','175','257739','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730132),('5','175','257739','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730133),('5','175','257740','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730134),('5','175','257740','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730135),('5','175','257741','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730136),('5','175','257741','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730137),('5','175','257742','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730138),('5','175','257742','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730139),('5','175','257743','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730140),('5','175','257743','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730141),('5','175','257744','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730142),('5','175','257744','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730143),('5','175','257745','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730144),('5','175','257745','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730145),('5','175','257746','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730146),('5','175','257746','403',185.00,185.00,2666.00,0.00,0.00,0.00,0.00,730147),('5','175','257747','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730148),('5','175','257747','403',185.00,185.00,6010.07,0.00,0.00,0.00,0.00,730149),('5','175','257748','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730150),('5','175','257748','403',185.00,185.00,4960.01,0.00,0.00,0.00,0.00,730151),('5','175','257749','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730152),('5','175','257749','403',185.00,185.00,5345.59,0.00,0.00,0.00,0.00,730153),('5','175','257750','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730154),('5','175','257750','403',185.00,185.00,3599.27,0.00,0.00,0.00,0.00,730155),('5','175','257751','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730156),('5','175','257751','403',185.00,185.00,4176.25,0.00,0.00,0.00,0.00,730157),('5','175','257752','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730158),('5','175','257752','403',185.00,185.00,4231.61,0.00,0.00,0.00,0.00,730159),('5','175','257753','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730160),('5','175','257753','403',185.00,185.00,4506.29,0.00,0.00,0.00,0.00,730161),('5','175','257754','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730162),('5','175','257754','403',185.00,185.00,4026.00,0.00,0.00,0.00,0.00,730163),('5','175','257755','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730164),('5','175','257755','403',185.00,185.00,3567.04,0.00,0.00,0.00,0.00,730165),('5','175','257756','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730166),('5','175','257756','403',185.00,185.00,2194.28,0.00,0.00,0.00,0.00,730167),('5','175','257757','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730168),('5','175','257757','403',185.00,185.00,1180.47,0.00,0.00,0.00,0.00,730169),('5','175','257758','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730170),('5','175','257758','403',185.00,185.00,4179.11,0.00,0.00,0.00,0.00,730171),('5','175','257759','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730172),('5','175','257759','403',185.00,185.00,4277.44,0.00,0.00,0.00,0.00,730173),('5','175','257760','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730174),('5','175','257760','403',185.00,185.00,4435.58,0.00,0.00,0.00,0.00,730175),('5','175','257761','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730176),('5','175','257761','403',185.00,185.00,4371.68,0.00,0.00,0.00,0.00,730177),('5','175','257762','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730178),('5','175','257762','403',185.00,185.00,3662.12,0.00,0.00,0.00,0.00,730179),('5','175','257763','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730180),('5','175','257763','403',185.00,185.00,3508.77,0.00,0.00,0.00,0.00,730181),('5','175','257764','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730182),('5','175','257764','403',185.00,185.00,3659.64,0.00,0.00,0.00,0.00,730183),('5','175','257765','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730184),('5','175','257765','403',185.00,185.00,4138.63,0.00,0.00,0.00,0.00,730185),('5','175','257766','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730186),('5','175','257766','403',185.00,185.00,3835.89,0.00,0.00,0.00,0.00,730187),('5','175','257767','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730188),('5','175','257767','403',185.00,185.00,3929.57,0.00,0.00,0.00,0.00,730189),('5','175','257768','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730190),('5','175','257768','403',185.00,185.00,3573.50,0.00,0.00,0.00,0.00,730191),('5','175','257769','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730192),('5','175','257769','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730193),('5','175','257770','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730194),('5','175','257770','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730195),('5','175','257771','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730196),('5','175','257771','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730197),('5','175','257772','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730198),('5','175','257772','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730199),('5','175','257773','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730200),('5','175','257773','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730201),('5','175','257774','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730202),('5','175','257774','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730203),('5','175','257775','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730204),('5','175','257775','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730205),('5','175','257776','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730206),('5','175','257776','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730207),('5','175','257777','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730208),('5','175','257777','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730209),('5','175','257778','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730210),('5','175','257778','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730211),('5','175','257779','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730212),('5','175','257779','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730213),('5','175','257780','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730214),('5','175','257780','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730215),('5','175','257781','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730216),('5','175','257781','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730217),('5','175','257782','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730218),('5','175','257782','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730219),('5','175','257783','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730220),('5','175','257783','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730221),('5','175','257784','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730222),('5','175','257784','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730223),('5','175','257785','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730224),('5','175','257785','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730225),('5','175','257786','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730226),('5','175','257786','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730227),('5','175','257787','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730228),('5','175','257787','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730229),('5','175','257788','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730230),('5','175','257788','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730231),('5','175','257789','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730232),('5','175','257789','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730233),('5','175','257790','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730234),('5','175','257790','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730235),('5','175','257791','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730236),('5','175','257791','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730237),('5','175','257792','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730238),('5','175','257792','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730239),('5','175','257793','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730240),('5','175','257793','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730241),('5','175','257794','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730242),('5','175','257794','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730243),('5','175','257795','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730244),('5','175','257795','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730245),('5','175','257796','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730246),('5','175','257796','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730247),('5','175','257797','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730248),('5','175','257797','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730249),('5','175','257798','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730250),('5','175','257798','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730251),('5','175','257799','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730252),('5','175','257799','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730253),('5','175','257800','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730254),('5','175','257800','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730255),('5','175','257801','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730256),('5','175','257801','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730257),('5','175','257802','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730258),('5','175','257802','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730259),('5','175','257803','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730260),('5','175','257803','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730261),('5','175','257804','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730262),('5','175','257804','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730263),('5','175','257805','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730264),('5','175','257805','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730265),('5','175','257806','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730266),('5','175','257806','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730267),('5','175','257807','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730268),('5','175','257807','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730269),('5','175','257808','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730270),('5','175','257808','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730271),('5','175','257809','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730272),('5','175','257809','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730273),('5','175','257810','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730274),('5','175','257810','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730275),('5','175','257811','404',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730276),('5','175','257811','403',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730277);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=368 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',367,'175','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=911 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','175','367',908,0,'403','PMS TANK 1',54000.00,1.00,6891.66,'TANKS CONTAINING PETROLEUM PRODUCT.','597','2021-02-22 21:41:32','2021-02-22 21:41:32','597',5,1),('5','175','367',909,0,'403','PMS TANK 2',25900.00,1.00,400.00,'TANKS CONTAINING PETROLEUM PRODUCT.','597','2021-02-22 21:45:18','2021-05-23 09:24:07','600',5,1),('5','175','367',910,0,'404','AGO TANK',28000.00,1.00,17083.43,'TANKS CONTAINING PETROLEUM PRODUCT.','597','2021-02-22 21:47:50','2021-02-22 21:47:50','597',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2627150 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2232913,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7326000.00,44400.00,0.00,0.00,'2021-12-10 13:53:30','',''),(2233271,'5','175',NULL,403,'Reception corrector for bridging 126891',0.00,0.00,0.00,44400.00,0.00,'2021-12-10 14:09:56','',''),(2233272,'5','175','908',403,'Received from bridging 126891',0.00,0.00,44400.00,0.00,0.00,'2021-12-10 14:09:56','',''),(2239196,'5','175','908',403,'Sale Id shift 245168',0.00,0.00,0.00,4643.17,0.00,'2021-12-11 06:58:48','',''),(2239197,'5','175','908',403,'Sale Id shift 245168',0.00,0.00,0.00,3551.67,0.00,'2021-12-11 06:58:48','',''),(2239198,'5','175',NULL,403,'Sale Id shift 245168',1352148.60,0.00,0.00,0.00,0.00,'2021-12-11 06:58:48','',''),(2252562,'5','175','908',403,'Sale Id shift 245243',0.00,0.00,0.00,5877.99,0.00,'2021-12-12 06:49:17','',''),(2252563,'5','175','908',403,'Sale Id shift 245243',0.00,0.00,0.00,4998.04,0.00,'2021-12-12 06:49:17','',''),(2252564,'5','175',NULL,403,'Sale Id shift 245243',1794544.95,0.00,0.00,0.00,0.00,'2021-12-12 06:49:17','',''),(2265288,'5','175','908',403,'Sale Id shift 245518',0.00,0.00,0.00,4159.08,0.00,'2021-12-13 05:56:56','',''),(2265289,'5','175','908',403,'Sale Id shift 245518',0.00,0.00,0.00,3884.53,0.00,'2021-12-13 05:56:56','',''),(2265290,'5','175',NULL,403,'Sale Id shift 245518',1327195.65,0.00,0.00,0.00,0.00,'2021-12-13 05:56:56','',''),(2276940,'5','175','908',403,'Sale Id shift 245742',0.00,0.00,0.00,3626.66,0.00,'2021-12-14 06:04:22','',''),(2276941,'5','175','908',403,'Sale Id shift 245742',0.00,0.00,0.00,3422.38,0.00,'2021-12-14 06:04:22','',''),(2276942,'5','175',NULL,403,'Sale Id shift 245742',1163091.60,0.00,0.00,0.00,0.00,'2021-12-14 06:04:22','',''),(2286139,'5','175','908',403,'Sale Id shift 245992',0.00,0.00,0.00,3443.54,0.00,'2021-12-15 06:38:23','',''),(2286140,'5','175','908',403,'Sale Id shift 245992',0.00,0.00,0.00,4817.40,0.00,'2021-12-15 06:38:23','',''),(2286141,'5','175',NULL,403,'Sale Id shift 245992',1363055.10,0.00,0.00,0.00,0.00,'2021-12-15 06:38:23','',''),(2286732,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,1987.68,0.00,'2021-12-15 07:46:45','',''),(2286733,'5','175','908',0,'Inventory adjustment from tank dipping to 300',0.00,0.00,300.00,0.00,0.00,'2021-12-15 07:46:45','',''),(2286756,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,300.00,0.00,'2021-12-15 07:48:51','',''),(2286757,'5','175','908',0,'Inventory adjustment from tank dipping to 2350',0.00,0.00,2350.00,0.00,0.00,'2021-12-15 07:48:51','',''),(2293358,'5','175','908',403,'Sale Id shift 246289',0.00,0.00,0.00,2128.13,0.00,'2021-12-16 06:50:04','',''),(2293359,'5','175',NULL,403,'Sale Id shift 246289',351141.45,0.00,0.00,0.00,0.00,'2021-12-16 06:50:04','',''),(2314811,'5','175',NULL,404,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4657500.00,13500.00,0.00,0.00,'2021-12-18 14:32:08','',''),(2315101,'5','175',NULL,404,'Reception corrector for bridging 127881',0.00,0.00,0.00,13500.00,0.00,'2021-12-18 14:54:12','',''),(2315102,'5','175','910',404,'Received from bridging 127881',0.00,0.00,13500.00,0.00,0.00,'2021-12-18 14:54:12','',''),(2318377,'5','175','910',404,'Sale Id shift 246968',0.00,0.00,0.00,99.27,0.00,'2021-12-19 07:11:24','',''),(2318378,'5','175',NULL,404,'Sale Id shift 246968',34248.15,0.00,0.00,0.00,0.00,'2021-12-19 07:11:24','',''),(2326399,'5','175','910',404,'Sale Id shift 247215',0.00,0.00,0.00,234.36,0.00,'2021-12-20 06:52:52','',''),(2326400,'5','175',NULL,404,'Sale Id shift 247215',80854.20,0.00,0.00,0.00,0.00,'2021-12-20 06:52:52','',''),(2335020,'5','175','910',404,'Sale Id shift 247462',0.00,0.00,0.00,382.18,0.00,'2021-12-21 09:21:58','',''),(2335021,'5','175',NULL,404,'Sale Id shift 247462',131852.10,0.00,0.00,0.00,0.00,'2021-12-21 09:21:58','',''),(2341264,'5','175','910',404,'Sale Id shift 247746',0.00,0.00,0.00,362.88,0.00,'2021-12-22 06:28:10','',''),(2341265,'5','175',NULL,404,'Sale Id shift 247746',125193.60,0.00,0.00,0.00,0.00,'2021-12-22 06:28:10','',''),(2349590,'5','175','910',404,'Sale Id shift 248012',0.00,0.00,0.00,360.68,0.00,'2021-12-23 06:23:16','',''),(2349591,'5','175',NULL,404,'Sale Id shift 248012',124434.60,0.00,0.00,0.00,0.00,'2021-12-23 06:23:16','',''),(2359038,'5','175','910',404,'Sale Id shift 248241',0.00,0.00,0.00,350.30,0.00,'2021-12-24 07:19:22','',''),(2359039,'5','175',NULL,404,'Sale Id shift 248241',120853.50,0.00,0.00,0.00,0.00,'2021-12-24 07:19:22','',''),(2373011,'5','175','910',404,'Sale Id shift 248577',0.00,0.00,0.00,380.06,0.00,'2021-12-25 14:07:31','',''),(2373012,'5','175',NULL,404,'Sale Id shift 248577',131120.70,0.00,0.00,0.00,0.00,'2021-12-25 14:07:31','',''),(2375199,'5','175','910',404,'Sale Id shift 248821',0.00,0.00,0.00,471.57,0.00,'2021-12-26 07:31:00','',''),(2375200,'5','175',NULL,404,'Sale Id shift 248821',162691.65,0.00,0.00,0.00,0.00,'2021-12-26 07:31:00','',''),(2380994,'5','175','910',404,'Sale Id shift 248945',0.00,0.00,0.00,594.94,0.00,'2021-12-27 07:39:49','',''),(2380995,'5','175',NULL,404,'Sale Id shift 248945',205254.30,0.00,0.00,0.00,0.00,'2021-12-27 07:39:49','',''),(2386979,'5','175','910',404,'Sale Id shift 249197',0.00,0.00,0.00,736.70,0.00,'2021-12-28 07:34:17','',''),(2386980,'5','175',NULL,404,'Sale Id shift 249197',254161.50,0.00,0.00,0.00,0.00,'2021-12-28 07:34:17','',''),(2393511,'5','175','910',404,'Sale Id shift 249435',0.00,0.00,0.00,295.76,0.00,'2021-12-29 06:44:22','',''),(2393512,'5','175',NULL,404,'Sale Id shift 249435',102037.20,0.00,0.00,0.00,0.00,'2021-12-29 06:44:22','',''),(2400350,'5','175','910',404,'Sale Id shift 249651',0.00,0.00,0.00,346.65,0.00,'2021-12-30 06:55:45','',''),(2400351,'5','175',NULL,404,'Sale Id shift 249651',119594.25,0.00,0.00,0.00,0.00,'2021-12-30 06:55:45','',''),(2414094,'5','175','910',404,'Sale Id shift 249920',0.00,0.00,0.00,369.23,0.00,'2021-12-31 18:59:45','',''),(2414095,'5','175',NULL,404,'Sale Id shift 249920',127384.35,0.00,0.00,0.00,0.00,'2021-12-31 18:59:45','',''),(2415158,'5','175','910',404,'Sale Id shift 250288',0.00,0.00,0.00,360.09,0.00,'2022-01-01 07:48:29','',''),(2415159,'5','175',NULL,404,'Sale Id shift 250288',124231.05,0.00,0.00,0.00,0.00,'2022-01-01 07:48:29','',''),(2420816,'5','175','910',404,'Sale Id shift 250470',0.00,0.00,0.00,545.45,0.00,'2022-01-02 06:43:57','',''),(2420817,'5','175',NULL,404,'Sale Id shift 250470',188180.25,0.00,0.00,0.00,0.00,'2022-01-02 06:43:57','',''),(2430321,'5','175','910',404,'Sale Id shift 250667',0.00,0.00,0.00,390.79,0.00,'2022-01-03 14:05:06','',''),(2430322,'5','175',NULL,404,'Sale Id shift 250667',134822.55,0.00,0.00,0.00,0.00,'2022-01-03 14:05:06','',''),(2433242,'5','175','910',404,'Sale Id shift 250969',0.00,0.00,0.00,369.99,0.00,'2022-01-04 07:03:53','',''),(2433243,'5','175',NULL,404,'Sale Id shift 250969',127646.55,0.00,0.00,0.00,0.00,'2022-01-04 07:03:53','',''),(2440886,'5','175','910',404,'Sale Id shift 251075',0.00,0.00,0.00,484.33,0.00,'2022-01-05 07:33:37','',''),(2440887,'5','175',NULL,404,'Sale Id shift 251075',167093.85,0.00,0.00,0.00,0.00,'2022-01-05 07:33:37','',''),(2444026,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7359000.00,44600.00,0.00,0.00,'2022-01-05 13:09:00','',''),(2444758,'5','175',NULL,403,'Reception corrector for bridging 129832',0.00,0.00,0.00,44600.00,0.00,'2022-01-05 14:24:49','',''),(2444759,'5','175','908',403,'Received from bridging 129832',0.00,0.00,44600.00,0.00,0.00,'2022-01-05 14:24:49','',''),(2448343,'5','175','908',403,'Sale Id shift 251321',0.00,0.00,0.00,3994.76,0.00,'2022-01-06 07:45:18','',''),(2448344,'5','175','908',403,'Sale Id shift 251321',0.00,0.00,0.00,3508.98,0.00,'2022-01-06 07:45:18','',''),(2448345,'5','175','910',404,'Sale Id shift 251321',0.00,0.00,0.00,959.59,0.00,'2022-01-06 07:45:18','',''),(2448346,'5','175',NULL,403,'Sale Id shift 251321',1238117.10,0.00,0.00,0.00,0.00,'2022-01-06 07:45:18','',''),(2448347,'5','175',NULL,404,'Sale Id shift 251321',331058.55,0.00,0.00,0.00,0.00,'2022-01-06 07:45:18','',''),(2456927,'5','175','908',403,'Sale Id shift 251569',0.00,0.00,0.00,4745.73,0.00,'2022-01-07 09:07:28','',''),(2456928,'5','175','908',403,'Sale Id shift 251569',0.00,0.00,0.00,4623.27,0.00,'2022-01-07 09:07:28','',''),(2456929,'5','175','910',404,'Sale Id shift 251569',0.00,0.00,0.00,454.85,0.00,'2022-01-07 09:07:28','',''),(2456930,'5','175',NULL,403,'Sale Id shift 251569',1545885.00,0.00,0.00,0.00,0.00,'2022-01-07 09:07:28','',''),(2456931,'5','175',NULL,404,'Sale Id shift 251569',156923.25,0.00,0.00,0.00,0.00,'2022-01-07 09:07:28','',''),(2463386,'5','175','908',403,'Sale Id shift 251827',0.00,0.00,0.00,5378.11,0.00,'2022-01-08 07:57:07','',''),(2463387,'5','175','908',403,'Sale Id shift 251827',0.00,0.00,0.00,4994.75,0.00,'2022-01-08 07:57:07','',''),(2463388,'5','175','910',404,'Sale Id shift 251827',0.00,0.00,0.00,600.44,0.00,'2022-01-08 07:57:07','',''),(2463389,'5','175',NULL,403,'Sale Id shift 251827',1711521.90,0.00,0.00,0.00,0.00,'2022-01-08 07:57:07','',''),(2463390,'5','175',NULL,404,'Sale Id shift 251827',207151.80,0.00,0.00,0.00,0.00,'2022-01-08 07:57:07','',''),(2471727,'5','175','908',403,'Sale Id shift 252043',0.00,0.00,0.00,5909.41,0.00,'2022-01-09 08:01:29','',''),(2471728,'5','175','908',403,'Sale Id shift 252043',0.00,0.00,0.00,6294.70,0.00,'2022-01-09 08:01:29','',''),(2471729,'5','175','910',404,'Sale Id shift 252043',0.00,0.00,0.00,1253.51,0.00,'2022-01-09 08:01:29','',''),(2471730,'5','175',NULL,403,'Sale Id shift 252043',2013678.15,0.00,0.00,0.00,0.00,'2022-01-09 08:01:29','',''),(2471731,'5','175',NULL,404,'Sale Id shift 252043',432460.95,0.00,0.00,0.00,0.00,'2022-01-09 08:01:29','',''),(2478872,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,5372.16,0.00,'2022-01-09 19:31:13','',''),(2478873,'5','175','908',0,'Inventory adjustment from tank dipping to 5500',0.00,0.00,5500.00,0.00,0.00,'2022-01-09 19:31:13','',''),(2479473,'5','175','908',403,'Sale Id shift 252280',0.00,0.00,0.00,2829.85,0.00,'2022-01-10 07:00:57','',''),(2479474,'5','175','908',403,'Sale Id shift 252280',0.00,0.00,0.00,2629.65,0.00,'2022-01-10 07:00:57','',''),(2479475,'5','175','910',404,'Sale Id shift 252280',0.00,0.00,0.00,474.20,0.00,'2022-01-10 07:00:57','',''),(2479476,'5','175',NULL,403,'Sale Id shift 252280',900817.50,0.00,0.00,0.00,0.00,'2022-01-10 07:00:57','',''),(2479477,'5','175',NULL,404,'Sale Id shift 252280',163599.00,0.00,0.00,0.00,0.00,'2022-01-10 07:00:57','',''),(2486312,'5','175','910',404,'Sale Id shift 252570',0.00,0.00,0.00,495.15,0.00,'2022-01-11 05:29:51','',''),(2486313,'5','175',NULL,404,'Sale Id shift 252570',170826.75,0.00,0.00,0.00,0.00,'2022-01-11 05:29:51','',''),(2494232,'5','175','910',404,'Sale Id shift 252769',0.00,0.00,0.00,335.01,0.00,'2022-01-12 07:48:34','',''),(2494233,'5','175',NULL,404,'Sale Id shift 252769',115578.45,0.00,0.00,0.00,0.00,'2022-01-12 07:48:34','',''),(2501742,'5','175','910',404,'Sale Id shift 253031',0.00,0.00,0.00,312.03,0.00,'2022-01-13 07:33:56','',''),(2501743,'5','175',NULL,404,'Sale Id shift 253031',107650.35,0.00,0.00,0.00,0.00,'2022-01-13 07:33:56','',''),(2510654,'5','175','910',404,'Sale Id shift 253245',0.00,0.00,0.00,275.23,0.00,'2022-01-14 09:29:54','',''),(2510655,'5','175',NULL,404,'Sale Id shift 253245',94954.35,0.00,0.00,0.00,0.00,'2022-01-14 09:29:54','',''),(2516801,'5','175','910',404,'Sale Id shift 253545',0.00,0.00,0.00,321.13,0.00,'2022-01-15 07:14:33','',''),(2516802,'5','175',NULL,404,'Sale Id shift 253545',110789.85,0.00,0.00,0.00,0.00,'2022-01-15 07:14:33','',''),(2525775,'5','175','910',404,'Sale Id shift 253792',0.00,0.00,0.00,250.59,0.00,'2022-01-16 07:09:14','',''),(2525776,'5','175',NULL,404,'Sale Id shift 253792',86453.55,0.00,0.00,0.00,0.00,'2022-01-16 07:09:14','',''),(2534140,'5','175','910',404,'Sale Id shift 254000',0.00,0.00,0.00,313.33,0.00,'2022-01-17 07:12:37','',''),(2534141,'5','175',NULL,404,'Sale Id shift 254000',108098.85,0.00,0.00,0.00,0.00,'2022-01-17 07:12:37','',''),(2540328,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,6567000.00,39800.00,0.00,0.00,'2022-01-17 18:08:20','',''),(2540554,'5','175',NULL,403,'Reception corrector for bridging 131220',0.00,0.00,0.00,39800.00,0.00,'2022-01-17 19:06:50','',''),(2540555,'5','175','908',403,'Received from bridging 131220',0.00,0.00,39800.00,0.00,0.00,'2022-01-17 19:06:50','',''),(2541556,'5','175','910',404,'Sale Id shift 254274',0.00,0.00,0.00,182.02,0.00,'2022-01-18 08:36:59','',''),(2541557,'5','175',NULL,404,'Sale Id shift 254274',62796.90,0.00,0.00,0.00,0.00,'2022-01-18 08:36:59','',''),(2549226,'5','175','908',403,'Sale Id shift 254517',0.00,0.00,0.00,6523.33,0.00,'2022-01-19 08:42:08','',''),(2549227,'5','175','908',403,'Sale Id shift 254517',0.00,0.00,0.00,5642.73,0.00,'2022-01-19 08:42:08','',''),(2549228,'5','175',NULL,403,'Sale Id shift 254517',2007399.90,0.00,0.00,0.00,0.00,'2022-01-19 08:42:08','',''),(2549906,'5','175','910',0,'Tank level zero out for dipping',0.00,0.00,0.00,395.35,0.00,'2022-01-19 09:35:21','',''),(2549907,'5','175','910',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-01-19 09:35:21','',''),(2556541,'5','175','908',403,'Sale Id shift 254768',0.00,0.00,0.00,5673.52,0.00,'2022-01-20 08:07:14','',''),(2556542,'5','175','908',403,'Sale Id shift 254768',0.00,0.00,0.00,5020.32,0.00,'2022-01-20 08:07:14','',''),(2556543,'5','175',NULL,403,'Sale Id shift 254768',1764483.60,0.00,0.00,0.00,0.00,'2022-01-20 08:07:14','',''),(2565248,'5','175','908',403,'Sale Id shift 255031',0.00,0.00,0.00,5163.72,0.00,'2022-01-21 08:32:36','',''),(2565249,'5','175','908',403,'Sale Id shift 255031',0.00,0.00,0.00,4660.84,0.00,'2022-01-21 08:32:36','',''),(2565250,'5','175',NULL,403,'Sale Id shift 255031',1621052.40,0.00,0.00,0.00,0.00,'2022-01-21 08:32:36','',''),(2569892,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,7156.04,0.00,'2022-01-21 15:52:37','',''),(2569893,'5','175','908',0,'Inventory adjustment from tank dipping to 7500',0.00,0.00,7500.00,0.00,0.00,'2022-01-21 15:52:37','',''),(2569923,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,7500.00,0.00,'2022-01-21 15:54:49','',''),(2569924,'5','175','908',0,'Inventory adjustment from tank dipping to 7300',0.00,0.00,7300.00,0.00,0.00,'2022-01-21 15:54:49','',''),(2573278,'5','175','908',403,'Sale Id shift 255247',0.00,0.00,0.00,3889.34,0.00,'2022-01-22 08:04:44','',''),(2573279,'5','175','908',403,'Sale Id shift 255247',0.00,0.00,0.00,3308.32,0.00,'2022-01-22 08:04:44','',''),(2573280,'5','175',NULL,403,'Sale Id shift 255247',1187613.90,0.00,0.00,0.00,0.00,'2022-01-22 08:04:44','',''),(2601354,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,24915.00,151.00,0.00,0.00,'2022-01-25 14:25:10','',''),(2605053,'5','175',NULL,403,'Reception corrector for bridging 132064',0.00,0.00,0.00,151.00,0.00,'2022-01-25 19:46:10','',''),(2605054,'5','175','908',403,'Received from bridging 132064',0.00,0.00,151.00,0.00,0.00,'2022-01-25 19:46:10','',''),(2612774,'5','175',NULL,403,'Balance from closing inventory values 2021-11-31 23:59:59',11451806.85,11517000.00,139600.00,139204.89,0.00,'2021-11-30 23:59:59','',''),(2613115,'5','175',NULL,404,'Balance from closing inventory values 2021-11-31 23:59:59',3661237.51,3462000.00,23080.00,22822.34,0.00,'2021-11-30 23:59:59','',''),(2613570,'5','175','909',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,400.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613685,'5','175','910',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,11540.00,11282.34,0.00,'2021-11-30 23:59:59','',''),(2613904,'5','175','908',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,74200.00,74187.86,0.00,'2021-11-30 23:59:59','',''),(2626841,'5','175',NULL,404,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,93499.10,301.61,0.00,0.00,'2022-01-28 13:16:44','',''),(2626842,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-02-03 15:37:00','',''),(2626843,'5','175',NULL,403,'Reception corrector for bridging 132065',0.00,0.00,0.00,45000.00,0.00,'2022-02-03 16:34:22','',''),(2626844,'5','175','908',403,'Received from bridging 132065',0.00,0.00,45000.00,0.00,0.00,'2022-02-03 16:34:22','',''),(2626845,'5','175','908',403,'Sale Id shift 257535',0.00,0.00,0.00,1493.15,0.00,'2022-02-04 06:25:39','',''),(2626846,'5','175','908',403,'Sale Id shift 257535',0.00,0.00,0.00,1160.67,0.00,'2022-02-04 06:25:39','',''),(2626847,'5','175',NULL,403,'Sale Id shift 257535',437880.30,0.00,0.00,0.00,0.00,'2022-02-04 06:25:39','',''),(2626848,'5','175','908',403,'Sale Id shift 257536',0.00,0.00,0.00,3810.01,0.00,'2022-02-05 07:50:07','',''),(2626849,'5','175','908',403,'Sale Id shift 257536',0.00,0.00,0.00,3964.03,0.00,'2022-02-05 07:50:07','',''),(2626850,'5','175',NULL,403,'Sale Id shift 257536',1282716.60,0.00,0.00,0.00,0.00,'2022-02-05 07:50:07','',''),(2626851,'5','175','908',403,'Sale Id shift 257537',0.00,0.00,0.00,4063.91,0.00,'2022-02-06 07:46:13','',''),(2626852,'5','175','908',403,'Sale Id shift 257537',0.00,0.00,0.00,3552.40,0.00,'2022-02-06 07:46:13','',''),(2626853,'5','175',NULL,403,'Sale Id shift 257537',1256691.15,0.00,0.00,0.00,0.00,'2022-02-06 07:46:13','',''),(2626854,'5','175','908',403,'Sale Id shift 257538',0.00,0.00,0.00,3198.08,0.00,'2022-02-07 07:15:33','',''),(2626855,'5','175','908',403,'Sale Id shift 257538',0.00,0.00,0.00,2904.40,0.00,'2022-02-07 07:15:33','',''),(2626856,'5','175',NULL,403,'Sale Id shift 257538',1006909.20,0.00,0.00,0.00,0.00,'2022-02-07 07:15:33','',''),(2626857,'5','175','908',403,'Sale Id shift 257539',0.00,0.00,0.00,5662.94,0.00,'2022-02-08 07:41:43','',''),(2626858,'5','175','908',403,'Sale Id shift 257539',0.00,0.00,0.00,4579.54,0.00,'2022-02-08 07:41:43','',''),(2626859,'5','175',NULL,403,'Sale Id shift 257539',1690009.20,0.00,0.00,0.00,0.00,'2022-02-08 07:41:43','',''),(2626860,'5','175','908',403,'Sale Id shift 257540',0.00,0.00,0.00,3496.62,0.00,'2022-02-09 08:16:46','',''),(2626861,'5','175','908',403,'Sale Id shift 257540',0.00,0.00,0.00,2910.79,0.00,'2022-02-09 08:16:46','',''),(2626862,'5','175',NULL,403,'Sale Id shift 257540',1057222.65,0.00,0.00,0.00,0.00,'2022-02-09 08:16:46','',''),(2626863,'5','175','908',403,'Sale Id shift 257541',0.00,0.00,0.00,2298.87,0.00,'2022-02-10 07:57:15','',''),(2626864,'5','175','908',403,'Sale Id shift 257541',0.00,0.00,0.00,2024.48,0.00,'2022-02-10 07:57:15','',''),(2626865,'5','175',NULL,403,'Sale Id shift 257541',713352.75,0.00,0.00,0.00,0.00,'2022-02-10 07:57:15','',''),(2626866,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,152460.00,924.00,0.00,0.00,'2022-02-17 10:21:07','',''),(2626867,'5','175',NULL,403,'Reception corrector for bridging 132066',0.00,0.00,0.00,924.00,0.00,'2022-02-17 10:23:19','',''),(2626868,'5','175','909',403,'Received from bridging 132066',0.00,0.00,924.00,0.00,0.00,'2022-02-17 10:23:19','',''),(2626869,'5','175','909',0,'Tank level zero out for dipping',0.00,0.00,0.00,1324.00,0.00,'2022-02-17 10:23:36','',''),(2626870,'5','175','909',0,'Inventory adjustment from tank dipping to 400',0.00,0.00,400.00,0.00,0.00,'2022-02-17 10:23:36','',''),(2626871,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-02-23 14:08:39','',''),(2626872,'5','175',NULL,403,'Reception corrector for bridging 132067',0.00,0.00,0.00,45000.00,0.00,'2022-02-23 14:44:15','',''),(2626873,'5','175','908',403,'Received from bridging 132067',0.00,0.00,45000.00,0.00,0.00,'2022-02-23 14:44:15','',''),(2626874,'5','175','908',403,'Sale Id shift 257555',0.00,0.00,0.00,3296.68,0.00,'2022-02-24 09:37:07','',''),(2626875,'5','175','908',403,'Sale Id shift 257555',0.00,0.00,0.00,2533.94,0.00,'2022-02-24 09:37:07','',''),(2626876,'5','175',NULL,403,'Sale Id shift 257555',962052.30,0.00,0.00,0.00,0.00,'2022-02-24 09:37:07','',''),(2626877,'5','175','908',403,'Sale Id shift 257556',0.00,0.00,0.00,4194.62,0.00,'2022-02-25 08:09:57','',''),(2626878,'5','175','908',403,'Sale Id shift 257556',0.00,0.00,0.00,3502.24,0.00,'2022-02-25 08:09:57','',''),(2626879,'5','175',NULL,403,'Sale Id shift 257556',1269981.90,0.00,0.00,0.00,0.00,'2022-02-25 08:09:57','',''),(2626880,'5','175','908',403,'Sale Id shift 257557',0.00,0.00,0.00,3467.34,0.00,'2022-02-26 07:18:54','',''),(2626881,'5','175','908',403,'Sale Id shift 257557',0.00,0.00,0.00,3666.61,0.00,'2022-02-26 07:18:54','',''),(2626882,'5','175',NULL,403,'Sale Id shift 257557',1177101.75,0.00,0.00,0.00,0.00,'2022-02-26 07:18:54','',''),(2626883,'5','175','908',403,'Sale Id shift 257558',0.00,0.00,0.00,4239.67,0.00,'2022-02-27 07:01:15','',''),(2626884,'5','175','908',403,'Sale Id shift 257558',0.00,0.00,0.00,3705.62,0.00,'2022-02-27 07:01:15','',''),(2626885,'5','175',NULL,403,'Sale Id shift 257558',1310972.85,0.00,0.00,0.00,0.00,'2022-02-27 07:01:15','',''),(2626886,'5','175','908',403,'Sale Id shift 257559',0.00,0.00,0.00,4817.33,0.00,'2022-02-28 07:16:56','',''),(2626887,'5','175','908',403,'Sale Id shift 257559',0.00,0.00,0.00,4116.07,0.00,'2022-02-28 07:16:56','',''),(2626888,'5','175',NULL,403,'Sale Id shift 257559',1474011.00,0.00,0.00,0.00,0.00,'2022-02-28 07:16:56','',''),(2626889,'5','175','908',403,'Sale Id shift 257560',0.00,0.00,0.00,3137.31,0.00,'2022-03-01 06:53:49','',''),(2626890,'5','175','908',403,'Sale Id shift 257560',0.00,0.00,0.00,2310.77,0.00,'2022-03-01 06:53:49','',''),(2626891,'5','175',NULL,403,'Sale Id shift 257560',898933.20,0.00,0.00,0.00,0.00,'2022-03-01 06:53:49','',''),(2626892,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,2145.25,0.00,'2022-03-01 07:24:55','',''),(2626893,'5','175','908',0,'Inventory adjustment from tank dipping to 2500',0.00,0.00,2500.00,0.00,0.00,'2022-03-01 07:24:55','',''),(2626894,'5','175','908',403,'Sale Id shift 257561',0.00,0.00,0.00,1678.87,0.00,'2022-03-02 08:17:50','',''),(2626895,'5','175','908',403,'Sale Id shift 257561',0.00,0.00,0.00,801.73,0.00,'2022-03-02 08:17:50','',''),(2626896,'5','175',NULL,403,'Sale Id shift 257561',409299.00,0.00,0.00,0.00,0.00,'2022-03-02 08:17:50','',''),(2626897,'5','175','909',0,'Tank level zero out for dipping',0.00,0.00,0.00,400.00,0.00,'2022-03-05 08:57:25','',''),(2626898,'5','175','909',0,'Inventory adjustment from tank dipping to 100',0.00,0.00,100.00,0.00,0.00,'2022-03-05 08:57:25','',''),(2626899,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,2227500.00,13500.00,0.00,0.00,'2022-03-15 14:51:49','',''),(2626900,'5','175',NULL,403,'Reception corrector for bridging 132068',0.00,0.00,0.00,13500.00,0.00,'2022-03-15 15:37:27','',''),(2626901,'5','175','908',403,'Received from bridging 132068',0.00,0.00,13500.00,0.00,0.00,'2022-03-15 15:37:27','',''),(2626902,'5','175','908',403,'Sale Id shift 257574',0.00,0.00,0.00,1854.94,0.00,'2022-03-16 08:08:57','',''),(2626903,'5','175','908',403,'Sale Id shift 257574',0.00,0.00,0.00,1464.66,0.00,'2022-03-16 08:08:57','',''),(2626904,'5','175',NULL,403,'Sale Id shift 257574',547734.00,0.00,0.00,0.00,0.00,'2022-03-16 08:08:57','',''),(2626905,'5','175','908',403,'Sale Id shift 257575',0.00,0.00,0.00,2841.75,0.00,'2022-03-17 10:21:33','',''),(2626906,'5','175','908',403,'Sale Id shift 257575',0.00,0.00,0.00,2665.89,0.00,'2022-03-17 10:21:33','',''),(2626907,'5','175',NULL,403,'Sale Id shift 257575',908760.60,0.00,0.00,0.00,0.00,'2022-03-17 10:21:33','',''),(2626908,'5','175','908',403,'Sale Id shift 257576',0.00,0.00,0.00,1288.93,0.00,'2022-03-18 07:46:28','',''),(2626909,'5','175','908',403,'Sale Id shift 257576',0.00,0.00,0.00,2331.74,0.00,'2022-03-18 07:46:28','',''),(2626910,'5','175',NULL,403,'Sale Id shift 257576',597410.55,0.00,0.00,0.00,0.00,'2022-03-18 07:46:28','',''),(2626911,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,1071.49,0.00,'2022-03-18 19:36:12','',''),(2626912,'5','175','908',0,'Inventory adjustment from tank dipping to 1250',0.00,0.00,1250.00,0.00,0.00,'2022-03-18 19:36:12','',''),(2626913,'5','175','908',403,'Sale Id shift 257577',0.00,0.00,0.00,1215.10,0.00,'2022-03-19 06:59:38','',''),(2626914,'5','175',NULL,403,'Sale Id shift 257577',200491.50,0.00,0.00,0.00,0.00,'2022-03-19 06:59:38','',''),(2626915,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-23 14:02:04','',''),(2626916,'5','175',NULL,403,'Reception corrector for bridging 132069',0.00,0.00,0.00,45000.00,0.00,'2022-04-23 15:50:30','',''),(2626917,'5','175','908',403,'Received from bridging 132069',0.00,0.00,45000.00,0.00,0.00,'2022-04-23 15:50:30','',''),(2626918,'5','175','908',403,'Sale Id shift 257609',0.00,0.00,0.00,326.76,0.00,'2022-04-23 17:39:13','',''),(2626919,'5','175','908',403,'Sale Id shift 257609',0.00,0.00,0.00,653.84,0.00,'2022-04-23 17:39:13','',''),(2626920,'5','175',NULL,403,'Sale Id shift 257609',161799.00,0.00,0.00,0.00,0.00,'2022-04-23 17:39:13','',''),(2626921,'5','175','908',403,'Sale Id shift 257610',0.00,0.00,0.00,3366.33,0.00,'2022-04-24 09:19:20','',''),(2626922,'5','175','908',403,'Sale Id shift 257610',0.00,0.00,0.00,2469.94,0.00,'2022-04-24 09:19:20','',''),(2626923,'5','175',NULL,403,'Sale Id shift 257610',962984.55,0.00,0.00,0.00,0.00,'2022-04-24 09:19:20','',''),(2626924,'5','175','908',403,'Sale Id shift 257611',0.00,0.00,0.00,3025.94,0.00,'2022-04-25 11:36:52','',''),(2626925,'5','175','908',403,'Sale Id shift 257611',0.00,0.00,0.00,2290.57,0.00,'2022-04-25 11:36:52','',''),(2626926,'5','175',NULL,403,'Sale Id shift 257611',877224.15,0.00,0.00,0.00,0.00,'2022-04-25 11:36:52','',''),(2626927,'5','175','908',403,'Sale Id shift 257612',0.00,0.00,0.00,3470.34,0.00,'2022-04-26 11:21:01','',''),(2626928,'5','175','908',403,'Sale Id shift 257612',0.00,0.00,0.00,2124.17,0.00,'2022-04-26 11:21:01','',''),(2626929,'5','175',NULL,403,'Sale Id shift 257612',923094.15,0.00,0.00,0.00,0.00,'2022-04-26 11:21:01','',''),(2626930,'5','175','908',403,'Sale Id shift 257613',0.00,0.00,0.00,3270.27,0.00,'2022-04-27 07:49:32','',''),(2626931,'5','175','908',403,'Sale Id shift 257613',0.00,0.00,0.00,1944.55,0.00,'2022-04-27 07:49:32','',''),(2626932,'5','175',NULL,403,'Sale Id shift 257613',860445.30,0.00,0.00,0.00,0.00,'2022-04-27 07:49:32','',''),(2626933,'5','175','908',403,'Sale Id shift 257614',0.00,0.00,0.00,3627.73,0.00,'2022-04-28 08:25:57','',''),(2626934,'5','175','908',403,'Sale Id shift 257614',0.00,0.00,0.00,2506.24,0.00,'2022-04-28 08:25:57','',''),(2626935,'5','175',NULL,403,'Sale Id shift 257614',1012105.05,0.00,0.00,0.00,0.00,'2022-04-28 08:25:57','',''),(2626936,'5','175','908',403,'Sale Id shift 257615',0.00,0.00,0.00,3616.61,0.00,'2022-04-29 10:19:53','',''),(2626937,'5','175','908',403,'Sale Id shift 257615',0.00,0.00,0.00,2446.55,0.00,'2022-04-29 10:19:53','',''),(2626938,'5','175',NULL,403,'Sale Id shift 257615',1000421.40,0.00,0.00,0.00,0.00,'2022-04-29 10:19:53','',''),(2626939,'5','175','908',403,'Sale Id shift 257616',0.00,0.00,0.00,2143.02,0.00,'2022-05-10 09:19:22','',''),(2626940,'5','175','908',403,'Sale Id shift 257616',0.00,0.00,0.00,2025.05,0.00,'2022-05-10 09:19:22','',''),(2626941,'5','175',NULL,403,'Sale Id shift 257616',687731.55,0.00,0.00,0.00,0.00,'2022-05-10 09:19:22','',''),(2626942,'5','175','908',403,'Sale Id shift 257617',0.00,0.00,0.00,2149.05,0.00,'2022-05-10 11:17:17','',''),(2626943,'5','175','908',403,'Sale Id shift 257617',0.00,0.00,0.00,1975.46,0.00,'2022-05-10 11:17:17','',''),(2626944,'5','175',NULL,403,'Sale Id shift 257617',680544.15,0.00,0.00,0.00,0.00,'2022-05-10 11:17:17','',''),(2626945,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,1602.48,0.00,'2022-05-10 14:20:19','',''),(2626946,'5','175','908',0,'Inventory adjustment from tank dipping to 1750',0.00,0.00,1750.00,0.00,0.00,'2022-05-10 14:20:19','',''),(2626947,'5','175','908',403,'Sale Id shift 257618',0.00,0.00,0.00,1721.36,0.00,'2022-05-10 15:54:19','',''),(2626948,'5','175',NULL,403,'Sale Id shift 257618',284024.40,0.00,0.00,0.00,0.00,'2022-05-10 15:54:19','',''),(2626949,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4372500.00,26500.00,0.00,0.00,'2022-05-10 15:59:30','',''),(2626950,'5','175',NULL,403,'Reception corrector for bridging 132070',0.00,0.00,0.00,26500.00,0.00,'2022-05-11 05:56:07','',''),(2626951,'5','175','908',403,'Received from bridging 132070',0.00,0.00,26500.00,0.00,0.00,'2022-05-11 05:56:07','',''),(2626952,'5','175','908',403,'Sale Id shift 257622',0.00,0.00,0.00,2003.26,0.00,'2022-05-11 06:40:53','',''),(2626953,'5','175','908',403,'Sale Id shift 257622',0.00,0.00,0.00,1403.03,0.00,'2022-05-11 06:40:53','',''),(2626954,'5','175',NULL,403,'Sale Id shift 257622',562037.85,0.00,0.00,0.00,0.00,'2022-05-11 06:40:53','',''),(2626955,'5','175','908',403,'Sale Id shift 257623',0.00,0.00,0.00,2034.61,0.00,'2022-05-11 07:14:19','',''),(2626956,'5','175','908',403,'Sale Id shift 257623',0.00,0.00,0.00,1656.37,0.00,'2022-05-11 07:14:19','',''),(2626957,'5','175',NULL,403,'Sale Id shift 257623',609011.70,0.00,0.00,0.00,0.00,'2022-05-11 07:14:19','',''),(2626958,'5','175','908',403,'Sale Id shift 257624',0.00,0.00,0.00,2954.13,0.00,'2022-05-11 07:48:52','',''),(2626959,'5','175','908',403,'Sale Id shift 257624',0.00,0.00,0.00,2462.10,0.00,'2022-05-11 07:48:52','',''),(2626960,'5','175',NULL,403,'Sale Id shift 257624',893677.95,0.00,0.00,0.00,0.00,'2022-05-11 07:48:52','',''),(2626961,'5','175','908',403,'Sale Id shift 257625',0.00,0.00,0.00,2756.70,0.00,'2022-05-11 08:31:59','',''),(2626962,'5','175','908',403,'Sale Id shift 257625',0.00,0.00,0.00,2299.49,0.00,'2022-05-11 08:31:59','',''),(2626963,'5','175',NULL,403,'Sale Id shift 257625',834271.35,0.00,0.00,0.00,0.00,'2022-05-11 08:31:59','',''),(2626964,'5','175','908',403,'Sale Id shift 257626',0.00,0.00,0.00,1942.50,0.00,'2022-05-11 08:42:08','',''),(2626965,'5','175','908',403,'Sale Id shift 257626',0.00,0.00,0.00,2160.18,0.00,'2022-05-11 08:42:08','',''),(2626966,'5','175',NULL,403,'Sale Id shift 257626',676942.20,0.00,0.00,0.00,0.00,'2022-05-11 08:42:08','',''),(2626967,'5','175','908',403,'Sale Id shift 257627',0.00,0.00,0.00,1713.42,0.00,'2022-05-11 08:44:16','',''),(2626968,'5','175','908',403,'Sale Id shift 257627',0.00,0.00,0.00,1879.91,0.00,'2022-05-11 08:44:16','',''),(2626969,'5','175',NULL,403,'Sale Id shift 257627',592899.45,0.00,0.00,0.00,0.00,'2022-05-11 08:44:16','',''),(2626970,'5','175','908',403,'Sale Id shift 257628',0.00,0.00,0.00,1014.95,0.00,'2022-05-12 18:43:52','',''),(2626971,'5','175','908',403,'Sale Id shift 257628',0.00,0.00,0.00,193.41,0.00,'2022-05-12 18:43:52','',''),(2626972,'5','175',NULL,403,'Sale Id shift 257628',199379.40,0.00,0.00,0.00,0.00,'2022-05-12 18:43:52','',''),(2626973,'5','175',NULL,404,'2022-05-13 08:07:53',0.00,546107.36,0.00,0.00,0.00,'2022-05-13 08:07:53','',''),(2626974,'5','175','910',0,'Tank level zero out for dipping',0.00,0.00,0.00,200.00,0.00,'2022-05-20 22:06:47','',''),(2626975,'5','175','910',0,'Inventory adjustment from tank dipping to 250',0.00,0.00,250.00,0.00,0.00,'2022-05-20 22:06:47','',''),(2626976,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,3712500.00,22500.00,0.00,0.00,'2022-05-28 22:10:58','',''),(2626977,'5','175',NULL,403,'Reception corrector for bridging 132071',0.00,0.00,0.00,22500.00,0.00,'2022-05-28 23:04:11','',''),(2626978,'5','175','908',403,'Received from bridging 132071',0.00,0.00,22500.00,0.00,0.00,'2022-05-28 23:04:11','',''),(2626979,'5','175','908',403,'Sale Id shift 257645',0.00,0.00,0.00,43.85,0.00,'2022-05-29 08:17:23','',''),(2626980,'5','175','908',403,'Sale Id shift 257645',0.00,0.00,0.00,1218.55,0.00,'2022-05-29 08:17:23','',''),(2626981,'5','175',NULL,403,'Sale Id shift 257645',208296.00,0.00,0.00,0.00,0.00,'2022-05-29 08:17:23','',''),(2626982,'5','175','908',403,'Sale Id shift 257646',0.00,0.00,0.00,2684.83,0.00,'2022-05-30 04:59:35','',''),(2626983,'5','175','908',403,'Sale Id shift 257646',0.00,0.00,0.00,2784.70,0.00,'2022-05-30 04:59:35','',''),(2626984,'5','175',NULL,403,'Sale Id shift 257646',902472.45,0.00,0.00,0.00,0.00,'2022-05-30 04:59:35','',''),(2626985,'5','175','908',403,'Sale Id shift 257647',0.00,0.00,0.00,2773.25,0.00,'2022-05-31 00:20:15','',''),(2626986,'5','175','908',403,'Sale Id shift 257647',0.00,0.00,0.00,1711.26,0.00,'2022-05-31 00:20:15','',''),(2626987,'5','175',NULL,403,'Sale Id shift 257647',739944.15,0.00,0.00,0.00,0.00,'2022-05-31 00:20:15','',''),(2626988,'5','175','908',403,'Sale Id shift 257648',0.00,0.00,0.00,2300.63,0.00,'2022-06-01 07:04:11','',''),(2626989,'5','175','908',403,'Sale Id shift 257648',0.00,0.00,0.00,2391.97,0.00,'2022-06-01 07:04:11','',''),(2626990,'5','175',NULL,403,'Sale Id shift 257648',774279.00,0.00,0.00,0.00,0.00,'2022-06-01 07:04:11','',''),(2626991,'5','175','908',403,'Sale Id shift 257649',0.00,0.00,0.00,2759.04,0.00,'2022-06-02 05:01:03','',''),(2626992,'5','175','908',403,'Sale Id shift 257649',0.00,0.00,0.00,2091.60,0.00,'2022-06-02 05:01:03','',''),(2626993,'5','175',NULL,403,'Sale Id shift 257649',800355.60,0.00,0.00,0.00,0.00,'2022-06-02 05:01:03','',''),(2626994,'5','175','908',403,'Sale Id shift 257650',0.00,0.00,0.00,1703.33,0.00,'2022-06-03 06:46:28','',''),(2626995,'5','175',NULL,403,'Sale Id shift 257650',281049.45,0.00,0.00,0.00,0.00,'2022-06-03 06:46:28','',''),(2626996,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8297250.00,44850.00,0.00,0.00,'2022-07-18 10:49:08','',''),(2626997,'5','175',NULL,403,'Reception corrector for bridging 132072',0.00,0.00,0.00,44850.00,0.00,'2022-07-18 11:22:30','',''),(2626998,'5','175','908',403,'Received from bridging 132072',0.00,0.00,44850.00,0.00,0.00,'2022-07-18 11:22:30','',''),(2626999,'5','175','908',403,'Sale Id shift 257695',0.00,0.00,0.00,1185.00,0.00,'2022-07-18 11:48:27','',''),(2627000,'5','175',NULL,403,'Sale Id shift 257695',219225.00,0.00,0.00,0.00,0.00,'2022-07-18 11:48:27','',''),(2627001,'5','175','908',403,'Sale Id shift 257696',0.00,0.00,0.00,2083.66,0.00,'2022-07-19 07:22:03','',''),(2627002,'5','175','908',403,'Sale Id shift 257696',0.00,0.00,0.00,2946.78,0.00,'2022-07-19 07:22:03','',''),(2627003,'5','175',NULL,403,'Sale Id shift 257696',930631.40,0.00,0.00,0.00,0.00,'2022-07-19 07:22:03','',''),(2627004,'5','175','908',403,'Sale Id shift 257697',0.00,0.00,0.00,2111.98,0.00,'2022-07-20 07:40:10','',''),(2627005,'5','175','908',403,'Sale Id shift 257697',0.00,0.00,0.00,1392.36,0.00,'2022-07-20 07:40:10','',''),(2627006,'5','175',NULL,403,'Sale Id shift 257697',648302.90,0.00,0.00,0.00,0.00,'2022-07-20 07:40:10','',''),(2627007,'5','175','908',403,'Sale Id shift 257698',0.00,0.00,0.00,3138.39,0.00,'2022-07-21 06:49:11','',''),(2627008,'5','175','908',403,'Sale Id shift 257698',0.00,0.00,0.00,2254.75,0.00,'2022-07-21 06:49:11','',''),(2627009,'5','175',NULL,403,'Sale Id shift 257698',997730.90,0.00,0.00,0.00,0.00,'2022-07-21 06:49:11','',''),(2627010,'5','175','908',403,'Sale Id shift 257699',0.00,0.00,0.00,1940.82,0.00,'2022-07-21 23:15:21','',''),(2627011,'5','175','908',403,'Sale Id shift 257699',0.00,0.00,0.00,2513.00,0.00,'2022-07-21 23:15:21','',''),(2627012,'5','175',NULL,403,'Sale Id shift 257699',823956.70,0.00,0.00,0.00,0.00,'2022-07-21 23:15:21','',''),(2627013,'5','175','908',403,'Sale Id shift 257700',0.00,0.00,0.00,2836.34,0.00,'2022-07-23 06:54:53','',''),(2627014,'5','175','908',403,'Sale Id shift 257700',0.00,0.00,0.00,1639.56,0.00,'2022-07-23 06:54:53','',''),(2627015,'5','175',NULL,403,'Sale Id shift 257700',828041.50,0.00,0.00,0.00,0.00,'2022-07-23 06:54:53','',''),(2627016,'5','175','908',403,'Sale Id shift 257701',0.00,0.00,0.00,2531.61,0.00,'2022-07-24 08:32:16','',''),(2627017,'5','175','908',403,'Sale Id shift 257701',0.00,0.00,0.00,1672.36,0.00,'2022-07-24 08:32:16','',''),(2627018,'5','175',NULL,403,'Sale Id shift 257701',777734.45,0.00,0.00,0.00,0.00,'2022-07-24 08:32:16','',''),(2627019,'5','175','908',403,'Sale Id shift 257702',0.00,0.00,0.00,2201.37,0.00,'2022-07-25 06:44:43','',''),(2627020,'5','175','908',403,'Sale Id shift 257702',0.00,0.00,0.00,2177.25,0.00,'2022-07-25 06:44:43','',''),(2627021,'5','175',NULL,403,'Sale Id shift 257702',810044.70,0.00,0.00,0.00,0.00,'2022-07-25 06:44:43','',''),(2627022,'5','175','908',403,'Sale Id shift 257703',0.00,0.00,0.00,2518.76,0.00,'2022-07-26 05:53:45','',''),(2627023,'5','175','908',403,'Sale Id shift 257703',0.00,0.00,0.00,1032.18,0.00,'2022-07-26 05:53:45','',''),(2627024,'5','175',NULL,403,'Sale Id shift 257703',656923.90,0.00,0.00,0.00,0.00,'2022-07-26 05:53:45','',''),(2627025,'5','175','908',403,'Sale Id shift 257704',0.00,0.00,0.00,1603.12,0.00,'2022-07-27 07:30:12','',''),(2627026,'5','175','908',403,'Sale Id shift 257704',0.00,0.00,0.00,1491.31,0.00,'2022-07-27 07:30:12','',''),(2627027,'5','175',NULL,403,'Sale Id shift 257704',572469.55,0.00,0.00,0.00,0.00,'2022-07-27 07:30:12','',''),(2627028,'5','175','908',403,'Sale Id shift 257705',0.00,0.00,0.00,1968.10,0.00,'2022-07-28 06:53:54','',''),(2627029,'5','175','908',403,'Sale Id shift 257705',0.00,0.00,0.00,2045.26,0.00,'2022-07-28 06:53:54','',''),(2627030,'5','175',NULL,403,'Sale Id shift 257705',742471.60,0.00,0.00,0.00,0.00,'2022-07-28 06:53:54','',''),(2627031,'5','175','908',403,'Sale Id shift 257706',0.00,0.00,0.00,1568.58,0.00,'2022-07-29 07:12:22','',''),(2627032,'5','175',NULL,403,'Sale Id shift 257706',290187.30,0.00,0.00,0.00,0.00,'2022-07-29 07:12:22','',''),(2627033,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,9222250.00,49850.00,0.00,0.00,'2022-09-05 10:53:03','',''),(2627034,'5','175',NULL,403,'Reception corrector for bridging 132073',0.00,0.00,0.00,49850.00,0.00,'2022-09-05 11:01:35','',''),(2627035,'5','175','908',403,'Received from bridging 132073',0.00,0.00,49850.00,0.00,0.00,'2022-09-05 11:01:35','',''),(2627036,'5','175','908',403,'Sale Id shift 257722',0.00,0.00,0.00,1670.50,0.00,'2022-09-05 11:08:03','',''),(2627037,'5','175',NULL,403,'Sale Id shift 257722',309042.50,0.00,0.00,0.00,0.00,'2022-09-05 11:08:03','',''),(2627038,'5','175','908',403,'Sale Id shift 257723',0.00,0.00,0.00,3040.27,0.00,'2022-09-05 11:10:28','',''),(2627039,'5','175','908',403,'Sale Id shift 257723',0.00,0.00,0.00,1234.53,0.00,'2022-09-05 11:10:28','',''),(2627040,'5','175',NULL,403,'Sale Id shift 257723',790838.00,0.00,0.00,0.00,0.00,'2022-09-05 11:10:28','',''),(2627041,'5','175','908',403,'Sale Id shift 257724',0.00,0.00,0.00,2844.63,0.00,'2022-09-05 11:13:57','',''),(2627042,'5','175','908',403,'Sale Id shift 257724',0.00,0.00,0.00,1648.17,0.00,'2022-09-05 11:13:57','',''),(2627043,'5','175',NULL,403,'Sale Id shift 257724',831168.00,0.00,0.00,0.00,0.00,'2022-09-05 11:13:57','',''),(2627044,'5','175','908',403,'Sale Id shift 257725',0.00,0.00,0.00,2164.55,0.00,'2022-09-05 11:17:38','',''),(2627045,'5','175','908',403,'Sale Id shift 257725',0.00,0.00,0.00,2746.32,0.00,'2022-09-05 11:17:38','',''),(2627046,'5','175',NULL,403,'Sale Id shift 257725',908510.95,0.00,0.00,0.00,0.00,'2022-09-05 11:17:38','',''),(2627047,'5','175','908',403,'Sale Id shift 257726',0.00,0.00,0.00,2887.56,0.00,'2022-09-05 11:25:00','',''),(2627048,'5','175','908',403,'Sale Id shift 257726',0.00,0.00,0.00,2671.26,0.00,'2022-09-05 11:25:00','',''),(2627049,'5','175',NULL,403,'Sale Id shift 257726',1028381.70,0.00,0.00,0.00,0.00,'2022-09-05 11:25:00','',''),(2627050,'5','175','908',403,'Sale Id shift 257727',0.00,0.00,0.00,2562.37,0.00,'2022-09-05 11:29:03','',''),(2627051,'5','175','908',403,'Sale Id shift 257727',0.00,0.00,0.00,2031.13,0.00,'2022-09-05 11:29:03','',''),(2627052,'5','175',NULL,403,'Sale Id shift 257727',849797.50,0.00,0.00,0.00,0.00,'2022-09-05 11:29:03','',''),(2627053,'5','175','908',403,'Sale Id shift 257728',0.00,0.00,0.00,3088.36,0.00,'2022-09-05 11:33:00','',''),(2627054,'5','175','908',403,'Sale Id shift 257728',0.00,0.00,0.00,3084.89,0.00,'2022-09-05 11:33:00','',''),(2627055,'5','175',NULL,403,'Sale Id shift 257728',1142051.25,0.00,0.00,0.00,0.00,'2022-09-05 11:33:00','',''),(2627056,'5','175','908',403,'Sale Id shift 257729',0.00,0.00,0.00,246.68,0.00,'2022-09-05 11:40:28','',''),(2627057,'5','175','908',403,'Sale Id shift 257729',0.00,0.00,0.00,3405.74,0.00,'2022-09-05 11:40:28','',''),(2627058,'5','175',NULL,403,'Sale Id shift 257729',675697.70,0.00,0.00,0.00,0.00,'2022-09-05 11:40:28','',''),(2627059,'5','175','908',403,'Sale Id shift 257730',0.00,0.00,0.00,23.49,0.00,'2022-09-05 11:45:41','',''),(2627060,'5','175','908',403,'Sale Id shift 257730',0.00,0.00,0.00,4211.02,0.00,'2022-09-05 11:45:41','',''),(2627061,'5','175',NULL,403,'Sale Id shift 257730',783384.35,0.00,0.00,0.00,0.00,'2022-09-05 11:45:41','',''),(2627062,'5','175','908',403,'Sale Id shift 257731',0.00,0.00,0.00,2481.74,0.00,'2022-09-05 11:55:11','',''),(2627063,'5','175','908',403,'Sale Id shift 257731',0.00,0.00,0.00,2155.64,0.00,'2022-09-05 11:55:11','',''),(2627064,'5','175',NULL,403,'Sale Id shift 257731',857915.30,0.00,0.00,0.00,0.00,'2022-09-05 11:55:11','',''),(2627065,'5','175','908',403,'Sale Id shift 257732',0.00,0.00,0.00,1052.65,0.00,'2022-09-05 11:58:56','',''),(2627066,'5','175','908',403,'Sale Id shift 257732',0.00,0.00,0.00,1175.46,0.00,'2022-09-05 11:58:56','',''),(2627067,'5','175',NULL,403,'Sale Id shift 257732',412200.35,0.00,0.00,0.00,0.00,'2022-09-05 11:58:56','',''),(2627068,'5','175','908',403,'Sale Id shift 257733',0.00,0.00,0.00,1074.50,0.00,'2022-09-05 12:04:49','',''),(2627069,'5','175','908',403,'Sale Id shift 257733',0.00,0.00,0.00,1126.10,0.00,'2022-09-05 12:04:49','',''),(2627070,'5','175',NULL,403,'Sale Id shift 257733',407111.00,0.00,0.00,0.00,0.00,'2022-09-05 12:04:49','',''),(2627071,'5','175','908',403,'Sale Id shift 257734',0.00,0.00,0.00,925.50,0.00,'2022-09-05 12:07:41','',''),(2627072,'5','175','908',403,'Sale Id shift 257734',0.00,0.00,0.00,273.90,0.00,'2022-09-05 12:07:41','',''),(2627073,'5','175',NULL,403,'Sale Id shift 257734',221889.00,0.00,0.00,0.00,0.00,'2022-09-05 12:07:41','',''),(2627074,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-05 12:37:07','',''),(2627075,'5','175',NULL,403,'Reception corrector for bridging 132074',0.00,0.00,0.00,45000.00,0.00,'2022-09-05 12:48:32','',''),(2627076,'5','175','908',403,'Received from bridging 132074',0.00,0.00,45000.00,0.00,0.00,'2022-09-05 12:48:32','',''),(2627077,'5','175','908',403,'Sale Id shift 257746',0.00,0.00,0.00,1318.32,0.00,'2022-09-06 10:27:57','',''),(2627078,'5','175','908',403,'Sale Id shift 257746',0.00,0.00,0.00,1347.68,0.00,'2022-09-06 10:27:57','',''),(2627079,'5','175',NULL,403,'Sale Id shift 257746',493210.00,0.00,0.00,0.00,0.00,'2022-09-06 10:27:57','',''),(2627080,'5','175','908',403,'Sale Id shift 257747',0.00,0.00,0.00,3606.27,0.00,'2022-09-07 08:24:35','',''),(2627081,'5','175','908',403,'Sale Id shift 257747',0.00,0.00,0.00,2403.80,0.00,'2022-09-07 08:24:35','',''),(2627082,'5','175',NULL,403,'Sale Id shift 257747',1111862.95,0.00,0.00,0.00,0.00,'2022-09-07 08:24:35','',''),(2627083,'5','175','908',403,'Sale Id shift 257748',0.00,0.00,0.00,2182.56,0.00,'2022-09-08 07:10:42','',''),(2627084,'5','175','908',403,'Sale Id shift 257748',0.00,0.00,0.00,2777.45,0.00,'2022-09-08 07:10:42','',''),(2627085,'5','175',NULL,403,'Sale Id shift 257748',917601.85,0.00,0.00,0.00,0.00,'2022-09-08 07:10:42','',''),(2627086,'5','175','908',403,'Sale Id shift 257749',0.00,0.00,0.00,3921.98,0.00,'2022-09-09 08:18:03','',''),(2627087,'5','175','908',403,'Sale Id shift 257749',0.00,0.00,0.00,1423.61,0.00,'2022-09-09 08:18:03','',''),(2627088,'5','175',NULL,403,'Sale Id shift 257749',988934.15,0.00,0.00,0.00,0.00,'2022-09-09 08:18:03','',''),(2627089,'5','175','908',403,'Sale Id shift 257750',0.00,0.00,0.00,1816.71,0.00,'2022-09-10 09:39:38','',''),(2627090,'5','175','908',403,'Sale Id shift 257750',0.00,0.00,0.00,1782.56,0.00,'2022-09-10 09:39:38','',''),(2627091,'5','175',NULL,403,'Sale Id shift 257750',665864.95,0.00,0.00,0.00,0.00,'2022-09-10 09:39:38','',''),(2627092,'5','175','908',403,'Sale Id shift 257751',0.00,0.00,0.00,2497.63,0.00,'2022-09-11 08:55:58','',''),(2627093,'5','175','908',403,'Sale Id shift 257751',0.00,0.00,0.00,1678.62,0.00,'2022-09-11 08:55:58','',''),(2627094,'5','175',NULL,403,'Sale Id shift 257751',772606.25,0.00,0.00,0.00,0.00,'2022-09-11 08:55:58','',''),(2627095,'5','175','908',403,'Sale Id shift 257752',0.00,0.00,0.00,2346.34,0.00,'2022-09-12 08:56:15','',''),(2627096,'5','175','908',403,'Sale Id shift 257752',0.00,0.00,0.00,1885.27,0.00,'2022-09-12 08:56:15','',''),(2627097,'5','175',NULL,403,'Sale Id shift 257752',782847.85,0.00,0.00,0.00,0.00,'2022-09-12 08:56:15','',''),(2627098,'5','175','908',403,'Sale Id shift 257753',0.00,0.00,0.00,2493.74,0.00,'2022-09-13 09:15:19','',''),(2627099,'5','175','908',403,'Sale Id shift 257753',0.00,0.00,0.00,2012.55,0.00,'2022-09-13 09:15:19','',''),(2627100,'5','175',NULL,403,'Sale Id shift 257753',833663.65,0.00,0.00,0.00,0.00,'2022-09-13 09:15:19','',''),(2627101,'5','175','908',403,'Sale Id shift 257754',0.00,0.00,0.00,1981.83,0.00,'2022-09-14 08:14:09','',''),(2627102,'5','175','908',403,'Sale Id shift 257754',0.00,0.00,0.00,2044.17,0.00,'2022-09-14 08:14:09','',''),(2627103,'5','175',NULL,403,'Sale Id shift 257754',744810.00,0.00,0.00,0.00,0.00,'2022-09-14 08:14:09','',''),(2627104,'5','175','908',403,'Sale Id shift 257755',0.00,0.00,0.00,1300.18,0.00,'2022-09-15 08:52:10','',''),(2627105,'5','175','908',403,'Sale Id shift 257755',0.00,0.00,0.00,2266.86,0.00,'2022-09-15 08:52:10','',''),(2627106,'5','175',NULL,403,'Sale Id shift 257755',659902.40,0.00,0.00,0.00,0.00,'2022-09-15 08:52:10','',''),(2627107,'5','175','908',0,'Tank level zero out for dipping',0.00,0.00,0.00,2023.94,0.00,'2022-09-15 21:10:30','',''),(2627108,'5','175','908',0,'Inventory adjustment from tank dipping to 2300',0.00,0.00,2300.00,0.00,0.00,'2022-09-15 21:10:30','',''),(2627109,'5','175','908',403,'Sale Id shift 257756',0.00,0.00,0.00,2194.28,0.00,'2022-09-16 09:08:55','',''),(2627110,'5','175',NULL,403,'Sale Id shift 257756',405941.80,0.00,0.00,0.00,0.00,'2022-09-16 09:08:55','',''),(2627111,'5','175',NULL,403,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-17 10:13:24','',''),(2627112,'5','175',NULL,403,'Reception corrector for bridging 132075',0.00,0.00,0.00,45000.00,0.00,'2022-09-17 10:35:50','',''),(2627113,'5','175','908',403,'Received from bridging 132075',0.00,0.00,45000.00,0.00,0.00,'2022-09-17 10:35:50','',''),(2627114,'5','175','908',403,'Sale Id shift 257757',0.00,0.00,0.00,1077.53,0.00,'2022-09-17 10:42:22','',''),(2627115,'5','175','908',403,'Sale Id shift 257757',0.00,0.00,0.00,102.94,0.00,'2022-09-17 10:42:22','',''),(2627116,'5','175',NULL,403,'Sale Id shift 257757',218386.95,0.00,0.00,0.00,0.00,'2022-09-17 10:42:22','',''),(2627117,'5','175','908',403,'Sale Id shift 257758',0.00,0.00,0.00,2404.19,0.00,'2022-09-18 07:21:33','',''),(2627118,'5','175','908',403,'Sale Id shift 257758',0.00,0.00,0.00,1774.92,0.00,'2022-09-18 07:21:34','',''),(2627119,'5','175',NULL,403,'Sale Id shift 257758',773135.35,0.00,0.00,0.00,0.00,'2022-09-18 07:21:34','',''),(2627120,'5','175','908',403,'Sale Id shift 257759',0.00,0.00,0.00,2239.54,0.00,'2022-09-19 07:20:02','',''),(2627121,'5','175','908',403,'Sale Id shift 257759',0.00,0.00,0.00,2037.90,0.00,'2022-09-19 07:20:02','',''),(2627122,'5','175',NULL,403,'Sale Id shift 257759',791326.40,0.00,0.00,0.00,0.00,'2022-09-19 07:20:02','',''),(2627123,'5','175','908',403,'Sale Id shift 257760',0.00,0.00,0.00,3946.37,0.00,'2022-09-20 08:33:02','',''),(2627124,'5','175','908',403,'Sale Id shift 257760',0.00,0.00,0.00,489.21,0.00,'2022-09-20 08:33:02','',''),(2627125,'5','175',NULL,403,'Sale Id shift 257760',820582.30,0.00,0.00,0.00,0.00,'2022-09-20 08:33:02','',''),(2627126,'5','175','908',403,'Sale Id shift 257761',0.00,0.00,0.00,664.67,0.00,'2022-09-21 11:51:21','',''),(2627127,'5','175','908',403,'Sale Id shift 257761',0.00,0.00,0.00,3707.01,0.00,'2022-09-21 11:51:21','',''),(2627128,'5','175',NULL,403,'Sale Id shift 257761',808760.80,0.00,0.00,0.00,0.00,'2022-09-21 11:51:21','',''),(2627129,'5','175','908',403,'Sale Id shift 257762',0.00,0.00,0.00,1732.02,0.00,'2022-09-22 07:39:26','',''),(2627130,'5','175','908',403,'Sale Id shift 257762',0.00,0.00,0.00,1930.10,0.00,'2022-09-22 07:39:26','',''),(2627131,'5','175',NULL,403,'Sale Id shift 257762',677492.20,0.00,0.00,0.00,0.00,'2022-09-22 07:39:26','',''),(2627132,'5','175','908',403,'Sale Id shift 257763',0.00,0.00,0.00,2153.99,0.00,'2022-09-23 07:49:51','',''),(2627133,'5','175','908',403,'Sale Id shift 257763',0.00,0.00,0.00,1354.78,0.00,'2022-09-23 07:49:51','',''),(2627134,'5','175',NULL,403,'Sale Id shift 257763',649122.45,0.00,0.00,0.00,0.00,'2022-09-23 07:49:51','',''),(2627135,'5','175','908',403,'Sale Id shift 257764',0.00,0.00,0.00,1922.47,0.00,'2022-09-23 22:38:54','',''),(2627136,'5','175','908',403,'Sale Id shift 257764',0.00,0.00,0.00,1737.17,0.00,'2022-09-23 22:38:54','',''),(2627137,'5','175',NULL,403,'Sale Id shift 257764',677033.40,0.00,0.00,0.00,0.00,'2022-09-23 22:38:54','',''),(2627138,'5','175','908',403,'Sale Id shift 257765',0.00,0.00,0.00,2486.73,0.00,'2022-09-25 08:04:58','',''),(2627139,'5','175','908',403,'Sale Id shift 257765',0.00,0.00,0.00,1651.90,0.00,'2022-09-25 08:04:58','',''),(2627140,'5','175',NULL,403,'Sale Id shift 257765',765646.55,0.00,0.00,0.00,0.00,'2022-09-25 08:04:58','',''),(2627141,'5','175','908',403,'Sale Id shift 257766',0.00,0.00,0.00,1189.86,0.00,'2022-09-26 07:17:57','',''),(2627142,'5','175','908',403,'Sale Id shift 257766',0.00,0.00,0.00,2646.03,0.00,'2022-09-26 07:17:57','',''),(2627143,'5','175',NULL,403,'Sale Id shift 257766',709639.65,0.00,0.00,0.00,0.00,'2022-09-26 07:17:57','',''),(2627144,'5','175','908',403,'Sale Id shift 257767',0.00,0.00,0.00,2600.14,0.00,'2022-09-27 07:25:13','',''),(2627145,'5','175','908',403,'Sale Id shift 257767',0.00,0.00,0.00,1329.43,0.00,'2022-09-27 07:25:13','',''),(2627146,'5','175',NULL,403,'Sale Id shift 257767',726970.45,0.00,0.00,0.00,0.00,'2022-09-27 07:25:13','',''),(2627147,'5','175','908',403,'Sale Id shift 257768',0.00,0.00,0.00,1584.75,0.00,'2022-09-28 08:23:37','',''),(2627148,'5','175','908',403,'Sale Id shift 257768',0.00,0.00,0.00,1988.75,0.00,'2022-09-28 08:23:37','',''),(2627149,'5','175',NULL,403,'Sale Id shift 257768',661097.50,0.00,0.00,0.00,0.00,'2022-09-28 08:23:37','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1780033 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (530463,'5','175',403,'Sale Id shift 181515',0.00,0.00,0.00,0.00,0.00,'2021-02-27 20:45:36'),(530464,'5','175',404,'Sale Id shift 181515',0.00,0.00,0.00,0.00,0.00,'2021-02-27 20:45:36'),(534173,'5','175',404,'Sale Id shift 181546',0.00,0.00,0.00,0.00,0.00,'2021-02-28 18:44:52'),(537601,'5','175',404,'Sale Id shift 181713',0.00,0.00,250.00,576265.00,576265.00,'2021-03-01 19:09:55'),(540710,'5','175',404,'Sale Id shift 182007',0.00,0.00,250.00,272470.00,272470.00,'2021-03-02 19:02:56'),(543566,'5','175',404,'Sale Id shift 182143',0.00,0.00,250.00,51922.50,51922.50,'2021-03-03 16:01:40'),(553664,'5','175',404,'Sale Id shift 182682',0.00,416602.50,250.00,416602.50,0.00,'2021-03-07 09:23:13'),(555175,'5','175',403,'Sale Id shift 182884',0.00,0.00,163.00,836742.57,836742.57,'2021-03-08 06:44:26'),(555176,'5','175',404,'Sale Id shift 182884',0.00,257885.00,265.00,273358.10,15473.10,'2021-03-08 06:44:26'),(557992,'5','175',403,'Sale Id shift 183000',0.00,1787598.18,163.00,1787598.18,0.00,'2021-03-09 04:29:16'),(557993,'5','175',404,'Sale Id shift 183000',0.00,219202.50,265.00,232354.65,13152.15,'2021-03-09 04:29:16'),(560989,'5','175',403,'Sale Id shift 183231',0.00,2122654.46,163.00,2122654.46,0.00,'2021-03-09 19:23:30'),(560990,'5','175',404,'Sale Id shift 183231',0.00,315460.00,265.00,334387.60,18927.60,'2021-03-09 19:23:30'),(564157,'5','175',403,'Sale Id shift 183433',0.00,1968715.63,163.00,1968715.63,0.00,'2021-03-11 07:16:07'),(564158,'5','175',404,'Sale Id shift 183433',0.00,513267.50,265.00,544063.55,30796.05,'2021-03-11 07:16:07'),(566531,'5','175',403,'Sale Id shift 183676',0.00,1896368.08,163.00,1896368.08,0.00,'2021-03-11 21:31:09'),(566532,'5','175',404,'Sale Id shift 183676',0.00,116750.00,265.00,123755.00,7005.00,'2021-03-11 21:31:09'),(569118,'5','175',403,'Sale Id shift 183972',0.00,1233168.35,163.00,1233168.35,0.00,'2021-03-13 10:05:47'),(569119,'5','175',404,'Sale Id shift 183972',0.00,484967.50,255.00,494666.85,9699.35,'2021-03-13 10:05:47'),(571428,'5','175',404,'Sale Id shift 184122',0.00,382352.50,255.00,389999.55,7647.05,'2021-03-14 08:06:58'),(573996,'5','175',404,'Sale Id shift 184311',0.00,526390.00,255.00,536917.80,10527.80,'2021-03-15 05:53:14'),(576035,'5','175',403,'Sale Id shift 184501',0.00,1672050.74,163.00,1672050.74,0.00,'2021-03-15 14:05:05'),(577322,'5','175',403,'Sale Id shift 184607',0.00,1161379.89,162.00,1154254.86,-7125.03,'2021-03-15 22:31:45'),(577323,'5','175',404,'Sale Id shift 184607',0.00,541627.50,255.00,552460.05,10832.55,'2021-03-15 22:31:45'),(580593,'5','175',403,'Sale Id shift 184733',0.00,1979486.67,162.00,1967342.58,-12144.09,'2021-03-17 06:59:45'),(583290,'5','175',403,'Sale Id shift 184919',0.00,1715128.38,163.00,1715128.38,0.00,'2021-03-18 06:53:54'),(592805,'5','175',403,'Sale Id shift 185520',0.00,1425097.59,163.00,1425097.59,0.00,'2021-03-20 19:52:53'),(596393,'5','175',403,'Sale Id shift 185675',0.00,1712370.42,163.00,1712370.42,0.00,'2021-03-21 20:07:50'),(599482,'5','175',403,'Sale Id shift 185889',0.00,2371395.72,163.00,2371395.72,0.00,'2021-03-22 20:57:59'),(602630,'5','175',403,'Sale Id shift 186096',0.00,2236312.73,163.00,2236312.73,0.00,'2021-03-24 05:29:53'),(605726,'5','175',403,'Sale Id shift 186347',0.00,2144072.66,163.00,2144072.66,0.00,'2021-03-25 05:27:28'),(608583,'5','175',403,'Sale Id shift 186569',0.00,720456.74,163.00,720456.74,0.00,'2021-03-26 05:37:48'),(617865,'5','175',403,'Sale Id shift 187189',0.00,2113412.36,163.00,2113412.36,0.00,'2021-03-29 06:30:21'),(620759,'5','175',403,'Sale Id shift 187401',0.00,1908382.81,163.00,1908382.81,0.00,'2021-03-30 05:37:48'),(624490,'5','175',403,'Sale Id shift 187635',0.00,2010195.87,163.00,2010195.87,0.00,'2021-03-31 04:08:24'),(628078,'5','175',403,'Sale Id shift 187828',0.00,1318994.37,163.00,1318994.37,0.00,'2021-04-01 04:38:13'),(632219,'5','175',403,'Sale Id shift 188009',0.00,2293556.70,163.00,2293556.70,0.00,'2021-04-02 05:18:14'),(636257,'5','175',403,'Sale Id shift 188265',0.00,2342963.63,163.00,2342963.63,0.00,'2021-04-02 22:39:16'),(639385,'5','175',403,'Sale Id shift 188438',0.00,2226032.32,163.00,2226032.32,0.00,'2021-04-04 05:25:38'),(642759,'5','175',403,'Sale Id shift 188621',0.00,543226.84,163.00,543226.84,0.00,'2021-04-05 05:19:49'),(656280,'5','175',404,'Sale Id shift 189509',0.00,428144.60,265.00,428144.60,0.00,'2021-04-09 04:49:45'),(659815,'5','175',404,'Sale Id shift 189615',0.00,438066.20,265.00,438066.20,0.00,'2021-04-10 05:47:06'),(663752,'5','175',403,'Sale Id shift 189875',0.00,349895.80,165.00,354189.00,4293.20,'2021-04-11 05:33:28'),(663753,'5','175',404,'Sale Id shift 189875',0.00,223387.05,265.00,223387.05,0.00,'2021-04-11 05:33:28'),(667694,'5','175',403,'Sale Id shift 190074',0.00,2130663.15,165.00,2130663.15,0.00,'2021-04-12 05:12:43'),(667695,'5','175',404,'Sale Id shift 190074',0.00,390074.70,265.00,390074.70,0.00,'2021-04-12 05:12:43'),(672234,'5','175',403,'Sale Id shift 190232',0.00,1838515.80,165.00,1838515.80,0.00,'2021-04-13 05:45:14'),(672235,'5','175',404,'Sale Id shift 190232',0.00,533916.70,265.00,533916.70,0.00,'2021-04-13 05:45:14'),(677200,'5','175',403,'Sale Id shift 190438',0.00,1478642.55,165.00,1478642.55,0.00,'2021-04-14 02:44:15'),(677201,'5','175',404,'Sale Id shift 190438',0.00,417147.10,265.00,417147.10,0.00,'2021-04-14 02:44:15'),(681243,'5','175',403,'Sale Id shift 190704',0.00,772391.40,165.00,772391.40,0.00,'2021-04-15 06:49:55'),(681244,'5','175',404,'Sale Id shift 190704',0.00,356218.30,265.00,356218.30,0.00,'2021-04-15 06:49:55'),(684680,'5','175',404,'Sale Id shift 190921',0.00,288786.40,265.00,288786.40,0.00,'2021-04-16 05:07:04'),(687790,'5','175',403,'Sale Id shift 191102',0.00,593206.35,165.00,593206.35,0.00,'2021-04-17 05:15:57'),(687791,'5','175',404,'Sale Id shift 191102',0.00,336666.60,265.00,336666.60,0.00,'2021-04-17 05:15:57'),(691090,'5','175',403,'Sale Id shift 191280',0.00,1935450.00,165.00,1935450.00,0.00,'2021-04-18 04:43:41'),(691091,'5','175',404,'Sale Id shift 191280',0.00,317422.30,265.00,317422.30,0.00,'2021-04-18 04:43:41'),(694539,'5','175',403,'Sale Id shift 191505',0.00,1691363.85,165.00,1691363.85,0.00,'2021-04-19 03:46:07'),(694540,'5','175',404,'Sale Id shift 191505',0.00,247351.00,265.00,247351.00,0.00,'2021-04-19 03:46:07'),(698121,'5','175',403,'Sale Id shift 191709',0.00,1684423.95,165.00,1684423.95,0.00,'2021-04-20 05:15:23'),(700917,'5','175',403,'Sale Id shift 191947',0.00,757528.20,165.00,757528.20,0.00,'2021-04-21 05:34:42'),(719000,'5','175',404,'Sale Id shift 193209',0.00,550675.30,265.00,550675.30,0.00,'2021-04-27 05:29:19'),(721908,'5','175',404,'Sale Id shift 193408',0.00,262249.30,265.00,262249.30,0.00,'2021-04-28 05:32:30'),(724627,'5','175',404,'Sale Id shift 193640',0.00,287845.65,265.00,287845.65,0.00,'2021-04-29 05:13:04'),(729057,'5','175',404,'Sale Id shift 193880',0.00,332299.40,265.00,332299.40,0.00,'2021-04-30 12:56:15'),(730375,'5','175',404,'Sale Id shift 194188',0.00,357654.60,265.00,357654.60,0.00,'2021-05-01 06:15:59'),(733033,'5','175',404,'Sale Id shift 194381',0.00,587950.20,265.00,587950.20,0.00,'2021-05-01 21:10:20'),(736745,'5','175',404,'Sale Id shift 194492',0.00,448107.05,265.00,448107.05,0.00,'2021-05-02 23:40:40'),(740527,'5','175',403,'Sale Id shift 194708',0.00,1099041.90,165.00,1099041.90,0.00,'2021-05-04 05:30:30'),(740528,'5','175',404,'Sale Id shift 194708',0.00,227454.80,265.00,227454.80,0.00,'2021-05-04 05:30:30'),(742611,'5','175',403,'Sale Id shift 194918',0.00,1157102.10,165.00,1157102.10,0.00,'2021-05-05 05:26:44'),(742612,'5','175',404,'Sale Id shift 194918',0.00,302743.95,265.00,302743.95,0.00,'2021-05-05 05:26:44'),(745631,'5','175',403,'Sale Id shift 195287',0.00,1101408.00,165.00,1101408.00,0.00,'2021-05-06 04:53:19'),(745632,'5','175',404,'Sale Id shift 195287',0.00,471270.70,265.00,471270.70,0.00,'2021-05-06 04:53:19'),(748701,'5','175',403,'Sale Id shift 195437',0.00,1466967.15,165.00,1466967.15,0.00,'2021-05-06 21:54:47'),(748702,'5','175',404,'Sale Id shift 195437',0.00,215259.50,265.00,215259.50,0.00,'2021-05-06 21:54:47'),(752192,'5','175',403,'Sale Id shift 195543',0.00,1177119.90,165.00,1177119.90,0.00,'2021-05-08 06:10:15'),(752193,'5','175',404,'Sale Id shift 195543',0.00,260545.35,265.00,260545.35,0.00,'2021-05-08 06:10:15'),(755803,'5','175',403,'Sale Id shift 195972',0.00,612871.05,165.00,612871.05,0.00,'2021-05-09 05:25:53'),(755804,'5','175',404,'Sale Id shift 195972',0.00,201198.60,265.00,201198.60,0.00,'2021-05-09 05:25:53'),(759393,'5','175',404,'Sale Id shift 196071',0.00,211106.95,265.00,211106.95,0.00,'2021-05-10 05:41:52'),(762623,'5','175',404,'Sale Id shift 196336',0.00,116170.70,265.00,116170.70,0.00,'2021-05-11 04:16:03'),(767132,'5','175',404,'Sale Id shift 196540',0.00,104404.70,265.00,104404.70,0.00,'2021-05-12 09:38:53'),(769554,'5','175',404,'Sale Id shift 196858',0.00,183022.25,265.00,183022.25,0.00,'2021-05-13 05:56:02'),(771167,'5','175',404,'Sale Id shift 196893',0.00,286046.30,265.00,286046.30,0.00,'2021-05-14 06:14:49'),(774964,'5','175',404,'Sale Id shift 197206',0.00,189793.00,265.00,189793.00,0.00,'2021-05-16 17:18:42'),(776714,'5','175',403,'Sale Id shift 197508',0.00,914761.65,165.00,914761.65,0.00,'2021-05-17 15:27:28'),(776715,'5','175',404,'Sale Id shift 197508',0.00,507501.50,265.00,507501.50,0.00,'2021-05-17 15:27:28'),(776745,'5','175',403,'Sale Id shift 197760',0.00,891349.80,165.00,891349.80,0.00,'2021-05-17 15:33:19'),(776746,'5','175',404,'Sale Id shift 197760',0.00,188581.95,265.00,188581.95,0.00,'2021-05-17 15:33:19'),(777345,'5','175',403,'Sale Id shift 197766',0.00,1036536.60,165.00,1036536.60,0.00,'2021-05-18 06:19:11'),(777346,'5','175',404,'Sale Id shift 197766',0.00,187055.55,265.00,187055.55,0.00,'2021-05-18 06:19:11'),(780912,'5','175',403,'Sale Id shift 198139',0.00,943555.80,165.00,943555.80,0.00,'2021-05-19 08:56:28'),(780913,'5','175',404,'Sale Id shift 198139',0.00,303104.70,270.00,303104.70,0.00,'2021-05-19 08:56:28'),(783261,'5','175',403,'Sale Id shift 198260',0.00,1146241.80,165.00,1146241.80,0.00,'2021-05-20 04:49:59'),(783262,'5','175',404,'Sale Id shift 198260',0.00,340459.20,270.00,340459.20,0.00,'2021-05-20 04:49:59'),(786495,'5','175',403,'Sale Id shift 198387',0.00,1137262.50,165.00,1137262.50,0.00,'2021-05-21 05:06:19'),(786496,'5','175',404,'Sale Id shift 198387',0.00,252158.40,270.00,252158.40,0.00,'2021-05-21 05:06:19'),(789581,'5','175',403,'Sale Id shift 198645',0.00,1074732.45,165.00,1074732.45,0.00,'2021-05-22 05:25:14'),(789582,'5','175',404,'Sale Id shift 198645',0.00,267302.70,270.00,267302.70,0.00,'2021-05-22 05:25:14'),(794919,'5','175',403,'Sale Id shift 199046',0.00,1101031.80,165.00,1101031.80,0.00,'2021-05-23 10:17:04'),(794920,'5','175',404,'Sale Id shift 199046',0.00,352468.80,270.00,352468.80,0.00,'2021-05-23 10:17:04'),(797174,'5','175',403,'Sale Id shift 199056',0.00,1080901.80,165.00,1080901.80,0.00,'2021-05-24 04:41:42'),(800361,'5','175',403,'Sale Id shift 199211',0.00,1132866.90,165.00,1132866.90,0.00,'2021-05-25 05:01:45'),(803690,'5','175',403,'Sale Id shift 199426',0.00,1335368.10,165.00,1335368.10,0.00,'2021-05-26 04:48:21'),(807062,'5','175',403,'Sale Id shift 199675',0.00,1257092.10,165.00,1257092.10,0.00,'2021-05-27 05:09:55'),(810275,'5','175',403,'Sale Id shift 199893',0.00,1272689.55,165.00,1272689.55,0.00,'2021-05-28 05:36:12'),(813402,'5','175',403,'Sale Id shift 200106',0.00,1144494.45,165.00,1144494.45,0.00,'2021-05-29 06:30:01'),(817064,'5','175',403,'Sale Id shift 200315',0.00,1221516.45,165.00,1221516.45,0.00,'2021-05-30 04:38:20'),(817065,'5','175',404,'Sale Id shift 200315',0.00,169614.00,270.00,169614.00,0.00,'2021-05-30 04:38:20'),(820732,'5','175',403,'Sale Id shift 200506',0.00,1200071.40,165.00,1200071.40,0.00,'2021-05-31 05:16:11'),(820733,'5','175',404,'Sale Id shift 200506',0.00,244209.60,270.00,244209.60,0.00,'2021-05-31 05:16:11'),(824079,'5','175',403,'Sale Id shift 200707',0.00,1463782.65,165.00,1463782.65,0.00,'2021-06-01 05:12:37'),(824080,'5','175',404,'Sale Id shift 200707',0.00,741760.20,270.00,741760.20,0.00,'2021-06-01 05:12:37'),(828421,'5','175',403,'Sale Id shift 200919',0.00,1601729.25,165.00,1601729.25,0.00,'2021-06-02 05:24:14'),(828422,'5','175',404,'Sale Id shift 200919',0.00,384582.60,270.00,384582.60,0.00,'2021-06-02 05:24:14'),(832617,'5','175',403,'Sale Id shift 201122',0.00,1524015.90,165.00,1524015.90,0.00,'2021-06-03 05:18:55'),(832618,'5','175',404,'Sale Id shift 201122',0.00,968643.90,270.00,968643.90,0.00,'2021-06-03 05:18:55'),(836150,'5','175',403,'Sale Id shift 201321',0.00,1358593.50,165.00,1358593.50,0.00,'2021-06-03 22:25:34'),(836151,'5','175',404,'Sale Id shift 201321',0.00,855241.20,270.00,855241.20,0.00,'2021-06-03 22:25:34'),(839909,'5','175',403,'Sale Id shift 201511',0.00,1131195.45,165.00,1131195.45,0.00,'2021-06-05 05:40:07'),(839910,'5','175',404,'Sale Id shift 201511',0.00,332702.10,270.00,332702.10,0.00,'2021-06-05 05:40:07'),(844264,'5','175',403,'Sale Id shift 201760',0.00,1029501.00,165.00,1029501.00,0.00,'2021-06-05 22:32:33'),(844265,'5','175',404,'Sale Id shift 201760',0.00,354372.30,275.00,360934.75,6562.45,'2021-06-05 22:32:33'),(847952,'5','175',403,'Sale Id shift 202030',0.00,960920.40,165.00,960920.40,0.00,'2021-06-07 05:12:56'),(847953,'5','175',404,'Sale Id shift 202030',0.00,501271.20,275.00,510554.00,9282.80,'2021-06-07 05:12:56'),(852043,'5','175',403,'Sale Id shift 202240',0.00,806843.40,165.00,806843.40,0.00,'2021-06-08 05:21:46'),(852044,'5','175',404,'Sale Id shift 202240',0.00,695125.80,275.00,707998.50,12872.70,'2021-06-08 05:21:46'),(855680,'5','175',403,'Sale Id shift 202456',0.00,847756.80,165.00,847756.80,0.00,'2021-06-09 01:06:28'),(855681,'5','175',404,'Sale Id shift 202456',0.00,382967.75,275.00,382967.75,0.00,'2021-06-09 01:06:28'),(859616,'5','175',403,'Sale Id shift 202655',0.00,787941.00,165.00,787941.00,0.00,'2021-06-10 05:43:30'),(859617,'5','175',404,'Sale Id shift 202655',0.00,548886.25,275.00,548886.25,0.00,'2021-06-10 05:43:30'),(863317,'5','175',403,'Sale Id shift 202857',0.00,779695.95,165.00,779695.95,0.00,'2021-06-11 05:48:37'),(863318,'5','175',404,'Sale Id shift 202857',0.00,354156.00,275.00,354156.00,0.00,'2021-06-11 05:48:37'),(867219,'5','175',403,'Sale Id shift 203124',0.00,788470.65,165.00,788470.65,0.00,'2021-06-12 04:43:35'),(867220,'5','175',404,'Sale Id shift 203124',0.00,51480.00,275.00,51480.00,0.00,'2021-06-12 04:43:35'),(870644,'5','175',403,'Sale Id shift 203322',0.00,716278.20,165.00,716278.20,0.00,'2021-06-13 05:03:22'),(874920,'5','175',403,'Sale Id shift 203528',0.00,688520.25,165.00,688520.25,0.00,'2021-06-14 06:14:12'),(878665,'5','175',403,'Sale Id shift 203737',0.00,793191.30,165.00,793191.30,0.00,'2021-06-15 05:02:47'),(881840,'5','175',403,'Sale Id shift 203973',0.00,824080.95,165.00,824080.95,0.00,'2021-06-16 06:10:54'),(885666,'5','175',403,'Sale Id shift 204191',0.00,747088.65,165.00,747088.65,0.00,'2021-06-17 05:59:51'),(889447,'5','175',403,'Sale Id shift 204404',0.00,672114.30,165.00,672114.30,0.00,'2021-06-18 05:42:00'),(893101,'5','175',403,'Sale Id shift 204626',0.00,678216.00,165.00,678216.00,0.00,'2021-06-19 05:54:44'),(896705,'5','175',403,'Sale Id shift 204842',0.00,685400.10,165.00,685400.10,0.00,'2021-06-19 21:55:57'),(900298,'5','175',403,'Sale Id shift 205055',0.00,667623.00,165.00,667623.00,0.00,'2021-06-21 05:26:02'),(903478,'5','175',403,'Sale Id shift 205237',0.00,746384.10,165.00,746384.10,0.00,'2021-06-22 05:12:58'),(906586,'5','175',403,'Sale Id shift 205479',0.00,751570.05,165.00,751570.05,0.00,'2021-06-23 05:31:01'),(910150,'5','175',403,'Sale Id shift 205719',0.00,718164.15,165.00,718164.15,0.00,'2021-06-24 05:42:41'),(913644,'5','175',403,'Sale Id shift 206014',0.00,736759.65,165.00,736759.65,0.00,'2021-06-25 05:13:55'),(917079,'5','175',403,'Sale Id shift 206219',0.00,672444.30,165.00,672444.30,0.00,'2021-06-26 06:57:14'),(920529,'5','175',403,'Sale Id shift 206375',0.00,558998.55,165.00,558998.55,0.00,'2021-06-27 05:42:25'),(924355,'5','175',403,'Sale Id shift 206772',0.00,601118.10,165.00,601118.10,0.00,'2021-06-28 05:35:41'),(928126,'5','175',403,'Sale Id shift 206819',0.00,642178.35,165.00,642178.35,0.00,'2021-06-29 05:45:30'),(932004,'5','175',403,'Sale Id shift 207028',0.00,591434.25,165.00,591434.25,0.00,'2021-06-30 05:32:55'),(936470,'5','175',403,'Sale Id shift 207270',0.00,755183.55,165.00,755183.55,0.00,'2021-07-01 05:38:39'),(940420,'5','175',403,'Sale Id shift 207490',0.00,765839.25,165.00,765839.25,0.00,'2021-07-02 05:35:09'),(944148,'5','175',403,'Sale Id shift 207708',0.00,755597.70,165.00,755597.70,0.00,'2021-07-03 07:01:39'),(948111,'5','175',403,'Sale Id shift 207926',0.00,784132.80,165.00,784132.80,0.00,'2021-07-04 05:41:19'),(952252,'5','175',403,'Sale Id shift 208118',0.00,655404.75,165.00,655404.75,0.00,'2021-07-05 05:18:06'),(956359,'5','175',403,'Sale Id shift 208337',0.00,731108.40,165.00,731108.40,0.00,'2021-07-06 07:02:11'),(960351,'5','175',403,'Sale Id shift 208546',0.00,643559.40,165.00,643559.40,0.00,'2021-07-07 05:54:59'),(964458,'5','175',403,'Sale Id shift 208764',0.00,653000.70,165.00,653000.70,0.00,'2021-07-08 04:55:23'),(968564,'5','175',403,'Sale Id shift 208984',0.00,661925.55,165.00,661925.55,0.00,'2021-07-09 06:16:36'),(972380,'5','175',403,'Sale Id shift 209255',0.00,496511.40,165.00,496511.40,0.00,'2021-07-10 06:32:30'),(976925,'5','175',403,'Sale Id shift 209455',0.00,647171.25,165.00,647171.25,0.00,'2021-07-11 05:43:48'),(981332,'5','175',403,'Sale Id shift 209656',0.00,608249.40,165.00,608249.40,0.00,'2021-07-12 07:27:52'),(984247,'5','175',403,'Sale Id shift 209891',0.00,571277.85,165.00,571277.85,0.00,'2021-07-13 04:25:08'),(988030,'5','175',403,'Sale Id shift 210107',0.00,602906.70,165.00,602906.70,0.00,'2021-07-14 06:20:24'),(991438,'5','175',403,'Sale Id shift 210325',0.00,651383.70,165.00,651383.70,0.00,'2021-07-15 06:07:15'),(994558,'5','175',403,'Sale Id shift 210524',0.00,594047.85,165.00,594047.85,0.00,'2021-07-16 05:36:55'),(998044,'5','175',403,'Sale Id shift 210732',0.00,607685.10,165.00,607685.10,0.00,'2021-07-17 06:03:16'),(1002493,'5','175',403,'Sale Id shift 210954',0.00,674587.65,165.00,674587.65,0.00,'2021-07-18 06:07:43'),(1006341,'5','175',403,'Sale Id shift 211193',0.00,563704.35,165.00,563704.35,0.00,'2021-07-19 06:32:47'),(1010257,'5','175',403,'Sale Id shift 211411',0.00,906109.05,165.00,906109.05,0.00,'2021-07-20 05:43:23'),(1012618,'5','175',403,'Sale Id shift 211664',0.00,762997.95,165.00,762997.95,0.00,'2021-07-21 06:20:13'),(1016090,'5','175',403,'Sale Id shift 211782',0.00,656294.10,165.00,656294.10,0.00,'2021-07-22 06:22:44'),(1019021,'5','175',403,'Sale Id shift 212004',0.00,608713.05,165.00,608713.05,0.00,'2021-07-23 04:34:16'),(1022301,'5','175',403,'Sale Id shift 212237',0.00,674619.00,165.00,674619.00,0.00,'2021-07-24 04:41:05'),(1025846,'5','175',403,'Sale Id shift 212485',0.00,199277.10,165.00,199277.10,0.00,'2021-07-25 05:23:42'),(1028949,'5','175',403,'Sale Id shift 212661',0.00,540599.40,165.00,540599.40,0.00,'2021-07-26 05:41:17'),(1032118,'5','175',403,'Sale Id shift 212874',0.00,533251.95,165.00,533251.95,0.00,'2021-07-27 05:51:43'),(1036036,'5','175',403,'Sale Id shift 213129',0.00,530841.30,165.00,530841.30,0.00,'2021-07-28 01:53:49'),(1039350,'5','175',403,'Sale Id shift 213378',0.00,547125.15,165.00,547125.15,0.00,'2021-07-29 05:39:22'),(1043443,'5','175',403,'Sale Id shift 213741',0.00,575209.80,165.00,575209.80,0.00,'2021-07-30 07:06:11'),(1047858,'5','175',403,'Sale Id shift 213911',0.00,543899.40,165.00,543899.40,0.00,'2021-07-31 08:47:23'),(1051408,'5','175',403,'Sale Id shift 214262',0.00,482182.80,165.00,482182.80,0.00,'2021-08-01 05:17:22'),(1055267,'5','175',403,'Sale Id shift 214454',0.00,506913.00,165.00,506913.00,0.00,'2021-08-02 07:05:53'),(1055268,'5','175',404,'Sale Id shift 214454',0.00,35040.70,295.00,35644.85,604.15,'2021-08-02 07:05:53'),(1059281,'5','175',403,'Sale Id shift 214557',0.00,540587.85,165.00,540587.85,0.00,'2021-08-03 04:27:40'),(1059282,'5','175',404,'Sale Id shift 214557',0.00,35299.70,295.00,35299.70,0.00,'2021-08-03 04:27:40'),(1063777,'5','175',403,'Sale Id shift 214825',0.00,315004.80,165.00,315004.80,0.00,'2021-08-04 05:52:06'),(1063778,'5','175',404,'Sale Id shift 214825',0.00,69909.10,295.00,69909.10,0.00,'2021-08-04 05:52:06'),(1067348,'5','175',403,'Sale Id shift 215195',0.00,213673.35,165.00,213673.35,0.00,'2021-08-05 05:26:33'),(1070557,'5','175',404,'Sale Id shift 215325',0.00,26998.40,295.00,26998.40,0.00,'2021-08-06 01:14:12'),(1074753,'5','175',403,'Sale Id shift 215526',0.00,1042829.70,165.00,1042829.70,0.00,'2021-08-07 05:38:04'),(1074754,'5','175',404,'Sale Id shift 215526',0.00,101279.40,295.00,101279.40,0.00,'2021-08-07 05:38:04'),(1078807,'5','175',403,'Sale Id shift 215771',0.00,506673.75,165.00,506673.75,0.00,'2021-08-08 03:35:47'),(1078808,'5','175',404,'Sale Id shift 215771',0.00,47913.90,295.00,47913.90,0.00,'2021-08-08 03:35:47'),(1082648,'5','175',403,'Sale Id shift 215986',0.00,331315.05,165.00,331315.05,0.00,'2021-08-09 06:20:01'),(1082649,'5','175',404,'Sale Id shift 215986',0.00,165223.60,295.00,165223.60,0.00,'2021-08-09 06:20:01'),(1086645,'5','175',403,'Sale Id shift 216152',0.00,698230.50,165.00,698230.50,0.00,'2021-08-10 05:33:00'),(1086646,'5','175',404,'Sale Id shift 216152',0.00,62312.85,295.00,62312.85,0.00,'2021-08-10 05:33:00'),(1090452,'5','175',403,'Sale Id shift 216332',0.00,455180.55,165.00,455180.55,0.00,'2021-08-11 05:47:51'),(1090453,'5','175',404,'Sale Id shift 216332',0.00,50769.50,295.00,50769.50,0.00,'2021-08-11 05:47:51'),(1093625,'5','175',403,'Sale Id shift 216570',0.00,440033.55,165.00,440033.55,0.00,'2021-08-12 05:34:17'),(1093626,'5','175',404,'Sale Id shift 216570',0.00,113580.90,295.00,113580.90,0.00,'2021-08-12 05:34:17'),(1097016,'5','175',403,'Sale Id shift 216809',0.00,450054.00,165.00,450054.00,0.00,'2021-08-13 05:40:10'),(1097017,'5','175',404,'Sale Id shift 216809',0.00,24700.35,295.00,24700.35,0.00,'2021-08-13 05:40:10'),(1101134,'5','175',403,'Sale Id shift 217046',0.00,439758.00,165.00,439758.00,0.00,'2021-08-14 05:39:52'),(1101135,'5','175',404,'Sale Id shift 217046',0.00,91756.80,295.00,91756.80,0.00,'2021-08-14 05:39:52'),(1109695,'5','175',403,'Sale Id shift 217280',0.00,648580.35,165.00,648580.35,0.00,'2021-08-15 19:00:01'),(1109696,'5','175',404,'Sale Id shift 217280',0.00,67324.90,295.00,67324.90,0.00,'2021-08-15 19:00:01'),(1109816,'5','175',403,'Sale Id shift 217680',0.00,506492.25,165.00,506492.25,0.00,'2021-08-16 06:08:10'),(1109817,'5','175',404,'Sale Id shift 217680',0.00,410457.10,295.00,410457.10,0.00,'2021-08-16 06:08:10'),(1113681,'5','175',403,'Sale Id shift 217713',0.00,515319.75,165.00,515319.75,0.00,'2021-08-17 05:44:24'),(1113682,'5','175',404,'Sale Id shift 217713',0.00,103810.50,295.00,103810.50,0.00,'2021-08-17 05:44:24'),(1117520,'5','175',403,'Sale Id shift 218016',0.00,527244.30,165.00,527244.30,0.00,'2021-08-18 00:53:21'),(1117521,'5','175',404,'Sale Id shift 218016',0.00,64991.45,295.00,64991.45,0.00,'2021-08-18 00:53:21'),(1121071,'5','175',403,'Sale Id shift 218223',0.00,509173.50,165.00,509173.50,0.00,'2021-08-19 05:48:31'),(1121072,'5','175',404,'Sale Id shift 218223',0.00,118492.65,295.00,118492.65,0.00,'2021-08-19 05:48:31'),(1125185,'5','175',403,'Sale Id shift 218475',0.00,488431.35,165.00,488431.35,0.00,'2021-08-20 05:46:49'),(1125186,'5','175',404,'Sale Id shift 218475',0.00,63318.80,295.00,63318.80,0.00,'2021-08-20 05:46:49'),(1128884,'5','175',403,'Sale Id shift 218732',0.00,620835.60,165.00,620835.60,0.00,'2021-08-21 06:16:16'),(1128885,'5','175',404,'Sale Id shift 218732',0.00,65138.95,295.00,65138.95,0.00,'2021-08-21 06:16:16'),(1133183,'5','175',403,'Sale Id shift 219002',0.00,665649.60,165.00,665649.60,0.00,'2021-08-22 06:00:12'),(1133184,'5','175',404,'Sale Id shift 219002',0.00,80552.70,295.00,80552.70,0.00,'2021-08-22 06:00:12'),(1137286,'5','175',403,'Sale Id shift 219158',0.00,489906.45,165.00,489906.45,0.00,'2021-08-23 05:46:58'),(1137287,'5','175',404,'Sale Id shift 219158',0.00,95423.65,295.00,95423.65,0.00,'2021-08-23 05:46:58'),(1141251,'5','175',403,'Sale Id shift 219329',0.00,468281.55,165.00,468281.55,0.00,'2021-08-24 05:37:15'),(1141252,'5','175',404,'Sale Id shift 219329',0.00,18599.75,295.00,18599.75,0.00,'2021-08-24 05:37:15'),(1145026,'5','175',403,'Sale Id shift 219633',0.00,537893.40,165.00,537893.40,0.00,'2021-08-25 05:39:49'),(1145027,'5','175',404,'Sale Id shift 219633',0.00,20139.65,295.00,20139.65,0.00,'2021-08-25 05:39:49'),(1148821,'5','175',403,'Sale Id shift 219812',0.00,473571.45,165.00,473571.45,0.00,'2021-08-26 05:03:11'),(1148822,'5','175',404,'Sale Id shift 219812',0.00,94807.10,295.00,94807.10,0.00,'2021-08-26 05:03:11'),(1152503,'5','175',403,'Sale Id shift 220086',0.00,201918.75,165.00,201918.75,0.00,'2021-08-27 06:15:26'),(1152504,'5','175',404,'Sale Id shift 220086',0.00,52636.85,295.00,52636.85,0.00,'2021-08-27 06:15:26'),(1155885,'5','175',404,'Sale Id shift 220266',0.00,27635.60,295.00,27635.60,0.00,'2021-08-28 05:21:56'),(1159603,'5','175',404,'Sale Id shift 220476',0.00,51689.90,295.00,51689.90,0.00,'2021-08-29 05:51:54'),(1164046,'5','175',403,'Sale Id shift 220726',0.00,204421.80,165.00,204421.80,0.00,'2021-08-30 05:35:12'),(1164047,'5','175',404,'Sale Id shift 220726',0.00,48557.00,295.00,48557.00,0.00,'2021-08-30 05:35:12'),(1168193,'5','175',403,'Sale Id shift 220905',0.00,469921.65,165.00,469921.65,0.00,'2021-08-31 05:59:12'),(1168194,'5','175',404,'Sale Id shift 220905',0.00,69148.00,295.00,69148.00,0.00,'2021-08-31 05:59:12'),(1172077,'5','175',403,'Sale Id shift 221145',0.00,489630.90,165.00,489630.90,0.00,'2021-09-01 05:56:36'),(1172078,'5','175',404,'Sale Id shift 221145',0.00,126029.90,295.00,126029.90,0.00,'2021-09-01 05:56:36'),(1175831,'5','175',403,'Sale Id shift 221401',0.00,504438.00,165.00,504438.00,0.00,'2021-09-02 05:45:04'),(1175832,'5','175',404,'Sale Id shift 221401',0.00,62787.80,295.00,62787.80,0.00,'2021-09-02 05:45:04'),(1180015,'5','175',403,'Sale Id shift 221617',0.00,534129.75,165.00,534129.75,0.00,'2021-09-03 05:41:56'),(1180016,'5','175',404,'Sale Id shift 221617',0.00,112294.70,295.00,112294.70,0.00,'2021-09-03 05:41:56'),(1184328,'5','175',403,'Sale Id shift 221836',0.00,538609.50,165.00,538609.50,0.00,'2021-09-04 05:58:26'),(1184329,'5','175',404,'Sale Id shift 221836',0.00,113893.60,295.00,113893.60,0.00,'2021-09-04 05:58:26'),(1188323,'5','175',403,'Sale Id shift 222062',0.00,588982.35,165.00,588982.35,0.00,'2021-09-05 05:55:36'),(1188324,'5','175',404,'Sale Id shift 222062',0.00,46241.25,295.00,46241.25,0.00,'2021-09-05 05:55:36'),(1192184,'5','175',403,'Sale Id shift 222265',0.00,523992.15,165.00,523992.15,0.00,'2021-09-06 06:02:56'),(1192185,'5','175',404,'Sale Id shift 222265',0.00,57112.00,295.00,57112.00,0.00,'2021-09-06 06:02:56'),(1195215,'5','175',403,'Sale Id shift 222497',0.00,511683.15,165.00,511683.15,0.00,'2021-09-07 06:37:35'),(1195216,'5','175',404,'Sale Id shift 222497',0.00,115055.90,295.00,115055.90,0.00,'2021-09-07 06:37:35'),(1196584,'5','175',403,'Sale Id shift 222738',0.00,367412.10,165.00,367412.10,0.00,'2021-09-08 06:06:40'),(1196585,'5','175',404,'Sale Id shift 222738',0.00,55132.55,295.00,55132.55,0.00,'2021-09-08 06:06:40'),(1198460,'5','175',403,'Sale Id shift 222957',0.00,205486.05,165.00,205486.05,0.00,'2021-09-09 05:14:31'),(1198461,'5','175',404,'Sale Id shift 222957',0.00,48055.50,295.00,48055.50,0.00,'2021-09-09 05:14:31'),(1201830,'5','175',404,'Sale Id shift 223219',0.00,38987.20,295.00,38987.20,0.00,'2021-09-10 05:55:34'),(1205312,'5','175',404,'Sale Id shift 223446',0.00,37597.75,295.00,37597.75,0.00,'2021-09-11 05:58:38'),(1208981,'5','175',404,'Sale Id shift 223641',0.00,58174.00,295.00,58174.00,0.00,'2021-09-12 05:59:44'),(1212484,'5','175',404,'Sale Id shift 224045',0.00,61395.40,295.00,61395.40,0.00,'2021-09-13 05:43:46'),(1216251,'5','175',404,'Sale Id shift 224118',0.00,35447.20,295.00,35447.20,0.00,'2021-09-14 06:28:08'),(1219993,'5','175',404,'Sale Id shift 224317',0.00,101185.00,295.00,101185.00,0.00,'2021-09-15 06:17:46'),(1223448,'5','175',404,'Sale Id shift 224530',0.00,75095.20,295.00,75095.20,0.00,'2021-09-16 06:05:40'),(1227248,'5','175',404,'Sale Id shift 224776',0.00,99648.05,295.00,99648.05,0.00,'2021-09-17 05:45:18'),(1230460,'5','175',404,'Sale Id shift 225043',0.00,60829.00,295.00,60829.00,0.00,'2021-09-18 05:47:57'),(1233644,'5','175',404,'Sale Id shift 225262',0.00,61799.55,295.00,61799.55,0.00,'2021-09-19 05:57:44'),(1236940,'5','175',404,'Sale Id shift 225502',0.00,25547.00,295.00,25547.00,0.00,'2021-09-20 05:38:06'),(1240114,'5','175',404,'Sale Id shift 225707',0.00,96984.20,295.00,96984.20,0.00,'2021-09-21 05:32:47'),(1243509,'5','175',404,'Sale Id shift 226008',0.00,26809.60,295.00,26809.60,0.00,'2021-09-22 08:35:01'),(1246168,'5','175',404,'Sale Id shift 226301',0.00,55545.55,295.00,55545.55,0.00,'2021-09-23 05:38:38'),(1249716,'5','175',403,'Sale Id shift 226490',0.00,310464.00,165.00,310464.00,0.00,'2021-09-24 06:07:29'),(1249717,'5','175',404,'Sale Id shift 226490',0.00,67525.50,295.00,67525.50,0.00,'2021-09-24 06:07:29'),(1253197,'5','175',403,'Sale Id shift 226809',0.00,339700.35,165.00,339700.35,0.00,'2021-09-25 05:43:40'),(1253198,'5','175',404,'Sale Id shift 226809',0.00,45524.40,295.00,45524.40,0.00,'2021-09-25 05:43:40'),(1256650,'5','175',403,'Sale Id shift 226999',0.00,302806.35,165.00,302806.35,0.00,'2021-09-26 05:46:24'),(1256651,'5','175',404,'Sale Id shift 226999',0.00,44140.85,295.00,44140.85,0.00,'2021-09-26 05:46:24'),(1259684,'5','175',403,'Sale Id shift 227204',0.00,370571.85,165.00,370571.85,0.00,'2021-09-27 05:37:45'),(1259685,'5','175',404,'Sale Id shift 227204',0.00,62504.60,295.00,62504.60,0.00,'2021-09-27 05:37:45'),(1262805,'5','175',403,'Sale Id shift 227399',0.00,475011.90,165.00,475011.90,0.00,'2021-09-28 05:48:20'),(1262806,'5','175',404,'Sale Id shift 227399',0.00,41600.90,295.00,41600.90,0.00,'2021-09-28 05:48:20'),(1265706,'5','175',403,'Sale Id shift 227627',0.00,459685.05,165.00,459685.05,0.00,'2021-09-29 05:52:13'),(1265707,'5','175',404,'Sale Id shift 227627',0.00,193219.10,300.00,196494.00,3274.90,'2021-09-29 05:52:13'),(1286523,'5','175',403,'Sale Id shift 227883',0.00,546583.95,165.00,546583.95,0.00,'2021-10-05 11:54:25'),(1286524,'5','175',404,'Sale Id shift 227883',0.00,75517.05,300.00,76797.00,1279.95,'2021-10-05 11:54:25'),(1286714,'5','175',403,'Sale Id shift 229277',0.00,516902.10,165.00,516902.10,0.00,'2021-10-05 12:28:00'),(1286715,'5','175',404,'Sale Id shift 229277',0.00,122330.60,300.00,124404.00,2073.40,'2021-10-05 12:28:00'),(1308812,'5','175',403,'Sale Id shift 230755',0.00,506921.25,165.00,506921.25,0.00,'2021-10-11 19:53:47'),(1308813,'5','175',404,'Sale Id shift 230755',0.00,439107.00,300.00,439107.00,0.00,'2021-10-11 19:53:47'),(1308814,'5','175',403,'Sale Id shift 230757',0.00,467337.75,165.00,467337.75,0.00,'2021-10-11 19:58:17'),(1308815,'5','175',404,'Sale Id shift 230757',0.00,78402.00,300.00,78402.00,0.00,'2021-10-11 19:58:17'),(1308820,'5','175',403,'Sale Id shift 230759',0.00,439670.55,165.00,439670.55,0.00,'2021-10-11 20:06:11'),(1308821,'5','175',404,'Sale Id shift 230759',0.00,60870.00,300.00,60870.00,0.00,'2021-10-11 20:06:11'),(1308841,'5','175',403,'Sale Id shift 230765',0.00,437152.65,165.00,437152.65,0.00,'2021-10-12 04:40:12'),(1308842,'5','175',404,'Sale Id shift 230765',0.00,38259.00,300.00,38259.00,0.00,'2021-10-12 04:40:12'),(1309843,'5','175',403,'Sale Id shift 230837',0.00,518073.60,165.00,518073.60,0.00,'2021-10-12 09:41:46'),(1309844,'5','175',404,'Sale Id shift 230837',0.00,57927.00,300.00,57927.00,0.00,'2021-10-12 09:41:46'),(1309870,'5','175',403,'Sale Id shift 230840',0.00,488206.95,165.00,488206.95,0.00,'2021-10-12 09:53:59'),(1309871,'5','175',404,'Sale Id shift 230840',0.00,153366.00,310.00,158478.20,5112.20,'2021-10-12 09:53:59'),(1309879,'5','175',403,'Sale Id shift 230846',0.00,578138.55,165.00,578138.55,0.00,'2021-10-12 09:57:18'),(1309880,'5','175',404,'Sale Id shift 230846',0.00,76802.50,310.00,76802.50,0.00,'2021-10-12 09:57:18'),(1309883,'5','175',403,'Sale Id shift 230847',0.00,546389.25,165.00,546389.25,0.00,'2021-10-12 10:00:52'),(1309884,'5','175',404,'Sale Id shift 230847',0.00,110170.90,310.00,110170.90,0.00,'2021-10-12 10:00:52'),(1309896,'5','175',403,'Sale Id shift 230848',0.00,452139.60,165.00,452139.60,0.00,'2021-10-12 10:04:46'),(1309897,'5','175',404,'Sale Id shift 230848',0.00,84406.80,310.00,84406.80,0.00,'2021-10-12 10:04:46'),(1309922,'5','175',403,'Sale Id shift 230850',0.00,53141.55,165.00,53141.55,0.00,'2021-10-12 10:14:18'),(1309923,'5','175',404,'Sale Id shift 230850',0.00,36124.30,310.00,36124.30,0.00,'2021-10-12 10:14:18'),(1309953,'5','175',404,'Sale Id shift 230855',0.00,80684.80,320.00,80684.80,0.00,'2021-10-12 10:23:37'),(1311801,'5','175',403,'Sale Id shift 230858',0.00,370481.10,165.00,370481.10,0.00,'2021-10-13 05:56:21'),(1311802,'5','175',404,'Sale Id shift 230858',0.00,99494.40,320.00,99494.40,0.00,'2021-10-13 05:56:21'),(1315065,'5','175',403,'Sale Id shift 231101',0.00,371251.65,165.00,371251.65,0.00,'2021-10-14 07:20:09'),(1315066,'5','175',404,'Sale Id shift 231101',0.00,133776.00,320.00,133776.00,0.00,'2021-10-14 07:20:09'),(1317640,'5','175',403,'Sale Id shift 231417',0.00,429042.90,165.00,429042.90,0.00,'2021-10-15 06:00:13'),(1317641,'5','175',404,'Sale Id shift 231417',0.00,98188.80,320.00,98188.80,0.00,'2021-10-15 06:00:13'),(1320875,'5','175',403,'Sale Id shift 231669',0.00,494901.00,165.00,494901.00,0.00,'2021-10-16 06:19:13'),(1320876,'5','175',404,'Sale Id shift 231669',0.00,105862.40,320.00,105862.40,0.00,'2021-10-16 06:19:13'),(1324653,'5','175',403,'Sale Id shift 231991',0.00,426716.40,165.00,426716.40,0.00,'2021-10-17 08:34:56'),(1324654,'5','175',404,'Sale Id shift 231991',0.00,90208.00,320.00,90208.00,0.00,'2021-10-17 08:34:56'),(1327137,'5','175',403,'Sale Id shift 232184',0.00,488002.35,165.00,488002.35,0.00,'2021-10-18 06:11:46'),(1327138,'5','175',404,'Sale Id shift 232184',0.00,154540.20,327.00,154540.20,0.00,'2021-10-18 06:11:46'),(1330824,'5','175',403,'Sale Id shift 232341',0.00,457660.50,165.00,457660.50,0.00,'2021-10-19 05:51:49'),(1330825,'5','175',404,'Sale Id shift 232341',0.00,117644.79,327.00,117644.79,0.00,'2021-10-19 05:51:49'),(1333951,'5','175',403,'Sale Id shift 232647',0.00,510996.75,165.00,510996.75,0.00,'2021-10-20 05:47:00'),(1333952,'5','175',404,'Sale Id shift 232647',0.00,153631.14,327.00,153631.14,0.00,'2021-10-20 05:47:00'),(1336113,'5','175',404,'Sale Id shift 232887',0.00,23720.58,327.00,23720.58,0.00,'2021-10-20 13:30:18'),(1337450,'5','175',403,'Sale Id shift 233023',0.00,474246.30,165.00,474246.30,0.00,'2021-10-21 06:03:01'),(1337451,'5','175',404,'Sale Id shift 233023',0.00,55131.00,345.00,55131.00,0.00,'2021-10-21 06:03:01'),(1340912,'5','175',403,'Sale Id shift 233126',0.00,526556.25,165.00,526556.25,0.00,'2021-10-22 05:57:44'),(1340913,'5','175',404,'Sale Id shift 233126',0.00,137189.25,345.00,137189.25,0.00,'2021-10-22 05:57:44'),(1344363,'5','175',403,'Sale Id shift 233422',0.00,646649.85,165.00,646649.85,0.00,'2021-10-23 06:16:21'),(1344364,'5','175',404,'Sale Id shift 233422',0.00,125421.30,345.00,125421.30,0.00,'2021-10-23 06:16:21'),(1348142,'5','175',403,'Sale Id shift 233654',0.00,798477.90,165.00,798477.90,0.00,'2021-10-24 06:14:32'),(1348143,'5','175',404,'Sale Id shift 233654',0.00,233571.90,345.00,233571.90,0.00,'2021-10-24 06:14:32'),(1351397,'5','175',403,'Sale Id shift 233850',0.00,608655.30,165.00,608655.30,0.00,'2021-10-25 06:05:01'),(1351398,'5','175',404,'Sale Id shift 233850',0.00,433081.95,345.00,433081.95,0.00,'2021-10-25 06:05:01'),(1354741,'5','175',403,'Sale Id shift 234053',0.00,360996.90,165.00,360996.90,0.00,'2021-10-26 05:38:31'),(1354742,'5','175',404,'Sale Id shift 234053',0.00,71508.15,345.00,71508.15,0.00,'2021-10-26 05:38:31'),(1358814,'5','175',404,'Sale Id shift 234406',0.00,60095.55,345.00,60095.55,0.00,'2021-10-27 08:31:14'),(1361819,'5','175',404,'Sale Id shift 234657',0.00,51142.80,345.00,51142.80,0.00,'2021-10-28 07:19:27'),(1364836,'5','175',404,'Sale Id shift 234870',0.00,47416.80,345.00,47416.80,0.00,'2021-10-29 06:07:08'),(1367886,'5','175',404,'Sale Id shift 235094',0.00,59553.90,345.00,59553.90,0.00,'2021-10-30 07:13:32'),(1371077,'5','175',404,'Sale Id shift 235342',0.00,93674.40,345.00,93674.40,0.00,'2021-10-31 06:10:47'),(1374351,'5','175',404,'Sale Id shift 235586',0.00,100263.90,345.00,100263.90,0.00,'2021-11-01 07:24:00'),(1558367,'5','175',403,'Sale Id shift 245168',0.00,1352148.60,165.00,1352148.60,0.00,'2021-12-11 06:58:48'),(1563392,'5','175',403,'Sale Id shift 245243',0.00,1794544.95,165.00,1794544.95,0.00,'2021-12-12 06:49:17'),(1568405,'5','175',403,'Sale Id shift 245518',0.00,1327195.65,165.00,1327195.65,0.00,'2021-12-13 05:56:56'),(1573760,'5','175',403,'Sale Id shift 245742',0.00,1163091.60,165.00,1163091.60,0.00,'2021-12-14 06:04:22'),(1578624,'5','175',403,'Sale Id shift 245992',0.00,1363055.10,165.00,1363055.10,0.00,'2021-12-15 06:38:23'),(1583499,'5','175',403,'Sale Id shift 246289',0.00,351141.45,165.00,351141.45,0.00,'2021-12-16 06:50:04'),(1599874,'5','175',404,'Sale Id shift 246968',0.00,34248.15,345.00,34248.15,0.00,'2021-12-19 07:11:24'),(1604922,'5','175',404,'Sale Id shift 247215',0.00,80854.20,345.00,80854.20,0.00,'2021-12-20 06:52:52'),(1611267,'5','175',404,'Sale Id shift 247462',0.00,131852.10,345.00,131852.10,0.00,'2021-12-21 09:21:58'),(1615384,'5','175',404,'Sale Id shift 247746',0.00,125193.60,345.00,125193.60,0.00,'2021-12-22 06:28:10'),(1621018,'5','175',404,'Sale Id shift 248012',0.00,124434.60,345.00,124434.60,0.00,'2021-12-23 06:23:16'),(1627098,'5','175',404,'Sale Id shift 248241',0.00,120853.50,345.00,120853.50,0.00,'2021-12-24 07:19:22'),(1636724,'5','175',404,'Sale Id shift 248577',0.00,131120.70,345.00,131120.70,0.00,'2021-12-25 14:07:31'),(1638180,'5','175',404,'Sale Id shift 248821',0.00,162691.65,345.00,162691.65,0.00,'2021-12-26 07:31:00'),(1642228,'5','175',404,'Sale Id shift 248945',0.00,205254.30,345.00,205254.30,0.00,'2021-12-27 07:39:49'),(1646722,'5','175',404,'Sale Id shift 249197',0.00,254161.50,345.00,254161.50,0.00,'2021-12-28 07:34:17'),(1651387,'5','175',404,'Sale Id shift 249435',0.00,102037.20,345.00,102037.20,0.00,'2021-12-29 06:44:22'),(1656097,'5','175',404,'Sale Id shift 249651',0.00,119594.25,345.00,119594.25,0.00,'2021-12-30 06:55:45'),(1666300,'5','175',404,'Sale Id shift 249920',0.00,127384.35,345.00,127384.35,0.00,'2021-12-31 18:59:45'),(1667012,'5','175',404,'Sale Id shift 250288',0.00,124231.05,345.00,124231.05,0.00,'2022-01-01 07:48:29'),(1671518,'5','175',404,'Sale Id shift 250470',0.00,188180.25,345.00,188180.25,0.00,'2022-01-02 06:43:57'),(1679216,'5','175',404,'Sale Id shift 250667',0.00,134822.55,345.00,134822.55,0.00,'2022-01-03 14:05:06'),(1681266,'5','175',404,'Sale Id shift 250969',0.00,127646.55,345.00,127646.55,0.00,'2022-01-04 07:03:53'),(1686822,'5','175',404,'Sale Id shift 251075',0.00,167093.85,345.00,167093.85,0.00,'2022-01-05 07:33:37'),(1692015,'5','175',403,'Sale Id shift 251321',0.00,1238117.10,165.00,1238117.10,0.00,'2022-01-06 07:45:18'),(1692016,'5','175',404,'Sale Id shift 251321',0.00,331058.55,345.00,331058.55,0.00,'2022-01-06 07:45:18'),(1697936,'5','175',403,'Sale Id shift 251569',0.00,1545885.00,165.00,1545885.00,0.00,'2022-01-07 09:07:28'),(1697937,'5','175',404,'Sale Id shift 251569',0.00,156923.25,345.00,156923.25,0.00,'2022-01-07 09:07:28'),(1702480,'5','175',403,'Sale Id shift 251827',0.00,1711521.90,165.00,1711521.90,0.00,'2022-01-08 07:57:07'),(1702481,'5','175',404,'Sale Id shift 251827',0.00,207151.80,345.00,207151.80,0.00,'2022-01-08 07:57:07'),(1708332,'5','175',403,'Sale Id shift 252043',0.00,2013678.15,165.00,2013678.15,0.00,'2022-01-09 08:01:29'),(1708333,'5','175',404,'Sale Id shift 252043',0.00,432460.95,345.00,432460.95,0.00,'2022-01-09 08:01:29'),(1713455,'5','175',403,'Sale Id shift 252280',0.00,900817.50,165.00,900817.50,0.00,'2022-01-10 07:00:57'),(1713456,'5','175',404,'Sale Id shift 252280',0.00,163599.00,345.00,163599.00,0.00,'2022-01-10 07:00:57'),(1718788,'5','175',404,'Sale Id shift 252570',0.00,170826.75,345.00,170826.75,0.00,'2022-01-11 05:29:51'),(1723974,'5','175',404,'Sale Id shift 252769',0.00,115578.45,345.00,115578.45,0.00,'2022-01-12 07:48:34'),(1729145,'5','175',404,'Sale Id shift 253031',0.00,107650.35,345.00,107650.35,0.00,'2022-01-13 07:33:56'),(1735079,'5','175',404,'Sale Id shift 253245',0.00,94954.35,345.00,94954.35,0.00,'2022-01-14 09:29:54'),(1739036,'5','175',404,'Sale Id shift 253545',0.00,110789.85,345.00,110789.85,0.00,'2022-01-15 07:14:33'),(1744958,'5','175',404,'Sale Id shift 253792',0.00,86453.55,345.00,86453.55,0.00,'2022-01-16 07:09:14'),(1749687,'5','175',404,'Sale Id shift 254000',0.00,108098.85,345.00,108098.85,0.00,'2022-01-17 07:12:37'),(1755893,'5','175',404,'Sale Id shift 254274',0.00,62796.90,345.00,62796.90,0.00,'2022-01-18 08:36:59'),(1761872,'5','175',403,'Sale Id shift 254517',0.00,2007399.90,165.00,2007399.90,0.00,'2022-01-19 08:42:08'),(1767879,'5','175',403,'Sale Id shift 254768',0.00,1764483.60,165.00,1764483.60,0.00,'2022-01-20 08:07:14'),(1774261,'5','175',403,'Sale Id shift 255031',0.00,1621052.40,165.00,1621052.40,0.00,'2022-01-21 08:32:36'),(1779943,'5','175',403,'Sale Id shift 255247',0.00,1187613.90,165.00,1187613.90,0.00,'2022-01-22 08:04:44'),(1779944,'5','175',403,'Sale Id shift 257535',0.00,437880.30,165.00,437880.30,0.00,'2022-02-04 06:25:39'),(1779945,'5','175',403,'Sale Id shift 257536',0.00,1282716.60,165.00,1282716.60,0.00,'2022-02-05 07:50:07'),(1779946,'5','175',403,'Sale Id shift 257537',0.00,1256691.15,165.00,1256691.15,0.00,'2022-02-06 07:46:13'),(1779947,'5','175',403,'Sale Id shift 257538',0.00,1006909.20,165.00,1006909.20,0.00,'2022-02-07 07:15:33'),(1779948,'5','175',403,'Sale Id shift 257539',0.00,1690009.20,165.00,1690009.20,0.00,'2022-02-08 07:41:43'),(1779949,'5','175',403,'Sale Id shift 257540',0.00,1057222.65,165.00,1057222.65,0.00,'2022-02-09 08:16:46'),(1779950,'5','175',403,'Sale Id shift 257541',0.00,713352.75,165.00,713352.75,0.00,'2022-02-10 07:57:15'),(1779951,'5','175',403,'Sale Id shift 257555',0.00,962052.30,165.00,962052.30,0.00,'2022-02-24 09:37:07'),(1779952,'5','175',403,'Sale Id shift 257556',0.00,1269981.90,165.00,1269981.90,0.00,'2022-02-25 08:09:57'),(1779953,'5','175',403,'Sale Id shift 257557',0.00,1177101.75,165.00,1177101.75,0.00,'2022-02-26 07:18:54'),(1779954,'5','175',403,'Sale Id shift 257558',0.00,1310972.85,165.00,1310972.85,0.00,'2022-02-27 07:01:15'),(1779955,'5','175',403,'Sale Id shift 257559',0.00,1474011.00,165.00,1474011.00,0.00,'2022-02-28 07:16:56'),(1779956,'5','175',403,'Sale Id shift 257560',0.00,898933.20,165.00,898933.20,0.00,'2022-03-01 06:53:49'),(1779957,'5','175',403,'Sale Id shift 257561',0.00,409299.00,165.00,409299.00,0.00,'2022-03-02 08:17:50'),(1779958,'5','175',403,'Sale Id shift 257574',0.00,547734.00,165.00,547734.00,0.00,'2022-03-16 08:08:57'),(1779959,'5','175',403,'Sale Id shift 257575',0.00,908760.60,165.00,908760.60,0.00,'2022-03-17 10:21:33'),(1779960,'5','175',403,'Sale Id shift 257576',0.00,597410.55,165.00,597410.55,0.00,'2022-03-18 07:46:28'),(1779961,'5','175',403,'Sale Id shift 257577',0.00,200491.50,165.00,200491.50,0.00,'2022-03-19 06:59:38'),(1779962,'5','175',403,'Sale Id shift 257609',0.00,161799.00,165.00,161799.00,0.00,'2022-04-23 17:39:13'),(1779963,'5','175',403,'Sale Id shift 257610',0.00,962984.55,165.00,962984.55,0.00,'2022-04-24 09:19:20'),(1779964,'5','175',403,'Sale Id shift 257611',0.00,877224.15,165.00,877224.15,0.00,'2022-04-25 11:36:52'),(1779965,'5','175',403,'Sale Id shift 257612',0.00,923094.15,165.00,923094.15,0.00,'2022-04-26 11:21:01'),(1779966,'5','175',403,'Sale Id shift 257613',0.00,860445.30,165.00,860445.30,0.00,'2022-04-27 07:49:32'),(1779967,'5','175',403,'Sale Id shift 257614',0.00,1012105.05,165.00,1012105.05,0.00,'2022-04-28 08:25:57'),(1779968,'5','175',403,'Sale Id shift 257615',0.00,1000421.40,165.00,1000421.40,0.00,'2022-04-29 10:19:53'),(1779969,'5','175',403,'Sale Id shift 257616',0.00,687731.55,165.00,687731.55,0.00,'2022-05-10 09:19:22'),(1779970,'5','175',403,'Sale Id shift 257617',0.00,680544.15,165.00,680544.15,0.00,'2022-05-10 11:17:17'),(1779971,'5','175',403,'Sale Id shift 257618',0.00,284024.40,165.00,284024.40,0.00,'2022-05-10 15:54:19'),(1779972,'5','175',403,'Sale Id shift 257622',0.00,562037.85,165.00,562037.85,0.00,'2022-05-11 06:40:53'),(1779973,'5','175',403,'Sale Id shift 257623',0.00,609011.70,165.00,609011.70,0.00,'2022-05-11 07:14:19'),(1779974,'5','175',403,'Sale Id shift 257624',0.00,893677.95,165.00,893677.95,0.00,'2022-05-11 07:48:52'),(1779975,'5','175',403,'Sale Id shift 257625',0.00,834271.35,165.00,834271.35,0.00,'2022-05-11 08:31:59'),(1779976,'5','175',403,'Sale Id shift 257626',0.00,676942.20,165.00,676942.20,0.00,'2022-05-11 08:42:08'),(1779977,'5','175',403,'Sale Id shift 257627',0.00,592899.45,165.00,592899.45,0.00,'2022-05-11 08:44:16'),(1779978,'5','175',403,'Sale Id shift 257628',0.00,199379.40,165.00,199379.40,0.00,'2022-05-12 18:43:52'),(1779979,'5','175',403,'Sale Id shift 257645',0.00,208296.00,165.00,208296.00,0.00,'2022-05-29 08:17:23'),(1779980,'5','175',403,'Sale Id shift 257646',0.00,902472.45,165.00,902472.45,0.00,'2022-05-30 04:59:35'),(1779981,'5','175',403,'Sale Id shift 257647',0.00,739944.15,165.00,739944.15,0.00,'2022-05-31 00:20:15'),(1779982,'5','175',403,'Sale Id shift 257648',0.00,774279.00,165.00,774279.00,0.00,'2022-06-01 07:04:11'),(1779983,'5','175',403,'Sale Id shift 257649',0.00,800355.60,165.00,800355.60,0.00,'2022-06-02 05:01:03'),(1779984,'5','175',403,'Sale Id shift 257650',0.00,281049.45,165.00,281049.45,0.00,'2022-06-03 06:46:28'),(1779985,'5','175',403,'Sale Id shift 257695',0.00,219225.00,185.00,219225.00,0.00,'2022-07-18 11:48:27'),(1779986,'5','175',403,'Sale Id shift 257696',0.00,930631.40,185.00,930631.40,0.00,'2022-07-19 07:22:03'),(1779987,'5','175',403,'Sale Id shift 257697',0.00,648302.90,185.00,648302.90,0.00,'2022-07-20 07:40:10'),(1779988,'5','175',403,'Sale Id shift 257698',0.00,997730.90,185.00,997730.90,0.00,'2022-07-21 06:49:11'),(1779989,'5','175',403,'Sale Id shift 257699',0.00,823956.70,185.00,823956.70,0.00,'2022-07-21 23:15:21'),(1779990,'5','175',403,'Sale Id shift 257700',0.00,828041.50,185.00,828041.50,0.00,'2022-07-23 06:54:53'),(1779991,'5','175',403,'Sale Id shift 257701',0.00,777734.45,185.00,777734.45,0.00,'2022-07-24 08:32:16'),(1779992,'5','175',403,'Sale Id shift 257702',0.00,810044.70,185.00,810044.70,0.00,'2022-07-25 06:44:43'),(1779993,'5','175',403,'Sale Id shift 257703',0.00,656923.90,185.00,656923.90,0.00,'2022-07-26 05:53:45'),(1779994,'5','175',403,'Sale Id shift 257704',0.00,572469.55,185.00,572469.55,0.00,'2022-07-27 07:30:12'),(1779995,'5','175',403,'Sale Id shift 257705',0.00,742471.60,185.00,742471.60,0.00,'2022-07-28 06:53:54'),(1779996,'5','175',403,'Sale Id shift 257706',0.00,290187.30,185.00,290187.30,0.00,'2022-07-29 07:12:22'),(1779997,'5','175',403,'Sale Id shift 257722',0.00,309042.50,185.00,309042.50,0.00,'2022-09-05 11:08:03'),(1779998,'5','175',403,'Sale Id shift 257723',0.00,790838.00,185.00,790838.00,0.00,'2022-09-05 11:10:28'),(1779999,'5','175',403,'Sale Id shift 257724',0.00,831168.00,185.00,831168.00,0.00,'2022-09-05 11:13:57'),(1780000,'5','175',403,'Sale Id shift 257725',0.00,908510.95,185.00,908510.95,0.00,'2022-09-05 11:17:38'),(1780001,'5','175',403,'Sale Id shift 257726',0.00,1028381.70,185.00,1028381.70,0.00,'2022-09-05 11:25:00'),(1780002,'5','175',403,'Sale Id shift 257727',0.00,849797.50,185.00,849797.50,0.00,'2022-09-05 11:29:03'),(1780003,'5','175',403,'Sale Id shift 257728',0.00,1142051.25,185.00,1142051.25,0.00,'2022-09-05 11:33:00'),(1780004,'5','175',403,'Sale Id shift 257729',0.00,675697.70,185.00,675697.70,0.00,'2022-09-05 11:40:28'),(1780005,'5','175',403,'Sale Id shift 257730',0.00,783384.35,185.00,783384.35,0.00,'2022-09-05 11:45:41'),(1780006,'5','175',403,'Sale Id shift 257731',0.00,857915.30,185.00,857915.30,0.00,'2022-09-05 11:55:11'),(1780007,'5','175',403,'Sale Id shift 257732',0.00,412200.35,185.00,412200.35,0.00,'2022-09-05 11:58:56'),(1780008,'5','175',403,'Sale Id shift 257733',0.00,407111.00,185.00,407111.00,0.00,'2022-09-05 12:04:49'),(1780009,'5','175',403,'Sale Id shift 257734',0.00,221889.00,185.00,221889.00,0.00,'2022-09-05 12:07:41'),(1780010,'5','175',403,'Sale Id shift 257746',0.00,493210.00,185.00,493210.00,0.00,'2022-09-06 10:27:57'),(1780011,'5','175',403,'Sale Id shift 257747',0.00,1111862.95,185.00,1111862.95,0.00,'2022-09-07 08:24:35'),(1780012,'5','175',403,'Sale Id shift 257748',0.00,917601.85,185.00,917601.85,0.00,'2022-09-08 07:10:42'),(1780013,'5','175',403,'Sale Id shift 257749',0.00,988934.15,185.00,988934.15,0.00,'2022-09-09 08:18:03'),(1780014,'5','175',403,'Sale Id shift 257750',0.00,665864.95,185.00,665864.95,0.00,'2022-09-10 09:39:38'),(1780015,'5','175',403,'Sale Id shift 257751',0.00,772606.25,185.00,772606.25,0.00,'2022-09-11 08:55:58'),(1780016,'5','175',403,'Sale Id shift 257752',0.00,782847.85,185.00,782847.85,0.00,'2022-09-12 08:56:15'),(1780017,'5','175',403,'Sale Id shift 257753',0.00,833663.65,185.00,833663.65,0.00,'2022-09-13 09:15:19'),(1780018,'5','175',403,'Sale Id shift 257754',0.00,744810.00,185.00,744810.00,0.00,'2022-09-14 08:14:09'),(1780019,'5','175',403,'Sale Id shift 257755',0.00,659902.40,185.00,659902.40,0.00,'2022-09-15 08:52:10'),(1780020,'5','175',403,'Sale Id shift 257756',0.00,405941.80,185.00,405941.80,0.00,'2022-09-16 09:08:55'),(1780021,'5','175',403,'Sale Id shift 257757',0.00,218386.95,185.00,218386.95,0.00,'2022-09-17 10:42:22'),(1780022,'5','175',403,'Sale Id shift 257758',0.00,773135.35,185.00,773135.35,0.00,'2022-09-18 07:21:34'),(1780023,'5','175',403,'Sale Id shift 257759',0.00,791326.40,185.00,791326.40,0.00,'2022-09-19 07:20:02'),(1780024,'5','175',403,'Sale Id shift 257760',0.00,820582.30,185.00,820582.30,0.00,'2022-09-20 08:33:02'),(1780025,'5','175',403,'Sale Id shift 257761',0.00,808760.80,185.00,808760.80,0.00,'2022-09-21 11:51:21'),(1780026,'5','175',403,'Sale Id shift 257762',0.00,677492.20,185.00,677492.20,0.00,'2022-09-22 07:39:26'),(1780027,'5','175',403,'Sale Id shift 257763',0.00,649122.45,185.00,649122.45,0.00,'2022-09-23 07:49:51'),(1780028,'5','175',403,'Sale Id shift 257764',0.00,677033.40,185.00,677033.40,0.00,'2022-09-23 22:38:54'),(1780029,'5','175',403,'Sale Id shift 257765',0.00,765646.55,185.00,765646.55,0.00,'2022-09-25 08:04:58'),(1780030,'5','175',403,'Sale Id shift 257766',0.00,709639.65,185.00,709639.65,0.00,'2022-09-26 07:17:57'),(1780031,'5','175',403,'Sale Id shift 257767',0.00,726970.45,185.00,726970.45,0.00,'2022-09-27 07:25:13'),(1780032,'5','175',403,'Sale Id shift 257768',0.00,661097.50,185.00,661097.50,0.00,'2022-09-28 08:23:37');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4952439 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','175',3554812,'','24','3186',0.00,4587000.00,'Purchase Id 78060 for 27,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-10-11 13:31:47','',''),('5','175',3554813,'','supplier','218',4587000.00,0.00,'Purchase Id 78060 for 27,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-10-11 13:31:47','',''),('5','175',3554814,'','24','3186',0.00,3462000.00,'Purchase Id 78059 for 11,540.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2021-10-11 13:32:00','',''),('5','175',3554815,'','supplier','218',3462000.00,0.00,'Purchase Id 78059 for 11,540.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2021-10-11 13:32:00','',''),('5','175',3558286,'','20','3182',946028.25,0.00,'Sales from shift 230755 on 2021-10-11 19:53:47 ','2021-10-11 19:53:47','',''),('5','175',3558287,'','6.1','3183',0.00,946028.25,'Sales from shift 230755 on 2021-10-11 19:53:47 ','2021-10-11 19:53:47','',''),('5','175',3558290,'','20','3182',545739.75,0.00,'Sales from shift 230757 on 2021-10-11 19:58:17 ','2021-10-11 19:58:17','',''),('5','175',3558291,'','6.1','3183',0.00,545739.75,'Sales from shift 230757 on 2021-10-11 19:58:17 ','2021-10-11 19:58:17','',''),('5','175',3558304,'','20','3182',500540.55,0.00,'Sales from shift 230759 on 2021-10-11 20:06:11 ','2021-10-11 20:06:11','',''),('5','175',3558305,'','6.1','3183',0.00,500540.55,'Sales from shift 230759 on 2021-10-11 20:06:11 ','2021-10-11 20:06:11','',''),('5','175',3558427,'','20','3182',475411.65,0.00,'Sales from shift 230765 on 2021-10-12 04:40:12 ','2021-10-12 04:40:12','',''),('5','175',3558428,'','6.1','3183',0.00,475411.65,'Sales from shift 230765 on 2021-10-12 04:40:12 ','2021-10-12 04:40:12','',''),('5','175',3561275,'','20','3182',576000.60,0.00,'Sales from shift 230837 on 2021-10-12 09:41:46 ','2021-10-12 09:41:46','',''),('5','175',3561276,'','6.1','3183',0.00,576000.60,'Sales from shift 230837 on 2021-10-12 09:41:46 ','2021-10-12 09:41:46','',''),('5','175',3561362,'','20','3182',646685.15,0.00,'Sales from shift 230840 on 2021-10-12 09:53:59 ','2021-10-12 09:53:59','',''),('5','175',3561363,'','6.1','3183',0.00,646685.15,'Sales from shift 230840 on 2021-10-12 09:53:59 ','2021-10-12 09:53:59','',''),('5','175',3561389,'','20','3182',654941.05,0.00,'Sales from shift 230846 on 2021-10-12 09:57:18 ','2021-10-12 09:57:18','',''),('5','175',3561390,'','6.1','3183',0.00,654941.05,'Sales from shift 230846 on 2021-10-12 09:57:18 ','2021-10-12 09:57:18','',''),('5','175',3561423,'','20','3182',656560.15,0.00,'Sales from shift 230847 on 2021-10-12 10:00:52 ','2021-10-12 10:00:52','',''),('5','175',3561424,'','6.1','3183',0.00,656560.15,'Sales from shift 230847 on 2021-10-12 10:00:52 ','2021-10-12 10:00:52','',''),('5','175',3561458,'','20','3182',536546.40,0.00,'Sales from shift 230848 on 2021-10-12 10:04:46 ','2021-10-12 10:04:46','',''),('5','175',3561459,'','6.1','3183',0.00,536546.40,'Sales from shift 230848 on 2021-10-12 10:04:46 ','2021-10-12 10:04:46','',''),('5','175',3561553,'','20','3182',89265.85,0.00,'Sales from shift 230850 on 2021-10-12 10:14:18 ','2021-10-12 10:14:18','',''),('5','175',3561554,'','6.1','3183',0.00,89265.85,'Sales from shift 230850 on 2021-10-12 10:14:18 ','2021-10-12 10:14:18','',''),('5','175',3561648,'','20','3182',80684.80,0.00,'Sales from shift 230855 on 2021-10-12 10:23:37 ','2021-10-12 10:23:37','',''),('5','175',3561649,'','6.1','3183',0.00,80684.80,'Sales from shift 230855 on 2021-10-12 10:23:37 ','2021-10-12 10:23:37','',''),('5','175',3561705,'','24','3186',0.00,6930000.00,'Purchase Id 78108 for 42,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-10-12 10:29:16','',''),('5','175',3561706,'','supplier','218',6930000.00,0.00,'Purchase Id 78108 for 42,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-10-12 10:29:16','',''),('5','175',3568590,'','20','3182',469975.50,0.00,'Sales from shift 230858 on 2021-10-13 05:56:21 ','2021-10-13 05:56:21','',''),('5','175',3568591,'','6.1','3183',0.00,469975.50,'Sales from shift 230858 on 2021-10-13 05:56:21 ','2021-10-13 05:56:21','',''),('5','175',3572624,'','2','3235',869730.00,0.00,'Payment Id 343149 for invoice:230755, receipt: 465767 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:44:33','',''),('5','175',3572625,'','supplier','218',0.00,869730.00,'Payment Id 343149 for invoice:230755, receipt: 465767 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:44:33','',''),('5','175',3572630,'','6.1','3183',15400.00,0.00,'Payment Id 343151 for invoice:230755, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:44:59','',''),('5','175',3572631,'','supplier','218',0.00,15400.00,'Payment Id 343151 for invoice:230755, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:44:59','',''),('5','175',3572632,'','2','3235',60900.00,0.00,'Payment Id 343154 for invoice:230755, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:45:08','',''),('5','175',3572633,'','supplier','218',0.00,60900.00,'Payment Id 343154 for invoice:230755, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:45:08','',''),('5','175',3572644,'','2','3235',10000.00,0.00,'Payment Id 343166 for invoice:230757, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572645,'','supplier','218',0.00,10000.00,'Payment Id 343166 for invoice:230757, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572646,'','6.1','3183',15400.00,0.00,'Payment Id 343163 for invoice:230757, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572647,'','supplier','218',0.00,15400.00,'Payment Id 343163 for invoice:230757, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572648,'','2','3235',520340.00,0.00,'Payment Id 343160 for invoice:230757, receipt: 465752 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572649,'','supplier','218',0.00,520340.00,'Payment Id 343160 for invoice:230757, receipt: 465752 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:46:03','',''),('5','175',3572672,'','2','3235',25900.00,0.00,'Payment Id 343175 for invoice:230765, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572673,'','supplier','218',0.00,25900.00,'Payment Id 343175 for invoice:230765, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572674,'','6.1','3183',15400.00,0.00,'Payment Id 343174 for invoice:230765, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572675,'','supplier','218',0.00,15400.00,'Payment Id 343174 for invoice:230765, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572676,'','2','3235',434110.00,0.00,'Payment Id 343173 for invoice:230765, receipt: 081421 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572677,'','supplier','218',0.00,434110.00,'Payment Id 343173 for invoice:230765, receipt: 081421 by SALBAS OIL & GAS NIG LTD','2021-10-13 11:47:58','',''),('5','175',3572814,'','6.1','3183',15400.00,0.00,'Payment Id 343172 for invoice:230759, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:05:30','',''),('5','175',3572815,'','supplier','218',0.00,15400.00,'Payment Id 343172 for invoice:230759, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:05:30','',''),('5','175',3572816,'','2','3235',485140.00,0.00,'Payment Id 343171 for invoice:230759, receipt: 465710 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:05:30','',''),('5','175',3572817,'','supplier','218',0.00,485140.00,'Payment Id 343171 for invoice:230759, receipt: 465710 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:05:30','',''),('5','175',3572832,'','2','3235',615785.00,0.00,'Payment Id 343182 for invoice:230840, receipt: 465765 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:35','',''),('5','175',3572833,'','supplier','218',0.00,615785.00,'Payment Id 343182 for invoice:230840, receipt: 465765 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:35','',''),('5','175',3572838,'','2','3235',15000.00,0.00,'Payment Id 343186 for invoice:230840, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:50','',''),('5','175',3572839,'','supplier','218',0.00,15000.00,'Payment Id 343186 for invoice:230840, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:50','',''),('5','175',3572840,'','6.1','3183',15900.00,0.00,'Payment Id 343184 for invoice:230840, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:50','',''),('5','175',3572841,'','supplier','218',0.00,15900.00,'Payment Id 343184 for invoice:230840, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:06:50','',''),('5','175',3572850,'','6.1','3183',15900.00,0.00,'Payment Id 343189 for invoice:230846, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:15','',''),('5','175',3572851,'','supplier','218',0.00,15900.00,'Payment Id 343189 for invoice:230846, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:15','',''),('5','175',3572852,'','2','3235',639040.00,0.00,'Payment Id 343187 for invoice:230846, receipt: 465763 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:15','',''),('5','175',3572853,'','supplier','218',0.00,639040.00,'Payment Id 343187 for invoice:230846, receipt: 465763 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:15','',''),('5','175',3572856,'','2','3235',10000.00,0.00,'Payment Id 343193 for invoice:230847, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572857,'','supplier','218',0.00,10000.00,'Payment Id 343193 for invoice:230847, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572858,'','6.1','3183',15900.00,0.00,'Payment Id 343191 for invoice:230858, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572859,'','supplier','218',0.00,15900.00,'Payment Id 343191 for invoice:230858, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572860,'','2','3235',630660.00,0.00,'Payment Id 343190 for invoice:230847, receipt: 465780 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572861,'','supplier','218',0.00,630660.00,'Payment Id 343190 for invoice:230847, receipt: 465780 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:07:37','',''),('5','175',3572872,'','2','3235',7100.00,0.00,'Payment Id 343200 for invoice:230848, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572873,'','supplier','218',0.00,7100.00,'Payment Id 343200 for invoice:230848, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572874,'','6.1','3183',15900.00,0.00,'Payment Id 343198 for invoice:230848, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572875,'','supplier','218',0.00,15900.00,'Payment Id 343198 for invoice:230848, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572876,'','2','3235',513545.00,0.00,'Payment Id 343197 for invoice:230848, receipt: 465779 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572877,'','supplier','218',0.00,513545.00,'Payment Id 343197 for invoice:230848, receipt: 465779 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:04','',''),('5','175',3572882,'','6.1','3183',15900.00,0.00,'Payment Id 343203 for invoice:230850, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:31','',''),('5','175',3572883,'','supplier','218',0.00,15900.00,'Payment Id 343203 for invoice:230850, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:31','',''),('5','175',3572884,'','2','3235',73415.00,0.00,'Payment Id 343202 for invoice:230850, receipt: 465778 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:31','',''),('5','175',3572885,'','supplier','218',0.00,73415.00,'Payment Id 343202 for invoice:230850, receipt: 465778 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:08:31','',''),('5','175',3572890,'','6.1','3183',28100.00,0.00,'Payment Id 343206 for invoice:230855, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:09:04','',''),('5','175',3572891,'','supplier','218',0.00,28100.00,'Payment Id 343206 for invoice:230855, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:09:04','',''),('5','175',3572892,'','2','3235',53085.00,0.00,'Payment Id 343204 for invoice:230855, receipt: 465777 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:09:04','',''),('5','175',3572893,'','supplier','218',0.00,53085.00,'Payment Id 343204 for invoice:230855, receipt: 465777 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:09:04','',''),('5','175',3573121,'','6.1','3183',282400.00,0.00,'Payment Id 343706 for invoice:230858, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:31:11','',''),('5','175',3573122,'','supplier','218',0.00,282400.00,'Payment Id 343706 for invoice:230858, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:31:11','',''),('5','175',3573123,'','2','3235',187525.00,0.00,'Payment Id 343704 for invoice:230858, receipt: 465776 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:31:11','',''),('5','175',3573124,'','supplier','218',0.00,187525.00,'Payment Id 343704 for invoice:230858, receipt: 465776 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:31:11','',''),('5','175',3573235,'','2','3235',15900.00,0.00,'Payment Id 343179 for invoice:230837, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3573236,'','supplier','218',0.00,15900.00,'Payment Id 343179 for invoice:230837, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3573237,'','6.1','3183',15900.00,0.00,'Payment Id 343178 for invoice:230837, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3573238,'','supplier','218',0.00,15900.00,'Payment Id 343178 for invoice:230837, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3573239,'','2','3235',540130.00,0.00,'Payment Id 343177 for invoice:230837, receipt: 465764 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3573240,'','supplier','218',0.00,540130.00,'Payment Id 343177 for invoice:230837, receipt: 465764 by SALBAS OIL & GAS NIG LTD','2021-10-13 12:38:36','',''),('5','175',3579471,'','20','3182',505027.65,0.00,'Sales from shift 231101 on 2021-10-14 07:20:09 ','2021-10-14 07:20:09','',''),('5','175',3579472,'','6.1','3183',0.00,505027.65,'Sales from shift 231101 on 2021-10-14 07:20:09 ','2021-10-14 07:20:09','',''),('5','175',3588256,'','20','3182',527231.70,0.00,'Sales from shift 231417 on 2021-10-15 06:00:13 ','2021-10-15 06:00:13','',''),('5','175',3588257,'','6.1','3183',0.00,527231.70,'Sales from shift 231417 on 2021-10-15 06:00:13 ','2021-10-15 06:00:13','',''),('5','175',3598527,'','20','3182',600763.40,0.00,'Sales from shift 231669 on 2021-10-16 06:19:13 ','2021-10-16 06:19:13','',''),('5','175',3598528,'','6.1','3183',0.00,600763.40,'Sales from shift 231669 on 2021-10-16 06:19:13 ','2021-10-16 06:19:13','',''),('5','175',3607930,'','2','3235',485280.00,0.00,'Payment Id 344217 for invoice:231101, receipt: 465756 by SALBAS OIL & GAS NIG LTD','2021-10-16 19:34:45','',''),('5','175',3607931,'','supplier','218',0.00,485280.00,'Payment Id 344217 for invoice:231101, receipt: 465756 by SALBAS OIL & GAS NIG LTD','2021-10-16 19:34:45','',''),('5','175',3607932,'','2','3235',12000.00,0.00,'Payment Id 344820 for invoice:231417, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607933,'','supplier','218',0.00,12000.00,'Payment Id 344820 for invoice:231417, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607934,'','6.1','3183',16400.00,0.00,'Payment Id 344817 for invoice:231417, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607935,'','supplier','218',0.00,16400.00,'Payment Id 344817 for invoice:231417, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607936,'','2','3235',498830.00,0.00,'Payment Id 344816 for invoice:231417, receipt: 465757 by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607937,'','supplier','218',0.00,498830.00,'Payment Id 344816 for invoice:231417, receipt: 465757 by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607938,'','2','3235',5000.00,0.00,'Payment Id 344220 for invoice:231101, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607939,'','supplier','218',0.00,5000.00,'Payment Id 344220 for invoice:231101, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607940,'','6.1','3183',16400.00,0.00,'Payment Id 344219 for invoice:231101, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3607941,'','supplier','218',0.00,16400.00,'Payment Id 344219 for invoice:231101, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-16 19:35:19','',''),('5','175',3610271,'','20','3182',516924.40,0.00,'Sales from shift 231991 on 2021-10-17 08:34:56 ','2021-10-17 08:34:56','',''),('5','175',3610272,'','6.1','3183',0.00,516924.40,'Sales from shift 231991 on 2021-10-17 08:34:56 ','2021-10-17 08:34:56','',''),('5','175',3618063,'','20','3182',642542.55,0.00,'Sales from shift 232184 on 2021-10-18 06:11:46 ','2021-10-18 06:11:46','',''),('5','175',3618064,'','6.1','3183',0.00,642542.55,'Sales from shift 232184 on 2021-10-18 06:11:46 ','2021-10-18 06:11:46','',''),('5','175',3627912,'','20','3182',575305.29,0.00,'Sales from shift 232341 on 2021-10-19 05:51:49 ','2021-10-19 05:51:49','',''),('5','175',3627913,'','6.1','3183',0.00,575305.29,'Sales from shift 232341 on 2021-10-19 05:51:49 ','2021-10-19 05:51:49','',''),('5','175',3634239,'','2','3235',18050.00,0.00,'Payment Id 346533 for invoice:232184, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634240,'','supplier','218',0.00,18050.00,'Payment Id 346533 for invoice:232184, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634241,'','6.1','3183',16750.00,0.00,'Payment Id 346530 for invoice:232184, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634242,'','supplier','218',0.00,16750.00,'Payment Id 346530 for invoice:232184, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634243,'','2','3235',607745.00,0.00,'Payment Id 346529 for invoice:232184, receipt: 465759 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634244,'','supplier','218',0.00,607745.00,'Payment Id 346529 for invoice:232184, receipt: 465759 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634245,'','2','3235',5000.00,0.00,'Payment Id 346528 for invoice:231991, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634246,'','supplier','218',0.00,5000.00,'Payment Id 346528 for invoice:231991, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634247,'','6.1','3183',16750.00,0.00,'Payment Id 346527 for invoice:231991, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634248,'','supplier','218',0.00,16750.00,'Payment Id 346527 for invoice:231991, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634249,'','2','3235',497150.00,0.00,'Payment Id 346525 for invoice:231991, receipt: 465753 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634250,'','supplier','218',0.00,497150.00,'Payment Id 346525 for invoice:231991, receipt: 465753 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634251,'','2','3235',577360.00,0.00,'Payment Id 346522 for invoice:231669, receipt: 465754 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3634252,'','supplier','218',0.00,577360.00,'Payment Id 346522 for invoice:231669, receipt: 465754 by SALBAS OIL & GAS NIG LTD','2021-10-19 14:12:06','',''),('5','175',3636977,'','20','3182',664627.89,0.00,'Sales from shift 232647 on 2021-10-20 05:47:00 ','2021-10-20 05:47:00','',''),('5','175',3636978,'','6.1','3183',0.00,664627.89,'Sales from shift 232647 on 2021-10-20 05:47:00 ','2021-10-20 05:47:00','',''),('5','175',3643436,'','20','3182',23720.58,0.00,'Sales from shift 232887 on 2021-10-20 13:30:18 ','2021-10-20 13:30:18','',''),('5','175',3643437,'','6.1','3183',0.00,23720.58,'Sales from shift 232887 on 2021-10-20 13:30:18 ','2021-10-20 13:30:18','',''),('5','175',3647227,'','2','3235',16000.00,0.00,'Payment Id 347405 for invoice:232647, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647228,'','supplier','218',0.00,16000.00,'Payment Id 347405 for invoice:232647, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647229,'','6.1','3183',16750.00,0.00,'Payment Id 347404 for invoice:232647, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647230,'','supplier','218',0.00,16750.00,'Payment Id 347404 for invoice:232647, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647231,'','2','3235',631875.00,0.00,'Payment Id 347401 for invoice:232647, receipt: 465743 by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647232,'','supplier','218',0.00,631875.00,'Payment Id 347401 for invoice:232647, receipt: 465743 by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647233,'','2','3235',400.00,0.00,'Payment Id 347398 for invoice:232241, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647234,'','supplier','218',0.00,400.00,'Payment Id 347398 for invoice:232241, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647235,'','6.1','3183',16750.00,0.00,'Payment Id 347392 for invoice:232341, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647236,'','supplier','218',0.00,16750.00,'Payment Id 347392 for invoice:232341, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647237,'','2','3235',558155.00,0.00,'Payment Id 347390 for invoice:232341, receipt: 012843 by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647238,'','supplier','218',0.00,558155.00,'Payment Id 347390 for invoice:232341, receipt: 012843 by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647239,'','6.1','3183',23400.00,0.00,'Payment Id 346523 for invoice:231669, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3647240,'','supplier','218',0.00,23400.00,'Payment Id 346523 for invoice:231669, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-20 16:19:25','',''),('5','175',3649029,'','20','3182',529377.30,0.00,'Sales from shift 233023 on 2021-10-21 06:03:01 ','2021-10-21 06:03:01','',''),('5','175',3649030,'','6.1','3183',0.00,529377.30,'Sales from shift 233023 on 2021-10-21 06:03:01 ','2021-10-21 06:03:01','',''),('5','175',3657672,'','2','3235',23280.00,0.00,'Payment Id 348006 for invoice:233023, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657673,'','supplier','218',0.00,23280.00,'Payment Id 348006 for invoice:233023, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657674,'','6.1','3183',16900.00,0.00,'Payment Id 348004 for invoice:233023, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657675,'','supplier','218',0.00,16900.00,'Payment Id 348004 for invoice:233023, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657676,'','2','3235',489415.00,0.00,'Payment Id 348000 for invoice:233023, receipt: 465744 by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657677,'','supplier','218',0.00,489415.00,'Payment Id 348000 for invoice:233023, receipt: 465744 by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657678,'','2','3235',23720.00,0.00,'Payment Id 347999 for invoice:232887, receipt: 465744 by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657679,'','supplier','218',0.00,23720.00,'Payment Id 347999 for invoice:232887, receipt: 465744 by SALBAS OIL & GAS NIG LTD','2021-10-21 19:05:34','',''),('5','175',3657944,'','20','3182',663745.50,0.00,'Sales from shift 233126 on 2021-10-22 05:57:44 ','2021-10-22 05:57:44','',''),('5','175',3657945,'','6.1','3183',0.00,663745.50,'Sales from shift 233126 on 2021-10-22 05:57:44 ','2021-10-22 05:57:44','',''),('5','175',3669079,'','20','3182',772071.15,0.00,'Sales from shift 233422 on 2021-10-23 06:16:21 ','2021-10-23 06:16:21','',''),('5','175',3669080,'','6.1','3183',0.00,772071.15,'Sales from shift 233422 on 2021-10-23 06:16:21 ','2021-10-23 06:16:21','',''),('5','175',3679103,'','20','3182',1032049.80,0.00,'Sales from shift 233654 on 2021-10-24 06:14:32 ','2021-10-24 06:14:32','',''),('5','175',3679104,'','6.1','3183',0.00,1032049.80,'Sales from shift 233654 on 2021-10-24 06:14:32 ','2021-10-24 06:14:32','',''),('5','175',3686416,'','2','3235',33509.00,0.00,'Payment Id 348777 for invoice:233126, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3686417,'','supplier','218',0.00,33509.00,'Payment Id 348777 for invoice:233126, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3686418,'','6.1','3183',17650.00,0.00,'Payment Id 348776 for invoice:233126, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3686419,'','supplier','218',0.00,17650.00,'Payment Id 348776 for invoice:233126, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3686420,'','2','3235',612585.00,0.00,'Payment Id 348775 for invoice:233126, receipt: 465745 by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3686421,'','supplier','218',0.00,612585.00,'Payment Id 348775 for invoice:233126, receipt: 465745 by SALBAS OIL & GAS NIG LTD','2021-10-24 17:02:11','',''),('5','175',3687409,'','20','3182',1041737.25,0.00,'Sales from shift 233850 on 2021-10-25 06:05:01 ','2021-10-25 06:05:01','',''),('5','175',3687410,'','6.1','3183',0.00,1041737.25,'Sales from shift 233850 on 2021-10-25 06:05:01 ','2021-10-25 06:05:01','',''),('5','175',3693533,'','2','3235',5100.00,0.00,'Payment Id 350334 for invoice:233850, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693534,'','supplier','218',0.00,5100.00,'Payment Id 350334 for invoice:233850, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693535,'','6.1','3183',17650.00,0.00,'Payment Id 350332 for invoice:233850, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693536,'','supplier','218',0.00,17650.00,'Payment Id 350332 for invoice:233850, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693537,'','2','3235',1018990.00,0.00,'Payment Id 350330 for invoice:233850, receipt: 465756 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693538,'','supplier','218',0.00,1018990.00,'Payment Id 350330 for invoice:233850, receipt: 465756 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693539,'','2','3235',41515.00,0.00,'Payment Id 350328 for invoice:233654, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693540,'','supplier','218',0.00,41515.00,'Payment Id 350328 for invoice:233654, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693541,'','6.1','3183',17650.00,0.00,'Payment Id 350325 for invoice:233654, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693542,'','supplier','218',0.00,17650.00,'Payment Id 350325 for invoice:233654, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693543,'','2','3235',972885.00,0.00,'Payment Id 350323 for invoice:233654, receipt: 0133661 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693544,'','supplier','218',0.00,972885.00,'Payment Id 350323 for invoice:233654, receipt: 0133661 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693545,'','2','3235',1500.00,0.00,'Payment Id 350320 for invoice:233422, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693546,'','supplier','218',0.00,1500.00,'Payment Id 350320 for invoice:233422, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693547,'','6.1','3183',17650.00,0.00,'Payment Id 350319 for invoice:233422, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693548,'','supplier','218',0.00,17650.00,'Payment Id 350319 for invoice:233422, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693549,'','2','3235',752920.00,0.00,'Payment Id 350318 for invoice:233422, receipt: 0133660 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3693550,'','supplier','218',0.00,752920.00,'Payment Id 350318 for invoice:233422, receipt: 0133660 by SALBAS OIL & GAS NIG LTD','2021-10-25 13:49:55','',''),('5','175',3697441,'','20','3182',432505.05,0.00,'Sales from shift 234053 on 2021-10-26 05:38:31 ','2021-10-26 05:38:31','',''),('5','175',3697442,'','6.1','3183',0.00,432505.05,'Sales from shift 234053 on 2021-10-26 05:38:31 ','2021-10-26 05:38:31','',''),('5','175',3710865,'','20','3182',60095.55,0.00,'Sales from shift 234406 on 2021-10-27 08:31:14 ','2021-10-27 08:31:14','',''),('5','175',3710866,'','6.1','3183',0.00,60095.55,'Sales from shift 234406 on 2021-10-27 08:31:14 ','2021-10-27 08:31:14','',''),('5','175',3711066,'','6.1','3183',17650.00,0.00,'Payment Id 350784 for invoice:234053, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-27 08:54:17','',''),('5','175',3711067,'','supplier','218',0.00,17650.00,'Payment Id 350784 for invoice:234053, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-27 08:54:17','',''),('5','175',3711068,'','2','3235',414855.00,0.00,'Payment Id 350783 for invoice:234053, receipt: 133059 by SALBAS OIL & GAS NIG LTD','2021-10-27 08:54:17','',''),('5','175',3711069,'','supplier','218',0.00,414855.00,'Payment Id 350783 for invoice:234053, receipt: 133059 by SALBAS OIL & GAS NIG LTD','2021-10-27 08:54:17','',''),('5','175',3720551,'','20','3182',51142.80,0.00,'Sales from shift 234657 on 2021-10-28 07:19:27 ','2021-10-28 07:19:27','',''),('5','175',3720552,'','6.1','3183',0.00,51142.80,'Sales from shift 234657 on 2021-10-28 07:19:27 ','2021-10-28 07:19:27','',''),('5','175',3722679,'','6.1','3183',17650.00,0.00,'Payment Id 351358 for invoice:234406, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-28 09:29:09','',''),('5','175',3722680,'','supplier','218',0.00,17650.00,'Payment Id 351358 for invoice:234406, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-28 09:29:09','',''),('5','175',3722681,'','2','3235',42445.00,0.00,'Payment Id 351356 for invoice:234406, receipt: 0133053 by SALBAS OIL & GAS NIG LTD','2021-10-28 09:29:09','',''),('5','175',3722682,'','supplier','218',0.00,42445.00,'Payment Id 351356 for invoice:234406, receipt: 0133053 by SALBAS OIL & GAS NIG LTD','2021-10-28 09:29:09','',''),('5','175',3723495,'','6.1','3183',17650.00,0.00,'Payment Id 351846 for invoice:234657, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-28 10:21:35','',''),('5','175',3723496,'','supplier','218',0.00,17650.00,'Payment Id 351846 for invoice:234657, receipt:  by SALBAS OIL & GAS NIG LTD','2021-10-28 10:21:35','',''),('5','175',3723497,'','2','3235',33495.00,0.00,'Payment Id 351843 for invoice:234657, receipt: 1033050 by SALBAS OIL & GAS NIG LTD','2021-10-28 10:21:35','',''),('5','175',3723498,'','supplier','218',0.00,33495.00,'Payment Id 351843 for invoice:234657, receipt: 1033050 by SALBAS OIL & GAS NIG LTD','2021-10-28 10:21:35','',''),('5','175',3729825,'','20','3182',47416.80,0.00,'Sales from shift 234870 on 2021-10-29 06:07:08 ','2021-10-29 06:07:08','',''),('5','175',3729826,'','6.1','3183',0.00,47416.80,'Sales from shift 234870 on 2021-10-29 06:07:08 ','2021-10-29 06:07:08','',''),('5','175',3739092,'','20','3182',59553.90,0.00,'Sales from shift 235094 on 2021-10-30 07:13:32 ','2021-10-30 07:13:32','',''),('5','175',3739093,'','6.1','3183',0.00,59553.90,'Sales from shift 235094 on 2021-10-30 07:13:32 ','2021-10-30 07:13:32','',''),('5','175',3748713,'','20','3182',93674.40,0.00,'Sales from shift 235342 on 2021-10-31 06:10:47 ','2021-10-31 06:10:47','',''),('5','175',3748714,'','6.1','3183',0.00,93674.40,'Sales from shift 235342 on 2021-10-31 06:10:47 ','2021-10-31 06:10:47','',''),('5','175',3758864,'','20','3182',100263.90,0.00,'Sales from shift 235586 on 2021-11-01 07:24:00 ','2021-11-01 07:24:00','',''),('5','175',3758865,'','6.1','3183',0.00,100263.90,'Sales from shift 235586 on 2021-11-01 07:24:00 ','2021-11-01 07:24:00','',''),('5','175',3765368,'','6.1','3183',17650.00,0.00,'Payment Id 353810 for invoice:235586, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:43','',''),('5','175',3765369,'','supplier','218',0.00,17650.00,'Payment Id 353810 for invoice:235586, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:43','',''),('5','175',3765370,'','2','3235',82615.00,0.00,'Payment Id 353809 for invoice:235586, receipt: 0133053 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765371,'','supplier','218',0.00,82615.00,'Payment Id 353809 for invoice:235586, receipt: 0133053 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765372,'','6.1','3183',17650.00,0.00,'Payment Id 353808 for invoice:235342, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765373,'','supplier','218',0.00,17650.00,'Payment Id 353808 for invoice:235342, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765374,'','2','3235',76025.00,0.00,'Payment Id 353806 for invoice:235342, receipt: 0133054 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765375,'','supplier','218',0.00,76025.00,'Payment Id 353806 for invoice:235342, receipt: 0133054 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765376,'','6.1','3183',17650.00,0.00,'Payment Id 353804 for invoice:235094, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765377,'','supplier','218',0.00,17650.00,'Payment Id 353804 for invoice:235094, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765378,'','2','3235',41905.00,0.00,'Payment Id 353803 for invoice:235094, receipt: 0133051 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765379,'','supplier','218',0.00,41905.00,'Payment Id 353803 for invoice:235094, receipt: 0133051 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765380,'','6.1','3183',17650.00,0.00,'Payment Id 352451 for invoice:234870, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765381,'','supplier','218',0.00,17650.00,'Payment Id 352451 for invoice:234870, receipt:  by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765382,'','2','3235',29765.00,0.00,'Payment Id 352449 for invoice:234870, receipt: 0133057 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3765383,'','supplier','218',0.00,29765.00,'Payment Id 352449 for invoice:234870, receipt: 0133057 by SALBAS OIL & GAS NIG LTD','2021-11-01 16:21:44','',''),('5','175',3766920,'','20','3182',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3767282,'','24','3185',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3767923,'','6.1','3183',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3768143,'','22','3184',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3768872,'','2','3235',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3769875,'','24','3186',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','175',3871185,'','20','3182',0.00,0.00,'Sales from shift 238027 on 2021-11-10 14:07:20 ','2021-11-10 14:07:20','',''),('5','175',3871186,'','6.1','3183',0.00,0.00,'Sales from shift 238027 on 2021-11-10 14:07:20 ','2021-11-10 14:07:20','',''),('5','175',3876157,'','20','3182',0.00,0.00,'Sales from shift 238035 on 2021-11-11 05:45:22 ','2021-11-11 05:45:22','',''),('5','175',3876158,'','6.1','3183',0.00,0.00,'Sales from shift 238035 on 2021-11-11 05:45:22 ','2021-11-11 05:45:22','',''),('5','175',3882423,'','20','3182',0.00,0.00,'Sales from shift 238207 on 2021-11-11 12:11:16 ','2021-11-11 12:11:16','',''),('5','175',3882424,'','6.1','3183',0.00,0.00,'Sales from shift 238207 on 2021-11-11 12:11:16 ','2021-11-11 12:11:16','',''),('5','175',3882601,'','20','3182',0.00,0.00,'Sales from shift 238237 on 2021-11-11 12:20:31 ','2021-11-11 12:20:31','',''),('5','175',3882602,'','6.1','3183',0.00,0.00,'Sales from shift 238237 on 2021-11-11 12:20:31 ','2021-11-11 12:20:31','',''),('5','175',3882880,'','20','3182',0.00,0.00,'Sales from shift 238243 on 2021-11-11 12:34:56 ','2021-11-11 12:34:56','',''),('5','175',3882881,'','6.1','3183',0.00,0.00,'Sales from shift 238243 on 2021-11-11 12:34:56 ','2021-11-11 12:34:56','',''),('5','175',3884277,'','20','3182',0.00,0.00,'Sales from shift 238249 on 2021-11-11 13:52:59 ','2021-11-11 13:52:59','',''),('5','175',3884278,'','6.1','3183',0.00,0.00,'Sales from shift 238249 on 2021-11-11 13:52:59 ','2021-11-11 13:52:59','',''),('5','175',3891794,'','20','3182',0.00,0.00,'Sales from shift 238270 on 2021-11-12 07:26:34 ','2021-11-12 07:26:34','',''),('5','175',3891795,'','6.1','3183',0.00,0.00,'Sales from shift 238270 on 2021-11-12 07:26:34 ','2021-11-12 07:26:34','',''),('5','175',3897233,'','20','3182',0.00,0.00,'Sales from shift 238491 on 2021-11-12 13:36:29 ','2021-11-12 13:36:29','',''),('5','175',3897234,'','6.1','3183',0.00,0.00,'Sales from shift 238491 on 2021-11-12 13:36:29 ','2021-11-12 13:36:29','',''),('5','175',3898544,'','20','3182',0.00,0.00,'Sales from shift 238523 on 2021-11-12 14:34:33 ','2021-11-12 14:34:33','',''),('5','175',3898545,'','6.1','3183',0.00,0.00,'Sales from shift 238523 on 2021-11-12 14:34:33 ','2021-11-12 14:34:33','',''),('5','175',3899670,'','20','3182',0.00,0.00,'Sales from shift 238531 on 2021-11-12 15:31:12 ','2021-11-12 15:31:12','',''),('5','175',3899671,'','6.1','3183',0.00,0.00,'Sales from shift 238531 on 2021-11-12 15:31:12 ','2021-11-12 15:31:12','',''),('5','175',3903616,'','20','3182',0.00,0.00,'Sales from shift 238539 on 2021-11-13 07:03:16 ','2021-11-13 07:03:16','',''),('5','175',3903617,'','6.1','3183',0.00,0.00,'Sales from shift 238539 on 2021-11-13 07:03:16 ','2021-11-13 07:03:16','',''),('5','175',3915369,'','20','3182',0.00,0.00,'Sales from shift 238683 on 2021-11-14 05:46:48 ','2021-11-14 05:46:48','',''),('5','175',3915370,'','6.1','3183',0.00,0.00,'Sales from shift 238683 on 2021-11-14 05:46:48 ','2021-11-14 05:46:48','',''),('5','175',3927836,'','20','3182',0.00,0.00,'Sales from shift 238876 on 2021-11-15 06:22:30 ','2021-11-15 06:22:30','',''),('5','175',3927837,'','6.1','3183',0.00,0.00,'Sales from shift 238876 on 2021-11-15 06:22:30 ','2021-11-15 06:22:30','',''),('5','175',3939381,'','20','3182',0.00,0.00,'Sales from shift 239139 on 2021-11-16 07:15:37 ','2021-11-16 07:15:37','',''),('5','175',3939382,'','6.1','3183',0.00,0.00,'Sales from shift 239139 on 2021-11-16 07:15:37 ','2021-11-16 07:15:37','',''),('5','175',3950206,'','20','3182',0.00,0.00,'Sales from shift 239344 on 2021-11-17 05:46:04 ','2021-11-17 05:46:04','',''),('5','175',3950207,'','6.1','3183',0.00,0.00,'Sales from shift 239344 on 2021-11-17 05:46:04 ','2021-11-17 05:46:04','',''),('5','175',3962349,'','20','3182',0.00,0.00,'Sales from shift 239603 on 2021-11-18 06:06:36 ','2021-11-18 06:06:36','',''),('5','175',3962350,'','6.1','3183',0.00,0.00,'Sales from shift 239603 on 2021-11-18 06:06:36 ','2021-11-18 06:06:36','',''),('5','175',3976044,'','20','3182',0.00,0.00,'Sales from shift 240016 on 2021-11-19 07:26:02 ','2021-11-19 07:26:02','',''),('5','175',3976045,'','6.1','3183',0.00,0.00,'Sales from shift 240016 on 2021-11-19 07:26:02 ','2021-11-19 07:26:02','',''),('5','175',3987007,'','20','3182',0.00,0.00,'Sales from shift 240079 on 2021-11-20 07:07:44 ','2021-11-20 07:07:44','',''),('5','175',3987008,'','6.1','3183',0.00,0.00,'Sales from shift 240079 on 2021-11-20 07:07:44 ','2021-11-20 07:07:44','',''),('5','175',3999374,'','20','3182',0.00,0.00,'Sales from shift 240380 on 2021-11-21 05:51:19 ','2021-11-21 05:51:19','',''),('5','175',3999375,'','6.1','3183',0.00,0.00,'Sales from shift 240380 on 2021-11-21 05:51:19 ','2021-11-21 05:51:19','',''),('5','175',4012374,'','20','3182',0.00,0.00,'Sales from shift 240561 on 2021-11-22 06:20:24 ','2021-11-22 06:20:24','',''),('5','175',4012375,'','6.1','3183',0.00,0.00,'Sales from shift 240561 on 2021-11-22 06:20:24 ','2021-11-22 06:20:24','',''),('5','175',4024904,'','20','3182',0.00,0.00,'Sales from shift 240800 on 2021-11-23 07:00:53 ','2021-11-23 07:00:53','',''),('5','175',4024905,'','6.1','3183',0.00,0.00,'Sales from shift 240800 on 2021-11-23 07:00:53 ','2021-11-23 07:00:53','',''),('5','175',4037896,'','20','3182',0.00,0.00,'Sales from shift 241165 on 2021-11-24 06:13:20 ','2021-11-24 06:13:20','',''),('5','175',4037897,'','6.1','3183',0.00,0.00,'Sales from shift 241165 on 2021-11-24 06:13:20 ','2021-11-24 06:13:20','',''),('5','175',4049891,'','20','3182',0.00,0.00,'Sales from shift 241247 on 2021-11-25 06:24:56 ','2021-11-25 06:24:56','',''),('5','175',4049892,'','6.1','3183',0.00,0.00,'Sales from shift 241247 on 2021-11-25 06:24:56 ','2021-11-25 06:24:56','',''),('5','175',4062940,'','20','3182',0.00,0.00,'Sales from shift 241518 on 2021-11-26 06:07:41 ','2021-11-26 06:07:41','',''),('5','175',4062941,'','6.1','3183',0.00,0.00,'Sales from shift 241518 on 2021-11-26 06:07:41 ','2021-11-26 06:07:41','',''),('5','175',4075559,'','20','3182',0.00,0.00,'Sales from shift 241800 on 2021-11-27 07:08:00 ','2021-11-27 07:08:00','',''),('5','175',4075560,'','6.1','3183',0.00,0.00,'Sales from shift 241800 on 2021-11-27 07:08:00 ','2021-11-27 07:08:00','',''),('5','175',4088499,'','20','3182',0.00,0.00,'Sales from shift 242009 on 2021-11-28 06:47:09 ','2021-11-28 06:47:09','',''),('5','175',4088500,'','6.1','3183',0.00,0.00,'Sales from shift 242009 on 2021-11-28 06:47:09 ','2021-11-28 06:47:09','',''),('5','175',4100665,'','20','3182',0.00,0.00,'Sales from shift 242291 on 2021-11-29 05:57:41 ','2021-11-29 05:57:41','',''),('5','175',4100666,'','6.1','3183',0.00,0.00,'Sales from shift 242291 on 2021-11-29 05:57:41 ','2021-11-29 05:57:41','',''),('5','175',4112826,'','20','3182',0.00,0.00,'Sales from shift 242478 on 2021-11-30 06:00:33 ','2021-11-30 06:00:33','',''),('5','175',4112827,'','6.1','3183',0.00,0.00,'Sales from shift 242478 on 2021-11-30 06:00:33 ','2021-11-30 06:00:33','',''),('5','175',4126429,'','20','3182',0.00,0.00,'Sales from shift 242757 on 2021-12-01 02:41:32 ','2021-12-01 02:41:32','',''),('5','175',4126430,'','6.1','3183',0.00,0.00,'Sales from shift 242757 on 2021-12-01 02:41:32 ','2021-12-01 02:41:32','',''),('5','175',4140425,'','20','3182',0.00,0.00,'Sales from shift 242927 on 2021-12-02 07:19:37 ','2021-12-02 07:19:37','',''),('5','175',4140426,'','6.1','3183',0.00,0.00,'Sales from shift 242927 on 2021-12-02 07:19:37 ','2021-12-02 07:19:37','',''),('5','175',4154156,'','20','3182',0.00,0.00,'Sales from shift 243216 on 2021-12-03 06:46:13 ','2021-12-03 06:46:13','',''),('5','175',4154157,'','6.1','3183',0.00,0.00,'Sales from shift 243216 on 2021-12-03 06:46:13 ','2021-12-03 06:46:13','',''),('5','175',4167361,'','20','3182',0.00,0.00,'Sales from shift 243429 on 2021-12-04 06:54:39 ','2021-12-04 06:54:39','',''),('5','175',4167362,'','6.1','3183',0.00,0.00,'Sales from shift 243429 on 2021-12-04 06:54:39 ','2021-12-04 06:54:39','',''),('5','175',4179705,'','20','3182',0.00,0.00,'Sales from shift 243673 on 2021-12-05 05:43:54 ','2021-12-05 05:43:54','',''),('5','175',4179706,'','6.1','3183',0.00,0.00,'Sales from shift 243673 on 2021-12-05 05:43:54 ','2021-12-05 05:43:54','',''),('5','175',4191907,'','20','3182',0.00,0.00,'Sales from shift 243908 on 2021-12-06 06:28:33 ','2021-12-06 06:28:33','',''),('5','175',4191908,'','6.1','3183',0.00,0.00,'Sales from shift 243908 on 2021-12-06 06:28:33 ','2021-12-06 06:28:33','',''),('5','175',4205980,'','20','3182',0.00,0.00,'Sales from shift 244090 on 2021-12-07 06:51:00 ','2021-12-07 06:51:00','',''),('5','175',4205981,'','6.1','3183',0.00,0.00,'Sales from shift 244090 on 2021-12-07 06:51:00 ','2021-12-07 06:51:00','',''),('5','175',4220888,'','20','3182',0.00,0.00,'Sales from shift 244357 on 2021-12-08 07:16:58 ','2021-12-08 07:16:58','',''),('5','175',4220889,'','6.1','3183',0.00,0.00,'Sales from shift 244357 on 2021-12-08 07:16:58 ','2021-12-08 07:16:58','',''),('5','175',4232011,'','20','3182',0.00,0.00,'Sales from shift 244559 on 2021-12-09 05:40:50 ','2021-12-09 05:40:50','',''),('5','175',4232012,'','6.1','3183',0.00,0.00,'Sales from shift 244559 on 2021-12-09 05:40:50 ','2021-12-09 05:40:50','',''),('5','175',4246399,'','20','3182',0.00,0.00,'Sales from shift 244779 on 2021-12-10 06:14:47 ','2021-12-10 06:14:47','',''),('5','175',4246400,'','6.1','3183',0.00,0.00,'Sales from shift 244779 on 2021-12-10 06:14:47 ','2021-12-10 06:14:47','',''),('5','175',4254010,'','24','3186',0.00,7326000.00,'Purchase Id 86844 for 44,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-12-10 13:53:30','',''),('5','175',4254011,'','supplier','218',7326000.00,0.00,'Purchase Id 86844 for 44,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2021-12-10 13:53:30','',''),('5','175',4260288,'','20','3182',1352148.60,0.00,'Sales from shift 245168 on 2021-12-11 06:58:48 ','2021-12-11 06:58:48','',''),('5','175',4260289,'','6.1','3183',0.00,1352148.60,'Sales from shift 245168 on 2021-12-11 06:58:48 ','2021-12-11 06:58:48','',''),('5','175',4273220,'','20','3182',1794544.95,0.00,'Sales from shift 245243 on 2021-12-12 06:49:17 ','2021-12-12 06:49:17','',''),('5','175',4273221,'','6.1','3183',0.00,1794544.95,'Sales from shift 245243 on 2021-12-12 06:49:17 ','2021-12-12 06:49:17','',''),('5','175',4284966,'','20','3182',1327195.65,0.00,'Sales from shift 245518 on 2021-12-13 05:56:56 ','2021-12-13 05:56:56','',''),('5','175',4284967,'','6.1','3183',0.00,1327195.65,'Sales from shift 245518 on 2021-12-13 05:56:56 ','2021-12-13 05:56:56','',''),('5','175',4295531,'','6.1','3183',22650.00,0.00,'Payment Id 375935 for invoice:245168, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295532,'','supplier','218',0.00,22650.00,'Payment Id 375935 for invoice:245168, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295533,'','2','3235',13600.00,0.00,'Payment Id 375933 for invoice:0133002, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295534,'','supplier','218',0.00,13600.00,'Payment Id 375933 for invoice:0133002, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295535,'','2','3235',1315925.00,0.00,'Payment Id 375927 for invoice:245168, receipt: 0133002 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295536,'','supplier','218',0.00,1315925.00,'Payment Id 375927 for invoice:245168, receipt: 0133002 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:44:50','',''),('5','175',4295551,'','6.1','3183',47650.00,0.00,'Payment Id 375943 for invoice:245243, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295552,'','supplier','218',0.00,47650.00,'Payment Id 375943 for invoice:245243, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295553,'','2','3235',8000.00,0.00,'Payment Id 375939 for invoice:245243, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295554,'','supplier','218',0.00,8000.00,'Payment Id 375939 for invoice:245243, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295555,'','2','3235',1739055.00,0.00,'Payment Id 375938 for invoice:245243, receipt: 0134486 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295556,'','supplier','218',0.00,1739055.00,'Payment Id 375938 for invoice:245243, receipt: 0134486 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:36','',''),('5','175',4295565,'','6.1','3183',412650.00,0.00,'Payment Id 375951 for invoice:245518, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4295566,'','supplier','218',0.00,412650.00,'Payment Id 375951 for invoice:245518, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4295567,'','2','3235',4000.00,0.00,'Payment Id 375949 for invoice:245518, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4295568,'','supplier','218',0.00,4000.00,'Payment Id 375949 for invoice:245518, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4295569,'','2','3235',910546.00,0.00,'Payment Id 375946 for invoice:245518, receipt: 0133004 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4295570,'','supplier','218',0.00,910546.00,'Payment Id 375946 for invoice:245518, receipt: 0133004 by SALBAS OIL & GAS NIG LTD','2021-12-13 15:45:59','',''),('5','175',4298226,'','20','3182',1163091.60,0.00,'Sales from shift 245742 on 2021-12-14 06:04:22 ','2021-12-14 06:04:22','',''),('5','175',4298227,'','6.1','3183',0.00,1163091.60,'Sales from shift 245742 on 2021-12-14 06:04:22 ','2021-12-14 06:04:22','',''),('5','175',4310504,'','20','3182',1363055.10,0.00,'Sales from shift 245992 on 2021-12-15 06:38:23 ','2021-12-15 06:38:23','',''),('5','175',4310505,'','6.1','3183',0.00,1363055.10,'Sales from shift 245992 on 2021-12-15 06:38:23 ','2021-12-15 06:38:23','',''),('5','175',4313795,'','6.1','3183',29350.00,0.00,'Payment Id 376402 for invoice:245742, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:07','',''),('5','175',4313796,'','supplier','218',0.00,29350.00,'Payment Id 376402 for invoice:245742, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:07','',''),('5','175',4313797,'','2','3235',13000.00,0.00,'Payment Id 376401 for invoice:245742, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:07','',''),('5','175',4313798,'','supplier','218',0.00,13000.00,'Payment Id 376401 for invoice:245742, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:07','',''),('5','175',4313823,'','2','3235',1120740.00,0.00,'Payment Id 376400 for invoice:245742, receipt: 0133005 by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:47','',''),('5','175',4313824,'','supplier','218',0.00,1120740.00,'Payment Id 376400 for invoice:245742, receipt: 0133005 by SALBAS OIL & GAS NIG LTD','2021-12-15 09:41:47','',''),('5','175',4324753,'','20','3182',351141.45,0.00,'Sales from shift 246289 on 2021-12-16 06:50:04 ','2021-12-16 06:50:04','',''),('5','175',4324754,'','6.1','3183',0.00,351141.45,'Sales from shift 246289 on 2021-12-16 06:50:04 ','2021-12-16 06:50:04','',''),('5','175',4339311,'','20','3182',0.00,0.00,'Sales from shift 246476 on 2021-12-17 06:09:55 ','2021-12-17 06:09:55','',''),('5','175',4339312,'','6.1','3183',0.00,0.00,'Sales from shift 246476 on 2021-12-17 06:09:55 ','2021-12-17 06:09:55','',''),('5','175',4340674,'','6.1','3183',17650.00,0.00,'Payment Id 377512 for invoice:246289, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340675,'','supplier','218',0.00,17650.00,'Payment Id 377512 for invoice:246289, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340676,'','2','3235',333500.00,0.00,'Payment Id 377511 for invoice:246289, receipt: 0133048 by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340677,'','supplier','218',0.00,333500.00,'Payment Id 377511 for invoice:246289, receipt: 0133048 by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340678,'','6.1','3183',17650.00,0.00,'Payment Id 376935 for invoice:245992, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340679,'','supplier','218',0.00,17650.00,'Payment Id 376935 for invoice:245992, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340680,'','2','3235',10650.00,0.00,'Payment Id 376934 for invoice:245992, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340681,'','supplier','218',0.00,10650.00,'Payment Id 376934 for invoice:245992, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340682,'','2','3235',1334755.00,0.00,'Payment Id 376932 for invoice:245992, receipt: 086293 by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4340683,'','supplier','218',0.00,1334755.00,'Payment Id 376932 for invoice:245992, receipt: 086293 by SALBAS OIL & GAS NIG LTD','2021-12-17 07:40:01','',''),('5','175',4353378,'','20','3182',0.00,0.00,'Sales from shift 246704 on 2021-12-18 07:01:55 ','2021-12-18 07:01:55','',''),('5','175',4353379,'','6.1','3183',0.00,0.00,'Sales from shift 246704 on 2021-12-18 07:01:55 ','2021-12-18 07:01:55','',''),('5','175',4362981,'','24','3186',0.00,4657500.00,'Purchase Id 87536 for 13,500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2021-12-18 14:32:08','',''),('5','175',4362982,'','supplier','218',4657500.00,0.00,'Purchase Id 87536 for 13,500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2021-12-18 14:32:08','',''),('5','175',4369210,'','20','3182',34248.15,0.00,'Sales from shift 246968 on 2021-12-19 07:11:24 ','2021-12-19 07:11:24','',''),('5','175',4369211,'','6.1','3183',0.00,34248.15,'Sales from shift 246968 on 2021-12-19 07:11:24 ','2021-12-19 07:11:24','',''),('5','175',4382731,'','20','3182',80854.20,0.00,'Sales from shift 247215 on 2021-12-20 06:52:52 ','2021-12-20 06:52:52','',''),('5','175',4382732,'','6.1','3183',0.00,80854.20,'Sales from shift 247215 on 2021-12-20 06:52:52 ','2021-12-20 06:52:52','',''),('5','175',4398011,'','20','3182',131852.10,0.00,'Sales from shift 247462 on 2021-12-21 09:21:58 ','2021-12-21 09:21:58','',''),('5','175',4398012,'','6.1','3183',0.00,131852.10,'Sales from shift 247462 on 2021-12-21 09:21:58 ','2021-12-21 09:21:58','',''),('5','175',4398217,'','6.1','3183',17650.00,0.00,'Payment Id 379491 for invoice:247215, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398218,'','supplier','218',0.00,17650.00,'Payment Id 379491 for invoice:247215, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398219,'','2','3235',63205.00,0.00,'Payment Id 379490 for invoice:247215, receipt: 0133040 by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398220,'','supplier','218',0.00,63205.00,'Payment Id 379490 for invoice:247215, receipt: 0133040 by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398221,'','6.1','3183',17650.00,0.00,'Payment Id 379487 for invoice:246968, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398222,'','supplier','218',0.00,17650.00,'Payment Id 379487 for invoice:246968, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398223,'','2','3235',16600.00,0.00,'Payment Id 379485 for invoice:246968, receipt: 0133039 by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4398224,'','supplier','218',0.00,16600.00,'Payment Id 379485 for invoice:246968, receipt: 0133039 by SALBAS OIL & GAS NIG LTD','2021-12-21 09:31:35','',''),('5','175',4410256,'','6.1','3183',24650.00,0.00,'Payment Id 380034 for invoice:247462, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-22 06:27:41','',''),('5','175',4410257,'','supplier','218',0.00,24650.00,'Payment Id 380034 for invoice:247462, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-22 06:27:41','',''),('5','175',4410258,'','2','3235',107200.00,0.00,'Payment Id 380032 for invoice:247462, receipt: 0133038 by SALBAS OIL & GAS NIG LTD','2021-12-22 06:27:41','',''),('5','175',4410259,'','supplier','218',0.00,107200.00,'Payment Id 380032 for invoice:247462, receipt: 0133038 by SALBAS OIL & GAS NIG LTD','2021-12-22 06:27:41','',''),('5','175',4410263,'','20','3182',125193.60,0.00,'Sales from shift 247746 on 2021-12-22 06:28:10 ','2021-12-22 06:28:10','',''),('5','175',4410264,'','6.1','3183',0.00,125193.60,'Sales from shift 247746 on 2021-12-22 06:28:10 ','2021-12-22 06:28:10','',''),('5','175',4426340,'','20','3182',124434.60,0.00,'Sales from shift 248012 on 2021-12-23 06:23:16 ','2021-12-23 06:23:16','',''),('5','175',4426341,'','6.1','3183',0.00,124434.60,'Sales from shift 248012 on 2021-12-23 06:23:16 ','2021-12-23 06:23:16','',''),('5','175',4426346,'','6.1','3183',17650.00,0.00,'Payment Id 380754 for invoice:247746, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-23 06:23:33','',''),('5','175',4426347,'','supplier','218',0.00,17650.00,'Payment Id 380754 for invoice:247746, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-23 06:23:33','',''),('5','175',4426348,'','2','3235',107500.00,0.00,'Payment Id 380752 for invoice:247746, receipt: 0133011 by SALBAS OIL & GAS NIG LTD','2021-12-23 06:23:33','',''),('5','175',4426349,'','supplier','218',0.00,107500.00,'Payment Id 380752 for invoice:247746, receipt: 0133011 by SALBAS OIL & GAS NIG LTD','2021-12-23 06:23:33','',''),('5','175',4443291,'','20','3182',120853.50,0.00,'Sales from shift 248241 on 2021-12-24 07:19:22 ','2021-12-24 07:19:22','',''),('5','175',4443292,'','6.1','3183',0.00,120853.50,'Sales from shift 248241 on 2021-12-24 07:19:22 ','2021-12-24 07:19:22','',''),('5','175',4468725,'','20','3182',131120.70,0.00,'Sales from shift 248577 on 2021-12-25 14:07:31 ','2021-12-25 14:07:31','',''),('5','175',4468726,'','6.1','3183',0.00,131120.70,'Sales from shift 248577 on 2021-12-25 14:07:31 ','2021-12-25 14:07:31','',''),('5','175',4472153,'','20','3182',162691.65,0.00,'Sales from shift 248821 on 2021-12-26 07:31:00 ','2021-12-26 07:31:00','',''),('5','175',4472154,'','6.1','3183',0.00,162691.65,'Sales from shift 248821 on 2021-12-26 07:31:00 ','2021-12-26 07:31:00','',''),('5','175',4481506,'','20','3182',205254.30,0.00,'Sales from shift 248945 on 2021-12-27 07:39:49 ','2021-12-27 07:39:49','',''),('5','175',4481507,'','6.1','3183',0.00,205254.30,'Sales from shift 248945 on 2021-12-27 07:39:49 ','2021-12-27 07:39:49','',''),('5','175',4488729,'','6.1','3183',17650.00,0.00,'Payment Id 381289 for invoice:248012, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:01','',''),('5','175',4488730,'','supplier','218',0.00,17650.00,'Payment Id 381289 for invoice:248012, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:01','',''),('5','175',4488731,'','2','3235',106780.00,0.00,'Payment Id 381288 for invoice:248012, receipt: 0133012 by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:01','',''),('5','175',4488732,'','supplier','218',0.00,106780.00,'Payment Id 381288 for invoice:248012, receipt: 0133012 by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:01','',''),('5','175',4488737,'','6.1','3183',17650.00,0.00,'Payment Id 381912 for invoice:248241, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:24','',''),('5','175',4488738,'','supplier','218',0.00,17650.00,'Payment Id 381912 for invoice:248241, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:24','',''),('5','175',4488739,'','2','3235',103200.00,0.00,'Payment Id 381911 for invoice:248241, receipt: 0133015 by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:24','',''),('5','175',4488740,'','supplier','218',0.00,103200.00,'Payment Id 381911 for invoice:248241, receipt: 0133015 by SALBAS OIL & GAS NIG LTD','2021-12-27 14:53:24','',''),('5','175',4491832,'','20','3182',254161.50,0.00,'Sales from shift 249197 on 2021-12-28 07:34:17 ','2021-12-28 07:34:17','',''),('5','175',4491833,'','6.1','3183',0.00,254161.50,'Sales from shift 249197 on 2021-12-28 07:34:17 ','2021-12-28 07:34:17','',''),('5','175',4502615,'','20','3182',102037.20,0.00,'Sales from shift 249435 on 2021-12-29 06:44:22 ','2021-12-29 06:44:22','',''),('5','175',4502616,'','6.1','3183',0.00,102037.20,'Sales from shift 249435 on 2021-12-29 06:44:22 ','2021-12-29 06:44:22','',''),('5','175',4515122,'','20','3182',119594.25,0.00,'Sales from shift 249651 on 2021-12-30 06:55:45 ','2021-12-30 06:55:45','',''),('5','175',4515123,'','6.1','3183',0.00,119594.25,'Sales from shift 249651 on 2021-12-30 06:55:45 ','2021-12-30 06:55:45','',''),('5','175',4517609,'','6.1','3183',17650.00,0.00,'Payment Id 384200 for invoice:249435, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:45','',''),('5','175',4517610,'','supplier','218',0.00,17650.00,'Payment Id 384200 for invoice:249435, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:45','',''),('5','175',4517611,'','2','3235',84390.00,0.00,'Payment Id 384198 for invoice:249435, receipt: 0133021 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:45','',''),('5','175',4517612,'','supplier','218',0.00,84390.00,'Payment Id 384198 for invoice:249435, receipt: 0133021 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:45','',''),('5','175',4517613,'','6.1','3183',17650.00,0.00,'Payment Id 384196 for invoice:249197, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517614,'','supplier','218',0.00,17650.00,'Payment Id 384196 for invoice:249197, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517615,'','2','3235',236510.00,0.00,'Payment Id 384194 for invoice:249197, receipt: 0133022 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517616,'','supplier','218',0.00,236510.00,'Payment Id 384194 for invoice:249197, receipt: 0133022 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517617,'','6.1','3183',17650.00,0.00,'Payment Id 384191 for invoice:248945, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517618,'','supplier','218',0.00,17650.00,'Payment Id 384191 for invoice:248945, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517619,'','2','3235',187605.00,0.00,'Payment Id 384189 for invoice:248945, receipt: 0133013 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517620,'','supplier','218',0.00,187605.00,'Payment Id 384189 for invoice:248945, receipt: 0133013 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517621,'','6.1','3183',17650.00,0.00,'Payment Id 384188 for invoice:248821, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517622,'','supplier','218',0.00,17650.00,'Payment Id 384188 for invoice:248821, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517623,'','2','3235',145045.00,0.00,'Payment Id 384187 for invoice:248821, receipt: 0133014 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517624,'','supplier','218',0.00,145045.00,'Payment Id 384187 for invoice:248821, receipt: 0133014 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517625,'','6.1','3183',17650.00,0.00,'Payment Id 384186 for invoice:248577, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517626,'','supplier','218',0.00,17650.00,'Payment Id 384186 for invoice:248577, receipt:  by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517627,'','2','3235',113470.00,0.00,'Payment Id 384184 for invoice:248577, receipt: 0133016 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4517628,'','supplier','218',0.00,113470.00,'Payment Id 384184 for invoice:248577, receipt: 0133016 by SALBAS OIL & GAS NIG LTD','2021-12-30 08:51:46','',''),('5','175',4542673,'','20','3182',127384.35,0.00,'Sales from shift 249920 on 2021-12-31 18:59:45 ','2021-12-31 18:59:45','',''),('5','175',4542674,'','6.1','3183',0.00,127384.35,'Sales from shift 249920 on 2021-12-31 18:59:45 ','2021-12-31 18:59:45','',''),('5','175',4544191,'','20','3182',124231.05,0.00,'Sales from shift 250288 on 2022-01-01 07:48:29 ','2022-01-01 07:48:29','',''),('5','175',4544192,'','6.1','3183',0.00,124231.05,'Sales from shift 250288 on 2022-01-01 07:48:29 ','2022-01-01 07:48:29','',''),('5','175',4554123,'','20','3182',188180.25,0.00,'Sales from shift 250470 on 2022-01-02 06:43:57 ','2022-01-02 06:43:57','',''),('5','175',4554124,'','6.1','3183',0.00,188180.25,'Sales from shift 250470 on 2022-01-02 06:43:57 ','2022-01-02 06:43:57','',''),('5','175',4563144,'','6.1','3183',17650.00,0.00,'Payment Id 385360 for invoice:249920, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563145,'','supplier','218',0.00,17650.00,'Payment Id 385360 for invoice:249920, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563146,'','2','3235',109230.00,0.00,'Payment Id 385357 for invoice:249920, receipt: 0133017 by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563147,'','supplier','218',0.00,109230.00,'Payment Id 385357 for invoice:249920, receipt: 0133017 by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563148,'','6.1','3183',17650.00,0.00,'Payment Id 384730 for invoice:249651, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563149,'','supplier','218',0.00,17650.00,'Payment Id 384730 for invoice:249651, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563150,'','2','3235',101720.00,0.00,'Payment Id 384729 for invoice:249651, receipt: 0133028 by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4563151,'','supplier','218',0.00,101720.00,'Payment Id 384729 for invoice:249651, receipt: 0133028 by SALBAS OIL & GAS NIG LTD','2022-01-02 17:30:22','',''),('5','175',4570882,'','20','3182',134822.55,0.00,'Sales from shift 250667 on 2022-01-03 14:05:06 ','2022-01-03 14:05:06','',''),('5','175',4570883,'','6.1','3183',0.00,134822.55,'Sales from shift 250667 on 2022-01-03 14:05:06 ','2022-01-03 14:05:06','',''),('5','175',4575349,'','20','3182',127646.55,0.00,'Sales from shift 250969 on 2022-01-04 07:03:53 ','2022-01-04 07:03:53','',''),('5','175',4575350,'','6.1','3183',0.00,127646.55,'Sales from shift 250969 on 2022-01-04 07:03:53 ','2022-01-04 07:03:53','',''),('5','175',4589773,'','20','3182',167093.85,0.00,'Sales from shift 251075 on 2022-01-05 07:33:37 ','2022-01-05 07:33:37','',''),('5','175',4589774,'','6.1','3183',0.00,167093.85,'Sales from shift 251075 on 2022-01-05 07:33:37 ','2022-01-05 07:33:37','',''),('5','175',4596766,'','24','3186',0.00,7359000.00,'Purchase Id 88885 for 44,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-05 13:09:00','',''),('5','175',4596767,'','supplier','218',7359000.00,0.00,'Purchase Id 88885 for 44,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-05 13:09:00','',''),('5','175',4601936,'','6.1','3183',17650.00,0.00,'Payment Id 387158 for invoice:250969, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601937,'','supplier','218',0.00,17650.00,'Payment Id 387158 for invoice:250969, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601938,'','2','3235',109995.00,0.00,'Payment Id 387157 for invoice:250969, receipt: 013080304 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601939,'','supplier','218',0.00,109995.00,'Payment Id 387157 for invoice:250969, receipt: 013080304 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601940,'','6.1','3183',17650.00,0.00,'Payment Id 387151 for invoice:250667, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601941,'','supplier','218',0.00,17650.00,'Payment Id 387151 for invoice:250667, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601942,'','2','3235',117170.00,0.00,'Payment Id 387150 for invoice:250667, receipt: 0133020 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601943,'','supplier','218',0.00,117170.00,'Payment Id 387150 for invoice:250667, receipt: 0133020 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601944,'','6.1','3183',17650.00,0.00,'Payment Id 387145 for invoice:250470, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601945,'','supplier','218',0.00,17650.00,'Payment Id 387145 for invoice:250470, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601946,'','2','3235',170530.00,0.00,'Payment Id 387144 for invoice:250470, receipt: 0133018 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601947,'','supplier','218',0.00,170530.00,'Payment Id 387144 for invoice:250470, receipt: 0133018 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601948,'','6.1','3183',17650.00,0.00,'Payment Id 387141 for invoice:250288, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601949,'','supplier','218',0.00,17650.00,'Payment Id 387141 for invoice:250288, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601950,'','2','3235',106580.00,0.00,'Payment Id 387140 for invoice:250288, receipt: 0133019 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4601951,'','supplier','218',0.00,106580.00,'Payment Id 387140 for invoice:250288, receipt: 0133019 by SALBAS OIL & GAS NIG LTD','2022-01-05 17:19:20','',''),('5','175',4604699,'','20','3182',1569175.65,0.00,'Sales from shift 251321 on 2022-01-06 07:45:18 ','2022-01-06 07:45:18','',''),('5','175',4604700,'','6.1','3183',0.00,1569175.65,'Sales from shift 251321 on 2022-01-06 07:45:18 ','2022-01-06 07:45:18','',''),('5','175',4619262,'','20','3182',1702808.25,0.00,'Sales from shift 251569 on 2022-01-07 09:07:28 ','2022-01-07 09:07:28','',''),('5','175',4619263,'','6.1','3183',0.00,1702808.25,'Sales from shift 251569 on 2022-01-07 09:07:28 ','2022-01-07 09:07:28','',''),('5','175',4630677,'','20','3182',1918673.70,0.00,'Sales from shift 251827 on 2022-01-08 07:57:07 ','2022-01-08 07:57:07','',''),('5','175',4630678,'','6.1','3183',0.00,1918673.70,'Sales from shift 251827 on 2022-01-08 07:57:07 ','2022-01-08 07:57:07','',''),('5','175',4644675,'','20','3182',2446139.10,0.00,'Sales from shift 252043 on 2022-01-09 08:01:29 ','2022-01-09 08:01:29','',''),('5','175',4644676,'','6.1','3183',0.00,2446139.10,'Sales from shift 252043 on 2022-01-09 08:01:29 ','2022-01-09 08:01:29','',''),('5','175',4657105,'','2','3235',10000.00,0.00,'Payment Id 389017 for invoice:251569, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657106,'','supplier','218',0.00,10000.00,'Payment Id 389017 for invoice:251569, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657107,'','6.1','3183',17650.00,0.00,'Payment Id 389015 for invoice:251569, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657108,'','supplier','218',0.00,17650.00,'Payment Id 389015 for invoice:251569, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657109,'','2','3235',1675160.00,0.00,'Payment Id 389013 for invoice:251569, receipt: 0133037 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657110,'','supplier','218',0.00,1675160.00,'Payment Id 389013 for invoice:251569, receipt: 0133037 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657111,'','2','3235',28500.00,0.00,'Payment Id 388488 for invoice:251321, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657112,'','supplier','218',0.00,28500.00,'Payment Id 388488 for invoice:251321, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657113,'','6.1','3183',315150.00,0.00,'Payment Id 388486 for invoice:251321, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657114,'','supplier','218',0.00,315150.00,'Payment Id 388486 for invoice:251321, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657115,'','2','3235',1225520.00,0.00,'Payment Id 388482 for invoice:251321, receipt: 0133031 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657116,'','supplier','218',0.00,1225520.00,'Payment Id 388482 for invoice:251321, receipt: 0133031 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657117,'','6.1','3183',142650.00,0.00,'Payment Id 387739 for invoice:251075, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657118,'','supplier','218',0.00,142650.00,'Payment Id 387739 for invoice:251075, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657119,'','2','3235',24440.00,0.00,'Payment Id 387735 for invoice:251075, receipt: 0133044 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657120,'','supplier','218',0.00,24440.00,'Payment Id 387735 for invoice:251075, receipt: 0133044 by SALBAS OIL & GAS NIG LTD','2022-01-09 21:36:37','',''),('5','175',4657425,'','20','3182',1064416.50,0.00,'Sales from shift 252280 on 2022-01-10 07:00:57 ','2022-01-10 07:00:57','',''),('5','175',4657426,'','6.1','3183',0.00,1064416.50,'Sales from shift 252280 on 2022-01-10 07:00:57 ','2022-01-10 07:00:57','',''),('5','175',4671139,'','20','3182',170826.75,0.00,'Sales from shift 252570 on 2022-01-11 05:29:51 ','2022-01-11 05:29:51','',''),('5','175',4671140,'','6.1','3183',0.00,170826.75,'Sales from shift 252570 on 2022-01-11 05:29:51 ','2022-01-11 05:29:51','',''),('5','175',4675380,'','6.1','3183',29350.00,0.00,'Payment Id 390948 for invoice:252570, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675381,'','supplier','218',0.00,29350.00,'Payment Id 390948 for invoice:252570, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675382,'','2','3235',141580.00,0.00,'Payment Id 390947 for invoice:252570, receipt: 0133029 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675383,'','supplier','218',0.00,141580.00,'Payment Id 390947 for invoice:252570, receipt: 0133029 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675384,'','2','3235',12000.00,0.00,'Payment Id 390469 for invoice:252280, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675385,'','supplier','218',0.00,12000.00,'Payment Id 390469 for invoice:252280, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675386,'','6.1','3183',17650.00,0.00,'Payment Id 390466 for invoice:252280, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675387,'','supplier','218',0.00,17650.00,'Payment Id 390466 for invoice:252280, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675388,'','2','3235',1034420.00,0.00,'Payment Id 390465 for invoice:252280, receipt: 0133035 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675389,'','supplier','218',0.00,1034420.00,'Payment Id 390465 for invoice:252280, receipt: 0133035 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675390,'','2','3235',31000.00,0.00,'Payment Id 390462 for invoice:252043, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675391,'','supplier','218',0.00,31000.00,'Payment Id 390462 for invoice:252043, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675392,'','6.1','3183',17650.00,0.00,'Payment Id 390460 for invoice:252043, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675393,'','supplier','218',0.00,17650.00,'Payment Id 390460 for invoice:252043, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675394,'','2','3235',2397495.00,0.00,'Payment Id 390456 for invoice:252043, receipt: 0133034 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675395,'','supplier','218',0.00,2397495.00,'Payment Id 390456 for invoice:252043, receipt: 0133034 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675396,'','6.1','3183',17650.00,0.00,'Payment Id 390446 for invoice:251827, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675397,'','supplier','218',0.00,17650.00,'Payment Id 390446 for invoice:251827, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675398,'','2','3235',1901015.00,0.00,'Payment Id 390445 for invoice:251827, receipt: 0133033 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4675399,'','supplier','218',0.00,1901015.00,'Payment Id 390445 for invoice:251827, receipt: 0133033 by SALBAS OIL & GAS NIG LTD','2022-01-11 11:05:25','',''),('5','175',4686362,'','20','3182',115578.45,0.00,'Sales from shift 252769 on 2022-01-12 07:48:34 ','2022-01-12 07:48:34','',''),('5','175',4686363,'','6.1','3183',0.00,115578.45,'Sales from shift 252769 on 2022-01-12 07:48:34 ','2022-01-12 07:48:34','',''),('5','175',4700849,'','20','3182',107650.35,0.00,'Sales from shift 253031 on 2022-01-13 07:33:56 ','2022-01-13 07:33:56','',''),('5','175',4700850,'','6.1','3183',0.00,107650.35,'Sales from shift 253031 on 2022-01-13 07:33:56 ','2022-01-13 07:33:56','',''),('5','175',4706070,'','6.1','3183',17650.00,0.00,'Payment Id 391668 for invoice:252769, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-13 12:02:53','',''),('5','175',4706071,'','supplier','218',0.00,17650.00,'Payment Id 391668 for invoice:252769, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-13 12:02:53','',''),('5','175',4706072,'','2','4075',97930.00,0.00,'Payment Id 391667 for invoice:252769, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-13 12:02:53','',''),('5','175',4706073,'','supplier','218',0.00,97930.00,'Payment Id 391667 for invoice:252769, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-13 12:02:53','',''),('5','175',4716463,'','20','3182',94954.35,0.00,'Sales from shift 253245 on 2022-01-14 09:29:54 ','2022-01-14 09:29:54','',''),('5','175',4716464,'','6.1','3183',0.00,94954.35,'Sales from shift 253245 on 2022-01-14 09:29:54 ','2022-01-14 09:29:54','',''),('5','175',4717629,'','6.1','3183',17650.00,0.00,'Payment Id 392175 for invoice:253031, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-14 10:15:19','',''),('5','175',4717630,'','supplier','218',0.00,17650.00,'Payment Id 392175 for invoice:253031, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-14 10:15:19','',''),('5','175',4717631,'','2','4075',90000.00,0.00,'Payment Id 392173 for invoice:253031, receipt: 016197 by SALBAS OIL & GAS NIG LTD','2022-01-14 10:15:19','',''),('5','175',4717632,'','supplier','218',0.00,90000.00,'Payment Id 392173 for invoice:253031, receipt: 016197 by SALBAS OIL & GAS NIG LTD','2022-01-14 10:15:19','',''),('5','175',4724119,'','6.1','3183',17650.00,0.00,'Payment Id 392858 for invoice:253245, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-14 16:29:10','',''),('5','175',4724120,'','supplier','218',0.00,17650.00,'Payment Id 392858 for invoice:253245, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-14 16:29:10','',''),('5','175',4724121,'','2','4075',77300.00,0.00,'Payment Id 392857 for invoice:253245, receipt: 0029 by SALBAS OIL & GAS NIG LTD','2022-01-14 16:29:10','',''),('5','175',4724122,'','supplier','218',0.00,77300.00,'Payment Id 392857 for invoice:253245, receipt: 0029 by SALBAS OIL & GAS NIG LTD','2022-01-14 16:29:10','',''),('5','175',4727960,'','20','3182',110789.85,0.00,'Sales from shift 253545 on 2022-01-15 07:14:33 ','2022-01-15 07:14:33','',''),('5','175',4727961,'','6.1','3183',0.00,110789.85,'Sales from shift 253545 on 2022-01-15 07:14:33 ','2022-01-15 07:14:33','',''),('5','175',4743842,'','20','3182',86453.55,0.00,'Sales from shift 253792 on 2022-01-16 07:09:14 ','2022-01-16 07:09:14','',''),('5','175',4743843,'','6.1','3183',0.00,86453.55,'Sales from shift 253792 on 2022-01-16 07:09:14 ','2022-01-16 07:09:14','',''),('5','175',4757767,'','20','3182',108098.85,0.00,'Sales from shift 254000 on 2022-01-17 07:12:37 ','2022-01-17 07:12:37','',''),('5','175',4757768,'','6.1','3183',0.00,108098.85,'Sales from shift 254000 on 2022-01-17 07:12:37 ','2022-01-17 07:12:37','',''),('5','175',4770062,'','24','3186',0.00,6567000.00,'Purchase Id 89783 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-17 18:08:20','',''),('5','175',4770063,'','supplier','218',6567000.00,0.00,'Purchase Id 89783 for 39,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-17 18:08:20','',''),('5','175',4771911,'','20','3182',62796.90,0.00,'Sales from shift 254274 on 2022-01-18 08:36:59 ','2022-01-18 08:36:59','',''),('5','175',4771912,'','6.1','3183',0.00,62796.90,'Sales from shift 254274 on 2022-01-18 08:36:59 ','2022-01-18 08:36:59','',''),('5','175',4775203,'','6.1','3183',17650.00,0.00,'Payment Id 394985 for invoice:254274, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775204,'','supplier','218',0.00,17650.00,'Payment Id 394985 for invoice:254274, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775205,'','2','4075',45145.00,0.00,'Payment Id 394983 for invoice:254274, receipt: 0225 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775206,'','supplier','218',0.00,45145.00,'Payment Id 394983 for invoice:254274, receipt: 0225 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775207,'','6.1','3183',17650.00,0.00,'Payment Id 394539 for invoice:254000, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775208,'','supplier','218',0.00,17650.00,'Payment Id 394539 for invoice:254000, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775209,'','2','4075',90445.00,0.00,'Payment Id 394537 for invoice:254000, receipt: 020 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775210,'','supplier','218',0.00,90445.00,'Payment Id 394537 for invoice:254000, receipt: 020 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775211,'','6.1','3183',17650.00,0.00,'Payment Id 394536 for invoice:253792, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775212,'','supplier','218',0.00,17650.00,'Payment Id 394536 for invoice:253792, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775213,'','2','4075',68805.00,0.00,'Payment Id 394534 for invoice:253792, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775214,'','supplier','218',0.00,68805.00,'Payment Id 394534 for invoice:253792, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775215,'','6.1','3183',17650.00,0.00,'Payment Id 394533 for invoice:253545, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775216,'','supplier','218',0.00,17650.00,'Payment Id 394533 for invoice:253545, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775217,'','2','4075',93140.00,0.00,'Payment Id 394531 for invoice:253545, receipt: 028 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4775218,'','supplier','218',0.00,93140.00,'Payment Id 394531 for invoice:253545, receipt: 028 by SALBAS OIL & GAS NIG LTD','2022-01-18 11:16:34','',''),('5','175',4786777,'','20','3182',2007399.90,0.00,'Sales from shift 254517 on 2022-01-19 08:42:08 ','2022-01-19 08:42:08','',''),('5','175',4786778,'','6.1','3183',0.00,2007399.90,'Sales from shift 254517 on 2022-01-19 08:42:08 ','2022-01-19 08:42:08','',''),('5','175',4792252,'','2','3235',9000.00,0.00,'Payment Id 395627 for invoice:254517, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4792253,'','supplier','218',0.00,9000.00,'Payment Id 395627 for invoice:254517, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4792254,'','6.1','3183',29650.00,0.00,'Payment Id 395624 for invoice:254517, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4792255,'','supplier','218',0.00,29650.00,'Payment Id 395624 for invoice:254517, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4792256,'','2','4075',1968750.00,0.00,'Payment Id 395619 for invoice:254517, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4792257,'','supplier','218',0.00,1968750.00,'Payment Id 395619 for invoice:254517, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-19 13:06:06','',''),('5','175',4801463,'','20','3182',1764483.60,0.00,'Sales from shift 254768 on 2022-01-20 08:07:14 ','2022-01-20 08:07:14','',''),('5','175',4801464,'','6.1','3183',0.00,1764483.60,'Sales from shift 254768 on 2022-01-20 08:07:14 ','2022-01-20 08:07:14','',''),('5','175',4817131,'','20','3182',1621052.40,0.00,'Sales from shift 255031 on 2022-01-21 08:32:36 ','2022-01-21 08:32:36','',''),('5','175',4817132,'','6.1','3183',0.00,1621052.40,'Sales from shift 255031 on 2022-01-21 08:32:36 ','2022-01-21 08:32:36','',''),('5','175',4831965,'','20','3182',1187613.90,0.00,'Sales from shift 255247 on 2022-01-22 08:04:44 ','2022-01-22 08:04:44','',''),('5','175',4831966,'','6.1','3183',0.00,1187613.90,'Sales from shift 255247 on 2022-01-22 08:04:44 ','2022-01-22 08:04:44','',''),('5','175',4846923,'','20','3182',0.00,0.00,'Sales from shift 255545 on 2022-01-23 07:21:36 ','2022-01-23 07:21:36','',''),('5','175',4846924,'','6.1','3183',0.00,0.00,'Sales from shift 255545 on 2022-01-23 07:21:36 ','2022-01-23 07:21:36','',''),('5','175',4861161,'','20','3182',0.00,0.00,'Sales from shift 255760 on 2022-01-24 08:31:34 ','2022-01-24 08:31:34','',''),('5','175',4861162,'','6.1','3183',0.00,0.00,'Sales from shift 255760 on 2022-01-24 08:31:34 ','2022-01-24 08:31:34','',''),('5','175',4874043,'','20','3182',0.00,0.00,'Sales from shift 256041 on 2022-01-25 07:31:25 ','2022-01-25 07:31:25','',''),('5','175',4874044,'','6.1','3183',0.00,0.00,'Sales from shift 256041 on 2022-01-25 07:31:25 ','2022-01-25 07:31:25','',''),('5','175',4876566,'','2','3235',5000.00,0.00,'Payment Id 398097 for invoice:255247, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876567,'','supplier','218',0.00,5000.00,'Payment Id 398097 for invoice:255247, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876568,'','6.1','3183',17900.00,0.00,'Payment Id 398096 for invoice:255247, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876569,'','supplier','218',0.00,17900.00,'Payment Id 398096 for invoice:255247, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876570,'','2','4075',1164715.00,0.00,'Payment Id 398095 for invoice:255247, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876571,'','supplier','218',0.00,1164715.00,'Payment Id 398095 for invoice:255247, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876572,'','2','3235',5000.00,0.00,'Payment Id 396684 for invoice:255031, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876573,'','supplier','218',0.00,5000.00,'Payment Id 396684 for invoice:255031, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876574,'','6.1','3183',17900.00,0.00,'Payment Id 396683 for invoice:255031, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876575,'','supplier','218',0.00,17900.00,'Payment Id 396683 for invoice:255031, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876576,'','2','4075',1598155.00,0.00,'Payment Id 396681 for invoice:255031, receipt: 0225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876577,'','supplier','218',0.00,1598155.00,'Payment Id 396681 for invoice:255031, receipt: 0225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876578,'','6.1','3183',17900.00,0.00,'Payment Id 396111 for invoice:254768, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876579,'','supplier','218',0.00,17900.00,'Payment Id 396111 for invoice:254768, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876580,'','2','4075',1746585.00,0.00,'Payment Id 396110 for invoice:254768, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4876581,'','supplier','218',0.00,1746585.00,'Payment Id 396110 for invoice:254768, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-01-25 09:46:21','',''),('5','175',4883230,'','24','3186',0.00,24915.00,'Purchase Id 90362 for 151.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-25 14:25:10','',''),('5','175',4883231,'','supplier','218',24915.00,0.00,'Purchase Id 90362 for 151.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-01-25 14:25:10','',''),('5','175',4891345,'','20','3182',0.00,0.00,'Sales from shift 256257 on 2022-01-26 08:07:21 ','2022-01-26 08:07:21','',''),('5','175',4891346,'','6.1','3183',0.00,0.00,'Sales from shift 256257 on 2022-01-26 08:07:21 ','2022-01-26 08:07:21','',''),('5','175',4904405,'','20','3182',0.00,0.00,'Sales from shift 256540 on 2022-01-27 07:56:08 ','2022-01-27 07:56:08','',''),('5','175',4904406,'','6.1','3183',0.00,0.00,'Sales from shift 256540 on 2022-01-27 07:56:08 ','2022-01-27 07:56:08','',''),('5','175',4919987,'','20','3182',0.00,0.00,'Sales from shift 256800 on 2022-01-28 07:20:40 ','2022-01-28 07:20:40','',''),('5','175',4919988,'','6.1','3183',0.00,0.00,'Sales from shift 256800 on 2022-01-28 07:20:40 ','2022-01-28 07:20:40','',''),('5','175',4925918,'','6.1','3183',223495.00,0.00,'Payment Id 400314 for invoice:256800, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-28 12:10:59','',''),('5','175',4925919,'','supplier','218',0.00,223495.00,'Payment Id 400314 for invoice:256800, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-28 12:10:59','',''),('5','175',4925936,'','6.1','3183',0.00,223495.00,'Payment Id 400314 for invoice:256800, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-28 12:12:03','',''),('5','175',4925937,'','supplier','218',223495.00,0.00,'Payment Id 400314 for invoice:256800, receipt:  by SALBAS OIL & GAS NIG LTD','2022-01-28 12:12:03','',''),('5','175',4927123,'','24','3186',0.00,93499.10,'Purchase Id 90595 for 301.61 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2022-01-28 13:16:44','',''),('5','175',4927124,'','supplier','218',93499.10,0.00,'Purchase Id 90595 for 301.61 litters of Diesel - AGO from SALBAS OIL & GAS NIG LTD','2022-01-28 13:16:44','',''),('5','175',4935586,'','20','3182',0.00,0.00,'Sales from shift 257076 on 2022-01-29 07:48:46 ','2022-01-29 07:48:46','',''),('5','175',4935587,'','6.1','3183',0.00,0.00,'Sales from shift 257076 on 2022-01-29 07:48:46 ','2022-01-29 07:48:46','',''),('5','175',4951399,'','20','3182',0.00,0.00,'Sales from shift 257338 on 2022-01-30 07:42:27 ','2022-01-30 07:42:27','',''),('5','175',4951400,'','6.1','3183',0.00,0.00,'Sales from shift 257338 on 2022-01-30 07:42:27 ','2022-01-30 07:42:27','',''),('5','175',4951401,'','20','3182',0.00,0.00,'Sales from shift 257531 on 2022-01-31 09:29:30 ','2022-01-31 09:29:30','',''),('5','175',4951402,'','6.1','3183',0.00,0.00,'Sales from shift 257531 on 2022-01-31 09:29:30 ','2022-01-31 09:29:30','',''),('5','175',4951403,'','20','3182',0.00,0.00,'Sales from shift 257532 on 2022-02-01 08:28:21 ','2022-02-01 08:28:21','',''),('5','175',4951404,'','6.1','3183',0.00,0.00,'Sales from shift 257532 on 2022-02-01 08:28:21 ','2022-02-01 08:28:21','',''),('5','175',4951405,'','20','3182',0.00,0.00,'Sales from shift 257533 on 2022-02-02 08:31:52 ','2022-02-02 08:31:52','',''),('5','175',4951406,'','6.1','3183',0.00,0.00,'Sales from shift 257533 on 2022-02-02 08:31:52 ','2022-02-02 08:31:52','',''),('5','175',4951407,'','20','3182',0.00,0.00,'Sales from shift 257534 on 2022-02-03 06:37:59 ','2022-02-03 06:37:59','',''),('5','175',4951408,'','6.1','3183',0.00,0.00,'Sales from shift 257534 on 2022-02-03 06:37:59 ','2022-02-03 06:37:59','',''),('5','175',4951409,'','24','3186',0.00,7425000.00,'Purchase Id 90596 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-03 15:37:00','',''),('5','175',4951410,'','supplier','218',7425000.00,0.00,'Purchase Id 90596 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-03 15:37:00','',''),('5','175',4951411,'','20','3182',437880.30,0.00,'Sales from shift 257535 on 2022-02-04 06:25:39 ','2022-02-04 06:25:39','',''),('5','175',4951412,'','6.1','3183',0.00,437880.30,'Sales from shift 257535 on 2022-02-04 06:25:39 ','2022-02-04 06:25:39','',''),('5','175',4951413,'','20','3182',1282716.60,0.00,'Sales from shift 257536 on 2022-02-05 07:50:07 ','2022-02-05 07:50:07','',''),('5','175',4951414,'','6.1','3183',0.00,1282716.60,'Sales from shift 257536 on 2022-02-05 07:50:07 ','2022-02-05 07:50:07','',''),('5','175',4951415,'','20','3182',1256691.15,0.00,'Sales from shift 257537 on 2022-02-06 07:46:13 ','2022-02-06 07:46:13','',''),('5','175',4951416,'','6.1','3183',0.00,1256691.15,'Sales from shift 257537 on 2022-02-06 07:46:13 ','2022-02-06 07:46:13','',''),('5','175',4951417,'','20','3182',1006909.20,0.00,'Sales from shift 257538 on 2022-02-07 07:15:33 ','2022-02-07 07:15:33','',''),('5','175',4951418,'','6.1','3183',0.00,1006909.20,'Sales from shift 257538 on 2022-02-07 07:15:33 ','2022-02-07 07:15:33','',''),('5','175',4951419,'','20','3182',1690009.20,0.00,'Sales from shift 257539 on 2022-02-08 07:41:43 ','2022-02-08 07:41:43','',''),('5','175',4951420,'','6.1','3183',0.00,1690009.20,'Sales from shift 257539 on 2022-02-08 07:41:43 ','2022-02-08 07:41:43','',''),('5','175',4951421,'','2','4075',409500.00,0.00,'Payment Id 400315 for invoice:257535, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:49:32','',''),('5','175',4951422,'','supplier','218',0.00,409500.00,'Payment Id 400315 for invoice:257535, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:49:32','',''),('5','175',4951423,'','2','3235',9730.00,0.00,'Payment Id 400317 for invoice:257535, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:51:42','',''),('5','175',4951424,'','supplier','218',0.00,9730.00,'Payment Id 400317 for invoice:257535, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:51:42','',''),('5','175',4951425,'','6.1','3183',18650.00,0.00,'Payment Id 400316 for invoice:257535, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:51:42','',''),('5','175',4951426,'','supplier','218',0.00,18650.00,'Payment Id 400316 for invoice:257535, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:51:42','',''),('5','175',4951427,'','2','3235',8000.00,0.00,'Payment Id 400325 for invoice:257538, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951428,'','supplier','218',0.00,8000.00,'Payment Id 400325 for invoice:257538, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951429,'','6.1','3183',19900.00,0.00,'Payment Id 400324 for invoice:257538, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951430,'','supplier','218',0.00,19900.00,'Payment Id 400324 for invoice:257538, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951431,'','2','4075',979010.00,0.00,'Payment Id 400323 for invoice:257538, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951432,'','supplier','218',0.00,979010.00,'Payment Id 400323 for invoice:257538, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951433,'','2','3235',18070.00,0.00,'Payment Id 400322 for invoice:257537, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951434,'','supplier','218',0.00,18070.00,'Payment Id 400322 for invoice:257537, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951435,'','6.1','3183',19900.00,0.00,'Payment Id 400321 for invoice:257537, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951436,'','supplier','218',0.00,19900.00,'Payment Id 400321 for invoice:257537, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951437,'','2','4075',1218720.00,0.00,'Payment Id 400320 for invoice:257537, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951438,'','supplier','218',0.00,1218720.00,'Payment Id 400320 for invoice:257537, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951439,'','6.1','3183',18650.00,0.00,'Payment Id 400319 for invoice:257536, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951440,'','supplier','218',0.00,18650.00,'Payment Id 400319 for invoice:257536, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951441,'','2','4075',1264065.00,0.00,'Payment Id 400318 for invoice:257536, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951442,'','supplier','218',0.00,1264065.00,'Payment Id 400318 for invoice:257536, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-08 10:53:37','',''),('5','175',4951443,'','20','3182',1057222.65,0.00,'Sales from shift 257540 on 2022-02-09 08:16:46 ','2022-02-09 08:16:46','',''),('5','175',4951444,'','6.1','3183',0.00,1057222.65,'Sales from shift 257540 on 2022-02-09 08:16:46 ','2022-02-09 08:16:46','',''),('5','175',4951445,'','20','3182',713352.75,0.00,'Sales from shift 257541 on 2022-02-10 07:57:15 ','2022-02-10 07:57:15','',''),('5','175',4951446,'','6.1','3183',0.00,713352.75,'Sales from shift 257541 on 2022-02-10 07:57:15 ','2022-02-10 07:57:15','',''),('5','175',4951447,'','20','3182',0.00,0.00,'Sales from shift 257542 on 2022-02-11 08:10:19 ','2022-02-11 08:10:19','',''),('5','175',4951448,'','6.1','3183',0.00,0.00,'Sales from shift 257542 on 2022-02-11 08:10:19 ','2022-02-11 08:10:19','',''),('5','175',4951449,'','2','4075',681205.00,0.00,'Payment Id 400331 for invoice:257541, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951450,'','supplier','218',0.00,681205.00,'Payment Id 400331 for invoice:257541, receipt: 225 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951451,'','6.1','3183',19900.00,0.00,'Payment Id 400330 for invoice:257540, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951452,'','supplier','218',0.00,19900.00,'Payment Id 400330 for invoice:257540, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951453,'','2','4075',1037325.00,0.00,'Payment Id 400329 for invoice:257540, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951454,'','supplier','218',0.00,1037325.00,'Payment Id 400329 for invoice:257540, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951455,'','2','3235',1000.00,0.00,'Payment Id 400328 for invoice:257539, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951456,'','supplier','218',0.00,1000.00,'Payment Id 400328 for invoice:257539, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951457,'','6.1','3183',274900.00,0.00,'Payment Id 400327 for invoice:257539, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951458,'','supplier','218',0.00,274900.00,'Payment Id 400327 for invoice:257539, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951459,'','2','4075',1414110.00,0.00,'Payment Id 400326 for invoice:257539, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951460,'','supplier','218',0.00,1414110.00,'Payment Id 400326 for invoice:257539, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-02-11 11:52:36','',''),('5','175',4951461,'','20','3182',0.00,0.00,'Sales from shift 257543 on 2022-02-12 08:11:46 ','2022-02-12 08:11:46','',''),('5','175',4951462,'','6.1','3183',0.00,0.00,'Sales from shift 257543 on 2022-02-12 08:11:46 ','2022-02-12 08:11:46','',''),('5','175',4951463,'','20','3182',0.00,0.00,'Sales from shift 257544 on 2022-02-13 07:28:39 ','2022-02-13 07:28:39','',''),('5','175',4951464,'','6.1','3183',0.00,0.00,'Sales from shift 257544 on 2022-02-13 07:28:39 ','2022-02-13 07:28:39','',''),('5','175',4951465,'','20','3182',0.00,0.00,'Sales from shift 257545 on 2022-02-14 07:19:35 ','2022-02-14 07:19:35','',''),('5','175',4951466,'','6.1','3183',0.00,0.00,'Sales from shift 257545 on 2022-02-14 07:19:35 ','2022-02-14 07:19:35','',''),('5','175',4951467,'','20','3182',0.00,0.00,'Sales from shift 257546 on 2022-02-15 08:08:55 ','2022-02-15 08:08:55','',''),('5','175',4951468,'','6.1','3183',0.00,0.00,'Sales from shift 257546 on 2022-02-15 08:08:55 ','2022-02-15 08:08:55','',''),('5','175',4951469,'','20','3182',0.00,0.00,'Sales from shift 257547 on 2022-02-16 07:31:29 ','2022-02-16 07:31:29','',''),('5','175',4951470,'','6.1','3183',0.00,0.00,'Sales from shift 257547 on 2022-02-16 07:31:29 ','2022-02-16 07:31:29','',''),('5','175',4951471,'','20','3182',0.00,0.00,'Sales from shift 257548 on 2022-02-17 07:08:06 ','2022-02-17 07:08:06','',''),('5','175',4951472,'','6.1','3183',0.00,0.00,'Sales from shift 257548 on 2022-02-17 07:08:06 ','2022-02-17 07:08:06','',''),('5','175',4951473,'','6.1','3183',32850.00,0.00,'Payment Id 400332 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-17 10:15:50','',''),('5','175',4951474,'','supplier','218',0.00,32850.00,'Payment Id 400332 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG LTD','2022-02-17 10:15:50','',''),('5','175',4951475,'','24','3186',0.00,152460.00,'Purchase Id 90597 for 924.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-17 10:21:07','',''),('5','175',4951476,'','supplier','218',152460.00,0.00,'Purchase Id 90597 for 924.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-17 10:21:07','',''),('5','175',4951477,'','20','3182',0.00,0.00,'Sales from shift 257549 on 2022-02-18 07:22:00 ','2022-02-18 07:22:00','',''),('5','175',4951478,'','6.1','3183',0.00,0.00,'Sales from shift 257549 on 2022-02-18 07:22:00 ','2022-02-18 07:22:00','',''),('5','175',4951479,'','20','3182',0.00,0.00,'Sales from shift 257550 on 2022-02-19 07:29:43 ','2022-02-19 07:29:43','',''),('5','175',4951480,'','6.1','3183',0.00,0.00,'Sales from shift 257550 on 2022-02-19 07:29:43 ','2022-02-19 07:29:43','',''),('5','175',4951481,'','20','3182',0.00,0.00,'Sales from shift 257551 on 2022-02-20 07:20:22 ','2022-02-20 07:20:22','',''),('5','175',4951482,'','6.1','3183',0.00,0.00,'Sales from shift 257551 on 2022-02-20 07:20:22 ','2022-02-20 07:20:22','',''),('5','175',4951483,'','20','3182',0.00,0.00,'Sales from shift 257552 on 2022-02-21 07:24:11 ','2022-02-21 07:24:11','',''),('5','175',4951484,'','6.1','3183',0.00,0.00,'Sales from shift 257552 on 2022-02-21 07:24:11 ','2022-02-21 07:24:11','',''),('5','175',4951485,'','20','3182',0.00,0.00,'Sales from shift 257553 on 2022-02-22 06:41:37 ','2022-02-22 06:41:37','',''),('5','175',4951486,'','6.1','3183',0.00,0.00,'Sales from shift 257553 on 2022-02-22 06:41:37 ','2022-02-22 06:41:37','',''),('5','175',4951487,'','20','3182',0.00,0.00,'Sales from shift 257554 on 2022-02-23 07:01:01 ','2022-02-23 07:01:01','',''),('5','175',4951488,'','6.1','3183',0.00,0.00,'Sales from shift 257554 on 2022-02-23 07:01:01 ','2022-02-23 07:01:01','',''),('5','175',4951489,'','24','3186',0.00,7425000.00,'Purchase Id 90598 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-23 14:08:39','',''),('5','175',4951490,'','supplier','218',7425000.00,0.00,'Purchase Id 90598 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-02-23 14:08:39','',''),('5','175',4951491,'','20','3182',962052.30,0.00,'Sales from shift 257555 on 2022-02-24 09:37:07 ','2022-02-24 09:37:07','',''),('5','175',4951492,'','6.1','3183',0.00,962052.30,'Sales from shift 257555 on 2022-02-24 09:37:07 ','2022-02-24 09:37:07','',''),('5','175',4951493,'','20','3182',1269981.90,0.00,'Sales from shift 257556 on 2022-02-25 08:09:57 ','2022-02-25 08:09:57','',''),('5','175',4951494,'','6.1','3183',0.00,1269981.90,'Sales from shift 257556 on 2022-02-25 08:09:57 ','2022-02-25 08:09:57','',''),('5','175',4951495,'','20','3182',1177101.75,0.00,'Sales from shift 257557 on 2022-02-26 07:18:54 ','2022-02-26 07:18:54','',''),('5','175',4951496,'','6.1','3183',0.00,1177101.75,'Sales from shift 257557 on 2022-02-26 07:18:54 ','2022-02-26 07:18:54','',''),('5','175',4951497,'','20','3182',1310972.85,0.00,'Sales from shift 257558 on 2022-02-27 07:01:15 ','2022-02-27 07:01:15','',''),('5','175',4951498,'','6.1','3183',0.00,1310972.85,'Sales from shift 257558 on 2022-02-27 07:01:15 ','2022-02-27 07:01:15','',''),('5','175',4951499,'','20','3182',1474011.00,0.00,'Sales from shift 257559 on 2022-02-28 07:16:56 ','2022-02-28 07:16:56','',''),('5','175',4951500,'','6.1','3183',0.00,1474011.00,'Sales from shift 257559 on 2022-02-28 07:16:56 ','2022-02-28 07:16:56','',''),('5','175',4951501,'','20','3182',898933.20,0.00,'Sales from shift 257560 on 2022-03-01 06:53:49 ','2022-03-01 06:53:49','',''),('5','175',4951502,'','6.1','3183',0.00,898933.20,'Sales from shift 257560 on 2022-03-01 06:53:49 ','2022-03-01 06:53:49','',''),('5','175',4951503,'','20','3182',409299.00,0.00,'Sales from shift 257561 on 2022-03-02 08:17:50 ','2022-03-02 08:17:50','',''),('5','175',4951504,'','6.1','3183',0.00,409299.00,'Sales from shift 257561 on 2022-03-02 08:17:50 ','2022-03-02 08:17:50','',''),('5','175',4951505,'','6.1','3183',21150.00,0.00,'Payment Id 400334 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:12:42','',''),('5','175',4951506,'','supplier','218',0.00,21150.00,'Payment Id 400334 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:12:42','',''),('5','175',4951507,'','2','4075',1234765.00,0.00,'Payment Id 400336 for invoice:257556, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951508,'','supplier','218',0.00,1234765.00,'Payment Id 400336 for invoice:257556, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951509,'','2','3235',6300.00,0.00,'Payment Id 400335 for invoice:257555, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951510,'','supplier','218',0.00,6300.00,'Payment Id 400335 for invoice:257555, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951511,'','2','4075',934900.00,0.00,'Payment Id 400333 for invoice:257555, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951512,'','supplier','218',0.00,934900.00,'Payment Id 400333 for invoice:257555, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:24','',''),('5','175',4951513,'','2','3235',14000.00,0.00,'Payment Id 400338 for invoice:257556, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:54','',''),('5','175',4951514,'','supplier','218',0.00,14000.00,'Payment Id 400338 for invoice:257556, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:54','',''),('5','175',4951515,'','6.1','3183',21150.00,0.00,'Payment Id 400337 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:54','',''),('5','175',4951516,'','supplier','218',0.00,21150.00,'Payment Id 400337 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:13:54','',''),('5','175',4951517,'','2','3235',1000.00,0.00,'Payment Id 400341 for invoice:257557, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951518,'','supplier','218',0.00,1000.00,'Payment Id 400341 for invoice:257557, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951519,'','6.1','3183',21150.00,0.00,'Payment Id 400340 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951520,'','supplier','218',0.00,21150.00,'Payment Id 400340 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951521,'','2','4075',1154950.00,0.00,'Payment Id 400339 for invoice:257557, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951522,'','supplier','218',0.00,1154950.00,'Payment Id 400339 for invoice:257557, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:14:17','',''),('5','175',4951523,'','2','3235',31700.00,0.00,'Payment Id 400346 for invoice:257559, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951524,'','supplier','218',0.00,31700.00,'Payment Id 400346 for invoice:257559, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951525,'','6.1','3183',21150.00,0.00,'Payment Id 400345 for invoice:257559, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951526,'','supplier','218',0.00,21150.00,'Payment Id 400345 for invoice:257559, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951527,'','2','4075',1421060.00,0.00,'Payment Id 400344 for invoice:257559, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951528,'','supplier','218',0.00,1421060.00,'Payment Id 400344 for invoice:257559, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951529,'','6.1','3183',21150.00,0.00,'Payment Id 400343 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951530,'','supplier','218',0.00,21150.00,'Payment Id 400343 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951531,'','2','4075',1289820.00,0.00,'Payment Id 400342 for invoice:257558, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951532,'','supplier','218',0.00,1289820.00,'Payment Id 400342 for invoice:257558, receipt: 029 by SALBAS OIL & GAS NIG LTD','2022-03-02 15:15:10','',''),('5','175',4951533,'','20','3182',0.00,0.00,'Sales from shift 257562 on 2022-03-03 09:42:16 ','2022-03-03 09:42:16','',''),('5','175',4951534,'','6.1','3183',0.00,0.00,'Sales from shift 257562 on 2022-03-03 09:42:16 ','2022-03-03 09:42:16','',''),('5','175',4951535,'','20','3182',0.00,0.00,'Sales from shift 257563 on 2022-03-05 09:12:03 ','2022-03-05 09:12:03','',''),('5','175',4951536,'','6.1','3183',0.00,0.00,'Sales from shift 257563 on 2022-03-05 09:12:03 ','2022-03-05 09:12:03','',''),('5','175',4951537,'','20','3182',0.00,0.00,'Sales from shift 257564 on 2022-03-06 07:42:08 ','2022-03-06 07:42:08','',''),('5','175',4951538,'','6.1','3183',0.00,0.00,'Sales from shift 257564 on 2022-03-06 07:42:08 ','2022-03-06 07:42:08','',''),('5','175',4951539,'','20','3182',0.00,0.00,'Sales from shift 257565 on 2022-03-07 07:56:07 ','2022-03-07 07:56:07','',''),('5','175',4951540,'','6.1','3183',0.00,0.00,'Sales from shift 257565 on 2022-03-07 07:56:07 ','2022-03-07 07:56:07','',''),('5','175',4951541,'','20','3182',0.00,0.00,'Sales from shift 257566 on 2022-03-08 07:02:30 ','2022-03-08 07:02:30','',''),('5','175',4951542,'','6.1','3183',0.00,0.00,'Sales from shift 257566 on 2022-03-08 07:02:30 ','2022-03-08 07:02:30','',''),('5','175',4951543,'','20','3182',0.00,0.00,'Sales from shift 257567 on 2022-03-09 07:55:25 ','2022-03-09 07:55:25','',''),('5','175',4951544,'','6.1','3183',0.00,0.00,'Sales from shift 257567 on 2022-03-09 07:55:25 ','2022-03-09 07:55:25','',''),('5','175',4951545,'','20','3182',0.00,0.00,'Sales from shift 257568 on 2022-03-10 06:38:13 ','2022-03-10 06:38:13','',''),('5','175',4951546,'','6.1','3183',0.00,0.00,'Sales from shift 257568 on 2022-03-10 06:38:13 ','2022-03-10 06:38:13','',''),('5','175',4951547,'','20','3182',0.00,0.00,'Sales from shift 257569 on 2022-03-11 08:23:50 ','2022-03-11 08:23:50','',''),('5','175',4951548,'','6.1','3183',0.00,0.00,'Sales from shift 257569 on 2022-03-11 08:23:50 ','2022-03-11 08:23:50','',''),('5','175',4951549,'','20','3182',0.00,0.00,'Sales from shift 257570 on 2022-03-12 07:55:33 ','2022-03-12 07:55:33','',''),('5','175',4951550,'','6.1','3183',0.00,0.00,'Sales from shift 257570 on 2022-03-12 07:55:33 ','2022-03-12 07:55:33','',''),('5','175',4951551,'','20','3182',0.00,0.00,'Sales from shift 257571 on 2022-03-13 08:06:03 ','2022-03-13 08:06:03','',''),('5','175',4951552,'','6.1','3183',0.00,0.00,'Sales from shift 257571 on 2022-03-13 08:06:03 ','2022-03-13 08:06:03','',''),('5','175',4951553,'','20','3182',0.00,0.00,'Sales from shift 257572 on 2022-03-14 07:05:34 ','2022-03-14 07:05:34','',''),('5','175',4951554,'','6.1','3183',0.00,0.00,'Sales from shift 257572 on 2022-03-14 07:05:34 ','2022-03-14 07:05:34','',''),('5','175',4951555,'','20','3182',0.00,0.00,'Sales from shift 257573 on 2022-03-15 07:07:04 ','2022-03-15 07:07:04','',''),('5','175',4951556,'','6.1','3183',0.00,0.00,'Sales from shift 257573 on 2022-03-15 07:07:04 ','2022-03-15 07:07:04','',''),('5','175',4951557,'','24','3186',0.00,2227500.00,'Purchase Id 90599 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-03-15 14:51:49','',''),('5','175',4951558,'','supplier','218',2227500.00,0.00,'Purchase Id 90599 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-03-15 14:51:49','',''),('5','175',4951559,'','20','3182',547734.00,0.00,'Sales from shift 257574 on 2022-03-16 08:08:57 ','2022-03-16 08:08:57','',''),('5','175',4951560,'','6.1','3183',0.00,547734.00,'Sales from shift 257574 on 2022-03-16 08:08:57 ','2022-03-16 08:08:57','',''),('5','175',4951561,'','20','3182',908760.60,0.00,'Sales from shift 257575 on 2022-03-17 10:21:33 ','2022-03-17 10:21:33','',''),('5','175',4951562,'','6.1','3183',0.00,908760.60,'Sales from shift 257575 on 2022-03-17 10:21:33 ','2022-03-17 10:21:33','',''),('5','175',4951563,'','20','3182',597410.55,0.00,'Sales from shift 257576 on 2022-03-18 07:46:28 ','2022-03-18 07:46:28','',''),('5','175',4951564,'','6.1','3183',0.00,597410.55,'Sales from shift 257576 on 2022-03-18 07:46:28 ','2022-03-18 07:46:28','',''),('5','175',4951565,'','20','3182',200491.50,0.00,'Sales from shift 257577 on 2022-03-19 06:59:38 ','2022-03-19 06:59:38','',''),('5','175',4951566,'','6.1','3183',0.00,200491.50,'Sales from shift 257577 on 2022-03-19 06:59:38 ','2022-03-19 06:59:38','',''),('5','175',4951567,'','20','3182',0.00,0.00,'Sales from shift 257578 on 2022-03-20 07:29:57 ','2022-03-20 07:29:57','',''),('5','175',4951568,'','6.1','3183',0.00,0.00,'Sales from shift 257578 on 2022-03-20 07:29:57 ','2022-03-20 07:29:57','',''),('5','175',4951569,'','20','3182',0.00,0.00,'Sales from shift 257579 on 2022-03-21 06:31:07 ','2022-03-21 06:31:07','',''),('5','175',4951570,'','6.1','3183',0.00,0.00,'Sales from shift 257579 on 2022-03-21 06:31:07 ','2022-03-21 06:31:07','',''),('5','175',4951571,'','20','3182',0.00,0.00,'Sales from shift 257580 on 2022-03-22 07:05:36 ','2022-03-22 07:05:36','',''),('5','175',4951572,'','6.1','3183',0.00,0.00,'Sales from shift 257580 on 2022-03-22 07:05:36 ','2022-03-22 07:05:36','',''),('5','175',4951573,'','6.1','3183',32400.00,0.00,'Payment Id 400354 for invoice:257580, receipt: 6924977 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951574,'','supplier','218',0.00,32400.00,'Payment Id 400354 for invoice:257580, receipt: 6924977 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951575,'','2','4076',168090.00,0.00,'Payment Id 400353 for invoice:257577, receipt: 6924977 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951576,'','supplier','218',0.00,168090.00,'Payment Id 400353 for invoice:257577, receipt: 6924977 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951577,'','6.1','3183',37400.00,0.00,'Payment Id 400352 for invoice:257576, receipt: 6926181 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951578,'','supplier','218',0.00,37400.00,'Payment Id 400352 for invoice:257576, receipt: 6926181 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951579,'','2','4076',560010.00,0.00,'Payment Id 400351 for invoice:257576, receipt: 6926181 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951580,'','supplier','218',0.00,560010.00,'Payment Id 400351 for invoice:257576, receipt: 6926181 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951581,'','2','4076',38400.00,0.00,'Payment Id 400350 for invoice:257575, receipt: 6926159 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951582,'','supplier','218',0.00,38400.00,'Payment Id 400350 for invoice:257575, receipt: 6926159 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951583,'','2','4076',870400.00,0.00,'Payment Id 400349 for invoice:257575, receipt: 6926159 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951584,'','supplier','218',0.00,870400.00,'Payment Id 400349 for invoice:257575, receipt: 6926159 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951585,'','2','4076',95600.00,0.00,'Payment Id 400348 for invoice:257574, receipt: 6926431 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951586,'','supplier','218',0.00,95600.00,'Payment Id 400348 for invoice:257574, receipt: 6926431 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951587,'','2','4076',452140.00,0.00,'Payment Id 400347 for invoice:257574, receipt: 6926431 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951588,'','supplier','218',0.00,452140.00,'Payment Id 400347 for invoice:257574, receipt: 6926431 by SALBAS OIL & GAS NIG LTD','2022-03-22 15:49:19','',''),('5','175',4951589,'','20','3182',0.00,0.00,'Sales from shift 257581 on 2022-03-23 06:32:30 ','2022-03-23 06:32:30','',''),('5','175',4951590,'','6.1','3183',0.00,0.00,'Sales from shift 257581 on 2022-03-23 06:32:30 ','2022-03-23 06:32:30','',''),('5','175',4951591,'','20','3182',0.00,0.00,'Sales from shift 257582 on 2022-03-24 20:32:34 ','2022-03-24 20:32:34','',''),('5','175',4951592,'','6.1','3183',0.00,0.00,'Sales from shift 257582 on 2022-03-24 20:32:34 ','2022-03-24 20:32:34','',''),('5','175',4951593,'','20','3182',0.00,0.00,'Sales from shift 257583 on 2022-03-25 08:27:27 ','2022-03-25 08:27:27','',''),('5','175',4951594,'','6.1','3183',0.00,0.00,'Sales from shift 257583 on 2022-03-25 08:27:27 ','2022-03-25 08:27:27','',''),('5','175',4951595,'','20','3182',0.00,0.00,'Sales from shift 257584 on 2022-03-27 07:05:03 ','2022-03-27 07:05:03','',''),('5','175',4951596,'','6.1','3183',0.00,0.00,'Sales from shift 257584 on 2022-03-27 07:05:03 ','2022-03-27 07:05:03','',''),('5','175',4951597,'','20','3182',0.00,0.00,'Sales from shift 257585 on 2022-03-28 09:19:52 ','2022-03-28 09:19:52','',''),('5','175',4951598,'','6.1','3183',0.00,0.00,'Sales from shift 257585 on 2022-03-28 09:19:52 ','2022-03-28 09:19:52','',''),('5','175',4951599,'','20','3182',0.00,0.00,'Sales from shift 257586 on 2022-03-29 07:19:25 ','2022-03-29 07:19:25','',''),('5','175',4951600,'','6.1','3183',0.00,0.00,'Sales from shift 257586 on 2022-03-29 07:19:25 ','2022-03-29 07:19:25','',''),('5','175',4951601,'','20','3182',0.00,0.00,'Sales from shift 257587 on 2022-03-29 12:58:59 ','2022-03-29 12:58:59','',''),('5','175',4951602,'','6.1','3183',0.00,0.00,'Sales from shift 257587 on 2022-03-29 12:58:59 ','2022-03-29 12:58:59','',''),('5','175',4951603,'','20','3182',0.00,0.00,'Sales from shift 257588 on 2022-03-30 06:40:50 ','2022-03-30 06:40:50','',''),('5','175',4951604,'','6.1','3183',0.00,0.00,'Sales from shift 257588 on 2022-03-30 06:40:50 ','2022-03-30 06:40:50','',''),('5','175',4951605,'','20','3182',0.00,0.00,'Sales from shift 257589 on 2022-03-31 08:01:53 ','2022-03-31 08:01:53','',''),('5','175',4951606,'','6.1','3183',0.00,0.00,'Sales from shift 257589 on 2022-03-31 08:01:53 ','2022-03-31 08:01:53','',''),('5','175',4951607,'','20','3182',0.00,0.00,'Sales from shift 257590 on 2022-04-01 08:38:07 ','2022-04-01 08:38:07','',''),('5','175',4951608,'','6.1','3183',0.00,0.00,'Sales from shift 257590 on 2022-04-01 08:38:07 ','2022-04-01 08:38:07','',''),('5','175',4951609,'','20','3182',0.00,0.00,'Sales from shift 257591 on 2022-04-02 19:14:23 ','2022-04-02 19:14:23','',''),('5','175',4951610,'','6.1','3183',0.00,0.00,'Sales from shift 257591 on 2022-04-02 19:14:23 ','2022-04-02 19:14:23','',''),('5','175',4951611,'','20','3182',0.00,0.00,'Sales from shift 257592 on 2022-04-03 15:21:20 ','2022-04-03 15:21:20','',''),('5','175',4951612,'','6.1','3183',0.00,0.00,'Sales from shift 257592 on 2022-04-03 15:21:20 ','2022-04-03 15:21:20','',''),('5','175',4951613,'','20','3182',0.00,0.00,'Sales from shift 257593 on 2022-04-03 21:59:31 ','2022-04-03 21:59:31','',''),('5','175',4951614,'','6.1','3183',0.00,0.00,'Sales from shift 257593 on 2022-04-03 21:59:31 ','2022-04-03 21:59:31','',''),('5','175',4951615,'','20','3182',0.00,0.00,'Sales from shift 257594 on 2022-04-07 06:09:09 ','2022-04-07 06:09:09','',''),('5','175',4951616,'','6.1','3183',0.00,0.00,'Sales from shift 257594 on 2022-04-07 06:09:09 ','2022-04-07 06:09:09','',''),('5','175',4951617,'','20','3182',0.00,0.00,'Sales from shift 257595 on 2022-04-08 13:52:25 ','2022-04-08 13:52:25','',''),('5','175',4951618,'','6.1','3183',0.00,0.00,'Sales from shift 257595 on 2022-04-08 13:52:25 ','2022-04-08 13:52:25','',''),('5','175',4951619,'','20','3182',0.00,0.00,'Sales from shift 257596 on 2022-04-11 11:43:07 ','2022-04-11 11:43:07','',''),('5','175',4951620,'','6.1','3183',0.00,0.00,'Sales from shift 257596 on 2022-04-11 11:43:07 ','2022-04-11 11:43:07','',''),('5','175',4951621,'','20','3182',0.00,0.00,'Sales from shift 257597 on 2022-04-11 12:27:31 ','2022-04-11 12:27:31','',''),('5','175',4951622,'','6.1','3183',0.00,0.00,'Sales from shift 257597 on 2022-04-11 12:27:31 ','2022-04-11 12:27:31','',''),('5','175',4951623,'','20','3182',0.00,0.00,'Sales from shift 257598 on 2022-04-20 09:47:54 ','2022-04-20 09:47:54','',''),('5','175',4951624,'','6.1','3183',0.00,0.00,'Sales from shift 257598 on 2022-04-20 09:47:54 ','2022-04-20 09:47:54','',''),('5','175',4951625,'','20','3182',0.00,0.00,'Sales from shift 257599 on 2022-04-20 12:56:22 ','2022-04-20 12:56:22','',''),('5','175',4951626,'','6.1','3183',0.00,0.00,'Sales from shift 257599 on 2022-04-20 12:56:22 ','2022-04-20 12:56:22','',''),('5','175',4951627,'','20','3182',0.00,0.00,'Sales from shift 257600 on 2022-04-20 14:09:45 ','2022-04-20 14:09:45','',''),('5','175',4951628,'','6.1','3183',0.00,0.00,'Sales from shift 257600 on 2022-04-20 14:09:45 ','2022-04-20 14:09:45','',''),('5','175',4951629,'','20','3182',0.00,0.00,'Sales from shift 257601 on 2022-04-20 15:04:26 ','2022-04-20 15:04:26','',''),('5','175',4951630,'','6.1','3183',0.00,0.00,'Sales from shift 257601 on 2022-04-20 15:04:26 ','2022-04-20 15:04:26','',''),('5','175',4951631,'','20','3182',0.00,0.00,'Sales from shift 257602 on 2022-04-20 15:21:45 ','2022-04-20 15:21:45','',''),('5','175',4951632,'','6.1','3183',0.00,0.00,'Sales from shift 257602 on 2022-04-20 15:21:45 ','2022-04-20 15:21:45','',''),('5','175',4951633,'','20','3182',0.00,0.00,'Sales from shift 257603 on 2022-04-21 07:45:03 ','2022-04-21 07:45:03','',''),('5','175',4951634,'','6.1','3183',0.00,0.00,'Sales from shift 257603 on 2022-04-21 07:45:03 ','2022-04-21 07:45:03','',''),('5','175',4951635,'','24','3186',0.00,7425000.00,'Purchase Id 90600 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-04-23 14:02:04','',''),('5','175',4951636,'','supplier','218',7425000.00,0.00,'Purchase Id 90600 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-04-23 14:02:04','',''),('5','175',4951637,'','20','3182',0.00,0.00,'Sales from shift 257604 on 2022-04-23 14:02:20 ','2022-04-23 14:02:20','',''),('5','175',4951638,'','6.1','3183',0.00,0.00,'Sales from shift 257604 on 2022-04-23 14:02:20 ','2022-04-23 14:02:20','',''),('5','175',4951639,'','20','3182',0.00,0.00,'Sales from shift 257605 on 2022-04-23 15:33:54 ','2022-04-23 15:33:54','',''),('5','175',4951640,'','6.1','3183',0.00,0.00,'Sales from shift 257605 on 2022-04-23 15:33:54 ','2022-04-23 15:33:54','',''),('5','175',4951641,'','20','3182',0.00,0.00,'Sales from shift 257606 on 2022-04-23 16:31:19 ','2022-04-23 16:31:19','',''),('5','175',4951642,'','6.1','3183',0.00,0.00,'Sales from shift 257606 on 2022-04-23 16:31:19 ','2022-04-23 16:31:19','',''),('5','175',4951643,'','20','3182',0.00,0.00,'Sales from shift 257607 on 2022-04-23 16:46:23 ','2022-04-23 16:46:23','',''),('5','175',4951644,'','6.1','3183',0.00,0.00,'Sales from shift 257607 on 2022-04-23 16:46:23 ','2022-04-23 16:46:23','',''),('5','175',4951645,'','20','3182',0.00,0.00,'Sales from shift 257608 on 2022-04-23 17:08:27 ','2022-04-23 17:08:27','',''),('5','175',4951646,'','6.1','3183',0.00,0.00,'Sales from shift 257608 on 2022-04-23 17:08:27 ','2022-04-23 17:08:27','',''),('5','175',4951647,'','20','3182',161799.00,0.00,'Sales from shift 257609 on 2022-04-23 17:39:13 ','2022-04-23 17:39:13','',''),('5','175',4951648,'','6.1','3183',0.00,161799.00,'Sales from shift 257609 on 2022-04-23 17:39:13 ','2022-04-23 17:39:13','',''),('5','175',4951649,'','20','3182',962984.55,0.00,'Sales from shift 257610 on 2022-04-24 09:19:20 ','2022-04-24 09:19:20','',''),('5','175',4951650,'','6.1','3183',0.00,962984.55,'Sales from shift 257610 on 2022-04-24 09:19:20 ','2022-04-24 09:19:20','',''),('5','175',4951651,'','20','3182',877224.15,0.00,'Sales from shift 257611 on 2022-04-25 11:36:52 ','2022-04-25 11:36:52','',''),('5','175',4951652,'','6.1','3183',0.00,877224.15,'Sales from shift 257611 on 2022-04-25 11:36:52 ','2022-04-25 11:36:52','',''),('5','175',4951653,'','20','3182',923094.15,0.00,'Sales from shift 257612 on 2022-04-26 11:21:01 ','2022-04-26 11:21:01','',''),('5','175',4951654,'','6.1','3183',0.00,923094.15,'Sales from shift 257612 on 2022-04-26 11:21:01 ','2022-04-26 11:21:01','',''),('5','175',4951655,'','6.1','3183',33400.00,0.00,'Payment Id 400357 for invoice:257609, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:44:11','',''),('5','175',4951656,'','supplier','218',0.00,33400.00,'Payment Id 400357 for invoice:257609, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:44:11','',''),('5','175',4951657,'','2','4076',124400.00,0.00,'Payment Id 400355 for invoice:257609, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:44:11','',''),('5','175',4951658,'','supplier','218',0.00,124400.00,'Payment Id 400355 for invoice:257609, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:44:11','',''),('5','175',4951659,'','6.1','3183',47100.00,0.00,'Payment Id 400360 for invoice:257610, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:45:15','',''),('5','175',4951660,'','supplier','218',0.00,47100.00,'Payment Id 400360 for invoice:257610, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:45:15','',''),('5','175',4951661,'','2','4076',898680.00,0.00,'Payment Id 400358 for invoice:257610, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:45:15','',''),('5','175',4951662,'','supplier','218',0.00,898680.00,'Payment Id 400358 for invoice:257610, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:45:15','',''),('5','175',4951663,'','6.1','3183',33400.00,0.00,'Payment Id 400362 for invoice:257611, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:07','',''),('5','175',4951664,'','supplier','218',0.00,33400.00,'Payment Id 400362 for invoice:257611, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:07','',''),('5','175',4951665,'','2','4076',843820.00,0.00,'Payment Id 400361 for invoice:257611, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:07','',''),('5','175',4951666,'','supplier','218',0.00,843820.00,'Payment Id 400361 for invoice:257611, receipt: 1603036 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:07','',''),('5','175',4951667,'','6.1','3183',33400.00,0.00,'Payment Id 400364 for invoice:257612, receipt: 1592206 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:25','',''),('5','175',4951668,'','supplier','218',0.00,33400.00,'Payment Id 400364 for invoice:257612, receipt: 1592206 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:25','',''),('5','175',4951669,'','2','4076',664700.00,0.00,'Payment Id 400363 for invoice:257612, receipt: 1592206 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:25','',''),('5','175',4951670,'','supplier','218',0.00,664700.00,'Payment Id 400363 for invoice:257612, receipt: 1592206 by SALBAS OIL & GAS NIG LTD','2022-04-26 14:46:25','',''),('5','175',4951671,'','20','3182',860445.30,0.00,'Sales from shift 257613 on 2022-04-27 07:49:32 ','2022-04-27 07:49:32','',''),('5','175',4951672,'','6.1','3183',0.00,860445.30,'Sales from shift 257613 on 2022-04-27 07:49:32 ','2022-04-27 07:49:32','',''),('5','175',4951673,'','20','3182',1012105.05,0.00,'Sales from shift 257614 on 2022-04-28 08:25:57 ','2022-04-28 08:25:57','',''),('5','175',4951674,'','6.1','3183',0.00,1012105.05,'Sales from shift 257614 on 2022-04-28 08:25:57 ','2022-04-28 08:25:57','',''),('5','175',4951675,'','20','3182',1000421.40,0.00,'Sales from shift 257615 on 2022-04-29 10:19:53 ','2022-04-29 10:19:53','',''),('5','175',4951676,'','6.1','3183',0.00,1000421.40,'Sales from shift 257615 on 2022-04-29 10:19:53 ','2022-04-29 10:19:53','',''),('5','175',4951677,'','6.1','3183',33400.00,0.00,'Payment Id 400371 for invoice:257614, receipt: 1597163 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951678,'','supplier','218',0.00,33400.00,'Payment Id 400371 for invoice:257614, receipt: 1597163 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951679,'','2','4076',978710.00,0.00,'Payment Id 400370 for invoice:257614, receipt: 1597163 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951680,'','supplier','218',0.00,978710.00,'Payment Id 400370 for invoice:257614, receipt: 1597163 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951681,'','6.1','3183',33400.00,0.00,'Payment Id 400369 for invoice:257613, receipt: 1592324 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951682,'','supplier','218',0.00,33400.00,'Payment Id 400369 for invoice:257613, receipt: 1592324 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951683,'','2','3235',3000.00,0.00,'Payment Id 400368 for invoice:257613, receipt: 122226 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951684,'','supplier','218',0.00,3000.00,'Payment Id 400368 for invoice:257613, receipt: 122226 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951685,'','2','4076',824040.00,0.00,'Payment Id 400367 for invoice:257613, receipt: 1592324 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951686,'','supplier','218',0.00,824040.00,'Payment Id 400367 for invoice:257613, receipt: 1592324 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951687,'','2','3235',17200.00,0.00,'Payment Id 400366 for invoice:257610, receipt: 113830 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951688,'','supplier','218',0.00,17200.00,'Payment Id 400366 for invoice:257610, receipt: 113830 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951689,'','2','3235',4000.00,0.00,'Payment Id 400365 for invoice:257609, receipt: 174804 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951690,'','supplier','218',0.00,4000.00,'Payment Id 400365 for invoice:257609, receipt: 174804 by SALBAS OIL & GAS NIG LTD','2022-04-29 14:24:30','',''),('5','175',4951691,'','20','3182',687731.55,0.00,'Sales from shift 257616 on 2022-05-10 09:19:22 ','2022-05-10 09:19:22','',''),('5','175',4951692,'','6.1','3183',0.00,687731.55,'Sales from shift 257616 on 2022-05-10 09:19:22 ','2022-05-10 09:19:22','',''),('5','175',4951693,'','20','3182',680544.15,0.00,'Sales from shift 257617 on 2022-05-10 11:17:17 ','2022-05-10 11:17:17','',''),('5','175',4951694,'','6.1','3183',0.00,680544.15,'Sales from shift 257617 on 2022-05-10 11:17:17 ','2022-05-10 11:17:17','',''),('5','175',4951695,'','20','3182',284024.40,0.00,'Sales from shift 257618 on 2022-05-10 15:54:19 ','2022-05-10 15:54:19','',''),('5','175',4951696,'','6.1','3183',0.00,284024.40,'Sales from shift 257618 on 2022-05-10 15:54:19 ','2022-05-10 15:54:19','',''),('5','175',4951697,'','24','3186',0.00,4372500.00,'Purchase Id 90601 for 26,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-05-10 15:59:30','',''),('5','175',4951698,'','supplier','218',4372500.00,0.00,'Purchase Id 90601 for 26,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-05-10 15:59:30','',''),('5','175',4951699,'','20','3182',0.00,0.00,'Sales from shift 257619 on 2022-05-10 15:59:47 ','2022-05-10 15:59:47','',''),('5','175',4951700,'','6.1','3183',0.00,0.00,'Sales from shift 257619 on 2022-05-10 15:59:47 ','2022-05-10 15:59:47','',''),('5','175',4951701,'','20','3182',0.00,0.00,'Sales from shift 257620 on 2022-05-10 16:15:06 ','2022-05-10 16:15:06','',''),('5','175',4951702,'','6.1','3183',0.00,0.00,'Sales from shift 257620 on 2022-05-10 16:15:06 ','2022-05-10 16:15:06','',''),('5','175',4951703,'','20','3182',0.00,0.00,'Sales from shift 257621 on 2022-05-10 20:15:04 ','2022-05-10 20:15:04','',''),('5','175',4951704,'','6.1','3183',0.00,0.00,'Sales from shift 257621 on 2022-05-10 20:15:04 ','2022-05-10 20:15:04','',''),('5','175',4951705,'','2','3235',17200.00,0.00,'Payment Id 400359 for invoice:257610, receipt: 113830 by SALBAS OIL & GAS NIG LTD','2022-05-10 22:50:54','',''),('5','175',4951706,'','supplier','218',0.00,17200.00,'Payment Id 400359 for invoice:257610, receipt: 113830 by SALBAS OIL & GAS NIG LTD','2022-05-10 22:50:54','',''),('5','175',4951707,'','20','3182',562037.85,0.00,'Sales from shift 257622 on 2022-05-11 06:40:53 ','2022-05-11 06:40:53','',''),('5','175',4951708,'','6.1','3183',0.00,562037.85,'Sales from shift 257622 on 2022-05-11 06:40:53 ','2022-05-11 06:40:53','',''),('5','175',4951709,'','20','3182',609011.70,0.00,'Sales from shift 257623 on 2022-05-11 07:14:19 ','2022-05-11 07:14:19','',''),('5','175',4951710,'','6.1','3183',0.00,609011.70,'Sales from shift 257623 on 2022-05-11 07:14:19 ','2022-05-11 07:14:19','',''),('5','175',4951711,'','20','3182',893677.95,0.00,'Sales from shift 257624 on 2022-05-11 07:48:52 ','2022-05-11 07:48:52','',''),('5','175',4951712,'','6.1','3183',0.00,893677.95,'Sales from shift 257624 on 2022-05-11 07:48:52 ','2022-05-11 07:48:52','',''),('5','175',4951713,'','20','3182',834271.35,0.00,'Sales from shift 257625 on 2022-05-11 08:31:59 ','2022-05-11 08:31:59','',''),('5','175',4951714,'','6.1','3183',0.00,834271.35,'Sales from shift 257625 on 2022-05-11 08:31:59 ','2022-05-11 08:31:59','',''),('5','175',4951715,'','20','3182',676942.20,0.00,'Sales from shift 257626 on 2022-05-11 08:42:08 ','2022-05-11 08:42:08','',''),('5','175',4951716,'','6.1','3183',0.00,676942.20,'Sales from shift 257626 on 2022-05-11 08:42:08 ','2022-05-11 08:42:08','',''),('5','175',4951717,'','20','3182',592899.45,0.00,'Sales from shift 257627 on 2022-05-11 08:44:16 ','2022-05-11 08:44:16','',''),('5','175',4951718,'','6.1','3183',0.00,592899.45,'Sales from shift 257627 on 2022-05-11 08:44:16 ','2022-05-11 08:44:16','',''),('5','175',4951719,'','6.1','3183',33400.00,0.00,'Payment Id 400377 for invoice:257617, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951720,'','supplier','218',0.00,33400.00,'Payment Id 400377 for invoice:257617, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951721,'','2','4076',647145.00,0.00,'Payment Id 400376 for invoice:257617, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951722,'','supplier','218',0.00,647145.00,'Payment Id 400376 for invoice:257617, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951723,'','6.1','3183',35400.00,0.00,'Payment Id 400375 for invoice:257616, receipt: 00000622050412192384 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951724,'','supplier','218',0.00,35400.00,'Payment Id 400375 for invoice:257616, receipt: 00000622050412192384 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951725,'','2','4076',652330.00,0.00,'Payment Id 400374 for invoice:257616, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951726,'','supplier','218',0.00,652330.00,'Payment Id 400374 for invoice:257616, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951727,'','6.1','3183',33400.00,0.00,'Payment Id 400373 for invoice:257615, receipt: 454731 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951728,'','supplier','218',0.00,33400.00,'Payment Id 400373 for invoice:257615, receipt: 454731 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951729,'','2','4076',967020.00,0.00,'Payment Id 400372 for invoice:257615, receipt: 454731 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951730,'','supplier','218',0.00,967020.00,'Payment Id 400372 for invoice:257615, receipt: 454731 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:31:17','',''),('5','175',4951731,'','6.1','3183',33400.00,0.00,'Payment Id 400384 for invoice:257623, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951732,'','supplier','218',0.00,33400.00,'Payment Id 400384 for invoice:257623, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951733,'','2','4076',575610.00,0.00,'Payment Id 400383 for invoice:257623, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951734,'','supplier','218',0.00,575610.00,'Payment Id 400383 for invoice:257623, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951735,'','6.1','3183',33400.00,0.00,'Payment Id 400382 for invoice:257622, receipt: 481033 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951736,'','supplier','218',0.00,33400.00,'Payment Id 400382 for invoice:257622, receipt: 481033 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951737,'','2','4076',528640.00,0.00,'Payment Id 400381 for invoice:257622, receipt: 481033 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951738,'','supplier','218',0.00,528640.00,'Payment Id 400381 for invoice:257622, receipt: 481033 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951739,'','6.1','3183',270100.00,0.00,'Payment Id 400380 for invoice:257618, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951740,'','supplier','218',0.00,270100.00,'Payment Id 400380 for invoice:257618, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951741,'','2','4076',13925.00,0.00,'Payment Id 400379 for invoice:257618, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951742,'','supplier','218',0.00,13925.00,'Payment Id 400379 for invoice:257618, receipt: 107065 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951743,'','2','3235',4000.00,0.00,'Payment Id 400378 for invoice:257609, receipt: 7339 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951744,'','supplier','218',0.00,4000.00,'Payment Id 400378 for invoice:257609, receipt: 7339 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:46:24','',''),('5','175',4951745,'','6.1','3183',223400.00,0.00,'Payment Id 400387 for invoice:257624, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951746,'','supplier','218',0.00,223400.00,'Payment Id 400387 for invoice:257624, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951747,'','2','3235',16000.00,0.00,'Payment Id 400386 for invoice:257624, receipt: 392655 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951748,'','supplier','218',0.00,16000.00,'Payment Id 400386 for invoice:257624, receipt: 392655 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951749,'','2','4076',654280.00,0.00,'Payment Id 400385 for invoice:257624, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951750,'','supplier','218',0.00,654280.00,'Payment Id 400385 for invoice:257624, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 09:54:49','',''),('5','175',4951751,'','2','3235',10000.00,0.00,'Payment Id 400392 for invoice:257626, receipt: 444208 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951752,'','supplier','218',0.00,10000.00,'Payment Id 400392 for invoice:257626, receipt: 444208 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951753,'','2','4076',623545.00,0.00,'Payment Id 400391 for invoice:257626, receipt: 276877 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951754,'','supplier','218',0.00,623545.00,'Payment Id 400391 for invoice:257626, receipt: 276877 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951755,'','6.1','3183',33400.00,0.00,'Payment Id 400390 for invoice:257625, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951756,'','supplier','218',0.00,33400.00,'Payment Id 400390 for invoice:257625, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951757,'','2','3235',11000.00,0.00,'Payment Id 400389 for invoice:257625, receipt: 573636 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951758,'','supplier','218',0.00,11000.00,'Payment Id 400389 for invoice:257625, receipt: 573636 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951759,'','2','4076',789870.00,0.00,'Payment Id 400388 for invoice:257625, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951760,'','supplier','218',0.00,789870.00,'Payment Id 400388 for invoice:257625, receipt: 761684 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:02','',''),('5','175',4951761,'','6.1','3183',43400.00,0.00,'Payment Id 400393 for invoice:257626, receipt: 276877 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:09','',''),('5','175',4951762,'','supplier','218',0.00,43400.00,'Payment Id 400393 for invoice:257626, receipt: 276877 by SALBAS OIL & GAS NIG LTD','2022-05-11 10:08:09','',''),('5','175',4951763,'','6.1','3183',64400.00,0.00,'Payment Id 400395 for invoice:257627, receipt: 475012 by SALBAS OIL & GAS NIG LTD','2022-05-11 16:47:46','',''),('5','175',4951764,'','supplier','218',0.00,64400.00,'Payment Id 400395 for invoice:257627, receipt: 475012 by SALBAS OIL & GAS NIG LTD','2022-05-11 16:47:46','',''),('5','175',4951765,'','2','4076',528500.00,0.00,'Payment Id 400394 for invoice:257627, receipt: 475012 by SALBAS OIL & GAS NIG LTD','2022-05-11 16:47:46','',''),('5','175',4951766,'','supplier','218',0.00,528500.00,'Payment Id 400394 for invoice:257627, receipt: 475012 by SALBAS OIL & GAS NIG LTD','2022-05-11 16:47:46','',''),('5','175',4951767,'','6.1','3183',33400.00,0.00,'Payment Id 400397 for invoice:257628, receipt: 670805 by SALBAS OIL & GAS NIG LTD','2022-05-12 15:05:02','',''),('5','175',4951768,'','supplier','218',0.00,33400.00,'Payment Id 400397 for invoice:257628, receipt: 670805 by SALBAS OIL & GAS NIG LTD','2022-05-12 15:05:02','',''),('5','175',4951769,'','2','4076',165880.00,0.00,'Payment Id 400396 for invoice:257628, receipt: 670805 by SALBAS OIL & GAS NIG LTD','2022-05-12 15:05:02','',''),('5','175',4951770,'','supplier','218',0.00,165880.00,'Payment Id 400396 for invoice:257628, receipt: 670805 by SALBAS OIL & GAS NIG LTD','2022-05-12 15:05:02','',''),('5','175',4951771,'','20','3182',199379.40,0.00,'Sales from shift 257628 on 2022-05-12 18:43:52 ','2022-05-12 18:43:52','',''),('5','175',4951772,'','6.1','3183',0.00,199379.40,'Sales from shift 257628 on 2022-05-12 18:43:52 ','2022-05-12 18:43:52','',''),('5','175',4951773,'','20','3182',0.00,0.00,'Sales from shift 257629 on 2022-05-12 22:39:13 ','2022-05-12 22:39:13','',''),('5','175',4951774,'','6.1','3183',0.00,0.00,'Sales from shift 257629 on 2022-05-12 22:39:13 ','2022-05-12 22:39:13','',''),('5','175',4951775,'','24','3186',0.00,546107.36,'Inventory value adjustment for product Id 404 from 660.00 to 700','2022-05-13 08:07:53','',''),('5','175',4951776,'','supplier','218',546107.36,0.00,'Inventory value adjustment for product Id 404 from 660.00 to 700','2022-05-13 08:07:53','',''),('5','175',4951777,'','20','3182',0.00,0.00,'Sales from shift 257630 on 2022-05-13 22:25:29 ','2022-05-13 22:25:29','',''),('5','175',4951778,'','6.1','3183',0.00,0.00,'Sales from shift 257630 on 2022-05-13 22:25:29 ','2022-05-13 22:25:29','',''),('5','175',4951779,'','20','3182',0.00,0.00,'Sales from shift 257631 on 2022-05-15 06:10:10 ','2022-05-15 06:10:10','',''),('5','175',4951780,'','6.1','3183',0.00,0.00,'Sales from shift 257631 on 2022-05-15 06:10:10 ','2022-05-15 06:10:10','',''),('5','175',4951781,'','20','3182',0.00,0.00,'Sales from shift 257632 on 2022-05-16 06:02:32 ','2022-05-16 06:02:32','',''),('5','175',4951782,'','6.1','3183',0.00,0.00,'Sales from shift 257632 on 2022-05-16 06:02:32 ','2022-05-16 06:02:32','',''),('5','175',4951783,'','20','3182',0.00,0.00,'Sales from shift 257633 on 2022-05-17 06:11:49 ','2022-05-17 06:11:49','',''),('5','175',4951784,'','6.1','3183',0.00,0.00,'Sales from shift 257633 on 2022-05-17 06:11:49 ','2022-05-17 06:11:49','',''),('5','175',4951785,'','20','3182',0.00,0.00,'Sales from shift 257634 on 2022-05-18 06:11:53 ','2022-05-18 06:11:53','',''),('5','175',4951786,'','6.1','3183',0.00,0.00,'Sales from shift 257634 on 2022-05-18 06:11:53 ','2022-05-18 06:11:53','',''),('5','175',4951787,'','20','3182',0.00,0.00,'Sales from shift 257635 on 2022-05-18 21:30:01 ','2022-05-18 21:30:01','',''),('5','175',4951788,'','6.1','3183',0.00,0.00,'Sales from shift 257635 on 2022-05-18 21:30:01 ','2022-05-18 21:30:01','',''),('5','175',4951789,'','20','3182',0.00,0.00,'Sales from shift 257636 on 2022-05-20 05:23:20 ','2022-05-20 05:23:20','',''),('5','175',4951790,'','6.1','3183',0.00,0.00,'Sales from shift 257636 on 2022-05-20 05:23:20 ','2022-05-20 05:23:20','',''),('5','175',4951791,'','20','3182',0.00,0.00,'Sales from shift 257637 on 2022-05-20 21:24:11 ','2022-05-20 21:24:11','',''),('5','175',4951792,'','6.1','3183',0.00,0.00,'Sales from shift 257637 on 2022-05-20 21:24:11 ','2022-05-20 21:24:11','',''),('5','175',4951793,'','20','3182',0.00,0.00,'Sales from shift 257638 on 2022-05-22 08:14:12 ','2022-05-22 08:14:12','',''),('5','175',4951794,'','6.1','3183',0.00,0.00,'Sales from shift 257638 on 2022-05-22 08:14:12 ','2022-05-22 08:14:12','',''),('5','175',4951795,'','20','3182',0.00,0.00,'Sales from shift 257639 on 2022-05-23 05:16:17 ','2022-05-23 05:16:17','',''),('5','175',4951796,'','6.1','3183',0.00,0.00,'Sales from shift 257639 on 2022-05-23 05:16:17 ','2022-05-23 05:16:17','',''),('5','175',4951797,'','20','3182',0.00,0.00,'Sales from shift 257640 on 2022-05-23 22:08:58 ','2022-05-23 22:08:58','',''),('5','175',4951798,'','6.1','3183',0.00,0.00,'Sales from shift 257640 on 2022-05-23 22:08:58 ','2022-05-23 22:08:58','',''),('5','175',4951799,'','20','3182',0.00,0.00,'Sales from shift 257641 on 2022-05-25 06:10:33 ','2022-05-25 06:10:33','',''),('5','175',4951800,'','6.1','3183',0.00,0.00,'Sales from shift 257641 on 2022-05-25 06:10:33 ','2022-05-25 06:10:33','',''),('5','175',4951801,'','20','3182',0.00,0.00,'Sales from shift 257642 on 2022-05-26 05:21:07 ','2022-05-26 05:21:07','',''),('5','175',4951802,'','6.1','3183',0.00,0.00,'Sales from shift 257642 on 2022-05-26 05:21:07 ','2022-05-26 05:21:07','',''),('5','175',4951803,'','20','3182',0.00,0.00,'Sales from shift 257643 on 2022-05-26 20:39:19 ','2022-05-26 20:39:19','',''),('5','175',4951804,'','6.1','3183',0.00,0.00,'Sales from shift 257643 on 2022-05-26 20:39:19 ','2022-05-26 20:39:19','',''),('5','175',4951805,'','20','3182',0.00,0.00,'Sales from shift 257644 on 2022-05-28 04:58:10 ','2022-05-28 04:58:10','',''),('5','175',4951806,'','6.1','3183',0.00,0.00,'Sales from shift 257644 on 2022-05-28 04:58:10 ','2022-05-28 04:58:10','',''),('5','175',4951807,'','24','3186',0.00,3712500.00,'Purchase Id 90604 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-05-28 22:10:58','',''),('5','175',4951808,'','supplier','218',3712500.00,0.00,'Purchase Id 90604 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-05-28 22:10:58','',''),('5','175',4951809,'','20','3182',208296.00,0.00,'Sales from shift 257645 on 2022-05-29 08:17:23 ','2022-05-29 08:17:23','',''),('5','175',4951810,'','6.1','3183',0.00,208296.00,'Sales from shift 257645 on 2022-05-29 08:17:23 ','2022-05-29 08:17:23','',''),('5','175',4951811,'','20','3182',902472.45,0.00,'Sales from shift 257646 on 2022-05-30 04:59:35 ','2022-05-30 04:59:35','',''),('5','175',4951812,'','6.1','3183',0.00,902472.45,'Sales from shift 257646 on 2022-05-30 04:59:35 ','2022-05-30 04:59:35','',''),('5','175',4951813,'','6.1','3183',45400.00,0.00,'Payment Id 400403 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951814,'','supplier','218',0.00,45400.00,'Payment Id 400403 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951815,'','2','3235',1890.00,0.00,'Payment Id 400402 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951816,'','supplier','218',0.00,1890.00,'Payment Id 400402 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951817,'','2','4076',855205.00,0.00,'Payment Id 400401 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951818,'','supplier','218',0.00,855205.00,'Payment Id 400401 for invoice:257646, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951819,'','6.1','3183',35400.00,0.00,'Payment Id 400400 for invoice:257645, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951820,'','supplier','218',0.00,35400.00,'Payment Id 400400 for invoice:257645, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951821,'','2','3235',7000.00,0.00,'Payment Id 400399 for invoice:257645, receipt: 192701 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951822,'','supplier','218',0.00,7000.00,'Payment Id 400399 for invoice:257645, receipt: 192701 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951823,'','2','4076',165895.00,0.00,'Payment Id 400398 for invoice:257645, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951824,'','supplier','218',0.00,165895.00,'Payment Id 400398 for invoice:257645, receipt: 257378 by SALBAS OIL & GAS NIG LTD','2022-05-30 16:50:28','',''),('5','175',4951825,'','20','3182',739944.15,0.00,'Sales from shift 257647 on 2022-05-31 00:20:15 ','2022-05-31 00:20:15','',''),('5','175',4951826,'','6.1','3183',0.00,739944.15,'Sales from shift 257647 on 2022-05-31 00:20:15 ','2022-05-31 00:20:15','',''),('5','175',4951827,'','6.1','3183',47400.00,0.00,'Payment Id 400407 for invoice:257647, receipt: 145215 by SALBAS OIL & GAS NIG LTD','2022-05-31 20:10:13','',''),('5','175',4951828,'','supplier','218',0.00,47400.00,'Payment Id 400407 for invoice:257647, receipt: 145215 by SALBAS OIL & GAS NIG LTD','2022-05-31 20:10:13','',''),('5','175',4951829,'','2','4076',692645.00,0.00,'Payment Id 400406 for invoice:257647, receipt: 145215 by SALBAS OIL & GAS NIG LTD','2022-05-31 20:10:13','',''),('5','175',4951830,'','supplier','218',0.00,692645.00,'Payment Id 400406 for invoice:257647, receipt: 145215 by SALBAS OIL & GAS NIG LTD','2022-05-31 20:10:13','',''),('5','175',4951831,'','20','3182',774279.00,0.00,'Sales from shift 257648 on 2022-06-01 07:04:11 ','2022-06-01 07:04:11','',''),('5','175',4951832,'','6.1','3183',0.00,774279.00,'Sales from shift 257648 on 2022-06-01 07:04:11 ','2022-06-01 07:04:11','',''),('5','175',4951833,'','6.1','3183',45400.00,0.00,'Payment Id 400409 for invoice:257648, receipt: 1588453 by SALBAS OIL & GAS NIG LTD','2022-06-01 18:39:40','',''),('5','175',4951834,'','supplier','218',0.00,45400.00,'Payment Id 400409 for invoice:257648, receipt: 1588453 by SALBAS OIL & GAS NIG LTD','2022-06-01 18:39:40','',''),('5','175',4951835,'','2','4076',728880.00,0.00,'Payment Id 400408 for invoice:257648, receipt: 1588453 by SALBAS OIL & GAS NIG LTD','2022-06-01 18:39:40','',''),('5','175',4951836,'','supplier','218',0.00,728880.00,'Payment Id 400408 for invoice:257648, receipt: 1588453 by SALBAS OIL & GAS NIG LTD','2022-06-01 18:39:40','',''),('5','175',4951837,'','20','3182',800355.60,0.00,'Sales from shift 257649 on 2022-06-02 05:01:03 ','2022-06-02 05:01:03','',''),('5','175',4951838,'','6.1','3183',0.00,800355.60,'Sales from shift 257649 on 2022-06-02 05:01:03 ','2022-06-02 05:01:03','',''),('5','175',4951839,'','6.1','3183',47100.00,0.00,'Payment Id 400411 for invoice:257649, receipt: 421772 by SALBAS OIL & GAS NIG LTD','2022-06-02 16:26:11','',''),('5','175',4951840,'','supplier','218',0.00,47100.00,'Payment Id 400411 for invoice:257649, receipt: 421772 by SALBAS OIL & GAS NIG LTD','2022-06-02 16:26:11','',''),('5','175',4951841,'','2','4076',753255.00,0.00,'Payment Id 400410 for invoice:257649, receipt: 421772 by SALBAS OIL & GAS NIG LTD','2022-06-02 16:26:11','',''),('5','175',4951842,'','supplier','218',0.00,753255.00,'Payment Id 400410 for invoice:257649, receipt: 421772 by SALBAS OIL & GAS NIG LTD','2022-06-02 16:26:11','',''),('5','175',4951843,'','20','3182',281049.45,0.00,'Sales from shift 257650 on 2022-06-03 06:46:28 ','2022-06-03 06:46:28','',''),('5','175',4951844,'','6.1','3183',0.00,281049.45,'Sales from shift 257650 on 2022-06-03 06:46:28 ','2022-06-03 06:46:28','',''),('5','175',4951845,'','6.1','3183',35400.00,0.00,'Payment Id 400413 for invoice:257650, receipt: 157805 by SALBAS OIL & GAS NIG LTD','2022-06-03 19:05:00','',''),('5','175',4951846,'','supplier','218',0.00,35400.00,'Payment Id 400413 for invoice:257650, receipt: 157805 by SALBAS OIL & GAS NIG LTD','2022-06-03 19:05:00','',''),('5','175',4951847,'','2','4076',245650.00,0.00,'Payment Id 400412 for invoice:257650, receipt: 157805 by SALBAS OIL & GAS NIG LTD','2022-06-03 19:05:00','',''),('5','175',4951848,'','supplier','218',0.00,245650.00,'Payment Id 400412 for invoice:257650, receipt: 157805 by SALBAS OIL & GAS NIG LTD','2022-06-03 19:05:00','',''),('5','175',4951849,'','20','3182',0.00,0.00,'Sales from shift 257651 on 2022-06-04 06:06:30 ','2022-06-04 06:06:30','',''),('5','175',4951850,'','6.1','3183',0.00,0.00,'Sales from shift 257651 on 2022-06-04 06:06:30 ','2022-06-04 06:06:30','',''),('5','175',4951851,'','20','3182',0.00,0.00,'Sales from shift 257652 on 2022-06-05 06:07:16 ','2022-06-05 06:07:16','',''),('5','175',4951852,'','6.1','3183',0.00,0.00,'Sales from shift 257652 on 2022-06-05 06:07:16 ','2022-06-05 06:07:16','',''),('5','175',4951853,'','20','3182',0.00,0.00,'Sales from shift 257653 on 2022-06-06 06:27:33 ','2022-06-06 06:27:33','',''),('5','175',4951854,'','6.1','3183',0.00,0.00,'Sales from shift 257653 on 2022-06-06 06:27:33 ','2022-06-06 06:27:33','',''),('5','175',4951855,'','20','3182',0.00,0.00,'Sales from shift 257654 on 2022-06-07 07:26:26 ','2022-06-07 07:26:26','',''),('5','175',4951856,'','6.1','3183',0.00,0.00,'Sales from shift 257654 on 2022-06-07 07:26:26 ','2022-06-07 07:26:26','',''),('5','175',4951857,'','20','3182',0.00,0.00,'Sales from shift 257655 on 2022-06-08 10:31:41 ','2022-06-08 10:31:41','',''),('5','175',4951858,'','6.1','3183',0.00,0.00,'Sales from shift 257655 on 2022-06-08 10:31:41 ','2022-06-08 10:31:41','',''),('5','175',4951859,'','20','3182',0.00,0.00,'Sales from shift 257656 on 2022-06-09 06:00:40 ','2022-06-09 06:00:40','',''),('5','175',4951860,'','6.1','3183',0.00,0.00,'Sales from shift 257656 on 2022-06-09 06:00:40 ','2022-06-09 06:00:40','',''),('5','175',4951861,'','20','3182',0.00,0.00,'Sales from shift 257657 on 2022-06-10 05:28:01 ','2022-06-10 05:28:01','',''),('5','175',4951862,'','6.1','3183',0.00,0.00,'Sales from shift 257657 on 2022-06-10 05:28:01 ','2022-06-10 05:28:01','',''),('5','175',4951863,'','20','3182',0.00,0.00,'Sales from shift 257658 on 2022-06-10 21:44:57 ','2022-06-10 21:44:57','',''),('5','175',4951864,'','6.1','3183',0.00,0.00,'Sales from shift 257658 on 2022-06-10 21:44:57 ','2022-06-10 21:44:57','',''),('5','175',4951865,'','20','3182',0.00,0.00,'Sales from shift 257659 on 2022-06-12 08:30:42 ','2022-06-12 08:30:42','',''),('5','175',4951866,'','6.1','3183',0.00,0.00,'Sales from shift 257659 on 2022-06-12 08:30:42 ','2022-06-12 08:30:42','',''),('5','175',4951867,'','20','3182',0.00,0.00,'Sales from shift 257660 on 2022-06-13 06:54:21 ','2022-06-13 06:54:21','',''),('5','175',4951868,'','6.1','3183',0.00,0.00,'Sales from shift 257660 on 2022-06-13 06:54:21 ','2022-06-13 06:54:21','',''),('5','175',4951869,'','20','3182',0.00,0.00,'Sales from shift 257661 on 2022-06-14 08:58:30 ','2022-06-14 08:58:30','',''),('5','175',4951870,'','6.1','3183',0.00,0.00,'Sales from shift 257661 on 2022-06-14 08:58:30 ','2022-06-14 08:58:30','',''),('5','175',4951871,'','20','3182',0.00,0.00,'Sales from shift 257662 on 2022-06-14 22:17:29 ','2022-06-14 22:17:29','',''),('5','175',4951872,'','6.1','3183',0.00,0.00,'Sales from shift 257662 on 2022-06-14 22:17:29 ','2022-06-14 22:17:29','',''),('5','175',4951873,'','20','3182',0.00,0.00,'Sales from shift 257663 on 2022-06-16 07:02:24 ','2022-06-16 07:02:24','',''),('5','175',4951874,'','6.1','3183',0.00,0.00,'Sales from shift 257663 on 2022-06-16 07:02:24 ','2022-06-16 07:02:24','',''),('5','175',4951875,'','20','3182',0.00,0.00,'Sales from shift 257664 on 2022-06-17 06:00:22 ','2022-06-17 06:00:22','',''),('5','175',4951876,'','6.1','3183',0.00,0.00,'Sales from shift 257664 on 2022-06-17 06:00:22 ','2022-06-17 06:00:22','',''),('5','175',4951877,'','20','3182',0.00,0.00,'Sales from shift 257665 on 2022-06-18 07:03:55 ','2022-06-18 07:03:55','',''),('5','175',4951878,'','6.1','3183',0.00,0.00,'Sales from shift 257665 on 2022-06-18 07:03:55 ','2022-06-18 07:03:55','',''),('5','175',4951879,'','20','3182',0.00,0.00,'Sales from shift 257666 on 2022-06-18 22:47:37 ','2022-06-18 22:47:37','',''),('5','175',4951880,'','6.1','3183',0.00,0.00,'Sales from shift 257666 on 2022-06-18 22:47:37 ','2022-06-18 22:47:37','',''),('5','175',4951881,'','20','3182',0.00,0.00,'Sales from shift 257667 on 2022-06-20 06:46:40 ','2022-06-20 06:46:40','',''),('5','175',4951882,'','6.1','3183',0.00,0.00,'Sales from shift 257667 on 2022-06-20 06:46:40 ','2022-06-20 06:46:40','',''),('5','175',4951883,'','20','3182',0.00,0.00,'Sales from shift 257668 on 2022-06-21 07:54:41 ','2022-06-21 07:54:41','',''),('5','175',4951884,'','6.1','3183',0.00,0.00,'Sales from shift 257668 on 2022-06-21 07:54:41 ','2022-06-21 07:54:41','',''),('5','175',4951885,'','20','3182',0.00,0.00,'Sales from shift 257669 on 2022-06-21 22:46:28 ','2022-06-21 22:46:28','',''),('5','175',4951886,'','6.1','3183',0.00,0.00,'Sales from shift 257669 on 2022-06-21 22:46:28 ','2022-06-21 22:46:28','',''),('5','175',4951887,'','20','3182',0.00,0.00,'Sales from shift 257670 on 2022-06-23 07:07:11 ','2022-06-23 07:07:11','',''),('5','175',4951888,'','6.1','3183',0.00,0.00,'Sales from shift 257670 on 2022-06-23 07:07:11 ','2022-06-23 07:07:11','',''),('5','175',4951889,'','20','3182',0.00,0.00,'Sales from shift 257671 on 2022-06-23 22:56:38 ','2022-06-23 22:56:38','',''),('5','175',4951890,'','6.1','3183',0.00,0.00,'Sales from shift 257671 on 2022-06-23 22:56:38 ','2022-06-23 22:56:38','',''),('5','175',4951891,'','20','3182',0.00,0.00,'Sales from shift 257672 on 2022-06-25 06:14:12 ','2022-06-25 06:14:12','',''),('5','175',4951892,'','6.1','3183',0.00,0.00,'Sales from shift 257672 on 2022-06-25 06:14:12 ','2022-06-25 06:14:12','',''),('5','175',4951893,'','20','3182',0.00,0.00,'Sales from shift 257673 on 2022-06-26 07:15:33 ','2022-06-26 07:15:33','',''),('5','175',4951894,'','6.1','3183',0.00,0.00,'Sales from shift 257673 on 2022-06-26 07:15:33 ','2022-06-26 07:15:33','',''),('5','175',4951895,'','20','3182',0.00,0.00,'Sales from shift 257674 on 2022-06-27 07:35:37 ','2022-06-27 07:35:37','',''),('5','175',4951896,'','6.1','3183',0.00,0.00,'Sales from shift 257674 on 2022-06-27 07:35:37 ','2022-06-27 07:35:37','',''),('5','175',4951897,'','20','3182',0.00,0.00,'Sales from shift 257675 on 2022-06-28 07:22:30 ','2022-06-28 07:22:30','',''),('5','175',4951898,'','6.1','3183',0.00,0.00,'Sales from shift 257675 on 2022-06-28 07:22:30 ','2022-06-28 07:22:30','',''),('5','175',4951899,'','20','3182',0.00,0.00,'Sales from shift 257676 on 2022-06-29 08:02:29 ','2022-06-29 08:02:29','',''),('5','175',4951900,'','6.1','3183',0.00,0.00,'Sales from shift 257676 on 2022-06-29 08:02:29 ','2022-06-29 08:02:29','',''),('5','175',4951901,'','20','3182',0.00,0.00,'Sales from shift 257677 on 2022-06-30 06:24:51 ','2022-06-30 06:24:51','',''),('5','175',4951902,'','6.1','3183',0.00,0.00,'Sales from shift 257677 on 2022-06-30 06:24:51 ','2022-06-30 06:24:51','',''),('5','175',4951903,'','20','3182',0.00,0.00,'Sales from shift 257678 on 2022-07-01 07:10:02 ','2022-07-01 07:10:02','',''),('5','175',4951904,'','6.1','3183',0.00,0.00,'Sales from shift 257678 on 2022-07-01 07:10:02 ','2022-07-01 07:10:02','',''),('5','175',4951905,'','20','3182',0.00,0.00,'Sales from shift 257679 on 2022-07-02 05:49:09 ','2022-07-02 05:49:09','',''),('5','175',4951906,'','6.1','3183',0.00,0.00,'Sales from shift 257679 on 2022-07-02 05:49:09 ','2022-07-02 05:49:09','',''),('5','175',4951907,'','20','3182',0.00,0.00,'Sales from shift 257680 on 2022-07-03 06:30:03 ','2022-07-03 06:30:03','',''),('5','175',4951908,'','6.1','3183',0.00,0.00,'Sales from shift 257680 on 2022-07-03 06:30:03 ','2022-07-03 06:30:03','',''),('5','175',4951909,'','20','3182',0.00,0.00,'Sales from shift 257681 on 2022-07-03 23:25:09 ','2022-07-03 23:25:09','',''),('5','175',4951910,'','6.1','3183',0.00,0.00,'Sales from shift 257681 on 2022-07-03 23:25:09 ','2022-07-03 23:25:09','',''),('5','175',4951911,'','20','3182',0.00,0.00,'Sales from shift 257682 on 2022-07-04 22:35:37 ','2022-07-04 22:35:37','',''),('5','175',4951912,'','6.1','3183',0.00,0.00,'Sales from shift 257682 on 2022-07-04 22:35:37 ','2022-07-04 22:35:37','',''),('5','175',4951913,'','20','3182',0.00,0.00,'Sales from shift 257683 on 2022-07-06 07:49:34 ','2022-07-06 07:49:34','',''),('5','175',4951914,'','6.1','3183',0.00,0.00,'Sales from shift 257683 on 2022-07-06 07:49:34 ','2022-07-06 07:49:34','',''),('5','175',4951915,'','20','3182',0.00,0.00,'Sales from shift 257684 on 2022-07-07 05:27:10 ','2022-07-07 05:27:10','',''),('5','175',4951916,'','6.1','3183',0.00,0.00,'Sales from shift 257684 on 2022-07-07 05:27:10 ','2022-07-07 05:27:10','',''),('5','175',4951917,'','20','3182',0.00,0.00,'Sales from shift 257685 on 2022-07-08 06:10:54 ','2022-07-08 06:10:54','',''),('5','175',4951918,'','6.1','3183',0.00,0.00,'Sales from shift 257685 on 2022-07-08 06:10:54 ','2022-07-08 06:10:54','',''),('5','175',4951919,'','20','3182',0.00,0.00,'Sales from shift 257686 on 2022-07-08 22:42:06 ','2022-07-08 22:42:06','',''),('5','175',4951920,'','6.1','3183',0.00,0.00,'Sales from shift 257686 on 2022-07-08 22:42:06 ','2022-07-08 22:42:06','',''),('5','175',4951921,'','20','3182',0.00,0.00,'Sales from shift 257687 on 2022-07-10 07:04:10 ','2022-07-10 07:04:10','',''),('5','175',4951922,'','6.1','3183',0.00,0.00,'Sales from shift 257687 on 2022-07-10 07:04:10 ','2022-07-10 07:04:10','',''),('5','175',4951923,'','20','3182',0.00,0.00,'Sales from shift 257688 on 2022-07-11 07:00:48 ','2022-07-11 07:00:48','',''),('5','175',4951924,'','6.1','3183',0.00,0.00,'Sales from shift 257688 on 2022-07-11 07:00:48 ','2022-07-11 07:00:48','',''),('5','175',4951925,'','20','3182',0.00,0.00,'Sales from shift 257689 on 2022-07-12 05:22:38 ','2022-07-12 05:22:38','',''),('5','175',4951926,'','6.1','3183',0.00,0.00,'Sales from shift 257689 on 2022-07-12 05:22:38 ','2022-07-12 05:22:38','',''),('5','175',4951927,'','20','3182',0.00,0.00,'Sales from shift 257690 on 2022-07-13 07:18:10 ','2022-07-13 07:18:10','',''),('5','175',4951928,'','6.1','3183',0.00,0.00,'Sales from shift 257690 on 2022-07-13 07:18:10 ','2022-07-13 07:18:10','',''),('5','175',4951929,'','20','3182',0.00,0.00,'Sales from shift 257691 on 2022-07-14 06:32:46 ','2022-07-14 06:32:46','',''),('5','175',4951930,'','6.1','3183',0.00,0.00,'Sales from shift 257691 on 2022-07-14 06:32:46 ','2022-07-14 06:32:46','',''),('5','175',4951931,'','20','3182',0.00,0.00,'Sales from shift 257692 on 2022-07-15 07:17:57 ','2022-07-15 07:17:57','',''),('5','175',4951932,'','6.1','3183',0.00,0.00,'Sales from shift 257692 on 2022-07-15 07:17:57 ','2022-07-15 07:17:57','',''),('5','175',4951933,'','20','3182',0.00,0.00,'Sales from shift 257693 on 2022-07-16 06:53:37 ','2022-07-16 06:53:37','',''),('5','175',4951934,'','6.1','3183',0.00,0.00,'Sales from shift 257693 on 2022-07-16 06:53:37 ','2022-07-16 06:53:37','',''),('5','175',4951935,'','20','3182',0.00,0.00,'Sales from shift 257694 on 2022-07-17 05:29:31 ','2022-07-17 05:29:31','',''),('5','175',4951936,'','6.1','3183',0.00,0.00,'Sales from shift 257694 on 2022-07-17 05:29:31 ','2022-07-17 05:29:31','',''),('5','175',4951937,'','24','3186',0.00,8297250.00,'Purchase Id 90605 for 44,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-07-18 10:49:08','',''),('5','175',4951938,'','supplier','218',8297250.00,0.00,'Purchase Id 90605 for 44,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-07-18 10:49:08','',''),('5','175',4951939,'','20','3182',219225.00,0.00,'Sales from shift 257695 on 2022-07-18 11:48:27 ','2022-07-18 11:48:27','',''),('5','175',4951940,'','6.1','3183',0.00,219225.00,'Sales from shift 257695 on 2022-07-18 11:48:27 ','2022-07-18 11:48:27','',''),('5','175',4951941,'','6.1','3183',40400.00,0.00,'Payment Id 400415 for invoice:257695, receipt: 6977419 by SALBAS OIL & GAS NIG LTD','2022-07-18 20:04:17','',''),('5','175',4951942,'','supplier','218',0.00,40400.00,'Payment Id 400415 for invoice:257695, receipt: 6977419 by SALBAS OIL & GAS NIG LTD','2022-07-18 20:04:17','',''),('5','175',4951943,'','2','4076',178825.00,0.00,'Payment Id 400414 for invoice:257695, receipt: 6977419 by SALBAS OIL & GAS NIG LTD','2022-07-18 20:04:17','',''),('5','175',4951944,'','supplier','218',0.00,178825.00,'Payment Id 400414 for invoice:257695, receipt: 6977419 by SALBAS OIL & GAS NIG LTD','2022-07-18 20:04:17','',''),('5','175',4951945,'','20','3182',930631.40,0.00,'Sales from shift 257696 on 2022-07-19 07:22:03 ','2022-07-19 07:22:03','',''),('5','175',4951946,'','6.1','3183',0.00,930631.40,'Sales from shift 257696 on 2022-07-19 07:22:03 ','2022-07-19 07:22:03','',''),('5','175',4951947,'','20','3182',648302.90,0.00,'Sales from shift 257697 on 2022-07-20 07:40:10 ','2022-07-20 07:40:10','',''),('5','175',4951948,'','6.1','3183',0.00,648302.90,'Sales from shift 257697 on 2022-07-20 07:40:10 ','2022-07-20 07:40:10','',''),('5','175',4951949,'','6.1','3183',474285.00,0.00,'Payment Id 400418 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951950,'','supplier','218',0.00,474285.00,'Payment Id 400418 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951951,'','2','3235',10000.00,0.00,'Payment Id 400417 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951952,'','supplier','218',0.00,10000.00,'Payment Id 400417 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951953,'','2','4076',452625.00,0.00,'Payment Id 400416 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951954,'','supplier','218',0.00,452625.00,'Payment Id 400416 for invoice:257697, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 09:02:51','',''),('5','175',4951955,'','6.1','3183',40400.00,0.00,'Payment Id 400422 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951956,'','supplier','218',0.00,40400.00,'Payment Id 400422 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951957,'','2','3235',24000.00,0.00,'Payment Id 400421 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951958,'','supplier','218',0.00,24000.00,'Payment Id 400421 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951959,'','2','4076',583905.00,0.00,'Payment Id 400420 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951960,'','supplier','218',0.00,583905.00,'Payment Id 400420 for invoice:257697, receipt: 037026 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951961,'','2','4076',452625.00,0.00,'Payment Id 400419 for invoice:257696, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951962,'','supplier','218',0.00,452625.00,'Payment Id 400419 for invoice:257696, receipt: 825826 by SALBAS OIL & GAS NIG LTD','2022-07-20 16:28:42','',''),('5','175',4951963,'','20','3182',997730.90,0.00,'Sales from shift 257698 on 2022-07-21 06:49:11 ','2022-07-21 06:49:11','',''),('5','175',4951964,'','6.1','3183',0.00,997730.90,'Sales from shift 257698 on 2022-07-21 06:49:11 ','2022-07-21 06:49:11','',''),('5','175',4951965,'','6.1','3183',265400.00,0.00,'Payment Id 400424 for invoice:257698, receipt: 880171 by SALBAS OIL & GAS NIG LTD','2022-07-21 19:57:33','',''),('5','175',4951966,'','supplier','218',0.00,265400.00,'Payment Id 400424 for invoice:257698, receipt: 880171 by SALBAS OIL & GAS NIG LTD','2022-07-21 19:57:33','',''),('5','175',4951967,'','2','4076',732330.00,0.00,'Payment Id 400423 for invoice:257698, receipt: 880171 by SALBAS OIL & GAS NIG LTD','2022-07-21 19:57:33','',''),('5','175',4951968,'','supplier','218',0.00,732330.00,'Payment Id 400423 for invoice:257698, receipt: 880171 by SALBAS OIL & GAS NIG LTD','2022-07-21 19:57:33','',''),('5','175',4951969,'','20','3182',823956.70,0.00,'Sales from shift 257699 on 2022-07-21 23:15:21 ','2022-07-21 23:15:21','',''),('5','175',4951970,'','6.1','3183',0.00,823956.70,'Sales from shift 257699 on 2022-07-21 23:15:21 ','2022-07-21 23:15:21','',''),('5','175',4951971,'','6.1','3183',40400.00,0.00,'Payment Id 400427 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951972,'','supplier','218',0.00,40400.00,'Payment Id 400427 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951973,'','2','3235',10000.00,0.00,'Payment Id 400426 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951974,'','supplier','218',0.00,10000.00,'Payment Id 400426 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951975,'','2','4076',773560.00,0.00,'Payment Id 400425 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951976,'','supplier','218',0.00,773560.00,'Payment Id 400425 for invoice:257699, receipt: 6988014 by SALBAS OIL & GAS NIG LTD','2022-07-22 16:44:52','',''),('5','175',4951977,'','20','3182',828041.50,0.00,'Sales from shift 257700 on 2022-07-23 06:54:53 ','2022-07-23 06:54:53','',''),('5','175',4951978,'','6.1','3183',0.00,828041.50,'Sales from shift 257700 on 2022-07-23 06:54:53 ','2022-07-23 06:54:53','',''),('5','175',4951979,'','20','3182',777734.45,0.00,'Sales from shift 257701 on 2022-07-24 08:32:16 ','2022-07-24 08:32:16','',''),('5','175',4951980,'','6.1','3183',0.00,777734.45,'Sales from shift 257701 on 2022-07-24 08:32:16 ','2022-07-24 08:32:16','',''),('5','175',4951981,'','20','3182',810044.70,0.00,'Sales from shift 257702 on 2022-07-25 06:44:43 ','2022-07-25 06:44:43','',''),('5','175',4951982,'','6.1','3183',0.00,810044.70,'Sales from shift 257702 on 2022-07-25 06:44:43 ','2022-07-25 06:44:43','',''),('5','175',4951983,'','20','3182',656923.90,0.00,'Sales from shift 257703 on 2022-07-26 05:53:45 ','2022-07-26 05:53:45','',''),('5','175',4951984,'','6.1','3183',0.00,656923.90,'Sales from shift 257703 on 2022-07-26 05:53:45 ','2022-07-26 05:53:45','',''),('5','175',4951985,'','2','4076',687835.00,0.00,'Payment Id 400432 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951986,'','supplier','218',0.00,687835.00,'Payment Id 400432 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951987,'','2','4076',686835.00,0.00,'Payment Id 400431 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951988,'','supplier','218',0.00,686835.00,'Payment Id 400431 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951989,'','6.1','3183',32400.00,0.00,'Payment Id 400430 for invoice:257700, receipt: 623761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951990,'','supplier','218',0.00,32400.00,'Payment Id 400430 for invoice:257700, receipt: 623761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951991,'','2','3235',57300.00,0.00,'Payment Id 400429 for invoice:257700, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951992,'','supplier','218',0.00,57300.00,'Payment Id 400429 for invoice:257700, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951993,'','2','4076',738340.00,0.00,'Payment Id 400428 for invoice:257700, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951994,'','supplier','218',0.00,738340.00,'Payment Id 400428 for invoice:257700, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-26 22:37:12','',''),('5','175',4951995,'','6.1','3183',32400.00,0.00,'Payment Id 400438 for invoice:257703, receipt: 600553 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4951996,'','supplier','218',0.00,32400.00,'Payment Id 400438 for invoice:257703, receipt: 600553 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4951997,'','2','4076',624425.00,0.00,'Payment Id 400437 for invoice:257703, receipt: 600553 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4951998,'','supplier','218',0.00,624425.00,'Payment Id 400437 for invoice:257703, receipt: 600553 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4951999,'','6.1','3183',32400.00,0.00,'Payment Id 400436 for invoice:257702, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952000,'','supplier','218',0.00,32400.00,'Payment Id 400436 for invoice:257702, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952001,'','2','4076',777645.00,0.00,'Payment Id 400435 for invoice:257702, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952002,'','supplier','218',0.00,777645.00,'Payment Id 400435 for invoice:257702, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952003,'','6.1','3183',32400.00,0.00,'Payment Id 400434 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952004,'','supplier','218',0.00,32400.00,'Payment Id 400434 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952005,'','2','3235',57300.00,0.00,'Payment Id 400433 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952006,'','supplier','218',0.00,57300.00,'Payment Id 400433 for invoice:257701, receipt: 613761 by SALBAS OIL & GAS NIG LTD','2022-07-27 06:02:07','',''),('5','175',4952007,'','20','3182',572469.55,0.00,'Sales from shift 257704 on 2022-07-27 07:30:12 ','2022-07-27 07:30:12','',''),('5','175',4952008,'','6.1','3183',0.00,572469.55,'Sales from shift 257704 on 2022-07-27 07:30:12 ','2022-07-27 07:30:12','',''),('5','175',4952009,'','20','3182',742471.60,0.00,'Sales from shift 257705 on 2022-07-28 06:53:54 ','2022-07-28 06:53:54','',''),('5','175',4952010,'','6.1','3183',0.00,742471.60,'Sales from shift 257705 on 2022-07-28 06:53:54 ','2022-07-28 06:53:54','',''),('5','175',4952011,'','6.1','3183',32400.00,0.00,'Payment Id 400441 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952012,'','supplier','218',0.00,32400.00,'Payment Id 400441 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952013,'','2','3235',5000.00,0.00,'Payment Id 400440 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952014,'','supplier','218',0.00,5000.00,'Payment Id 400440 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952015,'','2','4076',535070.00,0.00,'Payment Id 400439 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952016,'','supplier','218',0.00,535070.00,'Payment Id 400439 for invoice:257704, receipt: 380515 by SALBAS OIL & GAS NIG LTD','2022-07-28 06:54:20','',''),('5','175',4952017,'','20','3182',290187.30,0.00,'Sales from shift 257706 on 2022-07-29 07:12:22 ','2022-07-29 07:12:22','',''),('5','175',4952018,'','6.1','3183',0.00,290187.30,'Sales from shift 257706 on 2022-07-29 07:12:22 ','2022-07-29 07:12:22','',''),('5','175',4952019,'','20','3182',0.00,0.00,'Sales from shift 257707 on 2022-07-30 05:48:27 ','2022-07-30 05:48:27','',''),('5','175',4952020,'','6.1','3183',0.00,0.00,'Sales from shift 257707 on 2022-07-30 05:48:27 ','2022-07-30 05:48:27','',''),('5','175',4952021,'','20','3182',0.00,0.00,'Sales from shift 257708 on 2022-07-31 05:23:03 ','2022-07-31 05:23:03','',''),('5','175',4952022,'','6.1','3183',0.00,0.00,'Sales from shift 257708 on 2022-07-31 05:23:03 ','2022-07-31 05:23:03','',''),('5','175',4952023,'','20','3182',0.00,0.00,'Sales from shift 257709 on 2022-08-01 07:48:50 ','2022-08-01 07:48:50','',''),('5','175',4952024,'','6.1','3183',0.00,0.00,'Sales from shift 257709 on 2022-08-01 07:48:50 ','2022-08-01 07:48:50','',''),('5','175',4952025,'','20','3182',0.00,0.00,'Sales from shift 257710 on 2022-08-02 05:38:21 ','2022-08-02 05:38:21','',''),('5','175',4952026,'','6.1','3183',0.00,0.00,'Sales from shift 257710 on 2022-08-02 05:38:21 ','2022-08-02 05:38:21','',''),('5','175',4952027,'','20','3182',0.00,0.00,'Sales from shift 257711 on 2022-08-03 06:59:13 ','2022-08-03 06:59:13','',''),('5','175',4952028,'','6.1','3183',0.00,0.00,'Sales from shift 257711 on 2022-08-03 06:59:13 ','2022-08-03 06:59:13','',''),('5','175',4952029,'','20','3182',0.00,0.00,'Sales from shift 257712 on 2022-08-04 06:15:06 ','2022-08-04 06:15:06','',''),('5','175',4952030,'','6.1','3183',0.00,0.00,'Sales from shift 257712 on 2022-08-04 06:15:06 ','2022-08-04 06:15:06','',''),('5','175',4952031,'','20','3182',0.00,0.00,'Sales from shift 257713 on 2022-08-04 21:55:16 ','2022-08-04 21:55:16','',''),('5','175',4952032,'','6.1','3183',0.00,0.00,'Sales from shift 257713 on 2022-08-04 21:55:16 ','2022-08-04 21:55:16','',''),('5','175',4952033,'','20','3182',0.00,0.00,'Sales from shift 257714 on 2022-08-06 06:55:56 ','2022-08-06 06:55:56','',''),('5','175',4952034,'','6.1','3183',0.00,0.00,'Sales from shift 257714 on 2022-08-06 06:55:56 ','2022-08-06 06:55:56','',''),('5','175',4952035,'','20','3182',0.00,0.00,'Sales from shift 257715 on 2022-08-07 05:36:52 ','2022-08-07 05:36:52','',''),('5','175',4952036,'','6.1','3183',0.00,0.00,'Sales from shift 257715 on 2022-08-07 05:36:52 ','2022-08-07 05:36:52','',''),('5','175',4952037,'','20','3182',0.00,0.00,'Sales from shift 257716 on 2022-09-04 19:39:13 ','2022-09-04 19:39:13','',''),('5','175',4952038,'','6.1','3183',0.00,0.00,'Sales from shift 257716 on 2022-09-04 19:39:13 ','2022-09-04 19:39:13','',''),('5','175',4952039,'','20','3182',0.00,0.00,'Sales from shift 257717 on 2022-09-05 10:37:08 ','2022-09-05 10:37:08','',''),('5','175',4952040,'','6.1','3183',0.00,0.00,'Sales from shift 257717 on 2022-09-05 10:37:08 ','2022-09-05 10:37:08','',''),('5','175',4952041,'','20','3182',0.00,0.00,'Sales from shift 257718 on 2022-09-05 10:40:30 ','2022-09-05 10:40:30','',''),('5','175',4952042,'','6.1','3183',0.00,0.00,'Sales from shift 257718 on 2022-09-05 10:40:30 ','2022-09-05 10:40:30','',''),('5','175',4952043,'','6.1','3183',40400.00,0.00,'Payment Id 400445 for invoice:257706, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952044,'','supplier','218',0.00,40400.00,'Payment Id 400445 for invoice:257706, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952045,'','2','4076',249885.00,0.00,'Payment Id 400444 for invoice:257706, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952046,'','supplier','218',0.00,249885.00,'Payment Id 400444 for invoice:257706, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952047,'','6.1','3183',32400.00,0.00,'Payment Id 400443 for invoice:257705, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952048,'','supplier','218',0.00,32400.00,'Payment Id 400443 for invoice:257705, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952049,'','2','4076',710070.00,0.00,'Payment Id 400442 for invoice:257705, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952050,'','supplier','218',0.00,710070.00,'Payment Id 400442 for invoice:257705, receipt: 810470 by SALBAS OIL & GAS NIG LTD','2022-09-05 10:41:08','',''),('5','175',4952051,'','20','3182',0.00,0.00,'Sales from shift 257719 on 2022-09-05 10:43:14 ','2022-09-05 10:43:14','',''),('5','175',4952052,'','6.1','3183',0.00,0.00,'Sales from shift 257719 on 2022-09-05 10:43:14 ','2022-09-05 10:43:14','',''),('5','175',4952053,'','20','3182',0.00,0.00,'Sales from shift 257720 on 2022-09-05 10:45:10 ','2022-09-05 10:45:10','',''),('5','175',4952054,'','6.1','3183',0.00,0.00,'Sales from shift 257720 on 2022-09-05 10:45:10 ','2022-09-05 10:45:10','',''),('5','175',4952055,'','20','3182',0.00,0.00,'Sales from shift 257721 on 2022-09-05 10:47:27 ','2022-09-05 10:47:27','',''),('5','175',4952056,'','6.1','3183',0.00,0.00,'Sales from shift 257721 on 2022-09-05 10:47:27 ','2022-09-05 10:47:27','',''),('5','175',4952057,'','24','3186',0.00,9222250.00,'Purchase Id 90606 for 49,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-05 10:53:03','',''),('5','175',4952058,'','supplier','218',9222250.00,0.00,'Purchase Id 90606 for 49,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-05 10:53:03','',''),('5','175',4952059,'','20','3182',309042.50,0.00,'Sales from shift 257722 on 2022-09-05 11:08:03 ','2022-09-05 11:08:03','',''),('5','175',4952060,'','6.1','3183',0.00,309042.50,'Sales from shift 257722 on 2022-09-05 11:08:03 ','2022-09-05 11:08:03','',''),('5','175',4952061,'','20','3182',790838.00,0.00,'Sales from shift 257723 on 2022-09-05 11:10:28 ','2022-09-05 11:10:28','',''),('5','175',4952062,'','6.1','3183',0.00,790838.00,'Sales from shift 257723 on 2022-09-05 11:10:28 ','2022-09-05 11:10:28','',''),('5','175',4952063,'','20','3182',831168.00,0.00,'Sales from shift 257724 on 2022-09-05 11:13:57 ','2022-09-05 11:13:57','',''),('5','175',4952064,'','6.1','3183',0.00,831168.00,'Sales from shift 257724 on 2022-09-05 11:13:57 ','2022-09-05 11:13:57','',''),('5','175',4952065,'','20','3182',908510.95,0.00,'Sales from shift 257725 on 2022-09-05 11:17:38 ','2022-09-05 11:17:38','',''),('5','175',4952066,'','6.1','3183',0.00,908510.95,'Sales from shift 257725 on 2022-09-05 11:17:38 ','2022-09-05 11:17:38','',''),('5','175',4952067,'','20','3182',1028381.70,0.00,'Sales from shift 257726 on 2022-09-05 11:25:00 ','2022-09-05 11:25:00','',''),('5','175',4952068,'','6.1','3183',0.00,1028381.70,'Sales from shift 257726 on 2022-09-05 11:25:00 ','2022-09-05 11:25:00','',''),('5','175',4952069,'','20','3182',849797.50,0.00,'Sales from shift 257727 on 2022-09-05 11:29:03 ','2022-09-05 11:29:03','',''),('5','175',4952070,'','6.1','3183',0.00,849797.50,'Sales from shift 257727 on 2022-09-05 11:29:03 ','2022-09-05 11:29:03','',''),('5','175',4952071,'','20','3182',1142051.25,0.00,'Sales from shift 257728 on 2022-09-05 11:33:00 ','2022-09-05 11:33:00','',''),('5','175',4952072,'','6.1','3183',0.00,1142051.25,'Sales from shift 257728 on 2022-09-05 11:33:00 ','2022-09-05 11:33:00','',''),('5','175',4952073,'','20','3182',675697.70,0.00,'Sales from shift 257729 on 2022-09-05 11:40:28 ','2022-09-05 11:40:28','',''),('5','175',4952074,'','6.1','3183',0.00,675697.70,'Sales from shift 257729 on 2022-09-05 11:40:28 ','2022-09-05 11:40:28','',''),('5','175',4952075,'','20','3182',783384.35,0.00,'Sales from shift 257730 on 2022-09-05 11:45:41 ','2022-09-05 11:45:41','',''),('5','175',4952076,'','6.1','3183',0.00,783384.35,'Sales from shift 257730 on 2022-09-05 11:45:41 ','2022-09-05 11:45:41','',''),('5','175',4952077,'','20','3182',857915.30,0.00,'Sales from shift 257731 on 2022-09-05 11:55:11 ','2022-09-05 11:55:11','',''),('5','175',4952078,'','6.1','3183',0.00,857915.30,'Sales from shift 257731 on 2022-09-05 11:55:11 ','2022-09-05 11:55:11','',''),('5','175',4952079,'','20','3182',412200.35,0.00,'Sales from shift 257732 on 2022-09-05 11:58:56 ','2022-09-05 11:58:56','',''),('5','175',4952080,'','6.1','3183',0.00,412200.35,'Sales from shift 257732 on 2022-09-05 11:58:56 ','2022-09-05 11:58:56','',''),('5','175',4952081,'','20','3182',407111.00,0.00,'Sales from shift 257733 on 2022-09-05 12:04:49 ','2022-09-05 12:04:49','',''),('5','175',4952082,'','6.1','3183',0.00,407111.00,'Sales from shift 257733 on 2022-09-05 12:04:49 ','2022-09-05 12:04:49','',''),('5','175',4952083,'','20','3182',221889.00,0.00,'Sales from shift 257734 on 2022-09-05 12:07:41 ','2022-09-05 12:07:41','',''),('5','175',4952084,'','6.1','3183',0.00,221889.00,'Sales from shift 257734 on 2022-09-05 12:07:41 ','2022-09-05 12:07:41','',''),('5','175',4952085,'','20','3182',0.00,0.00,'Sales from shift 257735 on 2022-09-05 12:12:27 ','2022-09-05 12:12:27','',''),('5','175',4952086,'','6.1','3183',0.00,0.00,'Sales from shift 257735 on 2022-09-05 12:12:27 ','2022-09-05 12:12:27','',''),('5','175',4952087,'','20','3182',0.00,0.00,'Sales from shift 257736 on 2022-09-05 12:16:43 ','2022-09-05 12:16:43','',''),('5','175',4952088,'','6.1','3183',0.00,0.00,'Sales from shift 257736 on 2022-09-05 12:16:43 ','2022-09-05 12:16:43','',''),('5','175',4952089,'','20','3182',0.00,0.00,'Sales from shift 257737 on 2022-09-05 12:20:39 ','2022-09-05 12:20:39','',''),('5','175',4952090,'','6.1','3183',0.00,0.00,'Sales from shift 257737 on 2022-09-05 12:20:39 ','2022-09-05 12:20:39','',''),('5','175',4952091,'','20','3182',0.00,0.00,'Sales from shift 257738 on 2022-09-05 12:22:27 ','2022-09-05 12:22:27','',''),('5','175',4952092,'','6.1','3183',0.00,0.00,'Sales from shift 257738 on 2022-09-05 12:22:27 ','2022-09-05 12:22:27','',''),('5','175',4952093,'','20','3182',0.00,0.00,'Sales from shift 257739 on 2022-09-05 12:28:31 ','2022-09-05 12:28:31','',''),('5','175',4952094,'','6.1','3183',0.00,0.00,'Sales from shift 257739 on 2022-09-05 12:28:31 ','2022-09-05 12:28:31','',''),('5','175',4952095,'','20','3182',0.00,0.00,'Sales from shift 257740 on 2022-09-05 12:33:21 ','2022-09-05 12:33:21','',''),('5','175',4952096,'','6.1','3183',0.00,0.00,'Sales from shift 257740 on 2022-09-05 12:33:21 ','2022-09-05 12:33:21','',''),('5','175',4952097,'','20','3182',0.00,0.00,'Sales from shift 257741 on 2022-09-05 12:36:39 ','2022-09-05 12:36:39','',''),('5','175',4952098,'','6.1','3183',0.00,0.00,'Sales from shift 257741 on 2022-09-05 12:36:39 ','2022-09-05 12:36:39','',''),('5','175',4952099,'','24','3186',0.00,8325000.00,'Purchase Id 90607 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-05 12:37:07','',''),('5','175',4952100,'','supplier','218',8325000.00,0.00,'Purchase Id 90607 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-05 12:37:07','',''),('5','175',4952101,'','20','3182',0.00,0.00,'Sales from shift 257742 on 2022-09-05 12:40:42 ','2022-09-05 12:40:42','',''),('5','175',4952102,'','6.1','3183',0.00,0.00,'Sales from shift 257742 on 2022-09-05 12:40:42 ','2022-09-05 12:40:42','',''),('5','175',4952103,'','20','3182',0.00,0.00,'Sales from shift 257743 on 2022-09-05 12:46:00 ','2022-09-05 12:46:00','',''),('5','175',4952104,'','6.1','3183',0.00,0.00,'Sales from shift 257743 on 2022-09-05 12:46:00 ','2022-09-05 12:46:00','',''),('5','175',4952105,'','20','3182',0.00,0.00,'Sales from shift 257744 on 2022-09-05 12:49:29 ','2022-09-05 12:49:29','',''),('5','175',4952106,'','6.1','3183',0.00,0.00,'Sales from shift 257744 on 2022-09-05 12:49:29 ','2022-09-05 12:49:29','',''),('5','175',4952107,'','20','3182',0.00,0.00,'Sales from shift 257745 on 2022-09-05 13:08:48 ','2022-09-05 13:08:48','',''),('5','175',4952108,'','6.1','3183',0.00,0.00,'Sales from shift 257745 on 2022-09-05 13:08:48 ','2022-09-05 13:08:48','',''),('5','175',4952109,'','6.1','3183',20400.00,0.00,'Payment Id 400480 for invoice:257734, receipt: 265568 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952110,'','supplier','218',0.00,20400.00,'Payment Id 400480 for invoice:257734, receipt: 265568 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952111,'','2','4076',201390.00,0.00,'Payment Id 400479 for invoice:257734, receipt: 265568 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952112,'','supplier','218',0.00,201390.00,'Payment Id 400479 for invoice:257734, receipt: 265568 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952113,'','6.1','3183',20400.00,0.00,'Payment Id 400478 for invoice:257733, receipt: 350518 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952114,'','supplier','218',0.00,20400.00,'Payment Id 400478 for invoice:257733, receipt: 350518 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952115,'','2','4076',386810.00,0.00,'Payment Id 400477 for invoice:257733, receipt: 350518 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952116,'','supplier','218',0.00,386810.00,'Payment Id 400477 for invoice:257733, receipt: 350518 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952117,'','6.1','3183',30400.00,0.00,'Payment Id 400476 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952118,'','supplier','218',0.00,30400.00,'Payment Id 400476 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952119,'','2','3235',24400.00,0.00,'Payment Id 400475 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952120,'','supplier','218',0.00,24400.00,'Payment Id 400475 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952121,'','2','4076',357400.00,0.00,'Payment Id 400474 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952122,'','supplier','218',0.00,357400.00,'Payment Id 400474 for invoice:257732, receipt: 631842 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952123,'','6.1','3183',23400.00,0.00,'Payment Id 400473 for invoice:257746, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952124,'','supplier','218',0.00,23400.00,'Payment Id 400473 for invoice:257746, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952125,'','2','3235',10000.00,0.00,'Payment Id 400472 for invoice:257746, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952126,'','supplier','218',0.00,10000.00,'Payment Id 400472 for invoice:257746, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952127,'','2','4076',824520.00,0.00,'Payment Id 400471 for invoice:257731, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952128,'','supplier','218',0.00,824520.00,'Payment Id 400471 for invoice:257731, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:15','',''),('5','175',4952129,'','6.1','3183',20400.00,0.00,'Payment Id 400470 for invoice:257730, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952130,'','supplier','218',0.00,20400.00,'Payment Id 400470 for invoice:257730, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952131,'','2','4076',763545.00,0.00,'Payment Id 400469 for invoice:257730, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952132,'','supplier','218',0.00,763545.00,'Payment Id 400469 for invoice:257730, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952133,'','2','3235',10000.00,0.00,'Payment Id 400468 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952134,'','supplier','218',0.00,10000.00,'Payment Id 400468 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952135,'','2','3235',20400.00,0.00,'Payment Id 400467 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952136,'','supplier','218',0.00,20400.00,'Payment Id 400467 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952137,'','2','3235',20400.00,0.00,'Payment Id 400466 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952138,'','supplier','218',0.00,20400.00,'Payment Id 400466 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952139,'','2','4076',644745.00,0.00,'Payment Id 400465 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952140,'','supplier','218',0.00,644745.00,'Payment Id 400465 for invoice:257729, receipt: 845018 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952141,'','6.1','3183',20400.00,0.00,'Payment Id 400464 for invoice:257728, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952142,'','supplier','218',0.00,20400.00,'Payment Id 400464 for invoice:257728, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952143,'','2','3235',2000.00,0.00,'Payment Id 400463 for invoice:2577428, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952144,'','supplier','218',0.00,2000.00,'Payment Id 400463 for invoice:2577428, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952145,'','2','4076',1119650.00,0.00,'Payment Id 400462 for invoice:257728, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952146,'','supplier','218',0.00,1119650.00,'Payment Id 400462 for invoice:257728, receipt: 047830 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952147,'','6.1','3183',222100.00,0.00,'Payment Id 400461 for invoice:257727, receipt: 823315 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952148,'','supplier','218',0.00,222100.00,'Payment Id 400461 for invoice:257727, receipt: 823315 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:37:40','',''),('5','175',4952149,'','2','4076',627695.00,0.00,'Payment Id 400460 for invoice:257727, receipt: 823315 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952150,'','supplier','218',0.00,627695.00,'Payment Id 400460 for invoice:257727, receipt: 823315 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952151,'','6.1','3183',630200.00,0.00,'Payment Id 400459 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952152,'','supplier','218',0.00,630200.00,'Payment Id 400459 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952153,'','2','3235',47350.00,0.00,'Payment Id 400458 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952154,'','supplier','218',0.00,47350.00,'Payment Id 400458 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952155,'','2','4076',330830.00,0.00,'Payment Id 400457 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952156,'','supplier','218',0.00,330830.00,'Payment Id 400457 for invoice:257726, receipt: 331010 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952157,'','6.1','3183',20400.00,0.00,'Payment Id 400456 for invoice:2577425, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952158,'','supplier','218',0.00,20400.00,'Payment Id 400456 for invoice:2577425, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952159,'','2','3235',1000.00,0.00,'Payment Id 400455 for invoice:257725, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952160,'','supplier','218',0.00,1000.00,'Payment Id 400455 for invoice:257725, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952161,'','2','4076',887110.00,0.00,'Payment Id 400454 for invoice:257725, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952162,'','supplier','218',0.00,887110.00,'Payment Id 400454 for invoice:257725, receipt: 048203 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952163,'','6.1','3183',20400.00,0.00,'Payment Id 400453 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952164,'','supplier','218',0.00,20400.00,'Payment Id 400453 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952165,'','2','3235',14000.00,0.00,'Payment Id 400452 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952166,'','supplier','218',0.00,14000.00,'Payment Id 400452 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952167,'','2','4076',796770.00,0.00,'Payment Id 400451 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952168,'','supplier','218',0.00,796770.00,'Payment Id 400451 for invoice:257724, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:07','',''),('5','175',4952169,'','2','3235',17500.00,0.00,'Payment Id 400450 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952170,'','supplier','218',0.00,17500.00,'Payment Id 400450 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952171,'','6.1','3183',43400.00,0.00,'Payment Id 400449 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952172,'','supplier','218',0.00,43400.00,'Payment Id 400449 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952173,'','2','4076',729940.00,0.00,'Payment Id 400448 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952174,'','supplier','218',0.00,729940.00,'Payment Id 400448 for invoice:257723, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952175,'','6.1','3183',20400.00,0.00,'Payment Id 400447 for invoice:257722, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952176,'','supplier','218',0.00,20400.00,'Payment Id 400447 for invoice:257722, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952177,'','2','4076',288640.00,0.00,'Payment Id 400446 for invoice:257722, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952178,'','supplier','218',0.00,288640.00,'Payment Id 400446 for invoice:257722, receipt: 767582 by SALBAS OIL & GAS NIG LTD','2022-09-05 16:38:28','',''),('5','175',4952179,'','20','3182',493210.00,0.00,'Sales from shift 257746 on 2022-09-06 10:27:57 ','2022-09-06 10:27:57','',''),('5','175',4952180,'','6.1','3183',0.00,493210.00,'Sales from shift 257746 on 2022-09-06 10:27:57 ','2022-09-06 10:27:57','',''),('5','175',4952181,'','20','3182',1111862.95,0.00,'Sales from shift 257747 on 2022-09-07 08:24:35 ','2022-09-07 08:24:35','',''),('5','175',4952182,'','6.1','3183',0.00,1111862.95,'Sales from shift 257747 on 2022-09-07 08:24:35 ','2022-09-07 08:24:35','',''),('5','175',4952183,'','6.1','3183',20400.00,0.00,'Payment Id 400483 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952184,'','supplier','218',0.00,20400.00,'Payment Id 400483 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952185,'','2','3235',11000.00,0.00,'Payment Id 400482 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952186,'','supplier','218',0.00,11000.00,'Payment Id 400482 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952187,'','2','4076',462920.00,0.00,'Payment Id 400481 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952188,'','supplier','218',0.00,462920.00,'Payment Id 400481 for invoice:257745, receipt: 166788 by SALBAS OIL & GAS NIG LTD','2022-09-07 08:24:56','',''),('5','175',4952189,'','20','3182',917601.85,0.00,'Sales from shift 257748 on 2022-09-08 07:10:42 ','2022-09-08 07:10:42','',''),('5','175',4952190,'','6.1','3183',0.00,917601.85,'Sales from shift 257748 on 2022-09-08 07:10:42 ','2022-09-08 07:10:42','',''),('5','175',4952191,'','6.1','3183',20400.00,0.00,'Payment Id 400486 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952192,'','supplier','218',0.00,20400.00,'Payment Id 400486 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952193,'','2','3235',62000.00,0.00,'Payment Id 400485 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952194,'','supplier','218',0.00,62000.00,'Payment Id 400485 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952195,'','2','4076',1028350.00,0.00,'Payment Id 400484 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952196,'','supplier','218',0.00,1028350.00,'Payment Id 400484 for invoice:257747, receipt: 402445 by SALBAS OIL & GAS NIG LTD','2022-09-08 07:11:00','',''),('5','175',4952197,'','20','3182',988934.15,0.00,'Sales from shift 257749 on 2022-09-09 08:18:03 ','2022-09-09 08:18:03','',''),('5','175',4952198,'','6.1','3183',0.00,988934.15,'Sales from shift 257749 on 2022-09-09 08:18:03 ','2022-09-09 08:18:03','',''),('5','175',4952199,'','6.1','3183',22400.00,0.00,'Payment Id 400489 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952200,'','supplier','218',0.00,22400.00,'Payment Id 400489 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952201,'','2','3235',25850.00,0.00,'Payment Id 400488 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952202,'','supplier','218',0.00,25850.00,'Payment Id 400488 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952203,'','2','4076',869350.00,0.00,'Payment Id 400487 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952204,'','supplier','218',0.00,869350.00,'Payment Id 400487 for invoice:257748, receipt: 784454 by SALBAS OIL & GAS NIG LTD','2022-09-09 08:18:20','',''),('5','175',4952205,'','20','3182',665864.95,0.00,'Sales from shift 257750 on 2022-09-10 09:39:38 ','2022-09-10 09:39:38','',''),('5','175',4952206,'','6.1','3183',0.00,665864.95,'Sales from shift 257750 on 2022-09-10 09:39:38 ','2022-09-10 09:39:38','',''),('5','175',4952207,'','6.1','3183',20400.00,0.00,'Payment Id 400491 for invoice:257748, receipt: 677103 by SALBAS OIL & GAS NIG LTD','2022-09-10 09:39:58','',''),('5','175',4952208,'','supplier','218',0.00,20400.00,'Payment Id 400491 for invoice:257748, receipt: 677103 by SALBAS OIL & GAS NIG LTD','2022-09-10 09:39:58','',''),('5','175',4952209,'','2','4076',968530.00,0.00,'Payment Id 400490 for invoice:257748, receipt: 677103 by SALBAS OIL & GAS NIG LTD','2022-09-10 09:39:58','',''),('5','175',4952210,'','supplier','218',0.00,968530.00,'Payment Id 400490 for invoice:257748, receipt: 677103 by SALBAS OIL & GAS NIG LTD','2022-09-10 09:39:58','',''),('5','175',4952211,'','20','3182',772606.25,0.00,'Sales from shift 257751 on 2022-09-11 08:55:58 ','2022-09-11 08:55:58','',''),('5','175',4952212,'','6.1','3183',0.00,772606.25,'Sales from shift 257751 on 2022-09-11 08:55:58 ','2022-09-11 08:55:58','',''),('5','175',4952213,'','20','3182',782847.85,0.00,'Sales from shift 257752 on 2022-09-12 08:56:15 ','2022-09-12 08:56:15','',''),('5','175',4952214,'','6.1','3183',0.00,782847.85,'Sales from shift 257752 on 2022-09-12 08:56:15 ','2022-09-12 08:56:15','',''),('5','175',4952215,'','6.1','3183',20400.00,0.00,'Payment Id 400497 for invoice:257752, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:03','',''),('5','175',4952216,'','supplier','218',0.00,20400.00,'Payment Id 400497 for invoice:257752, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:03','',''),('5','175',4952217,'','2','4076',762440.00,0.00,'Payment Id 400496 for invoice:257752, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952218,'','supplier','218',0.00,762440.00,'Payment Id 400496 for invoice:257752, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952219,'','6.1','3183',210400.00,0.00,'Payment Id 400495 for invoice:257751, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952220,'','supplier','218',0.00,210400.00,'Payment Id 400495 for invoice:257751, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952221,'','2','4076',562200.00,0.00,'Payment Id 400494 for invoice:257751, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952222,'','supplier','218',0.00,562200.00,'Payment Id 400494 for invoice:257751, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952223,'','6.1','3183',55400.00,0.00,'Payment Id 400493 for invoice:257750, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952224,'','supplier','218',0.00,55400.00,'Payment Id 400493 for invoice:257750, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952225,'','2','4076',610465.00,0.00,'Payment Id 400492 for invoice:257750, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952226,'','supplier','218',0.00,610465.00,'Payment Id 400492 for invoice:257750, receipt: 817451 by SALBAS OIL & GAS NIG LTD','2022-09-13 09:15:04','',''),('5','175',4952227,'','20','3182',833663.65,0.00,'Sales from shift 257753 on 2022-09-13 09:15:19 ','2022-09-13 09:15:19','',''),('5','175',4952228,'','6.1','3183',0.00,833663.65,'Sales from shift 257753 on 2022-09-13 09:15:19 ','2022-09-13 09:15:19','',''),('5','175',4952229,'','20','3182',744810.00,0.00,'Sales from shift 257754 on 2022-09-14 08:14:09 ','2022-09-14 08:14:09','',''),('5','175',4952230,'','6.1','3183',0.00,744810.00,'Sales from shift 257754 on 2022-09-14 08:14:09 ','2022-09-14 08:14:09','',''),('5','175',4952231,'','6.1','3183',20400.00,0.00,'Payment Id 400500 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952232,'','supplier','218',0.00,20400.00,'Payment Id 400500 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952233,'','2','3235',107000.00,0.00,'Payment Id 400499 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952234,'','supplier','218',0.00,107000.00,'Payment Id 400499 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952235,'','2','4076',706260.00,0.00,'Payment Id 400498 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952236,'','supplier','218',0.00,706260.00,'Payment Id 400498 for invoice:257753, receipt: 881675 by SALBAS OIL & GAS NIG LTD','2022-09-14 08:14:35','',''),('5','175',4952237,'','20','3182',659902.40,0.00,'Sales from shift 257755 on 2022-09-15 08:52:10 ','2022-09-15 08:52:10','',''),('5','175',4952238,'','6.1','3183',0.00,659902.40,'Sales from shift 257755 on 2022-09-15 08:52:10 ','2022-09-15 08:52:10','',''),('5','175',4952239,'','6.1','3183',20400.00,0.00,'Payment Id 400503 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952240,'','supplier','218',0.00,20400.00,'Payment Id 400503 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952241,'','2','3235',6950.00,0.00,'Payment Id 400502 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952242,'','supplier','218',0.00,6950.00,'Payment Id 400502 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952243,'','2','4076',717460.00,0.00,'Payment Id 400501 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952244,'','supplier','218',0.00,717460.00,'Payment Id 400501 for invoice:257754, receipt: 360316 by SALBAS OIL & GAS NIG LTD','2022-09-15 08:52:29','',''),('5','175',4952245,'','20','3182',405941.80,0.00,'Sales from shift 257756 on 2022-09-16 09:08:55 ','2022-09-16 09:08:55','',''),('5','175',4952246,'','6.1','3183',0.00,405941.80,'Sales from shift 257756 on 2022-09-16 09:08:55 ','2022-09-16 09:08:55','',''),('5','175',4952247,'','6.1','3183',20400.00,0.00,'Payment Id 400506 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952248,'','supplier','218',0.00,20400.00,'Payment Id 400506 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952249,'','2','3235',6000.00,0.00,'Payment Id 400505 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952250,'','supplier','218',0.00,6000.00,'Payment Id 400505 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952251,'','2','4076',633600.00,0.00,'Payment Id 400504 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952252,'','supplier','218',0.00,633600.00,'Payment Id 400504 for invoice:257755, receipt: 324854 by SALBAS OIL & GAS NIG LTD','2022-09-16 09:09:14','',''),('5','175',4952253,'','24','3186',0.00,8325000.00,'Purchase Id 90608 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:24','',''),('5','175',4952254,'','supplier','218',8325000.00,0.00,'Purchase Id 90608 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:24','',''),('5','175',4952255,'','6.1','3183',20400.00,0.00,'Payment Id 400509 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952256,'','supplier','218',0.00,20400.00,'Payment Id 400509 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952257,'','2','3235',2500.00,0.00,'Payment Id 400508 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952258,'','supplier','218',0.00,2500.00,'Payment Id 400508 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952259,'','2','4076',383130.00,0.00,'Payment Id 400507 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952260,'','supplier','218',0.00,383130.00,'Payment Id 400507 for invoice:257756, receipt: 717072 by SALBAS OIL & GAS NIG LTD','2022-09-17 10:13:44','',''),('5','175',4952261,'','20','3182',218386.95,0.00,'Sales from shift 257757 on 2022-09-17 10:42:22 ','2022-09-17 10:42:22','',''),('5','175',4952262,'','6.1','3183',0.00,218386.95,'Sales from shift 257757 on 2022-09-17 10:42:22 ','2022-09-17 10:42:22','',''),('5','175',4952263,'','20','3182',773135.35,0.00,'Sales from shift 257758 on 2022-09-18 07:21:33 ','2022-09-18 07:21:33','',''),('5','175',4952264,'','6.1','3183',0.00,773135.35,'Sales from shift 257758 on 2022-09-18 07:21:33 ','2022-09-18 07:21:33','',''),('5','175',4952265,'','20','3182',791326.40,0.00,'Sales from shift 257759 on 2022-09-19 07:20:02 ','2022-09-19 07:20:02','',''),('5','175',4952266,'','6.1','3183',0.00,791326.40,'Sales from shift 257759 on 2022-09-19 07:20:02 ','2022-09-19 07:20:02','',''),('5','175',4952267,'','20','3182',820582.30,0.00,'Sales from shift 257760 on 2022-09-20 08:33:02 ','2022-09-20 08:33:02','',''),('5','175',4952268,'','6.1','3183',0.00,820582.30,'Sales from shift 257760 on 2022-09-20 08:33:02 ','2022-09-20 08:33:02','',''),('5','175',4952269,'','20','3182',808760.80,0.00,'Sales from shift 257761 on 2022-09-21 11:51:21 ','2022-09-21 11:51:21','',''),('5','175',4952270,'','6.1','3183',0.00,808760.80,'Sales from shift 257761 on 2022-09-21 11:51:21 ','2022-09-21 11:51:21','',''),('5','175',4952271,'','20','3182',677492.20,0.00,'Sales from shift 257762 on 2022-09-22 07:39:26 ','2022-09-22 07:39:26','',''),('5','175',4952272,'','6.1','3183',0.00,677492.20,'Sales from shift 257762 on 2022-09-22 07:39:26 ','2022-09-22 07:39:26','',''),('5','175',4952273,'','6.1','3183',20400.00,0.00,'Payment Id 400523 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952274,'','supplier','218',0.00,20400.00,'Payment Id 400523 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952275,'','2','3235',45000.00,0.00,'Payment Id 400522 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952276,'','supplier','218',0.00,45000.00,'Payment Id 400522 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952277,'','2','4076',743360.00,0.00,'Payment Id 400521 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952278,'','supplier','218',0.00,743360.00,'Payment Id 400521 for invoice:257761, receipt: 540043 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952279,'','6.1','3183',20400.00,0.00,'Payment Id 400520 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952280,'','supplier','218',0.00,20400.00,'Payment Id 400520 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952281,'','2','4076',743880.00,0.00,'Payment Id 400518 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952282,'','supplier','218',0.00,743880.00,'Payment Id 400518 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952283,'','6.1','3183',45400.00,0.00,'Payment Id 400517 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952284,'','supplier','218',0.00,45400.00,'Payment Id 400517 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952285,'','2','3235',17500.00,0.00,'Payment Id 400516 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952286,'','supplier','218',0.00,17500.00,'Payment Id 400516 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952287,'','2','4076',728425.00,0.00,'Payment Id 400515 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952288,'','supplier','218',0.00,728425.00,'Payment Id 400515 for invoice:257759, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952289,'','6.1','3183',20400.00,0.00,'Payment Id 400514 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952290,'','supplier','218',0.00,20400.00,'Payment Id 400514 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:52','',''),('5','175',4952291,'','2','3235',56300.00,0.00,'Payment Id 400519 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:57','',''),('5','175',4952292,'','supplier','218',0.00,56300.00,'Payment Id 400519 for invoice:257760, receipt: 574000 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:39:57','',''),('5','175',4952293,'','2','3235',86735.00,0.00,'Payment Id 400513 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952294,'','supplier','218',0.00,86735.00,'Payment Id 400513 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952295,'','2','4076',666000.00,0.00,'Payment Id 400512 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952296,'','supplier','218',0.00,666000.00,'Payment Id 400512 for invoice:257758, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952297,'','6.1','3183',45400.00,0.00,'Payment Id 400511 for invoice:257757, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952298,'','supplier','218',0.00,45400.00,'Payment Id 400511 for invoice:257757, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952299,'','2','4076',172985.00,0.00,'Payment Id 400510 for invoice:257757, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952300,'','supplier','218',0.00,172985.00,'Payment Id 400510 for invoice:257757, receipt: 317036 by SALBAS OIL & GAS NIG LTD','2022-09-22 07:40:10','',''),('5','175',4952301,'','20','3182',649122.45,0.00,'Sales from shift 257763 on 2022-09-23 07:49:51 ','2022-09-23 07:49:51','',''),('5','175',4952302,'','6.1','3183',0.00,649122.45,'Sales from shift 257763 on 2022-09-23 07:49:51 ','2022-09-23 07:49:51','',''),('5','175',4952303,'','6.1','3183',20400.00,0.00,'Payment Id 400525 for invoice:257762, receipt: 214773 by SALBAS OIL & GAS NIG LTD','2022-09-23 07:50:11','',''),('5','175',4952304,'','supplier','218',0.00,20400.00,'Payment Id 400525 for invoice:257762, receipt: 214773 by SALBAS OIL & GAS NIG LTD','2022-09-23 07:50:11','',''),('5','175',4952305,'','2','4076',657090.00,0.00,'Payment Id 400524 for invoice:257762, receipt: 214773 by SALBAS OIL & GAS NIG LTD','2022-09-23 07:50:11','',''),('5','175',4952306,'','supplier','218',0.00,657090.00,'Payment Id 400524 for invoice:257762, receipt: 214773 by SALBAS OIL & GAS NIG LTD','2022-09-23 07:50:11','',''),('5','175',4952307,'','6.1','3183',20400.00,0.00,'Payment Id 400527 for invoice:257763, receipt: 833049 by SALBAS OIL & GAS NIG LTD','2022-09-23 22:38:19','',''),('5','175',4952308,'','supplier','218',0.00,20400.00,'Payment Id 400527 for invoice:257763, receipt: 833049 by SALBAS OIL & GAS NIG LTD','2022-09-23 22:38:19','',''),('5','175',4952309,'','2','4076',628720.00,0.00,'Payment Id 400526 for invoice:257763, receipt: 833049 by SALBAS OIL & GAS NIG LTD','2022-09-23 22:38:19','',''),('5','175',4952310,'','supplier','218',0.00,628720.00,'Payment Id 400526 for invoice:257763, receipt: 833049 by SALBAS OIL & GAS NIG LTD','2022-09-23 22:38:19','',''),('5','175',4952311,'','20','3182',677033.40,0.00,'Sales from shift 257764 on 2022-09-23 22:38:54 ','2022-09-23 22:38:54','',''),('5','175',4952312,'','6.1','3183',0.00,677033.40,'Sales from shift 257764 on 2022-09-23 22:38:54 ','2022-09-23 22:38:54','',''),('5','175',4952313,'','20','3182',765646.55,0.00,'Sales from shift 257765 on 2022-09-25 08:04:58 ','2022-09-25 08:04:58','',''),('5','175',4952314,'','6.1','3183',0.00,765646.55,'Sales from shift 257765 on 2022-09-25 08:04:58 ','2022-09-25 08:04:58','',''),('5','175',4952315,'','20','3182',709639.65,0.00,'Sales from shift 257766 on 2022-09-26 07:17:57 ','2022-09-26 07:17:57','',''),('5','175',4952316,'','6.1','3183',0.00,709639.65,'Sales from shift 257766 on 2022-09-26 07:17:57 ','2022-09-26 07:17:57','',''),('5','175',4952317,'','20','3182',726970.45,0.00,'Sales from shift 257767 on 2022-09-27 07:25:13 ','2022-09-27 07:25:13','',''),('5','175',4952318,'','6.1','3183',0.00,726970.45,'Sales from shift 257767 on 2022-09-27 07:25:13 ','2022-09-27 07:25:13','',''),('5','175',4952319,'','6.1','3183',32100.00,0.00,'Payment Id 400537 for invoice:257767, receipt: 068264 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952320,'','supplier','218',0.00,32100.00,'Payment Id 400537 for invoice:257767, receipt: 068264 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952321,'','2','4076',694870.00,0.00,'Payment Id 400536 for invoice:257767, receipt: 068264 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952322,'','supplier','218',0.00,694870.00,'Payment Id 400536 for invoice:257767, receipt: 068264 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952323,'','6.1','3183',20400.00,0.00,'Payment Id 400535 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952324,'','supplier','218',0.00,20400.00,'Payment Id 400535 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952325,'','2','3235',15000.00,0.00,'Payment Id 400534 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952326,'','supplier','218',0.00,15000.00,'Payment Id 400534 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952327,'','2','4076',674240.00,0.00,'Payment Id 400533 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952328,'','supplier','218',0.00,674240.00,'Payment Id 400533 for invoice:257766, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952329,'','6.1','3183',20400.00,0.00,'Payment Id 400532 for invoice:257765, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952330,'','supplier','218',0.00,20400.00,'Payment Id 400532 for invoice:257765, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952331,'','2','4076',745250.00,0.00,'Payment Id 400531 for invoice:257765, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952332,'','supplier','218',0.00,745250.00,'Payment Id 400531 for invoice:257765, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952333,'','2','4076',628720.00,0.00,'Payment Id 400530 for invoice:257763, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952334,'','supplier','218',0.00,628720.00,'Payment Id 400530 for invoice:257763, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952335,'','6.1','3183',20400.00,0.00,'Payment Id 400529 for invoice:257764, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952336,'','supplier','218',0.00,20400.00,'Payment Id 400529 for invoice:257764, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952337,'','2','4076',646635.00,0.00,'Payment Id 400528 for invoice:257764, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952338,'','supplier','218',0.00,646635.00,'Payment Id 400528 for invoice:257764, receipt: 409622 by SALBAS OIL & GAS NIG LTD','2022-09-27 15:38:51','',''),('5','175',4952339,'','20','3182',661097.50,0.00,'Sales from shift 257768 on 2022-09-28 08:23:37 ','2022-09-28 08:23:37','',''),('5','175',4952340,'','6.1','3183',0.00,661097.50,'Sales from shift 257768 on 2022-09-28 08:23:37 ','2022-09-28 08:23:37','',''),('5','175',4952341,'','6.1','3183',85400.00,0.00,'Payment Id 400539 for invoice:257768, receipt: 585004 by SALBAS OIL & GAS NIG LTD','2022-09-28 16:30:39','',''),('5','175',4952342,'','supplier','218',0.00,85400.00,'Payment Id 400539 for invoice:257768, receipt: 585004 by SALBAS OIL & GAS NIG LTD','2022-09-28 16:30:39','',''),('5','175',4952343,'','2','4076',575709.00,0.00,'Payment Id 400538 for invoice:257768, receipt: 585004 by SALBAS OIL & GAS NIG LTD','2022-09-28 16:30:39','',''),('5','175',4952344,'','supplier','218',0.00,575709.00,'Payment Id 400538 for invoice:257768, receipt: 585004 by SALBAS OIL & GAS NIG LTD','2022-09-28 16:30:39','',''),('5','175',4952345,'','20','3182',0.00,0.00,'Sales from shift 257769 on 2022-09-29 08:35:39 ','2022-09-29 08:35:39','',''),('5','175',4952346,'','6.1','3183',0.00,0.00,'Sales from shift 257769 on 2022-09-29 08:35:39 ','2022-09-29 08:35:39','',''),('5','175',4952347,'','20','3182',0.00,0.00,'Sales from shift 257770 on 2022-09-30 08:10:03 ','2022-09-30 08:10:03','',''),('5','175',4952348,'','6.1','3183',0.00,0.00,'Sales from shift 257770 on 2022-09-30 08:10:03 ','2022-09-30 08:10:03','',''),('5','175',4952349,'','20','3182',0.00,0.00,'Sales from shift 257771 on 2022-09-30 21:49:56 ','2022-09-30 21:49:56','',''),('5','175',4952350,'','6.1','3183',0.00,0.00,'Sales from shift 257771 on 2022-09-30 21:49:56 ','2022-09-30 21:49:56','',''),('5','175',4952351,'','20','3182',0.00,0.00,'Sales from shift 257772 on 2022-10-02 06:43:35 ','2022-10-02 06:43:35','',''),('5','175',4952352,'','6.1','3183',0.00,0.00,'Sales from shift 257772 on 2022-10-02 06:43:35 ','2022-10-02 06:43:35','',''),('5','175',4952353,'','20','3182',0.00,0.00,'Sales from shift 257773 on 2022-10-03 06:25:05 ','2022-10-03 06:25:05','',''),('5','175',4952354,'','6.1','3183',0.00,0.00,'Sales from shift 257773 on 2022-10-03 06:25:05 ','2022-10-03 06:25:05','',''),('5','175',4952355,'','20','3182',0.00,0.00,'Sales from shift 257774 on 2022-10-04 07:12:14 ','2022-10-04 07:12:14','',''),('5','175',4952356,'','6.1','3183',0.00,0.00,'Sales from shift 257774 on 2022-10-04 07:12:14 ','2022-10-04 07:12:14','',''),('5','175',4952357,'','20','3182',0.00,0.00,'Sales from shift 257775 on 2022-10-05 09:40:07 ','2022-10-05 09:40:07','',''),('5','175',4952358,'','6.1','3183',0.00,0.00,'Sales from shift 257775 on 2022-10-05 09:40:07 ','2022-10-05 09:40:07','',''),('5','175',4952359,'','20','3182',0.00,0.00,'Sales from shift 257776 on 2022-10-06 07:59:46 ','2022-10-06 07:59:46','',''),('5','175',4952360,'','6.1','3183',0.00,0.00,'Sales from shift 257776 on 2022-10-06 07:59:46 ','2022-10-06 07:59:46','',''),('5','175',4952361,'','20','3182',0.00,0.00,'Sales from shift 257777 on 2022-10-06 21:18:12 ','2022-10-06 21:18:12','',''),('5','175',4952362,'','6.1','3183',0.00,0.00,'Sales from shift 257777 on 2022-10-06 21:18:12 ','2022-10-06 21:18:12','',''),('5','175',4952363,'','20','3182',0.00,0.00,'Sales from shift 257778 on 2022-10-08 08:37:17 ','2022-10-08 08:37:17','',''),('5','175',4952364,'','6.1','3183',0.00,0.00,'Sales from shift 257778 on 2022-10-08 08:37:17 ','2022-10-08 08:37:17','',''),('5','175',4952365,'','20','3182',0.00,0.00,'Sales from shift 257779 on 2022-10-09 08:31:37 ','2022-10-09 08:31:37','',''),('5','175',4952366,'','6.1','3183',0.00,0.00,'Sales from shift 257779 on 2022-10-09 08:31:37 ','2022-10-09 08:31:37','',''),('5','175',4952367,'','20','3182',0.00,0.00,'Sales from shift 257780 on 2022-10-10 12:15:28 ','2022-10-10 12:15:28','',''),('5','175',4952368,'','6.1','3183',0.00,0.00,'Sales from shift 257780 on 2022-10-10 12:15:28 ','2022-10-10 12:15:28','',''),('5','175',4952369,'','20','3182',0.00,0.00,'Sales from shift 257781 on 2022-10-11 07:05:46 ','2022-10-11 07:05:46','',''),('5','175',4952370,'','6.1','3183',0.00,0.00,'Sales from shift 257781 on 2022-10-11 07:05:46 ','2022-10-11 07:05:46','',''),('5','175',4952371,'','20','3182',0.00,0.00,'Sales from shift 257782 on 2022-10-12 10:04:54 ','2022-10-12 10:04:54','',''),('5','175',4952372,'','6.1','3183',0.00,0.00,'Sales from shift 257782 on 2022-10-12 10:04:54 ','2022-10-12 10:04:54','',''),('5','175',4952373,'','20','3182',0.00,0.00,'Sales from shift 257783 on 2022-10-12 22:15:59 ','2022-10-12 22:15:59','',''),('5','175',4952374,'','6.1','3183',0.00,0.00,'Sales from shift 257783 on 2022-10-12 22:15:59 ','2022-10-12 22:15:59','',''),('5','175',4952375,'','20','3182',0.00,0.00,'Sales from shift 257784 on 2022-10-14 07:32:38 ','2022-10-14 07:32:38','',''),('5','175',4952376,'','6.1','3183',0.00,0.00,'Sales from shift 257784 on 2022-10-14 07:32:38 ','2022-10-14 07:32:38','',''),('5','175',4952377,'','20','3182',0.00,0.00,'Sales from shift 257785 on 2022-10-15 06:23:20 ','2022-10-15 06:23:20','',''),('5','175',4952378,'','6.1','3183',0.00,0.00,'Sales from shift 257785 on 2022-10-15 06:23:20 ','2022-10-15 06:23:20','',''),('5','175',4952379,'','20','3182',0.00,0.00,'Sales from shift 257786 on 2022-10-15 20:32:15 ','2022-10-15 20:32:15','',''),('5','175',4952380,'','6.1','3183',0.00,0.00,'Sales from shift 257786 on 2022-10-15 20:32:15 ','2022-10-15 20:32:15','',''),('5','175',4952381,'','20','3182',0.00,0.00,'Sales from shift 257787 on 2022-10-17 07:37:28 ','2022-10-17 07:37:28','',''),('5','175',4952382,'','6.1','3183',0.00,0.00,'Sales from shift 257787 on 2022-10-17 07:37:28 ','2022-10-17 07:37:28','',''),('5','175',4952383,'','20','3182',0.00,0.00,'Sales from shift 257788 on 2022-10-18 07:44:57 ','2022-10-18 07:44:57','',''),('5','175',4952384,'','6.1','3183',0.00,0.00,'Sales from shift 257788 on 2022-10-18 07:44:57 ','2022-10-18 07:44:57','',''),('5','175',4952385,'','20','3182',0.00,0.00,'Sales from shift 257789 on 2022-10-19 07:38:45 ','2022-10-19 07:38:45','',''),('5','175',4952386,'','6.1','3183',0.00,0.00,'Sales from shift 257789 on 2022-10-19 07:38:45 ','2022-10-19 07:38:45','',''),('5','175',4952387,'','20','3182',0.00,0.00,'Sales from shift 257790 on 2022-10-20 09:09:26 ','2022-10-20 09:09:26','',''),('5','175',4952388,'','6.1','3183',0.00,0.00,'Sales from shift 257790 on 2022-10-20 09:09:26 ','2022-10-20 09:09:26','',''),('5','175',4952389,'','20','3182',0.00,0.00,'Sales from shift 257791 on 2022-10-21 07:44:13 ','2022-10-21 07:44:13','',''),('5','175',4952390,'','6.1','3183',0.00,0.00,'Sales from shift 257791 on 2022-10-21 07:44:13 ','2022-10-21 07:44:13','',''),('5','175',4952391,'','6.1','3183',49503.00,0.00,'Payment Id 400540 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:14:26','',''),('5','175',4952392,'','supplier','218',0.00,49503.00,'Payment Id 400540 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:14:26','',''),('5','175',4952393,'','6.1','3183',0.00,49503.00,'Payment Id 400540 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:15:21','',''),('5','175',4952394,'','supplier','218',49503.00,0.00,'Payment Id 400540 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:15:21','',''),('5','175',4952395,'','6.1','3183',0.00,60900.00,'Payment Id 343154 for invoice:230755, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-10-21 13:18:02','',''),('5','175',4952396,'','supplier','218',60900.00,0.00,'Payment Id 343154 for invoice:230755, receipt: 2057k23z by SALBAS OIL & GAS NIG LTD','2022-10-21 13:18:02','',''),('5','175',4952397,'','6.1','3183',11379.46,0.00,'Payment Id 400541 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:20:01','',''),('5','175',4952398,'','supplier','218',0.00,11379.46,'Payment Id 400541 for invoice:257791, receipt: 2634 by SALBAS OIL & GAS NIG LTD','2022-10-21 13:20:01','',''),('5','175',4952399,'','20','3182',0.00,0.00,'Sales from shift 257792 on 2022-10-22 06:17:24 ','2022-10-22 06:17:24','',''),('5','175',4952400,'','6.1','3183',0.00,0.00,'Sales from shift 257792 on 2022-10-22 06:17:24 ','2022-10-22 06:17:24','',''),('5','175',4952401,'','20','3182',0.00,0.00,'Sales from shift 257793 on 2022-10-23 08:12:35 ','2022-10-23 08:12:35','',''),('5','175',4952402,'','6.1','3183',0.00,0.00,'Sales from shift 257793 on 2022-10-23 08:12:35 ','2022-10-23 08:12:35','',''),('5','175',4952403,'','20','3182',0.00,0.00,'Sales from shift 257794 on 2022-10-24 07:24:29 ','2022-10-24 07:24:29','',''),('5','175',4952404,'','6.1','3183',0.00,0.00,'Sales from shift 257794 on 2022-10-24 07:24:29 ','2022-10-24 07:24:29','',''),('5','175',4952405,'','20','3182',0.00,0.00,'Sales from shift 257795 on 2022-10-25 07:23:22 ','2022-10-25 07:23:22','',''),('5','175',4952406,'','6.1','3183',0.00,0.00,'Sales from shift 257795 on 2022-10-25 07:23:22 ','2022-10-25 07:23:22','',''),('5','175',4952407,'','20','3182',0.00,0.00,'Sales from shift 257796 on 2022-10-26 07:23:56 ','2022-10-26 07:23:56','',''),('5','175',4952408,'','6.1','3183',0.00,0.00,'Sales from shift 257796 on 2022-10-26 07:23:56 ','2022-10-26 07:23:56','',''),('5','175',4952409,'','20','3182',0.00,0.00,'Sales from shift 257797 on 2022-10-27 09:58:20 ','2022-10-27 09:58:20','',''),('5','175',4952410,'','6.1','3183',0.00,0.00,'Sales from shift 257797 on 2022-10-27 09:58:20 ','2022-10-27 09:58:20','',''),('5','175',4952411,'','20','3182',0.00,0.00,'Sales from shift 257798 on 2022-10-28 06:54:44 ','2022-10-28 06:54:44','',''),('5','175',4952412,'','6.1','3183',0.00,0.00,'Sales from shift 257798 on 2022-10-28 06:54:44 ','2022-10-28 06:54:44','',''),('5','175',4952413,'','20','3182',0.00,0.00,'Sales from shift 257799 on 2022-10-29 07:56:22 ','2022-10-29 07:56:22','',''),('5','175',4952414,'','6.1','3183',0.00,0.00,'Sales from shift 257799 on 2022-10-29 07:56:22 ','2022-10-29 07:56:22','',''),('5','175',4952415,'','20','3182',0.00,0.00,'Sales from shift 257800 on 2022-10-30 06:36:59 ','2022-10-30 06:36:59','',''),('5','175',4952416,'','6.1','3183',0.00,0.00,'Sales from shift 257800 on 2022-10-30 06:36:59 ','2022-10-30 06:36:59','',''),('5','175',4952417,'','20','3182',0.00,0.00,'Sales from shift 257801 on 2022-10-31 06:46:19 ','2022-10-31 06:46:19','',''),('5','175',4952418,'','6.1','3183',0.00,0.00,'Sales from shift 257801 on 2022-10-31 06:46:19 ','2022-10-31 06:46:19','',''),('5','175',4952419,'','20','3182',0.00,0.00,'Sales from shift 257802 on 2022-11-01 06:42:19 ','2022-11-01 06:42:19','',''),('5','175',4952420,'','6.1','3183',0.00,0.00,'Sales from shift 257802 on 2022-11-01 06:42:19 ','2022-11-01 06:42:19','',''),('5','175',4952421,'','20','3182',0.00,0.00,'Sales from shift 257803 on 2022-11-02 06:28:36 ','2022-11-02 06:28:36','',''),('5','175',4952422,'','6.1','3183',0.00,0.00,'Sales from shift 257803 on 2022-11-02 06:28:36 ','2022-11-02 06:28:36','',''),('5','175',4952423,'','20','3182',0.00,0.00,'Sales from shift 257804 on 2022-11-03 08:16:21 ','2022-11-03 08:16:21','',''),('5','175',4952424,'','6.1','3183',0.00,0.00,'Sales from shift 257804 on 2022-11-03 08:16:21 ','2022-11-03 08:16:21','',''),('5','175',4952425,'','20','3182',0.00,0.00,'Sales from shift 257805 on 2022-11-04 07:33:45 ','2022-11-04 07:33:45','',''),('5','175',4952426,'','6.1','3183',0.00,0.00,'Sales from shift 257805 on 2022-11-04 07:33:45 ','2022-11-04 07:33:45','',''),('5','175',4952427,'','20','3182',0.00,0.00,'Sales from shift 257806 on 2022-11-06 07:09:30 ','2022-11-06 07:09:30','',''),('5','175',4952428,'','6.1','3183',0.00,0.00,'Sales from shift 257806 on 2022-11-06 07:09:30 ','2022-11-06 07:09:30','',''),('5','175',4952429,'','20','3182',0.00,0.00,'Sales from shift 257807 on 2022-11-08 07:11:54 ','2022-11-08 07:11:54','',''),('5','175',4952430,'','6.1','3183',0.00,0.00,'Sales from shift 257807 on 2022-11-08 07:11:54 ','2022-11-08 07:11:54','',''),('5','175',4952431,'','20','3182',0.00,0.00,'Sales from shift 257808 on 2022-11-09 08:13:34 ','2022-11-09 08:13:34','',''),('5','175',4952432,'','6.1','3183',0.00,0.00,'Sales from shift 257808 on 2022-11-09 08:13:34 ','2022-11-09 08:13:34','',''),('5','175',4952433,'','20','3182',0.00,0.00,'Sales from shift 257809 on 2022-11-10 09:29:43 ','2022-11-10 09:29:43','',''),('5','175',4952434,'','6.1','3183',0.00,0.00,'Sales from shift 257809 on 2022-11-10 09:29:43 ','2022-11-10 09:29:43','',''),('5','175',4952435,'','20','3182',0.00,0.00,'Sales from shift 257810 on 2022-11-11 07:53:24 ','2022-11-11 07:53:24','',''),('5','175',4952436,'','6.1','3183',0.00,0.00,'Sales from shift 257810 on 2022-11-11 07:53:24 ','2022-11-11 07:53:24','',''),('5','175',4952437,'','20','3182',0.00,0.00,'Sales from shift 257811 on 2022-12-14 09:50:32 ','2022-12-14 09:50:32','',''),('5','175',4952438,'','6.1','3183',0.00,0.00,'Sales from shift 257811 on 2022-12-14 09:50:32 ','2022-12-14 09:50:32','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (403,'5','175','PMS','Petrol','Litres',1,185.00,185.00,185.00,185.00,0.00,0,'2021-02-22 21:41:32','597','597','2021-02-22 21:41:32',1),(404,'5','175','AGO','Diesel','Litres',1,800.00,800.00,800.00,800.00,0.00,0,'2021-02-22 21:47:50','597','597','2022-05-20 22:07:19',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
INSERT INTO `products_changevalues` VALUES ('5','175',1,'404','257630',697,660.00,700.00,'AGO Pump Price Change','597','2022-05-13 08:07:53');
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=17927 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (12579,'5','175',404,250.00,0.00,0.00,0.00,'Cost from purchase id #62957','2021-03-05 20:09:11','606'),(12594,'5','175',403,163.00,0.00,0.00,0.00,'Cost from purchase id #63079','2021-03-07 12:04:47','606'),(13214,'5','175',404,265.00,0.00,0.00,0.00,'Cost from purchase id #65685','2021-04-08 11:38:53','606'),(13232,'5','175',403,165.00,0.00,0.00,0.00,'Cost from purchase id #65870','2021-04-10 17:35:33','606'),(13575,'5','175',404,270.00,270.00,270.00,270.00,'','2021-05-19 07:17:43','600'),(13852,'5','175',404,275.00,275.00,275.00,275.00,'NEW AGO PRICE','2021-06-07 09:13:29','600'),(14753,'5','175',404,295.00,275.00,0.00,0.00,'Cost from purchase id #73641','2021-08-01 20:00:49','606'),(15983,'5','175',404,300.00,275.00,0.00,0.00,'Cost from purchase id #78059','2021-10-11 13:32:00','600'),(16004,'5','175',404,300.00,300.00,300.00,300.00,'AGO NEW PRICE','2021-10-11 19:31:52','600'),(16005,'5','175',403,163.00,163.00,163.00,163.00,'PMS New Price','2021-10-11 19:34:01','600'),(16006,'5','175',403,165.00,165.00,165.00,165.00,'New PMS price','2021-10-11 19:46:36','600'),(16011,'5','175',404,310.00,310.00,310.00,310.00,'AGO NEW PRICE','2021-10-12 09:48:30','597'),(16014,'5','175',404,320.00,320.00,320.00,320.00,'Ago new price','2021-10-12 10:18:42','597'),(16128,'5','175',404,327.00,327.00,327.00,327.00,'Ago new price','2021-10-17 07:49:20','597'),(16291,'5','175',404,330.00,330.00,330.00,330.00,'Ago new price','2021-10-20 07:53:02','597'),(16331,'5','175',404,345.00,345.00,345.00,345.00,'Ago new price','2021-10-20 14:17:08','597'),(17662,'5','175',404,350.00,350.00,350.00,350.00,'New Ago price','2022-01-19 09:26:12','597'),(17795,'5','175',404,355.00,355.00,355.00,355.00,'New Ago price','2022-01-24 07:00:23','597'),(17886,'5','175',404,360.00,360.00,360.00,360.00,'New Ago price','2022-01-27 22:50:53','597'),(17919,'5','175',404,310.00,360.00,0.00,0.00,'Cost from purchase id #90595','2022-01-28 13:16:44','600'),(17920,'5','175',404,415.00,415.00,415.00,415.00,'New Ago price','2022-02-09 06:32:03','597'),(17921,'5','175',404,660.00,660.00,660.00,660.00,'','2022-04-08 11:06:27','597'),(17922,'5','175',404,700.00,700.00,700.00,700.00,'AGO Price Change','2022-05-20 22:04:31','597'),(17923,'5','175',404,800.00,800.00,800.00,800.00,'AGO Price Change','2022-06-25 12:37:46','597'),(17924,'5','175',404,820.00,820.00,820.00,820.00,'AGO Price Change','2022-06-25 15:06:17','597'),(17925,'5','175',403,185.00,185.00,185.00,185.00,'PMS Price Change','2022-07-09 22:06:21','597'),(17926,'5','175',404,800.00,800.00,800.00,800.00,'AGO Price Change','2022-07-09 22:07:31','597');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=90609 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (78059,'5','175','2021-10-01',404,218,300.00,11540.00,0.00,0.00,3462000.00,0.00,'','NIL','NIL','','','','2021-10-11 13:29:24',15,'','600','','0000-00-00 00:00:00','600','2021-10-11 13:32:00'),(78060,'5','175','2021-10-01',403,218,165.00,27800.00,0.00,0.00,4587000.00,0.00,'','NIL','NIL','','','','2021-10-11 13:31:24',15,'','600','','0000-00-00 00:00:00','600','2021-10-11 13:31:47'),(78108,'5','175','2021-10-11',403,218,165.00,42000.00,0.00,0.00,6930000.00,0.00,'','1234','SKK 290 XA','','','','2021-10-12 10:26:41',15,'','597','','0000-00-00 00:00:00','606','2021-10-12 10:29:16'),(86844,'5','175','2021-12-10',403,218,165.00,44400.00,0.00,0.00,7326000.00,0.00,'','0189','BCH 727 XA','','','','2021-12-10 13:38:09',15,'','597','600','2021-12-10 13:52:57','600','2021-12-10 13:53:30'),(87536,'5','175','2021-12-18',404,218,345.00,13500.00,0.00,0.00,4657500.00,0.00,'','2243','GWL 66 YJ','','','','2021-12-18 13:08:57',15,'','597','','0000-00-00 00:00:00','606','2021-12-18 14:32:08'),(88885,'5','175','2022-01-05',403,218,165.00,44600.00,0.00,0.00,7359000.00,0.00,'','2408','GGE 589 XY','','','','2022-01-05 13:03:19',15,'','597','','0000-00-00 00:00:00','606','2022-01-05 13:09:00'),(89783,'5','175','2022-01-17',403,218,165.00,39800.00,0.00,0.00,6567000.00,0.00,'','1234','NSR 186 ZU','','','','2022-01-17 18:06:52',15,'','597','','0000-00-00 00:00:00','606','2022-01-17 18:08:20'),(90362,'5','175','2021-12-10',403,218,165.00,151.00,0.00,0.00,24915.00,0.00,'','2408','BCH 727 XA','','','','2022-01-25 14:01:43',15,'','597','','0000-00-00 00:00:00','606','2022-01-25 14:25:10'),(90595,'5','175','2022-01-28',404,218,310.00,301.61,0.00,0.00,93499.10,0.00,'','1234','NSR 186 ZU','','','','2022-01-28 13:12:42',5,'','597','','0000-00-00 00:00:00','600','2022-01-28 13:16:44'),(90596,'5','175','2022-02-03',403,218,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','1234','BCH 736 XA','','','','2022-02-03 13:54:53',15,'','597','','0000-00-00 00:00:00','606','2022-02-03 15:37:00'),(90597,'5','175','2022-02-17',403,218,165.00,924.00,0.00,0.00,152460.00,0.00,'','NIL','NIL','','','','2022-02-17 10:20:55',15,'','600','','0000-00-00 00:00:00','600','2022-02-17 10:21:07'),(90598,'5','175','2022-02-23',403,218,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','1234','BCH 736 XA','','','','2022-02-23 14:06:57',15,'','597','','0000-00-00 00:00:00','606','2022-02-23 14:08:39'),(90599,'5','175','2022-03-15',403,218,165.00,13500.00,0.00,0.00,2227500.00,0.00,'','1313','TRN 183 ZG','','','','2022-03-15 14:42:23',15,'PMS Supply','597','','0000-00-00 00:00:00','600','2022-03-15 14:51:49'),(90600,'5','175','2022-04-22',403,218,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','1330','BCH 727 XA','','','','2022-04-23 13:33:11',15,'PMS Supply','597','','0000-00-00 00:00:00','600','2022-04-23 14:02:04'),(90601,'5','175','2022-05-04',403,218,165.00,26500.00,0.00,0.00,4372500.00,0.00,'','1346','KMC 139 YT','','','','2022-05-10 14:24:12',15,'PMS Supply','597','','0000-00-00 00:00:00','600','2022-05-10 15:59:30'),(90604,'5','175','2022-05-28',403,218,165.00,22500.00,0.00,0.00,3712500.00,0.00,'','2456','BCH 739 XA','','','','2022-05-28 22:03:50',15,'PMS Supply','597','','0000-00-00 00:00:00','600','2022-05-28 22:10:58'),(90605,'5','175','2022-07-17',403,218,185.00,44850.00,0.00,0.00,8297250.00,0.00,'','2479','BCH 740 XA','','','','2022-07-18 10:39:21',15,'PMS Supply','597','','0000-00-00 00:00:00','664','2022-07-18 10:49:08'),(90606,'5','175','2022-08-12',403,218,185.00,49850.00,0.00,0.00,9222250.00,0.00,'','2497','RBC 298 XF','','','','2022-09-05 10:51:29',15,'PMS Supply','597','','0000-00-00 00:00:00','664','2022-09-05 10:53:03'),(90607,'5','175','2022-09-05',403,218,185.00,45000.00,0.00,0.00,8325000.00,0.00,'','1863','BCH 742 XA','','','','2022-09-05 11:01:52',15,'PMS Supply','597','','0000-00-00 00:00:00','664','2022-09-05 12:37:07'),(90608,'5','175','2022-09-16',403,218,185.00,45000.00,0.00,0.00,8325000.00,0.00,'','1875','BCH 736 XA','','','','2022-09-16 21:22:42',15,'PMS Supply','597','','0000-00-00 00:00:00','664','2022-09-17 10:13:24');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=400542 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (343149,'5','175','2021-10-01',218,'465767','','5',869730.00,'230755','','','3235','SOKOTO STATION ','465767',946028.25,'2021-10-12 12:25:18',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:44:33'),(343151,'5','175','2021-10-01',218,'','','2',15400.00,'230755','','','','','',0.00,'2021-10-12 12:26:16',5,'AGO  = 15,000\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 11:44:59'),(343154,'5','175','2021-10-01',218,'2057k23z','','10',60900.00,'230755','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 12:28:34',2,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:45:08'),(343160,'5','175','2021-10-02',218,'465752','','5',520340.00,'230757','','','3235','SOKOTO STATION ','465752',545739.75,'2021-10-12 12:30:59',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:46:03'),(343163,'5','175','2021-10-02',218,'','','2',15400.00,'230757','','','','','',0.00,'2021-10-12 12:31:49',5,'AGO = 15,000\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 11:46:03'),(343166,'5','175','2021-10-02',218,'2057k23z','','10',10000.00,'230757','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 12:33:08',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:46:03'),(343171,'5','175','2021-10-03',218,'465710','','5',485140.00,'230759','','','3235','SOKOTO STATION ','465710',500540.55,'2021-10-12 12:35:38',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:05:30'),(343172,'5','175','2021-10-03',218,'','','2',15400.00,'230759','','','','','',0.00,'2021-10-12 12:36:29',5,'AGO = 15,000\r\nWATER  = 400','597','600','2021-10-13 11:48:45','606','2021-10-13 12:05:30'),(343173,'5','175','2021-10-04',218,'081421','','5',434110.00,'230765','','','3235','SOKOTO STATION ','081421',475411.65,'2021-10-12 12:39:27',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:47:58'),(343174,'5','175','2021-10-04',218,'','','2',15400.00,'230765','','','','','',0.00,'2021-10-12 12:40:19',5,'AGO = 15,000\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 11:47:58'),(343175,'5','175','2021-10-04',218,'2057k23z','','10',25900.00,'230765','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 12:41:41',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 11:47:58'),(343177,'5','175','2021-10-05',218,'465764','','5',540130.00,'230837','','','3235','SOKOTO STATION ','465764',572173.93,'2021-10-12 12:44:48',5,'','597','600','2021-10-13 12:36:27','606','2021-10-13 12:38:36'),(343178,'5','175','2021-10-05',218,'','','2',15900.00,'230837','','','','','',0.00,'2021-10-12 12:46:11',5,'AGO  = 15,500\r\nWATER  = 400\r\nWEIGHT & MEASURE  = 5,000','597','600','2021-10-13 12:38:19','606','2021-10-13 12:38:36'),(343179,'5','175','2021-10-05',218,'2057k23z','','10',15900.00,'230837','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 12:47:35',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:38:36'),(343182,'5','175','2021-10-06',218,'465765','','5',615785.00,'230840','','','3235','SOKOTO STATION ','465765',646685.15,'2021-10-12 12:50:55',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:06:35'),(343184,'5','175','2021-10-06',218,'','','2',15900.00,'230840','','','','','',0.00,'2021-10-12 12:53:16',5,'AGO = 15,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-10-13 12:06:50'),(343186,'5','175','2021-10-06',218,'2057k23z','','10',15000.00,'230840','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 12:55:15',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:06:50'),(343187,'5','175','2021-10-07',218,'465763','','5',639040.00,'230846','','','3235','SOKOTO STATION ','465763',654941.05,'2021-10-12 12:57:24',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:07:15'),(343189,'5','175','2021-10-07',218,'','','2',15900.00,'230846','','','','','',0.00,'2021-10-12 12:58:20',5,'AGO = 15,500\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 12:07:15'),(343190,'5','175','2021-10-08',218,'465780','','5',630660.00,'230847','','','3235','SOKOTO STATION ','465780',656560.15,'2021-10-12 13:00:15',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:07:37'),(343191,'5','175','2021-10-08',218,'','','2',15900.00,'230858','','','','','',0.00,'2021-10-12 13:01:14',5,'AGO  = 15,500\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 12:07:37'),(343193,'5','175','2021-10-08',218,'2057k23z','','10',10000.00,'230847','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 13:02:46',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:07:37'),(343197,'5','175','2021-10-09',218,'465779','','5',513545.00,'230848','','','3235','SOKOTO STATION ','465779',536546.40,'2021-10-12 13:04:49',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:08:04'),(343198,'5','175','2021-10-09',218,'','','2',15900.00,'230848','','','','','',0.00,'2021-10-12 13:05:47',5,'AGO  = 15,500\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 12:08:04'),(343200,'5','175','2021-10-09',218,'2057k23z','','10',7100.00,'230848','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-12 13:06:48',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:08:04'),(343202,'5','175','2021-10-10',218,'465778','','5',73415.00,'230850','','','3235','SOKOTO STATION ','465778',89317.00,'2021-10-12 13:08:50',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:08:31'),(343203,'5','175','2021-10-10',218,'','','2',15900.00,'230850','','','','','',0.00,'2021-10-12 13:09:38',5,'AGO = 15,500\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-13 12:08:31'),(343204,'5','175','2021-10-11',218,'465777','','5',53085.00,'230855','','','3235','SOKOTO STATION ','465777',80684.80,'2021-10-12 13:11:38',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:09:04'),(343206,'5','175','2021-10-11',218,'','','2',28100.00,'230855','','','','','',0.00,'2021-10-12 13:13:34',5,'AGO  = 16,000\r\nWATER  = 400\r\nMONTHLY EXP  = 11,700\r\n','597','','0000-00-00 00:00:00','606','2021-10-13 12:09:04'),(343704,'5','175','2021-10-12',218,'465776','','5',187525.00,'230858','','','3235','SOKOTO STATION ','465776',469924.35,'2021-10-13 11:36:36',5,'','597','','0000-00-00 00:00:00','606','2021-10-13 12:31:11'),(343706,'5','175','2021-10-12',218,'','','2',282400.00,'230858','','','','','',0.00,'2021-10-13 11:38:41',5,'AGO = 16,000\r\nWATER = 400\r\nREG & DRUM = 16,000\r\nSTAFF SALARY  = 250,000','597','','0000-00-00 00:00:00','606','2021-10-13 12:31:11'),(344217,'5','175','2021-10-13',218,'465756','','5',485280.00,'231101','','','3235','SOKOTO STATION ','465756',505027.65,'2021-10-14 10:43:51',5,'','597','','0000-00-00 00:00:00','606','2021-10-16 19:34:45'),(344219,'5','175','2021-10-13',218,'','','2',16400.00,'231101','','','','','',0.00,'2021-10-14 10:45:24',5,'AGO = 16,000\r\nWATER  = 400\r\n','597','','0000-00-00 00:00:00','606','2021-10-16 19:35:19'),(344220,'5','175','2021-10-13',218,'2057k23z','','10',5000.00,'231101','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-14 10:46:44',5,'','597','','0000-00-00 00:00:00','606','2021-10-16 19:35:19'),(344816,'5','175','2021-10-14',218,'465757','','5',498830.00,'231417','','','3235','SOKOTO STATION ','465757',527231.70,'2021-10-15 10:15:09',5,'','597','','0000-00-00 00:00:00','606','2021-10-16 19:35:19'),(344817,'5','175','2021-10-14',218,'','','2',16400.00,'231417','','','','','',0.00,'2021-10-15 10:15:54',5,'AGO = 16,000\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-16 19:35:19'),(344820,'5','175','2021-10-14',218,'2057k23z','','10',12000.00,'231417','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-15 10:16:38',5,'','597','','0000-00-00 00:00:00','606','2021-10-16 19:35:19'),(346522,'5','175','2021-10-15',218,'465754','','5',577360.00,'231669','','','3235','SOKOTO STATION ','465754',600763.40,'2021-10-18 13:15:56',5,'','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346523,'5','175','2021-10-15',218,'','','2',23400.00,'231669','','','','','',0.00,'2021-10-18 13:17:06',5,'AGO = 16,000\r\nWATER  = 400','597','600','2021-10-20 10:32:34','606','2021-10-20 16:19:25'),(346525,'5','175','2021-10-16',218,'465753','','5',497150.00,'231991','','','3235','SOKOTO STATION ','465753',518897.70,'2021-10-18 13:19:19',5,'','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346527,'5','175','2021-10-16',218,'','','2',16750.00,'231991','','','','','',0.00,'2021-10-18 13:20:35',5,'AGO  = 16,350\r\nWATER = 400\r\n','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346528,'5','175','2021-10-16',218,'2057k23z','','10',5000.00,'231991','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-18 13:22:27',5,'','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346529,'5','175','2021-10-17',218,'465759','','5',607745.00,'232184','','','3235','SOKOTO STATION ','465759',642542.55,'2021-10-18 13:24:08',5,'','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346530,'5','175','2021-10-17',218,'','','2',16750.00,'232184','','','','','',0.00,'2021-10-18 13:25:04',5,'AGO  = 16,350\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(346533,'5','175','2021-10-17',218,'2057k23z','','10',18050.00,'232184','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-18 13:26:31',5,'','597','','0000-00-00 00:00:00','606','2021-10-19 14:12:06'),(347390,'5','175','2021-10-18',218,'012843','','5',558155.00,'232341','','','3235','SOKOTO STATION ','012843',575305.29,'2021-10-20 09:51:25',5,'','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347392,'5','175','2021-10-18',218,'','','2',16750.00,'232341','','','','','',0.00,'2021-10-20 09:52:17',5,'AGO  = 16,350\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347398,'5','175','2021-10-18',218,'2057k23z','','10',400.00,'232241','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-20 09:53:21',5,'','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347401,'5','175','2021-10-19',218,'465743','','5',631875.00,'232647','','','3235','SOKOTO STATION ','465743',664627.89,'2021-10-20 09:54:52',5,'','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347404,'5','175','2021-10-19',218,'','','2',16750.00,'232647','','','','','',0.00,'2021-10-20 09:55:48',5,'AGO  = 16,350\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347405,'5','175','2021-10-19',218,'2057k23z','','10',16000.00,'232647','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-20 09:56:45',5,'','597','','0000-00-00 00:00:00','606','2021-10-20 16:19:25'),(347999,'5','175','2021-10-20',218,'465744','','5',23720.00,'232887','','','3235','SOKOTO STATION ','465744',23720.58,'2021-10-21 09:50:53',5,'','597','','0000-00-00 00:00:00','606','2021-10-21 19:05:34'),(348000,'5','175','2021-10-20',218,'465744','','5',489415.00,'233023','','','3235','SOKOTO STATION ','465744',529377.30,'2021-10-21 09:53:46',5,'','597','','0000-00-00 00:00:00','606','2021-10-21 19:05:34'),(348004,'5','175','2021-10-20',218,'','','2',16900.00,'233023','','','','','',0.00,'2021-10-21 09:55:34',5,'AGO = 16,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-10-21 19:05:34'),(348006,'5','175','2021-10-20',218,'2057k23z','','10',23280.00,'233023','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-21 09:56:43',5,'','597','','0000-00-00 00:00:00','606','2021-10-21 19:05:34'),(348775,'5','175','2021-10-21',218,'465745','','5',612585.00,'233126','','','3235','SOKOTO STATION ','465745',663745.50,'2021-10-22 11:42:47',5,'','597','','0000-00-00 00:00:00','606','2021-10-24 17:02:11'),(348776,'5','175','2021-10-21',218,'','','2',17650.00,'233126','','','','','',0.00,'2021-10-22 11:43:44',5,'AGO  = 17,250\r\nWATER  = 400\r\n','597','','0000-00-00 00:00:00','606','2021-10-24 17:02:11'),(348777,'5','175','2021-10-21',218,'2057k23z','','10',33509.00,'233126','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-22 11:44:49',5,'','597','','0000-00-00 00:00:00','606','2021-10-24 17:02:11'),(350318,'5','175','2021-10-22',218,'0133660','','5',752920.00,'233422','','','3235','SOKOTO STATION ','0133660',772071.15,'2021-10-25 12:18:31',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350319,'5','175','2021-10-22',218,'','','2',17650.00,'233422','','','','','',0.00,'2021-10-25 12:19:33',5,'AGO = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350320,'5','175','2021-10-22',218,'2057k23z','','10',1500.00,'233422','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-25 12:20:35',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350323,'5','175','2021-10-23',218,'0133661','','5',972885.00,'233654','','','3235','SOKOTO STATION ','0133661',1032049.80,'2021-10-25 12:22:54',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350325,'5','175','2021-10-23',218,'','','2',17650.00,'233654','','','','','',0.00,'2021-10-25 12:23:45',5,'AGO  = 17,250\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350328,'5','175','2021-10-23',218,'2057k23z','','10',41515.00,'233654','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-25 12:24:57',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350330,'5','175','2021-10-24',218,'465756','','5',1018990.00,'233850','','','3235','SOKOTO STATION ','465756',1041737.25,'2021-10-25 12:26:37',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350332,'5','175','2021-10-24',218,'','','2',17650.00,'233850','','','','','',0.00,'2021-10-25 12:27:28',5,'AGO  = 17,250\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350334,'5','175','2021-10-24',218,'2057k23z','','10',5100.00,'233850','','','3235','SOKOTO STATION ','2057k23z',0.00,'2021-10-25 12:28:22',5,'','597','','0000-00-00 00:00:00','606','2021-10-25 13:49:55'),(350783,'5','175','2021-10-25',218,'133059','','5',414855.00,'234053','','','3235','SOKOTO STATION ','133059',432505.05,'2021-10-26 10:21:23',5,'','597','','0000-00-00 00:00:00','606','2021-10-27 08:54:17'),(350784,'5','175','2021-10-25',218,'','','2',17650.00,'234053','','','','','',0.00,'2021-10-26 10:22:15',5,'AGO  = 17,250\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-27 08:54:17'),(351356,'5','175','2021-10-26',218,'0133053','','5',42445.00,'234406','','','3235','SOKOTO STATION ','1033053',60095.55,'2021-10-27 09:42:48',5,'','597','','0000-00-00 00:00:00','606','2021-10-28 09:29:09'),(351358,'5','175','2021-10-26',218,'','','2',17650.00,'234406','','','','','',0.00,'2021-10-27 09:43:59',5,'AGO  = 17,250\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-10-28 09:29:09'),(351843,'5','175','2021-10-27',218,'1033050','','5',33495.00,'234657','','','3235','SOKOTO STATION ','1033050',51142.80,'2021-10-28 09:02:22',5,'','597','','0000-00-00 00:00:00','606','2021-10-28 10:21:35'),(351846,'5','175','2021-10-27',218,'','','2',17650.00,'234657','','','','','',0.00,'2021-10-28 09:03:43',5,'AGO = 17,250\r\nWATER  = 400','597','600','2021-10-28 09:06:53','606','2021-10-28 10:21:35'),(352449,'5','175','2021-10-28',218,'0133057','','5',29765.00,'234870','','','3235','SOKOTO STATION ','0133057',47416.80,'2021-10-29 10:42:01',5,'','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(352451,'5','175','2021-10-28',218,'','','2',17650.00,'234870','','','','','',0.00,'2021-10-29 10:42:52',5,'AGO = 17,250\r\nWATER  = 400','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353803,'5','175','2021-10-29',218,'0133051','','5',41905.00,'235094','','','3235','SOKOTO STATION ','0133051',59553.90,'2021-11-01 09:39:38',5,'','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353804,'5','175','2021-10-29',218,'','','2',17650.00,'235094','','','','','',0.00,'2021-11-01 09:40:57',5,'AGO = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353806,'5','175','2021-10-30',218,'0133054','','5',76025.00,'235342','','','3235','SOKOTO STATION ','0133054',93674.40,'2021-11-01 09:43:48',5,'','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353808,'5','175','2021-10-30',218,'','','2',17650.00,'235342','','','','','',0.00,'2021-11-01 09:44:46',5,'AGO  = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353809,'5','175','2021-10-31',218,'0133053','','5',82615.00,'235586','','','3235','SOKOTO STATION ','0133053',100263.90,'2021-11-01 09:46:27',5,'','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:44'),(353810,'5','175','2021-10-31',218,'','','2',17650.00,'235586','','','','','',0.00,'2021-11-01 09:47:19',5,'AGO  = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-11-01 16:21:43'),(375927,'5','175','2021-12-10',218,'0133002','','5',1315925.00,'245168','','','3235','Sokoto station','0133002',1352148.60,'2021-12-13 10:39:16',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:44:50'),(375933,'5','175','2021-12-10',218,'2057k23z','','10',13600.00,'0133002','','','3235','Sokoto station','2057k23z',0.00,'2021-12-13 10:41:38',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:44:50'),(375935,'5','175','2021-12-10',218,'','','2',22650.00,'245168','','','','','',0.00,'2021-12-13 10:43:35',5,'GEN = 17,250\r\nWATER = 400\r\nSTAFF TRNSPRT TO KANO = 5,000','597','','0000-00-00 00:00:00','606','2021-12-13 15:44:50'),(375938,'5','175','2021-12-11',218,'0134486','','5',1739055.00,'245243','','','3235','Sokoto station','0134486',1794544.95,'2021-12-13 10:45:48',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:36'),(375939,'5','175','2021-12-11',218,'2057k23z','','10',8000.00,'245243','','','3235','Sokoto station','2057k23z',0.00,'2021-12-13 10:47:04',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:36'),(375943,'5','175','2021-12-11',218,'','','2',47650.00,'245243','','','','','',0.00,'2021-12-13 10:48:40',5,'GEN = 17,250\r\nWATER = 400\r\nLOCAL GOVT REVENUE = 30,000','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:36'),(375946,'5','175','2021-12-12',218,'0133004','','5',910546.00,'245518','','','3235','Sokoto station','0133004',1327195.65,'2021-12-13 10:50:25',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:59'),(375949,'5','175','2021-12-12',218,'2057k23z','','10',4000.00,'245518','','','3235','Sokoto station','2057k23z',0.00,'2021-12-13 10:51:45',5,'','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:59'),(375951,'5','175','2021-12-12',218,'','','2',412650.00,'245518','','','','','',0.00,'2021-12-13 10:53:25',5,'GEN = 17,250\r\nWATER = 400\r\nT/MAFAR SALARY = 395,000','597','','0000-00-00 00:00:00','606','2021-12-13 15:45:59'),(376400,'5','175','2021-12-13',218,'0133005','','5',1120740.00,'245742','','','3235','Sokoto station','0133005',1163091.60,'2021-12-14 10:04:06',5,'','597','600','2021-12-15 09:41:36','600','2021-12-15 09:41:47'),(376401,'5','175','2021-12-13',218,'2057k23z','','10',13000.00,'245742','','','3235','Sokoto station','2057k23z',0.00,'2021-12-14 10:05:05',5,'','597','','0000-00-00 00:00:00','600','2021-12-15 09:41:07'),(376402,'5','175','2021-12-13',218,'','','2',29350.00,'245742','','','','','',0.00,'2021-12-14 10:06:33',5,'GEN = 17,250\r\nWATER = 400\r\nMONTHLY EXP = 11,700','597','','0000-00-00 00:00:00','600','2021-12-15 09:41:07'),(376932,'5','175','2021-12-14',218,'086293','','5',1334755.00,'245992','','','3235','Sokoto station','086293',1363055.10,'2021-12-15 10:10:32',5,'','597','','0000-00-00 00:00:00','600','2021-12-17 07:40:01'),(376934,'5','175','2021-12-14',218,'2057k23z','','10',10650.00,'245992','','','3235','Sokoto station','2057k23z',0.00,'2021-12-15 10:11:30',5,'','597','','0000-00-00 00:00:00','600','2021-12-17 07:40:01'),(376935,'5','175','2021-12-14',218,'','','2',17650.00,'245992','','','','','',0.00,'2021-12-15 10:12:25',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-17 07:40:01'),(377511,'5','175','2021-12-15',218,'0133048','','5',333500.00,'246289','','','3235','Sokoto station','0133048',351141.45,'2021-12-16 10:15:26',5,'','597','','0000-00-00 00:00:00','600','2021-12-17 07:40:01'),(377512,'5','175','2021-12-15',218,'','','2',17650.00,'246289','','','','','',0.00,'2021-12-16 10:16:16',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-17 07:40:01'),(379485,'5','175','2021-12-18',218,'0133039','','5',16600.00,'246968','','','3235','Sokoto station','0133039',34248.15,'2021-12-20 09:39:34',5,'','597','','0000-00-00 00:00:00','600','2021-12-21 09:31:35'),(379487,'5','175','2021-12-18',218,'','','2',17650.00,'246968','','','','','',0.00,'2021-12-20 09:40:40',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-21 09:31:35'),(379490,'5','175','2021-12-19',218,'0133040','','5',63205.00,'247215','','','3235','Sokoto station','0133040',80854.20,'2021-12-20 09:42:29',5,'','597','','0000-00-00 00:00:00','600','2021-12-21 09:31:35'),(379491,'5','175','2021-12-19',218,'','','2',17650.00,'247215','','','','','',0.00,'2021-12-20 09:43:23',5,'GEN  = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-21 09:31:35'),(380032,'5','175','2021-12-20',218,'0133038','','5',107200.00,'247462','','','3235','Sokoto station','0133038',131852.10,'2021-12-21 07:54:37',5,'','597','','0000-00-00 00:00:00','606','2021-12-22 06:27:41'),(380034,'5','175','2021-12-20',218,'','','2',24650.00,'247462','','','','','',0.00,'2021-12-21 07:56:57',5,'GEN = 17,250\r\nWATER = 400\r\nGEN SERVICE = 7,000','597','','0000-00-00 00:00:00','606','2021-12-22 06:27:41'),(380752,'5','175','2021-12-21',218,'0133011','','5',107500.00,'247746','','','3235','Sokoto station','0133011',125193.60,'2021-12-22 10:50:56',5,'','597','','0000-00-00 00:00:00','606','2021-12-23 06:23:33'),(380754,'5','175','2021-12-21',218,'','','2',17650.00,'247746','','','','','',0.00,'2021-12-22 10:51:40',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2021-12-23 06:23:33'),(381288,'5','175','2021-12-22',218,'0133012','','5',106780.00,'248012','','','3235','Sokoto station','0133012',124434.60,'2021-12-23 09:58:38',5,'','597','','0000-00-00 00:00:00','600','2021-12-27 14:53:01'),(381289,'5','175','2021-12-22',218,'','','2',17650.00,'248012','','','','','',0.00,'2021-12-23 09:59:42',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-27 14:53:01'),(381911,'5','175','2021-12-23',218,'0133015','','5',103200.00,'248241','','','3235','Sokoto station','0133015',120853.50,'2021-12-24 11:17:55',5,'','597','','0000-00-00 00:00:00','600','2021-12-27 14:53:24'),(381912,'5','175','2021-12-23',218,'','','2',17650.00,'248241','','','','','',0.00,'2021-12-24 11:18:42',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-27 14:53:24'),(384184,'5','175','2021-12-24',218,'0133016','','5',113470.00,'248577','','','3235','Sokoto station','0133016',131120.70,'2021-12-29 11:46:12',5,'','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384186,'5','175','2021-12-24',218,'','','2',17650.00,'248577','','','','','',0.00,'2021-12-29 11:47:07',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384187,'5','175','2021-12-25',218,'0133014','','5',145045.00,'248821','','','3235','Sokoto station','0133014',162691.65,'2021-12-29 11:49:00',5,'','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384188,'5','175','2021-12-25',218,'','','2',17650.00,'248821','','','','','',0.00,'2021-12-29 11:49:48',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384189,'5','175','2021-12-26',218,'0133013','','5',187605.00,'248945','','','3235','Sokoto station','0133013',205254.30,'2021-12-29 11:52:01',5,'','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384191,'5','175','2021-12-26',218,'','','2',17650.00,'248945','','','','','',0.00,'2021-12-29 11:52:49',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384194,'5','175','2021-12-27',218,'0133022','','5',236510.00,'249197','','','3235','Sokoto station','0133022',254161.50,'2021-12-29 11:54:37',5,'','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384196,'5','175','2021-12-27',218,'','','2',17650.00,'249197','','','','','',0.00,'2021-12-29 11:55:25',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:46'),(384198,'5','175','2021-12-28',218,'0133021','','5',84390.00,'249435','','','3235','Sokoto station','0133021',102037.20,'2021-12-29 11:58:04',5,'','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:45'),(384200,'5','175','2021-12-28',218,'','','2',17650.00,'249435','','','','','',0.00,'2021-12-29 11:58:58',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2021-12-30 08:51:45'),(384729,'5','175','2021-12-29',218,'0133028','','5',101720.00,'249651','','','3235','Sokoto station','0133028',119594.25,'2021-12-30 10:52:27',5,'','597','','0000-00-00 00:00:00','606','2022-01-02 17:30:22'),(384730,'5','175','2021-12-29',218,'','','2',17650.00,'249651','','','','','',0.00,'2021-12-30 10:53:11',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-02 17:30:22'),(385357,'5','175','2021-12-30',218,'0133017','','5',109230.00,'249920','','','3235','Sokoto station','0133017',127384.35,'2021-12-31 11:41:38',5,'','597','','0000-00-00 00:00:00','606','2022-01-02 17:30:22'),(385360,'5','175','2021-12-30',218,'','','2',17650.00,'249920','','','','','',0.00,'2021-12-31 11:42:22',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-02 17:30:22'),(387140,'5','175','2021-12-31',218,'0133019','','5',106580.00,'250288','','','3235','Sokoto station','0133018',124231.05,'2022-01-04 10:08:39',5,'','597','600','2022-01-04 11:10:11','600','2022-01-05 17:19:20'),(387141,'5','175','2021-12-31',218,'','','2',17650.00,'250288','','','','','',0.00,'2022-01-04 10:09:34',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387144,'5','175','2022-01-01',218,'0133018','','5',170530.00,'250470','','','3235','Sokoto station','0133018',188180.25,'2022-01-04 10:11:28',5,'','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387145,'5','175','2022-01-01',218,'','','2',17650.00,'250470','','','','','',0.00,'2022-01-04 10:12:26',5,'GEN = 17,650\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387150,'5','175','2022-01-02',218,'0133020','','5',117170.00,'250667','','','3235','Sokoto station','0133020',134822.55,'2022-01-04 10:14:07',5,'','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387151,'5','175','2022-01-02',218,'','','2',17650.00,'250667','','','','','',0.00,'2022-01-04 10:15:03',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387157,'5','175','2022-01-03',218,'013080304','','5',109995.00,'250969','','','3235','Sokoto station','01370304',127646.55,'2022-01-04 10:17:03',5,'','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387158,'5','175','2022-01-03',218,'','','2',17650.00,'250969','','','','','',0.00,'2022-01-04 10:17:55',5,'GEN,= 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-05 17:19:20'),(387735,'5','175','2022-01-04',218,'0133044','','5',24440.00,'251075','','','3235','Sokoto station','0133044',167093.85,'2022-01-05 11:17:51',5,'','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(387739,'5','175','2022-01-04',218,'','','2',142650.00,'251075','','','','','',0.00,'2022-01-05 11:20:34',5,'GEN = 17,250\r\nWATER = 400\r\nSALARY = 125,000','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(388482,'5','175','2022-01-05',218,'0133031','','5',1225520.00,'251321','','','3235','Sokoto station','0133031',1569175.65,'2022-01-06 12:15:22',5,'','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(388486,'5','175','2022-01-05',218,'','','2',315150.00,'251321','','','','','',0.00,'2022-01-06 12:18:01',5,'GEN = 17,250\r\nWATER = 400\r\nDIVERSION = 500 LTS × 345 = 172,500\r\nSALARY TOPPING = 125,000','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(388488,'5','175','2022-01-05',218,'2057k23z','','10',28500.00,'251321','','','3235','Sokoto station','2057k23z',0.00,'2022-01-06 12:19:06',5,'','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(389013,'5','175','2022-01-06',218,'0133037','','5',1675160.00,'251569','','','3235','Sokoto station','0133037',1702808.25,'2022-01-07 11:49:28',5,'','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(389015,'5','175','2022-01-06',218,'','','2',17650.00,'251569','','','','','',0.00,'2022-01-07 11:50:14',5,'GEN = 17,250\r\nAGO = 400','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(389017,'5','175','2022-01-06',218,'2057k23z','','10',10000.00,'251569','','','3235','Sokoto station','2057k23z',0.00,'2022-01-07 11:51:06',5,'','597','','0000-00-00 00:00:00','600','2022-01-09 21:36:37'),(390445,'5','175','2022-01-07',218,'0133033','','5',1901015.00,'251827','','','3235','Sokoto station','0133033',1918673.70,'2022-01-10 10:49:00',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390446,'5','175','2022-01-07',218,'','','2',17650.00,'251827','','','','','',0.00,'2022-01-10 10:49:59',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390456,'5','175','2022-01-08',218,'0133034','','5',2397495.00,'252043','','','3235','Sokoto station','0133034',2446139.10,'2022-01-10 10:54:05',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390460,'5','175','2022-01-08',218,'','','2',17650.00,'252043','','','','','',0.00,'2022-01-10 10:54:59',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390462,'5','175','2022-01-08',218,'2057k23z','','10',31000.00,'252043','','','3235','Sokoto station','2057k23z',0.00,'2022-01-10 10:56:50',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390465,'5','175','2022-01-09',218,'0133035','','5',1034420.00,'252280','','','3235','Sokoto station','0133035',1064416.50,'2022-01-10 11:00:31',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390466,'5','175','2022-01-09',218,'','','2',17650.00,'252280','','','','','',0.00,'2022-01-10 11:01:47',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390469,'5','175','2022-01-09',218,'2057k23z','','10',12000.00,'252280','','','3235','Sokoto station','2057k23z',0.00,'2022-01-10 11:03:25',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390947,'5','175','2022-01-10',218,'0133029','','5',141580.00,'252570','','','3235','Sokoto station','0133029',170826.75,'2022-01-11 09:59:31',5,'','597','','0000-00-00 00:00:00','600','2022-01-11 11:05:25'),(390948,'5','175','2022-01-10',218,'','','2',29350.00,'252570','','','','','',0.00,'2022-01-11 10:00:45',5,'GEN = 17,250\r\nWATER = 400','597','600','2022-01-11 10:07:55','600','2022-01-11 11:05:25'),(391667,'5','175','2022-01-11',218,'225','','5',97930.00,'252769','','','4075','Sokoto station','225',115578.45,'2022-01-12 12:33:03',5,'','597','','0000-00-00 00:00:00','600','2022-01-13 12:02:53'),(391668,'5','175','2022-01-11',218,'','','2',17650.00,'252769','','','','','',0.00,'2022-01-12 12:33:43',5,'GEN = 17,250\r\nWATER = 400','597','600','2022-01-13 12:02:46','600','2022-01-13 12:02:53'),(392173,'5','175','2022-01-12',218,'016197','','5',90000.00,'253031','','','4075','SOKOTO STATION ','016197',107650.35,'2022-01-13 10:07:30',5,'','597','','0000-00-00 00:00:00','600','2022-01-14 10:15:19'),(392175,'5','175','2022-01-12',218,'','','2',17650.00,'253031','','','','','',0.00,'2022-01-13 10:08:14',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-14 10:15:19'),(392857,'5','175','2022-01-13',218,'0029','','5',77300.00,'253245','','','4075','SOKOTO STATION ','0029',94954.35,'2022-01-14 11:07:10',5,'','597','','0000-00-00 00:00:00','600','2022-01-14 16:29:10'),(392858,'5','175','2022-01-13',218,'','','2',17650.00,'253245','','','','','',0.00,'2022-01-14 11:08:03',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-01-14 16:29:10'),(394531,'5','175','2022-01-14',218,'028','','5',93140.00,'253545','','','4075','SOKOTO STATION ','028',110789.85,'2022-01-17 12:56:37',5,'','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394533,'5','175','2022-01-14',218,'','','2',17650.00,'253545','','','','','',0.00,'2022-01-17 12:57:29',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394534,'5','175','2022-01-15',218,'029','','5',68805.00,'253792','','','4075','SOKOTO STATION ','029',86453.55,'2022-01-17 12:59:01',5,'','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394536,'5','175','2022-01-15',218,'','','2',17650.00,'253792','','','','','',0.00,'2022-01-17 13:00:52',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394537,'5','175','2022-01-16',218,'020','','5',90445.00,'254000','','','4075','SOKOTO STATION ','020',108098.85,'2022-01-17 13:02:26',5,'','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394539,'5','175','2022-01-16',218,'','','2',17650.00,'254000','','','','','',0.00,'2022-01-17 13:03:12',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394983,'5','175','2022-01-17',218,'0225','','5',45145.00,'254274','','','4075','SOKOTO STATION ','0225',62796.90,'2022-01-18 09:54:31',5,'','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(394985,'5','175','2022-01-17',218,'','','2',17650.00,'254274','','','','','',0.00,'2022-01-18 09:55:28',5,'GEN = 17,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-18 11:16:34'),(395619,'5','175','2022-01-18',218,'225','','5',1968750.00,'254517','','','4075','SOKOTO STATION ','225',2007399.90,'2022-01-19 10:44:59',5,'','597','','0000-00-00 00:00:00','606','2022-01-19 13:06:06'),(395624,'5','175','2022-01-18',218,'','','2',29650.00,'254517','','','','','',0.00,'2022-01-19 10:47:25',5,'GEN = 17,250\r\nWATER = 400\r\nGEN SERVICE = 7,000\r\nWEIGHT MEASURE = 5,000','597','','0000-00-00 00:00:00','606','2022-01-19 13:06:06'),(395627,'5','175','2022-01-18',218,'2057k23z','','10',9000.00,'254517','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-01-19 10:50:01',5,'','597','','0000-00-00 00:00:00','606','2022-01-19 13:06:06'),(396110,'5','175','2022-01-19',218,'225','','5',1746585.00,'254768','','','4075','SOKOTO STATION ','225',1764483.60,'2022-01-20 10:28:28',5,'','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(396111,'5','175','2022-01-19',218,'','','2',17900.00,'254768','','','','','',0.00,'2022-01-20 10:29:16',5,'GEN = 17,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(396681,'5','175','2022-01-20',218,'0225','','5',1598155.00,'255031','','','4075','SOKOTO STATION ','0225',1621052.40,'2022-01-21 11:30:25',5,'','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(396683,'5','175','2022-01-20',218,'','','2',17900.00,'255031','','','','','',0.00,'2022-01-21 11:32:49',5,'GEN = 17,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(396684,'5','175','2022-01-20',218,'2057k23z','','5',5000.00,'255031','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-01-21 11:33:44',5,'','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(398095,'5','175','2022-01-21',218,'225','','5',1164715.00,'255247','','','4075','SOKOTO STATION ','225',1187613.90,'2022-01-24 11:37:24',5,'','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(398096,'5','175','2022-01-21',218,'','','2',17900.00,'255247','','','','','',0.00,'2022-01-24 11:39:59',5,'GEN = 17,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(398097,'5','175','2022-01-21',218,'2057k23z','','10',5000.00,'255247','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-01-24 11:42:35',5,'','597','','0000-00-00 00:00:00','606','2022-01-25 09:46:21'),(400314,'5','175','2022-01-28',218,'','','2',223495.00,'256800','','','','','',0.00,'2022-01-28 12:10:37',2,'','600','','0000-00-00 00:00:00','600','2022-01-28 12:10:59'),(400315,'5','175','2022-02-03',218,'029','','5',409500.00,'257535','','','4075','Sokoto station','029',437880.30,'2022-02-04 11:56:56',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:49:32'),(400316,'5','175','2022-02-03',218,'','','2',18650.00,'257535','','','','','',0.00,'2022-02-04 11:57:59',5,'GEN = 18,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-02-08 10:51:42'),(400317,'5','175','2022-02-03',218,'2057k23z','','10',9730.00,'257535','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-04 11:58:51',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:51:42'),(400318,'5','175','2022-02-04',218,'029','','5',1264065.00,'257536','','','4075','SOKOTO STATION ','029',1282716.60,'2022-02-07 14:11:48',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400319,'5','175','2022-02-04',218,'','','2',18650.00,'257536','','','','','',0.00,'2022-02-07 14:12:44',5,'GEN = 18,250\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400320,'5','175','2022-02-05',218,'029','','5',1218720.00,'257537','','','4075','SOKOTO STATION ','029',1256691.15,'2022-02-07 14:14:15',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400321,'5','175','2022-02-05',218,'','','2',19900.00,'257537','','','','','',0.00,'2022-02-07 14:15:20',5,'GEN = 19,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400322,'5','175','2022-02-05',218,'2057k23z','','10',18070.00,'257537','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-07 14:16:31',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400323,'5','175','2022-02-06',218,'029','','5',979010.00,'257538','','','4075','SOKOTO STATION ','029',1006909.20,'2022-02-07 14:17:33',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400324,'5','175','2022-02-06',218,'','','2',19900.00,'257538','','','','','',0.00,'2022-02-07 14:18:29',5,'GEN = 19,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400325,'5','175','2022-02-06',218,'2057k23z','','10',8000.00,'257538','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-07 14:19:21',5,'','597','','0000-00-00 00:00:00','606','2022-02-08 10:53:37'),(400326,'5','175','2022-02-07',218,'029','','5',1414110.00,'257539','','','4075','SOKOTO STATION ','029',1690009.20,'2022-02-08 13:08:26',5,'','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400327,'5','175','2022-02-07',218,'','','2',274900.00,'257539','','','','','',0.00,'2022-02-08 13:10:38',5,'GEN = 19,500\r\nWATER = 400\r\nWEIGHT & MEASURE = 5,000\r\nSTAFF SALARY = 250,000','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400328,'5','175','2022-02-07',218,'2057k23z','','10',1000.00,'257539','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-08 13:11:50',5,'','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400329,'5','175','2022-02-08',218,'029','','5',1037325.00,'257540','','','4075','SOKOTO STATION ','029',1057222.65,'2022-02-09 13:09:10',5,'','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400330,'5','175','2022-02-08',218,'','','2',19900.00,'257540','','','','','',0.00,'2022-02-09 13:12:23',5,'GEN = 19,500\r\nWATER = 400','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400331,'5','175','2022-02-09',218,'225','','5',681205.00,'257541','','','4075','SOKOTO STATION ','225',713352.75,'2022-02-10 13:12:20',5,'','597','','0000-00-00 00:00:00','606','2022-02-11 11:52:36'),(400332,'5','175','2022-02-09',218,'','','2',32850.00,'257541','','','','','',0.00,'2022-02-10 13:14:45',5,'GEN = 20,750\r\nWATER = 400\r\nMONTHLY EXP = 11,700','597','','0000-00-00 00:00:00','606','2022-02-17 10:15:50'),(400333,'5','175','2022-02-23',218,'029','','5',934900.00,'257555','','','4075','SOKOTO STATION ','029',962052.30,'2022-02-24 12:54:41',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:13:24'),(400334,'5','175','2022-02-23',218,'','','2',21150.00,'257555','','','','','',0.00,'2022-02-24 12:55:51',5,'GEN = 20,750\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-03-02 15:12:42'),(400335,'5','175','2022-02-23',218,'2057k23z','','10',6300.00,'257555','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-24 12:56:46',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:13:24'),(400336,'5','175','2022-02-24',218,'029','','5',1234765.00,'257556','','','4075','SOKOTO STATION ','029',1269981.90,'2022-02-25 12:53:45',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:13:24'),(400337,'5','175','2022-02-24',218,'','','2',21150.00,'257556','','','','','',0.00,'2022-02-25 12:54:44',5,'GEN = 20,750\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-03-02 15:13:54'),(400338,'5','175','2022-02-24',218,'2057k23z','','10',14000.00,'257556','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-25 12:55:44',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:13:54'),(400339,'5','175','2022-02-25',218,'029','','5',1154950.00,'257557','','','4075','SOKOTO STATION ','029',1177101.75,'2022-02-28 11:54:03',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:14:17'),(400340,'5','175','2022-02-25',218,'','','2',21150.00,'257557','','','','','',0.00,'2022-02-28 11:54:47',5,'GEN = 20,750\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-03-02 15:14:17'),(400341,'5','175','2022-02-25',218,'2057k23z','','10',1000.00,'257557','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-28 11:55:53',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:14:17'),(400342,'5','175','2022-02-26',218,'029','','5',1289820.00,'257558','','','4075','SOKOTO STATION ','029',1310972.85,'2022-02-28 11:57:08',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:15:10'),(400343,'5','175','2022-02-26',218,'','','2',21150.00,'257558','','','','','',0.00,'2022-02-28 11:58:04',5,'GEN = 20,750\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-03-02 15:15:10'),(400344,'5','175','2022-02-27',218,'029','','5',1421060.00,'257559','','','4075','SOKOTO STATION ','029',1474011.00,'2022-02-28 11:59:23',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:15:10'),(400345,'5','175','2022-02-27',218,'','','2',21150.00,'257559','','','','','',0.00,'2022-02-28 12:00:18',5,'GEN = 20,750\r\nWATER = 400','597','','0000-00-00 00:00:00','600','2022-03-02 15:15:10'),(400346,'5','175','2022-02-27',218,'2057k23z','','5',31700.00,'257559','','','3235','SOKOTO STATION ','2057k23z',0.00,'2022-02-28 12:01:44',5,'','597','','0000-00-00 00:00:00','600','2022-03-02 15:15:10'),(400347,'5','175','2022-03-15',218,'6926431','','5',452140.00,'257574','','','4076','Sokoto Station','6926431',547734.00,'2022-03-16 12:06:57',5,'Payment for 15/3/2022 Sales','597','','0000-00-00 00:00:00','600','2022-03-22 15:49:19'),(400348,'5','175','2022-03-15',218,'6926431','','5',95600.00,'257574','','','4076','Sokoto Station','6926431',0.00,'2022-03-16 12:10:23',5,'POS #21,500\r\nWater Vendor #400\r\nGenerator AGO #32,000\r\nMonthly Expenses #11,700\r\nLocal Government Revenue #30,000','597','600','2022-03-22 15:47:52','600','2022-03-22 15:49:19'),(400349,'5','175','2022-03-16',218,'6926159','','5',870400.00,'257575','','','4076','Sokoto Station','6926159',908760.60,'2022-03-17 12:34:12',5,'Payment for Sales of 16/3/2022','597','','0000-00-00 00:00:00','600','2022-03-22 15:49:19'),(400350,'5','175','2022-03-16',218,'6926159','','5',38400.00,'257575','','','4076','Sokoto Station','6926159',0.00,'2022-03-17 12:35:58',5,'POS #6000\r\nWater Vendor #400\r\nGen AGO #32,000','597','600','2022-03-22 15:48:18','600','2022-03-22 15:49:19'),(400351,'5','175','2022-03-17',218,'6926181','','5',560010.00,'257576','','','4076','Sokoto Station','6926181',597410.55,'2022-03-18 13:11:31',5,'Payment for the sales of 17/3/2022','597','','0000-00-00 00:00:00','600','2022-03-22 15:49:19'),(400352,'5','175','2022-03-17',218,'6926181','','2',37400.00,'257576','','','','','',0.00,'2022-03-18 13:13:25',5,'Water Vendor #400\r\nGen AGO #32,000\r\nWeight and Measure #5000','597','600','2022-03-22 15:48:43','600','2022-03-22 15:49:19'),(400353,'5','175','2022-03-18',218,'6924977','','5',168090.00,'257577','','','4076','Sokoto Station','6924977',200491.50,'2022-03-21 11:34:14',5,'Payment for the sales of 18/03/2022','597','','0000-00-00 00:00:00','600','2022-03-22 15:49:19'),(400354,'5','175','2022-03-18',218,'6924977','','2',32400.00,'257580','','','','','',0.00,'2022-03-21 11:35:37',5,'Water Vendor #400\r\nGen AGO #32,000','597','600','2022-03-22 15:49:04','600','2022-03-22 15:49:19'),(400355,'5','175','2022-04-22',218,'1603036','','5',124400.00,'257609','','','4076','Sokoto Station','1603036',161799.00,'2022-04-26 11:36:24',5,'Payment for Sales of 22/04/22','597','','0000-00-00 00:00:00','600','2022-04-26 14:44:11'),(400357,'5','175','2022-04-22',218,'1603036','','2',33400.00,'257609','','','','','',0.00,'2022-04-26 11:44:44',5,'Gen AGO #33,000\r\nWater Vendor #400','597','600','2022-04-26 14:44:04','600','2022-04-26 14:44:11'),(400358,'5','175','2022-04-23',218,'1603036','','5',898680.00,'257610','','','4076','Sokoto Station','1603036',962984.55,'2022-04-26 11:53:48',5,'Payment for the sales of 23/04/2022','597','','0000-00-00 00:00:00','600','2022-04-26 14:45:15'),(400359,'5','175','2022-04-23',218,'113830','','10',17200.00,'257610','','','3235','Sokoto Station','113830',962984.55,'2022-04-26 11:55:56',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-10 22:50:54'),(400360,'5','175','2022-04-23',218,'1603036','','2',47100.00,'257610','','','','','',0.00,'2022-04-26 11:58:31',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nMonthly Expenses #11,700\r\nDust Removal for the month of March #2000','597','600','2022-04-26 14:45:05','600','2022-04-26 14:45:15'),(400361,'5','175','2022-04-24',218,'1603036','','5',843820.00,'257611','','','4076','Sokoto Station','1603036',877224.15,'2022-04-26 12:02:01',5,'Payment for the sales of 24/04/22','597','','0000-00-00 00:00:00','600','2022-04-26 14:46:07'),(400362,'5','175','2022-04-24',218,'1603036','','2',33400.00,'257611','','','','','',0.00,'2022-04-26 12:03:14',5,'Gen AGO #33,000\r\nWater Vendor #400','597','600','2022-04-26 14:45:55','600','2022-04-26 14:46:07'),(400363,'5','175','2022-04-25',218,'1592206','','5',664700.00,'257612','','','4076','Sokoto Station','1592206',923094.15,'2022-04-26 14:00:58',5,'Payment for the sales of 25/04/22','597','','0000-00-00 00:00:00','600','2022-04-26 14:46:25'),(400364,'5','175','2022-04-25',218,'1592206','','2',33400.00,'257612','','','','','',0.00,'2022-04-26 14:02:02',5,'Gen AGO #33,000\r\nWater Vendor #400','597','600','2022-04-26 14:46:19','600','2022-04-26 14:46:25'),(400365,'5','175','2022-04-22',218,'174804','','10',4000.00,'257609','','','3235','Sokoto Station','174804',0.00,'2022-04-26 15:11:26',5,'POS Payment','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400366,'5','175','2022-04-23',218,'113830','','10',17200.00,'257610','','','3235','Sokoto Station','113830',0.00,'2022-04-26 15:13:25',5,'POS','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400367,'5','175','2022-04-26',218,'1592324','','5',824040.00,'257613','','','4076','Sokoto Station','1592324',860445.30,'2022-04-27 13:03:39',5,'Payment for the sales of 26/04/2022','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400368,'5','175','2022-04-26',218,'122226','','10',3000.00,'257613','','','3235','Sokoto Station','122226',0.00,'2022-04-27 13:05:28',5,'POS Payment','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400369,'5','175','2022-04-26',218,'1592324','','2',33400.00,'257613','','','','','',0.00,'2022-04-27 13:06:38',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400370,'5','175','2022-04-27',218,'1597163','','5',978710.00,'257614','','','4076','Sokoto Station','1597163',1012105.05,'2022-04-28 11:55:05',5,'Payment for the sales of 27/04/2022','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400371,'5','175','2022-04-27',218,'1597163','','2',33400.00,'257614','','','','','',0.00,'2022-04-28 11:56:04',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','600','2022-04-29 14:24:30'),(400372,'5','175','2022-04-28',218,'454731','','5',967020.00,'257615','','','4076','Sokoto Station','454731',1000421.40,'2022-05-11 08:56:01',5,'Payment for Sales of 28/04/22','597','','0000-00-00 00:00:00','664','2022-05-11 09:31:17'),(400373,'5','175','2022-04-28',218,'454731','','2',33400.00,'257615','','','','','',0.00,'2022-05-11 08:58:45',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-11 09:31:17'),(400374,'5','175','2022-04-29',218,'107065','','5',652330.00,'257616','','','4076','Sokoto Station','107065',687731.55,'2022-05-11 09:03:55',5,'Pay','597','','0000-00-00 00:00:00','664','2022-05-11 09:31:17'),(400375,'5','175','2022-04-29',218,'00000622050412192384','','2',35400.00,'257616','','','','','',0.00,'2022-05-11 09:07:14',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nDust Removal #2000','597','','0000-00-00 00:00:00','664','2022-05-11 09:31:17'),(400376,'5','175','2022-04-30',218,'107065','','5',647145.00,'257617','','','4076','Sokoto Station','107065',680544.15,'2022-05-11 09:17:02',5,'Payment for the Sales of 30/04/2022','597','600','2022-05-11 09:27:44','664','2022-05-11 09:31:17'),(400377,'5','175','2022-04-30',218,'107065','','2',33400.00,'257617','','','','','',0.00,'2022-05-11 09:19:03',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-11 09:31:17'),(400378,'5','175','2022-04-22',218,'7339','','10',4000.00,'257609','','','3235','Sokoto Station','7339',0.00,'2022-05-11 09:32:30',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400379,'5','175','2022-05-01',218,'107065','','5',13925.00,'257618','','','4076','Sokoto Station','107065',284024.40,'2022-05-11 09:36:10',5,'Payment for the Sales of 1/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400380,'5','175','2022-05-01',218,'107065','','2',270100.00,'257618','','','','','',0.00,'2022-05-11 09:38:21',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nMonthly Expenses #11,700\r\nStaffs Salary #225,000','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400381,'5','175','2022-05-05',218,'481033','','5',528640.00,'257622','','','4076','Sokoto Station','481033',562037.85,'2022-05-11 09:41:04',5,'Payment for the Sales of 5/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400382,'5','175','2022-05-05',218,'481033','','2',33400.00,'257622','','','','','',0.00,'2022-05-11 09:42:21',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400383,'5','175','2022-05-06',218,'761684','','5',575610.00,'257623','','','4076','Sokoto Station','761684',609011.70,'2022-05-11 09:45:03',5,'Payment for the Sales of 6/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400384,'5','175','2022-05-06',218,'761684','','2',33400.00,'257623','','','','','',0.00,'2022-05-11 09:46:04',5,'Gen AGO #33,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-11 09:46:24'),(400385,'5','175','2022-05-07',218,'761684','','5',654280.00,'257624','','','4076','Sokoto Station','761684',893677.95,'2022-05-11 09:48:46',5,'Payment for the Sales of 7/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 09:54:49'),(400386,'5','175','2022-05-07',218,'392655','','10',16000.00,'257624','','','3235','Sokoto Station','392655',0.00,'2022-05-11 09:51:55',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-11 09:54:49'),(400387,'5','175','2022-05-07',218,'761684','','2',223400.00,'257624','','','','','',0.00,'2022-05-11 09:53:50',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nHouse Rent #190,000','597','','0000-00-00 00:00:00','664','2022-05-11 09:54:49'),(400388,'5','175','2022-05-08',218,'761684','','5',789870.00,'257625','','','4076','Sokoto Station','761684',834271.35,'2022-05-11 09:58:00',5,'Payment for the Sales of 8/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:02'),(400389,'5','175','2022-05-08',218,'573636','','10',11000.00,'257625','','','3235','Sokoto Station','573636',0.00,'2022-05-11 09:59:35',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:02'),(400390,'5','175','2022-05-08',218,'761684','','2',33400.00,'257625','','','','','',0.00,'2022-05-11 10:00:34',5,'Gen AGO #33,000\r\nWater Vendor #4000','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:02'),(400391,'5','175','2022-05-09',218,'276877','','5',623545.00,'257626','','','4076','Sokoto Station','276877',676942.20,'2022-05-11 10:04:57',5,'Payment for the Sales of 9/5/2022','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:02'),(400392,'5','175','2022-05-09',218,'444208','','10',10000.00,'257626','','','3235','Sokoto Station','444208',0.00,'2022-05-11 10:06:22',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:02'),(400393,'5','175','2022-05-09',218,'276877','','2',43400.00,'257626','','','','','',0.00,'2022-05-11 10:07:57',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nWeight and Measure #10,000','597','','0000-00-00 00:00:00','664','2022-05-11 10:08:09'),(400394,'5','175','2022-05-10',218,'475012','','5',528500.00,'257627','','','4076','Sokoto Station','475012',592899.45,'2022-05-11 12:38:54',5,'Payment for the sales of 10/05/2022','597','','0000-00-00 00:00:00','664','2022-05-11 16:47:46'),(400395,'5','175','2022-05-10',218,'475012','','2',64400.00,'257627','','','','','',0.00,'2022-05-11 12:40:27',5,'Gen AGO #33,000\r\nWater Vendor #400\r\nRefilling of Fire Extinguisher #31,000','597','','0000-00-00 00:00:00','664','2022-05-11 16:47:46'),(400396,'5','175','2022-05-11',218,'670805','','5',165880.00,'257628','','','4076','Sokoto Station','670805',199379.40,'2022-05-12 10:21:55',5,'Payment for the Sales of 21)05/2022','597','','0000-00-00 00:00:00','664','2022-05-12 15:05:02'),(400397,'5','175','2022-05-11',218,'670805','','2',33400.00,'257628','','','','','',0.00,'2022-05-12 10:23:19',5,'Gen AGO #33,400\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-12 15:05:02'),(400398,'5','175','2022-05-28',218,'257378','','5',165895.00,'257645','','','4076','Sokoto Station','257378',208296.00,'2022-05-30 12:33:47',5,'Payment for the Sales of 28/05/2022','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400399,'5','175','2022-05-28',218,'192701','','10',7000.00,'257645','','','3235','Sokoto Station','192701',0.00,'2022-05-30 12:42:11',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400400,'5','175','2022-05-28',218,'257378','','2',35400.00,'257645','','','','','',0.00,'2022-05-30 12:44:05',5,'Gen AGO #35,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400401,'5','175','2022-05-29',218,'257378','','5',855205.00,'257646','','','4076','Sokoto Station','257378',902472.45,'2022-05-30 12:45:38',5,'Payment for the Sales of 29/05/2022','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400402,'5','175','2022-05-29',218,'257378','','10',1890.00,'257646','','','3235','Sokoto Station','257378',0.00,'2022-05-30 12:52:24',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400403,'5','175','2022-05-29',218,'257378','','2',45400.00,'257646','','','','','',0.00,'2022-05-30 12:54:16',5,'Gen AGO #35,000\r\nWater Vendor #400\r\nHouse Rent Completion #10,000','597','','0000-00-00 00:00:00','664','2022-05-30 16:50:28'),(400406,'5','175','2022-05-30',218,'145215','','5',692645.00,'257647','','','4076','Sokoto Station','145215',739944.15,'2022-05-31 19:44:37',5,'Payment for the Sales of 30/05/2022','597','','0000-00-00 00:00:00','664','2022-05-31 20:10:13'),(400407,'5','175','2022-05-30',218,'145215','','2',47400.00,'257647','','','','','',0.00,'2022-05-31 19:47:02',5,'Gen AGO #35,000\r\nWater Vendor #400\r\nDust Removal #2000\r\nWeight and Measure #10,000','597','','0000-00-00 00:00:00','664','2022-05-31 20:10:13'),(400408,'5','175','2022-05-31',218,'1588453','','5',728880.00,'257648','','','4076','Sokoto Station','1588453',774279.00,'2022-06-01 14:44:35',5,'Payment for the Sales of 31/05/2022','597','','0000-00-00 00:00:00','664','2022-06-01 18:39:40'),(400409,'5','175','2022-05-31',218,'1588453','','2',45400.00,'257648','','','','','',0.00,'2022-06-01 14:58:39',5,'Gen AGO #35,000\r\nWater Vendor #400\r\nGen Service #10,000','597','','0000-00-00 00:00:00','664','2022-06-01 18:39:40'),(400410,'5','175','2022-06-01',218,'421772','','5',753255.00,'257649','','','4076','Sokoto Station','421772',800355.60,'2022-06-02 13:13:17',5,'Payment for the Sales of 01/06/2022','597','','0000-00-00 00:00:00','664','2022-06-02 16:26:11'),(400411,'5','175','2022-06-01',218,'421772','','2',47100.00,'257649','','','','','',0.00,'2022-06-02 13:14:59',5,'Gen AGO #35,000\r\nWater Vendor #400\r\nMonthly Expenses #11,700\r\n','597','','0000-00-00 00:00:00','664','2022-06-02 16:26:11'),(400412,'5','175','2022-06-02',218,'157805','','5',245650.00,'257650','','','4076','Sokoto Station','157805',281049.45,'2022-06-03 12:24:39',5,'Payment for the Sales of 02/06/2022','597','','0000-00-00 00:00:00','664','2022-06-03 19:05:00'),(400413,'5','175','2022-06-02',218,'157805','','2',35400.00,'257650','','','','','',0.00,'2022-06-03 12:25:38',5,'Gen AGO #35,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-06-03 19:05:00'),(400414,'5','175','2022-07-17',218,'6977419','','5',178825.00,'257695','','','4076','Sokoto Station','6977419',219225.00,'2022-07-18 19:33:02',5,'Payment for the Sales of 17/07/2022','597','','0000-00-00 00:00:00','664','2022-07-18 20:04:17'),(400415,'5','175','2022-07-17',218,'6977419','','2',40400.00,'257695','','','','','',0.00,'2022-07-18 19:34:50',5,'Gen AGO #40,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-07-18 20:04:17'),(400416,'5','175','2022-07-19',218,'825826','','5',452625.00,'257697','','','4076','Sokoto Station','825826',648302.90,'2022-07-20 08:29:58',5,'Payment for the Sales of 19/07/2022','597','','0000-00-00 00:00:00','664','2022-07-20 09:02:51'),(400417,'5','175','2022-07-19',218,'825826','','10',10000.00,'257697','','','3235','Sokoto Station','825826',0.00,'2022-07-20 08:31:44',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-20 09:02:51'),(400418,'5','175','2022-07-20',218,'825826','','2',474285.00,'257697','','','','','',0.00,'2022-07-20 08:37:22',5,'Gen AGO #40,000\r\nWater Vendor 400\r\nOverage Payment #41,885\r\nDust Removal #2000\r\nSalary #380,000\r\n','597','','0000-00-00 00:00:00','664','2022-07-20 09:02:51'),(400419,'5','175','2022-07-18',218,'825826','','5',452625.00,'257696','','','4076','Sokoto Station','825826',648302.90,'2022-07-20 15:12:36',5,'','597','','0000-00-00 00:00:00','664','2022-07-20 16:28:42'),(400420,'5','175','2022-07-19',218,'037026','','5',583905.00,'257697','','','4076','Sokoto Station','037026',648302.90,'2022-07-20 15:16:06',5,'Payment for the Sales of 19/07/2022','597','','0000-00-00 00:00:00','664','2022-07-20 16:28:42'),(400421,'5','175','2022-07-19',218,'037026','','10',24000.00,'257697','','','3235','Sokoto Station','037026',0.00,'2022-07-20 15:17:17',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-20 16:28:42'),(400422,'5','175','2022-07-19',218,'037026','','2',40400.00,'257697','','','','','',0.00,'2022-07-20 15:18:24',5,'Gen AGO #40,000\r\nWater Vendor #400','597','','0000-00-00 00:00:00','664','2022-07-20 16:28:42'),(400423,'5','175','2022-07-20',218,'880171','','5',732330.00,'257698','','','4076','Sokoto Station','880171',997730.90,'2022-07-21 12:30:17',5,'Payment for the Sales of 20/07/2022','597','','0000-00-00 00:00:00','664','2022-07-21 19:57:33'),(400424,'5','175','2022-07-20',218,'880171','','2',265400.00,'257698','','','','Sokoto Station','',0.00,'2022-07-21 12:32:24',5,'Water Vendor #400\r\nGen AGO #40,000\r\nStaffs Salary for the month of May #225,000','597','','0000-00-00 00:00:00','664','2022-07-21 19:57:33'),(400425,'5','175','2022-07-21',218,'6988014','','5',773560.00,'257699','','','4076','Sokoto Station','6988014',828041.50,'2022-07-22 15:05:57',5,'Payment for the Sales of 21/072022','597','','0000-00-00 00:00:00','664','2022-07-22 16:44:52'),(400426,'5','175','2022-07-21',218,'6988014','','10',10000.00,'257699','','','3235','Sokoto Station','6988014',0.00,'2022-07-22 15:07:13',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-22 16:44:52'),(400427,'5','175','2022-07-21',218,'6988014','','2',40400.00,'257699','','','','','',0.00,'2022-07-22 15:08:21',5,'Water Vendor #400\r\nGen AGO #40,000','597','','0000-00-00 00:00:00','664','2022-07-22 16:44:52'),(400428,'5','175','2022-07-22',218,'613761','','5',738340.00,'257700','','','4076','Sokoto Station','613761',828041.50,'2022-07-26 22:27:21',5,'Payment for the Sales of 22/07/2022','597','','0000-00-00 00:00:00','664','2022-07-26 22:37:12'),(400429,'5','175','2022-07-22',218,'613761','','10',57300.00,'257700','','','3235','Sokoto Station','613761',0.00,'2022-07-26 22:28:27',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-26 22:37:12'),(400430,'5','175','2022-07-22',218,'623761','','2',32400.00,'257700','','','','','',0.00,'2022-07-26 22:29:49',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-07-26 22:37:12'),(400431,'5','175','2022-07-22',218,'613761','','5',686835.00,'257701','','','4076','Sokoto Station','613761',777734.45,'2022-07-26 22:32:13',5,'Payment for the Sales of 23/07/2022','597','','0000-00-00 00:00:00','664','2022-07-26 22:37:12'),(400432,'5','175','2022-07-23',218,'613761','','5',687835.00,'257701','','','4076','Sokoto Station','613761',777734.45,'2022-07-26 22:35:07',5,'Payment for the Sales of 23/07/2022','597','','0000-00-00 00:00:00','664','2022-07-26 22:37:12'),(400433,'5','175','2022-07-23',218,'613761','','10',57300.00,'257701','','','3235','','613761',0.00,'2022-07-26 22:37:48',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400434,'5','175','2022-07-23',218,'613761','','2',32400.00,'257701','','','','','',0.00,'2022-07-26 22:38:41',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400435,'5','175','2022-07-24',218,'613761','','5',777645.00,'257702','','','4076','Sokoto Station','613761',810044.70,'2022-07-26 22:40:42',5,'Payment for the Sales of 24/07/2022','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400436,'5','175','2022-07-24',218,'613761','','2',32400.00,'257702','','','','','',0.00,'2022-07-26 22:41:57',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400437,'5','175','2022-07-25',218,'600553','','5',624425.00,'257703','','','4076','Sokoto Station','600553',656923.90,'2022-07-26 22:44:24',5,'Payment for the Sales of 25/07/2022','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400438,'5','175','2022-07-25',218,'600553','','2',32400.00,'257703','','','','','',0.00,'2022-07-26 22:45:37',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-07-27 06:02:07'),(400439,'5','175','2022-07-26',218,'380515','','5',535070.00,'257704','','','4076','Sokoto Station','380515',572469.55,'2022-07-27 14:22:25',5,'Payment for the Sales of 26/07/2022','597','','0000-00-00 00:00:00','664','2022-07-28 06:54:20'),(400440,'5','175','2022-07-26',218,'380515','','10',5000.00,'257704','','','3235','Sokoto Station','380515',0.00,'2022-07-27 14:23:30',5,'POS Payment','597','','0000-00-00 00:00:00','664','2022-07-28 06:54:20'),(400441,'5','175','2022-07-26',218,'380515','','2',32400.00,'257704','','','','','',0.00,'2022-07-27 14:24:19',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-07-28 06:54:20'),(400442,'5','175','2022-07-27',218,'810470','','5',710070.00,'257705','','','4076','Sokoto Station','810470',742471.60,'2022-08-02 12:30:18',5,'Payment for the Sales of 27/07/22','597','','0000-00-00 00:00:00','664','2022-09-05 10:41:08'),(400443,'5','175','2022-07-27',218,'810470','','2',32400.00,'257705','','','','','',0.00,'2022-08-02 12:31:17',5,'Water Vendor #400\r\nGen AGO #32,000','597','','0000-00-00 00:00:00','664','2022-09-05 10:41:08'),(400444,'5','175','2022-07-28',218,'810470','','5',249885.00,'257706','','','4076','Sokoto Station','810470',290187.30,'2022-08-02 12:33:03',5,'Payment for the Sales of 28/07/22','597','','0000-00-00 00:00:00','664','2022-09-05 10:41:08'),(400445,'5','175','2022-07-28',218,'810470','','2',40400.00,'257706','','','','','',0.00,'2022-08-02 12:35:23',5,'Water Vendor #400\r\nDust Removal #2000\r\nTransport to Kano Head Office by Godstime Mbakogu #6000\r\nGen AGO #32,400','597','','0000-00-00 00:00:00','664','2022-09-05 10:41:08'),(400446,'5','175','2022-08-12',218,'767582','','5',288640.00,'257722','','','4076','Sokoto Station','767582',309042.50,'2022-09-05 13:11:25',5,'Payment for the Sales of the 12/08/2022','597','','0000-00-00 00:00:00','664','2022-09-05 16:38:28'),(400447,'5','175','2022-08-12',218,'767582','','2',20400.00,'257722','','','','','',0.00,'2022-09-05 13:14:38',5,'Gen AGO #20,000\r\nWater Vendor #400\r\n','597','','0000-00-00 00:00:00','664','2022-09-05 16:38:28'),(400448,'5'