-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_174
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_174`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_174` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_174`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3539 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3172,4016,'',0,'20','5','174','SALES','','2021-02-22 18:41:14',5,0.00,0.00,'','596','2021-02-22 18:41:14','596',0,1),(3173,3018,'',0,'6.1','5','174','CASH','','2021-02-22 18:41:41',5,0.00,0.00,'','596','2021-02-22 18:41:41','596',0,1),(3174,4001,'',0,'22','5','174','PURCHASES','','2021-02-22 18:42:33',5,0.00,0.00,'','596','2021-02-22 18:42:33','596',0,1),(3175,30150,'',0,'24','5','174','SALARIES & WAGES','','2021-02-22 18:43:15',5,0.00,0.00,'','596','2021-02-22 18:43:15','596',0,1),(3176,30151,'',0,'24','5','174','PURCHASES','','2021-02-22 18:44:22',5,0.00,0.00,'','596','2021-02-22 18:44:22','596',0,1),(3230,4017,'',0,'2','5','174','ZENITH BANK-1011555093','','2021-03-06 01:20:34',5,0.00,0.00,'','600','2021-03-06 01:20:34','600',0,1),(3536,4051,'',0,'2','5','174','UBA-1024022423','','2021-08-12 15:36:16',5,0.00,0.00,'','600','2021-08-12 15:36:16','600',0,1),(3537,4052,'',0,'2','5','174','JA\'IZ-0010037957','','2022-03-02 19:10:36',5,0.00,0.00,'','600','2022-03-02 19:10:36','600',0,0),(3538,2000,'',0,'6','5','174','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:34:18',5,0.00,0.00,'','600','2023-02-06 10:34:18','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','174','0000-00-00','2023-02-07 15:26:06',10,'797','','0000-00-00 00:00:00','606','2023-02-08 16:16:47');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','174','1','3538','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  900ltrs ×35 = 31,500',31500.00,'2023-01-20'),(2,'5','174','1','216','supplier',31500.00,'Pms price increase from 185 to 220 on 20/1/2023  900 ×35 = 31,500',0.00,'2023-01-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18558 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','174',16779,'903',220.53,400.00,'2021-10-12','','2021-10-12 10:37:40','600','600',2021,'600','2021-10-12 10:37:40',5),('5','174',16877,'903',103.99,120.00,'2021-10-21','Sale out of my deastock: refer as overage','2021-10-21 17:34:10','596','596',2021,'596','2021-10-21 17:34:10',5),('5','174',17429,'901',431.66,1823.00,'2021-11-01','','2021-11-02 07:07:42','596','596',2021,'596','2021-11-02 07:07:42',5),('5','174',17441,'901',1199.63,1200.00,'2021-11-02','','2021-11-03 08:09:44','596','596',2021,'596','2021-11-03 08:09:44',5),('5','174',17461,'900',1508.69,1550.00,'2021-11-03','','2021-11-04 05:32:26','596','596',2021,'596','2021-11-04 05:32:26',5),('5','174',17543,'899',3957.63,4320.00,'2021-11-08','','2021-11-08 18:24:56','596','596',2021,'596','2021-11-08 18:24:56',5),('5','174',17607,'899',5351.72,5750.00,'2021-11-13','','2021-11-13 20:17:42','596','596',2021,'596','2021-11-13 20:17:42',5),('5','174',17769,'899',7805.51,8390.00,'2021-11-25','','2021-11-25 19:05:16','596','596',2021,'596','2021-11-25 19:05:16',5),('5','174',18382,'899',3721.85,3800.00,'2022-01-08','','2022-01-08 19:22:56','596','596',2022,'596','2022-01-08 19:22:56',5),('5','174',18448,'899',4385.00,4700.00,'2022-01-15','','2022-01-15 20:38:41','596','596',2022,'596','2022-01-15 20:38:41',5),('5','174',18512,'900',70.71,200.00,'2022-01-20','','2022-01-20 20:28:11','596','596',2022,'596','2022-01-20 20:28:11',5),('5','174',18551,'899',697.52,1200.00,'2022-01-24','','2022-01-24 22:03:31','596','596',2022,'596','2022-01-24 22:03:31',5),('5','174',18552,'900',5061.83,5110.00,'2022-02-07','','2022-02-07 20:33:04','596','596',2022,'596','2022-02-07 20:33:04',5),('5','174',18553,'899',3609.69,3900.00,'2022-03-02','','2022-03-02 22:31:46','596','596',2022,'596','2022-03-02 22:31:46',5),('5','174',18554,'899',2953.10,3100.00,'2022-03-06','','2022-03-06 20:32:45','596','596',2022,'596','2022-03-06 20:32:45',5),('5','174',18555,'899',633.61,1300.00,'2022-03-27','','2022-03-28 03:06:00','596','596',2022,'596','2022-03-28 03:06:00',5),('5','174',18556,'899',3021.03,18200.00,'2022-07-14','','2022-07-14 15:46:46','600','600',2022,'600','2022-07-14 15:46:46',5),('5','174',18557,'900',4962.70,7400.00,'2022-08-15','','2022-09-07 14:04:23','596','596',2022,'596','2022-09-07 14:04:23',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2683 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','174','899',2677,'5','PMS PUMP 2',1316565.98,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','174','899',2678,'5','PMS PUMP 3',1061391.98,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','174','900',2679,'5','PMS PUMP 4',1197692.24,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','174','901',2680,'5','PMS PUMP 1',726199.99,'TANKS CONTAINING PETROLEUM PRODUCT.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','174','902',2681,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','174','903',2682,'5','AGO PUMP',306298.01,'AGO DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257989 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','174',181489,'Daily shift','2021-02-27','2021-02-27 00:00:00',NULL,'596',0.00,278029439.33,'596','2021-02-27 16:54:24','596','2021-02-27 16:57:58',10,0),('5','174',181495,'Daily shift','2021-02-27','2021-02-27 00:00:00',NULL,'596',0.00,3745864.87,'596','2021-02-27 21:00:44','596','2021-02-27 21:13:08',10,0),('5','174',181576,'Daily shift','2021-02-28','2021-02-28 00:00:00',NULL,'596',0.00,2691193.43,'596','2021-02-28 18:36:38','596','2021-02-28 18:46:02',10,0),('5','174',181794,'Daily shift','2021-03-01','2021-03-01 00:00:00',NULL,'596',0.00,1235241.81,'596','2021-03-02 06:43:55','600','2021-03-02 10:15:49',10,0),('5','174',181991,'Daily shift','2021-03-02','2021-03-02 00:00:00',NULL,'596',0.00,314323.79,'596','2021-03-02 20:45:27','600','2021-03-03 08:49:05',10,0),('5','174',182148,'Daily shift','2021-03-03','2021-03-03 00:00:00',NULL,'596',0.00,302352.50,'596','2021-03-03 19:15:51','600','2021-03-04 10:53:14',10,0),('5','174',182388,'Daily shift','2021-03-04','2021-03-04 00:00:00',NULL,'596',0.00,630069.30,'596','2021-03-05 08:58:32','606','2021-03-05 09:00:59',10,0),('5','174',182531,'Daily shift','2021-03-05','2021-03-05 00:00:00',NULL,'596',2154504.89,2154504.89,'596','2021-03-05 21:33:35','606','2021-03-06 09:06:35',10,0),('5','174',182711,'Daily shift','2021-03-06','2021-03-06 00:00:00',NULL,'596',2074014.14,2074014.14,'596','2021-03-06 21:16:55','606','2021-03-07 13:51:45',10,0),('5','174',182915,'Daily shift','2021-03-07','2021-03-07 00:00:00',NULL,'596',2320806.94,2320806.94,'596','2021-03-07 20:58:24','606','2021-03-08 05:54:15',10,0),('5','174',183007,'Daily shift','2021-03-08','2021-03-08 00:00:00',NULL,'596',915674.31,915674.31,'596','2021-03-08 21:16:00','606','2021-03-09 04:31:00',10,0),('5','174',183227,'Daily shift','2021-03-09','2021-03-09 00:00:00',NULL,'596',126947.50,126947.50,'596','2021-03-09 21:18:24','606','2021-03-10 06:41:48',10,0),('5','174',183442,'Daily shift','2021-03-10','2021-03-10 00:00:00',NULL,'596',77085.00,81710.10,'596','2021-03-10 21:38:42','606','2021-03-11 07:17:20',10,0),('5','174',183675,'Daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'596',137522.50,145773.85,'596','2021-03-11 20:32:52','606','2021-03-12 08:44:49',10,0),('5','174',183942,'Daily shift','2021-03-12','2021-03-12 00:00:00',NULL,'596',1829442.09,1838061.99,'596','2021-03-13 06:18:56','606','2021-03-13 10:07:08',10,0),('5','174',184106,'Daily shift','2021-03-13','2021-03-13 00:00:00',NULL,'596',3236728.39,3251594.64,'596','2021-03-13 20:21:56','606','2021-03-14 08:09:27',10,0),('5','174',184308,'Daily shift','2021-03-14','2021-03-14 00:00:00',NULL,'596',2068406.16,2077407.96,'596','2021-03-15 06:13:14','606','2021-03-15 10:41:24',10,0),('5','174',184564,'Daily shift','2021-03-15','2021-03-15 00:00:00',NULL,'596',1839998.10,1854952.15,'596','2021-03-17 09:43:59','606','2021-03-17 09:45:08',10,0),('5','174',184940,'Daily shift','2021-03-16','2021-03-16 00:00:00',NULL,'596',707010.00,721150.20,'596','2021-03-17 09:47:42','606','2021-03-17 09:48:48',10,0),('5','174',184942,'Daily shift','2021-03-17','2021-03-17 00:00:00',NULL,'596',1741618.18,1779910.93,'596','2021-03-17 20:37:49','606','2021-03-18 06:57:50',10,0),('5','174',185141,'Daily shift','2021-03-18','2021-03-18 00:00:00',NULL,'596',1637124.50,1673478.80,'596','2021-03-18 21:53:56','606','2021-03-19 07:04:46',10,0),('5','174',185291,'Daily shift','2021-03-19','2021-03-19 00:00:00',NULL,'596',2043778.47,2094178.02,'596','2021-03-19 21:09:07','606','2021-03-20 08:26:37',10,0),('5','174',185510,'Daily shift','2021-03-20','2021-03-20 00:00:00',NULL,'596',2111623.01,2151613.16,'596','2021-03-21 07:32:44','606','2021-03-21 14:19:26',10,0),('5','174',185794,'Daily shift','2021-03-21','2021-03-21 00:00:00',NULL,'596',1936936.38,1961017.53,'596','2021-03-21 20:35:42','606','2021-03-21 20:43:56',10,0),('5','174',185887,'Daily shift','2021-03-22','2021-03-22 00:00:00',NULL,'596',1926528.01,1939006.51,'596','2021-03-22 21:40:52','606','2021-03-23 06:21:50',10,0),('5','174',186108,'Daily shift','2021-03-23','2021-03-23 00:00:00',NULL,'596',1263689.10,1267865.10,'596','2021-03-23 21:27:05','606','2021-03-24 05:31:03',10,0),('5','174',186334,'Daily shift','2021-03-24','2021-03-24 00:00:00',NULL,'596',1128808.31,1134640.46,'596','2021-03-24 21:17:00','606','2021-03-25 05:30:47',10,0),('5','174',186554,'Daily shift','2021-03-25','2021-03-25 00:00:00',NULL,'596',1381310.90,1381310.90,'596','2021-03-25 20:48:16','606','2021-03-26 05:39:03',10,0),('5','174',186765,'Daily shift','2021-03-26','2021-03-26 00:00:00',NULL,'596',1287537.00,1287537.00,'596','2021-03-26 21:09:44','606','2021-03-27 06:16:13',10,0),('5','174',187040,'Daily shift','2021-03-27','2021-03-27 00:00:00',NULL,'596',1320930.81,1320930.81,'596','2021-03-27 20:30:27','606','2021-03-28 05:36:05',10,0),('5','174',187196,'Daily shift','2021-03-28','2021-03-28 00:00:00',NULL,'596',1218561.92,1218561.92,'596','2021-03-28 21:07:09','606','2021-03-29 06:32:23',10,0),('5','174',187371,'Daily shift','2021-03-29','2021-03-29 00:00:00',NULL,'596',1918581.72,1918581.72,'596','2021-03-29 20:44:51','606','2021-03-30 07:08:09',10,0),('5','174',187642,'Delliy','2021-03-30','2021-03-30 00:00:00',NULL,'596',1469229.84,1469229.84,'596','2021-03-30 21:30:22','606','2021-03-31 04:09:16',10,0),('5','174',187827,'Daily shift','2021-03-31','2021-03-31 00:00:00',NULL,'596',1307453.97,1307453.97,'596','2021-04-01 06:56:11','606','2021-04-01 06:57:28',10,0),('5','174',188024,'Daily shift','2021-04-01','2021-04-01 00:00:00',NULL,'596',1384647.51,1384647.51,'596','2021-04-01 21:13:46','606','2021-04-02 05:19:54',10,0),('5','174',188203,'Daily','2021-04-02','2021-04-02 00:00:00',NULL,'596',1163634.18,1163634.18,'596','2021-04-02 20:18:27','606','2021-04-02 22:41:05',10,0),('5','174',188414,'Daily shift','2021-04-03','2021-04-03 00:00:00',NULL,'596',1296572.09,1296572.09,'596','2021-04-03 20:22:16','606','2021-04-04 05:27:43',10,0),('5','174',188601,'Daily shift','2021-04-04','2021-04-04 00:00:00',NULL,'596',1153104.38,1153104.38,'596','2021-04-05 07:30:26','606','2021-04-05 08:27:41',10,0),('5','174',188859,'Daily shift','2021-04-05','2021-04-05 00:00:00',NULL,'596',1620414.90,1634711.90,'596','2021-04-05 20:46:12','606','2021-04-05 21:53:26',10,0),('5','174',189041,'Daily shift','2021-04-06','2021-04-06 00:00:00',NULL,'596',1623566.78,1623566.78,'596','2021-04-06 20:57:06','606','2021-04-07 03:03:44',10,0),('5','174',189205,'Daily shift','2021-04-07','2021-04-07 00:00:00',NULL,'596',1830556.21,1830556.21,'596','2021-04-07 20:39:43','606','2021-04-07 21:23:01',10,0),('5','174',189420,'Daily shift','2021-04-08','2021-04-08 00:00:00',NULL,'596',1507893.87,260513.55,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',189660,'Daily shift','2021-04-08','2021-04-08 00:00:00',NULL,'596',1507893.87,1507893.87,'596','2021-04-09 08:45:25','606','2021-04-09 08:50:56',10,0),('5','174',189667,'Daily shift','2021-04-09','2021-04-09 00:00:00',NULL,'596',682570.04,682570.04,'596','2021-04-09 21:36:08','606','2021-04-10 05:48:12',10,0),('5','174',190011,'Daily  shift ','2021-04-10','2021-04-10 00:00:00',NULL,'596',2417400.51,2417400.51,'596','2021-04-10 21:18:39','606','2021-04-11 05:34:18',10,0),('5','174',190026,'Daily  shift ','2021-04-11','2021-04-11 00:00:00',NULL,'596',1533791.94,1533791.94,'596','2021-04-11 20:43:03','606','2021-04-12 05:15:08',10,0),('5','174',190217,'Daily  shift ','2021-04-12','2021-04-12 00:00:00',NULL,'596',1909002.94,1909002.94,'596','2021-04-12 20:49:42','606','2021-04-13 05:46:01',10,0),('5','174',190462,'Daily  shift ','2021-04-13','2021-04-13 00:00:00',NULL,'596',203209.95,203209.95,'596','2021-04-13 22:16:53','606','2021-04-14 02:45:58',10,0),('5','174',190659,'Daily  shift ','2021-04-14','2021-04-14 00:00:00',NULL,'596',1396185.70,1396185.70,'596','2021-04-14 20:27:20','606','2021-04-15 06:51:07',10,0),('5','174',190898,'Daily  shift ','2021-04-15','2021-04-15 00:00:00',NULL,'596',2137530.15,2137530.15,'596','2021-04-15 20:17:54','606','2021-04-16 05:08:32',10,0),('5','174',191124,'Daily  shift ','2021-04-16','2021-04-16 00:00:00',NULL,'596',1922487.10,1922487.10,'596','2021-04-17 10:41:25','606','2021-04-17 10:54:26',10,0),('5','174',191365,'Daily  shift ','2021-04-17','2021-04-17 00:00:00',NULL,'596',1318080.90,1318080.90,'596','2021-04-17 21:30:48','606','2021-04-18 04:44:56',10,0),('5','174',191519,'Daily  shift ','2021-04-18','2021-04-18 00:00:00',NULL,'596',1290145.35,1290145.35,'596','2021-04-18 21:12:45','606','2021-04-19 03:46:51',10,0),('5','174',191728,'Daily  shift ','2021-04-19','2021-04-19 00:00:00',NULL,'596',1458808.95,1458808.95,'596','2021-04-19 22:04:16','606','2021-04-20 05:16:40',10,0),('5','174',191962,'Daily  shift ','2021-04-20','2021-04-20 00:00:00',NULL,'596',1078829.35,1078829.35,'596','2021-04-21 00:54:35','606','2021-04-21 05:35:30',10,0),('5','174',192138,'Daily  shift ','2021-04-21','2021-04-21 00:00:00',NULL,'596',291892.20,291892.20,'596','2021-04-21 20:21:50','606','2021-04-22 04:02:06',10,0),('5','174',192427,'Daily  shift ','2021-04-22','2021-04-22 00:00:00',NULL,'596',347605.80,347605.80,'596','2021-04-22 21:06:55','606','2021-04-23 05:26:44',10,0),('5','174',192570,'Daily shift','2021-04-23','2021-04-23 00:00:00',NULL,'596',1234777.65,1234777.65,'596','2021-04-23 21:38:56','606','2021-04-24 07:22:45',10,0),('5','174',192774,'Daily shift','2021-04-24','2021-04-24 00:00:00',NULL,'596',1181635.25,1181635.25,'596','2021-04-24 21:36:15','606','2021-04-25 06:17:50',10,0),('5','174',192967,'Daily shift','2021-04-25','2021-04-25 00:00:00',NULL,'596',1057494.35,1057494.35,'596','2021-04-26 07:20:27','606','2021-04-26 07:33:35',10,0),('5','174',193193,'Daily shift','2021-04-26','2021-04-26 00:00:00',NULL,'596',1636918.40,1636918.40,'596','2021-04-26 20:51:39','606','2021-04-27 05:31:37',10,0),('5','174',193419,'Daily shift','2021-04-27','2021-04-27 00:00:00',NULL,'596',997464.40,997464.40,'596','2021-04-27 21:04:29','606','2021-04-28 05:37:49',10,0),('5','174',193651,'Daily  shift ','2021-04-28','2021-04-28 00:00:00',NULL,'596',1088443.15,1088443.15,'596','2021-04-28 21:44:36','606','2021-04-29 08:18:57',10,0),('5','174',193890,'Daily shift','2021-04-29','2021-04-29 00:00:00',NULL,'596',846272.85,846272.85,'596','2021-04-29 21:11:24','606','2021-04-29 23:31:51',10,0),('5','174',194097,'Daily shift','2021-04-30','2021-04-30 00:00:00',NULL,'596',1275954.85,1275954.85,'596','2021-04-30 20:45:10','606','2021-05-01 06:18:22',10,0),('5','174',194347,'Daily shift','2021-05-01','2021-05-01 00:00:00',NULL,'596',731424.00,731424.00,'596','2021-05-01 22:06:03','606','2021-05-02 07:05:53',10,0),('5','174',194526,'Daily shift','2021-05-02','2021-05-02 00:00:00',NULL,'596',148050.20,148050.20,'596','2021-05-02 21:06:53','606','2021-05-02 23:42:23',10,0),('5','174',194692,'Daily shift','2021-05-03','2021-05-03 00:00:00',NULL,'596',1552584.20,1552584.20,'596','2021-05-04 12:26:35','606','2021-05-04 12:29:53',10,0),('5','174',194943,'Daily shift','2021-05-04','2021-05-04 00:00:00',NULL,'596',992492.25,992492.25,'596','2021-05-04 20:41:29','606','2021-05-05 05:28:13',10,0),('5','174',195116,'Daily shift','2021-05-05','2021-05-05 00:00:00',NULL,'596',856015.05,856015.05,'596','2021-05-05 21:09:38','606','2021-05-06 04:54:41',10,0),('5','174',195325,'Daily shift','2021-05-06','2021-05-06 00:00:00',NULL,'596',826054.35,826054.35,'596','2021-05-06 20:21:27','606','2021-05-06 21:56:37',10,0),('5','174',195561,'Daily shift','2021-05-07','2021-05-07 00:00:00',NULL,'596',1147012.35,1147012.35,'596','2021-05-07 21:07:39','606','2021-05-08 06:17:22',10,0),('5','174',195841,'Daily shift','2021-05-08','2021-05-08 00:00:00',NULL,'596',965637.75,965637.75,'596','2021-05-08 20:52:24','606','2021-05-09 05:27:01',10,0),('5','174',196047,'Daily  shift ','2021-05-09','2021-05-09 00:00:00',NULL,'596',611344.80,611344.80,'596','2021-05-09 20:23:37','606','2021-05-10 05:42:59',10,0),('5','174',196229,'Daily shift','2021-05-10','2021-05-10 00:00:00',NULL,'596',808854.75,808854.75,'596','2021-05-10 20:33:22','606','2021-05-11 04:17:20',10,0),('5','174',196635,'Daily  shift ','2021-05-11','2021-05-11 00:00:00',NULL,'596',134311.65,134311.65,'596','2021-05-11 20:50:50','606','2021-05-12 09:40:15',10,0),('5','174',196876,'Daily shift','2021-05-13','2021-05-13 00:00:00',NULL,'596',578961.90,578961.90,'596','2021-05-13 21:22:03','606','2021-05-14 06:15:58',10,0),('5','174',197037,'Daily  shift ','2021-05-14','2021-05-14 00:00:00',NULL,'596',626212.95,626212.95,'596','2021-05-14 23:53:11','606','2021-05-16 17:19:39',10,0),('5','174',197572,'Daily shift ','2021-05-17','2021-05-17 00:00:00',NULL,'596',982798.75,982798.75,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',197764,'Daily  shift ','2021-05-15','2021-05-15 00:00:00',NULL,'596',982798.75,982798.75,'596','2021-05-17 16:04:23','606','2021-05-17 16:06:02',10,0),('5','174',197782,'Daily  shift ','2021-05-17','2021-05-17 00:00:00',NULL,'596',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',197786,'Daily shift ','2021-05-16','2021-05-16 00:00:00',NULL,'596',598778.20,598778.20,'596','2021-05-17 16:16:01','606','2021-05-17 16:19:38',10,0),('5','174',197815,'Daily shift ','2021-05-17','2021-05-17 00:00:00',NULL,'596',104818.10,104818.10,'596','2021-05-17 20:23:53','606','2021-05-18 06:22:37',10,0),('5','174',197898,'Daily shift ','2021-05-18','2021-05-18 00:00:00',NULL,'596',168402.20,168402.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',198142,'Daily shift ','2021-05-18','2021-05-18 00:00:00',NULL,'596',168402.20,171579.60,'596','2021-05-19 07:48:21','606','2021-05-19 08:55:01',10,0),('5','174',198175,'Daily  shift ','2021-05-19','2021-05-19 00:00:00',NULL,'596',1057757.75,1060476.15,'596','2021-05-19 20:23:47','606','2021-05-20 04:51:12',10,0),('5','174',198458,'Daily shift ','2021-05-20','2021-05-20 00:00:00',NULL,'596',863935.90,866812.80,'596','2021-05-20 21:30:07','606','2021-05-21 05:08:58',10,0),('5','174',198571,'Daily shift ','2021-05-21','2021-05-21 00:00:00',NULL,'596',938459.25,938459.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',198816,'Daily shift ','2021-05-21','2021-05-21 00:00:00',NULL,'596',943042.80,943042.80,'596','2021-05-22 08:28:22','606','2021-05-22 08:35:42',10,0),('5','174',198820,'Daily shift ','2021-05-22','2021-05-22 00:00:00',NULL,'596',944316.15,944316.15,'596','2021-05-23 02:44:13','606','2021-05-23 05:20:21',10,0),('5','174',199014,'Daily shift ','2021-05-23','2021-05-23 00:00:00',NULL,'596',883385.55,883385.55,'596','2021-05-23 20:42:07','606','2021-05-24 04:43:18',10,0),('5','174',199209,'Daily shift ','2021-05-24','2021-05-24 00:00:00',NULL,'596',1129734.45,1129734.45,'596','2021-05-24 20:58:27','606','2021-05-25 05:04:56',10,0),('5','174',199439,'Daily shift ','2021-05-25','2021-05-25 00:00:00',NULL,'596',906521.25,906521.25,'596','2021-05-25 21:22:52','606','2021-05-26 04:49:35',10,0),('5','174',199663,'Daily shift ','2021-05-26','2021-05-26 00:00:00',NULL,'596',933392.40,933392.40,'596','2021-05-26 21:01:06','606','2021-05-27 05:11:14',10,0),('5','174',199874,'Daily shift ','2021-05-27','2021-05-27 00:00:00',NULL,'596',948525.00,948525.00,'596','2021-05-27 20:50:10','606','2021-05-28 05:37:45',10,0),('5','174',200101,'Daily shift ','2021-05-28','2021-05-28 00:00:00',NULL,'596',1231774.35,1231774.35,'596','2021-05-28 20:54:02','606','2021-05-29 06:31:24',10,0),('5','174',200312,'Daily shift ','2021-05-29','2021-05-29 00:00:00',NULL,'596',960066.60,960066.60,'596','2021-05-29 21:13:42','606','2021-05-30 04:39:31',10,0),('5','174',200525,'Daily shift ','2021-05-30','2021-05-30 00:00:00',NULL,'596',895000.95,895000.95,'596','2021-05-30 21:13:15','606','2021-05-31 05:17:53',10,0),('5','174',200759,'Daily shift ','2021-05-31','2021-05-31 00:00:00',NULL,'596',1025843.55,1025843.55,'596','2021-05-31 20:31:46','606','2021-06-01 05:14:04',10,0),('5','174',200923,'Daily shift ','2021-06-01','2021-06-01 00:00:00',NULL,'596',633939.90,633939.90,'596','2021-06-01 21:19:15','606','2021-06-02 05:26:12',10,0),('5','174',201118,'Daily shift ','2021-06-02','2021-06-02 00:00:00',NULL,'596',789033.30,789033.30,'596','2021-06-02 21:10:12','606','2021-06-03 05:20:26',10,0),('5','174',201314,'Daily shift ','2021-06-03','2021-06-03 00:00:00',NULL,'596',1016953.95,1016953.95,'596','2021-06-04 05:41:07','606','2021-06-04 05:43:58',10,0),('5','174',201493,'Daily shift ','2021-06-04','2021-06-04 00:00:00',NULL,'596',1145880.45,1145880.45,'596','2021-06-04 21:01:28','606','2021-06-05 05:41:17',10,0),('5','174',201802,'Daily shift ','2021-06-05','2021-06-05 00:00:00',NULL,'596',863675.10,867741.60,'596','2021-06-05 21:19:07','606','2021-06-05 22:35:32',10,0),('5','174',202028,'Daily shift ','2021-06-06','2021-06-06 00:00:00',NULL,'596',880278.45,884555.10,'596','2021-06-06 21:05:48','606','2021-06-07 05:15:17',10,0),('5','174',202233,'Daily shift ','2021-06-07','2021-06-07 00:00:00',NULL,'596',866250.30,868678.80,'596','2021-06-07 20:36:10','606','2021-06-08 05:23:53',10,0),('5','174',202434,'Daily shift ','2021-06-08','2021-06-08 00:00:00',NULL,'596',943391.35,943391.35,'596','2021-06-08 20:39:07','606','2021-06-09 01:03:37',10,0),('5','174',202646,'Daily shift ','2021-06-09','2021-06-09 00:00:00',NULL,'596',776910.75,776910.75,'596','2021-06-09 20:53:44','606','2021-06-10 05:48:46',10,0),('5','174',202864,'Daily shift ','2021-06-10','2021-06-10 00:00:00',NULL,'596',900211.40,900211.40,'596','2021-06-10 21:24:51','606','2021-06-11 05:50:38',10,0),('5','174',203108,'Daily shift ','2021-06-11','2021-06-11 00:00:00',NULL,'596',759610.50,759610.50,'596','2021-06-11 21:20:21','606','2021-06-12 04:45:00',10,0),('5','174',203303,'Daily shift ','2021-06-12','2021-06-12 00:00:00',NULL,'596',1002010.90,1002010.90,'596','2021-06-12 20:49:35','606','2021-06-13 05:06:24',10,0),('5','174',203529,'Daily shift ','2021-06-13','2021-06-13 00:00:00',NULL,'596',821927.70,821927.70,'596','2021-06-13 20:51:54','606','2021-06-14 06:18:07',10,0),('5','174',203740,'Daily shift ','2021-06-14','2021-06-14 00:00:00',NULL,'596',1023924.55,1023924.55,'596','2021-06-14 22:02:31','606','2021-06-15 05:04:34',10,0),('5','174',203964,'Daily shift ','2021-06-15','2021-06-15 00:00:00',NULL,'596',870922.25,870922.25,'596','2021-06-15 20:44:10','606','2021-06-16 05:47:20',10,0),('5','174',204184,'Daily shift ','2021-06-16','2021-06-16 00:00:00',NULL,'596',1508846.90,1508846.90,'596','2021-06-16 21:36:38','606','2021-06-17 06:10:01',10,0),('5','174',204399,'Daily shift ','2021-06-17','2021-06-17 00:00:00',NULL,'596',1180962.75,1180962.75,'596','2021-06-17 21:05:02','606','2021-06-18 05:44:10',10,0),('5','174',204627,'Daily shift ','2021-06-18','2021-06-18 00:00:00',NULL,'596',1047905.10,1047905.10,'596','2021-06-18 21:03:11','606','2021-06-19 06:06:04',10,0),('5','174',204844,'Daily shift ','2021-06-19','2021-06-19 00:00:00',NULL,'596',979628.10,979628.10,'596','2021-06-19 21:06:08','606','2021-06-20 08:38:07',10,0),('5','174',205080,'Daily shift ','2021-06-20','2021-06-20 00:00:00',NULL,'596',655673.70,655673.70,'596','2021-06-20 21:02:10','606','2021-06-21 05:27:32',10,0),('5','174',205236,'Daily shift ','2021-06-21','2021-06-21 00:00:00',NULL,'596',868843.80,868843.80,'596','2021-06-21 21:12:09','606','2021-06-22 05:14:26',10,0),('5','174',205503,'Daily shift ','2021-06-22','2021-06-22 00:00:00',NULL,'596',597374.25,597374.25,'596','2021-06-22 20:43:33','606','2021-06-23 06:58:26',10,0),('5','174',205741,'Daily shift ','2021-06-23','2021-06-23 00:00:00',NULL,'596',746420.40,746420.40,'596','2021-06-23 20:41:05','606','2021-06-24 07:01:47',10,0),('5','174',205960,'Daily shift ','2021-06-24','2021-06-24 00:00:00',NULL,'596',683169.30,683169.30,'596','2021-06-24 20:49:05','606','2021-06-25 05:16:00',10,0),('5','174',206166,'Daily shift ','2021-06-25','2021-06-25 00:00:00',NULL,'596',852132.60,852132.60,'596','2021-06-25 21:13:39','606','2021-06-26 06:58:34',10,0),('5','174',206373,'Daily shift ','2021-06-26','2021-06-26 00:00:00',NULL,'596',756899.55,756899.55,'596','2021-06-26 21:00:47','606','2021-06-27 05:46:28',10,0),('5','174',206586,'Daily shift ','2021-06-27','2021-06-27 00:00:00',NULL,'596',716177.55,716177.55,'596','2021-06-27 21:28:00','606','2021-06-28 05:37:33',10,0),('5','174',206818,'Daily shift ','2021-06-28','2021-06-28 00:00:00',NULL,'596',879520.95,879520.95,'596','2021-06-28 20:50:34','606','2021-06-29 05:46:50',10,0),('5','174',207038,'Daily shift ','2021-06-29','2021-06-29 00:00:00',NULL,'596',790759.20,790759.20,'596','2021-06-29 21:17:20','606','2021-06-30 05:34:55',10,0),('5','174',207267,'Daily shift ','2021-06-30','2021-06-30 00:00:00',NULL,'596',756587.70,756587.70,'596','2021-06-30 20:50:23','606','2021-07-01 05:41:36',10,0),('5','174',207491,'Daily shift ','2021-07-01','2021-07-01 00:00:00',NULL,'596',813692.55,813692.55,'596','2021-07-01 21:41:04','606','2021-07-02 05:36:47',10,0),('5','174',207698,'Daily shift ','2021-07-02','2021-07-02 00:00:00',NULL,'596',1180708.65,1180708.65,'596','2021-07-02 20:54:40','606','2021-07-03 06:26:24',10,0),('5','174',207910,'Daily shift ','2021-07-03','2021-07-03 00:00:00',NULL,'596',668518.95,668518.95,'596','2021-07-03 20:47:06','606','2021-07-04 05:42:22',10,0),('5','174',208107,'Daily shift ','2021-07-04','2021-07-04 00:00:00',NULL,'596',676542.90,676542.90,'596','2021-07-04 21:18:20','606','2021-07-05 05:19:21',10,0),('5','174',208330,'Daily shift ','2021-07-05','2021-07-05 00:00:00',NULL,'596',772889.70,772889.70,'596','2021-07-05 20:34:35','606','2021-07-06 07:03:07',10,0),('5','174',208652,'Daily shift ','2021-07-06','2021-07-06 00:00:00',NULL,'596',712323.15,712323.15,'596','2021-07-06 20:45:14','606','2021-07-07 05:56:44',10,0),('5','174',208777,'Daily shift ','2021-07-07','2021-07-07 00:00:00',NULL,'596',673206.60,673206.60,'596','2021-07-07 21:20:42','606','2021-07-08 07:36:24',10,0),('5','174',209022,'Daily shift ','2021-07-08','2021-07-08 00:00:00',NULL,'596',730030.95,730030.95,'596','2021-07-08 22:49:20','606','2021-07-09 06:17:41',10,0),('5','174',209215,'Daily shift ','2021-07-09','2021-07-09 00:00:00',NULL,'596',743810.10,743810.10,'596','2021-07-09 20:42:28','606','2021-07-10 06:33:34',10,0),('5','174',209448,'Daily shift ','2021-07-10','2021-07-10 00:00:00',NULL,'596',695275.35,695275.35,'596','2021-07-10 23:09:39','606','2021-07-11 05:45:14',10,0),('5','174',209661,'Daily shift ','2021-07-11','2021-07-11 00:00:00',NULL,'596',680042.55,680042.55,'596','2021-07-11 20:42:57','606','2021-07-12 06:20:07',10,0),('5','174',209883,'Daily shift ','2021-07-12','2021-07-12 00:00:00',NULL,'596',797897.10,797897.10,'596','2021-07-12 21:12:29','606','2021-07-13 04:27:27',10,0),('5','174',210097,'Daily shift ','2021-07-13','2021-07-13 00:00:00',NULL,'596',525496.95,525496.95,'596','2021-07-13 21:11:14','606','2021-07-14 06:21:29',10,0),('5','174',210480,'Daily shift ','2021-07-14','2021-07-14 00:00:00',NULL,'596',79912.80,79912.80,'596','2021-07-14 20:42:28','606','2021-07-15 06:11:59',10,0),('5','174',210529,'Daily shift ','2021-07-15','2021-07-15 00:00:00',NULL,'596',723813.75,723813.75,'596','2021-07-15 20:45:06','606','2021-07-16 05:37:50',10,0),('5','174',210767,'Daily shift ','2021-07-16','2021-07-16 00:00:00',NULL,'596',847111.65,847111.65,'596','2021-07-16 21:34:17','606','2021-07-17 06:04:55',10,0),('5','174',210980,'Daily shift ','2021-07-17','2021-07-17 00:00:00',NULL,'596',737380.05,737380.05,'596','2021-07-17 21:36:38','606','2021-07-18 06:09:06',10,0),('5','174',211169,'Daily shift ','2021-07-18','2021-07-18 00:00:00',NULL,'596',957712.80,957712.80,'596','2021-07-18 20:58:42','606','2021-07-19 06:33:53',10,0),('5','174',211388,'Daily shift ','2021-07-19','2021-07-19 00:00:00',NULL,'596',1110796.50,1110796.50,'596','2021-07-19 21:50:04','606','2021-07-20 05:47:06',10,0),('5','174',211604,'Daily shift','2021-07-20','2021-07-20 00:00:00',NULL,'596',586297.80,586297.80,'596','2021-07-20 21:27:35','606','2021-07-21 06:22:02',10,0),('5','174',211838,'Daily shift','2021-07-21','2021-07-21 00:00:00',NULL,'596',658211.40,658211.40,'596','2021-07-21 21:59:51','606','2021-07-22 06:24:10',10,0),('5','174',212144,'Daily shift','2021-07-22','2021-07-22 00:00:00',NULL,'596',457700.10,457700.10,'596','2021-07-23 06:41:07','606','2021-07-23 07:13:22',10,0),('5','174',212265,'Daily shift','2021-07-23','2021-07-23 00:00:00',NULL,'596',718650.90,718650.90,'596','2021-07-23 22:22:18','606','2021-07-24 04:42:07',10,0),('5','174',212466,'Daily shift','2021-07-24','2021-07-24 00:00:00',NULL,'596',712392.45,712392.45,'596','2021-07-24 21:52:34','606','2021-07-25 05:25:57',10,0),('5','174',212675,'Daily shift','2021-07-25','2021-07-25 00:00:00',NULL,'596',638312.40,638312.40,'596','2021-07-25 21:04:22','606','2021-07-26 05:42:28',10,0),('5','174',212884,'Daily shift','2021-07-26','2021-07-26 00:00:00',NULL,'596',468534.00,468534.00,'596','2021-07-26 20:58:36','606','2021-07-27 05:55:15',10,0),('5','174',213135,'Daily shift','2021-07-27','2021-07-27 00:00:00',NULL,'596',592698.15,592698.15,'596','2021-07-27 21:24:21','606','2021-07-28 01:55:10',10,0),('5','174',213432,'Daily shift','2021-07-28','2021-07-28 00:00:00',NULL,'596',623978.85,623978.85,'596','2021-07-29 05:47:46','606','2021-07-29 14:01:45',10,0),('5','174',213776,'Daily shift ','2021-07-29','2021-07-29 00:00:00',NULL,'596',696234.00,696234.00,'596','2021-07-29 21:40:27','606','2021-07-30 07:07:42',10,0),('5','174',213915,'Daily shift ','2021-07-30','2021-07-30 00:00:00',NULL,'596',641828.55,641828.55,'596','2021-07-30 21:12:23','606','2021-07-31 08:48:13',10,0),('5','174',214148,'Daily shift','2021-07-31','2021-07-31 00:00:00',NULL,'596',602840.70,602840.70,'596','2021-07-31 21:52:59','606','2021-08-01 05:18:32',10,0),('5','174',214352,'Daily shift','2021-08-01','2021-08-01 00:00:00',NULL,'596',596547.60,596547.60,'596','2021-08-01 21:41:32','606','2021-08-02 05:31:25',10,0),('5','174',214587,'Daily shift','2021-08-02','2021-08-02 00:00:00',NULL,'596',350877.45,350877.45,'596','2021-08-02 20:59:19','606','2021-08-03 04:31:37',10,0),('5','174',214792,'Daily shift','2021-08-03','2021-08-03 00:00:00',NULL,'596',667776.45,667776.45,'596','2021-08-03 21:10:42','606','2021-08-04 05:53:10',10,0),('5','174',215073,'Daily shift','2021-08-04','2021-08-04 00:00:00',NULL,'596',645118.65,645118.65,'596','2021-08-04 21:02:23','606','2021-08-05 05:28:46',10,0),('5','174',215285,'Daily shift','2021-08-05','2021-08-05 00:00:00',NULL,'596',595343.10,595343.10,'596','2021-08-05 21:00:28','606','2021-08-06 01:15:54',10,0),('5','174',215445,'Daily shift','2021-08-06','2021-08-06 00:00:00',NULL,'596',924403.65,924403.65,'596','2021-08-07 10:20:23','606','2021-08-07 10:24:36',10,0),('5','174',215742,'Daily shift','2021-08-07','2021-08-07 00:00:00',NULL,'596',674114.45,674114.45,'596','2021-08-07 21:07:24','606','2021-08-08 03:36:34',10,0),('5','174',215932,'Daily shift','2021-08-08','2021-08-08 00:00:00',NULL,'596',412427.70,412427.70,'596','2021-08-08 21:07:31','606','2021-08-09 06:21:14',10,0),('5','174',216115,'Daily shift','2021-08-09','2021-08-09 00:00:00',NULL,'596',640983.85,640983.85,'596','2021-08-09 21:30:31','606','2021-08-10 05:38:13',10,0),('5','174',216367,'Daily shift','2021-08-10','2021-08-10 00:00:00',NULL,'596',668118.95,668118.95,'596','2021-08-11 06:33:16','606','2021-08-11 07:24:41',10,0),('5','174',216578,'Daily shift ','2021-08-11','2021-08-11 00:00:00',NULL,'596',680948.35,680948.35,'596','2021-08-11 21:19:43','606','2021-08-12 05:36:22',10,0),('5','174',216797,'Daily shift ','2021-08-12','2021-08-12 00:00:00',NULL,'596',663984.15,663984.15,'596','2021-08-12 21:10:24','606','2021-08-13 05:42:18',10,0),('5','174',217024,'Daily shift ','2021-08-13','2021-08-13 00:00:00',NULL,'596',604851.20,604851.20,'596','2021-08-13 21:07:57','606','2021-08-14 05:41:56',10,0),('5','174',217298,'Daily shift ','2021-08-14','2021-08-14 00:00:00',NULL,'596',671873.55,671873.55,'596','2021-08-14 21:03:59','606','2021-08-15 18:54:16',10,0),('5','174',217653,'Daily shift ','2021-08-15','2021-08-15 00:00:00',NULL,'596',720588.00,720588.00,'596','2021-08-16 10:04:02','606','2021-08-16 10:56:40',10,0),('5','174',217829,'DAILY SHIFT ','2021-08-16','2021-08-16 00:00:00',NULL,'596',720898.35,720898.35,'596','2021-08-16 20:39:23','606','2021-08-17 05:47:22',10,0),('5','174',218040,'Daily shift ','2021-08-17','2021-08-17 00:00:00',NULL,'596',795041.45,795041.45,'596','2021-08-17 21:00:37','606','2021-08-18 00:54:35',10,0),('5','174',218241,'Daily shift ','2021-08-18','2021-08-18 00:00:00',NULL,'596',674481.50,674481.50,'596','2021-08-18 20:30:31','606','2021-08-19 05:49:43',10,0),('5','174',218517,'Daily shift ','2021-08-19','2021-08-19 00:00:00',NULL,'596',919708.10,919708.10,'596','2021-08-19 21:09:40','606','2021-08-20 10:06:01',10,0),('5','174',218761,'Daily  shift ','2021-08-20','2021-08-20 00:00:00',NULL,'596',672563.95,672563.95,'596','2021-08-20 21:06:05','606','2021-08-21 06:18:04',10,0),('5','174',219097,'Daily shift ','2021-08-21','2021-08-21 00:00:00',NULL,'596',633359.65,633359.65,'596','2021-08-21 21:01:44','606','2021-08-22 06:03:25',10,0),('5','174',219155,'Daily shift ','2021-08-22','2021-08-22 00:00:00',NULL,'596',536976.70,536976.70,'596','2021-08-22 20:31:55','606','2021-08-23 05:48:17',10,0),('5','174',219359,'Daily shift ','2021-08-23','2021-08-23 00:00:00',NULL,'596',1164225.25,1164225.25,'596','2021-08-23 21:28:53','606','2021-08-24 05:41:02',10,0),('5','174',219631,'Daily shift ','2021-08-24','2021-08-24 00:00:00',NULL,'596',548872.70,548872.70,'596','2021-08-24 21:23:27','606','2021-08-25 05:41:02',10,0),('5','174',219839,'Daily shift ','2021-08-25','2021-08-25 00:00:00',NULL,'596',623139.30,623139.30,'596','2021-08-25 21:18:11','606','2021-08-26 05:04:38',10,0),('5','174',220079,'Daily shift ','2021-08-26','2021-08-26 00:00:00',NULL,'596',595758.70,595758.70,'596','2021-08-26 20:58:29','606','2021-08-27 06:16:29',10,0),('5','174',220254,'Daily shift ','2021-08-27','2021-08-27 00:00:00',NULL,'596',645283.55,645283.55,'596','2021-08-27 20:44:11','606','2021-08-28 05:23:02',10,0),('5','174',220492,'Daily shift ','2021-08-28','2021-08-28 00:00:00',NULL,'596',518462.70,518462.70,'596','2021-08-29 05:29:49','606','2021-08-29 05:55:04',10,0),('5','174',220716,'Daily shift ','2021-08-29','2021-08-29 00:00:00',NULL,'596',566369.20,566369.20,'596','2021-08-29 21:02:06','606','2021-08-30 05:37:06',10,0),('5','174',220929,'Daily shift ','2021-08-30','2021-08-30 00:00:00',NULL,'596',657277.20,657277.20,'596','2021-08-30 21:11:42','606','2021-08-31 06:00:42',10,0),('5','174',221181,'Daily shift ','2021-08-31','2021-08-31 00:00:00',NULL,'596',528553.15,528553.15,'596','2021-08-31 20:30:01','606','2021-09-01 05:57:52',10,0),('5','174',221418,'Daily shift ','2021-09-01','2021-09-01 00:00:00',NULL,'596',636027.45,636027.45,'596','2021-09-01 21:22:29','606','2021-09-02 05:46:07',10,0),('5','174',221637,'Daily shift ','2021-09-02','2021-09-02 00:00:00',NULL,'596',561903.45,561903.45,'596','2021-09-02 20:15:50','606','2021-09-03 05:43:16',10,0),('5','174',221853,'Daily shift ','2021-09-03','2021-09-03 00:00:00',NULL,'596',589009.85,589009.85,'596','2021-09-03 21:13:42','606','2021-09-04 06:04:38',10,0),('5','174',223083,'Daily shift ','2021-09-04','2021-09-04 00:00:00',NULL,'596',378087.55,378087.55,'596','2021-09-08 14:15:24','606','2021-09-08 14:24:17',10,0),('5','174',223092,'Daily shift ','2021-09-05','2021-09-05 00:00:00',NULL,'596',391026.85,391026.85,'596','2021-09-08 14:39:40','606','2021-09-08 14:42:35',10,0),('5','174',223100,'Daily shift ','2021-09-06','2021-09-06 00:00:00',NULL,'596',492252.55,492252.55,'596','2021-09-14 12:44:05','606','2021-09-14 13:02:22',10,0),('5','174',224440,'Daily shift ','2021-09-14','2021-09-14 00:00:00',NULL,'596',413059.00,413059.00,'596','2021-09-14 13:24:02','606','2021-09-14 13:25:57',10,0),('5','174',224444,'Daily shift ','2021-09-14','2021-09-14 00:00:00',NULL,'596',617758.95,617758.95,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',224447,'Daily shift ','2021-09-08','2021-09-08 00:00:00',NULL,'596',617758.95,617758.95,'596','2021-09-14 13:47:33','606','2021-09-14 13:51:06',10,0),('5','174',224451,'Daily shift ','2021-09-09','2021-09-09 00:00:00',NULL,'596',431101.10,431101.10,'596','2021-09-14 14:00:27','606','2021-09-14 14:02:14',10,0),('5','174',224453,'Daily shift ','2021-09-10','2021-09-10 00:00:00',NULL,'596',422348.25,422348.25,'596','2021-09-14 14:05:21','606','2021-09-14 14:08:18',10,0),('5','174',224456,'Daily shift ','2021-09-11','2021-09-11 00:00:00',NULL,'596',482595.85,482595.85,'596','2021-09-14 14:15:44','606','2021-09-14 14:21:15',10,0),('5','174',224460,'Daily shift ','2021-09-12','2021-09-12 00:00:00',NULL,'596',360714.30,360714.30,'596','2021-09-14 14:25:55','606','2021-09-14 14:27:29',10,0),('5','174',224461,'Daily shift ','2021-09-13','2021-09-13 00:00:00',NULL,'596',372759.75,372759.75,'596','2021-09-14 14:31:29','606','2021-09-14 14:32:46',10,0),('5','174',224463,'Daily shift ','2021-09-14','2021-09-14 00:00:00',NULL,'596',463193.10,463193.10,'596','2021-09-20 14:16:43','606','2021-09-20 14:18:17',10,0),('5','174',225881,'Daily shift ','2021-09-15','2021-09-15 00:00:00',NULL,'596',431224.40,431224.40,'596','2021-09-20 14:29:56','606','2021-09-20 14:32:49',10,0),('5','174',225889,'Daily shift ','2021-09-16','2021-09-16 00:00:00',NULL,'596',469326.90,469326.90,'596','2021-09-20 14:42:21','606','2021-09-20 14:49:19',10,0),('5','174',225894,'Daily shift ','2021-09-17','2021-09-17 00:00:00',NULL,'596',466537.45,461165.15,'596','2021-09-20 14:54:53','606','2021-09-20 14:59:11',10,0),('5','174',225896,'Daily shift ','2021-09-20','2021-09-20 00:00:00',NULL,'596',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',225901,'Daily shift ','2021-09-18','2021-09-18 00:00:00',NULL,'596',677402.09,677402.09,'596','2021-09-20 15:12:58','606','2021-09-20 15:14:36',10,0),('5','174',225904,'Daily shift ','2021-09-19','2021-09-19 00:00:00',NULL,'596',784260.25,784260.25,'596','2021-09-20 15:17:57','606','2021-09-20 15:24:15',10,0),('5','174',226825,'Daily shift ','2021-09-20','2021-09-20 00:00:00',NULL,'596',585363.51,585363.51,'596','2021-09-24 10:58:58','606','2021-09-24 11:05:19',10,0),('5','174',226829,'Daily shift ','2021-09-21','2021-09-21 00:00:00',NULL,'596',670144.42,670144.42,'596','2021-09-24 11:15:09','606','2021-09-24 11:22:46',10,0),('5','174',226882,'Daily shift ','2021-09-22','2021-09-22 00:00:00',NULL,'596',503640.15,503640.15,'596','2021-09-24 14:23:55','606','2021-09-24 14:26:02',10,0),('5','174',226884,'Daily shift ','2021-09-23','2021-09-23 00:00:00',NULL,'596',673503.38,673503.38,'596','2021-09-24 14:29:47','606','2021-09-24 14:31:27',10,0),('5','174',226889,'Daily shift ','2021-09-24','2021-09-24 00:00:00',NULL,'596',575082.91,575082.91,'596','2021-09-28 11:39:09','606','2021-09-28 11:49:20',10,0),('5','174',227726,'Daily shift ','2021-09-25','2021-09-25 00:00:00',NULL,'596',503980.17,503980.17,'596','2021-09-28 12:16:35','606','2021-09-28 12:30:09',10,0),('5','174',227739,'Daily shift ','2021-09-26','2021-09-26 00:00:00',NULL,'596',537694.16,537694.16,'596','2021-09-28 12:57:46','606','2021-09-28 13:13:13',10,0),('5','174',227764,'Daily shift ','2021-09-27','2021-09-27 00:00:00',NULL,'596',837638.61,837638.61,'596','2021-09-28 13:44:48','606','2021-09-28 13:46:13',10,0),('5','174',229271,'Daily shift ','2021-09-28','2021-09-28 00:00:00',NULL,'596',488052.42,489143.82,'596','2021-10-05 12:14:32','606','2021-10-05 12:20:46',10,0),('5','174',229280,'Daily shift ','2021-09-29','2021-09-29 00:00:00',NULL,'596',452878.82,453417.57,'596','2021-10-05 12:36:37','606','2021-10-05 13:27:29',10,0),('5','174',229394,'Daily shift ','2021-09-30','2021-09-30 00:00:00',NULL,'596',296944.46,297432.01,'596','2021-10-05 20:17:18','600','2021-10-11 13:10:27',10,0),('5','174',230852,'Daily shift ','2021-10-01','2021-10-01 00:00:00',NULL,'596',360460.44,360460.44,'596','2021-10-12 10:14:19','606','2021-10-12 10:17:05',10,0),('5','174',230856,'Daily shift ','2021-10-02','2021-10-02 00:00:00',NULL,'596',35499.00,35499.00,'596','2021-10-12 10:25:37','606','2021-10-12 10:26:49',10,0),('5','174',230863,'Daily shift ','2021-10-03','2021-10-03 00:00:00',NULL,'596',88803.00,88803.00,'596','2021-10-12 10:43:13','606','2021-10-12 10:45:18',10,0),('5','174',230874,'Daily shift ','2021-10-06','2021-10-06 00:00:00',NULL,'596',413555.45,413555.45,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',230883,'Daily shift ','2021-10-04','2021-10-04 00:00:00',NULL,'596',0.00,0.00,'596','2021-10-12 11:09:15','606','2021-10-12 11:09:51',10,0),('5','174',230884,'Daily shift ','2021-10-05','2021-10-05 00:00:00',NULL,'596',0.00,0.00,'596','2021-10-12 11:10:55','606','2021-10-12 11:11:33',10,0),('5','174',230885,'Daily shift ','2021-10-06','2021-10-06 00:00:00',NULL,'596',413555.45,413555.45,'596','2021-10-12 11:14:14','606','2021-10-12 11:19:35',10,0),('5','174',230891,'Daily shift ','2021-10-07','2021-10-07 00:00:00',NULL,'596',478515.84,478515.84,'596','2021-10-12 11:24:36','606','2021-10-12 11:25:19',10,0),('5','174',230894,'Daily shift ','2021-10-08','2021-10-08 00:00:00',NULL,'596',482246.91,482246.91,'596','2021-10-12 11:30:39','606','2021-10-12 11:32:09',10,0),('5','174',230896,'Daily shift ','2021-10-09','2021-10-09 00:00:00',NULL,'596',786549.98,786549.98,'596','2021-10-12 11:35:16','606','2021-10-12 11:36:16',10,0),('5','174',230899,'Daily shift ','2021-10-10','2021-10-10 00:00:00',NULL,'596',902151.21,902151.21,'596','2021-10-12 11:38:39','606','2021-10-12 11:41:23',10,0),('5','174',230902,'Daily shift ','2021-10-11','2021-10-11 00:00:00',NULL,'596',1110207.67,1110207.67,'596','2021-10-12 11:43:44','606','2021-10-12 11:45:44',10,0),('5','174',230905,'Daily shift ','2021-10-12','2021-10-12 00:00:00',NULL,'596',510278.02,510278.02,'596','2021-10-12 18:39:28','606','2021-10-13 05:55:18',10,0),('5','174',231129,'Daily shift','2021-10-13','2021-10-13 00:00:00',NULL,'596',498256.77,498256.77,'596','2021-10-13 17:26:44','606','2021-10-14 07:20:54',10,0),('5','174',231416,'Daily shift','2021-10-14','2021-10-14 00:00:00',NULL,'596',521707.58,521707.58,'596','2021-10-14 17:18:53','606','2021-10-15 06:00:48',10,0),('5','174',231655,'Daily shift','2021-10-15','2021-10-15 00:00:00',NULL,'596',657734.34,657734.34,'596','2021-10-15 17:10:49','606','2021-10-16 09:52:51',10,0),('5','174',231953,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'596',655191.54,655191.54,'596','2021-10-16 17:18:43','606','2021-10-16 19:31:22',10,0),('5','174',232112,'Daily shift ','2021-10-17','2021-10-17 00:00:00',NULL,'596',558636.86,558636.86,'596','2021-10-17 17:23:47','606','2021-10-18 06:12:21',10,0),('5','174',232356,'Daily shift','2021-10-18','2021-10-18 00:00:00',NULL,'596',588742.96,588742.96,'596','2021-10-18 17:26:16','606','2021-10-19 05:52:59',10,0),('5','174',232635,'Daily shift','2021-10-19','2021-10-19 00:00:00',NULL,'596',880126.65,880126.65,'596','2021-10-19 17:25:17','606','2021-10-20 05:49:20',10,0),('5','174',232897,'Daily shift','2021-10-20','2021-10-20 00:00:00',NULL,'596',551094.85,551094.85,'596','2021-10-20 17:16:01','606','2021-10-21 06:04:12',10,0),('5','174',233122,'Daily shift','2021-10-21','2021-10-21 00:00:00',NULL,'596',604324.80,609066.00,'596','2021-10-21 17:36:46','606','2021-10-22 05:59:14',10,0),('5','174',233419,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'596',639331.64,639331.64,'596','2021-10-22 17:25:43','606','2021-10-23 06:18:26',10,0),('5','174',233651,'Daily shift','2021-10-23','2021-10-23 00:00:00',NULL,'596',546100.53,546100.53,'596','2021-10-23 17:22:15','606','2021-10-24 06:15:15',10,0),('5','174',233853,'Daily shift','2021-10-24','2021-10-24 00:00:00',NULL,'596',583810.58,583810.58,'596','2021-10-24 17:17:24','606','2021-10-25 06:05:38',10,0),('5','174',234131,'Daily shift','2021-10-25','2021-10-25 00:00:00',NULL,'596',1186783.44,1186783.44,'596','2021-10-25 17:26:41','606','2021-10-26 05:39:43',10,0),('5','174',234389,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'596',756165.15,765443.25,'596','2021-10-26 17:29:06','606','2021-10-27 06:37:42',10,0),('5','174',234681,'Daily shift','2021-10-27','2021-10-27 00:00:00',NULL,'596',1167084.89,1181404.95,'596','2021-10-27 17:29:50','606','2021-10-28 07:20:01',10,0),('5','174',234924,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'596',754039.63,763291.65,'596','2021-10-28 17:24:13','606','2021-10-29 06:07:50',10,0),('5','174',235150,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'596',1602620.89,1622284.95,'596','2021-10-30 10:38:40','606','2021-10-30 17:30:57',10,0),('5','174',235478,'Daily shift','2021-10-30','2021-10-30 00:00:00',NULL,'596',1679230.89,1699834.95,'596','2021-10-30 17:49:17','606','2021-10-31 06:11:19',10,0),('5','174',235596,'Daily shift','2021-10-31','2021-10-31 00:00:00',NULL,'596',941509.19,953061.45,'596','2021-10-31 17:32:09','606','2021-11-01 07:25:18',10,0),('5','174',235870,'Daily shift','2021-11-01','2021-11-01 00:00:00',NULL,'596',1829671.74,1852121.70,'596','2021-11-02 07:08:02','606','2021-11-02 12:16:32',10,0),('5','174',236188,'Daily shift','2021-11-02','2021-11-02 00:00:00',NULL,'596',1406199.37,1423453.35,'596','2021-11-03 08:13:09','606','2021-11-03 08:49:01',10,0),('5','174',236311,'Daily shift ','2021-11-03','2021-11-03 00:00:00',NULL,'596',1081751.55,1081751.55,'596','2021-11-04 08:30:02','606','2021-11-04 09:38:10',10,0),('5','174',236597,'Daily shift ','2021-11-04','2021-11-04 00:00:00',NULL,'596',1342824.45,1342824.45,'596','2021-11-04 18:08:44','606','2021-11-05 06:34:31',10,0),('5','174',236783,'Daily shift','2021-11-05','2021-11-05 00:00:00',NULL,'596',1765097.40,1765097.40,'596','2021-11-05 16:51:13','606','2021-11-06 07:05:11',10,0),('5','174',237054,'Daily shift','2021-11-06','2021-11-06 00:00:00',NULL,'596',1047961.20,1047961.20,'596','2021-11-07 12:00:21','606','2021-11-07 12:01:13',10,0),('5','174',237317,'Daily shift ','2021-11-07','2021-11-07 00:00:00',NULL,'596',1811374.95,1811374.95,'596','2021-11-07 19:18:56','606','2021-11-08 06:32:00',10,0),('5','174',237428,'Daily shift ','2021-11-08','2021-11-08 00:00:00',NULL,'596',712017.90,712017.90,'596','2021-11-08 19:27:19','606','2021-11-09 06:13:27',10,0),('5','174',237722,'Daily shift ','2021-11-09','2021-11-09 00:00:00',NULL,'596',0.00,0.00,'596','2021-11-09 17:31:53','606','2021-11-10 07:32:12',10,0),('5','174',237925,'Daily shift ','2021-11-10','2021-11-10 00:00:00',NULL,'596',0.00,0.00,'596','2021-11-10 19:57:00','606','2021-11-11 05:46:38',10,0),('5','174',238154,'Daily shift ','2021-11-11','2021-11-11 00:00:00',NULL,'596',0.00,0.00,'596','2021-11-11 18:00:11','606','2021-11-12 07:27:29',10,0),('5','174',238429,'Daily shift ','2021-11-12','2021-11-12 00:00:00',NULL,'596',1345248.30,1345248.30,'596','2021-11-12 17:41:33','606','2021-11-13 07:24:48',10,0),('5','174',238644,'Daily shift ','2021-11-13','2021-11-13 00:00:00',NULL,'596',947332.65,947332.65,'596','2021-11-13 20:19:26','606','2021-11-14 05:47:44',10,0),('5','174',238833,'Daily shift ','2021-11-14','2021-11-14 00:00:00',NULL,'596',949410.00,949410.00,'596','2021-11-14 18:31:27','606','2021-11-15 06:23:14',10,0),('5','174',239147,'Daily shift ','2021-11-15','2021-11-15 00:00:00',NULL,'596',2238018.75,2238018.75,'596','2021-11-15 19:02:28','606','2021-11-15 19:15:20',10,0),('5','174',239328,'Daily shift ','2021-11-16','2021-11-16 00:00:00',NULL,'596',1650787.05,1650787.05,'596','2021-11-16 17:05:14','606','2021-11-17 05:46:51',10,0),('5','174',239537,'Daily shift ','2021-11-17','2021-11-17 00:00:00',NULL,'596',2422553.10,2422553.10,'596','2021-11-17 17:37:04','606','2021-11-18 06:07:24',10,0),('5','174',239797,'Daily shift ','2021-11-18','2021-11-18 00:00:00',NULL,'596',1723205.55,1723205.55,'596','2021-11-18 20:33:40','606','2021-11-19 07:27:03',10,0),('5','174',240036,'Daily shift ','2021-11-19','2021-11-19 00:00:00',NULL,'596',1565330.25,1565330.25,'596','2021-11-19 19:12:12','606','2021-11-20 07:08:39',10,0),('5','174',240236,'Daily shift ','2021-11-20','2021-11-20 00:00:00',NULL,'596',1796008.80,1796008.80,'596','2021-11-21 10:22:07','606','2021-11-21 10:50:33',10,0),('5','174',240531,'Daily shift ','2021-11-21','2021-11-21 00:00:00',NULL,'596',1308344.85,1308344.85,'596','2021-11-21 18:15:15','606','2021-11-22 06:21:28',10,0),('5','174',240769,'Daily shift ','2021-11-22','2021-11-22 00:00:00',NULL,'596',2603706.75,2603706.75,'596','2021-11-22 17:45:20','606','2021-11-23 07:01:40',10,0),('5','174',241015,'Daily shift ','2021-11-23','2021-11-23 00:00:00',NULL,'596',1645088.70,1645088.70,'596','2021-11-23 18:33:00','606','2021-11-24 06:21:35',10,0),('5','174',241249,'Daily shift ','2021-11-24','2021-11-24 00:00:00',NULL,'596',1369149.75,1369149.75,'596','2021-11-24 19:14:28','606','2021-11-25 06:25:43',10,0),('5','174',241522,'Daily shift ','2021-11-25','2021-11-25 00:00:00',NULL,'596',1481130.90,1481130.90,'596','2021-11-25 19:07:07','606','2021-11-26 06:10:13',10,0),('5','174',241747,'Daily shift ','2021-11-26','2021-11-26 00:00:00',NULL,'596',168900.15,168900.15,'596','2021-11-26 18:40:22','606','2021-11-27 07:08:51',10,0),('5','174',242027,'Daily shift ','2021-11-27','2021-11-27 00:00:00',NULL,'596',446571.45,446571.45,'596','2021-11-27 17:57:48','606','2021-11-28 06:48:55',10,0),('5','174',242229,'Daily shift ','2021-11-28','2021-11-28 00:00:00',NULL,'596',217967.55,217967.55,'596','2021-11-28 19:19:08','606','2021-11-29 05:58:11',10,0),('5','174',242450,'Daily shift ','2021-11-29','2021-11-29 00:00:00',NULL,'596',203964.00,203964.00,'596','2021-11-29 18:47:34','606','2021-11-30 06:01:24',10,0),('5','174',242712,'Daily shift ','2021-11-30','2021-11-30 00:00:00',NULL,'596',273540.15,273540.15,'596','2021-12-01 10:01:51','600','2021-12-01 10:15:00',10,0),('5','174',243019,'Daily shift ','2021-12-01','2021-12-01 00:00:00',NULL,'596',159186.45,159186.45,'596','2021-12-01 18:45:47','606','2021-12-02 07:20:18',10,0),('5','174',243180,'Daily shift ','2021-12-02','2021-12-02 00:00:00',NULL,'596',250266.45,250266.45,'596','2021-12-02 18:46:40','606','2021-12-03 06:47:04',10,0),('5','174',243414,'Daily shift ','2021-12-03','2021-12-03 00:00:00',NULL,'596',240603.00,240603.00,'596','2021-12-03 18:44:44','606','2021-12-04 06:55:33',10,0),('5','174',243639,'Daily shift ','2021-12-04','2021-12-04 00:00:00',NULL,'596',153090.30,153090.30,'596','2021-12-04 17:56:39','606','2021-12-05 05:45:20',10,0),('5','174',243888,'Daily shift ','2021-12-05','2021-12-05 00:00:00',NULL,'596',115195.50,115195.50,'596','2021-12-05 18:33:35','606','2021-12-06 06:29:20',10,0),('5','174',244120,'Daily shift ','2021-12-06','2021-12-06 00:00:00',NULL,'596',224902.05,224902.05,'596','2021-12-06 20:32:15','606','2021-12-07 06:51:43',10,0),('5','174',244332,'Daily shift ','2021-12-07','2021-12-07 00:00:00',NULL,'596',1547183.10,1547183.10,'596','2021-12-07 20:09:51','606','2021-12-08 07:17:37',10,0),('5','174',244699,'Daily shift','2021-12-08','2021-12-08 00:00:00',NULL,'596',1181262.00,1181262.00,'596','2021-12-08 19:31:32','606','2021-12-09 05:41:36',10,0),('5','174',244909,'Daily shift','2021-12-09','2021-12-09 00:00:00',NULL,'596',337980.60,337980.60,'596','2021-12-09 17:10:04','606','2021-12-10 06:15:28',10,0),('5','174',245153,'Daily shift','2021-12-10','2021-12-10 00:00:00',NULL,'596',88447.65,88447.65,'596','2021-12-10 17:17:15','606','2021-12-11 06:59:31',10,0),('5','174',245258,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'596',242935.20,242935.20,'596','2021-12-12 08:16:49','606','2021-12-13 05:58:45',10,0),('5','174',245688,'Daily shift','2021-12-13','2021-12-13 00:00:00',NULL,'596',75023.70,75023.70,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','174',245761,'Daily shift ','2021-12-12','2021-12-12 00:00:00',NULL,'596',75023.70,75023.70,'596','2021-12-13 10:34:32','600','2021-12-13 10:44:12',10,0),('5','174',245777,'Daily shift','2021-12-13','2021-12-13 00:00:00',NULL,'596',120618.90,120618.90,'596','2021-12-14 06:57:38','606','2021-12-14 07:14:41',10,0),('5','174',246003,'Daily shift ','2021-12-14','2021-12-14 00:00:00',NULL,'596',36894.30,36894.30,'596','2021-12-14 17:46:02','606','2021-12-15 06:39:10',10,0),('5','174',246270,'Daily shift','2021-12-15','2021-12-15 00:00:00',NULL,'596',782247.15,782247.15,'596','2021-12-15 17:49:36','606','2021-12-16 06:50:51',10,0),('5','174',246524,'Daily shift','2021-12-16','2021-12-16 00:00:00',NULL,'596',727329.90,727329.90,'596','2021-12-16 19:06:25','606','2021-12-17 06:10:43',10,0),('5','174',246783,'Daily shift','2021-12-17','2021-12-17 00:00:00',NULL,'596',695070.75,695070.75,'596','2021-12-17 18:45:16','606','2021-12-18 07:02:54',10,0),('5','174',247027,'Daily shift','2021-12-18','2021-12-18 00:00:00',NULL,'596',129158.70,129158.70,'596','2021-12-18 18:04:13','606','2021-12-19 07:12:09',10,0),('5','174',247310,'Daily shift','2021-12-19','2021-12-19 00:00:00',NULL,'596',0.00,0.00,'596','2021-12-19 17:08:26','606','2021-12-20 06:54:07',10,0),('5','174',247503,'Daily shift','2021-12-20','2021-12-20 00:00:00',NULL,'596',0.00,0.00,'596','2021-12-20 18:48:40','600','2021-12-21 09:21:11',10,0),('5','174',247850,'Daily shift','2021-12-21','2021-12-21 00:00:00',NULL,'596',0.00,0.00,'596','2021-12-21 18:31:57','606','2021-12-22 06:29:21',10,0),('5','174',247929,'Daily shift ','2021-12-22','2021-12-22 00:00:00',NULL,'596',602413.35,602413.35,'596','2021-12-22 19:39:24','606','2021-12-23 06:29:23',10,0),('5','174',248216,'Daily shift ','2021-12-23','2021-12-23 00:00:00',NULL,'596',637759.65,637759.65,'596','2021-12-23 19:49:32','606','2021-12-24 07:20:08',10,0),('5','174',248473,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'596',891503.25,891503.25,'596','2021-12-24 20:03:39','606','2021-12-25 14:08:22',10,0),('5','174',248784,'Daily shift ','2021-12-25','2021-12-25 00:00:00',NULL,'596',926433.75,926433.75,'596','2021-12-26 16:42:35','606','2021-12-26 16:46:55',10,0),('5','174',249030,'Daily shift','2021-12-26','2021-12-26 00:00:00',NULL,'596',1153315.35,1153315.35,'596','2021-12-26 18:28:32','606','2021-12-27 07:40:47',10,0),('5','174',249162,'Daily shift ','2021-12-27','2021-12-27 00:00:00',NULL,'596',1028329.50,1028329.50,'596','2021-12-27 19:07:48','606','2021-12-28 07:35:22',10,0),('5','174',249394,'Daily shift','2021-12-28','2021-12-28 00:00:00',NULL,'596',923443.95,923443.95,'596','2021-12-29 05:31:10','606','2021-12-29 06:45:21',10,0),('5','174',249696,'Daily shift','2021-12-29','2021-12-29 00:00:00',NULL,'596',1075184.55,1075184.55,'596','2021-12-29 17:44:47','606','2021-12-30 06:56:48',10,0),('5','174',249945,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'596',751403.40,751403.40,'596','2021-12-30 20:18:52','606','2021-12-31 06:46:41',10,0),('5','174',250189,'Daily shift','2021-12-31','2021-12-31 00:00:00',NULL,'596',642836.70,642836.70,'596','2022-01-01 06:33:37','606','2022-01-01 07:49:14',10,0),('5','174',250509,'Daily shift','2022-01-01','2022-01-01 00:00:00',NULL,'596',827833.05,827833.05,'596','2022-01-01 18:26:24','606','2022-01-02 06:44:41',10,0),('5','174',250931,'Daily shift ','2022-01-02','2022-01-02 00:00:00',NULL,'596',893684.55,893684.55,'596','2022-01-03 14:42:02','606','2022-01-03 14:53:24',10,0),('5','174',250944,'Daily shift','2022-01-03','2022-01-03 00:00:00',NULL,'596',845818.05,845818.05,'596','2022-01-03 17:41:27','606','2022-01-04 07:04:39',10,0),('5','174',251183,'Daily shift ','2022-01-04','2022-01-04 00:00:00',NULL,'596',1369988.40,1369988.40,'596','2022-01-04 19:47:39','606','2022-01-05 07:34:30',10,0),('5','174',251305,'Daily shift ','2022-01-05','2022-01-05 00:00:00',NULL,'596',1414046.70,1414046.70,'596','2022-01-05 19:59:10','606','2022-01-06 07:46:57',10,0),('5','174',251537,'Daily shift','2022-01-06','2022-01-06 00:00:00',NULL,'596',1234129.05,1234129.05,'596','2022-01-06 18:36:06','606','2022-01-07 09:08:14',10,0),('5','174',251846,'Daily shift ','2022-01-07','2022-01-07 00:00:00',NULL,'596',1130647.65,1130647.65,'596','2022-01-07 21:07:53','606','2022-01-08 07:57:53',10,0),('5','174',252047,'Daily shift ','2022-01-08','2022-01-08 00:00:00',NULL,'596',1328228.55,1328228.55,'596','2022-01-08 21:25:53','606','2022-01-09 08:02:14',10,0),('5','174',252297,'Daily shift ','2022-01-09','2022-01-09 00:00:00',NULL,'596',959244.00,959244.00,'596','2022-01-09 21:12:00','606','2022-01-10 07:01:43',10,0),('5','174',252559,'Daily shift ','2022-01-10','2022-01-10 00:00:00',NULL,'596',1119204.90,1119204.90,'596','2022-01-11 10:45:12','600','2022-01-11 10:59:56',10,0),('5','174',252819,'Daily shift ','2022-01-11','2022-01-11 00:00:00',NULL,'596',1550292.15,1550292.15,'596','2022-01-11 20:38:28','606','2022-01-12 07:49:18',10,0),('5','174',253062,'Daily ','2022-01-12','2022-01-12 00:00:00',NULL,'596',973952.10,973952.10,'596','2022-01-12 19:50:00','606','2022-01-13 07:34:46',10,0),('5','174',253337,'Daily  shift ','2022-01-13','2022-01-13 00:00:00',NULL,'596',1095760.05,1095760.05,'596','2022-01-13 22:02:35','606','2022-01-14 09:32:47',10,0),('5','174',253541,'Daily  shift ','2022-01-14','2022-01-14 00:00:00',NULL,'596',1077256.95,1077256.95,'596','2022-01-14 21:17:26','606','2022-01-15 07:15:06',10,0),('5','174',253735,'Daily shift','2022-01-15','2022-01-15 00:00:00',NULL,'596',1134929.40,1134929.40,'596','2022-01-15 20:39:59','606','2022-01-16 07:10:18',10,0),('5','174',254003,'Daily  shift ','2022-01-16','2022-01-16 00:00:00',NULL,'596',873600.75,873600.75,'596','2022-01-16 20:15:13','606','2022-01-17 07:13:22',10,0),('5','174',254216,'Daily shift','2022-01-17','2022-01-17 00:00:00',NULL,'596',669815.85,669815.85,'596','2022-01-17 20:41:02','606','2022-01-18 08:38:13',10,0),('5','174',254503,'Daily  shift ','2022-01-18','2022-01-18 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-18 19:15:00','606','2022-01-19 08:42:53',10,0),('5','174',254774,'Daily  shift ','2022-01-19','2022-01-19 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-19 21:05:37','606','2022-01-20 08:07:54',10,0),('5','174',255019,'Daily shift ','2022-01-20','2022-01-20 00:00:00',NULL,'596',199032.90,199032.90,'596','2022-01-20 20:29:46','606','2022-01-21 11:52:36',10,0),('5','174',255287,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'596',1142554.05,1142554.05,'596','2022-01-21 22:21:59','606','2022-01-22 08:07:09',10,0),('5','174',255514,'Daily shift ','2022-01-22','2022-01-22 00:00:00',NULL,'596',900528.75,900528.75,'596','2022-01-22 20:03:53','606','2022-01-23 07:22:40',10,0),('5','174',255759,'Daily shift ','2022-01-23','2022-01-23 00:00:00',NULL,'596',823808.70,823808.70,'596','2022-01-23 20:07:24','606','2022-01-24 08:32:16',10,0),('5','174',256001,'Daily shift ','2022-01-24','2022-01-24 00:00:00',NULL,'596',186483.00,186483.00,'596','2022-01-24 22:06:39','606','2022-01-25 07:32:11',10,0),('5','174',256273,'Daily  shift ','2022-01-25','2022-01-25 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-25 20:32:17','606','2022-01-26 08:08:10',10,0),('5','174',256537,'Daily shift ','2022-01-26','2022-01-26 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-26 20:03:56','606','2022-01-27 07:56:45',10,0),('5','174',256796,'Daily shift ','2022-01-27','2022-01-27 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-27 21:39:05','606','2022-01-28 07:21:30',10,0),('5','174',256991,'Daily shift ','2022-01-28','2022-01-28 00:00:00',NULL,'596',0.00,0.00,'596','2022-01-28 19:45:51','606','2022-01-29 07:49:32',10,0),('5','174',257286,'Daily shift ','2022-01-29','2022-01-29 00:00:00',NULL,'596',316823.10,316823.10,'596','2022-01-29 20:37:14','606','2022-01-30 07:43:30',10,0),('5','174',257545,'Daily shift ','2022-01-30','2022-01-30 00:00:00',NULL,'596',1250173.65,1250173.65,'596','2022-01-31 09:28:17','606','2022-01-31 09:32:39',10,0),('5','174',257546,'Daily shift ','2022-01-31','2022-01-31 00:00:00',NULL,'596',1303957.05,1303957.05,'596','2022-01-31 20:38:46','606','2022-02-01 08:32:21',10,0),('5','174',257547,'Daily shift ','2022-02-01','2022-02-01 00:00:00',NULL,'596',788094.45,788094.45,'596','2022-02-01 21:17:50','606','2022-02-02 08:37:04',10,0),('5','174',257548,'Daily shift ','2022-02-02','2022-02-02 00:00:00',NULL,'596',203177.70,203177.70,'596','2022-02-02 21:05:14','606','2022-02-03 06:43:50',10,0),('5','174',257549,'Daily shift','2022-02-03','2022-02-03 00:00:00',NULL,'596',723785.70,723785.70,'596','2022-02-04 07:40:16','606','2022-02-04 09:12:33',10,0),('5','174',257550,'Daily shift ','2022-02-04','2022-02-04 00:00:00',NULL,'596',1267917.75,1267917.75,'596','2022-02-04 21:20:27','606','2022-02-05 07:53:49',10,0),('5','174',257551,'Daily shift ','2022-02-05','2022-02-05 00:00:00',NULL,'596',1497328.80,1497328.80,'596','2022-02-05 20:48:04','606','2022-02-06 07:49:38',10,0),('5','174',257552,'Daily shift ','2022-02-06','2022-02-06 00:00:00',NULL,'596',1075597.05,1075597.05,'596','2022-02-06 20:27:10','606','2022-02-07 07:18:46',10,0),('5','174',257553,'Daily shift ','2022-02-07','2022-02-07 00:00:00',NULL,'596',1297347.15,1297347.15,'596','2022-02-07 20:37:23','606','2022-02-08 07:44:42',10,0),('5','174',257554,'Daily shift ','2022-02-08','2022-02-08 00:00:00',NULL,'596',1058092.20,1058092.20,'596','2022-02-08 20:31:54','606','2022-02-09 08:21:27',10,0),('5','174',257555,'Daily shift ','2022-02-09','2022-02-09 00:00:00',NULL,'596',513164.85,513164.85,'596','2022-02-09 20:50:53','606','2022-02-10 08:05:02',10,0),('5','174',257556,'Daily shift ','2022-02-10','2022-02-10 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-10 21:40:58','606','2022-02-11 08:14:09',10,0),('5','174',257557,'Daily shift ','2022-02-11','2022-02-11 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-12 09:30:01','606','2022-02-12 14:23:39',10,0),('5','174',257558,'Daily shift ','2022-02-12','2022-02-12 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-12 22:04:45','606','2022-02-13 07:32:22',10,0),('5','174',257559,'Daily shift ','2022-02-13','2022-02-13 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-13 20:26:02','606','2022-02-14 07:22:54',10,0),('5','174',257560,'Daily shift ','2022-02-14','2022-02-14 00:00:00',NULL,'596',364836.45,364836.45,'596','2022-02-14 20:25:14','606','2022-02-15 08:12:44',10,0),('5','174',257561,'Daily shift ','2022-02-15','2022-02-15 00:00:00',NULL,'596',1866435.45,1866435.45,'596','2022-02-15 20:40:31','606','2022-02-16 07:34:28',10,0),('5','174',257562,'Daily shift ','2022-02-16','2022-02-16 00:00:00',NULL,'596',1573218.90,1573218.90,'596','2022-02-16 20:22:43','606','2022-02-17 07:11:27',10,0),('5','174',257563,'Daily shift ','2022-02-17','2022-02-17 00:00:00',NULL,'596',993669.60,993669.60,'596','2022-02-17 21:19:05','606','2022-02-18 07:25:46',10,0),('5','174',257564,'Daily shift ','2022-02-18','2022-02-18 00:00:00',NULL,'596',159993.90,159993.90,'596','2022-02-18 22:03:12','606','2022-02-19 07:37:07',10,0),('5','174',257565,'Daily shift ','2022-02-19','2022-02-19 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-20 07:35:09','606','2022-02-20 09:14:29',10,0),('5','174',257566,'Daily shift ','2022-02-20','2022-02-20 00:00:00',NULL,'596',0.00,0.00,'596','2022-02-20 20:36:52','606','2022-02-21 07:28:04',10,0),('5','174',257567,'Daily shift ','2022-02-21','2022-02-21 00:00:00',NULL,'596',297084.15,297084.15,'596','2022-02-21 22:22:03','606','2022-02-22 06:46:54',10,0),('5','174',257568,'Daily shift ','2022-02-22','2022-02-22 08:27:29','2022-02-23 08:27:29','596',1866752.25,1866752.25,'596','2022-02-22 20:36:35','606','2022-02-23 07:04:31',10,0),('5','174',257569,'Daily shift ','2022-02-23','2022-02-23 08:28:16','2022-02-24 08:28:16','596',1712983.80,1712983.80,'596','2022-02-23 20:32:24','606','2022-02-24 09:40:10',10,0),('5','174',257570,'Daily shift ','2022-02-24','2022-02-24 11:46:55','2022-02-25 11:46:55','596',1730340.15,1730340.15,'596','2022-02-24 22:07:22','606','2022-02-25 11:05:07',10,0),('5','174',257571,'Daily shift ','2022-02-25','2022-02-25 12:29:18','2022-02-26 12:29:18','596',2885604.15,2885604.15,'596','2022-02-25 21:30:08','606','2022-02-26 07:22:44',10,0),('5','174',257572,'Daily shift ','2022-02-26','2022-02-26 22:55:28','2022-02-27 22:55:28','596',1062499.35,1062499.35,'596','2022-02-26 22:56:46','606','2022-02-27 07:05:25',10,0),('5','174',257573,'Daily shift ','2022-02-27','2022-02-27 09:22:52','2022-02-28 09:22:52','596',1418704.65,1418704.65,'596','2022-02-27 20:36:48','606','2022-02-28 07:20:10',10,0),('5','174',257574,'Daily shift ','2022-02-28','2022-02-28 08:38:08','2022-03-01 08:38:08','596',478061.10,478061.10,'596','2022-02-28 21:49:38','606','2022-03-01 06:58:03',10,0),('5','174',257575,'Daily shift ','2022-03-01','2022-03-01 08:28:06','2022-03-02 08:28:06','596',3146583.00,3146583.00,'596','2022-03-01 21:38:08','606','2022-03-02 08:22:46',10,0),('5','174',257576,'Daily shift ','2022-03-02','2022-03-02 12:49:04','2022-03-03 12:49:04','596',637890.00,637890.00,'596','2022-03-02 22:33:00','606','2022-03-03 09:42:38',10,0),('5','174',257577,'Daily shift ','2022-03-03','2022-03-03 09:53:23','2022-03-04 09:53:23','596',0.00,0.00,'596','2022-03-03 22:27:36','606','2022-03-04 09:15:25',10,0),('5','174',257578,'Daily shift ','2022-03-04','2022-03-04 09:21:12','2022-03-05 09:21:12','596',659069.40,659069.40,'596','2022-03-05 09:39:33','606','2022-03-05 12:35:11',10,0),('5','174',257579,'Daily shift ','2022-03-05','2022-03-05 21:37:30','2022-03-06 21:37:30','596',1664279.10,1664279.10,'596','2022-03-05 21:38:35','606','2022-03-06 07:44:31',10,0),('5','174',257580,'Daily shift ','2022-03-06','2022-03-06 11:39:27','2022-03-07 11:39:27','596',502095.00,502095.00,'596','2022-03-06 20:34:17','606','2022-03-07 08:01:02',10,0),('5','174',257581,'Daily shift ','2022-03-07','2022-03-07 08:25:48','2022-03-08 08:25:48','596',0.00,0.00,'596','2022-03-07 22:11:29','606','2022-03-08 07:05:50',10,0),('5','174',257582,'Daily shift ','2022-03-08','2022-03-08 09:13:35','2022-03-09 09:13:35','596',0.00,0.00,'596','2022-03-08 21:52:01','606','2022-03-09 07:59:44',10,0),('5','174',257583,'Daily shift ','2022-03-09','2022-03-09 22:42:47','2022-03-10 22:42:47','596',0.00,0.00,'596','2022-03-09 22:43:09','606','2022-03-10 06:42:28',10,0),('5','174',257584,'Daily shift','2022-03-10','2022-03-10 10:57:03','2022-03-11 10:57:03','596',0.00,0.00,'596','2022-03-10 23:01:16','606','2022-03-11 08:27:28',10,0),('5','174',257585,'Daily shift ','2022-03-11','2022-03-11 08:33:41','2022-03-12 08:33:41','596',344355.00,344355.00,'596','2022-03-12 07:07:49','606','2022-03-12 07:59:58',10,0),('5','174',257586,'Daily shift ','2022-03-12','2022-03-12 08:53:33','2022-03-13 08:53:33','596',1082167.35,1082167.35,'596','2022-03-12 20:32:06','606','2022-03-13 08:09:06',10,0),('5','174',257587,'Daily shift','2022-03-13','2022-03-13 09:07:21','2022-03-14 09:07:21','596',989526.45,989526.45,'596','2022-03-13 21:17:33','606','2022-03-14 07:08:52',10,0),('5','174',257588,'Daily shift ','2022-03-14','2022-03-14 08:20:26','2022-03-15 08:20:26','596',222987.60,222987.60,'596','2022-03-14 21:12:23','606','2022-03-15 07:10:47',10,0),('5','174',257589,'Daily shift','2022-03-15','2022-03-15 19:27:42','2022-03-16 19:27:42','596',0.00,0.00,'596','2022-03-15 19:28:34','606','2022-03-16 08:13:30',10,0),('5','174',257590,'Daily shift','2022-03-16','2022-03-16 14:47:32','2022-03-17 14:47:32','596',0.00,0.00,'596','2022-03-16 19:19:52','606','2022-03-17 10:24:31',10,0),('5','174',257591,'Daily shift','2022-03-17','2022-03-17 17:57:36','2022-03-18 17:57:36','596',0.00,0.00,'596','2022-03-18 06:12:55','606','2022-03-18 07:49:29',10,0),('5','174',257592,'Daily shift ','2022-03-18','2022-03-19 07:50:02','2022-03-20 07:50:02','596',0.00,0.00,'596','2022-03-19 07:50:18','606','2022-03-19 08:33:53',10,0),('5','174',257593,'Daily shift ','2022-03-19','2022-03-19 08:48:25','2022-03-20 08:48:25','596',0.00,0.00,'596','2022-03-19 21:30:42','606','2022-03-20 07:34:48',10,0),('5','174',257594,'Daily shift ','2022-03-20','2022-03-20 08:10:26','2022-03-21 08:10:26','596',0.00,0.00,'596','2022-03-20 19:45:55','606','2022-03-21 06:35:41',10,0),('5','174',257595,'Daily shift ','2022-03-21','2022-03-21 09:23:53','2022-03-22 09:23:53','596',0.00,0.00,'596','2022-03-21 22:34:03','606','2022-03-22 07:08:57',10,0),('5','174',257596,'Daily shift ','2022-03-22','2022-03-22 10:12:28','2022-03-23 10:12:28','596',0.00,0.00,'596','2022-03-22 21:23:49','606','2022-03-23 06:35:20',10,0),('5','174',257597,'Daily shift ','2022-03-23','2022-03-23 10:04:37','2022-03-24 10:04:37','596',0.00,0.00,'596','2022-03-23 21:26:38','606','2022-03-24 20:38:26',10,0),('5','174',257598,'Daily shift ','2022-03-24','2022-03-24 23:07:33','2022-03-25 23:07:33','596',683646.15,683646.15,'596','2022-03-24 23:09:45','600','2022-03-25 09:48:45',10,0),('5','174',257599,'Daily shift ','2022-03-25','2022-03-25 09:54:48','2022-03-26 09:54:48','596',1254557.70,1254557.70,'596','2022-03-25 23:27:15','606','2022-03-26 09:07:28',10,0),('5','174',257600,'Daily shift ','2022-03-26','2022-03-26 09:16:14','2022-03-27 09:16:14','596',1267619.10,1267619.10,'596','2022-03-26 19:51:29','606','2022-03-27 07:07:43',10,0),('5','174',257601,'Daily shift ','2022-03-27','2022-03-27 12:52:37','2022-03-28 12:52:37','596',200869.35,200869.35,'596','2022-03-28 03:08:20','606','2022-03-28 09:23:15',10,0),('5','174',257602,'Daily shift','2022-03-29','2022-03-29 07:54:39','2022-03-30 07:54:39','596',0.00,0.00,'596','2022-03-30 06:15:32','606','2022-03-30 06:43:27',10,0),('5','174',257603,'Daily shift','2022-03-30','2022-03-30 22:01:05','2022-03-31 22:01:05','596',0.00,0.00,'596','2022-03-30 22:45:12','606','2022-03-31 08:05:47',10,0),('5','174',257604,'Daily shift','2022-03-31','2022-04-01 03:18:54','2022-04-02 03:18:54','596',0.00,0.00,'596','2022-04-01 03:19:58','797','2022-04-01 07:35:53',10,0),('5','174',257605,'Daily shift','2022-04-01','2022-04-01 10:47:32','2022-04-02 10:47:32','596',0.00,0.00,'596','2022-04-02 12:47:10','797','2022-04-02 17:02:15',10,0),('5','174',257606,'Daily shift','2022-04-02','2022-04-02 23:04:06','2022-04-03 23:04:06','596',0.00,0.00,'596','2022-04-02 23:05:24','606','2022-04-03 22:02:34',10,0),('5','174',257607,'Daily shift','2022-04-03','2022-04-03 22:39:47','2022-04-04 22:39:47','596',0.00,0.00,'596','2022-04-03 22:40:43','797','2022-04-04 09:07:32',10,0),('5','174',257608,'Daily shift','2022-04-04','2022-04-04 22:48:17','2022-04-05 22:48:17','596',0.00,0.00,'596','2022-04-04 22:48:51','797','2022-04-05 10:31:00',10,0),('5','174',257609,'Daily shift','2022-04-05','2022-04-06 04:20:07','2022-04-07 04:20:07','596',0.00,0.00,'596','2022-04-06 04:20:51','797','2022-04-06 09:50:47',10,0),('5','174',257610,'Daily shift','2022-04-06','2022-04-07 00:26:56','2022-04-08 00:26:56','596',0.00,0.00,'596','2022-04-07 00:29:00','606','2022-04-07 06:12:19',10,0),('5','174',257611,'Daily shift','2022-04-07','2022-04-07 19:28:27','2022-04-08 19:28:27','596',0.00,0.00,'596','2022-04-07 19:29:14','797','2022-04-08 10:32:34',10,0),('5','174',257612,'Daily shift','2022-04-08','2022-04-08 22:59:59','2022-04-09 22:59:59','596',0.00,0.00,'596','2022-04-08 23:01:08','797','2022-04-09 12:53:59',10,0),('5','174',257613,'Daily shift ','2022-04-09','2022-04-09 19:22:17','2022-04-10 19:22:17','596',0.00,0.00,'596','2022-04-09 19:23:20','797','2022-04-10 14:59:32',10,0),('5','174',257614,'Daily shift','2022-04-10','2022-04-10 17:29:33','2022-04-11 17:29:33','596',0.00,0.00,'596','2022-04-10 17:30:53','797','2022-04-11 08:59:54',10,0),('5','174',257615,'Daily shift','2022-04-11','2022-04-11 21:57:04','2022-04-12 21:57:04','596',359568.00,359568.00,'596','2022-04-12 11:20:18','797','2022-04-12 14:17:55',10,0),('5','174',257616,'Daily shift','2022-04-12','2022-04-12 19:54:19','2022-04-13 19:54:19','596',761181.30,761181.30,'596','2022-04-12 20:04:28','797','2022-04-13 09:56:35',10,0),('5','174',257617,'Daily shift','2022-04-13','2022-04-13 21:10:01','2022-04-14 21:10:01','596',755577.90,755577.90,'596','2022-04-13 21:20:55','797','2022-04-14 08:27:21',10,0),('5','174',257618,'Daily shift','2022-04-14','2022-04-14 17:05:09','2022-04-15 17:05:09','596',334720.65,334720.65,'596','2022-04-14 21:59:36','797','2022-04-15 15:19:45',10,0),('5','174',257619,'Daily shift','2022-04-15','2022-04-15 19:56:59','2022-04-16 19:56:59','596',0.00,0.00,'596','2022-04-16 10:08:10','797','2022-04-16 11:32:55',10,0),('5','174',257620,'Daily shipt','2022-04-16','2022-04-16 21:21:14','2022-04-17 21:21:14','596',0.00,0.00,'596','2022-04-16 21:21:57','797','2022-04-17 07:09:21',10,0),('5','174',257621,'Daily shift','2022-04-17','2022-04-17 22:02:37','2022-04-18 22:02:37','596',0.00,0.00,'596','2022-04-17 22:03:15','797','2022-04-17 22:12:39',10,0),('5','174',257622,'Daily shift','2022-04-18','2022-04-18 19:25:38','2022-04-19 19:25:38','596',525741.15,525741.15,'596','2022-04-18 23:33:01','797','2022-04-19 04:33:45',10,0),('5','174',257623,'Daily shipt','2022-04-19','2022-04-19 10:51:03','2022-04-20 10:51:03','596',981651.00,981651.00,'596','2022-04-19 21:26:11','797','2022-04-19 22:46:54',10,0),('5','174',257624,'Daily shipt','2022-04-20','2022-04-20 14:31:33','2022-04-21 14:31:33','596',871985.40,871985.40,'596','2022-04-20 19:50:42','797','2022-04-21 08:56:25',10,0),('5','174',257625,'Daily shift','2022-04-21','2022-04-21 22:02:07','2022-04-22 22:02:07','596',878065.65,878065.65,'596','2022-04-22 11:25:30','797','2022-04-22 11:27:01',10,0),('5','174',257626,'Daily shift','2022-04-22','2022-04-22 21:31:54','2022-04-23 21:31:54','596',890995.05,890995.05,'596','2022-04-22 21:36:22','797','2022-04-23 09:28:20',10,0),('5','174',257627,'Daily shift','2022-04-23','2022-04-23 19:53:29','2022-04-24 19:53:29','596',702739.95,702739.95,'596','2022-04-23 19:55:33','797','2022-04-23 22:09:41',10,0),('5','174',257628,'Daily shift','2022-04-24','2022-04-24 21:15:43','2022-04-25 21:15:43','596',1157338.05,1157338.05,'596','2022-04-24 21:49:51','797','2022-04-25 04:55:49',10,0),('5','174',257629,'Daily shift','2022-04-25','2022-04-25 20:18:50','2022-04-26 20:18:50','596',924090.75,924090.75,'596','2022-04-25 20:23:03','797','2022-04-26 07:37:13',10,0),('5','174',257630,'Daily shift','2022-04-26','2022-04-26 19:49:55','2022-04-27 19:49:55','596',118833.00,118833.00,'596','2022-04-27 07:45:00','797','2022-04-27 08:18:57',10,0),('5','174',257631,'Daily shipt','2022-04-26','2022-04-27 16:38:55','2022-04-28 16:38:55','596',1025476.65,1025476.65,'596','2022-04-27 16:46:50','797','2022-04-27 16:50:37',10,0),('5','174',257632,'Daily shift','2022-04-27','2022-04-27 20:52:08','2022-04-28 20:52:08','596',1031398.50,1031398.50,'596','2022-04-27 21:03:23','797','2022-04-28 07:35:00',10,0),('5','174',257633,'Daily shifts','2022-04-28','2022-04-28 11:34:02','2022-04-29 11:34:02','596',963565.35,963565.35,'596','2022-04-28 22:14:18','797','2022-04-29 14:22:04',10,0),('5','174',257634,'Daily shift','2022-04-29','2022-04-29 20:00:45','2022-04-30 20:00:45','596',1393464.60,1393464.60,'596','2022-04-29 20:04:44','797','2022-05-09 10:24:50',10,0),('5','174',257635,'Daily shipt','2022-04-30','2022-05-10 15:53:15','2022-05-11 15:53:15','596',1590505.95,1590505.95,'596','2022-05-10 15:57:51','797','2022-05-10 16:00:35',10,0),('5','174',257636,'Daily shipt','2022-05-01','2022-05-10 16:03:39','2022-05-11 16:03:39','596',845598.60,845598.60,'596','2022-05-10 17:16:36','797','2022-05-10 17:17:25',10,0),('5','174',257637,'Daily shipt','2022-05-02','2022-05-10 17:22:23','2022-05-11 17:22:23','596',848500.95,848500.95,'596','2022-05-10 17:29:04','797','2022-05-10 17:29:45',10,0),('5','174',257638,'Daily shift','2022-05-03','2022-05-10 17:32:37','2022-05-11 17:32:37','596',762303.30,762303.30,'596','2022-05-10 17:42:25','797','2022-05-10 19:58:04',10,0),('5','174',257639,'Daily shipt','2022-05-04','2022-05-11 04:21:34','2022-05-12 04:21:34','596',184869.30,184869.30,'596','2022-05-11 04:27:16','797','2022-05-11 05:41:05',10,0),('5','174',257640,'Daily shipt','2022-05-05','2022-05-11 06:22:24','2022-05-12 06:22:24','596',541713.15,541713.15,'596','2022-05-11 06:31:25','797','2022-05-11 08:17:54',10,0),('5','174',257641,'Daily shipt','2022-05-08','2022-05-11 08:22:22','2022-05-12 08:22:22','596',682976.25,682976.25,'596','2022-05-11 08:25:38','797','2022-05-11 08:28:53',10,0),('5','174',257642,'Daily shift','2022-05-07','2022-05-11 09:08:06','2022-05-12 09:08:06','596',785246.55,785246.55,'596','2022-05-11 09:11:48','797','2022-05-11 09:28:52',10,0),('5','174',257643,'Daily shipt','2022-05-08','2022-05-11 09:33:28','2022-05-12 09:33:28','596',200496.45,200496.45,'596','2022-05-11 09:36:55','797','2022-05-11 09:39:19',10,0),('5','174',257644,'Daily shipt','2022-05-09','2022-05-11 09:53:58','2022-05-12 09:53:58','596',0.00,0.00,'596','2022-05-11 09:54:42','797','2022-05-11 09:54:59',10,0),('5','174',257645,'Daily shift','2022-05-10','2022-05-11 09:58:24','2022-05-12 09:58:24','596',0.00,0.00,'596','2022-05-11 09:59:24','797','2022-05-11 10:04:19',10,0),('5','174',257646,'Daily shipt','2022-05-11','2022-05-11 11:48:08','2022-05-12 11:48:08','596',0.00,0.00,'596','2022-05-13 07:13:46','797','2022-05-13 09:55:45',10,0),('5','174',257647,'Daily shipt','2022-05-12','2022-05-13 12:49:13','2022-05-14 12:49:13','596',0.00,0.00,'596','2022-05-13 14:11:29','797','2022-05-14 14:33:50',10,0),('5','174',257648,'Daily shipt','2022-05-13','2022-05-15 08:10:30','2022-05-16 08:10:30','596',0.00,0.00,'596','2022-05-15 08:11:16','797','2022-05-15 10:00:53',10,0),('5','174',257649,'Daily shipt','2022-05-14','2022-05-15 10:23:03','2022-05-16 10:23:03','596',0.00,0.00,'596','2022-05-15 10:23:45','797','2022-05-15 12:07:23',10,0),('5','174',257650,'Daily shipt or','2022-05-15','2022-05-15 12:23:47','2022-05-16 12:23:47','596',0.00,0.00,'596','2022-05-16 08:01:35','797','2022-05-16 08:09:13',10,0),('5','174',257651,'Daily shipt','2022-05-16','2022-05-16 10:25:26','2022-05-17 10:25:26','596',0.00,0.00,'596','2022-05-17 10:00:52','797','2022-05-17 10:01:26',10,0),('5','174',257652,'Daily shipt','2022-05-17','2022-05-17 10:10:29','2022-05-18 10:10:29','596',0.00,0.00,'596','2022-05-17 20:43:22','797','2022-05-18 07:14:03',10,0),('5','174',257653,'Daily shipt','2022-05-18','2022-05-18 08:49:38','2022-05-19 08:49:38','596',0.00,0.00,'596','2022-05-18 21:15:55','797','2022-05-19 06:19:46',10,0),('5','174',257654,'Daily shipt','2022-05-19','2022-05-19 15:41:58','2022-05-20 15:41:58','596',0.00,0.00,'596','2022-05-19 20:48:51','797','2022-05-19 22:33:09',10,0),('5','174',257655,'Daily shipt','2022-05-20','2022-05-20 09:20:11','2022-05-21 09:20:11','596',0.00,0.00,'596','2022-05-20 20:47:28','797','2022-05-20 22:34:51',10,0),('5','174',257656,'Daily shipt','2022-05-21','2022-05-21 06:34:13','2022-05-22 06:34:13','596',0.00,0.00,'596','2022-05-21 23:13:01','797','2022-05-22 19:52:30',10,0),('5','174',257657,'Daily shift','2022-05-22','2022-05-22 20:59:13','2022-05-23 20:59:13','596',0.00,0.00,'596','2022-05-22 20:59:46','797','2022-05-23 05:43:08',10,0),('5','174',257658,'Daily shipt','2022-05-23','2022-05-23 13:31:47','2022-05-24 13:31:47','596',0.00,0.00,'596','2022-05-23 22:36:53','797','2022-05-24 06:28:29',10,0),('5','174',257659,'Daily shift','2022-05-24','2022-05-24 08:12:52','2022-05-25 08:12:52','596',355248.30,355248.30,'596','2022-05-25 01:52:59','797','2022-05-25 07:31:01',10,0),('5','174',257660,'Daily shift','2022-05-25','2022-05-25 08:24:10','2022-05-26 08:24:10','596',762469.95,762469.95,'596','2022-05-26 03:57:57','797','2022-05-26 05:41:58',10,0),('5','174',257661,'Daily shift','2022-05-26','2022-05-26 09:38:44','2022-05-27 09:38:44','596',779563.95,779563.95,'596','2022-05-26 21:36:42','797','2022-05-27 05:53:41',10,0),('5','174',257662,'Daily shift','2022-05-27','2022-05-28 08:25:58','2022-05-29 08:25:58','596',832014.15,832014.15,'596','2022-05-28 08:32:09','797','2022-05-28 09:48:14',10,0),('5','174',257663,'Daily shift','2022-05-28','2022-05-29 07:18:03','2022-05-30 07:18:03','596',847101.75,847101.75,'596','2022-05-29 07:23:39','797','2022-05-29 09:42:41',10,0),('5','174',257664,'Daily shift','2022-05-29','2022-05-29 22:52:56','2022-05-30 22:52:56','596',851586.45,851586.45,'596','2022-05-29 22:57:28','797','2022-05-30 06:26:22',10,0),('5','174',257665,'Daily shift it','2022-05-30','2022-05-31 06:24:11','2022-06-01 06:24:11','596',365475.00,365475.00,'596','2022-05-31 06:26:49','797','2022-05-31 10:02:58',10,0),('5','174',257666,'Daily shift','2022-05-31','2022-05-31 13:25:58','2022-06-01 13:25:58','596',0.00,0.00,'596','2022-06-01 06:26:09','797','2022-06-01 11:49:54',10,0),('5','174',257667,'Daily shift','2022-06-01','2022-06-01 19:45:22','2022-06-02 19:45:22','596',0.00,0.00,'596','2022-06-01 19:46:05','797','2022-06-02 05:40:56',10,0),('5','174',257668,'Daily shift','2022-06-02','2022-06-02 21:37:56','2022-06-03 21:37:56','596',0.00,0.00,'596','2022-06-02 21:50:50','797','2022-06-03 05:47:53',10,0),('5','174',257669,'Daily shift','2022-06-03','2022-06-04 06:19:34','2022-06-05 06:19:34','596',0.00,0.00,'596','2022-06-04 06:20:17','797','2022-06-04 07:48:30',10,0),('5','174',257670,'Daily shift','2022-06-04','2022-06-04 19:36:32','2022-06-05 19:36:32','596',301186.05,301186.05,'596','2022-06-04 19:43:23','797','2022-06-05 08:11:49',10,0),('5','174',257671,'Daily shift','2022-06-05','2022-06-06 01:48:57','2022-06-07 01:48:57','596',827435.40,827435.40,'596','2022-06-06 02:00:34','797','2022-06-06 09:47:34',10,0),('5','174',257672,'Daily shift','2022-06-06','2022-06-07 06:03:40','2022-06-08 06:03:40','596',696088.80,696088.80,'596','2022-06-07 06:12:57','797','2022-06-07 06:51:35',10,0),('5','174',257673,'Daily shift','2022-06-07','2022-06-07 06:55:27','2022-06-08 06:55:27','596',843841.35,843841.35,'596','2022-06-07 22:46:13','797','2022-06-08 09:06:01',10,0),('5','174',257674,'Daily shift','2022-06-08','2022-06-08 11:42:16','2022-06-09 11:42:16','596',713260.35,713260.35,'596','2022-06-09 12:17:18','797','2022-06-09 14:11:03',10,0),('5','174',257675,'Daily shift','2022-06-09','2022-06-09 18:10:23','2022-06-10 18:10:23','596',682852.50,682852.50,'596','2022-06-09 23:10:49','797','2022-06-10 05:47:10',10,0),('5','174',257676,'Daily shift','2022-06-10','2022-06-11 06:49:45','2022-06-12 06:49:45','596',661820.61,661820.61,'596','2022-06-11 06:52:54','797','2022-06-12 12:35:12',10,0),('5','174',257677,'Daily shift','2022-06-11','2022-06-13 04:34:15','2022-06-14 04:34:15','596',629351.25,629351.25,'596','2022-06-13 04:41:08','797','2022-06-13 07:04:06',10,0),('5','174',257678,'Daily shift','2022-06-12','2022-06-13 12:15:51','2022-06-14 12:15:51','596',682151.25,682151.25,'596','2022-06-14 05:41:23','797','2022-06-14 06:50:11',10,0),('5','174',257679,'Daily shift','2022-06-13','2022-06-14 08:00:40','2022-06-15 08:00:40','596',519296.25,519296.25,'596','2022-06-14 08:08:06','797','2022-06-14 10:54:06',10,0),('5','174',257680,'Daily shift','2022-06-14','2022-06-15 10:16:56','2022-06-16 10:16:56','596',0.00,0.00,'596','2022-06-15 10:17:48','797','2022-06-15 10:19:33',10,0),('5','174',257681,'Daily shift','2022-06-15','2022-06-15 10:21:40','2022-06-16 10:21:40','596',0.00,0.00,'596','2022-06-15 10:24:41','797','2022-06-16 06:59:53',10,0),('5','174',257682,'Daily shift is','2022-06-16','2022-06-16 08:23:58','2022-06-17 08:23:58','596',0.00,0.00,'596','2022-06-17 09:02:33','797','2022-06-17 09:41:52',10,0),('5','174',257683,'Daily shift','2022-06-17','2022-06-17 10:30:26','2022-06-18 10:30:26','596',0.00,0.00,'596','2022-06-17 10:31:53','797','2022-06-18 07:33:39',10,0),('5','174',257684,'Daily shift','2022-06-18','2022-06-18 09:20:51','2022-06-19 09:20:51','596',84517.95,84517.95,'596','2022-06-19 03:24:00','797','2022-06-19 06:59:42',10,0),('5','174',257685,'Daily shift','2022-06-19','2022-06-20 06:26:14','2022-06-21 06:26:14','596',0.00,0.00,'596','2022-06-20 06:27:03','797','2022-06-20 12:09:18',10,0),('5','174',257686,'Daily shift','2022-06-20','2022-06-20 16:25:30','2022-06-21 16:25:30','596',0.00,0.00,'596','2022-06-21 02:27:44','797','2022-06-21 06:19:39',10,0),('5','174',257687,'Daily shift','2022-06-21','2022-06-22 05:59:12','2022-06-23 05:59:12','596',0.00,0.00,'596','2022-06-22 05:59:56','797','2022-06-22 07:33:26',10,0),('5','174',257688,'Daily shift','2022-06-22','2022-06-23 05:46:15','2022-06-24 05:46:15','596',0.00,0.00,'596','2022-06-23 05:46:50','797','2022-06-23 07:15:16',10,0),('5','174',257689,'Daily shift','2022-06-23','2022-06-23 21:17:15','2022-06-24 21:17:15','596',0.00,0.00,'596','2022-06-23 21:18:19','797','2022-06-24 07:04:31',10,0),('5','174',257690,'Daily shift','2022-06-24','2022-06-24 10:08:11','2022-06-25 10:08:11','596',0.00,0.00,'596','2022-06-24 23:26:08','797','2022-06-25 07:55:51',10,0),('5','174',257691,'Daily shift','2022-06-25','2022-06-26 05:32:06','2022-06-27 05:32:06','596',0.00,0.00,'596','2022-06-26 05:32:36','797','2022-06-26 09:02:01',10,0),('5','174',257692,'Daily shipt','2022-06-26','2022-06-26 10:27:40','2022-06-27 10:27:40','596',0.00,0.00,'596','2022-06-27 06:05:08','797','2022-06-27 09:41:40',10,0),('5','174',257693,'Daily shift is','2022-06-27','2022-06-27 23:25:48','2022-06-28 23:25:48','596',0.00,0.00,'596','2022-06-27 23:26:22','797','2022-06-28 09:38:35',10,0),('5','174',257694,'Daily shift','2022-06-28','2022-06-28 21:50:44','2022-06-29 21:50:44','596',0.00,0.00,'596','2022-06-28 21:51:11','797','2022-06-29 09:29:48',10,0),('5','174',257695,'Daily shift','2022-06-29','2022-06-29 11:51:13','2022-06-30 11:51:13','596',0.00,0.00,'596','2022-06-29 11:51:53','797','2022-06-30 07:19:09',10,0),('5','174',257696,'Daily shift','2022-06-30','2022-06-30 20:26:34','2022-07-01 20:26:34','596',0.00,0.00,'596','2022-06-30 20:27:04','797','2022-07-01 07:32:25',10,0),('5','174',257697,'Daily shift','2022-07-01','2022-07-01 23:07:12','2022-07-02 23:07:12','596',0.00,0.00,'596','2022-07-01 23:07:50','797','2022-07-02 09:06:55',10,0),('5','174',257698,'Daily shift','2022-07-02','2022-07-03 09:35:13','2022-07-04 09:35:13','596',0.00,0.00,'596','2022-07-03 09:36:16','797','2022-07-03 09:49:20',10,0),('5','174',257699,'Daily shift','2022-07-03','2022-07-04 01:23:12','2022-07-05 01:23:12','596',0.00,0.00,'596','2022-07-04 01:23:38','797','2022-07-04 07:01:26',10,0),('5','174',257700,'Daily shift','2022-07-04','2022-07-04 23:24:35','2022-07-05 23:24:35','596',0.00,0.00,'596','2022-07-04 23:25:11','797','2022-07-05 06:33:14',10,0),('5','174',257701,'Daily shift','2022-07-05','2022-07-05 21:30:20','2022-07-06 21:30:20','596',0.00,0.00,'596','2022-07-05 21:31:27','797','2022-07-06 06:28:00',10,0),('5','174',257702,'Daily shift','2022-07-06','2022-07-06 14:09:54','2022-07-07 14:09:54','596',0.00,0.00,'596','2022-07-07 05:50:06','797','2022-07-07 06:52:40',10,0),('5','174',257703,'Daily shift','2022-07-07','2022-07-07 15:00:36','2022-07-08 15:00:36','596',0.00,0.00,'596','2022-07-08 07:33:16','797','2022-07-08 09:11:29',10,0),('5','174',257704,'Daily shift','2022-07-08','2022-07-08 23:06:55','2022-07-09 23:06:55','596',810592.20,810592.20,'596','2022-07-09 14:06:27','797','2022-07-09 15:18:48',10,0),('5','174',257705,'Daily shift','2022-07-09','2022-07-10 07:32:41','2022-07-11 07:32:41','596',695983.20,695983.20,'596','2022-07-10 07:41:05','797','2022-07-10 13:25:40',10,0),('5','174',257706,'Daily shift','2022-07-10','2022-07-10 22:53:21','2022-07-11 22:53:21','596',602604.75,602604.75,'596','2022-07-10 22:58:57','797','2022-07-11 07:40:45',10,0),('5','174',257707,'Daily shift','2022-07-11','2022-07-11 08:10:34','2022-07-12 08:10:34','596',516171.15,516171.15,'596','2022-07-12 07:02:11','797','2022-07-12 08:43:09',10,0),('5','174',257708,'Daily shift','2022-07-12','2022-07-12 22:42:00','2022-07-13 22:42:00','596',171436.65,192216.85,'596','2022-07-12 22:52:58','606','2022-07-13 06:13:21',10,0),('5','174',257709,'Daily shift','2022-07-13','2022-07-13 07:54:00','2022-07-14 07:54:00','596',0.00,0.00,'596','2022-07-14 07:57:50','797','2022-07-14 09:28:50',10,0),('5','174',257710,'Daily shift','2022-07-14','2022-07-15 06:52:02','2022-07-16 06:52:02','596',631257.00,707773.00,'596','2022-07-15 11:37:12','797','2022-07-15 11:38:25',10,0),('5','174',257711,'Daily shift or is','2022-07-15','2022-07-15 11:43:56','2022-07-16 11:43:56','596',951392.10,951392.10,'596','2022-07-16 05:50:11','797','2022-07-16 08:23:03',10,0),('5','174',257712,'Daily shift','2022-07-16','2022-07-17 05:52:18','2022-07-18 05:52:18','596',1030947.65,1030947.65,'596','2022-07-17 05:57:38','797','2022-07-17 06:05:43',10,0),('5','174',257713,'Daily shift','2022-07-17','2022-07-17 22:23:02','2022-07-18 22:23:02','596',1154028.15,1154028.15,'596','2022-07-17 22:40:18','797','2022-07-18 07:34:42',10,0),('5','174',257714,'Daily shift','2022-07-18','2022-07-19 07:11:53','2022-07-20 07:11:53','596',1130394.40,1130394.40,'596','2022-07-19 12:45:00','797','2022-07-19 12:50:17',10,0),('5','174',257715,'Daily shipt','2022-07-19','2022-07-20 08:15:50','2022-07-21 08:15:50','596',1225221.70,1225221.70,'596','2022-07-20 08:31:14','797','2022-07-20 09:43:56',10,0),('5','174',257716,'Daily shift','2022-07-20','2022-07-20 14:42:56','2022-07-21 14:42:56','596',1310436.40,1310436.40,'596','2022-07-21 07:23:16','797','2022-07-21 07:46:58',10,0),('5','174',257717,'Daily shift','2022-07-21','2022-07-21 17:32:47','2022-07-22 17:32:47','596',1021061.25,1021061.25,'596','2022-07-22 02:37:59','797','2022-07-22 07:02:30',10,0),('5','174',257718,'Daily shift','2022-07-22','2022-07-22 07:53:30','2022-07-23 07:53:30','596',858914.30,858914.30,'596','2022-07-23 05:58:39','797','2022-07-23 07:31:07',10,0),('5','174',257719,'Daily shift','2022-07-23','2022-07-23 18:47:09','2022-07-24 18:47:09','596',1005824.65,897086.85,'596','2022-07-23 21:30:31','797','2022-07-24 06:58:23',10,0),('5','174',257720,'Daily shift','2022-07-24','2022-07-24 07:23:25','2022-07-25 07:23:25','596',944256.65,842174.85,'596','2022-07-25 08:33:43','797','2022-07-25 09:27:42',10,0),('5','174',257721,'Daily shift','2022-07-26','2022-07-26 05:52:50','2022-07-27 05:52:50','596',926546.60,926546.60,'596','2022-07-26 06:09:35','797','2022-07-26 07:43:54',10,0),('5','174',257722,'Daily shift','2022-07-26','2022-07-26 07:47:53','2022-07-27 07:47:53','596',0.00,0.00,'596','2022-07-26 21:37:10','797','2022-07-27 06:58:20',10,0),('5','174',257723,'Daily shift','2022-07-27','2022-07-27 18:20:57','2022-07-28 18:20:57','596',0.00,0.00,'596','2022-07-27 18:21:51','797','2022-07-28 08:59:55',10,0),('5','174',257724,'Daily shift','2022-07-28','2022-07-28 22:29:50','2022-07-29 22:29:50','596',0.00,0.00,'596','2022-07-28 22:30:29','797','2022-07-29 06:59:13',10,0),('5','174',257725,'Daily shift','2022-07-29','2022-07-29 17:43:33','2022-07-30 17:43:33','596',0.00,0.00,'596','2022-07-29 17:44:05','797','2022-07-30 07:02:06',10,0),('5','174',257726,'Daily shift','2022-07-30','2022-07-31 05:37:28','2022-08-01 05:37:28','596',0.00,0.00,'596','2022-07-31 05:37:58','797','2022-07-31 06:00:14',10,0),('5','174',257727,'Daily shift','2022-07-31','2022-07-31 13:15:23','2022-08-01 13:15:23','596',0.00,0.00,'596','2022-07-31 13:16:18','797','2022-08-01 06:50:04',10,0),('5','174',257728,'Daily shift','2022-08-01','2022-08-02 10:21:51','2022-08-03 10:21:51','596',465972.45,465972.45,'596','2022-08-02 10:28:08','797','2022-08-02 10:31:26',10,0),('5','174',257729,'Daily shift','2022-08-02','2022-08-03 06:42:47','2022-08-04 06:42:47','596',1008869.75,1008869.75,'596','2022-08-03 06:47:04','797','2022-08-03 06:59:30',10,0),('5','174',257730,'Daily shift','2022-08-03','2022-08-03 21:40:06','2022-08-04 21:40:06','596',885511.75,885511.75,'596','2022-08-03 21:43:19','797','2022-08-04 06:53:02',10,0),('5','174',257731,'Daily shipt','2022-08-04','2022-08-04 20:46:58','2022-08-05 20:46:58','596',933811.55,933811.55,'596','2022-08-04 20:56:11','797','2022-08-05 06:38:50',10,0),('5','174',257732,'Daily shift','2022-08-05','2022-08-05 23:29:54','2022-08-06 23:29:54','596',966482.55,966482.55,'596','2022-08-05 23:32:05','797','2022-08-06 09:12:37',10,0),('5','174',257733,'Daily shift','2022-08-06','2022-08-06 18:28:22','2022-08-07 18:28:22','596',892397.45,892397.45,'596','2022-08-06 18:40:51','797','2022-08-07 07:14:22',10,0),('5','174',257734,'Daily shift','2022-08-07','2022-09-06 10:29:25','2022-09-07 10:29:25','596',390705.20,390705.20,'596','2022-09-06 10:36:03','797','2022-09-06 10:38:15',10,0),('5','174',257735,'Daily shift','2022-08-10','2022-09-06 10:40:41','2022-09-07 10:40:41','596',0.00,0.00,'596','2022-09-06 10:47:58','797','2022-09-06 10:50:40',10,0),('5','174',257736,'Daily shift','2022-08-09','2022-09-06 10:53:53','2022-09-07 10:53:53','596',0.00,0.00,'596','2022-09-06 10:54:46','797','2022-09-06 10:56:01',10,0),('5','174',257737,'Daily shift','2022-08-10','2022-09-06 11:05:36','2022-09-07 11:05:36','596',583628.75,583628.75,'596','2022-09-06 11:13:32','797','2022-09-06 11:15:32',10,0),('5','174',257738,'Daily shift','2022-08-11','2022-09-06 11:16:38','2022-09-07 11:16:38','596',1111324.60,1111324.60,'596','2022-09-06 11:43:49','797','2022-09-06 11:44:39',10,0),('5','174',257739,'Daily shift ma','2022-08-12','2022-09-06 11:58:49','2022-09-07 11:58:49','596',956192.85,956192.85,'596','2022-09-06 12:02:58','797','2022-09-06 12:10:17',10,0),('5','174',257740,'Daily shift','2022-08-13','2022-09-06 12:15:36','2022-09-07 12:15:36','596',998896.40,998896.40,'596','2022-09-06 12:20:36','797','2022-09-06 12:23:54',10,0),('5','174',257741,'Daily shift','2022-08-14','2022-09-06 14:24:21','2022-09-07 14:24:21','596',1040144.00,1040144.00,'596','2022-09-06 16:34:56','797','2022-09-06 16:37:31',10,0),('5','174',257742,'Daily shiftfvg','2022-08-15','2022-09-06 16:46:10','2022-09-07 16:46:10','596',1280264.75,1280264.75,'596','2022-09-06 16:52:46','797','2022-09-06 16:55:00',10,0),('5','174',257743,'Daily shift','2022-08-16','2022-09-06 16:58:28','2022-09-07 16:58:28','596',1243784.60,1243784.60,'596','2022-09-07 09:50:41','797','2022-09-07 09:54:26',10,0),('5','174',257744,'Daily shift is','2022-08-17','2022-09-07 09:57:54','2022-09-08 09:57:54','596',1266330.55,1266330.55,'596','2022-09-07 10:00:20','797','2022-09-07 10:03:37',10,0),('5','174',257745,'Daily shift','2022-08-18','2022-09-07 10:05:35','2022-09-08 10:05:35','596',1189030.15,1189030.15,'596','2022-09-07 12:46:46','797','2022-09-07 12:49:11',10,0),('5','174',257746,'Daily shift','2022-08-19','2022-09-07 12:51:25','2022-09-08 12:51:25','596',1314243.70,1314243.70,'596','2022-09-07 12:52:49','797','2022-09-07 13:08:11',10,0),('5','174',257747,'Daily shift','2022-08-20','2022-09-07 13:12:48','2022-09-08 13:12:48','596',1062573.40,1062573.40,'596','2022-09-07 13:15:25','797','2022-09-07 13:16:41',10,0),('5','174',257748,'Daily shift','2022-08-21','2022-09-07 13:18:09','2022-09-08 13:18:09','596',890308.80,890308.80,'596','2022-09-07 13:21:14','797','2022-09-07 13:22:25',10,0),('5','174',257749,'Daily shift','2022-08-22','2022-09-07 13:24:12','2022-09-08 13:24:12','596',965947.90,965947.90,'596','2022-09-07 15:37:28','797','2022-09-07 15:47:04',10,0),('5','174',257750,'Daily shift','2022-08-23','2022-09-07 16:38:03','2022-09-08 16:38:03','596',877340.30,877340.30,'596','2022-09-07 16:40:08','797','2022-09-07 16:42:50',10,0),('5','174',257751,'Daily shift','2022-08-24','2022-09-07 16:46:10','2022-09-08 16:46:10','596',378593.25,378593.25,'596','2022-09-07 17:05:57','797','2022-09-07 17:24:55',10,0),('5','174',257752,'Daily shift','2022-08-25','2022-09-08 09:16:25','2022-09-09 09:16:25','596',594691.75,594691.75,'596','2022-09-08 09:21:43','797','2022-09-08 09:28:55',10,0),('5','174',257753,'Daily shift','2022-08-26','2022-09-08 09:30:03','2022-09-09 09:30:03','596',966774.85,966774.85,'596','2022-09-08 09:31:56','797','2022-09-08 09:37:10',10,0),('5','174',257754,'Daily shift','2022-08-27','2022-09-08 09:39:23','2022-09-09 09:39:23','596',1151465.90,1151465.90,'596','2022-09-08 09:41:52','797','2022-09-08 09:43:32',10,0),('5','174',257755,'Daily shift','2022-08-28','2022-09-08 09:46:27','2022-09-09 09:46:27','596',1112038.70,1112038.70,'596','2022-09-08 09:48:21','797','2022-09-08 09:49:07',10,0),('5','174',257756,'Daily shift','2022-08-29','2022-09-08 09:51:59','2022-09-09 09:51:59','596',1057907.70,1057907.70,'596','2022-09-08 09:54:52','797','2022-09-08 09:55:57',10,0),('5','174',257757,'Daily shift','2022-08-30','2022-09-08 09:57:42','2022-09-09 09:57:42','596',1136736.20,1136736.20,'596','2022-09-08 09:59:05','797','2022-09-08 10:00:10',10,0),('5','174',257758,'Daily shift','2022-08-31','2022-09-08 10:01:32','2022-09-09 10:01:32','596',1872899.30,1872899.30,'596','2022-09-08 11:07:05','797','2022-09-08 11:09:22',10,0),('5','174',257759,'Daily shift it','2022-09-01','2022-09-08 11:13:55','2022-09-09 11:13:55','596',2035793.65,2035793.65,'596','2022-09-08 11:17:59','797','2022-09-08 11:18:44',10,0),('5','174',257760,'Daily shift','2022-09-02','2022-09-08 11:19:34','2022-09-09 11:19:34','596',2145234.10,2145234.10,'596','2022-09-08 11:31:19','797','2022-09-08 11:36:44',10,0),('5','174',257761,'Daily shift','2022-09-03','2022-09-08 11:42:31','2022-09-09 11:42:31','596',1893752.50,1893752.50,'596','2022-09-08 11:48:16','797','2022-09-08 11:49:59',10,0),('5','174',257762,'Daily shift','2022-09-04','2022-09-08 11:51:31','2022-09-09 11:51:31','596',965209.75,965209.75,'596','2022-09-08 11:53:25','797','2022-09-08 11:55:27',10,0),('5','174',257763,'Daily shift','2022-09-05','2022-09-08 11:56:30','2022-09-09 11:56:30','596',1116737.70,1116737.70,'596','2022-09-08 12:52:30','797','2022-09-08 12:58:27',10,0),('5','174',257764,'Daily shift ','2022-09-06','2022-09-08 13:02:03','2022-09-09 13:02:03','596',1630998.85,1630998.85,'596','2022-09-08 16:22:32','797','2022-09-08 16:23:12',10,0),('5','174',257765,'Daily shift','2022-09-07','2022-09-08 16:33:09','2022-09-09 16:33:09','596',1853907.20,1853907.20,'596','2022-09-08 16:36:21','797','2022-09-08 16:38:18',10,0),('5','174',257766,'Daily shift','2022-09-08','2022-09-08 16:46:46','2022-09-09 16:46:46','596',1667190.40,1667190.40,'596','2022-09-09 09:23:52','797','2022-09-09 09:27:00',10,0),('5','174',257767,'Daily shift','2022-09-09','2022-09-10 03:04:44','2022-09-11 03:04:44','596',2629112.70,2629112.70,'596','2022-09-10 06:05:05','797','2022-09-10 10:18:58',10,0),('5','174',257768,'Daily shift','2022-09-10','2022-09-10 19:32:13','2022-09-11 19:32:13','596',855802.60,763283.40,'596','2022-09-11 11:21:11','797','2022-09-12 06:25:55',10,0),('5','174',257769,'Daily shift','2022-09-11','2022-09-12 08:57:58','2022-09-13 08:57:58','596',1114267.95,1114267.95,'596','2022-09-12 09:01:52','797','2022-09-12 09:37:11',10,0),('5','174',257770,'Daily shift','2022-09-12','2022-09-12 11:31:53','2022-09-13 11:31:53','596',801236.85,801236.85,'596','2022-09-13 06:32:07','797','2022-09-13 07:02:32',10,0),('5','174',257771,'Daily shift','2022-09-13','2022-09-13 21:50:28','2022-09-14 21:50:28','596',244943.70,244943.70,'596','2022-09-13 21:53:39','797','2022-09-14 09:18:02',10,0),('5','174',257772,'Daily shift','2022-09-14','2022-09-14 11:09:22','2022-09-15 11:09:22','596',1045451.65,1045451.65,'596','2022-09-16 09:53:16','797','2022-09-16 09:56:21',10,0),('5','174',257773,'Daily shift','2022-09-15','2022-09-16 09:58:43','2022-09-17 09:58:43','596',1605104.40,1605104.40,'596','2022-09-16 10:06:03','797','2022-09-16 11:01:07',10,0),('5','174',257774,'Daily shift','2022-09-16','2022-09-16 22:41:57','2022-09-17 22:41:57','596',1509598.15,1509598.15,'596','2022-09-16 23:02:06','797','2022-09-17 07:57:13',10,0),('5','174',257775,'Daily shift','2022-09-17','2022-09-18 08:04:00','2022-09-19 08:04:00','596',1171088.85,1171088.85,'596','2022-09-18 08:07:10','797','2022-09-18 10:40:14',10,0),('5','174',257776,'Daily shift','2022-09-18','2022-09-19 07:55:13','2022-09-20 07:55:13','596',1169064.95,1169064.95,'596','2022-09-19 08:04:41','797','2022-09-19 10:48:31',10,0),('5','174',257777,'Daily shift','2022-09-19','2022-09-19 12:21:32','2022-09-20 12:21:32','596',2139967.15,2139967.15,'596','2022-09-20 15:44:35','797','2022-09-20 16:53:55',10,0),('5','174',257778,'Daily shift','2022-09-20','2022-09-20 22:26:22','2022-09-21 22:26:22','596',1252958.75,1252958.75,'596','2022-09-20 22:29:18','797','2022-09-21 07:10:37',10,0),('5','174',257779,'Daily shift','2022-09-21','2022-09-21 09:50:03','2022-09-22 09:50:03','596',1891835.90,1891835.90,'596','2022-09-22 04:32:52','797','2022-09-22 09:17:08',10,0),('5','174',257780,'Daily shift','2022-09-22','2022-09-22 14:40:27','2022-09-23 14:40:27','596',1554599.40,1554599.40,'596','2022-09-23 06:53:56','797','2022-09-23 10:20:13',10,0),('5','174',257781,'Daily shift','2022-09-23','2022-09-24 06:11:08','2022-09-25 06:11:08','596',1210760.25,1210760.25,'596','2022-09-24 06:13:20','797','2022-09-24 08:51:51',10,0),('5','174',257782,'Daily shift','2022-09-24','2022-09-25 06:17:09','2022-09-26 06:17:09','596',1063842.50,1063842.50,'596','2022-09-25 06:28:13','797','2022-09-25 07:03:11',10,0),('5','174',257783,'Daily shift','2022-09-25','2022-09-26 09:35:38','2022-09-27 09:35:38','596',1547858.00,1380522.00,'596','2022-09-26 09:37:26','797','2022-09-26 10:06:15',10,0),('5','174',257784,'Daily shift','2022-09-26','2022-09-27 09:40:31','2022-09-28 09:40:31','596',2074971.10,2074971.10,'596','2022-09-27 09:49:08','797','2022-09-27 13:27:26',10,0),('5','174',257785,'Daily shift','2022-09-27','2022-09-27 21:14:21','2022-09-28 21:14:21','596',1549867.10,1549867.10,'596','2022-09-27 21:19:44','797','2022-09-28 06:41:30',10,0),('5','174',257786,'Daily shift','2022-09-28','2022-09-29 04:10:59','2022-09-30 04:10:59','596',1947137.95,1947137.95,'596','2022-09-29 04:18:32','797','2022-09-29 07:14:21',10,0),('5','174',257787,'Daily shift','2022-09-29','2022-09-30 06:22:03','2022-10-01 06:22:03','596',2549033.60,2549033.60,'596','2022-09-30 06:24:49','797','2022-09-30 07:23:49',10,0),('5','174',257788,'Daily shift','2022-09-30','2022-09-30 12:10:56','2022-10-01 12:10:56','596',3211226.30,3211226.30,'596','2022-10-02 07:55:23','797','2022-10-02 09:54:41',10,0),('5','174',257789,'Daily shift','2022-10-01','2022-10-02 10:13:17','2022-10-03 10:13:17','596',1890907.20,1890907.20,'596','2022-10-02 10:14:42','797','2022-10-02 10:40:22',10,0),('5','174',257790,'Daily shift','2022-10-02','2022-10-02 14:40:46','2022-10-03 14:40:46','596',1316589.50,1316589.50,'596','2022-10-03 03:51:57','797','2022-10-03 09:48:52',10,0),('5','174',257791,'Daily shipt','2022-10-03','2022-10-03 12:12:51','2022-10-04 12:12:51','596',572809.95,572809.95,'596','2022-10-04 06:17:17','797','2022-10-04 07:13:06',10,0),('5','174',257792,'Daily shift','2022-10-04','2022-10-04 21:51:36','2022-10-05 21:51:36','596',0.00,0.00,'596','2022-10-04 21:52:28','797','2022-10-05 10:05:55',10,0),('5','174',257793,'Daily shift','2022-10-05','2022-10-06 05:52:02','2022-10-07 05:52:02','596',0.00,0.00,'596','2022-10-06 05:52:39','797','2022-10-06 06:58:40',10,0),('5','174',257794,'Daily shift','2022-10-06','2022-10-06 21:12:25','2022-10-07 21:12:25','596',0.00,0.00,'596','2022-10-06 21:13:19','797','2022-10-07 06:58:07',10,0),('5','174',257795,'Daily shift','2022-10-07','2022-10-08 08:17:44','2022-10-09 08:17:44','596',0.00,0.00,'596','2022-10-08 08:18:31','797','2022-10-08 11:36:19',10,0),('5','174',257796,'Daily shift','2022-10-08','2022-10-08 23:26:33','2022-10-09 23:26:33','596',0.00,0.00,'596','2022-10-08 23:27:12','797','2022-10-09 07:02:19',10,0),('5','174',257797,'Daily shift','2022-10-09','2022-10-10 07:58:33','2022-10-11 07:58:33','596',0.00,0.00,'596','2022-10-10 07:59:17','797','2022-10-10 08:58:59',10,0),('5','174',257798,'Daily shift','2022-10-10','2022-10-11 07:40:54','2022-10-12 07:40:54','596',0.00,0.00,'596','2022-10-11 07:41:38','797','2022-10-11 12:15:01',10,0),('5','174',257799,'Daily shift','2022-10-11','2022-10-12 07:14:29','2022-10-13 07:14:29','596',0.00,0.00,'596','2022-10-12 07:15:16','797','2022-10-12 12:31:12',10,0),('5','174',257800,'Daily shift','2022-10-12','2022-10-13 08:59:06','2022-10-14 08:59:06','596',0.00,0.00,'596','2022-10-13 09:00:52','797','2022-10-13 09:47:56',10,0),('5','174',257801,'Daily shift','2022-10-13','2022-10-14 05:55:18','2022-10-15 05:55:18','596',0.00,0.00,'596','2022-10-14 05:55:50','797','2022-10-14 10:21:37',10,0),('5','174',257802,'Daily shift','2022-10-14','2022-10-15 12:28:57','2022-10-16 12:28:57','596',0.00,0.00,'596','2022-10-15 12:30:03','797','2022-10-15 14:09:55',10,0),('5','174',257803,'Daily shift','2022-10-15','2022-10-16 09:42:47','2022-10-17 09:42:47','596',0.00,0.00,'596','2022-10-16 09:43:32','797','2022-10-16 14:26:34',10,0),('5','174',257804,'Daily shift','2022-10-16','2022-10-17 03:13:39','2022-10-18 03:13:39','596',0.00,0.00,'596','2022-10-17 03:14:18','797','2022-10-17 20:10:10',10,0),('5','174',257805,'Daily shift','2022-10-17','2022-10-18 15:06:45','2022-10-19 15:06:45','596',707556.55,707556.55,'596','2022-10-18 15:08:54','797','2022-10-18 18:32:46',10,0),('5','174',257806,'Daily shift','2022-10-18','2022-10-19 06:50:09','2022-10-20 06:50:09','596',1492071.25,1492071.25,'596','2022-10-19 06:56:23','797','2022-10-19 09:47:12',10,0),('5','174',257807,'Daily shift','2022-10-19','2022-10-19 14:37:46','2022-10-20 14:37:46','596',1693608.40,1693608.40,'596','2022-10-20 11:11:55','797','2022-10-20 11:15:01',10,0),('5','174',257808,'Daily shipt','2022-10-20','2022-10-20 18:59:14','2022-10-21 18:59:14','596',1493157.20,1493157.20,'596','2022-10-20 19:07:52','797','2022-10-21 09:35:15',10,0),('5','174',257809,'Daily shift','2022-10-21','2022-10-21 09:59:10','2022-10-22 09:59:10','596',1446914.60,1446914.60,'596','2022-10-22 07:26:20','797','2022-10-22 10:06:02',10,0),('5','174',257810,'Daily shift','2022-10-22','2022-10-23 07:44:37','2022-10-24 07:44:37','596',1317851.20,1317851.20,'596','2022-10-23 07:46:58','797','2022-10-23 10:23:37',10,0),('5','174',257811,'Daily shift','2022-10-23','2022-10-24 05:57:20','2022-10-25 05:57:20','596',1187374.40,1187374.40,'596','2022-10-24 06:02:47','797','2022-10-24 07:32:48',10,0),('5','174',257812,'Daily shift','2022-10-24','2022-10-24 22:28:38','2022-10-25 22:28:38','596',1040351.20,1040351.20,'596','2022-10-24 22:31:42','797','2022-10-25 09:26:40',10,0),('5','174',257813,'Daily shift','2022-10-25','2022-10-26 06:03:28','2022-10-27 06:03:28','596',853038.70,853038.70,'596','2022-10-26 06:06:02','797','2022-10-26 06:09:45',10,0),('5','174',257814,'Daily shift','2022-10-26','2022-10-27 00:39:30','2022-10-28 00:39:30','596',1297096.05,1156869.45,'596','2022-10-27 00:41:49','797','2022-10-27 07:03:16',10,0),('5','174',257815,'Daily shift','2022-10-27','2022-10-28 06:56:25','2022-10-29 06:56:25','596',0.00,0.00,'596','2022-10-28 06:57:08','797','2022-10-28 08:52:31',10,0),('5','174',257816,'Daily shift','2022-10-28','2022-10-28 17:57:08','2022-10-29 17:57:08','596',0.00,0.00,'596','2022-10-28 17:57:55','797','2022-10-29 08:39:27',10,0),('5','174',257817,'Daily shift','2022-10-29','2022-10-30 12:55:27','2022-10-31 12:55:27','596',0.00,0.00,'596','2022-10-30 12:56:19','797','2022-10-30 18:55:27',10,0),('5','174',257818,'Daily shift','2022-10-30','2022-10-31 12:25:55','2022-11-01 12:25:55','596',0.00,0.00,'596','2022-10-31 12:26:51','797','2022-10-31 12:35:46',10,0),('5','174',257819,'Daily shift','2022-10-31','2022-11-01 01:05:08','2022-11-02 01:05:08','596',0.00,0.00,'596','2022-11-01 01:05:45','797','2022-11-01 07:06:32',10,0),('5','174',257820,'Daily shift ya','2022-11-01','2022-11-01 11:53:01','2022-11-02 11:53:01','596',578036.20,578036.20,'596','2022-11-02 03:34:50','797','2022-11-02 07:08:15',10,0),('5','174',257821,'Daily shift','2022-11-02','2022-11-02 08:13:36','2022-11-03 08:13:36','596',1597362.15,1597362.15,'596','2022-11-03 03:43:46','797','2022-11-03 06:38:21',10,0),('5','174',257822,'Daily shift','2022-11-03','2022-11-03 13:10:23','2022-11-04 13:10:23','596',601436.85,601436.85,'596','2022-11-04 05:53:37','797','2022-11-04 07:03:16',10,0),('5','174',257823,'Daily shift','2022-11-04','2022-11-04 18:37:50','2022-11-05 18:37:50','596',0.00,0.00,'596','2022-11-04 18:38:14','797','2022-11-05 07:27:10',10,0),('5','174',257824,'Daily shift','2022-11-05','2022-11-06 03:24:49','2022-11-07 03:24:49','596',0.00,0.00,'596','2022-11-06 03:25:27','797','2022-11-06 08:20:36',10,0),('5','174',257825,'Daily shift','2022-11-06','2022-11-07 08:44:13','2022-11-08 08:44:13','596',1132947.40,1132947.40,'596','2022-11-07 09:50:20','797','2022-11-07 14:16:57',10,0),('5','174',257826,'Daily shift','2022-11-07','2022-11-08 02:46:36','2022-11-09 02:46:36','596',938349.60,938349.60,'596','2022-11-08 02:49:15','797','2022-11-08 07:51:28',10,0),('5','174',257827,'Daily shift','2022-11-08','2022-11-08 11:49:23','2022-11-09 11:49:23','596',668595.55,668595.55,'596','2022-11-08 20:02:39','797','2022-11-09 08:39:18',10,0),('5','174',257828,'Daily shift','2022-11-09','2022-11-09 11:59:43','2022-11-10 11:59:43','596',0.00,0.00,'596','2022-11-09 19:20:57','797','2022-11-10 10:46:55',10,0),('5','174',257829,'Daily shift','2022-11-10','2022-11-10 20:28:19','2022-11-11 20:28:19','596',0.00,0.00,'596','2022-11-10 20:29:05','797','2022-11-11 11:28:42',10,0),('5','174',257830,'Daily shift','2022-11-11','2022-11-12 05:56:36','2022-11-13 05:56:36','596',0.00,0.00,'596','2022-11-12 05:57:13','797','2022-11-12 10:05:56',10,0),('5','174',257831,'Daily shift','2022-11-12','2022-11-12 18:33:32','2022-11-13 18:33:32','596',0.00,0.00,'596','2022-11-12 18:34:20','797','2022-11-12 23:51:46',10,0),('5','174',257832,'Daily shift','2022-11-13','2022-11-14 05:55:22','2022-11-15 05:55:22','596',0.00,0.00,'596','2022-11-14 05:55:53','797','2022-11-14 07:23:46',10,0),('5','174',257833,'Daily shift','2022-11-14','2022-11-14 22:13:58','2022-11-15 22:13:58','596',0.00,0.00,'596','2022-11-14 22:14:37','797','2022-11-14 23:45:02',10,0),('5','174',257834,'Daily shift','2022-11-15','2022-11-16 05:54:45','2022-11-17 05:54:45','596',0.00,0.00,'596','2022-11-16 05:55:34','797','2022-11-16 07:53:48',10,0),('5','174',257835,'Daily shift','2022-11-16','2022-11-17 06:32:30','2022-11-18 06:32:30','596',0.00,0.00,'596','2022-11-17 06:33:04','797','2022-11-17 09:37:55',10,0),('5','174',257836,'Daily shift','2022-11-17','2022-11-18 08:30:05','2022-11-19 08:30:05','596',0.00,0.00,'596','2022-11-18 08:30:44','797','2022-11-19 09:17:49',10,0),('5','174',257837,'Daily shift','2022-11-19','2022-11-19 21:58:06','2022-11-20 21:58:06','596',762755.00,680295.00,'596','2022-11-19 22:21:07','797','2022-11-20 07:30:29',10,0),('5','174',257838,'Daily shift','2022-11-19','2022-11-21 06:51:56','2022-11-22 06:51:56','596',1173825.00,1173825.00,'596','2022-11-21 06:55:03','797','2022-11-21 09:37:50',10,0),('5','174',257839,'Daily shift','2022-11-20','2022-11-21 13:48:25','2022-11-22 13:48:25','596',600325.00,600325.00,'596','2022-11-21 13:52:33','797','2022-11-21 14:11:54',10,0),('5','174',257840,'Daily shift','2022-11-21','2022-11-22 12:26:55','2022-11-23 12:26:55','596',712618.15,635578.35,'596','2022-11-22 19:15:51','797','2022-11-23 09:39:34',10,0),('5','174',257841,'Daily shift','2022-11-23','2022-11-24 07:46:54','2022-11-25 07:46:54','596',0.00,0.00,'596','2022-11-24 09:43:50','797','2022-11-24 10:12:08',10,0),('5','174',257842,'Daily shift','2022-11-22','2022-11-24 10:28:46','2022-11-25 10:28:46','596',1241990.10,1241990.10,'596','2022-11-24 10:30:56','797','2022-11-24 13:09:55',10,0),('5','174',257843,'Daily shift','2022-11-23','2022-11-24 16:00:39','2022-11-25 16:00:39','596',1297599.25,1297599.25,'596','2022-11-24 16:04:10','797','2022-11-24 16:46:49',10,0),('5','174',257844,'Daily shift','2022-11-24','2022-11-24 22:51:26','2022-11-25 22:51:26','596',1527452.50,1527452.50,'596','2022-11-24 22:55:05','797','2022-11-25 11:15:37',10,0),('5','174',257845,'Daily shift','2022-11-25','2022-11-26 06:11:10','2022-11-27 06:11:10','596',594443.85,594443.85,'596','2022-11-26 06:18:04','797','2022-11-26 07:46:56',10,0),('5','174',257846,'Daily shift','2022-11-26','2022-11-27 12:05:01','2022-11-28 12:05:01','596',594488.25,530219.25,'596','2022-11-27 12:09:40','797','2022-11-27 12:32:01',10,0),('5','174',257847,'Daily shift','2022-11-27','2022-11-28 07:22:25','2022-11-29 07:22:25','596',1120746.65,1120746.65,'596','2022-11-28 07:25:35','797','2022-11-28 09:47:52',10,0),('5','174',257848,'Daily shift','2022-11-28','2022-11-28 21:14:07','2022-11-29 21:14:07','596',324501.10,324501.10,'596','2022-11-29 04:57:34','797','2022-11-29 09:46:11',10,0),('5','174',257849,'Daily shift ','2022-11-29','2022-11-30 09:35:16','2022-12-01 09:35:16','596',0.00,0.00,'596','2022-11-30 09:35:45','797','2022-11-30 09:40:33',10,0),('5','174',257850,'Daily shift','2022-11-30','2022-11-30 18:55:21','2022-12-01 18:55:21','596',0.00,0.00,'596','2022-11-30 18:55:52','797','2022-12-01 10:44:31',10,0),('5','174',257851,'Daily shift','2022-12-01','2022-12-02 05:51:34','2022-12-03 05:51:34','596',0.00,0.00,'596','2022-12-02 05:52:09','797','2022-12-02 09:59:10',10,0),('5','174',257852,'Daily shift','2022-12-02','2022-12-03 07:53:56','2022-12-04 07:53:56','596',0.00,0.00,'596','2022-12-03 07:54:31','797','2022-12-03 10:12:18',10,0),('5','174',257853,'Daily shift','2022-12-03','2022-12-04 11:41:10','2022-12-05 11:41:10','596',0.00,0.00,'596','2022-12-04 11:41:45','797','2022-12-05 06:44:35',10,0),('5','174',257854,'Daily shift','2022-12-04','2022-12-05 08:32:33','2022-12-06 08:32:33','596',0.00,0.00,'596','2022-12-05 08:33:21','797','2022-12-05 09:01:12',10,0),('5','174',257855,'Daily shift','2022-12-05','2022-12-06 09:03:54','2022-12-07 09:03:54','596',0.00,0.00,'596','2022-12-06 09:05:03','797','2022-12-06 09:23:34',10,0),('5','174',257856,'Daily shift','2022-12-06','2022-12-06 11:41:57','2022-12-07 11:41:57','596',0.00,0.00,'596','2022-12-06 11:42:41','797','2022-12-07 09:10:51',10,0),('5','174',257857,'Daily shipt it','2022-12-07','2022-12-07 11:26:47','2022-12-08 11:26:47','596',0.00,0.00,'596','2022-12-07 11:27:30','797','2022-12-08 09:27:04',10,0),('5','174',257858,'Daily shift','2022-12-08','2022-12-09 06:05:13','2022-12-10 06:05:13','596',0.00,0.00,'596','2022-12-09 06:05:51','797','2022-12-09 09:16:53',10,0),('5','174',257859,'Daily shift','2022-12-09','2022-12-10 06:04:09','2022-12-11 06:04:09','596',0.00,0.00,'596','2022-12-10 06:04:49','797','2022-12-10 08:52:48',10,0),('5','174',257860,'Daily shift','2022-12-11','2022-12-11 05:50:48','2022-12-12 05:50:48','596',0.00,0.00,'596','2022-12-11 05:51:25','797','2022-12-11 12:27:31',10,0),('5','174',257865,'Daily shift','2022-12-11','2022-12-11 18:44:20','2022-12-12 18:44:20','596',0.00,0.00,'596','2022-12-11 18:44:54','797','2022-12-12 11:06:43',10,0),('5','174',257866,'Daily shift','2022-12-12','2022-12-12 18:29:13','2022-12-13 18:29:13','596',0.00,0.00,'596','2022-12-12 18:30:19','797','2022-12-13 09:55:15',10,0),('5','174',257867,'Daily shift','2022-12-13','2022-12-14 01:14:53','2022-12-15 01:14:53','596',0.00,0.00,'596','2022-12-14 01:15:40','797','2022-12-14 09:40:09',10,0),('5','174',257873,'Daily shift','2022-12-14','2022-12-14 12:17:49','2022-12-15 12:17:49','596',0.00,0.00,'596','2022-12-14 12:18:51','797','2022-12-15 09:51:32',10,0),('5','174',257874,'Daily shift','2022-12-15','2022-12-15 22:42:48','2022-12-16 22:42:48','596',0.00,0.00,'596','2022-12-15 22:43:34','797','2022-12-16 10:00:26',10,0),('5','174',257875,'Daily shift','2022-12-16','2022-12-17 05:51:08','2022-12-18 05:51:08','596',0.00,0.00,'596','2022-12-17 05:52:04','797','2022-12-17 12:19:24',10,0),('5','174',257876,'Daily shift','2022-12-17','2022-12-17 21:54:50','2022-12-18 21:54:50','596',0.00,0.00,'596','2022-12-17 21:55:32','797','2022-12-18 12:34:46',10,0),('5','174',257877,'Daily shift','2022-12-18','2022-12-19 07:21:28','2022-12-20 07:21:28','596',0.00,0.00,'596','2022-12-19 07:22:12','797','2022-12-19 08:59:06',10,0),('5','174',257878,'Daily shift','2022-12-19','2022-12-20 07:56:31','2022-12-21 07:56:31','596',0.00,0.00,'596','2022-12-20 07:57:09','797','2022-12-20 09:03:27',10,0),('5','174',257879,'Daily shift','2022-12-20','2022-12-20 19:07:23','2022-12-21 19:07:23','596',0.00,0.00,'596','2022-12-20 19:08:26','797','2022-12-21 09:19:34',10,0),('5','174',257880,'Daily shift','2022-12-21','2022-12-22 07:18:03','2022-12-23 07:18:03','596',0.00,0.00,'596','2022-12-22 07:22:21','797','2022-12-22 09:29:31',10,0),('5','174',257881,'Daily shift','2022-12-22','2022-12-23 11:56:45','2022-12-24 11:56:45','596',0.00,0.00,'596','2022-12-23 11:57:38','797','2022-12-23 18:38:06',10,0),('5','174',257882,'Daily shift','2022-12-23','2022-12-24 09:27:04','2022-12-25 09:27:04','596',0.00,0.00,'596','2022-12-24 09:27:55','797','2022-12-24 19:17:21',10,0),('5','174',257883,'Daily shift','2022-12-24','2022-12-25 08:09:36','2022-12-26 08:09:36','596',0.00,0.00,'596','2022-12-25 08:10:16','797','2022-12-25 11:26:22',10,0),('5','174',257884,'Daily shift','2022-12-25','2022-12-26 13:32:23','2022-12-27 13:32:23','596',0.00,0.00,'596','2022-12-26 13:33:11','797','2022-12-26 13:35:35',10,0),('5','174',257885,'Daily shift','2022-12-26','2022-12-27 08:38:18','2022-12-28 08:38:18','596',0.00,0.00,'596','2022-12-27 08:39:01','797','2022-12-27 10:51:23',10,0),('5','174',257886,'Daily shift','2022-12-27','2022-12-28 12:47:20','2022-12-29 12:47:20','596',0.00,0.00,'596','2022-12-28 12:47:54','797','2022-12-28 14:42:27',10,0),('5','174',257887,'Daily shift','2022-12-28','2022-12-28 20:21:39','2022-12-29 20:21:39','596',0.00,0.00,'596','2022-12-28 20:26:34','797','2022-12-29 10:19:16',10,0),('5','174',257888,'Daily shift','2022-12-29','2022-12-29 12:15:48','2022-12-30 12:15:48','596',0.00,0.00,'596','2022-12-29 12:16:21','797','2022-12-30 09:02:41',10,0),('5','174',257889,'Daily shift','2022-12-30','2022-12-30 10:09:57','2022-12-31 10:09:57','596',0.00,0.00,'596','2022-12-30 10:10:49','797','2022-12-31 07:07:30',10,0),('5','174',257890,'Daily shift','2022-12-31','2022-12-31 21:15:46','2023-01-01 21:15:46','596',0.00,0.00,'596','2022-12-31 21:16:21','797','2023-01-01 08:54:25',10,0),('5','174',257891,'Daily shift','2023-01-01','2023-01-01 22:43:03','2023-01-02 22:43:03','596',0.00,0.00,'596','2023-01-01 22:43:45','797','2023-01-02 08:22:39',10,0),('5','174',257892,'Daily shift','2023-01-02','2023-01-03 11:20:38','2023-01-04 11:20:38','596',0.00,0.00,'596','2023-01-03 11:22:24','797','2023-01-03 19:23:04',10,0),('5','174',257893,'Daily shift','2023-01-03','2023-01-04 06:15:01','2023-01-05 06:15:01','596',0.00,0.00,'596','2023-01-04 06:15:45','797','2023-01-04 11:25:58',10,0),('5','174',257894,'Daily shift','2023-01-04','2023-01-05 08:56:47','2023-01-06 08:56:47','596',0.00,0.00,'596','2023-01-05 08:57:19','797','2023-01-05 08:58:00',10,0),('5','174',257895,'Daily shift','2023-01-05','2023-01-06 15:36:58','2023-01-07 15:36:58','596',0.00,0.00,'596','2023-01-06 15:38:03','797','2023-01-07 05:45:18',10,0),('5','174',257896,'Daily shift','2023-01-06','2023-01-07 08:43:15','2023-01-08 08:43:15','596',0.00,0.00,'596','2023-01-07 08:43:53','797','2023-01-07 09:21:25',10,0),('5','174',257897,'Daily shift','2023-01-08','2023-01-08 09:58:35','2023-01-09 09:58:35','596',0.00,0.00,'596','2023-01-08 09:59:20','797','2023-01-08 10:06:46',10,0),('5','174',257898,'Daily shift','2023-01-08','2023-01-08 12:35:16','2023-01-09 12:35:16','596',0.00,0.00,'596','2023-01-08 12:35:42','797','2023-01-09 09:48:42',10,0),('5','174',257899,'Daily shift','2023-01-09','2023-01-09 11:19:15','2023-01-10 11:19:15','596',0.00,0.00,'596','2023-01-09 11:20:13','797','2023-01-10 09:21:51',10,0),('5','174',257903,'Daily shift','2023-01-10','2023-01-10 10:25:39','2023-01-11 10:25:39','596',0.00,0.00,'596','2023-01-11 06:30:15','797','2023-01-11 09:45:38',10,0),('5','174',257904,'Daily shift','2023-01-11','2023-01-12 07:01:53','2023-01-13 07:01:53','596',0.00,0.00,'596','2023-01-12 07:02:58','797','2023-01-12 09:33:17',10,0),('5','174',257905,'Daily shift','2023-01-12','2023-01-12 22:04:07','2023-01-13 22:04:07','596',0.00,0.00,'596','2023-01-12 22:04:40','797','2023-01-13 09:23:24',10,0),('5','174',257906,'Daily shift','2023-01-13','2023-01-13 11:41:08','2023-01-14 11:41:08','596',0.00,0.00,'596','2023-01-13 11:41:44','797','2023-01-14 16:56:21',10,0),('5','174',257915,'Daily shift','2023-01-14','2023-01-16 04:16:08','2023-01-17 04:16:08','596',577677.30,577677.30,'596','2023-01-16 10:38:06','797','2023-01-16 11:02:13',10,0),('5','174',257925,'Daily shift','2023-01-15','2023-01-16 14:51:21','2023-01-17 14:51:21','596',1321543.80,1321543.80,'596','2023-01-16 14:57:10','797','2023-01-17 10:24:35',10,0),('5','174',257926,'Daily shift','2023-01-16','2023-01-17 10:26:52','2023-01-18 10:26:52','596',983180.65,983180.65,'596','2023-01-17 10:28:56','797','2023-01-17 10:30:32',10,0),('5','174',257927,'Daily shift','2023-01-17','2023-01-17 10:38:09','2023-01-18 10:38:09','596',208036.20,208036.20,'596','2023-01-18 06:22:09','797','2023-01-18 09:17:43',10,0),('5','174',257928,'Daily shift','2023-01-18','2023-01-18 12:47:54','2023-01-19 12:47:54','596',0.00,0.00,'596','2023-01-18 12:48:24','797','2023-01-19 09:14:48',10,0),('5','174',257929,'Daily shift','2023-01-19','2023-01-20 09:15:36','2023-01-21 09:15:36','596',0.00,0.00,'596','2023-01-20 09:16:27','797','2023-01-20 09:28:04',10,0),('5','174',257930,'Daily shift','2023-01-20','2023-01-21 08:47:38','2023-01-22 08:47:38','596',0.00,0.00,'596','2023-01-21 08:48:43','797','2023-01-21 10:19:51',10,0),('5','174',257931,'Daily shift','2023-01-21','2023-01-21 21:14:17','2023-01-22 21:14:17','596',0.00,0.00,'596','2023-01-21 21:15:59','797','2023-01-22 10:46:23',10,0),('5','174',257932,'Daily shift','2023-01-12','2023-01-23 08:46:54','2023-01-24 08:46:54','596',982869.85,876613.65,'596','2023-01-23 13:26:41','797','2023-01-23 16:58:57',10,0),('5','174',257933,'Daily shift','2023-01-23','2023-01-24 14:53:27','2023-01-25 14:53:27','596',1854908.00,1854908.00,'596','2023-01-24 14:57:21','797','2023-01-24 15:29:39',10,0),('5','174',257934,'Daily shift','2023-01-24','2023-01-25 07:12:23','2023-01-26 07:12:23','596',1566809.20,1566809.20,'596','2023-01-25 07:17:43','797','2023-01-25 09:33:36',10,0),('5','174',257935,'Daily shift','2023-01-25','2023-01-26 08:39:27','2023-01-27 08:39:27','596',1608521.20,1608521.20,'596','2023-01-26 13:28:13','797','2023-01-26 13:34:47',10,0),('5','174',257936,'Daily shift','2023-01-26','2023-01-27 06:46:04','2023-01-28 06:46:04','596',376523.40,376523.40,'596','2023-01-27 06:48:50','797','2023-01-27 09:46:08',10,0),('5','174',257937,'Daily shift','2023-01-27','2023-01-28 08:56:38','2023-01-29 08:56:38','596',0.00,0.00,'596','2023-01-28 08:57:07','797','2023-01-28 09:49:34',10,0),('5','174',257938,'Daily shift','2023-01-28','2023-01-29 06:28:00','2023-01-30 06:28:00','596',0.00,0.00,'596','2023-01-29 06:28:36','797','2023-01-29 11:06:00',10,0),('5','174',257939,'Daily shift','2023-01-29','2023-01-30 08:52:37','2023-01-31 08:52:37','596',0.00,0.00,'596','2023-01-30 08:53:47','797','2023-01-30 09:24:44',10,0),('5','174',257940,'Daily shift','2023-01-30','2023-01-30 22:16:08','2023-01-31 22:16:08','596',0.00,0.00,'596','2023-01-30 22:16:43','797','2023-01-31 09:10:24',10,0),('5','174',257941,'Daily shift','2023-01-31','2023-02-01 07:34:51','2023-02-02 07:34:51','596',0.00,0.00,'596','2023-02-01 07:36:20','797','2023-02-01 13:55:26',10,0),('5','174',257942,'Daily shipt','2023-02-01','2023-02-02 10:09:41','2023-02-03 10:09:41','596',0.00,0.00,'596','2023-02-02 10:10:15','797','2023-02-02 11:32:29',10,0),('5','174',257943,'Daily shift','2023-02-02','2023-02-03 15:57:23','2023-02-04 15:57:23','596',715851.40,715851.40,'596','2023-02-03 15:59:15','797','2023-02-03 16:16:14',10,0),('5','174',257944,'Daily shift','2023-02-03','2023-02-04 07:10:35','2023-02-05 07:10:35','596',2060159.20,2060159.20,'596','2023-02-04 07:17:36','797','2023-02-04 13:21:46',10,0),('5','174',257945,'Daily shift','2023-02-04','2023-02-05 11:34:36','2023-02-06 11:34:36','596',1789051.00,1789051.00,'596','2023-02-05 11:44:46','797','2023-02-05 11:53:15',10,0),('5','174',257946,'Daily shift','2023-02-05','2023-02-06 07:27:06','2023-02-07 07:27:06','596',1571268.60,1571268.60,'596','2023-02-06 07:29:46','797','2023-02-06 09:09:48',10,0),('5','174',257947,'Daily shift','2023-02-06','2023-02-07 07:36:50','2023-02-08 07:36:50','596',467891.60,467891.60,'596','2023-02-07 07:54:18','797','2023-02-07 09:10:37',10,0),('5','174',257948,'Daily shift','2023-02-07','2023-02-08 08:29:13','2023-02-09 08:29:13','596',0.00,0.00,'596','2023-02-08 08:29:54','797','2023-02-08 09:26:39',10,0),('5','174',257949,'Daily shift','2023-02-08','2023-02-08 21:14:59','2023-02-09 21:14:59','596',0.00,0.00,'596','2023-02-08 21:27:49','797','2023-02-09 09:26:12',10,0),('5','174',257950,'Daily shift it','2023-02-09','2023-02-10 14:29:48','2023-02-11 14:29:48','596',0.00,0.00,'596','2023-02-10 14:30:56','797','2023-02-10 14:48:19',10,0),('5','174',257951,'Daily shift','2023-02-10','2023-02-11 08:47:05','2023-02-12 08:47:05','596',696319.80,696319.80,'596','2023-02-12 09:46:04','797','2023-02-12 13:23:22',10,0),('5','174',257952,'Daily shift','2023-02-11','2023-02-12 13:57:32','2023-02-13 13:57:32','596',1807082.20,1807082.20,'596','2023-02-12 15:01:11','797','2023-02-12 15:37:09',10,0),('5','174',257953,'Daily shift','2023-02-12','2023-02-12 20:46:19','2023-02-13 20:46:19','596',803220.00,803220.00,'596','2023-02-12 20:49:01','797','2023-02-13 09:15:20',10,0),('5','174',257954,'Daily shift','2023-02-13','2023-02-14 03:47:20','2023-02-15 03:47:20','596',0.00,0.00,'596','2023-02-14 03:48:13','797','2023-02-14 09:38:20',10,0),('5','174',257955,'Daily shift','2023-02-14','2023-02-15 08:48:04','2023-02-16 08:48:04','596',0.00,0.00,'596','2023-02-15 08:48:37','797','2023-02-15 09:26:08',10,0),('5','174',257956,'Daily shift','2023-02-15','2023-02-16 08:10:56','2023-02-17 08:10:56','596',0.00,0.00,'596','2023-02-16 08:11:33','797','2023-02-16 08:51:04',10,0),('5','174',257957,'Daily shift','2023-02-16','2023-02-16 15:46:31','2023-02-17 15:46:31','596',0.00,0.00,'596','2023-02-16 15:47:05','797','2023-02-17 12:23:42',10,0),('5','174',257958,'Daily shift','2023-02-17','2023-02-18 06:51:26','2023-02-19 06:51:26','596',0.00,0.00,'596','2023-02-18 06:51:59','797','2023-02-18 16:32:05',10,0),('5','174',257959,'Daily shift','2023-02-18','2023-02-18 21:20:24','2023-02-19 21:20:24','596',0.00,0.00,'596','2023-02-19 09:29:24','797','2023-02-19 10:02:07',10,0),('5','174',257960,'Daily shift','2023-02-19','2023-02-20 06:29:12','2023-02-21 06:29:12','596',0.00,0.00,'596','2023-02-20 06:29:55','797','2023-02-20 09:20:49',10,0),('5','174',257961,'Daily shift','2023-02-20','2023-02-20 13:27:22','2023-02-21 13:27:22','596',0.00,0.00,'596','2023-02-20 13:28:18','797','2023-02-21 08:54:30',10,0),('5','174',257962,'Daily shift','2023-02-21','2023-02-22 06:34:53','2023-02-23 06:34:53','596',0.00,0.00,'596','2023-02-22 06:35:35','797','2023-02-22 09:51:41',10,0),('5','174',257963,'Daily shift','2023-02-22','2023-02-22 22:23:15','2023-02-23 22:23:15','596',0.00,0.00,'596','2023-02-22 22:24:02','797','2023-02-23 07:01:44',10,0),('5','174',257964,'Daily shift','2023-02-23','2023-02-23 21:16:31','2023-02-24 21:16:31','596',0.00,0.00,'596','2023-02-23 21:17:16','797','2023-02-24 18:54:20',10,0),('5','174',257965,'Daily shift','2023-02-24','2023-02-25 06:49:47','2023-02-26 06:49:47','596',735900.00,702450.00,'596','2023-02-25 15:08:02','797','2023-02-25 15:53:28',10,0),('5','174',257966,'Daily shift','2023-02-25','2023-02-26 06:25:14','2023-02-27 06:25:14','596',660074.10,660074.10,'596','2023-02-26 06:27:05','797','2023-02-26 11:14:32',10,0),('5','174',257967,'Daily shift','2023-02-26','2023-02-27 07:09:45','2023-02-28 07:09:45','596',259824.60,204147.90,'596','2023-02-27 07:19:21','797','2023-02-27 15:41:11',10,0),('5','174',257969,'Daily shift','2023-02-27','2023-02-28 14:09:04','2023-03-01 14:09:04','596',4757029.20,4757029.20,'596','2023-02-28 14:21:33','797','2023-02-28 15:39:09',10,0),('5','174',257970,'Daily shift','2023-02-28','2023-03-01 04:06:02','2023-03-02 04:06:02','596',4136892.90,4136892.90,'596','2023-03-03 08:17:31','797','2023-03-03 09:24:06',10,0),('5','174',257971,'Daily shift','2023-03-02','2023-03-03 11:49:05','2023-03-04 11:49:05','596',4672829.70,4672829.70,'596','2023-03-03 15:04:21','797','2023-03-04 08:48:55',10,0),('5','174',257972,'Daily shift','2023-03-03','2023-03-05 09:56:57','2023-03-06 09:56:57','596',2751012.60,2751012.60,'596','2023-03-05 12:42:04','797','2023-03-05 13:39:21',10,0),('5','174',257973,'Daily shipt','2023-03-04','2023-03-05 15:44:26','2023-03-06 15:44:26','596',2388594.60,2388594.60,'596','2023-03-05 19:56:13','797','2023-03-05 19:58:30',10,0),('5','174',257974,'Daily shift','2023-03-05','2023-03-06 03:32:16','2023-03-07 03:32:16','596',2197167.00,2197167.00,'596','2023-03-06 03:35:24','797','2023-03-06 09:02:19',10,0),('5','174',257975,'Daily shift','2023-03-06','2023-03-06 09:37:59','2023-03-07 09:37:59','596',2021191.20,2021191.20,'596','2023-03-07 09:23:28','797','2023-03-07 09:27:30',10,0),('5','174',257976,'Daily shift ','2023-03-07','2023-03-07 09:57:46','2023-03-08 09:57:46','596',770046.90,770046.90,'596','2023-03-08 06:47:34','797','2023-03-08 09:54:23',10,0),('5','174',257977,'Daily shift','2023-03-08','2023-03-08 16:49:46','2023-03-09 16:49:46','596',0.00,0.00,'596','2023-03-08 16:50:27','797','2023-03-09 09:50:07',10,0),('5','174',257978,'Daily shift','2023-03-09','2023-03-10 06:57:37','2023-03-11 06:57:37','596',0.00,0.00,'596','2023-03-10 06:58:13','797','2023-03-10 09:19:03',10,0),('5','174',257979,'Daily shift','2023-03-10','2023-03-11 06:44:59','2023-03-12 06:44:59','596',0.00,0.00,'596','2023-03-11 06:46:32','797','2023-03-11 10:37:14',10,0),('5','174',257980,'Daily shift','2023-03-11','2023-03-12 08:55:07','2023-03-13 08:55:07','596',0.00,0.00,'596','2023-03-12 08:56:13','797','2023-03-12 09:00:47',10,0),('5','174',257981,'Daily shift','2023-03-12','2023-03-13 06:09:11','2023-03-14 06:09:11','596',0.00,0.00,'596','2023-03-13 06:10:07','797','2023-03-13 10:02:47',10,0),('5','174',257982,'Daily shift','2023-03-13','2023-03-14 09:38:56','2023-03-15 09:38:56','596',0.00,0.00,'596','2023-03-14 09:39:46','797','2023-03-14 12:34:33',10,0),('5','174',257983,'Daily shift','2023-03-14','2023-03-14 22:20:01','2023-03-15 22:20:01','596',0.00,0.00,'596','2023-03-14 22:20:45','797','2023-03-15 08:28:31',10,0),('5','174',257984,'Daily shift','2023-03-15','2023-03-16 04:18:06','2023-03-17 04:18:06','596',0.00,0.00,'596','2023-03-16 04:18:44','797','2023-03-16 09:34:44',10,0),('5','174',257985,'Daily shift','2023-03-16','2023-03-16 12:19:20','2023-03-17 12:19:20','596',0.00,0.00,'596','2023-03-16 12:19:47','797','2023-03-17 07:58:26',10,0),('5','174',257986,'Daily shift','2023-03-17','2023-03-17 09:32:43','2023-03-18 09:32:43','596',0.00,0.00,'596','2023-03-17 09:33:31','797','2023-03-18 11:03:33',10,0),('5','174',257987,'Daily shift','2023-03-18','2023-03-19 22:36:39','2023-03-20 22:36:39','596',0.00,0.00,'596','2023-03-19 22:37:24','797','2023-03-20 12:22:46',10,0),('5','174',257988,'Daily shift ','2023-03-20','2023-03-20 12:48:21','2023-03-21 12:48:21','596',0.00,0.00,'596','2023-03-20 12:48:54','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906696 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','174','899','181489',3564571,'2677','397',0.00,289540.27,289540.27,47195064.01,0.00,0.00,0.00,0.00,0.00),('5','174','899','181489',3564572,'2678','397',0.00,300768.06,300768.06,49025193.78,0.00,0.00,0.00,0.00,0.00),('5','174','900','181489',3564573,'2679','397',0.00,367129.71,367129.71,59842142.73,0.00,0.00,0.00,0.00,0.00),('5','174','901','181489',3564574,'2680','397',0.00,476214.87,476214.87,77623023.81,0.00,0.00,0.00,0.00,0.00),('5','174','902','181489',3564575,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','181489',3564576,'2682','399',0.00,177376.06,177376.06,44344015.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','181495',3564707,'2677','397',289540.27,295998.71,6458.44,1052725.72,0.00,0.00,0.00,0.00,0.00),('5','174','899','181495',3564708,'2678','397',300768.06,305060.16,4292.10,699612.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','181495',3564709,'2679','397',367129.71,372452.01,5322.30,867534.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','181495',3564710,'2680','397',476214.87,481222.52,5007.65,816246.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','181495',3564711,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','181495',3564712,'2682','399',177376.06,178615.04,1238.98,309745.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','181576',3565789,'2677','397',295998.71,296693.29,694.58,113216.54,0.00,0.00,0.00,0.00,0.00),('5','174','899','181576',3565790,'2678','397',305060.16,305897.11,836.95,136422.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','181576',3565791,'2679','397',372452.01,380803.89,8351.88,1361356.44,0.00,0.00,0.00,0.00,0.00),('5','174','901','181576',3565792,'2680','397',481222.52,486975.22,5752.70,937690.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','181576',3565793,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','181576',3565794,'2682','399',178615.04,179185.07,570.03,142507.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','181794',3569695,'2677','397',296693.29,296693.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','181794',3569696,'2678','397',305897.11,305897.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','181794',3569697,'2679','397',380803.89,384221.22,3417.33,557024.79,0.00,0.00,0.00,0.00,0.00),('5','174','901','181794',3569698,'2680','397',486975.22,489758.76,2783.54,453717.02,0.00,0.00,0.00,0.00,0.00),('5','174','902','181794',3569699,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','181794',3569700,'2682','399',179185.07,180083.07,898.00,224500.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','181991',3573100,'2677','397',296693.29,296693.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','181991',3573101,'2678','397',305897.11,305897.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','181991',3573102,'2679','397',384221.22,384221.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','181991',3573103,'2680','397',489758.76,490146.59,387.83,63216.29,0.00,0.00,0.00,0.00,0.00),('5','174','902','181991',3573104,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','181991',3573105,'2682','399',180083.07,181087.50,1004.43,251107.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','182148',3576052,'2677','397',296693.29,296693.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','182148',3576053,'2678','397',305897.11,305897.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','182148',3576054,'2679','397',384221.22,384221.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','182148',3576055,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','182148',3576056,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','182148',3576057,'2682','399',181087.50,182296.91,1209.41,302352.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','182388',3580316,'2677','397',296693.29,297684.86,991.57,161625.91,0.00,0.00,0.00,0.00,0.00),('5','174','899','182388',3580317,'2678','397',305897.11,306510.20,613.09,99933.67,0.00,0.00,0.00,0.00,0.00),('5','174','900','182388',3580318,'2679','397',384221.22,384952.66,731.44,119224.72,0.00,0.00,0.00,0.00,0.00),('5','174','901','182388',3580319,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','182388',3580320,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','182388',3580321,'2682','399',182296.91,183294.05,997.14,249285.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','182531',3582824,'2677','397',297684.86,300849.82,3164.96,515888.48,0.00,0.00,0.00,0.00,0.00),('5','174','899','182531',3582825,'2678','397',306510.20,309866.55,3356.35,547085.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','182531',3582826,'2679','397',384952.66,387378.88,2426.22,395473.86,0.00,0.00,0.00,0.00,0.00),('5','174','901','182531',3582827,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','182531',3582828,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','182531',3582829,'2682','399',183294.05,186078.28,2784.23,696057.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','182711',3586209,'2677','397',300849.82,304944.81,4094.99,667483.37,0.00,0.00,0.00,0.00,0.00),('5','174','899','182711',3586210,'2678','397',309866.55,313273.80,3407.25,555381.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','182711',3586211,'2679','397',387378.88,391283.92,3905.04,636521.52,0.00,0.00,0.00,0.00,0.00),('5','174','901','182711',3586212,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','182711',3586213,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','182711',3586214,'2682','399',186078.28,186936.79,858.51,214627.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','182915',3590125,'2677','397',304944.81,310127.67,5182.86,844806.18,0.00,0.00,0.00,0.00,0.00),('5','174','899','182915',3590126,'2678','397',313273.80,317201.22,3927.42,640169.46,0.00,0.00,0.00,0.00,0.00),('5','174','900','182915',3590127,'2679','397',391283.92,395339.02,4055.10,660981.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','182915',3590128,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','182915',3590129,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','182915',3590130,'2682','399',186936.79,187636.19,699.40,174850.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','183007',3591767,'2677','397',310127.67,311090.60,962.93,156957.59,0.00,0.00,0.00,0.00,0.00),('5','174','899','183007',3591768,'2678','397',317201.22,318501.24,1300.02,211903.26,0.00,0.00,0.00,0.00,0.00),('5','174','900','183007',3591769,'2679','397',395339.02,397121.94,1782.92,290615.96,0.00,0.00,0.00,0.00,0.00),('5','174','901','183007',3591770,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','183007',3591771,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','183007',3591772,'2682','399',187636.19,188660.98,1024.79,256197.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','183227',3595744,'2677','397',311090.60,311090.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','183227',3595745,'2678','397',318501.24,318501.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','183227',3595746,'2679','397',397121.94,397121.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','183227',3595747,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','183227',3595748,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','183227',3595749,'2682','399',188660.98,189168.77,507.79,126947.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','183442',3599566,'2677','397',311090.60,311090.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','183442',3599567,'2678','397',318501.24,318501.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','183442',3599568,'2679','397',397121.94,397121.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','183442',3599569,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','183442',3599570,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','183442',3599571,'2682','399',189168.77,189477.11,308.34,81710.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','183675',3603800,'2677','397',311090.60,311090.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','183675',3603801,'2678','397',318501.24,318501.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','183675',3603802,'2679','397',397121.94,397121.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','183675',3603803,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','183675',3603804,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','183675',3603805,'2682','399',189477.11,190027.20,550.09,145773.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','183942',3608790,'2677','397',311090.60,314223.87,3133.27,510723.01,0.00,0.00,0.00,0.00,0.00),('5','174','899','183942',3608791,'2678','397',318501.24,321476.09,2974.85,484900.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','183942',3608792,'2679','397',397121.94,399593.25,2471.31,402823.53,0.00,0.00,0.00,0.00,0.00),('5','174','901','183942',3608793,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','183942',3608794,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','183942',3608795,'2682','399',190027.20,191751.18,1723.98,439614.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','184106',3611714,'2677','397',314223.87,319713.78,5489.91,894855.33,0.00,0.00,0.00,0.00,0.00),('5','174','899','184106',3611715,'2678','397',321476.09,326538.54,5062.45,825179.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','184106',3611716,'2679','397',399593.25,404337.92,4744.67,773381.21,0.00,0.00,0.00,0.00,0.00),('5','174','901','184106',3611717,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','184106',3611718,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','184106',3611719,'2682','399',191751.18,194724.43,2973.25,758178.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','184308',3615097,'2677','397',319713.78,323656.21,3942.43,642616.09,0.00,0.00,0.00,0.00,0.00),('5','174','899','184308',3615098,'2678','397',326538.54,329461.78,2923.24,476488.12,0.00,0.00,0.00,0.00,0.00),('5','174','900','184308',3615099,'2679','397',404337.92,407400.57,3062.65,499211.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','184308',3615100,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','184308',3615101,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','184308',3615102,'2682','399',194724.43,196524.79,1800.36,459091.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','184564',3619865,'2677','397',323656.21,325169.57,1513.36,246677.68,0.00,0.00,0.00,0.00,0.00),('5','174','899','184564',3619866,'2678','397',329461.78,331750.22,2288.44,373015.72,0.00,0.00,0.00,0.00,0.00),('5','174','900','184564',3619867,'2679','397',407400.57,410299.97,2899.40,472602.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','184564',3619868,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','184564',3619869,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','184564',3619870,'2682','399',196524.79,199515.60,2990.81,762656.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','184940',3626626,'2677','397',325169.57,325169.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','184940',3626627,'2678','397',331750.22,331750.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','184940',3626628,'2679','397',410299.97,410299.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','184940',3626629,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','184940',3626630,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','184940',3626631,'2682','399',199515.60,202343.64,2828.04,721150.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','184942',3626649,'2677','397',325169.57,328159.72,2990.15,487394.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','184942',3626650,'2678','397',331750.22,333877.49,2127.27,346745.01,0.00,0.00,0.00,0.00,0.00),('5','174','900','184942',3626651,'2679','397',410299.97,411951.91,1651.94,269266.22,0.00,0.00,0.00,0.00,0.00),('5','174','901','184942',3626652,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','184942',3626653,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','184942',3626654,'2682','399',202343.64,204896.49,2552.85,676505.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','185141',3630028,'2677','397',328159.72,331212.47,3052.75,497598.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','185141',3630029,'2678','397',333877.49,336113.76,2236.27,364512.01,0.00,0.00,0.00,0.00,0.00),('5','174','900','185141',3630030,'2679','397',411951.91,412989.39,1037.48,169109.24,0.00,0.00,0.00,0.00,0.00),('5','174','901','185141',3630031,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','185141',3630032,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','185141',3630033,'2682','399',204896.49,207320.11,2423.62,642259.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','185291',3632345,'2677','397',331212.47,334095.09,2882.62,469867.06,0.00,0.00,0.00,0.00,0.00),('5','174','899','185291',3632346,'2678','397',336113.76,338007.34,1893.58,308653.54,0.00,0.00,0.00,0.00,0.00),('5','174','900','185291',3632347,'2679','397',412989.39,415598.38,2608.99,425265.37,0.00,0.00,0.00,0.00,0.00),('5','174','901','185291',3632348,'2680','397',490146.59,490146.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','185291',3632349,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','185291',3632350,'2682','399',207320.11,210680.08,3359.97,890392.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','185510',3636440,'2677','397',334095.09,336276.76,2181.67,355612.21,0.00,0.00,0.00,0.00,0.00),('5','174','899','185510',3636441,'2678','397',338007.34,340659.16,2651.82,432246.66,0.00,0.00,0.00,0.00,0.00),('5','174','900','185510',3636442,'2679','397',415598.38,419129.76,3531.38,575614.94,0.00,0.00,0.00,0.00,0.00),('5','174','901','185510',3636443,'2680','397',490146.59,490647.49,500.90,81646.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','185510',3636444,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','185510',3636445,'2682','399',210680.08,213346.09,2666.01,706492.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','185794',3641457,'2677','397',336276.76,338863.43,2586.67,421627.21,0.00,0.00,0.00,0.00,0.00),('5','174','899','185794',3641458,'2678','397',340659.16,341726.49,1067.33,173974.79,0.00,0.00,0.00,0.00,0.00),('5','174','900','185794',3641459,'2679','397',419129.76,421210.89,2081.13,339224.19,0.00,0.00,0.00,0.00,0.00),('5','174','901','185794',3641460,'2680','397',490647.49,494333.12,3685.63,600757.69,0.00,0.00,0.00,0.00,0.00),('5','174','902','185794',3641461,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','185794',3641462,'2682','399',213346.09,214951.50,1605.41,425433.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','185887',3643243,'2677','397',338863.43,339736.91,873.48,142377.24,0.00,0.00,0.00,0.00,0.00),('5','174','899','185887',3643244,'2678','397',341726.49,344674.80,2948.31,480574.53,0.00,0.00,0.00,0.00,0.00),('5','174','900','185887',3643245,'2679','397',421210.89,424192.59,2981.70,486017.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','185887',3643246,'2680','397',494333.12,498072.90,3739.78,609584.14,0.00,0.00,0.00,0.00,0.00),('5','174','902','185887',3643247,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','185887',3643248,'2682','399',214951.50,215783.40,831.90,220453.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','186108',3647215,'2677','397',339736.91,341817.62,2080.71,339155.73,0.00,0.00,0.00,0.00,0.00),('5','174','899','186108',3647216,'2678','397',344674.80,347116.36,2441.56,397974.28,0.00,0.00,0.00,0.00,0.00),('5','174','900','186108',3647217,'2679','397',424192.59,426661.98,2469.39,402510.57,0.00,0.00,0.00,0.00,0.00),('5','174','901','186108',3647218,'2680','397',498072.90,498406.94,334.04,54448.52,0.00,0.00,0.00,0.00,0.00),('5','174','902','186108',3647219,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','186108',3647220,'2682','399',215783.40,216061.80,278.40,73776.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','186334',3650897,'2677','397',341817.62,343751.96,1934.34,315297.42,0.00,0.00,0.00,0.00,0.00),('5','174','899','186334',3650898,'2678','397',347116.36,348326.48,1210.12,197249.56,0.00,0.00,0.00,0.00,0.00),('5','174','900','186334',3650899,'2679','397',426661.98,428889.61,2227.63,363103.69,0.00,0.00,0.00,0.00,0.00),('5','174','901','186334',3650900,'2680','397',498406.94,499363.72,956.78,155955.14,0.00,0.00,0.00,0.00,0.00),('5','174','902','186334',3650901,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','186334',3650902,'2682','399',216061.80,216450.61,388.81,103034.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','186554',3654656,'2677','397',343751.96,346472.79,2720.83,443495.29,0.00,0.00,0.00,0.00,0.00),('5','174','899','186554',3654657,'2678','397',348326.48,349596.50,1270.02,207013.26,0.00,0.00,0.00,0.00,0.00),('5','174','900','186554',3654658,'2679','397',428889.61,431925.80,3036.19,494898.97,0.00,0.00,0.00,0.00,0.00),('5','174','901','186554',3654659,'2680','397',499363.72,500810.98,1447.26,235903.38,0.00,0.00,0.00,0.00,0.00),('5','174','902','186554',3654660,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','186554',3654661,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','186765',3658287,'2677','397',346472.79,349258.31,2785.52,454039.76,0.00,0.00,0.00,0.00,0.00),('5','174','899','186765',3658288,'2678','397',349596.50,351533.89,1937.39,315794.57,0.00,0.00,0.00,0.00,0.00),('5','174','900','186765',3658289,'2679','397',431925.80,434943.35,3017.55,491860.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','186765',3658290,'2680','397',500810.98,500969.52,158.54,25842.02,0.00,0.00,0.00,0.00,0.00),('5','174','902','186765',3658291,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','186765',3658292,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','187040',3662835,'2677','397',349258.31,351710.19,2451.88,399656.44,0.00,0.00,0.00,0.00,0.00),('5','174','899','187040',3662836,'2678','397',351533.89,351744.48,210.59,34326.17,0.00,0.00,0.00,0.00,0.00),('5','174','900','187040',3662837,'2679','397',434943.35,437601.15,2657.80,433221.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','187040',3662838,'2680','397',500969.52,503753.12,2783.60,453726.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','187040',3662839,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','187040',3662840,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','187196',3665564,'2677','397',351710.19,353891.28,2181.09,355517.67,0.00,0.00,0.00,0.00,0.00),('5','174','899','187196',3665565,'2678','397',351744.48,351744.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','187196',3665566,'2679','397',437601.15,440014.93,2413.78,393446.14,0.00,0.00,0.00,0.00,0.00),('5','174','901','187196',3665567,'2680','397',503753.12,506634.09,2880.97,469598.11,0.00,0.00,0.00,0.00,0.00),('5','174','902','187196',3665568,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','187196',3665569,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','187371',3668778,'2677','397',353891.28,357227.67,3336.39,543831.57,0.00,0.00,0.00,0.00,0.00),('5','174','899','187371',3668779,'2678','397',351744.48,351753.70,9.22,1502.86,0.00,0.00,0.00,0.00,0.00),('5','174','900','187371',3668780,'2679','397',440014.93,444133.05,4118.12,671253.56,0.00,0.00,0.00,0.00,0.00),('5','174','901','187371',3668781,'2680','397',506634.09,510940.80,4306.71,701993.73,0.00,0.00,0.00,0.00,0.00),('5','174','902','187371',3668782,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','187371',3668783,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','187642',3673567,'2677','397',357227.67,359905.54,2677.87,436492.81,0.00,0.00,0.00,0.00,0.00),('5','174','899','187642',3673568,'2678','397',351753.70,352091.72,338.02,55097.26,0.00,0.00,0.00,0.00,0.00),('5','174','900','187642',3673569,'2679','397',444133.05,446755.66,2622.61,427485.43,0.00,0.00,0.00,0.00,0.00),('5','174','901','187642',3673570,'2680','397',510940.80,514315.98,3375.18,550154.34,0.00,0.00,0.00,0.00,0.00),('5','174','902','187642',3673571,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','187642',3673572,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','187827',3676815,'2677','397',359905.54,362571.92,2666.38,434619.94,0.00,0.00,0.00,0.00,0.00),('5','174','899','187827',3676816,'2678','397',352091.72,353288.01,1196.29,194995.27,0.00,0.00,0.00,0.00,0.00),('5','174','900','187827',3676817,'2679','397',446755.66,448649.59,1893.93,308710.59,0.00,0.00,0.00,0.00,0.00),('5','174','901','187827',3676818,'2680','397',514315.98,516580.57,2264.59,369128.17,0.00,0.00,0.00,0.00,0.00),('5','174','902','187827',3676819,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','187827',3676820,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','188024',3680305,'2677','397',362571.92,365670.99,3099.07,505148.41,0.00,0.00,0.00,0.00,0.00),('5','174','899','188024',3680306,'2678','397',353288.01,356608.48,3320.47,541236.61,0.00,0.00,0.00,0.00,0.00),('5','174','900','188024',3680307,'2679','397',448649.59,450724.82,2075.23,338262.49,0.00,0.00,0.00,0.00,0.00),('5','174','901','188024',3680308,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','188024',3680309,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','188024',3680310,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','188203',3683498,'2677','397',365670.99,369794.53,4123.54,672137.02,0.00,0.00,0.00,0.00,0.00),('5','174','899','188203',3683499,'2678','397',356608.48,359623.80,3015.32,491497.16,0.00,0.00,0.00,0.00,0.00),('5','174','900','188203',3683500,'2679','397',450724.82,450724.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','188203',3683501,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','188203',3683502,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','188203',3683503,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','188414',3687108,'2677','397',369794.53,373653.96,3859.43,629087.09,0.00,0.00,0.00,0.00,0.00),('5','174','899','188414',3687109,'2678','397',359623.80,363718.80,4095.00,667485.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','188414',3687110,'2679','397',450724.82,450724.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','188414',3687111,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','188414',3687112,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','188414',3687113,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','188601',3690355,'2677','397',373653.96,375766.17,2112.21,344290.23,0.00,0.00,0.00,0.00,0.00),('5','174','899','188601',3690356,'2678','397',363718.80,366367.72,2648.92,431773.96,0.00,0.00,0.00,0.00,0.00),('5','174','900','188601',3690357,'2679','397',450724.82,453037.95,2313.13,377040.19,0.00,0.00,0.00,0.00,0.00),('5','174','901','188601',3690358,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','188601',3690359,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','188601',3690360,'2682','399',216450.61,216450.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','188859',3694775,'2677','397',375766.17,379604.49,3838.32,625646.16,0.00,0.00,0.00,0.00,0.00),('5','174','899','188859',3694776,'2678','397',366367.72,369197.02,2829.30,461175.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','188859',3694777,'2679','397',453037.95,455215.13,2177.18,354880.34,0.00,0.00,0.00,0.00,0.00),('5','174','901','188859',3694778,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','188859',3694779,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','188859',3694780,'2682','399',216450.61,217165.46,714.85,193009.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','189041',3698082,'2677','397',379604.49,382375.83,2771.34,451728.42,0.00,0.00,0.00,0.00,0.00),('5','174','899','189041',3698083,'2678','397',369197.02,372475.99,3278.97,534472.11,0.00,0.00,0.00,0.00,0.00),('5','174','900','189041',3698084,'2679','397',455215.13,456682.28,1467.15,239145.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','189041',3698085,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','189041',3698086,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','189041',3698087,'2682','399',217165.46,218668.18,1502.72,398220.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','189205',3701065,'2677','397',382375.83,384643.82,2267.99,369682.37,0.00,0.00,0.00,0.00,0.00),('5','174','899','189205',3701066,'2678','397',372475.99,375399.18,2923.19,476479.97,0.00,0.00,0.00,0.00,0.00),('5','174','900','189205',3701067,'2679','397',456682.28,459549.57,2867.29,467368.27,0.00,0.00,0.00,0.00,0.00),('5','174','901','189205',3701068,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','189205',3701069,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','189205',3701070,'2682','399',218668.18,220619.22,1951.04,517025.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','189420',3705074,'2677','397',384643.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','189420',3705075,'2678','397',375399.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','189420',3705076,'2679','397',459549.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','189420',3705077,'2680','397',516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','189420',3705078,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','189420',3705079,'2682','399',220619.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','189660',3709109,'2677','397',384643.82,387347.58,2703.76,440712.88,0.00,0.00,0.00,0.00,0.00),('5','174','899','189660',3709110,'2678','397',375399.18,377481.08,2081.90,339349.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','189660',3709111,'2679','397',459549.57,462416.55,2866.98,467317.74,0.00,0.00,0.00,0.00,0.00),('5','174','901','189660',3709112,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','189660',3709113,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','189660',3709114,'2682','399',220619.22,221602.29,983.07,260513.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','189667',3709211,'2677','397',387347.58,388409.01,1061.43,173013.09,0.00,0.00,0.00,0.00,0.00),('5','174','899','189667',3709212,'2678','397',377481.08,377950.27,469.19,76477.97,0.00,0.00,0.00,0.00,0.00),('5','174','900','189667',3709213,'2679','397',462416.55,464180.41,1763.86,287509.18,0.00,0.00,0.00,0.00,0.00),('5','174','901','189667',3709214,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','189667',3709215,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','189667',3709216,'2682','399',221602.29,222151.61,549.32,145569.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','190011',3716032,'2677','397',388409.01,393463.19,5054.18,823831.34,0.00,0.00,0.00,0.00,0.00),('5','174','899','190011',3716033,'2678','397',377950.27,383983.96,6033.69,983491.47,0.00,0.00,0.00,0.00,0.00),('5','174','900','190011',3716034,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190011',3716035,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190011',3716036,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190011',3716037,'2682','399',222151.61,224453.79,2302.18,610077.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','190026',3716197,'2677','397',393463.19,398453.58,4990.39,813433.57,0.00,0.00,0.00,0.00,0.00),('5','174','899','190026',3716198,'2678','397',383983.96,387817.15,3833.19,624809.97,0.00,0.00,0.00,0.00,0.00),('5','174','900','190026',3716199,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190026',3716200,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190026',3716201,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190026',3716202,'2682','399',224453.79,224814.35,360.56,95548.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','190217',3719772,'2677','397',398453.58,403828.25,5374.67,876071.21,0.00,0.00,0.00,0.00,0.00),('5','174','899','190217',3719773,'2678','397',387817.15,392586.46,4769.31,777397.53,0.00,0.00,0.00,0.00,0.00),('5','174','900','190217',3719774,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190217',3719775,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190217',3719776,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190217',3719777,'2682','399',224814.35,225778.63,964.28,255534.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','190462',3724121,'2677','397',403828.25,403828.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','190462',3724122,'2678','397',392586.46,392586.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','190462',3724123,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190462',3724124,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190462',3724125,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190462',3724126,'2682','399',225778.63,226545.46,766.83,203209.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','190659',3728110,'2677','397',403828.25,407576.59,3748.34,618476.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','190659',3728111,'2678','397',392586.46,396771.57,4185.11,690543.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','190659',3728112,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190659',3728113,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190659',3728114,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190659',3728115,'2682','399',226545.46,226874.39,328.93,87166.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','190898',3732277,'2677','397',407576.59,413067.16,5490.57,905944.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','190898',3732278,'2678','397',396771.57,403012.97,6241.40,1029831.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','190898',3732279,'2679','397',464180.41,464180.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','190898',3732280,'2680','397',516580.57,516580.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','190898',3732281,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','190898',3732282,'2682','399',226874.39,227635.73,761.34,201755.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','191124',3736182,'2677','397',413067.16,417033.37,3966.21,654424.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','191124',3736183,'2678','397',403012.97,403305.32,292.35,48237.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','191124',3736184,'2679','397',464180.41,468077.44,3897.03,643009.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','191124',3736185,'2680','397',516580.57,519143.36,2562.79,422860.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','191124',3736186,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','191124',3736187,'2682','399',227635.73,228216.69,580.96,153954.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','191365',3740423,'2677','397',417033.37,419427.62,2394.25,395051.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','191365',3740424,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','191365',3740425,'2679','397',468077.44,469962.36,1884.92,311011.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','191365',3740426,'2680','397',519143.36,522025.47,2882.11,475548.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','191365',3740427,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','191365',3740428,'2682','399',228216.69,228731.67,514.98,136469.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','191519',3743152,'2677','397',419427.62,419427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','191519',3743153,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','191519',3743154,'2679','397',469962.36,472645.16,2682.80,442662.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','191519',3743155,'2680','397',522025.47,525626.66,3601.19,594196.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','191519',3743156,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','191519',3743157,'2682','399',228731.67,229687.47,955.80,253287.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','191728',3747370,'2677','397',419427.62,419427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','191728',3747371,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','191728',3747372,'2679','397',472645.16,476031.55,3386.39,558754.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','191728',3747373,'2680','397',525626.66,530055.89,4429.23,730822.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','191728',3747374,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','191728',3747375,'2682','399',229687.47,230326.08,638.61,169231.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','191962',3751839,'2677','397',419427.62,419427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','191962',3751840,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','191962',3751841,'2679','397',476031.55,478834.97,2803.42,462564.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','191962',3751842,'2680','397',530055.89,531577.63,1521.74,251087.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','191962',3751843,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','191962',3751844,'2682','399',230326.08,231704.11,1378.03,365177.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','192138',3754984,'2677','397',419427.62,419427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','192138',3754985,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','192138',3754986,'2679','397',478834.97,478834.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','192138',3754987,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','192138',3754988,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','192138',3754989,'2682','399',231704.11,232805.59,1101.48,291892.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','192427',3760122,'2677','397',419427.62,419427.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','192427',3760123,'2678','397',403305.32,403305.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','192427',3760124,'2679','397',478834.97,478834.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','192427',3760125,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','192427',3760126,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','192427',3760127,'2682','399',232805.59,234117.31,1311.72,347605.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','192570',3762882,'2677','397',419427.62,422729.94,3302.32,544882.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','192570',3762883,'2678','397',403305.32,405818.88,2513.56,414737.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','192570',3762884,'2679','397',478834.97,478834.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','192570',3762885,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','192570',3762886,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','192570',3762887,'2682','399',234117.31,235155.64,1038.33,275157.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','192774',3766493,'2677','397',422729.94,425440.38,2710.44,447222.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','192774',3766494,'2678','397',405818.88,408786.46,2967.58,489650.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','192774',3766495,'2679','397',478834.97,478834.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','192774',3766496,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','192774',3766497,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','192774',3766498,'2682','399',235155.64,236079.27,923.63,244761.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','192967',3770073,'2677','397',425440.38,428068.01,2627.63,433558.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','192967',3770074,'2678','397',408786.46,410353.43,1566.97,258550.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','192967',3770075,'2679','397',478834.97,480109.56,1274.59,210307.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','192967',3770076,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','192967',3770077,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','192967',3770078,'2682','399',236079.27,236664.47,585.20,155078.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','193193',3774313,'2677','397',428068.01,429299.61,1231.60,203214.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','193193',3774314,'2678','397',410353.43,411341.09,987.66,162963.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','193193',3774315,'2679','397',480109.56,484309.95,4200.39,693064.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','193193',3774316,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','193193',3774317,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','193193',3774318,'2682','399',236664.47,238844.38,2179.91,577676.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','193419',3778918,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','193419',3778919,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','193419',3778920,'2679','397',484309.95,488504.22,4194.27,692054.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','193419',3778921,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','193419',3778922,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','193419',3778923,'2682','399',238844.38,239996.87,1152.49,305409.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','193651',3783040,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','193651',3783041,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','193651',3783042,'2679','397',488504.22,493173.46,4669.24,770424.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','193651',3783043,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','193651',3783044,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','193651',3783045,'2682','399',239996.87,241196.94,1200.07,318018.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','193890',3787349,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','193890',3787350,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','193890',3787351,'2679','397',493173.46,497791.90,4618.44,762042.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','193890',3787352,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','193890',3787353,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','193890',3787354,'2682','399',241196.94,241514.79,317.85,84230.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','194097',3791041,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','194097',3791042,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','194097',3791043,'2679','397',497791.90,503173.43,5381.53,887952.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','194097',3791044,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','194097',3791045,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','194097',3791046,'2682','399',241514.79,242978.95,1464.16,388002.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','194347',3795711,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','194347',3795712,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','194347',3795713,'2679','397',503173.43,505934.49,2761.06,455574.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','194347',3795714,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','194347',3795715,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','194347',3795716,'2682','399',242978.95,244019.89,1040.94,275849.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','194526',3798878,'2677','397',429299.61,429299.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','194526',3798879,'2678','397',411341.09,411341.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','194526',3798880,'2679','397',505934.49,505934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','194526',3798881,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','194526',3798882,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','194526',3798883,'2682','399',244019.89,244578.57,558.68,148050.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','194692',3801833,'2677','397',429299.61,432553.77,3254.16,536936.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','194692',3801834,'2678','397',411341.09,413011.00,1669.91,275535.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','194692',3801835,'2679','397',505934.49,508807.44,2872.95,474036.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','194692',3801836,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','194692',3801837,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','194692',3801838,'2682','399',244578.57,245582.63,1004.06,266075.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','194943',3807049,'2677','397',432553.77,433945.58,1391.81,229648.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','194943',3807050,'2678','397',413011.00,413707.55,696.55,114930.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','194943',3807051,'2679','397',508807.44,511104.29,2296.85,378980.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','194943',3807052,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','194943',3807053,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','194943',3807054,'2682','399',245582.63,246597.47,1014.84,268932.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','195116',3809954,'2677','397',433945.58,436006.87,2061.29,340112.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','195116',3809955,'2678','397',413707.55,415072.53,1364.98,225221.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','195116',3809956,'2679','397',511104.29,512865.99,1761.70,290680.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','195116',3809957,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','195116',3809958,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','195116',3809959,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','195325',3813482,'2677','397',436006.87,438453.87,2447.00,403755.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','195325',3813483,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','195325',3813484,'2679','397',512865.99,515425.38,2559.39,422299.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','195325',3813485,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','195325',3813486,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','195325',3813487,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','195561',3817640,'2677','397',438453.87,442275.17,3821.30,630514.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','195561',3817641,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','195561',3817642,'2679','397',515425.38,518555.67,3130.29,516497.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','195561',3817643,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','195561',3817644,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','195561',3817645,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','195841',3822449,'2677','397',442275.17,445805.88,3530.71,582567.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','195841',3822450,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','195841',3822451,'2679','397',518555.67,520877.31,2321.64,383070.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','195841',3822452,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','195841',3822453,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','195841',3822454,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','196047',3826264,'2677','397',445805.88,449511.00,3705.12,611344.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','196047',3826265,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','196047',3826266,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','196047',3826267,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','196047',3826268,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','196047',3826269,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','196229',3829894,'2677','397',449511.00,454413.15,4902.15,808854.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','196229',3829895,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','196229',3829896,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','196229',3829897,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','196229',3829898,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','196229',3829899,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','196635',3837242,'2677','397',454413.15,455227.16,814.01,134311.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','196635',3837243,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','196635',3837244,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','196635',3837245,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','196635',3837246,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','196635',3837247,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','196876',3841457,'2677','397',455227.16,458736.02,3508.86,578961.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','196876',3841458,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','196876',3841459,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','196876',3841460,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','196876',3841461,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','196876',3841462,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197037',3844312,'2677','397',458736.02,462531.25,3795.23,626212.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','197037',3844313,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197037',3844314,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197037',3844315,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197037',3844316,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197037',3844317,'2682','399',246597.47,246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197572',3853323,'2677','397',462531.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197572',3853324,'2678','397',415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197572',3853325,'2679','397',520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197572',3853326,'2680','397',531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197572',3853327,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197572',3853328,'2682','399',246597.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197764',3856818,'2677','397',462531.25,467312.05,4780.80,788832.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197764',3856819,'2678','397',415072.53,415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197764',3856820,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197764',3856821,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197764',3856822,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197764',3856823,'2682','399',246597.47,247329.42,731.95,193966.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','197782',3857207,'2677','397',467312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197782',3857208,'2678','397',415072.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197782',3857209,'2679','397',520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197782',3857210,'2680','397',531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197782',3857211,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197782',3857212,'2682','399',247329.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197786',3857289,'2677','397',467312.05,468379.84,1067.79,176185.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','197786',3857290,'2678','397',415072.53,415097.44,24.91,4110.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','197786',3857291,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197786',3857292,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197786',3857293,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197786',3857294,'2682','399',247329.42,248908.60,1579.18,418482.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','197815',3857894,'2677','397',468379.84,468379.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197815',3857895,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197815',3857896,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197815',3857897,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197815',3857898,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197815',3857899,'2682','399',248908.60,249304.14,395.54,104818.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','197898',3859155,'2677','397',468379.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','197898',3859156,'2678','397',415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','197898',3859157,'2679','397',520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','197898',3859158,'2680','397',531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','197898',3859159,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','197898',3859160,'2682','399',249304.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','198142',3863398,'2677','397',468379.84,468379.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','198142',3863399,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198142',3863400,'2679','397',520877.31,520877.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','198142',3863401,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','198142',3863402,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198142',3863403,'2682','399',249304.14,249939.62,635.48,171579.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','198175',3863980,'2677','397',468379.84,471693.92,3314.08,546823.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','198175',3863981,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198175',3863982,'2679','397',520877.31,523100.70,2223.39,366859.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','198175',3863983,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','198175',3863984,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198175',3863985,'2682','399',249939.62,250483.30,543.68,146793.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','198458',3868913,'2677','397',471693.92,474152.77,2458.85,405710.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','198458',3868914,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198458',3868915,'2679','397',523100.70,524953.73,1853.03,305749.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','198458',3868916,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','198458',3868917,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198458',3868918,'2682','399',250483.30,251058.68,575.38,155352.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','198571',3870838,'2677','397',474152.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','198571',3870839,'2678','397',415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198571',3870840,'2679','397',524953.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','198571',3870841,'2680','397',531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','198571',3870842,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198571',3870843,'2682','399',251058.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','198816',3874777,'2677','397',474152.77,476722.63,2569.86,424026.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','198816',3874778,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198816',3874779,'2679','397',524953.73,526599.21,1645.48,271504.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','198816',3874780,'2680','397',531577.63,531577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','198816',3874781,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198816',3874782,'2682','399',251058.68,251975.39,916.71,247511.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','198820',3874823,'2677','397',476722.63,478078.43,1355.80,223707.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','198820',3874824,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','198820',3874825,'2679','397',526599.21,528781.47,2182.26,360072.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','198820',3874826,'2680','397',531577.63,532813.46,1235.83,203911.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','198820',3874827,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','198820',3874828,'2682','399',251975.39,252555.48,580.09,156624.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','199014',3878289,'2677','397',478078.43,479165.80,1087.37,179416.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','199014',3878290,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','199014',3878291,'2679','397',528781.47,529920.30,1138.83,187906.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','199014',3878292,'2680','397',532813.46,534907.65,2094.19,345541.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','199014',3878293,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','199014',3878294,'2682','399',252555.48,253187.04,631.56,170521.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','199209',3881937,'2677','397',479165.80,481453.73,2287.93,377508.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','199209',3881938,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','199209',3881939,'2679','397',529920.30,530949.59,1029.29,169832.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','199209',3881940,'2680','397',534907.65,536686.02,1778.37,293431.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','199209',3881941,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','199209',3881942,'2682','399',253187.04,254257.27,1070.23,288962.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','199439',3885524,'2677','397',481453.73,482235.26,781.53,128952.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','199439',3885525,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','199439',3885526,'2679','397',530949.59,532785.07,1835.48,302854.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','199439',3885527,'2680','397',536686.02,538583.96,1897.94,313160.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','199439',3885528,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','199439',3885529,'2682','399',254257.27,254855.62,598.35,161554.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','199663',3889327,'2677','397',482235.26,484481.12,2245.86,370566.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','199663',3889328,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','199663',3889329,'2679','397',532785.07,534138.58,1353.51,223329.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','199663',3889330,'2680','397',538583.96,539586.73,1002.77,165457.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','199663',3889331,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','199663',3889332,'2682','399',254855.62,255500.21,644.59,174039.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','199874',3892579,'2677','397',484481.12,485565.19,1084.07,178871.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','199874',3892580,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','199874',3892581,'2679','397',534138.58,535920.62,1782.04,294036.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','199874',3892582,'2680','397',539586.73,541190.16,1603.43,264565.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','199874',3892583,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','199874',3892584,'2682','399',255500.21,256281.88,781.67,211050.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','200101',3896810,'2677','397',485565.19,487574.68,2009.49,331565.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','200101',3896811,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','200101',3896812,'2679','397',535920.62,537008.51,1087.89,179501.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','200101',3896813,'2680','397',541190.16,542554.55,1364.39,225124.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','200101',3896814,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','200101',3896815,'2682','399',256281.88,258117.37,1835.49,495582.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','200312',3900453,'2677','397',487574.68,488724.67,1149.99,189748.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','200312',3900454,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','200312',3900455,'2679','397',537008.51,538685.99,1677.48,276784.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','200312',3900456,'2680','397',542554.55,544226.56,1672.01,275881.65,0.00,0.00,0.00,0.00,0.00),('5','174','902','200312',3900457,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','200312',3900458,'2682','399',258117.37,258923.49,806.12,217652.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','200525',3904445,'2677','397',488724.67,490115.84,1391.17,229543.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','200525',3904446,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','200525',3904447,'2679','397',538685.99,539512.33,826.34,136346.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','200525',3904448,'2680','397',544226.56,546433.84,2207.28,364201.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','200525',3904449,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','200525',3904450,'2682','399',258923.49,259534.27,610.78,164910.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','200759',3908536,'2677','397',490115.84,492232.72,2116.88,349285.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','200759',3908537,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','200759',3908538,'2679','397',539512.33,540618.15,1105.82,182460.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','200759',3908539,'2680','397',546433.84,548688.05,2254.21,371944.65,0.00,0.00,0.00,0.00,0.00),('5','174','902','200759',3908540,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','200759',3908541,'2682','399',259534.27,259986.69,452.42,122153.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','200923',3911533,'2677','397',492232.72,493612.60,1379.88,227680.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','200923',3911534,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','200923',3911535,'2679','397',540618.15,541780.21,1162.06,191739.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','200923',3911536,'2680','397',548688.05,549988.17,1300.12,214519.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','200923',3911537,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','200923',3911538,'2682','399',259986.69,259986.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','201118',3914665,'2677','397',493612.60,495902.13,2289.53,377772.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','201118',3914666,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','201118',3914667,'2679','397',541780.21,542351.26,571.05,94223.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','201118',3914668,'2680','397',549988.17,551909.61,1921.44,317037.60,0.00,0.00,0.00,0.00,0.00),('5','174','902','201118',3914669,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','201118',3914670,'2682','399',259986.69,259986.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','201314',3918080,'2677','397',495902.13,498087.80,2185.67,360635.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','201314',3918081,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','201314',3918082,'2679','397',542351.26,543986.98,1635.72,269893.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','201314',3918083,'2680','397',551909.61,553591.19,1681.58,277460.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','201314',3918084,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','201314',3918085,'2682','399',259986.69,260410.26,403.57,108963.90,0.00,0.00,20.00,0.00,0.00),('5','174','899','201493',3921436,'2677','397',498087.80,500336.72,2248.92,371071.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','201493',3921437,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','201493',3921438,'2679','397',543986.98,544567.90,580.92,95851.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','201493',3921439,'2680','397',553591.19,556079.60,2488.41,410587.65,0.00,0.00,0.00,0.00,0.00),('5','174','902','201493',3921440,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','201493',3921441,'2682','399',260410.26,261404.22,993.96,268369.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','201802',3927156,'2677','397',500336.72,502464.20,2127.48,351034.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','201802',3927157,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','201802',3927158,'2679','397',544567.90,545523.10,955.20,157608.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','201802',3927159,'2680','397',556079.60,556900.46,820.86,135441.90,0.00,0.00,0.00,0.00,0.00),('5','174','902','201802',3927160,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','201802',3927161,'2682','399',261404.22,262217.52,813.30,223657.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','202028',3931628,'2677','397',502464.20,504748.95,2284.75,376983.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','202028',3931629,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','202028',3931630,'2679','397',545523.10,546393.24,870.14,143573.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','202028',3931631,'2680','397',556900.46,557680.96,780.50,128782.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','202028',3931632,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','202028',3931633,'2682','399',262217.52,263072.85,855.33,235215.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','202233',3934978,'2677','397',504748.95,506151.34,1402.39,231394.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','202233',3934979,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','202233',3934980,'2679','397',546393.24,547809.93,1416.69,233753.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','202233',3934981,'2680','397',557680.96,559317.10,1636.14,269963.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','202233',3934982,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','202233',3934983,'2682','399',263072.85,263558.55,485.70,133567.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','202434',3938506,'2677','397',506151.34,507909.69,1758.35,290127.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','202434',3938507,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','202434',3938508,'2679','397',547809.93,548818.56,1008.63,166423.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','202434',3938509,'2680','397',559317.10,560564.31,1247.21,205789.65,0.00,0.00,0.00,0.00,0.00),('5','174','902','202434',3938510,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','202434',3938511,'2682','399',263558.55,264580.55,1022.00,281050.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','202646',3942201,'2677','397',507909.69,509491.68,1581.99,261028.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','202646',3942202,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','202646',3942203,'2679','397',548818.56,549733.09,914.53,150897.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','202646',3942204,'2680','397',560564.31,561807.29,1242.98,205091.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','202646',3942205,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','202646',3942206,'2682','399',264580.55,265161.98,581.43,159893.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','202864',3946053,'2677','397',509491.68,511226.22,1734.54,286199.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','202864',3946054,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','202864',3946055,'2679','397',549733.09,550454.26,721.17,118993.05,0.00,0.00,0.00,0.00,0.00),('5','174','901','202864',3946056,'2680','397',561807.29,563491.34,1684.05,277868.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','202864',3946057,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','202864',3946058,'2682','399',265161.98,265951.62,789.64,217151.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','203108',3950813,'2677','397',511226.22,512603.36,1377.14,227228.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','203108',3950814,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','203108',3950815,'2679','397',550454.26,551493.55,1039.29,171482.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','203108',3950816,'2680','397',563491.34,565201.91,1710.57,282244.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','203108',3950817,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','203108',3950818,'2682','399',265951.62,266237.64,286.02,78655.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','203303',3954449,'2677','397',512603.36,514362.48,1759.12,290254.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','203303',3954450,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','203303',3954451,'2679','397',551493.55,552080.22,586.67,96800.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','203303',3954452,'2680','397',565201.91,566922.33,1720.42,283869.30,0.00,0.00,0.00,0.00,0.00),('5','174','902','203303',3954453,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','203303',3954454,'2682','399',266237.64,267441.59,1203.95,331086.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','203529',3958373,'2677','397',514362.48,516281.91,1919.43,316705.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','203529',3958374,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','203529',3958375,'2679','397',552080.22,553070.17,989.95,163341.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','203529',3958376,'2680','397',566922.33,567801.68,879.35,145092.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','203529',3958377,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','203529',3958378,'2682','399',267441.59,268157.18,715.59,196787.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','203740',3962144,'2677','397',516281.91,518680.05,2398.14,395693.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','203740',3962145,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','203740',3962146,'2679','397',553070.17,554118.30,1048.13,172941.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','203740',3962147,'2680','397',567801.68,569553.13,1751.45,288989.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','203740',3962148,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','203740',3962149,'2682','399',268157.18,268761.91,604.73,166300.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','203964',3966132,'2677','397',518680.05,520065.47,1385.42,228594.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','203964',3966133,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','203964',3966134,'2679','397',554118.30,555037.98,919.68,151747.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','203964',3966135,'2680','397',569553.13,571528.98,1975.85,326015.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','203964',3966136,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','203964',3966137,'2682','399',268761.91,269360.33,598.42,164565.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','204184',3970310,'2677','397',520065.47,521735.31,1669.84,275523.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','204184',3970311,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','204184',3970312,'2679','397',555037.98,556175.59,1137.61,187705.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','204184',3970313,'2680','397',571528.98,573220.39,1691.41,279082.65,0.00,0.00,0.00,0.00,0.00),('5','174','902','204184',3970314,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','204184',3970315,'2682','399',269360.33,272147.73,2787.40,766535.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','204399',3974014,'2677','397',521735.31,524006.88,2271.57,374809.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','204399',3974015,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','204399',3974016,'2679','397',556175.59,557252.15,1076.56,177632.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','204399',3974017,'2680','397',573220.39,574533.01,1312.62,216582.30,0.00,0.00,0.00,0.00,0.00),('5','174','902','204399',3974018,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','204399',3974019,'2682','399',272147.73,273645.69,1497.96,411939.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','204627',3978124,'2677','397',524006.88,525539.19,1532.31,252831.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','204627',3978125,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','204627',3978126,'2679','397',557252.15,559014.74,1762.59,290827.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','204627',3978127,'2680','397',574533.01,575891.95,1358.94,224225.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','204627',3978128,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','204627',3978129,'2682','399',273645.69,274663.95,1018.26,280021.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','204844',3981628,'2677','397',525539.19,528188.27,2649.08,437098.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','204844',3981629,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','204844',3981630,'2679','397',559014.74,559418.14,403.40,66561.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','204844',3981631,'2680','397',575891.95,577699.06,1807.11,298173.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','204844',3981632,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','204844',3981633,'2682','399',274663.95,275310.48,646.53,177795.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','205080',3985759,'2677','397',528188.27,529861.09,1672.82,276015.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','205080',3985760,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','205080',3985761,'2679','397',559418.14,560379.10,960.96,158558.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','205080',3985762,'2680','397',577699.06,579039.06,1340.00,221100.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','205080',3985763,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','205080',3985764,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','205236',3988768,'2677','397',529861.09,532206.93,2345.84,387063.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','205236',3988769,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','205236',3988770,'2679','397',560379.10,561657.80,1278.70,210985.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','205236',3988771,'2680','397',579039.06,580680.24,1641.18,270794.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','205236',3988772,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','205236',3988773,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','205503',3993401,'2677','397',532206.93,533547.35,1340.42,221169.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','205503',3993402,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','205503',3993403,'2679','397',561657.80,562504.80,847.00,139755.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','205503',3993404,'2680','397',580680.24,582113.27,1433.03,236449.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','205503',3993405,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','205503',3993406,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','205741',3997846,'2677','397',533547.35,535389.24,1841.89,303911.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','205741',3997847,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','205741',3997848,'2679','397',562504.80,563636.11,1131.31,186666.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','205741',3997849,'2680','397',582113.27,583663.83,1550.56,255842.40,0.00,0.00,0.00,0.00,0.00),('5','174','902','205741',3997850,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','205741',3997851,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','205960',4001740,'2677','397',535389.24,536848.03,1458.79,240700.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','205960',4001741,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','205960',4001742,'2679','397',563636.11,564846.38,1210.27,199694.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','205960',4001743,'2680','397',583663.83,585135.19,1471.36,242774.40,0.00,0.00,0.00,0.00,0.00),('5','174','902','205960',4001744,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','205960',4001745,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','206166',4005453,'2677','397',536848.03,539127.39,2279.36,376094.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','206166',4005454,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','206166',4005455,'2679','397',564846.38,565951.49,1105.11,182343.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','206166',4005456,'2680','397',585135.19,586915.16,1779.97,293695.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','206166',4005457,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','206166',4005458,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','206373',4008997,'2677','397',539127.39,541193.73,2066.34,340946.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','206373',4008998,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','206373',4008999,'2679','397',565951.49,566995.09,1043.60,172194.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','206373',4009000,'2680','397',586915.16,588392.49,1477.33,243759.45,0.00,0.00,0.00,0.00,0.00),('5','174','902','206373',4009001,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','206373',4009002,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','206586',4012694,'2677','397',541193.73,542652.32,1458.59,240667.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','206586',4012695,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','206586',4012696,'2679','397',566995.09,568266.47,1271.38,209777.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','206586',4012697,'2680','397',588392.49,590002.99,1610.50,265732.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','206586',4012698,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','206586',4012699,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','206818',4016774,'2677','397',542652.32,545282.88,2630.56,434042.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','206818',4016775,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','206818',4016776,'2679','397',568266.47,570966.34,2699.87,445478.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','206818',4016777,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','206818',4016778,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','206818',4016779,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','207038',4020777,'2677','397',545282.88,547790.41,2507.53,413742.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','207038',4020778,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','207038',4020779,'2679','397',570966.34,573251.29,2284.95,377016.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','207038',4020780,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','207038',4020781,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','207038',4020782,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','207267',4024900,'2677','397',547790.41,550596.95,2806.54,463079.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','207267',4024901,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','207267',4024902,'2679','397',573251.29,575030.13,1778.84,293508.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','207267',4024903,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','207267',4024904,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','207267',4024905,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','207491',4028915,'2677','397',550596.95,553045.92,2448.97,404080.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','207491',4028916,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','207491',4028917,'2679','397',575030.13,577512.63,2482.50,409612.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','207491',4028918,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','207491',4028919,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','207491',4028920,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','207698',4032542,'2677','397',553045.92,557056.02,4010.10,661666.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','207698',4032543,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','207698',4032544,'2679','397',577512.63,580658.34,3145.71,519042.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','207698',4032545,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','207698',4032546,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','207698',4032547,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','207910',4036089,'2677','397',557056.02,559078.20,2022.18,333659.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','207910',4036090,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','207910',4036091,'2679','397',580658.34,582687.79,2029.45,334859.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','207910',4036092,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','207910',4036093,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','207910',4036094,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','208107',4039598,'2677','397',559078.20,561483.30,2405.10,396841.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','208107',4039599,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','208107',4039600,'2679','397',582687.79,584382.95,1695.16,279701.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','208107',4039601,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','208107',4039602,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','208107',4039603,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','208330',4043604,'2677','397',561483.30,564237.07,2753.77,454372.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','208330',4043605,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','208330',4043606,'2679','397',584382.95,586313.36,1930.41,318517.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','208330',4043607,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','208330',4043608,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','208330',4043609,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','208652',4049155,'2677','397',564237.07,566418.52,2181.45,359939.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','208652',4049156,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','208652',4049157,'2679','397',586313.36,588449.02,2135.66,352383.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','208652',4049158,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','208652',4049159,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','208652',4049160,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','208777',4051265,'2677','397',566418.52,568462.06,2043.54,337184.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','208777',4051266,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','208777',4051267,'2679','397',588449.02,590485.52,2036.50,336022.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','208777',4051268,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','208777',4051269,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','208777',4051270,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','209022',4055380,'2677','397',568462.06,571008.71,2546.65,420197.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','209022',4055381,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','209022',4055382,'2679','397',590485.52,592363.30,1877.78,309833.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','209022',4055383,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','209022',4055384,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','209022',4055385,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','209215',4058977,'2677','397',571008.71,573296.62,2287.91,377505.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','209215',4058978,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','209215',4058979,'2679','397',592363.30,594583.33,2220.03,366304.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','209215',4058980,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','209215',4058981,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','209215',4058982,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','209448',4062999,'2677','397',573296.62,575825.23,2528.61,417220.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','209448',4063000,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','209448',4063001,'2679','397',594583.33,596268.51,1685.18,278054.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','209448',4063002,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','209448',4063003,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','209448',4063004,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','209661',4066784,'2677','397',575825.23,577816.41,1991.18,328544.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','209661',4066785,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','209661',4066786,'2679','397',596268.51,598398.80,2130.29,351497.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','209661',4066787,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','209661',4066788,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','209661',4066789,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','209883',4070679,'2677','397',577816.41,582515.06,4698.65,775277.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','209883',4070680,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','209883',4070681,'2679','397',598398.80,598535.89,137.09,22619.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','209883',4070682,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','209883',4070683,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','209883',4070684,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','210097',4074745,'2677','397',582515.06,585699.89,3184.83,525496.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','210097',4074746,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','210097',4074747,'2679','397',598535.89,598535.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','210097',4074748,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','210097',4074749,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','210097',4074750,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','210480',4081604,'2677','397',585699.89,585980.00,280.11,46218.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','210480',4081605,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','210480',4081606,'2679','397',598535.89,598740.10,204.21,33694.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','210480',4081607,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','210480',4081608,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','210480',4081609,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','210529',4082328,'2677','397',585980.00,588575.64,2595.64,428280.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','210529',4082329,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','210529',4082330,'2679','397',598740.10,600531.21,1791.11,295533.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','210529',4082331,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','210529',4082332,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','210529',4082333,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','210767',4086485,'2677','397',588575.64,591333.11,2757.47,454982.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','210767',4086486,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','210767',4086487,'2679','397',600531.21,602907.75,2376.54,392129.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','210767',4086488,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','210767',4086489,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','210767',4086490,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','210980',4089987,'2677','397',591333.11,594018.86,2685.75,443148.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','210980',4089988,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','210980',4089989,'2679','397',602907.75,604690.97,1783.22,294231.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','210980',4089990,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','210980',4089991,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','210980',4089992,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','211169',4093574,'2677','397',594018.86,597235.96,3217.10,530821.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','211169',4093575,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','211169',4093576,'2679','397',604690.97,607278.19,2587.22,426891.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','211169',4093577,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','211169',4093578,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','211169',4093579,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','211388',4097440,'2677','397',597235.96,600584.13,3348.17,552448.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','211388',4097441,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','211388',4097442,'2679','397',607278.19,610662.12,3383.93,558348.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','211388',4097443,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','211388',4097444,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','211388',4097445,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','211604',4101290,'2677','397',600584.13,602399.60,1815.47,299552.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','211604',4101291,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','211604',4101292,'2679','397',610662.12,612399.97,1737.85,286745.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','211604',4101293,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','211604',4101294,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','211604',4101295,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','211838',4105037,'2677','397',602399.60,606364.58,3964.98,654221.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','211838',4105038,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','211838',4105039,'2679','397',612399.97,612424.15,24.18,3989.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','211838',4105040,'2680','397',590002.99,590002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','211838',4105041,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','211838',4105042,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','212144',4110570,'2677','397',606364.58,608658.40,2293.82,378480.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','212144',4110571,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','212144',4110572,'2679','397',612424.15,612794.81,370.66,61158.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','212144',4110573,'2680','397',590002.99,590112.45,109.46,18060.90,0.00,0.00,0.00,0.00,0.00),('5','174','902','212144',4110574,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','212144',4110575,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','212265',4112617,'2677','397',608658.40,609539.58,881.18,145394.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','212265',4112618,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','212265',4112619,'2679','397',612794.81,614067.89,1273.08,210058.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','212265',4112620,'2680','397',590112.45,592313.65,2201.20,363198.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','212265',4112621,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','212265',4112622,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','212466',4116386,'2677','397',609539.58,610691.40,1151.82,190050.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','212466',4116387,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','212466',4116388,'2679','397',614067.89,615887.50,1819.61,300235.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','212466',4116389,'2680','397',592313.65,593659.75,1346.10,222106.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','212466',4116390,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','212466',4116391,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','212675',4120154,'2677','397',610691.40,612862.41,2171.01,358216.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','212675',4120155,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','212675',4120156,'2679','397',615887.50,617585.05,1697.55,280095.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','212675',4120157,'2680','397',593659.75,593659.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','212675',4120158,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','212675',4120159,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','212884',4123791,'2677','397',612862.41,613616.78,754.37,124471.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','212884',4123792,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','212884',4123793,'2679','397',617585.05,618656.99,1071.94,176870.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','212884',4123794,'2680','397',593659.75,594673.04,1013.29,167192.85,0.00,0.00,0.00,0.00,0.00),('5','174','902','212884',4123795,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','212884',4123796,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','213135',4128167,'2677','397',613616.78,614658.37,1041.59,171862.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','213135',4128168,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','213135',4128169,'2679','397',618656.99,620437.42,1780.43,293770.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','213135',4128170,'2680','397',594673.04,595443.13,770.09,127064.85,0.00,0.00,0.00,0.00,0.00),('5','174','902','213135',4128171,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','213135',4128172,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','213432',4133007,'2677','397',614658.37,616988.55,2330.18,384479.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','213432',4133008,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','213432',4133009,'2679','397',620437.42,621888.93,1451.51,239499.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','213432',4133010,'2680','397',595443.13,595443.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','213432',4133011,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','213432',4133012,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','213776',4138885,'2677','397',616988.55,618673.50,1684.95,278016.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','213776',4138886,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','213776',4138887,'2679','397',621888.93,622311.83,422.90,69778.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','213776',4138888,'2680','397',595443.13,597554.88,2111.75,348438.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','213776',4138889,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','213776',4138890,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','213915',4140922,'2677','397',618673.50,619973.79,1300.29,214547.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','213915',4140923,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','213915',4140924,'2679','397',622311.83,623623.09,1311.26,216357.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','213915',4140925,'2680','397',597554.88,598833.20,1278.32,210922.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','213915',4140926,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','213915',4140927,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','214148',4144964,'2677','397',619973.79,621646.35,1672.56,275972.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','214148',4144965,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','214148',4144966,'2679','397',623623.09,624235.41,612.32,101032.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','214148',4144967,'2680','397',598833.20,600201.90,1368.70,225835.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','214148',4144968,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','214148',4144969,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','214352',4148517,'2677','397',621646.35,623222.50,1576.15,260064.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','214352',4148518,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','214352',4148519,'2679','397',624235.41,625703.68,1468.27,242264.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','214352',4148520,'2680','397',600201.90,600772.92,571.02,94218.30,0.00,0.00,0.00,0.00,0.00),('5','174','902','214352',4148521,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','214352',4148522,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','214587',4152422,'2677','397',623222.50,624281.12,1058.62,174672.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','214587',4152423,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','214587',4152424,'2679','397',625703.68,626027.88,324.20,53493.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','214587',4152425,'2680','397',600772.92,601516.63,743.71,122712.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','214587',4152426,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','214587',4152427,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','214792',4156037,'2677','397',624281.12,625550.47,1269.35,209442.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','214792',4156038,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','214792',4156039,'2679','397',626027.88,627702.83,1674.95,276366.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','214792',4156040,'2680','397',601516.63,602619.46,1102.83,181966.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','214792',4156041,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','214792',4156042,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','215073',4160707,'2677','397',625550.47,627420.42,1869.95,308541.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','215073',4160708,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','215073',4160709,'2679','397',627702.83,629143.69,1440.86,237741.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','215073',4160710,'2680','397',602619.46,603218.46,599.00,98835.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','215073',4160711,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','215073',4160712,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','215285',4164328,'2677','397',627420.42,629142.98,1722.56,284222.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','215285',4164329,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','215285',4164330,'2679','397',629143.69,630330.38,1186.69,195803.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','215285',4164331,'2680','397',603218.46,603917.35,698.89,115316.85,0.00,0.00,0.00,0.00,0.00),('5','174','902','215285',4164332,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','215285',4164333,'2682','399',275310.48,275310.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','215445',4167084,'2677','397',629142.98,630871.27,1728.29,285167.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','215445',4167085,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','215445',4167086,'2679','397',630330.38,631499.44,1169.06,192894.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','215445',4167087,'2680','397',603917.35,605434.83,1517.48,250384.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','215445',4167088,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','215445',4167089,'2682','399',275310.48,275974.74,664.26,195956.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','215742',4172135,'2677','397',630871.27,631700.54,829.27,136829.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','215742',4172136,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','215742',4172137,'2679','397',631499.44,632640.57,1141.13,188286.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','215742',4172138,'2680','397',605434.83,607008.37,1573.54,259634.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','215742',4172139,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','215742',4172140,'2682','399',275974.74,276277.67,302.93,89364.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','215932',4175397,'2677','397',631700.54,632906.79,1206.25,199031.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','215932',4175398,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','215932',4175399,'2679','397',632640.57,633253.41,612.84,101118.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','215932',4175400,'2680','397',607008.37,607516.24,507.87,83798.55,0.00,0.00,0.00,0.00,0.00),('5','174','902','215932',4175401,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','215932',4175402,'2682','399',276277.67,276374.21,96.54,28479.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','216115',4178618,'2677','397',632906.79,634240.60,1333.81,220078.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','216115',4178619,'2678','397',415097.44,415097.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','216115',4178620,'2679','397',633253.41,634200.12,946.71,156207.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','216115',4178621,'2680','397',607516.24,608775.41,1259.17,207763.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','216115',4178622,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','216115',4178623,'2682','399',276374.21,276567.21,193.00,56935.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','216367',4182865,'2677','397',634240.60,636116.96,1876.36,309599.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','216367',4182866,'2678','397',415097.44,415501.13,403.69,66608.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','216367',4182867,'2679','397',634200.12,634915.71,715.59,118072.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','216367',4182868,'2680','397',608775.41,609377.00,601.59,99262.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','216367',4182869,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','216367',4182870,'2682','399',276567.21,276820.01,252.80,74576.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','216578',4186495,'2677','397',636116.96,637683.98,1567.02,258558.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','216578',4186496,'2678','397',415501.13,415984.44,483.31,79746.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','216578',4186497,'2679','397',634915.71,635187.63,271.92,44866.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','216578',4186498,'2680','397',609377.00,610793.15,1416.15,233664.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','216578',4186499,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','216578',4186500,'2682','399',276820.01,277037.34,217.33,64112.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','216797',4190559,'2677','397',637683.98,639177.88,1493.90,246493.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','216797',4190560,'2678','397',415984.44,415984.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','216797',4190561,'2679','397',635187.63,636250.34,1062.71,175347.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','216797',4190562,'2680','397',610793.15,612050.70,1257.55,207495.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','216797',4190563,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','216797',4190564,'2682','399',277037.34,277154.79,117.45,34647.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','217024',4194502,'2677','397',639177.88,639890.42,712.54,117569.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','217024',4194503,'2678','397',415984.44,416594.21,609.77,100612.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','217024',4194504,'2679','397',636250.34,637143.76,893.42,147414.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','217024',4194505,'2680','397',612050.70,613153.35,1102.65,181937.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','217024',4194506,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','217024',4194507,'2682','399',277154.79,277349.09,194.30,57318.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','217298',4199605,'2677','397',639890.42,641541.27,1650.85,272390.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','217298',4199606,'2678','397',416594.21,416600.28,6.07,1001.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','217298',4199607,'2679','397',637143.76,638215.09,1071.33,176769.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','217298',4199608,'2680','397',613153.35,613856.75,703.40,116061.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','217298',4199609,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','217298',4199610,'2682','399',277349.09,277707.23,358.14,105651.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','217653',4205947,'2677','397',641541.27,642863.76,1322.49,218210.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','217653',4205948,'2678','397',416600.28,417185.34,585.06,96534.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','217653',4205949,'2679','397',638215.09,638924.48,709.39,117049.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','217653',4205950,'2680','397',613856.75,614848.27,991.52,163600.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','217653',4205951,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','217653',4205952,'2682','399',277707.23,278131.61,424.38,125192.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','217829',4208981,'2677','397',642863.76,644851.13,1987.37,327916.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','217829',4208982,'2678','397',417185.34,417517.31,331.97,54775.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','217829',4208983,'2679','397',638924.48,639545.09,620.61,102400.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','217829',4208984,'2680','397',614848.27,615835.92,987.65,162962.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','217829',4208985,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','217829',4208986,'2682','399',278131.61,278378.54,246.93,72844.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','218040',4212536,'2677','397',644851.13,646299.11,1447.98,238916.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','218040',4212537,'2678','397',417517.31,417517.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','218040',4212538,'2679','397',639545.09,640813.10,1268.01,209221.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','218040',4212539,'2680','397',615835.92,617405.45,1569.53,258972.45,0.00,0.00,0.00,0.00,0.00),('5','174','902','218040',4212540,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','218040',4212541,'2682','399',278378.54,278676.61,298.07,87930.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','218241',4216069,'2677','397',646299.11,648035.81,1736.70,286555.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','218241',4216070,'2678','397',417517.31,417517.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','218241',4216071,'2679','397',640813.10,642144.11,1331.01,219616.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','218241',4216072,'2680','397',617405.45,617781.62,376.17,62068.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','218241',4216073,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','218241',4216074,'2682','399',278676.61,279036.75,360.14,106241.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','218517',4220999,'2677','397',648035.81,650014.72,1978.91,326520.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','218517',4221000,'2678','397',417517.31,417562.98,45.67,7535.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','218517',4221001,'2679','397',642144.11,643625.79,1481.68,244477.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','218517',4221002,'2680','397',617781.62,618793.32,1011.70,166930.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','218517',4221003,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','218517',4221004,'2682','399',279036.75,279627.41,590.66,174244.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','218761',4225278,'2677','397',650014.72,651426.76,1412.04,232986.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','218761',4225279,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','218761',4225280,'2679','397',643625.79,644692.02,1066.23,175927.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','218761',4225281,'2680','397',618793.32,619926.15,1132.83,186916.95,0.00,0.00,0.00,0.00,0.00),('5','174','902','218761',4225282,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','218761',4225283,'2682','399',279627.41,279887.52,260.11,76732.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','219097',4231362,'2677','397',651426.76,652848.79,1422.03,234634.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','219097',4231363,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','219097',4231364,'2679','397',644692.02,645582.99,890.97,147010.05,0.00,0.00,0.00,0.00,0.00),('5','174','901','219097',4231365,'2680','397',619926.15,621019.42,1093.27,180389.55,0.00,0.00,0.00,0.00,0.00),('5','174','902','219097',4231366,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','219097',4231367,'2682','399',279887.52,280129.30,241.78,71325.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','219155',4232035,'2677','397',652848.79,653747.40,898.61,148270.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','219155',4232036,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','219155',4232037,'2679','397',645582.99,646860.40,1277.41,210772.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','219155',4232038,'2680','397',621019.42,621556.81,537.39,88669.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','219155',4232039,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','219155',4232040,'2682','399',280129.30,280431.89,302.59,89264.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','219359',4235617,'2677','397',653747.40,654601.33,853.93,140898.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','219359',4235618,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','219359',4235619,'2679','397',646860.40,649030.62,2170.22,358086.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','219359',4235620,'2680','397',621556.81,623368.49,1811.68,298927.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','219359',4235621,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','219359',4235622,'2682','399',280431.89,281673.63,1241.74,366313.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','219631',4240254,'2677','397',654601.33,655704.57,1103.24,182034.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','219631',4240255,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','219631',4240256,'2679','397',649030.62,649736.10,705.48,116404.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','219631',4240257,'2680','397',623368.49,624513.57,1145.08,188938.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','219631',4240258,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','219631',4240259,'2682','399',281673.63,281882.09,208.46,61495.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','219839',4244066,'2677','397',655704.57,657279.19,1574.62,259812.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','219839',4244067,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','219839',4244068,'2679','397',649736.10,650834.81,1098.71,181287.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','219839',4244069,'2680','397',624513.57,625099.68,586.11,96708.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','219839',4244070,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','219839',4244071,'2682','399',281882.09,282171.35,289.26,85331.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','220079',4248398,'2677','397',657279.19,658636.36,1357.17,223933.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','220079',4248399,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','220079',4248400,'2679','397',650834.81,652106.96,1272.15,209904.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','220079',4248401,'2680','397',625099.68,625697.34,597.66,98613.90,0.00,0.00,0.00,0.00,0.00),('5','174','902','220079',4248402,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','220079',4248403,'2682','399',282171.35,282385.95,214.60,63307.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','220254',4251550,'2677','397',658636.36,660187.80,1551.44,255987.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','220254',4251551,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','220254',4251552,'2679','397',652106.96,653244.13,1137.17,187633.05,0.00,0.00,0.00,0.00,0.00),('5','174','901','220254',4251553,'2680','397',625697.34,626138.88,441.54,72854.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','220254',4251554,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','220254',4251555,'2682','399',282385.95,282822.59,436.64,128808.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','220492',4255801,'2677','397',660187.80,660941.13,753.33,124299.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','220492',4255802,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','220492',4255803,'2679','397',653244.13,654189.42,945.29,155972.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','220492',4255804,'2680','397',626138.88,627356.22,1217.34,200861.10,0.00,0.00,0.00,0.00,0.00),('5','174','902','220492',4255805,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','220492',4255806,'2682','399',282822.59,282949.13,126.54,37329.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','220716',4259630,'2677','397',660941.13,662267.18,1326.05,218798.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','220716',4259631,'2678','397',417562.98,417562.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','220716',4259632,'2679','397',654189.42,654982.04,792.62,130782.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','220716',4259633,'2680','397',627356.22,628295.53,939.31,154986.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','220716',4259634,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','220716',4259635,'2682','399',282949.13,283158.63,209.50,61802.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','220929',4263477,'2677','397',662267.18,663570.34,1303.16,215021.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','220929',4263478,'2678','397',417562.98,418401.17,838.19,138301.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','220929',4263479,'2679','397',654982.04,655138.71,156.67,25850.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','220929',4263480,'2680','397',628295.53,629585.44,1289.91,212835.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','220929',4263481,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','220929',4263482,'2682','399',283158.63,283379.88,221.25,65268.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','221181',4267872,'2677','397',663570.34,664544.88,974.54,160799.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','221181',4267873,'2678','397',418401.17,418401.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','221181',4267874,'2679','397',655138.71,656205.94,1067.23,176092.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','221181',4267875,'2680','397',629585.44,630626.43,1040.99,171763.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','221181',4267876,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','221181',4267877,'2682','399',283379.88,283447.33,67.45,19897.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','221418',4272153,'2677','397',664544.88,665799.85,1254.97,207070.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','221418',4272154,'2678','397',418401.17,418719.84,318.67,52580.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','221418',4272155,'2679','397',656205.94,657269.60,1063.66,175503.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','221418',4272156,'2680','397',630626.43,631387.45,761.02,125568.30,0.00,0.00,0.00,0.00,0.00),('5','174','902','221418',4272157,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','221418',4272158,'2682','399',283447.33,283702.60,255.27,75304.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','221637',4276243,'2677','397',665799.85,666979.85,1180.00,194700.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','221637',4276244,'2678','397',418719.84,419859.57,1139.73,188055.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','221637',4276245,'2679','397',657269.60,657998.02,728.42,120189.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','221637',4276246,'2680','397',631387.45,631387.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','221637',4276247,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','221637',4276248,'2682','399',283702.60,283902.46,199.86,58958.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','221853',4280032,'2677','397',666979.85,667625.02,645.17,106453.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','221853',4280033,'2678','397',419859.57,421041.65,1182.08,195043.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','221853',4280034,'2679','397',657998.02,659119.65,1121.63,185068.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','221853',4280035,'2680','397',631387.45,631387.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','221853',4280036,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','221853',4280037,'2682','399',283902.46,284249.73,347.27,102444.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','223083',4302325,'2677','397',667625.02,668602.46,977.44,161277.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','223083',4302326,'2678','397',421041.65,421721.51,679.86,112176.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','223083',4302327,'2679','397',659119.65,659659.64,539.99,89098.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','223083',4302328,'2680','397',631387.45,631387.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','223083',4302329,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','223083',4302330,'2682','399',284249.73,284302.39,52.66,15534.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','223092',4302477,'2677','397',668602.46,669623.15,1020.69,168413.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','223092',4302478,'2678','397',421721.51,422282.90,561.39,92629.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','223092',4302479,'2679','397',659659.64,660250.02,590.38,97412.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','223092',4302480,'2680','397',631387.45,631387.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','223092',4302481,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','223092',4302482,'2682','399',284302.39,284412.80,110.41,32570.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','223100',4302603,'2677','397',669623.15,670402.41,779.26,128577.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','223100',4302604,'2678','397',422282.90,422933.80,650.90,107398.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','223100',4302605,'2679','397',660250.02,660565.74,315.72,52093.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','223100',4302606,'2680','397',631387.45,632314.40,926.95,152946.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','223100',4302607,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','223100',4302608,'2682','399',284412.80,284586.48,173.68,51235.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','224440',4326308,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224440',4326309,'2678','397',422933.80,423876.06,942.26,155472.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','224440',4326310,'2679','397',660565.74,661110.40,544.66,89868.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','224440',4326311,'2680','397',632314.40,633152.08,837.68,138217.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','224440',4326312,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224440',4326313,'2682','399',284586.48,284686.48,100.00,29500.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224444',4326399,'2677','397',670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224444',4326400,'2678','397',423876.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','224444',4326401,'2679','397',661110.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','224444',4326402,'2680','397',633152.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','224444',4326403,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224444',4326404,'2682','399',284686.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224447',4326457,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224447',4326458,'2678','397',423876.06,424685.87,809.81,133618.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','224447',4326459,'2679','397',661110.40,661870.84,760.44,125472.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','224447',4326460,'2680','397',633152.08,634289.73,1137.65,187712.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','224447',4326461,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224447',4326462,'2682','399',284686.48,285265.99,579.51,170955.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','224451',4326519,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224451',4326520,'2678','397',424685.87,425634.81,948.94,156575.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','224451',4326521,'2679','397',661870.84,662081.87,211.03,34819.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','224451',4326522,'2680','397',634289.73,635625.37,1335.64,220380.60,0.00,0.00,0.00,0.00,0.00),('5','174','902','224451',4326523,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224451',4326524,'2682','399',285265.99,285331.50,65.51,19325.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','224453',4326591,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224453',4326592,'2678','397',425634.81,426412.68,777.87,128348.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','224453',4326593,'2679','397',662081.87,662465.02,383.15,63219.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','224453',4326594,'2680','397',635625.37,636904.32,1278.95,211026.75,0.00,0.00,0.00,0.00,0.00),('5','174','902','224453',4326595,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224453',4326596,'2682','399',285331.50,285398.46,66.96,19753.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','224456',4326625,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224456',4326626,'2678','397',426412.68,426931.13,518.45,85544.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','224456',4326627,'2679','397',662465.02,663156.74,691.72,114133.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','224456',4326628,'2680','397',636904.32,638458.69,1554.37,256471.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','224456',4326629,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224456',4326630,'2682','399',285398.46,285488.11,89.65,26446.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','224460',4326690,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224460',4326691,'2678','397',426931.13,427334.24,403.11,66513.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','224460',4326692,'2679','397',663156.74,664163.72,1006.98,166151.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','224460',4326693,'2680','397',638458.69,639096.58,637.89,105251.85,0.00,0.00,0.00,0.00,0.00),('5','174','902','224460',4326694,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224460',4326695,'2682','399',285488.11,285565.39,77.28,22797.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','224461',4326696,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224461',4326697,'2678','397',427334.24,427920.32,586.08,96703.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','224461',4326698,'2679','397',664163.72,664490.46,326.74,53912.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','224461',4326699,'2680','397',639096.58,640321.37,1224.79,202090.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','224461',4326700,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224461',4326701,'2682','399',285565.39,285633.37,67.98,20054.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','224463',4326713,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','224463',4326714,'2678','397',427920.32,428248.33,328.01,54121.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','224463',4326715,'2679','397',664490.46,665363.38,872.92,144031.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','224463',4326716,'2680','397',640321.37,641530.44,1209.07,199496.55,0.00,0.00,0.00,0.00,0.00),('5','174','902','224463',4326717,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','224463',4326718,'2682','399',285633.37,285855.55,222.18,65543.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','225881',4351957,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','225881',4351958,'2678','397',428248.33,428459.51,211.18,34844.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','225881',4351959,'2679','397',665363.38,666285.30,921.92,152116.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','225881',4351960,'2680','397',641530.44,642862.91,1332.47,219857.55,0.00,0.00,0.00,0.00,0.00),('5','174','902','225881',4351961,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225881',4351962,'2682','399',285855.55,285938.28,82.73,24405.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','225889',4352127,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','225889',4352128,'2678','397',428459.51,428786.32,326.81,53923.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','225889',4352129,'2679','397',666285.30,667005.76,720.46,118875.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','225889',4352130,'2680','397',642862.91,644241.36,1378.45,227444.25,0.00,0.00,0.00,0.00,0.00),('5','174','902','225889',4352131,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225889',4352132,'2682','399',285938.28,286172.46,234.18,69083.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','225894',4352202,'2677','397',670402.41,670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','225894',4352203,'2678','397',428786.32,429112.05,325.73,53093.99,0.00,0.00,0.00,0.00,0.00),('5','174','900','225894',4352204,'2679','397',667005.76,668183.66,1177.90,191997.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','225894',4352205,'2680','397',644241.36,645423.88,1182.52,192750.76,0.00,0.00,0.00,0.00,0.00),('5','174','902','225894',4352206,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225894',4352207,'2682','399',286172.46,286251.52,79.06,23322.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','225896',4352250,'2677','397',670402.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','225896',4352251,'2678','397',429112.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','225896',4352252,'2679','397',668183.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','225896',4352253,'2680','397',645423.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','225896',4352254,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225896',4352255,'2682','399',286251.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','225901',4352359,'2677','397',670402.41,671503.97,1101.56,179554.28,0.00,0.00,0.00,0.00,0.00),('5','174','899','225901',4352360,'2678','397',429112.05,429877.17,765.12,124714.56,0.00,0.00,0.00,0.00,0.00),('5','174','900','225901',4352361,'2679','397',668183.66,669764.26,1580.60,257637.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','225901',4352362,'2680','397',645423.88,645423.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','225901',4352363,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225901',4352364,'2682','399',286251.52,286643.03,391.51,115495.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','225904',4352399,'2677','397',671503.97,672846.19,1342.22,218781.86,0.00,0.00,0.00,0.00,0.00),('5','174','899','225904',4352400,'2678','397',429877.17,429877.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','225904',4352401,'2679','397',669764.26,670374.31,610.05,99438.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','225904',4352402,'2680','397',645423.88,647019.21,1595.33,260038.79,0.00,0.00,0.00,0.00,0.00),('5','174','902','225904',4352403,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','225904',4352404,'2682','399',286643.03,287341.34,698.31,206001.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','226825',4368835,'2677','397',672846.19,674375.95,1529.76,249350.88,0.00,0.00,0.00,0.00,0.00),('5','174','899','226825',4368836,'2678','397',429877.17,429877.27,0.10,16.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','226825',4368837,'2679','397',670374.31,671446.99,1072.68,174846.84,0.00,0.00,0.00,0.00,0.00),('5','174','901','226825',4368838,'2680','397',647019.21,647155.09,135.88,22148.44,0.00,0.00,0.00,0.00,0.00),('5','174','902','226825',4368839,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','226825',4368840,'2682','399',287341.34,287812.53,471.19,139001.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','226829',4368890,'2677','397',674375.95,675869.36,1493.41,243425.83,0.00,0.00,0.00,0.00,0.00),('5','174','899','226829',4368891,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','226829',4368892,'2679','397',671446.99,672410.91,963.92,157118.96,0.00,0.00,0.00,0.00,0.00),('5','174','901','226829',4368893,'2680','397',647155.09,647494.95,339.86,55397.18,0.00,0.00,0.00,0.00,0.00),('5','174','902','226829',4368894,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','226829',4368895,'2682','399',287812.53,288538.64,726.11,214202.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','226882',4369996,'2677','397',675869.36,677173.55,1304.19,212582.97,0.00,0.00,0.00,0.00,0.00),('5','174','899','226882',4369997,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','226882',4369998,'2679','397',672410.91,673133.43,722.52,117770.76,0.00,0.00,0.00,0.00,0.00),('5','174','901','226882',4369999,'2680','397',647494.95,648027.75,532.80,86846.40,0.00,0.00,0.00,0.00,0.00),('5','174','902','226882',4370000,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','226882',4370001,'2682','399',288538.64,288831.66,293.02,86440.01,0.00,0.00,0.00,0.00,0.00),('5','174','899','226884',4370044,'2677','397',677173.55,678643.62,1470.07,239621.41,0.00,0.00,0.00,0.00,0.00),('5','174','899','226884',4370045,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','226884',4370046,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','226884',4370047,'2680','397',648027.75,649272.39,1244.64,202876.32,0.00,0.00,0.00,0.00,0.00),('5','174','902','226884',4370048,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','226884',4370049,'2682','399',288831.66,289614.73,783.07,231005.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','226889',4370139,'2677','397',678643.62,680347.61,1703.99,277750.37,0.00,0.00,0.00,0.00,0.00),('5','174','899','226889',4370140,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','226889',4370141,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','226889',4370142,'2680','397',649272.39,650613.82,1341.43,218653.09,0.00,0.00,0.00,0.00,0.00),('5','174','902','226889',4370143,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','226889',4370144,'2682','399',289614.73,289881.44,266.71,78679.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','227726',4384677,'2677','397',680347.61,681657.15,1309.54,213455.02,0.00,0.00,0.00,0.00,0.00),('5','174','899','227726',4384678,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','227726',4384679,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','227726',4384680,'2680','397',650613.82,651723.42,1109.60,180864.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','227726',4384681,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','227726',4384682,'2682','399',289881.44,290253.17,371.73,109660.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','227739',4384924,'2677','397',681657.15,682890.00,1232.85,200954.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','227739',4384925,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','227739',4384926,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','227739',4384927,'2680','397',651723.42,653054.54,1331.12,216972.56,0.00,0.00,0.00,0.00,0.00),('5','174','902','227739',4384928,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','227739',4384929,'2682','399',290253.17,290659.16,405.99,119767.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','227764',4385498,'2677','397',682890.00,685149.08,2259.08,368230.04,0.00,0.00,0.00,0.00,0.00),('5','174','899','227764',4385499,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','227764',4385500,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','227764',4385501,'2680','397',653054.54,655580.13,2525.59,411671.17,0.00,0.00,0.00,0.00,0.00),('5','174','902','227764',4385502,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','227764',4385503,'2682','399',290659.16,290854.88,195.72,57737.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','229271',4413825,'2677','397',685149.08,686152.17,1003.09,163503.67,0.00,0.00,0.00,0.00,0.00),('5','174','899','229271',4413826,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','229271',4413827,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','229271',4413828,'2680','397',655580.13,657176.18,1596.05,260156.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','229271',4413829,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','229271',4413830,'2682','399',290854.88,291073.16,218.28,65484.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','229280',4413967,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','229280',4413968,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','229280',4413969,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','229280',4413970,'2680','397',657176.18,659759.57,2583.39,421092.57,0.00,0.00,0.00,0.00,0.00),('5','174','902','229280',4413971,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','229280',4413972,'2682','399',291073.16,291180.91,107.75,32325.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','229394',4416101,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','229394',4416102,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','229394',4416103,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','229394',4416104,'2680','397',659759.57,661404.84,1645.27,268179.01,0.00,0.00,0.00,0.00,0.00),('5','174','902','229394',4416105,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','229394',4416106,'2682','399',291180.91,291278.42,97.51,29253.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230852',4443261,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230852',4443262,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230852',4443263,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230852',4443264,'2680','397',661404.84,662661.72,1256.88,204871.44,0.00,0.00,0.00,0.00,0.00),('5','174','902','230852',4443265,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230852',4443266,'2682','399',291278.42,291797.05,518.63,155589.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230856',4443292,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230856',4443293,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230856',4443294,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230856',4443295,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230856',4443296,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230856',4443297,'2682','399',291797.05,291915.38,118.33,35499.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230863',4443376,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230863',4443377,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230863',4443378,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230863',4443379,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230863',4443380,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230863',4443381,'2682','399',291915.38,292211.39,296.01,88803.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230874',4443556,'2677','397',686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230874',4443557,'2678','397',429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230874',4443558,'2679','397',673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230874',4443559,'2680','397',662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230874',4443560,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230874',4443561,'2682','399',292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230883',4443689,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230883',4443690,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230883',4443691,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230883',4443692,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230883',4443693,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230883',4443694,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230884',4443695,'2677','397',686152.17,686152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230884',4443696,'2678','397',429877.27,429877.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','230884',4443697,'2679','397',673133.43,673133.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','230884',4443698,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230884',4443699,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230884',4443700,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230885',4443701,'2677','397',686152.17,687377.68,1225.51,199758.13,0.00,0.00,0.00,0.00,0.00),('5','174','899','230885',4443702,'2678','397',429877.27,430473.82,596.55,97237.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','230885',4443703,'2679','397',673133.43,673848.52,715.09,116559.67,0.00,0.00,0.00,0.00,0.00),('5','174','901','230885',4443704,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230885',4443705,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230885',4443706,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230891',4443828,'2677','397',687377.68,688356.91,979.23,159614.49,0.00,0.00,0.00,0.00,0.00),('5','174','899','230891',4443829,'2678','397',430473.82,431292.37,818.55,133423.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','230891',4443830,'2679','397',673848.52,674986.42,1137.90,185477.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','230891',4443831,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230891',4443832,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230891',4443833,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230894',4443851,'2677','397',688356.91,689780.69,1423.78,232076.14,0.00,0.00,0.00,0.00,0.00),('5','174','899','230894',4443852,'2678','397',431292.37,432137.97,845.60,137832.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','230894',4443853,'2679','397',674986.42,675675.61,689.19,112337.97,0.00,0.00,0.00,0.00,0.00),('5','174','901','230894',4443854,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230894',4443855,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230894',4443856,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230896',4443880,'2677','397',689780.69,691952.16,2171.47,353949.61,0.00,0.00,0.00,0.00,0.00),('5','174','899','230896',4443881,'2678','397',432137.97,433641.29,1503.32,245041.16,0.00,0.00,0.00,0.00,0.00),('5','174','900','230896',4443882,'2679','397',675675.61,676826.28,1150.67,187559.21,0.00,0.00,0.00,0.00,0.00),('5','174','901','230896',4443883,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230896',4443884,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230896',4443885,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230899',4443929,'2677','397',691952.16,694660.95,2708.79,441532.77,0.00,0.00,0.00,0.00,0.00),('5','174','899','230899',4443930,'2678','397',433641.29,434500.80,859.51,140100.13,0.00,0.00,0.00,0.00,0.00),('5','174','900','230899',4443931,'2679','397',676826.28,678792.65,1966.37,320518.31,0.00,0.00,0.00,0.00,0.00),('5','174','901','230899',4443932,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230899',4443933,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230899',4443934,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230902',4443981,'2677','397',694660.95,697872.76,3211.81,523525.03,0.00,0.00,0.00,0.00,0.00),('5','174','899','230902',4443982,'2678','397',434500.80,436298.96,1798.16,293100.08,0.00,0.00,0.00,0.00,0.00),('5','174','900','230902',4443983,'2679','397',678792.65,680593.77,1801.12,293582.56,0.00,0.00,0.00,0.00,0.00),('5','174','901','230902',4443984,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230902',4443985,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230902',4443986,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','230905',4444034,'2677','397',697872.76,699040.10,1167.34,190276.42,0.00,0.00,0.00,0.00,0.00),('5','174','899','230905',4444035,'2678','397',436298.96,436956.51,657.55,107180.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','230905',4444036,'2679','397',680593.77,681899.42,1305.65,212820.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','230905',4444037,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','230905',4444038,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','230905',4444039,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','231129',4448004,'2677','397',699040.10,700662.15,1622.05,264394.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','231129',4448005,'2678','397',436956.51,437494.14,537.63,87633.69,0.00,0.00,0.00,0.00,0.00),('5','174','900','231129',4448006,'2679','397',681899.42,682796.53,897.11,146228.93,0.00,0.00,0.00,0.00,0.00),('5','174','901','231129',4448007,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','231129',4448008,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','231129',4448009,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','231416',4452473,'2677','397',700662.15,702159.32,1497.17,244038.71,0.00,0.00,0.00,0.00,0.00),('5','174','899','231416',4452474,'2678','397',437494.14,438446.74,952.60,155273.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','231416',4452475,'2679','397',682796.53,683547.42,750.89,122395.07,0.00,0.00,0.00,0.00,0.00),('5','174','901','231416',4452476,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','231416',4452477,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','231416',4452478,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','231655',4456615,'2677','397',702159.32,703185.00,1025.68,167185.84,0.00,0.00,0.00,0.00,0.00),('5','174','899','231655',4456616,'2678','397',438446.74,440163.28,1716.54,279796.02,0.00,0.00,0.00,0.00,0.00),('5','174','900','231655',4456617,'2679','397',683547.42,684840.38,1292.96,210752.48,0.00,0.00,0.00,0.00,0.00),('5','174','901','231655',4456618,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','231655',4456619,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','231655',4456620,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','231953',4462122,'2677','397',703185.00,705135.60,1950.60,317947.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','231953',4462123,'2678','397',440163.28,441710.73,1547.45,252234.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','231953',4462124,'2679','397',684840.38,685361.91,521.53,85009.39,0.00,0.00,0.00,0.00,0.00),('5','174','901','231953',4462125,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','231953',4462126,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','231953',4462127,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','232112',4465003,'2677','397',705135.60,706580.10,1444.50,235453.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','232112',4465004,'2678','397',441710.73,442808.43,1097.70,178925.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','232112',4465005,'2679','397',685361.91,686246.93,885.02,144258.26,0.00,0.00,0.00,0.00,0.00),('5','174','901','232112',4465006,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','232112',4465007,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','232112',4465008,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','232356',4469230,'2677','397',706580.10,708299.36,1719.26,280239.38,0.00,0.00,0.00,0.00,0.00),('5','174','899','232356',4469231,'2678','397',442808.43,443535.65,727.22,118536.86,0.00,0.00,0.00,0.00,0.00),('5','174','900','232356',4469232,'2679','397',686246.93,687412.37,1165.44,189966.72,0.00,0.00,0.00,0.00,0.00),('5','174','901','232356',4469233,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','232356',4469234,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','232356',4469235,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','232635',4474375,'2677','397',708299.36,710605.80,2306.44,375949.72,0.00,0.00,0.00,0.00,0.00),('5','174','899','232635',4474376,'2678','397',443535.65,445137.67,1602.02,261129.26,0.00,0.00,0.00,0.00,0.00),('5','174','900','232635',4474377,'2679','397',687412.37,688903.46,1491.09,243047.67,0.00,0.00,0.00,0.00,0.00),('5','174','901','232635',4474378,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','232635',4474379,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','232635',4474380,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','232897',4479014,'2677','397',710605.80,711778.05,1172.25,191076.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','232897',4479015,'2678','397',445137.67,446494.73,1357.06,221200.78,0.00,0.00,0.00,0.00,0.00),('5','174','900','232897',4479016,'2679','397',688903.46,689755.10,851.64,138817.32,0.00,0.00,0.00,0.00,0.00),('5','174','901','232897',4479017,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','232897',4479018,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','232897',4479019,'2682','399',292211.39,292211.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','233122',4483114,'2677','397',711778.05,713817.50,2039.45,332430.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','233122',4483115,'2678','397',446494.73,447021.56,526.83,85873.29,0.00,0.00,0.00,0.00,0.00),('5','174','900','233122',4483116,'2679','397',689755.10,690702.42,947.32,154413.16,0.00,0.00,0.00,0.00,0.00),('5','174','901','233122',4483117,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','233122',4483118,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','233122',4483119,'2682','399',292211.39,292316.75,105.36,36349.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','233419',4488415,'2677','397',713817.50,715680.78,1863.28,303714.64,0.00,0.00,0.00,0.00,0.00),('5','174','899','233419',4488416,'2678','397',447021.56,448303.68,1282.12,208985.56,0.00,0.00,0.00,0.00,0.00),('5','174','900','233419',4488417,'2679','397',690702.42,691479.30,776.88,126631.44,0.00,0.00,0.00,0.00,0.00),('5','174','901','233419',4488418,'2680','397',662661.72,662661.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','233419',4488419,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','233419',4488420,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','233651',4492646,'2677','397',715680.78,716572.02,891.24,145272.12,0.00,0.00,0.00,0.00,0.00),('5','174','899','233651',4492647,'2678','397',448303.68,449142.97,839.29,136804.27,0.00,0.00,0.00,0.00,0.00),('5','174','900','233651',4492648,'2679','397',691479.30,692658.93,1179.63,192279.69,0.00,0.00,0.00,0.00,0.00),('5','174','901','233651',4492649,'2680','397',662661.72,663101.87,440.15,71744.45,0.00,0.00,0.00,0.00,0.00),('5','174','902','233651',4492650,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','233651',4492651,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','233853',4496310,'2677','397',716572.02,717314.07,742.05,120954.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','233853',4496311,'2678','397',449142.97,449707.48,564.51,92015.13,0.00,0.00,0.00,0.00,0.00),('5','174','900','233853',4496312,'2679','397',692658.93,693517.15,858.22,139889.86,0.00,0.00,0.00,0.00,0.00),('5','174','901','233853',4496313,'2680','397',663101.87,664518.75,1416.88,230951.44,0.00,0.00,0.00,0.00,0.00),('5','174','902','233853',4496314,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','233853',4496315,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','234131',4501510,'2677','397',717314.07,718774.48,1460.41,238046.83,0.00,0.00,0.00,0.00,0.00),('5','174','899','234131',4501511,'2678','397',449707.48,450879.79,1172.31,191086.53,0.00,0.00,0.00,0.00,0.00),('5','174','900','234131',4501512,'2679','397',693517.15,695299.85,1782.70,290580.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','234131',4501513,'2680','397',664518.75,667384.21,2865.46,467069.98,0.00,0.00,0.00,0.00,0.00),('5','174','902','234131',4501514,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','234131',4501515,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','234389',4506050,'2677','397',718774.48,719620.59,846.11,139608.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','234389',4506051,'2678','397',450879.79,451590.98,711.19,117346.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','234389',4506052,'2679','397',695299.85,696696.76,1396.91,230490.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','234389',4506053,'2680','397',667384.21,669069.05,1684.84,277998.60,0.00,0.00,0.00,0.00,0.00),('5','174','902','234389',4506054,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','234389',4506055,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','234681',4511335,'2677','397',719620.59,722257.47,2636.88,435085.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','234681',4511336,'2678','397',451590.98,451612.19,21.21,3499.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','234681',4511337,'2679','397',696696.76,699023.19,2326.43,383860.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','234681',4511338,'2680','397',669069.05,671244.56,2175.51,358959.15,0.00,0.00,0.00,0.00,0.00),('5','174','902','234681',4511339,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','234681',4511340,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','234924',4515657,'2677','397',722257.47,723832.46,1574.99,259873.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','234924',4515658,'2678','397',451612.19,451612.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','234924',4515659,'2679','397',699023.19,700428.62,1405.43,231895.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','234924',4515660,'2680','397',671244.56,672890.15,1645.59,271522.35,0.00,0.00,0.00,0.00,0.00),('5','174','902','234924',4515661,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','234924',4515662,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','235150',4519629,'2677','397',723832.46,727813.09,3980.63,656803.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','235150',4519630,'2678','397',451612.19,451931.27,319.08,52648.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','235150',4519631,'2679','397',700428.62,703307.76,2879.14,475058.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','235150',4519632,'2680','397',672890.15,675543.33,2653.18,437774.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','235150',4519633,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','235150',4519634,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','235478',4525413,'2677','397',727813.09,731505.06,3691.97,609175.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','235478',4525414,'2678','397',451931.27,451931.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','235478',4525415,'2679','397',703307.76,706221.36,2913.60,480744.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','235478',4525416,'2680','397',675543.33,679239.79,3696.46,609915.90,0.00,0.00,0.00,0.00,0.00),('5','174','902','235478',4525417,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','235478',4525418,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','235596',4527216,'2677','397',731505.06,733718.09,2213.03,365149.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','235596',4527217,'2678','397',451931.27,453480.42,1549.15,255609.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','235596',4527218,'2679','397',706221.36,707732.19,1510.83,249286.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','235596',4527219,'2680','397',679239.79,679742.91,503.12,83014.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','235596',4527220,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','235596',4527221,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','235870',4532175,'2677','397',733718.09,737958.65,4240.56,699692.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','235870',4532176,'2678','397',453480.42,456612.55,3132.13,516801.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','235870',4532177,'2679','397',707732.19,710961.11,3228.92,532771.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','235870',4532178,'2680','397',679742.91,680366.28,623.37,102856.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','235870',4532179,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','235870',4532180,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','236188',4537893,'2677','397',737958.65,740632.83,2674.18,441239.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','236188',4537894,'2678','397',456612.55,457901.96,1289.41,212752.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','236188',4537895,'2679','397',710961.11,714424.74,3463.63,571498.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','236188',4537896,'2680','397',680366.28,681566.05,1199.77,197962.05,0.00,0.00,0.00,0.00,0.00),('5','174','902','236188',4537897,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','236188',4537898,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','236311',4540017,'2677','397',740632.83,743538.24,2905.41,479392.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','236311',4540018,'2678','397',457901.96,460018.37,2116.41,349207.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','236311',4540019,'2679','397',714424.74,715958.99,1534.25,253151.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','236311',4540020,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','236311',4540021,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','236311',4540022,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','236597',4544978,'2677','397',743538.24,747660.70,4122.46,680205.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','236597',4544979,'2678','397',460018.37,464034.24,4015.87,662618.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','236597',4544980,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','236597',4544981,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','236597',4544982,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','236597',4544983,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','236783',4548050,'2677','397',747660.70,753113.42,5452.72,899698.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','236783',4548051,'2678','397',464034.24,469279.08,5244.84,865398.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','236783',4548052,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','236783',4548053,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','236783',4548054,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','236783',4548055,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237054',4552801,'2677','397',753113.42,755895.52,2782.10,459046.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','237054',4552802,'2678','397',469279.08,472848.26,3569.18,588914.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','237054',4552803,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','237054',4552804,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','237054',4552805,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','237054',4552806,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237317',4557714,'2677','397',755895.52,760835.49,4939.97,815095.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','237317',4557715,'2678','397',472848.26,478886.32,6038.06,996279.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','237317',4557716,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','237317',4557717,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','237317',4557718,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','237317',4557719,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237428',4559641,'2677','397',760835.49,762865.08,2029.59,334882.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','237428',4559642,'2678','397',478886.32,481171.99,2285.67,377135.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','237428',4559643,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','237428',4559644,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','237428',4559645,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','237428',4559646,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237722',4564886,'2677','397',762865.08,762865.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237722',4564887,'2678','397',481171.99,481171.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','237722',4564888,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','237722',4564889,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','237722',4564890,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','237722',4564891,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237925',4567981,'2677','397',762865.08,762865.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','237925',4567982,'2678','397',481171.99,481171.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','237925',4567983,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','237925',4567984,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','237925',4567985,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','237925',4567986,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','238154',4571596,'2677','397',762865.08,762865.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','238154',4571597,'2678','397',481171.99,481171.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','238154',4571598,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','238154',4571599,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','238154',4571600,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','238154',4571601,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','238429',4576550,'2677','397',762865.08,767023.22,4158.14,686093.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','238429',4576551,'2678','397',481171.99,485166.87,3994.88,659155.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','238429',4576552,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','238429',4576553,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','238429',4576554,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','238429',4576555,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','238644',4579971,'2677','397',767023.22,769864.18,2840.96,468758.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','238644',4579972,'2678','397',485166.87,488067.32,2900.45,478574.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','238644',4579973,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','238644',4579974,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','238644',4579975,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','238644',4579976,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','238833',4583452,'2677','397',769864.18,773232.41,3368.23,555757.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','238833',4583453,'2678','397',488067.32,490453.09,2385.77,393652.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','238833',4583454,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','238833',4583455,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','238833',4583456,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','238833',4583457,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','239147',4589122,'2677','397',773232.41,780525.70,7293.29,1203392.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','239147',4589123,'2678','397',490453.09,496723.55,6270.46,1034625.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','239147',4589124,'2679','397',715958.99,715958.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','239147',4589125,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','239147',4589126,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','239147',4589127,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','239328',4592055,'2677','397',780525.70,784377.81,3852.11,635598.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','239328',4592056,'2678','397',496723.55,499913.63,3190.08,526363.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','239328',4592057,'2679','397',715958.99,718921.57,2962.58,488825.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','239328',4592058,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','239328',4592059,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','239328',4592060,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','239537',4595605,'2677','397',784377.81,789952.10,5574.29,919757.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','239537',4595606,'2678','397',499913.63,504492.57,4578.94,755525.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','239537',4595607,'2679','397',718921.57,723450.48,4528.91,747270.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','239537',4595608,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','239537',4595609,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','239537',4595610,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','239797',4600128,'2677','397',789952.10,794826.63,4874.53,804297.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','239797',4600129,'2678','397',504492.57,504617.57,125.00,20625.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','239797',4600130,'2679','397',723450.48,728894.62,5444.14,898283.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','239797',4600131,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','239797',4600132,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','239797',4600133,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','240036',4604316,'2677','397',794826.63,797802.18,2975.55,490965.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','240036',4604317,'2678','397',504617.57,504937.15,319.58,52730.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','240036',4604318,'2679','397',728894.62,735086.34,6191.72,1021633.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','240036',4604319,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','240036',4604320,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','240036',4604321,'2682','399',292316.75,292316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','240236',4607809,'2677','397',797802.18,801889.36,4087.18,674384.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','240236',4607810,'2678','397',504937.15,508035.39,3098.24,511209.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','240236',4607811,'2679','397',735086.34,737572.53,2486.19,410221.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','240236',4607812,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','240236',4607813,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','240236',4607814,'2682','399',292316.75,292897.02,580.27,200193.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','240531',4612647,'2677','397',801889.36,804759.41,2860.05,471908.25,0.00,0.00,10.00,0.00,0.00),('5','174','899','240531',4612648,'2678','397',508035.39,510931.31,2885.92,476176.80,0.00,0.00,10.00,0.00,0.00),('5','174','900','240531',4612649,'2679','397',737572.53,739479.04,1876.51,309624.15,0.00,0.00,30.00,0.00,0.00),('5','174','901','240531',4612650,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','240531',4612651,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','240531',4612652,'2682','399',292897.02,293053.79,146.77,50635.65,0.00,0.00,10.00,0.00,0.00),('5','174','899','240769',4616266,'2677','397',804759.41,809653.70,4894.29,807557.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','240769',4616267,'2678','397',510931.31,515955.71,5024.40,829026.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','240769',4616268,'2679','397',739479.04,742003.07,2524.03,416464.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','240769',4616269,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','240769',4616270,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','240769',4616271,'2682','399',293053.79,294649.90,1596.11,550657.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','241015',4620667,'2677','397',809653.70,814597.59,4943.89,815741.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','241015',4620668,'2678','397',515955.71,519992.95,4037.24,666144.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','241015',4620669,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','241015',4620670,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','241015',4620671,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','241015',4620672,'2682','399',294649.90,295122.95,473.05,163202.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','241249',4624837,'2677','397',814597.59,818212.52,3594.93,593163.45,0.00,0.00,20.00,0.00,0.00),('5','174','899','241249',4624838,'2678','397',519992.95,524032.06,4029.11,664803.15,0.00,0.00,10.00,0.00,0.00),('5','174','900','241249',4624839,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','241249',4624840,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','241249',4624841,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','241249',4624842,'2682','399',295122.95,295445.22,322.27,111183.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','241522',4629399,'2677','397',818212.52,822452.62,4240.10,699616.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','241522',4629400,'2678','397',524032.06,527685.42,3653.36,602804.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','241522',4629401,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','241522',4629402,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','241522',4629403,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','241522',4629404,'2682','399',295445.22,295963.22,518.00,178710.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','241747',4633499,'2677','397',822452.62,822814.24,361.62,59667.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','241747',4633500,'2678','397',527685.42,527714.54,29.12,4804.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','241747',4633501,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','241747',4633502,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','241747',4633503,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','241747',4633504,'2682','399',295963.22,296265.91,302.69,104428.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','242027',4638272,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','242027',4638273,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','242027',4638274,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','242027',4638275,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','242027',4638276,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','242027',4638277,'2682','399',296265.91,297560.32,1294.41,446571.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','242229',4641856,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','242229',4641857,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','242229',4641858,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','242229',4641859,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','242229',4641860,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','242229',4641861,'2682','399',297560.32,298192.11,631.79,217967.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','242450',4645660,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','242450',4645661,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','242450',4645662,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','242450',4645663,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','242450',4645664,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','242450',4645665,'2682','399',298192.11,298783.31,591.20,203964.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','242712',4650314,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','242712',4650315,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','242712',4650316,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','242712',4650317,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','242712',4650318,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','242712',4650319,'2682','399',298783.31,299576.18,792.87,273540.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','243019',4655592,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243019',4655593,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','243019',4655594,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','243019',4655595,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','243019',4655596,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','243019',4655597,'2682','399',299576.18,300037.59,461.41,159186.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','243180',4658306,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243180',4658307,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','243180',4658308,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','243180',4658309,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','243180',4658310,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','243180',4658311,'2682','399',300037.59,300763.00,725.41,250266.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','243414',4662552,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243414',4662553,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','243414',4662554,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','243414',4662555,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','243414',4662556,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','243414',4662557,'2682','399',300763.00,301460.40,697.40,240603.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243639',4666369,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243639',4666370,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','243639',4666371,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','243639',4666372,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','243639',4666373,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','243639',4666374,'2682','399',301460.40,301904.14,443.74,153090.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','243888',4670782,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','243888',4670783,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','243888',4670784,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','243888',4670785,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','243888',4670786,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','243888',4670787,'2682','399',301904.14,302238.04,333.90,115195.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','244120',4674793,'2677','397',822814.24,822814.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','244120',4674794,'2678','397',527714.54,527714.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','244120',4674795,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','244120',4674796,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','244120',4674797,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','244120',4674798,'2682','399',302238.04,302889.93,651.89,224902.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','244332',4678254,'2677','397',822814.24,827270.35,4456.11,735258.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','244332',4678255,'2678','397',527714.54,531293.77,3579.23,590572.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','244332',4678256,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','244332',4678257,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','244332',4678258,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','244332',4678259,'2682','399',302889.93,303531.53,641.60,221352.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','244699',4684935,'2677','397',827270.35,830335.02,3064.67,505670.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','244699',4684936,'2678','397',531293.77,534095.81,2802.04,462336.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','244699',4684937,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','244699',4684938,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','244699',4684939,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','244699',4684940,'2682','399',303531.53,304149.66,618.13,213254.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','244909',4688576,'2677','397',830335.02,831160.01,824.99,136123.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','244909',4688577,'2678','397',534095.81,534370.73,274.92,45361.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','244909',4688578,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','244909',4688579,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','244909',4688580,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','244909',4688581,'2682','399',304149.66,304603.27,453.61,156495.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','245153',4692888,'2677','397',831160.01,831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245153',4692889,'2678','397',534370.73,534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','245153',4692890,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','245153',4692891,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','245153',4692892,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','245153',4692893,'2682','399',304603.27,304859.64,256.37,88447.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','245258',4694378,'2677','397',831160.01,831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245258',4694379,'2678','397',534370.73,534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','245258',4694380,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','245258',4694381,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','245258',4694382,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','245258',4694383,'2682','399',304859.64,305563.80,704.16,242935.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','245688',4701947,'2677','397',831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245688',4701948,'2678','397',534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','245688',4701949,'2679','397',742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','245688',4701950,'2680','397',681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','245688',4701951,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','245688',4701952,'2682','399',305563.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245761',4703367,'2677','397',831160.01,831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245761',4703368,'2678','397',534370.73,534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','245761',4703369,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','245761',4703370,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','245761',4703371,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','245761',4703372,'2682','399',305563.80,305781.26,217.46,75023.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','245777',4703620,'2677','397',831160.01,831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','245777',4703621,'2678','397',534370.73,534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','245777',4703622,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','245777',4703623,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','245777',4703624,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','245777',4703625,'2682','399',305781.26,306130.88,349.62,120618.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','246003',4706844,'2677','397',831160.01,831160.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','246003',4706845,'2678','397',534370.73,534370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','246003',4706846,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','246003',4706847,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','246003',4706848,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','246003',4706849,'2682','399',306130.88,306237.82,106.94,36894.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','246270',4711441,'2677','397',831160.01,833943.48,2783.47,459272.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','246270',4711442,'2678','397',534370.73,536202.30,1831.57,302209.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','246270',4711443,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','246270',4711444,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','246270',4711445,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','246270',4711446,'2682','399',306237.82,306298.01,60.19,20765.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','246524',4715741,'2677','397',833943.48,836214.70,2251.22,371451.30,0.00,0.00,20.00,0.00,0.00),('5','174','899','246524',4715742,'2678','397',536202.30,538389.14,2156.84,355878.60,0.00,0.00,30.00,0.00,0.00),('5','174','900','246524',4715743,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','246524',4715744,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','246524',4715745,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','246524',4715746,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','246783',4720254,'2677','397',836214.70,838621.90,2407.20,397188.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','246783',4720255,'2678','397',538389.14,540194.49,1805.35,297882.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','246783',4720256,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','246783',4720257,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','246783',4720258,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','246783',4720259,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247027',4724480,'2677','397',838621.90,839361.32,739.42,122004.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','247027',4724481,'2678','397',540194.49,540237.85,43.36,7154.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','247027',4724482,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','247027',4724483,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','247027',4724484,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','247027',4724485,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247310',4729581,'2677','397',839361.32,839361.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247310',4729582,'2678','397',540237.85,540237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','247310',4729583,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','247310',4729584,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','247310',4729585,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','247310',4729586,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247503',4732747,'2677','397',839361.32,839361.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247503',4732748,'2678','397',540237.85,540237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','247503',4732749,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','247503',4732750,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','247503',4732751,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','247503',4732752,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247850',4738648,'2677','397',839361.32,839361.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247850',4738649,'2678','397',540237.85,540237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','247850',4738650,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','247850',4738651,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','247850',4738652,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','247850',4738653,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','247929',4739813,'2677','397',839361.32,843012.31,3650.99,602413.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','247929',4739814,'2678','397',540237.85,540237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','247929',4739815,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','247929',4739816,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','247929',4739817,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','247929',4739818,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','248216',4744727,'2677','397',843012.31,845482.67,2470.36,407609.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','248216',4744728,'2678','397',540237.85,541632.70,1394.85,230150.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','248216',4744729,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','248216',4744730,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','248216',4744731,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','248216',4744732,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','248473',4749065,'2677','397',845482.67,845533.08,50.41,8317.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','248473',4749066,'2678','397',541632.70,546985.34,5352.64,883185.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','248473',4749067,'2679','397',742003.07,742003.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','248473',4749068,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','248473',4749069,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','248473',4749070,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','248784',4754499,'2677','397',845533.08,849206.28,3673.20,606078.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','248784',4754500,'2678','397',546985.34,547057.06,71.72,11833.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','248784',4754501,'2679','397',742003.07,743872.90,1869.83,308521.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','248784',4754502,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','248784',4754503,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','248784',4754504,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249030',4758686,'2677','397',849206.28,853175.31,3969.03,654889.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','249030',4758687,'2678','397',547057.06,547057.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','249030',4758688,'2679','397',743872.90,746893.66,3020.76,498425.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','249030',4758689,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','249030',4758690,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','249030',4758691,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249162',4760547,'2677','397',853175.31,855857.83,2682.52,442615.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','249162',4760548,'2678','397',547057.06,547057.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','249162',4760549,'2679','397',746893.66,750443.44,3549.78,585713.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','249162',4760550,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','249162',4760551,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','249162',4760552,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249394',4764525,'2677','397',855857.83,858827.63,2969.80,490017.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249394',4764526,'2678','397',547057.06,547057.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','249394',4764527,'2679','397',750443.44,753070.27,2626.83,433426.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','249394',4764528,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','249394',4764529,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','249394',4764530,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249696',4769670,'2677','397',858827.63,862248.88,3421.25,564506.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','249696',4769671,'2678','397',547057.06,547057.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','249696',4769672,'2679','397',753070.27,756165.29,3095.02,510678.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','249696',4769673,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','249696',4769674,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','249696',4769675,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','249945',4774044,'2677','397',862248.88,863771.36,1522.48,251209.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','249945',4774045,'2678','397',547057.06,547057.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','249945',4774046,'2679','397',756165.29,759196.77,3031.48,500194.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','249945',4774047,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','249945',4774048,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','249945',4774049,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','250189',4778062,'2677','397',863771.36,867189.80,3418.44,564042.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','250189',4778063,'2678','397',547057.06,547534.60,477.54,78794.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','250189',4778064,'2679','397',759196.77,759196.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','250189',4778065,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','250189',4778066,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','250189',4778067,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','250509',4783423,'2677','397',867189.80,867189.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','250509',4783424,'2678','397',547534.60,547534.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','250509',4783425,'2679','397',759196.77,764213.94,5017.17,827833.05,0.00,0.00,0.00,0.00,0.00),('5','174','901','250509',4783426,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','250509',4783427,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','250509',4783428,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','250931',4790950,'2677','397',867189.80,867543.64,353.84,58383.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','250931',4790951,'2678','397',547534.60,552597.03,5062.43,835300.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','250931',4790952,'2679','397',764213.94,764213.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','250931',4790953,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','250931',4790954,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','250931',4790955,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','250944',4791244,'2677','397',867543.64,868005.83,462.19,76261.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','250944',4791245,'2678','397',552597.03,557261.01,4663.98,769556.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','250944',4791246,'2679','397',764213.94,764213.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','250944',4791247,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','250944',4791248,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','250944',4791249,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','251183',4795335,'2677','397',868005.83,870723.01,2697.18,445034.70,0.00,0.00,20.00,0.00,0.00),('5','174','899','251183',4795336,'2678','397',557261.01,562896.79,5605.78,924953.70,0.00,0.00,30.00,0.00,0.00),('5','174','900','251183',4795337,'2679','397',764213.94,764213.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','251183',4795338,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','251183',4795339,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','251183',4795340,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','251305',4797282,'2677','397',870723.01,875557.67,4834.66,797718.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','251305',4797283,'2678','397',562896.79,562896.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','251305',4797284,'2679','397',764213.94,767949.26,3735.32,616327.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','251305',4797285,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','251305',4797286,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','251305',4797287,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','251537',4801154,'2677','397',875557.67,879739.93,4182.26,690072.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','251537',4801155,'2678','397',562896.79,562896.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','251537',4801156,'2679','397',767949.26,771246.57,3297.31,544056.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','251537',4801157,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','251537',4801158,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','251537',4801159,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','251846',4806711,'2677','397',879739.93,883134.07,3394.14,560033.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','251846',4806712,'2678','397',562896.79,563478.66,581.87,96008.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','251846',4806713,'2679','397',771246.57,774122.97,2876.40,474606.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','251846',4806714,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','251846',4806715,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','251846',4806716,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252047',4810081,'2677','397',883134.07,886897.19,3763.12,620914.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','252047',4810082,'2678','397',563478.66,563501.40,22.74,3752.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','252047',4810083,'2679','397',774122.97,778386.98,4264.01,703561.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','252047',4810084,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','252047',4810085,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','252047',4810086,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252297',4814375,'2677','397',886897.19,886897.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252297',4814376,'2678','397',563501.40,563501.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','252297',4814377,'2679','397',778386.98,784200.58,5813.60,959244.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','252297',4814378,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','252297',4814379,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','252297',4814380,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252559',4819404,'2677','397',886897.19,887033.84,136.65,22547.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','252559',4819405,'2678','397',563501.40,563541.16,39.76,6560.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','252559',4819406,'2679','397',784200.58,790807.23,6606.65,1090097.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','252559',4819407,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','252559',4819408,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','252559',4819409,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252819',4823615,'2677','397',887033.84,891946.24,4912.40,810546.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','252819',4823616,'2678','397',563541.16,563541.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','252819',4823617,'2679','397',790807.23,795290.54,4483.31,739746.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','252819',4823618,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','252819',4823619,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','252819',4823620,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','253062',4827652,'2677','397',891946.24,895010.13,3043.89,502241.85,0.00,0.00,20.00,0.00,0.00),('5','174','899','253062',4827653,'2678','397',563541.16,564499.93,938.77,154897.05,0.00,0.00,20.00,0.00,0.00),('5','174','900','253062',4827654,'2679','397',795290.54,797230.62,1920.08,316813.20,0.00,0.00,20.00,0.00,0.00),('5','174','901','253062',4827655,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','253062',4827656,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','253062',4827657,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','253337',4832284,'2677','397',895010.13,898165.11,3154.98,520571.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','253337',4832285,'2678','397',564499.93,565929.47,1429.54,235874.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','253337',4832286,'2679','397',797230.62,799287.07,2056.45,339314.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','253337',4832287,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','253337',4832288,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','253337',4832289,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','253541',4835709,'2677','397',898165.11,900820.17,2655.06,438084.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','253541',4835710,'2678','397',565929.47,567747.56,1818.09,299984.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','253541',4835711,'2679','397',799287.07,801342.75,2055.68,339187.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','253541',4835712,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','253541',4835713,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','253541',4835714,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','253735',4838973,'2677','397',900820.17,903605.05,2784.88,459505.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','253735',4838974,'2678','397',567747.56,569583.80,1836.24,302979.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','253735',4838975,'2679','397',801342.75,803599.99,2257.24,372444.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','253735',4838976,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','253735',4838977,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','253735',4838978,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254003',4843629,'2677','397',903605.05,903605.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254003',4843630,'2678','397',569583.80,569583.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','254003',4843631,'2679','397',803599.99,808894.54,5294.55,873600.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','254003',4843632,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','254003',4843633,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','254003',4843634,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254216',4847640,'2677','397',903605.05,903605.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254216',4847641,'2678','397',569583.80,569583.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','254216',4847642,'2679','397',808894.54,812954.03,4059.49,669815.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','254216',4847643,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','254216',4847644,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','254216',4847645,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254503',4852482,'2677','397',903605.05,903605.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254503',4852483,'2678','397',569583.80,569583.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','254503',4852484,'2679','397',812954.03,812954.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','254503',4852485,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','254503',4852486,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','254503',4852487,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254774',4857201,'2677','397',903605.05,903605.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','254774',4857202,'2678','397',569583.80,569583.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','254774',4857203,'2679','397',812954.03,812954.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','254774',4857204,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','254774',4857205,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','254774',4857206,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','255019',4861417,'2677','397',903605.05,904002.26,397.21,65539.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','255019',4861418,'2678','397',569583.80,570192.85,609.05,100493.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','255019',4861419,'2679','397',812954.03,813154.03,200.00,33000.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','255019',4861420,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','255019',4861421,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','255019',4861422,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','255287',4866341,'2677','397',904002.26,906159.24,2156.98,355901.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','255287',4866342,'2678','397',570192.85,574960.44,4767.59,786652.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','255287',4866343,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','255287',4866344,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','255287',4866345,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','255287',4866346,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','255514',4869701,'2677','397',906159.24,910732.37,4573.13,754566.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','255514',4869702,'2678','397',574960.44,575845.06,884.62,145962.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','255514',4869703,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','255514',4869704,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','255514',4869705,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','255514',4869706,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','255759',4873870,'2677','397',910732.37,913753.44,3021.07,498476.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','255759',4873871,'2678','397',575845.06,577816.77,1971.71,325332.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','255759',4873872,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','255759',4873873,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','255759',4873874,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','255759',4873875,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256001',4877875,'2677','397',913753.44,914246.83,493.39,81409.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','256001',4877876,'2678','397',577816.77,578453.58,636.81,105073.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','256001',4877877,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','256001',4877878,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','256001',4877879,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','256001',4877880,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256273',4882088,'2677','397',914246.83,914246.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256273',4882089,'2678','397',578453.58,578453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','256273',4882090,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','256273',4882091,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','256273',4882092,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','256273',4882093,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256537',4886741,'2677','397',914246.83,914246.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256537',4886742,'2678','397',578453.58,578453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','256537',4886743,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','256537',4886744,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','256537',4886745,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','256537',4886746,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256796',4891083,'2677','397',914246.83,914246.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256796',4891084,'2678','397',578453.58,578453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','256796',4891085,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','256796',4891086,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','256796',4891087,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','256796',4891088,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256991',4894468,'2677','397',914246.83,914246.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','256991',4894469,'2678','397',578453.58,578453.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','256991',4894470,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','256991',4894471,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','256991',4894472,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','256991',4894473,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257286',4899858,'2677','397',914246.83,914316.83,50.00,8250.00,0.00,0.00,20.00,0.00,0.00),('5','174','899','257286',4899859,'2678','397',578453.58,580353.72,1870.14,308573.10,0.00,0.00,30.00,0.00,0.00),('5','174','900','257286',4899860,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257286',4899861,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257286',4899862,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257286',4899863,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257545',4904212,'2677','397',914316.83,914540.85,224.02,36963.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257545',4904213,'2678','397',580353.72,587706.51,7352.79,1213210.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','257545',4904214,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257545',4904215,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257545',4904216,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257545',4904217,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257546',4904218,'2677','397',914540.85,914620.19,79.34,13091.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257546',4904219,'2678','397',587706.51,595529.94,7823.43,1290865.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257546',4904220,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257546',4904221,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257546',4904222,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257546',4904223,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257547',4904224,'2677','397',914620.19,914620.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257547',4904225,'2678','397',595529.94,600306.27,4776.33,788094.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257547',4904226,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257547',4904227,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257547',4904228,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257547',4904229,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257548',4904230,'2677','397',914620.19,914643.62,23.43,3865.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257548',4904231,'2678','397',600306.27,601514.22,1207.95,199311.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','257548',4904232,'2679','397',813154.03,813154.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257548',4904233,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257548',4904234,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257548',4904235,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257549',4904236,'2677','397',914643.62,914643.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257549',4904237,'2678','397',601514.22,605163.74,3649.52,602170.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257549',4904238,'2679','397',813154.03,813891.09,737.06,121614.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257549',4904239,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257549',4904240,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257549',4904241,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257550',4904242,'2677','397',914643.62,914643.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257550',4904243,'2678','397',605163.74,609348.03,4144.29,683807.85,0.00,0.00,40.00,0.00,0.00),('5','174','900','257550',4904244,'2679','397',813891.09,817451.15,3540.06,584109.90,0.00,0.00,20.00,0.00,0.00),('5','174','901','257550',4904245,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257550',4904246,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257550',4904247,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257551',4904248,'2677','397',914643.62,914872.55,228.93,37773.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','257551',4904249,'2678','397',609348.03,613904.82,4556.79,751870.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','257551',4904250,'2679','397',817451.15,821740.15,4289.00,707685.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257551',4904251,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257551',4904252,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257551',4904253,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257552',4904254,'2677','397',914872.55,914874.91,2.36,389.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257552',4904255,'2678','397',613904.82,615549.18,1644.36,271319.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','257552',4904256,'2679','397',821740.15,826612.20,4872.05,803888.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','257552',4904257,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257552',4904258,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257552',4904259,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257553',4904260,'2677','397',914874.91,915364.28,489.37,80746.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257553',4904261,'2678','397',615549.18,617812.88,2263.70,373510.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257553',4904262,'2679','397',826612.20,831721.84,5109.64,843090.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257553',4904263,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257553',4904264,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257553',4904265,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257554',4904266,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257554',4904267,'2678','397',617812.88,624225.56,6412.68,1058092.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257554',4904268,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257554',4904269,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257554',4904270,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257554',4904271,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257555',4904272,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257555',4904273,'2678','397',624225.56,627335.65,3110.09,513164.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257555',4904274,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257555',4904275,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257555',4904276,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257555',4904277,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257556',4904278,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257556',4904279,'2678','397',627335.65,627335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257556',4904280,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257556',4904281,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257556',4904282,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257556',4904283,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257557',4904284,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257557',4904285,'2678','397',627335.65,627335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257557',4904286,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257557',4904287,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257557',4904288,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257557',4904289,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257558',4904290,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257558',4904291,'2678','397',627335.65,627335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257558',4904292,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257558',4904293,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257558',4904294,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257558',4904295,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257559',4904296,'2677','397',915364.28,915364.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257559',4904297,'2678','397',627335.65,627335.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257559',4904298,'2679','397',831721.84,831721.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257559',4904299,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257559',4904300,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257559',4904301,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257560',4904302,'2677','397',915364.28,916730.04,1365.76,225350.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257560',4904303,'2678','397',627335.65,627946.69,611.04,100821.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257560',4904304,'2679','397',831721.84,831956.17,234.33,38664.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','257560',4904305,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257560',4904306,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257560',4904307,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257561',4904308,'2677','397',916730.04,921142.35,4392.31,724731.15,0.00,0.00,20.00,0.00,0.00),('5','174','899','257561',4904309,'2678','397',627946.69,627946.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257561',4904310,'2679','397',831956.17,838895.59,6919.42,1141704.30,0.00,0.00,20.00,0.00,0.00),('5','174','901','257561',4904311,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257561',4904312,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257561',4904313,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257562',4904314,'2677','397',921142.35,924194.05,3051.70,503530.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','257562',4904315,'2678','397',627946.69,633759.01,5812.32,959032.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257562',4904316,'2679','397',838895.59,839566.23,670.64,110655.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257562',4904317,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257562',4904318,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257562',4904319,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257563',4904320,'2677','397',924194.05,924194.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257563',4904321,'2678','397',633759.01,633759.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257563',4904322,'2679','397',839566.23,845588.47,6022.24,993669.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257563',4904323,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257563',4904324,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257563',4904325,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257564',4904326,'2677','397',924194.05,924194.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257564',4904327,'2678','397',633759.01,633759.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257564',4904328,'2679','397',845588.47,846558.13,969.66,159993.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257564',4904329,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257564',4904330,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257564',4904331,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257565',4904332,'2677','397',924194.05,924194.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257565',4904333,'2678','397',633759.01,633759.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257565',4904334,'2679','397',846558.13,846558.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257565',4904335,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257565',4904336,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257565',4904337,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257566',4904338,'2677','397',924194.05,924194.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257566',4904339,'2678','397',633759.01,633759.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257566',4904340,'2679','397',846558.13,846558.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257566',4904341,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257566',4904342,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257566',4904343,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257567',4904344,'2677','397',924194.05,924926.15,732.10,120796.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','257567',4904345,'2678','397',633759.01,634827.42,1068.41,176287.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257567',4904346,'2679','397',846558.13,846558.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257567',4904347,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257567',4904348,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257567',4904349,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257568',4904350,'2677','397',924926.15,929338.26,4412.11,727998.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','257568',4904351,'2678','397',634827.42,641728.96,6901.54,1138754.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257568',4904352,'2679','397',846558.13,846558.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257568',4904353,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257568',4904354,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257568',4904355,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257569',4904356,'2677','397',929338.26,933634.57,4296.31,708891.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','257569',4904357,'2678','397',641728.96,641878.43,149.47,24662.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','257569',4904358,'2679','397',846558.13,852494.07,5935.94,979430.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','257569',4904359,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257569',4904360,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257569',4904361,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257570',4904362,'2677','397',933634.57,936771.70,3137.13,517626.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','257570',4904363,'2678','397',641878.43,644943.34,3064.91,505710.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','257570',4904364,'2679','397',852494.07,856778.94,4284.87,707003.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','257570',4904365,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257570',4904366,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257570',4904367,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257571',4904368,'2677','397',936771.70,936771.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257571',4904369,'2678','397',644943.34,650151.25,5207.91,859305.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','257571',4904370,'2679','397',856778.94,869059.54,12280.60,2026299.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257571',4904371,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257571',4904372,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257571',4904373,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257572',4904374,'2677','397',936771.70,937162.14,390.44,64422.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257572',4904375,'2678','397',650151.25,650641.33,490.08,80863.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257572',4904376,'2679','397',869059.54,874618.41,5558.87,917213.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','257572',4904377,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257572',4904378,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257572',4904379,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257573',4904380,'2677','397',937162.14,937162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257573',4904381,'2678','397',650641.33,650641.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257573',4904382,'2679','397',874618.41,883216.62,8598.21,1418704.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','257573',4904383,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257573',4904384,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257573',4904385,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257574',4904386,'2677','397',937162.14,937162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257574',4904387,'2678','397',650641.33,650641.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257574',4904388,'2679','397',883216.62,886113.96,2897.34,478061.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','257574',4904389,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257574',4904390,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257574',4904391,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257575',4904392,'2677','397',937162.14,938184.36,1022.22,168666.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257575',4904393,'2678','397',650641.33,664786.16,14144.83,2333896.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257575',4904394,'2679','397',886113.96,890017.11,3903.15,644019.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','257575',4904395,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257575',4904396,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257575',4904397,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257576',4904398,'2677','397',938184.36,938934.50,750.14,123773.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257576',4904399,'2678','397',664786.16,667902.02,3115.86,514116.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257576',4904400,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257576',4904401,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257576',4904402,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257576',4904403,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257577',4904404,'2677','397',938934.50,938934.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257577',4904405,'2678','397',667902.02,667902.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257577',4904406,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257577',4904407,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257577',4904408,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257577',4904409,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257578',4904410,'2677','397',938934.50,939346.73,412.23,68017.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257578',4904411,'2678','397',667902.02,671484.15,3582.13,591051.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257578',4904412,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257578',4904413,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257578',4904414,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257578',4904415,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257579',4904416,'2677','397',939346.73,944200.05,4853.32,800797.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','257579',4904417,'2678','397',671484.15,676717.37,5233.22,863481.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','257579',4904418,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257579',4904419,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257579',4904420,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257579',4904421,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257580',4904422,'2677','397',944200.05,944543.05,343.00,56595.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257580',4904423,'2678','397',676717.37,679417.37,2700.00,445500.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257580',4904424,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257580',4904425,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257580',4904426,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257580',4904427,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257581',4904428,'2677','397',944543.05,944543.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257581',4904429,'2678','397',679417.37,679417.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257581',4904430,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257581',4904431,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257581',4904432,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257581',4904433,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257582',4904434,'2677','397',944543.05,944543.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257582',4904435,'2678','397',679417.37,679417.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257582',4904436,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257582',4904437,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257582',4904438,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257582',4904439,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257583',4904440,'2677','397',944543.05,944543.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257583',4904441,'2678','397',679417.37,679417.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257583',4904442,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257583',4904443,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257583',4904444,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257583',4904445,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257584',4904446,'2677','397',944543.05,944543.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257584',4904447,'2678','397',679417.37,679417.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257584',4904448,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257584',4904449,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257584',4904450,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257584',4904451,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257585',4904452,'2677','397',944543.05,945543.05,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257585',4904453,'2678','397',679417.37,680504.37,1087.00,179355.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257585',4904454,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257585',4904455,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257585',4904456,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257585',4904457,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257586',4904458,'2677','397',945543.05,946860.91,1317.86,217446.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','257586',4904459,'2678','397',680504.37,685745.10,5240.73,864720.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257586',4904460,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257586',4904461,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257586',4904462,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257586',4904463,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257587',4904464,'2677','397',946860.91,949286.07,2395.16,395201.40,0.00,0.00,30.00,0.00,0.00),('5','174','899','257587',4904465,'2678','397',685745.10,689367.07,3601.97,594325.05,0.00,0.00,20.00,0.00,0.00),('5','174','900','257587',4904466,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257587',4904467,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257587',4904468,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257587',4904469,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257588',4904470,'2677','397',949286.07,949329.94,43.87,7238.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257588',4904471,'2678','397',689367.07,690674.64,1307.57,215749.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','257588',4904472,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257588',4904473,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257588',4904474,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257588',4904475,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257589',4904476,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257589',4904477,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257589',4904478,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257589',4904479,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257589',4904480,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257589',4904481,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257590',4904482,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257590',4904483,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257590',4904484,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257590',4904485,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257590',4904486,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257590',4904487,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257591',4904488,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257591',4904489,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257591',4904490,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257591',4904491,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257591',4904492,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257591',4904493,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257592',4904494,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257592',4904495,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257592',4904496,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257592',4904497,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257592',4904498,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257592',4904499,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257593',4904500,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257593',4904501,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257593',4904502,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257593',4904503,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257593',4904504,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257593',4904505,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257594',4904506,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257594',4904507,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257594',4904508,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257594',4904509,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257594',4904510,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257594',4904511,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257595',4904512,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257595',4904513,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257595',4904514,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257595',4904515,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257595',4904516,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257595',4904517,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257596',4904518,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257596',4904519,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257596',4904520,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257596',4904521,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257596',4904522,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257596',4904523,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257597',4904524,'2677','397',949329.94,949329.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257597',4904525,'2678','397',690674.64,690674.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257597',4904526,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257597',4904527,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257597',4904528,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257597',4904529,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257598',4904530,'2677','397',949329.94,951596.64,2266.70,374005.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','257598',4904531,'2678','397',690674.64,692551.25,1876.61,309640.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257598',4904532,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257598',4904533,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257598',4904534,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257598',4904535,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257599',4904536,'2677','397',951596.64,955756.52,4129.88,681430.20,0.00,0.00,30.00,0.00,0.00),('5','174','899','257599',4904537,'2678','397',692551.25,696044.75,3473.50,573127.50,0.00,0.00,20.00,0.00,0.00),('5','174','900','257599',4904538,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257599',4904539,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257599',4904540,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257599',4904541,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257600',4904542,'2677','397',955756.52,960429.81,4673.29,771092.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','257600',4904543,'2678','397',696044.75,699054.00,3009.25,496526.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257600',4904544,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257600',4904545,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257600',4904546,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257600',4904547,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257601',4904548,'2677','397',960429.81,961091.94,622.13,102651.45,0.00,0.00,40.00,0.00,0.00),('5','174','899','257601',4904549,'2678','397',699054.00,699669.26,595.26,98217.90,0.00,0.00,20.00,0.00,0.00),('5','174','900','257601',4904550,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257601',4904551,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257601',4904552,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257601',4904553,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257602',4904554,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257602',4904555,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257602',4904556,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257602',4904557,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257602',4904558,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257602',4904559,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257603',4904560,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257603',4904561,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257603',4904562,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257603',4904563,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257603',4904564,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257603',4904565,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257604',4904566,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257604',4904567,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257604',4904568,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257604',4904569,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257604',4904570,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257604',4904571,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257605',4904572,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257605',4904573,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257605',4904574,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257605',4904575,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257605',4904576,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257605',4904577,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257606',4904578,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257606',4904579,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257606',4904580,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257606',4904581,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257606',4904582,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257606',4904583,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257607',4904584,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257607',4904585,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257607',4904586,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257607',4904587,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257607',4904588,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257607',4904589,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257608',4904590,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257608',4904591,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257608',4904592,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257608',4904593,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257608',4904594,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257608',4904595,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257609',4904596,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257609',4904597,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257609',4904598,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257609',4904599,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257609',4904600,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257609',4904601,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257610',4904602,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257610',4904603,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257610',4904604,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257610',4904605,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257610',4904606,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257610',4904607,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257611',4904608,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257611',4904609,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257611',4904610,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257611',4904611,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257611',4904612,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257611',4904613,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257612',4904614,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257612',4904615,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257612',4904616,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257612',4904617,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257612',4904618,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257612',4904619,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257613',4904620,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257613',4904621,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257613',4904622,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257613',4904623,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257613',4904624,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257613',4904625,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257614',4904626,'2677','397',961091.94,961091.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257614',4904627,'2678','397',699669.26,699669.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257614',4904628,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257614',4904629,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257614',4904630,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257614',4904631,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257615',4904632,'2677','397',961091.94,962092.14,1000.20,165033.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257615',4904633,'2678','397',699669.26,700848.26,1179.00,194535.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257615',4904634,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257615',4904635,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257615',4904636,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257615',4904637,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257616',4904638,'2677','397',962092.14,963652.72,1560.58,257495.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','257616',4904639,'2678','397',700848.26,703900.90,3052.64,503685.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257616',4904640,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257616',4904641,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257616',4904642,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257616',4904643,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257617',4904644,'2677','397',963652.72,965019.64,1366.92,225541.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','257617',4904645,'2678','397',703900.90,707113.24,3212.34,530036.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257617',4904646,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257617',4904647,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257617',4904648,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257617',4904649,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257618',4904650,'2677','397',965019.64,965048.26,28.62,4722.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257618',4904651,'2678','397',707113.24,709113.23,1999.99,329998.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','257618',4904652,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257618',4904653,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257618',4904654,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257618',4904655,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257619',4904656,'2677','397',965048.26,965048.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257619',4904657,'2678','397',709113.23,709113.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257619',4904658,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257619',4904659,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257619',4904660,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257619',4904661,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257620',4904662,'2677','397',965048.26,965048.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257620',4904663,'2678','397',709113.23,709113.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257620',4904664,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257620',4904665,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257620',4904666,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257620',4904667,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257621',4904668,'2677','397',965048.26,965048.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257621',4904669,'2678','397',709113.23,709113.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257621',4904670,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257621',4904671,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257621',4904672,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257621',4904673,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257622',4904674,'2677','397',965048.26,966047.57,999.31,164886.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','257622',4904675,'2678','397',709113.23,711300.23,2187.00,360855.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257622',4904676,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257622',4904677,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257622',4904678,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257622',4904679,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257623',4904680,'2677','397',966047.57,968994.24,2946.67,486200.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257623',4904681,'2678','397',711300.23,714302.96,3002.73,495450.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257623',4904682,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257623',4904683,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257623',4904684,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257623',4904685,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257624',4904686,'2677','397',968994.24,973277.01,4282.77,706657.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257624',4904687,'2678','397',714302.96,715304.95,1001.99,165328.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','257624',4904688,'2679','397',890017.11,890017.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257624',4904689,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257624',4904690,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257624',4904691,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257625',4904692,'2677','397',973277.01,973526.85,249.84,41223.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257625',4904693,'2678','397',715304.95,717876.73,2571.78,424343.70,0.00,0.00,0.00,0.00,0.00),('5','174','900','257625',4904694,'2679','397',890017.11,892517.10,2499.99,412498.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','257625',4904695,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257625',4904696,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257625',4904697,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257626',4904698,'2677','397',973526.85,973526.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257626',4904699,'2678','397',717876.73,717876.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257626',4904700,'2679','397',892517.10,897917.07,5399.97,890995.05,0.00,0.00,0.00,0.00,0.00),('5','174','901','257626',4904701,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257626',4904702,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257626',4904703,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257627',4904704,'2677','397',973526.85,973526.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257627',4904705,'2678','397',717876.73,717876.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257627',4904706,'2679','397',897917.07,902176.10,4259.03,702739.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','257627',4904707,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257627',4904708,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257627',4904709,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257628',4904710,'2677','397',973526.85,973526.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257628',4904711,'2678','397',717876.73,719025.70,1148.97,189580.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','257628',4904712,'2679','397',902176.10,908041.30,5865.20,967758.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257628',4904713,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257628',4904714,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257628',4904715,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257629',4904716,'2677','397',973526.85,976786.50,3259.65,537842.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','257629',4904717,'2678','397',719025.70,721366.60,2340.90,386248.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257629',4904718,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257629',4904719,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257629',4904720,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257629',4904721,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257630',4904722,'2677','397',976786.50,977506.70,720.20,118833.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257630',4904723,'2678','397',721366.60,721366.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257630',4904724,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257630',4904725,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257630',4904726,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257630',4904727,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257631',4904728,'2677','397',977506.70,983721.71,6215.01,1025476.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','257631',4904729,'2678','397',721366.60,721366.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257631',4904730,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257631',4904731,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257631',4904732,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257631',4904733,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257632',4904734,'2677','397',983721.71,986872.91,3151.20,519948.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257632',4904735,'2678','397',721366.60,724466.30,3099.70,511450.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257632',4904736,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257632',4904737,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257632',4904738,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257632',4904739,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257633',4904740,'2677','397',986872.91,990498.50,3625.59,598222.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257633',4904741,'2678','397',724466.30,726680.50,2214.20,365343.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257633',4904742,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257633',4904743,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257633',4904744,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257633',4904745,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257634',4904746,'2677','397',990498.50,992170.12,1671.62,275817.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257634',4904747,'2678','397',726680.50,733454.12,6773.62,1117647.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','257634',4904748,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257634',4904749,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257634',4904750,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257634',4904751,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257635',4904752,'2677','397',992170.12,994085.30,1915.18,316004.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','257635',4904753,'2678','397',733454.12,741178.37,7724.25,1274501.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257635',4904754,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257635',4904755,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257635',4904756,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257635',4904757,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257636',4904758,'2677','397',994085.30,997667.42,3582.12,591049.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','257636',4904759,'2678','397',741178.37,742721.09,1542.72,254548.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257636',4904760,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257636',4904761,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257636',4904762,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257636',4904763,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257637',4904764,'2677','397',997667.42,999668.42,2001.00,330165.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257637',4904765,'2678','397',742721.09,745862.52,3141.43,518335.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257637',4904766,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257637',4904767,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257637',4904768,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257637',4904769,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257638',4904770,'2677','397',999668.42,1003190.43,3522.01,581131.65,0.00,0.00,0.00,0.00,0.00),('5','174','899','257638',4904771,'2678','397',745862.52,746960.53,1098.01,181171.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257638',4904772,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257638',4904773,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257638',4904774,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257638',4904775,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257639',4904776,'2677','397',1003190.43,1004310.85,1120.42,184869.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257639',4904777,'2678','397',746960.53,746960.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257639',4904778,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257639',4904779,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257639',4904780,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257639',4904781,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257640',4904782,'2677','397',1004310.85,1004310.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257640',4904783,'2678','397',746960.53,750243.64,3283.11,541713.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','257640',4904784,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257640',4904785,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257640',4904786,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257640',4904787,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257641',4904788,'2677','397',1004310.85,1004310.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257641',4904789,'2678','397',750243.64,754382.89,4139.25,682976.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257641',4904790,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257641',4904791,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257641',4904792,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257641',4904793,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257642',4904794,'2677','397',1004310.85,1004310.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257642',4904795,'2678','397',754382.89,759141.96,4759.07,785246.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','257642',4904796,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257642',4904797,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257642',4904798,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257642',4904799,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257643',4904800,'2677','397',1004310.85,1005525.98,1215.13,200496.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','257643',4904801,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257643',4904802,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257643',4904803,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257643',4904804,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257643',4904805,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257644',4904806,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257644',4904807,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257644',4904808,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257644',4904809,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257644',4904810,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257644',4904811,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257645',4904812,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257645',4904813,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257645',4904814,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257645',4904815,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257645',4904816,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257645',4904817,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257646',4904818,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257646',4904819,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257646',4904820,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257646',4904821,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257646',4904822,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257646',4904823,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257647',4904824,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257647',4904825,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257647',4904826,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257647',4904827,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257647',4904828,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257647',4904829,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257648',4904830,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257648',4904831,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257648',4904832,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257648',4904833,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257648',4904834,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257648',4904835,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257649',4904836,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257649',4904837,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257649',4904838,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257649',4904839,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257649',4904840,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257649',4904841,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257650',4904842,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257650',4904843,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257650',4904844,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257650',4904845,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257650',4904846,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257650',4904847,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257651',4904848,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257651',4904849,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257651',4904850,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257651',4904851,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257651',4904852,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257651',4904853,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257652',4904854,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257652',4904855,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257652',4904856,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257652',4904857,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257652',4904858,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257652',4904859,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257653',4904860,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257653',4904861,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257653',4904862,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257653',4904863,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257653',4904864,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257653',4904865,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257654',4904866,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257654',4904867,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257654',4904868,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257654',4904869,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257654',4904870,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257654',4904871,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257655',4904872,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257655',4904873,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257655',4904874,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257655',4904875,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257655',4904876,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257655',4904877,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257656',4904878,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257656',4904879,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257656',4904880,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257656',4904881,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257656',4904882,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257656',4904883,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257657',4904884,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257657',4904885,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257657',4904886,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257657',4904887,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257657',4904888,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257657',4904889,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257658',4904890,'2677','397',1005525.98,1005525.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257658',4904891,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257658',4904892,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257658',4904893,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257658',4904894,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257658',4904895,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257659',4904896,'2677','397',1005525.98,1007679.00,2153.02,355248.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257659',4904897,'2678','397',759141.96,759141.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257659',4904898,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257659',4904899,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257659',4904900,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257659',4904901,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257660',4904902,'2677','397',1007679.00,1007679.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257660',4904903,'2678','397',759141.96,763762.99,4621.03,762469.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257660',4904904,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257660',4904905,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257660',4904906,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257660',4904907,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257661',4904908,'2677','397',1007679.00,1012403.63,4724.63,779563.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257661',4904909,'2678','397',763762.99,763762.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257661',4904910,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257661',4904911,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257661',4904912,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257661',4904913,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257662',4904914,'2677','397',1012403.63,1017446.14,5042.51,832014.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','257662',4904915,'2678','397',763762.99,763762.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257662',4904916,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257662',4904917,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257662',4904918,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257662',4904919,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257663',4904920,'2677','397',1017446.14,1021977.23,4531.09,747629.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','257663',4904921,'2678','397',763762.99,764365.85,602.86,99471.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257663',4904922,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257663',4904923,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257663',4904924,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257663',4904925,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257664',4904926,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257664',4904927,'2678','397',764365.85,769526.98,5161.13,851586.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257664',4904928,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257664',4904929,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257664',4904930,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257664',4904931,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257665',4904932,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257665',4904933,'2678','397',769526.98,771741.98,2215.00,365475.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257665',4904934,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257665',4904935,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257665',4904936,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257665',4904937,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257666',4904938,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257666',4904939,'2678','397',771741.98,771741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257666',4904940,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257666',4904941,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257666',4904942,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257666',4904943,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257667',4904944,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257667',4904945,'2678','397',771741.98,771741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257667',4904946,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257667',4904947,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257667',4904948,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257667',4904949,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257668',4904950,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257668',4904951,'2678','397',771741.98,771741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257668',4904952,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257668',4904953,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257668',4904954,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257668',4904955,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257669',4904956,'2677','397',1021977.23,1021977.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257669',4904957,'2678','397',771741.98,771741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257669',4904958,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257669',4904959,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257669',4904960,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257669',4904961,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257670',4904962,'2677','397',1021977.23,1022705.00,727.77,120082.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257670',4904963,'2678','397',771741.98,772839.58,1097.60,181104.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257670',4904964,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257670',4904965,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257670',4904966,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257670',4904967,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257671',4904968,'2677','397',1022705.00,1025801.32,3096.32,510892.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','257671',4904969,'2678','397',772839.58,774758.02,1918.44,316542.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257671',4904970,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257671',4904971,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257671',4904972,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257671',4904973,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257672',4904974,'2677','397',1025801.32,1028853.52,3052.20,503613.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257672',4904975,'2678','397',774758.02,775924.54,1166.52,192475.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257672',4904976,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257672',4904977,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257672',4904978,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257672',4904979,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257673',4904980,'2677','397',1028853.52,1031953.25,3099.73,511455.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','257673',4904981,'2678','397',775924.54,777939.00,2014.46,332385.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257673',4904982,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257673',4904983,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257673',4904984,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257673',4904985,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257674',4904986,'2677','397',1031953.25,1033055.52,1102.27,181874.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257674',4904987,'2678','397',777939.00,781159.52,3220.52,531385.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257674',4904988,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257674',4904989,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257674',4904990,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257674',4904991,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257675',4904992,'2677','397',1033055.52,1033055.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257675',4904993,'2678','397',781159.52,785298.02,4138.50,682852.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257675',4904994,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257675',4904995,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257675',4904996,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257675',4904997,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257676',4904998,'2677','397',1033055.52,1033055.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257676',4904999,'2678','397',785298.02,789309.05,4011.03,661820.61,0.00,0.00,0.00,0.00,0.00),('5','174','900','257676',4905000,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257676',4905001,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257676',4905002,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257676',4905003,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257677',4905004,'2677','397',1033055.52,1036869.77,3814.25,629351.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','257677',4905005,'2678','397',789309.05,789309.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257677',4905006,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257677',4905007,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257677',4905008,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257677',4905009,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257678',4905010,'2677','397',1036869.77,1041004.02,4134.25,682151.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','257678',4905011,'2678','397',789309.05,789309.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257678',4905012,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257678',4905013,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257678',4905014,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257678',4905015,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257679',4905016,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257679',4905017,'2678','397',789309.05,792456.30,3147.25,519296.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257679',4905018,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257679',4905019,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257679',4905020,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257679',4905021,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257680',4905022,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257680',4905023,'2678','397',792456.30,792456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257680',4905024,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257680',4905025,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257680',4905026,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257680',4905027,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257681',4905028,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257681',4905029,'2678','397',792456.30,792456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257681',4905030,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257681',4905031,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257681',4905032,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257681',4905033,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257682',4905034,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257682',4905035,'2678','397',792456.30,792456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257682',4905036,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257682',4905037,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257682',4905038,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257682',4905039,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257683',4905040,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257683',4905041,'2678','397',792456.30,792456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257683',4905042,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257683',4905043,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257683',4905044,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257683',4905045,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257684',4905046,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257684',4905047,'2678','397',792456.30,792968.53,512.23,84517.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257684',4905048,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257684',4905049,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257684',4905050,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257684',4905051,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257685',4905052,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257685',4905053,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257685',4905054,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257685',4905055,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257685',4905056,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257685',4905057,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257686',4905058,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257686',4905059,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257686',4905060,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257686',4905061,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257686',4905062,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257686',4905063,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257687',4905064,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257687',4905065,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257687',4905066,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257687',4905067,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257687',4905068,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257687',4905069,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257688',4905070,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257688',4905071,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257688',4905072,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257688',4905073,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257688',4905074,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257688',4905075,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257689',4905076,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257689',4905077,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257689',4905078,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257689',4905079,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257689',4905080,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257689',4905081,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257690',4905082,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257690',4905083,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257690',4905084,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257690',4905085,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257690',4905086,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257690',4905087,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257691',4905088,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257691',4905089,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257691',4905090,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257691',4905091,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257691',4905092,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257691',4905093,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257692',4905094,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257692',4905095,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257692',4905096,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257692',4905097,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257692',4905098,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257692',4905099,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257693',4905100,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257693',4905101,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257693',4905102,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257693',4905103,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257693',4905104,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257693',4905105,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257694',4905106,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257694',4905107,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257694',4905108,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257694',4905109,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257694',4905110,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257694',4905111,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257695',4905112,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257695',4905113,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257695',4905114,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257695',4905115,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257695',4905116,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257695',4905117,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257696',4905118,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257696',4905119,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257696',4905120,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257696',4905121,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257696',4905122,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257696',4905123,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257697',4905124,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257697',4905125,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257697',4905126,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257697',4905127,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257697',4905128,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257697',4905129,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257698',4905130,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257698',4905131,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257698',4905132,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257698',4905133,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257698',4905134,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257698',4905135,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257699',4905136,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257699',4905137,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257699',4905138,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257699',4905139,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257699',4905140,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257699',4905141,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257700',4905142,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257700',4905143,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257700',4905144,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257700',4905145,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257700',4905146,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257700',4905147,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257701',4905148,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257701',4905149,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257701',4905150,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257701',4905151,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257701',4905152,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257701',4905153,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257702',4905154,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257702',4905155,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257702',4905156,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257702',4905157,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257702',4905158,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257702',4905159,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257703',4905160,'2677','397',1041004.02,1041004.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257703',4905161,'2678','397',792968.53,792968.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257703',4905162,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257703',4905163,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257703',4905164,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257703',4905165,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257704',4905166,'2677','397',1041004.02,1042702.02,1698.00,280170.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257704',4905167,'2678','397',792968.53,796183.21,3214.68,530422.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257704',4905168,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257704',4905169,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257704',4905170,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257704',4905171,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257705',4905172,'2677','397',1042702.02,1044863.21,2161.19,356596.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257705',4905173,'2678','397',796183.21,798240.10,2056.89,339386.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257705',4905174,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257705',4905175,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257705',4905176,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257705',4905177,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257706',4905178,'2677','397',1044863.21,1044863.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257706',4905179,'2678','397',798240.10,801892.25,3652.15,602604.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','257706',4905180,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257706',4905181,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257706',4905182,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257706',4905183,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257707',4905184,'2677','397',1044863.21,1047991.52,3128.31,516171.15,0.00,0.00,0.00,0.00,0.00),('5','174','899','257707',4905185,'2678','397',801892.25,801892.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257707',4905186,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257707',4905187,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257707',4905188,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257707',4905189,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257708',4905190,'2677','397',1047991.52,1048993.25,1001.73,185320.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257708',4905191,'2678','397',801892.25,801929.53,37.28,6896.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257708',4905192,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257708',4905193,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257708',4905194,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257708',4905195,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257709',4905196,'2677','397',1048993.25,1048993.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257709',4905197,'2678','397',801929.53,801929.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257709',4905198,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257709',4905199,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257709',4905200,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257709',4905201,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257710',4905202,'2677','397',1048993.25,1050817.53,1824.28,337491.80,0.00,0.00,0.00,0.00,0.00),('5','174','899','257710',4905203,'2678','397',801929.53,803931.05,2001.52,370281.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257710',4905204,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257710',4905205,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257710',4905206,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257710',4905207,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257711',4905208,'2677','397',1050817.53,1052919.25,2101.72,388818.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257711',4905209,'2678','397',803931.05,806971.99,3040.94,562573.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257711',4905210,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257711',4905211,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257711',4905212,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257711',4905213,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257712',4905214,'2677','397',1052919.25,1056013.21,3093.96,572382.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257712',4905215,'2678','397',806971.99,809450.72,2478.73,458565.05,0.00,0.00,0.00,0.00,0.00),('5','174','900','257712',4905216,'2679','397',908041.30,908041.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257712',4905217,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257712',4905218,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257712',4905219,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257713',4905220,'2677','397',1056013.21,1057411.99,1398.78,258774.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257713',4905221,'2678','397',809450.72,810307.72,857.00,158545.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257713',4905222,'2679','397',908041.30,912023.51,3982.21,736708.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','257713',4905223,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257713',4905224,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257713',4905225,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257714',4905226,'2677','397',1057411.99,1060520.00,3108.01,574981.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','257714',4905227,'2678','397',810307.72,813309.95,3002.23,555412.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','257714',4905228,'2679','397',912023.51,912023.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257714',4905229,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257714',4905230,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257714',4905231,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257715',4905232,'2677','397',1060520.00,1062022.51,1502.51,277964.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257715',4905233,'2678','397',813309.95,813309.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257715',4905234,'2679','397',912023.51,917143.82,5120.31,947257.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','257715',4905235,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257715',4905236,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257715',4905237,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257716',4905238,'2677','397',1062022.51,1067032.25,5009.74,926801.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','257716',4905239,'2678','397',813309.95,813309.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257716',4905240,'2679','397',917143.82,919217.52,2073.70,383634.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','257716',4905241,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257716',4905242,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257716',4905243,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257717',4905244,'2677','397',1067032.25,1067032.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257717',4905245,'2678','397',813309.95,818829.20,5519.25,1021061.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257717',4905246,'2679','397',919217.52,919217.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257717',4905247,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257717',4905248,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257717',4905249,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257718',4905250,'2677','397',1067032.25,1067032.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257718',4905251,'2678','397',818829.20,823471.98,4642.78,858914.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','257718',4905252,'2679','397',919217.52,919217.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257718',4905253,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257718',4905254,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257718',4905255,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257719',4905256,'2677','397',1067032.25,1069602.31,2570.06,424059.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','257719',4905257,'2678','397',823471.98,826338.81,2866.83,473026.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257719',4905258,'2679','397',919217.52,919217.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257719',4905259,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257719',4905260,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257719',4905261,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257720',4905262,'2677','397',1069602.31,1071294.35,1692.04,279186.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257720',4905263,'2678','397',826338.81,829750.86,3412.05,562988.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257720',4905264,'2679','397',919217.52,919217.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257720',4905265,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257720',4905266,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257720',4905267,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257721',4905268,'2677','397',1071294.35,1074098.25,2803.90,518721.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','257721',4905269,'2678','397',829750.86,830754.25,1003.39,185627.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','257721',4905270,'2679','397',919217.52,920418.59,1201.07,222197.95,0.00,0.00,0.00,0.00,0.00),('5','174','901','257721',4905271,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257721',4905272,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257721',4905273,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257722',4905274,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257722',4905275,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257722',4905276,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257722',4905277,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257722',4905278,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257722',4905279,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257723',4905280,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257723',4905281,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257723',4905282,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257723',4905283,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257723',4905284,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257723',4905285,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257724',4905286,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257724',4905287,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257724',4905288,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257724',4905289,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257724',4905290,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257724',4905291,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257725',4905292,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257725',4905293,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257725',4905294,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257725',4905295,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257725',4905296,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257725',4905297,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257726',4905298,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257726',4905299,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257726',4905300,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257726',4905301,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257726',4905302,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257726',4905303,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257727',4905304,'2677','397',1074098.25,1074098.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257727',4905305,'2678','397',830754.25,830754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257727',4905306,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257727',4905307,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257727',4905308,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257727',4905309,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257728',4905310,'2677','397',1074098.25,1076099.96,2001.71,370316.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257728',4905311,'2678','397',830754.25,831271.31,517.06,95656.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257728',4905312,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257728',4905313,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257728',4905314,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257728',4905315,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257729',4905316,'2677','397',1076099.96,1079072.21,2972.25,549866.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','257729',4905317,'2678','397',831271.31,833752.41,2481.10,459003.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257729',4905318,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257729',4905319,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257729',4905320,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257729',4905321,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257730',4905322,'2677','397',1079072.21,1079072.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257730',4905323,'2678','397',833752.41,838538.96,4786.55,885511.75,0.00,0.00,0.00,0.00,0.00),('5','174','900','257730',4905324,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257730',4905325,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257730',4905326,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257730',4905327,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257731',4905328,'2677','397',1079072.21,1080268.28,1196.07,221272.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257731',4905329,'2678','397',838538.96,842390.52,3851.56,712538.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257731',4905330,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257731',4905331,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257731',4905332,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257731',4905333,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257732',4905334,'2677','397',1080268.28,1085492.51,5224.23,966482.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257732',4905335,'2678','397',842390.52,842390.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257732',4905336,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257732',4905337,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257732',4905338,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257732',4905339,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257733',4905340,'2677','397',1085492.51,1085840.25,347.74,64331.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','257733',4905341,'2678','397',842390.52,846866.55,4476.03,828065.55,0.00,0.00,0.00,0.00,0.00),('5','174','900','257733',4905342,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257733',4905343,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257733',4905344,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257733',4905345,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257734',4905346,'2677','397',1085840.25,1086553.03,712.78,131864.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257734',4905347,'2678','397',846866.55,848265.69,1399.14,258840.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257734',4905348,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257734',4905349,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257734',4905350,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257734',4905351,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257735',4905352,'2677','397',1086553.03,1086553.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257735',4905353,'2678','397',848265.69,848265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257735',4905354,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257735',4905355,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257735',4905356,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257735',4905357,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257736',4905358,'2677','397',1086553.03,1086553.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257736',4905359,'2678','397',848265.69,848265.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257736',4905360,'2679','397',920418.59,920418.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257736',4905361,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257736',4905362,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257736',4905363,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257737',4905364,'2677','397',1086553.03,1087533.13,980.10,181318.50,0.00,0.00,0.00,0.00,0.00),('5','174','899','257737',4905365,'2678','397',848265.69,850195.50,1929.81,357014.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257737',4905366,'2679','397',920418.59,920663.43,244.84,45295.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','257737',4905367,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257737',4905368,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257737',4905369,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257738',4905370,'2677','397',1087533.13,1090366.50,2833.37,524173.45,0.00,0.00,0.00,0.00,0.00),('5','174','899','257738',4905371,'2678','397',850195.50,851151.41,955.91,176843.35,0.00,0.00,0.00,0.00,0.00),('5','174','900','257738',4905372,'2679','397',920663.43,922881.31,2217.88,410307.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','257738',4905373,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257738',4905374,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257738',4905375,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257739',4905376,'2677','397',1090366.50,1092535.01,2168.51,401174.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257739',4905377,'2678','397',851151.41,854151.51,3000.10,555018.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257739',4905378,'2679','397',922881.31,922881.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257739',4905379,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257739',4905380,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257739',4905381,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257740',4905382,'2677','397',1092535.01,1095156.14,2621.13,484909.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257740',4905383,'2678','397',854151.51,854151.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257740',4905384,'2679','397',922881.31,925659.62,2778.31,513987.35,0.00,0.00,0.00,0.00,0.00),('5','174','901','257740',4905385,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257740',4905386,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257740',4905387,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257741',4905388,'2677','397',1095156.14,1095156.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257741',4905389,'2678','397',854151.51,854151.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257741',4905390,'2679','397',925659.62,931282.02,5622.40,1040144.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257741',4905391,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257741',4905392,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257741',4905393,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257742',4905394,'2677','397',1095156.14,1099064.30,3908.16,723009.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257742',4905395,'2678','397',854151.51,857163.70,3012.19,557255.15,0.00,0.00,0.00,0.00,0.00),('5','174','900','257742',4905396,'2679','397',931282.02,931282.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257742',4905397,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257742',4905398,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257742',4905399,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257743',4905400,'2677','397',1099064.30,1101422.34,2358.04,436237.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257743',4905401,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257743',4905402,'2679','397',931282.02,935647.14,4365.12,807547.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257743',4905403,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257743',4905404,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257743',4905405,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257744',4905406,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257744',4905407,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257744',4905408,'2679','397',935647.14,942492.17,6845.03,1266330.55,0.00,0.00,0.00,0.00,0.00),('5','174','901','257744',4905409,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257744',4905410,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257744',4905411,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257745',4905412,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257745',4905413,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257745',4905414,'2679','397',942492.17,948919.36,6427.19,1189030.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','257745',4905415,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257745',4905416,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257745',4905417,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257746',4905418,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257746',4905419,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257746',4905420,'2679','397',948919.36,956023.38,7104.02,1314243.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','257746',4905421,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257746',4905422,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257746',4905423,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257747',4905424,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257747',4905425,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257747',4905426,'2679','397',956023.38,961767.02,5743.64,1062573.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','257747',4905427,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257747',4905428,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257747',4905429,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257748',4905430,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257748',4905431,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257748',4905432,'2679','397',961767.02,966579.50,4812.48,890308.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','257748',4905433,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257748',4905434,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257748',4905435,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257749',4905436,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257749',4905437,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257749',4905438,'2679','397',966579.50,971800.84,5221.34,965947.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257749',4905439,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257749',4905440,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257749',4905441,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257750',4905442,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257750',4905443,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257750',4905444,'2679','397',971800.84,976543.22,4742.38,877340.30,0.00,0.00,0.00,0.00,0.00),('5','174','901','257750',4905445,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257750',4905446,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257750',4905447,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257751',4905448,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257751',4905449,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257751',4905450,'2679','397',976543.22,978589.67,2046.45,378593.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','257751',4905451,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257751',4905452,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257751',4905453,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257752',4905454,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257752',4905455,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257752',4905456,'2679','397',978589.67,981804.22,3214.55,594691.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','257752',4905457,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257752',4905458,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257752',4905459,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257753',4905460,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257753',4905461,'2678','397',857163.70,857163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257753',4905462,'2679','397',981804.22,987030.03,5225.81,966774.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','257753',4905463,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257753',4905464,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257753',4905465,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257754',4905466,'2677','397',1101422.34,1101422.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257754',4905467,'2678','397',857163.70,863387.84,6224.14,1151465.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257754',4905468,'2679','397',987030.03,987030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257754',4905469,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257754',4905470,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257754',4905471,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257755',4905472,'2677','397',1101422.34,1107433.36,6011.02,1112038.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','257755',4905473,'2678','397',863387.84,863387.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257755',4905474,'2679','397',987030.03,987030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257755',4905475,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257755',4905476,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257755',4905477,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257756',4905478,'2677','397',1107433.36,1113151.78,5718.42,1057907.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','257756',4905479,'2678','397',863387.84,863387.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257756',4905480,'2679','397',987030.03,987030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257756',4905481,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257756',4905482,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257756',4905483,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257757',4905484,'2677','397',1113151.78,1119296.30,6144.52,1136736.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257757',4905485,'2678','397',863387.84,863387.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257757',4905486,'2679','397',987030.03,987030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257757',4905487,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257757',4905488,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257757',4905489,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257758',4905490,'2677','397',1119296.30,1122679.92,3383.62,625969.70,0.00,0.00,0.00,0.00,0.00),('5','174','899','257758',4905491,'2678','397',863387.84,870128.00,6740.16,1246929.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257758',4905492,'2679','397',987030.03,987030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257758',4905493,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257758',4905494,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257758',4905495,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257759',4905496,'2677','397',1122679.92,1127589.46,4909.54,908264.90,0.00,0.00,0.00,0.00,0.00),('5','174','899','257759',4905497,'2678','397',870128.00,874365.67,4237.67,783968.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257759',4905498,'2679','397',987030.03,988887.11,1857.08,343559.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','257759',4905499,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257759',4905500,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257759',4905501,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257760',4905502,'2677','397',1127589.46,1130738.42,3148.96,582557.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257760',4905503,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257760',4905504,'2679','397',988887.11,997334.01,8446.90,1562676.50,0.00,0.00,0.00,0.00,0.00),('5','174','901','257760',4905505,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257760',4905506,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257760',4905507,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257761',4905508,'2677','397',1130738.42,1135346.73,4608.31,852537.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257761',4905509,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257761',4905510,'2679','397',997334.01,1002962.20,5628.19,1041215.15,0.00,0.00,0.00,0.00,0.00),('5','174','901','257761',4905511,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257761',4905512,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257761',4905513,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257762',4905514,'2677','397',1135346.73,1135346.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257762',4905515,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257762',4905516,'2679','397',1002962.20,1008179.55,5217.35,965209.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','257762',4905517,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257762',4905518,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257762',4905519,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257763',4905520,'2677','397',1135346.73,1135346.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257763',4905521,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257763',4905522,'2679','397',1008179.55,1014215.97,6036.42,1116737.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','257763',4905523,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257763',4905524,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257763',4905525,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257764',4905526,'2677','397',1135346.73,1144162.94,8816.21,1630998.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','257764',4905527,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257764',4905528,'2679','397',1014215.97,1014215.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257764',4905529,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257764',4905530,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257764',4905531,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257765',4905532,'2677','397',1144162.94,1154184.06,10021.12,1853907.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257765',4905533,'2678','397',874365.67,874365.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257765',4905534,'2679','397',1014215.97,1014215.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257765',4905535,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257765',4905536,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257765',4905537,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257766',4905538,'2677','397',1154184.06,1158197.37,4013.31,742462.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257766',4905539,'2678','397',874365.67,876958.24,2592.57,479625.45,0.00,0.00,0.00,0.00,0.00),('5','174','900','257766',4905540,'2679','397',1014215.97,1016621.93,2405.96,445102.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257766',4905541,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257766',4905542,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257766',4905543,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257767',4905544,'2677','397',1158197.37,1163544.23,5346.86,989169.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257767',4905545,'2678','397',876958.24,882890.52,5932.28,1097471.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257767',4905546,'2679','397',1016621.93,1019554.21,2932.28,542471.80,0.00,0.00,0.00,0.00,0.00),('5','174','901','257767',4905547,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257767',4905548,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257767',4905549,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257768',4905550,'2677','397',1163544.23,1163544.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257768',4905551,'2678','397',882890.52,887516.48,4625.96,763283.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','257768',4905552,'2679','397',1019554.21,1019554.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257768',4905553,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257768',4905554,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257768',4905555,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257769',4905556,'2677','397',1163544.23,1165547.29,2003.06,370566.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257769',4905557,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257769',4905558,'2679','397',1019554.21,1023574.22,4020.01,743701.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','257769',4905559,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257769',4905560,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257769',4905561,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257770',4905562,'2677','397',1165547.29,1165547.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257770',4905563,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257770',4905564,'2679','397',1023574.22,1027905.23,4331.01,801236.85,0.00,0.00,0.00,0.00,0.00),('5','174','901','257770',4905565,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257770',4905566,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257770',4905567,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257771',4905568,'2677','397',1165547.29,1165547.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257771',4905569,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257771',4905570,'2679','397',1027905.23,1029229.25,1324.02,244943.70,0.00,0.00,0.00,0.00,0.00),('5','174','901','257771',4905571,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257771',4905572,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257771',4905573,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257772',4905574,'2677','397',1165547.29,1168114.44,2567.15,474922.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','257772',4905575,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257772',4905576,'2679','397',1029229.25,1032313.19,3083.94,570528.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257772',4905577,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257772',4905578,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257772',4905579,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257773',4905580,'2677','397',1168114.44,1172557.76,4443.32,822014.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257773',4905581,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257773',4905582,'2679','397',1032313.19,1036546.11,4232.92,783090.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257773',4905583,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257773',4905584,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257773',4905585,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257774',4905586,'2677','397',1172557.76,1176362.00,3804.24,703784.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257774',4905587,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257774',4905588,'2679','397',1036546.11,1040901.86,4355.75,805813.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','257774',4905589,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257774',4905590,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257774',4905591,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257775',4905592,'2677','397',1176362.00,1182692.21,6330.21,1171088.85,0.00,0.00,0.00,0.00,0.00),('5','174','899','257775',4905593,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257775',4905594,'2679','397',1040901.86,1040901.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257775',4905595,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257775',4905596,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257775',4905597,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257776',4905598,'2677','397',1182692.21,1189011.48,6319.27,1169064.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257776',4905599,'2678','397',887516.48,887516.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257776',4905600,'2679','397',1040901.86,1040901.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257776',4905601,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257776',4905602,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257776',4905603,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257777',4905604,'2677','397',1189011.48,1189011.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257777',4905605,'2678','397',887516.48,897074.52,9558.04,1768237.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','257777',4905606,'2679','397',1040901.86,1042911.21,2009.35,371729.75,0.00,0.00,0.00,0.00,0.00),('5','174','901','257777',4905607,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257777',4905608,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257777',4905609,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257778',4905610,'2677','397',1189011.48,1195784.23,6772.75,1252958.75,0.00,0.00,0.00,0.00,0.00),('5','174','899','257778',4905611,'2678','397',897074.52,897074.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257778',4905612,'2679','397',1042911.21,1042911.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257778',4905613,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257778',4905614,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257778',4905615,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257779',4905616,'2677','397',1195784.23,1195784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257779',4905617,'2678','397',897074.52,897074.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257779',4905618,'2679','397',1042911.21,1053137.35,10226.14,1891835.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257779',4905619,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257779',4905620,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257779',4905621,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257780',4905622,'2677','397',1195784.23,1195784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257780',4905623,'2678','397',897074.52,897074.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257780',4905624,'2679','397',1053137.35,1061540.59,8403.24,1554599.40,0.00,0.00,0.00,0.00,0.00),('5','174','901','257780',4905625,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257780',4905626,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257780',4905627,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257781',4905628,'2677','397',1195784.23,1195784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257781',4905629,'2678','397',897074.52,897074.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257781',4905630,'2679','397',1061540.59,1068085.24,6544.65,1210760.25,0.00,0.00,0.00,0.00,0.00),('5','174','901','257781',4905631,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257781',4905632,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257781',4905633,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257782',4905634,'2677','397',1195784.23,1195784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257782',4905635,'2678','397',897074.52,900824.73,3750.21,693788.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257782',4905636,'2679','397',1068085.24,1070085.53,2000.29,370053.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','257782',4905637,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257782',4905638,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257782',4905639,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257783',4905640,'2677','397',1195784.23,1195784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257783',4905641,'2678','397',900824.73,909191.53,8366.80,1380522.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257783',4905642,'2679','397',1070085.53,1070085.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257783',4905643,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257783',4905644,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257783',4905645,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257784',4905646,'2677','397',1195784.23,1197789.23,2005.00,370925.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257784',4905647,'2678','397',909191.53,909191.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257784',4905648,'2679','397',1070085.53,1079296.59,9211.06,1704046.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','257784',4905649,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257784',4905650,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257784',4905651,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257785',4905652,'2677','397',1197789.23,1197789.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257785',4905653,'2678','397',909191.53,917569.19,8377.66,1549867.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257785',4905654,'2679','397',1079296.59,1079296.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257785',4905655,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257785',4905656,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257785',4905657,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257786',4905658,'2677','397',1197789.23,1197789.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257786',4905659,'2678','397',917569.19,921591.00,4021.81,744034.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257786',4905660,'2679','397',1079296.59,1085799.85,6503.26,1203103.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','257786',4905661,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257786',4905662,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257786',4905663,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257787',4905664,'2677','397',1197789.23,1197789.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257787',4905665,'2678','397',921591.00,935369.56,13778.56,2549033.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257787',4905666,'2679','397',1085799.85,1085799.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257787',4905667,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257787',4905668,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257787',4905669,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257788',4905670,'2677','397',1197789.23,1215147.21,17357.98,3211226.30,0.00,0.00,0.00,0.00,0.00),('5','174','899','257788',4905671,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257788',4905672,'2679','397',1085799.85,1085799.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257788',4905673,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257788',4905674,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257788',4905675,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257789',4905676,'2677','397',1215147.21,1215147.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257789',4905677,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257789',4905678,'2679','397',1085799.85,1096020.97,10221.12,1890907.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257789',4905679,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257789',4905680,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257789',4905681,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257790',4905682,'2677','397',1215147.21,1217982.25,2835.04,524482.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257790',4905683,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257790',4905684,'2679','397',1096020.97,1100302.63,4281.66,792107.10,0.00,0.00,0.00,0.00,0.00),('5','174','901','257790',4905685,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257790',4905686,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257790',4905687,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257791',4905688,'2677','397',1217982.25,1221078.52,3096.27,572809.95,0.00,0.00,0.00,0.00,0.00),('5','174','899','257791',4905689,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257791',4905690,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257791',4905691,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257791',4905692,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257791',4905693,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257792',4905694,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257792',4905695,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257792',4905696,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257792',4905697,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257792',4905698,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257792',4905699,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257793',4905700,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257793',4905701,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257793',4905702,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257793',4905703,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257793',4905704,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257793',4905705,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257794',4905706,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257794',4905707,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257794',4905708,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257794',4905709,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257794',4905710,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257794',4905711,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257795',4905712,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257795',4905713,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257795',4905714,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257795',4905715,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257795',4905716,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257795',4905717,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257796',4905718,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257796',4905719,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257796',4905720,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257796',4905721,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257796',4905722,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257796',4905723,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257797',4905724,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257797',4905725,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257797',4905726,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257797',4905727,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257797',4905728,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257797',4905729,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257798',4905730,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257798',4905731,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257798',4905732,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257798',4905733,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257798',4905734,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257798',4905735,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257799',4905736,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257799',4905737,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257799',4905738,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257799',4905739,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257799',4905740,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257799',4905741,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257800',4905742,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257800',4905743,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257800',4905744,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257800',4905745,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257800',4905746,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257800',4905747,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257801',4905748,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257801',4905749,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257801',4905750,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257801',4905751,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257801',4905752,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257801',4905753,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257802',4905754,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257802',4905755,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257802',4905756,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257802',4905757,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257802',4905758,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257802',4905759,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257803',4905760,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257803',4905761,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257803',4905762,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257803',4905763,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257803',4905764,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257803',4905765,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257804',4905766,'2677','397',1221078.52,1221078.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257804',4905767,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257804',4905768,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257804',4905769,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257804',4905770,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257804',4905771,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257805',4905772,'2677','397',1221078.52,1224903.15,3824.63,707556.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257805',4905773,'2678','397',935369.56,935369.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257805',4905774,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257805',4905775,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257805',4905776,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257805',4905777,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257806',4905778,'2677','397',1224903.15,1228521.91,3618.76,669470.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257806',4905779,'2678','397',935369.56,939816.05,4446.49,822600.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257806',4905780,'2679','397',1100302.63,1100302.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257806',4905781,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257806',4905782,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257806',4905783,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257807',4905784,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257807',4905785,'2678','397',939816.05,945347.52,5531.47,1023321.95,0.00,0.00,0.00,0.00,0.00),('5','174','900','257807',4905786,'2679','397',1100302.63,1103925.80,3623.17,670286.45,0.00,0.00,0.00,0.00,0.00),('5','174','901','257807',4905787,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257807',4905788,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257807',4905789,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257808',4905790,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257808',4905791,'2678','397',945347.52,945347.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257808',4905792,'2679','397',1103925.80,1111996.92,8071.12,1493157.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257808',4905793,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257808',4905794,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257808',4905795,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257809',4905796,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257809',4905797,'2678','397',945347.52,953168.68,7821.16,1446914.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257809',4905798,'2679','397',1111996.92,1111996.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257809',4905799,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257809',4905800,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257809',4905801,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257810',4905802,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257810',4905803,'2678','397',953168.68,953168.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257810',4905804,'2679','397',1111996.92,1119120.44,7123.52,1317851.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257810',4905805,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257810',4905806,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257810',4905807,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257811',4905808,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257811',4905809,'2678','397',953168.68,959586.92,6418.24,1187374.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','257811',4905810,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257811',4905811,'2680','397',681566.05,681566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257811',4905812,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257811',4905813,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257812',4905814,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257812',4905815,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257812',4905816,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257812',4905817,'2680','397',681566.05,687189.57,5623.52,1040351.20,0.00,0.00,0.00,0.00,0.00),('5','174','902','257812',4905818,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257812',4905819,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257813',4905820,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257813',4905821,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257813',4905822,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257813',4905823,'2680','397',687189.57,691800.59,4611.02,853038.70,0.00,0.00,0.00,0.00,0.00),('5','174','902','257813',4905824,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257813',4905825,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257814',4905826,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257814',4905827,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257814',4905828,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257814',4905829,'2680','397',691800.59,698811.92,7011.33,1156869.45,0.00,0.00,0.00,0.00,0.00),('5','174','902','257814',4905830,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257814',4905831,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257815',4905832,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257815',4905833,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257815',4905834,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257815',4905835,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257815',4905836,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257815',4905837,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257816',4905838,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257816',4905839,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257816',4905840,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257816',4905841,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257816',4905842,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257816',4905843,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257817',4905844,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257817',4905845,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257817',4905846,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257817',4905847,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257817',4905848,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257817',4905849,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257818',4905850,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257818',4905851,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257818',4905852,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257818',4905853,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257818',4905854,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257818',4905855,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257819',4905856,'2677','397',1228521.91,1228521.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257819',4905857,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257819',4905858,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257819',4905859,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257819',4905860,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257819',4905861,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257820',4905862,'2677','397',1228521.91,1231646.43,3124.52,578036.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257820',4905863,'2678','397',959586.92,959586.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257820',4905864,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257820',4905865,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257820',4905866,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257820',4905867,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257821',4905868,'2677','397',1231646.43,1236275.76,4629.33,856426.05,0.00,0.00,0.00,0.00,0.00),('5','174','899','257821',4905869,'2678','397',959586.92,963591.98,4005.06,740936.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257821',4905870,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257821',4905871,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257821',4905872,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257821',4905873,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257822',4905874,'2677','397',1236275.76,1236275.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257822',4905875,'2678','397',963591.98,966842.99,3251.01,601436.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257822',4905876,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257822',4905877,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257822',4905878,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257822',4905879,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257823',4905880,'2677','397',1236275.76,1236275.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257823',4905881,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257823',4905882,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257823',4905883,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257823',4905884,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257823',4905885,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257824',4905886,'2677','397',1236275.76,1236275.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257824',4905887,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257824',4905888,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257824',4905889,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257824',4905890,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257824',4905891,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257825',4905892,'2677','397',1236275.76,1242399.80,6124.04,1132947.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257825',4905893,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257825',4905894,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257825',4905895,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257825',4905896,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257825',4905897,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257826',4905898,'2677','397',1242399.80,1247471.96,5072.16,938349.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257826',4905899,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257826',4905900,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257826',4905901,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257826',4905902,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257826',4905903,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257827',4905904,'2677','397',1247471.96,1251085.99,3614.03,668595.55,0.00,0.00,0.00,0.00,0.00),('5','174','899','257827',4905905,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257827',4905906,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257827',4905907,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257827',4905908,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257827',4905909,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257828',4905910,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257828',4905911,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257828',4905912,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257828',4905913,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257828',4905914,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257828',4905915,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257829',4905916,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257829',4905917,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257829',4905918,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257829',4905919,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257829',4905920,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257829',4905921,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257830',4905922,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257830',4905923,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257830',4905924,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257830',4905925,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257830',4905926,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257830',4905927,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257831',4905928,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257831',4905929,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257831',4905930,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257831',4905931,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257831',4905932,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257831',4905933,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257832',4905934,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257832',4905935,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257832',4905936,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257832',4905937,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257832',4905938,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257832',4905939,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257833',4905940,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257833',4905941,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257833',4905942,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257833',4905943,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257833',4905944,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257833',4905945,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257834',4905946,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257834',4905947,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257834',4905948,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257834',4905949,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257834',4905950,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257834',4905951,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257835',4905952,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257835',4905953,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257835',4905954,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257835',4905955,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257835',4905956,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257835',4905957,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257836',4905958,'2677','397',1251085.99,1251085.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257836',4905959,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257836',4905960,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257836',4905961,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257836',4905962,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257836',4905963,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257837',4905964,'2677','397',1251085.99,1255208.99,4123.00,680295.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257837',4905965,'2678','397',966842.99,966842.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257837',4905966,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257837',4905967,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257837',4905968,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257837',4905969,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257838',4905970,'2677','397',1255208.99,1255208.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257838',4905971,'2678','397',966842.99,973187.99,6345.00,1173825.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257838',4905972,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257838',4905973,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257838',4905974,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257838',4905975,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257839',4905976,'2677','397',1255208.99,1258453.99,3245.00,600325.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257839',4905977,'2678','397',973187.99,973187.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257839',4905978,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257839',4905979,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257839',4905980,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257839',4905981,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257840',4905982,'2677','397',1258453.99,1262305.98,3851.99,635578.35,0.00,0.00,0.00,0.00,0.00),('5','174','899','257840',4905983,'2678','397',973187.99,973187.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257840',4905984,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257840',4905985,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257840',4905986,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257840',4905987,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257841',4905988,'2677','397',1262305.98,1262305.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257841',4905989,'2678','397',973187.99,973187.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257841',4905990,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257841',4905991,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257841',4905992,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257841',4905993,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257842',4905994,'2677','397',1262305.98,1262305.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257842',4905995,'2678','397',973187.99,979901.45,6713.46,1241990.10,0.00,0.00,0.00,0.00,0.00),('5','174','900','257842',4905996,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257842',4905997,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257842',4905998,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257842',4905999,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257843',4906000,'2677','397',1262305.98,1262305.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257843',4906001,'2678','397',979901.45,986915.50,7014.05,1297599.25,0.00,0.00,0.00,0.00,0.00),('5','174','900','257843',4906002,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257843',4906003,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257843',4906004,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257843',4906005,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257844',4906006,'2677','397',1262305.98,1262305.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257844',4906007,'2678','397',986915.50,995172.00,8256.50,1527452.50,0.00,0.00,0.00,0.00,0.00),('5','174','900','257844',4906008,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257844',4906009,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257844',4906010,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257844',4906011,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257845',4906012,'2677','397',1262305.98,1262305.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257845',4906013,'2678','397',995172.00,998385.21,3213.21,594443.85,0.00,0.00,0.00,0.00,0.00),('5','174','900','257845',4906014,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257845',4906015,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257845',4906016,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257845',4906017,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257846',4906018,'2677','397',1262305.98,1265519.43,3213.45,530219.25,0.00,0.00,0.00,0.00,0.00),('5','174','899','257846',4906019,'2678','397',998385.21,998385.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257846',4906020,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257846',4906021,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257846',4906022,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257846',4906023,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257847',4906024,'2677','397',1265519.43,1265519.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257847',4906025,'2678','397',998385.21,1004443.30,6058.09,1120746.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257847',4906026,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257847',4906027,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257847',4906028,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257847',4906029,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257848',4906030,'2677','397',1265519.43,1267273.49,1754.06,324501.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257848',4906031,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257848',4906032,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257848',4906033,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257848',4906034,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257848',4906035,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257849',4906036,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257849',4906037,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257849',4906038,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257849',4906039,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257849',4906040,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257849',4906041,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257850',4906042,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257850',4906043,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257850',4906044,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257850',4906045,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257850',4906046,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257850',4906047,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257851',4906048,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257851',4906049,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257851',4906050,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257851',4906051,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257851',4906052,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257851',4906053,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257852',4906054,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257852',4906055,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257852',4906056,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257852',4906057,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257852',4906058,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257852',4906059,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257853',4906060,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257853',4906061,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257853',4906062,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257853',4906063,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257853',4906064,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257853',4906065,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257854',4906066,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257854',4906067,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257854',4906068,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257854',4906069,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257854',4906070,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257854',4906071,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257855',4906072,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257855',4906073,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257855',4906074,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257855',4906075,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257855',4906076,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257855',4906077,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257856',4906078,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257856',4906079,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257856',4906080,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257856',4906081,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257856',4906082,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257856',4906083,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257857',4906084,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257857',4906085,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257857',4906086,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257857',4906087,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257857',4906088,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257857',4906089,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257858',4906090,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257858',4906091,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257858',4906092,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257858',4906093,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257858',4906094,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257858',4906095,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257859',4906096,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257859',4906097,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257859',4906098,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257859',4906099,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257859',4906100,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257859',4906101,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257860',4906102,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257860',4906103,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257860',4906104,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257860',4906105,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257860',4906106,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257860',4906107,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257865',4906108,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257865',4906109,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257865',4906110,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257865',4906111,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257865',4906112,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257865',4906113,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257866',4906114,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257866',4906115,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257866',4906116,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257866',4906117,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257866',4906118,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257866',4906119,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257867',4906120,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257867',4906121,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257867',4906122,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257867',4906123,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257867',4906124,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257867',4906125,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257873',4906126,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257873',4906127,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257873',4906128,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257873',4906129,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257873',4906130,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257873',4906131,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257874',4906132,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257874',4906133,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257874',4906134,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257874',4906135,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257874',4906136,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257874',4906137,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257875',4906138,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257875',4906139,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257875',4906140,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257875',4906141,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257875',4906142,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257875',4906143,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257876',4906144,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257876',4906145,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257876',4906146,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257876',4906147,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257876',4906148,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257876',4906149,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257877',4906150,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257877',4906151,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257877',4906152,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257877',4906153,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257877',4906154,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257877',4906155,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257878',4906156,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257878',4906157,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257878',4906158,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257878',4906159,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257878',4906160,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257878',4906161,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257879',4906162,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257879',4906163,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257879',4906164,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257879',4906165,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257879',4906166,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257879',4906167,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257880',4906168,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257880',4906169,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257880',4906170,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257880',4906171,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257880',4906172,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257880',4906173,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257881',4906174,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257881',4906175,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257881',4906176,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257881',4906177,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257881',4906178,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257881',4906179,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257882',4906180,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257882',4906181,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257882',4906182,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257882',4906183,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257882',4906184,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257882',4906185,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257883',4906186,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257883',4906187,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257883',4906188,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257883',4906189,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257883',4906190,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257883',4906191,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257884',4906192,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257884',4906193,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257884',4906194,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257884',4906195,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257884',4906196,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257884',4906197,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257885',4906198,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257885',4906199,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257885',4906200,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257885',4906201,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257885',4906202,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257885',4906203,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257886',4906204,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257886',4906205,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257886',4906206,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257886',4906207,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257886',4906208,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257886',4906209,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257887',4906210,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257887',4906211,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257887',4906212,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257887',4906213,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257887',4906214,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257887',4906215,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257888',4906216,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257888',4906217,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257888',4906218,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257888',4906219,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257888',4906220,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257888',4906221,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257889',4906222,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257889',4906223,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257889',4906224,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257889',4906225,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257889',4906226,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257889',4906227,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257890',4906228,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257890',4906229,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257890',4906230,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257890',4906231,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257890',4906232,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257890',4906233,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257891',4906234,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257891',4906235,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257891',4906236,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257891',4906237,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257891',4906238,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257891',4906239,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257892',4906240,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257892',4906241,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257892',4906242,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257892',4906243,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257892',4906244,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257892',4906245,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257893',4906246,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257893',4906247,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257893',4906248,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257893',4906249,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257893',4906250,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257893',4906251,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257894',4906252,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257894',4906253,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257894',4906254,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257894',4906255,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257894',4906256,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257894',4906257,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257895',4906258,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257895',4906259,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257895',4906260,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257895',4906261,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257895',4906262,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257895',4906263,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257896',4906264,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257896',4906265,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257896',4906266,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257896',4906267,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257896',4906268,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257896',4906269,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257897',4906270,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257897',4906271,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257897',4906272,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257897',4906273,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257897',4906274,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257897',4906275,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257898',4906276,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257898',4906277,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257898',4906278,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257898',4906279,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257898',4906280,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257898',4906281,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257899',4906282,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257899',4906283,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257899',4906284,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257899',4906285,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257899',4906286,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257899',4906287,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257903',4906288,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257903',4906289,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257903',4906290,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257903',4906291,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257903',4906292,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257903',4906293,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257904',4906294,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257904',4906295,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257904',4906296,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257904',4906297,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257904',4906298,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257904',4906299,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257905',4906300,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257905',4906301,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257905',4906302,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257905',4906303,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257905',4906304,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257905',4906305,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257906',4906306,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257906',4906307,'2678','397',1004443.30,1004443.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257906',4906308,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257906',4906309,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257906',4906310,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257906',4906311,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257915',4906312,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257915',4906313,'2678','397',1004443.30,1007565.88,3122.58,577677.30,0.00,0.00,0.00,0.00,0.00),('5','174','900','257915',4906314,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257915',4906315,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257915',4906316,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257915',4906317,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257925',4906318,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257925',4906319,'2678','397',1007565.88,1014709.36,7143.48,1321543.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257925',4906320,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257925',4906321,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257925',4906322,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257925',4906323,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257926',4906324,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257926',4906325,'2678','397',1014709.36,1020023.85,5314.49,983180.65,0.00,0.00,0.00,0.00,0.00),('5','174','900','257926',4906326,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257926',4906327,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257926',4906328,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257926',4906329,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257927',4906330,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257927',4906331,'2678','397',1020023.85,1021148.37,1124.52,208036.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257927',4906332,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257927',4906333,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257927',4906334,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257927',4906335,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257928',4906336,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257928',4906337,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257928',4906338,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257928',4906339,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257928',4906340,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257928',4906341,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257929',4906342,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257929',4906343,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257929',4906344,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257929',4906345,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257929',4906346,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257929',4906347,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257930',4906348,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257930',4906349,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257930',4906350,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257930',4906351,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257930',4906352,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257930',4906353,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257931',4906354,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257931',4906355,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257931',4906356,'2679','397',1119120.44,1119120.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257931',4906357,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257931',4906358,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257931',4906359,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257932',4906360,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257932',4906361,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257932',4906362,'2679','397',1119120.44,1124433.25,5312.81,876613.65,0.00,0.00,0.00,0.00,0.00),('5','174','901','257932',4906363,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257932',4906364,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257932',4906365,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257933',4906366,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257933',4906367,'2678','397',1021148.37,1021148.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257933',4906368,'2679','397',1124433.25,1132864.65,8431.40,1854908.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257933',4906369,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257933',4906370,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257933',4906371,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257934',4906372,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257934',4906373,'2678','397',1021148.37,1025248.43,4100.06,902013.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257934',4906374,'2679','397',1132864.65,1135886.45,3021.80,664796.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257934',4906375,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257934',4906376,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257934',4906377,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257935',4906378,'2677','397',1267273.49,1267273.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257935',4906379,'2678','397',1025248.43,1032559.89,7311.46,1608521.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257935',4906380,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257935',4906381,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257935',4906382,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257935',4906383,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257936',4906384,'2677','397',1267273.49,1268984.96,1711.47,376523.40,0.00,0.00,0.00,0.00,0.00),('5','174','899','257936',4906385,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257936',4906386,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257936',4906387,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257936',4906388,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257936',4906389,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257937',4906390,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257937',4906391,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257937',4906392,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257937',4906393,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257937',4906394,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257937',4906395,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257938',4906396,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257938',4906397,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257938',4906398,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257938',4906399,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257938',4906400,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257938',4906401,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257939',4906402,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257939',4906403,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257939',4906404,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257939',4906405,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257939',4906406,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257939',4906407,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257940',4906408,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257940',4906409,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257940',4906410,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257940',4906411,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257940',4906412,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257940',4906413,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257941',4906414,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257941',4906415,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257941',4906416,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257941',4906417,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257941',4906418,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257941',4906419,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257942',4906420,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257942',4906421,'2678','397',1032559.89,1032559.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257942',4906422,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257942',4906423,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257942',4906424,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257942',4906425,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257943',4906426,'2677','397',1268984.96,1268984.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257943',4906427,'2678','397',1032559.89,1035813.76,3253.87,715851.40,0.00,0.00,0.00,0.00,0.00),('5','174','900','257943',4906428,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257943',4906429,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257943',4906430,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257943',4906431,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257944',4906432,'2677','397',1268984.96,1278349.32,9364.36,2060159.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257944',4906433,'2678','397',1035813.76,1035813.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257944',4906434,'2679','397',1135886.45,1135886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257944',4906435,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257944',4906436,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257944',4906437,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257945',4906438,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257945',4906439,'2678','397',1035813.76,1035813.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257945',4906440,'2679','397',1135886.45,1144018.50,8132.05,1789051.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257945',4906441,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257945',4906442,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257945',4906443,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257946',4906444,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257946',4906445,'2678','397',1035813.76,1042955.89,7142.13,1571268.60,0.00,0.00,0.00,0.00,0.00),('5','174','900','257946',4906446,'2679','397',1144018.50,1144018.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257946',4906447,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257946',4906448,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257946',4906449,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257947',4906450,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257947',4906451,'2678','397',1042955.89,1042955.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257947',4906452,'2679','397',1144018.50,1146145.28,2126.78,467891.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257947',4906453,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257947',4906454,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257947',4906455,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257948',4906456,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257948',4906457,'2678','397',1042955.89,1042955.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257948',4906458,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257948',4906459,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257948',4906460,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257948',4906461,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257949',4906462,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257949',4906463,'2678','397',1042955.89,1042955.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257949',4906464,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257949',4906465,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257949',4906466,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257949',4906467,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257950',4906468,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257950',4906469,'2678','397',1042955.89,1042955.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257950',4906470,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257950',4906471,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257950',4906472,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257950',4906473,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257951',4906474,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257951',4906475,'2678','397',1042955.89,1046120.98,3165.09,696319.80,0.00,0.00,0.00,0.00,0.00),('5','174','900','257951',4906476,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257951',4906477,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257951',4906478,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257951',4906479,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257952',4906480,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257952',4906481,'2678','397',1046120.98,1054334.99,8214.01,1807082.20,0.00,0.00,0.00,0.00,0.00),('5','174','900','257952',4906482,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257952',4906483,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257952',4906484,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257952',4906485,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257953',4906486,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257953',4906487,'2678','397',1054334.99,1057985.99,3651.00,803220.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257953',4906488,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257953',4906489,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257953',4906490,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257953',4906491,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257954',4906492,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257954',4906493,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257954',4906494,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257954',4906495,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257954',4906496,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257954',4906497,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257955',4906498,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257955',4906499,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257955',4906500,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257955',4906501,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257955',4906502,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257955',4906503,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257956',4906504,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257956',4906505,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257956',4906506,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257956',4906507,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257956',4906508,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257956',4906509,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257957',4906510,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257957',4906511,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257957',4906512,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257957',4906513,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257957',4906514,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257957',4906515,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257958',4906516,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257958',4906517,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257958',4906518,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257958',4906519,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257958',4906520,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257958',4906521,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257959',4906522,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257959',4906523,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257959',4906524,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257959',4906525,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257959',4906526,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257959',4906527,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257960',4906528,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257960',4906529,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257960',4906530,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257960',4906531,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257960',4906532,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257960',4906533,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257961',4906534,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257961',4906535,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257961',4906536,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257961',4906537,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257961',4906538,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257961',4906539,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257962',4906540,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257962',4906541,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257962',4906542,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257962',4906543,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257962',4906544,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257962',4906545,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257963',4906546,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257963',4906547,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257963',4906548,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257963',4906549,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257963',4906550,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257963',4906551,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257964',4906552,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257964',4906553,'2678','397',1057985.99,1057985.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257964',4906554,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257964',4906555,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257964',4906556,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257964',4906557,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257965',4906558,'2677','397',1278349.32,1278349.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257965',4906559,'2678','397',1057985.99,1061330.99,3345.00,702450.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257965',4906560,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257965',4906561,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257965',4906562,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257965',4906563,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257966',4906564,'2677','397',1278349.32,1281492.53,3143.21,660074.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257966',4906565,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257966',4906566,'2679','397',1146145.28,1146145.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257966',4906567,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257966',4906568,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257966',4906569,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257967',4906570,'2677','397',1281492.53,1281492.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257967',4906571,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257967',4906572,'2679','397',1146145.28,1147382.54,1237.26,204147.90,0.00,0.00,0.00,0.00,0.00),('5','174','901','257967',4906573,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257967',4906574,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257967',4906575,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257969',4906576,'2677','397',1281492.53,1292592.59,11100.06,2331012.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257969',4906577,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257969',4906578,'2679','397',1147382.54,1158935.00,11552.46,2426016.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257969',4906579,'2680','397',698811.92,698811.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257969',4906580,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257969',4906581,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257970',4906582,'2677','397',1292592.59,1297220.00,4627.41,971756.10,0.00,0.00,0.00,0.00,0.00),('5','174','899','257970',4906583,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257970',4906584,'2679','397',1158935.00,1158935.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257970',4906585,'2680','397',698811.92,713884.00,15072.08,3165136.80,0.00,0.00,0.00,0.00,0.00),('5','174','902','257970',4906586,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257970',4906587,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257971',4906588,'2677','397',1297220.00,1311647.52,14427.52,3029779.20,0.00,0.00,0.00,0.00,0.00),('5','174','899','257971',4906589,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257971',4906590,'2679','397',1158935.00,1158935.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257971',4906591,'2680','397',713884.00,721708.05,7824.05,1643050.50,0.00,0.00,0.00,0.00,0.00),('5','174','902','257971',4906592,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257971',4906593,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257972',4906594,'2677','397',1311647.52,1311647.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257972',4906595,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257972',4906596,'2679','397',1158935.00,1172035.06,13100.06,2751012.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257972',4906597,'2680','397',721708.05,721708.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257972',4906598,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257972',4906599,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257973',4906600,'2677','397',1311647.52,1311647.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257973',4906601,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257973',4906602,'2679','397',1172035.06,1183409.32,11374.26,2388594.60,0.00,0.00,0.00,0.00,0.00),('5','174','901','257973',4906603,'2680','397',721708.05,721708.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257973',4906604,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257973',4906605,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257974',4906606,'2677','397',1311647.52,1311647.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257974',4906607,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257974',4906608,'2679','397',1183409.32,1193872.02,10462.70,2197167.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257974',4906609,'2680','397',721708.05,721708.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257974',4906610,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257974',4906611,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257975',4906612,'2677','397',1311647.52,1315565.82,3918.30,822843.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257975',4906613,'2678','397',1061330.99,1061330.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257975',4906614,'2679','397',1193872.02,1197692.24,3820.22,802246.20,0.00,0.00,0.00,0.00,0.00),('5','174','901','257975',4906615,'2680','397',721708.05,723594.25,1886.20,396102.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257975',4906616,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257975',4906617,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257976',4906618,'2677','397',1315565.82,1316565.98,1000.16,210033.60,0.00,0.00,0.00,0.00,0.00),('5','174','899','257976',4906619,'2678','397',1061330.99,1061391.98,60.99,12807.90,0.00,0.00,0.00,0.00,0.00),('5','174','900','257976',4906620,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257976',4906621,'2680','397',723594.25,726199.99,2605.74,547205.40,0.00,0.00,0.00,0.00,0.00),('5','174','902','257976',4906622,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257976',4906623,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257977',4906624,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257977',4906625,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257977',4906626,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257977',4906627,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257977',4906628,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257977',4906629,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257978',4906630,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257978',4906631,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257978',4906632,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257978',4906633,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257978',4906634,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257978',4906635,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257979',4906636,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257979',4906637,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257979',4906638,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257979',4906639,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257979',4906640,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257979',4906641,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257980',4906642,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257980',4906643,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257980',4906644,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257980',4906645,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257980',4906646,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257980',4906647,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257981',4906648,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257981',4906649,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257981',4906650,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257981',4906651,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257981',4906652,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257981',4906653,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257982',4906654,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257982',4906655,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257982',4906656,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257982',4906657,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257982',4906658,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257982',4906659,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257983',4906660,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257983',4906661,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257983',4906662,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257983',4906663,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257983',4906664,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257983',4906665,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257984',4906666,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257984',4906667,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257984',4906668,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257984',4906669,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257984',4906670,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257984',4906671,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257985',4906672,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257985',4906673,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257985',4906674,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257985',4906675,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257985',4906676,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257985',4906677,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257986',4906678,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257986',4906679,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257986',4906680,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257986',4906681,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257986',4906682,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257986',4906683,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257987',4906684,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257987',4906685,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257987',4906686,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257987',4906687,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257987',4906688,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257987',4906689,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257988',4906690,'2677','397',1316565.98,1316565.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','899','257988',4906691,'2678','397',1061391.98,1061391.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','900','257988',4906692,'2679','397',1197692.24,1197692.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','901','257988',4906693,'2680','397',726199.99,726199.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','902','257988',4906694,'2681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','174','903','257988',4906695,'2682','399',306298.01,306298.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=731001 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','174','181489','397',0.00,163.00,1433652.91,0.00,0.00,0.00,0.00,532401),('5','174','181489','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532402),('5','174','181489','399',0.00,250.00,177376.06,0.00,0.00,0.00,0.00,532403),('5','174','181495','397',0.00,163.00,21080.49,0.00,0.00,0.00,0.00,532417),('5','174','181495','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532418),('5','174','181495','399',0.00,250.00,1238.98,0.00,0.00,0.00,0.00,532419),('5','174','181576','397',0.00,163.00,15636.11,0.00,0.00,0.00,0.00,532616),('5','174','181576','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532617),('5','174','181576','399',0.00,250.00,570.03,0.00,0.00,0.00,0.00,532618),('5','174','181794','397',0.00,163.00,6200.87,0.00,0.00,0.00,0.00,533196),('5','174','181794','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533197),('5','174','181794','399',0.00,250.00,898.00,0.00,0.00,0.00,0.00,533198),('5','174','181991','397',0.00,163.00,387.83,0.00,0.00,0.00,0.00,533735),('5','174','181991','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533736),('5','174','181991','399',0.00,250.00,1004.43,0.00,0.00,0.00,0.00,533737),('5','174','182148','397',0.00,163.00,0.00,0.00,0.00,0.00,0.00,534147),('5','174','182148','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534148),('5','174','182148','399',0.00,250.00,1209.41,0.00,0.00,0.00,0.00,534149),('5','174','182388','397',0.00,163.00,2336.10,0.00,0.00,0.00,0.00,534770),('5','174','182388','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534771),('5','174','182388','399',0.00,250.00,997.14,0.00,0.00,0.00,0.00,534772),('5','174','182531','397',163.00,163.00,8947.53,0.00,0.00,0.00,0.00,535150),('5','174','182531','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535151),('5','174','182531','399',250.00,250.00,2784.23,0.00,0.00,0.00,0.00,535152),('5','174','182711','397',163.00,163.00,11407.28,0.00,0.00,0.00,0.00,535626),('5','174','182711','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535627),('5','174','182711','399',250.00,250.00,858.51,0.00,0.00,0.00,0.00,535628),('5','174','182915','397',163.00,163.00,13165.38,0.00,0.00,0.00,0.00,536195),('5','174','182915','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536196),('5','174','182915','399',250.00,250.00,699.40,0.00,0.00,0.00,0.00,536197),('5','174','183007','397',163.00,163.00,4045.87,0.00,0.00,0.00,0.00,536441),('5','174','183007','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536442),('5','174','183007','399',250.00,250.00,1024.79,0.00,0.00,0.00,0.00,536443),('5','174','183227','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,536995),('5','174','183227','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536996),('5','174','183227','399',250.00,250.00,507.79,0.00,0.00,0.00,0.00,536997),('5','174','183442','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,537546),('5','174','183442','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,537547),('5','174','183442','399',250.00,265.00,308.34,0.00,0.00,0.00,0.00,537548),('5','174','183675','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,538171),('5','174','183675','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,538172),('5','174','183675','399',250.00,265.00,550.09,0.00,0.00,0.00,0.00,538173),('5','174','183942','397',163.00,163.00,8579.43,0.00,0.00,0.00,0.00,538880),('5','174','183942','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,538881),('5','174','183942','399',250.00,255.00,1723.98,0.00,0.00,0.00,0.00,538882),('5','174','184106','397',163.00,163.00,15297.03,0.00,0.00,0.00,0.00,539316),('5','174','184106','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539317),('5','174','184106','399',250.00,255.00,2973.25,0.00,0.00,0.00,0.00,539318),('5','174','184308','397',163.00,163.00,9928.32,0.00,0.00,0.00,0.00,539850),('5','174','184308','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539851),('5','174','184308','399',250.00,255.00,1800.36,0.00,0.00,0.00,0.00,539852),('5','174','184564','397',163.00,163.00,6701.20,0.00,0.00,0.00,0.00,540529),('5','174','184564','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540530),('5','174','184564','399',250.00,255.00,2990.81,0.00,0.00,0.00,0.00,540531),('5','174','184940','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,541536),('5','174','184940','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541537),('5','174','184940','399',250.00,255.00,2828.04,0.00,0.00,0.00,0.00,541538),('5','174','184942','397',163.00,163.00,6769.36,0.00,0.00,0.00,0.00,541542),('5','174','184942','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541543),('5','174','184942','399',250.00,265.00,2552.85,0.00,0.00,0.00,0.00,541544),('5','174','185141','397',163.00,163.00,6326.50,0.00,0.00,0.00,0.00,542048),('5','174','185141','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542049),('5','174','185141','399',250.00,265.00,2423.62,0.00,0.00,0.00,0.00,542050),('5','174','185291','397',163.00,163.00,7385.19,0.00,0.00,0.00,0.00,542413),('5','174','185291','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542414),('5','174','185291','399',250.00,265.00,3359.97,0.00,0.00,0.00,0.00,542415),('5','174','185510','397',163.00,163.00,8865.77,0.00,0.00,0.00,0.00,542990),('5','174','185510','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542991),('5','174','185510','399',250.00,265.00,2666.01,0.00,0.00,0.00,0.00,542992),('5','174','185794','397',163.00,163.00,9420.76,0.00,0.00,0.00,0.00,543763),('5','174','185794','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543764),('5','174','185794','399',250.00,265.00,1605.41,0.00,0.00,0.00,0.00,543765),('5','174','185887','397',163.00,163.00,10543.27,0.00,0.00,0.00,0.00,544001),('5','174','185887','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544002),('5','174','185887','399',250.00,265.00,831.90,0.00,0.00,0.00,0.00,544003),('5','174','186108','397',163.00,163.00,7325.70,0.00,0.00,0.00,0.00,544583),('5','174','186108','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544584),('5','174','186108','399',250.00,265.00,278.40,0.00,0.00,0.00,0.00,544585),('5','174','186334','397',163.00,163.00,6328.87,0.00,0.00,0.00,0.00,545173),('5','174','186334','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545174),('5','174','186334','399',250.00,265.00,388.81,0.00,0.00,0.00,0.00,545175),('5','174','186554','397',163.00,163.00,8474.30,0.00,0.00,0.00,0.00,545756),('5','174','186554','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545757),('5','174','186554','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545758),('5','174','186765','397',163.00,163.00,7899.00,0.00,0.00,0.00,0.00,546301),('5','174','186765','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546302),('5','174','186765','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,546303),('5','174','187040','397',163.00,163.00,8103.87,0.00,0.00,0.00,0.00,547001),('5','174','187040','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547002),('5','174','187040','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547003),('5','174','187196','397',163.00,163.00,7475.84,0.00,0.00,0.00,0.00,547418),('5','174','187196','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547419),('5','174','187196','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547420),('5','174','187371','397',163.00,163.00,11770.44,0.00,0.00,0.00,0.00,547877),('5','174','187371','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547878),('5','174','187371','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547879),('5','174','187642','397',163.00,163.00,9013.68,0.00,0.00,0.00,0.00,548596),('5','174','187642','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548597),('5','174','187642','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548598),('5','174','187827','397',163.00,163.00,8021.19,0.00,0.00,0.00,0.00,549082),('5','174','187827','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549083),('5','174','187827','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549084),('5','174','188024','397',163.00,163.00,8494.77,0.00,0.00,0.00,0.00,549595),('5','174','188024','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549596),('5','174','188024','399',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549597),('5','174','188203','397',163.00,163.00,7138.86,0.00,0.00,0.00,0.00,550073),('5','174','188203','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550074),('5','174','188203','399',250.00,270.00,0.00,0.00,0.00,0.00,0.00,550075),('5','174','188414','397',163.00,163.00,7954.43,0.00,0.00,0.00,0.00,550620),('5','174','188414','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550621),('5','174','188414','399',250.00,270.00,0.00,0.00,0.00,0.00,0.00,550622),('5','174','188601','397',163.00,163.00,7074.26,0.00,0.00,0.00,0.00,551089),('5','174','188601','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551090),('5','174','188601','399',250.00,270.00,0.00,0.00,0.00,0.00,0.00,551091),('5','174','188859','397',163.00,163.00,8844.80,0.00,0.00,0.00,0.00,551764),('5','174','188859','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551765),('5','174','188859','399',250.00,270.00,714.85,0.00,0.00,0.00,0.00,551766),('5','174','189041','397',163.00,163.00,7517.46,0.00,0.00,0.00,0.00,552241),('5','174','189041','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552242),('5','174','189041','399',265.00,265.00,1502.72,0.00,0.00,0.00,0.00,552243),('5','174','189205','397',163.00,163.00,8058.47,0.00,0.00,0.00,0.00,552674),('5','174','189205','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552675),('5','174','189205','399',265.00,265.00,1951.04,0.00,0.00,0.00,0.00,552676),('5','174','189420','397',163.00,0.00,0.00,0.00,0.00,0.00,0.00,553246),('5','174','189420','398',0.00,163.00,0.00,0.00,0.00,0.00,0.00,553247),('5','174','189420','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,553248),('5','174','189660','397',163.00,163.00,7652.64,0.00,0.00,0.00,0.00,553855),('5','174','189660','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553856),('5','174','189660','399',265.00,265.00,983.07,0.00,0.00,0.00,0.00,553857),('5','174','189667','397',163.00,163.00,3294.48,0.00,0.00,0.00,0.00,553876),('5','174','189667','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553877),('5','174','189667','399',265.00,265.00,549.32,0.00,0.00,0.00,0.00,553878),('5','174','190011','397',163.00,163.00,11087.87,0.00,0.00,0.00,0.00,554786),('5','174','190011','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554787),('5','174','190011','399',265.00,265.00,2302.18,0.00,0.00,0.00,0.00,554788),('5','174','190026','397',163.00,163.00,8823.58,0.00,0.00,0.00,0.00,554819),('5','174','190026','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554820),('5','174','190026','399',265.00,265.00,360.56,0.00,0.00,0.00,0.00,554821),('5','174','190217','397',163.00,163.00,10143.98,0.00,0.00,0.00,0.00,555309),('5','174','190217','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555310),('5','174','190217','399',265.00,265.00,964.28,0.00,0.00,0.00,0.00,555311),('5','174','190462','397',163.00,165.00,0.00,0.00,0.00,0.00,0.00,555943),('5','174','190462','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555944),('5','174','190462','399',265.00,265.00,766.83,0.00,0.00,0.00,0.00,555945),('5','174','190659','397',165.00,165.00,7933.45,0.00,0.00,0.00,0.00,556492),('5','174','190659','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556493),('5','174','190659','399',265.00,265.00,328.93,0.00,0.00,0.00,0.00,556494),('5','174','190898','397',165.00,165.00,11731.97,0.00,0.00,0.00,0.00,557100),('5','174','190898','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557101),('5','174','190898','399',265.00,265.00,761.34,0.00,0.00,0.00,0.00,557102),('5','174','191124','397',165.00,165.00,10718.38,0.00,0.00,0.00,0.00,557689),('5','174','191124','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557690),('5','174','191124','399',265.00,265.00,580.96,0.00,0.00,0.00,0.00,557691),('5','174','191365','397',165.00,165.00,7161.28,0.00,0.00,0.00,0.00,558330),('5','174','191365','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558331),('5','174','191365','399',265.00,265.00,514.98,0.00,0.00,0.00,0.00,558332),('5','174','191519','397',165.00,165.00,6283.99,0.00,0.00,0.00,0.00,558726),('5','174','191519','398',0.00,210.00,0.00,0.00,0.00,0.00,0.00,558727),('5','174','191519','399',265.00,265.00,955.80,0.00,0.00,0.00,0.00,558728),('5','174','191728','397',165.00,165.00,7815.62,0.00,0.00,0.00,0.00,559283),('5','174','191728','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559284),('5','174','191728','399',265.00,265.00,638.61,0.00,0.00,0.00,0.00,559285),('5','174','191962','397',165.00,165.00,4325.16,0.00,0.00,0.00,0.00,559912),('5','174','191962','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559913),('5','174','191962','399',265.00,265.00,1378.03,0.00,0.00,0.00,0.00,559914),('5','174','192138','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560383),('5','174','192138','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560384),('5','174','192138','399',265.00,265.00,1101.48,0.00,0.00,0.00,0.00,560385),('5','174','192427','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,561138),('5','174','192427','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561139),('5','174','192427','399',265.00,265.00,1311.72,0.00,0.00,0.00,0.00,561140),('5','174','192570','397',165.00,165.00,5815.88,0.00,0.00,0.00,0.00,561509),('5','174','192570','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561510),('5','174','192570','399',265.00,265.00,1038.33,0.00,0.00,0.00,0.00,561511),('5','174','192774','397',165.00,165.00,5678.02,0.00,0.00,0.00,0.00,562038),('5','174','192774','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562039),('5','174','192774','399',265.00,265.00,923.63,0.00,0.00,0.00,0.00,562040),('5','174','192967','397',165.00,165.00,5469.19,0.00,0.00,0.00,0.00,562546),('5','174','192967','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562547),('5','174','192967','399',265.00,265.00,585.20,0.00,0.00,0.00,0.00,562548),('5','174','193193','397',165.00,165.00,6419.65,0.00,0.00,0.00,0.00,563143),('5','174','193193','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563144),('5','174','193193','399',265.00,265.00,2179.91,0.00,0.00,0.00,0.00,563145),('5','174','193419','397',165.00,165.00,4194.27,0.00,0.00,0.00,0.00,563736),('5','174','193419','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563737),('5','174','193419','399',265.00,265.00,1152.49,0.00,0.00,0.00,0.00,563738),('5','174','193651','397',165.00,165.00,4669.24,0.00,0.00,0.00,0.00,564321),('5','174','193651','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564322),('5','174','193651','399',265.00,265.00,1200.07,0.00,0.00,0.00,0.00,564323),('5','174','193890','397',165.00,165.00,4618.44,0.00,0.00,0.00,0.00,564928),('5','174','193890','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564929),('5','174','193890','399',265.00,265.00,317.85,0.00,0.00,0.00,0.00,564930),('5','174','194097','397',165.00,165.00,5381.53,0.00,0.00,0.00,0.00,565447),('5','174','194097','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565448),('5','174','194097','399',265.00,265.00,1464.16,0.00,0.00,0.00,0.00,565449),('5','174','194347','397',165.00,165.00,2761.06,0.00,0.00,0.00,0.00,566102),('5','174','194347','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566103),('5','174','194347','399',265.00,265.00,1040.94,0.00,0.00,0.00,0.00,566104),('5','174','194526','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,566550),('5','174','194526','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566551),('5','174','194526','399',265.00,265.00,558.68,0.00,0.00,0.00,0.00,566552),('5','174','194692','397',165.00,165.00,7797.02,0.00,0.00,0.00,0.00,566973),('5','174','194692','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566974),('5','174','194692','399',265.00,265.00,1004.06,0.00,0.00,0.00,0.00,566975),('5','174','194943','397',165.00,165.00,4385.21,0.00,0.00,0.00,0.00,567653),('5','174','194943','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567654),('5','174','194943','399',265.00,265.00,1014.84,0.00,0.00,0.00,0.00,567655),('5','174','195116','397',165.00,165.00,5187.97,0.00,0.00,0.00,0.00,568094),('5','174','195116','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568095),('5','174','195116','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,568096),('5','174','195325','397',165.00,165.00,5006.39,0.00,0.00,0.00,0.00,568618),('5','174','195325','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568619),('5','174','195325','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,568620),('5','174','195561','397',165.00,165.00,6951.59,0.00,0.00,0.00,0.00,569223),('5','174','195561','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569224),('5','174','195561','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,569225),('5','174','195841','397',165.00,165.00,5852.35,0.00,0.00,0.00,0.00,569923),('5','174','195841','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569924),('5','174','195841','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,569925),('5','174','196047','397',165.00,165.00,3705.12,0.00,0.00,0.00,0.00,570462),('5','174','196047','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570463),('5','174','196047','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,570464),('5','174','196229','397',165.00,165.00,4902.15,0.00,0.00,0.00,0.00,570917),('5','174','196229','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570918),('5','174','196229','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,570919),('5','174','196635','397',165.00,165.00,814.01,0.00,0.00,0.00,0.00,571972),('5','174','196635','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571973),('5','174','196635','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,571974),('5','174','196876','397',165.00,165.00,3508.86,0.00,0.00,0.00,0.00,572604),('5','174','196876','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572605),('5','174','196876','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,572606),('5','174','197037','397',165.00,165.00,3795.23,0.00,0.00,0.00,0.00,573006),('5','174','197037','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,573007),('5','174','197037','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,573008),('5','174','197572','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,574306),('5','174','197572','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574307),('5','174','197572','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,574308),('5','174','197764','397',165.00,165.00,4780.80,0.00,0.00,0.00,0.00,574826),('5','174','197764','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574827),('5','174','197764','399',265.00,265.00,731.95,0.00,0.00,0.00,0.00,574828),('5','174','197782','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,574878),('5','174','197782','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574879),('5','174','197782','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,574880),('5','174','197786','397',165.00,165.00,1092.70,0.00,0.00,0.00,0.00,574890),('5','174','197786','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574891),('5','174','197786','399',265.00,265.00,1579.18,0.00,0.00,0.00,0.00,574892),('5','174','197815','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,574976),('5','174','197815','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574977),('5','174','197815','399',265.00,265.00,395.54,0.00,0.00,0.00,0.00,574978),('5','174','197898','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,575180),('5','174','197898','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575181),('5','174','197898','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,575182),('5','174','198142','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,575803),('5','174','198142','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575804),('5','174','198142','399',265.00,270.00,635.48,0.00,0.00,0.00,0.00,575805),('5','174','198175','397',165.00,165.00,5537.47,0.00,0.00,0.00,0.00,575895),('5','174','198175','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575896),('5','174','198175','399',265.00,270.00,543.68,0.00,0.00,0.00,0.00,575897),('5','174','198458','397',165.00,165.00,4311.88,0.00,0.00,0.00,0.00,576633),('5','174','198458','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576634),('5','174','198458','399',265.00,270.00,575.38,0.00,0.00,0.00,0.00,576635),('5','174','198571','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,576934),('5','174','198571','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576935),('5','174','198571','399',265.00,265.00,0.00,0.00,0.00,0.00,0.00,576936),('5','174','198816','397',165.00,165.00,4215.34,0.00,0.00,0.00,0.00,577520),('5','174','198816','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577521),('5','174','198816','399',270.00,270.00,916.71,0.00,0.00,0.00,0.00,577522),('5','174','198820','397',165.00,165.00,4773.89,0.00,0.00,0.00,0.00,577532),('5','174','198820','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577533),('5','174','198820','399',270.00,270.00,580.09,0.00,0.00,0.00,0.00,577534),('5','174','199014','397',165.00,165.00,4320.39,0.00,0.00,0.00,0.00,578046),('5','174','199014','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578047),('5','174','199014','399',270.00,270.00,631.56,0.00,0.00,0.00,0.00,578048),('5','174','199209','397',165.00,165.00,5095.59,0.00,0.00,0.00,0.00,578539),('5','174','199209','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578540),('5','174','199209','399',270.00,270.00,1070.23,0.00,0.00,0.00,0.00,578541),('5','174','199439','397',165.00,165.00,4514.95,0.00,0.00,0.00,0.00,579102),('5','174','199439','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579103),('5','174','199439','399',270.00,270.00,598.35,0.00,0.00,0.00,0.00,579104),('5','174','199663','397',165.00,165.00,4602.14,0.00,0.00,0.00,0.00,579660),('5','174','199663','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579661),('5','174','199663','399',270.00,270.00,644.59,0.00,0.00,0.00,0.00,579662),('5','174','199874','397',165.00,165.00,4469.54,0.00,0.00,0.00,0.00,580171),('5','174','199874','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580172),('5','174','199874','399',270.00,270.00,781.67,0.00,0.00,0.00,0.00,580173),('5','174','200101','397',165.00,165.00,4461.77,0.00,0.00,0.00,0.00,580770),('5','174','200101','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580771),('5','174','200101','399',270.00,270.00,1835.49,0.00,0.00,0.00,0.00,580772),('5','174','200312','397',165.00,165.00,4499.48,0.00,0.00,0.00,0.00,581314),('5','174','200312','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581315),('5','174','200312','399',270.00,270.00,806.12,0.00,0.00,0.00,0.00,581316),('5','174','200525','397',165.00,165.00,4424.79,0.00,0.00,0.00,0.00,581868),('5','174','200525','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581869),('5','174','200525','399',270.00,270.00,610.78,0.00,0.00,0.00,0.00,581870),('5','174','200759','397',165.00,165.00,5476.91,0.00,0.00,0.00,0.00,582480),('5','174','200759','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582481),('5','174','200759','399',270.00,270.00,452.42,0.00,0.00,0.00,0.00,582482),('5','174','200923','397',165.00,165.00,3842.06,0.00,0.00,0.00,0.00,582898),('5','174','200923','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582899),('5','174','200923','399',270.00,270.00,0.00,0.00,0.00,0.00,0.00,582900),('5','174','201118','397',165.00,165.00,4782.02,0.00,0.00,0.00,0.00,583389),('5','174','201118','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583390),('5','174','201118','399',270.00,270.00,0.00,0.00,0.00,0.00,0.00,583391),('5','174','201314','397',165.00,165.00,5502.97,0.00,0.00,0.00,0.00,583901),('5','174','201314','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583902),('5','174','201314','399',270.00,270.00,403.57,0.00,0.00,0.00,0.00,583903),('5','174','201493','397',165.00,165.00,5318.25,0.00,0.00,0.00,0.00,584370),('5','174','201493','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584371),('5','174','201493','399',270.00,270.00,993.96,0.00,0.00,0.00,0.00,584372),('5','174','201802','397',165.00,165.00,3903.54,0.00,0.00,0.00,0.00,585181),('5','174','201802','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585182),('5','174','201802','399',270.00,275.00,813.30,0.00,0.00,0.00,0.00,585183),('5','174','202028','397',165.00,165.00,3935.39,0.00,0.00,0.00,0.00,585786),('5','174','202028','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585787),('5','174','202028','399',270.00,275.00,855.33,0.00,0.00,0.00,0.00,585788),('5','174','202233','397',165.00,165.00,4455.22,0.00,0.00,0.00,0.00,586305),('5','174','202233','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586306),('5','174','202233','399',270.00,275.00,485.70,0.00,0.00,0.00,0.00,586307),('5','174','202434','397',165.00,165.00,4014.19,0.00,0.00,0.00,0.00,586822),('5','174','202434','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586823),('5','174','202434','399',275.00,275.00,1022.00,0.00,0.00,0.00,0.00,586824),('5','174','202646','397',165.00,165.00,3739.50,0.00,0.00,0.00,0.00,587368),('5','174','202646','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587369),('5','174','202646','399',275.00,275.00,581.43,0.00,0.00,0.00,0.00,587370),('5','174','202864','397',165.00,165.00,4139.76,0.00,0.00,0.00,0.00,587923),('5','174','202864','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587924),('5','174','202864','399',275.00,275.00,789.64,0.00,0.00,0.00,0.00,587925),('5','174','203108','397',165.00,165.00,4127.00,0.00,0.00,0.00,0.00,588560),('5','174','203108','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588561),('5','174','203108','399',275.00,275.00,286.02,0.00,0.00,0.00,0.00,588562),('5','174','203303','397',165.00,165.00,4066.21,0.00,0.00,0.00,0.00,589084),('5','174','203303','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589085),('5','174','203303','399',275.00,275.00,1203.95,0.00,0.00,0.00,0.00,589086),('5','174','203529','397',165.00,165.00,3788.73,0.00,0.00,0.00,0.00,589644),('5','174','203529','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589645),('5','174','203529','399',275.00,275.00,715.59,0.00,0.00,0.00,0.00,589646),('5','174','203740','397',165.00,165.00,5197.72,0.00,0.00,0.00,0.00,590189),('5','174','203740','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590190),('5','174','203740','399',275.00,275.00,604.73,0.00,0.00,0.00,0.00,590191),('5','174','203964','397',165.00,165.00,4280.95,0.00,0.00,0.00,0.00,590768),('5','174','203964','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590769),('5','174','203964','399',275.00,275.00,598.42,0.00,0.00,0.00,0.00,590770),('5','174','204184','397',165.00,165.00,4498.86,0.00,0.00,0.00,0.00,591355),('5','174','204184','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591356),('5','174','204184','399',275.00,275.00,2787.40,0.00,0.00,0.00,0.00,591357),('5','174','204399','397',165.00,165.00,4660.75,0.00,0.00,0.00,0.00,591901),('5','174','204399','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591902),('5','174','204399','399',275.00,275.00,1497.96,0.00,0.00,0.00,0.00,591903),('5','174','204627','397',165.00,165.00,4653.84,0.00,0.00,0.00,0.00,592483),('5','174','204627','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592484),('5','174','204627','399',275.00,275.00,1018.26,0.00,0.00,0.00,0.00,592485),('5','174','204844','397',165.00,165.00,4859.59,0.00,0.00,0.00,0.00,593003),('5','174','204844','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593004),('5','174','204844','399',275.00,275.00,646.53,0.00,0.00,0.00,0.00,593005),('5','174','205080','397',165.00,165.00,3973.78,0.00,0.00,0.00,0.00,593602),('5','174','205080','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593603),('5','174','205080','399',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593604),('5','174','205236','397',165.00,165.00,5265.72,0.00,0.00,0.00,0.00,594024),('5','174','205236','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594025),('5','174','205236','399',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594026),('5','174','205503','397',165.00,165.00,3620.45,0.00,0.00,0.00,0.00,594690),('5','174','205503','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594691),('5','174','205503','399',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594692),('5','174','205741','397',165.00,165.00,4523.76,0.00,0.00,0.00,0.00,595320),('5','174','205741','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595321),('5','174','205741','399',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595322),('5','174','205960','397',165.00,165.00,4140.42,0.00,0.00,0.00,0.00,595884),('5','174','205960','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595885),('5','174','205960','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,595886),('5','174','206166','397',165.00,165.00,5164.44,0.00,0.00,0.00,0.00,596411),('5','174','206166','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596412),('5','174','206166','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596413),('5','174','206373','397',165.00,165.00,4587.27,0.00,0.00,0.00,0.00,596937),('5','174','206373','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596938),('5','174','206373','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596939),('5','174','206586','397',165.00,165.00,4340.47,0.00,0.00,0.00,0.00,597479),('5','174','206586','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597480),('5','174','206586','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,597481),('5','174','206818','397',165.00,165.00,5330.43,0.00,0.00,0.00,0.00,598077),('5','174','206818','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598078),('5','174','206818','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598079),('5','174','207038','397',165.00,165.00,4792.48,0.00,0.00,0.00,0.00,598648),('5','174','207038','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598649),('5','174','207038','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598650),('5','174','207267','397',165.00,165.00,4585.38,0.00,0.00,0.00,0.00,599240),('5','174','207267','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599241),('5','174','207267','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599242),('5','174','207491','397',165.00,165.00,4931.47,0.00,0.00,0.00,0.00,599823),('5','174','207491','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599824),('5','174','207491','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599825),('5','174','207698','397',165.00,165.00,7155.81,0.00,0.00,0.00,0.00,600350),('5','174','207698','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600351),('5','174','207698','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600352),('5','174','207910','397',165.00,165.00,4051.63,0.00,0.00,0.00,0.00,600885),('5','174','207910','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600886),('5','174','207910','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600887),('5','174','208107','397',165.00,165.00,4100.26,0.00,0.00,0.00,0.00,601399),('5','174','208107','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601400),('5','174','208107','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601401),('5','174','208330','397',165.00,165.00,4684.18,0.00,0.00,0.00,0.00,601966),('5','174','208330','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601967),('5','174','208330','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601968),('5','174','208652','397',165.00,165.00,4317.11,0.00,0.00,0.00,0.00,602795),('5','174','208652','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602796),('5','174','208652','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602797),('5','174','208777','397',165.00,165.00,4080.04,0.00,0.00,0.00,0.00,603112),('5','174','208777','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603113),('5','174','208777','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603114),('5','174','209022','397',165.00,165.00,4424.43,0.00,0.00,0.00,0.00,603719),('5','174','209022','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603720),('5','174','209022','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603721),('5','174','209215','397',165.00,165.00,4507.94,0.00,0.00,0.00,0.00,604230),('5','174','209215','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604231),('5','174','209215','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604232),('5','174','209448','397',165.00,165.00,4213.79,0.00,0.00,0.00,0.00,604813),('5','174','209448','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604814),('5','174','209448','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604815),('5','174','209661','397',165.00,165.00,4121.47,0.00,0.00,0.00,0.00,605358),('5','174','209661','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605359),('5','174','209661','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605360),('5','174','209883','397',165.00,165.00,4835.74,0.00,0.00,0.00,0.00,605934),('5','174','209883','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605935),('5','174','209883','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605936),('5','174','210097','397',165.00,165.00,3184.83,0.00,0.00,0.00,0.00,606508),('5','174','210097','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606509),('5','174','210097','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,606510),('5','174','210480','397',165.00,165.00,484.32,0.00,0.00,0.00,0.00,607505),('5','174','210480','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607506),('5','174','210480','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607507),('5','174','210529','397',165.00,165.00,4386.75,0.00,0.00,0.00,0.00,607620),('5','174','210529','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607621),('5','174','210529','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,607622),('5','174','210767','397',165.00,165.00,5134.01,0.00,0.00,0.00,0.00,608248),('5','174','210767','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608249),('5','174','210767','399',275.00,290.00,0.00,0.00,0.00,0.00,0.00,608250),('5','174','210980','397',165.00,165.00,4468.97,0.00,0.00,0.00,0.00,608785),('5','174','210980','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608786),('5','174','210980','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,608787),('5','174','211169','397',165.00,165.00,5804.32,0.00,0.00,0.00,0.00,609281),('5','174','211169','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609282),('5','174','211169','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609283),('5','174','211388','397',165.00,165.00,6732.10,0.00,0.00,0.00,0.00,609848),('5','174','211388','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609849),('5','174','211388','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609850),('5','174','211604','397',165.00,165.00,3553.32,0.00,0.00,0.00,0.00,610419),('5','174','211604','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610420),('5','174','211604','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,610421),('5','174','211838','397',165.00,165.00,3989.16,0.00,0.00,0.00,0.00,611003),('5','174','211838','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611004),('5','174','211838','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,611005),('5','174','212144','397',165.00,165.00,2773.94,0.00,0.00,0.00,0.00,611812),('5','174','212144','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611813),('5','174','212144','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,611814),('5','174','212265','397',165.00,165.00,4355.46,0.00,0.00,0.00,0.00,612116),('5','174','212265','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612117),('5','174','212265','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612118),('5','174','212466','397',165.00,165.00,4317.53,0.00,0.00,0.00,0.00,612647),('5','174','212466','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612648),('5','174','212466','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612649),('5','174','212675','397',165.00,165.00,3868.56,0.00,0.00,0.00,0.00,613206),('5','174','212675','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613207),('5','174','212675','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613208),('5','174','212884','397',165.00,165.00,2839.60,0.00,0.00,0.00,0.00,613747),('5','174','212884','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613748),('5','174','212884','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613749),('5','174','213135','397',165.00,165.00,3592.11,0.00,0.00,0.00,0.00,614406),('5','174','213135','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614407),('5','174','213135','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,614408),('5','174','213432','397',165.00,165.00,3781.69,0.00,0.00,0.00,0.00,615162),('5','174','213432','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615163),('5','174','213432','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,615164),('5','174','213776','397',165.00,165.00,4219.60,0.00,0.00,0.00,0.00,616088),('5','174','213776','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616089),('5','174','213776','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,616090),('5','174','213915','397',165.00,165.00,3889.87,0.00,0.00,0.00,0.00,616440),('5','174','213915','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616441),('5','174','213915','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,616442),('5','174','214148','397',165.00,165.00,3653.58,0.00,0.00,0.00,0.00,617052),('5','174','214148','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617053),('5','174','214148','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617054),('5','174','214352','397',165.00,165.00,3615.44,0.00,0.00,0.00,0.00,617579),('5','174','214352','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617580),('5','174','214352','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617581),('5','174','214587','397',165.00,165.00,2126.53,0.00,0.00,0.00,0.00,618183),('5','174','214587','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618184),('5','174','214587','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618185),('5','174','214792','397',165.00,165.00,4047.13,0.00,0.00,0.00,0.00,618719),('5','174','214792','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618720),('5','174','214792','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618721),('5','174','215073','397',165.00,165.00,3909.81,0.00,0.00,0.00,0.00,619463),('5','174','215073','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619464),('5','174','215073','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,619465),('5','174','215285','397',165.00,165.00,3608.14,0.00,0.00,0.00,0.00,620001),('5','174','215285','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620002),('5','174','215285','399',275.00,295.00,0.00,0.00,0.00,0.00,0.00,620003),('5','174','215445','397',165.00,165.00,4414.83,0.00,0.00,0.00,0.00,620406),('5','174','215445','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620407),('5','174','215445','399',295.00,295.00,664.26,0.00,0.00,0.00,0.00,620408),('5','174','215742','397',165.00,165.00,3543.94,0.00,0.00,0.00,0.00,621176),('5','174','215742','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621177),('5','174','215742','399',295.00,295.00,302.93,0.00,0.00,0.00,0.00,621178),('5','174','215932','397',165.00,165.00,2326.96,0.00,0.00,0.00,0.00,621656),('5','174','215932','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621657),('5','174','215932','399',295.00,295.00,96.54,0.00,0.00,0.00,0.00,621658),('5','174','216115','397',165.00,165.00,3539.69,0.00,0.00,0.00,0.00,622137),('5','174','216115','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622138),('5','174','216115','399',295.00,295.00,193.00,0.00,0.00,0.00,0.00,622139),('5','174','216367','397',165.00,165.00,3597.23,0.00,0.00,0.00,0.00,622786),('5','174','216367','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622787),('5','174','216367','399',295.00,295.00,252.80,0.00,0.00,0.00,0.00,622788),('5','174','216578','397',165.00,165.00,3738.40,0.00,0.00,0.00,0.00,623347),('5','174','216578','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623348),('5','174','216578','399',295.00,295.00,217.33,0.00,0.00,0.00,0.00,623349),('5','174','216797','397',165.00,165.00,3814.16,0.00,0.00,0.00,0.00,623927),('5','174','216797','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623928),('5','174','216797','399',295.00,295.00,117.45,0.00,0.00,0.00,0.00,623929),('5','174','217024','397',165.00,165.00,3318.38,0.00,0.00,0.00,0.00,624523),('5','174','217024','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624524),('5','174','217024','399',295.00,295.00,194.30,0.00,0.00,0.00,0.00,624525),('5','174','217298','397',165.00,165.00,3431.65,0.00,0.00,0.00,0.00,625239),('5','174','217298','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625240),('5','174','217298','399',295.00,295.00,358.14,0.00,0.00,0.00,0.00,625241),('5','174','217653','397',165.00,165.00,3608.46,0.00,0.00,0.00,0.00,626181),('5','174','217653','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626182),('5','174','217653','399',295.00,295.00,424.38,0.00,0.00,0.00,0.00,626183),('5','174','217829','397',165.00,165.00,3927.60,0.00,0.00,0.00,0.00,626636),('5','174','217829','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626637),('5','174','217829','399',295.00,295.00,246.93,0.00,0.00,0.00,0.00,626638),('5','174','218040','397',165.00,165.00,4285.52,0.00,0.00,0.00,0.00,627182),('5','174','218040','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627183),('5','174','218040','399',295.00,295.00,298.07,0.00,0.00,0.00,0.00,627184),('5','174','218241','397',165.00,165.00,3443.88,0.00,0.00,0.00,0.00,627712),('5','174','218241','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627713),('5','174','218241','399',295.00,295.00,360.14,0.00,0.00,0.00,0.00,627714),('5','174','218517','397',165.00,165.00,4517.96,0.00,0.00,0.00,0.00,628440),('5','174','218517','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628441),('5','174','218517','399',295.00,295.00,590.66,0.00,0.00,0.00,0.00,628442),('5','174','218761','397',165.00,165.00,3611.10,0.00,0.00,0.00,0.00,629065),('5','174','218761','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629066),('5','174','218761','399',295.00,295.00,260.11,0.00,0.00,0.00,0.00,629067),('5','174','219097','397',165.00,165.00,3406.27,0.00,0.00,0.00,0.00,629958),('5','174','219097','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629959),('5','174','219097','399',295.00,295.00,241.78,0.00,0.00,0.00,0.00,629960),('5','174','219155','397',165.00,165.00,2713.41,0.00,0.00,0.00,0.00,630095),('5','174','219155','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630096),('5','174','219155','399',295.00,295.00,302.59,0.00,0.00,0.00,0.00,630097),('5','174','219359','397',165.00,165.00,4835.83,0.00,0.00,0.00,0.00,630630),('5','174','219359','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630631),('5','174','219359','399',295.00,295.00,1241.74,0.00,0.00,0.00,0.00,630632),('5','174','219631','397',165.00,165.00,2953.80,0.00,0.00,0.00,0.00,631346),('5','174','219631','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631347),('5','174','219631','399',295.00,295.00,208.46,0.00,0.00,0.00,0.00,631348),('5','174','219839','397',165.00,165.00,3259.44,0.00,0.00,0.00,0.00,631888),('5','174','219839','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631889),('5','174','219839','399',295.00,295.00,289.26,0.00,0.00,0.00,0.00,631890),('5','174','220079','397',165.00,165.00,3226.98,0.00,0.00,0.00,0.00,632530),('5','174','220079','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632531),('5','174','220079','399',295.00,295.00,214.60,0.00,0.00,0.00,0.00,632532),('5','174','220254','397',165.00,165.00,3130.15,0.00,0.00,0.00,0.00,632999),('5','174','220254','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633000),('5','174','220254','399',295.00,295.00,436.64,0.00,0.00,0.00,0.00,633001),('5','174','220492','397',165.00,165.00,2915.96,0.00,0.00,0.00,0.00,633619),('5','174','220492','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633620),('5','174','220492','399',295.00,295.00,126.54,0.00,0.00,0.00,0.00,633621),('5','174','220716','397',165.00,165.00,3057.98,0.00,0.00,0.00,0.00,634199),('5','174','220716','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634200),('5','174','220716','399',295.00,295.00,209.50,0.00,0.00,0.00,0.00,634201),('5','174','220929','397',165.00,165.00,3587.93,0.00,0.00,0.00,0.00,634752),('5','174','220929','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634753),('5','174','220929','399',295.00,295.00,221.25,0.00,0.00,0.00,0.00,634754),('5','174','221181','397',165.00,165.00,3082.76,0.00,0.00,0.00,0.00,635401),('5','174','221181','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635402),('5','174','221181','399',295.00,295.00,67.45,0.00,0.00,0.00,0.00,635403),('5','174','221418','397',165.00,165.00,3398.32,0.00,0.00,0.00,0.00,636025),('5','174','221418','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636026),('5','174','221418','399',295.00,295.00,255.27,0.00,0.00,0.00,0.00,636027),('5','174','221637','397',165.00,165.00,3048.15,0.00,0.00,0.00,0.00,636596),('5','174','221637','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636597),('5','174','221637','399',295.00,295.00,199.86,0.00,0.00,0.00,0.00,636598),('5','174','221853','397',165.00,165.00,2948.88,0.00,0.00,0.00,0.00,637157),('5','174','221853','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637158),('5','174','221853','399',295.00,295.00,347.27,0.00,0.00,0.00,0.00,637159),('5','174','223083','397',165.00,165.00,2197.29,0.00,0.00,0.00,0.00,640393),('5','174','223083','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640394),('5','174','223083','399',295.00,295.00,52.66,0.00,0.00,0.00,0.00,640395),('5','174','223092','397',165.00,165.00,2172.46,0.00,0.00,0.00,0.00,640416),('5','174','223092','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640417),('5','174','223092','399',295.00,295.00,110.41,0.00,0.00,0.00,0.00,640418),('5','174','223100','397',165.00,165.00,2672.83,0.00,0.00,0.00,0.00,640440),('5','174','223100','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640441),('5','174','223100','399',295.00,295.00,173.68,0.00,0.00,0.00,0.00,640442),('5','174','224440','397',165.00,165.00,2324.60,0.00,0.00,0.00,0.00,643852),('5','174','224440','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643853),('5','174','224440','399',295.00,295.00,100.00,0.00,0.00,0.00,0.00,643854),('5','174','224444','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,643864),('5','174','224444','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643865),('5','174','224444','399',295.00,295.00,0.00,0.00,0.00,0.00,0.00,643866),('5','174','224447','397',165.00,165.00,2707.90,0.00,0.00,0.00,0.00,643872),('5','174','224447','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643873),('5','174','224447','399',295.00,295.00,579.51,0.00,0.00,0.00,0.00,643874),('5','174','224451','397',165.00,165.00,2495.61,0.00,0.00,0.00,0.00,643884),('5','174','224451','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643885),('5','174','224451','399',295.00,295.00,65.51,0.00,0.00,0.00,0.00,643886),('5','174','224453','397',165.00,165.00,2439.97,0.00,0.00,0.00,0.00,643890),('5','174','224453','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643891),('5','174','224453','399',295.00,295.00,66.96,0.00,0.00,0.00,0.00,643892),('5','174','224456','397',165.00,165.00,2764.54,0.00,0.00,0.00,0.00,643899),('5','174','224456','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643900),('5','174','224456','399',295.00,295.00,89.65,0.00,0.00,0.00,0.00,643901),('5','174','224460','397',165.00,165.00,2047.98,0.00,0.00,0.00,0.00,643911),('5','174','224460','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643912),('5','174','224460','399',295.00,295.00,77.28,0.00,0.00,0.00,0.00,643913),('5','174','224461','397',165.00,165.00,2137.61,0.00,0.00,0.00,0.00,643914),('5','174','224461','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643915),('5','174','224461','399',295.00,295.00,67.98,0.00,0.00,0.00,0.00,643916),('5','174','224463','397',165.00,165.00,2410.00,0.00,0.00,0.00,0.00,643920),('5','174','224463','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643921),('5','174','224463','399',295.00,295.00,222.18,0.00,0.00,0.00,0.00,643922),('5','174','225881','397',165.00,165.00,2465.57,0.00,0.00,0.00,0.00,647594),('5','174','225881','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647595),('5','174','225881','399',295.00,295.00,82.73,0.00,0.00,0.00,0.00,647596),('5','174','225889','397',165.00,165.00,2425.72,0.00,0.00,0.00,0.00,647614),('5','174','225889','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647615),('5','174','225889','399',295.00,295.00,234.18,0.00,0.00,0.00,0.00,647616),('5','174','225894','397',165.00,163.00,2686.15,0.00,0.00,0.00,0.00,647629),('5','174','225894','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647630),('5','174','225894','399',295.00,295.00,79.06,0.00,0.00,0.00,0.00,647631),('5','174','225896','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,647634),('5','174','225896','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647635),('5','174','225896','399',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647636),('5','174','225901','397',163.00,163.00,3447.28,0.00,0.00,0.00,0.00,647646),('5','174','225901','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647647),('5','174','225901','399',295.00,295.00,391.51,0.00,0.00,0.00,0.00,647648),('5','174','225904','397',163.00,163.00,3547.60,0.00,0.00,0.00,0.00,647654),('5','174','225904','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647655),('5','174','225904','399',295.00,295.00,698.31,0.00,0.00,0.00,0.00,647656),('5','174','226825','397',163.00,163.00,2738.42,0.00,0.00,0.00,0.00,650018),('5','174','226825','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650019),('5','174','226825','399',295.00,295.00,471.19,0.00,0.00,0.00,0.00,650020),('5','174','226829','397',163.00,163.00,2797.19,0.00,0.00,0.00,0.00,650030),('5','174','226829','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650031),('5','174','226829','399',295.00,295.00,726.11,0.00,0.00,0.00,0.00,650032),('5','174','226882','397',163.00,163.00,2559.51,0.00,0.00,0.00,0.00,650180),('5','174','226882','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650181),('5','174','226882','399',295.00,295.00,293.02,0.00,0.00,0.00,0.00,650182),('5','174','226884','397',163.00,163.00,2714.71,0.00,0.00,0.00,0.00,650185),('5','174','226884','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650186),('5','174','226884','399',295.00,295.00,783.07,0.00,0.00,0.00,0.00,650187),('5','174','226889','397',163.00,163.00,3045.42,0.00,0.00,0.00,0.00,650199),('5','174','226889','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650200),('5','174','226889','399',295.00,295.00,266.71,0.00,0.00,0.00,0.00,650201),('5','174','227726','397',163.00,163.00,2419.14,0.00,0.00,0.00,0.00,652348),('5','174','227726','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652349),('5','174','227726','399',295.00,295.00,371.73,0.00,0.00,0.00,0.00,652350),('5','174','227739','397',163.00,163.00,2563.97,0.00,0.00,0.00,0.00,652381),('5','174','227739','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652382),('5','174','227739','399',295.00,295.00,405.99,0.00,0.00,0.00,0.00,652383),('5','174','227764','397',163.00,163.00,4784.67,0.00,0.00,0.00,0.00,652451),('5','174','227764','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652452),('5','174','227764','399',295.00,295.00,195.72,0.00,0.00,0.00,0.00,652453),('5','174','229271','397',163.00,163.00,2599.14,0.00,0.00,0.00,0.00,656345),('5','174','229271','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656346),('5','174','229271','399',295.00,300.00,218.28,0.00,0.00,0.00,0.00,656347),('5','174','229280','397',163.00,163.00,2583.39,0.00,0.00,0.00,0.00,656369),('5','174','229280','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656370),('5','174','229280','399',295.00,300.00,107.75,0.00,0.00,0.00,0.00,656371),('5','174','229394','397',163.00,163.00,1645.27,0.00,0.00,0.00,0.00,656681),('5','174','229394','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656682),('5','174','229394','399',295.00,300.00,97.51,0.00,0.00,0.00,0.00,656683),('5','174','230852','397',163.00,163.00,1256.88,0.00,0.00,0.00,0.00,660416),('5','174','230852','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660417),('5','174','230852','399',300.00,300.00,518.63,0.00,0.00,0.00,0.00,660418),('5','174','230856','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660427),('5','174','230856','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660428),('5','174','230856','399',300.00,300.00,118.33,0.00,0.00,0.00,0.00,660429),('5','174','230863','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660447),('5','174','230863','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660448),('5','174','230863','399',300.00,300.00,296.01,0.00,0.00,0.00,0.00,660449),('5','174','230874','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660473),('5','174','230874','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660474),('5','174','230874','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660475),('5','174','230883','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660498),('5','174','230883','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660499),('5','174','230883','399',300.00,300.00,0.00,0.00,0.00,0.00,0.00,660500),('5','174','230884','397',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660501),('5','174','230884','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660502),('5','174','230884','399',300.00,300.00,0.00,0.00,0.00,0.00,0.00,660503),('5','174','230885','397',163.00,163.00,2537.15,0.00,0.00,0.00,0.00,660504),('5','174','230885','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660505),('5','174','230885','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660506),('5','174','230891','397',163.00,163.00,2935.68,0.00,0.00,0.00,0.00,660522),('5','174','230891','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660523),('5','174','230891','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660524),('5','174','230894','397',163.00,163.00,2958.57,0.00,0.00,0.00,0.00,660529),('5','174','230894','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660530),('5','174','230894','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660531),('5','174','230896','397',163.00,163.00,4825.46,0.00,0.00,0.00,0.00,660535),('5','174','230896','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660536),('5','174','230896','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660537),('5','174','230899','397',163.00,163.00,5534.67,0.00,0.00,0.00,0.00,660544),('5','174','230899','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660545),('5','174','230899','399',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660546),('5','174','230902','397',163.00,163.00,6811.09,0.00,0.00,0.00,0.00,660553),('5','174','230902','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660554),('5','174','230902','399',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660555),('5','174','230905','397',163.00,163.00,3130.54,0.00,0.00,0.00,0.00,660561),('5','174','230905','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660562),('5','174','230905','399',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660563),('5','174','231129','397',163.00,163.00,3056.79,0.00,0.00,0.00,0.00,661161),('5','174','231129','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661162),('5','174','231129','399',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661163),('5','174','231416','397',163.00,163.00,3200.66,0.00,0.00,0.00,0.00,661926),('5','174','231416','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661927),('5','174','231416','399',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661928),('5','174','231655','397',163.00,163.00,4035.18,0.00,0.00,0.00,0.00,662554),('5','174','231655','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662555),('5','174','231655','399',300.00,320.00,0.00,0.00,0.00,0.00,0.00,662556),('5','174','231953','397',163.00,163.00,4019.58,0.00,0.00,0.00,0.00,663363),('5','174','231953','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663364),('5','174','231953','399',300.00,327.00,0.00,0.00,0.00,0.00,0.00,663365),('5','174','232112','397',163.00,163.00,3427.22,0.00,0.00,0.00,0.00,663785),('5','174','232112','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663786),('5','174','232112','399',300.00,327.00,0.00,0.00,0.00,0.00,0.00,663787),('5','174','232356','397',163.00,163.00,3611.92,0.00,0.00,0.00,0.00,664408),('5','174','232356','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664409),('5','174','232356','399',300.00,300.00,0.00,0.00,0.00,0.00,0.00,664410),('5','174','232635','397',163.00,163.00,5399.55,0.00,0.00,0.00,0.00,665150),('5','174','232635','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665151),('5','174','232635','399',300.00,327.00,0.00,0.00,0.00,0.00,0.00,665152),('5','174','232897','397',163.00,163.00,3380.95,0.00,0.00,0.00,0.00,665842),('5','174','232897','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665843),('5','174','232897','399',300.00,330441.00,0.00,0.00,0.00,0.00,0.00,665844),('5','174','233122','397',163.00,163.00,3513.60,0.00,0.00,0.00,0.00,666427),('5','174','233122','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666428),('5','174','233122','399',300.00,345.00,105.36,0.00,0.00,0.00,0.00,666429),('5','174','233419','397',163.00,163.00,3922.28,0.00,0.00,0.00,0.00,667206),('5','174','233419','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667207),('5','174','233419','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667208),('5','174','233651','397',163.00,163.00,3350.31,0.00,0.00,0.00,0.00,667812),('5','174','233651','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667813),('5','174','233651','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667814),('5','174','233853','397',163.00,163.00,3581.66,0.00,0.00,0.00,0.00,668346),('5','174','233853','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668347),('5','174','233853','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668348),('5','174','234131','397',163.00,163.00,7280.88,0.00,0.00,0.00,0.00,669089),('5','174','234131','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669090),('5','174','234131','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669091),('5','174','234389','397',163.00,165.00,4639.05,0.00,0.00,0.00,0.00,669769),('5','174','234389','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669770),('5','174','234389','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669771),('5','174','234681','397',163.00,165.00,7160.03,0.00,0.00,0.00,0.00,670549),('5','174','234681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670550),('5','174','234681','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670551),('5','174','234924','397',163.00,165.00,4626.01,0.00,0.00,0.00,0.00,671193),('5','174','234924','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671194),('5','174','234924','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671195),('5','174','235150','397',163.00,165.00,9832.03,0.00,0.00,0.00,0.00,671796),('5','174','235150','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671797),('5','174','235150','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671798),('5','174','235478','397',163.00,165.00,10302.03,0.00,0.00,0.00,0.00,672654),('5','174','235478','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672655),('5','174','235478','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672656),('5','174','235596','397',163.00,165.00,5776.13,0.00,0.00,0.00,0.00,672938),('5','174','235596','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672939),('5','174','235596','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672940),('5','174','235870','397',163.00,165.00,11224.98,0.00,0.00,0.00,0.00,673655),('5','174','235870','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673656),('5','174','235870','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673657),('5','174','236188','397',163.00,165.00,8626.99,0.00,0.00,0.00,0.00,674506),('5','174','236188','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674507),('5','174','236188','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674508),('5','174','236311','397',165.00,165.00,6556.07,0.00,0.00,0.00,0.00,674820),('5','174','236311','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674821),('5','174','236311','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674822),('5','174','236597','397',165.00,165.00,8138.33,0.00,0.00,0.00,0.00,675571),('5','174','236597','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675572),('5','174','236597','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675573),('5','174','236783','397',165.00,165.00,10697.56,0.00,0.00,0.00,0.00,676046),('5','174','236783','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676047),('5','174','236783','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676048),('5','174','237054','397',165.00,165.00,6351.28,0.00,0.00,0.00,0.00,676751),('5','174','237054','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676752),('5','174','237054','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676753),('5','174','237317','397',165.00,165.00,10978.03,0.00,0.00,0.00,0.00,677437),('5','174','237317','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677438),('5','174','237317','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677439),('5','174','237428','397',165.00,165.00,4315.26,0.00,0.00,0.00,0.00,677710),('5','174','237428','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677711),('5','174','237428','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677712),('5','174','237722','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678482),('5','174','237722','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678483),('5','174','237722','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678484),('5','174','237925','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679002),('5','174','237925','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679003),('5','174','237925','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679004),('5','174','238154','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679600),('5','174','238154','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679601),('5','174','238154','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679602),('5','174','238429','397',165.00,165.00,8153.02,0.00,0.00,0.00,0.00,680306),('5','174','238429','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680307),('5','174','238429','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680308),('5','174','238644','397',165.00,165.00,5741.41,0.00,0.00,0.00,0.00,680870),('5','174','238644','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680871),('5','174','238644','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680872),('5','174','238833','397',165.00,165.00,5754.00,0.00,0.00,0.00,0.00,681363),('5','174','238833','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681364),('5','174','238833','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681365),('5','174','239147','397',165.00,165.00,13563.75,0.00,0.00,0.00,0.00,682176),('5','174','239147','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682177),('5','174','239147','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682178),('5','174','239328','397',165.00,165.00,10004.77,0.00,0.00,0.00,0.00,682641),('5','174','239328','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682642),('5','174','239328','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682643),('5','174','239537','397',165.00,165.00,14682.14,0.00,0.00,0.00,0.00,683193),('5','174','239537','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683194),('5','174','239537','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683195),('5','174','239797','397',165.00,165.00,10443.67,0.00,0.00,0.00,0.00,683866),('5','174','239797','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683867),('5','174','239797','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683868),('5','174','240036','397',165.00,165.00,9486.85,0.00,0.00,0.00,0.00,684481),('5','174','240036','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684482),('5','174','240036','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684483),('5','174','240236','397',165.00,165.00,9671.61,0.00,0.00,0.00,0.00,685000),('5','174','240236','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685001),('5','174','240236','399',345.00,345.00,580.27,0.00,0.00,0.00,0.00,685002),('5','174','240531','397',165.00,165.00,7622.48,0.00,0.00,0.00,0.00,685773),('5','174','240531','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685774),('5','174','240531','399',345.00,345.00,146.77,0.00,0.00,0.00,0.00,685775),('5','174','240769','397',165.00,165.00,12442.72,0.00,0.00,0.00,0.00,686347),('5','174','240769','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686348),('5','174','240769','399',345.00,345.00,1596.11,0.00,0.00,0.00,0.00,686349),('5','174','241015','397',165.00,165.00,8981.13,0.00,0.00,0.00,0.00,687011),('5','174','241015','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687012),('5','174','241015','399',345.00,345.00,473.05,0.00,0.00,0.00,0.00,687013),('5','174','241249','397',165.00,165.00,7624.04,0.00,0.00,0.00,0.00,687618),('5','174','241249','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687619),('5','174','241249','399',345.00,345.00,322.27,0.00,0.00,0.00,0.00,687620),('5','174','241522','397',165.00,165.00,7893.46,0.00,0.00,0.00,0.00,688346),('5','174','241522','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688347),('5','174','241522','399',345.00,345.00,518.00,0.00,0.00,0.00,0.00,688348),('5','174','241747','397',165.00,165.00,390.74,0.00,0.00,0.00,0.00,688951),('5','174','241747','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688952),('5','174','241747','399',345.00,345.00,302.69,0.00,0.00,0.00,0.00,688953),('5','174','242027','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689672),('5','174','242027','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689673),('5','174','242027','399',345.00,345.00,1294.41,0.00,0.00,0.00,0.00,689674),('5','174','242229','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690203),('5','174','242229','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690204),('5','174','242229','399',345.00,345.00,631.79,0.00,0.00,0.00,0.00,690205),('5','174','242450','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690761),('5','174','242450','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690762),('5','174','242450','399',345.00,345.00,591.20,0.00,0.00,0.00,0.00,690763),('5','174','242712','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691443),('5','174','242712','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691444),('5','174','242712','399',345.00,345.00,792.87,0.00,0.00,0.00,0.00,691445),('5','174','243019','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692253),('5','174','243019','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692254),('5','174','243019','399',345.00,345.00,461.41,0.00,0.00,0.00,0.00,692255),('5','174','243180','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692666),('5','174','243180','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692667),('5','174','243180','399',345.00,345.00,725.41,0.00,0.00,0.00,0.00,692668),('5','174','243414','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693286),('5','174','243414','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693287),('5','174','243414','399',345.00,345.00,697.40,0.00,0.00,0.00,0.00,693288),('5','174','243639','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693863),('5','174','243639','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693864),('5','174','243639','399',345.00,345.00,443.74,0.00,0.00,0.00,0.00,693865),('5','174','243888','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694514),('5','174','243888','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694515),('5','174','243888','399',345.00,345.00,333.90,0.00,0.00,0.00,0.00,694516),('5','174','244120','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695105),('5','174','244120','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695106),('5','174','244120','399',345.00,345.00,651.89,0.00,0.00,0.00,0.00,695107),('5','174','244332','397',165.00,165.00,8035.34,0.00,0.00,0.00,0.00,695660),('5','174','244332','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695661),('5','174','244332','399',345.00,345.00,641.60,0.00,0.00,0.00,0.00,695662),('5','174','244699','397',165.00,165.00,5866.71,0.00,0.00,0.00,0.00,696631),('5','174','244699','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696632),('5','174','244699','399',345.00,345.00,618.13,0.00,0.00,0.00,0.00,696633),('5','174','244909','397',165.00,165.00,1099.91,0.00,0.00,0.00,0.00,697177),('5','174','244909','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697178),('5','174','244909','399',345.00,345.00,453.61,0.00,0.00,0.00,0.00,697179),('5','174','245153','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697806),('5','174','245153','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697807),('5','174','245153','399',345.00,345.00,256.37,0.00,0.00,0.00,0.00,697808),('5','174','245258','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698056),('5','174','245258','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698057),('5','174','245258','399',345.00,345.00,704.16,0.00,0.00,0.00,0.00,698058),('5','174','245688','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699171),('5','174','245688','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699172),('5','174','245688','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699173),('5','174','245761','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699356),('5','174','245761','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699357),('5','174','245761','399',345.00,345.00,217.46,0.00,0.00,0.00,0.00,699358),('5','174','245777','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699396),('5','174','245777','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699397),('5','174','245777','399',345.00,345.00,349.62,0.00,0.00,0.00,0.00,699398),('5','174','246003','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699994),('5','174','246003','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699995),('5','174','246003','399',345.00,345.00,106.94,0.00,0.00,0.00,0.00,699996),('5','174','246270','397',165.00,165.00,4615.04,0.00,0.00,0.00,0.00,700679),('5','174','246270','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700680),('5','174','246270','399',345.00,345.00,60.19,0.00,0.00,0.00,0.00,700681),('5','174','246524','397',165.00,165.00,4408.06,0.00,0.00,0.00,0.00,701355),('5','174','246524','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701356),('5','174','246524','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701357),('5','174','246783','397',165.00,165.00,4212.55,0.00,0.00,0.00,0.00,702026),('5','174','246783','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702027),('5','174','246783','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702028),('5','174','247027','397',165.00,165.00,782.78,0.00,0.00,0.00,0.00,702650),('5','174','247027','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702651),('5','174','247027','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702652),('5','174','247310','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703391),('5','174','247310','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703392),('5','174','247310','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703393),('5','174','247503','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703878),('5','174','247503','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703879),('5','174','247503','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703880),('5','174','247850','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704790),('5','174','247850','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704791),('5','174','247850','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704792),('5','174','247929','397',165.00,165.00,3650.99,0.00,0.00,0.00,0.00,704989),('5','174','247929','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704990),('5','174','247929','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704991),('5','174','248216','397',165.00,165.00,3865.21,0.00,0.00,0.00,0.00,705727),('5','174','248216','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705728),('5','174','248216','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705729),('5','174','248473','397',165.00,165.00,5403.05,0.00,0.00,0.00,0.00,706382),('5','174','248473','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706383),('5','174','248473','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706384),('5','174','248784','397',165.00,165.00,5614.75,0.00,0.00,0.00,0.00,707198),('5','174','248784','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707199),('5','174','248784','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707200),('5','174','249030','397',165.00,165.00,6989.79,0.00,0.00,0.00,0.00,707839),('5','174','249030','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707840),('5','174','249030','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707841),('5','174','249162','397',165.00,165.00,6232.30,0.00,0.00,0.00,0.00,708142),('5','174','249162','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708143),('5','174','249162','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708144),('5','174','249394','397',165.00,165.00,5596.63,0.00,0.00,0.00,0.00,708738),('5','174','249394','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708739),('5','174','249394','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708740),('5','174','249696','397',165.00,165.00,6516.27,0.00,0.00,0.00,0.00,709529),('5','174','249696','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709530),('5','174','249696','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709531),('5','174','249945','397',165.00,165.00,4553.96,0.00,0.00,0.00,0.00,710167),('5','174','249945','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710168),('5','174','249945','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710169),('5','174','250189','397',165.00,165.00,3895.98,0.00,0.00,0.00,0.00,710789),('5','174','250189','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710790),('5','174','250189','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710791),('5','174','250509','397',165.00,165.00,5017.17,0.00,0.00,0.00,0.00,711612),('5','174','250509','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711613),('5','174','250509','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711614),('5','174','250931','397',165.00,165.00,5416.27,0.00,0.00,0.00,0.00,712703),('5','174','250931','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712704),('5','174','250931','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712705),('5','174','250944','397',165.00,165.00,5126.17,0.00,0.00,0.00,0.00,712739),('5','174','250944','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712740),('5','174','250944','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712741),('5','174','251183','397',165.00,165.00,8302.96,0.00,0.00,0.00,0.00,713354),('5','174','251183','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713355),('5','174','251183','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713356),('5','174','251305','397',165.00,165.00,8569.98,0.00,0.00,0.00,0.00,713659),('5','174','251305','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713660),('5','174','251305','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713661),('5','174','251537','397',165.00,165.00,7479.57,0.00,0.00,0.00,0.00,714268),('5','174','251537','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714269),('5','174','251537','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714270),('5','174','251846','397',165.00,165.00,6852.41,0.00,0.00,0.00,0.00,715082),('5','174','251846','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715083),('5','174','251846','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715084),('5','174','252047','397',165.00,165.00,8049.87,0.00,0.00,0.00,0.00,715600),('5','174','252047','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715601),('5','174','252047','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715602),('5','174','252297','397',165.00,165.00,5813.60,0.00,0.00,0.00,0.00,716253),('5','174','252297','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716254),('5','174','252297','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716255),('5','174','252559','397',165.00,165.00,6783.06,0.00,0.00,0.00,0.00,716930),('5','174','252559','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716931),('5','174','252559','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716932),('5','174','252819','397',165.00,165.00,9395.71,0.00,0.00,0.00,0.00,717608),('5','174','252819','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717609),('5','174','252819','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717610),('5','174','253062','397',165.00,165.00,5902.74,0.00,0.00,0.00,0.00,718237),('5','174','253062','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718238),('5','174','253062','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718239),('5','174','253337','397',165.00,165.00,6640.97,0.00,0.00,0.00,0.00,718971),('5','174','253337','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718972),('5','174','253337','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718973),('5','174','253541','397',165.00,165.00,6528.83,0.00,0.00,0.00,0.00,719483),('5','174','253541','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719484),('5','174','253541','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719485),('5','174','253735','397',165.00,165.00,6878.36,0.00,0.00,0.00,0.00,719984),('5','174','253735','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719985),('5','174','253735','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719986),('5','174','254003','397',165.00,165.00,5294.55,0.00,0.00,0.00,0.00,720689),('5','174','254003','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720690),('5','174','254003','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720691),('5','174','254216','397',165.00,165.00,4059.49,0.00,0.00,0.00,0.00,721243),('5','174','254216','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721244),('5','174','254216','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721245),('5','174','254503','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721977),('5','174','254503','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721978),('5','174','254503','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721979),('5','174','254774','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722653),('5','174','254774','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722654),('5','174','254774','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722655),('5','174','255019','397',165.00,165.00,1206.26,0.00,0.00,0.00,0.00,723286),('5','174','255019','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723287),('5','174','255019','399',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723288),('5','174','255287','397',165.00,165.00,6924.57,0.00,0.00,0.00,0.00,723981),('5','174','255287','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723982),('5','174','255287','399',345.00,350.00,0.00,0.00,0.00,0.00,0.00,723983),('5','174','255514','397',165.00,165.00,5457.75,0.00,0.00,0.00,0.00,724527),('5','174','255514','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724528),('5','174','255514','399',345.00,350.00,0.00,0.00,0.00,0.00,0.00,724529),('5','174','255759','397',165.00,165.00,4992.78,0.00,0.00,0.00,0.00,725149),('5','174','255759','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725150),('5','174','255759','399',345.00,350.00,0.00,0.00,0.00,0.00,0.00,725151),('5','174','256001','397',165.00,165.00,1130.20,0.00,0.00,0.00,0.00,725769),('5','174','256001','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725770),('5','174','256001','399',345.00,355.00,0.00,0.00,0.00,0.00,0.00,725771),('5','174','256273','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726423),('5','174','256273','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726424),('5','174','256273','399',345.00,355.00,0.00,0.00,0.00,0.00,0.00,726425),('5','174','256537','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727126),('5','174','256537','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727127),('5','174','256537','399',345.00,355.00,0.00,0.00,0.00,0.00,0.00,727128),('5','174','256796','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727787),('5','174','256796','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727788),('5','174','256796','399',345.00,355.00,0.00,0.00,0.00,0.00,0.00,727789),('5','174','256991','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728306),('5','174','256991','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728307),('5','174','256991','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,728308),('5','174','257286','397',165.00,165.00,1920.14,0.00,0.00,0.00,0.00,729077),('5','174','257286','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729078),('5','174','257286','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729079),('5','174','257545','397',165.00,165.00,7576.81,0.00,0.00,0.00,0.00,729745),('5','174','257545','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','174','257545','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729747),('5','174','257546','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729748),('5','174','257546','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','174','257546','397',165.00,165.00,7902.77,0.00,0.00,0.00,0.00,729750),('5','174','257547','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729751),('5','174','257547','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','174','257547','397',165.00,165.00,4776.33,0.00,0.00,0.00,0.00,729753),('5','174','257548','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729754),('5','174','257548','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','174','257548','397',165.00,165.00,1231.38,0.00,0.00,0.00,0.00,729756),('5','174','257549','399',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729757),('5','174','257549','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','174','257549','397',165.00,165.00,4386.58,0.00,0.00,0.00,0.00,729759),('5','174','257550','399',360.00,365.00,0.00,0.00,0.00,0.00,0.00,729760),('5','174','257550','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729761),('5','174','257550','397',165.00,165.00,7684.35,0.00,0.00,0.00,0.00,729762),('5','174','257551','399',360.00,390.00,0.00,0.00,0.00,0.00,0.00,729763),('5','174','257551','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','174','257551','397',165.00,165.00,9074.72,0.00,0.00,0.00,0.00,729765),('5','174','257552','399',360.00,390.00,0.00,0.00,0.00,0.00,0.00,729766),('5','174','257552','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','174','257552','397',165.00,165.00,6518.77,0.00,0.00,0.00,0.00,729768),('5','174','257553','399',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729769),('5','174','257553','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','174','257553','397',165.00,165.00,7862.71,0.00,0.00,0.00,0.00,729771),('5','174','257554','397',165.00,165.00,6412.68,0.00,0.00,0.00,0.00,729772),('5','174','257554','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','174','257554','399',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729774),('5','174','257555','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729775),('5','174','257555','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','174','257555','397',165.00,165.00,3110.09,0.00,0.00,0.00,0.00,729777),('5','174','257556','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729778),('5','174','257556','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729779),('5','174','257556','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729780),('5','174','257557','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729781),('5','174','257557','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','174','257557','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729783),('5','174','257558','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729784),('5','174','257558','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','174','257558','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729786),('5','174','257559','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729787),('5','174','257559','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','174','257559','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729789),('5','174','257560','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729790),('5','174','257560','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','174','257560','397',165.00,165.00,2211.13,0.00,0.00,0.00,0.00,729792),('5','174','257561','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729793),('5','174','257561','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','174','257561','397',165.00,165.00,11311.73,0.00,0.00,0.00,0.00,729795),('5','174','257562','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729796),('5','174','257562','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','174','257562','397',165.00,165.00,9534.66,0.00,0.00,0.00,0.00,729798),('5','174','257563','399',390.00,415.00,0.00,0.00,0.00,0.00,0.00,729799),('5','174','257563','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','174','257563','397',165.00,165.00,6022.24,0.00,0.00,0.00,0.00,729801),('5','174','257564','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729802),('5','174','257564','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','174','257564','397',165.00,165.00,969.66,0.00,0.00,0.00,0.00,729804),('5','174','257565','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729805),('5','174','257565','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','174','257565','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729807),('5','174','257566','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729808),('5','174','257566','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','174','257566','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729810),('5','174','257567','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729811),('5','174','257567','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729812),('5','174','257567','397',165.00,165.00,1800.51,0.00,0.00,0.00,0.00,729813),('5','174','257568','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729814),('5','174','257568','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','174','257568','397',165.00,165.00,11313.65,0.00,0.00,0.00,0.00,729816),('5','174','257569','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729817),('5','174','257569','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','174','257569','397',165.00,165.00,10381.72,0.00,0.00,0.00,0.00,729819),('5','174','257570','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729820),('5','174','257570','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','174','257570','397',165.00,165.00,10486.91,0.00,0.00,0.00,0.00,729822),('5','174','257571','397',165.00,165.00,17488.51,0.00,0.00,0.00,0.00,729823),('5','174','257571','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','174','257571','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729825),('5','174','257572','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729826),('5','174','257572','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','174','257572','397',165.00,165.00,6439.39,0.00,0.00,0.00,0.00,729828),('5','174','257573','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729829),('5','174','257573','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729830),('5','174','257573','397',165.00,165.00,8598.21,0.00,0.00,0.00,0.00,729831),('5','174','257574','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729832),('5','174','257574','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','174','257574','397',165.00,165.00,2897.34,0.00,0.00,0.00,0.00,729834),('5','174','257575','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729835),('5','174','257575','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','174','257575','397',165.00,165.00,19070.20,0.00,0.00,0.00,0.00,729837),('5','174','257576','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729838),('5','174','257576','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','174','257576','397',165.00,165.00,3866.00,0.00,0.00,0.00,0.00,729840),('5','174','257577','399',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729841),('5','174','257577','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','174','257577','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','174','257578','399',415.00,440.00,0.00,0.00,0.00,0.00,0.00,729844),('5','174','257578','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729845),('5','174','257578','397',165.00,165.00,3994.36,0.00,0.00,0.00,0.00,729846),('5','174','257579','399',440.00,500.00,0.00,0.00,0.00,0.00,0.00,729847),('5','174','257579','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729848),('5','174','257579','397',165.00,165.00,10086.54,0.00,0.00,0.00,0.00,729849),('5','174','257580','399',440.00,500.00,0.00,0.00,0.00,0.00,0.00,729850),('5','174','257580','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729851),('5','174','257580','397',165.00,165.00,3043.00,0.00,0.00,0.00,0.00,729852),('5','174','257581','399',440.00,500.00,0.00,0.00,0.00,0.00,0.00,729853),('5','174','257581','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','174','257581','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','174','257582','399',440.00,500.00,0.00,0.00,0.00,0.00,0.00,729856),('5','174','257582','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729857),('5','174','257582','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','174','257583','399',440.00,600.00,0.00,0.00,0.00,0.00,0.00,729859),('5','174','257583','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','174','257583','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','174','257584','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729862),('5','174','257584','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','174','257584','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729864),('5','174','257585','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729865),('5','174','257585','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729866),('5','174','257585','397',165.00,165.00,2087.00,0.00,0.00,0.00,0.00,729867),('5','174','257586','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729868),('5','174','257586','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729869),('5','174','257586','397',165.00,165.00,6558.59,0.00,0.00,0.00,0.00,729870),('5','174','257587','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729871),('5','174','257587','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','174','257587','397',165.00,165.00,5997.13,0.00,0.00,0.00,0.00,729873),('5','174','257588','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729874),('5','174','257588','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','174','257588','397',165.00,165.00,1351.44,0.00,0.00,0.00,0.00,729876),('5','174','257589','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729877),('5','174','257589','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','174','257589','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','174','257590','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729880),('5','174','257590','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','174','257590','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729882),('5','174','257591','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729883),('5','174','257591','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','174','257591','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729885),('5','174','257592','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729886),('5','174','257592','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','174','257592','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729888),('5','174','257593','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729889),('5','174','257593','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','174','257593','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729891),('5','174','257594','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729892),('5','174','257594','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','174','257594','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729894),('5','174','257595','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729895),('5','174','257595','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','174','257595','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729897),('5','174','257596','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729898),('5','174','257596','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','174','257596','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729900),('5','174','257597','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729901),('5','174','257597','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729902),('5','174','257597','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729903),('5','174','257598','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729904),('5','174','257598','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729905),('5','174','257598','397',165.00,165.00,4143.31,0.00,0.00,0.00,0.00,729906),('5','174','257599','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729907),('5','174','257599','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729908),('5','174','257599','397',165.00,165.00,7603.38,0.00,0.00,0.00,0.00,729909),('5','174','257600','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729910),('5','174','257600','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729911),('5','174','257600','397',165.00,165.00,7682.54,0.00,0.00,0.00,0.00,729912),('5','174','257601','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729913),('5','174','257601','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','174','257601','397',165.00,165.00,1217.39,0.00,0.00,0.00,0.00,729915),('5','174','257602','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729916),('5','174','257602','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','174','257602','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729918),('5','174','257603','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729919),('5','174','257603','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','174','257603','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729921),('5','174','257604','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729922),('5','174','257604','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','174','257604','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729924),('5','174','257605','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729925),('5','174','257605','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','174','257605','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729927),('5','174','257606','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729928),('5','174','257606','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','174','257606','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729930),('5','174','257607','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729931),('5','174','257607','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','174','257607','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729933),('5','174','257608','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729934),('5','174','257608','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','174','257608','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729936),('5','174','257609','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729937),('5','174','257609','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729938),('5','174','257609','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','174','257610','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729940),('5','174','257610','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729941),('5','174','257610','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729942),('5','174','257611','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729943),('5','174','257611','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729944),('5','174','257611','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729945),('5','174','257612','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729946),('5','174','257612','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729947),('5','174','257612','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729948),('5','174','257613','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729949),('5','174','257613','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','174','257613','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729951),('5','174','257614','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729952),('5','174','257614','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729953),('5','174','257614','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','174','257615','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729955),('5','174','257615','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','174','257615','397',165.00,165.00,2179.20,0.00,0.00,0.00,0.00,729957),('5','174','257616','399',440.00,640.00,0.00,0.00,0.00,0.00,0.00,729958),('5','174','257616','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','174','257616','397',165.00,165.00,4613.22,0.00,0.00,0.00,0.00,729960),('5','174','257617','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729961),('5','174','257617','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729962),('5','174','257617','397',165.00,165.00,4579.26,0.00,0.00,0.00,0.00,729963),('5','174','257618','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729964),('5','174','257618','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','174','257618','397',165.00,165.00,2028.61,0.00,0.00,0.00,0.00,729966),('5','174','257619','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729967),('5','174','257619','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','174','257619','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729969),('5','174','257620','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729970),('5','174','257620','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','174','257620','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729972),('5','174','257621','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729973),('5','174','257621','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729974),('5','174','257621','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729975),('5','174','257622','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729976),('5','174','257622','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','174','257622','397',165.00,165.00,3186.31,0.00,0.00,0.00,0.00,729978),('5','174','257623','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729979),('5','174','257623','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','174','257623','397',165.00,165.00,5949.40,0.00,0.00,0.00,0.00,729981),('5','174','257624','397',165.00,165.00,5284.76,0.00,0.00,0.00,0.00,729982),('5','174','257624','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','174','257624','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729984),('5','174','257625','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729985),('5','174','257625','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','174','257625','397',165.00,165.00,5321.61,0.00,0.00,0.00,0.00,729987),('5','174','257626','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729988),('5','174','257626','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729989),('5','174','257626','397',165.00,165.00,5399.97,0.00,0.00,0.00,0.00,729990),('5','174','257627','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729991),('5','174','257627','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729992),('5','174','257627','397',165.00,165.00,4259.03,0.00,0.00,0.00,0.00,729993),('5','174','257628','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729994),('5','174','257628','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','174','257628','397',165.00,165.00,7014.17,0.00,0.00,0.00,0.00,729996),('5','174','257629','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,729997),('5','174','257629','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','174','257629','397',165.00,165.00,5600.55,0.00,0.00,0.00,0.00,729999),('5','174','257630','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730000),('5','174','257630','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','174','257630','397',165.00,165.00,720.20,0.00,0.00,0.00,0.00,730002),('5','174','257631','397',165.00,165.00,6215.01,0.00,0.00,0.00,0.00,730003),('5','174','257631','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730004),('5','174','257631','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730005),('5','174','257632','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730006),('5','174','257632','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730007),('5','174','257632','397',165.00,165.00,6250.90,0.00,0.00,0.00,0.00,730008),('5','174','257633','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730009),('5','174','257633','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730010),('5','174','257633','397',165.00,165.00,5839.79,0.00,0.00,0.00,0.00,730011),('5','174','257634','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730012),('5','174','257634','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','174','257634','397',165.00,165.00,8445.24,0.00,0.00,0.00,0.00,730014),('5','174','257635','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730015),('5','174','257635','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','174','257635','397',165.00,165.00,9639.43,0.00,0.00,0.00,0.00,730017),('5','174','257636','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730018),('5','174','257636','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','174','257636','397',165.00,165.00,5124.84,0.00,0.00,0.00,0.00,730020),('5','174','257637','397',165.00,165.00,5142.43,0.00,0.00,0.00,0.00,730021),('5','174','257637','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','174','257637','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730023),('5','174','257638','397',165.00,165.00,4620.02,0.00,0.00,0.00,0.00,730024),('5','174','257638','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','174','257638','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730026),('5','174','257639','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730027),('5','174','257639','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','174','257639','397',165.00,165.00,1120.42,0.00,0.00,0.00,0.00,730029),('5','174','257640','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730030),('5','174','257640','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','174','257640','397',165.00,165.00,3283.11,0.00,0.00,0.00,0.00,730032),('5','174','257641','397',165.00,165.00,4139.25,0.00,0.00,0.00,0.00,730033),('5','174','257641','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730034),('5','174','257641','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730035),('5','174','257642','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730036),('5','174','257642','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','174','257642','397',165.00,165.00,4759.07,0.00,0.00,0.00,0.00,730038),('5','174','257643','397',165.00,165.00,1215.13,0.00,0.00,0.00,0.00,730039),('5','174','257643','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730040),('5','174','257643','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730041),('5','174','257644','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730042),('5','174','257644','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730043),('5','174','257644','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730044),('5','174','257645','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730045),('5','174','257645','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','174','257645','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730047),('5','174','257646','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730048),('5','174','257646','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','174','257646','399',440.00,660.00,0.00,0.00,0.00,0.00,0.00,730050),('5','174','257647','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730051),('5','174','257647','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','174','257647','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730053),('5','174','257648','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730054),('5','174','257648','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','174','257648','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730056),('5','174','257649','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730057),('5','174','257649','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730058),('5','174','257649','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730059),('5','174','257650','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730060),('5','174','257650','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730061),('5','174','257650','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730062),('5','174','257651','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730063),('5','174','257651','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','174','257651','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730065),('5','174','257652','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730066),('5','174','257652','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','174','257652','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730068),('5','174','257653','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730069),('5','174','257653','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','174','257653','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','174','257654','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730072),('5','174','257654','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','174','257654','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730074),('5','174','257655','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730075),('5','174','257655','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','174','257655','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730077),('5','174','257656','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730078),('5','174','257656','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','174','257656','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730080),('5','174','257657','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730081),('5','174','257657','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','174','257657','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730083),('5','174','257658','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730084),('5','174','257658','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','174','257658','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','174','257659','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730087),('5','174','257659','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','174','257659','397',165.00,165.00,2153.02,0.00,0.00,0.00,0.00,730089),('5','174','257660','397',165.00,165.00,4621.03,0.00,0.00,0.00,0.00,730090),('5','174','257660','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','174','257660','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730092),('5','174','257661','397',165.00,165.00,4724.63,0.00,0.00,0.00,0.00,730093),('5','174','257661','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','174','257661','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730095),('5','174','257662','397',165.00,165.00,5042.51,0.00,0.00,0.00,0.00,730096),('5','174','257662','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','174','257662','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730098),('5','174','257663','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730099),('5','174','257663','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','174','257663','397',165.00,165.00,5133.95,0.00,0.00,0.00,0.00,730101),('5','174','257664','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730102),('5','174','257664','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','174','257664','397',165.00,165.00,5161.13,0.00,0.00,0.00,0.00,730104),('5','174','257665','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730105),('5','174','257665','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','174','257665','397',165.00,165.00,2215.00,0.00,0.00,0.00,0.00,730107),('5','174','257666','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730108),('5','174','257666','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','174','257666','399',440.00,700.00,0.00,0.00,0.00,0.00,0.00,730110),('5','174','257667','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730111),('5','174','257667','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','174','257667','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730113),('5','174','257668','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730114),('5','174','257668','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','174','257668','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730116),('5','174','257669','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730117),('5','174','257669','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','174','257669','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730119),('5','174','257670','397',165.00,165.00,1825.37,0.00,0.00,0.00,0.00,730120),('5','174','257670','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','174','257670','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730122),('5','174','257671','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730123),('5','174','257671','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','174','257671','397',165.00,165.00,5014.76,0.00,0.00,0.00,0.00,730125),('5','174','257672','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730126),('5','174','257672','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','174','257672','397',165.00,165.00,4218.72,0.00,0.00,0.00,0.00,730128),('5','174','257673','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730129),('5','174','257673','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','174','257673','397',165.00,165.00,5114.19,0.00,0.00,0.00,0.00,730131),('5','174','257674','397',165.00,165.00,4322.79,0.00,0.00,0.00,0.00,730132),('5','174','257674','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','174','257674','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730134),('5','174','257675','397',165.00,165.00,4138.50,0.00,0.00,0.00,0.00,730135),('5','174','257675','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','174','257675','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730137),('5','174','257676','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730138),('5','174','257676','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','174','257676','397',165.00,165.00,4011.03,0.00,0.00,0.00,0.00,730140),('5','174','257677','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730141),('5','174','257677','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','174','257677','397',165.00,165.00,3814.25,0.00,0.00,0.00,0.00,730143),('5','174','257678','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730144),('5','174','257678','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','174','257678','397',165.00,165.00,4134.25,0.00,0.00,0.00,0.00,730146),('5','174','257679','397',165.00,165.00,3147.25,0.00,0.00,0.00,0.00,730147),('5','174','257679','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','174','257679','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730149),('5','174','257680','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730150),('5','174','257680','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','174','257680','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730152),('5','174','257681','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730153),('5','174','257681','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','174','257681','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730155),('5','174','257682','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730156),('5','174','257682','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','174','257682','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730158),('5','174','257683','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730159),('5','174','257683','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','174','257683','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730161),('5','174','257684','397',165.00,165.00,512.23,0.00,0.00,0.00,0.00,730162),('5','174','257684','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','174','257684','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730164),('5','174','257685','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730165),('5','174','257685','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','174','257685','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730167),('5','174','257686','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730168),('5','174','257686','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','174','257686','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730170),('5','174','257687','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730171),('5','174','257687','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','174','257687','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730173),('5','174','257688','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730174),('5','174','257688','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','174','257688','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730176),('5','174','257689','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730177),('5','174','257689','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','174','257689','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730179),('5','174','257690','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730180),('5','174','257690','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','174','257690','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730182),('5','174','257691','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730183),('5','174','257691','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','174','257691','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730185),('5','174','257692','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730186),('5','174','257692','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','174','257692','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730188),('5','174','257693','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730189),('5','174','257693','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','174','257693','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730191),('5','174','257694','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730192),('5','174','257694','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','174','257694','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730194),('5','174','257695','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730195),('5','174','257695','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','174','257695','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730197),('5','174','257696','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730198),('5','174','257696','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','174','257696','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730200),('5','174','257697','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730201),('5','174','257697','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','174','257697','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730203),('5','174','257698','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730204),('5','174','257698','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','174','257698','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730206),('5','174','257699','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730207),('5','174','257699','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','174','257699','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730209),('5','174','257700','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730210),('5','174','257700','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','174','257700','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730212),('5','174','257701','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730213),('5','174','257701','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','174','257701','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730215),('5','174','257702','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730216),('5','174','257702','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','174','257702','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730218),('5','174','257703','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730219),('5','174','257703','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','174','257703','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730221),('5','174','257704','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730222),('5','174','257704','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','174','257704','397',165.00,165.00,4912.68,0.00,0.00,0.00,0.00,730224),('5','174','257705','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730225),('5','174','257705','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','174','257705','397',165.00,165.00,4218.08,0.00,0.00,0.00,0.00,730227),('5','174','257706','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730228),('5','174','257706','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','174','257706','397',165.00,165.00,3652.15,0.00,0.00,0.00,0.00,730230),('5','174','257707','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730231),('5','174','257707','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','174','257707','397',165.00,165.00,3128.31,0.00,0.00,0.00,0.00,730233),('5','174','257708','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730234),('5','174','257708','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','174','257708','397',165.00,185.00,1039.01,0.00,0.00,0.00,0.00,730236),('5','174','257709','397',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730237),('5','174','257709','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','174','257709','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730239),('5','174','257710','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730240),('5','174','257710','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','174','257710','397',165.00,185.00,3825.80,0.00,0.00,0.00,0.00,730242),('5','174','257711','397',185.00,185.00,5142.66,0.00,0.00,0.00,0.00,730243),('5','174','257711','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','174','257711','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730245),('5','174','257712','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730246),('5','174','257712','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730247),('5','174','257712','397',185.00,185.00,5572.69,0.00,0.00,0.00,0.00,730248),('5','174','257713','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730249),('5','174','257713','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','174','257713','397',185.00,185.00,6237.99,0.00,0.00,0.00,0.00,730251),('5','174','257714','397',185.00,185.00,6110.24,0.00,0.00,0.00,0.00,730252),('5','174','257714','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','174','257714','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730254),('5','174','257715','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730255),('5','174','257715','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','174','257715','397',185.00,185.00,6622.82,0.00,0.00,0.00,0.00,730257),('5','174','257716','397',185.00,185.00,7083.44,0.00,0.00,0.00,0.00,730258),('5','174','257716','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','174','257716','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730260),('5','174','257717','397',185.00,185.00,5519.25,0.00,0.00,0.00,0.00,730261),('5','174','257717','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','174','257717','399',440.00,800.00,0.00,0.00,0.00,0.00,0.00,730263),('5','174','257718','397',185.00,185.00,4642.78,0.00,0.00,0.00,0.00,730264),('5','174','257718','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','174','257718','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730266),('5','174','257719','397',185.00,165.00,5436.89,0.00,0.00,0.00,0.00,730267),('5','174','257719','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730268),('5','174','257719','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730269),('5','174','257720','397',185.00,165.00,5104.09,0.00,0.00,0.00,0.00,730270),('5','174','257720','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730271),('5','174','257720','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730272),('5','174','257721','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730273),('5','174','257721','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','174','257721','397',185.00,185.00,5008.36,0.00,0.00,0.00,0.00,730275),('5','174','257722','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730276),('5','174','257722','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','174','257722','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730278),('5','174','257723','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730279),('5','174','257723','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','174','257723','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730281),('5','174','257724','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730282),('5','174','257724','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','174','257724','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730284),('5','174','257725','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730285),('5','174','257725','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','174','257725','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730287),('5','174','257726','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730288),('5','174','257726','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','174','257726','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730290),('5','174','257727','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730291),('5','174','257727','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','174','257727','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730293),('5','174','257728','397',185.00,185.00,2518.77,0.00,0.00,0.00,0.00,730294),('5','174','257728','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','174','257728','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730296),('5','174','257729','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730297),('5','174','257729','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','174','257729','397',185.00,185.00,5453.35,0.00,0.00,0.00,0.00,730299),('5','174','257730','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730300),('5','174','257730','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','174','257730','397',185.00,185.00,4786.55,0.00,0.00,0.00,0.00,730302),('5','174','257731','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730303),('5','174','257731','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730304),('5','174','257731','397',185.00,185.00,5047.63,0.00,0.00,0.00,0.00,730305),('5','174','257732','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730306),('5','174','257732','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730307),('5','174','257732','397',185.00,185.00,5224.23,0.00,0.00,0.00,0.00,730308),('5','174','257733','397',185.00,185.00,4823.77,0.00,0.00,0.00,0.00,730309),('5','174','257733','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730310),('5','174','257733','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730311),('5','174','257734','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730312),('5','174','257734','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730313),('5','174','257734','397',185.00,185.00,2111.92,0.00,0.00,0.00,0.00,730314),('5','174','257735','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730315),('5','174','257735','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','174','257735','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730317),('5','174','257736','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730318),('5','174','257736','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','174','257736','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730320),('5','174','257737','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730321),('5','174','257737','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','174','257737','397',185.00,185.00,3154.75,0.00,0.00,0.00,0.00,730323),('5','174','257738','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730324),('5','174','257738','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730325),('5','174','257738','397',185.00,185.00,6007.16,0.00,0.00,0.00,0.00,730326),('5','174','257739','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730327),('5','174','257739','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730328),('5','174','257739','397',185.00,185.00,5168.61,0.00,0.00,0.00,0.00,730329),('5','174','257740','397',185.00,185.00,5399.44,0.00,0.00,0.00,0.00,730330),('5','174','257740','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730331),('5','174','257740','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730332),('5','174','257741','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730333),('5','174','257741','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','174','257741','397',185.00,185.00,5622.40,0.00,0.00,0.00,0.00,730335),('5','174','257742','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730336),('5','174','257742','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730337),('5','174','257742','397',185.00,185.00,6920.35,0.00,0.00,0.00,0.00,730338),('5','174','257743','397',185.00,185.00,6723.16,0.00,0.00,0.00,0.00,730339),('5','174','257743','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730340),('5','174','257743','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730341),('5','174','257744','397',185.00,185.00,6845.03,0.00,0.00,0.00,0.00,730342),('5','174','257744','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730343),('5','174','257744','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730344),('5','174','257745','397',185.00,185.00,6427.19,0.00,0.00,0.00,0.00,730345),('5','174','257745','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730346),('5','174','257745','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730347),('5','174','257746','397',185.00,185.00,7104.02,0.00,0.00,0.00,0.00,730348),('5','174','257746','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730349),('5','174','257746','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730350),('5','174','257747','397',185.00,185.00,5743.64,0.00,0.00,0.00,0.00,730351),('5','174','257747','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730352),('5','174','257747','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730353),('5','174','257748','397',185.00,185.00,4812.48,0.00,0.00,0.00,0.00,730354),('5','174','257748','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730355),('5','174','257748','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730356),('5','174','257749','397',185.00,185.00,5221.34,0.00,0.00,0.00,0.00,730357),('5','174','257749','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730358),('5','174','257749','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730359),('5','174','257750','397',185.00,185.00,4742.38,0.00,0.00,0.00,0.00,730360),('5','174','257750','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730361),('5','174','257750','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730362),('5','174','257751','397',185.00,185.00,2046.45,0.00,0.00,0.00,0.00,730363),('5','174','257751','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730364),('5','174','257751','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730365),('5','174','257752','397',185.00,185.00,3214.55,0.00,0.00,0.00,0.00,730366),('5','174','257752','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','174','257752','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730368),('5','174','257753','397',185.00,185.00,5225.81,0.00,0.00,0.00,0.00,730369),('5','174','257753','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','174','257753','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730371),('5','174','257754','397',185.00,185.00,6224.14,0.00,0.00,0.00,0.00,730372),('5','174','257754','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','174','257754','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730374),('5','174','257755','397',185.00,185.00,6011.02,0.00,0.00,0.00,0.00,730375),('5','174','257755','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','174','257755','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730377),('5','174','257756','397',185.00,185.00,5718.42,0.00,0.00,0.00,0.00,730378),('5','174','257756','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','174','257756','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730380),('5','174','257757','397',185.00,185.00,6144.52,0.00,0.00,0.00,0.00,730381),('5','174','257757','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730382),('5','174','257757','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730383),('5','174','257758','397',185.00,185.00,10123.78,0.00,0.00,0.00,0.00,730384),('5','174','257758','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','174','257758','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730386),('5','174','257759','397',185.00,185.00,11004.29,0.00,0.00,0.00,0.00,730387),('5','174','257759','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','174','257759','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730389),('5','174','257760','397',185.00,185.00,11595.86,0.00,0.00,0.00,0.00,730390),('5','174','257760','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730391),('5','174','257760','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730392),('5','174','257761','397',185.00,185.00,10236.50,0.00,0.00,0.00,0.00,730393),('5','174','257761','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','174','257761','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730395),('5','174','257762','397',185.00,185.00,5217.35,0.00,0.00,0.00,0.00,730396),('5','174','257762','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730397),('5','174','257762','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730398),('5','174','257763','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730399),('5','174','257763','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730400),('5','174','257763','397',185.00,185.00,6036.42,0.00,0.00,0.00,0.00,730401),('5','174','257764','397',185.00,185.00,8816.21,0.00,0.00,0.00,0.00,730402),('5','174','257764','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730403),('5','174','257764','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730404),('5','174','257765','397',185.00,185.00,10021.12,0.00,0.00,0.00,0.00,730405),('5','174','257765','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','174','257765','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730407),('5','174','257766','397',185.00,185.00,9011.84,0.00,0.00,0.00,0.00,730408),('5','174','257766','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','174','257766','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730410),('5','174','257767','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730411),('5','174','257767','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','174','257767','397',185.00,185.00,14211.42,0.00,0.00,0.00,0.00,730413),('5','174','257768','397',185.00,165.00,4625.96,0.00,0.00,0.00,0.00,730414),('5','174','257768','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730415),('5','174','257768','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730416),('5','174','257769','397',185.00,185.00,6023.07,0.00,0.00,0.00,0.00,730417),('5','174','257769','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','174','257769','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730419),('5','174','257770','397',185.00,185.00,4331.01,0.00,0.00,0.00,0.00,730420),('5','174','257770','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','174','257770','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730422),('5','174','257771','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730423),('5','174','257771','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730424),('5','174','257771','397',185.00,185.00,1324.02,0.00,0.00,0.00,0.00,730425),('5','174','257772','397',185.00,185.00,5651.09,0.00,0.00,0.00,0.00,730426),('5','174','257772','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730427),('5','174','257772','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730428),('5','174','257773','397',185.00,185.00,8676.24,0.00,0.00,0.00,0.00,730429),('5','174','257773','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','174','257773','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730431),('5','174','257774','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730432),('5','174','257774','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730433),('5','174','257774','397',185.00,185.00,8159.99,0.00,0.00,0.00,0.00,730434),('5','174','257775','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730435),('5','174','257775','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','174','257775','397',185.00,185.00,6330.21,0.00,0.00,0.00,0.00,730437),('5','174','257776','397',185.00,185.00,6319.27,0.00,0.00,0.00,0.00,730438),('5','174','257776','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730439),('5','174','257776','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730440),('5','174','257777','397',185.00,185.00,11567.39,0.00,0.00,0.00,0.00,730441),('5','174','257777','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','174','257777','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730443),('5','174','257778','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730444),('5','174','257778','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','174','257778','397',185.00,185.00,6772.75,0.00,0.00,0.00,0.00,730446),('5','174','257779','397',185.00,185.00,10226.14,0.00,0.00,0.00,0.00,730447),('5','174','257779','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','174','257779','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730449),('5','174','257780','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730450),('5','174','257780','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','174','257780','397',185.00,185.00,8403.24,0.00,0.00,0.00,0.00,730452),('5','174','257781','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730453),('5','174','257781','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730454),('5','174','257781','397',185.00,185.00,6544.65,0.00,0.00,0.00,0.00,730455),('5','174','257782','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730456),('5','174','257782','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730457),('5','174','257782','397',185.00,185.00,5750.50,0.00,0.00,0.00,0.00,730458),('5','174','257783','397',185.00,165.00,8366.80,0.00,0.00,0.00,0.00,730459),('5','174','257783','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730460),('5','174','257783','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730461),('5','174','257784','397',185.00,185.00,11216.06,0.00,0.00,0.00,0.00,730462),('5','174','257784','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','174','257784','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730464),('5','174','257785','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730465),('5','174','257785','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730466),('5','174','257785','397',185.00,185.00,8377.66,0.00,0.00,0.00,0.00,730467),('5','174','257786','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730468),('5','174','257786','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730469),('5','174','257786','397',185.00,185.00,10525.07,0.00,0.00,0.00,0.00,730470),('5','174','257787','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730471),('5','174','257787','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','174','257787','397',185.00,185.00,13778.56,0.00,0.00,0.00,0.00,730473),('5','174','257788','397',185.00,185.00,17357.98,0.00,0.00,0.00,0.00,730474),('5','174','257788','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','174','257788','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730476),('5','174','257789','397',185.00,185.00,10221.12,0.00,0.00,0.00,0.00,730477),('5','174','257789','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730478),('5','174','257789','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730479),('5','174','257790','397',185.00,185.00,7116.70,0.00,0.00,0.00,0.00,730480),('5','174','257790','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730481),('5','174','257790','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730482),('5','174','257791','397',185.00,185.00,3096.27,0.00,0.00,0.00,0.00,730483),('5','174','257791','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730484),('5','174','257791','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730485),('5','174','257792','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730486),('5','174','257792','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730487),('5','174','257792','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730488),('5','174','257793','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730489),('5','174','257793','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730490),('5','174','257793','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730491),('5','174','257794','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730492),('5','174','257794','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730493),('5','174','257794','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730494),('5','174','257795','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730495),('5','174','257795','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730496),('5','174','257795','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730497),('5','174','257796','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730498),('5','174','257796','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730499),('5','174','257796','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730500),('5','174','257797','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730501),('5','174','257797','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730502),('5','174','257797','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730503),('5','174','257798','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730504),('5','174','257798','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730505),('5','174','257798','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730506),('5','174','257799','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730507),('5','174','257799','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730508),('5','174','257799','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730509),('5','174','257800','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730510),('5','174','257800','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730511),('5','174','257800','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730512),('5','174','257801','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730513),('5','174','257801','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','174','257801','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730515),('5','174','257802','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730516),('5','174','257802','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730517),('5','174','257802','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730518),('5','174','257803','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730519),('5','174','257803','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730520),('5','174','257803','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730521),('5','174','257804','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730522),('5','174','257804','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730523),('5','174','257804','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730524),('5','174','257805','397',185.00,185.00,3824.63,0.00,0.00,0.00,0.00,730525),('5','174','257805','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730526),('5','174','257805','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730527),('5','174','257806','397',185.00,185.00,8065.25,0.00,0.00,0.00,0.00,730528),('5','174','257806','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730529),('5','174','257806','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730530),('5','174','257807','397',185.00,185.00,9154.64,0.00,0.00,0.00,0.00,730531),('5','174','257807','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730532),('5','174','257807','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730533),('5','174','257808','397',185.00,185.00,8071.12,0.00,0.00,0.00,0.00,730534),('5','174','257808','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730535),('5','174','257808','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730536),('5','174','257809','397',185.00,185.00,7821.16,0.00,0.00,0.00,0.00,730537),('5','174','257809','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730538),('5','174','257809','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730539),('5','174','257810','397',185.00,185.00,7123.52,0.00,0.00,0.00,0.00,730540),('5','174','257810','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730541),('5','174','257810','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730542),('5','174','257811','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730543),('5','174','257811','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730544),('5','174','257811','397',185.00,185.00,6418.24,0.00,0.00,0.00,0.00,730545),('5','174','257812','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730546),('5','174','257812','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730547),('5','174','257812','397',185.00,185.00,5623.52,0.00,0.00,0.00,0.00,730548),('5','174','257813','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730549),('5','174','257813','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730550),('5','174','257813','397',185.00,185.00,4611.02,0.00,0.00,0.00,0.00,730551),('5','174','257814','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730552),('5','174','257814','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730553),('5','174','257814','397',185.00,165.00,7011.33,0.00,0.00,0.00,0.00,730554),('5','174','257815','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730555),('5','174','257815','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730556),('5','174','257815','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730557),('5','174','257816','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730558),('5','174','257816','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730559),('5','174','257816','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730560),('5','174','257817','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','174','257817','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730562),('5','174','257817','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730563),('5','174','257818','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730564),('5','174','257818','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730565),('5','174','257818','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730566),('5','174','257819','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730567),('5','174','257819','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730568),('5','174','257819','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730569),('5','174','257820','397',185.00,185.00,3124.52,0.00,0.00,0.00,0.00,730570),('5','174','257820','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730571),('5','174','257820','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730572),('5','174','257821','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730573),('5','174','257821','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730574),('5','174','257821','397',185.00,185.00,8634.39,0.00,0.00,0.00,0.00,730575),('5','174','257822','397',185.00,185.00,3251.01,0.00,0.00,0.00,0.00,730576),('5','174','257822','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730577),('5','174','257822','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730578),('5','174','257823','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730579),('5','174','257823','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730580),('5','174','257823','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730581),('5','174','257824','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730582),('5','174','257824','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','174','257824','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730584),('5','174','257825','397',185.00,185.00,6124.04,0.00,0.00,0.00,0.00,730585),('5','174','257825','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730586),('5','174','257825','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730587),('5','174','257826','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730588),('5','174','257826','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','174','257826','397',185.00,185.00,5072.16,0.00,0.00,0.00,0.00,730590),('5','174','257827','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730591),('5','174','257827','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730592),('5','174','257827','397',185.00,185.00,3614.03,0.00,0.00,0.00,0.00,730593),('5','174','257828','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730594),('5','174','257828','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730595),('5','174','257828','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730596),('5','174','257829','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730597),('5','174','257829','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730598),('5','174','257829','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730599),('5','174','257830','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730600),('5','174','257830','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730601),('5','174','257830','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730602),('5','174','257831','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730603),('5','174','257831','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730604),('5','174','257831','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730605),('5','174','257832','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730606),('5','174','257832','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730607),('5','174','257832','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730608),('5','174','257833','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730609),('5','174','257833','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730610),('5','174','257833','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730611),('5','174','257834','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730612),('5','174','257834','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','174','257834','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730614),('5','174','257835','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730615),('5','174','257835','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730616),('5','174','257835','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730617),('5','174','257836','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730618),('5','174','257836','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730619),('5','174','257836','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730620),('5','174','257837','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730621),('5','174','257837','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','174','257837','397',185.00,165.00,4123.00,0.00,0.00,0.00,0.00,730623),('5','174','257838','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730624),('5','174','257838','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','174','257838','397',185.00,185.00,6345.00,0.00,0.00,0.00,0.00,730626),('5','174','257839','397',185.00,185.00,3245.00,0.00,0.00,0.00,0.00,730627),('5','174','257839','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730628),('5','174','257839','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730629),('5','174','257840','397',185.00,165.00,3851.99,0.00,0.00,0.00,0.00,730630),('5','174','257840','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730631),('5','174','257840','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730632),('5','174','257841','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730633),('5','174','257841','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730634),('5','174','257841','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730635),('5','174','257842','397',185.00,185.00,6713.46,0.00,0.00,0.00,0.00,730636),('5','174','257842','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730637),('5','174','257842','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730638),('5','174','257843','397',185.00,185.00,7014.05,0.00,0.00,0.00,0.00,730639),('5','174','257843','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','174','257843','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730641),('5','174','257844','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730642),('5','174','257844','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730643),('5','174','257844','397',185.00,185.00,8256.50,0.00,0.00,0.00,0.00,730644),('5','174','257845','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730645),('5','174','257845','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730646),('5','174','257845','397',185.00,185.00,3213.21,0.00,0.00,0.00,0.00,730647),('5','174','257846','397',185.00,165.00,3213.45,0.00,0.00,0.00,0.00,730648),('5','174','257846','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730649),('5','174','257846','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730650),('5','174','257847','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730651),('5','174','257847','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730652),('5','174','257847','397',185.00,185.00,6058.09,0.00,0.00,0.00,0.00,730653),('5','174','257848','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730654),('5','174','257848','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730655),('5','174','257848','397',185.00,185.00,1754.06,0.00,0.00,0.00,0.00,730656),('5','174','257849','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730657),('5','174','257849','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730658),('5','174','257849','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730659),('5','174','257850','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730660),('5','174','257850','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730661),('5','174','257850','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730662),('5','174','257851','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730663),('5','174','257851','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730664),('5','174','257851','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730665),('5','174','257852','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730666),('5','174','257852','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730667),('5','174','257852','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730668),('5','174','257853','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730669),('5','174','257853','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730670),('5','174','257853','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730671),('5','174','257854','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730672),('5','174','257854','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730673),('5','174','257854','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730674),('5','174','257855','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730675),('5','174','257855','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730676),('5','174','257855','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730677),('5','174','257856','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730678),('5','174','257856','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730679),('5','174','257856','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730680),('5','174','257857','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730681),('5','174','257857','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','174','257857','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730683),('5','174','257858','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730684),('5','174','257858','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730685),('5','174','257858','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730686),('5','174','257859','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730687),('5','174','257859','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730688),('5','174','257859','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730689),('5','174','257860','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730690),('5','174','257860','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730691),('5','174','257860','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730692),('5','174','257865','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730693),('5','174','257865','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730694),('5','174','257865','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730695),('5','174','257866','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730696),('5','174','257866','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730697),('5','174','257866','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730698),('5','174','257867','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730699),('5','174','257867','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730700),('5','174','257867','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730701),('5','174','257873','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730706),('5','174','257873','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730707),('5','174','257873','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730708),('5','174','257874','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730709),('5','174','257874','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730710),('5','174','257874','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730711),('5','174','257875','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730712),('5','174','257875','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730713),('5','174','257875','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730714),('5','174','257876','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730715),('5','174','257876','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730716),('5','174','257876','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730717),('5','174','257877','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730718),('5','174','257877','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730719),('5','174','257877','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730720),('5','174','257878','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730721),('5','174','257878','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730722),('5','174','257878','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730723),('5','174','257879','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730724),('5','174','257879','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730725),('5','174','257879','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730726),('5','174','257880','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730727),('5','174','257880','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','174','257880','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730729),('5','174','257881','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730730),('5','174','257881','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730731),('5','174','257881','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730732),('5','174','257882','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730733),('5','174','257882','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730734),('5','174','257882','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730735),('5','174','257883','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730736),('5','174','257883','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730737),('5','174','257883','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730738),('5','174','257884','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730739),('5','174','257884','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730740),('5','174','257884','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730741),('5','174','257885','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730742),('5','174','257885','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730743),('5','174','257885','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730744),('5','174','257886','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730745),('5','174','257886','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730746),('5','174','257886','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730747),('5','174','257887','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730748),('5','174','257887','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730749),('5','174','257887','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730750),('5','174','257888','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730751),('5','174','257888','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730752),('5','174','257888','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730753),('5','174','257889','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730754),('5','174','257889','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730755),('5','174','257889','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730756),('5','174','257890','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730757),('5','174','257890','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730758),('5','174','257890','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730759),('5','174','257891','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730760),('5','174','257891','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730761),('5','174','257891','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730762),('5','174','257892','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730763),('5','174','257892','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730764),('5','174','257892','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730765),('5','174','257893','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730766),('5','174','257893','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730767),('5','174','257893','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730768),('5','174','257894','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730769),('5','174','257894','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730770),('5','174','257894','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730771),('5','174','257895','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730772),('5','174','257895','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730773),('5','174','257895','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730774),('5','174','257896','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730775),('5','174','257896','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730776),('5','174','257896','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730777),('5','174','257897','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730778),('5','174','257897','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730779),('5','174','257897','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730780),('5','174','257898','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730781),('5','174','257898','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730782),('5','174','257898','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730783),('5','174','257899','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730784),('5','174','257899','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730785),('5','174','257899','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730786),('5','174','257903','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730787),('5','174','257903','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730788),('5','174','257903','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730789),('5','174','257904','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730790),('5','174','257904','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730791),('5','174','257904','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730792),('5','174','257905','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730793),('5','174','257905','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730794),('5','174','257905','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730795),('5','174','257906','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730796),('5','174','257906','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730797),('5','174','257906','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730798),('5','174','257915','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730807),('5','174','257915','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730808),('5','174','257915','397',185.00,185.00,3122.58,0.00,0.00,0.00,0.00,730809),('5','174','257925','397',185.00,185.00,7143.48,0.00,0.00,0.00,0.00,730810),('5','174','257925','398',0.00,840.00,0.00,0.00,0.00,0.00,0.00,730811),('5','174','257925','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730812),('5','174','257926','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730813),('5','174','257926','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730814),('5','174','257926','397',185.00,185.00,5314.49,0.00,0.00,0.00,0.00,730815),('5','174','257927','397',185.00,185.00,1124.52,0.00,0.00,0.00,0.00,730816),('5','174','257927','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730817),('5','174','257927','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730818),('5','174','257928','397',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730819),('5','174','257928','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730820),('5','174','257928','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730821),('5','174','257929','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730822),('5','174','257929','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730823),('5','174','257929','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730824),('5','174','257930','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730825),('5','174','257930','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730826),('5','174','257930','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730827),('5','174','257931','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730828),('5','174','257931','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730829),('5','174','257931','397',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730830),('5','174','257932','397',185.00,165.00,5312.81,0.00,0.00,0.00,0.00,730831),('5','174','257932','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730832),('5','174','257932','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730833),('5','174','257933','397',220.00,220.00,8431.40,0.00,0.00,0.00,0.00,730834),('5','174','257933','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730835),('5','174','257933','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730836),('5','174','257934','397',220.00,220.00,7121.86,0.00,0.00,0.00,0.00,730837),('5','174','257934','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730838),('5','174','257934','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730839),('5','174','257935','397',220.00,220.00,7311.46,0.00,0.00,0.00,0.00,730840),('5','174','257935','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730841),('5','174','257935','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730842),('5','174','257936','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730843),('5','174','257936','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730844),('5','174','257936','397',220.00,220.00,1711.47,0.00,0.00,0.00,0.00,730845),('5','174','257937','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730846),('5','174','257937','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730847),('5','174','257937','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730848),('5','174','257938','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730849),('5','174','257938','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730850),('5','174','257938','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730851),('5','174','257939','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730852),('5','174','257939','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730853),('5','174','257939','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730854),('5','174','257940','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730855),('5','174','257940','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730856),('5','174','257940','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730857),('5','174','257941','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730858),('5','174','257941','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730859),('5','174','257941','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730860),('5','174','257942','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730861),('5','174','257942','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730862),('5','174','257942','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730863),('5','174','257943','397',220.00,220.00,3253.87,0.00,0.00,0.00,0.00,730864),('5','174','257943','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730865),('5','174','257943','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730866),('5','174','257944','397',220.00,220.00,9364.36,0.00,0.00,0.00,0.00,730867),('5','174','257944','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730868),('5','174','257944','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730869),('5','174','257945','397',220.00,220.00,8132.05,0.00,0.00,0.00,0.00,730870),('5','174','257945','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730871),('5','174','257945','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730872),('5','174','257946','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730873),('5','174','257946','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730874),('5','174','257946','397',220.00,220.00,7142.13,0.00,0.00,0.00,0.00,730875),('5','174','257947','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730876),('5','174','257947','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730877),('5','174','257947','397',220.00,220.00,2126.78,0.00,0.00,0.00,0.00,730878),('5','174','257948','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730879),('5','174','257948','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730880),('5','174','257948','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730881),('5','174','257949','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730882),('5','174','257949','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730883),('5','174','257949','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730884),('5','174','257950','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730885),('5','174','257950','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730886),('5','174','257950','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730887),('5','174','257951','397',220.00,220.00,3165.09,0.00,0.00,0.00,0.00,730888),('5','174','257951','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730889),('5','174','257951','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730890),('5','174','257952','397',220.00,220.00,8214.01,0.00,0.00,0.00,0.00,730891),('5','174','257952','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730892),('5','174','257952','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730893),('5','174','257953','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730894),('5','174','257953','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730895),('5','174','257953','397',220.00,220.00,3651.00,0.00,0.00,0.00,0.00,730896),('5','174','257954','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730897),('5','174','257954','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730898),('5','174','257954','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730899),('5','174','257955','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730900),('5','174','257955','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730901),('5','174','257955','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730902),('5','174','257956','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730903),('5','174','257956','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730904),('5','174','257956','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730905),('5','174','257957','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730906),('5','174','257957','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730907),('5','174','257957','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730908),('5','174','257958','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730909),('5','174','257958','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730910),('5','174','257958','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730911),('5','174','257959','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730912),('5','174','257959','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730913),('5','174','257959','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730914),('5','174','257960','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730915),('5','174','257960','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730916),('5','174','257960','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730917),('5','174','257961','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730918),('5','174','257961','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730919),('5','174','257961','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730920),('5','174','257962','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730921),('5','174','257962','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730922),('5','174','257962','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730923),('5','174','257963','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730924),('5','174','257963','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730925),('5','174','257963','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730926),('5','174','257964','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730927),('5','174','257964','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730928),('5','174','257964','397',220.00,165.00,0.00,0.00,0.00,0.00,0.00,730929),('5','174','257965','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730930),('5','174','257965','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730931),('5','174','257965','397',220.00,210.00,3345.00,0.00,0.00,0.00,0.00,730932),('5','174','257966','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730933),('5','174','257966','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730934),('5','174','257966','397',210.00,210.00,3143.21,0.00,0.00,0.00,0.00,730935),('5','174','257967','397',210.00,165.00,1237.26,0.00,0.00,0.00,0.00,730936),('5','174','257967','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730937),('5','174','257967','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730938),('5','174','257969','397',210.00,210.00,22652.52,0.00,0.00,0.00,0.00,730941),('5','174','257969','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730942),('5','174','257969','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730943),('5','174','257970','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730944),('5','174','257970','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730945),('5','174','257970','397',210.00,210.00,19699.49,0.00,0.00,0.00,0.00,730946),('5','174','257971','397',210.00,210.00,22251.57,0.00,0.00,0.00,0.00,730947),('5','174','257971','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730948),('5','174','257971','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730949),('5','174','257972','397',210.00,210.00,13100.06,0.00,0.00,0.00,0.00,730950),('5','174','257972','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730951),('5','174','257972','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730952),('5','174','257973','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730953),('5','174','257973','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730954),('5','174','257973','397',210.00,210.00,11374.26,0.00,0.00,0.00,0.00,730955),('5','174','257974','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730956),('5','174','257974','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730957),('5','174','257974','397',210.00,210.00,10462.70,0.00,0.00,0.00,0.00,730958),('5','174','257975','397',210.00,210.00,9624.72,0.00,0.00,0.00,0.00,730959),('5','174','257975','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730960),('5','174','257975','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730961),('5','174','257976','397',210.00,210.00,3666.89,0.00,0.00,0.00,0.00,730962),('5','174','257976','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730963),('5','174','257976','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730964),('5','174','257977','397',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730965),('5','174','257977','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730966),('5','174','257977','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730967),('5','174','257978','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730968),('5','174','257978','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730969),('5','174','257978','397',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730970),('5','174','257979','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730971),('5','174','257979','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730972),('5','174','257979','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730973),('5','174','257980','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730974),('5','174','257980','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730975),('5','174','257980','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730976),('5','174','257981','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730977),('5','174','257981','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730978),('5','174','257981','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730979),('5','174','257982','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730980),('5','174','257982','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730981),('5','174','257982','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730982),('5','174','257983','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730983),('5','174','257983','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730984),('5','174','257983','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730985),('5','174','257984','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730986),('5','174','257984','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730987),('5','174','257984','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730988),('5','174','257985','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730989),('5','174','257985','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730990),('5','174','257985','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730991),('5','174','257986','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730992),('5','174','257986','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730993),('5','174','257986','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730994),('5','174','257987','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730995),('5','174','257987','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730996),('5','174','257987','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,730997),('5','174','257988','399',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730998),('5','174','257988','398',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730999),('5','174','257988','397',210.00,165.00,0.00,0.00,0.00,0.00,0.00,731000);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31072 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (31071,'5','174','241522','2021-11-25 18:58:37','596','397',0.00,8390.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=366 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',365,'174','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=904 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','174','365',899,0,'397','PMS TANK 1',33600.00,1.00,28244.70,'TANKS CONTAINING PETROLEUM PRODUCTS.','596','2021-02-22 18:32:29','2021-03-16 21:10:04','596',5,1),('5','174','365',900,0,'397','PMS TANK 2',33600.00,1.00,14901.15,'TANKS CONTAINING PETROLEUM PRODUCTS.','596','2021-02-22 18:35:14','2021-02-22 18:35:14','596',5,1),('5','174','365',901,0,'397','PMS TANK 3',33600.00,1.00,195.79,'TANKS CONTAINING PETROLEUM PRODUCTS.','596','2021-02-22 18:36:56','2021-02-22 18:36:56','596',5,1),('5','174','365',902,0,'398','DPK TANK',33600.00,1.00,0.00,'TANKS CONTAINING PETROLEUM PRODUCT.','596','2021-02-22 18:38:37','2021-02-22 18:38:37','596',5,1),('5','174','365',903,0,'399','AGO TANK',34000.00,1.00,8061.75,'TANKS CONTAINING PETROLEUM PRODUCT.','596','2021-02-22 18:39:54','2021-02-22 18:39:54','596',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','174',903,143.38,'2023-03-20 12:48:21'),(2,'5','174',902,0.00,'2023-03-20 12:48:21'),(3,'5','174',901,216.29,'2023-03-20 12:48:21'),(4,'5','174',900,1387.26,'2023-03-20 12:48:21'),(5,'5','174',899,414.82,'2023-03-20 12:48:21');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2641605 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2112154,'5','174','903',399,'Sale Id shift 242712',0.00,0.00,0.00,792.87,0.00,'2021-12-01 10:15:00','',''),(2112155,'5','174',NULL,399,'Sale Id shift 242712',273540.15,0.00,0.00,0.00,0.00,'2021-12-01 10:15:00','',''),(2121665,'5','174','903',399,'Sale Id shift 243019',0.00,0.00,0.00,461.41,0.00,'2021-12-02 07:20:18','',''),(2121666,'5','174',NULL,399,'Sale Id shift 243019',159186.45,0.00,0.00,0.00,0.00,'2021-12-02 07:20:18','',''),(2134491,'5','174','903',399,'Sale Id shift 243180',0.00,0.00,0.00,725.41,0.00,'2021-12-03 06:47:04','',''),(2134492,'5','174',NULL,399,'Sale Id shift 243180',250266.45,0.00,0.00,0.00,0.00,'2021-12-03 06:47:04','',''),(2147473,'5','174','903',399,'Sale Id shift 243414',0.00,0.00,0.00,697.40,0.00,'2021-12-04 06:55:33','',''),(2147474,'5','174',NULL,399,'Sale Id shift 243414',240603.00,0.00,0.00,0.00,0.00,'2021-12-04 06:55:33','',''),(2161898,'5','174','903',399,'Sale Id shift 243639',0.00,0.00,0.00,443.74,0.00,'2021-12-05 05:45:20','',''),(2161899,'5','174',NULL,399,'Sale Id shift 243639',153090.30,0.00,0.00,0.00,0.00,'2021-12-05 05:45:20','',''),(2174960,'5','174','903',399,'Sale Id shift 243888',0.00,0.00,0.00,333.90,0.00,'2021-12-06 06:29:20','',''),(2174961,'5','174',NULL,399,'Sale Id shift 243888',115195.50,0.00,0.00,0.00,0.00,'2021-12-06 06:29:20','',''),(2187802,'5','174','903',399,'Sale Id shift 244120',0.00,0.00,0.00,651.89,0.00,'2021-12-07 06:51:43','',''),(2187803,'5','174',NULL,399,'Sale Id shift 244120',224902.05,0.00,0.00,0.00,0.00,'2021-12-07 06:51:43','',''),(2197584,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2021-12-07 16:19:41','',''),(2199224,'5','174',NULL,397,'Reception corrector for bridging 126486',0.00,0.00,0.00,15000.00,0.00,'2021-12-07 18:52:53','',''),(2199225,'5','174','899',397,'Received from bridging 126486',0.00,0.00,15000.00,0.00,0.00,'2021-12-07 18:52:53','',''),(2200699,'5','174','899',397,'Sale Id shift 244332',0.00,0.00,0.00,4456.11,0.00,'2021-12-08 07:17:37','',''),(2200700,'5','174','899',397,'Sale Id shift 244332',0.00,0.00,0.00,3579.23,0.00,'2021-12-08 07:17:37','',''),(2200701,'5','174','903',399,'Sale Id shift 244332',0.00,0.00,0.00,641.60,0.00,'2021-12-08 07:17:37','',''),(2200702,'5','174',NULL,397,'Sale Id shift 244332',1325831.10,0.00,0.00,0.00,0.00,'2021-12-08 07:17:37','',''),(2200703,'5','174',NULL,399,'Sale Id shift 244332',221352.00,0.00,0.00,0.00,0.00,'2021-12-08 07:17:37','',''),(2211778,'5','174','899',397,'Sale Id shift 244699',0.00,0.00,0.00,3064.67,0.00,'2021-12-09 05:41:36','',''),(2211779,'5','174','899',397,'Sale Id shift 244699',0.00,0.00,0.00,2802.04,0.00,'2021-12-09 05:41:36','',''),(2211780,'5','174','903',399,'Sale Id shift 244699',0.00,0.00,0.00,618.13,0.00,'2021-12-09 05:41:36','',''),(2211781,'5','174',NULL,397,'Sale Id shift 244699',968007.15,0.00,0.00,0.00,0.00,'2021-12-09 05:41:36','',''),(2211782,'5','174',NULL,399,'Sale Id shift 244699',213254.85,0.00,0.00,0.00,0.00,'2021-12-09 05:41:36','',''),(2225184,'5','174','899',397,'Sale Id shift 244909',0.00,0.00,0.00,824.99,0.00,'2021-12-10 06:15:28','',''),(2225185,'5','174','899',397,'Sale Id shift 244909',0.00,0.00,0.00,274.92,0.00,'2021-12-10 06:15:28','',''),(2225186,'5','174','903',399,'Sale Id shift 244909',0.00,0.00,0.00,453.61,0.00,'2021-12-10 06:15:28','',''),(2225187,'5','174',NULL,397,'Sale Id shift 244909',181485.15,0.00,0.00,0.00,0.00,'2021-12-10 06:15:28','',''),(2225188,'5','174',NULL,399,'Sale Id shift 244909',156495.45,0.00,0.00,0.00,0.00,'2021-12-10 06:15:28','',''),(2239201,'5','174','903',399,'Sale Id shift 245153',0.00,0.00,0.00,256.37,0.00,'2021-12-11 06:59:31','',''),(2239202,'5','174',NULL,399,'Sale Id shift 245153',88447.65,0.00,0.00,0.00,0.00,'2021-12-11 06:59:31','',''),(2265293,'5','174','903',399,'Sale Id shift 245258',0.00,0.00,0.00,704.16,0.00,'2021-12-13 05:58:45','',''),(2265294,'5','174',NULL,399,'Sale Id shift 245258',242935.20,0.00,0.00,0.00,0.00,'2021-12-13 05:58:45','',''),(2269636,'5','174','903',399,'Sale Id shift 245761',0.00,0.00,0.00,217.46,0.00,'2021-12-13 10:44:12','',''),(2269637,'5','174',NULL,399,'Sale Id shift 245761',75023.70,0.00,0.00,0.00,0.00,'2021-12-13 10:44:12','',''),(2277944,'5','174','903',399,'Sale Id shift 245777',0.00,0.00,0.00,349.62,0.00,'2021-12-14 07:14:41','',''),(2277945,'5','174',NULL,399,'Sale Id shift 245777',120618.90,0.00,0.00,0.00,0.00,'2021-12-14 07:14:41','',''),(2285405,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2310000.00,14000.00,0.00,0.00,'2021-12-14 20:00:04','',''),(2285482,'5','174',NULL,397,'Reception corrector for bridging 127414',0.00,0.00,0.00,14000.00,0.00,'2021-12-14 20:58:54','',''),(2285483,'5','174','899',397,'Received from bridging 127414',0.00,0.00,14000.00,0.00,0.00,'2021-12-14 20:58:54','',''),(2286151,'5','174','903',399,'Sale Id shift 246003',0.00,0.00,0.00,106.94,0.00,'2021-12-15 06:39:10','',''),(2286152,'5','174',NULL,399,'Sale Id shift 246003',36894.30,0.00,0.00,0.00,0.00,'2021-12-15 06:39:10','',''),(2293376,'5','174','899',397,'Sale Id shift 246270',0.00,0.00,0.00,2783.47,0.00,'2021-12-16 06:50:51','',''),(2293377,'5','174','899',397,'Sale Id shift 246270',0.00,0.00,0.00,1831.57,0.00,'2021-12-16 06:50:51','',''),(2293378,'5','174','903',399,'Sale Id shift 246270',0.00,0.00,0.00,60.19,0.00,'2021-12-16 06:50:51','',''),(2293379,'5','174',NULL,397,'Sale Id shift 246270',761481.60,0.00,0.00,0.00,0.00,'2021-12-16 06:50:51','',''),(2293380,'5','174',NULL,399,'Sale Id shift 246270',20765.55,0.00,0.00,0.00,0.00,'2021-12-16 06:50:51','',''),(2301306,'5','174','899',397,'Sale Id shift 246524',0.00,0.00,0.00,2251.22,0.00,'2021-12-17 06:10:43','',''),(2301307,'5','174','899',397,'Sale Id shift 246524',0.00,0.00,0.00,2156.84,0.00,'2021-12-17 06:10:43','',''),(2301308,'5','174',NULL,397,'Sale Id shift 246524',727329.90,0.00,0.00,0.00,0.00,'2021-12-17 06:10:43','',''),(2309506,'5','174','899',397,'Sale Id shift 246783',0.00,0.00,0.00,2407.20,0.00,'2021-12-18 07:02:54','',''),(2309507,'5','174','899',397,'Sale Id shift 246783',0.00,0.00,0.00,1805.35,0.00,'2021-12-18 07:02:54','',''),(2309508,'5','174',NULL,397,'Sale Id shift 246783',695070.75,0.00,0.00,0.00,0.00,'2021-12-18 07:02:54','',''),(2318388,'5','174','899',397,'Sale Id shift 247027',0.00,0.00,0.00,739.42,0.00,'2021-12-19 07:12:09','',''),(2318389,'5','174','899',397,'Sale Id shift 247027',0.00,0.00,0.00,43.36,0.00,'2021-12-19 07:12:09','',''),(2318390,'5','174',NULL,397,'Sale Id shift 247027',129158.70,0.00,0.00,0.00,0.00,'2021-12-19 07:12:09','',''),(2342052,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2128500.00,12900.00,0.00,0.00,'2021-12-22 07:35:30','',''),(2342875,'5','174',NULL,397,'Reception corrector for bridging 128294',0.00,0.00,0.00,12900.00,0.00,'2021-12-22 08:28:24','',''),(2342876,'5','174','899',397,'Received from bridging 128294',0.00,0.00,12900.00,0.00,0.00,'2021-12-22 08:28:24','',''),(2349649,'5','174','899',397,'Sale Id shift 247929',0.00,0.00,0.00,3650.99,0.00,'2021-12-23 06:29:23','',''),(2349650,'5','174',NULL,397,'Sale Id shift 247929',602413.35,0.00,0.00,0.00,0.00,'2021-12-23 06:29:23','',''),(2359058,'5','174','899',397,'Sale Id shift 248216',0.00,0.00,0.00,2470.36,0.00,'2021-12-24 07:20:08','',''),(2359059,'5','174','899',397,'Sale Id shift 248216',0.00,0.00,0.00,1394.85,0.00,'2021-12-24 07:20:08','',''),(2359060,'5','174',NULL,397,'Sale Id shift 248216',637759.65,0.00,0.00,0.00,0.00,'2021-12-24 07:20:08','',''),(2373021,'5','174','899',397,'Sale Id shift 248473',0.00,0.00,0.00,50.41,0.00,'2021-12-25 14:08:22','',''),(2373022,'5','174','899',397,'Sale Id shift 248473',0.00,0.00,0.00,5352.64,0.00,'2021-12-25 14:08:22','',''),(2373023,'5','174',NULL,397,'Sale Id shift 248473',891503.25,0.00,0.00,0.00,0.00,'2021-12-25 14:08:22','',''),(2373069,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7375500.00,44700.00,0.00,0.00,'2021-12-25 14:11:23','',''),(2377652,'5','174',NULL,397,'Reception corrector for bridging 128777',0.00,0.00,0.00,22500.00,0.00,'2021-12-26 12:01:28','',''),(2377653,'5','174','899',397,'Received from bridging 128777',0.00,0.00,22500.00,0.00,0.00,'2021-12-26 12:01:28','',''),(2377658,'5','174',NULL,397,'Reception corrector for bridging 128778',0.00,0.00,0.00,22200.00,0.00,'2021-12-26 12:01:50','',''),(2377659,'5','174','900',397,'Received from bridging 128778',0.00,0.00,22200.00,0.00,0.00,'2021-12-26 12:01:50','',''),(2379835,'5','174','899',397,'Sale Id shift 248784',0.00,0.00,0.00,3673.20,0.00,'2021-12-26 16:46:55','',''),(2379836,'5','174','899',397,'Sale Id shift 248784',0.00,0.00,0.00,71.72,0.00,'2021-12-26 16:46:55','',''),(2379837,'5','174','900',397,'Sale Id shift 248784',0.00,0.00,0.00,1869.83,0.00,'2021-12-26 16:46:55','',''),(2379838,'5','174',NULL,397,'Sale Id shift 248784',926433.75,0.00,0.00,0.00,0.00,'2021-12-26 16:46:55','',''),(2381007,'5','174','899',397,'Sale Id shift 249030',0.00,0.00,0.00,3969.03,0.00,'2021-12-27 07:40:47','',''),(2381008,'5','174','900',397,'Sale Id shift 249030',0.00,0.00,0.00,3020.76,0.00,'2021-12-27 07:40:47','',''),(2381009,'5','174',NULL,397,'Sale Id shift 249030',1153315.35,0.00,0.00,0.00,0.00,'2021-12-27 07:40:47','',''),(2386991,'5','174','899',397,'Sale Id shift 249162',0.00,0.00,0.00,2682.52,0.00,'2021-12-28 07:35:22','',''),(2386992,'5','174','900',397,'Sale Id shift 249162',0.00,0.00,0.00,3549.78,0.00,'2021-12-28 07:35:22','',''),(2386993,'5','174',NULL,397,'Sale Id shift 249162',1028329.50,0.00,0.00,0.00,0.00,'2021-12-28 07:35:22','',''),(2393518,'5','174','899',397,'Sale Id shift 249394',0.00,0.00,0.00,2969.80,0.00,'2021-12-29 06:45:21','',''),(2393519,'5','174','900',397,'Sale Id shift 249394',0.00,0.00,0.00,2626.83,0.00,'2021-12-29 06:45:21','',''),(2393520,'5','174',NULL,397,'Sale Id shift 249394',923443.95,0.00,0.00,0.00,0.00,'2021-12-29 06:45:21','',''),(2400377,'5','174','899',397,'Sale Id shift 249696',0.00,0.00,0.00,3421.25,0.00,'2021-12-30 06:56:48','',''),(2400378,'5','174','900',397,'Sale Id shift 249696',0.00,0.00,0.00,3095.02,0.00,'2021-12-30 06:56:48','',''),(2400379,'5','174',NULL,397,'Sale Id shift 249696',1075184.55,0.00,0.00,0.00,0.00,'2021-12-30 06:56:48','',''),(2407544,'5','174','899',397,'Sale Id shift 249945',0.00,0.00,0.00,1522.48,0.00,'2021-12-31 06:46:41','',''),(2407545,'5','174','900',397,'Sale Id shift 249945',0.00,0.00,0.00,3031.48,0.00,'2021-12-31 06:46:41','',''),(2407546,'5','174',NULL,397,'Sale Id shift 249945',751403.40,0.00,0.00,0.00,0.00,'2021-12-31 06:46:41','',''),(2415175,'5','174','899',397,'Sale Id shift 250189',0.00,0.00,0.00,3418.44,0.00,'2022-01-01 07:49:14','',''),(2415176,'5','174','899',397,'Sale Id shift 250189',0.00,0.00,0.00,477.54,0.00,'2022-01-01 07:49:14','',''),(2415177,'5','174',NULL,397,'Sale Id shift 250189',642836.70,0.00,0.00,0.00,0.00,'2022-01-01 07:49:14','',''),(2420550,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3597000.00,21800.00,0.00,0.00,'2022-01-01 22:17:37','',''),(2420840,'5','174','900',397,'Sale Id shift 250509',0.00,0.00,0.00,5017.17,0.00,'2022-01-02 06:44:41','',''),(2420841,'5','174',NULL,397,'Sale Id shift 250509',827833.05,0.00,0.00,0.00,0.00,'2022-01-02 06:44:41','',''),(2426411,'5','174',NULL,397,'Reception corrector for bridging 129517',0.00,0.00,0.00,21800.00,0.00,'2022-01-03 06:19:41','',''),(2426412,'5','174','899',397,'Received from bridging 129517',0.00,0.00,21800.00,0.00,0.00,'2022-01-03 06:19:41','',''),(2430879,'5','174','899',397,'Sale Id shift 250931',0.00,0.00,0.00,353.84,0.00,'2022-01-03 14:53:24','',''),(2430880,'5','174','899',397,'Sale Id shift 250931',0.00,0.00,0.00,5062.43,0.00,'2022-01-03 14:53:24','',''),(2430881,'5','174',NULL,397,'Sale Id shift 250931',893684.55,0.00,0.00,0.00,0.00,'2022-01-03 14:53:24','',''),(2433249,'5','174','899',397,'Sale Id shift 250944',0.00,0.00,0.00,462.19,0.00,'2022-01-04 07:04:39','',''),(2433250,'5','174','899',397,'Sale Id shift 250944',0.00,0.00,0.00,4663.98,0.00,'2022-01-04 07:04:39','',''),(2433251,'5','174',NULL,397,'Sale Id shift 250944',845818.05,0.00,0.00,0.00,0.00,'2022-01-04 07:04:39','',''),(2440905,'5','174','899',397,'Sale Id shift 251183',0.00,0.00,0.00,2697.18,0.00,'2022-01-05 07:34:30','',''),(2440906,'5','174','899',397,'Sale Id shift 251183',0.00,0.00,0.00,5605.78,0.00,'2022-01-05 07:34:30','',''),(2440907,'5','174',NULL,397,'Sale Id shift 251183',1369988.40,0.00,0.00,0.00,0.00,'2022-01-05 07:34:30','',''),(2445957,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6542250.00,39650.00,0.00,0.00,'2022-01-05 16:14:53','',''),(2447518,'5','174',NULL,397,'Reception corrector for bridging 129868',0.00,0.00,0.00,13400.00,0.00,'2022-01-05 18:53:28','',''),(2447519,'5','174','899',397,'Received from bridging 129868',0.00,0.00,13400.00,0.00,0.00,'2022-01-05 18:53:28','',''),(2447522,'5','174',NULL,397,'Reception corrector for bridging 129869',0.00,0.00,0.00,26250.00,0.00,'2022-01-05 18:53:44','',''),(2447523,'5','174','900',397,'Received from bridging 129869',0.00,0.00,26250.00,0.00,0.00,'2022-01-05 18:53:44','',''),(2448362,'5','174','899',397,'Sale Id shift 251305',0.00,0.00,0.00,4834.66,0.00,'2022-01-06 07:46:57','',''),(2448363,'5','174','900',397,'Sale Id shift 251305',0.00,0.00,0.00,3735.32,0.00,'2022-01-06 07:46:57','',''),(2448364,'5','174',NULL,397,'Sale Id shift 251305',1414046.70,0.00,0.00,0.00,0.00,'2022-01-06 07:46:57','',''),(2456943,'5','174','899',397,'Sale Id shift 251537',0.00,0.00,0.00,4182.26,0.00,'2022-01-07 09:08:14','',''),(2456944,'5','174','900',397,'Sale Id shift 251537',0.00,0.00,0.00,3297.31,0.00,'2022-01-07 09:08:14','',''),(2456945,'5','174',NULL,397,'Sale Id shift 251537',1234129.05,0.00,0.00,0.00,0.00,'2022-01-07 09:08:14','',''),(2463397,'5','174','899',397,'Sale Id shift 251846',0.00,0.00,0.00,3394.14,0.00,'2022-01-08 07:57:53','',''),(2463398,'5','174','899',397,'Sale Id shift 251846',0.00,0.00,0.00,581.87,0.00,'2022-01-08 07:57:53','',''),(2463399,'5','174','900',397,'Sale Id shift 251846',0.00,0.00,0.00,2876.40,0.00,'2022-01-08 07:57:53','',''),(2463400,'5','174',NULL,397,'Sale Id shift 251846',1130647.65,0.00,0.00,0.00,0.00,'2022-01-08 07:57:53','',''),(2470996,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,3721.85,0.00,'2022-01-08 19:22:56','',''),(2470997,'5','174','899',0,'Inventory adjustment from tank dipping to 3800',0.00,0.00,3800.00,0.00,0.00,'2022-01-08 19:22:56','',''),(2471740,'5','174','899',397,'Sale Id shift 252047',0.00,0.00,0.00,3763.12,0.00,'2022-01-09 08:02:14','',''),(2471741,'5','174','899',397,'Sale Id shift 252047',0.00,0.00,0.00,22.74,0.00,'2022-01-09 08:02:14','',''),(2471742,'5','174','900',397,'Sale Id shift 252047',0.00,0.00,0.00,4264.01,0.00,'2022-01-09 08:02:14','',''),(2471743,'5','174',NULL,397,'Sale Id shift 252047',1328228.55,0.00,0.00,0.00,0.00,'2022-01-09 08:02:14','',''),(2479478,'5','174','900',397,'Sale Id shift 252297',0.00,0.00,0.00,5813.60,0.00,'2022-01-10 07:01:43','',''),(2479479,'5','174',NULL,397,'Sale Id shift 252297',959244.00,0.00,0.00,0.00,0.00,'2022-01-10 07:01:43','',''),(2486076,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-01-10 20:42:23','',''),(2488358,'5','174',NULL,397,'Reception corrector for bridging 130399',0.00,0.00,0.00,22500.00,0.00,'2022-01-11 10:31:48','',''),(2488359,'5','174','899',397,'Received from bridging 130399',0.00,0.00,22500.00,0.00,0.00,'2022-01-11 10:31:48','',''),(2488361,'5','174',NULL,397,'Reception corrector for bridging 130400',0.00,0.00,0.00,22500.00,0.00,'2022-01-11 10:31:58','',''),(2488362,'5','174','900',397,'Received from bridging 130400',0.00,0.00,22500.00,0.00,0.00,'2022-01-11 10:31:58','',''),(2488655,'5','174','899',397,'Sale Id shift 252559',0.00,0.00,0.00,136.65,0.00,'2022-01-11 10:59:56','',''),(2488656,'5','174','899',397,'Sale Id shift 252559',0.00,0.00,0.00,39.76,0.00,'2022-01-11 10:59:56','',''),(2488657,'5','174','900',397,'Sale Id shift 252559',0.00,0.00,0.00,6606.65,0.00,'2022-01-11 10:59:56','',''),(2488658,'5','174',NULL,397,'Sale Id shift 252559',1119204.90,0.00,0.00,0.00,0.00,'2022-01-11 10:59:56','',''),(2494239,'5','174','899',397,'Sale Id shift 252819',0.00,0.00,0.00,4912.40,0.00,'2022-01-12 07:49:18','',''),(2494240,'5','174','900',397,'Sale Id shift 252819',0.00,0.00,0.00,4483.31,0.00,'2022-01-12 07:49:18','',''),(2494241,'5','174',NULL,397,'Sale Id shift 252819',1550292.15,0.00,0.00,0.00,0.00,'2022-01-12 07:49:18','',''),(2501752,'5','174','899',397,'Sale Id shift 253062',0.00,0.00,0.00,3043.89,0.00,'2022-01-13 07:34:46','',''),(2501753,'5','174','899',397,'Sale Id shift 253062',0.00,0.00,0.00,938.77,0.00,'2022-01-13 07:34:46','',''),(2501754,'5','174','900',397,'Sale Id shift 253062',0.00,0.00,0.00,1920.08,0.00,'2022-01-13 07:34:46','',''),(2501755,'5','174',NULL,397,'Sale Id shift 253062',973952.10,0.00,0.00,0.00,0.00,'2022-01-13 07:34:46','',''),(2510693,'5','174','899',397,'Sale Id shift 253337',0.00,0.00,0.00,3154.98,0.00,'2022-01-14 09:32:47','',''),(2510694,'5','174','899',397,'Sale Id shift 253337',0.00,0.00,0.00,1429.54,0.00,'2022-01-14 09:32:47','',''),(2510695,'5','174','900',397,'Sale Id shift 253337',0.00,0.00,0.00,2056.45,0.00,'2022-01-14 09:32:47','',''),(2510696,'5','174',NULL,397,'Sale Id shift 253337',1095760.05,0.00,0.00,0.00,0.00,'2022-01-14 09:32:47','',''),(2516804,'5','174','899',397,'Sale Id shift 253541',0.00,0.00,0.00,2655.06,0.00,'2022-01-15 07:15:06','',''),(2516805,'5','174','899',397,'Sale Id shift 253541',0.00,0.00,0.00,1818.09,0.00,'2022-01-15 07:15:06','',''),(2516806,'5','174','900',397,'Sale Id shift 253541',0.00,0.00,0.00,2055.68,0.00,'2022-01-15 07:15:06','',''),(2516807,'5','174',NULL,397,'Sale Id shift 253541',1077256.95,0.00,0.00,0.00,0.00,'2022-01-15 07:15:06','',''),(2525381,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,4385.00,0.00,'2022-01-15 20:38:41','',''),(2525382,'5','174','899',0,'Inventory adjustment from tank dipping to 4700',0.00,0.00,4700.00,0.00,0.00,'2022-01-15 20:38:41','',''),(2525785,'5','174','899',397,'Sale Id shift 253735',0.00,0.00,0.00,2784.88,0.00,'2022-01-16 07:10:18','',''),(2525786,'5','174','899',397,'Sale Id shift 253735',0.00,0.00,0.00,1836.24,0.00,'2022-01-16 07:10:18','',''),(2525787,'5','174','900',397,'Sale Id shift 253735',0.00,0.00,0.00,2257.24,0.00,'2022-01-16 07:10:18','',''),(2525788,'5','174',NULL,397,'Sale Id shift 253735',1134929.40,0.00,0.00,0.00,0.00,'2022-01-16 07:10:18','',''),(2534151,'5','174','900',397,'Sale Id shift 254003',0.00,0.00,0.00,5294.55,0.00,'2022-01-17 07:13:22','',''),(2534152,'5','174',NULL,397,'Sale Id shift 254003',873600.75,0.00,0.00,0.00,0.00,'2022-01-17 07:13:22','',''),(2541571,'5','174','900',397,'Sale Id shift 254216',0.00,0.00,0.00,4059.49,0.00,'2022-01-18 08:38:13','',''),(2541572,'5','174',NULL,397,'Sale Id shift 254216',669815.85,0.00,0.00,0.00,0.00,'2022-01-18 08:38:13','',''),(2563745,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3135000.00,19000.00,0.00,0.00,'2022-01-20 18:26:07','',''),(2563838,'5','174',NULL,397,'Reception corrector for bridging 131525',0.00,0.00,0.00,19000.00,0.00,'2022-01-20 18:46:02','',''),(2563839,'5','174','899',397,'Received from bridging 131525',0.00,0.00,19000.00,0.00,0.00,'2022-01-20 18:46:02','',''),(2564179,'5','174','900',0,'Tank level zero out for dipping',0.00,0.00,0.00,70.71,0.00,'2022-01-20 20:28:11','',''),(2564180,'5','174','900',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-01-20 20:28:11','',''),(2567501,'5','174','899',397,'Sale Id shift 255019',0.00,0.00,0.00,397.21,0.00,'2022-01-21 11:52:36','',''),(2567502,'5','174','899',397,'Sale Id shift 255019',0.00,0.00,0.00,609.05,0.00,'2022-01-21 11:52:36','',''),(2567503,'5','174','900',397,'Sale Id shift 255019',0.00,0.00,0.00,200.00,0.00,'2022-01-21 11:52:36','',''),(2567504,'5','174',NULL,397,'Sale Id shift 255019',199032.90,0.00,0.00,0.00,0.00,'2022-01-21 11:52:36','',''),(2573297,'5','174','899',397,'Sale Id shift 255287',0.00,0.00,0.00,2156.98,0.00,'2022-01-22 08:07:09','',''),(2573298,'5','174','899',397,'Sale Id shift 255287',0.00,0.00,0.00,4767.59,0.00,'2022-01-22 08:07:09','',''),(2573299,'5','174',NULL,397,'Sale Id shift 255287',1142554.05,0.00,0.00,0.00,0.00,'2022-01-22 08:07:09','',''),(2581863,'5','174','899',397,'Sale Id shift 255514',0.00,0.00,0.00,4573.13,0.00,'2022-01-23 07:22:40','',''),(2581864,'5','174','899',397,'Sale Id shift 255514',0.00,0.00,0.00,884.62,0.00,'2022-01-23 07:22:40','',''),(2581865,'5','174',NULL,397,'Sale Id shift 255514',900528.75,0.00,0.00,0.00,0.00,'2022-01-23 07:22:40','',''),(2590572,'5','174','899',397,'Sale Id shift 255759',0.00,0.00,0.00,3021.07,0.00,'2022-01-24 08:32:16','',''),(2590573,'5','174','899',397,'Sale Id shift 255759',0.00,0.00,0.00,1971.71,0.00,'2022-01-24 08:32:16','',''),(2590574,'5','174',NULL,397,'Sale Id shift 255759',823808.70,0.00,0.00,0.00,0.00,'2022-01-24 08:32:16','',''),(2596831,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,697.52,0.00,'2022-01-24 22:03:31','',''),(2596832,'5','174','899',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-01-24 22:03:31','',''),(2597130,'5','174','899',397,'Sale Id shift 256001',0.00,0.00,0.00,493.39,0.00,'2022-01-25 07:32:11','',''),(2597131,'5','174','899',397,'Sale Id shift 256001',0.00,0.00,0.00,636.81,0.00,'2022-01-25 07:32:11','',''),(2597132,'5','174',NULL,397,'Sale Id shift 256001',186483.00,0.00,0.00,0.00,0.00,'2022-01-25 07:32:11','',''),(2612745,'5','174',NULL,399,'Balance from closing inventory values 2021-11-31 23:59:59',2567777.65,5151000.00,30110.00,22647.40,0.00,'2021-11-30 23:59:59','',''),(2612853,'5','174',NULL,398,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613129,'5','174',NULL,397,'Balance from closing inventory values 2021-11-31 23:59:59',53349544.62,52916645.00,644950.00,647570.46,0.00,'2021-11-30 23:59:59','',''),(2613222,'5','174','901',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,23438.00,23437.77,0.00,'2021-11-30 23:59:59','',''),(2613626,'5','174','902',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613756,'5','174','899',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,251670.00,251564.20,0.00,'2021-11-30 23:59:59','',''),(2613780,'5','174','900',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,70400.00,70348.33,0.00,'2021-11-30 23:59:59','',''),(2613885,'5','174','903',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,15575.00,7916.92,0.00,'2021-11-30 23:59:59','',''),(2639321,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3663000.00,22200.00,0.00,0.00,'2022-01-29 17:59:14','',''),(2640155,'5','174',NULL,397,'Reception corrector for bridging 132569',0.00,0.00,0.00,22200.00,0.00,'2022-01-29 19:27:39','',''),(2640156,'5','174','899',397,'Received from bridging 132569',0.00,0.00,22200.00,0.00,0.00,'2022-01-29 19:27:39','',''),(2640850,'5','174','899',397,'Sale Id shift 257286',0.00,0.00,0.00,50.00,0.00,'2022-01-30 07:43:30','',''),(2640851,'5','174','899',397,'Sale Id shift 257286',0.00,0.00,0.00,1870.14,0.00,'2022-01-30 07:43:30','',''),(2640852,'5','174',NULL,397,'Sale Id shift 257286',316823.10,0.00,0.00,0.00,0.00,'2022-01-30 07:43:30','',''),(2640853,'5','174','899',397,'Sale Id shift 257545',0.00,0.00,0.00,224.02,0.00,'2022-01-31 09:32:39','',''),(2640854,'5','174','899',397,'Sale Id shift 257545',0.00,0.00,0.00,7352.79,0.00,'2022-01-31 09:32:39','',''),(2640855,'5','174',NULL,397,'Sale Id shift 257545',1250173.65,0.00,0.00,0.00,0.00,'2022-01-31 09:32:39','',''),(2640856,'5','174','899',397,'Sale Id shift 257546',0.00,0.00,0.00,79.34,0.00,'2022-02-01 08:32:21','',''),(2640857,'5','174','899',397,'Sale Id shift 257546',0.00,0.00,0.00,7823.43,0.00,'2022-02-01 08:32:21','',''),(2640858,'5','174',NULL,397,'Sale Id shift 257546',1303957.05,0.00,0.00,0.00,0.00,'2022-02-01 08:32:21','',''),(2640859,'5','174','899',397,'Sale Id shift 257547',0.00,0.00,0.00,4776.33,0.00,'2022-02-02 08:37:04','',''),(2640860,'5','174',NULL,397,'Sale Id shift 257547',788094.45,0.00,0.00,0.00,0.00,'2022-02-02 08:37:04','',''),(2640861,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-02-02 19:29:59','',''),(2640862,'5','174',NULL,397,'Reception corrector for bridging 132570',0.00,0.00,0.00,15000.00,0.00,'2022-02-02 20:35:56','',''),(2640863,'5','174','899',397,'Received from bridging 132570',0.00,0.00,15000.00,0.00,0.00,'2022-02-02 20:35:56','',''),(2640864,'5','174','899',397,'Sale Id shift 257548',0.00,0.00,0.00,23.43,0.00,'2022-02-03 06:43:50','',''),(2640865,'5','174','899',397,'Sale Id shift 257548',0.00,0.00,0.00,1207.95,0.00,'2022-02-03 06:43:50','',''),(2640866,'5','174',NULL,397,'Sale Id shift 257548',203177.70,0.00,0.00,0.00,0.00,'2022-02-03 06:43:50','',''),(2640867,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5197500.00,31500.00,0.00,0.00,'2022-02-03 18:42:38','',''),(2640868,'5','174',NULL,397,'Reception corrector for bridging 132572',0.00,0.00,0.00,13000.00,0.00,'2022-02-03 21:57:30','',''),(2640869,'5','174','899',397,'Received from bridging 132572',0.00,0.00,13000.00,0.00,0.00,'2022-02-03 21:57:30','',''),(2640870,'5','174',NULL,397,'Reception corrector for bridging 132573',0.00,0.00,0.00,18500.00,0.00,'2022-02-03 21:57:42','',''),(2640871,'5','174','900',397,'Received from bridging 132573',0.00,0.00,18500.00,0.00,0.00,'2022-02-03 21:57:42','',''),(2640872,'5','174','899',397,'Sale Id shift 257549',0.00,0.00,0.00,3649.52,0.00,'2022-02-04 09:12:34','',''),(2640873,'5','174','900',397,'Sale Id shift 257549',0.00,0.00,0.00,737.06,0.00,'2022-02-04 09:12:34','',''),(2640874,'5','174',NULL,397,'Sale Id shift 257549',723785.70,0.00,0.00,0.00,0.00,'2022-02-04 09:12:34','',''),(2640875,'5','174','899',397,'Sale Id shift 257550',0.00,0.00,0.00,4144.29,0.00,'2022-02-05 07:53:49','',''),(2640876,'5','174','900',397,'Sale Id shift 257550',0.00,0.00,0.00,3540.06,0.00,'2022-02-05 07:53:49','',''),(2640877,'5','174',NULL,397,'Sale Id shift 257550',1267917.75,0.00,0.00,0.00,0.00,'2022-02-05 07:53:49','',''),(2640878,'5','174','899',397,'Sale Id shift 257551',0.00,0.00,0.00,228.93,0.00,'2022-02-06 07:49:38','',''),(2640879,'5','174','899',397,'Sale Id shift 257551',0.00,0.00,0.00,4556.79,0.00,'2022-02-06 07:49:38','',''),(2640880,'5','174','900',397,'Sale Id shift 257551',0.00,0.00,0.00,4289.00,0.00,'2022-02-06 07:49:38','',''),(2640881,'5','174',NULL,397,'Sale Id shift 257551',1497328.80,0.00,0.00,0.00,0.00,'2022-02-06 07:49:38','',''),(2640882,'5','174','899',397,'Sale Id shift 257552',0.00,0.00,0.00,2.36,0.00,'2022-02-07 07:18:46','',''),(2640883,'5','174','899',397,'Sale Id shift 257552',0.00,0.00,0.00,1644.36,0.00,'2022-02-07 07:18:46','',''),(2640884,'5','174','900',397,'Sale Id shift 257552',0.00,0.00,0.00,4872.05,0.00,'2022-02-07 07:18:46','',''),(2640885,'5','174',NULL,397,'Sale Id shift 257552',1075597.05,0.00,0.00,0.00,0.00,'2022-02-07 07:18:46','',''),(2640886,'5','174','900',0,'Tank level zero out for dipping',0.00,0.00,0.00,5061.83,0.00,'2022-02-07 20:33:04','',''),(2640887,'5','174','900',0,'Inventory adjustment from tank dipping to 5110',0.00,0.00,5110.00,0.00,0.00,'2022-02-07 20:33:04','',''),(2640888,'5','174','899',397,'Sale Id shift 257553',0.00,0.00,0.00,489.37,0.00,'2022-02-08 07:44:42','',''),(2640889,'5','174','899',397,'Sale Id shift 257553',0.00,0.00,0.00,2263.70,0.00,'2022-02-08 07:44:42','',''),(2640890,'5','174','900',397,'Sale Id shift 257553',0.00,0.00,0.00,5109.64,0.00,'2022-02-08 07:44:42','',''),(2640891,'5','174',NULL,397,'Sale Id shift 257553',1297347.15,0.00,0.00,0.00,0.00,'2022-02-08 07:44:42','',''),(2640892,'5','174','899',397,'Sale Id shift 257554',0.00,0.00,0.00,6412.68,0.00,'2022-02-09 08:21:27','',''),(2640893,'5','174',NULL,397,'Sale Id shift 257554',1058092.20,0.00,0.00,0.00,0.00,'2022-02-09 08:21:27','',''),(2640894,'5','174','899',397,'Sale Id shift 257555',0.00,0.00,0.00,3110.09,0.00,'2022-02-10 08:05:02','',''),(2640895,'5','174',NULL,397,'Sale Id shift 257555',513164.85,0.00,0.00,0.00,0.00,'2022-02-10 08:05:02','',''),(2640896,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-14 16:06:12','',''),(2640897,'5','174',NULL,397,'Reception corrector for bridging 132575',0.00,0.00,0.00,15000.00,0.00,'2022-02-14 17:52:51','',''),(2640898,'5','174','900',397,'Received from bridging 132575',0.00,0.00,15000.00,0.00,0.00,'2022-02-14 17:52:51','',''),(2640899,'5','174',NULL,397,'Reception corrector for bridging 132574',0.00,0.00,0.00,15000.00,0.00,'2022-02-14 17:53:03','',''),(2640900,'5','174','899',397,'Received from bridging 132574',0.00,0.00,15000.00,0.00,0.00,'2022-02-14 17:53:03','',''),(2640901,'5','174','899',397,'Sale Id shift 257560',0.00,0.00,0.00,1365.76,0.00,'2022-02-15 08:12:44','',''),(2640902,'5','174','899',397,'Sale Id shift 257560',0.00,0.00,0.00,611.04,0.00,'2022-02-15 08:12:44','',''),(2640903,'5','174','900',397,'Sale Id shift 257560',0.00,0.00,0.00,234.33,0.00,'2022-02-15 08:12:44','',''),(2640904,'5','174',NULL,397,'Sale Id shift 257560',364836.45,0.00,0.00,0.00,0.00,'2022-02-15 08:12:44','',''),(2640905,'5','174','899',397,'Sale Id shift 257561',0.00,0.00,0.00,4392.31,0.00,'2022-02-16 07:34:28','',''),(2640906,'5','174','900',397,'Sale Id shift 257561',0.00,0.00,0.00,6919.42,0.00,'2022-02-16 07:34:28','',''),(2640907,'5','174',NULL,397,'Sale Id shift 257561',1866435.45,0.00,0.00,0.00,0.00,'2022-02-16 07:34:28','',''),(2640908,'5','174','899',397,'Sale Id shift 257562',0.00,0.00,0.00,3051.70,0.00,'2022-02-17 07:11:27','',''),(2640909,'5','174','899',397,'Sale Id shift 257562',0.00,0.00,0.00,5812.32,0.00,'2022-02-17 07:11:27','',''),(2640910,'5','174','900',397,'Sale Id shift 257562',0.00,0.00,0.00,670.64,0.00,'2022-02-17 07:11:27','',''),(2640911,'5','174',NULL,397,'Sale Id shift 257562',1573218.90,0.00,0.00,0.00,0.00,'2022-02-17 07:11:27','',''),(2640912,'5','174','900',397,'Sale Id shift 257563',0.00,0.00,0.00,6022.24,0.00,'2022-02-18 07:25:46','',''),(2640913,'5','174',NULL,397,'Sale Id shift 257563',993669.60,0.00,0.00,0.00,0.00,'2022-02-18 07:25:46','',''),(2640914,'5','174','900',397,'Sale Id shift 257564',0.00,0.00,0.00,969.66,0.00,'2022-02-19 07:37:07','',''),(2640915,'5','174',NULL,397,'Sale Id shift 257564',159993.90,0.00,0.00,0.00,0.00,'2022-02-19 07:37:07','',''),(2640916,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-21 20:17:46','',''),(2640917,'5','174',NULL,397,'Reception corrector for bridging 132576',0.00,0.00,0.00,30000.00,0.00,'2022-02-21 21:36:40','',''),(2640918,'5','174','899',397,'Received from bridging 132576',0.00,0.00,30000.00,0.00,0.00,'2022-02-21 21:36:40','',''),(2640919,'5','174','899',397,'Sale Id shift 257567',0.00,0.00,0.00,732.10,0.00,'2022-02-22 06:46:54','',''),(2640920,'5','174','899',397,'Sale Id shift 257567',0.00,0.00,0.00,1068.41,0.00,'2022-02-22 06:46:54','',''),(2640921,'5','174',NULL,397,'Sale Id shift 257567',297084.15,0.00,0.00,0.00,0.00,'2022-02-22 06:46:54','',''),(2640922,'5','174','899',397,'Sale Id shift 257568',0.00,0.00,0.00,4412.11,0.00,'2022-02-23 07:04:31','',''),(2640923,'5','174','899',397,'Sale Id shift 257568',0.00,0.00,0.00,6901.54,0.00,'2022-02-23 07:04:31','',''),(2640924,'5','174',NULL,397,'Sale Id shift 257568',1866752.25,0.00,0.00,0.00,0.00,'2022-02-23 07:04:31','',''),(2640925,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-02-23 09:14:20','',''),(2640926,'5','174',NULL,397,'Reception corrector for bridging 132577',0.00,0.00,0.00,13500.00,0.00,'2022-02-23 18:39:56','',''),(2640927,'5','174','900',397,'Received from bridging 132577',0.00,0.00,13500.00,0.00,0.00,'2022-02-23 18:39:56','',''),(2640928,'5','174','899',397,'Sale Id shift 257569',0.00,0.00,0.00,4296.31,0.00,'2022-02-24 09:40:10','',''),(2640929,'5','174','899',397,'Sale Id shift 257569',0.00,0.00,0.00,149.47,0.00,'2022-02-24 09:40:10','',''),(2640930,'5','174','900',397,'Sale Id shift 257569',0.00,0.00,0.00,5935.94,0.00,'2022-02-24 09:40:10','',''),(2640931,'5','174',NULL,397,'Sale Id shift 257569',1712983.80,0.00,0.00,0.00,0.00,'2022-02-24 09:40:10','',''),(2640932,'5','174','899',397,'Sale Id shift 257570',0.00,0.00,0.00,3137.13,0.00,'2022-02-25 11:05:07','',''),(2640933,'5','174','899',397,'Sale Id shift 257570',0.00,0.00,0.00,3064.91,0.00,'2022-02-25 11:05:07','',''),(2640934,'5','174','900',397,'Sale Id shift 257570',0.00,0.00,0.00,4284.87,0.00,'2022-02-25 11:05:07','',''),(2640935,'5','174',NULL,397,'Sale Id shift 257570',1730340.15,0.00,0.00,0.00,0.00,'2022-02-25 11:05:07','',''),(2640936,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4280100.00,25940.00,0.00,0.00,'2022-02-25 13:13:34','',''),(2640937,'5','174',NULL,397,'Reception corrector for bridging 132578',0.00,0.00,0.00,25940.00,0.00,'2022-02-25 16:45:47','',''),(2640938,'5','174','900',397,'Received from bridging 132578',0.00,0.00,25940.00,0.00,0.00,'2022-02-25 16:45:47','',''),(2640939,'5','174','899',397,'Sale Id shift 257571',0.00,0.00,0.00,5207.91,0.00,'2022-02-26 07:22:44','',''),(2640940,'5','174','900',397,'Sale Id shift 257571',0.00,0.00,0.00,12280.60,0.00,'2022-02-26 07:22:44','',''),(2640941,'5','174',NULL,397,'Sale Id shift 257571',2885604.15,0.00,0.00,0.00,0.00,'2022-02-26 07:22:44','',''),(2640942,'5','174','899',397,'Sale Id shift 257572',0.00,0.00,0.00,390.44,0.00,'2022-02-27 07:05:25','',''),(2640943,'5','174','899',397,'Sale Id shift 257572',0.00,0.00,0.00,490.08,0.00,'2022-02-27 07:05:25','',''),(2640944,'5','174','900',397,'Sale Id shift 257572',0.00,0.00,0.00,5558.87,0.00,'2022-02-27 07:05:25','',''),(2640945,'5','174',NULL,397,'Sale Id shift 257572',1062499.35,0.00,0.00,0.00,0.00,'2022-02-27 07:05:25','',''),(2640946,'5','174','900',397,'Sale Id shift 257573',0.00,0.00,0.00,8598.21,0.00,'2022-02-28 07:20:10','',''),(2640947,'5','174',NULL,397,'Sale Id shift 257573',1418704.65,0.00,0.00,0.00,0.00,'2022-02-28 07:20:10','',''),(2640948,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3689400.00,22360.00,0.00,0.00,'2022-02-28 19:54:52','',''),(2640949,'5','174',NULL,397,'Reception corrector for bridging 132579',0.00,0.00,0.00,18500.00,0.00,'2022-02-28 21:08:41','',''),(2640950,'5','174','899',397,'Received from bridging 132579',0.00,0.00,18500.00,0.00,0.00,'2022-02-28 21:08:41','',''),(2640951,'5','174',NULL,397,'Reception corrector for bridging 132580',0.00,0.00,0.00,3860.00,0.00,'2022-02-28 21:08:58','',''),(2640952,'5','174','900',397,'Received from bridging 132580',0.00,0.00,3860.00,0.00,0.00,'2022-02-28 21:08:58','',''),(2640953,'5','174','900',397,'Sale Id shift 257574',0.00,0.00,0.00,2897.34,0.00,'2022-03-01 06:58:03','',''),(2640954,'5','174',NULL,397,'Sale Id shift 257574',478061.10,0.00,0.00,0.00,0.00,'2022-03-01 06:58:03','',''),(2640955,'5','174','899',397,'Sale Id shift 257575',0.00,0.00,0.00,1022.22,0.00,'2022-03-02 08:22:46','',''),(2640956,'5','174','899',397,'Sale Id shift 257575',0.00,0.00,0.00,14144.83,0.00,'2022-03-02 08:22:46','',''),(2640957,'5','174','900',397,'Sale Id shift 257575',0.00,0.00,0.00,3903.15,0.00,'2022-03-02 08:22:46','',''),(2640958,'5','174',NULL,397,'Sale Id shift 257575',3146583.00,0.00,0.00,0.00,0.00,'2022-03-02 08:22:46','',''),(2640959,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,3609.69,0.00,'2022-03-02 22:31:46','',''),(2640960,'5','174','899',0,'Inventory adjustment from tank dipping to 3900',0.00,0.00,3900.00,0.00,0.00,'2022-03-02 22:31:46','',''),(2640961,'5','174','899',397,'Sale Id shift 257576',0.00,0.00,0.00,750.14,0.00,'2022-03-03 09:42:38','',''),(2640962,'5','174','899',397,'Sale Id shift 257576',0.00,0.00,0.00,3115.86,0.00,'2022-03-03 09:42:38','',''),(2640963,'5','174',NULL,397,'Sale Id shift 257576',637890.00,0.00,0.00,0.00,0.00,'2022-03-03 09:42:38','',''),(2640964,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2805000.00,17000.00,0.00,0.00,'2022-03-05 09:11:22','',''),(2640965,'5','174',NULL,397,'Reception corrector for bridging 132581',0.00,0.00,0.00,17000.00,0.00,'2022-03-05 09:26:34','',''),(2640966,'5','174','899',397,'Received from bridging 132581',0.00,0.00,17000.00,0.00,0.00,'2022-03-05 09:26:34','',''),(2640967,'5','174','899',397,'Sale Id shift 257578',0.00,0.00,0.00,412.23,0.00,'2022-03-05 12:35:11','',''),(2640968,'5','174','899',397,'Sale Id shift 257578',0.00,0.00,0.00,3582.13,0.00,'2022-03-05 12:35:11','',''),(2640969,'5','174',NULL,397,'Sale Id shift 257578',659069.40,0.00,0.00,0.00,0.00,'2022-03-05 12:35:11','',''),(2640970,'5','174','899',397,'Sale Id shift 257579',0.00,0.00,0.00,4853.32,0.00,'2022-03-06 07:44:31','',''),(2640971,'5','174','899',397,'Sale Id shift 257579',0.00,0.00,0.00,5233.22,0.00,'2022-03-06 07:44:31','',''),(2640972,'5','174',NULL,397,'Sale Id shift 257579',1664279.10,0.00,0.00,0.00,0.00,'2022-03-06 07:44:31','',''),(2640973,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,2953.10,0.00,'2022-03-06 20:32:45','',''),(2640974,'5','174','899',0,'Inventory adjustment from tank dipping to 3100',0.00,0.00,3100.00,0.00,0.00,'2022-03-06 20:32:45','',''),(2640975,'5','174','899',397,'Sale Id shift 257580',0.00,0.00,0.00,343.00,0.00,'2022-03-07 08:01:02','',''),(2640976,'5','174','899',397,'Sale Id shift 257580',0.00,0.00,0.00,2700.00,0.00,'2022-03-07 08:01:02','',''),(2640977,'5','174',NULL,397,'Sale Id shift 257580',502095.00,0.00,0.00,0.00,0.00,'2022-03-07 08:01:02','',''),(2640978,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-03-11 20:02:19','',''),(2640979,'5','174',NULL,397,'Reception corrector for bridging 132582',0.00,0.00,0.00,16000.00,0.00,'2022-03-11 20:19:21','',''),(2640980,'5','174','899',397,'Received from bridging 132582',0.00,0.00,16000.00,0.00,0.00,'2022-03-11 20:19:21','',''),(2640981,'5','174','899',397,'Sale Id shift 257585',0.00,0.00,0.00,1000.00,0.00,'2022-03-12 07:59:58','',''),(2640982,'5','174','899',397,'Sale Id shift 257585',0.00,0.00,0.00,1087.00,0.00,'2022-03-12 07:59:58','',''),(2640983,'5','174',NULL,397,'Sale Id shift 257585',344355.00,0.00,0.00,0.00,0.00,'2022-03-12 07:59:58','',''),(2640984,'5','174','899',397,'Sale Id shift 257586',0.00,0.00,0.00,1317.86,0.00,'2022-03-13 08:09:06','',''),(2640985,'5','174','899',397,'Sale Id shift 257586',0.00,0.00,0.00,5240.73,0.00,'2022-03-13 08:09:06','',''),(2640986,'5','174',NULL,397,'Sale Id shift 257586',1082167.35,0.00,0.00,0.00,0.00,'2022-03-13 08:09:06','',''),(2640987,'5','174','899',397,'Sale Id shift 257587',0.00,0.00,0.00,2395.16,0.00,'2022-03-14 07:08:52','',''),(2640988,'5','174','899',397,'Sale Id shift 257587',0.00,0.00,0.00,3601.97,0.00,'2022-03-14 07:08:52','',''),(2640989,'5','174',NULL,397,'Sale Id shift 257587',989526.45,0.00,0.00,0.00,0.00,'2022-03-14 07:08:52','',''),(2640990,'5','174','899',397,'Sale Id shift 257588',0.00,0.00,0.00,43.87,0.00,'2022-03-15 07:10:47','',''),(2640991,'5','174','899',397,'Sale Id shift 257588',0.00,0.00,0.00,1307.57,0.00,'2022-03-15 07:10:47','',''),(2640992,'5','174',NULL,397,'Sale Id shift 257588',222987.60,0.00,0.00,0.00,0.00,'2022-03-15 07:10:47','',''),(2640993,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3300000.00,20000.00,0.00,0.00,'2022-03-24 18:23:24','',''),(2640994,'5','174',NULL,397,'Reception corrector for bridging 132583',0.00,0.00,0.00,20000.00,0.00,'2022-03-24 22:53:56','',''),(2640995,'5','174','899',397,'Received from bridging 132583',0.00,0.00,20000.00,0.00,0.00,'2022-03-24 22:53:56','',''),(2640996,'5','174','899',397,'Sale Id shift 257598',0.00,0.00,0.00,2266.70,0.00,'2022-03-25 09:48:45','',''),(2640997,'5','174','899',397,'Sale Id shift 257598',0.00,0.00,0.00,1876.61,0.00,'2022-03-25 09:48:45','',''),(2640998,'5','174',NULL,397,'Sale Id shift 257598',683646.15,0.00,0.00,0.00,0.00,'2022-03-25 09:48:45','',''),(2640999,'5','174','899',397,'Sale Id shift 257599',0.00,0.00,0.00,4129.88,0.00,'2022-03-26 09:07:28','',''),(2641000,'5','174','899',397,'Sale Id shift 257599',0.00,0.00,0.00,3473.50,0.00,'2022-03-26 09:07:28','',''),(2641001,'5','174',NULL,397,'Sale Id shift 257599',1254557.70,0.00,0.00,0.00,0.00,'2022-03-26 09:07:28','',''),(2641002,'5','174','899',397,'Sale Id shift 257600',0.00,0.00,0.00,4673.29,0.00,'2022-03-27 07:07:43','',''),(2641003,'5','174','899',397,'Sale Id shift 257600',0.00,0.00,0.00,3009.25,0.00,'2022-03-27 07:07:43','',''),(2641004,'5','174',NULL,397,'Sale Id shift 257600',1267619.10,0.00,0.00,0.00,0.00,'2022-03-27 07:07:43','',''),(2641005,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,633.61,0.00,'2022-03-28 03:06:00','',''),(2641006,'5','174','899',0,'Inventory adjustment from tank dipping to 1300',0.00,0.00,1300.00,0.00,0.00,'2022-03-28 03:06:00','',''),(2641007,'5','174','899',397,'Sale Id shift 257601',0.00,0.00,0.00,622.13,0.00,'2022-03-28 09:23:15','',''),(2641008,'5','174','899',397,'Sale Id shift 257601',0.00,0.00,0.00,595.26,0.00,'2022-03-28 09:23:15','',''),(2641009,'5','174',NULL,397,'Sale Id shift 257601',200869.35,0.00,0.00,0.00,0.00,'2022-03-28 09:23:15','',''),(2641010,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-04-12 10:20:27','',''),(2641011,'5','174',NULL,397,'Reception corrector for bridging 132584',0.00,0.00,0.00,13500.00,0.00,'2022-04-12 10:35:42','',''),(2641012,'5','174','899',397,'Received from bridging 132584',0.00,0.00,13500.00,0.00,0.00,'2022-04-12 10:35:42','',''),(2641013,'5','174','899',397,'Sale Id shift 257615',0.00,0.00,0.00,1000.20,0.00,'2022-04-12 14:17:55','',''),(2641014,'5','174','899',397,'Sale Id shift 257615',0.00,0.00,0.00,1179.00,0.00,'2022-04-12 14:17:55','',''),(2641015,'5','174',NULL,397,'Sale Id shift 257615',359568.00,0.00,0.00,0.00,0.00,'2022-04-12 14:17:55','',''),(2641016,'5','174','899',397,'Sale Id shift 257616',0.00,0.00,0.00,1560.58,0.00,'2022-04-13 09:56:35','',''),(2641017,'5','174','899',397,'Sale Id shift 257616',0.00,0.00,0.00,3052.64,0.00,'2022-04-13 09:56:35','',''),(2641018,'5','174',NULL,397,'Sale Id shift 257616',761181.30,0.00,0.00,0.00,0.00,'2022-04-13 09:56:35','',''),(2641019,'5','174','899',397,'Sale Id shift 257617',0.00,0.00,0.00,1366.92,0.00,'2022-04-14 08:27:21','',''),(2641020,'5','174','899',397,'Sale Id shift 257617',0.00,0.00,0.00,3212.34,0.00,'2022-04-14 08:27:21','',''),(2641021,'5','174',NULL,397,'Sale Id shift 257617',755577.90,0.00,0.00,0.00,0.00,'2022-04-14 08:27:21','',''),(2641022,'5','174','899',397,'Sale Id shift 257618',0.00,0.00,0.00,28.62,0.00,'2022-04-15 15:19:45','',''),(2641023,'5','174','899',397,'Sale Id shift 257618',0.00,0.00,0.00,1999.99,0.00,'2022-04-15 15:19:45','',''),(2641024,'5','174',NULL,397,'Sale Id shift 257618',334720.65,0.00,0.00,0.00,0.00,'2022-04-15 15:19:45','',''),(2641025,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5940000.00,36000.00,0.00,0.00,'2022-04-18 21:28:53','',''),(2641026,'5','174',NULL,397,'Reception corrector for bridging 132585',0.00,0.00,0.00,18000.00,0.00,'2022-04-18 21:45:34','',''),(2641027,'5','174','899',397,'Received from bridging 132585',0.00,0.00,18000.00,0.00,0.00,'2022-04-18 21:45:34','',''),(2641028,'5','174','899',397,'Sale Id shift 257622',0.00,0.00,0.00,999.31,0.00,'2022-04-19 04:33:45','',''),(2641029,'5','174','899',397,'Sale Id shift 257622',0.00,0.00,0.00,2187.00,0.00,'2022-04-19 04:33:45','',''),(2641030,'5','174',NULL,397,'Sale Id shift 257622',525741.15,0.00,0.00,0.00,0.00,'2022-04-19 04:33:45','',''),(2641031,'5','174','899',397,'Sale Id shift 257623',0.00,0.00,0.00,2946.67,0.00,'2022-04-19 22:46:54','',''),(2641032,'5','174','899',397,'Sale Id shift 257623',0.00,0.00,0.00,3002.73,0.00,'2022-04-19 22:46:54','',''),(2641033,'5','174',NULL,397,'Sale Id shift 257623',981651.00,0.00,0.00,0.00,0.00,'2022-04-19 22:46:54','',''),(2641034,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2970000.00,18000.00,0.00,0.00,'2022-04-20 16:43:12','',''),(2641035,'5','174','899',397,'Sale Id shift 257624',0.00,0.00,0.00,4282.77,0.00,'2022-04-21 08:56:25','',''),(2641036,'5','174','899',397,'Sale Id shift 257624',0.00,0.00,0.00,1001.99,0.00,'2022-04-21 08:56:25','',''),(2641037,'5','174',NULL,397,'Sale Id shift 257624',871985.40,0.00,0.00,0.00,0.00,'2022-04-21 08:56:25','',''),(2641038,'5','174',NULL,397,'Reception corrector for bridging 132587',0.00,0.00,0.00,18000.00,0.00,'2022-04-22 10:21:27','',''),(2641039,'5','174','900',397,'Received from bridging 132587',0.00,0.00,18000.00,0.00,0.00,'2022-04-22 10:21:27','',''),(2641040,'5','174','899',397,'Sale Id shift 257625',0.00,0.00,0.00,249.84,0.00,'2022-04-22 11:27:01','',''),(2641041,'5','174','899',397,'Sale Id shift 257625',0.00,0.00,0.00,2571.78,0.00,'2022-04-22 11:27:01','',''),(2641042,'5','174','900',397,'Sale Id shift 257625',0.00,0.00,0.00,2499.99,0.00,'2022-04-22 11:27:01','',''),(2641043,'5','174',NULL,397,'Sale Id shift 257625',878065.65,0.00,0.00,0.00,0.00,'2022-04-22 11:27:01','',''),(2641044,'5','174','900',397,'Sale Id shift 257626',0.00,0.00,0.00,5399.97,0.00,'2022-04-23 09:28:21','',''),(2641045,'5','174',NULL,397,'Sale Id shift 257626',890995.05,0.00,0.00,0.00,0.00,'2022-04-23 09:28:21','',''),(2641046,'5','174','900',397,'Sale Id shift 257627',0.00,0.00,0.00,4259.03,0.00,'2022-04-23 22:09:41','',''),(2641047,'5','174',NULL,397,'Sale Id shift 257627',702739.95,0.00,0.00,0.00,0.00,'2022-04-23 22:09:41','',''),(2641048,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-04-24 16:17:34','',''),(2641049,'5','174',NULL,397,'Reception corrector for bridging 132588',0.00,0.00,0.00,13450.00,0.00,'2022-04-24 16:59:19','',''),(2641050,'5','174','899',397,'Received from bridging 132588',0.00,0.00,13450.00,0.00,0.00,'2022-04-24 16:59:19','',''),(2641051,'5','174','899',397,'Sale Id shift 257628',0.00,0.00,0.00,1148.97,0.00,'2022-04-25 04:55:49','',''),(2641052,'5','174','900',397,'Sale Id shift 257628',0.00,0.00,0.00,5865.20,0.00,'2022-04-25 04:55:49','',''),(2641053,'5','174',NULL,397,'Sale Id shift 257628',1157338.05,0.00,0.00,0.00,0.00,'2022-04-25 04:55:49','',''),(2641054,'5','174','899',397,'Sale Id shift 257629',0.00,0.00,0.00,3259.65,0.00,'2022-04-26 07:37:13','',''),(2641055,'5','174','899',397,'Sale Id shift 257629',0.00,0.00,0.00,2340.90,0.00,'2022-04-26 07:37:13','',''),(2641056,'5','174',NULL,397,'Sale Id shift 257629',924090.75,0.00,0.00,0.00,0.00,'2022-04-26 07:37:13','',''),(2641057,'5','174','899',397,'Sale Id shift 257630',0.00,0.00,0.00,720.20,0.00,'2022-04-27 08:18:57','',''),(2641058,'5','174',NULL,397,'Sale Id shift 257630',118833.00,0.00,0.00,0.00,0.00,'2022-04-27 08:18:57','',''),(2641059,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-27 09:51:04','',''),(2641060,'5','174','899',397,'Sale Id shift 257631',0.00,0.00,0.00,6215.01,0.00,'2022-04-27 16:50:37','',''),(2641061,'5','174',NULL,397,'Sale Id shift 257631',1025476.65,0.00,0.00,0.00,0.00,'2022-04-27 16:50:37','',''),(2641062,'5','174',NULL,397,'Reception corrector for bridging 132589',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 18:08:40','',''),(2641063,'5','174','899',397,'Received from bridging 132589',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 18:08:40','',''),(2641064,'5','174','899',397,'Sale Id shift 257632',0.00,0.00,0.00,3151.20,0.00,'2022-04-28 07:35:00','',''),(2641065,'5','174','899',397,'Sale Id shift 257632',0.00,0.00,0.00,3099.70,0.00,'2022-04-28 07:35:00','',''),(2641066,'5','174',NULL,397,'Sale Id shift 257632',1031398.50,0.00,0.00,0.00,0.00,'2022-04-28 07:35:00','',''),(2641067,'5','174','899',397,'Sale Id shift 257633',0.00,0.00,0.00,3625.59,0.00,'2022-04-29 14:22:04','',''),(2641068,'5','174','899',397,'Sale Id shift 257633',0.00,0.00,0.00,2214.20,0.00,'2022-04-29 14:22:04','',''),(2641069,'5','174',NULL,397,'Sale Id shift 257633',963565.35,0.00,0.00,0.00,0.00,'2022-04-29 14:22:04','',''),(2641070,'5','174','899',397,'Sale Id shift 257634',0.00,0.00,0.00,1671.62,0.00,'2022-05-09 10:24:50','',''),(2641071,'5','174','899',397,'Sale Id shift 257634',0.00,0.00,0.00,6773.62,0.00,'2022-05-09 10:24:50','',''),(2641072,'5','174',NULL,397,'Sale Id shift 257634',1393464.60,0.00,0.00,0.00,0.00,'2022-05-09 10:24:50','',''),(2641073,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-05-10 15:34:57','',''),(2641074,'5','174','899',397,'Sale Id shift 257635',0.00,0.00,0.00,1915.18,0.00,'2022-05-10 16:00:35','',''),(2641075,'5','174','899',397,'Sale Id shift 257635',0.00,0.00,0.00,7724.25,0.00,'2022-05-10 16:00:35','',''),(2641076,'5','174',NULL,397,'Sale Id shift 257635',1590505.95,0.00,0.00,0.00,0.00,'2022-05-10 16:00:35','',''),(2641077,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-05-10 16:39:43','',''),(2641078,'5','174',NULL,397,'Reception corrector for bridging 132591',0.00,0.00,0.00,16000.00,0.00,'2022-05-10 17:01:20','',''),(2641079,'5','174','899',397,'Received from bridging 132591',0.00,0.00,16000.00,0.00,0.00,'2022-05-10 17:01:20','',''),(2641080,'5','174',NULL,397,'Reception corrector for bridging 132592',0.00,0.00,0.00,16000.00,0.00,'2022-05-10 17:01:33','',''),(2641081,'5','174','899',397,'Received from bridging 132592',0.00,0.00,16000.00,0.00,0.00,'2022-05-10 17:01:33','',''),(2641082,'5','174','899',397,'Sale Id shift 257636',0.00,0.00,0.00,3582.12,0.00,'2022-05-10 17:17:25','',''),(2641083,'5','174','899',397,'Sale Id shift 257636',0.00,0.00,0.00,1542.72,0.00,'2022-05-10 17:17:25','',''),(2641084,'5','174',NULL,397,'Sale Id shift 257636',845598.60,0.00,0.00,0.00,0.00,'2022-05-10 17:17:25','',''),(2641085,'5','174','899',397,'Sale Id shift 257637',0.00,0.00,0.00,2001.00,0.00,'2022-05-10 17:29:45','',''),(2641086,'5','174','899',397,'Sale Id shift 257637',0.00,0.00,0.00,3141.43,0.00,'2022-05-10 17:29:45','',''),(2641087,'5','174',NULL,397,'Sale Id shift 257637',848500.95,0.00,0.00,0.00,0.00,'2022-05-10 17:29:45','',''),(2641088,'5','174','899',397,'Sale Id shift 257638',0.00,0.00,0.00,3522.01,0.00,'2022-05-10 19:58:04','',''),(2641089,'5','174','899',397,'Sale Id shift 257638',0.00,0.00,0.00,1098.01,0.00,'2022-05-10 19:58:04','',''),(2641090,'5','174',NULL,397,'Sale Id shift 257638',762303.30,0.00,0.00,0.00,0.00,'2022-05-10 19:58:04','',''),(2641091,'5','174','899',397,'Sale Id shift 257639',0.00,0.00,0.00,1120.42,0.00,'2022-05-11 05:41:05','',''),(2641092,'5','174',NULL,397,'Sale Id shift 257639',184869.30,0.00,0.00,0.00,0.00,'2022-05-11 05:41:05','',''),(2641093,'5','174','899',397,'Sale Id shift 257640',0.00,0.00,0.00,3283.11,0.00,'2022-05-11 08:17:54','',''),(2641094,'5','174',NULL,397,'Sale Id shift 257640',541713.15,0.00,0.00,0.00,0.00,'2022-05-11 08:17:54','',''),(2641095,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2227500.00,13500.00,0.00,0.00,'2022-05-11 08:18:12','',''),(2641096,'5','174','899',397,'Sale Id shift 257641',0.00,0.00,0.00,4139.25,0.00,'2022-05-11 08:28:53','',''),(2641097,'5','174',NULL,397,'Sale Id shift 257641',682976.25,0.00,0.00,0.00,0.00,'2022-05-11 08:28:53','',''),(2641098,'5','174','899',397,'Sale Id shift 257642',0.00,0.00,0.00,4759.07,0.00,'2022-05-11 09:28:52','',''),(2641099,'5','174',NULL,397,'Sale Id shift 257642',785246.55,0.00,0.00,0.00,0.00,'2022-05-11 09:28:52','',''),(2641100,'5','174','899',397,'Sale Id shift 257643',0.00,0.00,0.00,1215.13,0.00,'2022-05-11 09:39:19','',''),(2641101,'5','174',NULL,397,'Sale Id shift 257643',200496.45,0.00,0.00,0.00,0.00,'2022-05-11 09:39:19','',''),(2641102,'5','174','899',397,'Sale Id shift 257659',0.00,0.00,0.00,2153.02,0.00,'2022-05-25 07:31:01','',''),(2641103,'5','174',NULL,397,'Sale Id shift 257659',355248.30,0.00,0.00,0.00,0.00,'2022-05-25 07:31:01','',''),(2641104,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2640000.00,16000.00,0.00,0.00,'2022-05-25 17:03:01','',''),(2641105,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2145000.00,13000.00,0.00,0.00,'2022-05-25 17:03:09','',''),(2641106,'5','174',NULL,397,'Reception corrector for bridging 132595',0.00,0.00,0.00,13000.00,0.00,'2022-05-25 19:29:49','',''),(2641107,'5','174','899',397,'Received from bridging 132595',0.00,0.00,13000.00,0.00,0.00,'2022-05-25 19:29:49','',''),(2641108,'5','174',NULL,397,'Reception corrector for bridging 132594',0.00,0.00,0.00,16000.00,0.00,'2022-05-25 19:30:03','',''),(2641109,'5','174','899',397,'Received from bridging 132594',0.00,0.00,16000.00,0.00,0.00,'2022-05-25 19:30:03','',''),(2641110,'5','174','899',397,'Sale Id shift 257660',0.00,0.00,0.00,4621.03,0.00,'2022-05-26 05:41:58','',''),(2641111,'5','174',NULL,397,'Sale Id shift 257660',762469.95,0.00,0.00,0.00,0.00,'2022-05-26 05:41:58','',''),(2641112,'5','174','899',397,'Sale Id shift 257661',0.00,0.00,0.00,4724.63,0.00,'2022-05-27 05:53:41','',''),(2641113,'5','174',NULL,397,'Sale Id shift 257661',779563.95,0.00,0.00,0.00,0.00,'2022-05-27 05:53:41','',''),(2641114,'5','174','899',397,'Sale Id shift 257662',0.00,0.00,0.00,5042.51,0.00,'2022-05-28 09:48:14','',''),(2641115,'5','174',NULL,397,'Sale Id shift 257662',832014.15,0.00,0.00,0.00,0.00,'2022-05-28 09:48:14','',''),(2641116,'5','174','899',397,'Sale Id shift 257663',0.00,0.00,0.00,4531.09,0.00,'2022-05-29 09:42:41','',''),(2641117,'5','174','899',397,'Sale Id shift 257663',0.00,0.00,0.00,602.86,0.00,'2022-05-29 09:42:41','',''),(2641118,'5','174',NULL,397,'Sale Id shift 257663',847101.75,0.00,0.00,0.00,0.00,'2022-05-29 09:42:41','',''),(2641119,'5','174','899',397,'Sale Id shift 257664',0.00,0.00,0.00,5161.13,0.00,'2022-05-30 06:26:22','',''),(2641120,'5','174',NULL,397,'Sale Id shift 257664',851586.45,0.00,0.00,0.00,0.00,'2022-05-30 06:26:22','',''),(2641121,'5','174','899',397,'Sale Id shift 257665',0.00,0.00,0.00,2215.00,0.00,'2022-05-31 10:02:58','',''),(2641122,'5','174',NULL,397,'Sale Id shift 257665',365475.00,0.00,0.00,0.00,0.00,'2022-05-31 10:02:58','',''),(2641123,'5','174','899',397,'Sale Id shift 257670',0.00,0.00,0.00,727.77,0.00,'2022-06-05 08:11:49','',''),(2641124,'5','174','899',397,'Sale Id shift 257670',0.00,0.00,0.00,1097.60,0.00,'2022-06-05 08:11:49','',''),(2641125,'5','174',NULL,397,'Sale Id shift 257670',301186.05,0.00,0.00,0.00,0.00,'2022-06-05 08:11:49','',''),(2641126,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2169750.00,13150.00,0.00,0.00,'2022-06-05 14:34:32','',''),(2641127,'5','174',NULL,397,'Reception corrector for bridging 132596',0.00,0.00,0.00,13150.00,0.00,'2022-06-05 15:11:33','',''),(2641128,'5','174','899',397,'Received from bridging 132596',0.00,0.00,13150.00,0.00,0.00,'2022-06-05 15:11:33','',''),(2641129,'5','174','899',397,'Sale Id shift 257671',0.00,0.00,0.00,3096.32,0.00,'2022-06-06 09:47:34','',''),(2641130,'5','174','899',397,'Sale Id shift 257671',0.00,0.00,0.00,1918.44,0.00,'2022-06-06 09:47:34','',''),(2641131,'5','174',NULL,397,'Sale Id shift 257671',827435.40,0.00,0.00,0.00,0.00,'2022-06-06 09:47:34','',''),(2641132,'5','174','899',397,'Sale Id shift 257672',0.00,0.00,0.00,3052.20,0.00,'2022-06-07 06:51:35','',''),(2641133,'5','174','899',397,'Sale Id shift 257672',0.00,0.00,0.00,1166.52,0.00,'2022-06-07 06:51:35','',''),(2641134,'5','174',NULL,397,'Sale Id shift 257672',696088.80,0.00,0.00,0.00,0.00,'2022-06-07 06:51:35','',''),(2641135,'5','174','899',397,'Sale Id shift 257673',0.00,0.00,0.00,3099.73,0.00,'2022-06-08 09:06:01','',''),(2641136,'5','174','899',397,'Sale Id shift 257673',0.00,0.00,0.00,2014.46,0.00,'2022-06-08 09:06:01','',''),(2641137,'5','174',NULL,397,'Sale Id shift 257673',843841.35,0.00,0.00,0.00,0.00,'2022-06-08 09:06:01','',''),(2641138,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4455000.00,27000.00,0.00,0.00,'2022-06-09 08:20:00','',''),(2641139,'5','174',NULL,397,'Reception corrector for bridging 132597',0.00,0.00,0.00,27000.00,0.00,'2022-06-09 09:07:56','',''),(2641140,'5','174','899',397,'Received from bridging 132597',0.00,0.00,27000.00,0.00,0.00,'2022-06-09 09:07:56','',''),(2641141,'5','174','899',397,'Sale Id shift 257674',0.00,0.00,0.00,1102.27,0.00,'2022-06-09 14:11:03','',''),(2641142,'5','174','899',397,'Sale Id shift 257674',0.00,0.00,0.00,3220.52,0.00,'2022-06-09 14:11:03','',''),(2641143,'5','174',NULL,397,'Sale Id shift 257674',713260.35,0.00,0.00,0.00,0.00,'2022-06-09 14:11:03','',''),(2641144,'5','174','899',397,'Sale Id shift 257675',0.00,0.00,0.00,4138.50,0.00,'2022-06-10 05:47:10','',''),(2641145,'5','174',NULL,397,'Sale Id shift 257675',682852.50,0.00,0.00,0.00,0.00,'2022-06-10 05:47:10','',''),(2641146,'5','174','899',397,'Sale Id shift 257676',0.00,0.00,0.00,4011.03,0.00,'2022-06-12 12:35:12','',''),(2641147,'5','174',NULL,397,'Sale Id shift 257676',661819.95,0.00,0.00,0.00,0.00,'2022-06-12 12:35:12','',''),(2641148,'5','174','899',397,'Sale Id shift 257677',0.00,0.00,0.00,3814.25,0.00,'2022-06-13 07:04:06','',''),(2641149,'5','174',NULL,397,'Sale Id shift 257677',629351.25,0.00,0.00,0.00,0.00,'2022-06-13 07:04:06','',''),(2641150,'5','174','899',397,'Sale Id shift 257678',0.00,0.00,0.00,4134.25,0.00,'2022-06-14 06:50:11','',''),(2641151,'5','174',NULL,397,'Sale Id shift 257678',682151.25,0.00,0.00,0.00,0.00,'2022-06-14 06:50:11','',''),(2641152,'5','174','899',397,'Sale Id shift 257679',0.00,0.00,0.00,3147.25,0.00,'2022-06-14 10:54:06','',''),(2641153,'5','174',NULL,397,'Sale Id shift 257679',519296.25,0.00,0.00,0.00,0.00,'2022-06-14 10:54:06','',''),(2641154,'5','174','899',397,'Sale Id shift 257684',0.00,0.00,0.00,512.23,0.00,'2022-06-19 06:59:42','',''),(2641155,'5','174',NULL,397,'Sale Id shift 257684',84517.95,0.00,0.00,0.00,0.00,'2022-06-19 06:59:42','',''),(2641156,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2805000.00,17000.00,0.00,0.00,'2022-07-09 11:15:34','',''),(2641157,'5','174',NULL,397,'Reception corrector for bridging 132598',0.00,0.00,0.00,17000.00,0.00,'2022-07-09 13:50:32','',''),(2641158,'5','174','899',397,'Received from bridging 132598',0.00,0.00,17000.00,0.00,0.00,'2022-07-09 13:50:32','',''),(2641159,'5','174','899',397,'Sale Id shift 257704',0.00,0.00,0.00,1698.00,0.00,'2022-07-09 15:18:48','',''),(2641160,'5','174','899',397,'Sale Id shift 257704',0.00,0.00,0.00,3214.68,0.00,'2022-07-09 15:18:48','',''),(2641161,'5','174',NULL,397,'Sale Id shift 257704',810592.20,0.00,0.00,0.00,0.00,'2022-07-09 15:18:48','',''),(2641162,'5','174','899',397,'Sale Id shift 257705',0.00,0.00,0.00,2161.19,0.00,'2022-07-10 13:25:40','',''),(2641163,'5','174','899',397,'Sale Id shift 257705',0.00,0.00,0.00,2056.89,0.00,'2022-07-10 13:25:40','',''),(2641164,'5','174',NULL,397,'Sale Id shift 257705',695983.20,0.00,0.00,0.00,0.00,'2022-07-10 13:25:40','',''),(2641165,'5','174','899',397,'Sale Id shift 257706',0.00,0.00,0.00,3652.15,0.00,'2022-07-11 07:40:45','',''),(2641166,'5','174',NULL,397,'Sale Id shift 257706',602604.75,0.00,0.00,0.00,0.00,'2022-07-11 07:40:45','',''),(2641167,'5','174','899',397,'Sale Id shift 257707',0.00,0.00,0.00,3128.31,0.00,'2022-07-12 08:43:09','',''),(2641168,'5','174',NULL,397,'Sale Id shift 257707',516171.15,0.00,0.00,0.00,0.00,'2022-07-12 08:43:09','',''),(2641169,'5','174','899',397,'Sale Id shift 257708',0.00,0.00,0.00,1001.73,0.00,'2022-07-13 06:13:21','',''),(2641170,'5','174','899',397,'Sale Id shift 257708',0.00,0.00,0.00,37.28,0.00,'2022-07-13 06:13:21','',''),(2641171,'5','174',NULL,397,'Sale Id shift 257708',171436.65,0.00,0.00,0.00,0.00,'2022-07-13 06:13:21','',''),(2641172,'5','174','899',0,'Tank level zero out for dipping',0.00,0.00,0.00,3021.03,0.00,'2022-07-14 15:46:46','',''),(2641173,'5','174','899',0,'Inventory adjustment from tank dipping to 18200',0.00,0.00,18200.00,0.00,0.00,'2022-07-14 15:46:46','',''),(2641174,'5','174','899',397,'Returned bridging 132591',0.00,0.00,0.00,16000.00,0.00,'2022-07-14 15:47:16','',''),(2641175,'5','174',NULL,397,'Reception Return corrector for bridging 132591',0.00,0.00,16000.00,0.00,0.00,'2022-07-14 15:47:16','',''),(2641176,'5','174',NULL,397,'Returned purchase #90729 to SALBAS OIL & GAS NIG. LIMITED',2640000.00,0.00,0.00,16000.00,0.00,'2022-07-14 15:47:42','',''),(2641177,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7381500.00,39900.00,0.00,0.00,'2022-07-15 07:56:29','',''),(2641178,'5','174',NULL,397,'Reception corrector for bridging 132599',0.00,0.00,0.00,26400.00,0.00,'2022-07-15 11:34:20','',''),(2641179,'5','174','899',397,'Received from bridging 132599',0.00,0.00,26400.00,0.00,0.00,'2022-07-15 11:34:20','',''),(2641180,'5','174',NULL,397,'Reception corrector for bridging 132600',0.00,0.00,0.00,13500.00,0.00,'2022-07-15 11:34:34','',''),(2641181,'5','174','900',397,'Received from bridging 132600',0.00,0.00,13500.00,0.00,0.00,'2022-07-15 11:34:34','',''),(2641182,'5','174','899',397,'Sale Id shift 257710',0.00,0.00,0.00,1824.28,0.00,'2022-07-15 11:38:25','',''),(2641183,'5','174','899',397,'Sale Id shift 257710',0.00,0.00,0.00,2001.52,0.00,'2022-07-15 11:38:25','',''),(2641184,'5','174',NULL,397,'Sale Id shift 257710',631257.00,0.00,0.00,0.00,0.00,'2022-07-15 11:38:25','',''),(2641185,'5','174','899',397,'Sale Id shift 257711',0.00,0.00,0.00,2101.72,0.00,'2022-07-16 08:23:03','',''),(2641186,'5','174','899',397,'Sale Id shift 257711',0.00,0.00,0.00,3040.94,0.00,'2022-07-16 08:23:03','',''),(2641187,'5','174',NULL,397,'Sale Id shift 257711',951392.10,0.00,0.00,0.00,0.00,'2022-07-16 08:23:03','',''),(2641188,'5','174','899',397,'Sale Id shift 257712',0.00,0.00,0.00,3093.96,0.00,'2022-07-17 06:05:43','',''),(2641189,'5','174','899',397,'Sale Id shift 257712',0.00,0.00,0.00,2478.73,0.00,'2022-07-17 06:05:43','',''),(2641190,'5','174',NULL,397,'Sale Id shift 257712',1030947.65,0.00,0.00,0.00,0.00,'2022-07-17 06:05:43','',''),(2641191,'5','174','899',397,'Sale Id shift 257713',0.00,0.00,0.00,1398.78,0.00,'2022-07-18 07:34:42','',''),(2641192,'5','174','899',397,'Sale Id shift 257713',0.00,0.00,0.00,857.00,0.00,'2022-07-18 07:34:42','',''),(2641193,'5','174','900',397,'Sale Id shift 257713',0.00,0.00,0.00,3982.21,0.00,'2022-07-18 07:34:42','',''),(2641194,'5','174',NULL,397,'Sale Id shift 257713',1154028.15,0.00,0.00,0.00,0.00,'2022-07-18 07:34:42','',''),(2641195,'5','174','899',397,'Sale Id shift 257714',0.00,0.00,0.00,3108.01,0.00,'2022-07-19 12:50:17','',''),(2641196,'5','174','899',397,'Sale Id shift 257714',0.00,0.00,0.00,3002.23,0.00,'2022-07-19 12:50:17','',''),(2641197,'5','174',NULL,397,'Sale Id shift 257714',1130394.40,0.00,0.00,0.00,0.00,'2022-07-19 12:50:17','',''),(2641198,'5','174','899',397,'Sale Id shift 257715',0.00,0.00,0.00,1502.51,0.00,'2022-07-20 09:43:56','',''),(2641199,'5','174','900',397,'Sale Id shift 257715',0.00,0.00,0.00,5120.31,0.00,'2022-07-20 09:43:56','',''),(2641200,'5','174',NULL,397,'Sale Id shift 257715',1225221.70,0.00,0.00,0.00,0.00,'2022-07-20 09:43:56','',''),(2641201,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4902500.00,26500.00,0.00,0.00,'2022-07-20 16:16:55','',''),(2641202,'5','174',NULL,397,'Reception corrector for bridging 132601',0.00,0.00,0.00,26500.00,0.00,'2022-07-21 07:12:36','',''),(2641203,'5','174','899',397,'Received from bridging 132601',0.00,0.00,26500.00,0.00,0.00,'2022-07-21 07:12:36','',''),(2641204,'5','174','899',397,'Sale Id shift 257716',0.00,0.00,0.00,5009.74,0.00,'2022-07-21 07:46:58','',''),(2641205,'5','174','900',397,'Sale Id shift 257716',0.00,0.00,0.00,2073.70,0.00,'2022-07-21 07:46:58','',''),(2641206,'5','174',NULL,397,'Sale Id shift 257716',1310436.40,0.00,0.00,0.00,0.00,'2022-07-21 07:46:58','',''),(2641207,'5','174','899',397,'Sale Id shift 257717',0.00,0.00,0.00,5519.25,0.00,'2022-07-22 07:02:30','',''),(2641208,'5','174',NULL,397,'Sale Id shift 257717',1021061.25,0.00,0.00,0.00,0.00,'2022-07-22 07:02:30','',''),(2641209,'5','174','899',397,'Sale Id shift 257718',0.00,0.00,0.00,4642.78,0.00,'2022-07-23 07:31:07','',''),(2641210,'5','174',NULL,397,'Sale Id shift 257718',858914.30,0.00,0.00,0.00,0.00,'2022-07-23 07:31:07','',''),(2641211,'5','174','899',397,'Sale Id shift 257719',0.00,0.00,0.00,2570.06,0.00,'2022-07-24 06:58:23','',''),(2641212,'5','174','899',397,'Sale Id shift 257719',0.00,0.00,0.00,2866.83,0.00,'2022-07-24 06:58:23','',''),(2641213,'5','174',NULL,397,'Sale Id shift 257719',1005824.65,0.00,0.00,0.00,0.00,'2022-07-24 06:58:23','',''),(2641214,'5','174','899',397,'Sale Id shift 257720',0.00,0.00,0.00,1692.04,0.00,'2022-07-25 09:27:42','',''),(2641215,'5','174','899',397,'Sale Id shift 257720',0.00,0.00,0.00,3412.05,0.00,'2022-07-25 09:27:42','',''),(2641216,'5','174',NULL,397,'Sale Id shift 257720',944256.65,0.00,0.00,0.00,0.00,'2022-07-25 09:27:42','',''),(2641217,'5','174','899',397,'Sale Id shift 257721',0.00,0.00,0.00,2803.90,0.00,'2022-07-26 07:43:54','',''),(2641218,'5','174','899',397,'Sale Id shift 257721',0.00,0.00,0.00,1003.39,0.00,'2022-07-26 07:43:54','',''),(2641219,'5','174','900',397,'Sale Id shift 257721',0.00,0.00,0.00,1201.07,0.00,'2022-07-26 07:43:54','',''),(2641220,'5','174',NULL,397,'Sale Id shift 257721',926546.60,0.00,0.00,0.00,0.00,'2022-07-26 07:43:54','',''),(2641221,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-08-02 07:32:59','',''),(2641222,'5','174',NULL,397,'Reception corrector for bridging 132602',0.00,0.00,0.00,30000.00,0.00,'2022-08-02 09:42:40','',''),(2641223,'5','174','899',397,'Received from bridging 132602',0.00,0.00,30000.00,0.00,0.00,'2022-08-02 09:42:40','',''),(2641224,'5','174','899',397,'Sale Id shift 257728',0.00,0.00,0.00,2001.71,0.00,'2022-08-02 10:31:26','',''),(2641225,'5','174','899',397,'Sale Id shift 257728',0.00,0.00,0.00,517.06,0.00,'2022-08-02 10:31:26','',''),(2641226,'5','174',NULL,397,'Sale Id shift 257728',465972.45,0.00,0.00,0.00,0.00,'2022-08-02 10:31:26','',''),(2641227,'5','174','899',397,'Sale Id shift 257729',0.00,0.00,0.00,2972.25,0.00,'2022-08-03 06:59:30','',''),(2641228,'5','174','899',397,'Sale Id shift 257729',0.00,0.00,0.00,2481.10,0.00,'2022-08-03 06:59:30','',''),(2641229,'5','174',NULL,397,'Sale Id shift 257729',1008869.75,0.00,0.00,0.00,0.00,'2022-08-03 06:59:30','',''),(2641230,'5','174','899',397,'Sale Id shift 257730',0.00,0.00,0.00,4786.55,0.00,'2022-08-04 06:53:02','',''),(2641231,'5','174',NULL,397,'Sale Id shift 257730',885511.75,0.00,0.00,0.00,0.00,'2022-08-04 06:53:02','',''),(2641232,'5','174','899',397,'Sale Id shift 257731',0.00,0.00,0.00,1196.07,0.00,'2022-08-05 06:38:50','',''),(2641233,'5','174','899',397,'Sale Id shift 257731',0.00,0.00,0.00,3851.56,0.00,'2022-08-05 06:38:50','',''),(2641234,'5','174',NULL,397,'Sale Id shift 257731',933811.55,0.00,0.00,0.00,0.00,'2022-08-05 06:38:50','',''),(2641235,'5','174','899',397,'Sale Id shift 257732',0.00,0.00,0.00,5224.23,0.00,'2022-08-06 09:12:37','',''),(2641236,'5','174',NULL,397,'Sale Id shift 257732',966482.55,0.00,0.00,0.00,0.00,'2022-08-06 09:12:37','',''),(2641237,'5','174','899',397,'Sale Id shift 257733',0.00,0.00,0.00,347.74,0.00,'2022-08-07 07:14:22','',''),(2641238,'5','174','899',397,'Sale Id shift 257733',0.00,0.00,0.00,4476.03,0.00,'2022-08-07 07:14:22','',''),(2641239,'5','174',NULL,397,'Sale Id shift 257733',892397.45,0.00,0.00,0.00,0.00,'2022-08-07 07:14:22','',''),(2641240,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-06 09:55:15','',''),(2641241,'5','174',NULL,397,'Reception corrector for bridging 132604',0.00,0.00,0.00,25000.00,0.00,'2022-09-06 10:22:26','',''),(2641242,'5','174','900',397,'Received from bridging 132604',0.00,0.00,25000.00,0.00,0.00,'2022-09-06 10:22:26','',''),(2641243,'5','174',NULL,397,'Reception corrector for bridging 132603',0.00,0.00,0.00,25000.00,0.00,'2022-09-06 10:22:33','',''),(2641244,'5','174','899',397,'Received from bridging 132603',0.00,0.00,25000.00,0.00,0.00,'2022-09-06 10:22:33','',''),(2641245,'5','174','899',397,'Sale Id shift 257734',0.00,0.00,0.00,712.78,0.00,'2022-09-06 10:38:15','',''),(2641246,'5','174','899',397,'Sale Id shift 257734',0.00,0.00,0.00,1399.14,0.00,'2022-09-06 10:38:15','',''),(2641247,'5','174',NULL,397,'Sale Id shift 257734',390705.20,0.00,0.00,0.00,0.00,'2022-09-06 10:38:15','',''),(2641248,'5','174','899',397,'Sale Id shift 257737',0.00,0.00,0.00,980.10,0.00,'2022-09-06 11:15:32','',''),(2641249,'5','174','899',397,'Sale Id shift 257737',0.00,0.00,0.00,1929.81,0.00,'2022-09-06 11:15:32','',''),(2641250,'5','174','900',397,'Sale Id shift 257737',0.00,0.00,0.00,244.84,0.00,'2022-09-06 11:15:32','',''),(2641251,'5','174',NULL,397,'Sale Id shift 257737',583628.75,0.00,0.00,0.00,0.00,'2022-09-06 11:15:32','',''),(2641252,'5','174','899',397,'Sale Id shift 257738',0.00,0.00,0.00,2833.37,0.00,'2022-09-06 11:44:39','',''),(2641253,'5','174','899',397,'Sale Id shift 257738',0.00,0.00,0.00,955.91,0.00,'2022-09-06 11:44:39','',''),(2641254,'5','174','900',397,'Sale Id shift 257738',0.00,0.00,0.00,2217.88,0.00,'2022-09-06 11:44:39','',''),(2641255,'5','174',NULL,397,'Sale Id shift 257738',1111324.60,0.00,0.00,0.00,0.00,'2022-09-06 11:44:39','',''),(2641256,'5','174','899',397,'Sale Id shift 257739',0.00,0.00,0.00,2168.51,0.00,'2022-09-06 12:10:17','',''),(2641257,'5','174','899',397,'Sale Id shift 257739',0.00,0.00,0.00,3000.10,0.00,'2022-09-06 12:10:17','',''),(2641258,'5','174',NULL,397,'Sale Id shift 257739',956192.85,0.00,0.00,0.00,0.00,'2022-09-06 12:10:17','',''),(2641259,'5','174','899',397,'Sale Id shift 257740',0.00,0.00,0.00,2621.13,0.00,'2022-09-06 12:23:54','',''),(2641260,'5','174','900',397,'Sale Id shift 257740',0.00,0.00,0.00,2778.31,0.00,'2022-09-06 12:23:54','',''),(2641261,'5','174',NULL,397,'Sale Id shift 257740',998896.40,0.00,0.00,0.00,0.00,'2022-09-06 12:23:54','',''),(2641262,'5','174','900',397,'Sale Id shift 257741',0.00,0.00,0.00,5622.40,0.00,'2022-09-06 16:37:31','',''),(2641263,'5','174',NULL,397,'Sale Id shift 257741',1040144.00,0.00,0.00,0.00,0.00,'2022-09-06 16:37:31','',''),(2641264,'5','174','899',397,'Sale Id shift 257742',0.00,0.00,0.00,3908.16,0.00,'2022-09-06 16:55:00','',''),(2641265,'5','174','899',397,'Sale Id shift 257742',0.00,0.00,0.00,3012.19,0.00,'2022-09-06 16:55:00','',''),(2641266,'5','174',NULL,397,'Sale Id shift 257742',1280264.75,0.00,0.00,0.00,0.00,'2022-09-06 16:55:00','',''),(2641267,'5','174','899',397,'Sale Id shift 257743',0.00,0.00,0.00,2358.04,0.00,'2022-09-07 09:54:26','',''),(2641268,'5','174','900',397,'Sale Id shift 257743',0.00,0.00,0.00,4365.12,0.00,'2022-09-07 09:54:26','',''),(2641269,'5','174',NULL,397,'Sale Id shift 257743',1243784.60,0.00,0.00,0.00,0.00,'2022-09-07 09:54:26','',''),(2641270,'5','174','900',397,'Sale Id shift 257744',0.00,0.00,0.00,6845.03,0.00,'2022-09-07 10:03:37','',''),(2641271,'5','174',NULL,397,'Sale Id shift 257744',1266330.55,0.00,0.00,0.00,0.00,'2022-09-07 10:03:37','',''),(2641272,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5994000.00,32400.00,0.00,0.00,'2022-09-07 10:19:40','',''),(2641273,'5','174',NULL,397,'Reception corrector for bridging 132608',0.00,0.00,0.00,25000.00,0.00,'2022-09-07 12:30:07','',''),(2641274,'5','174','900',397,'Received from bridging 132608',0.00,0.00,25000.00,0.00,0.00,'2022-09-07 12:30:07','',''),(2641275,'5','174','900',397,'Sale Id shift 257745',0.00,0.00,0.00,6427.19,0.00,'2022-09-07 12:49:11','',''),(2641276,'5','174',NULL,397,'Sale Id shift 257745',1189030.15,0.00,0.00,0.00,0.00,'2022-09-07 12:49:11','',''),(2641277,'5','174','900',397,'Sale Id shift 257746',0.00,0.00,0.00,7104.02,0.00,'2022-09-07 13:08:11','',''),(2641278,'5','174',NULL,397,'Sale Id shift 257746',1314243.70,0.00,0.00,0.00,0.00,'2022-09-07 13:08:11','',''),(2641279,'5','174','900',397,'Sale Id shift 257747',0.00,0.00,0.00,5743.64,0.00,'2022-09-07 13:16:41','',''),(2641280,'5','174',NULL,397,'Sale Id shift 257747',1062573.40,0.00,0.00,0.00,0.00,'2022-09-07 13:16:41','',''),(2641281,'5','174','900',397,'Sale Id shift 257748',0.00,0.00,0.00,4812.48,0.00,'2022-09-07 13:22:25','',''),(2641282,'5','174',NULL,397,'Sale Id shift 257748',890308.80,0.00,0.00,0.00,0.00,'2022-09-07 13:22:25','',''),(2641283,'5','174','900',0,'Tank level zero out for dipping',0.00,0.00,0.00,4962.70,0.00,'2022-09-07 14:04:23','',''),(2641284,'5','174','900',0,'Inventory adjustment from tank dipping to 7400',0.00,0.00,7400.00,0.00,0.00,'2022-09-07 14:04:23','',''),(2641285,'5','174','900',397,'Sale Id shift 257749',0.00,0.00,0.00,5221.34,0.00,'2022-09-07 15:47:04','',''),(2641286,'5','174',NULL,397,'Sale Id shift 257749',965947.90,0.00,0.00,0.00,0.00,'2022-09-07 15:47:04','',''),(2641287,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-07 15:47:44','',''),(2641288,'5','174',NULL,397,'Reception corrector for bridging 132609',0.00,0.00,0.00,7400.00,0.00,'2022-09-07 15:55:54','',''),(2641289,'5','174','900',397,'Received from bridging 132609',0.00,0.00,7400.00,0.00,0.00,'2022-09-07 15:55:54','',''),(2641290,'5','174','900',397,'Sale Id shift 257750',0.00,0.00,0.00,4742.38,0.00,'2022-09-07 16:42:50','',''),(2641291,'5','174',NULL,397,'Sale Id shift 257750',877340.30,0.00,0.00,0.00,0.00,'2022-09-07 16:42:50','',''),(2641292,'5','174',NULL,397,'Reception corrector for bridging 132611',0.00,0.00,0.00,13000.00,0.00,'2022-09-07 16:52:07','',''),(2641293,'5','174','900',397,'Received from bridging 132611',0.00,0.00,13000.00,0.00,0.00,'2022-09-07 16:52:07','',''),(2641294,'5','174',NULL,397,'Reception corrector for bridging 132610',0.00,0.00,0.00,27000.00,0.00,'2022-09-07 16:52:15','',''),(2641295,'5','174','899',397,'Received from bridging 132610',0.00,0.00,27000.00,0.00,0.00,'2022-09-07 16:52:15','',''),(2641296,'5','174','900',397,'Sale Id shift 257751',0.00,0.00,0.00,2046.45,0.00,'2022-09-07 17:24:55','',''),(2641297,'5','174',NULL,397,'Sale Id shift 257751',378593.25,0.00,0.00,0.00,0.00,'2022-09-07 17:24:55','',''),(2641298,'5','174','900',397,'Sale Id shift 257752',0.00,0.00,0.00,3214.55,0.00,'2022-09-08 09:28:55','',''),(2641299,'5','174',NULL,397,'Sale Id shift 257752',594691.75,0.00,0.00,0.00,0.00,'2022-09-08 09:28:55','',''),(2641300,'5','174','900',397,'Sale Id shift 257753',0.00,0.00,0.00,5225.81,0.00,'2022-09-08 09:37:10','',''),(2641301,'5','174',NULL,397,'Sale Id shift 257753',966774.85,0.00,0.00,0.00,0.00,'2022-09-08 09:37:10','',''),(2641302,'5','174','899',397,'Sale Id shift 257754',0.00,0.00,0.00,6224.14,0.00,'2022-09-08 09:43:32','',''),(2641303,'5','174',NULL,397,'Sale Id shift 257754',1151465.90,0.00,0.00,0.00,0.00,'2022-09-08 09:43:33','',''),(2641304,'5','174','899',397,'Sale Id shift 257755',0.00,0.00,0.00,6011.02,0.00,'2022-09-08 09:49:07','',''),(2641305,'5','174',NULL,397,'Sale Id shift 257755',1112038.70,0.00,0.00,0.00,0.00,'2022-09-08 09:49:07','',''),(2641306,'5','174','899',397,'Sale Id shift 257756',0.00,0.00,0.00,5718.42,0.00,'2022-09-08 09:55:57','',''),(2641307,'5','174',NULL,397,'Sale Id shift 257756',1057907.70,0.00,0.00,0.00,0.00,'2022-09-08 09:55:57','',''),(2641308,'5','174','899',397,'Sale Id shift 257757',0.00,0.00,0.00,6144.52,0.00,'2022-09-08 10:00:10','',''),(2641309,'5','174',NULL,397,'Sale Id shift 257757',1136736.20,0.00,0.00,0.00,0.00,'2022-09-08 10:00:10','',''),(2641310,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-08 10:19:11','',''),(2641311,'5','174',NULL,397,'Reception corrector for bridging 132615',0.00,0.00,0.00,22500.00,0.00,'2022-09-08 10:47:24','',''),(2641312,'5','174','900',397,'Received from bridging 132615',0.00,0.00,22500.00,0.00,0.00,'2022-09-08 10:47:24','',''),(2641313,'5','174',NULL,397,'Reception corrector for bridging 132614',0.00,0.00,0.00,22500.00,0.00,'2022-09-08 10:47:33','',''),(2641314,'5','174','899',397,'Received from bridging 132614',0.00,0.00,22500.00,0.00,0.00,'2022-09-08 10:47:33','',''),(2641315,'5','174','899',397,'Sale Id shift 257758',0.00,0.00,0.00,3383.62,0.00,'2022-09-08 11:09:22','',''),(2641316,'5','174','899',397,'Sale Id shift 257758',0.00,0.00,0.00,6740.16,0.00,'2022-09-08 11:09:22','',''),(2641317,'5','174',NULL,397,'Sale Id shift 257758',1872899.30,0.00,0.00,0.00,0.00,'2022-09-08 11:09:22','',''),(2641318,'5','174','899',397,'Sale Id shift 257759',0.00,0.00,0.00,4909.54,0.00,'2022-09-08 11:18:44','',''),(2641319,'5','174','899',397,'Sale Id shift 257759',0.00,0.00,0.00,4237.67,0.00,'2022-09-08 11:18:44','',''),(2641320,'5','174','900',397,'Sale Id shift 257759',0.00,0.00,0.00,1857.08,0.00,'2022-09-08 11:18:44','',''),(2641321,'5','174',NULL,397,'Sale Id shift 257759',2035793.65,0.00,0.00,0.00,0.00,'2022-09-08 11:18:44','',''),(2641322,'5','174','899',397,'Sale Id shift 257760',0.00,0.00,0.00,3148.96,0.00,'2022-09-08 11:36:44','',''),(2641323,'5','174','900',397,'Sale Id shift 257760',0.00,0.00,0.00,8446.90,0.00,'2022-09-08 11:36:44','',''),(2641324,'5','174',NULL,397,'Sale Id shift 257760',2145234.10,0.00,0.00,0.00,0.00,'2022-09-08 11:36:44','',''),(2641325,'5','174','899',397,'Sale Id shift 257761',0.00,0.00,0.00,4608.31,0.00,'2022-09-08 11:49:59','',''),(2641326,'5','174','900',397,'Sale Id shift 257761',0.00,0.00,0.00,5628.19,0.00,'2022-09-08 11:49:59','',''),(2641327,'5','174',NULL,397,'Sale Id shift 257761',1893752.50,0.00,0.00,0.00,0.00,'2022-09-08 11:49:59','',''),(2641328,'5','174','900',397,'Sale Id shift 257762',0.00,0.00,0.00,5217.35,0.00,'2022-09-08 11:55:27','',''),(2641329,'5','174',NULL,397,'Sale Id shift 257762',965209.75,0.00,0.00,0.00,0.00,'2022-09-08 11:55:27','',''),(2641330,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11063000.00,59800.00,0.00,0.00,'2022-09-08 12:24:55','',''),(2641331,'5','174','900',397,'Sale Id shift 257763',0.00,0.00,0.00,6036.42,0.00,'2022-09-08 12:58:27','',''),(2641332,'5','174',NULL,397,'Sale Id shift 257763',1116737.70,0.00,0.00,0.00,0.00,'2022-09-08 12:58:27','',''),(2641333,'5','174',NULL,397,'Reception corrector for bridging 132616',0.00,0.00,0.00,30000.00,0.00,'2022-09-08 13:25:18','',''),(2641334,'5','174','899',397,'Received from bridging 132616',0.00,0.00,30000.00,0.00,0.00,'2022-09-08 13:25:18','',''),(2641335,'5','174','899',397,'Sale Id shift 257764',0.00,0.00,0.00,8816.21,0.00,'2022-09-08 16:23:12','',''),(2641336,'5','174',NULL,397,'Sale Id shift 257764',1630998.85,0.00,0.00,0.00,0.00,'2022-09-08 16:23:12','',''),(2641337,'5','174','899',397,'Sale Id shift 257765',0.00,0.00,0.00,10021.12,0.00,'2022-09-08 16:38:18','',''),(2641338,'5','174',NULL,397,'Sale Id shift 257765',1853907.20,0.00,0.00,0.00,0.00,'2022-09-08 16:38:18','',''),(2641339,'5','174',NULL,397,'Reception corrector for bridging 132617',0.00,0.00,0.00,15000.00,0.00,'2022-09-08 16:58:35','',''),(2641340,'5','174','899',397,'Received from bridging 132617',0.00,0.00,15000.00,0.00,0.00,'2022-09-08 16:58:35','',''),(2641341,'5','174',NULL,397,'Reception corrector for bridging 132618',0.00,0.00,0.00,14800.00,0.00,'2022-09-08 16:58:47','',''),(2641342,'5','174','900',397,'Received from bridging 132618',0.00,0.00,14800.00,0.00,0.00,'2022-09-08 16:58:47','',''),(2641343,'5','174','899',397,'Sale Id shift 257766',0.00,0.00,0.00,4013.31,0.00,'2022-09-09 09:27:00','',''),(2641344,'5','174','899',397,'Sale Id shift 257766',0.00,0.00,0.00,2592.57,0.00,'2022-09-09 09:27:00','',''),(2641345,'5','174','900',397,'Sale Id shift 257766',0.00,0.00,0.00,2405.96,0.00,'2022-09-09 09:27:00','',''),(2641346,'5','174',NULL,397,'Sale Id shift 257766',1667190.40,0.00,0.00,0.00,0.00,'2022-09-09 09:27:00','',''),(2641347,'5','174','899',397,'Sale Id shift 257767',0.00,0.00,0.00,5346.86,0.00,'2022-09-10 10:18:58','',''),(2641348,'5','174','899',397,'Sale Id shift 257767',0.00,0.00,0.00,5932.28,0.00,'2022-09-10 10:18:58','',''),(2641349,'5','174','900',397,'Sale Id shift 257767',0.00,0.00,0.00,2932.28,0.00,'2022-09-10 10:18:58','',''),(2641350,'5','174',NULL,397,'Sale Id shift 257767',2629112.70,0.00,0.00,0.00,0.00,'2022-09-10 10:18:58','',''),(2641351,'5','174','899',397,'Sale Id shift 257768',0.00,0.00,0.00,4625.96,0.00,'2022-09-12 06:25:55','',''),(2641352,'5','174',NULL,397,'Sale Id shift 257768',855802.60,0.00,0.00,0.00,0.00,'2022-09-12 06:25:55','',''),(2641353,'5','174','899',397,'Sale Id shift 257769',0.00,0.00,0.00,2003.06,0.00,'2022-09-12 09:37:11','',''),(2641354,'5','174','900',397,'Sale Id shift 257769',0.00,0.00,0.00,4020.01,0.00,'2022-09-12 09:37:11','',''),(2641355,'5','174',NULL,397,'Sale Id shift 257769',1114267.95,0.00,0.00,0.00,0.00,'2022-09-12 09:37:11','',''),(2641356,'5','174','900',397,'Sale Id shift 257770',0.00,0.00,0.00,4331.01,0.00,'2022-09-13 07:02:32','',''),(2641357,'5','174',NULL,397,'Sale Id shift 257770',801236.85,0.00,0.00,0.00,0.00,'2022-09-13 07:02:32','',''),(2641358,'5','174','900',397,'Sale Id shift 257771',0.00,0.00,0.00,1324.02,0.00,'2022-09-14 09:18:02','',''),(2641359,'5','174',NULL,397,'Sale Id shift 257771',244943.70,0.00,0.00,0.00,0.00,'2022-09-14 09:18:02','',''),(2641360,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7372250.00,39850.00,0.00,0.00,'2022-09-15 07:59:05','',''),(2641361,'5','174',NULL,397,'Reception corrector for bridging 132620',0.00,0.00,0.00,13000.00,0.00,'2022-09-15 11:04:50','',''),(2641362,'5','174','900',397,'Received from bridging 132620',0.00,0.00,13000.00,0.00,0.00,'2022-09-15 11:04:50','',''),(2641363,'5','174',NULL,397,'Reception corrector for bridging 132619',0.00,0.00,0.00,26850.00,0.00,'2022-09-15 18:37:45','',''),(2641364,'5','174','899',397,'Received from bridging 132619',0.00,0.00,26850.00,0.00,0.00,'2022-09-15 18:37:45','',''),(2641365,'5','174','899',397,'Sale Id shift 257772',0.00,0.00,0.00,2567.15,0.00,'2022-09-16 09:56:21','',''),(2641366,'5','174','900',397,'Sale Id shift 257772',0.00,0.00,0.00,3083.94,0.00,'2022-09-16 09:56:21','',''),(2641367,'5','174',NULL,397,'Sale Id shift 257772',1045451.65,0.00,0.00,0.00,0.00,'2022-09-16 09:56:21','',''),(2641368,'5','174','899',397,'Sale Id shift 257773',0.00,0.00,0.00,4443.32,0.00,'2022-09-16 11:01:07','',''),(2641369,'5','174','900',397,'Sale Id shift 257773',0.00,0.00,0.00,4232.92,0.00,'2022-09-16 11:01:07','',''),(2641370,'5','174',NULL,397,'Sale Id shift 257773',1605104.40,0.00,0.00,0.00,0.00,'2022-09-16 11:01:07','',''),(2641371,'5','174','899',397,'Sale Id shift 257774',0.00,0.00,0.00,3804.24,0.00,'2022-09-17 07:57:13','',''),(2641372,'5','174','900',397,'Sale Id shift 257774',0.00,0.00,0.00,4355.75,0.00,'2022-09-17 07:57:13','',''),(2641373,'5','174',NULL,397,'Sale Id shift 257774',1509598.15,0.00,0.00,0.00,0.00,'2022-09-17 07:57:13','',''),(2641374,'5','174','899',397,'Sale Id shift 257775',0.00,0.00,0.00,6330.21,0.00,'2022-09-18 10:40:14','',''),(2641375,'5','174',NULL,397,'Sale Id shift 257775',1171088.85,0.00,0.00,0.00,0.00,'2022-09-18 10:40:14','',''),(2641376,'5','174','899',397,'Sale Id shift 257776',0.00,0.00,0.00,6319.27,0.00,'2022-09-19 10:48:31','',''),(2641377,'5','174',NULL,397,'Sale Id shift 257776',1169064.95,0.00,0.00,0.00,0.00,'2022-09-19 10:48:31','',''),(2641378,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8241750.00,44550.00,0.00,0.00,'2022-09-20 11:45:18','',''),(2641379,'5','174',NULL,397,'Reception corrector for bridging 132621',0.00,0.00,0.00,14550.00,0.00,'2022-09-20 15:04:59','',''),(2641380,'5','174','899',397,'Received from bridging 132621',0.00,0.00,14550.00,0.00,0.00,'2022-09-20 15:04:59','',''),(2641381,'5','174','899',397,'Sale Id shift 257777',0.00,0.00,0.00,9558.04,0.00,'2022-09-20 16:53:55','',''),(2641382,'5','174','900',397,'Sale Id shift 257777',0.00,0.00,0.00,2009.35,0.00,'2022-09-20 16:53:55','',''),(2641383,'5','174',NULL,397,'Sale Id shift 257777',2139967.15,0.00,0.00,0.00,0.00,'2022-09-20 16:53:55','',''),(2641384,'5','174','899',397,'Sale Id shift 257778',0.00,0.00,0.00,6772.75,0.00,'2022-09-21 07:10:37','',''),(2641385,'5','174',NULL,397,'Sale Id shift 257778',1252958.75,0.00,0.00,0.00,0.00,'2022-09-21 07:10:37','',''),(2641386,'5','174',NULL,397,'Reception corrector for bridging 132622',0.00,0.00,0.00,30000.00,0.00,'2022-09-21 22:35:41','',''),(2641387,'5','174','900',397,'Received from bridging 132622',0.00,0.00,30000.00,0.00,0.00,'2022-09-21 22:35:41','',''),(2641388,'5','174','900',397,'Sale Id shift 257779',0.00,0.00,0.00,10226.14,0.00,'2022-09-22 09:17:08','',''),(2641389,'5','174',NULL,397,'Sale Id shift 257779',1891835.90,0.00,0.00,0.00,0.00,'2022-09-22 09:17:08','',''),(2641390,'5','174','900',397,'Sale Id shift 257780',0.00,0.00,0.00,8403.24,0.00,'2022-09-23 10:20:13','',''),(2641391,'5','174',NULL,397,'Sale Id shift 257780',1554599.40,0.00,0.00,0.00,0.00,'2022-09-23 10:20:13','',''),(2641392,'5','174','900',397,'Sale Id shift 257781',0.00,0.00,0.00,6544.65,0.00,'2022-09-24 08:51:51','',''),(2641393,'5','174',NULL,397,'Sale Id shift 257781',1210760.25,0.00,0.00,0.00,0.00,'2022-09-24 08:51:51','',''),(2641394,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-25 07:01:57','',''),(2641395,'5','174','899',397,'Sale Id shift 257782',0.00,0.00,0.00,3750.21,0.00,'2022-09-25 07:03:11','',''),(2641396,'5','174','900',397,'Sale Id shift 257782',0.00,0.00,0.00,2000.29,0.00,'2022-09-25 07:03:11','',''),(2641397,'5','174',NULL,397,'Sale Id shift 257782',1063842.50,0.00,0.00,0.00,0.00,'2022-09-25 07:03:11','',''),(2641398,'5','174',NULL,397,'Reception corrector for bridging 132624',0.00,0.00,0.00,13000.00,0.00,'2022-09-26 09:08:42','',''),(2641399,'5','174','900',397,'Received from bridging 132624',0.00,0.00,13000.00,0.00,0.00,'2022-09-26 09:08:42','',''),(2641400,'5','174',NULL,397,'Reception corrector for bridging 132623',0.00,0.00,0.00,27000.00,0.00,'2022-09-26 09:08:53','',''),(2641401,'5','174','899',397,'Received from bridging 132623',0.00,0.00,27000.00,0.00,0.00,'2022-09-26 09:08:53','',''),(2641402,'5','174','899',397,'Sale Id shift 257783',0.00,0.00,0.00,8366.80,0.00,'2022-09-26 10:06:15','',''),(2641403,'5','174',NULL,397,'Sale Id shift 257783',1547858.00,0.00,0.00,0.00,0.00,'2022-09-26 10:06:15','',''),(2641404,'5','174','899',397,'Sale Id shift 257784',0.00,0.00,0.00,2005.00,0.00,'2022-09-27 13:27:26','',''),(2641405,'5','174','900',397,'Sale Id shift 257784',0.00,0.00,0.00,9211.06,0.00,'2022-09-27 13:27:26','',''),(2641406,'5','174',NULL,397,'Sale Id shift 257784',2074971.10,0.00,0.00,0.00,0.00,'2022-09-27 13:27:26','',''),(2641407,'5','174','899',397,'Sale Id shift 257785',0.00,0.00,0.00,8377.66,0.00,'2022-09-28 06:41:30','',''),(2641408,'5','174',NULL,397,'Sale Id shift 257785',1549867.10,0.00,0.00,0.00,0.00,'2022-09-28 06:41:30','',''),(2641409,'5','174','899',397,'Sale Id shift 257786',0.00,0.00,0.00,4021.81,0.00,'2022-09-29 07:14:21','',''),(2641410,'5','174','900',397,'Sale Id shift 257786',0.00,0.00,0.00,6503.26,0.00,'2022-09-29 07:14:21','',''),(2641411,'5','174',NULL,397,'Sale Id shift 257786',1947137.95,0.00,0.00,0.00,0.00,'2022-09-29 07:14:21','',''),(2641412,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-29 15:37:31','',''),(2641413,'5','174',NULL,397,'Reception corrector for bridging 132625',0.00,0.00,0.00,17000.00,0.00,'2022-09-29 16:28:32','',''),(2641414,'5','174','899',397,'Received from bridging 132625',0.00,0.00,17000.00,0.00,0.00,'2022-09-29 16:28:32','',''),(2641415,'5','174','899',397,'Sale Id shift 257787',0.00,0.00,0.00,13778.56,0.00,'2022-09-30 07:23:49','',''),(2641416,'5','174',NULL,397,'Sale Id shift 257787',2549033.60,0.00,0.00,0.00,0.00,'2022-09-30 07:23:49','',''),(2641417,'5','174',NULL,397,'Reception corrector for bridging 132629',0.00,0.00,0.00,17000.00,0.00,'2022-10-02 07:39:03','',''),(2641418,'5','174','900',397,'Received from bridging 132629',0.00,0.00,17000.00,0.00,0.00,'2022-10-02 07:39:03','',''),(2641419,'5','174',NULL,397,'Reception corrector for bridging 132628',0.00,0.00,0.00,16000.00,0.00,'2022-10-02 07:39:36','',''),(2641420,'5','174','899',397,'Received from bridging 132628',0.00,0.00,16000.00,0.00,0.00,'2022-10-02 07:39:36','',''),(2641421,'5','174','899',397,'Sale Id shift 257788',0.00,0.00,0.00,17357.98,0.00,'2022-10-02 09:54:41','',''),(2641422,'5','174',NULL,397,'Sale Id shift 257788',3211226.30,0.00,0.00,0.00,0.00,'2022-10-02 09:54:41','',''),(2641423,'5','174','900',397,'Sale Id shift 257789',0.00,0.00,0.00,10221.12,0.00,'2022-10-02 10:40:22','',''),(2641424,'5','174',NULL,397,'Sale Id shift 257789',1890907.20,0.00,0.00,0.00,0.00,'2022-10-02 10:40:22','',''),(2641425,'5','174','899',397,'Sale Id shift 257790',0.00,0.00,0.00,2835.04,0.00,'2022-10-03 09:48:52','',''),(2641426,'5','174','900',397,'Sale Id shift 257790',0.00,0.00,0.00,4281.66,0.00,'2022-10-03 09:48:52','',''),(2641427,'5','174',NULL,397,'Sale Id shift 257790',1316589.50,0.00,0.00,0.00,0.00,'2022-10-03 09:48:52','',''),(2641428,'5','174','899',397,'Sale Id shift 257791',0.00,0.00,0.00,3096.27,0.00,'2022-10-04 07:13:06','',''),(2641429,'5','174',NULL,397,'Sale Id shift 257791',572809.95,0.00,0.00,0.00,0.00,'2022-10-04 07:13:06','',''),(2641430,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-10-18 09:38:13','',''),(2641431,'5','174',NULL,397,'Reception corrector for bridging 132631',0.00,0.00,0.00,17000.00,0.00,'2022-10-18 10:04:57','',''),(2641432,'5','174','900',397,'Received from bridging 132631',0.00,0.00,17000.00,0.00,0.00,'2022-10-18 10:04:57','',''),(2641433,'5','174',NULL,397,'Reception corrector for bridging 132630',0.00,0.00,0.00,33000.00,0.00,'2022-10-18 10:05:08','',''),(2641434,'5','174','899',397,'Received from bridging 132630',0.00,0.00,33000.00,0.00,0.00,'2022-10-18 10:05:08','',''),(2641435,'5','174','899',397,'Sale Id shift 257805',0.00,0.00,0.00,3824.63,0.00,'2022-10-18 18:32:46','',''),(2641436,'5','174',NULL,397,'Sale Id shift 257805',707556.55,0.00,0.00,0.00,0.00,'2022-10-18 18:32:46','',''),(2641437,'5','174','899',397,'Sale Id shift 257806',0.00,0.00,0.00,3618.76,0.00,'2022-10-19 09:47:12','',''),(2641438,'5','174','899',397,'Sale Id shift 257806',0.00,0.00,0.00,4446.49,0.00,'2022-10-19 09:47:12','',''),(2641439,'5','174',NULL,397,'Sale Id shift 257806',1492071.25,0.00,0.00,0.00,0.00,'2022-10-19 09:47:12','',''),(2641440,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3422500.00,18500.00,0.00,0.00,'2022-10-19 14:59:00','',''),(2641441,'5','174',NULL,397,'Reception corrector for bridging 132632',0.00,0.00,0.00,18500.00,0.00,'2022-10-19 16:39:19','',''),(2641442,'5','174','901',397,'Received from bridging 132632',0.00,0.00,18500.00,0.00,0.00,'2022-10-19 16:39:19','',''),(2641443,'5','174','899',397,'Sale Id shift 257807',0.00,0.00,0.00,5531.47,0.00,'2022-10-20 11:15:01','',''),(2641444,'5','174','900',397,'Sale Id shift 257807',0.00,0.00,0.00,3623.17,0.00,'2022-10-20 11:15:01','',''),(2641445,'5','174',NULL,397,'Sale Id shift 257807',1693608.40,0.00,0.00,0.00,0.00,'2022-10-20 11:15:01','',''),(2641446,'5','174','900',397,'Sale Id shift 257808',0.00,0.00,0.00,8071.12,0.00,'2022-10-21 09:35:15','',''),(2641447,'5','174',NULL,397,'Sale Id shift 257808',1493157.20,0.00,0.00,0.00,0.00,'2022-10-21 09:35:15','',''),(2641448,'5','174','899',397,'Sale Id shift 257809',0.00,0.00,0.00,7821.16,0.00,'2022-10-22 10:06:02','',''),(2641449,'5','174',NULL,397,'Sale Id shift 257809',1446914.60,0.00,0.00,0.00,0.00,'2022-10-22 10:06:02','',''),(2641450,'5','174','900',397,'Sale Id shift 257810',0.00,0.00,0.00,7123.52,0.00,'2022-10-23 10:23:37','',''),(2641451,'5','174',NULL,397,'Sale Id shift 257810',1317851.20,0.00,0.00,0.00,0.00,'2022-10-23 10:23:37','',''),(2641452,'5','174','899',397,'Sale Id shift 257811',0.00,0.00,0.00,6418.24,0.00,'2022-10-24 07:32:48','',''),(2641453,'5','174',NULL,397,'Sale Id shift 257811',1187374.40,0.00,0.00,0.00,0.00,'2022-10-24 07:32:48','',''),(2641454,'5','174','901',397,'Sale Id shift 257812',0.00,0.00,0.00,5623.52,0.00,'2022-10-25 09:26:40','',''),(2641455,'5','174',NULL,397,'Sale Id shift 257812',1040351.20,0.00,0.00,0.00,0.00,'2022-10-25 09:26:40','',''),(2641456,'5','174','901',397,'Sale Id shift 257813',0.00,0.00,0.00,4611.02,0.00,'2022-10-26 06:09:45','',''),(2641457,'5','174',NULL,397,'Sale Id shift 257813',853038.70,0.00,0.00,0.00,0.00,'2022-10-26 06:09:45','',''),(2641458,'5','174','901',397,'Sale Id shift 257814',0.00,0.00,0.00,7011.33,0.00,'2022-10-27 07:03:16','',''),(2641459,'5','174',NULL,397,'Sale Id shift 257814',1297096.05,0.00,0.00,0.00,0.00,'2022-10-27 07:03:16','',''),(2641460,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-11-01 17:49:49','',''),(2641461,'5','174',NULL,397,'Reception corrector for bridging 132633',0.00,0.00,0.00,15000.00,0.00,'2022-11-01 20:01:38','',''),(2641462,'5','174','899',397,'Received from bridging 132633',0.00,0.00,15000.00,0.00,0.00,'2022-11-01 20:01:38','',''),(2641463,'5','174','899',397,'Sale Id shift 257820',0.00,0.00,0.00,3124.52,0.00,'2022-11-02 07:08:15','',''),(2641464,'5','174',NULL,397,'Sale Id shift 257820',578036.20,0.00,0.00,0.00,0.00,'2022-11-02 07:08:15','',''),(2641465,'5','174','899',397,'Sale Id shift 257821',0.00,0.00,0.00,4629.33,0.00,'2022-11-03 06:38:21','',''),(2641466,'5','174','899',397,'Sale Id shift 257821',0.00,0.00,0.00,4005.06,0.00,'2022-11-03 06:38:21','',''),(2641467,'5','174',NULL,397,'Sale Id shift 257821',1597362.15,0.00,0.00,0.00,0.00,'2022-11-03 06:38:21','',''),(2641468,'5','174','899',397,'Sale Id shift 257822',0.00,0.00,0.00,3251.01,0.00,'2022-11-04 07:03:16','',''),(2641469,'5','174',NULL,397,'Sale Id shift 257822',601436.85,0.00,0.00,0.00,0.00,'2022-11-04 07:03:16','',''),(2641470,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2756500.00,14900.00,0.00,0.00,'2022-11-07 06:26:38','',''),(2641471,'5','174',NULL,397,'Reception corrector for bridging 132634',0.00,0.00,0.00,14900.00,0.00,'2022-11-07 09:35:18','',''),(2641472,'5','174','899',397,'Received from bridging 132634',0.00,0.00,14900.00,0.00,0.00,'2022-11-07 09:35:18','',''),(2641473,'5','174','899',397,'Sale Id shift 257825',0.00,0.00,0.00,6124.04,0.00,'2022-11-07 14:16:57','',''),(2641474,'5','174',NULL,397,'Sale Id shift 257825',1132947.40,0.00,0.00,0.00,0.00,'2022-11-07 14:16:57','',''),(2641475,'5','174','899',397,'Sale Id shift 257826',0.00,0.00,0.00,5072.16,0.00,'2022-11-08 07:51:28','',''),(2641476,'5','174',NULL,397,'Sale Id shift 257826',938349.60,0.00,0.00,0.00,0.00,'2022-11-08 07:51:28','',''),(2641477,'5','174','899',397,'Sale Id shift 257827',0.00,0.00,0.00,3614.03,0.00,'2022-11-09 08:39:18','',''),(2641478,'5','174',NULL,397,'Sale Id shift 257827',668595.55,0.00,0.00,0.00,0.00,'2022-11-09 08:39:18','',''),(2641479,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2506750.00,13550.00,0.00,0.00,'2022-11-19 09:12:46','',''),(2641480,'5','174',NULL,397,'Reception corrector for bridging 132635',0.00,0.00,0.00,13550.00,0.00,'2022-11-19 19:51:21','',''),(2641481,'5','174','899',397,'Received from bridging 132635',0.00,0.00,13550.00,0.00,0.00,'2022-11-19 19:51:21','',''),(2641482,'5','174','899',397,'Sale Id shift 257837',0.00,0.00,0.00,4123.00,0.00,'2022-11-20 07:30:29','',''),(2641483,'5','174',NULL,397,'Sale Id shift 257837',762755.00,0.00,0.00,0.00,0.00,'2022-11-20 07:30:29','',''),(2641484,'5','174','899',397,'Sale Id shift 257838',0.00,0.00,0.00,6345.00,0.00,'2022-11-21 09:37:50','',''),(2641485,'5','174',NULL,397,'Sale Id shift 257838',1173825.00,0.00,0.00,0.00,0.00,'2022-11-21 09:37:50','',''),(2641486,'5','174','899',397,'Sale Id shift 257839',0.00,0.00,0.00,3245.00,0.00,'2022-11-21 14:11:54','',''),(2641487,'5','174',NULL,397,'Sale Id shift 257839',600325.00,0.00,0.00,0.00,0.00,'2022-11-21 14:11:54','',''),(2641488,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5429750.00,29350.00,0.00,0.00,'2022-11-22 09:05:36','',''),(2641489,'5','174',NULL,397,'Reception corrector for bridging 132636',0.00,0.00,0.00,29350.00,0.00,'2022-11-22 14:23:26','',''),(2641490,'5','174','899',397,'Received from bridging 132636',0.00,0.00,29350.00,0.00,0.00,'2022-11-22 14:23:26','',''),(2641491,'5','174','899',397,'Sale Id shift 257840',0.00,0.00,0.00,3851.99,0.00,'2022-11-23 09:39:34','',''),(2641492,'5','174',NULL,397,'Sale Id shift 257840',712618.15,0.00,0.00,0.00,0.00,'2022-11-23 09:39:34','',''),(2641493,'5','174','899',397,'Sale Id shift 257842',0.00,0.00,0.00,6713.46,0.00,'2022-11-24 13:09:55','',''),(2641494,'5','174',NULL,397,'Sale Id shift 257842',1241990.10,0.00,0.00,0.00,0.00,'2022-11-24 13:09:55','',''),(2641495,'5','174','899',397,'Sale Id shift 257843',0.00,0.00,0.00,7014.05,0.00,'2022-11-24 16:46:49','',''),(2641496,'5','174',NULL,397,'Sale Id shift 257843',1297599.25,0.00,0.00,0.00,0.00,'2022-11-24 16:46:49','',''),(2641497,'5','174','899',397,'Sale Id shift 257844',0.00,0.00,0.00,8256.50,0.00,'2022-11-25 11:15:37','',''),(2641498,'5','174',NULL,397,'Sale Id shift 257844',1527452.50,0.00,0.00,0.00,0.00,'2022-11-25 11:15:37','',''),(2641499,'5','174','899',397,'Sale Id shift 257845',0.00,0.00,0.00,3213.21,0.00,'2022-11-26 07:46:56','',''),(2641500,'5','174',NULL,397,'Sale Id shift 257845',594443.85,0.00,0.00,0.00,0.00,'2022-11-26 07:46:56','',''),(2641501,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2590000.00,14000.00,0.00,0.00,'2022-11-27 08:56:33','',''),(2641502,'5','174',NULL,397,'Reception corrector for bridging 132637',0.00,0.00,0.00,14000.00,0.00,'2022-11-27 11:24:18','',''),(2641503,'5','174','899',397,'Received from bridging 132637',0.00,0.00,14000.00,0.00,0.00,'2022-11-27 11:24:18','',''),(2641504,'5','174','899',397,'Sale Id shift 257846',0.00,0.00,0.00,3213.45,0.00,'2022-11-27 12:32:01','',''),(2641505,'5','174',NULL,397,'Sale Id shift 257846',594488.25,0.00,0.00,0.00,0.00,'2022-11-27 12:32:01','',''),(2641506,'5','174','899',397,'Sale Id shift 257847',0.00,0.00,0.00,6058.09,0.00,'2022-11-28 09:47:52','',''),(2641507,'5','174',NULL,397,'Sale Id shift 257847',1120746.65,0.00,0.00,0.00,0.00,'2022-11-28 09:47:52','',''),(2641508,'5','174','899',397,'Sale Id shift 257848',0.00,0.00,0.00,1754.06,0.00,'2022-11-29 09:46:11','',''),(2641509,'5','174',NULL,397,'Sale Id shift 257848',324501.10,0.00,0.00,0.00,0.00,'2022-11-29 09:46:11','',''),(2641510,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3080250.00,16650.00,0.00,0.00,'2023-01-16 08:20:26','',''),(2641511,'5','174',NULL,397,'Reception corrector for bridging 132638',0.00,0.00,0.00,16650.00,0.00,'2023-01-16 09:42:55','',''),(2641512,'5','174','899',397,'Received from bridging 132638',0.00,0.00,16650.00,0.00,0.00,'2023-01-16 09:42:55','',''),(2641513,'5','174','899',397,'Sale Id shift 257915',0.00,0.00,0.00,3122.58,0.00,'2023-01-16 11:02:13','',''),(2641514,'5','174',NULL,397,'Sale Id shift 257915',577677.30,0.00,0.00,0.00,0.00,'2023-01-16 11:02:13','',''),(2641515,'5','174','899',397,'Sale Id shift 257925',0.00,0.00,0.00,7143.48,0.00,'2023-01-17 10:24:35','',''),(2641516,'5','174',NULL,397,'Sale Id shift 257925',1321543.80,0.00,0.00,0.00,0.00,'2023-01-17 10:24:35','',''),(2641517,'5','174','899',397,'Sale Id shift 257926',0.00,0.00,0.00,5314.49,0.00,'2023-01-17 10:30:32','',''),(2641518,'5','174',NULL,397,'Sale Id shift 257926',983180.65,0.00,0.00,0.00,0.00,'2023-01-17 10:30:32','',''),(2641519,'5','174','899',397,'Sale Id shift 257927',0.00,0.00,0.00,1124.52,0.00,'2023-01-18 09:17:43','',''),(2641520,'5','174',NULL,397,'Sale Id shift 257927',208036.20,0.00,0.00,0.00,0.00,'2023-01-18 09:17:43','',''),(2641521,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6578000.00,29900.00,0.00,0.00,'2023-01-23 09:05:43','',''),(2641522,'5','174',NULL,397,'Reception corrector for bridging 132640',0.00,0.00,0.00,14900.00,0.00,'2023-01-23 11:58:24','',''),(2641523,'5','174','900',397,'Received from bridging 132640',0.00,0.00,14900.00,0.00,0.00,'2023-01-23 11:58:24','',''),(2641524,'5','174','900',397,'Sale Id shift 257932',0.00,0.00,0.00,5312.81,0.00,'2023-01-23 16:58:57','',''),(2641525,'5','174',NULL,397,'Sale Id shift 257932',982869.85,0.00,0.00,0.00,0.00,'2023-01-23 16:58:57','',''),(2641526,'5','174','900',397,'Sale Id shift 257933',0.00,0.00,0.00,8431.40,0.00,'2023-01-24 15:29:39','',''),(2641527,'5','174',NULL,397,'Sale Id shift 257933',1854908.00,0.00,0.00,0.00,0.00,'2023-01-24 15:29:39','',''),(2641528,'5','174','899',397,'Sale Id shift 257934',0.00,0.00,0.00,4100.06,0.00,'2023-01-25 09:33:36','',''),(2641529,'5','174','900',397,'Sale Id shift 257934',0.00,0.00,0.00,3021.80,0.00,'2023-01-25 09:33:36','',''),(2641530,'5','174',NULL,397,'Sale Id shift 257934',1566809.20,0.00,0.00,0.00,0.00,'2023-01-25 09:33:36','',''),(2641531,'5','174',NULL,397,'Reception corrector for bridging 132639',0.00,0.00,0.00,15000.00,0.00,'2023-01-26 10:53:06','',''),(2641532,'5','174','899',397,'Received from bridging 132639',0.00,0.00,15000.00,0.00,0.00,'2023-01-26 10:53:06','',''),(2641533,'5','174','899',397,'Sale Id shift 257935',0.00,0.00,0.00,7311.46,0.00,'2023-01-26 13:34:47','',''),(2641534,'5','174',NULL,397,'Sale Id shift 257935',1608521.20,0.00,0.00,0.00,0.00,'2023-01-26 13:34:47','',''),(2641535,'5','174','899',397,'Sale Id shift 257936',0.00,0.00,0.00,1711.47,0.00,'2023-01-27 09:46:08','',''),(2641536,'5','174',NULL,397,'Sale Id shift 257936',376523.40,0.00,0.00,0.00,0.00,'2023-01-27 09:46:08','',''),(2641537,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6600000.00,30000.00,0.00,0.00,'2023-02-03 10:23:53','',''),(2641538,'5','174',NULL,397,'Reception corrector for bridging 132642',0.00,0.00,0.00,15000.00,0.00,'2023-02-03 13:10:19','',''),(2641539,'5','174','900',397,'Received from bridging 132642',0.00,0.00,15000.00,0.00,0.00,'2023-02-03 13:10:19','',''),(2641540,'5','174',NULL,397,'Reception corrector for bridging 132641',0.00,0.00,0.00,15000.00,0.00,'2023-02-03 13:10:32','',''),(2641541,'5','174','899',397,'Received from bridging 132641',0.00,0.00,15000.00,0.00,0.00,'2023-02-03 13:10:32','',''),(2641542,'5','174','899',397,'Sale Id shift 257943',0.00,0.00,0.00,3253.87,0.00,'2023-02-03 16:16:14','',''),(2641543,'5','174',NULL,397,'Sale Id shift 257943',715851.40,0.00,0.00,0.00,0.00,'2023-02-03 16:16:14','',''),(2641544,'5','174','899',397,'Sale Id shift 257944',0.00,0.00,0.00,9364.36,0.00,'2023-02-04 13:21:46','',''),(2641545,'5','174',NULL,397,'Sale Id shift 257944',2060159.20,0.00,0.00,0.00,0.00,'2023-02-04 13:21:46','',''),(2641546,'5','174','900',397,'Sale Id shift 257945',0.00,0.00,0.00,8132.05,0.00,'2023-02-05 11:53:15','',''),(2641547,'5','174',NULL,397,'Sale Id shift 257945',1789051.00,0.00,0.00,0.00,0.00,'2023-02-05 11:53:15','',''),(2641548,'5','174','899',397,'Sale Id shift 257946',0.00,0.00,0.00,7142.13,0.00,'2023-02-06 09:09:48','',''),(2641549,'5','174',NULL,397,'Sale Id shift 257946',1571268.60,0.00,0.00,0.00,0.00,'2023-02-06 09:09:48','',''),(2641550,'5','174','900',397,'Sale Id shift 257947',0.00,0.00,0.00,2126.78,0.00,'2023-02-07 09:10:37','',''),(2641551,'5','174',NULL,397,'Sale Id shift 257947',467891.60,0.00,0.00,0.00,0.00,'2023-02-07 09:10:37','',''),(2641552,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3300000.00,15000.00,0.00,0.00,'2023-02-12 06:00:07','',''),(2641553,'5','174',NULL,397,'Reception corrector for bridging 132643',0.00,0.00,0.00,15000.00,0.00,'2023-02-12 09:37:40','',''),(2641554,'5','174','899',397,'Received from bridging 132643',0.00,0.00,15000.00,0.00,0.00,'2023-02-12 09:37:40','',''),(2641555,'5','174','899',397,'Sale Id shift 257951',0.00,0.00,0.00,3165.09,0.00,'2023-02-12 13:23:22','',''),(2641556,'5','174',NULL,397,'Sale Id shift 257951',696319.80,0.00,0.00,0.00,0.00,'2023-02-12 13:23:22','',''),(2641557,'5','174','899',397,'Sale Id shift 257952',0.00,0.00,0.00,8214.01,0.00,'2023-02-12 15:37:09','',''),(2641558,'5','174',NULL,397,'Sale Id shift 257952',1807082.20,0.00,0.00,0.00,0.00,'2023-02-12 15:37:09','',''),(2641559,'5','174','899',397,'Sale Id shift 257953',0.00,0.00,0.00,3651.00,0.00,'2023-02-13 09:15:20','',''),(2641560,'5','174',NULL,397,'Sale Id shift 257953',803220.00,0.00,0.00,0.00,0.00,'2023-02-13 09:15:20','',''),(2641561,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8400000.00,40000.00,0.00,0.00,'2023-02-25 10:27:25','',''),(2641562,'5','174',NULL,397,'Reception corrector for bridging 132645',0.00,0.00,0.00,13500.00,0.00,'2023-02-25 13:35:26','',''),(2641563,'5','174','900',397,'Received from bridging 132645',0.00,0.00,13500.00,0.00,0.00,'2023-02-25 13:35:26','',''),(2641564,'5','174',NULL,397,'Reception corrector for bridging 132644',0.00,0.00,0.00,26500.00,0.00,'2023-02-25 13:35:38','',''),(2641565,'5','174','899',397,'Received from bridging 132644',0.00,0.00,26500.00,0.00,0.00,'2023-02-25 13:35:38','',''),(2641566,'5','174','899',397,'Sale Id shift 257965',0.00,0.00,0.00,3345.00,0.00,'2023-02-25 15:53:28','',''),(2641567,'5','174',NULL,397,'Sale Id shift 257965',735900.00,0.00,0.00,0.00,0.00,'2023-02-25 15:53:28','',''),(2641568,'5','174','899',397,'Sale Id shift 257966',0.00,0.00,0.00,3143.21,0.00,'2023-02-26 11:14:32','',''),(2641569,'5','174',NULL,397,'Sale Id shift 257966',660074.10,0.00,0.00,0.00,0.00,'2023-02-26 11:14:32','',''),(2641570,'5','174','900',397,'Sale Id shift 257967',0.00,0.00,0.00,1237.26,0.00,'2023-02-27 15:41:11','',''),(2641571,'5','174',NULL,397,'Sale Id shift 257967',259824.60,0.00,0.00,0.00,0.00,'2023-02-27 15:41:11','',''),(2641572,'5','174','899',397,'Sale Id shift 257969',0.00,0.00,0.00,11100.06,0.00,'2023-02-28 15:39:09','',''),(2641573,'5','174','900',397,'Sale Id shift 257969',0.00,0.00,0.00,11552.46,0.00,'2023-02-28 15:39:09','',''),(2641574,'5','174',NULL,397,'Sale Id shift 257969',4757029.20,0.00,0.00,0.00,0.00,'2023-02-28 15:39:09','',''),(2641575,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,10500000.00,50000.00,0.00,0.00,'2023-03-02 10:05:55','',''),(2641576,'5','174',NULL,397,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8368500.00,39850.00,0.00,0.00,'2023-03-02 13:56:25','',''),(2641577,'5','174',NULL,397,'Reception corrector for bridging 132646',0.00,0.00,0.00,13500.00,0.00,'2023-03-02 18:28:38','',''),(2641578,'5','174','899',397,'Received from bridging 132646',0.00,0.00,13500.00,0.00,0.00,'2023-03-02 18:28:38','',''),(2641579,'5','174',NULL,397,'Reception corrector for bridging 132647',0.00,0.00,0.00,26350.00,0.00,'2023-03-02 18:28:54','',''),(2641580,'5','174','901',397,'Received from bridging 132647',0.00,0.00,26350.00,0.00,0.00,'2023-03-02 18:28:54','',''),(2641581,'5','174','899',397,'Sale Id shift 257970',0.00,0.00,0.00,4627.41,0.00,'2023-03-03 09:24:06','',''),(2641582,'5','174','901',397,'Sale Id shift 257970',0.00,0.00,0.00,15072.08,0.00,'2023-03-03 09:24:06','',''),(2641583,'5','174',NULL,397,'Sale Id shift 257970',4136892.90,0.00,0.00,0.00,0.00,'2023-03-03 09:24:06','',''),(2641584,'5','174','899',397,'Sale Id shift 257971',0.00,0.00,0.00,14427.52,0.00,'2023-03-04 08:48:55','',''),(2641585,'5','174','901',397,'Sale Id shift 257971',0.00,0.00,0.00,7824.05,0.00,'2023-03-04 08:48:55','',''),(2641586,'5','174',NULL,397,'Sale Id shift 257971',4672829.70,0.00,0.00,0.00,0.00,'2023-03-04 08:48:55','',''),(2641587,'5','174',NULL,397,'Reception corrector for bridging 132649',0.00,0.00,0.00,17000.00,0.00,'2023-03-05 10:30:45','',''),(2641588,'5','174','900',397,'Received from bridging 132649',0.00,0.00,17000.00,0.00,0.00,'2023-03-05 10:30:45','',''),(2641589,'5','174','900',397,'Sale Id shift 257972',0.00,0.00,0.00,13100.06,0.00,'2023-03-05 13:39:21','',''),(2641590,'5','174',NULL,397,'Sale Id shift 257972',2751012.60,0.00,0.00,0.00,0.00,'2023-03-05 13:39:21','',''),(2641591,'5','174',NULL,397,'Reception corrector for bridging 132651',0.00,0.00,0.00,17000.00,0.00,'2023-03-05 16:42:42','',''),(2641592,'5','174','900',397,'Received from bridging 132651',0.00,0.00,17000.00,0.00,0.00,'2023-03-05 16:42:42','',''),(2641593,'5','174','900',397,'Sale Id shift 257973',0.00,0.00,0.00,11374.26,0.00,'2023-03-05 19:58:30','',''),(2641594,'5','174',NULL,397,'Sale Id shift 257973',2388594.60,0.00,0.00,0.00,0.00,'2023-03-05 19:58:30','',''),(2641595,'5','174','900',397,'Sale Id shift 257974',0.00,0.00,0.00,10462.70,0.00,'2023-03-06 09:02:20','',''),(2641596,'5','174',NULL,397,'Sale Id shift 257974',2197167.00,0.00,0.00,0.00,0.00,'2023-03-06 09:02:20','',''),(2641597,'5','174','899',397,'Sale Id shift 257975',0.00,0.00,0.00,3918.30,0.00,'2023-03-07 09:27:30','',''),(2641598,'5','174','900',397,'Sale Id shift 257975',0.00,0.00,0.00,3820.22,0.00,'2023-03-07 09:27:30','',''),(2641599,'5','174','901',397,'Sale Id shift 257975',0.00,0.00,0.00,1886.20,0.00,'2023-03-07 09:27:30','',''),(2641600,'5','174',NULL,397,'Sale Id shift 257975',2021191.20,0.00,0.00,0.00,0.00,'2023-03-07 09:27:30','',''),(2641601,'5','174','899',397,'Sale Id shift 257976',0.00,0.00,0.00,1000.16,0.00,'2023-03-08 09:54:23','',''),(2641602,'5','174','899',397,'Sale Id shift 257976',0.00,0.00,0.00,60.99,0.00,'2023-03-08 09:54:23','',''),(2641603,'5','174','901',397,'Sale Id shift 257976',0.00,0.00,0.00,2605.74,0.00,'2023-03-08 09:54:23','',''),(2641604,'5','174',NULL,397,'Sale Id shift 257976',770046.90,0.00,0.00,0.00,0.00,'2023-03-08 09:54:23','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','174',399,-52.10,'2023-03-20 12:48:21'),(2,'5','174',398,0.00,'2023-03-20 12:48:21'),(3,'5','174',397,26997.25,'2023-03-20 12:48:21');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1826180 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (530208,'5','174',397,'Sale Id shift 181489',0.00,0.00,163.00,233685424.33,233685424.33,'2021-02-27 16:57:58'),(530209,'5','174',399,'Sale Id shift 181489',0.00,0.00,250.00,44344015.00,44344015.00,'2021-02-27 16:57:58'),(530479,'5','174',397,'Sale Id shift 181495',0.00,0.00,163.00,3436119.87,3436119.87,'2021-02-27 21:13:08'),(530480,'5','174',399,'Sale Id shift 181495',0.00,0.00,250.00,309745.00,309745.00,'2021-02-27 21:13:08'),(534175,'5','174',397,'Sale Id shift 181576',0.00,0.00,163.00,2548685.93,2548685.93,'2021-02-28 18:46:02'),(534176,'5','174',399,'Sale Id shift 181576',0.00,0.00,250.00,142507.50,142507.50,'2021-02-28 18:46:02'),(538715,'5','174',397,'Sale Id shift 181794',0.00,0.00,163.00,1010741.81,1010741.81,'2021-03-02 10:15:49'),(538716,'5','174',399,'Sale Id shift 181794',0.00,0.00,250.00,224500.00,224500.00,'2021-03-02 10:15:49'),(541327,'5','174',397,'Sale Id shift 181991',0.00,0.00,163.00,63216.29,63216.29,'2021-03-03 08:49:05'),(541328,'5','174',399,'Sale Id shift 181991',0.00,0.00,250.00,251107.50,251107.50,'2021-03-03 08:49:05'),(545645,'5','174',399,'Sale Id shift 182148',0.00,0.00,250.00,302352.50,302352.50,'2021-03-04 10:53:14'),(548704,'5','174',397,'Sale Id shift 182388',0.00,0.00,163.00,380784.30,380784.30,'2021-03-05 09:00:59'),(548705,'5','174',399,'Sale Id shift 182388',0.00,0.00,250.00,249285.00,249285.00,'2021-03-05 09:00:59'),(551497,'5','174',397,'Sale Id shift 182531',0.00,1458447.39,163.00,1458447.39,0.00,'2021-03-06 09:06:35'),(551498,'5','174',399,'Sale Id shift 182531',0.00,696057.50,250.00,696057.50,0.00,'2021-03-06 09:06:35'),(554468,'5','174',397,'Sale Id shift 182711',0.00,1859386.64,163.00,1859386.64,0.00,'2021-03-07 13:51:45'),(554469,'5','174',399,'Sale Id shift 182711',0.00,214627.50,250.00,214627.50,0.00,'2021-03-07 13:51:45'),(555101,'5','174',397,'Sale Id shift 182915',0.00,2145956.94,163.00,2145956.94,0.00,'2021-03-08 05:54:15'),(555102,'5','174',399,'Sale Id shift 182915',0.00,174850.00,250.00,174850.00,0.00,'2021-03-08 05:54:15'),(557996,'5','174',397,'Sale Id shift 183007',0.00,659476.81,163.00,659476.81,0.00,'2021-03-09 04:31:00'),(557997,'5','174',399,'Sale Id shift 183007',0.00,256197.50,250.00,256197.50,0.00,'2021-03-09 04:31:00'),(561049,'5','174',399,'Sale Id shift 183227',0.00,126947.50,250.00,126947.50,0.00,'2021-03-10 06:41:48'),(564165,'5','174',399,'Sale Id shift 183442',0.00,77085.00,265.00,81710.10,4625.10,'2021-03-11 07:17:20'),(567079,'5','174',399,'Sale Id shift 183675',0.00,137522.50,265.00,145773.85,8251.35,'2021-03-12 08:44:49'),(569126,'5','174',397,'Sale Id shift 183942',0.00,1398447.09,163.00,1398447.09,0.00,'2021-03-13 10:07:08'),(569127,'5','174',399,'Sale Id shift 183942',0.00,430995.00,255.00,439614.90,8619.90,'2021-03-13 10:07:08'),(571443,'5','174',397,'Sale Id shift 184106',0.00,2493415.89,163.00,2493415.89,0.00,'2021-03-14 08:09:27'),(571444,'5','174',399,'Sale Id shift 184106',0.00,743312.50,255.00,758178.75,14866.25,'2021-03-14 08:09:27'),(575146,'5','174',397,'Sale Id shift 184308',0.00,1618316.16,163.00,1618316.16,0.00,'2021-03-15 10:41:24'),(575147,'5','174',399,'Sale Id shift 184308',0.00,450090.00,255.00,459091.80,9001.80,'2021-03-15 10:41:24'),(581239,'5','174',397,'Sale Id shift 184564',0.00,1092295.60,163.00,1092295.60,0.00,'2021-03-17 09:45:08'),(581240,'5','174',399,'Sale Id shift 184564',0.00,747702.50,255.00,762656.55,14954.05,'2021-03-17 09:45:08'),(581252,'5','174',399,'Sale Id shift 184940',0.00,707010.00,255.00,721150.20,14140.20,'2021-03-17 09:48:48'),(583308,'5','174',397,'Sale Id shift 184942',0.00,1103405.68,163.00,1103405.68,0.00,'2021-03-18 06:57:50'),(583309,'5','174',399,'Sale Id shift 184942',0.00,638212.50,265.00,676505.25,38292.75,'2021-03-18 06:57:50'),(586297,'5','174',397,'Sale Id shift 185141',0.00,1031219.50,163.00,1031219.50,0.00,'2021-03-19 07:04:46'),(586298,'5','174',399,'Sale Id shift 185141',0.00,605905.00,265.00,642259.30,36354.30,'2021-03-19 07:04:46'),(590109,'5','174',397,'Sale Id shift 185291',0.00,1203785.97,163.00,1203785.97,0.00,'2021-03-20 08:26:37'),(590110,'5','174',399,'Sale Id shift 185291',0.00,839992.50,265.00,890392.05,50399.55,'2021-03-20 08:26:37'),(595061,'5','174',397,'Sale Id shift 185510',0.00,1445120.51,163.00,1445120.51,0.00,'2021-03-21 14:19:26'),(595062,'5','174',399,'Sale Id shift 185510',0.00,666502.50,265.00,706492.65,39990.15,'2021-03-21 14:19:26'),(596404,'5','174',397,'Sale Id shift 185794',0.00,1535583.88,163.00,1535583.88,0.00,'2021-03-21 20:43:56'),(596405,'5','174',399,'Sale Id shift 185794',0.00,401352.50,265.00,425433.65,24081.15,'2021-03-21 20:43:56'),(599541,'5','174',397,'Sale Id shift 185887',0.00,1718553.01,163.00,1718553.01,0.00,'2021-03-23 06:21:50'),(599542,'5','174',399,'Sale Id shift 185887',0.00,207975.00,265.00,220453.50,12478.50,'2021-03-23 06:21:50'),(602631,'5','174',397,'Sale Id shift 186108',0.00,1194089.10,163.00,1194089.10,0.00,'2021-03-24 05:31:03'),(602632,'5','174',399,'Sale Id shift 186108',0.00,69600.00,265.00,73776.00,4176.00,'2021-03-24 05:31:03'),(605729,'5','174',397,'Sale Id shift 186334',0.00,1031605.81,163.00,1031605.81,0.00,'2021-03-25 05:30:47'),(605730,'5','174',399,'Sale Id shift 186334',0.00,97202.50,265.00,103034.65,5832.15,'2021-03-25 05:30:47'),(608584,'5','174',397,'Sale Id shift 186554',0.00,1381310.90,163.00,1381310.90,0.00,'2021-03-26 05:39:03'),(611556,'5','174',397,'Sale Id shift 186765',0.00,1287537.00,163.00,1287537.00,0.00,'2021-03-27 06:16:13'),(614583,'5','174',397,'Sale Id shift 187040',0.00,1320930.81,163.00,1320930.81,0.00,'2021-03-28 05:36:05'),(617870,'5','174',397,'Sale Id shift 187196',0.00,1218561.92,163.00,1218561.92,0.00,'2021-03-29 06:32:23'),(620946,'5','174',397,'Sale Id shift 187371',0.00,1918581.72,163.00,1918581.72,0.00,'2021-03-30 07:08:09'),(624491,'5','174',397,'Sale Id shift 187642',0.00,1469229.84,163.00,1469229.84,0.00,'2021-03-31 04:09:16'),(628159,'5','174',397,'Sale Id shift 187827',0.00,1307453.97,163.00,1307453.97,0.00,'2021-04-01 06:57:28'),(632222,'5','174',397,'Sale Id shift 188024',0.00,1384647.51,163.00,1384647.51,0.00,'2021-04-02 05:19:54'),(636259,'5','174',397,'Sale Id shift 188203',0.00,1163634.18,163.00,1163634.18,0.00,'2021-04-02 22:41:05'),(639388,'5','174',397,'Sale Id shift 188414',0.00,1296572.09,163.00,1296572.09,0.00,'2021-04-04 05:27:43'),(643343,'5','174',397,'Sale Id shift 188601',0.00,1153104.38,163.00,1153104.38,0.00,'2021-04-05 08:27:41'),(646449,'5','174',397,'Sale Id shift 188859',0.00,1441702.40,163.00,1441702.40,0.00,'2021-04-05 21:53:26'),(646450,'5','174',399,'Sale Id shift 188859',0.00,178712.50,270.00,193009.50,14297.00,'2021-04-05 21:53:26'),(649434,'5','174',397,'Sale Id shift 189041',0.00,1225345.98,163.00,1225345.98,0.00,'2021-04-07 03:03:44'),(649435,'5','174',399,'Sale Id shift 189041',0.00,398220.80,265.00,398220.80,0.00,'2021-04-07 03:03:44'),(653060,'5','174',397,'Sale Id shift 189205',0.00,1313530.61,163.00,1313530.61,0.00,'2021-04-07 21:23:01'),(653061,'5','174',399,'Sale Id shift 189205',0.00,517025.60,265.00,517025.60,0.00,'2021-04-07 21:23:01'),(657015,'5','174',397,'Sale Id shift 189660',0.00,1247380.32,163.00,1247380.32,0.00,'2021-04-09 08:50:56'),(657016,'5','174',399,'Sale Id shift 189660',0.00,260513.55,265.00,260513.55,0.00,'2021-04-09 08:50:56'),(659819,'5','174',397,'Sale Id shift 189667',0.00,537000.24,163.00,537000.24,0.00,'2021-04-10 05:48:12'),(659820,'5','174',399,'Sale Id shift 189667',0.00,145569.80,265.00,145569.80,0.00,'2021-04-10 05:48:12'),(663754,'5','174',397,'Sale Id shift 190011',0.00,1807322.81,163.00,1807322.81,0.00,'2021-04-11 05:34:18'),(663755,'5','174',399,'Sale Id shift 190011',0.00,610077.70,265.00,610077.70,0.00,'2021-04-11 05:34:18'),(667698,'5','174',397,'Sale Id shift 190026',0.00,1438243.54,163.00,1438243.54,0.00,'2021-04-12 05:15:08'),(667699,'5','174',399,'Sale Id shift 190026',0.00,95548.40,265.00,95548.40,0.00,'2021-04-12 05:15:08'),(672237,'5','174',397,'Sale Id shift 190217',0.00,1653468.74,163.00,1653468.74,0.00,'2021-04-13 05:46:01'),(672238,'5','174',399,'Sale Id shift 190217',0.00,255534.20,265.00,255534.20,0.00,'2021-04-13 05:46:01'),(677203,'5','174',399,'Sale Id shift 190462',0.00,203209.95,265.00,203209.95,0.00,'2021-04-14 02:45:58'),(681248,'5','174',397,'Sale Id shift 190659',0.00,1309019.25,165.00,1309019.25,0.00,'2021-04-15 06:51:07'),(681249,'5','174',399,'Sale Id shift 190659',0.00,87166.45,265.00,87166.45,0.00,'2021-04-15 06:51:07'),(684683,'5','174',397,'Sale Id shift 190898',0.00,1935775.05,165.00,1935775.05,0.00,'2021-04-16 05:08:32'),(684684,'5','174',399,'Sale Id shift 190898',0.00,201755.10,265.00,201755.10,0.00,'2021-04-16 05:08:32'),(689088,'5','174',397,'Sale Id shift 191124',0.00,1768532.70,165.00,1768532.70,0.00,'2021-04-17 10:54:26'),(689089,'5','174',399,'Sale Id shift 191124',0.00,153954.40,265.00,153954.40,0.00,'2021-04-17 10:54:26'),(691092,'5','174',397,'Sale Id shift 191365',0.00,1181611.20,165.00,1181611.20,0.00,'2021-04-18 04:44:56'),(691093,'5','174',399,'Sale Id shift 191365',0.00,136469.70,265.00,136469.70,0.00,'2021-04-18 04:44:56'),(694541,'5','174',397,'Sale Id shift 191519',0.00,1036858.35,165.00,1036858.35,0.00,'2021-04-19 03:46:51'),(694542,'5','174',399,'Sale Id shift 191519',0.00,253287.00,265.00,253287.00,0.00,'2021-04-19 03:46:51'),(698123,'5','174',397,'Sale Id shift 191728',0.00,1289577.30,165.00,1289577.30,0.00,'2021-04-20 05:16:40'),(698124,'5','174',399,'Sale Id shift 191728',0.00,169231.65,265.00,169231.65,0.00,'2021-04-20 05:16:40'),(700918,'5','174',397,'Sale Id shift 191962',0.00,713651.40,165.00,713651.40,0.00,'2021-04-21 05:35:30'),(700919,'5','174',399,'Sale Id shift 191962',0.00,365177.95,265.00,365177.95,0.00,'2021-04-21 05:35:30'),(703440,'5','174',399,'Sale Id shift 192138',0.00,291892.20,265.00,291892.20,0.00,'2021-04-22 04:02:06'),(706459,'5','174',399,'Sale Id shift 192427',0.00,347605.80,265.00,347605.80,0.00,'2021-04-23 05:26:44'),(709605,'5','174',397,'Sale Id shift 192570',0.00,959620.20,165.00,959620.20,0.00,'2021-04-24 07:22:45'),(709606,'5','174',399,'Sale Id shift 192570',0.00,275157.45,265.00,275157.45,0.00,'2021-04-24 07:22:45'),(712810,'5','174',397,'Sale Id shift 192774',0.00,936873.30,165.00,936873.30,0.00,'2021-04-25 06:17:50'),(712811,'5','174',399,'Sale Id shift 192774',0.00,244761.95,265.00,244761.95,0.00,'2021-04-25 06:17:50'),(716291,'5','174',397,'Sale Id shift 192967',0.00,902416.35,165.00,902416.35,0.00,'2021-04-26 07:33:35'),(716292,'5','174',399,'Sale Id shift 192967',0.00,155078.00,265.00,155078.00,0.00,'2021-04-26 07:33:35'),(719002,'5','174',397,'Sale Id shift 193193',0.00,1059242.25,165.00,1059242.25,0.00,'2021-04-27 05:31:37'),(719003,'5','174',399,'Sale Id shift 193193',0.00,577676.15,265.00,577676.15,0.00,'2021-04-27 05:31:37'),(721913,'5','174',397,'Sale Id shift 193419',0.00,692054.55,165.00,692054.55,0.00,'2021-04-28 05:37:49'),(721914,'5','174',399,'Sale Id shift 193419',0.00,305409.85,265.00,305409.85,0.00,'2021-04-28 05:37:49'),(725075,'5','174',397,'Sale Id shift 193651',0.00,770424.60,165.00,770424.60,0.00,'2021-04-29 08:18:57'),(725076,'5','174',399,'Sale Id shift 193651',0.00,318018.55,265.00,318018.55,0.00,'2021-04-29 08:18:57'),(727543,'5','174',397,'Sale Id shift 193890',0.00,762042.60,165.00,762042.60,0.00,'2021-04-29 23:31:51'),(727544,'5','174',399,'Sale Id shift 193890',0.00,84230.25,265.00,84230.25,0.00,'2021-04-29 23:31:51'),(730384,'5','174',397,'Sale Id shift 194097',0.00,887952.45,165.00,887952.45,0.00,'2021-05-01 06:18:22'),(730385,'5','174',399,'Sale Id shift 194097',0.00,388002.40,265.00,388002.40,0.00,'2021-05-01 06:18:22'),(733186,'5','174',397,'Sale Id shift 194347',0.00,455574.90,165.00,455574.90,0.00,'2021-05-02 07:05:53'),(733187,'5','174',399,'Sale Id shift 194347',0.00,275849.10,265.00,275849.10,0.00,'2021-05-02 07:05:53'),(736748,'5','174',399,'Sale Id shift 194526',0.00,148050.20,265.00,148050.20,0.00,'2021-05-02 23:42:23'),(741043,'5','174',397,'Sale Id shift 194692',0.00,1286508.30,165.00,1286508.30,0.00,'2021-05-04 12:29:53'),(741044,'5','174',399,'Sale Id shift 194692',0.00,266075.90,265.00,266075.90,0.00,'2021-05-04 12:29:53'),(742615,'5','174',397,'Sale Id shift 194943',0.00,723559.65,165.00,723559.65,0.00,'2021-05-05 05:28:13'),(742616,'5','174',399,'Sale Id shift 194943',0.00,268932.60,265.00,268932.60,0.00,'2021-05-05 05:28:13'),(745635,'5','174',397,'Sale Id shift 195116',0.00,856015.05,165.00,856015.05,0.00,'2021-05-06 04:54:41'),(748705,'5','174',397,'Sale Id shift 195325',0.00,826054.35,165.00,826054.35,0.00,'2021-05-06 21:56:37'),(752210,'5','174',397,'Sale Id shift 195561',0.00,1147012.35,165.00,1147012.35,0.00,'2021-05-08 06:17:22'),(755807,'5','174',397,'Sale Id shift 195841',0.00,965637.75,165.00,965637.75,0.00,'2021-05-09 05:27:01'),(759396,'5','174',397,'Sale Id shift 196047',0.00,611344.80,165.00,611344.80,0.00,'2021-05-10 05:42:59'),(762626,'5','174',397,'Sale Id shift 196229',0.00,808854.75,165.00,808854.75,0.00,'2021-05-11 04:17:20'),(767142,'5','174',397,'Sale Id shift 196635',0.00,134311.65,165.00,134311.65,0.00,'2021-05-12 09:40:15'),(771171,'5','174',397,'Sale Id shift 196876',0.00,578961.90,165.00,578961.90,0.00,'2021-05-14 06:15:58'),(774968,'5','174',397,'Sale Id shift 197037',0.00,626212.95,165.00,626212.95,0.00,'2021-05-16 17:19:39'),(776915,'5','174',397,'Sale Id shift 197764',0.00,788832.00,165.00,788832.00,0.00,'2021-05-17 16:06:02'),(776916,'5','174',399,'Sale Id shift 197764',0.00,193966.75,265.00,193966.75,0.00,'2021-05-17 16:06:02'),(776988,'5','174',397,'Sale Id shift 197786',0.00,180295.50,165.00,180295.50,0.00,'2021-05-17 16:19:38'),(776989,'5','174',399,'Sale Id shift 197786',0.00,418482.70,265.00,418482.70,0.00,'2021-05-17 16:19:38'),(777355,'5','174',399,'Sale Id shift 197815',0.00,104818.10,265.00,104818.10,0.00,'2021-05-18 06:22:37'),(780900,'5','174',399,'Sale Id shift 198142',0.00,168402.20,270.00,171579.60,3177.40,'2021-05-19 08:55:01'),(783264,'5','174',397,'Sale Id shift 198175',0.00,913682.55,165.00,913682.55,0.00,'2021-05-20 04:51:12'),(783265,'5','174',399,'Sale Id shift 198175',0.00,144075.20,270.00,146793.60,2718.40,'2021-05-20 04:51:12'),(786497,'5','174',397,'Sale Id shift 198458',0.00,711460.20,165.00,711460.20,0.00,'2021-05-21 05:08:58'),(786498,'5','174',399,'Sale Id shift 198458',0.00,152475.70,270.00,155352.60,2876.90,'2021-05-21 05:08:58'),(790296,'5','174',397,'Sale Id shift 198816',0.00,695531.10,165.00,695531.10,0.00,'2021-05-22 08:35:42'),(790297,'5','174',399,'Sale Id shift 198816',0.00,247511.70,270.00,247511.70,0.00,'2021-05-22 08:35:42'),(793788,'5','174',397,'Sale Id shift 198820',0.00,787691.85,165.00,787691.85,0.00,'2021-05-23 05:20:21'),(793789,'5','174',399,'Sale Id shift 198820',0.00,156624.30,270.00,156624.30,0.00,'2021-05-23 05:20:21'),(797177,'5','174',397,'Sale Id shift 199014',0.00,712864.35,165.00,712864.35,0.00,'2021-05-24 04:43:18'),(797178,'5','174',399,'Sale Id shift 199014',0.00,170521.20,270.00,170521.20,0.00,'2021-05-24 04:43:18'),(800364,'5','174',397,'Sale Id shift 199209',0.00,840772.35,165.00,840772.35,0.00,'2021-05-25 05:04:56'),(800365,'5','174',399,'Sale Id shift 199209',0.00,288962.10,270.00,288962.10,0.00,'2021-05-25 05:04:56'),(803693,'5','174',397,'Sale Id shift 199439',0.00,744966.75,165.00,744966.75,0.00,'2021-05-26 04:49:35'),(803694,'5','174',399,'Sale Id shift 199439',0.00,161554.50,270.00,161554.50,0.00,'2021-05-26 04:49:35'),(807063,'5','174',397,'Sale Id shift 199663',0.00,759353.10,165.00,759353.10,0.00,'2021-05-27 05:11:14'),(807064,'5','174',399,'Sale Id shift 199663',0.00,174039.30,270.00,174039.30,0.00,'2021-05-27 05:11:14'),(810279,'5','174',397,'Sale Id shift 199874',0.00,737474.10,165.00,737474.10,0.00,'2021-05-28 05:37:45'),(810280,'5','174',399,'Sale Id shift 199874',0.00,211050.90,270.00,211050.90,0.00,'2021-05-28 05:37:45'),(813410,'5','174',397,'Sale Id shift 200101',0.00,736192.05,165.00,736192.05,0.00,'2021-05-29 06:31:24'),(813411,'5','174',399,'Sale Id shift 200101',0.00,495582.30,270.00,495582.30,0.00,'2021-05-29 06:31:24'),(817068,'5','174',397,'Sale Id shift 200312',0.00,742414.20,165.00,742414.20,0.00,'2021-05-30 04:39:31'),(817069,'5','174',399,'Sale Id shift 200312',0.00,217652.40,270.00,217652.40,0.00,'2021-05-30 04:39:31'),(820736,'5','174',397,'Sale Id shift 200525',0.00,730090.35,165.00,730090.35,0.00,'2021-05-31 05:17:53'),(820737,'5','174',399,'Sale Id shift 200525',0.00,164910.60,270.00,164910.60,0.00,'2021-05-31 05:17:53'),(824083,'5','174',397,'Sale Id shift 200759',0.00,903690.15,165.00,903690.15,0.00,'2021-06-01 05:14:04'),(824084,'5','174',399,'Sale Id shift 200759',0.00,122153.40,270.00,122153.40,0.00,'2021-06-01 05:14:04'),(828426,'5','174',397,'Sale Id shift 200923',0.00,633939.90,165.00,633939.90,0.00,'2021-06-02 05:26:12'),(832622,'5','174',397,'Sale Id shift 201118',0.00,789033.30,165.00,789033.30,0.00,'2021-06-03 05:20:26'),(836176,'5','174',397,'Sale Id shift 201314',0.00,907990.05,165.00,907990.05,0.00,'2021-06-04 05:43:58'),(836177,'5','174',399,'Sale Id shift 201314',0.00,108963.90,270.00,108963.90,0.00,'2021-06-04 05:43:58'),(839912,'5','174',397,'Sale Id shift 201493',0.00,877511.25,165.00,877511.25,0.00,'2021-06-05 05:41:17'),(839913,'5','174',399,'Sale Id shift 201493',0.00,268369.20,270.00,268369.20,0.00,'2021-06-05 05:41:17'),(844267,'5','174',397,'Sale Id shift 201802',0.00,644084.10,165.00,644084.10,0.00,'2021-06-05 22:35:32'),(844268,'5','174',399,'Sale Id shift 201802',0.00,219591.00,275.00,223657.50,4066.50,'2021-06-05 22:35:32'),(847955,'5','174',397,'Sale Id shift 202028',0.00,649339.35,165.00,649339.35,0.00,'2021-06-07 05:15:17'),(847956,'5','174',399,'Sale Id shift 202028',0.00,230939.10,275.00,235215.75,4276.65,'2021-06-07 05:15:17'),(852046,'5','174',397,'Sale Id shift 202233',0.00,735111.30,165.00,735111.30,0.00,'2021-06-08 05:23:53'),(852047,'5','174',399,'Sale Id shift 202233',0.00,131139.00,275.00,133567.50,2428.50,'2021-06-08 05:23:53'),(855677,'5','174',397,'Sale Id shift 202434',0.00,662341.35,165.00,662341.35,0.00,'2021-06-09 01:03:37'),(855678,'5','174',399,'Sale Id shift 202434',0.00,281050.00,275.00,281050.00,0.00,'2021-06-09 01:03:37'),(859624,'5','174',397,'Sale Id shift 202646',0.00,617017.50,165.00,617017.50,0.00,'2021-06-10 05:48:46'),(859625,'5','174',399,'Sale Id shift 202646',0.00,159893.25,275.00,159893.25,0.00,'2021-06-10 05:48:46'),(863320,'5','174',397,'Sale Id shift 202864',0.00,683060.40,165.00,683060.40,0.00,'2021-06-11 05:50:38'),(863321,'5','174',399,'Sale Id shift 202864',0.00,217151.00,275.00,217151.00,0.00,'2021-06-11 05:50:38'),(867222,'5','174',397,'Sale Id shift 203108',0.00,680955.00,165.00,680955.00,0.00,'2021-06-12 04:45:00'),(867223,'5','174',399,'Sale Id shift 203108',0.00,78655.50,275.00,78655.50,0.00,'2021-06-12 04:45:00'),(870647,'5','174',397,'Sale Id shift 203303',0.00,670924.65,165.00,670924.65,0.00,'2021-06-13 05:06:24'),(870648,'5','174',399,'Sale Id shift 203303',0.00,331086.25,275.00,331086.25,0.00,'2021-06-13 05:06:24'),(874925,'5','174',397,'Sale Id shift 203529',0.00,625140.45,165.00,625140.45,0.00,'2021-06-14 06:18:07'),(874926,'5','174',399,'Sale Id shift 203529',0.00,196787.25,275.00,196787.25,0.00,'2021-06-14 06:18:07'),(878667,'5','174',397,'Sale Id shift 203740',0.00,857623.80,165.00,857623.80,0.00,'2021-06-15 05:04:34'),(878668,'5','174',399,'Sale Id shift 203740',0.00,166300.75,275.00,166300.75,0.00,'2021-06-15 05:04:34'),(881813,'5','174',397,'Sale Id shift 203964',0.00,706356.75,165.00,706356.75,0.00,'2021-06-16 05:47:20'),(881814,'5','174',399,'Sale Id shift 203964',0.00,164565.50,275.00,164565.50,0.00,'2021-06-16 05:47:20'),(885690,'5','174',397,'Sale Id shift 204184',0.00,742311.90,165.00,742311.90,0.00,'2021-06-17 06:10:01'),(885691,'5','174',399,'Sale Id shift 204184',0.00,766535.00,275.00,766535.00,0.00,'2021-06-17 06:10:01'),(889450,'5','174',397,'Sale Id shift 204399',0.00,769023.75,165.00,769023.75,0.00,'2021-06-18 05:44:10'),(889451,'5','174',399,'Sale Id shift 204399',0.00,411939.00,275.00,411939.00,0.00,'2021-06-18 05:44:10'),(893109,'5','174',397,'Sale Id shift 204627',0.00,767883.60,165.00,767883.60,0.00,'2021-06-19 06:06:04'),(893110,'5','174',399,'Sale Id shift 204627',0.00,280021.50,275.00,280021.50,0.00,'2021-06-19 06:06:04'),(897433,'5','174',397,'Sale Id shift 204844',0.00,801832.35,165.00,801832.35,0.00,'2021-06-20 08:38:07'),(897434,'5','174',399,'Sale Id shift 204844',0.00,177795.75,275.00,177795.75,0.00,'2021-06-20 08:38:07'),(900300,'5','174',397,'Sale Id shift 205080',0.00,655673.70,165.00,655673.70,0.00,'2021-06-21 05:27:32'),(903480,'5','174',397,'Sale Id shift 205236',0.00,868843.80,165.00,868843.80,0.00,'2021-06-22 05:14:26'),(906703,'5','174',397,'Sale Id shift 205503',0.00,597374.25,165.00,597374.25,0.00,'2021-06-23 06:58:26'),(910364,'5','174',397,'Sale Id shift 205741',0.00,746420.40,165.00,746420.40,0.00,'2021-06-24 07:01:47'),(913648,'5','174',397,'Sale Id shift 205960',0.00,683169.30,165.00,683169.30,0.00,'2021-06-25 05:16:00'),(917082,'5','174',397,'Sale Id shift 206166',0.00,852132.60,165.00,852132.60,0.00,'2021-06-26 06:58:34'),(920532,'5','174',397,'Sale Id shift 206373',0.00,756899.55,165.00,756899.55,0.00,'2021-06-27 05:46:28'),(924357,'5','174',397,'Sale Id shift 206586',0.00,716177.55,165.00,716177.55,0.00,'2021-06-28 05:37:33'),(928129,'5','174',397,'Sale Id shift 206818',0.00,879520.95,165.00,879520.95,0.00,'2021-06-29 05:46:50'),(932007,'5','174',397,'Sale Id shift 207038',0.00,790759.20,165.00,790759.20,0.00,'2021-06-30 05:34:55'),(936472,'5','174',397,'Sale Id shift 207267',0.00,756587.70,165.00,756587.70,0.00,'2021-07-01 05:41:36'),(940421,'5','174',397,'Sale Id shift 207491',0.00,813692.55,165.00,813692.55,0.00,'2021-07-02 05:36:47'),(944040,'5','174',397,'Sale Id shift 207698',0.00,1180708.65,165.00,1180708.65,0.00,'2021-07-03 06:26:24'),(948113,'5','174',397,'Sale Id shift 207910',0.00,668518.95,165.00,668518.95,0.00,'2021-07-04 05:42:22'),(952254,'5','174',397,'Sale Id shift 208107',0.00,676542.90,165.00,676542.90,0.00,'2021-07-05 05:19:21'),(956362,'5','174',397,'Sale Id shift 208330',0.00,772889.70,165.00,772889.70,0.00,'2021-07-06 07:03:07'),(960353,'5','174',397,'Sale Id shift 208652',0.00,712323.15,165.00,712323.15,0.00,'2021-07-07 05:56:44'),(964733,'5','174',397,'Sale Id shift 208777',0.00,673206.60,165.00,673206.60,0.00,'2021-07-08 07:36:24'),(968569,'5','174',397,'Sale Id shift 209022',0.00,730030.95,165.00,730030.95,0.00,'2021-07-09 06:17:41'),(972388,'5','174',397,'Sale Id shift 209215',0.00,743810.10,165.00,743810.10,0.00,'2021-07-10 06:33:34'),(976928,'5','174',397,'Sale Id shift 209448',0.00,695275.35,165.00,695275.35,0.00,'2021-07-11 05:45:14'),(981058,'5','174',397,'Sale Id shift 209661',0.00,680042.55,165.00,680042.55,0.00,'2021-07-12 06:20:07'),(984249,'5','174',397,'Sale Id shift 209883',0.00,797897.10,165.00,797897.10,0.00,'2021-07-13 04:27:27'),(988034,'5','174',397,'Sale Id shift 210097',0.00,525496.95,165.00,525496.95,0.00,'2021-07-14 06:21:29'),(991442,'5','174',397,'Sale Id shift 210480',0.00,79912.80,165.00,79912.80,0.00,'2021-07-15 06:11:59'),(994559,'5','174',397,'Sale Id shift 210529',0.00,723813.75,165.00,723813.75,0.00,'2021-07-16 05:37:50'),(998048,'5','174',397,'Sale Id shift 210767',0.00,847111.65,165.00,847111.65,0.00,'2021-07-17 06:04:55'),(1002496,'5','174',397,'Sale Id shift 210980',0.00,737380.05,165.00,737380.05,0.00,'2021-07-18 06:09:06'),(1006348,'5','174',397,'Sale Id shift 211169',0.00,957712.80,165.00,957712.80,0.00,'2021-07-19 06:33:53'),(1010258,'5','174',397,'Sale Id shift 211388',0.00,1110796.50,165.00,1110796.50,0.00,'2021-07-20 05:47:06'),(1012624,'5','174',397,'Sale Id shift 211604',0.00,586297.80,165.00,586297.80,0.00,'2021-07-21 06:22:02'),(1016096,'5','174',397,'Sale Id shift 211838',0.00,658211.40,165.00,658211.40,0.00,'2021-07-22 06:24:10'),(1019266,'5','174',397,'Sale Id shift 212144',0.00,457700.10,165.00,457700.10,0.00,'2021-07-23 07:13:22'),(1022303,'5','174',397,'Sale Id shift 212265',0.00,718650.90,165.00,718650.90,0.00,'2021-07-24 04:42:07'),(1025848,'5','174',397,'Sale Id shift 212466',0.00,712392.45,165.00,712392.45,0.00,'2021-07-25 05:25:57'),(1028951,'5','174',397,'Sale Id shift 212675',0.00,638312.40,165.00,638312.40,0.00,'2021-07-26 05:42:28'),(1032120,'5','174',397,'Sale Id shift 212884',0.00,468534.00,165.00,468534.00,0.00,'2021-07-27 05:55:15'),(1036038,'5','174',397,'Sale Id shift 213135',0.00,592698.15,165.00,592698.15,0.00,'2021-07-28 01:55:10'),(1041746,'5','174',397,'Sale Id shift 213432',0.00,623978.85,165.00,623978.85,0.00,'2021-07-29 14:01:45'),(1043455,'5','174',397,'Sale Id shift 213776',0.00,696234.00,165.00,696234.00,0.00,'2021-07-30 07:07:42'),(1047868,'5','174',397,'Sale Id shift 213915',0.00,641828.55,165.00,641828.55,0.00,'2021-07-31 08:48:13'),(1051410,'5','174',397,'Sale Id shift 214148',0.00,602840.70,165.00,602840.70,0.00,'2021-08-01 05:18:32'),(1055081,'5','174',397,'Sale Id shift 214352',0.00,596547.60,165.00,596547.60,0.00,'2021-08-02 05:31:25'),(1059284,'5','174',397,'Sale Id shift 214587',0.00,350877.45,165.00,350877.45,0.00,'2021-08-03 04:31:37'),(1063780,'5','174',397,'Sale Id shift 214792',0.00,667776.45,165.00,667776.45,0.00,'2021-08-04 05:53:10'),(1067352,'5','174',397,'Sale Id shift 215073',0.00,645118.65,165.00,645118.65,0.00,'2021-08-05 05:28:46'),(1070559,'5','174',397,'Sale Id shift 215285',0.00,595343.10,165.00,595343.10,0.00,'2021-08-06 01:15:54'),(1075970,'5','174',397,'Sale Id shift 215445',0.00,728446.95,165.00,728446.95,0.00,'2021-08-07 10:24:36'),(1075971,'5','174',399,'Sale Id shift 215445',0.00,195956.70,295.00,195956.70,0.00,'2021-08-07 10:24:36'),(1078809,'5','174',397,'Sale Id shift 215742',0.00,584750.10,165.00,584750.10,0.00,'2021-08-08 03:36:34'),(1078810,'5','174',399,'Sale Id shift 215742',0.00,89364.35,295.00,89364.35,0.00,'2021-08-08 03:36:34'),(1082656,'5','174',397,'Sale Id shift 215932',0.00,383948.40,165.00,383948.40,0.00,'2021-08-09 06:21:14'),(1082657,'5','174',399,'Sale Id shift 215932',0.00,28479.30,295.00,28479.30,0.00,'2021-08-09 06:21:14'),(1086651,'5','174',397,'Sale Id shift 216115',0.00,584048.85,165.00,584048.85,0.00,'2021-08-10 05:38:13'),(1086652,'5','174',399,'Sale Id shift 216115',0.00,56935.00,295.00,56935.00,0.00,'2021-08-10 05:38:13'),(1090704,'5','174',397,'Sale Id shift 216367',0.00,593542.95,165.00,593542.95,0.00,'2021-08-11 07:24:41'),(1090705,'5','174',399,'Sale Id shift 216367',0.00,74576.00,295.00,74576.00,0.00,'2021-08-11 07:24:41'),(1093629,'5','174',397,'Sale Id shift 216578',0.00,616836.00,165.00,616836.00,0.00,'2021-08-12 05:36:22'),(1093630,'5','174',399,'Sale Id shift 216578',0.00,64112.35,295.00,64112.35,0.00,'2021-08-12 05:36:22'),(1097020,'5','174',397,'Sale Id shift 216797',0.00,629336.40,165.00,629336.40,0.00,'2021-08-13 05:42:18'),(1097021,'5','174',399,'Sale Id shift 216797',0.00,34647.75,295.00,34647.75,0.00,'2021-08-13 05:42:18'),(1101138,'5','174',397,'Sale Id shift 217024',0.00,547532.70,165.00,547532.70,0.00,'2021-08-14 05:41:56'),(1101139,'5','174',399,'Sale Id shift 217024',0.00,57318.50,295.00,57318.50,0.00,'2021-08-14 05:41:56'),(1109677,'5','174',397,'Sale Id shift 217298',0.00,566222.25,165.00,566222.25,0.00,'2021-08-15 18:54:16'),(1109678,'5','174',399,'Sale Id shift 217298',0.00,105651.30,295.00,105651.30,0.00,'2021-08-15 18:54:16'),(1111149,'5','174',397,'Sale Id shift 217653',0.00,595395.90,165.00,595395.90,0.00,'2021-08-16 10:56:40'),(1111150,'5','174',399,'Sale Id shift 217653',0.00,125192.10,295.00,125192.10,0.00,'2021-08-16 10:56:40'),(1113687,'5','174',397,'Sale Id shift 217829',0.00,648054.00,165.00,648054.00,0.00,'2021-08-17 05:47:22'),(1113688,'5','174',399,'Sale Id shift 217829',0.00,72844.35,295.00,72844.35,0.00,'2021-08-17 05:47:22'),(1117524,'5','174',397,'Sale Id shift 218040',0.00,707110.80,165.00,707110.80,0.00,'2021-08-18 00:54:35'),(1117525,'5','174',399,'Sale Id shift 218040',0.00,87930.65,295.00,87930.65,0.00,'2021-08-18 00:54:35'),(1121075,'5','174',397,'Sale Id shift 218241',0.00,568240.20,165.00,568240.20,0.00,'2021-08-19 05:49:43'),(1121076,'5','174',399,'Sale Id shift 218241',0.00,106241.30,295.00,106241.30,0.00,'2021-08-19 05:49:43'),(1126310,'5','174',397,'Sale Id shift 218517',0.00,745463.40,165.00,745463.40,0.00,'2021-08-20 10:06:01'),(1126311,'5','174',399,'Sale Id shift 218517',0.00,174244.70,295.00,174244.70,0.00,'2021-08-20 10:06:01'),(1128892,'5','174',397,'Sale Id shift 218761',0.00,595831.50,165.00,595831.50,0.00,'2021-08-21 06:18:04'),(1128893,'5','174',399,'Sale Id shift 218761',0.00,76732.45,295.00,76732.45,0.00,'2021-08-21 06:18:04'),(1133187,'5','174',397,'Sale Id shift 219097',0.00,562034.55,165.00,562034.55,0.00,'2021-08-22 06:03:25'),(1133188,'5','174',399,'Sale Id shift 219097',0.00,71325.10,295.00,71325.10,0.00,'2021-08-22 06:03:25'),(1137290,'5','174',397,'Sale Id shift 219155',0.00,447712.65,165.00,447712.65,0.00,'2021-08-23 05:48:17'),(1137291,'5','174',399,'Sale Id shift 219155',0.00,89264.05,295.00,89264.05,0.00,'2021-08-23 05:48:17'),(1141255,'5','174',397,'Sale Id shift 219359',0.00,797911.95,165.00,797911.95,0.00,'2021-08-24 05:41:02'),(1141256,'5','174',399,'Sale Id shift 219359',0.00,366313.30,295.00,366313.30,0.00,'2021-08-24 05:41:02'),(1145030,'5','174',397,'Sale Id shift 219631',0.00,487377.00,165.00,487377.00,0.00,'2021-08-25 05:41:02'),(1145031,'5','174',399,'Sale Id shift 219631',0.00,61495.70,295.00,61495.70,0.00,'2021-08-25 05:41:02'),(1148825,'5','174',397,'Sale Id shift 219839',0.00,537807.60,165.00,537807.60,0.00,'2021-08-26 05:04:38'),(1148826,'5','174',399,'Sale Id shift 219839',0.00,85331.70,295.00,85331.70,0.00,'2021-08-26 05:04:38'),(1152508,'5','174',397,'Sale Id shift 220079',0.00,532451.70,165.00,532451.70,0.00,'2021-08-27 06:16:29'),(1152509,'5','174',399,'Sale Id shift 220079',0.00,63307.00,295.00,63307.00,0.00,'2021-08-27 06:16:29'),(1155888,'5','174',397,'Sale Id shift 220254',0.00,516474.75,165.00,516474.75,0.00,'2021-08-28 05:23:02'),(1155889,'5','174',399,'Sale Id shift 220254',0.00,128808.80,295.00,128808.80,0.00,'2021-08-28 05:23:02'),(1159607,'5','174',397,'Sale Id shift 220492',0.00,481133.40,165.00,481133.40,0.00,'2021-08-29 05:55:04'),(1159608,'5','174',399,'Sale Id shift 220492',0.00,37329.30,295.00,37329.30,0.00,'2021-08-29 05:55:04'),(1164050,'5','174',397,'Sale Id shift 220716',0.00,504566.70,165.00,504566.70,0.00,'2021-08-30 05:37:06'),(1164051,'5','174',399,'Sale Id shift 220716',0.00,61802.50,295.00,61802.50,0.00,'2021-08-30 05:37:06'),(1168200,'5','174',397,'Sale Id shift 220929',0.00,592008.45,165.00,592008.45,0.00,'2021-08-31 06:00:42'),(1168201,'5','174',399,'Sale Id shift 220929',0.00,65268.75,295.00,65268.75,0.00,'2021-08-31 06:00:42'),(1172083,'5','174',397,'Sale Id shift 221181',0.00,508655.40,165.00,508655.40,0.00,'2021-09-01 05:57:52'),(1172084,'5','174',399,'Sale Id shift 221181',0.00,19897.75,295.00,19897.75,0.00,'2021-09-01 05:57:52'),(1175835,'5','174',397,'Sale Id shift 221418',0.00,560722.80,165.00,560722.80,0.00,'2021-09-02 05:46:07'),(1175836,'5','174',399,'Sale Id shift 221418',0.00,75304.65,295.00,75304.65,0.00,'2021-09-02 05:46:07'),(1180019,'5','174',397,'Sale Id shift 221637',0.00,502944.75,165.00,502944.75,0.00,'2021-09-03 05:43:16'),(1180020,'5','174',399,'Sale Id shift 221637',0.00,58958.70,295.00,58958.70,0.00,'2021-09-03 05:43:16'),(1184332,'5','174',397,'Sale Id shift 221853',0.00,486565.20,165.00,486565.20,0.00,'2021-09-04 06:04:38'),(1184333,'5','174',399,'Sale Id shift 221853',0.00,102444.65,295.00,102444.65,0.00,'2021-09-04 06:04:38'),(1197753,'5','174',397,'Sale Id shift 223083',0.00,362552.85,165.00,362552.85,0.00,'2021-09-08 14:24:17'),(1197754,'5','174',399,'Sale Id shift 223083',0.00,15534.70,295.00,15534.70,0.00,'2021-09-08 14:24:17'),(1197815,'5','174',397,'Sale Id shift 223092',0.00,358455.90,165.00,358455.90,0.00,'2021-09-08 14:42:35'),(1197816,'5','174',399,'Sale Id shift 223092',0.00,32570.95,295.00,32570.95,0.00,'2021-09-08 14:42:35'),(1218406,'5','174',397,'Sale Id shift 223100',0.00,441016.95,165.00,441016.95,0.00,'2021-09-14 13:02:22'),(1218407,'5','174',399,'Sale Id shift 223100',0.00,51235.60,295.00,51235.60,0.00,'2021-09-14 13:02:22'),(1218527,'5','174',397,'Sale Id shift 224440',0.00,383559.00,165.00,383559.00,0.00,'2021-09-14 13:25:57'),(1218528,'5','174',399,'Sale Id shift 224440',0.00,29500.00,295.00,29500.00,0.00,'2021-09-14 13:25:57'),(1218669,'5','174',397,'Sale Id shift 224447',0.00,446803.50,165.00,446803.50,0.00,'2021-09-14 13:51:06'),(1218670,'5','174',399,'Sale Id shift 224447',0.00,170955.45,295.00,170955.45,0.00,'2021-09-14 13:51:06'),(1218747,'5','174',397,'Sale Id shift 224451',0.00,411775.65,165.00,411775.65,0.00,'2021-09-14 14:02:14'),(1218748,'5','174',399,'Sale Id shift 224451',0.00,19325.45,295.00,19325.45,0.00,'2021-09-14 14:02:14'),(1218784,'5','174',397,'Sale Id shift 224453',0.00,402595.05,165.00,402595.05,0.00,'2021-09-14 14:08:18'),(1218785,'5','174',399,'Sale Id shift 224453',0.00,19753.20,295.00,19753.20,0.00,'2021-09-14 14:08:18'),(1218846,'5','174',397,'Sale Id shift 224456',0.00,456149.10,165.00,456149.10,0.00,'2021-09-14 14:21:15'),(1218847,'5','174',399,'Sale Id shift 224456',0.00,26446.75,295.00,26446.75,0.00,'2021-09-14 14:21:15'),(1218890,'5','174',397,'Sale Id shift 224460',0.00,337916.70,165.00,337916.70,0.00,'2021-09-14 14:27:29'),(1218891,'5','174',399,'Sale Id shift 224460',0.00,22797.60,295.00,22797.60,0.00,'2021-09-14 14:27:29'),(1218922,'5','174',397,'Sale Id shift 224461',0.00,352705.65,165.00,352705.65,0.00,'2021-09-14 14:32:46'),(1218923,'5','174',399,'Sale Id shift 224461',0.00,20054.10,295.00,20054.10,0.00,'2021-09-14 14:32:46'),(1239202,'5','174',397,'Sale Id shift 224463',0.00,397650.00,165.00,397650.00,0.00,'2021-09-20 14:18:17'),(1239203,'5','174',399,'Sale Id shift 224463',0.00,65543.10,295.00,65543.10,0.00,'2021-09-20 14:18:17'),(1239265,'5','174',397,'Sale Id shift 225881',0.00,406819.05,165.00,406819.05,0.00,'2021-09-20 14:32:49'),(1239266,'5','174',399,'Sale Id shift 225881',0.00,24405.35,295.00,24405.35,0.00,'2021-09-20 14:32:49'),(1239327,'5','174',397,'Sale Id shift 225889',0.00,400243.80,165.00,400243.80,0.00,'2021-09-20 14:49:19'),(1239328,'5','174',399,'Sale Id shift 225889',0.00,69083.10,295.00,69083.10,0.00,'2021-09-20 14:49:19'),(1239383,'5','174',397,'Sale Id shift 225894',0.00,443214.75,163.00,437842.45,-5372.30,'2021-09-20 14:59:11'),(1239384,'5','174',399,'Sale Id shift 225894',0.00,23322.70,295.00,23322.70,0.00,'2021-09-20 14:59:11'),(1239442,'5','174',397,'Sale Id shift 225901',0.00,561906.64,163.00,561906.64,0.00,'2021-09-20 15:14:36'),(1239443,'5','174',399,'Sale Id shift 225901',0.00,115495.45,295.00,115495.45,0.00,'2021-09-20 15:14:36'),(1239471,'5','174',397,'Sale Id shift 225904',0.00,578258.80,163.00,578258.80,0.00,'2021-09-20 15:24:15'),(1239472,'5','174',399,'Sale Id shift 225904',0.00,206001.45,295.00,206001.45,0.00,'2021-09-20 15:24:15'),(1251321,'5','174',397,'Sale Id shift 226825',0.00,446362.46,163.00,446362.46,0.00,'2021-09-24 11:05:19'),(1251322,'5','174',399,'Sale Id shift 226825',0.00,139001.05,295.00,139001.05,0.00,'2021-09-24 11:05:19'),(1251416,'5','174',397,'Sale Id shift 226829',0.00,455941.97,163.00,455941.97,0.00,'2021-09-24 11:22:46'),(1251417,'5','174',399,'Sale Id shift 226829',0.00,214202.45,295.00,214202.45,0.00,'2021-09-24 11:22:46'),(1252304,'5','174',397,'Sale Id shift 226882',0.00,417200.13,163.00,417200.13,0.00,'2021-09-24 14:26:02'),(1252305,'5','174',399,'Sale Id shift 226882',0.00,86440.90,295.00,86440.90,0.00,'2021-09-24 14:26:02'),(1252339,'5','174',397,'Sale Id shift 226884',0.00,442497.73,163.00,442497.73,0.00,'2021-09-24 14:31:27'),(1252340,'5','174',399,'Sale Id shift 226884',0.00,231005.65,295.00,231005.65,0.00,'2021-09-24 14:31:27'),(1264486,'5','174',397,'Sale Id shift 226889',0.00,496403.46,163.00,496403.46,0.00,'2021-09-28 11:49:20'),(1264487,'5','174',399,'Sale Id shift 226889',0.00,78679.45,295.00,78679.45,0.00,'2021-09-28 11:49:20'),(1264735,'5','174',397,'Sale Id shift 227726',0.00,394319.82,163.00,394319.82,0.00,'2021-09-28 12:30:09'),(1264736,'5','174',399,'Sale Id shift 227726',0.00,109660.35,295.00,109660.35,0.00,'2021-09-28 12:30:09'),(1264948,'5','174',397,'Sale Id shift 227739',0.00,417927.11,163.00,417927.11,0.00,'2021-09-28 13:13:13'),(1264949,'5','174',399,'Sale Id shift 227739',0.00,119767.05,295.00,119767.05,0.00,'2021-09-28 13:13:13'),(1265112,'5','174',397,'Sale Id shift 227764',0.00,779901.21,163.00,779901.21,0.00,'2021-09-28 13:46:13'),(1265113,'5','174',399,'Sale Id shift 227764',0.00,57737.40,295.00,57737.40,0.00,'2021-09-28 13:46:13'),(1286681,'5','174',397,'Sale Id shift 229271',0.00,423659.82,163.00,423659.82,0.00,'2021-10-05 12:20:46'),(1286682,'5','174',399,'Sale Id shift 229271',0.00,64392.60,300.00,65484.00,1091.40,'2021-10-05 12:20:46'),(1286985,'5','174',397,'Sale Id shift 229280',0.00,421092.57,163.00,421092.57,0.00,'2021-10-05 13:27:29'),(1286986,'5','174',399,'Sale Id shift 229280',0.00,31786.25,300.00,32325.00,538.75,'2021-10-05 13:27:29'),(1307327,'5','174',397,'Sale Id shift 229394',0.00,268179.01,163.00,268179.01,0.00,'2021-10-11 13:10:27'),(1307328,'5','174',399,'Sale Id shift 229394',0.00,28765.45,300.00,29253.00,487.55,'2021-10-11 13:10:27'),(1309930,'5','174',397,'Sale Id shift 230852',0.00,204871.44,163.00,204871.44,0.00,'2021-10-12 10:17:05'),(1309931,'5','174',399,'Sale Id shift 230852',0.00,155589.00,300.00,155589.00,0.00,'2021-10-12 10:17:05'),(1309964,'5','174',399,'Sale Id shift 230856',0.00,35499.00,300.00,35499.00,0.00,'2021-10-12 10:26:49'),(1310025,'5','174',399,'Sale Id shift 230863',0.00,88803.00,300.00,88803.00,0.00,'2021-10-12 10:45:18'),(1310161,'5','174',397,'Sale Id shift 230885',0.00,413555.45,163.00,413555.45,0.00,'2021-10-12 11:19:35'),(1310187,'5','174',397,'Sale Id shift 230891',0.00,478515.84,163.00,478515.84,0.00,'2021-10-12 11:25:19'),(1310227,'5','174',397,'Sale Id shift 230894',0.00,482246.91,163.00,482246.91,0.00,'2021-10-12 11:32:09'),(1310245,'5','174',397,'Sale Id shift 230896',0.00,786549.98,163.00,786549.98,0.00,'2021-10-12 11:36:16'),(1310263,'5','174',397,'Sale Id shift 230899',0.00,902151.21,163.00,902151.21,0.00,'2021-10-12 11:41:23'),(1310287,'5','174',397,'Sale Id shift 230902',0.00,1110207.67,163.00,1110207.67,0.00,'2021-10-12 11:45:44'),(1311797,'5','174',397,'Sale Id shift 230905',0.00,510278.02,163.00,510278.02,0.00,'2021-10-13 05:55:18'),(1315069,'5','174',397,'Sale Id shift 231129',0.00,498256.77,163.00,498256.77,0.00,'2021-10-14 07:20:54'),(1317644,'5','174',397,'Sale Id shift 231416',0.00,521707.58,163.00,521707.58,0.00,'2021-10-15 06:00:48'),(1321781,'5','174',397,'Sale Id shift 231655',0.00,657734.34,163.00,657734.34,0.00,'2021-10-16 09:52:51'),(1323954,'5','174',397,'Sale Id shift 231953',0.00,655191.54,163.00,655191.54,0.00,'2021-10-16 19:31:22'),(1327140,'5','174',397,'Sale Id shift 232112',0.00,558636.86,163.00,558636.86,0.00,'2021-10-18 06:12:21'),(1330826,'5','174',397,'Sale Id shift 232356',0.00,588742.96,163.00,588742.96,0.00,'2021-10-19 05:52:59'),(1333958,'5','174',397,'Sale Id shift 232635',0.00,880126.65,163.00,880126.65,0.00,'2021-10-20 05:49:20'),(1337455,'5','174',397,'Sale Id shift 232897',0.00,551094.85,163.00,551094.85,0.00,'2021-10-21 06:04:12'),(1340918,'5','174',397,'Sale Id shift 233122',0.00,572716.80,163.00,572716.80,0.00,'2021-10-22 05:59:14'),(1340919,'5','174',399,'Sale Id shift 233122',0.00,31608.00,345.00,36349.20,4741.20,'2021-10-22 05:59:14'),(1344368,'5','174',397,'Sale Id shift 233419',0.00,639331.64,163.00,639331.64,0.00,'2021-10-23 06:18:26'),(1348151,'5','174',397,'Sale Id shift 233651',0.00,546100.53,163.00,546100.53,0.00,'2021-10-24 06:15:15'),(1351401,'5','174',397,'Sale Id shift 233853',0.00,583810.58,163.00,583810.58,0.00,'2021-10-25 06:05:38'),(1354745,'5','174',397,'Sale Id shift 234131',0.00,1186783.44,163.00,1186783.44,0.00,'2021-10-26 05:39:43'),(1358233,'5','174',397,'Sale Id shift 234389',0.00,756165.15,165.00,765443.25,9278.10,'2021-10-27 06:37:42'),(1361823,'5','174',397,'Sale Id shift 234681',0.00,1167084.89,165.00,1181404.95,14320.06,'2021-10-28 07:20:01'),(1364840,'5','174',397,'Sale Id shift 234924',0.00,754039.63,165.00,763291.65,9252.02,'2021-10-29 06:07:50'),(1370842,'5','174',397,'Sale Id shift 235150',0.00,1602620.89,165.00,1622284.95,19664.06,'2021-10-30 17:30:57'),(1371080,'5','174',397,'Sale Id shift 235478',0.00,1679230.89,165.00,1699834.95,20604.06,'2021-10-31 06:11:19'),(1374359,'5','174',397,'Sale Id shift 235596',0.00,941509.19,165.00,953061.45,11552.26,'2021-11-01 07:25:18'),(1378274,'5','174',397,'Sale Id shift 235870',0.00,1829671.74,165.00,1852121.70,22449.96,'2021-11-02 12:16:32'),(1380053,'5','174',397,'Sale Id shift 236188',0.00,1406199.37,165.00,1423453.35,17253.98,'2021-11-03 08:49:01'),(1384039,'5','174',397,'Sale Id shift 236311',0.00,1081751.55,165.00,1081751.55,0.00,'2021-11-04 09:38:10'),(1387957,'5','174',397,'Sale Id shift 236597',0.00,1342824.45,165.00,1342824.45,0.00,'2021-11-05 06:34:31'),(1392884,'5','174',397,'Sale Id shift 236783',0.00,1765097.40,165.00,1765097.40,0.00,'2021-11-06 07:05:11'),(1400235,'5','174',397,'Sale Id shift 237054',0.00,1047961.20,165.00,1047961.20,0.00,'2021-11-07 12:01:13'),(1402429,'5','174',397,'Sale Id shift 237317',0.00,1811374.95,165.00,1811374.95,0.00,'2021-11-08 06:32:00'),(1406621,'5','174',397,'Sale Id shift 237428',0.00,712017.90,165.00,712017.90,0.00,'2021-11-09 06:13:27'),(1426327,'5','174',397,'Sale Id shift 238429',0.00,1345248.30,165.00,1345248.30,0.00,'2021-11-13 07:24:48'),(1430599,'5','174',397,'Sale Id shift 238644',0.00,947332.65,165.00,947332.65,0.00,'2021-11-14 05:47:44'),(1435263,'5','174',397,'Sale Id shift 238833',0.00,949410.00,165.00,949410.00,0.00,'2021-11-15 06:23:14'),(1439212,'5','174',397,'Sale Id shift 239147',0.00,2238018.75,165.00,2238018.75,0.00,'2021-11-15 19:15:20'),(1443109,'5','174',397,'Sale Id shift 239328',0.00,1650787.05,165.00,1650787.05,0.00,'2021-11-17 05:46:51'),(1447490,'5','174',397,'Sale Id shift 239537',0.00,2422553.10,165.00,2422553.10,0.00,'2021-11-18 06:07:24'),(1452278,'5','174',397,'Sale Id shift 239797',0.00,1723205.55,165.00,1723205.55,0.00,'2021-11-19 07:27:03'),(1456341,'5','174',397,'Sale Id shift 240036',0.00,1565330.25,165.00,1565330.25,0.00,'2021-11-20 07:08:39'),(1462676,'5','174',397,'Sale Id shift 240236',0.00,1595815.65,165.00,1595815.65,0.00,'2021-11-21 10:50:33'),(1462677,'5','174',399,'Sale Id shift 240236',0.00,200193.15,345.00,200193.15,0.00,'2021-11-21 10:50:33'),(1465784,'5','174',397,'Sale Id shift 240531',0.00,1257709.20,165.00,1257709.20,0.00,'2021-11-22 06:21:28'),(1465785,'5','174',399,'Sale Id shift 240531',0.00,50635.65,345.00,50635.65,0.00,'2021-11-22 06:21:28'),(1470763,'5','174',397,'Sale Id shift 240769',0.00,2053048.80,165.00,2053048.80,0.00,'2021-11-23 07:01:40'),(1470764,'5','174',399,'Sale Id shift 240769',0.00,550657.95,345.00,550657.95,0.00,'2021-11-23 07:01:40'),(1475231,'5','174',397,'Sale Id shift 241015',0.00,1481886.45,165.00,1481886.45,0.00,'2021-11-24 06:21:35'),(1475232,'5','174',399,'Sale Id shift 241015',0.00,163202.25,345.00,163202.25,0.00,'2021-11-24 06:21:35'),(1479200,'5','174',397,'Sale Id shift 241249',0.00,1257966.60,165.00,1257966.60,0.00,'2021-11-25 06:25:43'),(1479201,'5','174',399,'Sale Id shift 241249',0.00,111183.15,345.00,111183.15,0.00,'2021-11-25 06:25:43'),(1483442,'5','174',397,'Sale Id shift 241522',0.00,1302420.90,165.00,1302420.90,0.00,'2021-11-26 06:10:13'),(1483443,'5','174',399,'Sale Id shift 241522',0.00,178710.00,345.00,178710.00,0.00,'2021-11-26 06:10:13'),(1488086,'5','174',397,'Sale Id shift 241747',0.00,64472.10,165.00,64472.10,0.00,'2021-11-27 07:08:51'),(1488087,'5','174',399,'Sale Id shift 241747',0.00,104428.05,345.00,104428.05,0.00,'2021-11-27 07:08:51'),(1492760,'5','174',399,'Sale Id shift 242027',0.00,446571.45,345.00,446571.45,0.00,'2021-11-28 06:48:55'),(1497414,'5','174',399,'Sale Id shift 242229',0.00,217967.55,345.00,217967.55,0.00,'2021-11-29 05:58:11'),(1502253,'5','174',399,'Sale Id shift 242450',0.00,203964.00,345.00,203964.00,0.00,'2021-11-30 06:01:24'),(1508791,'5','174',399,'Sale Id shift 242712',0.00,273540.15,345.00,273540.15,0.00,'2021-12-01 10:15:00'),(1512277,'5','174',399,'Sale Id shift 243019',0.00,159186.45,345.00,159186.45,0.00,'2021-12-02 07:20:18'),(1517242,'5','174',399,'Sale Id shift 243180',0.00,250266.45,345.00,250266.45,0.00,'2021-12-03 06:47:04'),(1522111,'5','174',399,'Sale Id shift 243414',0.00,240603.00,345.00,240603.00,0.00,'2021-12-04 06:55:33'),(1527671,'5','174',399,'Sale Id shift 243639',0.00,153090.30,345.00,153090.30,0.00,'2021-12-05 05:45:20'),(1532528,'5','174',399,'Sale Id shift 243888',0.00,115195.50,345.00,115195.50,0.00,'2021-12-06 06:29:20'),(1538093,'5','174',399,'Sale Id shift 244120',0.00,224902.05,345.00,224902.05,0.00,'2021-12-07 06:51:43'),(1543178,'5','174',397,'Sale Id shift 244332',0.00,1325831.10,165.00,1325831.10,0.00,'2021-12-08 07:17:37'),(1543179,'5','174',399,'Sale Id shift 244332',0.00,221352.00,345.00,221352.00,0.00,'2021-12-08 07:17:37'),(1547572,'5','174',397,'Sale Id shift 244699',0.00,968007.15,165.00,968007.15,0.00,'2021-12-09 05:41:36'),(1547573,'5','174',399,'Sale Id shift 244699',0.00,213254.85,345.00,213254.85,0.00,'2021-12-09 05:41:36'),(1552917,'5','174',397,'Sale Id shift 244909',0.00,181485.15,165.00,181485.15,0.00,'2021-12-10 06:15:28'),(1552918,'5','174',399,'Sale Id shift 244909',0.00,156495.45,345.00,156495.45,0.00,'2021-12-10 06:15:28'),(1558368,'5','174',399,'Sale Id shift 245153',0.00,88447.65,345.00,88447.65,0.00,'2021-12-11 06:59:31'),(1568407,'5','174',399,'Sale Id shift 245258',0.00,242935.20,345.00,242935.20,0.00,'2021-12-13 05:58:45'),(1570390,'5','174',399,'Sale Id shift 245761',0.00,75023.70,345.00,75023.70,0.00,'2021-12-13 10:44:12'),(1574119,'5','174',399,'Sale Id shift 245777',0.00,120618.90,345.00,120618.90,0.00,'2021-12-14 07:14:41'),(1578631,'5','174',399,'Sale Id shift 246003',0.00,36894.30,345.00,36894.30,0.00,'2021-12-15 06:39:10'),(1583512,'5','174',397,'Sale Id shift 246270',0.00,761481.60,165.00,761481.60,0.00,'2021-12-16 06:50:51'),(1583513,'5','174',399,'Sale Id shift 246270',0.00,20765.55,345.00,20765.55,0.00,'2021-12-16 06:50:51'),(1588678,'5','174',397,'Sale Id shift 246524',0.00,727329.90,165.00,727329.90,0.00,'2021-12-17 06:10:43'),(1593944,'5','174',397,'Sale Id shift 246783',0.00,695070.75,165.00,695070.75,0.00,'2021-12-18 07:02:54'),(1599879,'5','174',397,'Sale Id shift 247027',0.00,129158.70,165.00,129158.70,0.00,'2021-12-19 07:12:09'),(1621043,'5','174',397,'Sale Id shift 247929',0.00,602413.35,165.00,602413.35,0.00,'2021-12-23 06:29:23'),(1627108,'5','174',397,'Sale Id shift 248216',0.00,637759.65,165.00,637759.65,0.00,'2021-12-24 07:20:08'),(1636733,'5','174',397,'Sale Id shift 248473',0.00,891503.25,165.00,891503.25,0.00,'2021-12-25 14:08:22'),(1641487,'5','174',397,'Sale Id shift 248784',0.00,926433.75,165.00,926433.75,0.00,'2021-12-26 16:46:55'),(1642237,'5','174',397,'Sale Id shift 249030',0.00,1153315.35,165.00,1153315.35,0.00,'2021-12-27 07:40:47'),(1646727,'5','174',397,'Sale Id shift 249162',0.00,1028329.50,165.00,1028329.50,0.00,'2021-12-28 07:35:22'),(1651393,'5','174',397,'Sale Id shift 249394',0.00,923443.95,165.00,923443.95,0.00,'2021-12-29 06:45:21'),(1656108,'5','174',397,'Sale Id shift 249696',0.00,1075184.55,165.00,1075184.55,0.00,'2021-12-30 06:56:48'),(1661409,'5','174',397,'Sale Id shift 249945',0.00,751403.40,165.00,751403.40,0.00,'2021-12-31 06:46:41'),(1667023,'5','174',397,'Sale Id shift 250189',0.00,642836.70,165.00,642836.70,0.00,'2022-01-01 07:49:14'),(1671526,'5','174',397,'Sale Id shift 250509',0.00,827833.05,165.00,827833.05,0.00,'2022-01-02 06:44:41'),(1679622,'5','174',397,'Sale Id shift 250931',0.00,893684.55,165.00,893684.55,0.00,'2022-01-03 14:53:24'),(1681270,'5','174',397,'Sale Id shift 250944',0.00,845818.05,165.00,845818.05,0.00,'2022-01-04 07:04:39'),(1686835,'5','174',397,'Sale Id shift 251183',0.00,1369988.40,165.00,1369988.40,0.00,'2022-01-05 07:34:30'),(1692028,'5','174',397,'Sale Id shift 251305',0.00,1414046.70,165.00,1414046.70,0.00,'2022-01-06 07:46:57'),(1697945,'5','174',397,'Sale Id shift 251537',0.00,1234129.05,165.00,1234129.05,0.00,'2022-01-07 09:08:14'),(1702485,'5','174',397,'Sale Id shift 251846',0.00,1130647.65,165.00,1130647.65,0.00,'2022-01-08 07:57:53'),(1708339,'5','174',397,'Sale Id shift 252047',0.00,1328228.55,165.00,1328228.55,0.00,'2022-01-09 08:02:14'),(1713457,'5','174',397,'Sale Id shift 252297',0.00,959244.00,165.00,959244.00,0.00,'2022-01-10 07:01:43'),(1720374,'5','174',397,'Sale Id shift 252559',0.00,1119204.90,165.00,1119204.90,0.00,'2022-01-11 10:59:56'),(1723978,'5','174',397,'Sale Id shift 252819',0.00,1550292.15,165.00,1550292.15,0.00,'2022-01-12 07:49:18'),(1729151,'5','174',397,'Sale Id shift 253062',0.00,973952.10,165.00,973952.10,0.00,'2022-01-13 07:34:46'),(1735105,'5','174',397,'Sale Id shift 253337',0.00,1095760.05,165.00,1095760.05,0.00,'2022-01-14 09:32:47'),(1739038,'5','174',397,'Sale Id shift 253541',0.00,1077256.95,165.00,1077256.95,0.00,'2022-01-15 07:15:06'),(1744961,'5','174',397,'Sale Id shift 253735',0.00,1134929.40,165.00,1134929.40,0.00,'2022-01-16 07:10:18'),(1749693,'5','174',397,'Sale Id shift 254003',0.00,873600.75,165.00,873600.75,0.00,'2022-01-17 07:13:22'),(1755905,'5','174',397,'Sale Id shift 254216',0.00,669815.85,165.00,669815.85,0.00,'2022-01-18 08:38:13'),(1775974,'5','174',397,'Sale Id shift 255019',0.00,199032.90,165.00,199032.90,0.00,'2022-01-21 11:52:36'),(1779954,'5','174',397,'Sale Id shift 255287',0.00,1142554.05,165.00,1142554.05,0.00,'2022-01-22 08:07:09'),(1785765,'5','174',397,'Sale Id shift 255514',0.00,900528.75,165.00,900528.75,0.00,'2022-01-23 07:22:40'),(1791486,'5','174',397,'Sale Id shift 255759',0.00,823808.70,165.00,823808.70,0.00,'2022-01-24 08:32:16'),(1796671,'5','174',397,'Sale Id shift 256001',0.00,186483.00,165.00,186483.00,0.00,'2022-01-25 07:32:11'),(1825964,'5','174',397,'Sale Id shift 257286',0.00,316823.10,165.00,316823.10,0.00,'2022-01-30 07:43:30'),(1825965,'5','174',397,'Sale Id shift 257545',0.00,1250173.65,165.00,1250173.65,0.00,'2022-01-31 09:32:39'),(1825966,'5','174',397,'Sale Id shift 257546',0.00,1303957.05,165.00,1303957.05,0.00,'2022-02-01 08:32:21'),(1825967,'5','174',397,'Sale Id shift 257547',0.00,788094.45,165.00,788094.45,0.00,'2022-02-02 08:37:04'),(1825968,'5','174',397,'Sale Id shift 257548',0.00,203177.70,165.00,203177.70,0.00,'2022-02-03 06:43:50'),(1825969,'5','174',397,'Sale Id shift 257549',0.00,723785.70,165.00,723785.70,0.00,'2022-02-04 09:12:34'),(1825970,'5','174',397,'Sale Id shift 257550',0.00,1267917.75,165.00,1267917.75,0.00,'2022-02-05 07:53:49'),(1825971,'5','174',397,'Sale Id shift 257551',0.00,1497328.80,165.00,1497328.80,0.00,'2022-02-06 07:49:38'),(1825972,'5','174',397,'Sale Id shift 257552',0.00,1075597.05,165.00,1075597.05,0.00,'2022-02-07 07:18:46'),(1825973,'5','174',397,'Sale Id shift 257553',0.00,1297347.15,165.00,1297347.15,0.00,'2022-02-08 07:44:42'),(1825974,'5','174',397,'Sale Id shift 257554',0.00,1058092.20,165.00,1058092.20,0.00,'2022-02-09 08:21:27'),(1825975,'5','174',397,'Sale Id shift 257555',0.00,513164.85,165.00,513164.85,0.00,'2022-02-10 08:05:02'),(1825976,'5','174',397,'Sale Id shift 257560',0.00,364836.45,165.00,364836.45,0.00,'2022-02-15 08:12:44'),(1825977,'5','174',397,'Sale Id shift 257561',0.00,1866435.45,165.00,1866435.45,0.00,'2022-02-16 07:34:28'),(1825978,'5','174',397,'Sale Id shift 257562',0.00,1573218.90,165.00,1573218.90,0.00,'2022-02-17 07:11:27'),(1825979,'5','174',397,'Sale Id shift 257563',0.00,993669.60,165.00,993669.60,0.00,'2022-02-18 07:25:46'),(1825980,'5','174',397,'Sale Id shift 257564',0.00,159993.90,165.00,159993.90,0.00,'2022-02-19 07:37:07'),(1825981,'5','174',397,'Sale Id shift 257567',0.00,297084.15,165.00,297084.15,0.00,'2022-02-22 06:46:54'),(1825982,'5','174',397,'Sale Id shift 257568',0.00,1866752.25,165.00,1866752.25,0.00,'2022-02-23 07:04:31'),(1825983,'5','174',397,'Sale Id shift 257569',0.00,1712983.80,165.00,1712983.80,0.00,'2022-02-24 09:40:10'),(1825984,'5','174',397,'Sale Id shift 257570',0.00,1730340.15,165.00,1730340.15,0.00,'2022-02-25 11:05:07'),(1825985,'5','174',397,'Sale Id shift 257571',0.00,2885604.15,165.00,2885604.15,0.00,'2022-02-26 07:22:44'),(1825986,'5','174',397,'Sale Id shift 257572',0.00,1062499.35,165.00,1062499.35,0.00,'2022-02-27 07:05:25'),(1825987,'5','174',397,'Sale Id shift 257573',0.00,1418704.65,165.00,1418704.65,0.00,'2022-02-28 07:20:10'),(1825988,'5','174',397,'Sale Id shift 257574',0.00,478061.10,165.00,478061.10,0.00,'2022-03-01 06:58:03'),(1825989,'5','174',397,'Sale Id shift 257575',0.00,3146583.00,165.00,3146583.00,0.00,'2022-03-02 08:22:46'),(1825990,'5','174',397,'Sale Id shift 257576',0.00,637890.00,165.00,637890.00,0.00,'2022-03-03 09:42:38'),(1825991,'5','174',397,'Sale Id shift 257578',0.00,659069.40,165.00,659069.40,0.00,'2022-03-05 12:35:11'),(1825992,'5','174',397,'Sale Id shift 257579',0.00,1664279.10,165.00,1664279.10,0.00,'2022-03-06 07:44:31'),(1825993,'5','174',397,'Sale Id shift 257580',0.00,502095.00,165.00,502095.00,0.00,'2022-03-07 08:01:02'),(1825994,'5','174',397,'Sale Id shift 257585',0.00,344355.00,165.00,344355.00,0.00,'2022-03-12 07:59:58'),(1825995,'5','174',397,'Sale Id shift 257586',0.00,1082167.35,165.00,1082167.35,0.00,'2022-03-13 08:09:06'),(1825996,'5','174',397,'Sale Id shift 257587',0.00,989526.45,165.00,989526.45,0.00,'2022-03-14 07:08:52'),(1825997,'5','174',397,'Sale Id shift 257588',0.00,222987.60,165.00,222987.60,0.00,'2022-03-15 07:10:47'),(1825998,'5','174',397,'Sale Id shift 257598',0.00,683646.15,165.00,683646.15,0.00,'2022-03-25 09:48:45'),(1825999,'5','174',397,'Sale Id shift 257599',0.00,1254557.70,165.00,1254557.70,0.00,'2022-03-26 09:07:28'),(1826000,'5','174',397,'Sale Id shift 257600',0.00,1267619.10,165.00,1267619.10,0.00,'2022-03-27 07:07:43'),(1826001,'5','174',397,'Sale Id shift 257601',0.00,200869.35,165.00,200869.35,0.00,'2022-03-28 09:23:15'),(1826002,'5','174',397,'Sale Id shift 257615',0.00,359568.00,165.00,359568.00,0.00,'2022-04-12 14:17:55'),(1826003,'5','174',397,'Sale Id shift 257616',0.00,761181.30,165.00,761181.30,0.00,'2022-04-13 09:56:35'),(1826004,'5','174',397,'Sale Id shift 257617',0.00,755577.90,165.00,755577.90,0.00,'2022-04-14 08:27:21'),(1826005,'5','174',397,'Sale Id shift 257618',0.00,334720.65,165.00,334720.65,0.00,'2022-04-15 15:19:45'),(1826006,'5','174',397,'Sale Id shift 257622',0.00,525741.15,165.00,525741.15,0.00,'2022-04-19 04:33:45'),(1826007,'5','174',397,'Sale Id shift 257623',0.00,981651.00,165.00,981651.00,0.00,'2022-04-19 22:46:54'),(1826008,'5','174',397,'Sale Id shift 257624',0.00,871985.40,165.00,871985.40,0.00,'2022-04-21 08:56:25'),(1826009,'5','174',397,'Sale Id shift 257625',0.00,878065.65,165.00,878065.65,0.00,'2022-04-22 11:27:01'),(1826010,'5','174',397,'Sale Id shift 257626',0.00,890995.05,165.00,890995.05,0.00,'2022-04-23 09:28:21'),(1826011,'5','174',397,'Sale Id shift 257627',0.00,702739.95,165.00,702739.95,0.00,'2022-04-23 22:09:41'),(1826012,'5','174',397,'Sale Id shift 257628',0.00,1157338.05,165.00,1157338.05,0.00,'2022-04-25 04:55:49'),(1826013,'5','174',397,'Sale Id shift 257629',0.00,924090.75,165.00,924090.75,0.00,'2022-04-26 07:37:13'),(1826014,'5','174',397,'Sale Id shift 257630',0.00,118833.00,165.00,118833.00,0.00,'2022-04-27 08:18:57'),(1826015,'5','174',397,'Sale Id shift 257631',0.00,1025476.65,165.00,1025476.65,0.00,'2022-04-27 16:50:37'),(1826016,'5','174',397,'Sale Id shift 257632',0.00,1031398.50,165.00,1031398.50,0.00,'2022-04-28 07:35:00'),(1826017,'5','174',397,'Sale Id shift 257633',0.00,963565.35,165.00,963565.35,0.00,'2022-04-29 14:22:04'),(1826018,'5','174',397,'Sale Id shift 257634',0.00,1393464.60,165.00,1393464.60,0.00,'2022-05-09 10:24:50'),(1826019,'5','174',397,'Sale Id shift 257635',0.00,1590505.95,165.00,1590505.95,0.00,'2022-05-10 16:00:35'),(1826020,'5','174',397,'Sale Id shift 257636',0.00,845598.60,165.00,845598.60,0.00,'2022-05-10 17:17:25'),(1826021,'5','174',397,'Sale Id shift 257637',0.00,848500.95,165.00,848500.95,0.00,'2022-05-10 17:29:45'),(1826022,'5','174',397,'Sale Id shift 257638',0.00,762303.30,165.00,762303.30,0.00,'2022-05-10 19:58:04'),(1826023,'5','174',397,'Sale Id shift 257639',0.00,184869.30,165.00,184869.30,0.00,'2022-05-11 05:41:05'),(1826024,'5','174',397,'Sale Id shift 257640',0.00,541713.15,165.00,541713.15,0.00,'2022-05-11 08:17:54'),(1826025,'5','174',397,'Sale Id shift 257641',0.00,682976.25,165.00,682976.25,0.00,'2022-05-11 08:28:53'),(1826026,'5','174',397,'Sale Id shift 257642',0.00,785246.55,165.00,785246.55,0.00,'2022-05-11 09:28:52'),(1826027,'5','174',397,'Sale Id shift 257643',0.00,200496.45,165.00,200496.45,0.00,'2022-05-11 09:39:19'),(1826028,'5','174',397,'Sale Id shift 257659',0.00,355248.30,165.00,355248.30,0.00,'2022-05-25 07:31:01'),(1826029,'5','174',397,'Sale Id shift 257660',0.00,762469.95,165.00,762469.95,0.00,'2022-05-26 05:41:58'),(1826030,'5','174',397,'Sale Id shift 257661',0.00,779563.95,165.00,779563.95,0.00,'2022-05-27 05:53:41'),(1826031,'5','174',397,'Sale Id shift 257662',0.00,832014.15,165.00,832014.15,0.00,'2022-05-28 09:48:14'),(1826032,'5','174',397,'Sale Id shift 257663',0.00,847101.75,165.00,847101.75,0.00,'2022-05-29 09:42:41'),(1826033,'5','174',397,'Sale Id shift 257664',0.00,851586.45,165.00,851586.45,0.00,'2022-05-30 06:26:22'),(1826034,'5','174',397,'Sale Id shift 257665',0.00,365475.00,165.00,365475.00,0.00,'2022-05-31 10:02:58'),(1826035,'5','174',397,'Sale Id shift 257670',0.00,301186.05,165.00,301186.05,0.00,'2022-06-05 08:11:49'),(1826036,'5','174',397,'Sale Id shift 257671',0.00,827435.40,165.00,827435.40,0.00,'2022-06-06 09:47:34'),(1826037,'5','174',397,'Sale Id shift 257672',0.00,696088.80,165.00,696088.80,0.00,'2022-06-07 06:51:35'),(1826038,'5','174',397,'Sale Id shift 257673',0.00,843841.35,165.00,843841.35,0.00,'2022-06-08 09:06:01'),(1826039,'5','174',397,'Sale Id shift 257674',0.00,713260.35,165.00,713260.35,0.00,'2022-06-09 14:11:03'),(1826040,'5','174',397,'Sale Id shift 257675',0.00,682852.50,165.00,682852.50,0.00,'2022-06-10 05:47:10'),(1826041,'5','174',397,'Sale Id shift 257676',0.00,661819.95,165.00,661819.95,0.00,'2022-06-12 12:35:12'),(1826042,'5','174',397,'Sale Id shift 257677',0.00,629351.25,165.00,629351.25,0.00,'2022-06-13 07:04:06'),(1826043,'5','174',397,'Sale Id shift 257678',0.00,682151.25,165.00,682151.25,0.00,'2022-06-14 06:50:11'),(1826044,'5','174',397,'Sale Id shift 257679',0.00,519296.25,165.00,519296.25,0.00,'2022-06-14 10:54:06'),(1826045,'5','174',397,'Sale Id shift 257684',0.00,84517.95,165.00,84517.95,0.00,'2022-06-19 06:59:42'),(1826046,'5','174',397,'Sale Id shift 257704',0.00,810592.20,165.00,810592.20,0.00,'2022-07-09 15:18:48'),(1826047,'5','174',397,'Sale Id shift 257705',0.00,695983.20,165.00,695983.20,0.00,'2022-07-10 13:25:40'),(1826048,'5','174',397,'Sale Id shift 257706',0.00,602604.75,165.00,602604.75,0.00,'2022-07-11 07:40:45'),(1826049,'5','174',397,'Sale Id shift 257707',0.00,516171.15,165.00,516171.15,0.00,'2022-07-12 08:43:09'),(1826050,'5','174',397,'Sale Id shift 257708',0.00,171436.65,185.00,192216.85,20780.20,'2022-07-13 06:13:21'),(1826051,'5','174',397,'Sale Id shift 257710',0.00,631257.00,185.00,707773.00,76516.00,'2022-07-15 11:38:25'),(1826052,'5','174',397,'Sale Id shift 257711',0.00,951392.10,185.00,951392.10,0.00,'2022-07-16 08:23:03'),(1826053,'5','174',397,'Sale Id shift 257712',0.00,1030947.65,185.00,1030947.65,0.00,'2022-07-17 06:05:43'),(1826054,'5','174',397,'Sale Id shift 257713',0.00,1154028.15,185.00,1154028.15,0.00,'2022-07-18 07:34:42'),(1826055,'5','174',397,'Sale Id shift 257714',0.00,1130394.40,185.00,1130394.40,0.00,'2022-07-19 12:50:17'),(1826056,'5','174',397,'Sale Id shift 257715',0.00,1225221.70,185.00,1225221.70,0.00,'2022-07-20 09:43:56'),(1826057,'5','174',397,'Sale Id shift 257716',0.00,1310436.40,185.00,1310436.40,0.00,'2022-07-21 07:46:58'),(1826058,'5','174',397,'Sale Id shift 257717',0.00,1021061.25,185.00,1021061.25,0.00,'2022-07-22 07:02:30'),(1826059,'5','174',397,'Sale Id shift 257718',0.00,858914.30,185.00,858914.30,0.00,'2022-07-23 07:31:07'),(1826060,'5','174',397,'Sale Id shift 257719',0.00,1005824.65,165.00,897086.85,-108737.80,'2022-07-24 06:58:23'),(1826061,'5','174',397,'Sale Id shift 257720',0.00,944256.65,165.00,842174.85,-102081.80,'2022-07-25 09:27:42'),(1826062,'5','174',397,'Sale Id shift 257721',0.00,926546.60,185.00,926546.60,0.00,'2022-07-26 07:43:54'),(1826063,'5','174',397,'Sale Id shift 257728',0.00,465972.45,185.00,465972.45,0.00,'2022-08-02 10:31:26'),(1826064,'5','174',397,'Sale Id shift 257729',0.00,1008869.75,185.00,1008869.75,0.00,'2022-08-03 06:59:30'),(1826065,'5','174',397,'Sale Id shift 257730',0.00,885511.75,185.00,885511.75,0.00,'2022-08-04 06:53:02'),(1826066,'5','174',397,'Sale Id shift 257731',0.00,933811.55,185.00,933811.55,0.00,'2022-08-05 06:38:50'),(1826067,'5','174',397,'Sale Id shift 257732',0.00,966482.55,185.00,966482.55,0.00,'2022-08-06 09:12:37'),(1826068,'5','174',397,'Sale Id shift 257733',0.00,892397.45,185.00,892397.45,0.00,'2022-08-07 07:14:22'),(1826069,'5','174',397,'Sale Id shift 257734',0.00,390705.20,185.00,390705.20,0.00,'2022-09-06 10:38:15'),(1826070,'5','174',397,'Sale Id shift 257737',0.00,583628.75,185.00,583628.75,0.00,'2022-09-06 11:15:32'),(1826071,'5','174',397,'Sale Id shift 257738',0.00,1111324.60,185.00,1111324.60,0.00,'2022-09-06 11:44:39'),(1826072,'5','174',397,'Sale Id shift 257739',0.00,956192.85,185.00,956192.85,0.00,'2022-09-06 12:10:17'),(1826073,'5','174',397,'Sale Id shift 257740',0.00,998896.40,185.00,998896.40,0.00,'2022-09-06 12:23:54'),(1826074,'5','174',397,'Sale Id shift 257741',0.00,1040144.00,185.00,1040144.00,0.00,'2022-09-06 16:37:31'),(1826075,'5','174',397,'Sale Id shift 257742',0.00,1280264.75,185.00,1280264.75,0.00,'2022-09-06 16:55:00'),(1826076,'5','174',397,'Sale Id shift 257743',0.00,1243784.60,185.00,1243784.60,0.00,'2022-09-07 09:54:26'),(1826077,'5','174',397,'Sale Id shift 257744',0.00,1266330.55,185.00,1266330.55,0.00,'2022-09-07 10:03:37'),(1826078,'5','174',397,'Sale Id shift 257745',0.00,1189030.15,185.00,1189030.15,0.00,'2022-09-07 12:49:11'),(1826079,'5','174',397,'Sale Id shift 257746',0.00,1314243.70,185.00,1314243.70,0.00,'2022-09-07 13:08:11'),(1826080,'5','174',397,'Sale Id shift 257747',0.00,1062573.40,185.00,1062573.40,0.00,'2022-09-07 13:16:41'),(1826081,'5','174',397,'Sale Id shift 257748',0.00,890308.80,185.00,890308.80,0.00,'2022-09-07 13:22:25'),(1826082,'5','174',397,'Sale Id shift 257749',0.00,965947.90,185.00,965947.90,0.00,'2022-09-07 15:47:04'),(1826083,'5','174',397,'Sale Id shift 257750',0.00,877340.30,185.00,877340.30,0.00,'2022-09-07 16:42:50'),(1826084,'5','174',397,'Sale Id shift 257751',0.00,378593.25,185.00,378593.25,0.00,'2022-09-07 17:24:55'),(1826085,'5','174',397,'Sale Id shift 257752',0.00,594691.75,185.00,594691.75,0.00,'2022-09-08 09:28:55'),(1826086,'5','174',397,'Sale Id shift 257753',0.00,966774.85,185.00,966774.85,0.00,'2022-09-08 09:37:10'),(1826087,'5','174',397,'Sale Id shift 257754',0.00,1151465.90,185.00,1151465.90,0.00,'2022-09-08 09:43:33'),(1826088,'5','174',397,'Sale Id shift 257755',0.00,1112038.70,185.00,1112038.70,0.00,'2022-09