-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_173
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_173`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_173` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_173`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3231 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3177,4017,'',0,'20','5','173','SALES','','2021-02-22 19:10:15',5,0.00,0.00,'','602','2021-02-22 19:10:15','602',0,1),(3178,3019,'',0,'6.1','5','173','CASH','','2021-02-22 19:10:30',5,0.00,0.00,'','602','2021-02-22 19:10:30','602',0,1),(3179,4002,'',0,'22','5','173','PURCHASES','','2021-02-22 19:11:08',5,0.00,0.00,'','602','2021-02-22 19:11:08','602',0,1),(3180,30152,'',0,'24','5','173','SALARIES & WAGES','','2021-02-22 19:11:45',5,0.00,0.00,'','602','2021-02-22 19:11:45','602',0,1),(3181,30153,'',0,'24','5','173','PURCHASES','','2021-02-22 19:14:47',5,0.00,0.00,'','602','2021-02-22 19:14:47','602',0,1),(3228,4015,'',0,'2','5','173','FIRST BANK:EBILLS-2009876215','','2021-03-06 01:14:17',5,0.00,0.00,'','600','2021-03-06 01:14:17','600',0,1),(3229,4016,'',0,'2','5','173','JA\'IZ-0010037957','','2022-03-02 19:11:21',5,0.00,0.00,'','600','2022-03-02 19:11:21','600',0,0),(3230,2000,'',0,'6','5','173','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:35:09',5,0.00,0.00,'','600','2023-02-06 10:35:09','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','173','0000-00-00','2023-02-07 14:22:03',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','173','0000-00-00','2023-02-22 13:12:39',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','173','1','3230','6',0.00,'PMS Price Increase (185 to 220,300 litres on 20/1/2023',10500.00,'2023-02-07'),(2,'5','173','1','217','supplier',10500.00,'PMS Price Increase (185 to 220, 300litres on 20/1/2023',0.00,'2023-02-07'),(3,'5','173','2','217','supplier',0.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',3000.00,'2023-02-19'),(4,'5','173','2','217','supplier',3000.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',0.00,'2023-02-19'),(5,'5','173','2','217','supplier',0.00,'Ago Price decrease 830 to 820 100litres on 20/2/2023',1000.00,'2023-02-20'),(6,'5','173','2','217','supplier',1000.00,'Ago Price decrease 830 to 820 100litres on 20/2/2023',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','173',1,'905',5989.45,100.00,'2023-03-10','','2023-03-10 10:39:27','600','600',2023,'600','2023-03-10 10:39:27',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2689 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','173','904',2683,'5','PMS PUMP 1',453522.06,'PMS DISPENSER','',NULL,NULL,'',5,'2023-03-10 13:27:47','600'),('5','173','904',2684,'5','PMS PUMP 2',711033.89,'PMS DISPENSER','',NULL,NULL,'',5,'2023-03-10 13:28:19','600'),('5','173','905',2685,'5','PMS PUMP 3',415679.27,'PMS DISPENSER','',NULL,NULL,'',5,'2023-03-10 13:28:54','600'),('5','173','905',2686,'5','PMS PUMP 4',313461.29,'PMS DISPENSER','',NULL,NULL,'',5,'2023-03-10 13:29:55','600'),('5','173','906',2687,'5','AGO PUMP',69550.41,'AGO DISPENSER','',NULL,NULL,'',5,'2021-10-08 15:22:01','600'),('5','173','907',2688,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257988 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','173',182030,'MORNING','2021-03-02','2021-03-02 00:00:00',NULL,'600',0.00,393359.00,'602','2021-03-15 14:16:53','607','2021-03-15 14:30:32',10,0),('5','173',184618,'MORNING','2021-03-03','2021-03-03 00:00:00',NULL,'602',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',184629,'MORNING','2021-03-03','2021-03-03 00:00:00',NULL,'602',0.00,474197.50,'602','2021-03-15 15:48:24','607','2021-03-15 15:52:42',10,0),('5','173',184634,'MORNING','2021-03-04','2021-03-04 00:00:00',NULL,'602',0.00,19250.00,'602','2021-03-15 16:00:28','607','2021-03-15 16:07:29',10,0),('5','173',184635,'MORNING','2021-03-05','2021-03-05 00:00:00',NULL,'602',207604.95,247834.95,'602','2021-03-15 16:23:21','607','2021-03-16 09:35:27',10,0),('5','173',184745,'MORNING','2021-03-06','2021-03-06 00:00:00',NULL,'602',674617.88,710070.38,'602','2021-03-16 09:44:25','607','2021-03-16 09:48:40',10,0),('5','173',184749,'MORNING','2021-03-07','2021-03-07 00:00:00',NULL,'602',764005.45,786945.45,'602','2021-03-16 09:56:13','607','2021-03-16 09:58:33',10,0),('5','173',184756,'MORNING','2021-03-08','2021-03-08 00:00:00',NULL,'602',1251950.84,1399238.34,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',184778,'MORNING','2021-03-08','2021-03-08 00:00:00',NULL,'602',1251950.84,1636200.84,'602','2021-03-16 11:40:28','607','2021-03-16 11:51:50',10,0),('5','173',184950,'MORNING','2021-03-09','2021-03-09 00:00:00',NULL,'602',881618.10,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',184958,'MORNING','2021-03-09','2021-03-09 00:00:00',NULL,'602',881613.21,881613.21,'602','2021-03-17 10:30:03','607','2021-03-17 11:06:15',10,0),('5','173',184969,'MORNING','2021-03-10','2021-03-10 00:00:00',NULL,'602',989255.15,989255.15,'602','2021-03-17 11:22:26','607','2021-03-17 11:42:13',10,0),('5','173',184987,'MORNING','2021-03-11','2021-03-11 00:00:00',NULL,'602',1310932.39,1310932.39,'602','2021-03-17 12:08:42','607','2021-03-17 12:33:18',10,0),('5','173',185016,'MORNING','2021-03-12','2021-03-12 00:00:00',NULL,'602',2055315.90,2055315.90,'602','2021-03-17 14:05:45','607','2021-03-17 14:10:13',10,0),('5','173',185022,'MORNING','2021-03-13','2021-03-13 00:00:00',NULL,'602',2195099.81,2195099.81,'602','2021-03-22 11:49:04','607','2021-03-22 15:30:14',10,0),('5','173',186012,'MORNING','2021-03-14','2021-03-14 00:00:00',NULL,'602',1331679.03,1331679.03,'602','2021-03-22 15:43:51','607','2021-03-22 15:45:31',10,0),('5','173',186014,'MORNING','2021-03-15','2021-03-15 00:00:00',NULL,'602',1358301.82,1358301.82,'602','2021-03-22 15:48:26','607','2021-03-22 15:49:30',10,0),('5','173',186016,'MORNING','2021-03-16','2021-03-16 00:00:00',NULL,'602',815000.00,815000.00,'602','2021-03-22 15:55:40','607','2021-03-22 16:13:19',10,0),('5','173',186024,'MORNING','2021-03-17','2021-03-17 00:00:00',NULL,'602',293400.00,293400.00,'602','2021-03-22 16:15:09','607','2021-03-22 16:18:10',10,0),('5','173',186026,'MORNING','2021-03-18','2021-03-18 00:00:00',NULL,'602',163000.00,163000.00,'602','2021-03-22 16:20:38','607','2021-03-22 16:30:46',10,0),('5','173',186028,'MORNING','2021-03-19','2021-03-19 00:00:00',NULL,'602',316783.98,316783.98,'602','2021-03-22 16:32:28','607','2021-03-22 17:15:50',10,0),('5','173',186115,'MORNING','2021-03-20','2021-03-20 00:00:00',NULL,'602',1634132.05,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',186124,'MORNING','2021-03-20','2021-03-20 00:00:00',NULL,'602',1634132.05,1634132.05,'602','2021-03-23 08:32:23','607','2021-03-23 08:47:32',10,0),('5','173',186128,'MORNING','2021-03-21','2021-03-21 00:00:00',NULL,'602',1300678.06,1300678.06,'602','2021-03-23 08:53:08','607','2021-03-23 09:00:30',10,0),('5','173',186131,'MORNING','2021-03-22','2021-03-22 00:00:00',NULL,'602',1394161.82,1394161.82,'602','2021-03-23 09:04:35','607','2021-03-23 09:20:01',10,0),('5','173',186349,'MORNING','2021-03-23','2021-03-23 00:00:00',NULL,'602',1319605.62,1319605.62,'602','2021-03-24 08:23:55','607','2021-03-24 14:38:32',10,0),('5','173',186670,'MORNING','2021-03-24','2021-03-24 00:00:00',NULL,'602',1325830.59,1325830.59,'602','2021-03-25 14:24:41','607','2021-03-25 16:02:06',10,0),('5','173',186913,'MORNING','2021-03-25','2021-03-25 00:00:00',NULL,'602',1133946.99,1133946.99,'602','2021-03-26 16:27:48','607','2021-03-26 19:23:29',10,0),('5','173',186968,'MORNING','2021-03-26','2021-03-26 00:00:00',NULL,'602',1034627.83,1034627.83,'602','2021-03-27 14:09:35','607','2021-03-28 09:04:58',10,0),('5','173',187227,'Morning','2021-03-27','2021-03-27 00:00:00',NULL,'602',1193415.91,1193415.91,'602','2021-03-28 10:43:00','607','2021-03-28 13:59:17',10,0),('5','173',187326,'Morning','2021-03-28','2021-03-28 00:00:00',NULL,'602',1308599.86,1308599.86,'602','2021-03-29 06:23:45','607','2021-03-29 13:29:55',10,0),('5','173',187510,'Morning','2021-03-29','2021-03-29 00:00:00',NULL,'602',1187909.77,1187909.77,'602','2021-03-30 11:53:25','607','2021-03-30 16:31:37',10,0),('5','173',187773,'Morning','2021-03-30','2021-03-30 00:00:00',NULL,'602',940994.11,940994.11,'602','2021-03-30 21:12:09','607','2021-03-31 05:48:24',10,0),('5','173',187916,'Morning','2021-03-31','2021-03-31 00:00:00',NULL,'602',1053705.35,1053705.35,'602','2021-03-31 20:14:25','607','2021-03-31 20:18:54',10,0),('5','173',188002,'Morning','2021-04-01','2021-04-01 00:00:00',NULL,'602',1393635.33,1393635.33,'602','2021-04-01 21:49:31','607','2021-04-02 06:50:15',10,0),('5','173',188231,'Morning','2021-04-02','2021-04-02 00:00:00',NULL,'602',1508049.92,1508049.92,'602','2021-04-02 20:18:12','607','2021-04-03 06:14:27',10,0),('5','173',188435,'Morning','2021-04-03','2021-04-03 00:00:00',NULL,'602',1632004.90,1632004.90,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',188649,'Morning','2021-04-03','2021-04-03 00:00:00',NULL,'602',2013726.80,2013726.80,'602','2021-04-04 15:19:49','607','2021-04-04 15:32:21',10,0),('5','173',188726,'Morning','2021-04-04','2021-04-04 00:00:00',NULL,'602',1419579.59,1419579.59,'602','2021-04-04 20:49:53','607','2021-04-05 07:39:32',10,0),('5','173',188828,'Morning','2021-04-05','2021-04-05 00:00:00',NULL,'602',951956.42,951956.42,'602','2021-04-05 21:00:39','607','2021-04-06 09:39:10',10,0),('5','173',189075,'Morning','2021-04-06','2021-04-06 00:00:00',NULL,'602',794142.51,794142.51,'602','2021-04-06 20:15:40','604','2021-04-07 07:06:30',10,0),('5','173',189262,'Morning','2021-04-07','2021-04-07 00:00:00',NULL,'602',712814.92,0.00,'602','2021-04-07 20:06:05','607','2021-04-07 21:38:11',10,0),('5','173',189565,'Morning','2021-04-08','2021-04-08 00:00:00',NULL,'602',53227.90,53227.90,'602','2021-04-08 20:31:07','607','2021-04-09 08:12:11',10,0),('5','173',189697,'Morning','2021-04-09','2021-04-09 00:00:00',NULL,'602',201930.00,201930.00,'602','2021-04-09 19:53:20','607','2021-04-10 08:24:57',10,0),('5','173',189856,'Morning','2021-04-10','2021-04-10 00:00:00',NULL,'602',46157.70,46157.70,'602','2021-04-10 19:53:56','607','2021-04-11 09:22:50',10,0),('5','173',190153,'Morning','2021-04-11','2021-04-11 00:00:00',NULL,'602',71663.95,71663.95,'602','2021-04-11 20:02:48','607','2021-04-12 10:04:07',10,0),('5','173',190277,'Morning','2021-04-12','2021-04-12 00:00:00',NULL,'602',40764.95,40764.95,'602','2021-04-12 19:29:09','607','2021-04-13 07:37:47',10,0),('5','173',190453,'Morning','2021-04-13','2021-04-13 00:00:00',NULL,'602',33397.95,33397.95,'602','2021-04-13 19:55:02','607','2021-04-14 07:52:59',10,0),('5','173',190700,'Morning','2021-04-14','2021-04-14 00:00:00',NULL,'602',43881.35,43881.35,'602','2021-04-14 19:47:41','607','2021-04-15 08:24:27',10,0),('5','173',190969,'Morning','2021-04-15','2021-04-15 00:00:00',NULL,'602',39010.65,39010.65,'602','2021-04-15 19:55:46','607','2021-04-16 08:39:55',10,0),('5','173',191145,'Morning','2021-04-16','2021-04-16 00:00:00',NULL,'602',45315.00,45315.00,'602','2021-04-16 19:53:49','607','2021-04-17 12:37:26',10,0),('5','173',191410,'Morning','2021-04-17','2021-04-17 00:00:00',NULL,'602',72246.95,72246.95,'602','2021-04-17 20:14:56','607','2021-04-18 10:21:52',10,0),('5','173',191569,'Morning','2021-04-18','2021-04-18 00:00:00',NULL,'602',318956.65,318956.65,'602','2021-04-18 20:00:43','607','2021-04-19 09:37:33',10,0),('5','173',191836,'Morning','2021-04-19','2021-04-19 00:00:00',NULL,'602',113282.20,113282.20,'602','2021-04-19 20:07:01','607','2021-04-20 09:03:39',10,0),('5','173',191988,'Morning','2021-04-20','2021-04-20 00:00:00',NULL,'602',54325.00,54325.00,'602','2021-04-20 20:25:50','607','2021-04-21 10:45:03',10,0),('5','173',192226,'Morning','2021-04-21','2021-04-21 00:00:00',NULL,'602',58501.40,58501.40,'602','2021-04-21 20:37:18','607','2021-04-22 08:14:10',10,0),('5','173',192406,'Morning','2021-04-22','2021-04-22 00:00:00',NULL,'602',53482.30,53482.30,'602','2021-04-22 21:44:27','607','2021-04-23 09:25:34',10,0),('5','173',192613,'Morning','2021-04-23','2021-04-23 00:00:00',NULL,'602',70225.00,70225.00,'602','2021-04-23 20:07:04','607','2021-04-24 08:58:24',10,0),('5','173',193750,'Morning','2021-04-23','2021-04-23 00:00:00',NULL,'602',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',193941,'morning','2021-04-24','2021-04-24 00:00:00',NULL,'602',61215.00,61215.00,'602','2021-04-29 10:41:11','607','2021-04-29 10:43:08',10,0),('5','173',193945,'morning','2021-04-25','2021-04-25 00:00:00',NULL,'602',101643.40,101643.40,'602','2021-04-29 10:50:26','607','2021-04-29 10:55:53',10,0),('5','173',193950,'morning','2021-04-26','2021-04-26 00:00:00',NULL,'602',65720.00,65720.00,'602','2021-04-29 11:06:15','607','2021-04-29 11:10:50',10,0),('5','173',193958,'morning','2021-04-27','2021-04-27 00:00:00',NULL,'602',64066.40,64066.40,'602','2021-04-29 11:16:06','607','2021-04-29 11:19:25',10,0),('5','173',193963,'morning','2021-04-28','2021-04-28 00:00:00',NULL,'602',42665.00,42665.00,'602','2021-04-29 11:38:34','607','2021-04-29 11:39:43',10,0),('5','173',194197,'morning','2021-04-29','2021-04-29 00:00:00',NULL,'602',82521.00,82521.00,'602','2021-04-30 13:49:36','607','2021-05-01 10:58:36',10,0),('5','173',194378,'morning','2021-04-30','2021-04-30 00:00:00',NULL,'602',110968.75,110968.75,'602','2021-05-01 11:15:59','607','2021-05-01 11:19:15',10,0),('5','173',194379,'morning','2021-05-01','2021-05-01 00:00:00',NULL,'602',126362.60,126362.60,'602','2021-05-03 07:55:47','607','2021-05-03 08:36:53',10,0),('5','173',194734,'morning','2021-05-02','2021-05-02 00:00:00',NULL,'602',289455.10,289455.10,'602','2021-05-04 06:15:40','607','2021-05-04 11:20:53',10,0),('5','173',195005,'morning','2021-05-03','2021-05-03 00:00:00',NULL,'602',514875.95,514875.95,'602','2021-05-04 15:31:06','607','2021-05-04 15:46:33',10,0),('5','173',195015,'morning','2021-05-04','2021-05-04 00:00:00',NULL,'602',446017.00,446017.00,'602','2021-05-05 16:30:38','607','2021-05-06 09:09:18',10,0),('5','173',195357,'morning','2021-05-05','2021-05-05 00:00:00',NULL,'602',507081.30,507081.30,'602','2021-05-06 12:01:59','607','2021-05-06 12:06:23',10,0),('5','173',195416,'morning','2021-05-06','2021-05-06 00:00:00',NULL,'602',541820.20,541820.20,'602','2021-05-07 05:11:27','607','2021-05-07 16:11:47',10,0),('5','173',195767,'morning','2021-05-07','2021-05-07 00:00:00',NULL,'602',880923.05,880923.05,'602','2021-05-08 05:07:22','607','2021-05-08 12:02:23',10,0),('5','173',195878,'morning','2021-05-08','2021-05-08 00:00:00',NULL,'602',595861.30,595861.30,'602','2021-05-09 05:19:55','607','2021-05-09 10:13:51',10,0),('5','173',196092,'morning','2021-05-09','2021-05-09 00:00:00',NULL,'602',505560.35,505560.35,'602','2021-05-10 17:21:44','607','2021-05-10 17:28:30',10,0),('5','173',196408,'Morning','2021-05-10','2021-05-10 00:00:00',NULL,'602',628300.25,628300.25,'602','2021-05-11 14:19:06','607','2021-05-11 14:26:14',10,0),('5','173',196592,'Morning','2021-05-11','2021-05-11 00:00:00',NULL,'602',498055.30,498055.30,'602','2021-05-12 15:40:48','607','2021-05-12 15:42:28',10,0),('5','173',196813,'Morning','2021-05-12','2021-05-12 00:00:00',NULL,'602',364159.75,364159.75,'602','2021-05-13 08:58:49','607','2021-05-13 12:27:10',10,0),('5','173',196935,'Morning','2021-05-13','2021-05-13 00:00:00',NULL,'602',211174.60,211174.60,'602','2021-05-14 08:46:36','607','2021-05-14 21:38:49',10,0),('5','173',197652,'Morning','2021-05-14','2021-05-14 00:00:00',NULL,'602',279419.70,279419.70,'602','2021-05-17 11:27:40','607','2021-05-17 11:31:50',10,0),('5','173',197654,'Morning','2021-05-15','2021-05-15 00:00:00',NULL,'602',418827.75,418827.75,'602','2021-05-17 11:36:28','607','2021-05-17 11:43:55',10,0),('5','173',197662,'Morning','2021-05-16','2021-05-16 00:00:00',NULL,'602',500538.00,500538.00,'602','2021-05-17 11:46:57','607','2021-05-17 11:49:51',10,0),('5','173',197668,'Morning','2021-05-17','2021-05-17 00:00:00',NULL,'602',519269.25,519269.25,'602','2021-05-18 11:40:33','607','2021-05-18 11:46:39',10,0),('5','173',197989,'Morning','2021-05-18','2021-05-18 00:00:00',NULL,'602',489831.15,490703.70,'602','2021-05-19 12:01:41','607','2021-05-19 12:03:33',10,0),('5','173',198228,'Morning','2021-05-19','2021-05-19 00:00:00',NULL,'602',233650.00,233700.00,'602','2021-05-20 10:48:17','607','2021-05-20 10:50:00',10,0),('5','173',198432,'Morning','2021-05-20','2021-05-20 00:00:00',NULL,'602',10698.05,10899.90,'602','2021-05-21 15:59:45','607','2021-05-21 16:13:17',10,0),('5','173',198720,'Morning','2021-05-21','2021-05-21 00:00:00',NULL,'602',452370.20,452370.20,'602','2021-05-23 10:01:44','607','2021-05-23 10:07:19',10,0),('5','173',199047,'Morning ','2021-05-22','2021-05-22 00:00:00',NULL,'602',357112.45,357477.00,'602','2021-05-23 10:38:48','607','2021-05-23 10:44:27',10,0),('5','173',199067,'Morning ','2021-05-23','2021-05-23 00:00:00',NULL,'602',369243.95,369447.00,'602','2021-05-24 07:51:40','607','2021-05-24 07:54:33',10,0),('5','173',199255,'Morning ','2021-05-24','2021-05-24 00:00:00',NULL,'602',132000.00,132000.00,'602','2021-05-25 09:02:18','607','2021-05-25 09:29:12',10,0),('5','173',199511,'Morning','2021-05-24','2021-05-24 00:00:00',NULL,'602',133710.20,132925.30,'602','2021-05-25 09:37:27','607','2021-05-25 09:40:37',10,0),('5','173',199516,'Morning','2021-05-25','2021-05-25 00:00:00',NULL,'602',306060.80,303074.46,'602','2021-05-26 08:00:40','607','2021-05-26 10:16:34',10,0),('5','173',199765,'Morning','2021-05-26','2021-05-26 00:00:00',NULL,'602',234708.45,234929.10,'602','2021-05-27 08:47:14','607','2021-05-27 08:48:37',10,0),('5','173',199960,'Morning','2021-05-27','2021-05-27 00:00:00',NULL,'602',351543.90,347414.32,'602','2021-05-28 15:52:16','607','2021-05-28 15:57:59',10,0),('5','173',200246,'Morning','2021-05-28','2021-05-28 00:00:00',NULL,'602',414561.15,415460.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',200536,'Morning','2021-05-28','2021-05-28 00:00:00',NULL,'602',414561.15,411012.87,'602','2021-05-30 09:29:56','607','2021-05-30 09:32:26',10,0),('5','173',200537,'Morning','2021-05-29','2021-05-29 00:00:00',NULL,'602',424812.65,421370.87,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',200554,'Morning','2021-05-29','2021-05-29 00:00:00',NULL,'602',689812.65,691370.87,'602','2021-05-30 10:29:34','607','2021-05-30 10:32:39',10,0),('5','173',200558,'Morning','2021-05-30','2021-05-30 00:00:00',NULL,'602',598198.15,596835.19,'602','2021-05-31 09:57:31','607','2021-05-31 10:20:55',10,0),('5','173',200831,'Morning','2021-05-31','2021-05-31 00:00:00',NULL,'602',583635.40,583635.40,'602','2021-06-01 13:26:50','607','2021-06-01 14:04:13',10,0),('5','173',201050,'Morning','2021-06-01','2021-06-01 00:00:00',NULL,'602',438996.92,438996.92,'602','2021-06-02 09:05:39','607','2021-06-02 09:16:10',10,0),('5','173',201171,'Morning','2021-06-02','2021-06-02 00:00:00',NULL,'602',372926.98,372926.98,'602','2021-06-03 05:30:05','607','2021-06-03 08:40:38',10,0),('5','173',201380,'Morning','2021-06-03','2021-06-03 00:00:00',NULL,'602',196449.94,196449.94,'602','2021-06-04 16:05:57','607','2021-06-04 16:36:00',10,0),('5','173',201746,'Morning','2021-06-04','2021-06-04 00:00:00',NULL,'602',82020.24,82020.24,'602','2021-06-04 23:05:43','607','2021-06-05 07:44:31',10,0),('5','173',201788,'Morning','2021-06-05','2021-06-05 00:00:00',NULL,'602',499605.19,499605.19,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',202187,'Morning','2021-06-05','2021-06-05 00:00:00',NULL,'602',502767.79,502767.79,'602','2021-06-06 20:41:20','607','2021-06-06 20:44:30',10,0),('5','173',202188,'Morning','2021-06-06','2021-06-06 00:00:00',NULL,'602',692347.88,692347.88,'602','2021-06-06 20:52:13','607','2021-06-07 05:27:48',10,0),('5','173',202238,'Morning','2021-06-07','2021-06-07 00:00:00',NULL,'602',722028.43,722028.43,'602','2021-06-07 21:32:29','607','2021-06-08 05:48:31',10,0),('5','173',202624,'Morning','2021-06-08','2021-06-08 00:00:00',NULL,'602',457417.03,457417.03,'602','2021-06-08 21:20:44','607','2021-06-08 23:00:57',10,0),('5','173',202638,'Morning','2021-06-09','2021-06-09 00:00:00',NULL,'602',687938.14,687938.14,'602','2021-06-09 21:52:46','607','2021-06-09 22:16:16',10,0),('5','173',202851,'Morning','2021-06-10','2021-06-10 00:00:00',NULL,'602',563257.38,563257.38,'602','2021-06-10 22:50:41','607','2021-06-11 06:00:14',10,0),('5','173',203111,'Morning','2021-06-11','2021-06-11 00:00:00',NULL,'602',818572.55,818572.55,'602','2021-06-11 20:08:52','607','2021-06-11 20:45:32',10,0),('5','173',203316,'Morning','2021-06-12','2021-06-12 00:00:00',NULL,'602',513695.83,513695.83,'602','2021-06-12 21:25:45','607','2021-06-13 05:52:52',10,0),('5','173',203562,'Morning','2021-06-13','2021-06-13 00:00:00',NULL,'602',431303.66,431303.66,'602','2021-06-13 23:04:35','607','2021-06-14 07:28:23',10,0),('5','173',203752,'Morning','2021-06-14','2021-06-14 00:00:00',NULL,'602',319444.04,319444.04,'602','2021-06-14 22:30:50','607','2021-06-15 06:08:37',10,0),('5','173',203971,'Morning','2021-06-15','2021-06-15 00:00:00',NULL,'602',248719.43,248719.43,'602','2021-06-15 20:02:51','607','2021-06-16 07:01:22',10,0),('5','173',204218,'Morning','2021-06-16','2021-06-16 00:00:00',NULL,'602',223806.39,223806.39,'602','2021-06-16 19:51:33','607','2021-06-17 06:17:57',10,0),('5','173',204411,'Morning','2021-06-17','2021-06-17 00:00:00',NULL,'602',347134.22,347134.22,'602','2021-06-17 21:04:01','607','2021-06-17 21:49:44',10,0),('5','173',204619,'Morning','2021-06-18','2021-06-18 00:00:00',NULL,'602',705522.32,705522.32,'602','2021-06-18 22:48:27','607','2021-06-19 06:12:04',10,0),('5','173',204872,'Morning','2021-06-19','2021-06-19 00:00:00',NULL,'602',608984.39,608984.39,'602','2021-06-19 22:12:31','607','2021-06-20 07:05:12',10,0),('5','173',205221,'Morning','2021-06-20','2021-06-20 00:00:00',NULL,'602',319213.43,319213.43,'602','2021-06-21 05:45:44','607','2021-06-21 05:50:13',10,0),('5','173',205231,'Morning','2021-06-21','2021-06-21 00:00:00',NULL,'602',287778.04,287817.84,'602','2021-06-21 21:06:18','607','2021-06-22 07:39:59',10,0),('5','173',205526,'Morning','2021-06-22','2021-06-22 00:00:00',NULL,'602',339598.72,340451.47,'602','2021-06-22 20:21:14','607','2021-06-23 06:24:38',10,0),('5','173',205808,'Morning','2021-06-23','2021-06-23 00:00:00',NULL,'602',337196.81,337196.81,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',205991,'Morning','2021-06-23','2021-06-23 00:00:00',NULL,'602',337634.16,337634.16,'602','2021-06-24 08:48:49','607','2021-06-24 09:20:31',10,0),('5','173',206003,'Morning','2021-06-24','2021-06-24 00:00:00',NULL,'602',226332.90,227473.00,'602','2021-06-24 20:09:51','607','2021-06-24 21:45:18',10,0),('5','173',206134,'Morning','2021-06-25','2021-06-25 00:00:00',NULL,'602',344802.99,348217.99,'602','2021-06-25 20:10:37','607','2021-06-26 06:41:38',10,0),('5','173',206401,'Morning','2021-06-26','2021-06-26 00:00:00',NULL,'602',318777.70,318997.70,'602','2021-06-26 20:32:48','607','2021-06-27 09:17:33',10,0),('5','173',206657,'Morning','2021-06-27','2021-06-27 00:00:00',NULL,'602',282794.20,283094.20,'602','2021-06-27 20:25:42','607','2021-06-28 08:37:42',10,0),('5','173',206881,'Morning','2021-06-28','2021-06-28 00:00:00',NULL,'602',267662.74,268012.74,'602','2021-06-28 20:06:05','607','2021-06-29 08:38:50',10,0),('5','173',207086,'Morning','2021-06-29','2021-06-29 00:00:00',NULL,'602',268744.28,268844.28,'602','2021-06-29 20:27:52','607','2021-06-30 09:37:40',10,0),('5','173',207357,'Morning','2021-06-30','2021-06-30 00:00:00',NULL,'602',240227.43,240327.43,'602','2021-06-30 20:12:29','607','2021-07-01 08:24:43',10,0),('5','173',207592,'Morning','2021-07-01','2021-07-01 00:00:00',NULL,'602',281795.66,283097.26,'602','2021-07-01 20:18:08','607','2021-07-02 07:26:14',10,0),('5','173',207786,'Morning','2021-07-02','2021-07-02 00:00:00',NULL,'602',353599.64,354325.24,'602','2021-07-03 21:31:04','607','2021-07-03 21:36:46',10,0),('5','173',208093,'Morning','2021-07-03','2021-07-03 00:00:00',NULL,'602',293960.72,293960.72,'602','2021-07-03 21:40:54','607','2021-07-04 09:03:07',10,0),('5','173',208177,'Morning','2021-07-04','2021-07-04 00:00:00',NULL,'602',315590.82,315590.82,'602','2021-07-04 22:57:57','607','2021-07-05 05:28:34',10,0),('5','173',208502,'Morning','2021-07-05','2021-07-05 00:00:00',NULL,'602',394730.58,394730.58,'602','2021-07-05 21:59:42','607','2021-07-05 22:06:56',10,0),('5','173',208639,'Morning','2021-07-06','2021-07-06 00:00:00',NULL,'602',289483.11,289483.11,'602','2021-07-06 19:42:51','607','2021-07-07 06:10:56',10,0),('5','173',208878,'Morning','2021-07-07','2021-07-07 00:00:00',NULL,'602',267531.90,267531.90,'602','2021-07-07 22:03:09','607','2021-07-08 06:39:16',10,0),('5','173',209024,'Morning','2021-07-08','2021-07-08 00:00:00',NULL,'602',360053.96,360053.96,'602','2021-07-09 04:58:52','607','2021-07-09 08:03:35',10,0),('5','173',209421,'Morning','2021-07-09','2021-07-09 00:00:00',NULL,'602',297232.40,298072.50,'602','2021-07-09 23:19:47','607','2021-07-10 08:03:02',10,0),('5','173',209536,'Morning','2021-07-10','2021-07-10 00:00:00',NULL,'602',300643.72,300643.72,'602','2021-07-10 21:41:04','607','2021-07-10 22:28:36',10,0),('5','173',209841,'Morning','2021-07-11','2021-07-11 00:00:00',NULL,'602',365478.60,365478.60,'602','2021-07-11 20:23:32','607','2021-07-11 20:31:28',10,0),('5','173',209952,'Morning','2021-07-12','2021-07-12 00:00:00',NULL,'602',319603.88,319603.88,'602','2021-07-12 20:03:43','607','2021-07-12 20:29:21',10,0),('5','173',210135,'Morning','2021-07-13','2021-07-13 00:00:00',NULL,'602',286765.90,286765.90,'602','2021-07-13 19:52:41','607','2021-07-14 09:51:06',10,0),('5','173',210410,'Morning','2021-07-14','2021-07-14 00:00:00',NULL,'602',273548.23,273548.23,'602','2021-07-14 20:20:01','607','2021-07-14 20:52:39',10,0),('5','173',210508,'Morning','2021-07-15','2021-07-15 00:00:00',NULL,'602',295176.70,295176.70,'602','2021-07-15 20:30:02','607','2021-07-15 22:24:06',10,0),('5','173',210750,'Morning','2021-07-16','2021-07-16 00:00:00',NULL,'602',228925.35,228925.35,'602','2021-07-17 09:01:03','607','2021-07-17 09:19:03',10,0),('5','173',211027,'Morning','2021-07-17','2021-07-17 00:00:00',NULL,'602',365758.96,365758.96,'602','2021-07-18 08:12:51','607','2021-07-18 08:54:55',10,0),('5','173',211240,'Morning','2021-07-18','2021-07-18 00:00:00',NULL,'602',410148.75,410148.75,'602','2021-07-18 20:02:59','607','2021-07-18 20:15:29',10,0),('5','173',211419,'Morning','2021-07-19','2021-07-19 00:00:00',NULL,'602',300255.78,300255.78,'602','2021-07-20 05:46:58','607','2021-07-20 11:27:53',10,0),('5','173',211764,'Morning','2021-07-20','2021-07-20 00:00:00',NULL,'602',142973.82,142973.82,'602','2021-07-21 04:42:28','607','2021-07-21 14:41:57',10,0),('5','173',211974,'Morning','2021-07-21','2021-07-21 00:00:00',NULL,'602',178509.45,178509.45,'602','2021-07-22 03:47:47','607','2021-07-22 09:05:42',10,0),('5','173',212139,'Morning','2021-07-22','2021-07-22 00:00:00',NULL,'602',254263.70,254263.70,'602','2021-07-23 05:15:33','607','2021-07-23 09:16:54',10,0),('5','173',212360,'Morning','2021-07-23','2021-07-23 00:00:00',NULL,'602',235732.23,235732.23,'602','2021-07-25 18:15:27','607','2021-07-25 18:45:04',10,0),('5','173',212828,'Morning','2021-07-24','2021-07-24 00:00:00',NULL,'602',243024.85,243024.85,'602','2021-07-25 19:03:31','607','2021-07-25 19:04:34',10,0),('5','173',212832,'Morning','2021-07-25','2021-07-25 00:00:00',NULL,'602',244500.00,244500.00,'602','2021-07-25 19:13:33','607','2021-07-25 19:26:06',10,0),('5','173',213110,'Morning ','2021-07-26','2021-07-26 00:00:00',NULL,'602',187450.00,187450.00,'602','2021-07-26 21:40:43','607','2021-07-27 06:25:53',10,0),('5','173',213232,'Morning','2021-07-27','2021-07-27 00:00:00',NULL,'602',0.00,0.00,'602','2021-07-28 13:18:20','607','2021-07-28 13:42:31',10,0),('5','173',213859,'Morning','2021-07-28','2021-07-28 00:00:00',NULL,'602',0.00,0.00,'602','2021-07-29 21:16:58','607','2021-07-29 21:44:29',10,0),('5','173',213860,'Morning','2021-07-29','2021-07-29 00:00:00',NULL,'602',192918.65,192918.65,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',213981,'Morning','2021-07-29','2021-07-29 00:00:00',NULL,'602',192918.65,191735.10,'602','2021-07-30 11:19:18','607','2021-07-30 11:32:27',10,0),('5','173',214239,'Morning','2021-07-30','2021-07-30 00:00:00',NULL,'602',430011.18,430011.18,'602','2021-08-01 14:20:28','607','2021-08-01 14:37:54',10,0),('5','173',214464,'Morning','2021-07-31','2021-07-31 00:00:00',NULL,'602',275796.90,275796.90,'602','2021-08-01 14:50:12','607','2021-08-01 15:09:44',10,0),('5','173',214547,'Morning','2021-08-01','2021-08-01 00:00:00',NULL,'602',290208.42,290208.42,'602','2021-08-02 07:00:37','607','2021-08-02 10:08:33',10,0),('5','173',214916,'Morning','2021-08-02','2021-08-02 00:00:00',NULL,'602',246032.64,246032.64,'602','2021-08-03 14:37:50','607','2021-08-03 14:41:14',10,0),('5','173',214939,'Morning','2021-08-03','2021-08-03 00:00:00',NULL,'602',255867.66,255867.66,'602','2021-08-04 07:59:03','607','2021-08-04 10:39:52',10,0),('5','173',215085,'MORNING SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'602',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',215277,'Morning','2021-08-04','2021-08-04 00:00:00',NULL,'602',237407.76,237407.76,'602','2021-08-05 09:13:06','607','2021-08-05 09:23:04',10,0),('5','173',215282,'Morning','2021-08-05','2021-08-05 00:00:00',NULL,'602',262762.38,262762.38,'602','2021-08-05 19:40:16','607','2021-08-06 08:00:36',10,0),('5','173',215476,'Morning','2021-08-06','2021-08-06 00:00:00',NULL,'602',342727.20,342727.20,'602','2021-08-06 19:51:05','607','2021-08-07 08:50:17',10,0),('5','173',215783,'Morning','2021-08-07','2021-08-07 00:00:00',NULL,'602',295217.46,295217.46,'602','2021-08-07 20:02:50','607','2021-08-08 07:38:28',10,0),('5','173',215983,'Morning ','2021-08-08','2021-08-08 00:00:00',NULL,'602',330847.74,330847.74,'602','2021-08-08 20:08:36','607','2021-08-09 08:02:05',10,0),('5','173',216156,'Morning','2021-08-09','2021-08-09 00:00:00',NULL,'602',313377.66,313377.66,'602','2021-08-09 20:09:20','607','2021-08-10 06:23:42',10,0),('5','173',216361,'Morning','2021-08-10','2021-08-10 00:00:00',NULL,'602',283253.76,283253.76,'602','2021-08-10 19:54:00','607','2021-08-11 08:14:36',10,0),('5','173',216599,'Morning','2021-08-11','2021-08-11 00:00:00',NULL,'602',344855.88,344855.88,'602','2021-08-11 20:04:14','607','2021-08-11 22:05:06',10,0),('5','173',216862,'Morning','2021-08-12','2021-08-12 00:00:00',NULL,'602',250800.30,250800.30,'602','2021-08-12 20:12:11','607','2021-08-13 08:04:31',10,0),('5','173',217112,'Morning','2021-08-13','2021-08-13 00:00:00',NULL,'602',250349.94,250349.94,'602','2021-08-13 20:03:46','607','2021-08-14 08:14:51',10,0),('5','173',217318,'Morning','2021-08-14','2021-08-14 00:00:00',NULL,'602',305420.22,305420.22,'602','2021-08-14 19:47:44','607','2021-08-15 19:52:44',10,0),('5','173',217672,'Morning','2021-08-15','2021-08-15 00:00:00',NULL,'602',20389.32,20389.32,'602','2021-08-15 20:18:06','607','2021-08-16 07:55:49',10,0),('5','173',217943,'Morning','2021-08-16','2021-08-16 00:00:00',NULL,'602',61200.36,61200.36,'602','2021-08-17 08:45:08','607','2021-08-17 08:47:41',10,0),('5','173',218036,'Morning','2021-08-17','2021-08-17 00:00:00',NULL,'602',53659.26,53659.26,'602','2021-08-17 19:56:22','607','2021-08-18 08:26:48',10,0),('5','173',218359,'Morning','2021-08-18','2021-08-18 00:00:00',NULL,'602',65263.32,65263.32,'602','2021-08-18 18:24:25','607','2021-08-19 05:41:57',10,0),('5','173',218480,'Morning','2021-08-19','2021-08-19 00:00:00',NULL,'602',143123.76,143123.76,'602','2021-08-19 18:12:15','607','2021-08-20 06:50:17',10,0),('5','173',218859,'Morning','2021-08-20','2021-08-20 00:00:00',NULL,'602',288167.22,288167.22,'602','2021-08-20 18:29:41','607','2021-08-20 23:10:09',10,0),('5','173',218929,'Morning','2021-08-21','2021-08-21 00:00:00',NULL,'602',328445.28,328445.28,'602','2021-08-21 18:10:46','607','2021-08-21 23:06:23',10,0),('5','173',219136,'Morning','2021-08-22','2021-08-22 00:00:00',NULL,'602',268297.92,268297.92,'602','2021-08-22 17:23:09','607','2021-08-22 23:28:33',10,0),('5','173',219342,'Morning','2021-08-23','2021-08-23 00:00:00',NULL,'602',309648.42,309648.42,'602','2021-08-23 17:50:36','607','2021-08-23 22:03:13',10,0),('5','173',219622,'Morning','2021-08-24','2021-08-24 00:00:00',NULL,'602',342306.00,342306.00,'602','2021-08-24 18:55:37','607','2021-08-24 22:27:50',10,0),('5','173',219871,'Morning','2021-08-25','2021-08-25 00:00:00',NULL,'602',125869.14,125869.14,'602','2021-08-26 07:15:23','607','2021-08-26 09:37:09',10,0),('5','173',220148,'Morning','2021-08-26','2021-08-26 00:00:00',NULL,'602',162061.56,162061.56,'602','2021-08-26 19:02:01','607','2021-08-27 05:51:50',10,0),('5','173',220379,'Morning','2021-08-27','2021-08-27 00:00:00',NULL,'602',90742.68,90742.68,'602','2021-08-27 18:09:02','607','2021-08-28 07:05:12',10,0),('5','173',220654,'Morning','2021-08-28','2021-08-28 00:00:00',NULL,'602',126034.38,126034.38,'602','2021-08-28 18:40:44','607','2021-08-29 07:43:30',10,0),('5','173',220867,'Morning','2021-08-29','2021-08-29 00:00:00',NULL,'602',138058.02,138058.02,'602','2021-08-29 21:24:46','607','2021-08-30 09:16:40',10,0),('5','173',221005,'Morning','2021-08-30','2021-08-30 00:00:00',NULL,'602',191488.86,191488.86,'602','2021-08-30 17:50:31','607','2021-08-31 07:03:53',10,0),('5','173',221220,'Morning','2021-08-31','2021-08-31 00:00:00',NULL,'602',286636.32,286636.32,'602','2021-08-31 18:18:11','607','2021-09-01 05:29:22',10,0),('5','173',221398,'Morning','2021-09-01','2021-09-01 00:00:00',NULL,'602',264283.56,264283.56,'602','2021-09-01 17:53:16','607','2021-09-02 06:40:42',10,0),('5','173',221741,'Morning','2021-09-02','2021-09-02 00:00:00',NULL,'602',263967.66,263967.66,'602','2021-09-02 17:56:47','607','2021-09-03 09:16:49',10,0),('5','173',221971,'Morning','2021-09-03','2021-09-03 00:00:00',NULL,'602',186099.12,186099.12,'602','2021-09-03 17:33:53','607','2021-09-04 07:09:58',10,0),('5','173',222079,'Morning','2021-09-04','2021-09-04 00:00:00',NULL,'602',246870.18,246870.18,'602','2021-09-04 18:56:42','607','2021-09-05 07:11:55',10,0),('5','173',222307,'Morning','2021-09-05','2021-09-05 00:00:00',NULL,'602',128504.88,128504.88,'602','2021-09-05 17:49:26','607','2021-09-06 08:36:01',10,0),('5','173',222565,'Morning','2021-09-06','2021-09-06 00:00:00',NULL,'602',255138.66,255138.66,'602','2021-09-06 17:46:27','607','2021-09-07 08:01:16',10,0),('5','173',222790,'Morning','2021-09-07','2021-09-07 00:00:00',NULL,'602',227355.66,227355.66,'602','2021-09-07 18:42:24','607','2021-09-08 05:56:57',10,0),('5','173',222970,'Morning','2021-09-08','2021-09-08 00:00:00',NULL,'602',123884.64,123884.64,'602','2021-09-08 19:23:25','607','2021-09-09 05:58:00',10,0),('5','173',223225,'Morning','2021-09-09','2021-09-09 00:00:00',NULL,'602',133820.10,133820.10,'602','2021-09-09 20:13:27','607','2021-09-10 08:59:24',10,0),('5','173',223539,'Morning','2021-09-10','2021-09-10 00:00:00',NULL,'602',67301.28,67301.28,'602','2021-09-10 19:25:14','607','2021-09-11 06:23:17',10,0),('5','173',223786,'Morning','2021-09-11','2021-09-11 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-12 05:54:01','607','2021-09-13 09:01:25',10,0),('5','173',224166,'Morning','2021-09-12','2021-09-12 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-13 10:33:52','607','2021-09-13 14:27:12',10,0),('5','173',224272,'Morning','2021-09-13','2021-09-13 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-13 18:31:46','607','2021-09-14 08:32:06',10,0),('5','173',224416,'Morning','2021-09-14','2021-09-14 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-15 05:10:10','607','2021-09-15 09:13:43',10,0),('5','173',224710,'Morning','2021-09-15','2021-09-15 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-16 13:08:28','607','2021-09-17 08:39:25',10,0),('5','173',225161,'Morning','2021-09-16','2021-09-16 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-17 14:06:23','607','2021-09-18 07:33:24',10,0),('5','173',225425,'Morning','2021-09-17','2021-09-17 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-18 17:34:16','607','2021-09-19 06:24:01',10,0),('5','173',225629,'Morning','2021-09-18','2021-09-18 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-19 15:13:22','607','2021-09-19 22:40:50',10,0),('5','173',225850,'Morning','2021-09-19','2021-09-19 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-20 12:38:10','607','2021-09-20 15:30:59',10,0),('5','173',225930,'Morning','2021-09-20','2021-09-20 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-20 17:54:38','607','2021-09-21 09:53:36',10,0),('5','173',226153,'Morning','2021-09-21','2021-09-21 00:00:00',NULL,'602',0.00,0.00,'602','2021-09-21 17:41:57','607','2021-09-21 21:02:26',10,0),('5','173',226444,'Morning','2021-09-22','2021-09-22 00:00:00',NULL,'602',61078.86,61078.86,'602','2021-09-22 19:25:56','607','2021-09-23 07:14:57',10,0),('5','173',226574,'Morning','2021-09-23','2021-09-23 00:00:00',NULL,'602',263557.80,263557.80,'602','2021-09-23 18:52:00','607','2021-09-24 10:36:00',10,0),('5','173',226870,'Morning','2021-09-24','2021-09-24 00:00:00',NULL,'602',306320.94,306320.94,'602','2021-09-25 11:36:19','607','2021-09-25 12:27:51',10,0),('5','173',227070,'Morning','2021-09-25','2021-09-25 00:00:00',NULL,'602',193314.60,193314.60,'602','2021-09-25 20:14:27','607','2021-09-26 08:25:42',10,0),('5','173',227234,'Morning','2021-09-26','2021-09-26 00:00:00',NULL,'602',214202.88,214202.88,'602','2021-09-26 19:45:26','607','2021-09-27 09:33:16',10,0),('5','173',227462,'Morning','2021-09-27','2021-09-27 00:00:00',NULL,'602',242475.12,242475.12,'602','2021-09-27 19:52:23','607','2021-09-28 08:23:48',10,0),('5','173',227687,'Morning','2021-09-28','2021-09-28 00:00:00',NULL,'602',202253.76,202253.76,'602','2021-09-28 19:22:08','607','2021-09-29 08:30:24',10,0),('5','173',227925,'Morning','2021-09-29','2021-09-29 00:00:00',NULL,'602',186735.78,186735.78,'602','2021-09-29 18:56:03','607','2021-10-05 13:10:45',10,0),('5','173',235144,'morning ','2021-10-01','2021-10-01 00:00:00',NULL,'602',124218.36,124218.36,'602','2021-10-29 13:16:47','607','2021-10-31 10:33:22',10,0),('5','173',235685,'Morning','2021-10-02','2021-10-02 00:00:00',NULL,'602',32400.00,32400.00,'602','2021-10-31 16:18:24','607','2021-11-01 08:47:10',10,0),('5','173',235849,'Morning','2021-10-03','2021-10-03 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 09:35:37','607','2021-11-01 09:41:27',10,0),('5','173',235850,'Morning','2021-10-04','2021-10-04 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 09:45:11','607','2021-11-01 09:45:59',10,0),('5','173',235852,'Morning','2021-10-05','2021-10-05 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 09:47:52','607','2021-11-01 09:48:31',10,0),('5','173',235855,'Morning','2021-10-06','2021-10-06 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 09:51:01','607','2021-11-01 09:53:22',10,0),('5','173',235856,'Morning','2021-10-07','2021-10-07 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 09:56:52','607','2021-11-01 09:57:52',10,0),('5','173',235857,'Morning','2021-10-08','2021-10-08 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 10:01:53','607','2021-11-01 10:10:46',10,0),('5','173',235863,'Morning','2021-10-09','2021-10-09 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 10:24:17','607','2021-11-01 10:57:21',10,0),('5','173',235872,'Morning','2021-10-10','2021-10-10 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 10:58:50','607','2021-11-01 11:00:37',10,0),('5','173',235873,'Morning','2021-10-11','2021-10-11 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 11:01:55','607','2021-11-01 11:03:15',10,0),('5','173',235874,'Morning','2021-10-12','2021-10-12 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 11:04:04','607','2021-11-01 11:04:56',10,0),('5','173',235875,'Morning','2021-10-13','2021-10-13 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 11:05:34','607','2021-11-01 11:07:19',10,0),('5','173',235876,'Morning','2021-10-14','2021-10-14 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 11:08:37','607','2021-11-01 11:09:15',10,0),('5','173',235877,'Morning','2021-10-15','2021-10-15 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 11:10:20','607','2021-11-01 11:15:35',10,0),('5','173',235911,'Morning','2021-10-16','2021-10-16 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 13:13:58','607','2021-11-01 16:11:11',10,0),('5','173',235962,'Morning','2021-10-17','2021-10-17 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-01 17:59:54','607','2021-11-01 18:09:07',10,0),('5','173',236316,'Morning','2021-10-18','2021-10-18 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-03 09:09:53','607','2021-11-03 09:11:13',10,0),('5','173',236317,'Morning it','2021-10-19','2021-10-19 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-03 09:13:26','607','2021-11-03 09:16:57',10,0),('5','173',236324,'Morning','2021-10-20','2021-10-20 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-03 09:25:58','607','2021-11-03 09:33:49',10,0),('5','173',236332,'Morning','2021-10-21','2021-10-21 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-03 09:44:02','607','2021-11-03 09:44:39',10,0),('5','173',236334,'Morning','2021-10-22','2021-10-22 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-03 09:49:10','607','2021-11-03 09:54:08',10,0),('5','173',236340,'Morning','2021-11-03','2021-11-03 00:00:00',NULL,'602',48600.00,48600.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',236357,'Morning','2021-10-23','2021-10-23 00:00:00',NULL,'602',48600.00,48600.00,'602','2021-11-03 10:43:16','607','2021-11-03 10:48:36',10,0),('5','173',236359,'Morning','2021-10-24','2021-10-24 00:00:00',NULL,'602',196656.66,196656.66,'602','2021-11-03 10:54:46','607','2021-11-03 10:55:40',10,0),('5','173',236360,'Morning','2021-10-25','2021-10-25 00:00:00',NULL,'602',229524.84,229524.84,'602','2021-11-09 12:55:35','600','2021-11-09 12:57:00',10,0),('5','173',237730,'Morning','2021-10-26','2021-10-26 00:00:00',NULL,'602',172261.08,175451.10,'602','2021-11-09 13:00:45','600','2021-11-09 13:03:10',10,0),('5','173',237733,'Morning','2021-10-27','2021-10-27 00:00:00',NULL,'602',438420.60,446539.50,'602','2021-11-09 13:05:06','600','2021-11-09 13:17:56',10,0),('5','173',237741,'Morning','2021-10-28','2021-10-28 00:00:00',NULL,'602',177633.00,180922.50,'602','2021-11-09 13:26:13','600','2021-11-09 13:34:07',10,0),('5','173',237743,'Morning','2021-10-29','2021-10-29 00:00:00',NULL,'602',191027.16,194564.70,'602','2021-11-09 13:37:41','600','2021-11-09 13:40:55',10,0),('5','173',237746,'Morning','2021-10-30','2021-10-30 00:00:00',NULL,'602',168037.74,171149.55,'602','2021-11-09 13:43:44','600','2021-11-09 13:48:30',10,0),('5','173',237747,'Morning','2021-10-31','2021-10-31 00:00:00',NULL,'602',171640.62,174819.15,'602','2021-11-09 13:50:29','600','2021-11-09 13:51:32',10,0),('5','173',237748,'Morning','2021-11-01','2021-11-01 00:00:00',NULL,'602',241554.96,246028.20,'602','2021-11-09 13:53:58','600','2021-11-09 13:55:48',10,0),('5','173',237751,'Morning','2021-11-02','2021-11-02 00:00:00',NULL,'602',287914.50,293246.25,'602','2021-11-09 13:58:35','600','2021-11-09 13:59:41',10,0),('5','173',237752,'Morning','2021-11-03','2021-11-03 00:00:00',NULL,'602',285165.36,290446.20,'602','2021-11-09 14:03:28','600','2021-11-09 14:04:58',10,0),('5','173',237754,'Morning','2021-10-04','2021-10-04 00:00:00',NULL,'602',262459.44,267319.80,'602','2021-11-09 14:07:38','600','2021-11-09 14:09:12',10,0),('5','173',237757,'Morning','2021-11-05','2021-11-05 00:00:00',NULL,'602',154003.68,156855.60,'602','2021-11-09 14:11:15','600','2021-11-09 14:12:24',10,0),('5','173',237759,'Morning','2021-11-06','2021-11-06 00:00:00',NULL,'602',189540.00,193050.00,'602','2021-11-09 14:14:16','600','2021-11-09 14:15:13',10,0),('5','173',237761,'Morning','2021-11-07','2021-11-07 00:00:00',NULL,'602',86480.46,88081.95,'602','2021-11-09 14:16:46','600','2021-11-09 14:17:31',10,0),('5','173',237763,'Morning','2021-11-08','2021-11-08 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-09 14:18:40','600','2021-11-09 14:20:23',10,0),('5','173',237766,'Morning','2021-11-09','2021-11-09 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-10 07:19:04','600','2021-11-11 04:50:33',10,0),('5','173',238205,'Morning','2021-11-10','2021-11-10 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-11 10:02:28','600','2021-11-12 08:17:04',10,0),('5','173',238454,'Morning','2021-11-11','2021-11-11 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-12 09:51:36','600','2021-11-13 10:07:18',10,0),('5','173',238699,'Morning','2021-11-12','2021-11-12 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-13 10:48:19','600','2021-11-14 09:35:40',10,0),('5','173',238985,'Morning','2021-11-13','2021-11-13 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-14 17:21:17','600','2021-11-14 18:41:37',10,0),('5','173',239129,'Morning','2021-11-14','2021-11-14 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-15 08:25:59','600','2021-11-16 08:08:05',10,0),('5','173',239350,'Morning','2021-11-15','2021-11-15 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-16 08:34:29','600','2021-11-17 08:01:30',10,0),('5','173',239700,'Morning','2021-11-16','2021-11-16 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-17 17:02:22','600','2021-11-18 12:16:52',10,0),('5','173',239903,'Morning ','2021-11-17','2021-11-17 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-18 13:45:05','600','2021-11-19 08:12:47',10,0),('5','173',240055,'Morning','2021-11-19','2021-11-19 00:00:00',NULL,'602',0.00,0.00,'602','2021-11-19 17:54:48','600','2021-11-20 08:31:51',10,0),('5','173',240341,'Morning','2021-11-20','2021-11-20 00:00:00',NULL,'602',354982.50,361556.25,'602','2021-11-25 15:17:17','600','2021-11-26 08:27:05',10,0),('5','173',241811,'Morning','2021-11-21','2021-11-21 00:00:00',NULL,'602',267149.85,267149.85,'602','2021-11-26 08:44:50','600','2021-11-27 07:56:51',10,0),('5','173',242198,'Morning','2021-11-22','2021-11-22 00:00:00',NULL,'602',505399.95,505399.95,'602','2021-11-28 05:55:40','600','2021-11-28 13:43:24',10,0),('5','173',242461,'Morning','2021-11-23','2021-11-23 00:00:00',NULL,'602',234493.05,234493.05,'602','2021-11-29 07:02:20','600','2021-11-29 14:02:20',10,0),('5','173',242614,'Morning','2021-11-24','2021-11-24 00:00:00',NULL,'602',227980.50,227980.50,'602','2021-11-29 18:18:26','600','2021-11-30 08:47:16',10,0),('5','173',242787,'Morning','2021-11-25','2021-11-25 00:00:00',NULL,'602',260904.60,260904.60,'602','2021-11-30 11:46:21','600','2021-12-01 08:32:47',10,0),('5','173',247018,'Morning','2021-11-26','2021-11-26 00:00:00',NULL,'602',296142.00,296142.00,'602','2021-12-18 10:04:32','600','2021-12-19 07:54:34',10,0),('5','173',247308,'Morning','2021-11-27','2021-11-27 00:00:00',NULL,'602',341612.70,341612.70,'602','2021-12-19 14:05:51','600','2021-12-20 11:04:54',10,0),('5','173',247501,'Morning','2021-11-28','2021-11-28 00:00:00',NULL,'602',279123.90,279123.90,'602','2021-12-20 11:47:52','600','2021-12-20 12:11:32',10,0),('5','173',247509,'Morning','2021-11-29','2021-11-29 00:00:00',NULL,'602',227975.55,227975.55,'602','2021-12-20 12:15:50','600','2021-12-20 12:17:14',10,0),('5','173',247511,'Morning','2021-11-30','2021-11-30 00:00:00',NULL,'602',261366.60,261366.60,'602','2021-12-20 12:22:10','600','2021-12-20 12:28:16',10,0),('5','173',247514,'Morning','2021-12-01','2021-12-01 00:00:00',NULL,'602',274074.90,274074.90,'602','2021-12-20 12:31:33','600','2021-12-20 12:33:55',10,0),('5','173',247515,'Morning','2021-12-02','2021-12-02 00:00:00',NULL,'602',249085.65,249085.65,'602','2021-12-20 12:37:43','600','2021-12-20 12:40:17',10,0),('5','173',247516,'Morning','2021-12-03','2021-12-03 00:00:00',NULL,'602',350265.30,350265.30,'602','2021-12-20 12:42:16','600','2021-12-20 12:43:11',10,0),('5','173',247517,'Morning','2021-12-04','2021-12-04 00:00:00',NULL,'602',255179.10,255179.10,'602','2021-12-20 12:44:37','600','2021-12-20 12:45:00',10,0),('5','173',247519,'Morning','2021-12-05','2021-12-05 00:00:00',NULL,'602',261975.45,261975.45,'602','2021-12-20 12:46:45','600','2021-12-20 12:47:17',10,0),('5','173',247521,'Morning','2021-12-06','2021-12-06 00:00:00',NULL,'602',271849.05,271849.05,'602','2021-12-20 12:49:13','600','2021-12-20 12:50:20',10,0),('5','173',247523,'Morning','2021-12-07','2021-12-07 00:00:00',NULL,'602',339198.75,339198.75,'602','2021-12-20 12:52:40','600','2021-12-20 12:53:22',10,0),('5','173',247524,'Morning','2021-12-08','2021-12-08 00:00:00',NULL,'602',236426.85,236426.85,'602','2021-12-20 12:54:46','600','2021-12-20 12:55:16',10,0),('5','173',247527,'Morning','2021-12-09','2021-12-09 00:00:00',NULL,'602',290583.15,290583.15,'602','2021-12-20 12:56:31','600','2021-12-20 12:57:03',10,0),('5','173',247528,'Morning','2021-12-10','2021-12-10 00:00:00',NULL,'602',238956.30,238956.30,'602','2021-12-20 12:58:16','600','2021-12-20 13:00:08',10,0),('5','173',247529,'Morning','2021-12-11','2021-12-11 00:00:00',NULL,'602',244508.55,244508.55,'602','2021-12-20 13:01:42','600','2021-12-20 13:02:16',10,0),('5','173',247531,'Morning','2021-12-12','2021-12-12 00:00:00',NULL,'602',76858.65,76858.65,'602','2021-12-20 13:04:30','600','2021-12-20 13:05:18',10,0),('5','173',247536,'Morning','2021-12-13','2021-12-13 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:06:27','600','2021-12-20 13:07:01',10,0),('5','173',247537,'Morning','2021-12-14','2021-12-14 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:07:48','600','2021-12-20 13:08:44',10,0),('5','173',247538,'Morning','2021-12-15','2021-12-15 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:09:32','600','2021-12-20 13:10:03',10,0),('5','173',247539,'Morning','2021-12-16','2021-12-16 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:10:57','600','2021-12-20 13:11:35',10,0),('5','173',247541,'Morning','2021-12-17','2021-12-17 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:12:23','600','2021-12-20 13:12:52',10,0),('5','173',247542,'Morning','2021-12-18','2021-12-18 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:13:41','600','2021-12-20 13:14:14',10,0),('5','173',247543,'Morning','2021-12-19','2021-12-19 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-20 13:15:05','600','2021-12-20 13:16:25',10,0),('5','173',247546,'Morning','2021-12-20','2021-12-20 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-21 04:38:46','600','2021-12-21 07:57:31',10,0),('5','173',247773,'Morning','2021-12-21','2021-12-21 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-21 18:22:10','600','2021-12-22 08:01:31',10,0),('5','173',248027,'Morning','2021-12-22','2021-12-22 00:00:00',NULL,'602',481953.45,481953.45,'602','2021-12-23 16:55:01','600','2021-12-23 18:06:48',10,0),('5','173',248351,'Morning','2021-12-23','2021-12-23 00:00:00',NULL,'602',644204.55,644204.55,'602','2021-12-23 19:26:50','600','2021-12-24 08:11:50',10,0),('5','173',248504,'Morning','2021-12-24','2021-12-24 00:00:00',NULL,'602',410450.70,410450.70,'602','2021-12-25 09:05:41','600','2021-12-25 14:08:28',10,0),('5','173',248814,'Morning','2021-12-25','2021-12-25 00:00:00',NULL,'602',466158.00,466158.00,'602','2021-12-26 16:19:30','600','2021-12-27 12:17:59',10,0),('5','173',249241,'Morning','2021-12-26','2021-12-26 00:00:00',NULL,'602',318542.40,318542.40,'602','2021-12-27 13:29:51','600','2021-12-27 18:20:36',10,0),('5','173',249383,'Morning','2021-12-27','2021-12-27 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-28 17:29:44','600','2021-12-29 08:42:53',10,0),('5','173',249732,'Morning','2021-12-28','2021-12-28 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-29 12:43:48','600','2021-12-30 08:56:22',10,0),('5','173',250013,'Morning','2021-12-29','2021-12-29 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-30 15:05:44','600','2021-12-31 08:43:50',10,0),('5','173',250281,'Morning','2021-12-30','2021-12-30 00:00:00',NULL,'602',0.00,0.00,'602','2021-12-31 18:25:19','600','2022-01-01 08:42:12',10,0),('5','173',250482,'Morning','2021-12-31','2021-12-31 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-01 14:26:38','600','2022-01-02 09:30:14',10,0),('5','173',250705,'Morning','2022-01-01','2022-01-01 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-02 14:31:19','600','2022-01-03 10:16:08',10,0),('5','173',250883,'Morning','2022-01-02','2022-01-02 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-03 11:30:59','600','2022-01-04 08:30:04',10,0),('5','173',251254,'Morning','2022-01-04','2022-01-04 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-05 03:08:11','600','2022-01-05 11:36:58',10,0),('5','173',251381,'Morning','2022-01-05','2022-01-05 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-06 04:32:06','600','2022-01-07 11:43:02',10,0),('5','173',251927,'Morning','2022-01-06','2022-01-06 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-07 18:21:32','600','2022-01-08 13:23:54',10,0),('5','173',252221,'Morning','2022-01-07','2022-01-07 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-09 04:54:01','600','2022-01-09 09:55:09',10,0),('5','173',252420,'Morning','2021-12-08','2021-12-08 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-09 20:14:05','600','2022-01-10 09:42:24',10,0),('5','173',252595,'Morning','2022-01-09','2022-01-09 00:00:00',NULL,'602',1225986.30,1225986.30,'602','2022-01-11 10:03:55','600','2022-01-11 10:06:33',10,0),('5','173',252800,'Morning','2022-01-11','2022-01-11 00:00:00',NULL,'602',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',252814,'Morning','2022-01-10','2022-01-10 00:00:00',NULL,'602',732446.55,732446.55,'602','2022-01-11 11:39:11','600','2022-01-11 15:00:50',10,0),('5','173',252903,'Morning','2022-01-11','2022-01-11 00:00:00',NULL,'602',765666.00,765666.00,'602','2022-01-12 11:44:44','600','2022-01-13 09:12:28',10,0),('5','173',253311,'Morning','2022-01-12','2022-01-12 00:00:00',NULL,'602',620733.30,620733.30,'602','2022-01-13 11:12:57','600','2022-01-13 11:17:28',10,0),('5','173',253414,'Morning','2022-01-13','2022-01-13 00:00:00',NULL,'602',362970.30,362970.30,'602','2022-01-14 07:10:08','600','2022-01-14 09:53:24',10,0),('5','173',253560,'Morning','2022-01-14','2022-01-14 00:00:00',NULL,'602',260848.50,260848.50,'602','2022-01-15 10:11:15','600','2022-01-15 10:55:54',10,0),('5','173',253814,'Morning','2022-01-15','2022-01-15 00:00:00',NULL,'602',85800.00,85800.00,'602','2022-01-16 09:33:23','600','2022-01-17 09:14:18',10,0),('5','173',254377,'Morning','2022-01-16','2022-01-16 00:00:00',NULL,'602',167479.95,167479.95,'602','2022-01-17 20:35:20','600','2022-01-17 21:24:01',10,0),('5','173',254419,'Morning','2022-01-17','2022-01-17 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-17 21:59:09','600','2022-01-18 13:30:13',10,0),('5','173',254572,'Morning','2022-01-18','2022-01-18 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-18 19:30:36','600','2022-01-19 09:52:49',10,0),('5','173',254813,'Morning','2022-01-19','2022-01-19 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-19 21:27:26','600','2022-01-20 09:45:07',10,0),('5','173',255020,'Morning','2022-01-20','2022-01-20 00:00:00',NULL,'602',107664.15,107664.15,'602','2022-01-21 07:27:00','600','2022-01-21 09:58:56',10,0),('5','173',255301,'Morning','2022-01-21','2022-01-21 00:00:00',NULL,'602',505696.95,505696.95,'602','2022-01-22 16:32:46','600','2022-01-23 09:04:13',10,0),('5','173',255754,'Morning','2022-01-22','2022-01-22 00:00:00',NULL,'602',501502.65,501502.65,'602','2022-01-23 09:08:35','600','2022-01-23 16:28:50',10,0),('5','173',255906,'Morning','2022-01-23','2022-01-23 00:00:00',NULL,'602',256588.20,256588.20,'602','2022-01-24 12:38:18','600','2022-01-25 09:11:10',10,0),('5','173',256342,'Morning','2022-01-24','2022-01-24 00:00:00',NULL,'602',380285.40,380285.40,'602','2022-01-25 13:41:10','600','2022-01-25 15:22:29',10,0),('5','173',256381,'Morning','2022-01-25','2022-01-25 00:00:00',NULL,'602',342985.50,342985.50,'602','2022-01-26 06:50:23','600','2022-01-26 09:04:46',10,0),('5','173',256590,'Morning','2022-01-26','2022-01-26 00:00:00',NULL,'602',198052.80,198052.80,'602','2022-01-27 08:38:06','600','2022-01-27 10:04:50',10,0),('5','173',256893,'Morning','2022-01-27','2022-01-27 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-28 08:11:01','600','2022-01-28 10:48:19',10,0),('5','173',257077,'Morning','2022-01-28','2022-01-28 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-29 06:04:21','600','2022-01-29 13:26:19',10,0),('5','173',257495,'Morning','2022-01-29','2022-01-29 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-30 07:21:03','600','2022-01-30 10:20:14',10,0),('5','173',257659,'Morning ','2022-01-30','2022-01-30 00:00:00',NULL,'602',0.00,0.00,'602','2022-01-30 17:10:21','600','2022-02-01 09:11:27',10,0),('5','173',257660,'Morning','2022-01-31','2022-01-31 00:00:00',NULL,'602',0.00,0.00,'602','2022-02-01 11:01:43','600','2022-02-01 11:04:17',10,0),('5','173',257661,'Morning','2022-02-01','2022-02-01 00:00:00',NULL,'602',0.00,0.00,'602','2022-02-01 17:56:13','600','2022-02-03 14:02:35',10,0),('5','173',257662,'Morning','2022-02-02','2022-02-02 00:00:00',NULL,'602',249438.75,249438.75,'602','2022-02-03 19:01:49','600','2022-02-04 09:24:35',10,0),('5','173',257663,'Morning','2022-02-03','2022-02-03 00:00:00',NULL,'602',268804.80,268804.80,'602','2022-02-05 12:04:03','600','2022-02-06 05:27:06',10,0),('5','173',257664,'Morning','2022-02-04','2022-02-04 00:00:00',NULL,'602',722221.50,722221.50,'602','2022-02-06 17:06:42','600','2022-02-06 20:23:14',10,0),('5','173',257665,'Morning ','2022-02-06','2022-02-06 00:00:00',NULL,'602',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','173',257666,'Morning','2022-02-05','2022-02-05 00:00:00',NULL,'602',1024310.10,1024310.10,'602','2022-02-06 21:10:12','600','2022-02-06 21:12:12',10,0),('5','173',257667,'Morning','2022-02-06','2022-02-06 00:00:00',NULL,'602',626184.90,626184.90,'602','2022-02-06 21:21:55','600','2022-02-07 15:48:33',10,0),('5','173',257668,'Morning','2022-02-07','2022-02-07 00:00:00',NULL,'602',1410065.25,1410065.25,'602','2022-02-08 07:57:07','600','2022-02-09 09:12:41',10,0),('5','173',257669,'Morning ','2022-02-08','2022-02-08 00:00:00',NULL,'602',1021909.35,1021909.35,'602','2022-02-09 12:11:05','600','2022-02-09 15:26:19',10,0),('5','173',257670,'Morning','2022-02-09','2022-02-09 00:00:00',NULL,'602',1675180.65,1675180.65,'602','2022-02-10 14:09:47','600','2022-02-10 14:18:46',10,0),('5','173',257671,'Morning','2022-02-10','2022-02-10 00:00:00',NULL,'602',2036639.55,2036639.55,'602','2022-02-11 06:15:14','600','2022-02-11 09:47:07',10,0),('5','173',257672,'Morning','2022-02-11','2022-02-11 00:00:00',NULL,'602',1061346.00,1061346.00,'602','2022-02-12 03:40:51','600','2022-02-12 08:48:31',10,0),('5','173',257673,'Morning','2022-02-12','2022-02-12 00:00:00',NULL,'602',1140907.35,1140907.35,'602','2022-02-13 02:26:35','600','2022-02-13 09:05:03',10,0),('5','173',257674,'Morning','2022-02-13','2022-02-13 00:00:00',NULL,'602',819510.45,819510.45,'602','2022-02-14 08:30:43','600','2022-02-14 09:00:52',10,0),('5','173',257675,'Morning','2022-02-14','2022-02-14 00:00:00',NULL,'602',370613.10,370613.10,'602','2022-02-15 16:11:20','600','2022-02-15 16:50:13',10,0),('5','173',257676,'Morning ','2022-02-15','2022-02-15 00:00:00',NULL,'602',0.00,0.00,'602','2022-02-16 18:25:02','600','2022-02-17 09:00:18',10,0),('5','173',257677,'Morning ','2022-02-16','2022-02-16 00:00:00',NULL,'602',0.00,0.00,'602','2022-02-17 10:06:58','600','2022-02-18 09:27:18',10,0),('5','173',257678,'Morning ','2022-02-17','2022-02-17 00:00:00',NULL,'602',264298.65,264298.65,'602','2022-02-19 15:12:35','600','2022-02-20 08:52:09',10,0),('5','173',257679,'Morning ','2022-02-18','2022-02-18 00:00:00',NULL,'602',960262.05,960262.05,'602','2022-02-20 11:28:00','600','2022-02-20 11:50:16',10,0),('5','173',257680,'Morning ','2022-02-19','2022-02-19 00:00:00',NULL,'602',767872.05,767872.05,'602','2022-02-20 12:29:27','600','2022-02-20 13:54:56',10,0),('5','173',257681,'Morning ','2022-02-20','2022-02-20 00:00:00',NULL,'602',710993.25,710993.25,'602','2022-02-20 18:05:47','600','2022-02-21 10:00:21',10,0),('5','173',257682,'Morning ','2022-02-21','2022-02-21 00:00:00',NULL,'602',0.00,0.00,'602','2022-02-21 21:10:00','600','2022-02-22 09:29:25',10,0),('5','173',257683,'Morning ','2022-02-22','2022-02-22 13:32:30','2022-02-23 13:32:30','602',0.00,0.00,'602','2022-02-23 07:17:20','600','2022-02-23 09:14:02',10,0),('5','173',257684,'Morning ','2022-02-23','2022-02-23 20:11:29','2022-02-24 20:11:29','602',0.00,0.00,'602','2022-02-23 20:11:46','600','2022-02-24 08:15:28',10,0),('5','173',257685,'Morning ','2022-02-24','2022-02-24 23:34:16','2022-02-25 23:34:16','602',1245857.25,1245857.25,'602','2022-02-26 14:12:28','600','2022-02-27 09:06:20',10,0),('5','173',257686,'Morning ','2022-02-25','2022-02-27 09:09:06','2022-02-28 09:09:06','602',1651610.40,1651610.40,'602','2022-02-27 09:11:39','600','2022-02-27 13:44:19',10,0),('5','173',257687,'Morning ','2022-02-26','2022-02-28 08:21:54','2022-03-01 08:21:54','602',332512.95,332512.95,'602','2022-02-28 12:34:44','600','2022-02-28 12:44:26',10,0),('5','173',257688,'Morning ','2022-02-27','2022-02-28 12:51:31','2022-03-01 12:51:31','602',2580494.40,2580494.40,'602','2022-02-28 14:51:07','600','2022-02-28 15:54:54',10,0),('5','173',257689,'Morning ','2022-02-28','2022-02-28 16:26:36','2022-03-01 16:26:36','602',2023093.05,2023093.05,'602','2022-03-01 12:52:02','600','2022-03-02 09:53:19',10,0),('5','173',257690,'Morning ','2022-03-01','2022-03-02 11:34:43','2022-03-03 11:34:43','602',380787.00,380787.00,'602','2022-03-03 07:27:55','600','2022-03-03 10:25:28',10,0),('5','173',257691,'Morning ','2022-03-02','2022-03-03 12:43:56','2022-03-04 12:43:56','602',462000.00,462000.00,'602','2022-03-03 12:53:08','600','2022-03-03 14:25:50',10,0),('5','173',257692,'Morning ','2022-03-03','2022-03-03 19:09:29','2022-03-04 19:09:29','602',0.00,0.00,'602','2022-03-04 07:00:02','600','2022-03-04 09:30:25',10,0),('5','173',257693,'Morning ','2022-03-04','2022-03-04 18:19:32','2022-03-05 18:19:32','602',0.00,0.00,'602','2022-03-05 06:34:42','600','2022-03-05 10:24:20',10,0),('5','173',257694,'Morning ','2022-03-05','2022-03-05 18:42:56','2022-03-06 18:42:56','602',0.00,0.00,'602','2022-03-05 18:43:20','600','2022-03-06 11:34:44',10,0),('5','173',257695,'Morning ','2022-03-06','2022-03-06 12:58:21','2022-03-07 12:58:21','602',0.00,0.00,'602','2022-03-07 07:32:32','600','2022-03-07 09:59:02',10,0),('5','173',257696,'Morning ','2022-03-07','2022-03-07 12:43:22','2022-03-08 12:43:22','602',0.00,0.00,'602','2022-03-13 09:18:47','600','2022-03-13 12:04:23',10,0),('5','173',257697,'Morning ','2022-03-08','2022-03-13 15:49:33','2022-03-14 15:49:33','602',0.00,0.00,'602','2022-03-13 15:50:12','600','2022-03-13 17:16:40',10,0),('5','173',257698,'Morning ','2022-03-09','2022-03-13 18:21:41','2022-03-14 18:21:41','602',1734428.85,1734428.85,'602','2022-03-13 18:25:41','600','2022-03-13 18:57:55',10,0),('5','173',257699,'Morning ','2022-03-10','2022-03-13 19:58:36','2022-03-14 19:58:36','602',1805553.75,1805553.75,'602','2022-03-13 20:00:57','600','2022-03-13 20:55:53',10,0),('5','173',257700,'Morning ','2022-03-11','2022-03-14 00:59:17','2022-03-15 00:59:17','602',4127663.10,4127663.10,'602','2022-03-14 01:29:52','600','2022-03-14 09:18:33',10,0),('5','173',257701,'Morning ','2022-03-12','2022-03-14 13:28:03','2022-03-15 13:28:03','602',2600992.35,2600992.35,'602','2022-03-15 11:38:53','600','2022-03-15 12:30:16',10,0),('5','173',257702,'Morning ','2022-03-13','2022-03-15 12:59:25','2022-03-16 12:59:25','602',1819478.10,1819478.10,'602','2022-03-15 13:02:09','600','2022-03-15 13:38:47',10,0),('5','173',257703,'Morning ','2022-03-14','2022-03-15 16:21:54','2022-03-16 16:21:54','602',1023301.95,1023301.95,'602','2022-03-15 16:24:04','600','2022-03-15 16:25:16',10,0),('5','173',257704,'Morning ','2022-03-15','2022-03-15 16:40:43','2022-03-16 16:40:43','602',912248.70,912248.70,'602','2022-03-16 08:45:10','600','2022-03-16 11:43:15',10,0),('5','173',257705,'Morning ','2022-03-16','2022-03-16 13:22:07','2022-03-17 13:22:07','602',521119.50,521119.50,'602','2022-03-17 07:40:08','600','2022-03-17 08:54:56',10,0),('5','173',257706,'Morning ','2022-03-17','2022-03-17 18:52:57','2022-03-18 18:52:57','602',0.00,0.00,'602','2022-03-18 08:00:10','600','2022-03-18 09:22:09',10,0),('5','173',257707,'Morning ','2022-03-18','2022-03-19 08:45:46','2022-03-20 08:45:46','602',0.00,0.00,'602','2022-03-19 08:46:00','600','2022-03-19 10:16:14',10,0),('5','173',257708,'Morning ','2022-03-19','2022-03-20 08:48:01','2022-03-21 08:48:01','602',0.00,0.00,'602','2022-03-20 08:48:22','600','2022-03-20 13:18:25',10,0),('5','173',257709,'Morning ','2022-03-20','2022-03-21 13:38:42','2022-03-22 13:38:42','602',0.00,0.00,'602','2022-03-21 13:39:05','600','2022-03-22 09:11:57',10,0),('5','173',257710,'Morning ','2022-03-21','2022-03-22 10:54:23','2022-03-23 10:54:23','602',0.00,0.00,'602','2022-03-22 10:54:46','600','2022-03-23 10:22:19',10,0),('5','173',257711,'Morning ','2022-03-22','2022-03-23 16:40:56','2022-03-24 16:40:56','602',0.00,0.00,'602','2022-03-23 16:41:09','600','2022-03-24 09:08:22',10,0),('5','173',257712,'Morning ','2022-03-23','2022-03-24 13:32:06','2022-03-25 13:32:06','602',0.00,0.00,'602','2022-03-24 13:32:22','600','2022-03-25 10:23:25',10,0),('5','173',257713,'Morning ','2022-03-24','2022-03-26 11:02:58','2022-03-27 11:02:58','602',0.00,0.00,'602','2022-03-26 11:03:17','600','2022-03-26 12:43:43',10,0),('5','173',257714,'Morning ','2022-03-25','2022-03-27 12:07:22','2022-03-28 12:07:22','602',0.00,0.00,'602','2022-03-27 12:07:42','600','2022-03-28 10:14:10',10,0),('5','173',257715,'Morning ','2022-03-26','2022-03-28 10:31:18','2022-03-29 10:31:18','602',0.00,0.00,'602','2022-03-28 10:31:35','600','2022-03-28 11:10:23',10,0),('5','173',257716,'Morning ','2022-03-27','2022-03-28 22:44:28','2022-03-29 22:44:28','602',0.00,0.00,'602','2022-03-28 22:44:48','600','2022-03-29 11:35:32',10,0),('5','173',257717,'Morning ','2022-03-28','2022-03-29 18:19:13','2022-03-30 18:19:13','602',0.00,0.00,'602','2022-03-30 00:09:48','600','2022-03-30 10:03:13',10,0),('5','173',257718,'Morning ','2022-03-29','2022-03-30 12:08:39','2022-03-31 12:08:39','602',0.00,0.00,'602','2022-03-30 12:08:59','600','2022-03-31 09:29:56',10,0),('5','173',257719,'Morning ','2022-03-30','2022-03-31 16:21:50','2022-04-01 16:21:50','602',0.00,0.00,'602','2022-03-31 16:22:09','600','2022-04-01 16:23:18',10,0),('5','173',257720,'Morning ','2022-03-31','2022-04-02 00:32:17','2022-04-03 00:32:17','602',0.00,0.00,'602','2022-04-02 00:33:03','600','2022-04-02 16:15:05',10,0),('5','173',257721,'Morning ','2022-04-01','2022-04-03 03:57:01','2022-04-04 03:57:01','602',0.00,0.00,'602','2022-04-03 03:57:15','600','2022-04-04 09:10:52',10,0),('5','173',257722,'Morning ','2022-04-02','2022-04-04 15:13:49','2022-04-05 15:13:49','602',0.00,0.00,'602','2022-04-04 15:14:02','600','2022-04-05 11:34:13',10,0),('5','173',257723,'Morning ','2022-04-03','2022-04-05 16:59:59','2022-04-06 16:59:59','602',0.00,0.00,'602','2022-04-05 17:00:18','600','2022-04-07 14:01:19',10,0),('5','173',257724,'Morning ','2022-04-04','2022-04-07 15:56:19','2022-04-08 15:56:19','602',0.00,0.00,'602','2022-04-07 15:56:34','600','2022-04-08 09:13:06',10,0),('5','173',257725,'Morning ','2022-04-05','2022-04-08 21:02:15','2022-04-09 21:02:15','602',0.00,0.00,'602','2022-04-08 21:02:54','600','2022-04-09 09:06:19',10,0),('5','173',257726,'Morning ','2022-04-06','2022-04-09 21:55:52','2022-04-10 21:55:52','602',0.00,0.00,'602','2022-04-09 21:56:34','600','2022-04-10 12:37:23',10,0),('5','173',257727,'Morning ','2022-04-07','2022-04-10 14:11:35','2022-04-11 14:11:35','602',0.00,0.00,'602','2022-04-10 14:11:49','600','2022-04-11 09:09:01',10,0),('5','173',257728,'Morning ','2022-04-08','2022-04-11 15:58:29','2022-04-12 15:58:29','602',0.00,0.00,'602','2022-04-11 15:58:42','600','2022-04-12 09:05:51',10,0),('5','173',257729,'Morning ','2022-04-09','2022-04-12 10:45:05','2022-04-13 10:45:05','602',0.00,0.00,'602','2022-04-12 10:45:24','600','2022-04-13 09:01:38',10,0),('5','173',257730,'Morning ','2022-04-10','2022-04-13 09:16:09','2022-04-14 09:16:09','602',0.00,0.00,'602','2022-04-13 09:16:24','600','2022-04-14 09:25:37',10,0),('5','173',257731,'Morning ','2022-04-11','2022-04-14 14:57:10','2022-04-15 14:57:10','602',0.00,0.00,'602','2022-04-14 14:57:20','600','2022-04-15 10:25:41',10,0),('5','173',257732,'Morning ','2022-04-12','2022-04-15 13:57:30','2022-04-16 13:57:30','602',0.00,0.00,'602','2022-04-15 13:57:43','600','2022-04-16 08:32:37',10,0),('5','173',257733,'Morning ','2022-04-13','2022-04-16 16:31:37','2022-04-17 16:31:37','602',0.00,0.00,'602','2022-04-16 16:31:50','600','2022-04-16 19:59:19',10,0),('5','173',257734,'Morning ','2022-04-14','2022-04-17 12:00:26','2022-04-18 12:00:26','602',0.00,0.00,'602','2022-04-17 12:00:42','600','2022-04-17 12:32:31',10,0),('5','173',257735,'Morning ','2022-04-15','2022-04-18 19:53:36','2022-04-19 19:53:36','602',0.00,0.00,'602','2022-04-18 19:53:48','600','2022-04-19 10:57:51',10,0),('5','173',257736,'Morning ','2022-04-16','2022-04-19 10:59:28','2022-04-20 10:59:28','602',0.00,0.00,'602','2022-04-19 11:00:08','600','2022-04-19 11:35:27',10,0),('5','173',257737,'Morning ','2022-04-17','2022-04-20 06:13:38','2022-04-21 06:13:38','602',0.00,0.00,'602','2022-04-20 06:13:52','600','2022-04-20 10:15:05',10,0),('5','173',257738,'Morning ','2022-04-18','2022-04-20 11:19:25','2022-04-21 11:19:25','602',0.00,0.00,'602','2022-04-20 11:19:37','600','2022-04-21 09:25:08',10,0),('5','173',257739,'Morning ','2022-04-19','2022-04-21 14:35:36','2022-04-22 14:35:36','602',0.00,0.00,'602','2022-04-21 14:35:48','600','2022-04-22 10:20:10',10,0),('5','173',257740,'Morning ','2022-04-20','2022-04-22 11:10:44','2022-04-23 11:10:44','602',107250.00,107250.00,'602','2022-04-23 06:54:05','600','2022-04-23 09:14:24',10,0),('5','173',257741,'Morning ','2022-04-21','2022-04-23 11:11:10','2022-04-24 11:11:10','602',645646.65,645646.65,'602','2022-04-23 15:26:06','600','2022-04-23 15:27:08',10,0),('5','173',257742,'Morning ','2022-04-22','2022-04-23 18:35:52','2022-04-24 18:35:52','602',822675.15,822675.15,'602','2022-04-23 18:37:42','600','2022-04-23 21:09:11',10,0),('5','173',257743,'Morning ','2022-04-23','2022-04-24 06:43:17','2022-04-25 06:43:17','602',630009.60,630009.60,'602','2022-04-24 17:47:46','600','2022-04-25 11:42:21',10,0),('5','173',257744,'Morning ','2022-04-24','2022-04-25 13:40:01','2022-04-26 13:40:01','602',643788.75,643788.75,'602','2022-04-25 13:42:11','600','2022-04-25 13:45:05',10,0),('5','173',257745,'Morning ','2022-04-25','2022-04-25 15:45:13','2022-04-26 15:45:13','602',694503.15,694503.15,'602','2022-04-25 17:43:29','600','2022-04-26 10:24:10',10,0),('5','173',257746,'Morning ','2022-04-26','2022-04-26 16:33:26','2022-04-27 16:33:26','602',691480.35,691480.35,'602','2022-04-26 18:20:10','600','2022-04-27 10:20:31',10,0),('5','173',257747,'Morning ','2022-04-27','2022-04-27 10:48:45','2022-04-28 10:48:45','602',508541.55,508541.55,'602','2022-04-27 17:54:19','600','2022-04-28 12:52:37',10,0),('5','173',257748,'Morning ','2022-04-28','2022-04-29 09:57:20','2022-04-30 09:57:20','602',635740.05,635740.05,'602','2022-04-29 09:59:04','600','2022-04-29 10:13:20',10,0),('5','173',257749,'Morning ','2022-04-29','2022-04-29 11:20:28','2022-04-30 11:20:28','602',529245.75,529245.75,'602','2022-05-10 10:17:11','600','2022-05-10 10:18:16',10,0),('5','173',257750,'Morning ','2022-04-30','2022-05-10 10:19:10','2022-05-11 10:19:10','602',447813.30,447813.30,'602','2022-05-10 10:20:04','600','2022-05-10 10:21:16',10,0),('5','173',257751,'Morning ','2022-05-01','2022-05-10 10:22:10','2022-05-11 10:22:10','602',440365.20,440365.20,'602','2022-05-10 10:23:00','600','2022-05-10 10:27:38',10,0),('5','173',257752,'Morning ','2022-05-02','2022-05-10 10:28:26','2022-05-11 10:28:26','602',300361.05,300361.05,'602','2022-05-10 10:30:08','600','2022-05-10 10:31:51',10,0),('5','173',257753,'Morning ','2022-05-03','2022-05-10 10:32:26','2022-05-11 10:32:26','602',99003.30,99003.30,'602','2022-05-10 10:33:57','600','2022-05-10 10:37:58',10,0),('5','173',257754,'Morning ','2022-05-04','2022-05-10 10:39:20','2022-05-11 10:39:20','602',0.00,0.00,'602','2022-05-10 10:40:07','600','2022-05-10 10:40:59',10,0),('5','173',257755,'Morning ','2022-05-05','2022-05-10 10:42:39','2022-05-11 10:42:39','602',0.00,0.00,'602','2022-05-10 10:43:10','600','2022-05-10 10:43:53',10,0),('5','173',257756,'Morning ','2022-05-06','2022-05-10 10:45:22','2022-05-11 10:45:22','602',0.00,0.00,'602','2022-05-10 10:46:12','600','2022-05-10 10:47:24',10,0),('5','173',257757,'Morning ','2022-05-07','2022-05-10 10:49:50','2022-05-11 10:49:50','602',0.00,0.00,'602','2022-05-10 10:51:18','600','2022-05-10 10:52:25',10,0),('5','173',257758,'Morning ','2022-05-08','2022-05-10 10:52:45','2022-05-11 10:52:45','602',0.00,0.00,'602','2022-05-10 10:53:07','600','2022-05-10 10:53:45',10,0),('5','173',257759,'Morning ','2022-05-09','2022-05-10 10:54:15','2022-05-11 10:54:15','602',0.00,0.00,'602','2022-05-10 10:54:30','600','2022-05-10 10:54:58',10,0),('5','173',257760,'Morning ','2022-05-10','2022-05-10 10:55:23','2022-05-11 10:55:23','602',92400.00,92400.00,'602','2022-05-11 08:09:25','600','2022-05-11 09:40:22',10,0),('5','173',257761,'Morning ','2022-05-11','2022-05-11 10:12:30','2022-05-12 10:12:30','602',815463.00,815463.00,'602','2022-05-12 10:08:03','600','2022-05-12 13:10:13',10,0),('5','173',257762,'Morning ','2022-05-12','2022-05-13 07:57:08','2022-05-14 07:57:08','602',834537.00,834537.00,'602','2022-05-13 08:24:30','600','2022-05-13 11:35:04',10,0),('5','173',257763,'Morning ','2022-05-13','2022-05-13 14:29:53','2022-05-14 14:29:53','602',876443.70,876443.70,'602','2022-05-14 09:08:57','600','2022-05-14 13:46:26',10,0),('5','173',257764,'Morning ','2022-05-14','2022-05-15 07:56:36','2022-05-16 07:56:36','602',773556.30,773556.30,'602','2022-05-15 09:53:26','600','2022-05-16 10:05:04',10,0),('5','173',257765,'Morning ','2022-05-15','2022-05-16 12:37:33','2022-05-17 12:37:33','602',776384.40,776384.40,'602','2022-05-16 15:01:33','600','2022-05-16 15:08:56',10,0),('5','173',257766,'Morning ','2022-05-16','2022-05-16 15:12:22','2022-05-17 15:12:22','602',646882.50,646882.50,'602','2022-05-17 09:03:29','600','2022-05-17 09:04:33',10,0),('5','173',257767,'Morning ','2022-05-17','2022-05-18 07:00:01','2022-05-19 07:00:01','602',673101.00,673101.00,'602','2022-05-18 07:06:10','600','2022-05-18 07:36:58',10,0),('5','173',257768,'Morning ','2022-05-18','2022-05-19 07:41:27','2022-05-20 07:41:27','602',685401.75,685401.75,'602','2022-05-19 07:42:51','600','2022-05-19 08:21:39',10,0),('5','173',257769,'Morning ','2022-05-19','2022-05-19 08:46:04','2022-05-20 08:46:04','602',634596.60,634596.60,'602','2022-05-20 08:12:39','600','2022-05-20 21:23:34',10,0),('5','173',257770,'Morning ','2022-05-20','2022-05-21 13:01:49','2022-05-22 13:01:49','602',485918.40,485918.40,'602','2022-05-21 13:05:48','600','2022-05-22 08:12:21',10,0),('5','173',257771,'Morning ','2022-05-21','2022-05-22 09:39:58','2022-05-23 09:39:58','602',198024.75,198024.75,'602','2022-05-22 09:40:27','600','2022-05-22 14:37:34',10,0),('5','173',257772,'Morning ','2022-05-22','2022-05-23 06:01:00','2022-05-24 06:01:00','602',0.00,0.00,'602','2022-05-23 13:33:59','600','2022-05-23 13:48:01',10,0),('5','173',257773,'Morning ','2022-05-23','2022-05-23 15:22:34','2022-05-24 15:22:34','602',0.00,0.00,'602','2022-05-24 08:20:06','600','2022-05-24 17:32:42',10,0),('5','173',257774,'Morning ','2022-05-24','2022-05-24 18:27:20','2022-05-25 18:27:20','602',0.00,0.00,'602','2022-05-24 18:27:36','600','2022-05-25 06:09:51',10,0),('5','173',257775,'Morning ','2022-05-25','2022-05-25 09:33:03','2022-05-26 09:33:03','602',0.00,0.00,'602','2022-05-25 20:30:14','600','2022-05-26 05:29:23',10,0),('5','173',257776,'Morning ','2022-05-26','2022-05-26 13:51:25','2022-05-27 13:51:25','602',0.00,0.00,'602','2022-05-26 18:13:45','600','2022-05-26 20:38:15',10,0),('5','173',257777,'Morning ','2022-05-27','2022-05-27 12:10:18','2022-05-28 12:10:18','602',0.00,0.00,'602','2022-05-27 19:43:41','600','2022-05-28 08:15:22',10,0),('5','173',257778,'Morning ','2022-05-28','2022-05-28 18:43:49','2022-05-29 18:43:49','602',0.00,0.00,'602','2022-05-28 18:44:03','600','2022-05-29 08:16:36',10,0),('5','173',257779,'Morning ','2022-05-29','2022-05-29 16:33:03','2022-05-30 16:33:03','602',0.00,0.00,'602','2022-05-29 16:33:17','600','2022-05-30 05:59:29',10,0),('5','173',257780,'Morning ','2022-05-30','2022-05-30 11:24:39','2022-05-31 11:24:39','602',0.00,0.00,'602','2022-05-30 18:20:11','600','2022-05-31 09:09:38',10,0),('5','173',257781,'Morning ','2022-05-31','2022-05-31 09:13:12','2022-06-01 09:13:12','602',0.00,0.00,'602','2022-05-31 18:02:54','600','2022-05-31 22:59:16',10,0),('5','173',257782,'Morning ','2022-06-01','2022-06-01 17:34:48','2022-06-02 17:34:48','602',0.00,0.00,'602','2022-06-01 17:35:02','600','2022-06-02 09:08:36',10,0),('5','173',257783,'Morning ','2022-06-02','2022-06-02 12:22:00','2022-06-03 12:22:00','602',0.00,0.00,'602','2022-06-02 17:27:28','600','2022-06-03 09:30:54',10,0),('5','173',257784,'Morning ','2022-06-03','2022-06-03 11:05:57','2022-06-04 11:05:57','602',486429.90,486429.90,'602','2022-06-04 09:51:45','600','2022-06-04 15:42:43',10,0),('5','173',257785,'Morning ','2022-06-04','2022-06-04 17:40:19','2022-06-05 17:40:19','602',833566.80,833566.80,'602','2022-06-06 11:09:01','600','2022-06-06 11:10:38',10,0),('5','173',257786,'Morning ','2022-06-06','2022-06-06 11:16:38','2022-06-07 11:16:38','602',775838.25,775838.25,'602','2022-06-06 11:17:45','600','2022-06-06 12:03:38',10,0),('5','173',257787,'Morning ','2022-06-06','2022-06-07 09:14:31','2022-06-08 09:14:31','602',775839.90,775839.90,'602','2022-06-07 09:15:28','600','2022-06-07 11:02:32',10,0),('5','173',257788,'Morning ','2022-06-07','2022-06-07 22:01:29','2022-06-08 22:01:29','602',1340090.40,1340090.40,'602','2022-06-08 13:55:18','600','2022-06-08 15:30:23',10,0),('5','173',257789,'Morning ','2022-06-08','2022-06-08 15:34:26','2022-06-09 15:34:26','602',1188000.00,1188000.00,'602','2022-06-09 06:19:47','600','2022-06-09 11:16:03',10,0),('5','173',257790,'Morning ','2022-06-09','2022-06-09 14:12:15','2022-06-10 14:12:15','602',908518.05,908518.05,'602','2022-06-10 10:37:49','600','2022-06-10 15:28:31',10,0),('5','173',257791,'Morning ','2022-06-10','2022-06-10 18:30:22','2022-06-11 18:30:22','602',1084559.85,1084559.85,'602','2022-06-11 16:41:22','600','2022-06-12 09:56:54',10,0),('5','173',257792,'Morning ','2022-06-12','2022-06-12 12:19:49','2022-06-13 12:19:49','602',854416.20,854416.20,'602','2022-06-12 14:09:29','600','2022-06-12 14:10:19',10,0),('5','173',257793,'Morning ','2022-06-12','2022-06-12 14:11:17','2022-06-13 14:11:17','602',795582.15,795582.15,'602','2022-06-13 07:42:58','600','2022-06-13 09:32:27',10,0),('5','173',257794,'Morning ','2022-06-13','2022-06-13 10:31:27','2022-06-14 10:31:27','602',826019.70,826019.70,'602','2022-06-14 10:45:40','600','2022-06-14 11:02:26',10,0),('5','173',257795,'Morning ','2022-06-14','2022-06-14 12:27:43','2022-06-15 12:27:43','602',823980.30,823980.30,'602','2022-06-15 10:01:34','600','2022-06-16 09:19:59',10,0),('5','173',257796,'Morning ','2022-06-15','2022-06-16 18:17:39','2022-06-17 18:17:39','602',673579.50,673579.50,'602','2022-06-16 18:18:48','600','2022-06-17 09:58:06',10,0),('5','173',257797,'Morning ','2022-06-16','2022-06-17 11:00:24','2022-06-18 11:00:24','602',613915.50,613915.50,'602','2022-06-17 11:01:57','600','2022-06-18 09:49:32',10,0),('5','173',257798,'Morning ','2022-06-17','2022-06-18 10:01:20','2022-06-19 10:01:20','602',570603.00,570603.00,'602','2022-06-18 10:02:28','600','2022-06-19 09:35:14',10,0),('5','173',257799,'Morning ','2022-06-18','2022-06-19 20:29:10','2022-06-20 20:29:10','602',495808.50,495808.50,'602','2022-06-19 20:31:32','600','2022-06-20 10:00:17',10,0),('5','173',257800,'Morning ','2022-06-19','2022-06-20 11:30:07','2022-06-21 11:30:07','602',482062.35,482062.35,'602','2022-06-20 11:33:13','600','2022-06-21 09:57:46',10,0),('5','173',257801,'Morning ','2022-06-20','2022-06-21 10:53:52','2022-06-22 10:53:52','602',413061.00,413061.00,'602','2022-06-21 10:55:32','600','2022-06-22 09:33:14',10,0),('5','173',257802,'Morning ','2022-06-21','2022-06-22 11:22:24','2022-06-23 11:22:24','602',265437.15,265437.15,'602','2022-06-22 11:23:38','600','2022-06-22 14:33:15',10,0),('5','173',257803,'Morning ','2022-06-22','2022-06-22 14:45:02','2022-06-23 14:45:02','602',330178.20,330178.20,'602','2022-06-23 10:18:57','600','2022-06-23 11:10:49',10,0),('5','173',257804,'Morning ','2022-06-23','2022-06-23 11:15:57','2022-06-24 11:15:57','602',0.00,0.00,'602','2022-06-24 08:06:02','600','2022-06-24 09:44:34',10,0),('5','173',257805,'Morning ','2022-06-24','2022-06-25 05:54:05','2022-06-26 05:54:05','602',0.00,0.00,'602','2022-06-25 05:54:20','600','2022-06-25 09:27:12',10,0),('5','173',257806,'Morning ','2022-06-25','2022-06-25 15:31:37','2022-06-26 15:31:37','602',0.00,0.00,'602','2022-06-26 10:41:52','600','2022-06-26 12:16:17',10,0),('5','173',257807,'Morning ','2022-06-26','2022-06-26 15:49:16','2022-06-27 15:49:16','602',0.00,0.00,'602','2022-06-26 20:08:30','600','2022-06-27 10:26:16',10,0),('5','173',257808,'Morning ','2022-06-27','2022-06-27 19:33:15','2022-06-28 19:33:15','602',0.00,0.00,'602','2022-06-27 19:33:31','600','2022-06-28 09:19:42',10,0),('5','173',257809,'Morning ','2022-06-28','2022-06-28 14:15:30','2022-06-29 14:15:30','602',0.00,0.00,'602','2022-06-29 06:37:51','600','2022-06-29 09:09:02',10,0),('5','173',257810,'Morning ','2022-06-29','2022-06-29 18:23:54','2022-06-30 18:23:54','602',0.00,0.00,'602','2022-06-29 18:24:09','600','2022-06-30 08:32:35',10,0),('5','173',257811,'Morning ','2022-06-30','2022-06-30 09:17:31','2022-07-01 09:17:31','602',0.00,0.00,'602','2022-06-30 21:16:24','600','2022-07-01 09:56:46',10,0),('5','173',257812,'Morning ','2022-07-01','2022-07-02 03:15:33','2022-07-03 03:15:33','602',0.00,0.00,'602','2022-07-02 03:15:46','600','2022-07-02 14:29:13',10,0),('5','173',257813,'Morning ','2022-07-02','2022-07-02 18:50:41','2022-07-03 18:50:41','602',0.00,0.00,'602','2022-07-02 18:50:57','600','2022-07-03 09:38:53',10,0),('5','173',257814,'Morning ','2022-07-03','2022-07-03 11:34:10','2022-07-04 11:34:10','602',0.00,0.00,'602','2022-07-03 19:12:50','600','2022-07-04 12:15:36',10,0),('5','173',257815,'Morning ','2022-07-04','2022-07-04 12:47:21','2022-07-05 12:47:21','602',0.00,0.00,'602','2022-07-04 18:32:16','600','2022-07-05 09:19:18',10,0),('5','173',257816,'Morning ','2022-07-05','2022-07-05 11:39:53','2022-07-06 11:39:53','602',0.00,0.00,'602','2022-07-05 19:17:48','600','2022-07-06 09:19:10',10,0),('5','173',257817,'Morning ','2022-07-06','2022-07-06 12:34:00','2022-07-07 12:34:00','602',0.00,0.00,'602','2022-07-06 19:58:46','600','2022-07-07 10:41:45',10,0),('5','173',257818,'Morning ','2022-07-07','2022-07-07 16:27:06','2022-07-08 16:27:06','602',0.00,0.00,'602','2022-07-07 18:25:22','600','2022-07-08 08:58:30',10,0),('5','173',257819,'Morning ','2022-07-08','2022-07-08 19:26:04','2022-07-09 19:26:04','602',0.00,0.00,'602','2022-07-08 19:26:22','600','2022-07-09 16:55:56',10,0),('5','173',257820,'Morning ','2022-07-09','2022-07-09 17:23:08','2022-07-10 17:23:08','602',0.00,0.00,'602','2022-07-09 17:23:29','600','2022-07-09 20:31:31',10,0),('5','173',257821,'Morning ','2022-07-10','2022-07-10 14:29:05','2022-07-11 14:29:05','602',0.00,0.00,'602','2022-07-10 17:32:00','600','2022-07-11 08:26:44',10,0),('5','173',257822,'Morning ','2022-07-11','2022-07-11 14:28:08','2022-07-12 14:28:08','602',0.00,0.00,'602','2022-07-11 20:43:59','600','2022-07-12 10:55:28',10,0),('5','173',257823,'Morning ','2022-07-12','2022-07-12 20:07:21','2022-07-13 20:07:21','602',0.00,0.00,'602','2022-07-13 08:30:02','600','2022-07-13 09:34:18',10,0),('5','173',257824,'Morning ','2022-07-14','2022-07-14 09:13:13','2022-07-15 09:13:13','602',0.00,0.00,'602','2022-07-14 19:48:05','600','2022-07-15 11:01:34',10,0),('5','173',257825,'Morning ','2022-07-15','2022-07-15 12:14:03','2022-07-16 12:14:03','602',129698.25,145419.25,'602','2022-07-16 09:33:04','600','2022-07-16 09:57:51',10,0),('5','173',257826,'Morning ','2022-07-16','2022-07-17 07:55:15','2022-07-18 07:55:15','602',821011.50,821011.50,'602','2022-07-17 08:01:29','600','2022-07-17 09:22:05',10,0),('5','173',257827,'Morning ','2022-07-17','2022-07-17 09:33:08','2022-07-18 09:33:08','602',1028988.50,1028988.50,'602','2022-07-18 09:03:07','600','2022-07-18 09:05:59',10,0),('5','173',257828,'Morning ','2022-07-18','2022-07-18 19:08:47','2022-07-19 19:08:47','602',1010146.25,1010146.25,'602','2022-07-19 07:57:11','600','2022-07-19 09:42:43',10,0),('5','173',257829,'Morning ','2022-07-19','2022-07-19 10:41:18','2022-07-20 10:41:18','602',839853.75,844393.50,'602','2022-07-20 09:53:50','600','2022-07-20 14:03:57',10,0),('5','173',257830,'Morning ','2022-07-20','2022-07-20 14:12:46','2022-07-21 14:12:46','602',1000263.55,1000263.55,'602','2022-07-21 10:01:17','600','2022-07-21 10:21:47',10,0),('5','173',257831,'Morning ','2022-07-21','2022-07-21 10:23:50','2022-07-22 10:23:50','602',757236.45,757236.45,'602','2022-07-22 08:18:44','600','2022-07-22 09:54:30',10,0),('5','173',257832,'Morning ','2022-07-22','2022-07-22 10:48:59','2022-07-23 10:48:59','602',648049.45,648049.45,'602','2022-07-23 08:56:53','600','2022-07-23 10:38:15',10,0),('5','173',257833,'Morning ','2022-07-23','2022-07-23 12:13:12','2022-07-24 12:13:12','602',554413.55,554413.55,'602','2022-07-24 09:08:09','600','2022-07-24 09:32:06',10,0),('5','173',257834,'Morning ','2022-07-24','2022-07-24 15:09:03','2022-07-25 15:09:03','602',530063.85,530063.85,'602','2022-07-25 07:33:01','600','2022-07-25 07:36:42',10,0),('5','173',257835,'Morning ','2022-07-25','2022-07-25 09:43:43','2022-07-26 09:43:43','602',508716.70,508716.70,'602','2022-07-26 07:54:45','600','2022-07-26 09:23:00',10,0),('5','173',257836,'Morning ','2022-07-26','2022-07-26 09:23:46','2022-07-27 09:23:46','602',740719.65,740719.65,'602','2022-07-27 09:41:26','600','2022-07-27 11:20:20',10,0),('5','173',257837,'MORNING ','2022-07-27','2022-07-27 11:54:13','2022-07-28 11:54:13','602',556881.45,556881.45,'602','2022-07-28 08:54:43','600','2022-07-28 09:28:44',10,0),('5','173',257838,'MORNING ','2022-07-28','2022-07-28 09:39:30','2022-07-29 09:39:30','602',225994.15,225994.15,'602','2022-07-29 08:56:00','600','2022-07-29 09:26:17',10,0),('5','173',257839,'MORNING ','2022-07-29','2022-07-29 12:13:10','2022-07-30 12:13:10','602',0.00,0.00,'602','2022-07-29 17:11:40','600','2022-07-30 20:11:36',10,0),('5','173',257840,'MORNING ','2022-07-30','2022-07-31 09:10:33','2022-08-01 09:10:33','602',0.00,0.00,'602','2022-07-31 09:10:57','600','2022-07-31 10:18:00',10,0),('5','173',257841,'MORNING ','2022-07-31','2022-07-31 14:26:17','2022-08-01 14:26:17','602',0.00,0.00,'602','2022-08-01 10:02:31','600','2022-08-01 12:03:05',10,0),('5','173',257842,'MORNING ','2022-08-01','2022-08-01 19:02:04','2022-08-02 19:02:04','602',0.00,0.00,'602','2022-08-01 19:02:20','600','2022-08-02 11:18:50',10,0),('5','173',257843,'MORNING ','2022-08-02','2022-08-02 15:01:16','2022-08-03 15:01:16','602',0.00,0.00,'602','2022-08-03 07:12:50','600','2022-08-03 10:21:11',10,0),('5','173',257844,'MORNING ','2022-08-03','2022-08-03 12:00:08','2022-08-04 12:00:08','602',0.00,0.00,'602','2022-08-04 07:52:58','600','2022-08-04 08:22:22',10,0),('5','173',257845,'MORNING ','2022-08-04','2022-08-04 19:30:53','2022-08-05 19:30:53','602',0.00,0.00,'602','2022-08-05 07:48:34','600','2022-08-05 10:30:05',10,0),('5','173',257846,'MORNING ','2022-08-05','2022-08-05 15:27:00','2022-08-06 15:27:00','602',222778.85,222778.85,'602','2022-08-06 07:13:43','600','2022-08-06 09:00:05',10,0),('5','173',257847,'MORNING ','2022-08-06','2022-08-06 14:46:51','2022-08-07 14:46:51','602',816684.35,816684.35,'602','2022-08-07 06:38:33','600','2022-08-07 10:04:15',10,0),('5','173',257848,'MORNING ','2022-08-07','2022-08-07 14:31:48','2022-08-08 14:31:48','602',906333.50,906333.50,'602','2022-09-03 06:34:56','600','2022-09-03 09:37:23',10,0),('5','173',257849,'MORNING ','2022-08-08','2022-09-03 09:40:43','2022-09-04 09:40:43','602',738150.00,738150.00,'602','2022-09-03 09:43:05','600','2022-09-03 09:45:01',10,0),('5','173',257850,'MORNING ','2022-08-09','2022-09-03 09:45:32','2022-09-04 09:45:32','602',518577.20,518577.20,'602','2022-09-03 09:46:26','600','2022-09-03 09:47:04',10,0),('5','173',257851,'MORNING ','2022-08-10','2022-09-03 09:47:44','2022-09-04 09:47:44','602',695703.60,695703.60,'602','2022-09-03 09:49:28','600','2022-09-03 09:50:17',10,0),('5','173',257852,'MORNING ','2022-08-11','2022-09-03 09:51:13','2022-09-04 09:51:13','602',444569.80,444569.80,'602','2022-09-03 09:53:15','600','2022-09-03 09:54:38',10,0),('5','173',257853,'MORNING ','2022-08-12','2022-09-03 09:55:36','2022-09-04 09:55:36','602',259592.00,259592.00,'602','2022-09-03 09:56:34','600','2022-09-03 09:57:30',10,0),('5','173',257854,'MORNING ','2022-08-13','2022-09-03 09:58:15','2022-09-04 09:58:15','602',878540.95,878540.95,'602','2022-09-03 10:03:55','600','2022-09-03 10:04:54',10,0),('5','173',257855,'MORNING ','2022-08-14','2022-09-03 10:05:57','2022-09-04 10:05:57','602',433220.05,433220.05,'602','2022-09-03 10:07:32','600','2022-09-03 10:08:14',10,0),('5','173',257856,'MORNING ','2022-08-15','2022-09-03 10:09:52','2022-09-04 10:09:52','602',871331.50,871331.50,'602','2022-09-03 10:14:46','600','2022-09-03 10:15:33',10,0),('5','173',257857,'MORNING ','2022-08-16','2022-09-03 10:19:12','2022-09-04 10:19:12','602',867727.70,867727.70,'602','2022-09-03 10:21:01','600','2022-09-03 10:22:25',10,0),('5','173',257858,'MORNING ','2022-08-17','2022-09-03 10:23:01','2022-09-04 10:23:01','602',783467.60,783467.60,'602','2022-09-03 10:24:15','600','2022-09-03 10:35:08',10,0),('5','173',257859,'MORNING ','2022-08-18','2022-09-03 10:38:31','2022-09-04 10:38:31','602',860272.20,860272.20,'602','2022-09-03 10:39:52','600','2022-09-03 11:05:13',10,0),('5','173',257860,'MORNING ','2022-08-19','2022-09-03 11:38:52','2022-09-04 11:38:52','602',917729.50,917729.50,'602','2022-09-03 11:40:42','600','2022-09-03 12:12:25',10,0),('5','173',257861,'MORNING ','2022-08-20','2022-09-04 09:24:55','2022-09-05 09:24:55','602',792392.00,792392.00,'602','2022-09-04 09:27:25','600','2022-09-04 10:11:24',10,0),('5','173',257862,'MORNING ','2022-08-21','2022-09-04 10:14:27','2022-09-05 10:14:27','602',749218.55,749218.55,'602','2022-09-04 10:15:58','600','2022-09-04 10:17:30',10,0),('5','173',257863,'MORNING ','2022-07-22','2022-09-04 10:19:03','2022-09-05 10:19:03','602',861767.00,861767.00,'602','2022-09-04 10:20:48','600','2022-09-04 10:21:29',10,0),('5','173',257864,'MORNING ','2022-08-23','2022-09-04 10:21:58','2022-09-05 10:21:58','602',877251.50,877251.50,'602','2022-09-04 10:23:35','600','2022-09-04 10:24:01',10,0),('5','173',257865,'MORNING ','2022-08-24','2022-09-04 10:24:39','2022-09-05 10:24:39','602',712399.85,712399.85,'602','2022-09-04 10:25:53','600','2022-09-04 10:26:34',10,0),('5','173',257866,'MORNING ','2022-08-25','2022-09-04 10:27:02','2022-09-05 10:27:02','602',876200.70,876200.70,'602','2022-09-04 10:28:22','600','2022-09-04 10:28:50',10,0),('5','173',257867,'MORNING ','2022-08-26','2022-09-04 10:30:00','2022-09-05 10:30:00','602',1115483.40,1115483.40,'602','2022-09-04 10:35:59','600','2022-09-04 10:36:43',10,0),('5','173',257868,'MORNING ','2022-08-27','2022-09-04 10:37:35','2022-09-05 10:37:35','602',1131587.65,1131587.65,'602','2022-09-04 10:45:51','600','2022-09-04 10:48:30',10,0),('5','173',257869,'MORNING ','2022-08-28','2022-09-04 10:51:53','2022-09-05 10:51:53','602',835680.15,835680.15,'602','2022-09-04 10:57:43','600','2022-09-04 10:58:20',10,0),('5','173',257870,'MORNING ','2022-08-29','2022-09-04 10:58:50','2022-09-05 10:58:50','602',581479.05,581479.05,'602','2022-09-04 10:59:41','600','2022-09-04 11:00:16',10,0),('5','173',257871,'MORNING ','2022-08-30','2022-09-04 11:00:42','2022-09-05 11:00:42','602',557068.30,560079.48,'602','2022-09-04 11:01:42','600','2022-09-04 11:02:11',10,0),('5','173',257872,'MORNING ','2022-08-31','2022-09-04 11:02:38','2022-09-05 11:02:38','602',378659.85,378659.85,'602','2022-09-04 11:04:09','600','2022-09-04 11:04:33',10,0),('5','173',257873,'MORNING ','2022-09-01','2022-09-04 11:05:06','2022-09-05 11:05:06','602',415097.45,415097.45,'602','2022-09-04 11:06:02','600','2022-09-04 11:07:17',10,0),('5','173',257874,'MORNING ','2022-09-02','2022-09-04 11:07:46','2022-09-05 11:07:46','602',557812.00,557812.00,'602','2022-09-04 11:08:43','600','2022-09-04 11:09:09',10,0),('5','173',257875,'MORNING ','2022-09-03','2022-09-04 11:09:35','2022-09-05 11:09:35','602',378902.20,378902.20,'602','2022-09-04 11:12:16','600','2022-09-04 11:12:55',10,0),('5','173',257876,'MORNING ','2022-09-04','2022-09-04 11:13:23','2022-09-05 11:13:23','602',378876.30,378876.30,'602','2022-09-05 07:48:32','600','2022-09-05 10:23:04',10,0),('5','173',257877,'MORNING ','2022-09-05','2022-09-05 14:13:55','2022-09-06 14:13:55','602',521792.50,521792.50,'602','2022-09-06 09:26:26','600','2022-09-06 10:21:05',10,0),('5','173',257878,'MORNING ','2022-09-06','2022-09-07 03:34:04','2022-09-08 03:34:04','602',745455.65,745455.65,'602','2022-09-07 09:26:02','600','2022-09-07 15:23:25',10,0),('5','173',257879,'MORNING ','2022-09-07','2022-09-07 15:25:13','2022-09-08 15:25:13','602',382413.50,382413.50,'602','2022-09-08 11:09:01','600','2022-09-08 14:28:05',10,0),('5','173',257880,'MORNING ','2022-09-08','2022-09-09 11:56:52','2022-09-10 11:56:52','602',476289.90,476289.90,'602','2022-09-09 11:58:06','600','2022-09-09 16:22:32',10,0),('5','173',257881,'MORNING ','2022-09-09','2022-09-10 12:14:47','2022-09-11 12:14:47','602',394301.60,394301.60,'602','2022-09-10 14:35:16','600','2022-09-11 05:58:06',10,0),('5','173',257882,'MORNING ','2022-09-10','2022-09-11 07:28:31','2022-09-12 07:28:31','602',445163.65,445163.65,'602','2022-09-11 07:31:51','600','2022-09-12 05:54:38',10,0),('5','173',257883,'MORNING ','2022-09-11','2022-09-12 06:28:32','2022-09-13 06:28:32','602',371524.40,371524.40,'602','2022-09-13 08:08:44','600','2022-09-13 10:33:28',10,0),('5','173',257884,'MORNING ','2022-09-12','2022-09-13 12:06:45','2022-09-14 12:06:45','602',398813.75,398813.75,'602','2022-09-13 12:08:08','600','2022-09-14 06:02:18',10,0),('5','173',257885,'MORNING ','2022-09-14','2022-09-14 06:03:39','2022-09-15 06:03:39','602',407382.95,407382.95,'602','2022-09-14 09:27:15','600','2022-09-14 16:29:33',10,0),('5','173',257886,'MORNING ','2022-09-14','2022-09-15 06:35:08','2022-09-16 06:35:08','602',147742.85,147742.85,'602','2022-09-15 08:32:55','600','2022-09-15 10:05:58',10,0),('5','173',257887,'MORNING ','2022-09-15','2022-09-16 06:12:36','2022-09-17 06:12:36','602',0.00,0.00,'602','2022-09-16 06:12:54','600','2022-09-16 10:19:43',10,0),('5','173',257888,'MORNING ','2022-09-16','2022-09-17 14:06:39','2022-09-18 14:06:39','602',0.00,0.00,'602','2022-09-17 14:06:52','600','2022-09-18 08:27:37',10,0),('5','173',257889,'MORNING ','2022-09-17','2022-09-18 15:37:22','2022-09-19 15:37:22','602',0.00,0.00,'602','2022-09-18 15:37:43','600','2022-09-19 08:04:47',10,0),('5','173',257890,'MORNING ','2022-09-18','2022-09-19 11:08:18','2022-09-20 11:08:18','602',138516.90,138516.90,'602','2022-09-19 11:10:56','600','2022-09-19 13:25:58',10,0),('5','173',257891,'MORNING ','2022-09-19','2022-09-20 07:22:25','2022-09-21 07:22:25','602',375884.85,375884.85,'602','2022-09-20 08:25:08','600','2022-09-20 11:21:19',10,0),('5','173',257892,'MORNING ','2022-09-20','2022-09-20 11:33:09','2022-09-21 11:33:09','602',222919.45,222919.45,'602','2022-09-21 12:31:49','600','2022-09-21 17:00:30',10,0),('5','173',257893,'MORNING ','2022-09-21','2022-09-22 07:36:42','2022-09-23 07:36:42','602',239044.05,239044.05,'602','2022-09-22 07:38:57','600','2022-09-22 08:45:17',10,0),('5','173',257894,'MORNING ','2022-09-22','2022-09-22 12:51:29','2022-09-23 12:51:29','602',244631.05,244631.05,'602','2022-09-23 12:15:15','600','2022-09-23 14:49:54',10,0),('5','173',257895,'MORNING ','2022-09-23','2022-09-24 07:43:43','2022-09-25 07:43:43','602',216958.75,216958.75,'602','2022-09-24 07:46:11','600','2022-09-24 09:56:11',10,0),('5','173',257896,'MORNING ','2022-09-24','2022-09-25 06:15:37','2022-09-26 06:15:37','602',224175.60,224175.60,'602','2022-09-25 06:16:55','600','2022-09-25 08:21:41',10,0),('5','173',257897,'MORNING ','2022-09-25','2022-09-25 14:18:36','2022-09-26 14:18:36','602',203714.60,203714.60,'602','2022-09-26 08:56:51','600','2022-09-26 09:46:06',10,0),('5','173',257898,'MORNING ','2022-09-26','2022-09-26 09:50:33','2022-09-27 09:50:33','602',208883.50,208883.50,'602','2022-09-27 07:31:12','600','2022-09-27 08:18:55',10,0),('5','173',257899,'MORNING ','2022-09-27','2022-09-27 11:06:30','2022-09-28 11:06:30','602',203897.75,203897.75,'602','2022-09-28 10:00:21','600','2022-09-28 10:04:46',10,0),('5','173',257900,'MORNING ','2022-09-28','2022-09-28 11:35:18','2022-09-29 11:35:18','602',246571.70,246571.70,'602','2022-09-29 07:19:54','600','2022-09-29 08:08:15',10,0),('5','173',257901,'MORNING ','2022-09-29','2022-09-30 02:45:08','2022-10-01 02:45:08','602',188762.90,188762.90,'602','2022-09-30 09:22:22','600','2022-10-01 10:26:52',10,0),('5','173',257902,'MORNING ','2022-09-30','2022-10-01 11:01:53','2022-10-02 11:01:53','602',203773.80,203773.80,'602','2022-10-01 11:03:44','600','2022-10-02 08:08:45',10,0),('5','173',257903,'MORNING ','2022-10-01','2022-10-02 18:37:39','2022-10-03 18:37:39','602',256091.80,256091.80,'602','2022-10-02 18:38:51','600','2022-10-03 05:59:07',10,0),('5','173',257904,'MORNING ','2022-10-02','2022-10-03 07:51:37','2022-10-04 07:51:37','602',230859.65,230859.65,'602','2022-10-03 07:54:19','600','2022-10-03 09:32:56',10,0),('5','173',257905,'MORNING ','2022-10-03','2022-10-03 19:11:38','2022-10-04 19:11:38','602',206445.20,206445.20,'602','2022-10-04 07:15:47','600','2022-10-04 09:09:01',10,0),('5','173',257906,'MORNING ','2022-10-04','2022-10-04 20:37:21','2022-10-05 20:37:21','602',199084.05,199084.05,'602','2022-10-05 07:58:26','600','2022-10-05 08:08:22',10,0),('5','173',257907,'MORNING ','2022-10-05','2022-10-06 06:48:35','2022-10-07 06:48:35','602',260491.10,260491.10,'602','2022-10-06 06:50:22','600','2022-10-06 08:06:16',10,0),('5','173',257908,'MORNING ','2022-10-06','2022-10-06 23:25:43','2022-10-07 23:25:43','602',659225.30,659225.30,'602','2022-10-06 23:27:16','600','2022-10-08 08:15:06',10,0),('5','173',257909,'MORNING ','2022-10-07','2022-10-08 13:55:10','2022-10-09 13:55:10','602',901912.00,906787.20,'602','2022-10-08 14:00:31','600','2022-10-08 18:52:18',10,0),('5','173',257910,'MORNING ','2022-10-08','2022-10-08 18:54:27','2022-10-09 18:54:27','602',1580360.65,1580360.65,'602','2022-10-09 16:53:05','600','2022-10-09 17:19:08',10,0),('5','173',257911,'MORNING ','2022-10-09','2022-10-09 17:38:18','2022-10-10 17:38:18','602',1203141.95,1203141.95,'602','2022-10-10 13:18:26','600','2022-10-10 17:04:03',10,0),('5','173',257912,'MORNING ','2022-10-10','2022-10-10 19:43:26','2022-10-11 19:43:26','602',1740276.50,1740276.50,'602','2022-10-11 09:29:44','600','2022-10-12 09:01:10',10,0),('5','173',257913,'MORNING ','2022-10-11','2022-10-12 10:21:21','2022-10-13 10:21:21','602',904115.35,904115.35,'602','2022-10-12 16:34:16','600','2022-10-12 16:52:15',10,0),('5','173',257914,'MORNING ','2022-10-12','2022-10-13 09:22:05','2022-10-14 09:22:05','602',746378.80,746378.80,'602','2022-10-13 10:00:50','600','2022-10-14 08:15:39',10,0),('5','173',257915,'MORNING ','2022-10-13','2022-10-14 10:58:49','2022-10-15 10:58:49','602',1215126.25,1215126.25,'602','2022-10-14 11:03:02','600','2022-10-14 14:23:21',10,0),('5','173',257916,'MORNING ','2022-10-14','2022-10-15 12:09:29','2022-10-16 12:09:29','602',638967.80,638967.80,'602','2022-10-15 12:11:50','600','2022-10-16 10:00:41',10,0),('5','173',257917,'MORNING ','2022-10-15','2022-10-16 17:18:13','2022-10-17 17:18:13','602',866932.20,866932.20,'602','2022-10-16 17:21:20','600','2022-10-17 08:10:15',10,0),('5','173',257918,'MORNING ','2022-10-16','2022-10-17 09:53:25','2022-10-18 09:53:25','602',494697.40,494697.40,'602','2022-10-17 09:57:06','600','2022-10-17 11:29:59',10,0),('5','173',257919,'MORNING ','2022-10-17','2022-10-18 07:30:57','2022-10-19 07:30:57','602',537217.80,537217.80,'602','2022-10-18 10:21:51','600','2022-10-18 21:32:30',10,0),('5','173',257920,'MORNING ','2022-10-18','2022-10-19 06:26:58','2022-10-20 06:26:58','602',426600.75,426600.75,'602','2022-10-19 08:15:43','600','2022-10-19 08:18:13',10,0),('5','173',257921,'MORNING ','2022-10-19','2022-10-19 14:06:39','2022-10-20 14:06:39','602',618492.00,618492.00,'602','2022-10-20 09:24:39','600','2022-10-21 06:02:32',10,0),('5','173',257922,'MORNING ','2022-10-20','2022-10-21 17:47:37','2022-10-22 17:47:37','602',0.00,0.00,'602','2022-10-21 17:47:50','600','2022-10-21 20:56:55',10,0),('5','173',257923,'MORNING ','2022-10-21','2022-10-22 08:52:00','2022-10-23 08:52:00','602',0.00,0.00,'602','2022-10-22 18:44:45','600','2022-10-23 05:56:17',10,0),('5','173',257924,'MORNING ','2022-10-22','2022-10-23 08:49:46','2022-10-24 08:49:46','602',0.00,0.00,'602','2022-10-23 08:50:02','600','2022-10-24 06:04:47',10,0),('5','173',257925,'MORNING ','2022-10-23','2022-10-24 07:35:10','2022-10-25 07:35:10','602',0.00,0.00,'602','2022-10-24 07:36:10','600','2022-10-25 05:58:43',10,0),('5','173',257926,'MORNING ','2022-10-24','2022-10-25 11:25:48','2022-10-26 11:25:48','602',0.00,0.00,'602','2022-10-25 11:26:05','600','2022-10-26 06:04:33',10,0),('5','173',257927,'MORNING ','2022-10-25','2022-10-26 08:50:36','2022-10-27 08:50:36','602',0.00,0.00,'602','2022-10-26 08:50:51','600','2022-10-27 05:55:50',10,0),('5','173',257928,'MORNING ','2022-10-26','2022-10-27 12:14:53','2022-10-28 12:14:53','602',0.00,0.00,'602','2022-10-27 12:15:07','600','2022-10-27 18:40:20',10,0),('5','173',257929,'MORNING ','2022-10-27','2022-10-28 06:14:50','2022-10-29 06:14:50','602',0.00,0.00,'602','2022-10-28 06:15:05','600','2022-10-28 08:06:08',10,0),('5','173',257930,'MORNING ','2022-10-28','2022-10-28 09:36:52','2022-10-29 09:36:52','602',0.00,0.00,'602','2022-10-28 21:09:12','600','2022-10-29 09:40:28',10,0),('5','173',257931,'MORNING ','2022-10-29','2022-10-29 13:55:21','2022-10-30 13:55:21','602',0.00,0.00,'602','2022-10-29 17:49:01','600','2022-10-30 05:52:42',10,0),('5','173',257932,'MORNING ','2022-10-30','2022-10-30 15:42:15','2022-10-31 15:42:15','602',0.00,0.00,'602','2022-10-31 10:07:08','600','2022-10-31 10:15:32',10,0),('5','173',257933,'MORNING ','2022-10-31','2022-10-31 18:23:18','2022-11-01 18:23:18','602',0.00,0.00,'602','2022-10-31 18:23:34','600','2022-11-01 05:57:26',10,0),('5','173',257934,'MORNING ','2022-11-01','2022-11-01 09:56:07','2022-11-02 09:56:07','602',0.00,0.00,'602','2022-11-02 06:22:12','600','2022-11-02 08:34:42',10,0),('5','173',257935,'MORNING ','2022-11-02','2022-11-03 00:48:12','2022-11-04 00:48:12','602',598332.55,598332.55,'602','2022-11-03 13:23:26','600','2022-11-03 16:38:42',10,0),('5','173',257936,'MORNING ','2022-11-03','2022-11-03 17:20:46','2022-11-04 17:20:46','602',1184738.15,1184738.15,'602','2022-11-04 16:02:28','600','2022-11-05 09:02:47',10,0),('5','173',257937,'MORNING ','2022-11-04','2022-11-05 09:37:03','2022-11-06 09:37:03','602',1260271.80,1260271.80,'602','2022-11-05 09:40:11','600','2022-11-05 09:42:27',10,0),('5','173',257938,'MORNING ','2022-11-05','2022-11-05 09:43:35','2022-11-06 09:43:35','602',1055077.20,1055077.20,'602','2022-11-06 08:09:37','600','2022-11-06 09:18:58',10,0),('5','173',257939,'MORNING ','2022-11-06','2022-11-07 06:32:18','2022-11-08 06:32:18','602',999192.40,999192.40,'602','2022-11-07 07:19:15','600','2022-11-07 09:14:26',10,0),('5','173',257940,'MORNING ','2022-11-07','2022-11-08 07:13:51','2022-11-09 07:13:51','602',945103.95,945103.95,'602','2022-11-08 07:20:41','600','2022-11-08 08:19:35',10,0),('5','173',257941,'MORNING ','2022-11-08','2022-11-08 09:35:34','2022-11-09 09:35:34','602',756810.95,756810.95,'602','2022-11-09 07:39:44','600','2022-11-09 08:17:55',10,0),('5','173',257942,'MORNING ','2022-11-09','2022-11-09 10:03:39','2022-11-10 10:03:39','602',944369.50,944369.50,'602','2022-11-10 07:07:37','600','2022-11-10 09:31:32',10,0),('5','173',257943,'MORNING ','2022-11-10','2022-11-10 11:41:49','2022-11-11 11:41:49','602',525603.50,525603.50,'602','2022-11-11 12:05:14','600','2022-11-11 13:27:10',10,0),('5','173',257944,'MORNING ','2022-11-11','2022-11-11 19:27:51','2022-11-12 19:27:51','602',0.00,0.00,'602','2022-11-11 19:28:07','600','2022-11-12 09:32:20',10,0),('5','173',257945,'MORNING ','2022-11-12','2022-11-12 14:19:30','2022-11-13 14:19:30','602',0.00,0.00,'602','2022-11-13 07:08:47','600','2022-11-13 08:44:59',10,0),('5','173',257946,'MORNING ','2022-11-13','2022-11-13 17:13:32','2022-11-14 17:13:32','602',0.00,0.00,'602','2022-11-13 18:53:18','600','2022-11-14 08:10:27',10,0),('5','173',257947,'MORNING ','2022-11-13','2022-11-15 07:11:30','2022-11-16 07:11:30','602',0.00,0.00,'602','2022-11-15 07:11:49','600','2022-11-15 08:30:52',10,0),('5','173',257948,'MORNING ','2022-11-15','2022-11-15 18:22:23','2022-11-16 18:22:23','602',0.00,0.00,'602','2022-11-15 18:22:49','600','2022-11-16 09:40:23',10,0),('5','173',257949,'MORNING ','2022-11-16','2022-11-16 10:08:37','2022-11-17 10:08:37','602',0.00,0.00,'602','2022-11-16 21:57:48','600','2022-11-17 10:01:23',10,0),('5','173',257950,'MORNING ','2022-11-17','2022-11-17 13:57:32','2022-11-18 13:57:32','602',0.00,0.00,'602','2022-11-17 19:05:45','600','2022-11-18 08:38:52',10,0),('5','173',257951,'MORNING ','2022-11-18','2022-11-18 17:26:13','2022-11-19 17:26:13','602',0.00,0.00,'602','2022-11-18 21:38:12','600','2022-11-19 09:16:49',10,0),('5','173',257952,'MORNING ','2022-11-19','2022-11-19 18:56:40','2022-11-20 18:56:40','602',0.00,0.00,'602','2022-11-19 18:56:56','600','2022-11-20 10:34:38',10,0),('5','173',257953,'MORNING ','2022-11-20','2022-11-20 13:58:41','2022-11-21 13:58:41','602',0.00,0.00,'602','2022-11-20 18:30:40','600','2022-11-21 06:08:51',10,0),('5','173',257954,'MORNING ','2022-11-21','2022-11-21 17:39:19','2022-11-22 17:39:19','602',0.00,0.00,'602','2022-11-21 17:39:37','600','2022-11-22 08:15:32',10,0),('5','173',257955,'MORNING ','2022-11-22','2022-11-22 18:05:44','2022-11-23 18:05:44','602',0.00,0.00,'602','2022-11-22 18:06:01','600','2022-11-23 06:15:01',10,0),('5','173',257956,'MORNING ','2022-11-23','2022-11-23 09:51:29','2022-11-24 09:51:29','602',0.00,0.00,'602','2022-11-24 07:09:22','600','2022-11-24 08:52:14',10,0),('5','173',257957,'Daily ','2022-11-24','2022-11-24 10:20:09','2022-11-25 10:20:09','600',0.00,0.00,'602','2022-11-24 22:00:19','600','2022-11-25 06:11:17',10,0),('5','173',257958,'MORNING ','2022-11-25','2022-11-25 18:30:30','2022-11-26 18:30:30','602',0.00,0.00,'602','2022-11-25 18:30:51','600','2022-11-26 09:26:17',10,0),('5','173',257959,'MORNING ','2022-11-26','2022-11-26 19:22:36','2022-11-27 19:22:36','602',0.00,0.00,'602','2022-11-26 19:23:05','600','2022-11-27 09:32:12',10,0),('5','173',257960,'MORNING ','2022-11-27','2022-11-27 17:13:49','2022-11-28 17:13:49','602',0.00,0.00,'602','2022-11-27 17:14:31','600','2022-11-28 06:13:30',10,0),('5','173',257961,'MORNING ','2022-11-28','2022-11-28 19:35:04','2022-11-29 19:35:04','602',0.00,0.00,'602','2022-11-28 19:35:21','600','2022-11-29 06:05:14',10,0),('5','173',257962,'MORNING ','2022-11-29','2022-11-29 18:03:48','2022-11-30 18:03:48','602',0.00,0.00,'602','2022-11-29 18:04:14','600','2022-11-30 06:22:28',10,0),('5','173',257963,'MORNING ','2022-11-30','2022-11-30 14:47:22','2022-12-01 14:47:22','602',0.00,0.00,'602','2022-11-30 18:08:19','600','2022-12-01 06:07:39',10,0),('5','173',257964,'MORNING ','2022-12-01','2022-12-02 02:55:28','2022-12-03 02:55:28','602',0.00,0.00,'602','2022-12-02 02:55:51','600','2022-12-02 06:15:29',10,0),('5','173',257965,'MORNING ','2022-12-02','2022-12-02 23:53:53','2022-12-03 23:53:53','602',0.00,0.00,'602','2022-12-02 23:54:17','600','2022-12-03 10:16:28',10,0),('5','173',257966,'MORNING ','2022-12-03','2022-12-04 01:02:18','2022-12-05 01:02:18','602',0.00,0.00,'602','2022-12-04 01:02:53','600','2022-12-04 09:08:45',10,0),('5','173',257967,'MORNING','2022-12-04','2022-12-05 05:09:41','2022-12-06 05:09:41','602',0.00,0.00,'602','2022-12-05 05:10:09','600','2022-12-05 06:09:31',10,0),('5','173',257968,'MORNING ','2022-12-05','2022-12-06 08:46:37','2022-12-07 08:46:37','602',0.00,0.00,'602','2022-12-06 08:47:26','600','2022-12-06 08:52:09',10,0),('5','173',257969,'MORNING ','2022-12-06','2022-12-06 19:59:27','2022-12-07 19:59:27','602',0.00,0.00,'602','2022-12-06 19:59:50','600','2022-12-07 06:16:34',10,0),('5','173',257970,'MORNING ','2022-12-07','2022-12-09 04:49:59','2022-12-10 04:49:59','602',0.00,0.00,'602','2022-12-09 04:50:30','600','2022-12-09 06:09:15',10,0),('5','173',257971,'MORNING ','2022-12-08','2022-12-10 21:55:23','2022-12-11 21:55:23','602',0.00,0.00,'602','2022-12-10 21:56:10','600','2022-12-11 09:19:43',10,0),('5','173',257972,'MORNING ','2022-12-09','2022-12-12 09:12:07','2022-12-13 09:12:07','602',0.00,0.00,'602','2022-12-12 09:12:31','600','2022-12-12 14:18:49',10,0),('5','173',257973,'MORNING ','2022-12-10','2022-12-13 22:37:26','2022-12-14 22:37:26','602',0.00,0.00,'602','2022-12-13 22:37:52','600','2022-12-14 09:46:05',10,0),('5','173',257974,'MORNING ','2022-12-11','2022-12-15 10:03:18','2022-12-16 10:03:18','602',0.00,0.00,'602','2022-12-15 10:03:36','795','2022-12-15 19:41:22',10,0),('5','173',257975,'MORNING ','2022-12-12','2022-12-16 13:23:15','2022-12-17 13:23:15','602',0.00,0.00,'602','2022-12-16 13:23:36','795','2023-03-09 20:31:26',10,0),('5','173',257976,'Daily shift','2023-03-06','2023-03-10 14:11:53','2023-03-11 14:11:53','602',1395044.70,1395044.70,'602','2023-03-10 14:13:52','795','2023-03-10 14:16:41',10,0),('5','173',257977,'Daily shift','2023-03-07','2023-03-10 14:52:37','2023-03-11 14:52:37','602',1832775.00,1832775.00,'602','2023-03-10 14:53:26','795','2023-03-10 14:56:15',10,0),('5','173',257978,'Daily shift','2023-03-08','2023-03-10 14:57:26','2023-03-11 14:57:26','602',1768118.10,1768118.10,'602','2023-03-10 14:58:16','795','2023-03-10 15:13:09',10,0),('5','173',257979,'Daily shift','2023-03-09','2023-03-10 15:16:37','2023-03-11 15:16:37','602',2240143.50,2240143.50,'602','2023-03-11 14:41:14','795','2023-03-11 16:05:13',10,0),('5','173',257980,'Daily shift','2023-03-10','2023-03-11 16:06:56','2023-03-12 16:06:56','602',1655721.90,1655721.90,'602','2023-03-11 16:08:03','795','2023-03-11 16:33:20',10,0),('5','173',257981,'Daily shift','2023-03-11','2023-03-12 12:35:12','2023-03-13 12:35:12','602',1503392.10,1503392.10,'602','2023-03-12 12:36:19','795','2023-03-12 16:53:04',10,0),('5','173',257982,'Daily shift','2023-03-12','2023-03-15 12:17:50','2023-03-16 12:17:50','602',0.00,0.00,'602','2023-03-15 12:18:15','795','2023-03-15 12:20:08',10,0),('5','173',257983,'Daily shift','2023-03-13','2023-03-15 12:28:46','2023-03-16 12:28:46','602',0.00,0.00,'602','2023-03-15 12:29:06','795','2023-03-15 12:31:02',10,0),('5','173',257984,'Daily shift','2023-03-14','2023-03-15 12:32:04','2023-03-16 12:32:04','602',0.00,0.00,'602','2023-03-15 12:33:21','795','2023-03-15 12:49:51',10,0),('5','173',257985,'Daily shift','2023-03-15','2023-03-17 06:46:23','2023-03-18 06:46:23','602',0.00,0.00,'602','2023-03-17 06:46:43','795','2023-03-18 00:03:58',10,0),('5','173',257986,'Daily shift','2023-03-16','2023-03-19 10:07:49','2023-03-20 10:07:49','602',0.00,0.00,'602','2023-03-20 06:02:58','795','2023-03-20 08:47:22',10,0),('5','173',257987,'Daily shift','2023-03-17','2023-03-20 20:10:02','2023-03-21 20:10:02','602',0.00,0.00,'602','2023-03-20 20:10:20','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908660 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','173','904','182030',3573972,'2683','400',210733.49,212095.37,1361.88,221986.44,0.00,0.00,0.00,0.00,0.00),('5','173','904','182030',3573973,'2684','400',164030.99,164912.11,881.12,143622.56,0.00,0.00,0.00,0.00,0.00),('5','173','905','182030',3573974,'2685','400',63310.24,63310.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','182030',3573975,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','182030',3573976,'2687','401',36481.45,36592.45,111.00,27750.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','182030',3573977,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184618',3620967,'2683','400',212095.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184618',3620968,'2684','400',164912.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184618',3620969,'2685','400',63310.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184618',3620970,'2686','400',79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184618',3620971,'2687','401',36592.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184618',3620972,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184629',3621208,'2683','400',212095.37,212095.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184629',3621209,'2684','400',164912.11,164912.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184629',3621210,'2685','400',63310.24,63310.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184629',3621211,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184629',3621212,'2687','401',36592.45,38489.24,1896.79,474197.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','184629',3621213,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184634',3621265,'2683','400',212095.37,212095.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184634',3621266,'2684','400',164912.11,164912.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184634',3621267,'2685','400',63310.24,63310.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184634',3621268,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184634',3621269,'2687','401',38489.24,38566.24,77.00,19250.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184634',3621270,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184635',3621271,'2683','400',212095.37,212713.51,618.14,100756.82,0.00,0.00,0.00,0.00,0.00),('5','173','904','184635',3621272,'2684','400',164912.11,165567.62,655.51,106848.13,0.00,0.00,0.00,0.00,0.00),('5','173','905','184635',3621273,'2685','400',63310.24,63310.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184635',3621274,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184635',3621275,'2687','401',38566.24,38727.16,160.92,40230.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184635',3621276,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184745',3623117,'2683','400',212713.51,214415.19,1701.68,277373.84,0.00,0.00,0.00,0.00,0.00),('5','173','904','184745',3623118,'2684','400',165567.62,167419.35,1851.73,301831.99,0.00,0.00,0.00,0.00,0.00),('5','173','905','184745',3623119,'2685','400',63310.24,63895.59,585.35,95412.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','184745',3623120,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184745',3623121,'2687','401',38727.16,38868.97,141.81,35452.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','184745',3623122,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184749',3623183,'2683','400',214415.19,216645.83,2230.64,363594.32,0.00,0.00,0.00,0.00,0.00),('5','173','904','184749',3623184,'2684','400',167419.35,169875.86,2456.51,400411.13,0.00,0.00,0.00,0.00,0.00),('5','173','905','184749',3623185,'2685','400',63895.59,63895.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184749',3623186,'2686','400',79474.04,79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184749',3623187,'2687','401',38868.97,38960.73,91.76,22940.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184749',3623188,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184756',3623291,'2683','400',216645.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184756',3623292,'2684','400',169875.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184756',3623293,'2685','400',63895.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184756',3623294,'2686','400',79474.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184756',3623295,'2687','401',38960.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184756',3623296,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184778',3623801,'2683','400',216645.83,220430.84,3785.01,616956.63,0.00,0.00,0.00,0.00,0.00),('5','173','904','184778',3623802,'2684','400',169875.86,172598.42,2722.56,443777.28,0.00,0.00,0.00,0.00,0.00),('5','173','905','184778',3623803,'2685','400',63895.59,64848.43,952.84,155312.92,0.00,0.00,0.00,0.00,0.00),('5','173','905','184778',3623804,'2686','400',79474.04,79694.31,220.27,35904.01,0.00,0.00,0.00,0.00,0.00),('5','173','906','184778',3623805,'2687','401',37794.72,39331.72,1537.00,384250.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184778',3623806,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184950',3626771,'2683','400',220430.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184950',3626772,'2684','400',172598.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184950',3626773,'2685','400',64848.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','184950',3626774,'2686','400',79694.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','184950',3626775,'2687','401',39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184950',3626776,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184958',3626984,'2683','400',220430.84,221697.58,1266.74,206478.62,0.00,0.00,0.00,0.00,0.00),('5','173','904','184958',3626985,'2684','400',172598.42,173592.34,993.92,162008.96,0.00,0.00,0.00,0.00,0.00),('5','173','905','184958',3626986,'2685','400',64848.43,66447.70,1599.27,260681.01,0.00,0.00,0.00,0.00,0.00),('5','173','905','184958',3626987,'2686','400',79694.31,81243.05,1548.74,252444.62,0.00,0.00,0.00,0.00,0.00),('5','173','906','184958',3626988,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184958',3626989,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184969',3627176,'2683','400',221697.58,221697.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184969',3627177,'2684','400',173592.34,176513.30,2920.96,476116.48,0.00,0.00,0.00,0.00,0.00),('5','173','905','184969',3627178,'2685','400',66447.70,67900.37,1452.67,236785.21,0.00,0.00,0.00,0.00,0.00),('5','173','905','184969',3627179,'2686','400',81243.05,82938.47,1695.42,276353.46,0.00,0.00,0.00,0.00,0.00),('5','173','906','184969',3627180,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184969',3627181,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184987',3627426,'2683','400',221697.58,223988.58,2291.00,373433.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','184987',3627427,'2684','400',176513.30,179229.96,2716.66,442815.58,0.00,0.00,0.00,0.00,0.00),('5','173','905','184987',3627428,'2685','400',67900.37,69905.51,2005.14,326837.82,0.00,0.00,0.00,0.00,0.00),('5','173','905','184987',3627429,'2686','400',82938.47,83968.20,1029.73,167845.99,0.00,0.00,0.00,0.00,0.00),('5','173','906','184987',3627430,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','184987',3627431,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','185016',3627863,'2683','400',223988.58,228626.00,4637.42,755899.46,0.00,0.00,0.00,0.00,0.00),('5','173','904','185016',3627864,'2684','400',179229.96,181790.54,2560.58,417374.54,0.00,0.00,0.00,0.00,0.00),('5','173','905','185016',3627865,'2685','400',69905.51,74316.81,4411.30,719041.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','185016',3627866,'2686','400',83968.20,84968.20,1000.00,163000.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','185016',3627867,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','185016',3627868,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','185022',3627997,'2683','400',228626.00,233719.01,5093.01,830160.63,0.00,0.00,0.00,0.00,0.00),('5','173','904','185022',3627998,'2684','400',181790.54,184840.37,3049.83,497122.29,0.00,0.00,0.00,0.00,0.00),('5','173','905','185022',3627999,'2685','400',74316.81,79640.84,5324.03,867816.89,0.00,0.00,0.00,0.00,0.00),('5','173','905','185022',3628000,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','185022',3628001,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','185022',3628002,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186012',3645582,'2683','400',233719.01,235410.26,1691.25,275673.75,0.00,0.00,0.00,0.00,0.00),('5','173','904','186012',3645583,'2684','400',184840.37,186417.25,1576.88,257031.44,0.00,0.00,0.00,0.00,0.00),('5','173','905','186012',3645584,'2685','400',79640.84,84542.52,4901.68,798973.84,0.00,0.00,0.00,0.00,0.00),('5','173','905','186012',3645585,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186012',3645586,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186012',3645587,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186014',3645596,'2683','400',235410.26,235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186014',3645597,'2684','400',186417.25,186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186014',3645598,'2685','400',84542.52,92875.66,8333.14,1358301.82,0.00,0.00,0.00,0.00,0.00),('5','173','905','186014',3645599,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186014',3645600,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186014',3645601,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186016',3645619,'2683','400',235410.26,235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186016',3645620,'2684','400',186417.25,186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186016',3645621,'2685','400',92875.66,97875.66,5000.00,815000.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186016',3645622,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186016',3645623,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186016',3645624,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186024',3645756,'2683','400',235410.26,235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186024',3645757,'2684','400',186417.25,186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186024',3645758,'2685','400',97875.66,99675.66,1800.00,293400.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186024',3645759,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186024',3645760,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186024',3645761,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186026',3645778,'2683','400',235410.26,235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186026',3645779,'2684','400',186417.25,186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186026',3645780,'2685','400',99675.66,100675.66,1000.00,163000.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186026',3645781,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186026',3645782,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186026',3645783,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186028',3645800,'2683','400',235410.26,235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186028',3645801,'2684','400',186417.25,186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186028',3645802,'2685','400',100675.66,102619.12,1943.46,316783.98,0.00,0.00,0.00,0.00,0.00),('5','173','905','186028',3645803,'2686','400',84968.20,84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186028',3645804,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186028',3645805,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186115',3647329,'2683','400',235410.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186115',3647330,'2684','400',186417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186115',3647331,'2685','400',102619.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186115',3647332,'2686','400',84968.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186115',3647333,'2687','401',39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186115',3647334,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186124',3647453,'2683','400',235410.26,237552.23,2141.97,349141.11,0.00,0.00,0.00,0.00,0.00),('5','173','904','186124',3647454,'2684','400',186417.25,189812.14,3394.89,553367.07,0.00,0.00,0.00,0.00,0.00),('5','173','905','186124',3647455,'2685','400',102619.12,106585.27,3966.15,646482.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','186124',3647456,'2686','400',84968.20,85490.54,522.34,85141.42,0.00,0.00,0.00,0.00,0.00),('5','173','906','186124',3647457,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186124',3647458,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186128',3647515,'2683','400',237552.23,240508.25,2956.02,481831.26,0.00,0.00,0.00,0.00,0.00),('5','173','904','186128',3647516,'2684','400',189812.14,192742.21,2930.07,477601.41,0.00,0.00,0.00,0.00,0.00),('5','173','905','186128',3647517,'2685','400',106585.27,108678.80,2093.53,341245.39,0.00,0.00,0.00,0.00,0.00),('5','173','905','186128',3647518,'2686','400',85490.54,85490.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186128',3647519,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186128',3647520,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186131',3647547,'2683','400',240508.25,243586.94,3078.69,501826.47,0.00,0.00,0.00,0.00,0.00),('5','173','904','186131',3647548,'2684','400',192742.21,196227.77,3485.56,568146.28,0.00,0.00,0.00,0.00,0.00),('5','173','905','186131',3647549,'2685','400',108678.80,108678.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186131',3647550,'2686','400',85490.54,87479.43,1988.89,324189.07,0.00,0.00,0.00,0.00,0.00),('5','173','906','186131',3647551,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186131',3647552,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186349',3651110,'2683','400',243586.94,246477.53,2890.59,471166.17,0.00,0.00,0.00,0.00,0.00),('5','173','904','186349',3651111,'2684','400',196227.77,198487.82,2260.05,368388.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','186349',3651112,'2685','400',108678.80,110803.39,2124.59,346308.17,0.00,0.00,0.00,0.00,0.00),('5','173','905','186349',3651113,'2686','400',87479.43,88299.94,820.51,133743.13,0.00,0.00,0.00,0.00,0.00),('5','173','906','186349',3651114,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186349',3651115,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186670',3656746,'2683','400',246477.53,250556.52,4078.99,664875.37,0.00,0.00,0.00,0.00,0.00),('5','173','904','186670',3656747,'2684','400',198487.82,201954.96,3467.14,565143.82,0.00,0.00,0.00,0.00,0.00),('5','173','905','186670',3656748,'2685','400',110803.39,111391.19,587.80,95811.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','186670',3656749,'2686','400',88299.94,88299.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','186670',3656750,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186670',3656751,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186913',3660875,'2683','400',250556.52,254229.43,3672.91,598684.33,0.00,0.00,0.00,0.00,0.00),('5','173','904','186913',3660876,'2684','400',201954.96,202090.20,135.24,22044.12,0.00,0.00,0.00,0.00,0.00),('5','173','905','186913',3660877,'2685','400',111391.19,114175.74,2784.55,453881.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','186913',3660878,'2686','400',88299.94,88663.97,364.03,59336.89,0.00,0.00,0.00,0.00,0.00),('5','173','906','186913',3660879,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186913',3660880,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','186968',3661781,'2683','400',254229.43,258968.54,4739.11,772474.93,0.00,0.00,0.00,0.00,0.00),('5','173','904','186968',3661782,'2684','400',202090.20,202090.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','186968',3661783,'2685','400',114175.74,115078.45,902.71,147141.73,0.00,0.00,0.00,0.00,0.00),('5','173','905','186968',3661784,'2686','400',88663.97,89369.56,705.59,115011.17,0.00,0.00,0.00,0.00,0.00),('5','173','906','186968',3661785,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','186968',3661786,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','187227',3666144,'2683','400',258968.54,259581.12,612.58,99850.54,0.00,0.00,0.00,0.00,0.00),('5','173','904','187227',3666145,'2684','400',202090.20,202804.22,714.02,116385.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','187227',3666146,'2685','400',115078.45,118363.47,3285.02,535458.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','187227',3666147,'2686','400',89369.56,92079.51,2709.95,441721.85,0.00,0.00,0.00,0.00,0.00),('5','173','906','187227',3666148,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','187227',3666149,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','187326',3668134,'2683','400',259581.12,263342.38,3761.26,613085.38,0.00,0.00,0.00,0.00,0.00),('5','173','904','187326',3668135,'2684','400',202804.22,202804.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','187326',3668136,'2685','400',118363.47,119835.04,1471.57,239865.91,0.00,0.00,0.00,0.00,0.00),('5','173','905','187326',3668137,'2686','400',92079.51,94874.90,2795.39,455648.57,0.00,0.00,0.00,0.00,0.00),('5','173','906','187326',3668138,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','187326',3668139,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','187510',3671315,'2683','400',263342.38,266858.16,3515.78,573072.14,0.00,0.00,0.00,0.00,0.00),('5','173','904','187510',3671316,'2684','400',202804.22,202804.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','187510',3671317,'2685','400',119835.04,122025.06,2190.02,356973.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','187510',3671318,'2686','400',94874.90,96456.89,1581.99,257864.37,0.00,0.00,0.00,0.00,0.00),('5','173','906','187510',3671319,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','187510',3671320,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','187773',3676092,'2683','400',266858.16,270001.45,3143.29,512356.27,0.00,0.00,0.00,0.00,0.00),('5','173','904','187773',3676093,'2684','400',202804.22,202804.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','187773',3676094,'2685','400',122025.06,124654.74,2629.68,428637.84,0.00,0.00,0.00,0.00,0.00),('5','173','905','187773',3676095,'2686','400',96456.89,96456.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','187773',3676096,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','187773',3676097,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','187916',3678484,'2683','400',270001.45,273468.46,3467.01,565122.63,0.00,0.00,0.00,0.00,0.00),('5','173','904','187916',3678485,'2684','400',202804.22,202804.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','187916',3678486,'2685','400',124654.74,127652.18,2997.44,488582.72,0.00,0.00,0.00,0.00,0.00),('5','173','905','187916',3678487,'2686','400',96456.89,96456.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','187916',3678488,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','187916',3678489,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188002',3680070,'2683','400',273468.46,275617.79,2149.33,350340.79,0.00,0.00,0.00,0.00,0.00),('5','173','904','188002',3680071,'2684','400',202804.22,204453.60,1649.38,268848.94,0.00,0.00,0.00,0.00,0.00),('5','173','905','188002',3680072,'2685','400',127652.18,131012.58,3360.40,547745.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','188002',3680073,'2686','400',96456.89,97847.69,1390.80,226700.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','188002',3680074,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','188002',3680075,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188231',3683852,'2683','400',275617.79,279941.00,4323.21,704683.23,0.00,0.00,0.00,0.00,0.00),('5','173','904','188231',3683853,'2684','400',204453.60,204453.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','188231',3683854,'2685','400',131012.58,133519.86,2507.28,408686.64,0.00,0.00,0.00,0.00,0.00),('5','173','905','188231',3683855,'2686','400',97847.69,100269.04,2421.35,394680.05,0.00,0.00,0.00,0.00,0.00),('5','173','906','188231',3683856,'2687','401',39331.72,39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','188231',3683857,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188435',3687311,'2683','400',279941.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188435',3687312,'2684','400',204453.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','188435',3687313,'2685','400',133519.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','188435',3687314,'2686','400',100269.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','188435',3687315,'2687','401',39331.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','188435',3687316,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188649',3691022,'2683','400',279941.00,283009.40,3068.40,500149.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','188649',3691023,'2684','400',204453.60,204453.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','188649',3691024,'2685','400',133519.86,136993.79,3473.93,566250.59,0.00,0.00,0.00,0.00,0.00),('5','173','905','188649',3691025,'2686','400',100269.04,103739.01,3469.97,565605.11,0.00,0.00,0.00,0.00,0.00),('5','173','906','188649',3691026,'2687','401',39331.72,40772.18,1440.46,381721.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','188649',3691027,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188726',3692442,'2683','400',283009.40,287615.98,4606.58,750872.54,0.00,0.00,0.00,0.00,0.00),('5','173','904','188726',3692443,'2684','400',204453.60,205721.51,1267.91,206669.33,0.00,0.00,0.00,0.00,0.00),('5','173','905','188726',3692444,'2685','400',136993.79,138720.25,1726.46,281412.98,0.00,0.00,0.00,0.00,0.00),('5','173','905','188726',3692445,'2686','400',103739.01,103808.89,69.88,11390.44,0.00,0.00,0.00,0.00,0.00),('5','173','906','188726',3692446,'2687','401',40772.18,41410.80,638.62,169234.30,0.00,0.00,0.00,0.00,0.00),('5','173','907','188726',3692447,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','188828',3694213,'2683','400',287615.98,290322.72,2706.74,441198.62,0.00,0.00,0.00,0.00,0.00),('5','173','904','188828',3694214,'2684','400',205721.51,207368.72,1647.21,268495.23,0.00,0.00,0.00,0.00,0.00),('5','173','905','188828',3694215,'2685','400',138720.25,138742.72,22.47,3662.61,0.00,0.00,0.00,0.00,0.00),('5','173','905','188828',3694216,'2686','400',103808.89,105000.41,1191.52,194217.76,0.00,0.00,0.00,0.00,0.00),('5','173','906','188828',3694217,'2687','401',41410.80,41578.28,167.48,44382.20,0.00,0.00,0.00,0.00,0.00),('5','173','907','188828',3694218,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189075',3698727,'2683','400',290322.72,294763.72,4441.00,723883.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189075',3698728,'2684','400',207368.72,207556.09,187.37,30541.31,0.00,0.00,0.00,0.00,0.00),('5','173','905','189075',3698729,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189075',3698730,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','189075',3698731,'2687','401',41578.28,41728.16,149.88,39718.20,0.00,0.00,0.00,0.00,0.00),('5','173','907','189075',3698732,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189262',3702063,'2683','400',294763.72,298263.72,3500.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189262',3702064,'2684','400',207556.09,207710.68,154.59,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189262',3702065,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189262',3702066,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','189262',3702067,'2687','401',41728.16,42170.11,441.95,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','189262',3702068,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189565',3707638,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189565',3707639,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189565',3707640,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189565',3707641,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','189565',3707642,'2687','401',42170.11,42370.97,200.86,53227.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','189565',3707643,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189697',3709684,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189697',3709685,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189697',3709686,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189697',3709687,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','189697',3709688,'2687','401',42370.97,43132.97,762.00,201930.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','189697',3709689,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189856',3712496,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','189856',3712497,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189856',3712498,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','189856',3712499,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','189856',3712500,'2687','401',43132.97,43307.15,174.18,46157.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','189856',3712501,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190153',3718530,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190153',3718531,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190153',3718532,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190153',3718533,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','190153',3718534,'2687','401',43307.15,43577.58,270.43,71663.95,0.00,0.00,0.00,0.00,0.00),('5','173','907','190153',3718535,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190277',3720660,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190277',3720661,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190277',3720662,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190277',3720663,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','190277',3720664,'2687','401',43577.58,43731.41,153.83,40764.95,0.00,0.00,0.00,0.00,0.00),('5','173','907','190277',3720665,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190453',3723980,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190453',3723981,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190453',3723982,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190453',3723983,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','190453',3723984,'2687','401',43731.41,43857.44,126.03,33397.95,0.00,0.00,0.00,0.00,0.00),('5','173','907','190453',3723985,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190700',3728611,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190700',3728612,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190700',3728613,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190700',3728614,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','190700',3728615,'2687','401',43857.44,44023.03,165.59,43881.35,0.00,0.00,0.00,0.00,0.00),('5','173','907','190700',3728616,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190969',3733461,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','190969',3733462,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190969',3733463,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','190969',3733464,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','190969',3733465,'2687','401',44023.03,44170.24,147.21,39010.65,0.00,0.00,0.00,0.00,0.00),('5','173','907','190969',3733466,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191145',3736535,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191145',3736536,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191145',3736537,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191145',3736538,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','191145',3736539,'2687','401',44170.24,44341.24,171.00,45315.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','191145',3736540,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191410',3741330,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191410',3741331,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191410',3741332,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191410',3741333,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','191410',3741334,'2687','401',44341.24,44613.87,272.63,72246.95,0.00,0.00,0.00,0.00,0.00),('5','173','907','191410',3741335,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191569',3744185,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191569',3744186,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191569',3744187,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191569',3744188,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','191569',3744189,'2687','401',44613.87,45817.48,1203.61,318956.65,0.00,0.00,0.00,0.00,0.00),('5','173','907','191569',3744190,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191836',3749570,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191836',3749571,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191836',3749572,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191836',3749573,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','191836',3749574,'2687','401',45817.48,46244.96,427.48,113282.20,0.00,0.00,0.00,0.00,0.00),('5','173','907','191836',3749575,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191988',3752272,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','191988',3752273,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191988',3752274,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','191988',3752275,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','191988',3752276,'2687','401',46244.96,46449.96,205.00,54325.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','191988',3752277,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192226',3756593,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192226',3756594,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192226',3756595,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192226',3756596,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','192226',3756597,'2687','401',46449.96,46670.72,220.76,58501.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','192226',3756598,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192406',3759688,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192406',3759689,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192406',3759690,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192406',3759691,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','192406',3759692,'2687','401',46670.72,46872.54,201.82,53482.30,0.00,0.00,0.00,0.00,0.00),('5','173','907','192406',3759693,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192613',3763526,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','192613',3763527,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192613',3763528,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','192613',3763529,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','192613',3763530,'2687','401',46872.54,47137.54,265.00,70225.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','192613',3763531,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193750',3784962,'2683','400',298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193750',3784963,'2684','400',207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193750',3784964,'2685','400',138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193750',3784965,'2686','400',105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193750',3784966,'2687','401',47137.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','193750',3784967,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193941',3788399,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193941',3788400,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193941',3788401,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193941',3788402,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193941',3788403,'2687','401',47137.54,47368.54,231.00,61215.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','193941',3788404,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193945',3788463,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193945',3788464,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193945',3788465,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193945',3788466,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193945',3788467,'2687','401',47368.54,47752.10,383.56,101643.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','193945',3788468,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193950',3788612,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193950',3788613,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193950',3788614,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193950',3788615,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193950',3788616,'2687','401',47752.10,48000.10,248.00,65720.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','193950',3788617,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193958',3788740,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193958',3788741,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193958',3788742,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193958',3788743,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193958',3788744,'2687','401',48000.10,48241.86,241.76,64066.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','193958',3788745,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193963',3788862,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','193963',3788863,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193963',3788864,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','193963',3788865,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','193963',3788866,'2687','401',48241.86,48402.86,161.00,42665.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','193963',3788867,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194197',3793006,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194197',3793007,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194197',3793008,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194197',3793009,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','194197',3793010,'2687','401',48402.86,48714.26,311.40,82521.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','194197',3793011,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194378',3796318,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194378',3796319,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194378',3796320,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194378',3796321,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','194378',3796322,'2687','401',48714.26,49133.01,418.75,110968.75,0.00,0.00,0.00,0.00,0.00),('5','173','907','194378',3796323,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194379',3796324,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194379',3796325,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194379',3796326,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194379',3796327,'2686','400',105000.41,105000.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','194379',3796328,'2687','401',49133.01,49609.85,476.84,126362.60,0.00,0.00,0.00,0.00,0.00),('5','173','907','194379',3796329,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194734',3802718,'2683','400',298263.72,298263.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','194734',3802719,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194734',3802720,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','194734',3802721,'2686','400',105000.41,105553.35,552.94,91235.10,0.00,0.00,0.00,0.00,0.00),('5','173','906','194734',3802722,'2687','401',49609.85,50357.85,748.00,198220.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','194734',3802723,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195005',3808113,'2683','400',298263.72,299834.98,1571.26,259257.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','195005',3808114,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195005',3808115,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195005',3808116,'2686','400',105553.35,106036.11,482.76,79655.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','195005',3808117,'2687','401',50357.85,51021.86,664.01,175962.65,0.00,0.00,0.00,0.00,0.00),('5','173','907','195005',3808118,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195015',3808223,'2683','400',299834.98,301586.44,1751.46,288990.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','195015',3808224,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195015',3808225,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195015',3808226,'2686','400',106036.11,106806.17,770.06,127059.90,0.00,0.00,0.00,0.00,0.00),('5','173','906','195015',3808227,'2687','401',51021.86,51134.94,113.08,29966.20,0.00,0.00,0.00,0.00,0.00),('5','173','907','195015',3808228,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195357',3814130,'2683','400',301586.44,303429.87,1843.43,304165.95,0.00,0.00,0.00,0.00,0.00),('5','173','904','195357',3814131,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195357',3814132,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195357',3814133,'2686','400',106806.17,107716.90,910.73,150270.45,0.00,0.00,0.00,0.00,0.00),('5','173','906','195357',3814134,'2687','401',51134.94,51333.60,198.66,52644.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','195357',3814135,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195416',3815169,'2683','400',303429.87,305326.23,1896.36,312899.40,0.00,0.00,0.00,0.00,0.00),('5','173','904','195416',3815170,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195416',3815171,'2685','400',138742.72,138742.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195416',3815172,'2686','400',107716.90,108680.62,963.72,159013.80,0.00,0.00,0.00,0.00,0.00),('5','173','906','195416',3815173,'2687','401',51333.60,51597.40,263.80,69907.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','195416',3815174,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195767',3821299,'2683','400',305326.23,306891.01,1564.78,258188.70,0.00,0.00,0.00,0.00,0.00),('5','173','904','195767',3821300,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195767',3821301,'2685','400',138742.72,139800.06,1057.34,174461.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','195767',3821302,'2686','400',108680.62,109318.35,637.73,105225.45,0.00,0.00,0.00,0.00,0.00),('5','173','906','195767',3821303,'2687','401',51597.40,52891.92,1294.52,343047.80,0.00,0.00,0.00,0.00,0.00),('5','173','907','195767',3821304,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','195878',3823179,'2683','400',306891.01,308738.31,1847.30,304804.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','195878',3823180,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','195878',3823181,'2685','400',139800.06,140238.32,438.26,72312.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','195878',3823182,'2686','400',109318.35,110287.22,968.87,159863.55,0.00,0.00,0.00,0.00,0.00),('5','173','906','195878',3823183,'2687','401',52891.92,53114.11,222.19,58880.35,0.00,0.00,0.00,0.00,0.00),('5','173','907','195878',3823184,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196092',3827032,'2683','400',308738.31,310563.09,1824.78,301088.70,0.00,0.00,0.00,0.00,0.00),('5','173','904','196092',3827033,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196092',3827034,'2685','400',140238.32,140238.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196092',3827035,'2686','400',110287.22,111410.87,1123.65,185402.25,0.00,0.00,0.00,0.00,0.00),('5','173','906','196092',3827036,'2687','401',53114.11,53186.07,71.96,19069.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','196092',3827037,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196408',3833142,'2683','400',310563.09,312755.08,2191.99,361678.35,0.00,0.00,0.00,0.00,0.00),('5','173','904','196408',3833143,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196408',3833144,'2685','400',140238.32,140238.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196408',3833145,'2686','400',111410.87,112922.80,1511.93,249468.45,0.00,0.00,0.00,0.00,0.00),('5','173','906','196408',3833146,'2687','401',53186.07,53250.80,64.73,17153.45,0.00,0.00,0.00,0.00,0.00),('5','173','907','196408',3833147,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196592',3836436,'2683','400',312755.08,313573.81,818.73,135090.45,0.00,0.00,0.00,0.00,0.00),('5','173','904','196592',3836437,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196592',3836438,'2685','400',140238.32,141791.80,1553.48,256324.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','196592',3836439,'2686','400',112922.80,113523.27,600.47,99077.55,0.00,0.00,0.00,0.00,0.00),('5','173','906','196592',3836440,'2687','401',53250.80,53279.34,28.54,7563.10,0.00,0.00,0.00,0.00,0.00),('5','173','907','196592',3836441,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196813',3840307,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196813',3840308,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196813',3840309,'2685','400',141791.80,143786.10,1994.30,329059.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','196813',3840310,'2686','400',113523.27,113667.42,144.15,23784.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','196813',3840311,'2687','401',53279.34,53322.04,42.70,11315.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','196813',3840312,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196935',3842383,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','196935',3842384,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','196935',3842385,'2685','400',143786.10,144561.87,775.77,128002.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','196935',3842386,'2686','400',113667.42,114155.05,487.63,80458.95,0.00,0.00,0.00,0.00,0.00),('5','173','906','196935',3842387,'2687','401',53322.04,53332.28,10.24,2713.60,0.00,0.00,0.00,0.00,0.00),('5','173','907','196935',3842388,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197652',3854919,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197652',3854920,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','197652',3854921,'2685','400',144561.87,146213.79,1651.92,272566.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','197652',3854922,'2686','400',114155.05,114155.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','197652',3854923,'2687','401',53332.28,53358.14,25.86,6852.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','197652',3854924,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197654',3854941,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197654',3854942,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','197654',3854943,'2685','400',146213.79,147450.10,1236.31,203991.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','197654',3854944,'2686','400',114155.05,115329.36,1174.31,193761.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','197654',3854945,'2687','401',53358.14,53437.67,79.53,21075.45,0.00,0.00,0.00,0.00,0.00),('5','173','907','197654',3854946,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197662',3855094,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197662',3855095,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','197662',3855096,'2685','400',147450.10,147773.37,323.27,53339.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','197662',3855097,'2686','400',115329.36,117924.74,2595.38,428237.70,0.00,0.00,0.00,0.00,0.00),('5','173','906','197662',3855098,'2687','401',53437.67,53509.22,71.55,18960.75,0.00,0.00,0.00,0.00,0.00),('5','173','907','197662',3855099,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197668',3855232,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197668',3855233,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','197668',3855234,'2685','400',147773.37,149629.55,1856.18,306269.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','197668',3855235,'2686','400',117924.74,118877.94,953.20,157278.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','197668',3855236,'2687','401',53509.22,53719.49,210.27,55721.55,0.00,0.00,0.00,0.00,0.00),('5','173','907','197668',3855237,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197989',3860950,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','197989',3860951,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','197989',3860952,'2685','400',149629.55,151020.77,1391.22,229551.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','197989',3860953,'2686','400',118877.94,120175.12,1297.18,214034.70,0.00,0.00,0.00,0.00,0.00),('5','173','906','197989',3860954,'2687','401',53719.49,53894.00,174.51,47117.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','197989',3860955,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','198228',3864809,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','198228',3864810,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','198228',3864811,'2685','400',151020.77,151864.35,843.58,139190.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','198228',3864812,'2686','400',120175.12,120731.54,556.42,91809.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','198228',3864813,'2687','401',53894.00,53904.00,10.00,2700.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','198228',3864814,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','198432',3868426,'2683','400',313573.81,313573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','198432',3868427,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','198432',3868428,'2685','400',151864.35,151864.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','198432',3868429,'2686','400',120731.54,120731.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','198432',3868430,'2687','401',53904.00,53944.37,40.37,10899.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','198432',3868431,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','198720',3873647,'2683','400',313573.81,314054.93,481.12,79384.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','198720',3873648,'2684','400',207710.68,207710.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','198720',3873649,'2685','400',151864.35,152226.86,362.51,59814.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','198720',3873650,'2686','400',120731.54,120830.84,99.30,16384.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','198720',3873651,'2687','401',53944.37,55064.32,1119.95,296786.75,0.00,0.00,0.00,0.00,0.00),('5','173','907','198720',3873652,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199047',3878942,'2683','400',314054.93,315119.01,1064.08,175573.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','199047',3878943,'2684','400',207710.68,207713.34,2.66,438.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','199047',3878944,'2685','400',152226.86,152778.66,551.80,91047.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199047',3878945,'2686','400',120830.84,121259.52,428.68,70732.20,0.00,0.00,0.00,0.00,0.00),('5','173','906','199047',3878946,'2687','401',55064.32,55137.23,72.91,19685.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','199047',3878947,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199067',3879390,'2683','400',315119.01,316465.33,1346.32,222142.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','199067',3879391,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199067',3879392,'2685','400',152778.66,153604.96,826.30,136339.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','199067',3879393,'2686','400',121259.52,121259.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199067',3879394,'2687','401',55137.23,55177.84,40.61,10964.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','199067',3879395,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199255',3882564,'2683','400',316465.33,316871.04,405.71,66942.15,0.00,0.00,0.00,0.00,0.00),('5','173','904','199255',3882565,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199255',3882566,'2685','400',153604.96,153999.25,394.29,65057.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','199255',3882567,'2686','400',121259.52,121259.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199255',3882568,'2687','401',55177.84,55177.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','199255',3882569,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199511',3886610,'2683','400',316871.04,317166.14,295.10,48101.30,0.00,0.00,0.00,0.00,0.00),('5','173','904','199511',3886611,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199511',3886612,'2685','400',153999.25,154351.05,351.80,57343.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','199511',3886613,'2686','400',121259.52,121259.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199511',3886614,'2687','401',55177.84,55279.62,101.78,27480.60,0.00,0.00,0.00,0.00,0.00),('5','173','907','199511',3886615,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199516',3886739,'2683','400',317166.14,318371.83,1205.69,196527.47,0.00,0.00,0.00,0.00,0.00),('5','173','904','199516',3886740,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199516',3886741,'2685','400',154351.05,154858.78,507.73,82759.99,0.00,0.00,0.00,0.00,0.00),('5','173','905','199516',3886742,'2686','400',121259.52,121259.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199516',3886743,'2687','401',55279.62,55367.72,88.10,23787.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','199516',3886744,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199765',3890778,'2683','400',318371.83,319252.52,880.69,145313.85,0.00,0.00,0.00,0.00,0.00),('5','173','904','199765',3890779,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199765',3890780,'2685','400',154858.78,155319.69,460.91,76050.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','199765',3890781,'2686','400',121259.52,121269.52,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199765',3890782,'2687','401',55367.72,55411.85,44.13,11915.10,0.00,0.00,0.00,0.00,0.00),('5','173','907','199765',3890783,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','199960',3894189,'2683','400',319252.52,320119.43,866.91,141306.33,0.00,0.00,0.00,0.00,0.00),('5','173','904','199960',3894190,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','199960',3894191,'2685','400',155319.69,156557.62,1237.93,201782.59,0.00,0.00,0.00,0.00,0.00),('5','173','905','199960',3894192,'2686','400',121269.52,121269.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','199960',3894193,'2687','401',55411.85,55427.87,16.02,4325.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','199960',3894194,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200246',3899557,'2683','400',320119.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200246',3899558,'2684','400',207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200246',3899559,'2685','400',156557.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200246',3899560,'2686','400',121269.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','200246',3899561,'2687','401',55427.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','200246',3899562,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200536',3904591,'2683','400',320119.43,321469.03,1349.60,219984.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','200536',3904592,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200536',3904593,'2685','400',156557.62,157431.71,874.09,142476.67,0.00,0.00,0.00,0.00,0.00),('5','173','905','200536',3904594,'2686','400',121269.52,121269.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','200536',3904595,'2687','401',55427.87,55607.69,179.82,48551.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','200536',3904596,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200537',3904597,'2683','400',321469.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200537',3904598,'2684','400',207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200537',3904599,'2685','400',157431.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200537',3904600,'2686','400',121269.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','200537',3904601,'2687','401',55607.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','200537',3904602,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200554',3904867,'2683','400',321469.03,321538.27,69.24,11286.12,0.00,0.00,0.00,0.00,0.00),('5','173','904','200554',3904868,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200554',3904869,'2685','400',157431.71,159046.67,1614.96,263238.48,0.00,0.00,0.00,0.00,0.00),('5','173','905','200554',3904870,'2686','400',121269.52,121826.01,556.49,90707.87,0.00,0.00,0.00,0.00,0.00),('5','173','906','200554',3904871,'2687','401',55607.69,56815.61,1207.92,326138.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','200554',3904872,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200558',3904919,'2683','400',321538.27,321538.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200558',3904920,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200558',3904921,'2685','400',159046.67,160496.53,1449.86,236327.18,0.00,0.00,0.00,0.00,0.00),('5','173','905','200558',3904922,'2686','400',121826.01,122850.08,1024.07,166923.41,0.00,0.00,0.00,0.00,0.00),('5','173','906','200558',3904923,'2687','401',56815.61,57532.59,716.98,193584.60,0.00,0.00,0.00,0.00,0.00),('5','173','907','200558',3904924,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200831',3909976,'2683','400',321538.27,321538.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','200831',3909977,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','200831',3909978,'2685','400',160496.53,161763.68,1267.15,206545.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','200831',3909979,'2686','400',122850.08,123921.83,1071.75,174695.25,0.00,0.00,0.00,0.00,0.00),('5','173','906','200831',3909980,'2687','401',57532.59,58282.20,749.61,202394.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','200831',3909981,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201050',3913643,'2683','400',321538.27,322134.30,596.03,97152.89,0.00,0.00,0.00,0.00,0.00),('5','173','904','201050',3913644,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201050',3913645,'2685','400',161763.68,162747.40,983.72,160346.36,0.00,0.00,0.00,0.00,0.00),('5','173','905','201050',3913646,'2686','400',123921.83,124378.02,456.19,74358.97,0.00,0.00,0.00,0.00,0.00),('5','173','906','201050',3913647,'2687','401',58282.20,58679.01,396.81,107138.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','201050',3913648,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201171',3915404,'2683','400',322134.30,323171.99,1037.69,169143.47,0.00,0.00,0.00,0.00,0.00),('5','173','904','201171',3915405,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201171',3915406,'2685','400',162747.40,163193.38,445.98,72694.74,0.00,0.00,0.00,0.00,0.00),('5','173','905','201171',3915407,'2686','400',124378.02,124936.91,558.89,91099.07,0.00,0.00,0.00,0.00,0.00),('5','173','906','201171',3915408,'2687','401',58679.01,58827.12,148.11,39989.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','201171',3915409,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201380',3919005,'2683','400',323171.99,323171.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201380',3919006,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201380',3919007,'2685','400',163193.38,163853.60,660.22,107615.86,0.00,0.00,0.00,0.00,0.00),('5','173','905','201380',3919008,'2686','400',124936.91,125406.47,469.56,76538.28,0.00,0.00,0.00,0.00,0.00),('5','173','906','201380',3919009,'2687','401',58827.12,58872.66,45.54,12295.80,0.00,0.00,0.00,0.00,0.00),('5','173','907','201380',3919010,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201746',3926450,'2683','400',323171.99,323254.72,82.73,13484.99,0.00,0.00,0.00,0.00,0.00),('5','173','904','201746',3926451,'2684','400',207713.34,207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201746',3926452,'2685','400',163853.60,163970.61,117.01,19072.63,0.00,0.00,0.00,0.00,0.00),('5','173','905','201746',3926453,'2686','400',125406.47,125698.31,291.84,47569.92,0.00,0.00,0.00,0.00,0.00),('5','173','906','201746',3926454,'2687','401',58872.66,58879.67,7.01,1892.70,0.00,0.00,0.00,0.00,0.00),('5','173','907','201746',3926455,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201788',3926906,'2683','400',323254.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','201788',3926907,'2684','400',207713.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201788',3926908,'2685','400',163970.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','201788',3926909,'2686','400',125698.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','201788',3926910,'2687','401',58879.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','201788',3926911,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202187',3934360,'2683','400',323254.72,323521.67,266.95,43512.85,0.00,0.00,0.00,0.00,0.00),('5','173','904','202187',3934361,'2684','400',207713.34,207787.16,73.82,12032.66,0.00,0.00,0.00,0.00,0.00),('5','173','905','202187',3934362,'2685','400',163970.61,165031.55,1060.94,172933.22,0.00,0.00,0.00,0.00,0.00),('5','173','905','202187',3934363,'2686','400',125698.31,126313.93,615.62,100346.06,0.00,0.00,0.00,0.00,0.00),('5','173','906','202187',3934364,'2687','401',58879.67,59512.19,632.52,173943.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','202187',3934365,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202188',3934366,'2683','400',323521.67,324679.48,1157.81,188723.03,0.00,0.00,0.00,0.00,0.00),('5','173','904','202188',3934367,'2684','400',207787.16,208937.61,1150.45,187523.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','202188',3934368,'2685','400',165031.55,165031.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','202188',3934369,'2686','400',126313.93,126313.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','202188',3934370,'2687','401',59512.19,60661.65,1149.46,316101.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','202188',3934371,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202238',3935037,'2683','400',324679.48,325841.45,1161.97,189401.11,0.00,0.00,0.00,0.00,0.00),('5','173','904','202238',3935038,'2684','400',208937.61,210030.13,1092.52,178080.76,0.00,0.00,0.00,0.00,0.00),('5','173','905','202238',3935039,'2685','400',165031.55,165288.92,257.37,41951.31,0.00,0.00,0.00,0.00,0.00),('5','173','905','202238',3935040,'2686','400',126313.93,126313.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','202238',3935041,'2687','401',60661.65,61798.36,1136.71,312595.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','202238',3935042,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202624',3941982,'2683','400',325841.45,327333.45,1492.00,243196.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202624',3941983,'2684','400',210030.13,211020.19,990.06,161379.78,0.00,0.00,0.00,0.00,0.00),('5','173','905','202624',3941984,'2685','400',165288.92,165288.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','202624',3941985,'2686','400',126313.93,126313.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','202624',3941986,'2687','401',61798.36,61990.51,192.15,52841.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','202624',3941987,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202638',3942128,'2683','400',327333.45,329006.10,1672.65,272641.95,0.00,0.00,0.00,0.00,0.00),('5','173','904','202638',3942129,'2684','400',211020.19,211020.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','202638',3942130,'2685','400',165288.92,165573.54,284.62,46393.06,0.00,0.00,0.00,0.00,0.00),('5','173','905','202638',3942131,'2686','400',126313.93,126657.69,343.76,56032.88,0.00,0.00,0.00,0.00,0.00),('5','173','906','202638',3942132,'2687','401',61990.51,63128.22,1137.71,312870.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','202638',3942133,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','202851',3945921,'2683','400',329006.10,330335.12,1329.02,216630.26,0.00,0.00,0.00,0.00,0.00),('5','173','904','202851',3945922,'2684','400',211020.19,211718.17,697.98,113770.74,0.00,0.00,0.00,0.00,0.00),('5','173','905','202851',3945923,'2685','400',165573.54,165573.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','202851',3945924,'2686','400',126657.69,127101.20,443.51,72292.13,0.00,0.00,0.00,0.00,0.00),('5','173','906','202851',3945925,'2687','401',63128.22,63712.09,583.87,160564.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','202851',3945926,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203111',3950832,'2683','400',330335.12,331596.79,1261.67,205652.21,0.00,0.00,0.00,0.00,0.00),('5','173','904','203111',3950833,'2684','400',211718.17,212854.54,1136.37,185228.31,0.00,0.00,0.00,0.00,0.00),('5','173','905','203111',3950834,'2685','400',165573.54,165573.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','203111',3950835,'2686','400',127101.20,127470.01,368.81,60116.03,0.00,0.00,0.00,0.00,0.00),('5','173','906','203111',3950836,'2687','401',63712.09,65048.73,1336.64,367576.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','203111',3950837,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203316',3954569,'2683','400',331596.79,332396.79,800.00,130400.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203316',3954570,'2684','400',212854.54,214130.73,1276.19,208018.97,0.00,0.00,0.00,0.00,0.00),('5','173','905','203316',3954571,'2685','400',165573.54,166363.01,789.47,128683.61,0.00,0.00,0.00,0.00,0.00),('5','173','905','203316',3954572,'2686','400',127470.01,127470.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','203316',3954573,'2687','401',65048.73,65218.16,169.43,46593.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','203316',3954574,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203562',3958873,'2683','400',332396.79,333540.30,1143.51,186392.13,0.00,0.00,0.00,0.00,0.00),('5','173','904','203562',3958874,'2684','400',214130.73,214908.79,778.06,126823.78,0.00,0.00,0.00,0.00,0.00),('5','173','905','203562',3958875,'2685','400',166363.01,166363.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','203562',3958876,'2686','400',127470.01,127470.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','203562',3958877,'2687','401',65218.16,65647.57,429.41,118087.75,0.00,0.00,0.00,0.00,0.00),('5','173','907','203562',3958878,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203752',3962252,'2683','400',333540.30,333540.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203752',3962253,'2684','400',214908.79,215740.63,831.84,135589.92,0.00,0.00,0.00,0.00,0.00),('5','173','905','203752',3962254,'2685','400',166363.01,166810.63,447.62,72962.06,0.00,0.00,0.00,0.00,0.00),('5','173','905','203752',3962255,'2686','400',127470.01,128070.63,600.62,97901.06,0.00,0.00,0.00,0.00,0.00),('5','173','906','203752',3962256,'2687','401',65647.57,65694.81,47.24,12991.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','203752',3962257,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203971',3966201,'2683','400',333540.30,333540.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','203971',3966202,'2684','400',215740.63,216278.19,537.56,87622.28,0.00,0.00,0.00,0.00,0.00),('5','173','905','203971',3966203,'2685','400',166810.63,167233.46,422.83,68921.29,0.00,0.00,0.00,0.00,0.00),('5','173','905','203971',3966204,'2686','400',128070.63,128572.10,501.47,81739.61,0.00,0.00,0.00,0.00,0.00),('5','173','906','203971',3966205,'2687','401',65694.81,65732.76,37.95,10436.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','203971',3966206,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204218',3970626,'2683','400',333540.30,333540.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204218',3970627,'2684','400',216278.19,217231.83,953.64,155443.32,0.00,0.00,0.00,0.00,0.00),('5','173','905','204218',3970628,'2685','400',167233.46,167233.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','204218',3970629,'2686','400',128572.10,128976.49,404.39,65915.57,0.00,0.00,0.00,0.00,0.00),('5','173','906','204218',3970630,'2687','401',65732.76,65741.66,8.90,2447.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','204218',3970631,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204411',3974169,'2683','400',333540.30,333787.74,247.44,40332.72,0.00,0.00,0.00,0.00,0.00),('5','173','904','204411',3974170,'2684','400',217231.83,218602.26,1370.43,223380.09,0.00,0.00,0.00,0.00,0.00),('5','173','905','204411',3974171,'2685','400',167233.46,167233.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','204411',3974172,'2686','400',128976.49,129453.81,477.32,77803.16,0.00,0.00,0.00,0.00,0.00),('5','173','906','204411',3974173,'2687','401',65741.66,65762.09,20.43,5618.25,0.00,0.00,0.00,0.00,0.00),('5','173','907','204411',3974174,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204619',3978053,'2683','400',333787.74,333787.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204619',3978054,'2684','400',218602.26,220064.22,1461.96,238299.48,0.00,0.00,0.00,0.00,0.00),('5','173','905','204619',3978055,'2685','400',167233.46,168060.64,827.18,134830.34,0.00,0.00,0.00,0.00,0.00),('5','173','905','204619',3978056,'2686','400',129453.81,129453.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','204619',3978057,'2687','401',65762.09,66970.79,1208.70,332392.50,0.00,0.00,0.00,0.00,0.00),('5','173','907','204619',3978058,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','204872',3982039,'2683','400',333787.74,335052.66,1264.92,206181.96,0.00,0.00,0.00,0.00,0.00),('5','173','904','204872',3982040,'2684','400',220064.22,220451.44,387.22,63116.86,0.00,0.00,0.00,0.00,0.00),('5','173','905','204872',3982041,'2685','400',168060.64,168217.89,157.25,25631.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','204872',3982042,'2686','400',129453.81,130007.95,554.14,90324.82,0.00,0.00,0.00,0.00,0.00),('5','173','906','204872',3982043,'2687','401',66970.79,67784.35,813.56,223729.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','204872',3982044,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205221',3988615,'2683','400',335052.66,335052.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205221',3988616,'2684','400',220451.44,221265.63,814.19,132712.97,0.00,0.00,0.00,0.00,0.00),('5','173','905','205221',3988617,'2685','400',168217.89,168217.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205221',3988618,'2686','400',130007.95,130897.37,889.42,144975.46,0.00,0.00,0.00,0.00,0.00),('5','173','906','205221',3988619,'2687','401',67784.35,67935.35,151.00,41525.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','205221',3988620,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205231',3988713,'2683','400',335052.66,335242.25,189.59,30903.17,0.00,0.00,0.00,0.00,0.00),('5','173','904','205231',3988714,'2684','400',221265.63,222125.29,859.66,140124.58,0.00,0.00,0.00,0.00,0.00),('5','173','905','205231',3988715,'2685','400',168217.89,168217.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205231',3988716,'2686','400',130897.37,131600.20,702.83,114561.29,0.00,0.00,0.00,0.00,0.00),('5','173','906','205231',3988717,'2687','401',67935.35,67943.31,7.96,2228.80,0.00,0.00,0.00,0.00,0.00),('5','173','907','205231',3988718,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205526',3993884,'2683','400',335242.25,336241.71,999.46,162911.98,0.00,0.00,0.00,0.00,0.00),('5','173','904','205526',3993885,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205526',3993886,'2685','400',168217.89,168543.96,326.07,53149.41,0.00,0.00,0.00,0.00,0.00),('5','173','905','205526',3993887,'2686','400',131600.20,132070.36,470.16,76636.08,0.00,0.00,0.00,0.00,0.00),('5','173','906','205526',3993888,'2687','401',67943.31,68113.86,170.55,47754.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','205526',3993889,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205808',3999098,'2683','400',336241.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205808',3999099,'2684','400',222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205808',3999100,'2685','400',168543.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205808',3999101,'2686','400',132070.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','205808',3999102,'2687','401',68113.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','205808',3999103,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','205991',4002353,'2683','400',336241.71,337244.01,1002.30,163374.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','205991',4002354,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205991',4002355,'2685','400',168543.96,168543.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','205991',4002356,'2686','400',132070.36,132989.18,918.82,149767.66,0.00,0.00,0.00,0.00,0.00),('5','173','906','205991',4002357,'2687','401',68113.86,68201.33,87.47,24491.60,0.00,0.00,0.00,0.00,0.00),('5','173','907','205991',4002358,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206003',4002502,'2683','400',337244.01,337663.41,419.40,68362.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','206003',4002503,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206003',4002504,'2685','400',168543.96,168543.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206003',4002505,'2686','400',132989.18,133762.48,773.30,126047.90,0.00,0.00,0.00,0.00,0.00),('5','173','906','206003',4002506,'2687','401',68201.33,68315.34,114.01,33062.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','206003',4002507,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206134',4005032,'2683','400',337663.41,338750.23,1086.82,177151.66,0.00,0.00,0.00,0.00,0.00),('5','173','904','206134',4005033,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206134',4005034,'2685','400',168543.96,168543.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206134',4005035,'2686','400',133762.48,134204.39,441.91,72031.33,0.00,0.00,0.00,0.00,0.00),('5','173','906','206134',4005036,'2687','401',68315.34,68656.84,341.50,99035.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','206134',4005037,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206401',4009427,'2683','400',338750.23,338750.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206401',4009428,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206401',4009429,'2685','400',168543.96,169622.29,1078.33,175767.79,0.00,0.00,0.00,0.00,0.00),('5','173','905','206401',4009430,'2686','400',134204.39,135043.96,839.57,136849.91,0.00,0.00,0.00,0.00,0.00),('5','173','906','206401',4009431,'2687','401',68656.84,68678.84,22.00,6380.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','206401',4009432,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206657',4014026,'2683','400',338750.23,338750.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206657',4014027,'2684','400',222125.29,222125.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','206657',4014028,'2685','400',169622.29,170493.82,871.53,142059.39,0.00,0.00,0.00,0.00,0.00),('5','173','905','206657',4014029,'2686','400',135043.96,135855.83,811.87,132334.81,0.00,0.00,0.00,0.00,0.00),('5','173','906','206657',4014030,'2687','401',68678.84,68708.84,30.00,8700.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','206657',4014031,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','206881',4017904,'2683','400',338750.23,339149.43,399.20,65069.60,0.00,0.00,0.00,0.00,0.00),('5','173','904','206881',4017905,'2684','400',222125.29,222195.81,70.52,11494.76,0.00,0.00,0.00,0.00,0.00),('5','173','905','206881',4017906,'2685','400',170493.82,170662.61,168.79,27512.77,0.00,0.00,0.00,0.00,0.00),('5','173','905','206881',4017907,'2686','400',135855.83,136799.30,943.47,153785.61,0.00,0.00,0.00,0.00,0.00),('5','173','906','206881',4017908,'2687','401',68708.84,68743.84,35.00,10150.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','206881',4017909,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207086',4021595,'2683','400',339149.43,339149.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207086',4021596,'2684','400',222195.81,222195.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','207086',4021597,'2685','400',170662.61,171608.55,945.94,154188.22,0.00,0.00,0.00,0.00,0.00),('5','173','905','207086',4021598,'2686','400',136799.30,137484.92,685.62,111756.06,0.00,0.00,0.00,0.00,0.00),('5','173','906','207086',4021599,'2687','401',68743.84,68753.84,10.00,2900.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','207086',4021600,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207357',4026380,'2683','400',339149.43,339149.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207357',4026381,'2684','400',222195.81,222195.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','207357',4026382,'2685','400',171608.55,172473.37,864.82,140965.66,0.00,0.00,0.00,0.00,0.00),('5','173','905','207357',4026383,'2686','400',137484.92,138076.71,591.79,96461.77,0.00,0.00,0.00,0.00,0.00),('5','173','906','207357',4026384,'2687','401',68753.84,68763.84,10.00,2900.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','207357',4026385,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207592',4030712,'2683','400',339149.43,339149.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207592',4030713,'2684','400',222195.81,222195.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','207592',4030714,'2685','400',172473.37,173310.06,836.69,136380.47,0.00,0.00,0.00,0.00,0.00),('5','173','905','207592',4030715,'2686','400',138076.71,138745.24,668.53,108970.39,0.00,0.00,0.00,0.00,0.00),('5','173','906','207592',4030716,'2687','401',68763.84,68894.00,130.16,37746.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','207592',4030717,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','207786',4033916,'2683','400',339149.43,339296.16,146.73,23916.99,0.00,0.00,0.00,0.00,0.00),('5','173','904','207786',4033917,'2684','400',222195.81,223277.97,1082.16,176392.08,0.00,0.00,0.00,0.00,0.00),('5','173','905','207786',4033918,'2685','400',173310.06,173347.74,37.68,6141.84,0.00,0.00,0.00,0.00,0.00),('5','173','905','207786',4033919,'2686','400',138745.24,139523.35,778.11,126831.93,0.00,0.00,0.00,0.00,0.00),('5','173','906','207786',4033920,'2687','401',68894.00,68966.56,72.56,21042.40,0.00,0.00,0.00,0.00,0.00),('5','173','907','207786',4033921,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208093',4039358,'2683','400',339296.16,339848.16,552.00,89976.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208093',4039359,'2684','400',223277.97,224333.38,1055.41,172031.83,0.00,0.00,0.00,0.00,0.00),('5','173','905','208093',4039360,'2685','400',173347.74,173543.77,196.03,31952.89,0.00,0.00,0.00,0.00,0.00),('5','173','905','208093',4039361,'2686','400',139523.35,139523.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','208093',4039362,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','208093',4039363,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208177',4040708,'2683','400',339848.16,339848.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208177',4040709,'2684','400',224333.38,225377.47,1044.09,170186.67,0.00,0.00,0.00,0.00,0.00),('5','173','905','208177',4040710,'2685','400',173543.77,174435.82,892.05,145404.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','208177',4040711,'2686','400',139523.35,139523.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','208177',4040712,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','208177',4040713,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208502',4046669,'2683','400',339848.16,340239.70,391.54,63821.02,0.00,0.00,0.00,0.00,0.00),('5','173','904','208502',4046670,'2684','400',225377.47,226444.01,1066.54,173846.02,0.00,0.00,0.00,0.00,0.00),('5','173','905','208502',4046671,'2685','400',174435.82,175399.40,963.58,157063.54,0.00,0.00,0.00,0.00,0.00),('5','173','905','208502',4046672,'2686','400',139523.35,139523.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','208502',4046673,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','208502',4046674,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208639',4048903,'2683','400',340239.70,340239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208639',4048904,'2684','400',226444.01,227517.03,1073.02,174902.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','208639',4048905,'2685','400',175399.40,175823.72,424.32,69164.16,0.00,0.00,0.00,0.00,0.00),('5','173','905','208639',4048906,'2686','400',139523.35,139801.98,278.63,45416.69,0.00,0.00,0.00,0.00,0.00),('5','173','906','208639',4048907,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','208639',4048908,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208878',4053051,'2683','400',340239.70,340239.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','208878',4053052,'2684','400',227517.03,228464.49,947.46,154435.98,0.00,0.00,0.00,0.00,0.00),('5','173','905','208878',4053053,'2685','400',175823.72,176232.72,409.00,66667.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','208878',4053054,'2686','400',139801.98,140086.82,284.84,46428.92,0.00,0.00,0.00,0.00,0.00),('5','173','906','208878',4053055,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','208878',4053056,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209024',4055387,'2683','400',340239.70,341468.76,1229.06,200336.78,0.00,0.00,0.00,0.00,0.00),('5','173','904','209024',4055388,'2684','400',228464.49,228538.08,73.59,11995.17,0.00,0.00,0.00,0.00,0.00),('5','173','905','209024',4055389,'2685','400',176232.72,176232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','209024',4055390,'2686','400',140086.82,140993.09,906.27,147722.01,0.00,0.00,0.00,0.00,0.00),('5','173','906','209024',4055391,'2687','401',68966.56,68966.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','209024',4055392,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209421',4062706,'2683','400',341468.76,342277.21,808.45,131777.35,0.00,0.00,0.00,0.00,0.00),('5','173','904','209421',4062707,'2684','400',228538.08,228538.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','209421',4062708,'2685','400',176232.72,176232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','209421',4062709,'2686','400',140993.09,141863.84,870.75,141932.25,0.00,0.00,0.00,0.00,0.00),('5','173','906','209421',4062710,'2687','401',68966.56,69050.57,84.01,24362.90,0.00,0.00,0.00,0.00,0.00),('5','173','907','209421',4062711,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209536',4064583,'2683','400',342277.21,342277.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209536',4064584,'2684','400',228538.08,229694.35,1156.27,188472.01,0.00,0.00,0.00,0.00,0.00),('5','173','905','209536',4064585,'2685','400',176232.72,176920.89,688.17,112171.71,0.00,0.00,0.00,0.00,0.00),('5','173','905','209536',4064586,'2686','400',141863.84,141863.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','209536',4064587,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','209536',4064588,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209841',4070202,'2683','400',342277.21,342277.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209841',4070203,'2684','400',229694.35,230990.63,1296.28,211293.64,0.00,0.00,0.00,0.00,0.00),('5','173','905','209841',4070204,'2685','400',176920.89,177866.81,945.92,154184.96,0.00,0.00,0.00,0.00,0.00),('5','173','905','209841',4070205,'2686','400',141863.84,141863.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','209841',4070206,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','209841',4070207,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','209952',4072091,'2683','400',342277.21,342406.70,129.49,21106.87,0.00,0.00,0.00,0.00,0.00),('5','173','904','209952',4072092,'2684','400',230990.63,231568.74,578.11,94231.93,0.00,0.00,0.00,0.00,0.00),('5','173','905','209952',4072093,'2685','400',177866.81,178300.58,433.77,70704.51,0.00,0.00,0.00,0.00,0.00),('5','173','905','209952',4072094,'2686','400',141863.84,142683.23,819.39,133560.57,0.00,0.00,0.00,0.00,0.00),('5','173','906','209952',4072095,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','209952',4072096,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210135',4075200,'2683','400',342406.70,343002.83,596.13,97169.19,0.00,0.00,0.00,0.00,0.00),('5','173','904','210135',4075201,'2684','400',231568.74,232600.96,1032.22,168251.86,0.00,0.00,0.00,0.00,0.00),('5','173','905','210135',4075202,'2685','400',178300.58,178431.53,130.95,21344.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','210135',4075203,'2686','400',142683.23,142683.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','210135',4075204,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','210135',4075205,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210410',4080137,'2683','400',343002.83,343056.83,54.00,8802.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210410',4080138,'2684','400',232600.96,233975.36,1374.40,224027.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','210410',4080139,'2685','400',178431.53,178431.63,0.10,16.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','210410',4080140,'2686','400',142683.23,142932.94,249.71,40702.73,0.00,0.00,0.00,0.00,0.00),('5','173','906','210410',4080141,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','210410',4080142,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210508',4082140,'2683','400',343056.83,343056.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210508',4082141,'2684','400',233975.36,234906.93,931.57,151845.91,0.00,0.00,0.00,0.00,0.00),('5','173','905','210508',4082142,'2685','400',178431.63,178637.02,205.39,33478.57,0.00,0.00,0.00,0.00,0.00),('5','173','905','210508',4082143,'2686','400',142932.94,143606.88,673.94,109852.22,0.00,0.00,0.00,0.00,0.00),('5','173','906','210508',4082144,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','210508',4082145,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','210750',4086181,'2683','400',343056.83,343426.10,369.27,60191.01,0.00,0.00,0.00,0.00,0.00),('5','173','904','210750',4086182,'2684','400',234906.93,235942.11,1035.18,168734.34,0.00,0.00,0.00,0.00,0.00),('5','173','905','210750',4086183,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','210750',4086184,'2686','400',143606.88,143606.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','210750',4086185,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','210750',4086186,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211027',4090842,'2683','400',343426.10,344612.04,1185.94,193308.22,0.00,0.00,0.00,0.00,0.00),('5','173','904','211027',4090843,'2684','400',235942.11,237000.09,1057.98,172450.74,0.00,0.00,0.00,0.00,0.00),('5','173','905','211027',4090844,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','211027',4090845,'2686','400',143606.88,143606.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','211027',4090846,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','211027',4090847,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211240',4094788,'2683','400',344612.04,345513.16,901.12,146882.56,0.00,0.00,0.00,0.00,0.00),('5','173','904','211240',4094789,'2684','400',237000.09,238285.91,1285.82,209588.66,0.00,0.00,0.00,0.00,0.00),('5','173','905','211240',4094790,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','211240',4094791,'2686','400',143606.88,143936.19,329.31,53677.53,0.00,0.00,0.00,0.00,0.00),('5','173','906','211240',4094792,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','211240',4094793,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211419',4097884,'2683','400',345513.16,345817.94,304.78,49679.14,0.00,0.00,0.00,0.00,0.00),('5','173','904','211419',4097885,'2684','400',238285.91,239393.89,1107.98,180600.74,0.00,0.00,0.00,0.00,0.00),('5','173','905','211419',4097886,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','211419',4097887,'2686','400',143936.19,144365.49,429.30,69975.90,0.00,0.00,0.00,0.00,0.00),('5','173','906','211419',4097888,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','211419',4097889,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211764',4103982,'2683','400',345817.94,345817.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211764',4103983,'2684','400',239393.89,240271.03,877.14,142973.82,0.00,0.00,0.00,0.00,0.00),('5','173','905','211764',4103984,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','211764',4103985,'2686','400',144365.49,144365.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','211764',4103986,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','211764',4103987,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211974',4107732,'2683','400',345817.94,345817.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','211974',4107733,'2684','400',240271.03,241366.18,1095.15,178509.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','211974',4107734,'2685','400',178637.02,178637.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','211974',4107735,'2686','400',144365.49,144365.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','211974',4107736,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','211974',4107737,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212139',4110480,'2683','400',345817.94,345817.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212139',4110481,'2684','400',241366.18,242773.94,1407.76,229464.88,0.00,0.00,0.00,0.00,0.00),('5','173','905','212139',4110482,'2685','400',178637.02,178643.75,6.73,1096.99,0.00,0.00,0.00,0.00,0.00),('5','173','905','212139',4110483,'2686','400',144365.49,144510.90,145.41,23701.83,0.00,0.00,0.00,0.00,0.00),('5','173','906','212139',4110484,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','212139',4110485,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212360',4114486,'2683','400',345817.94,345817.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212360',4114487,'2684','400',242773.94,244220.15,1446.21,235732.23,0.00,0.00,0.00,0.00,0.00),('5','173','905','212360',4114488,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','212360',4114489,'2686','400',144510.90,144510.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','212360',4114490,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','212360',4114491,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212828',4122958,'2683','400',345817.94,346025.29,207.35,33798.05,0.00,0.00,0.00,0.00,0.00),('5','173','904','212828',4122959,'2684','400',244220.15,245265.33,1045.18,170364.34,0.00,0.00,0.00,0.00,0.00),('5','173','905','212828',4122960,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','212828',4122961,'2686','400',144510.90,144749.32,238.42,38862.46,0.00,0.00,0.00,0.00,0.00),('5','173','906','212828',4122962,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','212828',4122963,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212832',4123039,'2683','400',346025.29,346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','212832',4123040,'2684','400',245265.33,245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','212832',4123041,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','212832',4123042,'2686','400',144749.32,146249.32,1500.00,244500.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','212832',4123043,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','212832',4123044,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213110',4127895,'2683','400',346025.29,346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213110',4127896,'2684','400',245265.33,245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213110',4127897,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213110',4127898,'2686','400',146249.32,147399.32,1150.00,187450.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','213110',4127899,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','213110',4127900,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213232',4129764,'2683','400',346025.29,346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213232',4129765,'2684','400',245265.33,245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213232',4129766,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213232',4129767,'2686','400',147399.32,147399.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','213232',4129768,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','213232',4129769,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213859',4140277,'2683','400',346025.29,346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213859',4140278,'2684','400',245265.33,245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213859',4140279,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213859',4140280,'2686','400',147399.32,147399.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','213859',4140281,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','213859',4140282,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213860',4140283,'2683','400',346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213860',4140284,'2684','400',245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213860',4140285,'2685','400',178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213860',4140286,'2686','400',147399.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','213860',4140287,'2687','401',69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','213860',4140288,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213981',4142165,'2683','400',346025.29,346025.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','213981',4142166,'2684','400',245265.33,245265.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213981',4142167,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','213981',4142168,'2686','400',147399.32,148582.87,1183.55,191735.10,0.00,0.00,0.00,0.00,0.00),('5','173','906','213981',4142169,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','213981',4142170,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214239',4146717,'2683','400',346025.29,346097.47,72.18,11693.16,0.00,0.00,0.00,0.00,0.00),('5','173','904','214239',4146718,'2684','400',245265.33,246916.06,1650.73,267418.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','214239',4146719,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','214239',4146720,'2686','400',148582.87,149514.35,931.48,150899.76,0.00,0.00,0.00,0.00,0.00),('5','173','906','214239',4146721,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','214239',4146722,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214464',4150560,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214464',4150561,'2684','400',246916.06,248094.27,1178.21,190870.02,0.00,0.00,0.00,0.00,0.00),('5','173','905','214464',4150562,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','214464',4150563,'2686','400',149514.35,150038.59,524.24,84926.88,0.00,0.00,0.00,0.00,0.00),('5','173','906','214464',4150564,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','214464',4150565,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214547',4151732,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214547',4151733,'2684','400',248094.27,249400.62,1306.35,211628.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','214547',4151734,'2685','400',178643.75,178643.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','214547',4151735,'2686','400',150038.59,150523.65,485.06,78579.72,0.00,0.00,0.00,0.00,0.00),('5','173','906','214547',4151736,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','214547',4151737,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214916',4158174,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214916',4158175,'2684','400',249400.62,250393.59,992.97,160861.14,0.00,0.00,0.00,0.00,0.00),('5','173','905','214916',4158176,'2685','400',178643.75,178764.03,120.28,19485.36,0.00,0.00,0.00,0.00,0.00),('5','173','905','214916',4158177,'2686','400',150523.65,150929.12,405.47,65686.14,0.00,0.00,0.00,0.00,0.00),('5','173','906','214916',4158178,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','214916',4158179,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214939',4158632,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','214939',4158633,'2684','400',250393.59,251476.05,1082.46,175358.52,0.00,0.00,0.00,0.00,0.00),('5','173','905','214939',4158634,'2685','400',178764.03,179027.07,263.04,42612.48,0.00,0.00,0.00,0.00,0.00),('5','173','905','214939',4158635,'2686','400',150929.12,151163.05,233.93,37896.66,0.00,0.00,0.00,0.00,0.00),('5','173','906','214939',4158636,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','214939',4158637,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215085',4160950,'2683','400',346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215085',4160951,'2684','400',251476.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','215085',4160952,'2685','400',179027.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','215085',4160953,'2686','400',151163.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','215085',4160954,'2687','401',69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215085',4160955,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215277',4164229,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215277',4164230,'2684','400',251476.05,252165.75,689.70,111731.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','215277',4164231,'2685','400',179027.07,179027.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','215277',4164232,'2686','400',151163.05,151938.83,775.78,125676.36,0.00,0.00,0.00,0.00,0.00),('5','173','906','215277',4164233,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215277',4164234,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215282',4164296,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215282',4164297,'2684','400',252165.75,253177.32,1011.57,163874.34,0.00,0.00,0.00,0.00,0.00),('5','173','905','215282',4164298,'2685','400',179027.07,179294.73,267.66,43360.92,0.00,0.00,0.00,0.00,0.00),('5','173','905','215282',4164299,'2686','400',151938.83,152281.59,342.76,55527.12,0.00,0.00,0.00,0.00,0.00),('5','173','906','215282',4164300,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215282',4164301,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215476',4167527,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215476',4167528,'2684','400',253177.32,254619.03,1441.71,233557.02,0.00,0.00,0.00,0.00,0.00),('5','173','905','215476',4167529,'2685','400',179294.73,179424.86,130.13,21081.06,0.00,0.00,0.00,0.00,0.00),('5','173','905','215476',4167530,'2686','400',152281.59,152825.35,543.76,88089.12,0.00,0.00,0.00,0.00,0.00),('5','173','906','215476',4167531,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215476',4167532,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215783',4172986,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215783',4172987,'2684','400',254619.03,255977.18,1358.15,220020.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','215783',4172988,'2685','400',179424.86,179538.16,113.30,18354.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','215783',4172989,'2686','400',152825.35,153176.23,350.88,56842.56,0.00,0.00,0.00,0.00,0.00),('5','173','906','215783',4172990,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215783',4172991,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215983',4176303,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','215983',4176304,'2684','400',255977.18,257043.77,1066.59,172787.58,0.00,0.00,0.00,0.00,0.00),('5','173','905','215983',4176305,'2685','400',179538.16,180108.90,570.74,92459.88,0.00,0.00,0.00,0.00,0.00),('5','173','905','215983',4176306,'2686','400',153176.23,153581.17,404.94,65600.28,0.00,0.00,0.00,0.00,0.00),('5','173','906','215983',4176307,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','215983',4176308,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216156',4179256,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216156',4179257,'2684','400',257043.77,258277.63,1233.86,199885.32,0.00,0.00,0.00,0.00,0.00),('5','173','905','216156',4179258,'2685','400',180108.90,180277.40,168.50,27297.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','216156',4179259,'2686','400',153581.17,154113.24,532.07,86195.34,0.00,0.00,0.00,0.00,0.00),('5','173','906','216156',4179260,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','216156',4179261,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216361',4182774,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216361',4182775,'2684','400',258277.63,259274.98,997.35,161570.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','216361',4182776,'2685','400',180277.40,180716.38,438.98,71114.76,0.00,0.00,0.00,0.00,0.00),('5','173','905','216361',4182777,'2686','400',154113.24,154425.39,312.15,50568.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','216361',4182778,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','216361',4182779,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216599',4186841,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216599',4186842,'2684','400',259274.98,260820.63,1545.65,250395.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','216599',4186843,'2685','400',180716.38,181175.11,458.73,74314.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','216599',4186844,'2686','400',154425.39,154549.75,124.36,20146.32,0.00,0.00,0.00,0.00,0.00),('5','173','906','216599',4186845,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','216599',4186846,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216862',4191650,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','216862',4191651,'2684','400',260820.63,261806.08,985.45,159642.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','216862',4191652,'2685','400',181175.11,181474.64,299.53,48523.86,0.00,0.00,0.00,0.00,0.00),('5','173','905','216862',4191653,'2686','400',154549.75,154812.92,263.17,42633.54,0.00,0.00,0.00,0.00,0.00),('5','173','906','216862',4191654,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','216862',4191655,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217112',4196017,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217112',4196018,'2684','400',261806.08,262548.76,742.68,120314.16,0.00,0.00,0.00,0.00,0.00),('5','173','905','217112',4196019,'2685','400',181474.64,181787.89,313.25,50746.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','217112',4196020,'2686','400',154812.92,155302.36,489.44,79289.28,0.00,0.00,0.00,0.00,0.00),('5','173','906','217112',4196021,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','217112',4196022,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217318',4199909,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217318',4199910,'2684','400',262548.76,263838.40,1289.64,208921.68,0.00,0.00,0.00,0.00,0.00),('5','173','905','217318',4199911,'2685','400',181787.89,181971.87,183.98,29804.76,0.00,0.00,0.00,0.00,0.00),('5','173','905','217318',4199912,'2686','400',155302.36,155714.05,411.69,66693.78,0.00,0.00,0.00,0.00,0.00),('5','173','906','217318',4199913,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','217318',4199914,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217672',4206254,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217672',4206255,'2684','400',263838.40,263963.54,125.14,20272.68,0.00,0.00,0.00,0.00,0.00),('5','173','905','217672',4206256,'2685','400',181971.87,181972.59,0.72,116.64,0.00,0.00,0.00,0.00,0.00),('5','173','905','217672',4206257,'2686','400',155714.05,155714.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','217672',4206258,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','217672',4206259,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217943',4211164,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','217943',4211165,'2684','400',263963.54,264263.55,300.01,48601.62,0.00,0.00,0.00,0.00,0.00),('5','173','905','217943',4211166,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','217943',4211167,'2686','400',155714.05,155791.82,77.77,12598.74,0.00,0.00,0.00,0.00,0.00),('5','173','906','217943',4211168,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','217943',4211169,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218036',4212494,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218036',4212495,'2684','400',264263.55,264594.78,331.23,53659.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','218036',4212496,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','218036',4212497,'2686','400',155791.82,155791.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','218036',4212498,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','218036',4212499,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218359',4218250,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218359',4218251,'2684','400',264594.78,264997.64,402.86,65263.32,0.00,0.00,0.00,0.00,0.00),('5','173','905','218359',4218252,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','218359',4218253,'2686','400',155791.82,155791.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','218359',4218254,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','218359',4218255,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218480',4220257,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218480',4220258,'2684','400',264997.64,265830.99,833.35,135002.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','218480',4220259,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','218480',4220260,'2686','400',155791.82,155841.95,50.13,8121.06,0.00,0.00,0.00,0.00,0.00),('5','173','906','218480',4220261,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','218480',4220262,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218859',4227218,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218859',4227219,'2684','400',265830.99,266855.29,1024.30,165936.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','218859',4227220,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','218859',4227221,'2686','400',155841.95,156596.46,754.51,122230.62,0.00,0.00,0.00,0.00,0.00),('5','173','906','218859',4227222,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','218859',4227223,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218929',4228229,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','218929',4228230,'2684','400',266855.29,268294.03,1438.74,233075.88,0.00,0.00,0.00,0.00,0.00),('5','173','905','218929',4228231,'2685','400',181972.59,181972.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','218929',4228232,'2686','400',156596.46,157185.16,588.70,95369.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','218929',4228233,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','218929',4228234,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219136',4231758,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219136',4231759,'2684','400',268294.03,269264.38,970.35,157196.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','219136',4231760,'2685','400',181972.59,182367.31,394.72,63944.64,0.00,0.00,0.00,0.00,0.00),('5','173','905','219136',4231761,'2686','400',157185.16,157476.25,291.09,47156.58,0.00,0.00,0.00,0.00,0.00),('5','173','906','219136',4231762,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','219136',4231763,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219342',4235377,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219342',4235378,'2684','400',269264.38,270384.17,1119.79,181405.98,0.00,0.00,0.00,0.00,0.00),('5','173','905','219342',4235379,'2685','400',182367.31,182367.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','219342',4235380,'2686','400',157476.25,158267.87,791.62,128242.44,0.00,0.00,0.00,0.00,0.00),('5','173','906','219342',4235381,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','219342',4235382,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219622',4240055,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219622',4240056,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','219622',4240057,'2685','400',182367.31,183222.17,854.86,138487.32,0.00,0.00,0.00,0.00,0.00),('5','173','905','219622',4240058,'2686','400',158267.87,159526.01,1258.14,203818.68,0.00,0.00,0.00,0.00,0.00),('5','173','906','219622',4240059,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','219622',4240060,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219871',4244648,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','219871',4244649,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','219871',4244650,'2685','400',183222.17,183222.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','219871',4244651,'2686','400',159526.01,160302.98,776.97,125869.14,0.00,0.00,0.00,0.00,0.00),('5','173','906','219871',4244652,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','219871',4244653,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220148',4249702,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220148',4249703,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220148',4249704,'2685','400',183222.17,184222.55,1000.38,162061.56,0.00,0.00,0.00,0.00,0.00),('5','173','905','220148',4249705,'2686','400',160302.98,160302.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','220148',4249706,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','220148',4249707,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220379',4253897,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220379',4253898,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220379',4253899,'2685','400',184222.55,184782.69,560.14,90742.68,0.00,0.00,0.00,0.00,0.00),('5','173','905','220379',4253900,'2686','400',160302.98,160302.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','220379',4253901,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','220379',4253902,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220654',4258812,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220654',4258813,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220654',4258814,'2685','400',184782.69,184782.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220654',4258815,'2686','400',160302.98,161080.97,777.99,126034.38,0.00,0.00,0.00,0.00,0.00),('5','173','906','220654',4258816,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','220654',4258817,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220867',4262658,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','220867',4262659,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220867',4262660,'2685','400',184782.69,184782.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','220867',4262661,'2686','400',161080.97,161933.18,852.21,138058.02,0.00,0.00,0.00,0.00,0.00),('5','173','906','220867',4262662,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','220867',4262663,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221005',4264833,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221005',4264834,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221005',4264835,'2685','400',184782.69,185183.52,400.83,64934.46,0.00,0.00,0.00,0.00,0.00),('5','173','905','221005',4264836,'2686','400',161933.18,162714.38,781.20,126554.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','221005',4264837,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','221005',4264838,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221220',4268572,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221220',4268573,'2684','400',270384.17,270384.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221220',4268574,'2685','400',185183.52,185183.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221220',4268575,'2686','400',162714.38,164483.74,1769.36,286636.32,0.00,0.00,0.00,0.00,0.00),('5','173','906','221220',4268576,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','221220',4268577,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221398',4271877,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221398',4271878,'2684','400',270384.17,270824.81,440.64,71383.68,0.00,0.00,0.00,0.00,0.00),('5','173','905','221398',4271879,'2685','400',185183.52,185183.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221398',4271880,'2686','400',164483.74,165674.48,1190.74,192899.88,0.00,0.00,0.00,0.00,0.00),('5','173','906','221398',4271881,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','221398',4271882,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221741',4278197,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221741',4278198,'2684','400',270824.81,271228.49,403.68,65396.16,0.00,0.00,0.00,0.00,0.00),('5','173','905','221741',4278199,'2685','400',185183.52,185183.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221741',4278200,'2686','400',165674.48,166900.23,1225.75,198571.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','221741',4278201,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','221741',4278202,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221971',4282273,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','221971',4282274,'2684','400',271228.49,272302.64,1074.15,174012.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','221971',4282275,'2685','400',185183.52,185183.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','221971',4282276,'2686','400',166900.23,166974.84,74.61,12086.82,0.00,0.00,0.00,0.00,0.00),('5','173','906','221971',4282277,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','221971',4282278,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222079',4284222,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222079',4284223,'2684','400',272302.64,273732.38,1429.74,231617.88,0.00,0.00,0.00,0.00,0.00),('5','173','905','222079',4284224,'2685','400',185183.52,185183.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','222079',4284225,'2686','400',166974.84,167068.99,94.15,15252.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','222079',4284226,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','222079',4284227,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222307',4287894,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222307',4287895,'2684','400',273732.38,273732.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','222307',4287896,'2685','400',185183.52,185277.98,94.46,15302.52,0.00,0.00,0.00,0.00,0.00),('5','173','905','222307',4287897,'2686','400',167068.99,167767.77,698.78,113202.36,0.00,0.00,0.00,0.00,0.00),('5','173','906','222307',4287898,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','222307',4287899,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222565',4292454,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222565',4292455,'2684','400',273732.38,273732.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','222565',4292456,'2685','400',185277.98,185584.58,306.60,49669.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','222565',4292457,'2686','400',167767.77,169036.10,1268.33,205469.46,0.00,0.00,0.00,0.00,0.00),('5','173','906','222565',4292458,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','222565',4292459,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222790',4296621,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222790',4296622,'2684','400',273732.38,273732.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','222790',4296623,'2685','400',185584.58,185652.47,67.89,10998.18,0.00,0.00,0.00,0.00,0.00),('5','173','905','222790',4296624,'2686','400',169036.10,170371.64,1335.54,216357.48,0.00,0.00,0.00,0.00,0.00),('5','173','906','222790',4296625,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','222790',4296626,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222970',4300185,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','222970',4300186,'2684','400',273732.38,273732.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','222970',4300187,'2685','400',185652.47,185943.76,291.29,47188.98,0.00,0.00,0.00,0.00,0.00),('5','173','905','222970',4300188,'2686','400',170371.64,170845.07,473.43,76695.66,0.00,0.00,0.00,0.00,0.00),('5','173','906','222970',4300189,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','222970',4300190,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','223225',4304364,'2683','400',346097.47,346097.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','223225',4304365,'2684','400',273732.38,274558.43,826.05,133820.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','223225',4304366,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','223225',4304367,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','223225',4304368,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','223225',4304369,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','223539',4309948,'2683','400',346097.47,346512.91,415.44,67301.28,0.00,0.00,0.00,0.00,0.00),('5','173','904','223539',4309949,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','223539',4309950,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','223539',4309951,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','223539',4309952,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','223539',4309953,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','223786',4314676,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','223786',4314677,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','223786',4314678,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','223786',4314679,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','223786',4314680,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','223786',4314681,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224166',4321236,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224166',4321237,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224166',4321238,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224166',4321239,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','224166',4321240,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','224166',4321241,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224272',4323589,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224272',4323590,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224272',4323591,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224272',4323592,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','224272',4323593,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','224272',4323594,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224416',4325931,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224416',4325932,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224416',4325933,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224416',4325934,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','224416',4325935,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','224416',4325936,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224710',4330862,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','224710',4330863,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224710',4330864,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','224710',4330865,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','224710',4330866,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','224710',4330867,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225161',4339186,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225161',4339187,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225161',4339188,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225161',4339189,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','225161',4339190,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','225161',4339191,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225425',4344168,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225425',4344169,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225425',4344170,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225425',4344171,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','225425',4344172,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','225425',4344173,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225629',4347781,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225629',4347782,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225629',4347783,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225629',4347784,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','225629',4347785,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','225629',4347786,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225850',4351305,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225850',4351306,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225850',4351307,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225850',4351308,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','225850',4351309,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','225850',4351310,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225930',4352824,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','225930',4352825,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225930',4352826,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','225930',4352827,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','225930',4352828,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','225930',4352829,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226153',4356800,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226153',4356801,'2684','400',274558.43,274558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','226153',4356802,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','226153',4356803,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','226153',4356804,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','226153',4356805,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226444',4362168,'2683','400',346512.91,346512.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226444',4362169,'2684','400',274558.43,274935.46,377.03,61078.86,0.00,0.00,0.00,0.00,0.00),('5','173','905','226444',4362170,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','226444',4362171,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','226444',4362172,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','226444',4362173,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226574',4364164,'2683','400',346512.91,346579.14,66.23,10729.26,0.00,0.00,0.00,0.00,0.00),('5','173','904','226574',4364165,'2684','400',274935.46,276496.13,1560.67,252828.54,0.00,0.00,0.00,0.00,0.00),('5','173','905','226574',4364166,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','226574',4364167,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','226574',4364168,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','226574',4364169,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','226870',4369707,'2683','400',346579.14,347817.04,1237.90,200539.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','226870',4369708,'2684','400',276496.13,277149.10,652.97,105781.14,0.00,0.00,0.00,0.00,0.00),('5','173','905','226870',4369709,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','226870',4369710,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','226870',4369711,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','226870',4369712,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','227070',4373061,'2683','400',347817.04,348217.90,400.86,64939.32,0.00,0.00,0.00,0.00,0.00),('5','173','904','227070',4373062,'2684','400',277149.10,277941.54,792.44,128375.28,0.00,0.00,0.00,0.00,0.00),('5','173','905','227070',4373063,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','227070',4373064,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','227070',4373065,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','227070',4373066,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','227234',4375819,'2683','400',348217.90,348374.91,157.01,25435.62,0.00,0.00,0.00,0.00,0.00),('5','173','904','227234',4375820,'2684','400',277941.54,279106.77,1165.23,188767.26,0.00,0.00,0.00,0.00,0.00),('5','173','905','227234',4375821,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','227234',4375822,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','227234',4375823,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','227234',4375824,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','227462',4380083,'2683','400',348374.91,349013.01,638.10,103372.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','227462',4380084,'2684','400',279106.77,279965.43,858.66,139102.92,0.00,0.00,0.00,0.00,0.00),('5','173','905','227462',4380085,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','227462',4380086,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','227462',4380087,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','227462',4380088,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','227687',4383966,'2683','400',349013.01,349610.33,597.32,96765.84,0.00,0.00,0.00,0.00,0.00),('5','173','904','227687',4383967,'2684','400',279965.43,280616.59,651.16,105487.92,0.00,0.00,0.00,0.00,0.00),('5','173','905','227687',4383968,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','227687',4383969,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','227687',4383970,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','227687',4383971,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','227925',4388218,'2683','400',349610.33,349997.66,387.33,62747.46,0.00,0.00,0.00,0.00,0.00),('5','173','904','227925',4388219,'2684','400',280616.59,281381.95,765.36,123988.32,0.00,0.00,0.00,0.00,0.00),('5','173','905','227925',4388220,'2685','400',185943.76,185943.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','227925',4388221,'2686','400',170845.07,170845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','227925',4388222,'2687','401',69050.57,69050.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','227925',4388223,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235144',4519496,'2683','400',351342.29,351342.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235144',4519497,'2684','400',282956.04,283722.82,766.78,124218.36,0.00,0.00,0.00,0.00,0.00),('5','173','905','235144',4519498,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235144',4519499,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235144',4519500,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235144',4519501,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235685',4528982,'2683','400',351342.29,351438.27,95.98,15548.76,0.00,0.00,0.00,0.00,0.00),('5','173','904','235685',4528983,'2684','400',283722.82,283826.84,104.02,16851.24,0.00,0.00,0.00,0.00,0.00),('5','173','905','235685',4528984,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235685',4528985,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235685',4528986,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235685',4528987,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235849',4531871,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235849',4531872,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235849',4531873,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235849',4531874,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235849',4531875,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235849',4531876,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235850',4531877,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235850',4531878,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235850',4531879,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235850',4531880,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235850',4531881,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235850',4531882,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235852',4531901,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235852',4531902,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235852',4531903,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235852',4531904,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235852',4531905,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235852',4531906,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235855',4531972,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235855',4531973,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235855',4531974,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235855',4531975,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235855',4531976,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235855',4531977,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235856',4531978,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235856',4531979,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235856',4531980,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235856',4531981,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235856',4531982,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235856',4531983,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235857',4531984,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235857',4531985,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235857',4531986,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235857',4531987,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235857',4531988,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235857',4531989,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235863',4532054,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235863',4532055,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235863',4532056,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235863',4532057,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235863',4532058,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235863',4532059,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235872',4532209,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235872',4532210,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235872',4532211,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235872',4532212,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235872',4532213,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235872',4532214,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235873',4532215,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235873',4532216,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235873',4532217,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235873',4532218,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235873',4532219,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235873',4532220,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235874',4532221,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235874',4532222,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235874',4532223,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235874',4532224,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235874',4532225,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235874',4532226,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235875',4532227,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235875',4532228,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235875',4532229,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235875',4532230,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235875',4532231,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235875',4532232,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235876',4532233,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235876',4532234,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235876',4532235,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235876',4532236,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235876',4532237,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235876',4532238,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235877',4532239,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235877',4532240,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235877',4532241,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235877',4532242,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235877',4532243,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235877',4532244,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235911',4532768,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235911',4532769,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235911',4532770,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235911',4532771,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235911',4532772,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235911',4532773,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235962',4533821,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','235962',4533822,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235962',4533823,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','235962',4533824,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','235962',4533825,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','235962',4533826,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236316',4540097,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236316',4540098,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236316',4540099,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236316',4540100,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236316',4540101,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236316',4540102,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236317',4540103,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236317',4540104,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236317',4540105,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236317',4540106,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236317',4540107,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236317',4540108,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236324',4540281,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236324',4540282,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236324',4540283,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236324',4540284,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236324',4540285,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236324',4540286,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236332',4540388,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236332',4540389,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236332',4540390,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236332',4540391,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236332',4540392,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236332',4540393,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236334',4540435,'2683','400',351438.27,351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236334',4540436,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236334',4540437,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236334',4540438,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236334',4540439,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236334',4540440,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236340',4540545,'2683','400',351438.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236340',4540546,'2684','400',283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236340',4540547,'2685','400',185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236340',4540548,'2686','400',178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236340',4540549,'2687','401',69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236340',4540550,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236357',4540810,'2683','400',351438.27,351738.27,300.00,48600.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236357',4540811,'2684','400',283826.84,283826.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236357',4540812,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236357',4540813,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236357',4540814,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236357',4540815,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236359',4540870,'2683','400',351738.27,352083.29,345.02,55893.24,0.00,0.00,0.00,0.00,0.00),('5','173','904','236359',4540871,'2684','400',283826.84,284695.75,868.91,140763.42,0.00,0.00,0.00,0.00,0.00),('5','173','905','236359',4540872,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236359',4540873,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236359',4540874,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236359',4540875,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','236360',4540876,'2683','400',352083.29,352756.36,673.07,109037.34,0.00,0.00,0.00,0.00,0.00),('5','173','904','236360',4540877,'2684','400',284695.75,285439.50,743.75,120487.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','236360',4540878,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','236360',4540879,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','236360',4540880,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','236360',4540881,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237730',4564979,'2683','400',352756.36,353279.43,523.07,86306.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','237730',4564980,'2684','400',285439.50,285979.77,540.27,89144.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','237730',4564981,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237730',4564982,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237730',4564983,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237730',4564984,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237733',4565005,'2683','400',353279.43,355242.59,1963.16,323921.40,0.00,0.00,0.00,0.00,0.00),('5','173','904','237733',4565006,'2684','400',285979.77,286722.91,743.14,122618.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','237733',4565007,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237733',4565008,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237733',4565009,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237733',4565010,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237741',4565109,'2683','400',355242.59,355242.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237741',4565110,'2684','400',286722.91,287819.41,1096.50,180922.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','237741',4565111,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237741',4565112,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237741',4565113,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237741',4565114,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237743',4565136,'2683','400',355242.59,355242.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237743',4565137,'2684','400',287819.41,288998.59,1179.18,194564.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','237743',4565138,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237743',4565139,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237743',4565140,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237743',4565141,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237746',4565176,'2683','400',355242.59,355242.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237746',4565177,'2684','400',288998.59,290035.86,1037.27,171149.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','237746',4565178,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237746',4565179,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237746',4565180,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237746',4565181,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237747',4565182,'2683','400',355242.59,355242.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237747',4565183,'2684','400',290035.86,291095.37,1059.51,174819.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','237747',4565184,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237747',4565185,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237747',4565186,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237747',4565187,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237748',4565188,'2683','400',355242.59,355490.37,247.78,40883.70,0.00,0.00,0.00,0.00,0.00),('5','173','904','237748',4565189,'2684','400',291095.37,292338.67,1243.30,205144.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','237748',4565190,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237748',4565191,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237748',4565192,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237748',4565193,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237751',4565222,'2683','400',355490.37,356684.69,1194.32,197062.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','237751',4565223,'2684','400',292338.67,292921.60,582.93,96183.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','237751',4565224,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237751',4565225,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237751',4565226,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237751',4565227,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237752',4565228,'2683','400',356684.69,357329.58,644.89,106406.85,0.00,0.00,0.00,0.00,0.00),('5','173','904','237752',4565229,'2684','400',292921.60,294036.99,1115.39,184039.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','237752',4565230,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237752',4565231,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237752',4565232,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237752',4565233,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237754',4565238,'2683','400',357329.58,358949.70,1620.12,267319.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','237754',4565239,'2684','400',294036.99,294036.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237754',4565240,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237754',4565241,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237754',4565242,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237754',4565243,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237757',4565262,'2683','400',358949.70,359065.34,115.64,19080.60,0.00,0.00,0.00,0.00,0.00),('5','173','904','237757',4565263,'2684','400',294036.99,294871.99,835.00,137775.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237757',4565264,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237757',4565265,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237757',4565266,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237757',4565267,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237759',4565274,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237759',4565275,'2684','400',294871.99,296041.99,1170.00,193050.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237759',4565276,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237759',4565277,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237759',4565278,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237759',4565279,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237761',4565306,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237761',4565307,'2684','400',296041.99,296575.82,533.83,88081.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','237761',4565308,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237761',4565309,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237761',4565310,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237761',4565311,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237763',4565342,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237763',4565343,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237763',4565344,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237763',4565345,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237763',4565346,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237763',4565347,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237766',4565388,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','237766',4565389,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237766',4565390,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','237766',4565391,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','237766',4565392,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','237766',4565393,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238205',4572672,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238205',4572673,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238205',4572674,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238205',4572675,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','238205',4572676,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','238205',4572677,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238454',4576902,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238454',4576903,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238454',4576904,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238454',4576905,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','238454',4576906,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','238454',4576907,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238699',4581171,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238699',4581172,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238699',4581173,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238699',4581174,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','238699',4581175,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','238699',4581176,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238985',4586296,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','238985',4586297,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238985',4586298,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','238985',4586299,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','238985',4586300,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','238985',4586301,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239129',4588744,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239129',4588745,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239129',4588746,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239129',4588747,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','239129',4588748,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','239129',4588749,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239350',4592440,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239350',4592441,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239350',4592442,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239350',4592443,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','239350',4592444,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','239350',4592445,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239700',4598650,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239700',4598651,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239700',4598652,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239700',4598653,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','239700',4598654,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','239700',4598655,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239903',4602061,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','239903',4602062,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239903',4602063,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','239903',4602064,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','239903',4602065,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','239903',4602066,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','240055',4604731,'2683','400',359065.34,359065.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','240055',4604732,'2684','400',296575.82,296575.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','240055',4604733,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','240055',4604734,'2686','400',178845.07,178845.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','240055',4604735,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','240055',4604736,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','240341',4609719,'2683','400',359065.34,359663.94,598.60,98769.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','240341',4609720,'2684','400',296575.82,297962.45,1386.63,228793.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','240341',4609721,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','240341',4609722,'2686','400',178845.07,179051.09,206.02,33993.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','240341',4609723,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','240341',4609724,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','241811',4634486,'2683','400',359663.94,359854.94,191.00,31515.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','241811',4634487,'2684','400',297962.45,299390.54,1428.09,235634.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','241811',4634488,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','241811',4634489,'2686','400',179051.09,179051.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','241811',4634490,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','241811',4634491,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','242198',4641431,'2683','400',359854.94,361993.47,2138.53,352857.45,0.00,0.00,0.00,0.00,0.00),('5','173','904','242198',4641432,'2684','400',299390.54,299390.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','242198',4641433,'2685','400',185959.88,185959.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','242198',4641434,'2686','400',179051.09,179975.59,924.50,152542.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','242198',4641435,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','242198',4641436,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','242461',4645827,'2683','400',361993.47,362312.04,318.57,52564.05,0.00,0.00,0.00,0.00,0.00),('5','173','904','242461',4645828,'2684','400',299390.54,300302.17,911.63,150418.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','242461',4645829,'2685','400',185959.88,186150.85,190.97,31510.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','242461',4645830,'2686','400',179975.59,179975.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','242461',4645831,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','242461',4645832,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','242614',4648766,'2683','400',362312.04,362760.24,448.20,73953.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','242614',4648767,'2684','400',300302.17,300969.26,667.09,110069.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','242614',4648768,'2685','400',186150.85,186204.44,53.59,8842.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','242614',4648769,'2686','400',179975.59,180188.41,212.82,35115.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','242614',4648770,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','242614',4648771,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','242787',4651646,'2683','400',362760.24,362856.89,96.65,15947.25,0.00,0.00,0.00,0.00,0.00),('5','173','904','242787',4651647,'2684','400',300969.26,302247.90,1278.64,210975.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','242787',4651648,'2685','400',186204.44,186410.39,205.95,33981.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','242787',4651649,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','242787',4651650,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','242787',4651651,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247018',4724329,'2683','400',362856.89,362895.88,38.99,6433.35,0.00,0.00,0.00,0.00,0.00),('5','173','904','247018',4724330,'2684','400',302247.90,303717.02,1469.12,242404.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','247018',4724331,'2685','400',186410.39,186697.08,286.69,47303.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','247018',4724332,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247018',4724333,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247018',4724334,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247308',4729559,'2683','400',362895.88,362989.88,94.00,15510.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247308',4729560,'2684','400',303717.02,305144.45,1427.43,235525.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','247308',4729561,'2685','400',186697.08,187246.03,548.95,90576.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','247308',4729562,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247308',4729563,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247308',4729564,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247501',4732719,'2683','400',362989.88,362989.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247501',4732720,'2684','400',305144.45,306836.11,1691.66,279123.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','247501',4732721,'2685','400',187246.03,187246.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247501',4732722,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247501',4732723,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247501',4732724,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247509',4732835,'2683','400',362989.88,362989.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247509',4732836,'2684','400',306836.11,308177.29,1341.18,221294.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','247509',4732837,'2685','400',187246.03,187286.52,40.49,6680.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','247509',4732838,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247509',4732839,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247509',4732840,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247511',4732852,'2683','400',362989.88,362989.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247511',4732853,'2684','400',308177.29,309592.92,1415.63,233578.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','247511',4732854,'2685','400',187286.52,187454.93,168.41,27787.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','247511',4732855,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247511',4732856,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247511',4732857,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247514',4732929,'2683','400',362989.88,362989.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247514',4732930,'2684','400',309592.92,311011.19,1418.27,234014.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','247514',4732931,'2685','400',187454.93,187697.72,242.79,40060.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','247514',4732932,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247514',4732933,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247514',4732934,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247515',4732935,'2683','400',362989.88,363011.36,21.48,3544.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','247515',4732936,'2684','400',311011.19,312473.84,1462.65,241337.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','247515',4732937,'2685','400',187697.72,187723.20,25.48,4204.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','247515',4732938,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247515',4732939,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247515',4732940,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247516',4732941,'2683','400',363011.36,363011.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247516',4732942,'2684','400',312473.84,314375.43,1901.59,313762.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','247516',4732943,'2685','400',187723.20,187944.43,221.23,36502.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','247516',4732944,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247516',4732945,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247516',4732946,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247517',4732947,'2683','400',363011.36,363011.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247517',4732948,'2684','400',314375.43,315736.63,1361.20,224598.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247517',4732949,'2685','400',187944.43,188129.77,185.34,30581.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','247517',4732950,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247517',4732951,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247517',4732952,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247519',4732962,'2683','400',363011.36,363011.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247519',4732963,'2684','400',315736.63,317274.84,1538.21,253804.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','247519',4732964,'2685','400',188129.77,188179.29,49.52,8170.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','247519',4732965,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247519',4732966,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247519',4732967,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247521',4733034,'2683','400',363011.36,363230.73,219.37,36196.05,0.00,0.00,0.00,0.00,0.00),('5','173','904','247521',4733035,'2684','400',317274.84,318703.04,1428.20,235653.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247521',4733036,'2685','400',188179.29,188179.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247521',4733037,'2686','400',180188.41,180188.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247521',4733038,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247521',4733039,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247523',4733061,'2683','400',363230.73,363301.68,70.95,11706.75,0.00,0.00,0.00,0.00,0.00),('5','173','904','247523',4733062,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247523',4733063,'2685','400',188179.29,189171.44,992.15,163704.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','247523',4733064,'2686','400',180188.41,181181.06,992.65,163787.25,0.00,0.00,0.00,0.00,0.00),('5','173','906','247523',4733065,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247523',4733066,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247524',4733067,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247524',4733068,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247524',4733069,'2685','400',189171.44,189171.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247524',4733070,'2686','400',181181.06,182613.95,1432.89,236426.85,0.00,0.00,0.00,0.00,0.00),('5','173','906','247524',4733071,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247524',4733072,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247527',4733091,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247527',4733092,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247527',4733093,'2685','400',189171.44,189171.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247527',4733094,'2686','400',182613.95,184375.06,1761.11,290583.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','247527',4733095,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247527',4733096,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247528',4733097,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247528',4733098,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247528',4733099,'2685','400',189171.44,189171.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247528',4733100,'2686','400',184375.06,185823.28,1448.22,238956.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','247528',4733101,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247528',4733102,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247529',4733103,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247529',4733104,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247529',4733105,'2685','400',189171.44,190653.31,1481.87,244508.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','247529',4733106,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247529',4733107,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247529',4733108,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247531',4733131,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247531',4733132,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247531',4733133,'2685','400',190653.31,191119.12,465.81,76858.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','247531',4733134,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247531',4733135,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247531',4733136,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247536',4733233,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247536',4733234,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247536',4733235,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247536',4733236,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247536',4733237,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247536',4733238,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247537',4733239,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247537',4733240,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247537',4733241,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247537',4733242,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247537',4733243,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247537',4733244,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247538',4733245,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247538',4733246,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247538',4733247,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247538',4733248,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247538',4733249,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247538',4733250,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247539',4733251,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247539',4733252,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247539',4733253,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247539',4733254,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247539',4733255,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247539',4733256,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247541',4733273,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247541',4733274,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247541',4733275,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247541',4733276,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247541',4733277,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247541',4733278,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247542',4733279,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247542',4733280,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247542',4733281,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247542',4733282,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247542',4733283,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247542',4733284,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247543',4733285,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247543',4733286,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247543',4733287,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247543',4733288,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247543',4733289,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247543',4733290,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247546',4733336,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247546',4733337,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247546',4733338,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247546',4733339,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247546',4733340,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247546',4733341,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247773',4737285,'2683','400',363301.68,363301.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','247773',4737286,'2684','400',318703.04,318703.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247773',4737287,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','247773',4737288,'2686','400',185823.28,185823.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','247773',4737289,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','247773',4737290,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248027',4741478,'2683','400',363301.68,364414.80,1113.12,183664.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','248027',4741479,'2684','400',318703.04,319616.96,913.92,150796.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','248027',4741480,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248027',4741481,'2686','400',185823.28,186717.17,893.89,147491.85,0.00,0.00,0.00,0.00,0.00),('5','173','906','248027',4741482,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','248027',4741483,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248351',4747298,'2683','400',364414.80,368319.07,3904.27,644204.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','248351',4747299,'2684','400',319616.96,319616.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248351',4747300,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248351',4747301,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','248351',4747302,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','248351',4747303,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248504',4749804,'2683','400',368319.07,368319.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248504',4749805,'2684','400',319616.96,322104.54,2487.58,410450.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','248504',4749806,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248504',4749807,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','248504',4749808,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','248504',4749809,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248814',4755117,'2683','400',368319.07,371144.27,2825.20,466158.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','248814',4755118,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248814',4755119,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','248814',4755120,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','248814',4755121,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','248814',4755122,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','249241',4762225,'2683','400',371144.27,373074.83,1930.56,318542.40,0.00,0.00,0.00,0.00,0.00),('5','173','904','249241',4762226,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249241',4762227,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249241',4762228,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','249241',4762229,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','249241',4762230,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','249383',4764374,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','249383',4764375,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249383',4764376,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249383',4764377,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','249383',4764378,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','249383',4764379,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','249732',4770399,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','249732',4770400,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249732',4770401,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','249732',4770402,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','249732',4770403,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','249732',4770404,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250013',4775297,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250013',4775298,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250013',4775299,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250013',4775300,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','250013',4775301,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','250013',4775302,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250281',4779809,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250281',4779810,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250281',4779811,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250281',4779812,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','250281',4779813,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','250281',4779814,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250482',4782931,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250482',4782932,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250482',4782933,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250482',4782934,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','250482',4782935,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','250482',4782936,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250705',4786806,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250705',4786807,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250705',4786808,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250705',4786809,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','250705',4786810,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','250705',4786811,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250883',4789981,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','250883',4789982,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250883',4789983,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','250883',4789984,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','250883',4789985,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','250883',4789986,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251254',4796635,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251254',4796636,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251254',4796637,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251254',4796638,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','251254',4796639,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','251254',4796640,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251381',4798585,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251381',4798586,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251381',4798587,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251381',4798588,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','251381',4798589,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','251381',4798590,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251927',4808236,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','251927',4808237,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251927',4808238,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','251927',4808239,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','251927',4808240,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','251927',4808241,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252221',4813390,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252221',4813391,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252221',4813392,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252221',4813393,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','252221',4813394,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252221',4813395,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252420',4816947,'2683','400',373074.83,373074.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252420',4816948,'2684','400',322104.54,322104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252420',4816949,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252420',4816950,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','252420',4816951,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252420',4816952,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252595',4819953,'2683','400',373074.83,376957.05,3882.22,640566.30,0.00,0.00,0.00,0.00,0.00),('5','173','904','252595',4819954,'2684','400',322104.54,325652.54,3548.00,585420.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252595',4819955,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252595',4819956,'2686','400',186717.17,186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','252595',4819957,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252595',4819958,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252800',4823310,'2683','400',376957.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252800',4823311,'2684','400',325652.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252800',4823312,'2685','400',191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252800',4823313,'2686','400',186717.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','252800',4823314,'2687','401',69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252800',4823315,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252814',4823495,'2683','400',376957.05,376957.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252814',4823496,'2684','400',325652.54,325652.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252814',4823497,'2685','400',191119.12,191119.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252814',4823498,'2686','400',186717.17,191156.24,4439.07,732446.55,0.00,0.00,0.00,0.00,0.00),('5','173','906','252814',4823499,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252814',4823500,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252903',4825077,'2683','400',376957.05,376957.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','252903',4825078,'2684','400',325652.54,325652.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','252903',4825079,'2685','400',191119.12,193407.96,2288.84,377658.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','252903',4825080,'2686','400',191156.24,193507.80,2351.56,388007.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','252903',4825081,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','252903',4825082,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253311',4831830,'2683','400',376957.05,376957.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253311',4831831,'2684','400',325652.54,329414.56,3762.02,620733.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','253311',4831832,'2685','400',193407.96,193407.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253311',4831833,'2686','400',193507.80,193507.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','253311',4831834,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','253311',4831835,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253414',4833771,'2683','400',376957.05,376957.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253414',4833772,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253414',4833773,'2685','400',193407.96,195306.39,1898.43,313240.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','253414',4833774,'2686','400',193507.80,193809.19,301.39,49729.35,0.00,0.00,0.00,0.00,0.00),('5','173','906','253414',4833775,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','253414',4833776,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253560',4836098,'2683','400',376957.05,378537.95,1580.90,260848.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','253560',4836099,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253560',4836100,'2685','400',195306.39,195306.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253560',4836101,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','253560',4836102,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','253560',4836103,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253814',4840569,'2683','400',378537.95,378537.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','253814',4840570,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253814',4840571,'2685','400',195306.39,195826.39,520.00,85800.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','253814',4840572,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','253814',4840573,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','253814',4840574,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254377',4850569,'2683','400',378537.95,379552.98,1015.03,167479.95,0.00,0.00,0.00,0.00,0.00),('5','173','904','254377',4850570,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254377',4850571,'2685','400',195826.39,195826.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254377',4850572,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','254377',4850573,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','254377',4850574,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254419',4851324,'2683','400',379552.98,379552.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254419',4851325,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254419',4851326,'2685','400',195826.39,195826.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254419',4851327,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','254419',4851328,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','254419',4851329,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254572',4853749,'2683','400',379552.98,379552.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254572',4853750,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254572',4853751,'2685','400',195826.39,195826.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254572',4853752,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','254572',4853753,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','254572',4853754,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254813',4857945,'2683','400',379552.98,379552.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','254813',4857946,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254813',4857947,'2685','400',195826.39,195826.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','254813',4857948,'2686','400',193809.19,193809.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','254813',4857949,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','254813',4857950,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255020',4861423,'2683','400',379552.98,379552.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255020',4861424,'2684','400',329414.56,329414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','255020',4861425,'2685','400',195826.39,196324.95,498.56,82262.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','255020',4861426,'2686','400',193809.19,193963.14,153.95,25401.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','255020',4861427,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','255020',4861428,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255301',4866552,'2683','400',379552.98,381275.98,1723.00,284295.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255301',4866553,'2684','400',329414.56,330756.39,1341.83,221401.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','255301',4866554,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','255301',4866555,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','255301',4866556,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','255301',4866557,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255754',4873751,'2683','400',381275.98,381275.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255754',4873752,'2684','400',330756.39,333795.80,3039.41,501502.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','255754',4873753,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','255754',4873754,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','255754',4873755,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','255754',4873756,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','255906',4876470,'2683','400',381275.98,382831.06,1555.08,256588.20,0.00,0.00,0.00,0.00,0.00),('5','173','904','255906',4876471,'2684','400',333795.80,333795.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','255906',4876472,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','255906',4876473,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','255906',4876474,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','255906',4876475,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256342',4883425,'2683','400',382831.06,382831.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256342',4883426,'2684','400',333795.80,336100.56,2304.76,380285.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','256342',4883427,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256342',4883428,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','256342',4883429,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','256342',4883430,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256381',4884212,'2683','400',382831.06,382831.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256381',4884213,'2684','400',336100.56,338179.26,2078.70,342985.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','256381',4884214,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256381',4884215,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','256381',4884216,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','256381',4884217,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256590',4887784,'2683','400',382831.06,384031.38,1200.32,198052.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','256590',4887785,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256590',4887786,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256590',4887787,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','256590',4887788,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','256590',4887789,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256893',4892988,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','256893',4892989,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256893',4892990,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','256893',4892991,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','256893',4892992,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','256893',4892993,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257077',4896156,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257077',4896157,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257077',4896158,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257077',4896159,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257077',4896160,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257077',4896161,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257495',4903583,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257495',4903584,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257495',4903585,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257495',4903586,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257495',4903587,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257495',4903588,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257659',4906686,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257659',4906687,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257659',4906688,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257659',4906689,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257659',4906690,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257659',4906691,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257660',4906692,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257660',4906693,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257660',4906694,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257660',4906695,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257660',4906696,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257660',4906697,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257661',4906698,'2683','400',384031.38,384031.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257661',4906699,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257661',4906700,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257661',4906701,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257661',4906702,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257661',4906703,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257662',4906704,'2683','400',384031.38,385543.13,1511.75,249438.75,0.00,0.00,0.00,0.00,0.00),('5','173','904','257662',4906705,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257662',4906706,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257662',4906707,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257662',4906708,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257662',4906709,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257663',4906710,'2683','400',385543.13,387172.25,1629.12,268804.80,0.00,0.00,0.00,0.00,0.00),('5','173','904','257663',4906711,'2684','400',338179.26,338179.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257663',4906712,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257663',4906713,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257663',4906714,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257663',4906715,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257664',4906716,'2683','400',387172.25,389487.83,2315.58,382070.70,0.00,0.00,0.00,0.00,0.00),('5','173','904','257664',4906717,'2684','400',338179.26,340240.78,2061.52,340150.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257664',4906718,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257664',4906719,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257664',4906720,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257664',4906721,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257665',4906722,'2683','400',389487.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257665',4906723,'2684','400',340240.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257665',4906724,'2685','400',196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257665',4906725,'2686','400',193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257665',4906726,'2687','401',69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257665',4906727,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257666',4906728,'2683','400',389487.83,392385.39,2897.56,478097.40,0.00,0.00,0.00,0.00,0.00),('5','173','904','257666',4906729,'2684','400',340240.78,343551.16,3310.38,546212.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257666',4906730,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257666',4906731,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257666',4906732,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257666',4906733,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257667',4906734,'2683','400',392385.39,394620.69,2235.30,368824.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','257667',4906735,'2684','400',343551.16,345110.92,1559.76,257360.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257667',4906736,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257667',4906737,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257667',4906738,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257667',4906739,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257668',4906740,'2683','400',394620.69,397812.79,3192.10,526696.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','257668',4906741,'2684','400',345110.92,350464.67,5353.75,883368.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257668',4906742,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257668',4906743,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257668',4906744,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257668',4906745,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257669',4906746,'2683','400',397812.79,402225.69,4412.90,728128.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','257669',4906747,'2684','400',350464.67,352245.16,1780.49,293780.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257669',4906748,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257669',4906749,'2686','400',193963.14,193963.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257669',4906750,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257669',4906751,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257670',4906752,'2683','400',402225.69,406232.75,4007.06,661164.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','257670',4906753,'2684','400',352245.16,355860.17,3615.01,596476.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257670',4906754,'2685','400',196324.95,196324.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257670',4906755,'2686','400',193963.14,196493.68,2530.54,417539.10,0.00,0.00,0.00,0.00,0.00),('5','173','906','257670',4906756,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257670',4906757,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257671',4906758,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257671',4906759,'2684','400',355860.17,361705.55,5845.38,964487.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257671',4906760,'2685','400',196324.95,202822.84,6497.89,1072151.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257671',4906761,'2686','400',196493.68,196493.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257671',4906762,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257671',4906763,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257672',4906764,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257672',4906765,'2684','400',361705.55,368137.95,6432.40,1061346.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257672',4906766,'2685','400',202822.84,202822.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257672',4906767,'2686','400',196493.68,196493.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257672',4906768,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257672',4906769,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257673',4906770,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257673',4906771,'2684','400',368137.95,368137.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257673',4906772,'2685','400',202822.84,209737.43,6914.59,1140907.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257673',4906773,'2686','400',196493.68,196493.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257673',4906774,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257673',4906775,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257674',4906776,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257674',4906777,'2684','400',368137.95,368137.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257674',4906778,'2685','400',209737.43,209737.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257674',4906779,'2686','400',196493.68,201460.41,4966.73,819510.45,0.00,0.00,0.00,0.00,0.00),('5','173','906','257674',4906780,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257674',4906781,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257675',4906782,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257675',4906783,'2684','400',368137.95,370384.09,2246.14,370613.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257675',4906784,'2685','400',209737.43,209737.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257675',4906785,'2686','400',201460.41,201460.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257675',4906786,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257675',4906787,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257676',4906788,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257676',4906789,'2684','400',370384.09,370384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257676',4906790,'2685','400',209737.43,209737.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257676',4906791,'2686','400',201460.41,201460.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257676',4906792,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257676',4906793,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257677',4906794,'2683','400',406232.75,406232.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257677',4906795,'2684','400',370384.09,370384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257677',4906796,'2685','400',209737.43,209737.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257677',4906797,'2686','400',201460.41,201460.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257677',4906798,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257677',4906799,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257678',4906800,'2683','400',406232.75,406422.35,189.60,31284.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257678',4906801,'2684','400',370384.09,370674.05,289.96,47843.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257678',4906802,'2685','400',209737.43,210261.85,524.42,86529.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257678',4906803,'2686','400',201460.41,202058.24,597.83,98641.95,0.00,0.00,0.00,0.00,0.00),('5','173','906','257678',4906804,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257678',4906805,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257679',4906806,'2683','400',406422.35,412242.12,5819.77,960262.05,0.00,0.00,0.00,0.00,0.00),('5','173','904','257679',4906807,'2684','400',370674.05,370674.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257679',4906808,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257679',4906809,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257679',4906810,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257679',4906811,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257680',4906812,'2683','400',412242.12,412242.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257680',4906813,'2684','400',370674.05,375327.82,4653.77,767872.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257680',4906814,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257680',4906815,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257680',4906816,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257680',4906817,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257681',4906818,'2683','400',412242.12,413551.12,1309.00,215985.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257681',4906819,'2684','400',375327.82,378327.87,3000.05,495008.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257681',4906820,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257681',4906821,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257681',4906822,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257681',4906823,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257682',4906824,'2683','400',413551.12,413551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257682',4906825,'2684','400',378327.87,378327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257682',4906826,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257682',4906827,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257682',4906828,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257682',4906829,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257683',4906830,'2683','400',413551.12,413551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257683',4906831,'2684','400',378327.87,378327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257683',4906832,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257683',4906833,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257683',4906834,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257683',4906835,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257684',4906836,'2683','400',413551.12,413551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257684',4906837,'2684','400',378327.87,378327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257684',4906838,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257684',4906839,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257684',4906840,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257684',4906841,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257685',4906842,'2683','400',413551.12,413551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257685',4906843,'2684','400',378327.87,385878.52,7550.65,1245857.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257685',4906844,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257685',4906845,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257685',4906846,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257685',4906847,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257686',4906848,'2683','400',413551.12,419324.18,5773.06,952554.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','257686',4906849,'2684','400',385878.52,390115.22,4236.70,699055.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257686',4906850,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257686',4906851,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257686',4906852,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257686',4906853,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257687',4906854,'2683','400',419324.18,421317.65,1993.47,328922.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','257687',4906855,'2684','400',390115.22,390136.98,21.76,3590.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257687',4906856,'2685','400',210261.85,210261.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257687',4906857,'2686','400',202058.24,202058.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257687',4906858,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257687',4906859,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257688',4906860,'2683','400',421317.65,421317.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257688',4906861,'2684','400',390136.98,390136.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257688',4906862,'2685','400',210261.85,216795.06,6533.21,1077979.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257688',4906863,'2686','400',202058.24,211164.39,9106.15,1502514.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257688',4906864,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257688',4906865,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257689',4906866,'2683','400',421317.65,424062.22,2744.57,452854.05,0.00,0.00,0.00,0.00,0.00),('5','173','904','257689',4906867,'2684','400',390136.98,399653.58,9516.60,1570239.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257689',4906868,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257689',4906869,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257689',4906870,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257689',4906871,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257690',4906872,'2683','400',424062.22,426370.02,2307.80,380787.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257690',4906873,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257690',4906874,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257690',4906875,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257690',4906876,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257690',4906877,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257691',4906878,'2683','400',426370.02,429170.02,2800.00,462000.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257691',4906879,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257691',4906880,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257691',4906881,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257691',4906882,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257691',4906883,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257692',4906884,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257692',4906885,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257692',4906886,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257692',4906887,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257692',4906888,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257692',4906889,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257693',4906890,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257693',4906891,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257693',4906892,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257693',4906893,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257693',4906894,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257693',4906895,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257694',4906896,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257694',4906897,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257694',4906898,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257694',4906899,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257694',4906900,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257694',4906901,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257695',4906902,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257695',4906903,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257695',4906904,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257695',4906905,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257695',4906906,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257695',4906907,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257696',4906908,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257696',4906909,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257696',4906910,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257696',4906911,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257696',4906912,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257696',4906913,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257697',4906914,'2683','400',429170.02,429170.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257697',4906915,'2684','400',399653.58,399653.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257697',4906916,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257697',4906917,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257697',4906918,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257697',4906919,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257698',4906920,'2683','400',429170.02,434081.29,4911.27,810359.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','257698',4906921,'2684','400',399653.58,405254.00,5600.42,924069.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257698',4906922,'2685','400',216795.06,216795.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257698',4906923,'2686','400',211164.39,211164.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257698',4906924,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257698',4906925,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257699',4906926,'2683','400',434081.29,434081.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257699',4906927,'2684','400',405254.00,405254.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257699',4906928,'2685','400',216795.06,221553.10,4758.04,785076.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257699',4906929,'2686','400',211164.39,217349.10,6184.71,1020477.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','257699',4906930,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257699',4906931,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257700',4906932,'2683','400',434081.29,435869.00,1787.71,294972.15,0.00,0.00,0.00,0.00,0.00),('5','173','904','257700',4906933,'2684','400',405254.00,409935.53,4681.53,772452.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257700',4906934,'2685','400',221553.10,231568.21,10015.11,1652493.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257700',4906935,'2686','400',217349.10,225880.89,8531.79,1407745.35,0.00,0.00,0.00,0.00,0.00),('5','173','906','257700',4906936,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257700',4906937,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257701',4906938,'2683','400',435869.00,435869.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257701',4906939,'2684','400',409935.53,416209.96,6274.43,1035280.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257701',4906940,'2685','400',231568.21,241057.37,9489.16,1565711.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257701',4906941,'2686','400',225880.89,225880.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257701',4906942,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257701',4906943,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257702',4906944,'2683','400',435869.00,435874.39,5.39,889.35,0.00,0.00,0.00,0.00,0.00),('5','173','904','257702',4906945,'2684','400',416209.96,416209.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257702',4906946,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257702',4906947,'2686','400',225880.89,236902.64,11021.75,1818588.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257702',4906948,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257702',4906949,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257703',4906950,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257703',4906951,'2684','400',416209.96,422411.79,6201.83,1023301.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257703',4906952,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257703',4906953,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257703',4906954,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257703',4906955,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257704',4906956,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257704',4906957,'2684','400',422411.79,427940.57,5528.78,912248.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257704',4906958,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257704',4906959,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257704',4906960,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257704',4906961,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257705',4906962,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257705',4906963,'2684','400',427940.57,431098.87,3158.30,521119.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257705',4906964,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257705',4906965,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257705',4906966,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257705',4906967,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257706',4906968,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257706',4906969,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257706',4906970,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257706',4906971,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257706',4906972,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257706',4906973,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257707',4906974,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257707',4906975,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257707',4906976,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257707',4906977,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257707',4906978,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257707',4906979,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257708',4906980,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257708',4906981,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257708',4906982,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257708',4906983,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257708',4906984,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257708',4906985,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257709',4906986,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257709',4906987,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257709',4906988,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257709',4906989,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257709',4906990,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257709',4906991,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257710',4906992,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257710',4906993,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257710',4906994,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257710',4906995,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257710',4906996,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257710',4906997,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257711',4906998,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257711',4906999,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257711',4907000,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257711',4907001,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257711',4907002,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257711',4907003,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257712',4907004,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257712',4907005,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257712',4907006,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257712',4907007,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257712',4907008,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257712',4907009,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257713',4907010,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257713',4907011,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257713',4907012,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257713',4907013,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257713',4907014,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257713',4907015,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257714',4907016,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257714',4907017,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257714',4907018,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257714',4907019,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257714',4907020,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257714',4907021,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257715',4907022,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257715',4907023,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257715',4907024,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257715',4907025,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257715',4907026,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257715',4907027,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257716',4907028,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257716',4907029,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257716',4907030,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257716',4907031,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257716',4907032,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257716',4907033,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257717',4907034,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257717',4907035,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257717',4907036,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257717',4907037,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257717',4907038,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257717',4907039,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257718',4907040,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257718',4907041,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257718',4907042,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257718',4907043,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257718',4907044,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257718',4907045,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257719',4907046,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257719',4907047,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257719',4907048,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257719',4907049,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257719',4907050,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257719',4907051,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257720',4907052,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257720',4907053,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257720',4907054,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257720',4907055,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257720',4907056,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257720',4907057,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257721',4907058,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257721',4907059,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257721',4907060,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257721',4907061,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257721',4907062,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257721',4907063,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257722',4907064,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257722',4907065,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257722',4907066,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257722',4907067,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257722',4907068,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257722',4907069,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257723',4907070,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257723',4907071,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257723',4907072,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257723',4907073,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257723',4907074,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257723',4907075,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257724',4907076,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257724',4907077,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257724',4907078,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257724',4907079,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257724',4907080,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257724',4907081,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257725',4907082,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257725',4907083,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257725',4907084,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257725',4907085,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257725',4907086,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257725',4907087,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257726',4907088,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257726',4907089,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257726',4907090,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257726',4907091,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257726',4907092,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257726',4907093,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257727',4907094,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257727',4907095,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257727',4907096,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257727',4907097,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257727',4907098,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257727',4907099,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257728',4907100,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257728',4907101,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257728',4907102,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257728',4907103,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257728',4907104,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257728',4907105,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257729',4907106,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257729',4907107,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257729',4907108,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257729',4907109,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257729',4907110,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257729',4907111,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257730',4907112,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257730',4907113,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257730',4907114,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257730',4907115,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257730',4907116,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257730',4907117,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257731',4907118,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257731',4907119,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257731',4907120,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257731',4907121,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257731',4907122,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257731',4907123,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257732',4907124,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257732',4907125,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257732',4907126,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257732',4907127,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257732',4907128,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257732',4907129,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257733',4907130,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257733',4907131,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257733',4907132,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257733',4907133,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257733',4907134,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257733',4907135,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257734',4907136,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257734',4907137,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257734',4907138,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257734',4907139,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257734',4907140,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257734',4907141,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257735',4907142,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257735',4907143,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257735',4907144,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257735',4907145,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257735',4907146,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257735',4907147,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257736',4907148,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257736',4907149,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257736',4907150,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257736',4907151,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257736',4907152,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257736',4907153,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257737',4907154,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257737',4907155,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257737',4907156,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257737',4907157,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257737',4907158,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257737',4907159,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257738',4907160,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257738',4907161,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257738',4907162,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257738',4907163,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257738',4907164,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257738',4907165,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257739',4907166,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257739',4907167,'2684','400',431098.87,431098.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257739',4907168,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257739',4907169,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257739',4907170,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257739',4907171,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257740',4907172,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257740',4907173,'2684','400',431098.87,431748.87,650.00,107250.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257740',4907174,'2685','400',241057.37,241057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257740',4907175,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257740',4907176,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257740',4907177,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257741',4907178,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257741',4907179,'2684','400',431748.87,433629.38,1880.51,310284.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257741',4907180,'2685','400',241057.37,243089.87,2032.50,335362.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257741',4907181,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257741',4907182,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257741',4907183,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257742',4907184,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257742',4907185,'2684','400',433629.38,436672.63,3043.25,502136.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257742',4907186,'2685','400',243089.87,245032.53,1942.66,320538.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257742',4907187,'2686','400',236902.64,236902.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257742',4907188,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257742',4907189,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257743',4907190,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257743',4907191,'2684','400',436672.63,437550.32,877.69,144818.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257743',4907192,'2685','400',245032.53,245032.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257743',4907193,'2686','400',236902.64,239843.19,2940.55,485190.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257743',4907194,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257743',4907195,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257744',4907196,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257744',4907197,'2684','400',437550.32,438652.21,1101.89,181811.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257744',4907198,'2685','400',245032.53,247832.39,2799.86,461976.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257744',4907199,'2686','400',239843.19,239843.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257744',4907200,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257744',4907201,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257745',4907202,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257745',4907203,'2684','400',438652.21,438652.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257745',4907204,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257745',4907205,'2686','400',239843.19,244052.30,4209.11,694503.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','257745',4907206,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257745',4907207,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257746',4907208,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257746',4907209,'2684','400',438652.21,440115.76,1463.55,241485.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257746',4907210,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257746',4907211,'2686','400',244052.30,246779.54,2727.24,449994.60,0.00,0.00,0.00,0.00,0.00),('5','173','906','257746',4907212,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257746',4907213,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257747',4907214,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257747',4907215,'2684','400',440115.76,443197.83,3082.07,508541.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257747',4907216,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257747',4907217,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257747',4907218,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257747',4907219,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257748',4907220,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257748',4907221,'2684','400',443197.83,447050.80,3852.97,635740.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257748',4907222,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257748',4907223,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257748',4907224,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257748',4907225,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257749',4907226,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257749',4907227,'2684','400',447050.80,450258.35,3207.55,529245.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257749',4907228,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257749',4907229,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257749',4907230,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257749',4907231,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257750',4907232,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257750',4907233,'2684','400',450258.35,452972.37,2714.02,447813.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257750',4907234,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257750',4907235,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257750',4907236,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257750',4907237,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257751',4907238,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257751',4907239,'2684','400',452972.37,455641.25,2668.88,440365.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257751',4907240,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257751',4907241,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257751',4907242,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257751',4907243,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257752',4907244,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257752',4907245,'2684','400',455641.25,457461.62,1820.37,300361.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257752',4907246,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257752',4907247,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257752',4907248,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257752',4907249,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257753',4907250,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257753',4907251,'2684','400',457461.62,458061.64,600.02,99003.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257753',4907252,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257753',4907253,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257753',4907254,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257753',4907255,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257754',4907256,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257754',4907257,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257754',4907258,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257754',4907259,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257754',4907260,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257754',4907261,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257755',4907262,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257755',4907263,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257755',4907264,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257755',4907265,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257755',4907266,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257755',4907267,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257756',4907268,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257756',4907269,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257756',4907270,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257756',4907271,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257756',4907272,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257756',4907273,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257757',4907274,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257757',4907275,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257757',4907276,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257757',4907277,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257757',4907278,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257757',4907279,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257758',4907280,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257758',4907281,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257758',4907282,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257758',4907283,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257758',4907284,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257758',4907285,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257759',4907286,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257759',4907287,'2684','400',458061.64,458061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257759',4907288,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257759',4907289,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257759',4907290,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257759',4907291,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257760',4907292,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257760',4907293,'2684','400',458061.64,458621.64,560.00,92400.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257760',4907294,'2685','400',247832.39,247832.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257760',4907295,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257760',4907296,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257760',4907297,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257761',4907298,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257761',4907299,'2684','400',458621.64,458621.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257761',4907300,'2685','400',247832.39,252774.59,4942.20,815463.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257761',4907301,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257761',4907302,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257761',4907303,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257762',4907304,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257762',4907305,'2684','400',458621.64,463350.70,4729.06,780294.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257762',4907306,'2685','400',252774.59,253103.33,328.74,54242.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257762',4907307,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257762',4907308,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257762',4907309,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257763',4907310,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257763',4907311,'2684','400',463350.70,463350.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257763',4907312,'2685','400',253103.33,258415.11,5311.78,876443.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257763',4907313,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257763',4907314,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257763',4907315,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257764',4907316,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257764',4907317,'2684','400',463350.70,463350.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257764',4907318,'2685','400',258415.11,263103.33,4688.22,773556.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257764',4907319,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257764',4907320,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257764',4907321,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257765',4907322,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257765',4907323,'2684','400',463350.70,463350.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257765',4907324,'2685','400',263103.33,267808.69,4705.36,776384.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257765',4907325,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257765',4907326,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257765',4907327,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257766',4907328,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257766',4907329,'2684','400',463350.70,465962.20,2611.50,430897.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257766',4907330,'2685','400',267808.69,269117.69,1309.00,215985.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257766',4907331,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257766',4907332,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257766',4907333,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257767',4907334,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257767',4907335,'2684','400',465962.20,470041.60,4079.40,673101.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257767',4907336,'2685','400',269117.69,269117.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257767',4907337,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257767',4907338,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257767',4907339,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257768',4907340,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257768',4907341,'2684','400',470041.60,474195.55,4153.95,685401.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257768',4907342,'2685','400',269117.69,269117.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257768',4907343,'2686','400',246779.54,246779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257768',4907344,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257768',4907345,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257769',4907346,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257769',4907347,'2684','400',474195.55,474195.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257769',4907348,'2685','400',269117.69,269961.91,844.22,139296.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257769',4907349,'2686','400',246779.54,249781.36,3001.82,495300.30,0.00,0.00,0.00,0.00,0.00),('5','173','906','257769',4907350,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257769',4907351,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257770',4907352,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257770',4907353,'2684','400',474195.55,477140.51,2944.96,485918.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257770',4907354,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257770',4907355,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257770',4907356,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257770',4907357,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257771',4907358,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257771',4907359,'2684','400',477140.51,478340.66,1200.15,198024.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257771',4907360,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257771',4907361,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257771',4907362,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257771',4907363,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257772',4907364,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257772',4907365,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257772',4907366,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257772',4907367,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257772',4907368,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257772',4907369,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257773',4907370,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257773',4907371,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257773',4907372,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257773',4907373,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257773',4907374,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257773',4907375,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257774',4907376,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257774',4907377,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257774',4907378,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257774',4907379,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257774',4907380,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257774',4907381,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257775',4907382,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257775',4907383,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257775',4907384,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257775',4907385,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257775',4907386,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257775',4907387,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257776',4907388,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257776',4907389,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257776',4907390,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257776',4907391,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257776',4907392,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257776',4907393,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257777',4907394,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257777',4907395,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257777',4907396,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257777',4907397,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257777',4907398,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257777',4907399,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257778',4907400,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257778',4907401,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257778',4907402,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257778',4907403,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257778',4907404,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257778',4907405,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257779',4907406,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257779',4907407,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257779',4907408,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257779',4907409,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257779',4907410,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257779',4907411,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257780',4907412,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257780',4907413,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257780',4907414,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257780',4907415,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257780',4907416,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257780',4907417,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257781',4907418,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257781',4907419,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257781',4907420,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257781',4907421,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257781',4907422,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257781',4907423,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257782',4907424,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257782',4907425,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257782',4907426,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257782',4907427,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257782',4907428,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257782',4907429,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257783',4907430,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257783',4907431,'2684','400',478340.66,478340.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257783',4907432,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257783',4907433,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257783',4907434,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257783',4907435,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257784',4907436,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257784',4907437,'2684','400',478340.66,481288.72,2948.06,486429.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257784',4907438,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257784',4907439,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257784',4907440,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257784',4907441,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257785',4907442,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257785',4907443,'2684','400',481288.72,486340.64,5051.92,833566.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257785',4907444,'2685','400',269961.91,269961.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257785',4907445,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257785',4907446,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257785',4907447,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257786',4907448,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257786',4907449,'2684','400',486340.64,486340.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257786',4907450,'2685','400',269961.91,274663.96,4702.05,775838.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257786',4907451,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257786',4907452,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257786',4907453,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257787',4907454,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257787',4907455,'2684','400',486340.64,491042.70,4702.06,775839.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257787',4907456,'2685','400',274663.96,274663.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257787',4907457,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257787',4907458,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257787',4907459,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257788',4907460,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257788',4907461,'2684','400',491042.70,499164.46,8121.76,1340090.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257788',4907462,'2685','400',274663.96,274663.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257788',4907463,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257788',4907464,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257788',4907465,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257789',4907466,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257789',4907467,'2684','400',499164.46,506364.46,7200.00,1188000.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257789',4907468,'2685','400',274663.96,274663.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257789',4907469,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257789',4907470,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257789',4907471,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257790',4907472,'2683','400',435874.39,435874.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257790',4907473,'2684','400',506364.46,511870.63,5506.17,908518.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257790',4907474,'2685','400',274663.96,274663.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257790',4907475,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257790',4907476,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257790',4907477,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257791',4907478,'2683','400',435874.39,436419.54,545.15,89949.75,0.00,0.00,0.00,0.00,0.00),('5','173','904','257791',4907479,'2684','400',511870.63,511870.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257791',4907480,'2685','400',274663.96,280691.90,6027.94,994610.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257791',4907481,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257791',4907482,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257791',4907483,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257792',4907484,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257792',4907485,'2684','400',511870.63,511870.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257792',4907486,'2685','400',280691.90,285870.18,5178.28,854416.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257792',4907487,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257792',4907488,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257792',4907489,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257793',4907490,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257793',4907491,'2684','400',511870.63,511870.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257793',4907492,'2685','400',285870.18,290691.89,4821.71,795582.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257793',4907493,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257793',4907494,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257793',4907495,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257794',4907496,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257794',4907497,'2684','400',511870.63,516876.81,5006.18,826019.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257794',4907498,'2685','400',290691.89,290691.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257794',4907499,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257794',4907500,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257794',4907501,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257795',4907502,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257795',4907503,'2684','400',516876.81,521870.63,4993.82,823980.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257795',4907504,'2685','400',290691.89,290691.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257795',4907505,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257795',4907506,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257795',4907507,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257796',4907508,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257796',4907509,'2684','400',521870.63,525952.93,4082.30,673579.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257796',4907510,'2685','400',290691.89,290691.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257796',4907511,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257796',4907512,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257796',4907513,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257797',4907514,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257797',4907515,'2684','400',525952.93,529673.63,3720.70,613915.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257797',4907516,'2685','400',290691.89,290691.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257797',4907517,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257797',4907518,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257797',4907519,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257798',4907520,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257798',4907521,'2684','400',529673.63,533131.83,3458.20,570603.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257798',4907522,'2685','400',290691.89,290691.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257798',4907523,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257798',4907524,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257798',4907525,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257799',4907526,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257799',4907527,'2684','400',533131.83,533131.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257799',4907528,'2685','400',290691.89,293696.79,3004.90,495808.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257799',4907529,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257799',4907530,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257799',4907531,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257800',4907532,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257800',4907533,'2684','400',533131.83,533131.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257800',4907534,'2685','400',293696.79,296618.38,2921.59,482062.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257800',4907535,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257800',4907536,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257800',4907537,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257801',4907538,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257801',4907539,'2684','400',533131.83,533131.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257801',4907540,'2685','400',296618.38,299121.78,2503.40,413061.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257801',4907541,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257801',4907542,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257801',4907543,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257802',4907544,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257802',4907545,'2684','400',533131.83,534740.54,1608.71,265437.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257802',4907546,'2685','400',299121.78,299121.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257802',4907547,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257802',4907548,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257802',4907549,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257803',4907550,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257803',4907551,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257803',4907552,'2685','400',299121.78,301122.86,2001.08,330178.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257803',4907553,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257803',4907554,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257803',4907555,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257804',4907556,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257804',4907557,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257804',4907558,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257804',4907559,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257804',4907560,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257804',4907561,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257805',4907562,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257805',4907563,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257805',4907564,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257805',4907565,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257805',4907566,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257805',4907567,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257806',4907568,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257806',4907569,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257806',4907570,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257806',4907571,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257806',4907572,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257806',4907573,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257807',4907574,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257807',4907575,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257807',4907576,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257807',4907577,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257807',4907578,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257807',4907579,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257808',4907580,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257808',4907581,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257808',4907582,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257808',4907583,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257808',4907584,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257808',4907585,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257809',4907586,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257809',4907587,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257809',4907588,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257809',4907589,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257809',4907590,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257809',4907591,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257810',4907592,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257810',4907593,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257810',4907594,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257810',4907595,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257810',4907596,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257810',4907597,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257811',4907598,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257811',4907599,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257811',4907600,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257811',4907601,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257811',4907602,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257811',4907603,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257812',4907604,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257812',4907605,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257812',4907606,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257812',4907607,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257812',4907608,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257812',4907609,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257813',4907610,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257813',4907611,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257813',4907612,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257813',4907613,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257813',4907614,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257813',4907615,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257814',4907616,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257814',4907617,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257814',4907618,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257814',4907619,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257814',4907620,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257814',4907621,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257815',4907622,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257815',4907623,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257815',4907624,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257815',4907625,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257815',4907626,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257815',4907627,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257816',4907628,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257816',4907629,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257816',4907630,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257816',4907631,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257816',4907632,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257816',4907633,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257817',4907634,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257817',4907635,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257817',4907636,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257817',4907637,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257817',4907638,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257817',4907639,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257818',4907640,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257818',4907641,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257818',4907642,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257818',4907643,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257818',4907644,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257818',4907645,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257819',4907646,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257819',4907647,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257819',4907648,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257819',4907649,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257819',4907650,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257819',4907651,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257820',4907652,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257820',4907653,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257820',4907654,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257820',4907655,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257820',4907656,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257820',4907657,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257821',4907658,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257821',4907659,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257821',4907660,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257821',4907661,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257821',4907662,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257821',4907663,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257822',4907664,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257822',4907665,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257822',4907666,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257822',4907667,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257822',4907668,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257822',4907669,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257823',4907670,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257823',4907671,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257823',4907672,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257823',4907673,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257823',4907674,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257823',4907675,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257824',4907676,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257824',4907677,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257824',4907678,'2685','400',301122.86,301122.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257824',4907679,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257824',4907680,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257824',4907681,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257825',4907682,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257825',4907683,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257825',4907684,'2685','400',301122.86,301908.91,786.05,145419.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257825',4907685,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257825',4907686,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257825',4907687,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257826',4907688,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257826',4907689,'2684','400',534740.54,534740.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257826',4907690,'2685','400',301908.91,306346.81,4437.90,821011.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257826',4907691,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257826',4907692,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257826',4907693,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257827',4907694,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257827',4907695,'2684','400',534740.54,540302.64,5562.10,1028988.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257827',4907696,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257827',4907697,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257827',4907698,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257827',4907699,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257828',4907700,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257828',4907701,'2684','400',540302.64,545762.89,5460.25,1010146.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257828',4907702,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257828',4907703,'2686','400',249781.36,249781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257828',4907704,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257828',4907705,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257829',4907706,'2683','400',436419.54,436419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257829',4907707,'2684','400',545762.89,545762.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257829',4907708,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257829',4907709,'2686','400',249781.36,254321.11,4539.75,844393.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','257829',4907710,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257829',4907711,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257830',4907712,'2683','400',436419.54,438509.92,2090.38,386720.30,0.00,0.00,0.00,0.00,0.00),('5','173','904','257830',4907713,'2684','400',545762.89,549079.34,3316.45,613543.25,0.00,0.00,0.00,0.00,0.00),('5','173','905','257830',4907714,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257830',4907715,'2686','400',254321.11,254321.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257830',4907716,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257830',4907717,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257831',4907718,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257831',4907719,'2684','400',549079.34,553172.51,4093.17,757236.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257831',4907720,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257831',4907721,'2686','400',254321.11,254321.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257831',4907722,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257831',4907723,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257832',4907724,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257832',4907725,'2684','400',553172.51,556675.48,3502.97,648049.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257832',4907726,'2685','400',306346.81,306346.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257832',4907727,'2686','400',254321.11,254321.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257832',4907728,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257832',4907729,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257833',4907730,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257833',4907731,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257833',4907732,'2685','400',306346.81,309343.64,2996.83,554413.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257833',4907733,'2686','400',254321.11,254321.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257833',4907734,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257833',4907735,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257834',4907736,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257834',4907737,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257834',4907738,'2685','400',309343.64,309343.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257834',4907739,'2686','400',254321.11,257186.32,2865.21,530063.85,0.00,0.00,0.00,0.00,0.00),('5','173','906','257834',4907740,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257834',4907741,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257835',4907742,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257835',4907743,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257835',4907744,'2685','400',309343.64,311507.51,2163.87,400315.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257835',4907745,'2686','400',257186.32,257772.27,585.95,108400.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257835',4907746,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257835',4907747,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257836',4907748,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257836',4907749,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257836',4907750,'2685','400',311507.51,313507.51,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257836',4907751,'2686','400',257772.27,259776.16,2003.89,370719.65,0.00,0.00,0.00,0.00,0.00),('5','173','906','257836',4907752,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257836',4907753,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257837',4907754,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257837',4907755,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257837',4907756,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257837',4907757,'2686','400',259776.16,262786.33,3010.17,556881.45,0.00,0.00,0.00,0.00,0.00),('5','173','906','257837',4907758,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257837',4907759,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257838',4907760,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257838',4907761,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257838',4907762,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257838',4907763,'2686','400',262786.33,264007.92,1221.59,225994.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','257838',4907764,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257838',4907765,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257839',4907766,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257839',4907767,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257839',4907768,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257839',4907769,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257839',4907770,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257839',4907771,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257840',4907772,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257840',4907773,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257840',4907774,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257840',4907775,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257840',4907776,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257840',4907777,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257841',4907778,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257841',4907779,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257841',4907780,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257841',4907781,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257841',4907782,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257841',4907783,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257842',4907784,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257842',4907785,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257842',4907786,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257842',4907787,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257842',4907788,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257842',4907789,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257843',4907790,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257843',4907791,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257843',4907792,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257843',4907793,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257843',4907794,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257843',4907795,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257844',4907796,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257844',4907797,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257844',4907798,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257844',4907799,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257844',4907800,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257844',4907801,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257845',4907802,'2683','400',438509.92,438509.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257845',4907803,'2684','400',556675.48,556675.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257845',4907804,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257845',4907805,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257845',4907806,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257845',4907807,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257846',4907808,'2683','400',438509.92,439028.14,518.22,95870.70,0.00,0.00,0.00,0.00,0.00),('5','173','904','257846',4907809,'2684','400',556675.48,557361.47,685.99,126908.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257846',4907810,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257846',4907811,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257846',4907812,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257846',4907813,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257847',4907814,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257847',4907815,'2684','400',557361.47,561775.98,4414.51,816684.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257847',4907816,'2685','400',313507.51,313507.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257847',4907817,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257847',4907818,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257847',4907819,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257848',4907820,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257848',4907821,'2684','400',561775.98,565704.55,3928.57,726785.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257848',4907822,'2685','400',313507.51,314478.04,970.53,179548.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257848',4907823,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257848',4907824,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257848',4907825,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257849',4907826,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257849',4907827,'2684','400',565704.55,568210.56,2506.01,463611.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257849',4907828,'2685','400',314478.04,315962.03,1483.99,274538.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257849',4907829,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257849',4907830,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257849',4907831,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257850',4907832,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257850',4907833,'2684','400',568210.56,571013.68,2803.12,518577.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257850',4907834,'2685','400',315962.03,315962.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257850',4907835,'2686','400',264007.92,264007.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257850',4907836,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257850',4907837,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257851',4907838,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257851',4907839,'2684','400',571013.68,573204.14,2190.46,405235.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257851',4907840,'2685','400',315962.03,315962.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257851',4907841,'2686','400',264007.92,265578.02,1570.10,290468.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','257851',4907842,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257851',4907843,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257852',4907844,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257852',4907845,'2684','400',573204.14,573204.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257852',4907846,'2685','400',315962.03,318365.11,2403.08,444569.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257852',4907847,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257852',4907848,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257852',4907849,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257853',4907850,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257853',4907851,'2684','400',573204.14,574607.34,1403.20,259592.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257853',4907852,'2685','400',318365.11,318365.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257853',4907853,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257853',4907854,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257853',4907855,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257854',4907856,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257854',4907857,'2684','400',574607.34,576052.94,1445.60,267436.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257854',4907858,'2685','400',318365.11,321668.38,3303.27,611104.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257854',4907859,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257854',4907860,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257854',4907861,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257855',4907862,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257855',4907863,'2684','400',576052.94,577803.80,1750.86,323909.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257855',4907864,'2685','400',321668.38,322259.25,590.87,109310.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257855',4907865,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257855',4907866,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257855',4907867,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257856',4907868,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257856',4907869,'2684','400',577803.80,580724.50,2920.70,540329.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257856',4907870,'2685','400',322259.25,324048.45,1789.20,331002.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257856',4907871,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257856',4907872,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257856',4907873,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257857',4907874,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257857',4907875,'2684','400',580724.50,582026.30,1301.80,240833.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257857',4907876,'2685','400',324048.45,327437.07,3388.62,626894.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257857',4907877,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257857',4907878,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257857',4907879,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257858',4907880,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257858',4907881,'2684','400',582026.30,584135.20,2108.90,390146.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257858',4907882,'2685','400',327437.07,329563.13,2126.06,393321.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257858',4907883,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257858',4907884,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257858',4907885,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257859',4907886,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257859',4907887,'2684','400',584135.20,587144.19,3008.99,556663.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257859',4907888,'2685','400',329563.13,331204.26,1641.13,303609.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257859',4907889,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257859',4907890,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257859',4907891,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257860',4907892,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257860',4907893,'2684','400',587144.19,590994.66,3850.47,712336.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257860',4907894,'2685','400',331204.26,332314.49,1110.23,205392.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257860',4907895,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257860',4907896,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257860',4907897,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257861',4907898,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257861',4907899,'2684','400',590994.66,593059.77,2065.11,382045.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257861',4907900,'2685','400',332314.49,334532.58,2218.09,410346.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257861',4907901,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257861',4907902,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257861',4907903,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257862',4907904,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257862',4907905,'2684','400',593059.77,595758.23,2698.46,499215.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257862',4907906,'2685','400',334532.58,335883.95,1351.37,250003.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257862',4907907,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257862',4907908,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257862',4907909,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257863',4907910,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257863',4907911,'2684','400',595758.23,597957.90,2199.67,406938.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257863',4907912,'2685','400',335883.95,338342.48,2458.53,454828.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257863',4907913,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257863',4907914,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257863',4907915,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257864',4907916,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257864',4907917,'2684','400',597957.90,600848.08,2890.18,534683.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257864',4907918,'2685','400',338342.48,340194.20,1851.72,342568.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257864',4907919,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257864',4907920,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257864',4907921,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257865',4907922,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257865',4907923,'2684','400',600848.08,603108.08,2260.00,418100.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257865',4907924,'2685','400',340194.20,341785.01,1590.81,294299.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257865',4907925,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257865',4907926,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257865',4907927,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257866',4907928,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257866',4907929,'2684','400',603108.08,607844.30,4736.22,876200.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257866',4907930,'2685','400',341785.01,341785.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257866',4907931,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257866',4907932,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257866',4907933,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257867',4907934,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257867',4907935,'2684','400',607844.30,609370.38,1526.08,282324.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257867',4907936,'2685','400',341785.01,346288.57,4503.56,833158.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257867',4907937,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257867',4907938,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257867',4907939,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257868',4907940,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257868',4907941,'2684','400',609370.38,609370.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257868',4907942,'2685','400',346288.57,352405.26,6116.69,1131587.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257868',4907943,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257868',4907944,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257868',4907945,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257869',4907946,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257869',4907947,'2684','400',609370.38,613887.57,4517.19,835680.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257869',4907948,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257869',4907949,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257869',4907950,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257869',4907951,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257870',4907952,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257870',4907953,'2684','400',613887.57,617030.70,3143.13,581479.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257870',4907954,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257870',4907955,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257870',4907956,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257870',4907957,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257871',4907958,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257871',4907959,'2684','400',617030.70,620041.88,3011.18,560079.48,0.00,0.00,0.00,0.00,0.00),('5','173','905','257871',4907960,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257871',4907961,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257871',4907962,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257871',4907963,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257872',4907964,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257872',4907965,'2684','400',620041.88,622088.69,2046.81,378659.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257872',4907966,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257872',4907967,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257872',4907968,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257872',4907969,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257873',4907970,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257873',4907971,'2684','400',622088.69,624332.46,2243.77,415097.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257873',4907972,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257873',4907973,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257873',4907974,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257873',4907975,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257874',4907976,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257874',4907977,'2684','400',624332.46,627347.66,3015.20,557812.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257874',4907978,'2685','400',352405.26,352405.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257874',4907979,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257874',4907980,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257874',4907981,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257875',4907982,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257875',4907983,'2684','400',627347.66,629029.86,1682.20,311207.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257875',4907984,'2685','400',352405.26,352771.18,365.92,67695.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257875',4907985,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257875',4907986,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257875',4907987,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257876',4907988,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257876',4907989,'2684','400',629029.86,630385.88,1356.02,250863.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257876',4907990,'2685','400',352771.18,353463.14,691.96,128012.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257876',4907991,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257876',4907992,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257876',4907993,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257877',4907994,'2683','400',439028.14,439028.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257877',4907995,'2684','400',630385.88,632309.96,1924.08,355954.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257877',4907996,'2685','400',353463.14,354359.56,896.42,165837.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257877',4907997,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257877',4907998,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257877',4907999,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257878',4908000,'2683','400',439028.14,440399.00,1370.86,253609.10,0.00,0.00,0.00,0.00,0.00),('5','173','904','257878',4908001,'2684','400',632309.96,634219.83,1909.87,353325.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257878',4908002,'2685','400',354359.56,355108.32,748.76,138520.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257878',4908003,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257878',4908004,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257878',4908005,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257879',4908006,'2683','400',440399.00,441146.70,747.70,138324.50,0.00,0.00,0.00,0.00,0.00),('5','173','904','257879',4908007,'2684','400',634219.83,634219.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257879',4908008,'2685','400',355108.32,356427.72,1319.40,244089.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257879',4908009,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257879',4908010,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257879',4908011,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257880',4908012,'2683','400',441146.70,441146.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257880',4908013,'2684','400',634219.83,634219.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257880',4908014,'2685','400',356427.72,359002.26,2574.54,476289.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257880',4908015,'2686','400',265578.02,265578.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257880',4908016,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257880',4908017,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257881',4908018,'2683','400',441146.70,441146.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257881',4908019,'2684','400',634219.83,634651.19,431.36,79801.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257881',4908020,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257881',4908021,'2686','400',265578.02,267278.02,1700.00,314500.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257881',4908022,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257881',4908023,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257882',4908024,'2683','400',441146.70,443501.84,2355.14,435700.90,0.00,0.00,0.00,0.00,0.00),('5','173','904','257882',4908025,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257882',4908026,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257882',4908027,'2686','400',267278.02,267329.17,51.15,9462.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257882',4908028,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257882',4908029,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257883',4908030,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257883',4908031,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257883',4908032,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257883',4908033,'2686','400',267329.17,269337.41,2008.24,371524.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','257883',4908034,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257883',4908035,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257884',4908036,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257884',4908037,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257884',4908038,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257884',4908039,'2686','400',269337.41,271493.16,2155.75,398813.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257884',4908040,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257884',4908041,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257885',4908042,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257885',4908043,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257885',4908044,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257885',4908045,'2686','400',271493.16,273695.23,2202.07,407382.95,0.00,0.00,0.00,0.00,0.00),('5','173','906','257885',4908046,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257885',4908047,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257886',4908048,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257886',4908049,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257886',4908050,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257886',4908051,'2686','400',273695.23,274493.84,798.61,147742.85,0.00,0.00,0.00,0.00,0.00),('5','173','906','257886',4908052,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257886',4908053,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257887',4908054,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257887',4908055,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257887',4908056,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257887',4908057,'2686','400',274493.84,274493.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257887',4908058,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257887',4908059,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257888',4908060,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257888',4908061,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257888',4908062,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257888',4908063,'2686','400',274493.84,274493.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257888',4908064,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257888',4908065,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257889',4908066,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257889',4908067,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257889',4908068,'2685','400',359002.26,359002.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257889',4908069,'2686','400',274493.84,274493.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257889',4908070,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257889',4908071,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257890',4908072,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257890',4908073,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257890',4908074,'2685','400',359002.26,359751.00,748.74,138516.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257890',4908075,'2686','400',274493.84,274493.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257890',4908076,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257890',4908077,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257891',4908078,'2683','400',443501.84,443501.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257891',4908079,'2684','400',634651.19,634651.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257891',4908080,'2685','400',359751.00,360695.46,944.46,174725.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257891',4908081,'2686','400',274493.84,275581.19,1087.35,201159.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257891',4908082,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257891',4908083,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257892',4908084,'2683','400',443501.84,443531.84,30.00,5550.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257892',4908085,'2684','400',634651.19,635349.42,698.23,129172.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257892',4908086,'2685','400',360695.46,360956.40,260.94,48273.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257892',4908087,'2686','400',275581.19,275796.99,215.80,39923.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257892',4908088,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257892',4908089,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257893',4908090,'2683','400',443531.84,444026.62,494.78,91534.30,0.00,0.00,0.00,0.00,0.00),('5','173','904','257893',4908091,'2684','400',635349.42,636146.77,797.35,147509.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257893',4908092,'2685','400',360956.40,360956.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257893',4908093,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257893',4908094,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257893',4908095,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257894',4908096,'2683','400',444026.62,444102.83,76.21,14098.85,0.00,0.00,0.00,0.00,0.00),('5','173','904','257894',4908097,'2684','400',636146.77,636966.34,819.57,151620.45,0.00,0.00,0.00,0.00,0.00),('5','173','905','257894',4908098,'2685','400',360956.40,361382.95,426.55,78911.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257894',4908099,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257894',4908100,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257894',4908101,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257895',4908102,'2683','400',444102.83,444135.26,32.43,5999.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','257895',4908103,'2684','400',636966.34,638106.66,1140.32,210959.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257895',4908104,'2685','400',361382.95,361382.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257895',4908105,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257895',4908106,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257895',4908107,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257896',4908108,'2683','400',444135.26,444135.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257896',4908109,'2684','400',638106.66,639318.42,1211.76,224175.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257896',4908110,'2685','400',361382.95,361382.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257896',4908111,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257896',4908112,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257896',4908113,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257897',4908114,'2683','400',444135.26,444135.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257897',4908115,'2684','400',639318.42,640419.58,1101.16,203714.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257897',4908116,'2685','400',361382.95,361382.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257897',4908117,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257897',4908118,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257897',4908119,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257898',4908120,'2683','400',444135.26,444135.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257898',4908121,'2684','400',640419.58,641548.68,1129.10,208883.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257898',4908122,'2685','400',361382.95,361382.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257898',4908123,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257898',4908124,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257898',4908125,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257899',4908126,'2683','400',444135.26,444435.26,300.00,55500.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257899',4908127,'2684','400',641548.68,642350.83,802.15,148397.75,0.00,0.00,0.00,0.00,0.00),('5','173','905','257899',4908128,'2685','400',361382.95,361382.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257899',4908129,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257899',4908130,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257899',4908131,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257900',4908132,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257900',4908133,'2684','400',642350.83,643441.74,1090.91,201818.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257900',4908134,'2685','400',361382.95,361624.86,241.91,44753.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257900',4908135,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257900',4908136,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257900',4908137,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257901',4908138,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257901',4908139,'2684','400',643441.74,644462.08,1020.34,188762.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257901',4908140,'2685','400',361624.86,361624.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257901',4908141,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257901',4908142,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257901',4908143,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257902',4908144,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257902',4908145,'2684','400',644462.08,645563.56,1101.48,203773.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257902',4908146,'2685','400',361624.86,361624.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257902',4908147,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257902',4908148,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257902',4908149,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257903',4908150,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257903',4908151,'2684','400',645563.56,645563.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257903',4908152,'2685','400',361624.86,363009.14,1384.28,256091.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257903',4908153,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257903',4908154,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257903',4908155,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257904',4908156,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257904',4908157,'2684','400',645563.56,646563.56,1000.00,185000.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257904',4908158,'2685','400',363009.14,363257.03,247.89,45859.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257904',4908159,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257904',4908160,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257904',4908161,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257905',4908162,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257905',4908163,'2684','400',646563.56,646563.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257905',4908164,'2685','400',363257.03,364372.95,1115.92,206445.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257905',4908165,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257905',4908166,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257905',4908167,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257906',4908168,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257906',4908169,'2684','400',646563.56,646563.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257906',4908170,'2685','400',364372.95,365449.08,1076.13,199084.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257906',4908171,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257906',4908172,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257906',4908173,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257907',4908174,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257907',4908175,'2684','400',646563.56,646563.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257907',4908176,'2685','400',365449.08,366857.14,1408.06,260491.10,0.00,0.00,0.00,0.00,0.00),('5','173','905','257907',4908177,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257907',4908178,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257907',4908179,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257908',4908180,'2683','400',444435.26,444435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257908',4908181,'2684','400',646563.56,646563.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257908',4908182,'2685','400',366857.14,370420.52,3563.38,659225.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257908',4908183,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257908',4908184,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257908',4908185,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257909',4908186,'2683','400',444435.26,445435.26,1000.00,186000.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257909',4908187,'2684','400',646563.56,648367.56,1804.00,335544.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257909',4908188,'2685','400',370420.52,372491.72,2071.20,385243.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257909',4908189,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257909',4908190,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257909',4908191,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257910',4908192,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257910',4908193,'2684','400',648367.56,651067.25,2699.69,499442.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257910',4908194,'2685','400',372491.72,378334.52,5842.80,1080918.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257910',4908195,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257910',4908196,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257910',4908197,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257911',4908198,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257911',4908199,'2684','400',651067.25,656934.58,5867.33,1085456.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257911',4908200,'2685','400',378334.52,378970.66,636.14,117685.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257911',4908201,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257911',4908202,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257911',4908203,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257912',4908204,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257912',4908205,'2684','400',656934.58,664743.67,7809.09,1444681.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257912',4908206,'2685','400',378970.66,380568.47,1597.81,295594.85,0.00,0.00,0.00,0.00,0.00),('5','173','905','257912',4908207,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257912',4908208,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257912',4908209,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257913',4908210,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257913',4908211,'2684','400',664743.67,665565.85,822.18,152103.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257913',4908212,'2685','400',380568.47,384633.40,4064.93,752012.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257913',4908213,'2686','400',275796.99,275796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257913',4908214,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257913',4908215,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257914',4908216,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257914',4908217,'2684','400',665565.85,667159.41,1593.56,294808.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257914',4908218,'2685','400',384633.40,386074.32,1440.92,266570.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257914',4908219,'2686','400',275796.99,276796.99,1000.00,185000.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257914',4908220,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257914',4908221,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257915',4908222,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257915',4908223,'2684','400',667159.41,671514.28,4354.87,805650.95,0.00,0.00,0.00,0.00,0.00),('5','173','905','257915',4908224,'2685','400',386074.32,388287.70,2213.38,409475.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257915',4908225,'2686','400',276796.99,276796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257915',4908226,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257915',4908227,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257916',4908228,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257916',4908229,'2684','400',671514.28,674968.16,3453.88,638967.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257916',4908230,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257916',4908231,'2686','400',276796.99,276796.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257916',4908232,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257916',4908233,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257917',4908234,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257917',4908235,'2684','400',674968.16,678092.29,3124.13,577964.05,0.00,0.00,0.00,0.00,0.00),('5','173','905','257917',4908236,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257917',4908237,'2686','400',276796.99,278358.98,1561.99,288968.15,0.00,0.00,0.00,0.00,0.00),('5','173','906','257917',4908238,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257917',4908239,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257918',4908240,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257918',4908241,'2684','400',678092.29,678512.59,420.30,77755.50,0.00,0.00,0.00,0.00,0.00),('5','173','905','257918',4908242,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257918',4908243,'2686','400',278358.98,280612.72,2253.74,416941.90,0.00,0.00,0.00,0.00,0.00),('5','173','906','257918',4908244,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257918',4908245,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257919',4908246,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257919',4908247,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257919',4908248,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257919',4908249,'2686','400',280612.72,283516.60,2903.88,537217.80,0.00,0.00,0.00,0.00,0.00),('5','173','906','257919',4908250,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257919',4908251,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257920',4908252,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257920',4908253,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257920',4908254,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257920',4908255,'2686','400',283516.60,285822.55,2305.95,426600.75,0.00,0.00,0.00,0.00,0.00),('5','173','906','257920',4908256,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257920',4908257,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257921',4908258,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257921',4908259,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257921',4908260,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257921',4908261,'2686','400',285822.55,289165.75,3343.20,618492.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257921',4908262,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257921',4908263,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257922',4908264,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257922',4908265,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257922',4908266,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257922',4908267,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257922',4908268,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257922',4908269,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257923',4908270,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257923',4908271,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257923',4908272,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257923',4908273,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257923',4908274,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257923',4908275,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257924',4908276,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257924',4908277,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257924',4908278,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257924',4908279,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257924',4908280,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257924',4908281,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257925',4908282,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257925',4908283,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257925',4908284,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257925',4908285,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257925',4908286,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257925',4908287,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257926',4908288,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257926',4908289,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257926',4908290,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257926',4908291,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257926',4908292,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257926',4908293,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257927',4908294,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257927',4908295,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257927',4908296,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257927',4908297,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257927',4908298,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257927',4908299,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257928',4908300,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257928',4908301,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257928',4908302,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257928',4908303,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257928',4908304,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257928',4908305,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257929',4908306,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257929',4908307,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257929',4908308,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257929',4908309,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257929',4908310,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257929',4908311,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257930',4908312,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257930',4908313,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257930',4908314,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257930',4908315,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257930',4908316,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257930',4908317,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257931',4908318,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257931',4908319,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257931',4908320,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257931',4908321,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257931',4908322,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257931',4908323,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257932',4908324,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257932',4908325,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257932',4908326,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257932',4908327,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257932',4908328,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257932',4908329,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257933',4908330,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257933',4908331,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257933',4908332,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257933',4908333,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257933',4908334,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257933',4908335,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257934',4908336,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257934',4908337,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257934',4908338,'2685','400',388287.70,388287.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257934',4908339,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257934',4908340,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257934',4908341,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257935',4908342,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257935',4908343,'2684','400',678512.59,678512.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257935',4908344,'2685','400',388287.70,391521.93,3234.23,598332.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257935',4908345,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257935',4908346,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257935',4908347,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257936',4908348,'2683','400',445435.26,445435.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257936',4908349,'2684','400',678512.59,682572.59,4060.00,751100.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257936',4908350,'2685','400',391521.93,393865.92,2343.99,433638.15,0.00,0.00,0.00,0.00,0.00),('5','173','905','257936',4908351,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257936',4908352,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257936',4908353,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257937',4908354,'2683','400',445435.26,447435.26,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257937',4908355,'2684','400',682572.59,687384.87,4812.28,890271.80,0.00,0.00,0.00,0.00,0.00),('5','173','905','257937',4908356,'2685','400',393865.92,393865.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257937',4908357,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257937',4908358,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257937',4908359,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257938',4908360,'2683','400',447435.26,449019.09,1583.83,293008.55,0.00,0.00,0.00,0.00,0.00),('5','173','904','257938',4908361,'2684','400',687384.87,691504.16,4119.29,762068.65,0.00,0.00,0.00,0.00,0.00),('5','173','905','257938',4908362,'2685','400',393865.92,393865.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257938',4908363,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257938',4908364,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257938',4908365,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257939',4908366,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257939',4908367,'2684','400',691504.16,696905.20,5401.04,999192.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257939',4908368,'2685','400',393865.92,393865.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257939',4908369,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257939',4908370,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257939',4908371,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257940',4908372,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257940',4908373,'2684','400',696905.20,698016.71,1111.51,205629.35,0.00,0.00,0.00,0.00,0.00),('5','173','905','257940',4908374,'2685','400',393865.92,397863.08,3997.16,739474.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257940',4908375,'2686','400',289165.75,289165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257940',4908376,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257940',4908377,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257941',4908378,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257941',4908379,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257941',4908380,'2685','400',397863.08,399993.31,2130.23,394092.55,0.00,0.00,0.00,0.00,0.00),('5','173','905','257941',4908381,'2686','400',289165.75,291126.39,1960.64,362718.40,0.00,0.00,0.00,0.00,0.00),('5','173','906','257941',4908382,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257941',4908383,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257942',4908384,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257942',4908385,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257942',4908386,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257942',4908387,'2686','400',291126.39,296231.09,5104.70,944369.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','257942',4908388,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257942',4908389,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257943',4908390,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257943',4908391,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257943',4908392,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257943',4908393,'2686','400',296231.09,299072.19,2841.10,525603.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','257943',4908394,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257943',4908395,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257944',4908396,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257944',4908397,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257944',4908398,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257944',4908399,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257944',4908400,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257944',4908401,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257945',4908402,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257945',4908403,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257945',4908404,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257945',4908405,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257945',4908406,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257945',4908407,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257946',4908408,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257946',4908409,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257946',4908410,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257946',4908411,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257946',4908412,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257946',4908413,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257947',4908414,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257947',4908415,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257947',4908416,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257947',4908417,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257947',4908418,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257947',4908419,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257948',4908420,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257948',4908421,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257948',4908422,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257948',4908423,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257948',4908424,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257948',4908425,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257949',4908426,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257949',4908427,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257949',4908428,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257949',4908429,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257949',4908430,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257949',4908431,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257950',4908432,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257950',4908433,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257950',4908434,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257950',4908435,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257950',4908436,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257950',4908437,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257951',4908438,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257951',4908439,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257951',4908440,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257951',4908441,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257951',4908442,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257951',4908443,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257952',4908444,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257952',4908445,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257952',4908446,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257952',4908447,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257952',4908448,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257952',4908449,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257953',4908450,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257953',4908451,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257953',4908452,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257953',4908453,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257953',4908454,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257953',4908455,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257954',4908456,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257954',4908457,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257954',4908458,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257954',4908459,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257954',4908460,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257954',4908461,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257955',4908462,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257955',4908463,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257955',4908464,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257955',4908465,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257955',4908466,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257955',4908467,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257956',4908468,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257956',4908469,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257956',4908470,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257956',4908471,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257956',4908472,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257956',4908473,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257957',4908474,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257957',4908475,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257957',4908476,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257957',4908477,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257957',4908478,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257957',4908479,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257958',4908480,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257958',4908481,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257958',4908482,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257958',4908483,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257958',4908484,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257958',4908485,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257959',4908486,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257959',4908487,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257959',4908488,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257959',4908489,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257959',4908490,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257959',4908491,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257960',4908492,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257960',4908493,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257960',4908494,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257960',4908495,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257960',4908496,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257960',4908497,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257961',4908498,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257961',4908499,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257961',4908500,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257961',4908501,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257961',4908502,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257961',4908503,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257962',4908504,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257962',4908505,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257962',4908506,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257962',4908507,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257962',4908508,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257962',4908509,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257963',4908510,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257963',4908511,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257963',4908512,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257963',4908513,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257963',4908514,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257963',4908515,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257964',4908516,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257964',4908517,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257964',4908518,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257964',4908519,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257964',4908520,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257964',4908521,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257965',4908522,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257965',4908523,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257965',4908524,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257965',4908525,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257965',4908526,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257965',4908527,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257966',4908528,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257966',4908529,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257966',4908530,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257966',4908531,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257966',4908532,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257966',4908533,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257967',4908534,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257967',4908535,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257967',4908536,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257967',4908537,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257967',4908538,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257967',4908539,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257968',4908540,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257968',4908541,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257968',4908542,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257968',4908543,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257968',4908544,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257968',4908545,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257969',4908546,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257969',4908547,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257969',4908548,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257969',4908549,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257969',4908550,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257969',4908551,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257970',4908552,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257970',4908553,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257970',4908554,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257970',4908555,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257970',4908556,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257970',4908557,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257971',4908558,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257971',4908559,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257971',4908560,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257971',4908561,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257971',4908562,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257971',4908563,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257972',4908564,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257972',4908565,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257972',4908566,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257972',4908567,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257972',4908568,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257972',4908569,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257973',4908570,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257973',4908571,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257973',4908572,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257973',4908573,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257973',4908574,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257973',4908575,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257974',4908576,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257974',4908577,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257974',4908578,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257974',4908579,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257974',4908580,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257974',4908581,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257975',4908582,'2683','400',449019.09,449019.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257975',4908583,'2684','400',698016.71,698016.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257975',4908584,'2685','400',399993.31,399993.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257975',4908585,'2686','400',299072.19,299072.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257975',4908586,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257975',4908587,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257976',4908588,'2683','400',449173.89,449173.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257976',4908589,'2684','400',699020.70,699041.13,20.43,4290.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257976',4908590,'2685','400',399993.49,403467.78,3474.29,729600.90,0.00,0.00,0.00,0.00,0.00),('5','173','905','257976',4908591,'2686','400',296007.50,299155.85,3148.35,661153.50,0.00,0.00,0.00,0.00,0.00),('5','173','906','257976',4908592,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257976',4908593,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257977',4908594,'2683','400',449173.89,449173.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257977',4908595,'2684','400',699041.13,699041.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257977',4908596,'2685','400',403467.78,407071.61,3603.83,756804.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257977',4908597,'2686','400',299155.85,304279.52,5123.67,1075970.70,0.00,0.00,0.00,0.00,0.00),('5','173','906','257977',4908598,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257977',4908599,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257978',4908600,'2683','400',449173.89,449173.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257978',4908601,'2684','400',699041.13,699041.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257978',4908602,'2685','400',407071.61,410885.63,3814.02,800944.20,0.00,0.00,0.00,0.00,0.00),('5','173','905','257978',4908603,'2686','400',304279.52,308885.11,4605.59,967173.90,0.00,0.00,0.00,0.00,0.00),('5','173','906','257978',4908604,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257978',4908605,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257979',4908606,'2683','400',449173.89,449235.69,61.80,12978.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257979',4908607,'2684','400',699041.13,700276.86,1235.73,259503.30,0.00,0.00,0.00,0.00,0.00),('5','173','905','257979',4908608,'2685','400',410885.63,415679.27,4793.64,1006664.40,0.00,0.00,0.00,0.00,0.00),('5','173','905','257979',4908609,'2686','400',308885.11,313461.29,4576.18,960997.80,0.00,0.00,0.00,0.00,0.00),('5','173','906','257979',4908610,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257979',4908611,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257980',4908612,'2683','400',449235.69,451413.92,2178.23,457428.30,0.00,0.00,0.00,0.00,0.00),('5','173','904','257980',4908613,'2684','400',700276.86,705983.02,5706.16,1198293.60,0.00,0.00,0.00,0.00,0.00),('5','173','905','257980',4908614,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257980',4908615,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257980',4908616,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257980',4908617,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257981',4908618,'2683','400',451413.92,453522.06,2108.14,442709.40,0.00,0.00,0.00,0.00,0.00),('5','173','904','257981',4908619,'2684','400',705983.02,711033.89,5050.87,1060682.70,0.00,0.00,0.00,0.00,0.00),('5','173','905','257981',4908620,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257981',4908621,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257981',4908622,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257981',4908623,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257982',4908624,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257982',4908625,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257982',4908626,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257982',4908627,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257982',4908628,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257982',4908629,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257983',4908630,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257983',4908631,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257983',4908632,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257983',4908633,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257983',4908634,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257983',4908635,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257984',4908636,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257984',4908637,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257984',4908638,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257984',4908639,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257984',4908640,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257984',4908641,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257985',4908642,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257985',4908643,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257985',4908644,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257985',4908645,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257985',4908646,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257985',4908647,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257986',4908648,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257986',4908649,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257986',4908650,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257986',4908651,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257986',4908652,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257986',4908653,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257987',4908654,'2683','400',453522.06,453522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','904','257987',4908655,'2684','400',711033.89,711033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257987',4908656,'2685','400',415679.27,415679.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','905','257987',4908657,'2686','400',313461.29,313461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','906','257987',4908658,'2687','401',69550.41,69550.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','173','907','257987',4908659,'2688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=731053 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','173','182030','400',0.00,163.00,2243.00,0.00,0.00,0.00,0.00,533844),('5','173','182030','401',0.00,250.00,111.00,0.00,0.00,0.00,0.00,533845),('5','173','182030','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533846),('5','173','184618','400',163.00,0.00,0.00,0.00,0.00,0.00,0.00,540679),('5','173','184618','401',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540680),('5','173','184618','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540681),('5','173','184629','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,540712),('5','173','184629','401',0.00,250.00,1896.79,0.00,0.00,0.00,0.00,540713),('5','173','184629','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540714),('5','173','184634','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,540725),('5','173','184634','401',0.00,250.00,77.00,0.00,0.00,0.00,0.00,540726),('5','173','184634','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540727),('5','173','184635','400',163.00,163.00,1273.65,0.00,0.00,0.00,0.00,540728),('5','173','184635','401',0.00,250.00,160.92,0.00,0.00,0.00,0.00,540729),('5','173','184635','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540730),('5','173','184745','400',163.00,163.00,4138.76,0.00,0.00,0.00,0.00,541018),('5','173','184745','401',0.00,250.00,141.81,0.00,0.00,0.00,0.00,541019),('5','173','184745','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541020),('5','173','184749','400',163.00,163.00,4687.15,0.00,0.00,0.00,0.00,541028),('5','173','184749','401',0.00,250.00,91.76,0.00,0.00,0.00,0.00,541029),('5','173','184749','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541030),('5','173','184756','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,541046),('5','173','184756','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541047),('5','173','184756','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541048),('5','173','184778','400',163.00,163.00,7680.68,0.00,0.00,0.00,0.00,541108),('5','173','184778','401',0.00,250.00,1537.00,0.00,0.00,0.00,0.00,541109),('5','173','184778','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541110),('5','173','184950','400',163.00,0.00,0.00,0.00,0.00,0.00,0.00,541567),('5','173','184950','401',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541568),('5','173','184950','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541569),('5','173','184958','400',163.00,163.00,5408.67,0.00,0.00,0.00,0.00,541591),('5','173','184958','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541592),('5','173','184958','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541593),('5','173','184969','400',163.00,163.00,6069.05,0.00,0.00,0.00,0.00,541620),('5','173','184969','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541621),('5','173','184969','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541622),('5','173','184987','400',163.00,163.00,8042.53,0.00,0.00,0.00,0.00,541663),('5','173','184987','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541664),('5','173','184987','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541665),('5','173','185016','400',163.00,163.00,12609.30,0.00,0.00,0.00,0.00,541733),('5','173','185016','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541734),('5','173','185016','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541735),('5','173','185022','400',163.00,163.00,13466.87,0.00,0.00,0.00,0.00,541750),('5','173','185022','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,541751),('5','173','185022','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541752),('5','173','186012','400',163.00,163.00,8169.81,0.00,0.00,0.00,0.00,544345),('5','173','186012','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544346),('5','173','186012','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544347),('5','173','186014','400',163.00,163.00,8333.14,0.00,0.00,0.00,0.00,544351),('5','173','186014','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544352),('5','173','186014','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544353),('5','173','186016','400',163.00,163.00,5000.00,0.00,0.00,0.00,0.00,544357),('5','173','186016','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544358),('5','173','186016','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544359),('5','173','186024','400',163.00,163.00,1800.00,0.00,0.00,0.00,0.00,544380),('5','173','186024','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544381),('5','173','186024','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544382),('5','173','186026','400',163.00,163.00,1000.00,0.00,0.00,0.00,0.00,544386),('5','173','186026','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544387),('5','173','186026','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544388),('5','173','186028','400',163.00,163.00,1943.46,0.00,0.00,0.00,0.00,544392),('5','173','186028','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544393),('5','173','186028','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544394),('5','173','186115','400',163.00,0.00,0.00,0.00,0.00,0.00,0.00,544604),('5','173','186115','401',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544605),('5','173','186115','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544606),('5','173','186124','400',163.00,163.00,10025.35,0.00,0.00,0.00,0.00,544627),('5','173','186124','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544628),('5','173','186124','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544629),('5','173','186128','400',163.00,163.00,7979.62,0.00,0.00,0.00,0.00,544637),('5','173','186128','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544638),('5','173','186128','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544639),('5','173','186131','400',163.00,163.00,8553.14,0.00,0.00,0.00,0.00,544646),('5','173','186131','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,544647),('5','173','186131','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544648),('5','173','186349','400',163.00,163.00,8095.74,0.00,0.00,0.00,0.00,545212),('5','173','186349','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,545213),('5','173','186349','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545214),('5','173','186670','400',163.00,163.00,8133.93,0.00,0.00,0.00,0.00,546064),('5','173','186670','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,546065),('5','173','186670','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546066),('5','173','186913','400',163.00,163.00,6956.73,0.00,0.00,0.00,0.00,546682),('5','173','186913','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,546683),('5','173','186913','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546684),('5','173','186968','400',163.00,163.00,6347.41,0.00,0.00,0.00,0.00,546818),('5','173','186968','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,546819),('5','173','186968','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546820),('5','173','187227','400',163.00,163.00,7321.57,0.00,0.00,0.00,0.00,547498),('5','173','187227','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,547499),('5','173','187227','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547500),('5','173','187326','400',163.00,163.00,8028.22,0.00,0.00,0.00,0.00,547770),('5','173','187326','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,547771),('5','173','187326','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547772),('5','173','187510','400',163.00,163.00,7287.79,0.00,0.00,0.00,0.00,548258),('5','173','187510','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,548259),('5','173','187510','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548260),('5','173','187773','400',163.00,163.00,5772.97,0.00,0.00,0.00,0.00,548957),('5','173','187773','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,548958),('5','173','187773','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548959),('5','173','187916','400',163.00,163.00,6464.45,0.00,0.00,0.00,0.00,549325),('5','173','187916','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,549326),('5','173','187916','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549327),('5','173','188002','400',163.00,163.00,8549.91,0.00,0.00,0.00,0.00,549546),('5','173','188002','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,549547),('5','173','188002','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549548),('5','173','188231','400',163.00,163.00,9251.84,0.00,0.00,0.00,0.00,550133),('5','173','188231','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,550134),('5','173','188231','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550135),('5','173','188435','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,550660),('5','173','188435','401',0.00,250.00,0.00,0.00,0.00,0.00,0.00,550661),('5','173','188435','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550662),('5','173','188649','400',163.00,163.00,10012.30,0.00,0.00,0.00,0.00,551205),('5','173','188649','401',265.00,265.00,1440.46,0.00,0.00,0.00,0.00,551206),('5','173','188649','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551207),('5','173','188726','400',163.00,163.00,7670.83,0.00,0.00,0.00,0.00,551418),('5','173','188726','401',265.00,265.00,638.62,0.00,0.00,0.00,0.00,551419),('5','173','188726','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551420),('5','173','188828','400',163.00,163.00,5567.94,0.00,0.00,0.00,0.00,551684),('5','173','188828','401',265.00,265.00,167.48,0.00,0.00,0.00,0.00,551685),('5','173','188828','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551686),('5','173','189075','400',163.00,163.00,4628.37,0.00,0.00,0.00,0.00,552336),('5','173','189075','401',265.00,265.00,149.88,0.00,0.00,0.00,0.00,552337),('5','173','189075','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552338),('5','173','189262','400',163.00,0.00,3654.59,0.00,0.00,0.00,0.00,552823),('5','173','189262','401',265.00,0.00,441.95,0.00,0.00,0.00,0.00,552824),('5','173','189262','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552825),('5','173','189565','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553623),('5','173','189565','401',265.00,265.00,200.86,0.00,0.00,0.00,0.00,553624),('5','173','189565','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553625),('5','173','189697','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553945),('5','173','189697','401',265.00,265.00,762.00,0.00,0.00,0.00,0.00,553946),('5','173','189697','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553947),('5','173','189856','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,554352),('5','173','189856','401',265.00,265.00,174.18,0.00,0.00,0.00,0.00,554353),('5','173','189856','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554354),('5','173','190153','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555148),('5','173','190153','401',265.00,265.00,270.43,0.00,0.00,0.00,0.00,555149),('5','173','190153','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555150),('5','173','190277','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555461),('5','173','190277','401',265.00,265.00,153.83,0.00,0.00,0.00,0.00,555462),('5','173','190277','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555463),('5','173','190453','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555918),('5','173','190453','401',265.00,265.00,126.03,0.00,0.00,0.00,0.00,555919),('5','173','190453','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555920),('5','173','190700','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,556575),('5','173','190700','401',265.00,265.00,165.59,0.00,0.00,0.00,0.00,556576),('5','173','190700','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556577),('5','173','190969','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,557288),('5','173','190969','401',265.00,265.00,147.21,0.00,0.00,0.00,0.00,557289),('5','173','190969','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557290),('5','173','191145','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,557748),('5','173','191145','401',265.00,265.00,171.00,0.00,0.00,0.00,0.00,557749),('5','173','191145','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557750),('5','173','191410','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,558456),('5','173','191410','401',265.00,265.00,272.63,0.00,0.00,0.00,0.00,558457),('5','173','191410','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558458),('5','173','191569','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,558865),('5','173','191569','401',265.00,265.00,1203.61,0.00,0.00,0.00,0.00,558866),('5','173','191569','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558867),('5','173','191836','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,559591),('5','173','191836','401',265.00,265.00,427.48,0.00,0.00,0.00,0.00,559592),('5','173','191836','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559593),('5','173','191988','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,559986),('5','173','191988','401',265.00,265.00,205.00,0.00,0.00,0.00,0.00,559987),('5','173','191988','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559988),('5','173','192226','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,560615),('5','173','192226','401',265.00,265.00,220.76,0.00,0.00,0.00,0.00,560616),('5','173','192226','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560617),('5','173','192406','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,561080),('5','173','192406','401',265.00,265.00,201.82,0.00,0.00,0.00,0.00,561081),('5','173','192406','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561082),('5','173','192613','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,561624),('5','173','192613','401',265.00,265.00,265.00,0.00,0.00,0.00,0.00,561625),('5','173','192613','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561626),('5','173','193750','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,564589),('5','173','193750','401',265.00,265.00,0.00,0.00,0.00,0.00,0.00,564590),('5','173','193750','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564591),('5','173','193941','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565065),('5','173','193941','401',265.00,265.00,231.00,0.00,0.00,0.00,0.00,565066),('5','173','193941','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565067),('5','173','193945','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565076),('5','173','193945','401',265.00,265.00,383.56,0.00,0.00,0.00,0.00,565077),('5','173','193945','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565078),('5','173','193950','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565090),('5','173','193950','401',265.00,265.00,248.00,0.00,0.00,0.00,0.00,565091),('5','173','193950','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565092),('5','173','193958','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565112),('5','173','193958','401',265.00,265.00,241.76,0.00,0.00,0.00,0.00,565113),('5','173','193958','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565114),('5','173','193963','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565126),('5','173','193963','401',265.00,265.00,161.00,0.00,0.00,0.00,0.00,565127),('5','173','193963','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565128),('5','173','194197','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,565726),('5','173','194197','401',265.00,265.00,311.40,0.00,0.00,0.00,0.00,565727),('5','173','194197','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565728),('5','173','194378','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,566186),('5','173','194378','401',265.00,265.00,418.75,0.00,0.00,0.00,0.00,566187),('5','173','194378','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566188),('5','173','194379','400',163.00,165.00,0.00,0.00,0.00,0.00,0.00,566189),('5','173','194379','401',265.00,265.00,476.84,0.00,0.00,0.00,0.00,566190),('5','173','194379','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566191),('5','173','194734','400',165.00,165.00,552.94,0.00,0.00,0.00,0.00,567090),('5','173','194734','401',265.00,265.00,748.00,0.00,0.00,0.00,0.00,567091),('5','173','194734','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567092),('5','173','195005','400',165.00,165.00,2054.02,0.00,0.00,0.00,0.00,567813),('5','173','195005','401',265.00,265.00,664.01,0.00,0.00,0.00,0.00,567814),('5','173','195005','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567815),('5','173','195015','400',165.00,165.00,2521.52,0.00,0.00,0.00,0.00,567839),('5','173','195015','401',265.00,265.00,113.08,0.00,0.00,0.00,0.00,567840),('5','173','195015','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567841),('5','173','195357','400',165.00,165.00,2754.16,0.00,0.00,0.00,0.00,568708),('5','173','195357','401',265.00,265.00,198.66,0.00,0.00,0.00,0.00,568709),('5','173','195357','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568710),('5','173','195416','400',165.00,165.00,2860.08,0.00,0.00,0.00,0.00,568864),('5','173','195416','401',265.00,265.00,263.80,0.00,0.00,0.00,0.00,568865),('5','173','195416','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568866),('5','173','195767','400',165.00,165.00,3259.85,0.00,0.00,0.00,0.00,569756),('5','173','195767','401',265.00,265.00,1294.52,0.00,0.00,0.00,0.00,569757),('5','173','195767','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569758),('5','173','195878','400',165.00,165.00,3254.43,0.00,0.00,0.00,0.00,570022),('5','173','195878','401',265.00,265.00,222.19,0.00,0.00,0.00,0.00,570023),('5','173','195878','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570024),('5','173','196092','400',165.00,165.00,2948.43,0.00,0.00,0.00,0.00,570573),('5','173','196092','401',265.00,265.00,71.96,0.00,0.00,0.00,0.00,570574),('5','173','196092','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570575),('5','173','196408','400',165.00,165.00,3703.92,0.00,0.00,0.00,0.00,571386),('5','173','196408','401',265.00,265.00,64.73,0.00,0.00,0.00,0.00,571387),('5','173','196408','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571388),('5','173','196592','400',165.00,165.00,2972.68,0.00,0.00,0.00,0.00,571861),('5','173','196592','401',265.00,265.00,28.54,0.00,0.00,0.00,0.00,571862),('5','173','196592','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571863),('5','173','196813','400',165.00,165.00,2138.45,0.00,0.00,0.00,0.00,572434),('5','173','196813','401',265.00,265.00,42.70,0.00,0.00,0.00,0.00,572435),('5','173','196813','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572436),('5','173','196935','400',165.00,165.00,1263.40,0.00,0.00,0.00,0.00,572741),('5','173','196935','401',265.00,265.00,10.24,0.00,0.00,0.00,0.00,572742),('5','173','196935','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572743),('5','173','197652','400',165.00,165.00,1651.92,0.00,0.00,0.00,0.00,574527),('5','173','197652','401',265.00,265.00,25.86,0.00,0.00,0.00,0.00,574528),('5','173','197652','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574529),('5','173','197654','400',165.00,165.00,2410.62,0.00,0.00,0.00,0.00,574533),('5','173','197654','401',265.00,265.00,79.53,0.00,0.00,0.00,0.00,574534),('5','173','197654','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574535),('5','173','197662','400',165.00,165.00,2918.65,0.00,0.00,0.00,0.00,574557),('5','173','197662','401',265.00,265.00,71.55,0.00,0.00,0.00,0.00,574558),('5','173','197662','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574559),('5','173','197668','400',165.00,165.00,2809.38,0.00,0.00,0.00,0.00,574574),('5','173','197668','401',265.00,265.00,210.27,0.00,0.00,0.00,0.00,574575),('5','173','197668','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574576),('5','173','197989','400',165.00,165.00,2688.40,0.00,0.00,0.00,0.00,575429),('5','173','197989','401',265.00,270.00,174.51,0.00,0.00,0.00,0.00,575430),('5','173','197989','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575431),('5','173','198228','400',165.00,165.00,1400.00,0.00,0.00,0.00,0.00,576023),('5','173','198228','401',265.00,270.00,10.00,0.00,0.00,0.00,0.00,576024),('5','173','198228','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576025),('5','173','198432','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,576561),('5','173','198432','401',265.00,270.00,40.37,0.00,0.00,0.00,0.00,576562),('5','173','198432','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576563),('5','173','198720','400',165.00,165.00,942.93,0.00,0.00,0.00,0.00,577329),('5','173','198720','401',265.00,265.00,1119.95,0.00,0.00,0.00,0.00,577330),('5','173','198720','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577331),('5','173','199047','400',165.00,165.00,2047.22,0.00,0.00,0.00,0.00,578137),('5','173','199047','401',265.00,270.00,72.91,0.00,0.00,0.00,0.00,578138),('5','173','199047','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578139),('5','173','199067','400',165.00,165.00,2172.62,0.00,0.00,0.00,0.00,578192),('5','173','199067','401',265.00,270.00,40.61,0.00,0.00,0.00,0.00,578193),('5','173','199067','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578194),('5','173','199255','400',165.00,165.00,800.00,0.00,0.00,0.00,0.00,578650),('5','173','199255','401',265.00,270.00,0.00,0.00,0.00,0.00,0.00,578651),('5','173','199255','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578652),('5','173','199511','400',165.00,163.00,646.90,0.00,0.00,0.00,0.00,579277),('5','173','199511','401',265.00,270.00,101.78,0.00,0.00,0.00,0.00,579278),('5','173','199511','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579279),('5','173','199516','400',165.00,163.00,1713.42,0.00,0.00,0.00,0.00,579292),('5','173','199516','401',265.00,270.00,88.10,0.00,0.00,0.00,0.00,579293),('5','173','199516','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579294),('5','173','199765','400',165.00,165.00,1351.60,0.00,0.00,0.00,0.00,579896),('5','173','199765','401',265.00,270.00,44.13,0.00,0.00,0.00,0.00,579897),('5','173','199765','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579898),('5','173','199960','400',165.00,163.00,2104.84,0.00,0.00,0.00,0.00,580404),('5','173','199960','401',265.00,270.00,16.02,0.00,0.00,0.00,0.00,580405),('5','173','199960','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580406),('5','173','200246','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,581160),('5','173','200246','401',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581161),('5','173','200246','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581162),('5','173','200536','400',165.00,163.00,2223.69,0.00,0.00,0.00,0.00,581896),('5','173','200536','401',265.00,270.00,179.82,0.00,0.00,0.00,0.00,581897),('5','173','200536','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581898),('5','173','200537','400',165.00,163.00,0.00,0.00,0.00,0.00,0.00,581899),('5','173','200537','401',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581900),('5','173','200537','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581901),('5','173','200554','400',165.00,163.00,2240.69,0.00,0.00,0.00,0.00,581944),('5','173','200554','401',265.00,270.00,1207.92,0.00,0.00,0.00,0.00,581945),('5','173','200554','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581946),('5','173','200558','400',165.00,163.00,2473.93,0.00,0.00,0.00,0.00,581956),('5','173','200558','401',265.00,270.00,716.98,0.00,0.00,0.00,0.00,581957),('5','173','200558','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581958),('5','173','200831','400',163.00,163.00,2338.90,0.00,0.00,0.00,0.00,582670),('5','173','200831','401',270.00,270.00,749.61,0.00,0.00,0.00,0.00,582671),('5','173','200831','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582672),('5','173','201050','400',163.00,163.00,2035.94,0.00,0.00,0.00,0.00,583224),('5','173','201050','401',270.00,270.00,396.81,0.00,0.00,0.00,0.00,583225),('5','173','201050','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583226),('5','173','201171','400',163.00,163.00,2042.56,0.00,0.00,0.00,0.00,583518),('5','173','201171','401',270.00,270.00,148.11,0.00,0.00,0.00,0.00,583519),('5','173','201171','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583520),('5','173','201380','400',163.00,163.00,1129.78,0.00,0.00,0.00,0.00,584068),('5','173','201380','401',270.00,270.00,45.54,0.00,0.00,0.00,0.00,584069),('5','173','201380','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584070),('5','173','201746','400',163.00,163.00,491.58,0.00,0.00,0.00,0.00,585051),('5','173','201746','401',270.00,270.00,7.01,0.00,0.00,0.00,0.00,585052),('5','173','201746','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585053),('5','173','201788','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,585141),('5','173','201788','401',270.00,270.00,0.00,0.00,0.00,0.00,0.00,585142),('5','173','201788','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585143),('5','173','202187','400',163.00,163.00,2017.33,0.00,0.00,0.00,0.00,586190),('5','173','202187','401',275.00,275.00,632.52,0.00,0.00,0.00,0.00,586191),('5','173','202187','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586192),('5','173','202188','400',163.00,163.00,2308.26,0.00,0.00,0.00,0.00,586193),('5','173','202188','401',275.00,275.00,1149.46,0.00,0.00,0.00,0.00,586194),('5','173','202188','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586195),('5','173','202238','400',163.00,163.00,2511.86,0.00,0.00,0.00,0.00,586318),('5','173','202238','401',275.00,275.00,1136.71,0.00,0.00,0.00,0.00,586319),('5','173','202238','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586320),('5','173','202624','400',163.00,163.00,2482.06,0.00,0.00,0.00,0.00,587316),('5','173','202624','401',275.00,275.00,192.15,0.00,0.00,0.00,0.00,587317),('5','173','202624','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587318),('5','173','202638','400',163.00,163.00,2301.03,0.00,0.00,0.00,0.00,587348),('5','173','202638','401',275.00,275.00,1137.71,0.00,0.00,0.00,0.00,587349),('5','173','202638','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587350),('5','173','202851','400',163.00,163.00,2470.51,0.00,0.00,0.00,0.00,587893),('5','173','202851','401',275.00,275.00,583.87,0.00,0.00,0.00,0.00,587894),('5','173','202851','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587895),('5','173','203111','400',163.00,163.00,2766.85,0.00,0.00,0.00,0.00,588567),('5','173','203111','401',275.00,275.00,1336.64,0.00,0.00,0.00,0.00,588568),('5','173','203111','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588569),('5','173','203316','400',163.00,163.00,2865.66,0.00,0.00,0.00,0.00,589111),('5','173','203316','401',275.00,275.00,169.43,0.00,0.00,0.00,0.00,589112),('5','173','203316','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589113),('5','173','203562','400',163.00,163.00,1921.57,0.00,0.00,0.00,0.00,589724),('5','173','203562','401',275.00,275.00,429.41,0.00,0.00,0.00,0.00,589725),('5','173','203562','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589726),('5','173','203752','400',163.00,163.00,1880.08,0.00,0.00,0.00,0.00,590213),('5','173','203752','401',275.00,275.00,47.24,0.00,0.00,0.00,0.00,590214),('5','173','203752','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590215),('5','173','203971','400',163.00,163.00,1461.86,0.00,0.00,0.00,0.00,590783),('5','173','203971','401',275.00,275.00,37.95,0.00,0.00,0.00,0.00,590784),('5','173','203971','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590785),('5','173','204218','400',163.00,163.00,1358.03,0.00,0.00,0.00,0.00,591423),('5','173','204218','401',275.00,275.00,8.90,0.00,0.00,0.00,0.00,591424),('5','173','204218','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591425),('5','173','204411','400',163.00,163.00,2095.19,0.00,0.00,0.00,0.00,591930),('5','173','204411','401',275.00,275.00,20.43,0.00,0.00,0.00,0.00,591931),('5','173','204411','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591932),('5','173','204619','400',163.00,163.00,2289.14,0.00,0.00,0.00,0.00,592466),('5','173','204619','401',275.00,275.00,1208.70,0.00,0.00,0.00,0.00,592467),('5','173','204619','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592468),('5','173','204872','400',163.00,163.00,2363.53,0.00,0.00,0.00,0.00,593071),('5','173','204872','401',275.00,275.00,813.56,0.00,0.00,0.00,0.00,593072),('5','173','204872','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593073),('5','173','205221','400',163.00,163.00,1703.61,0.00,0.00,0.00,0.00,593989),('5','173','205221','401',275.00,275.00,151.00,0.00,0.00,0.00,0.00,593990),('5','173','205221','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593991),('5','173','205231','400',163.00,163.00,1752.08,0.00,0.00,0.00,0.00,594011),('5','173','205231','401',275.00,280.00,7.96,0.00,0.00,0.00,0.00,594012),('5','173','205231','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594013),('5','173','205526','400',163.00,163.00,1795.69,0.00,0.00,0.00,0.00,594755),('5','173','205526','401',275.00,280.00,170.55,0.00,0.00,0.00,0.00,594756),('5','173','205526','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594757),('5','173','205808','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,595493),('5','173','205808','401',275.00,275.00,0.00,0.00,0.00,0.00,0.00,595494),('5','173','205808','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595495),('5','173','205991','400',163.00,163.00,1921.12,0.00,0.00,0.00,0.00,595968),('5','173','205991','401',280.00,280.00,87.47,0.00,0.00,0.00,0.00,595969),('5','173','205991','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595970),('5','173','206003','400',163.00,163.00,1192.70,0.00,0.00,0.00,0.00,595996),('5','173','206003','401',280.00,290.00,114.01,0.00,0.00,0.00,0.00,595997),('5','173','206003','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595998),('5','173','206134','400',163.00,163.00,1528.73,0.00,0.00,0.00,0.00,596338),('5','173','206134','401',280.00,290.00,341.50,0.00,0.00,0.00,0.00,596339),('5','173','206134','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596340),('5','173','206401','400',163.00,163.00,1917.90,0.00,0.00,0.00,0.00,597008),('5','173','206401','401',280.00,290.00,22.00,0.00,0.00,0.00,0.00,597009),('5','173','206401','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597010),('5','173','206657','400',163.00,163.00,1683.40,0.00,0.00,0.00,0.00,597665),('5','173','206657','401',280.00,290.00,30.00,0.00,0.00,0.00,0.00,597666),('5','173','206657','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597667),('5','173','206881','400',163.00,163.00,1581.98,0.00,0.00,0.00,0.00,598245),('5','173','206881','401',280.00,290.00,35.00,0.00,0.00,0.00,0.00,598246),('5','173','206881','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598247),('5','173','207086','400',163.00,163.00,1631.56,0.00,0.00,0.00,0.00,598775),('5','173','207086','401',280.00,290.00,10.00,0.00,0.00,0.00,0.00,598776),('5','173','207086','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598777),('5','173','207357','400',163.00,163.00,1456.61,0.00,0.00,0.00,0.00,599471),('5','173','207357','401',280.00,290.00,10.00,0.00,0.00,0.00,0.00,599472),('5','173','207357','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599473),('5','173','207592','400',163.00,163.00,1505.22,0.00,0.00,0.00,0.00,600081),('5','173','207592','401',280.00,290.00,130.16,0.00,0.00,0.00,0.00,600082),('5','173','207592','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600083),('5','173','207786','400',163.00,163.00,2044.68,0.00,0.00,0.00,0.00,600566),('5','173','207786','401',280.00,290.00,72.56,0.00,0.00,0.00,0.00,600567),('5','173','207786','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600568),('5','173','208093','400',163.00,163.00,1803.44,0.00,0.00,0.00,0.00,601368),('5','173','208093','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,601369),('5','173','208093','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601370),('5','173','208177','400',163.00,163.00,1936.14,0.00,0.00,0.00,0.00,601570),('5','173','208177','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,601571),('5','173','208177','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601572),('5','173','208502','400',163.00,163.00,2421.66,0.00,0.00,0.00,0.00,602417),('5','173','208502','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,602418),('5','173','208502','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602419),('5','173','208639','400',163.00,163.00,1775.97,0.00,0.00,0.00,0.00,602760),('5','173','208639','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,602761),('5','173','208639','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602762),('5','173','208878','400',163.00,163.00,1641.30,0.00,0.00,0.00,0.00,603357),('5','173','208878','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,603358),('5','173','208878','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603359),('5','173','209024','400',163.00,163.00,2208.92,0.00,0.00,0.00,0.00,603723),('5','173','209024','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,603724),('5','173','209024','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603725),('5','173','209421','400',163.00,163.00,1679.20,0.00,0.00,0.00,0.00,604760),('5','173','209421','401',280.00,290.00,84.01,0.00,0.00,0.00,0.00,604761),('5','173','209421','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604762),('5','173','209536','400',163.00,163.00,1844.44,0.00,0.00,0.00,0.00,605050),('5','173','209536','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,605051),('5','173','209536','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605052),('5','173','209841','400',163.00,163.00,2242.20,0.00,0.00,0.00,0.00,605846),('5','173','209841','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,605847),('5','173','209841','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605848),('5','173','209952','400',163.00,163.00,1960.76,0.00,0.00,0.00,0.00,606128),('5','173','209952','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,606129),('5','173','209952','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606130),('5','173','210135','400',163.00,163.00,1759.30,0.00,0.00,0.00,0.00,606592),('5','173','210135','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,606593),('5','173','210135','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606594),('5','173','210410','400',163.00,163.00,1678.21,0.00,0.00,0.00,0.00,607306),('5','173','210410','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,607307),('5','173','210410','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607308),('5','173','210508','400',163.00,163.00,1810.90,0.00,0.00,0.00,0.00,607579),('5','173','210508','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,607580),('5','173','210508','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607581),('5','173','210750','400',163.00,163.00,1404.45,0.00,0.00,0.00,0.00,608204),('5','173','210750','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,608205),('5','173','210750','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608206),('5','173','211027','400',163.00,163.00,2243.92,0.00,0.00,0.00,0.00,608907),('5','173','211027','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,608908),('5','173','211027','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608909),('5','173','211240','400',163.00,163.00,2516.25,0.00,0.00,0.00,0.00,609465),('5','173','211240','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,609466),('5','173','211240','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609467),('5','173','211419','400',163.00,163.00,1842.06,0.00,0.00,0.00,0.00,609928),('5','173','211419','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,609929),('5','173','211419','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609930),('5','173','211764','400',163.00,163.00,877.14,0.00,0.00,0.00,0.00,610823),('5','173','211764','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,610824),('5','173','211764','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610825),('5','173','211974','400',163.00,163.00,1095.15,0.00,0.00,0.00,0.00,611372),('5','173','211974','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,611373),('5','173','211974','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611374),('5','173','212139','400',163.00,163.00,1559.90,0.00,0.00,0.00,0.00,611798),('5','173','212139','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,611799),('5','173','212139','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611800),('5','173','212360','400',163.00,163.00,1446.21,0.00,0.00,0.00,0.00,612372),('5','173','212360','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,612373),('5','173','212360','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612374),('5','173','212828','400',163.00,163.00,1490.95,0.00,0.00,0.00,0.00,613615),('5','173','212828','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,613616),('5','173','212828','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613617),('5','173','212832','400',163.00,163.00,1500.00,0.00,0.00,0.00,0.00,613625),('5','173','212832','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,613626),('5','173','212832','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613627),('5','173','213110','400',163.00,163.00,1150.00,0.00,0.00,0.00,0.00,614353),('5','173','213110','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,614354),('5','173','213110','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614355),('5','173','213232','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,614659),('5','173','213232','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,614660),('5','173','213232','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614661),('5','173','213859','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,616312),('5','173','213859','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,616313),('5','173','213859','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616314),('5','173','213860','400',163.00,163.00,0.00,0.00,0.00,0.00,0.00,616315),('5','173','213860','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,616316),('5','173','213860','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616317),('5','173','213981','400',163.00,162.00,1183.55,0.00,0.00,0.00,0.00,616622),('5','173','213981','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,616623),('5','173','213981','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616624),('5','173','214239','400',162.00,162.00,2654.39,0.00,0.00,0.00,0.00,617290),('5','173','214239','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,617291),('5','173','214239','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617292),('5','173','214464','400',162.00,162.00,1702.45,0.00,0.00,0.00,0.00,617880),('5','173','214464','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,617881),('5','173','214464','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617882),('5','173','214547','400',162.00,162.00,1791.41,0.00,0.00,0.00,0.00,618079),('5','173','214547','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,618080),('5','173','214547','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618081),('5','173','214916','400',162.00,162.00,1518.72,0.00,0.00,0.00,0.00,619055),('5','173','214916','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,619056),('5','173','214916','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619057),('5','173','214939','400',162.00,162.00,1579.43,0.00,0.00,0.00,0.00,619118),('5','173','214939','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,619119),('5','173','214939','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619120),('5','173','215085','400',162.00,163.00,0.00,0.00,0.00,0.00,0.00,619497),('5','173','215085','401',280.00,280.00,0.00,0.00,0.00,0.00,0.00,619498),('5','173','215085','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619499),('5','173','215277','400',162.00,162.00,1465.48,0.00,0.00,0.00,0.00,619977),('5','173','215277','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,619978),('5','173','215277','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619979),('5','173','215282','400',162.00,162.00,1621.99,0.00,0.00,0.00,0.00,619992),('5','173','215282','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,619993),('5','173','215282','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619994),('5','173','215476','400',162.00,162.00,2115.60,0.00,0.00,0.00,0.00,620479),('5','173','215476','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,620480),('5','173','215476','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620481),('5','173','215783','400',162.00,162.00,1822.33,0.00,0.00,0.00,0.00,621285),('5','173','215783','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,621286),('5','173','215783','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621287),('5','173','215983','400',162.00,162.00,2042.27,0.00,0.00,0.00,0.00,621797),('5','173','215983','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,621798),('5','173','215983','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621799),('5','173','216156','400',162.00,162.00,1934.43,0.00,0.00,0.00,0.00,622240),('5','173','216156','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,622241),('5','173','216156','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622242),('5','173','216361','400',162.00,162.00,1748.48,0.00,0.00,0.00,0.00,622770),('5','173','216361','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,622771),('5','173','216361','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622772),('5','173','216599','400',162.00,162.00,2128.74,0.00,0.00,0.00,0.00,623403),('5','173','216599','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,623404),('5','173','216599','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623405),('5','173','216862','400',162.00,162.00,1548.15,0.00,0.00,0.00,0.00,624103),('5','173','216862','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,624104),('5','173','216862','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624105),('5','173','217112','400',162.00,162.00,1545.37,0.00,0.00,0.00,0.00,624753),('5','173','217112','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,624754),('5','173','217112','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624755),('5','173','217318','400',162.00,162.00,1885.31,0.00,0.00,0.00,0.00,625289),('5','173','217318','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,625290),('5','173','217318','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625291),('5','173','217672','400',162.00,162.00,125.86,0.00,0.00,0.00,0.00,626235),('5','173','217672','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,626236),('5','173','217672','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626237),('5','173','217943','400',162.00,162.00,377.78,0.00,0.00,0.00,0.00,626946),('5','173','217943','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,626947),('5','173','217943','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626948),('5','173','218036','400',162.00,162.00,331.23,0.00,0.00,0.00,0.00,627172),('5','173','218036','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,627173),('5','173','218036','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627174),('5','173','218359','400',162.00,162.00,402.86,0.00,0.00,0.00,0.00,628030),('5','173','218359','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,628031),('5','173','218359','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628032),('5','173','218480','400',162.00,162.00,883.48,0.00,0.00,0.00,0.00,628336),('5','173','218480','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,628337),('5','173','218480','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628338),('5','173','218859','400',162.00,162.00,1778.81,0.00,0.00,0.00,0.00,629338),('5','173','218859','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,629339),('5','173','218859','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629340),('5','173','218929','400',162.00,162.00,2027.44,0.00,0.00,0.00,0.00,629508),('5','173','218929','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,629509),('5','173','218929','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629510),('5','173','219136','400',162.00,162.00,1656.16,0.00,0.00,0.00,0.00,630047),('5','173','219136','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,630048),('5','173','219136','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630049),('5','173','219342','400',162.00,162.00,1911.41,0.00,0.00,0.00,0.00,630587),('5','173','219342','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,630588),('5','173','219342','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630589),('5','173','219622','400',162.00,162.00,2113.00,0.00,0.00,0.00,0.00,631319),('5','173','219622','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,631320),('5','173','219622','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631321),('5','173','219871','400',162.00,162.00,776.97,0.00,0.00,0.00,0.00,631980),('5','173','219871','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,631981),('5','173','219871','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631982),('5','173','220148','400',162.00,162.00,1000.38,0.00,0.00,0.00,0.00,632725),('5','173','220148','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,632726),('5','173','220148','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632727),('5','173','220379','400',162.00,162.00,560.14,0.00,0.00,0.00,0.00,633335),('5','173','220379','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,633336),('5','173','220379','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633337),('5','173','220654','400',162.00,162.00,777.99,0.00,0.00,0.00,0.00,634047),('5','173','220654','401',280.00,290.00,0.00,0.00,0.00,0.00,0.00,634048),('5','173','220654','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634049),('5','173','220867','400',162.00,162.00,852.21,0.00,0.00,0.00,0.00,634605),('5','173','220867','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,634606),('5','173','220867','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634607),('5','173','221005','400',162.00,162.00,1182.03,0.00,0.00,0.00,0.00,634962),('5','173','221005','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,634963),('5','173','221005','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634964),('5','173','221220','400',162.00,162.00,1769.36,0.00,0.00,0.00,0.00,635509),('5','173','221220','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,635510),('5','173','221220','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635511),('5','173','221398','400',162.00,162.00,1631.38,0.00,0.00,0.00,0.00,635977),('5','173','221398','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,635978),('5','173','221398','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635979),('5','173','221741','400',162.00,162.00,1629.43,0.00,0.00,0.00,0.00,636881),('5','173','221741','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,636882),('5','173','221741','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636883),('5','173','221971','400',162.00,162.00,1148.76,0.00,0.00,0.00,0.00,637478),('5','173','221971','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,637479),('5','173','221971','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637480),('5','173','222079','400',162.00,162.00,1523.89,0.00,0.00,0.00,0.00,637752),('5','173','222079','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,637753),('5','173','222079','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637754),('5','173','222307','400',162.00,162.00,793.24,0.00,0.00,0.00,0.00,638331),('5','173','222307','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,638332),('5','173','222307','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638333),('5','173','222565','400',162.00,162.00,1574.93,0.00,0.00,0.00,0.00,638998),('5','173','222565','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,638999),('5','173','222565','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639000),('5','173','222790','400',162.00,162.00,1403.43,0.00,0.00,0.00,0.00,639592),('5','173','222790','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,639593),('5','173','222790','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639594),('5','173','222970','400',162.00,162.00,764.72,0.00,0.00,0.00,0.00,640087),('5','173','222970','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,640088),('5','173','222970','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640089),('5','173','223225','400',162.00,162.00,826.05,0.00,0.00,0.00,0.00,640729),('5','173','223225','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,640730),('5','173','223225','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640731),('5','173','223539','400',162.00,162.00,415.44,0.00,0.00,0.00,0.00,641514),('5','173','223539','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,641515),('5','173','223539','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641516),('5','173','223786','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,642156),('5','173','223786','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,642157),('5','173','223786','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642158),('5','173','224166','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,643129),('5','173','224166','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,643130),('5','173','224166','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643131),('5','173','224272','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,643426),('5','173','224272','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,643427),('5','173','224272','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643428),('5','173','224416','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,643785),('5','173','224416','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,643786),('5','173','224416','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643787),('5','173','224710','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,644564),('5','173','224710','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,644565),('5','173','224710','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644566),('5','173','225161','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,645718),('5','173','225161','401',280.00,280.00,0.00,0.00,0.00,0.00,0.00,645719),('5','173','225161','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645720),('5','173','225425','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,646401),('5','173','225425','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,646402),('5','173','225425','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646403),('5','173','225629','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,646927),('5','173','225629','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,646928),('5','173','225629','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646929),('5','173','225850','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,647502),('5','173','225850','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,647503),('5','173','225850','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647504),('5','173','225930','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,647728),('5','173','225930','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,647729),('5','173','225930','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647730),('5','173','226153','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,648294),('5','173','226153','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,648295),('5','173','226153','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648296),('5','173','226444','400',162.00,162.00,377.03,0.00,0.00,0.00,0.00,649054),('5','173','226444','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,649055),('5','173','226444','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649056),('5','173','226574','400',162.00,162.00,1626.90,0.00,0.00,0.00,0.00,649363),('5','173','226574','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,649364),('5','173','226574','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649365),('5','173','226870','400',162.00,162.00,1890.87,0.00,0.00,0.00,0.00,650147),('5','173','226870','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,650148),('5','173','226870','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650149),('5','173','227070','400',162.00,162.00,1193.30,0.00,0.00,0.00,0.00,650656),('5','173','227070','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,650657),('5','173','227070','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650658),('5','173','227234','400',162.00,162.00,1322.24,0.00,0.00,0.00,0.00,651074),('5','173','227234','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,651075),('5','173','227234','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651076),('5','173','227462','400',162.00,162.00,1496.76,0.00,0.00,0.00,0.00,651665),('5','173','227462','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,651666),('5','173','227462','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651667),('5','173','227687','400',162.00,162.00,1248.48,0.00,0.00,0.00,0.00,652241),('5','173','227687','401',280.00,295.00,0.00,0.00,0.00,0.00,0.00,652242),('5','173','227687','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652243),('5','173','227925','400',162.00,162.00,1152.69,0.00,0.00,0.00,0.00,652862),('5','173','227925','401',300.00,300.00,0.00,0.00,0.00,0.00,0.00,652863),('5','173','227925','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652864),('5','173','235144','400',162.00,162.00,766.78,0.00,0.00,0.00,0.00,671779),('5','173','235144','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671780),('5','173','235144','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671781),('5','173','235685','400',162.00,162.00,200.00,0.00,0.00,0.00,0.00,673184),('5','173','235685','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673185),('5','173','235685','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673186),('5','173','235849','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673599),('5','173','235849','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673600),('5','173','235849','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673601),('5','173','235850','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673602),('5','173','235850','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673603),('5','173','235850','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673604),('5','173','235852','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673608),('5','173','235852','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673609),('5','173','235852','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673610),('5','173','235855','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673617),('5','173','235855','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673618),('5','173','235855','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673619),('5','173','235856','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673620),('5','173','235856','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673621),('5','173','235856','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673622),('5','173','235857','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673623),('5','173','235857','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673624),('5','173','235857','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673625),('5','173','235863','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673639),('5','173','235863','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673640),('5','173','235863','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673641),('5','173','235872','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673661),('5','173','235872','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673662),('5','173','235872','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673663),('5','173','235873','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673664),('5','173','235873','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673665),('5','173','235873','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673666),('5','173','235874','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673667),('5','173','235874','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673668),('5','173','235874','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673669),('5','173','235875','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673670),('5','173','235875','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673671),('5','173','235875','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673672),('5','173','235876','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673673),('5','173','235876','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673674),('5','173','235876','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673675),('5','173','235877','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673676),('5','173','235877','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673677),('5','173','235877','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673678),('5','173','235911','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673772),('5','173','235911','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673773),('5','173','235911','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673774),('5','173','235962','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,673916),('5','173','235962','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673917),('5','173','235962','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673918),('5','173','236316','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674836),('5','173','236316','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674837),('5','173','236316','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674838),('5','173','236317','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674839),('5','173','236317','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674840),('5','173','236317','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674841),('5','173','236324','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674858),('5','173','236324','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674859),('5','173','236324','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674860),('5','173','236332','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674881),('5','173','236332','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674882),('5','173','236332','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674883),('5','173','236334','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674887),('5','173','236334','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674888),('5','173','236334','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674889),('5','173','236340','400',162.00,162.00,0.00,0.00,0.00,0.00,0.00,674904),('5','173','236340','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674905),('5','173','236340','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674906),('5','173','236357','400',162.00,162.00,300.00,0.00,0.00,0.00,0.00,674949),('5','173','236357','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674950),('5','173','236357','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674951),('5','173','236359','400',162.00,162.00,1213.93,0.00,0.00,0.00,0.00,674955),('5','173','236359','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674956),('5','173','236359','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674957),('5','173','236360','400',162.00,162.00,1416.82,0.00,0.00,0.00,0.00,674958),('5','173','236360','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674959),('5','173','236360','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674960),('5','173','237730','400',162.00,165.00,1063.34,0.00,0.00,0.00,0.00,678504),('5','173','237730','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678505),('5','173','237730','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678506),('5','173','237733','400',162.00,165.00,2706.30,0.00,0.00,0.00,0.00,678514),('5','173','237733','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678515),('5','173','237733','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678516),('5','173','237741','400',162.00,165.00,1096.50,0.00,0.00,0.00,0.00,678534),('5','173','237741','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678535),('5','173','237741','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678536),('5','173','237743','400',162.00,165.00,1179.18,0.00,0.00,0.00,0.00,678540),('5','173','237743','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678541),('5','173','237743','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678542),('5','173','237746','400',162.00,165.00,1037.27,0.00,0.00,0.00,0.00,678548),('5','173','237746','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678549),('5','173','237746','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678550),('5','173','237747','400',162.00,165.00,1059.51,0.00,0.00,0.00,0.00,678551),('5','173','237747','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678552),('5','173','237747','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678553),('5','173','237748','400',162.00,165.00,1491.08,0.00,0.00,0.00,0.00,678554),('5','173','237748','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678555),('5','173','237748','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678556),('5','173','237751','400',162.00,165.00,1777.25,0.00,0.00,0.00,0.00,678563),('5','173','237751','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678564),('5','173','237751','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678565),('5','173','237752','400',162.00,165.00,1760.28,0.00,0.00,0.00,0.00,678566),('5','173','237752','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678567),('5','173','237752','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678568),('5','173','237754','400',162.00,165.00,1620.12,0.00,0.00,0.00,0.00,678570),('5','173','237754','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678571),('5','173','237754','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678572),('5','173','237757','400',162.00,165.00,950.64,0.00,0.00,0.00,0.00,678576),('5','173','237757','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678577),('5','173','237757','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678578),('5','173','237759','400',162.00,165.00,1170.00,0.00,0.00,0.00,0.00,678582),('5','173','237759','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678583),('5','173','237759','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678584),('5','173','237761','400',162.00,165.00,533.83,0.00,0.00,0.00,0.00,678587),('5','173','237761','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678588),('5','173','237761','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678589),('5','173','237763','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,678593),('5','173','237763','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678594),('5','173','237763','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678595),('5','173','237766','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,678602),('5','173','237766','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678603),('5','173','237766','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678604),('5','173','238205','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,679728),('5','173','238205','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679729),('5','173','238205','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679730),('5','173','238454','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,680377),('5','173','238454','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680378),('5','173','238454','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680379),('5','173','238699','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,681017),('5','173','238699','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681018),('5','173','238699','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681019),('5','173','238985','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,681760),('5','173','238985','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681761),('5','173','238985','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681762),('5','173','239129','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,682123),('5','173','239129','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682124),('5','173','239129','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682125),('5','173','239350','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,682700),('5','173','239350','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682701),('5','173','239350','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682702),('5','173','239700','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,683623),('5','173','239700','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683624),('5','173','239700','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683625),('5','173','239903','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,684153),('5','173','239903','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684154),('5','173','239903','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684155),('5','173','240055','400',162.00,165.00,0.00,0.00,0.00,0.00,0.00,684535),('5','173','240055','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684536),('5','173','240055','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684537),('5','173','240341','400',162.00,165.00,2191.25,0.00,0.00,0.00,0.00,685279),('5','173','240341','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685280),('5','173','240341','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685281),('5','173','241811','400',165.00,165.00,1619.09,0.00,0.00,0.00,0.00,689110),('5','173','241811','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689111),('5','173','241811','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689112),('5','173','242198','400',165.00,165.00,3063.03,0.00,0.00,0.00,0.00,690121),('5','173','242198','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690122),('5','173','242198','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690123),('5','173','242461','400',165.00,165.00,1421.17,0.00,0.00,0.00,0.00,690790),('5','173','242461','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690791),('5','173','242461','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690792),('5','173','242614','400',165.00,165.00,1381.70,0.00,0.00,0.00,0.00,691211),('5','173','242614','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691212),('5','173','242614','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691213),('5','173','242787','400',165.00,165.00,1581.24,0.00,0.00,0.00,0.00,691647),('5','173','242787','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691648),('5','173','242787','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691649),('5','173','247018','400',165.00,165.00,1794.80,0.00,0.00,0.00,0.00,702623),('5','173','247018','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702624),('5','173','247018','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702625),('5','173','247308','400',165.00,165.00,2070.38,0.00,0.00,0.00,0.00,703385),('5','173','247308','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703386),('5','173','247308','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703387),('5','173','247501','400',165.00,165.00,1691.66,0.00,0.00,0.00,0.00,703872),('5','173','247501','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703873),('5','173','247501','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703874),('5','173','247509','400',165.00,165.00,1381.67,0.00,0.00,0.00,0.00,703896),('5','173','247509','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703897),('5','173','247509','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703898),('5','173','247511','400',165.00,165.00,1584.04,0.00,0.00,0.00,0.00,703902),('5','173','247511','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703903),('5','173','247511','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703904),('5','173','247514','400',165.00,165.00,1661.06,0.00,0.00,0.00,0.00,703911),('5','173','247514','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703912),('5','173','247514','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703913),('5','173','247515','400',165.00,165.00,1509.61,0.00,0.00,0.00,0.00,703914),('5','173','247515','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703915),('5','173','247515','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703916),('5','173','247516','400',165.00,165.00,2122.82,0.00,0.00,0.00,0.00,703917),('5','173','247516','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703918),('5','173','247516','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703919),('5','173','247517','400',165.00,165.00,1546.54,0.00,0.00,0.00,0.00,703920),('5','173','247517','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703921),('5','173','247517','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703922),('5','173','247519','400',165.00,165.00,1587.73,0.00,0.00,0.00,0.00,703926),('5','173','247519','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703927),('5','173','247519','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703928),('5','173','247521','400',165.00,165.00,1647.57,0.00,0.00,0.00,0.00,703932),('5','173','247521','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703933),('5','173','247521','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703934),('5','173','247523','400',165.00,165.00,2055.75,0.00,0.00,0.00,0.00,703938),('5','173','247523','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703939),('5','173','247523','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703940),('5','173','247524','400',165.00,165.00,1432.89,0.00,0.00,0.00,0.00,703941),('5','173','247524','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703942),('5','173','247524','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703943),('5','173','247527','400',165.00,165.00,1761.11,0.00,0.00,0.00,0.00,703948),('5','173','247527','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703949),('5','173','247527','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703950),('5','173','247528','400',165.00,165.00,1448.22,0.00,0.00,0.00,0.00,703951),('5','173','247528','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703952),('5','173','247528','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703953),('5','173','247529','400',165.00,165.00,1481.87,0.00,0.00,0.00,0.00,703954),('5','173','247529','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703955),('5','173','247529','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703956),('5','173','247531','400',165.00,165.00,465.81,0.00,0.00,0.00,0.00,703960),('5','173','247531','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703961),('5','173','247531','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703962),('5','173','247536','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703974),('5','173','247536','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703975),('5','173','247536','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703976),('5','173','247537','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703977),('5','173','247537','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703978),('5','173','247537','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703979),('5','173','247538','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703980),('5','173','247538','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703981),('5','173','247538','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703982),('5','173','247539','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703983),('5','173','247539','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703984),('5','173','247539','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703985),('5','173','247541','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703989),('5','173','247541','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703990),('5','173','247541','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703991),('5','173','247542','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703992),('5','173','247542','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703993),('5','173','247542','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703994),('5','173','247543','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703995),('5','173','247543','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703996),('5','173','247543','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703997),('5','173','247546','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704003),('5','173','247546','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704004),('5','173','247546','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704005),('5','173','247773','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704572),('5','173','247773','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704573),('5','173','247773','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704574),('5','173','248027','400',165.00,165.00,2920.93,0.00,0.00,0.00,0.00,705238),('5','173','248027','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705239),('5','173','248027','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705240),('5','173','248351','400',165.00,165.00,3904.27,0.00,0.00,0.00,0.00,706095),('5','173','248351','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706096),('5','173','248351','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706097),('5','173','248504','400',165.00,165.00,2487.58,0.00,0.00,0.00,0.00,706463),('5','173','248504','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706464),('5','173','248504','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706465),('5','173','248814','400',165.00,165.00,2825.20,0.00,0.00,0.00,0.00,707281),('5','173','248814','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707282),('5','173','248814','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707283),('5','173','249241','400',165.00,165.00,1930.56,0.00,0.00,0.00,0.00,708370),('5','173','249241','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708371),('5','173','249241','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708372),('5','173','249383','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708711),('5','173','249383','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708712),('5','173','249383','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708713),('5','173','249732','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709631),('5','173','249732','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709632),('5','173','249732','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709633),('5','173','250013','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710353),('5','173','250013','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710354),('5','173','250013','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710355),('5','173','250281','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711038),('5','173','250281','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711039),('5','173','250281','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711040),('5','173','250482','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711539),('5','173','250482','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711540),('5','173','250482','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711541),('5','173','250705','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712118),('5','173','250705','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712119),('5','173','250705','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712120),('5','173','250883','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,712565),('5','173','250883','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712566),('5','173','250883','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712567),('5','173','251254','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,713551),('5','173','251254','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713552),('5','173','251254','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713553),('5','173','251381','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713863),('5','173','251381','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713864),('5','173','251381','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713865),('5','173','251927','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715306),('5','173','251927','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715307),('5','173','251927','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715308),('5','173','252221','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716083),('5','173','252221','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716084),('5','173','252221','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716085),('5','173','252420','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,716592),('5','173','252420','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716593),('5','173','252420','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716594),('5','173','252595','400',165.00,165.00,7430.22,0.00,0.00,0.00,0.00,717036),('5','173','252595','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717037),('5','173','252595','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717038),('5','173','252800','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717556),('5','173','252800','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717557),('5','173','252800','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717558),('5','173','252814','400',165.00,165.00,4439.07,0.00,0.00,0.00,0.00,717593),('5','173','252814','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717594),('5','173','252814','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717595),('5','173','252903','400',165.00,165.00,4640.40,0.00,0.00,0.00,0.00,717840),('5','173','252903','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717841),('5','173','252903','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717842),('5','173','253311','400',165.00,165.00,3762.02,0.00,0.00,0.00,0.00,718899),('5','173','253311','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718900),('5','173','253311','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718901),('5','173','253414','400',165.00,165.00,2199.82,0.00,0.00,0.00,0.00,719175),('5','173','253414','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719176),('5','173','253414','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719177),('5','173','253560','400',165.00,165.00,1580.90,0.00,0.00,0.00,0.00,719538),('5','173','253560','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719539),('5','173','253560','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719540),('5','173','253814','400',165.00,165.00,520.00,0.00,0.00,0.00,0.00,720199),('5','173','253814','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720200),('5','173','253814','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720201),('5','173','254377','400',165.00,165.00,1015.03,0.00,0.00,0.00,0.00,721674),('5','173','254377','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721675),('5','173','254377','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721676),('5','173','254419','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721794),('5','173','254419','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721795),('5','173','254419','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721796),('5','173','254572','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722154),('5','173','254572','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722155),('5','173','254572','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722156),('5','173','254813','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722765),('5','173','254813','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722766),('5','173','254813','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722767),('5','173','255020','400',165.00,165.00,652.51,0.00,0.00,0.00,0.00,723289),('5','173','255020','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723290),('5','173','255020','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723291),('5','173','255301','400',165.00,165.00,3064.83,0.00,0.00,0.00,0.00,724016),('5','173','255301','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724017),('5','173','255301','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724018),('5','173','255754','400',165.00,165.00,3039.41,0.00,0.00,0.00,0.00,725136),('5','173','255754','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725137),('5','173','255754','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725138),('5','173','255906','400',165.00,165.00,1555.08,0.00,0.00,0.00,0.00,725540),('5','173','255906','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725541),('5','173','255906','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725542),('5','173','256342','400',165.00,165.00,2304.76,0.00,0.00,0.00,0.00,726615),('5','173','256342','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726616),('5','173','256342','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726617),('5','173','256381','400',165.00,165.00,2078.70,0.00,0.00,0.00,0.00,726730),('5','173','256381','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726731),('5','173','256381','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726732),('5','173','256590','400',165.00,165.00,1200.32,0.00,0.00,0.00,0.00,727263),('5','173','256590','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727264),('5','173','256590','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727265),('5','173','256893','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728066),('5','173','256893','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728067),('5','173','256893','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728068),('5','173','257077','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728531),('5','173','257077','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728532),('5','173','257077','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728533),('5','173','257495','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729637),('5','173','257495','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729638),('5','173','257495','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729639),('5','173','257659','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730066),('5','173','257659','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730067),('5','173','257659','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730068),('5','173','257660','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730069),('5','173','257660','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','173','257660','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','173','257661','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730072),('5','173','257661','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730073),('5','173','257661','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730074),('5','173','257662','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730075),('5','173','257662','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','173','257662','400',165.00,165.00,1511.75,0.00,0.00,0.00,0.00,730077),('5','173','257663','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730078),('5','173','257663','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','173','257663','400',165.00,165.00,1629.12,0.00,0.00,0.00,0.00,730080),('5','173','257664','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730081),('5','173','257664','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','173','257664','400',165.00,165.00,4377.10,0.00,0.00,0.00,0.00,730083),('5','173','257665','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730084),('5','173','257665','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','173','257665','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','173','257666','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730087),('5','173','257666','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','173','257666','400',165.00,165.00,6207.94,0.00,0.00,0.00,0.00,730089),('5','173','257667','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730090),('5','173','257667','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','173','257667','400',165.00,165.00,3795.06,0.00,0.00,0.00,0.00,730092),('5','173','257668','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730093),('5','173','257668','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','173','257668','400',165.00,165.00,8545.85,0.00,0.00,0.00,0.00,730095),('5','173','257669','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730096),('5','173','257669','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','173','257669','400',165.00,165.00,6193.39,0.00,0.00,0.00,0.00,730098),('5','173','257670','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730099),('5','173','257670','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','173','257670','400',165.00,165.00,10152.61,0.00,0.00,0.00,0.00,730101),('5','173','257671','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730102),('5','173','257671','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','173','257671','400',165.00,165.00,12343.27,0.00,0.00,0.00,0.00,730104),('5','173','257672','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730105),('5','173','257672','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','173','257672','400',165.00,165.00,6432.40,0.00,0.00,0.00,0.00,730107),('5','173','257673','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730108),('5','173','257673','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','173','257673','400',165.00,165.00,6914.59,0.00,0.00,0.00,0.00,730110),('5','173','257674','400',165.00,165.00,4966.73,0.00,0.00,0.00,0.00,730111),('5','173','257674','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730112),('5','173','257674','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730113),('5','173','257675','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730114),('5','173','257675','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','173','257675','400',165.00,165.00,2246.14,0.00,0.00,0.00,0.00,730116),('5','173','257676','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730117),('5','173','257676','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','173','257676','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730119),('5','173','257677','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730120),('5','173','257677','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','173','257677','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730122),('5','173','257678','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730123),('5','173','257678','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','173','257678','400',165.00,165.00,1601.81,0.00,0.00,0.00,0.00,730125),('5','173','257679','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730126),('5','173','257679','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','173','257679','400',165.00,165.00,5819.77,0.00,0.00,0.00,0.00,730128),('5','173','257680','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730129),('5','173','257680','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','173','257680','400',165.00,165.00,4653.77,0.00,0.00,0.00,0.00,730131),('5','173','257681','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730132),('5','173','257681','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','173','257681','400',165.00,165.00,4309.05,0.00,0.00,0.00,0.00,730134),('5','173','257682','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730135),('5','173','257682','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','173','257682','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730137),('5','173','257683','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730138),('5','173','257683','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','173','257683','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730140),('5','173','257684','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730141),('5','173','257684','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','173','257684','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730143),('5','173','257685','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730144),('5','173','257685','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','173','257685','400',165.00,165.00,7550.65,0.00,0.00,0.00,0.00,730146),('5','173','257686','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730147),('5','173','257686','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','173','257686','400',165.00,165.00,10009.76,0.00,0.00,0.00,0.00,730149),('5','173','257687','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730150),('5','173','257687','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','173','257687','400',165.00,165.00,2015.23,0.00,0.00,0.00,0.00,730152),('5','173','257688','400',165.00,165.00,15639.36,0.00,0.00,0.00,0.00,730153),('5','173','257688','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730154),('5','173','257688','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730155),('5','173','257689','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730156),('5','173','257689','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','173','257689','400',165.00,165.00,12261.17,0.00,0.00,0.00,0.00,730158),('5','173','257690','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730159),('5','173','257690','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','173','257690','400',165.00,165.00,2307.80,0.00,0.00,0.00,0.00,730161),('5','173','257691','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730162),('5','173','257691','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','173','257691','400',165.00,165.00,2800.00,0.00,0.00,0.00,0.00,730164),('5','173','257692','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730165),('5','173','257692','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','173','257692','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730167),('5','173','257693','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730168),('5','173','257693','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','173','257693','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730170),('5','173','257694','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730171),('5','173','257694','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','173','257694','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730173),('5','173','257695','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730174),('5','173','257695','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','173','257695','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730176),('5','173','257696','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730177),('5','173','257696','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','173','257696','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730179),('5','173','257697','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730180),('5','173','257697','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','173','257697','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730182),('5','173','257698','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730183),('5','173','257698','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','173','257698','400',165.00,165.00,10511.69,0.00,0.00,0.00,0.00,730185),('5','173','257699','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730186),('5','173','257699','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','173','257699','400',165.00,165.00,10942.75,0.00,0.00,0.00,0.00,730188),('5','173','257700','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730189),('5','173','257700','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','173','257700','400',165.00,165.00,25016.14,0.00,0.00,0.00,0.00,730191),('5','173','257701','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730192),('5','173','257701','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','173','257701','400',165.00,165.00,15763.59,0.00,0.00,0.00,0.00,730194),('5','173','257702','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730195),('5','173','257702','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','173','257702','400',165.00,165.00,11027.14,0.00,0.00,0.00,0.00,730197),('5','173','257703','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730198),('5','173','257703','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','173','257703','400',165.00,165.00,6201.83,0.00,0.00,0.00,0.00,730200),('5','173','257704','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730201),('5','173','257704','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','173','257704','400',165.00,165.00,5528.78,0.00,0.00,0.00,0.00,730203),('5','173','257705','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730204),('5','173','257705','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','173','257705','400',165.00,165.00,3158.30,0.00,0.00,0.00,0.00,730206),('5','173','257706','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730207),('5','173','257706','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','173','257706','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730209),('5','173','257707','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730210),('5','173','257707','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','173','257707','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730212),('5','173','257708','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730213),('5','173','257708','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','173','257708','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730215),('5','173','257709','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730216),('5','173','257709','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','173','257709','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730218),('5','173','257710','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730219),('5','173','257710','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','173','257710','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730221),('5','173','257711','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730222),('5','173','257711','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','173','257711','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730224),('5','173','257712','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730225),('5','173','257712','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','173','257712','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730227),('5','173','257713','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730228),('5','173','257713','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','173','257713','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730230),('5','173','257714','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730231),('5','173','257714','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','173','257714','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730233),('5','173','257715','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730234),('5','173','257715','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','173','257715','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730236),('5','173','257716','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730237),('5','173','257716','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','173','257716','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730239),('5','173','257717','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730240),('5','173','257717','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','173','257717','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730242),('5','173','257718','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730243),('5','173','257718','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','173','257718','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730245),('5','173','257719','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730246),('5','173','257719','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730247),('5','173','257719','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730248),('5','173','257720','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730249),('5','173','257720','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','173','257720','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730251),('5','173','257721','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730252),('5','173','257721','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','173','257721','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730254),('5','173','257722','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730255),('5','173','257722','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','173','257722','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730257),('5','173','257723','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730258),('5','173','257723','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','173','257723','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730260),('5','173','257724','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730261),('5','173','257724','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','173','257724','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730263),('5','173','257725','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730264),('5','173','257725','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','173','257725','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730266),('5','173','257726','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730267),('5','173','257726','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730268),('5','173','257726','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730269),('5','173','257727','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730270),('5','173','257727','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730271),('5','173','257727','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730272),('5','173','257728','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730273),('5','173','257728','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','173','257728','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730275),('5','173','257729','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730276),('5','173','257729','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','173','257729','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730278),('5','173','257730','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730279),('5','173','257730','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','173','257730','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730281),('5','173','257731','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730282),('5','173','257731','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730283),('5','173','257731','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','173','257732','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730285),('5','173','257732','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','173','257732','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730287),('5','173','257733','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730288),('5','173','257733','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730289),('5','173','257733','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730290),('5','173','257734','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730291),('5','173','257734','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','173','257734','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730293),('5','173','257735','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730294),('5','173','257735','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','173','257735','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730296),('5','173','257736','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730297),('5','173','257736','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','173','257736','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730299),('5','173','257737','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730300),('5','173','257737','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','173','257737','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730302),('5','173','257738','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730303),('5','173','257738','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730304),('5','173','257738','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730305),('5','173','257739','400',165.00,162.00,0.00,0.00,0.00,0.00,0.00,730306),('5','173','257739','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730307),('5','173','257739','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730308),('5','173','257740','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730309),('5','173','257740','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730310),('5','173','257740','400',165.00,165.00,650.00,0.00,0.00,0.00,0.00,730311),('5','173','257741','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730312),('5','173','257741','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730313),('5','173','257741','400',165.00,165.00,3913.01,0.00,0.00,0.00,0.00,730314),('5','173','257742','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730315),('5','173','257742','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','173','257742','400',165.00,165.00,4985.91,0.00,0.00,0.00,0.00,730317),('5','173','257743','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730318),('5','173','257743','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','173','257743','400',165.00,165.00,3818.24,0.00,0.00,0.00,0.00,730320),('5','173','257744','400',165.00,165.00,3901.75,0.00,0.00,0.00,0.00,730321),('5','173','257744','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730322),('5','173','257744','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730323),('5','173','257745','400',165.00,165.00,4209.11,0.00,0.00,0.00,0.00,730324),('5','173','257745','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730325),('5','173','257745','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','173','257746','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730327),('5','173','257746','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730328),('5','173','257746','400',165.00,165.00,4190.79,0.00,0.00,0.00,0.00,730329),('5','173','257747','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730330),('5','173','257747','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730331),('5','173','257747','400',165.00,165.00,3082.07,0.00,0.00,0.00,0.00,730332),('5','173','257748','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730333),('5','173','257748','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','173','257748','400',165.00,165.00,3852.97,0.00,0.00,0.00,0.00,730335),('5','173','257749','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730336),('5','173','257749','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730337),('5','173','257749','400',165.00,165.00,3207.55,0.00,0.00,0.00,0.00,730338),('5','173','257750','400',165.00,165.00,2714.02,0.00,0.00,0.00,0.00,730339),('5','173','257750','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730340),('5','173','257750','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','173','257751','400',165.00,165.00,2668.88,0.00,0.00,0.00,0.00,730342),('5','173','257751','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730343),('5','173','257751','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','173','257752','400',165.00,165.00,1820.37,0.00,0.00,0.00,0.00,730345),('5','173','257752','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730346),('5','173','257752','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','173','257753','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730348),('5','173','257753','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730349),('5','173','257753','400',165.00,165.00,600.02,0.00,0.00,0.00,0.00,730350),('5','173','257754','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730351),('5','173','257754','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730352),('5','173','257754','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','173','257755','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730354),('5','173','257755','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730355),('5','173','257755','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','173','257756','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730357),('5','173','257756','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730358),('5','173','257756','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','173','257757','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730360),('5','173','257757','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730361),('5','173','257757','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','173','257758','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730363),('5','173','257758','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730364),('5','173','257758','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730365),('5','173','257759','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730366),('5','173','257759','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','173','257759','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730368),('5','173','257760','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730369),('5','173','257760','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','173','257760','400',165.00,165.00,560.00,0.00,0.00,0.00,0.00,730371),('5','173','257761','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730372),('5','173','257761','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','173','257761','400',165.00,165.00,4942.20,0.00,0.00,0.00,0.00,730374),('5','173','257762','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730375),('5','173','257762','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','173','257762','400',165.00,165.00,5057.80,0.00,0.00,0.00,0.00,730377),('5','173','257763','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730378),('5','173','257763','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','173','257763','400',165.00,165.00,5311.78,0.00,0.00,0.00,0.00,730380),('5','173','257764','400',165.00,165.00,4688.22,0.00,0.00,0.00,0.00,730381),('5','173','257764','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730382),('5','173','257764','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730383),('5','173','257765','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730384),('5','173','257765','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','173','257765','400',165.00,165.00,4705.36,0.00,0.00,0.00,0.00,730386),('5','173','257766','400',165.00,165.00,3920.50,0.00,0.00,0.00,0.00,730387),('5','173','257766','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730388),('5','173','257766','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730389),('5','173','257767','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730390),('5','173','257767','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730391),('5','173','257767','400',165.00,165.00,4079.40,0.00,0.00,0.00,0.00,730392),('5','173','257768','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730393),('5','173','257768','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','173','257768','400',165.00,165.00,4153.95,0.00,0.00,0.00,0.00,730395),('5','173','257769','400',165.00,165.00,3846.04,0.00,0.00,0.00,0.00,730396),('5','173','257769','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730397),('5','173','257769','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730398),('5','173','257770','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730399),('5','173','257770','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730400),('5','173','257770','400',165.00,165.00,2944.96,0.00,0.00,0.00,0.00,730401),('5','173','257771','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730402),('5','173','257771','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730403),('5','173','257771','400',165.00,165.00,1200.15,0.00,0.00,0.00,0.00,730404),('5','173','257772','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730405),('5','173','257772','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','173','257772','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730407),('5','173','257773','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730408),('5','173','257773','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','173','257773','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730410),('5','173','257774','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730411),('5','173','257774','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','173','257774','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730413),('5','173','257775','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730414),('5','173','257775','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730415),('5','173','257775','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','173','257776','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730417),('5','173','257776','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730418),('5','173','257776','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730419),('5','173','257777','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730420),('5','173','257777','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','173','257777','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730422),('5','173','257778','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730423),('5','173','257778','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730424),('5','173','257778','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730425),('5','173','257779','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730426),('5','173','257779','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730427),('5','173','257779','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730428),('5','173','257780','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730429),('5','173','257780','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','173','257780','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730431),('5','173','257781','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730432),('5','173','257781','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730433),('5','173','257781','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730434),('5','173','257782','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730435),('5','173','257782','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730436),('5','173','257782','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730437),('5','173','257783','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730438),('5','173','257783','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730439),('5','173','257783','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','173','257784','400',165.00,165.00,2948.06,0.00,0.00,0.00,0.00,730441),('5','173','257784','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730442),('5','173','257784','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730443),('5','173','257785','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730444),('5','173','257785','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','173','257785','400',165.00,165.00,5051.92,0.00,0.00,0.00,0.00,730446),('5','173','257786','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730447),('5','173','257786','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','173','257786','400',165.00,165.00,4702.05,0.00,0.00,0.00,0.00,730449),('5','173','257787','400',165.00,165.00,4702.06,0.00,0.00,0.00,0.00,730450),('5','173','257787','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730451),('5','173','257787','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730452),('5','173','257788','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730453),('5','173','257788','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730454),('5','173','257788','400',165.00,165.00,8121.76,0.00,0.00,0.00,0.00,730455),('5','173','257789','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730456),('5','173','257789','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730457),('5','173','257789','400',165.00,165.00,7200.00,0.00,0.00,0.00,0.00,730458),('5','173','257790','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730459),('5','173','257790','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730460),('5','173','257790','400',165.00,165.00,5506.17,0.00,0.00,0.00,0.00,730461),('5','173','257791','400',165.00,165.00,6573.09,0.00,0.00,0.00,0.00,730462),('5','173','257791','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730463),('5','173','257791','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730464),('5','173','257792','400',165.00,165.00,5178.28,0.00,0.00,0.00,0.00,730465),('5','173','257792','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730466),('5','173','257792','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','173','257793','400',165.00,165.00,4821.71,0.00,0.00,0.00,0.00,730468),('5','173','257793','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730469),('5','173','257793','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730470),('5','173','257794','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730471),('5','173','257794','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','173','257794','400',165.00,165.00,5006.18,0.00,0.00,0.00,0.00,730473),('5','173','257795','400',165.00,165.00,4993.82,0.00,0.00,0.00,0.00,730474),('5','173','257795','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730475),('5','173','257795','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730476),('5','173','257796','400',165.00,165.00,4082.30,0.00,0.00,0.00,0.00,730477),('5','173','257796','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730478),('5','173','257796','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730479),('5','173','257797','400',165.00,165.00,3720.70,0.00,0.00,0.00,0.00,730480),('5','173','257797','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730481),('5','173','257797','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','173','257798','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730483),('5','173','257798','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730484),('5','173','257798','400',165.00,165.00,3458.20,0.00,0.00,0.00,0.00,730485),('5','173','257799','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730486),('5','173','257799','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730487),('5','173','257799','400',165.00,165.00,3004.90,0.00,0.00,0.00,0.00,730488),('5','173','257800','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730489),('5','173','257800','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730490),('5','173','257800','400',165.00,165.00,2921.59,0.00,0.00,0.00,0.00,730491),('5','173','257801','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730492),('5','173','257801','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730493),('5','173','257801','400',165.00,165.00,2503.40,0.00,0.00,0.00,0.00,730494),('5','173','257802','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730495),('5','173','257802','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730496),('5','173','257802','400',165.00,165.00,1608.71,0.00,0.00,0.00,0.00,730497),('5','173','257803','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730498),('5','173','257803','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730499),('5','173','257803','400',165.00,165.00,2001.08,0.00,0.00,0.00,0.00,730500),('5','173','257804','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730501),('5','173','257804','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730502),('5','173','257804','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730503),('5','173','257805','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730504),('5','173','257805','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730505),('5','173','257805','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730506),('5','173','257806','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730507),('5','173','257806','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730508),('5','173','257806','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730509),('5','173','257807','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730510),('5','173','257807','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730511),('5','173','257807','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730512),('5','173','257808','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730513),('5','173','257808','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','173','257808','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730515),('5','173','257809','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730516),('5','173','257809','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730517),('5','173','257809','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730518),('5','173','257810','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730519),('5','173','257810','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730520),('5','173','257810','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730521),('5','173','257811','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730522),('5','173','257811','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730523),('5','173','257811','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730524),('5','173','257812','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730525),('5','173','257812','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730526),('5','173','257812','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730527),('5','173','257813','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730528),('5','173','257813','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730529),('5','173','257813','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730530),('5','173','257814','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730531),('5','173','257814','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730532),('5','173','257814','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730533),('5','173','257815','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730534),('5','173','257815','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730535),('5','173','257815','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730536),('5','173','257816','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730537),('5','173','257816','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730538),('5','173','257816','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730539),('5','173','257817','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730540),('5','173','257817','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730541),('5','173','257817','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730542),('5','173','257818','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730543),('5','173','257818','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730544),('5','173','257818','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730545),('5','173','257819','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730546),('5','173','257819','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730547),('5','173','257819','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730548),('5','173','257820','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730549),('5','173','257820','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730550),('5','173','257820','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730551),('5','173','257821','400',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730552),('5','173','257821','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730553),('5','173','257821','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730554),('5','173','257822','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730555),('5','173','257822','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730556),('5','173','257822','400',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730557),('5','173','257823','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730558),('5','173','257823','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730559),('5','173','257823','400',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730560),('5','173','257824','400',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','173','257824','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730562),('5','173','257824','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730563),('5','173','257825','400',165.00,185.00,786.05,0.00,0.00,0.00,0.00,730564),('5','173','257825','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730565),('5','173','257825','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730566),('5','173','257826','400',185.00,185.00,4437.90,0.00,0.00,0.00,0.00,730567),('5','173','257826','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730568),('5','173','257826','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730569),('5','173','257827','400',185.00,185.00,5562.10,0.00,0.00,0.00,0.00,730570),('5','173','257827','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730571),('5','173','257827','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730572),('5','173','257828','400',185.00,185.00,5460.25,0.00,0.00,0.00,0.00,730573),('5','173','257828','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730574),('5','173','257828','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730575),('5','173','257829','400',185.00,186.00,4539.75,0.00,0.00,0.00,0.00,730576),('5','173','257829','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730577),('5','173','257829','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730578),('5','173','257830','400',185.00,185.00,5406.83,0.00,0.00,0.00,0.00,730579),('5','173','257830','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730580),('5','173','257830','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730581),('5','173','257831','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730582),('5','173','257831','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','173','257831','400',185.00,185.00,4093.17,0.00,0.00,0.00,0.00,730584),('5','173','257832','400',185.00,185.00,3502.97,0.00,0.00,0.00,0.00,730585),('5','173','257832','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730586),('5','173','257832','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730587),('5','173','257833','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730588),('5','173','257833','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','173','257833','400',185.00,185.00,2996.83,0.00,0.00,0.00,0.00,730590),('5','173','257834','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730591),('5','173','257834','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730592),('5','173','257834','400',185.00,185.00,2865.21,0.00,0.00,0.00,0.00,730593),('5','173','257835','400',185.00,185.00,2749.82,0.00,0.00,0.00,0.00,730594),('5','173','257835','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730595),('5','173','257835','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730596),('5','173','257836','400',185.00,185.00,4003.89,0.00,0.00,0.00,0.00,730597),('5','173','257836','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730598),('5','173','257836','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730599),('5','173','257837','400',185.00,185.00,3010.17,0.00,0.00,0.00,0.00,730600),('5','173','257837','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730601),('5','173','257837','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730602),('5','173','257838','400',185.00,185.00,1221.59,0.00,0.00,0.00,0.00,730603),('5','173','257838','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730604),('5','173','257838','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730605),('5','173','257839','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730606),('5','173','257839','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730607),('5','173','257839','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730608),('5','173','257840','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730609),('5','173','257840','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730610),('5','173','257840','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730611),('5','173','257841','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730612),('5','173','257841','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730613),('5','173','257841','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730614),('5','173','257842','401',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730615),('5','173','257842','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730616),('5','173','257842','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730617),('5','173','257843','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730618),('5','173','257843','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730619),('5','173','257843','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730620),('5','173','257844','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730621),('5','173','257844','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','173','257844','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730623),('5','173','257845','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730624),('5','173','257845','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','173','257845','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730626),('5','173','257846','400',185.00,185.00,1204.21,0.00,0.00,0.00,0.00,730627),('5','173','257846','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730628),('5','173','257846','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730629),('5','173','257847','400',185.00,185.00,4414.51,0.00,0.00,0.00,0.00,730630),('5','173','257847','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730631),('5','173','257847','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','173','257848','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730633),('5','173','257848','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730634),('5','173','257848','400',185.00,185.00,4899.10,0.00,0.00,0.00,0.00,730635),('5','173','257849','400',185.00,185.00,3990.00,0.00,0.00,0.00,0.00,730636),('5','173','257849','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730637),('5','173','257849','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730638),('5','173','257850','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730639),('5','173','257850','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','173','257850','400',185.00,185.00,2803.12,0.00,0.00,0.00,0.00,730641),('5','173','257851','400',185.00,185.00,3760.56,0.00,0.00,0.00,0.00,730642),('5','173','257851','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730643),('5','173','257851','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730644),('5','173','257852','400',185.00,185.00,2403.08,0.00,0.00,0.00,0.00,730645),('5','173','257852','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730646),('5','173','257852','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730647),('5','173','257853','400',185.00,185.00,1403.20,0.00,0.00,0.00,0.00,730648),('5','173','257853','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730649),('5','173','257853','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730650),('5','173','257854','400',185.00,185.00,4748.87,0.00,0.00,0.00,0.00,730651),('5','173','257854','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730652),('5','173','257854','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730653),('5','173','257855','400',185.00,185.00,2341.73,0.00,0.00,0.00,0.00,730654),('5','173','257855','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730655),('5','173','257855','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730656),('5','173','257856','400',185.00,185.00,4709.90,0.00,0.00,0.00,0.00,730657),('5','173','257856','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730658),('5','173','257856','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730659),('5','173','257857','400',185.00,185.00,4690.42,0.00,0.00,0.00,0.00,730660),('5','173','257857','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730661),('5','173','257857','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730662),('5','173','257858','400',185.00,185.00,4234.96,0.00,0.00,0.00,0.00,730663),('5','173','257858','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730664),('5','173','257858','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730665),('5','173','257859','400',185.00,185.00,4650.12,0.00,0.00,0.00,0.00,730666),('5','173','257859','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730667),('5','173','257859','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730668),('5','173','257860','400',185.00,185.00,4960.70,0.00,0.00,0.00,0.00,730669),('5','173','257860','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730670),('5','173','257860','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730671),('5','173','257861','400',185.00,185.00,4283.20,0.00,0.00,0.00,0.00,730672),('5','173','257861','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730673),('5','173','257861','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730674),('5','173','257862','400',185.00,185.00,4049.83,0.00,0.00,0.00,0.00,730675),('5','173','257862','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730676),('5','173','257862','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730677),('5','173','257863','400',185.00,185.00,4658.20,0.00,0.00,0.00,0.00,730678),('5','173','257863','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730679),('5','173','257863','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730680),('5','173','257864','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730681),('5','173','257864','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','173','257864','400',185.00,185.00,4741.90,0.00,0.00,0.00,0.00,730683),('5','173','257865','400',185.00,185.00,3850.81,0.00,0.00,0.00,0.00,730684),('5','173','257865','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730685),('5','173','257865','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730686),('5','173','257866','400',185.00,185.00,4736.22,0.00,0.00,0.00,0.00,730687),('5','173','257866','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730688),('5','173','257866','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730689),('5','173','257867','400',185.00,185.00,6029.64,0.00,0.00,0.00,0.00,730690),('5','173','257867','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730691),('5','173','257867','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730692),('5','173','257868','400',185.00,185.00,6116.69,0.00,0.00,0.00,0.00,730693),('5','173','257868','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730694),('5','173','257868','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730695),('5','173','257869','400',185.00,185.00,4517.19,0.00,0.00,0.00,0.00,730696),('5','173','257869','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730697),('5','173','257869','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730698),('5','173','257870','400',185.00,185.00,3143.13,0.00,0.00,0.00,0.00,730699),('5','173','257870','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730700),('5','173','257870','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730701),('5','173','257871','400',185.00,186.00,3011.18,0.00,0.00,0.00,0.00,730702),('5','173','257871','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730703),('5','173','257871','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730704),('5','173','257872','400',185.00,185.00,2046.81,0.00,0.00,0.00,0.00,730705),('5','173','257872','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730706),('5','173','257872','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730707),('5','173','257873','400',185.00,185.00,2243.77,0.00,0.00,0.00,0.00,730708),('5','173','257873','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730709),('5','173','257873','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730710),('5','173','257874','400',185.00,185.00,3015.20,0.00,0.00,0.00,0.00,730711),('5','173','257874','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730712),('5','173','257874','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730713),('5','173','257875','400',185.00,185.00,2048.12,0.00,0.00,0.00,0.00,730714),('5','173','257875','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730715),('5','173','257875','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730716),('5','173','257876','400',185.00,185.00,2047.98,0.00,0.00,0.00,0.00,730717),('5','173','257876','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730718),('5','173','257876','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730719),('5','173','257877','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730720),('5','173','257877','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730721),('5','173','257877','400',185.00,185.00,2820.50,0.00,0.00,0.00,0.00,730722),('5','173','257878','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730723),('5','173','257878','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730724),('5','173','257878','400',185.00,185.00,4029.49,0.00,0.00,0.00,0.00,730725),('5','173','257879','400',185.00,185.00,2067.10,0.00,0.00,0.00,0.00,730726),('5','173','257879','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730727),('5','173','257879','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730728),('5','173','257880','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730729),('5','173','257880','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730730),('5','173','257880','400',185.00,185.00,2574.54,0.00,0.00,0.00,0.00,730731),('5','173','257881','400',185.00,185.00,2131.36,0.00,0.00,0.00,0.00,730732),('5','173','257881','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730733),('5','173','257881','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730734),('5','173','257882','400',185.00,185.00,2406.29,0.00,0.00,0.00,0.00,730735),('5','173','257882','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730736),('5','173','257882','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730737),('5','173','257883','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730738),('5','173','257883','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730739),('5','173','257883','400',185.00,185.00,2008.24,0.00,0.00,0.00,0.00,730740),('5','173','257884','400',185.00,185.00,2155.75,0.00,0.00,0.00,0.00,730741),('5','173','257884','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730742),('5','173','257884','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730743),('5','173','257885','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730744),('5','173','257885','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730745),('5','173','257885','400',185.00,185.00,2202.07,0.00,0.00,0.00,0.00,730746),('5','173','257886','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730747),('5','173','257886','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730748),('5','173','257886','400',185.00,185.00,798.61,0.00,0.00,0.00,0.00,730749),('5','173','257887','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730750),('5','173','257887','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730751),('5','173','257887','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730752),('5','173','257888','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730753),('5','173','257888','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730754),('5','173','257888','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730755),('5','173','257889','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730756),('5','173','257889','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730757),('5','173','257889','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730758),('5','173','257890','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730759),('5','173','257890','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730760),('5','173','257890','400',185.00,185.00,748.74,0.00,0.00,0.00,0.00,730761),('5','173','257891','400',185.00,185.00,2031.81,0.00,0.00,0.00,0.00,730762),('5','173','257891','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730763),('5','173','257891','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730764),('5','173','257892','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730765),('5','173','257892','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730766),('5','173','257892','400',185.00,185.00,1204.97,0.00,0.00,0.00,0.00,730767),('5','173','257893','400',185.00,185.00,1292.13,0.00,0.00,0.00,0.00,730768),('5','173','257893','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730769),('5','173','257893','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730770),('5','173','257894','400',185.00,185.00,1322.33,0.00,0.00,0.00,0.00,730771),('5','173','257894','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730772),('5','173','257894','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730773),('5','173','257895','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730774),('5','173','257895','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730775),('5','173','257895','400',185.00,185.00,1172.75,0.00,0.00,0.00,0.00,730776),('5','173','257896','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730777),('5','173','257896','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730778),('5','173','257896','400',185.00,185.00,1211.76,0.00,0.00,0.00,0.00,730779),('5','173','257897','400',185.00,185.00,1101.16,0.00,0.00,0.00,0.00,730780),('5','173','257897','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730781),('5','173','257897','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730782),('5','173','257898','400',185.00,185.00,1129.10,0.00,0.00,0.00,0.00,730783),('5','173','257898','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730784),('5','173','257898','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730785),('5','173','257899','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730786),('5','173','257899','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730787),('5','173','257899','400',185.00,185.00,1102.15,0.00,0.00,0.00,0.00,730788),('5','173','257900','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730789),('5','173','257900','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730790),('5','173','257900','400',185.00,185.00,1332.82,0.00,0.00,0.00,0.00,730791),('5','173','257901','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730792),('5','173','257901','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730793),('5','173','257901','400',185.00,185.00,1020.34,0.00,0.00,0.00,0.00,730794),('5','173','257902','400',185.00,185.00,1101.48,0.00,0.00,0.00,0.00,730795),('5','173','257902','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730796),('5','173','257902','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730797),('5','173','257903','400',185.00,185.00,1384.28,0.00,0.00,0.00,0.00,730798),('5','173','257903','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730799),('5','173','257903','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730800),('5','173','257904','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730801),('5','173','257904','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730802),('5','173','257904','400',185.00,185.00,1247.89,0.00,0.00,0.00,0.00,730803),('5','173','257905','400',185.00,185.00,1115.92,0.00,0.00,0.00,0.00,730804),('5','173','257905','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730805),('5','173','257905','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730806),('5','173','257906','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730807),('5','173','257906','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730808),('5','173','257906','400',185.00,185.00,1076.13,0.00,0.00,0.00,0.00,730809),('5','173','257907','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730810),('5','173','257907','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730811),('5','173','257907','400',185.00,185.00,1408.06,0.00,0.00,0.00,0.00,730812),('5','173','257908','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730813),('5','173','257908','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730814),('5','173','257908','400',185.00,185.00,3563.38,0.00,0.00,0.00,0.00,730815),('5','173','257909','400',185.00,186.00,4875.20,0.00,0.00,0.00,0.00,730816),('5','173','257909','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730817),('5','173','257909','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730818),('5','173','257910','400',185.00,185.00,8542.49,0.00,0.00,0.00,0.00,730819),('5','173','257910','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730820),('5','173','257910','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730821),('5','173','257911','400',185.00,185.00,6503.47,0.00,0.00,0.00,0.00,730822),('5','173','257911','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730823),('5','173','257911','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730824),('5','173','257912','400',185.00,185.00,9406.90,0.00,0.00,0.00,0.00,730825),('5','173','257912','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730826),('5','173','257912','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730827),('5','173','257913','400',185.00,185.00,4887.11,0.00,0.00,0.00,0.00,730828),('5','173','257913','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730829),('5','173','257913','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730830),('5','173','257914','400',185.00,185.00,4034.48,0.00,0.00,0.00,0.00,730831),('5','173','257914','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730832),('5','173','257914','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730833),('5','173','257915','400',185.00,185.00,6568.25,0.00,0.00,0.00,0.00,730834),('5','173','257915','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730835),('5','173','257915','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730836),('5','173','257916','400',185.00,185.00,3453.88,0.00,0.00,0.00,0.00,730837),('5','173','257916','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730838),('5','173','257916','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730839),('5','173','257917','400',185.00,185.00,4686.12,0.00,0.00,0.00,0.00,730840),('5','173','257917','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730841),('5','173','257917','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730842),('5','173','257918','400',185.00,185.00,2674.04,0.00,0.00,0.00,0.00,730843),('5','173','257918','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730844),('5','173','257918','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730845),('5','173','257919','400',185.00,185.00,2903.88,0.00,0.00,0.00,0.00,730846),('5','173','257919','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730847),('5','173','257919','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730848),('5','173','257920','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730849),('5','173','257920','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730850),('5','173','257920','400',185.00,185.00,2305.95,0.00,0.00,0.00,0.00,730851),('5','173','257921','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730852),('5','173','257921','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730853),('5','173','257921','400',185.00,185.00,3343.20,0.00,0.00,0.00,0.00,730854),('5','173','257922','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730855),('5','173','257922','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730856),('5','173','257922','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730857),('5','173','257923','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730858),('5','173','257923','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730859),('5','173','257923','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730860),('5','173','257924','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730861),('5','173','257924','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730862),('5','173','257924','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730863),('5','173','257925','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730864),('5','173','257925','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730865),('5','173','257925','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730866),('5','173','257926','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730867),('5','173','257926','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730868),('5','173','257926','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730869),('5','173','257927','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730870),('5','173','257927','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730871),('5','173','257927','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730872),('5','173','257928','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730873),('5','173','257928','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730874),('5','173','257928','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730875),('5','173','257929','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730876),('5','173','257929','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730877),('5','173','257929','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730878),('5','173','257930','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730879),('5','173','257930','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730880),('5','173','257930','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730881),('5','173','257931','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730882),('5','173','257931','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730883),('5','173','257931','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730884),('5','173','257932','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730885),('5','173','257932','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730886),('5','173','257932','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730887),('5','173','257933','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730888),('5','173','257933','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730889),('5','173','257933','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730890),('5','173','257934','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730891),('5','173','257934','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730892),('5','173','257934','400',185.00,186.00,0.00,0.00,0.00,0.00,0.00,730893),('5','173','257935','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730894),('5','173','257935','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730895),('5','173','257935','400',185.00,185.00,3234.23,0.00,0.00,0.00,0.00,730896),('5','173','257936','400',185.00,185.00,6403.99,0.00,0.00,0.00,0.00,730897),('5','173','257936','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730898),('5','173','257936','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730899),('5','173','257937','400',185.00,185.00,6812.28,0.00,0.00,0.00,0.00,730900),('5','173','257937','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730901),('5','173','257937','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730902),('5','173','257938','400',185.00,185.00,5703.12,0.00,0.00,0.00,0.00,730903),('5','173','257938','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730904),('5','173','257938','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730905),('5','173','257939','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730906),('5','173','257939','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730907),('5','173','257939','400',185.00,185.00,5401.04,0.00,0.00,0.00,0.00,730908),('5','173','257940','400',185.00,185.00,5108.67,0.00,0.00,0.00,0.00,730909),('5','173','257940','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730910),('5','173','257940','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730911),('5','173','257941','400',185.00,185.00,4090.87,0.00,0.00,0.00,0.00,730912),('5','173','257941','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730913),('5','173','257941','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730914),('5','173','257942','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730915),('5','173','257942','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730916),('5','173','257942','400',185.00,185.00,5104.70,0.00,0.00,0.00,0.00,730917),('5','173','257943','400',185.00,185.00,2841.10,0.00,0.00,0.00,0.00,730918),('5','173','257943','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730919),('5','173','257943','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730920),('5','173','257944','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730921),('5','173','257944','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730922),('5','173','257944','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730923),('5','173','257945','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730924),('5','173','257945','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730925),('5','173','257945','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730926),('5','173','257946','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730927),('5','173','257946','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730928),('5','173','257946','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730929),('5','173','257947','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730930),('5','173','257947','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730931),('5','173','257947','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730932),('5','173','257948','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730933),('5','173','257948','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730934),('5','173','257948','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730935),('5','173','257949','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730936),('5','173','257949','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730937),('5','173','257949','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730938),('5','173','257950','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730939),('5','173','257950','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730940),('5','173','257950','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730941),('5','173','257951','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730942),('5','173','257951','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730943),('5','173','257951','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730944),('5','173','257952','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730945),('5','173','257952','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730946),('5','173','257952','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730947),('5','173','257953','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730948),('5','173','257953','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730949),('5','173','257953','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730950),('5','173','257954','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730951),('5','173','257954','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730952),('5','173','257954','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730953),('5','173','257955','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730954),('5','173','257955','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730955),('5','173','257955','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730956),('5','173','257956','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730957),('5','173','257956','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730958),('5','173','257956','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730959),('5','173','257957','400',185.00,162.00,0.00,0.00,0.00,0.00,0.00,730960),('5','173','257957','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730961),('5','173','257957','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730962),('5','173','257958','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730963),('5','173','257958','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730964),('5','173','257958','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730965),('5','173','257959','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730966),('5','173','257959','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730967),('5','173','257959','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730968),('5','173','257960','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730969),('5','173','257960','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730970),('5','173','257960','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730971),('5','173','257961','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730972),('5','173','257961','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730973),('5','173','257961','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730974),('5','173','257962','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730975),('5','173','257962','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730976),('5','173','257962','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730977),('5','173','257963','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730978),('5','173','257963','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730979),('5','173','257963','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730980),('5','173','257964','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730981),('5','173','257964','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730982),('5','173','257964','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730983),('5','173','257965','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730984),('5','173','257965','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730985),('5','173','257965','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730986),('5','173','257966','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730987),('5','173','257966','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730988),('5','173','257966','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730989),('5','173','257967','401',345.00,880.00,0.00,0.00,0.00,0.00,0.00,730990),('5','173','257967','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730991),('5','173','257967','400',185.00,186.00,0.00,0.00,0.00,0.00,0.00,730992),('5','173','257968','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730993),('5','173','257968','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730994),('5','173','257968','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730995),('5','173','257969','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730996),('5','173','257969','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730997),('5','173','257969','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730998),('5','173','257970','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730999),('5','173','257970','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731000),('5','173','257970','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,731001),('5','173','257971','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731002),('5','173','257971','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731003),('5','173','257971','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,731004),('5','173','257972','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,731005),('5','173','257972','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731006),('5','173','257972','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731007),('5','173','257973','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731008),('5','173','257973','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731009),('5','173','257973','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,731010),('5','173','257974','400',185.00,185.00,0.00,0.00,0.00,0.00,0.00,731011),('5','173','257974','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731012),('5','173','257974','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731013),('5','173','257975','400',185.00,180.00,0.00,0.00,0.00,0.00,0.00,731014),('5','173','257975','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731015),('5','173','257975','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731016),('5','173','257976','400',210.00,210.00,6643.07,0.00,0.00,0.00,0.00,731017),('5','173','257976','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731018),('5','173','257976','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731019),('5','173','257977','400',210.00,210.00,8727.50,0.00,0.00,0.00,0.00,731020),('5','173','257977','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731021),('5','173','257977','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731022),('5','173','257978','400',210.00,210.00,8419.61,0.00,0.00,0.00,0.00,731023),('5','173','257978','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731024),('5','173','257978','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731025),('5','173','257979','400',210.00,210.00,10667.35,0.00,0.00,0.00,0.00,731026),('5','173','257979','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731027),('5','173','257979','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731028),('5','173','257980','400',210.00,210.00,7884.39,0.00,0.00,0.00,0.00,731029),('5','173','257980','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731030),('5','173','257980','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731031),('5','173','257981','400',210.00,210.00,7159.01,0.00,0.00,0.00,0.00,731032),('5','173','257981','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731033),('5','173','257981','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731034),('5','173','257982','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731035),('5','173','257982','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731036),('5','173','257982','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731037),('5','173','257983','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731038),('5','173','257983','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731039),('5','173','257983','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731040),('5','173','257984','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731041),('5','173','257984','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731042),('5','173','257984','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731043),('5','173','257985','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731044),('5','173','257985','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731045),('5','173','257985','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731046),('5','173','257986','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731047),('5','173','257986','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731048),('5','173','257986','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731049),('5','173','257987','401',345.00,345.00,0.00,0.00,0.00,0.00,0.00,731050),('5','173','257987','402',0.00,0.00,0.00,0.00,0.00,0.00,0.00,731051),('5','173','257987','400',210.00,210.00,0.00,0.00,0.00,0.00,0.00,731052);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=367 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',366,'173','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=908 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','173','366',904,0,'400','PMS TANK 1',33000.00,1.00,3465.69,'TANKS CONTAINING PETROLEUM PRODUCT.','602','2021-02-22 19:02:47','2021-02-22 19:02:47','602',5,1),('5','173','366',905,0,'400','PMS TANK 2',33200.00,1.00,3792.34,'TANKS CONTAINING PETROLEUM PRODUCT.','602','2021-02-22 19:04:37','2023-03-10 10:39:53','600',5,1),('5','173','366',906,0,'401','AGO TANK',33000.00,1.00,762.74,'TANKS CONTAINING PETROLEUM PRODUCT.','602','2021-02-22 19:07:27','2021-02-22 19:07:27','602',5,1),('5','173','366',907,0,'402','DPK TANK',33000.00,1.00,0.00,'TANKS CONTAINING PETROLEUM PRODUCT.','602','2021-02-22 19:08:29','2021-02-22 19:08:29','602',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','173',907,0.00,'2023-03-20 20:10:02'),(2,'5','173',906,300.00,'2023-03-20 20:10:02'),(3,'5','173',905,99.43,'2023-03-20 20:10:02'),(4,'5','173',904,1151.17,'2023-03-20 20:10:02');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2616537 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2110525,'5','173','904',400,'Sale Id shift 242787',0.00,0.00,0.00,96.65,0.00,'2021-12-01 08:32:47','',''),(2110526,'5','173','904',400,'Sale Id shift 242787',0.00,0.00,0.00,1278.64,0.00,'2021-12-01 08:32:47','',''),(2110527,'5','173','905',400,'Sale Id shift 242787',0.00,0.00,0.00,205.95,0.00,'2021-12-01 08:32:47','',''),(2110528,'5','173',NULL,400,'Sale Id shift 242787',260904.60,0.00,0.00,0.00,0.00,'2021-12-01 08:32:47','',''),(2318916,'5','173','904',400,'Sale Id shift 247018',0.00,0.00,0.00,38.99,0.00,'2021-12-19 07:54:34','',''),(2318917,'5','173','904',400,'Sale Id shift 247018',0.00,0.00,0.00,1469.12,0.00,'2021-12-19 07:54:34','',''),(2318918,'5','173','905',400,'Sale Id shift 247018',0.00,0.00,0.00,286.69,0.00,'2021-12-19 07:54:34','',''),(2318919,'5','173',NULL,400,'Sale Id shift 247018',296142.00,0.00,0.00,0.00,0.00,'2021-12-19 07:54:34','',''),(2328633,'5','173','904',400,'Sale Id shift 247308',0.00,0.00,0.00,94.00,0.00,'2021-12-20 11:04:54','',''),(2328634,'5','173','904',400,'Sale Id shift 247308',0.00,0.00,0.00,1427.43,0.00,'2021-12-20 11:04:54','',''),(2328635,'5','173','905',400,'Sale Id shift 247308',0.00,0.00,0.00,548.95,0.00,'2021-12-20 11:04:54','',''),(2328636,'5','173',NULL,400,'Sale Id shift 247308',341612.70,0.00,0.00,0.00,0.00,'2021-12-20 11:04:54','',''),(2329218,'5','173','904',400,'Sale Id shift 247501',0.00,0.00,0.00,1691.66,0.00,'2021-12-20 12:11:32','',''),(2329219,'5','173',NULL,400,'Sale Id shift 247501',279123.90,0.00,0.00,0.00,0.00,'2021-12-20 12:11:32','',''),(2329271,'5','173','904',400,'Sale Id shift 247509',0.00,0.00,0.00,1341.18,0.00,'2021-12-20 12:17:14','',''),(2329272,'5','173','905',400,'Sale Id shift 247509',0.00,0.00,0.00,40.49,0.00,'2021-12-20 12:17:14','',''),(2329273,'5','173',NULL,400,'Sale Id shift 247509',227975.55,0.00,0.00,0.00,0.00,'2021-12-20 12:17:14','',''),(2329390,'5','173','904',400,'Sale Id shift 247511',0.00,0.00,0.00,1415.63,0.00,'2021-12-20 12:28:16','',''),(2329391,'5','173','905',400,'Sale Id shift 247511',0.00,0.00,0.00,168.41,0.00,'2021-12-20 12:28:16','',''),(2329392,'5','173',NULL,400,'Sale Id shift 247511',261366.60,0.00,0.00,0.00,0.00,'2021-12-20 12:28:16','',''),(2329441,'5','173','904',400,'Sale Id shift 247514',0.00,0.00,0.00,1418.27,0.00,'2021-12-20 12:33:55','',''),(2329442,'5','173','905',400,'Sale Id shift 247514',0.00,0.00,0.00,242.79,0.00,'2021-12-20 12:33:55','',''),(2329443,'5','173',NULL,400,'Sale Id shift 247514',274074.90,0.00,0.00,0.00,0.00,'2021-12-20 12:33:55','',''),(2329522,'5','173','904',400,'Sale Id shift 247515',0.00,0.00,0.00,21.48,0.00,'2021-12-20 12:40:17','',''),(2329523,'5','173','904',400,'Sale Id shift 247515',0.00,0.00,0.00,1462.65,0.00,'2021-12-20 12:40:17','',''),(2329524,'5','173','905',400,'Sale Id shift 247515',0.00,0.00,0.00,25.48,0.00,'2021-12-20 12:40:17','',''),(2329525,'5','173',NULL,400,'Sale Id shift 247515',249085.65,0.00,0.00,0.00,0.00,'2021-12-20 12:40:17','',''),(2329589,'5','173','904',400,'Sale Id shift 247516',0.00,0.00,0.00,1901.59,0.00,'2021-12-20 12:43:11','',''),(2329590,'5','173','905',400,'Sale Id shift 247516',0.00,0.00,0.00,221.23,0.00,'2021-12-20 12:43:11','',''),(2329591,'5','173',NULL,400,'Sale Id shift 247516',350265.30,0.00,0.00,0.00,0.00,'2021-12-20 12:43:11','',''),(2329614,'5','173','904',400,'Sale Id shift 247517',0.00,0.00,0.00,1361.20,0.00,'2021-12-20 12:45:00','',''),(2329615,'5','173','905',400,'Sale Id shift 247517',0.00,0.00,0.00,185.34,0.00,'2021-12-20 12:45:00','',''),(2329616,'5','173',NULL,400,'Sale Id shift 247517',255179.10,0.00,0.00,0.00,0.00,'2021-12-20 12:45:00','',''),(2329655,'5','173','904',400,'Sale Id shift 247519',0.00,0.00,0.00,1538.21,0.00,'2021-12-20 12:47:17','',''),(2329656,'5','173','905',400,'Sale Id shift 247519',0.00,0.00,0.00,49.52,0.00,'2021-12-20 12:47:17','',''),(2329657,'5','173',NULL,400,'Sale Id shift 247519',261975.45,0.00,0.00,0.00,0.00,'2021-12-20 12:47:17','',''),(2329679,'5','173','904',400,'Sale Id shift 247521',0.00,0.00,0.00,219.37,0.00,'2021-12-20 12:50:20','',''),(2329680,'5','173','904',400,'Sale Id shift 247521',0.00,0.00,0.00,1428.20,0.00,'2021-12-20 12:50:20','',''),(2329681,'5','173',NULL,400,'Sale Id shift 247521',271849.05,0.00,0.00,0.00,0.00,'2021-12-20 12:50:20','',''),(2329715,'5','173','904',400,'Sale Id shift 247523',0.00,0.00,0.00,70.95,0.00,'2021-12-20 12:53:22','',''),(2329716,'5','173','905',400,'Sale Id shift 247523',0.00,0.00,0.00,992.15,0.00,'2021-12-20 12:53:22','',''),(2329717,'5','173','905',400,'Sale Id shift 247523',0.00,0.00,0.00,992.65,0.00,'2021-12-20 12:53:22','',''),(2329718,'5','173',NULL,400,'Sale Id shift 247523',339198.75,0.00,0.00,0.00,0.00,'2021-12-20 12:53:22','',''),(2329736,'5','173','905',400,'Sale Id shift 247524',0.00,0.00,0.00,1432.89,0.00,'2021-12-20 12:55:16','',''),(2329737,'5','173',NULL,400,'Sale Id shift 247524',236426.85,0.00,0.00,0.00,0.00,'2021-12-20 12:55:16','',''),(2329750,'5','173','905',400,'Sale Id shift 247527',0.00,0.00,0.00,1761.11,0.00,'2021-12-20 12:57:03','',''),(2329751,'5','173',NULL,400,'Sale Id shift 247527',290583.15,0.00,0.00,0.00,0.00,'2021-12-20 12:57:03','',''),(2329778,'5','173','905',400,'Sale Id shift 247528',0.00,0.00,0.00,1448.22,0.00,'2021-12-20 13:00:08','',''),(2329779,'5','173',NULL,400,'Sale Id shift 247528',238956.30,0.00,0.00,0.00,0.00,'2021-12-20 13:00:08','',''),(2329803,'5','173','905',400,'Sale Id shift 247529',0.00,0.00,0.00,1481.87,0.00,'2021-12-20 13:02:16','',''),(2329804,'5','173',NULL,400,'Sale Id shift 247529',244508.55,0.00,0.00,0.00,0.00,'2021-12-20 13:02:16','',''),(2329826,'5','173','905',400,'Sale Id shift 247531',0.00,0.00,0.00,465.81,0.00,'2021-12-20 13:05:18','',''),(2329827,'5','173',NULL,400,'Sale Id shift 247531',76858.65,0.00,0.00,0.00,0.00,'2021-12-20 13:05:18','',''),(2355375,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2021-12-23 14:33:40','',''),(2356834,'5','173',NULL,400,'Reception corrector for bridging 128517',0.00,0.00,0.00,15000.00,0.00,'2021-12-23 16:46:09','',''),(2356835,'5','173','904',400,'Received from bridging 128517',0.00,0.00,15000.00,0.00,0.00,'2021-12-23 16:46:09','',''),(2357571,'5','173','904',400,'Sale Id shift 248027',0.00,0.00,0.00,1113.12,0.00,'2021-12-23 18:06:48','',''),(2357572,'5','173','904',400,'Sale Id shift 248027',0.00,0.00,0.00,913.92,0.00,'2021-12-23 18:06:48','',''),(2357573,'5','173','905',400,'Sale Id shift 248027',0.00,0.00,0.00,893.89,0.00,'2021-12-23 18:06:48','',''),(2357574,'5','173',NULL,400,'Sale Id shift 248027',481953.45,0.00,0.00,0.00,0.00,'2021-12-23 18:06:48','',''),(2359699,'5','173','904',400,'Sale Id shift 248351',0.00,0.00,0.00,3904.27,0.00,'2021-12-24 08:11:50','',''),(2359700,'5','173',NULL,400,'Sale Id shift 248351',644204.55,0.00,0.00,0.00,0.00,'2021-12-24 08:11:50','',''),(2373025,'5','173','904',400,'Sale Id shift 248504',0.00,0.00,0.00,2487.58,0.00,'2021-12-25 14:08:28','',''),(2373026,'5','173',NULL,400,'Sale Id shift 248504',410450.70,0.00,0.00,0.00,0.00,'2021-12-25 14:08:28','',''),(2383870,'5','173','904',400,'Sale Id shift 248814',0.00,0.00,0.00,2825.20,0.00,'2021-12-27 12:17:59','',''),(2383871,'5','173',NULL,400,'Sale Id shift 248814',466158.00,0.00,0.00,0.00,0.00,'2021-12-27 12:17:59','',''),(2386185,'5','173','904',400,'Sale Id shift 249241',0.00,0.00,0.00,1930.56,0.00,'2021-12-27 18:20:36','',''),(2386186,'5','173',NULL,400,'Sale Id shift 249241',318542.40,0.00,0.00,0.00,0.00,'2021-12-27 18:20:36','',''),(2487651,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4174500.00,25300.00,0.00,0.00,'2022-01-11 09:25:27','',''),(2487871,'5','173',NULL,400,'Reception corrector for bridging 130420',0.00,0.00,0.00,12500.00,0.00,'2022-01-11 09:45:33','',''),(2487872,'5','173','905',400,'Received from bridging 130420',0.00,0.00,12500.00,0.00,0.00,'2022-01-11 09:45:33','',''),(2487875,'5','173',NULL,400,'Reception corrector for bridging 130419',0.00,0.00,0.00,12800.00,0.00,'2022-01-11 09:45:43','',''),(2487876,'5','173','904',400,'Received from bridging 130419',0.00,0.00,12800.00,0.00,0.00,'2022-01-11 09:45:43','',''),(2488076,'5','173','904',400,'Sale Id shift 252595',0.00,0.00,0.00,3882.22,0.00,'2022-01-11 10:06:33','',''),(2488077,'5','173','904',400,'Sale Id shift 252595',0.00,0.00,0.00,3548.00,0.00,'2022-01-11 10:06:33','',''),(2488078,'5','173',NULL,400,'Sale Id shift 252595',1225986.30,0.00,0.00,0.00,0.00,'2022-01-11 10:06:33','',''),(2490795,'5','173','905',400,'Sale Id shift 252814',0.00,0.00,0.00,4439.07,0.00,'2022-01-11 15:00:50','',''),(2490796,'5','173',NULL,400,'Sale Id shift 252814',732446.55,0.00,0.00,0.00,0.00,'2022-01-11 15:00:50','',''),(2502742,'5','173','905',400,'Sale Id shift 252903',0.00,0.00,0.00,2288.84,0.00,'2022-01-13 09:12:28','',''),(2502743,'5','173','905',400,'Sale Id shift 252903',0.00,0.00,0.00,2351.56,0.00,'2022-01-13 09:12:28','',''),(2502744,'5','173',NULL,400,'Sale Id shift 252903',765666.00,0.00,0.00,0.00,0.00,'2022-01-13 09:12:28','',''),(2504183,'5','173','904',400,'Sale Id shift 253311',0.00,0.00,0.00,3762.02,0.00,'2022-01-13 11:17:28','',''),(2504184,'5','173',NULL,400,'Sale Id shift 253311',620733.30,0.00,0.00,0.00,0.00,'2022-01-13 11:17:28','',''),(2511024,'5','173','905',400,'Sale Id shift 253414',0.00,0.00,0.00,1898.43,0.00,'2022-01-14 09:53:24','',''),(2511025,'5','173','905',400,'Sale Id shift 253414',0.00,0.00,0.00,301.39,0.00,'2022-01-14 09:53:24','',''),(2511026,'5','173',NULL,400,'Sale Id shift 253414',362970.30,0.00,0.00,0.00,0.00,'2022-01-14 09:53:24','',''),(2519377,'5','173','904',400,'Sale Id shift 253560',0.00,0.00,0.00,1580.90,0.00,'2022-01-15 10:55:54','',''),(2519378,'5','173',NULL,400,'Sale Id shift 253560',260848.50,0.00,0.00,0.00,0.00,'2022-01-15 10:55:54','',''),(2535064,'5','173','905',400,'Sale Id shift 253814',0.00,0.00,0.00,520.00,0.00,'2022-01-17 09:14:18','',''),(2535065,'5','173',NULL,400,'Sale Id shift 253814',85800.00,0.00,0.00,0.00,0.00,'2022-01-17 09:14:18','',''),(2540826,'5','173','904',400,'Sale Id shift 254377',0.00,0.00,0.00,1015.03,0.00,'2022-01-17 21:24:01','',''),(2540827,'5','173',NULL,400,'Sale Id shift 254377',167479.95,0.00,0.00,0.00,0.00,'2022-01-17 21:24:01','',''),(2566204,'5','173','905',400,'Sale Id shift 255020',0.00,0.00,0.00,498.56,0.00,'2022-01-21 09:58:56','',''),(2566205,'5','173','905',400,'Sale Id shift 255020',0.00,0.00,0.00,153.95,0.00,'2022-01-21 09:58:56','',''),(2566206,'5','173',NULL,400,'Sale Id shift 255020',107664.15,0.00,0.00,0.00,0.00,'2022-01-21 09:58:56','',''),(2566213,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2442000.00,14800.00,0.00,0.00,'2022-01-21 09:59:12','',''),(2574101,'5','173',NULL,400,'Reception corrector for bridging 131592',0.00,0.00,0.00,14800.00,0.00,'2022-01-22 09:26:45','',''),(2574102,'5','173','904',400,'Received from bridging 131592',0.00,0.00,14800.00,0.00,0.00,'2022-01-22 09:26:45','',''),(2582855,'5','173','904',400,'Sale Id shift 255301',0.00,0.00,0.00,1723.00,0.00,'2022-01-23 09:04:13','',''),(2582856,'5','173','904',400,'Sale Id shift 255301',0.00,0.00,0.00,1341.83,0.00,'2022-01-23 09:04:13','',''),(2582857,'5','173',NULL,400,'Sale Id shift 255301',505696.95,0.00,0.00,0.00,0.00,'2022-01-23 09:04:13','',''),(2587981,'5','173','904',400,'Sale Id shift 255754',0.00,0.00,0.00,3039.41,0.00,'2022-01-23 16:28:50','',''),(2587982,'5','173',NULL,400,'Sale Id shift 255754',501502.65,0.00,0.00,0.00,0.00,'2022-01-23 16:28:50','',''),(2598152,'5','173','904',400,'Sale Id shift 255906',0.00,0.00,0.00,1555.08,0.00,'2022-01-25 09:11:10','',''),(2598153,'5','173',NULL,400,'Sale Id shift 255906',256588.20,0.00,0.00,0.00,0.00,'2022-01-25 09:11:10','',''),(2602003,'5','173','904',400,'Sale Id shift 256342',0.00,0.00,0.00,2304.76,0.00,'2022-01-25 15:22:29','',''),(2602004,'5','173',NULL,400,'Sale Id shift 256342',380285.40,0.00,0.00,0.00,0.00,'2022-01-25 15:22:29','',''),(2606725,'5','173','904',400,'Sale Id shift 256381',0.00,0.00,0.00,2078.70,0.00,'2022-01-26 09:04:46','',''),(2606726,'5','173',NULL,400,'Sale Id shift 256381',342985.50,0.00,0.00,0.00,0.00,'2022-01-26 09:04:46','',''),(2612761,'5','173',NULL,402,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612772,'5','173',NULL,401,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,90000.00,600.00,300.00,0.00,'2021-11-30 23:59:59','',''),(2612953,'5','173',NULL,400,'Balance from closing inventory values 2021-11-31 23:59:59',5047544.31,10341000.00,126200.00,94119.07,0.00,'2021-11-30 23:59:59','',''),(2613228,'5','173','904',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,49650.00,29431.17,0.00,'2021-11-30 23:59:59','',''),(2613552,'5','173','907',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613672,'5','173','906',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,300.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613770,'5','173','905',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,13450.00,1587.90,0.00,'2021-11-30 23:59:59','',''),(2615985,'5','173','904',400,'Sale Id shift 256590',0.00,0.00,0.00,1200.32,0.00,'2022-01-27 10:04:50','',''),(2615986,'5','173',NULL,400,'Sale Id shift 256590',198052.80,0.00,0.00,0.00,0.00,'2022-01-27 10:04:50','',''),(2615987,'5','173','904',400,'Sale Id shift 257662',0.00,0.00,0.00,1511.75,0.00,'2022-02-04 09:24:35','',''),(2615988,'5','173',NULL,400,'Sale Id shift 257662',249438.75,0.00,0.00,0.00,0.00,'2022-02-04 09:24:35','',''),(2615989,'5','173','904',400,'Sale Id shift 257663',0.00,0.00,0.00,1629.12,0.00,'2022-02-06 05:27:06','',''),(2615990,'5','173',NULL,400,'Sale Id shift 257663',268804.80,0.00,0.00,0.00,0.00,'2022-02-06 05:27:06','',''),(2615991,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-06 15:12:13','',''),(2615992,'5','173',NULL,400,'Reception corrector for bridging 131593',0.00,0.00,0.00,30000.00,0.00,'2022-02-06 16:29:34','',''),(2615993,'5','173','904',400,'Received from bridging 131593',0.00,0.00,30000.00,0.00,0.00,'2022-02-06 16:29:34','',''),(2615994,'5','173','904',400,'Sale Id shift 257664',0.00,0.00,0.00,2315.58,0.00,'2022-02-06 20:23:14','',''),(2615995,'5','173','904',400,'Sale Id shift 257664',0.00,0.00,0.00,2061.52,0.00,'2022-02-06 20:23:14','',''),(2615996,'5','173',NULL,400,'Sale Id shift 257664',722221.50,0.00,0.00,0.00,0.00,'2022-02-06 20:23:14','',''),(2615997,'5','173','904',400,'Sale Id shift 257666',0.00,0.00,0.00,2897.56,0.00,'2022-02-06 21:12:12','',''),(2615998,'5','173','904',400,'Sale Id shift 257666',0.00,0.00,0.00,3310.38,0.00,'2022-02-06 21:12:12','',''),(2615999,'5','173',NULL,400,'Sale Id shift 257666',1024310.10,0.00,0.00,0.00,0.00,'2022-02-06 21:12:12','',''),(2616000,'5','173','904',400,'Sale Id shift 257667',0.00,0.00,0.00,2235.30,0.00,'2022-02-07 15:48:33','',''),(2616001,'5','173','904',400,'Sale Id shift 257667',0.00,0.00,0.00,1559.76,0.00,'2022-02-07 15:48:33','',''),(2616002,'5','173',NULL,400,'Sale Id shift 257667',626184.90,0.00,0.00,0.00,0.00,'2022-02-07 15:48:33','',''),(2616003,'5','173','904',400,'Sale Id shift 257668',0.00,0.00,0.00,3192.10,0.00,'2022-02-09 09:12:41','',''),(2616004,'5','173','904',400,'Sale Id shift 257668',0.00,0.00,0.00,5353.75,0.00,'2022-02-09 09:12:41','',''),(2616005,'5','173',NULL,400,'Sale Id shift 257668',1410065.25,0.00,0.00,0.00,0.00,'2022-02-09 09:12:41','',''),(2616006,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-02-09 15:26:04','',''),(2616007,'5','173','904',400,'Sale Id shift 257669',0.00,0.00,0.00,4412.90,0.00,'2022-02-09 15:26:19','',''),(2616008,'5','173','904',400,'Sale Id shift 257669',0.00,0.00,0.00,1780.49,0.00,'2022-02-09 15:26:19','',''),(2616009,'5','173',NULL,400,'Sale Id shift 257669',1021909.35,0.00,0.00,0.00,0.00,'2022-02-09 15:26:19','',''),(2616010,'5','173',NULL,400,'Reception corrector for bridging 131594',0.00,0.00,0.00,22000.00,0.00,'2022-02-09 16:10:12','',''),(2616011,'5','173','904',400,'Received from bridging 131594',0.00,0.00,22000.00,0.00,0.00,'2022-02-09 16:10:12','',''),(2616012,'5','173',NULL,400,'Reception corrector for bridging 131595',0.00,0.00,0.00,23000.00,0.00,'2022-02-09 16:10:22','',''),(2616013,'5','173','905',400,'Received from bridging 131595',0.00,0.00,23000.00,0.00,0.00,'2022-02-09 16:10:22','',''),(2616014,'5','173','904',400,'Sale Id shift 257670',0.00,0.00,0.00,4007.06,0.00,'2022-02-10 14:18:46','',''),(2616015,'5','173','904',400,'Sale Id shift 257670',0.00,0.00,0.00,3615.01,0.00,'2022-02-10 14:18:46','',''),(2616016,'5','173','905',400,'Sale Id shift 257670',0.00,0.00,0.00,2530.54,0.00,'2022-02-10 14:18:46','',''),(2616017,'5','173',NULL,400,'Sale Id shift 257670',1675180.65,0.00,0.00,0.00,0.00,'2022-02-10 14:18:46','',''),(2616018,'5','173','904',400,'Sale Id shift 257671',0.00,0.00,0.00,5845.38,0.00,'2022-02-11 09:47:07','',''),(2616019,'5','173','905',400,'Sale Id shift 257671',0.00,0.00,0.00,6497.89,0.00,'2022-02-11 09:47:07','',''),(2616020,'5','173',NULL,400,'Sale Id shift 257671',2036639.55,0.00,0.00,0.00,0.00,'2022-02-11 09:47:07','',''),(2616021,'5','173','904',400,'Sale Id shift 257672',0.00,0.00,0.00,6432.40,0.00,'2022-02-12 08:48:31','',''),(2616022,'5','173',NULL,400,'Sale Id shift 257672',1061346.00,0.00,0.00,0.00,0.00,'2022-02-12 08:48:31','',''),(2616023,'5','173','905',400,'Sale Id shift 257673',0.00,0.00,0.00,6914.59,0.00,'2022-02-13 09:05:03','',''),(2616024,'5','173',NULL,400,'Sale Id shift 257673',1140907.35,0.00,0.00,0.00,0.00,'2022-02-13 09:05:03','',''),(2616025,'5','173','905',400,'Sale Id shift 257674',0.00,0.00,0.00,4966.73,0.00,'2022-02-14 09:00:52','',''),(2616026,'5','173',NULL,400,'Sale Id shift 257674',819510.45,0.00,0.00,0.00,0.00,'2022-02-14 09:00:52','',''),(2616027,'5','173','904',400,'Sale Id shift 257675',0.00,0.00,0.00,2246.14,0.00,'2022-02-15 16:50:13','',''),(2616028,'5','173',NULL,400,'Sale Id shift 257675',370613.10,0.00,0.00,0.00,0.00,'2022-02-15 16:50:13','',''),(2616029,'5','173','904',400,'Sale Id shift 257678',0.00,0.00,0.00,189.60,0.00,'2022-02-20 08:52:09','',''),(2616030,'5','173','904',400,'Sale Id shift 257678',0.00,0.00,0.00,289.96,0.00,'2022-02-20 08:52:09','',''),(2616031,'5','173','905',400,'Sale Id shift 257678',0.00,0.00,0.00,524.42,0.00,'2022-02-20 08:52:09','',''),(2616032,'5','173','905',400,'Sale Id shift 257678',0.00,0.00,0.00,597.83,0.00,'2022-02-20 08:52:09','',''),(2616033,'5','173',NULL,400,'Sale Id shift 257678',264298.65,0.00,0.00,0.00,0.00,'2022-02-20 08:52:09','',''),(2616034,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-02-20 10:54:24','',''),(2616035,'5','173',NULL,400,'Reception corrector for bridging 131596',0.00,0.00,0.00,15000.00,0.00,'2022-02-20 11:21:29','',''),(2616036,'5','173','904',400,'Received from bridging 131596',0.00,0.00,15000.00,0.00,0.00,'2022-02-20 11:21:29','',''),(2616037,'5','173','904',400,'Sale Id shift 257679',0.00,0.00,0.00,5819.77,0.00,'2022-02-20 11:50:16','',''),(2616038,'5','173',NULL,400,'Sale Id shift 257679',960262.05,0.00,0.00,0.00,0.00,'2022-02-20 11:50:16','',''),(2616039,'5','173','904',400,'Sale Id shift 257680',0.00,0.00,0.00,4653.77,0.00,'2022-02-20 13:54:56','',''),(2616040,'5','173',NULL,400,'Sale Id shift 257680',767872.05,0.00,0.00,0.00,0.00,'2022-02-20 13:54:56','',''),(2616041,'5','173','904',400,'Sale Id shift 257681',0.00,0.00,0.00,1309.00,0.00,'2022-02-21 10:00:21','',''),(2616042,'5','173','904',400,'Sale Id shift 257681',0.00,0.00,0.00,3000.05,0.00,'2022-02-21 10:00:21','',''),(2616043,'5','173',NULL,400,'Sale Id shift 257681',710993.25,0.00,0.00,0.00,0.00,'2022-02-21 10:00:21','',''),(2616044,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,3712500.00,22500.00,0.00,0.00,'2022-02-25 18:20:11','',''),(2616045,'5','173',NULL,400,'Reception corrector for bridging 131597',0.00,0.00,0.00,22500.00,0.00,'2022-02-25 21:24:27','',''),(2616046,'5','173','904',400,'Received from bridging 131597',0.00,0.00,22500.00,0.00,0.00,'2022-02-25 21:24:27','',''),(2616047,'5','173','904',400,'Sale Id shift 257685',0.00,0.00,0.00,7550.65,0.00,'2022-02-27 09:06:20','',''),(2616048,'5','173',NULL,400,'Sale Id shift 257685',1245857.25,0.00,0.00,0.00,0.00,'2022-02-27 09:06:20','',''),(2616049,'5','173','904',400,'Sale Id shift 257686',0.00,0.00,0.00,5773.06,0.00,'2022-02-27 13:44:19','',''),(2616050,'5','173','904',400,'Sale Id shift 257686',0.00,0.00,0.00,4236.70,0.00,'2022-02-27 13:44:19','',''),(2616051,'5','173',NULL,400,'Sale Id shift 257686',1651610.40,0.00,0.00,0.00,0.00,'2022-02-27 13:44:19','',''),(2616052,'5','173','904',400,'Sale Id shift 257687',0.00,0.00,0.00,1993.47,0.00,'2022-02-28 12:44:26','',''),(2616053,'5','173','904',400,'Sale Id shift 257687',0.00,0.00,0.00,21.76,0.00,'2022-02-28 12:44:26','',''),(2616054,'5','173',NULL,400,'Sale Id shift 257687',332512.95,0.00,0.00,0.00,0.00,'2022-02-28 12:44:26','',''),(2616055,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4917000.00,29800.00,0.00,0.00,'2022-02-28 12:58:09','',''),(2616056,'5','173',NULL,400,'Reception corrector for bridging 131599',0.00,0.00,0.00,14800.00,0.00,'2022-02-28 14:46:35','',''),(2616057,'5','173','905',400,'Received from bridging 131599',0.00,0.00,14800.00,0.00,0.00,'2022-02-28 14:46:35','',''),(2616058,'5','173',NULL,400,'Reception corrector for bridging 131598',0.00,0.00,0.00,15000.00,0.00,'2022-02-28 14:46:35','',''),(2616059,'5','173','904',400,'Received from bridging 131598',0.00,0.00,15000.00,0.00,0.00,'2022-02-28 14:46:35','',''),(2616060,'5','173','905',400,'Sale Id shift 257688',0.00,0.00,0.00,6533.21,0.00,'2022-02-28 15:54:54','',''),(2616061,'5','173','905',400,'Sale Id shift 257688',0.00,0.00,0.00,9106.15,0.00,'2022-02-28 15:54:54','',''),(2616062,'5','173',NULL,400,'Sale Id shift 257688',2580494.40,0.00,0.00,0.00,0.00,'2022-02-28 15:54:54','',''),(2616063,'5','173','904',400,'Sale Id shift 257689',0.00,0.00,0.00,2744.57,0.00,'2022-03-02 09:53:19','',''),(2616064,'5','173','904',400,'Sale Id shift 257689',0.00,0.00,0.00,9516.60,0.00,'2022-03-02 09:53:19','',''),(2616065,'5','173',NULL,400,'Sale Id shift 257689',2023093.05,0.00,0.00,0.00,0.00,'2022-03-02 09:53:19','',''),(2616066,'5','173','904',400,'Sale Id shift 257690',0.00,0.00,0.00,2307.80,0.00,'2022-03-03 10:25:28','',''),(2616067,'5','173',NULL,400,'Sale Id shift 257690',380787.00,0.00,0.00,0.00,0.00,'2022-03-03 10:25:28','',''),(2616068,'5','173','904',400,'Sale Id shift 257691',0.00,0.00,0.00,2800.00,0.00,'2022-03-03 14:25:50','',''),(2616069,'5','173',NULL,400,'Sale Id shift 257691',462000.00,0.00,0.00,0.00,0.00,'2022-03-03 14:25:50','',''),(2616070,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-13 12:04:41','',''),(2616071,'5','173',NULL,400,'Reception corrector for bridging 131601',0.00,0.00,0.00,30000.00,0.00,'2022-03-13 17:16:53','',''),(2616072,'5','173','905',400,'Received from bridging 131601',0.00,0.00,30000.00,0.00,0.00,'2022-03-13 17:16:53','',''),(2616073,'5','173',NULL,400,'Reception corrector for bridging 131600',0.00,0.00,0.00,15000.00,0.00,'2022-03-13 17:17:03','',''),(2616074,'5','173','904',400,'Received from bridging 131600',0.00,0.00,15000.00,0.00,0.00,'2022-03-13 17:17:03','',''),(2616075,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-13 17:17:11','',''),(2616076,'5','173','904',400,'Sale Id shift 257698',0.00,0.00,0.00,4911.27,0.00,'2022-03-13 18:57:55','',''),(2616077,'5','173','904',400,'Sale Id shift 257698',0.00,0.00,0.00,5600.42,0.00,'2022-03-13 18:57:55','',''),(2616078,'5','173',NULL,400,'Sale Id shift 257698',1734428.85,0.00,0.00,0.00,0.00,'2022-03-13 18:57:55','',''),(2616079,'5','173','905',400,'Sale Id shift 257699',0.00,0.00,0.00,4758.04,0.00,'2022-03-13 20:55:53','',''),(2616080,'5','173','905',400,'Sale Id shift 257699',0.00,0.00,0.00,6184.71,0.00,'2022-03-13 20:55:53','',''),(2616081,'5','173',NULL,400,'Sale Id shift 257699',1805553.75,0.00,0.00,0.00,0.00,'2022-03-13 20:55:53','',''),(2616082,'5','173','904',400,'Sale Id shift 257700',0.00,0.00,0.00,1787.71,0.00,'2022-03-14 09:18:33','',''),(2616083,'5','173','904',400,'Sale Id shift 257700',0.00,0.00,0.00,4681.53,0.00,'2022-03-14 09:18:33','',''),(2616084,'5','173','905',400,'Sale Id shift 257700',0.00,0.00,0.00,10015.11,0.00,'2022-03-14 09:18:33','',''),(2616085,'5','173','905',400,'Sale Id shift 257700',0.00,0.00,0.00,8531.79,0.00,'2022-03-14 09:18:33','',''),(2616086,'5','173',NULL,400,'Sale Id shift 257700',4127663.10,0.00,0.00,0.00,0.00,'2022-03-14 09:18:33','',''),(2616087,'5','173',NULL,400,'Reception corrector for bridging 131602',0.00,0.00,0.00,22500.00,0.00,'2022-03-14 17:43:00','',''),(2616088,'5','173','904',400,'Received from bridging 131602',0.00,0.00,22500.00,0.00,0.00,'2022-03-14 17:43:00','',''),(2616089,'5','173',NULL,400,'Reception corrector for bridging 131603',0.00,0.00,0.00,22500.00,0.00,'2022-03-14 17:43:08','',''),(2616090,'5','173','905',400,'Received from bridging 131603',0.00,0.00,22500.00,0.00,0.00,'2022-03-14 17:43:08','',''),(2616091,'5','173','904',400,'Sale Id shift 257701',0.00,0.00,0.00,6274.43,0.00,'2022-03-15 12:30:16','',''),(2616092,'5','173','905',400,'Sale Id shift 257701',0.00,0.00,0.00,9489.16,0.00,'2022-03-15 12:30:16','',''),(2616093,'5','173',NULL,400,'Sale Id shift 257701',2600992.35,0.00,0.00,0.00,0.00,'2022-03-15 12:30:16','',''),(2616094,'5','173','904',400,'Sale Id shift 257702',0.00,0.00,0.00,5.39,0.00,'2022-03-15 13:38:47','',''),(2616095,'5','173','905',400,'Sale Id shift 257702',0.00,0.00,0.00,11021.75,0.00,'2022-03-15 13:38:47','',''),(2616096,'5','173',NULL,400,'Sale Id shift 257702',1819478.10,0.00,0.00,0.00,0.00,'2022-03-15 13:38:47','',''),(2616097,'5','173','904',400,'Sale Id shift 257703',0.00,0.00,0.00,6201.83,0.00,'2022-03-15 16:25:16','',''),(2616098,'5','173',NULL,400,'Sale Id shift 257703',1023301.95,0.00,0.00,0.00,0.00,'2022-03-15 16:25:16','',''),(2616099,'5','173','904',400,'Sale Id shift 257704',0.00,0.00,0.00,5528.78,0.00,'2022-03-16 11:43:15','',''),(2616100,'5','173',NULL,400,'Sale Id shift 257704',912248.70,0.00,0.00,0.00,0.00,'2022-03-16 11:43:15','',''),(2616101,'5','173','904',400,'Sale Id shift 257705',0.00,0.00,0.00,3158.30,0.00,'2022-03-17 08:54:56','',''),(2616102,'5','173',NULL,400,'Sale Id shift 257705',521119.50,0.00,0.00,0.00,0.00,'2022-03-17 08:54:56','',''),(2616103,'5','173','904',400,'Sale Id shift 257740',0.00,0.00,0.00,650.00,0.00,'2022-04-23 09:14:24','',''),(2616104,'5','173',NULL,400,'Sale Id shift 257740',107250.00,0.00,0.00,0.00,0.00,'2022-04-23 09:14:24','',''),(2616105,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-23 14:11:32','',''),(2616106,'5','173',NULL,400,'Reception corrector for bridging 131605',0.00,0.00,0.00,17400.00,0.00,'2022-04-23 15:19:35','',''),(2616107,'5','173','905',400,'Received from bridging 131605',0.00,0.00,17400.00,0.00,0.00,'2022-04-23 15:19:35','',''),(2616108,'5','173',NULL,400,'Reception corrector for bridging 131604',0.00,0.00,0.00,27600.00,0.00,'2022-04-23 15:19:47','',''),(2616109,'5','173','904',400,'Received from bridging 131604',0.00,0.00,27600.00,0.00,0.00,'2022-04-23 15:19:47','',''),(2616110,'5','173','904',400,'Sale Id shift 257741',0.00,0.00,0.00,1880.51,0.00,'2022-04-23 15:27:08','',''),(2616111,'5','173','905',400,'Sale Id shift 257741',0.00,0.00,0.00,2032.50,0.00,'2022-04-23 15:27:08','',''),(2616112,'5','173',NULL,400,'Sale Id shift 257741',645646.65,0.00,0.00,0.00,0.00,'2022-04-23 15:27:08','',''),(2616113,'5','173','904',400,'Sale Id shift 257742',0.00,0.00,0.00,3043.25,0.00,'2022-04-23 21:09:11','',''),(2616114,'5','173','905',400,'Sale Id shift 257742',0.00,0.00,0.00,1942.66,0.00,'2022-04-23 21:09:11','',''),(2616115,'5','173',NULL,400,'Sale Id shift 257742',822675.15,0.00,0.00,0.00,0.00,'2022-04-23 21:09:11','',''),(2616116,'5','173','904',400,'Sale Id shift 257743',0.00,0.00,0.00,877.69,0.00,'2022-04-25 11:42:21','',''),(2616117,'5','173','905',400,'Sale Id shift 257743',0.00,0.00,0.00,2940.55,0.00,'2022-04-25 11:42:21','',''),(2616118,'5','173',NULL,400,'Sale Id shift 257743',630009.60,0.00,0.00,0.00,0.00,'2022-04-25 11:42:21','',''),(2616119,'5','173','904',400,'Sale Id shift 257744',0.00,0.00,0.00,1101.89,0.00,'2022-04-25 13:45:05','',''),(2616120,'5','173','905',400,'Sale Id shift 257744',0.00,0.00,0.00,2799.86,0.00,'2022-04-25 13:45:05','',''),(2616121,'5','173',NULL,400,'Sale Id shift 257744',643788.75,0.00,0.00,0.00,0.00,'2022-04-25 13:45:05','',''),(2616122,'5','173','905',400,'Sale Id shift 257745',0.00,0.00,0.00,4209.11,0.00,'2022-04-26 10:24:10','',''),(2616123,'5','173',NULL,400,'Sale Id shift 257745',694503.15,0.00,0.00,0.00,0.00,'2022-04-26 10:24:10','',''),(2616124,'5','173','904',400,'Sale Id shift 257746',0.00,0.00,0.00,1463.55,0.00,'2022-04-27 10:20:31','',''),(2616125,'5','173','905',400,'Sale Id shift 257746',0.00,0.00,0.00,2727.24,0.00,'2022-04-27 10:20:31','',''),(2616126,'5','173',NULL,400,'Sale Id shift 257746',691480.35,0.00,0.00,0.00,0.00,'2022-04-27 10:20:31','',''),(2616127,'5','173','904',400,'Sale Id shift 257747',0.00,0.00,0.00,3082.07,0.00,'2022-04-28 12:52:37','',''),(2616128,'5','173',NULL,400,'Sale Id shift 257747',508541.55,0.00,0.00,0.00,0.00,'2022-04-28 12:52:37','',''),(2616129,'5','173','904',400,'Sale Id shift 257748',0.00,0.00,0.00,3852.97,0.00,'2022-04-29 10:13:20','',''),(2616130,'5','173',NULL,400,'Sale Id shift 257748',635740.05,0.00,0.00,0.00,0.00,'2022-04-29 10:13:20','',''),(2616131,'5','173','904',400,'Sale Id shift 257749',0.00,0.00,0.00,3207.55,0.00,'2022-05-10 10:18:16','',''),(2616132,'5','173',NULL,400,'Sale Id shift 257749',529245.75,0.00,0.00,0.00,0.00,'2022-05-10 10:18:16','',''),(2616133,'5','173','904',400,'Sale Id shift 257750',0.00,0.00,0.00,2714.02,0.00,'2022-05-10 10:21:16','',''),(2616134,'5','173',NULL,400,'Sale Id shift 257750',447813.30,0.00,0.00,0.00,0.00,'2022-05-10 10:21:16','',''),(2616135,'5','173','904',400,'Sale Id shift 257751',0.00,0.00,0.00,2668.88,0.00,'2022-05-10 10:27:38','',''),(2616136,'5','173',NULL,400,'Sale Id shift 257751',440365.20,0.00,0.00,0.00,0.00,'2022-05-10 10:27:38','',''),(2616137,'5','173','904',400,'Sale Id shift 257752',0.00,0.00,0.00,1820.37,0.00,'2022-05-10 10:31:51','',''),(2616138,'5','173',NULL,400,'Sale Id shift 257752',300361.05,0.00,0.00,0.00,0.00,'2022-05-10 10:31:51','',''),(2616139,'5','173','904',400,'Sale Id shift 257753',0.00,0.00,0.00,600.02,0.00,'2022-05-10 10:37:58','',''),(2616140,'5','173',NULL,400,'Sale Id shift 257753',99003.30,0.00,0.00,0.00,0.00,'2022-05-10 10:37:58','',''),(2616141,'5','173','904',400,'Sale Id shift 257760',0.00,0.00,0.00,560.00,0.00,'2022-05-11 09:40:22','',''),(2616142,'5','173',NULL,400,'Sale Id shift 257760',92400.00,0.00,0.00,0.00,0.00,'2022-05-11 09:40:22','',''),(2616143,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7408500.00,44900.00,0.00,0.00,'2022-05-11 10:07:30','',''),(2616144,'5','173',NULL,400,'Reception corrector for bridging 131606',0.00,0.00,0.00,22500.00,0.00,'2022-05-11 10:24:54','',''),(2616145,'5','173','904',400,'Received from bridging 131606',0.00,0.00,22500.00,0.00,0.00,'2022-05-11 10:24:54','',''),(2616146,'5','173',NULL,400,'Reception corrector for bridging 131607',0.00,0.00,0.00,22400.00,0.00,'2022-05-11 10:25:04','',''),(2616147,'5','173','905',400,'Received from bridging 131607',0.00,0.00,22400.00,0.00,0.00,'2022-05-11 10:25:04','',''),(2616148,'5','173','905',400,'Sale Id shift 257761',0.00,0.00,0.00,4942.20,0.00,'2022-05-12 13:10:13','',''),(2616149,'5','173',NULL,400,'Sale Id shift 257761',815463.00,0.00,0.00,0.00,0.00,'2022-05-12 13:10:13','',''),(2616150,'5','173','904',400,'Sale Id shift 257762',0.00,0.00,0.00,4729.06,0.00,'2022-05-13 11:35:04','',''),(2616151,'5','173','905',400,'Sale Id shift 257762',0.00,0.00,0.00,328.74,0.00,'2022-05-13 11:35:04','',''),(2616152,'5','173',NULL,400,'Sale Id shift 257762',834537.00,0.00,0.00,0.00,0.00,'2022-05-13 11:35:04','',''),(2616153,'5','173','905',400,'Sale Id shift 257763',0.00,0.00,0.00,5311.78,0.00,'2022-05-14 13:46:26','',''),(2616154,'5','173',NULL,400,'Sale Id shift 257763',876443.70,0.00,0.00,0.00,0.00,'2022-05-14 13:46:26','',''),(2616155,'5','173','905',400,'Sale Id shift 257764',0.00,0.00,0.00,4688.22,0.00,'2022-05-16 10:05:04','',''),(2616156,'5','173',NULL,400,'Sale Id shift 257764',773556.30,0.00,0.00,0.00,0.00,'2022-05-16 10:05:04','',''),(2616157,'5','173','905',400,'Sale Id shift 257765',0.00,0.00,0.00,4705.36,0.00,'2022-05-16 15:08:56','',''),(2616158,'5','173',NULL,400,'Sale Id shift 257765',776384.40,0.00,0.00,0.00,0.00,'2022-05-16 15:08:56','',''),(2616159,'5','173','904',400,'Sale Id shift 257766',0.00,0.00,0.00,2611.50,0.00,'2022-05-17 09:04:33','',''),(2616160,'5','173','905',400,'Sale Id shift 257766',0.00,0.00,0.00,1309.00,0.00,'2022-05-17 09:04:33','',''),(2616161,'5','173',NULL,400,'Sale Id shift 257766',646882.50,0.00,0.00,0.00,0.00,'2022-05-17 09:04:33','',''),(2616162,'5','173','904',400,'Sale Id shift 257767',0.00,0.00,0.00,4079.40,0.00,'2022-05-18 07:36:58','',''),(2616163,'5','173',NULL,400,'Sale Id shift 257767',673101.00,0.00,0.00,0.00,0.00,'2022-05-18 07:36:58','',''),(2616164,'5','173','904',400,'Sale Id shift 257768',0.00,0.00,0.00,4153.95,0.00,'2022-05-19 08:21:39','',''),(2616165,'5','173',NULL,400,'Sale Id shift 257768',685401.75,0.00,0.00,0.00,0.00,'2022-05-19 08:21:39','',''),(2616166,'5','173','905',400,'Sale Id shift 257769',0.00,0.00,0.00,844.22,0.00,'2022-05-20 21:23:34','',''),(2616167,'5','173','905',400,'Sale Id shift 257769',0.00,0.00,0.00,3001.82,0.00,'2022-05-20 21:23:34','',''),(2616168,'5','173',NULL,400,'Sale Id shift 257769',634596.60,0.00,0.00,0.00,0.00,'2022-05-20 21:23:34','',''),(2616169,'5','173','904',400,'Sale Id shift 257770',0.00,0.00,0.00,2944.96,0.00,'2022-05-22 08:12:21','',''),(2616170,'5','173',NULL,400,'Sale Id shift 257770',485918.40,0.00,0.00,0.00,0.00,'2022-05-22 08:12:21','',''),(2616171,'5','173','904',400,'Sale Id shift 257771',0.00,0.00,0.00,1200.15,0.00,'2022-05-22 14:37:34','',''),(2616172,'5','173',NULL,400,'Sale Id shift 257771',198024.75,0.00,0.00,0.00,0.00,'2022-05-22 14:37:34','',''),(2616173,'5','173','904',400,'Sale Id shift 257784',0.00,0.00,0.00,2948.06,0.00,'2022-06-04 15:42:43','',''),(2616174,'5','173',NULL,400,'Sale Id shift 257784',486429.90,0.00,0.00,0.00,0.00,'2022-06-04 15:42:43','',''),(2616175,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-06 09:54:26','',''),(2616176,'5','173',NULL,400,'Reception corrector for bridging 131609',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 10:26:11','',''),(2616177,'5','173','905',400,'Received from bridging 131609',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 10:26:11','',''),(2616178,'5','173',NULL,400,'Reception corrector for bridging 131608',0.00,0.00,0.00,30000.00,0.00,'2022-06-06 10:26:11','',''),(2616179,'5','173','904',400,'Received from bridging 131608',0.00,0.00,30000.00,0.00,0.00,'2022-06-06 10:26:11','',''),(2616180,'5','173','904',400,'Sale Id shift 257785',0.00,0.00,0.00,5051.92,0.00,'2022-06-06 11:10:38','',''),(2616181,'5','173',NULL,400,'Sale Id shift 257785',833566.80,0.00,0.00,0.00,0.00,'2022-06-06 11:10:38','',''),(2616182,'5','173','905',400,'Sale Id shift 257786',0.00,0.00,0.00,4702.05,0.00,'2022-06-06 12:03:38','',''),(2616183,'5','173',NULL,400,'Sale Id shift 257786',775838.25,0.00,0.00,0.00,0.00,'2022-06-06 12:03:38','',''),(2616184,'5','173','904',400,'Sale Id shift 257787',0.00,0.00,0.00,4702.06,0.00,'2022-06-07 11:02:32','',''),(2616185,'5','173',NULL,400,'Sale Id shift 257787',775839.90,0.00,0.00,0.00,0.00,'2022-06-07 11:02:32','',''),(2616186,'5','173','904',400,'Sale Id shift 257788',0.00,0.00,0.00,8121.76,0.00,'2022-06-08 15:30:23','',''),(2616187,'5','173',NULL,400,'Sale Id shift 257788',1340090.40,0.00,0.00,0.00,0.00,'2022-06-08 15:30:23','',''),(2616188,'5','173','904',400,'Sale Id shift 257789',0.00,0.00,0.00,7200.00,0.00,'2022-06-09 11:16:03','',''),(2616189,'5','173',NULL,400,'Sale Id shift 257789',1188000.00,0.00,0.00,0.00,0.00,'2022-06-09 11:16:03','',''),(2616190,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7309500.00,44300.00,0.00,0.00,'2022-06-10 09:22:58','',''),(2616191,'5','173','904',400,'Sale Id shift 257790',0.00,0.00,0.00,5506.17,0.00,'2022-06-10 15:28:31','',''),(2616192,'5','173',NULL,400,'Sale Id shift 257790',908518.05,0.00,0.00,0.00,0.00,'2022-06-10 15:28:31','',''),(2616193,'5','173','904',400,'Sale Id shift 257791',0.00,0.00,0.00,545.15,0.00,'2022-06-12 09:56:54','',''),(2616194,'5','173','905',400,'Sale Id shift 257791',0.00,0.00,0.00,6027.94,0.00,'2022-06-12 09:56:54','',''),(2616195,'5','173',NULL,400,'Sale Id shift 257791',1084559.85,0.00,0.00,0.00,0.00,'2022-06-12 09:56:54','',''),(2616196,'5','173',NULL,400,'Reception corrector for bridging 131611',0.00,0.00,0.00,21500.00,0.00,'2022-06-12 13:20:34','',''),(2616197,'5','173','905',400,'Received from bridging 131611',0.00,0.00,21500.00,0.00,0.00,'2022-06-12 13:20:34','',''),(2616198,'5','173',NULL,400,'Reception corrector for bridging 131610',0.00,0.00,0.00,22800.00,0.00,'2022-06-12 13:20:42','',''),(2616199,'5','173','904',400,'Received from bridging 131610',0.00,0.00,22800.00,0.00,0.00,'2022-06-12 13:20:42','',''),(2616200,'5','173','905',400,'Sale Id shift 257792',0.00,0.00,0.00,5178.28,0.00,'2022-06-12 14:10:19','',''),(2616201,'5','173',NULL,400,'Sale Id shift 257792',854416.20,0.00,0.00,0.00,0.00,'2022-06-12 14:10:19','',''),(2616202,'5','173','905',400,'Sale Id shift 257793',0.00,0.00,0.00,4821.71,0.00,'2022-06-13 09:32:27','',''),(2616203,'5','173',NULL,400,'Sale Id shift 257793',795582.15,0.00,0.00,0.00,0.00,'2022-06-13 09:32:27','',''),(2616204,'5','173','904',400,'Sale Id shift 257794',0.00,0.00,0.00,5006.18,0.00,'2022-06-14 11:02:26','',''),(2616205,'5','173',NULL,400,'Sale Id shift 257794',826019.70,0.00,0.00,0.00,0.00,'2022-06-14 11:02:26','',''),(2616206,'5','173','904',400,'Sale Id shift 257795',0.00,0.00,0.00,4993.82,0.00,'2022-06-16 09:19:59','',''),(2616207,'5','173',NULL,400,'Sale Id shift 257795',823980.30,0.00,0.00,0.00,0.00,'2022-06-16 09:19:59','',''),(2616208,'5','173','904',400,'Sale Id shift 257796',0.00,0.00,0.00,4082.30,0.00,'2022-06-17 09:58:06','',''),(2616209,'5','173',NULL,400,'Sale Id shift 257796',673579.50,0.00,0.00,0.00,0.00,'2022-06-17 09:58:06','',''),(2616210,'5','173','904',400,'Sale Id shift 257797',0.00,0.00,0.00,3720.70,0.00,'2022-06-18 09:49:32','',''),(2616211,'5','173',NULL,400,'Sale Id shift 257797',613915.50,0.00,0.00,0.00,0.00,'2022-06-18 09:49:32','',''),(2616212,'5','173','904',400,'Sale Id shift 257798',0.00,0.00,0.00,3458.20,0.00,'2022-06-19 09:35:14','',''),(2616213,'5','173',NULL,400,'Sale Id shift 257798',570603.00,0.00,0.00,0.00,0.00,'2022-06-19 09:35:14','',''),(2616214,'5','173','905',400,'Sale Id shift 257799',0.00,0.00,0.00,3004.90,0.00,'2022-06-20 10:00:17','',''),(2616215,'5','173',NULL,400,'Sale Id shift 257799',495808.50,0.00,0.00,0.00,0.00,'2022-06-20 10:00:17','',''),(2616216,'5','173','905',400,'Sale Id shift 257800',0.00,0.00,0.00,2921.59,0.00,'2022-06-21 09:57:46','',''),(2616217,'5','173',NULL,400,'Sale Id shift 257800',482062.35,0.00,0.00,0.00,0.00,'2022-06-21 09:57:46','',''),(2616218,'5','173','905',400,'Sale Id shift 257801',0.00,0.00,0.00,2503.40,0.00,'2022-06-22 09:33:14','',''),(2616219,'5','173',NULL,400,'Sale Id shift 257801',413061.00,0.00,0.00,0.00,0.00,'2022-06-22 09:33:14','',''),(2616220,'5','173','904',400,'Sale Id shift 257802',0.00,0.00,0.00,1608.71,0.00,'2022-06-22 14:33:15','',''),(2616221,'5','173',NULL,400,'Sale Id shift 257802',265437.15,0.00,0.00,0.00,0.00,'2022-06-22 14:33:15','',''),(2616222,'5','173','905',400,'Sale Id shift 257803',0.00,0.00,0.00,2001.08,0.00,'2022-06-23 11:10:49','',''),(2616223,'5','173',NULL,400,'Sale Id shift 257803',330178.20,0.00,0.00,0.00,0.00,'2022-06-23 11:10:49','',''),(2616224,'5','173','905',400,'Sale Id shift 257825',0.00,0.00,0.00,786.05,0.00,'2022-07-16 09:57:51','',''),(2616225,'5','173',NULL,400,'Sale Id shift 257825',129698.25,0.00,0.00,0.00,0.00,'2022-07-16 09:57:51','',''),(2616226,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-16 09:58:22','',''),(2616227,'5','173',NULL,400,'Reception corrector for bridging 131613',0.00,0.00,0.00,24000.00,0.00,'2022-07-17 09:21:40','',''),(2616228,'5','173','905',400,'Received from bridging 131613',0.00,0.00,24000.00,0.00,0.00,'2022-07-17 09:21:40','',''),(2616229,'5','173',NULL,400,'Reception corrector for bridging 131612',0.00,0.00,0.00,26000.00,0.00,'2022-07-17 09:21:40','',''),(2616230,'5','173','904',400,'Received from bridging 131612',0.00,0.00,26000.00,0.00,0.00,'2022-07-17 09:21:40','',''),(2616231,'5','173','905',400,'Sale Id shift 257826',0.00,0.00,0.00,4437.90,0.00,'2022-07-17 09:22:05','',''),(2616232,'5','173',NULL,400,'Sale Id shift 257826',821011.50,0.00,0.00,0.00,0.00,'2022-07-17 09:22:05','',''),(2616233,'5','173','904',400,'Sale Id shift 257827',0.00,0.00,0.00,5562.10,0.00,'2022-07-18 09:05:59','',''),(2616234,'5','173',NULL,400,'Sale Id shift 257827',1028988.50,0.00,0.00,0.00,0.00,'2022-07-18 09:05:59','',''),(2616235,'5','173','904',400,'Sale Id shift 257828',0.00,0.00,0.00,5460.25,0.00,'2022-07-19 09:42:43','',''),(2616236,'5','173',NULL,400,'Sale Id shift 257828',1010146.25,0.00,0.00,0.00,0.00,'2022-07-19 09:42:43','',''),(2616237,'5','173','905',400,'Sale Id shift 257829',0.00,0.00,0.00,4539.75,0.00,'2022-07-20 14:03:57','',''),(2616238,'5','173',NULL,400,'Sale Id shift 257829',839853.75,0.00,0.00,0.00,0.00,'2022-07-20 14:03:57','',''),(2616239,'5','173','904',400,'Sale Id shift 257830',0.00,0.00,0.00,2090.38,0.00,'2022-07-21 10:21:47','',''),(2616240,'5','173','904',400,'Sale Id shift 257830',0.00,0.00,0.00,3316.45,0.00,'2022-07-21 10:21:47','',''),(2616241,'5','173',NULL,400,'Sale Id shift 257830',1000263.55,0.00,0.00,0.00,0.00,'2022-07-21 10:21:47','',''),(2616242,'5','173','904',400,'Sale Id shift 257831',0.00,0.00,0.00,4093.17,0.00,'2022-07-22 09:54:30','',''),(2616243,'5','173',NULL,400,'Sale Id shift 257831',757236.45,0.00,0.00,0.00,0.00,'2022-07-22 09:54:30','',''),(2616244,'5','173','904',400,'Sale Id shift 257832',0.00,0.00,0.00,3502.97,0.00,'2022-07-23 10:38:15','',''),(2616245,'5','173',NULL,400,'Sale Id shift 257832',648049.45,0.00,0.00,0.00,0.00,'2022-07-23 10:38:15','',''),(2616246,'5','173','905',400,'Sale Id shift 257833',0.00,0.00,0.00,2996.83,0.00,'2022-07-24 09:32:06','',''),(2616247,'5','173',NULL,400,'Sale Id shift 257833',554413.55,0.00,0.00,0.00,0.00,'2022-07-24 09:32:06','',''),(2616248,'5','173','905',400,'Sale Id shift 257834',0.00,0.00,0.00,2865.21,0.00,'2022-07-25 07:36:42','',''),(2616249,'5','173',NULL,400,'Sale Id shift 257834',530063.85,0.00,0.00,0.00,0.00,'2022-07-25 07:36:42','',''),(2616250,'5','173','905',400,'Sale Id shift 257835',0.00,0.00,0.00,2163.87,0.00,'2022-07-26 09:23:00','',''),(2616251,'5','173','905',400,'Sale Id shift 257835',0.00,0.00,0.00,585.95,0.00,'2022-07-26 09:23:00','',''),(2616252,'5','173',NULL,400,'Sale Id shift 257835',508716.70,0.00,0.00,0.00,0.00,'2022-07-26 09:23:00','',''),(2616253,'5','173','905',400,'Sale Id shift 257836',0.00,0.00,0.00,2000.00,0.00,'2022-07-27 11:20:20','',''),(2616254,'5','173','905',400,'Sale Id shift 257836',0.00,0.00,0.00,2003.89,0.00,'2022-07-27 11:20:20','',''),(2616255,'5','173',NULL,400,'Sale Id shift 257836',740719.65,0.00,0.00,0.00,0.00,'2022-07-27 11:20:20','',''),(2616256,'5','173','905',400,'Sale Id shift 257837',0.00,0.00,0.00,3010.17,0.00,'2022-07-28 09:28:44','',''),(2616257,'5','173',NULL,400,'Sale Id shift 257837',556881.45,0.00,0.00,0.00,0.00,'2022-07-28 09:28:44','',''),(2616258,'5','173','905',400,'Sale Id shift 257838',0.00,0.00,0.00,1221.59,0.00,'2022-07-29 09:26:17','',''),(2616259,'5','173',NULL,400,'Sale Id shift 257838',225994.15,0.00,0.00,0.00,0.00,'2022-07-29 09:26:17','',''),(2616260,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-08-05 17:53:28','',''),(2616261,'5','173',NULL,400,'Reception corrector for bridging 131615',0.00,0.00,0.00,10000.00,0.00,'2022-08-05 18:32:55','',''),(2616262,'5','173','905',400,'Received from bridging 131615',0.00,0.00,10000.00,0.00,0.00,'2022-08-05 18:32:55','',''),(2616263,'5','173',NULL,400,'Reception corrector for bridging 131614',0.00,0.00,0.00,20000.00,0.00,'2022-08-05 18:32:55','',''),(2616264,'5','173','904',400,'Received from bridging 131614',0.00,0.00,20000.00,0.00,0.00,'2022-08-05 18:32:55','',''),(2616265,'5','173','904',400,'Sale Id shift 257846',0.00,0.00,0.00,518.22,0.00,'2022-08-06 09:00:05','',''),(2616266,'5','173','904',400,'Sale Id shift 257846',0.00,0.00,0.00,685.99,0.00,'2022-08-06 09:00:05','',''),(2616267,'5','173',NULL,400,'Sale Id shift 257846',222778.85,0.00,0.00,0.00,0.00,'2022-08-06 09:00:05','',''),(2616268,'5','173','904',400,'Sale Id shift 257847',0.00,0.00,0.00,4414.51,0.00,'2022-08-07 10:04:15','',''),(2616269,'5','173',NULL,400,'Sale Id shift 257847',816684.35,0.00,0.00,0.00,0.00,'2022-08-07 10:04:15','',''),(2616270,'5','173','904',400,'Sale Id shift 257848',0.00,0.00,0.00,3928.57,0.00,'2022-09-03 09:37:23','',''),(2616271,'5','173','905',400,'Sale Id shift 257848',0.00,0.00,0.00,970.53,0.00,'2022-09-03 09:37:23','',''),(2616272,'5','173',NULL,400,'Sale Id shift 257848',906333.50,0.00,0.00,0.00,0.00,'2022-09-03 09:37:23','',''),(2616273,'5','173','904',400,'Sale Id shift 257849',0.00,0.00,0.00,2506.01,0.00,'2022-09-03 09:45:01','',''),(2616274,'5','173','905',400,'Sale Id shift 257849',0.00,0.00,0.00,1483.99,0.00,'2022-09-03 09:45:01','',''),(2616275,'5','173',NULL,400,'Sale Id shift 257849',738150.00,0.00,0.00,0.00,0.00,'2022-09-03 09:45:01','',''),(2616276,'5','173','904',400,'Sale Id shift 257850',0.00,0.00,0.00,2803.12,0.00,'2022-09-03 09:47:04','',''),(2616277,'5','173',NULL,400,'Sale Id shift 257850',518577.20,0.00,0.00,0.00,0.00,'2022-09-03 09:47:04','',''),(2616278,'5','173','904',400,'Sale Id shift 257851',0.00,0.00,0.00,2190.46,0.00,'2022-09-03 09:50:17','',''),(2616279,'5','173','905',400,'Sale Id shift 257851',0.00,0.00,0.00,1570.10,0.00,'2022-09-03 09:50:17','',''),(2616280,'5','173',NULL,400,'Sale Id shift 257851',695703.60,0.00,0.00,0.00,0.00,'2022-09-03 09:50:17','',''),(2616281,'5','173','905',400,'Sale Id shift 257852',0.00,0.00,0.00,2403.08,0.00,'2022-09-03 09:54:38','',''),(2616282,'5','173',NULL,400,'Sale Id shift 257852',444569.80,0.00,0.00,0.00,0.00,'2022-09-03 09:54:38','',''),(2616283,'5','173','904',400,'Sale Id shift 257853',0.00,0.00,0.00,1403.20,0.00,'2022-09-03 09:57:30','',''),(2616284,'5','173',NULL,400,'Sale Id shift 257853',259592.00,0.00,0.00,0.00,0.00,'2022-09-03 09:57:30','',''),(2616285,'5','173','904',400,'Sale Id shift 257854',0.00,0.00,0.00,1445.60,0.00,'2022-09-03 10:04:54','',''),(2616286,'5','173','905',400,'Sale Id shift 257854',0.00,0.00,0.00,3303.27,0.00,'2022-09-03 10:04:54','',''),(2616287,'5','173',NULL,400,'Sale Id shift 257854',878540.95,0.00,0.00,0.00,0.00,'2022-09-03 10:04:54','',''),(2616288,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-03 10:05:21','',''),(2616289,'5','173','904',400,'Sale Id shift 257855',0.00,0.00,0.00,1750.86,0.00,'2022-09-03 10:08:14','',''),(2616290,'5','173','905',400,'Sale Id shift 257855',0.00,0.00,0.00,590.87,0.00,'2022-09-03 10:08:14','',''),(2616291,'5','173',NULL,400,'Sale Id shift 257855',433220.05,0.00,0.00,0.00,0.00,'2022-09-03 10:08:14','',''),(2616292,'5','173',NULL,400,'Reception corrector for bridging 131617',0.00,0.00,0.00,29000.00,0.00,'2022-09-03 10:13:03','',''),(2616293,'5','173','905',400,'Received from bridging 131617',0.00,0.00,29000.00,0.00,0.00,'2022-09-03 10:13:03','',''),(2616294,'5','173',NULL,400,'Reception corrector for bridging 131616',0.00,0.00,0.00,31000.00,0.00,'2022-09-03 10:13:03','',''),(2616295,'5','173','904',400,'Received from bridging 131616',0.00,0.00,31000.00,0.00,0.00,'2022-09-03 10:13:03','',''),(2616296,'5','173','904',400,'Sale Id shift 257856',0.00,0.00,0.00,2920.70,0.00,'2022-09-03 10:15:33','',''),(2616297,'5','173','905',400,'Sale Id shift 257856',0.00,0.00,0.00,1789.20,0.00,'2022-09-03 10:15:33','',''),(2616298,'5','173',NULL,400,'Sale Id shift 257856',871331.50,0.00,0.00,0.00,0.00,'2022-09-03 10:15:33','',''),(2616299,'5','173','904',400,'Sale Id shift 257857',0.00,0.00,0.00,1301.80,0.00,'2022-09-03 10:22:25','',''),(2616300,'5','173','905',400,'Sale Id shift 257857',0.00,0.00,0.00,3388.62,0.00,'2022-09-03 10:22:25','',''),(2616301,'5','173',NULL,400,'Sale Id shift 257857',867727.70,0.00,0.00,0.00,0.00,'2022-09-03 10:22:25','',''),(2616302,'5','173','904',400,'Sale Id shift 257858',0.00,0.00,0.00,2108.90,0.00,'2022-09-03 10:35:08','',''),(2616303,'5','173','905',400,'Sale Id shift 257858',0.00,0.00,0.00,2126.06,0.00,'2022-09-03 10:35:08','',''),(2616304,'5','173',NULL,400,'Sale Id shift 257858',783467.60,0.00,0.00,0.00,0.00,'2022-09-03 10:35:08','',''),(2616305,'5','173','904',400,'Sale Id shift 257859',0.00,0.00,0.00,3008.99,0.00,'2022-09-03 11:05:13','',''),(2616306,'5','173','905',400,'Sale Id shift 257859',0.00,0.00,0.00,1641.13,0.00,'2022-09-03 11:05:13','',''),(2616307,'5','173',NULL,400,'Sale Id shift 257859',860272.20,0.00,0.00,0.00,0.00,'2022-09-03 11:05:13','',''),(2616308,'5','173','904',400,'Sale Id shift 257860',0.00,0.00,0.00,3850.47,0.00,'2022-09-03 12:12:25','',''),(2616309,'5','173','905',400,'Sale Id shift 257860',0.00,0.00,0.00,1110.23,0.00,'2022-09-03 12:12:25','',''),(2616310,'5','173',NULL,400,'Sale Id shift 257860',917729.50,0.00,0.00,0.00,0.00,'2022-09-03 12:12:25','',''),(2616311,'5','173','904',400,'Sale Id shift 257861',0.00,0.00,0.00,2065.11,0.00,'2022-09-04 10:11:24','',''),(2616312,'5','173','905',400,'Sale Id shift 257861',0.00,0.00,0.00,2218.09,0.00,'2022-09-04 10:11:24','',''),(2616313,'5','173',NULL,400,'Sale Id shift 257861',792392.00,0.00,0.00,0.00,0.00,'2022-09-04 10:11:24','',''),(2616314,'5','173','904',400,'Sale Id shift 257862',0.00,0.00,0.00,2698.46,0.00,'2022-09-04 10:17:30','',''),(2616315,'5','173','905',400,'Sale Id shift 257862',0.00,0.00,0.00,1351.37,0.00,'2022-09-04 10:17:30','',''),(2616316,'5','173',NULL,400,'Sale Id shift 257862',749218.55,0.00,0.00,0.00,0.00,'2022-09-04 10:17:30','',''),(2616317,'5','173','904',400,'Sale Id shift 257863',0.00,0.00,0.00,2199.67,0.00,'2022-09-04 10:21:29','',''),(2616318,'5','173','905',400,'Sale Id shift 257863',0.00,0.00,0.00,2458.53,0.00,'2022-09-04 10:21:29','',''),(2616319,'5','173',NULL,400,'Sale Id shift 257863',861767.00,0.00,0.00,0.00,0.00,'2022-09-04 10:21:29','',''),(2616320,'5','173','904',400,'Sale Id shift 257864',0.00,0.00,0.00,2890.18,0.00,'2022-09-04 10:24:01','',''),(2616321,'5','173','905',400,'Sale Id shift 257864',0.00,0.00,0.00,1851.72,0.00,'2022-09-04 10:24:01','',''),(2616322,'5','173',NULL,400,'Sale Id shift 257864',877251.50,0.00,0.00,0.00,0.00,'2022-09-04 10:24:01','',''),(2616323,'5','173','904',400,'Sale Id shift 257865',0.00,0.00,0.00,2260.00,0.00,'2022-09-04 10:26:34','',''),(2616324,'5','173','905',400,'Sale Id shift 257865',0.00,0.00,0.00,1590.81,0.00,'2022-09-04 10:26:34','',''),(2616325,'5','173',NULL,400,'Sale Id shift 257865',712399.85,0.00,0.00,0.00,0.00,'2022-09-04 10:26:34','',''),(2616326,'5','173','904',400,'Sale Id shift 257866',0.00,0.00,0.00,4736.22,0.00,'2022-09-04 10:28:50','',''),(2616327,'5','173',NULL,400,'Sale Id shift 257866',876200.70,0.00,0.00,0.00,0.00,'2022-09-04 10:28:50','',''),(2616328,'5','173','904',400,'Sale Id shift 257867',0.00,0.00,0.00,1526.08,0.00,'2022-09-04 10:36:43','',''),(2616329,'5','173','905',400,'Sale Id shift 257867',0.00,0.00,0.00,4503.56,0.00,'2022-09-04 10:36:43','',''),(2616330,'5','173',NULL,400,'Sale Id shift 257867',1115483.40,0.00,0.00,0.00,0.00,'2022-09-04 10:36:43','',''),(2616331,'5','173','905',400,'Sale Id shift 257868',0.00,0.00,0.00,6116.69,0.00,'2022-09-04 10:48:30','',''),(2616332,'5','173',NULL,400,'Sale Id shift 257868',1131587.65,0.00,0.00,0.00,0.00,'2022-09-04 10:48:30','',''),(2616333,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,9213000.00,49800.00,0.00,0.00,'2022-09-04 10:51:53','',''),(2616334,'5','173',NULL,400,'Reception corrector for bridging 131618',0.00,0.00,0.00,30000.00,0.00,'2022-09-04 10:55:51','',''),(2616335,'5','173','904',400,'Received from bridging 131618',0.00,0.00,30000.00,0.00,0.00,'2022-09-04 10:55:51','',''),(2616336,'5','173',NULL,400,'Reception corrector for bridging 131619',0.00,0.00,0.00,19800.00,0.00,'2022-09-04 10:55:59','',''),(2616337,'5','173','905',400,'Received from bridging 131619',0.00,0.00,19800.00,0.00,0.00,'2022-09-04 10:55:59','',''),(2616338,'5','173','904',400,'Sale Id shift 257869',0.00,0.00,0.00,4517.19,0.00,'2022-09-04 10:58:20','',''),(2616339,'5','173',NULL,400,'Sale Id shift 257869',835680.15,0.00,0.00,0.00,0.00,'2022-09-04 10:58:20','',''),(2616340,'5','173','904',400,'Sale Id shift 257870',0.00,0.00,0.00,3143.13,0.00,'2022-09-04 11:00:16','',''),(2616341,'5','173',NULL,400,'Sale Id shift 257870',581479.05,0.00,0.00,0.00,0.00,'2022-09-04 11:00:16','',''),(2616342,'5','173','904',400,'Sale Id shift 257871',0.00,0.00,0.00,3011.18,0.00,'2022-09-04 11:02:11','',''),(2616343,'5','173',NULL,400,'Sale Id shift 257871',557068.30,0.00,0.00,0.00,0.00,'2022-09-04 11:02:11','',''),(2616344,'5','173','904',400,'Sale Id shift 257872',0.00,0.00,0.00,2046.81,0.00,'2022-09-04 11:04:33','',''),(2616345,'5','173',NULL,400,'Sale Id shift 257872',378659.85,0.00,0.00,0.00,0.00,'2022-09-04 11:04:33','',''),(2616346,'5','173','904',400,'Sale Id shift 257873',0.00,0.00,0.00,2243.77,0.00,'2022-09-04 11:07:17','',''),(2616347,'5','173',NULL,400,'Sale Id shift 257873',415097.45,0.00,0.00,0.00,0.00,'2022-09-04 11:07:17','',''),(2616348,'5','173','904',400,'Sale Id shift 257874',0.00,0.00,0.00,3015.20,0.00,'2022-09-04 11:09:09','',''),(2616349,'5','173',NULL,400,'Sale Id shift 257874',557812.00,0.00,0.00,0.00,0.00,'2022-09-04 11:09:09','',''),(2616350,'5','173','904',400,'Sale Id shift 257875',0.00,0.00,0.00,1682.20,0.00,'2022-09-04 11:12:55','',''),(2616351,'5','173','905',400,'Sale Id shift 257875',0.00,0.00,0.00,365.92,0.00,'2022-09-04 11:12:55','',''),(2616352,'5','173',NULL,400,'Sale Id shift 257875',378902.20,0.00,0.00,0.00,0.00,'2022-09-04 11:12:55','',''),(2616353,'5','173','904',400,'Sale Id shift 257876',0.00,0.00,0.00,1356.02,0.00,'2022-09-05 10:23:04','',''),(2616354,'5','173','905',400,'Sale Id shift 257876',0.00,0.00,0.00,691.96,0.00,'2022-09-05 10:23:04','',''),(2616355,'5','173',NULL,400,'Sale Id shift 257876',378876.30,0.00,0.00,0.00,0.00,'2022-09-05 10:23:04','',''),(2616356,'5','173','904',400,'Sale Id shift 257877',0.00,0.00,0.00,1924.08,0.00,'2022-09-06 10:21:05','',''),(2616357,'5','173','905',400,'Sale Id shift 257877',0.00,0.00,0.00,896.42,0.00,'2022-09-06 10:21:05','',''),(2616358,'5','173',NULL,400,'Sale Id shift 257877',521792.50,0.00,0.00,0.00,0.00,'2022-09-06 10:21:05','',''),(2616359,'5','173','904',400,'Sale Id shift 257878',0.00,0.00,0.00,1370.86,0.00,'2022-09-07 15:23:25','',''),(2616360,'5','173','904',400,'Sale Id shift 257878',0.00,0.00,0.00,1909.87,0.00,'2022-09-07 15:23:25','',''),(2616361,'5','173','905',400,'Sale Id shift 257878',0.00,0.00,0.00,748.76,0.00,'2022-09-07 15:23:25','',''),(2616362,'5','173',NULL,400,'Sale Id shift 257878',745455.65,0.00,0.00,0.00,0.00,'2022-09-07 15:23:25','',''),(2616363,'5','173','904',400,'Sale Id shift 257879',0.00,0.00,0.00,747.70,0.00,'2022-09-08 14:28:05','',''),(2616364,'5','173','905',400,'Sale Id shift 257879',0.00,0.00,0.00,1319.40,0.00,'2022-09-08 14:28:05','',''),(2616365,'5','173',NULL,400,'Sale Id shift 257879',382413.50,0.00,0.00,0.00,0.00,'2022-09-08 14:28:05','',''),(2616366,'5','173','905',400,'Sale Id shift 257880',0.00,0.00,0.00,2574.54,0.00,'2022-09-09 16:22:32','',''),(2616367,'5','173',NULL,400,'Sale Id shift 257880',476289.90,0.00,0.00,0.00,0.00,'2022-09-09 16:22:32','',''),(2616368,'5','173','904',400,'Sale Id shift 257881',0.00,0.00,0.00,431.36,0.00,'2022-09-11 05:58:06','',''),(2616369,'5','173','905',400,'Sale Id shift 257881',0.00,0.00,0.00,1700.00,0.00,'2022-09-11 05:58:06','',''),(2616370,'5','173',NULL,400,'Sale Id shift 257881',394301.60,0.00,0.00,0.00,0.00,'2022-09-11 05:58:06','',''),(2616371,'5','173','904',400,'Sale Id shift 257882',0.00,0.00,0.00,2355.14,0.00,'2022-09-12 05:54:38','',''),(2616372,'5','173','905',400,'Sale Id shift 257882',0.00,0.00,0.00,51.15,0.00,'2022-09-12 05:54:38','',''),(2616373,'5','173',NULL,400,'Sale Id shift 257882',445163.65,0.00,0.00,0.00,0.00,'2022-09-12 05:54:38','',''),(2616374,'5','173','905',400,'Sale Id shift 257883',0.00,0.00,0.00,2008.24,0.00,'2022-09-13 10:33:28','',''),(2616375,'5','173',NULL,400,'Sale Id shift 257883',371524.40,0.00,0.00,0.00,0.00,'2022-09-13 10:33:28','',''),(2616376,'5','173','905',400,'Sale Id shift 257884',0.00,0.00,0.00,2155.75,0.00,'2022-09-14 06:02:18','',''),(2616377,'5','173',NULL,400,'Sale Id shift 257884',398813.75,0.00,0.00,0.00,0.00,'2022-09-14 06:02:18','',''),(2616378,'5','173','905',400,'Sale Id shift 257885',0.00,0.00,0.00,2202.07,0.00,'2022-09-14 16:29:33','',''),(2616379,'5','173',NULL,400,'Sale Id shift 257885',407382.95,0.00,0.00,0.00,0.00,'2022-09-14 16:29:33','',''),(2616380,'5','173','905',400,'Sale Id shift 257886',0.00,0.00,0.00,798.61,0.00,'2022-09-15 10:05:58','',''),(2616381,'5','173',NULL,400,'Sale Id shift 257886',147742.85,0.00,0.00,0.00,0.00,'2022-09-15 10:05:58','',''),(2616382,'5','173','905',400,'Sale Id shift 257890',0.00,0.00,0.00,748.74,0.00,'2022-09-19 13:25:58','',''),(2616383,'5','173',NULL,400,'Sale Id shift 257890',138516.90,0.00,0.00,0.00,0.00,'2022-09-19 13:25:58','',''),(2616384,'5','173','905',400,'Sale Id shift 257891',0.00,0.00,0.00,944.46,0.00,'2022-09-20 11:21:19','',''),(2616385,'5','173','905',400,'Sale Id shift 257891',0.00,0.00,0.00,1087.35,0.00,'2022-09-20 11:21:19','',''),(2616386,'5','173',NULL,400,'Sale Id shift 257891',375884.85,0.00,0.00,0.00,0.00,'2022-09-20 11:21:19','',''),(2616387,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-20 11:55:28','',''),(2616388,'5','173',NULL,400,'Reception corrector for bridging 131621',0.00,0.00,0.00,14500.00,0.00,'2022-09-20 14:10:27','',''),(2616389,'5','173','905',400,'Received from bridging 131621',0.00,0.00,14500.00,0.00,0.00,'2022-09-20 14:10:27','',''),(2616390,'5','173',NULL,400,'Reception corrector for bridging 131620',0.00,0.00,0.00,15500.00,0.00,'2022-09-20 14:10:27','',''),(2616391,'5','173','904',400,'Received from bridging 131620',0.00,0.00,15500.00,0.00,0.00,'2022-09-20 14:10:27','',''),(2616392,'5','173','904',400,'Sale Id shift 257892',0.00,0.00,0.00,30.00,0.00,'2022-09-21 17:00:30','',''),(2616393,'5','173','904',400,'Sale Id shift 257892',0.00,0.00,0.00,698.23,0.00,'2022-09-21 17:00:30','',''),(2616394,'5','173','905',400,'Sale Id shift 257892',0.00,0.00,0.00,260.94,0.00,'2022-09-21 17:00:30','',''),(2616395,'5','173','905',400,'Sale Id shift 257892',0.00,0.00,0.00,215.80,0.00,'2022-09-21 17:00:30','',''),(2616396,'5','173',NULL,400,'Sale Id shift 257892',222919.45,0.00,0.00,0.00,0.00,'2022-09-21 17:00:30','',''),(2616397,'5','173','904',400,'Sale Id shift 257893',0.00,0.00,0.00,494.78,0.00,'2022-09-22 08:45:17','',''),(2616398,'5','173','904',400,'Sale Id shift 257893',0.00,0.00,0.00,797.35,0.00,'2022-09-22 08:45:17','',''),(2616399,'5','173',NULL,400,'Sale Id shift 257893',239044.05,0.00,0.00,0.00,0.00,'2022-09-22 08:45:18','',''),(2616400,'5','173','904',400,'Sale Id shift 257894',0.00,0.00,0.00,76.21,0.00,'2022-09-23 14:49:54','',''),(2616401,'5','173','904',400,'Sale Id shift 257894',0.00,0.00,0.00,819.57,0.00,'2022-09-23 14:49:54','',''),(2616402,'5','173','905',400,'Sale Id shift 257894',0.00,0.00,0.00,426.55,0.00,'2022-09-23 14:49:54','',''),(2616403,'5','173',NULL,400,'Sale Id shift 257894',244631.05,0.00,0.00,0.00,0.00,'2022-09-23 14:49:54','',''),(2616404,'5','173','904',400,'Sale Id shift 257895',0.00,0.00,0.00,32.43,0.00,'2022-09-24 09:56:11','',''),(2616405,'5','173','904',400,'Sale Id shift 257895',0.00,0.00,0.00,1140.32,0.00,'2022-09-24 09:56:11','',''),(2616406,'5','173',NULL,400,'Sale Id shift 257895',216958.75,0.00,0.00,0.00,0.00,'2022-09-24 09:56:11','',''),(2616407,'5','173','904',400,'Sale Id shift 257896',0.00,0.00,0.00,1211.76,0.00,'2022-09-25 08:21:41','',''),(2616408,'5','173',NULL,400,'Sale Id shift 257896',224175.60,0.00,0.00,0.00,0.00,'2022-09-25 08:21:41','',''),(2616409,'5','173','904',400,'Sale Id shift 257897',0.00,0.00,0.00,1101.16,0.00,'2022-09-26 09:46:06','',''),(2616410,'5','173',NULL,400,'Sale Id shift 257897',203714.60,0.00,0.00,0.00,0.00,'2022-09-26 09:46:06','',''),(2616411,'5','173','904',400,'Sale Id shift 257898',0.00,0.00,0.00,1129.10,0.00,'2022-09-27 08:18:55','',''),(2616412,'5','173',NULL,400,'Sale Id shift 257898',208883.50,0.00,0.00,0.00,0.00,'2022-09-27 08:18:55','',''),(2616413,'5','173','904',400,'Sale Id shift 257899',0.00,0.00,0.00,300.00,0.00,'2022-09-28 10:04:46','',''),(2616414,'5','173','904',400,'Sale Id shift 257899',0.00,0.00,0.00,802.15,0.00,'2022-09-28 10:04:46','',''),(2616415,'5','173',NULL,400,'Sale Id shift 257899',203897.75,0.00,0.00,0.00,0.00,'2022-09-28 10:04:46','',''),(2616416,'5','173','904',400,'Sale Id shift 257900',0.00,0.00,0.00,1090.91,0.00,'2022-09-29 08:08:15','',''),(2616417,'5','173','905',400,'Sale Id shift 257900',0.00,0.00,0.00,241.91,0.00,'2022-09-29 08:08:15','',''),(2616418,'5','173',NULL,400,'Sale Id shift 257900',246571.70,0.00,0.00,0.00,0.00,'2022-09-29 08:08:15','',''),(2616419,'5','173','904',400,'Sale Id shift 257901',0.00,0.00,0.00,1020.34,0.00,'2022-10-01 10:26:52','',''),(2616420,'5','173',NULL,400,'Sale Id shift 257901',188762.90,0.00,0.00,0.00,0.00,'2022-10-01 10:26:52','',''),(2616421,'5','173','904',400,'Sale Id shift 257902',0.00,0.00,0.00,1101.48,0.00,'2022-10-02 08:08:45','',''),(2616422,'5','173',NULL,400,'Sale Id shift 257902',203773.80,0.00,0.00,0.00,0.00,'2022-10-02 08:08:45','',''),(2616423,'5','173','905',400,'Sale Id shift 257903',0.00,0.00,0.00,1384.28,0.00,'2022-10-03 05:59:07','',''),(2616424,'5','173',NULL,400,'Sale Id shift 257903',256091.80,0.00,0.00,0.00,0.00,'2022-10-03 05:59:07','',''),(2616425,'5','173','904',400,'Sale Id shift 257904',0.00,0.00,0.00,1000.00,0.00,'2022-10-03 09:32:56','',''),(2616426,'5','173','905',400,'Sale Id shift 257904',0.00,0.00,0.00,247.89,0.00,'2022-10-03 09:32:56','',''),(2616427,'5','173',NULL,400,'Sale Id shift 257904',230859.65,0.00,0.00,0.00,0.00,'2022-10-03 09:32:56','',''),(2616428,'5','173','905',400,'Sale Id shift 257905',0.00,0.00,0.00,1115.92,0.00,'2022-10-04 09:09:01','',''),(2616429,'5','173',NULL,400,'Sale Id shift 257905',206445.20,0.00,0.00,0.00,0.00,'2022-10-04 09:09:01','',''),(2616430,'5','173','905',400,'Sale Id shift 257906',0.00,0.00,0.00,1076.13,0.00,'2022-10-05 08:08:22','',''),(2616431,'5','173',NULL,400,'Sale Id shift 257906',199084.05,0.00,0.00,0.00,0.00,'2022-10-05 08:08:22','',''),(2616432,'5','173','905',400,'Sale Id shift 257907',0.00,0.00,0.00,1408.06,0.00,'2022-10-06 08:06:16','',''),(2616433,'5','173',NULL,400,'Sale Id shift 257907',260491.10,0.00,0.00,0.00,0.00,'2022-10-06 08:06:16','',''),(2616434,'5','173','905',400,'Sale Id shift 257908',0.00,0.00,0.00,3563.38,0.00,'2022-10-08 08:15:06','',''),(2616435,'5','173',NULL,400,'Sale Id shift 257908',659225.30,0.00,0.00,0.00,0.00,'2022-10-08 08:15:06','',''),(2616436,'5','173','904',400,'Sale Id shift 257909',0.00,0.00,0.00,1000.00,0.00,'2022-10-08 18:52:18','',''),(2616437,'5','173','904',400,'Sale Id shift 257909',0.00,0.00,0.00,1804.00,0.00,'2022-10-08 18:52:18','',''),(2616438,'5','173','905',400,'Sale Id shift 257909',0.00,0.00,0.00,2071.20,0.00,'2022-10-08 18:52:18','',''),(2616439,'5','173',NULL,400,'Sale Id shift 257909',901912.00,0.00,0.00,0.00,0.00,'2022-10-08 18:52:18','',''),(2616440,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,11044500.00,59700.00,0.00,0.00,'2022-10-08 18:52:36','',''),(2616441,'5','173',NULL,400,'Reception corrector for bridging 131622',0.00,0.00,0.00,30000.00,0.00,'2022-10-09 16:31:39','',''),(2616442,'5','173','904',400,'Received from bridging 131622',0.00,0.00,30000.00,0.00,0.00,'2022-10-09 16:31:39','',''),(2616443,'5','173','904',400,'Sale Id shift 257910',0.00,0.00,0.00,2699.69,0.00,'2022-10-09 17:19:08','',''),(2616444,'5','173','905',400,'Sale Id shift 257910',0.00,0.00,0.00,5842.80,0.00,'2022-10-09 17:19:08','',''),(2616445,'5','173',NULL,400,'Sale Id shift 257910',1580360.65,0.00,0.00,0.00,0.00,'2022-10-09 17:19:08','',''),(2616446,'5','173',NULL,400,'Reception corrector for bridging 131623',0.00,0.00,0.00,29700.00,0.00,'2022-10-10 10:27:32','',''),(2616447,'5','173','905',400,'Received from bridging 131623',0.00,0.00,29700.00,0.00,0.00,'2022-10-10 10:27:32','',''),(2616448,'5','173','904',400,'Sale Id shift 257911',0.00,0.00,0.00,5867.33,0.00,'2022-10-10 17:04:03','',''),(2616449,'5','173','905',400,'Sale Id shift 257911',0.00,0.00,0.00,636.14,0.00,'2022-10-10 17:04:03','',''),(2616450,'5','173',NULL,400,'Sale Id shift 257911',1203141.95,0.00,0.00,0.00,0.00,'2022-10-10 17:04:03','',''),(2616451,'5','173','904',400,'Sale Id shift 257912',0.00,0.00,0.00,7809.09,0.00,'2022-10-12 09:01:10','',''),(2616452,'5','173','905',400,'Sale Id shift 257912',0.00,0.00,0.00,1597.81,0.00,'2022-10-12 09:01:10','',''),(2616453,'5','173',NULL,400,'Sale Id shift 257912',1740276.50,0.00,0.00,0.00,0.00,'2022-10-12 09:01:10','',''),(2616454,'5','173','904',400,'Sale Id shift 257913',0.00,0.00,0.00,822.18,0.00,'2022-10-12 16:52:15','',''),(2616455,'5','173','905',400,'Sale Id shift 257913',0.00,0.00,0.00,4064.93,0.00,'2022-10-12 16:52:15','',''),(2616456,'5','173',NULL,400,'Sale Id shift 257913',904115.35,0.00,0.00,0.00,0.00,'2022-10-12 16:52:15','',''),(2616457,'5','173','904',400,'Sale Id shift 257914',0.00,0.00,0.00,1593.56,0.00,'2022-10-14 08:15:39','',''),(2616458,'5','173','905',400,'Sale Id shift 257914',0.00,0.00,0.00,1440.92,0.00,'2022-10-14 08:15:39','',''),(2616459,'5','173','905',400,'Sale Id shift 257914',0.00,0.00,0.00,1000.00,0.00,'2022-10-14 08:15:39','',''),(2616460,'5','173',NULL,400,'Sale Id shift 257914',746378.80,0.00,0.00,0.00,0.00,'2022-10-14 08:15:39','',''),(2616461,'5','173','904',400,'Sale Id shift 257915',0.00,0.00,0.00,4354.87,0.00,'2022-10-14 14:23:21','',''),(2616462,'5','173','905',400,'Sale Id shift 257915',0.00,0.00,0.00,2213.38,0.00,'2022-10-14 14:23:21','',''),(2616463,'5','173',NULL,400,'Sale Id shift 257915',1215126.25,0.00,0.00,0.00,0.00,'2022-10-14 14:23:21','',''),(2616464,'5','173','904',400,'Sale Id shift 257916',0.00,0.00,0.00,3453.88,0.00,'2022-10-16 10:00:41','',''),(2616465,'5','173',NULL,400,'Sale Id shift 257916',638967.80,0.00,0.00,0.00,0.00,'2022-10-16 10:00:41','',''),(2616466,'5','173','904',400,'Sale Id shift 257917',0.00,0.00,0.00,3124.13,0.00,'2022-10-17 08:10:15','',''),(2616467,'5','173','905',400,'Sale Id shift 257917',0.00,0.00,0.00,1561.99,0.00,'2022-10-17 08:10:15','',''),(2616468,'5','173',NULL,400,'Sale Id shift 257917',866932.20,0.00,0.00,0.00,0.00,'2022-10-17 08:10:15','',''),(2616469,'5','173','904',400,'Sale Id shift 257918',0.00,0.00,0.00,420.30,0.00,'2022-10-17 11:29:59','',''),(2616470,'5','173','905',400,'Sale Id shift 257918',0.00,0.00,0.00,2253.74,0.00,'2022-10-17 11:29:59','',''),(2616471,'5','173',NULL,400,'Sale Id shift 257918',494697.40,0.00,0.00,0.00,0.00,'2022-10-17 11:29:59','',''),(2616472,'5','173','905',400,'Sale Id shift 257919',0.00,0.00,0.00,2903.88,0.00,'2022-10-18 21:32:30','',''),(2616473,'5','173',NULL,400,'Sale Id shift 257919',537217.80,0.00,0.00,0.00,0.00,'2022-10-18 21:32:30','',''),(2616474,'5','173','905',400,'Sale Id shift 257920',0.00,0.00,0.00,2305.95,0.00,'2022-10-19 08:18:13','',''),(2616475,'5','173',NULL,400,'Sale Id shift 257920',426600.75,0.00,0.00,0.00,0.00,'2022-10-19 08:18:13','',''),(2616476,'5','173','905',400,'Sale Id shift 257921',0.00,0.00,0.00,3343.20,0.00,'2022-10-21 06:02:32','',''),(2616477,'5','173',NULL,400,'Sale Id shift 257921',618492.00,0.00,0.00,0.00,0.00,'2022-10-21 06:02:32','',''),(2616478,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,8269500.00,44700.00,0.00,0.00,'2022-11-03 16:38:24','',''),(2616479,'5','173','905',400,'Sale Id shift 257935',0.00,0.00,0.00,3234.23,0.00,'2022-11-03 16:38:42','',''),(2616480,'5','173',NULL,400,'Sale Id shift 257935',598332.55,0.00,0.00,0.00,0.00,'2022-11-03 16:38:42','',''),(2616481,'5','173',NULL,400,'Reception corrector for bridging 131625',0.00,0.00,0.00,20700.00,0.00,'2022-11-04 08:17:23','',''),(2616482,'5','173','905',400,'Received from bridging 131625',0.00,0.00,20700.00,0.00,0.00,'2022-11-04 08:17:23','',''),(2616483,'5','173',NULL,400,'Reception corrector for bridging 131624',0.00,0.00,0.00,24000.00,0.00,'2022-11-04 08:17:23','',''),(2616484,'5','173','904',400,'Received from bridging 131624',0.00,0.00,24000.00,0.00,0.00,'2022-11-04 08:17:23','',''),(2616485,'5','173','904',400,'Sale Id shift 257936',0.00,0.00,0.00,4060.00,0.00,'2022-11-05 09:02:47','',''),(2616486,'5','173','905',400,'Sale Id shift 257936',0.00,0.00,0.00,2343.99,0.00,'2022-11-05 09:02:47','',''),(2616487,'5','173',NULL,400,'Sale Id shift 257936',1184738.15,0.00,0.00,0.00,0.00,'2022-11-05 09:02:47','',''),(2616488,'5','173','904',400,'Sale Id shift 257937',0.00,0.00,0.00,2000.00,0.00,'2022-11-05 09:42:27','',''),(2616489,'5','173','904',400,'Sale Id shift 257937',0.00,0.00,0.00,4812.28,0.00,'2022-11-05 09:42:27','',''),(2616490,'5','173',NULL,400,'Sale Id shift 257937',1260271.80,0.00,0.00,0.00,0.00,'2022-11-05 09:42:27','',''),(2616491,'5','173','904',400,'Sale Id shift 257938',0.00,0.00,0.00,1583.83,0.00,'2022-11-06 09:18:58','',''),(2616492,'5','173','904',400,'Sale Id shift 257938',0.00,0.00,0.00,4119.29,0.00,'2022-11-06 09:18:58','',''),(2616493,'5','173',NULL,400,'Sale Id shift 257938',1055077.20,0.00,0.00,0.00,0.00,'2022-11-06 09:18:58','',''),(2616494,'5','173','904',400,'Sale Id shift 257939',0.00,0.00,0.00,5401.04,0.00,'2022-11-07 09:14:26','',''),(2616495,'5','173',NULL,400,'Sale Id shift 257939',999192.40,0.00,0.00,0.00,0.00,'2022-11-07 09:14:26','',''),(2616496,'5','173','904',400,'Sale Id shift 257940',0.00,0.00,0.00,1111.51,0.00,'2022-11-08 08:19:35','',''),(2616497,'5','173','905',400,'Sale Id shift 257940',0.00,0.00,0.00,3997.16,0.00,'2022-11-08 08:19:35','',''),(2616498,'5','173',NULL,400,'Sale Id shift 257940',945103.95,0.00,0.00,0.00,0.00,'2022-11-08 08:19:35','',''),(2616499,'5','173','905',400,'Sale Id shift 257941',0.00,0.00,0.00,2130.23,0.00,'2022-11-09 08:17:55','',''),(2616500,'5','173','905',400,'Sale Id shift 257941',0.00,0.00,0.00,1960.64,0.00,'2022-11-09 08:17:55','',''),(2616501,'5','173',NULL,400,'Sale Id shift 257941',756810.95,0.00,0.00,0.00,0.00,'2022-11-09 08:17:55','',''),(2616502,'5','173','905',400,'Sale Id shift 257942',0.00,0.00,0.00,5104.70,0.00,'2022-11-10 09:31:32','',''),(2616503,'5','173',NULL,400,'Sale Id shift 257942',944369.50,0.00,0.00,0.00,0.00,'2022-11-10 09:31:32','',''),(2616504,'5','173','905',400,'Sale Id shift 257943',0.00,0.00,0.00,2841.10,0.00,'2022-11-11 13:27:10','',''),(2616505,'5','173',NULL,400,'Sale Id shift 257943',525603.50,0.00,0.00,0.00,0.00,'2022-11-11 13:27:10','',''),(2616506,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,10300500.00,49050.00,0.00,0.00,'2023-03-09 09:15:59','',''),(2616507,'5','173','905',0,'Tank level zero out for dipping',0.00,0.00,0.00,5989.45,0.00,'2023-03-10 10:39:27','',''),(2616508,'5','173','905',0,'Inventory adjustment from tank dipping to 100',0.00,0.00,100.00,0.00,0.00,'2023-03-10 10:39:27','',''),(2616509,'5','173',NULL,400,'Reception corrector for bridging 131627',0.00,0.00,0.00,32450.00,0.00,'2023-03-10 12:21:53','',''),(2616510,'5','173','905',400,'Received from bridging 131627',0.00,0.00,32450.00,0.00,0.00,'2023-03-10 12:21:53','',''),(2616511,'5','173',NULL,400,'Reception corrector for bridging 131626',0.00,0.00,0.00,16600.00,0.00,'2023-03-10 12:22:00','',''),(2616512,'5','173','904',400,'Received from bridging 131626',0.00,0.00,16600.00,0.00,0.00,'2023-03-10 12:22:00','',''),(2616513,'5','173','904',400,'Sale Id shift 257976',0.00,0.00,0.00,20.43,0.00,'2023-03-10 14:16:41','',''),(2616514,'5','173','905',400,'Sale Id shift 257976',0.00,0.00,0.00,3474.29,0.00,'2023-03-10 14:16:41','',''),(2616515,'5','173','905',400,'Sale Id shift 257976',0.00,0.00,0.00,3148.35,0.00,'2023-03-10 14:16:41','',''),(2616516,'5','173',NULL,400,'Sale Id shift 257976',1395044.70,0.00,0.00,0.00,0.00,'2023-03-10 14:16:41','',''),(2616517,'5','173','905',400,'Sale Id shift 257977',0.00,0.00,0.00,3603.83,0.00,'2023-03-10 14:56:15','',''),(2616518,'5','173','905',400,'Sale Id shift 257977',0.00,0.00,0.00,5123.67,0.00,'2023-03-10 14:56:15','',''),(2616519,'5','173',NULL,400,'Sale Id shift 257977',1832775.00,0.00,0.00,0.00,0.00,'2023-03-10 14:56:15','',''),(2616520,'5','173','905',400,'Sale Id shift 257978',0.00,0.00,0.00,3814.02,0.00,'2023-03-10 15:13:09','',''),(2616521,'5','173','905',400,'Sale Id shift 257978',0.00,0.00,0.00,4605.59,0.00,'2023-03-10 15:13:09','',''),(2616522,'5','173',NULL,400,'Sale Id shift 257978',1768118.10,0.00,0.00,0.00,0.00,'2023-03-10 15:13:09','',''),(2616523,'5','173',NULL,400,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,144690.00,689.00,0.00,0.00,'2023-03-10 15:42:19','',''),(2616524,'5','173',NULL,400,'Reception corrector for bridging 131628',0.00,0.00,0.00,689.00,0.00,'2023-03-11 14:26:47','',''),(2616525,'5','173','905',400,'Received from bridging 131628',0.00,0.00,689.00,0.00,0.00,'2023-03-11 14:26:47','',''),(2616526,'5','173','904',400,'Sale Id shift 257979',0.00,0.00,0.00,61.80,0.00,'2023-03-11 16:05:13','',''),(2616527,'5','173','904',400,'Sale Id shift 257979',0.00,0.00,0.00,1235.73,0.00,'2023-03-11 16:05:13','',''),(2616528,'5','173','905',400,'Sale Id shift 257979',0.00,0.00,0.00,4793.64,0.00,'2023-03-11 16:05:13','',''),(2616529,'5','173','905',400,'Sale Id shift 257979',0.00,0.00,0.00,4576.18,0.00,'2023-03-11 16:05:13','',''),(2616530,'5','173',NULL,400,'Sale Id shift 257979',2240143.50,0.00,0.00,0.00,0.00,'2023-03-11 16:05:13','',''),(2616531,'5','173','904',400,'Sale Id shift 257980',0.00,0.00,0.00,2178.23,0.00,'2023-03-11 16:33:20','',''),(2616532,'5','173','904',400,'Sale Id shift 257980',0.00,0.00,0.00,5706.16,0.00,'2023-03-11 16:33:20','',''),(2616533,'5','173',NULL,400,'Sale Id shift 257980',1655721.90,0.00,0.00,0.00,0.00,'2023-03-11 16:33:20','',''),(2616534,'5','173','904',400,'Sale Id shift 257981',0.00,0.00,0.00,2108.14,0.00,'2023-03-12 16:53:04','',''),(2616535,'5','173','904',400,'Sale Id shift 257981',0.00,0.00,0.00,5050.87,0.00,'2023-03-12 16:53:04','',''),(2616536,'5','173',NULL,400,'Sale Id shift 257981',1503392.10,0.00,0.00,0.00,0.00,'2023-03-12 16:53:04','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','173',402,0.00,'2023-03-20 20:10:02'),(2,'5','173',401,300.00,'2023-03-20 20:10:02'),(3,'5','173',400,7140.05,'2023-03-20 20:10:02');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1808795 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (576172,'5','173',400,'Sale Id shift 182030',0.00,0.00,163.00,365609.00,365609.00,'2021-03-15 14:30:32'),(576173,'5','173',401,'Sale Id shift 182030',0.00,0.00,250.00,27750.00,27750.00,'2021-03-15 14:30:32'),(576613,'5','173',401,'Sale Id shift 184629',0.00,0.00,250.00,474197.50,474197.50,'2021-03-15 15:52:42'),(576691,'5','173',401,'Sale Id shift 184634',0.00,0.00,250.00,19250.00,19250.00,'2021-03-15 16:07:29'),(578219,'5','173',400,'Sale Id shift 184635',0.00,207604.95,163.00,207604.95,0.00,'2021-03-16 09:35:27'),(578220,'5','173',401,'Sale Id shift 184635',0.00,0.00,250.00,40230.00,40230.00,'2021-03-16 09:35:27'),(578284,'5','173',400,'Sale Id shift 184745',0.00,674617.88,163.00,674617.88,0.00,'2021-03-16 09:48:40'),(578285,'5','173',401,'Sale Id shift 184745',0.00,0.00,250.00,35452.50,35452.50,'2021-03-16 09:48:40'),(578343,'5','173',400,'Sale Id shift 184749',0.00,764005.45,163.00,764005.45,0.00,'2021-03-16 09:58:33'),(578344,'5','173',401,'Sale Id shift 184749',0.00,0.00,250.00,22940.00,22940.00,'2021-03-16 09:58:33'),(578897,'5','173',400,'Sale Id shift 184778',0.00,1251950.84,163.00,1251950.84,0.00,'2021-03-16 11:51:50'),(578898,'5','173',401,'Sale Id shift 184778',0.00,0.00,250.00,384250.00,384250.00,'2021-03-16 11:51:50'),(581539,'5','173',400,'Sale Id shift 184958',0.00,881613.21,163.00,881613.21,0.00,'2021-03-17 11:06:15'),(581699,'5','173',400,'Sale Id shift 184969',0.00,989255.15,163.00,989255.15,0.00,'2021-03-17 11:42:13'),(581793,'5','173',400,'Sale Id shift 184987',0.00,1310932.39,163.00,1310932.39,0.00,'2021-03-17 12:33:18'),(582097,'5','173',400,'Sale Id shift 185016',0.00,2055315.90,163.00,2055315.90,0.00,'2021-03-17 14:10:13'),(598675,'5','173',400,'Sale Id shift 185022',0.00,2195099.81,163.00,2195099.81,0.00,'2021-03-22 15:30:14'),(598769,'5','173',400,'Sale Id shift 186012',0.00,1331679.03,163.00,1331679.03,0.00,'2021-03-22 15:45:31'),(598793,'5','173',400,'Sale Id shift 186014',0.00,1358301.82,163.00,1358301.82,0.00,'2021-03-22 15:49:30'),(598971,'5','173',400,'Sale Id shift 186016',0.00,815000.00,163.00,815000.00,0.00,'2021-03-22 16:13:19'),(599002,'5','173',400,'Sale Id shift 186024',0.00,293400.00,163.00,293400.00,0.00,'2021-03-22 16:18:10'),(599090,'5','173',400,'Sale Id shift 186026',0.00,163000.00,163.00,163000.00,0.00,'2021-03-22 16:30:46'),(599306,'5','173',400,'Sale Id shift 186028',0.00,316783.98,163.00,316783.98,0.00,'2021-03-22 17:15:50'),(600071,'5','173',400,'Sale Id shift 186124',0.00,1634132.05,163.00,1634132.05,0.00,'2021-03-23 08:47:32'),(600129,'5','173',400,'Sale Id shift 186128',0.00,1300678.06,163.00,1300678.06,0.00,'2021-03-23 09:00:30'),(600226,'5','173',400,'Sale Id shift 186131',0.00,1394161.82,163.00,1394161.82,0.00,'2021-03-23 09:20:01'),(604657,'5','173',400,'Sale Id shift 186349',0.00,1319605.62,163.00,1319605.62,0.00,'2021-03-24 14:38:32'),(608021,'5','173',400,'Sale Id shift 186670',0.00,1325830.59,163.00,1325830.59,0.00,'2021-03-25 16:02:06'),(611491,'5','173',400,'Sale Id shift 186913',0.00,1133946.99,163.00,1133946.99,0.00,'2021-03-26 19:23:29'),(615123,'5','173',400,'Sale Id shift 186968',0.00,1034627.83,163.00,1034627.83,0.00,'2021-03-28 09:04:58'),(616637,'5','173',400,'Sale Id shift 187227',0.00,1193415.91,163.00,1193415.91,0.00,'2021-03-28 13:59:17'),(619461,'5','173',400,'Sale Id shift 187326',0.00,1308599.86,163.00,1308599.86,0.00,'2021-03-29 13:29:55'),(624008,'5','173',400,'Sale Id shift 187510',0.00,1187909.77,163.00,1187909.77,0.00,'2021-03-30 16:31:37'),(624507,'5','173',400,'Sale Id shift 187773',0.00,940994.11,163.00,940994.11,0.00,'2021-03-31 05:48:24'),(628027,'5','173',400,'Sale Id shift 187916',0.00,1053705.35,163.00,1053705.35,0.00,'2021-03-31 20:18:54'),(632378,'5','173',400,'Sale Id shift 188002',0.00,1393635.33,163.00,1393635.33,0.00,'2021-04-02 06:50:15'),(636293,'5','173',400,'Sale Id shift 188231',0.00,1508049.92,163.00,1508049.92,0.00,'2021-04-03 06:14:27'),(642007,'5','173',400,'Sale Id shift 188649',0.00,1632004.90,163.00,1632004.90,0.00,'2021-04-04 15:32:21'),(642008,'5','173',401,'Sale Id shift 188649',0.00,381721.90,265.00,381721.90,0.00,'2021-04-04 15:32:21'),(643088,'5','173',400,'Sale Id shift 188726',0.00,1250345.29,163.00,1250345.29,0.00,'2021-04-05 07:39:32'),(643089,'5','173',401,'Sale Id shift 188726',0.00,169234.30,265.00,169234.30,0.00,'2021-04-05 07:39:32'),(647146,'5','173',400,'Sale Id shift 188828',0.00,907574.22,163.00,907574.22,0.00,'2021-04-06 09:39:10'),(647147,'5','173',401,'Sale Id shift 188828',0.00,44382.20,265.00,44382.20,0.00,'2021-04-06 09:39:10'),(649670,'5','173',400,'Sale Id shift 189075',0.00,754424.31,163.00,754424.31,0.00,'2021-04-07 07:06:30'),(649671,'5','173',401,'Sale Id shift 189075',0.00,39718.20,265.00,39718.20,0.00,'2021-04-07 07:06:30'),(653062,'5','173',400,'Sale Id shift 189262',0.00,595698.17,0.00,0.00,-595698.17,'2021-04-07 21:38:11'),(653063,'5','173',401,'Sale Id shift 189262',0.00,117116.75,0.00,0.00,-117116.75,'2021-04-07 21:38:11'),(656805,'5','173',401,'Sale Id shift 189565',0.00,53227.90,265.00,53227.90,0.00,'2021-04-09 08:12:11'),(660437,'5','173',401,'Sale Id shift 189697',0.00,201930.00,265.00,201930.00,0.00,'2021-04-10 08:24:57'),(664550,'5','173',401,'Sale Id shift 189856',0.00,46157.70,265.00,46157.70,0.00,'2021-04-11 09:22:50'),(668872,'5','173',401,'Sale Id shift 190153',0.00,71663.95,265.00,71663.95,0.00,'2021-04-12 10:04:07'),(672550,'5','173',401,'Sale Id shift 190277',0.00,40764.95,265.00,40764.95,0.00,'2021-04-13 07:37:47'),(677658,'5','173',401,'Sale Id shift 190453',0.00,33397.95,265.00,33397.95,0.00,'2021-04-14 07:52:59'),(681709,'5','173',401,'Sale Id shift 190700',0.00,43881.35,265.00,43881.35,0.00,'2021-04-15 08:24:27'),(685268,'5','173',401,'Sale Id shift 190969',0.00,39010.65,265.00,39010.65,0.00,'2021-04-16 08:39:55'),(689549,'5','173',401,'Sale Id shift 191145',0.00,45315.00,265.00,45315.00,0.00,'2021-04-17 12:37:26'),(692048,'5','173',401,'Sale Id shift 191410',0.00,72246.95,265.00,72246.95,0.00,'2021-04-18 10:21:52'),(695462,'5','173',401,'Sale Id shift 191569',0.00,318956.65,265.00,318956.65,0.00,'2021-04-19 09:37:33'),(698823,'5','173',401,'Sale Id shift 191836',0.00,113282.20,265.00,113282.20,0.00,'2021-04-20 09:03:39'),(701736,'5','173',401,'Sale Id shift 191988',0.00,54325.00,265.00,54325.00,0.00,'2021-04-21 10:45:03'),(703916,'5','173',401,'Sale Id shift 192226',0.00,58501.40,265.00,58501.40,0.00,'2021-04-22 08:14:10'),(707268,'5','173',401,'Sale Id shift 192406',0.00,53482.30,265.00,53482.30,0.00,'2021-04-23 09:25:34'),(709908,'5','173',401,'Sale Id shift 192613',0.00,70225.00,265.00,70225.00,0.00,'2021-04-24 08:58:24'),(725753,'5','173',401,'Sale Id shift 193941',0.00,61215.00,265.00,61215.00,0.00,'2021-04-29 10:43:08'),(725817,'5','173',401,'Sale Id shift 193945',0.00,101643.40,265.00,101643.40,0.00,'2021-04-29 10:55:53'),(725901,'5','173',401,'Sale Id shift 193950',0.00,65720.00,265.00,65720.00,0.00,'2021-04-29 11:10:50'),(725946,'5','173',401,'Sale Id shift 193958',0.00,64066.40,265.00,64066.40,0.00,'2021-04-29 11:19:25'),(726045,'5','173',401,'Sale Id shift 193963',0.00,42665.00,265.00,42665.00,0.00,'2021-04-29 11:39:43'),(731649,'5','173',401,'Sale Id shift 194197',0.00,82521.00,265.00,82521.00,0.00,'2021-05-01 10:58:36'),(731736,'5','173',401,'Sale Id shift 194378',0.00,110968.75,265.00,110968.75,0.00,'2021-05-01 11:19:15'),(737459,'5','173',401,'Sale Id shift 194379',0.00,126362.60,265.00,126362.60,0.00,'2021-05-03 08:36:53'),(740804,'5','173',400,'Sale Id shift 194734',0.00,91235.10,165.00,91235.10,0.00,'2021-05-04 11:20:53'),(740805,'5','173',401,'Sale Id shift 194734',0.00,198220.00,265.00,198220.00,0.00,'2021-05-04 11:20:53'),(741980,'5','173',400,'Sale Id shift 195005',0.00,338913.30,165.00,338913.30,0.00,'2021-05-04 15:46:33'),(741981,'5','173',401,'Sale Id shift 195005',0.00,175962.65,265.00,175962.65,0.00,'2021-05-04 15:46:33'),(746556,'5','173',400,'Sale Id shift 195015',0.00,416050.80,165.00,416050.80,0.00,'2021-05-06 09:09:18'),(746557,'5','173',401,'Sale Id shift 195015',0.00,29966.20,265.00,29966.20,0.00,'2021-05-06 09:09:18'),(747269,'5','173',400,'Sale Id shift 195357',0.00,454436.40,165.00,454436.40,0.00,'2021-05-06 12:06:23'),(747270,'5','173',401,'Sale Id shift 195357',0.00,52644.90,265.00,52644.90,0.00,'2021-05-06 12:06:23'),(751718,'5','173',400,'Sale Id shift 195416',0.00,471913.20,165.00,471913.20,0.00,'2021-05-07 16:11:47'),(751719,'5','173',401,'Sale Id shift 195416',0.00,69907.00,265.00,69907.00,0.00,'2021-05-07 16:11:47'),(754144,'5','173',400,'Sale Id shift 195767',0.00,537875.25,165.00,537875.25,0.00,'2021-05-08 12:02:23'),(754145,'5','173',401,'Sale Id shift 195767',0.00,343047.80,265.00,343047.80,0.00,'2021-05-08 12:02:23'),(756869,'5','173',400,'Sale Id shift 195878',0.00,536980.95,165.00,536980.95,0.00,'2021-05-09 10:13:51'),(756870,'5','173',401,'Sale Id shift 195878',0.00,58880.35,265.00,58880.35,0.00,'2021-05-09 10:13:51'),(762520,'5','173',400,'Sale Id shift 196092',0.00,486490.95,165.00,486490.95,0.00,'2021-05-10 17:28:30'),(762521,'5','173',401,'Sale Id shift 196092',0.00,19069.40,265.00,19069.40,0.00,'2021-05-10 17:28:30'),(764957,'5','173',400,'Sale Id shift 196408',0.00,611146.80,165.00,611146.80,0.00,'2021-05-11 14:26:14'),(764958,'5','173',401,'Sale Id shift 196408',0.00,17153.45,265.00,17153.45,0.00,'2021-05-11 14:26:14'),(768929,'5','173',400,'Sale Id shift 196592',0.00,490492.20,165.00,490492.20,0.00,'2021-05-12 15:42:28'),(768930,'5','173',401,'Sale Id shift 196592',0.00,7563.10,265.00,7563.10,0.00,'2021-05-12 15:42:28'),(770341,'5','173',400,'Sale Id shift 196813',0.00,352844.25,165.00,352844.25,0.00,'2021-05-13 12:27:10'),(770342,'5','173',401,'Sale Id shift 196813',0.00,11315.50,265.00,11315.50,0.00,'2021-05-13 12:27:10'),(773668,'5','173',400,'Sale Id shift 196935',0.00,208461.00,165.00,208461.00,0.00,'2021-05-14 21:38:49'),(773669,'5','173',401,'Sale Id shift 196935',0.00,2713.60,265.00,2713.60,0.00,'2021-05-14 21:38:49'),(775881,'5','173',400,'Sale Id shift 197652',0.00,272566.80,165.00,272566.80,0.00,'2021-05-17 11:31:50'),(775882,'5','173',401,'Sale Id shift 197652',0.00,6852.90,265.00,6852.90,0.00,'2021-05-17 11:31:50'),(775933,'5','173',400,'Sale Id shift 197654',0.00,397752.30,165.00,397752.30,0.00,'2021-05-17 11:43:55'),(775934,'5','173',401,'Sale Id shift 197654',0.00,21075.45,265.00,21075.45,0.00,'2021-05-17 11:43:55'),(775954,'5','173',400,'Sale Id shift 197662',0.00,481577.25,165.00,481577.25,0.00,'2021-05-17 11:49:51'),(775955,'5','173',401,'Sale Id shift 197662',0.00,18960.75,265.00,18960.75,0.00,'2021-05-17 11:49:51'),(778584,'5','173',400,'Sale Id shift 197668',0.00,463547.70,165.00,463547.70,0.00,'2021-05-18 11:46:39'),(778585,'5','173',401,'Sale Id shift 197668',0.00,55721.55,265.00,55721.55,0.00,'2021-05-18 11:46:39'),(781667,'5','173',400,'Sale Id shift 197989',0.00,443586.00,165.00,443586.00,0.00,'2021-05-19 12:03:33'),(781668,'5','173',401,'Sale Id shift 197989',0.00,46245.15,270.00,47117.70,872.55,'2021-05-19 12:03:33'),(784443,'5','173',400,'Sale Id shift 198228',0.00,231000.00,165.00,231000.00,0.00,'2021-05-20 10:50:00'),(784444,'5','173',401,'Sale Id shift 198228',0.00,2650.00,270.00,2700.00,50.00,'2021-05-20 10:50:00'),(789117,'5','173',401,'Sale Id shift 198432',0.00,10698.05,270.00,10899.90,201.85,'2021-05-21 16:13:17'),(794879,'5','173',400,'Sale Id shift 198720',0.00,155583.45,165.00,155583.45,0.00,'2021-05-23 10:07:19'),(794880,'5','173',401,'Sale Id shift 198720',0.00,296786.75,265.00,296786.75,0.00,'2021-05-23 10:07:19'),(795065,'5','173',400,'Sale Id shift 199047',0.00,337791.30,165.00,337791.30,0.00,'2021-05-23 10:44:27'),(795066,'5','173',401,'Sale Id shift 199047',0.00,19321.15,270.00,19685.70,364.55,'2021-05-23 10:44:27'),(797543,'5','173',400,'Sale Id shift 199067',0.00,358482.30,165.00,358482.30,0.00,'2021-05-24 07:54:33'),(797544,'5','173',401,'Sale Id shift 199067',0.00,10761.65,270.00,10964.70,203.05,'2021-05-24 07:54:33'),(801162,'5','173',400,'Sale Id shift 199255',0.00,132000.00,165.00,132000.00,0.00,'2021-05-25 09:29:12'),(801207,'5','173',400,'Sale Id shift 199511',0.00,106738.50,163.00,105444.70,-1293.80,'2021-05-25 09:40:37'),(801208,'5','173',401,'Sale Id shift 199511',0.00,26971.70,270.00,27480.60,508.90,'2021-05-25 09:40:37'),(804846,'5','173',400,'Sale Id shift 199516',0.00,282714.30,163.00,279287.46,-3426.84,'2021-05-26 10:16:34'),(804847,'5','173',401,'Sale Id shift 199516',0.00,23346.50,270.00,23787.00,440.50,'2021-05-26 10:16:34'),(807747,'5','173',400,'Sale Id shift 199765',0.00,223014.00,165.00,223014.00,0.00,'2021-05-27 08:48:37'),(807748,'5','173',401,'Sale Id shift 199765',0.00,11694.45,270.00,11915.10,220.65,'2021-05-27 08:48:37'),(812870,'5','173',400,'Sale Id shift 199960',0.00,347298.60,163.00,343088.92,-4209.68,'2021-05-28 15:57:59'),(812871,'5','173',401,'Sale Id shift 199960',0.00,4245.30,270.00,4325.40,80.10,'2021-05-28 15:57:59'),(817882,'5','173',400,'Sale Id shift 200536',0.00,366908.85,163.00,362461.47,-4447.38,'2021-05-30 09:32:26'),(817883,'5','173',401,'Sale Id shift 200536',0.00,47652.30,270.00,48551.40,899.10,'2021-05-30 09:32:26'),(818219,'5','173',400,'Sale Id shift 200554',0.00,369713.85,163.00,365232.47,-4481.38,'2021-05-30 10:32:39'),(818220,'5','173',401,'Sale Id shift 200554',0.00,320098.80,270.00,326138.40,6039.60,'2021-05-30 10:32:39'),(821852,'5','173',400,'Sale Id shift 200558',0.00,408198.45,163.00,403250.59,-4947.86,'2021-05-31 10:20:55'),(821853,'5','173',401,'Sale Id shift 200558',0.00,189999.70,270.00,193584.60,3584.90,'2021-05-31 10:20:55'),(826522,'5','173',400,'Sale Id shift 200831',0.00,381240.70,163.00,381240.70,0.00,'2021-06-01 14:04:13'),(826523,'5','173',401,'Sale Id shift 200831',0.00,202394.70,270.00,202394.70,0.00,'2021-06-01 14:04:13'),(829557,'5','173',400,'Sale Id shift 201050',0.00,331858.22,163.00,331858.22,0.00,'2021-06-02 09:16:10'),(829558,'5','173',401,'Sale Id shift 201050',0.00,107138.70,270.00,107138.70,0.00,'2021-06-02 09:16:10'),(833272,'5','173',400,'Sale Id shift 201171',0.00,332937.28,163.00,332937.28,0.00,'2021-06-03 08:40:38'),(833273,'5','173',401,'Sale Id shift 201171',0.00,39989.70,270.00,39989.70,0.00,'2021-06-03 08:40:38'),(839662,'5','173',400,'Sale Id shift 201380',0.00,184154.14,163.00,184154.14,0.00,'2021-06-04 16:36:00'),(839663,'5','173',401,'Sale Id shift 201380',0.00,12295.80,270.00,12295.80,0.00,'2021-06-04 16:36:00'),(840274,'5','173',400,'Sale Id shift 201746',0.00,80127.54,163.00,80127.54,0.00,'2021-06-05 07:44:31'),(840275,'5','173',401,'Sale Id shift 201746',0.00,1892.70,270.00,1892.70,0.00,'2021-06-05 07:44:31'),(847920,'5','173',400,'Sale Id shift 202187',0.00,328824.79,163.00,328824.79,0.00,'2021-06-06 20:44:30'),(847921,'5','173',401,'Sale Id shift 202187',0.00,173943.00,275.00,173943.00,0.00,'2021-06-06 20:44:30'),(847960,'5','173',400,'Sale Id shift 202188',0.00,376246.38,163.00,376246.38,0.00,'2021-06-07 05:27:48'),(847961,'5','173',401,'Sale Id shift 202188',0.00,316101.50,275.00,316101.50,0.00,'2021-06-07 05:27:48'),(852056,'5','173',400,'Sale Id shift 202238',0.00,409433.18,163.00,409433.18,0.00,'2021-06-08 05:48:31'),(852057,'5','173',401,'Sale Id shift 202238',0.00,312595.25,275.00,312595.25,0.00,'2021-06-08 05:48:31'),(855667,'5','173',400,'Sale Id shift 202624',0.00,404575.78,163.00,404575.78,0.00,'2021-06-08 23:00:57'),(855668,'5','173',401,'Sale Id shift 202624',0.00,52841.25,275.00,52841.25,0.00,'2021-06-08 23:00:57'),(859580,'5','173',400,'Sale Id shift 202638',0.00,375067.89,163.00,375067.89,0.00,'2021-06-09 22:16:16'),(859581,'5','173',401,'Sale Id shift 202638',0.00,312870.25,275.00,312870.25,0.00,'2021-06-09 22:16:16'),(863330,'5','173',400,'Sale Id shift 202851',0.00,402693.13,163.00,402693.13,0.00,'2021-06-11 06:00:14'),(863331,'5','173',401,'Sale Id shift 202851',0.00,160564.25,275.00,160564.25,0.00,'2021-06-11 06:00:14'),(867169,'5','173',400,'Sale Id shift 203111',0.00,450996.55,163.00,450996.55,0.00,'2021-06-11 20:45:32'),(867170,'5','173',401,'Sale Id shift 203111',0.00,367576.00,275.00,367576.00,0.00,'2021-06-11 20:45:32'),(870667,'5','173',400,'Sale Id shift 203316',0.00,467102.58,163.00,467102.58,0.00,'2021-06-13 05:52:52'),(870668,'5','173',401,'Sale Id shift 203316',0.00,46593.25,275.00,46593.25,0.00,'2021-06-13 05:52:52'),(875123,'5','173',400,'Sale Id shift 203562',0.00,313215.91,163.00,313215.91,0.00,'2021-06-14 07:28:23'),(875124,'5','173',401,'Sale Id shift 203562',0.00,118087.75,275.00,118087.75,0.00,'2021-06-14 07:28:23'),(878700,'5','173',400,'Sale Id shift 203752',0.00,306453.04,163.00,306453.04,0.00,'2021-06-15 06:08:37'),(878701,'5','173',401,'Sale Id shift 203752',0.00,12991.00,275.00,12991.00,0.00,'2021-06-15 06:08:37'),(882040,'5','173',400,'Sale Id shift 203971',0.00,238283.18,163.00,238283.18,0.00,'2021-06-16 07:01:22'),(882041,'5','173',401,'Sale Id shift 203971',0.00,10436.25,275.00,10436.25,0.00,'2021-06-16 07:01:22'),(885718,'5','173',400,'Sale Id shift 204218',0.00,221358.89,163.00,221358.89,0.00,'2021-06-17 06:17:57'),(885719,'5','173',401,'Sale Id shift 204218',0.00,2447.50,275.00,2447.50,0.00,'2021-06-17 06:17:57'),(889423,'5','173',400,'Sale Id shift 204411',0.00,341515.97,163.00,341515.97,0.00,'2021-06-17 21:49:44'),(889424,'5','173',401,'Sale Id shift 204411',0.00,5618.25,275.00,5618.25,0.00,'2021-06-17 21:49:44'),(893127,'5','173',400,'Sale Id shift 204619',0.00,373129.82,163.00,373129.82,0.00,'2021-06-19 06:12:04'),(893128,'5','173',401,'Sale Id shift 204619',0.00,332392.50,275.00,332392.50,0.00,'2021-06-19 06:12:04'),(896928,'5','173',400,'Sale Id shift 204872',0.00,385255.39,163.00,385255.39,0.00,'2021-06-20 07:05:12'),(896929,'5','173',401,'Sale Id shift 204872',0.00,223729.00,275.00,223729.00,0.00,'2021-06-20 07:05:12'),(900305,'5','173',400,'Sale Id shift 205221',0.00,277688.43,163.00,277688.43,0.00,'2021-06-21 05:50:13'),(900306,'5','173',401,'Sale Id shift 205221',0.00,41525.00,275.00,41525.00,0.00,'2021-06-21 05:50:13'),(903747,'5','173',400,'Sale Id shift 205231',0.00,285589.04,163.00,285589.04,0.00,'2021-06-22 07:39:59'),(903748,'5','173',401,'Sale Id shift 205231',0.00,2189.00,280.00,2228.80,39.80,'2021-06-22 07:39:59'),(906616,'5','173',400,'Sale Id shift 205526',0.00,292697.47,163.00,292697.47,0.00,'2021-06-23 06:24:38'),(906617,'5','173',401,'Sale Id shift 205526',0.00,46901.25,280.00,47754.00,852.75,'2021-06-23 06:24:38'),(910952,'5','173',400,'Sale Id shift 205991',0.00,313142.56,163.00,313142.56,0.00,'2021-06-24 09:20:31'),(910953,'5','173',401,'Sale Id shift 205991',0.00,24491.60,280.00,24491.60,0.00,'2021-06-24 09:20:31'),(913615,'5','173',400,'Sale Id shift 206003',0.00,194410.10,163.00,194410.10,0.00,'2021-06-24 21:45:18'),(913616,'5','173',401,'Sale Id shift 206003',0.00,31922.80,290.00,33062.90,1140.10,'2021-06-24 21:45:18'),(917061,'5','173',400,'Sale Id shift 206134',0.00,249182.99,163.00,249182.99,0.00,'2021-06-26 06:41:38'),(917062,'5','173',401,'Sale Id shift 206134',0.00,95620.00,290.00,99035.00,3415.00,'2021-06-26 06:41:38'),(921365,'5','173',400,'Sale Id shift 206401',0.00,312617.70,163.00,312617.70,0.00,'2021-06-27 09:17:33'),(921366,'5','173',401,'Sale Id shift 206401',0.00,6160.00,290.00,6380.00,220.00,'2021-06-27 09:17:33'),(924955,'5','173',400,'Sale Id shift 206657',0.00,274394.20,163.00,274394.20,0.00,'2021-06-28 08:37:42'),(924956,'5','173',401,'Sale Id shift 206657',0.00,8400.00,290.00,8700.00,300.00,'2021-06-28 08:37:42'),(928848,'5','173',400,'Sale Id shift 206881',0.00,257862.74,163.00,257862.74,0.00,'2021-06-29 08:38:50'),(928849,'5','173',401,'Sale Id shift 206881',0.00,9800.00,290.00,10150.00,350.00,'2021-06-29 08:38:50'),(932954,'5','173',400,'Sale Id shift 207086',0.00,265944.28,163.00,265944.28,0.00,'2021-06-30 09:37:40'),(932955,'5','173',401,'Sale Id shift 207086',0.00,2800.00,290.00,2900.00,100.00,'2021-06-30 09:37:40'),(936922,'5','173',400,'Sale Id shift 207357',0.00,237427.43,163.00,237427.43,0.00,'2021-07-01 08:24:43'),(936923,'5','173',401,'Sale Id shift 207357',0.00,2800.00,290.00,2900.00,100.00,'2021-07-01 08:24:43'),(940715,'5','173',400,'Sale Id shift 207592',0.00,245350.86,163.00,245350.86,0.00,'2021-07-02 07:26:14'),(940716,'5','173',401,'Sale Id shift 207592',0.00,36444.80,290.00,37746.40,1301.60,'2021-07-02 07:26:14'),(948097,'5','173',400,'Sale Id shift 207786',0.00,333282.84,163.00,333282.84,0.00,'2021-07-03 21:36:46'),(948098,'5','173',401,'Sale Id shift 207786',0.00,20316.80,290.00,21042.40,725.60,'2021-07-03 21:36:46'),(948845,'5','173',400,'Sale Id shift 208093',0.00,293960.72,163.00,293960.72,0.00,'2021-07-04 09:03:07'),(952257,'5','173',400,'Sale Id shift 208177',0.00,315590.82,163.00,315590.82,0.00,'2021-07-05 05:28:34'),(956355,'5','173',400,'Sale Id shift 208502',0.00,394730.58,163.00,394730.58,0.00,'2021-07-05 22:06:56'),(960381,'5','173',400,'Sale Id shift 208639',0.00,289483.11,163.00,289483.11,0.00,'2021-07-07 06:10:56'),(964547,'5','173',400,'Sale Id shift 208878',0.00,267531.90,163.00,267531.90,0.00,'2021-07-08 06:39:16'),(968876,'5','173',400,'Sale Id shift 209024',0.00,360053.96,163.00,360053.96,0.00,'2021-07-09 08:03:35'),(972924,'5','173',400,'Sale Id shift 209421',0.00,273709.60,163.00,273709.60,0.00,'2021-07-10 08:03:02'),(972925,'5','173',401,'Sale Id shift 209421',0.00,23522.80,290.00,24362.90,840.10,'2021-07-10 08:03:02'),(976900,'5','173',400,'Sale Id shift 209536',0.00,300643.72,163.00,300643.72,0.00,'2021-07-10 22:28:36'),(980991,'5','173',400,'Sale Id shift 209841',0.00,365478.60,163.00,365478.60,0.00,'2021-07-11 20:31:28'),(984223,'5','173',400,'Sale Id shift 209952',0.00,319603.88,163.00,319603.88,0.00,'2021-07-12 20:29:21'),(989104,'5','173',400,'Sale Id shift 210135',0.00,286765.90,163.00,286765.90,0.00,'2021-07-14 09:51:06'),(991393,'5','173',400,'Sale Id shift 210410',0.00,273548.23,163.00,273548.23,0.00,'2021-07-14 20:52:39'),(994526,'5','173',400,'Sale Id shift 210508',0.00,295176.70,163.00,295176.70,0.00,'2021-07-15 22:24:06'),(999084,'5','173',400,'Sale Id shift 210750',0.00,228925.35,163.00,228925.35,0.00,'2021-07-17 09:19:03'),(1003109,'5','173',400,'Sale Id shift 211027',0.00,365758.96,163.00,365758.96,0.00,'2021-07-18 08:54:55'),(1006214,'5','173',400,'Sale Id shift 211240',0.00,410148.75,163.00,410148.75,0.00,'2021-07-18 20:15:29'),(1010943,'5','173',400,'Sale Id shift 211419',0.00,300255.78,163.00,300255.78,0.00,'2021-07-20 11:27:53'),(1015107,'5','173',400,'Sale Id shift 211764',0.00,142973.82,163.00,142973.82,0.00,'2021-07-21 14:41:57'),(1016670,'5','173',400,'Sale Id shift 211974',0.00,178509.45,163.00,178509.45,0.00,'2021-07-22 09:05:42'),(1019802,'5','173',400,'Sale Id shift 212139',0.00,254263.70,163.00,254263.70,0.00,'2021-07-23 09:16:54'),(1028830,'5','173',400,'Sale Id shift 212360',0.00,235732.23,163.00,235732.23,0.00,'2021-07-25 18:45:04'),(1028841,'5','173',400,'Sale Id shift 212828',0.00,243024.85,163.00,243024.85,0.00,'2021-07-25 19:04:34'),(1028854,'5','173',400,'Sale Id shift 212832',0.00,244500.00,163.00,244500.00,0.00,'2021-07-25 19:26:06'),(1032159,'5','173',400,'Sale Id shift 213110',0.00,187450.00,163.00,187450.00,0.00,'2021-07-27 06:25:53'),(1045072,'5','173',400,'Sale Id shift 213981',0.00,192918.65,162.00,191735.10,-1183.55,'2021-07-30 11:32:27'),(1054222,'5','173',400,'Sale Id shift 214239',0.00,430011.18,162.00,430011.18,0.00,'2021-08-01 14:37:54'),(1054376,'5','173',400,'Sale Id shift 214464',0.00,275796.90,162.00,275796.90,0.00,'2021-08-01 15:09:44'),(1056436,'5','173',400,'Sale Id shift 214547',0.00,290208.42,162.00,290208.42,0.00,'2021-08-02 10:08:33'),(1062419,'5','173',400,'Sale Id shift 214916',0.00,246032.64,162.00,246032.64,0.00,'2021-08-03 14:41:14'),(1065199,'5','173',400,'Sale Id shift 214939',0.00,255867.66,162.00,255867.66,0.00,'2021-08-04 10:39:52'),(1068052,'5','173',400,'Sale Id shift 215277',0.00,237407.76,162.00,237407.76,0.00,'2021-08-05 09:23:04'),(1071226,'5','173',400,'Sale Id shift 215282',0.00,262762.38,162.00,262762.38,0.00,'2021-08-06 08:00:36'),(1075418,'5','173',400,'Sale Id shift 215476',0.00,342727.20,162.00,342727.20,0.00,'2021-08-07 08:50:17'),(1079109,'5','173',400,'Sale Id shift 215783',0.00,295217.46,162.00,295217.46,0.00,'2021-08-08 07:38:28'),(1083062,'5','173',400,'Sale Id shift 215983',0.00,330847.74,162.00,330847.74,0.00,'2021-08-09 08:02:05'),(1086703,'5','173',400,'Sale Id shift 216156',0.00,313377.66,162.00,313377.66,0.00,'2021-08-10 06:23:42'),(1090955,'5','173',400,'Sale Id shift 216361',0.00,283253.76,162.00,283253.76,0.00,'2021-08-11 08:14:36'),(1093613,'5','173',400,'Sale Id shift 216599',0.00,344855.88,162.00,344855.88,0.00,'2021-08-11 22:05:06'),(1097477,'5','173',400,'Sale Id shift 216862',0.00,250800.30,162.00,250800.30,0.00,'2021-08-13 08:04:31'),(1101891,'5','173',400,'Sale Id shift 217112',0.00,250349.94,162.00,250349.94,0.00,'2021-08-14 08:14:51'),(1109716,'5','173',400,'Sale Id shift 217318',0.00,305420.22,162.00,305420.22,0.00,'2021-08-15 19:52:44'),(1110236,'5','173',400,'Sale Id shift 217672',0.00,20389.32,162.00,20389.32,0.00,'2021-08-16 07:55:49'),(1114321,'5','173',400,'Sale Id shift 217943',0.00,61200.36,162.00,61200.36,0.00,'2021-08-17 08:47:41'),(1118184,'5','173',400,'Sale Id shift 218036',0.00,53659.26,162.00,53659.26,0.00,'2021-08-18 08:26:48'),(1121068,'5','173',400,'Sale Id shift 218359',0.00,65263.32,162.00,65263.32,0.00,'2021-08-19 05:41:57'),(1125320,'5','173',400,'Sale Id shift 218480',0.00,143123.76,162.00,143123.76,0.00,'2021-08-20 06:50:17'),(1128838,'5','173',400,'Sale Id shift 218859',0.00,288167.22,162.00,288167.22,0.00,'2021-08-20 23:10:09'),(1133150,'5','173',400,'Sale Id shift 218929',0.00,328445.28,162.00,328445.28,0.00,'2021-08-21 23:06:23'),(1137263,'5','173',400,'Sale Id shift 219136',0.00,268297.92,162.00,268297.92,0.00,'2021-08-22 23:28:33'),(1141216,'5','173',400,'Sale Id shift 219342',0.00,309648.42,162.00,309648.42,0.00,'2021-08-23 22:03:13'),(1144988,'5','173',400,'Sale Id shift 219622',0.00,342306.00,162.00,342306.00,0.00,'2021-08-24 22:27:50'),(1149966,'5','173',400,'Sale Id shift 219871',0.00,125869.14,162.00,125869.14,0.00,'2021-08-26 09:37:09'),(1152478,'5','173',400,'Sale Id shift 220148',0.00,162061.56,162.00,162061.56,0.00,'2021-08-27 05:51:50'),(1156107,'5','173',400,'Sale Id shift 220379',0.00,90742.68,162.00,90742.68,0.00,'2021-08-28 07:05:12'),(1160044,'5','173',400,'Sale Id shift 220654',0.00,126034.38,162.00,126034.38,0.00,'2021-08-29 07:43:30'),(1164965,'5','173',400,'Sale Id shift 220867',0.00,138058.02,162.00,138058.02,0.00,'2021-08-30 09:16:40'),(1168425,'5','173',400,'Sale Id shift 221005',0.00,191488.86,162.00,191488.86,0.00,'2021-08-31 07:03:53'),(1172063,'5','173',400,'Sale Id shift 221220',0.00,286636.32,162.00,286636.32,0.00,'2021-09-01 05:29:22'),(1175976,'5','173',400,'Sale Id shift 221398',0.00,264283.56,162.00,264283.56,0.00,'2021-09-02 06:40:42'),(1181033,'5','173',400,'Sale Id shift 221741',0.00,263967.66,162.00,263967.66,0.00,'2021-09-03 09:16:49'),(1184514,'5','173',400,'Sale Id shift 221971',0.00,186099.12,162.00,186099.12,0.00,'2021-09-04 07:09:58'),(1188513,'5','173',400,'Sale Id shift 222079',0.00,246870.18,162.00,246870.18,0.00,'2021-09-05 07:11:55'),(1192882,'5','173',400,'Sale Id shift 222307',0.00,128504.88,162.00,128504.88,0.00,'2021-09-06 08:36:01'),(1195376,'5','173',400,'Sale Id shift 222565',0.00,255138.66,162.00,255138.66,0.00,'2021-09-07 08:01:16'),(1196574,'5','173',400,'Sale Id shift 222790',0.00,227355.66,162.00,227355.66,0.00,'2021-09-08 05:56:57'),(1198502,'5','173',400,'Sale Id shift 222970',0.00,123884.64,162.00,123884.64,0.00,'2021-09-09 05:58:00'),(1202639,'5','173',400,'Sale Id shift 223225',0.00,133820.10,162.00,133820.10,0.00,'2021-09-10 08:59:24'),(1205342,'5','173',400,'Sale Id shift 223539',0.00,67301.28,162.00,67301.28,0.00,'2021-09-11 06:23:17'),(1246426,'5','173',400,'Sale Id shift 226444',0.00,61078.86,162.00,61078.86,0.00,'2021-09-23 07:14:57'),(1251165,'5','173',400,'Sale Id shift 226574',0.00,263557.80,162.00,263557.80,0.00,'2021-09-24 10:36:00'),(1254958,'5','173',400,'Sale Id shift 226870',0.00,306320.94,162.00,306320.94,0.00,'2021-09-25 12:27:51'),(1257073,'5','173',400,'Sale Id shift 227070',0.00,193314.60,162.00,193314.60,0.00,'2021-09-26 08:25:42'),(1260485,'5','173',400,'Sale Id shift 227234',0.00,214202.88,162.00,214202.88,0.00,'2021-09-27 09:33:16'),(1263455,'5','173',400,'Sale Id shift 227462',0.00,242475.12,162.00,242475.12,0.00,'2021-09-28 08:23:48'),(1266306,'5','173',400,'Sale Id shift 227687',0.00,202253.76,162.00,202253.76,0.00,'2021-09-29 08:30:24'),(1286914,'5','173',400,'Sale Id shift 227925',0.00,186735.78,162.00,186735.78,0.00,'2021-10-05 13:10:45'),(1372117,'5','173',400,'Sale Id shift 235144',0.00,124218.36,162.00,124218.36,0.00,'2021-10-31 10:33:22'),(1374744,'5','173',400,'Sale Id shift 235685',0.00,32400.00,162.00,32400.00,0.00,'2021-11-01 08:47:10'),(1380723,'5','173',400,'Sale Id shift 236357',0.00,48600.00,162.00,48600.00,0.00,'2021-11-03 10:48:36'),(1380748,'5','173',400,'Sale Id shift 236359',0.00,196656.66,162.00,196656.66,0.00,'2021-11-03 10:55:40'),(1409070,'5','173',400,'Sale Id shift 236360',0.00,229524.84,162.00,229524.84,0.00,'2021-11-09 12:57:00'),(1409105,'5','173',400,'Sale Id shift 237730',0.00,172261.08,165.00,175451.10,3190.02,'2021-11-09 13:03:10'),(1409178,'5','173',400,'Sale Id shift 237733',0.00,438420.60,165.00,446539.50,8118.90,'2021-11-09 13:17:56'),(1409264,'5','173',400,'Sale Id shift 237741',0.00,177633.00,165.00,180922.50,3289.50,'2021-11-09 13:34:07'),(1409304,'5','173',400,'Sale Id shift 237743',0.00,191027.16,165.00,194564.70,3537.54,'2021-11-09 13:40:55'),(1409350,'5','173',400,'Sale Id shift 237746',0.00,168037.74,165.00,171149.55,3111.81,'2021-11-09 13:48:30'),(1409374,'5','173',400,'Sale Id shift 237747',0.00,171640.62,165.00,174819.15,3178.53,'2021-11-09 13:51:32'),(1409396,'5','173',400,'Sale Id shift 237748',0.00,241554.96,165.00,246028.20,4473.24,'2021-11-09 13:55:48'),(1409414,'5','173',400,'Sale Id shift 237751',0.00,287914.50,165.00,293246.25,5331.75,'2021-11-09 13:59:41'),(1409452,'5','173',400,'Sale Id shift 237752',0.00,285165.36,165.00,290446.20,5280.84,'2021-11-09 14:04:58'),(1409482,'5','173',400,'Sale Id shift 237754',0.00,262459.44,165.00,267319.80,4860.36,'2021-11-09 14:09:12'),(1409508,'5','173',400,'Sale Id shift 237757',0.00,154003.68,165.00,156855.60,2851.92,'2021-11-09 14:12:24'),(1409534,'5','173',400,'Sale Id shift 237759',0.00,189540.00,165.00,193050.00,3510.00,'2021-11-09 14:15:13'),(1409550,'5','173',400,'Sale Id shift 237761',0.00,86480.46,165.00,88081.95,1601.49,'2021-11-09 14:17:31'),(1484261,'5','173',400,'Sale Id shift 240341',0.00,354982.50,165.00,361556.25,6573.75,'2021-11-26 08:27:05'),(1488302,'5','173',400,'Sale Id shift 241811',0.00,267149.85,165.00,267149.85,0.00,'2021-11-27 07:56:51'),(1495646,'5','173',400,'Sale Id shift 242198',0.00,505399.95,165.00,505399.95,0.00,'2021-11-28 13:43:24'),(1500378,'5','173',400,'Sale Id shift 242461',0.00,234493.05,165.00,234493.05,0.00,'2021-11-29 14:02:21'),(1503289,'5','173',400,'Sale Id shift 242614',0.00,227980.50,165.00,227980.50,0.00,'2021-11-30 08:47:16'),(1508078,'5','173',400,'Sale Id shift 242787',0.00,260904.60,165.00,260904.60,0.00,'2021-12-01 08:32:47'),(1600159,'5','173',400,'Sale Id shift 247018',0.00,296142.00,165.00,296142.00,0.00,'2021-12-19 07:54:34'),(1606778,'5','173',400,'Sale Id shift 247308',0.00,341612.70,165.00,341612.70,0.00,'2021-12-20 11:04:54'),(1607336,'5','173',400,'Sale Id shift 247501',0.00,279123.90,165.00,279123.90,0.00,'2021-12-20 12:11:32'),(1607380,'5','173',400,'Sale Id shift 247509',0.00,227975.55,165.00,227975.55,0.00,'2021-12-20 12:17:14'),(1607450,'5','173',400,'Sale Id shift 247511',0.00,261366.60,165.00,261366.60,0.00,'2021-12-20 12:28:16'),(1607492,'5','173',400,'Sale Id shift 247514',0.00,274074.90,165.00,274074.90,0.00,'2021-12-20 12:33:55'),(1607543,'5','173',400,'Sale Id shift 247515',0.00,249085.65,165.00,249085.65,0.00,'2021-12-20 12:40:17'),(1607571,'5','173',400,'Sale Id shift 247516',0.00,350265.30,165.00,350265.30,0.00,'2021-12-20 12:43:11'),(1607589,'5','173',400,'Sale Id shift 247517',0.00,255179.10,165.00,255179.10,0.00,'2021-12-20 12:45:00'),(1607615,'5','173',400,'Sale Id shift 247519',0.00,261975.45,165.00,261975.45,0.00,'2021-12-20 12:47:17'),(1607628,'5','173',400,'Sale Id shift 247521',0.00,271849.05,165.00,271849.05,0.00,'2021-12-20 12:50:20'),(1607660,'5','173',400,'Sale Id shift 247523',0.00,339198.75,165.00,339198.75,0.00,'2021-12-20 12:53:22'),(1607673,'5','173',400,'Sale Id shift 247524',0.00,236426.85,165.00,236426.85,0.00,'2021-12-20 12:55:16'),(1607685,'5','173',400,'Sale Id shift 247527',0.00,290583.15,165.00,290583.15,0.00,'2021-12-20 12:57:03'),(1607712,'5','173',400,'Sale Id shift 247528',0.00,238956.30,165.00,238956.30,0.00,'2021-12-20 13:00:08'),(1607731,'5','173',400,'Sale Id shift 247529',0.00,244508.55,165.00,244508.55,0.00,'2021-12-20 13:02:16'),(1607749,'5','173',400,'Sale Id shift 247531',0.00,76858.65,165.00,76858.65,0.00,'2021-12-20 13:05:18'),(1626403,'5','173',400,'Sale Id shift 248027',0.00,481953.45,165.00,481953.45,0.00,'2021-12-23 18:06:48'),(1627570,'5','173',400,'Sale Id shift 248351',0.00,644204.55,165.00,644204.55,0.00,'2021-12-24 08:11:50'),(1636735,'5','173',400,'Sale Id shift 248504',0.00,410450.70,165.00,410450.70,0.00,'2021-12-25 14:08:28'),(1644469,'5','173',400,'Sale Id shift 248814',0.00,466158.00,165.00,466158.00,0.00,'2021-12-27 12:17:59'),(1646316,'5','173',400,'Sale Id shift 249241',0.00,318542.40,165.00,318542.40,0.00,'2021-12-27 18:20:36'),(1719956,'5','173',400,'Sale Id shift 252595',0.00,1225986.30,165.00,1225986.30,0.00,'2022-01-11 10:06:33'),(1721953,'5','173',400,'Sale Id shift 252814',0.00,732446.55,165.00,732446.55,0.00,'2022-01-11 15:00:50'),(1729855,'5','173',400,'Sale Id shift 252903',0.00,765666.00,165.00,765666.00,0.00,'2022-01-13 09:12:28'),(1730885,'5','173',400,'Sale Id shift 253311',0.00,620733.30,165.00,620733.30,0.00,'2022-01-13 11:17:28'),(1735301,'5','173',400,'Sale Id shift 253414',0.00,362970.30,165.00,362970.30,0.00,'2022-01-14 09:53:24'),(1740771,'5','173',400,'Sale Id shift 253560',0.00,260848.50,165.00,260848.50,0.00,'2022-01-15 10:55:54'),(1750471,'5','173',400,'Sale Id shift 253814',0.00,85800.00,165.00,85800.00,0.00,'2022-01-17 09:14:18'),(1755366,'5','173',400,'Sale Id shift 254377',0.00,167479.95,165.00,167479.95,0.00,'2022-01-17 21:24:01'),(1775006,'5','173',400,'Sale Id shift 255020',0.00,107664.15,165.00,107664.15,0.00,'2022-01-21 09:58:56'),(1786312,'5','173',400,'Sale Id shift 255301',0.00,505696.95,165.00,505696.95,0.00,'2022-01-23 09:04:13'),(1789775,'5','173',400,'Sale Id shift 255754',0.00,501502.65,165.00,501502.65,0.00,'2022-01-23 16:28:50'),(1797342,'5','173',400,'Sale Id shift 255906',0.00,256588.20,165.00,256588.20,0.00,'2022-01-25 09:11:10'),(1800284,'5','173',400,'Sale Id shift 256342',0.00,380285.40,165.00,380285.40,0.00,'2022-01-25 15:22:29'),(1803240,'5','173',400,'Sale Id shift 256381',0.00,342985.50,165.00,342985.50,0.00,'2022-01-26 09:04:46'),(1808614,'5','173',400,'Sale Id shift 256590',0.00,198052.80,165.00,198052.80,0.00,'2022-01-27 10:04:50'),(1808615,'5','173',400,'Sale Id shift 257662',0.00,249438.75,165.00,249438.75,0.00,'2022-02-04 09:24:35'),(1808616,'5','173',400,'Sale Id shift 257663',0.00,268804.80,165.00,268804.80,0.00,'2022-02-06 05:27:06'),(1808617,'5','173',400,'Sale Id shift 257664',0.00,722221.50,165.00,722221.50,0.00,'2022-02-06 20:23:14'),(1808618,'5','173',400,'Sale Id shift 257666',0.00,1024310.10,165.00,1024310.10,0.00,'2022-02-06 21:12:12'),(1808619,'5','173',400,'Sale Id shift 257667',0.00,626184.90,165.00,626184.90,0.00,'2022-02-07 15:48:33'),(1808620,'5','173',400,'Sale Id shift 257668',0.00,1410065.25,165.00,1410065.25,0.00,'2022-02-09 09:12:41'),(1808621,'5','173',400,'Sale Id shift 257669',0.00,1021909.35,165.00,1021909.35,0.00,'2022-02-09 15:26:19'),(1808622,'5','173',400,'Sale Id shift 257670',0.00,1675180.65,165.00,1675180.65,0.00,'2022-02-10 14:18:46'),(1808623,'5','173',400,'Sale Id shift 257671',0.00,2036639.55,165.00,2036639.55,0.00,'2022-02-11 09:47:07'),(1808624,'5','173',400,'Sale Id shift 257672',0.00,1061346.00,165.00,1061346.00,0.00,'2022-02-12 08:48:31'),(1808625,'5','173',400,'Sale Id shift 257673',0.00,1140907.35,165.00,1140907.35,0.00,'2022-02-13 09:05:03'),(1808626,'5','173',400,'Sale Id shift 257674',0.00,819510.45,165.00,819510.45,0.00,'2022-02-14 09:00:52'),(1808627,'5','173',400,'Sale Id shift 257675',0.00,370613.10,165.00,370613.10,0.00,'2022-02-15 16:50:13'),(1808628,'5','173',400,'Sale Id shift 257678',0.00,264298.65,165.00,264298.65,0.00,'2022-02-20 08:52:09'),(1808629,'5','173',400,'Sale Id shift 257679',0.00,960262.05,165.00,960262.05,0.00,'2022-02-20 11:50:16'),(1808630,'5','173',400,'Sale Id shift 257680',0.00,767872.05,165.00,767872.05,0.00,'2022-02-20 13:54:56'),(1808631,'5','173',400,'Sale Id shift 257681',0.00,710993.25,165.00,710993.25,0.00,'2022-02-21 10:00:21'),(1808632,'5','173',400,'Sale Id shift 257685',0.00,1245857.25,165.00,1245857.25,0.00,'2022-02-27 09:06:20'),(1808633,'5','173',400,'Sale Id shift 257686',0.00,1651610.40,165.00,1651610.40,0.00,'2022-02-27 13:44:19'),(1808634,'5','173',400,'Sale Id shift 257687',0.00,332512.95,165.00,332512.95,0.00,'2022-02-28 12:44:26'),(1808635,'5','173',400,'Sale Id shift 257688',0.00,2580494.40,165.00,2580494.40,0.00,'2022-02-28 15:54:54'),(1808636,'5','173',400,'Sale Id shift 257689',0.00,2023093.05,165.00,2023093.05,0.00,'2022-03-02 09:53:19'),(1808637,'5','173',400,'Sale Id shift 257690',0.00,380787.00,165.00,380787.00,0.00,'2022-03-03 10:25:28'),(1808638,'5','173',400,'Sale Id shift 257691',0.00,462000.00,165.00,462000.00,0.00,'2022-03-03 14:25:50'),(1808639,'5','173',400,'Sale Id shift 257698',0.00,1734428.85,165.00,1734428.85,0.00,'2022-03-13 18:57:55'),(1808640,'5','173',400,'Sale Id shift 257699',0.00,1805553.75,165.00,1805553.75,0.00,'2022-03-13 20:55:53'),(1808641,'5','173',400,'Sale Id shift 257700',0.00,4127663.10,165.00,4127663.10,0.00,'2022-03-14 09:18:33'),(1808642,'5','173',400,'Sale Id shift 257701',0.00,2600992.35,165.00,2600992.35,0.00,'2022-03-15 12:30:16'),(1808643,'5','173',400,'Sale Id shift 257702',0.00,1819478.10,165.00,1819478.10,0.00,'2022-03-15 13:38:47'),(1808644,'5','173',400,'Sale Id shift 257703',0.00,1023301.95,165.00,1023301.95,0.00,'2022-03-15 16:25:16'),(1808645,'5','173',400,'Sale Id shift 257704',0.00,912248.70,165.00,912248.70,0.00,'2022-03-16 11:43:15'),(1808646,'5','173',400,'Sale Id shift 257705',0.00,521119.50,165.00,521119.50,0.00,'2022-03-17 08:54:56'),(1808647,'5','173',400,'Sale Id shift 257740',0.00,107250.00,165.00,107250.00,0.00,'2022-04-23 09:14:24'),(1808648,'5','173',400,'Sale Id shift 257741',0.00,645646.65,165.00,645646.65,0.00,'2022-04-23 15:27:08'),(1808649,'5','173',400,'Sale Id shift 257742',0.00,822675.15,165.00,822675.15,0.00,'2022-04-23 21:09:11'),(1808650,'5','173',400,'Sale Id shift 257743',0.00,630009.60,165.00,630009.60,0.00,'2022-04-25 11:42:21'),(1808651,'5','173',400,'Sale Id shift 257744',0.00,643788.75,165.00,643788.75,0.00,'2022-04-25 13:45:05'),(1808652,'5','173',400,'Sale Id shift 257745',0.00,694503.15,165.00,694503.15,0.00,'2022-04-26 10:24:10'),(1808653,'5','173',400,'Sale Id shift 257746',0.00,691480.35,165.00,691480.35,0.00,'2022-04-27 10:20:31'),(1808654,'5','173',400,'Sale Id shift 257747',0.00,508541.55,165.00,508541.55,0.00,'2022-04-28 12:52:37'),(1808655,'5','173',400,'Sale Id shift 257748',0.00,635740.05,165.00,635740.05,0.00,'2022-04-29 10:13:20'),(1808656,'5','173',400,'Sale Id shift 257749',0.00,529245.75,165.00,529245.75,0.00,'2022-05-10 10:18:16'),(1808657,'5','173',400,'Sale Id shift 257750',0.00,447813.30,165.00,447813.30,0.00,'2022-05-10 10:21:16'),(1808658,'5','173',400,'Sale Id shift 257751',0.00,440365.20,165.00,440365.20,0.00,'2022-05-10 10:27:38'),(1808659,'5','173',400,'Sale Id shift 257752',0.00,300361.05,165.00,300361.05,0.00,'2022-05-10 10:31:51'),(1808660,'5','173',400,'Sale Id shift 257753',0.00,99003.30,165.00,99003.30,0.00,'2022-05-10 10:37:58'),(1808661,'5','173',400,'Sale Id shift 257760',0.00,92400.00,165.00,92400.00,0.00,'2022-05-11 09:40:22'),(1808662,'5','173',400,'Sale Id shift 257761',0.00,815463.00,165.00,815463.00,0.00,'2022-05-12 13:10:13'),(1808663,'5','173',400,'Sale Id shift 257762',0.00,834537.00,165.00,834537.00,0.00,'2022-05-13 11:35:04'),(1808664,'5','173',400,'Sale Id shift 257763',0.00,876443.70,165.00,876443.70,0.00,'2022-05-14 13:46:26'),(1808665,'5','173',400,'Sale Id shift 257764',0.00,773556.30,165.00,773556.30,0.00,'2022-05-16 10:05:04'),(1808666,'5','173',400,'Sale Id shift 257765',0.00,776384.40,165.00,776384.40,0.00,'2022-05-16 15:08:56'),(1808667,'5','173',400,'Sale Id shift 257766',0.00,646882.50,165.00,646882.50,0.00,'2022-05-17 09:04:33'),(1808668,'5','173',400,'Sale Id shift 257767',0.00,673101.00,165.00,673101.00,0.00,'2022-05-18 07:36:58'),(1808669,'5','173',400,'Sale Id shift 257768',0.00,685401.75,165.00,685401.75,0.00,'2022-05-19 08:21:39'),(1808670,'5','173',400,'Sale Id shift 257769',0.00,634596.60,165.00,634596.60,0.00,'2022-05-20 21:23:34'),(1808671,'5','173',400,'Sale Id shift 257770',0.00,485918.40,165.00,485918.40,0.00,'2022-05-22 08:12:21'),(1808672,'5','173',400,'Sale Id shift 257771',0.00,198024.75,165.00,198024.75,0.00,'2022-05-22 14:37:34'),(1808673,'5','173',400,'Sale Id shift 257784',0.00,486429.90,165.00,486429.90,0.00,'2022-06-04 15:42:43'),(1808674,'5','173',400,'Sale Id shift 257785',0.00,833566.80,165.00,833566.80,0.00,'2022-06-06 11:10:38'),(1808675,'5','173',400,'Sale Id shift 257786',0.00,775838.25,165.00,775838.25,0.00,'2022-06-06 12:03:38'),(1808676,'5','173',400,'Sale Id shift 257787',0.00,775839.90,165.00,775839.90,0.00,'2022-06-07 11:02:32'),(1808677,'5','173',400,'Sale Id shift 257788',0.00,1340090.40,165.00,1340090.40,0.00,'2022-06-08 15:30:23'),(1808678,'5','173',400,'Sale Id shift 257789',0.00,1188000.00,165.00,1188000.00,0.00,'2022-06-09 11:16:03'),(1808679,'5','173',400,'Sale Id shift 257790',0.00,908518.05,165.00,908518.05,0.00,'2022-06-10 15:28:31'),(1808680,'5','173',400,'Sale Id shift 257791',0.00,1084559.85,165.00,1084559.85,0.00,'2022-06-12 09:56:54'),(1808681,'5','173',400,'Sale Id shift 257792',0.00,854416.20,165.00,854416.20,0.00,'2022-06-12 14:10:19'),(1808682,'5','173',400,'Sale Id shift 257793',0.00,795582.15,165.00,795582.15,0.00,'2022-06-13 09:32:27'),(1808683,'5','173',400,'Sale Id shift 257794',0.00,826019.70,165.00,826019.70,0.00,'2022-06-14 11:02:26'),(1808684,'5','173',400,'Sale Id shift 257795',0.00,823980.30,165.00,823980.30,0.00,'2022-06-16 09:19:59'),(1808685,'5','173',400,'Sale Id shift 257796',0.00,673579.50,165.00,673579.50,0.00,'2022-06-17 09:58:06'),(1808686,'5','173',400,'Sale Id shift 257797',0.00,613915.50,165.00,613915.50,0.00,'2022-06-18 09:49:32'),(1808687,'5','173',400,'Sale Id shift 257798',0.00,570603.00,165.00,570603.00,0.00,'2022-06-19 09:35:14'),(1808688,'5','173',400,'Sale Id shift 257799',0.00,495808.50,165.00,495808.50,0.00,'2022-06-20 10:00:17'),(1808689,'5','173',400,'Sale Id shift 257800',0.00,482062.35,165.00,482062.35,0.00,'2022-06-21 09:57:46'),(1808690,'5','173',400,'Sale Id shift 257801',0.00,413061.00,165.00,413061.00,0.00,'2022-06-22 09:33:14'),(1808691,'5','173',400,'Sale Id shift 257802',0.00,265437.15,165.00,265437.15,0.00,'2022-06-22 14:33:15'),(1808692,'5','173',400,'Sale Id shift 257803',0.00,330178.20,165.00,330178.20,0.00,'2022-06-23 11:10:49'),(1808693,'5','173',400,'Sale Id shift 257825',0.00,129698.25,185.00,145419.25,15721.00,'2022-07-16 09:57:51'),(1808694,'5','173',400,'Sale Id shift 257826',0.00,821011.50,185.00,821011.50,0.00,'2022-07-17 09:22:05'),(1808695,'5','173',400,'Sale Id shift 257827',0.00,1028988.50,185.00,1028988.50,0.00,'2022-07-18 09:05:59'),(1808696,'5','173',400,'Sale Id shift 257828',0.00,1010146.25,185.00,1010146.25,0.00,'2022-07-19 09:42:43'),(1808697,'5','173',400,'Sale Id shift 257829',0.00,839853.75,186.00,844393.50,4539.75,'2022-07-20 14:03:57'),(1808698,'5','173',400,'Sale Id shift 257830',0.00,1000263.55,185.00,1000263.55,0.00,'2022-07-21 10:21:47'),(1808699,'5','173',400,'Sale Id shift 257831',0.00,757236.45,185.00,757236.45,0.00,'2022-07-22 09:54:30'),(1808700,'5','173',400,'Sale Id shift 257832',0.00,648049.45,185.00,648049.45,0.00,'2022-07-23 10:38:15'),(1808701,'5','173',400,'Sale Id shift 257833',0.00,554413.55,185.00,554413.55,0.00,'2022-07-24 09:32:06'),(1808702,'5','173',400,'Sale Id shift 257834',0.00,530063.85,185.00,530063.85,0.00,'2022-07-25 07:36:42'),(1808703,'5','173',400,'Sale Id shift 257835',0.00,508716.70,185.00,508716.70,0.00,'2022-07-26 09:23:00'),(1808704,'5','173',400,'Sale Id shift 257836',0.00,740719.65,185.00,740719.65,0.00,'2022-07-27 11:20:20'),(1808705,'5','173',400,'Sale Id shift 257837',0.00,556881.45,185.00,556881.45,0.00,'2022-07-28 09:28:44'),(1808706,'5','173',400,'Sale Id shift 257838',0.00,225994.15,185.00,225994.15,0.00,'2022-07-29 09:26:17'),(1808707,'5','173',400,'Sale Id shift 257846',0.00,222778.85,185.00,222778.85,0.00,'2022-08-06 09:00:05'),(1808708,'5','173',400,'Sale Id shift 257847',0.00,816684.35,185.00,816684.35,0.00,'2022-08-07 10:04:15'),(1808709,'5','173',400,'Sale Id shift 257848',0.00,906333.50,185.00,906333.50,0.00,'2022-09-03 09:37:23'),(1808710,'5','173',400,'Sale Id shift 257849',0.00,738150.00,185.00,738150.00,0.00,'2022-09-03 09:45:01'),(1808711,'5','173',400,'Sale Id shift 257850',0.00,518577.20,185.00,518577.20,0.00,'2022-09-03 09:47:04'),(1808712,'5','173',400,'Sale Id shift 257851',0.00,695703.60,185.00,695703.60,0.00,'2022-09-03 09:50:17'),(1808713,'5','173',400,'Sale Id shift 257852',0.00,444569.80,185.00,444569.80,0.00,'2022-09-03 09:54:38'),(1808714,'5','173',400,'Sale Id shift 257853',0.00,259592.00,185.00,259592.00,0.00,'2022-09-03 09:57:30'),(1808715,'5','173',400,'Sale Id shift 257854',0.00,878540.95,185.00,878540.95,0.00,'2022-09-03 10:04:54'),(1808716,'5','173',400,'Sale Id shift 257855',0.00,433220.05,185.00,433220.05,0.00,'2022-09-03 10:08:14'),(1808717,'5','173',400,'Sale Id shift 257856',0.00,871331.50,185.00,871331.50,0.00,'2022-09-03 10:15:33'),(1808718,'5','173',400,'Sale Id shift 257857',0.00,867727.70,185.00,867727.70,0.00,'2022-09-03 10:22:25'),(1808719,'5','173',400,'Sale Id shift 257858',0.00,783467.60,185.00,783467.60,0.00,'2022-09-03 10:35:08'),(1808720,'5','173',400,'Sale Id shift 257859',0.00,860272.20,185.00,860272.20,0.00,'2022-09-03 11:05:13'),(1808721,'5','173',400,'Sale Id shift 257860',0.00,917729.50,185.00,917729.50,0.00,'2022-09-03 12:12:25'),(1808722,'5','173',400,'Sale Id shift 257861',0.00,792392.00,185.00,792392.00,0.00,'2022-09-04 10:11:24'),(1808723,'5','173',400,'Sale Id shift 257862',0.00,749218.55,185.00,749218.55,0.00,'2022-09-04 10:17:30'),(1808724,'5','173',400,'Sale Id shift 257863',0.00,861767.00,185.00,861767.00,0.00,'2022-09-04 10:21:29'),(1808725,'5','173',400,'Sale Id shift 257864',0.00,877251.50,185.00,877251.50,0.00,'2022-09-04 10:24:01'),(1808726,'5','173',400,'Sale Id shift 257865',0.00,712399.85,185.00,712399.85,0.00,'2022-09-04 10:26:34'),(1808727,'5','173',400,'Sale Id shift 257866',0.00,876200.70,185.00,876200.70,0.00,'2022-09-04 10:28:50'),(1808728,'5','173',400,'Sale Id shift 257867',0.00,1115483.40,185.00,1115483.40,0.00,'2022-09-04 10:36:43'),(1808729,'5','173',400,'Sale Id shift 257868',0.00,1131587.65,185.00,1131587.65,0.00,'2022-09-04 10:48:30'),(1808730,'5','173',400,'Sale Id shift 257869',0.00,835680.15,185.00,835680.15,0.00,'2022-09-04 10:58:20'),(1808731,'5','173',400,'Sale Id shift 257870',0.00,581479.05,185.00,581479.05,0.00,'2022-09-04 11:00:16'),(1808732,'5','173',400,'Sale Id shift 257871',0.00,557068.30,186.00,560079.48,3011.18,'2022-09-04 11:02:11'),(1808733,'5','173',400,'Sale Id shift 257872',0.00,378659.85,185.00,378659.85,0.00,'2022-09-04 11:04:33'),(1808734,'5','173',400,'Sale Id shift 257873',0.00,415097.45,185.00,415097.45,0.00,'2022-09-04 11:07:17'),(1808735,'5','173',400,'Sale Id shift 257874',0.00,557812.00,185.00,557812.00,0.00,'2022-09-04 11:09:09'),(1808736,'5','173',400,'Sale Id shift 257875',0.00,378902.20,185.00,378902.20,0.00,'2022-09-04 11:12:55'),(1808737,'5','173',400,'Sale Id shift 257876',0.00,378876.30,185.00,378876.30,0.00,'2022-09-05 10:23:04'),(1808738,'5','173',400,'Sale Id shift 257877',0.00,521792.50,185.00,521792.50,0.00,'2022-09-06 10:21:05'),(1808739,'5','173',400,'Sale Id shift 257878',0.00,745455.65,185.00,745455.65,0.00,'2022-09-07 15:23:25'),(1808740,'5','173',400,'Sale Id shift 257879',0.00,382413.50,185.00,382413.50,0.00,'2022-09-08 14:28:05'),(1808741,'5','173',400,'Sale Id shift 257880',0.00,476289.90,185.00,476289.90,0.00,'2022-09-09 16:22:32'),(1808742,'5','173',400,'Sale Id shift 257881',0.00,394301.60,185.00,394301.60,0.00,'2022-09-11 05:58:06'),(1808743,'5','173',400,'Sale Id shift 257882',0.00,445163.65,185.00,445163.65,0.00,'2022-09-12 05:54:38'),(1808744,'5','173',400,'Sale Id shift 257883',0.00,371524.40,185.00,371524.40,0.00,'2022-09-13 10:33:28'),(1808745,'5','173',400,'Sale Id shift 257884',0.00,398813.75,185.00,398813.75,0.00,'2022-09-14 06:02:18'),(1808746,'5','173',400,'Sale Id shift 257885',0.00,407382.95,185.00,407382.95,0.00,'2022-09-14 16:29:33'),(1808747,'5','173',400,'Sale Id shift 257886',0.00,147742.85,185.00,147742.85,0.00,'2022-09-15 10:05:58'),(1808748,'5','173',400,'Sale Id shift 257890',0.00,138516.90,185.00,138516.90,0.00,'2022-09-19 13:25:58'),(1808749,'5','173',400,'Sale Id shift 257891',0.00,375884.85,185.00,375884.85,0.00,'2022-09-20 11:21:19'),(1808750,'5','173',400,'Sale Id shift 257892',0.00,222919.45,185.00,222919.45,0.00,'2022-09-21 17:00:30'),(1808751,'5','173',400,'Sale Id shift 257893',0.00,239044.05,185.00,239044.05,0.00,'2022-09-22 08:45:18'),(1808752,'5','173',400,'Sale Id shift 257894',0.00,244631.05,185.00,244631.05,0.00,'2022-09-23 14:49:54'),(1808753,'5','173',400,'Sale Id shift 257895',0.00,216958.75,185.00,216958.75,0.00,'2022-09-24 09:56:11'),(1808754,'5','173',400,'Sale Id shift 257896',0.00,224175.60,185.00,224175.60,0.00,'2022-09-25 08:21:41'),(1808755,'5','173',400,'Sale Id shift 257897',0.00,203714.60,185.00,203714.60,0.00,'2022-09-26 09:46:06'),(1808756,'5','173',400,'Sale Id shift 257898',0.00,208883.50,185.00,208883.50,0.00,'2022-09-27 08:18:55'),(1808757,'5','173',400,'Sale Id shift 257899',0.00,203897.75,185.00,203897.75,0.00,'2022-09-28 10:04:46'),(1808758,'5','173',400,'Sale Id shift 257900',0.00,246571.70,185.00,246571.70,0.00,'2022-09-29 08:08:15'),(1808759,'5','173',400,'Sale Id shift 257901',0.00,188762.90,185.00,188762.90,0.00,'2022-10-01 10:26:52'),(1808760,'5','173',400,'Sale Id shift 257902',0.00,203773.80,185.00,203773.80,0.00,'2022-10-02 08:08:45'),(1808761,'5','173',400,'Sale Id shift 257903',0.00,256091.80,185.00,256091.80,0.00,'2022-10-03 05:59:07'),(1808762,'5','173',400,'Sale Id shift 257904',0.00,230859.65,185.00,230859.65,0.00,'2022-10-03 09:32:56'),(1808763,'5','173',400,'Sale Id shift 257905',0.00,206445.20,185.00,206445.20,0.00,'2022-10-04 09:09:01'),(1808764,'5','173',400,'Sale Id shift 257906',0.00,199084.05,185.00,199084.05,0.00,'2022-10-05 08:08:22'),(1808765,'5','173',400,'Sale Id shift 257907',0.00,260491.10,185.00,260491.10,0.00,'2022-10-06 08:06:16'),(1808766,'5','173',400,'Sale Id shift 257908',0.00,659225.30,185.00,659225.30,0.00,'2022-10-08 08:15:06'),(1808767,'5','173',400,'Sale Id shift 257909',0.00,901912.00,186.00,906787.20,4875.20,'2022-10-08 18:52:18'),(1808768,'5','173',400,'Sale Id shift 257910',0.00,1580360.65,185.00,1580360.65,0.00,'2022-10-09 17:19:08'),(1808769,'5','173',400,'Sale Id shift 257911',0.00,1203141.95,185.00,1203141.95,0.00,'2022-10-10 17:04:03'),(1808770,'5','173',400,'Sale Id shift 257912',0.00,1740276.50,185.00,1740276.50,0.00,'2022-10-12 09:01:10'),(1808771,'5','173',400,'Sale Id shift 257913',0.00,904115.35,185.00,904115.35,0.00,'2022-10-12 16:52:15'),(1808772,'5','173',400,'Sale Id shift 257914',0.00,746378.80,185.00,746378.80,0.00,'2022-10-14 08:15:39'),(1808773,'5','173',400,'Sale Id shift 257915',0.00,1215126.25,185.00,1215126.25,0.00,'2022-10-14 14:23:21'),(1808774,'5','173',400,'Sale Id shift 257916',0.00,638967.80,185.00,638967.80,0.00,'2022-10-16 10:00:41'),(1808775,'5','173',400,'Sale Id shift 257917',0.00,866932.20,185.00,866932.20,0.00,'2022-10-17 08:10:15'),(1808776,'5','173',400,'Sale Id shift 257918',0.00,494697.40,185.00,494697.40,0.00,'2022-10-17 11:29:59'),(1808777,'5','173',400,'Sale Id shift 257919',0.00,537217.80,185.00,537217.80,0.00,'2022-10-18 21:32:30'),(1808778,'5','173',400,'Sale Id shift 257920',0.00,426600.75,185.00,426600.75,0.00,'2022-10-19 08:18:13'),(1808779,'5','173',400,'Sale Id shift 257921',0.00,618492.00,185.00,618492.00,0.00,'2022-10-21 06:02:32'),(1808780,'5','173',400,'Sale Id shift 257935',0.00,598332.55,185.00,598332.55,0.00,'2022-11-03 16:38:42'),(1808781,'5','173',400,'Sale Id shift 257936',0.00,1184738.15,185.00,1184738.15,0.00,'2022-11-05 09:02:47'),(1808782,'5','173',400,'Sale Id shift 257937',0.00,1260271.80,185.00,1260271.80,0.00,'2022-11-05 09:42:27'),(1808783,'5','173',400,'Sale Id shift 257938',0.00,1055077.20,185.00,1055077.20,0.00,'2022-11-06 09:18:58'),(1808784,'5','173',400,'Sale Id shift 257939',0.00,999192.40,185.00,999192.40,0.00,'2022-11-07 09:14:26'),(1808785,'5','173',400,'Sale Id shift 257940',0.00,945103.95,185.00,945103.95,0.00,'2022-11-08 08:19:35'),(1808786,'5','173',400,'Sale Id shift 257941',0.00,756810.95,185.00,756810.95,0.00,'2022-11-09 08:17:55'),(1808787,'5','173',400,'Sale Id shift 257942',0.00,944369.50,185.00,944369.50,0.00,'2022-11-10 09:31:32'),(1808788,'5','173',400,'Sale Id shift 257943',0.00,525603.50,185.00,525603.50,0.00,'2022-11-11 13:27:10'),(1808789,'5','173',400,'Sale Id shift 257976',0.00,1395044.70,210.00,1395044.70,0.00,'2023-03-10 14:16:41'),(1808790,'5','173',400,'Sale Id shift 257977',0.00,1832775.00,210.00,1832775.00,0.00,'2023-03-10 14:56:15'),(1808791,'5','173',400,'Sale Id shift 257978',0.00,1768118.10,210.00,1768118.10,0.00,'2023-03-10 15:13:09'),(1808792,'5','173',400,'Sale Id shift 257979',0.00,2240143.50,210.00,2240143.50,0.00,'2023-03-11 16:05:13'),(1808793,'5','173',400,'Sale Id shift 257980',0.00,1655721.90,210.00,1655721.90,0.00,'2023-03-11 16:33:20'),(1808794,'5','173',400,'Sale Id shift 257981',0.00,1503392.10,210.00,1503392.10,0.00,'2023-03-12 16:53:04');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4956482 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','173',3619357,'','24','3181',0.00,90000.00,'Purchase Id 78549 for 300.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:36:41','',''),('5','173',3619358,'','supplier','217',90000.00,0.00,'Purchase Id 78549 for 300.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:36:41','',''),('5','173',3619365,'','24','3181',0.00,502200.00,'Purchase Id 78548 for 3,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:37:14','',''),('5','173',3619366,'','supplier','217',502200.00,0.00,'Purchase Id 78548 for 3,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:37:14','',''),('5','173',3752172,'','20','3177',124218.36,0.00,'Sales from shift 235144 on 2021-10-31 10:33:22 ','2021-10-31 10:33:22','',''),('5','173',3752173,'','6.1','3178',0.00,124218.36,'Sales from shift 235144 on 2021-10-31 10:33:22 ','2021-10-31 10:33:22','',''),('5','173',3759810,'','20','3177',32400.00,0.00,'Sales from shift 235685 on 2021-11-01 08:47:10 ','2021-11-01 08:47:10','',''),('5','173',3759811,'','6.1','3178',0.00,32400.00,'Sales from shift 235685 on 2021-11-01 08:47:10 ','2021-11-01 08:47:10','',''),('5','173',3760605,'','20','3177',0.00,0.00,'Sales from shift 235849 on 2021-11-01 09:41:27 ','2021-11-01 09:41:27','',''),('5','173',3760606,'','6.1','3178',0.00,0.00,'Sales from shift 235849 on 2021-11-01 09:41:27 ','2021-11-01 09:41:27','',''),('5','173',3760712,'','20','3177',0.00,0.00,'Sales from shift 235850 on 2021-11-01 09:45:59 ','2021-11-01 09:45:59','',''),('5','173',3760713,'','6.1','3178',0.00,0.00,'Sales from shift 235850 on 2021-11-01 09:45:59 ','2021-11-01 09:45:59','',''),('5','173',3760737,'','20','3177',0.00,0.00,'Sales from shift 235852 on 2021-11-01 09:48:31 ','2021-11-01 09:48:31','',''),('5','173',3760738,'','6.1','3178',0.00,0.00,'Sales from shift 235852 on 2021-11-01 09:48:31 ','2021-11-01 09:48:31','',''),('5','173',3760788,'','20','3177',0.00,0.00,'Sales from shift 235855 on 2021-11-01 09:53:22 ','2021-11-01 09:53:22','',''),('5','173',3760789,'','6.1','3178',0.00,0.00,'Sales from shift 235855 on 2021-11-01 09:53:22 ','2021-11-01 09:53:22','',''),('5','173',3760869,'','20','3177',0.00,0.00,'Sales from shift 235856 on 2021-11-01 09:57:52 ','2021-11-01 09:57:52','',''),('5','173',3760870,'','6.1','3178',0.00,0.00,'Sales from shift 235856 on 2021-11-01 09:57:52 ','2021-11-01 09:57:52','',''),('5','173',3761003,'','20','3177',0.00,0.00,'Sales from shift 235857 on 2021-11-01 10:10:46 ','2021-11-01 10:10:46','',''),('5','173',3761004,'','6.1','3178',0.00,0.00,'Sales from shift 235857 on 2021-11-01 10:10:46 ','2021-11-01 10:10:46','',''),('5','173',3761637,'','20','3177',0.00,0.00,'Sales from shift 235863 on 2021-11-01 10:57:21 ','2021-11-01 10:57:21','',''),('5','173',3761638,'','6.1','3178',0.00,0.00,'Sales from shift 235863 on 2021-11-01 10:57:21 ','2021-11-01 10:57:21','',''),('5','173',3761678,'','20','3177',0.00,0.00,'Sales from shift 235872 on 2021-11-01 11:00:37 ','2021-11-01 11:00:37','',''),('5','173',3761679,'','6.1','3178',0.00,0.00,'Sales from shift 235872 on 2021-11-01 11:00:37 ','2021-11-01 11:00:37','',''),('5','173',3761714,'','20','3177',0.00,0.00,'Sales from shift 235873 on 2021-11-01 11:03:15 ','2021-11-01 11:03:15','',''),('5','173',3761715,'','6.1','3178',0.00,0.00,'Sales from shift 235873 on 2021-11-01 11:03:15 ','2021-11-01 11:03:15','',''),('5','173',3761742,'','20','3177',0.00,0.00,'Sales from shift 235874 on 2021-11-01 11:04:56 ','2021-11-01 11:04:56','',''),('5','173',3761743,'','6.1','3178',0.00,0.00,'Sales from shift 235874 on 2021-11-01 11:04:56 ','2021-11-01 11:04:56','',''),('5','173',3761773,'','20','3177',0.00,0.00,'Sales from shift 235875 on 2021-11-01 11:07:19 ','2021-11-01 11:07:19','',''),('5','173',3761774,'','6.1','3178',0.00,0.00,'Sales from shift 235875 on 2021-11-01 11:07:19 ','2021-11-01 11:07:19','',''),('5','173',3761793,'','20','3177',0.00,0.00,'Sales from shift 235876 on 2021-11-01 11:09:15 ','2021-11-01 11:09:15','',''),('5','173',3761794,'','6.1','3178',0.00,0.00,'Sales from shift 235876 on 2021-11-01 11:09:15 ','2021-11-01 11:09:15','',''),('5','173',3761863,'','20','3177',0.00,0.00,'Sales from shift 235877 on 2021-11-01 11:15:35 ','2021-11-01 11:15:35','',''),('5','173',3761864,'','6.1','3178',0.00,0.00,'Sales from shift 235877 on 2021-11-01 11:15:35 ','2021-11-01 11:15:35','',''),('5','173',3765179,'','20','3177',0.00,0.00,'Sales from shift 235911 on 2021-11-01 16:11:11 ','2021-11-01 16:11:11','',''),('5','173',3765180,'','6.1','3178',0.00,0.00,'Sales from shift 235911 on 2021-11-01 16:11:11 ','2021-11-01 16:11:11','',''),('5','173',3766149,'','20','3177',0.00,0.00,'Sales from shift 235962 on 2021-11-01 18:09:07 ','2021-11-01 18:09:07','',''),('5','173',3766150,'','6.1','3178',0.00,0.00,'Sales from shift 235962 on 2021-11-01 18:09:07 ','2021-11-01 18:09:07','',''),('5','173',3766681,'','22','3179',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3768076,'','20','3177',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3768499,'','6.1','3178',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3768779,'','2','3228',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3769124,'','24','3181',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3769209,'','24','3180',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','173',3781333,'','20','3177',0.00,0.00,'Sales from shift 236316 on 2021-11-03 09:11:13 ','2021-11-03 09:11:13','',''),('5','173',3781334,'','6.1','3178',0.00,0.00,'Sales from shift 236316 on 2021-11-03 09:11:13 ','2021-11-03 09:11:13','',''),('5','173',3781420,'','20','3177',0.00,0.00,'Sales from shift 236317 on 2021-11-03 09:16:57 ','2021-11-03 09:16:57','',''),('5','173',3781421,'','6.1','3178',0.00,0.00,'Sales from shift 236317 on 2021-11-03 09:16:57 ','2021-11-03 09:16:57','',''),('5','173',3781672,'','20','3177',0.00,0.00,'Sales from shift 236324 on 2021-11-03 09:33:49 ','2021-11-03 09:33:49','',''),('5','173',3781673,'','6.1','3178',0.00,0.00,'Sales from shift 236324 on 2021-11-03 09:33:49 ','2021-11-03 09:33:49','',''),('5','173',3781855,'','20','3177',0.00,0.00,'Sales from shift 236332 on 2021-11-03 09:44:39 ','2021-11-03 09:44:39','',''),('5','173',3781856,'','6.1','3178',0.00,0.00,'Sales from shift 236332 on 2021-11-03 09:44:39 ','2021-11-03 09:44:39','',''),('5','173',3782027,'','20','3177',0.00,0.00,'Sales from shift 236334 on 2021-11-03 09:54:08 ','2021-11-03 09:54:08','',''),('5','173',3782028,'','6.1','3178',0.00,0.00,'Sales from shift 236334 on 2021-11-03 09:54:08 ','2021-11-03 09:54:08','',''),('5','173',3782839,'','20','3177',48600.00,0.00,'Sales from shift 236357 on 2021-11-03 10:48:36 ','2021-11-03 10:48:36','',''),('5','173',3782840,'','6.1','3178',0.00,48600.00,'Sales from shift 236357 on 2021-11-03 10:48:36 ','2021-11-03 10:48:36','',''),('5','173',3782924,'','20','3177',196656.66,0.00,'Sales from shift 236359 on 2021-11-03 10:55:40 ','2021-11-03 10:55:40','',''),('5','173',3782925,'','6.1','3178',0.00,196656.66,'Sales from shift 236359 on 2021-11-03 10:55:40 ','2021-11-03 10:55:40','',''),('5','173',3783011,'','24','3181',0.00,3304800.00,'Purchase Id 79695 for 20,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-03 11:01:38','',''),('5','173',3783012,'','supplier','217',3304800.00,0.00,'Purchase Id 79695 for 20,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-03 11:01:38','',''),('5','173',3857370,'','20','3177',229524.84,0.00,'Sales from shift 236360 on 2021-11-09 12:57:00 ','2021-11-09 12:57:00','',''),('5','173',3857371,'','6.1','3178',0.00,229524.84,'Sales from shift 236360 on 2021-11-09 12:57:00 ','2021-11-09 12:57:00','',''),('5','173',3857504,'','20','3177',175451.10,0.00,'Sales from shift 237730 on 2021-11-09 13:03:10 ','2021-11-09 13:03:10','',''),('5','173',3857505,'','6.1','3178',0.00,175451.10,'Sales from shift 237730 on 2021-11-09 13:03:10 ','2021-11-09 13:03:10','',''),('5','173',3857708,'','20','3177',446539.50,0.00,'Sales from shift 237733 on 2021-11-09 13:17:56 ','2021-11-09 13:17:56','',''),('5','173',3857709,'','6.1','3178',0.00,446539.50,'Sales from shift 237733 on 2021-11-09 13:17:56 ','2021-11-09 13:17:56','',''),('5','173',3857990,'','20','3177',180922.50,0.00,'Sales from shift 237741 on 2021-11-09 13:34:07 ','2021-11-09 13:34:07','',''),('5','173',3857991,'','6.1','3178',0.00,180922.50,'Sales from shift 237741 on 2021-11-09 13:34:07 ','2021-11-09 13:34:07','',''),('5','173',3858092,'','20','3177',194564.70,0.00,'Sales from shift 237743 on 2021-11-09 13:40:55 ','2021-11-09 13:40:55','',''),('5','173',3858093,'','6.1','3178',0.00,194564.70,'Sales from shift 237743 on 2021-11-09 13:40:55 ','2021-11-09 13:40:55','',''),('5','173',3858222,'','20','3177',171149.55,0.00,'Sales from shift 237746 on 2021-11-09 13:48:30 ','2021-11-09 13:48:30','',''),('5','173',3858223,'','6.1','3178',0.00,171149.55,'Sales from shift 237746 on 2021-11-09 13:48:30 ','2021-11-09 13:48:30','',''),('5','173',3858271,'','20','3177',174819.15,0.00,'Sales from shift 237747 on 2021-11-09 13:51:32 ','2021-11-09 13:51:32','',''),('5','173',3858272,'','6.1','3178',0.00,174819.15,'Sales from shift 237747 on 2021-11-09 13:51:32 ','2021-11-09 13:51:32','',''),('5','173',3858340,'','20','3177',246028.20,0.00,'Sales from shift 237748 on 2021-11-09 13:55:48 ','2021-11-09 13:55:48','',''),('5','173',3858341,'','6.1','3178',0.00,246028.20,'Sales from shift 237748 on 2021-11-09 13:55:48 ','2021-11-09 13:55:48','',''),('5','173',3858395,'','20','3177',293246.25,0.00,'Sales from shift 237751 on 2021-11-09 13:59:41 ','2021-11-09 13:59:41','',''),('5','173',3858396,'','6.1','3178',0.00,293246.25,'Sales from shift 237751 on 2021-11-09 13:59:41 ','2021-11-09 13:59:41','',''),('5','173',3858487,'','20','3177',290446.20,0.00,'Sales from shift 237752 on 2021-11-09 14:04:58 ','2021-11-09 14:04:58','',''),('5','173',3858488,'','6.1','3178',0.00,290446.20,'Sales from shift 237752 on 2021-11-09 14:04:58 ','2021-11-09 14:04:58','',''),('5','173',3858588,'','20','3177',267319.80,0.00,'Sales from shift 237754 on 2021-11-09 14:09:12 ','2021-11-09 14:09:12','',''),('5','173',3858589,'','6.1','3178',0.00,267319.80,'Sales from shift 237754 on 2021-11-09 14:09:12 ','2021-11-09 14:09:12','',''),('5','173',3858655,'','20','3177',156855.60,0.00,'Sales from shift 237757 on 2021-11-09 14:12:24 ','2021-11-09 14:12:24','',''),('5','173',3858656,'','6.1','3178',0.00,156855.60,'Sales from shift 237757 on 2021-11-09 14:12:24 ','2021-11-09 14:12:24','',''),('5','173',3858733,'','20','3177',193050.00,0.00,'Sales from shift 237759 on 2021-11-09 14:15:13 ','2021-11-09 14:15:13','',''),('5','173',3858734,'','6.1','3178',0.00,193050.00,'Sales from shift 237759 on 2021-11-09 14:15:13 ','2021-11-09 14:15:13','',''),('5','173',3858789,'','20','3177',88081.95,0.00,'Sales from shift 237761 on 2021-11-09 14:17:31 ','2021-11-09 14:17:31','',''),('5','173',3858790,'','6.1','3178',0.00,88081.95,'Sales from shift 237761 on 2021-11-09 14:17:31 ','2021-11-09 14:17:31','',''),('5','173',3858851,'','20','3177',0.00,0.00,'Sales from shift 237763 on 2021-11-09 14:20:23 ','2021-11-09 14:20:23','',''),('5','173',3858852,'','6.1','3178',0.00,0.00,'Sales from shift 237763 on 2021-11-09 14:20:23 ','2021-11-09 14:20:23','',''),('5','173',3876082,'','20','3177',0.00,0.00,'Sales from shift 237766 on 2021-11-11 04:50:33 ','2021-11-11 04:50:33','',''),('5','173',3876083,'','6.1','3178',0.00,0.00,'Sales from shift 237766 on 2021-11-11 04:50:33 ','2021-11-11 04:50:33','',''),('5','173',3892744,'','20','3177',0.00,0.00,'Sales from shift 238205 on 2021-11-12 08:17:04 ','2021-11-12 08:17:04','',''),('5','173',3892745,'','6.1','3178',0.00,0.00,'Sales from shift 238205 on 2021-11-12 08:17:04 ','2021-11-12 08:17:04','',''),('5','173',3906999,'','20','3177',0.00,0.00,'Sales from shift 238454 on 2021-11-13 10:07:18 ','2021-11-13 10:07:18','',''),('5','173',3907000,'','6.1','3178',0.00,0.00,'Sales from shift 238454 on 2021-11-13 10:07:18 ','2021-11-13 10:07:18','',''),('5','173',3918998,'','20','3177',0.00,0.00,'Sales from shift 238699 on 2021-11-14 09:35:40 ','2021-11-14 09:35:40','',''),('5','173',3918999,'','6.1','3178',0.00,0.00,'Sales from shift 238699 on 2021-11-14 09:35:40 ','2021-11-14 09:35:40','',''),('5','173',3927319,'','20','3177',0.00,0.00,'Sales from shift 238985 on 2021-11-14 18:41:37 ','2021-11-14 18:41:37','',''),('5','173',3927320,'','6.1','3178',0.00,0.00,'Sales from shift 238985 on 2021-11-14 18:41:37 ','2021-11-14 18:41:37','',''),('5','173',3940346,'','20','3177',0.00,0.00,'Sales from shift 239129 on 2021-11-16 08:08:05 ','2021-11-16 08:08:05','',''),('5','173',3940347,'','6.1','3178',0.00,0.00,'Sales from shift 239129 on 2021-11-16 08:08:05 ','2021-11-16 08:08:05','',''),('5','173',3952140,'','20','3177',0.00,0.00,'Sales from shift 239350 on 2021-11-17 08:01:30 ','2021-11-17 08:01:30','',''),('5','173',3952141,'','6.1','3178',0.00,0.00,'Sales from shift 239350 on 2021-11-17 08:01:30 ','2021-11-17 08:01:30','',''),('5','173',3968056,'','20','3177',0.00,0.00,'Sales from shift 239700 on 2021-11-18 12:16:52 ','2021-11-18 12:16:52','',''),('5','173',3968057,'','6.1','3178',0.00,0.00,'Sales from shift 239700 on 2021-11-18 12:16:52 ','2021-11-18 12:16:52','',''),('5','173',3976787,'','20','3177',0.00,0.00,'Sales from shift 239903 on 2021-11-19 08:12:47 ','2021-11-19 08:12:47','',''),('5','173',3976788,'','6.1','3178',0.00,0.00,'Sales from shift 239903 on 2021-11-19 08:12:47 ','2021-11-19 08:12:47','',''),('5','173',3988752,'','20','3177',0.00,0.00,'Sales from shift 240055 on 2021-11-20 08:31:51 ','2021-11-20 08:31:51','',''),('5','173',3988753,'','6.1','3178',0.00,0.00,'Sales from shift 240055 on 2021-11-20 08:31:51 ','2021-11-20 08:31:51','',''),('5','173',4030958,'','24','3181',0.00,6534000.00,'Purchase Id 81027 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-23 12:28:37','',''),('5','173',4030959,'','supplier','217',6534000.00,0.00,'Purchase Id 81027 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-23 12:28:37','',''),('5','173',4064953,'','20','3177',361556.25,0.00,'Sales from shift 240341 on 2021-11-26 08:27:05 ','2021-11-26 08:27:05','',''),('5','173',4064954,'','6.1','3178',0.00,361556.25,'Sales from shift 240341 on 2021-11-26 08:27:05 ','2021-11-26 08:27:05','',''),('5','173',4076075,'','20','3177',267149.85,0.00,'Sales from shift 241811 on 2021-11-27 07:56:51 ','2021-11-27 07:56:51','',''),('5','173',4076076,'','6.1','3178',0.00,267149.85,'Sales from shift 241811 on 2021-11-27 07:56:51 ','2021-11-27 07:56:51','',''),('5','173',4096218,'','20','3177',505399.95,0.00,'Sales from shift 242198 on 2021-11-28 13:43:24 ','2021-11-28 13:43:24','',''),('5','173',4096219,'','6.1','3178',0.00,505399.95,'Sales from shift 242198 on 2021-11-28 13:43:24 ','2021-11-28 13:43:24','',''),('5','173',4107930,'','20','3177',234493.05,0.00,'Sales from shift 242461 on 2021-11-29 14:02:20 ','2021-11-29 14:02:20','',''),('5','173',4107931,'','6.1','3178',0.00,234493.05,'Sales from shift 242461 on 2021-11-29 14:02:20 ','2021-11-29 14:02:20','',''),('5','173',4115302,'','20','3177',227980.50,0.00,'Sales from shift 242614 on 2021-11-30 08:47:16 ','2021-11-30 08:47:16','',''),('5','173',4115303,'','6.1','3178',0.00,227980.50,'Sales from shift 242614 on 2021-11-30 08:47:16 ','2021-11-30 08:47:16','',''),('5','173',4129060,'','20','3177',260904.60,0.00,'Sales from shift 242787 on 2021-12-01 08:32:47 ','2021-12-01 08:32:47','',''),('5','173',4129061,'','6.1','3178',0.00,260904.60,'Sales from shift 242787 on 2021-12-01 08:32:47 ','2021-12-01 08:32:47','',''),('5','173',4370103,'','20','3177',296142.00,0.00,'Sales from shift 247018 on 2021-12-19 07:54:34 ','2021-12-19 07:54:34','',''),('5','173',4370104,'','6.1','3178',0.00,296142.00,'Sales from shift 247018 on 2021-12-19 07:54:34 ','2021-12-19 07:54:34','',''),('5','173',4386625,'','20','3177',341612.70,0.00,'Sales from shift 247308 on 2021-12-20 11:04:54 ','2021-12-20 11:04:54','',''),('5','173',4386626,'','6.1','3178',0.00,341612.70,'Sales from shift 247308 on 2021-12-20 11:04:54 ','2021-12-20 11:04:54','',''),('5','173',4387755,'','20','3177',279123.90,0.00,'Sales from shift 247501 on 2021-12-20 12:11:32 ','2021-12-20 12:11:32','',''),('5','173',4387756,'','6.1','3178',0.00,279123.90,'Sales from shift 247501 on 2021-12-20 12:11:32 ','2021-12-20 12:11:32','',''),('5','173',4387865,'','20','3177',227975.55,0.00,'Sales from shift 247509 on 2021-12-20 12:17:14 ','2021-12-20 12:17:14','',''),('5','173',4387866,'','6.1','3178',0.00,227975.55,'Sales from shift 247509 on 2021-12-20 12:17:14 ','2021-12-20 12:17:14','',''),('5','173',4388100,'','20','3177',261366.60,0.00,'Sales from shift 247511 on 2021-12-20 12:28:16 ','2021-12-20 12:28:16','',''),('5','173',4388101,'','6.1','3178',0.00,261366.60,'Sales from shift 247511 on 2021-12-20 12:28:16 ','2021-12-20 12:28:16','',''),('5','173',4388198,'','20','3177',274074.90,0.00,'Sales from shift 247514 on 2021-12-20 12:33:55 ','2021-12-20 12:33:55','',''),('5','173',4388199,'','6.1','3178',0.00,274074.90,'Sales from shift 247514 on 2021-12-20 12:33:55 ','2021-12-20 12:33:55','',''),('5','173',4388322,'','20','3177',249085.65,0.00,'Sales from shift 247515 on 2021-12-20 12:40:17 ','2021-12-20 12:40:17','',''),('5','173',4388323,'','6.1','3178',0.00,249085.65,'Sales from shift 247515 on 2021-12-20 12:40:17 ','2021-12-20 12:40:17','',''),('5','173',4388437,'','20','3177',350265.30,0.00,'Sales from shift 247516 on 2021-12-20 12:43:11 ','2021-12-20 12:43:11','',''),('5','173',4388438,'','6.1','3178',0.00,350265.30,'Sales from shift 247516 on 2021-12-20 12:43:11 ','2021-12-20 12:43:11','',''),('5','173',4388480,'','20','3177',255179.10,0.00,'Sales from shift 247517 on 2021-12-20 12:45:00 ','2021-12-20 12:45:00','',''),('5','173',4388481,'','6.1','3178',0.00,255179.10,'Sales from shift 247517 on 2021-12-20 12:45:00 ','2021-12-20 12:45:00','',''),('5','173',4388546,'','20','3177',261975.45,0.00,'Sales from shift 247519 on 2021-12-20 12:47:17 ','2021-12-20 12:47:17','',''),('5','173',4388547,'','6.1','3178',0.00,261975.45,'Sales from shift 247519 on 2021-12-20 12:47:17 ','2021-12-20 12:47:17','',''),('5','173',4388640,'','20','3177',271849.05,0.00,'Sales from shift 247521 on 2021-12-20 12:50:20 ','2021-12-20 12:50:20','',''),('5','173',4388641,'','6.1','3178',0.00,271849.05,'Sales from shift 247521 on 2021-12-20 12:50:20 ','2021-12-20 12:50:20','',''),('5','173',4388713,'','20','3177',339198.75,0.00,'Sales from shift 247523 on 2021-12-20 12:53:22 ','2021-12-20 12:53:22','',''),('5','173',4388714,'','6.1','3178',0.00,339198.75,'Sales from shift 247523 on 2021-12-20 12:53:22 ','2021-12-20 12:53:22','',''),('5','173',4388746,'','20','3177',236426.85,0.00,'Sales from shift 247524 on 2021-12-20 12:55:16 ','2021-12-20 12:55:16','',''),('5','173',4388747,'','6.1','3178',0.00,236426.85,'Sales from shift 247524 on 2021-12-20 12:55:16 ','2021-12-20 12:55:16','',''),('5','173',4388796,'','20','3177',290583.15,0.00,'Sales from shift 247527 on 2021-12-20 12:57:03 ','2021-12-20 12:57:03','',''),('5','173',4388797,'','6.1','3178',0.00,290583.15,'Sales from shift 247527 on 2021-12-20 12:57:03 ','2021-12-20 12:57:03','',''),('5','173',4388858,'','20','3177',238956.30,0.00,'Sales from shift 247528 on 2021-12-20 13:00:08 ','2021-12-20 13:00:08','',''),('5','173',4388859,'','6.1','3178',0.00,238956.30,'Sales from shift 247528 on 2021-12-20 13:00:08 ','2021-12-20 13:00:08','',''),('5','173',4388949,'','20','3177',244508.55,0.00,'Sales from shift 247529 on 2021-12-20 13:02:16 ','2021-12-20 13:02:16','',''),('5','173',4388950,'','6.1','3178',0.00,244508.55,'Sales from shift 247529 on 2021-12-20 13:02:16 ','2021-12-20 13:02:16','',''),('5','173',4389001,'','20','3177',76858.65,0.00,'Sales from shift 247531 on 2021-12-20 13:05:18 ','2021-12-20 13:05:18','',''),('5','173',4389002,'','6.1','3178',0.00,76858.65,'Sales from shift 247531 on 2021-12-20 13:05:18 ','2021-12-20 13:05:18','',''),('5','173',4389023,'','20','3177',0.00,0.00,'Sales from shift 247536 on 2021-12-20 13:07:01 ','2021-12-20 13:07:01','',''),('5','173',4389024,'','6.1','3178',0.00,0.00,'Sales from shift 247536 on 2021-12-20 13:07:01 ','2021-12-20 13:07:01','',''),('5','173',4389043,'','20','3177',0.00,0.00,'Sales from shift 247537 on 2021-12-20 13:08:44 ','2021-12-20 13:08:44','',''),('5','173',4389044,'','6.1','3178',0.00,0.00,'Sales from shift 247537 on 2021-12-20 13:08:44 ','2021-12-20 13:08:44','',''),('5','173',4389063,'','20','3177',0.00,0.00,'Sales from shift 247538 on 2021-12-20 13:10:03 ','2021-12-20 13:10:03','',''),('5','173',4389064,'','6.1','3178',0.00,0.00,'Sales from shift 247538 on 2021-12-20 13:10:03 ','2021-12-20 13:10:03','',''),('5','173',4389083,'','20','3177',0.00,0.00,'Sales from shift 247539 on 2021-12-20 13:11:35 ','2021-12-20 13:11:35','',''),('5','173',4389084,'','6.1','3178',0.00,0.00,'Sales from shift 247539 on 2021-12-20 13:11:35 ','2021-12-20 13:11:35','',''),('5','173',4389136,'','20','3177',0.00,0.00,'Sales from shift 247541 on 2021-12-20 13:12:52 ','2021-12-20 13:12:52','',''),('5','173',4389137,'','6.1','3178',0.00,0.00,'Sales from shift 247541 on 2021-12-20 13:12:52 ','2021-12-20 13:12:52','',''),('5','173',4389164,'','20','3177',0.00,0.00,'Sales from shift 247542 on 2021-12-20 13:14:14 ','2021-12-20 13:14:14','',''),('5','173',4389165,'','6.1','3178',0.00,0.00,'Sales from shift 247542 on 2021-12-20 13:14:14 ','2021-12-20 13:14:14','',''),('5','173',4389200,'','20','3177',0.00,0.00,'Sales from shift 247543 on 2021-12-20 13:16:25 ','2021-12-20 13:16:25','',''),('5','173',4389201,'','6.1','3178',0.00,0.00,'Sales from shift 247543 on 2021-12-20 13:16:25 ','2021-12-20 13:16:25','',''),('5','173',4396681,'','20','3177',0.00,0.00,'Sales from shift 247546 on 2021-12-21 07:57:31 ','2021-12-21 07:57:31','',''),('5','173',4396682,'','6.1','3178',0.00,0.00,'Sales from shift 247546 on 2021-12-21 07:57:31 ','2021-12-21 07:57:31','',''),('5','173',4412276,'','20','3177',0.00,0.00,'Sales from shift 247773 on 2021-12-22 08:01:31 ','2021-12-22 08:01:31','',''),('5','173',4412277,'','6.1','3178',0.00,0.00,'Sales from shift 247773 on 2021-12-22 08:01:31 ','2021-12-22 08:01:31','',''),('5','173',4420310,'','2','3228',218300.00,0.00,'Payment Id 360916 for invoice:237748, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:35:07','',''),('5','173',4420311,'','supplier','217',0.00,218300.00,'Payment Id 360916 for invoice:237748, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:35:07','',''),('5','173',4420334,'','6.1','3178',27725.00,0.00,'Payment Id 360918 for invoice:237748, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:36:01','',''),('5','173',4420335,'','supplier','217',0.00,27725.00,'Payment Id 360918 for invoice:237748, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:36:01','',''),('5','173',4420652,'','2','3228',267250.00,0.00,'Payment Id 360923 for invoice:237751, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:51:47','',''),('5','173',4420653,'','supplier','217',0.00,267250.00,'Payment Id 360923 for invoice:237751, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:51:47','',''),('5','173',4420656,'','6.1','3178',26025.00,0.00,'Payment Id 360924 for invoice:237751, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:51:59','',''),('5','173',4420657,'','supplier','217',0.00,26025.00,'Payment Id 360924 for invoice:237751, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:51:59','',''),('5','173',4420700,'','2','3228',270500.00,0.00,'Payment Id 360927 for invoice:237752, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:54:06','',''),('5','173',4420701,'','supplier','217',0.00,270500.00,'Payment Id 360927 for invoice:237752, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:54:06','',''),('5','173',4420704,'','6.1','3178',20025.00,0.00,'Payment Id 360928 for invoice:237752, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:54:16','',''),('5','173',4420705,'','supplier','217',0.00,20025.00,'Payment Id 360928 for invoice:237752, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2021-12-22 13:54:16','',''),('5','173',4420795,'','2','3228',251100.00,0.00,'Payment Id 360929 for invoice:237754, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-22 14:00:48','',''),('5','173',4420796,'','supplier','217',0.00,251100.00,'Payment Id 360929 for invoice:237754, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-22 14:00:48','',''),('5','173',4420832,'','6.1','3178',16025.00,0.00,'Payment Id 360930 for invoice:237754, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-22 14:01:16','',''),('5','173',4420833,'','supplier','217',0.00,16025.00,'Payment Id 360930 for invoice:237754, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-22 14:01:16','',''),('5','173',4435206,'','2','3228',216850.00,0.00,'Payment Id 358659 for invoice:236360, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:25:45','',''),('5','173',4435207,'','supplier','217',0.00,216850.00,'Payment Id 358659 for invoice:236360, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:25:45','',''),('5','173',4435252,'','6.1','3178',12575.00,0.00,'Payment Id 358660 for invoice:236360, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:27:31','',''),('5','173',4435253,'','supplier','217',0.00,12575.00,'Payment Id 358660 for invoice:236360, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:27:31','',''),('5','173',4435315,'','2','3228',159400.00,0.00,'Payment Id 358662 for invoice:237730, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:29:43','',''),('5','173',4435316,'','supplier','217',0.00,159400.00,'Payment Id 358662 for invoice:237730, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:29:43','',''),('5','173',4435355,'','6.1','3178',16025.00,0.00,'Payment Id 358663 for invoice:237730, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:30:04','',''),('5','173',4435356,'','supplier','217',0.00,16025.00,'Payment Id 358663 for invoice:237730, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:30:04','',''),('5','173',4435388,'','2','3228',335200.00,0.00,'Payment Id 358665 for invoice:237733, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:31:23','',''),('5','173',4435389,'','supplier','217',0.00,335200.00,'Payment Id 358665 for invoice:237733, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:31:23','',''),('5','173',4435398,'','6.1','3178',16025.00,0.00,'Payment Id 358666 for invoice:237733, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:31:38','',''),('5','173',4435399,'','supplier','217',0.00,16025.00,'Payment Id 358666 for invoice:237733, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:31:38','',''),('5','173',4435436,'','2','3228',160800.00,0.00,'Payment Id 358667 for invoice:237741, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:33:08','',''),('5','173',4435437,'','supplier','217',0.00,160800.00,'Payment Id 358667 for invoice:237741, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:33:08','',''),('5','173',4435448,'','6.1','3178',20025.00,0.00,'Payment Id 358668 for invoice:237741, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:33:33','',''),('5','173',4435449,'','supplier','217',0.00,20025.00,'Payment Id 358668 for invoice:237741, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2021-12-23 13:33:33','',''),('5','173',4436995,'','24','3181',0.00,2475000.00,'Purchase Id 87867 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-23 14:33:40','',''),('5','173',4436996,'','supplier','217',2475000.00,0.00,'Purchase Id 87867 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-23 14:33:40','',''),('5','173',4441280,'','20','3177',481953.45,0.00,'Sales from shift 248027 on 2021-12-23 18:06:48 ','2021-12-23 18:06:48','',''),('5','173',4441281,'','6.1','3178',0.00,481953.45,'Sales from shift 248027 on 2021-12-23 18:06:48 ','2021-12-23 18:06:48','',''),('5','173',4444514,'','20','3177',644204.55,0.00,'Sales from shift 248351 on 2021-12-24 08:11:50 ','2021-12-24 08:11:50','',''),('5','173',4444515,'','6.1','3178',0.00,644204.55,'Sales from shift 248351 on 2021-12-24 08:11:50 ','2021-12-24 08:11:50','',''),('5','173',4468750,'','20','3177',410450.70,0.00,'Sales from shift 248504 on 2021-12-25 14:08:28 ','2021-12-25 14:08:28','',''),('5','173',4468751,'','6.1','3178',0.00,410450.70,'Sales from shift 248504 on 2021-12-25 14:08:28 ','2021-12-25 14:08:28','',''),('5','173',4486775,'','20','3177',466158.00,0.00,'Sales from shift 248814 on 2021-12-27 12:17:59 ','2021-12-27 12:17:59','',''),('5','173',4486776,'','6.1','3178',0.00,466158.00,'Sales from shift 248814 on 2021-12-27 12:17:59 ','2021-12-27 12:17:59','',''),('5','173',4490781,'','20','3177',318542.40,0.00,'Sales from shift 249241 on 2021-12-27 18:20:36 ','2021-12-27 18:20:36','',''),('5','173',4490782,'','6.1','3178',0.00,318542.40,'Sales from shift 249241 on 2021-12-27 18:20:36 ','2021-12-27 18:20:36','',''),('5','173',4504500,'','20','3177',0.00,0.00,'Sales from shift 249383 on 2021-12-29 08:42:53 ','2021-12-29 08:42:53','',''),('5','173',4504501,'','6.1','3178',0.00,0.00,'Sales from shift 249383 on 2021-12-29 08:42:53 ','2021-12-29 08:42:53','',''),('5','173',4517809,'','20','3177',0.00,0.00,'Sales from shift 249732 on 2021-12-30 08:56:22 ','2021-12-30 08:56:22','',''),('5','173',4517810,'','6.1','3178',0.00,0.00,'Sales from shift 249732 on 2021-12-30 08:56:22 ','2021-12-30 08:56:22','',''),('5','173',4532462,'','20','3177',0.00,0.00,'Sales from shift 250013 on 2021-12-31 08:43:50 ','2021-12-31 08:43:50','',''),('5','173',4532463,'','6.1','3178',0.00,0.00,'Sales from shift 250013 on 2021-12-31 08:43:50 ','2021-12-31 08:43:50','',''),('5','173',4545323,'','20','3177',0.00,0.00,'Sales from shift 250281 on 2022-01-01 08:42:12 ','2022-01-01 08:42:12','',''),('5','173',4545324,'','6.1','3178',0.00,0.00,'Sales from shift 250281 on 2022-01-01 08:42:12 ','2022-01-01 08:42:12','',''),('5','173',4556231,'','20','3177',0.00,0.00,'Sales from shift 250482 on 2022-01-02 09:30:14 ','2022-01-02 09:30:14','',''),('5','173',4556232,'','6.1','3178',0.00,0.00,'Sales from shift 250482 on 2022-01-02 09:30:14 ','2022-01-02 09:30:14','',''),('5','173',4567020,'','20','3177',0.00,0.00,'Sales from shift 250705 on 2022-01-03 10:16:08 ','2022-01-03 10:16:08','',''),('5','173',4567021,'','6.1','3178',0.00,0.00,'Sales from shift 250705 on 2022-01-03 10:16:08 ','2022-01-03 10:16:08','',''),('5','173',4576809,'','20','3177',0.00,0.00,'Sales from shift 250883 on 2022-01-04 08:30:04 ','2022-01-04 08:30:04','',''),('5','173',4576810,'','6.1','3178',0.00,0.00,'Sales from shift 250883 on 2022-01-04 08:30:04 ','2022-01-04 08:30:04','',''),('5','173',4594500,'','20','3177',0.00,0.00,'Sales from shift 251254 on 2022-01-05 11:36:58 ','2022-01-05 11:36:58','',''),('5','173',4594501,'','6.1','3178',0.00,0.00,'Sales from shift 251254 on 2022-01-05 11:36:58 ','2022-01-05 11:36:58','',''),('5','173',4622131,'','20','3177',0.00,0.00,'Sales from shift 251381 on 2022-01-07 11:43:02 ','2022-01-07 11:43:02','',''),('5','173',4622132,'','6.1','3178',0.00,0.00,'Sales from shift 251381 on 2022-01-07 11:43:02 ','2022-01-07 11:43:02','',''),('5','173',4636977,'','20','3177',0.00,0.00,'Sales from shift 251927 on 2022-01-08 13:23:54 ','2022-01-08 13:23:54','',''),('5','173',4636978,'','6.1','3178',0.00,0.00,'Sales from shift 251927 on 2022-01-08 13:23:54 ','2022-01-08 13:23:54','',''),('5','173',4646757,'','20','3177',0.00,0.00,'Sales from shift 252221 on 2022-01-09 09:55:09 ','2022-01-09 09:55:09','',''),('5','173',4646758,'','6.1','3178',0.00,0.00,'Sales from shift 252221 on 2022-01-09 09:55:09 ','2022-01-09 09:55:09','',''),('5','173',4659491,'','20','3177',0.00,0.00,'Sales from shift 252420 on 2022-01-10 09:42:24 ','2022-01-10 09:42:24','',''),('5','173',4659492,'','6.1','3178',0.00,0.00,'Sales from shift 252420 on 2022-01-10 09:42:24 ','2022-01-10 09:42:24','',''),('5','173',4673313,'','24','3181',0.00,4174500.00,'Purchase Id 89239 for 25,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-11 09:25:27','',''),('5','173',4673314,'','supplier','217',4174500.00,0.00,'Purchase Id 89239 for 25,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-11 09:25:27','',''),('5','173',4674079,'','20','3177',1225986.30,0.00,'Sales from shift 252595 on 2022-01-11 10:06:33 ','2022-01-11 10:06:33','',''),('5','173',4674080,'','6.1','3178',0.00,1225986.30,'Sales from shift 252595 on 2022-01-11 10:06:33 ','2022-01-11 10:06:33','',''),('5','173',4680171,'','20','3177',732446.55,0.00,'Sales from shift 252814 on 2022-01-11 15:00:50 ','2022-01-11 15:00:50','',''),('5','173',4680172,'','6.1','3178',0.00,732446.55,'Sales from shift 252814 on 2022-01-11 15:00:50 ','2022-01-11 15:00:50','',''),('5','173',4702505,'','20','3177',765666.00,0.00,'Sales from shift 252903 on 2022-01-13 09:12:28 ','2022-01-13 09:12:28','',''),('5','173',4702506,'','6.1','3178',0.00,765666.00,'Sales from shift 252903 on 2022-01-13 09:12:28 ','2022-01-13 09:12:28','',''),('5','173',4705176,'','20','3177',620733.30,0.00,'Sales from shift 253311 on 2022-01-13 11:17:28 ','2022-01-13 11:17:28','',''),('5','173',4705177,'','6.1','3178',0.00,620733.30,'Sales from shift 253311 on 2022-01-13 11:17:28 ','2022-01-13 11:17:28','',''),('5','173',4717073,'','20','3177',362970.30,0.00,'Sales from shift 253414 on 2022-01-14 09:53:24 ','2022-01-14 09:53:24','',''),('5','173',4717074,'','6.1','3178',0.00,362970.30,'Sales from shift 253414 on 2022-01-14 09:53:24 ','2022-01-14 09:53:24','',''),('5','173',4718701,'','2','3228',860.00,0.00,'Payment Id 392834 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 11:12:19','',''),('5','173',4718702,'','supplier','217',0.00,860.00,'Payment Id 392834 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 11:12:19','',''),('5','173',4718777,'','2','3228',0.00,860.00,'Payment Id 392834 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 11:14:54','',''),('5','173',4718778,'','supplier','217',860.00,0.00,'Payment Id 392834 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 11:14:54','',''),('5','173',4720994,'','2','3228',52540.00,0.00,'Payment Id 392893 for invoice:237759, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:35:06','',''),('5','173',4720995,'','supplier','217',0.00,52540.00,'Payment Id 392893 for invoice:237759, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:35:06','',''),('5','173',4721012,'','6.1','3178',140510.00,0.00,'Payment Id 392895 for invoice:237759, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:36:35','',''),('5','173',4721013,'','supplier','217',0.00,140510.00,'Payment Id 392895 for invoice:237759, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:36:35','',''),('5','173',4721016,'','2','3228',72550.00,0.00,'Payment Id 392899 for invoice:237761, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:36:56','',''),('5','173',4721017,'','supplier','217',0.00,72550.00,'Payment Id 392899 for invoice:237761, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:36:56','',''),('5','173',4721020,'','6.1','3178',15531.00,0.00,'Payment Id 392902 for invoice:237761, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:14','',''),('5','173',4721021,'','supplier','217',0.00,15531.00,'Payment Id 392902 for invoice:237761, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:14','',''),('5','173',4721030,'','2','3228',346030.00,0.00,'Payment Id 392912 for invoice:230341, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:31','',''),('5','173',4721031,'','supplier','217',0.00,346030.00,'Payment Id 392912 for invoice:230341, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:31','',''),('5','173',4721032,'','6.1','3178',15520.00,0.00,'Payment Id 392915 for invoice:240341, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:45','',''),('5','173',4721033,'','supplier','217',0.00,15520.00,'Payment Id 392915 for invoice:240341, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:37:45','',''),('5','173',4721036,'','2','3228',251160.00,0.00,'Payment Id 392917 for invoice:241811, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:38:24','',''),('5','173',4721037,'','supplier','217',0.00,251160.00,'Payment Id 392917 for invoice:241811, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:38:24','',''),('5','173',4721052,'','6.1','3178',15990.00,0.00,'Payment Id 392942 for invoice:241811, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:40:07','',''),('5','173',4721053,'','supplier','217',0.00,15990.00,'Payment Id 392942 for invoice:241811, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:40:07','',''),('5','173',4721058,'','2','3228',469400.00,0.00,'Payment Id 392945 for invoice:242198, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:40:35','',''),('5','173',4721059,'','supplier','217',0.00,469400.00,'Payment Id 392945 for invoice:242198, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:40:35','',''),('5','173',4721072,'','6.1','3178',35999.00,0.00,'Payment Id 392946 for invoice:242198, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:14','',''),('5','173',4721073,'','supplier','217',0.00,35999.00,'Payment Id 392946 for invoice:242198, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:14','',''),('5','173',4721082,'','2','3228',182900.00,0.00,'Payment Id 392948 for invoice:242461, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:34','',''),('5','173',4721083,'','supplier','217',0.00,182900.00,'Payment Id 392948 for invoice:242461, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:34','',''),('5','173',4721091,'','6.1','3178',51593.00,0.00,'Payment Id 392951 for invoice:242461, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:49','',''),('5','173',4721092,'','supplier','217',0.00,51593.00,'Payment Id 392951 for invoice:242461, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:41:49','',''),('5','173',4721095,'','2','3228',215300.00,0.00,'Payment Id 392954 for invoice:242614, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:06','',''),('5','173',4721096,'','supplier','217',0.00,215300.00,'Payment Id 392954 for invoice:242614, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:06','',''),('5','173',4721099,'','6.1','3178',12593.00,0.00,'Payment Id 392955 for invoice:242614, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:20','',''),('5','173',4721100,'','supplier','217',0.00,12593.00,'Payment Id 392955 for invoice:242614, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:20','',''),('5','173',4721103,'','2','3228',248350.00,0.00,'Payment Id 392956 for invoice:242787, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:35','',''),('5','173',4721104,'','supplier','217',0.00,248350.00,'Payment Id 392956 for invoice:242787, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:35','',''),('5','173',4721108,'','6.1','3178',12555.00,0.00,'Payment Id 392957 for invoice:242787, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:49','',''),('5','173',4721109,'','supplier','217',0.00,12555.00,'Payment Id 392957 for invoice:242787, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:42:49','',''),('5','173',4721110,'','2','3228',282250.00,0.00,'Payment Id 392960 for invoice:247018, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:09','',''),('5','173',4721111,'','supplier','217',0.00,282250.00,'Payment Id 392960 for invoice:247018, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:09','',''),('5','173',4721114,'','6.1','3178',12550.00,0.00,'Payment Id 392961 for invoice:247018, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:35','',''),('5','173',4721115,'','supplier','217',0.00,12550.00,'Payment Id 392961 for invoice:247018, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:35','',''),('5','173',4721116,'','2','3228',324600.00,0.00,'Payment Id 392963 for invoice:247308, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:51','',''),('5','173',4721117,'','supplier','217',0.00,324600.00,'Payment Id 392963 for invoice:247308, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:43:51','',''),('5','173',4721126,'','6.1','3178',12575.00,0.00,'Payment Id 392965 for invoice:247308, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:19','',''),('5','173',4721127,'','supplier','217',0.00,12575.00,'Payment Id 392965 for invoice:247308, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:19','',''),('5','173',4721132,'','2','3228',267050.00,0.00,'Payment Id 392966 for invoice:247501, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:35','',''),('5','173',4721133,'','supplier','217',0.00,267050.00,'Payment Id 392966 for invoice:247501, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:35','',''),('5','173',4721138,'','6.1','3178',12075.00,0.00,'Payment Id 392967 for invoice:247501, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:53','',''),('5','173',4721139,'','supplier','217',0.00,12075.00,'Payment Id 392967 for invoice:247501, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:44:53','',''),('5','173',4721144,'','2','3228',205400.00,0.00,'Payment Id 392968 for invoice:247509, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:09','',''),('5','173',4721145,'','supplier','217',0.00,205400.00,'Payment Id 392968 for invoice:247509, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:09','',''),('5','173',4721148,'','6.1','3178',22575.00,0.00,'Payment Id 392969 for invoice:247509, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:26','',''),('5','173',4721149,'','supplier','217',0.00,22575.00,'Payment Id 392969 for invoice:247509, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:26','',''),('5','173',4721153,'','2','3228',248800.00,0.00,'Payment Id 392971 for invoice:247511, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:40','',''),('5','173',4721154,'','supplier','217',0.00,248800.00,'Payment Id 392971 for invoice:247511, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:40','',''),('5','173',4721157,'','6.1','3178',12565.00,0.00,'Payment Id 392972 for invoice:247511, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:53','',''),('5','173',4721158,'','supplier','217',0.00,12565.00,'Payment Id 392972 for invoice:247511, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:45:53','',''),('5','173',4721161,'','2','3228',249800.00,0.00,'Payment Id 392979 for invoice:247514, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:06','',''),('5','173',4721162,'','supplier','217',0.00,249800.00,'Payment Id 392979 for invoice:247514, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:06','',''),('5','173',4721163,'','6.1','3178',24275.00,0.00,'Payment Id 392980 for invoice:247514, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:18','',''),('5','173',4721164,'','supplier','217',0.00,24275.00,'Payment Id 392980 for invoice:247514, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:18','',''),('5','173',4721173,'','2','3228',236500.00,0.00,'Payment Id 392982 for invoice:247515, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:28','',''),('5','173',4721174,'','supplier','217',0.00,236500.00,'Payment Id 392982 for invoice:247515, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:28','',''),('5','173',4721177,'','6.1','3178',12585.00,0.00,'Payment Id 392983 for invoice:247515, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:37','',''),('5','173',4721178,'','supplier','217',0.00,12585.00,'Payment Id 392983 for invoice:247515, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:37','',''),('5','173',4721181,'','2','3228',327700.00,0.00,'Payment Id 392986 for invoice:247516, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:47','',''),('5','173',4721182,'','supplier','217',0.00,327700.00,'Payment Id 392986 for invoice:247516, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:47','',''),('5','173',4721183,'','6.1','3178',22565.00,0.00,'Payment Id 392987 for invoice:247516, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:58','',''),('5','173',4721184,'','supplier','217',0.00,22565.00,'Payment Id 392987 for invoice:247516, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:46:58','',''),('5','173',4721187,'','2','3228',243100.00,0.00,'Payment Id 392989 for invoice:247517, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:10','',''),('5','173',4721188,'','supplier','217',0.00,243100.00,'Payment Id 392989 for invoice:247517, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:10','',''),('5','173',4721191,'','6.1','3178',12075.00,0.00,'Payment Id 392991 for invoice:247517, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:20','',''),('5','173',4721192,'','supplier','217',0.00,12075.00,'Payment Id 392991 for invoice:247517, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:20','',''),('5','173',4721193,'','2','3228',249900.00,0.00,'Payment Id 392992 for invoice:247519, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:30','',''),('5','173',4721194,'','supplier','217',0.00,249900.00,'Payment Id 392992 for invoice:247519, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:30','',''),('5','173',4721197,'','6.1','3178',12085.00,0.00,'Payment Id 392993 for invoice:247519, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:42','',''),('5','173',4721198,'','supplier','217',0.00,12085.00,'Payment Id 392993 for invoice:247519, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:42','',''),('5','173',4721199,'','2','3228',259300.00,0.00,'Payment Id 392999 for invoice:247521, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:52','',''),('5','173',4721200,'','supplier','217',0.00,259300.00,'Payment Id 392999 for invoice:247521, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:47:52','',''),('5','173',4721207,'','6.1','3178',12540.00,0.00,'Payment Id 393000 for invoice:247521, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:07','',''),('5','173',4721208,'','supplier','217',0.00,12540.00,'Payment Id 393000 for invoice:247521, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:07','',''),('5','173',4721211,'','2','3228',41500.00,0.00,'Payment Id 393002 for invoice:247523, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:16','',''),('5','173',4721212,'','supplier','217',0.00,41500.00,'Payment Id 393002 for invoice:247523, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:16','',''),('5','173',4721215,'','6.1','3178',297545.00,0.00,'Payment Id 393003 for invoice:247523, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:31','',''),('5','173',4721216,'','supplier','217',0.00,297545.00,'Payment Id 393003 for invoice:247523, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:31','',''),('5','173',4721221,'','2','3228',223850.00,0.00,'Payment Id 393005 for invoice:247524, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:42','',''),('5','173',4721222,'','supplier','217',0.00,223850.00,'Payment Id 393005 for invoice:247524, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:42','',''),('5','173',4721223,'','6.1','3178',12575.00,0.00,'Payment Id 393007 for invoice:247524, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:51','',''),('5','173',4721224,'','supplier','217',0.00,12575.00,'Payment Id 393007 for invoice:247524, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:48:51','',''),('5','173',4721227,'','2','3228',268000.00,0.00,'Payment Id 393011 for invoice:247527, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:03','',''),('5','173',4721228,'','supplier','217',0.00,268000.00,'Payment Id 393011 for invoice:247527, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:03','',''),('5','173',4721229,'','6.1','3178',22580.00,0.00,'Payment Id 393012 for invoice:247527, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:14','',''),('5','173',4721230,'','supplier','217',0.00,22580.00,'Payment Id 393012 for invoice:247527, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:14','',''),('5','173',4721235,'','2','3228',193000.00,0.00,'Payment Id 393013 for invoice:247528, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:25','',''),('5','173',4721236,'','supplier','217',0.00,193000.00,'Payment Id 393013 for invoice:247528, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:25','',''),('5','173',4721243,'','6.1','3178',45955.00,0.00,'Payment Id 393015 for invoice:247528, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:47','',''),('5','173',4721244,'','supplier','217',0.00,45955.00,'Payment Id 393015 for invoice:247528, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:47','',''),('5','173',4721247,'','2','3228',232400.00,0.00,'Payment Id 393016 for invoice:247529, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:58','',''),('5','173',4721248,'','supplier','217',0.00,232400.00,'Payment Id 393016 for invoice:247529, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:49:58','',''),('5','173',4721252,'','6.1','3178',12110.00,0.00,'Payment Id 393018 for invoice:247529, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:50:08','',''),('5','173',4721253,'','supplier','217',0.00,12110.00,'Payment Id 393018 for invoice:247529, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-14 13:50:08','',''),('5','173',4721508,'','2','3228',85200.00,0.00,'Payment Id 393025 for invoice:247531, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:04:47','',''),('5','173',4721509,'','supplier','217',0.00,85200.00,'Payment Id 393025 for invoice:247531, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:04:47','',''),('5','173',4721510,'','2','3228',469400.00,0.00,'Payment Id 393027 for invoice:248351, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:04:57','',''),('5','173',4721511,'','supplier','217',0.00,469400.00,'Payment Id 393027 for invoice:248351, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:04:57','',''),('5','173',4721518,'','6.1','3178',12555.00,0.00,'Payment Id 393028 for invoice:248027, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:05:18','',''),('5','173',4721519,'','supplier','217',0.00,12555.00,'Payment Id 393028 for invoice:248027, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:05:18','',''),('5','173',4721526,'','2','3228',391600.00,0.00,'Payment Id 393029 for invoice:248351, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:05:39','',''),('5','173',4721527,'','supplier','217',0.00,391600.00,'Payment Id 393029 for invoice:248351, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:05:39','',''),('5','173',4721531,'','6.1','3178',252594.00,0.00,'Payment Id 393031 for invoice:248351, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:06:00','',''),('5','173',4721532,'','supplier','217',0.00,252594.00,'Payment Id 393031 for invoice:248351, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:06:00','',''),('5','173',4721533,'','2','3228',392900.00,0.00,'Payment Id 393032 for invoice:248504, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:06:27','',''),('5','173',4721534,'','supplier','217',0.00,392900.00,'Payment Id 393032 for invoice:248504, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:06:27','',''),('5','173',4721545,'','6.1','3178',17550.00,0.00,'Payment Id 393034 for invoice:248504, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:07:40','',''),('5','173',4721546,'','supplier','217',0.00,17550.00,'Payment Id 393034 for invoice:248504, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:07:40','',''),('5','173',4721563,'','2','3228',451100.00,0.00,'Payment Id 393035 for invoice:248814, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:08:53','',''),('5','173',4721564,'','supplier','217',0.00,451100.00,'Payment Id 393035 for invoice:248814, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:08:53','',''),('5','173',4721571,'','6.1','3178',15060.00,0.00,'Payment Id 393037 for invoice:248814, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:09:29','',''),('5','173',4721572,'','supplier','217',0.00,15060.00,'Payment Id 393037 for invoice:248814, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-14 14:09:29','',''),('5','173',4732375,'','20','3177',260848.50,0.00,'Sales from shift 253560 on 2022-01-15 10:55:54 ','2022-01-15 10:55:54','',''),('5','173',4732376,'','6.1','3178',0.00,260848.50,'Sales from shift 253560 on 2022-01-15 10:55:54 ','2022-01-15 10:55:54','',''),('5','173',4759354,'','20','3177',85800.00,0.00,'Sales from shift 253814 on 2022-01-17 09:14:18 ','2022-01-17 09:14:18','',''),('5','173',4759355,'','6.1','3178',0.00,85800.00,'Sales from shift 253814 on 2022-01-17 09:14:18 ','2022-01-17 09:14:18','',''),('5','173',4760260,'','2','3228',206500.00,0.00,'Payment Id 393466 for invoice:249241, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:14','',''),('5','173',4760261,'','supplier','217',0.00,206500.00,'Payment Id 393466 for invoice:249241, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:14','',''),('5','173',4760267,'','6.1','3178',112045.00,0.00,'Payment Id 393467 for invoice:249241, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:27','',''),('5','173',4760268,'','supplier','217',0.00,112045.00,'Payment Id 393467 for invoice:249241, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:27','',''),('5','173',4760271,'','2','3228',937300.00,0.00,'Payment Id 393838 for invoice:252595, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:39','',''),('5','173',4760272,'','supplier','217',0.00,937300.00,'Payment Id 393838 for invoice:252595, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:10:39','',''),('5','173',4760277,'','6.1','3178',288685.00,0.00,'Payment Id 393840 for invoice:2252595, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:05','',''),('5','173',4760278,'','supplier','217',0.00,288685.00,'Payment Id 393840 for invoice:2252595, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:05','',''),('5','173',4760285,'','2','3228',699900.00,0.00,'Payment Id 393841 for invoice:252814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:14','',''),('5','173',4760286,'','supplier','217',0.00,699900.00,'Payment Id 393841 for invoice:252814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:14','',''),('5','173',4760291,'','6.1','3178',32550.00,0.00,'Payment Id 393842 for invoice:252814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:28','',''),('5','173',4760292,'','supplier','217',0.00,32550.00,'Payment Id 393842 for invoice:252814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:28','',''),('5','173',4760299,'','2','3228',700400.00,0.00,'Payment Id 393847 for invoice:252903, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:42','',''),('5','173',4760300,'','supplier','217',0.00,700400.00,'Payment Id 393847 for invoice:252903, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:42','',''),('5','173',4760305,'','6.1','3178',65265.00,0.00,'Payment Id 393848 for invoice:252903, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:51','',''),('5','173',4760306,'','supplier','217',0.00,65265.00,'Payment Id 393848 for invoice:252903, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:11:51','',''),('5','173',4760316,'','2','3228',588200.00,0.00,'Payment Id 393849 for invoice:253311, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:01','',''),('5','173',4760317,'','supplier','217',0.00,588200.00,'Payment Id 393849 for invoice:253311, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:01','',''),('5','173',4760320,'','6.1','3178',32540.00,0.00,'Payment Id 393850 for invoice:253311, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:12','',''),('5','173',4760321,'','supplier','217',0.00,32540.00,'Payment Id 393850 for invoice:253311, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:12','',''),('5','173',4760324,'','2','3228',350400.00,0.00,'Payment Id 393853 for invoice:253414, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:24','',''),('5','173',4760325,'','supplier','217',0.00,350400.00,'Payment Id 393853 for invoice:253414, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:24','',''),('5','173',4760332,'','6.1','3178',12570.00,0.00,'Payment Id 393856 for invoice:253414, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:46','',''),('5','173',4760333,'','supplier','217',0.00,12570.00,'Payment Id 393856 for invoice:253414, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-01-17 10:12:46','',''),('5','173',4770822,'','20','3177',167479.95,0.00,'Sales from shift 254377 on 2022-01-17 21:24:01 ','2022-01-17 21:24:01','',''),('5','173',4770823,'','6.1','3178',0.00,167479.95,'Sales from shift 254377 on 2022-01-17 21:24:01 ','2022-01-17 21:24:01','',''),('5','173',4777874,'','20','3177',0.00,0.00,'Sales from shift 254419 on 2022-01-18 13:30:13 ','2022-01-18 13:30:13','',''),('5','173',4777875,'','6.1','3178',0.00,0.00,'Sales from shift 254419 on 2022-01-18 13:30:13 ','2022-01-18 13:30:13','',''),('5','173',4788302,'','20','3177',0.00,0.00,'Sales from shift 254572 on 2022-01-19 09:52:49 ','2022-01-19 09:52:49','',''),('5','173',4788303,'','6.1','3178',0.00,0.00,'Sales from shift 254572 on 2022-01-19 09:52:49 ','2022-01-19 09:52:49','',''),('5','173',4803503,'','20','3177',0.00,0.00,'Sales from shift 254813 on 2022-01-20 09:45:07 ','2022-01-20 09:45:07','',''),('5','173',4803504,'','6.1','3178',0.00,0.00,'Sales from shift 254813 on 2022-01-20 09:45:07 ','2022-01-20 09:45:07','',''),('5','173',4808667,'','2','3228',248400.00,0.00,'Payment Id 396231 for invoice:253560, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-20 13:50:23','',''),('5','173',4808668,'','supplier','217',0.00,248400.00,'Payment Id 396231 for invoice:253560, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-20 13:50:23','',''),('5','173',4818840,'','20','3177',107664.15,0.00,'Sales from shift 255020 on 2022-01-21 09:58:56 ','2022-01-21 09:58:56','',''),('5','173',4818841,'','6.1','3178',0.00,107664.15,'Sales from shift 255020 on 2022-01-21 09:58:56 ','2022-01-21 09:58:56','',''),('5','173',4818854,'','24','3181',0.00,2442000.00,'Purchase Id 90020 for 14,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-21 09:59:12','',''),('5','173',4818855,'','supplier','217',2442000.00,0.00,'Purchase Id 90020 for 14,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-21 09:59:12','',''),('5','173',4848381,'','20','3177',505696.95,0.00,'Sales from shift 255301 on 2022-01-23 09:04:13 ','2022-01-23 09:04:13','',''),('5','173',4848382,'','6.1','3178',0.00,505696.95,'Sales from shift 255301 on 2022-01-23 09:04:13 ','2022-01-23 09:04:13','',''),('5','173',4857324,'','20','3177',501502.65,0.00,'Sales from shift 255754 on 2022-01-23 16:28:50 ','2022-01-23 16:28:50','',''),('5','173',4857325,'','6.1','3178',0.00,501502.65,'Sales from shift 255754 on 2022-01-23 16:28:50 ','2022-01-23 16:28:50','',''),('5','173',4875796,'','20','3177',256588.20,0.00,'Sales from shift 255906 on 2022-01-25 09:11:10 ','2022-01-25 09:11:10','',''),('5','173',4875797,'','6.1','3178',0.00,256588.20,'Sales from shift 255906 on 2022-01-25 09:11:10 ','2022-01-25 09:11:10','',''),('5','173',4884344,'','20','3177',380285.40,0.00,'Sales from shift 256342 on 2022-01-25 15:22:29 ','2022-01-25 15:22:29','',''),('5','173',4884345,'','6.1','3178',0.00,380285.40,'Sales from shift 256342 on 2022-01-25 15:22:29 ','2022-01-25 15:22:29','',''),('5','173',4892404,'','20','3177',342985.50,0.00,'Sales from shift 256381 on 2022-01-26 09:04:46 ','2022-01-26 09:04:46','',''),('5','173',4892405,'','6.1','3178',0.00,342985.50,'Sales from shift 256381 on 2022-01-26 09:04:46 ','2022-01-26 09:04:46','',''),('5','173',4907109,'','20','3177',198052.80,0.00,'Sales from shift 256590 on 2022-01-27 10:04:50 ','2022-01-27 10:04:50','',''),('5','173',4907110,'','6.1','3178',0.00,198052.80,'Sales from shift 256590 on 2022-01-27 10:04:50 ','2022-01-27 10:04:50','',''),('5','173',4924004,'','20','3177',0.00,0.00,'Sales from shift 256893 on 2022-01-28 10:48:19 ','2022-01-28 10:48:19','',''),('5','173',4924005,'','6.1','3178',0.00,0.00,'Sales from shift 256893 on 2022-01-28 10:48:19 ','2022-01-28 10:48:19','',''),('5','173',4927438,'','2','3228',73700.00,0.00,'Payment Id 400280 for invoice:253814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:42:09','',''),('5','173',4927439,'','supplier','217',0.00,73700.00,'Payment Id 400280 for invoice:253814, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:42:09','',''),('5','173',4927450,'','6.1','3178',12075.00,0.00,'Payment Id 400285 for invoice:253814, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:43:14','',''),('5','173',4927451,'','supplier','217',0.00,12075.00,'Payment Id 400285 for invoice:253814, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:43:14','',''),('5','173',4927462,'','2','3228',92330.00,0.00,'Payment Id 400295 for invoice:255020, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:44:28','',''),('5','173',4927463,'','supplier','217',0.00,92330.00,'Payment Id 400295 for invoice:255020, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:44:28','',''),('5','173',4927486,'','6.1','3178',15250.00,0.00,'Payment Id 400299 for invoice:255020, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:46:00','',''),('5','173',4927487,'','supplier','217',0.00,15250.00,'Payment Id 400299 for invoice:255020, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:46:00','',''),('5','173',4927510,'','2','3228',493450.00,0.00,'Payment Id 400302 for invoice:255301, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:47:59','',''),('5','173',4927511,'','supplier','217',0.00,493450.00,'Payment Id 400302 for invoice:255301, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:47:59','',''),('5','173',4927514,'','6.1','3178',12250.00,0.00,'Payment Id 400307 for invoice:255301, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:48:20','',''),('5','173',4927515,'','supplier','217',0.00,12250.00,'Payment Id 400307 for invoice:255301, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:48:20','',''),('5','173',4927531,'','2','3228',489250.00,0.00,'Payment Id 400311 for invoice:255754, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:49:18','',''),('5','173',4927532,'','supplier','217',0.00,489250.00,'Payment Id 400311 for invoice:255754, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:49:18','',''),('5','173',4927537,'','6.1','3178',12250.00,0.00,'Payment Id 400312 for invoice:255754, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:49:37','',''),('5','173',4927538,'','supplier','217',0.00,12250.00,'Payment Id 400312 for invoice:255754, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:49:37','',''),('5','173',4927549,'','2','3228',233360.00,0.00,'Payment Id 400315 for invoice:255906, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:50:39','',''),('5','173',4927550,'','supplier','217',0.00,233360.00,'Payment Id 400315 for invoice:255906, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:50:39','',''),('5','173',4927573,'','6.1','3178',23230.00,0.00,'Payment Id 400316 for invoice:255906, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:52:27','',''),('5','173',4927574,'','supplier','217',0.00,23230.00,'Payment Id 400316 for invoice:255906, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:52:27','',''),('5','173',4927593,'','2','3228',367260.00,0.00,'Payment Id 400317 for invoice:256342, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:54:09','',''),('5','173',4927594,'','supplier','217',0.00,367260.00,'Payment Id 400317 for invoice:256342, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:54:09','',''),('5','173',4927595,'','6.1','3178',12925.00,0.00,'Payment Id 400318 for invoice:256342, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:54:32','',''),('5','173',4927596,'','supplier','217',0.00,12925.00,'Payment Id 400318 for invoice:256342, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:54:32','',''),('5','173',4927617,'','2','3228',329770.00,0.00,'Payment Id 400319 for invoice:256381, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:55:24','',''),('5','173',4927618,'','supplier','217',0.00,329770.00,'Payment Id 400319 for invoice:256381, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:55:24','',''),('5','173',4927625,'','6.1','3178',12925.00,0.00,'Payment Id 400321 for invoice:256381, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:56:07','',''),('5','173',4927626,'','supplier','217',0.00,12925.00,'Payment Id 400321 for invoice:256381, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:56:07','',''),('5','173',4927629,'','2','3228',185000.00,0.00,'Payment Id 400322 for invoice:256590, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:56:49','',''),('5','173',4927630,'','supplier','217',0.00,185000.00,'Payment Id 400322 for invoice:256590, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:56:49','',''),('5','173',4927641,'','6.1','3178',12925.00,0.00,'Payment Id 400325 for invoice:256590, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:57:17','',''),('5','173',4927642,'','supplier','217',0.00,12925.00,'Payment Id 400325 for invoice:256590, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-01-28 13:57:17','',''),('5','173',4942920,'','20','3177',0.00,0.00,'Sales from shift 257077 on 2022-01-29 13:26:19 ','2022-01-29 13:26:19','',''),('5','173',4942921,'','6.1','3178',0.00,0.00,'Sales from shift 257077 on 2022-01-29 13:26:19 ','2022-01-29 13:26:19','',''),('5','173',4955076,'','20','3177',0.00,0.00,'Sales from shift 257495 on 2022-01-30 10:20:14 ','2022-01-30 10:20:14','',''),('5','173',4955077,'','6.1','3178',0.00,0.00,'Sales from shift 257495 on 2022-01-30 10:20:14 ','2022-01-30 10:20:14','',''),('5','173',4955078,'','20','3177',0.00,0.00,'Sales from shift 257659 on 2022-02-01 09:11:27 ','2022-02-01 09:11:27','',''),('5','173',4955079,'','6.1','3178',0.00,0.00,'Sales from shift 257659 on 2022-02-01 09:11:27 ','2022-02-01 09:11:27','',''),('5','173',4955080,'','20','3177',0.00,0.00,'Sales from shift 257660 on 2022-02-01 11:04:17 ','2022-02-01 11:04:17','',''),('5','173',4955081,'','6.1','3178',0.00,0.00,'Sales from shift 257660 on 2022-02-01 11:04:17 ','2022-02-01 11:04:17','',''),('5','173',4955082,'','20','3177',0.00,0.00,'Sales from shift 257661 on 2022-02-03 14:02:35 ','2022-02-03 14:02:35','',''),('5','173',4955083,'','6.1','3178',0.00,0.00,'Sales from shift 257661 on 2022-02-03 14:02:35 ','2022-02-03 14:02:35','',''),('5','173',4955084,'','20','3177',249438.75,0.00,'Sales from shift 257662 on 2022-02-04 09:24:35 ','2022-02-04 09:24:35','',''),('5','173',4955085,'','6.1','3178',0.00,249438.75,'Sales from shift 257662 on 2022-02-04 09:24:35 ','2022-02-04 09:24:35','',''),('5','173',4955086,'','20','3177',268804.80,0.00,'Sales from shift 257663 on 2022-02-06 05:27:06 ','2022-02-06 05:27:06','',''),('5','173',4955087,'','6.1','3178',0.00,268804.80,'Sales from shift 257663 on 2022-02-06 05:27:06 ','2022-02-06 05:27:06','',''),('5','173',4955088,'','24','3181',0.00,4950000.00,'Purchase Id 90021 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-06 15:12:13','',''),('5','173',4955089,'','supplier','217',4950000.00,0.00,'Purchase Id 90021 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-06 15:12:13','',''),('5','173',4955090,'','20','3177',722221.50,0.00,'Sales from shift 257664 on 2022-02-06 20:23:14 ','2022-02-06 20:23:14','',''),('5','173',4955091,'','6.1','3178',0.00,722221.50,'Sales from shift 257664 on 2022-02-06 20:23:14 ','2022-02-06 20:23:14','',''),('5','173',4955092,'','20','3177',1024310.10,0.00,'Sales from shift 257666 on 2022-02-06 21:12:12 ','2022-02-06 21:12:12','',''),('5','173',4955093,'','6.1','3178',0.00,1024310.10,'Sales from shift 257666 on 2022-02-06 21:12:12 ','2022-02-06 21:12:12','',''),('5','173',4955094,'','20','3177',626184.90,0.00,'Sales from shift 257667 on 2022-02-07 15:48:33 ','2022-02-07 15:48:33','',''),('5','173',4955095,'','6.1','3178',0.00,626184.90,'Sales from shift 257667 on 2022-02-07 15:48:33 ','2022-02-07 15:48:33','',''),('5','173',4955096,'','20','3177',1410065.25,0.00,'Sales from shift 257668 on 2022-02-09 09:12:41 ','2022-02-09 09:12:41','',''),('5','173',4955097,'','6.1','3178',0.00,1410065.25,'Sales from shift 257668 on 2022-02-09 09:12:41 ','2022-02-09 09:12:41','',''),('5','173',4955098,'','24','3181',0.00,7425000.00,'Purchase Id 90022 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-09 15:26:04','',''),('5','173',4955099,'','supplier','217',7425000.00,0.00,'Purchase Id 90022 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-09 15:26:04','',''),('5','173',4955100,'','20','3177',1021909.35,0.00,'Sales from shift 257669 on 2022-02-09 15:26:19 ','2022-02-09 15:26:19','',''),('5','173',4955101,'','6.1','3178',0.00,1021909.35,'Sales from shift 257669 on 2022-02-09 15:26:19 ','2022-02-09 15:26:19','',''),('5','173',4955102,'','20','3177',1675180.65,0.00,'Sales from shift 257670 on 2022-02-10 14:18:46 ','2022-02-10 14:18:46','',''),('5','173',4955103,'','6.1','3178',0.00,1675180.65,'Sales from shift 257670 on 2022-02-10 14:18:46 ','2022-02-10 14:18:46','',''),('5','173',4955104,'','20','3177',2036639.55,0.00,'Sales from shift 257671 on 2022-02-11 09:47:07 ','2022-02-11 09:47:07','',''),('5','173',4955105,'','6.1','3178',0.00,2036639.55,'Sales from shift 257671 on 2022-02-11 09:47:07 ','2022-02-11 09:47:07','',''),('5','173',4955106,'','20','3177',1061346.00,0.00,'Sales from shift 257672 on 2022-02-12 08:48:31 ','2022-02-12 08:48:31','',''),('5','173',4955107,'','6.1','3178',0.00,1061346.00,'Sales from shift 257672 on 2022-02-12 08:48:31 ','2022-02-12 08:48:31','',''),('5','173',4955108,'','20','3177',1140907.35,0.00,'Sales from shift 257673 on 2022-02-13 09:05:03 ','2022-02-13 09:05:03','',''),('5','173',4955109,'','6.1','3178',0.00,1140907.35,'Sales from shift 257673 on 2022-02-13 09:05:03 ','2022-02-13 09:05:03','',''),('5','173',4955110,'','20','3177',819510.45,0.00,'Sales from shift 257674 on 2022-02-14 09:00:52 ','2022-02-14 09:00:52','',''),('5','173',4955111,'','6.1','3178',0.00,819510.45,'Sales from shift 257674 on 2022-02-14 09:00:52 ','2022-02-14 09:00:52','',''),('5','173',4955112,'','2','3228',233200.00,0.00,'Payment Id 400326 for invoice:257662, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:02:58','',''),('5','173',4955113,'','supplier','217',0.00,233200.00,'Payment Id 400326 for invoice:257662, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:02:58','',''),('5','173',4955114,'','6.1','3178',15540.00,0.00,'Payment Id 400327 for invoice:257662, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:03:43','',''),('5','173',4955115,'','supplier','217',0.00,15540.00,'Payment Id 400327 for invoice:257662, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:03:43','',''),('5','173',4955116,'','2','3228',244100.00,0.00,'Payment Id 400328 for invoice:257663, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:04:16','',''),('5','173',4955117,'','supplier','217',0.00,244100.00,'Payment Id 400328 for invoice:257663, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:04:16','',''),('5','173',4955118,'','6.1','3178',24705.00,0.00,'Payment Id 400329 for invoice:257663, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:05:06','',''),('5','173',4955119,'','supplier','217',0.00,24705.00,'Payment Id 400329 for invoice:257663, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:05:06','',''),('5','173',4955120,'','2','3228',608100.00,0.00,'Payment Id 400330 for invoice:257664, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:05:39','',''),('5','173',4955121,'','supplier','217',0.00,608100.00,'Payment Id 400330 for invoice:257664, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:05:39','',''),('5','173',4955122,'','6.1','3178',114120.00,0.00,'Payment Id 400331 for invoice:257664, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:06:21','',''),('5','173',4955123,'','supplier','217',0.00,114120.00,'Payment Id 400331 for invoice:257664, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:06:21','',''),('5','173',4955124,'','2','3228',1010650.00,0.00,'Payment Id 400332 for invoice:257666, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:06:51','',''),('5','173',4955125,'','supplier','217',0.00,1010650.00,'Payment Id 400332 for invoice:257666, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:06:51','',''),('5','173',4955126,'','6.1','3178',13650.00,0.00,'Payment Id 400333 for invoice:257666, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:07:35','',''),('5','173',4955127,'','supplier','217',0.00,13650.00,'Payment Id 400333 for invoice:257666, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:07:35','',''),('5','173',4955128,'','2','3228',612500.00,0.00,'Payment Id 400334 for invoice:257667, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:07:57','',''),('5','173',4955129,'','supplier','217',0.00,612500.00,'Payment Id 400334 for invoice:257667, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:07:57','',''),('5','173',4955130,'','6.1','3178',13650.00,0.00,'Payment Id 400335 for invoice:257667, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:08:26','',''),('5','173',4955131,'','supplier','217',0.00,13650.00,'Payment Id 400335 for invoice:257667, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:08:26','',''),('5','173',4955132,'','2','3228',1120915.00,0.00,'Payment Id 400336 for invoice:257668, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:08:44','',''),('5','173',4955133,'','supplier','217',0.00,1120915.00,'Payment Id 400336 for invoice:257668, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:08:44','',''),('5','173',4955134,'','6.1','3178',289150.00,0.00,'Payment Id 400337 for invoice:257668, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:04','',''),('5','173',4955135,'','supplier','217',0.00,289150.00,'Payment Id 400337 for invoice:257668, receipt: 75406727 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:04','',''),('5','173',4955136,'','2','3228',1007800.00,0.00,'Payment Id 400338 for invoice:257669, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:21','',''),('5','173',4955137,'','supplier','217',0.00,1007800.00,'Payment Id 400338 for invoice:257669, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:21','',''),('5','173',4955138,'','6.1','3178',14110.00,0.00,'Payment Id 400339 for invoice:257669, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:46','',''),('5','173',4955139,'','supplier','217',0.00,14110.00,'Payment Id 400339 for invoice:257669, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:09:46','',''),('5','173',4955140,'','2','3228',1650455.00,0.00,'Payment Id 400340 for invoice:257670, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:10:38','',''),('5','173',4955141,'','supplier','217',0.00,1650455.00,'Payment Id 400340 for invoice:257670, receipt: 75406734 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:10:38','',''),('5','173',4955142,'','6.1','3178',24625.00,0.00,'Payment Id 400341 for invoice:257670, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:11:59','',''),('5','173',4955143,'','supplier','217',0.00,24625.00,'Payment Id 400341 for invoice:257670, receipt: 12345678 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:11:59','',''),('5','173',4955144,'','2','3228',2021500.00,0.00,'Payment Id 400342 for invoice:257671, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:13:42','',''),('5','173',4955145,'','supplier','217',0.00,2021500.00,'Payment Id 400342 for invoice:257671, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:13:42','',''),('5','173',4955146,'','6.1','3178',15025.00,0.00,'Payment Id 400343 for invoice:257671, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:14:29','',''),('5','173',4955147,'','supplier','217',0.00,15025.00,'Payment Id 400343 for invoice:257671, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:14:29','',''),('5','173',4955148,'','2','3228',560520.00,0.00,'Payment Id 400344 for invoice:257674, receipt: 2780 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:20:07','',''),('5','173',4955149,'','supplier','217',0.00,560520.00,'Payment Id 400344 for invoice:257674, receipt: 2780 by SALBAS OIL & GAS NIG. LTD','2022-02-14 11:20:07','',''),('5','173',4955150,'','20','3177',370613.10,0.00,'Sales from shift 257675 on 2022-02-15 16:50:13 ','2022-02-15 16:50:13','',''),('5','173',4955151,'','6.1','3178',0.00,370613.10,'Sales from shift 257675 on 2022-02-15 16:50:13 ','2022-02-15 16:50:13','',''),('5','173',4955152,'','20','3177',0.00,0.00,'Sales from shift 257676 on 2022-02-17 09:00:18 ','2022-02-17 09:00:18','',''),('5','173',4955153,'','6.1','3178',0.00,0.00,'Sales from shift 257676 on 2022-02-17 09:00:18 ','2022-02-17 09:00:18','',''),('5','173',4955154,'','20','3177',0.00,0.00,'Sales from shift 257677 on 2022-02-18 09:27:18 ','2022-02-18 09:27:18','',''),('5','173',4955155,'','6.1','3178',0.00,0.00,'Sales from shift 257677 on 2022-02-18 09:27:18 ','2022-02-18 09:27:18','',''),('5','173',4955156,'','20','3177',264298.65,0.00,'Sales from shift 257678 on 2022-02-20 08:52:09 ','2022-02-20 08:52:09','',''),('5','173',4955157,'','6.1','3178',0.00,264298.65,'Sales from shift 257678 on 2022-02-20 08:52:09 ','2022-02-20 08:52:09','',''),('5','173',4955158,'','24','3181',0.00,2475000.00,'Purchase Id 90023 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-20 10:54:24','',''),('5','173',4955159,'','supplier','217',2475000.00,0.00,'Purchase Id 90023 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-20 10:54:24','',''),('5','173',4955160,'','20','3177',960262.05,0.00,'Sales from shift 257679 on 2022-02-20 11:50:16 ','2022-02-20 11:50:16','',''),('5','173',4955161,'','6.1','3178',0.00,960262.05,'Sales from shift 257679 on 2022-02-20 11:50:16 ','2022-02-20 11:50:16','',''),('5','173',4955162,'','20','3177',767872.05,0.00,'Sales from shift 257680 on 2022-02-20 13:54:56 ','2022-02-20 13:54:56','',''),('5','173',4955163,'','6.1','3178',0.00,767872.05,'Sales from shift 257680 on 2022-02-20 13:54:56 ','2022-02-20 13:54:56','',''),('5','173',4955164,'','20','3177',710993.25,0.00,'Sales from shift 257681 on 2022-02-21 10:00:21 ','2022-02-21 10:00:21','',''),('5','173',4955165,'','6.1','3178',0.00,710993.25,'Sales from shift 257681 on 2022-02-21 10:00:21 ','2022-02-21 10:00:21','',''),('5','173',4955166,'','2','3228',246800.00,0.00,'Payment Id 400345 for invoice:257678, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:14','',''),('5','173',4955167,'','supplier','217',0.00,246800.00,'Payment Id 400345 for invoice:257678, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:14','',''),('5','173',4955168,'','6.1','3178',17525.00,0.00,'Payment Id 400346 for invoice:257678, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:34','',''),('5','173',4955169,'','supplier','217',0.00,17525.00,'Payment Id 400346 for invoice:257678, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:34','',''),('5','173',4955170,'','2','3228',938250.00,0.00,'Payment Id 400347 for invoice:257679, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:50','',''),('5','173',4955171,'','supplier','217',0.00,938250.00,'Payment Id 400347 for invoice:257679, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:24:50','',''),('5','173',4955172,'','6.1','3178',22015.00,0.00,'Payment Id 400348 for invoice:257679, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:25:25','',''),('5','173',4955173,'','supplier','217',0.00,22015.00,'Payment Id 400348 for invoice:257679, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:25:25','',''),('5','173',4955174,'','2','3228',753350.00,0.00,'Payment Id 400349 for invoice:257680, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:26:14','',''),('5','173',4955175,'','supplier','217',0.00,753350.00,'Payment Id 400349 for invoice:257680, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:26:14','',''),('5','173',4955176,'','6.1','3178',14525.00,0.00,'Payment Id 400350 for invoice:257680, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:26:30','',''),('5','173',4955177,'','supplier','217',0.00,14525.00,'Payment Id 400350 for invoice:257680, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:26:30','',''),('5','173',4955178,'','2','3228',696500.00,0.00,'Payment Id 400351 for invoice:257681, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:27:04','',''),('5','173',4955179,'','supplier','217',0.00,696500.00,'Payment Id 400351 for invoice:257681, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:27:04','',''),('5','173',4955180,'','6.1','3178',14525.00,0.00,'Payment Id 400352 for invoice:257681, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:27:21','',''),('5','173',4955181,'','supplier','217',0.00,14525.00,'Payment Id 400352 for invoice:257681, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-02-21 16:27:21','',''),('5','173',4955182,'','20','3177',0.00,0.00,'Sales from shift 257682 on 2022-02-22 09:29:25 ','2022-02-22 09:29:25','',''),('5','173',4955183,'','6.1','3178',0.00,0.00,'Sales from shift 257682 on 2022-02-22 09:29:25 ','2022-02-22 09:29:25','',''),('5','173',4955184,'','20','3177',0.00,0.00,'Sales from shift 257683 on 2022-02-23 09:14:02 ','2022-02-23 09:14:02','',''),('5','173',4955185,'','6.1','3178',0.00,0.00,'Sales from shift 257683 on 2022-02-23 09:14:02 ','2022-02-23 09:14:02','',''),('5','173',4955186,'','20','3177',0.00,0.00,'Sales from shift 257684 on 2022-02-24 08:15:28 ','2022-02-24 08:15:28','',''),('5','173',4955187,'','6.1','3178',0.00,0.00,'Sales from shift 257684 on 2022-02-24 08:15:28 ','2022-02-24 08:15:28','',''),('5','173',4955188,'','24','3181',0.00,3712500.00,'Purchase Id 90024 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-25 18:20:11','',''),('5','173',4955189,'','supplier','217',3712500.00,0.00,'Purchase Id 90024 for 22,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-25 18:20:11','',''),('5','173',4955190,'','20','3177',1245857.25,0.00,'Sales from shift 257685 on 2022-02-27 09:06:20 ','2022-02-27 09:06:20','',''),('5','173',4955191,'','6.1','3178',0.00,1245857.25,'Sales from shift 257685 on 2022-02-27 09:06:20 ','2022-02-27 09:06:20','',''),('5','173',4955192,'','20','3177',1651610.40,0.00,'Sales from shift 257686 on 2022-02-27 13:44:19 ','2022-02-27 13:44:19','',''),('5','173',4955193,'','6.1','3178',0.00,1651610.40,'Sales from shift 257686 on 2022-02-27 13:44:19 ','2022-02-27 13:44:19','',''),('5','173',4955194,'','20','3177',332512.95,0.00,'Sales from shift 257687 on 2022-02-28 12:44:26 ','2022-02-28 12:44:26','',''),('5','173',4955195,'','6.1','3178',0.00,332512.95,'Sales from shift 257687 on 2022-02-28 12:44:26 ','2022-02-28 12:44:26','',''),('5','173',4955196,'','24','3181',0.00,4917000.00,'Purchase Id 90025 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-28 12:58:09','',''),('5','173',4955197,'','supplier','217',4917000.00,0.00,'Purchase Id 90025 for 29,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-28 12:58:09','',''),('5','173',4955198,'','20','3177',2580494.40,0.00,'Sales from shift 257688 on 2022-02-28 15:54:54 ','2022-02-28 15:54:54','',''),('5','173',4955199,'','6.1','3178',0.00,2580494.40,'Sales from shift 257688 on 2022-02-28 15:54:54 ','2022-02-28 15:54:54','',''),('5','173',4955200,'','20','3177',2023093.05,0.00,'Sales from shift 257689 on 2022-03-02 09:53:19 ','2022-03-02 09:53:19','',''),('5','173',4955201,'','6.1','3178',0.00,2023093.05,'Sales from shift 257689 on 2022-03-02 09:53:19 ','2022-03-02 09:53:19','',''),('5','173',4955202,'','20','3177',380787.00,0.00,'Sales from shift 257690 on 2022-03-03 10:25:28 ','2022-03-03 10:25:28','',''),('5','173',4955203,'','6.1','3178',0.00,380787.00,'Sales from shift 257690 on 2022-03-03 10:25:28 ','2022-03-03 10:25:28','',''),('5','173',4955204,'','20','3177',462000.00,0.00,'Sales from shift 257691 on 2022-03-03 14:25:50 ','2022-03-03 14:25:50','',''),('5','173',4955205,'','6.1','3178',0.00,462000.00,'Sales from shift 257691 on 2022-03-03 14:25:50 ','2022-03-03 14:25:50','',''),('5','173',4955206,'','20','3177',0.00,0.00,'Sales from shift 257692 on 2022-03-04 09:30:25 ','2022-03-04 09:30:25','',''),('5','173',4955207,'','6.1','3178',0.00,0.00,'Sales from shift 257692 on 2022-03-04 09:30:25 ','2022-03-04 09:30:25','',''),('5','173',4955208,'','20','3177',0.00,0.00,'Sales from shift 257693 on 2022-03-05 10:24:20 ','2022-03-05 10:24:20','',''),('5','173',4955209,'','6.1','3178',0.00,0.00,'Sales from shift 257693 on 2022-03-05 10:24:20 ','2022-03-05 10:24:20','',''),('5','173',4955210,'','20','3177',0.00,0.00,'Sales from shift 257694 on 2022-03-06 11:34:44 ','2022-03-06 11:34:44','',''),('5','173',4955211,'','6.1','3178',0.00,0.00,'Sales from shift 257694 on 2022-03-06 11:34:44 ','2022-03-06 11:34:44','',''),('5','173',4955212,'','20','3177',0.00,0.00,'Sales from shift 257695 on 2022-03-07 09:59:02 ','2022-03-07 09:59:02','',''),('5','173',4955213,'','6.1','3178',0.00,0.00,'Sales from shift 257695 on 2022-03-07 09:59:02 ','2022-03-07 09:59:02','',''),('5','173',4955214,'','20','3177',0.00,0.00,'Sales from shift 257696 on 2022-03-13 12:04:23 ','2022-03-13 12:04:23','',''),('5','173',4955215,'','6.1','3178',0.00,0.00,'Sales from shift 257696 on 2022-03-13 12:04:23 ','2022-03-13 12:04:23','',''),('5','173',4955216,'','24','3181',0.00,7425000.00,'Purchase Id 90026 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-13 12:04:41','',''),('5','173',4955217,'','supplier','217',7425000.00,0.00,'Purchase Id 90026 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-13 12:04:41','',''),('5','173',4955218,'','20','3177',0.00,0.00,'Sales from shift 257697 on 2022-03-13 17:16:40 ','2022-03-13 17:16:40','',''),('5','173',4955219,'','6.1','3178',0.00,0.00,'Sales from shift 257697 on 2022-03-13 17:16:40 ','2022-03-13 17:16:40','',''),('5','173',4955220,'','24','3181',0.00,7425000.00,'Purchase Id 90027 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-13 17:17:11','',''),('5','173',4955221,'','supplier','217',7425000.00,0.00,'Purchase Id 90027 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-13 17:17:11','',''),('5','173',4955222,'','20','3177',1734428.85,0.00,'Sales from shift 257698 on 2022-03-13 18:57:55 ','2022-03-13 18:57:55','',''),('5','173',4955223,'','6.1','3178',0.00,1734428.85,'Sales from shift 257698 on 2022-03-13 18:57:55 ','2022-03-13 18:57:55','',''),('5','173',4955224,'','20','3177',1805553.75,0.00,'Sales from shift 257699 on 2022-03-13 20:55:53 ','2022-03-13 20:55:53','',''),('5','173',4955225,'','6.1','3178',0.00,1805553.75,'Sales from shift 257699 on 2022-03-13 20:55:53 ','2022-03-13 20:55:53','',''),('5','173',4955226,'','20','3177',4127663.10,0.00,'Sales from shift 257700 on 2022-03-14 09:18:33 ','2022-03-14 09:18:33','',''),('5','173',4955227,'','6.1','3178',0.00,4127663.10,'Sales from shift 257700 on 2022-03-14 09:18:33 ','2022-03-14 09:18:33','',''),('5','173',4955228,'','20','3177',2600992.35,0.00,'Sales from shift 257701 on 2022-03-15 12:30:16 ','2022-03-15 12:30:16','',''),('5','173',4955229,'','6.1','3178',0.00,2600992.35,'Sales from shift 257701 on 2022-03-15 12:30:16 ','2022-03-15 12:30:16','',''),('5','173',4955230,'','20','3177',1819478.10,0.00,'Sales from shift 257702 on 2022-03-15 13:38:47 ','2022-03-15 13:38:47','',''),('5','173',4955231,'','6.1','3178',0.00,1819478.10,'Sales from shift 257702 on 2022-03-15 13:38:47 ','2022-03-15 13:38:47','',''),('5','173',4955232,'','20','3177',1023301.95,0.00,'Sales from shift 257703 on 2022-03-15 16:25:16 ','2022-03-15 16:25:16','',''),('5','173',4955233,'','6.1','3178',0.00,1023301.95,'Sales from shift 257703 on 2022-03-15 16:25:16 ','2022-03-15 16:25:16','',''),('5','173',4955234,'','20','3177',912248.70,0.00,'Sales from shift 257704 on 2022-03-16 11:43:15 ','2022-03-16 11:43:15','',''),('5','173',4955235,'','6.1','3178',0.00,912248.70,'Sales from shift 257704 on 2022-03-16 11:43:15 ','2022-03-16 11:43:15','',''),('5','173',4955236,'','20','3177',521119.50,0.00,'Sales from shift 257705 on 2022-03-17 08:54:56 ','2022-03-17 08:54:56','',''),('5','173',4955237,'','6.1','3178',0.00,521119.50,'Sales from shift 257705 on 2022-03-17 08:54:56 ','2022-03-17 08:54:56','',''),('5','173',4955238,'','20','3177',0.00,0.00,'Sales from shift 257706 on 2022-03-18 09:22:09 ','2022-03-18 09:22:09','',''),('5','173',4955239,'','6.1','3178',0.00,0.00,'Sales from shift 257706 on 2022-03-18 09:22:09 ','2022-03-18 09:22:09','',''),('5','173',4955240,'','20','3177',0.00,0.00,'Sales from shift 257707 on 2022-03-19 10:16:14 ','2022-03-19 10:16:14','',''),('5','173',4955241,'','6.1','3178',0.00,0.00,'Sales from shift 257707 on 2022-03-19 10:16:14 ','2022-03-19 10:16:14','',''),('5','173',4955242,'','20','3177',0.00,0.00,'Sales from shift 257708 on 2022-03-20 13:18:25 ','2022-03-20 13:18:25','',''),('5','173',4955243,'','6.1','3178',0.00,0.00,'Sales from shift 257708 on 2022-03-20 13:18:25 ','2022-03-20 13:18:25','',''),('5','173',4955244,'','20','3177',0.00,0.00,'Sales from shift 257709 on 2022-03-22 09:11:57 ','2022-03-22 09:11:57','',''),('5','173',4955245,'','6.1','3178',0.00,0.00,'Sales from shift 257709 on 2022-03-22 09:11:57 ','2022-03-22 09:11:57','',''),('5','173',4955246,'','20','3177',0.00,0.00,'Sales from shift 257710 on 2022-03-23 10:22:19 ','2022-03-23 10:22:19','',''),('5','173',4955247,'','6.1','3178',0.00,0.00,'Sales from shift 257710 on 2022-03-23 10:22:19 ','2022-03-23 10:22:19','',''),('5','173',4955248,'','20','3177',0.00,0.00,'Sales from shift 257711 on 2022-03-24 09:08:22 ','2022-03-24 09:08:22','',''),('5','173',4955249,'','6.1','3178',0.00,0.00,'Sales from shift 257711 on 2022-03-24 09:08:22 ','2022-03-24 09:08:22','',''),('5','173',4955250,'','20','3177',0.00,0.00,'Sales from shift 257712 on 2022-03-25 10:23:25 ','2022-03-25 10:23:25','',''),('5','173',4955251,'','6.1','3178',0.00,0.00,'Sales from shift 257712 on 2022-03-25 10:23:25 ','2022-03-25 10:23:25','',''),('5','173',4955252,'','20','3177',0.00,0.00,'Sales from shift 257713 on 2022-03-26 12:43:43 ','2022-03-26 12:43:43','',''),('5','173',4955253,'','6.1','3178',0.00,0.00,'Sales from shift 257713 on 2022-03-26 12:43:43 ','2022-03-26 12:43:43','',''),('5','173',4955254,'','20','3177',0.00,0.00,'Sales from shift 257714 on 2022-03-28 10:14:10 ','2022-03-28 10:14:10','',''),('5','173',4955255,'','6.1','3178',0.00,0.00,'Sales from shift 257714 on 2022-03-28 10:14:10 ','2022-03-28 10:14:10','',''),('5','173',4955256,'','20','3177',0.00,0.00,'Sales from shift 257715 on 2022-03-28 11:10:23 ','2022-03-28 11:10:23','',''),('5','173',4955257,'','6.1','3178',0.00,0.00,'Sales from shift 257715 on 2022-03-28 11:10:23 ','2022-03-28 11:10:23','',''),('5','173',4955258,'','20','3177',0.00,0.00,'Sales from shift 257716 on 2022-03-29 11:35:32 ','2022-03-29 11:35:32','',''),('5','173',4955259,'','6.1','3178',0.00,0.00,'Sales from shift 257716 on 2022-03-29 11:35:32 ','2022-03-29 11:35:32','',''),('5','173',4955260,'','20','3177',0.00,0.00,'Sales from shift 257717 on 2022-03-30 10:03:13 ','2022-03-30 10:03:13','',''),('5','173',4955261,'','6.1','3178',0.00,0.00,'Sales from shift 257717 on 2022-03-30 10:03:13 ','2022-03-30 10:03:13','',''),('5','173',4955262,'','20','3177',0.00,0.00,'Sales from shift 257718 on 2022-03-31 09:29:56 ','2022-03-31 09:29:56','',''),('5','173',4955263,'','6.1','3178',0.00,0.00,'Sales from shift 257718 on 2022-03-31 09:29:56 ','2022-03-31 09:29:56','',''),('5','173',4955264,'','20','3177',0.00,0.00,'Sales from shift 257719 on 2022-04-01 16:23:18 ','2022-04-01 16:23:18','',''),('5','173',4955265,'','6.1','3178',0.00,0.00,'Sales from shift 257719 on 2022-04-01 16:23:18 ','2022-04-01 16:23:18','',''),('5','173',4955266,'','20','3177',0.00,0.00,'Sales from shift 257720 on 2022-04-02 16:15:05 ','2022-04-02 16:15:05','',''),('5','173',4955267,'','6.1','3178',0.00,0.00,'Sales from shift 257720 on 2022-04-02 16:15:05 ','2022-04-02 16:15:05','',''),('5','173',4955268,'','20','3177',0.00,0.00,'Sales from shift 257721 on 2022-04-04 09:10:52 ','2022-04-04 09:10:52','',''),('5','173',4955269,'','6.1','3178',0.00,0.00,'Sales from shift 257721 on 2022-04-04 09:10:52 ','2022-04-04 09:10:52','',''),('5','173',4955270,'','20','3177',0.00,0.00,'Sales from shift 257722 on 2022-04-05 11:34:13 ','2022-04-05 11:34:13','',''),('5','173',4955271,'','6.1','3178',0.00,0.00,'Sales from shift 257722 on 2022-04-05 11:34:13 ','2022-04-05 11:34:13','',''),('5','173',4955272,'','20','3177',0.00,0.00,'Sales from shift 257723 on 2022-04-07 14:01:19 ','2022-04-07 14:01:19','',''),('5','173',4955273,'','6.1','3178',0.00,0.00,'Sales from shift 257723 on 2022-04-07 14:01:19 ','2022-04-07 14:01:19','',''),('5','173',4955274,'','20','3177',0.00,0.00,'Sales from shift 257724 on 2022-04-08 09:13:06 ','2022-04-08 09:13:06','',''),('5','173',4955275,'','6.1','3178',0.00,0.00,'Sales from shift 257724 on 2022-04-08 09:13:06 ','2022-04-08 09:13:06','',''),('5','173',4955276,'','20','3177',0.00,0.00,'Sales from shift 257725 on 2022-04-09 09:06:19 ','2022-04-09 09:06:19','',''),('5','173',4955277,'','6.1','3178',0.00,0.00,'Sales from shift 257725 on 2022-04-09 09:06:19 ','2022-04-09 09:06:19','',''),('5','173',4955278,'','20','3177',0.00,0.00,'Sales from shift 257726 on 2022-04-10 12:37:23 ','2022-04-10 12:37:23','',''),('5','173',4955279,'','6.1','3178',0.00,0.00,'Sales from shift 257726 on 2022-04-10 12:37:23 ','2022-04-10 12:37:23','',''),('5','173',4955280,'','20','3177',0.00,0.00,'Sales from shift 257727 on 2022-04-11 09:09:01 ','2022-04-11 09:09:01','',''),('5','173',4955281,'','6.1','3178',0.00,0.00,'Sales from shift 257727 on 2022-04-11 09:09:01 ','2022-04-11 09:09:01','',''),('5','173',4955282,'','2','3228',1231350.00,0.00,'Payment Id 400353 for invoice:257685, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:20:45','',''),('5','173',4955283,'','supplier','217',0.00,1231350.00,'Payment Id 400353 for invoice:257685, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:20:45','',''),('5','173',4955284,'','6.1','3178',14525.00,0.00,'Payment Id 400354 for invoice:257685, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:20:58','',''),('5','173',4955285,'','supplier','217',0.00,14525.00,'Payment Id 400354 for invoice:257685, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:20:58','',''),('5','173',4955286,'','2','3228',1625585.00,0.00,'Payment Id 400355 for invoice:257686, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:21:22','',''),('5','173',4955287,'','supplier','217',0.00,1625585.00,'Payment Id 400355 for invoice:257686, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:21:22','',''),('5','173',4955288,'','6.1','3178',26025.00,0.00,'Payment Id 400356 for invoice:257686, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:21:41','',''),('5','173',4955289,'','supplier','217',0.00,26025.00,'Payment Id 400356 for invoice:257686, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:21:41','',''),('5','173',4955290,'','2','3228',317990.00,0.00,'Payment Id 400357 for invoice:257687, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:22:03','',''),('5','173',4955291,'','supplier','217',0.00,317990.00,'Payment Id 400357 for invoice:257687, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:22:03','',''),('5','173',4955292,'','6.1','3178',14525.00,0.00,'Payment Id 400358 for invoice:257687, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:22:17','',''),('5','173',4955293,'','supplier','217',0.00,14525.00,'Payment Id 400358 for invoice:257687, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:22:17','',''),('5','173',4955294,'','2','3228',2563000.00,0.00,'Payment Id 400359 for invoice:257688, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:23:34','',''),('5','173',4955295,'','supplier','217',0.00,2563000.00,'Payment Id 400359 for invoice:257688, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:23:34','',''),('5','173',4955296,'','6.1','3178',17525.00,0.00,'Payment Id 400360 for invoice:257688, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:23:53','',''),('5','173',4955297,'','supplier','217',0.00,17525.00,'Payment Id 400360 for invoice:257688, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:23:53','',''),('5','173',4955298,'','2','3229',2003100.00,0.00,'Payment Id 400361 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:24:09','',''),('5','173',4955299,'','supplier','217',0.00,2003100.00,'Payment Id 400361 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:24:09','',''),('5','173',4955300,'','6.1','3178',2025.00,0.00,'Payment Id 400362 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:25:44','',''),('5','173',4955301,'','supplier','217',0.00,2025.00,'Payment Id 400362 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:25:44','',''),('5','173',4955302,'','6.1','3178',0.00,2025.00,'Payment Id 400362 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:26:06','',''),('5','173',4955303,'','supplier','217',2025.00,0.00,'Payment Id 400362 for invoice:257689, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:26:06','',''),('5','173',4955304,'','6.1','3178',20025.00,0.00,'Payment Id 400363 for invoice:257727, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:27:42','',''),('5','173',4955305,'','supplier','217',0.00,20025.00,'Payment Id 400363 for invoice:257727, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-11 11:27:42','',''),('5','173',4955306,'','20','3177',0.00,0.00,'Sales from shift 257728 on 2022-04-12 09:05:51 ','2022-04-12 09:05:51','',''),('5','173',4955307,'','6.1','3178',0.00,0.00,'Sales from shift 257728 on 2022-04-12 09:05:51 ','2022-04-12 09:05:51','',''),('5','173',4955308,'','20','3177',0.00,0.00,'Sales from shift 257729 on 2022-04-13 09:01:38 ','2022-04-13 09:01:38','',''),('5','173',4955309,'','6.1','3178',0.00,0.00,'Sales from shift 257729 on 2022-04-13 09:01:38 ','2022-04-13 09:01:38','',''),('5','173',4955310,'','20','3177',0.00,0.00,'Sales from shift 257730 on 2022-04-14 09:25:37 ','2022-04-14 09:25:37','',''),('5','173',4955311,'','6.1','3178',0.00,0.00,'Sales from shift 257730 on 2022-04-14 09:25:37 ','2022-04-14 09:25:37','',''),('5','173',4955312,'','20','3177',0.00,0.00,'Sales from shift 257731 on 2022-04-15 10:25:41 ','2022-04-15 10:25:41','',''),('5','173',4955313,'','6.1','3178',0.00,0.00,'Sales from shift 257731 on 2022-04-15 10:25:41 ','2022-04-15 10:25:41','',''),('5','173',4955314,'','20','3177',0.00,0.00,'Sales from shift 257732 on 2022-04-16 08:32:37 ','2022-04-16 08:32:37','',''),('5','173',4955315,'','6.1','3178',0.00,0.00,'Sales from shift 257732 on 2022-04-16 08:32:37 ','2022-04-16 08:32:37','',''),('5','173',4955316,'','20','3177',0.00,0.00,'Sales from shift 257733 on 2022-04-16 19:59:19 ','2022-04-16 19:59:19','',''),('5','173',4955317,'','6.1','3178',0.00,0.00,'Sales from shift 257733 on 2022-04-16 19:59:19 ','2022-04-16 19:59:19','',''),('5','173',4955318,'','20','3177',0.00,0.00,'Sales from shift 257734 on 2022-04-17 12:32:31 ','2022-04-17 12:32:31','',''),('5','173',4955319,'','6.1','3178',0.00,0.00,'Sales from shift 257734 on 2022-04-17 12:32:31 ','2022-04-17 12:32:31','',''),('5','173',4955320,'','20','3177',0.00,0.00,'Sales from shift 257735 on 2022-04-19 10:57:51 ','2022-04-19 10:57:51','',''),('5','173',4955321,'','6.1','3178',0.00,0.00,'Sales from shift 257735 on 2022-04-19 10:57:51 ','2022-04-19 10:57:51','',''),('5','173',4955322,'','20','3177',0.00,0.00,'Sales from shift 257736 on 2022-04-19 11:35:27 ','2022-04-19 11:35:27','',''),('5','173',4955323,'','6.1','3178',0.00,0.00,'Sales from shift 257736 on 2022-04-19 11:35:27 ','2022-04-19 11:35:27','',''),('5','173',4955324,'','20','3177',0.00,0.00,'Sales from shift 257737 on 2022-04-20 10:15:05 ','2022-04-20 10:15:05','',''),('5','173',4955325,'','6.1','3178',0.00,0.00,'Sales from shift 257737 on 2022-04-20 10:15:05 ','2022-04-20 10:15:05','',''),('5','173',4955326,'','20','3177',0.00,0.00,'Sales from shift 257738 on 2022-04-21 09:25:08 ','2022-04-21 09:25:08','',''),('5','173',4955327,'','6.1','3178',0.00,0.00,'Sales from shift 257738 on 2022-04-21 09:25:08 ','2022-04-21 09:25:08','',''),('5','173',4955328,'','20','3177',0.00,0.00,'Sales from shift 257739 on 2022-04-22 10:20:10 ','2022-04-22 10:20:10','',''),('5','173',4955329,'','6.1','3178',0.00,0.00,'Sales from shift 257739 on 2022-04-22 10:20:10 ','2022-04-22 10:20:10','',''),('5','173',4955330,'','20','3177',107250.00,0.00,'Sales from shift 257740 on 2022-04-23 09:14:24 ','2022-04-23 09:14:24','',''),('5','173',4955331,'','6.1','3178',0.00,107250.00,'Sales from shift 257740 on 2022-04-23 09:14:24 ','2022-04-23 09:14:24','',''),('5','173',4955332,'','24','3181',0.00,7425000.00,'Purchase Id 90028 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-23 14:11:32','',''),('5','173',4955333,'','supplier','217',7425000.00,0.00,'Purchase Id 90028 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-23 14:11:32','',''),('5','173',4955334,'','20','3177',645646.65,0.00,'Sales from shift 257741 on 2022-04-23 15:27:08 ','2022-04-23 15:27:08','',''),('5','173',4955335,'','6.1','3178',0.00,645646.65,'Sales from shift 257741 on 2022-04-23 15:27:08 ','2022-04-23 15:27:08','',''),('5','173',4955336,'','20','3177',822675.15,0.00,'Sales from shift 257742 on 2022-04-23 21:09:11 ','2022-04-23 21:09:11','',''),('5','173',4955337,'','6.1','3178',0.00,822675.15,'Sales from shift 257742 on 2022-04-23 21:09:11 ','2022-04-23 21:09:11','',''),('5','173',4955338,'','20','3177',630009.60,0.00,'Sales from shift 257743 on 2022-04-25 11:42:21 ','2022-04-25 11:42:21','',''),('5','173',4955339,'','6.1','3178',0.00,630009.60,'Sales from shift 257743 on 2022-04-25 11:42:21 ','2022-04-25 11:42:21','',''),('5','173',4955340,'','20','3177',643788.75,0.00,'Sales from shift 257744 on 2022-04-25 13:45:05 ','2022-04-25 13:45:05','',''),('5','173',4955341,'','6.1','3178',0.00,643788.75,'Sales from shift 257744 on 2022-04-25 13:45:05 ','2022-04-25 13:45:05','',''),('5','173',4955342,'','20','3177',694503.15,0.00,'Sales from shift 257745 on 2022-04-26 10:24:10 ','2022-04-26 10:24:10','',''),('5','173',4955343,'','6.1','3178',0.00,694503.15,'Sales from shift 257745 on 2022-04-26 10:24:10 ','2022-04-26 10:24:10','',''),('5','173',4955344,'','20','3177',691480.35,0.00,'Sales from shift 257746 on 2022-04-27 10:20:31 ','2022-04-27 10:20:31','',''),('5','173',4955345,'','6.1','3178',0.00,691480.35,'Sales from shift 257746 on 2022-04-27 10:20:31 ','2022-04-27 10:20:31','',''),('5','173',4955346,'','20','3177',508541.55,0.00,'Sales from shift 257747 on 2022-04-28 12:52:37 ','2022-04-28 12:52:37','',''),('5','173',4955347,'','6.1','3178',0.00,508541.55,'Sales from shift 257747 on 2022-04-28 12:52:37 ','2022-04-28 12:52:37','',''),('5','173',4955348,'','2','3229',1671450.00,0.00,'Payment Id 400364 for invoice:257698, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 13:59:40','',''),('5','173',4955349,'','supplier','217',0.00,1671450.00,'Payment Id 400364 for invoice:257698, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 13:59:40','',''),('5','173',4955350,'','6.1','3178',62978.00,0.00,'Payment Id 400365 for invoice:257698, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:00:40','',''),('5','173',4955351,'','supplier','217',0.00,62978.00,'Payment Id 400365 for invoice:257698, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:00:40','',''),('5','173',4955352,'','2','3229',1781450.00,0.00,'Payment Id 400366 for invoice:257699, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:01:19','',''),('5','173',4955353,'','supplier','217',0.00,1781450.00,'Payment Id 400366 for invoice:257699, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:01:19','',''),('5','173',4955354,'','6.1','3178',22900.00,0.00,'Payment Id 400367 for invoice:257699, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:02:32','',''),('5','173',4955355,'','supplier','217',0.00,22900.00,'Payment Id 400367 for invoice:257699, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:02:32','',''),('5','173',4955356,'','2','3229',4096750.00,0.00,'Payment Id 400368 for invoice:257700, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:04','',''),('5','173',4955357,'','supplier','217',0.00,4096750.00,'Payment Id 400368 for invoice:257700, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:04','',''),('5','173',4955358,'','6.1','3178',30915.00,0.00,'Payment Id 400369 for invoice:257700, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:29','',''),('5','173',4955359,'','supplier','217',0.00,30915.00,'Payment Id 400369 for invoice:257700, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:29','',''),('5','173',4955360,'','2','3229',2578600.00,0.00,'Payment Id 400370 for invoice:257701, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:57','',''),('5','173',4955361,'','supplier','217',0.00,2578600.00,'Payment Id 400370 for invoice:257701, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:03:57','',''),('5','173',4955362,'','6.1','3178',22400.00,0.00,'Payment Id 400371 for invoice:257701, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:04:22','',''),('5','173',4955363,'','supplier','217',0.00,22400.00,'Payment Id 400371 for invoice:257701, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:04:22','',''),('5','173',4955364,'','2','3229',1796000.00,0.00,'Payment Id 400372 for invoice:257702, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:05:31','',''),('5','173',4955365,'','supplier','217',0.00,1796000.00,'Payment Id 400372 for invoice:257702, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:05:31','',''),('5','173',4955366,'','6.1','3178',22400.00,0.00,'Payment Id 400373 for invoice:257702, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:06:04','',''),('5','173',4955367,'','supplier','217',0.00,22400.00,'Payment Id 400373 for invoice:257702, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:06:04','',''),('5','173',4955368,'','2','3229',995400.00,0.00,'Payment Id 400374 for invoice:257703, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:02','',''),('5','173',4955369,'','supplier','217',0.00,995400.00,'Payment Id 400374 for invoice:257703, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:02','',''),('5','173',4955370,'','6.1','3178',27900.00,0.00,'Payment Id 400375 for invoice:257703, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:26','',''),('5','173',4955371,'','supplier','217',0.00,27900.00,'Payment Id 400375 for invoice:257703, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:26','',''),('5','173',4955372,'','2','3229',889250.00,0.00,'Payment Id 400376 for invoice:257704, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:54','',''),('5','173',4955373,'','supplier','217',0.00,889250.00,'Payment Id 400376 for invoice:257704, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:07:54','',''),('5','173',4955374,'','6.1','3178',22900.00,0.00,'Payment Id 400377 for invoice:257704, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:09:25','',''),('5','173',4955375,'','supplier','217',0.00,22900.00,'Payment Id 400377 for invoice:257704, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:09:25','',''),('5','173',4955376,'','2','3229',498120.00,0.00,'Payment Id 400378 for invoice:257705, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:10:12','',''),('5','173',4955377,'','supplier','217',0.00,498120.00,'Payment Id 400378 for invoice:257705, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:10:12','',''),('5','173',4955378,'','6.1','3178',22900.00,0.00,'Payment Id 400379 for invoice:257705, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:10:57','',''),('5','173',4955379,'','supplier','217',0.00,22900.00,'Payment Id 400379 for invoice:257705, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:10:57','',''),('5','173',4955380,'','2','3229',81900.00,0.00,'Payment Id 400380 for invoice:257740, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:04','',''),('5','173',4955381,'','supplier','217',0.00,81900.00,'Payment Id 400380 for invoice:257740, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:04','',''),('5','173',4955382,'','6.1','3178',25350.00,0.00,'Payment Id 400381 for invoice:257740, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:34','',''),('5','173',4955383,'','supplier','217',0.00,25350.00,'Payment Id 400381 for invoice:257740, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:34','',''),('5','173',4955384,'','2','3229',623250.00,0.00,'Payment Id 400382 for invoice:257741, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:54','',''),('5','173',4955385,'','supplier','217',0.00,623250.00,'Payment Id 400382 for invoice:257741, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:12:54','',''),('5','173',4955386,'','6.1','3178',22395.00,0.00,'Payment Id 400383 for invoice:257741, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:07','',''),('5','173',4955387,'','supplier','217',0.00,22395.00,'Payment Id 400383 for invoice:257741, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:07','',''),('5','173',4955388,'','2','3229',786770.00,0.00,'Payment Id 400384 for invoice:257742, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:35','',''),('5','173',4955389,'','supplier','217',0.00,786770.00,'Payment Id 400384 for invoice:257742, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:35','',''),('5','173',4955390,'','6.1','3178',35900.00,0.00,'Payment Id 400385 for invoice:257742, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:58','',''),('5','173',4955391,'','supplier','217',0.00,35900.00,'Payment Id 400385 for invoice:257742, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:13:58','',''),('5','173',4955392,'','2','3229',607100.00,0.00,'Payment Id 400386 for invoice:257743, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:17','',''),('5','173',4955393,'','supplier','217',0.00,607100.00,'Payment Id 400386 for invoice:257743, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:17','',''),('5','173',4955394,'','6.1','3178',2240.00,0.00,'Payment Id 400387 for invoice:257743, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:33','',''),('5','173',4955395,'','supplier','217',0.00,2240.00,'Payment Id 400387 for invoice:257743, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:33','',''),('5','173',4955396,'','2','3229',621380.00,0.00,'Payment Id 400388 for invoice:257744, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:50','',''),('5','173',4955397,'','supplier','217',0.00,621380.00,'Payment Id 400388 for invoice:257744, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:14:50','',''),('5','173',4955398,'','6.1','3178',22400.00,0.00,'Payment Id 400389 for invoice:257744, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:05','',''),('5','173',4955399,'','supplier','217',0.00,22400.00,'Payment Id 400389 for invoice:257744, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:05','',''),('5','173',4955400,'','2','3229',671600.00,0.00,'Payment Id 400390 for invoice:257745, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:24','',''),('5','173',4955401,'','supplier','217',0.00,671600.00,'Payment Id 400390 for invoice:257745, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:24','',''),('5','173',4955402,'','6.1','3178',22900.00,0.00,'Payment Id 400391 for invoice:257745, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:40','',''),('5','173',4955403,'','supplier','217',0.00,22900.00,'Payment Id 400391 for invoice:257745, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:15:40','',''),('5','173',4955404,'','2','3229',668570.00,0.00,'Payment Id 400392 for invoice:257746, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:16:01','',''),('5','173',4955405,'','supplier','217',0.00,668570.00,'Payment Id 400392 for invoice:257746, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:16:01','',''),('5','173',4955406,'','6.1','3178',22900.00,0.00,'Payment Id 400393 for invoice:257746, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:16:21','',''),('5','173',4955407,'','supplier','217',0.00,22900.00,'Payment Id 400393 for invoice:257746, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:16:21','',''),('5','173',4955408,'','2','3229',339440.00,0.00,'Payment Id 400394 for invoice:257747, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:17:18','',''),('5','173',4955409,'','supplier','217',0.00,339440.00,'Payment Id 400394 for invoice:257747, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-04-28 14:17:18','',''),('5','173',4955410,'','20','3177',635740.05,0.00,'Sales from shift 257748 on 2022-04-29 10:13:20 ','2022-04-29 10:13:20','',''),('5','173',4955411,'','6.1','3178',0.00,635740.05,'Sales from shift 257748 on 2022-04-29 10:13:20 ','2022-04-29 10:13:20','',''),('5','173',4955412,'','20','3177',529245.75,0.00,'Sales from shift 257749 on 2022-05-10 10:18:16 ','2022-05-10 10:18:16','',''),('5','173',4955413,'','6.1','3178',0.00,529245.75,'Sales from shift 257749 on 2022-05-10 10:18:16 ','2022-05-10 10:18:16','',''),('5','173',4955414,'','20','3177',447813.30,0.00,'Sales from shift 257750 on 2022-05-10 10:21:16 ','2022-05-10 10:21:16','',''),('5','173',4955415,'','6.1','3178',0.00,447813.30,'Sales from shift 257750 on 2022-05-10 10:21:16 ','2022-05-10 10:21:16','',''),('5','173',4955416,'','20','3177',440365.20,0.00,'Sales from shift 257751 on 2022-05-10 10:27:38 ','2022-05-10 10:27:38','',''),('5','173',4955417,'','6.1','3178',0.00,440365.20,'Sales from shift 257751 on 2022-05-10 10:27:38 ','2022-05-10 10:27:38','',''),('5','173',4955418,'','20','3177',300361.05,0.00,'Sales from shift 257752 on 2022-05-10 10:31:51 ','2022-05-10 10:31:51','',''),('5','173',4955419,'','6.1','3178',0.00,300361.05,'Sales from shift 257752 on 2022-05-10 10:31:51 ','2022-05-10 10:31:51','',''),('5','173',4955420,'','20','3177',99003.30,0.00,'Sales from shift 257753 on 2022-05-10 10:37:58 ','2022-05-10 10:37:58','',''),('5','173',4955421,'','6.1','3178',0.00,99003.30,'Sales from shift 257753 on 2022-05-10 10:37:58 ','2022-05-10 10:37:58','',''),('5','173',4955422,'','20','3177',0.00,0.00,'Sales from shift 257754 on 2022-05-10 10:40:59 ','2022-05-10 10:40:59','',''),('5','173',4955423,'','6.1','3178',0.00,0.00,'Sales from shift 257754 on 2022-05-10 10:40:59 ','2022-05-10 10:40:59','',''),('5','173',4955424,'','20','3177',0.00,0.00,'Sales from shift 257755 on 2022-05-10 10:43:53 ','2022-05-10 10:43:53','',''),('5','173',4955425,'','6.1','3178',0.00,0.00,'Sales from shift 257755 on 2022-05-10 10:43:53 ','2022-05-10 10:43:53','',''),('5','173',4955426,'','20','3177',0.00,0.00,'Sales from shift 257756 on 2022-05-10 10:47:24 ','2022-05-10 10:47:24','',''),('5','173',4955427,'','6.1','3178',0.00,0.00,'Sales from shift 257756 on 2022-05-10 10:47:24 ','2022-05-10 10:47:24','',''),('5','173',4955428,'','20','3177',0.00,0.00,'Sales from shift 257757 on 2022-05-10 10:52:25 ','2022-05-10 10:52:25','',''),('5','173',4955429,'','6.1','3178',0.00,0.00,'Sales from shift 257757 on 2022-05-10 10:52:25 ','2022-05-10 10:52:25','',''),('5','173',4955430,'','20','3177',0.00,0.00,'Sales from shift 257758 on 2022-05-10 10:53:45 ','2022-05-10 10:53:45','',''),('5','173',4955431,'','6.1','3178',0.00,0.00,'Sales from shift 257758 on 2022-05-10 10:53:45 ','2022-05-10 10:53:45','',''),('5','173',4955432,'','20','3177',0.00,0.00,'Sales from shift 257759 on 2022-05-10 10:54:58 ','2022-05-10 10:54:58','',''),('5','173',4955433,'','6.1','3178',0.00,0.00,'Sales from shift 257759 on 2022-05-10 10:54:58 ','2022-05-10 10:54:58','',''),('5','173',4955434,'','20','3177',92400.00,0.00,'Sales from shift 257760 on 2022-05-11 09:40:22 ','2022-05-11 09:40:22','',''),('5','173',4955435,'','6.1','3178',0.00,92400.00,'Sales from shift 257760 on 2022-05-11 09:40:22 ','2022-05-11 09:40:22','',''),('5','173',4955436,'','6.1','3178',287800.00,0.00,'Payment Id 400395 for invoice:257747, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:41:45','',''),('5','173',4955437,'','supplier','217',0.00,287800.00,'Payment Id 400395 for invoice:257747, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:41:45','',''),('5','173',4955438,'','2','3229',612840.00,0.00,'Payment Id 400396 for invoice:257748, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:12','',''),('5','173',4955439,'','supplier','217',0.00,612840.00,'Payment Id 400396 for invoice:257748, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:12','',''),('5','173',4955440,'','6.1','3178',22900.00,0.00,'Payment Id 400397 for invoice:257748, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:27','',''),('5','173',4955441,'','supplier','217',0.00,22900.00,'Payment Id 400397 for invoice:257748, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:27','',''),('5','173',4955442,'','2','3229',506345.00,0.00,'Payment Id 400398 for invoice:257749, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:44','',''),('5','173',4955443,'','supplier','217',0.00,506345.00,'Payment Id 400398 for invoice:257749, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:42:44','',''),('5','173',4955444,'','6.1','3178',22900.00,0.00,'Payment Id 400399 for invoice:257749, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:43:02','',''),('5','173',4955445,'','supplier','217',0.00,22900.00,'Payment Id 400399 for invoice:257749, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:43:02','',''),('5','173',4955446,'','2','3229',425415.00,0.00,'Payment Id 400400 for invoice:257750, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:43:25','',''),('5','173',4955447,'','supplier','217',0.00,425415.00,'Payment Id 400400 for invoice:257750, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:43:25','',''),('5','173',4955448,'','6.1','3178',22400.00,0.00,'Payment Id 400401 for invoice:257750, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:50:50','',''),('5','173',4955449,'','supplier','217',0.00,22400.00,'Payment Id 400401 for invoice:257750, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:50:50','',''),('5','173',4955450,'','2','3229',131256.00,0.00,'Payment Id 400402 for invoice:257751, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:52:17','',''),('5','173',4955451,'','supplier','217',0.00,131256.00,'Payment Id 400402 for invoice:257751, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:52:17','',''),('5','173',4955452,'','6.1','3178',309100.00,0.00,'Payment Id 400403 for invoice:257751, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:52:44','',''),('5','173',4955453,'','supplier','217',0.00,309100.00,'Payment Id 400403 for invoice:257751, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:52:44','',''),('5','173',4955454,'','2','3229',278000.00,0.00,'Payment Id 400404 for invoice:257752, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:01','',''),('5','173',4955455,'','supplier','217',0.00,278000.00,'Payment Id 400404 for invoice:257752, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:01','',''),('5','173',4955456,'','6.1','3178',22400.00,0.00,'Payment Id 400405 for invoice:257752, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:11','',''),('5','173',4955457,'','supplier','217',0.00,22400.00,'Payment Id 400405 for invoice:257752, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:11','',''),('5','173',4955458,'','2','3229',76600.00,0.00,'Payment Id 400406 for invoice:257753, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:29','',''),('5','173',4955459,'','supplier','217',0.00,76600.00,'Payment Id 400406 for invoice:257753, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:29','',''),('5','173',4955460,'','6.1','3178',22400.00,0.00,'Payment Id 400407 for invoice:257753, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:39','',''),('5','173',4955461,'','supplier','217',0.00,22400.00,'Payment Id 400407 for invoice:257753, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 09:53:39','',''),('5','173',4955462,'','24','3181',0.00,7408500.00,'Purchase Id 90029 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-05-11 10:07:30','',''),('5','173',4955463,'','supplier','217',7408500.00,0.00,'Purchase Id 90029 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-05-11 10:07:30','',''),('5','173',4955464,'','2','3229',67000.00,0.00,'Payment Id 400408 for invoice:257760, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 16:56:25','',''),('5','173',4955465,'','supplier','217',0.00,67000.00,'Payment Id 400408 for invoice:257760, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 16:56:25','',''),('5','173',4955466,'','6.1','3178',25400.00,0.00,'Payment Id 400409 for invoice:257760, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 16:56:40','',''),('5','173',4955467,'','supplier','217',0.00,25400.00,'Payment Id 400409 for invoice:257760, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-11 16:56:40','',''),('5','173',4955468,'','20','3177',815463.00,0.00,'Sales from shift 257761 on 2022-05-12 13:10:13 ','2022-05-12 13:10:13','',''),('5','173',4955469,'','6.1','3178',0.00,815463.00,'Sales from shift 257761 on 2022-05-12 13:10:13 ','2022-05-12 13:10:13','',''),('5','173',4955470,'','20','3177',834537.00,0.00,'Sales from shift 257762 on 2022-05-13 11:35:04 ','2022-05-13 11:35:04','',''),('5','173',4955471,'','6.1','3178',0.00,834537.00,'Sales from shift 257762 on 2022-05-13 11:35:04 ','2022-05-13 11:35:04','',''),('5','173',4955472,'','20','3177',876443.70,0.00,'Sales from shift 257763 on 2022-05-14 13:46:26 ','2022-05-14 13:46:26','',''),('5','173',4955473,'','6.1','3178',0.00,876443.70,'Sales from shift 257763 on 2022-05-14 13:46:26 ','2022-05-14 13:46:26','',''),('5','173',4955474,'','20','3177',773556.30,0.00,'Sales from shift 257764 on 2022-05-16 10:05:04 ','2022-05-16 10:05:04','',''),('5','173',4955475,'','6.1','3178',0.00,773556.30,'Sales from shift 257764 on 2022-05-16 10:05:04 ','2022-05-16 10:05:04','',''),('5','173',4955476,'','6.1','3178',22900.00,0.00,'Payment Id 400411 for invoice:257761, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-16 10:05:32','',''),('5','173',4955477,'','supplier','217',0.00,22900.00,'Payment Id 400411 for invoice:257761, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-16 10:05:32','',''),('5','173',4955478,'','2','3229',792530.00,0.00,'Payment Id 400410 for invoice:257761, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-16 10:05:32','',''),('5','173',4955479,'','supplier','217',0.00,792530.00,'Payment Id 400410 for invoice:257761, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-16 10:05:32','',''),('5','173',4955480,'','20','3177',776384.40,0.00,'Sales from shift 257765 on 2022-05-16 15:08:56 ','2022-05-16 15:08:56','',''),('5','173',4955481,'','6.1','3178',0.00,776384.40,'Sales from shift 257765 on 2022-05-16 15:08:56 ','2022-05-16 15:08:56','',''),('5','173',4955482,'','20','3177',646882.50,0.00,'Sales from shift 257766 on 2022-05-17 09:04:33 ','2022-05-17 09:04:33','',''),('5','173',4955483,'','6.1','3178',0.00,646882.50,'Sales from shift 257766 on 2022-05-17 09:04:33 ','2022-05-17 09:04:33','',''),('5','173',4955484,'','20','3177',673101.00,0.00,'Sales from shift 257767 on 2022-05-18 07:36:58 ','2022-05-18 07:36:58','',''),('5','173',4955485,'','6.1','3178',0.00,673101.00,'Sales from shift 257767 on 2022-05-18 07:36:58 ','2022-05-18 07:36:58','',''),('5','173',4955486,'','20','3177',685401.75,0.00,'Sales from shift 257768 on 2022-05-19 08:21:39 ','2022-05-19 08:21:39','',''),('5','173',4955487,'','6.1','3178',0.00,685401.75,'Sales from shift 257768 on 2022-05-19 08:21:39 ','2022-05-19 08:21:39','',''),('5','173',4955488,'','20','3177',634596.60,0.00,'Sales from shift 257769 on 2022-05-20 21:23:34 ','2022-05-20 21:23:34','',''),('5','173',4955489,'','6.1','3178',0.00,634596.60,'Sales from shift 257769 on 2022-05-20 21:23:34 ','2022-05-20 21:23:34','',''),('5','173',4955490,'','20','3177',485918.40,0.00,'Sales from shift 257770 on 2022-05-22 08:12:21 ','2022-05-22 08:12:21','',''),('5','173',4955491,'','6.1','3178',0.00,485918.40,'Sales from shift 257770 on 2022-05-22 08:12:21 ','2022-05-22 08:12:21','',''),('5','173',4955492,'','6.1','3178',38000.00,0.00,'Payment Id 400427 for invoice:257769, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955493,'','supplier','217',0.00,38000.00,'Payment Id 400427 for invoice:257769, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955494,'','2','3229',596600.00,0.00,'Payment Id 400426 for invoice:257769, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955495,'','supplier','217',0.00,596600.00,'Payment Id 400426 for invoice:257769, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955496,'','6.1','3178',25000.00,0.00,'Payment Id 400425 for invoice:257768, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955497,'','supplier','217',0.00,25000.00,'Payment Id 400425 for invoice:257768, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955498,'','2','3229',660400.00,0.00,'Payment Id 400424 for invoice:257768, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955499,'','supplier','217',0.00,660400.00,'Payment Id 400424 for invoice:257768, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955500,'','6.1','3178',30000.00,0.00,'Payment Id 400423 for invoice:257767, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955501,'','supplier','217',0.00,30000.00,'Payment Id 400423 for invoice:257767, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955502,'','2','3229',643100.00,0.00,'Payment Id 400422 for invoice:257767, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955503,'','supplier','217',0.00,643100.00,'Payment Id 400422 for invoice:257767, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955504,'','6.1','3178',25000.00,0.00,'Payment Id 400421 for invoice:257766, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955505,'','supplier','217',0.00,25000.00,'Payment Id 400421 for invoice:257766, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955506,'','2','3229',621900.00,0.00,'Payment Id 400420 for invoice:257766, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955507,'','supplier','217',0.00,621900.00,'Payment Id 400420 for invoice:257766, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955508,'','6.1','3178',25000.00,0.00,'Payment Id 400419 for invoice:257765, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955509,'','supplier','217',0.00,25000.00,'Payment Id 400419 for invoice:257765, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955510,'','2','3229',752550.00,0.00,'Payment Id 400418 for invoice:257765, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955511,'','supplier','217',0.00,752550.00,'Payment Id 400418 for invoice:257765, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:12:46','',''),('5','173',4955512,'','6.1','3178',24500.00,0.00,'Payment Id 400417 for invoice:257764, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955513,'','supplier','217',0.00,24500.00,'Payment Id 400417 for invoice:257764, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955514,'','2','3229',749100.00,0.00,'Payment Id 400416 for invoice:257764, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955515,'','supplier','217',0.00,749100.00,'Payment Id 400416 for invoice:257764, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955516,'','6.1','3178',59000.00,0.00,'Payment Id 400415 for invoice:257763, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955517,'','supplier','217',0.00,59000.00,'Payment Id 400415 for invoice:257763, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955518,'','2','3229',817440.00,0.00,'Payment Id 400414 for invoice:257763, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955519,'','supplier','217',0.00,817440.00,'Payment Id 400414 for invoice:257763, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955520,'','6.1','3178',23900.00,0.00,'Payment Id 400413 for invoice:257762, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955521,'','supplier','217',0.00,23900.00,'Payment Id 400413 for invoice:257762, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955522,'','2','3229',810540.00,0.00,'Payment Id 400412 for invoice:257762, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955523,'','supplier','217',0.00,810540.00,'Payment Id 400412 for invoice:257762, receipt: 2376833 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955524,'','6.1','3178',14500.00,0.00,'Payment Id 400292 for invoice:254377, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955525,'','supplier','217',0.00,14500.00,'Payment Id 400292 for invoice:254377, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955526,'','2','3228',152500.00,0.00,'Payment Id 400287 for invoice:254377, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955527,'','supplier','217',0.00,152500.00,'Payment Id 400287 for invoice:254377, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955528,'','2','3228',52540.00,0.00,'Payment Id 392890 for invoice:237759, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955529,'','supplier','217',0.00,52540.00,'Payment Id 392890 for invoice:237759, receipt: 75411885 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955530,'','6.1','3178',156017.00,0.00,'Payment Id 392889 for invoice:237757, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955531,'','supplier','217',0.00,156017.00,'Payment Id 392889 for invoice:237757, receipt: 75411867 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:15','',''),('5','173',4955532,'','2','3228',860.00,0.00,'Payment Id 392888 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:31','',''),('5','173',4955533,'','supplier','217',0.00,860.00,'Payment Id 392888 for invoice:237757, receipt: 75414110 by SALBAS OIL & GAS NIG. LTD','2022-05-22 08:13:31','',''),('5','173',4955534,'','20','3177',198024.75,0.00,'Sales from shift 257771 on 2022-05-22 14:37:34 ','2022-05-22 14:37:34','',''),('5','173',4955535,'','6.1','3178',0.00,198024.75,'Sales from shift 257771 on 2022-05-22 14:37:34 ','2022-05-22 14:37:34','',''),('5','173',4955536,'','20','3177',0.00,0.00,'Sales from shift 257772 on 2022-05-23 13:48:01 ','2022-05-23 13:48:01','',''),('5','173',4955537,'','6.1','3178',0.00,0.00,'Sales from shift 257772 on 2022-05-23 13:48:01 ','2022-05-23 13:48:01','',''),('5','173',4955538,'','20','3177',0.00,0.00,'Sales from shift 257773 on 2022-05-24 17:32:42 ','2022-05-24 17:32:42','',''),('5','173',4955539,'','6.1','3178',0.00,0.00,'Sales from shift 257773 on 2022-05-24 17:32:42 ','2022-05-24 17:32:42','',''),('5','173',4955540,'','20','3177',0.00,0.00,'Sales from shift 257774 on 2022-05-25 06:09:51 ','2022-05-25 06:09:51','',''),('5','173',4955541,'','6.1','3178',0.00,0.00,'Sales from shift 257774 on 2022-05-25 06:09:51 ','2022-05-25 06:09:51','',''),('5','173',4955542,'','20','3177',0.00,0.00,'Sales from shift 257775 on 2022-05-26 05:29:23 ','2022-05-26 05:29:23','',''),('5','173',4955543,'','6.1','3178',0.00,0.00,'Sales from shift 257775 on 2022-05-26 05:29:23 ','2022-05-26 05:29:23','',''),('5','173',4955544,'','20','3177',0.00,0.00,'Sales from shift 257776 on 2022-05-26 20:38:15 ','2022-05-26 20:38:15','',''),('5','173',4955545,'','6.1','3178',0.00,0.00,'Sales from shift 257776 on 2022-05-26 20:38:15 ','2022-05-26 20:38:15','',''),('5','173',4955546,'','20','3177',0.00,0.00,'Sales from shift 257777 on 2022-05-28 08:15:22 ','2022-05-28 08:15:22','',''),('5','173',4955547,'','6.1','3178',0.00,0.00,'Sales from shift 257777 on 2022-05-28 08:15:22 ','2022-05-28 08:15:22','',''),('5','173',4955548,'','20','3177',0.00,0.00,'Sales from shift 257778 on 2022-05-29 08:16:36 ','2022-05-29 08:16:36','',''),('5','173',4955549,'','6.1','3178',0.00,0.00,'Sales from shift 257778 on 2022-05-29 08:16:36 ','2022-05-29 08:16:36','',''),('5','173',4955550,'','20','3177',0.00,0.00,'Sales from shift 257779 on 2022-05-30 05:59:29 ','2022-05-30 05:59:29','',''),('5','173',4955551,'','6.1','3178',0.00,0.00,'Sales from shift 257779 on 2022-05-30 05:59:29 ','2022-05-30 05:59:29','',''),('5','173',4955552,'','20','3177',0.00,0.00,'Sales from shift 257780 on 2022-05-31 09:09:38 ','2022-05-31 09:09:38','',''),('5','173',4955553,'','6.1','3178',0.00,0.00,'Sales from shift 257780 on 2022-05-31 09:09:38 ','2022-05-31 09:09:38','',''),('5','173',4955554,'','20','3177',0.00,0.00,'Sales from shift 2577