-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_172
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_172`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_172` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_172`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3251 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3187,4019,'',0,'20','5','172','SALES','','2021-02-22 22:16:40',5,0.00,0.00,'','601','2021-02-22 22:16:40','601',0,1),(3188,3021,'',0,'6.1','5','172','CASH','','2021-02-22 22:16:58',5,0.00,0.00,'','601','2021-02-22 22:16:58','601',0,1),(3189,4004,'',0,'22','5','172','PURCHASES','','2021-02-22 22:17:29',5,0.00,0.00,'','601','2021-02-22 22:17:29','601',0,1),(3190,30156,'',0,'24','5','172','SALARIES & WAGES','','2021-02-22 22:18:53',5,0.00,0.00,'','601','2021-02-22 22:18:53','601',0,1),(3191,30157,'',0,'24','5','172','PURCHASES','','2021-02-22 22:19:27',5,0.00,0.00,'','601','2021-02-22 22:19:27','601',0,1),(3248,4030,'',0,'2','5','172','UBA-1023852421','','2021-03-06 01:48:47',5,0.00,0.00,'','600','2021-03-06 01:48:47','600',0,1),(3249,4031,'',0,'2','5','172','JA\'IZ-0010037957','','2022-03-02 18:58:44',5,0.00,0.00,'','600','2022-03-02 18:58:44','600',0,0),(3250,2000,'',0,'6','5','172','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:34:43',5,0.00,0.00,'','600','2023-02-06 10:34:43','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','172','0000-00-00','2023-02-20 16:47:48',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:51:12'),(2,'5','172','0000-00-00','2023-03-09 15:14:10',10,'600','','0000-00-00 00:00:00','600','2023-03-09 15:15:43');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (2,'5','172','1','219','supplier',0.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 500Ltrs',5000.00,'2023-02-19'),(3,'5','172','1','3250','6',5000.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 500Ltrs',0.00,'2023-02-19'),(4,'5','172','1','219','supplier',0.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 500Ltrs',5000.00,'2023-02-20'),(5,'5','172','1','3250','6',5000.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 500Ltrs',0.00,'2023-02-20'),(6,'5','172','2','219','supplier',0.00,'AGO price Decrease from 820 to 780 Dipping 500ltrs',20000.00,'2023-03-02'),(7,'5','172','2','3250','6',20000.00,'AGO Price Decrease from 820 To 780 Dipping is 500ltrs',0.00,'2023-03-02');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18542 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','172',16750,'913',200.00,200.00,'2021-10-08','','2021-10-08 15:25:16','600','600',2021,'600','2021-10-08 15:25:16',5),('5','172',16751,'914',26802.00,26802.00,'2021-10-08','','2021-10-08 15:25:32','600','600',2021,'600','2021-10-08 15:25:32',5),('5','172',16752,'913',200.00,26802.00,'2021-10-08','','2021-10-08 15:27:13','600','600',2021,'600','2021-10-08 15:27:13',5),('5','172',16753,'914',26802.00,200.00,'2021-10-08','','2021-10-08 15:27:23','600','600',2021,'600','2021-10-08 15:27:23',5),('5','172',16873,'914',435.31,620.00,'2021-10-20','170.20','2021-10-21 08:56:59','601','601',2021,'601','2021-10-21 08:56:59',5),('5','172',17107,'912',3787.11,3900.00,'2021-10-29','ADD DIPPING','2021-10-29 08:46:29','601','601',2021,'601','2021-10-29 08:46:29',5),('5','172',17155,'912',81.19,406.00,'2021-10-30','adding  dipping','2021-10-30 08:47:17','601','601',2021,'601','2021-10-30 08:47:17',5),('5','172',17733,'914',4660.07,4739.00,'2021-11-23','76','2021-11-23 10:40:57','601','601',2021,'601','2021-11-23 10:40:57',5),('5','172',17734,'914',4739.00,4750.00,'2021-11-23','10.83','2021-11-23 10:48:58','601','601',2021,'601','2021-11-23 10:48:58',5),('5','172',18328,'913',754.70,840.00,'2022-01-03','ADD UP','2022-01-03 07:50:30','601','601',2022,'601','2022-01-03 07:50:30',5),('5','172',18344,'913',4.10,435.00,'2022-01-04','adding','2022-01-04 08:16:38','601','601',2022,'601','2022-01-04 08:16:38',5),('5','172',18501,'913',645.58,807.00,'2022-01-19','adding dipping','2022-01-19 09:24:03','601','601',2022,'601','2022-01-19 09:24:03',5),('5','172',18502,'913',14998.58,350.00,'2022-02-09','','2022-02-09 15:49:08','600','600',2022,'600','2022-02-09 15:49:08',5),('5','172',18503,'914',9490.04,24650.00,'2022-02-09','','2022-02-09 15:49:48','600','600',2022,'600','2022-02-09 15:49:48',5),('5','172',18504,'914',2860.58,3000.00,'2022-02-11','','2022-02-11 09:48:56','600','600',2022,'600','2022-02-11 09:48:56',5),('5','172',18505,'912',18770.09,655.00,'2022-02-14','','2022-02-14 10:59:18','600','600',2022,'600','2022-02-14 10:59:18',5),('5','172',18506,'914',1349.13,300.00,'2022-03-30','','2022-03-30 21:46:47','601','601',2022,'601','2022-03-30 21:46:47',5),('5','172',18507,'914',300.00,1820.00,'2022-03-30','','2022-03-30 21:48:47','601','601',2022,'601','2022-03-30 21:48:47',5),('5','172',18508,'911',2742.27,3400.00,'2022-03-30','','2022-03-30 21:49:22','601','601',2022,'601','2022-03-30 21:49:22',5),('5','172',18509,'914',39754.55,8000.00,'2022-04-07','','2022-04-07 14:04:17','601','601',2022,'601','2022-04-07 14:04:17',5),('5','172',18510,'912',7095.68,7500.00,'2022-04-07','','2022-04-07 14:06:39','601','601',2022,'601','2022-04-07 14:06:39',5),('5','172',18511,'914',8000.00,36000.00,'2022-04-07','','2022-04-07 14:07:50','601','601',2022,'601','2022-04-07 14:07:50',5),('5','172',18512,'914',4545.22,8800.00,'2022-04-15','','2022-04-15 12:49:24','601','601',2022,'601','2022-04-15 12:49:24',5),('5','172',18513,'911',6101.93,6300.00,'2022-04-24','','2022-04-24 10:43:05','601','601',2022,'601','2022-04-24 10:43:05',5),('5','172',18514,'913',301.15,750.00,'2022-04-24','','2022-04-24 10:45:22','601','601',2022,'601','2022-04-24 10:45:22',5),('5','172',18515,'911',1321.73,1600.00,'2022-05-14','','2022-05-14 21:03:37','601','601',2022,'601','2022-05-14 21:03:37',5),('5','172',18516,'913',2791.26,3500.00,'2022-05-21','','2022-05-21 07:15:44','601','601',2022,'601','2022-05-21 07:15:44',5),('5','172',18517,'911',171.32,600.00,'2022-06-04','','2022-06-04 07:04:14','601','601',2022,'601','2022-06-04 07:04:14',5),('5','172',18518,'912',5594.13,6100.00,'2022-06-23','','2022-06-23 11:23:30','601','601',2022,'601','2022-06-23 11:23:30',5),('5','172',18519,'912',3599.39,2800.00,'2022-07-02','','2022-07-02 06:50:12','601','601',2022,'601','2022-07-02 06:50:12',5),('5','172',18520,'912',2800.00,3800.00,'2022-07-02','','2022-07-02 06:50:50','601','601',2022,'601','2022-07-02 06:50:50',5),('5','172',18521,'912',5810.43,6000.00,'2022-07-09','','2022-07-09 08:02:50','601','601',2022,'601','2022-07-09 08:02:50',5),('5','172',18522,'912',3276.56,4000.00,'2022-07-16','','2022-07-16 11:24:59','601','601',2022,'601','2022-07-16 11:24:59',5),('5','172',18523,'914',5947.52,6500.00,'2022-07-26','','2022-07-26 10:24:51','601','601',2022,'601','2022-07-26 10:24:51',5),('5','172',18524,'911',1900.37,4000.00,'2022-09-07','','2022-09-07 10:51:26','601','601',2022,'601','2022-09-07 10:51:26',5),('5','172',18525,'913',407.76,750.00,'2022-09-08','','2022-09-08 12:08:02','601','601',2022,'601','2022-09-08 12:08:02',5),('5','172',18526,'912',36329.16,750.00,'2022-09-14','','2022-09-14 12:03:49','601','601',2022,'601','2022-09-14 12:03:49',5),('5','172',18527,'912',750.00,750.00,'2022-09-14','','2022-09-14 12:07:18','601','601',2022,'601','2022-09-14 12:07:18',5),('5','172',18528,'914',284.78,1000.00,'2022-09-14','','2022-09-14 12:12:47','600','600',2022,'600','2022-09-14 12:12:47',5),('5','172',18529,'912',2360.00,43000.00,'2022-09-14','','2022-09-14 12:22:37','600','600',2022,'600','2022-09-14 12:22:37',5),('5','172',18530,'911',15083.86,13800.00,'2022-09-23','','2022-09-23 11:41:29','601','601',2022,'601','2022-09-23 11:41:29',5),('5','172',18531,'912',10339.14,1400.00,'2022-09-23','','2022-09-23 11:42:07','601','601',2022,'601','2022-09-23 11:42:07',5),('5','172',18532,'911',4646.79,7850.00,'2022-09-25','','2022-09-25 18:35:45','601','601',2022,'601','2022-09-25 18:35:45',5),('5','172',18533,'912',-3107.90,150.00,'2022-09-25','','2022-09-25 18:36:02','601','601',2022,'601','2022-09-25 18:36:02',5),('5','172',18534,'912',5823.58,8000.00,'2022-10-14','','2022-10-14 08:21:50','601','601',2022,'601','2022-10-14 08:21:50',5),('5','172',18535,'914',1336.25,1500.00,'2022-11-24','','2022-11-24 07:25:23','601','601',2022,'601','2022-11-24 07:25:23',5),('5','172',18536,'912',18917.61,19350.00,'2023-01-02','','2023-01-02 08:57:14','600','600',2023,'600','2023-01-02 08:57:14',5),('5','172',18537,'913',279.63,1500.00,'2023-02-04','','2023-02-04 15:09:41','600','600',2023,'600','2023-02-04 15:09:41',5),('5','172',18538,'914',95.30,1500.00,'2023-02-04','','2023-02-04 15:10:15','600','600',2023,'600','2023-02-04 15:10:15',5),('5','172',18539,'913',1500.00,200.00,'2023-02-04','','2023-02-04 15:10:34','600','600',2023,'600','2023-02-04 15:10:34',5),('5','172',18540,'912',12142.06,12400.00,'2023-03-07','','2023-03-07 15:24:38','600','600',2023,'600','2023-03-07 15:24:38',5),('5','172',18541,'912',12453.49,13000.00,'2023-03-09','','2023-03-09 09:22:43','600','600',2023,'600','2023-03-09 09:22:43',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2705 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','172','911',2694,'5','PMS PUMP 1',520049.77,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:27:18','600'),('5','172','911',2695,'5','PMS PUMP 2',880607.33,'PMS DISPENSER','',NULL,NULL,'',5,'2021-06-30 09:42:12','600'),('5','172','911',2696,'5','PMS PUMP 3',1031565.06,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:29:19','600'),('5','172','911',2697,'5','PMS PUMP 4',255998.04,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:30:04','600'),('5','172','912',2698,'5','PMS PUMP 5',776659.66,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:31:13','600'),('5','172','912',2699,'5','PMS PUMP 6',1229529.44,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:33:18','600'),('5','172','912',2700,'5','PMS PUMP 7',164619.43,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:35:47','600'),('5','172','912',2701,'5','PMS PUMP 8',498929.81,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-01 09:37:18','600'),('5','172','913',2702,'5','AGO PUMP 1',614847.57,'AGO DISPENSER','',NULL,NULL,'',5,'2021-06-30 09:41:08','600'),('5','172','914',2703,'5','AGO PUMP 2',1713051.57,'AGO DISPENSER','',NULL,NULL,'',5,'2021-03-03 14:35:53','600'),('5','172','915',2704,'5','DPK PUMP',436321.61,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258020 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','172',181808,'Daily','2021-03-01','2021-03-01 00:00:00',NULL,'601',0.00,0.00,'600','2021-03-03 14:34:28','600','2021-03-03 14:35:06',10,0),('5','172',182222,'MORNING','2021-03-03','2021-03-03 00:00:00',NULL,'600',0.00,1887822.38,'601','2021-03-03 14:56:08','600','2021-03-03 15:02:01',10,0),('5','172',182240,'Daily','2021-03-02','2021-03-02 00:00:00',NULL,'601',0.00,2780242.52,'601','2021-03-03 15:41:02','600','2021-03-03 15:45:43',10,0),('5','172',183162,'Daily','2021-03-08','2021-03-08 00:00:00',NULL,'601',0.00,2889223.28,'601','2021-03-08 16:49:58','607','2021-03-08 17:02:03',10,0),('5','172',183379,'Daily','2021-03-09','2021-03-09 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',183581,'Daily','2021-03-10','2021-03-10 00:00:00',NULL,'601',0.00,3004343.42,'601','2021-03-10 16:07:37','607','2021-03-10 16:16:43',10,0),('5','172',183585,'Daily','2021-03-10','2021-03-10 00:00:00',NULL,'601',0.00,3934375.35,'601','2021-03-10 16:27:53','607','2021-03-10 16:37:16',10,0),('5','172',183932,'Daily','2021-03-12','2021-03-12 00:00:00',NULL,'601',0.00,3262786.44,'601','2021-03-12 09:29:33','607','2021-03-12 09:55:28',10,0),('5','172',184015,'Daily','2021-03-12','2021-03-12 00:00:00',NULL,'601',0.00,3923515.56,'601','2021-03-13 07:14:42','607','2021-03-17 10:11:09',10,0),('5','172',185398,'Daily','2021-03-19','2021-03-19 00:00:00',NULL,'601',0.00,2111963.44,'601','2021-03-20 14:01:06','607','2021-03-20 14:45:17',10,0),('5','172',185582,'Daily','2021-03-08','2021-03-08 00:00:00',NULL,'601',0.00,5552047.36,'601','2021-03-20 15:00:48','607','2021-03-20 15:06:40',10,0),('5','172',185649,'Daily','2021-03-09','2021-03-09 00:00:00',NULL,'601',0.00,4360611.83,'601','2021-03-20 19:48:36','607','2021-03-20 19:53:07',10,0),('5','172',185650,'Daily','2021-03-10','2021-03-10 00:00:00',NULL,'601',0.00,2437275.78,'601','2021-03-20 20:06:34','607','2021-03-20 20:08:53',10,0),('5','172',185651,'Daily','2021-03-20','2021-03-20 00:00:00',NULL,'601',0.00,3899245.35,'601','2021-03-20 20:14:30','607','2021-03-20 20:15:37',10,0),('5','172',185652,'Daily','2021-03-12','2021-03-12 00:00:00',NULL,'601',0.00,4188358.70,'601','2021-03-20 20:21:37','607','2021-03-20 20:22:29',10,0),('5','172',185653,'Daily','2021-03-13','2021-03-13 00:00:00',NULL,'601',0.00,4546881.21,'601','2021-03-20 20:27:13','607','2021-03-20 20:28:43',10,0),('5','172',185655,'Daily','2021-03-14','2021-03-14 00:00:00',NULL,'601',0.00,4140544.90,'601','2021-03-20 20:36:39','607','2021-03-20 20:40:04',10,0),('5','172',185656,'Daily','2021-03-15','2021-03-15 00:00:00',NULL,'601',0.00,4635566.12,'601','2021-03-20 20:48:44','607','2021-03-20 20:52:37',10,0),('5','172',185657,'Daily','2021-03-16','2021-03-16 00:00:00',NULL,'601',0.00,7871841.80,'601','2021-03-20 21:01:31','607','2021-03-20 21:02:36',10,0),('5','172',185658,'MORNING','2021-03-17','2021-03-17 00:00:00',NULL,'601',0.00,2363496.20,'601','2021-03-20 21:23:55','607','2021-03-20 21:27:42',10,0),('5','172',185659,'AFTERNOON-NIGHT','2021-03-17','2021-03-17 00:00:00',NULL,'601',0.00,3448699.77,'601','2021-03-20 21:35:27','607','2021-03-20 21:46:54',10,0),('5','172',186113,'Daily','2021-03-23','2021-03-23 00:00:00',NULL,'601',0.00,5866193.54,'601','2021-03-26 16:48:59','607','2021-03-26 19:18:26',10,0),('5','172',186957,'DAILY','2021-03-19','2021-03-19 00:00:00',NULL,'601',5215942.57,5215942.57,'601','2021-03-26 21:41:55','607','2021-03-27 17:51:15',10,0),('5','172',187130,'DAILY','2021-03-20','2021-03-20 00:00:00',NULL,'601',6552835.94,6468552.19,'601','2021-03-27 18:56:17','607','2021-03-27 19:00:06',10,0),('5','172',187133,'DAILY','2021-03-21','2021-03-21 00:00:00',NULL,'601',2470907.22,2470907.22,'601','2021-03-27 19:06:00','607','2021-03-27 19:22:54',10,0),('5','172',187136,'DAILY','2021-03-22','2021-03-22 00:00:00',NULL,'601',3013490.21,3013490.21,'601','2021-03-27 19:35:16','607','2021-03-27 19:37:05',10,0),('5','172',187137,'DAILY','2021-03-23','2021-03-23 00:00:00',NULL,'601',2638135.44,2638135.44,'601','2021-03-27 19:50:24','607','2021-03-27 19:52:00',10,0),('5','172',187140,'DAILY','2021-03-24','2021-03-24 00:00:00',NULL,'601',4127550.38,4127550.38,'601','2021-03-27 20:01:28','607','2021-03-27 20:17:48',10,0),('5','172',187221,'DAILY','2021-03-25','2021-03-25 00:00:00',NULL,'601',4546727.75,4546727.75,'601','2021-03-28 10:18:33','607','2021-03-28 11:00:19',10,0),('5','172',187233,'DAILY','2021-03-26','2021-03-26 00:00:00',NULL,'601',5657205.16,5657205.16,'601','2021-03-28 11:15:42','607','2021-03-28 11:19:47',10,0),('5','172',187238,'DAILY','2021-03-27','2021-03-27 00:00:00',NULL,'601',4762790.90,4762790.90,'601','2021-03-28 11:27:58','607','2021-03-28 14:00:39',10,0),('5','172',187373,'DAILY','2021-03-28','2021-03-28 00:00:00',NULL,'601',3952079.22,3952079.22,'601','2021-03-29 07:39:14','607','2021-03-29 08:47:42',10,0),('5','172',187524,'DAILY','2021-03-29','2021-03-29 00:00:00',NULL,'601',5256143.44,5256143.44,'601','2021-03-30 08:45:38','607','2021-03-30 08:47:46',10,0),('5','172',187630,'DAILY','2021-03-30','2021-03-30 00:00:00',NULL,'601',4956718.39,4956718.39,'601','2021-03-31 06:43:34','607','2021-03-31 08:06:48',10,0),('5','172',187850,'DAILY','2021-03-31','2021-03-31 00:00:00',NULL,'601',4256103.96,4256103.96,'601','2021-04-01 06:40:40','607','2021-04-01 07:50:38',10,0),('5','172',188041,'DAILY','2021-04-01','2021-04-01 00:00:00',NULL,'601',4702689.24,4702689.24,'601','2021-04-02 07:06:39','607','2021-04-02 07:09:11',10,0),('5','172',188236,'DAILY','2021-04-02','2021-04-02 00:00:00',NULL,'601',5210127.64,5210127.64,'601','2021-04-03 06:07:08','607','2021-04-03 06:37:22',10,0),('5','172',188428,'DAILY','2021-04-03','2021-04-03 00:00:00',NULL,'601',4320883.08,4320883.08,'601','2021-04-04 07:14:39','607','2021-04-04 07:27:40',10,0),('5','172',188624,'DAILY','2021-04-04','2021-04-04 00:00:00',NULL,'601',2204533.36,2204533.36,'601','2021-04-05 07:05:40','607','2021-04-05 07:38:28',10,0),('5','172',188866,'DAILY','2021-04-05','2021-04-05 00:00:00',NULL,'601',1095471.00,1095471.00,'601','2021-04-06 08:42:11','607','2021-04-06 09:37:52',10,0),('5','172',189065,'DAILY','2021-04-06','2021-04-06 00:00:00',NULL,'601',2236423.80,2236423.80,'601','2021-04-07 06:49:19','604','2021-04-07 07:04:27',10,0),('5','172',189243,'DAILY','2021-04-07','2021-04-07 00:00:00',NULL,'601',2450481.80,2450481.80,'601','2021-04-09 07:31:30','607','2021-04-09 08:15:51',10,0),('5','172',189659,'DAILY','2021-04-08','2021-04-08 00:00:00',NULL,'601',3741639.28,3724759.15,'601','2021-04-09 08:44:24','607','2021-04-09 08:48:51',10,0),('5','172',189663,'DAILY','2021-04-09','2021-04-09 00:00:00',NULL,'601',4088078.88,4057624.80,'601','2021-04-13 09:33:33','607','2021-04-13 09:39:19',10,0),('5','172',190492,'DAILY','2021-04-10','2021-04-10 00:00:00',NULL,'601',3187775.60,3187775.60,'601','2021-04-13 16:58:46','607','2021-04-13 17:10:11',10,0),('5','172',190639,'DAILY','2021-04-11','2021-04-11 00:00:00',NULL,'601',3962914.50,3962914.50,'601','2021-04-13 17:23:09','607','2021-04-13 17:25:44',10,0),('5','172',190644,'DAILY','2021-04-12','2021-04-12 00:00:00',NULL,'601',3726389.70,3726389.70,'601','2021-04-14 18:23:53','607','2021-04-14 18:46:14',10,0),('5','172',191398,'DAILY','2021-04-13','2021-04-13 00:00:00',NULL,'601',3342819.35,3342819.35,'601','2021-04-17 13:01:37','607','2021-04-17 13:04:32',10,0),('5','172',191401,'DAILY','2021-04-14','2021-04-14 00:00:00',NULL,'601',3439134.00,3439134.00,'601','2021-04-17 13:08:00','607','2021-04-17 13:09:52',10,0),('5','172',191404,'DAILY','2021-04-15','2021-04-15 00:00:00',NULL,'601',4143761.90,4143761.90,'601','2021-04-17 13:14:56','607','2021-04-17 13:43:40',10,0),('5','172',191411,'DAILY','2021-04-16','2021-04-16 00:00:00',NULL,'601',3508191.70,3508191.70,'601','2021-04-17 13:47:05','607','2021-04-17 13:58:22',10,0),('5','172',191420,'DAILY','2021-04-17','2021-04-17 00:00:00',NULL,'601',1315857.40,1315857.40,'601','2021-04-18 06:48:53','607','2021-04-18 10:21:15',10,0),('5','172',192071,'DAILY','2021-04-18','2021-04-18 00:00:00',NULL,'601',532381.20,532381.20,'601','2021-04-21 09:09:28','607','2021-04-21 10:44:25',10,0),('5','172',192221,'DAILY','2021-04-19','2021-04-19 00:00:00',NULL,'601',3400313.80,3400313.80,'601','2021-04-21 15:54:17','607','2021-04-21 16:06:12',10,0),('5','172',192287,'DAILY','2021-04-20','2021-04-20 00:00:00',NULL,'601',1481914.20,1481914.20,'601','2021-04-22 14:54:18','607','2021-04-22 14:59:14',10,0),('5','172',192507,'DAILY','2021-04-21','2021-04-21 00:00:00',NULL,'601',1254918.60,1254918.60,'601','2021-04-22 15:12:11','607','2021-04-22 15:33:22',10,0),('5','172',192689,'DAILY','2021-04-22','2021-04-22 00:00:00',NULL,'601',2241348.20,2241348.20,'601','2021-04-23 15:23:34','607','2021-04-23 15:28:24',10,0),('5','172',192695,'DAILY','2021-04-23','2021-04-23 00:00:00',NULL,'601',1713283.00,17146009.10,'601','2021-04-25 07:56:39','607','2021-04-25 08:08:24',10,0),('5','172',192975,'DAILY','2021-04-24','2021-04-24 00:00:00',NULL,'601',1535944.80,1535944.80,'601','2021-04-25 08:13:02','607','2021-04-25 12:29:15',10,0),('5','172',193174,'DAILY','2021-04-25','2021-04-25 00:00:00',NULL,'601',2382198.00,2382198.00,'601','2021-04-26 07:16:41','607','2021-04-26 08:02:11',10,0),('5','172',193216,'DAILY','2021-04-26','2021-04-26 00:00:00',NULL,'601',2310479.55,2310479.55,'601','2021-04-27 11:29:23','607','2021-04-28 11:21:58',10,0),('5','172',193918,'DAILY','2021-04-27','2021-04-27 00:00:00',NULL,'601',2088715.75,2088715.75,'601','2021-04-29 10:10:15','607','2021-04-29 10:21:47',10,0),('5','172',193933,'DAILY','2021-04-28','2021-04-28 00:00:00',NULL,'601',2429698.20,2429698.20,'601','2021-05-05 12:54:37','607','2021-05-05 12:57:12',10,0),('5','172',195211,'DAILY','2021-04-29','2021-04-29 00:00:00',NULL,'601',2784708.35,2784708.35,'601','2021-05-05 13:04:07','607','2021-05-05 13:44:53',10,0),('5','172',195234,'DAILY','2021-04-30','2021-04-30 00:00:00',NULL,'601',2722475.35,2722475.35,'601','2021-05-05 14:09:20','607','2021-05-05 14:18:06',10,0),('5','172',195242,'DAILY','2021-05-01','2021-05-01 00:00:00',NULL,'601',3151803.55,3151803.55,'601','2021-05-06 10:03:14','607','2021-05-06 10:24:06',10,0),('5','172',195382,'DAILY','2021-05-02','2021-05-02 00:00:00',NULL,'601',3266854.00,3266854.00,'601','2021-05-08 12:27:29','607','2021-05-08 12:42:47',10,0),('5','172',195889,'DAILY','2021-05-03','2021-05-03 00:00:00',NULL,'601',3306435.60,3306435.60,'601','2021-05-08 12:48:34','607','2021-05-08 12:56:46',10,0),('5','172',195899,'DAILY','2021-05-04','2021-05-04 00:00:00',NULL,'601',2678225.20,2678225.20,'601','2021-05-20 08:01:31','607','2021-05-20 08:03:45',10,0),('5','172',198386,'DAILY SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'601',2045983.55,2045983.55,'601','2021-05-20 12:00:41','607','2021-05-20 12:01:58',10,0),('5','172',198447,'DAILY SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'601',1543271.40,1543271.40,'601','2021-05-20 12:04:52','607','2021-05-20 12:06:44',10,0),('5','172',198448,'DAILY SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'601',1329442.95,1329442.95,'601','2021-05-20 12:11:17','607','2021-05-20 12:12:05',10,0),('5','172',198450,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'601',1479258.00,1479258.00,'601','2021-05-20 12:19:11','607','2021-05-20 12:20:01',10,0),('5','172',198451,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'601',1596351.90,1596351.90,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',198475,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'601',2093006.50,2093006.50,'601','2021-05-20 13:53:28','607','2021-05-20 13:55:27',10,0),('5','172',198478,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'601',2708916.95,2708916.95,'601','2021-05-20 14:00:30','607','2021-05-20 14:04:07',10,0),('5','172',198484,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'601',2560975.70,2560975.70,'601','2021-05-20 14:08:49','607','2021-05-20 14:09:47',10,0),('5','172',198488,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'601',1665114.80,1665114.80,'601','2021-05-20 14:15:43','607','2021-05-20 14:16:51',10,0),('5','172',198492,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'601',1489382.10,1489382.10,'601','2021-05-20 14:20:48','607','2021-05-20 14:22:13',10,0),('5','172',198493,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'601',2002467.10,2002467.10,'601','2021-05-20 14:24:38','607','2021-05-20 14:27:12',10,0),('5','172',198499,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'601',1811347.00,1811347.00,'601','2021-05-20 14:37:28','607','2021-05-20 14:40:08',10,0),('5','172',198504,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'601',1955518.75,1955518.75,'601','2021-05-20 14:51:59','607','2021-05-20 14:53:15',10,0),('5','172',198506,'DAILY SHIF','2021-05-17','2021-05-17 00:00:00',NULL,'601',2284360.50,854341.80,'601','2021-05-22 10:42:49','607','2021-05-22 10:45:28',10,0),('5','172',198858,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'601',2251908.90,2251908.90,'601','2021-05-22 10:51:26','607','2021-05-22 10:52:25',10,0),('5','172',198862,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'601',2142218.25,2142218.25,'601','2021-05-22 10:57:21','607','2021-05-22 11:01:25',10,0),('5','172',198866,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'601',2858694.00,2858694.00,'601','2021-05-22 11:07:35','607','2021-05-22 11:08:32',10,0),('5','172',199071,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'601',2779752.75,2779752.75,'601','2021-05-23 11:02:16','607','2021-05-23 11:04:55',10,0),('5','172',199074,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'601',1798102.05,1798102.05,'601','2021-05-23 11:09:05','607','2021-05-23 11:10:22',10,0),('5','172',199290,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'601',2372984.40,2372984.40,'601','2021-05-24 09:03:48','607','2021-05-24 09:09:12',10,0),('5','172',199499,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'601',2908232.85,2908232.85,'601','2021-05-25 08:59:21','607','2021-05-25 09:34:59',10,0),('5','172',199601,'DAILY','2021-05-25','2021-05-25 00:00:00',NULL,'601',2384669.55,2384669.55,'601','2021-05-26 14:59:10','607','2021-05-26 15:11:29',10,0),('5','172',199816,'DAILY','2021-05-26','2021-05-26 00:00:00',NULL,'601',2670184.95,2670184.95,'601','2021-05-27 10:23:16','607','2021-05-27 10:31:10',10,0),('5','172',199962,'DAILY','2021-05-27','2021-05-27 00:00:00',NULL,'601',2426920.35,2426920.35,'601','2021-05-28 09:07:52','607','2021-05-28 09:10:43',10,0),('5','172',200156,'DAILY','2021-05-28','2021-05-28 00:00:00',NULL,'601',2413941.60,2413941.60,'601','2021-05-29 08:51:07','607','2021-05-29 08:52:51',10,0),('5','172',200327,'DAILY','2021-05-29','2021-05-29 00:00:00',NULL,'601',2633079.90,2633079.90,'601','2021-05-30 07:14:51','607','2021-05-30 08:36:47',10,0),('5','172',200527,'DAILY','2021-05-30','2021-05-30 00:00:00',NULL,'601',2430072.45,2430072.45,'601','2021-05-31 07:43:41','607','2021-05-31 08:32:16',10,0),('5','172',200747,'DAILY','2021-05-31','2021-05-31 00:00:00',NULL,'601',2708703.30,2708703.30,'601','2021-06-01 16:08:16','607','2021-06-01 16:09:54',10,0),('5','172',201070,'DAILY','2021-06-01','2021-06-01 00:00:00',NULL,'601',2853450.00,2853450.00,'601','2021-06-02 08:42:09','607','2021-06-02 09:15:04',10,0),('5','172',201176,'DAILY','2021-06-02','2021-06-02 00:00:00',NULL,'601',3290513.25,3290513.25,'601','2021-06-03 07:53:07','607','2021-06-03 08:38:01',10,0),('5','172',201367,'DAILY','2021-06-03','2021-06-03 00:00:00',NULL,'601',2647779.15,2647779.15,'601','2021-06-04 09:14:56','607','2021-06-04 09:16:35',10,0),('5','172',201561,'DAILY','2021-06-04','2021-06-04 00:00:00',NULL,'601',2420226.90,2420226.90,'601','2021-06-05 14:16:11','607','2021-06-05 14:21:03',10,0),('5','172',201926,'DAILY','2021-06-05','2021-06-05 00:00:00',NULL,'601',2901742.20,2901742.20,'601','2021-06-06 19:01:15','607','2021-06-06 19:03:25',10,0),('5','172',202179,'DAILY','2021-06-06','2021-06-06 00:00:00',NULL,'601',4006306.95,4006306.95,'601','2021-06-07 07:43:57','607','2021-06-07 08:08:01',10,0),('5','172',202269,'DAILY','2021-06-07','2021-06-07 00:00:00',NULL,'601',3303461.55,3303461.55,'601','2021-06-08 07:59:38','607','2021-06-08 08:01:56',10,0),('5','172',202465,'DAILY','2021-06-08','2021-06-08 00:00:00',NULL,'601',3188667.60,3188667.60,'601','2021-06-09 13:51:05','607','2021-06-09 13:52:46',10,0),('5','172',202776,'DAILY','2021-06-09','2021-06-09 00:00:00',NULL,'601',2578189.05,2578189.05,'601','2021-06-10 09:08:01','607','2021-06-10 09:10:58',10,0),('5','172',202926,'DAILY','2021-06-10','2021-06-10 00:00:00',NULL,'601',2710272.90,2710272.90,'601','2021-06-11 07:32:23','607','2021-06-11 07:38:19',10,0),('5','172',203135,'DAILY','2021-06-11','2021-06-11 00:00:00',NULL,'601',2723816.85,2723816.85,'601','2021-06-12 10:02:33','607','2021-06-12 10:06:54',10,0),('5','172',203367,'DAILY','2021-06-12','2021-06-12 00:00:00',NULL,'601',2609886.45,2609886.45,'601','2021-06-13 09:05:00','607','2021-06-13 09:19:44',10,0),('5','172',203583,'DAILY','2021-06-13','2021-06-13 00:00:00',NULL,'601',2750990.40,2750990.40,'601','2021-06-14 08:16:07','607','2021-06-14 08:17:38',10,0),('5','172',203774,'DAILY','2021-06-14','2021-06-14 00:00:00',NULL,'601',2966889.90,2966889.90,'601','2021-06-15 09:52:49','607','2021-06-15 10:05:24',10,0),('5','172',204044,'DAILY','2021-06-15','2021-06-15 00:00:00',NULL,'601',2586267.15,2586267.15,'601','2021-06-16 08:15:08','607','2021-06-16 09:41:14',10,0),('5','172',204264,'DAILY','2021-06-16','2021-06-16 00:00:00',NULL,'601',893148.30,893148.30,'601','2021-06-17 08:13:57','607','2021-06-17 08:23:28',10,0),('5','172',204450,'DAILY','2021-06-17','2021-06-17 00:00:00',NULL,'601',1087526.55,1087526.55,'601','2021-06-18 07:22:04','607','2021-06-18 07:33:10',10,0),('5','172',204658,'DAILY','2021-06-18','2021-06-18 00:00:00',NULL,'601',1133490.60,1133490.60,'601','2021-06-19 08:30:51','607','2021-06-19 08:33:18',10,0),('5','172',204878,'DAILY','2021-06-19','2021-06-19 00:00:00',NULL,'601',1051340.40,1051340.40,'601','2021-06-20 06:58:55','607','2021-06-20 08:38:00',10,0),('5','172',205201,'DAILY','2021-06-20','2021-06-20 00:00:00',NULL,'601',2999240.25,2999240.25,'601','2021-06-21 14:07:32','607','2021-06-21 14:23:17',10,0),('5','172',205384,'DAILY','2021-06-21','2021-06-21 00:00:00',NULL,'601',2651910.75,2733541.85,'601','2021-06-22 08:30:05','607','2021-06-22 09:43:26',10,0),('5','172',205539,'DAILY','2021-06-22','2021-06-22 00:00:00',NULL,'601',1582162.20,1640760.80,'601','2021-06-23 08:16:27','607','2021-06-23 09:08:05',10,0),('5','172',205786,'DAILY','2021-06-23','2021-06-23 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',205790,'DAILY','2021-06-23','2021-06-23 00:00:00',NULL,'601',1138976.10,1181160.40,'601','2021-06-24 06:53:16','607','2021-06-24 07:43:21',10,0),('5','172',206008,'DAILY','2021-06-24','2021-06-24 00:00:00',NULL,'601',1590204.00,1631687.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',206237,'DAILY','2021-06-24','2021-06-24 00:00:00',NULL,'601',1673170.40,1673170.40,'601','2021-06-25 10:24:22','607','2021-06-25 10:26:08',10,0),('5','172',206243,'DAILY','2021-06-25','2021-06-25 00:00:00',NULL,'601',1585462.60,1585462.60,'601','2021-06-26 08:11:45','607','2021-06-26 11:47:05',10,0),('5','172',206492,'DAILY','2021-06-26','2021-06-26 00:00:00',NULL,'601',820277.70,820277.70,'601','2021-06-27 07:46:04','607','2021-06-27 09:18:15',10,0),('5','172',206695,'DAILY','2021-06-27','2021-06-27 00:00:00',NULL,'601',871472.25,871472.25,'601','2021-06-28 08:50:06','607','2021-06-28 08:54:42',10,0),('5','172',206871,'DAILY','2021-06-28','2021-06-28 00:00:00',NULL,'601',1090506.45,1090506.45,'601','2021-06-29 08:39:44','607','2021-06-29 08:50:12',10,0),('5','172',207088,'DAILY','2021-06-29','2021-06-29 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',207335,'DAILY','2021-06-29','2021-06-29 00:00:00',NULL,'601',1737147.25,1737147.25,'601','2021-06-30 09:51:41','607','2021-06-30 09:54:44',10,0),('5','172',207341,'DAILY','2021-06-30','2021-06-30 00:00:00',NULL,'601',2314456.75,2314456.75,'601','2021-07-01 08:21:11','607','2021-07-01 08:23:58',10,0),('5','172',207521,'DAILY','2021-07-01','2021-07-01 00:00:00',NULL,'601',1847413.15,1847413.15,'601','2021-07-02 09:40:01','607','2021-07-02 10:36:17',10,0),('5','172',207819,'DAILY','2021-07-02','2021-07-02 00:00:00',NULL,'601',1336760.55,1336760.55,'601','2021-07-03 09:13:18','607','2021-07-03 09:28:33',10,0),('5','172',207964,'DAILY','2021-07-03','2021-07-03 00:00:00',NULL,'601',879542.40,879542.40,'601','2021-07-04 09:57:47','607','2021-07-04 09:59:53',10,0),('5','172',208186,'DAILY','2021-07-04','2021-07-04 00:00:00',NULL,'601',1074443.70,1074443.70,'601','2021-07-05 08:38:53','607','2021-07-05 08:40:31',10,0),('5','172',208388,'DAILY','2021-07-05','2021-07-05 00:00:00',NULL,'601',1129388.70,1129388.70,'601','2021-07-06 08:21:39','607','2021-07-06 08:24:09',10,0),('5','172',208592,'DAILY','2021-07-06','2021-07-06 00:00:00',NULL,'601',853675.35,853675.35,'601','2021-07-07 08:06:17','607','2021-07-07 08:29:25',10,0),('5','172',208818,'DAILY','2021-07-07','2021-07-07 00:00:00',NULL,'601',840849.90,840849.90,'601','2021-07-08 09:07:05','607','2021-07-08 09:27:44',10,0),('5','172',209102,'DAILY','2021-07-08','2021-07-08 00:00:00',NULL,'601',982796.10,982796.10,'601','2021-07-09 08:16:46','607','2021-07-09 08:21:48',10,0),('5','172',209251,'DAILY','2021-07-09','2021-07-09 00:00:00',NULL,'601',990239.25,990239.25,'601','2021-07-10 08:31:59','607','2021-07-10 08:38:45',10,0),('5','172',209488,'DAILY','2021-07-10','2021-07-10 00:00:00',NULL,'601',808734.30,808734.30,'601','2021-07-11 07:57:08','607','2021-07-11 07:59:49',10,0),('5','172',209671,'DAILY','2021-07-11','2021-07-11 00:00:00',NULL,'601',907315.20,907315.20,'601','2021-07-12 08:29:49','607','2021-07-12 08:33:03',10,0),('5','172',209913,'DAILY','2021-07-12','2021-07-12 00:00:00',NULL,'601',1301312.10,1301312.10,'601','2021-07-13 08:05:50','607','2021-07-13 08:10:53',10,0),('5','172',210143,'DAILY','2021-07-13','2021-07-13 00:00:00',NULL,'601',1098830.70,1098830.70,'601','2021-07-14 07:44:47','607','2021-07-14 07:50:46',10,0),('5','172',210347,'DAILY','2021-07-14','2021-07-14 00:00:00',NULL,'601',1104254.25,1104254.25,'601','2021-07-15 07:38:21','607','2021-07-15 07:59:49',10,0),('5','172',210536,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'601',1530155.25,1530155.25,'601','2021-07-16 07:59:26','607','2021-07-16 09:09:41',10,0),('5','172',210789,'DAILY','2021-07-16','2021-07-16 00:00:00',NULL,'601',842580.75,842580.75,'601','2021-07-17 07:00:46','607','2021-07-17 08:42:14',10,0),('5','172',211139,'DAILY','2021-07-17','2021-07-17 00:00:00',NULL,'601',1134853.50,1134853.50,'601','2021-07-18 13:13:02','607','2021-07-18 13:16:41',10,0),('5','172',211281,'DAILY','2021-07-18','2021-07-18 00:00:00',NULL,'601',1590994.35,1590994.35,'601','2021-07-19 07:52:01','607','2021-07-19 07:57:10',10,0),('5','172',211403,'DAILY','2021-07-19','2021-07-19 00:00:00',NULL,'601',971528.25,971528.25,'601','2021-07-20 16:06:25','607','2021-07-20 16:09:43',10,0),('5','172',211719,'DAILY','2021-07-20','2021-07-20 00:00:00',NULL,'601',390843.75,390843.75,'601','2021-07-21 11:20:36','607','2021-07-21 11:32:33',10,0),('5','172',211867,'DAILY','2021-07-21','2021-07-21 00:00:00',NULL,'601',350669.55,350669.55,'601','2021-07-22 08:54:38','607','2021-07-22 09:04:40',10,0),('5','172',212041,'DAILY','2021-07-22','2021-07-22 00:00:00',NULL,'601',495765.60,495765.60,'601','2021-07-23 09:55:11','607','2021-07-23 10:00:24',10,0),('5','172',212309,'DAILY','2021-07-23','2021-07-23 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',212510,'DAILY','2021-07-23','2021-07-23 00:00:00',NULL,'601',733522.55,733522.55,'601','2021-07-24 09:42:19','607','2021-07-24 09:45:38',10,0),('5','172',212520,'DAILY','2021-07-24','2021-07-24 00:00:00',NULL,'601',1083667.80,1083667.80,'601','2021-07-25 08:13:05','607','2021-07-25 08:14:40',10,0),('5','172',212694,'DAILY','2021-07-25','2021-07-25 00:00:00',NULL,'601',1365508.65,1365508.65,'601','2021-07-26 16:20:20','607','2021-07-26 16:34:42',10,0),('5','172',213073,'DAILY','2021-07-26','2021-07-26 00:00:00',NULL,'601',1556615.20,1556615.20,'601','2021-07-27 08:33:51','607','2021-07-27 08:38:58',10,0),('5','172',213177,'DAILY','2021-07-27','2021-07-27 00:00:00',NULL,'601',1220777.85,1220777.85,'601','2021-07-28 08:20:39','607','2021-07-28 08:56:19',10,0),('5','172',213445,'DAILY','2021-07-28','2021-07-28 00:00:00',NULL,'601',1572080.00,1572080.00,'601','2021-07-29 08:32:49','607','2021-07-29 08:55:20',10,0),('5','172',213687,'DAILY','2021-07-29','2021-07-29 00:00:00',NULL,'601',2035613.90,2035613.90,'601','2021-07-30 07:38:34','607','2021-07-30 09:55:39',10,0),('5','172',213956,'DAILY','2021-07-30','2021-07-30 00:00:00',NULL,'601',1665148.25,1665148.25,'601','2021-07-31 08:23:32','607','2021-07-31 08:27:56',10,0),('5','172',214133,'DAILY','2021-07-31','2021-07-31 00:00:00',NULL,'601',1306431.00,1306431.00,'601','2021-08-02 17:17:37','607','2021-08-02 17:23:10',10,0),('5','172',214736,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'601',2140522.80,2140522.80,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',214860,'DAILY','2021-08-01','2021-08-01 00:00:00',NULL,'601',2140522.80,2140522.80,'601','2021-08-03 10:23:07','607','2021-08-03 10:25:57',10,0),('5','172',214862,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'601',2393095.95,2393095.95,'601','2021-08-03 10:36:01','607','2021-08-03 10:38:13',10,0),('5','172',214864,'DAILY','2021-08-03','2021-08-03 00:00:00',NULL,'601',1538145.35,1538145.35,'601','2021-08-04 07:32:57','607','2021-08-04 07:39:45',10,0),('5','172',215027,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'601',2263187.00,2263187.00,'601','2021-08-05 07:16:37','607','2021-08-05 07:18:55',10,0),('5','172',215242,'DAILY','2021-08-05','2021-08-05 00:00:00',NULL,'601',2312412.25,2312412.25,'601','2021-08-06 09:09:25','607','2021-08-06 10:04:28',10,0),('5','172',215538,'DAILY','2021-08-06','2021-08-06 00:00:00',NULL,'601',2243863.70,2243863.70,'601','2021-08-07 08:40:00','607','2021-08-07 08:50:59',10,0),('5','172',215799,'DAILY','2021-08-07','2021-08-07 00:00:00',NULL,'601',1777894.05,1777894.05,'601','2021-08-08 07:35:23','607','2021-08-08 07:40:26',10,0),('5','172',215926,'DAILY','2021-08-08','2021-08-08 00:00:00',NULL,'601',1709425.70,1709425.70,'601','2021-08-09 10:22:54','607','2021-08-09 10:25:36',10,0),('5','172',216191,'DAILY','2021-08-09','2021-08-09 00:00:00',NULL,'601',2770895.60,2770895.60,'601','2021-08-10 08:06:54','607','2021-08-10 08:10:07',10,0),('5','172',216370,'DAILY','2021-08-10','2021-08-10 00:00:00',NULL,'601',1476547.80,1476547.80,'601','2021-08-11 08:53:33','607','2021-08-11 08:57:58',10,0),('5','172',216609,'DAILY','2021-08-11','2021-08-11 00:00:00',NULL,'601',1719504.40,1719504.40,'601','2021-08-12 07:55:26','607','2021-08-12 15:20:02',10,0),('5','172',216949,'DAILY','2021-08-12','2021-08-12 00:00:00',NULL,'601',1949962.00,1949962.00,'601','2021-08-13 08:53:40','607','2021-08-13 08:59:45',10,0),('5','172',217086,'DAILY','2021-08-13','2021-08-13 00:00:00',NULL,'601',2059323.45,2059323.45,'601','2021-08-14 08:04:05','607','2021-08-14 08:07:40',10,0),('5','172',217315,'DAILY','2021-08-14','2021-08-14 00:00:00',NULL,'601',1797803.95,1797803.95,'601','2021-08-16 10:03:18','607','2021-08-16 10:07:02',10,0),('5','172',217809,'DAILY','2021-08-15','2021-08-15 00:00:00',NULL,'601',2000837.00,2000837.00,'601','2021-08-16 10:18:19','607','2021-08-16 10:19:34',10,0),('5','172',217819,'DAILY','2021-08-16','2021-08-16 00:00:00',NULL,'601',2113309.40,2113309.40,'601','2021-08-17 08:24:25','607','2021-08-17 08:26:01',10,0),('5','172',218031,'DAILY','2021-08-17','2021-08-17 00:00:00',NULL,'601',1633603.30,1633603.30,'601','2021-08-18 08:22:56','607','2021-08-18 08:26:20',10,0),('5','172',218266,'DAILY','2021-08-18','2021-08-18 00:00:00',NULL,'601',2106608.75,2106608.75,'601','2021-08-19 09:46:24','607','2021-08-20 07:41:07',10,0),('5','172',218715,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'601',1832676.15,1832676.15,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',218742,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',218747,'DAILY','2021-08-19','2021-08-19 00:00:00',NULL,'601',1832676.15,1832676.15,'601','2021-08-20 09:35:40','607','2021-08-20 09:42:54',10,0),('5','172',218751,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'601',2187903.65,2187903.65,'601','2021-08-21 10:10:45','607','2021-08-21 10:15:05',10,0),('5','172',218963,'DAILY','2021-08-21','2021-08-21 00:00:00',NULL,'601',1899801.30,1899801.30,'601','2021-08-22 08:50:41','607','2021-08-22 08:52:22',10,0),('5','172',219166,'DAILY','2021-08-22','2021-08-22 00:00:00',NULL,'601',1535389.35,1535389.35,'601','2021-08-23 09:11:30','607','2021-08-23 09:16:16',10,0),('5','172',219419,'DAILY','2021-08-23','2021-08-23 00:00:00',NULL,'601',1925006.00,1925006.00,'601','2021-08-24 08:39:57','607','2021-08-24 08:52:23',10,0),('5','172',219722,'DAILY','2021-08-24','2021-08-24 00:00:00',NULL,'601',1716401.65,1716401.65,'601','2021-08-25 08:28:50','607','2021-08-25 08:31:05',10,0),('5','172',219861,'DAILY','2021-08-25','2021-08-25 00:00:00',NULL,'601',2863783.80,2863783.80,'601','2021-08-26 09:19:56','607','2021-08-26 09:34:59',10,0),('5','172',220113,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'601',1612922.70,1612922.70,'601','2021-08-27 09:05:25','607','2021-08-27 09:32:03',10,0),('5','172',220317,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',220399,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'601',1750041.35,1719195.22,'601','2021-08-28 09:16:49','607','2021-08-28 09:40:43',10,0),('5','172',220539,'DAILY','2021-08-28','2021-08-28 00:00:00',NULL,'601',1677634.60,1648179.44,'601','2021-08-29 16:37:51','607','2021-08-29 16:44:16',10,0),('5','172',220854,'DAILY','2021-08-29','2021-08-29 00:00:00',NULL,'601',1875394.71,1859804.46,'601','2021-08-30 09:10:18','607','2021-08-30 09:16:04',10,0),('5','172',220994,'DAILY','2021-08-30','2021-08-30 00:00:00',NULL,'601',1779227.29,1765585.34,'601','2021-08-31 08:25:02','607','2021-08-31 08:30:47',10,0),('5','172',221207,'DAILY','2021-08-31','2021-08-31 00:00:00',NULL,'601',2220524.28,2199188.88,'601','2021-09-01 08:20:19','607','2021-09-01 08:59:18',10,0),('5','172',221450,'DAILY','2021-09-01','2021-09-01 00:00:00',NULL,'601',1683725.28,1667098.38,'601','2021-09-02 09:32:41','607','2021-09-02 10:51:31',10,0),('5','172',221703,'DAILY','2021-09-02','2021-09-02 00:00:00',NULL,'601',1793281.88,1780100.98,'601','2021-09-03 09:37:39','607','2021-09-03 10:00:13',10,0),('5','172',221903,'DAILY','2021-09-03','2021-09-03 00:00:00',NULL,'601',1966685.42,1956405.22,'601','2021-09-04 09:08:34','607','2021-09-04 09:10:29',10,0),('5','172',222104,'DAILY','2021-09-04','2021-09-04 00:00:00',NULL,'601',1820856.48,1807813.38,'601','2021-09-05 12:41:43','607','2021-09-05 12:45:17',10,0),('5','172',222376,'DAILY','2021-09-05','2021-09-05 00:00:00',NULL,'601',2081435.01,2064525.96,'601','2021-09-06 08:31:35','607','2021-09-06 08:35:26',10,0),('5','172',222546,'DAILY','2021-09-06','2021-09-06 00:00:00',NULL,'601',2468807.16,2451671.76,'601','2021-09-07 08:59:34','607','2021-09-07 14:11:04',10,0),('5','172',222873,'DAILY','2021-09-07','2021-09-07 00:00:00',NULL,'601',2509536.52,2488668.02,'601','2021-09-08 09:33:31','607','2021-09-08 09:37:47',10,0),('5','172',223002,'DAILY','2021-09-08','2021-09-08 00:00:00',NULL,'601',2502529.68,2478340.68,'601','2021-09-09 14:06:58','607','2021-09-09 15:24:31',10,0),('5','172',223343,'DAILY','2021-09-09','2021-09-09 00:00:00',NULL,'601',2010555.20,1992171.40,'601','2021-09-10 10:45:12','607','2021-09-10 15:36:10',10,0),('5','172',223683,'DAILY','2021-09-10','2021-09-10 00:00:00',NULL,'601',1890767.28,1873564.08,'601','2021-09-11 09:03:56','607','2021-09-11 09:05:25',10,0),('5','172',223690,'DAILY','2021-09-11','2021-09-11 00:00:00',NULL,'601',2169380.32,2153027.72,'601','2021-09-12 08:17:31','607','2021-09-12 08:19:10',10,0),('5','172',223901,'DAILY','2021-09-12','2021-09-12 00:00:00',NULL,'601',1620792.54,1620792.54,'601','2021-09-13 07:49:45','607','2021-09-13 09:00:36',10,0),('5','172',224150,'DAILY','2021-09-13','2021-09-13 00:00:00',NULL,'601',2512502.24,2512502.24,'601','2021-09-14 07:38:24','607','2021-09-14 08:31:27',10,0),('5','172',224375,'DAILY','2021-09-14','2021-09-14 00:00:00',NULL,'601',405540.98,405540.98,'601','2021-09-16 08:18:05','607','2021-09-16 08:19:39',10,0),('5','172',224816,'DAILY','2021-09-15','2021-09-15 00:00:00',NULL,'601',0.00,0.00,'601','2021-09-16 08:23:32','607','2021-09-16 08:25:57',10,0),('5','172',224818,'DAILY','2021-09-16','2021-09-16 00:00:00',NULL,'601',1567997.40,1567997.40,'601','2021-09-17 08:37:13','607','2021-09-17 09:04:16',10,0),('5','172',225070,'DAILY','2021-09-17','2021-09-17 00:00:00',NULL,'601',1833654.60,1833654.60,'601','2021-09-18 07:50:00','607','2021-09-18 08:26:33',10,0),('5','172',225321,'DAILY','2021-09-18','2021-09-18 00:00:00',NULL,'601',2247992.72,2247992.72,'601','2021-09-20 07:50:51','607','2021-09-20 09:07:57',10,0),('5','172',225805,'DAILY','2021-09-19','2021-09-19 00:00:00',NULL,'601',2473428.46,2473428.46,'601','2021-09-20 10:34:00','607','2021-09-20 15:30:17',10,0),('5','172',225928,'DAILY','2021-09-20','2021-09-20 00:00:00',NULL,'601',1977823.54,1977823.54,'601','2021-09-21 07:35:55','607','2021-09-21 09:45:29',10,0),('5','172',226133,'DAILY','2021-09-21','2021-09-21 00:00:00',NULL,'601',1946430.26,1946430.26,'601','2021-09-22 08:29:10','607','2021-09-22 09:08:00',10,0),('5','172',226272,'DAILY','2021-09-22','2021-09-22 00:00:00',NULL,'601',1970901.40,1970901.40,'601','2021-09-23 08:59:58','607','2021-09-23 10:25:34',10,0),('5','172',226567,'DAILY','2021-09-23','2021-09-23 00:00:00',NULL,'601',2215809.72,2215809.72,'601','2021-09-24 08:30:53','607','2021-09-24 09:24:39',10,0),('5','172',226910,'DAILY','2021-09-24','2021-09-24 00:00:00',NULL,'601',1575256.70,1575256.70,'601','2021-09-25 09:36:33','607','2021-09-25 09:38:12',10,0),('5','172',227035,'DAILY','2021-09-25','2021-09-25 00:00:00',NULL,'601',1811022.82,1811022.82,'601','2021-09-26 07:56:30','607','2021-09-26 08:24:57',10,0),('5','172',227244,'DAILY','2021-09-26','2021-09-26 00:00:00',NULL,'601',1152764.62,1152764.62,'601','2021-09-27 09:04:54','607','2021-09-27 09:32:18',10,0),('5','172',227454,'DAILY','2021-09-27','2021-09-27 00:00:00',NULL,'601',1106165.90,1106165.90,'601','2021-09-28 08:51:52','607','2021-09-28 11:12:17',10,0),('5','172',227734,'DAILY','2021-09-28','2021-09-28 00:00:00',NULL,'601',1396281.14,1405340.29,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',227974,'DAILY','2021-09-29','2021-09-29 00:00:00',NULL,'601',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',227977,'DAILY','2021-09-28','2021-09-28 00:00:00',NULL,'601',1414399.44,1414399.44,'601','2021-09-29 12:40:19','607','2021-09-29 12:47:05',10,0),('5','172',227981,'DAILY','2021-09-29','2021-09-29 00:00:00',NULL,'601',1458806.82,1458806.82,'601','2021-10-05 13:02:46','607','2021-10-05 13:08:18',10,0),('5','172',229290,'DAILY','2021-09-30','2021-09-30 00:00:00',NULL,'601',2396869.68,2396869.68,'601','2021-10-05 13:31:07','607','2021-10-05 13:33:53',10,0),('5','172',230022,'DAILY','2021-10-01','2021-10-01 00:00:00',NULL,'601',2754035.70,2754035.70,'601','2021-10-08 15:31:58','607','2021-10-08 15:33:53',10,0),('5','172',230031,'DAILY','2021-10-02','2021-10-02 00:00:00',NULL,'601',2580756.48,2633684.88,'601','2021-10-08 16:08:19','607','2021-10-08 16:23:33',10,0),('5','172',230037,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'601',1529753.22,1562434.62,'601','2021-10-09 07:04:23','607','2021-10-09 07:11:42',10,0),('5','172',230103,'DAILY','2021-10-04','2021-10-04 00:00:00',NULL,'601',2593189.02,2593189.02,'601','2021-10-09 07:21:34','607','2021-10-09 07:24:08',10,0),('5','172',230104,'DAILY','2021-10-09','2021-10-09 00:00:00',NULL,'601',2242245.96,2242245.96,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',230116,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'601',2242245.96,2242245.96,'601','2021-10-09 08:07:06','607','2021-10-09 08:46:52',10,0),('5','172',230131,'DAILY','2021-10-06','2021-10-06 00:00:00',NULL,'601',1924954.80,1956572.00,'601','2021-10-09 08:55:02','607','2021-10-09 09:01:05',10,0),('5','172',230136,'DAILY','2021-10-07','2021-10-07 00:00:00',NULL,'601',937194.30,937194.30,'601','2021-10-09 09:30:25','607','2021-10-09 09:32:42',10,0),('5','172',230141,'DAILY','2021-10-08','2021-10-08 00:00:00',NULL,'601',1089600.66,1089600.66,'601','2021-10-09 09:36:40','607','2021-10-09 09:40:06',10,0),('5','172',230144,'DAILY','2021-10-09','2021-10-09 00:00:00',NULL,'601',2580788.50,2580788.50,'601','2021-10-11 08:06:57','607','2021-10-11 11:01:34',10,0),('5','172',230619,'DAILY','2021-10-10','2021-10-10 00:00:00',NULL,'601',3393707.88,3393707.88,'601','2021-10-11 11:16:51','607','2021-10-11 11:18:13',10,0),('5','172',230623,'DAILY','2021-10-11','2021-10-11 00:00:00',NULL,'601',2787339.38,2787339.38,'601','2021-10-12 09:19:37','607','2021-10-12 14:02:11',10,0),('5','172',230974,'DAILY','2021-10-12','2021-10-12 00:00:00',NULL,'601',3541391.86,3541391.86,'601','2021-10-13 08:20:46','607','2021-10-13 08:26:16',10,0),('5','172',231115,'DAILY','2021-10-13','2021-10-13 00:00:00',NULL,'601',2526151.74,2526151.74,'601','2021-10-14 07:48:10','607','2021-10-14 09:10:47',10,0),('5','172',231542,'DAILY','2021-10-14','2021-10-14 00:00:00',NULL,'601',1607596.72,1607596.72,'601','2021-10-15 08:56:24','607','2021-10-15 10:08:52',10,0),('5','172',231747,'DAILY','2021-10-15','2021-10-15 00:00:00',NULL,'601',2140822.40,2140822.40,'601','2021-10-16 08:15:19','607','2021-10-16 09:35:29',10,0),('5','172',232006,'DAILY','2021-10-16','2021-10-16 00:00:00',NULL,'601',550867.47,550867.47,'601','2021-10-17 14:26:02','607','2021-10-17 17:46:38',10,0),('5','172',232284,'DAILY','2021-10-17','2021-10-17 00:00:00',NULL,'601',802956.24,802956.24,'601','2021-10-18 07:43:28','607','2021-10-18 09:44:32',10,0),('5','172',232506,'DAILY','2021-10-18','2021-10-18 00:00:00',NULL,'601',1125606.78,1125606.78,'601','2021-10-19 07:12:52','607','2021-10-19 07:36:54',10,0),('5','172',232623,'DAILY','2021-10-19','2021-10-19 00:00:00',NULL,'601',971287.20,971287.20,'601','2021-10-20 08:02:57','607','2021-10-20 09:05:44',10,0),('5','172',232923,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'601',1024516.02,1024516.02,'601','2021-10-21 09:11:54','607','2021-10-21 09:12:58',10,0),('5','172',233182,'DAILY','2021-10-21','2021-10-21 00:00:00',NULL,'601',1064004.66,1064004.66,'601','2021-10-22 09:07:37','607','2021-10-22 09:18:29',10,0),('5','172',233446,'DAILY','2021-10-22','2021-10-22 00:00:00',NULL,'601',1133316.36,1133316.36,'601','2021-10-23 10:07:59','607','2021-10-23 10:31:53',10,0),('5','172',233694,'DAILY','2021-10-23','2021-10-23 00:00:00',NULL,'601',965270.52,965270.52,'601','2021-10-24 09:08:48','607','2021-10-24 09:11:57',10,0),('5','172',233893,'DAILY','2021-10-24','2021-10-24 00:00:00',NULL,'601',1347702.30,1347702.30,'601','2021-10-25 07:26:43','607','2021-10-25 11:15:07',10,0),('5','172',234200,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'601',1438765.74,1438765.74,'601','2021-10-26 07:55:30','607','2021-10-26 08:28:37',10,0),('5','172',234420,'DAILY','2021-10-26','2021-10-26 00:00:00',NULL,'601',1817207.85,1817207.85,'601','2021-10-27 09:34:48','607','2021-10-27 09:47:12',10,0),('5','172',234668,'DAILY','2021-10-27','2021-10-27 00:00:00',NULL,'601',1873363.05,1873363.05,'601','2021-10-28 09:24:17','607','2021-10-28 09:49:07',10,0),('5','172',234976,'DAILY','2021-10-28','2021-10-28 00:00:00',NULL,'601',2332213.05,2332213.05,'601','2021-10-29 08:49:37','607','2021-10-29 08:58:30',10,0),('5','172',235145,'DAILY','2021-10-29','2021-10-29 00:00:00',NULL,'601',3793074.20,3793074.20,'601','2021-10-30 08:49:18','607','2021-10-30 16:49:36',10,0),('5','172',235616,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'601',1606146.40,1606146.40,'601','2021-10-31 11:30:05','607','2021-10-31 11:43:40',10,0),('5','172',235748,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'601',1021591.20,1021591.20,'601','2021-11-01 09:20:59','607','2021-11-01 09:43:49',10,0),('5','172',235854,'DAILY','2021-11-01','2021-11-01 00:00:00',NULL,'601',1440325.00,1440325.00,'601','2021-11-02 08:59:51','607','2021-11-02 09:10:52',10,0),('5','172',236150,'DAILY','2021-11-02','2021-11-02 00:00:00',NULL,'601',2044732.80,2044732.80,'601','2021-11-03 09:48:48','607','2021-11-03 10:34:11',10,0),('5','172',236420,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'601',2407958.20,2407958.20,'601','2021-11-04 08:45:00','607','2021-11-04 10:37:57',10,0),('5','172',236667,'DAILY','2021-11-04','2021-11-04 00:00:00',NULL,'601',2556972.60,2556972.60,'601','2021-11-05 08:07:07','607','2021-11-05 10:17:01',10,0),('5','172',236864,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'601',1706106.00,1706106.00,'601','2021-11-06 09:21:07','600','2021-11-07 07:49:28',10,0),('5','172',237228,'DAILY','2021-11-07','2021-11-07 00:00:00',NULL,'601',1224225.75,1224225.75,'601','2021-11-07 08:34:59','600','2021-11-07 10:55:15',10,0),('5','172',237449,'DAILY','2021-11-07','2021-11-07 00:00:00',NULL,'601',1417683.30,1417683.30,'601','2021-11-08 08:30:18','600','2021-11-08 08:31:20',10,0),('5','172',237453,'DAILY','2021-11-08','2021-11-08 00:00:00',NULL,'601',869366.85,869366.85,'601','2021-11-09 07:49:10','600','2021-11-09 08:35:40',10,0),('5','172',237721,'DAILY','2021-11-09','2021-11-09 00:00:00',NULL,'601',697139.85,697139.85,'601','2021-11-10 08:15:43','600','2021-11-10 15:37:54',10,0),('5','172',238048,'DAILY','2021-11-10','2021-11-10 00:00:00',NULL,'601',0.00,0.00,'601','2021-11-11 07:13:43','600','2021-11-12 08:16:23',10,0),('5','172',238426,'DAILY','2021-11-11','2021-11-11 00:00:00',NULL,'601',0.00,0.00,'601','2021-11-12 08:46:10','600','2021-11-12 09:07:23',10,0),('5','172',238443,'DAILY','2021-11-12','2021-11-12 00:00:00',NULL,'601',1288018.60,1288018.60,'601','2021-11-13 07:00:48','600','2021-11-13 10:03:49',10,0),('5','172',238708,'DAILY','2021-11-13','2021-11-13 00:00:00',NULL,'601',1560726.80,1560726.80,'601','2021-11-14 19:56:03','600','2021-11-14 19:58:00',10,0),('5','172',239017,'DAILY','2021-11-14','2021-11-14 00:00:00',NULL,'601',2544246.20,2544246.20,'601','2021-11-15 08:09:19','600','2021-11-15 14:08:54',10,0),('5','172',239226,'DAILY','2021-11-15','2021-11-15 00:00:00',NULL,'601',2394249.80,2394249.80,'601','2021-11-16 07:20:20','600','2021-11-16 08:08:34',10,0),('5','172',239419,'DAILY','2021-11-16','2021-11-16 00:00:00',NULL,'601',3105448.10,3105448.10,'601','2021-11-17 07:46:25','600','2021-11-17 08:00:56',10,0),('5','172',239636,'DAILY','2021-11-17','2021-11-17 00:00:00',NULL,'601',2935744.70,2935744.70,'601','2021-11-18 07:22:14','600','2021-11-18 12:16:03',10,0),('5','172',239880,'DAILY','2021-11-18','2021-11-18 00:00:00',NULL,'601',3245689.85,3245689.85,'601','2021-11-19 07:36:07','600','2021-11-19 08:13:15',10,0),('5','172',240088,'DAILY','2021-11-19','2021-11-19 00:00:00',NULL,'601',2816981.50,2816981.50,'601','2021-11-20 07:24:49','600','2021-11-20 08:30:08',10,0),('5','172',240523,'DAILY','2021-11-20','2021-11-20 00:00:00',NULL,'601',2816459.70,2816459.70,'601','2021-11-21 10:35:22','600','2021-11-21 10:37:55',10,0),('5','172',240525,'DAILY52','2021-11-21','2021-11-21 00:00:00',NULL,'601',1066471.55,1066471.55,'601','2021-11-22 07:53:53','600','2021-11-22 07:59:32',10,0),('5','172',240880,'DAILY','2021-11-22','2021-11-22 00:00:00',NULL,'601',2444130.05,2444130.05,'601','2021-11-23 10:50:33','600','2021-11-23 10:52:31',10,0),('5','172',241079,'DAILY','2021-11-23','2021-11-23 00:00:00',NULL,'601',2317315.90,2317315.90,'601','2021-11-24 08:27:26','600','2021-11-24 08:45:48',10,0),('5','172',241314,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'601',2492768.75,2492768.75,'601','2021-11-25 10:35:00','600','2021-11-25 10:49:14',10,0),('5','172',241599,'DAILY','2021-11-25','2021-11-25 00:00:00',NULL,'601',2886230.95,2886230.95,'601','2021-11-26 09:12:04','600','2021-11-26 14:12:23',10,0),('5','172',241882,'DAILY','2021-11-26','2021-11-26 00:00:00',NULL,'601',4496536.40,4496536.40,'601','2021-11-27 10:23:48','600','2021-11-27 13:21:00',10,0),('5','172',242115,'DAILY','2021-11-27','2021-11-27 00:00:00',NULL,'601',2642947.15,2642947.15,'601','2021-11-28 10:15:07','600','2021-11-28 13:43:58',10,0),('5','172',242318,'DAILY','2021-11-28','2021-11-28 00:00:00',NULL,'601',1162342.65,1162342.65,'601','2021-11-29 09:21:21','600','2021-11-29 14:01:51',10,0),('5','172',242610,'DAILY','2021-11-29','2021-11-29 00:00:00',NULL,'601',1619889.20,1619889.20,'601','2021-11-30 09:11:03','600','2021-11-30 10:44:06',10,0),('5','172',242817,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'601',1858680.75,1858680.75,'601','2021-12-01 08:25:15','600','2021-12-01 08:30:04',10,0),('5','172',243008,'DAILY','2021-12-01','2021-12-01 00:00:00',NULL,'601',546152.20,546152.20,'601','2021-12-02 11:51:38','600','2021-12-03 09:18:40',10,0),('5','172',243458,'DAILY','2021-12-02','2021-12-02 00:00:00',NULL,'601',0.00,0.00,'601','2021-12-06 14:03:43','600','2021-12-06 14:07:33',10,0),('5','172',244189,'DAILY','2021-12-03','2021-12-03 00:00:00',NULL,'601',0.00,0.00,'601','2021-12-06 14:13:00','600','2021-12-06 14:14:07',10,0),('5','172',244192,'DAILY','2021-12-04','2021-12-04 00:00:00',NULL,'601',2521766.05,2521766.05,'601','2021-12-06 14:20:06','600','2021-12-06 14:34:57',10,0),('5','172',244196,'DAILY','2021-12-05','2021-12-05 00:00:00',NULL,'601',2698062.40,2698062.40,'601','2021-12-06 14:38:39','600','2021-12-06 14:42:12',10,0),('5','172',244198,'DAILY','2021-12-06','2021-12-06 00:00:00',NULL,'601',2965968.45,2965968.45,'601','2021-12-07 10:35:11','600','2021-12-07 11:00:52',10,0),('5','172',244391,'DAILY','2021-12-07','2021-12-07 00:00:00',NULL,'601',2207652.35,2207652.35,'601','2021-12-08 08:36:55','600','2021-12-08 08:55:28',10,0),('5','172',244642,'DAILY','2021-12-08','2021-12-08 00:00:00',NULL,'601',2790574.05,2790574.05,'601','2021-12-09 08:20:02','600','2021-12-09 08:46:33',10,0),('5','172',244807,'DAILY','2021-12-09','2021-12-09 00:00:00',NULL,'601',2897273.65,2897273.65,'601','2021-12-10 10:47:34','600','2021-12-10 10:53:13',10,0),('5','172',245079,'DAILY','2021-12-10','2021-12-10 00:00:00',NULL,'601',2281699.20,2281699.20,'601','2021-12-11 13:15:01','600','2021-12-11 13:53:05',10,0),('5','172',245338,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'601',2436725.60,2436725.60,'601','2021-12-12 08:09:06','600','2021-12-12 08:13:23',10,0),('5','172',245570,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'601',2161505.75,2161505.75,'601','2021-12-13 08:59:35','600','2021-12-13 09:07:34',10,0),('5','172',245739,'DAILY','2021-12-13','2021-12-13 00:00:00',NULL,'601',2388508.10,2388508.10,'601','2021-12-14 09:34:25','600','2021-12-14 09:41:02',10,0),('5','172',246020,'DAILY','2021-12-14','2021-12-14 00:00:00',NULL,'601',2441904.35,2441904.35,'601','2021-12-15 09:32:10','600','2021-12-15 09:33:15',10,0),('5','172',246286,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'601',3611982.35,3611982.35,'601','2021-12-16 08:07:00','600','2021-12-16 08:10:18',10,0),('5','172',246508,'DAILY','2021-12-16','2021-12-16 00:00:00',NULL,'601',3518410.35,3518410.35,'601','2021-12-17 08:41:13','600','2021-12-17 08:54:24',10,0),('5','172',246779,'DAILY','2021-12-17','2021-12-17 00:00:00',NULL,'601',4016660.45,4016660.45,'601','2021-12-18 09:57:57','600','2021-12-18 10:23:16',10,0),('5','172',247075,'DAILY','2021-12-18','2021-12-18 00:00:00',NULL,'601',2807085.75,2807085.75,'601','2021-12-19 09:14:48','600','2021-12-20 09:28:41',10,0),('5','172',247492,'DAILY','2021-12-19','2021-12-19 00:00:00',NULL,'601',3735641.35,3735641.35,'601','2021-12-20 10:38:48','600','2021-12-20 10:39:55',10,0),('5','172',247494,'DAILY','2021-12-20','2021-12-20 00:00:00',NULL,'601',3435007.20,3435007.20,'601','2021-12-21 07:21:50','600','2021-12-21 07:58:02',10,0),('5','172',247795,'DAILY','2021-12-21','2021-12-21 00:00:00',NULL,'601',3374454.05,3374454.05,'601','2021-12-22 09:10:12','600','2021-12-22 09:20:23',10,0),('5','172',247992,'DAILY','2021-12-22','2021-12-22 00:00:00',NULL,'601',2961231.95,2961231.95,'601','2021-12-23 09:56:58','600','2021-12-23 12:04:56',10,0),('5','172',248281,'DAILY','2021-12-23','2021-12-23 00:00:00',NULL,'601',867234.60,867234.60,'601','2021-12-24 07:28:48','600','2021-12-24 08:12:20',10,0),('5','172',248542,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'601',2197277.90,2197277.90,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','172',248778,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'601',2127010.70,2127010.70,'601','2021-12-25 14:26:05','600','2021-12-25 14:27:03',10,0),('5','172',248781,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'601',2197727.20,2197727.20,'601','2021-12-26 08:51:45','600','2021-12-26 11:03:09',10,0),('5','172',249008,'DAILY','2021-12-26','2021-12-26 00:00:00',NULL,'601',2083086.25,2083086.25,'601','2021-12-27 07:26:55','600','2021-12-27 12:17:29',10,0),('5','172',249252,'DAILY','2021-12-27','2021-12-27 00:00:00',NULL,'601',2831846.50,2831846.50,'601','2021-12-28 08:04:33','600','2021-12-28 08:18:32',10,0),('5','172',249490,'DAILY','2021-12-28','2021-12-28 00:00:00',NULL,'601',2741148.45,2741148.45,'601','2021-12-29 07:36:24','600','2021-12-29 08:42:17',10,0),('5','172',249744,'DAILY','2021-12-29','2021-12-29 00:00:00',NULL,'601',3209014.15,3209014.15,'601','2021-12-30 08:13:11','600','2021-12-30 08:57:44',10,0),('5','172',249976,'DAILY','2021-12-30','2021-12-30 00:00:00',NULL,'601',3341662.85,3341662.85,'601','2021-12-31 07:39:53','600','2021-12-31 08:43:27',10,0),('5','172',250213,'DAILY','2021-12-31','2021-12-31 00:00:00',NULL,'601',1771333.35,1771333.35,'601','2022-01-01 08:11:29','600','2022-01-01 08:42:53',10,0),('5','172',250411,'DAILY','2022-01-01','2022-01-01 00:00:00',NULL,'601',2257089.30,2257089.30,'601','2022-01-02 06:59:28','600','2022-01-02 09:30:41',10,0),('5','172',250653,'DAILY','2022-01-02','2022-01-02 00:00:00',NULL,'601',1240293.95,1240293.95,'601','2022-01-03 07:51:57','600','2022-01-03 10:16:33',10,0),('5','172',250905,'DAILY','2022-01-03','2022-01-03 00:00:00',NULL,'601',3042089.50,3042089.50,'601','2022-01-04 08:18:52','600','2022-01-04 08:29:35',10,0),('5','172',251141,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'601',3218430.60,3218430.60,'601','2022-01-05 10:23:40','600','2022-01-05 11:37:29',10,0),('5','172',251427,'DAILY','2022-01-05','2022-01-05 00:00:00',NULL,'601',3290644.70,3290644.70,'601','2022-01-06 08:58:54','600','2022-01-06 10:40:59',10,0),('5','172',251676,'DAILY','2022-01-06','2022-01-06 00:00:00',NULL,'601',3840083.50,3840083.50,'601','2022-01-07 08:26:18','600','2022-01-07 11:35:46',10,0),('5','172',252028,'DAILY','2022-01-07','2022-01-07 00:00:00',NULL,'601',2025598.95,2025598.95,'601','2022-01-08 08:38:09','600','2022-01-08 13:24:17',10,0),('5','172',252137,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'601',838297.30,838297.30,'601','2022-01-09 10:43:11','600','2022-01-09 11:55:11',10,0),('5','172',252377,'DAILY','2022-01-09','2022-01-09 00:00:00',NULL,'601',1001995.05,1001995.05,'601','2022-01-10 12:19:17','600','2022-01-10 12:20:50',10,0),('5','172',252592,'DAILY','2022-01-10','2022-01-10 00:00:00',NULL,'601',1155522.20,1155522.20,'601','2022-01-11 20:52:37','600','2022-01-11 21:51:05',10,0),('5','172',253007,'DAILY','2022-01-11','2022-01-11 00:00:00',NULL,'601',1757584.20,1757584.20,'601','2022-01-12 08:24:32','600','2022-01-12 09:35:12',10,0),('5','172',253135,'DAILY','2022-01-12','2022-01-12 00:00:00',NULL,'601',1861976.90,1861976.90,'601','2022-01-13 09:24:11','600','2022-01-13 09:40:39',10,0),('5','172',253277,'DAILY','2022-01-13','2022-01-13 00:00:00',NULL,'601',1406591.30,1406591.30,'601','2022-01-14 09:08:35','600','2022-01-14 09:52:42',10,0),('5','172',253559,'DAILY','2022-01-14','2022-01-14 00:00:00',NULL,'601',2299178.70,2299178.70,'601','2022-01-15 08:27:49','600','2022-01-15 10:54:58',10,0),('5','172',253986,'DAILY','2022-01-15','2022-01-15 00:00:00',NULL,'601',1348636.30,1348636.30,'601','2022-01-16 08:14:01','600','2022-01-17 09:14:43',10,0),('5','172',254297,'DAILY','2022-01-16','2022-01-16 00:00:00',NULL,'601',1328110.85,1328110.85,'601','2022-01-17 11:34:09','600','2022-01-17 17:28:54',10,0),('5','172',254372,'DAILY','2022-01-17','2022-01-17 00:00:00',NULL,'601',1694453.45,1694453.45,'601','2022-01-18 09:09:33','600','2022-01-18 10:16:08',10,0),('5','172',254529,'DAILY','2022-01-18','2022-01-18 00:00:00',NULL,'601',1635570.50,1635570.50,'601','2022-01-19 09:26:12','600','2022-01-19 09:46:29',10,0),('5','172',254781,'DAILY','2022-01-19','2022-01-19 00:00:00',NULL,'601',1890287.00,1890287.00,'601','2022-01-20 09:05:36','600','2022-01-20 09:44:19',10,0),('5','172',255033,'DAILY','2022-01-20','2022-01-20 00:00:00',NULL,'601',2578677.50,2578677.50,'601','2022-01-21 09:15:06','600','2022-01-21 09:58:24',10,0),('5','172',255314,'DAILY','2022-01-21','2022-01-21 00:00:00',NULL,'601',2509731.00,2509731.00,'601','2022-01-22 08:06:03','600','2022-01-22 09:24:38',10,0),('5','172',255517,'DAILY','2022-01-22','2022-01-22 00:00:00',NULL,'601',1499645.00,1499645.00,'601','2022-01-23 07:39:05','600','2022-01-23 09:03:43',10,0),('5','172',255816,'DAILY','2022-01-23','2022-01-23 00:00:00',NULL,'601',1663522.00,1663522.00,'601','2022-01-24 08:23:55','600','2022-01-24 09:37:48',10,0),('5','172',256120,'DAILY','2022-01-24','2022-01-24 00:00:00',NULL,'601',1884691.45,1884691.45,'601','2022-01-25 08:36:33','600','2022-01-25 09:10:14',10,0),('5','172',256265,'DAILY','2022-01-25','2022-01-25 00:00:00',NULL,'601',994635.10,994635.10,'601','2022-01-26 09:47:17','600','2022-01-26 09:48:33',10,0),('5','172',256550,'DAILY','2022-01-26','2022-01-26 00:00:00',NULL,'601',807236.10,807236.10,'601','2022-01-27 08:27:27','600','2022-01-27 10:04:21',10,0),('5','172',256811,'DAILY','2022-01-27','2022-01-27 00:00:00',NULL,'601',1039424.10,1039424.10,'601','2022-01-28 10:50:52','600','2022-01-28 11:49:41',10,0),('5','172',257068,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'601',1034847.00,1034847.00,'601','2022-01-29 08:44:14','600','2022-01-29 13:25:41',10,0),('5','172',257512,'DAILY','2022-01-29','2022-01-29 00:00:00',NULL,'601',834824.10,834824.10,'601','2022-01-30 07:59:56','600','2022-01-30 10:21:01',10,0),('5','172',257616,'DAILY','2022-01-30','2022-01-30 00:00:00',NULL,'601',940193.10,940193.10,'601','2022-01-31 08:15:23','600','2022-01-31 16:21:38',10,0),('5','172',257617,'DAILY','2022-01-31','2022-01-31 00:00:00',NULL,'601',779304.90,779304.90,'601','2022-02-01 09:01:04','600','2022-02-01 09:10:42',10,0),('5','172',257618,'DAILY','2022-02-01','2022-02-01 00:00:00',NULL,'601',554781.15,554781.15,'601','2022-02-02 11:49:42','600','2022-02-02 14:48:41',10,0),('5','172',257619,'DAILY','2022-02-02','2022-02-02 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-03 07:41:53','600','2022-02-03 14:03:15',10,0),('5','172',257620,'DAILY','2022-02-03','2022-02-03 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-04 07:57:01','600','2022-02-04 09:23:55',10,0),('5','172',257621,'DAILY','2022-02-04','2022-02-04 00:00:00',NULL,'601',2208903.50,2208903.50,'601','2022-02-05 09:25:22','600','2022-02-05 09:56:27',10,0),('5','172',257622,'DAILY','2022-02-05','2022-02-05 00:00:00',NULL,'601',2687261.55,2687261.55,'601','2022-02-06 09:38:02','600','2022-02-06 11:33:49',10,0),('5','172',257623,'DAILY','2022-02-06','2022-02-06 00:00:00',NULL,'601',2636488.05,2636488.05,'601','2022-02-07 09:10:16','600','2022-02-07 10:38:56',10,0),('5','172',257624,'DAILY','2022-02-07','2022-02-07 00:00:00',NULL,'601',4238134.95,4238134.95,'601','2022-02-08 18:46:19','600','2022-02-08 21:43:49',10,0),('5','172',257625,'DAILY','2022-02-08','2022-02-08 00:00:00',NULL,'601',7783710.75,7783710.75,'601','2022-02-09 15:56:24','600','2022-02-09 16:09:47',10,0),('5','172',257626,'DAILY SHIRT','2022-02-09','2022-02-09 00:00:00',NULL,'601',3954193.15,3442118.15,'601','2022-02-10 07:16:55','600','2022-02-10 10:07:32',10,0),('5','172',257627,'DAILY SHITF','2022-02-10','2022-02-10 00:00:00',NULL,'601',1505473.75,1213148.75,'601','2022-02-11 10:06:34','600','2022-02-11 16:32:42',10,0),('5','172',257628,'DAILY SHIRT','2022-02-11','2022-02-11 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-12 07:49:46','600','2022-02-12 08:47:36',10,0),('5','172',257629,'DAILY SHIRT','2022-02-12','2022-02-12 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-12 20:05:16','600','2022-02-12 21:54:59',10,0),('5','172',257630,'DAILY SHIRT','2022-02-13','2022-02-13 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-13 19:40:18','600','2022-02-13 21:50:02',10,0),('5','172',257631,'DAILY SHIRT','2022-02-14','2022-02-14 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-14 21:19:59','600','2022-02-15 16:49:46',10,0),('5','172',257632,'DAILY SHIRT','2022-02-15','2022-02-15 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-15 20:33:39','600','2022-02-16 09:25:20',10,0),('5','172',257633,'DAILY SHITF','2022-02-16','2022-02-16 00:00:00',NULL,'601',0.00,0.00,'601','2022-02-17 09:47:38','600','2022-02-18 09:26:50',10,0),('5','172',257634,'DAILY SHITF','2022-02-17','2022-02-17 00:00:00',NULL,'601',1188942.15,1188942.15,'601','2022-02-18 14:47:14','600','2022-02-19 11:48:35',10,0),('5','172',257635,'DAILY SHITF','2022-02-18','2022-02-18 00:00:00',NULL,'601',4065573.60,4065573.60,'601','2022-02-19 12:00:34','600','2022-02-20 08:51:27',10,0),('5','172',257636,'DAILY SHITF','2022-02-19','2022-02-19 00:00:00',NULL,'601',2586326.45,2586326.45,'601','2022-02-20 10:39:29','600','2022-02-21 09:59:44',10,0),('5','172',257637,'DAILY SHIRT','2022-02-20','2022-02-20 00:00:00',NULL,'601',2614088.65,2614088.65,'601','2022-02-21 15:20:03','600','2022-02-22 09:28:10',10,0),('5','172',257638,'DAILY SHITF','2022-02-21','2022-02-22 10:05:51','2022-02-23 10:05:51','601',4099940.35,4099940.35,'601','2022-02-22 12:50:53','600','2022-02-23 09:13:25',10,0),('5','172',257639,'DAILY SHIRT','2022-02-22','2022-02-23 16:48:19','2022-02-24 16:48:19','601',5798771.55,5798771.55,'601','2022-02-23 16:51:57','600','2022-02-24 08:14:59',10,0),('5','172',257640,'DAILY SHITF','2022-02-23','2022-02-24 08:15:59','2022-02-25 08:15:59','601',3558095.25,3558095.25,'601','2022-02-24 08:18:03','600','2022-02-25 09:40:37',10,0),('5','172',257641,'DAILY SHIRT','2022-02-24','2022-02-25 11:03:57','2022-02-26 11:03:57','601',1763152.40,1763152.40,'601','2022-02-25 11:04:44','600','2022-02-26 09:49:28',10,0),('5','172',257642,'DAILY SHITF','2022-02-25','2022-02-26 18:46:48','2022-02-27 18:46:48','601',1662568.85,1662568.85,'601','2022-02-26 18:47:43','600','2022-02-27 09:05:47',10,0),('5','172',257643,'DAILY SHITF','2022-02-26','2022-02-27 15:25:21','2022-02-28 15:25:21','601',1944797.90,1944797.90,'601','2022-02-27 15:26:01','600','2022-02-28 08:50:33',10,0),('5','172',257644,'DAILY SHIRT','2022-02-27','2022-02-28 10:40:42','2022-03-01 10:40:42','601',2855976.05,2855976.05,'601','2022-02-28 12:40:09','600','2022-03-01 09:26:46',10,0),('5','172',257645,'DAILY SHITF','2022-02-28','2022-03-01 09:38:01','2022-03-02 09:38:01','601',5029230.65,5029230.65,'601','2022-03-01 15:09:02','600','2022-03-02 09:52:37',10,0),('5','172',257646,'DAILY SHITF','2022-03-01','2022-03-02 10:37:13','2022-03-03 10:37:13','601',5034468.75,5034468.75,'601','2022-03-02 14:12:10','600','2022-03-03 10:24:53',10,0),('5','172',257647,'DAILY SHIRT','2022-03-02','2022-03-03 10:58:43','2022-03-04 10:58:43','601',4095662.20,4095662.20,'601','2022-03-03 11:00:54','600','2022-03-03 11:08:15',10,0),('5','172',257648,'DAILY SHITF','2022-03-03','2022-03-03 11:39:36','2022-03-04 11:39:36','601',8071353.50,8071353.50,'601','2022-03-04 10:43:21','600','2022-03-04 10:50:49',10,0),('5','172',257649,'DAILY SHIRT','2022-03-04','2022-03-06 11:19:37','2022-03-07 11:19:37','601',1222452.00,1222452.00,'601','2022-03-06 11:20:55','600','2022-03-06 11:31:37',10,0),('5','172',257650,'DAILY SHIRT','2022-03-05','2022-03-06 11:35:26','2022-03-07 11:35:26','601',0.00,0.00,'601','2022-03-06 11:36:05','600','2022-03-06 11:42:00',10,0),('5','172',257651,'DAILY SHIRT ','2022-03-06','2022-03-06 14:06:35','2022-03-07 14:06:35','601',3902588.25,3902588.25,'601','2022-03-07 06:34:15','600','2022-03-07 09:58:37',10,0),('5','172',257652,'DAILY SHITF','2022-03-07','2022-03-07 12:04:27','2022-03-08 12:04:27','601',3577506.90,3577506.90,'601','2022-03-08 06:30:17','600','2022-03-09 12:19:59',10,0),('5','172',257653,'DAILY SHITF','2022-03-08','2022-03-09 12:27:10','2022-03-10 12:27:10','601',2608375.60,2608375.60,'601','2022-03-09 12:40:52','600','2022-03-10 09:14:19',10,0),('5','172',257654,'DAILY SHITF','2022-03-09','2022-03-10 09:48:04','2022-03-11 09:48:04','601',2656858.05,2656858.05,'601','2022-03-10 12:20:34','600','2022-03-11 10:02:21',10,0),('5','172',257655,'DAILY SHIRT','2022-03-10','2022-03-11 11:35:56','2022-03-12 11:35:56','601',1436509.70,1436509.70,'601','2022-03-11 11:44:42','600','2022-03-11 12:12:46',10,0),('5','172',257656,'DAILY SHITF','2022-03-11','2022-03-12 14:23:12','2022-03-13 14:23:12','601',841907.55,841907.55,'601','2022-03-12 14:24:32','600','2022-03-13 08:58:36',10,0),('5','172',257657,'DAILY SHITF','2022-03-12','2022-03-14 09:10:54','2022-03-15 09:10:54','601',0.00,0.00,'601','2022-03-14 09:11:41','600','2022-03-14 09:16:03',10,0),('5','172',257658,'DAILY SHIRT ','2022-03-13','2022-03-14 10:22:03','2022-03-15 10:22:03','601',0.00,0.00,'601','2022-03-14 10:22:24','600','2022-03-15 09:15:04',10,0),('5','172',257659,'DAILY SHITF','2022-03-14','2022-03-15 17:20:31','2022-03-16 17:20:31','601',0.00,0.00,'601','2022-03-15 17:20:54','600','2022-03-16 11:42:20',10,0),('5','172',257660,'DAILY SHIRT','2022-03-15','2022-03-16 14:23:21','2022-03-17 14:23:21','601',0.00,0.00,'601','2022-03-16 14:23:59','600','2022-03-17 08:54:31',10,0),('5','172',257661,'DAILY SHITF','2022-03-16','2022-03-17 09:58:58','2022-03-18 09:58:58','601',901022.10,901022.10,'601','2022-03-17 10:00:31','600','2022-03-18 09:21:35',10,0),('5','172',257662,'DAILY SHITF','2022-03-17','2022-03-18 10:13:02','2022-03-19 10:13:02','601',3038029.75,3038029.75,'601','2022-03-18 10:14:38','600','2022-03-19 10:15:41',10,0),('5','172',257663,'DAILY SHITF','2022-03-19','2022-03-20 11:26:05','2022-03-21 11:26:05','601',0.00,0.00,'601','2022-03-20 11:26:30','600','2022-03-20 13:18:03',10,0),('5','172',257664,'DAILY SHITF','2022-03-18','2022-03-21 07:01:02','2022-03-22 07:01:02','601',2694359.25,2694359.25,'601','2022-03-21 07:02:44','600','2022-03-22 09:11:25',10,0),('5','172',257665,'DAILY SHITF','2022-03-20','2022-03-22 10:11:04','2022-03-23 10:11:04','601',0.00,0.00,'601','2022-03-22 10:11:21','600','2022-03-22 10:12:33',10,0),('5','172',257666,'DAILY SHITF','2022-03-21','2022-03-22 13:48:47','2022-03-23 13:48:47','601',0.00,0.00,'601','2022-03-22 13:49:04','600','2022-03-22 13:51:40',10,0),('5','172',257667,'DAILY SHITF','2022-03-22','2022-03-22 13:57:00','2022-03-23 13:57:00','601',3450579.40,3450579.40,'601','2022-03-23 10:43:34','600','2022-03-24 09:07:50',10,0),('5','172',257668,'DAILY SHITF','2022-03-23','2022-03-24 11:45:15','2022-03-25 11:45:15','601',5892969.85,5892969.85,'601','2022-03-24 11:55:59','600','2022-03-25 10:23:00',10,0),('5','172',257669,'DAILY SHITF','2022-03-24','2022-03-25 11:12:54','2022-03-26 11:12:54','601',4875763.80,4875763.80,'601','2022-03-25 11:14:23','600','2022-03-26 12:43:23',10,0),('5','172',257670,'DAILY SHIRT ','2022-03-25','2022-03-26 13:09:59','2022-03-27 13:09:59','601',4422189.05,4422189.05,'601','2022-03-26 13:14:33','600','2022-03-27 08:58:27',10,0),('5','172',257671,'DAILY SHITF','2022-03-26','2022-03-27 11:38:18','2022-03-28 11:38:18','601',9727182.30,9727182.30,'601','2022-03-27 11:44:20','600','2022-03-28 10:13:30',10,0),('5','172',257672,'DAILY SHITF','2022-03-27','2022-03-28 10:43:28','2022-03-29 10:43:28','601',9134769.00,9134769.00,'601','2022-03-28 10:46:48','600','2022-03-28 11:10:59',10,0),('5','172',257673,'DAILY SHITF','2022-03-28','2022-03-29 15:06:24','2022-03-30 15:06:24','601',4381526.95,4381526.95,'601','2022-03-30 06:54:47','600','2022-03-30 09:56:31',10,0),('5','172',257674,'DAILY SHITF','2022-03-29','2022-03-30 21:28:33','2022-03-31 21:28:33','601',3849158.00,3849158.00,'601','2022-03-30 21:50:59','600','2022-03-31 09:29:25',10,0),('5','172',257675,'DAILY SHITF','2022-03-31','2022-04-01 09:42:03','2022-04-02 09:42:03','601',0.00,0.00,'601','2022-04-01 09:42:45','600','2022-04-01 16:22:51',10,0),('5','172',257676,'DAILY SHITF','2022-04-01','2022-04-02 17:14:21','2022-04-03 17:14:21','601',0.00,0.00,'601','2022-04-02 17:14:45','600','2022-04-03 11:08:10',10,0),('5','172',257677,'DAILY SHITF','2022-04-02','2022-04-03 14:30:02','2022-04-04 14:30:02','601',1723713.75,1723713.75,'601','2022-04-03 21:34:45','600','2022-04-04 09:09:55',10,0),('5','172',257678,'DAILY SHITF','2022-04-03','2022-04-04 10:14:59','2022-04-05 10:14:59','601',1630393.05,1630393.05,'601','2022-04-04 10:16:57','600','2022-04-05 11:33:46',10,0),('5','172',257679,'DAILY SHIRT ','2022-04-04','2022-04-05 15:45:51','2022-04-06 15:45:51','601',887896.35,887896.35,'601','2022-04-05 15:46:50','600','2022-04-06 09:08:05',10,0),('5','172',257680,'DAILY SHIRT is','2022-04-05','2022-04-06 11:01:00','2022-04-07 11:01:00','601',1514931.00,1514931.00,'601','2022-04-06 13:32:30','600','2022-04-07 13:59:15',10,0),('5','172',257681,'DAILY SHITF','2022-04-06','2022-04-07 14:02:17','2022-04-08 14:02:17','601',3976227.75,3976227.75,'601','2022-04-07 14:08:43','600','2022-04-08 09:12:38',10,0),('5','172',257682,'DAILY SHITF','2022-04-07','2022-04-08 09:19:10','2022-04-09 09:19:10','601',2245980.00,2245980.00,'601','2022-04-08 09:20:27','600','2022-04-09 09:05:12',10,0),('5','172',257683,'DAILY SHITF','2022-04-08','2022-04-09 13:23:18','2022-04-10 13:23:18','601',2782923.00,2782923.00,'601','2022-04-09 13:23:51','600','2022-04-10 12:36:58',10,0),('5','172',257684,'DAILY SHITF','2022-04-09','2022-04-10 14:09:44','2022-04-11 14:09:44','601',2791054.20,2791054.20,'601','2022-04-10 14:10:31','600','2022-04-11 09:08:18',10,0),('5','172',257685,'DAILY SHITF','2022-04-10','2022-04-11 11:35:09','2022-04-12 11:35:09','601',1868948.40,1868948.40,'601','2022-04-11 11:49:25','600','2022-04-12 09:03:20',10,0),('5','172',257686,'DAILY SHIRT ','2022-04-11','2022-04-12 10:37:55','2022-04-13 10:37:55','601',2802663.60,2802663.60,'601','2022-04-12 10:38:45','600','2022-04-13 09:00:06',10,0),('5','172',257687,'DAILY SHIRT ','2022-04-12','2022-04-13 11:03:07','2022-04-14 11:03:07','601',2913365.40,2913365.40,'601','2022-04-13 11:04:14','600','2022-04-14 09:25:06',10,0),('5','172',257688,'DAILY SHITF','2022-04-13','2022-04-14 12:27:40','2022-04-15 12:27:40','601',3132058.05,3132058.05,'601','2022-04-14 12:42:36','600','2022-04-14 16:23:15',10,0),('5','172',257689,'DAILY SHITF','2022-04-14','2022-04-15 12:25:50','2022-04-16 12:25:50','601',6624588.30,6624588.30,'601','2022-04-15 12:51:30','600','2022-04-15 15:14:10',10,0),('5','172',257690,'DAILY SHITF','2022-04-15','2022-04-16 12:30:08','2022-04-17 12:30:08','601',6004985.25,6004985.25,'601','2022-04-16 12:32:08','600','2022-04-17 05:43:48',10,0),('5','172',257691,'DAILY SHITF','2022-04-16','2022-04-17 13:23:57','2022-04-18 13:23:57','601',5021501.10,5021501.10,'601','2022-04-17 13:25:17','600','2022-04-17 13:50:26',10,0),('5','172',257692,'DAILY SHITF','2022-04-17','2022-04-18 11:30:50','2022-04-19 11:30:50','601',4014745.35,4014745.35,'601','2022-04-18 11:33:14','600','2022-04-19 10:56:28',10,0),('5','172',257693,'DAILY SHITF','2022-04-18','2022-04-19 10:57:15','2022-04-20 10:57:15','601',3464074.35,3464074.35,'601','2022-04-19 11:12:24','600','2022-04-20 10:04:25',10,0),('5','172',257694,'DAILY SHITF','2022-04-19','2022-04-20 12:42:45','2022-04-21 12:42:45','601',6254547.75,6254547.75,'601','2022-04-20 12:44:16','600','2022-04-21 09:24:35',10,0),('5','172',257695,'DAILY SHITF','2022-04-20','2022-04-21 13:44:07','2022-04-22 13:44:07','601',4585726.20,4585726.20,'601','2022-04-21 13:45:40','600','2022-04-22 10:19:37',10,0),('5','172',257696,'DAILY SHITF','2022-04-21','2022-04-22 18:35:33','2022-04-23 18:35:33','601',6840213.60,6840213.60,'601','2022-04-22 18:39:09','600','2022-04-23 09:13:46',10,0),('5','172',257697,'DAILY SHIRT ','2022-04-22','2022-04-23 12:18:31','2022-04-24 12:18:31','601',4818828.30,4818828.30,'601','2022-04-23 12:19:51','600','2022-04-24 09:11:33',10,0),('5','172',257698,'DAILY SHITF','2022-04-23','2022-04-24 10:40:26','2022-04-25 10:40:26','601',6208327.95,6208327.95,'601','2022-04-24 10:46:20','600','2022-04-24 13:11:13',10,0),('5','172',257699,'DAILY SHITF','2022-04-24','2022-04-25 06:51:41','2022-04-26 06:51:41','601',4695055.20,4695055.20,'601','2022-04-25 06:52:13','600','2022-04-25 11:40:59',10,0),('5','172',257700,'DAILY SHIRT ','2022-04-25','2022-04-26 10:34:38','2022-04-27 10:34:38','601',7032397.35,7032397.35,'601','2022-04-26 10:35:58','600','2022-04-27 10:18:47',10,0),('5','172',257701,'DAILY','2022-04-26','2022-04-27 10:47:43','2022-04-28 10:47:43','600',5099575.80,5099575.80,'601','2022-04-27 10:51:37','600','2022-04-28 12:52:10',10,0),('5','172',257702,'DAILY SHITF','2022-04-27','2022-04-28 13:01:30','2022-04-29 13:01:30','601',6327967.80,6327967.80,'601','2022-04-28 13:03:01','600','2022-04-28 14:17:47',10,0),('5','172',257703,'DAILY SHITF ','2022-04-28','2022-04-29 10:39:33','2022-04-30 10:39:33','601',3259197.15,3259197.15,'601','2022-04-29 10:41:47','600','2022-04-29 14:24:55',10,0),('5','172',257704,'DAILY SHITF','2022-04-29','2022-05-09 10:56:28','2022-05-10 10:56:28','601',1506747.00,1506747.00,'601','2022-05-09 10:57:30','600','2022-05-09 11:03:26',10,0),('5','172',257705,'DAILY SHITF','2022-04-30','2022-05-09 11:08:32','2022-05-10 11:08:32','601',501979.50,501979.50,'601','2022-05-09 11:10:48','600','2022-05-09 11:18:53',10,0),('5','172',257706,'DAILY SHITF','2022-05-01','2022-05-09 11:30:46','2022-05-10 11:30:46','601',285161.25,285161.25,'601','2022-05-09 11:31:18','600','2022-05-09 11:32:44',10,0),('5','172',257707,'DAILY SHITF','2022-05-02','2022-05-09 11:40:11','2022-05-10 11:40:11','601',1395188.85,1395188.85,'601','2022-05-09 11:43:12','600','2022-05-09 12:03:56',10,0),('5','172',257708,'DAILY SHITF','2022-05-03','2022-05-09 12:17:01','2022-05-10 12:17:01','601',1289961.75,1289961.75,'601','2022-05-09 12:19:05','600','2022-05-09 12:43:07',10,0),('5','172',257709,'DAILY SHITF','2022-05-04','2022-05-09 13:29:59','2022-05-10 13:29:59','601',1937599.95,1937599.95,'601','2022-05-09 13:30:54','600','2022-05-09 13:33:57',10,0),('5','172',257710,'DAILY SHITF','2022-05-05','2022-05-09 13:36:56','2022-05-10 13:36:56','601',1865948.70,1865948.70,'601','2022-05-09 13:37:48','600','2022-05-09 13:38:40',10,0),('5','172',257711,'DAILY SHITF','2022-05-06','2022-05-09 13:40:20','2022-05-10 13:40:20','601',2020261.65,2020261.65,'601','2022-05-09 13:45:40','600','2022-05-09 13:47:01',10,0),('5','172',257712,'DAILY SHITF','2022-05-07','2022-05-09 13:48:11','2022-05-10 13:48:11','601',2079244.20,2079244.20,'601','2022-05-09 13:49:18','600','2022-05-09 13:54:28',10,0),('5','172',257713,'DAILY SHITF','2022-05-08','2022-05-09 13:56:15','2022-05-10 13:56:15','601',2187474.30,2187474.30,'601','2022-05-09 13:57:15','600','2022-05-09 14:28:20',10,0),('5','172',257714,'DAILY SHITF','2022-05-09','2022-05-09 21:47:05','2022-05-10 21:47:05','601',2108612.55,2108612.55,'601','2022-05-10 07:19:24','600','2022-05-10 09:43:43',10,0),('5','172',257715,'DAILY SHITF','2022-05-10','2022-05-10 11:51:02','2022-05-11 11:51:02','601',1686740.55,1686740.55,'601','2022-05-11 06:48:13','600','2022-05-11 09:38:28',10,0),('5','172',257716,'DAILY SHITF','2022-05-11','2022-05-11 11:28:45','2022-05-12 11:28:45','601',1620638.25,1620638.25,'601','2022-05-12 12:42:27','600','2022-05-12 13:09:22',10,0),('5','172',257717,'DAILY SHITF','2022-05-12','2022-05-13 10:21:07','2022-05-14 10:21:07','601',2454041.70,2454041.70,'601','2022-05-13 12:05:39','600','2022-05-14 13:45:54',10,0),('5','172',257718,'DAILY SHITF','2022-05-13','2022-05-14 20:21:02','2022-05-15 20:21:02','601',2425795.35,2425795.35,'601','2022-05-14 21:05:09','600','2022-05-15 06:17:36',10,0),('5','172',257719,'DAILY SHITF','2022-05-14','2022-05-15 06:59:36','2022-05-16 06:59:36','601',2286683.00,2286683.00,'601','2022-05-15 07:00:25','600','2022-05-16 10:03:35',10,0),('5','172',257720,'DAILY SHITF','2022-05-15','2022-05-16 11:50:05','2022-05-17 11:50:05','601',2797494.00,2797494.00,'601','2022-05-16 11:50:40','600','2022-05-16 12:03:26',10,0),('5','172',257721,'DAILY SHITF','2022-05-16','2022-05-16 12:33:19','2022-05-17 12:33:19','601',4370324.00,4370324.00,'601','2022-05-17 07:14:56','600','2022-05-17 07:24:45',10,0),('5','172',257722,'DAILY SHIRT ','2022-05-17','2022-05-17 14:32:02','2022-05-18 14:32:02','601',3997504.00,3997504.00,'601','2022-05-18 07:02:56','600','2022-05-18 07:35:49',10,0),('5','172',257723,'DAILY SHIRT ','2022-05-18','2022-05-18 12:45:08','2022-05-19 12:45:08','601',6385701.00,6385701.00,'601','2022-05-19 07:23:02','600','2022-05-19 08:20:58',10,0),('5','172',257724,'DAILY SHIRT ','2022-05-19','2022-05-19 14:10:03','2022-05-20 14:10:03','601',3585960.00,3585960.00,'601','2022-05-20 09:43:54','600','2022-05-20 09:59:07',10,0),('5','172',257725,'DAILY SHIRT ','2022-05-20','2022-05-20 11:36:52','2022-05-21 11:36:52','601',3834362.00,3834362.00,'601','2022-05-21 07:16:46','600','2022-05-21 08:00:08',10,0),('5','172',257726,'DAILY SHIRT ','2022-05-21','2022-05-22 07:21:06','2022-05-23 07:21:06','601',3867339.00,3867339.00,'601','2022-05-22 07:21:40','600','2022-05-22 08:11:38',10,0),('5','172',257727,'DAILY SHIRT ','2022-05-22','2022-05-23 07:02:52','2022-05-24 07:02:52','601',2831213.00,2831213.00,'601','2022-05-23 07:03:27','600','2022-05-23 07:50:58',10,0),('5','172',257728,'DAILY SHIRT ','2022-05-23','2022-05-23 09:22:07','2022-05-24 09:22:07','601',4599979.35,4599979.35,'601','2022-05-24 07:18:06','600','2022-05-24 08:00:20',10,0),('5','172',257729,'DAILY SHIRT ','2022-05-24','2022-05-24 14:05:13','2022-05-25 14:05:13','601',5450708.60,5450708.60,'601','2022-05-25 07:08:16','600','2022-05-25 07:22:31',10,0),('5','172',257730,'DAILY SHIRT ','2022-05-25','2022-05-25 12:18:08','2022-05-26 12:18:08','601',8381060.05,8381060.05,'601','2022-05-26 07:05:31','600','2022-05-26 07:43:59',10,0),('5','172',257731,'DAILY SHIRT ','2022-05-26','2022-05-26 11:58:07','2022-05-27 11:58:07','601',5808881.15,5808881.15,'601','2022-05-27 08:48:24','600','2022-05-27 10:00:49',10,0),('5','172',257732,'DAILY SHIRT ','2022-05-27','2022-05-27 15:07:03','2022-05-28 15:07:03','601',2961251.05,2961251.05,'601','2022-05-28 07:15:52','600','2022-05-28 08:13:28',10,0),('5','172',257733,'DAILY SHIRT','2022-05-28','2022-05-29 07:42:54','2022-05-30 07:42:54','601',1341921.90,1341921.90,'601','2022-05-29 07:43:45','600','2022-05-29 08:16:02',10,0),('5','172',257734,'DAILY SHIRT ','2022-05-29','2022-05-30 07:51:03','2022-05-31 07:51:03','601',1450526.55,1450526.55,'601','2022-05-30 07:52:28','600','2022-05-30 11:17:02',10,0),('5','172',257735,'DAILY SHIRT','2022-05-30','2022-05-31 07:24:11','2022-06-01 07:24:11','601',2321056.65,2321056.65,'601','2022-05-31 07:25:18','600','2022-05-31 09:08:33',10,0),('5','172',257736,'DAILY SHIRT ','2022-05-31','2022-06-01 07:06:33','2022-06-02 07:06:33','601',1202874.75,1202874.75,'601','2022-06-01 07:07:52','600','2022-06-01 09:23:26',10,0),('5','172',257737,'DAILY SHIRT ','2022-06-01','2022-06-01 11:37:25','2022-06-02 11:37:25','601',1909932.75,1909932.75,'601','2022-06-02 07:06:27','600','2022-06-02 09:08:01',10,0),('5','172',257738,'DAILY SHIRT ','2022-06-02','2022-06-02 10:37:51','2022-06-03 10:37:51','601',2314091.95,2314091.95,'601','2022-06-03 12:40:44','600','2022-06-03 16:29:38',10,0),('5','172',257739,'DAILY SHITF','2022-06-03','2022-06-04 07:02:35','2022-06-05 07:02:35','601',1192052.40,1192052.40,'601','2022-06-04 07:05:19','600','2022-06-04 09:23:52',10,0),('5','172',257740,'DAILY SHIRT ','2022-06-04','2022-06-05 07:58:25','2022-06-06 07:58:25','601',1134548.25,1134548.25,'601','2022-06-05 07:59:17','600','2022-06-06 09:53:49',10,0),('5','172',257741,'DAILY SHIRT ','2022-06-05','2022-06-06 10:33:40','2022-06-07 10:33:40','601',1107440.40,1107440.40,'601','2022-06-06 10:34:51','600','2022-06-07 09:09:22',10,0),('5','172',257742,'DAILY SHIRT ','2022-06-06','2022-06-07 10:23:17','2022-06-08 10:23:17','601',1872174.15,1872174.15,'601','2022-06-07 10:25:48','600','2022-06-07 11:02:00',10,0),('5','172',257743,'DAILY SHIRT ','2022-06-07','2022-06-07 15:13:05','2022-06-08 15:13:05','601',2306546.55,2306546.55,'601','2022-06-08 07:01:54','600','2022-06-08 09:49:07',10,0),('5','172',257744,'DAILY SHIRT ','2022-06-08','2022-06-08 13:28:52','2022-06-09 13:28:52','601',1339362.75,1339362.75,'601','2022-06-09 07:02:11','600','2022-06-09 11:15:09',10,0),('5','172',257745,'DAILY SHIRT ','2022-06-09','2022-06-10 07:48:54','2022-06-11 07:48:54','601',0.00,0.00,'601','2022-06-10 07:49:31','600','2022-06-10 09:22:18',10,0),('5','172',257746,'DAILY SHIRT ','2022-06-10','2022-06-11 09:14:49','2022-06-12 09:14:49','601',0.00,0.00,'601','2022-06-11 09:15:07','600','2022-06-11 09:30:55',10,0),('5','172',257747,'DAILY SHIRT','2022-06-11','2022-06-11 20:29:42','2022-06-12 20:29:42','601',0.00,0.00,'601','2022-06-11 20:30:01','600','2022-06-12 09:56:15',10,0),('5','172',257748,'DAILY SHIRT ','2022-06-12','2022-06-12 21:04:03','2022-06-13 21:04:03','601',0.00,0.00,'601','2022-06-12 21:04:26','600','2022-06-13 09:31:54',10,0),('5','172',257749,'DAILY SHIRT ','2022-06-13','2022-06-13 09:40:44','2022-06-14 09:40:44','601',0.00,0.00,'600','2022-06-14 15:29:42','600','2022-06-14 15:30:25',10,0),('5','172',257750,'DAILY SHIRT ','2022-06-13','2022-06-14 15:33:50','2022-06-15 15:33:50','601',942045.00,942045.00,'601','2022-06-14 15:34:27','600','2022-06-15 09:26:24',10,0),('5','172',257751,'DAILY SHIRT ','2022-06-14','2022-06-15 09:53:52','2022-06-16 09:53:52','601',2538915.60,2538915.60,'601','2022-06-15 09:55:23','600','2022-06-16 09:19:12',10,0),('5','172',257752,'DAILY SHIRT ','2022-06-15','2022-06-16 14:24:34','2022-06-17 14:24:34','601',2160301.50,2160301.50,'601','2022-06-16 14:25:58','600','2022-06-17 09:57:41',10,0),('5','172',257753,'DAILY SHIRT','2022-06-16','2022-06-17 12:53:54','2022-06-18 12:53:54','601',3751684.05,3751684.05,'601','2022-06-17 12:55:22','600','2022-06-18 09:49:05',10,0),('5','172',257754,'DAILY SHIRT ','2022-06-17','2022-06-18 12:42:17','2022-06-19 12:42:17','601',6532769.85,6532769.85,'601','2022-06-18 12:43:24','600','2022-06-19 09:34:47',10,0),('5','172',257755,'DAILY SHIRT','2022-06-18','2022-06-19 11:14:51','2022-06-20 11:14:51','601',5831421.00,5831421.00,'601','2022-06-19 14:35:39','600','2022-06-20 09:59:42',10,0),('5','172',257756,'DAILY SHIRT ','2022-06-19','2022-06-20 10:29:38','2022-06-21 10:29:38','601',4896269.10,4896269.10,'601','2022-06-20 10:30:34','600','2022-06-21 09:57:21',10,0),('5','172',257757,'DAILY SHIRT ','2022-06-20','2022-06-21 12:26:15','2022-06-22 12:26:15','601',4685757.00,4685757.00,'601','2022-06-21 12:28:02','600','2022-06-22 09:32:51',10,0),('5','172',257758,'DAILY SHIRT ','2022-06-21','2022-06-22 10:36:36','2022-06-23 10:36:36','601',3687664.95,3687664.95,'601','2022-06-22 12:56:04','600','2022-06-22 14:32:11',10,0),('5','172',257759,'DAILY SHIRT ','2022-06-22','2022-06-23 11:23:56','2022-06-24 11:23:56','601',6411711.90,6411711.90,'601','2022-06-23 11:25:06','600','2022-06-23 14:26:08',10,0),('5','172',257760,'DAILY SHIRT ','2022-06-23','2022-06-24 09:46:33','2022-06-25 09:46:33','601',3984583.20,3984583.20,'601','2022-06-24 09:47:33','600','2022-06-24 12:16:13',10,0),('5','172',257761,'DAILY SHIRT ','2022-06-24','2022-06-25 09:56:25','2022-06-26 09:56:25','601',2916287.40,2916287.40,'601','2022-06-25 09:57:51','600','2022-06-25 14:02:43',10,0),('5','172',257762,'DAILY SHIRT ','2022-06-25','2022-06-26 07:21:50','2022-06-27 07:21:50','601',2522995.80,2522995.80,'601','2022-06-26 07:22:54','600','2022-06-26 12:15:51',10,0),('5','172',257763,'DAILY SHIRT ','2022-06-26','2022-06-26 21:02:16','2022-06-27 21:02:16','601',3719566.65,3719566.65,'601','2022-06-27 11:20:27','600','2022-06-28 09:19:06',10,0),('5','172',257764,'DAILY SHIRT ','2022-06-27','2022-06-28 11:07:06','2022-06-29 11:07:06','601',4891206.45,4891206.45,'601','2022-06-28 11:08:12','600','2022-06-28 11:33:21',10,0),('5','172',257765,'DAILY SHIRT','2022-06-28','2022-06-28 14:43:39','2022-06-29 14:43:39','601',5863693.80,5863693.80,'601','2022-06-29 06:54:00','600','2022-06-29 09:08:38',10,0),('5','172',257766,'DAILY SHIRT ','2022-06-29','2022-06-29 11:25:07','2022-06-30 11:25:07','601',3048556.95,3048556.95,'601','2022-06-30 07:28:48','600','2022-06-30 08:32:08',10,0),('5','172',257767,'DAILY SHIRT ','2022-06-30','2022-06-30 14:22:47','2022-07-01 14:22:47','601',5095620.90,5095620.90,'601','2022-07-01 07:07:59','600','2022-07-01 09:56:20',10,0),('5','172',257768,'DAILY SHIRT ','2022-07-01','2022-07-02 06:48:32','2022-07-03 06:48:32','601',2850613.80,2850613.80,'601','2022-07-02 06:51:59','600','2022-07-02 13:44:22',10,0),('5','172',257769,'DAILY SHIRT','2022-07-02','2022-07-02 21:53:01','2022-07-03 21:53:01','601',4778651.70,4778651.70,'601','2022-07-03 12:42:37','600','2022-07-03 12:48:35',10,0),('5','172',257770,'DAILY SHIRT','2022-07-03','2022-07-04 06:34:18','2022-07-05 06:34:18','601',5613234.75,5613234.75,'601','2022-07-04 06:35:18','600','2022-07-04 12:15:12',10,0),('5','172',257771,'DAILY SHIRT ','2022-07-04','2022-07-04 12:42:47','2022-07-05 12:42:47','601',5496408.75,5496408.75,'601','2022-07-05 09:10:11','600','2022-07-05 09:18:51',10,0),('5','172',257772,'DAILY SHIRT','2022-07-05','2022-07-05 16:56:14','2022-07-06 16:56:14','601',1246081.65,1246081.65,'601','2022-07-06 08:09:47','600','2022-07-06 09:18:06',10,0),('5','172',257773,'DAILY SHIRT','2022-07-06','2022-07-06 11:20:44','2022-07-07 11:20:44','601',1238503.20,1238503.20,'601','2022-07-07 07:26:31','600','2022-07-07 10:41:19',10,0),('5','172',257774,'DAILY SHIRT','2022-07-07','2022-07-07 11:34:02','2022-07-08 11:34:02','601',982776.30,982776.30,'601','2022-07-09 08:03:57','600','2022-07-09 16:55:31',10,0),('5','172',257775,'DAILY SHIRT ','2022-07-08','2022-07-10 07:09:01','2022-07-11 07:09:01','601',0.00,0.00,'601','2022-07-10 07:09:38','600','2022-07-10 09:30:45',10,0),('5','172',257776,'DAILY SHIRT ','2022-07-09','2022-07-10 10:51:02','2022-07-11 10:51:02','601',1247697.00,1247697.00,'601','2022-07-10 18:31:22','600','2022-07-10 18:40:12',10,0),('5','172',257777,'DAILY SHIRT','2022-07-10','2022-07-10 19:14:38','2022-07-11 19:14:38','601',1192249.15,1192249.15,'601','2022-07-11 10:59:00','600','2022-07-12 10:55:01',10,0),('5','172',257778,'DAILY SHIRT ','2022-07-12','2022-07-12 15:26:29','2022-07-13 15:26:29','601',1378529.35,1378529.35,'601','2022-07-12 15:55:52','600','2022-07-13 09:33:56',10,0),('5','172',257779,'DAILY SHIRT','2022-07-12','2022-07-13 10:12:41','2022-07-14 10:12:41','601',975234.90,975234.90,'601','2022-07-13 10:13:32','600','2022-07-14 10:02:50',10,0),('5','172',257780,'DAILY SHIRT','2022-07-13','2022-07-14 19:37:09','2022-07-15 19:37:09','601',2089843.90,2089843.90,'601','2022-07-14 21:57:54','600','2022-07-15 11:00:47',10,0),('5','172',257781,'DAILY SHITF','2022-07-14','2022-07-15 11:29:50','2022-07-16 11:29:50','601',2858392.60,2858392.60,'601','2022-07-15 11:32:36','600','2022-07-16 09:57:20',10,0),('5','172',257782,'DAILY SHIRT ','2022-07-15','2022-07-16 11:23:35','2022-07-17 11:23:35','601',2870182.90,2870182.90,'601','2022-07-16 11:25:47','600','2022-07-17 05:00:44',10,0),('5','172',257783,'DAILY SHIRT ','2022-07-16','2022-07-17 11:48:45','2022-07-18 11:48:45','601',2261766.00,2261766.00,'601','2022-07-17 11:49:37','600','2022-07-17 14:31:16',10,0),('5','172',257784,'DAILY SHIRT ','2022-07-17','2022-07-17 16:27:46','2022-07-18 16:27:46','601',4257123.00,4257123.00,'601','2022-07-17 22:17:16','600','2022-07-18 07:34:21',10,0),('5','172',257785,'DAILY SHIRT','2022-07-18','2022-07-19 08:23:18','2022-07-20 08:23:18','601',2915967.60,2915967.60,'601','2022-07-19 08:24:01','600','2022-07-19 09:42:15',10,0),('5','172',257786,'DAILY SHIRT ','2022-07-19','2022-07-20 09:01:44','2022-07-21 09:01:44','601',2677903.80,2677903.80,'601','2022-07-20 09:02:36','600','2022-07-20 09:12:58',10,0),('5','172',257787,'DAILY SHIRT ','2022-07-20','2022-07-20 21:41:16','2022-07-21 21:41:16','601',2998226.40,2998226.40,'601','2022-07-20 21:41:45','600','2022-07-21 09:03:56',10,0),('5','172',257788,'DAILY SHIRT','2022-07-21','2022-07-21 16:13:36','2022-07-22 16:13:36','601',2738057.40,2738057.40,'601','2022-07-22 07:59:03','600','2022-07-22 09:53:59',10,0),('5','172',257789,'DAILY SHIRT ','2022-07-22','2022-07-25 07:22:59','2022-07-26 07:22:59','601',2899743.60,2899743.60,'601','2022-07-25 07:24:16','600','2022-07-25 07:35:54',10,0),('5','172',257790,'DAILY SHIRT ','2022-07-23','2022-07-25 11:55:25','2022-07-26 11:55:25','601',4192500.00,4192500.00,'601','2022-07-25 11:56:04','600','2022-07-25 11:57:44',10,0),('5','172',257791,'DAILY SHIRT ','2022-07-24','2022-07-25 12:04:32','2022-07-26 12:04:32','601',1738035.00,1738035.00,'601','2022-07-25 12:05:01','600','2022-07-25 12:39:33',10,0),('5','172',257792,'DAILY SHIRT ','2022-07-25','2022-07-25 13:24:20','2022-07-26 13:24:20','601',4923820.20,4923820.20,'601','2022-07-26 10:25:26','600','2022-07-26 12:13:50',10,0),('5','172',257793,'DAILY SHIRT ','2022-07-26','2022-07-27 07:33:19','2022-07-28 07:33:19','601',2795208.00,2795208.00,'601','2022-07-27 07:33:58','600','2022-07-27 09:20:08',10,0),('5','172',257794,'DAILY SHIRT','2022-07-27','2022-07-27 12:01:41','2022-07-28 12:01:41','601',3135155.40,3135155.40,'601','2022-07-28 07:53:57','600','2022-07-28 09:28:13',10,0),('5','172',257795,'DAILY SHIRT ','2022-07-28','2022-07-29 07:29:13','2022-07-30 07:29:13','601',2768025.00,2768025.00,'601','2022-07-29 07:29:44','600','2022-07-29 09:24:28',10,0),('5','172',257796,'DAILY SHIRT ','2022-07-29','2022-07-30 07:44:34','2022-07-31 07:44:34','601',2643357.60,2643357.60,'601','2022-07-30 07:45:06','600','2022-07-30 20:10:56',10,0),('5','172',257797,'DAILY SHIRT ','2022-07-30','2022-07-31 07:30:11','2022-08-01 07:30:11','601',3030627.60,3030627.60,'601','2022-07-31 07:30:47','600','2022-07-31 10:17:33',10,0),('5','172',257798,'DAILY SHIRT ','2022-07-31','2022-08-01 07:38:53','2022-08-02 07:38:53','601',3238248.00,3238248.00,'601','2022-08-01 07:40:04','600','2022-08-01 08:27:26',10,0),('5','172',257799,'DAILY SHITF','2022-08-01','2022-08-02 07:20:39','2022-08-03 07:20:39','601',1715422.80,1715422.80,'601','2022-08-02 07:21:12','600','2022-08-02 11:18:19',10,0),('5','172',257800,'DAILY SHIRT','2022-08-02','2022-08-02 17:19:44','2022-08-03 17:19:44','601',3535740.00,3535740.00,'601','2022-08-03 07:32:34','600','2022-08-03 10:14:19',10,0),('5','172',257801,'DAILY SHIRT ','2022-08-03','2022-08-03 11:09:24','2022-08-04 11:09:24','601',2611245.00,2611245.00,'601','2022-08-04 07:56:09','600','2022-08-04 08:21:45',10,0),('5','172',257802,'DAILY SHIRT ','2022-08-04','2022-08-04 15:34:33','2022-08-05 15:34:33','601',3117566.45,3117566.45,'601','2022-08-05 10:41:25','600','2022-08-05 13:46:28',10,0),('5','172',257803,'DAILY SHIRT ','2022-08-05','2022-08-06 11:42:20','2022-08-07 11:42:20','601',4638473.40,4638473.40,'601','2022-08-06 11:43:55','600','2022-08-06 20:39:43',10,0),('5','172',257804,'DAILY SHIRT ','2022-08-06','2022-08-07 14:54:41','2022-08-08 14:54:41','601',4139062.25,4139062.25,'601','2022-08-07 14:56:21','600','2022-09-03 05:10:55',10,0),('5','172',257805,'DAILY SHIRT ','2022-08-07','2022-09-03 14:18:14','2022-09-04 14:18:14','601',3144320.45,3144320.45,'601','2022-09-03 14:20:47','600','2022-09-03 17:02:45',10,0),('5','172',257806,'DAILY SHIRT ','2022-08-08','2022-09-05 11:29:01','2022-09-06 11:29:01','601',2126005.20,2126005.20,'601','2022-09-05 11:30:20','600','2022-09-07 10:27:56',10,0),('5','172',257807,'DAILY SHIRT ','2022-08-09','2022-09-07 10:32:03','2022-09-08 10:32:03','601',2122179.40,2122179.40,'601','2022-09-07 10:33:11','600','2022-09-07 10:34:06',10,0),('5','172',257808,'DAILY SHIRT ','2022-08-10','2022-09-07 10:35:07','2022-09-08 10:35:07','601',1700621.75,1700621.75,'601','2022-09-07 10:35:57','600','2022-09-07 10:39:01',10,0),('5','172',257809,'DAILY SHIRT ','2022-08-11','2022-09-07 10:40:43','2022-09-08 10:40:43','601',1804277.25,1804277.25,'601','2022-09-07 10:43:54','600','2022-09-07 10:44:35',10,0),('5','172',257810,'DAILY SHIRT ','2022-08-12','2022-09-07 10:46:44','2022-09-08 10:46:44','601',1375647.05,1375647.05,'601','2022-09-07 10:47:55','600','2022-09-07 10:48:59',10,0),('5','172',257811,'DAILY SHIRT ','2022-08-13','2022-09-07 10:49:41','2022-09-08 10:49:41','601',696068.05,696068.05,'601','2022-09-07 10:52:03','600','2022-09-07 11:03:28',10,0),('5','172',257812,'DAILY SHITF ','2022-08-14','2022-09-07 11:46:38','2022-09-08 11:46:38','601',0.00,0.00,'601','2022-09-07 11:46:54','600','2022-09-07 11:58:24',10,0),('5','172',257813,'DAILY SHIRT ','2022-08-15','2022-09-07 12:02:02','2022-09-08 12:02:02','601',0.00,0.00,'601','2022-09-07 12:02:16','600','2022-09-07 12:03:30',10,0),('5','172',257814,'DAILY SHIRT ','2022-08-16','2022-09-07 12:34:14','2022-09-08 12:34:14','601',0.00,0.00,'601','2022-09-07 12:34:43','600','2022-09-07 13:23:25',10,0),('5','172',257815,'DAILY SHITF','2022-08-17','2022-09-07 13:32:32','2022-09-08 13:32:32','601',1409374.20,1409374.20,'601','2022-09-07 14:28:16','600','2022-09-07 14:28:55',10,0),('5','172',257816,'DAILY SHITF','2022-08-18','2022-09-07 14:29:51','2022-09-08 14:29:51','601',2752058.40,2752058.40,'601','2022-09-07 14:30:27','600','2022-09-07 14:35:45',10,0),('5','172',257817,'DAILY SHIRT ','2022-08-19','2022-09-07 14:49:17','2022-09-08 14:49:17','601',1436089.20,1436089.20,'601','2022-09-07 14:49:55','600','2022-09-07 14:52:24',10,0),('5','172',257818,'DAILY SHIRT ','2022-08-20','2022-09-07 14:54:10','2022-09-08 14:54:10','601',1486999.80,1486999.80,'601','2022-09-07 14:54:46','600','2022-09-07 14:55:57',10,0),('5','172',257819,'DAILY SHIRT ','2022-08-21','2022-09-07 14:56:40','2022-09-08 14:56:40','601',2889471.00,2889471.00,'601','2022-09-07 14:57:18','600','2022-09-07 15:06:24',10,0),('5','172',257820,'DAILY SHIRT ','2022-08-22','2022-09-07 15:11:10','2022-09-08 15:11:10','601',1748658.60,1748658.60,'601','2022-09-07 15:11:46','600','2022-09-07 15:21:04',10,0),('5','172',257821,'DAILY SHIRT ','2022-08-23','2022-09-07 19:31:38','2022-09-08 19:31:38','601',1661719.80,1661719.80,'601','2022-09-08 11:08:54','600','2022-09-08 11:09:46',10,0),('5','172',257822,'DAILY SHIRT ','2022-08-24','2022-09-08 11:10:29','2022-09-09 11:10:29','601',1763681.40,1763681.40,'601','2022-09-08 11:11:00','600','2022-09-08 11:40:04',10,0),('5','172',257823,'DAILY SHIRT ','2022-08-25','2022-09-08 11:56:57','2022-09-09 11:56:57','601',2716818.00,2716818.00,'601','2022-09-08 11:57:31','600','2022-09-08 11:57:57',10,0),('5','172',257824,'DAILY SHITF','2022-08-26','2022-09-08 11:58:53','2022-09-09 11:58:53','601',1455597.00,1455597.00,'601','2022-09-08 11:59:22','600','2022-09-08 11:59:55',10,0),('5','172',257825,'DAILY SHIRT ','2022-08-27','2022-09-08 12:00:59','2022-09-09 12:00:59','601',1487709.60,1487709.60,'601','2022-09-08 12:01:32','600','2022-09-08 12:03:53',10,0),('5','172',257826,'DAILY SHITF','2022-09-08','2022-09-08 12:08:57','2022-09-09 12:08:57','601',0.00,0.00,'600','2022-09-08 12:14:49','600','2022-09-08 12:15:02',10,0),('5','172',257827,'DAILY SHITF','2022-08-28','2022-09-08 12:24:36','2022-09-09 12:24:36','601',2492178.00,2492178.00,'601','2022-09-08 12:25:41','600','2022-09-08 12:27:56',10,0),('5','172',257828,'DAILY SHIRT ','2022-08-29','2022-09-08 12:28:44','2022-09-09 12:28:44','601',2432313.00,2432313.00,'601','2022-09-08 12:29:13','600','2022-09-08 12:33:34',10,0),('5','172',257829,'DAILY SHIRT ','2022-08-30','2022-09-08 12:34:22','2022-09-09 12:34:22','601',2664511.20,2664511.20,'601','2022-09-08 12:34:51','600','2022-09-08 12:35:24',10,0),('5','172',257830,'DAILY SHIRT ','2022-09-08','2022-09-08 12:36:11','2022-09-09 12:36:11','601',0.00,0.00,'600','2022-09-08 12:39:54','600','2022-09-08 12:40:07',10,0),('5','172',257831,'DAILY SHIRT ','2022-08-31','2022-09-08 12:45:34','2022-09-09 12:45:34','601',1860900.60,1860900.60,'601','2022-09-08 12:48:34','600','2022-09-08 12:49:13',10,0),('5','172',257832,'DAILY SHIRT ','2022-09-01','2022-09-08 12:49:58','2022-09-09 12:49:58','601',2073435.00,2073435.00,'601','2022-09-08 12:50:29','600','2022-09-08 12:54:50',10,0),('5','172',257833,'DAILY SHIRT ','2022-09-02','2022-09-08 12:56:03','2022-09-09 12:56:03','601',1189398.60,1189398.60,'601','2022-09-08 12:56:37','600','2022-09-08 13:00:44',10,0),('5','172',257834,'DAILY SHITF','2022-09-03','2022-09-08 13:20:51','2022-09-09 13:20:51','601',0.00,0.00,'601','2022-09-08 13:21:05','600','2022-09-08 13:29:48',10,0),('5','172',257835,'DAILY SHITF','2022-09-04','2022-09-08 13:50:43','2022-09-09 13:50:43','601',2999997.00,2999997.00,'601','2022-09-08 13:52:33','600','2022-09-08 13:55:01',10,0),('5','172',257836,'DAILY SHIRT ','2022-09-04','2022-09-08 14:17:59','2022-09-09 14:17:59','601',2116873.20,2116873.20,'601','2022-09-08 14:39:36','600','2022-09-08 14:47:19',10,0),('5','172',257837,'DAILY SHIRT ','2022-09-05','2022-09-08 14:48:32','2022-09-09 14:48:32','601',1638842.40,1638842.40,'601','2022-09-08 14:57:29','600','2022-09-08 14:58:40',10,0),('5','172',257838,'DAILY SHIRT ','2022-09-06','2022-09-08 14:59:29','2022-09-09 14:59:29','601',2040862.20,2040862.20,'601','2022-09-08 14:59:56','600','2022-09-08 15:01:30',10,0),('5','172',257839,'DAILY SHITF','2022-09-07','2022-09-08 15:02:32','2022-09-09 15:02:32','601',675987.00,675987.00,'601','2022-09-08 15:03:06','600','2022-09-08 15:05:36',10,0),('5','172',257840,'DAILY SHITF ','2022-09-08','2022-09-09 08:27:28','2022-09-10 08:27:28','601',1236089.40,1236089.40,'601','2022-09-09 08:28:53','600','2022-09-09 09:20:02',10,0),('5','172',257841,'DAILY SHIRT ','2022-09-09','2022-09-09 17:02:28','2022-09-10 17:02:28','601',2625347.40,2625347.40,'601','2022-09-10 15:31:00','600','2022-09-11 05:58:34',10,0),('5','172',257842,'DAILY SHIRT ','2022-09-10','2022-09-11 17:29:28','2022-09-12 17:29:28','601',2446836.60,2446836.60,'601','2022-09-11 17:30:08','600','2022-09-12 11:46:58',10,0),('5','172',257843,'DAILY SHIRT ','2022-09-11','2022-09-12 12:52:18','2022-09-13 12:52:18','601',2347353.05,2347353.05,'601','2022-09-12 12:53:32','600','2022-09-13 10:34:24',10,0),('5','172',257844,'DAILY SHIRT ','2022-09-12','2022-09-13 19:44:54','2022-09-14 19:44:54','601',1768135.00,1768135.00,'601','2022-09-13 19:47:23','600','2022-09-14 06:02:47',10,0),('5','172',257845,'DAILY SHIRT ','2022-09-13','2022-09-14 12:01:58','2022-09-15 12:01:58','601',1215675.90,1215675.90,'601','2022-09-14 12:24:24','600','2022-09-14 12:25:14',10,0),('5','172',257846,'DAILY SHIRT ','2022-09-14','2022-09-14 13:39:27','2022-09-15 13:39:27','601',961694.75,961694.75,'601','2022-09-15 08:33:26','600','2022-09-15 10:06:37',10,0),('5','172',257847,'DAILY SHIRT ','2022-09-14','2022-09-16 07:44:05','2022-09-17 07:44:05','601',1170422.85,1170422.85,'601','2022-09-16 07:45:20','600','2022-09-16 10:19:18',10,0),('5','172',257848,'DAILY SHIRT ','2022-09-16','2022-09-17 07:49:11','2022-09-18 07:49:11','601',1201173.55,1201173.55,'601','2022-09-17 07:50:14','600','2022-09-17 08:22:14',10,0),('5','172',257849,'DAILY SHIRT ','2022-09-17','2022-09-18 08:29:50','2022-09-19 08:29:50','601',1348422.45,1348422.45,'601','2022-09-18 08:30:44','600','2022-09-18 08:32:44',10,0),('5','172',257850,'DAILY SHIRT ','2022-09-18','2022-09-19 15:14:44','2022-09-20 15:14:44','601',1269758.60,1269758.60,'601','2022-09-19 15:15:36','600','2022-09-20 11:04:11',10,0),('5','172',257851,'DAILY SHIRT ','2022-09-19','2022-09-20 11:23:56','2022-09-21 11:23:56','601',1235544.70,1235544.70,'601','2022-09-20 11:24:59','600','2022-09-21 08:12:24',10,0),('5','172',257852,'DAILY SHITF ','2022-09-20','2022-09-21 08:59:44','2022-09-22 08:59:44','601',1447708.25,1447708.25,'601','2022-09-21 09:46:28','600','2022-09-22 08:45:46',10,0),('5','172',257853,'DAILY SHITF','2022-09-21','2022-09-22 10:20:22','2022-09-23 10:20:22','601',1357309.85,1357309.85,'601','2022-09-22 10:21:14','600','2022-09-22 16:38:40',10,0),('5','172',257854,'DAILY SHIRT ','2022-09-22','2022-09-23 11:39:50','2022-09-24 11:39:50','601',1293717.95,1293717.95,'601','2022-09-23 11:40:53','600','2022-09-24 09:56:36',10,0),('5','172',257855,'DAILY SHIRT ','2022-09-23','2022-09-24 11:47:06','2022-09-25 11:47:06','601',1233587.40,1233587.40,'601','2022-09-24 11:48:24','600','2022-09-25 08:22:06',10,0),('5','172',257856,'DAILY SHIRT ','2022-09-24','2022-09-25 08:29:16','2022-09-26 08:29:16','601',1429583.80,1429583.80,'601','2022-09-25 20:38:44','600','2022-09-26 08:26:07',10,0),('5','172',257857,'DAILY SHIRT ','2022-09-25','2022-09-26 10:54:18','2022-09-27 10:54:18','601',0.00,0.00,'601','2022-09-26 10:54:33','600','2022-09-26 11:11:02',10,0),('5','172',257858,'DAILY SHIRT ','2022-09-26','2022-09-26 11:18:33','2022-09-27 11:18:33','601',0.00,0.00,'601','2022-09-26 19:04:38','600','2022-09-27 08:20:20',10,0),('5','172',257859,'DAILY SHIRT ','2022-09-27','2022-09-28 07:54:41','2022-09-29 07:54:41','601',0.00,0.00,'601','2022-09-28 07:55:05','600','2022-09-28 10:04:15',10,0),('5','172',257860,'DAILY SHIRT ','2022-09-28','2022-09-28 19:43:22','2022-09-29 19:43:22','601',0.00,0.00,'601','2022-09-28 19:43:39','600','2022-09-29 06:17:38',10,0),('5','172',257861,'DAILY SHIRT ','2022-09-30','2022-10-01 18:15:36','2022-10-02 18:15:36','601',1118648.75,1118648.75,'601','2022-10-01 18:17:45','600','2022-10-02 08:09:15',10,0),('5','172',257862,'DAILY SHIRT ','2022-10-02','2022-10-03 07:57:17','2022-10-04 07:57:17','601',1223334.70,1223334.70,'601','2022-10-03 07:59:08','600','2022-10-03 09:33:39',10,0),('5','172',257863,'DAILY SHIRT ','2022-10-02','2022-10-04 13:38:43','2022-10-05 13:38:43','601',1137666.75,1137666.75,'601','2022-10-04 13:45:41','600','2022-10-04 14:06:33',10,0),('5','172',257864,'DAILY SHITF ','2022-10-03','2022-10-04 19:42:16','2022-10-05 19:42:16','601',1659424.10,1659424.10,'601','2022-10-05 08:17:38','600','2022-10-05 10:52:12',10,0),('5','172',257865,'DAILY SHITF ','2022-10-04','2022-10-05 14:24:07','2022-10-06 14:24:07','601',1474072.60,1474072.60,'601','2022-10-05 14:25:00','600','2022-10-05 15:33:44',10,0),('5','172',257866,'DAILY SHIRT ','2022-10-05','2022-10-06 08:19:03','2022-10-07 08:19:03','601',2664210.75,2664210.75,'601','2022-10-06 09:40:44','600','2022-10-06 10:36:34',10,0),('5','172',257867,'DAILY SHIRT ','2022-10-06','2022-10-07 12:10:31','2022-10-08 12:10:31','601',3291639.75,3291639.75,'601','2022-10-07 12:11:41','600','2022-10-08 08:15:38',10,0),('5','172',257868,'DAILY SHIRT ','2022-10-07','2022-10-09 00:07:36','2022-10-10 00:07:36','601',4062826.85,4062826.85,'601','2022-10-09 00:08:50','600','2022-10-09 07:58:50',10,0),('5','172',257869,'DAILY SHITF','2022-10-08','2022-10-09 09:48:47','2022-10-10 09:48:47','601',4568961.00,4568961.00,'601','2022-10-09 09:50:20','600','2022-10-09 16:32:17',10,0),('5','172',257870,'DAILY SHITF','2022-10-09','2022-10-10 08:19:24','2022-10-11 08:19:24','601',3619592.30,3619592.30,'601','2022-10-10 08:20:49','600','2022-10-10 10:28:01',10,0),('5','172',257871,'DAILY SHITF','2022-10-10','2022-10-11 12:25:34','2022-10-12 12:25:34','601',2867666.75,2867666.75,'601','2022-10-11 12:27:07','600','2022-10-12 09:00:38',10,0),('5','172',257872,'DAILY SHIRT ','2022-10-11','2022-10-12 12:16:58','2022-10-13 12:16:58','601',5390625.35,5390625.35,'601','2022-10-12 12:18:45','600','2022-10-12 16:51:43',10,0),('5','172',257873,'DAILY SHITF','2022-10-12','2022-10-13 07:51:46','2022-10-14 07:51:46','601',4905053.95,4905053.95,'601','2022-10-13 07:53:19','600','2022-10-13 08:21:17',10,0),('5','172',257874,'DAILY SHITF','2022-10-13','2022-10-14 08:17:06','2022-10-15 08:17:06','601',3687246.70,3687246.70,'601','2022-10-14 08:22:52','600','2022-10-14 08:42:59',10,0),('5','172',257875,'DAILY SHITF','2022-10-14','2022-10-14 10:37:51','2022-10-15 10:37:51','601',2878257.85,2878257.85,'601','2022-10-15 11:00:03','600','2022-10-15 11:58:27',10,0),('5','172',257876,'DAILY SHITF ','2022-10-15','2022-10-16 08:34:30','2022-10-17 08:34:30','601',1985786.40,1985786.40,'601','2022-10-16 08:35:03','600','2022-10-16 10:01:05',10,0),('5','172',257877,'DAILY SHIRT ','2022-10-16','2022-10-17 07:01:19','2022-10-18 07:01:19','601',1450503.60,1450503.60,'601','2022-10-17 07:01:55','600','2022-10-17 08:09:52',10,0),('5','172',257878,'DAILY SHITF','2022-10-17','2022-10-18 09:43:48','2022-10-19 09:43:48','601',2470260.00,2470260.00,'601','2022-10-18 09:44:34','600','2022-10-18 21:27:59',10,0),('5','172',257879,'DAILY SHITF ','2022-10-18','2022-10-19 05:39:42','2022-10-20 05:39:42','601',2897099.40,2897099.40,'601','2022-10-19 08:36:50','600','2022-10-19 10:37:20',10,0),('5','172',257880,'DAILY SHIRT ','2022-10-19','2022-10-19 12:56:14','2022-10-20 12:56:14','601',3172465.40,3172465.40,'601','2022-10-20 09:25:57','600','2022-10-20 09:58:30',10,0),('5','172',257881,'DAILY SHIRT ','2022-10-20','2022-10-21 00:02:37','2022-10-22 00:02:37','601',1752305.75,1752305.75,'601','2022-10-21 08:00:26','600','2022-10-21 09:47:07',10,0),('5','172',257882,'DAILY SHIRT ','2022-10-21','2022-10-21 11:57:36','2022-10-22 11:57:36','601',1672511.00,1672511.00,'601','2022-10-22 08:39:03','600','2022-10-22 09:16:10',10,0),('5','172',257883,'DAILY SHITF ','2022-10-22','2022-10-23 07:10:35','2022-10-24 07:10:35','601',1188214.30,1188214.30,'601','2022-10-23 07:11:20','600','2022-10-23 08:49:34',10,0),('5','172',257884,'DAILY SHIRT ','2022-10-23','2022-10-23 20:31:40','2022-10-24 20:31:40','601',750502.45,750502.45,'601','2022-10-24 05:49:37','600','2022-10-24 06:05:37',10,0),('5','172',257885,'DAILY SHIRT ','2022-10-24','2022-10-25 17:58:16','2022-10-26 17:58:16','601',0.00,0.00,'601','2022-10-25 17:58:38','600','2022-10-25 19:14:54',10,0),('5','172',257886,'DAILY SHIRT','2022-10-25','2022-10-26 20:39:39','2022-10-27 20:39:39','601',0.00,0.00,'601','2022-10-26 20:40:09','600','2022-10-27 05:56:15',10,0),('5','172',257887,'DAILY SHIRT ','2022-10-26','2022-10-27 09:21:00','2022-10-28 09:21:00','601',0.00,0.00,'601','2022-10-27 09:21:32','600','2022-10-27 18:39:47',10,0),('5','172',257888,'DAILY SHITF ','2022-10-27','2022-10-28 07:43:55','2022-10-29 07:43:55','601',0.00,0.00,'601','2022-10-28 07:44:12','600','2022-10-28 08:06:48',10,0),('5','172',257889,'DAILY SHIRT ','2022-10-28','2022-10-29 11:55:31','2022-10-30 11:55:31','601',0.00,0.00,'601','2022-10-29 11:55:44','600','2022-10-30 05:53:08',10,0),('5','172',257890,'DAILY SHIRT ','2022-10-29','2022-10-30 07:42:47','2022-10-31 07:42:47','601',147880.20,147880.20,'601','2022-10-30 07:43:34','600','2022-10-30 08:24:09',10,0),('5','172',257891,'DAILY SHITF ','2022-10-30','2022-10-30 21:17:51','2022-10-31 21:17:51','601',0.00,0.00,'601','2022-10-30 21:18:08','600','2022-10-31 06:04:22',10,0),('5','172',257892,'DAILY SHIRT ','2022-10-31','2022-11-01 05:40:18','2022-11-02 05:40:18','601',0.00,0.00,'601','2022-11-01 05:40:38','600','2022-11-01 05:57:52',10,0),('5','172',257893,'DAILY SHIRT ','2022-11-01','2022-11-01 20:16:29','2022-11-02 20:16:29','601',0.00,0.00,'601','2022-11-01 20:16:46','600','2022-11-02 08:35:18',10,0),('5','172',257894,'DAILY SHIRT ','2022-11-02','2022-11-02 18:34:30','2022-11-03 18:34:30','601',0.00,0.00,'601','2022-11-02 18:34:53','600','2022-11-03 06:06:36',10,0),('5','172',257895,'DAILY SHIRT ','2022-11-03','2022-11-03 22:42:06','2022-11-04 22:42:06','601',0.00,0.00,'601','2022-11-03 22:42:30','600','2022-11-04 08:18:06',10,0),('5','172',257896,'DAILY SHITF ','2022-11-04','2022-11-05 23:46:01','2022-11-06 23:46:01','601',692991.00,692991.00,'601','2022-11-05 23:46:33','600','2022-11-06 09:19:37',10,0),('5','172',257897,'DAILY SHIRT ','2022-11-05','2022-11-06 13:35:21','2022-11-07 13:35:21','601',1075425.00,1075425.00,'601','2022-11-06 13:36:12','600','2022-11-06 14:25:03',10,0),('5','172',257898,'DAILY SHIRT ','2022-11-06','2022-11-07 08:13:58','2022-11-08 08:13:58','601',861900.00,861900.00,'601','2022-11-07 08:14:40','600','2022-11-08 08:20:14',10,0),('5','172',257899,'DAILY SHIRT ','2022-11-07','2022-11-08 11:13:34','2022-11-09 11:13:34','601',2417142.00,2417142.00,'601','2022-11-08 11:14:07','600','2022-11-09 08:18:23',10,0),('5','172',257900,'DAILY SHIRT ','2022-11-08','2022-11-09 08:24:08','2022-11-10 08:24:08','601',1837180.80,1837180.80,'601','2022-11-09 08:25:29','600','2022-11-09 09:21:06',10,0),('5','172',257901,'DAILY SHIRT ','2022-11-09','2022-11-09 11:42:23','2022-11-10 11:42:23','601',1898301.60,1898301.60,'601','2022-11-10 07:46:54','600','2022-11-10 09:31:59',10,0),('5','172',257902,'DAILY SHIRT ','2022-11-10','2022-11-11 11:07:17','2022-11-12 11:07:17','601',1501071.00,1501071.00,'601','2022-11-11 11:07:55','600','2022-11-11 13:26:21',10,0),('5','172',257903,'DAILY SHIRT ','2022-11-11','2022-11-11 15:18:36','2022-11-12 15:18:36','601',0.00,0.00,'600','2022-11-12 09:42:39','600','2022-11-12 09:42:56',10,0),('5','172',257904,'Daily ','2022-11-11','2022-11-12 09:43:49','2022-11-13 09:43:49','600',1033690.50,1033690.50,'600','2022-11-12 09:44:59','600','2022-11-12 09:45:14',10,0),('5','172',257905,'DAILY SHITF ','2022-11-12','2022-11-13 14:11:43','2022-11-14 14:11:43','601',329782.20,329782.20,'601','2022-11-13 14:12:35','600','2022-11-14 08:11:00',10,0),('5','172',257906,'DAILY SHIRT ','2022-11-13','2022-11-14 08:12:15','2022-11-15 08:12:15','601',409735.20,409735.20,'601','2022-11-14 08:12:44','600','2022-11-14 11:57:41',10,0),('5','172',257907,'DAILY SHIRT ','2022-11-14','2022-11-14 13:38:17','2022-11-15 13:38:17','601',1072362.00,1072362.00,'601','2022-11-15 14:36:42','600','2022-11-15 14:46:27',10,0),('5','172',257908,'DAILY SHIRT ','2022-11-15','2022-11-16 09:55:20','2022-11-17 09:55:20','601',591939.30,591939.30,'601','2022-11-16 09:56:00','600','2022-11-16 09:57:11',10,0),('5','172',257909,'DAILY SHIRT ','2022-11-16','2022-11-16 09:59:02','2022-11-17 09:59:02','601',1024319.60,1024319.60,'601','2022-11-16 09:59:45','600','2022-11-16 10:15:13',10,0),('5','172',257910,'DAILY SHIRT ','2022-11-16','2022-11-16 11:38:49','2022-11-17 11:38:49','601',2016476.70,2016476.70,'601','2022-11-17 07:30:35','600','2022-11-17 10:02:09',10,0),('5','172',257911,'DAILY SHIRT ','2022-11-17','2022-11-17 11:53:43','2022-11-18 11:53:43','601',1907447.90,1907447.90,'601','2022-11-18 07:53:39','600','2022-11-18 08:39:16',10,0),('5','172',257912,'DAILY SHITF ','2022-11-18','2022-11-18 15:08:36','2022-11-19 15:08:36','601',1712281.70,1712281.70,'601','2022-11-19 08:14:38','600','2022-11-19 09:17:39',10,0),('5','172',257913,'DAILY SHIRT ','2022-11-19','2022-11-20 08:02:18','2022-11-21 08:02:18','601',3160756.20,3160756.20,'601','2022-11-20 08:02:44','600','2022-11-20 10:35:19',10,0),('5','172',257914,'DAILY SHIRT ','2022-11-20','2022-11-21 08:34:43','2022-11-22 08:34:43','601',2381817.80,2381817.80,'601','2022-11-21 08:35:39','600','2022-11-21 08:56:33',10,0),('5','172',257915,'DAILY SHIRT ','2022-11-21','2022-11-21 11:15:13','2022-11-22 11:15:13','601',3295324.10,3295324.10,'601','2022-11-22 07:21:02','600','2022-11-22 08:15:58',10,0),('5','172',257916,'DAILY SHIRT ','2022-11-22','2022-11-22 12:38:25','2022-11-23 12:38:25','601',2456899.60,2456899.60,'601','2022-11-23 07:32:49','600','2022-11-23 08:37:04',10,0),('5','172',257917,'DAILY SHITF','2022-11-23','2022-11-23 09:40:17','2022-11-24 09:40:17','601',1113196.00,1113196.00,'601','2022-11-24 07:26:06','600','2022-11-24 08:52:53',10,0),('5','172',257918,'DAILY SHIRT ','2022-11-24','2022-11-24 09:15:25','2022-11-25 09:15:25','601',0.00,0.00,'600','2022-11-25 10:25:34','600','2022-11-25 10:25:47',10,0),('5','172',257919,'DAILY SHITF','2022-11-25','2022-11-26 11:34:47','2022-11-27 11:34:47','601',2091269.60,2091269.60,'601','2022-11-26 11:35:38','600','2022-11-26 11:46:11',10,0),('5','172',257920,'DAILY SHIRT ','2022-11-26','2022-11-27 07:44:11','2022-11-28 07:44:11','601',3006244.45,3006244.45,'601','2022-11-27 07:44:56','600','2022-11-27 09:32:38',10,0),('5','172',257921,'DAILY SHITF','2022-11-27','2022-11-28 09:26:12','2022-11-29 09:26:12','601',2309501.15,2309501.15,'601','2022-11-28 09:26:57','600','2022-11-28 10:12:12',10,0),('5','172',257922,'DAILY SHIRT ','2022-11-28','2022-11-28 12:13:53','2022-11-29 12:13:53','601',0.00,0.00,'601','2022-11-29 08:51:27','600','2022-11-29 09:32:45',10,0),('5','172',257923,'DAILY SHITF ','2022-11-29','2022-11-29 21:06:26','2022-11-30 21:06:26','601',0.00,0.00,'601','2022-11-29 21:06:41','600','2022-11-30 06:23:04',10,0),('5','172',257924,'DAILY SHITF ','2022-11-30','2022-12-01 09:37:58','2022-12-02 09:37:58','601',0.00,0.00,'601','2022-12-01 09:38:27','600','2022-12-01 13:05:20',10,0),('5','172',257925,'DAILY SHIRT ','2022-12-01','2022-12-01 21:53:05','2022-12-02 21:53:05','601',0.00,0.00,'601','2022-12-01 21:53:28','600','2022-12-02 06:18:39',10,0),('5','172',257926,'DAILY SHIRT','2022-12-02','2022-12-03 11:13:22','2022-12-04 11:13:22','601',0.00,0.00,'601','2022-12-03 11:13:39','600','2022-12-04 09:09:11',10,0),('5','172',257927,'DAILY SHIRT ','2022-12-03','2022-12-04 20:53:05','2022-12-05 20:53:05','601',0.00,0.00,'601','2022-12-04 20:53:20','600','2022-12-04 21:47:44',10,0),('5','172',257928,'DAILY SHIRT','2022-12-04','2022-12-05 12:20:16','2022-12-06 12:20:16','601',0.00,0.00,'601','2022-12-05 12:20:32','600','2022-12-06 06:08:47',10,0),('5','172',257929,'DAILY SHIRT ','2022-12-05','2022-12-06 08:48:41','2022-12-07 08:48:41','601',3145340.40,3145340.40,'601','2022-12-06 08:49:22','600','2022-12-06 08:51:42',10,0),('5','172',257930,'DAILY SHIRT ','2022-12-06','2022-12-06 14:40:49','2022-12-07 14:40:49','601',2447303.95,2447303.95,'601','2022-12-07 07:42:32','600','2022-12-07 08:25:57',10,0),('5','172',257931,'DAILY SHITF ','2022-12-07','2022-12-07 11:54:30','2022-12-08 11:54:30','601',1805611.10,1805611.10,'601','2022-12-08 10:17:07','600','2022-12-08 16:29:54',10,0),('5','172',257932,'DAILY SHIRT ','2022-12-08','2022-12-08 17:20:48','2022-12-09 17:20:48','601',42281.75,42281.75,'601','2022-12-09 09:10:20','600','2022-12-10 06:10:55',10,0),('5','172',257933,'DAILY SHIRT ','2022-12-09','2022-12-10 17:29:30','2022-12-11 17:29:30','601',0.00,0.00,'601','2022-12-10 17:29:48','600','2022-12-10 17:31:24',10,0),('5','172',257934,'DAILY SHIRT','2022-12-10','2022-12-11 16:47:10','2022-12-12 16:47:10','601',0.00,0.00,'601','2022-12-11 16:47:25','600','2022-12-12 08:41:54',10,0),('5','172',257935,'DAILY SHITF ','2022-12-11','2022-12-12 10:49:38','2022-12-13 10:49:38','601',0.00,0.00,'601','2022-12-12 10:50:05','600','2022-12-12 14:18:25',10,0),('5','172',257936,'DAILY SHIRT ','2022-12-12','2022-12-12 18:54:16','2022-12-13 18:54:16','601',0.00,0.00,'601','2022-12-12 18:54:36','600','2022-12-13 09:21:28',10,0),('5','172',257937,'DAILY SHIRT ','2022-12-14','2022-12-14 08:01:01','2022-12-15 08:01:01','601',0.00,0.00,'601','2022-12-14 08:01:16','600','2022-12-14 09:46:37',10,0),('5','172',257938,'DAILY SHIRT ','2022-12-14','2022-12-15 12:30:26','2022-12-16 12:30:26','601',1042322.30,1042322.30,'601','2022-12-15 12:31:13','600','2022-12-15 17:49:27',10,0),('5','172',257939,'DAILY SHIRT ','2022-12-15','2022-12-16 07:41:24','2022-12-17 07:41:24','601',943212.00,943212.00,'601','2022-12-16 07:41:55','600','2022-12-16 09:13:56',10,0),('5','172',257940,'DAILY SHIRT ','2022-12-16','2022-12-16 13:57:56','2022-12-17 13:57:56','601',1476487.00,1476487.00,'601','2022-12-17 08:06:48','600','2022-12-17 10:31:24',10,0),('5','172',257941,'DAILY SHITF','2022-12-17','2022-12-18 08:24:50','2022-12-19 08:24:50','601',2687249.50,2687249.50,'601','2022-12-18 08:25:18','600','2022-12-18 09:28:27',10,0),('5','172',257942,'DAILY SHIRT ','2022-12-18','2022-12-19 08:23:04','2022-12-20 08:23:04','601',2933825.90,2933825.90,'601','2022-12-19 08:23:37','600','2022-12-20 08:57:02',10,0),('5','172',257943,'DAILY SHIRT ','2022-12-19','2022-12-20 08:59:49','2022-12-21 08:59:49','601',1620027.20,1620027.20,'601','2022-12-20 09:00:24','600','2022-12-21 09:32:58',10,0),('5','172',257944,'DAILY SHITF','2022-12-20','2022-12-21 13:59:20','2022-12-22 13:59:20','601',1671636.60,1671636.60,'601','2022-12-21 13:59:54','600','2022-12-22 09:51:37',10,0),('5','172',257945,'DAILY SHIRT ','2022-12-21','2022-12-22 11:08:37','2022-12-23 11:08:37','601',3761485.30,3761485.30,'601','2022-12-22 11:09:06','600','2022-12-23 09:55:29',10,0),('5','172',257946,'DAILY SHITF','2022-12-22','2022-12-23 14:48:16','2022-12-24 14:48:16','601',5686180.60,5686180.60,'601','2022-12-23 14:49:42','600','2022-12-24 07:20:44',10,0),('5','172',257947,'DAILY SHIRT ','2022-12-23','2022-12-24 11:31:01','2022-12-25 11:31:01','601',3523665.40,3523665.40,'601','2022-12-24 11:31:36','600','2022-12-25 09:32:48',10,0),('5','172',257948,'DAILY SHITF ','2022-12-24','2022-12-26 07:49:44','2022-12-27 07:49:44','601',2760256.30,2760256.30,'601','2022-12-26 07:50:25','600','2022-12-26 10:06:14',10,0),('5','172',257949,'DAILY SHIRT ','2022-12-25','2022-12-26 15:31:30','2022-12-27 15:31:30','601',2581059.30,2581059.30,'601','2022-12-26 15:32:36','600','2022-12-26 17:47:09',10,0),('5','172',257950,'DAILY SHIRT ','2022-12-26','2022-12-26 21:16:03','2022-12-27 21:16:03','601',3028794.50,3028794.50,'601','2022-12-27 11:45:48','600','2022-12-27 11:55:46',10,0),('5','172',257951,'DAILY SHIRT ','2022-12-27','2022-12-28 07:04:16','2022-12-29 07:04:16','601',2836798.90,2836798.90,'601','2022-12-28 07:04:47','600','2022-12-28 09:34:25',10,0),('5','172',257952,'DAILY SHITF ','2022-12-28','2022-12-28 16:44:59','2022-12-29 16:44:59','601',2713079.10,2713079.10,'601','2022-12-29 07:36:14','600','2022-12-29 09:40:38',10,0),('5','172',257953,'DAILY SHITF ','2022-12-29','2022-12-29 14:13:47','2022-12-30 14:13:47','601',1184028.20,1184028.20,'601','2022-12-30 07:59:35','600','2022-12-30 10:26:56',10,0),('5','172',257954,'DAILY SHIRT ','2022-12-30','2022-12-30 13:56:48','2022-12-31 13:56:48','601',5676690.15,5676690.15,'601','2022-12-31 09:36:01','600','2022-12-31 09:42:38',10,0),('5','172',257955,'DAILY SHIRT ','2022-12-31','2023-01-01 07:58:05','2023-01-02 07:58:05','601',6276214.20,6276214.20,'601','2023-01-01 07:59:34','600','2023-01-01 09:27:52',10,0),('5','172',257956,'DAILY SHIRT ','2023-01-01','2023-01-02 06:30:50','2023-01-03 06:30:50','601',5872680.65,5872680.65,'601','2023-01-02 09:01:37','600','2023-01-02 09:02:35',10,0),('5','172',257957,'DAILY SHIFT ','2023-01-02','2023-01-02 21:49:51','2023-01-03 21:49:51','601',1800411.10,1800411.10,'601','2023-01-03 12:51:05','600','2023-01-04 09:16:40',10,0),('5','172',257958,'DAILY SHIFT ','2023-01-03','2023-01-04 10:48:09','2023-01-05 10:48:09','601',1856079.20,1856079.20,'601','2023-01-04 10:49:52','600','2023-01-05 09:59:39',10,0),('5','172',257959,'DAILY SHIFT ','2023-01-04','2023-01-05 10:37:17','2023-01-06 10:37:17','601',954798.80,954798.80,'601','2023-01-05 10:38:01','600','2023-01-05 10:52:44',10,0),('5','172',257960,'DAILY SHIFT ','2023-01-05','2023-01-05 13:28:32','2023-01-06 13:28:32','601',1997029.80,1997029.80,'601','2023-01-06 08:05:14','600','2023-01-06 10:18:20',10,0),('5','172',257961,'DAILY SHIFT ','2023-01-06','2023-01-06 14:06:59','2023-01-07 14:06:59','601',1862237.80,1862237.80,'601','2023-01-07 09:07:16','600','2023-01-07 10:17:03',10,0),('5','172',257962,'DAILY SHIFT ','2023-01-07','2023-01-08 09:03:58','2023-01-09 09:03:58','601',1738542.90,1738542.90,'601','2023-01-08 09:04:50','600','2023-01-08 12:45:40',10,0),('5','172',257963,'DAILY SHIFT ','2023-01-08','2023-01-09 11:24:42','2023-01-10 11:24:42','601',1921391.90,1921391.90,'601','2023-01-09 11:26:39','600','2023-01-09 11:34:23',10,0),('5','172',257964,'DAILY SHIFT ','2023-01-09','2023-01-09 15:42:57','2023-01-10 15:42:57','601',498390.10,498390.10,'601','2023-01-10 07:49:37','600','2023-01-10 08:30:16',10,0),('5','172',257965,'DAILY SHIFT ','2023-01-10','2023-01-10 10:26:39','2023-01-11 10:26:39','601',0.00,0.00,'601','2023-01-11 10:31:06','600','2023-01-12 06:22:16',10,0),('5','172',257966,'DAILY W','2023-01-11','2023-01-12 09:04:47','2023-01-13 09:04:47','601',0.00,0.00,'601','2023-01-12 09:05:18','600','2023-01-13 06:30:14',10,0),('5','172',257967,'DAILY SHIFT ','2023-01-12','2023-01-13 07:56:00','2023-01-14 07:56:00','601',854061.70,854061.70,'601','2023-01-13 09:17:09','600','2023-01-13 09:21:09',10,0),('5','172',257968,'DAILY SHIFT ','2023-01-13','2023-01-14 08:34:44','2023-01-15 08:34:44','601',1943237.50,1943237.50,'601','2023-01-14 08:35:18','600','2023-01-14 14:46:08',10,0),('5','172',257969,'DAILY SHIFT ','2023-01-14','2023-01-15 08:06:58','2023-01-16 08:06:58','601',1343130.90,1343130.90,'601','2023-01-15 08:07:38','600','2023-01-15 09:29:46',10,0),('5','172',257970,'DAILY SHIFT ','2023-01-15','2023-01-16 06:21:20','2023-01-17 06:21:20','601',2177413.70,2177413.70,'601','2023-01-16 07:54:27','600','2023-01-16 08:26:59',10,0),('5','172',257971,'DAILY SHIFT ','2023-01-16','2023-01-16 09:18:44','2023-01-17 09:18:44','601',3723230.60,3723230.60,'601','2023-01-17 07:21:21','600','2023-01-17 08:26:11',10,0),('5','172',257972,'DAILY SHIFT ','2023-01-17','2023-01-17 14:03:29','2023-01-18 14:03:29','601',954782.20,954782.20,'601','2023-01-18 10:33:36','600','2023-01-18 10:34:29',10,0),('5','172',257973,'DAILY SHIFT ','2023-01-18','2023-01-18 11:30:56','2023-01-19 11:30:56','601',987600.40,987600.40,'601','2023-01-19 07:50:24','600','2023-01-19 08:28:22',10,0),('5','172',257974,'DAILY SHIFT ','2023-01-19','2023-01-19 10:47:39','2023-01-20 10:47:39','601',2257500.40,2257500.40,'601','2023-01-20 08:04:29','600','2023-01-20 08:32:42',10,0),('5','172',257975,'DAILY SHIFT ','2023-01-20','2023-01-20 09:12:07','2023-01-21 09:12:07','601',1805623.50,1805623.50,'601','2023-01-21 07:47:43','600','2023-01-21 10:08:05',10,0),('5','172',257976,'DAILY SHIFT ','2023-01-21','2023-01-21 11:27:53','2023-01-22 11:27:53','601',1121935.90,1121935.90,'601','2023-01-22 08:08:37','600','2023-01-22 09:35:19',10,0),('5','172',257977,'DAILY SHIFT ','2023-01-22','2023-01-23 07:40:39','2023-01-24 07:40:39','601',854875.10,854875.10,'601','2023-01-23 07:41:28','600','2023-01-23 08:18:29',10,0),('5','172',257978,'DAILY SHIFT ','2023-01-23','2023-01-23 09:49:46','2023-01-24 09:49:46','601',869607.60,869607.60,'601','2023-01-24 07:24:28','600','2023-01-24 08:28:15',10,0),('5','172',257979,'DAILY SHIFT ','2023-01-24','2023-01-24 09:13:31','2023-01-25 09:13:31','601',1060731.70,1060731.70,'601','2023-01-25 07:27:18','600','2023-01-25 09:19:14',10,0),('5','172',257980,'DAILY SHIFT ','2023-01-25','2023-01-25 10:44:47','2023-01-26 10:44:47','601',865009.40,865009.40,'601','2023-01-26 07:30:25','600','2023-01-26 09:01:09',10,0),('5','172',257981,'DAILY SHIFT ','2023-01-26','2023-01-26 10:55:23','2023-01-27 10:55:23','601',2522826.50,2522826.50,'601','2023-01-27 07:35:42','600','2023-01-27 13:42:32',10,0),('5','172',257982,'DAILY SHIFT ','2023-01-27','2023-01-28 08:00:26','2023-01-29 08:00:26','601',1545584.50,1545584.50,'601','2023-01-28 08:00:54','600','2023-01-28 12:01:57',10,0),('5','172',257983,'DAILY SHIFT ','2023-01-28','2023-01-29 07:07:56','2023-01-30 07:07:56','601',2496830.90,2496830.90,'601','2023-01-29 14:41:10','600','2023-01-29 14:50:51',10,0),('5','172',257984,'DAILY SHIFT ','2023-01-29','2023-01-30 08:29:31','2023-01-31 08:29:31','601',3007704.20,3007704.20,'601','2023-01-30 08:30:09','600','2023-01-30 09:02:48',10,0),('5','172',257985,'DAILY SHIFT ','2023-01-30','2023-01-30 12:37:14','2023-01-31 12:37:14','601',1021315.00,1021315.00,'601','2023-01-31 07:27:02','600','2023-01-31 10:16:05',10,0),('5','172',257986,'DAILY SHIFT ','2023-01-31','2023-01-31 14:01:00','2023-02-01 14:01:00','601',1205865.50,1205865.50,'601','2023-02-01 08:34:03','600','2023-02-01 10:19:30',10,0),('5','172',257987,'DAILY SHIFT ','2023-02-01','2023-02-01 11:53:51','2023-02-02 11:53:51','601',1788127.10,1788127.10,'601','2023-02-02 12:27:56','600','2023-02-02 12:30:17',10,0),('5','172',257988,'DAILY SHIFT ','2023-02-02','2023-02-03 07:18:03','2023-02-04 07:18:03','601',1336798.00,1336798.00,'601','2023-02-03 07:18:43','600','2023-02-03 09:16:27',10,0),('5','172',257989,'DAIL SHIFT ','2023-02-03','2023-02-03 15:09:28','2023-02-04 15:09:28','601',1087789.70,1087789.70,'601','2023-02-04 21:26:35','600','2023-02-05 15:09:37',10,0),('5','172',257990,'DAILY SHIFT ','2023-02-04','2023-02-06 13:32:08','2023-02-07 13:32:08','601',0.00,0.00,'601','2023-02-06 13:32:28','600','2023-02-06 14:17:48',10,0),('5','172',257991,'DAILY SHIFT ','2023-02-05','2023-02-06 16:26:25','2023-02-07 16:26:25','601',0.00,0.00,'601','2023-02-06 16:26:50','600','2023-02-08 09:10:34',10,0),('5','172',257992,'DAILY SHIFT ','2023-02-06','2023-02-10 12:50:37','2023-02-11 12:50:37','601',0.00,0.00,'601','2023-02-10 12:50:58','600','2023-02-11 14:00:48',10,0),('5','172',257993,'DAILY SHIFT ','2023-02-07','2023-02-11 21:54:40','2023-02-12 21:54:40','601',0.00,0.00,'601','2023-02-11 21:55:55','600','2023-02-12 14:17:02',10,0),('5','172',257994,'DAILY SHIFT ','2023-02-08','2023-02-13 06:59:43','2023-02-14 06:59:43','601',0.00,0.00,'601','2023-02-13 07:00:06','600','2023-02-13 09:06:46',10,0),('5','172',257995,'DAILY SHIFT ','2023-02-09','2023-02-14 11:14:14','2023-02-15 11:14:14','601',0.00,0.00,'601','2023-02-14 11:14:32','600','2023-02-15 09:00:09',10,0),('5','172',257996,'DAILY SHIFT ','2023-02-10','2023-02-16 12:13:15','2023-02-17 12:13:15','601',0.00,0.00,'601','2023-02-16 12:13:36','600','2023-02-16 12:16:27',10,0),('5','172',257997,'DAILY SHIFT ','2023-02-15','2023-02-16 12:31:11','2023-02-17 12:31:11','601',0.00,0.00,'601','2023-02-16 12:31:36','600','2023-02-16 12:39:43',10,0),('5','172',257998,'DAILY ','2023-02-16','2023-02-16 20:36:47','2023-02-17 20:36:47','601',0.00,0.00,'601','2023-02-16 20:37:21','600','2023-02-17 10:31:48',10,0),('5','172',257999,'DAILY SHIFT ','2023-02-17','2023-02-17 21:21:38','2023-02-18 21:21:38','601',0.00,0.00,'601','2023-02-17 21:22:21','600','2023-02-18 21:25:33',10,0),('5','172',258000,'DAILY SHIFT ','2023-02-18','2023-02-18 22:37:30','2023-02-19 22:37:30','601',0.00,0.00,'601','2023-02-18 22:38:05','600','2023-02-21 11:34:00',10,0),('5','172',258001,'DAILY SHIFT ','2023-03-01','2023-03-01 14:37:43','2023-03-02 14:37:43','601',0.00,0.00,'601','2023-03-02 07:37:42','600','2023-03-02 09:15:14',10,0),('5','172',258002,'DAILY SHIFT ','2023-03-02','2023-03-03 08:00:57','2023-03-04 08:00:57','601',1294965.00,1294965.00,'601','2023-03-03 09:36:53','600','2023-03-04 13:40:56',10,0),('5','172',258003,'DAILY SHIFT ','2023-03-03','2023-03-05 08:36:45','2023-03-06 08:36:45','601',2145996.30,2145996.30,'601','2023-03-05 08:38:55','600','2023-03-05 11:23:59',10,0),('5','172',258004,'DAILY SHIFT ','2023-03-04','2023-03-05 23:30:40','2023-03-06 23:30:40','601',4097965.80,4097965.80,'601','2023-03-07 15:22:40','600','2023-03-07 15:24:20',10,0),('5','172',258005,'DAILY SHIFT ','2023-03-05','2023-03-07 15:25:33','2023-03-08 15:25:33','601',3799713.60,3799713.60,'601','2023-03-07 15:26:34','600','2023-03-07 15:29:40',10,0),('5','172',258006,'DAILY SHIFT ','2023-03-06','2023-03-07 15:51:14','2023-03-08 15:51:14','601',5355441.00,5355441.00,'601','2023-03-07 15:52:18','600','2023-03-07 15:53:05',10,0),('5','172',258007,'DAILY SHIFT ','2023-03-07','2023-03-07 16:17:45','2023-03-08 16:17:45','601',4111220.70,4111220.70,'601','2023-03-08 10:15:04','600','2023-03-08 10:49:55',10,0),('5','172',258008,'DAILY SHIFT ','2023-03-08','2023-03-09 07:31:04','2023-03-10 07:31:04','601',5469028.20,5469028.20,'601','2023-03-09 09:34:59','600','2023-03-09 09:48:16',10,0),('5','172',258009,'DAILY SHIFT ','2023-03-09','2023-03-10 07:45:02','2023-03-11 07:45:02','601',1978056.60,1978056.60,'601','2023-03-10 07:45:43','600','2023-03-10 09:21:35',10,0),('5','172',258010,'DAILY SHIFT ','2023-03-10','2023-03-10 10:11:16','2023-03-11 10:11:16','601',2931271.20,2931271.20,'601','2023-03-11 07:20:43','600','2023-03-11 22:54:18',10,0),('5','172',258011,'DAILY SHIFT ','2023-03-11','2023-03-12 07:54:02','2023-03-13 07:54:02','601',1288957.80,1288957.80,'601','2023-03-12 07:55:21','600','2023-03-12 09:21:40',10,0),('5','172',258012,'DAILY SHIFT ','2023-03-12','2023-03-13 08:18:14','2023-03-14 08:18:14','601',1807205.40,1807205.40,'601','2023-03-13 08:18:50','600','2023-03-13 08:21:12',10,0),('5','172',258013,'DAIL SHIFT ','2023-03-13','2023-03-13 10:59:58','2023-03-14 10:59:58','601',1884214.80,1884214.80,'601','2023-03-14 10:45:13','600','2023-03-14 11:27:35',10,0),('5','172',258014,'DAILY SHIFT ','2023-03-14','2023-03-15 10:30:30','2023-03-16 10:30:30','601',1610021.40,1610021.40,'601','2023-03-15 10:31:00','600','2023-03-15 11:46:21',10,0),('5','172',258015,'DAILY SHIFT ','2023-03-15','2023-03-16 11:42:55','2023-03-17 11:42:55','601',1935358.50,1935358.50,'601','2023-03-16 11:59:38','600','2023-03-16 13:35:07',10,0),('5','172',258016,'DAILY SHIFT ','2023-03-16','2023-03-17 10:42:07','2023-03-18 10:42:07','601',2912992.50,2912992.50,'601','2023-03-17 10:43:15','600','2023-03-17 12:01:31',10,0),('5','172',258017,'DAILY SHIFT ','2023-03-17','2023-03-18 08:27:23','2023-03-19 08:27:23','601',3849763.80,3849763.80,'601','2023-03-18 08:28:49','600','2023-03-18 10:12:38',10,0),('5','172',258018,'DAILY SHIFT ','2023-03-18','2023-03-19 15:08:40','2023-03-20 15:08:40','601',0.00,0.00,'601','2023-03-19 15:09:02','600','2023-03-20 08:40:57',10,0),('5','172',258019,'DAILY SHIFT ','2023-03-19','2023-03-20 10:22:54','2023-03-21 10:22:54','601',5411149.80,5411149.80,'601','2023-03-20 10:24:04','600','2023-03-20 10:44:14',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4910265 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','172','911','181808',3569908,'2694','405',178144.05,178144.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','181808',3569909,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','181808',3569910,'2696','405',48249.30,48249.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','181808',3569911,'2697','405',175708.36,175708.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','181808',3569912,'2698','405',105864.59,105864.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','181808',3569913,'2699','405',70117.62,70117.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','181808',3569914,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','181808',3569915,'2701','405',154913.00,154913.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','181808',3569916,'2702','406',515551.00,515551.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','181808',3569917,'2703','406',403291.93,403291.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','181808',3569918,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182222',3577481,'2694','405',178144.05,180809.49,2665.44,434466.72,0.00,0.00,0.00,0.00,0.00),('5','172','911','182222',3577482,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182222',3577483,'2696','405',48249.30,48249.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182222',3577484,'2697','405',175708.36,179801.40,4093.04,667165.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','182222',3577485,'2698','405',105864.59,106792.66,928.07,151275.41,0.00,0.00,0.00,0.00,0.00),('5','172','912','182222',3577486,'2699','405',70117.62,70881.33,763.71,124484.73,0.00,0.00,0.00,0.00,0.00),('5','172','912','182222',3577487,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','182222',3577488,'2701','405',154913.00,154913.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','182222',3577489,'2702','406',515551.00,515551.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','182222',3577490,'2703','406',404291.93,406333.65,2041.72,510430.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','182222',3577491,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182240',3577818,'2694','405',180809.49,180809.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182240',3577819,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','182240',3577820,'2696','405',48249.30,49696.60,1447.30,235909.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','182240',3577821,'2697','405',179801.40,180777.35,975.95,159079.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','182240',3577822,'2698','405',106792.66,108564.74,1772.08,288849.04,0.00,0.00,0.00,0.00,0.00),('5','172','912','182240',3577823,'2699','405',70881.33,73165.18,2283.85,372267.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','182240',3577824,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','182240',3577825,'2701','405',154913.00,157888.36,2975.36,484983.68,0.00,0.00,0.00,0.00,0.00),('5','172','913','182240',3577826,'2702','406',515551.00,515551.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','182240',3577827,'2703','406',406333.65,411290.26,4956.61,1239152.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','182240',3577828,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183162',3594630,'2694','405',180809.49,185724.13,4914.64,801086.32,0.00,0.00,0.00,0.00,0.00),('5','172','911','183162',3594631,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183162',3594632,'2696','405',49696.60,50982.02,1285.42,209523.46,0.00,0.00,0.00,0.00,0.00),('5','172','911','183162',3594633,'2697','405',180777.35,181489.98,712.63,116158.69,0.00,0.00,0.00,0.00,0.00),('5','172','912','183162',3594634,'2698','405',108564.74,110113.78,1549.04,252493.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','183162',3594635,'2699','405',73165.18,74070.51,905.33,147568.79,0.00,0.00,0.00,0.00,0.00),('5','172','912','183162',3594636,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183162',3594637,'2701','405',157888.36,157888.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','183162',3594638,'2702','406',515551.00,516144.11,593.11,148277.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','183162',3594639,'2703','406',411290.26,416146.72,4856.46,1214115.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','183162',3594640,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183379',3598631,'2694','405',185724.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183379',3598632,'2695','405',3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183379',3598633,'2696','405',50982.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183379',3598634,'2697','405',181489.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183379',3598635,'2698','405',110113.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183379',3598636,'2699','405',74070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183379',3598637,'2700','405',4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183379',3598638,'2701','405',157888.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','183379',3598639,'2702','406',516144.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','183379',3598640,'2703','406',416146.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','183379',3598641,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183581',3602153,'2694','405',185724.13,185724.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183581',3602154,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183581',3602155,'2696','405',50982.02,53785.13,2803.11,456906.93,0.00,0.00,0.00,0.00,0.00),('5','172','911','183581',3602156,'2697','405',181489.98,181489.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183581',3602157,'2698','405',110113.78,112172.62,2058.84,335590.92,0.00,0.00,0.00,0.00,0.00),('5','172','912','183581',3602158,'2699','405',74070.51,75685.17,1614.66,263189.58,0.00,0.00,0.00,0.00,0.00),('5','172','912','183581',3602159,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183581',3602160,'2701','405',157888.36,159873.09,1984.73,323510.99,0.00,0.00,0.00,0.00,0.00),('5','172','913','183581',3602161,'2702','406',516144.11,519120.71,2976.60,744150.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','183581',3602162,'2703','406',416146.72,419670.70,3523.98,880995.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','183581',3602163,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183585',3602241,'2694','405',185724.13,185724.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183585',3602242,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183585',3602243,'2696','405',53785.13,53785.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183585',3602244,'2697','405',181489.98,184393.82,2903.84,473325.92,0.00,0.00,0.00,0.00,0.00),('5','172','912','183585',3602245,'2698','405',112172.62,112485.85,313.23,51056.49,0.00,0.00,0.00,0.00,0.00),('5','172','912','183585',3602246,'2699','405',75685.17,78953.91,3268.74,532804.62,0.00,0.00,0.00,0.00,0.00),('5','172','912','183585',3602247,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183585',3602248,'2701','405',159873.09,163221.73,3348.64,545828.32,0.00,0.00,0.00,0.00,0.00),('5','172','913','183585',3602249,'2702','406',519120.71,525311.73,6191.02,1547755.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','183585',3602250,'2703','406',419670.70,422805.12,3134.42,783605.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','183585',3602251,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183932',3608567,'2694','405',185724.13,185724.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183932',3608568,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183932',3608569,'2696','405',53785.13,53785.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','183932',3608570,'2697','405',184393.82,186308.30,1914.48,312060.24,0.00,0.00,0.00,0.00,0.00),('5','172','912','183932',3608571,'2698','405',112485.85,112485.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183932',3608572,'2699','405',78953.91,83403.15,4449.24,725226.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','183932',3608573,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','183932',3608574,'2701','405',163221.73,165582.39,2360.66,384787.58,0.00,0.00,0.00,0.00,0.00),('5','172','913','183932',3608575,'2702','406',525311.73,525653.55,341.82,85455.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','183932',3608576,'2703','406',422805.12,429826.15,7021.03,1755257.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','183932',3608577,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','184015',3610063,'2694','405',185724.13,188578.29,2854.16,465228.08,0.00,0.00,0.00,0.00,0.00),('5','172','911','184015',3610064,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','184015',3610065,'2696','405',53785.13,55041.23,1256.10,204744.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','184015',3610066,'2697','405',186308.30,187260.04,951.74,155133.62,0.00,0.00,0.00,0.00,0.00),('5','172','912','184015',3610067,'2698','405',112485.85,113465.70,979.85,159715.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','184015',3610068,'2699','405',83403.15,83444.32,41.17,6710.71,0.00,0.00,0.00,0.00,0.00),('5','172','912','184015',3610069,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','184015',3610070,'2701','405',165582.39,170518.99,4936.60,804665.80,0.00,0.00,0.00,0.00,0.00),('5','172','913','184015',3610071,'2702','406',525653.55,533694.80,8041.25,2010312.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','184015',3610072,'2703','406',429826.15,430294.17,468.02,117005.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','184015',3610073,'2704','407',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185398',3634519,'2694','405',188578.29,190375.71,1797.42,292979.46,0.00,0.00,0.00,0.00,0.00),('5','172','911','185398',3634520,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185398',3634521,'2696','405',55041.23,56272.58,1231.35,200710.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','185398',3634522,'2697','405',187260.04,187419.80,159.76,26040.88,0.00,0.00,0.00,0.00,0.00),('5','172','912','185398',3634523,'2698','405',113465.70,117116.86,3651.16,595139.08,0.00,0.00,0.00,0.00,0.00),('5','172','912','185398',3634524,'2699','405',83444.32,86223.17,2778.85,452952.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','185398',3634525,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185398',3634526,'2701','405',170518.99,173591.33,3072.34,500791.42,0.00,0.00,0.00,0.00,0.00),('5','172','913','185398',3634527,'2702','406',533694.80,533864.80,170.00,43350.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','185398',3634528,'2703','406',430294.17,430294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','185398',3634529,'2704','407',0.00,436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185582',3637887,'2694','405',190375.71,196255.59,5879.88,958420.44,0.00,0.00,0.00,0.00,0.00),('5','172','911','185582',3637888,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185582',3637889,'2696','405',56272.58,56272.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185582',3637890,'2697','405',187419.80,190294.84,2875.04,468631.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','185582',3637891,'2698','405',117116.86,117263.59,146.73,23916.99,0.00,0.00,0.00,0.00,0.00),('5','172','912','185582',3637892,'2699','405',86223.17,89264.82,3041.65,495788.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','185582',3637893,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185582',3637894,'2701','405',173591.33,175984.20,2392.87,390037.81,0.00,0.00,0.00,0.00,0.00),('5','172','913','185582',3637895,'2702','406',533864.80,533864.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','185582',3637896,'2703','406',430294.17,442903.00,12608.83,3215251.65,0.00,0.00,0.00,0.00,0.00),('5','172','915','185582',3637897,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185649',3639183,'2694','405',196255.59,197433.95,1178.36,192072.68,0.00,0.00,0.00,0.00,0.00),('5','172','911','185649',3639184,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185649',3639185,'2696','405',56272.58,56272.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185649',3639186,'2697','405',190294.84,192123.03,1828.19,297994.97,0.00,0.00,0.00,0.00,0.00),('5','172','912','185649',3639187,'2698','405',117263.59,117267.56,3.97,647.11,0.00,0.00,0.00,0.00,0.00),('5','172','912','185649',3639188,'2699','405',89264.82,94957.90,5693.08,927972.04,0.00,0.00,0.00,0.00,0.00),('5','172','912','185649',3639189,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185649',3639190,'2701','405',175984.20,178469.81,2485.61,405154.43,0.00,0.00,0.00,0.00,0.00),('5','172','913','185649',3639191,'2702','406',533864.80,541580.58,7715.78,1967523.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','185649',3639192,'2703','406',442903.00,445135.34,2232.34,569246.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','185649',3639193,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185650',3639194,'2694','405',197433.95,197433.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185650',3639195,'2695','405',3749.36,3749.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185650',3639196,'2696','405',56272.58,56519.75,247.17,40288.71,0.00,0.00,0.00,0.00,0.00),('5','172','911','185650',3639197,'2697','405',192123.03,193799.20,1676.17,273215.71,0.00,0.00,0.00,0.00,0.00),('5','172','912','185650',3639198,'2698','405',117267.56,117267.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185650',3639199,'2699','405',94957.90,96557.14,1599.24,260676.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','185650',3639200,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185650',3639201,'2701','405',178469.81,180333.04,1863.23,303706.49,0.00,0.00,0.00,0.00,0.00),('5','172','913','185650',3639202,'2702','406',541580.58,544677.20,3096.62,789638.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','185650',3639203,'2703','406',445135.34,448153.97,3018.63,769750.65,0.00,0.00,0.00,0.00,0.00),('5','172','915','185650',3639204,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185651',3639205,'2694','405',197433.95,197433.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185651',3639206,'2695','405',3749.36,3749.46,0.10,16.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','185651',3639207,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185651',3639208,'2697','405',193799.20,193799.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185651',3639209,'2698','405',117267.56,123628.79,6361.23,1036880.49,0.00,0.00,0.00,0.00,0.00),('5','172','912','185651',3639210,'2699','405',96557.14,96557.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185651',3639211,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185651',3639212,'2701','405',180333.04,186451.11,6118.07,997245.41,0.00,0.00,0.00,0.00,0.00),('5','172','913','185651',3639213,'2702','406',544677.20,547245.59,2568.39,654939.45,0.00,0.00,0.00,0.00,0.00),('5','172','914','185651',3639214,'2703','406',448153.97,452899.71,4745.74,1210163.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','185651',3639215,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185652',3639216,'2694','405',197433.95,197433.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185652',3639217,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185652',3639218,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185652',3639219,'2697','405',193799.20,193799.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185652',3639220,'2698','405',123628.79,126166.28,2537.49,413610.87,0.00,0.00,0.00,0.00,0.00),('5','172','912','185652',3639221,'2699','405',96557.14,100649.04,4091.90,666979.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','185652',3639222,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185652',3639223,'2701','405',186451.11,194331.12,7880.01,1284441.63,0.00,0.00,0.00,0.00,0.00),('5','172','913','185652',3639224,'2702','406',547245.59,550894.48,3648.89,930466.95,0.00,0.00,0.00,0.00,0.00),('5','172','914','185652',3639225,'2703','406',452899.71,456401.12,3501.41,892859.55,0.00,0.00,0.00,0.00,0.00),('5','172','915','185652',3639226,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185653',3639227,'2694','405',197433.95,197433.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185653',3639228,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185653',3639229,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185653',3639230,'2697','405',193799.20,193799.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185653',3639231,'2698','405',126166.28,127712.17,1545.89,251980.07,0.00,0.00,0.00,0.00,0.00),('5','172','912','185653',3639232,'2699','405',100649.04,104858.22,4209.18,686096.34,0.00,0.00,0.00,0.00,0.00),('5','172','912','185653',3639233,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185653',3639234,'2701','405',194331.12,199357.57,5026.45,819311.35,0.00,0.00,0.00,0.00,0.00),('5','172','913','185653',3639235,'2702','406',550894.48,555151.14,4256.66,1085448.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','185653',3639236,'2703','406',456401.12,463083.65,6682.53,1704045.15,0.00,0.00,0.00,0.00,0.00),('5','172','915','185653',3639237,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185655',3639264,'2694','405',197433.95,199408.65,1974.70,321876.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','185655',3639265,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185655',3639266,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185655',3639267,'2697','405',193799.20,197881.86,4082.66,665473.58,0.00,0.00,0.00,0.00,0.00),('5','172','912','185655',3639268,'2698','405',127712.17,129400.46,1688.29,275191.27,0.00,0.00,0.00,0.00,0.00),('5','172','912','185655',3639269,'2699','405',104858.22,104858.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185655',3639270,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185655',3639271,'2701','405',199357.57,199357.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','185655',3639272,'2702','406',555151.14,560983.72,5832.58,1487307.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','185655',3639273,'2703','406',463083.65,468537.36,5453.71,1390696.05,0.00,0.00,0.00,0.00,0.00),('5','172','915','185655',3639274,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185656',3639275,'2694','405',199408.65,200233.21,824.56,134403.28,0.00,0.00,0.00,0.00,0.00),('5','172','911','185656',3639276,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185656',3639277,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185656',3639278,'2697','405',197881.86,201266.43,3384.57,551684.91,0.00,0.00,0.00,0.00,0.00),('5','172','912','185656',3639279,'2698','405',129400.46,133053.51,3653.05,595447.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','185656',3639280,'2699','405',104858.22,110100.99,5242.77,854571.51,0.00,0.00,0.00,0.00,0.00),('5','172','912','185656',3639281,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185656',3639282,'2701','405',199357.57,202816.06,3458.49,563733.87,0.00,0.00,0.00,0.00,0.00),('5','172','913','185656',3639283,'2702','406',560983.72,568574.80,7591.08,1935725.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','185656',3639284,'2703','406',468537.36,468537.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','185656',3639285,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185657',3639286,'2694','405',200233.21,201594.08,1360.87,221821.81,0.00,0.00,0.00,0.00,0.00),('5','172','911','185657',3639287,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185657',3639288,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185657',3639289,'2697','405',201266.43,201266.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185657',3639290,'2698','405',133053.51,138562.02,5508.51,897887.13,0.00,0.00,0.00,0.00,0.00),('5','172','912','185657',3639291,'2699','405',110100.99,112129.64,2028.65,330669.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','185657',3639292,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185657',3639293,'2701','405',202816.06,207734.13,4918.07,801645.41,0.00,0.00,0.00,0.00,0.00),('5','172','913','185657',3639294,'2702','406',568574.80,589230.03,20655.23,5267083.65,0.00,0.00,0.00,0.00,0.00),('5','172','914','185657',3639295,'2703','406',468537.36,469920.63,1383.27,352733.85,0.00,0.00,0.00,0.00,0.00),('5','172','915','185657',3639296,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185658',3639297,'2694','405',201594.08,201594.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185658',3639298,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185658',3639299,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185658',3639300,'2697','405',201266.43,204876.99,3610.56,588521.28,0.00,0.00,0.00,0.00,0.00),('5','172','912','185658',3639301,'2698','405',138562.02,141034.74,2472.72,403053.36,0.00,0.00,0.00,0.00,0.00),('5','172','912','185658',3639302,'2699','405',112129.64,112129.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185658',3639303,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185658',3639304,'2701','405',207734.13,210202.85,2468.72,402401.36,0.00,0.00,0.00,0.00,0.00),('5','172','913','185658',3639305,'2702','406',589230.03,590478.70,1248.67,318410.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','185658',3639306,'2703','406',469920.63,472474.00,2553.37,651109.35,0.00,0.00,0.00,0.00,0.00),('5','172','915','185658',3639307,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185659',3639308,'2694','405',201594.08,201594.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185659',3639309,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185659',3639310,'2696','405',56519.75,56519.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','185659',3639311,'2697','405',204876.99,204876.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185659',3639312,'2698','405',141034.74,146497.03,5462.29,890353.27,0.00,0.00,0.00,0.00,0.00),('5','172','912','185659',3639313,'2699','405',112129.64,112129.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185659',3639314,'2700','405',4857.72,4857.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','185659',3639315,'2701','405',210202.85,214868.15,4665.30,760443.90,0.00,0.00,0.00,0.00,0.00),('5','172','913','185659',3639316,'2702','406',590478.70,597265.46,6786.76,1764557.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','185659',3639317,'2703','406',472474.00,472602.25,128.25,33345.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','185659',3639318,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186113',3647306,'2694','405',201594.08,201594.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186113',3647307,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186113',3647308,'2696','405',56519.75,59445.96,2926.21,476972.23,0.00,0.00,0.00,0.00,0.00),('5','172','911','186113',3647309,'2697','405',204876.99,204927.26,50.27,8194.01,0.00,0.00,0.00,0.00,0.00),('5','172','912','186113',3647310,'2698','405',146497.03,149885.07,3388.04,552250.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','186113',3647311,'2699','405',112129.64,117743.96,5614.32,915134.16,0.00,0.00,0.00,0.00,0.00),('5','172','912','186113',3647312,'2700','405',4857.72,4858.64,0.92,149.96,0.00,0.00,0.00,0.00,0.00),('5','172','912','186113',3647313,'2701','405',214868.15,220321.57,5453.42,888907.46,0.00,0.00,0.00,0.00,0.00),('5','172','913','186113',3647314,'2702','406',597265.46,606450.62,9185.16,2388141.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','186113',3647315,'2703','406',472602.25,475050.11,2447.86,636443.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','186113',3647316,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186957',3661662,'2694','405',201594.08,201594.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186957',3661663,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','186957',3661664,'2696','405',59445.96,62673.50,3227.54,526089.02,0.00,0.00,0.00,0.00,0.00),('5','172','911','186957',3661665,'2697','405',204927.26,206555.72,1628.46,265438.98,0.00,0.00,0.00,0.00,0.00),('5','172','912','186957',3661666,'2698','405',149885.07,153124.01,3238.94,527947.22,0.00,0.00,0.00,0.00,0.00),('5','172','912','186957',3661667,'2699','405',117743.96,119055.01,1311.05,213701.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','186957',3661668,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','186957',3661669,'2701','405',220321.57,223959.17,3637.60,592928.80,0.00,0.00,0.00,0.00,0.00),('5','172','913','186957',3661670,'2702','406',606450.62,616540.88,10090.26,2623467.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','186957',3661671,'2703','406',475050.11,476843.84,1793.73,466369.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','186957',3661672,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187130',3664620,'2694','405',201594.08,202589.33,995.25,162225.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','187130',3664621,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187130',3664622,'2696','405',62673.50,63022.70,349.20,56919.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','187130',3664623,'2697','405',206555.72,211077.38,4521.66,737030.58,0.00,0.00,0.00,0.00,0.00),('5','172','912','187130',3664624,'2698','405',153124.01,153701.84,577.83,94186.29,0.00,0.00,0.00,0.00,0.00),('5','172','912','187130',3664625,'2699','405',119055.01,124426.52,5371.51,875556.13,0.00,0.00,0.00,0.00,0.00),('5','172','912','187130',3664626,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187130',3664627,'2701','405',223959.17,225457.10,1497.93,244162.59,0.00,0.00,0.00,0.00,0.00),('5','172','913','187130',3664628,'2702','406',616540.88,617646.05,1105.17,281818.35,0.00,0.00,0.00,0.00,0.00),('5','172','914','187130',3664629,'2703','406',476843.84,492595.42,15751.58,4016652.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','187130',3664630,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187133',3664644,'2694','405',202589.33,208225.45,5636.12,918687.56,0.00,0.00,0.00,0.00,0.00),('5','172','911','187133',3664645,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187133',3664646,'2696','405',63022.70,63022.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187133',3664647,'2697','405',211077.38,216329.22,5251.84,856049.92,0.00,0.00,0.00,0.00,0.00),('5','172','912','187133',3664648,'2698','405',153701.84,153701.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187133',3664649,'2699','405',124426.52,128697.50,4270.98,696169.74,0.00,0.00,0.00,0.00,0.00),('5','172','912','187133',3664650,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187133',3664651,'2701','405',225457.10,225457.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','187133',3664652,'2702','406',617646.05,617646.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','187133',3664653,'2703','406',492595.42,492595.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','187133',3664654,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187136',3664688,'2694','405',208225.45,215152.34,6926.89,1129083.07,0.00,0.00,0.00,0.00,0.00),('5','172','911','187136',3664689,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187136',3664690,'2696','405',63022.70,63022.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187136',3664691,'2697','405',216329.22,223600.28,7271.06,1185182.78,0.00,0.00,0.00,0.00,0.00),('5','172','912','187136',3664692,'2698','405',153701.84,155560.34,1858.50,302935.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','187136',3664693,'2699','405',128697.50,128697.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187136',3664694,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187136',3664695,'2701','405',225457.10,227888.32,2431.22,396288.86,0.00,0.00,0.00,0.00,0.00),('5','172','913','187136',3664696,'2702','406',617646.05,617646.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','187136',3664697,'2703','406',492595.42,492595.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','187136',3664698,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187137',3664699,'2694','405',215152.34,218469.14,3316.80,540638.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','187137',3664700,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187137',3664701,'2696','405',63022.70,64921.97,1899.27,309581.01,0.00,0.00,0.00,0.00,0.00),('5','172','911','187137',3664702,'2697','405',223600.28,228675.81,5075.53,827311.39,0.00,0.00,0.00,0.00,0.00),('5','172','912','187137',3664703,'2698','405',155560.34,156996.80,1436.46,234142.98,0.00,0.00,0.00,0.00,0.00),('5','172','912','187137',3664704,'2699','405',128697.50,131460.70,2763.20,450401.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','187137',3664705,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187137',3664706,'2701','405',227888.32,229581.94,1693.62,276060.06,0.00,0.00,0.00,0.00,0.00),('5','172','913','187137',3664707,'2702','406',617646.05,617646.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','187137',3664708,'2703','406',492595.42,492595.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','187137',3664709,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187140',3664759,'2694','405',218469.14,225946.25,7477.11,1218768.93,0.00,0.00,0.00,0.00,0.00),('5','172','911','187140',3664760,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187140',3664761,'2696','405',64921.97,65128.73,206.76,33701.88,0.00,0.00,0.00,0.00,0.00),('5','172','911','187140',3664762,'2697','405',228675.81,235431.41,6755.60,1101162.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','187140',3664763,'2698','405',156996.80,157880.12,883.32,143981.16,0.00,0.00,0.00,0.00,0.00),('5','172','912','187140',3664764,'2699','405',131460.70,132271.57,810.87,132171.81,0.00,0.00,0.00,0.00,0.00),('5','172','912','187140',3664765,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187140',3664766,'2701','405',229581.94,229581.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','187140',3664767,'2702','406',617646.05,621396.98,3750.93,975241.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','187140',3664768,'2703','406',492595.42,494605.12,2009.70,522522.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','187140',3664769,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187221',3666044,'2694','405',225946.25,234152.19,8205.94,1337568.22,0.00,0.00,0.00,0.00,0.00),('5','172','911','187221',3666045,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187221',3666046,'2696','405',65128.73,65128.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187221',3666047,'2697','405',235431.41,243435.52,8004.11,1304669.93,0.00,0.00,0.00,0.00,0.00),('5','172','912','187221',3666048,'2698','405',157880.12,157880.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187221',3666049,'2699','405',132271.57,132271.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187221',3666050,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187221',3666051,'2701','405',229581.94,229581.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','187221',3666052,'2702','406',621396.98,628721.94,7324.96,1904489.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','187221',3666053,'2703','406',494605.12,494605.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','187221',3666054,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187233',3666275,'2694','405',234152.19,237803.11,3650.92,595099.96,0.00,0.00,0.00,0.00,0.00),('5','172','911','187233',3666276,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187233',3666277,'2696','405',65128.73,65974.31,845.58,137829.54,0.00,0.00,0.00,0.00,0.00),('5','172','911','187233',3666278,'2697','405',243435.52,243435.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187233',3666279,'2698','405',157880.12,157880.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187233',3666280,'2699','405',132271.57,135492.16,3220.59,524956.17,0.00,0.00,0.00,0.00,0.00),('5','172','912','187233',3666281,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187233',3666282,'2701','405',229581.94,236157.77,6575.83,1071860.29,0.00,0.00,0.00,0.00,0.00),('5','172','913','187233',3666283,'2702','406',628721.94,631345.38,2623.44,682094.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','187233',3666284,'2703','406',494605.12,504779.60,10174.48,2645364.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','187233',3666285,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187238',3666361,'2694','405',237803.11,237803.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187238',3666362,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187238',3666363,'2696','405',65974.31,65974.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187238',3666364,'2697','405',243435.52,243435.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187238',3666365,'2698','405',157880.12,159824.34,1944.22,316907.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','187238',3666366,'2699','405',135492.16,142130.97,6638.81,1082126.03,0.00,0.00,0.00,0.00,0.00),('5','172','912','187238',3666367,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187238',3666368,'2701','405',236157.77,243174.24,7016.47,1143684.61,0.00,0.00,0.00,0.00,0.00),('5','172','913','187238',3666369,'2702','406',631345.38,636989.85,5644.47,1467562.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','187238',3666370,'2703','406',504779.60,507673.87,2894.27,752510.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','187238',3666371,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187373',3668800,'2694','405',237803.11,240820.46,3017.35,491828.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','187373',3668801,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187373',3668802,'2696','405',65974.31,67271.26,1296.95,211402.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','187373',3668803,'2697','405',243435.52,246055.81,2620.29,427107.27,0.00,0.00,0.00,0.00,0.00),('5','172','912','187373',3668804,'2698','405',159824.34,162764.27,2939.93,479208.59,0.00,0.00,0.00,0.00,0.00),('5','172','912','187373',3668805,'2699','405',142130.97,142999.17,868.20,141516.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','187373',3668806,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187373',3668807,'2701','405',243174.24,247582.86,4408.62,718605.06,0.00,0.00,0.00,0.00,0.00),('5','172','913','187373',3668808,'2702','406',636989.85,638405.64,1415.79,368105.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','187373',3668809,'2703','406',507673.87,511959.66,4285.79,1114305.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','187373',3668810,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187524',3671650,'2694','405',240820.46,244775.19,3954.73,644620.99,0.00,0.00,0.00,0.00,0.00),('5','172','911','187524',3671651,'2695','405',3749.46,3749.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187524',3671652,'2696','405',67271.26,67271.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187524',3671653,'2697','405',246055.81,250020.20,3964.39,646195.57,0.00,0.00,0.00,0.00,0.00),('5','172','912','187524',3671654,'2698','405',162764.27,169039.18,6274.91,1022810.33,0.00,0.00,0.00,0.00,0.00),('5','172','912','187524',3671655,'2699','405',142999.17,143284.87,285.70,46569.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','187524',3671656,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187524',3671657,'2701','405',247582.86,252967.81,5384.95,877746.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','187524',3671658,'2702','406',638405.64,642899.81,4494.17,1168484.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','187524',3671659,'2703','406',511959.66,515227.80,3268.14,849716.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','187524',3671660,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187630',3673322,'2694','405',244775.19,247541.13,2765.94,450848.22,0.00,0.00,0.00,0.00,0.00),('5','172','911','187630',3673323,'2695','405',3749.46,3749.69,0.23,37.49,0.00,0.00,0.00,0.00,0.00),('5','172','911','187630',3673324,'2696','405',67271.26,67271.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187630',3673325,'2697','405',250020.20,251455.91,1435.71,234020.73,0.00,0.00,0.00,0.00,0.00),('5','172','912','187630',3673326,'2698','405',169039.18,169458.49,419.31,68347.53,0.00,0.00,0.00,0.00,0.00),('5','172','912','187630',3673327,'2699','405',143284.87,148187.76,4902.89,799171.07,0.00,0.00,0.00,0.00,0.00),('5','172','912','187630',3673328,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187630',3673329,'2701','405',252967.81,259064.66,6096.85,993786.55,0.00,0.00,0.00,0.00,0.00),('5','172','913','187630',3673330,'2702','406',642899.81,644353.78,1453.97,378032.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','187630',3673331,'2703','406',515227.80,523045.01,7817.21,2032474.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','187630',3673332,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187850',3677170,'2694','405',247541.13,247541.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187850',3677171,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187850',3677172,'2696','405',67271.26,67271.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','187850',3677173,'2697','405',251455.91,251455.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187850',3677174,'2698','405',169458.49,172628.56,3170.07,532571.76,0.00,0.00,0.00,0.00,0.00),('5','172','912','187850',3677175,'2699','405',148187.76,151949.08,3761.32,631901.76,0.00,0.00,0.00,0.00,0.00),('5','172','912','187850',3677176,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','187850',3677177,'2701','405',259064.66,266171.94,7107.28,1194023.04,0.00,0.00,0.00,0.00,0.00),('5','172','913','187850',3677178,'2702','406',644353.78,648147.46,3793.68,986356.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','187850',3677179,'2703','406',523045.01,526549.82,3504.81,911250.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','187850',3677180,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188041',3680527,'2694','405',247541.13,251396.31,3855.18,647670.24,0.00,0.00,0.00,0.00,0.00),('5','172','911','188041',3680528,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188041',3680529,'2696','405',67271.26,71459.19,4187.93,703572.24,0.00,0.00,0.00,0.00,0.00),('5','172','911','188041',3680530,'2697','405',251455.91,251512.10,56.19,9439.92,0.00,0.00,0.00,0.00,0.00),('5','172','912','188041',3680531,'2698','405',172628.56,176929.98,4301.42,722638.56,0.00,0.00,0.00,0.00,0.00),('5','172','912','188041',3680532,'2699','405',151949.08,151967.11,18.03,3029.04,0.00,0.00,0.00,0.00,0.00),('5','172','912','188041',3680533,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188041',3680534,'2701','405',266171.94,269527.57,3355.63,563745.84,0.00,0.00,0.00,0.00,0.00),('5','172','913','188041',3680535,'2702','406',648147.46,650392.16,2244.70,583622.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','188041',3680536,'2703','406',526549.82,532199.71,5649.89,1468971.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','188041',3680537,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188236',3683927,'2694','405',251396.31,251961.52,565.21,94955.28,0.00,0.00,0.00,0.00,0.00),('5','172','911','188236',3683928,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188236',3683929,'2696','405',71459.19,75381.68,3922.49,658978.32,0.00,0.00,0.00,0.00,0.00),('5','172','911','188236',3683930,'2697','405',251512.10,251589.65,77.55,13028.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','188236',3683931,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188236',3683932,'2699','405',151967.11,157136.42,5169.31,868444.08,0.00,0.00,0.00,0.00,0.00),('5','172','912','188236',3683933,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188236',3683934,'2701','405',269527.57,272375.59,2848.02,478467.36,0.00,0.00,0.00,0.00,0.00),('5','172','913','188236',3683935,'2702','406',650392.16,659056.10,8663.94,2252624.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','188236',3683936,'2703','406',532199.71,535444.44,3244.73,843629.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','188236',3683937,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188428',3687264,'2694','405',251961.52,259254.84,7293.32,1225277.76,0.00,0.00,0.00,0.00,0.00),('5','172','911','188428',3687265,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188428',3687266,'2696','405',75381.68,80002.46,4620.78,776291.04,0.00,0.00,0.00,0.00,0.00),('5','172','911','188428',3687267,'2697','405',251589.65,251589.74,0.09,15.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','188428',3687268,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188428',3687269,'2699','405',157136.42,157136.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188428',3687270,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188428',3687271,'2701','405',272375.59,273699.41,1323.82,222401.76,0.00,0.00,0.00,0.00,0.00),('5','172','913','188428',3687272,'2702','406',659056.10,664347.75,5291.65,1375829.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','188428',3687273,'2703','406',535444.44,538217.78,2773.34,721068.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','188428',3687274,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188624',3690668,'2694','405',259254.84,259763.31,508.47,85422.96,0.00,0.00,0.00,0.00,0.00),('5','172','911','188624',3690669,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188624',3690670,'2696','405',80002.46,80427.66,425.20,71433.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','188624',3690671,'2697','405',251589.74,251589.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188624',3690672,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188624',3690673,'2699','405',157136.42,157136.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188624',3690674,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188624',3690675,'2701','405',273699.41,273699.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','188624',3690676,'2702','406',664347.75,670542.33,6194.58,1610590.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','188624',3690677,'2703','406',538217.78,539898.88,1681.10,437086.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','188624',3690678,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188866',3694902,'2694','405',259763.31,259763.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188866',3694903,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188866',3694904,'2696','405',80427.66,80427.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','188866',3694905,'2697','405',251589.74,251589.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188866',3694906,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188866',3694907,'2699','405',157136.42,157136.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188866',3694908,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','188866',3694909,'2701','405',273699.41,273699.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','188866',3694910,'2702','406',670542.33,674056.07,3513.74,913572.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','188866',3694911,'2703','406',539898.88,540598.49,699.61,181898.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','188866',3694912,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189065',3698503,'2694','405',259763.31,259763.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189065',3698504,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189065',3698505,'2696','405',80427.66,80427.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189065',3698506,'2697','405',251589.74,251589.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189065',3698507,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189065',3698508,'2699','405',157136.42,157136.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189065',3698509,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189065',3698510,'2701','405',273699.41,273699.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','189065',3698511,'2702','406',674056.07,679533.57,5477.50,1424150.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','189065',3698512,'2703','406',540598.49,543722.62,3124.13,812273.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','189065',3698513,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189243',3701667,'2694','405',259763.31,259763.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189243',3701668,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189243',3701669,'2696','405',80427.66,80427.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189243',3701670,'2697','405',251589.74,251589.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189243',3701671,'2698','405',176929.98,176929.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189243',3701672,'2699','405',157136.42,157136.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189243',3701673,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189243',3701674,'2701','405',273699.41,273699.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','189243',3701675,'2702','406',679533.57,685327.46,5793.89,1506411.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','189243',3701676,'2703','406',543722.62,547353.66,3631.04,944070.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','189243',3701677,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189659',3709098,'2694','405',259763.31,259763.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189659',3709099,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189659',3709100,'2696','405',80427.66,80427.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189659',3709101,'2697','405',251589.74,251589.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189659',3709102,'2698','405',176929.98,179493.34,2563.36,422954.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','189659',3709103,'2699','405',157136.42,157174.93,38.51,6354.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','189659',3709104,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189659',3709105,'2701','405',273699.41,276724.25,3024.84,499098.60,0.00,0.00,0.00,0.00,0.00),('5','172','913','189659',3709106,'2702','406',685327.46,689622.56,4295.10,1116726.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','189659',3709107,'2703','406',547353.66,553813.76,6460.10,1679626.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','189659',3709108,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189663',3709140,'2694','405',259763.31,262104.80,2341.49,386345.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','189663',3709141,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','189663',3709142,'2696','405',80427.66,81523.96,1096.30,180889.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','189663',3709143,'2697','405',251589.74,251793.69,203.95,33651.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','189663',3709144,'2698','405',179493.34,182606.37,3113.03,513649.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','189663',3709145,'2699','405',157174.93,157174.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189663',3709146,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','189663',3709147,'2701','405',276724.25,280120.84,3396.59,560437.35,0.00,0.00,0.00,0.00,0.00),('5','172','913','189663',3709148,'2702','406',689622.56,690214.95,592.39,154021.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','189663',3709149,'2703','406',553813.76,562385.41,8571.65,2228629.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','189663',3709150,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190492',3724650,'2694','405',262104.80,265134.78,3029.98,499946.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','190492',3724651,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190492',3724652,'2696','405',81523.96,84212.86,2688.90,443668.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','190492',3724653,'2697','405',251793.69,251793.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190492',3724654,'2698','405',182606.37,184896.67,2290.30,377899.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','190492',3724655,'2699','405',157174.93,157499.67,324.74,53582.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','190492',3724656,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190492',3724657,'2701','405',280120.84,282111.04,1990.20,328383.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','190492',3724658,'2702','406',690214.95,693321.96,3107.01,807822.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','190492',3724659,'2703','406',562385.41,564987.23,2601.82,676473.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','190492',3724660,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190639',3727687,'2694','405',265134.78,268825.17,3690.39,608914.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','190639',3727688,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190639',3727689,'2696','405',84212.86,87439.90,3227.04,532461.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','190639',3727690,'2697','405',251793.69,251793.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190639',3727691,'2698','405',184896.67,186999.14,2102.47,346907.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','190639',3727692,'2699','405',157499.67,157959.69,460.02,75903.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','190639',3727693,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190639',3727694,'2701','405',282111.04,285194.46,3083.42,508764.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','190639',3727695,'2702','406',693321.96,695898.29,2576.33,669845.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','190639',3727696,'2703','406',564987.23,569679.99,4692.76,1220117.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','190639',3727697,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190644',3727825,'2694','405',268825.17,268825.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190644',3727826,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190644',3727827,'2696','405',87439.90,87439.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','190644',3727828,'2697','405',251793.69,251793.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190644',3727829,'2698','405',186999.14,191840.96,4841.82,798900.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','190644',3727830,'2699','405',157959.69,159536.14,1576.45,260114.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','190644',3727831,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','190644',3727832,'2701','405',285194.46,291983.21,6788.75,1120143.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','190644',3727833,'2702','406',695898.29,697030.79,1132.50,294450.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','190644',3727834,'2703','406',569679.99,574498.38,4818.39,1252781.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','190644',3727835,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191398',3741077,'2694','405',268825.17,272615.36,3790.19,625381.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','191398',3741078,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191398',3741079,'2696','405',87439.90,91610.98,4171.08,688228.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','191398',3741080,'2697','405',251793.69,251951.45,157.76,26030.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','191398',3741081,'2698','405',191840.96,193153.37,1312.41,216547.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','191398',3741082,'2699','405',159536.14,159561.03,24.89,4106.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','191398',3741083,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191398',3741084,'2701','405',291983.21,294163.83,2180.62,359802.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','191398',3741085,'2702','406',697030.79,699897.11,2866.32,745243.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','191398',3741086,'2703','406',574498.38,577104.07,2605.69,677479.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','191398',3741087,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191401',3741120,'2694','405',272615.36,278345.77,5730.41,945517.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','191401',3741121,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191401',3741122,'2696','405',91610.98,96559.65,4948.67,816530.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','191401',3741123,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191401',3741124,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191401',3741125,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191401',3741126,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191401',3741127,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','191401',3741128,'2702','406',699897.11,704283.07,4385.96,1140349.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','191401',3741129,'2703','406',577104.07,579168.44,2064.37,536736.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','191401',3741130,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191404',3741162,'2694','405',278345.77,282531.73,4185.96,690683.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','191404',3741163,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191404',3741164,'2696','405',96559.65,100725.75,4166.10,687406.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','191404',3741165,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191404',3741166,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191404',3741167,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191404',3741168,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191404',3741169,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','191404',3741170,'2702','406',704283.07,709077.06,4793.99,1246437.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','191404',3741171,'2703','406',579168.44,585011.65,5843.21,1519234.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','191404',3741172,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191411',3741336,'2694','405',282531.73,285768.87,3237.14,534128.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','191411',3741337,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191411',3741338,'2696','405',100725.75,104132.91,3407.16,562181.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','191411',3741339,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191411',3741340,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191411',3741341,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191411',3741342,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191411',3741343,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','191411',3741344,'2702','406',709077.06,712913.24,3836.18,997406.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','191411',3741345,'2703','406',585011.65,590451.94,5440.29,1414475.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','191411',3741346,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191420',3741515,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191420',3741516,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191420',3741517,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','191420',3741518,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191420',3741519,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191420',3741520,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191420',3741521,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','191420',3741522,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','191420',3741523,'2702','406',712913.24,717015.43,4102.19,1066569.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','191420',3741524,'2703','406',590451.94,591410.74,958.80,249288.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','191420',3741525,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192071',3753815,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192071',3753816,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192071',3753817,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192071',3753818,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192071',3753819,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192071',3753820,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192071',3753821,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192071',3753822,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192071',3753823,'2702','406',717015.43,718220.26,1204.83,313255.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','192071',3753824,'2703','406',591410.74,592253.53,842.79,219125.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','192071',3753825,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192221',3756526,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192221',3756527,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192221',3756528,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192221',3756529,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192221',3756530,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192221',3756531,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192221',3756532,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192221',3756533,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192221',3756534,'2702','406',718220.26,729737.23,11516.97,2994412.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','192221',3756535,'2703','406',592253.53,593814.69,1561.16,405901.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','192221',3756536,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192287',3758073,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192287',3758074,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192287',3758075,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192287',3758076,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192287',3758077,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192287',3758078,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192287',3758079,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192287',3758080,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192287',3758081,'2702','406',729737.23,734784.83,5047.60,1312376.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','192287',3758082,'2703','406',593814.69,594466.76,652.07,169538.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','192287',3758083,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192507',3761881,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192507',3761882,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192507',3761883,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192507',3761884,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192507',3761885,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192507',3761886,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192507',3761887,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192507',3761888,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192507',3761889,'2702','406',734784.83,739611.44,4826.61,1254918.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','192507',3761890,'2703','406',594466.76,594466.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','192507',3761891,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192689',3765100,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192689',3765101,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192689',3765102,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192689',3765103,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192689',3765104,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192689',3765105,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192689',3765106,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192689',3765107,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192689',3765108,'2702','406',739611.44,746559.09,6947.65,1806389.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','192689',3765109,'2703','406',594466.76,596139.68,1672.92,434959.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','192689',3765110,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192695',3765183,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192695',3765184,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192695',3765185,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192695',3765186,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192695',3765187,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192695',3765188,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192695',3765189,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192695',3765190,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192695',3765191,'2702','406',746559.09,748957.70,2398.61,6241183.22,0.00,0.00,0.00,0.00,0.00),('5','172','914','192695',3765192,'2703','406',596139.68,600330.62,4190.94,10904825.88,0.00,0.00,0.00,0.00,0.00),('5','172','915','192695',3765193,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192975',3770220,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192975',3770221,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192975',3770222,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','192975',3770223,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192975',3770224,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192975',3770225,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192975',3770226,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','192975',3770227,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','192975',3770228,'2702','406',748957.70,751326.00,2368.30,615758.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','192975',3770229,'2703','406',600330.62,603869.80,3539.18,920186.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','192975',3770230,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193174',3774054,'2694','405',285768.87,285768.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193174',3774055,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193174',3774056,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193174',3774057,'2697','405',251951.45,251951.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193174',3774058,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193174',3774059,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193174',3774060,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193174',3774061,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','193174',3774062,'2702','406',751326.00,751326.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','193174',3774063,'2703','406',603869.80,613032.10,9162.30,2382198.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','193174',3774064,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193216',3774726,'2694','405',285768.87,286924.03,1155.16,190601.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','193216',3774727,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193216',3774728,'2696','405',104132.91,104132.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193216',3774729,'2697','405',251951.45,253493.64,1542.19,254461.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','193216',3774730,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193216',3774731,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193216',3774732,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193216',3774733,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','193216',3774734,'2702','406',751326.00,751326.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','193216',3774735,'2703','406',613032.10,620206.78,7174.68,1865416.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','193216',3774736,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193918',3787837,'2694','405',286924.03,289475.67,2551.64,421020.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','193918',3787838,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193918',3787839,'2696','405',104132.91,105010.82,877.91,144855.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','193918',3787840,'2697','405',253493.64,255012.24,1518.60,250569.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193918',3787841,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193918',3787842,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193918',3787843,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193918',3787844,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','193918',3787845,'2702','406',751326.00,753873.45,2547.45,662337.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','193918',3787846,'2703','406',620206.78,622552.68,2345.90,609934.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','193918',3787847,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193933',3788235,'2694','405',289475.67,291933.22,2457.55,405495.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','193933',3788236,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','193933',3788237,'2696','405',105010.82,107756.71,2745.89,453071.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','193933',3788238,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193933',3788239,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193933',3788240,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193933',3788241,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','193933',3788242,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','193933',3788243,'2702','406',753873.45,754913.54,1040.09,270423.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','193933',3788244,'2703','406',622552.68,627555.40,5002.72,1300707.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','193933',3788245,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195211',3811658,'2694','405',291933.22,295424.89,3491.67,576125.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','195211',3811659,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195211',3811660,'2696','405',107756.71,110907.83,3151.12,519934.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','195211',3811661,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195211',3811662,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195211',3811663,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195211',3811664,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195211',3811665,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','195211',3811666,'2702','406',754913.54,758265.42,3351.88,871488.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','195211',3811667,'2703','406',627555.40,630698.32,3142.92,817159.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','195211',3811668,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195234',3812120,'2694','405',295424.89,298014.98,2590.09,427364.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','195234',3812121,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195234',3812122,'2696','405',110907.83,114272.29,3364.46,555135.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','195234',3812123,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195234',3812124,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195234',3812125,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195234',3812126,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195234',3812127,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','195234',3812128,'2702','406',758265.42,762517.14,4251.72,1105447.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','195234',3812129,'2703','406',630698.32,633138.81,2440.49,634527.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','195234',3812130,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195242',3812261,'2694','405',298014.98,301456.08,3441.10,567781.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','195242',3812262,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195242',3812263,'2696','405',114272.29,118369.38,4097.09,676019.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','195242',3812264,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195242',3812265,'2698','405',193153.37,193153.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195242',3812266,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195242',3812267,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195242',3812268,'2701','405',294163.83,294163.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','195242',3812269,'2702','406',762517.14,769855.61,7338.47,1908002.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','195242',3812270,'2703','406',633138.81,633138.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','195242',3812271,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195382',3814630,'2694','405',301456.08,303911.12,2455.04,405081.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','195382',3814631,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195382',3814632,'2696','405',118369.38,121193.20,2823.82,465930.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','195382',3814633,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195382',3814634,'2698','405',193153.37,194696.11,1542.74,254552.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','195382',3814635,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195382',3814636,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195382',3814637,'2701','405',294163.83,295247.59,1083.76,178820.40,0.00,0.00,0.00,0.00,0.00),('5','172','913','195382',3814638,'2702','406',769855.61,775414.49,5558.88,1445308.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','195382',3814639,'2703','406',633138.81,635127.89,1989.08,517160.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','195382',3814640,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195889',3823407,'2694','405',303911.12,307602.84,3691.72,609133.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','195889',3823408,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195889',3823409,'2696','405',121193.20,125846.10,4652.90,767728.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','195889',3823410,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195889',3823411,'2698','405',194696.11,195057.78,361.67,59675.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','195889',3823412,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195889',3823413,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195889',3823414,'2701','405',295247.59,295595.54,347.95,57411.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','195889',3823415,'2702','406',775414.49,780005.21,4590.72,1193587.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','195889',3823416,'2703','406',635127.89,637508.27,2380.38,618898.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','195889',3823417,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195899',3823581,'2694','405',307602.84,310963.20,3360.36,554459.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','195899',3823582,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','195899',3823583,'2696','405',125846.10,129684.22,3838.12,633289.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','195899',3823584,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195899',3823585,'2698','405',195057.78,195057.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195899',3823586,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195899',3823587,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','195899',3823588,'2701','405',295595.54,295595.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','195899',3823589,'2702','406',780005.21,781272.37,1267.16,329461.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','195899',3823590,'2703','406',637508.27,641973.71,4465.44,1161014.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','195899',3823591,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198386',3867545,'2694','405',310963.20,313233.43,2270.23,374587.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','198386',3867546,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198386',3867547,'2696','405',129684.22,133004.20,3319.98,547796.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','198386',3867548,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198386',3867549,'2698','405',195057.78,196094.32,1036.54,171029.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','198386',3867550,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198386',3867551,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198386',3867552,'2701','405',295595.54,295595.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198386',3867553,'2702','406',781272.37,781272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198386',3867554,'2703','406',641973.71,645637.44,3663.73,952569.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','198386',3867555,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198447',3868765,'2694','405',313233.43,316907.15,3673.72,606163.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','198447',3868766,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198447',3868767,'2696','405',133004.20,136166.43,3162.23,521767.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','198447',3868768,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198447',3868769,'2698','405',196094.32,196424.35,330.03,54454.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','198447',3868770,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198447',3868771,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198447',3868772,'2701','405',295595.54,297782.72,2187.18,360884.70,0.00,0.00,0.00,0.00,0.00),('5','172','913','198447',3868773,'2702','406',781272.37,781272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198447',3868774,'2703','406',645637.44,645637.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198447',3868775,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198448',3868776,'2694','405',316907.15,320010.99,3103.84,512133.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','198448',3868777,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198448',3868778,'2696','405',136166.43,139572.94,3406.51,562074.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','198448',3868779,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198448',3868780,'2698','405',196424.35,197296.37,872.02,143883.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','198448',3868781,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198448',3868782,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198448',3868783,'2701','405',297782.72,298457.58,674.86,111351.90,0.00,0.00,0.00,0.00,0.00),('5','172','913','198448',3868784,'2702','406',781272.37,781272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198448',3868785,'2703','406',645637.44,645637.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198448',3868786,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198450',3868788,'2694','405',320010.99,323616.22,3605.23,594862.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','198450',3868789,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198450',3868790,'2696','405',139572.94,142681.39,3108.45,512894.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','198450',3868791,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198450',3868792,'2698','405',197296.37,197296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198450',3868793,'2699','405',159561.03,159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198450',3868794,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198450',3868795,'2701','405',298457.58,300709.10,2251.52,371500.80,0.00,0.00,0.00,0.00,0.00),('5','172','913','198450',3868796,'2702','406',781272.37,781272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198450',3868797,'2703','406',645637.44,645637.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198450',3868798,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198451',3868799,'2694','405',323616.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198451',3868800,'2695','405',3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198451',3868801,'2696','405',142681.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198451',3868802,'2697','405',255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198451',3868803,'2698','405',197296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198451',3868804,'2699','405',159561.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198451',3868805,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198451',3868806,'2701','405',300709.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198451',3868807,'2702','406',781272.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198451',3868808,'2703','406',645637.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198451',3868809,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198475',3869211,'2694','405',323616.22,325879.27,2263.05,373403.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','198475',3869212,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198475',3869213,'2696','405',142681.39,147194.80,4513.41,744712.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','198475',3869214,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198475',3869215,'2698','405',197296.37,198553.38,1257.01,207406.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','198475',3869216,'2699','405',159561.03,159563.15,2.12,349.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','198475',3869217,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198475',3869218,'2701','405',300709.10,302348.37,1639.27,270479.55,0.00,0.00,0.00,0.00,0.00),('5','172','913','198475',3869219,'2702','406',781272.37,782682.58,1410.21,366654.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','198475',3869220,'2703','406',645637.44,646137.44,500.00,130000.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198475',3869221,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198478',3869247,'2694','405',325879.27,330089.53,4210.26,694692.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','198478',3869248,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198478',3869249,'2696','405',147194.80,151242.93,4048.13,667941.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','198478',3869250,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198478',3869251,'2698','405',198553.38,198553.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198478',3869252,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198478',3869253,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198478',3869254,'2701','405',302348.37,302348.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198478',3869255,'2702','406',782682.58,787860.59,5178.01,1346282.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','198478',3869256,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198478',3869257,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198484',3869385,'2694','405',330089.53,333351.41,3261.88,538210.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','198484',3869386,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198484',3869387,'2696','405',151242.93,154113.83,2870.90,473698.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','198484',3869388,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198484',3869389,'2698','405',198553.38,198553.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198484',3869390,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198484',3869391,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198484',3869392,'2701','405',302348.37,302348.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198484',3869393,'2702','406',787860.59,793818.54,5957.95,1549067.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','198484',3869394,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198484',3869395,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198488',3869447,'2694','405',333351.41,335590.07,2238.66,369378.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','198488',3869448,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198488',3869449,'2696','405',154113.83,155658.45,1544.62,254862.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','198488',3869450,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198488',3869451,'2698','405',198553.38,198553.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198488',3869452,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198488',3869453,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198488',3869454,'2701','405',302348.37,302348.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198488',3869455,'2702','406',793818.54,797821.90,4003.36,1040873.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','198488',3869456,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198488',3869457,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198492',3869543,'2694','405',335590.07,336743.28,1153.21,190279.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','198492',3869544,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198492',3869545,'2696','405',155658.45,157108.90,1450.45,239324.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','198492',3869546,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198492',3869547,'2698','405',198553.38,198553.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198492',3869548,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198492',3869549,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198492',3869550,'2701','405',302348.37,302348.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198492',3869551,'2702','406',797821.90,801897.97,4076.07,1059778.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','198492',3869552,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198492',3869553,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198493',3869554,'2694','405',336743.28,339058.55,2315.27,382019.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','198493',3869555,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198493',3869556,'2696','405',157108.90,158503.21,1394.31,230061.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','198493',3869557,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198493',3869558,'2698','405',198553.38,198553.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198493',3869559,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198493',3869560,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198493',3869561,'2701','405',302348.37,302348.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198493',3869562,'2702','406',801897.97,807245.61,5347.64,1390386.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','198493',3869563,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198493',3869564,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198499',3869703,'2694','405',339058.55,340484.22,1425.67,235235.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','198499',3869704,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198499',3869705,'2696','405',158503.21,160808.94,2305.73,380445.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','198499',3869706,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198499',3869707,'2698','405',198553.38,199053.12,499.74,82457.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','198499',3869708,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198499',3869709,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198499',3869710,'2701','405',302348.37,302803.39,455.02,75078.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','198499',3869711,'2702','406',807245.61,811238.42,3992.81,1038130.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','198499',3869712,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198499',3869713,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198504',3869792,'2694','405',340484.22,343392.33,2908.11,479838.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','198504',3869793,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198504',3869794,'2696','405',160808.94,164321.50,3512.56,579572.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','198504',3869795,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198504',3869796,'2698','405',199053.12,199053.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198504',3869797,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198504',3869798,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198504',3869799,'2701','405',302803.39,302803.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198504',3869800,'2702','406',811238.42,814684.99,3446.57,896108.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','198504',3869801,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198504',3869802,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198506',3869819,'2694','405',343392.33,347194.43,3802.10,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198506',3869820,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198506',3869821,'2696','405',164321.50,169186.18,4864.68,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198506',3869822,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198506',3869823,'2698','405',199053.12,199053.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198506',3869824,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198506',3869825,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198506',3869826,'2701','405',302803.39,302803.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','198506',3869827,'2702','406',814684.99,817970.92,3285.93,854341.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','198506',3869828,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198506',3869829,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198858',3875520,'2694','405',347194.43,351577.75,4383.32,723247.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','198858',3875521,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198858',3875522,'2696','405',169186.18,171829.39,2643.21,436129.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','198858',3875523,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198858',3875524,'2698','405',199053.12,199053.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198858',3875525,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198858',3875526,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198858',3875527,'2701','405',302803.39,303008.66,205.27,33869.55,0.00,0.00,0.00,0.00,0.00),('5','172','913','198858',3875528,'2702','406',817970.92,821891.89,3920.97,1058661.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','198858',3875529,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198858',3875530,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198862',3875586,'2694','405',351577.75,354890.51,3312.76,546605.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','198862',3875587,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198862',3875588,'2696','405',171829.39,175715.48,3886.09,641204.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','198862',3875589,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198862',3875590,'2698','405',199053.12,199053.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198862',3875591,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198862',3875592,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198862',3875593,'2701','405',303008.66,303291.30,282.64,46635.60,0.00,0.00,0.00,0.00,0.00),('5','172','913','198862',3875594,'2702','406',821891.89,825254.01,3362.12,907772.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','198862',3875595,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198862',3875596,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198866',3875663,'2694','405',354890.51,356091.34,1200.83,198136.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','198866',3875664,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','198866',3875665,'2696','405',175715.48,177345.64,1630.16,268976.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','198866',3875666,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198866',3875667,'2698','405',199053.12,202466.56,3413.44,563217.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','198866',3875668,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198866',3875669,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','198866',3875670,'2701','405',303291.30,305814.63,2523.33,416349.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','198866',3875671,'2702','406',825254.01,830483.69,5229.68,1412013.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','198866',3875672,'2703','406',646137.44,646137.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','198866',3875673,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199071',3879422,'2694','405',356091.34,356091.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199071',3879423,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199071',3879424,'2696','405',177345.64,177345.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199071',3879425,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199071',3879426,'2698','405',202466.56,204929.06,2462.50,406312.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','199071',3879427,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199071',3879428,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199071',3879429,'2701','405',305814.63,310667.56,4852.93,800733.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','199071',3879430,'2702','406',830483.69,835762.63,5278.94,1425313.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','199071',3879431,'2703','406',646137.44,646683.34,545.90,147393.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','199071',3879432,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199074',3879502,'2694','405',356091.34,356091.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199074',3879503,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199074',3879504,'2696','405',177345.64,177345.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199074',3879505,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199074',3879506,'2698','405',204929.06,207285.75,2356.69,388853.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','199074',3879507,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199074',3879508,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199074',3879509,'2701','405',310667.56,315013.46,4345.90,717073.50,0.00,0.00,0.00,0.00,0.00),('5','172','913','199074',3879510,'2702','406',835762.63,835762.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','199074',3879511,'2703','406',646683.34,649246.95,2563.61,692174.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','199074',3879512,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199290',3882884,'2694','405',356091.34,356091.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199290',3882885,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199290',3882886,'2696','405',177345.64,177345.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199290',3882887,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199290',3882888,'2698','405',207285.75,209652.23,2366.48,390469.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','199290',3882889,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199290',3882890,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199290',3882891,'2701','405',315013.46,319618.48,4605.02,759828.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','199290',3882892,'2702','406',835762.63,835762.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','199290',3882893,'2703','406',649246.95,653775.42,4528.47,1222686.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','199290',3882894,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199499',3886385,'2694','405',356091.34,356904.98,813.64,134250.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','199499',3886386,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199499',3886387,'2696','405',177345.64,177345.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199499',3886388,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199499',3886389,'2698','405',209652.23,212073.65,2421.42,399534.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','199499',3886390,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199499',3886391,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199499',3886392,'2701','405',319618.48,326152.63,6534.15,1078134.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','199499',3886393,'2702','406',835762.63,837416.28,1653.65,446485.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','199499',3886394,'2703','406',653775.42,656922.93,3147.51,849827.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','199499',3886395,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199601',3888555,'2694','405',356904.98,357798.49,893.51,147429.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','199601',3888556,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199601',3888557,'2696','405',177345.64,180811.18,3465.54,571814.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','199601',3888558,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199601',3888559,'2698','405',212073.65,213588.11,1514.46,249885.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','199601',3888560,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199601',3888561,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199601',3888562,'2701','405',326152.63,327256.59,1103.96,182153.40,0.00,0.00,0.00,0.00,0.00),('5','172','913','199601',3888563,'2702','406',837416.28,837705.90,289.62,78197.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','199601',3888564,'2703','406',656922.93,661201.41,4278.48,1155189.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','199601',3888565,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199816',3891724,'2694','405',357798.49,358423.77,625.28,103171.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','199816',3891725,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199816',3891726,'2696','405',180811.18,181184.77,373.59,61642.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','199816',3891727,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199816',3891728,'2698','405',213588.11,214708.83,1120.72,184918.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','199816',3891729,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199816',3891730,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199816',3891731,'2701','405',327256.59,331378.67,4122.08,680143.20,0.00,0.00,0.00,0.00,0.00),('5','172','913','199816',3891732,'2702','406',837705.90,843781.12,6075.22,1640309.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','199816',3891733,'2703','406',661201.41,661201.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','199816',3891734,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199962',3894211,'2694','405',358423.77,358423.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199962',3894212,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199962',3894213,'2696','405',181184.77,181184.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','199962',3894214,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199962',3894215,'2698','405',214708.83,217149.89,2441.06,402774.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','199962',3894216,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199962',3894217,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','199962',3894218,'2701','405',331378.67,336733.94,5355.27,883619.55,0.00,0.00,0.00,0.00,0.00),('5','172','913','199962',3894219,'2702','406',843781.12,845192.78,1411.66,381148.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','199962',3894220,'2703','406',661201.41,664013.92,2812.51,759377.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','199962',3894221,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200156',3897750,'2694','405',358423.77,358423.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200156',3897751,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200156',3897752,'2696','405',181184.77,181184.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200156',3897753,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200156',3897754,'2698','405',217149.89,219109.48,1959.59,323332.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','200156',3897755,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200156',3897756,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200156',3897757,'2701','405',336733.94,341535.73,4801.79,792295.35,0.00,0.00,0.00,0.00,0.00),('5','172','913','200156',3897758,'2702','406',845192.78,845192.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','200156',3897759,'2703','406',664013.92,668822.49,4808.57,1298313.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','200156',3897760,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200327',3900632,'2694','405',358423.77,359272.47,848.70,140035.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','200327',3900633,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200327',3900634,'2696','405',181184.77,184394.04,3209.27,529529.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','200327',3900635,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200327',3900636,'2698','405',219109.48,220469.07,1359.59,224332.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','200327',3900637,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200327',3900638,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200327',3900639,'2701','405',341535.73,343038.07,1502.34,247886.10,0.00,0.00,0.00,0.00,0.00),('5','172','913','200327',3900640,'2702','406',845192.78,845192.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','200327',3900641,'2703','406',668822.49,674345.81,5523.32,1491296.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','200327',3900642,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200527',3904453,'2694','405',359272.47,361817.89,2545.42,419994.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','200527',3904454,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200527',3904455,'2696','405',184394.04,188289.77,3895.73,642795.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','200527',3904456,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200527',3904457,'2698','405',220469.07,220469.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200527',3904458,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200527',3904459,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200527',3904460,'2701','405',343038.07,343038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','200527',3904461,'2702','406',845192.78,845192.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','200527',3904462,'2703','406',674345.81,679409.82,5064.01,1367282.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','200527',3904463,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200747',3908313,'2694','405',361817.89,364872.87,3054.98,504071.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','200747',3908314,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','200747',3908315,'2696','405',188289.77,194081.47,5791.70,955630.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','200747',3908316,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200747',3908317,'2698','405',220469.07,220469.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200747',3908318,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200747',3908319,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','200747',3908320,'2701','405',343038.07,343038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','200747',3908321,'2702','406',845192.78,847799.65,2606.87,703854.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','200747',3908322,'2703','406',679409.82,681428.88,2019.06,545146.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','200747',3908323,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201070',3914028,'2694','405',364872.87,366709.68,1836.81,303073.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','201070',3914029,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201070',3914030,'2696','405',194081.47,197961.04,3879.57,640129.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','201070',3914031,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201070',3914032,'2698','405',220469.07,220469.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201070',3914033,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201070',3914034,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201070',3914035,'2701','405',343038.07,343038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','201070',3914036,'2702','406',847799.65,852201.76,4402.11,1188569.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','201070',3914037,'2703','406',681428.88,684101.76,2672.88,721677.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','201070',3914038,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201176',3915525,'2694','405',366709.68,369153.41,2443.73,403215.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','201176',3915526,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201176',3915527,'2696','405',197961.04,202246.08,4285.04,707031.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','201176',3915528,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201176',3915529,'2698','405',220469.07,220469.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201176',3915530,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201176',3915531,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201176',3915532,'2701','405',343038.07,343038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','201176',3915533,'2702','406',852201.76,852201.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','201176',3915534,'2703','406',684101.76,692176.82,8075.06,2180266.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','201176',3915535,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201367',3918767,'2694','405',369153.41,371795.33,2641.92,435916.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','201367',3918768,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201367',3918769,'2696','405',202246.08,206014.46,3768.38,621782.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','201367',3918770,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201367',3918771,'2698','405',220469.07,220632.50,163.43,26965.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','201367',3918772,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201367',3918773,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201367',3918774,'2701','405',343038.07,344446.57,1408.50,232402.50,0.00,0.00,0.00,0.00,0.00),('5','172','913','201367',3918775,'2702','406',852201.76,852201.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','201367',3918776,'2703','406',692176.82,697105.38,4928.56,1330711.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','201367',3918777,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201561',3922432,'2694','405',371795.33,371795.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201561',3922433,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201561',3922434,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201561',3922435,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201561',3922436,'2698','405',220632.50,222110.77,1478.27,243914.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','201561',3922437,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201561',3922438,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201561',3922439,'2701','405',344446.57,348999.50,4552.93,751233.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','201561',3922440,'2702','406',852201.76,852201.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','201561',3922441,'2703','406',697105.38,702383.45,5278.07,1425078.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','201561',3922442,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201926',3929631,'2694','405',371795.33,375187.28,3391.95,559671.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','201926',3929632,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201926',3929633,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','201926',3929634,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201926',3929635,'2698','405',222110.77,222110.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201926',3929636,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201926',3929637,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','201926',3929638,'2701','405',348999.50,351880.85,2881.35,475422.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','201926',3929639,'2702','406',852201.76,856884.14,4682.38,1264242.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','201926',3929640,'2703','406',702383.45,704614.58,2231.13,602405.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','201926',3929641,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202179',3934232,'2694','405',375187.28,377874.39,2687.11,443373.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','202179',3934233,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202179',3934234,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202179',3934235,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202179',3934236,'2698','405',222110.77,222110.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202179',3934237,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202179',3934238,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202179',3934239,'2701','405',351880.85,356267.73,4386.88,723835.20,0.00,0.00,0.00,0.00,0.00),('5','172','913','202179',3934240,'2702','406',856884.14,861601.56,4717.42,1273703.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','202179',3934241,'2703','406',704614.58,710412.34,5797.76,1565395.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','202179',3934242,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202269',3935472,'2694','405',377874.39,380948.96,3074.57,507304.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','202269',3935473,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202269',3935474,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202269',3935475,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202269',3935476,'2698','405',222110.77,222110.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202269',3935477,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202269',3935478,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202269',3935479,'2701','405',356267.73,361129.43,4861.70,802180.50,0.00,0.00,0.00,0.00,0.00),('5','172','913','202269',3935480,'2702','406',861601.56,862084.76,483.20,130464.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','202269',3935481,'2703','406',710412.34,717314.24,6901.90,1863513.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','202269',3935482,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202465',3938923,'2694','405',380948.96,382453.95,1504.99,248323.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','202465',3938924,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202465',3938925,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202465',3938926,'2697','405',255012.24,255012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202465',3938927,'2698','405',222110.77,222110.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202465',3938928,'2699','405',159563.15,159563.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202465',3938929,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202465',3938930,'2701','405',361129.43,364517.74,3388.31,559071.15,0.00,0.00,0.00,0.00,0.00),('5','172','913','202465',3938931,'2702','406',862084.76,867228.55,5143.79,1388823.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','202465',3938932,'2703','406',717314.24,720989.98,3675.74,992449.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','202465',3938933,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202776',3944459,'2694','405',382453.95,385497.35,3043.40,502161.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202776',3944460,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202776',3944461,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202776',3944462,'2697','405',255012.24,255020.15,7.91,1305.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','202776',3944463,'2698','405',222110.77,222111.58,0.81,133.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','202776',3944464,'2699','405',159563.15,159563.19,0.04,6.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','202776',3944465,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202776',3944466,'2701','405',364517.74,368029.67,3511.93,579468.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','202776',3944467,'2702','406',867228.55,871778.19,4549.64,1228402.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','202776',3944468,'2703','406',720989.98,721977.80,987.82,266711.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','202776',3944469,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202926',3947137,'2694','405',385497.35,387454.71,1957.36,322964.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','202926',3947138,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202926',3947139,'2696','405',206014.46,206014.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','202926',3947140,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202926',3947141,'2698','405',222111.58,222111.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202926',3947142,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202926',3947143,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','202926',3947144,'2701','405',368029.67,372978.35,4948.68,816532.20,0.00,0.00,0.00,0.00,0.00),('5','172','913','202926',3947145,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','202926',3947146,'2703','406',721977.80,727795.49,5817.69,1570776.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','202926',3947147,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203135',3951142,'2694','405',387454.71,391107.70,3652.99,602743.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','203135',3951143,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203135',3951144,'2696','405',206014.46,209086.75,3072.29,506927.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','203135',3951145,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203135',3951146,'2698','405',222111.58,222111.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203135',3951147,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203135',3951148,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203135',3951149,'2701','405',372978.35,373522.06,543.71,89712.15,0.00,0.00,0.00,0.00,0.00),('5','172','913','203135',3951150,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','203135',3951151,'2703','406',727795.49,733441.54,5646.05,1524433.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','203135',3951152,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203367',3955447,'2694','405',391107.70,393561.24,2453.54,404834.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','203367',3955448,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203367',3955449,'2696','405',209086.75,211275.60,2188.85,361160.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','203367',3955450,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203367',3955451,'2698','405',222111.58,222111.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203367',3955452,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203367',3955453,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203367',3955454,'2701','405',373522.06,373522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','203367',3955455,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','203367',3955456,'2703','406',733441.54,740270.77,6829.23,1843892.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','203367',3955457,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203583',3959244,'2694','405',393561.24,396480.08,2918.84,481608.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','203583',3959245,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203583',3959246,'2696','405',211275.60,214266.28,2990.68,493462.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','203583',3959247,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203583',3959248,'2698','405',222111.58,222111.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203583',3959249,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203583',3959250,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203583',3959251,'2701','405',373522.06,373522.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','203583',3959252,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','203583',3959253,'2703','406',740270.77,746848.25,6577.48,1775919.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','203583',3959254,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203774',3962668,'2694','405',396480.08,399891.94,3411.86,562956.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','203774',3962669,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','203774',3962670,'2696','405',214266.28,217503.54,3237.26,534147.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','203774',3962671,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203774',3962672,'2698','405',222111.58,222111.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203774',3962673,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203774',3962674,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','203774',3962675,'2701','405',373522.06,373659.40,137.34,22661.10,0.00,0.00,0.00,0.00,0.00),('5','172','913','203774',3962676,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','203774',3962677,'2703','406',746848.25,753689.45,6841.20,1847124.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','203774',3962678,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204044',3967487,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204044',3967488,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204044',3967489,'2696','405',217503.54,217538.58,35.04,5781.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','204044',3967490,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204044',3967491,'2698','405',222111.58,224202.58,2091.00,345015.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204044',3967492,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204044',3967493,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204044',3967494,'2701','405',373659.40,376667.97,3008.57,496414.05,0.00,0.00,0.00,0.00,0.00),('5','172','913','204044',3967495,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','204044',3967496,'2703','406',753689.45,760130.40,6440.95,1739056.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','204044',3967497,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204264',3971540,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204264',3971541,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204264',3971542,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204264',3971543,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204264',3971544,'2698','405',224202.58,226404.01,2201.43,363235.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','204264',3971545,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204264',3971546,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204264',3971547,'2701','405',376667.97,379879.56,3211.59,529912.35,0.00,0.00,0.00,0.00,0.00),('5','172','913','204264',3971548,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','204264',3971549,'2703','406',760130.40,760130.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','204264',3971550,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204450',3974784,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204450',3974785,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204450',3974786,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204450',3974787,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204450',3974788,'2698','405',226404.01,229560.93,3156.92,520891.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','204450',3974789,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204450',3974790,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204450',3974791,'2701','405',379879.56,383313.71,3434.15,566634.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','204450',3974792,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','204450',3974793,'2703','406',760130.40,760130.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','204450',3974794,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204658',3978540,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204658',3978541,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204658',3978542,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204658',3978543,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204658',3978544,'2698','405',229560.93,232911.80,3350.87,552893.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','204658',3978545,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204658',3978546,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204658',3978547,'2701','405',383313.71,386832.48,3518.77,580597.05,0.00,0.00,0.00,0.00,0.00),('5','172','913','204658',3978548,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','204658',3978549,'2703','406',760130.40,760130.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','204658',3978550,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204878',3982148,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204878',3982149,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204878',3982150,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','204878',3982151,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204878',3982152,'2698','405',232911.80,236034.32,3122.52,515215.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','204878',3982153,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204878',3982154,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','204878',3982155,'2701','405',386832.48,390081.72,3249.24,536124.60,0.00,0.00,0.00,0.00,0.00),('5','172','913','204878',3982156,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','204878',3982157,'2703','406',760130.40,760130.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','204878',3982158,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205201',3988321,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205201',3988322,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205201',3988323,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205201',3988324,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205201',3988325,'2698','405',236034.32,239305.19,3270.87,539693.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','205201',3988326,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205201',3988327,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205201',3988328,'2701','405',390081.72,392842.58,2760.86,455541.90,0.00,0.00,0.00,0.00,0.00),('5','172','913','205201',3988329,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','205201',3988330,'2703','406',760130.40,767552.64,7422.24,2004004.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','205201',3988331,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205384',3991441,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205384',3991442,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205384',3991443,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205384',3991444,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205384',3991445,'2698','405',239305.19,240730.35,1425.16,235151.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','205384',3991446,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205384',3991447,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205384',3991448,'2701','405',392842.58,394131.79,1289.21,212719.65,0.00,0.00,0.00,0.00,0.00),('5','172','913','205384',3991449,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','205384',3991450,'2703','406',767552.64,775715.75,8163.11,2285670.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','205384',3991451,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205539',3994135,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205539',3994136,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205539',3994137,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205539',3994138,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205539',3994139,'2698','405',240730.35,240730.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205539',3994140,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205539',3994141,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205539',3994142,'2701','405',394131.79,394131.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','205539',3994143,'2702','406',871778.19,871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','205539',3994144,'2703','406',775715.75,781575.61,5859.86,1640760.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','205539',3994145,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205786',3998698,'2694','405',399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205786',3998699,'2695','405',3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205786',3998700,'2696','405',217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205786',3998701,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205786',3998702,'2698','405',240730.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205786',3998703,'2699','405',159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205786',3998704,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205786',3998705,'2701','405',394131.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','205786',3998706,'2702','406',871778.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','205786',3998707,'2703','406',781575.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','205786',3998708,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205790',3998754,'2694','405',399891.94,399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205790',3998755,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205790',3998756,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','205790',3998757,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205790',3998758,'2698','405',240730.35,240730.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205790',3998759,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205790',3998760,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','205790',3998761,'2701','405',394131.79,394131.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','205790',3998762,'2702','406',871778.19,873735.62,1957.43,548080.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','205790',3998763,'2703','406',781575.61,783836.61,2261.00,633080.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','205790',3998764,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206008',4002594,'2694','405',399891.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206008',4002595,'2695','405',3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206008',4002596,'2696','405',217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206008',4002597,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206008',4002598,'2698','405',240730.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206008',4002599,'2699','405',159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206008',4002600,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206008',4002601,'2701','405',394131.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','206008',4002602,'2702','406',873735.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','206008',4002603,'2703','406',783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206008',4002604,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206237',4006757,'2694','405',399891.94,401068.77,1176.83,194176.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','206237',4006758,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206237',4006759,'2696','405',217538.58,217538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206237',4006760,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206237',4006761,'2698','405',240730.35,241967.27,1236.92,204091.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','206237',4006762,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206237',4006763,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206237',4006764,'2701','405',394131.79,394567.48,435.69,71888.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','206237',4006765,'2702','406',873735.62,877883.94,4148.32,1203012.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','206237',4006766,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206237',4006767,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206243',4006835,'2694','405',401068.77,403276.75,2207.98,364316.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','206243',4006836,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206243',4006837,'2696','405',217538.58,220152.90,2614.32,431362.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','206243',4006838,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206243',4006839,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206243',4006840,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206243',4006841,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206243',4006842,'2701','405',394567.48,394567.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','206243',4006843,'2702','406',877883.94,880607.33,2723.39,789783.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','206243',4006844,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206243',4006845,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206492',4011138,'2694','405',403276.75,405409.37,2132.62,351882.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','206492',4011139,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206492',4011140,'2696','405',220152.90,221305.97,1153.07,190256.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','206492',4011141,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206492',4011142,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206492',4011143,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206492',4011144,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206492',4011145,'2701','405',394567.48,396253.17,1685.69,278138.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','206492',4011146,'2702','406',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','206492',4011147,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206492',4011148,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206695',4014805,'2694','405',405409.37,408504.76,3095.39,510739.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','206695',4014806,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206695',4014807,'2696','405',221305.97,223258.90,1952.93,322233.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','206695',4014808,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206695',4014809,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206695',4014810,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206695',4014811,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206695',4014812,'2701','405',396253.17,396486.50,233.33,38499.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','206695',4014813,'2702','406',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','206695',4014814,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206695',4014815,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206871',4017670,'2694','405',408504.76,412331.19,3826.43,631360.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','206871',4017671,'2695','405',3749.69,3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','206871',4017672,'2696','405',223258.90,223577.75,318.85,52610.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','206871',4017673,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206871',4017674,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206871',4017675,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206871',4017676,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','206871',4017677,'2701','405',396486.50,398950.35,2463.85,406535.25,0.00,0.00,0.00,0.00,0.00),('5','172','913','206871',4017678,'2702','406',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','206871',4017679,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','206871',4017680,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207088',4021642,'2694','405',412331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207088',4021643,'2695','405',3749.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207088',4021644,'2696','405',223577.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207088',4021645,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207088',4021646,'2698','405',241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207088',4021647,'2699','405',159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207088',4021648,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207088',4021649,'2701','405',398950.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','207088',4021650,'2702','406',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','207088',4021651,'2703','406',783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207088',4021652,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207335',4026104,'2694','405',412331.19,415208.84,2877.65,474812.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','207335',4026105,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207335',4026106,'2696','405',223577.75,223577.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207335',4026107,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207335',4026108,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207335',4026109,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207335',4026110,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207335',4026111,'2701','405',398950.35,400600.15,1649.80,272217.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','207335',4026112,'2702','406',3749.69,7163.89,3414.20,990118.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','207335',4026113,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207335',4026114,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207341',4026182,'2694','405',415208.84,417918.27,2709.43,447055.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','207341',4026183,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207341',4026184,'2696','405',223577.75,225473.70,1895.95,312831.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','207341',4026185,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207341',4026186,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207341',4026187,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207341',4026188,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207341',4026189,'2701','405',400600.15,401101.24,501.09,82679.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','207341',4026190,'2702','406',7163.89,12239.37,5075.48,1471889.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','207341',4026191,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207341',4026192,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207521',4029473,'2694','405',417918.27,420757.60,2839.33,468489.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','207521',4029474,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207521',4029475,'2696','405',225473.70,227956.96,2483.26,409737.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','207521',4029476,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207521',4029477,'2698','405',241967.27,241967.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207521',4029478,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207521',4029479,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207521',4029480,'2701','405',401101.24,401101.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','207521',4029481,'2702','406',12239.37,15581.39,3342.02,969185.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','207521',4029482,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207521',4029483,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207819',4034508,'2694','405',420757.60,421131.35,373.75,61668.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','207819',4034509,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207819',4034510,'2696','405',227956.96,228157.29,200.33,33054.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','207819',4034511,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207819',4034512,'2698','405',241967.27,244622.62,2655.35,438132.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','207819',4034513,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207819',4034514,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207819',4034515,'2701','405',401101.24,404170.96,3069.72,506503.80,0.00,0.00,0.00,0.00,0.00),('5','172','913','207819',4034516,'2702','406',15581.39,16606.91,1025.52,297400.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','207819',4034517,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207819',4034518,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207964',4036986,'2694','405',421131.35,421131.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207964',4036987,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207964',4036988,'2696','405',228157.29,228157.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','207964',4036989,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207964',4036990,'2698','405',244622.62,247423.09,2800.47,462077.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','207964',4036991,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207964',4036992,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','207964',4036993,'2701','405',404170.96,406701.05,2530.09,417464.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','207964',4036994,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','207964',4036995,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','207964',4036996,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208186',4040910,'2694','405',421131.35,424173.08,3041.73,501885.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','208186',4040911,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208186',4040912,'2696','405',228157.29,231112.57,2955.28,487621.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','208186',4040913,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208186',4040914,'2698','405',247423.09,247681.06,257.97,42565.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','208186',4040915,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208186',4040916,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208186',4040917,'2701','405',406701.05,406957.85,256.80,42372.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','208186',4040918,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','208186',4040919,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','208186',4040920,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208388',4044534,'2694','405',424173.08,427396.84,3223.76,531920.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','208388',4044535,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208388',4044536,'2696','405',231112.57,234684.88,3572.31,589431.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','208388',4044537,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208388',4044538,'2698','405',247681.06,247729.77,48.71,8037.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','208388',4044539,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208388',4044540,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208388',4044541,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','208388',4044542,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','208388',4044543,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','208388',4044544,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208592',4048000,'2694','405',427396.84,429624.81,2227.97,367615.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','208592',4048001,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208592',4048002,'2696','405',234684.88,237531.90,2847.02,469758.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','208592',4048003,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208592',4048004,'2698','405',247729.77,247828.57,98.80,16302.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208592',4048005,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208592',4048006,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208592',4048007,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','208592',4048008,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','208592',4048009,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','208592',4048010,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208818',4051843,'2694','405',429624.81,431808.62,2183.81,360328.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','208818',4051844,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','208818',4051845,'2696','405',237531.90,239988.15,2456.25,405281.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','208818',4051846,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208818',4051847,'2698','405',247828.57,248284.57,456.00,75240.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208818',4051848,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208818',4051849,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','208818',4051850,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','208818',4051851,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','208818',4051852,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','208818',4051853,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209102',4056815,'2694','405',431808.62,434261.80,2453.18,404774.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','209102',4056816,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209102',4056817,'2696','405',239988.15,242820.35,2832.20,467313.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209102',4056818,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209102',4056819,'2698','405',248284.57,248955.53,670.96,110708.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','209102',4056820,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209102',4056821,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209102',4056822,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','209102',4056823,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','209102',4056824,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','209102',4056825,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209251',4059511,'2694','405',434261.80,436846.59,2584.79,426490.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','209251',4059512,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209251',4059513,'2696','405',242820.35,245674.36,2854.01,470911.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','209251',4059514,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209251',4059515,'2698','405',248955.53,249518.18,562.65,92837.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','209251',4059516,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209251',4059517,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209251',4059518,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','209251',4059519,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','209251',4059520,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','209251',4059521,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209488',4063768,'2694','405',436846.59,438712.79,1866.20,307923.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209488',4063769,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209488',4063770,'2696','405',245674.36,248102.17,2427.81,400588.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','209488',4063771,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209488',4063772,'2698','405',249518.18,250125.59,607.41,100222.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','209488',4063773,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209488',4063774,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209488',4063775,'2701','405',406957.85,406957.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','209488',4063776,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','209488',4063777,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','209488',4063778,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209671',4066976,'2694','405',438712.79,440502.70,1789.91,295335.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','209671',4066977,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209671',4066978,'2696','405',248102.17,250012.81,1910.64,315255.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','209671',4066979,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209671',4066980,'2698','405',250125.59,251460.01,1334.42,220179.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','209671',4066981,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209671',4066982,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209671',4066983,'2701','405',406957.85,407421.76,463.91,76545.15,0.00,0.00,0.00,0.00,0.00),('5','172','913','209671',4066984,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','209671',4066985,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','209671',4066986,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209913',4071300,'2694','405',440502.70,440502.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209913',4071301,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209913',4071302,'2696','405',250012.81,250012.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','209913',4071303,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209913',4071304,'2698','405',251460.01,255222.08,3762.07,620741.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','209913',4071305,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209913',4071306,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','209913',4071307,'2701','405',407421.76,411546.43,4124.67,680570.55,0.00,0.00,0.00,0.00,0.00),('5','172','913','209913',4071308,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','209913',4071309,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','209913',4071310,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210143',4075287,'2694','405',440502.70,440502.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210143',4075288,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210143',4075289,'2696','405',250012.81,250030.69,17.88,2950.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','210143',4075290,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210143',4075291,'2698','405',255222.08,258685.96,3463.88,571540.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','210143',4075292,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210143',4075293,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210143',4075294,'2701','405',411546.43,414724.25,3177.82,524340.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','210143',4075295,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','210143',4075296,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','210143',4075297,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210347',4078877,'2694','405',440502.70,440502.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210347',4078878,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210347',4078879,'2696','405',250030.69,250030.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210347',4078880,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210347',4078881,'2698','405',258685.96,261862.76,3176.80,524172.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210347',4078882,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210347',4078883,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210347',4078884,'2701','405',414724.25,418239.90,3515.65,580082.25,0.00,0.00,0.00,0.00,0.00),('5','172','913','210347',4078885,'2702','406',16606.91,16606.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','210347',4078886,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','210347',4078887,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210536',4082412,'2694','405',440502.70,440502.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210536',4082413,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210536',4082414,'2696','405',250030.69,250030.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210536',4082415,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210536',4082416,'2698','405',261862.76,266948.06,5085.30,839074.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','210536',4082417,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210536',4082418,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210536',4082419,'2701','405',418239.90,421890.45,3650.55,602340.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','210536',4082420,'2702','406',16606.91,16912.91,306.00,88740.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','210536',4082421,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','210536',4082422,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210789',4086903,'2694','405',440502.70,440502.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210789',4086904,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210789',4086905,'2696','405',250030.69,250030.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','210789',4086906,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210789',4086907,'2698','405',266948.06,268786.36,1838.30,303319.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','210789',4086908,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210789',4086909,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','210789',4086910,'2701','405',421890.45,425158.70,3268.25,539261.25,0.00,0.00,0.00,0.00,0.00),('5','172','913','210789',4086911,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','210789',4086912,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','210789',4086913,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211139',4093081,'2694','405',440502.70,443599.98,3097.28,511051.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','211139',4093082,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211139',4093083,'2696','405',250030.69,253811.31,3780.62,623802.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','211139',4093084,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211139',4093085,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211139',4093086,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211139',4093087,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211139',4093088,'2701','405',425158.70,425158.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','211139',4093089,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','211139',4093090,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','211139',4093091,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211281',4095565,'2694','405',443599.98,448018.40,4418.42,729039.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','211281',4095566,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211281',4095567,'2696','405',253811.31,258566.09,4754.78,784538.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','211281',4095568,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211281',4095569,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211281',4095570,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211281',4095571,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211281',4095572,'2701','405',425158.70,425627.89,469.19,77416.35,0.00,0.00,0.00,0.00,0.00),('5','172','913','211281',4095573,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','211281',4095574,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','211281',4095575,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211403',4097674,'2694','405',448018.40,450053.45,2035.05,335783.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','211403',4097675,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211403',4097676,'2696','405',258566.09,261190.48,2624.39,433024.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','211403',4097677,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211403',4097678,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211403',4097679,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211403',4097680,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211403',4097681,'2701','405',425627.89,426856.50,1228.61,202720.65,0.00,0.00,0.00,0.00,0.00),('5','172','913','211403',4097682,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','211403',4097683,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','211403',4097684,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211719',4103200,'2694','405',450053.45,451117.49,1064.04,175566.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','211719',4103201,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211719',4103202,'2696','405',261190.48,262495.19,1304.71,215277.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','211719',4103203,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211719',4103204,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211719',4103205,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211719',4103206,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211719',4103207,'2701','405',426856.50,426856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','211719',4103208,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','211719',4103209,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','211719',4103210,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211867',4105656,'2694','405',451117.49,452337.52,1220.03,201304.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','211867',4105657,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','211867',4105658,'2696','405',262495.19,263400.43,905.24,149364.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','211867',4105659,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211867',4105660,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211867',4105661,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211867',4105662,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','211867',4105663,'2701','405',426856.50,426856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','211867',4105664,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','211867',4105665,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','211867',4105666,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212041',4108689,'2694','405',452337.52,454174.82,1837.30,303154.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','212041',4108690,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212041',4108691,'2696','405',263400.43,264567.77,1167.34,192611.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','212041',4108692,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212041',4108693,'2698','405',268786.36,268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212041',4108694,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212041',4108695,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212041',4108696,'2701','405',426856.50,426856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','212041',4108697,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','212041',4108698,'2703','406',783836.61,783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','212041',4108699,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212309',4113511,'2694','405',454174.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212309',4113512,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212309',4113513,'2696','405',264567.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212309',4113514,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212309',4113515,'2698','405',268786.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212309',4113516,'2699','405',159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212309',4113517,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212309',4113518,'2701','405',426856.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','212309',4113519,'2702','406',16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','212309',4113520,'2703','406',783836.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','212309',4113521,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212510',4117203,'2694','405',454174.82,454174.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212510',4117204,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212510',4117205,'2696','405',264567.77,264567.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212510',4117206,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212510',4117207,'2698','405',268786.36,271350.48,2564.12,423079.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','212510',4117208,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212510',4117209,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212510',4117210,'2701','405',426856.50,428211.28,1354.78,223538.70,0.00,0.00,0.00,0.00,0.00),('5','172','913','212510',4117211,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','212510',4117212,'2703','406',783836.61,784131.20,294.59,86904.05,0.00,0.00,0.00,0.00,0.00),('5','172','915','212510',4117213,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212520',4117365,'2694','405',454174.82,454174.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212520',4117366,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212520',4117367,'2696','405',264567.77,265146.54,578.77,95497.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','212520',4117368,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212520',4117369,'2698','405',271350.48,272452.88,1102.40,181896.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212520',4117370,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212520',4117371,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212520',4117372,'2701','405',428211.28,430105.26,1893.98,312506.70,0.00,0.00,0.00,0.00,0.00),('5','172','913','212520',4117373,'2702','406',16912.91,16912.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','212520',4117374,'2703','406',784131.20,785804.99,1673.79,493768.05,0.00,0.00,0.00,0.00,0.00),('5','172','915','212520',4117375,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212694',4120483,'2694','405',454174.82,454174.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212694',4120484,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212694',4120485,'2696','405',265146.54,265146.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','212694',4120486,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212694',4120487,'2698','405',272452.88,274844.00,2391.12,394534.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','212694',4120488,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212694',4120489,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','212694',4120490,'2701','405',430105.26,432367.94,2262.68,373342.20,0.00,0.00,0.00,0.00,0.00),('5','172','913','212694',4120491,'2702','406',16912.91,18351.79,1438.88,424469.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','212694',4120492,'2703','406',785804.99,786391.98,586.99,173162.05,0.00,0.00,0.00,0.00,0.00),('5','172','915','212694',4120493,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213073',4127191,'2694','405',454174.82,456617.42,2442.60,403029.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213073',4127192,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213073',4127193,'2696','405',265146.54,267070.70,1924.16,317486.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','213073',4127194,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213073',4127195,'2698','405',274844.00,276677.72,1833.72,302563.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','213073',4127196,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213073',4127197,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213073',4127198,'2701','405',432367.94,432986.54,618.60,102069.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','213073',4127199,'2702','406',18351.79,18832.46,480.67,141797.65,0.00,0.00,0.00,0.00,0.00),('5','172','914','213073',4127200,'2703','406',786391.98,787373.91,981.93,289669.35,0.00,0.00,0.00,0.00,0.00),('5','172','915','213073',4127201,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213177',4128869,'2694','405',456617.42,458409.49,1792.07,295691.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','213177',4128870,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213177',4128871,'2696','405',267070.70,269621.62,2550.92,420901.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','213177',4128872,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213177',4128873,'2698','405',276677.72,276677.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213177',4128874,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213177',4128875,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213177',4128876,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','213177',4128877,'2702','406',18832.46,18856.18,23.72,6997.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','213177',4128878,'2703','406',787373.91,789059.29,1685.38,497187.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','213177',4128879,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213445',4133198,'2694','405',458409.49,460687.10,2277.61,375805.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','213445',4133199,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213445',4133200,'2696','405',269621.62,271856.41,2234.79,368740.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','213445',4133201,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213445',4133202,'2698','405',276677.72,276677.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213445',4133203,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213445',4133204,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213445',4133205,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','213445',4133206,'2702','406',18856.18,18856.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','213445',4133207,'2703','406',789059.29,791864.49,2805.20,827534.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','213445',4133208,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213687',4137322,'2694','405',460687.10,463298.19,2611.09,430829.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','213687',4137323,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213687',4137324,'2696','405',271856.41,275160.51,3304.10,545176.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','213687',4137325,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213687',4137326,'2698','405',276677.72,276677.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213687',4137327,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213687',4137328,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213687',4137329,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','213687',4137330,'2702','406',18856.18,18856.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','213687',4137331,'2703','406',791864.49,795456.38,3591.89,1059607.55,0.00,0.00,0.00,0.00,0.00),('5','172','915','213687',4137332,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213956',4141676,'2694','405',463298.19,464896.34,1598.15,263694.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','213956',4141677,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','213956',4141678,'2696','405',275160.51,277766.45,2605.94,429980.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','213956',4141679,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213956',4141680,'2698','405',276677.72,277783.72,1106.00,182490.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213956',4141681,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213956',4141682,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','213956',4141683,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','213956',4141684,'2702','406',18856.18,18856.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','213956',4141685,'2703','406',795456.38,798130.90,2674.52,788983.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','213956',4141686,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214133',4144660,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214133',4144661,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214133',4144662,'2696','405',277766.45,279694.20,1927.75,318078.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','214133',4144663,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214133',4144664,'2698','405',277783.72,280012.43,2228.71,367737.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','214133',4144665,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214133',4144666,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214133',4144667,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','214133',4144668,'2702','406',18856.18,19008.64,152.46,44975.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','214133',4144669,'2703','406',798130.90,800082.22,1951.32,575639.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','214133',4144670,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214736',4155270,'2694','405',464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214736',4155271,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214736',4155272,'2696','405',279694.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214736',4155273,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214736',4155274,'2698','405',280012.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214736',4155275,'2699','405',159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214736',4155276,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214736',4155277,'2701','405',432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','214736',4155278,'2702','406',19008.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','214736',4155279,'2703','406',800082.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','214736',4155280,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214860',4157338,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214860',4157339,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214860',4157340,'2696','405',279694.20,283360.14,3665.94,604880.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','214860',4157341,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214860',4157342,'2698','405',280012.43,282676.17,2663.74,439517.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','214860',4157343,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214860',4157344,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214860',4157345,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','214860',4157346,'2702','406',19008.64,19008.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','214860',4157347,'2703','406',800082.22,803797.90,3715.68,1096125.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','214860',4157348,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214862',4157380,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214862',4157381,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214862',4157382,'2696','405',283360.14,287088.51,3728.37,615181.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','214862',4157383,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214862',4157384,'2698','405',282676.17,285529.75,2853.58,470840.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','214862',4157385,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214862',4157386,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214862',4157387,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','214862',4157388,'2702','406',19008.64,19386.14,377.50,111362.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','214862',4157389,'2703','406',803797.90,807851.16,4053.26,1195711.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','214862',4157390,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214864',4157407,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214864',4157408,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','214864',4157409,'2696','405',287088.51,290630.34,3541.83,584401.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','214864',4157410,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214864',4157411,'2698','405',285529.75,287415.87,1886.12,311209.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','214864',4157412,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214864',4157413,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','214864',4157414,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','214864',4157415,'2702','406',19386.14,19386.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','214864',4157416,'2703','406',807851.16,810029.24,2178.08,642533.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','214864',4157417,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215027',4159924,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215027',4159925,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215027',4159926,'2696','405',290630.34,293165.27,2534.93,418263.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','215027',4159927,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215027',4159928,'2698','405',287415.87,290530.28,3114.41,513877.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','215027',4159929,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215027',4159930,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215027',4159931,'2701','405',432986.54,432986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','215027',4159932,'2702','406',19386.14,19386.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','215027',4159933,'2703','406',810029.24,814541.26,4512.02,1331045.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','215027',4159934,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215242',4163665,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215242',4163666,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215242',4163667,'2696','405',293165.27,295305.07,2139.80,353067.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215242',4163668,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215242',4163669,'2698','405',290530.28,293301.58,2771.30,457264.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','215242',4163670,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215242',4163671,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215242',4163672,'2701','405',432986.54,434037.99,1051.45,173489.25,0.00,0.00,0.00,0.00,0.00),('5','172','913','215242',4163673,'2702','406',19386.14,19386.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','215242',4163674,'2703','406',814541.26,819044.96,4503.70,1328591.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','215242',4163675,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215538',4168645,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215538',4168646,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215538',4168647,'2696','405',295305.07,295305.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215538',4168648,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215538',4168649,'2698','405',293301.58,295884.05,2582.47,426107.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','215538',4168650,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215538',4168651,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215538',4168652,'2701','405',434037.99,436461.04,2423.05,399803.25,0.00,0.00,0.00,0.00,0.00),('5','172','913','215538',4168653,'2702','406',19386.14,19588.71,202.57,59758.15,0.00,0.00,0.00,0.00,0.00),('5','172','914','215538',4168654,'2703','406',819044.96,823649.01,4604.05,1358194.75,0.00,0.00,0.00,0.00,0.00),('5','172','915','215538',4168655,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215799',4173288,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215799',4173289,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215799',4173290,'2696','405',295305.07,295305.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215799',4173291,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215799',4173292,'2698','405',295884.05,297724.28,1840.23,303637.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','215799',4173293,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215799',4173294,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215799',4173295,'2701','405',436461.04,439352.77,2891.73,477135.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','215799',4173296,'2702','406',19588.71,19588.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','215799',4173297,'2703','406',823649.01,827029.08,3380.07,997120.65,0.00,0.00,0.00,0.00,0.00),('5','172','915','215799',4173298,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215926',4175315,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215926',4175316,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','215926',4175317,'2696','405',295305.07,296967.34,1662.27,274274.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','215926',4175318,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215926',4175319,'2698','405',297724.28,299403.24,1678.96,277028.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','215926',4175320,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215926',4175321,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','215926',4175322,'2701','405',439352.77,441816.27,2463.50,406477.50,0.00,0.00,0.00,0.00,0.00),('5','172','913','215926',4175323,'2702','406',19588.71,19588.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','215926',4175324,'2703','406',827029.08,829577.03,2547.95,751645.25,0.00,0.00,0.00,0.00,0.00),('5','172','915','215926',4175325,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216191',4179871,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216191',4179872,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216191',4179873,'2696','405',296967.34,301585.05,4617.71,761922.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','216191',4179874,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216191',4179875,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216191',4179876,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216191',4179877,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216191',4179878,'2701','405',441816.27,443457.22,1640.95,270756.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','216191',4179879,'2702','406',19588.71,19588.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','216191',4179880,'2703','406',829577.03,835469.29,5892.26,1738216.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','216191',4179881,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216370',4182893,'2694','405',464896.34,464896.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216370',4182894,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216370',4182895,'2696','405',301585.05,304689.99,3104.94,512315.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','216370',4182896,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216370',4182897,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216370',4182898,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216370',4182899,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216370',4182900,'2701','405',443457.22,445372.03,1914.81,315943.65,0.00,0.00,0.00,0.00,0.00),('5','172','913','216370',4182901,'2702','406',19588.71,19588.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','216370',4182902,'2703','406',835469.29,837666.88,2197.59,648289.05,0.00,0.00,0.00,0.00,0.00),('5','172','915','216370',4182903,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216609',4187011,'2694','405',464896.34,466640.85,1744.51,287844.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','216609',4187012,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216609',4187013,'2696','405',304689.99,305333.11,643.12,106114.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','216609',4187014,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216609',4187015,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216609',4187016,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216609',4187017,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216609',4187018,'2701','405',445372.03,447010.45,1638.42,270339.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','216609',4187019,'2702','406',19588.71,19588.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','216609',4187020,'2703','406',837666.88,841243.85,3576.97,1055206.15,0.00,0.00,0.00,0.00,0.00),('5','172','915','216609',4187021,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216949',4193278,'2694','405',466640.85,469597.99,2957.14,487928.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','216949',4193279,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','216949',4193280,'2696','405',305333.11,306897.28,1564.17,258088.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','216949',4193281,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216949',4193282,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216949',4193283,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216949',4193284,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','216949',4193285,'2701','405',447010.45,448097.27,1086.82,179325.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','216949',4193286,'2702','406',19588.71,20057.04,468.33,138157.35,0.00,0.00,0.00,0.00,0.00),('5','172','914','216949',4193287,'2703','406',841243.85,844248.81,3004.96,886463.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','216949',4193288,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217086',4195427,'2694','405',469597.99,472041.98,2443.99,403258.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','217086',4195428,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217086',4195429,'2696','405',306897.28,309845.51,2948.23,486457.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','217086',4195430,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217086',4195431,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217086',4195432,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217086',4195433,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217086',4195434,'2701','405',448097.27,448097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','217086',4195435,'2702','406',20057.04,24021.81,3964.77,1169607.15,0.00,0.00,0.00,0.00,0.00),('5','172','914','217086',4195436,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','217086',4195437,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217315',4199869,'2694','405',472041.98,474583.15,2541.17,419293.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','217315',4199870,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217315',4199871,'2696','405',309845.51,312090.60,2245.09,370439.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','217315',4199872,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217315',4199873,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217315',4199874,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217315',4199875,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217315',4199876,'2701','405',448097.27,448097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','217315',4199877,'2702','406',24021.81,27439.00,3417.19,1008071.05,0.00,0.00,0.00,0.00,0.00),('5','172','914','217315',4199878,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','217315',4199879,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217809',4208534,'2694','405',474583.15,477558.18,2975.03,490879.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','217809',4208535,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217809',4208536,'2696','405',312090.60,314838.12,2747.52,453340.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','217809',4208537,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217809',4208538,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217809',4208539,'2699','405',159563.19,159563.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217809',4208540,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217809',4208541,'2701','405',448097.27,448097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','217809',4208542,'2702','406',27439.00,31020.75,3581.75,1056616.25,0.00,0.00,0.00,0.00,0.00),('5','172','914','217809',4208543,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','217809',4208544,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217819',4208709,'2694','405',477558.18,478510.04,951.86,157056.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','217819',4208710,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','217819',4208711,'2696','405',314838.12,315715.63,877.51,144789.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','217819',4208712,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217819',4208713,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217819',4208714,'2699','405',159563.19,161678.25,2115.06,348984.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','217819',4208715,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','217819',4208716,'2701','405',448097.27,450080.16,1982.89,327176.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','217819',4208717,'2702','406',31020.75,34869.23,3848.48,1135301.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','217819',4208718,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','217819',4208719,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218031',4212416,'2694','405',478510.04,478510.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218031',4212417,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218031',4212418,'2696','405',315715.63,315715.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218031',4212419,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218031',4212420,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218031',4212421,'2699','405',161678.25,163991.07,2312.82,381615.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','218031',4212422,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218031',4212423,'2701','405',450080.16,452863.90,2783.74,459317.10,0.00,0.00,0.00,0.00,0.00),('5','172','913','218031',4212424,'2702','406',34869.23,37556.25,2687.02,792670.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','218031',4212425,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218031',4212426,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218266',4216492,'2694','405',478510.04,479017.04,507.00,83655.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218266',4216493,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218266',4216494,'2696','405',315715.63,316034.71,319.08,52648.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','218266',4216495,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218266',4216496,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218266',4216497,'2699','405',163991.07,165699.22,1708.15,281844.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','218266',4216498,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218266',4216499,'2701','405',452863.90,454471.16,1607.26,265197.90,0.00,0.00,0.00,0.00,0.00),('5','172','913','218266',4216500,'2702','406',37556.25,42380.87,4824.62,1423262.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','218266',4216501,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218266',4216502,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218715',4224463,'2694','405',479017.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218715',4224464,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218715',4224465,'2696','405',316034.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218715',4224466,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218715',4224467,'2698','405',299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218715',4224468,'2699','405',165699.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218715',4224469,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218715',4224470,'2701','405',454471.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','218715',4224471,'2702','406',42380.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','218715',4224472,'2703','406',844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218715',4224473,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218742',4224868,'2694','405',479017.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218742',4224869,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218742',4224870,'2696','405',316034.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218742',4224871,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218742',4224872,'2698','405',299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218742',4224873,'2699','405',165699.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218742',4224874,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218742',4224875,'2701','405',454471.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','218742',4224876,'2702','406',42380.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','218742',4224877,'2703','406',844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218742',4224878,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218747',4224985,'2694','405',479017.04,479017.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218747',4224986,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218747',4224987,'2696','405',316034.71,316034.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218747',4224988,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218747',4224989,'2698','405',299403.24,299403.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218747',4224990,'2699','405',165699.22,168077.44,2378.22,392406.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','218747',4224991,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218747',4224992,'2701','405',454471.16,457324.58,2853.42,470814.30,0.00,0.00,0.00,0.00,0.00),('5','172','913','218747',4224993,'2702','406',42380.87,45667.16,3286.29,969455.55,0.00,0.00,0.00,0.00,0.00),('5','172','914','218747',4224994,'2703','406',844248.81,844248.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218747',4224995,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218751',4225088,'2694','405',479017.04,481198.85,2181.81,359998.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','218751',4225089,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218751',4225090,'2696','405',316034.71,317555.31,1520.60,250899.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218751',4225091,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218751',4225092,'2698','405',299403.24,299414.11,10.87,1793.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','218751',4225093,'2699','405',168077.44,168699.48,622.04,102636.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','218751',4225094,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218751',4225095,'2701','405',457324.58,457932.66,608.08,100333.20,0.00,0.00,0.00,0.00,0.00),('5','172','913','218751',4225096,'2702','406',45667.16,50165.82,4498.66,1327104.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','218751',4225097,'2703','406',844248.81,844401.82,153.01,45137.95,0.00,0.00,0.00,0.00,0.00),('5','172','915','218751',4225098,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218963',4228748,'2694','405',481198.85,483915.10,2716.25,448181.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','218963',4228749,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','218963',4228750,'2696','405',317555.31,320380.92,2825.61,466225.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','218963',4228751,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218963',4228752,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218963',4228753,'2699','405',168699.48,168699.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218963',4228754,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','218963',4228755,'2701','405',457932.66,457932.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','218963',4228756,'2702','406',50165.82,53506.14,3340.32,985394.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','218963',4228757,'2703','406',844401.82,844401.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','218963',4228758,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219166',4232186,'2694','405',483915.10,485523.83,1608.73,265440.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','219166',4232187,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219166',4232188,'2696','405',320380.92,322180.22,1799.30,296884.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','219166',4232189,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219166',4232190,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219166',4232191,'2699','405',168699.48,169272.91,573.43,94615.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','219166',4232192,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219166',4232193,'2701','405',457932.66,459172.02,1239.36,204494.40,0.00,0.00,0.00,0.00,0.00),('5','172','913','219166',4232194,'2702','406',53506.14,55740.73,2234.59,659204.05,0.00,0.00,0.00,0.00,0.00),('5','172','914','219166',4232195,'2703','406',844401.82,844451.82,50.00,14750.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','219166',4232196,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219419',4236642,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219419',4236643,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219419',4236644,'2696','405',322180.22,322477.59,297.37,49066.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','219419',4236645,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219419',4236646,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219419',4236647,'2699','405',169272.91,172231.06,2958.15,488094.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','219419',4236648,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219419',4236649,'2701','405',459172.02,461923.78,2751.76,454040.40,0.00,0.00,0.00,0.00,0.00),('5','172','913','219419',4236650,'2702','406',55740.73,58906.17,3165.44,933804.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','219419',4236651,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','219419',4236652,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219722',4242081,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219722',4242082,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219722',4242083,'2696','405',322477.59,322477.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219722',4242084,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219722',4242085,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219722',4242086,'2699','405',172231.06,175750.52,3519.46,580710.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','219722',4242087,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219722',4242088,'2701','405',461923.78,464008.91,2085.13,344046.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','219722',4242089,'2702','406',58906.17,61589.71,2683.54,791644.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','219722',4242090,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','219722',4242091,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219861',4244463,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219861',4244464,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219861',4244465,'2696','405',322477.59,322477.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','219861',4244466,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219861',4244467,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219861',4244468,'2699','405',175750.52,178261.05,2510.53,414237.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','219861',4244469,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','219861',4244470,'2701','405',464008.91,466258.95,2250.04,371256.60,0.00,0.00,0.00,0.00,0.00),('5','172','913','219861',4244471,'2702','406',61589.71,68634.76,7045.05,2078289.75,0.00,0.00,0.00,0.00,0.00),('5','172','914','219861',4244472,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','219861',4244473,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220113',4249074,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220113',4249075,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220113',4249076,'2696','405',322477.59,322608.42,130.83,21586.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','220113',4249077,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220113',4249078,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220113',4249079,'2699','405',178261.05,181696.71,3435.66,566883.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','220113',4249080,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220113',4249081,'2701','405',466258.95,467917.24,1658.29,273617.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','220113',4249082,'2702','406',68634.76,71179.96,2545.20,750834.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','220113',4249083,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','220113',4249084,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220317',4252580,'2694','405',485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220317',4252581,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220317',4252582,'2696','405',322608.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220317',4252583,'2697','405',255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220317',4252584,'2698','405',299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220317',4252585,'2699','405',181696.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220317',4252586,'2700','405',4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220317',4252587,'2701','405',467917.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','220317',4252588,'2702','406',71179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','220317',4252589,'2703','406',844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','220317',4252590,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220399',4254319,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220399',4254320,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220399',4254321,'2696','405',322608.42,322608.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220399',4254322,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220399',4254323,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220399',4254324,'2699','405',181696.71,184123.06,2426.35,393068.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','220399',4254325,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220399',4254326,'2701','405',467917.24,471314.25,3397.01,550315.62,0.00,0.00,0.00,0.00,0.00),('5','172','913','220399',4254327,'2702','406',71179.96,73855.17,2675.21,775810.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','220399',4254328,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','220399',4254329,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220539',4256655,'2694','405',485523.83,485523.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220539',4256656,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220539',4256657,'2696','405',322608.42,322975.16,366.74,59411.88,0.00,0.00,0.00,0.00,0.00),('5','172','911','220539',4256658,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220539',4256659,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220539',4256660,'2699','405',184123.06,186209.10,2086.04,337938.48,0.00,0.00,0.00,0.00,0.00),('5','172','912','220539',4256661,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220539',4256662,'2701','405',471314.25,473879.79,2565.54,415617.48,0.00,0.00,0.00,0.00,0.00),('5','172','913','220539',4256663,'2702','406',73855.17,76735.21,2880.04,835211.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','220539',4256664,'2703','406',844451.82,844451.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','220539',4256665,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220854',4262321,'2694','405',485523.83,488625.06,3101.23,502399.26,0.00,0.00,0.00,0.00,0.00),('5','172','911','220854',4262322,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220854',4262323,'2696','405',322975.16,325640.47,2665.31,431780.22,0.00,0.00,0.00,0.00,0.00),('5','172','911','220854',4262324,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220854',4262325,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220854',4262326,'2699','405',186209.10,186251.13,42.03,6808.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','220854',4262327,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220854',4262328,'2701','405',473879.79,473969.80,90.01,14581.62,0.00,0.00,0.00,0.00,0.00),('5','172','913','220854',4262329,'2702','406',76735.21,79438.78,2703.57,784035.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','220854',4262330,'2703','406',844451.82,844866.30,414.48,120199.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','220854',4262331,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220994',4264676,'2694','405',488625.06,491648.00,3022.94,489716.28,0.00,0.00,0.00,0.00,0.00),('5','172','911','220994',4264677,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','220994',4264678,'2696','405',325640.47,328632.05,2991.58,484635.96,0.00,0.00,0.00,0.00,0.00),('5','172','911','220994',4264679,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220994',4264680,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220994',4264681,'2699','405',186251.13,186251.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220994',4264682,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','220994',4264683,'2701','405',473969.80,473969.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','220994',4264684,'2702','406',79438.78,82167.17,2728.39,791233.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','220994',4264685,'2703','406',844866.30,844866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','220994',4264686,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221207',4268331,'2694','405',491648.00,494569.77,2921.77,473326.74,0.00,0.00,0.00,0.00,0.00),('5','172','911','221207',4268332,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221207',4268333,'2696','405',328632.05,331646.92,3014.87,488408.94,0.00,0.00,0.00,0.00,0.00),('5','172','911','221207',4268334,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221207',4268335,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221207',4268336,'2699','405',186251.13,186251.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221207',4268337,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221207',4268338,'2701','405',473969.80,473969.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','221207',4268339,'2702','406',82167.17,85922.26,3755.09,1088976.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','221207',4268340,'2703','406',844866.30,845378.29,511.99,148477.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','221207',4268341,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221450',4272724,'2694','405',494569.77,495069.41,499.64,80941.68,0.00,0.00,0.00,0.00,0.00),('5','172','911','221450',4272725,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221450',4272726,'2696','405',331646.92,332775.44,1128.52,182820.24,0.00,0.00,0.00,0.00,0.00),('5','172','911','221450',4272727,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221450',4272728,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221450',4272729,'2699','405',186251.13,187353.03,1101.90,178507.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','221450',4272730,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221450',4272731,'2701','405',473969.80,475577.63,1607.83,260468.46,0.00,0.00,0.00,0.00,0.00),('5','172','913','221450',4272732,'2702','406',85922.26,86447.69,525.43,152374.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','221450',4272733,'2703','406',845378.29,848178.24,2799.95,811985.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','221450',4272734,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221703',4277475,'2694','405',495069.41,498503.97,3434.56,556398.72,0.00,0.00,0.00,0.00,0.00),('5','172','911','221703',4277476,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221703',4277477,'2696','405',332775.44,335610.07,2834.63,459210.06,0.00,0.00,0.00,0.00,0.00),('5','172','911','221703',4277478,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221703',4277479,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221703',4277480,'2699','405',187353.03,187353.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221703',4277481,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221703',4277482,'2701','405',475577.63,475577.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','221703',4277483,'2702','406',86447.69,88363.00,1915.31,555439.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','221703',4277484,'2703','406',848178.24,848899.11,720.87,209052.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','221703',4277485,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221903',4280874,'2694','405',498503.97,502406.66,3902.69,632235.78,0.00,0.00,0.00,0.00,0.00),('5','172','911','221903',4280875,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','221903',4280876,'2696','405',335610.07,339222.77,3612.70,585257.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','221903',4280877,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221903',4280878,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221903',4280879,'2699','405',187353.03,187353.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221903',4280880,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','221903',4280881,'2701','405',475577.63,476458.25,880.62,142660.44,0.00,0.00,0.00,0.00,0.00),('5','172','913','221903',4280882,'2702','406',88363.00,89618.36,1255.36,364054.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','221903',4280883,'2703','406',848899.11,849699.79,800.68,232197.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','221903',4280884,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222104',4284626,'2694','405',502406.66,505363.84,2957.18,479063.16,0.00,0.00,0.00,0.00,0.00),('5','172','911','222104',4284627,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222104',4284628,'2696','405',339222.77,341972.04,2749.27,445381.74,0.00,0.00,0.00,0.00,0.00),('5','172','911','222104',4284629,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222104',4284630,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222104',4284631,'2699','405',187353.03,187643.30,290.27,47023.74,0.00,0.00,0.00,0.00,0.00),('5','172','912','222104',4284632,'2700','405',4858.64,4858.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222104',4284633,'2701','405',476458.25,476951.12,492.87,79844.94,0.00,0.00,0.00,0.00,0.00),('5','172','913','222104',4284634,'2702','406',89618.36,91904.56,2286.20,662998.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','222104',4284635,'2703','406',849699.79,850022.21,322.42,93501.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','222104',4284636,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222376',4289172,'2694','405',505363.84,505363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222376',4289173,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222376',4289174,'2696','405',341972.04,341972.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222376',4289175,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222376',4289176,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222376',4289177,'2699','405',187643.30,191063.88,3420.58,554133.96,0.00,0.00,0.00,0.00,0.00),('5','172','912','222376',4289178,'2700','405',4858.64,7543.40,2684.76,434931.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','222376',4289179,'2701','405',476951.12,477535.91,584.79,94735.98,0.00,0.00,0.00,0.00,0.00),('5','172','913','222376',4289180,'2702','406',91904.56,91910.05,5.49,1592.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','222376',4289181,'2703','406',850022.21,853398.53,3376.32,979132.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','222376',4289182,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222546',4292100,'2694','405',505363.84,505363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222546',4292101,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222546',4292102,'2696','405',341972.04,341972.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222546',4292103,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222546',4292104,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222546',4292105,'2699','405',191063.88,195478.45,4414.57,715160.34,0.00,0.00,0.00,0.00,0.00),('5','172','912','222546',4292106,'2700','405',7543.40,12127.71,4584.31,742658.22,0.00,0.00,0.00,0.00,0.00),('5','172','912','222546',4292107,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','222546',4292108,'2702','406',91910.05,91916.97,6.92,2006.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','222546',4292109,'2703','406',853398.53,856818.69,3420.16,991846.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','222546',4292110,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222873',4298408,'2694','405',505363.84,505363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222873',4298409,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222873',4298410,'2696','405',341972.04,341972.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','222873',4298411,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222873',4298412,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','222873',4298413,'2699','405',195478.45,199692.65,4214.20,682700.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','222873',4298414,'2700','405',12127.71,15804.22,3676.51,595594.62,0.00,0.00,0.00,0.00,0.00),('5','172','912','222873',4298415,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','222873',4298416,'2702','406',91916.97,91954.97,38.00,11020.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','222873',4298417,'2703','406',856818.69,860954.39,4135.70,1199353.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','222873',4298418,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223002',4300794,'2694','405',505363.84,505363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223002',4300795,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223002',4300796,'2696','405',341972.04,341972.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223002',4300797,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223002',4300798,'2698','405',299414.11,299414.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223002',4300799,'2699','405',199692.65,203157.43,3464.78,561294.36,0.00,0.00,0.00,0.00,0.00),('5','172','912','223002',4300800,'2700','405',15804.22,18977.58,3173.36,514084.32,0.00,0.00,0.00,0.00,0.00),('5','172','912','223002',4300801,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','223002',4300802,'2702','406',91954.97,91994.97,40.00,11600.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','223002',4300803,'2703','406',860954.39,865752.19,4797.80,1391362.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','223002',4300804,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223343',4306280,'2694','405',505363.84,505363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223343',4306281,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223343',4306282,'2696','405',341972.04,341976.20,4.16,673.92,0.00,0.00,0.00,0.00,0.00),('5','172','911','223343',4306283,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223343',4306284,'2698','405',299414.11,299423.58,9.47,1534.14,0.00,0.00,0.00,0.00,0.00),('5','172','912','223343',4306285,'2699','405',203157.43,206020.28,2862.85,463781.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','223343',4306286,'2700','405',18977.58,21816.60,2839.02,459921.24,0.00,0.00,0.00,0.00,0.00),('5','172','912','223343',4306287,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','223343',4306288,'2702','406',91994.97,91998.95,3.98,1154.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','223343',4306289,'2703','406',865752.19,869424.97,3672.78,1065106.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','223343',4306290,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223683',4312636,'2694','405',505363.84,507720.98,2357.14,381856.68,0.00,0.00,0.00,0.00,0.00),('5','172','911','223683',4312637,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223683',4312638,'2696','405',341976.20,345025.10,3048.90,493921.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','223683',4312639,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223683',4312640,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223683',4312641,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223683',4312642,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223683',4312643,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','223683',4312644,'2702','406',91998.95,91998.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','223683',4312645,'2703','406',869424.97,872865.61,3440.64,997785.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','223683',4312646,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223690',4312717,'2694','405',507720.98,511343.73,3622.75,586885.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','223690',4312718,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223690',4312719,'2696','405',345025.10,348838.01,3812.91,617691.42,0.00,0.00,0.00,0.00,0.00),('5','172','911','223690',4312720,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223690',4312721,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223690',4312722,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223690',4312723,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223690',4312724,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','223690',4312725,'2702','406',91998.95,91998.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','223690',4312726,'2703','406',872865.61,876136.13,3270.52,948450.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','223690',4312727,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223901',4316722,'2694','405',511343.73,513962.19,2618.46,424190.52,0.00,0.00,0.00,0.00,0.00),('5','172','911','223901',4316723,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','223901',4316724,'2696','405',348838.01,351703.02,2865.01,464131.62,0.00,0.00,0.00,0.00,0.00),('5','172','911','223901',4316725,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223901',4316726,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223901',4316727,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223901',4316728,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','223901',4316729,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','223901',4316730,'2702','406',91998.95,91998.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','223901',4316731,'2703','406',876136.13,878661.89,2525.76,732470.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','223901',4316732,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224150',4320968,'2694','405',513962.19,519183.16,5220.97,845797.14,0.00,0.00,0.00,0.00,0.00),('5','172','911','224150',4320969,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224150',4320970,'2696','405',351703.02,355111.27,3408.25,552136.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','224150',4320971,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224150',4320972,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224150',4320973,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224150',4320974,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224150',4320975,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','224150',4320976,'2702','406',91998.95,91998.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','224150',4320977,'2703','406',878661.89,882505.23,3843.34,1114568.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','224150',4320978,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224375',4325060,'2694','405',519183.16,520049.77,866.61,140390.82,0.00,0.00,0.00,0.00,0.00),('5','172','911','224375',4325061,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224375',4325062,'2696','405',355111.27,355850.70,739.43,119787.66,0.00,0.00,0.00,0.00,0.00),('5','172','911','224375',4325063,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224375',4325064,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224375',4325065,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224375',4325066,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224375',4325067,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','224375',4325068,'2702','406',91998.95,92002.47,3.52,1020.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','224375',4325069,'2703','406',882505.23,883002.96,497.73,144341.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','224375',4325070,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224816',4332743,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224816',4332744,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224816',4332745,'2696','405',355850.70,355850.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224816',4332746,'2697','405',255020.15,255020.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224816',4332747,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224816',4332748,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224816',4332749,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224816',4332750,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','224816',4332751,'2702','406',92002.47,92002.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','224816',4332752,'2703','406',883002.96,883002.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','224816',4332753,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224818',4332762,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224818',4332763,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','224818',4332764,'2696','405',355850.70,362050.81,6200.11,1004417.82,0.00,0.00,0.00,0.00,0.00),('5','172','911','224818',4332765,'2697','405',255020.15,255548.34,528.19,85566.78,0.00,0.00,0.00,0.00,0.00),('5','172','912','224818',4332766,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224818',4332767,'2699','405',206020.28,206020.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224818',4332768,'2700','405',21816.60,21816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','224818',4332769,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','224818',4332770,'2702','406',92002.47,92002.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','224818',4332771,'2703','406',883002.96,884651.28,1648.32,478012.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','224818',4332772,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225070',4337330,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225070',4337331,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225070',4337332,'2696','405',362050.81,363198.60,1147.79,185941.98,0.00,0.00,0.00,0.00,0.00),('5','172','911','225070',4337333,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225070',4337334,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225070',4337335,'2699','405',206020.28,208500.50,2480.22,401795.64,0.00,0.00,0.00,0.00,0.00),('5','172','912','225070',4337336,'2700','405',21816.60,24415.69,2599.09,421052.58,0.00,0.00,0.00,0.00,0.00),('5','172','912','225070',4337337,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','225070',4337338,'2702','406',92002.47,92170.33,167.86,48679.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','225070',4337339,'2703','406',884651.28,887327.78,2676.50,776185.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','225070',4337340,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225321',4341795,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225321',4341796,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225321',4341797,'2696','405',363198.60,363198.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225321',4341798,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225321',4341799,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225321',4341800,'2699','405',208500.50,211246.65,2746.15,444876.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','225321',4341801,'2700','405',24415.69,27887.55,3471.86,562441.32,0.00,0.00,0.00,0.00,0.00),('5','172','912','225321',4341802,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','225321',4341803,'2702','406',92170.33,92173.38,3.05,884.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','225321',4341804,'2703','406',887327.78,891602.92,4275.14,1239790.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','225321',4341805,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225805',4350444,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225805',4350445,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225805',4350446,'2696','405',363198.60,363198.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225805',4350447,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225805',4350448,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225805',4350449,'2699','405',211246.65,214135.95,2889.30,468066.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','225805',4350450,'2700','405',27887.55,31480.58,3593.03,582070.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','225805',4350451,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','225805',4350452,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','225805',4350453,'2703','406',891602.92,896510.82,4907.90,1423291.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','225805',4350454,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225928',4352795,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225928',4352796,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225928',4352797,'2696','405',363198.60,363198.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','225928',4352798,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225928',4352799,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','225928',4352800,'2699','405',214135.95,217272.51,3136.56,508122.72,0.00,0.00,0.00,0.00,0.00),('5','172','912','225928',4352801,'2700','405',31480.58,34831.34,3350.76,542823.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','225928',4352802,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','225928',4352803,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','225928',4352804,'2703','406',896510.82,899706.95,3196.13,926877.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','225928',4352805,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226133',4356353,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226133',4356354,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226133',4356355,'2696','405',363198.60,366123.72,2925.12,473869.44,0.00,0.00,0.00,0.00,0.00),('5','172','911','226133',4356356,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226133',4356357,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226133',4356358,'2699','405',217272.51,217527.26,254.75,41269.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','226133',4356359,'2700','405',34831.34,37969.35,3138.01,508357.62,0.00,0.00,0.00,0.00,0.00),('5','172','912','226133',4356360,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','226133',4356361,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','226133',4356362,'2703','406',899706.95,902889.48,3182.53,922933.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','226133',4356363,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226272',4358891,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226272',4358892,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226272',4358893,'2696','405',366123.72,370420.97,4297.25,696154.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','226272',4358894,'2697','405',255548.34,255548.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226272',4358895,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226272',4358896,'2699','405',217527.26,217527.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226272',4358897,'2700','405',37969.35,40014.60,2045.25,331330.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','226272',4358898,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','226272',4358899,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','226272',4358900,'2703','406',902889.48,906142.64,3253.16,943416.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','226272',4358901,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226567',4363987,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226567',4363988,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226567',4363989,'2696','405',370420.97,376745.36,6324.39,1024551.18,0.00,0.00,0.00,0.00,0.00),('5','172','911','226567',4363990,'2697','405',255548.34,255739.11,190.77,30904.74,0.00,0.00,0.00,0.00,0.00),('5','172','912','226567',4363991,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226567',4363992,'2699','405',217527.26,217527.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226567',4363993,'2700','405',40014.60,40014.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226567',4363994,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','226567',4363995,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','226567',4363996,'2703','406',906142.64,910143.86,4001.22,1160353.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','226567',4363997,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226910',4370594,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226910',4370595,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','226910',4370596,'2696','405',376745.36,377935.98,1190.62,192880.44,0.00,0.00,0.00,0.00,0.00),('5','172','911','226910',4370597,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226910',4370598,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','226910',4370599,'2699','405',217527.26,219331.23,1803.97,292243.14,0.00,0.00,0.00,0.00,0.00),('5','172','912','226910',4370600,'2700','405',40014.60,41909.66,1895.06,306999.72,0.00,0.00,0.00,0.00,0.00),('5','172','912','226910',4370601,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','226910',4370602,'2702','406',92173.38,92173.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','226910',4370603,'2703','406',910143.86,912844.32,2700.46,783133.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','226910',4370604,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227035',4372386,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227035',4372387,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227035',4372388,'2696','405',377935.98,379760.41,1824.43,295557.66,0.00,0.00,0.00,0.00,0.00),('5','172','911','227035',4372389,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227035',4372390,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227035',4372391,'2699','405',219331.23,220472.37,1141.14,184864.68,0.00,0.00,0.00,0.00,0.00),('5','172','912','227035',4372392,'2700','405',41909.66,43167.45,1257.79,203761.98,0.00,0.00,0.00,0.00,0.00),('5','172','912','227035',4372393,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227035',4372394,'2702','406',92173.38,94775.16,2601.78,754516.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','227035',4372395,'2703','406',912844.32,914128.19,1283.87,372322.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','227035',4372396,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227244',4376029,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227244',4376030,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227244',4376031,'2696','405',379760.41,383254.64,3494.23,566065.26,0.00,0.00,0.00,0.00,0.00),('5','172','911','227244',4376032,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227244',4376033,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227244',4376034,'2699','405',220472.37,222107.65,1635.28,264915.36,0.00,0.00,0.00,0.00,0.00),('5','172','912','227244',4376035,'2700','405',43167.45,43167.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227244',4376036,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227244',4376037,'2702','406',94775.16,95884.76,1109.60,321784.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','227244',4376038,'2703','406',914128.19,914128.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','227244',4376039,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227454',4380010,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227454',4380011,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227454',4380012,'2696','405',383254.64,386090.39,2835.75,459391.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','227454',4380013,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227454',4380014,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227454',4380015,'2699','405',222107.65,223974.85,1867.20,302486.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','227454',4380016,'2700','405',43167.45,43167.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227454',4380017,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227454',4380018,'2702','406',95884.76,97037.48,1152.72,334288.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','227454',4380019,'2703','406',914128.19,914162.67,34.48,9999.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','227454',4380020,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227734',4384819,'2694','405',520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227734',4384820,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227734',4384821,'2696','405',386090.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227734',4384822,'2697','405',255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227734',4384823,'2698','405',299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227734',4384824,'2699','405',223974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227734',4384825,'2700','405',43167.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227734',4384826,'2701','405',477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227734',4384827,'2702','406',97037.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','227734',4384828,'2703','406',914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','227734',4384829,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227974',4389212,'2694','405',520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227974',4389213,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227974',4389214,'2696','405',386090.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227974',4389215,'2697','405',255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227974',4389216,'2698','405',299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227974',4389217,'2699','405',223974.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227974',4389218,'2700','405',43167.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227974',4389219,'2701','405',477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227974',4389220,'2702','406',97037.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','227974',4389221,'2703','406',914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','227974',4389222,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227977',4389240,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227977',4389241,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227977',4389242,'2696','405',386090.39,389807.63,3717.24,602192.88,0.00,0.00,0.00,0.00,0.00),('5','172','911','227977',4389243,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227977',4389244,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227977',4389245,'2699','405',223974.85,225633.23,1658.38,268657.56,0.00,0.00,0.00,0.00,0.00),('5','172','912','227977',4389246,'2700','405',43167.45,43167.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227977',4389247,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227977',4389248,'2702','406',97037.48,98849.31,1811.83,543549.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','227977',4389249,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','227977',4389250,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227981',4389320,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227981',4389321,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227981',4389322,'2696','405',389807.63,391764.13,1956.50,316953.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','227981',4389323,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227981',4389324,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','227981',4389325,'2699','405',225633.23,227241.62,1608.39,260559.18,0.00,0.00,0.00,0.00,0.00),('5','172','912','227981',4389326,'2700','405',43167.45,44200.67,1033.22,167381.64,0.00,0.00,0.00,0.00,0.00),('5','172','912','227981',4389327,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','227981',4389328,'2702','406',98849.31,101229.02,2379.71,713913.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','227981',4389329,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','227981',4389330,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','229290',4414131,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','229290',4414132,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','229290',4414133,'2696','405',391764.13,394630.25,2866.12,464311.44,0.00,0.00,0.00,0.00,0.00),('5','172','911','229290',4414134,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','229290',4414135,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','229290',4414136,'2699','405',227241.62,229723.47,2481.85,402059.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','229290',4414137,'2700','405',44200.67,46119.84,1919.17,310905.54,0.00,0.00,0.00,0.00,0.00),('5','172','912','229290',4414138,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','229290',4414139,'2702','406',101229.02,105294.33,4065.31,1219593.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','229290',4414140,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','229290',4414141,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230022',4428173,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230022',4428174,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230022',4428175,'2696','405',394630.25,394630.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230022',4428176,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230022',4428177,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230022',4428178,'2699','405',229723.47,232285.04,2561.57,414974.34,0.00,0.00,0.00,0.00,0.00),('5','172','912','230022',4428179,'2700','405',46119.84,49532.12,3412.28,552789.36,0.00,0.00,0.00,0.00,0.00),('5','172','912','230022',4428180,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230022',4428181,'2702','406',105294.33,111248.57,5954.24,1786272.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230022',4428182,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230022',4428183,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230031',4428325,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230031',4428326,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230031',4428327,'2696','405',394630.25,395683.20,1052.95,170577.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','230031',4428328,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230031',4428329,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230031',4428330,'2699','405',232285.04,236267.69,3982.65,645189.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','230031',4428331,'2700','405',49532.12,50625.56,1093.44,177137.28,0.00,0.00,0.00,0.00,0.00),('5','172','912','230031',4428332,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230031',4428333,'2702','406',111248.57,116541.41,5292.84,1640780.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','230031',4428334,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230031',4428335,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230037',4428481,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230037',4428482,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230037',4428483,'2696','405',395683.20,395683.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230037',4428484,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230037',4428485,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230037',4428486,'2699','405',236267.69,237979.86,1712.17,277371.54,0.00,0.00,0.00,0.00,0.00),('5','172','912','230037',4428487,'2700','405',50625.56,52304.20,1678.64,271939.68,0.00,0.00,0.00,0.00,0.00),('5','172','912','230037',4428488,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230037',4428489,'2702','406',116541.41,119809.55,3268.14,1013123.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','230037',4428490,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230037',4428491,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230103',4429481,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230103',4429482,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230103',4429483,'2696','405',395683.20,395683.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230103',4429484,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230103',4429485,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230103',4429486,'2699','405',237979.86,241916.10,3936.24,637670.88,0.00,0.00,0.00,0.00,0.00),('5','172','912','230103',4429487,'2700','405',52304.20,56473.67,4169.47,675454.14,0.00,0.00,0.00,0.00,0.00),('5','172','912','230103',4429488,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230103',4429489,'2702','406',119809.55,124076.43,4266.88,1280064.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230103',4429490,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230103',4429491,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230104',4429492,'2694','405',520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230104',4429493,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230104',4429494,'2696','405',395683.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230104',4429495,'2697','405',255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230104',4429496,'2698','405',299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230104',4429497,'2699','405',241916.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230104',4429498,'2700','405',56473.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230104',4429499,'2701','405',477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230104',4429500,'2702','406',124076.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230104',4429501,'2703','406',914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230104',4429502,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230116',4429677,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230116',4429678,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230116',4429679,'2696','405',395683.20,395683.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230116',4429680,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230116',4429681,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230116',4429682,'2699','405',241916.10,244948.22,3032.12,491203.44,0.00,0.00,0.00,0.00,0.00),('5','172','912','230116',4429683,'2700','405',56473.67,59424.13,2950.46,477974.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','230116',4429684,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230116',4429685,'2702','406',124076.43,128319.99,4243.56,1273068.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230116',4429686,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230116',4429687,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230131',4429911,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230131',4429912,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230131',4429913,'2696','405',395683.20,395683.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230131',4429914,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230131',4429915,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230131',4429916,'2699','405',244948.22,248285.04,3336.82,540564.84,0.00,0.00,0.00,0.00,0.00),('5','172','912','230131',4429917,'2700','405',59424.13,62114.71,2690.58,435873.96,0.00,0.00,0.00,0.00,0.00),('5','172','912','230131',4429918,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230131',4429919,'2702','406',128319.99,131481.71,3161.72,980133.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','230131',4429920,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230131',4429921,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230136',4430018,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230136',4430019,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230136',4430020,'2696','405',395683.20,397322.33,1639.13,265539.06,0.00,0.00,0.00,0.00,0.00),('5','172','911','230136',4430021,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230136',4430022,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230136',4430023,'2699','405',248285.04,251805.71,3520.67,570348.54,0.00,0.00,0.00,0.00,0.00),('5','172','912','230136',4430024,'2700','405',62114.71,62740.06,625.35,101306.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','230136',4430025,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230136',4430026,'2702','406',131481.71,131481.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230136',4430027,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230136',4430028,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230141',4430122,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230141',4430123,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230141',4430124,'2696','405',397322.33,397322.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230141',4430125,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230141',4430126,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230141',4430127,'2699','405',251805.71,254645.64,2839.93,460068.66,0.00,0.00,0.00,0.00,0.00),('5','172','912','230141',4430128,'2700','405',62740.06,66626.06,3886.00,629532.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230141',4430129,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230141',4430130,'2702','406',131481.71,131481.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230141',4430131,'2703','406',914162.67,914162.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230141',4430132,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230144',4430185,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230144',4430186,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230144',4430187,'2696','405',397322.33,399653.60,2331.27,377665.74,0.00,0.00,0.00,0.00,0.00),('5','172','911','230144',4430188,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230144',4430189,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230144',4430190,'2699','405',254645.64,258430.86,3785.22,613205.64,0.00,0.00,0.00,0.00,0.00),('5','172','912','230144',4430191,'2700','405',66626.06,67225.02,598.96,97031.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','230144',4430192,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230144',4430193,'2702','406',131481.71,131790.93,309.22,95858.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','230144',4430194,'2703','406',914162.67,918669.21,4506.54,1397027.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','230144',4430195,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230619',4439334,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230619',4439335,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230619',4439336,'2696','405',399653.60,402602.86,2949.26,477780.12,0.00,0.00,0.00,0.00,0.00),('5','172','911','230619',4439337,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230619',4439338,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230619',4439339,'2699','405',258430.86,262821.62,4390.76,711303.12,0.00,0.00,0.00,0.00,0.00),('5','172','912','230619',4439340,'2700','405',67225.02,67534.24,309.22,50093.64,0.00,0.00,0.00,0.00,0.00),('5','172','912','230619',4439341,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230619',4439342,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230619',4439343,'2703','406',918669.21,925619.31,6950.10,2154531.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230619',4439344,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230623',4439413,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230623',4439414,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230623',4439415,'2696','405',402602.86,402602.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230623',4439416,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230623',4439417,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230623',4439418,'2699','405',262821.62,268811.31,5989.69,970329.78,0.00,0.00,0.00,0.00,0.00),('5','172','912','230623',4439419,'2700','405',67534.24,70831.04,3296.80,534081.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','230623',4439420,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230623',4439421,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230623',4439422,'2703','406',925619.31,929628.46,4009.15,1282928.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','230623',4439423,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230974',4445503,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230974',4445504,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','230974',4445505,'2696','405',402602.86,406446.56,3843.70,622679.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','230974',4445506,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230974',4445507,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','230974',4445508,'2699','405',268811.31,271976.55,3165.24,512768.88,0.00,0.00,0.00,0.00,0.00),('5','172','912','230974',4445509,'2700','405',70831.04,71768.43,937.39,151857.18,0.00,0.00,0.00,0.00,0.00),('5','172','912','230974',4445510,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','230974',4445511,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','230974',4445512,'2703','406',929628.46,936672.48,7044.02,2254086.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','230974',4445513,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231115',4447817,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231115',4447818,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231115',4447819,'2696','405',406446.56,409581.87,3135.31,507920.22,0.00,0.00,0.00,0.00,0.00),('5','172','911','231115',4447820,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231115',4447821,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231115',4447822,'2699','405',271976.55,271976.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231115',4447823,'2700','405',71768.43,74799.39,3030.96,491015.52,0.00,0.00,0.00,0.00,0.00),('5','172','912','231115',4447824,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','231115',4447825,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','231115',4447826,'2703','406',936672.48,941445.03,4772.55,1527216.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','231115',4447827,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231542',4454735,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231542',4454736,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231542',4454737,'2696','405',409581.87,410707.90,1126.03,182416.86,0.00,0.00,0.00,0.00,0.00),('5','172','911','231542',4454738,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231542',4454739,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231542',4454740,'2699','405',271976.55,271976.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231542',4454741,'2700','405',74799.39,75482.92,683.53,110731.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','231542',4454742,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','231542',4454743,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','231542',4454744,'2703','406',941445.03,945552.68,4107.65,1314448.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','231542',4454745,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231747',4458440,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231747',4458441,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231747',4458442,'2696','405',410707.90,410707.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','231747',4458443,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231747',4458444,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231747',4458445,'2699','405',271976.55,271976.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231747',4458446,'2700','405',75482.92,75482.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','231747',4458447,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','231747',4458448,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','231747',4458449,'2703','406',945552.68,952242.75,6690.07,2140822.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','231747',4458450,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232006',4463120,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232006',4463121,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232006',4463122,'2696','405',410707.90,410707.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232006',4463123,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232006',4463124,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232006',4463125,'2699','405',271976.55,271976.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232006',4463126,'2700','405',75482.92,75482.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232006',4463127,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','232006',4463128,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','232006',4463129,'2703','406',952242.75,953927.36,1684.61,550867.47,0.00,0.00,0.00,0.00,0.00),('5','172','915','232006',4463130,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232284',4468254,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232284',4468255,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232284',4468256,'2696','405',410707.90,412685.22,1977.32,320325.84,0.00,0.00,0.00,0.00,0.00),('5','172','911','232284',4468257,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232284',4468258,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232284',4468259,'2699','405',271976.55,273460.85,1484.30,240456.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','232284',4468260,'2700','405',75482.92,76977.82,1494.90,242173.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','232284',4468261,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','232284',4468262,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','232284',4468263,'2703','406',953927.36,953927.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','232284',4468264,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232506',4472196,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232506',4472197,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232506',4472198,'2696','405',412685.22,414767.02,2081.80,337251.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','232506',4472199,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232506',4472200,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232506',4472201,'2699','405',273460.85,275780.72,2319.87,375818.94,0.00,0.00,0.00,0.00,0.00),('5','172','912','232506',4472202,'2700','405',76977.82,79524.34,2546.52,412536.24,0.00,0.00,0.00,0.00,0.00),('5','172','912','232506',4472203,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','232506',4472204,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','232506',4472205,'2703','406',953927.36,953927.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','232506',4472206,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232623',4474078,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232623',4474079,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232623',4474080,'2696','405',414767.02,417405.86,2638.84,427492.08,0.00,0.00,0.00,0.00,0.00),('5','172','911','232623',4474081,'2697','405',255739.11,255739.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232623',4474082,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232623',4474083,'2699','405',275780.72,276804.89,1024.17,165915.54,0.00,0.00,0.00,0.00,0.00),('5','172','912','232623',4474084,'2700','405',79524.34,81856.93,2332.59,377879.58,0.00,0.00,0.00,0.00,0.00),('5','172','912','232623',4474085,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','232623',4474086,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','232623',4474087,'2703','406',953927.36,953927.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','232623',4474088,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232923',4479546,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232923',4479547,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','232923',4479548,'2696','405',417405.86,419724.43,2318.57,375608.34,0.00,0.00,0.00,0.00,0.00),('5','172','911','232923',4479549,'2697','405',255739.11,255858.96,119.85,19415.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','232923',4479550,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','232923',4479551,'2699','405',276804.89,278626.23,1821.34,295057.08,0.00,0.00,0.00,0.00,0.00),('5','172','912','232923',4479552,'2700','405',81856.93,82699.08,842.15,136428.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','232923',4479553,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','232923',4479554,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','232923',4479555,'2703','406',953927.36,954527.38,600.02,198006.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','232923',4479556,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233182',4484246,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233182',4484247,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233182',4484248,'2696','405',419724.43,422177.63,2453.20,397418.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','233182',4484249,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233182',4484250,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233182',4484251,'2699','405',278626.23,279775.26,1149.03,186142.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','233182',4484252,'2700','405',82699.08,85664.78,2965.70,480443.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','233182',4484253,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','233182',4484254,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','233182',4484255,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','233182',4484256,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233446',4488895,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233446',4488896,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233446',4488897,'2696','405',422177.63,424817.55,2639.92,427667.04,0.00,0.00,0.00,0.00,0.00),('5','172','911','233446',4488898,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233446',4488899,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233446',4488900,'2699','405',279775.26,282455.87,2680.61,434258.82,0.00,0.00,0.00,0.00,0.00),('5','172','912','233446',4488901,'2700','405',85664.78,87340.03,1675.25,271390.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','233446',4488902,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','233446',4488903,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','233446',4488904,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','233446',4488905,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233694',4493401,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233694',4493402,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233694',4493403,'2696','405',424817.55,427694.89,2877.34,466129.08,0.00,0.00,0.00,0.00,0.00),('5','172','911','233694',4493404,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233694',4493405,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233694',4493406,'2699','405',282455.87,283807.89,1352.02,219027.24,0.00,0.00,0.00,0.00,0.00),('5','172','912','233694',4493407,'2700','405',87340.03,89069.13,1729.10,280114.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','233694',4493408,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','233694',4493409,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','233694',4493410,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','233694',4493411,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233893',4497072,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233893',4497073,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','233893',4497074,'2696','405',427694.89,430796.76,3101.87,502502.94,0.00,0.00,0.00,0.00,0.00),('5','172','911','233893',4497075,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233893',4497076,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','233893',4497077,'2699','405',283807.89,287048.14,3240.25,524920.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','233893',4497078,'2700','405',89069.13,91046.16,1977.03,320278.86,0.00,0.00,0.00,0.00,0.00),('5','172','912','233893',4497079,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','233893',4497080,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','233893',4497081,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','233893',4497082,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234200',4502836,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234200',4502837,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234200',4502838,'2696','405',430796.76,434716.26,3919.50,634959.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234200',4502839,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234200',4502840,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234200',4502841,'2699','405',287048.14,290367.19,3319.05,537686.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','234200',4502842,'2700','405',91046.16,92688.88,1642.72,266120.64,0.00,0.00,0.00,0.00,0.00),('5','172','912','234200',4502843,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','234200',4502844,'2702','406',131790.93,131790.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','234200',4502845,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','234200',4502846,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234420',4506683,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234420',4506684,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234420',4506685,'2696','405',434716.26,438285.38,3569.12,588904.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','234420',4506686,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234420',4506687,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234420',4506688,'2699','405',290367.19,293145.88,2778.69,458483.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','234420',4506689,'2700','405',92688.88,92688.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234420',4506690,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','234420',4506691,'2702','406',131790.93,134022.29,2231.36,769819.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','234420',4506692,'2703','406',954527.38,954527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','234420',4506693,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234668',4511102,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234668',4511103,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234668',4511104,'2696','405',438285.38,441759.48,3474.10,573226.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','234668',4511105,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234668',4511106,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234668',4511107,'2699','405',293145.88,294032.55,886.67,146300.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','234668',4511108,'2700','405',92688.88,94705.65,2016.77,332767.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','234668',4511109,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','234668',4511110,'2702','406',134022.29,136399.65,2377.36,820189.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','234668',4511111,'2703','406',954527.38,954529.93,2.55,879.75,0.00,0.00,0.00,0.00,0.00),('5','172','915','234668',4511112,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234976',4516632,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234976',4516633,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','234976',4516634,'2696','405',441759.48,446683.07,4923.59,812392.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','234976',4516635,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234976',4516636,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','234976',4516637,'2699','405',294032.55,296230.17,2197.62,362607.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','234976',4516638,'2700','405',94705.65,96326.84,1621.19,267496.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','234976',4516639,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','234976',4516640,'2702','406',136399.65,138978.54,2578.89,889717.05,0.00,0.00,0.00,0.00,0.00),('5','172','914','234976',4516641,'2703','406',954529.93,954529.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','234976',4516642,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235145',4519502,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235145',4519503,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235145',4519504,'2696','405',446683.07,455290.90,8607.83,1420291.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','235145',4519505,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235145',4519506,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235145',4519507,'2699','405',296230.17,296503.07,272.90,45028.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','235145',4519508,'2700','405',96326.84,96457.43,130.59,21547.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','235145',4519509,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','235145',4519510,'2702','406',138978.54,145761.50,6782.96,2306206.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','235145',4519511,'2703','406',954529.93,954529.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','235145',4519512,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235616',4527582,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235616',4527583,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235616',4527584,'2696','405',455290.90,455290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235616',4527585,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235616',4527586,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235616',4527587,'2699','405',296503.07,296503.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235616',4527588,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235616',4527589,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','235616',4527590,'2702','406',145761.50,150485.46,4723.96,1606146.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','235616',4527591,'2703','406',954529.93,954529.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','235616',4527592,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235748',4530100,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235748',4530101,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235748',4530102,'2696','405',455290.90,455290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235748',4530103,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235748',4530104,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235748',4530105,'2699','405',296503.07,296503.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235748',4530106,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235748',4530107,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','235748',4530108,'2702','406',150485.46,153490.14,3004.68,1021591.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','235748',4530109,'2703','406',954529.93,954529.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','235748',4530110,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235854',4531961,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235854',4531962,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235854',4531963,'2696','405',455290.90,455290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','235854',4531964,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235854',4531965,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235854',4531966,'2699','405',296503.07,296503.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235854',4531967,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','235854',4531968,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','235854',4531969,'2702','406',153490.14,154267.64,777.50,264350.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','235854',4531970,'2703','406',954529.93,957988.68,3458.75,1175975.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','235854',4531971,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236150',4537222,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236150',4537223,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236150',4537224,'2696','405',455290.90,455290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236150',4537225,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236150',4537226,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236150',4537227,'2699','405',296503.07,296503.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236150',4537228,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236150',4537229,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','236150',4537230,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','236150',4537231,'2703','406',957988.68,964002.60,6013.92,2044732.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','236150',4537232,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236420',4541979,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236420',4541980,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236420',4541981,'2696','405',455290.90,455290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236420',4541982,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236420',4541983,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236420',4541984,'2699','405',296503.07,296503.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236420',4541985,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236420',4541986,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','236420',4541987,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','236420',4541988,'2703','406',964002.60,971084.83,7082.23,2407958.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','236420',4541989,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236667',4546038,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236667',4546039,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236667',4546040,'2696','405',455290.90,458577.76,3286.86,542331.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','236667',4546041,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236667',4546042,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236667',4546043,'2699','405',296503.07,298320.45,1817.38,299867.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','236667',4546044,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236667',4546045,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','236667',4546046,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','236667',4546047,'2703','406',971084.83,976128.28,5043.45,1714773.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','236667',4546048,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236864',4549552,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236864',4549553,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','236864',4549554,'2696','405',458577.76,463184.71,4606.95,760146.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','236864',4549555,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236864',4549556,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236864',4549557,'2699','405',298320.45,302188.42,3867.97,638215.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','236864',4549558,'2700','405',96457.43,96457.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','236864',4549559,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','236864',4549560,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','236864',4549561,'2703','406',976128.28,977033.41,905.13,307744.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','236864',4549562,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237228',4555865,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237228',4555866,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237228',4555867,'2696','405',463184.71,465347.24,2162.53,356817.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','237228',4555868,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237228',4555869,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237228',4555870,'2699','405',302188.42,305605.40,3416.98,563801.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','237228',4555871,'2700','405',96457.43,98297.47,1840.04,303606.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','237228',4555872,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','237228',4555873,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','237228',4555874,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','237228',4555875,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237449',4560105,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237449',4560106,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237449',4560107,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237449',4560108,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237449',4560109,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237449',4560110,'2699','405',305605.40,309733.20,4127.80,681087.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237449',4560111,'2700','405',98297.47,102761.69,4464.22,736596.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','237449',4560112,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','237449',4560113,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','237449',4560114,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','237449',4560115,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237453',4560176,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237453',4560177,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237453',4560178,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237453',4560179,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237453',4560180,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237453',4560181,'2699','405',309733.20,313517.55,3784.35,624417.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','237453',4560182,'2700','405',102761.69,104246.23,1484.54,244949.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','237453',4560183,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','237453',4560184,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','237453',4560185,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','237453',4560186,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237721',4564875,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237721',4564876,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237721',4564877,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','237721',4564878,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237721',4564879,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','237721',4564880,'2699','405',313517.55,314500.21,982.66,162138.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','237721',4564881,'2700','405',104246.23,107488.66,3242.43,535000.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','237721',4564882,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','237721',4564883,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','237721',4564884,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','237721',4564885,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238048',4570023,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238048',4570024,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238048',4570025,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238048',4570026,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238048',4570027,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238048',4570028,'2699','405',314500.21,314500.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238048',4570029,'2700','405',107488.66,107488.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238048',4570030,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','238048',4570031,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','238048',4570032,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','238048',4570033,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238426',4576523,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238426',4576524,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238426',4576525,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238426',4576526,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238426',4576527,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238426',4576528,'2699','405',314500.21,314500.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238426',4576529,'2700','405',107488.66,107488.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238426',4576530,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','238426',4576531,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','238426',4576532,'2703','406',977033.41,977033.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','238426',4576533,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238443',4576764,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238443',4576765,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238443',4576766,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238443',4576767,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238443',4576768,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238443',4576769,'2699','405',314500.21,314500.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238443',4576770,'2700','405',107488.66,107488.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238443',4576771,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','238443',4576772,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','238443',4576773,'2703','406',977033.41,980821.70,3788.29,1288018.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','238443',4576774,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238708',4581250,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238708',4581251,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238708',4581252,'2696','405',465347.24,465347.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','238708',4581253,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238708',4581254,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','238708',4581255,'2699','405',314500.21,317025.47,2525.26,416667.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','238708',4581256,'2700','405',107488.66,109458.00,1969.34,324941.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','238708',4581257,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','238708',4581258,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','238708',4581259,'2703','406',980821.70,983230.87,2409.17,819117.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','238708',4581260,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239017',4586947,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239017',4586948,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239017',4586949,'2696','405',465347.24,468951.26,3604.02,594663.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','239017',4586950,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239017',4586951,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239017',4586952,'2699','405',317025.47,319171.77,2146.30,354139.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','239017',4586953,'2700','405',109458.00,110783.28,1325.28,218671.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','239017',4586954,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','239017',4586955,'2702','406',154267.64,154267.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','239017',4586956,'2703','406',983230.87,987280.20,4049.33,1376772.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','239017',4586957,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239226',4590318,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239226',4590319,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239226',4590320,'2696','405',468951.26,473604.62,4653.36,767804.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','239226',4590321,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239226',4590322,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239226',4590323,'2699','405',319171.77,322753.13,3581.36,590924.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','239226',4590324,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239226',4590325,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','239226',4590326,'2702','406',154267.64,157313.29,3045.65,1035521.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','239226',4590327,'2703','406',987280.20,987280.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','239226',4590328,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239419',4593647,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239419',4593648,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239419',4593649,'2696','405',473604.62,477414.25,3809.63,628588.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','239419',4593650,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239419',4593651,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239419',4593652,'2699','405',322753.13,326710.40,3957.27,652949.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','239419',4593653,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239419',4593654,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','239419',4593655,'2702','406',157313.29,162677.73,5364.44,1823909.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','239419',4593656,'2703','406',987280.20,987280.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','239419',4593657,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239636',4597425,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239636',4597426,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239636',4597427,'2696','405',477414.25,481509.96,4095.71,675792.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','239636',4597428,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239636',4597429,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239636',4597430,'2699','405',326710.40,330395.03,3684.63,607963.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','239636',4597431,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239636',4597432,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','239636',4597433,'2702','406',162677.73,167536.52,4858.79,1651988.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','239636',4597434,'2703','406',987280.20,987280.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','239636',4597435,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239880',4601666,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239880',4601667,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','239880',4601668,'2696','405',481509.96,486062.01,4552.05,751088.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','239880',4601669,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239880',4601670,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239880',4601671,'2699','405',330395.03,334440.11,4045.08,667438.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','239880',4601672,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','239880',4601673,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','239880',4601674,'2702','406',167536.52,168392.41,855.89,291002.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','239880',4601675,'2703','406',987280.20,991798.32,4518.12,1536160.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','239880',4601676,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240088',4605339,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240088',4605340,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240088',4605341,'2696','405',486062.01,491154.78,5092.77,840307.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','240088',4605342,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240088',4605343,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240088',4605344,'2699','405',334440.11,337864.36,3424.25,565001.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','240088',4605345,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240088',4605346,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','240088',4605347,'2702','406',168392.41,168392.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','240088',4605348,'2703','406',991798.32,995950.30,4151.98,1411673.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','240088',4605349,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240523',4612484,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240523',4612485,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240523',4612486,'2696','405',491154.78,495178.77,4023.99,663958.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','240523',4612487,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240523',4612488,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240523',4612489,'2699','405',337864.36,341175.19,3310.83,546286.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','240523',4612490,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240523',4612491,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','240523',4612492,'2702','406',168392.41,168392.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','240523',4612493,'2703','406',995950.30,1000674.46,4724.16,1606214.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','240523',4612494,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240525',4612510,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240525',4612511,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240525',4612512,'2696','405',495178.77,495310.50,131.73,21735.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','240525',4612513,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240525',4612514,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240525',4612515,'2699','405',341175.19,341916.85,741.66,122373.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','240525',4612516,'2700','405',110783.28,110783.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240525',4612517,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','240525',4612518,'2702','406',168392.41,168392.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','240525',4612519,'2703','406',1000674.46,1003387.29,2712.83,922362.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','240525',4612520,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240880',4618304,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240880',4618305,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','240880',4618306,'2696','405',495310.50,498002.58,2692.08,444193.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','240880',4618307,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240880',4618308,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240880',4618309,'2699','405',341916.85,341916.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','240880',4618310,'2700','405',110783.28,113137.97,2354.69,388523.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','240880',4618311,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','240880',4618312,'2702','406',168392.41,168392.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','240880',4618313,'2703','406',1003387.29,1008126.74,4739.45,1611413.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','240880',4618314,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241079',4621896,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241079',4621897,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241079',4621898,'2696','405',498002.58,501913.31,3910.73,645270.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','241079',4621899,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241079',4621900,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241079',4621901,'2699','405',341916.85,343878.83,1961.98,323726.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','241079',4621902,'2700','405',113137.97,114435.52,1297.55,214095.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','241079',4621903,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','241079',4621904,'2702','406',168392.41,171728.36,3335.95,1134223.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','241079',4621905,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','241079',4621906,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241314',4625978,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241314',4625979,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241314',4625980,'2696','405',501913.31,505197.25,3283.94,541850.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','241314',4625981,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241314',4625982,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241314',4625983,'2699','405',343878.83,347732.32,3853.49,635825.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','241314',4625984,'2700','405',114435.52,114435.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241314',4625985,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','241314',4625986,'2702','406',171728.36,175596.28,3867.92,1315092.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','241314',4625987,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','241314',4625988,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241599',4630861,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241599',4630862,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241599',4630863,'2696','405',505197.25,510356.55,5159.30,851284.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','241599',4630864,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241599',4630865,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241599',4630866,'2699','405',347732.32,352390.21,4657.89,768551.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','241599',4630867,'2700','405',114435.52,114435.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241599',4630868,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','241599',4630869,'2702','406',175596.28,179320.97,3724.69,1266394.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','241599',4630870,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','241599',4630871,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241882',4635665,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241882',4635666,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241882',4635667,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','241882',4635668,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241882',4635669,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','241882',4635670,'2699','405',352390.21,358323.30,5933.09,978959.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','241882',4635671,'2700','405',114435.52,117014.87,2579.35,425592.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','241882',4635672,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','241882',4635673,'2702','406',179320.97,188415.04,9094.07,3091983.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','241882',4635674,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','241882',4635675,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242115',4639892,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242115',4639893,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242115',4639894,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242115',4639895,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242115',4639896,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242115',4639897,'2699','405',358323.30,362455.10,4131.80,681747.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242115',4639898,'2700','405',117014.87,120244.14,3229.27,532829.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','242115',4639899,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','242115',4639900,'2702','406',188415.04,192616.13,4201.09,1428370.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','242115',4639901,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','242115',4639902,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242318',4643438,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242318',4643439,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242318',4643440,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242318',4643441,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242318',4643442,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242318',4643443,'2699','405',362455.10,362530.11,75.01,12376.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','242318',4643444,'2700','405',120244.14,120256.86,12.72,2098.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','242318',4643445,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','242318',4643446,'2702','406',192616.13,195992.21,3376.08,1147867.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','242318',4643447,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','242318',4643448,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242610',4648682,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242610',4648683,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242610',4648684,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242610',4648685,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242610',4648686,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242610',4648687,'2699','405',362530.11,362530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242610',4648688,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242610',4648689,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','242610',4648690,'2702','406',195992.21,200756.59,4764.38,1619889.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','242610',4648691,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','242610',4648692,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242817',4652092,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242817',4652093,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242817',4652094,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','242817',4652095,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242817',4652096,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242817',4652097,'2699','405',362530.11,362530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242817',4652098,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','242817',4652099,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','242817',4652100,'2702','406',200756.59,206223.30,5466.71,1858680.75,0.00,0.00,0.00,0.00,0.00),('5','172','914','242817',4652101,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','242817',4652102,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243008',4655389,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243008',4655390,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243008',4655391,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243008',4655392,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243008',4655393,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243008',4655394,'2699','405',362530.11,362530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243008',4655395,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243008',4655396,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','243008',4655397,'2702','406',206223.30,207829.63,1606.33,546152.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','243008',4655398,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','243008',4655399,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243458',4663448,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243458',4663449,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243458',4663450,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','243458',4663451,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243458',4663452,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243458',4663453,'2699','405',362530.11,362530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243458',4663454,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','243458',4663455,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','243458',4663456,'2702','406',207829.63,207829.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','243458',4663457,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','243458',4663458,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244189',4675995,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244189',4675996,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244189',4675997,'2696','405',510356.55,510356.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244189',4675998,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244189',4675999,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244189',4676000,'2699','405',362530.11,362530.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244189',4676001,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244189',4676002,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244189',4676003,'2702','406',207829.63,207829.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','244189',4676004,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244189',4676005,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244192',4676045,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244192',4676046,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244192',4676047,'2696','405',510356.55,513099.41,2742.86,452571.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','244192',4676048,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244192',4676049,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244192',4676050,'2699','405',362530.11,364170.94,1640.83,270736.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','244192',4676051,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244192',4676052,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244192',4676053,'2702','406',207829.63,213119.21,5289.58,1798457.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','244192',4676054,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244192',4676055,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244196',4676160,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244196',4676161,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244196',4676162,'2696','405',513099.41,516703.69,3604.28,594706.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','244196',4676163,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244196',4676164,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244196',4676165,'2699','405',364170.94,367336.22,3165.28,522271.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','244196',4676166,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244196',4676167,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244196',4676168,'2702','406',213119.21,217769.46,4650.25,1581085.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','244196',4676169,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244196',4676170,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244198',4676197,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244198',4676198,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244198',4676199,'2696','405',516703.69,520772.18,4068.49,671300.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','244198',4676200,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244198',4676201,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244198',4676202,'2699','405',367336.22,371992.70,4656.48,768319.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','244198',4676203,'2700','405',120256.86,120256.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244198',4676204,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244198',4676205,'2702','406',217769.46,222258.72,4489.26,1526348.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','244198',4676206,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244198',4676207,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244391',4679595,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244391',4679596,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244391',4679597,'2696','405',520772.18,523047.97,2275.79,375505.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','244391',4679598,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244391',4679599,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244391',4679600,'2699','405',371992.70,375805.63,3812.93,629133.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','244391',4679601,'2700','405',120256.86,121610.05,1353.19,223276.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','244391',4679602,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244391',4679603,'2702','406',222258.72,225140.30,2881.58,979737.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','244391',4679604,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244391',4679605,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244642',4683920,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244642',4683921,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244642',4683922,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244642',4683923,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244642',4683924,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244642',4683925,'2699','405',375805.63,379751.69,3946.06,651099.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','244642',4683926,'2700','405',121610.05,124943.00,3332.95,549936.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','244642',4683927,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244642',4683928,'2702','406',225140.30,229815.41,4675.11,1589537.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','244642',4683929,'2703','406',1008126.74,1008126.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244642',4683930,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244807',4686569,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244807',4686570,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244807',4686571,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','244807',4686572,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244807',4686573,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','244807',4686574,'2699','405',379751.69,382646.57,2894.88,477655.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','244807',4686575,'2700','405',124943.00,127240.73,2297.73,379125.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','244807',4686576,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','244807',4686577,'2702','406',229815.41,232875.71,3060.30,1040502.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','244807',4686578,'2703','406',1008126.74,1011067.89,2941.15,999991.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','244807',4686579,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245079',4691456,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245079',4691457,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245079',4691458,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245079',4691459,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245079',4691460,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245079',4691461,'2699','405',382646.57,382646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245079',4691462,'2700','405',127240.73,127240.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245079',4691463,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','245079',4691464,'2702','406',232875.71,239377.73,6502.02,2210686.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','245079',4691465,'2703','406',1011067.89,1011276.75,208.86,71012.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','245079',4691466,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245338',4695998,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245338',4695999,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245338',4696000,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245338',4696001,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245338',4696002,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245338',4696003,'2699','405',382646.57,382646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245338',4696004,'2700','405',127240.73,127240.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245338',4696005,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','245338',4696006,'2702','406',239377.73,246344.57,6966.84,2368725.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','245338',4696007,'2703','406',1011276.75,1011476.75,200.00,68000.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','245338',4696008,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245570',4700023,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245570',4700024,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245570',4700025,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245570',4700026,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245570',4700027,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245570',4700028,'2699','405',382646.57,384813.26,2166.69,357503.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','245570',4700029,'2700','405',127240.73,129401.23,2160.50,356482.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','245570',4700030,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','245570',4700031,'2702','406',246344.57,250601.98,4257.41,1447519.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','245570',4700032,'2703','406',1011476.75,1011476.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','245570',4700033,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245739',4702936,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245739',4702937,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245739',4702938,'2696','405',523047.97,523047.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','245739',4702939,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245739',4702940,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245739',4702941,'2699','405',384813.26,389235.72,4422.46,729705.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','245739',4702942,'2700','405',129401.23,133647.83,4246.60,700689.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','245739',4702943,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','245739',4702944,'2702','406',250601.98,253419.96,2817.98,958113.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','245739',4702945,'2703','406',1011476.75,1011476.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','245739',4702946,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246020',4707202,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246020',4707203,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246020',4707204,'2696','405',523047.97,526905.64,3857.67,636515.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','246020',4707205,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246020',4707206,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246020',4707207,'2699','405',389235.72,392011.02,2775.30,457924.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','246020',4707208,'2700','405',133647.83,134139.45,491.62,81117.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','246020',4707209,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','246020',4707210,'2702','406',253419.96,257144.51,3724.55,1266347.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','246020',4707211,'2703','406',1011476.75,1011476.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','246020',4707212,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246286',4711654,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246286',4711655,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246286',4711656,'2696','405',526905.64,531224.22,4318.58,712565.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','246286',4711657,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246286',4711658,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246286',4711659,'2699','405',392011.02,395981.73,3970.71,655167.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','246286',4711660,'2700','405',134139.45,134365.63,226.18,37319.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','246286',4711661,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','246286',4711662,'2702','406',257144.51,263635.48,6490.97,2206929.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','246286',4711663,'2703','406',1011476.75,1011476.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','246286',4711664,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246508',4715443,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246508',4715444,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246508',4715445,'2696','405',531224.22,535883.03,4658.81,768703.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','246508',4715446,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246508',4715447,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246508',4715448,'2699','405',395981.73,399736.51,3754.78,619538.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','246508',4715449,'2700','405',134365.63,134365.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246508',4715450,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','246508',4715451,'2702','406',263635.48,269900.68,6265.20,2130168.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','246508',4715452,'2703','406',1011476.75,1011476.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','246508',4715453,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246779',4720170,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246779',4720171,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','246779',4720172,'2696','405',535883.03,540262.40,4379.37,722596.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','246779',4720173,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246779',4720174,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246779',4720175,'2699','405',399736.51,403395.95,3659.44,603807.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','246779',4720176,'2700','405',134365.63,134365.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','246779',4720177,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','246779',4720178,'2702','406',269900.68,273237.61,3336.93,1134556.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','246779',4720179,'2703','406',1011476.75,1016052.34,4575.59,1555700.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','246779',4720180,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247075',4725309,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247075',4725310,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247075',4725311,'2696','405',540262.40,544402.15,4139.75,683058.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','247075',4725312,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247075',4725313,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247075',4725314,'2699','405',403395.95,406759.35,3363.40,554961.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247075',4725315,'2700','405',134365.63,134365.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247075',4725316,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','247075',4725317,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','247075',4725318,'2703','406',1016052.34,1020667.24,4614.90,1569066.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','247075',4725319,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247492',4732595,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247492',4732596,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247492',4732597,'2696','405',544402.15,549580.84,5178.69,854483.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','247492',4732598,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247492',4732599,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247492',4732600,'2699','405',406759.35,412193.73,5434.38,896672.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','247492',4732601,'2700','405',134365.63,134365.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247492',4732602,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','247492',4732603,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','247492',4732604,'2703','406',1020667.24,1026503.96,5836.72,1984484.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','247492',4732605,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247494',4732631,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247494',4732632,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247494',4732633,'2696','405',549580.84,554573.41,4992.57,823774.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','247494',4732634,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247494',4732635,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247494',4732636,'2699','405',412193.73,416890.32,4696.59,774937.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','247494',4732637,'2700','405',134365.63,134365.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247494',4732638,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','247494',4732639,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','247494',4732640,'2703','406',1026503.96,1031904.83,5400.87,1836295.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','247494',4732641,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247795',4737675,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247795',4737676,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247795',4737677,'2696','405',554573.41,560241.86,5668.45,935294.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','247795',4737678,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247795',4737679,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247795',4737680,'2699','405',416890.32,416890.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247795',4737681,'2700','405',134365.63,136489.31,2123.68,350407.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','247795',4737682,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','247795',4737683,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','247795',4737684,'2703','406',1031904.83,1038048.22,6143.39,2088752.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','247795',4737685,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247992',4740969,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247992',4740970,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','247992',4740971,'2696','405',560241.86,567956.47,7714.61,1272910.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','247992',4740972,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247992',4740973,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247992',4740974,'2699','405',416890.32,416890.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','247992',4740975,'2700','405',136489.31,137042.09,552.78,91208.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','247992',4740976,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','247992',4740977,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','247992',4740978,'2703','406',1038048.22,1042745.61,4697.39,1597112.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','247992',4740979,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248281',4746031,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248281',4746032,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248281',4746033,'2696','405',567956.47,567956.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248281',4746034,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248281',4746035,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248281',4746036,'2699','405',416890.32,416890.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248281',4746037,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248281',4746038,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','248281',4746039,'2702','406',273237.61,273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','248281',4746040,'2703','406',1042745.61,1045296.30,2550.69,867234.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','248281',4746041,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248542',4750490,'2694','405',520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248542',4750491,'2695','405',880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248542',4750492,'2696','405',567956.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248542',4750493,'2697','405',255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248542',4750494,'2698','405',299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248542',4750495,'2699','405',416890.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248542',4750496,'2700','405',137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248542',4750497,'2701','405',477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','248542',4750498,'2702','406',273237.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','248542',4750499,'2703','406',1045296.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','248542',4750500,'2704','407',436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248778',4754406,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248778',4754407,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248778',4754408,'2696','405',567956.47,570466.07,2509.60,414084.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248778',4754409,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248778',4754410,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248778',4754411,'2699','405',416890.32,417760.78,870.46,143625.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','248778',4754412,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248778',4754413,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','248778',4754414,'2702','406',273237.61,275135.03,1897.42,635635.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','248778',4754415,'2703','406',1045296.30,1048083.36,2787.06,933665.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','248778',4754416,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248781',4754454,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248781',4754455,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','248781',4754456,'2696','405',570466.07,573975.74,3509.67,579095.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','248781',4754457,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248781',4754458,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248781',4754459,'2699','405',417760.78,420340.11,2579.33,425589.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','248781',4754460,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','248781',4754461,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','248781',4754462,'2702','406',275135.03,278696.35,3561.32,1193042.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','248781',4754463,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','248781',4754464,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249008',4758294,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249008',4758295,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249008',4758296,'2696','405',573975.74,576948.41,2972.67,490490.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','249008',4758297,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249008',4758298,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249008',4758299,'2699','405',420340.11,423183.32,2843.21,469129.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','249008',4758300,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249008',4758301,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','249008',4758302,'2702','406',278696.35,282049.98,3353.63,1123466.05,0.00,0.00,0.00,0.00,0.00),('5','172','914','249008',4758303,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','249008',4758304,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249252',4762422,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249252',4762423,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249252',4762424,'2696','405',576948.41,580181.26,3232.85,533420.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','249252',4762425,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249252',4762426,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249252',4762427,'2699','405',423183.32,428036.28,4852.96,800738.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','249252',4762428,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249252',4762429,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','249252',4762430,'2702','406',282049.98,286520.69,4470.71,1497687.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','249252',4762431,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','249252',4762432,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249490',4766423,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249490',4766424,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249490',4766425,'2696','405',580181.26,583709.72,3528.46,582195.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','249490',4766426,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249490',4766427,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249490',4766428,'2699','405',428036.28,431554.52,3518.24,580509.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','249490',4766429,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249490',4766430,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','249490',4766431,'2702','406',286520.69,291232.46,4711.77,1578442.95,0.00,0.00,0.00,0.00,0.00),('5','172','914','249490',4766432,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','249490',4766433,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249744',4770589,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249744',4770590,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249744',4770591,'2696','405',583709.72,589207.30,5497.58,907100.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','249744',4770592,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249744',4770593,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249744',4770594,'2699','405',431554.52,434719.14,3164.62,522162.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','249744',4770595,'2700','405',137042.09,137042.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249744',4770596,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','249744',4770597,'2702','406',291232.46,296545.15,5312.69,1779751.15,0.00,0.00,0.00,0.00,0.00),('5','172','914','249744',4770598,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','249744',4770599,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249976',4774681,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249976',4774682,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','249976',4774683,'2696','405',589207.30,592216.19,3008.89,496466.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','249976',4774684,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249976',4774685,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','249976',4774686,'2699','405',434719.14,438716.05,3996.91,659490.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','249976',4774687,'2700','405',137042.09,139316.06,2273.97,375205.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','249976',4774688,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','249976',4774689,'2702','406',296545.15,301949.63,5404.48,1810500.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','249976',4774690,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','249976',4774691,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250213',4778505,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250213',4778506,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250213',4778507,'2696','405',592216.19,592216.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250213',4778508,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250213',4778509,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250213',4778510,'2699','405',438716.05,439402.13,686.08,113203.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','250213',4778511,'2700','405',139316.06,140425.28,1109.22,183021.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','250213',4778512,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','250213',4778513,'2702','406',301949.63,306352.94,4403.31,1475108.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','250213',4778514,'2703','406',1048083.36,1048083.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','250213',4778515,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250411',4781650,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250411',4781651,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250411',4781652,'2696','405',592216.19,592216.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250411',4781653,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250411',4781654,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250411',4781655,'2699','405',439402.13,439402.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250411',4781656,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250411',4781657,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','250411',4781658,'2702','406',306352.94,312520.63,6167.69,2066176.15,0.00,0.00,0.00,0.00,0.00),('5','172','914','250411',4781659,'2703','406',1048083.36,1048653.25,569.89,190913.15,0.00,0.00,0.00,0.00,0.00),('5','172','915','250411',4781660,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250653',4785724,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250653',4785725,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250653',4785726,'2696','405',592216.19,592216.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250653',4785727,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250653',4785728,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250653',4785729,'2699','405',439402.13,439402.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250653',4785730,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250653',4785731,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','250653',4785732,'2702','406',312520.63,313356.53,835.90,280026.50,0.00,0.00,0.00,0.00,0.00),('5','172','914','250653',4785733,'2703','406',1048653.25,1051519.72,2866.47,960267.45,0.00,0.00,0.00,0.00,0.00),('5','172','915','250653',4785734,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250905',4790330,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250905',4790331,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','250905',4790332,'2696','405',592216.19,595699.49,3483.30,574744.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','250905',4790333,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250905',4790334,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250905',4790335,'2699','405',439402.13,442708.05,3305.92,545476.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','250905',4790336,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','250905',4790337,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','250905',4790338,'2702','406',313356.53,313790.58,434.05,145406.75,0.00,0.00,0.00,0.00,0.00),('5','172','914','250905',4790339,'2703','406',1051519.72,1056822.59,5302.87,1776461.45,0.00,0.00,0.00,0.00,0.00),('5','172','915','250905',4790340,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251141',4794496,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251141',4794497,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251141',4794498,'2696','405',595699.49,600730.24,5030.75,830073.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','251141',4794499,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251141',4794500,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251141',4794501,'2699','405',442708.05,445728.62,3020.57,498394.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','251141',4794502,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251141',4794503,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','251141',4794504,'2702','406',313790.58,313790.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','251141',4794505,'2703','406',1056822.59,1062464.27,5641.68,1889962.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','251141',4794506,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251427',4799501,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251427',4799502,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251427',4799503,'2696','405',600730.24,604924.99,4194.75,692133.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','251427',4799504,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251427',4799505,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251427',4799506,'2699','405',445728.62,449324.63,3596.01,593341.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','251427',4799507,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251427',4799508,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','251427',4799509,'2702','406',313790.58,313790.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','251427',4799510,'2703','406',1062464.27,1068449.85,5985.58,2005169.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','251427',4799511,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251676',4803965,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251676',4803966,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','251676',4803967,'2696','405',604924.99,611504.52,6579.53,1085622.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','251676',4803968,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251676',4803969,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251676',4803970,'2699','405',449324.63,454914.20,5589.57,922279.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','251676',4803971,'2700','405',140425.28,140425.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','251676',4803972,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','251676',4803973,'2702','406',313790.58,313790.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','251676',4803974,'2703','406',1068449.85,1073919.05,5469.20,1832182.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','251676',4803975,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252028',4809756,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252028',4809757,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252028',4809758,'2696','405',611504.52,612586.24,1081.72,178483.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','252028',4809759,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252028',4809760,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252028',4809761,'2699','405',454914.20,458879.11,3964.91,654210.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','252028',4809762,'2700','405',140425.28,140448.00,22.72,3748.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','252028',4809763,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','252028',4809764,'2702','406',313790.58,313790.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','252028',4809765,'2703','406',1073919.05,1077468.77,3549.72,1189156.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','252028',4809766,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252137',4811804,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252137',4811805,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252137',4811806,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252137',4811807,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252137',4811808,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252137',4811809,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252137',4811810,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252137',4811811,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','252137',4811812,'2702','406',313790.58,313790.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','252137',4811813,'2703','406',1077468.77,1079971.15,2502.38,838297.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','252137',4811814,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252377',4816064,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252377',4816065,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252377',4816066,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252377',4816067,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252377',4816068,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252377',4816069,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252377',4816070,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252377',4816071,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','252377',4816072,'2702','406',313790.58,314781.61,991.03,331995.05,0.00,0.00,0.00,0.00,0.00),('5','172','914','252377',4816073,'2703','406',1079971.15,1081971.15,2000.00,670000.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','252377',4816074,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252592',4819901,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252592',4819902,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252592',4819903,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','252592',4819904,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252592',4819905,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252592',4819906,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252592',4819907,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','252592',4819908,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','252592',4819909,'2702','406',314781.61,318230.93,3449.32,1155522.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','252592',4819910,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','252592',4819911,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253007',4826559,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253007',4826560,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253007',4826561,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253007',4826562,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253007',4826563,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253007',4826564,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253007',4826565,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253007',4826566,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','253007',4826567,'2702','406',318230.93,323477.45,5246.52,1757584.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','253007',4826568,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','253007',4826569,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253135',4829115,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253135',4829116,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253135',4829117,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253135',4829118,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253135',4829119,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253135',4829120,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253135',4829121,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253135',4829122,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','253135',4829123,'2702','406',323477.45,329035.59,5558.14,1861976.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','253135',4829124,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','253135',4829125,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253277',4831307,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253277',4831308,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253277',4831309,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253277',4831310,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253277',4831311,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253277',4831312,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253277',4831313,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253277',4831314,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','253277',4831315,'2702','406',329035.59,333234.37,4198.78,1406591.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','253277',4831316,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','253277',4831317,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253559',4836087,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253559',4836088,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253559',4836089,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253559',4836090,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253559',4836091,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253559',4836092,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253559',4836093,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253559',4836094,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','253559',4836095,'2702','406',333234.37,340097.59,6863.22,2299178.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','253559',4836096,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','253559',4836097,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253986',4843373,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253986',4843374,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253986',4843375,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','253986',4843376,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253986',4843377,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253986',4843378,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253986',4843379,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','253986',4843380,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','253986',4843381,'2702','406',340097.59,344123.37,4025.78,1348636.30,0.00,0.00,0.00,0.00,0.00),('5','172','914','253986',4843382,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','253986',4843383,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254297',4849079,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254297',4849080,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254297',4849081,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254297',4849082,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254297',4849083,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254297',4849084,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254297',4849085,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254297',4849086,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','254297',4849087,'2702','406',344123.37,348087.88,3964.51,1328110.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','254297',4849088,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','254297',4849089,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254372',4850481,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254372',4850482,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254372',4850483,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254372',4850484,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254372',4850485,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254372',4850486,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254372',4850487,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254372',4850488,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','254372',4850489,'2702','406',348087.88,353145.95,5058.07,1694453.45,0.00,0.00,0.00,0.00,0.00),('5','172','914','254372',4850490,'2703','406',1081971.15,1081971.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','254372',4850491,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254529',4853065,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254529',4853066,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254529',4853067,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254529',4853068,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254529',4853069,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254529',4853070,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254529',4853071,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254529',4853072,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','254529',4853073,'2702','406',353145.95,353951.36,805.41,269812.35,0.00,0.00,0.00,0.00,0.00),('5','172','914','254529',4853074,'2703','406',1081971.15,1086048.04,4076.89,1365758.15,0.00,0.00,0.00,0.00,0.00),('5','172','915','254529',4853075,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254781',4857297,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254781',4857298,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254781',4857299,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','254781',4857300,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254781',4857301,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254781',4857302,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254781',4857303,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','254781',4857304,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','254781',4857305,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','254781',4857306,'2703','406',1086048.04,1091448.86,5400.82,1890287.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','254781',4857307,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255033',4861719,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255033',4861720,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255033',4861721,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255033',4861722,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255033',4861723,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255033',4861724,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255033',4861725,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255033',4861726,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','255033',4861727,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','255033',4861728,'2703','406',1091448.86,1098816.51,7367.65,2578677.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','255033',4861729,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255314',4866764,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255314',4866765,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255314',4866766,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255314',4866767,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255314',4866768,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255314',4866769,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255314',4866770,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255314',4866771,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','255314',4866772,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','255314',4866773,'2703','406',1098816.51,1105987.17,7170.66,2509731.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','255314',4866774,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255517',4869754,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255517',4869755,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255517',4869756,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255517',4869757,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255517',4869758,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255517',4869759,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255517',4869760,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255517',4869761,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','255517',4869762,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','255517',4869763,'2703','406',1105987.17,1110271.87,4284.70,1499645.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','255517',4869764,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255816',4874809,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255816',4874810,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255816',4874811,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','255816',4874812,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255816',4874813,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255816',4874814,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255816',4874815,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','255816',4874816,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','255816',4874817,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','255816',4874818,'2703','406',1110271.87,1115024.79,4752.92,1663522.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','255816',4874819,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256120',4880033,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256120',4880034,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256120',4880035,'2696','405',612586.24,612586.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256120',4880036,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256120',4880037,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256120',4880038,'2699','405',458879.11,458879.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256120',4880039,'2700','405',140448.00,140448.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256120',4880040,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','256120',4880041,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','256120',4880042,'2703','406',1115024.79,1120333.78,5308.99,1884691.45,0.00,0.00,0.00,0.00,0.00),('5','172','915','256120',4880043,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256265',4881932,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256265',4881933,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256265',4881934,'2696','405',612586.24,614157.27,1571.03,259219.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','256265',4881935,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256265',4881936,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256265',4881937,'2699','405',458879.11,459940.97,1061.86,175206.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','256265',4881938,'2700','405',140448.00,141397.23,949.23,156622.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','256265',4881939,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','256265',4881940,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','256265',4881941,'2703','406',1120333.78,1121470.64,1136.86,403585.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','256265',4881942,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256550',4886962,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256550',4886963,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256550',4886964,'2696','405',614157.27,616202.30,2045.03,337429.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','256550',4886965,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256550',4886966,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256550',4886967,'2699','405',459940.97,461441.36,1500.39,247564.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','256550',4886968,'2700','405',141397.23,142744.15,1346.92,222241.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','256550',4886969,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','256550',4886970,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','256550',4886971,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','256550',4886972,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256811',4891429,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256811',4891430,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','256811',4891431,'2696','405',616202.30,618189.86,1987.56,327947.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','256811',4891432,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256811',4891433,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','256811',4891434,'2699','405',461441.36,464349.29,2907.93,479808.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','256811',4891435,'2700','405',142744.15,144148.20,1404.05,231668.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','256811',4891436,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','256811',4891437,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','256811',4891438,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','256811',4891439,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257068',4896043,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257068',4896044,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257068',4896045,'2696','405',618189.86,621678.26,3488.40,575586.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257068',4896046,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257068',4896047,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257068',4896048,'2699','405',464349.29,465869.52,1520.23,250837.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257068',4896049,'2700','405',144148.20,145411.37,1263.17,208423.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257068',4896050,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257068',4896051,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257068',4896052,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257068',4896053,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257512',4903725,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257512',4903726,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257512',4903727,'2696','405',621678.26,624461.82,2783.56,459287.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','257512',4903728,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257512',4903729,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257512',4903730,'2699','405',465869.52,467395.72,1526.20,251823.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257512',4903731,'2700','405',145411.37,146161.15,749.78,123713.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257512',4903732,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257512',4903733,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257512',4903734,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257512',4903735,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257616',4905821,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257616',4905822,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257616',4905823,'2696','405',624461.82,627422.86,2961.04,488571.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257616',4905824,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257616',4905825,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257616',4905826,'2699','405',467395.72,469861.53,2465.81,406858.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257616',4905827,'2700','405',146161.15,146432.44,271.29,44762.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257616',4905828,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257616',4905829,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257616',4905830,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257616',4905831,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257617',4905832,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257617',4905833,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257617',4905834,'2696','405',627422.86,629266.39,1843.53,304182.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','257617',4905835,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257617',4905836,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257617',4905837,'2699','405',469861.53,472420.85,2559.32,422287.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257617',4905838,'2700','405',146432.44,146752.65,320.21,52834.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257617',4905839,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257617',4905840,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257617',4905841,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257617',4905842,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257618',4905843,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257618',4905844,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257618',4905845,'2696','405',629266.39,632619.07,3352.68,553192.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','257618',4905846,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257618',4905847,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257618',4905848,'2699','405',472420.85,472430.48,9.63,1588.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257618',4905849,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257618',4905850,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257618',4905851,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257618',4905852,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257618',4905853,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257619',4905854,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257619',4905855,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257619',4905856,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257619',4905857,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257619',4905858,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257619',4905859,'2699','405',472430.48,472430.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257619',4905860,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257619',4905861,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257619',4905862,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257619',4905863,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257619',4905864,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257620',4905865,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257620',4905866,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257620',4905867,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257620',4905868,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257620',4905869,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257620',4905870,'2699','405',472430.48,472430.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257620',4905871,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257620',4905872,'2701','405',477535.91,477535.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257620',4905873,'2702','406',353951.36,353951.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257620',4905874,'2703','406',1121470.64,1121470.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257620',4905875,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257621',4905876,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257621',4905877,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257621',4905878,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257621',4905879,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257621',4905880,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257621',4905881,'2699','405',472430.48,476234.36,3803.88,627640.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257621',4905882,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257621',4905883,'2701','405',477535.91,479428.42,1892.51,312264.15,0.00,0.00,0.00,0.00,0.00),('5','172','913','257621',4905884,'2702','406',353951.36,356577.25,2625.89,958449.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','257621',4905885,'2703','406',1121470.64,1122321.46,850.82,310549.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257621',4905886,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257622',4905887,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257622',4905888,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257622',4905889,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257622',4905890,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257622',4905891,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257622',4905892,'2699','405',476234.36,478911.32,2676.96,441698.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257622',4905893,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257622',4905894,'2701','405',479428.42,481961.35,2532.93,417933.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','257622',4905895,'2702','406',356577.25,361132.45,4555.20,1776528.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257622',4905896,'2703','406',1122321.46,1122452.49,131.03,51101.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257622',4905897,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257623',4905898,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257623',4905899,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257623',4905900,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257623',4905901,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257623',4905902,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257623',4905903,'2699','405',478911.32,481560.24,2648.92,437071.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257623',4905904,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257623',4905905,'2701','405',481961.35,485178.28,3216.93,530793.45,0.00,0.00,0.00,0.00,0.00),('5','172','913','257623',4905906,'2702','406',361132.45,365215.84,4083.39,1592522.10,0.00,0.00,0.00,0.00,0.00),('5','172','914','257623',4905907,'2703','406',1122452.49,1122647.62,195.13,76100.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257623',4905908,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257624',4905909,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257624',4905910,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257624',4905911,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257624',4905912,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257624',4905913,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257624',4905914,'2699','405',481560.24,485214.40,3654.16,602936.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257624',4905915,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257624',4905916,'2701','405',485178.28,488919.59,3741.31,617316.15,0.00,0.00,0.00,0.00,0.00),('5','172','913','257624',4905917,'2702','406',365215.84,368454.37,3238.53,1263026.70,0.00,0.00,0.00,0.00,0.00),('5','172','914','257624',4905918,'2703','406',1122647.62,1127147.25,4499.63,1754855.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257624',4905919,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257625',4905920,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257625',4905921,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257625',4905922,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257625',4905923,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257625',4905924,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257625',4905925,'2699','405',485214.40,492348.56,7134.16,1177136.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257625',4905926,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257625',4905927,'2701','405',488919.59,489560.76,641.17,105793.05,0.00,0.00,0.00,0.00,0.00),('5','172','913','257625',4905928,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257625',4905929,'2703','406',1127147.25,1143815.92,16668.67,6500781.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257625',4905930,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257626',4905931,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257626',4905932,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257626',4905933,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257626',4905934,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257626',4905935,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257626',4905936,'2699','405',492348.56,496668.87,4320.31,712851.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257626',4905937,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257626',4905938,'2701','405',489560.76,493222.31,3661.55,604155.75,0.00,0.00,0.00,0.00,0.00),('5','172','913','257626',4905939,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257626',4905940,'2703','406',1143815.92,1148936.67,5120.75,2125111.25,0.00,0.00,0.00,0.00,0.00),('5','172','915','257626',4905941,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257627',4905942,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257627',4905943,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257627',4905944,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257627',4905945,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257627',4905946,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257627',4905947,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257627',4905948,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257627',4905949,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257627',4905950,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257627',4905951,'2703','406',1148936.67,1151859.92,2923.25,1213148.75,0.00,0.00,0.00,0.00,0.00),('5','172','915','257627',4905952,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257628',4905953,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257628',4905954,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257628',4905955,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257628',4905956,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257628',4905957,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257628',4905958,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257628',4905959,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257628',4905960,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257628',4905961,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257628',4905962,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257628',4905963,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257629',4905964,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257629',4905965,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257629',4905966,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257629',4905967,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257629',4905968,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257629',4905969,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257629',4905970,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257629',4905971,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257629',4905972,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257629',4905973,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257629',4905974,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257630',4905975,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257630',4905976,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257630',4905977,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257630',4905978,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257630',4905979,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257630',4905980,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257630',4905981,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257630',4905982,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257630',4905983,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257630',4905984,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257630',4905985,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257631',4905986,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257631',4905987,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257631',4905988,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257631',4905989,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257631',4905990,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257631',4905991,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257631',4905992,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257631',4905993,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257631',4905994,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257631',4905995,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257631',4905996,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257632',4905997,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257632',4905998,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257632',4905999,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257632',4906000,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257632',4906001,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257632',4906002,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257632',4906003,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257632',4906004,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257632',4906005,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257632',4906006,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257632',4906007,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257633',4906008,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257633',4906009,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257633',4906010,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257633',4906011,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257633',4906012,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257633',4906013,'2699','405',496668.87,496668.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257633',4906014,'2700','405',146752.65,146752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257633',4906015,'2701','405',493222.31,493222.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257633',4906016,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257633',4906017,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257633',4906018,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257634',4906019,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257634',4906020,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257634',4906021,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257634',4906022,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257634',4906023,'2698','405',299423.58,299423.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257634',4906024,'2699','405',496668.87,500628.97,3960.10,653416.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257634',4906025,'2700','405',146752.65,146755.83,3.18,524.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257634',4906026,'2701','405',493222.31,496464.74,3242.43,535000.95,0.00,0.00,0.00,0.00,0.00),('5','172','913','257634',4906027,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257634',4906028,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257634',4906029,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257635',4906030,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257635',4906031,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257635',4906032,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257635',4906033,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257635',4906034,'2698','405',299423.58,299437.61,14.03,2314.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257635',4906035,'2699','405',500628.97,514404.83,13775.86,2273016.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257635',4906036,'2700','405',146755.83,155212.12,8456.29,1395287.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257635',4906037,'2701','405',496464.74,498858.40,2393.66,394953.90,0.00,0.00,0.00,0.00,0.00),('5','172','913','257635',4906038,'2702','406',368454.37,368454.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257635',4906039,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257635',4906040,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257636',4906041,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257636',4906042,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257636',4906043,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257636',4906044,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257636',4906045,'2698','405',299437.61,299437.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257636',4906046,'2699','405',514404.83,517769.57,3364.74,555182.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257636',4906047,'2700','405',155212.12,156959.38,1747.26,288297.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257636',4906048,'2701','405',498858.40,498858.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257636',4906049,'2702','406',368454.37,372654.00,4199.63,1742846.45,0.00,0.00,0.00,0.00,0.00),('5','172','914','257636',4906050,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257636',4906051,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257637',4906052,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257637',4906053,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257637',4906054,'2696','405',632619.07,632619.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257637',4906055,'2697','405',255858.96,255858.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257637',4906056,'2698','405',299437.61,299437.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257637',4906057,'2699','405',517769.57,524109.03,6339.46,1046010.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257637',4906058,'2700','405',156959.38,158154.33,1194.95,197166.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257637',4906059,'2701','405',498858.40,498858.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257637',4906060,'2702','406',372654.00,375957.40,3303.40,1370911.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257637',4906061,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257637',4906062,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257638',4906063,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257638',4906064,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257638',4906065,'2696','405',632619.07,639166.71,6547.64,1080360.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257638',4906066,'2697','405',255858.96,255860.86,1.90,313.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257638',4906067,'2698','405',299437.61,299437.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257638',4906068,'2699','405',524109.03,530169.61,6060.58,999995.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257638',4906069,'2700','405',158154.33,159781.63,1627.30,268504.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257638',4906070,'2701','405',498858.40,498925.89,67.49,11135.85,0.00,0.00,0.00,0.00,0.00),('5','172','913','257638',4906071,'2702','406',375957.40,380149.28,4191.88,1739630.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257638',4906072,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257638',4906073,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257639',4906074,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257639',4906075,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257639',4906076,'2696','405',639166.71,647603.51,8436.80,1392072.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257639',4906077,'2697','405',255860.86,255871.26,10.40,1716.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257639',4906078,'2698','405',299437.61,299492.09,54.48,8989.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257639',4906079,'2699','405',530169.61,537957.28,7787.67,1284965.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257639',4906080,'2700','405',159781.63,160477.84,696.21,114874.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257639',4906081,'2701','405',498925.89,498929.81,3.92,646.80,0.00,0.00,0.00,0.00,0.00),('5','172','913','257639',4906082,'2702','406',380149.28,387367.37,7218.09,2995507.35,0.00,0.00,0.00,0.00,0.00),('5','172','914','257639',4906083,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257639',4906084,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257640',4906085,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257640',4906086,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257640',4906087,'2696','405',647603.51,655321.83,7718.32,1273522.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','257640',4906088,'2697','405',255871.26,255909.43,38.17,6298.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257640',4906089,'2698','405',299492.09,300574.06,1081.97,178525.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257640',4906090,'2699','405',537957.28,543190.02,5232.74,863402.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257640',4906091,'2700','405',160477.84,160477.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257640',4906092,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257640',4906093,'2702','406',387367.37,390346.52,2979.15,1236347.25,0.00,0.00,0.00,0.00,0.00),('5','172','914','257640',4906094,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257640',4906095,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257641',4906096,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257641',4906097,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257641',4906098,'2696','405',655321.83,655321.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257641',4906099,'2697','405',255909.43,255909.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257641',4906100,'2698','405',300574.06,300574.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257641',4906101,'2699','405',543190.02,543190.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257641',4906102,'2700','405',160477.84,160477.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257641',4906103,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257641',4906104,'2702','406',390346.52,394595.08,4248.56,1763152.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257641',4906105,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257641',4906106,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257642',4906107,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257642',4906108,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257642',4906109,'2696','405',655321.83,655321.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257642',4906110,'2697','405',255909.43,255909.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257642',4906111,'2698','405',300574.06,300574.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257642',4906112,'2699','405',543190.02,543190.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257642',4906113,'2700','405',160477.84,160477.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257642',4906114,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257642',4906115,'2702','406',394595.08,398601.27,4006.19,1662568.85,0.00,0.00,0.00,0.00,0.00),('5','172','914','257642',4906116,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257642',4906117,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257643',4906118,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257643',4906119,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257643',4906120,'2696','405',655321.83,655321.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257643',4906121,'2697','405',255909.43,255909.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257643',4906122,'2698','405',300574.06,300574.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257643',4906123,'2699','405',543190.02,543190.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257643',4906124,'2700','405',160477.84,160477.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257643',4906125,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257643',4906126,'2702','406',398601.27,403287.53,4686.26,1944797.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','257643',4906127,'2703','406',1151859.92,1151859.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257643',4906128,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257644',4906129,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257644',4906130,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257644',4906131,'2696','405',655321.83,655321.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257644',4906132,'2697','405',255909.43,255909.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257644',4906133,'2698','405',300574.06,300574.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257644',4906134,'2699','405',543190.02,543190.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257644',4906135,'2700','405',160477.84,160477.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257644',4906136,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257644',4906137,'2702','406',403287.53,408537.79,5250.26,2178857.90,0.00,0.00,0.00,0.00,0.00),('5','172','914','257644',4906138,'2703','406',1151859.92,1153491.53,1631.61,677118.15,0.00,0.00,0.00,0.00,0.00),('5','172','915','257644',4906139,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257645',4906140,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257645',4906141,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257645',4906142,'2696','405',655321.83,659773.60,4451.77,734542.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257645',4906143,'2697','405',255909.43,255941.33,31.90,5263.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257645',4906144,'2698','405',300574.06,304593.40,4019.34,663191.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257645',4906145,'2699','405',543190.02,548725.94,5535.92,913426.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257645',4906146,'2700','405',160477.84,162752.53,2274.69,375323.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257645',4906147,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257645',4906148,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257645',4906149,'2703','406',1153491.53,1159124.02,5632.49,2337483.35,0.00,0.00,0.00,0.00,0.00),('5','172','915','257645',4906150,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257646',4906151,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257646',4906152,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257646',4906153,'2696','405',659773.60,668916.38,9142.78,1508558.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','257646',4906154,'2697','405',255941.33,255998.04,56.71,9357.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257646',4906155,'2698','405',304593.40,307964.04,3370.64,556155.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257646',4906156,'2699','405',548725.94,553947.46,5221.52,861550.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257646',4906157,'2700','405',162752.53,164619.43,1866.90,308038.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257646',4906158,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257646',4906159,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257646',4906160,'2703','406',1159124.02,1163439.22,4315.20,1790808.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257646',4906161,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257647',4906162,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257647',4906163,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257647',4906164,'2696','405',668916.38,677606.67,8690.29,1433897.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257647',4906165,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257647',4906166,'2698','405',307964.04,307964.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257647',4906167,'2699','405',553947.46,553947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257647',4906168,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257647',4906169,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257647',4906170,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257647',4906171,'2703','406',1163439.22,1169853.11,6413.89,2661764.35,0.00,0.00,0.00,0.00,0.00),('5','172','915','257647',4906172,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257648',4906173,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257648',4906174,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257648',4906175,'2696','405',677606.67,677606.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257648',4906176,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257648',4906177,'2698','405',307964.04,307964.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257648',4906178,'2699','405',553947.46,553947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257648',4906179,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257648',4906180,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257648',4906181,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257648',4906182,'2703','406',1169853.11,1188844.53,18991.42,8071353.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257648',4906183,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257649',4906184,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257649',4906185,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257649',4906186,'2696','405',677606.67,677606.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257649',4906187,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257649',4906188,'2698','405',307964.04,307964.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257649',4906189,'2699','405',553947.46,553947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257649',4906190,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257649',4906191,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257649',4906192,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257649',4906193,'2703','406',1188844.53,1191622.83,2778.30,1222452.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257649',4906194,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257650',4906195,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257650',4906196,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257650',4906197,'2696','405',677606.67,677606.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257650',4906198,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257650',4906199,'2698','405',307964.04,307964.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257650',4906200,'2699','405',553947.46,553947.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257650',4906201,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257650',4906202,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257650',4906203,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257650',4906204,'2703','406',1191622.83,1191622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257650',4906205,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257651',4906206,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257651',4906207,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257651',4906208,'2696','405',677606.67,684912.01,7305.34,1205381.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257651',4906209,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257651',4906210,'2698','405',307964.04,316075.66,8111.62,1338417.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257651',4906211,'2699','405',553947.46,562182.55,8235.09,1358789.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257651',4906212,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257651',4906213,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257651',4906214,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257651',4906215,'2703','406',1191622.83,1191622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257651',4906216,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257652',4906217,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257652',4906218,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257652',4906219,'2696','405',684912.01,692858.16,7946.15,1311114.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','257652',4906220,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257652',4906221,'2698','405',316075.66,322775.46,6699.80,1105467.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257652',4906222,'2699','405',562182.55,569218.46,7035.91,1160925.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257652',4906223,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257652',4906224,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257652',4906225,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257652',4906226,'2703','406',1191622.83,1191622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257652',4906227,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257653',4906228,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257653',4906229,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257653',4906230,'2696','405',692858.16,700727.40,7869.24,1298424.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257653',4906231,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257653',4906232,'2698','405',322775.46,330595.86,7820.40,1290366.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257653',4906233,'2699','405',569218.46,569218.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257653',4906234,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257653',4906235,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257653',4906236,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257653',4906237,'2703','406',1191622.83,1191662.00,39.17,19585.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257653',4906238,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257654',4906239,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257654',4906240,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257654',4906241,'2696','405',700727.40,708138.45,7411.05,1222823.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','257654',4906242,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257654',4906243,'2698','405',330595.86,339286.98,8691.12,1434034.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257654',4906244,'2699','405',569218.46,569218.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257654',4906245,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257654',4906246,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257654',4906247,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257654',4906248,'2703','406',1191662.00,1191662.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257654',4906249,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257655',4906250,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257655',4906251,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257655',4906252,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257655',4906253,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257655',4906254,'2698','405',339286.98,340888.98,1602.00,264330.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257655',4906255,'2699','405',569218.46,575702.40,6483.94,1069850.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257655',4906256,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257655',4906257,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257655',4906258,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257655',4906259,'2703','406',1191662.00,1191821.89,159.89,102329.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257655',4906260,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257656',4906261,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257656',4906262,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257656',4906263,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257656',4906264,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257656',4906265,'2698','405',340888.98,345991.45,5102.47,841907.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257656',4906266,'2699','405',575702.40,575702.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257656',4906267,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257656',4906268,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257656',4906269,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257656',4906270,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257656',4906271,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257657',4906272,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257657',4906273,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257657',4906274,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257657',4906275,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257657',4906276,'2698','405',345991.45,345991.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257657',4906277,'2699','405',575702.40,575702.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257657',4906278,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257657',4906279,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257657',4906280,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257657',4906281,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257657',4906282,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257658',4906283,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257658',4906284,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257658',4906285,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257658',4906286,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257658',4906287,'2698','405',345991.45,345991.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257658',4906288,'2699','405',575702.40,575702.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257658',4906289,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257658',4906290,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257658',4906291,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257658',4906292,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257658',4906293,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257659',4906294,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257659',4906295,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257659',4906296,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257659',4906297,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257659',4906298,'2698','405',345991.45,345991.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257659',4906299,'2699','405',575702.40,575702.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257659',4906300,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257659',4906301,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257659',4906302,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257659',4906303,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257659',4906304,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257660',4906305,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257660',4906306,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257660',4906307,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257660',4906308,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257660',4906309,'2698','405',345991.45,345991.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257660',4906310,'2699','405',575702.40,575702.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257660',4906311,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257660',4906312,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257660',4906313,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257660',4906314,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257660',4906315,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257661',4906316,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257661',4906317,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257661',4906318,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257661',4906319,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257661',4906320,'2698','405',345991.45,348491.90,2500.45,412574.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257661',4906321,'2699','405',575702.40,578662.69,2960.29,488447.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257661',4906322,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257661',4906323,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257661',4906324,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257661',4906325,'2703','406',1191821.89,1191821.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257661',4906326,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257662',4906327,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257662',4906328,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257662',4906329,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257662',4906330,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257662',4906331,'2698','405',348491.90,357539.45,9047.55,1492845.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257662',4906332,'2699','405',578662.69,587872.29,9209.60,1519584.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257662',4906333,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257662',4906334,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257662',4906335,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257662',4906336,'2703','406',1191821.89,1191861.89,40.00,25600.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257662',4906337,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257663',4906338,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257663',4906339,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257663',4906340,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257663',4906341,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257663',4906342,'2698','405',357539.45,357539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257663',4906343,'2699','405',587872.29,587872.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257663',4906344,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257663',4906345,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257663',4906346,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257663',4906347,'2703','406',1191861.89,1191861.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257663',4906348,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257664',4906349,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257664',4906350,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257664',4906351,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257664',4906352,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257664',4906353,'2698','405',357539.45,365261.79,7722.34,1274186.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257664',4906354,'2699','405',587872.29,596479.40,8607.11,1420173.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257664',4906355,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257664',4906356,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257664',4906357,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257664',4906358,'2703','406',1191861.89,1191861.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257664',4906359,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257665',4906360,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257665',4906361,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257665',4906362,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257665',4906363,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257665',4906364,'2698','405',365261.79,365261.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257665',4906365,'2699','405',596479.40,596479.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257665',4906366,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257665',4906367,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257665',4906368,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257665',4906369,'2703','406',1191861.89,1191861.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257665',4906370,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257666',4906371,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257666',4906372,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257666',4906373,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257666',4906374,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257666',4906375,'2698','405',365261.79,365261.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257666',4906376,'2699','405',596479.40,596479.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257666',4906377,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257666',4906378,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257666',4906379,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257666',4906380,'2703','406',1191861.89,1191861.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257666',4906381,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257667',4906382,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257667',4906383,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257667',4906384,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257667',4906385,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257667',4906386,'2698','405',365261.79,368797.20,3535.41,583342.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257667',4906387,'2699','405',596479.40,600425.63,3946.23,651127.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257667',4906388,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257667',4906389,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257667',4906390,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257667',4906391,'2703','406',1191861.89,1195324.56,3462.67,2216108.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257667',4906392,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257668',4906393,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257668',4906394,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257668',4906395,'2696','405',708138.45,708138.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257668',4906396,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257668',4906397,'2698','405',368797.20,374622.15,5824.95,961116.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257668',4906398,'2699','405',600425.63,609433.69,9008.06,1486329.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257668',4906399,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257668',4906400,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257668',4906401,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257668',4906402,'2703','406',1195324.56,1200708.19,5383.63,3445523.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257668',4906403,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257669',4906404,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257669',4906405,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257669',4906406,'2696','405',708138.45,716964.80,8826.35,1456347.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','257669',4906407,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257669',4906408,'2698','405',374622.15,374622.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257669',4906409,'2699','405',609433.69,610961.38,1527.69,252068.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257669',4906410,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257669',4906411,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257669',4906412,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257669',4906413,'2703','406',1200708.19,1205657.17,4948.98,3167347.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257669',4906414,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257670',4906415,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257670',4906416,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257670',4906417,'2696','405',716964.80,723468.85,6504.05,1073168.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','257670',4906418,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257670',4906419,'2698','405',374622.15,378017.23,3395.08,560188.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257670',4906420,'2699','405',610961.38,611691.10,729.72,120403.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257670',4906421,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257670',4906422,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257670',4906423,'2702','406',408537.79,408537.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257670',4906424,'2703','406',1205657.17,1209826.59,4169.42,2668428.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257670',4906425,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257671',4906426,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257671',4906427,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257671',4906428,'2696','405',723468.85,729741.77,6272.92,1035031.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','257671',4906429,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257671',4906430,'2698','405',378017.23,381775.21,3757.98,620066.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257671',4906431,'2699','405',611691.10,615869.14,4178.04,689376.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257671',4906432,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257671',4906433,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257671',4906434,'2702','406',408537.79,413161.73,4623.94,2959321.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257671',4906435,'2703','406',1209826.59,1216738.13,6911.54,4423385.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257671',4906436,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257672',4906437,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257672',4906438,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257672',4906439,'2696','405',729741.77,737751.94,8010.17,1321678.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257672',4906440,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257672',4906441,'2698','405',381775.21,383725.25,1950.04,321756.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257672',4906442,'2699','405',615869.14,618412.81,2543.67,419705.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257672',4906443,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257672',4906444,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257672',4906445,'2702','406',413161.73,413361.74,200.01,128006.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257672',4906446,'2703','406',1216738.13,1227587.54,10849.41,6943622.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257672',4906447,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257673',4906448,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257673',4906449,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257673',4906450,'2696','405',737751.94,745552.05,7800.11,1287018.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','257673',4906451,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257673',4906452,'2698','405',383725.25,383725.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257673',4906453,'2699','405',618412.81,618412.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257673',4906454,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257673',4906455,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257673',4906456,'2702','406',413361.74,418196.91,4835.17,3094508.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257673',4906457,'2703','406',1227587.54,1227587.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257673',4906458,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257674',4906459,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257674',4906460,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257674',4906461,'2696','405',745552.05,748874.85,3322.80,548262.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257674',4906462,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257674',4906463,'2698','405',383725.25,383725.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257674',4906464,'2699','405',618412.81,618412.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257674',4906465,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257674',4906466,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257674',4906467,'2702','406',418196.91,421696.91,3500.00,2240000.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257674',4906468,'2703','406',1227587.54,1229245.19,1657.65,1060896.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257674',4906469,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257675',4906470,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257675',4906471,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257675',4906472,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257675',4906473,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257675',4906474,'2698','405',383725.25,383725.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257675',4906475,'2699','405',618412.81,618412.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257675',4906476,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257675',4906477,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257675',4906478,'2702','406',421696.91,421696.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257675',4906479,'2703','406',1229245.19,1229245.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257675',4906480,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257676',4906481,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257676',4906482,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257676',4906483,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257676',4906484,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257676',4906485,'2698','405',383725.25,383725.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257676',4906486,'2699','405',618412.81,618412.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257676',4906487,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257676',4906488,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257676',4906489,'2702','406',421696.91,421696.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257676',4906490,'2703','406',1229245.19,1229245.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257676',4906491,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257677',4906492,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257677',4906493,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257677',4906494,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257677',4906495,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257677',4906496,'2698','405',383725.25,387993.88,4268.63,704323.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257677',4906497,'2699','405',618412.81,624590.93,6178.12,1019389.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257677',4906498,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257677',4906499,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257677',4906500,'2702','406',421696.91,421696.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257677',4906501,'2703','406',1229245.19,1229245.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257677',4906502,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257678',4906503,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257678',4906504,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257678',4906505,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257678',4906506,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257678',4906507,'2698','405',387993.88,390315.13,2321.25,383006.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257678',4906508,'2699','405',624590.93,632150.85,7559.92,1247386.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257678',4906509,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257678',4906510,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257678',4906511,'2702','406',421696.91,421696.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257678',4906512,'2703','406',1229245.19,1229245.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257678',4906513,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257679',4906514,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257679',4906515,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257679',4906516,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257679',4906517,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257679',4906518,'2698','405',390315.13,390315.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257679',4906519,'2699','405',632150.85,637532.04,5381.19,887896.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257679',4906520,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257679',4906521,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257679',4906522,'2702','406',421696.91,421696.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257679',4906523,'2703','406',1229245.19,1229245.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257679',4906524,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257680',4906525,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257680',4906526,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257680',4906527,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257680',4906528,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257680',4906529,'2698','405',390315.13,391915.00,1599.87,263978.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257680',4906530,'2699','405',637532.04,643401.49,5869.45,968459.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257680',4906531,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257680',4906532,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257680',4906533,'2702','406',421696.91,421717.13,20.22,13345.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257680',4906534,'2703','406',1229245.19,1229652.99,407.80,269148.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257680',4906535,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257681',4906536,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257681',4906537,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257681',4906538,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257681',4906539,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257681',4906540,'2698','405',391915.00,393931.98,2016.98,332801.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257681',4906541,'2699','405',643401.49,648742.22,5340.73,881220.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257681',4906542,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257681',4906543,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257681',4906544,'2702','406',421717.13,421717.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257681',4906545,'2703','406',1229652.99,1233838.15,4185.16,2762205.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257681',4906546,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257682',4906547,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257682',4906548,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257682',4906549,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257682',4906550,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257682',4906551,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257682',4906552,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257682',4906553,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257682',4906554,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257682',4906555,'2702','406',421717.13,421727.13,10.00,6600.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257682',4906556,'2703','406',1233838.15,1237231.15,3393.00,2239380.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257682',4906557,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257683',4906558,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257683',4906559,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257683',4906560,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257683',4906561,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257683',4906562,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257683',4906563,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257683',4906564,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257683',4906565,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257683',4906566,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257683',4906567,'2703','406',1237231.15,1241447.70,4216.55,2782923.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257683',4906568,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257684',4906569,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257684',4906570,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257684',4906571,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257684',4906572,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257684',4906573,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257684',4906574,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257684',4906575,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257684',4906576,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257684',4906577,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257684',4906578,'2703','406',1241447.70,1245676.57,4228.87,2791054.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257684',4906579,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257685',4906580,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257685',4906581,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257685',4906582,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257685',4906583,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257685',4906584,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257685',4906585,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257685',4906586,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257685',4906587,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257685',4906588,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257685',4906589,'2703','406',1245676.57,1248508.31,2831.74,1868948.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257685',4906590,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257686',4906591,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257686',4906592,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257686',4906593,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257686',4906594,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257686',4906595,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257686',4906596,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257686',4906597,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257686',4906598,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257686',4906599,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257686',4906600,'2703','406',1248508.31,1252754.77,4246.46,2802663.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257686',4906601,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257687',4906602,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257687',4906603,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257687',4906604,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257687',4906605,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257687',4906606,'2698','405',393931.98,393931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257687',4906607,'2699','405',648742.22,648742.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257687',4906608,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257687',4906609,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257687',4906610,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257687',4906611,'2703','406',1252754.77,1257168.96,4414.19,2913365.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257687',4906612,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257688',4906613,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257688',4906614,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257688',4906615,'2696','405',748874.85,748874.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257688',4906616,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257688',4906617,'2698','405',393931.98,395412.90,1480.92,244351.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257688',4906618,'2699','405',648742.22,650488.23,1746.01,288091.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257688',4906619,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257688',4906620,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257688',4906621,'2702','406',421727.13,421727.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257688',4906622,'2703','406',1257168.96,1261107.77,3938.81,2599614.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257688',4906623,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257689',4906624,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257689',4906625,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257689',4906626,'2696','405',748874.85,758430.17,9555.32,1576627.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','257689',4906627,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257689',4906628,'2698','405',395412.90,397004.86,1591.96,262673.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257689',4906629,'2699','405',650488.23,658031.77,7543.54,1244684.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257689',4906630,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257689',4906631,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257689',4906632,'2702','406',421727.13,421872.58,145.45,95997.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257689',4906633,'2703','406',1261107.77,1266326.87,5219.10,3444606.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257689',4906634,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257690',4906635,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257690',4906636,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257690',4906637,'2696','405',758430.17,761715.22,3285.05,542033.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','257690',4906638,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257690',4906639,'2698','405',397004.86,399314.76,2309.90,381133.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257690',4906640,'2699','405',658031.77,665606.43,7574.66,1249818.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257690',4906641,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257690',4906642,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257690',4906643,'2702','406',421872.58,424408.15,2535.57,1673476.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257690',4906644,'2703','406',1266326.87,1269597.36,3270.49,2158523.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257690',4906645,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257691',4906646,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257691',4906647,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257691',4906648,'2696','405',761715.22,766419.85,4704.63,776263.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','257691',4906649,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257691',4906650,'2698','405',399314.76,400676.55,1361.79,224695.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257691',4906651,'2699','405',665606.43,671565.39,5958.96,983228.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257691',4906652,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257691',4906653,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257691',4906654,'2702','406',424408.15,429010.14,4601.99,3037313.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257691',4906655,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257691',4906656,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257692',4906657,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257692',4906658,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257692',4906659,'2696','405',766419.85,770597.99,4178.14,689393.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257692',4906660,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257692',4906661,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257692',4906662,'2699','405',671565.39,675914.84,4349.45,717659.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257692',4906663,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257692',4906664,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257692',4906665,'2702','406',429010.14,432961.19,3951.05,2607693.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257692',4906666,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257692',4906667,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257693',4906668,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257693',4906669,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257693',4906670,'2696','405',770597.99,775426.52,4828.53,796707.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','257693',4906671,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257693',4906672,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257693',4906673,'2699','405',675914.84,680201.74,4286.90,707338.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257693',4906674,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257693',4906675,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257693',4906676,'2702','406',432961.19,435930.93,2969.74,1960028.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257693',4906677,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257693',4906678,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257694',4906679,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257694',4906680,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257694',4906681,'2696','405',775426.52,782240.32,6813.80,1124277.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257694',4906682,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257694',4906683,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257694',4906684,'2699','405',680201.74,687236.17,7034.43,1160680.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257694',4906685,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257694',4906686,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257694',4906687,'2702','406',435930.93,441945.46,6014.53,3969589.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257694',4906688,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257694',4906689,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257695',4906690,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257695',4906691,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257695',4906692,'2696','405',782240.32,786413.02,4172.70,688495.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','257695',4906693,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257695',4906694,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257695',4906695,'2699','405',687236.17,690758.99,3522.82,581265.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257695',4906696,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257695',4906697,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257695',4906698,'2702','406',441945.46,446969.65,5024.19,3315965.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257695',4906699,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257695',4906700,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257696',4906701,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257696',4906702,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257696',4906703,'2696','405',786413.02,790050.05,3637.03,600109.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','257696',4906704,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257696',4906705,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257696',4906706,'2699','405',690758.99,693885.04,3126.05,515798.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257696',4906707,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257696',4906708,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257696',4906709,'2702','406',446969.65,455642.84,8673.19,5724305.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257696',4906710,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257696',4906711,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257697',4906712,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257697',4906713,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257697',4906714,'2696','405',790050.05,795350.12,5300.07,874511.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','257697',4906715,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257697',4906716,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257697',4906717,'2699','405',693885.04,694348.47,463.43,76465.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257697',4906718,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257697',4906719,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257697',4906720,'2702','406',455642.84,461503.22,5860.38,3867850.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257697',4906721,'2703','406',1269597.36,1269597.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257697',4906722,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257698',4906723,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257698',4906724,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257698',4906725,'2696','405',795350.12,801551.19,6201.07,1023176.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','257698',4906726,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257698',4906727,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257698',4906728,'2699','405',694348.47,694348.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257698',4906729,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257698',4906730,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257698',4906731,'2702','406',461503.22,462176.67,673.45,444477.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257698',4906732,'2703','406',1269597.36,1276780.20,7182.84,4740674.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257698',4906733,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257699',4906734,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257699',4906735,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257699',4906736,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257699',4906737,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257699',4906738,'2698','405',400676.55,400676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257699',4906739,'2699','405',694348.47,694348.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257699',4906740,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257699',4906741,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257699',4906742,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257699',4906743,'2703','406',1276780.20,1283893.92,7113.72,4695055.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257699',4906744,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257700',4906745,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257700',4906746,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257700',4906747,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257700',4906748,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257700',4906749,'2698','405',400676.55,402191.17,1514.62,249912.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257700',4906750,'2699','405',694348.47,700996.68,6648.21,1096954.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257700',4906751,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257700',4906752,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257700',4906753,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257700',4906754,'2703','406',1283893.92,1292508.36,8614.44,5685530.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257700',4906755,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257701',4906756,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257701',4906757,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257701',4906758,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257701',4906759,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257701',4906760,'2698','405',402191.17,402845.44,654.27,107954.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257701',4906761,'2699','405',700996.68,705324.69,4328.01,714121.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257701',4906762,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257701',4906763,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257701',4906764,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257701',4906765,'2703','406',1292508.36,1298989.42,6481.06,4277499.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257701',4906766,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257702',4906767,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257702',4906768,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257702',4906769,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257702',4906770,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257702',4906771,'2698','405',402845.44,406507.79,3662.35,604287.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257702',4906772,'2699','405',705324.69,709443.74,4119.05,679643.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257702',4906773,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257702',4906774,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257702',4906775,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257702',4906776,'2703','406',1298989.42,1306631.90,7642.48,5044036.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257702',4906777,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257703',4906778,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257703',4906779,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257703',4906780,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257703',4906781,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257703',4906782,'2698','405',406507.79,409406.05,2898.26,478212.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257703',4906783,'2699','405',709443.74,713479.71,4035.97,665935.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257703',4906784,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257703',4906785,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257703',4906786,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257703',4906787,'2703','406',1306631.90,1309836.52,3204.62,2115049.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257703',4906788,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257704',4906789,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257704',4906790,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257704',4906791,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257704',4906792,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257704',4906793,'2698','405',409406.05,413616.34,4210.29,694697.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257704',4906794,'2699','405',713479.71,718401.22,4921.51,812049.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257704',4906795,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257704',4906796,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257704',4906797,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257704',4906798,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257704',4906799,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257705',4906800,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257705',4906801,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257705',4906802,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257705',4906803,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257705',4906804,'2698','405',413616.34,414918.56,1302.22,214866.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257705',4906805,'2699','405',718401.22,720141.30,1740.08,287113.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257705',4906806,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257705',4906807,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257705',4906808,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257705',4906809,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257705',4906810,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257706',4906811,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257706',4906812,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257706',4906813,'2696','405',801551.19,801551.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257706',4906814,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257706',4906815,'2698','405',414918.56,414918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257706',4906816,'2699','405',720141.30,721869.55,1728.25,285161.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257706',4906817,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257706',4906818,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257706',4906819,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257706',4906820,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257706',4906821,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257707',4906822,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257707',4906823,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257707',4906824,'2696','405',801551.19,803153.92,1602.73,264450.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','257707',4906825,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257707',4906826,'2698','405',414918.56,417857.25,2938.69,484883.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257707',4906827,'2699','405',721869.55,725783.82,3914.27,645854.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257707',4906828,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257707',4906829,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257707',4906830,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257707',4906831,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257707',4906832,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257708',4906833,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257708',4906834,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257708',4906835,'2696','405',803153.92,803153.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257708',4906836,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257708',4906837,'2698','405',417857.25,421640.49,3783.24,624234.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257708',4906838,'2699','405',725783.82,729818.53,4034.71,665727.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257708',4906839,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257708',4906840,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257708',4906841,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257708',4906842,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257708',4906843,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257709',4906844,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257709',4906845,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257709',4906846,'2696','405',803153.92,803153.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257709',4906847,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257709',4906848,'2698','405',421640.49,426823.04,5182.55,855120.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257709',4906849,'2699','405',729818.53,736379.01,6560.48,1082479.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257709',4906850,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257709',4906851,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257709',4906852,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257709',4906853,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257709',4906854,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257710',4906855,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257710',4906856,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257710',4906857,'2696','405',803153.92,803153.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257710',4906858,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257710',4906859,'2698','405',426823.04,431808.52,4985.48,822604.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257710',4906860,'2699','405',736379.01,742702.31,6323.30,1043344.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257710',4906861,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257710',4906862,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257710',4906863,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257710',4906864,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257710',4906865,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257711',4906866,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257711',4906867,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257711',4906868,'2696','405',803153.92,805910.68,2756.76,454865.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','257711',4906869,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257711',4906870,'2698','405',431808.52,436013.51,4204.99,693823.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257711',4906871,'2699','405',742702.31,747984.57,5282.26,871572.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257711',4906872,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257711',4906873,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257711',4906874,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257711',4906875,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257711',4906876,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257712',4906877,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257712',4906878,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257712',4906879,'2696','405',805910.68,809182.92,3272.24,539919.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257712',4906880,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257712',4906881,'2698','405',436013.51,438845.05,2831.54,467204.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257712',4906882,'2699','405',747984.57,754482.27,6497.70,1072120.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257712',4906883,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257712',4906884,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257712',4906885,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257712',4906886,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257712',4906887,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257713',4906888,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257713',4906889,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257713',4906890,'2696','405',809182.92,815713.47,6530.55,1077540.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','257713',4906891,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257713',4906892,'2698','405',438845.05,439829.49,984.44,162432.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257713',4906893,'2699','405',754482.27,760224.70,5742.43,947500.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257713',4906894,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257713',4906895,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257713',4906896,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257713',4906897,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257713',4906898,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257714',4906899,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257714',4906900,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257714',4906901,'2696','405',815713.47,822768.21,7054.74,1164032.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257714',4906902,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257714',4906903,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257714',4906904,'2699','405',760224.70,765949.43,5724.73,944580.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257714',4906905,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257714',4906906,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257714',4906907,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257714',4906908,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257714',4906909,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257715',4906910,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257715',4906911,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257715',4906912,'2696','405',822768.21,828263.25,5495.04,906681.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257715',4906913,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257715',4906914,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257715',4906915,'2699','405',765949.43,770677.06,4727.63,780058.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257715',4906916,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257715',4906917,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257715',4906918,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257715',4906919,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257715',4906920,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257716',4906921,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257716',4906922,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257716',4906923,'2696','405',828263.25,834007.17,5743.92,947746.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','257716',4906924,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257716',4906925,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257716',4906926,'2699','405',770677.06,774755.19,4078.13,672891.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257716',4906927,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257716',4906928,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257716',4906929,'2702','406',462176.67,462176.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257716',4906930,'2703','406',1309836.52,1309836.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257716',4906931,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257717',4906932,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257717',4906933,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257717',4906934,'2696','405',834007.17,840328.39,6321.22,1043001.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','257717',4906935,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257717',4906936,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257717',4906937,'2699','405',774755.19,778938.39,4183.20,690228.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257717',4906938,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257717',4906939,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257717',4906940,'2702','406',462176.67,463199.53,1022.86,675087.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257717',4906941,'2703','406',1309836.52,1309905.80,69.28,45724.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257717',4906942,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257718',4906943,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257718',4906944,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257718',4906945,'2696','405',840328.39,841864.74,1536.35,253497.75,0.00,0.00,0.00,0.00,0.00),('5','172','911','257718',4906946,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257718',4906947,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257718',4906948,'2699','405',778938.39,780224.83,1286.44,212262.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257718',4906949,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257718',4906950,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257718',4906951,'2702','406',463199.53,465999.58,2800.05,1960035.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257718',4906952,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257718',4906953,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257719',4906954,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257719',4906955,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257719',4906956,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257719',4906957,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257719',4906958,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257719',4906959,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257719',4906960,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257719',4906961,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257719',4906962,'2702','406',465999.58,469266.27,3266.69,2286683.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257719',4906963,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257719',4906964,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257720',4906965,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257720',4906966,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257720',4906967,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257720',4906968,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257720',4906969,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257720',4906970,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257720',4906971,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257720',4906972,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257720',4906973,'2702','406',469266.27,473262.69,3996.42,2797494.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257720',4906974,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257720',4906975,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257721',4906976,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257721',4906977,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257721',4906978,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257721',4906979,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257721',4906980,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257721',4906981,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257721',4906982,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257721',4906983,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257721',4906984,'2702','406',473262.69,479506.01,6243.32,4370324.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257721',4906985,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257721',4906986,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257722',4906987,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257722',4906988,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257722',4906989,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257722',4906990,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257722',4906991,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257722',4906992,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257722',4906993,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257722',4906994,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257722',4906995,'2702','406',479506.01,485216.73,5710.72,3997504.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257722',4906996,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257722',4906997,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257723',4906998,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257723',4906999,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257723',4907000,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257723',4907001,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257723',4907002,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257723',4907003,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257723',4907004,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257723',4907005,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257723',4907006,'2702','406',485216.73,494339.16,9122.43,6385701.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257723',4907007,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257723',4907008,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257724',4907009,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257724',4907010,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257724',4907011,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257724',4907012,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257724',4907013,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257724',4907014,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257724',4907015,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257724',4907016,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257724',4907017,'2702','406',494339.16,499461.96,5122.80,3585960.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257724',4907018,'2703','406',1309905.80,1309905.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257724',4907019,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257725',4907020,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257725',4907021,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257725',4907022,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257725',4907023,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257725',4907024,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257725',4907025,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257725',4907026,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257725',4907027,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257725',4907028,'2702','406',499461.96,502602.43,3140.47,2198329.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257725',4907029,'2703','406',1309905.80,1312242.99,2337.19,1636033.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257725',4907030,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257726',4907031,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257726',4907032,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257726',4907033,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257726',4907034,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257726',4907035,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257726',4907036,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257726',4907037,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257726',4907038,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257726',4907039,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257726',4907040,'2703','406',1312242.99,1317767.76,5524.77,3867339.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257726',4907041,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257727',4907042,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257727',4907043,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257727',4907044,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257727',4907045,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257727',4907046,'2698','405',439829.49,439829.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257727',4907047,'2699','405',780224.83,780224.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257727',4907048,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257727',4907049,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257727',4907050,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257727',4907051,'2703','406',1317767.76,1321812.35,4044.59,2831213.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257727',4907052,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257728',4907053,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257728',4907054,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257728',4907055,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257728',4907056,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257728',4907057,'2698','405',439829.49,441892.85,2063.36,340454.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257728',4907058,'2699','405',780224.83,782364.86,2140.03,353104.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257728',4907059,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257728',4907060,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257728',4907061,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257728',4907062,'2703','406',1321812.35,1327392.95,5580.60,3906420.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257728',4907063,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257729',4907064,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257729',4907065,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257729',4907066,'2696','405',841864.74,841864.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257729',4907067,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257729',4907068,'2698','405',441892.85,445477.15,3584.30,591409.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257729',4907069,'2699','405',782364.86,786524.20,4159.34,686291.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257729',4907070,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257729',4907071,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257729',4907072,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257729',4907073,'2703','406',1327392.95,1333354.39,5961.44,4173008.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257729',4907074,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257730',4907075,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257730',4907076,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257730',4907077,'2696','405',841864.74,849830.53,7965.79,1314355.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','257730',4907078,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257730',4907079,'2698','405',445477.15,446451.90,974.75,160833.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257730',4907080,'2699','405',786524.20,788486.83,1962.63,323833.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257730',4907081,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257730',4907082,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257730',4907083,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257730',4907084,'2703','406',1333354.39,1342757.30,9402.91,6582037.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257730',4907085,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257731',4907086,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257731',4907087,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257731',4907088,'2696','405',849830.53,855374.82,5544.29,914807.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257731',4907089,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257731',4907090,'2698','405',446451.90,449492.89,3040.99,501763.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257731',4907091,'2699','405',788486.83,794468.26,5981.43,986935.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257731',4907092,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257731',4907093,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257731',4907094,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257731',4907095,'2703','406',1342757.30,1347622.12,4864.82,3405374.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257731',4907096,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257732',4907097,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257732',4907098,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257732',4907099,'2696','405',855374.82,861251.70,5876.88,969685.20,0.00,0.00,0.00,0.00,0.00),('5','172','911','257732',4907100,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257732',4907101,'2698','405',449492.89,453874.78,4381.89,723011.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257732',4907102,'2699','405',794468.26,794468.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257732',4907103,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257732',4907104,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257732',4907105,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257732',4907106,'2703','406',1347622.12,1349434.34,1812.22,1268554.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257732',4907107,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257733',4907108,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257733',4907109,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257733',4907110,'2696','405',861251.70,861251.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257733',4907111,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257733',4907112,'2698','405',453874.78,457958.74,4083.96,673853.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257733',4907113,'2699','405',794468.26,798517.16,4048.90,668068.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257733',4907114,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257733',4907115,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257733',4907116,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257733',4907117,'2703','406',1349434.34,1349434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257733',4907118,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257734',4907119,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257734',4907120,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257734',4907121,'2696','405',861251.70,866548.73,5297.03,874009.95,0.00,0.00,0.00,0.00,0.00),('5','172','911','257734',4907122,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257734',4907123,'2698','405',457958.74,459378.36,1419.62,234237.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257734',4907124,'2699','405',798517.16,800591.58,2074.42,342279.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257734',4907125,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257734',4907126,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257734',4907127,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257734',4907128,'2703','406',1349434.34,1349434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257734',4907129,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257735',4907130,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257735',4907131,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257735',4907132,'2696','405',866548.73,873190.12,6641.39,1095829.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','257735',4907133,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257735',4907134,'2698','405',459378.36,463118.24,3739.88,617080.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257735',4907135,'2699','405',800591.58,804277.32,3685.74,608147.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257735',4907136,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257735',4907137,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257735',4907138,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257735',4907139,'2703','406',1349434.34,1349434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257735',4907140,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257736',4907141,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257736',4907142,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257736',4907143,'2696','405',873190.12,876313.68,3123.56,515387.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','257736',4907144,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257736',4907145,'2698','405',463118.24,465539.73,2421.49,399545.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257736',4907146,'2699','405',804277.32,806022.42,1745.10,287941.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257736',4907147,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257736',4907148,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257736',4907149,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257736',4907150,'2703','406',1349434.34,1349434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257736',4907151,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257737',4907152,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257737',4907153,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257737',4907154,'2696','405',876313.68,880913.77,4600.09,759014.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257737',4907155,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257737',4907156,'2698','405',465539.73,469309.21,3769.48,621964.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257737',4907157,'2699','405',806022.42,809228.20,3205.78,528953.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257737',4907158,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257737',4907159,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257737',4907160,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257737',4907161,'2703','406',1349434.34,1349434.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257737',4907162,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257738',4907163,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257738',4907164,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257738',4907165,'2696','405',880913.77,886757.07,5843.30,964144.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','257738',4907166,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257738',4907167,'2698','405',469309.21,473052.55,3743.34,617651.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257738',4907168,'2699','405',809228.20,813359.59,4131.39,681679.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257738',4907169,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257738',4907170,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257738',4907171,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257738',4907172,'2703','406',1349434.34,1349506.65,72.31,50617.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257738',4907173,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257739',4907174,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257739',4907175,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257739',4907176,'2696','405',886757.07,887273.76,516.69,85253.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257739',4907177,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257739',4907178,'2698','405',473052.55,476124.18,3071.63,506818.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257739',4907179,'2699','405',813359.59,816995.83,3636.24,599979.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257739',4907180,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257739',4907181,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257739',4907182,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257739',4907183,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257739',4907184,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257740',4907185,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257740',4907186,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257740',4907187,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257740',4907188,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257740',4907189,'2698','405',476124.18,479417.81,3293.63,543448.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257740',4907190,'2699','405',816995.83,820578.25,3582.42,591099.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257740',4907191,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257740',4907192,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257740',4907193,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257740',4907194,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257740',4907195,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257741',4907196,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257741',4907197,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257741',4907198,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257741',4907199,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257741',4907200,'2698','405',479417.81,482706.61,3288.80,542652.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257741',4907201,'2699','405',820578.25,824001.21,3422.96,564788.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257741',4907202,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257741',4907203,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257741',4907204,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257741',4907205,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257741',4907206,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257742',4907207,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257742',4907208,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257742',4907209,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257742',4907210,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257742',4907211,'2698','405',482706.61,488447.41,5740.80,947232.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257742',4907212,'2699','405',824001.21,829606.92,5605.71,924942.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257742',4907213,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257742',4907214,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257742',4907215,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257742',4907216,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257742',4907217,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257743',4907218,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257743',4907219,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257743',4907220,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257743',4907221,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257743',4907222,'2698','405',488447.41,495333.12,6885.71,1136142.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257743',4907223,'2699','405',829606.92,836700.28,7093.36,1170404.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257743',4907224,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257743',4907225,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257743',4907226,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257743',4907227,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257743',4907228,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257744',4907229,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257744',4907230,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257744',4907231,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257744',4907232,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257744',4907233,'2698','405',495333.12,499565.49,4232.37,698341.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257744',4907234,'2699','405',836700.28,840585.26,3884.98,641021.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257744',4907235,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257744',4907236,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257744',4907237,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257744',4907238,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257744',4907239,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257745',4907240,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257745',4907241,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257745',4907242,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257745',4907243,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257745',4907244,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257745',4907245,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257745',4907246,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257745',4907247,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257745',4907248,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257745',4907249,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257745',4907250,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257746',4907251,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257746',4907252,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257746',4907253,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257746',4907254,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257746',4907255,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257746',4907256,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257746',4907257,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257746',4907258,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257746',4907259,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257746',4907260,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257746',4907261,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257747',4907262,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257747',4907263,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257747',4907264,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257747',4907265,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257747',4907266,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257747',4907267,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257747',4907268,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257747',4907269,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257747',4907270,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257747',4907271,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257747',4907272,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257748',4907273,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257748',4907274,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257748',4907275,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257748',4907276,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257748',4907277,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257748',4907278,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257748',4907279,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257748',4907280,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257748',4907281,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257748',4907282,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257748',4907283,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257749',4907284,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257749',4907285,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257749',4907286,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257749',4907287,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257749',4907288,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257749',4907289,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257749',4907290,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257749',4907291,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257749',4907292,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257749',4907293,'2703','406',1349506.65,1349506.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257749',4907294,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257750',4907295,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257750',4907296,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257750',4907297,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257750',4907298,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257750',4907299,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257750',4907300,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257750',4907301,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257750',4907302,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257750',4907303,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257750',4907304,'2703','406',1349506.65,1350714.40,1207.75,942045.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257750',4907305,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257751',4907306,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257751',4907307,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257751',4907308,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257751',4907309,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257751',4907310,'2698','405',499565.49,499565.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257751',4907311,'2699','405',840585.26,840585.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257751',4907312,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257751',4907313,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257751',4907314,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257751',4907315,'2703','406',1350714.40,1353969.42,3255.02,2538915.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257751',4907316,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257752',4907317,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257752',4907318,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257752',4907319,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257752',4907320,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257752',4907321,'2698','405',499565.49,502621.75,3056.26,504282.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257752',4907322,'2699','405',840585.26,843608.26,3023.00,498795.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257752',4907323,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257752',4907324,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257752',4907325,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257752',4907326,'2703','406',1353969.42,1355453.04,1483.62,1157223.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257752',4907327,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257753',4907328,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257753',4907329,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257753',4907330,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257753',4907331,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257753',4907332,'2698','405',502621.75,509184.54,6562.79,1082860.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257753',4907333,'2699','405',843608.26,848410.36,4802.10,792346.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257753',4907334,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257753',4907335,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257753',4907336,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257753',4907337,'2703','406',1355453.04,1357858.78,2405.74,1876477.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257753',4907338,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257754',4907339,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257754',4907340,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257754',4907341,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257754',4907342,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257754',4907343,'2698','405',509184.54,516657.12,7472.58,1232975.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257754',4907344,'2699','405',848410.36,857959.63,9549.27,1575629.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257754',4907345,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257754',4907346,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257754',4907347,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257754',4907348,'2703','406',1357858.78,1362633.35,4774.57,3724164.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257754',4907349,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257755',4907350,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257755',4907351,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257755',4907352,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257755',4907353,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257755',4907354,'2698','405',516657.12,523575.10,6917.98,1141466.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257755',4907355,'2699','405',857959.63,865057.45,7097.82,1171140.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257755',4907356,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257755',4907357,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257755',4907358,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257755',4907359,'2703','406',1362633.35,1367144.65,4511.30,3518814.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257755',4907360,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257756',4907361,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257756',4907362,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257756',4907363,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257756',4907364,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257756',4907365,'2698','405',523575.10,527912.87,4337.77,715732.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257756',4907366,'2699','405',865057.45,869703.90,4646.45,766664.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257756',4907367,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257756',4907368,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257756',4907369,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257756',4907370,'2703','406',1367144.65,1371521.41,4376.76,3413872.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257756',4907371,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257757',4907372,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257757',4907373,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257757',4907374,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257757',4907375,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257757',4907376,'2698','405',527912.87,533057.61,5144.74,848882.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257757',4907377,'2699','405',869703.90,875307.28,5603.38,924557.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257757',4907378,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257757',4907379,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257757',4907380,'2702','406',502602.43,502602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257757',4907381,'2703','406',1371521.41,1375255.15,3733.74,2912317.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257757',4907382,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257758',4907383,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257758',4907384,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257758',4907385,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257758',4907386,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257758',4907387,'2698','405',533057.61,537933.64,4876.03,804544.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257758',4907388,'2699','405',875307.28,881238.72,5931.44,978687.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257758',4907389,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257758',4907390,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257758',4907391,'2702','406',502602.43,503685.58,1083.15,844857.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257758',4907392,'2703','406',1375255.15,1376613.58,1358.43,1059575.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257758',4907393,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257759',4907394,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257759',4907395,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257759',4907396,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257759',4907397,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257759',4907398,'2698','405',537933.64,540452.99,2519.35,415692.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257759',4907399,'2699','405',881238.72,884718.39,3479.67,574145.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257759',4907400,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257759',4907401,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257759',4907402,'2702','406',503685.58,503685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257759',4907403,'2703','406',1376613.58,1383564.70,6951.12,5421873.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257759',4907404,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257760',4907405,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257760',4907406,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257760',4907407,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257760',4907408,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257760',4907409,'2698','405',540452.99,540452.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257760',4907410,'2699','405',884718.39,884718.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257760',4907411,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257760',4907412,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257760',4907413,'2702','406',503685.58,503685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257760',4907414,'2703','406',1383564.70,1388673.14,5108.44,3984583.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257760',4907415,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257761',4907416,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257761',4907417,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257761',4907418,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257761',4907419,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257761',4907420,'2698','405',540452.99,540452.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257761',4907421,'2699','405',884718.39,884718.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257761',4907422,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257761',4907423,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257761',4907424,'2702','406',503685.58,503685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257761',4907425,'2703','406',1388673.14,1392411.97,3738.83,2916287.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257761',4907426,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257762',4907427,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257762',4907428,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257762',4907429,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257762',4907430,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257762',4907431,'2698','405',540452.99,540452.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257762',4907432,'2699','405',884718.39,884718.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257762',4907433,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257762',4907434,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257762',4907435,'2702','406',503685.58,504444.39,758.81,591871.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257762',4907436,'2703','406',1392411.97,1394887.77,2475.80,1931124.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257762',4907437,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257763',4907438,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257763',4907439,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257763',4907440,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257763',4907441,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257763',4907442,'2698','405',540452.99,542678.07,2225.08,367138.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257763',4907443,'2699','405',884718.39,889136.76,4418.37,729031.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257763',4907444,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257763',4907445,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257763',4907446,'2702','406',504444.39,507807.72,3363.33,2623397.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257763',4907447,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257763',4907448,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257764',4907449,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257764',4907450,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257764',4907451,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257764',4907452,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257764',4907453,'2698','405',542678.07,547855.91,5177.84,854343.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257764',4907454,'2699','405',889136.76,895767.21,6630.45,1094024.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257764',4907455,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257764',4907456,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257764',4907457,'2702','406',507807.72,511580.59,3772.87,2942838.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257764',4907458,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257764',4907459,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257765',4907460,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257765',4907461,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257765',4907462,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257765',4907463,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257765',4907464,'2698','405',547855.91,549159.50,1303.59,215092.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257765',4907465,'2699','405',895767.21,903768.34,8001.13,1320186.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257765',4907466,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257765',4907467,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257765',4907468,'2702','406',511580.59,517129.84,5549.25,4328415.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257765',4907469,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257765',4907470,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257766',4907471,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257766',4907472,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257766',4907473,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257766',4907474,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257766',4907475,'2698','405',549159.50,549250.29,90.79,14980.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257766',4907476,'2699','405',903768.34,909198.42,5430.08,895963.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257766',4907477,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257766',4907478,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257766',4907479,'2702','406',517129.84,519870.37,2740.53,2137613.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257766',4907480,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257766',4907481,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257767',4907482,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257767',4907483,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257767',4907484,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257767',4907485,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257767',4907486,'2698','405',549250.29,550568.73,1318.44,217542.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257767',4907487,'2699','405',909198.42,916104.24,6905.82,1139460.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257767',4907488,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257767',4907489,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257767',4907490,'2702','406',519870.37,524663.47,4793.10,3738618.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257767',4907491,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257767',4907492,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257768',4907493,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257768',4907494,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257768',4907495,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257768',4907496,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257768',4907497,'2698','405',550568.73,552264.51,1695.78,279803.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257768',4907498,'2699','405',916104.24,918038.50,1934.26,319152.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257768',4907499,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257768',4907500,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257768',4907501,'2702','406',524663.47,527550.21,2886.74,2251657.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257768',4907502,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257768',4907503,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257769',4907504,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257769',4907505,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257769',4907506,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257769',4907507,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257769',4907508,'2698','405',552264.51,554891.03,2626.52,433375.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257769',4907509,'2699','405',918038.50,920676.68,2638.18,435299.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257769',4907510,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257769',4907511,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257769',4907512,'2702','406',527550.21,532563.00,5012.79,3909976.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257769',4907513,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257769',4907514,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257770',4907515,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257770',4907516,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257770',4907517,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257770',4907518,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257770',4907519,'2698','405',554891.03,559341.51,4450.48,734329.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257770',4907520,'2699','405',920676.68,924780.79,4104.11,677178.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257770',4907521,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257770',4907522,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257770',4907523,'2702','406',532563.00,537949.83,5386.83,4201727.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257770',4907524,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257770',4907525,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257771',4907526,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257771',4907527,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257771',4907528,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257771',4907529,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257771',4907530,'2698','405',559341.51,564367.46,5025.95,829281.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257771',4907531,'2699','405',924780.79,930236.99,5456.20,900273.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257771',4907532,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257771',4907533,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257771',4907534,'2702','406',537949.83,542779.13,4829.30,3766854.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257771',4907535,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257771',4907536,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257772',4907537,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257772',4907538,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257772',4907539,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257772',4907540,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257772',4907541,'2698','405',564367.46,569068.29,4700.83,775636.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257772',4907542,'2699','405',930236.99,933088.17,2851.18,470444.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257772',4907543,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257772',4907544,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257772',4907545,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257772',4907546,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257772',4907547,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257773',4907548,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257773',4907549,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257773',4907550,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257773',4907551,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257773',4907552,'2698','405',569068.29,572885.83,3817.54,629894.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257773',4907553,'2699','405',933088.17,936776.71,3688.54,608609.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257773',4907554,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257773',4907555,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257773',4907556,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257773',4907557,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257773',4907558,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257774',4907559,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257774',4907560,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257774',4907561,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257774',4907562,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257774',4907563,'2698','405',572885.83,574485.62,1599.79,263965.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257774',4907564,'2699','405',936776.71,941133.14,4356.43,718810.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257774',4907565,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257774',4907566,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257774',4907567,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257774',4907568,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257774',4907569,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257775',4907570,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257775',4907571,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257775',4907572,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257775',4907573,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257775',4907574,'2698','405',574485.62,574485.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257775',4907575,'2699','405',941133.14,941133.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257775',4907576,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257775',4907577,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257775',4907578,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257775',4907579,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257775',4907580,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257776',4907581,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257776',4907582,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257776',4907583,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257776',4907584,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257776',4907585,'2698','405',574485.62,577635.45,3149.83,519721.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257776',4907586,'2699','405',941133.14,945545.11,4411.97,727975.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257776',4907587,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257776',4907588,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257776',4907589,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257776',4907590,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257776',4907591,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257777',4907592,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257777',4907593,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257777',4907594,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257777',4907595,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257777',4907596,'2698','405',577635.45,580196.93,2561.48,473873.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257777',4907597,'2699','405',945545.11,949428.22,3883.11,718375.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257777',4907598,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257777',4907599,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257777',4907600,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257777',4907601,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257777',4907602,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257778',4907603,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257778',4907604,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257778',4907605,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257778',4907606,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257778',4907607,'2698','405',580196.93,582158.72,1961.79,362931.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257778',4907608,'2699','405',949428.22,954917.94,5489.72,1015598.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257778',4907609,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257778',4907610,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257778',4907611,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257778',4907612,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257778',4907613,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257779',4907614,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257779',4907615,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257779',4907616,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257779',4907617,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257779',4907618,'2698','405',582158.72,584791.33,2632.61,487032.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257779',4907619,'2699','405',954917.94,957556.87,2638.93,488202.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257779',4907620,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257779',4907621,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257779',4907622,'2702','406',542779.13,542779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257779',4907623,'2703','406',1394887.77,1394887.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257779',4907624,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257780',4907625,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257780',4907626,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257780',4907627,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257780',4907628,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257780',4907629,'2698','405',584791.33,588364.63,3573.30,661060.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257780',4907630,'2699','405',957556.87,961021.35,3464.48,640928.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257780',4907631,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257780',4907632,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257780',4907633,'2702','406',542779.13,542799.20,20.07,15654.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257780',4907634,'2703','406',1394887.77,1395877.77,990.00,772200.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257780',4907635,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257781',4907636,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257781',4907637,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257781',4907638,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257781',4907639,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257781',4907640,'2698','405',588364.63,593211.41,4846.78,896654.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257781',4907641,'2699','405',961021.35,964174.57,3153.22,583345.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257781',4907642,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257781',4907643,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257781',4907644,'2702','406',542799.20,542799.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257781',4907645,'2703','406',1395877.77,1397644.94,1767.17,1378392.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257781',4907646,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257782',4907647,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257782',4907648,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257782',4907649,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257782',4907650,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257782',4907651,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257782',4907652,'2699','405',964174.57,967932.87,3758.30,695285.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257782',4907653,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257782',4907654,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257782',4907655,'2702','406',542799.20,542799.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257782',4907656,'2703','406',1397644.94,1400433.27,2788.33,2174897.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257782',4907657,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257783',4907658,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257783',4907659,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257783',4907660,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257783',4907661,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257783',4907662,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257783',4907663,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257783',4907664,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257783',4907665,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257783',4907666,'2702','406',542799.20,544476.48,1677.28,1308278.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257783',4907667,'2703','406',1400433.27,1401655.69,1222.42,953487.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257783',4907668,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257784',4907669,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257784',4907670,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257784',4907671,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257784',4907672,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257784',4907673,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257784',4907674,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257784',4907675,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257784',4907676,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257784',4907677,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257784',4907678,'2703','406',1401655.69,1407113.54,5457.85,4257123.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257784',4907679,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257785',4907680,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257785',4907681,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257785',4907682,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257785',4907683,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257785',4907684,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257785',4907685,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257785',4907686,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257785',4907687,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257785',4907688,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257785',4907689,'2703','406',1407113.54,1410851.96,3738.42,2915967.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257785',4907690,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257786',4907691,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257786',4907692,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257786',4907693,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257786',4907694,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257786',4907695,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257786',4907696,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257786',4907697,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257786',4907698,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257786',4907699,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257786',4907700,'2703','406',1410851.96,1414285.17,3433.21,2677903.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257786',4907701,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257787',4907702,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257787',4907703,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257787',4907704,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257787',4907705,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257787',4907706,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257787',4907707,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257787',4907708,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257787',4907709,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257787',4907710,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257787',4907711,'2703','406',1414285.17,1418129.05,3843.88,2998226.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257787',4907712,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257788',4907713,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257788',4907714,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257788',4907715,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257788',4907716,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257788',4907717,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257788',4907718,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257788',4907719,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257788',4907720,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257788',4907721,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257788',4907722,'2703','406',1418129.05,1421639.38,3510.33,2738057.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257788',4907723,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257789',4907724,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257789',4907725,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257789',4907726,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257789',4907727,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257789',4907728,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257789',4907729,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257789',4907730,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257789',4907731,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257789',4907732,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257789',4907733,'2703','406',1421639.38,1425357.00,3717.62,2899743.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257789',4907734,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257790',4907735,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257790',4907736,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257790',4907737,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257790',4907738,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257790',4907739,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257790',4907740,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257790',4907741,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257790',4907742,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257790',4907743,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257790',4907744,'2703','406',1425357.00,1430732.00,5375.00,4192500.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257790',4907745,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257791',4907746,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257791',4907747,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257791',4907748,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257791',4907749,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257791',4907750,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257791',4907751,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257791',4907752,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257791',4907753,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257791',4907754,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257791',4907755,'2703','406',1430732.00,1432960.25,2228.25,1738035.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257791',4907756,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257792',4907757,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257792',4907758,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257792',4907759,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257792',4907760,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257792',4907761,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257792',4907762,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257792',4907763,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257792',4907764,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257792',4907765,'2702','406',544476.48,544476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257792',4907766,'2703','406',1432960.25,1439272.84,6312.59,4923820.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257792',4907767,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257793',4907768,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257793',4907769,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257793',4907770,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257793',4907771,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257793',4907772,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257793',4907773,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257793',4907774,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257793',4907775,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257793',4907776,'2702','406',544476.48,548060.08,3583.60,2795208.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257793',4907777,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257793',4907778,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257794',4907779,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257794',4907780,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257794',4907781,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257794',4907782,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257794',4907783,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257794',4907784,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257794',4907785,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257794',4907786,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257794',4907787,'2702','406',548060.08,552079.51,4019.43,3135155.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257794',4907788,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257794',4907789,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257795',4907790,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257795',4907791,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257795',4907792,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257795',4907793,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257795',4907794,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257795',4907795,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257795',4907796,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257795',4907797,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257795',4907798,'2702','406',552079.51,555628.26,3548.75,2768025.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257795',4907799,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257795',4907800,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257796',4907801,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257796',4907802,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257796',4907803,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257796',4907804,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257796',4907805,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257796',4907806,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257796',4907807,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257796',4907808,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257796',4907809,'2702','406',555628.26,559017.18,3388.92,2643357.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257796',4907810,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257796',4907811,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257797',4907812,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257797',4907813,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257797',4907814,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257797',4907815,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257797',4907816,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257797',4907817,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257797',4907818,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257797',4907819,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257797',4907820,'2702','406',559017.18,562902.60,3885.42,3030627.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257797',4907821,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257797',4907822,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257798',4907823,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257798',4907824,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257798',4907825,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257798',4907826,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257798',4907827,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257798',4907828,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257798',4907829,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257798',4907830,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257798',4907831,'2702','406',562902.60,567054.20,4151.60,3238248.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257798',4907832,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257798',4907833,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257799',4907834,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257799',4907835,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257799',4907836,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257799',4907837,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257799',4907838,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257799',4907839,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257799',4907840,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257799',4907841,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257799',4907842,'2702','406',567054.20,569253.46,2199.26,1715422.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257799',4907843,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257799',4907844,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257800',4907845,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257800',4907846,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257800',4907847,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257800',4907848,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257800',4907849,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257800',4907850,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257800',4907851,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257800',4907852,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257800',4907853,'2702','406',569253.46,573786.46,4533.00,3535740.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257800',4907854,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257800',4907855,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257801',4907856,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257801',4907857,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257801',4907858,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257801',4907859,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257801',4907860,'2698','405',593211.41,593211.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257801',4907861,'2699','405',967932.87,967932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257801',4907862,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257801',4907863,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257801',4907864,'2702','406',573786.46,577134.21,3347.75,2611245.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257801',4907865,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257801',4907866,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257802',4907867,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257802',4907868,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257802',4907869,'2696','405',887273.76,887273.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257802',4907870,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257802',4907871,'2698','405',593211.41,595522.59,2311.18,427568.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257802',4907872,'2699','405',967932.87,970964.10,3031.23,560777.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257802',4907873,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257802',4907874,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257802',4907875,'2702','406',577134.21,579863.98,2729.77,2129220.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257802',4907876,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257802',4907877,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257803',4907878,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257803',4907879,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257803',4907880,'2696','405',887273.76,891725.01,4451.25,823481.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','257803',4907881,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257803',4907882,'2698','405',595522.59,596834.53,1311.94,242708.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257803',4907883,'2699','405',970964.10,974748.83,3784.73,700175.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257803',4907884,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257803',4907885,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257803',4907886,'2702','406',579863.98,583546.17,3682.19,2872108.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257803',4907887,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257803',4907888,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257804',4907889,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257804',4907890,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257804',4907891,'2696','405',891725.01,897641.85,5916.84,1094615.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','257804',4907892,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257804',4907893,'2698','405',596834.53,596834.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257804',4907894,'2699','405',974748.83,979414.44,4665.61,863137.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257804',4907895,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257804',4907896,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257804',4907897,'2702','406',583546.17,586342.72,2796.55,2181309.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257804',4907898,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257804',4907899,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257805',4907900,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257805',4907901,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257805',4907902,'2696','405',897641.85,903319.31,5677.46,1050330.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257805',4907903,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257805',4907904,'2698','405',596834.53,601993.41,5158.88,954392.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257805',4907905,'2699','405',979414.44,979851.63,437.19,80880.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257805',4907906,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257805',4907907,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257805',4907908,'2702','406',586342.72,587700.05,1357.33,1058717.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257805',4907909,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257805',4907910,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257806',4907911,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257806',4907912,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257806',4907913,'2696','405',903319.31,909676.04,6356.73,1175995.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257806',4907914,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257806',4907915,'2698','405',601993.41,602939.32,945.91,174993.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257806',4907916,'2699','405',979851.63,984040.91,4189.28,775016.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257806',4907917,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257806',4907918,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257806',4907919,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257806',4907920,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257806',4907921,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257807',4907922,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257807',4907923,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257807',4907924,'2696','405',909676.04,916046.67,6370.63,1178566.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','257807',4907925,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257807',4907926,'2698','405',602939.32,605958.20,3018.88,558492.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257807',4907927,'2699','405',984040.91,986122.64,2081.73,385120.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257807',4907928,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257807',4907929,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257807',4907930,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257807',4907931,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257807',4907932,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257808',4907933,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257808',4907934,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257808',4907935,'2696','405',916046.67,921176.11,5129.44,948946.40,0.00,0.00,0.00,0.00,0.00),('5','172','911','257808',4907936,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257808',4907937,'2698','405',605958.20,605958.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257808',4907938,'2699','405',986122.64,990185.75,4063.11,751675.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257808',4907939,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257808',4907940,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257808',4907941,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257808',4907942,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257808',4907943,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257809',4907944,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257809',4907945,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257809',4907946,'2696','405',921176.11,926404.91,5228.80,967328.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257809',4907947,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257809',4907948,'2698','405',605958.20,606970.82,1012.62,187334.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257809',4907949,'2699','405',990185.75,993697.18,3511.43,649614.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257809',4907950,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257809',4907951,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257809',4907952,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257809',4907953,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257809',4907954,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257810',4907955,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257810',4907956,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257810',4907957,'2696','405',926404.91,928456.70,2051.79,379581.15,0.00,0.00,0.00,0.00,0.00),('5','172','911','257810',4907958,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257810',4907959,'2698','405',606970.82,608310.31,1339.49,247805.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257810',4907960,'2699','405',993697.18,997741.83,4044.65,748260.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257810',4907961,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257810',4907962,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257810',4907963,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257810',4907964,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257810',4907965,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257811',4907966,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257811',4907967,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257811',4907968,'2696','405',928456.70,932219.23,3762.53,696068.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257811',4907969,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257811',4907970,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257811',4907971,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257811',4907972,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257811',4907973,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257811',4907974,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257811',4907975,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257811',4907976,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257812',4907977,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257812',4907978,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257812',4907979,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257812',4907980,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257812',4907981,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257812',4907982,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257812',4907983,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257812',4907984,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257812',4907985,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257812',4907986,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257812',4907987,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257813',4907988,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257813',4907989,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257813',4907990,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257813',4907991,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257813',4907992,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257813',4907993,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257813',4907994,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257813',4907995,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257813',4907996,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257813',4907997,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257813',4907998,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257814',4907999,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257814',4908000,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257814',4908001,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257814',4908002,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257814',4908003,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257814',4908004,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257814',4908005,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257814',4908006,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257814',4908007,'2702','406',587700.05,587700.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257814',4908008,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257814',4908009,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257815',4908010,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257815',4908011,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257815',4908012,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257815',4908013,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257815',4908014,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257815',4908015,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257815',4908016,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257815',4908017,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257815',4908018,'2702','406',587700.05,589506.94,1806.89,1409374.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257815',4908019,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257815',4908020,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257816',4908021,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257816',4908022,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257816',4908023,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257816',4908024,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257816',4908025,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257816',4908026,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257816',4908027,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257816',4908028,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257816',4908029,'2702','406',589506.94,593035.22,3528.28,2752058.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257816',4908030,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257816',4908031,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257817',4908032,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257817',4908033,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257817',4908034,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257817',4908035,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257817',4908036,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257817',4908037,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257817',4908038,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257817',4908039,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257817',4908040,'2702','406',593035.22,594876.36,1841.14,1436089.20,0.00,0.00,0.00,0.00,0.00),('5','172','914','257817',4908041,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257817',4908042,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257818',4908043,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257818',4908044,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257818',4908045,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257818',4908046,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257818',4908047,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257818',4908048,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257818',4908049,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257818',4908050,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257818',4908051,'2702','406',594876.36,596782.77,1906.41,1486999.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257818',4908052,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257818',4908053,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257819',4908054,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257819',4908055,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257819',4908056,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257819',4908057,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257819',4908058,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257819',4908059,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257819',4908060,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257819',4908061,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257819',4908062,'2702','406',596782.77,600487.22,3704.45,2889471.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257819',4908063,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257819',4908064,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257820',4908065,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257820',4908066,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257820',4908067,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257820',4908068,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257820',4908069,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257820',4908070,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257820',4908071,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257820',4908072,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257820',4908073,'2702','406',600487.22,602729.09,2241.87,1748658.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257820',4908074,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257820',4908075,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257821',4908076,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257821',4908077,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257821',4908078,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257821',4908079,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257821',4908080,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257821',4908081,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257821',4908082,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257821',4908083,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257821',4908084,'2702','406',602729.09,604859.50,2130.41,1661719.80,0.00,0.00,0.00,0.00,0.00),('5','172','914','257821',4908085,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257821',4908086,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257822',4908087,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257822',4908088,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257822',4908089,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257822',4908090,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257822',4908091,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257822',4908092,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257822',4908093,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257822',4908094,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257822',4908095,'2702','406',604859.50,607120.63,2261.13,1763681.40,0.00,0.00,0.00,0.00,0.00),('5','172','914','257822',4908096,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257822',4908097,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257823',4908098,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257823',4908099,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257823',4908100,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257823',4908101,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257823',4908102,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257823',4908103,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257823',4908104,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257823',4908105,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257823',4908106,'2702','406',607120.63,610603.73,3483.10,2716818.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257823',4908107,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257823',4908108,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257824',4908109,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257824',4908110,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257824',4908111,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257824',4908112,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257824',4908113,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257824',4908114,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257824',4908115,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257824',4908116,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257824',4908117,'2702','406',610603.73,612469.88,1866.15,1455597.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257824',4908118,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257824',4908119,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257825',4908120,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257825',4908121,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257825',4908122,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257825',4908123,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257825',4908124,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257825',4908125,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257825',4908126,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257825',4908127,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257825',4908128,'2702','406',612469.88,614377.20,1907.32,1487709.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257825',4908129,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257825',4908130,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257826',4908131,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257826',4908132,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257826',4908133,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257826',4908134,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257826',4908135,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257826',4908136,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257826',4908137,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257826',4908138,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257826',4908139,'2702','406',614377.20,614377.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257826',4908140,'2703','406',1439272.84,1439272.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257826',4908141,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257827',4908142,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257827',4908143,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257827',4908144,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257827',4908145,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257827',4908146,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257827',4908147,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257827',4908148,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257827',4908149,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257827',4908150,'2702','406',614377.20,614847.57,470.37,366888.60,0.00,0.00,0.00,0.00,0.00),('5','172','914','257827',4908151,'2703','406',1439272.84,1441997.57,2724.73,2125289.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257827',4908152,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257828',4908153,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257828',4908154,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257828',4908155,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257828',4908156,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257828',4908157,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257828',4908158,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257828',4908159,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257828',4908160,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257828',4908161,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257828',4908162,'2703','406',1441997.57,1445115.92,3118.35,2432313.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257828',4908163,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257829',4908164,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257829',4908165,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257829',4908166,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257829',4908167,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257829',4908168,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257829',4908169,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257829',4908170,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257829',4908171,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257829',4908172,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257829',4908173,'2703','406',1445115.92,1448531.96,3416.04,2664511.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257829',4908174,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257830',4908175,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257830',4908176,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257830',4908177,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257830',4908178,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257830',4908179,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257830',4908180,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257830',4908181,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257830',4908182,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257830',4908183,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257830',4908184,'2703','406',1448531.96,1448531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257830',4908185,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257831',4908186,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257831',4908187,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257831',4908188,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257831',4908189,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257831',4908190,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257831',4908191,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257831',4908192,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257831',4908193,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257831',4908194,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257831',4908195,'2703','406',1448531.96,1450917.73,2385.77,1860900.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257831',4908196,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257832',4908197,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257832',4908198,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257832',4908199,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257832',4908200,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257832',4908201,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257832',4908202,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257832',4908203,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257832',4908204,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257832',4908205,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257832',4908206,'2703','406',1450917.73,1453575.98,2658.25,2073435.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257832',4908207,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257833',4908208,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257833',4908209,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257833',4908210,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257833',4908211,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257833',4908212,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257833',4908213,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257833',4908214,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257833',4908215,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257833',4908216,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257833',4908217,'2703','406',1453575.98,1455100.85,1524.87,1189398.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257833',4908218,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257834',4908219,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257834',4908220,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257834',4908221,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257834',4908222,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257834',4908223,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257834',4908224,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257834',4908225,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257834',4908226,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257834',4908227,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257834',4908228,'2703','406',1455100.85,1455100.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257834',4908229,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257835',4908230,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257835',4908231,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257835',4908232,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257835',4908233,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257835',4908234,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257835',4908235,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257835',4908236,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257835',4908237,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257835',4908238,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257835',4908239,'2703','406',1455100.85,1458947.00,3846.15,2999997.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257835',4908240,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257836',4908241,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257836',4908242,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257836',4908243,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257836',4908244,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257836',4908245,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257836',4908246,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257836',4908247,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257836',4908248,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257836',4908249,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257836',4908250,'2703','406',1458947.00,1461660.94,2713.94,2116873.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257836',4908251,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257837',4908252,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257837',4908253,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257837',4908254,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257837',4908255,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257837',4908256,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257837',4908257,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257837',4908258,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257837',4908259,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257837',4908260,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257837',4908261,'2703','406',1461660.94,1463762.02,2101.08,1638842.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257837',4908262,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257838',4908263,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257838',4908264,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257838',4908265,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257838',4908266,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257838',4908267,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257838',4908268,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257838',4908269,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257838',4908270,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257838',4908271,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257838',4908272,'2703','406',1463762.02,1466378.51,2616.49,2040862.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257838',4908273,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257839',4908274,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257839',4908275,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257839',4908276,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257839',4908277,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257839',4908278,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257839',4908279,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257839',4908280,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257839',4908281,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257839',4908282,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257839',4908283,'2703','406',1466378.51,1467245.16,866.65,675987.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257839',4908284,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257840',4908285,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257840',4908286,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257840',4908287,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257840',4908288,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257840',4908289,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257840',4908290,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257840',4908291,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257840',4908292,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257840',4908293,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257840',4908294,'2703','406',1467245.16,1468829.89,1584.73,1236089.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257840',4908295,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257841',4908296,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257841',4908297,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257841',4908298,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257841',4908299,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257841',4908300,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257841',4908301,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257841',4908302,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257841',4908303,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257841',4908304,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257841',4908305,'2703','406',1468829.89,1472195.72,3365.83,2625347.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257841',4908306,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257842',4908307,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257842',4908308,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257842',4908309,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257842',4908310,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257842',4908311,'2698','405',608310.31,608310.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257842',4908312,'2699','405',997741.83,997741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257842',4908313,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257842',4908314,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257842',4908315,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257842',4908316,'2703','406',1472195.72,1475332.69,3136.97,2446836.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257842',4908317,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257843',4908318,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257843',4908319,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257843',4908320,'2696','405',932219.23,932219.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257843',4908321,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257843',4908322,'2698','405',608310.31,608962.90,652.59,120729.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257843',4908323,'2699','405',997741.83,998600.53,858.70,158859.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257843',4908324,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257843',4908325,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257843',4908326,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257843',4908327,'2703','406',1475332.69,1477983.67,2650.98,2067764.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257843',4908328,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257844',4908329,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257844',4908330,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257844',4908331,'2696','405',932219.23,934458.44,2239.21,414253.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257844',4908332,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257844',4908333,'2698','405',608962.90,610139.30,1176.40,217634.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257844',4908334,'2699','405',998600.53,999717.52,1116.99,206643.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257844',4908335,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257844',4908336,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257844',4908337,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257844',4908338,'2703','406',1477983.67,1479175.47,1191.80,929604.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257844',4908339,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257845',4908340,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257845',4908341,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257845',4908342,'2696','405',934458.44,936737.00,2278.56,421533.60,0.00,0.00,0.00,0.00,0.00),('5','172','911','257845',4908343,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257845',4908344,'2698','405',610139.30,610914.17,774.87,143350.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257845',4908345,'2699','405',999717.52,1001228.35,1510.83,279503.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257845',4908346,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257845',4908347,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257845',4908348,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257845',4908349,'2703','406',1479175.47,1479651.48,476.01,371287.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257845',4908350,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257846',4908351,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257846',4908352,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257846',4908353,'2696','405',936737.00,939338.66,2601.66,481307.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257846',4908354,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257846',4908355,'2698','405',610914.17,612671.79,1757.62,325159.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257846',4908356,'2699','405',1001228.35,1002067.42,839.07,155227.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257846',4908357,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257846',4908358,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257846',4908359,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257846',4908360,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257846',4908361,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257847',4908362,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257847',4908363,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257847',4908364,'2696','405',939338.66,942932.97,3594.31,664947.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','257847',4908365,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257847',4908366,'2698','405',612671.79,614134.90,1463.11,270675.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257847',4908367,'2699','405',1002067.42,1003336.61,1269.19,234800.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257847',4908368,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257847',4908369,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257847',4908370,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257847',4908371,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257847',4908372,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257848',4908373,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257848',4908374,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257848',4908375,'2696','405',942932.97,946311.34,3378.37,624998.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','257848',4908376,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257848',4908377,'2698','405',614134.90,616303.20,2168.30,401135.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257848',4908378,'2699','405',1003336.61,1004282.77,946.16,175039.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257848',4908379,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257848',4908380,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257848',4908381,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257848',4908382,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257848',4908383,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257849',4908384,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257849',4908385,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257849',4908386,'2696','405',946311.34,950154.85,3843.51,711049.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','257849',4908387,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257849',4908388,'2698','405',616303.20,618536.39,2233.19,413140.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257849',4908389,'2699','405',1004282.77,1005494.84,1212.07,224232.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257849',4908390,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257849',4908391,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257849',4908392,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257849',4908393,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257849',4908394,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257850',4908395,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257850',4908396,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257850',4908397,'2696','405',950154.85,953037.71,2882.86,533329.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257850',4908398,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257850',4908399,'2698','405',618536.39,620377.00,1840.61,340512.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257850',4908400,'2699','405',1005494.84,1007634.93,2140.09,395916.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257850',4908401,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257850',4908402,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257850',4908403,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257850',4908404,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257850',4908405,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257851',4908406,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257851',4908407,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257851',4908408,'2696','405',953037.71,954284.80,1247.09,230711.65,0.00,0.00,0.00,0.00,0.00),('5','172','911','257851',4908409,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257851',4908410,'2698','405',620377.00,623432.88,3055.88,565337.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257851',4908411,'2699','405',1007634.93,1010010.58,2375.65,439495.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257851',4908412,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257851',4908413,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257851',4908414,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257851',4908415,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257851',4908416,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257852',4908417,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257852',4908418,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257852',4908419,'2696','405',954284.80,957940.21,3655.41,676250.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257852',4908420,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257852',4908421,'2698','405',623432.88,625753.41,2320.53,429298.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257852',4908422,'2699','405',1010010.58,1011860.09,1849.51,342159.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257852',4908423,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257852',4908424,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257852',4908425,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257852',4908426,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257852',4908427,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257853',4908428,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257853',4908429,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257853',4908430,'2696','405',957940.21,960372.84,2432.63,450036.55,0.00,0.00,0.00,0.00,0.00),('5','172','911','257853',4908431,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257853',4908432,'2698','405',625753.41,627763.95,2010.54,371949.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257853',4908433,'2699','405',1011860.09,1014753.73,2893.64,535323.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257853',4908434,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257853',4908435,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257853',4908436,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257853',4908437,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257853',4908438,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257854',4908439,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257854',4908440,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257854',4908441,'2696','405',960372.84,964141.14,3768.30,697135.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','257854',4908442,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257854',4908443,'2698','405',627763.95,629651.67,1887.72,349228.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257854',4908444,'2699','405',1014753.73,1016090.78,1337.05,247354.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257854',4908445,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257854',4908446,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257854',4908447,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257854',4908448,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257854',4908449,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257855',4908450,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257855',4908451,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257855',4908452,'2696','405',964141.14,969526.05,5384.91,996208.35,0.00,0.00,0.00,0.00,0.00),('5','172','911','257855',4908453,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257855',4908454,'2698','405',629651.67,630934.80,1283.13,237379.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257855',4908455,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257855',4908456,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257855',4908457,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257855',4908458,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257855',4908459,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257855',4908460,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257856',4908461,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257856',4908462,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257856',4908463,'2696','405',969526.05,977253.53,7727.48,1429583.80,0.00,0.00,0.00,0.00,0.00),('5','172','911','257856',4908464,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257856',4908465,'2698','405',630934.80,630934.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257856',4908466,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257856',4908467,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257856',4908468,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257856',4908469,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257856',4908470,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257856',4908471,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257857',4908472,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257857',4908473,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257857',4908474,'2696','405',977253.53,977253.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257857',4908475,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257857',4908476,'2698','405',630934.80,630934.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257857',4908477,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257857',4908478,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257857',4908479,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257857',4908480,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257857',4908481,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257857',4908482,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257858',4908483,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257858',4908484,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257858',4908485,'2696','405',977253.53,977253.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257858',4908486,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257858',4908487,'2698','405',630934.80,630934.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257858',4908488,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257858',4908489,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257858',4908490,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257858',4908491,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257858',4908492,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257858',4908493,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257859',4908494,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257859',4908495,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257859',4908496,'2696','405',977253.53,977253.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257859',4908497,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257859',4908498,'2698','405',630934.80,630934.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257859',4908499,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257859',4908500,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257859',4908501,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257859',4908502,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257859',4908503,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257859',4908504,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257860',4908505,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257860',4908506,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257860',4908507,'2696','405',977253.53,977253.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257860',4908508,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257860',4908509,'2698','405',630934.80,630934.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257860',4908510,'2699','405',1016090.78,1016090.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257860',4908511,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257860',4908512,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257860',4908513,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257860',4908514,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257860',4908515,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257861',4908516,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257861',4908517,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257861',4908518,'2696','405',977253.53,979847.18,2593.65,479825.25,0.00,0.00,0.00,0.00,0.00),('5','172','911','257861',4908519,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257861',4908520,'2698','405',630934.80,632335.24,1400.44,259081.40,0.00,0.00,0.00,0.00,0.00),('5','172','912','257861',4908521,'2699','405',1016090.78,1018143.44,2052.66,379742.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257861',4908522,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257861',4908523,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257861',4908524,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257861',4908525,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257861',4908526,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257862',4908527,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257862',4908528,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257862',4908529,'2696','405',979847.18,982792.84,2945.66,544947.10,0.00,0.00,0.00,0.00,0.00),('5','172','911','257862',4908530,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257862',4908531,'2698','405',632335.24,634250.17,1914.93,354262.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257862',4908532,'2699','405',1018143.44,1019895.47,1752.03,324125.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257862',4908533,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257862',4908534,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257862',4908535,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257862',4908536,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257862',4908537,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257863',4908538,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257863',4908539,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257863',4908540,'2696','405',982792.84,985811.94,3019.10,558533.50,0.00,0.00,0.00,0.00,0.00),('5','172','911','257863',4908541,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257863',4908542,'2698','405',634250.17,634527.68,277.51,51339.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257863',4908543,'2699','405',1019895.47,1022748.41,2852.94,527793.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257863',4908544,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257863',4908545,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257863',4908546,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257863',4908547,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257863',4908548,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257864',4908549,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257864',4908550,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257864',4908551,'2696','405',985811.94,986541.96,730.02,135053.70,0.00,0.00,0.00,0.00,0.00),('5','172','911','257864',4908552,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257864',4908553,'2698','405',634527.68,638515.51,3987.83,737748.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257864',4908554,'2699','405',1022748.41,1027000.42,4252.01,786621.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257864',4908555,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257864',4908556,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257864',4908557,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257864',4908558,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257864',4908559,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257865',4908560,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257865',4908561,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257865',4908562,'2696','405',986541.96,986541.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257865',4908563,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257865',4908564,'2698','405',638515.51,642562.10,4046.59,748619.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257865',4908565,'2699','405',1027000.42,1030921.79,3921.37,725453.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257865',4908566,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257865',4908567,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257865',4908568,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257865',4908569,'2703','406',1479651.48,1479651.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257865',4908570,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257866',4908571,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257866',4908572,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257866',4908573,'2696','405',986541.96,990127.49,3585.53,663323.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257866',4908574,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257866',4908575,'2698','405',642562.10,645691.00,3128.90,578846.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257866',4908576,'2699','405',1030921.79,1033271.95,2350.16,434779.60,0.00,0.00,0.00,0.00,0.00),('5','172','912','257866',4908577,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257866',4908578,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257866',4908579,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257866',4908580,'2703','406',1479651.48,1480917.20,1265.72,987261.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257866',4908581,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257867',4908582,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257867',4908583,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257867',4908584,'2696','405',990127.49,990922.47,794.98,147071.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','257867',4908585,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257867',4908586,'2698','405',645691.00,650500.82,4809.82,889816.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257867',4908587,'2699','405',1033271.95,1037745.26,4473.31,827562.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257867',4908588,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257867',4908589,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257867',4908590,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257867',4908591,'2703','406',1480917.20,1482746.93,1829.73,1427189.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257867',4908592,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257868',4908593,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257868',4908594,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257868',4908595,'2696','405',990922.47,997515.45,6592.98,1219701.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','257868',4908596,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257868',4908597,'2698','405',650500.82,651956.87,1456.05,269369.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257868',4908598,'2699','405',1037745.26,1042471.08,4725.82,874276.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257868',4908599,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257868',4908600,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257868',4908601,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257868',4908602,'2703','406',1482746.93,1484925.75,2178.82,1699479.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257868',4908603,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257869',4908604,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257869',4908605,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257869',4908606,'2696','405',997515.45,1003352.63,5837.18,1079878.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','257869',4908607,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257869',4908608,'2698','405',651956.87,657753.18,5796.31,1072317.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257869',4908609,'2699','405',1042471.08,1042783.11,312.03,57725.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257869',4908610,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257869',4908611,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257869',4908612,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257869',4908613,'2703','406',1484925.75,1487950.16,3024.41,2359039.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257869',4908614,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257870',4908615,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257870',4908616,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257870',4908617,'2696','405',1003352.63,1008415.77,5063.14,936680.90,0.00,0.00,0.00,0.00,0.00),('5','172','911','257870',4908618,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257870',4908619,'2698','405',657753.18,659169.26,1416.08,261974.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257870',4908620,'2699','405',1042783.11,1046699.11,3916.00,724460.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257870',4908621,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257870',4908622,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257870',4908623,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257870',4908624,'2703','406',1487950.16,1490125.13,2174.97,1696476.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257870',4908625,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257871',4908626,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257871',4908627,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257871',4908628,'2696','405',1008415.77,1013813.54,5397.77,998587.45,0.00,0.00,0.00,0.00,0.00),('5','172','911','257871',4908629,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257871',4908630,'2698','405',659169.26,664065.28,4896.02,905763.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257871',4908631,'2699','405',1046699.11,1046699.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257871',4908632,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257871',4908633,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257871',4908634,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257871',4908635,'2703','406',1490125.13,1491360.15,1235.02,963315.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257871',4908636,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257872',4908637,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257872',4908638,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257872',4908639,'2696','405',1013813.54,1018216.94,4403.40,814629.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257872',4908640,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257872',4908641,'2698','405',664065.28,667065.16,2999.88,554977.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257872',4908642,'2699','405',1046699.11,1047744.74,1045.63,193441.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257872',4908643,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257872',4908644,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257872',4908645,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257872',4908646,'2703','406',1491360.15,1496267.30,4907.15,3827577.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257872',4908647,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257873',4908648,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257873',4908649,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257873',4908650,'2696','405',1018216.94,1022667.95,4451.01,823436.85,0.00,0.00,0.00,0.00,0.00),('5','172','911','257873',4908651,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257873',4908652,'2698','405',667065.16,670694.33,3629.17,671396.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257873',4908653,'2699','405',1047744.74,1049657.67,1912.93,353892.05,0.00,0.00,0.00,0.00,0.00),('5','172','912','257873',4908654,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257873',4908655,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257873',4908656,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257873',4908657,'2703','406',1496267.30,1500185.67,3918.37,3056328.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257873',4908658,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257874',4908659,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257874',4908660,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257874',4908661,'2696','405',1022667.95,1027291.88,4623.93,855427.05,0.00,0.00,0.00,0.00,0.00),('5','172','911','257874',4908662,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257874',4908663,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257874',4908664,'2699','405',1049657.67,1055717.84,6060.17,1121131.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257874',4908665,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257874',4908666,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257874',4908667,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257874',4908668,'2703','406',1500185.67,1502378.86,2193.19,1710688.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257874',4908669,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257875',4908670,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257875',4908671,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257875',4908672,'2696','405',1027291.88,1031565.06,4273.18,790538.30,0.00,0.00,0.00,0.00,0.00),('5','172','911','257875',4908673,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257875',4908674,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257875',4908675,'2699','405',1055717.84,1056917.79,1199.95,221990.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257875',4908676,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257875',4908677,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257875',4908678,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257875',4908679,'2703','406',1502378.86,1504770.82,2391.96,1865728.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257875',4908680,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257876',4908681,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257876',4908682,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257876',4908683,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257876',4908684,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257876',4908685,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257876',4908686,'2699','405',1056917.79,1056917.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257876',4908687,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257876',4908688,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257876',4908689,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257876',4908690,'2703','406',1504770.82,1507316.70,2545.88,1985786.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257876',4908691,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257877',4908692,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257877',4908693,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257877',4908694,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257877',4908695,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257877',4908696,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257877',4908697,'2699','405',1056917.79,1056917.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257877',4908698,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257877',4908699,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257877',4908700,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257877',4908701,'2703','406',1507316.70,1509176.32,1859.62,1450503.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257877',4908702,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257878',4908703,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257878',4908704,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257878',4908705,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257878',4908706,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257878',4908707,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257878',4908708,'2699','405',1056917.79,1056917.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257878',4908709,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257878',4908710,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257878',4908711,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257878',4908712,'2703','406',1509176.32,1512343.32,3167.00,2470260.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257878',4908713,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257879',4908714,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257879',4908715,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257879',4908716,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257879',4908717,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257879',4908718,'2698','405',670694.33,670694.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257879',4908719,'2699','405',1056917.79,1056917.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257879',4908720,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257879',4908721,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257879',4908722,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257879',4908723,'2703','406',1512343.32,1516057.55,3714.23,2897099.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257879',4908724,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257880',4908725,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257880',4908726,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257880',4908727,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257880',4908728,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257880',4908729,'2698','405',670694.33,672037.05,1342.72,248403.20,0.00,0.00,0.00,0.00,0.00),('5','172','912','257880',4908730,'2699','405',1056917.79,1058477.19,1559.40,288489.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257880',4908731,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257880',4908732,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257880',4908733,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257880',4908734,'2703','406',1516057.55,1519436.49,3378.94,2635573.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257880',4908735,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257881',4908736,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257881',4908737,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257881',4908738,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257881',4908739,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257881',4908740,'2698','405',672037.05,676152.82,4115.77,761417.45,0.00,0.00,0.00,0.00,0.00),('5','172','912','257881',4908741,'2699','405',1058477.19,1061959.53,3482.34,644232.90,0.00,0.00,0.00,0.00,0.00),('5','172','912','257881',4908742,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257881',4908743,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257881',4908744,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257881',4908745,'2703','406',1519436.49,1519880.92,444.43,346655.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257881',4908746,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257882',4908747,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257882',4908748,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257882',4908749,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257882',4908750,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257882',4908751,'2698','405',676152.82,680141.51,3988.69,737907.65,0.00,0.00,0.00,0.00,0.00),('5','172','912','257882',4908752,'2699','405',1061959.53,1067011.44,5051.91,934603.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257882',4908753,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257882',4908754,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257882',4908755,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257882',4908756,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257882',4908757,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257883',4908758,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257883',4908759,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257883',4908760,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257883',4908761,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257883',4908762,'2698','405',680141.51,683389.59,3248.08,600894.80,0.00,0.00,0.00,0.00,0.00),('5','172','912','257883',4908763,'2699','405',1067011.44,1070186.14,3174.70,587319.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257883',4908764,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257883',4908765,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257883',4908766,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257883',4908767,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257883',4908768,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257884',4908769,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257884',4908770,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257884',4908771,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257884',4908772,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257884',4908773,'2698','405',683389.59,685585.18,2195.59,406184.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257884',4908774,'2699','405',1070186.14,1072047.32,1861.18,344318.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257884',4908775,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257884',4908776,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257884',4908777,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257884',4908778,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257884',4908779,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257885',4908780,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257885',4908781,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257885',4908782,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257885',4908783,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257885',4908784,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257885',4908785,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257885',4908786,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257885',4908787,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257885',4908788,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257885',4908789,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257885',4908790,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257886',4908791,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257886',4908792,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257886',4908793,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257886',4908794,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257886',4908795,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257886',4908796,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257886',4908797,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257886',4908798,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257886',4908799,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257886',4908800,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257886',4908801,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257887',4908802,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257887',4908803,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257887',4908804,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257887',4908805,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257887',4908806,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257887',4908807,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257887',4908808,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257887',4908809,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257887',4908810,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257887',4908811,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257887',4908812,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257888',4908813,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257888',4908814,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257888',4908815,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257888',4908816,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257888',4908817,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257888',4908818,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257888',4908819,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257888',4908820,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257888',4908821,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257888',4908822,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257888',4908823,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257889',4908824,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257889',4908825,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257889',4908826,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257889',4908827,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257889',4908828,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257889',4908829,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257889',4908830,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257889',4908831,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257889',4908832,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257889',4908833,'2703','406',1519880.92,1519880.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257889',4908834,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257890',4908835,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257890',4908836,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257890',4908837,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257890',4908838,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257890',4908839,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257890',4908840,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257890',4908841,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257890',4908842,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257890',4908843,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257890',4908844,'2703','406',1519880.92,1520070.51,189.59,147880.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257890',4908845,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257891',4908846,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257891',4908847,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257891',4908848,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257891',4908849,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257891',4908850,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257891',4908851,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257891',4908852,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257891',4908853,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257891',4908854,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257891',4908855,'2703','406',1520070.51,1520070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257891',4908856,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257892',4908857,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257892',4908858,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257892',4908859,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257892',4908860,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257892',4908861,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257892',4908862,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257892',4908863,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257892',4908864,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257892',4908865,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257892',4908866,'2703','406',1520070.51,1520070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257892',4908867,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257893',4908868,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257893',4908869,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257893',4908870,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257893',4908871,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257893',4908872,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257893',4908873,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257893',4908874,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257893',4908875,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257893',4908876,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257893',4908877,'2703','406',1520070.51,1520070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257893',4908878,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257894',4908879,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257894',4908880,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257894',4908881,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257894',4908882,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257894',4908883,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257894',4908884,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257894',4908885,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257894',4908886,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257894',4908887,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257894',4908888,'2703','406',1520070.51,1520070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257894',4908889,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257895',4908890,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257895',4908891,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257895',4908892,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257895',4908893,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257895',4908894,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257895',4908895,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257895',4908896,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257895',4908897,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257895',4908898,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257895',4908899,'2703','406',1520070.51,1520070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257895',4908900,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257896',4908901,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257896',4908902,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257896',4908903,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257896',4908904,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257896',4908905,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257896',4908906,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257896',4908907,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257896',4908908,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257896',4908909,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257896',4908910,'2703','406',1520070.51,1520958.96,888.45,692991.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257896',4908911,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257897',4908912,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257897',4908913,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257897',4908914,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257897',4908915,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257897',4908916,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257897',4908917,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257897',4908918,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257897',4908919,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257897',4908920,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257897',4908921,'2703','406',1520958.96,1522337.71,1378.75,1075425.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257897',4908922,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257898',4908923,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257898',4908924,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257898',4908925,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257898',4908926,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257898',4908927,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257898',4908928,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257898',4908929,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257898',4908930,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257898',4908931,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257898',4908932,'2703','406',1522337.71,1523442.71,1105.00,861900.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257898',4908933,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257899',4908934,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257899',4908935,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257899',4908936,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257899',4908937,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257899',4908938,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257899',4908939,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257899',4908940,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257899',4908941,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257899',4908942,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257899',4908943,'2703','406',1523442.71,1526541.61,3098.90,2417142.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257899',4908944,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257900',4908945,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257900',4908946,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257900',4908947,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257900',4908948,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257900',4908949,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257900',4908950,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257900',4908951,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257900',4908952,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257900',4908953,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257900',4908954,'2703','406',1526541.61,1528896.97,2355.36,1837180.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257900',4908955,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257901',4908956,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257901',4908957,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257901',4908958,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257901',4908959,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257901',4908960,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257901',4908961,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257901',4908962,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257901',4908963,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257901',4908964,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257901',4908965,'2703','406',1528896.97,1531330.69,2433.72,1898301.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257901',4908966,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257902',4908967,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257902',4908968,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257902',4908969,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257902',4908970,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257902',4908971,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257902',4908972,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257902',4908973,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257902',4908974,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257902',4908975,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257902',4908976,'2703','406',1531330.69,1533255.14,1924.45,1501071.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257902',4908977,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257903',4908978,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257903',4908979,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257903',4908980,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257903',4908981,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257903',4908982,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257903',4908983,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257903',4908984,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257903',4908985,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257903',4908986,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257903',4908987,'2703','406',1533255.14,1533255.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257903',4908988,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257904',4908989,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257904',4908990,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257904',4908991,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257904',4908992,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257904',4908993,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257904',4908994,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257904',4908995,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257904',4908996,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257904',4908997,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257904',4908998,'2703','406',1533255.14,1534443.29,1188.15,1033690.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257904',4908999,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257905',4909000,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257905',4909001,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257905',4909002,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257905',4909003,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257905',4909004,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257905',4909005,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257905',4909006,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257905',4909007,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257905',4909008,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257905',4909009,'2703','406',1534443.29,1534822.35,379.06,329782.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257905',4909010,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257906',4909011,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257906',4909012,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257906',4909013,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257906',4909014,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257906',4909015,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257906',4909016,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257906',4909017,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257906',4909018,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257906',4909019,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257906',4909020,'2703','406',1534822.35,1535293.31,470.96,409735.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257906',4909021,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257907',4909022,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257907',4909023,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257907',4909024,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257907',4909025,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257907',4909026,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257907',4909027,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257907',4909028,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257907',4909029,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257907',4909030,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257907',4909031,'2703','406',1535293.31,1536525.91,1232.60,1072362.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257907',4909032,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257908',4909033,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257908',4909034,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257908',4909035,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257908',4909036,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257908',4909037,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257908',4909038,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257908',4909039,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257908',4909040,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257908',4909041,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257908',4909042,'2703','406',1536525.91,1537206.30,680.39,591939.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257908',4909043,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257909',4909044,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257909',4909045,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257909',4909046,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257909',4909047,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257909',4909048,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257909',4909049,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257909',4909050,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257909',4909051,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257909',4909052,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257909',4909053,'2703','406',1537206.30,1538440.42,1234.12,1024319.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257909',4909054,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257910',4909055,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257910',4909056,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257910',4909057,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257910',4909058,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257910',4909059,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257910',4909060,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257910',4909061,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257910',4909062,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257910',4909063,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257910',4909064,'2703','406',1538440.42,1540869.91,2429.49,2016476.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257910',4909065,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257911',4909066,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257911',4909067,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257911',4909068,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257911',4909069,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257911',4909070,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257911',4909071,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257911',4909072,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257911',4909073,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257911',4909074,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257911',4909075,'2703','406',1540869.91,1543168.04,2298.13,1907447.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257911',4909076,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257912',4909077,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257912',4909078,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257912',4909079,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257912',4909080,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257912',4909081,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257912',4909082,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257912',4909083,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257912',4909084,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257912',4909085,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257912',4909086,'2703','406',1543168.04,1545231.03,2062.99,1712281.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257912',4909087,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257913',4909088,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257913',4909089,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257913',4909090,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257913',4909091,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257913',4909092,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257913',4909093,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257913',4909094,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257913',4909095,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257913',4909096,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257913',4909097,'2703','406',1545231.03,1549039.17,3808.14,3160756.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257913',4909098,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257914',4909099,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257914',4909100,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257914',4909101,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257914',4909102,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257914',4909103,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257914',4909104,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257914',4909105,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257914',4909106,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257914',4909107,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257914',4909108,'2703','406',1549039.17,1551908.83,2869.66,2381817.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257914',4909109,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257915',4909110,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257915',4909111,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257915',4909112,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257915',4909113,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257915',4909114,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257915',4909115,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257915',4909116,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257915',4909117,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257915',4909118,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257915',4909119,'2703','406',1551908.83,1555879.10,3970.27,3295324.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257915',4909120,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257916',4909121,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257916',4909122,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257916',4909123,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257916',4909124,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257916',4909125,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257916',4909126,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257916',4909127,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257916',4909128,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257916',4909129,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257916',4909130,'2703','406',1555879.10,1558839.22,2960.12,2456899.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257916',4909131,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257917',4909132,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257917',4909133,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257917',4909134,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257917',4909135,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257917',4909136,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257917',4909137,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257917',4909138,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257917',4909139,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257917',4909140,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257917',4909141,'2703','406',1558839.22,1560180.42,1341.20,1113196.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257917',4909142,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257918',4909143,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257918',4909144,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257918',4909145,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257918',4909146,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257918',4909147,'2698','405',685585.18,685585.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257918',4909148,'2699','405',1072047.32,1072047.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257918',4909149,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257918',4909150,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257918',4909151,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257918',4909152,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257918',4909153,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257919',4909154,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257919',4909155,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257919',4909156,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257919',4909157,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257919',4909158,'2698','405',685585.18,689192.83,3607.65,667415.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257919',4909159,'2699','405',1072047.32,1079743.83,7696.51,1423854.35,0.00,0.00,0.00,0.00,0.00),('5','172','912','257919',4909160,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257919',4909161,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257919',4909162,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257919',4909163,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257919',4909164,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257920',4909165,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257920',4909166,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257920',4909167,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257920',4909168,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257920',4909169,'2698','405',689192.83,697132.82,7939.99,1468898.15,0.00,0.00,0.00,0.00,0.00),('5','172','912','257920',4909170,'2699','405',1079743.83,1088053.81,8309.98,1537346.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257920',4909171,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257920',4909172,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257920',4909173,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257920',4909174,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257920',4909175,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257921',4909176,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257921',4909177,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257921',4909178,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257921',4909179,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257921',4909180,'2698','405',697132.82,697874.63,741.81,137234.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257921',4909181,'2699','405',1088053.81,1099795.79,11741.98,2172266.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257921',4909182,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257921',4909183,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257921',4909184,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257921',4909185,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257921',4909186,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257922',4909187,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257922',4909188,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257922',4909189,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257922',4909190,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257922',4909191,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257922',4909192,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257922',4909193,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257922',4909194,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257922',4909195,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257922',4909196,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257922',4909197,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257923',4909198,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257923',4909199,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257923',4909200,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257923',4909201,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257923',4909202,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257923',4909203,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257923',4909204,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257923',4909205,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257923',4909206,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257923',4909207,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257923',4909208,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257924',4909209,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257924',4909210,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257924',4909211,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257924',4909212,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257924',4909213,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257924',4909214,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257924',4909215,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257924',4909216,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257924',4909217,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257924',4909218,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257924',4909219,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257925',4909220,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257925',4909221,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257925',4909222,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257925',4909223,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257925',4909224,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257925',4909225,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257925',4909226,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257925',4909227,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257925',4909228,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257925',4909229,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257925',4909230,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257926',4909231,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257926',4909232,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257926',4909233,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257926',4909234,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257926',4909235,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257926',4909236,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257926',4909237,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257926',4909238,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257926',4909239,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257926',4909240,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257926',4909241,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257927',4909242,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257927',4909243,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257927',4909244,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257927',4909245,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257927',4909246,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257927',4909247,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257927',4909248,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257927',4909249,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257927',4909250,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257927',4909251,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257927',4909252,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257928',4909253,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257928',4909254,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257928',4909255,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257928',4909256,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257928',4909257,'2698','405',697874.63,697874.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257928',4909258,'2699','405',1099795.79,1099795.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257928',4909259,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257928',4909260,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257928',4909261,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257928',4909262,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257928',4909263,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257929',4909264,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257929',4909265,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257929',4909266,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257929',4909267,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257929',4909268,'2698','405',697874.63,699815.06,1940.43,358979.55,0.00,0.00,0.00,0.00,0.00),('5','172','912','257929',4909269,'2699','405',1099795.79,1114857.20,15061.41,2786360.85,0.00,0.00,0.00,0.00,0.00),('5','172','912','257929',4909270,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257929',4909271,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257929',4909272,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257929',4909273,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257929',4909274,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257930',4909275,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257930',4909276,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257930',4909277,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257930',4909278,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257930',4909279,'2698','405',699815.06,699815.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257930',4909280,'2699','405',1114857.20,1128085.87,13228.67,2447303.95,0.00,0.00,0.00,0.00,0.00),('5','172','912','257930',4909281,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257930',4909282,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257930',4909283,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257930',4909284,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257930',4909285,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257931',4909286,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257931',4909287,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257931',4909288,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257931',4909289,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257931',4909290,'2698','405',699815.06,703700.06,3885.00,718725.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257931',4909291,'2699','405',1128085.87,1133960.93,5875.06,1086886.10,0.00,0.00,0.00,0.00,0.00),('5','172','912','257931',4909292,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257931',4909293,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257931',4909294,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257931',4909295,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257931',4909296,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257932',4909297,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257932',4909298,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257932',4909299,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257932',4909300,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257932',4909301,'2698','405',703700.06,703928.61,228.55,42281.75,0.00,0.00,0.00,0.00,0.00),('5','172','912','257932',4909302,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257932',4909303,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257932',4909304,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257932',4909305,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257932',4909306,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257932',4909307,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257933',4909308,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257933',4909309,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257933',4909310,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257933',4909311,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257933',4909312,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257933',4909313,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257933',4909314,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257933',4909315,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257933',4909316,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257933',4909317,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257933',4909318,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257934',4909319,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257934',4909320,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257934',4909321,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257934',4909322,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257934',4909323,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257934',4909324,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257934',4909325,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257934',4909326,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257934',4909327,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257934',4909328,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257934',4909329,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257935',4909330,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257935',4909331,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257935',4909332,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257935',4909333,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257935',4909334,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257935',4909335,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257935',4909336,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257935',4909337,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257935',4909338,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257935',4909339,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257935',4909340,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257936',4909341,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257936',4909342,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257936',4909343,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257936',4909344,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257936',4909345,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257936',4909346,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257936',4909347,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257936',4909348,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257936',4909349,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257936',4909350,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257936',4909351,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257937',4909352,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257937',4909353,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257937',4909354,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257937',4909355,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257937',4909356,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257937',4909357,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257937',4909358,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257937',4909359,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257937',4909360,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257937',4909361,'2703','406',1560180.42,1560180.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257937',4909362,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257938',4909363,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257938',4909364,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257938',4909365,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257938',4909366,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257938',4909367,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257938',4909368,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257938',4909369,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257938',4909370,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257938',4909371,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257938',4909372,'2703','406',1560180.42,1561436.23,1255.81,1042322.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257938',4909373,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257939',4909374,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257939',4909375,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257939',4909376,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257939',4909377,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257939',4909378,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257939',4909379,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257939',4909380,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257939',4909381,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257939',4909382,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257939',4909383,'2703','406',1561436.23,1562572.63,1136.40,943212.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257939',4909384,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257940',4909385,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257940',4909386,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257940',4909387,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257940',4909388,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257940',4909389,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257940',4909390,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257940',4909391,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257940',4909392,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257940',4909393,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257940',4909394,'2703','406',1562572.63,1564351.53,1778.90,1476487.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257940',4909395,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257941',4909396,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257941',4909397,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257941',4909398,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257941',4909399,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257941',4909400,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257941',4909401,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257941',4909402,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257941',4909403,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257941',4909404,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257941',4909405,'2703','406',1564351.53,1567589.18,3237.65,2687249.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257941',4909406,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257942',4909407,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257942',4909408,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257942',4909409,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257942',4909410,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257942',4909411,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257942',4909412,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257942',4909413,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257942',4909414,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257942',4909415,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257942',4909416,'2703','406',1567589.18,1571123.91,3534.73,2933825.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257942',4909417,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257943',4909418,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257943',4909419,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257943',4909420,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257943',4909421,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257943',4909422,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257943',4909423,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257943',4909424,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257943',4909425,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257943',4909426,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257943',4909427,'2703','406',1571123.91,1573075.75,1951.84,1620027.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257943',4909428,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257944',4909429,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257944',4909430,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257944',4909431,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257944',4909432,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257944',4909433,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257944',4909434,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257944',4909435,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257944',4909436,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257944',4909437,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257944',4909438,'2703','406',1573075.75,1575089.77,2014.02,1671636.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257944',4909439,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257945',4909440,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257945',4909441,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257945',4909442,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257945',4909443,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257945',4909444,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257945',4909445,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257945',4909446,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257945',4909447,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257945',4909448,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257945',4909449,'2703','406',1575089.77,1579621.68,4531.91,3761485.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257945',4909450,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257946',4909451,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257946',4909452,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257946',4909453,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257946',4909454,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257946',4909455,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257946',4909456,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257946',4909457,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257946',4909458,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257946',4909459,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257946',4909460,'2703','406',1579621.68,1586472.50,6850.82,5686180.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257946',4909461,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257947',4909462,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257947',4909463,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257947',4909464,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257947',4909465,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257947',4909466,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257947',4909467,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257947',4909468,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257947',4909469,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257947',4909470,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257947',4909471,'2703','406',1586472.50,1590717.88,4245.38,3523665.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257947',4909472,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257948',4909473,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257948',4909474,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257948',4909475,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257948',4909476,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257948',4909477,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257948',4909478,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257948',4909479,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257948',4909480,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257948',4909481,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257948',4909482,'2703','406',1590717.88,1594043.49,3325.61,2760256.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257948',4909483,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257949',4909484,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257949',4909485,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257949',4909486,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257949',4909487,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257949',4909488,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257949',4909489,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257949',4909490,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257949',4909491,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257949',4909492,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257949',4909493,'2703','406',1594043.49,1597153.20,3109.71,2581059.30,0.00,0.00,0.00,0.00,0.00),('5','172','915','257949',4909494,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257950',4909495,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257950',4909496,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257950',4909497,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257950',4909498,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257950',4909499,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257950',4909500,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257950',4909501,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257950',4909502,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257950',4909503,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257950',4909504,'2703','406',1597153.20,1600802.35,3649.15,3028794.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257950',4909505,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257951',4909506,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257951',4909507,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257951',4909508,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257951',4909509,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257951',4909510,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257951',4909511,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257951',4909512,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257951',4909513,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257951',4909514,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257951',4909515,'2703','406',1600802.35,1604220.18,3417.83,2836798.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257951',4909516,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257952',4909517,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257952',4909518,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257952',4909519,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257952',4909520,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257952',4909521,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257952',4909522,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257952',4909523,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257952',4909524,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257952',4909525,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257952',4909526,'2703','406',1604220.18,1607488.95,3268.77,2713079.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257952',4909527,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257953',4909528,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257953',4909529,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257953',4909530,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257953',4909531,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257953',4909532,'2698','405',703928.61,703928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257953',4909533,'2699','405',1133960.93,1133960.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257953',4909534,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257953',4909535,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257953',4909536,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257953',4909537,'2703','406',1607488.95,1608915.49,1426.54,1184028.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257953',4909538,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257954',4909539,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257954',4909540,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257954',4909541,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257954',4909542,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257954',4909543,'2698','405',703928.61,708836.46,4907.85,907952.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257954',4909544,'2699','405',1133960.93,1140495.71,6534.78,1208934.30,0.00,0.00,0.00,0.00,0.00),('5','172','912','257954',4909545,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257954',4909546,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257954',4909547,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257954',4909548,'2703','406',1608915.49,1613204.41,4288.92,3559803.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257954',4909549,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257955',4909550,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257955',4909551,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257955',4909552,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257955',4909553,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257955',4909554,'2698','405',708836.46,708836.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257955',4909555,'2699','405',1140495.71,1150097.93,9602.22,1776410.70,0.00,0.00,0.00,0.00,0.00),('5','172','912','257955',4909556,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257955',4909557,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257955',4909558,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257955',4909559,'2703','406',1613204.41,1618625.86,5421.45,4499803.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257955',4909560,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257956',4909561,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257956',4909562,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257956',4909563,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257956',4909564,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257956',4909565,'2698','405',708836.46,714158.76,5322.30,984625.50,0.00,0.00,0.00,0.00,0.00),('5','172','912','257956',4909566,'2699','405',1150097.93,1163931.98,13834.05,2559299.25,0.00,0.00,0.00,0.00,0.00),('5','172','912','257956',4909567,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257956',4909568,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257956',4909569,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257956',4909570,'2703','406',1618625.86,1621431.59,2805.73,2328755.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257956',4909571,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257957',4909572,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257957',4909573,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257957',4909574,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257957',4909575,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257957',4909576,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257957',4909577,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257957',4909578,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257957',4909579,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257957',4909580,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257957',4909581,'2703','406',1621431.59,1623600.76,2169.17,1800411.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257957',4909582,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257958',4909583,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257958',4909584,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257958',4909585,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257958',4909586,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257958',4909587,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257958',4909588,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257958',4909589,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257958',4909590,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257958',4909591,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257958',4909592,'2703','406',1623600.76,1625837.00,2236.24,1856079.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257958',4909593,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257959',4909594,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257959',4909595,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257959',4909596,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257959',4909597,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257959',4909598,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257959',4909599,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257959',4909600,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257959',4909601,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257959',4909602,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257959',4909603,'2703','406',1625837.00,1626987.36,1150.36,954798.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257959',4909604,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257960',4909605,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257960',4909606,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257960',4909607,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257960',4909608,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257960',4909609,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257960',4909610,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257960',4909611,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257960',4909612,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257960',4909613,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257960',4909614,'2703','406',1626987.36,1629393.42,2406.06,1997029.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257960',4909615,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257961',4909616,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257961',4909617,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257961',4909618,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257961',4909619,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257961',4909620,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257961',4909621,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257961',4909622,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257961',4909623,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257961',4909624,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257961',4909625,'2703','406',1629393.42,1631637.08,2243.66,1862237.80,0.00,0.00,0.00,0.00,0.00),('5','172','915','257961',4909626,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257962',4909627,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257962',4909628,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257962',4909629,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257962',4909630,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257962',4909631,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257962',4909632,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257962',4909633,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257962',4909634,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257962',4909635,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257962',4909636,'2703','406',1631637.08,1633731.71,2094.63,1738542.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257962',4909637,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257963',4909638,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257963',4909639,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257963',4909640,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257963',4909641,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257963',4909642,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257963',4909643,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257963',4909644,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257963',4909645,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257963',4909646,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257963',4909647,'2703','406',1633731.71,1636046.64,2314.93,1921391.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257963',4909648,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257964',4909649,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257964',4909650,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257964',4909651,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257964',4909652,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257964',4909653,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257964',4909654,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257964',4909655,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257964',4909656,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257964',4909657,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257964',4909658,'2703','406',1636046.64,1636647.11,600.47,498390.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257964',4909659,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257965',4909660,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257965',4909661,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257965',4909662,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257965',4909663,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257965',4909664,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257965',4909665,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257965',4909666,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257965',4909667,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257965',4909668,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257965',4909669,'2703','406',1636647.11,1636647.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257965',4909670,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257966',4909671,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257966',4909672,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257966',4909673,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257966',4909674,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257966',4909675,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257966',4909676,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257966',4909677,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257966',4909678,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257966',4909679,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257966',4909680,'2703','406',1636647.11,1636647.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257966',4909681,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257967',4909682,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257967',4909683,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257967',4909684,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257967',4909685,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257967',4909686,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257967',4909687,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257967',4909688,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257967',4909689,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257967',4909690,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257967',4909691,'2703','406',1636647.11,1637676.10,1028.99,854061.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257967',4909692,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257968',4909693,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257968',4909694,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257968',4909695,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257968',4909696,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257968',4909697,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257968',4909698,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257968',4909699,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257968',4909700,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257968',4909701,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257968',4909702,'2703','406',1637676.10,1640017.35,2341.25,1943237.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257968',4909703,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257969',4909704,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257969',4909705,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257969',4909706,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257969',4909707,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257969',4909708,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257969',4909709,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257969',4909710,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257969',4909711,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257969',4909712,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257969',4909713,'2703','406',1640017.35,1641635.58,1618.23,1343130.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257969',4909714,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257970',4909715,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257970',4909716,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257970',4909717,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257970',4909718,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257970',4909719,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257970',4909720,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257970',4909721,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257970',4909722,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257970',4909723,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257970',4909724,'2703','406',1641635.58,1644258.97,2623.39,2177413.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257970',4909725,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257971',4909726,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257971',4909727,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257971',4909728,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257971',4909729,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257971',4909730,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257971',4909731,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257971',4909732,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257971',4909733,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257971',4909734,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257971',4909735,'2703','406',1644258.97,1648744.79,4485.82,3723230.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257971',4909736,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257972',4909737,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257972',4909738,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257972',4909739,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257972',4909740,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257972',4909741,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257972',4909742,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257972',4909743,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257972',4909744,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257972',4909745,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257972',4909746,'2703','406',1648744.79,1649895.13,1150.34,954782.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257972',4909747,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257973',4909748,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257973',4909749,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257973',4909750,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257973',4909751,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257973',4909752,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257973',4909753,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257973',4909754,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257973',4909755,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257973',4909756,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257973',4909757,'2703','406',1649895.13,1651085.01,1189.88,987600.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257973',4909758,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257974',4909759,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257974',4909760,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257974',4909761,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257974',4909762,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257974',4909763,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257974',4909764,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257974',4909765,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257974',4909766,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257974',4909767,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257974',4909768,'2703','406',1651085.01,1653804.89,2719.88,2257500.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257974',4909769,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257975',4909770,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257975',4909771,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257975',4909772,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257975',4909773,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257975',4909774,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257975',4909775,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257975',4909776,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257975',4909777,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257975',4909778,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257975',4909779,'2703','406',1653804.89,1655980.34,2175.45,1805623.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257975',4909780,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257976',4909781,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257976',4909782,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257976',4909783,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257976',4909784,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257976',4909785,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257976',4909786,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257976',4909787,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257976',4909788,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257976',4909789,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257976',4909790,'2703','406',1655980.34,1657332.07,1351.73,1121935.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257976',4909791,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257977',4909792,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257977',4909793,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257977',4909794,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257977',4909795,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257977',4909796,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257977',4909797,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257977',4909798,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257977',4909799,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257977',4909800,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257977',4909801,'2703','406',1657332.07,1658362.04,1029.97,854875.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257977',4909802,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257978',4909803,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257978',4909804,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257978',4909805,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257978',4909806,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257978',4909807,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257978',4909808,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257978',4909809,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257978',4909810,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257978',4909811,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257978',4909812,'2703','406',1658362.04,1659409.76,1047.72,869607.60,0.00,0.00,0.00,0.00,0.00),('5','172','915','257978',4909813,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257979',4909814,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257979',4909815,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257979',4909816,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257979',4909817,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257979',4909818,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257979',4909819,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257979',4909820,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257979',4909821,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257979',4909822,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257979',4909823,'2703','406',1659409.76,1660687.75,1277.99,1060731.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257979',4909824,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257980',4909825,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257980',4909826,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257980',4909827,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257980',4909828,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257980',4909829,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257980',4909830,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257980',4909831,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257980',4909832,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257980',4909833,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257980',4909834,'2703','406',1660687.75,1661729.93,1042.18,865009.40,0.00,0.00,0.00,0.00,0.00),('5','172','915','257980',4909835,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257981',4909836,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257981',4909837,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257981',4909838,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257981',4909839,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257981',4909840,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257981',4909841,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257981',4909842,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257981',4909843,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257981',4909844,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257981',4909845,'2703','406',1661729.93,1664769.48,3039.55,2522826.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257981',4909846,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257982',4909847,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257982',4909848,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257982',4909849,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257982',4909850,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257982',4909851,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257982',4909852,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257982',4909853,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257982',4909854,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257982',4909855,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257982',4909856,'2703','406',1664769.48,1666631.63,1862.15,1545584.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257982',4909857,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257983',4909858,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257983',4909859,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257983',4909860,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257983',4909861,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257983',4909862,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257983',4909863,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257983',4909864,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257983',4909865,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257983',4909866,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257983',4909867,'2703','406',1666631.63,1669639.86,3008.23,2496830.90,0.00,0.00,0.00,0.00,0.00),('5','172','915','257983',4909868,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257984',4909869,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257984',4909870,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257984',4909871,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257984',4909872,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257984',4909873,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257984',4909874,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257984',4909875,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257984',4909876,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257984',4909877,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257984',4909878,'2703','406',1669639.86,1673263.60,3623.74,3007704.20,0.00,0.00,0.00,0.00,0.00),('5','172','915','257984',4909879,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257985',4909880,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257985',4909881,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257985',4909882,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257985',4909883,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257985',4909884,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257985',4909885,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257985',4909886,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257985',4909887,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257985',4909888,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257985',4909889,'2703','406',1673263.60,1674494.10,1230.50,1021315.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257985',4909890,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257986',4909891,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257986',4909892,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257986',4909893,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257986',4909894,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257986',4909895,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257986',4909896,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257986',4909897,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257986',4909898,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257986',4909899,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257986',4909900,'2703','406',1674494.10,1675946.95,1452.85,1205865.50,0.00,0.00,0.00,0.00,0.00),('5','172','915','257986',4909901,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257987',4909902,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257987',4909903,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257987',4909904,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257987',4909905,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257987',4909906,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257987',4909907,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257987',4909908,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257987',4909909,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257987',4909910,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257987',4909911,'2703','406',1675946.95,1678101.32,2154.37,1788127.10,0.00,0.00,0.00,0.00,0.00),('5','172','915','257987',4909912,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257988',4909913,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257988',4909914,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257988',4909915,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257988',4909916,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257988',4909917,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257988',4909918,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257988',4909919,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257988',4909920,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257988',4909921,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257988',4909922,'2703','406',1678101.32,1679711.92,1610.60,1336798.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257988',4909923,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257989',4909924,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257989',4909925,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257989',4909926,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257989',4909927,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257989',4909928,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257989',4909929,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257989',4909930,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257989',4909931,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257989',4909932,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257989',4909933,'2703','406',1679711.92,1681022.51,1310.59,1087789.70,0.00,0.00,0.00,0.00,0.00),('5','172','915','257989',4909934,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257990',4909935,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257990',4909936,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257990',4909937,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257990',4909938,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257990',4909939,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257990',4909940,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257990',4909941,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257990',4909942,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257990',4909943,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257990',4909944,'2703','406',1681022.51,1681022.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257990',4909945,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257991',4909946,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257991',4909947,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257991',4909948,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257991',4909949,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257991',4909950,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257991',4909951,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257991',4909952,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257991',4909953,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257991',4909954,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257991',4909955,'2703','406',1681022.51,1681022.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257991',4909956,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257992',4909957,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257992',4909958,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257992',4909959,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257992',4909960,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257992',4909961,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257992',4909962,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257992',4909963,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257992',4909964,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257992',4909965,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257992',4909966,'2703','406',1681022.51,1681022.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','915','257992',4909967,'2704','407',436321.61,436321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257993',4909968,'2694','405',520049.77,520049.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257993',4909969,'2695','405',880607.33,880607.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257993',4909970,'2696','405',1031565.06,1031565.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','911','257993',4909971,'2697','405',255998.04,255998.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257993',4909972,'2698','405',714158.76,714158.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257993',4909973,'2699','405',1163931.98,1163931.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257993',4909974,'2700','405',164619.43,164619.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','912','257993',4909975,'2701','405',498929.81,498929.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','913','257993',4909976,'2702','406',614847.57,614847.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','172','914','257993',4909977,'2703','406',1681022.51,1681